# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class UsecaseList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version):
        """
        Initialize the UsecaseList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.messaging.v1.usecase.UsecaseList
        :rtype: twilio.rest.messaging.v1.usecase.UsecaseList
        """
        super(UsecaseList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Services/Usecases'.format(**self._solution)

    def fetch(self):
        """
        Fetch the UsecaseInstance

        :returns: The fetched UsecaseInstance
        :rtype: twilio.rest.messaging.v1.usecase.UsecaseInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return UsecaseInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Messaging.V1.UsecaseList>'


class UsecasePage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the UsecasePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.messaging.v1.usecase.UsecasePage
        :rtype: twilio.rest.messaging.v1.usecase.UsecasePage
        """
        super(UsecasePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of UsecaseInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.messaging.v1.usecase.UsecaseInstance
        :rtype: twilio.rest.messaging.v1.usecase.UsecaseInstance
        """
        return UsecaseInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Messaging.V1.UsecasePage>'


class UsecaseInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, payload):
        """
        Initialize the UsecaseInstance

        :returns: twilio.rest.messaging.v1.usecase.UsecaseInstance
        :rtype: twilio.rest.messaging.v1.usecase.UsecaseInstance
        """
        super(UsecaseInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {'usecases': payload.get('usecases'), }

        # Context
        self._context = None
        self._solution = {}

    @property
    def usecases(self):
        """
        :returns: Human readable Messaging Service Use Case details
        :rtype: list[dict]
        """
        return self._properties['usecases']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Messaging.V1.UsecaseInstance>'
