# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessDecisionEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum for Access Decision."""

    ALLOWED = "Allowed"
    """Access allowed"""
    DENIED = "Denied"
    """Access denied"""


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class CategoryTypeEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Supported category types to be used with QueryParameter. Each type represents a different level
    of emissions data aggregation.
    """

    SUBSCRIPTION = "Subscription"
    """Emissions aggregated at the subscription level."""
    RESOURCE_GROUP = "ResourceGroup"
    """Emissions aggregated at the resource group level."""
    LOCATION = "Location"
    """Emissions aggregated at the location level."""
    RESOURCE = "Resource"
    """Emissions aggregated at the resource level."""
    RESOURCE_TYPE = "ResourceType"
    """Emissions aggregated at the resource type level."""


class EmissionScopeEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Supported carbon emission scopes to be used with QueryParameter, as defined by the GHG
    Protocol. At least one scope must be specified. The output will return a total of all specified
    scopes.
    """

    SCOPE1 = "Scope1"
    """Scope1 carbon emission"""
    SCOPE2 = "Scope2"
    """Scope2 carbon emission"""
    SCOPE3 = "Scope3"
    """Scope3 carbon emission"""


class OrderByColumnEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sorting is supported for columns in ItemDetailsReport. This object includes the column names
    that sorting is allowed for. Select one of these supported values.
    """

    ITEM_NAME = "ItemName"
    """The itemName filed in ItemDetailsReport result, see CarbonEmissionItemDetailData for more
    information."""
    LATEST_MONTH_EMISSIONS = "LatestMonthEmissions"
    """The latestMonthEmissions filed in ItemDetailsReport result, see CarbonEmissionItemDetailData
    for more information."""
    PREVIOUS_MONTH_EMISSIONS = "PreviousMonthEmissions"
    """The previousMonthEmissions filed in ItemDetailsReport result, see CarbonEmissionItemDetailData
    for more information."""
    MONTH_OVER_MONTH_EMISSIONS_CHANGE_RATIO = "MonthOverMonthEmissionsChangeRatio"
    """The monthOverMonthEmissionsChangeRatio filed in ItemDetailsReport result, see
    CarbonEmissionItemDetailData for more information."""
    MONTHLY_EMISSIONS_CHANGE_VALUE = "MonthlyEmissionsChangeValue"
    """The monthlyEmissionsChangeValue filed in ItemDetailsReport result, see
    CarbonEmissionItemDetailData for more information."""
    RESOURCE_GROUP = "ResourceGroup"
    """The resourceGroup filed in ResourceCarbonEmissionItemDetailData result, see
    ResourceCarbonEmissionItemDetailData for more information."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ReportTypeEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum for Report Type, specifying different report formats for carbon emissions data. Each
    report type returns different aggregations of carbon emissions across various categories, date
    range, emissions scope, and other parameters.
    """

    OVERALL_SUMMARY_REPORT = "OverallSummaryReport"
    """Overall summary report provides total carbon emissions for the specified date range and query
    parameters, as well as comparative values for a high-level overview. This report type can
    accept different values in the start and end fields within DateRange (e.g., start: 2024-03-01
    and end: 2024-06-01)."""
    MONTHLY_SUMMARY_REPORT = "MonthlySummaryReport"
    """MonthlySummaryReport provides carbon emissions data by month for the specified query
    parameters. This report type can accept different values in the start and end fields within
    DateRange (e.g., start: 2024-03-01 and end: 2024-06-01)."""
    TOP_ITEMS_SUMMARY_REPORT = "TopItemsSummaryReport"
    """TopItemsSummaryReport provides the N highest-emitting items for the specified query filters.
    This report returns data for a single month at a time, so it requires the same values for the
    start and end fields within DateRange. A maximum of N=10 items can be returned at a time."""
    TOP_ITEMS_MONTHLY_SUMMARY_REPORT = "TopItemsMonthlySummaryReport"
    """TopItemsMonthlyReport provides the N highest-emitting items by month for the specified query
    filter. Returns emissions data for the top N items by month within the given date range. A
    maximum of N=10 items can be returned at a time."""
    ITEM_DETAILS_REPORT = "ItemDetailsReport"
    """ItemDetailsReport provides a granular list of items based on the specified CategoryType (e.g.,
    Resource, ResourceGroup, ResourceType, Location, or Subscription) for the query filter. This
    report can be queried for only one month at a time, requiring the same values in the start and
    end fields within DateRange."""


class ResponseDataTypeEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The response data type of Carbon emission data."""

    OVERALL_SUMMARY_DATA = "OverallSummaryData"
    """The response data type for OverallSummaryReport"""
    MONTHLY_SUMMARY_DATA = "MonthlySummaryData"
    """The response data type for MonthlySummaryReport"""
    TOP_ITEMS_SUMMARY_DATA = "TopItemsSummaryData"
    """The response data type for TopItemsSummaryReport"""
    RESOURCE_TOP_ITEMS_SUMMARY_DATA = "ResourceTopItemsSummaryData"
    """The response data type for Resource's TopItemsSummaryReport"""
    RESOURCE_GROUP_TOP_ITEMS_SUMMARY_DATA = "ResourceGroupTopItemsSummaryData"
    """The response data type for ResourceGroup's TopItemsSummaryReport"""
    TOP_ITEMS_MONTHLY_SUMMARY_DATA = "TopItemsMonthlySummaryData"
    """The response data type for TopItemsMonthlySummaryReport"""
    RESOURCE_TOP_ITEMS_MONTHLY_SUMMARY_DATA = "ResourceTopItemsMonthlySummaryData"
    """The response data type for Resource's TopItemsMonthlySummaryReport"""
    RESOURCE_GROUP_TOP_ITEMS_MONTHLY_SUMMARY_DATA = "ResourceGroupTopItemsMonthlySummaryData"
    """The response data type for ResourceGroup's TopItemsMonthlySummaryReport"""
    ITEM_DETAILS_DATA = "ItemDetailsData"
    """The response data type for ItemDetailsReport"""
    RESOURCE_ITEM_DETAILS_DATA = "ResourceItemDetailsData"
    """The response data type for Resource's ItemDetailsReport"""
    RESOURCE_GROUP_ITEM_DETAILS_DATA = "ResourceGroupItemDetailsData"
    """The response data type for ResourceGroup's ItemDetailsReport"""


class SortDirectionEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sorting is supported for columns in ItemDetailsReport. This object define sorting direction."""

    DESC = "Desc"
    """Descending order for query result."""
    ASC = "Asc"
    """Ascending order for query result."""
