# == Class: vmms
#
# VMMS base package & configuration
#
# === Parameters
#
# [*package_ensure*]
#   (Optional) Ensure state for package.
#   Defaults to 'present'.
#
# [*purge_config*]
#   (optional) Whether to set only the specified config options
#   in the vmms config.
#   Defaults to false.
#
# [*sync_db*]
#   (Optional) Enable dbsync
#   Defaults to true.
#
class vmms(
  $package_ensure                     = 'present',
  Boolean $purge_config               = false,
  Boolean $sync_db                    = true,
  Boolean $accept_legacy_tls          = false,
){

  include vmms::deps
  include vmms::params
  include vmms::db

  package { 'vmms-common':
    ensure => $package_ensure,
    name   => $::vmms::params::common_package_name,
    tag    => ['openstack', 'vmms-package'],
  }

  resources { 'vmms_config':
    purge => $purge_config,
  }

  vmms_config {
    'DEFAULT/accept_legacy_tls':          value => $accept_legacy_tls;
  }

  if $sync_db {
    include vmms::db::sync
  }
}
