# 0.93 Release “Ra is a happy”

The Pitivi team is proud to announce the third release of the new
version of Pitivi based on [GES](GES.md), the GStreamer Editing
Services library. This is a incremental bugfixing release, so please
make sure to see the [0.91](releases/0.91.md) and [0.92](releases/0.92.md)
release notes to get the full picture.

This is now considered a **beta** release. As per the feedback we've
received since 0.91 and the many fixes we've made since then, we are
confident that the new release series is of much higher quality than the
0.15 series and older.

This release works well for us and we make nice movies with it. Try it
out, have fun and report detailed bugs for issues you may encounter!

## Changes and fixed bugs

Executive summary:

-   Port the viewer and media file previewers to use a Clutter video
    output sink
-   Visual refinements to the timeline (clip positioning, borders,
    selections)
-   Improvements to the ruler and timecode display (cleaner
    representation, respects user theme colors and fonts, etc.)
-   Allow importing MPEG-TS/AVCHD files. We are working towards
    improving the ts demuxer for nonlinear editing usecases.
-   Fixes and improvements to the timeline's clip thumbnailers
-   Clip thumbnailing in the media library, better import error handling
    (see also [this blog
    post](http://jeff.ecchi.ca/blog/2014/01/04/scratching-some-media-library-itches/))
-   Various fixes to the application version checking
-   Rework the way dependencies are checked on startup
-   Make some features contextual and cleanup menus
-   Many content updates to the user manual, thanks to Tomas Karger
-   Papercut fixes to keyframe curves
-   Various fixes for rendering, including:
    -   Fix incorrectly setting project settings from clip properties
    -   Fix playback (and render) of DV files
    -   Fix rendering to MP4 container formats
    -   Fix rendering to MPEG-TS container formats (why in the world
        would you ever want to do that?)
    -   Fix a bug in GES where files would sometimes be rendered with no
        video stream
    -   Usability improvements and minor bug fixes
-   Fix pylint errors
-   Various fixes to the automated test suite
-   Code refactoring and cleanup all over the place
-   Fixes for AppData XML spec compliance
-   Various build and packaging fixes
-   Translations have been updated

See the list of [reported bugs that have been resolved in
0.93](https://bugzilla.gnome.org/buglist.cgi?product=pitivi;target_milestone=0.93).

Since the 0.92 release, 403 commits were made across 166 files. Here is
a summary of some noteworthy commits:

```
8f5d7a3 timeline: Fix dragging an asset to the ruler
bbff99d project: Default to a square pixel aspect ratio
489d514 clipmediaprops: Prevent setting an invalid framerate from a misdetected clip
6ca7dd0 mainwindow: Actually use DAR (not PAR) to set the viewer's display aspect ratio
6401261 project: Emit “rendering-settings-changed” when the pixel aspect ratio changes
b272f07 project: Flush the pipeline when we set restriction caps
17fee0c viewer: Add a button to undock the viewer directly instead of using menu actions
771db7e clipmediaprops: Allow closing the dialog with ESC
25ab268 Show the full pathname in the tooltip for an asset
2167d95 elements: Fix lines appearing a bit to the left
0ff3bae elements: Make sure the line remains straight when adding a keyframe when clicked
9a71127 mainwindow: Allow pressing ESC or q to close the preview asset window
dfc908c tests: Skip TestGnomeSystem.testPowerInhibition if the power is inhibited
5ffd50e timeline: Handle only the key-press/release events on the timeline
5440803 elements: Fix video clips keyframes and lines vertical position
e54f0f5 clipproperties: Fix effect selection in the clip properties tab
7d3268b mainwindow: Short and consistent names for the context tabs
2a0b442 mainwindow: Show by default the title editor tab
1df29a8 medialibrary: Add half space unit at the left of the search field
b41a661 elements: Avoid 0-sized clips to become invisible
f0e557d widgets: Use the zoom slider tooltip to display the duration of the displayed timeline
a0b86d8 widgets: Simplify the zoom controls logic
86eb6ce widgets: Handle smooth scroll events on the zoom slider
f0f4f33 render: Allow the render progress dialog to close the desktop notification
fe2d994 mainwindow: Make the version display more robust in the about window
2b02155 tests: Allow the tests to be run by frameworks like nosetests
a96c7d6 bin: Make sure we use python2 when python3 is the default
510354e mediafilespreviewer: Keep the PreviewWidget size fixed
b1c3d59 mainwindow: Move the preview window size logic to a new method
0f0bd6b viewer: Make the AspectFrame part of the ViewerWidget
ea0149f viewer: Focus back the timeline when using the buttons
bd809c5 ruler: Remove hardcoded background color
b54e840 ruler: Use the same color for the entire playhead
614d70f ruler: Fix the play header display
1c0181b viewer: Add spacing around the play buttons
7734ff6 widgets: Hide the zero hour in the time widget
25107dc timeline: Make the timeline toolbar and scrollbars background transparent
944ff5e render: Fix the video codec settings saving
7215321 check: Make GnomeDesktop a soft dependency
946b99f ruler: Use system font
3f78e85 ruler: Show the hours and millis only if useful
7a301c8 ruler: Use a smaller font for the millis
d9ea434 elements: Remove margins between clips
cb89963 timeline: Fix the scrollbars alignment by using Gtk.Grid
88790fb elements: Change the border color when a clip is selected
5cc89e3 elements: Keep the handlebars hidden when the clip is selected
1af6c48 pipeline: Handle negative position when pausing
3b6ecb1 timeline: Fix stacktrace when clicking handlebar
3fd9b9a previewers: Fix stacktrace when removing a clip
cbe8af7 timeline: Insert the clip at the end of the longest layer
8551d7d widgets: Fix the zoom slider not showing the initial zoom value
3d19f44 timeline: Avoid zooming in when setting the best zoom ratio
ef3f62a timeline: connect to the whole GUI to end marquee selection.
7395094 project: cast remaining uncasted restriction fields.
1f3bf84 viewer: Use an AspectFrame widget in the external viewer, like the internal one
75c01e5 medialibrary: Generate thumbnails in the background
bf95c04 medialibrary: Automatically generate missing thumbnails
5cab48d Use icon_name all over the place, as stock icons are deprecated in GTK+ 3.10
8f031df Make the timeline insensitive during rendering by hijacking all events
afca76e previewers: Remove duplicated CPU tracking code
7e6b273 previewers: Set the thumbnail pixbuf in a single place
c9616fc previewers: Optimize thumbnails reuse
c296ebf previewers: Do not fail if thumbnail timestamp is not the requested one
3ef0717 medialibrary: Allow importing MTS files
e765314 medialibrary: Show the amount of errors with ngettext in warning_infobar
ccb2ce3 medialibrary.ui: Use a smaller, symbolic label for warning_infobar close button
7ea7245 medialibrary: Correctly represent imported vs total clips in the progressbar
7061503 All around: fix positional arguments warnings
a66be04 bin/pitivi.in : Don't call GObject.threads_init if pygobject is recent enough.
2e56e51 Update the app icon
96bc43a system: When the notification daemon is dead get over it
38861f7 system: Use the system instance for displaying notifications
c2fb6f8 Render: don't use the caps name for the muxer / encoder caps.
6933a56 Make pitivi.appdata.xml more translation-friendly and pass appdata-validate
```

## Requirements

Dependencies/requirements have changed significantly since the 0.15
series, but have stayed mostly the same since [0.92](releases/0.92.md).
For this release, we depend on GStreamer, GNonLin and GES 1.2.

Generally speaking, you can refer to Pitivi's check.py for the
dependencies' versions specific to a given release. See also
[dependencies](attic/Dependencies.md) for additional tips.

## Known issues

See the list of [currently known
issues](https://bugzilla.gnome.org/buglist.cgi?query_format=advanced;bug_severity=blocker;bug_severity=critical;bug_severity=major;bug_severity=normal;bug_severity=minor;bug_severity=trivial;bug_status=NEW;bug_status=ASSIGNED;bug_status=REOPENED;product=pitivi),
the [0.91, 0.92 and 0.93-specific
issues](https://bugzilla.gnome.org/buglist.cgi?query_format=advanced&version=0.91&version=0.92&version=0.93&resolution=---&product=pitivi)
and the list of [bugs that need re-testing with
0.91](https://bugzilla.gnome.org/buglist.cgi?query_format=advanced;bug_status=NEEDINFO;target_milestone=0.91;product=pitivi)
(you can help!)

You may also want to see the [0.91](releases/0.91.md) release notes'
“known issues” section.

# Contributors for this release

In Pitivi:

```
234  Alexandru Băluț
 44  Mathieu Duponchelle
 33  Tomas Karger
 27  Jean-François Fortin Tam
  6  Thibault Saunier
  1  Jakub Steiner
  1  Olivier Duchateau
```

In GES:

```
38  Thibault Saunier
 4  Alexandru Băluț
 4  Sebastian Dröge
 3  Dan Williams
 3  Mathieu Duponchelle
 3  Tim-Philipp Müller
 2  Kishore Arepalli
 1  Andreas Schwab
 1  Edward Hervey
 1  Lubosz Sarnecki
 1  Stefan Sauer
```

Translations:

```
   cs  Marek Černocký
   de  Benjamin Steinwender, Marcel Tiede
   el  Dimitris Spingos
   eo  Kristjan SCHMIDT
   es  Daniel Mustieles
   fr  Jean-François Fortin Tam
   hu  Gabor Kelemen
   lt  Aurimas Černius
   pl  Piotr Drąg
pt_BR  Rafael Ferreira, Enrico Nicoletto
   sl  Matej Urbančič
   sr  Мирослав Николић
   tr  Volkan Gezer
   uk  Daniel Korostil
zh_HK  Cheng-Chia Tseng
zh_TW  Cheng-Chia Tseng
```

# Download, additional information and feedback

A tarball is available on
<http://ftp.gnome.org/pub/GNOME/sources/pitivi/0.93/>

See [the Pitivi website](http://www.pitivi.org) and [building with
GES](attic/building_with_ges.md) for download and installation
instructions.

Feedback is welcome. See [bug reporting](Bug_reporting.md) for
tips and tricks.
