#ifndef H2TABLES_INC
#define H2TABLES_INC

/* The data has been calculated using the CoolProp Python package https://doi.org/10.1021/ie4033999.
*
* THIS AN AUTO-GENERATED FILE! DO NOT EDIT IT!
*
* Bell, Ian H. and Wronski, Jorrit and Quoilin, Sylvain and Lemort, Vincent
* Pure and Pseudo-pure Fluid Thermophysical Property Evaluation and
* the Open-Source Thermophysical Property Library CoolProp
* Industrial & Engineering Chemistry Research, 53(6), 2014
* DOI: 10.1021/ie4033999
*
* Temperature range: 280.000 K to 400.000 K, using 200 sampling points
* Pressure range: 0.100 MPa to 100.000 MPa, using 500 sampling points
* Reference temperature and pressure: 288.713 K and 0.101325 MPa
*
* Generated using opm_tables_coolprop.py in opm-utilities like this:
*
* >> python3 opm_tables_coolprop.py -t1 280.0 -t2 400.0 -nt 200 -tref 288.713 -p1 100000.0 -p2 100000000.0 -np 500 -pref 101325.0 -c H2
* 
*/
// Fill in the data for a struct like this (intended to work together with brine salinity 0.1)
//struct Opm::H2TabulatedDensityTraits {
//    typedef double Scalar;
//    static const char  *name;
//    static const int    numX = 200;
//    static const Scalar xMin;
//    static const Scalar xMax;
//    static const int    numY = 500;
//    static const Scalar yMin;
//    static const Scalar yMax;
//    static const Scalar vals[200][500];
//};

inline const double Opm::H2TabulatedDensityTraits::xMin = 2.800000000000000e+02;
inline const double Opm::H2TabulatedDensityTraits::xMax = 4.000000000000000e+02;
inline const double Opm::H2TabulatedDensityTraits::yMin = 1.000000000000000e+05;
inline const double Opm::H2TabulatedDensityTraits::yMax = 1.000000000000000e+08;
inline const char  *Opm::H2TabulatedDensityTraits::name = "density";

inline const Opm::H2TabulatedDensityTraits::Scalar Opm::H2TabulatedDensityTraits::vals[200][500] =
{
	{
		8.653824152443422e-02,		2.594723468676529e-01,		4.319859783653832e-01,		6.040799932433031e-01,		7.757552226174576e-01,
		9.470124736786077e-01,		1.117852531766587e+00,		1.288276162339212e+00,		1.458284112840105e+00,		1.627877114469611e+00,
		1.797055883862814e+00,		1.965821124678498e+00,		2.134173529102750e+00,		2.302113779270755e+00,		2.469642548610190e+00,
		2.636760503109481e+00,		2.803468302514093e+00,		2.969766601453881e+00,		3.135656050504391e+00,		3.301137297184950e+00,
		3.466210986896218e+00,		3.630877763799820e+00,		3.795138271642535e+00,		3.958993154527470e+00,		4.122443057634529e+00,
		4.285488627892414e+00,		4.448130514604294e+00,		4.610369370029229e+00,		4.772205849921327e+00,		4.933640614028585e+00,
		5.094674326553203e+00,		5.255307656575209e+00,		5.415541278441098e+00,		5.575375872119082e+00,		5.734812123522628e+00,
		5.893850724803724e+00,		6.052492374617414e+00,		6.210737778358956e+00,		6.368587648375028e+00,		6.526042704150234e+00,
		6.683103672470194e+00,		6.839771287562440e+00,		6.996046291216262e+00,		7.151929432882609e+00,		7.307421469755184e+00,
		7.462523166833654e+00,		7.617235296970094e+00,		7.771558640899492e+00,		7.925493987255338e+00,		8.079042132571075e+00,
		8.232203881268314e+00,		8.384980045632593e+00,		8.537371445777474e+00,		8.689378909597650e+00,		8.841003272711871e+00,
		8.992245378396253e+00,		9.143106077508731e+00,		9.293586228405161e+00,		9.443686696847744e+00,		9.593408355906329e+00,
		9.742752085853075e+00,		9.891718774051039e+00,		1.004030931483721e+01,		1.018852460940035e+01,		1.033636556565421e+01,
		1.048383309810647e+01,		1.063092812772383e+01,		1.077765158179360e+01,		1.092400439378231e+01,		1.106998750319139e+01,
		1.121560185541061e+01,		1.136084840156925e+01,		1.150572809838560e+01,		1.165024190801484e+01,		1.179439079789567e+01,
		1.193817574059597e+01,		1.208159771365763e+01,		1.222465769944093e+01,		1.236735668496840e+01,		1.250969566176876e+01,
		1.265167562572079e+01,		1.279329757689740e+01,		1.293456251941021e+01,		1.307547146125457e+01,		1.321602541415533e+01,
		1.335622539341347e+01,		1.349607241775359e+01,		1.363556750917257e+01,		1.377471169278942e+01,		1.391350599669632e+01,
		1.405195145181121e+01,		1.419004909173167e+01,		1.432779995259050e+01,		1.446520507291287e+01,		1.460226549347516e+01,
		1.473898225716558e+01,		1.487535640884657e+01,		1.501138899521916e+01,		1.514708106468911e+01,		1.528243366723513e+01,
		1.541744785427897e+01,		1.555212467855770e+01,		1.568646519399783e+01,		1.582047045559170e+01,		1.595414151927582e+01,
		1.608747944181145e+01,		1.622048528066720e+01,		1.635316009390385e+01,		1.648550494006125e+01,		1.661752087804739e+01,
		1.674920896702965e+01,		1.688057026632823e+01,		1.701160583531161e+01,		1.714231673329425e+01,		1.727270401943644e+01,
		1.740276875264623e+01,		1.753251199148350e+01,		1.766193479406610e+01,		1.779103821797821e+01,		1.791982332018060e+01,
		1.804829115692307e+01,		1.817644278365893e+01,		1.830427925496145e+01,		1.843180162444237e+01,		1.855901094467232e+01,
		1.868590826710335e+01,		1.881249464199325e+01,		1.893877111833182e+01,		1.906473874376914e+01,		1.919039856454556e+01,
		1.931575162542364e+01,		1.944079896962185e+01,		1.956554163875011e+01,		1.968998067274708e+01,		1.981411710981916e+01,
		1.993795198638124e+01,		2.006148633699914e+01,		2.018472119433367e+01,		2.030765758908636e+01,		2.043029654994682e+01,
		2.055263910354155e+01,		2.067468627438448e+01,		2.079643908482888e+01,		2.091789855502086e+01,		2.103906570285429e+01,
		2.115994154392718e+01,		2.128052709149944e+01,		2.140082335645208e+01,		2.152083134724772e+01,		2.164055206989246e+01,
		2.175998652789902e+01,		2.187913572225124e+01,		2.199800065136970e+01,		2.211658231107865e+01,		2.223488169457423e+01,
		2.235289979239364e+01,		2.247063759238565e+01,		2.258809607968216e+01,		2.270527623667085e+01,		2.282217904296898e+01,
		2.293880547539811e+01,		2.305515650796003e+01,		2.317123311181348e+01,		2.328703625525202e+01,		2.340256690368283e+01,
		2.351782601960636e+01,		2.363281456259699e+01,		2.374753348928455e+01,		2.386198375333667e+01,		2.397616630544208e+01,
		2.409008209329464e+01,		2.420373206157818e+01,		2.431711715195228e+01,		2.443023830303859e+01,		2.454309645040811e+01,
		2.465569252656904e+01,		2.476802746095549e+01,		2.488010217991671e+01,		2.499191760670721e+01,		2.510347466147733e+01,
		2.521477426126459e+01,		2.532581731998565e+01,		2.543660474842881e+01,		2.554713745424715e+01,		2.565741634195225e+01,
		2.576744231290846e+01,		2.587721626532775e+01,		2.598673909426500e+01,		2.609601169161390e+01,		2.620503494610332e+01,
		2.631380974329418e+01,		2.642233696557671e+01,		2.653061749216833e+01,		2.663865219911182e+01,		2.674644195927403e+01,
		2.685398764234498e+01,		2.696129011483728e+01,		2.706835024008616e+01,		2.717516887824969e+01,		2.728174688630942e+01,
		2.738808511807146e+01,		2.749418442416782e+01,		2.760004565205814e+01,		2.770566964603175e+01,		2.781105724721006e+01,
		2.791620929354918e+01,		2.802112661984300e+01,		2.812581005772635e+01,		2.823026043567869e+01,		2.833447857902787e+01,
		2.843846530995420e+01,		2.854222144749490e+01,		2.864574780754860e+01,		2.874904520288029e+01,		2.885211444312629e+01,
		2.895495633479965e+01,		2.905757168129557e+01,		2.915996128289721e+01,		2.926212593678153e+01,		2.936406643702555e+01,
		2.946578357461248e+01,		2.956727813743837e+01,		2.966855091031869e+01,		2.976960267499519e+01,		2.987043421014293e+01,
		2.997104629137736e+01,		3.007143969126171e+01,		3.017161517931438e+01,		3.027157352201658e+01,		3.037131548282001e+01,
		3.047084182215477e+01,		3.057015329743728e+01,		3.066925066307842e+01,		3.076813467049172e+01,		3.086680606810171e+01,
		3.096526560135228e+01,		3.106351401271531e+01,		3.116155204169924e+01,		3.125938042485775e+01,		3.135699989579863e+01,
		3.145441118519266e+01,		3.155161502078251e+01,		3.164861212739188e+01,		3.174540322693457e+01,		3.184198903842366e+01,
		3.193837027798080e+01,		3.203454765884552e+01,		3.213052189138456e+01,		3.222629368310137e+01,		3.232186373864555e+01,
		3.241723275982245e+01,		3.251240144560261e+01,		3.260737049213161e+01,		3.270214059273955e+01,		3.279671243795087e+01,
		3.289108671549403e+01,		3.298526411031136e+01,		3.307924530456883e+01,		3.317303097766591e+01,		3.326662180624545e+01,
		3.336001846420355e+01,		3.345322162269952e+01,		3.354623195016583e+01,		3.363905011231797e+01,		3.373167677216463e+01,
		3.382411259001745e+01,		3.391635822350122e+01,		3.400841432756387e+01,		3.410028155448636e+01,		3.419196055389293e+01,
		3.428345197276098e+01,		3.437475645543124e+01,		3.446587464361772e+01,		3.455680717641788e+01,		3.464755469032259e+01,
		3.473811781922627e+01,		3.482849719443690e+01,		3.491869344468609e+01,		3.500870719613918e+01,		3.509853907240518e+01,
		3.518818969454691e+01,		3.527765968109102e+01,		3.536694964803799e+01,		3.545606020887216e+01,		3.554499197457172e+01,
		3.563374555361874e+01,		3.572232155200911e+01,		3.581072057326258e+01,		3.589894321843266e+01,		3.598699008611652e+01,
		3.607486177246505e+01,		3.616255887119267e+01,		3.625008197358720e+01,		3.633743166851988e+01,		3.642460854245503e+01,
		3.651161317946006e+01,		3.659844616121521e+01,		3.668510806702329e+01,		3.677159947381961e+01,		3.685792095618163e+01,
		3.694407308633867e+01,		3.703005643418171e+01,		3.711587156727303e+01,		3.720151905085590e+01,		3.728699944786415e+01,
		3.737231331893189e+01,		3.745746122240301e+01,		3.754244371434083e+01,		3.762726134853758e+01,		3.771191467652393e+01,
		3.779640424757850e+01,		3.788073060873730e+01,		3.796489430480317e+01,		3.804889587835517e+01,		3.813273586975801e+01,
		3.821641481717136e+01,		3.829993325655921e+01,		3.838329172169912e+01,		3.846649074419148e+01,		3.854953085346883e+01,
		3.863241257680500e+01,		3.871513643932430e+01,		3.879770296401067e+01,		3.888011267171681e+01,		3.896236608117328e+01,
		3.904446370899753e+01,		3.912640606970297e+01,		3.920819367570795e+01,		3.928982703734466e+01,		3.937130666286822e+01,
		3.945263305846543e+01,		3.953380672826381e+01,		3.961482817434024e+01,		3.969569789673000e+01,		3.977641639343535e+01,
		3.985698416043441e+01,		3.993740169168987e+01,		4.001766947915764e+01,		4.009778801279547e+01,		4.017775778057171e+01,
		4.025757926847378e+01,		4.033725296051676e+01,		4.041677933875193e+01,		4.049615888327533e+01,		4.057539207223613e+01,
		4.065447938184511e+01,		4.073342128638303e+01,		4.081221825820911e+01,		4.089087076776926e+01,		4.096937928360435e+01,
		4.104774427235866e+01,		4.112596619878796e+01,		4.120404552576782e+01,		4.128198271430170e+01,		4.135977822352922e+01,
		4.143743251073411e+01,		4.151494603135251e+01,		4.159231923898082e+01,		4.166955258538388e+01,		4.174664652050281e+01,
		4.182360149246308e+01,		4.190041794758242e+01,		4.197709633037865e+01,		4.205363708357763e+01,		4.213004064812102e+01,
		4.220630746317414e+01,		4.228243796613367e+01,		4.235843259263542e+01,		4.243429177656211e+01,		4.251001595005086e+01,
		4.258560554350101e+01,		4.266106098558168e+01,		4.273638270323931e+01,		4.281157112170522e+01,		4.288662666450318e+01,
		4.296154975345683e+01,		4.303634080869718e+01,		4.311100024867000e+01,		4.318552849014326e+01,		4.325992594821447e+01,
		4.333419303631799e+01,		4.340833016623237e+01,		4.348233774808759e+01,		4.355621619037235e+01,		4.362996589994124e+01,
		4.370358728202185e+01,		4.377708074022214e+01,		4.385044667653730e+01,		4.392368549135703e+01,		4.399679758347250e+01,
		4.406978335008344e+01,		4.414264318680506e+01,		4.421537748767515e+01,		4.428798664516085e+01,		4.436047105016576e+01,
		4.443283109203665e+01,		4.450506715857042e+01,		4.457717963602084e+01,		4.464916890910543e+01,		4.472103536101216e+01,
		4.479277937340627e+01,		4.486440132643686e+01,		4.493590159874363e+01,		4.500728056746357e+01,		4.507853860823751e+01,
		4.514967609521676e+01,		4.522069340106960e+01,		4.529159089698799e+01,		4.536236895269384e+01,		4.543302793644565e+01,
		4.550356821504499e+01,		4.557399015384271e+01,		4.564429411674561e+01,		4.571448046622261e+01,		4.578454956331115e+01,
		4.585450176762357e+01,		4.592433743735325e+01,		4.599405692928099e+01,		4.606366059878121e+01,		4.613314879982813e+01,
		4.620252188500189e+01,		4.627178020549491e+01,		4.634092411111768e+01,		4.640995395030519e+01,		4.647887007012277e+01,
		4.654767281627222e+01,		4.661636253309780e+01,		4.668493956359225e+01,		4.675340424940270e+01,		4.682175693083665e+01,
		4.688999794686786e+01,		4.695812763514222e+01,		4.702614633198362e+01,		4.709405437239979e+01,		4.716185209008808e+01,
		4.722953981744129e+01,		4.729711788555328e+01,		4.736458662422493e+01,		4.743194636196966e+01,		4.749919742601913e+01,
		4.756634014232894e+01,		4.763337483558428e+01,		4.770030182920541e+01,		4.776712144535338e+01,		4.783383400493550e+01,
		4.790043982761085e+01,		4.796693923179583e+01,		4.803333253466962e+01,		4.809962005217966e+01,		4.816580209904697e+01,
		4.823187898877173e+01,		4.829785103363847e+01,		4.836371854472160e+01,		4.842948183189060e+01,		4.849514120381538e+01,
		4.856069696797162e+01,		4.862614943064592e+01,		4.869149889694113e+01,		4.875674567078149e+01,		4.882189005491790e+01,
		4.888693235093297e+01,		4.895187285924632e+01,		4.901671187911952e+01,		4.908144970866132e+01,		4.914608664483265e+01,
		4.921062298345174e+01,		4.927505901919903e+01,		4.933939504562233e+01,		4.940363135514162e+01,		4.946776823905419e+01,
		4.953180598753946e+01,		4.959574488966388e+01,		4.965958523338597e+01,		4.972332730556093e+01,		4.978697139194580e+01,
		4.985051777720400e+01,		4.991396674491035e+01,		4.997731857755571e+01,		5.004057355655176e+01,		5.010373196223584e+01,
		5.016679407387556e+01,		5.022976016967348e+01,		5.029263052677188e+01,		5.035540542125737e+01,		5.041808512816549e+01,
		5.048066992148527e+01,		5.054316007416404e+01,		5.060555585811169e+01,		5.066785754420547e+01,		5.073006540229439e+01,
		5.079217970120369e+01,		5.085420070873950e+01,		5.091612869169307e+01,		5.097796391584542e+01,		5.103970664597163e+01,
		5.110135714584528e+01,		5.116291567824288e+01,		5.122438250494810e+01,		5.128575788675628e+01,		5.134704208347868e+01
	},
	{
		8.635233128762666e-02,		2.589152851571928e-01,		4.310591554419675e-01,		6.027848008450900e-01,		7.740930541916078e-01,
		9.449847245851615e-01,		1.115460599456232e+00,		1.285521446506428e+00,		1.455168015553110e+00,		1.624401040278461e+00,
		1.793221239886955e+00,		1.961629320675016e+00,		2.129625977516492e+00,		2.297211895267457e+00,		2.464387750093686e+00,
		2.631154210724035e+00,		2.797511939632826e+00,		2.963461594154232e+00,		3.129003827531518e+00,		3.294139289903920e+00,
		3.458868629233792e+00,		3.623192492176616e+00,		3.787111524896318e+00,		3.950626373828256e+00,		4.113737686392182e+00,
		4.276446111657375e+00,		4.438752300962045e+00,		4.600656908489064e+00,		4.762160591800004e+00,		4.923264012329319e+00,
		5.083967835840566e+00,		5.244272732846357e+00,		5.404179378993763e+00,		5.563688455416790e+00,		5.722800649057496e+00,
		5.881516652957230e+00,		6.039837166519483e+00,		6.197762895745722e+00,		6.355294553445541e+00,		6.512432859422433e+00,
		6.669178540636440e+00,		6.825532331344833e+00,		6.981494973222005e+00,		7.137067215459663e+00,		7.292249814848367e+00,
		7.447043535841487e+00,		7.601449150602470e+00,		7.755467439036410e+00,		7.909099188806832e+00,		8.062345195338503e+00,
		8.215206261807142e+00,		8.367683199116778e+00,		8.519776825865584e+00,		8.671487968300825e+00,		8.822817460263725e+00,
		8.973766143124767e+00,		9.124334865710274e+00,		9.274524484220679e+00,		9.424335862141177e+00,		9.573769870145320e+00,
		9.722827385992010e+00,		9.871509294416505e+00,		1.001981648701583e+01,		1.016774986212911e+01,		1.031531032471323e+01,
		1.046249878621429e+01,		1.060931616443521e+01,		1.075576338339988e+01,		1.090184137321421e+01,		1.104755106992446e+01,
		1.119289341537312e+01,		1.133786935705268e+01,		1.148247984795761e+01,		1.162672584643476e+01,		1.177060831603254e+01,
		1.191412822534897e+01,		1.205728654787909e+01,		1.220008426186162e+01,		1.234252235012547e+01,		1.248460179993586e+01,
		1.262632360284069e+01,		1.276768875451690e+01,		1.290869825461740e+01,		1.304935310661832e+01,		1.318965431766708e+01,
		1.332960289843118e+01,		1.346919986294797e+01,		1.360844622847534e+01,		1.374734301534376e+01,		1.388589124680939e+01,
		1.402409194890865e+01,		1.416194615031419e+01,		1.429945488219235e+01,		1.443661917806229e+01,		1.457344007365666e+01,
		1.470991860678416e+01,		1.484605581719370e+01,		1.498185274644046e+01,		1.511731043775391e+01,		1.525242993590757e+01,
		1.538721228709091e+01,		1.552165853878308e+01,		1.565576973962876e+01,		1.578954693931600e+01,		1.592299118845609e+01,
		1.605610353846565e+01,		1.618888504145055e+01,		1.632133675009224e+01,		1.645345971753592e+01,		1.658525499728102e+01,
		1.671672364307367e+01,		1.684786670880134e+01,		1.697868524838966e+01,		1.710918031570115e+01,		1.723935296443635e+01,
		1.736920424803675e+01,		1.749873521959001e+01,		1.762794693173719e+01,		1.775684043658204e+01,		1.788541678560228e+01,
		1.801367702956310e+01,		1.814162221843240e+01,		1.826925340129829e+01,		1.839657162628839e+01,		1.852357794049119e+01,
		1.865027338987926e+01,		1.877665901923446e+01,		1.890273587207501e+01,		1.902850499058439e+01,		1.915396741554213e+01,
		1.927912418625642e+01,		1.940397634049850e+01,		1.952852491443880e+01,		1.965277094258489e+01,		1.977671545772107e+01,
		1.990035949084969e+01,		2.002370407113419e+01,		2.014675022584365e+01,		2.026949898029904e+01,		2.039195135782110e+01,
		2.051410837967965e+01,		2.063597106504454e+01,		2.075754043093803e+01,		2.087881749218874e+01,		2.099980326138692e+01,
		2.112049874884126e+01,		2.124090496253702e+01,		2.136102290809563e+01,		2.148085358873546e+01,		2.160039800523408e+01,
		2.171965715589171e+01,		2.183863203649600e+01,		2.195732364028798e+01,		2.207573295792924e+01,		2.219386097747035e+01,
		2.231170868432040e+01,		2.242927706121770e+01,		2.254656708820152e+01,		2.266357974258501e+01,		2.278031599892918e+01,
		2.289677682901783e+01,		2.301296320183363e+01,		2.312887608353507e+01,		2.324451643743446e+01,		2.335988522397686e+01,
		2.347498340071993e+01,		2.358981192231468e+01,		2.370437174048714e+01,		2.381866380402087e+01,		2.393268905874027e+01,
		2.404644844749479e+01,		2.415994291014393e+01,		2.427317338354293e+01,		2.438614080152934e+01,		2.449884609491032e+01,
		2.461129019145053e+01,		2.472347401586092e+01,		2.483539848978810e+01,		2.494706453180434e+01,		2.505847305739841e+01,
		2.516962497896677e+01,		2.528052120580567e+01,		2.539116264410364e+01,		2.550155019693475e+01,		2.561168476425221e+01,
		2.572156724288277e+01,		2.583119852652153e+01,		2.594057950572725e+01,		2.604971106791827e+01,		2.615859409736887e+01,
		2.626722947520613e+01,		2.637561807940723e+01,		2.648376078479723e+01,		2.659165846304735e+01,		2.669931198267354e+01,
		2.680672220903565e+01,		2.691389000433684e+01,		2.702081622762350e+01,		2.712750173478549e+01,		2.723394737855681e+01,
		2.734015400851652e+01,		2.744612247109019e+01,		2.755185360955147e+01,		2.765734826402422e+01,		2.776260727148476e+01,
		2.786763146576454e+01,		2.797242167755311e+01,		2.807697873440125e+01,		2.818130346072466e+01,		2.828539667780759e+01,
		2.838925920380693e+01,		2.849289185375657e+01,		2.859629543957190e+01,		2.869947077005460e+01,		2.880241865089768e+01,
		2.890513988469071e+01,		2.900763527092528e+01,		2.910990560600066e+01,		2.921195168322974e+01,		2.931377429284494e+01,
		2.941537422200460e+01,		2.951675225479937e+01,		2.961790917225880e+01,		2.971884575235807e+01,		2.981956277002502e+01,
		2.992006099714716e+01,		3.002034120257897e+01,		3.012040415214924e+01,		3.022025060866860e+01,		3.031988133193722e+01,
		3.041929707875253e+01,		3.051849860291718e+01,		3.061748665524705e+01,		3.071626198357941e+01,		3.081482533278114e+01,
		3.091317744475713e+01,		3.101131905845867e+01,		3.110925090989208e+01,		3.120697373212732e+01,		3.130448825530671e+01,
		3.140179520665378e+01,		3.149889531048212e+01,		3.159578928820440e+01,		3.169247785834140e+01,		3.178896173653111e+01,
		3.188524163553795e+01,		3.198131826526197e+01,		3.207719233274817e+01,		3.217286454219591e+01,		3.226833559496820e+01,
		3.236360618960133e+01,		3.245867702181420e+01,		3.255354878451810e+01,		3.264822216782605e+01,		3.274269785906265e+01,
		3.283697654277361e+01,		3.293105890073562e+01,		3.302494561196593e+01,		3.311863735273214e+01,		3.321213479656218e+01,
		3.330543861425389e+01,		3.339854947388502e+01,		3.349146804082307e+01,		3.358419497773517e+01,		3.367673094459796e+01,
		3.376907659870758e+01,		3.386123259468956e+01,		3.395319958450872e+01,		3.404497821747929e+01,		3.413656914027465e+01,
		3.422797299693755e+01,		3.431919042888985e+01,		3.441022207494272e+01,		3.450106857130645e+01,		3.459173055160061e+01,
		3.468220864686387e+01,		3.477250348556409e+01,		3.486261569360830e+01,		3.495254589435265e+01,		3.504229470861242e+01,
		3.513186275467199e+01,		3.522125064829468e+01,		3.531045900273296e+01,		3.539948842873816e+01,		3.548833953457052e+01,
		3.557701292600913e+01,		3.566550920636173e+01,		3.575382897647478e+01,		3.584197283474315e+01,		3.592994137712024e+01,
		3.601773519712756e+01,		3.610535488586478e+01,		3.619280103201952e+01,		3.628007422187701e+01,		3.636717503933006e+01,
		3.645410406588881e+01,		3.654086188069031e+01,		3.662744906050850e+01,		3.671386617976366e+01,		3.680011381053234e+01,
		3.688619252255688e+01,		3.697210288325510e+01,		3.705784545772987e+01,		3.714342080877880e+01,		3.722882949690376e+01,
		3.731407208032043e+01,		3.739914911496785e+01,		3.748406115451788e+01,		3.756880875038471e+01,		3.765339245173431e+01,
		3.773781280549385e+01,		3.782207035636105e+01,		3.790616564681364e+01,		3.799009921711863e+01,		3.807387160534165e+01,
		3.815748334735629e+01,		3.824093497685320e+01,		3.832422702534956e+01,		3.840736002219801e+01,		3.849033449459613e+01,
		3.857315096759529e+01,		3.865580996410998e+01,		3.873831200492678e+01,		3.882065760871348e+01,		3.890284729202806e+01,
		3.898488156932773e+01,		3.906676095297791e+01,		3.914848595326104e+01,		3.923005707838569e+01,		3.931147483449532e+01,
		3.939273972567704e+01,		3.947385225397066e+01,		3.955481291937722e+01,		3.963562221986795e+01,		3.971628065139288e+01,
		3.979678870788955e+01,		3.987714688129169e+01,		3.995735566153780e+01,		4.003741553657984e+01,		4.011732699239173e+01,
		4.019709051297787e+01,		4.027670658038171e+01,		4.035617567469417e+01,		4.043549827406206e+01,		4.051467485469662e+01,
		4.059370589088164e+01,		4.067259185498216e+01,		4.075133321745245e+01,		4.082993044684449e+01,		4.090838400981616e+01,
		4.098669437113946e+01,		4.106486199370870e+01,		4.114288733854868e+01,		4.122077086482274e+01,		4.129851302984095e+01,
		4.137611428906813e+01,		4.145357509613181e+01,		4.153089590283039e+01,		4.160807715914092e+01,		4.168511931322718e+01,
		4.176202281144744e+01,		4.183878809836253e+01,		4.191541561674350e+01,		4.199190580757950e+01,		4.206825911008553e+01,
		4.214447596171030e+01,		4.222055679814371e+01,		4.229650205332480e+01,		4.237231215944919e+01,		4.244798754697683e+01,
		4.252352864463952e+01,		4.259893587944858e+01,		4.267420967670218e+01,		4.274935045999299e+01,		4.282435865121565e+01,
		4.289923467057409e+01,		4.297397893658908e+01,		4.304859186610548e+01,		4.312307387429964e+01,		4.319742537468673e+01,
		4.327164677912794e+01,		4.334573849783792e+01,		4.341970093939172e+01,		4.349353451073219e+01,		4.356723961717716e+01,
		4.364081666242636e+01,		4.371426604856878e+01,		4.378758817608952e+01,		4.386078344387703e+01,		4.393385224922992e+01,
		4.400679498786414e+01,		4.407961205391975e+01,		4.415230383996801e+01,		4.422487073701812e+01,		4.429731313452419e+01,
		4.436963142039207e+01,		4.444182598098606e+01,		4.451389720113582e+01,		4.458584546414305e+01,		4.465767115178813e+01,
		4.472937464433699e+01,		4.480095632054760e+01,		4.487241655767672e+01,		4.494375573148648e+01,		4.501497421625083e+01,
		4.508607238476230e+01,		4.515705060833834e+01,		4.522790925682794e+01,		4.529864869861798e+01,		4.536926930063978e+01,
		4.543977142837535e+01,		4.551015544586396e+01,		4.558042171570834e+01,		4.565057059908106e+01,		4.572060245573086e+01,
		4.579051764398886e+01,		4.586031652077482e+01,		4.592999944160334e+01,		4.599956676059012e+01,		4.606901883045798e+01,
		4.613835600254318e+01,		4.620757862680131e+01,		4.627668705181359e+01,		4.634568162479276e+01,		4.641456269158912e+01,
		4.648333059669666e+01,		4.655198568325886e+01,		4.662052829307476e+01,		4.668895876660479e+01,		4.675727744297681e+01,
		4.682548465999178e+01,		4.689358075412972e+01,		4.696156606055556e+01,		4.702944091312481e+01,		4.709720564438945e+01,
		4.716486058560357e+01,		4.723240606672917e+01,		4.729984241644173e+01,		4.736716996213605e+01,		4.743438902993167e+01,
		4.750149994467871e+01,		4.756850302996325e+01,		4.763539860811303e+01,		4.770218700020297e+01,		4.776886852606060e+01,
		4.783544350427167e+01,		4.790191225218552e+01,		4.796827508592055e+01,		4.803453232036963e+01,		4.810068426920551e+01,
		4.816673124488621e+01,		4.823267355866027e+01,		4.829851152057213e+01,		4.836424543946748e+01,		4.842987562299843e+01,
		4.849540237762879e+01,		4.856082600863934e+01,		4.862614682013296e+01,		4.869136511503986e+01,		4.875648119512273e+01,
		4.882149536098181e+01,		4.888640791206013e+01,		4.895121914664839e+01,		4.901592936189024e+01,		4.908053885378715e+01,
		4.914504791720354e+01,		4.920945684587173e+01,		4.927376593239681e+01,		4.933797546826183e+01,		4.940208574383251e+01,
		4.946609704836216e+01,		4.953000966999669e+01,		4.959382389577939e+01,		4.965754001165570e+01,		4.972115830247815e+01,
		4.978467905201112e+01,		4.984810254293552e+01,		4.991142905685364e+01,		4.997465887429389e+01,		5.003779227471536e+01,
		5.010082953651268e+01,		5.016377093702062e+01,		5.022661675251866e+01,		5.028936725823571e+01,		5.035202272835465e+01,
		5.041458343601698e+01,		5.047704965332731e+01,		5.053942165135782e+01,		5.060169970015305e+01,		5.066388406873406e+01,
		5.072597502510317e+01,		5.078797283624822e+01,		5.084987776814718e+01,		5.091169008577242e+01,		5.097341005309517e+01,
		5.103503793308985e+01,		5.109657398773859e+01,		5.115801847803525e+01,		5.121937166399004e+01,		5.128063380463365e+01
	},
	{
		8.616721842952939e-02,		2.583606129970045e-01,		4.301363086022491e-01,		6.014951653536492e-01,		7.724380177102659e-01,
		9.429656766112628e-01,		1.113078931498427e+00,		1.282778552236198e+00,		1.452065290933424e+00,		1.620939883670911e+00,
		1.789403052138638e+00,		1.957455505186383e+00,		2.125097940291331e+00,		2.292331044946125e+00,		2.459155497970647e+00,
		2.625571970750718e+00,		2.791581128406783e+00,		2.957183630895501e+00,		3.122380134047091e+00,		3.287171290541140e+00,
		3.451557750823502e+00,		3.615540163966806e+00,		3.779119178477000e+00,		3.942295443048272e+00,		4.105069607268597e+00,
		4.267442322278081e+00,		4.429414241382175e+00,		4.590986020621798e+00,		4.752158319302266e+00,		4.912931800482934e+00,
		5.073307131429312e+00,		5.233284984029399e+00,		5.392866035175898e+00,		5.552050967115915e+00,		5.710840467769688e+00,
		5.869235231019810e+00,		6.027235956972413e+00,		6.184843352191653e+00,		6.342058129908835e+00,		6.498881010207444e+00,
		6.655312720185320e+00,		6.811353994095136e+00,		6.967005573464315e+00,		7.122268207195471e+00,		7.277142651648437e+00,
		7.431629670704850e+00,		7.585730035816287e+00,		7.739444526036850e+00,		7.892773928041113e+00,		8.045719036128263e+00,
		8.198280652213247e+00,		8.350459585805748e+00,		8.502256653977664e+00,		8.653672681319906e+00,		8.804708499889101e+00,
		8.955364949144942e+00,		9.105642875878766e+00,		9.255543134134005e+00,		9.405066585118991e+00,		9.554214097112821e+00,
		9.702986545364658e+00,		9.851384811987053e+00,		9.999409785843765e+00,		1.014706236243247e+01,		1.029434344376289e+01,
		1.044125393823068e+01,		1.058779476048754e+01,		1.073396683130780e+01,		1.087977107745198e+01,		1.102520843152766e+01,
		1.117027983184778e+01,		1.131498622228697e+01,		1.145932855213594e+01,		1.160330777595446e+01,		1.174692485342287e+01,
		1.189018074919269e+01,		1.203307643273637e+01,		1.217561287819646e+01,		1.231779106423438e+01,		1.245961197387903e+01,
		1.260107659437535e+01,		1.274218591703315e+01,		1.288294093707618e+01,		1.302334265349173e+01,		1.316339206888085e+01,
		1.330309018930939e+01,		1.344243802415981e+01,		1.358143658598413e+01,		1.372008689035796e+01,		1.385838995573566e+01,
		1.399634680330698e+01,		1.413395845685494e+01,		1.427122594261525e+01,		1.440815028913736e+01,		1.454473252714697e+01,
		1.468097368941039e+01,		1.481687481060054e+01,		1.495243692716473e+01,		1.508766107719439e+01,		1.522254830029652e+01,
		1.535709963746715e+01,		1.549131613096682e+01,		1.562519882419782e+01,		1.575874876158366e+01,		1.589196698845041e+01,
		1.602485455091017e+01,		1.615741249574652e+01,		1.628964187030210e+01,		1.642154372236825e+01,		1.655311910007666e+01,
		1.668436905179323e+01,		1.681529462601389e+01,		1.694589687126260e+01,		1.707617683599133e+01,		1.720613556848222e+01,
		1.733577411675171e+01,		1.746509352845683e+01,		1.759409485080335e+01,		1.772277913045621e+01,		1.785114741345177e+01,
		1.797920074511219e+01,		1.810694016996167e+01,		1.823436673164477e+01,		1.836148147284662e+01,		1.848828543521514e+01,
		1.861477965928500e+01,		1.874096518440368e+01,		1.886684304865925e+01,		1.899241428881002e+01,		1.911767994021605e+01,
		1.924264103677244e+01,		1.936729861084440e+01,		1.949165369320400e+01,		1.961570731296873e+01,		1.973946049754173e+01,
		1.986291427255367e+01,		1.998606966180631e+01,		2.010892768721761e+01,		2.023148936876851e+01,		2.035375572445129e+01,
		2.047572777021929e+01,		2.059740651993843e+01,		2.071879298534002e+01,		2.083988817597497e+01,		2.096069309916968e+01,
		2.108120875998313e+01,		2.120143616116539e+01,		2.132137630311753e+01,		2.144103018385287e+01,		2.156039879895944e+01,
		2.167948314156381e+01,		2.179828420229612e+01,		2.191680296925635e+01,		2.203504042798178e+01,		2.215299756141568e+01,
		2.227067534987704e+01,		2.238807477103154e+01,		2.250519679986353e+01,		2.262204240864919e+01,		2.273861256693060e+01,
		2.285490824149102e+01,		2.297093039633101e+01,		2.308667999264565e+01,		2.320215798880265e+01,		2.331736534032143e+01,
		2.343230299985322e+01,		2.354697191716174e+01,		2.366137303910523e+01,		2.377550730961890e+01,		2.388937566969846e+01,
		2.400297905738438e+01,		2.411631840774700e+01,		2.422939465287233e+01,		2.434220872184871e+01,		2.445476154075409e+01,
		2.456705403264415e+01,		2.467908711754104e+01,		2.479086171242279e+01,		2.490237873121353e+01,		2.501363908477410e+01,
		2.512464368089359e+01,		2.523539342428123e+01,		2.534588921655910e+01,		2.545613195625520e+01,		2.556612253879733e+01,
		2.567586185650729e+01,		2.578535079859585e+01,		2.589459025115799e+01,		2.600358109716884e+01,		2.611232421648006e+01,
		2.622082048581671e+01,		2.632907077877447e+01,		2.643707596581755e+01,		2.654483691427680e+01,		2.665235448834840e+01,
		2.675962954909291e+01,		2.686666295443473e+01,		2.697345555916198e+01,		2.708000821492665e+01,		2.718632177024538e+01,
		2.729239707050022e+01,		2.739823495794009e+01,		2.750383627168236e+01,		2.760920184771486e+01,		2.771433251889815e+01,
		2.781922911496812e+01,		2.792389246253896e+01,		2.802832338510623e+01,		2.813252270305041e+01,		2.823649123364064e+01,
		2.834022979103867e+01,		2.844373918630312e+01,		2.854702022739407e+01,		2.865007371917768e+01,		2.875290046343121e+01,
		2.885550125884817e+01,		2.895787690104383e+01,		2.906002818256066e+01,		2.916195589287428e+01,		2.926366081839940e+01,
		2.936514374249602e+01,		2.946640544547580e+01,		2.956744670460858e+01,		2.966826829412912e+01,		2.976887098524396e+01,
		2.986925554613843e+01,		2.996942274198383e+01,		3.006937333494478e+01,		3.016910808418664e+01,		3.026862774588309e+01,
		3.036793307322390e+01,		3.046702481642275e+01,		3.056590372272511e+01,		3.066457053641649e+01,		3.076302599883045e+01,
		3.086127084835697e+01,		3.095930582045082e+01,		3.105713164764004e+01,		3.115474905953452e+01,		3.125215878283469e+01,
		3.134936154134017e+01,		3.144635805595872e+01,		3.154314904471504e+01,		3.163973522275982e+01,		3.173611730237872e+01,
		3.183229599300152e+01,		3.192827200121129e+01,		3.202404603075360e+01,		3.211961878254584e+01,		3.221499095468651e+01,
		3.231016324246468e+01,		3.240513633836935e+01,		3.249991093209898e+01,		3.259448771057108e+01,		3.268886735793161e+01,
		3.278305055556472e+01,		3.287703798210237e+01,		3.297083031343393e+01,		3.306442822271595e+01,		3.315783238038185e+01,
		3.325104345415171e+01,		3.334406210904198e+01,		3.343688900737531e+01,		3.352952480879042e+01,		3.362197017025187e+01,
		3.371422574605990e+01,		3.380629218786034e+01,		3.389817014465446e+01,		3.398986026280891e+01,		3.408136318606547e+01,
		3.417267955555116e+01,		3.426381000978799e+01,		3.435475518470293e+01,		3.444551571363781e+01,		3.453609222735927e+01,
		3.462648535406866e+01,		3.471669571941194e+01,		3.480672394648964e+01,		3.489657065586668e+01,		3.498623646558239e+01,
		3.507572199116035e+01,		3.516502784561830e+01,		3.525415463947797e+01,		3.534310298077506e+01,		3.543187347506905e+01,
		3.552046672545303e+01,		3.560888333256360e+01,		3.569712389459064e+01,		3.578518900728721e+01,		3.587307926397928e+01,
		3.596079525557557e+01,		3.604833757057728e+01,		3.613570679508787e+01,		3.622290351282281e+01,		3.630992830511926e+01,
		3.639678175094585e+01,		3.648346442691225e+01,		3.656997690727895e+01,		3.665631976396684e+01,		3.674249356656684e+01,
		3.682849888234945e+01,		3.691433627627447e+01,		3.700000631100040e+01,		3.708550954689407e+01,		3.717084654204012e+01,
		3.725601785225042e+01,		3.734102403107370e+01,		3.742586562980480e+01,		3.751054319749415e+01,		3.759505728095725e+01,
		3.767940842478384e+01,		3.776359717134742e+01,		3.784762406081440e+01,		3.793148963115347e+01,		3.801519441814491e+01,
		3.809873895538962e+01,		3.818212377431851e+01,		3.826534940420157e+01,		3.834841637215702e+01,		3.843132520316045e+01,
		3.851407642005390e+01,		3.859667054355490e+01,		3.867910809226544e+01,		3.876138958268109e+01,		3.884351552919988e+01,
		3.892548644413124e+01,		3.900730283770493e+01,		3.908896521807993e+01,		3.917047409135323e+01,		3.925182996156871e+01,
		3.933303333072586e+01,		3.941408469878863e+01,		3.949498456369405e+01,		3.957573342136097e+01,		3.965633176569877e+01,
		3.973678008861591e+01,		3.981707888002855e+01,		3.989722862786922e+01,		3.997722981809518e+01,		4.005708293469706e+01,
		4.013678845970736e+01,		4.021634687320873e+01,		4.029575865334261e+01,		4.037502427631741e+01,		4.045414421641697e+01,
		4.053311894600888e+01,		4.061194893555271e+01,		4.069063465360835e+01,		4.076917656684410e+01,		4.084757514004505e+01,
		4.092583083612114e+01,		4.100394411611521e+01,		4.108191543921125e+01,		4.115974526274242e+01,		4.123743404219902e+01,
		4.131498223123658e+01,		4.139239028168380e+01,		4.146965864355048e+01,		4.154678776503547e+01,		4.162377809253448e+01,
		4.170063007064802e+01,		4.177734414218915e+01,		4.185392074819130e+01,		4.193036032791595e+01,		4.200666331886052e+01,
		4.208283015676588e+01,		4.215886127562410e+01,		4.223475710768611e+01,		4.231051808346920e+01,		4.238614463176469e+01,
		4.246163717964539e+01,		4.253699615247317e+01,		4.261222197390642e+01,		4.268731506590741e+01,		4.276227584874990e+01,
		4.283710474102627e+01,		4.291180215965511e+01,		4.298636851988835e+01,		4.306080423531871e+01,		4.313510971788686e+01,
		4.320928537788870e+01,		4.328333162398253e+01,		4.335724886319627e+01,		4.343103750093454e+01,		4.350469794098581e+01,
		4.357823058552947e+01,		4.365163583514293e+01,		4.372491408880855e+01,		4.379806574392070e+01,		4.387109119629273e+01,
		4.394399084016383e+01,		4.401676506820606e+01,		4.408941427153106e+01,		4.416193883969708e+01,		4.423433916071563e+01,
		4.430661562105838e+01,		4.437876860566387e+01,		4.445079849794426e+01,		4.452270567979199e+01,		4.459449053158654e+01,
		4.466615343220099e+01,		4.473769475900864e+01,		4.480911488788963e+01,		4.488041419323755e+01,		4.495159304796584e+01,
		4.502265182351439e+01,		4.509359088985597e+01,		4.516441061550271e+01,		4.523511136751251e+01,		4.530569351149537e+01,
		4.537615741161989e+01,		4.544650343061943e+01,		4.551673192979857e+01,		4.558684326903926e+01,		4.565683780680725e+01,
		4.572671590015810e+01,		4.579647790474352e+01,		4.586612417481749e+01,		4.593565506324248e+01,		4.600507092149540e+01,
		4.607437209967392e+01,		4.614355894650232e+01,		4.621263180933764e+01,		4.628159103417570e+01,		4.635043696565701e+01,
		4.641916994707280e+01,		4.648779032037091e+01,		4.655629842616174e+01,		4.662469460372404e+01,		4.669297919101090e+01,
		4.676115252465544e+01,		4.682921493997669e+01,		4.689716677098538e+01,		4.696500835038960e+01,		4.703274000960065e+01,
		4.710036207873866e+01,		4.716787488663825e+01,		4.723527876085423e+01,		4.730257402766723e+01,		4.736976101208925e+01,
		4.743684003786925e+01,		4.750381142749874e+01,		4.757067550221726e+01,		4.763743258201792e+01,		4.770408298565280e+01,
		4.777062703063849e+01,		4.783706503326148e+01,		4.790339730858356e+01,		4.796962417044721e+01,		4.803574593148095e+01,
		4.810176290310461e+01,		4.816767539553482e+01,		4.823348371779003e+01,		4.829918817769599e+01,		4.836478908189090e+01,
		4.843028673583058e+01,		4.849568144379376e+01,		4.856097350888717e+01,		4.862616323305070e+01,		4.869125091706250e+01,
		4.875623686054416e+01,		4.882112136196564e+01,		4.888590471865045e+01,		4.895058722678066e+01,		4.901516918140180e+01,
		4.907965087642799e+01,		4.914403260464675e+01,		4.920831465772410e+01,		4.927249732620928e+01,		4.933658089953989e+01,
		4.940056566604650e+01,		4.946445191295768e+01,		4.952823992640475e+01,		4.959192999142660e+01,		4.965552239197452e+01,
		4.971901741091683e+01,		4.978241533004379e+01,		4.984571643007215e+01,		4.990892099065002e+01,		4.997202929036142e+01,
		5.003504160673090e+01,		5.009795821622836e+01,		5.016077939427349e+01,		5.022350541524038e+01,		5.028613655246219e+01,
		5.034867307823556e+01,		5.041111526382531e+01,		5.047346337946873e+01,		5.053571769438029e+01,		5.059787847675594e+01,
		5.065994599377766e+01,		5.072192051161782e+01,		5.078380229544363e+01,		5.084559160942145e+01,		5.090728871672127e+01,
		5.096889387952098e+01,		5.103040735901072e+01,		5.109182941539719e+01,		5.115316030790787e+01,		5.121440029479538e+01
	},
	{
		8.598289782896683e-02,		2.578083150255587e-01,		4.292174122617929e-01,		6.002110509804480e-01,		7.707900672010114e-01,
		9.409552736222493e-01,		1.110707461619383e+00,		1.280047403140208e+00,		1.448975852504323e+00,		1.617493548109460e+00,
		1.785601214048740e+00,		1.953299561642540e+00,		2.120589290888493e+00,		2.287471091833014e+00,		2.453945645867609e+00,
		2.620013626953110e+00,		2.785675702774832e+00,		2.950932535831558e+00,		3.115784784461139e+00,		3.280233103805392e+00,
		3.444278146716873e+00,		3.607920564610009e+00,		3.771161008259000e+00,		3.934000128544757e+00,		4.096438577153132e+00,
		4.258477007226549e+00,		4.420116073971130e+00,		4.581356435221228e+00,		4.742198751963357e+00,		4.902643688821303e+00,
		5.062691914504202e+00,		5.222344102219280e+00,		5.381600930050910e+00,		5.540463081307566e+00,		5.698931244838173e+00,
		5.857006115319333e+00,		6.014688393514850e+00,		6.171978786508854e+00,		6.328878007913929e+00,		6.485386778055377e+00,
		6.641505824132906e+00,		6.797235880360909e+00,		6.952577688088377e+00,		7.107531995899591e+00,		7.262099559696575e+00,
		7.416281142764340e+00,		7.570077515819831e+00,		7.723489457045491e+00,		7.876517752108374e+00,		8.029163194165548e+00,
		8.181426583856691e+00,		8.333308729284584e+00,		8.484810445984273e+00,		8.635932556881619e+00,		8.786675892241854e+00,
		8.937041289608889e+00,		9.087029593735897e+00,		9.236641656507844e+00,		9.385878336856484e+00,		9.534740500668407e+00,
		9.683229020686600e+00,		9.831344776406072e+00,		9.979088653964009e+00,		1.012646154602486e+01,		1.027346435166087e+01,
		1.042009797622833e+01,		1.056636333124019e+01,		1.071226133423505e+01,		1.085779290864317e+01,		1.100295898364981e+01,
		1.114776049405596e+01,		1.129219838013716e+01,		1.143627358750031e+01,		1.157998706693907e+01,		1.172333977428783e+01,
		1.186633267027471e+01,		1.200896672037370e+01,		1.215124289465620e+01,		1.229316216764212e+01,		1.243472551815088e+01,
		1.257593392915221e+01,		1.271678838761727e+01,		1.285728988436998e+01,		1.299743941393883e+01,		1.313723797440928e+01,
		1.327668656727694e+01,		1.341578619730154e+01,		1.355453787236198e+01,		1.369294260331230e+01,		1.383100140383904e+01,
		1.396871529031967e+01,		1.410608528168257e+01,		1.424311239926828e+01,		1.437979766669246e+01,		1.451614210971022e+01,
		1.465214675608228e+01,		1.478781263544274e+01,		1.492314077916858e+01,		1.505813222025108e+01,		1.519278799316891e+01,
		1.532710913376327e+01,		1.546109667911482e+01,		1.559475166742260e+01,		1.572807513788487e+01,		1.586106813058205e+01,
		1.599373168636152e+01,		1.612606684672450e+01,		1.625807465371501e+01,		1.638975614981080e+01,		1.652111237781633e+01,
		1.665214438075782e+01,		1.678285320178038e+01,		1.691323988404713e+01,		1.704330547064040e+01,		1.717305100446493e+01,
		1.730247752815317e+01,		1.743158608397255e+01,		1.756037771373481e+01,		1.768885345870724e+01,		1.781701435952603e+01,
		1.794486145611154e+01,		1.807239578758548e+01,		1.819961839219007e+01,		1.832653030720922e+01,		1.845313256889137e+01,
		1.857942621237448e+01,		1.870541227161272e+01,		1.883109177930507e+01,		1.895646576682567e+01,		1.908153526415605e+01,
		1.920630129981910e+01,		1.933076490081474e+01,		1.945492709255740e+01,		1.957878889881511e+01,		1.970235134165041e+01,
		1.982561544136265e+01,		1.994858221643226e+01,		2.007125268346631e+01,		2.019362785714578e+01,		2.031570875017443e+01,
		2.043749637322908e+01,		2.055899173491142e+01,		2.068019584170132e+01,		2.080110969791158e+01,		2.092173430564402e+01,
		2.104207066474710e+01,		2.116211977277473e+01,		2.128188262494661e+01,		2.140136021410970e+01,		2.152055353070111e+01,
		2.163946356271222e+01,		2.175809129565394e+01,		2.187643771252336e+01,		2.199450379377146e+01,		2.211229051727198e+01,
		2.222979885829146e+01,		2.234702978946050e+01,		2.246398428074584e+01,		2.258066329942381e+01,		2.269706781005461e+01,
		2.281319877445773e+01,		2.292905715168830e+01,		2.304464389801445e+01,		2.315995996689558e+01,		2.327500630896168e+01,
		2.338978387199337e+01,		2.350429360090299e+01,		2.361853643771650e+01,		2.373251332155622e+01,		2.384622518862441e+01,
		2.395967297218766e+01,		2.407285760256202e+01,		2.418578000709898e+01,		2.429844111017218e+01,		2.441084183316479e+01,
		2.452298309445762e+01,		2.463486580941800e+01,		2.474649089038928e+01,		2.485785924668098e+01,		2.496897178455959e+01,
		2.507982940724000e+01,		2.519043301487757e+01,		2.530078350456079e+01,		2.541088177030442e+01,		2.552072870304333e+01,
		2.563032519062681e+01,		2.573967211781343e+01,		2.584877036626645e+01,		2.595762081454964e+01,		2.606622433812370e+01,
		2.617458180934311e+01,		2.628269409745343e+01,		2.639056206858910e+01,		2.649818658577155e+01,		2.660556850890798e+01,
		2.671270869479026e+01,		2.681960799709444e+01,		2.692626726638061e+01,		2.703268735009302e+01,		2.713886909256078e+01,
		2.724481333499866e+01,		2.735052091550850e+01,		2.745599266908075e+01,		2.756122942759639e+01,		2.766623201982928e+01,
		2.777100127144863e+01,		2.787553800502189e+01,		2.797984304001793e+01,		2.808391719281039e+01,		2.818776127668142e+01,
		2.829137610182563e+01,		2.839476247535430e+01,		2.849792120129974e+01,		2.860085308062015e+01,		2.870355891120434e+01,
		2.880603948787698e+01,		2.890829560240391e+01,		2.901032804349768e+01,		2.911213759682337e+01,		2.921372504500438e+01,
		2.931509116762874e+01,		2.941623674125528e+01,		2.951716253942016e+01,		2.961786933264354e+01,		2.971835788843636e+01,
		2.981862897130727e+01,		2.991868334276976e+01,		3.001852176134949e+01,		3.011814498259154e+01,		3.021755375906806e+01,
		3.031674884038583e+01,		3.041573097319408e+01,		3.051450090119240e+01,		3.061305936513868e+01,		3.071140710285728e+01,
		3.080954484924721e+01,		3.090747333629050e+01,		3.100519329306056e+01,		3.110270544573068e+01,		3.120001051758265e+01,
		3.129710922901546e+01,		3.139400229755395e+01,		3.149069043785777e+01,		3.158717436173022e+01,		3.168345477812717e+01,
		3.177953239316623e+01,		3.187540791013570e+01,		3.197108202950387e+01,		3.206655544892809e+01,		3.216182886326418e+01,
		3.225690296457565e+01,		3.235177844214313e+01,		3.244645598247372e+01,		3.254093626931049e+01,		3.263521998364197e+01,
		3.272930780371165e+01,		3.282320040502758e+01,		3.291689846037193e+01,		3.301040263981066e+01,		3.310371361070315e+01,
		3.319683203771184e+01,		3.328975858281203e+01,		3.338249390530152e+01,		3.347503866181042e+01,		3.356739350631079e+01,
		3.365955909012663e+01,		3.375153606194344e+01,		3.384332506781820e+01,		3.393492675118908e+01,		3.402634175288535e+01,
		3.411757071113708e+01,		3.420861426158516e+01,		3.429947303729097e+01,		3.439014766874636e+01,		3.448063878388338e+01,
		3.457094700808423e+01,		3.466107296419103e+01,		3.475101727251569e+01,		3.484078055084984e+01,		3.493036341447446e+01,
		3.501976647616991e+01,		3.510899034622567e+01,		3.519803563245016e+01,		3.528690294018057e+01,		3.537559287229259e+01,
		3.546410602921033e+01,		3.555244300891594e+01,		3.564060440695950e+01,		3.572859081646865e+01,		3.581640282815852e+01,
		3.590404103034122e+01,		3.599150600893566e+01,		3.607879834747726e+01,		3.616591862712759e+01,		3.625286742668403e+01,
		3.633964532258936e+01,		3.642625288894145e+01,		3.651269069750287e+01,		3.659895931771031e+01,		3.668505931668435e+01,
		3.677099125923884e+01,		3.685675570789045e+01,		3.694235322286824e+01,		3.702778436212298e+01,		3.711304968133672e+01,
		3.719814973393213e+01,		3.728308507108197e+01,		3.736785624171841e+01,		3.745246379254236e+01,		3.753690826803282e+01,
		3.762119021045623e+01,		3.770531015987557e+01,		3.778926865415982e+01,		3.787306622899301e+01,		3.795670341788350e+01,
		3.804018075217304e+01,		3.812349876104609e+01,		3.820665797153870e+01,		3.828965890854774e+01,		3.837250209483989e+01,
		3.845518805106073e+01,		3.853771729574361e+01,		3.862009034531872e+01,		3.870230771412194e+01,		3.878436991440390e+01,
		3.886627745633864e+01,		3.894803084803259e+01,		3.902963059553340e+01,		3.911107720283862e+01,		3.919237117190458e+01,
		3.927351300265505e+01,		3.935450319298991e+01,		3.943534223879388e+01,		3.951603063394511e+01,		3.959656887032377e+01,
		3.967695743782074e+01,		3.975719682434594e+01,		3.983728751583707e+01,		3.991722999626792e+01,		3.999702474765693e+01,
		4.007667225007553e+01,		4.015617298165661e+01,		4.023552741860278e+01,		4.031473603519476e+01,		4.039379930379967e+01,
		4.047271769487929e+01,		4.055149167699826e+01,		4.063012171683233e+01,		4.070860827917648e+01,		4.078695182695311e+01,
		4.086515282122013e+01,		4.094321172117895e+01,		4.102112898418273e+01,		4.109890506574411e+01,		4.117654041954351e+01,
		4.125403549743677e+01,		4.133139074946330e+01,		4.140860662385386e+01,		4.148568356703845e+01,		4.156262202365410e+01,
		4.163942243655274e+01,		4.171608524680889e+01,		4.179261089372737e+01,		4.186899981485116e+01,		4.194525244596884e+01,
		4.202136922112245e+01,		4.209735057261495e+01,		4.217319693101781e+01,		4.224890872517869e+01,		4.232448638222882e+01,
		4.239993032759047e+01,		4.247524098498454e+01,		4.255041877643787e+01,		4.262546412229068e+01,		4.270037744120393e+01,
		4.277515915016664e+01,		4.284980966450323e+01,		4.292432939788068e+01,		4.299871876231599e+01,		4.307297816818315e+01,
		4.314710802422049e+01,		4.322110873753770e+01,		4.329498071362320e+01,		4.336872435635085e+01,		4.344234006798736e+01,
		4.351582824919915e+01,		4.358918929905939e+01,		4.366242361505495e+01,		4.373553159309346e+01,		4.380851362751002e+01,
		4.388137011107431e+01,		4.395410143499725e+01,		4.402670798893798e+01,		4.409919016101060e+01,		4.417154833779086e+01,
		4.424378290432312e+01,		4.431589424412678e+01,		4.438788273920316e+01,		4.445974877004215e+01,		4.453149271562873e+01,
		4.460311495344963e+01,		4.467461585949993e+01,		4.474599580828952e+01,		4.481725517284974e+01,		4.488839432473971e+01,
		4.495941363405286e+01,		4.503031346942347e+01,		4.510109419803284e+01,		4.517175618561591e+01,		4.524229979646737e+01,
		4.531272539344820e+01,		4.538303333799181e+01,		4.545322399011033e+01,		4.552329770840094e+01,		4.559325485005196e+01,
		4.566309577084913e+01,		4.573282082518162e+01,		4.580243036604838e+01,		4.587192474506408e+01,		4.594130431246517e+01,
		4.601056941711608e+01,		4.607972040651506e+01,		4.614875762680039e+01,		4.621768142275605e+01,		4.628649213781802e+01,
		4.635519011407988e+01,		4.642377569229892e+01,		4.649224921190188e+01,		4.656061101099086e+01,		4.662886142634910e+01,
		4.669700079344677e+01,		4.676502944644675e+01,		4.683294771821036e+01,		4.690075594030304e+01,		4.696845444300009e+01,
		4.703604355529234e+01,		4.710352360489169e+01,		4.717089491823680e+01,		4.723815782049869e+01,		4.730531263558625e+01,
		4.737235968615182e+01,		4.743929929359668e+01,		4.750613177807652e+01,		4.757285745850693e+01,		4.763947665256885e+01,
		4.770598967671397e+01,		4.777239684617008e+01,		4.783869847494652e+01,		4.790489487583948e+01,		4.797098636043727e+01,
		4.803697323912571e+01,		4.810285582109331e+01,		4.816863441433663e+01,		4.823430932566536e+01,		4.829988086070765e+01,
		4.836534932391518e+01,		4.843071501856843e+01,		4.849597824678173e+01,		4.856113930950832e+01,		4.862619850654563e+01,
		4.869115613654009e+01,		4.875601249699237e+01,		4.882076788426230e+01,		4.888542259357386e+01,		4.894997691902022e+01,
		4.901443115356863e+01,		4.907878558906531e+01,		4.914304051624052e+01,		4.920719622471319e+01,		4.927125300299608e+01,
		4.933521113850028e+01,		4.939907091754030e+01,		4.946283262533884e+01,		4.952649654603134e+01,		4.959006296267099e+01,
		4.965353215723331e+01,		4.971690441062094e+01,		4.978018000266822e+01,		4.984335921214604e+01,		4.990644231676620e+01,
		4.996942959318636e+01,		5.003232131701444e+01,		5.009511776281320e+01,		5.015781920410489e+01,		5.022042591337574e+01,
		5.028293816208045e+01,		5.034535622064683e+01,		5.040768035848007e+01,		5.046991084396730e+01,		5.053204794448213e+01,
		5.059409192638887e+01,		5.065604305504704e+01,		5.071790159481577e+01,		5.077966780905812e+01,		5.084134196014533e+01,
		5.090292430946131e+01,		5.096441511740685e+01,		5.102581464340382e+01,		5.108712314589960e+01,		5.114834088237114e+01
	},
	{
		8.579936440854345e-02,		2.572583760128868e-01,		4.283024410556641e-01,		5.989324222445281e-01,		7.691491570871807e-01,
		9.389534599674841e-01,		1.108346124117661e+00,		1.277327923490854e+00,		1.445899614538153e+00,		1.614061937894012e+00,
		1.781815619973833e+00,		1.949161374487346e+00,		2.116099903871233e+00,		2.282631900644384e+00,		2.448758048688941e+00,
		2.614479024460262e+00,		2.779795498128743e+00,		2.944708134656368e+00,		3.109217594810726e+00,		3.273324536119136e+00,
		3.437029613765435e+00,		3.600333481431860e+00,		3.763236792088401e+00,		3.925740198731872e+00,		4.087844355076915e+00,
		4.249549916201008e+00,		4.410857539145537e+00,		4.571767883474862e+00,		4.732281611795257e+00,		4.892399390235560e+00,
		5.052121888891254e+00,		5.211449782233643e+00,		5.370383749485796e+00,		5.528924474966757e+00,		5.687072648405546e+00,
		5.844828965226408e+00,		6.002194126806658e+00,		6.159168840708511e+00,		6.315753820886131e+00,		6.471949787869166e+00,
		6.627757468923963e+00,		6.783177598193586e+00,		6.938210916817744e+00,		7.092858173033702e+00,		7.247120122259159e+00,
		7.400997527158094e+00,		7.554491157690522e+00,		7.707601791147016e+00,		7.860330212168928e+00,		8.012677212755055e+00,
		8.164643592255628e+00,		8.316230157354310e+00,		8.467437722038982e+00,		8.618267107562017e+00,		8.768719142390683e+00,
		8.918794662148301e+00,		9.068494509546854e+00,		9.217819534311570e+00,		9.366770593098005e+00,		9.515348549402274e+00,
		9.663554273464824e+00,		9.811388642168335e+00,		9.958852538930159e+00,		1.010594685358972e+01,		1.025267248229143e+01,
		1.039903032736331e+01,		1.054502129719195e+01,		1.069064630609395e+01,		1.083590627418437e+01,		1.098080212724238e+01,
		1.112533479657453e+01,		1.126950521887585e+01,		1.141331433608923e+01,		1.155676309526303e+01,		1.169985244840761e+01,
		1.184258335235058e+01,		1.198495676859135e+01,		1.212697366315499e+01,		1.226863500644567e+01,		1.240994177309989e+01,
		1.255089494183962e+01,		1.269149549532564e+01,		1.283174442001103e+01,		1.297164270599522e+01,		1.311119134687858e+01,
		1.325039133961761e+01,		1.338924368438114e+01,		1.352774938440728e+01,		1.366590944586159e+01,		1.380372487769627e+01,
		1.394119669151068e+01,		1.407832590141315e+01,		1.421511352388418e+01,		1.435156057764115e+01,		1.448766808350459e+01,
		1.462343706426604e+01,		1.475886854455756e+01,		1.489396355072298e+01,		1.502872311069092e+01,		1.516314825384958e+01,
		1.529724001092340e+01,		1.543099941385164e+01,		1.556442749566871e+01,		1.569752529038661e+01,		1.583029383287921e+01,
		1.596273415876855e+01,		1.609484730431308e+01,		1.622663430629790e+01,		1.635809620192709e+01,		1.648923402871790e+01,
		1.662004882439708e+01,		1.675054162679921e+01,		1.688071347376698e+01,		1.701056540305352e+01,		1.714009845222677e+01,
		1.726931365857585e+01,		1.739821205901929e+01,		1.752679469001548e+01,		1.765506258747487e+01,		1.778301678667426e+01,
		1.791065832217302e+01,		1.803798822773116e+01,		1.816500753622940e+01,		1.829171727959113e+01,		1.841811848870612e+01,
		1.854421219335635e+01,		1.866999942214337e+01,		1.879548120241768e+01,		1.892065856020986e+01,		1.904553252016341e+01,
		1.917010410546943e+01,		1.929437433780299e+01,		1.941834423726113e+01,		1.954201482230269e+01,		1.966538710968961e+01,
		1.978846211443007e+01,		1.991124084972299e+01,		2.003372432690438e+01,		2.015591355539499e+01,		2.027780954264964e+01,
		2.039941329410802e+01,		2.052072581314699e+01,		2.064174810103420e+01,		2.076248115688336e+01,		2.088292597761070e+01,
		2.100308355789293e+01,		2.112295489012650e+01,		2.124254096438822e+01,		2.136184276839709e+01,		2.148086128747753e+01,
		2.159959750452375e+01,		2.171805239996544e+01,		2.183622695173451e+01,		2.195412213523323e+01,		2.207173892330327e+01,
		2.218907828619605e+01,		2.230614119154415e+01,		2.242292860433368e+01,		2.253944148687792e+01,		2.265568079879182e+01,
		2.277164749696755e+01,		2.288734253555110e+01,		2.300276686591976e+01,		2.311792143666062e+01,		2.323280719354990e+01,
		2.334742507953332e+01,		2.346177603470721e+01,		2.357586099630054e+01,		2.368968089865781e+01,		2.380323667322271e+01,
		2.391652924852267e+01,		2.402955955015404e+01,		2.414232850076815e+01,		2.425483702005814e+01,		2.436708602474636e+01,
		2.447907642857266e+01,		2.459080914228325e+01,		2.470228507362019e+01,		2.481350512731175e+01,		2.492447020506316e+01,
		2.503518120554812e+01,		2.514563902440089e+01,		2.525584455420893e+01,		2.536579868450619e+01,		2.547550230176687e+01,
		2.558495628939978e+01,		2.569416152774325e+01,		2.580311889406044e+01,		2.591182926253534e+01,		2.602029350426902e+01,
		2.612851248727662e+01,		2.623648707648452e+01,		2.634421813372822e+01,		2.645170651775047e+01,		2.655895308419987e+01,
		2.666595868562993e+01,		2.677272417149851e+01,		2.687925038816759e+01,		2.698553817890349e+01,		2.709158838387736e+01,
		2.719740184016618e+01,		2.730297938175394e+01,		2.740832183953324e+01,		2.751343004130720e+01,		2.761830481179167e+01,
		2.772294697261776e+01,		2.782735734233465e+01,		2.793153673641270e+01,		2.803548596724681e+01,		2.813920584416004e+01,
		2.824269717340761e+01,		2.834596075818095e+01,		2.844899739861212e+01,		2.855180789177851e+01,		2.865439303170759e+01,
		2.875675360938206e+01,		2.885889041274512e+01,		2.896080422670596e+01,		2.906249583314546e+01,		2.916396601092206e+01,
		2.926521553587786e+01,		2.936624518084478e+01,		2.946705571565110e+01,		2.956764790712794e+01,		2.966802251911608e+01,
		2.976818031247279e+01,		2.986812204507891e+01,		2.996784847184603e+01,		3.006736034472382e+01,		3.016665841270750e+01,
		3.026574342184538e+01,		3.036461611524662e+01,		3.046327723308899e+01,		3.056172751262691e+01,		3.065996768819936e+01,
		3.075799849123812e+01,		3.085582065027602e+01,		3.095343489095522e+01,		3.105084193603569e+01,		3.114804250540376e+01,
		3.124503731608064e+01,		3.134182708223114e+01,		3.143841251517247e+01,		3.153479432338306e+01,		3.163097321251136e+01,
		3.172694988538500e+01,		3.182272504201958e+01,		3.191829937962800e+01,		3.201367359262940e+01,		3.210884837265850e+01,
		3.220382440857478e+01,		3.229860238647176e+01,		3.239318298968639e+01,		3.248756689880840e+01,		3.258175479168975e+01,
		3.267574734345403e+01,		3.276954522650602e+01,		3.286314911054118e+01,		3.295655966255519e+01,		3.304977754685356e+01,
		3.314280342506126e+01,		3.323563795613229e+01,		3.332828179635935e+01,		3.342073559938361e+01,		3.351300001620424e+01,
		3.360507569518824e+01,		3.369696328208008e+01,		3.378866342001154e+01,		3.388017674951134e+01,		3.397150390851491e+01,
		3.406264553237428e+01,		3.415360225386767e+01,		3.424437470320934e+01,		3.433496350805942e+01,		3.442536929353361e+01,
		3.451559268221296e+01,		3.460563429415368e+01,		3.469549474689694e+01,		3.478517465547855e+01,		3.487467463243881e+01,
		3.496399528783225e+01,		3.505313722923735e+01,		3.514210106176635e+01,		3.523088738807494e+01,		3.531949680837204e+01,
		3.540792992042941e+01,		3.549618731959150e+01,		3.558426959878508e+01,		3.567217734852886e+01,		3.575991115694329e+01,
		3.584747160976008e+01,		3.593485929033196e+01,		3.602207477964220e+01,		3.610911865631426e+01,		3.619599149662142e+01,
		3.628269387449625e+01,		3.636922636154022e+01,		3.645558952703327e+01,		3.654178393794324e+01,		3.662781015893538e+01,
		3.671366875238186e+01,		3.679936027837120e+01,		3.688488529471766e+01,		3.697024435697067e+01,		3.705543801842426e+01,
		3.714046683012628e+01,		3.722533134088785e+01,		3.731003209729263e+01,		3.739456964370614e+01,		3.747894452228491e+01,
		3.756315727298584e+01,		3.764720843357530e+01,		3.773109853963839e+01,		3.781482812458805e+01,		3.789839771967421e+01,
		3.798180785399281e+01,		3.806505905449503e+01,		3.814815184599617e+01,		3.823108675118475e+01,		3.831386429063152e+01,
		3.839648498279833e+01,		3.847894934404715e+01,		3.856125788864894e+01,		3.864341112879247e+01,		3.872540957459328e+01,
		3.880725373410240e+01,		3.888894411331515e+01,		3.897048121617996e+01,		3.905186554460700e+01,		3.913309759847695e+01,
		3.921417787564962e+01,		3.929510687197264e+01,		3.937588508129001e+01,		3.945651299545069e+01,		3.953699110431722e+01,
		3.961731989577408e+01,		3.969749985573633e+01,		3.977753146815798e+01,		3.985741521504043e+01,		3.993715157644086e+01,
		4.001674103048063e+01,		4.009618405335350e+01,		4.017548111933414e+01,		4.025463270078610e+01,		4.033363926817039e+01,
		4.041250129005333e+01,		4.049121923311507e+01,		4.056979356215749e+01,		4.064822474011238e+01,		4.072651322804958e+01,
		4.080465948518503e+01,		4.088266396888862e+01,		4.096052713469243e+01,		4.103824943629855e+01,		4.111583132558697e+01,
		4.119327325262359e+01,		4.127057566566801e+01,		4.134773901118137e+01,		4.142476373383423e+01,		4.150165027651416e+01,
		4.157839908033371e+01,		4.165501058463797e+01,		4.173148522701230e+01,		4.180782344328993e+01,		4.188402566755971e+01,
		4.196009233217352e+01,		4.203602386775393e+01,		4.211182070320177e+01,		4.218748326570346e+01,		4.226301198073872e+01,
		4.233840727208772e+01,		4.241366956183873e+01,		4.248879927039538e+01,		4.256379681648395e+01,		4.263866261716088e+01,
		4.271339708781976e+01,		4.278800064219890e+01,		4.286247369238832e+01,		4.293681664883702e+01,		4.301102992036022e+01,
		4.308511391414633e+01,		4.315906903576419e+01,		4.323289568917012e+01,		4.330659427671492e+01,		4.338016519915087e+01,
		4.345360885563883e+01,		4.352692564375509e+01,		4.360011595949830e+01,		4.367318019729641e+01,		4.374611875001354e+01,
		4.381893200895683e+01,		4.389162036388309e+01,		4.396418420300589e+01,		4.403662391300202e+01,		4.410893987901836e+01,
		4.418113248467857e+01,		4.425320211208972e+01,		4.432514914184890e+01,		4.439697395304994e+01,		4.446867692328989e+01,
		4.454025842867558e+01,		4.461171884383021e+01,		4.468305854189979e+01,		4.475427789455965e+01,		4.482537727202083e+01,
		4.489635704303650e+01,		4.496721757490847e+01,		4.503795923349331e+01,		4.510858238320893e+01,		4.517908738704072e+01,
		4.524947460654787e+01,		4.531974440186968e+01,		4.538989713173160e+01,		4.545993315345174e+01,		4.552985282294669e+01,
		4.559965649473792e+01,		4.566934452195775e+01,		4.573891725635546e+01,		4.580837504830346e+01,		4.587771824680313e+01,
		4.594694719949101e+01,		4.601606225264471e+01,		4.608506375118883e+01,		4.615395203870087e+01,		4.622272745741736e+01,
		4.629139034823937e+01,		4.635994105073869e+01,		4.642837990316343e+01,		4.649670724244399e+01,		4.656492340419869e+01,
		4.663302872273962e+01,		4.670102353107834e+01,		4.676890816093154e+01,		4.683668294272672e+01,		4.690434820560796e+01,
		4.697190427744130e+01,		4.703935148482061e+01,		4.710669015307298e+01,		4.717392060626429e+01,		4.724104316720481e+01,
		4.730805815745467e+01,		4.737496589732930e+01,		4.744176670590488e+01,		4.750846090102387e+01,		4.757504879930023e+01,
		4.764153071612498e+01,		4.770790696567144e+01,		4.777417786090064e+01,		4.784034371356650e+01,		4.790640483422128e+01,
		4.797236153222073e+01,		4.803821411572932e+01,		4.810396289172554e+01,		4.816960816600700e+01,		4.823515024319564e+01,
		4.830058942674282e+01,		4.836592601893462e+01,		4.843116032089663e+01,		4.849629263259927e+01,		4.856132325286283e+01,
		4.862625247936230e+01,		4.869108060863262e+01,		4.875580793607350e+01,		4.882043475595445e+01,		4.888496136141971e+01,
		4.894938804449314e+01,		4.901371509608315e+01,		4.907794280598752e+01,		4.914207146289837e+01,		4.920610135440683e+01,
		4.927003276700793e+01,		4.933386598610542e+01,		4.939760129601639e+01,		4.946123897997623e+01,		4.952477932014317e+01,
		4.958822259760304e+01,		4.965156909237396e+01,		4.971481908341097e+01,		4.977797284861069e+01,		4.984103066481592e+01,
		4.990399280782020e+01,		4.996685955237250e+01,		5.002963117218164e+01,		5.009230793992083e+01,		5.015489012723229e+01,
		5.021737800473167e+01,		5.027977184201246e+01,		5.034207190765057e+01,		5.040427846920862e+01,		5.046639179324048e+01,
		5.052841214529557e+01,		5.059033978992325e+01,		5.065217499067716e+01,		5.071391801011963e+01,		5.077556910982584e+01,
		5.083712855038822e+01,		5.089859659142072e+01,		5.095997349156297e+01,		5.102125950848467e+01,		5.108245489888960e+01
	},
	{
		8.561661313417648e-02,		2.567107808591731e-01,		4.273913698360732e-01,		5.976592439691960e-01,		7.675152421835999e-01,
		9.369601804751236e-01,		1.105994853857972e+00,		1.274620038214066e+00,		1.442836492048179e+00,		1.610644958152752e+00,
		1.778046165186083e+00,		1.945040829167475e+00,		2.111629654892751e+00,		2.277813337273439e+00,		2.443592562602789e+00,
		2.608968009751651e+00,		2.773940351297152e+00,		2.938510254586975e+00,		3.102678382741940e+00,		3.266445395599526e+00,
		3.429811950600775e+00,		3.592778703623063e+00,		3.755346309761014e+00,		3.917515424057797e+00,		4.079286702188990e+00,
		4.240660801101053e+00,		4.401638379606428e+00,		4.562220098937166e+00,		4.722406623258978e+00,		4.882198620147448e+00,
		5.041596761028149e+00,		5.200601721582325e+00,		5.359214182119713e+00,		5.517434827920050e+00,		5.675264349544764e+00,
		5.832703443120208e+00,		5.989752810593888e+00,		6.146413159964952e+00,		6.302685205490200e+00,		6.458569667866881e+00,
		6.614067274393390e+00,		6.769178759109060e+00,		6.923904862914071e+00,		7.078246333670551e+00,		7.232203926285869e+00,
		7.385778402779073e+00,		7.538970532331419e+00,		7.691781091321814e+00,		7.844210863348132e+00,		7.996260639235114e+00,
		8.147931217029702e+00,		8.299223401984522e+00,		8.450138006530262e+00,		8.600675850237630e+00,		8.750837759769531e+00,
		8.900624568824130e+00,		9.050037118069371e+00,		9.199076255069569e+00,		9.347742834204601e+00,		9.496037716582222e+00,
		9.643961769944070e+00,		9.791515868565726e+00,		9.938700893151465e+00,		1.008551773072391e+01,		1.023196727450927e+01,
		1.037805042381831e+01,		1.052376808392363e+01,		1.066912116593353e+01,		1.081411058666273e+01,		1.095873726850051e+01,
		1.110300213927627e+01,		1.124690613212310e+01,		1.139045018533939e+01,		1.153363524224893e+01,		1.167646225105972e+01,
		1.181893216472157e+01,		1.196104594078299e+01,		1.210280454124733e+01,		1.224420893242847e+01,		1.238526008480637e+01,
		1.252595897288243e+01,		1.266630657503497e+01,		1.280630387337501e+01,		1.294595185360241e+01,		1.308525150486254e+01,
		1.322420381960369e+01,		1.336280979343520e+01,		1.350107042498655e+01,		1.363898671576744e+01,		1.377655967002901e+01,
		1.391379029462623e+01,		1.405067959888165e+01,		1.418722859445045e+01,		1.432343829518697e+01,		1.445930971701277e+01,
		1.459484387778623e+01,		1.473004179717380e+01,		1.486490449652292e+01,		1.499943299873670e+01,		1.513362832815028e+01,
		1.526749151040913e+01,		1.540102357234907e+01,		1.553422554187821e+01,		1.566709844786080e+01,		1.579964332000294e+01,
		1.593186118874026e+01,		1.606375308512759e+01,		1.619532004073047e+01,		1.632656308751876e+01,		1.645748325776217e+01,
		1.658808158392775e+01,		1.671835909857942e+01,		1.684831683427941e+01,		1.697795582349179e+01,		1.710727709848783e+01,
		1.723628169125348e+01,		1.736497063339874e+01,		1.749334495606892e+01,		1.762140568985800e+01,		1.774915386472377e+01,
		1.787659050990499e+01,		1.800371665384036e+01,		1.813053332408949e+01,		1.825704154725560e+01,		1.838324234891021e+01,
		1.850913675351954e+01,		1.863472578437283e+01,		1.876001046351234e+01,		1.888499181166525e+01,		1.900967084817715e+01,
		1.913404859094741e+01,		1.925812605636619e+01,		1.938190425925305e+01,		1.950538421279740e+01,		1.962856692850039e+01,
		1.975145341611852e+01,		1.987404468360885e+01,		1.999634173707566e+01,		2.011834558071877e+01,		2.024005721678329e+01,
		2.036147764551085e+01,		2.048260786509233e+01,		2.060344887162208e+01,		2.072400165905338e+01,		2.084426721915540e+01,
		2.096424654147156e+01,		2.108394061327911e+01,		2.120335041955008e+01,		2.132247694291355e+01,		2.144132116361907e+01,
		2.155988405950141e+01,		2.167816660594649e+01,		2.179616977585855e+01,		2.191389453962832e+01,		2.203134186510249e+01,
		2.214851271755429e+01,		2.226540805965501e+01,		2.238202885144675e+01,		2.249837605031620e+01,		2.261445061096925e+01,
		2.273025348540691e+01,		2.284578562290194e+01,		2.296104796997655e+01,		2.307604147038109e+01,		2.319076706507351e+01,
		2.330522569219984e+01,		2.341941828707545e+01,		2.353334578216726e+01,		2.364700910707668e+01,		2.376040918852343e+01,
		2.387354695033011e+01,		2.398642331340760e+01,		2.409903919574112e+01,		2.421139551237715e+01,		2.432349317541098e+01,
		2.443533309397493e+01,		2.454691617422741e+01,		2.465824331934244e+01,		2.476931542949998e+01,		2.488013340187681e+01,
		2.499069813063809e+01,		2.510101050692938e+01,		2.521107141886947e+01,		2.532088175154355e+01,		2.543044238699710e+01,
		2.553975420423021e+01,		2.564881807919251e+01,		2.575763488477854e+01,		2.586620549082365e+01,		2.597453076410043e+01,
		2.608261156831545e+01,		2.619044876410672e+01,		2.629804320904128e+01,		2.640539575761353e+01,		2.651250726124371e+01,
		2.661937856827698e+01,		2.672601052398283e+01,		2.683240397055480e+01,		2.693855974711074e+01,		2.704447868969326e+01,
		2.715016163127061e+01,		2.725560940173798e+01,		2.736082282791891e+01,		2.746580273356729e+01,		2.757054993936947e+01,
		2.767506526294676e+01,		2.777934951885819e+01,		2.788340351860358e+01,		2.798722807062690e+01,		2.809082398031980e+01,
		2.819419205002553e+01,		2.829733307904301e+01,		2.840024786363118e+01,		2.850293719701361e+01,		2.860540186938322e+01,
		2.870764266790743e+01,		2.880966037673325e+01,		2.891145577699284e+01,		2.901302964680909e+01,		2.911438276130144e+01,
		2.921551589259187e+01,		2.931642980981117e+01,		2.941712527910517e+01,		2.951760306364137e+01,		2.961786392361559e+01,
		2.971790861625875e+01,		2.981773789584390e+01,		2.991735251369337e+01,		3.001675321818596e+01,		3.011594075476438e+01,
		3.021491586594274e+01,		3.031367929131421e+01,		3.041223176755878e+01,		3.051057402845112e+01,		3.060870680486851e+01,
		3.070663082479902e+01,		3.080434681334962e+01,		3.090185549275444e+01,		3.099915758238317e+01,		3.109625379874952e+01,
		3.119314485551972e+01,		3.128983146352116e+01,		3.138631433075106e+01,		3.148259416238523e+01,		3.157867166078692e+01,
		3.167454752551575e+01,		3.177022245333653e+01,		3.186569713822846e+01,		3.196097227139408e+01,		3.205604854126837e+01,
		3.215092663352812e+01,		3.224560723110089e+01,		3.234009101417448e+01,		3.243437866020614e+01,		3.252847084393197e+01,
		3.262236823737625e+01,		3.271607150986093e+01,		3.280958132801504e+01,		3.290289835578417e+01,		3.299602325444000e+01,
		3.308895668258987e+01,		3.318169929618625e+01,		3.327425174853641e+01,		3.336661469031198e+01,		3.345878876955859e+01,
		3.355077463170548e+01,		3.364257291957519e+01,		3.373418427339317e+01,		3.382560933079750e+01,		3.391684872684858e+01,
		3.400790309403875e+01,		3.409877306230209e+01,		3.418945925902403e+01,		3.427996230905113e+01,		3.437028283470069e+01,
		3.446042145577057e+01,		3.455037878954887e+01,		3.464015545082354e+01,		3.472975205189223e+01,		3.481916920257184e+01,
		3.490840751020836e+01,		3.499746757968644e+01,		3.508635001343913e+01,		3.517505541145755e+01,		3.526358437130049e+01,
		3.535193748810416e+01,		3.544011535459175e+01,		3.552811856108310e+01,		3.561594769550430e+01,		3.570360334339727e+01,
		3.579108608792941e+01,		3.587839650990311e+01,		3.596553518776533e+01,		3.605250269761713e+01,		3.613929961322319e+01,
		3.622592650602138e+01,		3.631238394513205e+01,		3.639867249736782e+01,		3.648479272724266e+01,		3.657074519698159e+01,
		3.665653046652995e+01,		3.674214909356281e+01,		3.682760163349437e+01,		3.691288863948724e+01,		3.699801066246177e+01,
		3.708296825110538e+01,		3.716776195188178e+01,		3.725239230904021e+01,		3.733685986462473e+01,		3.742116515848331e+01,
		3.750530872827713e+01,		3.758929110948956e+01,		3.767311283543540e+01,		3.775677443726997e+01,		3.784027644399808e+01,
		3.792361938248315e+01,		3.800680377745621e+01,		3.808983015152483e+01,		3.817269902518214e+01,		3.825541091681573e+01,
		3.833796634271656e+01,		3.842036581708774e+01,		3.850260985205359e+01,		3.858469895766817e+01,		3.866663364192433e+01,
		3.874841441076224e+01,		3.883004176807829e+01,		3.891151621573370e+01,		3.899283825356319e+01,		3.907400837938366e+01,
		3.915502708900273e+01,		3.923589487622739e+01,		3.931661223287249e+01,		3.939717964876933e+01,		3.947759761177404e+01,
		3.955786660777611e+01,		3.963798712070689e+01,		3.971795963254778e+01,		3.979778462333881e+01,		3.987746257118680e+01,
		3.995699395227383e+01,		4.003637924086539e+01,		4.011561890931867e+01,		4.019471342809080e+01,		4.027366326574695e+01,
		4.035246888896856e+01,		4.043113076256144e+01,		4.050964934946384e+01,		4.058802511075456e+01,		4.066625850566088e+01,
		4.074434999156661e+01,		4.082230002402017e+01,		4.090010905674229e+01,		4.097777754163411e+01,		4.105530592878500e+01,
		4.113269466648034e+01,		4.120994420120940e+01,		4.128705497767313e+01,		4.136402743879183e+01,		4.144086202571295e+01,
		4.151755917781879e+01,		4.159411933273407e+01,		4.167054292633362e+01,		4.174683039274995e+01,		4.182298216438085e+01,
		4.189899867189693e+01,		4.197488034424906e+01,		4.205062760867592e+01,		4.212624089071136e+01,		4.220172061419193e+01,
		4.227706720126419e+01,		4.235228107239203e+01,		4.242736264636410e+01,		4.250231234030102e+01,		4.257713056966261e+01,
		4.265181774825525e+01,		4.272637428823904e+01,		4.280080060013485e+01,		4.287509709283164e+01,		4.294926417359347e+01,
		4.302330224806661e+01,		4.309721172028659e+01,		4.317099299268524e+01,		4.324464646609770e+01,		4.331817253976936e+01,
		4.339157161136277e+01,		4.346484407696462e+01,		4.353799033109258e+01,		4.361101076670212e+01,		4.368390577519342e+01,
		4.375667574641804e+01,		4.382932106868579e+01,		4.390184212877147e+01,		4.397423931192146e+01,		4.404651300186049e+01,
		4.411866358079829e+01,		4.419069142943620e+01,		4.426259692697372e+01,		4.433438045111513e+01,		4.440604237807604e+01,
		4.447758308258982e+01,		4.454900293791412e+01,		4.462030231583739e+01,		4.469148158668519e+01,		4.476254111932666e+01,
		4.483348128118084e+01,		4.490430243822316e+01,		4.497500495499148e+01,		4.504558919459264e+01,		4.511605551870863e+01,
		4.518640428760275e+01,		4.525663586012588e+01,		4.532675059372274e+01,		4.539674884443787e+01,		4.546663096692190e+01,
		4.553639731443755e+01,		4.560604823886582e+01,		4.567558409071192e+01,		4.574500521911128e+01,		4.581431197183574e+01,
		4.588350469529919e+01,		4.595258373456389e+01,		4.602154943334603e+01,		4.609040213402189e+01,		4.615914217763359e+01,
		4.622776990389481e+01,		4.629628565119688e+01,		4.636468975661430e+01,		4.643298255591065e+01,		4.650116438354435e+01,
		4.656923557267422e+01,		4.663719645516523e+01,		4.670504736159434e+01,		4.677278862125578e+01,		4.684042056216700e+01,
		4.690794351107405e+01,		4.697535779345724e+01,		4.704266373353662e+01,		4.710986165427749e+01,		4.717695187739597e+01,
		4.724393472336436e+01,		4.731081051141663e+01,		4.737757955955380e+01,		4.744424218454940e+01,		4.751079870195482e+01,
		4.757724942610448e+01,		4.764359467012149e+01,		4.770983474592256e+01,		4.777596996422362e+01,		4.784200063454481e+01,
		4.790792706521584e+01,		4.797374956338111e+01,		4.803946843500500e+01,		4.810508398487688e+01,		4.817059651661643e+01,
		4.823600633267850e+01,		4.830131373435839e+01,		4.836651902179693e+01,		4.843162249398526e+01,		4.849662444877025e+01,
		4.856152518285912e+01,		4.862632499182464e+01,		4.869102417011003e+01,		4.875562301103377e+01,		4.882012180679472e+01,
		4.888452084847684e+01,		4.894882042605409e+01,		4.901302082839529e+01,		4.907712234326896e+01,		4.914112525734800e+01,
		4.920502985621468e+01,		4.926883642436515e+01,		4.933254524521438e+01,		4.939615660110066e+01,		4.945967077329050e+01,
		4.952308804198319e+01,		4.958640868631545e+01,		4.964963298436601e+01,		4.971276121316040e+01,		4.977579364867529e+01,
		4.983873056584322e+01,		4.990157223855705e+01,		4.996431893967461e+01,		5.002697094102302e+01,		5.008952851340332e+01,
		5.015199192659486e+01,		5.021436144935975e+01,		5.027663734944731e+01,		5.033881989359845e+01,		5.040090934754998e+01,
		5.046290597603918e+01,		5.052481004280781e+01,		5.058662181060682e+01,		5.064834154120032e+01,		5.070996949536996e+01,
		5.077150593291939e+01,		5.083295111267817e+01,		5.089430529250624e+01,		5.095556872929806e+01,		5.101674167898672e+01
	},
	{
		8.543463901463499e-02,		2.561655145933663e-01,		4.264841736700525e-01,		5.963914812787603e-01,		7.658882776923758e-01,
		9.349753804469553e-01,		1.103653586265061e+00,		1.271923672882230e+00,		1.439786400780546e+00,		1.607242514833140e+00,
		1.774292745863266e+00,		1.940937812121476e+00,		2.107178420684265e+00,		2.273015268777419e+00,		2.438449045027199e+00,
		2.603480430642338e+00,		2.768110100529750e+00,		2.932338724346702e+00,		3.096166967492128e+00,		3.259595492039658e+00,
		3.422624957614803e+00,		3.585256022218710e+00,		3.747489343000745e+00,		3.909325576982132e+00,		4.070765381732751e+00,
		4.231809416003154e+00,		4.392458340313770e+00,		4.552712817503167e+00,		4.712573513237239e+00,		4.872041096481055e+00,
		5.031116239935056e+00,		5.189799620437245e+00,		5.348091919332954e+00,		5.505993822813655e+00,		5.663506022226335e+00,
		5.820629214354783e+00,		5.977364101674161e+00,		6.133711392580172e+00,		6.289671801594043e+00,		6.445246049544541e+00,
		6.600434863728205e+00,		6.755238978048846e+00,		6.909659133137444e+00,		7.063696076453428e+00,		7.217350562368359e+00,
		7.370623352232945e+00,		7.523515214428289e+00,		7.676026924402273e+00,		7.828159264691911e+00,		7.979913024932456e+00,
		8.131289001854045e+00,		8.282287999266654e+00,		8.432910828034021e+00,		8.583158306037243e+00,		8.733031258128726e+00,
		8.882530516077059e+00,		9.031656918503453e+00,		9.180411310810305e+00,		9.328794545102415e+00,		9.476807480101424e+00,
		9.624450981053908e+00,		9.771725919633672e+00,		9.918633173838664e+00,		1.006517362788295e+01,		1.021134817208413e+01,
		1.035715770274670e+01,		1.050260312204159e+01,		1.064768533788235e+01,		1.079240526379825e+01,		1.093676381880468e+01,
		1.108076192727114e+01,		1.122440051878707e+01,		1.136768052802583e+01,		1.151060289460716e+01,		1.165316856295817e+01,
		1.179537848217343e+01,		1.193723360587396e+01,		1.207873489206575e+01,		1.221988330299771e+01,		1.236067980501933e+01,
		1.250112536843833e+01,		1.264122096737832e+01,		1.278096757963669e+01,		1.292036618654290e+01,		1.305941777281723e+01,
		1.319812332643025e+01,		1.333648383846301e+01,		1.347450030296809e+01,		1.361217371683170e+01,		1.374950507963679e+01,
		1.388649539352739e+01,		1.402314566307416e+01,		1.415945689514137e+01,		1.429543009875514e+01,		1.443106628497334e+01,
		1.456636646675685e+01,		1.470133165884256e+01,		1.483596287761793e+01,		1.497026114099728e+01,		1.510422746829979e+01,
		1.523786288012927e+01,		1.537116839825576e+01,		1.550414504549897e+01,		1.563679384561351e+01,		1.576911582317607e+01,
		1.590111200347446e+01,		1.603278341239862e+01,		1.616413107633345e+01,		1.629515602205374e+01,		1.642585927662084e+01,
		1.655624186728147e+01,		1.668630482136835e+01,		1.681604916620288e+01,		1.694547592899968e+01,		1.707458613677314e+01,
		1.720338081624589e+01,		1.733186099375919e+01,		1.746002769518524e+01,		1.758788194584147e+01,		1.771542477040663e+01,
		1.784265719283886e+01,		1.796958023629554e+01,		1.809619492305511e+01,		1.822250227444064e+01,		1.834850331074529e+01,
		1.847419905115946e+01,		1.859959051369993e+01,		1.872467871514056e+01,		1.884946467094488e+01,		1.897394939520029e+01,
		1.909813390055407e+01,		1.922201919815105e+01,		1.934560629757280e+01,		1.946889620677870e+01,		1.959188993204841e+01,
		1.971458847792604e+01,		1.983699284716582e+01,		1.995910404067941e+01,		2.008092305748455e+01,		2.020245089465542e+01,
		2.032368854727430e+01,		2.044463700838472e+01,		2.056529726894604e+01,		2.068567031778946e+01,		2.080575714157529e+01,
		2.092555872475167e+01,		2.104507604951456e+01,		2.116431009576900e+01,		2.128326184109171e+01,		2.140193226069487e+01,
		2.152032232739115e+01,		2.163843301155990e+01,		2.175626528111463e+01,		2.187382010147146e+01,		2.199109843551882e+01,
		2.210810124358825e+01,		2.222482948342620e+01,		2.234128411016701e+01,		2.245746607630676e+01,		2.257337633167831e+01,
		2.268901582342716e+01,		2.280438549598846e+01,		2.291948629106478e+01,		2.303431914760494e+01,		2.314888500178370e+01,
		2.326318478698231e+01,		2.337721943376995e+01,		2.349098986988603e+01,		2.360449702022326e+01,		2.371774180681161e+01,
		2.383072514880296e+01,		2.394344796245652e+01,		2.405591116112517e+01,		2.416811565524226e+01,		2.428006235230931e+01,
		2.439175215688440e+01,		2.450318597057110e+01,		2.461436469200821e+01,		2.472528921686008e+01,		2.483596043780754e+01,
		2.494637924453945e+01,		2.505654652374493e+01,		2.516646315910598e+01,		2.527613003129088e+01,		2.538554801794797e+01,
		2.549471799370009e+01,		2.560364083013944e+01,		2.571231739582303e+01,		2.582074855626855e+01,		2.592893517395077e+01,
		2.603687810829840e+01,		2.614457821569135e+01,		2.625203634945857e+01,		2.635925335987608e+01,		2.646623009416571e+01,
		2.657296739649398e+01,		2.667946610797154e+01,		2.678572706665293e+01,		2.689175110753672e+01,		2.699753906256600e+01,
		2.710309176062921e+01,		2.720841002756140e+01,		2.731349468614564e+01,		2.741834655611494e+01,		2.752296645415436e+01,
		2.762735519390342e+01,		2.773151358595891e+01,		2.783544243787784e+01,		2.793914255418075e+01,		2.804261473635526e+01,
		2.814585978285988e+01,		2.824887848912807e+01,		2.835167164757252e+01,		2.845424004758971e+01,		2.855658447556461e+01,
		2.865870571487569e+01,		2.876060454590008e+01,		2.886228174601897e+01,		2.896373808962315e+01,		2.906497434811882e+01,
		2.916599128993353e+01,		2.926678968052225e+01,		2.936737028237376e+01,		2.946773385501701e+01,		2.956788115502782e+01,
		2.966781293603562e+01,		2.976752994873033e+01,		2.986703294086949e+01,		2.996632265728537e+01,		3.006539983989241e+01,
		3.016426522769455e+01,		3.026291955679288e+01,		3.036136356039332e+01,		3.045959796881437e+01,		3.055762350949510e+01,
		3.065544090700310e+01,		3.075305088304265e+01,		3.085045415646280e+01,		3.094765144326584e+01,		3.104464345661555e+01,
		3.114143090684571e+01,		3.123801450146868e+01,		3.133439494518393e+01,		3.143057293988682e+01,		3.152654918467729e+01,
		3.162232437586879e+01,		3.171789920699700e+01,		3.181327436882896e+01,		3.190845054937196e+01,		3.200342843388257e+01,
		3.209820870487589e+01,		3.219279204213454e+01,		3.228717912271797e+01,		3.238137062097163e+01,		3.247536720853627e+01,
		3.256916955435732e+01,		3.266277832469412e+01,		3.275619418312940e+01,		3.284941779057867e+01,		3.294244980529962e+01,
		3.303529088290165e+01,		3.312794167635533e+01,		3.322040283600187e+01,		3.331267500956277e+01,		3.340475884214922e+01,
		3.349665497627178e+01,		3.358836405184992e+01,		3.367988670622161e+01,		3.377122357415296e+01,		3.386237528784773e+01,
		3.395334247695712e+01,		3.404412576858921e+01,		3.413472578731876e+01,		3.422514315519674e+01,		3.431537849176003e+01,
		3.440543241404096e+01,		3.449530553657711e+01,		3.458499847142080e+01,		3.467451182814879e+01,		3.476384621387193e+01,
		3.485300223324473e+01,		3.494198048847498e+01,		3.503078157933347e+01,		3.511940610316345e+01,		3.520785465489029e+01,
		3.529612782703106e+01,		3.538422620970415e+01,		3.547215039063873e+01,		3.555990095518437e+01,		3.564747848632058e+01,
		3.573488356466628e+01,		3.582211676848934e+01,		3.590917867371611e+01,		3.599606985394076e+01,		3.608279088043489e+01,
		3.616934232215691e+01,		3.625572474576138e+01,		3.634193871560858e+01,		3.642798479377368e+01,		3.651386354005629e+01,
		3.659957551198972e+01,		3.668512126485026e+01,		3.677050135166654e+01,		3.685571632322879e+01,		3.694076672809804e+01,
		3.702565311261544e+01,		3.711037602091140e+01,		3.719493599491474e+01,		3.727933357436197e+01,		3.736356929680630e+01,
		3.744764369762676e+01,		3.753155731003739e+01,		3.761531066509611e+01,		3.769890429171396e+01,		3.778233871666392e+01,
		3.786561446459001e+01,		3.794873205801618e+01,		3.803169201735519e+01,		3.811449486091765e+01,		3.819714110492072e+01,
		3.827963126349709e+01,		3.836196584870360e+01,		3.844414537053032e+01,		3.852617033690901e+01,		3.860804125372196e+01,
		3.868975862481076e+01,		3.877132295198485e+01,		3.885273473503020e+01,		3.893399447171795e+01,		3.901510265781297e+01,
		3.909605978708238e+01,		3.917686635130408e+01,		3.925752284027529e+01,		3.933802974182095e+01,		3.941838754180218e+01,
		3.949859672412470e+01,		3.957865777074710e+01,		3.965857116168936e+01,		3.973833737504094e+01,		3.981795688696926e+01,
		3.989743017172784e+01,		3.997675770166451e+01,		4.005593994722966e+01,		4.013497737698435e+01,		4.021387045760844e+01,
		4.029261965390874e+01,		4.037122542882700e+01,		4.044968824344799e+01,		4.052800855700745e+01,		4.060618682690021e+01,
		4.068422350868789e+01,		4.076211905610712e+01,		4.083987392107704e+01,		4.091748855370758e+01,		4.099496340230697e+01,
		4.107229891338954e+01,		4.114949553168373e+01,		4.122655370013950e+01,		4.130347385993630e+01,		4.138025645049052e+01,
		4.145690190946330e+01,		4.153341067276804e+01,		4.160978317457797e+01,		4.168601984733370e+01,		4.176212112175084e+01,
		4.183808742682737e+01,		4.191391918985106e+01,		4.198961683640707e+01,		4.206518079038514e+01,		4.214061147398712e+01,
		4.221590930773419e+01,		4.229107471047422e+01,		4.236610809938905e+01,		4.244100989000169e+01,		4.251578049618360e+01,
		4.259042033016178e+01,		4.266492980252600e+01,		4.273930932223594e+01,		4.281355929662823e+01,		4.288768013142349e+01,
		4.296167223073350e+01,		4.303553599706805e+01,		4.310927183134205e+01,		4.318288013288237e+01,		4.325636129943485e+01,
		4.332971572717110e+01,		4.340294381069544e+01,		4.347604594305172e+01,		4.354902251573009e+01,		4.362187391867378e+01,
		4.369460054028590e+01,		4.376720276743608e+01,		4.383968098546719e+01,		4.391203557820209e+01,		4.398426692795006e+01,
		4.405637541551364e+01,		4.412836142019501e+01,		4.420022531980266e+01,		4.427196749065785e+01,		4.434358830760118e+01,
		4.441508814399894e+01,		4.448646737174959e+01,		4.455772636129025e+01,		4.462886548160300e+01,		4.469988510022118e+01,
		4.477078558323588e+01,		4.484156729530208e+01,		4.491223059964506e+01,		4.498277585806650e+01,		4.505320343095077e+01,
		4.512351367727122e+01,		4.519370695459614e+01,		4.526378361909506e+01,		4.533374402554479e+01,		4.540358852733551e+01,
		4.547331747647692e+01,		4.554293122360406e+01,		4.561243011798355e+01,		4.568181450751940e+01,		4.575108473875905e+01,
		4.582024115689934e+01,		4.588928410579221e+01,		4.595821392795082e+01,		4.602703096455527e+01,		4.609573555545840e+01,
		4.616432803919172e+01,		4.623280875297095e+01,		4.630117803270211e+01,		4.636943621298688e+01,		4.643758362712855e+01,
		4.650562060713754e+01,		4.657354748373719e+01,		4.664136458636924e+01,		4.670907224319951e+01,		4.677667078112351e+01,
		4.684416052577179e+01,		4.691154180151579e+01,		4.697881493147298e+01,		4.704598023751264e+01,		4.711303804026110e+01,
		4.717998865910727e+01,		4.724683241220804e+01,		4.731356961649359e+01,		4.738020058767284e+01,		4.744672564023866e+01,
		4.751314508747334e+01,		4.757945924145370e+01,		4.764566841305648e+01,		4.771177291196348e+01,		4.777777304666688e+01,
		4.784366912447432e+01,		4.790946145151411e+01,		4.797515033274042e+01,		4.804073607193834e+01,		4.810621897172898e+01,
		4.817159933357457e+01,		4.823687745778355e+01,		4.830205364351545e+01,		4.836712818878610e+01,		4.843210139047245e+01,
		4.849697354431765e+01,		4.856174494493590e+01,		4.862641588581739e+01,		4.869098665933325e+01,		4.875545755674037e+01,
		4.881982886818623e+01,		4.888410088271382e+01,		4.894827388826636e+01,		4.901234817169213e+01,		4.907632401874920e+01,
		4.914020171411025e+01,		4.920398154136716e+01,		4.926766378303591e+01,		4.933124872056103e+01,		4.939473663432040e+01,
		4.945812780362989e+01,		4.952142250674790e+01,		4.958462102088004e+01,		4.964772362218363e+01,		4.971073058577230e+01,
		4.977364218572055e+01,		4.983645869506814e+01,		4.989918038582473e+01,		4.996180752897428e+01,		5.002434039447950e+01,
		5.008677925128633e+01,		5.014912436732826e+01,		5.021137600953081e+01,		5.027353444381585e+01,		5.033559993510601e+01,
		5.039757274732893e+01,		5.045945314342167e+01,		5.052124138533485e+01,		5.058293773403714e+01,		5.064454244951932e+01,
		5.070605579079862e+01,		5.076747801592288e+01,		5.082880938197483e+01,		5.089005014507613e+01,		5.095120056039168e+01
	},
	{
		8.525343710108450e-02,		2.556225623718079e-01,		4.255808278371627e-01,		5.951290995953100e-01,		7.642682191987394e-01,
		9.329990056533060e-01,		1.101322257317668e+00,		1.269238753707206e+00,		1.436749257206343e+00,		1.603854514693017e+00,
		1.770555259078923e+00,		1.936852210768964e+00,		2.102746079043261e+00,		2.268237563364890e+00,		2.433327354616440e+00,
		2.598016136268319e+00,		2.762304585481668e+00,		2.926193374148596e+00,		3.089683169872372e+00,		3.252774636890107e+00,
		3.415468436940339e+00,		3.577765230077896e+00,		3.739665675438259e+00,		3.901170431953619e+00,		4.062280159022720e+00,
		4.222995517136483e+00,		4.383317168461389e+00,		4.543245777382432e+00,		4.702782011007518e+00,		4.861926539634969e+00,
		5.020680037185854e+00,		5.179043181602738e+00,		5.337016655216384e+00,		5.494601145081933e+00,		5.651797343285964e+00,
		5.808605947225825e+00,		5.965027659862592e+00,		6.121063189948898e+00,		6.276713252232884e+00,		6.431978567639470e+00,
		6.586859863430045e+00,		6.741357873341729e+00,		6.895473337707209e+00,		7.049207003556208e+00,		7.202559624699509e+00,
		7.355531961796526e+00,		7.508124782407291e+00,		7.660338861029701e+00,		7.812174979122910e+00,		7.963633925117601e+00,
		8.114716494413937e+00,		8.265423489367913e+00,		8.415755719266818e+00,		8.565714000294447e+00,		8.715299155486759e+00,
		8.864512014678555e+00,		9.013353414441783e+00,		9.161824198016037e+00,		9.309925215231782e+00,		9.457657322426833e+00,
		9.605021382356556e+00,		9.752018264098316e+00,		9.898648842950545e+00,		1.004491400032694e+01,		1.019081462364612e+01,
		1.033635160621726e+01,		1.048152584712184e+01,		1.062633825109219e+01,		1.077078972838686e+01,		1.091488119466331e+01,
		1.105861357084820e+01,		1.120198778300553e+01,		1.134500476220295e+01,		1.148766544437638e+01,		1.162997077019349e+01,
		1.177192168491583e+01,		1.191351913826024e+01,		1.205476408425948e+01,		1.219565748112247e+01,		1.233620029109414e+01,
		1.247639348031519e+01,		1.261623801868194e+01,		1.275573487970636e+01,		1.289488504037636e+01,		1.303368948101673e+01,
		1.317214918515056e+01,		1.331026513936144e+01,		1.344803833315655e+01,		1.358546975883058e+01,		1.372256041133087e+01,
		1.385931128812360e+01,		1.399572338906114e+01,		1.413179771625085e+01,		1.426753527392514e+01,		1.440293706831309e+01,
		1.453800410751338e+01,		1.467273740136904e+01,		1.480713796134356e+01,		1.494120680039887e+01,		1.507494493287482e+01,
		1.520835337437058e+01,		1.534143314162768e+01,		1.547418525241489e+01,		1.560661072541492e+01,		1.573871058011306e+01,
		1.587048583668745e+01,		1.600193751590150e+01,		1.613306663899803e+01,		1.626387422759539e+01,		1.639436130358545e+01,
		1.652452888903353e+01,		1.665437800608028e+01,		1.678390967684541e+01,		1.691312492333338e+01,		1.704202476734104e+01,
		1.717061023036709e+01,		1.729888233352353e+01,		1.742684209744899e+01,		1.755449054222385e+01,		1.768182868728740e+01,
		1.780885755135674e+01,		1.793557815234750e+01,		1.806199150729656e+01,		1.818809863228638e+01,		1.831390054237125e+01,
		1.843939825150533e+01,		1.856459277247237e+01,		1.868948511681727e+01,		1.881407629477928e+01,		1.893836731522690e+01,
		1.906235918559463e+01,		1.918605291182105e+01,		1.930944949828891e+01,		1.943254994776657e+01,		1.955535526135111e+01,
		1.967786643841306e+01,		1.980008447654262e+01,		1.992201037149737e+01,		2.004364511715157e+01,		2.016498970544687e+01,
		2.028604512634446e+01,		2.040681236777870e+01,		2.052729241561205e+01,		2.064748625359154e+01,		2.076739486330641e+01,
		2.088701922414719e+01,		2.100636031326608e+01,		2.112541910553849e+01,		2.124419657352608e+01,		2.136269368744071e+01,
		2.148091141510994e+01,		2.159885072194337e+01,		2.171651257090042e+01,		2.183389792245910e+01,		2.195100773458595e+01,
		2.206784296270702e+01,		2.218440455967996e+01,		2.230069347576719e+01,		2.241671065860997e+01,		2.253245705320361e+01,
		2.264793360187359e+01,		2.276314124425262e+01,		2.287808091725871e+01,		2.299275355507407e+01,		2.310716008912499e+01,
		2.322130144806250e+01,		2.333517855774401e+01,		2.344879234121565e+01,		2.356214371869549e+01,		2.367523360755765e+01,
		2.378806292231695e+01,		2.390063257461460e+01,		2.401294347320443e+01,		2.412499652393987e+01,		2.423679262976180e+01,
		2.434833269068680e+01,		2.445961760379637e+01,		2.457064826322662e+01,		2.468142556015859e+01,		2.479195038280935e+01,
		2.490222361642356e+01,		2.501224614326557e+01,		2.512201884261237e+01,		2.523154259074677e+01,		2.534081826095131e+01,
		2.544984672350272e+01,		2.555862884566674e+01,		2.566716549169367e+01,		2.577545752281413e+01,		2.588350579723558e+01,
		2.599131117013910e+01,		2.609887449367671e+01,		2.620619661696911e+01,		2.631327838610384e+01,		2.642012064413383e+01,
		2.652672423107644e+01,		2.663308998391278e+01,		2.673921873658745e+01,		2.684511132000869e+01,		2.695076856204885e+01,
		2.705619128754517e+01,		2.716138031830098e+01,		2.726633647308716e+01,		2.737106056764394e+01,		2.747555341468301e+01,
		2.757981582388992e+01,		2.768384860192679e+01,		2.778765255243527e+01,		2.789122847603977e+01,		2.799457717035098e+01,
		2.809769942996966e+01,		2.820059604649058e+01,		2.830326780850683e+01,		2.840571550161425e+01,		2.850793990841619e+01,
		2.860994180852834e+01,		2.871172197858392e+01,		2.881328119223896e+01,		2.891462022017791e+01,		2.901573983011921e+01,
		2.911664078682130e+01,		2.921732385208862e+01,		2.931778978477785e+01,		2.941803934080436e+01,		2.951807327314873e+01,
		2.961789233186341e+01,		2.971749726407966e+01,		2.981688881401451e+01,		2.991606772297787e+01,		3.001503472937983e+01,
		3.011379056873800e+01,		3.021233597368507e+01,		3.031067167397637e+01,		3.040879839649768e+01,		3.050671686527303e+01,
		3.060442780147262e+01,		3.070193192342094e+01,		3.079922994660480e+01,		3.089632258368167e+01,		3.099321054448791e+01,
		3.108989453604719e+01,		3.118637526257901e+01,		3.128265342550717e+01,		3.137872972346846e+01,		3.147460485232131e+01,
		3.157027950515458e+01,		3.166575437229634e+01,		3.176103014132278e+01,		3.185610749706712e+01,		3.195098712162861e+01,
		3.204566969438156e+01,		3.214015589198441e+01,		3.223444638838890e+01,		3.232854185484917e+01,		3.242244295993105e+01,
		3.251615036952123e+01,		3.260966474683661e+01,		3.270298675243355e+01,		3.279611704421726e+01,		3.288905627745117e+01,
		3.298180510476626e+01,		3.307436417617059e+01,		3.316673413905863e+01,		3.325891563822086e+01,		3.335090931585306e+01,
		3.344271581156600e+01,		3.353433576239485e+01,		3.362576980280869e+01,		3.371701856472011e+01,		3.380808267749470e+01,
		3.389896276796063e+01,		3.398965946041821e+01,		3.408017337664943e+01,		3.417050513592757e+01,		3.426065535502672e+01,
		3.435062464823139e+01,		3.444041362734608e+01,		3.453002290170481e+01,		3.461945307818071e+01,		3.470870476119565e+01,
		3.479777855272963e+01,		3.488667505233052e+01,		3.497539485712350e+01,		3.506393856182059e+01,		3.515230675873026e+01,
		3.524050003776683e+01,		3.532851898646009e+01,		3.541636418996471e+01,		3.550403623106978e+01,		3.559153569020825e+01,
		3.567886314546639e+01,		3.576601917259323e+01,		3.585300434500999e+01,		3.593981923381949e+01,		3.602646440781552e+01,
		3.611294043349225e+01,		3.619924787505352e+01,		3.628538729442227e+01,		3.637135925124979e+01,		3.645716430292502e+01,
		3.654280300458385e+01,		3.662827590911834e+01,		3.671358356718601e+01,		3.679872652721899e+01,		3.688370533543325e+01,
		3.696852053583775e+01,		3.705317267024359e+01,		3.713766227827310e+01,		3.722198989736895e+01,		3.730615606280328e+01,
		3.739016130768665e+01,		3.747400616297708e+01,		3.755769115748907e+01,		3.764121681790264e+01,		3.772458366877208e+01,
		3.780779223253504e+01,		3.789084302952134e+01,		3.797373657796187e+01,		3.805647339399735e+01,		3.813905399168727e+01,
		3.822147888301851e+01,		3.830374857791419e+01,		3.838586358424240e+01,		3.846782440782485e+01,		3.854963155244555e+01,
		3.863128551985944e+01,		3.871278680980102e+01,		3.879413591999293e+01,		3.887533334615447e+01,		3.895637958201016e+01,
		3.903727511929820e+01,		3.911802044777894e+01,		3.919861605524334e+01,		3.927906242752132e+01,		3.935936004849017e+01,
		3.943950940008296e+01,		3.951951096229666e+01,		3.959936521320066e+01,		3.967907262894482e+01,		3.975863368376785e+01,
		3.983804885000541e+01,		3.991731859809829e+01,		3.999644339660057e+01,		4.007542371218769e+01,		4.015426000966453e+01,
		4.023295275197351e+01,		4.031150240020247e+01,		4.038990941359279e+01,		4.046817424954725e+01,		4.054629736363800e+01,
		4.062427920961441e+01,		4.070212023941097e+01,		4.077982090315508e+01,		4.085738164917487e+01,		4.093480292400694e+01,
		4.101208517240417e+01,		4.108922883734333e+01,		4.116623436003285e+01,		4.124310217992034e+01,		4.131983273470038e+01,
		4.139642646032194e+01,		4.147288379099602e+01,		4.154920515920320e+01,		4.162539099570101e+01,		4.170144172953155e+01,
		4.177735778802887e+01,		4.185313959682627e+01,		4.192878757986383e+01,		4.200430215939566e+01,		4.207968375599723e+01,
		4.215493278857273e+01,		4.223004967436215e+01,		4.230503482894873e+01,		4.237988866626595e+01,		4.245461159860484e+01,
		4.252920403662102e+01,		4.260366638934186e+01,		4.267799906417360e+01,		4.275220246690824e+01,		4.282627700173074e+01,
		4.290022307122592e+01,		4.297404107638539e+01,		4.304773141661457e+01,		4.312129448973951e+01,		4.319473069201381e+01,
		4.326804041812544e+01,		4.334122406120360e+01,		4.341428201282541e+01,		4.348721466302277e+01,		4.356002240028907e+01,
		4.363270561158581e+01,		4.370526468234940e+01,		4.377769999649770e+01,		4.385001193643668e+01,		4.392220088306698e+01,
		4.399426721579056e+01,		4.406621131251705e+01,		4.413803354967050e+01,		4.420973430219561e+01,		4.428131394356437e+01,
		4.435277284578234e+01,		4.442411137939518e+01,		4.449532991349488e+01,		4.456642881572617e+01,		4.463740845229282e+01,
		4.470826918796399e+01,		4.477901138608032e+01,		4.484963540856035e+01,		4.492014161590657e+01,		4.499053036721173e+01,
		4.506080202016484e+01,		4.513095693105743e+01,		4.520099545478957e+01,		4.527091794487601e+01,		4.534072475345207e+01,
		4.541041623127987e+01,		4.547999272775416e+01,		4.554945459090828e+01,		4.561880216742028e+01,		4.568803580261863e+01,
		4.575715584048817e+01,		4.582616262367604e+01,		4.589505649349742e+01,		4.596383778994142e+01,		4.603250685167678e+01,
		4.610106401605772e+01,		4.616950961912961e+01,		4.623784399563469e+01,		4.630606747901778e+01,		4.637418040143195e+01,
		4.644218309374405e+01,		4.651007588554045e+01,		4.657785910513257e+01,		4.664553307956242e+01,		4.671309813460815e+01,
		4.678055459478960e+01,		4.684790278337370e+01,		4.691514302238004e+01,		4.698227563258620e+01,		4.704930093353326e+01,
		4.711621924353112e+01,		4.718303087966387e+01,		4.724973615779523e+01,		4.731633539257372e+01,		4.738282889743802e+01,
		4.744921698462232e+01,		4.751549996516146e+01,		4.758167814889618e+01,		4.764775184447834e+01,		4.771372135937612e+01,
		4.777958699987905e+01,		4.784534907110339e+01,		4.791100787699696e+01,		4.797656372034442e+01,		4.804201690277225e+01,
		4.810736772475380e+01,		4.817261648561436e+01,		4.823776348353601e+01,		4.830280901556286e+01,		4.836775337760572e+01,
		4.843259686444713e+01,		4.849733976974640e+01,		4.856198238604429e+01,		4.862652500476801e+01,		4.869096791623596e+01,
		4.875531140966268e+01,		4.881955577316356e+01,		4.888370129375957e+01,		4.894774825738214e+01,		4.901169694887782e+01,
		4.907554765201294e+01,		4.913930064947851e+01,		4.920295622289458e+01,		4.926651465281514e+01,		4.932997621873265e+01,
		4.939334119908265e+01,		4.945660987124836e+01,		4.951978251156523e+01,		4.958285939532556e+01,		4.964584079678283e+01,
		4.970872698915646e+01,		4.977151824463611e+01,		4.983421483438622e+01,		4.989681702855041e+01,		4.995932509625595e+01,
		5.002173930561816e+01,		5.008405992374477e+01,		5.014628721674022e+01,		5.020842144971016e+01,		5.027046288676566e+01,
		5.033241179102751e+01,		5.039426842463058e+01,		5.045603304872800e+01,		5.051770592349553e+01,		5.057928730813557e+01,
		5.064077746088159e+01,		5.070217663900224e+01,		5.076348509880544e+01,		5.082470309564267e+01,		5.088583088391299e+01
	},
	{
		8.507300248663784e-02,		2.550819094768782e-01,		4.246813078272275e-01,		5.938720646355322e-01,		7.626550226669433e-01,
		9.310310023280109e-01,		1.099000803542570e+00,		1.266565207533435e+00,		1.433724978513773e+00,		1.600480865291842e+00,
		1.766833602792654e+00,		1.932783913499965e+00,		2.098332508821874e+00,		2.263480090383179e+00,		2.428227351247497e+00,
		2.592574977072074e+00,		2.756523647198081e+00,		2.920074035679070e+00,		3.083226812250192e+00,		3.245982643240670e+00,
		3.408342192431916e+00,		3.570306121863601e+00,		3.731875092589919e+00,		3.893049765388150e+00,		4.053830801421629e+00,
		4.214218862859074e+00,		4.374214613452188e+00,		4.533818719073391e+00,		4.693031848215460e+00,		4.851854672454760e+00,
		5.010287866879736e+00,		5.168332110486245e+00,		5.325988086541255e+00,		5.483256482916369e+00,		5.640137992392622e+00,
		5.796633312937871e+00,		5.952743147958126e+00,		6.108468206524063e+00,		6.263809203573940e+00,		6.418766860094103e+00,
		6.573341903278160e+00,		6.727535066665961e+00,		6.881347090263387e+00,		7.034778720643957e+00,		7.187830711033212e+00,
		7.340503821376811e+00,		7.492798818393215e+00,		7.644716475611792e+00,		7.796257573397210e+00,		7.947422898960862e+00,
		8.098213246360057e+00,		8.248629416485796e+00,		8.398672217039673e+00,		8.548342462500717e+00,		8.697640974082715e+00,
		8.846568579682645e+00,		8.995126113820808e+00,		9.143314417573263e+00,		9.291134338496974e+00,		9.438586730548320e+00,
		9.585672453995372e+00,		9.732392375324419e+00,		9.878747367141209e+00,		1.002473830806729e+01,		1.017036608263188e+01,
		1.031563158115971e+01,		1.046053569965505e+01,		1.060507933968242e+01,		1.074926340824431e+01,		1.089308881765606e+01,
		1.103655648541847e+01,		1.117966733408818e+01,		1.132242229114619e+01,		1.146482228886486e+01,		1.160686826417349e+01,
		1.174856115852277e+01,		1.188990191774836e+01,		1.203089149193377e+01,		1.217153083527270e+01,		1.231182090593112e+01,
		1.245176266590913e+01,		1.259135708090297e+01,		1.273060512016705e+01,		1.286950775637640e+01,		1.300806596548957e+01,
		1.314628072661212e+01,		1.328415302186074e+01,		1.342168383622829e+01,		1.355887415744971e+01,		1.369572497586898e+01,
		1.383223728430713e+01,		1.396841207793148e+01,		1.410425035412623e+01,		1.423975311236418e+01,		1.437492135408016e+01,
		1.450975608254566e+01,		1.464425830274510e+01,		1.477842902125373e+01,		1.491226924611704e+01,		1.504577998673190e+01,
		1.517896225372942e+01,		1.531181705885946e+01,		1.544434541487702e+01,		1.557654833543031e+01,		1.570842683495071e+01,
		1.583998192854453e+01,		1.597121463188662e+01,		1.610212596111583e+01,		1.623271693273240e+01,		1.636298856349715e+01,
		1.649294187033259e+01,		1.662257787022593e+01,		1.675189758013400e+01,		1.688090201688999e+01,		1.700959219711213e+01,
		1.713796913711423e+01,		1.726603385281810e+01,		1.739378735966787e+01,		1.752123067254607e+01,		1.764836480569166e+01,
		1.777519077261988e+01,		1.790170958604383e+01,		1.802792225779794e+01,		1.815382979876325e+01,		1.827943321879437e+01,
		1.840473352664827e+01,		1.852973172991480e+01,		1.865442883494890e+01,		1.877882584680449e+01,		1.890292376917017e+01,
		1.902672360430640e+01,		1.915022635298443e+01,		1.927343301442680e+01,		1.939634458624951e+01,		1.951896206440560e+01,
		1.964128644313048e+01,		1.976331871488861e+01,		1.988505987032183e+01,		2.000651089819899e+01,		2.012767278536728e+01,
		2.024854651670471e+01,		2.036913307507425e+01,		2.048943344127918e+01,		2.060944859401987e+01,		2.072917950985193e+01,
		2.084862716314559e+01,		2.096779252604638e+01,		2.108667656843721e+01,		2.120528025790148e+01,		2.132360455968755e+01,
		2.144165043667437e+01,		2.155941884933826e+01,		2.167691075572090e+01,		2.179412711139832e+01,		2.191106886945114e+01,
		2.202773698043580e+01,		2.214413239235682e+01,		2.226025605064024e+01,		2.237610889810786e+01,		2.249169187495268e+01,
		2.260700591871516e+01,		2.272205196426052e+01,		2.283683094375689e+01,		2.295134378665448e+01,		2.306559141966547e+01,
		2.317957476674494e+01,		2.329329474907255e+01,		2.340675228503507e+01,		2.351994829020968e+01,		2.363288367734819e+01,
		2.374555935636181e+01,		2.385797623430691e+01,		2.397013521537133e+01,		2.408203720086154e+01,		2.419368308919040e+01,
		2.430507377586562e+01,		2.441621015347899e+01,		2.452709311169609e+01,		2.463772353724677e+01,		2.474810231391617e+01,
		2.485823032253638e+01,		2.496810844097864e+01,		2.507773754414618e+01,		2.518711850396756e+01,		2.529625218939058e+01,
		2.540513946637662e+01,		2.551378119789575e+01,		2.562217824392193e+01,		2.573033146142917e+01,		2.583824170438773e+01,
		2.594590982376109e+01,		2.605333666750317e+01,		2.616052308055613e+01,		2.626746990484849e+01,		2.637417797929364e+01,
		2.648064813978893e+01,		2.658688121921489e+01,		2.669287804743507e+01,		2.679863945129602e+01,		2.690416625462783e+01,
		2.700945927824487e+01,		2.711451933994694e+01,		2.721934725452071e+01,		2.732394383374147e+01,		2.742830988637524e+01,
		2.753244621818109e+01,		2.763635363191384e+01,		2.774003292732695e+01,		2.784348490117571e+01,		2.794671034722081e+01,
		2.804971005623187e+01,		2.815248481599160e+01,		2.825503541129982e+01,		2.835736262397801e+01,		2.845946723287390e+01,
		2.856135001386636e+01,		2.866301173987044e+01,		2.876445318084264e+01,		2.886567510378643e+01,		2.896667827275783e+01,
		2.906746344887127e+01,		2.916803139030564e+01,		2.926838285231041e+01,		2.936851858721193e+01,		2.946843934442009e+01,
		2.956814587043475e+01,		2.966763890885271e+01,		2.976691920037452e+01,		2.986598748281164e+01,		2.996484449109358e+01,
		3.006349095727521e+01,		3.016192761054428e+01,		3.026015517722889e+01,		3.035817438080519e+01,		3.045598594190520e+01,
		3.055359057832462e+01,		3.065098900503085e+01,		3.074818193417105e+01,		3.084517007508028e+01,		3.094195413428975e+01,
		3.103853481553521e+01,		3.113491281976525e+01,		3.123108884514988e+01,		3.132706358708903e+01,		3.142283773822117e+01,
		3.151841198843200e+01,		3.161378702486327e+01,		3.170896353192147e+01,		3.180394219128678e+01,		3.189872368192195e+01,
		3.199330868008126e+01,		3.208769785931956e+01,		3.218189189050133e+01,		3.227589144180973e+01,		3.236969717875583e+01,
		3.246330976418766e+01,		3.255672985829954e+01,		3.264995811864129e+01,		3.274299520012743e+01,		3.283584175504663e+01,
		3.292849843307086e+01,		3.302096588126489e+01,		3.311324474409561e+01,		3.320533566344138e+01,		3.329723927860148e+01,
		3.338895622630564e+01,		3.348048714072322e+01,		3.357183265347296e+01,		3.366299339363224e+01,		3.375396998774667e+01,
		3.384476305983952e+01,		3.393537323142124e+01,		3.402580112149889e+01,		3.411604734658578e+01,		3.420611252071078e+01,
		3.429599725542800e+01,		3.438570215982622e+01,		3.447522784053839e+01,		3.456457490175107e+01,		3.465374394521409e+01,
		3.474273557024986e+01,		3.483155037376297e+01,		3.492018895024962e+01,		3.500865189180713e+01,		3.509693978814333e+01,
		3.518505322658613e+01,		3.527299279209279e+01,		3.536075906725952e+01,		3.544835263233080e+01,		3.553577406520885e+01,
		3.562302394146288e+01,		3.571010283433866e+01,		3.579701131476775e+01,		3.588374995137686e+01,		3.597031931049723e+01,
		3.605671995617387e+01,		3.614295245017488e+01,		3.622901735200076e+01,		3.631491521889360e+01,		3.640064660584636e+01,
		3.648621206561207e+01,		3.657161214871298e+01,		3.665684740344980e+01,		3.674191837591078e+01,		3.682682560998096e+01,
		3.691156964735109e+01,		3.699615102752684e+01,		3.708057028783780e+01,		3.716482796344662e+01,		3.724892458735781e+01,
		3.733286069042693e+01,		3.741663680136945e+01,		3.750025344676969e+01,		3.758371115108972e+01,		3.766701043667828e+01,
		3.775015182377960e+01,		3.783313583054227e+01,		3.791596297302797e+01,		3.799863376522032e+01,		3.808114871903354e+01,
		3.816350834432131e+01,		3.824571314888532e+01,		3.832776363848400e+01,		3.840966031684115e+01,		3.849140368565452e+01,
		3.857299424460451e+01,		3.865443249136248e+01,		3.873571892159956e+01,		3.881685402899487e+01,		3.889783830524421e+01,
		3.897867224006841e+01,		3.905935632122161e+01,		3.913989103449988e+01,		3.922027686374936e+01,		3.930051429087469e+01,
		3.938060379584728e+01,		3.946054585671349e+01,		3.954034094960299e+01,		3.961998954873683e+01,		3.969949212643572e+01,
		3.977884915312807e+01,		3.985806109735814e+01,		3.993712842579416e+01,		4.001605160323631e+01,		4.009483109262481e+01,
		4.017346735504776e+01,		4.025196084974930e+01,		4.033031203413742e+01,		4.040852136379187e+01,		4.048658929247196e+01,
		4.056451627212459e+01,		4.064230275289185e+01,		4.071994918311890e+01,		4.079745600936171e+01,		4.087482367639475e+01,
		4.095205262721868e+01,		4.102914330306800e+01,		4.110609614341872e+01,		4.118291158599591e+01,		4.125959006678123e+01,
		4.133613202002058e+01,		4.141253787823148e+01,		4.148880807221062e+01,		4.156494303104127e+01,		4.164094318210070e+01,
		4.171680895106761e+01,		4.179254076192938e+01,		4.186813903698950e+01,		4.194360419687484e+01,		4.201893666054284e+01,
		4.209413684528886e+01,		4.216920516675328e+01,		4.224414203892881e+01,		4.231894787416743e+01,		4.239362308318773e+01,
		4.246816807508186e+01,		4.254258325732265e+01,		4.261686903577057e+01,		4.269102581468081e+01,		4.276505399671021e+01,
		4.283895398292422e+01,		4.291272617280379e+01,		4.298637096425225e+01,		4.305988875360225e+01,		4.313327993562241e+01,
		4.320654490352434e+01,		4.327968404896921e+01,		4.335269776207463e+01,		4.342558643142127e+01,		4.349835044405963e+01,
		4.357099018551661e+01,		4.364350603980217e+01,		4.371589838941598e+01,		4.378816761535394e+01,		4.386031409711469e+01,
		4.393233821270619e+01,		4.400424033865220e+01,		4.407602084999871e+01,		4.414768012032037e+01,		4.421921852172697e+01,
		4.429063642486971e+01,		4.436193419894759e+01,		4.443311221171379e+01,		4.450417082948188e+01,		4.457511041713216e+01,
		4.464593133811784e+01,		4.471663395447129e+01,		4.478721862681024e+01,		4.485768571434391e+01,		4.492803557487918e+01,
		4.499826856482662e+01,		4.506838503920668e+01,		4.513838535165572e+01,		4.520826985443187e+01,		4.527803889842137e+01,
		4.534769283314420e+01,		4.541723200676027e+01,		4.548665676607521e+01,		4.555596745654633e+01,		4.562516442228848e+01,
		4.569424800607989e+01,		4.576321854936802e+01,		4.583207639227528e+01,		4.590082187360494e+01,		4.596945533084673e+01,
		4.603797710018263e+01,		4.610638751649257e+01,		4.617468691336011e+01,		4.624287562307801e+01,		4.631095397665396e+01,
		4.637892230381606e+01,		4.644678093301856e+01,		4.651453019144718e+01,		4.658217040502483e+01,		4.664970189841699e+01,
		4.671712499503727e+01,		4.678444001705277e+01,		4.685164728538957e+01,		4.691874711973814e+01,		4.698573983855863e+01,
		4.705262575908633e+01,		4.711940519733695e+01,		4.718607846811193e+01,		4.725264588500369e+01,		4.731910776040099e+01,
		4.738546440549407e+01,		4.745171613027986e+01,		4.751786324356726e+01,		4.758390605298221e+01,		4.764984486497293e+01,
		4.771567998481490e+01,		4.778141171661611e+01,		4.784704036332204e+01,		4.791256622672077e+01,		4.797798960744801e+01,
		4.804331080499198e+01,		4.810853011769858e+01,		4.817364784277625e+01,		4.823866427630092e+01,		4.830357971322093e+01,
		4.836839444736200e+01,		4.843310877143196e+01,		4.849772297702572e+01,		4.856223735463008e+01,		4.862665219362852e+01,
		4.869096778230598e+01,		4.875518440785364e+01,		4.881930235637372e+01,		4.888332191288404e+01,		4.894724336132294e+01,
		4.901106698455381e+01,		4.907479306436981e+01,		4.913842188149846e+01,		4.920195371560636e+01,		4.926538884530365e+01,
		4.932872754814873e+01,		4.939197010065266e+01,		4.945511677828388e+01,		4.951816785547255e+01,		4.958112360561518e+01,
		4.964398430107899e+01,		4.970675021320648e+01,		4.976942161231979e+01,		4.983199876772510e+01,		4.989448194771709e+01,
		4.995687141958326e+01,		5.001916744960838e+01,		5.008137030307861e+01,		5.014348024428614e+01,		5.020549753653314e+01,
		5.026742244213629e+01,		5.032925522243090e+01,		5.039099613777525e+01,		5.045264544755475e+01,		5.051420341018609e+01,
		5.057567028312151e+01,		5.063704632285294e+01,		5.069833178491609e+01,		5.075952692389468e+01,		5.082063199342443e+01
	},
	{
		8.489333030591127e-02,		2.545435413156595e-01,		4.237855893380990e-01,		5.926203424075736e-01,		7.610486444362142e-01,
		9.290713171634531e-01,		1.096689162008698e+00,		1.263902961831130e+00,		1.430713482600422e+00,		1.597121474982025e+00,
		1.763127675840519e+00,		1.928732809664387e+00,		2.093937589915442e+00,		2.258742720305992e+00,		2.423148896006746e+00,
		2.587156804788306e+00,		2.750767128099012e+00,		2.913980542081777e+00,		3.076797718532485e+00,		3.239219325802387e+00,
		3.401246029646864e+00,		3.562878494022836e+00,		3.724117381837012e+00,		3.884963355647066e+00,		4.045417078317810e+00,
		4.205479213634296e+00,		4.365150426873722e+00,		4.524431385337989e+00,		4.683322758848643e+00,		4.841825220205871e+00,
		4.999939445613201e+00,		5.157666115069453e+00,		5.315005912729444e+00,		5.471959527234921e+00,		5.628527652017060e+00,
		5.784710985571964e+00,		5.940510231710357e+00,		6.095926099782797e+00,		6.250959304881552e+00,		6.405610568020328e+00,
		6.559880616292934e+00,		6.713770183011972e+00,		6.867280007828549e+00,		7.020410836834021e+00,		7.173163422644720e+00,
		7.325538524470535e+00,		7.477536908168295e+00,		7.629159346280693e+00,		7.780406618061668e+00,		7.931279509488918e+00,
		8.081778813264368e+00,		8.231905328803256e+00,		8.381659862212521e+00,		8.531043226259197e+00,		8.680056240329355e+00,
		8.828699730378304e+00,		8.976974528872496e+00,		9.124881474723816e+00,		9.272421413216673e+00,		9.419595195928506e+00,
		9.566403680644044e+00,		9.712847731263933e+00,		9.858928217708067e+00,		1.000464601581407e+01,		1.015000200723132e+01,
		1.029499707931098e+01,		1.043963212499222e+01,		1.058390804268514e+01,		1.072782573615071e+01,		1.087138611437790e+01,
		1.101459009145846e+01,		1.115743858645959e+01,		1.129993252329468e+01,		1.144207283059245e+01,		1.158386044156484e+01,
		1.172529629387359e+01,		1.186638132949604e+01,		1.200711649459012e+01,		1.214750273935892e+01,		1.228754101791480e+01,
		1.242723228814346e+01,		1.256657751156793e+01,		1.270557765321274e+01,		1.284423368146836e+01,		1.298254656795613e+01,
		1.312051728739368e+01,		1.325814681746107e+01,		1.339543613866770e+01,		1.353238623422012e+01,		1.366899808989086e+01,
		1.380527269388825e+01,		1.394121103672747e+01,		1.407681411110287e+01,		1.421208291176151e+01,		1.434701843537815e+01,
		1.448162168043164e+01,		1.461589364708282e+01,		1.474983533705396e+01,		1.488344775350977e+01,		1.501673190094007e+01,
		1.514968878504416e+01,		1.528231941261672e+01,		1.541462479143573e+01,		1.554660593015185e+01,		1.567826383817980e+01,
		1.580959952559144e+01,		1.594061400301065e+01,		1.607130828151008e+01,		1.620168337250976e+01,		1.633174028767748e+01,
		1.646148003883115e+01,		1.659090363784284e+01,		1.672001209654490e+01,		1.684880642663768e+01,		1.697728763959939e+01,
		1.710545674659754e+01,		1.723331475840246e+01,		1.736086268530247e+01,		1.748810153702100e+01,		1.761503232263549e+01,
		1.774165605049807e+01,		1.786797372815808e+01,		1.799398636228635e+01,		1.811969495860124e+01,		1.824510052179643e+01,
		1.837020405547043e+01,		1.849500656205783e+01,		1.861950904276229e+01,		1.874371249749102e+01,		1.886761792479119e+01,
		1.899122632178776e+01,		1.911453868412297e+01,		1.923755600589754e+01,		1.936027927961331e+01,		1.948270949611748e+01,
		1.960484764454836e+01,		1.972669471228270e+01,		1.984825168488441e+01,		1.996951954605475e+01,		2.009049927758405e+01,
		2.021119185930473e+01,		2.033159826904578e+01,		2.045171948258859e+01,		2.057155647362410e+01,		2.069111021371130e+01,
		2.081038167223705e+01,		2.092937181637707e+01,		2.104808161105834e+01,		2.116651201892258e+01,		2.128466400029098e+01,
		2.140253851313017e+01,		2.152013651301928e+01,		2.163745895311816e+01,		2.175450678413667e+01,		2.187128095430518e+01,
		2.198778240934598e+01,		2.210401209244583e+01,		2.221997094422955e+01,		2.233565990273454e+01,		2.245107990338635e+01,
		2.256623187897513e+01,		2.268111675963314e+01,		2.279573547281307e+01,		2.291008894326729e+01,		2.302417809302799e+01,
		2.313800384138818e+01,		2.325156710488353e+01,		2.336486879727499e+01,		2.347790982953229e+01,		2.359069110981814e+01,
		2.370321354347323e+01,		2.381547803300197e+01,		2.392748547805903e+01,		2.403923677543638e+01,		2.415073281905134e+01,
		2.426197449993498e+01,		2.437296270622142e+01,		2.448369832313763e+01,		2.459418223299399e+01,		2.470441531517526e+01,
		2.481439844613238e+01,		2.492413249937468e+01,		2.503361834546273e+01,		2.514285685200170e+01,		2.525184888363533e+01,
		2.536059530204030e+01,		2.546909696592126e+01,		2.557735473100621e+01,		2.568536945004246e+01,		2.579314197279301e+01,
		2.590067314603345e+01,		2.600796381354916e+01,		2.611501481613313e+01,		2.622182699158405e+01,		2.632840117470487e+01,
		2.643473819730178e+01,		2.654083888818348e+01,		2.664670407316097e+01,		2.675233457504755e+01,		2.685773121365927e+01,
		2.696289480581570e+01,		2.706782616534098e+01,		2.717252610306533e+01,		2.727699542682669e+01,		2.738123494147280e+01,
		2.748524544886350e+01,		2.758902774787342e+01,		2.769258263439475e+01,		2.779591090134047e+01,		2.789901333864779e+01,
		2.800189073328178e+01,		2.810454386923927e+01,		2.820697352755300e+01,		2.830918048629607e+01,		2.841116552058643e+01,
		2.851292940259176e+01,		2.861447290153446e+01,		2.871579678369687e+01,		2.881690181242669e+01,		2.891778874814255e+01,
		2.901845834833982e+01,		2.911891136759654e+01,		2.921914855757950e+01,		2.931917066705059e+01,		2.941897844187320e+01,
		2.951857262501880e+01,		2.961795395657366e+01,		2.971712317374576e+01,		2.981608101087173e+01,		2.991482819942404e+01,
		3.001336546801829e+01,		3.011169354242045e+01,		3.020981314555448e+01,		3.030772499750992e+01,		3.040542981554955e+01,
		3.050292831411722e+01,		3.060022120484576e+01,		3.069730919656504e+01,		3.079419299530993e+01,		3.089087330432864e+01,
		3.098735082409085e+01,		3.108362625229611e+01,		3.117970028388225e+01,		3.127557361103386e+01,		3.137124692319084e+01,
		3.146672090705701e+01,		3.156199624660883e+01,		3.165707362310409e+01,		3.175195371509072e+01,		3.184663719841568e+01,
		3.194112474623376e+01,		3.203541702901665e+01,		3.212951471456181e+01,		3.222341846800160e+01,		3.231712895181226e+01,
		3.241064682582310e+01,		3.250397274722562e+01,		3.259710737058261e+01,		3.269005134783750e+01,		3.278280532832342e+01,
		3.287536995877260e+01,		3.296774588332563e+01,		3.305993374354065e+01,		3.315193417840287e+01,		3.324374782433371e+01,
		3.333537531520031e+01,		3.342681728232483e+01,		3.351807435449387e+01,		3.360914715796783e+01,		3.370003631649037e+01,
		3.379074245129779e+01,		3.388126618112845e+01,		3.397160812223223e+01,		3.406176888837995e+01,		3.415174909087278e+01,
		3.424154933855172e+01,		3.433117023780697e+01,		3.442061239258747e+01,		3.450987640441024e+01,		3.459896287236982e+01,
		3.468787239314773e+01,		3.477660556102191e+01,		3.486516296787604e+01,		3.495354520320907e+01,		3.504175285414448e+01,
		3.512978650543974e+01,		3.521764673949574e+01,		3.530533413636604e+01,		3.539284927376630e+01,		3.548019272708358e+01,
		3.556736506938569e+01,		3.565436687143049e+01,		3.574119870167520e+01,		3.582786112628563e+01,		3.591435470914555e+01,
		3.600068001186578e+01,		3.608683759379358e+01,		3.617282801202171e+01,		3.625865182139776e+01,		3.634430957453321e+01,
		3.642980182181266e+01,		3.651512911140286e+01,		3.660029198926197e+01,		3.668529099914845e+01,		3.677012668263036e+01,
		3.685479957909413e+01,		3.693931022575388e+01,		3.702365915766010e+01,		3.710784690770890e+01,		3.719187400665079e+01,
		3.727574098309964e+01,		3.735944836354161e+01,		3.744299667234400e+01,		3.752638643176409e+01,		3.760961816195796e+01,
		3.769269238098934e+01,		3.777560960483830e+01,		3.785837034741000e+01,		3.794097512054353e+01,		3.802342443402038e+01,
		3.810571879557331e+01,		3.818785871089490e+01,		3.826984468364608e+01,		3.835167721546486e+01,		3.843335680597477e+01,
		3.851488395279343e+01,		3.859625915154098e+01,		3.867748289584866e+01,		3.875855567736713e+01,		3.883947798577496e+01,
		3.892025030878698e+01,		3.900087313216256e+01,		3.908134693971407e+01,		3.916167221331506e+01,		3.924184943290858e+01,
		3.932187907651535e+01,		3.940176162024205e+01,		3.948149753828942e+01,		3.956108730296042e+01,		3.964053138466838e+01,
		3.971983025194503e+01,		3.979898437144858e+01,		3.987799420797177e+01,		3.995686022444980e+01,		4.003558288196837e+01,
		4.011416263977156e+01,		4.019259995526971e+01,		4.027089528404743e+01,		4.034904907987125e+01,		4.042706179469755e+01,
		4.050493387868038e+01,		4.058266578017913e+01,		4.066025794576625e+01,		4.073771082023505e+01,		4.081502484660719e+01,
		4.089220046614047e+01,		4.096923811833640e+01,		4.104613824094773e+01,		4.112290126998600e+01,		4.119952763972906e+01,
		4.127601778272861e+01,		4.135237212981757e+01,		4.142859111011755e+01,		4.150467515104620e+01,		4.158062467832466e+01,
		4.165644011598482e+01,		4.173212188637666e+01,		4.180767041017548e+01,		4.188308610638923e+01,		4.195836939236563e+01,
		4.203352068379941e+01,		4.210854039473950e+01,		4.218342893759607e+01,		4.225818672314770e+01,		4.233281416054844e+01,
		4.240731165733479e+01,		4.248167961943282e+01,		4.255591845116502e+01,		4.263002855525738e+01,		4.270401033284627e+01,
		4.277786418348524e+01,		4.285159050515203e+01,		4.292518969425537e+01,		4.299866214564170e+01,		4.307200825260210e+01,
		4.314522840687886e+01,		4.321832299867238e+01,		4.329129241664776e+01,		4.336413704794151e+01,		4.343685727816816e+01,
		4.350945349142692e+01,		4.358192607030816e+01,		4.365427539590014e+01,		4.372650184779532e+01,		4.379860580409704e+01,
		4.387058764142592e+01,		4.394244773492628e+01,		4.401418645827260e+01,		4.408580418367590e+01,		4.415730128189011e+01,
		4.422867812221833e+01,		4.429993507251926e+01,		4.437107249921340e+01,		4.444209076728934e+01,		4.451299024030989e+01,
		4.458377128041847e+01,		4.465443424834510e+01,		4.472497950341261e+01,		4.479540740354286e+01,		4.486571830526263e+01,
		4.493591256370983e+01,		4.500599053263956e+01,		4.507595256443000e+01,		4.514579901008857e+01,		4.521553021925767e+01,
		4.528514654022084e+01,		4.535464831990853e+01,		4.542403590390403e+01,		4.549330963644937e+01,		4.556246986045104e+01,
		4.563151691748588e+01,		4.570045114780692e+01,		4.576927289034901e+01,		4.583798248273461e+01,		4.590658026127954e+01,
		4.597506656099859e+01,		4.604344171561124e+01,		4.611170605754720e+01,		4.617985991795214e+01,		4.624790362669320e+01,
		4.631583751236460e+01,		4.638366190229303e+01,		4.645137712254337e+01,		4.651898349792405e+01,		4.658648135199252e+01,
		4.665387100706069e+01,		4.672115278420038e+01,		4.678832700324870e+01,		4.685539398281334e+01,		4.692235404027806e+01,
		4.698920749180786e+01,		4.705595465235437e+01,		4.712259583566106e+01,		4.718913135426852e+01,		4.725556151951971e+01,
		4.732188664156513e+01,		4.738810702936794e+01,		4.745422299070930e+01,		4.752023483219326e+01,		4.758614285925203e+01,
		4.765194737615109e+01,		4.771764868599409e+01,		4.778324709072807e+01,		4.784874289114836e+01,		4.791413638690366e+01,
		4.797942787650095e+01,		4.804461765731047e+01,		4.810970602557064e+01,		4.817469327639303e+01,		4.823957970376713e+01,
		4.830436560056530e+01,		4.836905125854761e+01,		4.843363696836666e+01,		4.849812301957226e+01,		4.856250970061646e+01,
		4.862679729885806e+01,		4.869098610056747e+01,		4.875507639093142e+01,		4.881906845405759e+01,		4.888296257297938e+01,
		4.894675902966043e+01,		4.901045810499939e+01,		4.907406007883441e+01,		4.913756522994791e+01,		4.920097383607085e+01,
		4.926428617388755e+01,		4.932750251904010e+01,		4.939062314613287e+01,		4.945364832873704e+01,		4.951657833939500e+01,
		4.957941344962484e+01,		4.964215392992482e+01,		4.970480004977765e+01,		4.976735207765498e+01,		4.982981028102176e+01,
		4.989217492634053e+01,		4.995444627907578e+01,		5.001662460369832e+01,		5.007871016368941e+01,		5.014070322154521e+01,
		5.020260403878088e+01,		5.026441287593491e+01,		5.032612999257329e+01,		5.038775564729374e+01,		5.044929009772977e+01,
		5.051073360055499e+01,		5.057208641148710e+01,		5.063334878529218e+01,		5.069452097578854e+01,		5.075560323585109e+01
	},
	{
		8.471441573458643e-02,		2.540074434186165e-01,		4.228936482734498e-01,		5.913738992079390e-01,		7.594490412167516e-01,
		9.271198973056584e-01,		1.094387270321333e+00,		1.261251944689568e+00,		1.427714688065631e+00,		1.593776252900384e+00,
		1.759437377925576e+00,		1.924698789561645e+00,		2.089561203251190e+00,		2.254025324721175e+00,		2.418091851176802e+00,
		2.581761472429867e+00,		2.745034871964331e+00,		2.907912727941689e+00,		3.070395714148686e+00,		3.232484500889770e+00,
		3.394179755826633e+00,		3.555482144767057e+00,		3.716392332405256e+00,		3.876910983015763e+00,		4.037038761102886e+00,
		4.196776332007650e+00,		4.356124362474100e+00,		4.515083521176710e+00,		4.673654479210701e+00,		4.831837910546848e+00,
		4.989634492452412e+00,		5.147044905879758e+00,		5.304069835824095e+00,		5.460709971651808e+00,		5.616966007400741e+00,
		5.772838642053738e+00,		5.928328579786783e+00,		6.083436530192851e+00,		6.238163208482794e+00,		6.392509335664267e+00,
		6.546475638699875e+00,		6.700062850645566e+00,		6.853271710770252e+00,		7.006102964657693e+00,		7.158557364291511e+00,
		7.310635668124289e+00,		7.462338641131574e+00,		7.613667054851633e+00,		7.764621687411786e+00,		7.915203323541999e+00,
		8.065412754576549e+00,		8.215250778444457e+00,		8.364718199649289e+00,		8.513815829239061e+00,		8.662544484766828e+00,
		8.810904990242527e+00,		8.958898176076705e+00,		9.106524879016582e+00,		9.253785942075083e+00,		9.400682214453244e+00,
		9.547214551456488e+00,		9.693383814405280e+00,		9.839190870540525e+00,		9.984636592924129e+00,		1.012972186033520e+01,
		1.027444755716213e+01,		1.041881457329108e+01,		1.056282380399104e+01,		1.070647614979591e+01,		1.084977251638390e+01,
		1.099271381445446e+01,		1.113530095960312e+01,		1.127753487219447e+01,		1.141941647723346e+01,		1.156094670423544e+01,
		1.170212648709495e+01,		1.184295676395361e+01,		1.198343847706731e+01,		1.212357257267283e+01,		1.226336000085412e+01,
		1.240280171540835e+01,		1.254189867371204e+01,		1.268065183658720e+01,		1.281906216816782e+01,		1.295713063576673e+01,
		1.309485820974301e+01,		1.323224586337002e+01,		1.336929457270424e+01,		1.350600531645493e+01,		1.364237907585473e+01,
		1.377841683453138e+01,		1.391411957838053e+01,		1.404948829543971e+01,		1.418452397576365e+01,		1.431922761130094e+01,
		1.445360019577202e+01,		1.458764272454878e+01,		1.472135619453545e+01,		1.485474160405124e+01,		1.498779995271452e+01,
		1.512053224132858e+01,		1.525293947176914e+01,		1.538502264687346e+01,		1.551678277033132e+01,		1.564822084657759e+01,
		1.577933788068667e+01,		1.591013487826871e+01,		1.604061284536751e+01,		1.617077278836042e+01,		1.630061571385993e+01,
		1.643014262861706e+01,		1.655935453942671e+01,		1.668825245303468e+01,		1.681683737604666e+01,		1.694511031483894e+01,
		1.707307227547102e+01,		1.720072426359999e+01,		1.732806728439672e+01,		1.745510234246388e+01,		1.758183044175578e+01,
		1.770825258549984e+01,		1.783436977612007e+01,		1.796018301516206e+01,		1.808569330321989e+01,		1.821090163986466e+01,
		1.833580902357478e+01,		1.846041645166789e+01,		1.858472492023458e+01,		1.870873542407359e+01,		1.883244895662881e+01,
		1.895586650992776e+01,		1.907898907452174e+01,		1.920181763942757e+01,		1.932435319207080e+01,		1.944659671823053e+01,
		1.956854920198574e+01,		1.969021162566301e+01,		1.981158496978582e+01,		1.993267021302524e+01,		2.005346833215207e+01,
		2.017398030199025e+01,		2.029420709537189e+01,		2.041414968309341e+01,		2.053380903387313e+01,		2.065318611431016e+01,
		2.077228188884452e+01,		2.089109731971857e+01,		2.100963336693965e+01,		2.112789098824394e+01,		2.124587113906153e+01,
		2.136357477248261e+01,		2.148100283922484e+01,		2.159815628760183e+01,		2.171503606349278e+01,		2.183164311031302e+01,
		2.194797836898591e+01,		2.206404277791542e+01,		2.217983727295999e+01,		2.229536278740733e+01,		2.241062025195003e+01,
		2.252561059466236e+01,		2.264033474097782e+01,		2.275479361366770e+01,		2.286898813282044e+01,		2.298291921582198e+01,
		2.309658777733683e+01,		2.320999472929006e+01,		2.332314098085012e+01,		2.343602743841228e+01,		2.354865500558313e+01,
		2.366102458316559e+01,		2.377313706914471e+01,		2.388499335867435e+01,		2.399659434406434e+01,		2.410794091476848e+01,
		2.421903395737314e+01,		2.432987435558653e+01,		2.444046299022863e+01,		2.455080073922172e+01,		2.466088847758152e+01,
		2.477072707740886e+01,		2.488031740788210e+01,		2.498966033524989e+01,		2.509875672282463e+01,		2.520760743097642e+01,
		2.531621331712750e+01,		2.542457523574720e+01,		2.553269403834745e+01,		2.564057057347868e+01,		2.574820568672623e+01,
		2.585560022070718e+01,		2.596275501506767e+01,		2.606967090648060e+01,		2.617634872864381e+01,		2.628278931227856e+01,
		2.638899348512847e+01,		2.649496207195891e+01,		2.660069589455659e+01,		2.670619577172967e+01,		2.681146251930813e+01,
		2.691649695014452e+01,		2.702129987411501e+01,		2.712587209812080e+01,		2.723021442608980e+01,		2.733432765897865e+01,
		2.743821259477497e+01,		2.754187002849999e+01,		2.764530075221133e+01,		2.774850555500621e+01,		2.785148522302472e+01,
		2.795424053945353e+01,		2.805677228452970e+01,		2.815908123554477e+01,		2.826116816684918e+01,		2.836303384985671e+01,
		2.846467905304927e+01,		2.856610454198191e+01,		2.866731107928790e+01,		2.876829942468415e+01,		2.886907033497673e+01,
		2.896962456406659e+01,		2.906996286295544e+01,		2.917008597975180e+01,		2.926999465967726e+01,		2.936968964507282e+01,
		2.946917167540544e+01,		2.956844148727462e+01,		2.966749981441938e+01,		2.976634738772504e+01,		2.986498493523037e+01,
		2.996341318213476e+01,		3.006163285080554e+01,		3.015964466078541e+01,		3.025744932880000e+01,		3.035504756876545e+01,
		3.045244009179623e+01,		3.054962760621294e+01,		3.064661081755027e+01,		3.074339042856500e+01,		3.083996713924413e+01,
		3.093634164681309e+01,		3.103251464574396e+01,		3.112848682776386e+01,		3.122425888186340e+01,		3.131983149430504e+01,
		3.141520534863182e+01,		3.151038112567576e+01,		3.160535950356678e+01,		3.170014115774119e+01,		3.179472676095064e+01,
		3.188911698327082e+01,		3.198331249211045e+01,		3.207731395222014e+01,		3.217112202570131e+01,		3.226473737201535e+01,
		3.235816064799243e+01,		3.245139250784080e+01,		3.254443360315574e+01,		3.263728458292876e+01,		3.272994609355679e+01,
		3.282241877885127e+01,		3.291470328004748e+01,		3.300680023581374e+01,		3.309871028226062e+01,		3.319043405295030e+01,
		3.328197217890573e+01,		3.337332528862012e+01,		3.346449400806607e+01,		3.355547896070506e+01,		3.364628076749671e+01,
		3.373690004690809e+01,		3.382733741492318e+01,		3.391759348505219e+01,		3.400766886834084e+01,		3.409756417337990e+01,
		3.418728000631440e+01,		3.427681697085308e+01,		3.436617566827776e+01,		3.445535669745265e+01,		3.454436065483382e+01,
		3.463318813447840e+01,		3.472183972805413e+01,		3.481031602484851e+01,		3.489861761177833e+01,		3.498674507339879e+01,
		3.507469899191304e+01,		3.516247994718132e+01,		3.525008851673034e+01,		3.533752527576261e+01,		3.542479079716554e+01,
		3.551188565152095e+01,		3.559881040711409e+01,		3.568556562994305e+01,		3.577215188372783e+01,		3.585856972991964e+01,
		3.594481972771004e+01,		3.603090243404013e+01,		3.611681840360966e+01,		3.620256818888615e+01,		3.628815234011412e+01,
		3.637357140532396e+01,		3.645882593034126e+01,		3.654391645879558e+01,		3.662884353212969e+01,		3.671360768960853e+01,
		3.679820946832808e+01,		3.688264940322441e+01,		3.696692802708267e+01,		3.705104587054586e+01,		3.713500346212381e+01,
		3.721880132820204e+01,		3.730243999305056e+01,		3.738591997883272e+01,		3.746924180561397e+01,		3.755240599137063e+01,
		3.763541305199864e+01,		3.771826350132230e+01,		3.780095785110281e+01,		3.788349661104718e+01,		3.796588028881659e+01,
		3.804810939003517e+01,		3.813018441829853e+01,		3.821210587518230e+01,		3.829387426025060e+01,		3.837549007106468e+01,
		3.845695380319120e+01,		3.853826595021084e+01,		3.861942700372656e+01,		3.870043745337207e+01,		3.878129778682017e+01,
		3.886200848979104e+01,		3.894257004606060e+01,		3.902298293746865e+01,		3.910324764392725e+01,		3.918336464342883e+01,
		3.926333441205440e+01,		3.934315742398169e+01,		3.942283415149335e+01,		3.950236506498483e+01,		3.958175063297265e+01,
		3.966099132210238e+01,		3.974008759715652e+01,		3.981903992106268e+01,		3.989784875490128e+01,		3.997651455791370e+01,
		4.005503778750994e+01,		4.013341889927665e+01,		4.021165834698485e+01,		4.028975658259775e+01,		4.036771405627852e+01,
		4.044553121639800e+01,		4.052320850954242e+01,		4.060074638052107e+01,		4.067814527237393e+01,		4.075540562637932e+01,
		4.083252788206143e+01,		4.090951247719786e+01,		4.098635984782728e+01,		4.106307042825673e+01,		4.113964465106920e+01,
		4.121608294713108e+01,		4.129238574559950e+01,		4.136855347392968e+01,		4.144458655788240e+01,		4.152048542153118e+01,
		4.159625048726968e+01,		4.167188217581884e+01,		4.174738090623423e+01,		4.182274709591314e+01,		4.189798116060179e+01,
		4.197308351440252e+01,		4.204805456978079e+01,		4.212289473757234e+01,		4.219760442699025e+01,		4.227218404563193e+01,
		4.234663399948606e+01,		4.242095469293970e+01,		4.249514652878508e+01,		4.256920990822655e+01,		4.264314523088754e+01,
		4.271695289481728e+01,		4.279063329649769e+01,		4.286418683085019e+01,		4.293761389124244e+01,		4.301091486949503e+01,
		4.308409015588829e+01,		4.315714013916885e+01,		4.323006520655638e+01,		4.330286574375020e+01,		4.337554213493578e+01,
		4.344809476279151e+01,		4.352052400849499e+01,		4.359283025172974e+01,		4.366501387069159e+01,		4.373707524209512e+01,
		4.380901474118016e+01,		4.388083274171816e+01,		4.395252961601850e+01,		4.402410573493496e+01,		4.409556146787192e+01,
		4.416689718279075e+01,		4.423811324621602e+01,		4.430921002324171e+01,		4.438018787753748e+01,		4.445104717135489e+01,
		4.452178826553339e+01,		4.459241151950667e+01,		4.466291729130862e+01,		4.473330593757947e+01,		4.480357781357174e+01,
		4.487373327315647e+01,		4.494377266882905e+01,		4.501369635171518e+01,		4.508350467157697e+01,		4.515319797681874e+01,
		4.522277661449296e+01,		4.529224093030609e+01,		4.536159126862447e+01,		4.543082797248012e+01,		4.549995138357651e+01,
		4.556896184229439e+01,		4.563785968769746e+01,		4.570664525753818e+01,		4.577531888826331e+01,		4.584388091501983e+01,
		4.591233167166031e+01,		4.598067149074870e+01,		4.604890070356591e+01,		4.611701964011528e+01,		4.618502862912828e+01,
		4.625292799806989e+01,		4.632071807314418e+01,		4.638839917929979e+01,		4.645597164023528e+01,		4.652343577840466e+01,
		4.659079191502281e+01,		4.665804037007072e+01,		4.672518146230099e+01,		4.679221550924304e+01,		4.685914282720857e+01,
		4.692596373129666e+01,		4.699267853539912e+01,		4.705928755220584e+01,		4.712579109320969e+01,		4.719218946871213e+01,
		4.725848298782797e+01,		4.732467195849083e+01,		4.739075668745808e+01,		4.745673748031599e+01,		4.752261464148482e+01,
		4.758838847422385e+01,		4.765405928063645e+01,		4.771962736167502e+01,		4.778509301714604e+01,		4.785045654571502e+01,
		4.791571824491145e+01,		4.798087841113363e+01,		4.804593733965375e+01,		4.811089532462258e+01,		4.817575265907442e+01,
		4.824050963493197e+01,		4.830516654301102e+01,		4.836972367302531e+01,		4.843418131359137e+01,		4.849853975223312e+01,
		4.856279927538670e+01,		4.862696016840516e+01,		4.869102271556307e+01,		4.875498720006131e+01,		4.881885390403161e+01,
		4.888262310854121e+01,		4.894629509359746e+01,		4.900987013815237e+01,		4.907334852010720e+01,		4.913673051631702e+01,
		4.920001640259518e+01,		4.926320645371781e+01,		4.932630094342832e+01,		4.938930014444192e+01,		4.945220432844987e+01,
		4.951501376612413e+01,		4.957772872712153e+01,		4.964034948008840e+01,		4.970287629266465e+01,		4.976530943148834e+01,
		4.982764916219992e+01,		4.988989574944643e+01,		4.995204945688595e+01,		5.001411054719173e+01,		5.007607928205648e+01,
		5.013795592219661e+01,		5.019974072735643e+01,		5.026143395631223e+01,		5.032303586687669e+01,		5.038454671590269e+01,
		5.044596675928776e+01,		5.050729625197798e+01,		5.056853544797212e+01,		5.062968460032579e+01,		5.069074396115536e+01
	},
	{
		8.453625398897788e-02,		2.534736014382938e-01,		4.220054607405943e-01,		5.901327016184338e-01,		7.578561700857860e-01,
		9.251766903494638e-01,		1.092095066616373e+00,		1.258612084810451e+00,		1.424728514202962e+00,		1.590445108959714e+00,
		1.755762609608547e+00,		1.920681744430408e+00,		2.085203230777084e+00,		2.249327776318660e+00,		2.413056080223544e+00,
		2.576388834273872e+00,		2.739326723918965e+00,		2.901870429269396e+00,		3.064020626034153e+00,		3.225777986403296e+00,
		3.387143179878375e+00,		3.548116874052841e+00,		3.708699735344574e+00,		3.868892429682568e+00,		4.028695623149755e+00,
		4.188109982583872e+00,		4.347136176138194e+00,		4.505774873803905e+00,		4.664026747895798e+00,		4.821892473502951e+00,
		4.979372728905950e+00,		5.136468195962183e+00,		5.293179560460643e+00,		5.449507512447709e+00,		5.605452746525187e+00,
		5.761015962121956e+00,		5.916197863740502e+00,		6.070999161179488e+00,		6.225420569733569e+00,		6.379462810371577e+00,
		6.533126609894109e+00,		6.686412701071623e+00,		6.839321822763966e+00,		6.991854720022357e+00,		7.144012144174712e+00,
		7.295794852895183e+00,		7.447203610258819e+00,		7.598239186782106e+00,		7.748902359450202e+00,		7.899193911731626e+00,
		8.049114633581066e+00,		8.198665321431141e+00,		8.347846778173553e+00,		8.496659813130542e+00,		8.645105242016992e+00,
		8.793183886893996e+00,		8.940896576114245e+00,		9.088244144259949e+00,		9.235227432073703e+00,		9.381847286382776e+00,
		9.528104560017393e+00,		9.674000111723322e+00,		9.819534806069354e+00,		9.964709513349915e+00,		1.010952510948333e+01,
		1.025398247590606e+01,		1.039808249946326e+01,		1.054182607229600e+01,		1.068521409172556e+01,		1.082824746013485e+01,
		1.097092708484762e+01,		1.111325387800541e+01,		1.125522875644266e+01,		1.139685264156025e+01,		1.153812645919754e+01,
		1.167905113950341e+01,		1.181962761680623e+01,		1.195985682948313e+01,		1.209973971982868e+01,		1.223927723392334e+01,
		1.237847032150144e+01,		1.251731993581938e+01,		1.265582703352379e+01,		1.279399257451997e+01,		1.293181752184068e+01,
		1.306930284151553e+01,		1.320644950244084e+01,		1.334325847625039e+01,		1.347973073718691e+01,		1.361586726197448e+01,
		1.375166902969204e+01,		1.388713702164790e+01,		1.402227222125550e+01,		1.415707561391038e+01,		1.429154818686846e+01,
		1.442569092912574e+01,		1.455950483129932e+01,		1.469299088551006e+01,		1.482615008526658e+01,		1.495898342535099e+01,
		1.509149190170614e+01,		1.522367651132449e+01,		1.535553825213864e+01,		1.548707812291370e+01,		1.561829712314115e+01,
		1.574919625293461e+01,		1.587977651292727e+01,		1.601003890417115e+01,		1.613998442803805e+01,		1.626961408612241e+01,
		1.639892888014583e+01,		1.652792981186350e+01,		1.665661788297236e+01,		1.678499409502110e+01,		1.691305944932191e+01,
		1.704081494686412e+01,		1.716826158822946e+01,		1.729540037350934e+01,		1.742223230222363e+01,		1.754875837324148e+01,
		1.767497958470367e+01,		1.780089693394685e+01,		1.792651141742943e+01,		1.805182403065918e+01,		1.817683576812261e+01,
		1.830154762321598e+01,		1.842596058817792e+01,		1.855007565402382e+01,		1.867389381048179e+01,		1.879741604593019e+01,
		1.892064334733683e+01,		1.904357670019969e+01,		1.916621708848927e+01,		1.928856549459233e+01,		1.941062289925732e+01,
		1.953239028154112e+01,		1.965386861875743e+01,		1.977505888642644e+01,		1.989596205822602e+01,		2.001657910594433e+01,
		2.013691099943372e+01,		2.025695870656608e+01,		2.037672319318943e+01,		2.049620542308596e+01,		2.061540635793120e+01,
		2.073432695725455e+01,		2.085296817840108e+01,		2.097133097649447e+01,		2.108941630440116e+01,		2.120722511269581e+01,
		2.132475834962768e+01,		2.144201696108837e+01,		2.155900189058055e+01,		2.167571407918775e+01,		2.179215446554537e+01,
		2.190832398581254e+01,		2.202422357364511e+01,		2.213985416016971e+01,		2.225521667395863e+01,		2.237031204100577e+01,
		2.248514118470352e+01,		2.259970502582053e+01,		2.271400448248039e+01,		2.282804047014123e+01,		2.294181390157611e+01,
		2.305532568685430e+01,		2.316857673332340e+01,		2.328156794559221e+01,		2.339430022551438e+01,		2.350677447217297e+01,
		2.361899158186552e+01,		2.373095244809005e+01,		2.384265796153172e+01,		2.395410901005015e+01,		2.406530647866742e+01,
		2.417625124955680e+01,		2.428694420203209e+01,		2.439738621253753e+01,		2.450757815463846e+01,		2.461752089901247e+01,
		2.472721531344114e+01,		2.483666226280244e+01,		2.494586260906360e+01,		2.505481721127454e+01,		2.516352692556188e+01,
		2.527199260512332e+01,		2.538021510022278e+01,		2.548819525818572e+01,		2.559593392339516e+01,		2.570343193728807e+01,
		2.581069013835223e+01,		2.591770936212350e+01,		2.602449044118356e+01,		2.613103420515802e+01,		2.623734148071494e+01,
		2.634341309156377e+01,		2.644924985845467e+01,		2.655485259917812e+01,		2.666022212856497e+01,		2.676535925848686e+01,
		2.687026479785682e+01,		2.697493955263046e+01,		2.707938432580717e+01,		2.718359991743189e+01,		2.728758712459706e+01,
		2.739134674144480e+01,		2.749487955916958e+01,		2.759818636602086e+01,		2.770126794730634e+01,		2.780412508539515e+01,
		2.790675855972153e+01,		2.800916914678852e+01,		2.811135762017220e+01,		2.821332475052580e+01,		2.831507130558427e+01,
		2.841659805016898e+01,		2.851790574619262e+01,		2.861899515266432e+01,		2.871986702569496e+01,		2.882052211850259e+01,
		2.892096118141820e+01,		2.902118496189145e+01,		2.912119420449676e+01,		2.922098965093937e+01,		2.932057204006178e+01,
		2.941994210785005e+01,		2.951910058744060e+01,		2.961804820912680e+01,		2.971678570036591e+01,		2.981531378578612e+01,
		2.991363318719361e+01,		3.001174462357989e+01,		3.010964881112905e+01,		3.020734646322536e+01,		3.030483829046072e+01,
		3.040212500064245e+01,		3.049920729880105e+01,		3.059608588719799e+01,		3.069276146533380e+01,		3.078923472995596e+01,
		3.088550637506718e+01,		3.098157709193352e+01,		3.107744756909264e+01,		3.117311849236227e+01,		3.126859054484851e+01,
		3.136386440695437e+01,		3.145894075638832e+01,		3.155382026817283e+01,		3.164850361465316e+01,		3.174299146550591e+01,
		3.183728448774789e+01,		3.193138334574489e+01,		3.202528870122059e+01,		3.211900121326533e+01,		3.221252153834517e+01,
		3.230585033031080e+01,		3.239898824040656e+01,		3.249193591727947e+01,		3.258469400698833e+01,		3.267726315301276e+01,
		3.276964399626239e+01,		3.286183717508597e+01,		3.295384332528052e+01,		3.304566308010055e+01,		3.313729707026731e+01,
		3.322874592397791e+01,		3.332001026691462e+01,		3.341109072225414e+01,		3.350198791067685e+01,		3.359270245037608e+01,
		3.368323495706732e+01,		3.377358604399770e+01,		3.386375632195507e+01,		3.395374639927742e+01,		3.404355688186217e+01,
		3.413318837317546e+01,		3.422264147426146e+01,		3.431191678375165e+01,		3.440101489787416e+01,		3.448993641046303e+01,
		3.457868191296754e+01,		3.466725199446148e+01,		3.475564724165243e+01,		3.484386823889103e+01,		3.493191556818025e+01,
		3.501978980918469e+01,		3.510749153923977e+01,		3.519502133336096e+01,		3.528237976425307e+01,		3.536956740231937e+01,
		3.545658481567089e+01,		3.554343257013555e+01,		3.563011122926728e+01,		3.571662135435528e+01,		3.580296350443306e+01,
		3.588913823628766e+01,		3.597514610446864e+01,		3.606098766129725e+01,		3.614666345687545e+01,		3.623217403909499e+01,
		3.631751995364640e+01,		3.640270174402804e+01,		3.648771995155503e+01,		3.657257511536826e+01,		3.665726777244334e+01,
		3.674179845759947e+01,		3.682616770350838e+01,		3.691037604070320e+01,		3.699442399758726e+01,		3.707831210044304e+01,
		3.716204087344077e+01,		3.724561083864749e+01,		3.732902251603552e+01,		3.741227642349141e+01,		3.749537307682444e+01,
		3.757831298977553e+01,		3.766109667402569e+01,		3.774372463920476e+01,		3.782619739290000e+01,		3.790851544066452e+01,
		3.799067928602614e+01,		3.807268943049555e+01,		3.815454637357502e+01,		3.823625061276687e+01,		3.831780264358175e+01,
		3.839920295954717e+01,		3.848045205221593e+01,		3.856155041117434e+01,		3.864249852405056e+01,		3.872329687652301e+01,
		3.880394595232854e+01,		3.888444623327069e+01,		3.896479819922791e+01,		3.904500232816172e+01,		3.912505909612491e+01,
		3.920496897726959e+01,		3.928473244385535e+01,		3.936434996625728e+01,		3.944382201297401e+01,		3.952314905063574e+01,
		3.960233154401226e+01,		3.968136995602074e+01,		3.976026474773381e+01,		3.983901637838736e+01,		3.991762530538846e+01,
		3.999609198432312e+01,		4.007441686896412e+01,		4.015260041127880e+01,		4.023064306143677e+01,		4.030854526781765e+01,
		4.038630747701867e+01,		4.046393013386248e+01,		4.054141368140457e+01,		4.061875856094105e+01,		4.069596521201608e+01,
		4.077303407242945e+01,		4.084996557824408e+01,		4.092676016379350e+01,		4.100341826168933e+01,		4.107994030282856e+01,
		4.115632671640111e+01,		4.123257792989703e+01,		4.130869436911392e+01,		4.138467645816424e+01,		4.146052461948248e+01,
		4.153623927383248e+01,		4.161182084031461e+01,		4.168726973637297e+01,		4.176258637780244e+01,		4.183777117875600e+01,
		4.191282455175162e+01,		4.198774690767940e+01,		4.206253865580867e+01,		4.213720020379483e+01,		4.221173195768654e+01,
		4.228613432193244e+01,		4.236040769938828e+01,		4.243455249132366e+01,		4.250856909742892e+01,		4.258245791582203e+01,
		4.265621934305535e+01,		4.272985377412237e+01,		4.280336160246455e+01,		4.287674321997797e+01,		4.294999901701999e+01,
		4.302312938241604e+01,		4.309613470346610e+01,		4.316901536595142e+01,		4.324177175414104e+01,		4.331440425079835e+01,
		4.338691323718768e+01,		4.345929909308060e+01,		4.353156219676270e+01,		4.360370292503971e+01,		4.367572165324412e+01,
		4.374761875524153e+01,		4.381939460343689e+01,		4.389104956878101e+01,		4.396258402077672e+01,		4.403399832748526e+01,
		4.410529285553239e+01,		4.417646797011479e+01,		4.424752403500608e+01,		4.431846141256313e+01,		4.438928046373214e+01,
		4.445998154805472e+01,		4.453056502367411e+01,		4.460103124734107e+01,		4.467138057442006e+01,		4.474161335889518e+01,
		4.481172995337621e+01,		4.488173070910449e+01,		4.495161597595894e+01,		4.502138610246190e+01,		4.509104143578509e+01,
		4.516058232175538e+01,		4.523000910486068e+01,		4.529932212825569e+01,		4.536852173376782e+01,		4.543760826190276e+01,
		4.550658205185033e+01,		4.557544344149017e+01,		4.564419276739738e+01,		4.571283036484822e+01,		4.578135656782571e+01,
		4.584977170902532e+01,		4.591807611986038e+01,		4.598627013046781e+01,		4.605435406971360e+01,		4.612232826519825e+01,
		4.619019304326236e+01,		4.625794872899203e+01,		4.632559564622429e+01,		4.639313411755261e+01,		4.646056446433207e+01,
		4.652788700668503e+01,		4.659510206350619e+01,		4.666220995246812e+01,		4.672921099002639e+01,		4.679610549142495e+01,
		4.686289377070138e+01,		4.692957614069200e+01,		4.699615291303721e+01,		4.706262439818663e+01,		4.712899090540416e+01,
		4.719525274277326e+01,		4.726141021720198e+01,		4.732746363442800e+01,		4.739341329902386e+01,		4.745925951440179e+01,
		4.752500258281894e+01,		4.759064280538217e+01,		4.765618048205322e+01,		4.772161591165354e+01,		4.778694939186925e+01,
		4.785218121925607e+01,		4.791731168924421e+01,		4.798234109614317e+01,		4.804726973314671e+01,		4.811209789233754e+01,
		4.817682586469220e+01,		4.824145394008584e+01,		4.830598240729692e+01,		4.837041155401202e+01,		4.843474166683051e+01,
		4.849897303126928e+01,		4.856310593176734e+01,		4.862714065169057e+01,		4.869107747333630e+01,		4.875491667793791e+01,
		4.881865854566946e+01,		4.888230335565025e+01,		4.894585138594934e+01,		4.900930291359010e+01,		4.907265821455474e+01,
		4.913591756378876e+01,		4.919908123520543e+01,		4.926214950169026e+01,		4.932512263510542e+01,		4.938800090629416e+01,
		4.945078458508510e+01,		4.951347394029681e+01,		4.957606923974188e+01,		4.963857075023158e+01,		4.970097873757982e+01,
		4.976329346660771e+01,		4.982551520114774e+01,		4.988764420404797e+01,		4.994968073717637e+01,		5.001162506142496e+01,
		5.007347743671402e+01,		5.013523812199632e+01,		5.019690737526120e+01,		5.025848545353876e+01,		5.031997261290395e+01,
		5.038136910848064e+01,		5.044267519444586e+01,		5.050389112403365e+01,		5.056501714953927e+01,		5.062605352232313e+01
	},
	{
		8.435884032560595e-02,		2.529420011480288e-01,		4.211210030483385e-01,		5.888967165031399e-01,		7.562699884836799e-01,
		9.232416443337409e-01,		1.089812489554675e+00,		1.255983311501370e+00,		1.421754880992773e+00,		1.587127953840459e+00,
		1.752103272298594e+00,		1.916681566438482e+00,		2.080863555450814e+00,		2.244649948878548e+00,		2.408041447783305e+00,
		2.571038745847989e+00,		2.733642530418292e+00,		2.895853483485602e+00,		3.057672282613779e+00,		3.219099601812113e+00,
		3.380136112356761e+00,		3.540782483562820e+00,		3.701039383509142e+00,		3.860907479717903e+00,		4.020387439790886e+00,
		4.179479932004332e+00,		4.338185625864190e+00,		4.496505192623473e+00,		4.654439305763426e+00,		4.811988641440101e+00,
		4.969153878897908e+00,		5.125935700851606e+00,		5.282334793838241e+00,		5.438351848540337e+00,		5.593987560081751e+00,
		5.749242628297435e+00,		5.904117757978361e+00,		6.058613659092806e+00,		6.212731046985131e+00,		6.366470642553181e+00,
		6.519833172405340e+00,		6.672819368998300e+00,		6.825429970756501e+00,		6.977665722174184e+00,		7.129527373901003e+00,
		7.281015682812024e+00,		7.432131412062988e+00,		7.582875331131603e+00,		7.733248215845702e+00,		7.883250848398945e+00,
		8.032884017354803e+00,		8.182148517639556e+00,		8.331045150524830e+00,		8.479574723600507e+00,		8.627738050738390e+00,
		8.775535952047361e+00,		8.922969253820517e+00,		9.070038788474811e+00,		9.216745394483750e+00,		9.363089916303577e+00,
		9.509073204293440e+00,		9.654696114629978e+00,		9.799959509216757e+00,		9.944864255588929e+00,		1.008941122681355e+01,
		1.023360130138589e+01,		1.037743536312209e+01,		1.052091430104846e+01,		1.066403900928790e+01,		1.080681038694347e+01,
		1.094922933797971e+01,		1.109129677110166e+01,		1.123301359963219e+01,		1.137438074138754e+01,		1.151539911855162e+01,
		1.165606965754898e+01,		1.179639328891694e+01,		1.193637094717697e+01,		1.207600357070538e+01,		1.221529210160375e+01,
		1.235423748556906e+01,		1.249284067176376e+01,		1.263110261268594e+01,		1.276902426403973e+01,		1.290660658460603e+01,
		1.304385053611373e+01,		1.318075708311149e+01,		1.331732719284036e+01,		1.345356183510696e+01,		1.358946198215783e+01,
		1.372502860855454e+01,		1.386026269105003e+01,		1.399516520846603e+01,		1.412973714157165e+01,		1.426397947296336e+01,
		1.439789318694622e+01,		1.453147926941656e+01,		1.466473870774606e+01,		1.479767249066735e+01,		1.493028160816115e+01,
		1.506256705134498e+01,		1.519452981236347e+01,		1.532617088428023e+01,		1.545749126097154e+01,		1.558849193702162e+01,
		1.571917390761955e+01,		1.584953816845809e+01,		1.597958571563402e+01,		1.610931754555043e+01,		1.623873465482059e+01,
		1.636783804017373e+01,		1.649662869836248e+01,		1.662510762607219e+01,		1.675327581983185e+01,		1.688113427592699e+01,
		1.700868399031419e+01,		1.713592595853741e+01,		1.726286117564610e+01,		1.738949063611498e+01,		1.751581533376567e+01,
		1.764183626168991e+01,		1.776755441217466e+01,		1.789297077662873e+01,		1.801808634551127e+01,		1.814290210826183e+01,
		1.826741905323202e+01,		1.839163816761903e+01,		1.851556043740061e+01,		1.863918684727161e+01,		1.876251838058230e+01,
		1.888555601927812e+01,		1.900830074384102e+01,		1.913075353323237e+01,		1.925291536483726e+01,		1.937478721441050e+01,
		1.949637005602388e+01,		1.961766486201505e+01,		1.973867260293766e+01,		1.985939424751309e+01,		1.997983076258340e+01,
		2.009998311306578e+01,		2.021985226190825e+01,		2.033943917004669e+01,		2.045874479636320e+01,		2.057777009764573e+01,
		2.069651602854896e+01,		2.081498354155636e+01,		2.093317358694352e+01,		2.105108711274268e+01,		2.116872506470833e+01,
		2.128608838628404e+01,		2.140317801857039e+01,		2.151999490029398e+01,		2.163653996777752e+01,		2.175281415491099e+01,
		2.186881839312382e+01,		2.198455361135809e+01,		2.210002073604276e+01,		2.221522069106873e+01,		2.233015439776506e+01,
		2.244482277487602e+01,		2.255922673853892e+01,		2.267336720226313e+01,		2.278724507690962e+01,		2.290086127067174e+01,
		2.301421668905643e+01,		2.312731223486657e+01,		2.324014880818394e+01,		2.335272730635304e+01,		2.346504862396564e+01,
		2.357711365284610e+01,		2.368892328203734e+01,		2.380047839778763e+01,		2.391177988353801e+01,		2.402282861991035e+01,
		2.413362548469614e+01,		2.424417135284590e+01,		2.435446709645916e+01,		2.446451358477512e+01,		2.457431168416391e+01,
		2.468386225811836e+01,		2.479316616724643e+01,		2.490222426926407e+01,		2.501103741898875e+01,		2.511960646833341e+01,
		2.522793226630102e+01,		2.533601565897949e+01,		2.544385748953722e+01,		2.555145859821902e+01,		2.565881982234258e+01,
		2.576594199629520e+01,		2.587282595153120e+01,		2.597947251656957e+01,		2.608588251699210e+01,		2.619205677544190e+01,
		2.629799611162232e+01,		2.640370134229621e+01,		2.650917328128557e+01,		2.661441273947157e+01,		2.671942052479490e+01,
		2.682419744225643e+01,		2.692874429391822e+01,		2.703306187890491e+01,		2.713715099340523e+01,		2.724101243067407e+01,
		2.734464698103459e+01,		2.744805543188077e+01,		2.755123856768016e+01,		2.765419716997693e+01,		2.775693201739516e+01,
		2.785944388564231e+01,		2.796173354751311e+01,		2.806380177289344e+01,		2.816564932876466e+01,		2.826727697920801e+01,
		2.836868548540924e+01,		2.846987560566356e+01,		2.857084809538056e+01,		2.867160370708960e+01,		2.877214319044513e+01,
		2.887246729223234e+01,		2.897257675637297e+01,		2.907247232393117e+01,		2.917215473311968e+01,		2.927162471930603e+01,
		2.937088301501901e+01,		2.946993034995515e+01,		2.956876745098542e+01,		2.966739504216208e+01,		2.976581384472564e+01,
		2.986402457711183e+01,		2.996202795495890e+01,		3.005982469111485e+01,		3.015741549564492e+01,		3.025480107583898e+01,
		3.035198213621924e+01,		3.044895937854800e+01,		3.054573350183531e+01,		3.064230520234702e+01,		3.073867517361266e+01,
		3.083484410643355e+01,		3.093081268889091e+01,		3.102658160635410e+01,		3.112215154148888e+01,		3.121752317426578e+01,
		3.131269718196853e+01,		3.140767423920248e+01,		3.150245501790320e+01,		3.159704018734503e+01,		3.169143041414978e+01,
		3.178562636229534e+01,		3.187962869312450e+01,		3.197343806535367e+01,		3.206705513508176e+01,		3.216048055579905e+01,
		3.225371497839603e+01,		3.234675905117241e+01,		3.243961341984604e+01,		3.253227872756195e+01,		3.262475561490140e+01,
		3.271704471989081e+01,		3.280914667801103e+01,		3.290106212220627e+01,		3.299279168289333e+01,		3.308433598797073e+01,
		3.317569566282780e+01,		3.326687133035394e+01,		3.335786361094771e+01,		3.344867312252614e+01,		3.353930048053387e+01,
		3.362974629795236e+01,		3.372001118530911e+01,		3.381009575068699e+01,		3.390000059973330e+01,		3.398972633566917e+01,
		3.407927355929871e+01,		3.416864286901829e+01,		3.425783486082568e+01,		3.434685012832946e+01,		3.443568926275811e+01,
		3.452435285296931e+01,		3.461284148545911e+01,		3.470115574437118e+01,		3.478929621150608e+01,		3.487726346633036e+01,
		3.496505808598574e+01,		3.505268064529847e+01,		3.514013171678828e+01,		3.522741187067769e+01,		3.531452167490112e+01,
		3.540146169511396e+01,		3.548823249470183e+01,		3.557483463478954e+01,		3.566126867425024e+01,		3.574753516971462e+01,
		3.583363467557967e+01,		3.591956774401803e+01,		3.600533492498685e+01,		3.609093676623678e+01,		3.617637381332109e+01,
		3.626164660960449e+01,		3.634675569627214e+01,		3.643170161233859e+01,		3.651648489465666e+01,		3.660110607792630e+01,
		3.668556569470353e+01,		3.676986427540918e+01,		3.685400234833776e+01,		3.693798043966625e+01,		3.702179907346287e+01,
		3.710545877169579e+01,		3.718896005424193e+01,		3.727230343889553e+01,		3.735548944137694e+01,		3.743851857534123e+01,
		3.752139135238676e+01,		3.760410828206383e+01,		3.768666987188325e+01,		3.776907662732484e+01,		3.785132905184598e+01,
		3.793342764689010e+01,		3.801537291189512e+01,		3.809716534430191e+01,		3.817880543956267e+01,		3.826029369114933e+01,
		3.834163059056188e+01,		3.842281662733678e+01,		3.850385228905510e+01,		3.858473806135095e+01,		3.866547442791961e+01,
		3.874606187052580e+01,		3.882650086901180e+01,		3.890679190130575e+01,		3.898693544342959e+01,		3.906693196950725e+01,
		3.914678195177276e+01,		3.922648586057820e+01,		3.930604416440178e+01,		3.938545732985579e+01,		3.946472582169456e+01,
		3.954385010282236e+01,		3.962283063430135e+01,		3.970166787535939e+01,		3.978036228339791e+01,		3.985891431399969e+01,
		3.993732442093664e+01,		4.001559305617759e+01,		4.009372066989596e+01,		4.017170771047741e+01,		4.024955462452763e+01,
		4.032726185687987e+01,		4.040482985060255e+01,		4.048225904700681e+01,		4.055954988565414e+01,		4.063670280436382e+01,
		4.071371823922038e+01,		4.079059662458111e+01,		4.086733839308349e+01,		4.094394397565249e+01,		4.102041380150808e+01,
		4.109674829817242e+01,		4.117294789147729e+01,		4.124901300557122e+01,		4.132494406292690e+01,		4.140074148434832e+01,
		4.147640568897794e+01,		4.155193709430388e+01,		4.162733611616699e+01,		4.170260316876812e+01,		4.177773866467496e+01,
		4.185274301482928e+01,		4.192761662855386e+01,		4.200235991355945e+01,		4.207697327595172e+01,		4.215145712023833e+01,
		4.222581184933570e+01,		4.230003786457588e+01,		4.237413556571341e+01,		4.244810535093223e+01,		4.252194761685228e+01,
		4.259566275853647e+01,		4.266925116949722e+01,		4.274271324170332e+01,		4.281604936558645e+01,		4.288925993004799e+01,
		4.296234532246548e+01,		4.303530592869933e+01,		4.310814213309931e+01,		4.318085431851114e+01,		4.325344286628297e+01,
		4.332590815627180e+01,		4.339825056685005e+01,		4.347047047491191e+01,		4.354256825587973e+01,		4.361454428371046e+01,
		4.368639893090186e+01,		4.375813256849902e+01,		4.382974556610043e+01,		4.390123829186435e+01,		4.397261111251511e+01,
		4.404386439334917e+01,		4.411499849824145e+01,		4.418601378965132e+01,		4.425691062862892e+01,		4.432768937482111e+01,
		4.439835038647760e+01,		4.446889402045704e+01,		4.453932063223296e+01,		4.460963057589989e+01,		4.467982420417916e+01,
		4.474990186842501e+01,		4.481986391863043e+01,		4.488971070343307e+01,		4.495944257012109e+01,		4.502905986463909e+01,
		4.509856293159379e+01,		4.516795211425991e+01,		4.523722775458594e+01,		4.530639019319988e+01,		4.537543976941492e+01,
		4.544437682123520e+01,		4.551320168536135e+01,		4.558191469719633e+01,		4.565051619085087e+01,		4.571900649914916e+01,
		4.578738595363439e+01,		4.585565488457430e+01,		4.592381362096669e+01,		4.599186249054497e+01,		4.605980181978354e+01,
		4.612763193390332e+01,		4.619535315687715e+01,		4.626296581143517e+01,		4.633047021907024e+01,		4.639786670004322e+01,
		4.646515557338842e+01,		4.653233715691877e+01,		4.659941176723123e+01,		4.666637971971190e+01,		4.673324132854146e+01,
		4.679999690670019e+01,		4.686664676597327e+01,		4.693319121695593e+01,		4.699963056905853e+01,		4.706596513051186e+01,
		4.713219520837188e+01,		4.719832110852534e+01,		4.726434313569430e+01,		4.733026159344145e+01,		4.739607678417510e+01,
		4.746178900915413e+01,		4.752739856849283e+01,		4.759290576116614e+01,		4.765831088501425e+01,		4.772361423674779e+01,
		4.778881611195241e+01,		4.785391680509390e+01,		4.791891660952287e+01,		4.798381581747964e+01,		4.804861472009895e+01,
		4.811331360741485e+01,		4.817791276836533e+01,		4.824241249079706e+01,		4.830681306147023e+01,		4.837111476606305e+01,
		4.843531788917655e+01,		4.849942271433916e+01,		4.856342952401140e+01,		4.862733859959034e+01,		4.869115022141434e+01,
		4.875486466876750e+01,		4.881848221988432e+01,		4.888200315195409e+01,		4.894542774112541e+01,		4.900875626251084e+01,
		4.907198899019109e+01,		4.913512619721965e+01,		4.919816815562715e+01,		4.926111513642581e+01,		4.932396740961371e+01,
		4.938672524417928e+01,		4.944938890810553e+01,		4.951195866837447e+01,		4.957443479097132e+01,		4.963681754088888e+01,
		4.969910718213168e+01,		4.976130397772040e+01,		4.982340818969590e+01,		4.988542007912358e+01,		4.994733990609743e+01,
		5.000916792974439e+01,		5.007090440822822e+01,		5.013254959875399e+01,		5.019410375757180e+01,		5.025556713998125e+01,
		5.031694000033517e+01,		5.037822259204400e+01,		5.043941516757952e+01,		5.050051797847915e+01,		5.056153127534974e+01
	},
	{
		8.418217004077504e-02,		2.524126284406821e-01,		4.202402517048540e-01,		5.876659110054341e-01,		7.546904542100826e-01,
		9.213147077366819e-01,		1.087539478316472e+00,		1.253365554669343e+00,		1.418793709094869e+00,		1.583824698982499e+00,
		1.748459268244219e+00,		1.912698148672837e+00,		2.076542061228925e+00,		2.239991717259358e+00,		2.403047819650238e+00,
		2.565711063916921e+00,		2.727982139233724e+00,		2.889861729405832e+00,		3.051350513785802e+00,		3.212449168136976e+00,
		3.373158365446037e+00,		3.533478776686855e+00,		3.693411071537688e+00,		3.852955919053719e+00,		4.012113988296877e+00,
		4.170885948924755e+00,		4.329272471740424e+00,		4.487274229204849e+00,		4.644891895913561e+00,		4.802126149039185e+00,
		4.958977668741345e+00,		5.115447138545414e+00,		5.271535245691559e+00,		5.427242681455421e+00,		5.582570141441778e+00,
		5.737518325852417e+00,		5.892087939729490e+00,		6.046279693175503e+00,		6.200094301551058e+00,		6.353532485651469e+00,
		6.506594971863279e+00,		6.659282492301697e+00,		6.811595784929920e+00,		6.963535593661272e+00,		7.115102668445061e+00,
		7.266297765337035e+00,		7.417121646555204e+00,		7.567575080521894e+00,		7.717658841892787e+00,		7.867373711573602e+00,
		8.016720476725240e+00,		8.165699930757979e+00,		8.314312873315401e+00,		8.462560110248674e+00,		8.610442453581769e+00,
		8.757960721468196e+00,		8.905115738139825e+00,		9.051908333848239e+00,		9.198339344799219e+00,		9.344409613080771e+00,
		9.490119986585178e+00,		9.635471318925514e+00,		9.780464469347054e+00,		9.925100302633879e+00,		1.006937968901127e+01,
		1.021330350404402e+01,		1.035687262853115e+01,		1.050008794839732e+01,		1.064295035458124e+01,		1.078546074292145e+01,
		1.092762001403960e+01,		1.106942907322166e+01,		1.121088883029731e+01,		1.135200019951753e+01,		1.149276409943099e+01,
		1.163318145275912e+01,		1.177325318627027e+01,		1.191298023065310e+01,		1.205236352038933e+01,		1.219140399362615e+01,
		1.233010259204838e+01,		1.246846026075042e+01,		1.260647794810845e+01,		1.274415660565272e+01,		1.288149718794013e+01,
		1.301850065242737e+01,		1.315516795934457e+01,		1.329150007156961e+01,		1.342749795450325e+01,		1.356316257594512e+01,
		1.369849490597060e+01,		1.383349591680889e+01,		1.396816658272203e+01,		1.410250787988520e+01,		1.423652078626825e+01,
		1.437020628151859e+01,		1.450356534684527e+01,		1.463659896490477e+01,		1.476930811968794e+01,		1.490169379640862e+01,
		1.503375698139384e+01,		1.516549866197538e+01,		1.529691982638320e+01,		1.542802146364027e+01,		1.555880456345924e+01,
		1.568927011614063e+01,		1.581941911247281e+01,		1.594925254363361e+01,		1.607877140109379e+01,		1.620797667652204e+01,
		1.633686936169187e+01,		1.646545044839014e+01,		1.659372092832742e+01,		1.672168179305005e+01,		1.684933403385387e+01,
		1.697667864169985e+01,		1.710371660713132e+01,		1.723044892019296e+01,		1.735687657035156e+01,		1.748300054641845e+01,
		1.760882183647362e+01,		1.773434142779157e+01,		1.785956030676885e+01,		1.798447945885318e+01,		1.810909986847435e+01,
		1.823342251897663e+01,		1.835744839255291e+01,		1.848117847018035e+01,		1.860461373155771e+01,		1.872775515504420e+01,
		1.885060371759985e+01,		1.897316039472748e+01,		1.909542616041614e+01,		1.921740198708606e+01,		1.933908884553506e+01,
		1.946048770488645e+01,		1.958159953253831e+01,		1.970242529411417e+01,		1.982296595341520e+01,		1.994322247237361e+01,
		2.006319581100751e+01,		2.018288692737700e+01,		2.030229677754170e+01,		2.042142631551941e+01,		2.054027649324613e+01,
		2.065884826053728e+01,		2.077714256505013e+01,		2.089516035224749e+01,		2.101290256536243e+01,		2.113037014536430e+01,
		2.124756403092585e+01,		2.136448515839131e+01,		2.148113446174583e+01,		2.159751287258568e+01,		2.171362132008975e+01,
		2.182946073099190e+01,		2.194503202955443e+01,		2.206033613754243e+01,		2.217537397419917e+01,		2.229014645622243e+01,
		2.240465449774166e+01,		2.251889901029616e+01,		2.263288090281408e+01,		2.274660108159228e+01,		2.286006045027705e+01,
		2.297325990984568e+01,		2.308620035858877e+01,		2.319888269209341e+01,		2.331130780322704e+01,		2.342347658212220e+01,
		2.353538991616182e+01,		2.364704868996540e+01,		2.375845378537588e+01,		2.386960608144700e+01,		2.398050645443164e+01,
		2.409115577777052e+01,		2.420155492208172e+01,		2.431170475515075e+01,		2.442160614192126e+01,		2.453125994448628e+01,
		2.464066702208009e+01,		2.474982823107069e+01,		2.485874442495264e+01,		2.496741645434069e+01,		2.507584516696373e+01,
		2.518403140765929e+01,		2.529197601836862e+01,		2.539967983813211e+01,		2.550714370308533e+01,		2.561436844645534e+01,
		2.572135489855768e+01,		2.582810388679352e+01,		2.593461623564748e+01,		2.604089276668564e+01,		2.614693429855413e+01,
		2.625274164697800e+01,		2.635831562476047e+01,		2.646365704178253e+01,		2.656876670500304e+01,		2.667364541845889e+01,
		2.677829398326580e+01,		2.688271319761921e+01,		2.698690385679566e+01,		2.709086675315428e+01,		2.719460267613878e+01,
		2.729811241227959e+01,		2.740139674519636e+01,		2.750445645560060e+01,		2.760729232129880e+01,		2.770990511719555e+01,
		2.781229561529712e+01,		2.791446458471514e+01,		2.801641279167056e+01,		2.811814099949789e+01,		2.821964996864952e+01,
		2.832094045670034e+01,		2.842201321835260e+01,		2.852286900544088e+01,		2.862350856693723e+01,		2.872393264895666e+01,
		2.882414199476257e+01,		2.892413734477258e+01,		2.902391943656433e+01,		2.912348900488156e+01,		2.922284678164034e+01,
		2.932199349593534e+01,		2.942092987404635e+01,		2.951965663944497e+01,		2.961817451280127e+01,		2.971648421199074e+01,
		2.981458645210124e+01,		2.991248194544020e+01,		3.001017140154180e+01,		3.010765552717432e+01,		3.020493502634763e+01,
		3.030201060032073e+01,		3.039888294760934e+01,		3.049555276399375e+01,		3.059202074252655e+01,		3.068828757354060e+01,
		3.078435394465702e+01,		3.088022054079324e+01,		3.097588804417114e+01,		3.107135713432537e+01,		3.116662848811148e+01,
		3.126170277971438e+01,		3.135658068065672e+01,		3.145126285980734e+01,		3.154574998338986e+01,		3.164004271499116e+01,
		3.173414171557010e+01,		3.182804764346611e+01,		3.192176115440804e+01,		3.201528290152274e+01,		3.210861353534401e+01,
		3.220175370382135e+01,		3.229470405232890e+01,		3.238746522367431e+01,		3.248003785810766e+01,		3.257242259333042e+01,
		3.266462006450450e+01,		3.275663090426121e+01,		3.284845574271029e+01,		3.294009520744902e+01,		3.303154992357122e+01,
		3.312282051367642e+01,		3.321390759787894e+01,		3.330481179381690e+01,		3.339553371666161e+01,		3.348607397912642e+01,
		3.357643319147606e+01,		3.366661196153576e+01,		3.375661089470039e+01,		3.384643059394359e+01,		3.393607165982703e+01,
		3.402553469050956e+01,		3.411482028175634e+01,		3.420392902694802e+01,		3.429286151709000e+01,		3.438161834082144e+01,
		3.447020008442460e+01,		3.455860733183389e+01,		3.464684066464503e+01,		3.473490066212423e+01,		3.482278790121734e+01,
		3.491050295655892e+01,		3.499804640048146e+01,		3.508541880302435e+01,		3.517262073194309e+01,		3.525965275271840e+01,
		3.534651542856511e+01,		3.543320932044148e+01,		3.551973498705801e+01,		3.560609298488663e+01,		3.569228386816962e+01,
		3.577830818892865e+01,		3.586416649697374e+01,		3.594985933991227e+01,		3.603538726315783e+01,		3.612075080993922e+01,
		3.620595052130936e+01,		3.629098693615412e+01,		3.637586059120125e+01,		3.646057202102916e+01,		3.654512175807577e+01,
		3.662951033264736e+01,		3.671373827292726e+01,		3.679780610498465e+01,		3.688171435278336e+01,		3.696546353819039e+01,
		3.704905418098484e+01,		3.713248679886639e+01,		3.721576190746403e+01,		3.729888002034460e+01,		3.738184164902148e+01,
		3.746464730296307e+01,		3.754729748960131e+01,		3.762979271434028e+01,		3.771213348056465e+01,		3.779432028964808e+01,
		3.787635364096179e+01,		3.795823403188272e+01,		3.803996195780224e+01,		3.812153791213422e+01,		3.820296238632349e+01,
		3.828423586985412e+01,		3.836535885025767e+01,		3.844633181312145e+01,		3.852715524209672e+01,		3.860782961890690e+01,
		3.868835542335565e+01,		3.876873313333515e+01,		3.884896322483406e+01,		3.892904617194562e+01,		3.900898244687576e+01,
		3.908877251995106e+01,		3.916841685962675e+01,		3.924791593249468e+01,		3.932727020329120e+01,		3.940648013490511e+01,
		3.948554618838556e+01,		3.956446882294980e+01,		3.964324849599105e+01,		3.972188566308631e+01,		3.980038077800403e+01,
		3.987873429271191e+01,		3.995694665738458e+01,		4.003501832041127e+01,		4.011294972840336e+01,		4.019074132620218e+01,
		4.026839355688638e+01,		4.034590686177964e+01,		4.042328168045804e+01,		4.050051845075771e+01,		4.057761760878220e+01,
		4.065457958890992e+01,		4.073140482380150e+01,		4.080809374440733e+01,		4.088464677997469e+01,		4.096106435805524e+01,
		4.103734690451214e+01,		4.111349484352751e+01,		4.118950859760947e+01,		4.126538858759944e+01,		4.134113523267932e+01,
		4.141674895037855e+01,		4.149223015658132e+01,		4.156757926553356e+01,		4.164279668985008e+01,		4.171788284052153e+01,
		4.179283812692144e+01,		4.186766295681316e+01,		4.194235773635686e+01,		4.201692287011631e+01,		4.209135876106589e+01,
		4.216566581059745e+01,		4.223984441852701e+01,		4.231389498310170e+01,		4.238781790100640e+01,		4.246161356737060e+01,
		4.253528237577506e+01,		4.260882471825844e+01,		4.268224098532410e+01,		4.275553156594658e+01,		4.282869684757829e+01,
		4.290173721615602e+01,		4.297465305610761e+01,		4.304744475035828e+01,		4.312011268033733e+01,		4.319265722598438e+01,
		4.326507876575605e+01,		4.333737767663217e+01,		4.340955433412223e+01,		4.348160911227180e+01,		4.355354238366876e+01,
		4.362535451944962e+01,		4.369704588930588e+01,		4.376861686149017e+01,		4.384006780282250e+01,		4.391139907869647e+01,
		4.398261105308548e+01,		4.405370408854880e+01,		4.412467854623769e+01,		4.419553478590152e+01,		4.426627316589389e+01,
		4.433689404317841e+01,		4.440739777333514e+01,		4.447778471056616e+01,		4.454805520770178e+01,		4.461820961620632e+01,
		4.468824828618420e+01,		4.475817156638563e+01,		4.482797980421258e+01,		4.489767334572454e+01,		4.496725253564443e+01,
		4.503671771736427e+01,		4.510606923295098e+01,		4.517530742315214e+01,		4.524443262740163e+01,		4.531344518382535e+01,
		4.538234542924693e+01,		4.545113369919316e+01,		4.551981032789995e+01,		4.558837564831752e+01,		4.565682999211619e+01,
		4.572517368969192e+01,		4.579340707017168e+01,		4.586153046141906e+01,		4.592954419003972e+01,		4.599744858138667e+01,
		4.606524395956593e+01,		4.613293064744175e+01,		4.620050896664202e+01,		4.626797923756363e+01,		4.633534177937772e+01,
		4.640259691003511e+01,		4.646974494627143e+01,		4.653678620361244e+01,		4.660372099637924e+01,		4.667054963769349e+01,
		4.673727243948257e+01,		4.680388971248477e+01,		4.687040176625430e+01,		4.693680890916661e+01,		4.700311144842334e+01,
		4.706930969005735e+01,		4.713540393893789e+01,		4.720139449877553e+01,		4.726728167212723e+01,		4.733306576040121e+01,
		4.739874706386200e+01,		4.746432588163533e+01,		4.752980251171310e+01,		4.759517725095814e+01,		4.766045039510925e+01,
		4.772562223878589e+01,		4.779069307549310e+01,		4.785566319762626e+01,		4.792053289647590e+01,		4.798530246223243e+01,
		4.804997218399090e+01,		4.811454234975574e+01,		4.817901324644539e+01,		4.824338515989701e+01,		4.830765837487120e+01,
		4.837183317505652e+01,		4.843590984307416e+01,		4.849988866048258e+01,		4.856376990778201e+01,		4.862755386441897e+01,
		4.869124080879093e+01,		4.875483101825078e+01,		4.881832476911119e+01,		4.888172233664925e+01,		4.894502399511086e+01,
		4.900823001771511e+01,		4.907134067665882e+01,		4.913435624312071e+01,		4.919727698726606e+01,		4.926010317825084e+01,
		4.932283508422610e+01,		4.938547297234236e+01,		4.944801710875380e+01,		4.951046775862260e+01,		4.957282518612315e+01,
		4.963508965444632e+01,		4.969726142580370e+01,		4.975934076143174e+01,		4.982132792159592e+01,		4.988322316559507e+01,
		4.994502675176521e+01,		5.000673893748404e+01,		5.006835997917472e+01,		5.012989013231017e+01,		5.019132965141699e+01,
		5.025267879007968e+01,		5.031393780094452e+01,		5.037510693572359e+01,		5.043618644519892e+01,		5.049717657922626e+01
	},
	{
		8.400623847015737e-02,		2.518854693273826e-01,		4.193631834155824e-01,		5.864402525450443e-01,		7.531175254201335e-01,
		9.193958294711455e-01,		1.085275972595855e+00,		1.250758744814437e+00,		1.415844919841270e+00,		1.580535256577031e+00,
		1.744830500524287e+00,		1.908731385129740e+00,		2.072238633056093e+00,		2.235352957386421e+00,		2.398075062763835e+00,
		2.560405646469052e+00,		2.722345399438497e+00,		2.883895007225335e+00,		3.045055150905847e+00,		3.205826507933419e+00,
		3.366209752942331e+00,		3.526205558503484e+00,		3.685814595834078e+00,		3.845037535463214e+00,		4.003875047855321e+00,
		4.162327803993215e+00,		4.320396475922546e+00,		4.478081737259318e+00,		4.635384263662132e+00,		4.792304733270695e+00,
		4.948843827112124e+00,		5.105002229476481e+00,		5.260780628262966e+00,		5.416179715298094e+00,		5.571200186627177e+00,
		5.725842742780341e+00,		5.880108089014309e+00,		6.033996935531087e+00,		6.187509997674691e+00,		6.340647996106968e+00,
		6.493411656963556e+00,		6.645801711991004e+00,		6.797818898665951e+00,		6.949463960297338e+00,		7.100737646112505e+00,
		7.251640711328053e+00,		7.402173917206261e+00,		7.552338031097831e+00,		7.702133826471790e+00,		7.851562082933164e+00,
		8.000623586229212e+00,		8.149319128244827e+00,		8.297649506987778e+00,		8.445615526564387e+00,		8.593217997146240e+00,
		8.740457734928484e+00,		8.887335562080256e+00,		9.033852306687780e+00,		9.180008802690564e+00,		9.325805889811249e+00,
		9.471244413479520e+00,		9.616325224750504e+00,		9.761049180218086e+00,		9.905417141923522e+00,		1.004942997725978e+01,
		1.019308855887184e+01,		1.033639376455348e+01,		1.047934647714071e+01,		1.062194758440219e+01,		1.076419797892711e+01,
		1.090609855801051e+01,		1.104765022353656e+01,		1.118885388185996e+01,		1.132971044368564e+01,		1.147022082394716e+01,
		1.161038594168382e+01,		1.175020671991684e+01,		1.188968408552474e+01,		1.202881896911815e+01,		1.216761230491410e+01,
		1.230606503061018e+01,		1.244417808725849e+01,		1.258195241913962e+01,		1.271938897363692e+01,		1.285648870111097e+01,
		1.299325255477449e+01,		1.312968149056785e+01,		1.326577646703517e+01,		1.340153844520120e+01,		1.353696838844902e+01,
		1.367206726239871e+01,		1.380683603478700e+01,		1.394127567534799e+01,		1.407538715569508e+01,		1.420917144920406e+01,
		1.434262953089751e+01,		1.447576237733056e+01,		1.460857096647799e+01,		1.474105627762275e+01,		1.487321929124603e+01,
		1.500506098891874e+01,		1.513658235319461e+01,		1.526778436750481e+01,		1.539866801605421e+01,		1.552923428371926e+01,
		1.565948415594742e+01,		1.578941861865846e+01,		1.591903865814717e+01,		1.604834526098801e+01,		1.617733941394126e+01,
		1.630602210386100e+01,		1.643439431760476e+01,		1.656245704194485e+01,		1.669021126348150e+01,		1.681765796855758e+01,
		1.694479814317515e+01,		1.707163277291368e+01,		1.719816284284995e+01,		1.732438933747964e+01,		1.745031324064069e+01,
		1.757593553543821e+01,		1.770125720417118e+01,		1.782627922826074e+01,		1.795100258818011e+01,		1.807542826338616e+01,
		1.819955723225265e+01,		1.832339047200498e+01,		1.844692895865653e+01,		1.857017366694668e+01,		1.869312557028021e+01,
		1.881578564066837e+01,		1.893815484867138e+01,		1.906023416334250e+01,		1.918202455217343e+01,		1.930352698104138e+01,
		1.942474241415738e+01,		1.954567181401607e+01,		1.966631614134696e+01,		1.978667635506694e+01,		1.990675341223420e+01,
		2.002654826800351e+01,		2.014606187558274e+01,		2.026529518619072e+01,		2.038424914901639e+01,		2.050292471117904e+01,
		2.062132281769005e+01,		2.073944441141552e+01,		2.085729043304034e+01,		2.097486182103324e+01,		2.109215951161309e+01,
		2.120918443871627e+01,		2.132593753396513e+01,		2.144241972663751e+01,		2.155863194363741e+01,		2.167457510946656e+01,
		2.179025014619707e+01,		2.190565797344511e+01,		2.202079950834547e+01,		2.213567566552712e+01,		2.225028735708975e+01,
		2.236463549258114e+01,		2.247872097897545e+01,		2.259254472065241e+01,		2.270610761937731e+01,		2.281941057428195e+01,
		2.293245448184621e+01,		2.304524023588058e+01,		2.315776872750944e+01,		2.327004084515503e+01,		2.338205747452229e+01,
		2.349381949858429e+01,		2.360532779756849e+01,		2.371658324894361e+01,		2.382758672740724e+01,		2.393833910487410e+01,
		2.404884125046486e+01,		2.415909403049577e+01,		2.426909830846873e+01,		2.437885494506203e+01,		2.448836479812173e+01,
		2.459762872265350e+01,		2.470664757081510e+01,		2.481542219190936e+01,		2.492395343237775e+01,		2.503224213579437e+01,
		2.514028914286049e+01,		2.524809529139962e+01,		2.535566141635300e+01,		2.546298834977554e+01,		2.557007692083229e+01,
		2.567692795579524e+01,		2.578354227804067e+01,		2.588992070804680e+01,		2.599606406339191e+01,		2.610197315875284e+01,
		2.620764880590389e+01,		2.631309181371603e+01,		2.641830298815653e+01,		2.652328313228892e+01,		2.662803304627333e+01,
		2.673255352736705e+01,		2.683684536992552e+01,		2.694090936540363e+01,		2.704474630235722e+01,		2.714835696644503e+01,
		2.725174214043073e+01,		2.735490260418546e+01,		2.745783913469046e+01,		2.756055250604001e+01,		2.766304348944470e+01,
		2.776531285323478e+01,		2.786736136286392e+01,		2.796918978091310e+01,		2.807079886709473e+01,		2.817218937825704e+01,
		2.827336206838856e+01,		2.837431768862295e+01,		2.847505698724393e+01,		2.857558070969039e+01,		2.867588959856175e+01,
		2.877598439362344e+01,		2.887586583181258e+01,		2.897553464724377e+01,		2.907499157121510e+01,		2.917423733221434e+01,
		2.927327265592512e+01,		2.937209826523347e+01,		2.947071488023430e+01,		2.956912321823814e+01,		2.966732399377798e+01,
		2.976531791861615e+01,		2.986310570175145e+01,		2.996068804942630e+01,		3.005806566513403e+01,		3.015523924962625e+01,
		3.025220950092036e+01,		3.034897711430714e+01,		3.044554278235839e+01,		3.054190719493476e+01,		3.063807103919353e+01,
		3.073403499959660e+01,		3.082979975791845e+01,		3.092536599325426e+01,		3.102073438202804e+01,		3.111590559800088e+01,
		3.121088031227917e+01,		3.130565919332302e+01,		3.140024290695465e+01,		3.149463211636680e+01,		3.158882748213128e+01,
		3.168282966220758e+01,		3.177663931195131e+01,		3.187025708412310e+01,		3.196368362889706e+01,		3.205691959386969e+01,
		3.214996562406853e+01,		3.224282236196103e+01,		3.233549044746338e+01,		3.242797051794937e+01,		3.252026320825929e+01,
		3.261236915070884e+01,		3.270428897509812e+01,		3.279602330872056e+01,		3.288757277637188e+01,		3.297893800035923e+01,
		3.307011960051005e+01,		3.316111819418124e+01,		3.325193439626813e+01,		3.334256881921361e+01,		3.343302207301713e+01,
		3.352329476524391e+01,		3.361338750103390e+01,		3.370330088311095e+01,		3.379303551179191e+01,		3.388259198499573e+01,
		3.397197089825256e+01,		3.406117284471288e+01,		3.415019841515660e+01,		3.423904819800213e+01,		3.432772277931557e+01,
		3.441622274281976e+01,		3.450454866990335e+01,		3.459270113962994e+01,		3.468068072874714e+01,		3.476848801169564e+01,
		3.485612356061836e+01,		3.494358794536934e+01,		3.503088173352295e+01,		3.511800549038281e+01,		3.520495977899094e+01,
		3.529174516013660e+01,		3.537836219236549e+01,		3.546481143198852e+01,		3.555109343309101e+01,		3.563720874754138e+01,
		3.572315792500032e+01,		3.580894151292960e+01,		3.589456005660096e+01,		3.598001409910503e+01,		3.606530418136020e+01,
		3.615043084212142e+01,		3.623539461798905e+01,		3.632019604341775e+01,		3.640483565072507e+01,		3.648931397010045e+01,
		3.657363152961373e+01,		3.665778885522406e+01,		3.674178647078848e+01,		3.682562489807067e+01,		3.690930465674956e+01,
		3.699282626442795e+01,		3.707619023664110e+01,		3.715939708686542e+01,		3.724244732652692e+01,		3.732534146500970e+01,
		3.740808000966466e+01,		3.749066346581770e+01,		3.757309233677842e+01,		3.765536712384839e+01,		3.773748832632967e+01,
		3.781945644153309e+01,		3.790127196478664e+01,		3.798293538944382e+01,		3.806444720689188e+01,		3.814580790656017e+01,
		3.822701797592824e+01,		3.830807790053428e+01,		3.838898816398304e+01,		3.846974924795421e+01,		3.855036163221048e+01,
		3.863082579460556e+01,		3.871114221109238e+01,		3.879131135573108e+01,		3.887133370069700e+01,		3.895120971628874e+01,
		3.903093987093610e+01,		3.911052463120796e+01,		3.918996446182027e+01,		3.926925982564383e+01,		3.934841118371225e+01,
		3.942741899522969e+01,		3.950628371757866e+01,		3.958500580632781e+01,		3.966358571523961e+01,		3.974202389627815e+01,
		3.982032079961669e+01,		3.989847687364540e+01,		3.997649256497895e+01,		4.005436831846407e+01,		4.013210457718716e+01,
		4.020970178248171e+01,		4.028716037393602e+01,		4.036448078940038e+01,		4.044166346499476e+01,		4.051870883511608e+01,
		4.059561733244564e+01,		4.067238938795649e+01,		4.074902543092071e+01,		4.082552588891677e+01,		4.090189118783669e+01,
		4.097812175189346e+01,		4.105421800362804e+01,		4.113018036391668e+01,		4.120600925197802e+01,		4.128170508538025e+01,
		4.135726828004815e+01,		4.143269925027018e+01,		4.150799840870556e+01,		4.158316616639119e+01,		4.165820293274871e+01,
		4.173310911559142e+01,		4.180788512113118e+01,		4.188253135398536e+01,		4.195704821718363e+01,		4.203143611217489e+01,
		4.210569543883396e+01,		4.217982659546851e+01,		4.225382997882571e+01,		4.232770598409888e+01,		4.240145500493449e+01,
		4.247507743343840e+01,		4.254857366018288e+01,		4.262194407421300e+01,		4.269518906305335e+01,		4.276830901271440e+01,
		4.284130430769932e+01,		4.291417533101021e+01,		4.298692246415476e+01,		4.305954608715262e+01,		4.313204657854178e+01,
		4.320442431538508e+01,		4.327667967327648e+01,		4.334881302634746e+01,		4.342082474727324e+01,		4.349271520727920e+01,
		4.356448477614708e+01,		4.363613382222110e+01,		4.370766271241439e+01,		4.377907181221497e+01,		4.385036148569201e+01,
		4.392153209550194e+01,		4.399258400289453e+01,		4.406351756771895e+01,		4.413433314842987e+01,		4.420503110209346e+01,
		4.427561178439334e+01,		4.434607554963664e+01,		4.441642275075987e+01,		4.448665373933486e+01,		4.455676886557466e+01,
		4.462676847833943e+01,		4.469665292514223e+01,		4.476642255215487e+01,		4.483607770421374e+01,		4.490561872482547e+01,
		4.497504595617280e+01,		4.504435973912020e+01,		4.511356041321962e+01,		4.518264831671606e+01,		4.525162378655344e+01,
		4.532048715837991e+01,		4.538923876655367e+01,		4.545787894414853e+01,		4.552640802295928e+01,		4.559482633350738e+01,
		4.566313420504641e+01,		4.573133196556753e+01,		4.579941994180496e+01,		4.586739845924132e+01,		4.593526784211312e+01,
		4.600302841341612e+01,		4.607068049491065e+01,		4.613822440712701e+01,		4.620566046937067e+01,		4.627298899972766e+01,
		4.634021031506973e+01,		4.640732473105971e+01,		4.647433256215658e+01,		4.654123412162082e+01,		4.660802972151943e+01,
		4.667471967273116e+01,		4.674130428495162e+01,		4.680778386669838e+01,		4.687415872531605e+01,		4.694042916698126e+01,
		4.700659549670787e+01,		4.707265801835178e+01,		4.713861703461606e+01,		4.720447284705585e+01,		4.727022575608332e+01,
		4.733587606097259e+01,		4.740142405986466e+01,		4.746687004977224e+01,		4.753221432658464e+01,		4.759745718507258e+01,
		4.766259891889307e+01,		4.772763982059412e+01,		4.779258018161953e+01,		4.785742029231368e+01,		4.792216044192625e+01,
		4.798680091861691e+01,		4.805134200946000e+01,		4.811578400044922e+01,		4.818012717650224e+01,		4.824437182146541e+01,
		4.830851821811821e+01,		4.837256664817805e+01,		4.843651739230461e+01,		4.850037073010456e+01,		4.856412694013596e+01,
		4.862778629991280e+01,		4.869134908590954e+01,		4.875481557356553e+01,		4.881818603728939e+01,		4.888146075046358e+01,
		4.894463998544861e+01,		4.900772401358761e+01,		4.907071310521059e+01,		4.913360752963877e+01,		4.919640755518900e+01,
		4.925911344917800e+01,		4.932172547792656e+01,		4.938424390676401e+01,		4.944666900003231e+01,		4.950900102109033e+01,
		4.957124023231807e+01,		4.963338689512078e+01,		4.969544126993323e+01,		4.975740361622385e+01,		4.981927419249877e+01,
		4.988105325630602e+01,		4.994274106423963e+01,		5.000433787194365e+01,		5.006584393411633e+01,		5.012725950451394e+01,
		5.018858483595507e+01,		5.024982018032441e+01,		5.031096578857688e+01,		5.037202191074149e+01,		5.043298879592543e+01
	},
	{
		8.383104098838158e-02,		2.513605099362906e-01,		4.184897750811650e-01,		5.852197088151408e-01,		7.515511606207130e-01,
		9.174849588800648e-01,		1.083021912595340e+00,		1.248162813023473e+00,		1.412908435229058e+00,		1.577259539558571e+00,
		1.741216873039157e+00,		1.904781170705043e+00,		2.067953156854538e+00,		2.230733546240445e+00,		2.393123045196616e+00,
		2.555122352703273e+00,		2.716732161393626e+00,		2.877953158504190e+00,		3.038786026771168e+00,		3.199231445275135e+00,
		3.359290090236174e+00,		3.518962635761583e+00,		3.678249754548130e+00,		3.837152118540808e+00,		3.995670399549938e+00,
		4.153805269828442e+00,		4.311557402610982e+00,		4.468927472616655e+00,		4.625916156516832e+00,		4.782524133369714e+00,
		4.938752085023057e+00,		5.094600696486531e+00,		5.250070656275077e+00,		5.405162656724621e+00,		5.559877394281375e+00,
		5.714215569766019e+00,		5.868177888613912e+00,		6.021765061092498e+00,		6.174977802496993e+00,		6.327816833325429e+00,
		6.480282879434055e+00,		6.632376672174106e+00,		6.784098948510851e+00,		6.935450451125858e+00,		7.086431928503312e+00,
		7.237044135001280e+00,		7.387287830908666e+00,		7.537163782488678e+00,		7.686672762009535e+00,		7.835815547763108e+00,
		7.984592924072230e+00,		8.133005681287274e+00,		8.281054615772677e+00,		8.428740529883983e+00,		8.576064231936027e+00,
		8.723026536162735e+00,		8.869628262669186e+00,		9.015870237376344e+00,		9.161753291959000e+00,		9.307278263777391e+00,
		9.452445995802904e+00,		9.597257336538364e+00,		9.741713139933232e+00,		9.885814265294142e+00,		1.002956157719118e+01,
		1.017295594536018e+01,		1.031599824460149e+01,		1.045868935467537e+01,		1.060103016019451e+01,		1.074302155051383e+01,
		1.088466441961791e+01,		1.102595966600624e+01,		1.116690819257665e+01,		1.130751090650708e+01,		1.144776871913590e+01,
		1.158768254584112e+01,		1.172725330591847e+01,		1.186648192245885e+01,		1.200536932222501e+01,		1.214391643552786e+01,
		1.228212419610252e+01,		1.241999354098418e+01,		1.255752541038399e+01,		1.269472074756517e+01,		1.283158049871931e+01,
		1.296810561284315e+01,		1.310429704161583e+01,		1.324015573927675e+01,		1.337568266250426e+01,		1.351087877029498e+01,
		1.364574502384423e+01,		1.378028238642727e+01,		1.391449182328170e+01,		1.404837430149095e+01,		1.418193078986893e+01,
		1.431516225884604e+01,		1.444806968035634e+01,		1.458065402772618e+01,		1.471291627556419e+01,		1.484485739965268e+01,
		1.497647837684060e+01,		1.510778018493795e+01,		1.523876380261174e+01,		1.536943020928352e+01,		1.549978038502855e+01,
		1.562981531047649e+01,		1.575953596671385e+01,		1.588894333518792e+01,		1.601803839761256e+01,		1.614682213587545e+01,
		1.627529553194721e+01,		1.640345956779203e+01,		1.653131522528018e+01,		1.665886348610195e+01,		1.678610533168355e+01,
		1.691304174310454e+01,		1.703967370101692e+01,		1.716600218556600e+01,		1.729202817631290e+01,		1.741775265215863e+01,
		1.754317659127000e+01,		1.766830097100697e+01,		1.779312676785181e+01,		1.791765495733974e+01,		1.804188651399129e+01,
		1.816582241124613e+01,		1.828946362139860e+01,		1.841281111553477e+01,		1.853586586347094e+01,		1.865862883369380e+01,
		1.878110099330207e+01,		1.890328330794958e+01,		1.902517674178984e+01,		1.914678225742217e+01,		1.926810081583905e+01,
		1.938913337637514e+01,		1.950988089665747e+01,		1.963034433255718e+01,		1.975052463814250e+01,		1.987042276563311e+01,
		1.999003966535584e+01,		2.010937628570161e+01,		2.022843357308366e+01,		2.034721247189707e+01,		2.046571392447946e+01,
		2.058393887107291e+01,		2.070188824978708e+01,		2.081956299656354e+01,		2.093696404514110e+01,		2.105409232702248e+01,
		2.117094877144188e+01,		2.128753430533375e+01,		2.140384985330265e+01,		2.151989633759398e+01,		2.163567467806598e+01,
		2.175118579216250e+01,		2.186643059488692e+01,		2.198140999877691e+01,		2.209612491388024e+01,		2.221057624773139e+01,
		2.232476490532921e+01,		2.243869178911534e+01,		2.255235779895355e+01,		2.266576383210991e+01,		2.277891078323377e+01,
		2.289179954433967e+01,		2.300443100478983e+01,		2.311680605127760e+01,		2.322892556781157e+01,		2.334079043570045e+01,
		2.345240153353868e+01,		2.356375973719269e+01,		2.367486591978798e+01,		2.378572095169668e+01,		2.389632570052594e+01,
		2.400668103110685e+01,		2.411678780548410e+01,		2.422664688290608e+01,		2.433625911981572e+01,		2.444562536984188e+01,
		2.455474648379126e+01,		2.466362330964091e+01,		2.477225669253123e+01,		2.488064747475960e+01,		2.498879649577432e+01,
		2.509670459216927e+01,		2.520437259767895e+01,		2.531180134317393e+01,		2.541899165665692e+01,		2.552594436325910e+01,
		2.563266028523708e+01,		2.573914024197008e+01,		2.584538504995774e+01,		2.595139552281811e+01,		2.605717247128620e+01,
		2.616271670321285e+01,		2.626802902356393e+01,		2.637311023441993e+01,		2.647796113497597e+01,		2.658258252154199e+01,
		2.668697518754343e+01,		2.679113992352211e+01,		2.689507751713748e+01,		2.699878875316817e+01,		2.710227441351381e+01,
		2.720553527719712e+01,		2.730857212036636e+01,		2.741138571629790e+01,		2.751397683539922e+01,		2.761634624521195e+01,
		2.771849471041543e+01,		2.782042299283021e+01,		2.792213185142202e+01,		2.802362204230576e+01,		2.812489431874988e+01,
		2.822594943118087e+01,		2.832678812718792e+01,		2.842741115152789e+01,		2.852781924613035e+01,		2.862801315010282e+01,
		2.872799359973634e+01,		2.882776132851090e+01,		2.892731706710136e+01,		2.902666154338331e+01,		2.912579548243917e+01,
		2.922471960656442e+01,		2.932343463527396e+01,		2.942194128530864e+01,		2.952024027064187e+01,		2.961833230248640e+01,
		2.971621808930119e+01,		2.981389833679845e+01,		2.991137374795069e+01,		3.000864502299800e+01,		3.010571285945536e+01,
		3.020257795212004e+01,		3.029924099307920e+01,		3.039570267171734e+01,		3.049196367472426e+01,		3.058802468610256e+01,
		3.068388638717570e+01,		3.077954945659592e+01,		3.087501457035216e+01,		3.097028240177826e+01,		3.106535362156105e+01,
		3.116022889774861e+01,		3.125490889575850e+01,		3.134939427838614e+01,		3.144368570581321e+01,		3.153778383561603e+01,
		3.163168932277418e+01,		3.172540281967891e+01,		3.181892497614180e+01,		3.191225643940338e+01,		3.200539785414177e+01,
		3.209834986248145e+01,		3.219111310400192e+01,		3.228368821574654e+01,		3.237607583223129e+01,		3.246827658545362e+01,
		3.256029110490129e+01,		3.265212001756132e+01,		3.274376394792879e+01,		3.283522351801584e+01,		3.292649934736059e+01,
		3.301759205303610e+01,		3.310850224965937e+01,		3.319923054940030e+01,		3.328977756199067e+01,		3.338014389473325e+01,
		3.347033015251070e+01,		3.356033693779467e+01,		3.365016485065487e+01,		3.373981448876798e+01,		3.382928644742682e+01,
		3.391858131954936e+01,		3.400769969568771e+01,		3.409664216403729e+01,		3.418540931044571e+01,		3.427400171842199e+01,
		3.436241996914542e+01,		3.445066464147472e+01,		3.453873631195707e+01,		3.462663555483704e+01,		3.471436294206570e+01,
		3.480191904330951e+01,		3.488930442595948e+01,		3.497651965513998e+01,		3.506356529371788e+01,		3.515044190231133e+01,
		3.523715003929892e+01,		3.532369026082846e+01,		3.541006312082590e+01,		3.549626917100439e+01,		3.558230896087296e+01,
		3.566818303774561e+01,		3.575389194674997e+01,		3.583943623083633e+01,		3.592481643078627e+01,		3.601003308522164e+01,
		3.609508673061324e+01,		3.617997790128965e+01,		3.626470712944592e+01,		3.634927494515230e+01,		3.643368187636301e+01,
		3.651792844892488e+01,		3.660201518658597e+01,		3.668594261100431e+01,		3.676971124175642e+01,		3.685332159634597e+01,
		3.693677419021230e+01,		3.702006953673904e+01,		3.710320814726254e+01,		3.718619053108041e+01,		3.726901719546007e+01,
		3.735168864564707e+01,		3.743420538487360e+01,		3.751656791436684e+01,		3.759877673335741e+01,		3.768083233908764e+01,
		3.776273522681985e+01,		3.784448588984484e+01,		3.792608481948994e+01,		3.800753250512739e+01,		3.808882943418246e+01,
		3.816997609214175e+01,		3.825097296256124e+01,		3.833182052707450e+01,		3.841251926540075e+01,		3.849306965535298e+01,
		3.857347217284592e+01,		3.865372729190420e+01,		3.873383548467021e+01,		3.881379722141216e+01,		3.889361297053189e+01,
		3.897328319857302e+01,		3.905280837022853e+01,		3.913218894834887e+01,		3.921142539394964e+01,		3.929051816621942e+01,
		3.936946772252755e+01,		3.944827451843186e+01,		3.952693900768639e+01,		3.960546164224909e+01,		3.968384287228938e+01,
		3.976208314619591e+01,		3.984018291058405e+01,		3.991814261030351e+01,		3.999596268844582e+01,		4.007364358635192e+01,
		4.015118574361963e+01,		4.022858959811096e+01,		4.030585558595972e+01,		4.038298414157883e+01,		4.045997569766769e+01,
		4.053683068521944e+01,		4.061354953352843e+01,		4.069013267019736e+01,		4.076658052114457e+01,		4.084289351061128e+01,
		4.091907206116873e+01,		4.099511659372545e+01,		4.107102752753423e+01,		4.114680528019937e+01,		4.122245026768366e+01,
		4.129796290431553e+01,		4.137334360279594e+01,		4.144859277420549e+01,		4.152371082801130e+01,		4.159869817207395e+01,
		4.167355521265448e+01,		4.174828235442114e+01,		4.182288000045626e+01,		4.189734855226324e+01,		4.197168840977306e+01,
		4.204589997135125e+01,		4.211998363380459e+01,		4.219393979238775e+01,		4.226776884081007e+01,		4.234147117124214e+01,
		4.241504717432241e+01,		4.248849723916388e+01,		4.256182175336055e+01,		4.263502110299410e+01,		4.270809567264025e+01,
		4.278104584537539e+01,		4.285387200278295e+01,		4.292657452495986e+01,		4.299915379052297e+01,		4.307161017661539e+01,
		4.314394405891293e+01,		4.321615581163026e+01,		4.328824580752737e+01,		4.336021441791583e+01,		4.343206201266487e+01,
		4.350378896020781e+01,		4.357539562754811e+01,		4.364688238026561e+01,		4.371824958252262e+01,		4.378949759707005e+01,
		4.386062678525352e+01,		4.393163750701934e+01,		4.400253012092068e+01,		4.407330498412347e+01,		4.414396245241242e+01,
		4.421450288019692e+01,		4.428492662051710e+01,		4.435523402504963e+01,		4.442542544411359e+01,		4.449550122667643e+01,
		4.456546172035969e+01,		4.463530727144484e+01,		4.470503822487908e+01,		4.477465492428109e+01,		4.484415771194674e+01,
		4.491354692885481e+01,		4.498282291467264e+01,		4.505198600776183e+01,		4.512103654518385e+01,		4.518997486270565e+01,
		4.525880129480520e+01,		4.532751617467710e+01,		4.539611983423811e+01,		4.546461260413268e+01,		4.553299481373831e+01,
		4.560126679117113e+01,		4.566942886329135e+01,		4.573748135570863e+01,		4.580542459278738e+01,		4.587325889765233e+01,
		4.594098459219368e+01,		4.600860199707250e+01,		4.607611143172610e+01,		4.614351321437312e+01,		4.621080766201893e+01,
		4.627799509046082e+01,		4.634507581429320e+01,		4.641205014691273e+01,		4.647891840052355e+01,		4.654568088614237e+01,
		4.661233791360362e+01,		4.667888979156449e+01,		4.674533682751004e+01,		4.681167932775821e+01,		4.687791759746491e+01,
		4.694405194062892e+01,		4.701008266009691e+01,		4.707601005756846e+01,		4.714183443360089e+01,		4.720755608761425e+01,
		4.727317531789618e+01,		4.733869242160679e+01,		4.740410769478344e+01,		4.746942143234572e+01,		4.753463392810009e+01,
		4.759974547474475e+01,		4.766475636387440e+01,		4.772966688598497e+01,		4.779447733047831e+01,		4.785918798566692e+01,
		4.792379913877863e+01,		4.798831107596129e+01,		4.805272408228727e+01,		4.811703844175831e+01,		4.818125443730980e+01,
		4.824537235081574e+01,		4.830939246309292e+01,		4.837331505390565e+01,		4.843714040197034e+01,		4.850086878495982e+01,
		4.856450047950791e+01,		4.862803576121384e+01,		4.869147490464673e+01,		4.875481818334995e+01,		4.881806586984559e+01,
		4.888121823563871e+01,		4.894427555122181e+01,		4.900723808607912e+01,		4.907010610869095e+01,		4.913287988653791e+01,
		4.919555968610526e+01,		4.925814577288713e+01,		4.932063841139082e+01,		4.938303786514092e+01,		4.944534439668358e+01,
		4.950755826759071e+01,		4.956967973846410e+01,		4.963170906893956e+01,		4.969364651769107e+01,		4.975549234243493e+01,
		4.981724679993369e+01,		4.987891014600049e+01,		4.994048263550285e+01,		5.000196452236685e+01,		5.006335605958111e+01,
		5.012465749920079e+01,		5.018586909235156e+01,		5.024699108923356e+01,		5.030802373912541e+01,		5.036896729038803e+01
	},
	{
		8.365657300862679e-02,		2.508377365113733e-01,		4.176200037953963e-01,		5.840042477794645e-01,		7.499913186667405e-01,
		9.155820457319099e-01,		1.080777239020480e+00,		1.245577690963814e+00,		1.409984177913315e+00,		1.573997461597045e+00,
		1.737618290501929e+00,		1.900847401184569e+00,		2.063685519513572e+00,		2.226133361846194e+00,		2.388191636141979e+00,
		2.549861043015980e+00,		2.711142276734050e+00,		2.872036026152598e+00,		3.032542975605097e+00,		3.192663805737581e+00,
		3.352399194295260e+00,		3.511749816862287e+00,		3.670716347556697e+00,		3.829299459682386e+00,		3.987499826339980e+00,
		4.145318120998384e+00,		4.302755018028682e+00,		4.459811193202041e+00,		4.616487324153229e+00,		4.772784090811223e+00,
		4.928702175798422e+00,		5.084242264799838e+00,		5.239405046903672e+00,		5.394191214914541e+00,		5.548601465640665e+00,
		5.702636500156193e+00,		5.856297024039865e+00,		6.009583747591134e+00,		6.162497386024823e+00,		6.315038659645382e+00,
		6.467208294001727e+00,		6.619007020023658e+00,		6.770435574140759e+00,		6.921494698384694e+00,		7.072185140475750e+00,
		7.222507653894470e+00,		7.372462997939149e+00,		7.522051937769962e+00,		7.671275244440495e+00,		7.820133694917313e+00,
		7.968628072088311e+00,		8.116759164760465e+00,		8.264527767647579e+00,		8.411934681348709e+00,		8.558980712317730e+00,
		8.705666672824675e+00,		8.851993380909351e+00,		8.997961660327688e+00,		9.143572340491412e+00,		9.288826256401370e+00,
		9.433724248575025e+00,		9.578267162968585e+00,		9.722455850894045e+00,		9.866291168931628e+00,		1.000977397883797e+01,
		1.015290514745036e+01,		1.029568554658744e+01,		1.043811605294666e+01,		1.058019754799863e+01,		1.072193091787905e+01,
		1.086331705327805e+01,		1.100435684932743e+01,		1.114505120548615e+01,		1.128540102542401e+01,		1.142540721690401e+01,
		1.156507069166348e+01,		1.170439236529416e+01,		1.184337315712160e+01,		1.198201399008372e+01,		1.212031579060912e+01,
		1.225827948849496e+01,		1.239590601678472e+01,		1.253319631164599e+01,		1.267015131224834e+01,		1.280677196064151e+01,
		1.294305920163394e+01,		1.307901398267178e+01,		1.321463725371855e+01,		1.334992996713544e+01,		1.348489307756246e+01,
		1.361952754180036e+01,		1.375383431869366e+01,		1.388781436901456e+01,		1.402146865534803e+01,		1.415479814197805e+01,
		1.428780379477503e+01,		1.442048658108458e+01,		1.455284746961755e+01,		1.468488743034140e+01,		1.481660743437313e+01,
		1.494800845387347e+01,		1.507909146194271e+01,		1.520985743251792e+01,		1.534030734027184e+01,		1.547044216051320e+01,
		1.560026286908871e+01,		1.572977044228663e+01,		1.585896585674196e+01,		1.598785008934329e+01,		1.611642411714117e+01,
		1.624468891725832e+01,		1.637264546680135e+01,		1.650029474277416e+01,		1.662763772199308e+01,		1.675467538100358e+01,
		1.688140869599867e+01,		1.700783864273899e+01,		1.713396619647447e+01,		1.725979233186778e+01,		1.738531802291920e+01,
		1.751054424289337e+01,		1.763547196424743e+01,		1.776010215856095e+01,		1.788443579646731e+01,		1.800847384758682e+01,
		1.813221728046121e+01,		1.825566706248988e+01,		1.837882415986756e+01,		1.850168953752354e+01,		1.862426415906235e+01,
		1.874654898670610e+01,		1.886854498123801e+01,		1.899025310194770e+01,		1.911167430657771e+01,		1.923280955127148e+01,
		1.935365979052278e+01,		1.947422597712649e+01,		1.959450906213074e+01,		1.971450999479036e+01,		1.983422972252168e+01,
		1.995366919085865e+01,		2.007282934341016e+01,		2.019171112181871e+01,		2.031031546572029e+01,		2.042864331270539e+01,
		2.054669559828134e+01,		2.066447325583569e+01,		2.078197721660093e+01,		2.089920840962009e+01,		2.101616776171371e+01,
		2.113285619744765e+01,		2.124927463910224e+01,		2.136542400664226e+01,		2.148130521768804e+01,		2.159691918748758e+01,
		2.171226682888969e+01,		2.182734905231793e+01,		2.194216676574577e+01,		2.205672087467249e+01,		2.217101228209998e+01,
		2.228504188851062e+01,		2.239881059184578e+01,		2.251231928748544e+01,		2.262556886822841e+01,		2.273856022427352e+01,
		2.285129424320162e+01,		2.296377180995819e+01,		2.307599380683693e+01,		2.318796111346402e+01,		2.329967460678304e+01,
		2.341113516104071e+01,		2.352234364777325e+01,		2.363330093579348e+01,		2.374400789117857e+01,		2.385446537725842e+01,
		2.396467425460470e+01,		2.407463538102047e+01,		2.418434961153048e+01,		2.429381779837198e+01,		2.440304079098617e+01,
		2.451201943601013e+01,		2.462075457726943e+01,		2.472924705577109e+01,		2.483749770969725e+01,		2.494550737439922e+01,
		2.505327688239205e+01,		2.516080706334964e+01,		2.526809874410021e+01,		2.537515274862235e+01,		2.548196989804136e+01,
		2.558855101062626e+01,		2.569489690178689e+01,		2.580100838407179e+01,		2.590688626716613e+01,		2.601253135789028e+01,
		2.611794446019866e+01,		2.622312637517893e+01,		2.632807790105155e+01,		2.643279983316977e+01,		2.653729296401983e+01,
		2.664155808322154e+01,		2.674559597752924e+01,		2.684940743083294e+01,		2.695299322415985e+01,		2.705635413567619e+01,
		2.715949094068926e+01,		2.726240441164980e+01,		2.736509531815456e+01,		2.746756442694924e+01,		2.756981250193156e+01,
		2.767184030415463e+01,		2.777364859183057e+01,		2.787523812033431e+01,		2.797660964220763e+01,		2.807776390716341e+01,
		2.817870166209012e+01,		2.827942365105642e+01,		2.837993061531607e+01,		2.848022329331292e+01,		2.858030242068616e+01,
		2.868016873027566e+01,		2.877982295212760e+01,		2.887926581350009e+01,		2.897849803886914e+01,		2.907752034993463e+01,
		2.917633346562649e+01,		2.927493810211105e+01,		2.937333497279742e+01,		2.947152478834409e+01,		2.956950825666573e+01,
		2.966728608293982e+01,		2.976485896961380e+01,		2.986222761641196e+01,		2.995939272034271e+01,		3.005635497570578e+01,
		3.015311507409961e+01,		3.024967370442884e+01,		3.034603155291175e+01,		3.044218930308805e+01,		3.053814763582648e+01,
		3.063390722933271e+01,		3.072946875915711e+01,		3.082483289820282e+01,		3.092000031673369e+01,		3.101497168238241e+01,
		3.110974766015865e+01,		3.120432891245727e+01,		3.129871609906665e+01,		3.139290987717691e+01,		3.148691090138842e+01,
		3.158071982372011e+01,		3.167433729361806e+01,		3.176776395796390e+01,		3.186100046108351e+01,		3.195404744475552e+01,
		3.204690554821996e+01,		3.213957540818701e+01,		3.223205765884564e+01,		3.232435293187233e+01,		3.241646185643994e+01,
		3.250838505922638e+01,		3.260012316442350e+01,		3.269167679374596e+01,		3.278304656643998e+01,		3.287423309929231e+01,
		3.296523700663912e+01,		3.305605890037486e+01,		3.314669938996125e+01,		3.323715908243616e+01,		3.332743858242262e+01,
		3.341753849213771e+01,		3.350745941140156e+01,		3.359720193764636e+01,		3.368676666592522e+01,		3.377615418892132e+01,
		3.386536509695674e+01,		3.395439997800149e+01,		3.404325941768256e+01,		3.413194399929280e+01,		3.422045430379998e+01,
		3.430879090985569e+01,		3.439695439380440e+01,		3.448494532969237e+01,		3.457276428927658e+01,		3.466041184203381e+01,
		3.474788855516939e+01,		3.483519499362632e+01,		3.492233172009408e+01,		3.500929929501757e+01,		3.509609827660608e+01,
		3.518272922084203e+01,		3.526919268149003e+01,		3.535548921010557e+01,		3.544161935604398e+01,		3.552758366646924e+01,
		3.561338268636277e+01,		3.569901695853221e+01,		3.578448702362028e+01,		3.586979342011352e+01,		3.595493668435091e+01,
		3.603991735053287e+01,		3.612473595072964e+01,		3.620939301489025e+01,		3.629388907085099e+01,		3.637822464434417e+01,
		3.646240025900671e+01,		3.654641643638877e+01,		3.663027369596227e+01,		3.671397255512952e+01,		3.679751352923169e+01,
		3.688089713155740e+01,		3.696412387335116e+01,		3.704719426382186e+01,		3.713010881015118e+01,		3.721286801750205e+01,
		3.729547238902701e+01,		3.737792242587660e+01,		3.746021862720772e+01,		3.754236149019189e+01,		3.762435151002362e+01,
		3.770618917992859e+01,		3.778787499117195e+01,		3.786940943306654e+01,		3.795079299298106e+01,		3.803202615634822e+01,
		3.811310940667286e+01,		3.819404322554011e+01,		3.827482809262344e+01,		3.835546448569274e+01,		3.843595288062222e+01,
		3.851629375139863e+01,		3.859648757012904e+01,		3.867653480704885e+01,		3.875643593052973e+01,		3.883619140708750e+01,
		3.891580170138986e+01,		3.899526727626449e+01,		3.907458859270655e+01,		3.915376610988667e+01,		3.923280028515860e+01,
		3.931169157406697e+01,		3.939044043035489e+01,		3.946904730597176e+01,		3.954751265108073e+01,		3.962583691406647e+01,
		3.970402054154259e+01,		3.978206397835929e+01,		3.985996766761090e+01,		3.993773205064319e+01,		4.001535756706102e+01,
		4.009284465473573e+01,		4.017019374981246e+01,		4.024740528671761e+01,		4.032447969816611e+01,		4.040141741516882e+01,
		4.047821886703975e+01,		4.055488448140336e+01,		4.063141468420174e+01,		4.070780989970187e+01,		4.078407055050275e+01,
		4.086019705754256e+01,		4.093618984010575e+01,		4.101204931583020e+01,		4.108777590071419e+01,		4.116337000912348e+01,
		4.123883205379830e+01,		4.131416244586030e+01,		4.138936159481956e+01,		4.146442990858140e+01,		4.153936779345342e+01,
		4.161417565415216e+01,		4.168885389381013e+01,		4.176340291398252e+01,		4.183782311465390e+01,		4.191211489424518e+01,
		4.198627864962009e+01,		4.206031477609204e+01,		4.213422366743070e+01,		4.220800571586867e+01,		4.228166131210811e+01,
		4.235519084532726e+01,		4.242859470318703e+01,		4.250187327183757e+01,		4.257502693592468e+01,		4.264805607859632e+01,
		4.272096108150909e+01,		4.279374232483462e+01,		4.286640018726595e+01,		4.293893504602391e+01,		4.301134727686341e+01,
		4.308363725407987e+01,		4.315580535051539e+01,		4.322785193756499e+01,		4.329977738518295e+01,		4.337158206188897e+01,
		4.344326633477425e+01,		4.351483056950784e+01,		4.358627513034253e+01,		4.365760038012113e+01,		4.372880668028250e+01,
		4.379989439086750e+01,		4.387086387052515e+01,		4.394171547651854e+01,		4.401244956473080e+01,		4.408306648967113e+01,
		4.415356660448055e+01,		4.422395026093796e+01,		4.429421780946592e+01,		4.436436959913654e+01,		4.443440597767719e+01,
		4.450432729147647e+01,		4.457413388558982e+01,		4.464382610374529e+01,		4.471340428834935e+01,		4.478286878049244e+01,
		4.485221991995480e+01,		4.492145804521192e+01,		4.499058349344035e+01,		4.505959660052320e+01,		4.512849770105559e+01,
		4.519728712835047e+01,		4.526596521444396e+01,		4.533453229010080e+01,		4.540298868481997e+01,		4.547133472684003e+01,
		4.553957074314460e+01,		4.560769705946774e+01,		4.567571400029936e+01,		4.574362188889044e+01,		4.581142104725865e+01,
		4.587911179619331e+01,		4.594669445526089e+01,		4.601416934281024e+01,		4.608153677597779e+01,		4.614879707069279e+01,
		4.621595054168250e+01,		4.628299750247729e+01,		4.634993826541597e+01,		4.641677314165065e+01,		4.648350244115212e+01,
		4.655012647271470e+01,		4.661664554396143e+01,		4.668305996134904e+01,		4.674937003017303e+01,		4.681557605457254e+01,
		4.688167833753548e+01,		4.694767718090334e+01,		4.701357288537616e+01,		4.707936575051745e+01,		4.714505607475908e+01,
		4.721064415540606e+01,		4.727613028864146e+01,		4.734151476953123e+01,		4.740679789202890e+01,		4.747197994898046e+01,
		4.753706123212909e+01,		4.760204203211980e+01,		4.766692263850430e+01,		4.773170333974553e+01,		4.779638442322242e+01,
		4.786096617523452e+01,		4.792544888100664e+01,		4.798983282469343e+01,		4.805411828938394e+01,		4.811830555710628e+01,
		4.818239490883210e+01,		4.824638662448108e+01,		4.831028098292551e+01,		4.837407826199475e+01,		4.843777873847968e+01,
		4.850138268813716e+01,		4.856489038569441e+01,		4.862830210485353e+01,		4.869161811829575e+01,		4.875483869768586e+01,
		4.881796411367660e+01,		4.888099463591287e+01,		4.894393053303620e+01,		4.900677207268885e+01,		4.906951952151827e+01,
		4.913217314518115e+01,		4.919473320834791e+01,		4.925719997470660e+01,		4.931957370696743e+01,		4.938185466686656e+01,
		4.944404311517064e+01,		4.950613931168076e+01,		4.956814351523649e+01,		4.963005598372018e+01,		4.969187697406082e+01,
		4.975360674223835e+01,		4.981524554328750e+01,		4.987679363130193e+01,		4.993825125943815e+01,		4.999961867991967e+01,
		5.006089614404076e+01,		5.012208390217062e+01,		5.018318220375708e+01,		5.024419129733079e+01,		5.030511143050892e+01
	},
	{
		8.348282998222177e-02,		2.503171354111978e-01,		4.167538468432070e-01,		5.827938376694942e-01,		7.484379587575202e-01,
		9.136870402162095e-01,		1.078541893074575e+00,		1.243003310877230e+00,		1.407072071200162e+00,		1.570748937089987e+00,
		1.734034658429811e+00,		1.896929973234644e+00,		2.059435608879281e+00,		2.221552283261347e+00,		2.383280705902205e+00,
		2.544621578988238e+00,		2.705575598354968e+00,		2.866143454416380e+00,		3.026325833041693e+00,		3.186123416381798e+00,
		3.345536883647436e+00,		3.504566911841153e+00,		3.663214176444996e+00,		3.821479352065802e+00,		3.979363113039922e+00,
		4.136866133999096e+00,		4.293989090399180e+00,		4.450732659013330e+00,		4.607097518391214e+00,		4.763084349285747e+00,
		4.918693835048805e+00,		5.073926661997297e+00,		5.228783519750960e+00,		5.383265101543159e+00,		5.537372104505933e+00,
		5.691105229930512e+00,		5.844465183504418e+00,		5.997452675526319e+00,		6.150068421099651e+00,		6.302313140306093e+00,
		6.454187558359824e+00,		6.605692405743605e+00,		6.756828418327500e+00,		6.907596337471200e+00,		7.057996910110781e+00,
		7.208030888830677e+00,		7.357699031921697e+00,		7.507002103425818e+00,		7.655940873168475e+00,		7.804516116779085e+00,
		7.952728615700364e+00,		8.100579157187251e+00,		8.248068534295861e+00,		8.395197545863217e+00,		8.541966996478241e+00,
		8.688377696444526e+00,		8.834430461735531e+00,		8.980126113942516e+00,		9.125465480215858e+00,		9.270449393200110e+00,
		9.415078690963238e+00,		9.559354216920548e+00,		9.703276819753546e+00,		9.846847353324247e+00,		9.990066676585238e+00,
		1.013293565348585e+01,		1.027545515287474e+01,		1.041762604839928e+01,		1.055944921840195e+01,		1.070092554581409e+01,
		1.084205591804728e+01,		1.098284122688257e+01,		1.112328236835784e+01,		1.126338024265350e+01,		1.140313575397679e+01,
		1.154254981044483e+01,		1.168162332396669e+01,		1.182035721012461e+01,		1.195875238805457e+01,		1.209680978032642e+01,
		1.223453031282367e+01,		1.237191491462304e+01,		1.250896451787420e+01,		1.264568005767932e+01,		1.278206247197315e+01,
		1.291811270140325e+01,		1.305383168921079e+01,		1.318922038111188e+01,		1.332427972517963e+01,		1.345901067172684e+01,
		1.359341417318976e+01,		1.372749118401251e+01,		1.386124266053270e+01,		1.399466956086807e+01,		1.412777284480421e+01,
		1.426055347368351e+01,		1.439301241029539e+01,		1.452515061876776e+01,		1.465696906445988e+01,		1.478846871385652e+01,
		1.491965053446366e+01,		1.505051549470555e+01,		1.518106456382326e+01,		1.531129871177481e+01,		1.544121890913672e+01,
		1.557082612700728e+01,		1.570012133691120e+01,		1.582910551070601e+01,		1.595777962049000e+01,		1.608614463851172e+01,
		1.621420153708123e+01,		1.634195128848286e+01,		1.646939486488964e+01,		1.659653323827941e+01,		1.672336738035247e+01,
		1.684989826245099e+01,		1.697612685547991e+01,		1.710205412982954e+01,		1.722768105529987e+01,		1.735300860102626e+01,
		1.747803773540697e+01,		1.760276942603216e+01,		1.772720463961451e+01,		1.785134434192141e+01,		1.797518949770867e+01,
		1.809874107065592e+01,		1.822200002330330e+01,		1.834496731698993e+01,		1.846764391179373e+01,		1.859003076647271e+01,
		1.871212883840785e+01,		1.883393908354732e+01,		1.895546245635222e+01,		1.907669990974367e+01,		1.919765239505132e+01,
		1.931832086196329e+01,		1.943870625847740e+01,		1.955880953085375e+01,		1.967863162356870e+01,		1.979817347927005e+01,
		1.991743603873359e+01,		2.003642024082080e+01,		2.015512702243797e+01,		2.027355731849632e+01,		2.039171206187352e+01,
		2.050959218337630e+01,		2.062719861170418e+01,		2.074453227341444e+01,		2.086159409288813e+01,		2.097838499229726e+01,
		2.109490589157291e+01,		2.121115770837466e+01,		2.132714135806081e+01,		2.144285775365969e+01,		2.155830780584213e+01,
		2.167349242289465e+01,		2.178841251069380e+01,		2.190306897268139e+01,		2.201746270984059e+01,		2.213159462067305e+01,
		2.224546560117675e+01,		2.235907654482485e+01,		2.247242834254534e+01,		2.258552188270145e+01,		2.269835805107309e+01,
		2.281093773083873e+01,		2.292326180255841e+01,		2.303533114415730e+01,		2.314714663091007e+01,		2.325870913542596e+01,
		2.337001952763459e+01,		2.348107867477246e+01,		2.359188744137007e+01,		2.370244668923978e+01,		2.381275727746426e+01,
		2.392282006238558e+01,		2.403263589759497e+01,		2.414220563392305e+01,		2.425153011943080e+01,		2.436061019940098e+01,
		2.446944671633020e+01,		2.457804050992141e+01,		2.468639241707708e+01,		2.479450327189276e+01,		2.490237390565121e+01,
		2.501000514681697e+01,		2.511739782103152e+01,		2.522455275110873e+01,		2.533147075703091e+01,		2.543815265594523e+01,
		2.554459926216062e+01,		2.565081138714498e+01,		2.575678983952296e+01,		2.586253542507395e+01,		2.596804894673066e+01,
		2.607333120457784e+01,		2.617838299585156e+01,		2.628320511493879e+01,		2.638779835337719e+01,		2.649216349985551e+01,
		2.659630134021398e+01,		2.670021265744531e+01,		2.680389823169583e+01,		2.690735884026690e+01,		2.701059525761680e+01,
		2.711360825536267e+01,		2.721639860228288e+01,		2.731896706431957e+01,		2.742131440458150e+01,		2.752344138334717e+01,
		2.762534875806805e+01,		2.772703728337223e+01,		2.782850771106811e+01,		2.792976079014846e+01,		2.803079726679458e+01,
		2.813161788438077e+01,		2.823222338347885e+01,		2.833261450186304e+01,		2.843279197451488e+01,		2.853275653362846e+01,
		2.863250890861569e+01,		2.873204982611184e+01,		2.883138000998120e+01,		2.893050018132286e+01,		2.902941105847678e+01,
		2.912811335702975e+01,		2.922660778982180e+01,		2.932489506695249e+01,		2.942297589578743e+01,		2.952085098096506e+01,
		2.961852102440318e+01,		2.971598672530603e+01,		2.981324878017122e+01,		2.991030788279677e+01,		3.000716472428843e+01,
		3.010381999306686e+01,		3.020027437487514e+01,		3.029652855278613e+01,		3.039258320721019e+01,		3.048843901590276e+01,
		3.058409665397206e+01,		3.067955679388701e+01,		3.077482010548502e+01,		3.086988725598004e+01,		3.096475890997052e+01,
		3.105943572944751e+01,		3.115391837380287e+01,		3.124820749983739e+01,		3.134230376176913e+01,		3.143620781124168e+01,
		3.152992029733259e+01,		3.162344186656171e+01,		3.171677316289972e+01,		3.180991482777655e+01,		3.190286750009000e+01,
		3.199563181621427e+01,		3.208820841000858e+01,		3.218059791282581e+01,		3.227280095352116e+01,		3.236481815846089e+01,
		3.245665015153102e+01,		3.254829755414612e+01,		3.263976098525802e+01,		3.273104106136466e+01,		3.282213839651887e+01,
		3.291305360233725e+01,		3.300378728800898e+01,		3.309434006030469e+01,		3.318471252358533e+01,		3.327490527981107e+01,
		3.336491892855018e+01,		3.345475406698793e+01,		3.354441128993555e+01,		3.363389118983902e+01,		3.372319435678813e+01,
		3.381232137852530e+01,		3.390127284045457e+01,		3.399004932565043e+01,		3.407865141486687e+01,		3.416707968654616e+01,
		3.425533471682787e+01,		3.434341707955770e+01,		3.443132734629646e+01,		3.451906608632891e+01,		3.460663386667269e+01,
		3.469403125208714e+01,		3.478125880508227e+01,		3.486831708592753e+01,		3.495520665266074e+01,		3.504192806109688e+01,
		3.512848186483692e+01,		3.521486861527665e+01,		3.530108886161551e+01,		3.538714315086535e+01,		3.547303202785918e+01,
		3.555875603525993e+01,		3.564431571356929e+01,		3.572971160113627e+01,		3.581494423416601e+01,		3.590001414672849e+01,
		3.598492187076713e+01,		3.606966793610746e+01,		3.615425287046574e+01,		3.623867719945764e+01,		3.632294144660675e+01,
		3.640704613335318e+01,		3.649099177906208e+01,		3.657477890103226e+01,		3.665840801450452e+01,		3.674187963267033e+01,
		3.682519426668014e+01,		3.690835242565187e+01,		3.699135461667937e+01,		3.707420134484067e+01,		3.715689311320653e+01,
		3.723943042284857e+01,		3.732181377284776e+01,		3.740404366030263e+01,		3.748612058033757e+01,		3.756804502611096e+01,
		3.764981748882354e+01,		3.773143845772650e+01,		3.781290842012962e+01,		3.789422786140955e+01,		3.797539726501770e+01,
		3.805641711248850e+01,		3.813728788344734e+01,		3.821801005561871e+01,		3.829858410483409e+01,		3.837901050503996e+01,
		3.845928972830580e+01,		3.853942224483190e+01,		3.861940852295738e+01,		3.869924902916792e+01,		3.877894422810370e+01,
		3.885849458256718e+01,		3.893790055353077e+01,		3.901716260014483e+01,		3.909628117974510e+01,		3.917525674786062e+01,
		3.925408975822125e+01,		3.933278066276541e+01,		3.941132991164762e+01,		3.948973795324615e+01,		3.956800523417046e+01,
		3.964613219926887e+01,		3.972411929163592e+01,		3.980196695261998e+01,		3.987967562183049e+01,		3.995724573714560e+01,
		4.003467773471940e+01,		4.011197204898927e+01,		4.018912911268331e+01,		4.026614935682757e+01,		4.034303321075328e+01,
		4.041978110210417e+01,		4.049639345684363e+01,		4.057287069926190e+01,		4.064921325198323e+01,		4.072542153597307e+01,
		4.080149597054494e+01,		4.087743697336782e+01,		4.095324496047299e+01,		4.102892034626099e+01,		4.110446354350885e+01,
		4.117987496337678e+01,		4.125515501541523e+01,		4.133030410757181e+01,		4.140532264619807e+01,		4.148021103605640e+01,
		4.155496968032688e+01,		4.162959898061398e+01,		4.170409933695338e+01,		4.177847114781872e+01,		4.185271481012818e+01,
		4.192683071925134e+01,		4.200081926901569e+01,		4.207468085171330e+01,		4.214841585810741e+01,		4.222202467743899e+01,
		4.229550769743330e+01,		4.236886530430636e+01,		4.244209788277146e+01,		4.251520581604568e+01,		4.258818948585612e+01,
		4.266104927244656e+01,		4.273378555458368e+01,		4.280639870956342e+01,		4.287888911321732e+01,		4.295125713991885e+01,
		4.302350316258964e+01,		4.309562755270572e+01,		4.316763068030374e+01,		4.323951291398718e+01,		4.331127462093252e+01,
		4.338291616689531e+01,		4.345443791621635e+01,		4.352584023182773e+01,		4.359712347525895e+01,		4.366828800664287e+01,
		4.373933418472178e+01,		4.381026236685337e+01,		4.388107290901663e+01,		4.395176616581791e+01,		4.402234249049663e+01,
		4.409280223493133e+01,		4.416314574964550e+01,		4.423337338381329e+01,		4.430348548526543e+01,		4.437348240049499e+01,
		4.444336447466308e+01,		4.451313205160465e+01,		4.458278547383413e+01,		4.465232508255114e+01,		4.472175121764618e+01,
		4.479106421770617e+01,		4.486026442002012e+01,		4.492935216058472e+01,		4.499832777410982e+01,		4.506719159402411e+01,
		4.513594395248045e+01,		4.520458518036150e+01,		4.527311560728509e+01,		4.534153556160965e+01,		4.540984537043975e+01,
		4.547804535963137e+01,		4.554613585379726e+01,		4.561411717631233e+01,		4.568198964931899e+01,		4.574975359373240e+01,
		4.581740932924576e+01,		4.588495717433555e+01,		4.595239744626679e+01,		4.601973046109814e+01,		4.608695653368729e+01,
		4.615407597769586e+01,		4.622108910559476e+01,		4.628799622866912e+01,		4.635479765702355e+01,		4.642149369958708e+01,
		4.648808466411823e+01,		4.655457085721012e+01,		4.662095258429532e+01,		4.668723014965101e+01,		4.675340385640376e+01,
		4.681947400653457e+01,		4.688544090088383e+01,		4.695130483915604e+01,		4.701706611992486e+01,		4.708272504063785e+01,
		4.714828189762132e+01,		4.721373698608519e+01,		4.727909060012774e+01,		4.734434303274029e+01,		4.740949457581208e+01,
		4.747454552013491e+01,		4.753949615540788e+01,		4.760434677024206e+01,		4.766909765216511e+01,		4.773374908762594e+01,
		4.779830136199939e+01,		4.786275475959075e+01,		4.792710956364033e+01,		4.799136605632810e+01,		4.805552451877816e+01,
		4.811958523106325e+01,		4.818354847220929e+01,		4.824741452019981e+01,		4.831118365198048e+01,		4.837485614346345e+01,
		4.843843226953183e+01,		4.850191230404407e+01,		4.856529651983836e+01,		4.862858518873691e+01,		4.869177858155039e+01,
		4.875487696808221e+01,		4.881788061713282e+01,		4.888078979650394e+01,		4.894360477300289e+01,		4.900632581244681e+01,
		4.906895317966687e+01,		4.913148713851253e+01,		4.919392795185563e+01,		4.925627588159468e+01,		4.931853118865883e+01,
		4.938069413301220e+01,		4.944276497365791e+01,		4.950474396864207e+01,		4.956663137505804e+01,		4.962842744905038e+01,
		4.969013244581887e+01,		4.975174661962257e+01,		4.981327022378385e+01,		4.987470351069234e+01,		4.993604673180884e+01,
		4.999730013766941e+01,		5.005846397788913e+01,		5.011953850116620e+01,		5.018052395528563e+01,		5.024142058712333e+01
	},
	{
		8.330980739824875e-02,		2.497986931077398e-01,		4.158912816986701e-01,		5.815884469816465e-01,		7.468910404331334e-01,
		9.117998929391316e-01,		1.076315816453422e+00,		1.240439605573836e+00,		1.404172039039874e+00,		1.567513881154840e+00,
		1.730465883135584e+00,		1.893028784392742e+00,		2.055203313744345e+00,		2.216990190565481e+00,		2.378390125876618e+00,
		2.539403823373117e+00,		2.700031980398335e+00,		2.860275288862643e+00,		3.020134436110602e+00,		3.179610105738437e+00,
		3.338702978363909e+00,		3.497413732350541e+00,		3.655743044488172e+00,		3.813691590631637e+00,		3.971260046299403e+00,
		4.128449087233862e+00,		4.285259389924933e+00,		4.441691632098573e+00,		4.597746493171742e+00,		4.753424654675308e+00,
		4.908726800646280e+00,		5.063653617990806e+00,		5.218205796819215e+00,		5.372384030754400e+00,		5.526189017214756e+00,
		5.679621457672869e+00,		5.832682057891100e+00,		5.985371528135158e+00,		6.137690583366692e+00,		6.289639943415970e+00,
		6.441220333135587e+00,		6.592432482536144e+00,		6.743277126904840e+00,		6.893755006907781e+00,		7.043866868676926e+00,
		7.193613463882413e+00,		7.342995549791073e+00,		7.492013889311840e+00,		7.640669251028834e+00,		7.788962409222724e+00,
		7.936894143881108e+00,		8.084465240698481e+00,		8.231676491066420e+00,		8.378528692054603e+00,		8.525022646383135e+00,
		8.671159162386816e+00,		8.816939053971803e+00,		8.962363140565131e+00,		9.107432247057661e+00,		9.252147203740810e+00,
		9.396508846237534e+00,		9.540518015427963e+00,		9.684175557370116e+00,		9.827482323216012e+00,		9.970439169123580e+00,
		1.011304695616469e+01,		1.025530655022970e+01,		1.039721882192865e+01,		1.053878464648962e+01,		1.068000490365446e+01,
		1.082088047757199e+01,		1.096141225668925e+01,		1.110160113364074e+01,		1.124144800513608e+01,		1.138095377184620e+01,
		1.152011933828833e+01,		1.165894561270995e+01,		1.179743350697190e+01,		1.193558393643087e+01,		1.207339781982133e+01,
		1.221087607913717e+01,		1.234801963951317e+01,		1.248482942910639e+01,		1.262130637897767e+01,		1.275745142297333e+01,
		1.289326549760725e+01,		1.302874954194332e+01,		1.316390449747850e+01,		1.329873130802651e+01,		1.343323091960225e+01,
		1.356740428030703e+01,		1.370125234021471e+01,		1.383477605125885e+01,		1.396797636712082e+01,		1.410085424311910e+01,
		1.423341063609970e+01,		1.436564650432779e+01,		1.449756280738062e+01,		1.462916050604177e+01,		1.476044056219667e+01,
		1.489140393872964e+01,		1.502205159942223e+01,		1.515238450885308e+01,		1.528240363229928e+01,		1.541210993563915e+01,
		1.554150438525670e+01,		1.567058794794744e+01,		1.579936159082594e+01,		1.592782628123480e+01,		1.605598298665537e+01,
		1.618383267461991e+01,		1.631137631262547e+01,		1.643861486804929e+01,		1.656554930806587e+01,		1.669218059956563e+01,
		1.681850970907515e+01,		1.694453760267902e+01,		1.707026524594338e+01,		1.719569360384090e+01,		1.732082364067750e+01,
		1.744565632002052e+01,		1.757019260462862e+01,		1.769443345638305e+01,		1.781837983622063e+01,		1.794203270406821e+01,
		1.806539301877863e+01,		1.818846173806823e+01,		1.831123981845586e+01,		1.843372821520336e+01,		1.855592788225746e+01,
		1.867783977219326e+01,		1.879946483615901e+01,		1.892080402382234e+01,		1.904185828331798e+01,		1.916262856119673e+01,
		1.928311580237587e+01,		1.940332095009093e+01,		1.952324494584868e+01,		1.964288872938159e+01,		1.976225323860340e+01,
		1.988133940956611e+01,		2.000014817641812e+01,		2.011868047136358e+01,		2.023693722462311e+01,		2.035491936439547e+01,
		2.047262781682062e+01,		2.059006350594373e+01,		2.070722735368051e+01,		2.082412027978347e+01,		2.094074320180942e+01,
		2.105709703508790e+01,		2.117318269269079e+01,		2.128900108540286e+01,		2.140455312169329e+01,		2.151983970768837e+01,
		2.163486174714490e+01,		2.174962014142481e+01,		2.186411578947051e+01,		2.197834958778121e+01,		2.209232243039023e+01,
		2.220603520884304e+01,		2.231948881217625e+01,		2.243268412689739e+01,		2.254562203696558e+01,		2.265830342377292e+01,
		2.277072916612672e+01,		2.288290014023249e+01,		2.299481721967764e+01,		2.310648127541600e+01,		2.321789317575297e+01,
		2.332905378633144e+01,		2.343996397011833e+01,		2.355062458739191e+01,		2.366103649572958e+01,		2.377120054999656e+01,
		2.388111760233490e+01,		2.399078850215339e+01,		2.410021409611785e+01,		2.420939522814208e+01,		2.431833273937941e+01,
		2.442702746821475e+01,		2.453548025025715e+01,		2.464369191833300e+01,		2.475166330247965e+01,		2.485939522993950e+01,
		2.496688852515465e+01,		2.507414400976206e+01,		2.518116250258898e+01,		2.528794481964907e+01,		2.539449177413880e+01,
		2.550080417643430e+01,		2.560688283408868e+01,		2.571272855182969e+01,		2.581834213155781e+01,		2.592372437234470e+01,
		2.602887607043205e+01,		2.613379801923073e+01,		2.623849100932040e+01,		2.634295582844932e+01,		2.644719326153459e+01,
		2.655120409066272e+01,		2.665498909509043e+01,		2.675854905124583e+01,		2.686188473272983e+01,		2.696499691031794e+01,
		2.706788635196222e+01,		2.717055382279357e+01,		2.727300008512427e+01,		2.737522589845083e+01,		2.747723201945693e+01,
		2.757901920201679e+01,		2.768058819719860e+01,		2.778193975326833e+01,		2.788307461569364e+01,		2.798399352714801e+01,
		2.808469722751517e+01,		2.818518645389361e+01,		2.828546194060132e+01,		2.838552441918076e+01,		2.848537461840396e+01,
		2.858501326427780e+01,		2.868444108004942e+01,		2.878365878621192e+01,		2.888266710051003e+01,		2.898146673794606e+01,
		2.908005841078601e+01,		2.917844282856561e+01,		2.927662069809690e+01,		2.937459272347445e+01,		2.947235960608208e+01,
		2.956992204459952e+01,		2.966728073500925e+01,		2.976443637060344e+01,		2.986138964199096e+01,		2.995814123710452e+01,
		3.005469184120797e+01,		3.015104213690354e+01,		3.024719280413937e+01,		3.034314452021695e+01,		3.043889795979873e+01,
		3.053445379491584e+01,		3.062981269497578e+01,		3.072497532677030e+01,		3.081994235448327e+01,		3.091471443969862e+01,
		3.100929224140848e+01,		3.110367641602107e+01,		3.119786761736906e+01,		3.129186649671762e+01,		3.138567370277273e+01,
		3.147928988168951e+01,		3.157271567708048e+01,		3.166595173002406e+01,		3.175899867907293e+01,		3.185185716026254e+01,
		3.194452780711960e+01,		3.203701125067067e+01,		3.212930811945064e+01,		3.222141903951148e+01,		3.231334463443079e+01,
		3.240508552532044e+01,		3.249664233083536e+01,		3.258801566718213e+01,		3.267920614812785e+01,		3.277021438500876e+01,
		3.286104098673906e+01,		3.295168655981976e+01,		3.304215170834736e+01,		3.313243703402276e+01,		3.322254313616003e+01,
		3.331247061169521e+01,		3.340222005519529e+01,		3.349179205886687e+01,		3.358118721256513e+01,		3.367040610380265e+01,
		3.375944931775827e+01,		3.384831743728599e+01,		3.393701104292373e+01,		3.402553071290225e+01,		3.411387702315405e+01,
		3.420205054732214e+01,		3.429005185676890e+01,		3.437788152058502e+01,		3.446554010559818e+01,		3.455302817638203e+01,
		3.464034629526491e+01,		3.472749502233871e+01,		3.481447491546765e+01,		3.490128653029711e+01,		3.498793042026237e+01,
		3.507440713659738e+01,		3.516071722834358e+01,		3.524686124235856e+01,		3.533283972332480e+01,		3.541865321375845e+01,
		3.550430225401799e+01,		3.558978738231289e+01,		3.567510913471229e+01,		3.576026804515366e+01,		3.584526464545139e+01,
		3.593009946530548e+01,		3.601477303231005e+01,		3.609928587196199e+01,		3.618363850766941e+01,		3.626783146076028e+01,
		3.635186525049089e+01,		3.643574039405432e+01,		3.651945740658896e+01,		3.660301680118693e+01,		3.668641908890250e+01,
		3.676966477876053e+01,		3.685275437776478e+01,		3.693568839090633e+01,		3.701846732117185e+01,		3.710109166955203e+01,
		3.718356193504969e+01,		3.726587861468816e+01,		3.734804220351949e+01,		3.743005319463266e+01,		3.751191207916175e+01,
		3.759361934629406e+01,		3.767517548327837e+01,		3.775658097543291e+01,		3.783783630615349e+01,		3.791894195692161e+01,
		3.799989840731239e+01,		3.808070613500264e+01,		3.816136561577880e+01,		3.824187732354493e+01,		3.832224173033057e+01,
		3.840245930629872e+01,		3.848253051975354e+01,		3.856245583714846e+01,		3.864223572309372e+01,		3.872187064036428e+01,
		3.880136104990758e+01,		3.888070741085130e+01,		3.895991018051090e+01,		3.903896981439748e+01,		3.911788676622534e+01,
		3.919666148791960e+01,		3.927529442962378e+01,		3.935378603970739e+01,		3.943213676477342e+01,		3.951034704966590e+01,
		3.958841733747733e+01,		3.966634806955611e+01,		3.974413968551405e+01,		3.982179262323363e+01,		3.989930731887552e+01,
		3.997668420688569e+01,		4.005392372000302e+01,		4.013102628926631e+01,		4.020799234402160e+01,		4.028482231192949e+01,
		4.036151661897219e+01,		4.043807568946082e+01,		4.051449994604247e+01,		4.059078980970728e+01,		4.066694569979556e+01,
		4.074296803400486e+01,		4.081885722839696e+01,		4.089461369740485e+01,		4.097023785383978e+01,		4.104573010889806e+01,
		4.112109087216810e+01,		4.119632055163724e+01,		4.127141955369857e+01,		4.134638828315782e+01,		4.142122714324011e+01,
		4.149593653559677e+01,		4.157051686031203e+01,		4.164496851590975e+01,		4.171929189936014e+01,		4.179348740608639e+01,
		4.186755542997130e+01,		4.194149636336390e+01,		4.201531059708599e+01,		4.208899852043879e+01,		4.216256052120934e+01,
		4.223599698567706e+01,		4.230930829862019e+01,		4.238249484332232e+01,		4.245555700157869e+01,		4.252849515370257e+01,
		4.260130967853181e+01,		4.267400095343487e+01,		4.274656935431745e+01,		4.281901525562851e+01,		4.289133903036669e+01,
		4.296354105008646e+01,		4.303562168490432e+01,		4.310758130350504e+01,		4.317942027314772e+01,		4.325113895967201e+01,
		4.332273772750408e+01,		4.339421693966282e+01,		4.346557695776581e+01,		4.353681814203541e+01,		4.360794085130458e+01,
		4.367894544302310e+01,		4.374983227326332e+01,		4.382060169672611e+01,		4.389125406674686e+01,		4.396178973530120e+01,
		4.403220905301090e+01,		4.410251236914975e+01,		4.417270003164924e+01,		4.424277238710442e+01,		4.431272978077955e+01,
		4.438257255661389e+01,		4.445230105722737e+01,		4.452191562392623e+01,		4.459141659670871e+01,		4.466080431427063e+01,
		4.473007911401101e+01,		4.479924133203757e+01,		4.486829130317236e+01,		4.493722936095730e+01,		4.500605583765954e+01,
		4.507477106427705e+01,		4.514337537054407e+01,		4.521186908493648e+01,		4.528025253467717e+01,		4.534852604574159e+01,
		4.541668994286287e+01,		4.548474454953734e+01,		4.555269018802972e+01,		4.562052717937850e+01,		4.568825584340108e+01,
		4.575587649869918e+01,		4.582338946266384e+01,		4.589079505148085e+01,		4.595809358013570e+01,		4.602528536241888e+01,
		4.609237071093091e+01,		4.615934993708755e+01,		4.622622335112473e+01,		4.629299126210377e+01,		4.635965397791629e+01,
		4.642621180528926e+01,		4.649266504979002e+01,		4.655901401583125e+01,		4.662525900667584e+01,		4.669140032444194e+01,
		4.675743827010775e+01,		4.682337314351646e+01,		4.688920524338111e+01,		4.695493486728939e+01,		4.702056231170851e+01,
		4.708608787198999e+01,		4.715151184237433e+01,		4.721683451599597e+01,		4.728205618488784e+01,		4.734717713998616e+01,
		4.741219767113506e+01,		4.747711806709134e+01,		4.754193861552910e+01,		4.760665960304431e+01,		4.767128131515943e+01,
		4.773580403632813e+01,		4.780022804993964e+01,		4.786455363832347e+01,		4.792878108275390e+01,		4.799291066345439e+01,
		4.805694265960219e+01,		4.812087734933276e+01,		4.818471500974426e+01,		4.824845591690186e+01,		4.831210034584226e+01,
		4.837564857057807e+01,		4.843910086410209e+01,		4.850245749839179e+01,		4.856571874441351e+01,		4.862888487212690e+01,
		4.869195615048909e+01,		4.875493284745905e+01,		4.881781523000177e+01,		4.888060356409261e+01,		4.894329811472139e+01,
		4.900589914589661e+01,		4.906840692064973e+01,		4.913082170103923e+01,		4.919314374815472e+01,		4.925537332212124e+01,
		4.931751068210311e+01,		4.937955608630823e+01,		4.944150979199204e+01,		4.950337205546164e+01,		4.956514313207973e+01,
		4.962682327626868e+01,		4.968841274151450e+01,		4.974991178037092e+01,		4.981132064446311e+01,		4.987263958449194e+01,
		4.993386885023757e+01,		4.999500869056372e+01,		5.005605935342119e+01,		5.011702108585202e+01,		5.017789413399311e+01
	},
	{
		8.313750078315250e-02,		2.492823961852041e-01,		4.150322860230312e-01,		5.803880444745115e-01,		7.453505235708738e-01,
		9.099205549191134e-01,		1.074098951340148e+00,		1.237886508426116e+00,		1.401284006020091e+00,		1.564292209621346e+00,
		1.726911871719188e+00,		1.889143733058242e+00,		2.050988523837989e+00,		2.212446964849205e+00,		2.373519768549895e+00,
		2.534207640083183e+00,		2.694511278239544e+00,		2.854431376365655e+00,		3.013968623222097e+00,		3.173123703791993e+00,
		3.331897300042662e+00,		3.490290091642233e+00,		3.648302756633122e+00,		3.805935972064207e+00,		3.963190414583440e+00,
		4.120066760992622e+00,		4.276565688765940e+00,		4.432687876533859e+00,		4.588434004533897e+00,		4.743804755029704e+00,
		4.898800812699903e+00,		5.053422864998008e+00,		5.207671602484747e+00,		5.361547719134043e+00,		5.515051912613868e+00,
		5.668184884543122e+00,		5.820947340725702e+00,		5.973339991362786e+00,		6.125363551244412e+00,		6.277018739921375e+00,
		6.428306281858330e+00,		6.579226906569127e+00,		6.729781348735201e+00,		6.879970348307904e+00,		7.029794650595601e+00,
		7.179255006336337e+00,		7.328352171756817e+00,		7.477086908618444e+00,		7.625459984251134e+00,		7.773472171575556e+00,
		7.921124249114467e+00,		8.068417000993767e+00,		8.215351216933872e+00,		8.361927692231962e+00,		8.508147227735678e+00,
		8.654010629808791e+00,		8.799518710289323e+00,		8.944672286440667e+00,		9.089472180896070e+00,		9.233919221597056e+00,
		9.378014241726076e+00,		9.521758079633884e+00,		9.665151578762007e+00,		9.808195587560663e+00,		9.950890959402486e+00,
		1.009323855249242e+01,		1.023523922977406e+01,		1.037689385883282e+01,		1.051820331179611e+01,		1.065916846523095e+01,
		1.079979020003914e+01,		1.094006940135032e+01,		1.108000695841320e+01,		1.121960376448502e+01,		1.135886071671971e+01,
		1.149777871605476e+01,		1.163635866709695e+01,		1.177460147800747e+01,		1.191250806038613e+01,		1.205007932915519e+01,
		1.218731620244280e+01,		1.232421960146628e+01,		1.246079045041527e+01,		1.259702967633500e+01,		1.273293820900976e+01,
		1.286851698084662e+01,		1.300376692675967e+01,		1.313868898405469e+01,		1.327328409231448e+01,		1.340755319328493e+01,
		1.354149723076183e+01,		1.367511715047860e+01,		1.380841389999491e+01,		1.394138842858639e+01,		1.407404168713539e+01,
		1.420637462802282e+01,		1.433838820502126e+01,		1.447008337318925e+01,		1.460146108876694e+01,		1.473252230907292e+01,
		1.486326799240264e+01,		1.499369909792795e+01,		1.512381658559832e+01,		1.525362141604336e+01,		1.538311455047686e+01,
		1.551229695060236e+01,		1.564116957852019e+01,		1.576973339663606e+01,		1.589798936757127e+01,		1.602593845407432e+01,
		1.615358161893423e+01,		1.628091982489543e+01,		1.640795403457411e+01,		1.653468521037626e+01,		1.666111431441726e+01,
		1.678724230844310e+01,		1.691307015375304e+01,		1.703859881112403e+01,		1.716382924073658e+01,		1.728876240210219e+01,
		1.741339925399248e+01,		1.753774075436966e+01,		1.766178786031872e+01,		1.778554152798102e+01,		1.790900271248950e+01,
		1.803217236790536e+01,		1.815505144715613e+01,		1.827764090197540e+01,		1.839994168284391e+01,		1.852195473893205e+01,
		1.864368101804386e+01,		1.876512146656247e+01,		1.888627702939682e+01,		1.900714864992988e+01,		1.912773726996821e+01,
		1.924804382969276e+01,		1.936806926761119e+01,		1.948781452051130e+01,		1.960728052341589e+01,		1.972646820953882e+01,
		1.984537851024235e+01,		1.996401235499570e+01,		2.008237067133481e+01,		2.020045438482336e+01,		2.031826441901488e+01,
		2.043580169541601e+01,		2.055306713345102e+01,		2.067006165042726e+01,		2.078678616150189e+01,		2.090324157964953e+01,
		2.101942881563107e+01,		2.113534877796348e+01,		2.125100237289058e+01,		2.136639050435494e+01,		2.148151407397066e+01,
		2.159637398099710e+01,		2.171097112231361e+01,		2.182530639239515e+01,		2.193938068328883e+01,		2.205319488459130e+01,
		2.216674988342702e+01,		2.228004656442745e+01,		2.239308580971095e+01,		2.250586849886355e+01,		2.261839550892057e+01,
		2.273066771434892e+01,		2.284268598703022e+01,		2.295445119624465e+01,		2.306596420865559e+01,		2.317722588829477e+01,
		2.328823709654843e+01,		2.339899869214383e+01,		2.350951153113674e+01,		2.361977646689926e+01,		2.372979435010855e+01,
		2.383956602873601e+01,		2.394909234803714e+01,		2.405837415054191e+01,		2.416741227604587e+01,		2.427620756160157e+01,
		2.438476084151078e+01,		2.449307294731708e+01,		2.460114470779901e+01,		2.470897694896381e+01,		2.481657049404145e+01,
		2.492392616347943e+01,		2.503104477493778e+01,		2.513792714328467e+01,		2.524457408059244e+01,		2.535098639613402e+01,
		2.545716489637983e+01,		2.556311038499503e+01,		2.566882366283727e+01,		2.577430552795466e+01,		2.587955677558428e+01,
		2.598457819815106e+01,		2.608937058526678e+01,		2.619393472372985e+01,		2.629827139752490e+01,		2.640238138782318e+01,
		2.650626547298296e+01,		2.660992442855041e+01,		2.671335902726069e+01,		2.681657003903938e+01,		2.691955823100417e+01,
		2.702232436746689e+01,		2.712486920993563e+01,		2.722719351711742e+01,		2.732929804492083e+01,		2.743118354645902e+01,
		2.753285077205305e+01,		2.763430046923523e+01,		2.773553338275289e+01,		2.783655025457225e+01,		2.793735182388256e+01,
		2.803793882710035e+01,		2.813831199787405e+01,		2.823847206708858e+01,		2.833841976287028e+01,		2.843815581059201e+01,
		2.853768093287828e+01,		2.863699584961073e+01,		2.873610127793368e+01,		2.883499793225979e+01,		2.893368652427595e+01,
		2.903216776294930e+01,		2.913044235453334e+01,		2.922851100257418e+01,		2.932637440791701e+01,		2.942403326871264e+01,
		2.952148828042401e+01,		2.961874013583311e+01,		2.971578952504776e+01,		2.981263713550862e+01,		2.990928365199627e+01,
		3.000572975663837e+01,		3.010197612891700e+01,		3.019802344567595e+01,		3.029387238112817e+01,		3.038952360686338e+01,
		3.048497779185562e+01,		3.058023560247096e+01,		3.067529770247528e+01,		3.077016475304205e+01,		3.086483741276033e+01,
		3.095931633764264e+01,		3.105360218113301e+01,		3.114769559411511e+01,		3.124159722492032e+01,		3.133530771933593e+01,
		3.142882772061348e+01,		3.152215786947687e+01,		3.161529880413083e+01,		3.170825116026926e+01,		3.180101557108359e+01,
		3.189359266727128e+01,		3.198598307704430e+01,		3.207818742613763e+01,		3.217020633781780e+01,		3.226204043289149e+01,
		3.235369032971410e+01,		3.244515664419840e+01,		3.253643998982319e+01,		3.262754097764193e+01,		3.271846021629145e+01,
		3.280919831200070e+01,		3.289975586859935e+01,		3.299013348752666e+01,		3.308033176784019e+01,		3.317035130622445e+01,
		3.326019269699988e+01,		3.334985653213143e+01,		3.343934340123742e+01,		3.352865389159835e+01,		3.361778858816570e+01,
		3.370674807357063e+01,		3.379553292813289e+01,		3.388414372986958e+01,		3.397258105450389e+01,		3.406084547547400e+01,
		3.414893756394179e+01,		3.423685788880162e+01,		3.432460701668920e+01,		3.441218551199027e+01,		3.449959393684946e+01,
		3.458683285117893e+01,		3.467390281266728e+01,		3.476080437678814e+01,		3.484753809680900e+01,		3.493410452379995e+01,
		3.502050420664222e+01,		3.510673769203715e+01,		3.519280552451465e+01,		3.527870824644196e+01,		3.536444639803229e+01,
		3.545002051735347e+01,		3.553543114033654e+01,		3.562067880078443e+01,		3.570576403038046e+01,		3.579068735869698e+01,
		3.587544931320390e+01,		3.596005041927720e+01,		3.604449120020750e+01,		3.612877217720852e+01,		3.621289386942557e+01,
		3.629685679394400e+01,		3.638066146579759e+01,		3.646430839797710e+01,		3.654779810143847e+01,		3.663113108511136e+01,
		3.671430785590741e+01,		3.679732891872858e+01,		3.688019477647541e+01,		3.696290593005541e+01,		3.704546287839118e+01,
		3.712786611842873e+01,		3.721011614514567e+01,		3.729221345155933e+01,		3.737415852873504e+01,		3.745595186579408e+01,
		3.753759394992196e+01,		3.761908526637643e+01,		3.770042629849550e+01,		3.778161752770551e+01,		3.786265943352917e+01,
		3.794355249359335e+01,		3.802429718363735e+01,		3.810489397752049e+01,		3.818534334723026e+01,		3.826564576289001e+01,
		3.834580169276691e+01,		3.842581160327970e+01,		3.850567595900654e+01,		3.858539522269265e+01,		3.866496985525821e+01,
		3.874440031580593e+01,		3.882368706162879e+01,		3.890283054821769e+01,		3.898183122926901e+01,		3.906068955669229e+01,
		3.913940598061780e+01,		3.921798094940398e+01,		3.929641490964502e+01,		3.937470830617834e+01,		3.945286158209206e+01,
		3.953087517873239e+01,		3.960874953571104e+01,		3.968648509091258e+01,		3.976408228050185e+01,		3.984154153893113e+01,
		3.991886329894764e+01,		3.999604799160057e+01,		4.007309604624847e+01,		4.015000789056639e+01,		4.022678395055306e+01,
		4.030342465053799e+01,		4.037993041318872e+01,		4.045630165951778e+01,		4.053253880888976e+01,		4.060864227902845e+01,
		4.068461248602369e+01,		4.076044984433851e+01,		4.083615476681594e+01,		4.091172766468601e+01,		4.098716894757263e+01,
		4.106247902350043e+01,		4.113765829890163e+01,		4.121270717862282e+01,		4.128762606593179e+01,		4.136241536252420e+01,
		4.143707546853040e+01,		4.151160678252207e+01,		4.158600970151892e+01,		4.166028462099531e+01,		4.173443193488688e+01,
		4.180845203559713e+01,		4.188234531400405e+01,		4.195611215946651e+01,		4.202975295983090e+01,		4.210326810143758e+01,
		4.217665796912728e+01,		4.224992294624759e+01,		4.232306341465930e+01,		4.239607975474288e+01,		4.246897234540467e+01,
		4.254174156408334e+01,		4.261438778675610e+01,		4.268691138794500e+01,		4.275931274072316e+01,		4.283159221672098e+01,
		4.290375018613238e+01,		4.297578701772081e+01,		4.304770307882562e+01,		4.311949873536795e+01,		4.319117435185692e+01,
		4.326273029139566e+01,		4.333416691568740e+01,		4.340548458504138e+01,		4.347668365837887e+01,		4.354776449323914e+01,
		4.361872744578541e+01,		4.368957287081069e+01,		4.376030112174364e+01,		4.383091255065458e+01,		4.390140750826114e+01,
		4.397178634393418e+01,		4.404204940570342e+01,		4.411219704026343e+01,		4.418222959297913e+01,		4.425214740789161e+01,
		4.432195082772377e+01,		4.439164019388602e+01,		4.446121584648185e+01,		4.453067812431348e+01,		4.460002736488741e+01,
		4.466926390441999e+01,		4.473838807784297e+01,		4.480740021880895e+01,		4.487630065969700e+01,		4.494508973161793e+01,
		4.501376776441983e+01,		4.508233508669355e+01,		4.515079202577800e+01,		4.521913890776546e+01,		4.528737605750710e+01,
		4.535550379861812e+01,		4.542352245348315e+01,		4.549143234326154e+01,		4.555923378789253e+01,		4.562692710610050e+01,
		4.569451261540023e+01,		4.576199063210201e+01,		4.582936147131687e+01,		4.589662544696162e+01,		4.596378287176410e+01,
		4.603083405726810e+01,		4.609777931383866e+01,		4.616461895066683e+01,		4.623135327577494e+01,		4.629798259602147e+01,
		4.636450721710612e+01,		4.643092744357462e+01,		4.649724357882386e+01,		4.656345592510669e+01,		4.662956478353681e+01,
		4.669557045409366e+01,		4.676147323562728e+01,		4.682727342586323e+01,		4.689297132140715e+01,		4.695856721774980e+01,
		4.702406140927170e+01,		4.708945418924793e+01,		4.715474584985279e+01,		4.721993668216452e+01,		4.728502697617009e+01,
		4.735001702076967e+01,		4.741490710378142e+01,		4.747969751194606e+01,		4.754438853093146e+01,		4.760898044533725e+01,
		4.767347353869935e+01,		4.773786809349453e+01,		4.780216439114490e+01,		4.786636271202240e+01,		4.793046333545340e+01,
		4.799446653972296e+01,		4.805837260207944e+01,		4.812218179873881e+01,		4.818589440488912e+01,		4.824951069469485e+01,
		4.831303094130129e+01,		4.837645541683879e+01,		4.843978439242724e+01,		4.850301813818026e+01,		4.856615692320949e+01,
		4.862920101562894e+01,		4.869215068255909e+01,		4.875500619013123e+01,		4.881776780349169e+01,		4.888043578680595e+01,
		4.894301040326276e+01,		4.900549191507844e+01,		4.906788058350101e+01,		4.913017666881410e+01,		4.919238043034122e+01,
		4.925449212644989e+01,		4.931651201455550e+01,		4.937844035112553e+01,		4.944027739168350e+01,		4.950202339081299e+01,
		4.956367860216154e+01,		4.962524327844481e+01,		4.968671767145040e+01,		4.974810203204177e+01,		4.980939661016220e+01,
		4.987060165483876e+01,		4.993171741418599e+01,		4.999274413541001e+01,		5.005368206481217e+01,		5.011453144779302e+01
	},
	{
		8.296590570035417e-02,		2.487682313388636e-01,		4.141768376627659e-01,		5.791925991661246e-01,		7.438163683817302e-01,
		9.080489775825560e-01,		1.071891240400107e+00,		1.235343953363019e+00,		1.398407897359116e+00,		1.561083839024042e+00,
		1.723372532059407e+00,		1.885274718483323e+00,		2.046791129816052e+00,		2.207922488203425e+00,		2.368669507480534e+00,
		2.529032894178159e+00,		2.689013348474277e+00,		2.848611565092883e+00,		3.007828234152329e+00,		3.166664041965253e+00,
		3.325119671792111e+00,		3.483195804550274e+00,		3.640893119480534e+00,		3.798212294772822e+00,		3.955154008152899e+00,
		4.111718937431653e+00,		4.267907761018650e+00,		4.423721158401453e+00,		4.579159810592231e+00,		4.734224400543097e+00,
		4.888915613531553e+00,		5.043234137517369e+00,		5.197180663472218e+00,		5.350755885683274e+00,		5.503960502031993e+00,
		5.656795214249205e+00,		5.809260728147652e+00,		5.961357753833018e+00,		6.113087005894492e+00,		6.264449203575845e+00,
		6.415445070927985e+00,		6.566075336943884e+00,		6.716340735676800e+00,		6.866242006342576e+00,		7.015779893406919e+00,
		7.164955146658365e+00,		7.313768521267713e+00,		7.462220777834671e+00,		7.610312682422377e+00,		7.758045006580504e+00,
		7.905418527357526e+00,		8.052434027302835e+00,		8.199092294459255e+00,		8.345394122346530e+00,		8.491340309936339e+00,
		8.636931661619327e+00,		8.782168987164717e+00,		8.927053101672900e+00,		9.071584825521528e+00,		9.215764984305524e+00,
		9.359594408771404e+00,		9.503073934746348e+00,		9.646204403062427e+00,		9.788986659476246e+00,		9.931421554584494e+00,
		1.007350994373563e+01,		1.021525268693807e+01,		1.035665064876517e+01,		1.049770469825732e+01,		1.063841570882133e+01,
		1.077878455812754e+01,		1.091881212800474e+01,		1.105849930433324e+01,		1.119784697693623e+01,		1.133685603946978e+01,
		1.147552738931158e+01,		1.161386192744851e+01,		1.175186055836358e+01,		1.188952418992199e+01,		1.202685373325673e+01,
		1.216385010265387e+01,		1.230051421543754e+01,		1.243684699185489e+01,		1.257284935496109e+01,		1.270852223050445e+01,
		1.284386654681195e+01,		1.297888323467506e+01,		1.311357322723604e+01,		1.324793745987500e+01,		1.338197687009747e+01,
		1.351569239742281e+01,		1.364908498327350e+01,		1.378215557086527e+01,		1.391490510509833e+01,		1.404733453244951e+01,
		1.417944480086565e+01,		1.431123685965808e+01,		1.444271165939825e+01,		1.457387015181482e+01,		1.470471328969176e+01,
		1.483524202676804e+01,		1.496545731763857e+01,		1.509536011765654e+01,		1.522495138283720e+01,		1.535423206976315e+01,
		1.548320313549093e+01,		1.561186553745938e+01,		1.574022023339920e+01,		1.586826818124428e+01,		1.599601033904440e+01,
		1.612344766487955e+01,		1.625058111677583e+01,		1.637741165262277e+01,		1.650394023009232e+01,		1.663016780655944e+01,
		1.675609533902406e+01,		1.688172378403481e+01,		1.700705409761416e+01,		1.713208723518516e+01,		1.725682415149970e+01,
		1.738126580056841e+01,		1.750541313559188e+01,		1.762926710889355e+01,		1.775282867185416e+01,		1.787609877484750e+01,
		1.799907836717777e+01,		1.812176839701849e+01,		1.824416981135264e+01,		1.836628355591446e+01,		1.848811057513258e+01,
		1.860965181207454e+01,		1.873090820839279e+01,		1.885188070427197e+01,		1.897257023837767e+01,		1.909297774780640e+01,
		1.921310416803703e+01,		1.933295043288340e+01,		1.945251747444837e+01,		1.957180622307899e+01,		1.969081760732306e+01,
		1.980955255388684e+01,		1.992801198759397e+01,		2.004619683134574e+01,		2.016410800608228e+01,		2.028174643074516e+01,
		2.039911302224095e+01,		2.051620869540604e+01,		2.063303436297241e+01,		2.074959093553468e+01,		2.086587932151800e+01,
		2.098190042714718e+01,		2.109765515641670e+01,		2.121314441106185e+01,		2.132836909053072e+01,		2.144333009195728e+01,
		2.155802831013538e+01,		2.167246463749360e+01,		2.178663996407111e+01,		2.190055517749439e+01,		2.201421116295480e+01,
		2.212760880318710e+01,		2.224074897844862e+01,		2.235363256649949e+01,		2.246626044258349e+01,		2.257863347940982e+01,
		2.269075254713549e+01,		2.280261851334861e+01,		2.291423224305239e+01,		2.302559459864974e+01,		2.313670643992872e+01,
		2.324756862404868e+01,		2.335818200552688e+01,		2.346854743622602e+01,		2.357866576534226e+01,		2.368853783939392e+01,
		2.379816450221073e+01,		2.390754659492379e+01,		2.401668495595602e+01,		2.412558042101321e+01,		2.423423382307565e+01,
		2.434264599239021e+01,		2.445081775646314e+01,		2.455874994005313e+01,		2.466644336516510e+01,		2.477389885104438e+01,
		2.488111721417129e+01,		2.498809926825639e+01,		2.509484582423597e+01,		2.520135769026817e+01,		2.530763567172929e+01,
		2.541368057121085e+01,		2.551949318851672e+01,		2.562507432066089e+01,		2.573042476186548e+01,		2.583554530355922e+01,
		2.594043673437628e+01,		2.604509984015532e+01,		2.614953540393918e+01,		2.625374420597454e+01,		2.635772702371222e+01,
		2.646148463180760e+01,		2.656501780212147e+01,		2.666832730372109e+01,		2.677141390288155e+01,		2.687427836308755e+01,
		2.697692144503519e+01,		2.707934390663432e+01,		2.718154650301091e+01,		2.728352998650985e+01,		2.738529510669782e+01,
		2.748684261036658e+01,		2.758817324153632e+01,		2.768928774145934e+01,		2.779018684862391e+01,		2.789087129875834e+01,
		2.799134182483524e+01,		2.809159915707596e+01,		2.819164402295528e+01,		2.829147714720625e+01,		2.839109925182511e+01,
		2.849051105607662e+01,		2.858971327649923e+01,		2.868870662691074e+01,		2.878749181841383e+01,		2.888606955940198e+01,
		2.898444055556526e+01,		2.908260550989661e+01,		2.918056512269789e+01,		2.927832009158633e+01,		2.937587111150093e+01,
		2.947321887470912e+01,		2.957036407081338e+01,		2.966730738675814e+01,		2.976404950683664e+01,		2.986059111269796e+01,
		2.995693288335417e+01,		3.005307549518750e+01,		3.014901962195770e+01,		3.024476593480937e+01,		3.034031510227947e+01,
		3.043566779030486e+01,		3.053082466222997e+01,		3.062578637881441e+01,		3.072055359824086e+01,		3.081512697612278e+01,
		3.090950716551247e+01,		3.100369481690885e+01,		3.109769057826563e+01,		3.119149509499933e+01,		3.128510900999734e+01,
		3.137853296362624e+01,		3.147176759373988e+01,		3.156481353568775e+01,		3.165767142232323e+01,		3.175034188401195e+01,
		3.184282554864018e+01,		3.193512304162327e+01,		3.202723498591408e+01,		3.211916200201141e+01,		3.221090470796869e+01,
		3.230246371940226e+01,		3.239383964950017e+01,		3.248503310903064e+01,		3.257604470635066e+01,		3.266687504741470e+01,
		3.275752473578327e+01,		3.284799437263163e+01,		3.293828455675843e+01,		3.302839588459443e+01,		3.311832895021118e+01,
		3.320808434532969e+01,		3.329766265932923e+01,		3.338706447925598e+01,		3.347629038983177e+01,		3.356534097346286e+01,
		3.365421681024856e+01,		3.374291847799014e+01,		3.383144655219937e+01,		3.391980160610743e+01,		3.400798421067353e+01,
		3.409599493459369e+01,		3.418383434430944e+01,		3.427150300401659e+01,		3.435900147567388e+01,		3.444633031901176e+01,
		3.453349009154101e+01,		3.462048134856155e+01,		3.470730464317098e+01,		3.479396052627339e+01,		3.488044954658790e+01,
		3.496677225065748e+01,		3.505292918285738e+01,		3.513892088540387e+01,		3.522474789836290e+01,		3.531041075965859e+01,
		3.539591000508191e+01,		3.548124616829912e+01,		3.556641978086044e+01,		3.565143137220855e+01,		3.573628146968708e+01,
		3.582097059854912e+01,		3.590549928196570e+01,		3.598986804103426e+01,		3.607407739478707e+01,		3.615812786019970e+01,
		3.624201995219930e+01,		3.632575418367313e+01,		3.640933106547686e+01,		3.649275110644278e+01,		3.657601481338840e+01,
		3.665912269112442e+01,		3.674207524246325e+01,		3.682487296822708e+01,		3.690751636725626e+01,		3.699000593641733e+01,
		3.707234217061139e+01,		3.715452556278204e+01,		3.723655660392369e+01,		3.731843578308953e+01,		3.740016358739970e+01,
		3.748174050204931e+01,		3.756316701031642e+01,		3.764444359357012e+01,		3.772557073127849e+01,		3.780654890101646e+01,
		3.788737857847384e+01,		3.796806023746322e+01,		3.804859434992773e+01,		3.812898138594902e+01,		3.820922181375496e+01,
		3.828931609972754e+01,		3.836926470841053e+01,		3.844906810251728e+01,		3.852872674293847e+01,		3.860824108874969e+01,
		3.868761159721912e+01,		3.876683872381522e+01,		3.884592292221433e+01,		3.892486464430813e+01,		3.900366434021132e+01,
		3.908232245826907e+01,		3.916083944506451e+01,		3.923921574542618e+01,		3.931745180243555e+01,		3.939554805743435e+01,
		3.947350495003188e+01,		3.955132291811255e+01,		3.962900239784304e+01,		3.970654382367967e+01,		3.978394762837563e+01,
		3.986121424298830e+01,		3.993834409688629e+01,		4.001533761775683e+01,		4.009219523161277e+01,		4.016891736279981e+01,
		4.024550443400349e+01,		4.032195686625639e+01,		4.039827507894508e+01,		4.047445948981716e+01,		4.055051051498823e+01,
		4.062642856894892e+01,		4.070221406457172e+01,		4.077786741311797e+01,		4.085338902424471e+01,		4.092877930601149e+01,
		4.100403866488723e+01,		4.107916750575704e+01,		4.115416623192888e+01,		4.122903524514044e+01,		4.130377494556575e+01,
		4.137838573182185e+01,		4.145286800097557e+01,		4.152722214855003e+01,		4.160144856853130e+01,		4.167554765337493e+01,
		4.174951979401256e+01,		4.182336537985842e+01,		4.189708479881576e+01,		4.197067843728345e+01,		4.204414668016219e+01,
		4.211748991086123e+01,		4.219070851130450e+01,		4.226380286193707e+01,		4.233677334173149e+01,		4.240962032819402e+01,
		4.248234419737108e+01,		4.255494532385526e+01,		4.262742408079176e+01,		4.269978083988445e+01,		4.277201597140213e+01,
		4.284412984418459e+01,		4.291612282564887e+01,		4.298799528179521e+01,		4.305974757721317e+01,		4.313138007508770e+01,
		4.320289313720517e+01,		4.327428712395927e+01,		4.334556239435709e+01,		4.341671930602497e+01,		4.348775821521448e+01,
		4.355867947680831e+01,		4.362948344432603e+01,		4.370017046993011e+01,		4.377074090443154e+01,		4.384119509729578e+01,
		4.391153339664844e+01,		4.398175614928105e+01,		4.405186370065673e+01,		4.412185639491598e+01,		4.419173457488222e+01,
		4.426149858206755e+01,		4.433114875667827e+01,		4.440068543762051e+01,		4.447010896250585e+01,		4.453941966765682e+01,
		4.460861788811234e+01,		4.467770395763340e+01,		4.474667820870837e+01,		4.481554097255854e+01,		4.488429257914346e+01,
		4.495293335716647e+01,		4.502146363407999e+01,		4.508988373609086e+01,		4.515819398816571e+01,		4.522639471403627e+01,
		4.529448623620468e+01,		4.536246887594868e+01,		4.543034295332686e+01,		4.549810878718400e+01,		4.556576669515608e+01,
		4.563331699367560e+01,		4.570075999797661e+01,		4.576809602209998e+01,		4.583532537889829e+01,		4.590244838004121e+01,
		4.596946533602021e+01,		4.603637655615391e+01,		4.610318234859291e+01,		4.616988302032482e+01,		4.623647887717922e+01,
		4.630297022383272e+01,		4.636935736381372e+01,		4.643564059950741e+01,		4.650182023216065e+01,		4.656789656188682e+01,
		4.663386988767063e+01,		4.669974050737301e+01,		4.676550871773588e+01,		4.683117481438686e+01,		4.689673909184412e+01,
		4.696220184352102e+01,		4.702756336173100e+01,		4.709282393769205e+01,		4.715798386153149e+01,		4.722304342229071e+01,
		4.728800290792958e+01,		4.735286260533132e+01,		4.741762280030689e+01,		4.748228377759962e+01,		4.754684582088982e+01,
		4.761130921279924e+01,		4.767567423489560e+01,		4.773994116769708e+01,		4.780411029067683e+01,		4.786818188226729e+01,
		4.793215621986486e+01,		4.799603357983399e+01,		4.805981423751190e+01,		4.812349846721269e+01,		4.818708654223186e+01,
		4.825057873485060e+01,		4.831397531633997e+01,		4.837727655696547e+01,		4.844048272599104e+01,		4.850359409168347e+01,
		4.856661092131660e+01,		4.862953348117555e+01,		4.869236203656092e+01,		4.875509685179289e+01,		4.881773819021556e+01,
		4.888028631420091e+01,		4.894274148515304e+01,		4.900510396351221e+01,		4.906737400875897e+01,		4.912955187941826e+01,
		4.919163783306334e+01,		4.925363212632003e+01,		4.931553501487046e+01,		4.937734675345735e+01,		4.943906759588775e+01,
		4.950069779503716e+01,		4.956223760285341e+01,		4.962368727036061e+01,		4.968504704766303e+01,		4.974631718394901e+01,
		4.980749792749490e+01,		4.986858952566877e+01,		4.992959222493437e+01,		4.999050627085494e+01,		5.005133190809698e+01
	},
	{
		8.279501774986975e-02,		2.482561853739095e-01,		4.133249146476591e-01,		5.780020803312712e-01,		7.422885354069133e-01,
		9.061851127595631e-01,		1.069692626775833e+00,		1.232811874864125e+00,		1.395543638899291e+00,		1.557888686594848e+00,
		1.719847772805667e+00,		1.881421640763949e+00,		2.042611023251197e+00,		2.203416643708757e+00,		2.363839217289461e+00,
		2.523879451852738e+00,		2.683538048905529e+00,		2.842815704491224e+00,		3.001713110028759e+00,		3.160230953103932e+00,
		3.318369918214944e+00,		3.476130687474049e+00,		3.633513941267175e+00,		3.790520358873292e+00,		3.947150619045213e+00,
		4.103405400553521e+00,		4.259285382695146e+00,		4.414791245768192e+00,		4.569923671514431e+00,		4.724683343530913e+00,
		4.879070947652064e+00,		5.033087172303562e+00,		5.186732708829296e+00,		5.340008251792613e+00,		5.492914499253036e+00,
		5.645452153019574e+00,		5.797621918881752e+00,		5.949424506819391e+00,		6.100860631192132e+00,		6.251931010909736e+00,
		6.402636369584036e+00,		6.552977435663497e+00,		6.702954942551219e+00,		6.852569628707243e+00,		7.001822237735937e+00,
		7.150713518459284e+00,		7.299244224976751e+00,		7.447415116712503e+00,		7.595226958450648e+00,		7.742680520359134e+00,
		7.889776578002963e+00,		8.036515912347328e+00,		8.182899309751258e+00,		8.328927561952304e+00,		8.474601466042829e+00,
		8.619921824438434e+00,		8.764889444838964e+00,		8.909505140182588e+00,		9.053769728593450e+00,		9.197684033323222e+00,
		9.341248882687109e+00,		9.484465109994572e+00,		9.627333553475236e+00,		9.769855056200297e+00,		9.912030465999820e+00,
		1.005386063537621e+01,		1.019534642141419e+01,		1.033648868568762e+01,		1.047728829416337e+01,		1.061774611710260e+01,
		1.075786302895968e+01,		1.089763990827893e+01,		1.103707763758954e+01,		1.117617710329884e+01,		1.131493919558402e+01,
		1.145336480828275e+01,		1.159145483878260e+01,		1.172921018790973e+01,		1.186663175981677e+01,		1.200372046187023e+01,
		1.214047720453748e+01,		1.227690290127357e+01,		1.241299846840783e+01,		1.254876482503063e+01,		1.268420289288023e+01,
		1.281931359622989e+01,		1.295409786177537e+01,		1.308855661852293e+01,		1.322269079767785e+01,		1.335650133253368e+01,
		1.348998915836218e+01,		1.362315521230413e+01,		1.375600043326094e+01,		1.388852576178739e+01,		1.402073213998519e+01,
		1.415262051139782e+01,		1.428419182090632e+01,		1.441544701462648e+01,		1.454638703980699e+01,		1.467701284472912e+01,
		1.480732537860753e+01,		1.493732559149251e+01,		1.506701443417360e+01,		1.519639285808450e+01,		1.532546181520955e+01,
		1.545422225799155e+01,		1.558267513924111e+01,		1.571082141204746e+01,		1.583866202969068e+01,		1.596619794555560e+01,
		1.609343011304705e+01,		1.622035948550674e+01,		1.634698701613162e+01,		1.647331365789379e+01,		1.659934036346189e+01,
		1.672506808512418e+01,		1.685049777471292e+01,		1.697563038353048e+01,		1.710046686227684e+01,		1.722500816097875e+01,
		1.734925522892022e+01,		1.747320901457466e+01,		1.759687046553850e+01,		1.772024052846618e+01,		1.784332014900680e+01,
		1.796611027174202e+01,		1.808861184012562e+01,		1.821082579642435e+01,		1.833275308166028e+01,		1.845439463555444e+01,
		1.857575139647213e+01,		1.869682430136922e+01,		1.881761428574016e+01,		1.893812228356710e+01,		1.905834922727050e+01,
		1.917829604766094e+01,		1.929796367389227e+01,		1.941735303341606e+01,		1.953646505193721e+01,		1.965530065337094e+01,
		1.977386075980095e+01,		1.989214629143862e+01,		2.001015816658374e+01,		2.012789730158603e+01,		2.024536461080805e+01,
		2.036256100658921e+01,		2.047948739921072e+01,		2.059614469686190e+01,		2.071253380560727e+01,		2.082865562935499e+01,
		2.094451106982600e+01,		2.106010102652449e+01,		2.117542639670920e+01,		2.129048807536563e+01,		2.140528695517943e+01,
		2.151982392651052e+01,		2.163409987736818e+01,		2.174811569338717e+01,		2.186187225780459e+01,		2.197537045143757e+01,
		2.208861115266204e+01,		2.220159523739211e+01,		2.231432357906028e+01,		2.242679704859863e+01,		2.253901651442055e+01,
		2.265098284240344e+01,		2.276269689587199e+01,		2.287415953558230e+01,		2.298537161970669e+01,		2.309633400381921e+01,
		2.320704754088173e+01,		2.331751308123091e+01,		2.342773147256563e+01,		2.353770355993512e+01,		2.364743018572777e+01,
		2.375691218966045e+01,		2.386615040876844e+01,		2.397514567739608e+01,		2.408389882718775e+01,		2.419241068707959e+01,
		2.430068208329167e+01,		2.440871383932071e+01,		2.451650677593333e+01,		2.462406171115972e+01,		2.473137946028792e+01,
		2.483846083585843e+01,		2.494530664765945e+01,		2.505191770272238e+01,		2.515829480531795e+01,		2.526443875695262e+01,
		2.537035035636548e+01,		2.547603039952550e+01,		2.558147967962930e+01,		2.568669898709912e+01,		2.579168910958128e+01,
		2.589645083194500e+01,		2.600098493628151e+01,		2.610529220190356e+01,		2.620937340534529e+01,		2.631322932036233e+01,
		2.641686071793225e+01,		2.652026836625542e+01,		2.662345303075596e+01,		2.672641547408321e+01,		2.682915645611330e+01,
		2.693167673395107e+01,		2.703397706193230e+01,		2.713605819162608e+01,		2.723792087183748e+01,		2.733956584861057e+01,
		2.744099386523146e+01,		2.754220566223177e+01,		2.764320197739218e+01,		2.774398354574625e+01,		2.784455109958449e+01,
		2.794490536845854e+01,		2.804504707918557e+01,		2.814497695585290e+01,		2.824469571982286e+01,		2.834420408973758e+01,
		2.844350278152427e+01,		2.854259250840046e+01,		2.864147398087941e+01,		2.874014790677576e+01,		2.883861499121129e+01,
		2.893687593662077e+01,		2.903493144275798e+01,		2.913278220670195e+01,		2.923042892286315e+01,		2.932787228298998e+01,
		2.942511297617526e+01,		2.952215168886290e+01,		2.961898910485462e+01,		2.971562590531684e+01,		2.981206276878764e+01,
		2.990830037118382e+01,		3.000433938580802e+01,		3.010018048335603e+01,		3.019582433192403e+01,		3.029127159701613e+01,
		3.038652294155172e+01,		3.048157902587315e+01,		3.057644050775327e+01,		3.067110804240328e+01,		3.076558228248034e+01,
		3.085986387809555e+01,		3.095395347682176e+01,		3.104785172370159e+01,		3.114155926125539e+01,		3.123507672948933e+01,
		3.132840476590350e+01,		3.142154400550011e+01,		3.151449508079166e+01,		3.160725862180916e+01,		3.169983525611047e+01,
		3.179222560878860e+01,		3.188443030248007e+01,		3.197644995737326e+01,		3.206828519121692e+01,		3.215993661932854e+01,
		3.225140485460287e+01,		3.234269050752037e+01,		3.243379418615581e+01,		3.252471649618674e+01,		3.261545804090211e+01,
		3.270601942121083e+01,		3.279640123565034e+01,		3.288660408039527e+01,		3.297662854926603e+01,		3.306647523373746e+01,
		3.315614472294749e+01,		3.324563760370573e+01,		3.333495446050224e+01,		3.342409587551610e+01,		3.351306242862409e+01,
		3.360185469740942e+01,		3.369047325717037e+01,		3.377891868092895e+01,		3.386719153943961e+01,		3.395529240119787e+01,
		3.404322183244907e+01,		3.413098039719694e+01,		3.421856865721232e+01,		3.430598717204181e+01,		3.439323649901642e+01,
		3.448031719326019e+01,		3.456722980769889e+01,		3.465397489306852e+01,		3.474055299792412e+01,		3.482696466864815e+01,
		3.491321044945924e+01,		3.499929088242074e+01,		3.508520650744924e+01,		3.517095786232319e+01,		3.525654548269139e+01,
		3.534196990208147e+01,		3.542723165190861e+01,		3.551233126148372e+01,		3.559726925802219e+01,		3.568204616665217e+01,
		3.576666251042315e+01,		3.585111881031420e+01,		3.593541558524262e+01,		3.601955335207211e+01,		3.610353262562121e+01,
		3.618735391867169e+01,		3.627101774197678e+01,		3.635452460426961e+01,		3.643787501227133e+01,		3.652106947069948e+01,
		3.660410848227621e+01,		3.668699254773644e+01,		3.676972216583611e+01,		3.685229783336035e+01,		3.693472004513158e+01,
		3.701698929401769e+01,		3.709910607094010e+01,		3.718107086488184e+01,		3.726288416289556e+01,		3.734454645011167e+01,
		3.742605820974622e+01,		3.750741992310896e+01,		3.758863206961118e+01,		3.766969512677377e+01,		3.775060957023505e+01,
		3.783137587375860e+01,		3.791199450924121e+01,		3.799246594672059e+01,		3.807279065438323e+01,		3.815296909857219e+01,
		3.823300174379478e+01,		3.831288905273028e+01,		3.839263148623764e+01,		3.847222950336318e+01,		3.855168356134819e+01,
		3.863099411563651e+01,		3.871016161988211e+01,		3.878918652595674e+01,		3.886806928395729e+01,		3.894681034221345e+01,
		3.902541014729508e+01,		3.910386914401963e+01,		3.918218777545967e+01,		3.926036648295016e+01,		3.933840570609591e+01,
		3.941630588277878e+01,		3.949406744916512e+01,		3.957169083971295e+01,		3.964917648717928e+01,		3.972652482262725e+01,
		3.980373627543342e+01,		3.988081127329483e+01,		3.995775024223621e+01,		4.003455360661705e+01,		4.011122178913873e+01,
		4.018775521085150e+01,		4.026415429116160e+01,		4.034041944783810e+01,		4.041655109702012e+01,		4.049254965322351e+01,
		4.056841552934792e+01,		4.064414913668367e+01,		4.071975088491854e+01,		4.079522118214467e+01,		4.087056043486540e+01,
		4.094576904800189e+01,		4.102084742490004e+01,		4.109579596733709e+01,		4.117061507552844e+01,		4.124530514813417e+01,
		4.131986658226582e+01,		4.139429977349287e+01,		4.146860511584941e+01,		4.154278300184072e+01,		4.161683382244973e+01,
		4.169075796714355e+01,		4.176455582387997e+01,		4.183822777911387e+01,		4.191177421780371e+01,		4.198519552341786e+01,
		4.205849207794098e+01,		4.213166426188037e+01,		4.220471245427239e+01,		4.227763703268851e+01,		4.235043837324184e+01,
		4.242311685059322e+01,		4.249567283795741e+01,		4.256810670710938e+01,		4.264041882839041e+01,		4.271260957071418e+01,
		4.278467930157302e+01,		4.285662838704383e+01,		4.292845719179419e+01,		4.300016607908845e+01,		4.307175541079368e+01,
		4.314322554738562e+01,		4.321457684795472e+01,		4.328580967021201e+01,		4.335692437049496e+01,		4.342792130377349e+01,
		4.349880082365566e+01,		4.356956328239364e+01,		4.364020903088944e+01,		4.371073841870065e+01,		4.378115179404628e+01,
		4.385144950381247e+01,		4.392163189355811e+01,		4.399169930752066e+01,		4.406165208862165e+01,		4.413149057847243e+01,
		4.420121511737967e+01,		4.427082604435109e+01,		4.434032369710085e+01,		4.440970841205522e+01,		4.447898052435797e+01,
		4.454814036787596e+01,		4.461718827520453e+01,		4.468612457767298e+01,		4.475494960534998e+01,		4.482366368704892e+01,
		4.489226715033330e+01,		4.496076032152212e+01,		4.502914352569516e+01,		4.509741708669821e+01,		4.516558132714847e+01,
		4.523363656843978e+01,		4.530158313074769e+01,		4.536942133303494e+01,		4.543715149305636e+01,		4.550477392736428e+01,
		4.557228895131342e+01,		4.563969687906619e+01,		4.570699802359781e+01,		4.577419269670118e+01,		4.584128120899208e+01,
		4.590826386991419e+01,		4.597514098774406e+01,		4.604191286959608e+01,		4.610857982142744e+01,		4.617514214804316e+01,
		4.624160015310087e+01,		4.630795413911582e+01,		4.637420440746562e+01,		4.644035125839531e+01,		4.650639499102191e+01,
		4.657233590333948e+01,		4.663817429222378e+01,		4.670391045343708e+01,		4.676954468163284e+01,		4.683507727036051e+01,
		4.690050851207028e+01,		4.696583869811757e+01,		4.703106811876789e+01,		4.709619706320146e+01,		4.716122581951767e+01,
		4.722615467473989e+01,		4.729098391481990e+01,		4.735571382464256e+01,		4.742034468803027e+01,		4.748487678774751e+01,
		4.754931040550537e+01,		4.761364582196600e+01,		4.767788331674713e+01,		4.774202316842641e+01,		4.780606565454593e+01,
		4.787001105161654e+01,		4.793385963512231e+01,		4.799761167952483e+01,		4.806126745826765e+01,		4.812482724378042e+01,
		4.818829130748344e+01,		4.825165991979168e+01,		4.831493335011933e+01,		4.837811186688378e+01,		4.844119573751007e+01,
		4.850418522843496e+01,		4.856708060511116e+01,		4.862988213201150e+01,		4.869259007263317e+01,		4.875520468950171e+01,
		4.881772624417523e+01,		4.888015499724848e+01,		4.894249120835693e+01,		4.900473513618081e+01,		4.906688703844922e+01,
		4.912894717194408e+01,		4.919091579250422e+01,		4.925279315502935e+01,		4.931457951348388e+01,		4.937627512090117e+01,
		4.943788022938720e+01,		4.949939509012466e+01,		4.956081995337676e+01,		4.962215506849115e+01,		4.968340068390378e+01,
		4.974455704714277e+01,		4.980562440483225e+01,		4.986660300269612e+01,		4.992749308556188e+01,		4.998829489736448e+01
	},
	{
		8.262483256793354e-02,		2.477462452043181e-01,		4.124764951889098e-01,		5.768164574988242e-01,		7.407669855144223e-01,
		9.043289126797407e-01,		1.067503054082063e+00,		1.230290207953893e+00,		1.392691157100461e+00,		1.554706670255747e+00,
		1.716337503369928e+00,		1.877584400830998e+00,		2.038448096623236e+00,		2.198929315425068e+00,		2.359028773648794e+00,
		2.518747180424555e+00,		2.678085238530790e+00,		2.837043645273408e+00,		2.995623093315773e+00,		3.153824271461522e+00,
		3.311647865392194e+00,		3.469094558361554e+00,		3.626165031848403e+00,		3.782859966169659e+00,		3.939180041055369e+00,
		4.095125936187285e+00,		4.250698331702585e+00,		4.405897908664197e+00,		4.560725349499255e+00,		4.715181338407028e+00,
		4.869266561737676e+00,		5.022981708343183e+00,		5.176327469901642e+00,		5.329304541216176e+00,		5.481913620489617e+00,
		5.634155409576042e+00,		5.786030614210310e+00,		5.937539944216566e+00,		6.088684113696784e+00,		6.239463841200232e+00,
		6.389879849874856e+00,		6.539932867601447e+00,		6.689623627111429e+00,		6.838952866089137e+00,		6.987921327259333e+00,
		7.136529758460772e+00,		7.284778912706503e+00,		7.432669548231637e+00,		7.580202428529271e+00,		7.727378322375180e+00,
		7.874198003841959e+00,		8.020662252303147e+00,		8.166771852427956e+00,		8.312527594167170e+00,		8.457930272730684e+00,
		8.602980688557244e+00,		8.747679647276867e+00,		8.892027959666384e+00,		9.036026441598576e+00,		9.179675913985330e+00,
		9.322977202715181e+00,		9.465931138585734e+00,		9.608538557231222e+00,		9.750800299045618e+00,		9.892717209101667e+00,
		1.003429013706611e+01,		1.017551993711143e+01,		1.031640746782444e+01,		1.045695359211198e+01,		1.059715917710400e+01,
		1.073702509405424e+01,		1.087655221823886e+01,		1.101574142885311e+01,		1.115459360890643e+01,		1.129310964511599e+01,
		1.143129042779907e+01,		1.156913685076434e+01,		1.170664981120226e+01,		1.184383020957476e+01,		1.198067894950439e+01,
		1.211719693766307e+01,		1.225338508366057e+01,		1.238924429993291e+01,		1.252477550163074e+01,		1.265997960650784e+01,
		1.279485753480993e+01,		1.292941020916377e+01,		1.306363855446673e+01,		1.319754349777698e+01,		1.333112596820418e+01,
		1.346438689680104e+01,		1.359732721645556e+01,		1.372994786178421e+01,		1.386224976902603e+01,		1.399423387593771e+01,
		1.412590112168973e+01,		1.425725244676365e+01,		1.438828879285051e+01,		1.451901110275043e+01,		1.464942032027350e+01,
		1.477951739014192e+01,		1.490930325789342e+01,		1.503877886978614e+01,		1.516794517270470e+01,		1.529680311406791e+01,
		1.542535364173763e+01,		1.555359770392930e+01,		1.568153624912376e+01,		1.580917022598066e+01,		1.593650058325326e+01,
		1.606352826970476e+01,		1.619025423402615e+01,		1.631667942475552e+01,		1.644280479019888e+01,		1.656863127835253e+01,
		1.669415983682692e+01,		1.681939141277195e+01,		1.694432695280393e+01,		1.706896740293385e+01,		1.719331370849735e+01,
		1.731736681408596e+01,		1.744112766348005e+01,		1.756459719958308e+01,		1.768777636435735e+01,		1.781066609876132e+01,
		1.793326734268821e+01,		1.805558103490608e+01,		1.817760811299945e+01,		1.829934951331214e+01,		1.842080617089160e+01,
		1.854197901943466e+01,		1.866286899123446e+01,		1.878347701712898e+01,		1.890380402645064e+01,		1.902385094697743e+01,
		1.914361870488518e+01,		1.926310822470118e+01,		1.938232042925907e+01,		1.950125623965491e+01,		1.961991657520454e+01,
		1.973830235340210e+01,		1.985641448987978e+01,		1.997425389836871e+01,		2.009182149066098e+01,		2.020911817657285e+01,
		2.032614486390908e+01,		2.044290245842822e+01,		2.055939186380917e+01,		2.067561398161865e+01,		2.079156971127983e+01,
		2.090725995004183e+01,		2.102268559295038e+01,		2.113784753281934e+01,		2.125274666020326e+01,		2.136738386337088e+01,
		2.148176002827954e+01,		2.159587603855047e+01,		2.170973277544503e+01,		2.182333111784181e+01,		2.193667194221460e+01,
		2.204975612261114e+01,		2.216258453063274e+01,		2.227515803541473e+01,		2.238747750360766e+01,		2.249954379935928e+01,
		2.261135778429723e+01,		2.272292031751263e+01,		2.283423225554416e+01,		2.294529445236306e+01,		2.305610775935865e+01,
		2.316667302532467e+01,		2.327699109644622e+01,		2.338706281628727e+01,		2.349688902577894e+01,		2.360647056320832e+01,
		2.371580826420788e+01,		2.382490296174553e+01,		2.393375548611514e+01,		2.404236666492777e+01,		2.415073732310335e+01,
		2.425886828286286e+01,		2.436676036372117e+01,		2.447441438248024e+01,		2.458183115322288e+01,		2.468901148730702e+01,
		2.479595619336036e+01,		2.490266607727563e+01,		2.500914194220609e+01,		2.511538458856165e+01,		2.522139481400533e+01,
		2.532717341345013e+01,		2.543272117905630e+01,		2.553803890022909e+01,		2.564312736361668e+01,		2.574798735310872e+01,
		2.585261964983507e+01,		2.595702503216491e+01,		2.606120427570631e+01,		2.616515815330592e+01,		2.626888743504921e+01,
		2.637239288826082e+01,		2.647567527750535e+01,		2.657873536458846e+01,		2.668157390855810e+01,		2.678419166570617e+01,
		2.688658938957038e+01,		2.698876783093648e+01,		2.709072773784049e+01,		2.719246985557152e+01,		2.729399492667452e+01,
		2.739530369095348e+01,		2.749639688547474e+01,		2.759727524457053e+01,		2.769793949984280e+01,		2.779839038016715e+01,
		2.789862861169701e+01,		2.799865491786803e+01,		2.809847001940262e+01,		2.819807463431469e+01,		2.829746947791453e+01,
		2.839665526281395e+01,		2.849563269893145e+01,		2.859440249349768e+01,		2.869296535106091e+01,		2.879132197349280e+01,
		2.888947305999425e+01,		2.898741930710125e+01,		2.908516140869113e+01,		2.918270005598872e+01,		2.928003593757272e+01,
		2.937716973938215e+01,		2.947410214472299e+01,		2.957083383427485e+01,		2.966736548609774e+01,		2.976369777563902e+01,
		2.985983137574038e+01,		2.995576695664496e+01,		3.005150518600444e+01,		3.014704672888648e+01,		3.024239224778191e+01,
		3.033754240261224e+01,		3.043249785073716e+01,		3.052725924696209e+01,		3.062182724354590e+01,		3.071620249020851e+01,
		3.081038563413881e+01,		3.090437732000235e+01,		3.099817818994936e+01,		3.109178888362264e+01,		3.118521003816557e+01,
		3.127844228823013e+01,		3.137148626598509e+01,		3.146434260112407e+01,		3.155701192087370e+01,		3.164949485000199e+01,
		3.174179201082641e+01,		3.183390402322230e+01,		3.192583150463114e+01,		3.201757507006896e+01,		3.210913533213473e+01,
		3.220051290101867e+01,		3.229170838451084e+01,		3.238272238800947e+01,		3.247355551452955e+01,		3.256420836471124e+01,
		3.265468153682848e+01,		3.274497562679743e+01,		3.283509122818508e+01,		3.292502893221784e+01,		3.301478932779003e+01,
		3.310437300147254e+01,		3.319378053752138e+01,		3.328301251788628e+01,		3.337206952221935e+01,		3.346095212788363e+01,
		3.354966090996167e+01,		3.363819644126429e+01,		3.372655929233905e+01,		3.381475003147891e+01,		3.390276922473087e+01,
		3.399061743590456e+01,		3.407829522658084e+01,		3.416580315612048e+01,		3.425314178167262e+01,		3.434031165818344e+01,
		3.442731333840479e+01,		3.451414737290268e+01,		3.460081431006591e+01,		3.468731469611454e+01,		3.477364907510862e+01,
		3.485981798895644e+01,		3.494582197742339e+01,		3.503166157814015e+01,		3.511733732661142e+01,		3.520284975622432e+01,
		3.528819939825679e+01,		3.537338678188618e+01,		3.545841243419754e+01,		3.554327688019221e+01,		3.562798064279604e+01,
		3.571252424286790e+01,		3.579690819920803e+01,		3.588113302856632e+01,		3.596519924565072e+01,		3.604910736313550e+01,
		3.613285789166957e+01,		3.621645133988473e+01,		3.629988821440391e+01,		3.638316901984948e+01,		3.646629425885126e+01,
		3.654926443205494e+01,		3.663208003813011e+01,		3.671474157377836e+01,		3.679724953374155e+01,		3.687960441080974e+01,
		3.696180669582936e+01,		3.704385687771121e+01,		3.712575544343852e+01,		3.720750287807489e+01,		3.728909966477230e+01,
		3.737054628477911e+01,		3.745184321744784e+01,		3.753299094024322e+01,		3.761398992874997e+01,		3.769484065668070e+01,
		3.777554359588364e+01,		3.785609921635057e+01,		3.793650798622452e+01,		3.801677037180746e+01,		3.809688683756813e+01,
		3.817685784614963e+01,		3.825668385837716e+01,		3.833636533326559e+01,		3.841590272802713e+01,		3.849529649807886e+01,
		3.857454709705038e+01,		3.865365497679117e+01,		3.873262058737831e+01,		3.881144437712377e+01,		3.889012679258195e+01,
		3.896866827855710e+01,		3.904706927811067e+01,		3.912533023256872e+01,		3.920345158152924e+01,		3.928143376286948e+01,
		3.935927721275317e+01,		3.943698236563787e+01,		3.951454965428213e+01,		3.959197950975273e+01,		3.966927236143179e+01,
		3.974642863702404e+01,		3.982344876256381e+01,		3.990033316242217e+01,		3.997708225931403e+01,		4.005369647430511e+01,
		4.013017622681897e+01,		4.020652193464404e+01,		4.028273401394049e+01,		4.035881287924722e+01,		4.043475894348876e+01,
		4.051057261798204e+01,		4.058625431244337e+01,		4.066180443499519e+01,		4.073722339217284e+01,		4.081251158893133e+01,
		4.088766942865213e+01,		4.096269731314980e+01,		4.103759564267868e+01,		4.111236481593962e+01,		4.118700523008648e+01,
		4.126151728073282e+01,		4.133590136195846e+01,		4.141015786631598e+01,		4.148428718483729e+01,		4.155828970704002e+01,
		4.163216582093415e+01,		4.170591591302831e+01,		4.177954036833619e+01,		4.185303957038303e+01,		4.192641390121180e+01,
		4.199966374138980e+01,		4.207278947001464e+01,		4.214579146472075e+01,		4.221867010168557e+01,		4.229142575563570e+01,
		4.236405879985320e+01,		4.243656960618174e+01,		4.250895854503264e+01,		4.258122598539118e+01,		4.265337229482249e+01,
		4.272539783947781e+01,		4.279730298410036e+01,		4.286908809203145e+01,		4.294075352521655e+01,		4.301229964421099e+01,
		4.308372680818623e+01,		4.315503537493552e+01,		4.322622570087994e+01,		4.329729814107420e+01,		4.336825304921246e+01,
		4.343909077763423e+01,		4.350981167733008e+01,		4.358041609794740e+01,		4.365090438779622e+01,		4.372127689385484e+01,
		4.379153396177561e+01,		4.386167593589045e+01,		4.393170315921667e+01,		4.400161597346249e+01,		4.407141471903260e+01,
		4.414109973503382e+01,		4.421067135928058e+01,		4.428012992830048e+01,		4.434947577733976e+01,		4.441870924036878e+01,
		4.448783065008749e+01,		4.455684033793082e+01,		4.462573863407408e+01,		4.469452586743843e+01,		4.476320236569611e+01,
		4.483176845527587e+01,		4.490022446136820e+01,		4.496857070793067e+01,		4.503680751769322e+01,		4.510493521216328e+01,
		4.517295411163119e+01,		4.524086453517508e+01,		4.530866680066647e+01,		4.537636122477502e+01,		4.544394812297385e+01,
		4.551142780954466e+01,		4.557880059758275e+01,		4.564606679900206e+01,		4.571322672454034e+01,		4.578028068376394e+01,
		4.584722898507309e+01,		4.591407193570661e+01,		4.598080984174700e+01,		4.604744300812535e+01,		4.611397173862622e+01,
		4.618039633589254e+01,		4.624671710143050e+01,		4.631293433561439e+01,		4.637904833769130e+01,		4.644505940578611e+01,
		4.651096783690614e+01,		4.657677392694599e+01,		4.664247797069219e+01,		4.670808026182797e+01,		4.677358109293795e+01,
		4.683898075551281e+01,		4.690427953995395e+01,		4.696947773557814e+01,		4.703457563062204e+01,		4.709957351224697e+01,
		4.716447166654329e+01,		4.722927037853506e+01,		4.729396993218462e+01,		4.735857061039693e+01,		4.742307269502424e+01,
		4.748747646687048e+01,		4.755178220569567e+01,		4.761599019022053e+01,		4.768010069813061e+01,		4.774411400608097e+01,
		4.780803038970036e+01,		4.787185012359567e+01,		4.793557348135623e+01,		4.799920073555815e+01,		4.806273215776860e+01,
		4.812616801855008e+01,		4.818950858746468e+01,		4.825275413307839e+01,		4.831590492296519e+01,		4.837896122371137e+01,
		4.844192330091968e+01,		4.850479141921344e+01,		4.856756584224081e+01,		4.863024683267874e+01,		4.869283465223729e+01,
		4.875532956166357e+01,		4.881773182074579e+01,		4.888004168831758e+01,		4.894225942226161e+01,		4.900438527951398e+01,
		4.906641951606802e+01,		4.912836238697835e+01,		4.919021414636482e+01,		4.925197504741647e+01,		4.931364534239546e+01,
		4.937522528264101e+01,		4.943671511857320e+01,		4.949811509969696e+01,		4.955942547460588e+01,		4.962064649098608e+01,
		4.968177839562001e+01,		4.974282143439029e+01,		4.980377585228344e+01,		4.986464189339372e+01,		4.992541980092689e+01
	},
	{
		8.245534582662600e-02,		2.472383978517298e-01,		4.116315576772580e-01,		5.756357004491162e-01,		7.392516798956600e-01,
		9.024803299680456e-01,		1.065322466400822e+00,		1.227778888195977e+00,		1.389850379033522e+00,		1.551537708611560e+00,
		1.712841633918691e+00,		1.873762900441477e+00,		2.034302243309587e+00,		2.194460388381151e+00,		2.354238053270739e+00,
		2.513635948322318e+00,		2.672654777529400e+00,		2.831295239404577e+00,		2.989558027800501e+00,		3.147443832684319e+00,
		3.304953340867505e+00,		3.462087236692916e+00,		3.618846202680909e+00,		3.775230920136191e+00,		3.931242069717113e+00,
		4.086880331968981e+00,		4.242146387822923e+00,		4.397040919061832e+00,		4.551564608754770e+00,		4.705718141661270e+00,
		4.859502204606816e+00,		5.012917486830800e+00,		5.165964680308221e+00,		5.318644480046266e+00,		5.470957584356958e+00,
		5.622904695106962e+00,		5.774486517945597e+00,		5.925703762512126e+00,		6.076557142623247e+00,		6.227047376441782e+00,
		6.377175186627469e+00,		6.526941300470717e+00,		6.676346450010193e+00,		6.825391372135045e+00,		6.974076808672542e+00,
		7.122403506461905e+00,		7.270372217415010e+00,		7.417983698564716e+00,		7.565238712101418e+00,		7.712138025398565e+00,
		7.858682411027627e+00,		8.004872646763252e+00,		8.150709515579040e+00,		8.296193805634607e+00,		8.441326310254361e+00,
		8.586107827898541e+00,		8.730539162127018e+00,		8.874621121556244e+00,		9.018354519809900e+00,		9.161740175463553e+00,
		9.304778911983803e+00,		9.447471557662293e+00,		9.589818945544911e+00,		9.731821913356598e+00,		9.873481303422059e+00,
		1.001479796258272e+01,		1.015577274211022e+01,		1.029640649761673e+01,		1.043670008896247e+01,		1.057665438016050e+01,
		1.071627023927921e+01,		1.085554853834275e+01,		1.099449015322948e+01,		1.113309596356882e+01,		1.127136685263661e+01,
		1.140930370724924e+01,		1.154690741765667e+01,		1.168417887743465e+01,		1.182111898337606e+01,		1.195772863538186e+01,
		1.209400873635150e+01,		1.222996019207318e+01,		1.236558391111379e+01,		1.250088080470908e+01,		1.263585178665376e+01,
		1.277049777319193e+01,		1.290481968290775e+01,		1.303881843661669e+01,		1.317249495725712e+01,		1.330585016978272e+01,
		1.343888500105537e+01,		1.357160037973899e+01,		1.370399723619417e+01,		1.383607650237363e+01,		1.396783911171882e+01,
		1.409928599905736e+01,		1.423041810050171e+01,		1.436123635334893e+01,		1.449174169598154e+01,		1.462193506776973e+01,
		1.475181740897473e+01,		1.488138966065348e+01,		1.501065276456467e+01,		1.513960766307605e+01,		1.526825529907318e+01,
		1.539659661586955e+01,		1.552463255711810e+01,		1.565236406672414e+01,		1.577979208875984e+01,		1.590691756737999e+01,
		1.603374144673940e+01,		1.616026467091163e+01,		1.628648818380930e+01,		1.641241292910584e+01,		1.653803985015874e+01,
		1.666336988993423e+01,		1.678840399093356e+01,		1.691314309512062e+01,		1.703758814385120e+01,		1.716174007780355e+01,
		1.728559983691054e+01,		1.740916836029323e+01,		1.753244658619590e+01,		1.765543545192252e+01,		1.777813589377462e+01,
		1.790054884699070e+01,		1.802267524568689e+01,		1.814451602279908e+01,		1.826607211002654e+01,		1.838734443777668e+01,
		1.850833393511141e+01,		1.862904152969464e+01,		1.874946814774128e+01,		1.886961471396738e+01,		1.898948215154175e+01,
		1.910907138203868e+01,		1.922838332539203e+01,		1.934741889985057e+01,		1.946617902193445e+01,		1.958466460639298e+01,
		1.970287656616359e+01,		1.982081581233187e+01,		1.993848325409290e+01,		2.005587979871363e+01,		2.017300635149635e+01,
		2.028986381574343e+01,		2.040645309272290e+01,		2.052277508163527e+01,		2.063883067958139e+01,		2.075462078153121e+01,
		2.087014628029367e+01,		2.098540806648760e+01,		2.110040702851343e+01,		2.121514405252604e+01,		2.132962002240843e+01,
		2.144383581974636e+01,		2.155779232380391e+01,		2.167149041149984e+01,		2.178493095738491e+01,		2.189811483361997e+01,
		2.201104290995497e+01,		2.212371605370869e+01,		2.223613512974934e+01,		2.234830100047590e+01,		2.246021452580024e+01,
		2.257187656313002e+01,		2.268328796735222e+01,		2.279444959081751e+01,		2.290536228332527e+01,		2.301602689210926e+01,
		2.312644426182401e+01,		2.323661523453182e+01,		2.334654064969047e+01,		2.345622134414150e+01,		2.356565815209907e+01,
		2.367485190513949e+01,		2.378380343219134e+01,		2.389251355952602e+01,		2.400098311074906e+01,		2.410921290679180e+01,
		2.421720376590368e+01,		2.432495650364505e+01,		2.443247193288044e+01,		2.453975086377237e+01,		2.464679410377554e+01,
		2.475360245763169e+01,		2.486017672736467e+01,		2.496651771227609e+01,		2.507262620894144e+01,		2.517850301120646e+01,
		2.528414891018413e+01,		2.538956469425190e+01,		2.549475114904940e+01,		2.559970905747639e+01,		2.570443919969135e+01,
		2.580894235311011e+01,		2.591321929240505e+01,		2.601727078950454e+01,		2.612109761359271e+01,		2.622470053110961e+01,
		2.632808030575158e+01,		2.643123769847205e+01,		2.653417346748243e+01,		2.663688836825356e+01,		2.673938315351719e+01,
		2.684165857326786e+01,		2.694371537476504e+01,		2.704555430253539e+01,		2.714717609837552e+01,		2.724858150135470e+01,
		2.734977124781803e+01,		2.745074607138968e+01,		2.755150670297644e+01,		2.765205387077145e+01,		2.775238830025811e+01,
		2.785251071421428e+01,		2.795242183271646e+01,		2.805212237314445e+01,		2.815161305018597e+01,		2.825089457584149e+01,
		2.834996765942931e+01,		2.844883300759071e+01,		2.854749132429535e+01,		2.864594331084664e+01,		2.874418966588758e+01,
		2.884223108540636e+01,		2.894006826274238e+01,		2.903770188859225e+01,		2.913513265101602e+01,		2.923236123544343e+01,
		2.932938832468036e+01,		2.942621459891535e+01,		2.952284073572622e+01,		2.961926741008685e+01,		2.971549529437397e+01,
		2.981152505837420e+01,		2.990735736929097e+01,		3.000299289175171e+01,		3.009843228781506e+01,		3.019367621697816e+01,
		3.028872533618397e+01,		3.038358029982881e+01,		3.047824175976980e+01,		3.057271036533247e+01,		3.066698676331844e+01,
		3.076107159801311e+01,		3.085496551119344e+01,		3.094866914213580e+01,		3.104218312762386e+01,		3.113550810195649e+01,
		3.122864469695579e+01,		3.132159354197511e+01,		3.141435526390719e+01,		3.150693048719215e+01,		3.159931983382578e+01,
		3.169152392336768e+01,		3.178354337294951e+01,		3.187537879728324e+01,		3.196703080866946e+01,		3.205850001700571e+01,
		3.214978702979482e+01,		3.224089245215330e+01,		3.233181688681975e+01,		3.242256093416325e+01,		3.251312519219182e+01,
		3.260351025656088e+01,		3.269371672058173e+01,		3.278374517523002e+01,		3.287359620915425e+01,		3.296327040868434e+01,
		3.305276835784010e+01,		3.314209063833974e+01,		3.323123782960847e+01,		3.332021050878704e+01,		3.340900925074023e+01,
		3.349763462806546e+01,		3.358608721110133e+01,		3.367436756793617e+01,		3.376247626441659e+01,		3.385041386415609e+01,
		3.393818092854352e+01,		3.402577801675170e+01,		3.411320568574594e+01,		3.420046449029255e+01,		3.428755498296748e+01,
		3.437447771416469e+01,		3.446123323210482e+01,		3.454782208284358e+01,		3.463424481028034e+01,		3.472050195616652e+01,
		3.480659406011417e+01,		3.489252165960441e+01,		3.497828528999583e+01,		3.506388548453297e+01,		3.514932277435477e+01,
		3.523459768850292e+01,		3.531971075393034e+01,		3.540466249550942e+01,		3.548945343604058e+01,		3.557408409626048e+01,
		3.565855499485033e+01,		3.574286664844433e+01,		3.582701957163783e+01,		3.591101427699572e+01,		3.599485127506055e+01,
		3.607853107436092e+01,		3.616205418141957e+01,		3.624542110076165e+01,		3.632863233492282e+01,		3.641168838445753e+01,
		3.649458974794698e+01,		3.657733692200735e+01,		3.665993040129790e+01,		3.674237067852892e+01,		3.682465824446984e+01,
		3.690679358795727e+01,		3.698877719590297e+01,		3.707060955330177e+01,		3.715229114323961e+01,		3.723382244690137e+01,
		3.731520394357887e+01,		3.739643611067858e+01,		3.747751942372965e+01,		3.755845435639162e+01,		3.763924138046224e+01,
		3.771988096588525e+01,		3.780037358075813e+01,		3.788071969133978e+01,		3.796091976205825e+01,		3.804097425551846e+01,
		3.812088363250970e+01,		3.820064835201336e+01,		3.828026887121047e+01,		3.835974564548932e+01,		3.843907912845290e+01,
		3.851826977192648e+01,		3.859731802596507e+01,		3.867622433886090e+01,		3.875498915715077e+01,		3.883361292562354e+01,
		3.891209608732747e+01,		3.899043908357756e+01,		3.906864235396283e+01,		3.914670633635372e+01,		3.922463146690922e+01,
		3.930241818008427e+01,		3.938006690863679e+01,		3.945757808363496e+01,		3.953495213446438e+01,		3.961218948883521e+01,
		3.968929057278915e+01,		3.976625581070670e+01,		3.984308562531407e+01,		3.991978043769022e+01,		3.999634066727388e+01,
		4.007276673187049e+01,		4.014905904765918e+01,		4.022521802919958e+01,		4.030124408943882e+01,		4.037713763971833e+01,
		4.045289908978057e+01,		4.052852884777607e+01,		4.060402732026991e+01,		4.067939491224872e+01,		4.075463202712721e+01,
		4.082973906675499e+01,		4.090471643142311e+01,		4.097956451987081e+01,		4.105428372929210e+01,		4.112887445534230e+01,
		4.120333709214460e+01,		4.127767203229663e+01,		4.135187966687695e+01,		4.142596038545148e+01,		4.149991457608000e+01,
		4.157374262532255e+01,		4.164744491824582e+01,		4.172102183842956e+01,		4.179447376797279e+01,		4.186780108750030e+01,
		4.194100417616885e+01,		4.201408341167336e+01,		4.208703917025326e+01,		4.215987182669870e+01,		4.223258175435660e+01,
		4.230516932513697e+01,		4.237763490951893e+01,		4.244997887655689e+01,		4.252220159388657e+01,		4.259430342773110e+01,
		4.266628474290702e+01,		4.273814590283032e+01,		4.280988726952233e+01,		4.288150920361583e+01,		4.295301206436083e+01,
		4.302439620963048e+01,		4.309566199592710e+01,		4.316680977838784e+01,		4.323783991079061e+01,		4.330875274555990e+01,
		4.337954863377244e+01,		4.345022792516315e+01,		4.352079096813063e+01,		4.359123810974310e+01,		4.366156969574385e+01,
		4.373178607055706e+01,		4.380188757729340e+01,		4.387187455775558e+01,		4.394174735244400e+01,		4.401150630056222e+01,
		4.408115174002258e+01,		4.415068400745167e+01,		4.422010343819582e+01,		4.428941036632656e+01,		4.435860512464608e+01,
		4.442768804469260e+01,		4.449665945674578e+01,		4.456551968983216e+01,		4.463426907173038e+01,		4.470290792897658e+01,
		4.477143658686966e+01,		4.483985536947664e+01,		4.490816459963779e+01,		4.497636459897193e+01,		4.504445568788164e+01,
		4.511243818555845e+01,		4.518031240998793e+01,		4.524807867795489e+01,		4.531573730504856e+01,		4.538328860566750e+01,
		4.545073289302486e+01,		4.551807047915335e+01,		4.558530167491026e+01,		4.565242678998246e+01,		4.571944613289139e+01,
		4.578636001099810e+01,		4.585316873050809e+01,		4.591987259647621e+01,		4.598647191281169e+01,		4.605296698228291e+01,
		4.611935810652227e+01,		4.618564558603101e+01,		4.625182972018412e+01,		4.631791080723498e+01,		4.638388914432022e+01,
		4.644976502746449e+01,		4.651553875158513e+01,		4.658121061049691e+01,		4.664678089691668e+01,		4.671224990246807e+01,
		4.677761791768616e+01,		4.684288523202203e+01,		4.690805213384739e+01,		4.697311891045923e+01,		4.703808584808436e+01,
		4.710295323188380e+01,		4.716772134595756e+01,		4.723239047334895e+01,		4.729696089604912e+01,		4.736143289500158e+01,
		4.742580675010658e+01,		4.749008274022550e+01,		4.755426114318537e+01,		4.761834223578319e+01,		4.768232629379020e+01,
		4.774621359195653e+01,		4.781000440401506e+01,		4.787369900268619e+01,		4.793729765968187e+01,		4.800080064570989e+01,
		4.806420823047825e+01,		4.812752068269924e+01,		4.819073827009380e+01,		4.825386125939553e+01,		4.831688991635515e+01,
		4.837982450574435e+01,		4.844266529136012e+01,		4.850541253602880e+01,		4.856806650161026e+01,		4.863062744900188e+01,
		4.869309563814265e+01,		4.875547132801730e+01,		4.881775477666017e+01,		4.887994624115940e+01,		4.894204597766084e+01,
		4.900405424137195e+01,		4.906597128656591e+01,		4.912779736658547e+01,		4.918953273384693e+01,		4.925117763984395e+01,
		4.931273233515152e+01,		4.937419706942983e+01,		4.943557209142813e+01,		4.949685764898852e+01,		4.955805398904979e+01,
		4.961916135765122e+01,		4.968017999993643e+01,		4.974111016015706e+01,		4.980195208167655e+01,		4.986270600697393e+01
	},
	{
		8.228655323350632e-02,		2.467326304443437e-01,		4.107900806811361e-01,		5.744597792113439e-01,		7.377425800620854e-01,
		9.006393176406875e-01,		1.063150808276569e+00,		1.225277851687609e+00,		1.387021232374047e+00,		1.548381720942813e+00,
		1.709360075365101e+00,		1.869957042169868e+00,		2.030173357575843e+00,		2.190009748564536e+00,		2.349466933896635e+00,
		2.508545625074083e+00,		2.667246527250067e+00,		2.825570340089036e+00,		2.983517758578794e+00,		3.141089473796663e+00,
		3.298286173631598e+00,		3.455108543464097e+00,		3.611557266805674e+00,		3.767633025899582e+00,		3.923336502284436e+00,
		4.078668377322326e+00,		4.233629332692905e+00,		4.388220050854962e+00,		4.542441215476856e+00,		4.696293511837209e+00,
		4.849777627197136e+00,		5.002894251145286e+00,		5.155644075916942e+00,		5.308027796688299e+00,		5.460046111847113e+00,
		5.611699723240748e+00,		5.762989336402720e+00,		5.913915660758731e+00,		6.064479409813152e+00,		6.214681301316912e+00,
		6.364522057417691e+00,		6.514002404793273e+00,		6.663123074768915e+00,		6.811884803419506e+00,		6.960288331657312e+00,
		7.108334405306069e+00,		7.256023775162072e+00,		7.403357197043016e+00,		7.550335431825227e+00,		7.696959245469880e+00,
		7.843229409038892e+00,		7.989146698700985e+00,		8.134711895728550e+00,		8.279925786485814e+00,		8.424789162408835e+00,
		8.569302819977832e+00,		8.713467560682306e+00,		8.857284190979417e+00,		9.000753522246065e+00,		9.143876370725058e+00,
		9.286653557465810e+00,		9.429085908259921e+00,		9.571174253572005e+00,		9.712919428466146e+00,		9.854322272528274e+00,
		9.995383629784820e+00,		1.013610434861791e+01,		1.027648528167746e+01,		1.041652728579033e+01,		1.055623122186694e+01,
		1.069559795480554e+01,		1.083462835339431e+01,		1.097332329021162e+01,		1.111168364152459e+01,		1.124971028718629e+01,
		1.138740411053152e+01,		1.152476599827162e+01,		1.166179684038836e+01,		1.179849753002713e+01,		1.193486896338940e+01,
		1.207091203962501e+01,		1.220662766072392e+01,		1.234201673140799e+01,		1.247708015902266e+01,		1.261181885342869e+01,
		1.274623372689425e+01,		1.288032569398711e+01,		1.301409567146746e+01,		1.314754457818107e+01,		1.328067333495313e+01,
		1.341348286448275e+01,		1.354597409123817e+01,		1.367814794135285e+01,		1.381000534252238e+01,		1.394154722390242e+01,
		1.407277451600758e+01,		1.420368815061136e+01,		1.433428906064722e+01,		1.446457818011082e+01,		1.459455644396342e+01,
		1.472422478803646e+01,		1.485358414893755e+01,		1.498263546395756e+01,		1.511137967097921e+01,		1.523981770838690e+01,
		1.536795051497791e+01,		1.549577902987507e+01,		1.562330419244070e+01,		1.575052694219210e+01,		1.587744821871842e+01,
		1.600406896159890e+01,		1.613039011032271e+01,		1.625641260421006e+01,		1.638213738233496e+01,		1.650756538344929e+01,
		1.663269754590840e+01,		1.675753480759815e+01,		1.688207810586349e+01,		1.700632837743831e+01,		1.713028655837696e+01,
		1.725395358398705e+01,		1.737733038876384e+01,		1.750041790632586e+01,		1.762321706935217e+01,		1.774572880952086e+01,
		1.786795405744910e+01,		1.798989374263443e+01,		1.811154879339755e+01,		1.823292013682641e+01,		1.835400869872169e+01,
		1.847481540354360e+01,		1.859534117435997e+01,		1.871558693279574e+01,		1.883555359898367e+01,		1.895524209151630e+01,
		1.907465332739928e+01,		1.919378822200589e+01,		1.931264768903271e+01,		1.943123264045667e+01,		1.954954398649311e+01,
		1.966758263555516e+01,		1.978534949421422e+01,		1.990284546716159e+01,		2.002007145717120e+01,		2.013702836506348e+01,
		2.025371708967031e+01,		2.037013852780107e+01,		2.048629357420959e+01,		2.060218312156245e+01,		2.071780806040788e+01,
		2.083316927914606e+01,		2.094826766400008e+01,		2.106310409898810e+01,		2.117767946589634e+01,		2.129199464425290e+01,
		2.140605051130277e+01,		2.151984794198346e+01,		2.163338780890159e+01,		2.174667098231043e+01,		2.185969833008815e+01,
		2.197247071771698e+01,		2.208498900826309e+01,		2.219725406235739e+01,		2.230926673817696e+01,		2.242102789142738e+01,
		2.253253837532560e+01,		2.264379904058381e+01,		2.275481073539376e+01,		2.286557430541194e+01,		2.297609059374536e+01,
		2.308636044093802e+01,		2.319638468495801e+01,		2.330616416118533e+01,		2.341569970240012e+01,		2.352499213877178e+01,
		2.363404229784845e+01,		2.374285100454718e+01,		2.385141908114460e+01,		2.395974734726825e+01,		2.406783661988828e+01,
		2.417568771330983e+01,		2.428330143916586e+01,		2.439067860641043e+01,		2.449782002131256e+01,		2.460472648745048e+01,
		2.471139880570643e+01,		2.481783777426181e+01,		2.492404418859283e+01,		2.503001884146662e+01,		2.513576252293766e+01,
		2.524127602034472e+01,		2.534656011830810e+01,		2.545161559872735e+01,		2.555644324077927e+01,		2.566104382091634e+01,
		2.576541811286554e+01,		2.586956688762736e+01,		2.597349091347533e+01,		2.607719095595575e+01,		2.618066777788781e+01,
		2.628392213936397e+01,		2.638695479775068e+01,		2.648976650768936e+01,		2.659235802109767e+01,		2.669473008717108e+01,
		2.679688345238466e+01,		2.689881886049518e+01,		2.700053705254344e+01,		2.710203876685683e+01,		2.720332473905210e+01,
		2.730439570203852e+01,		2.740525238602099e+01,		2.750589551850362e+01,		2.760632582429340e+01,		2.770654402550405e+01,
		2.780655084156014e+01,		2.790634698920138e+01,		2.800593318248702e+01,		2.810531013280054e+01,		2.820447854885445e+01,
		2.830343913669526e+01,		2.840219259970863e+01,		2.850073963862463e+01,		2.859908095152325e+01,		2.869721723383989e+01,
		2.879514917837121e+01,		2.889287747528087e+01,		2.899040281210567e+01,		2.908772587376150e+01,		2.918484734254974e+01,
		2.928176789816355e+01,		2.937848821769431e+01,		2.947500897563831e+01,		2.957133084390332e+01,		2.966745449181542e+01,
		2.976338058612590e+01,		2.985910979101827e+01,		2.995464276811521e+01,		3.004998017648585e+01,		3.014512267265291e+01,
		3.024007091060007e+01,		3.033482554177932e+01,		3.042938721511846e+01,		3.052375657702858e+01,		3.061793427141166e+01,
		3.071192093966831e+01,		3.080571722070534e+01,		3.089932375094365e+01,		3.099274116432603e+01,		3.108597009232502e+01,
		3.117901116395085e+01,		3.127186500575942e+01,		3.136453224186031e+01,		3.145701349392486e+01,		3.154930938119424e+01,
		3.164142052048762e+01,		3.173334752621033e+01,		3.182509101036204e+01,		3.191665158254506e+01,		3.200802984997252e+01,
		3.209922641747676e+01,		3.219024188751754e+01,		3.228107686019049e+01,		3.237173193323537e+01,		3.246220770204449e+01,
		3.255250475967119e+01,		3.264262369683808e+01,		3.273256510194564e+01,		3.282232956108055e+01,		3.291191765802419e+01,
		3.300132997426113e+01,		3.309056708898753e+01,		3.317962957911966e+01,		3.326851801930241e+01,		3.335723298191776e+01,
		3.344577503709323e+01,		3.353414475271046e+01,		3.362234269441365e+01,		3.371036942561804e+01,		3.379822550751849e+01,
		3.388591149909788e+01,		3.397342795713563e+01,		3.406077543621628e+01,		3.414795448873782e+01,		3.423496566492022e+01,
		3.432180951281396e+01,		3.440848657830846e+01,		3.449499740514046e+01,		3.458134253490255e+01,		3.466752250705159e+01,
		3.475353785891708e+01,		3.483938912570962e+01,		3.492507684052926e+01,		3.501060153437400e+01,		3.509596373614796e+01,
		3.518116397266992e+01,		3.526620276868159e+01,		3.535108064685592e+01,		3.543579812780541e+01,		3.552035573009044e+01,
		3.560475397022751e+01,		3.568899336269751e+01,		3.577307441995399e+01,		3.585699765243128e+01,		3.594076356855280e+01,
		3.602437267473922e+01,		3.610782547541655e+01,		3.619112247302434e+01,		3.627426416802388e+01,		3.635725105890607e+01,
		3.644008364219974e+01,		3.652276241247958e+01,		3.660528786237415e+01,		3.668766048257403e+01,		3.676988076183961e+01,
		3.685194918700924e+01,		3.693386624300706e+01,		3.701563241285092e+01,		3.709724817766040e+01,		3.717871401666446e+01,
		3.726003040720946e+01,		3.734119782476698e+01,		3.742221674294148e+01,		3.750308763347824e+01,		3.758381096627090e+01,
		3.766438720936948e+01,		3.774481682898774e+01,		3.782510028951106e+01,		3.790523805350409e+01,		3.798523058171823e+01,
		3.806507833309934e+01,		3.814478176479525e+01,		3.822434133216336e+01,		3.830375748877806e+01,		3.838303068643828e+01,
		3.846216137517496e+01,		3.854115000325844e+01,		3.861999701720590e+01,		3.869870286178872e+01,		3.877726798003983e+01,
		3.885569281326107e+01,		3.893397780103047e+01,		3.901212338120947e+01,		3.909012998995026e+01,		3.916799806170297e+01,
		3.924572802922278e+01,		3.932332032357714e+01,		3.940077537415303e+01,		3.947809360866379e+01,		3.955527545315646e+01,
		3.963232133201874e+01,		3.970923166798598e+01,		3.978600688214821e+01,		3.986264739395716e+01,		3.993915362123312e+01,
		4.001552598017192e+01,		4.009176488535181e+01,		4.016787074974030e+01,		4.024384398470106e+01,		4.031968500000059e+01,
		4.039539420381517e+01,		4.047097200273755e+01,		4.054641880178362e+01,		4.062173500439919e+01,		4.069692101246663e+01,
		4.077197722631151e+01,		4.084690404470924e+01,		4.092170186489169e+01,		4.099637108255365e+01,		4.107091209185951e+01,
		4.114532528544964e+01,		4.121961105444701e+01,		4.129376978846356e+01,		4.136780187560659e+01,		4.144170770248531e+01,
		4.151548765421709e+01,		4.158914211443390e+01,		4.166267146528861e+01,		4.173607608746119e+01,		4.180935636016515e+01,
		4.188251266115377e+01,		4.195554536672611e+01,		4.202845485173351e+01,		4.210124148958553e+01,		4.217390565225620e+01,
		4.224644771029013e+01,		4.231886803280856e+01,		4.239116698751545e+01,		4.246334494070361e+01,		4.253540225726051e+01,
		4.260733930067450e+01,		4.267915643304058e+01,		4.275085401506649e+01,		4.282243240607855e+01,		4.289389196402755e+01,
		4.296523304549465e+01,		4.303645600569713e+01,		4.310756119849437e+01,		4.317854897639346e+01,		4.324941969055509e+01,
		4.332017369079923e+01,		4.339081132561085e+01,		4.346133294214565e+01,		4.353173888623567e+01,		4.360202950239497e+01,
		4.367220513382527e+01,		4.374226612242145e+01,		4.381221280877722e+01,		4.388204553219065e+01,		4.395176463066966e+01,
		4.402137044093747e+01,		4.409086329843822e+01,		4.416024353734228e+01,		4.422951149055177e+01,		4.429866748970585e+01,
		4.436771186518629e+01,		4.443664494612261e+01,		4.450546706039759e+01,		4.457417853465243e+01,		4.464277969429218e+01,
		4.471127086349094e+01,		4.477965236519704e+01,		4.484792452113838e+01,		4.491608765182754e+01,		4.498414207656697e+01,
		4.505208811345418e+01,		4.511992607938684e+01,		4.518765629006782e+01,		4.525527906001045e+01,		4.532279470254337e+01,
		4.539020352981572e+01,		4.545750585280209e+01,		4.552470198130758e+01,		4.559179222397267e+01,		4.565877688827826e+01,
		4.572565628055057e+01,		4.579243070596603e+01,		4.585910046855624e+01,		4.592566587121271e+01,		4.599212721569187e+01,
		4.605848480261971e+01,		4.612473893149670e+01,		4.619088990070263e+01,		4.625693800750116e+01,		4.632288354804473e+01,
		4.638872681737929e+01,		4.645446810944889e+01,		4.652010771710039e+01,		4.658564593208818e+01,		4.665108304507874e+01,
		4.671641934565533e+01,		4.678165512232247e+01,		4.684679066251066e+01,		4.691182625258082e+01,		4.697676217782890e+01,
		4.704159872249033e+01,		4.710633616974456e+01,		4.717097480171952e+01,		4.723551489949607e+01,		4.729995674311248e+01,
		4.736430061156878e+01,		4.742854678283121e+01,		4.749269553383648e+01,		4.755674714049642e+01,		4.762070187770192e+01,
		4.768456001932753e+01,		4.774832183823574e+01,		4.781198760628109e+01,		4.787555759431462e+01,		4.793903207218802e+01,
		4.800241130875787e+01,		4.806569557188986e+01,		4.812888512846295e+01,		4.819198024437357e+01,		4.825498118453978e+01,
		4.831788821290533e+01,		4.838070159244382e+01,		4.844342158516286e+01,		4.850604845210803e+01,		4.856858245336706e+01,
		4.863102384807370e+01,		4.869337289441193e+01,		4.875562984961991e+01,		4.881779496999384e+01,		4.887986851089214e+01,
		4.894185072673924e+01,		4.900374187102960e+01,		4.906554219633153e+01,		4.912725195429126e+01,		4.918887139563666e+01,
		4.925040077018117e+01,		4.931184032682764e+01,		4.937319031357224e+01,		4.943445097750808e+01,		4.949562256482921e+01,
		4.955670532083429e+01,		4.961769948993039e+01,		4.967860531563674e+01,		4.973942304058840e+01,		4.980015290654009e+01
	},
	{
		8.211845053124936e-02,		2.462289302158237e-01,		4.099520429448421e-01,		5.732886640610059e-01,		7.362396478419098e-01,
		8.988058291010796e-01,		1.060988024711401e+00,		1.222787035054062e+00,		1.384203645395995e+00,		1.545238627198691e+00,
		1.705892739361143e+00,		1.866166729399568e+00,		2.026061334566463e+00,		2.185577282911429e+00,		2.344715294286134e+00,
		2.503476081295677e+00,		2.661860350198531e+00,		2.819868801757169e+00,		2.977502132041401e+00,		3.134761033186346e+00,
		3.291646194106949e+00,		3.448158301170821e+00,		3.604298038831155e+00,		3.760066090221395e+00,		3.915463137713255e+00,
		4.070489863439695e+00,		4.225146949784287e+00,		4.379435079838456e+00,		4.533354937828004e+00,		4.686907209510221e+00,
		4.840092582542897e+00,		4.992911746826482e+00,		5.145365394820601e+00,		5.297454221836067e+00,		5.449178926303523e+00,
		5.600540210019756e+00,		5.751538778372784e+00,		5.902175340546632e+00,		6.052450609706808e+00,		6.202365303167397e+00,
		6.351920142540653e+00,		6.501115853869943e+00,		6.649953167746876e+00,		6.798432819413408e+00,		6.946555548849675e+00,
		7.094322100848323e+00,		7.241733225075981e+00,		7.388789676122594e+00,		7.535492213539286e+00,		7.681841601865328e+00,
		7.827838610644849e+00,		7.973484014433852e+00,		8.118778592798090e+00,		8.263723130302369e+00,		8.408318416491689e+00,
		8.552565245864859e+00,		8.696464417840923e+00,		8.840016736718910e+00,		8.983223011631345e+00,		9.126084056491894e+00,
		9.268600689937580e+00,		9.410773735265904e+00,		9.552604020367287e+00,		9.694092377653130e+00,		9.835239643979829e+00,
		9.976046660569100e+00,		1.011651427292487e+01,		1.025664333074703e+01,		1.039643468784236e+01,		1.053588920203281e+01,
		1.067500773506153e+01,		1.081379115249666e+01,		1.095224032363337e+01,		1.109035612139411e+01,		1.122813942222754e+01,
		1.136559110600602e+01,		1.150271205592217e+01,		1.163950315838445e+01,		1.177596530291197e+01,		1.191209938202874e+01,
		1.204790629115752e+01,		1.218338692851333e+01,		1.231854219499674e+01,		1.245337299408727e+01,		1.258788023173667e+01,
		1.272206481626259e+01,		1.285592765824237e+01,		1.298946967040733e+01,		1.312269176753750e+01,		1.325559486635695e+01,
		1.338817988542970e+01,		1.352044774505645e+01,		1.365239936717205e+01,		1.378403567524382e+01,		1.391535759417085e+01,
		1.404636605018426e+01,		1.417706197074843e+01,		1.430744628446338e+01,		1.443751992096831e+01,		1.456728381084617e+01,
		1.469673888552957e+01,		1.482588607720786e+01,		1.495472631873549e+01,		1.508326054354168e+01,		1.521148968554137e+01,
		1.533941467904757e+01,		1.546703645868503e+01,		1.559435595930528e+01,		1.572137411590312e+01,		1.584809186353446e+01,
		1.597451013723560e+01,		1.610062987194393e+01,		1.622645200242006e+01,		1.635197746317139e+01,		1.647720718837710e+01,
		1.660214211181460e+01,		1.672678316678744e+01,		1.685113128605458e+01,		1.697518740176116e+01,		1.709895244537074e+01,
		1.722242734759881e+01,		1.734561303834790e+01,		1.746851044664396e+01,		1.759112050057427e+01,		1.771344412722661e+01,
		1.783548225262988e+01,		1.795723580169610e+01,		1.807870569816381e+01,		1.819989286454267e+01,		1.832079822205955e+01,
		1.844142269060584e+01,		1.856176718868619e+01,		1.868183263336834e+01,		1.880161994023442e+01,		1.892113002333343e+01,
		1.904036379513497e+01,		1.915932216648417e+01,		1.927800604655792e+01,		1.939641634282220e+01,		1.951455396099065e+01,
		1.963241980498429e+01,		1.975001477689235e+01,		1.986733977693431e+01,		1.998439570342296e+01,		2.010118345272860e+01,
		2.021770391924432e+01,		2.033395799535230e+01,		2.044994657139122e+01,		2.056567053562460e+01,		2.068113077421023e+01,
		2.079632817117051e+01,		2.091126360836387e+01,		2.102593796545697e+01,		2.114035211989804e+01,		2.125450694689095e+01,
		2.136840331937029e+01,		2.148204210797737e+01,		2.159542418103687e+01,		2.170855040453464e+01,		2.182142164209609e+01,
		2.193403875496552e+01,		2.204640260198620e+01,		2.215851403958123e+01,		2.227037392173523e+01,		2.238198309997665e+01,
		2.249334242336097e+01,		2.260445273845450e+01,		2.271531488931895e+01,		2.282592971749658e+01,		2.293629806199625e+01,
		2.304642075927984e+01,		2.315629864324953e+01,		2.326593254523562e+01,		2.337532329398494e+01,		2.348447171564993e+01,
		2.359337863377828e+01,		2.370204486930310e+01,		2.381047124053367e+01,		2.391865856314681e+01,		2.402660765017866e+01,
		2.413431931201706e+01,		2.424179435639442e+01,		2.434903358838107e+01,		2.445603781037910e+01,		2.456280782211671e+01,
		2.466934442064292e+01,		2.477564840032283e+01,		2.488172055283329e+01,		2.498756166715892e+01,		2.509317252958867e+01,
		2.519855392371267e+01,		2.530370663041953e+01,		2.540863142789402e+01,		2.551332909161513e+01,		2.561780039435441e+01,
		2.572204610617481e+01,		2.582606699442971e+01,		2.592986382376241e+01,		2.603343735610582e+01,		2.613678835068264e+01,
		2.623991756400561e+01,		2.634282574987829e+01,		2.644551365939597e+01,		2.654798204094695e+01,		2.665023164021403e+01,
		2.675226320017635e+01,		2.685407746111136e+01,		2.695567516059718e+01,		2.705705703351511e+01,		2.715822381205239e+01,
		2.725917622570523e+01,		2.735991500128200e+01,		2.746044086290669e+01,		2.756075453202256e+01,		2.766085672739596e+01,
		2.776074816512038e+01,		2.786042955862069e+01,		2.795990161865758e+01,		2.805916505333206e+01,		2.815822056809030e+01,
		2.825706886572859e+01,		2.835571064639830e+01,		2.845414660761126e+01,		2.855237744424504e+01,		2.865040384854860e+01,
		2.874822651014786e+01,		2.884584611605156e+01,		2.894326335065724e+01,		2.904047889575721e+01,		2.913749343054488e+01,
		2.923430763162087e+01,		2.933092217299964e+01,		2.942733772611586e+01,		2.952355495983111e+01,		2.961957454044061e+01,
		2.971539713167999e+01,		2.981102339473228e+01,		2.990645398823487e+01,		3.000168956828665e+01,		3.009673078845511e+01,
		3.019157829978365e+01,		3.028623275079890e+01,		3.038069478751810e+01,		3.047496505345661e+01,		3.056904418963538e+01,
		3.066293283458860e+01,		3.075663162437133e+01,		3.085014119256722e+01,		3.094346217029630e+01,		3.103659518622274e+01,
		3.112954086656280e+01,		3.122229983509267e+01,		3.131487271315648e+01,		3.140726011967426e+01,		3.149946267115003e+01,
		3.159148098167982e+01,		3.168331566295985e+01,		3.177496732429460e+01,		3.186643657260504e+01,		3.195772401243682e+01,
		3.204883024596847e+01,		3.213975587301973e+01,		3.223050149105975e+01,		3.232106769521545e+01,		3.241145507827979e+01,
		3.250166423072014e+01,		3.259169574068666e+01,		3.268155019402058e+01,		3.277122817426270e+01,		3.286073026266166e+01,
		3.295005703818249e+01,		3.303920907751486e+01,		3.312818695508164e+01,		3.321699124304722e+01,		3.330562251132602e+01,
		3.339408132759092e+01,		3.348236825728159e+01,		3.357048386361311e+01,		3.365842870758424e+01,		3.374620334798595e+01,
		3.383380834140984e+01,		3.392124424225656e+01,		3.400851160274424e+01,		3.409561097291694e+01,		3.418254290065305e+01,
		3.426930793167364e+01,		3.435590660955101e+01,		3.444233947571693e+01,		3.452860706947114e+01,		3.461470992798965e+01,
		3.470064858633314e+01,		3.478642357745533e+01,		3.487203543221126e+01,		3.495748467936568e+01,		3.504277184560134e+01,
		3.512789745552731e+01,		3.521286203168719e+01,		3.529766609456753e+01,		3.538231016260591e+01,		3.546679475219928e+01,
		3.555112037771219e+01,		3.563528755148490e+01,		3.571929678384169e+01,		3.580314858309892e+01,		3.588684345557329e+01,
		3.597038190558978e+01,		3.605376443548999e+01,		3.613699154564004e+01,		3.622006373443875e+01,		3.630298149832562e+01,
		3.638574533178891e+01,		3.646835572737359e+01,		3.655081317568937e+01,		3.663311816541860e+01,		3.671527118332427e+01,
		3.679727271425789e+01,		3.687912324116739e+01,		3.696082324510493e+01,		3.704237320523487e+01,		3.712377359884146e+01,
		3.720502490133669e+01,		3.728612758626812e+01,		3.736708212532644e+01,		3.744788898835345e+01,		3.752854864334950e+01,
		3.760906155648141e+01,		3.768942819208988e+01,		3.776964901269726e+01,		3.784972447901512e+01,		3.792965504995177e+01,
		3.800944118261985e+01,		3.808908333234385e+01,		3.816858195266752e+01,		3.824793749536150e+01,		3.832715041043058e+01,
		3.840622114612122e+01,		3.848515014892891e+01,		3.856393786360550e+01,		3.864258473316659e+01,		3.872109119889877e+01,
		3.879945770036699e+01,		3.887768467542168e+01,		3.895577256020610e+01,		3.903372178916351e+01,		3.911153279504427e+01,
		3.918920600891308e+01,		3.926674186015600e+01,		3.934414077648766e+01,		3.942140318395823e+01,		3.949852950696049e+01,
		3.957552016823681e+01,		3.965237558888622e+01,		3.972909618837122e+01,		3.980568238452490e+01,		3.988213459355759e+01,
		3.995845323006403e+01,		4.003463870702996e+01,		4.011069143583909e+01,		4.018661182627985e+01,		4.026240028655212e+01,
		4.033805722327403e+01,		4.041358304148866e+01,		4.048897814467067e+01,		4.056424293473304e+01,		4.063937781203366e+01,
		4.071438317538190e+01,		4.078925942204523e+01,		4.086400694775578e+01,		4.093862614671691e+01,		4.101311741160954e+01,
		4.108748113359877e+01,		4.116171770234030e+01,		4.123582750598687e+01,		4.130981093119451e+01,		4.138366836312907e+01,
		4.145740018547254e+01,		4.153100678042924e+01,		4.160448852873226e+01,		4.167784580964960e+01,		4.175107900099047e+01,
		4.182418847911149e+01,		4.189717461892285e+01,		4.197003779389450e+01,		4.204277837606226e+01,		4.211539673603391e+01,
		4.218789324299530e+01,		4.226026826471639e+01,		4.233252216755726e+01,		4.240465531647419e+01,		4.247666807502554e+01,
		4.254856080537769e+01,		4.262033386831114e+01,		4.269198762322615e+01,		4.276352242814890e+01,		4.283493863973711e+01,
		4.290623661328595e+01,		4.297741670273392e+01,		4.304847926066848e+01,		4.311942463833194e+01,		4.319025318562709e+01,
		4.326096525112290e+01,		4.333156118206038e+01,		4.340204132435795e+01,		4.347240602261726e+01,		4.354265562012878e+01,
		4.361279045887731e+01,		4.368281087954765e+01,		4.375271722152996e+01,		4.382250982292549e+01,		4.389218902055186e+01,
		4.396175514994869e+01,		4.403120854538292e+01,		4.410054953985426e+01,		4.416977846510065e+01,		4.423889565160355e+01,
		4.430790142859329e+01,		4.437679612405439e+01,		4.444558006473097e+01,		4.451425357613186e+01,		4.458281698253595e+01,
		4.465127060699744e+01,		4.471961477135096e+01,		4.478784979621686e+01,		4.485597600100626e+01,		4.492399370392629e+01,
		4.499190322198523e+01,		4.505970487099736e+01,		4.512739896558845e+01,		4.519498581920044e+01,		4.526246574409664e+01,
		4.532983905136671e+01,		4.539710605093164e+01,		4.546426705154874e+01,		4.553132236081654e+01,		4.559827228517975e+01,
		4.566511712993410e+01,		4.573185719923136e+01,		4.579849279608394e+01,		4.586502422237000e+01,		4.593145177883813e+01,
		4.599777576511210e+01,		4.606399647969573e+01,		4.613011421997761e+01,		4.619612928223579e+01,		4.626204196164253e+01,
		4.632785255226899e+01,		4.639356134708989e+01,		4.645916863798811e+01,		4.652467471575942e+01,		4.659007987011698e+01,
		4.665538438969598e+01,		4.672058856205822e+01,		4.678569267369667e+01,		4.685069701003987e+01,		4.691560185545660e+01,
		4.698040749326028e+01,		4.704511420571342e+01,		4.710972227403218e+01,		4.717423197839061e+01,		4.723864359792525e+01,
		4.730295741073938e+01,		4.736717369390749e+01,		4.743129272347954e+01,		4.749531477448532e+01,		4.755924012093882e+01,
		4.762306903584249e+01,		4.768680179119143e+01,		4.775043865797775e+01,		4.781397990619480e+01,		4.787742580484129e+01,
		4.794077662192564e+01,		4.800403262446998e+01,		4.806719407851450e+01,		4.813026124912142e+01,		4.819323440037925e+01,
		4.825611379540684e+01,		4.831889969635742e+01,		4.838159236442274e+01,		4.844419205983716e+01,		4.850669904188152e+01,
		4.856911356888739e+01,		4.863143589824079e+01,		4.869366628638642e+01,		4.875580498883154e+01,		4.881785226014984e+01,
		4.887980835398541e+01,		4.894167352305679e+01,		4.900344801916057e+01,		4.906513209317557e+01,		4.912672599506650e+01,
		4.918822997388791e+01,		4.924964427778793e+01,		4.931096915401213e+01,		4.937220484890734e+01,		4.943335160792531e+01,
		4.949440967562660e+01,		4.955537929568423e+01,		4.961626071088747e+01,		4.967705416314549e+01,		4.973775989349105e+01
	},
	{
		8.195103349728729e-02,		2.457272845042207e-01,		4.091174233867361e-01,		5.721223255173667e-01,		7.347428453768344e-01,
		8.969798181358443e-01,		1.058834061160323e+00,		1.220306375443174e+00,		1.381397546965495e+00,		1.542108347990081e+00,
		1.702439538289946e+00,		1.862391866314455e+00,		2.021966070295590e+00,		2.181162879296770e+00,		2.339983014206525e+00,
		2.498427188679282e+00,		2.656496110025402e+00,		2.814190480052540e+00,		2.971510995860314e+00,		3.128458350590227e+00,
		3.285033234132654e+00,		3.441236333792708e+00,		3.597068334916685e+00,		3.752529921480735e+00,		3.907621776643374e+00,
		4.062344583263348e+00,		4.216699024384346e+00,		4.370685783687978e+00,		4.524305545916389e+00,		4.677558997265858e+00,
		4.830446825752614e+00,		4.982969721552144e+00,		5.135128377313150e+00,		5.286923488447304e+00,		5.438355753395907e+00,
		5.589425873874498e+00,		5.740134555096456e+00,		5.890482505976554e+00,		6.040470439315423e+00,		6.190099071965845e+00,
		6.339369124981740e+00,		6.488281323750703e+00,		6.636836398110882e+00,		6.785035082453017e+00,		6.932878115808354e+00,
		7.080366241923192e+00,		7.227500209320719e+00,		7.374280771350849e+00,		7.520708686228667e+00,		7.666784717062131e+00,
		7.812509631869600e+00,		7.957884203587759e+00,		8.102909210070523e+00,		8.247585434079371e+00,		8.391913663265715e+00,
		8.535894690145691e+00,		8.679529312067899e+00,		8.822818331174503e+00,		8.965762554356134e+00,		9.108362793200987e+00,
		9.250619863938530e+00,		9.392534587378151e+00,		9.534107788843155e+00,		9.675340298100428e+00,		9.816232949286047e+00,
		9.956786580827274e+00,		1.009700203536107e+01,		1.023688015964953e+01,		1.037642180449250e+01,		1.051562782463755e+01,
		1.065449907868767e+01,		1.079303642900682e+01,		1.093124074162358e+01,		1.106911288613324e+01,		1.120665373559826e+01,
		1.134386416644760e+01,		1.148074505837489e+01,		1.161729729423567e+01,		1.175352175994392e+01,		1.188941934436795e+01,
		1.202499093922587e+01,		1.216023743898071e+01,		1.229515974073539e+01,		1.242975874412764e+01,		1.256403535122488e+01,
		1.269799046641948e+01,		1.283162499632400e+01,		1.296493984966710e+01,		1.309793593718969e+01,		1.323061417154175e+01,
		1.336297546717971e+01,		1.349502074026459e+01,		1.362675090856084e+01,		1.375816689133613e+01,		1.388926960926191e+01,
		1.402005998431505e+01,		1.415053893968036e+01,		1.428070739965428e+01,		1.441056628954963e+01,		1.454011653560144e+01,
		1.466935906487409e+01,		1.479829480516953e+01,		1.492692468493679e+01,		1.505524963318284e+01,		1.518327057938460e+01,
		1.531098845340237e+01,		1.543840418539458e+01,		1.556551870573386e+01,		1.569233294492453e+01,		1.581884783352144e+01,
		1.594506430205015e+01,		1.607098328092867e+01,		1.619660570039042e+01,		1.632193249040870e+01,		1.644696458062260e+01,
		1.657170290026425e+01,		1.669614837808752e+01,		1.682030194229818e+01,		1.694416452048538e+01,		1.706773703955464e+01,
		1.719102042566216e+01,		1.731401560415056e+01,		1.743672349948604e+01,		1.755914503519688e+01,		1.768128113381333e+01,
		1.780313271680882e+01,		1.792470070454263e+01,		1.804598601620382e+01,		1.816698956975645e+01,		1.828771228188619e+01,
		1.840815506794828e+01,		1.852831884191662e+01,		1.864820451633429e+01,		1.876781300226521e+01,		1.888714520924716e+01,
		1.900620204524592e+01,		1.912498441661075e+01,		1.924349322803089e+01,		1.936172938249345e+01,		1.947969378124230e+01,
		1.959738732373818e+01,		1.971481090761994e+01,		1.983196542866688e+01,		1.994885178076223e+01,		2.006547085585759e+01,
		2.018182354393861e+01,		2.029791073299157e+01,		2.041373330897103e+01,		2.052929215576857e+01,		2.064458815518238e+01,
		2.075962218688792e+01,		2.087439512840953e+01,		2.098890785509301e+01,		2.110316124007899e+01,		2.121715615427739e+01,
		2.133089346634262e+01,		2.144437404264978e+01,		2.155759874727157e+01,		2.167056844195619e+01,		2.178328398610595e+01,
		2.189574623675675e+01,		2.200795604855832e+01,		2.211991427375526e+01,		2.223162176216879e+01,		2.234307936117928e+01,
		2.245428791570957e+01,		2.256524826820878e+01,		2.267596125863715e+01,		2.278642772445121e+01,		2.289664850058992e+01,
		2.300662441946122e+01,		2.311635631092938e+01,		2.322584500230291e+01,		2.333509131832303e+01,		2.344409608115289e+01,
		2.355286011036712e+01,		2.366138422294224e+01,		2.376966923324737e+01,		2.387771595303566e+01,		2.398552519143610e+01,
		2.409309775494600e+01,		2.420043444742386e+01,		2.430753607008271e+01,		2.441440342148411e+01,		2.452103729753236e+01,
		2.462743849146933e+01,		2.473360779386979e+01,		2.483954599263690e+01,		2.494525387299849e+01,		2.505073221750341e+01,
		2.515598180601855e+01,		2.526100341572602e+01,		2.536579782112092e+01,		2.547036579400930e+01,		2.557470810350663e+01,
		2.567882551603646e+01,		2.578271879532960e+01,		2.588638870242349e+01,		2.598983599566193e+01,		2.609306143069518e+01,
		2.619606576048027e+01,		2.629884973528168e+01,		2.640141410267230e+01,		2.650375960753462e+01,		2.660588699206222e+01,
		2.670779699576157e+01,		2.680949035545397e+01,		2.691096780527792e+01,		2.701223007669151e+01,		2.711327789847519e+01,
		2.721411199673479e+01,		2.731473309490463e+01,		2.741514191375095e+01,		2.751533917137551e+01,		2.761532558321938e+01,
		2.771510186206698e+01,		2.781466871805019e+01,		2.791402685865276e+01,		2.801317698871492e+01,		2.811211981043794e+01,
		2.821085602338917e+01,		2.830938632450695e+01,		2.840771140810590e+01,		2.850583196588220e+01,		2.860374868691909e+01,
		2.870146225769252e+01,		2.879897336207686e+01,		2.889628268135085e+01,		2.899339089420356e+01,		2.909029867674056e+01,
		2.918700670249011e+01,		2.928351564240965e+01,		2.937982616489208e+01,		2.947593893577254e+01,		2.957185461833491e+01,
		2.966757387331867e+01,		2.976309735892576e+01,		2.985842573082746e+01,		2.995355964217157e+01,		3.004849974358931e+01,
		3.014324668320272e+01,		3.023780110663181e+01,		3.033216365700194e+01,		3.042633497495122e+01,		3.052031569863799e+01,
		3.061410646374835e+01,		3.070770790350376e+01,		3.080112064866871e+01,		3.089434532755839e+01,		3.098738256604650e+01,
		3.108023298757300e+01,		3.117289721315200e+01,		3.126537586137966e+01,		3.135766954844215e+01,		3.144977888812358e+01,
		3.154170449181404e+01,		3.163344696851766e+01,		3.172500692486069e+01,		3.181638496509961e+01,		3.190758169112928e+01,
		3.199859770249114e+01,		3.208943359638132e+01,		3.218008996765896e+01,		3.227056740885442e+01,		3.236086651017747e+01,
		3.245098785952570e+01,		3.254093204249268e+01,		3.263069964237638e+01,		3.272029124018741e+01,		3.280970741465740e+01,
		3.289894874224736e+01,		3.298801579715596e+01,		3.307690915132799e+01,		3.316562937446267e+01,		3.325417703402199e+01,
		3.334255269523917e+01,		3.343075692112700e+01,		3.351879027248619e+01,		3.360665330791380e+01,		3.369434658381157e+01,
		3.378187065439440e+01,		3.386922607169858e+01,		3.395641338559025e+01,		3.404343314377376e+01,		3.413028589180006e+01,
		3.421697217307494e+01,		3.430349252886754e+01,		3.438984749831852e+01,		3.447603761844853e+01,		3.456206342416647e+01,
		3.464792544827775e+01,		3.473362422149270e+01,		3.481916027243477e+01,		3.490453412764884e+01,		3.498974631160942e+01,
		3.507479734672900e+01,		3.515968775336620e+01,		3.524441804983399e+01,		3.532898875240794e+01,		3.541340037533435e+01,
		3.549765343083845e+01,		3.558174842913251e+01,		3.566568587842404e+01,		3.574946628492381e+01,		3.583309015285404e+01,
		3.591655798445642e+01,		3.599987028000013e+01,		3.608302753778996e+01,		3.616603025417430e+01,		3.624887892355307e+01,
		3.633157403838577e+01,		3.641411608919938e+01,		3.649650556459635e+01,		3.657874295126243e+01,		3.666082873397458e+01,
		3.674276339560893e+01,		3.682454741714842e+01,		3.690618127769077e+01,		3.698766545445630e+01,		3.706900042279555e+01,
		3.715018665619711e+01,		3.723122462629539e+01,		3.731211480287818e+01,		3.739285765389451e+01,		3.747345364546209e+01,
		3.755390324187508e+01,		3.763420690561166e+01,		3.771436509734153e+01,		3.779437827593352e+01,		3.787424689846314e+01,
		3.795397142021999e+01,		3.803355229471526e+01,		3.811298997368926e+01,		3.819228490711865e+01,		3.827143754322404e+01,
		3.835044832847722e+01,		3.842931770760854e+01,		3.850804612361421e+01,		3.858663401776363e+01,		3.866508182960657e+01,
		3.874338999698047e+01,		3.882155895601765e+01,		3.889958914115241e+01,		3.897748098512827e+01,		3.905523491900507e+01,
		3.913285137216604e+01,		3.921033077232492e+01,		3.928767354553295e+01,		3.936488011618595e+01,		3.944195090703123e+01,
		3.951888633917468e+01,		3.959568683208761e+01,		3.967235280361361e+01,		3.974888466997563e+01,		3.982528284578264e+01,
		3.990154774403653e+01,		3.997767977613899e+01,		4.005367935189815e+01,		4.012954687953544e+01,		4.020528276569225e+01,
		4.028088741543665e+01,		4.035636123227006e+01,		4.043170461813388e+01,		4.050691797341615e+01,		4.058200169695805e+01,
		4.065695618606060e+01,		4.073178183649102e+01,		4.080647904248940e+01,		4.088104819677508e+01,		4.095548969055318e+01,
		4.102980391352095e+01,		4.110399125387426e+01,		4.117805209831390e+01,		4.125198683205199e+01,		4.132579583881828e+01,
		4.139947950086644e+01,		4.147303819898036e+01,		4.154647231248034e+01,		4.161978221922939e+01,		4.169296829563939e+01,
		4.176603091667724e+01,		4.183897045587098e+01,		4.191178728531600e+01,		4.198448177568108e+01,		4.205705429621443e+01,
		4.212950521474971e+01,		4.220183489771217e+01,		4.227404371012455e+01,		4.234613201561299e+01,		4.241810017641311e+01,
		4.248994855337577e+01,		4.256167750597312e+01,		4.263328739230432e+01,		4.270477856910149e+01,		4.277615139173540e+01,
		4.284740621422144e+01,		4.291854338922521e+01,		4.298956326806830e+01,		4.306046620073418e+01,		4.313125253587357e+01,
		4.320192262081041e+01,		4.327247680154733e+01,		4.334291542277133e+01,		4.341323882785937e+01,		4.348344735888391e+01,
		4.355354135661852e+01,		4.362352116054332e+01,		4.369338710885053e+01,		4.376313953844996e+01,		4.383277878497444e+01,
		4.390230518278523e+01,		4.397171906497745e+01,		4.404102076338543e+01,		4.411021060858815e+01,		4.417928892991446e+01,
		4.424825605544849e+01,		4.431711231203486e+01,		4.438585802528401e+01,		4.445449351957745e+01,		4.452301911807288e+01,
		4.459143514270949e+01,		4.465974191421310e+01,		4.472793975210131e+01,		4.479602897468865e+01,		4.486400989909168e+01,
		4.493188284123403e+01,		4.499964811585151e+01,		4.506730603649717e+01,		4.513485691554628e+01,		4.520230106420134e+01,
		4.526963879249705e+01,		4.533687040930526e+01,		4.540399622233996e+01,		4.547101653816213e+01,		4.553793166218459e+01,
		4.560474189867697e+01,		4.567144755077054e+01,		4.573804892046292e+01,		4.580454630862302e+01,		4.587094001499577e+01,
		4.593723033820693e+01,		4.600341757576768e+01,		4.606950202407953e+01,		4.613548397843892e+01,		4.620136373304192e+01,
		4.626714158098887e+01,		4.633281781428904e+01,		4.639839272386526e+01,		4.646386659955850e+01,		4.652923973013242e+01,
		4.659451240327799e+01,		4.665968490561796e+01,		4.672475752271146e+01,		4.678973053905842e+01,		4.685460423810407e+01,
		4.691937890224340e+01,		4.698405481282565e+01,		4.704863225015865e+01,		4.711311149351322e+01,		4.717749282112766e+01,
		4.724177651021197e+01,		4.730596283695231e+01,		4.737005207651521e+01,		4.743404450305195e+01,		4.749794038970288e+01,
		4.756174000860155e+01,		4.762544363087908e+01,		4.768905152666835e+01,		4.775256396510817e+01,		4.781598121434762e+01,
		4.787930354154992e+01,		4.794253121289692e+01,		4.800566449359307e+01,		4.806870364786950e+01,		4.813164893898820e+01,
		4.819450062924610e+01,		4.825725897997906e+01,		4.831992425156599e+01,		4.838249670343286e+01,		4.844497659405670e+01,
		4.850736418096956e+01,		4.856965972076251e+01,		4.863186346908962e+01,		4.869397568067190e+01,		4.875599660930116e+01,
		4.881792650784395e+01,		4.887976562824550e+01,		4.894151422153347e+01,		4.900317253782194e+01,		4.906474082631508e+01,
		4.912621933531116e+01,		4.918760831220622e+01,		4.924890800349785e+01,		4.931011865478906e+01,		4.937124051079192e+01,
		4.943227381533134e+01,		4.949321881134880e+01,		4.955407574090606e+01,		4.961484484518876e+01,		4.967552636451023e+01
	},
	{
		8.178429794345543e-02,		2.452276807509049e-01,		4.082862010974588e-01,		5.709607343409613e-01,		7.332521351188267e-01,
		8.951612389108624e-01,		1.056688863526568e+00,		1.217835810519946e+00,		1.378602866534711e+00,		1.538990804582706e+00,
		1.699000385258183e+00,		1.858632357890539e+00,		2.017887461637970e+00,		2.176766426524431e+00,		2.335269974422186e+00,
		2.493398819982150e+00,		2.651153671514147e+00,		2.808535231819126e+00,		2.965544198975283e+00,		3.122181267080015e+00,
		3.278447126949487e+00,		3.434342466777608e+00,		3.589867972756075e+00,		3.745024329657140e+00,		3.899812221380643e+00,
		4.054232331466869e+00,		4.208285343576627e+00,		4.361971941940016e+00,		4.515292811775195e+00,		4.668248639678476e+00,
		4.820840113987002e+00,		4.973067925115211e+00,		5.124932765866268e+00,		5.276435331719581e+00,		5.427576321095492e+00,
		5.578356435598192e+00,		5.728776380237844e+00,		5.878836863632928e+00,		6.028538598193686e+00,		6.177882300287618e+00,
		6.326868690387868e+00,		6.475498493205332e+00,		6.623772437805293e+00,		6.771691257709384e+00,		6.919255690983559e+00,
		7.066466480312843e+00,		7.213324373063547e+00,		7.359830121333545e+00,		7.505984481991320e+00,		7.651788216704366e+00,
		7.797242091957520e+00,		7.942346879061760e+00,		8.087103354154118e+00,		8.231512298189058e+00,		8.375574496921983e+00,
		8.519290740885241e+00,		8.662661825357102e+00,		8.805688550324229e+00,		8.948371720437914e+00,		9.090712144964611e+00,
		9.232710637731108e+00,		9.374368017064681e+00,		9.515685105728624e+00,		9.656662730853450e+00,		9.797301723864134e+00,
		9.937602920403688e+00,		1.007756716025329e+01,		1.021719528724943e+01,		1.035648814919807e+01,		1.049544659778641e+01,
		1.063407148849214e+01,		1.077236368049071e+01,		1.091032403656073e+01,		1.104795342298757e+01,		1.118525270946566e+01,
		1.132222276899939e+01,		1.145886447780295e+01,		1.159517871519924e+01,		1.173116636351805e+01,		1.186682830799356e+01,
		1.200216543666142e+01,		1.213717864025551e+01,		1.227186881210445e+01,		1.240623684802810e+01,		1.254028364623406e+01,
		1.267401010721433e+01,		1.280741713364221e+01,		1.294050563026960e+01,		1.307327650382466e+01,		1.320573066291009e+01,
		1.333786901790195e+01,		1.346969248084914e+01,		1.360120196537374e+01,		1.373239838657204e+01,		1.386328266091653e+01,
		1.399385570615878e+01,		1.412411844123331e+01,		1.425407178616255e+01,		1.438371666196274e+01,		1.451305399055109e+01,
		1.464208469465404e+01,		1.477080969771667e+01,		1.489922992381336e+01,		1.502734629755973e+01,		1.515515974402582e+01,
		1.528267118865050e+01,		1.540988155715733e+01,		1.553679177547163e+01,		1.566340276963893e+01,		1.578971546574484e+01,
		1.591573078983619e+01,		1.604144966784358e+01,		1.616687302550539e+01,		1.629200178829306e+01,		1.641683688133782e+01,
		1.654137922935886e+01,		1.666562975659277e+01,		1.678958938672453e+01,		1.691325904281976e+01,		1.703663964725842e+01,
		1.715973212166989e+01,		1.728253738686942e+01,		1.740505636279592e+01,		1.752728996845120e+01,		1.764923912184044e+01,
		1.777090473991408e+01,		1.789228773851109e+01,		1.801338903230344e+01,		1.813420953474196e+01,		1.825475015800351e+01,
		1.837501181293937e+01,		1.849499540902498e+01,		1.861470185431088e+01,		1.873413205537492e+01,		1.885328691727567e+01,
		1.897216734350712e+01,		1.909077423595446e+01,		1.920910849485117e+01,		1.932717101873718e+01,		1.944496270441822e+01,
		1.956248444692634e+01,		1.967973713948144e+01,		1.979672167345403e+01,		1.991343893832900e+01,		2.002988982167045e+01,
		2.014607520908765e+01,		2.026199598420189e+01,		2.037765302861450e+01,		2.049304722187582e+01,		2.060817944145504e+01,
		2.072305056271119e+01,		2.083766145886496e+01,		2.095201300097144e+01,		2.106610605789391e+01,		2.117994149627828e+01,
		2.129352018052871e+01,		2.140684297278386e+01,		2.151991073289405e+01,		2.163272431839938e+01,		2.174528458450843e+01,
		2.185759238407796e+01,		2.196964856759327e+01,		2.208145398314943e+01,		2.219300947643315e+01,		2.230431589070544e+01,
		2.241537406678502e+01,		2.252618484303236e+01,		2.263674905533449e+01,		2.274706753709039e+01,		2.285714111919716e+01,
		2.296697063003672e+01,		2.307655689546319e+01,		2.318590073879089e+01,		2.329500298078298e+01,		2.340386443964057e+01,
		2.351248593099252e+01,		2.362086826788582e+01,		2.372901226077634e+01,		2.383691871752032e+01,		2.394458844336633e+01,
		2.405202224094762e+01,		2.415922091027513e+01,		2.426618524873091e+01,		2.437291605106198e+01,		2.447941410937474e+01,
		2.458568021312977e+01,		2.469171514913709e+01,		2.479751970155180e+01,		2.490309465187029e+01,		2.500844077892659e+01,
		2.511355885888946e+01,		2.521844966525952e+01,		2.532311396886699e+01,		2.542755253786978e+01,		2.553176613775175e+01,
		2.563575553132158e+01,		2.573952147871175e+01,		2.584306473737802e+01,		2.594638606209909e+01,		2.604948620497670e+01,
		2.615236591543590e+01,		2.625502594022577e+01,		2.635746702342022e+01,		2.645968990641929e+01,		2.656169532795059e+01,
		2.666348402407097e+01,		2.676505672816861e+01,		2.686641417096511e+01,		2.696755708051809e+01,		2.706848618222379e+01,
		2.716920219882004e+01,		2.726970585038944e+01,		2.736999785436263e+01,		2.747007892552190e+01,		2.756994977600499e+01,
		2.766961111530895e+01,		2.776906365029436e+01,		2.786830808518964e+01,		2.796734512159549e+01,		2.806617545848962e+01,
		2.816479979223158e+01,		2.826321881656770e+01,		2.836143322263628e+01,		2.845944369897283e+01,		2.855725093151560e+01,
		2.865485560361100e+01,		2.875225839601949e+01,		2.884945998692123e+01,		2.894646105192221e+01,		2.904326226406022e+01,
		2.913986429381105e+01,		2.923626780909486e+01,		2.933247347528253e+01,		2.942848195520219e+01,		2.952429390914590e+01,
		2.961990999487626e+01,		2.971533086763329e+01,		2.981055718014128e+01,		2.990558958261581e+01,		3.000042872277075e+01,
		3.009507524582542e+01,		3.018952979451186e+01,		3.028379300908199e+01,		3.037786552731509e+01,		3.047174798452512e+01,
		3.056544101356824e+01,		3.065894524485033e+01,		3.075226130633462e+01,		3.084538982354929e+01,		3.093833141959521e+01,
		3.103108671515366e+01,		3.112365632849413e+01,		3.121604087548219e+01,		3.130824096958734e+01,		3.140025722189092e+01,
		3.149209024109411e+01,		3.158374063352589e+01,		3.167520900315106e+01,		3.176649595157833e+01,		3.185760207806839e+01,
		3.194852797954197e+01,		3.203927425058806e+01,		3.212984148347207e+01,		3.222023026814389e+01,		3.231044119224625e+01,
		3.240047484112281e+01,		3.249033179782651e+01,		3.258001264312772e+01,		3.266951795552257e+01,		3.275884831124117e+01,
		3.284800428425599e+01,		3.293698644629004e+01,		3.302579536682524e+01,		3.311443161311075e+01,		3.320289575017120e+01,
		3.329118834081513e+01,		3.337930994564316e+01,		3.346726112305648e+01,		3.355504242926505e+01,		3.364265441829594e+01,
		3.373009764200172e+01,		3.381737265006870e+01,		3.390447999002532e+01,		3.399142020725031e+01,		3.407819384498127e+01,
		3.416480144432266e+01,		3.425124354425429e+01,		3.433752068163952e+01,		3.442363339123357e+01,		3.450958220569179e+01,
		3.459536765557787e+01,		3.468099026937210e+01,		3.476645057347962e+01,		3.485174909223865e+01,		3.493688634792863e+01,
		3.502186286077846e+01,		3.510667914897469e+01,		3.519133572866964e+01,		3.527583311398956e+01,		3.536017181704278e+01,
		3.544435234792780e+01,		3.552837521474137e+01,		3.561224092358663e+01,		3.569594997858109e+01,		3.577950288186474e+01,
		3.586290013360804e+01,		3.594614223201991e+01,		3.602922967335576e+01,		3.611216295192531e+01,		3.619494256010083e+01,
		3.627756898832475e+01,		3.636004272511767e+01,		3.644236425708633e+01,		3.652453406893132e+01,		3.660655264345503e+01,
		3.668842046156937e+01,		3.677013800230363e+01,		3.685170574281221e+01,		3.693312415838239e+01,		3.701439372244198e+01,
		3.709551490656711e+01,		3.717648818048981e+01,		3.725731401210577e+01,		3.733799286748180e+01,		3.741852521086361e+01,
		3.749891150468324e+01,		3.757915220956667e+01,		3.765924778434137e+01,		3.773919868604371e+01,		3.781900536992653e+01,
		3.789866828946654e+01,		3.797818789637171e+01,		3.805756464058873e+01,		3.813679897031035e+01,		3.821589133198272e+01,
		3.829484217031273e+01,		3.837365192827524e+01,		3.845232104712046e+01,		3.853084996638104e+01,		3.860923912387943e+01,
		3.868748895573498e+01,		3.876559989637111e+01,		3.884357237852246e+01,		3.892140683324200e+01,		3.899910368990813e+01,
		3.907666337623164e+01,		3.915408631826286e+01,		3.923137294039857e+01,		3.930852366538906e+01,		3.938553891434500e+01,
		3.946241910674436e+01,		3.953916466043938e+01,		3.961577599166337e+01,		3.969225351503757e+01,		3.976859764357795e+01,
		3.984480878870206e+01,		3.992088736023570e+01,		3.999683376641970e+01,		4.007264841391662e+01,		4.014833170781748e+01,
		4.022388405164833e+01,		4.029930584737691e+01,		4.037459749541926e+01,		4.044975939464628e+01,		4.052479194239033e+01,
		4.059969553445167e+01,		4.067447056510500e+01,		4.074911742710596e+01,		4.082363651169746e+01,		4.089802820861624e+01,
		4.097229290609913e+01,		4.104643099088953e+01,		4.112044284824365e+01,		4.119432886193686e+01,		4.126808941426999e+01,
		4.134172488607559e+01,		4.141523565672410e+01,		4.148862210413017e+01,		4.156188460475869e+01,		4.163502353363110e+01,
		4.170803926433143e+01,		4.178093216901242e+01,		4.185370261840163e+01,		4.192635098180740e+01,		4.199887762712502e+01,
		4.207128292084263e+01,		4.214356722804720e+01,		4.221573091243056e+01,		4.228777433629523e+01,		4.235969786056036e+01,
		4.243150184476766e+01,		4.250318664708714e+01,		4.257475262432306e+01,		4.264620013191964e+01,		4.271752952396690e+01,
		4.278874115320632e+01,		4.285983537103673e+01,		4.293081252751984e+01,		4.300167297138602e+01,		4.307241705003993e+01,
		4.314304510956617e+01,		4.321355749473486e+01,		4.328395454900721e+01,		4.335423661454116e+01,		4.342440403219680e+01,
		4.349445714154196e+01,		4.356439628085773e+01,		4.363422178714377e+01,		4.370393399612394e+01,		4.377353324225157e+01,
		4.384301985871497e+01,		4.391239417744269e+01,		4.398165652910896e+01,		4.405080724313897e+01,		4.411984664771420e+01,
		4.418877506977758e+01,		4.425759283503897e+01,		4.432630026798017e+01,		4.439489769186028e+01,		4.446338542872080e+01,
		4.453176379939083e+01,		4.460003312349220e+01,		4.466819371944466e+01,		4.473624590447085e+01,		4.480418999460143e+01,
		4.487202630468023e+01,		4.493975514836909e+01,		4.500737683815305e+01,		4.507489168534529e+01,		4.514230000009199e+01,
		4.520960209137739e+01,		4.527679826702873e+01,		4.534388883372102e+01,		4.541087409698203e+01,		4.547775436119711e+01,
		4.554452992961407e+01,		4.561120110434796e+01,		4.567776818638581e+01,		4.574423147559150e+01,		4.581059127071049e+01,
		4.587684786937452e+01,		4.594300156810634e+01,		4.600905266232440e+01,		4.607500144634751e+01,		4.614084821339952e+01,
		4.620659325561392e+01,		4.627223686403846e+01,		4.633777932863978e+01,		4.640322093830781e+01,		4.646856198086063e+01,
		4.653380274304867e+01,		4.659894351055944e+01,		4.666398456802192e+01,		4.672892619901102e+01,		4.679376868605215e+01,
		4.685851231062550e+01,		4.692315735317048e+01,		4.698770409309026e+01,		4.705215280875590e+01,		4.711650377751094e+01,
		4.718075727567554e+01,		4.724491357855095e+01,		4.730897296042367e+01,		4.737293569456980e+01,		4.743680205325936e+01,
		4.750057230776036e+01,		4.756424672834317e+01,		4.762782558428469e+01,		4.769130914387249e+01,		4.775469767440892e+01,
		4.781799144221548e+01,		4.788119071263668e+01,		4.794429575004432e+01,		4.800730681784155e+01,		4.807022417846691e+01,
		4.813304809339835e+01,		4.819577882315738e+01,		4.825841662731304e+01,		4.832096176448584e+01,		4.838341449235182e+01,
		4.844577506764649e+01,		4.850804374616876e+01,		4.857022078278492e+01,		4.863230643143251e+01,		4.869430094512426e+01,
		4.875620457595188e+01,		4.881801757509008e+01,		4.887974019280020e+01,		4.894137267843425e+01,		4.900291528043862e+01,
		4.906436824635784e+01,		4.912573182283844e+01,		4.918700625563267e+01,		4.924819178960218e+01,		4.930928866872196e+01,
		4.937029713608375e+01,		4.943121743389996e+01,		4.949204980350729e+01,		4.955279448537035e+01,		4.961345171908535e+01
	},
	{
		8.161823971564242e-02,		2.447301064995146e-01,		4.074583553381717e-01,		5.698038615311219e-01,		7.317674798269391e-01,
		8.933500459673778e-01,		1.054552378156986e+00,		1.215375278461203e+00,		1.375819534135786e+00,		1.535885918890340e+00,
		1.695575194088558e+00,		1.854888109887739e+00,		2.013825406319997e+00,		2.172387814317528e+00,		2.330576056684174e+00,
		2.488390849015464e+00,		2.645832900569223e+00,		2.802902915088748e+00,		2.959601591580515e+00,		3.115929625048245e+00,
		3.271887707185158e+00,		3.427476527026134e+00,		3.582696771561449e+00,		3.737549126313681e+00,		3.892034275879369e+00,
		4.046152904436877e+00,		4.199905696221927e+00,		4.353293335972187e+00,		4.506316509342225e+00,		4.658975903290160e+00,
		4.811272206437210e+00,		4.963206109401347e+00,		5.114778305106233e+00,		5.265989489066508e+00,		5.416840359650543e+00,
		5.567331618321640e+00,		5.717463969858726e+00,		5.867238122557461e+00,		6.016654788412692e+00,		6.165714683283135e+00,
		6.314418527039155e+00,		6.462767043694456e+00,		6.610760961522464e+00,		6.758401013158174e+00,		6.905687935686201e+00,
		7.052622470715729e+00,		7.199205364443037e+00,		7.345437367702250e+00,		7.491319236004956e+00,		7.636851729569281e+00,
		7.782035613338998e+00,		7.926871656993212e+00,		8.071360634947206e+00,		8.215503326344891e+00,		8.359300515043406e+00,
		8.502752989590299e+00,		8.645861543193771e+00,		8.788626973686400e+00,		8.931050083482774e+00,		9.073131679531404e+00,
		9.214872573261312e+00,		9.356273580523682e+00,		9.497335521528896e+00,		9.638059220779262e+00,		9.778445506997832e+00,
		9.918495213053527e+00,		1.005820917588292e+01,		1.019758823640894e+01,		1.033663323945674e+01,		1.047534503366697e+01,
		1.061372447140684e+01,		1.075177240867891e+01,		1.088948970502816e+01,		1.102687722344733e+01,		1.116393583028072e+01,
		1.130066639512686e+01,		1.143706979073990e+01,		1.157314689293023e+01,		1.170889858046418e+01,		1.184432573496318e+01,
		1.197942924080246e+01,		1.211420998500932e+01,		1.224866885716126e+01,		1.238280674928401e+01,		1.251662455574954e+01,
		1.265012317317426e+01,		1.278330350031742e+01,		1.291616643797984e+01,		1.304871288890309e+01,		1.318094375766912e+01,
		1.331285995060055e+01,		1.344446237566155e+01,		1.357575194235950e+01,		1.370672956164737e+01,		1.383739614582704e+01,
		1.396775260845353e+01,		1.409779986424005e+01,		1.422753882896425e+01,		1.435697041937536e+01,		1.448609555310255e+01,
		1.461491514856434e+01,		1.474343012487917e+01,		1.487164140177723e+01,		1.499954989951344e+01,		1.512715653878175e+01,
		1.525446224063061e+01,		1.538146792637983e+01,		1.550817451753868e+01,		1.563458293572537e+01,		1.576069410258775e+01,
		1.588650893972555e+01,		1.601202836861374e+01,		1.613725331052744e+01,		1.626218468646812e+01,		1.638682341709115e+01,
		1.651117042263477e+01,		1.663522662285038e+01,		1.675899293693427e+01,		1.688247028346065e+01,		1.700565958031613e+01,
		1.712856174463543e+01,		1.725117769273860e+01,		1.737350834006950e+01,		1.749555460113559e+01,		1.761731738944919e+01,
		1.773879761746994e+01,		1.785999619654856e+01,		1.798091403687208e+01,		1.810155204741016e+01,		1.822191113586282e+01,
		1.834199220860942e+01,		1.846179617065881e+01,		1.858132392560089e+01,		1.870057637555922e+01,		1.881955442114490e+01,
		1.893825896141177e+01,		1.905669089381259e+01,		1.917485111415655e+01,		1.929274051656786e+01,		1.941035999344547e+01,
		1.952771043542394e+01,		1.964479273133543e+01,		1.976160776817271e+01,		1.987815643105330e+01,		1.999443960318471e+01,
		2.011045816583052e+01,		2.022621299827776e+01,		2.034170497780506e+01,		2.045693497965194e+01,		2.057190387698896e+01,
		2.068661254088892e+01,		2.080106184029892e+01,		2.091525264201341e+01,		2.102918581064807e+01,		2.114286220861463e+01,
		2.125628269609656e+01,		2.136944813102557e+01,		2.148235936905904e+01,		2.159501726355813e+01,		2.170742266556681e+01,
		2.181957642379170e+01,		2.193147938458254e+01,		2.204313239191357e+01,		2.215453628736555e+01,		2.226569191010863e+01,
		2.237660009688570e+01,		2.248726168199680e+01,		2.259767749728376e+01,		2.270784837211597e+01,		2.281777513337646e+01,
		2.292745860544872e+01,		2.303689961020426e+01,		2.314609896699062e+01,		2.325505749262005e+01,		2.336377600135881e+01,
		2.347225530491692e+01,		2.358049621243863e+01,		2.368849953049327e+01,		2.379626606306676e+01,		2.390379661155358e+01,
		2.401109197474923e+01,		2.411815294884326e+01,		2.422498032741263e+01,		2.433157490141579e+01,		2.443793745918692e+01,
		2.454406878643087e+01,		2.464996966621837e+01,		2.475564087898179e+01,		2.486108320251121e+01,		2.496629741195091e+01,
		2.507128427979639e+01,		2.517604457589151e+01,		2.528057906742632e+01,		2.538488851893498e+01,		2.548897369229417e+01,
		2.559283534672186e+01,		2.569647423877631e+01,		2.579989112235554e+01,		2.590308674869696e+01,		2.600606186637745e+01,
		2.610881722131366e+01,		2.621135355676261e+01,		2.631367161332258e+01,		2.641577212893429e+01,		2.651765583888237e+01,
		2.661932347579695e+01,		2.672077576965579e+01,		2.682201344778628e+01,		2.692303723486802e+01,		2.702384785293537e+01,
		2.712444602138045e+01,		2.722483245695616e+01,		2.732500787377957e+01,		2.742497298333535e+01,		2.752472849447956e+01,
		2.762427511344352e+01,		2.772361354383796e+01,		2.782274448665724e+01,		2.792166864028383e+01,		2.802038670049293e+01,
		2.811889936045722e+01,		2.821720731075186e+01,		2.831531123935953e+01,		2.841321183167569e+01,		2.851090977051399e+01,
		2.860840573611172e+01,		2.870570040613557e+01,		2.880279445568731e+01,		2.889968855730974e+01,		2.899638338099272e+01,
		2.909287959417932e+01,		2.918917786177205e+01,		2.928527884613922e+01,		2.938118320712141e+01,		2.947689160203801e+01,
		2.957240468569394e+01,		2.966772311038630e+01,		2.976284752591128e+01,		2.985777857957106e+01,		2.995251691618078e+01,
		3.004706317807567e+01,		3.014141800511819e+01,		3.023558203470516e+01,		3.032955590177522e+01,		3.042334023881606e+01,
		3.051693567587190e+01,		3.061034284055090e+01,		3.070356235803279e+01,		3.079659485107639e+01,		3.088944094002730e+01,
		3.098210124282550e+01,		3.107457637501323e+01,		3.116686694974263e+01,		3.125897357778365e+01,		3.135089686753187e+01,
		3.144263742501642e+01,		3.153419585390791e+01,		3.162557275552635e+01,		3.171676872884924e+01,		3.180778437051952e+01,
		3.189862027485363e+01,		3.198927703384965e+01,		3.207975523719531e+01,		3.217005547227615e+01,		3.226017832418374e+01,
		3.235012437572370e+01,		3.243989420742399e+01,		3.252948839754303e+01,		3.261890752207797e+01,		3.270815215477285e+01,
		3.279722286712686e+01,		3.288612022840259e+01,		3.297484480563423e+01,		3.306339716363584e+01,		3.315177786500966e+01,
		3.323998747015429e+01,		3.332802653727300e+01,		3.341589562238199e+01,		3.350359527931864e+01,		3.359112605974980e+01,
		3.367848851318005e+01,		3.376568318695994e+01,		3.385271062629426e+01,		3.393957137425035e+01,		3.402626597176621e+01,
		3.411279495765888e+01,		3.419915886863264e+01,		3.428535823928716e+01,		3.437139360212583e+01,		3.445726548756392e+01,
		3.454297442393672e+01,		3.462852093750784e+01,		3.471390555247731e+01,		3.479912879098978e+01,		3.488419117314260e+01,
		3.496909321699409e+01,		3.505383543857149e+01,		3.513841835187925e+01,		3.522284246890698e+01,		3.530710829963755e+01,
		3.539121635205527e+01,		3.547516713215375e+01,		3.555896114394408e+01,		3.564259888946272e+01,		3.572608086877956e+01,
		3.580940758000590e+01,		3.589257951930233e+01,		3.597559718088674e+01,		3.605846105704212e+01,		3.614117163812467e+01,
		3.622372941257134e+01,		3.630613486690804e+01,		3.638838848575714e+01,		3.647049075184553e+01,		3.655244214601223e+01,
		3.663424314721628e+01,		3.671589423254439e+01,		3.679739587721867e+01,		3.687874855460435e+01,		3.695995273621744e+01,
		3.704100889173236e+01,		3.712191748898961e+01,		3.720267899400329e+01,		3.728329387096871e+01,		3.736376258226999e+01,
		3.744408558848749e+01,		3.752426334840541e+01,		3.760429631901919e+01,		3.768418495554296e+01,		3.776392971141702e+01,
		3.784353103831521e+01,		3.792298938615227e+01,		3.800230520309119e+01,		3.808147893555060e+01,		3.816051102821196e+01,
		3.823940192402692e+01,		3.831815206422450e+01,		3.839676188831837e+01,		3.847523183411398e+01,		3.855356233771578e+01,
		3.863175383353436e+01,		3.870980675429352e+01,		3.878772153103742e+01,		3.886549859313757e+01,		3.894313836829991e+01,
		3.902064128257186e+01,		3.909800776034918e+01,		3.917523822438310e+01,		3.925233309578710e+01,		3.932929279404382e+01,
		3.940611773701207e+01,		3.948280834093359e+01,		3.955936502043982e+01,		3.963578818855876e+01,		3.971207825672181e+01,
		3.978823563477037e+01,		3.986426073096268e+01,		3.994015395198042e+01,		4.001591570293542e+01,		4.009154638737633e+01,
		4.016704640729517e+01,		4.024241616313393e+01,		4.031765605379116e+01,		4.039276647662845e+01,		4.046774782747703e+01,
		4.054260050064414e+01,		4.061732488891953e+01,		4.069192138358191e+01,		4.076639037440533e+01,		4.084073224966554e+01,
		4.091494739614635e+01,		4.098903619914601e+01,		4.106299904248338e+01,		4.113683630850434e+01,		4.121054837808793e+01,
		4.128413563065261e+01,		4.135759844416252e+01,		4.143093719513348e+01,		4.150415225863929e+01,		4.157724400831782e+01,
		4.165021281637701e+01,		4.172305905360103e+01,		4.179578308935628e+01,		4.186838529159742e+01,		4.194086602687337e+01,
		4.201322566033320e+01,		4.208546455573218e+01,		4.215758307543763e+01,		4.222958158043479e+01,		4.230146043033277e+01,
		4.237321998337028e+01,		4.244486059642152e+01,		4.251638262500195e+01,		4.258778642327410e+01,		4.265907234405318e+01,
		4.273024073881293e+01,		4.280129195769126e+01,		4.287222634949595e+01,		4.294304426171021e+01,		4.301374604049843e+01,
		4.308433203071162e+01,		4.315480257589311e+01,		4.322515801828408e+01,		4.329539869882899e+01,		4.336552495718122e+01,
		4.343553713170841e+01,		4.350543555949800e+01,		4.357522057636263e+01,		4.364489251684559e+01,		4.371445171422611e+01,
		4.378389850052479e+01,		4.385323320650900e+01,		4.392245616169797e+01,		4.399156769436833e+01,		4.406056813155925e+01,
		4.412945779907771e+01,		4.419823702150369e+01,		4.426690612219548e+01,		4.433546542329468e+01,		4.440391524573151e+01,
		4.447225590922989e+01,		4.454048773231250e+01,		4.460861103230596e+01,		4.467662612534581e+01,		4.474453332638163e+01,
		4.481233294918199e+01,		4.488002530633949e+01,		4.494761070927574e+01,		4.501508946824629e+01,		4.508246189234566e+01,
		4.514972828951203e+01,		4.521688896653239e+01,		4.528394422904728e+01,		4.535089438155562e+01,		4.541773972741966e+01,
		4.548448056886956e+01,		4.555111720700843e+01,		4.561764994181696e+01,		4.568407907215821e+01,		4.575040489578222e+01,
		4.581662770933089e+01,		4.588274780834256e+01,		4.594876548725667e+01,		4.601468103941843e+01,		4.608049475708339e+01,
		4.614620693142215e+01,		4.621181785252482e+01,		4.627732780940565e+01,		4.634273709000752e+01,		4.640804598120656e+01,
		4.647325476881648e+01,		4.653836373759326e+01,		4.660337317123943e+01,		4.666828335240860e+01,		4.673309456270989e+01,
		4.679780708271229e+01,		4.686242119194906e+01,		4.692693716892214e+01,		4.699135529110635e+01,		4.705567583495395e+01,
		4.711989907589870e+01,		4.718402528836032e+01,		4.724805474574869e+01,		4.731198772046810e+01,		4.737582448392150e+01,
		4.743956530651472e+01,		4.750321045766059e+01,		4.756676020578322e+01,		4.763021481832212e+01,		4.769357456173628e+01,
		4.775683970150838e+01,		4.782001050214885e+01,		4.788308722719994e+01,		4.794607013923978e+01,		4.800895949988647e+01,
		4.807175556980218e+01,		4.813445860869685e+01,		4.819706887533265e+01,		4.825958662752756e+01,		4.832201212215956e+01,
		4.838434561517047e+01,		4.844658736156986e+01,		4.850873761543908e+01,		4.857079662993502e+01,		4.863276465729398e+01,
		4.869464194883573e+01,		4.875642875496703e+01,		4.881812532518571e+01,		4.887973190808435e+01,		4.894124875135412e+01,
		4.900267610178848e+01,		4.906401420528708e+01,		4.912526330685928e+01,		4.918642365062814e+01,		4.924749547983383e+01,
		4.930847903683757e+01,		4.936937456312518e+01,		4.943018229931069e+01,		4.949090248514013e+01,		4.955153535949503e+01
	},
	{
		8.145285469344453e-02,		2.442345493949147e-01,		4.066338655388183e-01,		5.686516783235395e-01,		7.302888425641629e-01,
		8.915461942181430e-01,		1.052424551837478e+00,		1.212924717950322e+00,		1.373047480374852e+00,		1.532793613468109e+00,
		1.692163879312395e+00,		1.851159028841744e+00,		2.009779802910864e+00,		2.168026933308857e+00,		2.325901143719944e+00,
		2.483403150633346e+00,		2.640533664204362e+00,		2.797293389068634e+00,		2.953683025111525e+00,		3.109703268194419e+00,
		3.265354810839743e+00,		3.420638342876398e+00,		3.575554552047255e+00,		3.730104124580298e+00,		3.884287745724932e+00,
		4.038106100254948e+00,		4.191559872939548e+00,		4.344649748983782e+00,		4.497376414439771e+00,		4.649740556589905e+00,
		4.801742864303320e+00,		4.953384028366774e+00,		5.104664741791087e+00,		5.255585700094247e+00,		5.406147601562206e+00,
		5.556351147488424e+00,		5.706197042393092e+00,		5.855685994223053e+00,		6.004818714533231e+00,		6.153595918650519e+00,
		6.302018325820956e+00,		6.450086659340976e+00,		6.597801646673532e+00,		6.745164019549846e+00,		6.892174514057499e+00,
		7.038833870715572e+00,		7.185142834537484e+00,		7.331102155082179e+00,		7.476712586494325e+00,		7.621974887533998e+00,
		7.766889821596602e+00,		7.911458156723395e+00,		8.055680665603235e+00,		8.199558125566101e+00,		8.343091318568749e+00,
		8.486281031173052e+00,		8.629128054517471e+00,		8.771633184282058e+00,		8.913797220647385e+00,		9.055620968247855e+00,
		9.197105236119688e+00,		9.338250837644027e+00,		9.479058590485444e+00,		9.619529316526197e+00,		9.759663841796559e+00,
		9.899462996401518e+00,		1.003892761444414e+01,		1.017805853394583e+01,		1.031685659676381e+01,		1.045532264850610e+01,
		1.059345753844401e+01,		1.073126211942274e+01,		1.086873724776994e+01,		1.100588378320275e+01,		1.114270258873321e+01,
		1.127919453057250e+01,		1.141536047803402e+01,		1.155120130343552e+01,		1.168671788200048e+01,		1.182191109175881e+01,
		1.195678181344709e+01,		1.209133093040848e+01,		1.222555932849230e+01,		1.235946789595365e+01,		1.249305752335289e+01,
		1.262632910345538e+01,		1.275928353113128e+01,		1.289192170325580e+01,		1.302424451860979e+01,		1.315625287778076e+01,
		1.328794768306462e+01,		1.341932983836784e+01,		1.355040024911055e+01,		1.368115982213020e+01,		1.381160946558622e+01,
		1.394175008886541e+01,		1.407158260248844e+01,		1.420110791801715e+01,		1.433032694796304e+01,		1.445924060569672e+01,
		1.458784980535851e+01,		1.471615546177020e+01,		1.484415849034791e+01,		1.497185980701622e+01,		1.509926032812352e+01,
		1.522636097035850e+01,		1.535316265066809e+01,		1.547966628617648e+01,		1.560587279410563e+01,		1.573178309169693e+01,
		1.585739809613427e+01,		1.598271872446846e+01,		1.610774589354287e+01,		1.623248051992059e+01,		1.635692351981277e+01,
		1.648107580900842e+01,		1.660493830280553e+01,		1.672851191594348e+01,		1.685179756253695e+01,		1.697479615601099e+01,
		1.709750860903759e+01,		1.721993583347346e+01,		1.734207874029928e+01,		1.746393823956009e+01,		1.758551524030720e+01,
		1.770681065054123e+01,		1.782782537715656e+01,		1.794856032588705e+01,		1.806901640125292e+01,		1.818919450650912e+01,
		1.830909554359470e+01,		1.842872041308362e+01,		1.854807001413663e+01,		1.866714524445450e+01,		1.878594700023237e+01,
		1.890447617611522e+01,		1.902273366515474e+01,		1.914072035876700e+01,		1.925843714669164e+01,		1.937588491695186e+01,
		1.949306455581574e+01,		1.960997694775853e+01,		1.972662297542605e+01,		1.984300351959919e+01,		1.995911945915933e+01,
		2.007497167105495e+01,		2.019056103026915e+01,		2.030588840978815e+01,		2.042095468057078e+01,		2.053576071151906e+01,
		2.065030736944944e+01,		2.076459551906530e+01,		2.087862602293011e+01,		2.099239974144156e+01,		2.110591753280666e+01,
		2.121918025301753e+01,		2.133218875582817e+01,		2.144494389273208e+01,		2.155744651294045e+01,		2.166969746336153e+01,
		2.178169758858046e+01,		2.189344773084002e+01,		2.200494873002209e+01,		2.211620142362981e+01,		2.222720664677061e+01,
		2.233796523213973e+01,		2.244847801000455e+01,		2.255874580818966e+01,		2.266876945206242e+01,		2.277854976451930e+01,
		2.288808756597285e+01,		2.299738367433916e+01,		2.310643890502610e+01,		2.321525407092209e+01,		2.332382998238528e+01,
		2.343216744723361e+01,		2.354026727073519e+01,		2.364813025559923e+01,		2.375575720196763e+01,		2.386314890740698e+01,
		2.397030616690105e+01,		2.407722977284385e+01,		2.418392051503310e+01,		2.429037918066423e+01,		2.439660655432471e+01,
		2.450260341798900e+01,		2.460837055101380e+01,		2.471390873013375e+01,		2.481921872945761e+01,		2.492430132046473e+01,
		2.502915727200197e+01,		2.513378735028105e+01,		2.523819231887617e+01,		2.534237293872204e+01,		2.544632996811228e+01,
		2.555006416269816e+01,		2.565357627548757e+01,		2.575686705684452e+01,		2.585993725448874e+01,		2.596278761349573e+01,
		2.606541887629704e+01,		2.616783178268085e+01,		2.627002706979285e+01,		2.637200547213741e+01,		2.647376772157894e+01,
		2.657531454734361e+01,		2.667664667602122e+01,		2.677776483156741e+01,		2.687866973530602e+01,		2.697936210593173e+01,
		2.707984265951293e+01,		2.718011210949480e+01,		2.728017116670251e+01,		2.738002053934481e+01,		2.747966093301758e+01,
		2.757909305070785e+01,		2.767831759279774e+01,		2.777733525706870e+01,		2.787614673870598e+01,		2.797475273030313e+01,
		2.807315392186680e+01,		2.817135100082159e+01,		2.826934465201510e+01,		2.836713555772313e+01,		2.846472439765502e+01,
		2.856211184895909e+01,		2.865929858622830e+01,		2.875628528150591e+01,		2.885307260429139e+01,		2.894966122154635e+01,
		2.904605179770066e+01,		2.914224499465864e+01,		2.923824147180533e+01,		2.933404188601299e+01,		2.942964689164744e+01,
		2.952505714057485e+01,		2.962027328216829e+01,		2.971529596331457e+01,		2.981012582842110e+01,		2.990476351942283e+01,
		2.999920967578925e+01,		3.009346493453150e+01,		3.018752993020955e+01,		3.028140529493941e+01,		3.037509165840047e+01,
		3.046858964784277e+01,		3.056189988809455e+01,		3.065502300156962e+01,		3.074795960827495e+01,		3.084071032581822e+01,
		3.093327576941547e+01,		3.102565655189876e+01,		3.111785328372394e+01,		3.120986657297833e+01,		3.130169702538861e+01,
		3.139334524432859e+01,		3.148481183082713e+01,		3.157609738357603e+01,		3.166720249893794e+01,		3.175812777095441e+01,
		3.184887379135380e+01,		3.193944114955931e+01,		3.202983043269710e+01,		3.212004222560422e+01,		3.221007711083686e+01,
		3.229993566867829e+01,		3.238961847714709e+01,		3.247912611200525e+01,		3.256845914676630e+01,		3.265761815270351e+01,
		3.274660369885798e+01,		3.283541635204695e+01,		3.292405667687188e+01,		3.301252523572666e+01,		3.310082258880586e+01,
		3.318894929411289e+01,		3.327690590746821e+01,		3.336469298251759e+01,		3.345231107074022e+01,		3.353976072145704e+01,
		3.362704248183881e+01,		3.371415689691447e+01,		3.380110450957925e+01,		3.388788586060282e+01,		3.397450148863764e+01,
		3.406095193022696e+01,		3.414723771981317e+01,		3.423335938974585e+01,		3.431931747028999e+01,		3.440511248963413e+01,
		3.449074497389852e+01,		3.457621544714320e+01,		3.466152443137620e+01,		3.474667244656162e+01,		3.483166001062765e+01,
		3.491648763947479e+01,		3.500115584698383e+01,		3.508566514502392e+01,		3.517001604346058e+01,		3.525420905016377e+01,
		3.533824467101592e+01,		3.542212340991986e+01,		3.550584576880680e+01,		3.558941224764429e+01,		3.567282334444423e+01,
		3.575607955527065e+01,		3.583918137424769e+01,		3.592212929356756e+01,		3.600492380349821e+01,		3.608756539239133e+01,
		3.617005454669008e+01,		3.625239175093695e+01,		3.633457748778150e+01,		3.641661223798810e+01,		3.649849648044371e+01,
		3.658023069216553e+01,		3.666181534830879e+01,		3.674325092217429e+01,		3.682453788521615e+01,		3.690567670704934e+01,
		3.698666785545737e+01,		3.706751179639978e+01,		3.714820899401973e+01,		3.722875991065153e+01,		3.730916500682815e+01,
		3.738942474128863e+01,		3.746953957098562e+01,		3.754950995109274e+01,		3.762933633501203e+01,		3.770901917438133e+01,
		3.778855891908155e+01,		3.786795601724410e+01,		3.794721091525818e+01,		3.802632405777794e+01,		3.810529588772992e+01,
		3.818412684632007e+01,		3.826281737304117e+01,		3.834136790567982e+01,		3.841977888032363e+01,		3.849805073136843e+01,
		3.857618389152529e+01,		3.865417879182757e+01,		3.873203586163802e+01,		3.880975552865581e+01,		3.888733821892345e+01,
		3.896478435683377e+01,		3.904209436513693e+01,		3.911926866494727e+01,		3.919630767575020e+01,		3.927321181540909e+01,
		3.934998150017209e+01,		3.942661714467887e+01,		3.950311916196753e+01,		3.957948796348129e+01,		3.965572395907515e+01,
		3.973182755702272e+01,		3.980779916402280e+01,		3.988363918520607e+01,		3.995934802414173e+01,		4.003492608284402e+01,
		4.011037376177887e+01,		4.018569145987043e+01,		4.026087957450752e+01,		4.033593850155024e+01,		4.041086863533632e+01,
		4.048567036868762e+01,		4.056034409291655e+01,		4.063489019783240e+01,		4.070930907174778e+01,		4.078360110148487e+01,
		4.085776667238181e+01,		4.093180616829893e+01,		4.100571997162503e+01,		4.107950846328360e+01,		4.115317202273899e+01,
		4.122671102800273e+01,		4.130012585563947e+01,		4.137341688077333e+01,		4.144658447709379e+01,		4.151962901686197e+01,
		4.159255087091655e+01,		4.166535040867980e+01,		4.173802799816369e+01,		4.181058400597572e+01,		4.188301879732502e+01,
		4.195533273602815e+01,		4.202752618451508e+01,		4.209959950383503e+01,		4.217155305366234e+01,		4.224338719230229e+01,
		4.231510227669693e+01,		4.238669866243079e+01,		4.245817670373670e+01,		4.252953675350152e+01,		4.260077916327177e+01,
		4.267190428325941e+01,		4.274291246234739e+01,		4.281380404809545e+01,		4.288457938674548e+01,		4.295523882322735e+01,
		4.302578270116431e+01,		4.309621136287861e+01,		4.316652514939695e+01,		4.323672440045604e+01,		4.330680945450799e+01,
		4.337678064872585e+01,		4.344663831900888e+01,		4.351638279998809e+01,		4.358601442503161e+01,		4.365553352624985e+01,
		4.372494043450108e+01,		4.379423547939655e+01,		4.386341898930590e+01,		4.393249129136224e+01,		4.400145271146764e+01,
		4.407030357429807e+01,		4.413904420330881e+01,		4.420767492073946e+01,		4.427619604761917e+01,		4.434460790377177e+01,
		4.441291080782082e+01,		4.448110507719468e+01,		4.454919102813167e+01,		4.461716897568495e+01,		4.468503923372761e+01,
		4.475280211495779e+01,		4.482045793090332e+01,		4.488800699192701e+01,		4.495544960723138e+01,		4.502278608486364e+01,
		4.509001673172052e+01,		4.515714185355314e+01,		4.522416175497195e+01,		4.529107673945138e+01,		4.535788710933473e+01,
		4.542459316583902e+01,		4.549119520905959e+01,		4.555769353797493e+01,		4.562408845045140e+01,		4.569038024324786e+01,
		4.575656921202044e+01,		4.582265565132705e+01,		4.588863985463221e+01,		4.595452211431147e+01,		4.602030272165610e+01,
		4.608598196687762e+01,		4.615156013911246e+01,		4.621703752642630e+01,		4.628241441581881e+01,		4.634769109322789e+01,
		4.641286784353434e+01,		4.647794495056630e+01,		4.654292269710353e+01,		4.660780136488199e+01,		4.667258123459814e+01,
		4.673726258591335e+01,		4.680184569745825e+01,		4.686633084683707e+01,		4.693071831063198e+01,		4.699500836440728e+01,
		4.705920128271385e+01,		4.712329733909330e+01,		4.718729680608218e+01,		4.725119995521634e+01,		4.731500705703498e+01,
		4.737871838108496e+01,		4.744233419592491e+01,		4.750585476912938e+01,		4.756928036729299e+01,		4.763261125603447e+01,
		4.769584770000089e+01,		4.775898996287164e+01,		4.782203830736253e+01,		4.788499299522974e+01,		4.794785428727403e+01,
		4.801062244334453e+01,		4.807329772234287e+01,		4.813588038222713e+01,		4.819837068001574e+01,		4.826076887179148e+01,
		4.832307521270531e+01,		4.838528995698037e+01,		4.844741335791582e+01,		4.850944566789066e+01,		4.857138713836771e+01,
		4.863323801989724e+01,		4.869499856212104e+01,		4.875666901377596e+01,		4.881824962269782e+01,		4.887974063582527e+01,
		4.894114229920332e+01,		4.900245485798722e+01,		4.906367855644618e+01,		4.912481363796697e+01,		4.918586034505770e+01,
		4.924681891935143e+01,		4.930768960160984e+01,		4.936847263172685e+01,		4.942916824873226e+01,		4.948977669079533e+01
	},
	{
		8.128813878982469e-02,		2.437409971821700e-01,		4.058127112964083e-01,		5.675041561878548e-01,		7.288161866943256e-01,
		8.897496389436208e-01,		1.050305331788498e+00,		1.210484068172030e+00,		1.370286636426125e+00,		1.529713811505878e+00,
		1.688766356162315e+00,		1.847445022055992e+00,		2.005750550813831e+00,		2.163683675031449e+00,		2.321245119223198e+00,
		2.478435600721997e+00,		2.635255830531016e+00,		2.791706514129153e+00,		2.947788352232170e+00,		3.103502041511342e+00,
		3.258848275271321e+00,		3.413827744088934e+00,		3.568441136414514e+00,		3.722689139137332e+00,		3.876572438116642e+00,
		4.030091718679787e+00,		4.183247666088760e+00,		4.336040965976572e+00,		4.488472304754725e+00,		4.640542369993058e+00,
		4.792251850773141e+00,		4.943601438016400e+00,		5.094591824788115e+00,		5.245223706578315e+00,		5.395497781560691e+00,
		5.545414750830431e+00,		5.694975318622049e+00,		5.844180192508055e+00,		5.993030083579411e+00,		6.141525706608615e+00,
		6.289667780196257e+00,		6.437457026901837e+00,		6.584894173359618e+00,		6.731979950380271e+00,		6.878715093038991e+00,
		7.025100340750817e+00,		7.171136437333779e+00,		7.316824131060498e+00,		7.462164174698924e+00,		7.607157325542683e+00,
		7.751804345431702e+00,		7.896106000763593e+00,		8.040063062496325e+00,		8.183676306142704e+00,		8.326946511757123e+00,
		8.469874463915037e+00,		8.612460951685616e+00,		8.754706768597988e+00,		8.896612712601492e+00,		9.038179586020313e+00,
		9.179408195502868e+00,		9.320299351966334e+00,		9.460853870536587e+00,		9.601072570483970e+00,		9.740956275155121e+00,
		9.880505811901200e+00,		1.001972201200281e+01,		1.015860571059180e+01,		1.029715774657038e+01,		1.043537896252757e+01,
		1.057327020465342e+01,		1.071083232265111e+01,		1.084806616964720e+01,		1.098497260210011e+01,		1.112155247970733e+01,
		1.125780666531110e+01,		1.139373602480313e+01,		1.152934142702833e+01,		1.166462374368770e+01,		1.179958384924066e+01,
		1.193422262080680e+01,		1.206854093806728e+01,		1.220253968316605e+01,		1.233621974061084e+01,		1.246958199717424e+01,
		1.260262734179480e+01,		1.273535666547839e+01,		1.286777086119982e+01,		1.299987082380485e+01,		1.313165744991263e+01,
		1.326313163781877e+01,		1.339429428739893e+01,		1.352514630001312e+01,		1.365568857841082e+01,		1.378592202663681e+01,
		1.391584754993789e+01,		1.404546605467058e+01,		1.417477844820965e+01,		1.430378563885784e+01,		1.443248853575642e+01,
		1.456088804879697e+01,		1.468898508853428e+01,		1.481678056610026e+01,		1.494427539311923e+01,		1.507147048162419e+01,
		1.519836674397454e+01,		1.532496509277482e+01,		1.545126644079486e+01,		1.557727170089116e+01,		1.570298178592957e+01,
		1.582839760870920e+01,		1.595352008188779e+01,		1.607835011790820e+01,		1.620288862892643e+01,		1.632713652674075e+01,
		1.645109472272237e+01,		1.657476412774728e+01,		1.669814565212953e+01,		1.682124020555574e+01,		1.694404869702097e+01,
		1.706657203476606e+01,		1.718881112621598e+01,		1.731076687791977e+01,		1.743244019549165e+01,		1.755383198355347e+01,
		1.767494314567842e+01,		1.779577458433603e+01,		1.791632720083846e+01,		1.803660189528802e+01,		1.815659956652593e+01,
		1.827632111208235e+01,		1.839576742812763e+01,		1.851493940942470e+01,		1.863383794928273e+01,		1.875246393951197e+01,
		1.887081827037974e+01,		1.898890183056751e+01,		1.910671550712929e+01,		1.922426018545091e+01,		1.934153674921062e+01,
		1.945854608034069e+01,		1.957528905899002e+01,		1.969176656348803e+01,		1.980797947030928e+01,		1.992392865403943e+01,
		2.003961498734201e+01,		2.015503934092625e+01,		2.027020258351595e+01,		2.038510558181919e+01,		2.049974920049915e+01,
		2.061413430214566e+01,		2.072826174724787e+01,		2.084213239416770e+01,		2.095574709911421e+01,		2.106910671611882e+01,
		2.118221209701140e+01,		2.129506409139723e+01,		2.140766354663464e+01,		2.152001130781369e+01,		2.163210821773540e+01,
		2.174395511689193e+01,		2.185555284344738e+01,		2.196690223321947e+01,		2.207800411966184e+01,		2.218885933384711e+01,
		2.229946870445060e+01,		2.240983305773485e+01,		2.251995321753461e+01,		2.262983000524269e+01,		2.273946423979630e+01,
		2.284885673766411e+01,		2.295800831283389e+01,		2.306691977680071e+01,		2.317559193855580e+01,		2.328402560457593e+01,
		2.339222157881338e+01,		2.350018066268644e+01,		2.360790365507043e+01,		2.371539135228931e+01,		2.382264454810766e+01,
		2.392966403372334e+01,		2.403645059776054e+01,		2.414300502626320e+01,		2.424932810268911e+01,		2.435542060790434e+01,
		2.446128332017806e+01,		2.456691701517790e+01,		2.467232246596568e+01,		2.477750044299352e+01,		2.488245171410039e+01,
		2.498717704450904e+01,		2.509167719682328e+01,		2.519595293102569e+01,		2.530000500447559e+01,		2.540383417190743e+01,
		2.550744118542955e+01,		2.561082679452316e+01,		2.571399174604175e+01,		2.581693678421076e+01,		2.591966265062756e+01,
		2.602217008426173e+01,		2.612445982145559e+01,		2.622653259592515e+01,		2.632838913876110e+01,		2.643003017843029e+01,
		2.653145644077733e+01,		2.663266864902648e+01,		2.673366752378380e+01,		2.683445378303948e+01,		2.693502814217047e+01,
		2.703539131394329e+01,		2.713554400851704e+01,		2.723548693344665e+01,		2.733522079368636e+01,		2.743474629159326e+01,
		2.753406412693122e+01,		2.763317499687484e+01,		2.773207959601366e+01,		2.783077861635651e+01,		2.792927274733604e+01,
		2.802756267581341e+01,		2.812564908608314e+01,		2.822353265987811e+01,		2.832121407637468e+01,		2.841869401219797e+01,
		2.851597314142733e+01,		2.861305213560185e+01,		2.870993166372602e+01,		2.880661239227560e+01,		2.890309498520347e+01,
		2.899938010394568e+01,		2.909546840742762e+01,		2.919136055207027e+01,		2.928705719179650e+01,		2.938255897803760e+01,
		2.947786655973973e+01,		2.957298058337064e+01,		2.966790169292635e+01,		2.976263052993798e+01,		2.985716773347856e+01,
		2.995151394017016e+01,		3.004566978419072e+01,		3.013963589728132e+01,		3.023341290875331e+01,		3.032700144549548e+01,
		3.042040213198149e+01,		3.051361559027714e+01,		3.060664244004780e+01,		3.069948329856595e+01,		3.079213878071859e+01,
		3.088460949901494e+01,		3.097689606359395e+01,		3.106899908223205e+01,		3.116091916035077e+01,		3.125265690102457e+01,
		3.134421290498857e+01,		3.143558777064637e+01,		3.152678209407792e+01,		3.161779646904733e+01,		3.170863148701095e+01,
		3.179928773712508e+01,		3.188976580625411e+01,		3.198006627897841e+01,		3.207018973760236e+01,		3.216013676216240e+01,
		3.224990793043506e+01,		3.233950381794499e+01,		3.242892499797309e+01,		3.251817204156456e+01,		3.260724551753702e+01,
		3.269614599248862e+01,		3.278487403080617e+01,		3.287343019467325e+01,		3.296181504407839e+01,		3.305002913682315e+01,
		3.313807302853032e+01,		3.322594727265206e+01,		3.331365242047804e+01,		3.340118902114359e+01,		3.348855762163789e+01,
		3.357575876681205e+01,		3.366279299938736e+01,		3.374966085996334e+01,		3.383636288702595e+01,		3.392289961695570e+01,
		3.400927158403577e+01,		3.409547932046014e+01,		3.418152335634177e+01,		3.426740421972063e+01,		3.435312243657179e+01,
		3.443867853081356e+01,		3.452407302431561e+01,		3.460930643690691e+01,		3.469437928638389e+01,		3.477929208851847e+01,
		3.486404535706603e+01,		3.494863960377351e+01,		3.503307533838731e+01,		3.511735306866141e+01,		3.520147330036521e+01,
		3.528543653729154e+01,		3.536924328126464e+01,		3.545289403214799e+01,		3.553638928785234e+01,		3.561972954434341e+01,
		3.570291529564992e+01,		3.578594703387139e+01,		3.586882524918597e+01,		3.595155042985819e+01,		3.603412306224687e+01,
		3.611654363081274e+01,		3.619881261812634e+01,		3.628093050487561e+01,		3.636289776987368e+01,		3.644471489006655e+01,
		3.652638234054071e+01,		3.660790059453085e+01,		3.668927012342732e+01,		3.677049139678397e+01,		3.685156488232550e+01,
		3.693249104595512e+01,		3.701327035176207e+01,		3.709390326202903e+01,		3.717439023723976e+01,		3.725473173608642e+01,
		3.733492821547701e+01,		3.741498013054287e+01,		3.749488793464593e+01,		3.757465207938619e+01,		3.765427301460898e+01,
		3.773375118841223e+01,		3.781308704715387e+01,		3.789228103545897e+01,		3.797133359622705e+01,		3.805024517063922e+01,
		3.812901619816542e+01,		3.820764711657153e+01,		3.828613836192653e+01,		3.836449036860957e+01,		3.844270356931705e+01,
		3.852077839506978e+01,		3.859871527521980e+01,		3.867651463745754e+01,		3.875417690781875e+01,		3.883170251069141e+01,
		3.890909186882273e+01,		3.898634540332600e+01,		3.906346353368740e+01,		3.914044667777294e+01,		3.921729525183527e+01,
		3.929400967052039e+01,		3.937059034687447e+01,		3.944703769235058e+01,		3.952335211681542e+01,		3.959953402855602e+01,
		3.967558383428630e+01,		3.975150193915379e+01,		3.982728874674626e+01,		3.990294465909822e+01,		3.997847007669753e+01,
		4.005386539849192e+01,		4.012913102189548e+01,		4.020426734279514e+01,		4.027927475555712e+01,		4.035415365303337e+01,
		4.042890442656797e+01,		4.050352746600346e+01,		4.057802315968721e+01,		4.065239189447779e+01,		4.072663405575120e+01,
		4.080075002740715e+01,		4.087474019187536e+01,		4.094860493012164e+01,		4.102234462165428e+01,		4.109595964453007e+01,
		4.116945037536048e+01,		4.124281718931780e+01,		4.131606046014114e+01,		4.138918056014266e+01,		4.146217786021349e+01,
		4.153505272982972e+01,		4.160780553705849e+01,		4.168043664856388e+01,		4.175294642961293e+01,		4.182533524408137e+01,
		4.189760345445976e+01,		4.196975142185924e+01,		4.204177950601724e+01,		4.211368806530351e+01,		4.218547745672581e+01,
		4.225714803593568e+01,		4.232870015723419e+01,		4.240013417357761e+01,		4.247145043658325e+01,		4.254264929653492e+01,
		4.261373110238871e+01,		4.268469620177864e+01,		4.275554494102213e+01,		4.282627766512572e+01,		4.289689471779043e+01,
		4.296739644141750e+01,		4.303778317711373e+01,		4.310805526469706e+01,		4.317821304270194e+01,		4.324825684838485e+01,
		4.331818701772960e+01,		4.338800388545283e+01,		4.345770778500930e+01,		4.352729904859724e+01,		4.359677800716369e+01,
		4.366614499040974e+01,		4.373540032679586e+01,		4.380454434354712e+01,		4.387357736665840e+01,		4.394249972089963e+01,
		4.401131172982092e+01,		4.408001371575774e+01,		4.414860599983611e+01,		4.421708890197758e+01,		4.428546274090445e+01,
		4.435372783414478e+01,		4.442188449803744e+01,		4.448993304773713e+01,		4.455787379721940e+01,		4.462570705928559e+01,
		4.469343314556786e+01,		4.476105236653408e+01,		4.482856503149272e+01,		4.489597144859777e+01,		4.496327192485366e+01,
		4.503046676612007e+01,		4.509755627711672e+01,		4.516454076142823e+01,		4.523142052150895e+01,		4.529819585868761e+01,
		4.536486707317215e+01,		4.543143446405448e+01,		4.549789832931503e+01,		4.556425896582765e+01,		4.563051666936413e+01,
		4.569667173459880e+01,		4.576272445511336e+01,		4.582867512340128e+01,		4.589452403087245e+01,		4.596027146785780e+01,
		4.602591772361372e+01,		4.609146308632675e+01,		4.615690784311793e+01,		4.622225228004737e+01,		4.628749668211866e+01,
		4.635264133328340e+01,		4.641768651644549e+01,		4.648263251346570e+01,		4.654747960516589e+01,		4.661222807133357e+01,
		4.667687819072598e+01,		4.674143024107467e+01,		4.680588449908975e+01,		4.687024124046408e+01,		4.693450073987761e+01,
		4.699866327100163e+01,		4.706272910650305e+01,		4.712669851804852e+01,		4.719057177630871e+01,		4.725434915096240e+01,
		4.731803091070081e+01,		4.738161732323148e+01,		4.744510865528269e+01,		4.750850517260731e+01,		4.757180713998702e+01,
		4.763501482123640e+01,		4.769812847920688e+01,		4.776114837579087e+01,		4.782407477192574e+01,		4.788690792759775e+01,
		4.794964810184621e+01,		4.801229555276723e+01,		4.807485053751780e+01,		4.813731331231969e+01,		4.819968413246337e+01,
		4.826196325231182e+01,		4.832415092530454e+01,		4.838624740396133e+01,		4.844825293988613e+01,		4.851016778377089e+01,
		4.857199218539931e+01,		4.863372639365072e+01,		4.869537065650373e+01,		4.875692522104018e+01,		4.881839033344866e+01,
		4.887976623902841e+01,		4.894105318219292e+01,		4.900225140647368e+01,		4.906336115452385e+01,		4.912438266812187e+01,
		4.918531618817520e+01,		4.924616195472385e+01,		4.930692020694399e+01,		4.936759118315172e+01,		4.942817512080638e+01
	},
	{
		8.112408795077497e-02,		2.432494377055301e-01,		4.049948723733209e-01,		5.663612668252773e-01,		7.273494758790232e-01,
		8.879603357882242e-01,		1.048194665660602e+00,		1.208053268807260e+00,		1.367536934026068e+00,		1.526646436821721e+00,
		1.685382540565010e+00,		1.843745997593739e+00,		2.001737550257593e+00,		2.159357931909253e+00,		2.316607867843862e+00,
		2.473488076188971e+00,		2.629999268746936e+00,		2.786142151791703e+00,		2.941917426821842e+00,		3.097325791271611e+00,
		3.252367939181771e+00,		3.407044561831819e+00,		3.561356348335237e+00,		3.715303986199276e+00,		3.868888161850803e+00,
		4.022109561129604e+00,		4.174968869750532e+00,		4.327466773735840e+00,		4.479603959818973e+00,		4.631381115821057e+00,
		4.782798931001265e+00,		4.933858096382230e+00,		5.084559305051582e+00,		5.234903252440708e+00,		5.384890636581728e+00,
		5.534522158343702e+00,		5.683798521649014e+00,		5.832720433670845e+00,		5.981288605012631e+00,		6.129503749870341e+00,
		6.277366586178424e+00,		6.424877835740189e+00,		6.572038224343374e+00,		6.718848481861678e+00,		6.865309342342901e+00,
		7.011421544084425e+00,		7.157185829696640e+00,		7.302602946154980e+00,		7.447673644841153e+00,		7.592398681574131e+00,
		7.736778816631488e+00,		7.880814814761608e+00,		8.024507445187231e+00,		8.167857481600945e+00,		8.310865702152936e+00,
		8.453532889431601e+00,		8.595859830437359e+00,		8.737847316550132e+00,		8.879496143490865e+00,		9.020807111277470e+00,
		9.161781024175600e+00,		9.302418690644537e+00,		9.442720923278602e+00,		9.582688538744357e+00,		9.722322357713908e+00,
		9.861623204794679e+00,		1.000059190845579e+01,		1.013922930095148e+01,		1.027753621824168e+01,		1.041551349991011e+01,
		1.055316198908001e+01,		1.069048253232784e+01,		1.082747597959506e+01,		1.096414318409829e+01,		1.110048500223793e+01,
		1.123650229350557e+01,		1.137219592039016e+01,		1.150756674828335e+01,		1.164261564538393e+01,		1.177734348260164e+01,
		1.191175113346052e+01,		1.204583947400177e+01,		1.217960938268649e+01,		1.231306174029815e+01,		1.244619742984511e+01,
		1.257901733646322e+01,		1.271152234731860e+01,		1.284371335151063e+01,		1.297559123997538e+01,		1.310715690538946e+01,
		1.323841124207441e+01,		1.336935514590160e+01,		1.349998951419791e+01,		1.363031524565208e+01,		1.376033324022181e+01,
		1.389004439904181e+01,		1.401944962433260e+01,		1.414854981931037e+01,		1.427734588809774e+01,		1.440583873563561e+01,
		1.453402926759599e+01,		1.466191839029603e+01,		1.478950701061305e+01,		1.491679603590084e+01,		1.504378637390700e+01,
		1.517047893269169e+01,		1.529687462054733e+01,		1.542297434591979e+01,		1.554877901733062e+01,		1.567428954330075e+01,
		1.579950683227526e+01,		1.592443179254965e+01,		1.604906533219719e+01,		1.617340835899774e+01,		1.629746178036779e+01,
		1.642122650329187e+01,		1.654470343425513e+01,		1.666789347917743e+01,		1.679079754334861e+01,		1.691341653136505e+01,
		1.703575134706760e+01,		1.715780289348082e+01,		1.727957207275341e+01,		1.740105978610003e+01,		1.752226693374435e+01,
		1.764319441486337e+01,		1.776384312753299e+01,		1.788421396867490e+01,		1.800430783400462e+01,		1.812412561798079e+01,
		1.824366821375578e+01,		1.836293651312729e+01,		1.848193140649144e+01,		1.860065378279671e+01,		1.871910452949934e+01,
		1.883728453251971e+01,		1.895519467619986e+01,		1.907283584326229e+01,		1.919020891476964e+01,		1.930731477008568e+01,
		1.942415428683722e+01,		1.954072834087717e+01,		1.965703780624868e+01,		1.977308355515017e+01,		1.988886645790155e+01,
		2.000438738291130e+01,		2.011964719664467e+01,		2.023464676359269e+01,		2.034938694624233e+01,		2.046386860504738e+01,
		2.057809259840046e+01,		2.069205978260577e+01,		2.080577101185283e+01,		2.091922713819110e+01,		2.103242901150536e+01,
		2.114537747949202e+01,		2.125807338763627e+01,		2.137051757918994e+01,		2.148271089515030e+01,		2.159465417423953e+01,
		2.170634825288494e+01,		2.181779396520006e+01,		2.192899214296640e+01,		2.203994361561583e+01,		2.215064921021390e+01,
		2.226110975144359e+01,		2.237132606158994e+01,		2.248129896052521e+01,		2.259102926569482e+01,		2.270051779210373e+01,
		2.280976535230366e+01,		2.291877275638077e+01,		2.302754081194398e+01,		2.313607032411386e+01,		2.324436209551214e+01,
		2.335241692625167e+01,		2.346023561392705e+01,		2.356781895360566e+01,		2.367516773781929e+01,		2.378228275655632e+01,
		2.388916479725422e+01,		2.399581464479272e+01,		2.410223308148736e+01,		2.420842088708346e+01,		2.431437883875065e+01,
		2.442010771107773e+01,		2.452560827606807e+01,		2.463088130313524e+01,		2.473592755909923e+01,		2.484074780818302e+01,
		2.494534281200945e+01,		2.504971332959853e+01,		2.515386011736518e+01,		2.525778392911714e+01,		2.536148551605342e+01,
		2.546496562676302e+01,		2.556822500722386e+01,		2.567126440080226e+01,		2.577408454825252e+01,		2.587668618771693e+01,
		2.597907005472601e+01,		2.608123688219905e+01,		2.618318740044498e+01,		2.628492233716337e+01,		2.638644241744592e+01,
		2.648774836377794e+01,		2.658884089604031e+01,		2.668972073151151e+01,		2.679038858487000e+01,		2.689084516819673e+01,
		2.699109119097802e+01,		2.709112736010840e+01,		2.719095437989396e+01,		2.729057295205567e+01,		2.738998377573298e+01,
		2.748918754748764e+01,		2.758818496130760e+01,		2.768697670861129e+01,		2.778556347825175e+01,		2.788394595652126e+01,
		2.798212482715590e+01,		2.808010077134044e+01,		2.817787446771313e+01,		2.827544659237097e+01,		2.837281781887482e+01,
		2.846998881825482e+01,		2.856696025901591e+01,		2.866373280714339e+01,		2.876030712610872e+01,		2.885668387687542e+01,
		2.895286371790491e+01,		2.904884730516284e+01,		2.914463529212503e+01,		2.924022832978391e+01,		2.933562706665490e+01,
		2.943083214878288e+01,		2.952584421974880e+01,		2.962066392067627e+01,		2.971529189023843e+01,		2.980972876466465e+01,
		2.990397517774759e+01,		2.999803176085000e+01,		3.009189914291192e+01,		3.018557795045774e+01,		3.027906880760339e+01,
		3.037237233606361e+01,		3.046548915515917e+01,		3.055841988182436e+01,		3.065116513061435e+01,		3.074372551371257e+01,
		3.083610164093839e+01,		3.092829411975454e+01,		3.102030355527480e+01,		3.111213055027160e+01,		3.120377570518376e+01,
		3.129523961812411e+01,		3.138652288488741e+01,		3.147762609895796e+01,		3.156854985151755e+01,		3.165929473145330e+01,
		3.174986132536544e+01,		3.184025021757537e+01,		3.193046199013341e+01,		3.202049722282693e+01,		3.211035649318816e+01,
		3.220004037650229e+01,		3.228954944581540e+01,		3.237888427194255e+01,		3.246804542347572e+01,		3.255703346679197e+01,
		3.264584896606139e+01,		3.273449248325524e+01,		3.282296457815397e+01,		3.291126580835536e+01,		3.299939672928254e+01,
		3.308735789419218e+01,		3.317514985418242e+01,		3.326277315820118e+01,		3.335022835305405e+01,		3.343751598341256e+01,
		3.352463659182215e+01,		3.361159071871033e+01,		3.369837890239477e+01,		3.378500167909135e+01,		3.387145958292228e+01,
		3.395775314592422e+01,		3.404388289805619e+01,		3.412984936720783e+01,		3.421565307920729e+01,		3.430129455782941e+01,
		3.438677432480367e+01,		3.447209289982224e+01,		3.455725080054801e+01,		3.464224854262255e+01,		3.472708663967417e+01,
		3.481176560332581e+01,		3.489628594320309e+01,		3.498064816694217e+01,		3.506485278019781e+01,		3.514890028665111e+01,
		3.523279118801759e+01,		3.531652598405494e+01,		3.540010517257104e+01,		3.548352924943162e+01,		3.556679870856826e+01,
		3.564991404198611e+01,		3.573287573977172e+01,		3.581568429010084e+01,		3.589834017924614e+01,		3.598084389158495e+01,
		3.606319590960702e+01,		3.614539671392217e+01,		3.622744678326799e+01,		3.630934659451750e+01,		3.639109662268677e+01,
		3.647269734094259e+01,		3.655414922060993e+01,		3.663545273117965e+01,		3.671660834031594e+01,		3.679761651386397e+01,
		3.687847771585723e+01,		3.695919240852511e+01,		3.703976105230036e+01,		3.712018410582646e+01,		3.720046202596507e+01,
		3.728059526780338e+01,		3.736058428466151e+01,		3.744042952809984e+01,		3.752013144792625e+01,		3.759969049220349e+01,
		3.767910710725639e+01,		3.775838173767913e+01,		3.783751482634237e+01,		3.791650681440062e+01,		3.799535814129914e+01,
		3.807406924478127e+01,		3.815264056089549e+01,		3.823107252400249e+01,		3.830936556678218e+01,		3.838752012024085e+01,
		3.846553661371806e+01,		3.854341547489363e+01,		3.862115712979470e+01,		3.869876200280253e+01,		3.877623051665950e+01,
		3.885356309247591e+01,		3.893076014973688e+01,		3.900782210630918e+01,		3.908474937844804e+01,		3.916154238080383e+01,
		3.923820152642893e+01,		3.931472722678441e+01,		3.939111989174667e+01,		3.946737992961420e+01,		3.954350774711416e+01,
		3.961950374940901e+01,		3.969536834010312e+01,		3.977110192124930e+01,		3.984670489335544e+01,		3.992217765539085e+01,
		3.999752060479292e+01,		4.007273413747347e+01,		4.014781864782523e+01,		4.022277452872827e+01,		4.029760217155632e+01,
		4.037230196618319e+01,		4.044687430098909e+01,		4.052131956286691e+01,		4.059563813722851e+01,		4.066983040801102e+01,
		4.074389675768298e+01,		4.081783756725066e+01,		4.089165321626413e+01,		4.096534408282348e+01,		4.103891054358492e+01,
		4.111235297376692e+01,		4.118567174715626e+01,		4.125886723611398e+01,		4.133193981158168e+01,		4.140488984308723e+01,
		4.147771769875087e+01,		4.155042374529125e+01,		4.162300834803114e+01,		4.169547187090359e+01,		4.176781467645759e+01,
		4.184003712586401e+01,		4.191213957892151e+01,		4.198412239406214e+01,		4.205598592835733e+01,		4.212773053752357e+01,
		4.219935657592801e+01,		4.227086439659438e+01,		4.234225435120857e+01,		4.241352679012426e+01,		4.248468206236861e+01,
		4.255572051564776e+01,		4.262664249635262e+01,		4.269744834956425e+01,		4.276813841905943e+01,		4.283871304731629e+01,
		4.290917257551963e+01,		4.297951734356650e+01,		4.304974769007162e+01,		4.311986395237280e+01,		4.318986646653633e+01,
		4.325975556736233e+01,		4.332953158839020e+01,		4.339919486190375e+01,		4.346874571893678e+01,		4.353818448927813e+01,
		4.360751150147701e+01,		4.367672708284827e+01,		4.374583155947763e+01,		4.381482525622675e+01,		4.388370849673858e+01,
		4.395248160344235e+01,		4.402114489755873e+01,		4.408969869910509e+01,		4.415814332690024e+01,		4.422647909856990e+01,
		4.429470633055137e+01,		4.436282533809883e+01,		4.443083643528813e+01,		4.449873993502185e+01,		4.456653614903428e+01,
		4.463422538789627e+01,		4.470180796102015e+01,		4.476928417666473e+01,		4.483665434193995e+01,		4.490391876281193e+01,
		4.497107774410765e+01,		4.503813158951989e+01,		4.510508060161183e+01,		4.517192508182195e+01,		4.523866533046868e+01,
		4.530530164675525e+01,		4.537183432877421e+01,		4.543826367351222e+01,		4.550458997685468e+01,		4.557081353359035e+01,
		4.563693463741600e+01,		4.570295358094094e+01,		4.576887065569169e+01,		4.583468615211645e+01,		4.590040035958967e+01,
		4.596601356641656e+01,		4.603152605983759e+01,		4.609693812603298e+01,		4.616225005012710e+01,		4.622746211619297e+01,
		4.629257460725665e+01,		4.635758780530163e+01,		4.642250199127320e+01,		4.648731744508287e+01,		4.655203444561265e+01,
		4.661665327071935e+01,		4.668117419723895e+01,		4.674559750099088e+01,		4.680992345678219e+01,		4.687415233841188e+01,
		4.693828441867518e+01,		4.700231996936756e+01,		4.706625926128916e+01,		4.713010256424878e+01,		4.719385014706813e+01,
		4.725750227758591e+01,		4.732105922266194e+01,		4.738452124818136e+01,		4.744788861905852e+01,		4.751116159924116e+01,
		4.757434045171445e+01,		4.763742543850505e+01,		4.770041682068501e+01,		4.776331485837580e+01,		4.782611981075240e+01,
		4.788883193604712e+01,		4.795145149155353e+01,		4.801397873363048e+01,		4.807641391770601e+01,		4.813875729828110e+01,
		4.820100912893363e+01,		4.826316966232232e+01,		4.832523915019036e+01,		4.838721784336940e+01,		4.844910599178330e+01,
		4.851090384445187e+01,		4.857261164949472e+01,		4.863422965413498e+01,		4.869575810470293e+01,		4.875719724663996e+01,
		4.881854732450200e+01,		4.887980858196340e+01,		4.894098126182050e+01,		4.900206560599534e+01,		4.906306185553927e+01,
		4.912397025063656e+01,		4.918479103060807e+01,		4.924552443391470e+01,		4.930617069816114e+01,		4.936673006009926e+01
	},
	{
		8.096069815498348e-02,		2.427598589074267e-01,		4.041803286956299e-01,		5.652229821662356e-01,		7.258886740745905e-01,
		8.861782407566080e-01,		1.046092501530056e+00,		1.205632260028076e+00,		1.364798305467626e+00,		1.523591413855461e+00,
		1.682012349134101e+00,		1.840061864270226e+00,		1.997740702287766e+00,		2.155049597247914e+00,		2.311989275178188e+00,
		2.468560454952600e+00,		2.624763849124890e+00,		2.780600164716745e+00,		2.936070103962812e+00,		3.091174365014286e+00,
		3.245913642602761e+00,		3.400288628665977e+00,		3.554300012937056e+00,		3.707948483498723e+00,		3.861234727303993e+00,
		4.014159430664734e+00,		4.166723279709465e+00,		4.318926960811679e+00,		4.470771160990006e+00,		4.622256568281372e+00,
		4.773383872088384e+00,		4.924153763502023e+00,		5.074566935600783e+00,		5.224624083727282e+00,		5.374325905743342e+00,
		5.523673102264552e+00,		5.672666376875243e+00,		5.821306436324746e+00,		5.969593990705868e+00,		6.117529753616373e+00,
		6.265114442304293e+00,		6.412348777797882e+00,		6.559233485020900e+00,		6.705769292894004e+00,		6.851956934422921e+00,
		6.997797146774063e+00,		7.143290671338245e+00,		7.288438253783097e+00,		7.433240644094813e+00,		7.577698596609741e+00,
		7.721812870036439e+00,		7.865584227468654e+00,		8.009013436389766e+00,		8.152101268669208e+00,		8.294848500551268e+00,
		8.437255912636761e+00,		8.579324289858011e+00,		8.721054421447526e+00,		8.862447100900742e+00,		9.003503125933319e+00,
		9.144223298433193e+00,		9.284608424407891e+00,		9.424659313927297e+00,		9.564376781062309e+00,		9.703761643819618e+00,
		9.842814724072920e+00,		9.981536847490824e+00,		1.011992884346180e+01,		1.025799154501623e+01,		1.039572578874609e+01,
		1.053313241472219e+01,		1.067021226640944e+01,		1.080696619058016e+01,		1.094339503722582e+01,		1.107949965946719e+01,
		1.121528091346328e+01,		1.135073965831908e+01,		1.148587675599242e+01,		1.162069307119991e+01,		1.175518947132232e+01,
		1.188936682630936e+01,		1.202322600858410e+01,		1.215676789294714e+01,		1.228999335648055e+01,		1.242290327845187e+01,
		1.255549854021810e+01,		1.268778002512987e+01,		1.281974861843592e+01,		1.295140520718782e+01,		1.308275068014520e+01,
		1.321378592768148e+01,		1.334451184169008e+01,		1.347492931549141e+01,		1.360503924374048e+01,		1.373484252233527e+01,
		1.386434004832597e+01,		1.399353271982505e+01,		1.412242143591824e+01,		1.425100709657653e+01,		1.437929060256906e+01,
		1.450727285537721e+01,		1.463495475710958e+01,		1.476233721041817e+01,		1.488942111841574e+01,		1.501620738459416e+01,
		1.514269691274414e+01,		1.526889060687599e+01,		1.539478937114166e+01,		1.552039410975802e+01,		1.564570572693140e+01,
		1.577072512678332e+01,		1.589545321327753e+01,		1.601989089014836e+01,		1.614403906083025e+01,		1.626789862838865e+01,
		1.639147049545218e+01,		1.651475556414607e+01,		1.663775473602691e+01,		1.676046891201865e+01,		1.688289899234993e+01,
		1.700504587649267e+01,		1.712691046310195e+01,		1.724849364995714e+01,		1.736979633390430e+01,		1.749081941079991e+01,
		1.761156377545571e+01,		1.773203032158494e+01,		1.785221994174968e+01,		1.797213352730956e+01,		1.809177196837148e+01,
		1.821113615374075e+01,		1.833022697087325e+01,		1.844904530582889e+01,		1.856759204322613e+01,		1.868586806619774e+01,
		1.880387425634765e+01,		1.892161149370892e+01,		1.903908065670288e+01,		1.915628262209926e+01,		1.927321826497749e+01,
		1.938988845868909e+01,		1.950629407482100e+01,		1.962243598315997e+01,		1.973831505165817e+01,		1.985393214639947e+01,
		1.996928813156696e+01,		2.008438386941143e+01,		2.019922022022060e+01,		2.031379804228962e+01,		2.042811819189217e+01,
		2.054218152325272e+01,		2.065598888851954e+01,		2.076954113773867e+01,		2.088283911882871e+01,		2.099588367755644e+01,
		2.110867565751339e+01,		2.122121590009307e+01,		2.133350524446912e+01,		2.144554452757421e+01,		2.155733458407967e+01,
		2.166887624637595e+01,		2.178017034455382e+01,		2.189121770638621e+01,		2.200201915731086e+01,		2.211257552041360e+01,
		2.222288761641242e+01,		2.233295626364202e+01,		2.244278227803924e+01,		2.255236647312895e+01,		2.266170966001070e+01,
		2.277081264734591e+01,		2.287967624134563e+01,		2.298830124575905e+01,		2.309668846186232e+01,		2.320483868844827e+01,
		2.331275272181631e+01,		2.342043135576318e+01,		2.352787538157410e+01,		2.363508558801431e+01,		2.374206276132138e+01,
		2.384880768519776e+01,		2.395532114080395e+01,		2.406160390675210e+01,		2.416765675910002e+01,		2.427348047134575e+01,
		2.437907581442236e+01,		2.448444355669347e+01,		2.458958446394881e+01,		2.469449929940057e+01,		2.479918882367982e+01,
		2.490365379483356e+01,		2.500789496832185e+01,		2.511191309701569e+01,		2.521570893119490e+01,		2.531928321854651e+01,
		2.542263670416351e+01,		2.552577013054383e+01,		2.562868423758965e+01,		2.573137976260714e+01,		2.583385744030636e+01,
		2.593611800280148e+01,		2.603816217961132e+01,		2.613999069766019e+01,		2.624160428127891e+01,		2.634300365220619e+01,
		2.644418952959015e+01,		2.654516262999020e+01,		2.664592366737911e+01,		2.674647335314526e+01,		2.684681239609525e+01,
		2.694694150245655e+01,		2.704686137588055e+01,		2.714657271744561e+01,		2.724607622566058e+01,		2.734537259646818e+01,
		2.744446252324889e+01,		2.754334669682477e+01,		2.764202580546362e+01,		2.774050053488327e+01,		2.783877156825591e+01,
		2.793683958621283e+01,		2.803470526684906e+01,		2.813236928572834e+01,		2.822983231588810e+01,		2.832709502784469e+01,
		2.842415808959872e+01,		2.852102216664046e+01,		2.861768792195543e+01,		2.871415601603015e+01,		2.881042710685783e+01,
		2.890650184994445e+01,		2.900238089831469e+01,		2.909806490251815e+01,		2.919355451063551e+01,		2.928885036828494e+01,
		2.938395311862850e+01,		2.947886340237869e+01,		2.957358185780504e+01,		2.966810912074081e+01,		2.976244582458975e+01,
		2.985659260033303e+01,		2.995055007653604e+01,		3.004431887935549e+01,		3.013789963254644e+01,		3.023129295746938e+01,
		3.032449947309754e+01,		3.041751979602399e+01,		3.051035454046904e+01,		3.060300431828761e+01,		3.069546973897653e+01,
		3.078775140968217e+01,		3.087984993520779e+01,		3.097176591802116e+01,		3.106349995826212e+01,		3.115505265375025e+01,
		3.124642459999250e+01,		3.133761639019092e+01,		3.142862861525033e+01,		3.151946186378620e+01,		3.161011672213233e+01,
		3.170059377434870e+01,		3.179089360222942e+01,		3.188101678531041e+01,		3.197096390087748e+01,		3.206073552397410e+01,
		3.215033222740941e+01,		3.223975458176617e+01,		3.232900315540864e+01,		3.241807851449071e+01,		3.250698122296368e+01,
		3.259571184258447e+01,		3.268427093292350e+01,		3.277265905137271e+01,		3.286087675315370e+01,		3.294892459132559e+01,
		3.303680311679322e+01,		3.312451287831505e+01,		3.321205442251133e+01,		3.329942829387202e+01,		3.338663503476494e+01,
		3.347367518544372e+01,		3.356054928405593e+01,		3.364725786665105e+01,		3.373380146718850e+01,		3.382018061754570e+01,
		3.390639584752611e+01,		3.399244768486724e+01,		3.407833665524858e+01,		3.416406328229967e+01,		3.424962808760817e+01,
		3.433503159072764e+01,		3.442027430918571e+01,		3.450535675849193e+01,		3.459027945214576e+01,		3.467504290164449e+01,
		3.475964761649119e+01,		3.484409410420260e+01,		3.492838287031700e+01,		3.501251441840217e+01,		3.509648925006321e+01,
		3.518030786495033e+01,		3.526397076076681e+01,		3.534747843327675e+01,		3.543083137631283e+01,		3.551403008178422e+01,
		3.559707503968418e+01,		3.567996673809792e+01,		3.576270566321037e+01,		3.584529229931371e+01,		3.592772712881523e+01,
		3.601001063224493e+01,		3.609214328826317e+01,		3.617412557366833e+01,		3.625595796340435e+01,		3.633764093056835e+01,
		3.641917494641828e+01,		3.650056048038030e+01,		3.658179800005639e+01,		3.666288797123193e+01,		3.674383085788298e+01,
		3.682462712218391e+01,		3.690527722451471e+01,		3.698578162346848e+01,		3.706614077585878e+01,		3.714635513672697e+01,
		3.722642515934960e+01,		3.730635129524562e+01,		3.738613399418378e+01,		3.746577370418986e+01,		3.754527087155383e+01,
		3.762462594083721e+01,		3.770383935488010e+01,		3.778291155480846e+01,		3.786184298004125e+01,		3.794063406829745e+01,
		3.801928525560322e+01,		3.809779697629897e+01,		3.817616966304635e+01,		3.825440374683535e+01,		3.833249965699115e+01,
		3.841045782118125e+01,		3.848827866542224e+01,		3.856596261408688e+01,		3.864351008991086e+01,		3.872092151399968e+01,
		3.879819730583557e+01,		3.887533788328415e+01,		3.895234366260135e+01,		3.902921505844014e+01,		3.910595248385720e+01,
		3.918255635031964e+01,		3.925902706771177e+01,		3.933536504434164e+01,		3.941157068694772e+01,		3.948764440070551e+01,
		3.956358658923409e+01,		3.963939765460269e+01,		3.971507799733723e+01,		3.979062801642677e+01,		3.986604810933003e+01,
		3.994133867198178e+01,		4.001650009879937e+01,		4.009153278268899e+01,		4.016643711505213e+01,		4.024121348579190e+01,
		4.031586228331937e+01,		4.039038389455980e+01,		4.046477870495900e+01,		4.053904709848944e+01,		4.061318945765667e+01,
		4.068720616350527e+01,		4.076109759562523e+01,		4.083486413215792e+01,		4.090850614980230e+01,		4.098202402382105e+01,
		4.105541812804648e+01,		4.112868883488679e+01,		4.120183651533179e+01,		4.127486153895919e+01,		4.134776427394043e+01,
		4.142054508704654e+01,		4.149320434365421e+01,		4.156574240775157e+01,		4.163815964194414e+01,		4.171045640746053e+01,
		4.178263306415847e+01,		4.185468997053040e+01,		4.192662748370935e+01,		4.199844595947462e+01,		4.207014575225759e+01,
		4.214172721514729e+01,		4.221319069989616e+01,		4.228453655692571e+01,		4.235576513533204e+01,		4.242687678289153e+01,
		4.249787184606640e+01,		4.256875067001025e+01,		4.263951359857354e+01,		4.271016097430915e+01,		4.278069313847790e+01,
		4.285111043105392e+01,		4.292141319073010e+01,		4.299160175492354e+01,		4.306167645978088e+01,		4.313163764018378e+01,
		4.320148562975405e+01,		4.327122076085919e+01,		4.334084336461761e+01,		4.341035377090375e+01,		4.347975230835363e+01,
		4.354903930436978e+01,		4.361821508512664e+01,		4.368727997557563e+01,		4.375623429945036e+01,		4.382507837927179e+01,
		4.389381253635332e+01,		4.396243709080578e+01,		4.403095236154270e+01,		4.409935866628521e+01,		4.416765632156712e+01,
		4.423584564273990e+01,		4.430392694397771e+01,		4.437190053828233e+01,		4.443976673748806e+01,		4.450752585226667e+01,
		4.457517819213238e+01,		4.464272406544659e+01,		4.471016377942286e+01,		4.477749764013164e+01,		4.484472595250515e+01,
		4.491184902034215e+01,		4.497886714631274e+01,		4.504578063196306e+01,		4.511258977772001e+01,		4.517929488289604e+01,
		4.524589624569377e+01,		4.531239416321068e+01,		4.537878893144374e+01,		4.544508084529404e+01,		4.551127019857145e+01,
		4.557735728399913e+01,		4.564334239321809e+01,		4.570922581679187e+01,		4.577500784421088e+01,		4.584068876389704e+01,
		4.590626886320823e+01,		4.597174842844267e+01,		4.603712774484364e+01,		4.610240709660349e+01,		4.616758676686841e+01,
		4.623266703774267e+01,		4.629764819029297e+01,		4.636253050455286e+01,		4.642731425952702e+01,		4.649199973319561e+01,
		4.655658720251851e+01,		4.662107694343966e+01,		4.668546923089131e+01,		4.674976433879819e+01,		4.681396254008179e+01,
		4.687806410666452e+01,		4.694206930947399e+01,		4.700597841844706e+01,		4.706979170253400e+01,		4.713350942970266e+01,
		4.719713186694258e+01,		4.726065928026910e+01,		4.732409193472726e+01,		4.738743009439617e+01,		4.745067402239275e+01,
		4.751382398087591e+01,		4.757688023105050e+01,		4.763984303317138e+01,		4.770271264654716e+01,		4.776548932954441e+01,
		4.782817333959149e+01,		4.789076493318243e+01,		4.795326436588088e+01,		4.801567189232389e+01,		4.807798776622596e+01,
		4.814021224038272e+01,		4.820234556667477e+01,		4.826438799607165e+01,		4.832633977863543e+01,		4.838820116352460e+01,
		4.844997239899785e+01,		4.851165373241775e+01,		4.857324541025447e+01,		4.863474767808970e+01,		4.869616078061991e+01,
		4.875748496166052e+01,		4.881872046414925e+01,		4.887986753014987e+01,		4.894092640085582e+01,		4.900189731659383e+01,
		4.906278051682754e+01,		4.912357624016097e+01,		4.918428472434230e+01,		4.924490620626724e+01,		4.930544092198257e+01
	},
	{
		8.079796541350551e-02,		2.422722488274837e-01,		4.033690603514481e-01,		5.640892743680533e-01,		7.244337455291087e-01,
		8.844033102100040e-01,		1.043998787894499e+00,		1.203220982492652e+00,		1.362070683594535e+00,		1.520548667662308e+00,
		1.678655699163083e+00,		1.836392531644957e+00,		1.993759908758473e+00,		2.150758565225693e+00,		2.307389227758981e+00,
		2.463652615931527e+00,		2.619549443001539e+00,		2.775080416691993e+00,		2.930246239927748e+00,		3.085047611531729e+00,
		3.239485226881914e+00,		3.393559778530673e+00,		3.547271956788060e+00,		3.700622450270535e+00,		3.853611946416560e+00,
		4.006241131970475e+00,		4.158510693435979e+00,		4.310421317500514e+00,		4.461973691431806e+00,		4.613168503447766e+00,
		4.764006443060882e+00,		4.914488201398263e+00,		5.064614471498360e+00,		5.214385948585468e+00,		5.363803330322926e+00,
		5.512867317046044e+00,		5.661578611975668e+00,		5.809937921413249e+00,		5.957945954918324e+00,		6.105603425469194e+00,
		6.252911049607623e+00,		6.399869547568338e+00,		6.546479643394025e+00,		6.692742065036596e+00,		6.838657544445342e+00,
		6.984226817642709e+00,		7.129450624788262e+00,		7.274329710231497e+00,		7.418864822554062e+00,		7.563056714601947e+00,
		7.706906143508211e+00,		7.850413870706761e+00,		7.993580661937633e+00,		8.136407287244351e+00,		8.278894520963718e+00,
		8.421043141708582e+00,		8.562853932343907e+00,		8.704327679956643e+00,		8.845465175819726e+00,		8.986267215350582e+00,
		9.126734598064562e+00,		9.266868127523534e+00,		9.406668611280104e+00,		9.546136860817626e+00,		9.685273691486433e+00,
		9.824079922436507e+00,		9.962556376546873e+00,		1.010070388035198e+01,		1.023852326396535e+01,		1.037601536100066e+01,
		1.051318100849060e+01,		1.065002104680357e+01,		1.078653631955862e+01,		1.092272767353861e+01,		1.105859595860196e+01,
		1.119414202759305e+01,		1.132936673625157e+01,		1.146427094312078e+01,		1.159885550945502e+01,		1.173312129912656e+01,
		1.186706917853186e+01,		1.200070001649750e+01,		1.213401468418571e+01,		1.226701405499987e+01,		1.239969900448982e+01,
		1.253207041025735e+01,		1.266412915186175e+01,		1.279587611072559e+01,		1.292731217004091e+01,		1.305843821467567e+01,
		1.318925513108089e+01,		1.331976380719816e+01,		1.344996513236782e+01,		1.357985999723791e+01,		1.370944929367375e+01,
		1.383873391466839e+01,		1.396771475425386e+01,		1.409639270741338e+01,		1.422476866999443e+01,		1.435284353862283e+01,
		1.448061821061789e+01,		1.460809358390850e+01,		1.473527055695041e+01,		1.486215002864450e+01,		1.498873289825633e+01,
		1.511502006533667e+01,		1.524101242964337e+01,		1.536671089106431e+01,		1.549211634954163e+01,		1.561722970499707e+01,
		1.574205185725876e+01,		1.586658370598898e+01,		1.599082615061342e+01,		1.611478009025149e+01,		1.623844642364809e+01,
		1.636182604910648e+01,		1.648491986442250e+01,		1.660772876682010e+01,		1.673025365288798e+01,		1.685249541851773e+01,
		1.697445495884300e+01,		1.709613316818007e+01,		1.721753093996969e+01,		1.733864916672003e+01,		1.745948873995102e+01,
		1.758005055013985e+01,		1.770033548666771e+01,		1.782034443776773e+01,		1.794007829047416e+01,		1.805953793057275e+01,
		1.817872424255224e+01,		1.829763810955712e+01,		1.841628041334151e+01,		1.853465203422418e+01,		1.865275385104471e+01,
		1.877058674112079e+01,		1.888815158020664e+01,		1.900544924245247e+01,		1.912248060036512e+01,		1.923924652476961e+01,
		1.935574788477195e+01,		1.947198554772283e+01,		1.958796037918236e+01,		1.970367324288591e+01,		1.981912500071081e+01,
		1.993431651264417e+01,		2.004924863675151e+01,		2.016392222914647e+01,		2.027833814396140e+01,		2.039249723331885e+01,
		2.050640034730398e+01,		2.062004833393786e+01,		2.073344203915167e+01,		2.084658230676165e+01,		2.095946997844502e+01,
		2.107210589371667e+01,		2.118449088990661e+01,		2.129662580213833e+01,		2.140851146330778e+01,		2.152014870406330e+01,
		2.163153835278617e+01,		2.174268123557189e+01,		2.185357817621229e+01,		2.196422999617825e+01,		2.207463751460311e+01,
		2.218480154826686e+01,		2.229472291158083e+01,		2.240440241657319e+01,		2.251384087287501e+01,		2.262303908770694e+01,
		2.273199786586646e+01,		2.284071800971586e+01,		2.294920031917071e+01,		2.305744559168880e+01,		2.316545462225990e+01,
		2.327322820339579e+01,		2.338076712512099e+01,		2.348807217496398e+01,		2.359514413794889e+01,		2.370198379658769e+01,
		2.380859193087293e+01,		2.391496931827084e+01,		2.402111673371503e+01,		2.412703494960055e+01,		2.423272473577835e+01,
		2.433818685955028e+01,		2.444342208566450e+01,		2.454843117631114e+01,		2.465321489111860e+01,		2.475777398715001e+01,
		2.486210921890023e+01,		2.496622133829316e+01,		2.507011109467935e+01,		2.517377923483413e+01,		2.527722650295583e+01,
		2.538045364066461e+01,		2.548346138700133e+01,		2.558625047842705e+01,		2.568882164882253e+01,		2.579117562948820e+01,
		2.589331314914441e+01,		2.599523493393193e+01,		2.609694170741271e+01,		2.619843419057092e+01,		2.629971310181429e+01,
		2.640077915697563e+01,		2.650163306931467e+01,		2.660227554952007e+01,		2.670270730571167e+01,		2.680292904344304e+01,
		2.690294146570415e+01,		2.700274527292430e+01,		2.710234116297521e+01,		2.720172983117445e+01,		2.730091197028883e+01,
		2.739988827053817e+01,		2.749865941959917e+01,		2.759722610260948e+01,		2.769558900217192e+01,		2.779374879835883e+01,
		2.789170616871671e+01,		2.798946178827085e+01,		2.808701632953021e+01,		2.818437046249241e+01,		2.828152485464890e+01,
		2.837848017099015e+01,		2.847523707401117e+01,		2.857179622371692e+01,		2.866815827762801e+01,		2.876432389078650e+01,
		2.886029371576169e+01,		2.895606840265620e+01,		2.905164859911194e+01,		2.914703495031648e+01,		2.924222809900913e+01,
		2.933722868548749e+01,		2.943203734761380e+01,		2.952665472082160e+01,		2.962108143812230e+01,		2.971531813011192e+01,
		2.980936542497789e+01,		2.990322394850593e+01,		2.999689432408695e+01,		3.009037717272412e+01,		3.018367311303989e+01,
		3.027678276128315e+01,		3.036970673133641e+01,		3.046244563472306e+01,		3.055500008061465e+01,		3.064737067583826e+01,
		3.073955802488395e+01,		3.083156272991206e+01,		3.092338539076087e+01,		3.101502660495407e+01,		3.110648696770826e+01,
		3.119776707194068e+01,		3.128886750827678e+01,		3.137978886505789e+01,		3.147053172834902e+01,		3.156109668194644e+01,
		3.165148430738559e+01,		3.174169518394883e+01,		3.183172988867317e+01,		3.192158899635824e+01,		3.201127307957405e+01,
		3.210078270866889e+01,		3.219011845177726e+01,		3.227928087482764e+01,		3.236827054155066e+01,		3.245708801348676e+01,
		3.254573384999428e+01,		3.263420860825749e+01,		3.272251284329435e+01,		3.281064710796458e+01,		3.289861195297770e+01,
		3.298640792690096e+01,		3.307403557616722e+01,		3.316149544508313e+01,		3.324878807583700e+01,		3.333591400850674e+01,
		3.342287378106801e+01,		3.350966792940203e+01,		3.359629698730369e+01,		3.368276148648948e+01,		3.376906195660543e+01,
		3.385519892523514e+01,		3.394117291790774e+01,		3.402698445810580e+01,		3.411263406727328e+01,		3.419812226482357e+01,
		3.428344956814722e+01,		3.436861649262010e+01,		3.445362355161114e+01,		3.453847125649028e+01,		3.462316011663632e+01,
		3.470769063944489e+01,		3.479206333033622e+01,		3.487627869276298e+01,		3.496033722821819e+01,		3.504423943624298e+01,
		3.512798581443434e+01,		3.521157685845304e+01,		3.529501306203127e+01,		3.537829491698046e+01,		3.546142291319899e+01,
		3.554439753867991e+01,		3.562721927951863e+01,		3.570988861992060e+01,		3.579240604220900e+01,		3.587477202683232e+01,
		3.595698705237202e+01,		3.603905159555016e+01,		3.612096613123689e+01,		3.620273113245809e+01,		3.628434707040287e+01,
		3.636581441443109e+01,		3.644713363208088e+01,		3.652830518907604e+01,		3.660932954933363e+01,		3.669020717497123e+01,
		3.677093852631445e+01,		3.685152406190428e+01,		3.693196423850448e+01,		3.701225951110888e+01,		3.709241033294870e+01,
		3.717241715549983e+01,		3.725228042849015e+01,		3.733200059990671e+01,		3.741157811600297e+01,		3.749101342130598e+01,
		3.757030695862358e+01,		3.764945916905150e+01,		3.772847049198057e+01,		3.780734136510364e+01,		3.788607222442285e+01,
		3.796466350425657e+01,		3.804311563724641e+01,		3.812142905436423e+01,		3.819960418491917e+01,		3.827764145656449e+01,
		3.835554129530460e+01,		3.843330412550183e+01,		3.851093036988343e+01,		3.858842044954833e+01,		3.866577478397394e+01,
		3.874299379102303e+01,		3.882007788695041e+01,		3.889702748640974e+01,		3.897384300246019e+01,		3.905052484657312e+01,
		3.912707342863885e+01,		3.920348915697317e+01,		3.927977243832401e+01,		3.935592367787801e+01,		3.943194327926717e+01,
		3.950783164457518e+01,		3.958358917434417e+01,		3.965921626758101e+01,		3.973471332176392e+01,		3.981008073284872e+01,
		3.988531889527546e+01,		3.996042820197456e+01,		4.003540904437337e+01,		4.011026181240236e+01,		4.018498689450159e+01,
		4.025958467762674e+01,		4.033405554725560e+01,		4.040839988739419e+01,		4.048261808058296e+01,		4.055671050790296e+01,
		4.063067754898211e+01,		4.070451958200115e+01,		4.077823698369986e+01,		4.085183012938310e+01,		4.092529939292686e+01,
		4.099864514678433e+01,		4.107186776199180e+01,		4.114496760817476e+01,		4.121794505355377e+01,		4.129080046495044e+01,
		4.136353420779324e+01,		4.143614664612354e+01,		4.150863814260123e+01,		4.158100905851087e+01,		4.165325975376710e+01,
		4.172539058692083e+01,		4.179740191516463e+01,		4.186929409433874e+01,		4.194106747893658e+01,		4.201272242211059e+01,
		4.208425927567776e+01,		4.215567839012537e+01,		4.222698011461645e+01,		4.229816479699562e+01,		4.236923278379439e+01,
		4.244018442023683e+01,		4.251102005024511e+01,		4.258174001644490e+01,		4.265234466017090e+01,		4.272283432147232e+01,
		4.279320933911820e+01,		4.286347005060290e+01,		4.293361679215143e+01,		4.300364989872480e+01,		4.307356970402542e+01,
		4.314337654050231e+01,		4.321307073935642e+01,		4.328265263054593e+01,		4.335212254279144e+01,		4.342148080358123e+01,
		4.349072773917637e+01,		4.355986367461605e+01,		4.362888893372251e+01,		4.369780383910636e+01,		4.376660871217161e+01,
		4.383530387312073e+01,		4.390388964095977e+01,		4.397236633350330e+01,		4.404073426737953e+01,		4.410899375803533e+01,
		4.417714511974100e+01,		4.424518866559548e+01,		4.431312470753110e+01,		4.438095355631859e+01,		4.444867552157187e+01,
		4.451629091175305e+01,		4.458380003417718e+01,		4.465120319501701e+01,		4.471850069930800e+01,		4.478569285095296e+01,
		4.485277995272673e+01,		4.491976230628114e+01,		4.498664021214956e+01,		4.505341396975165e+01,		4.512008387739806e+01,
		4.518665023229509e+01,		4.525311333054925e+01,		4.531947346717199e+01,		4.538573093608422e+01,		4.545188603012091e+01,
		4.551793904103570e+01,		4.558389025950529e+01,		4.564973997513417e+01,		4.571548847645893e+01,		4.578113605095283e+01,
		4.584668298503027e+01,		4.591212956405116e+01,		4.597747607232544e+01,		4.604272279311736e+01,		4.610787000864996e+01,
		4.617291800010942e+01,		4.623786704764932e+01,		4.630271743039507e+01,		4.636746942644816e+01,		4.643212331289048e+01,
		4.649667936578848e+01,		4.656113786019764e+01,		4.662549907016644e+01,		4.668976326874074e+01,		4.675393072796795e+01,
		4.681800171890114e+01,		4.688197651160330e+01,		4.694585537515135e+01,		4.700963857764037e+01,		4.707332638618764e+01,
		4.713691906693677e+01,		4.720041688506169e+01,		4.726382010477082e+01,		4.732712898931095e+01,		4.739034380097139e+01,
		4.745346480108785e+01,		4.751649225004657e+01,		4.757942640728807e+01,		4.764226753131125e+01,		4.770501587967732e+01,
		4.776767170901355e+01,		4.783023527501742e+01,		4.789270683246017e+01,		4.795508663519097e+01,		4.801737493614056e+01,
		4.807957198732510e+01,		4.814167803985008e+01,		4.820369334391400e+01,		4.826561814881219e+01,		4.832745270294048e+01,
		4.838919725379917e+01,		4.845085204799648e+01,		4.851241733125236e+01,		4.857389334840229e+01,		4.863528034340076e+01,
		4.869657855932507e+01,		4.875778823837893e+01,		4.881890962189612e+01,		4.887994295034396e+01,		4.894088846332706e+01,
		4.900174639959088e+01,		4.906251699702519e+01,		4.912320049266774e+01,		4.918379712270769e+01,		4.924430712248917e+01
	},
	{
		8.063588576943825e-02,		2.417865956015376e-01,		4.025610475892939e-01,		5.629601158126574e-01,		7.229846547794518e-01,
		8.826355008626020e-01,		1.041913473668654e+00,		1.200819377340325e+00,		1.359354001795696e+00,		1.517518123906561e+00,
		1.675312508618367e+00,		1.832737910014053e+00,		1.989795072324034e+00,		2.146484730884478e+00,		2.302807613045946e+00,
		2.458764439034393e+00,		2.614355922766438e+00,		2.769582772620758e+00,		2.924445692167383e+00,		3.078945380856604e+00,
		3.233082534669145e+00,		3.386857846729186e+00,		3.540272007881795e+00,		3.693325707236191e+00,		3.846019632676330e+00,
		3.998354471340134e+00,		4.150330910068715e+00,		4.301949635826852e+00,		4.453211336095964e+00,		4.604116699240755e+00,
		4.754666414850694e+00,		4.904861174057372e+00,		5.054701669828892e+00,		5.204188597242229e+00,		5.353322653734595e+00,
		5.502104539334726e+00,		5.650534956875047e+00,		5.798614612185570e+00,		5.946344214270366e+00,		6.093724475467450e+00,
		6.240756111592874e+00,		6.387439842069743e+00,		6.533776390042956e+00,		6.679766482480291e+00,		6.825410850260577e+00,
		6.970710228249589e+00,		7.115665355364271e+00,		7.260276974625893e+00,		7.404545833202769e+00,		7.548472682443003e+00,
		7.692058277897911e+00,		7.835303379336518e+00,		7.978208750751703e+00,		8.120775160358461e+00,		8.263003380584680e+00,
		8.404894188054932e+00,		8.546448363567679e+00,		8.687666692066271e+00,		8.828549962604152e+00,		8.969098968304641e+00,
		9.109314506315616e+00,		9.249197377759467e+00,		9.388748387678643e+00,		9.527968344977063e+00,		9.666858062357768e+00,
		9.805418356256986e+00,		9.943650046775007e+00,		1.008155395760402e+01,		1.021913091595323e+01,		1.035638175247144e+01,
		1.049330730116739e+01,		1.062990839932797e+01,		1.076618588743463e+01,		1.090214060907808e+01,		1.103777341087154e+01,
		1.117308514236261e+01,		1.130807665594410e+01,		1.144274880676385e+01,		1.157710245263366e+01,		1.171113845393762e+01,
		1.184485767353984e+01,		1.197826097669179e+01,		1.211134923093935e+01,		1.224412330602963e+01,		1.237658407381778e+01,
		1.250873240817380e+01,		1.264056918488946e+01,		1.277209528158552e+01,		1.290331157761914e+01,		1.303421895399180e+01,
		1.316481829325757e+01,		1.329511047943200e+01,		1.342509639790160e+01,		1.355477693533392e+01,		1.368415297958842e+01,
		1.381322541962813e+01,		1.394199514543204e+01,		1.407046304790847e+01,		1.419863001880931e+01,		1.432649695064517e+01,
		1.445406473660166e+01,		1.458133427045651e+01,		1.470830644649793e+01,		1.483498215944390e+01,		1.496136230436270e+01,
		1.508744777659447e+01,		1.521323947167400e+01,		1.533873828525461e+01,		1.546394511303333e+01,		1.558886085067717e+01,
		1.571348639375064e+01,		1.583782263764459e+01,		1.596187047750603e+01,		1.608563080816954e+01,		1.620910452408962e+01,
		1.633229251927438e+01,		1.645519568722060e+01,		1.657781492084986e+01,		1.670015111244604e+01,		1.682220515359398e+01,
		1.694397793511948e+01,		1.706547034703047e+01,		1.718668327845942e+01,		1.730761761760705e+01,		1.742827425168714e+01,
		1.754865406687269e+01,		1.766875794824317e+01,		1.778858677973312e+01,		1.790814144408172e+01,		1.802742282278378e+01,
		1.814643179604173e+01,		1.826516924271881e+01,		1.838363604029347e+01,		1.850183306481484e+01,		1.861976119085930e+01,
		1.873742129148826e+01,		1.885481423820692e+01,		1.897194090092422e+01,		1.908880214791374e+01,		1.920539884577579e+01,
		1.932173185940041e+01,		1.943780205193149e+01,		1.955361028473187e+01,		1.966915741734944e+01,		1.978444430748418e+01,
		1.989947181095627e+01,		2.001424078167501e+01,		2.012875207160883e+01,		2.024300653075611e+01,		2.035700500711689e+01,
		2.047074834666567e+01,		2.058423739332476e+01,		2.069747298893883e+01,		2.081045597325004e+01,		2.092318718387419e+01,
		2.103566745627753e+01,		2.114789762375447e+01,		2.125987851740613e+01,		2.137161096611946e+01,		2.148309579654733e+01,
		2.159433383308922e+01,		2.170532589787275e+01,		2.181607281073580e+01,		2.192657538920942e+01,		2.203683444850144e+01,
		2.214685080148063e+01,		2.225662525866165e+01,		2.236615862819055e+01,		2.247545171583102e+01,		2.258450532495108e+01,
		2.269332025651052e+01,		2.280189730904889e+01,		2.291023727867401e+01,		2.301834095905115e+01,		2.312620914139264e+01,
		2.323384261444818e+01,		2.334124216449547e+01,		2.344840857533154e+01,		2.355534262826452e+01,		2.366204510210580e+01,
		2.376851677316290e+01,		2.387475841523257e+01,		2.398077079959449e+01,		2.408655469500538e+01,		2.419211086769353e+01,
		2.429744008135379e+01,		2.440254309714294e+01,		2.450742067367550e+01,		2.461207356701991e+01,		2.471650253069507e+01,
		2.482070831566736e+01,		2.492469167034786e+01,		2.502845334059011e+01,		2.513199406968807e+01,		2.523531459837448e+01,
		2.533841566481957e+01,		2.544129800463008e+01,		2.554396235084850e+01,		2.564640943395278e+01,		2.574863998185619e+01,
		2.585065471990760e+01,		2.595245437089183e+01,		2.605403965503058e+01,		2.615541128998329e+01,		2.625656999084855e+01,
		2.635751647016556e+01,		2.645825143791589e+01,		2.655877560152556e+01,		2.665908966586718e+01,		2.675919433326250e+01,
		2.685909030348504e+01,		2.695877827376298e+01,		2.705825893878225e+01,		2.715753299068984e+01,		2.725660111909719e+01,
		2.735546401108401e+01,		2.745412235120196e+01,		2.755257682147874e+01,		2.765082810142232e+01,		2.774887686802516e+01,
		2.784672379576887e+01,		2.794436955662873e+01,		2.804181482007860e+01,		2.813906025309582e+01,		2.823610652016630e+01,
		2.833295428328974e+01,		2.842960420198499e+01,		2.852605693329558e+01,		2.862231313179521e+01,		2.871837344959352e+01,
		2.881423853634193e+01,		2.890990903923956e+01,		2.900538560303923e+01,		2.910066887005367e+01,		2.919575948016171e+01,
		2.929065807081457e+01,		2.938536527704240e+01,		2.947988173146063e+01,		2.957420806427667e+01,		2.966834490329652e+01,
		2.976229287393154e+01,		2.985605259920526e+01,		2.994962469976024e+01,		3.004300979386502e+01,		3.013620849742123e+01,
		3.022922142397049e+01,		3.032204918470176e+01,		3.041469238845835e+01,		3.050715164174527e+01,		3.059942754873646e+01,
		3.069152071128222e+01,		3.078343172891650e+01,		3.087516119886446e+01,		3.096670971604980e+01,		3.105807787310238e+01,
		3.114926626036577e+01,		3.124027546590475e+01,		3.133110607551304e+01,		3.142175867272087e+01,		3.151223383880273e+01,
		3.160253215278500e+01,		3.169265419145377e+01,		3.178260052936250e+01,		3.187237173883992e+01,		3.196196838999770e+01,
		3.205139105073835e+01,		3.214064028676304e+01,		3.222971666157945e+01,		3.231862073650962e+01,		3.240735307069782e+01,
		3.249591422111849e+01,		3.258430474258410e+01,		3.267252518775305e+01,		3.276057610713761e+01,		3.284845804911179e+01,
		3.293617155991936e+01,		3.302371718368167e+01,		3.311109546240569e+01,		3.319830693599182e+01,		3.328535214224195e+01,
		3.337223161686732e+01,		3.345894589349643e+01,		3.354549550368306e+01,		3.363188097691408e+01,		3.371810284061751e+01,
		3.380416162017028e+01,		3.389005783890625e+01,		3.397579201812410e+01,		3.406136467709519e+01,		3.414677633307142e+01,
		3.423202750129322e+01,		3.431711869499732e+01,		3.440205042542460e+01,		3.448682320182803e+01,		3.457143753148039e+01,
		3.465589391968219e+01,		3.474019286976939e+01,		3.482433488312126e+01,		3.490832045916814e+01,		3.499215009539918e+01,
		3.507582428737012e+01,		3.515934352871105e+01,		3.524270831113404e+01,		3.532591912444091e+01,		3.540897645653092e+01,
		3.549188079340836e+01,		3.557463261919033e+01,		3.565723241611418e+01,		3.573968066454533e+01,		3.582197784298471e+01,
		3.590412442807638e+01,		3.598612089461511e+01,		3.606796771555381e+01,		3.614966536201121e+01,		3.623121430327922e+01,
		3.631261500683035e+01,		3.639386793832536e+01,		3.647497356162050e+01,		3.655593233877498e+01,		3.663674473005833e+01,
		3.671741119395783e+01,		3.679793218718571e+01,		3.687830816468662e+01,		3.695853957964482e+01,		3.703862688349142e+01,
		3.711857052591174e+01,		3.719837095485246e+01,		3.727802861652876e+01,		3.735754395543161e+01,		3.743691741433483e+01,
		3.751614943430224e+01,		3.759524045469480e+01,		3.767419091317758e+01,		3.775300124572694e+01,		3.783167188663745e+01,
		3.791020326852897e+01,		3.798859582235357e+01,		3.806684997740251e+01,		3.814496616131311e+01,		3.822294480007578e+01,
		3.830078631804078e+01,		3.837849113792507e+01,		3.845605968081922e+01,		3.853349236619416e+01,		3.861078961190793e+01,
		3.868795183421246e+01,		3.876497944776032e+01,		3.884187286561136e+01,		3.891863249923942e+01,		3.899525875853899e+01,
		3.907175205183178e+01,		3.914811278587337e+01,		3.922434136585976e+01,		3.930043819543392e+01,		3.937640367669232e+01,
		3.945223821019138e+01,		3.952794219495397e+01,		3.960351602847591e+01,		3.967896010673227e+01,		3.975427482418385e+01,
		3.982946057378351e+01,		3.990451774698259e+01,		3.997944673373707e+01,		4.005424792251400e+01,		4.012892170029772e+01,
		4.020346845259608e+01,		4.027788856344668e+01,		4.035218241542306e+01,		4.042635038964086e+01,		4.050039286576394e+01,
		4.057431022201052e+01,		4.064810283515929e+01,		4.072177108055538e+01,		4.079531533211654e+01,		4.086873596233902e+01,
		4.094203334230365e+01,		4.101520784168175e+01,		4.108825982874109e+01,		4.116118967035187e+01,		4.123399773199246e+01,
		4.130668437775542e+01,		4.137924997035327e+01,		4.145169487112423e+01,		4.152401944003823e+01,		4.159622403570243e+01,
		4.166830901536714e+01,		4.174027473493147e+01,		4.181212154894899e+01,		4.188384981063350e+01,		4.195545987186460e+01,
		4.202695208319333e+01,		4.209832679384777e+01,		4.216958435173866e+01,		4.224072510346488e+01,		4.231174939431902e+01,
		4.238265756829288e+01,		4.245344996808297e+01,		4.252412693509594e+01,		4.259468880945399e+01,		4.266513593000037e+01,
		4.273546863430465e+01,		4.280568725866825e+01,		4.287579213812958e+01,		4.294578360646953e+01,		4.301566199621671e+01,
		4.308542763865262e+01,		4.315508086381711e+01,		4.322462200051343e+01,		4.329405137631354e+01,		4.336336931756320e+01,
		4.343257614938727e+01,		4.350167219569465e+01,		4.357065777918366e+01,		4.363953322134687e+01,		4.370829884247635e+01,
		4.377695496166866e+01,		4.384550189682984e+01,		4.391393996468055e+01,		4.398226948076087e+01,		4.405049075943539e+01,
		4.411860411389817e+01,		4.418660985617758e+01,		4.425450829714120e+01,		4.432229974650078e+01,		4.438998451281706e+01,
		4.445756290350455e+01,		4.452503522483644e+01,		4.459240178194928e+01,		4.465966287884793e+01,		4.472681881841010e+01,
		4.479386990239122e+01,		4.486081643142914e+01,		4.492765870504875e+01,		4.499439702166678e+01,		4.506103167859626e+01,
		4.512756297205134e+01,		4.519399119715175e+01,		4.526031664792757e+01,		4.532653961732355e+01,		4.539266039720388e+01,
		4.545867927835666e+01,		4.552459655049829e+01,		4.559041250227813e+01,		4.565612742128286e+01,		4.572174159404102e+01,
		4.578725530602731e+01,		4.585266884166714e+01,		4.591798248434097e+01,		4.598319651638864e+01,		4.604831121911378e+01,
		4.611332687278813e+01,		4.617824375665584e+01,		4.624306214893781e+01,		4.630778232683592e+01,		4.637240456653732e+01,
		4.643692914321864e+01,		4.650135633105027e+01,		4.656568640320050e+01,		4.662991963183973e+01,		4.669405628814469e+01,
		4.675809664230251e+01,		4.682204096351482e+01,		4.688588952000204e+01,		4.694964257900731e+01,		4.701330040680057e+01,
		4.707686326868273e+01,		4.714033142898961e+01,		4.720370515109603e+01,		4.726698469741976e+01,		4.733017032942552e+01,
		4.739326230762902e+01,		4.745626089160078e+01,		4.751916633997022e+01,		4.758197891042947e+01,		4.764469885973723e+01,
		4.770732644372287e+01,		4.776986191729005e+01,		4.783230553442070e+01,		4.789465754817881e+01,		4.795691821071429e+01,
		4.801908777326676e+01,		4.808116648616925e+01,		4.814315459885209e+01,		4.820505235984655e+01,		4.826686001678867e+01,
		4.832857781642294e+01,		4.839020600460590e+01,		4.845174482631000e+01,		4.851319452562717e+01,		4.857455534577246e+01,
		4.863582752908771e+01,		4.869701131704515e+01,		4.875810695025104e+01,		4.881911466844918e+01,		4.888003471052458e+01,
		4.894086731450695e+01,		4.900161271757425e+01,		4.906227115605622e+01,		4.912284286543791e+01,		4.918332808036317e+01
	},
	{
		8.047445529759953e-02,		2.413028874606722e-01,		4.017562708164742e-01,		5.618354791043093e-01,		7.215413666483638e-01,
		8.808747697779722e-01,		1.039836508180096e+00,		1.198427386186702e+00,		1.356648193999624e+00,		1.514499708855392e+00,
		1.671982696132397e+00,		1.829097910402717e+00,		1.985846096430765e+00,		2.142227990120920e+00,		2.298244319416155e+00,
		2.453895805149634e+00,		2.609183161851180e+00,		2.764107098510414e+00,		2.918668319298338e+00,		3.072867524249043e+00,
		3.226705409903164e+00,		3.380182669914669e+00,		3.533299995622473e+00,		3.686058076588342e+00,		3.838457601102502e+00,
		3.990499256658290e+00,		4.142183730397156e+00,		4.293511709525281e+00,		4.444483881703023e+00,		4.595100935408346e+00,
		4.745363560275382e+00,		4.895272447409188e+00,		5.044828289677762e+00,		5.194031781982324e+00,		5.342883621506838e+00,
		5.491384507947676e+00,		5.639535143724406e+00,		5.787336234172494e+00,		5.934788487718794e+00,		6.081892616040643e+00,
		6.228649334209316e+00,		6.375059360818603e+00,		6.521123418099232e+00,		6.666842232019818e+00,		6.812216532375010e+00,
		6.957247052861511e+00,		7.101934531142523e+00,		7.246279708901286e+00,		7.390283331884202e+00,		7.533946149934210e+00,
		7.677268917014795e+00,		7.820252391225261e+00,		7.962897334807685e+00,		8.105204514146052e+00,		8.247174699758016e+00,
		8.388808666279719e+00,		8.530107192444024e+00,		8.671071061052730e+00,		8.811701058942891e+00,		8.951997976947860e+00,
		9.091962609853208e+00,		9.231595756348023e+00,		9.370898218971739e+00,		9.509870804056956e+00,		9.648514321668427e+00,
		9.786829585538579e+00,		9.924817412999772e+00,		1.006247862491362e+01,		1.019981404559751e+01,		1.033682450274868e+01,
		1.047351082736603e+01,		1.060987385366980e+01,		1.074591441901945e+01,		1.088163336382988e+01,		1.101703153148607e+01,
		1.115210976825655e+01,		1.128686892320561e+01,		1.142130984810459e+01,		1.155543339734232e+01,		1.168924042783486e+01,
		1.182273179893468e+01,		1.195590837233941e+01,		1.208877101200032e+01,		1.222132058403055e+01,		1.235355795661329e+01,
		1.248548399990995e+01,		1.261709958596849e+01,		1.274840558863188e+01,		1.287940288344696e+01,		1.301009234757351e+01,
		1.314047485969396e+01,		1.327055129992344e+01,		1.340032254972051e+01,		1.352978949179851e+01,		1.365895301003763e+01,
		1.378781398939769e+01,		1.391637331583179e+01,		1.404463187620073e+01,		1.417259055818844e+01,		1.430025025021819e+01,
		1.442761184136994e+01,		1.455467622129859e+01,		1.468144428015325e+01,		1.480791690849767e+01,		1.493409499723168e+01,
		1.505997943751374e+01,		1.518557112068471e+01,		1.531087093819262e+01,		1.543587978151876e+01,		1.556059854210485e+01,
		1.568502811128146e+01,		1.580916938019757e+01,		1.593302323975139e+01,		1.605659058052242e+01,		1.617987229270466e+01,
		1.630286926604108e+01,		1.642558238975935e+01,		1.654801255250873e+01,		1.667016064229833e+01,		1.679202754643637e+01,
		1.691361415147090e+01,		1.703492134313158e+01,		1.715595000627279e+01,		1.727670102481785e+01,		1.739717528170453e+01,
		1.751737365883173e+01,		1.763729703700731e+01,		1.775694629589719e+01,		1.787632231397555e+01,		1.799542596847621e+01,
		1.811425813534520e+01,		1.823281968919443e+01,		1.835111150325651e+01,		1.846913444934069e+01,		1.858688939778989e+01,
		1.870437721743887e+01,		1.882159877557342e+01,		1.893855493789069e+01,		1.905524656846049e+01,		1.917167452968771e+01,
		1.928783968227575e+01,		1.940374288519091e+01,		1.951938499562782e+01,		1.963476686897594e+01,		1.974988935878682e+01,
		1.986475331674252e+01,		1.997935959262488e+01,		2.009370903428573e+01,		2.020780248761799e+01,		2.032164079652770e+01,
		2.043522480290692e+01,		2.054855534660749e+01,		2.066163326541563e+01,		2.077445939502744e+01,		2.088703456902514e+01,
		2.099935961885411e+01,		2.111143537380090e+01,		2.122326266097169e+01,		2.133484230527188e+01,		2.144617512938616e+01,
		2.155726195375943e+01,		2.166810359657842e+01,		2.177870087375405e+01,		2.188905459890437e+01,		2.199916558333831e+01,
		2.210903463604005e+01,		2.221866256365398e+01,		2.232805017047041e+01,		2.243719825841177e+01,		2.254610762701957e+01,
		2.265477907344183e+01,		2.276321339242113e+01,		2.287141137628329e+01,		2.297937381492655e+01,		2.308710149581132e+01,
		2.319459520395045e+01,		2.330185572190000e+01,		2.340888382975061e+01,		2.351568030511929e+01,		2.362224592314171e+01,
		2.372858145646496e+01,		2.383468767524083e+01,		2.394056534711949e+01,		2.404621523724363e+01,		2.415163810824301e+01,
		2.425683472022946e+01,		2.436180583079233e+01,		2.446655219499425e+01,		2.457107456536733e+01,		2.467537369190977e+01,
		2.477945032208280e+01,		2.488330520080800e+01,		2.498693907046495e+01,		2.509035267088927e+01,		2.519354673937098e+01,
		2.529652201065315e+01,		2.539927921693093e+01,		2.550181908785082e+01,		2.560414235051028e+01,		2.570624972945770e+01,
		2.580814194669251e+01,		2.590981972166567e+01,		2.601128377128044e+01,		2.611253480989330e+01,		2.621357354931530e+01,
		2.631440069881351e+01,		2.641501696511276e+01,		2.651542305239764e+01,		2.661561966231471e+01,		2.671560749397489e+01,
		2.681538724395612e+01,		2.691495960630627e+01,		2.701432527254608e+01,		2.711348493167251e+01,		2.721243927016210e+01,
		2.731118897197467e+01,		2.740973471855702e+01,		2.750807718884699e+01,		2.760621705927761e+01,		2.770415500378131e+01,
		2.780189169379448e+01,		2.789942779826205e+01,		2.799676398364219e+01,		2.809390091391131e+01,		2.819083925056906e+01,
		2.828757965264349e+01,		2.838412277669635e+01,		2.848046927682859e+01,		2.857661980468577e+01,		2.867257500946385e+01,
		2.876833553791490e+01,		2.886390203435303e+01,		2.895927514066026e+01,		2.905445549629280e+01,		2.914944373828702e+01,
		2.924424050126589e+01,		2.933884641744526e+01,		2.943326211664031e+01,		2.952748822627215e+01,		2.962152537137432e+01,
		2.971537417459960e+01,		2.980903525622666e+01,		2.990250923416699e+01,		2.999579672397170e+01,		3.008889833883855e+01,
		3.018181468961896e+01,		3.027454638482509e+01,		3.036709403063692e+01,		3.045945823090957e+01,		3.055163958718036e+01,
		3.064363869867629e+01,		3.073545616232124e+01,		3.082709257274341e+01,		3.091854852228269e+01,		3.100982460099821e+01,
		3.110092139667576e+01,		3.119183949483532e+01,		3.128257947873866e+01,		3.137314192939694e+01,		3.146352742557831e+01,
		3.155373654381556e+01,		3.164376985841382e+01,		3.173362794145823e+01,		3.182331136282174e+01,		3.191282069017273e+01,
		3.200215648898288e+01,		3.209131932253488e+01,		3.218030975193030e+01,		3.226912833609731e+01,		3.235777563179856e+01,
		3.244625219363903e+01,		3.253455857407378e+01,		3.262269532341596e+01,		3.271066298984447e+01,		3.279846211941202e+01,
		3.288609325605285e+01,		3.297355694159072e+01,		3.306085371574671e+01,		3.314798411614713e+01,		3.323494867833138e+01,
		3.332174793575988e+01,		3.340838241982188e+01,		3.349485265984339e+01,		3.358115918309502e+01,		3.366730251479984e+01,
		3.375328317814132e+01,		3.383910169427107e+01,		3.392475858231678e+01,		3.401025435939001e+01,		3.409558954059408e+01,
		3.418076463903182e+01,		3.426578016581346e+01,		3.435063663006440e+01,		3.443533453893299e+01,		3.451987439759831e+01,
		3.460425670927805e+01,		3.468848197523607e+01,		3.477255069479029e+01,		3.485646336532039e+01,		3.494022048227551e+01,
		3.502382253918195e+01,		3.510727002765084e+01,		3.519056343738586e+01,		3.527370325619081e+01,		3.535668996997730e+01,
		3.543952406277241e+01,		3.552220601672614e+01,		3.560473631211917e+01,		3.568711542737029e+01,		3.576934383904396e+01,
		3.585142202185795e+01,		3.593335044869066e+01,		3.601512959058876e+01,		3.609675991677454e+01,		3.617824189465345e+01,
		3.625957598982139e+01,		3.634076266607229e+01,		3.642180238540536e+01,		3.650269560803242e+01,		3.658344279238533e+01,
		3.666404439512330e+01,		3.674450087114008e+01,		3.682481267357129e+01,		3.690498025380168e+01,		3.698500406147237e+01,
		3.706488454448793e+01,		3.714462214902370e+01,		3.722421731953286e+01,		3.730367049875355e+01,		3.738298212771603e+01,
		3.746215264574967e+01,		3.754118249049012e+01,		3.762007209788626e+01,		3.769882190220716e+01,		3.777743233604927e+01,
		3.785590383034310e+01,		3.793423681436035e+01,		3.801243171572077e+01,		3.809048896039898e+01,		3.816840897273141e+01,
		3.824619217542307e+01,		3.832383898955446e+01,		3.840134983458820e+01,		3.847872512837591e+01,		3.855596528716490e+01,
		3.863307072560487e+01,		3.871004185675460e+01,		3.878687909208865e+01,		3.886358284150390e+01,		3.894015351332622e+01,
		3.901659151431706e+01,		3.909289724967999e+01,		3.916907112306718e+01,		3.924511353658598e+01,		3.932102489080538e+01,
		3.939680558476245e+01,		3.947245601596877e+01,		3.954797658041682e+01,		3.962336767258643e+01,		3.969862968545099e+01,
		3.977376301048397e+01,		3.984876803766503e+01,		3.992364515548648e+01,		3.999839475095930e+01,		4.007301720961966e+01,
		4.014751291553488e+01,		4.022188225130969e+01,		4.029612559809244e+01,		4.037024333558111e+01,		4.044423584202951e+01,
		4.051810349425331e+01,		4.059184666763611e+01,		4.066546573613544e+01,		4.073896107228879e+01,		4.081233304721957e+01,
		4.088558203064309e+01,		4.095870839087245e+01,		4.103171249482443e+01,		4.110459470802547e+01,		4.117735539461739e+01,
		4.124999491736332e+01,		4.132251363765344e+01,		4.139491191551079e+01,		4.146719010959705e+01,		4.153934857721823e+01,
		4.161138767433037e+01,		4.168330775554534e+01,		4.175510917413628e+01,		4.182679228204348e+01,		4.189835742987983e+01,
		4.196980496693647e+01,		4.204113524118829e+01,		4.211234859929964e+01,		4.218344538662965e+01,		4.225442594723782e+01,
		4.232529062388949e+01,		4.239603975806128e+01,		4.246667368994651e+01,		4.253719275846058e+01,		4.260759730124642e+01,
		4.267788765467975e+01,		4.274806415387452e+01,		4.281812713268810e+01,		4.288807692372664e+01,		4.295791385835036e+01,
		4.302763826667869e+01,		4.309725047759560e+01,		4.316675081875472e+01,		4.323613961658458e+01,		4.330541719629369e+01,
		4.337458388187569e+01,		4.344363999611455e+01,		4.351258586058945e+01,		4.358142179568010e+01,		4.365014812057159e+01,
		4.371876515325946e+01,		4.378727321055474e+01,		4.385567260808885e+01,		4.392396366031870e+01,		4.399214668053143e+01,
		4.406022198084943e+01,		4.412818987223530e+01,		4.419605066449653e+01,		4.426380466629053e+01,		4.433145218512934e+01,
		4.439899352738450e+01,		4.446642899829185e+01,		4.453375890195620e+01,		4.460098354135614e+01,		4.466810321834883e+01,
		4.473511823367457e+01,		4.480202888696151e+01,		4.486883547673045e+01,		4.493553830039930e+01,		4.500213765428779e+01,
		4.506863383362206e+01,		4.513502713253926e+01,		4.520131784409207e+01,		4.526750626025328e+01,		4.533359267192031e+01,
		4.539957736891965e+01,		4.546546064001142e+01,		4.553124277289379e+01,		4.559692405420746e+01,		4.566250476954002e+01,
		4.572798520343042e+01,		4.579336563937331e+01,		4.585864635982345e+01,		4.592382764620000e+01,		4.598890977889091e+01,
		4.605389303725713e+01,		4.611877769963703e+01,		4.618356404335061e+01,		4.624825234470372e+01,		4.631284287899231e+01,
		4.637733592050672e+01,		4.644173174253574e+01,		4.650603061737091e+01,		4.657023281631064e+01,		4.663433860966431e+01,
		4.669834826675648e+01,		4.676226205593089e+01,		4.682608024455464e+01,		4.688980309902221e+01,		4.695343088475951e+01,
		4.701696386622798e+01,		4.708040230692846e+01,		4.714374646940542e+01,		4.720699661525067e+01,		4.727015300510752e+01,
		4.733321589867468e+01,		4.739618555471015e+01,		4.745906223103518e+01,		4.752184618453808e+01,		4.758453767117820e+01,
		4.764713694598978e+01,		4.770964426308567e+01,		4.777205987566138e+01,		4.783438403599861e+01,		4.789661699546930e+01,
		4.795875900453927e+01,		4.802081031277199e+01,		4.808277116883232e+01,		4.814464182049030e+01,		4.820642251462479e+01,
		4.826811349722723e+01,		4.832971501340524e+01,		4.839122730738629e+01,		4.845265062252148e+01,		4.851398520128897e+01,
		4.857523128529773e+01,		4.863638911529109e+01,		4.869745893115034e+01,		4.875844097189824e+01,		4.881933547570268e+01,
		4.888014267988012e+01,		4.894086282089912e+01,		4.900149613438391e+01,		4.906204285511775e+01,		4.912250321704658e+01
	},
	{
		8.031367010421055e-02,		2.408211127302627e-01,		4.009547105974909e-01,		5.607153370673690e-01,		7.201038462415755e-01,
		8.791210743655353e-01,		1.037767841165071e+00,		1.196044951118821e+00,		1.353953194668965e+00,		1.511493349372709e+00,
		1.668666180996859e+00,		1.825472444557780e+00,		1.981912885308869e+00,		2.137988239677674e+00,		2.293699236154636e+00,
		2.449046596135421e+00,		2.604031034718678e+00,		2.758653261461042e+00,		2.912913981091096e+00,		3.066813894183969e+00,
		3.220353697798166e+00,		3.373534086076174e+00,		3.526355750810362e+00,		3.678819381975563e+00,		3.830925668229777e+00,
		3.982675297384281e+00,		4.134068956844478e+00,		4.285107334022686e+00,		4.435791116724091e+00,		4.586120993507000e+00,
		4.736097654018520e+00,		4.885721789306713e+00,		5.034994092110296e+00,		5.183915257126837e+00,		5.332485981260446e+00,
		5.480706963849855e+00,		5.628578906877798e+00,		5.776102515162553e+00,		5.923278496532444e+00,		6.070107561984142e+00,
		6.216590425825486e+00,		6.362727805803615e+00,		6.508520423219072e+00,		6.653969003026596e+00,		6.799074273923256e+00,
		6.943836968424561e+00,		7.088257822929138e+00,		7.232337577772608e+00,		7.376076977271172e+00,		7.519476769755488e+00,
		7.662537707595353e+00,		7.805260547215673e+00,		7.947646049104220e+00,		8.089694977811661e+00,		8.231408101944218e+00,
		8.372786194149514e+00,		8.513830031095878e+00,		8.654540393445636e+00,		8.794918065822625e+00,		8.934963836774413e+00,
		9.074678498729487e+00,		9.214062847949808e+00,		9.353117684478953e+00,		9.491843812086277e+00,		9.630242038207278e+00,
		9.768313173880468e+00,		9.906058033681060e+00,		1.004347743565168e+01,		1.018057220123035e+01,		1.031734315517599e+01,
		1.045379112549165e+01,		1.058991694334570e+01,		1.072572144299110e+01,		1.086120546168310e+01,		1.099636983959539e+01,
		1.113121541973494e+01,		1.126574304785569e+01,		1.139995357237133e+01,		1.153384784426709e+01,		1.166742671701099e+01,
		1.180069104646436e+01,		1.193364169079208e+01,		1.206627951037240e+01,		1.219860536770656e+01,		1.233062012732832e+01,
		1.246232465571354e+01,		1.259371982118977e+01,		1.272480649384611e+01,		1.285558554544329e+01,		1.298605784932409e+01,
		1.311622428032427e+01,		1.324608571468390e+01,		1.337564302995932e+01,		1.350489710493567e+01,		1.363384881954016e+01,
		1.376249905475603e+01,		1.389084869253734e+01,		1.401889861572452e+01,		1.414664970796088e+01,		1.427410285360997e+01,
		1.440125893767395e+01,		1.452811884571284e+01,		1.465468346376490e+01,		1.478095367826804e+01,		1.490693037598215e+01,
		1.503261444391277e+01,		1.515800676923562e+01,		1.528310823922245e+01,		1.540791974116790e+01,		1.553244216231763e+01,
		1.565667638979750e+01,		1.578062331054412e+01,		1.590428381123632e+01,		1.602765877822808e+01,		1.615074909748252e+01,
		1.627355565450713e+01,		1.639607933429019e+01,		1.651832102123845e+01,		1.664028159911596e+01,		1.676196195098416e+01,
		1.688336295914317e+01,		1.700448550507424e+01,		1.712533046938347e+01,		1.724589873174664e+01,		1.736619117085533e+01,
		1.748620866436415e+01,		1.760595208883912e+01,		1.772542231970734e+01,		1.784462023120769e+01,		1.796354669634272e+01,
		1.808220258683174e+01,		1.820058877306488e+01,		1.831870612405849e+01,		1.843655550741144e+01,		1.855413778926264e+01,
		1.867145383424957e+01,		1.878850450546792e+01,		1.890529066443231e+01,		1.902181317103792e+01,		1.913807288352336e+01,
		1.925407065843435e+01,		1.936980735058852e+01,		1.948528381304120e+01,		1.960050089705209e+01,		1.971545945205299e+01,
		1.983016032561644e+01,		1.994460436342527e+01,		2.005879240924308e+01,		2.017272530488561e+01,		2.028640389019303e+01,
		2.039982900300307e+01,		2.051300147912500e+01,		2.062592215231451e+01,		2.073859185424932e+01,		2.085101141450572e+01,
		2.096318166053576e+01,		2.107510341764543e+01,		2.118677750897338e+01,		2.129820475547056e+01,		2.140938597588055e+01,
		2.152032198672059e+01,		2.163101360226338e+01,		2.174146163451950e+01,		2.185166689322057e+01,		2.196163018580315e+01,
		2.207135231739311e+01,		2.218083409079078e+01,		2.229007630645677e+01,		2.239907976249829e+01,		2.250784525465609e+01,
		2.261637357629214e+01,		2.272466551837767e+01,		2.283272186948193e+01,		2.294054341576147e+01,		2.304813094094995e+01,
		2.315548522634844e+01,		2.326260705081636e+01,		2.336949719076275e+01,		2.347615642013818e+01,		2.358258551042718e+01,
		2.368878523064084e+01,		2.379475634731034e+01,		2.390049962448049e+01,		2.400601582370399e+01,		2.411130570403602e+01,
		2.421637002202921e+01,		2.432120953172914e+01,		2.442582498467007e+01,		2.453021712987126e+01,		2.463438671383346e+01,
		2.473833448053595e+01,		2.484206117143381e+01,		2.494556752545562e+01,		2.504885427900147e+01,		2.515192216594128e+01,
		2.525477191761351e+01,		2.535740426282415e+01,		2.545981992784598e+01,		2.556201963641820e+01,		2.566400410974629e+01,
		2.576577406650222e+01,		2.586733022282485e+01,		2.596867329232067e+01,		2.606980398606478e+01,		2.617072301260212e+01,
		2.627143107794894e+01,		2.637192888559450e+01,		2.647221713650306e+01,		2.657229652911603e+01,		2.667216775935436e+01,
		2.677183152062114e+01,		2.687128850380446e+01,		2.697053939728040e+01,		2.706958488691621e+01,		2.716842565607373e+01,
		2.726706238561305e+01,		2.736549575389612e+01,		2.746372643679079e+01,		2.756175510767491e+01,		2.765958243744053e+01,
		2.775720909449837e+01,		2.785463574478237e+01,		2.795186305175440e+01,		2.804889167640910e+01,		2.814572227727896e+01,
		2.824235551043929e+01,		2.833879202951364e+01,		2.843503248567909e+01,		2.853107752767173e+01,		2.862692780179234e+01,
		2.872258395191205e+01,		2.881804661947823e+01,		2.891331644352035e+01,		2.900839406065609e+01,		2.910328010509744e+01,
		2.919797520865689e+01,		2.929248000075378e+01,		2.938679510842070e+01,		2.948092115630996e+01,		2.957485876670012e+01,
		2.966860855950265e+01,		2.976217115226865e+01,		2.985554716019558e+01,		2.994873719613418e+01,		3.004174187059527e+01,
		3.013456179175681e+01,		3.022719756547088e+01,		3.031964979527078e+01,		3.041191908237813e+01,		3.050400602571014e+01,
		3.059591122188671e+01,		3.068763526523784e+01,		3.077917874781092e+01,		3.087054225937801e+01,		3.096172638744334e+01,
		3.105273171725074e+01,		3.114355883179108e+01,		3.123420831180980e+01,		3.132468073581443e+01,		3.141497668008221e+01,
		3.150509671866761e+01,		3.159504142341003e+01,		3.168481136394142e+01,		3.177440710769389e+01,		3.186382921990750e+01,
		3.195307826363788e+01,		3.204215479976400e+01,		3.213105938699591e+01,		3.221979258188248e+01,		3.230835493881917e+01,
		3.239674701005581e+01,		3.248496934570440e+01,		3.257302249374689e+01,		3.266090700004300e+01,		3.274862340833801e+01,
		3.283617226027064e+01,		3.292355409538075e+01,		3.301076945111731e+01,		3.309781886284610e+01,		3.318470286385764e+01,
		3.327142198537492e+01,		3.335797675656131e+01,		3.344436770452832e+01,		3.353059535434345e+01,		3.361666022903798e+01,
		3.370256284961484e+01,		3.378830373505634e+01,		3.387388340233204e+01,		3.395930236640645e+01,		3.404456114024690e+01,
		3.412966023483128e+01,		3.421460015915578e+01,		3.429938142024272e+01,		3.438400452314817e+01,		3.446846997096980e+01,
		3.455277826485453e+01,		3.463692990400626e+01,		3.472092538569360e+01,		3.480476520525743e+01,		3.488844985611872e+01,
		3.497197982978605e+01,		3.505535561586333e+01,		3.513857770205739e+01,		3.522164657418556e+01,		3.530456271618324e+01,
		3.538732661011158e+01,		3.546993873616488e+01,		3.555239957267823e+01,		3.563470959613494e+01,		3.571686928117414e+01,
		3.579887910059816e+01,		3.588073952538002e+01,		3.596245102467081e+01,		3.604401406580726e+01,		3.612542911431898e+01,
		3.620669663393589e+01,		3.628781708659557e+01,		3.636879093245057e+01,		3.644961862987579e+01,		3.653030063547568e+01,
		3.661083740409158e+01,		3.669122938880886e+01,		3.677147704096428e+01,		3.685158081015312e+01,		3.693154114423630e+01,
		3.701135848934761e+01,		3.709103328990082e+01,		3.717056598859679e+01,		3.724995702643053e+01,		3.732920684269827e+01,
		3.740831587500450e+01,		3.748728455926900e+01,		3.756611332973376e+01,		3.764480261897004e+01,		3.772335285788518e+01,
		3.780176447572968e+01,		3.788003790010394e+01,		3.795817355696521e+01,		3.803617187063436e+01,		3.811403326380281e+01,
		3.819175815753918e+01,		3.826934697129619e+01,		3.834680012291729e+01,		3.842411802864344e+01,		3.850130110311978e+01,
		3.857834975940231e+01,		3.865526440896452e+01,		3.873204546170399e+01,		3.880869332594901e+01,		3.888520840846515e+01,
		3.896159111446175e+01,		3.903784184759849e+01,		3.911396100999184e+01,		3.918994900222159e+01,		3.926580622333719e+01,
		3.934153307086424e+01,		3.941712994081088e+01,		3.949259722767405e+01,		3.956793532444605e+01,		3.964314462262058e+01,
		3.971822551219922e+01,		3.979317838169765e+01,		3.986800361815182e+01,		3.994270160712431e+01,		4.001727273271033e+01,
		4.009171737754402e+01,		4.016603592280456e+01,		4.024022874822226e+01,		4.031429623208464e+01,		4.038823875124257e+01,
		4.046205668111619e+01,		4.053575039570101e+01,		4.060932026757389e+01,		4.068276666789896e+01,		4.075608996643365e+01,
		4.082929053153447e+01,		4.090236873016303e+01,		4.097532492789184e+01,		4.104815948891017e+01,		4.112087277602986e+01,
		4.119346515069111e+01,		4.126593697296828e+01,		4.133828860157560e+01,		4.141052039387289e+01,		4.148263270587131e+01,
		4.155462589223893e+01,		4.162650030630655e+01,		4.169825630007308e+01,		4.176989422421139e+01,		4.184141442807375e+01,
		4.191281725969738e+01,		4.198410306581005e+01,		4.205527219183558e+01,		4.212632498189922e+01,		4.219726177883322e+01,
		4.226808292418223e+01,		4.233878875820879e+01,		4.240937961989850e+01,		4.247985584696568e+01,		4.255021777585850e+01,
		4.262046574176438e+01,		4.269060007861533e+01,		4.276062111909310e+01,		4.283052919463459e+01,		4.290032463543697e+01,
		4.297000777046296e+01,		4.303957892744593e+01,		4.310903843289515e+01,		4.317838661210093e+01,		4.324762378913966e+01,
		4.331675028687895e+01,		4.338576642698278e+01,		4.345467252991642e+01,		4.352346891495158e+01,		4.359215590017136e+01,
		4.366073380247521e+01,		4.372920293758399e+01,		4.379756362004485e+01,		4.386581616323615e+01,		4.393396087937241e+01,
		4.400199807950911e+01,		4.406992807354769e+01,		4.413775117024020e+01,		4.420546767719430e+01,		4.427307790087796e+01,
		4.434058214662424e+01,		4.440798071863607e+01,		4.447527391999098e+01,		4.454246205264582e+01,		4.460954541744143e+01,
		4.467652431410735e+01,		4.474339904126644e+01,		4.481016989643952e+01,		4.487683717605002e+01,		4.494340117542851e+01,
		4.500986218881733e+01,		4.507622050937512e+01,		4.514247642918134e+01,		4.520863023924076e+01,		4.527468222948806e+01,
		4.534063268879223e+01,		4.540648190496095e+01,		4.547223016474520e+01,		4.553787775384349e+01,		4.560342495690641e+01,
		4.566887205754094e+01,		4.573421933831473e+01,		4.579946708076065e+01,		4.586461556538087e+01,		4.592966507165134e+01,
		4.599461587802593e+01,		4.605946826194084e+01,		4.612422249981876e+01,		4.618887886707305e+01,		4.625343763811208e+01,
		4.631789908634330e+01,		4.638226348417748e+01,		4.644653110303280e+01,		4.651070221333908e+01,		4.657477708454181e+01,
		4.663875598510624e+01,		4.670263918252162e+01,		4.676642694330501e+01,		4.683011953300547e+01,		4.689371721620822e+01,
		4.695722025653830e+01,		4.702062891666493e+01,		4.708394345830520e+01,		4.714716414222823e+01,		4.721029122825902e+01,
		4.727332497528230e+01,		4.733626564124661e+01,		4.739911348316801e+01,		4.746186875713411e+01,		4.752453171830776e+01,
		4.758710262093110e+01,		4.764958171832910e+01,		4.771196926291361e+01,		4.777426550618705e+01,		4.783647069874618e+01,
		4.789858509028581e+01,		4.796060892960265e+01,		4.802254246459891e+01,		4.808438594228607e+01,		4.814613960878862e+01,
		4.820780370934758e+01,		4.826937848832429e+01,		4.833086418920400e+01,		4.839226105459947e+01,		4.845356932625467e+01,
		4.851478924504823e+01,		4.857592105099712e+01,		4.863696498326021e+01,		4.869792128014175e+01,		4.875879017909497e+01,
		4.881957191672556e+01,		4.888026672879510e+01,		4.894087485022471e+01,		4.900139651509836e+01,		4.906183195666637e+01
	},
	{
		8.015352632658236e-02,		2.403412598290326e-01,		4.001563476524633e-01,		5.595996627440810e-01,		7.186720589449574e-01,
		8.773743723770734e-01,		1.035707422764365e+00,		1.193672014690383e+00,		1.351268938795073e+00,		1.508498972913093e+00,
		1.665362883155971e+00,		1.821861424940351e+00,		1.977995343964439e+00,		2.133765377134745e+00,		2.289172253445077e+00,
		2.444216694809712e+00,		2.598899416852573e+00,		2.753221129654187e+00,		2.907182538458128e+00,		3.060784344338589e+00,
		3.214027244830666e+00,		3.366911934524872e+00,		3.519439105627368e+00,		3.671609448487302e+00,		3.823423652092655e+00,
		3.974882404535878e+00,		4.125986393450608e+00,		4.276736306420687e+00,		4.427132831362654e+00,		4.577176656882857e+00,
		4.726868472610278e+00,		4.876208969506112e+00,		5.025198840151161e+00,		5.173838779011977e+00,		5.322129482686734e+00,
		5.470071650131719e+00,		5.617665982869338e+00,		5.764913185178488e+00,		5.911813964268073e+00,		6.058369030434515e+00,
		6.204579097203954e+00,		6.350444881459900e+00,		6.495967103557035e+00,		6.641146487421849e+00,		6.785983760640724e+00,
		6.930479654536143e+00,		7.074634904231593e+00,		7.218450248705752e+00,		7.361926430836512e+00,		7.505064197435388e+00,
		7.647864299272798e+00,		7.790327491094754e+00,		7.932454531631400e+00,		8.074246183597875e+00,		8.215703213687911e+00,
		8.356826392560654e+00,		8.497616494821015e+00,		8.638074298994026e+00,		8.778200587493531e+00,		8.917996146585555e+00,
		9.057461766346732e+00,		9.196598240618089e+00,		9.335406366954524e+00,		9.473886946570227e+00,		9.612040784280408e+00,
		9.749868688439543e+00,		9.887371470876413e+00,		1.002454994682623e+01,		1.016140493486001e+01,		1.029793725681150e+01,
		1.043414773770184e+01,		1.057003720566216e+01,		1.070560649185433e+01,		1.084085643039006e+01,		1.097578785824845e+01,
		1.111040161519233e+01,		1.124469854368337e+01,		1.137867948879621e+01,		1.151234529813176e+01,		1.164569682172977e+01,
		1.177873491198084e+01,		1.191146042353795e+01,		1.204387421322773e+01,		1.217597713996138e+01,		1.230777006464561e+01,
		1.243925385009352e+01,		1.257042936093550e+01,		1.270129746353039e+01,		1.283185902587688e+01,		1.296211491752517e+01,
		1.309206600948913e+01,		1.322171317415892e+01,		1.335105728521409e+01,		1.348009921753737e+01,		1.360883984712905e+01,
		1.373728005102216e+01,		1.386542070719832e+01,		1.399326269450449e+01,		1.412080689257047e+01,		1.424805418172743e+01,
		1.437500544292725e+01,		1.450166155766288e+01,		1.462802340788966e+01,		1.475409187594774e+01,		1.487986784448541e+01,
		1.500535219638366e+01,		1.513054581468169e+01,		1.525544958250365e+01,		1.538006438298638e+01,		1.550439109920837e+01,
		1.562843061411987e+01,		1.575218381047416e+01,		1.587565157075994e+01,		1.599883477713497e+01,		1.612173431136080e+01,
		1.624435105473881e+01,		1.636668588804736e+01,		1.648873969148011e+01,		1.661051334458562e+01,		1.673200772620808e+01,
		1.685322371442921e+01,		1.697416218651140e+01,		1.709482401884204e+01,		1.721521008687892e+01,		1.733532126509701e+01,
		1.745515842693611e+01,		1.757472244474997e+01,		1.769401418975635e+01,		1.781303453198825e+01,		1.793178434024641e+01,
		1.805026448205273e+01,		1.816847582360497e+01,		1.828641922973248e+01,		1.840409556385299e+01,		1.852150568793053e+01,
		1.863865046243444e+01,		1.875553074629937e+01,		1.887214739688633e+01,		1.898850126994482e+01,		1.910459321957595e+01,
		1.922042409819653e+01,		1.933599475650419e+01,		1.945130604344349e+01,		1.956635880617291e+01,		1.968115389003290e+01,
		1.979569213851475e+01,		1.990997439323050e+01,		2.002400149388362e+01,		2.013777427824070e+01,		2.025129358210395e+01,
		2.036456023928457e+01,		2.047757508157698e+01,		2.059033893873391e+01,		2.070285263844220e+01,		2.081511700629958e+01,
		2.092713286579204e+01,		2.103890103827217e+01,		2.115042234293810e+01,		2.126169759681328e+01,		2.137272761472698e+01,
		2.148351320929547e+01,		2.159405519090397e+01,		2.170435436768918e+01,		2.181441154552270e+01,		2.192422752799482e+01,
		2.203380311639922e+01,		2.214313910971818e+01,		2.225223630460844e+01,		2.236109549538765e+01,		2.246971747402151e+01,
		2.257810303011134e+01,		2.268625295088237e+01,		2.279416802117253e+01,		2.290184902342179e+01,		2.300929673766199e+01,
		2.311651194150735e+01,		2.322349541014528e+01,		2.333024791632788e+01,		2.343677023036376e+01,		2.354306312011060e+01,
		2.364912735096780e+01,		2.375496368586992e+01,		2.386057288528044e+01,		2.396595570718593e+01,		2.407111290709067e+01,
		2.417604523801169e+01,		2.428075345047425e+01,		2.438523829250764e+01,		2.448950050964143e+01,		2.459354084490202e+01,
		2.469736003880972e+01,		2.480095882937595e+01,		2.490433795210099e+01,		2.500749813997198e+01,		2.511044012346123e+01,
		2.521316463052494e+01,		2.531567238660216e+01,		2.541796411461403e+01,		2.552004053496345e+01,		2.562190236553489e+01,
		2.572355032169452e+01,		2.582498511629077e+01,		2.592620745965483e+01,		2.602721805960176e+01,		2.612801762143167e+01,
		2.622860684793107e+01,		2.632898643937472e+01,		2.642915709352737e+01,		2.652911950564607e+01,		2.662887436848244e+01,
		2.672842237228524e+01,		2.682776420480322e+01,		2.692690055128805e+01,		2.702583209449747e+01,		2.712455951469871e+01,
		2.722308348967202e+01,		2.732140469471432e+01,		2.741952380264322e+01,		2.751744148380097e+01,		2.761515840605872e+01,
		2.771267523482087e+01,		2.780999263302967e+01,		2.790711126116977e+01,		2.800403177727313e+01,		2.810075483692392e+01,
		2.819728109326360e+01,		2.829361119699614e+01,		2.838974579639338e+01,		2.848568553730039e+01,		2.858143106314112e+01,
		2.867698301492402e+01,		2.877234203124788e+01,		2.886750874830760e+01,		2.896248379990034e+01,		2.905726781743144e+01,
		2.915186142992065e+01,		2.924626526400844e+01,		2.934047994396228e+01,		2.943450609168306e+01,		2.952834432671164e+01,
		2.962199526623539e+01,		2.971545952509490e+01,		2.980873771579059e+01,		2.990183044848966e+01,		2.999473833103278e+01,
		3.008746196894109e+01,		3.018000196542319e+01,		3.027235892138209e+01,		3.036453343542237e+01,		3.045652610385727e+01,
		3.054833752071582e+01,		3.063996827775021e+01,		3.073141896444288e+01,		3.082269016801398e+01,		3.091378247342861e+01,
		3.100469646340429e+01,		3.109543271841833e+01,		3.118599181671527e+01,		3.127637433431443e+01,		3.136658084501737e+01,
		3.145661192041546e+01,		3.154646812989743e+01,		3.163615004065695e+01,		3.172565821770027e+01,		3.181499322385388e+01,
		3.190415561977206e+01,		3.199314596394468e+01,		3.208196481270478e+01,		3.217061272023632e+01,		3.225909023858192e+01,
		3.234739791765051e+01,		3.243553630522513e+01,		3.252350594697063e+01,		3.261130738644145e+01,		3.269894116508939e+01,
		3.278640782227134e+01,		3.287370789525701e+01,		3.296084191923686e+01,		3.304781042732967e+01,		3.313461395059044e+01,
		3.322125301801811e+01,		3.330772815656342e+01,		3.339403989113652e+01,		3.348018874461490e+01,		3.356617523785103e+01,
		3.365199988968023e+01,		3.373766321692833e+01,		3.382316573441940e+01,		3.390850795498366e+01,		3.399369038946500e+01,
		3.407871354672879e+01,		3.416357793366964e+01,		3.424828405521904e+01,		3.433283241435308e+01,		3.441722351210009e+01,
		3.450145784754840e+01,		3.458553591785388e+01,		3.466945821824766e+01,		3.475322524204375e+01,		3.483683748064666e+01,
		3.492029542355894e+01,		3.500359955838883e+01,		3.508675037085783e+01,		3.516974834480819e+01,		3.525259396221052e+01,
		3.533528770317126e+01,		3.541783004594022e+01,		3.550022146691801e+01,		3.558246244066357e+01,		3.566455343990152e+01,
		3.574649493552974e+01,		3.582828739662661e+01,		3.590993129045852e+01,		3.599142708248718e+01,		3.607277523637700e+01,
		3.615397621400235e+01,		3.623503047545496e+01,		3.631593847905116e+01,		3.639670068133910e+01,		3.647731753710611e+01,
		3.655778949938576e+01,		3.663811701946521e+01,		3.671830054689233e+01,		3.679834052948275e+01,		3.687823741332718e+01,
		3.695799164279838e+01,		3.703760366055833e+01,		3.711707390756514e+01,		3.719640282308032e+01,		3.727559084467561e+01,
		3.735463840824001e+01,		3.743354594798684e+01,		3.751231389646055e+01,		3.759094268454369e+01,		3.766943274146389e+01,
		3.774778449480059e+01,		3.782599837049197e+01,		3.790407479284179e+01,		3.798201418452609e+01,		3.805981696660009e+01,
		3.813748355850482e+01,		3.821501437807393e+01,		3.829240984154038e+01,		3.836967036354304e+01,		3.844679635713343e+01,
		3.852378823378231e+01,		3.860064640338624e+01,		3.867737127427423e+01,		3.875396325321423e+01,		3.883042274541970e+01,
		3.890675015455606e+01,		3.898294588274721e+01,		3.905901033058194e+01,		3.913494389712040e+01,		3.921074697990051e+01,
		3.928641997494420e+01,		3.936196327676396e+01,		3.943737727836900e+01,		3.951266237127167e+01,		3.958781894549365e+01,
		3.966284738957221e+01,		3.973774809056653e+01,		3.981252143406370e+01,		3.988716780418517e+01,		3.996168758359265e+01,
		4.003608115349438e+01,		4.011034889365116e+01,		4.018449118238243e+01,		4.025850839657242e+01,		4.033240091167603e+01,
		4.040616910172495e+01,		4.047981333933355e+01,		4.055333399570491e+01,		4.062673144063663e+01,		4.070000604252693e+01,
		4.077315816838032e+01,		4.084618818381361e+01,		4.091909645306161e+01,		4.099188333898305e+01,		4.106454920306631e+01,
		4.113709440543517e+01,		4.120951930485457e+01,		4.128182425873629e+01,		4.135400962314469e+01,		4.142607575280230e+01,
		4.149802300109550e+01,		4.156985172008014e+01,		4.164156226048711e+01,		4.171315497172789e+01,		4.178463020190017e+01,
		4.185598829779331e+01,		4.192722960489382e+01,		4.199835446739089e+01,		4.206936322818176e+01,		4.214025622887726e+01,
		4.221103380980714e+01,		4.228169631002541e+01,		4.235224406731582e+01,		4.242267741819704e+01,		4.249299669792816e+01,
		4.256320224051384e+01,		4.263329437870958e+01,		4.270327344402698e+01,		4.277313976673910e+01,		4.284289367588543e+01,
		4.291253549927720e+01,		4.298206556350253e+01,		4.305148419393155e+01,		4.312079171472145e+01,		4.318998844882174e+01,
		4.325907471797907e+01,		4.332805084274248e+01,		4.339691714246834e+01,		4.346567393532533e+01,		4.353432153829951e+01,
		4.360286026719917e+01,		4.367129043665978e+01,		4.373961236014905e+01,		4.380782634997161e+01,		4.387593271727403e+01,
		4.394393177204964e+01,		4.401182382314332e+01,		4.407960917825638e+01,		4.414728814395127e+01,		4.421486102565639e+01,
		4.428232812767085e+01,		4.434968975316918e+01,		4.441694620420604e+01,		4.448409778172091e+01,		4.455114478554269e+01,
		4.461808751439447e+01,		4.468492626589808e+01,		4.475166133657871e+01,		4.481829302186943e+01,		4.488482161611585e+01,
		4.495124741258066e+01,		4.501757070344809e+01,		4.508379177982841e+01,		4.514991093176255e+01,		4.521592844822639e+01,
		4.528184461713531e+01,		4.534765972534858e+01,		4.541337405867382e+01,		4.547898790187133e+01,		4.554450153865849e+01,
		4.560991525171404e+01,		4.567522932268255e+01,		4.574044403217863e+01,		4.580555965979124e+01,		4.587057648408795e+01,
		4.593549478261925e+01,		4.600031483192276e+01,		4.606503690752744e+01,		4.612966128395779e+01,		4.619418823473799e+01,
		4.625861803239622e+01,		4.632295094846861e+01,		4.638718725350348e+01,		4.645132721706541e+01,		4.651537110773940e+01,
		4.657931919313484e+01,		4.664317173988958e+01,		4.670692901367411e+01,		4.677059127919537e+01,		4.683415880020088e+01,
		4.689763183948278e+01,		4.696101065888162e+01,		4.702429551929043e+01,		4.708748668065868e+01,		4.715058440199606e+01,
		4.721358894137654e+01,		4.727650055594218e+01,		4.733931950190693e+01,		4.740204603456061e+01,		4.746468040827258e+01,
		4.752722287649573e+01,		4.758967369177014e+01,		4.765203310572695e+01,		4.771430136909201e+01,		4.777647873168979e+01,
		4.783856544244696e+01,		4.790056174939620e+01,		4.796246789967986e+01,		4.802428413955361e+01,		4.808601071439018e+01,
		4.814764786868298e+01,		4.820919584604970e+01,		4.827065488923591e+01,		4.833202524011883e+01,		4.839330713971068e+01,
		4.845450082816240e+01,		4.851560654476716e+01,		4.857662452796389e+01,		4.863755501534085e+01,		4.869839824363909e+01,
		4.875915444875594e+01,		4.881982386574856e+01,		4.888040672883729e+01,		4.894090327140914e+01,		4.900131372602129e+01
	},
	{
		7.999402013280595e-02,		2.398633172681211e-01,		3.993611628555711e-01,		5.584884293923906e-01,		7.172459704217002e-01,
		8.756346219032809e-01,		1.033655203519224e+00,		1.191308519917035e+00,		1.348595361892658e+00,		1.505516507515805e+00,
		1.662072723199856e+00,		1.818264764718547e+00,		1.974093378171546e+00,		2.129559300900947e+00,		2.284663262360637e+00,
		2.439405984940433e+00,		2.593788184746780e+00,		2.747810572341772e+00,		2.901473853442166e+00,		3.054778729580023e+00,
		3.207725898726512e+00,		3.360316055880417e+00,		3.512549893622767e+00,		3.664428102638989e+00,		3.815951372209951e+00,
		3.967120390673180e+00,		4.117935845855497e+00,		4.268398425478297e+00,		4.418508817536625e+00,		4.568267710653173e+00,
		4.717675794408278e+00,		4.866733759646960e+00,		5.015442298764019e+00,		5.163802105968152e+00,		5.311813877526014e+00,
		5.459478311987128e+00,		5.606796110390541e+00,		5.753767976454007e+00,		5.900394616746555e+00,		6.046676740845174e+00,
		6.192615061476404e+00,		6.338210294643518e+00,		6.483463159740013e+00,		6.628374379650057e+00,		6.772944680836546e+00,
		6.917174793417391e+00,		7.061065451230627e+00,		7.204617391888909e+00,		7.347831356823947e+00,		7.490708091321433e+00,
		7.633248344546927e+00,		7.775452869563217e+00,		7.917322423339636e+00,		8.058857766753736e+00,		8.200059664585824e+00,
		8.340928885506703e+00,		8.481466202059073e+00,		8.621672390632940e+00,		8.761548231435421e+00,		8.901094508455289e+00,
		9.040312009422582e+00,		9.179201525763636e+00,		9.317763852551801e+00,		9.455999788454193e+00,		9.593910135674694e+00,
		9.731495699893575e+00,		9.868757290203861e+00,		1.000569571904485e+01,		1.014231180213284e+01,		1.027860635838951e+01,
		1.041458020986791e+01,		1.055023418167649e+01,		1.068556910190132e+01,		1.082058580152648e+01,		1.095528511435317e+01,
		1.108966787691735e+01,		1.122373492840627e+01,		1.135748711057407e+01,		1.149092526765639e+01,		1.162405024628438e+01,
		1.175686289539806e+01,		1.188936406615925e+01,		1.202155461186414e+01,		1.215343538785561e+01,		1.228500725143546e+01,
		1.241627106177661e+01,		1.254722767983532e+01,		1.267787796826364e+01,		1.280822279132200e+01,		1.293826301479224e+01,
		1.306799950589092e+01,		1.319743313318315e+01,		1.332656476649694e+01,		1.345539527683812e+01,		1.358392553630593e+01,
		1.371215641800927e+01,		1.384008879598371e+01,		1.396772354510932e+01,		1.409506154102933e+01,		1.422210366006956e+01,
		1.434885077915894e+01,		1.447530377575081e+01,		1.460146352774529e+01,		1.472733091341262e+01,		1.485290681131752e+01,
		1.497819210024459e+01,		1.510318765912482e+01,		1.522789436696319e+01,		1.535231310276727e+01,		1.547644474547707e+01,
		1.560029017389599e+01,		1.572385026662285e+01,		1.584712590198510e+01,		1.597011795797327e+01,		1.609282731217645e+01,
		1.621525484171902e+01,		1.633740142319857e+01,		1.645926793262490e+01,		1.658085524536028e+01,		1.670216423606090e+01,
		1.682319577861936e+01,		1.694395074610849e+01,		1.706443001072624e+01,		1.718463444374173e+01,		1.730456491544252e+01,
		1.742422229508294e+01,		1.754360745083367e+01,		1.766272124973230e+01,		1.778156455763522e+01,		1.790013823917045e+01,
		1.801844315769164e+01,		1.813648017523320e+01,		1.825425015246649e+01,		1.837175394865705e+01,		1.848899242162300e+01,
		1.860596642769432e+01,		1.872267682167339e+01,		1.883912445679634e+01,		1.895531018469563e+01,		1.907123485536342e+01,
		1.918689931711609e+01,		1.930230441655967e+01,		1.941745099855626e+01,		1.953233990619135e+01,		1.964697198074218e+01,
		1.976134806164683e+01,		1.987546898647451e+01,		1.998933559089642e+01,		2.010294870865777e+01,		2.021630917155044e+01,
		2.032941780938665e+01,		2.044227544997346e+01,		2.055488291908792e+01,		2.066724104045330e+01,		2.077935063571586e+01,
		2.089121252442255e+01,		2.100282752399947e+01,		2.111419644973105e+01,		2.122532011473988e+01,		2.133619932996750e+01,
		2.144683490415568e+01,		2.155722764382844e+01,		2.166737835327491e+01,		2.177728783453264e+01,		2.188695688737171e+01,
		2.199638630927947e+01,		2.210557689544584e+01,		2.221452943874932e+01,		2.232324472974353e+01,		2.243172355664442e+01,
		2.253996670531798e+01,		2.264797495926853e+01,		2.275574909962769e+01,		2.286328990514369e+01,		2.297059815217139e+01,
		2.307767461466269e+01,		2.318452006415756e+01,		2.329113526977550e+01,		2.339752099820746e+01,		2.350367801370837e+01,
		2.360960707808992e+01,		2.371530895071400e+01,		2.382078438848649e+01,		2.392603414585144e+01,		2.403105897478575e+01,
		2.413585962479424e+01,		2.424043684290510e+01,		2.434479137366579e+01,		2.444892395913918e+01,		2.455283533890027e+01,
		2.465652625003307e+01,		2.475999742712805e+01,		2.486324960227967e+01,		2.496628350508453e+01,		2.506909986263959e+01,
		2.517169939954095e+01,		2.527408283788271e+01,		2.537625089725634e+01,		2.547820429475015e+01,		2.557994374494928e+01,
		2.568146995993570e+01,		2.578278364928872e+01,		2.588388552008563e+01,		2.598477627690259e+01,		2.608545662181589e+01,
		2.618592725440331e+01,		2.628618887174586e+01,		2.638624216842956e+01,		2.648608783654764e+01,		2.658572656570286e+01,
		2.668515904301002e+01,		2.678438595309875e+01,		2.688340797811639e+01,		2.698222579773124e+01,		2.708084008913572e+01,
		2.717925152705006e+01,		2.727746078372584e+01,		2.737546852894990e+01,		2.747327543004835e+01,		2.757088215189075e+01,
		2.766828935689439e+01,		2.776549770502889e+01,		2.786250785382070e+01,		2.795932045835790e+01,		2.805593617129514e+01,
		2.815235564285867e+01,		2.824857952085141e+01,		2.834460845065836e+01,		2.844044307525190e+01,		2.853608403519736e+01,
		2.863153196865860e+01,		2.872678751140378e+01,		2.882185129681120e+01,		2.891672395587518e+01,		2.901140611721213e+01,
		2.910589840706661e+01,		2.920020144931766e+01,		2.929431586548496e+01,		2.938824227473528e+01,		2.948198129388888e+01,
		2.957553353742609e+01,		2.966889961749386e+01,		2.976208014391250e+01,		2.985507572418231e+01,		2.994788696349046e+01,
		3.004051446471783e+01,		3.013295882844591e+01,		3.022522065296378e+01,		3.031730053427516e+01,		3.040919906610545e+01,
		3.050091683990888e+01,		3.059245444487564e+01,		3.068381246793919e+01,		3.077499149378338e+01,		3.086599210484985e+01,
		3.095681488134533e+01,		3.104746040124900e+01,		3.113792924031987e+01,		3.122822197210425e+01,		3.131833916794319e+01,
		3.140828139697996e+01,		3.149804922616762e+01,		3.158764322027642e+01,		3.167706394190151e+01,		3.176631195147044e+01,
		3.185538780725080e+01,		3.194429206535776e+01,		3.203302527976182e+01,		3.212158800229631e+01,		3.220998078266519e+01,
		3.229820416845064e+01,		3.238625870512073e+01,		3.247414493603722e+01,		3.256186340246308e+01,		3.264941464357036e+01,
		3.273679919644781e+01,		3.282401759610865e+01,		3.291107037549819e+01,		3.299795806550167e+01,		3.308468119495195e+01,
		3.317124029063713e+01,		3.325763587730837e+01,		3.334386847768764e+01,		3.342993861247533e+01,		3.351584680035803e+01,
		3.360159355801618e+01,		3.368717940013190e+01,		3.377260483939649e+01,		3.385787038651826e+01,		3.394297655023021e+01,
		3.402792383729759e+01,		3.411271275252574e+01,		3.419734379876753e+01,		3.428181747693117e+01,		3.436613428598778e+01,
		3.445029472297900e+01,		3.453429928302460e+01,		3.461814845933009e+01,		3.470184274319429e+01,		3.478538262401691e+01,
		3.486876858930604e+01,		3.495200112468579e+01,		3.503508071390370e+01,		3.511800783883835e+01,		3.520078297950676e+01,
		3.528340661407191e+01,		3.536587921885016e+01,		3.544820126831874e+01,		3.553037323512310e+01,		3.561239559008434e+01,
		3.569426880220662e+01,		3.577599333868450e+01,		3.585756966491022e+01,		3.593899824448111e+01,		3.602027953920684e+01,
		3.610141400911677e+01,		3.618240211246709e+01,		3.626324430574817e+01,		3.634394104369169e+01,		3.642449277927798e+01,
		3.650489996374296e+01,		3.658516304658551e+01,		3.666528247557453e+01,		3.674525869675599e+01,		3.682509215446013e+01,
		3.690478329130838e+01,		3.698433254822052e+01,		3.706374036442167e+01,		3.714300717744925e+01,		3.722213342315996e+01,
		3.730111953573674e+01,		3.737996594769572e+01,		3.745867308989306e+01,		3.753724139153189e+01,		3.761567128016908e+01,
		3.769396318172215e+01,		3.777211752047608e+01,		3.785013471908997e+01,		3.792801519860394e+01,		3.800575937844579e+01,
		3.808336767643770e+01,		3.816084050880293e+01,		3.823817829017248e+01,		3.831538143359172e+01,		3.839245035052704e+01,
		3.846938545087229e+01,		3.854618714295555e+01,		3.862285583354548e+01,		3.869939192785796e+01,		3.877579582956246e+01,
		3.885206794078863e+01,		3.892820866213261e+01,		3.900421839266352e+01,		3.908009752992978e+01,		3.915584646996559e+01,
		3.923146560729710e+01,		3.930695533494886e+01,		3.938231604445005e+01,		3.945754812584071e+01,		3.953265196767806e+01,
		3.960762795704263e+01,		3.968247647954446e+01,		3.975719791932932e+01,		3.983179265908478e+01,		3.990626108004635e+01,
		3.998060356200362e+01,		4.005482048330617e+01,		4.012891222086981e+01,		4.020287915018241e+01,		4.027672164531004e+01,
		4.035044007890281e+01,		4.042403482220092e+01,		4.049750624504046e+01,		4.057085471585945e+01,		4.064408060170350e+01,
		4.071718426823192e+01,		4.079016607972329e+01,		4.086302639908139e+01,		4.093576558784094e+01,		4.100838400617334e+01,
		4.108088201289242e+01,		4.115325996546005e+01,		4.122551821999199e+01,		4.129765713126334e+01,		4.136967705271433e+01,
		4.144157833645577e+01,		4.151336133327479e+01,		4.158502639264029e+01,		4.165657386270851e+01,		4.172800409032848e+01,
		4.179931742104767e+01,		4.187051419911727e+01,		4.194159476749768e+01,		4.201255946786401e+01,		4.208340864061135e+01,
		4.215414262486028e+01,		4.222476175846208e+01,		4.229526637800412e+01,		4.236565681881521e+01,		4.243593341497078e+01,
		4.250609649929817e+01,		4.257614640338193e+01,		4.264608345756897e+01,		4.271590799097375e+01,		4.278562033148346e+01,
		4.285522080576316e+01,		4.292470973926094e+01,		4.299408745621295e+01,		4.306335427964854e+01,		4.313251053139530e+01,
		4.320155653208409e+01,		4.327049260115404e+01,		4.333931905685755e+01,		4.340803621626532e+01,		4.347664439527121e+01,
		4.354514390859719e+01,		4.361353506979830e+01,		4.368181819126746e+01,		4.374999358424041e+01,		4.381806155880052e+01,
		4.388602242388352e+01,		4.395387648728251e+01,		4.402162405565250e+01,		4.408926543451543e+01,		4.415680092826460e+01,
		4.422423084016965e+01,		4.429155547238121e+01,		4.435877512593541e+01,		4.442589010075874e+01,		4.449290069567257e+01,
		4.455980720839782e+01,		4.462660993555956e+01,		4.469330917269148e+01,		4.475990521424061e+01,		4.482639835357175e+01,
		4.489278888297203e+01,		4.495907709365539e+01,		4.502526327576699e+01,		4.509134771838784e+01,		4.515733070953910e+01,
		4.522321253618650e+01,		4.528899348424484e+01,		4.535467383858223e+01,		4.542025388302461e+01,		4.548573390035995e+01,
		4.555111417234266e+01,		4.561639497969787e+01,		4.568157660212574e+01,		4.574665931830565e+01,		4.581164340590056e+01,
		4.587652914156113e+01,		4.594131680093001e+01,		4.600600665864604e+01,		4.607059898834834e+01,		4.613509406268055e+01,
		4.619949215329493e+01,		4.626379353085645e+01,		4.632799846504704e+01,		4.639210722456941e+01,		4.645612007715143e+01,
		4.652003728954990e+01,		4.658385912755477e+01,		4.664758585599306e+01,		4.671121773873287e+01,		4.677475503868740e+01,
		4.683819801781885e+01,		4.690154693714242e+01,		4.696480205673017e+01,		4.702796363571502e+01,		4.709103193229452e+01,
		4.715400720373490e+01,		4.721688970637472e+01,		4.727967969562886e+01,		4.734237742599230e+01,		4.740498315104394e+01,
		4.746749712345034e+01,		4.752991959496953e+01,		4.759225081645481e+01,		4.765449103785842e+01,		4.771664050823532e+01,
		4.777869947574678e+01,		4.784066818766431e+01,		4.790254689037307e+01,		4.796433582937573e+01,		4.802603524929595e+01,
		4.808764539388216e+01,		4.814916650601110e+01,		4.821059882769139e+01,		4.827194260006712e+01,		4.833319806342148e+01,
		4.839436545718026e+01,		4.845544501991535e+01,		4.851643698934829e+01,		4.857734160235388e+01,		4.863815909496337e+01,
		4.869888970236831e+01,		4.875953365892372e+01,		4.882009119815166e+01,		4.888056255274462e+01,		4.894094795456892e+01
	},
	{
		7.983514772144629e-02,		2.393872736501627e-01,		3.985691372335161e-01,		5.573816104837853e-01,		7.158255466095389e-01,
		8.739017813703611e-01,		1.031611134367321e+00,		1.188954410271711e+00,		1.345932399994507e+00,		1.502545881798875e+00,
		1.658795622357990e+00,		1.814682377760316e+00,		1.970206894464440e+00,		2.125369910205468e+00,		2.280172154854887e+00,
		2.434614351235781e+00,		2.588697215895159e+00,		2.742421459835138e+00,		2.895787789204626e+00,		3.048796905953105e+00,
		3.201449508448057e+00,		3.353746292057515e+00,		3.505687949699162e+00,		3.657275172357371e+00,		3.808508649569494e+00,
		3.959389069882707e+00,		4.109917121282608e+00,		4.260093491594814e+00,		4.409918868860636e+00,		4.559393941688008e+00,
		4.708519399578683e+00,		4.857295933232745e+00,		5.005724234831449e+00,		5.153804998299305e+00,		5.301538919546358e+00,
		5.448926696691537e+00,		5.595969030267938e+00,		5.742666623410862e+00,		5.889020182029395e+00,		6.035030414962314e+00,
		6.180698034119041e+00,		6.326023754606353e+00,		6.471008294841560e+00,		6.615652376652764e+00,		6.759956725366862e+00,
		6.903922069885925e+00,		7.047549142752483e+00,		7.190838680204314e+00,		7.333791422219308e+00,		7.476408112550865e+00,
		7.618689498754369e+00,		7.760636332205239e+00,		7.902249368108952e+00,		8.043529365503566e+00,		8.184477087255132e+00,
		8.325093300046353e+00,		8.465378774359012e+00,		8.605334284450418e+00,		8.744960608324304e+00,		8.884258527696510e+00,
		9.023228827955782e+00,		9.161872298119988e+00,		9.300189730788111e+00,		9.438181922088239e+00,		9.575849671621880e+00,
		9.713193782404890e+00,		9.850215060805182e+00,		9.986914316477565e+00,		1.012329236229588e+01,		1.025935001428270e+01,
		1.039508809153674e+01,		1.053050741615826e+01,		1.066560881317266e+01,		1.080039311045228e+01,		1.093486113863690e+01,
		1.106901373105273e+01,		1.120285172363040e+01,		1.133637595482187e+01,		1.146958726551645e+01,		1.160248649895616e+01,
		1.173507450065047e+01,		1.186735211829054e+01,		1.199932020166317e+01,		1.213097960256440e+01,		1.226233117471309e+01,
		1.239337577366439e+01,		1.252411425672325e+01,		1.265454748285811e+01,		1.278467631261480e+01,		1.291450160803076e+01,
		1.304402423254956e+01,		1.317324505093596e+01,		1.330216492919141e+01,		1.343078473447015e+01,		1.355910533499595e+01,
		1.368712759997943e+01,		1.381485239953627e+01,		1.394228060460606e+01,		1.406941308687198e+01,		1.419625071868141e+01,
		1.432279437296733e+01,		1.444904492317074e+01,		1.457500324316395e+01,		1.470067020717489e+01,		1.482604668971243e+01,
		1.495113356549274e+01,		1.507593170936661e+01,		1.520044199624800e+01,		1.532466530104354e+01,		1.544860249858313e+01,
		1.557225446355180e+01,		1.569562207042248e+01,		1.581870619339008e+01,		1.594150770630661e+01,		1.606402748261746e+01,
		1.618626639529889e+01,		1.630822531679659e+01,		1.642990511896542e+01,		1.655130667301035e+01,		1.667243084942853e+01,
		1.679327851795246e+01,		1.691385054749441e+01,		1.703414780609190e+01,		1.715417116085439e+01,		1.727392147791105e+01,
		1.739339962235971e+01,		1.751260645821693e+01,		1.763154284836915e+01,		1.775020965452500e+01,		1.786860773716866e+01,
		1.798673795551437e+01,		1.810460116746202e+01,		1.822219822955369e+01,		1.833952999693147e+01,		1.845659732329612e+01,
		1.857340106086692e+01,		1.868994206034245e+01,		1.880622117086243e+01,		1.892223923997063e+01,		1.903799711357854e+01,
		1.915349563593037e+01,		1.926873564956868e+01,		1.938371799530114e+01,		1.949844351216828e+01,		1.961291303741192e+01,
		1.972712740644482e+01,		1.984108745282100e+01,		1.995479400820701e+01,		2.006824790235416e+01,		2.018144996307143e+01,
		2.029440101619941e+01,		2.040710188558490e+01,		2.051955339305648e+01,		2.063175635840074e+01,		2.074371159933942e+01,
		2.085541993150719e+01,		2.096688216843033e+01,		2.107809912150608e+01,		2.118907159998268e+01,		2.129980041094022e+01,
		2.141028635927215e+01,		2.152053024766750e+01,		2.163053287659369e+01,		2.174029504428014e+01,		2.184981754670247e+01,
		2.195910117756730e+01,		2.206814672829771e+01,		2.217695498801935e+01,		2.228552674354706e+01,		2.239386277937221e+01,
		2.250196387765042e+01,		2.260983081819009e+01,		2.271746437844123e+01,		2.282486533348504e+01,		2.293203445602389e+01,
		2.303897251637181e+01,		2.314568028244560e+01,		2.325215851975634e+01,		2.335840799140133e+01,		2.346442945805668e+01,
		2.357022367797019e+01,		2.367579140695472e+01,		2.378113339838209e+01,		2.388625040317726e+01,		2.399114316981309e+01,
		2.409581244430532e+01,		2.420025897020817e+01,		2.430448348861012e+01,		2.440848673813024e+01,		2.451226945491473e+01,
		2.461583237263395e+01,		2.471917622247978e+01,		2.482230173316325e+01,		2.492520963091255e+01,		2.502790063947142e+01,
		2.513037548009777e+01,		2.523263487156261e+01,		2.533467953014940e+01,		2.543651016965354e+01,		2.553812750138225e+01,
		2.563953223415465e+01,		2.574072507430220e+01,		2.584170672566933e+01,		2.594247788961436e+01,		2.604303926501063e+01,
		2.614339154824794e+01,		2.624353543323417e+01,		2.634347161139713e+01,		2.644320077168667e+01,		2.654272360057695e+01,
		2.664204078206898e+01,		2.674115299769332e+01,		2.684006092651299e+01,		2.693876524512658e+01,		2.703726662767149e+01,
		2.713556574582751e+01,		2.723366326882032e+01,		2.733155986342539e+01,		2.742925619397197e+01,		2.752675292234714e+01,
		2.762405070800018e+01,		2.772115020794694e+01,		2.781805207677448e+01,		2.791475696664575e+01,		2.801126552730446e+01,
		2.810757840608009e+01,		2.820369624789292e+01,		2.829961969525937e+01,		2.839534938829729e+01,		2.849088596473143e+01,
		2.858623005989900e+01,		2.868138230675541e+01,		2.877634333588000e+01,		2.887111377548193e+01,		2.896569425140617e+01,
		2.906008538713955e+01,		2.915428780381695e+01,		2.924830212022746e+01,		2.934212895282083e+01,		2.943576891571372e+01,
		2.952922262069630e+01,		2.962249067723875e+01,		2.971557369249781e+01,		2.980847227132357e+01,		2.990118701626618e+01,
		2.999371852758261e+01,		3.008606740324354e+01,		3.017823423894030e+01,		3.027021962809186e+01,		3.036202416185174e+01,
		3.045364842911523e+01,		3.054509301652642e+01,		3.063635850848532e+01,		3.072744548715521e+01,		3.081835453246971e+01,
		3.090908622214017e+01,		3.099964113166293e+01,		3.109001983432669e+01,		3.118022290121989e+01,		3.127025090123805e+01,
		3.136010440109131e+01,		3.144978396531183e+01,		3.153929015626124e+01,		3.162862353413821e+01,		3.171778465698595e+01,
		3.180677408069973e+01,		3.189559235903448e+01,		3.198424004361235e+01,		3.207271768393028e+01,		3.216102582736767e+01,
		3.224916501919394e+01,		3.233713580257615e+01,		3.242493871858671e+01,		3.251257430621094e+01,		3.260004310235476e+01,
		3.268734564185238e+01,		3.277448245747389e+01,		3.286145407993299e+01,		3.294826103789462e+01,		3.303490385798264e+01,
		3.312138306478751e+01,		3.320769918087391e+01,		3.329385272678848e+01,		3.337984422106745e+01,		3.346567418024426e+01,
		3.355134311885728e+01,		3.363685154945740e+01,		3.372219998261575e+01,		3.380738892693126e+01,		3.389241888903832e+01,
		3.397729037361442e+01,		3.406200388338773e+01,		3.414655991914471e+01,		3.423095897973776e+01,		3.431520156209268e+01,
		3.439928816121637e+01,		3.448321927020426e+01,		3.456699538024800e+01,		3.465061698064284e+01,		3.473408455879527e+01,
		3.481739860023045e+01,		3.490055958859970e+01,		3.498356800568803e+01,		3.506642433142152e+01,		3.514912904387482e+01,
		3.523168261927854e+01,		3.531408553202667e+01,		3.539633825468394e+01,		3.547844125799325e+01,		3.556039501088296e+01,
		3.564219998047427e+01,		3.572385663208848e+01,		3.580536542925436e+01,		3.588672683371536e+01,		3.596794130543687e+01,
		3.604900930261351e+01,		3.612993128167627e+01,		3.621070769729980e+01,		3.629133900240949e+01,		3.637182564818860e+01,
		3.645216808408555e+01,		3.653236675782085e+01,		3.661242211539430e+01,		3.669233460109199e+01,		3.677210465749336e+01,
		3.685173272547825e+01,		3.693121924423387e+01,		3.701056465126174e+01,		3.708976938238471e+01,		3.716883387175384e+01,
		3.724775855185533e+01,		3.732654385351736e+01,		3.740519020591702e+01,		3.748369803658703e+01,		3.756206777142270e+01,
		3.764029983468859e+01,		3.771839464902530e+01,		3.779635263545627e+01,		3.787417421339440e+01,		3.795185980064885e+01,
		3.802940981343157e+01,		3.810682466636409e+01,		3.818410477248397e+01,		3.826125054325161e+01,		3.833826238855656e+01,
		3.841514071672428e+01,		3.849188593452256e+01,		3.856849844716800e+01,		3.864497865833252e+01,		3.872132697014979e+01,
		3.879754378322168e+01,		3.887362949662459e+01,		3.894958450791588e+01,		3.902540921314019e+01,		3.910110400683575e+01,
		3.917666928204073e+01,		3.925210543029943e+01,		3.932741284166862e+01,		3.940259190472365e+01,		3.947764300656478e+01,
		3.955256653282325e+01,		3.962736286766746e+01,		3.970203239380911e+01,		3.977657549250932e+01,		3.985099254358459e+01,
		3.992528392541304e+01,		3.999945001494022e+01,		4.007349118768531e+01,		4.014740781774693e+01,		4.022120027780927e+01,
		4.029486893914779e+01,		4.036841417163537e+01,		4.044183634374804e+01,		4.051513582257080e+01,		4.058831297380360e+01,
		4.066136816176704e+01,		4.073430174940816e+01,		4.080711409830625e+01,		4.087980556867855e+01,		4.095237651938594e+01,
		4.102482730793865e+01,		4.109715829050198e+01,		4.116936982190184e+01,		4.124146225563042e+01,		4.131343594385180e+01,
		4.138529123740742e+01,		4.145702848582183e+01,		4.152864803730798e+01,		4.160015023877285e+01,		4.167153543582291e+01,
		4.174280397276955e+01,		4.181395619263454e+01,		4.188499243715538e+01,		4.195591304679076e+01,		4.202671836072590e+01,
		4.209740871687779e+01,		4.216798445190064e+01,		4.223844590119113e+01,		4.230879339889365e+01,		4.237902727790556e+01,
		4.244914786988240e+01,		4.251915550524316e+01,		4.258905051317542e+01,		4.265883322164039e+01,		4.272850395737832e+01,
		4.279806304591332e+01,		4.286751081155864e+01,		4.293684757742167e+01,		4.300607366540902e+01,		4.307518939623150e+01,
		4.314419508940916e+01,		4.321309106327627e+01,		4.328187763498628e+01,		4.335055512051675e+01,		4.341912383467427e+01,
		4.348758409109938e+01,		4.355593620227140e+01,		4.362418047951336e+01,		4.369231723299678e+01,		4.376034677174643e+01,
		4.382826940364527e+01,		4.389608543543908e+01,		4.396379517274132e+01,		4.403139892003779e+01,		4.409889698069129e+01,
		4.416628965694647e+01,		4.423357724993439e+01,		4.430076005967715e+01,		4.436783838509260e+01,		4.443481252399886e+01,
		4.450168277311899e+01,		4.456844942808547e+01,		4.463511278344487e+01,		4.470167313266226e+01,		4.476813076812576e+01,
		4.483448598115109e+01,		4.490073906198593e+01,		4.496689029981445e+01,		4.503293998276173e+01,		4.509888839789810e+01,
		4.516473583124371e+01,		4.523048256777267e+01,		4.529612889141758e+01,		4.536167508507378e+01,		4.542712143060371e+01,
		4.549246820884117e+01,		4.555771569959565e+01,		4.562286418165653e+01,		4.568791393279734e+01,		4.575286522978001e+01,
		4.581771834835906e+01,		4.588247356328579e+01,		4.594713114831239e+01,		4.601169137619621e+01,		4.607615451870377e+01,
		4.614052084661497e+01,		4.620479062972704e+01,		4.626896413685891e+01,		4.633304163585485e+01,		4.639702339358888e+01,
		4.646090967596862e+01,		4.652470074793934e+01,		4.658839687348791e+01,		4.665199831564684e+01,		4.671550533649815e+01,
		4.677891819717739e+01,		4.684223715787747e+01,		4.690546247785272e+01,		4.696859441542251e+01,		4.703163322797543e+01,
		4.709457917197287e+01,		4.715743250295308e+01,		4.722019347553479e+01,		4.728286234342117e+01,		4.734543935940348e+01,
		4.740792477536498e+01,		4.747031884228453e+01,		4.753262181024045e+01,		4.759483392841420e+01,		4.765695544509401e+01,
		4.771898660767872e+01,		4.778092766268123e+01,		4.784277885573241e+01,		4.790454043158454e+01,		4.796621263411500e+01,
		4.802779570632990e+01,		4.808928989036762e+01,		4.815069542750246e+01,		4.821201255814810e+01,		4.827324152186123e+01,
		4.833438255734496e+01,		4.839543590245255e+01,		4.845640179419065e+01,		4.851728046872297e+01,		4.857807216137362e+01,
		4.863877710663068e+01,		4.869939553814952e+01,		4.875992768875633e+01,		4.882037379045139e+01,		4.888073407441263e+01
	},
	{
		7.967690532123976e-02,		2.389131176683764e-01,		3.977802519640010e-01,		5.562791797011611e-01,		7.144107537180017e-01,
		8.721758095366640e-01,		1.029575166638777e+00,		1.186609629680031e+00,		1.343279989646249e+00,		1.499587024953254e+00,
		1.655531502492747e+00,		1.811114178626349e+00,		1.966335800129830e+00,		2.121197105089530e+00,		2.275698823752848e+00,
		2.429841679334645e+00,		2.583626388781317e+00,		2.737053663494229e+00,		2.890124210014161e+00,		3.042838730668328e+00,
		3.195197924181488e+00,		3.347202486252622e+00,		3.498853110098568e+00,		3.650150486966000e+00,		3.801095306613020e+00,
		3.951688257761680e+00,		4.101930028522604e+00,		4.251821306792903e+00,		4.401362780628529e+00,		4.550555138592136e+00,
		4.699399070077515e+00,		4.847895265611611e+00,		4.996044417135105e+00,		5.143847218262500e+00,		5.291304364522632e+00,
		5.438416553580458e+00,		5.585184485440988e+00,		5.731608862636171e+00,		5.877690390395514e+00,		6.023429776801175e+00,
		6.168827732928307e+00,		6.313884972971281e+00,		6.458602214356548e+00,		6.602980177842695e+00,		6.747019587608420e+00,
		6.890721171328942e+00,		7.034085660241481e+00,		7.177113789200340e+00,		7.319806296722153e+00,		7.462163925021748e+00,
		7.604187420039222e+00,		7.745877531458611e+00,		7.887235012718672e+00,		8.028260621016186e+00,		8.168955117302211e+00,
		8.309319266271723e+00,		8.449353836346956e+00,		8.589059599654918e+00,		8.728437331999359e+00,		8.867487812827557e+00,
		9.006211825192276e+00,		9.144610155709184e+00,		9.282683594510052e+00,		9.420432935192002e+00,		9.557858974763082e+00,
		9.694962513584503e+00,		9.831744355309636e+00,		9.968205306820213e+00,		1.010434617815976e+01,		1.024016778246468e+01,
		1.037567093589300e+01,		1.051085645755118e+01,		1.064572516941898e+01,		1.078027789627277e+01,		1.091451546560724e+01,
		1.104843870755590e+01,		1.118204845481037e+01,		1.131534554253862e+01,		1.144833080830241e+01,		1.158100509197394e+01,
		1.171336923565199e+01,		1.184542408357741e+01,		1.197717048204844e+01,		1.210860927933560e+01,		1.223974132559659e+01,
		1.237056747279095e+01,		1.250108857459496e+01,		1.263130548631648e+01,		1.276121906481013e+01,		1.289083016839271e+01,
		1.302013965675891e+01,		1.314914839089759e+01,		1.327785723300840e+01,		1.340626704641907e+01,		1.353437869550323e+01,
		1.366219304559889e+01,		1.378971096292770e+01,		1.391693331451489e+01,		1.404386096810999e+01,		1.417049479210850e+01,
		1.429683565547426e+01,		1.442288442766291e+01,		1.454864197854610e+01,		1.467410917833681e+01,		1.479928689751556e+01,
		1.492417600675768e+01,		1.504877737686160e+01,		1.517309187867815e+01,		1.529712038304100e+01,		1.542086376069815e+01,
		1.554432288224441e+01,		1.566749861805518e+01,		1.579039183822119e+01,		1.591300341248440e+01,		1.603533421017505e+01,
		1.615738510014982e+01,		1.627915695073113e+01,		1.640065062964757e+01,		1.652186700397551e+01,		1.664280694008175e+01,
		1.676347130356745e+01,		1.688386095921302e+01,		1.700397677092434e+01,		1.712381960167991e+01,		1.724339031347927e+01,
		1.736268976729248e+01,		1.748171882301067e+01,		1.760047833939780e+01,		1.771896917404338e+01,		1.783719218331640e+01,
		1.795514822232026e+01,		1.807283814484877e+01,		1.819026280334335e+01,		1.830742304885096e+01,		1.842431973098345e+01,
		1.854095369787764e+01,		1.865732579615663e+01,		1.877343687089188e+01,		1.888928776556656e+01,		1.900487932203961e+01,
		1.912021238051095e+01,		1.923528777948756e+01,		1.935010635575055e+01,		1.946466894432312e+01,		1.957897637843939e+01,
		1.969302948951425e+01,		1.980682910711402e+01,		1.992037605892797e+01,		2.003367117074074e+01,		2.014671526640560e+01,
		2.025950916781850e+01,		2.037205369489303e+01,		2.048434966553608e+01,		2.059639789562436e+01,		2.070819919898167e+01,
		2.081975438735700e+01,		2.093106427040320e+01,		2.104212965565664e+01,		2.115295134851741e+01,		2.126353015223026e+01,
		2.137386686786630e+01,		2.148396229430537e+01,		2.159381722821901e+01,		2.170343246405410e+01,		2.181280879401731e+01,
		2.192194700805994e+01,		2.203084789386351e+01,		2.213951223682595e+01,		2.224794082004841e+01,		2.235613442432255e+01,
		2.246409382811849e+01,		2.257181980757329e+01,		2.267931313648002e+01,		2.278657458627720e+01,		2.289360492603905e+01,
		2.300040492246595e+01,		2.310697533987559e+01,		2.321331694019454e+01,		2.331943048295034e+01,		2.342531672526397e+01,
		2.353097642184289e+01,		2.363641032497442e+01,		2.374161918451965e+01,		2.384660374790771e+01,		2.395136476013043e+01,
		2.405590296373751e+01,		2.416021909883202e+01,		2.426431390306623e+01,		2.436818811163796e+01,		2.447184245728712e+01,
		2.457527767029281e+01,		2.467849447847053e+01,		2.478149360717000e+01,		2.488427577927304e+01,		2.498684171519201e+01,
		2.508919213286839e+01,		2.519132774777179e+01,		2.529324927289916e+01,		2.539495741877436e+01,		2.549645289344801e+01,
		2.559773640249751e+01,		2.569880864902757e+01,		2.579967033367065e+01,		2.590032215458804e+01,		2.600076480747083e+01,
		2.610099898554142e+01,		2.620102537955502e+01,		2.630084467780159e+01,		2.640045756610780e+01,		2.649986472783932e+01,
		2.659906684390342e+01,		2.669806459275140e+01,		2.679685865038179e+01,		2.689544969034310e+01,		2.699383838373725e+01,
		2.709202539922301e+01,		2.719001140301953e+01,		2.728779705891008e+01,		2.738538302824613e+01,		2.748276996995128e+01,
		2.757995854052564e+01,		2.767694939405010e+01,		2.777374318219097e+01,		2.787034055420458e+01,		2.796674215694219e+01,
		2.806294863485478e+01,		2.815896062999823e+01,		2.825477878203851e+01,		2.835040372825689e+01,		2.844583610355548e+01,
		2.854107654046262e+01,		2.863612566913864e+01,		2.873098411738151e+01,		2.882565251063270e+01,		2.892013147198313e+01,
		2.901442162217912e+01,		2.910852357962855e+01,		2.920243796040704e+01,		2.929616537826420e+01,		2.938970644463002e+01,
		2.948306176862122e+01,		2.957623195704778e+01,		2.966921761441957e+01,		2.976201934295284e+01,		2.985463774257704e+01,
		2.994707341094152e+01,		3.003932694342230e+01,		3.013139893312900e+01,		3.022328997091176e+01,		3.031500064536813e+01,
		3.040653154285020e+01,		3.049788324747155e+01,		3.058905634111445e+01,		3.068005140343692e+01,		3.077086901188002e+01,
		3.086150974167495e+01,		3.095197416585045e+01,		3.104226285523994e+01,		3.113237637848898e+01,		3.122231530206252e+01,
		3.131208019025231e+01,		3.140167160518435e+01,		3.149109010682627e+01,		3.158033625299477e+01,		3.166941059936315e+01,
		3.175831369946873e+01,		3.184704610472045e+01,		3.193560836440626e+01,		3.202400102570083e+01,		3.211222463367294e+01,
		3.220027973129312e+01,		3.228816685944128e+01,		3.237588655691418e+01,		3.246343936043309e+01,		3.255082580465140e+01,
		3.263804642216217e+01,		3.272510174350580e+01,		3.281199229717762e+01,		3.289871860963544e+01,		3.298528120530730e+01,
		3.307168060659899e+01,		3.315791733390167e+01,		3.324399190559951e+01,		3.332990483807734e+01,		3.341565664572818e+01,
		3.350124784096086e+01,		3.358667893420768e+01,		3.367195043393192e+01,		3.375706284663553e+01,		3.384201667686661e+01,
		3.392681242722701e+01,		3.401145059837994e+01,		3.409593168905744e+01,		3.418025619606801e+01,		3.426442461430408e+01,
		3.434843743674953e+01,		3.443229515448726e+01,		3.451599825670662e+01,		3.459954723071088e+01,		3.468294256192480e+01,
		3.476618473390199e+01,		3.484927422833238e+01,		3.493221152504961e+01,		3.501499710203847e+01,		3.509763143544235e+01,
		3.518011499957052e+01,		3.526244826690552e+01,		3.534463170811051e+01,		3.542666579203658e+01,		3.550855098573010e+01,
		3.559028775443996e+01,		3.567187656162482e+01,		3.575331786896042e+01,		3.583461213634676e+01,		3.591575982191536e+01,
		3.599676138203639e+01,		3.607761727132588e+01,		3.615832794265282e+01,		3.623889384714640e+01,		3.631931543420295e+01,
		3.639959315149319e+01,		3.647972744496914e+01,		3.655971875887136e+01,		3.663956753573570e+01,		3.671927421640058e+01,
		3.679883924001376e+01,		3.687826304403939e+01,		3.695754606426489e+01,		3.703668873480794e+01,		3.711569148812327e+01,
		3.719455475500956e+01,		3.727327896461629e+01,		3.735186454445053e+01,		3.743031192038374e+01,		3.750862151665859e+01,
		3.758679375589563e+01,		3.766482905909998e+01,		3.774272784566816e+01,		3.782049053339468e+01,		3.789811753847866e+01,
		3.797560927553048e+01,		3.805296615757839e+01,		3.813018859607519e+01,		3.820727700090450e+01,		3.828423178038762e+01,
		3.836105334128976e+01,		3.843774208882672e+01,		3.851429842667121e+01,		3.859072275695936e+01,		3.866701548029707e+01,
		3.874317699576641e+01,		3.881920770093204e+01,		3.889510799184740e+01,		3.897087826306116e+01,		3.904651890762342e+01,
		3.912203031709201e+01,		3.919741288153869e+01,		3.927266698955535e+01,		3.934779302826026e+01,		3.942279138330418e+01,
		3.949766243887647e+01,		3.957240657771131e+01,		3.964702418109361e+01,		3.972151562886527e+01,		3.979588129943104e+01,
		3.987012156976470e+01,		3.994423681541488e+01,		4.001822741051116e+01,		4.009209372776994e+01,		4.016583613850040e+01,
		4.023945501261033e+01,		4.031295071861206e+01,		4.038632362362827e+01,		4.045957409339785e+01,		4.053270249228161e+01,
		4.060570918326813e+01,		4.067859452797951e+01,		4.075135888667705e+01,		4.082400261826693e+01,		4.089652608030601e+01,
		4.096892962900731e+01,		4.104121361924580e+01,		4.111337840456388e+01,		4.118542433717705e+01,		4.125735176797940e+01,
		4.132916104654921e+01,		4.140085252115443e+01,		4.147242653875812e+01,		4.154388344502405e+01,		4.161522358432197e+01,
		4.168644729973322e+01,		4.175755493305590e+01,		4.182854682481047e+01,		4.189942331424493e+01,		4.197018473934030e+01,
		4.204083143681574e+01,		4.211136374213397e+01,		4.218178198950658e+01,		4.225208651189902e+01,		4.232227764103612e+01,
		4.239235570740707e+01,		4.246232104027072e+01,		4.253217396766054e+01,		4.260191481639005e+01,		4.267154391205762e+01,
		4.274106157905175e+01,		4.281046814055604e+01,		4.287976391855426e+01,		4.294894923383538e+01,		4.301802440599848e+01,
		4.308698975345788e+01,		4.315584559344796e+01,		4.322459224202811e+01,		4.329323001408771e+01,		4.336175922335097e+01,
		4.343018018238178e+01,		4.349849320258857e+01,		4.356669859422918e+01,		4.363479666641561e+01,		4.370278772711883e+01,
		4.377067208317352e+01,		4.383845004028285e+01,		4.390612190302318e+01,		4.397368797484874e+01,		4.404114855809638e+01,
		4.410850395399012e+01,		4.417575446264591e+01,		4.424290038307618e+01,		4.430994201319446e+01,		4.437687964981996e+01,
		4.444371358868212e+01,		4.451044412442513e+01,		4.457707155061257e+01,		4.464359615973169e+01,		4.471001824319814e+01,
		4.477633809136029e+01,		4.484255599350363e+01,		4.490867223785533e+01,		4.497468711158855e+01,		4.504060090082685e+01,
		4.510641389064855e+01,		4.517212636509112e+01,		4.523773860715542e+01,		4.530325089881006e+01,		4.536866352099575e+01,
		4.543397675362944e+01,		4.549919087560867e+01,		4.556430616481580e+01,		4.562932289812217e+01,		4.569424135139236e+01,
		4.575906179948830e+01,		4.582378451627350e+01,		4.588840977461715e+01,		4.595293784639826e+01,		4.601736900250979e+01,
		4.608170351286265e+01,		4.614594164638989e+01,		4.621008367105067e+01,		4.627412985383431e+01,		4.633808046076435e+01,
		4.640193575690251e+01,		4.646569600635262e+01,		4.652936147226474e+01,		4.659293241683892e+01,		4.665640910132931e+01,
		4.671979178604792e+01,		4.678308073036862e+01,		4.684627619273094e+01,		4.690937843064400e+01,		4.697238770069033e+01,
		4.703530425852970e+01,		4.709812835890291e+01,		4.716086025563560e+01,		4.722350020164207e+01,		4.728604844892892e+01,
		4.734850524859898e+01,		4.741087085085484e+01,		4.747314550500274e+01,		4.753532945945616e+01,		4.759742296173945e+01,
		4.765942625849168e+01,		4.772133959547009e+01,		4.778316321755388e+01,		4.784489736874772e+01,		4.790654229218535e+01,
		4.796809823013325e+01,		4.802956542399416e+01,		4.809094411431056e+01,		4.815223454076838e+01,		4.821343694220035e+01,
		4.827455155658959e+01,		4.833557862107308e+01,		4.839651837194518e+01,		4.845737104466101e+01,		4.851813687383997e+01,
		4.857881609326911e+01,		4.863940893590661e+01,		4.869991563388513e+01,		4.876033641851521e+01,		4.882067152028863e+01
	},
	{
		7.951928919079541e-02,		2.384408381056673e-01,		3.969944883742292e-01,		5.551811109367171e-01,		7.130015582256976e-01,
		8.704566654893593e-01,		1.027547252052224e+00,		1.184274122515754e+00,		1.340638067901209e+00,		1.496639866737041e+00,
		1.652280286093002e+00,		1.807560082563078e+00,		1.962480003199270e+00,		2.117040786398160e+00,		2.271243162742145e+00,
		2.425087855797148e+00,		2.578575582868536e+00,		2.731707055716904e+00,		2.884482981235377e+00,		3.036904062089939e+00,
		3.188970997324317e+00,		3.340684482930845e+00,		3.492045212388711e+00,		3.643053877170917e+00,		3.793711167221254e+00,
		3.944017771402526e+00,		4.093974377917240e+00,		4.243581674701909e+00,		4.392840349796078e+00,		4.541751091687183e+00,
		4.690314589632231e+00,		4.838531533957352e+00,		4.986402616336140e+00,		5.133928530047783e+00,		5.281109970215776e+00,
		5.427947634028182e+00,		5.574442220940242e+00,		5.720594432860072e+00,		5.866404974318346e+00,		6.011874552622594e+00,
		6.157003877996899e+00,		6.301793663707662e+00,		6.446244626176121e+00,		6.590357485078225e+00,		6.734132963432524e+00,
		6.877571787676652e+00,		7.020674687732978e+00,		7.163442397063944e+00,		7.305875652717701e+00,		7.447975195364441e+00,
		7.589741769324019e+00,		7.731176122585271e+00,		7.872279006817485e+00,		8.013051177374493e+00,		8.153493393291798e+00,
		8.293606417277060e+00,		8.433391015694445e+00,		8.572847958543134e+00,		8.711978019430335e+00,		8.850781975539169e+00,
		8.989260607591778e+00,		9.127414699807899e+00,		9.265245039859254e+00,		9.402752418820038e+00,		9.539937631113748e+00,
		9.676801474456663e+00,		9.813344749798175e+00,		9.949568261258248e+00,		1.008547281606221e+01,		1.022105922447312e+01,
		1.035632829972193e+01,		1.049128085793551e+01,		1.062591771806299e+01,		1.076023970180034e+01,		1.089424763351347e+01,
		1.102794234016006e+01,		1.116132465121015e+01,		1.129439539856583e+01,		1.142715541647988e+01,		1.155960554147391e+01,
		1.169174661225561e+01,		1.182357946963574e+01,		1.195510495644464e+01,		1.208632391744845e+01,		1.221723719926524e+01,
		1.234784565028101e+01,		1.247815012056574e+01,		1.260815146178952e+01,		1.273785052713897e+01,		1.286724817123377e+01,
		1.299634525004367e+01,		1.312514262080581e+01,		1.325364114194261e+01,		1.338184167298011e+01,		1.350974507446692e+01,
		1.363735220789385e+01,		1.376466393561416e+01,		1.389168112076460e+01,		1.401840462718721e+01,		1.414483531935189e+01,
		1.427097406227995e+01,		1.439682172146835e+01,		1.452237916281503e+01,		1.464764725254507e+01,		1.477262685713790e+01,
		1.489731884325541e+01,		1.502172407767113e+01,		1.514584342720049e+01,		1.526967775863194e+01,		1.539322793865938e+01,
		1.551649483381543e+01,		1.563947931040600e+01,		1.576218223444575e+01,		1.588460447159479e+01,		1.600674688709647e+01,
		1.612861034571620e+01,		1.625019571168150e+01,		1.637150384862308e+01,		1.649253561951710e+01,		1.661329188662852e+01,
		1.673377351145554e+01,		1.685398135467528e+01,		1.697391627609039e+01,		1.709357913457693e+01,		1.721297078803327e+01,
		1.733209209333012e+01,		1.745094390626168e+01,		1.756952708149778e+01,		1.768784247253724e+01,		1.780589093166218e+01,
		1.792367330989347e+01,		1.804119045694720e+01,		1.815844322119217e+01,		1.827543244960854e+01,		1.839215898774729e+01,
		1.850862367969089e+01,		1.862482736801487e+01,		1.874077089375043e+01,		1.885645509634796e+01,		1.897188081364163e+01,
		1.908704888181480e+01,		1.920196013536652e+01,		1.931661540707885e+01,		1.943101552798511e+01,		1.954516132733914e+01,
		1.965905363258526e+01,		1.977269326932925e+01,		1.988608106131023e+01,		1.999921783037317e+01,		2.011210439644253e+01,
		2.022474157749647e+01,		2.033713018954206e+01,		2.044927104659112e+01,		2.056116496063698e+01,		2.067281274163195e+01,
		2.078421519746555e+01,		2.089537313394346e+01,		2.100628735476725e+01,		2.111695866151478e+01,		2.122738785362136e+01,
		2.133757572836151e+01,		2.144752308083151e+01,		2.155723070393248e+01,		2.166669938835425e+01,		2.177592992255977e+01,
		2.188492309277020e+01,		2.199367968295057e+01,		2.210220047479603e+01,		2.221048624771883e+01,		2.231853777883563e+01,
		2.242635584295564e+01,		2.253394121256905e+01,		2.264129465783628e+01,		2.274841694657746e+01,		2.285530884426273e+01,
		2.296197111400279e+01,		2.306840451654008e+01,		2.317460981024044e+01,		2.328058775108521e+01,		2.338633909266378e+01,
		2.349186458616662e+01,		2.359716498037880e+01,		2.370224102167379e+01,		2.380709345400786e+01,		2.391172301891478e+01,
		2.401613045550095e+01,		2.412031650044093e+01,		2.422428188797330e+01,		2.432802734989708e+01,		2.443155361556818e+01,
		2.453486141189654e+01,		2.463795146334340e+01,		2.474082449191906e+01,		2.484348121718081e+01,		2.494592235623128e+01,
		2.504814862371715e+01,		2.515016073182803e+01,		2.525195939029572e+01,		2.535354530639373e+01,		2.545491918493721e+01,
		2.555608172828283e+01,		2.565703363632935e+01,		2.575777560651809e+01,		2.585830833383386e+01,		2.595863251080609e+01,
		2.605874882751012e+01,		2.615865797156883e+01,		2.625836062815442e+01,		2.635785747999048e+01,		2.645714920735420e+01,
		2.655623648807876e+01,		2.665511999755613e+01,		2.675380040873975e+01,		2.685227839214765e+01,		2.695055461586564e+01,
		2.704862974555071e+01,		2.714650444443459e+01,		2.724417937332747e+01,		2.734165519062191e+01,		2.743893255229690e+01,
		2.753601211192204e+01,		2.763289452066189e+01,		2.772958042728052e+01,		2.782607047814601e+01,		2.792236531723539e+01,
		2.801846558613940e+01,		2.811437192406754e+01,		2.821008496785327e+01,		2.830560535195917e+01,		2.840093370848240e+01,
		2.849607066716012e+01,		2.859101685537507e+01,		2.868577289816132e+01,		2.878033941820997e+01,		2.887471703587507e+01,
		2.896890636917958e+01,		2.906290803382141e+01,		2.915672264317960e+01,		2.925035080832047e+01,		2.934379313800397e+01,
		2.943705023869003e+01,		2.953012271454501e+01,		2.962301116744819e+01,		2.971571619699839e+01,		2.980823840052054e+01,
		2.990057837307246e+01,		2.999273670745153e+01,		3.008471399420162e+01,		3.017651082161981e+01,		3.026812777576343e+01,
		3.035956544045697e+01,		3.045082439729909e+01,		3.054190522566964e+01,		3.063280850273685e+01,		3.072353480346437e+01,
		3.081408470061849e+01,		3.090445876477531e+01,		3.099465756432800e+01,		3.108468166549406e+01,		3.117453163232264e+01,
		3.126420802670186e+01,		3.135371140836611e+01,		3.144304233490348e+01,		3.153220136176319e+01,		3.162118904226289e+01,
		3.171000592759622e+01,		3.179865256684021e+01,		3.188712950696274e+01,		3.197543729283006e+01,		3.206357646721428e+01,
		3.215154757080087e+01,		3.223935114219617e+01,		3.232698771793498e+01,		3.241445783248805e+01,		3.250176201826960e+01,
		3.258890080564498e+01,		3.267587472293808e+01,		3.276268429643906e+01,		3.284933005041174e+01,		3.293581250710133e+01,
		3.302213218674185e+01,		3.310828960756378e+01,		3.319428528580163e+01,		3.328011973570143e+01,		3.336579346952838e+01,
		3.345130699757433e+01,		3.353666082816536e+01,		3.362185546766932e+01,		3.370689142050340e+01,		3.379176918914157e+01,
		3.387648927412218e+01,		3.396105217405547e+01,		3.404545838563101e+01,		3.412970840362532e+01,		3.421380272090916e+01,
		3.429774182845519e+01,		3.438152621534533e+01,		3.446515636877820e+01,		3.454863277407664e+01,		3.463195591469498e+01,
		3.471512627222663e+01,		3.479814432641135e+01,		3.488101055514261e+01,		3.496372543447504e+01,		3.504628943863175e+01,
		3.512870304001159e+01,		3.521096670919654e+01,		3.529308091495898e+01,		3.537504612426895e+01,		3.545686280230142e+01,
		3.553853141244355e+01,		3.562005241630192e+01,		3.570142627370963e+01,		3.578265344273362e+01,		3.586373437968177e+01,
		3.594466953911005e+01,		3.602545937382965e+01,		3.610610433491408e+01,		3.618660487170621e+01,		3.626696143182541e+01,
		3.634717446117457e+01,		3.642724440394710e+01,		3.650717170263388e+01,		3.658695679803036e+01,		3.666660012924342e+01,
		3.674610213369828e+01,		3.682546324714549e+01,		3.690468390366785e+01,		3.698376453568707e+01,		3.706270557397087e+01,
		3.714150744763960e+01,		3.722017058417312e+01,		3.729869540941766e+01,		3.737708234759235e+01,		3.745533182129613e+01,
		3.753344425151441e+01,		3.761142005762569e+01,		3.768925965740833e+01,		3.776696346704699e+01,		3.784453190113948e+01,
		3.792196537270318e+01,		3.799926429318159e+01,		3.807642907245097e+01,		3.815346011882681e+01,		3.823035783907025e+01,
		3.830712263839464e+01,		3.838375492047193e+01,		3.846025508743907e+01,		3.853662353990446e+01,		3.861286067695423e+01,
		3.868896689615869e+01,		3.876494259357853e+01,		3.884078816377119e+01,		3.891650399979716e+01,		3.899209049322607e+01,
		3.906754803414309e+01,		3.914287701115502e+01,		3.921807781139652e+01,		3.929315082053620e+01,		3.936809642278274e+01,
		3.944291500089110e+01,		3.951760693616842e+01,		3.959217260848022e+01,		3.966661239625635e+01,		3.974092667649697e+01,
		3.981511582477865e+01,		3.988918021526013e+01,		3.996312022068842e+01,		4.003693621240465e+01,		4.011062856034986e+01,
		4.018419763307102e+01,		4.025764379772674e+01,		4.033096742009309e+01,		4.040416886456946e+01,		4.047724849418425e+01,
		4.055020667060061e+01,		4.062304375412218e+01,		4.069576010369877e+01,		4.076835607693203e+01,		4.084083203008107e+01,
		4.091318831806808e+01,		4.098542529448402e+01,		4.105754331159400e+01,		4.112954272034298e+01,		4.120142387036131e+01,
		4.127318710997012e+01,		4.134483278618683e+01,		4.141636124473070e+01,		4.148777283002815e+01,		4.155906788521816e+01,
		4.163024675215782e+01,		4.170130977142751e+01,		4.177225728233632e+01,		4.184308962292734e+01,		4.191380712998302e+01,
		4.198441013903037e+01,		4.205489898434627e+01,		4.212527399896261e+01,		4.219553551467158e+01,		4.226568386203090e+01,
		4.233571937036875e+01,		4.240564236778922e+01,		4.247545318117719e+01,		4.254515213620354e+01,		4.261473955733021e+01,
		4.268421576781515e+01,		4.275358108971756e+01,		4.282283584390269e+01,		4.289198035004693e+01,		4.296101492664276e+01,
		4.302993989100369e+01,		4.309875555926917e+01,		4.316746224640953e+01,		4.323606026623082e+01,		4.330454993137968e+01,
		4.337293155334817e+01,		4.344120544247864e+01,		4.350937190796841e+01,		4.357743125787474e+01,		4.364538379911933e+01,
		4.371322983749328e+01,		4.378096967766167e+01,		4.384860362316838e+01,		4.391613197644056e+01,		4.398355503879345e+01,
		4.405087311043503e+01,		4.411808649047045e+01,		4.418519547690686e+01,		4.425220036665779e+01,		4.431910145554779e+01,
		4.438589903831695e+01,		4.445259340862543e+01,		4.451918485905792e+01,		4.458567368112809e+01,		4.465206016528320e+01,
		4.471834460090829e+01,		4.478452727633079e+01,		4.485060847882482e+01,		4.491658849461563e+01,		4.498246760888394e+01,
		4.504824610577020e+01,		4.511392426837904e+01,		4.517950237878349e+01,		4.524498071802925e+01,		4.531035956613903e+01,
		4.537563920211672e+01,		4.544081990395166e+01,		4.550590194862285e+01,		4.557088561210308e+01,		4.563577116936320e+01,
		4.570055889437618e+01,		4.576524906012134e+01,		4.582984193858834e+01,		4.589433780078141e+01,		4.595873691672337e+01,
		4.602303955545969e+01,		4.608724598506253e+01,		4.615135647263481e+01,		4.621537128431417e+01,		4.627929068527701e+01,
		4.634311493974245e+01,		4.640684431097620e+01,		4.647047906129472e+01,		4.653401945206889e+01,		4.659746574372809e+01,
		4.666081819576403e+01,		4.672407706673460e+01,		4.678724261426773e+01,		4.685031509506534e+01,		4.691329476490700e+01,
		4.697618187865378e+01,		4.703897669025219e+01,		4.710167945273767e+01,		4.716429041823857e+01,		4.722680983797989e+01,
		4.728923796228681e+01,		4.735157504058861e+01,		4.741382132142224e+01,		4.747597705243604e+01,		4.753804248039337e+01,
		4.760001785117623e+01,		4.766190340978903e+01,		4.772369940036195e+01,		4.778540606615479e+01,		4.784702364956038e+01,
		4.790855239210817e+01,		4.796999253446791e+01,		4.803134431645295e+01,		4.809260797702397e+01,		4.815378375429236e+01,
		4.821487188552374e+01,		4.827587260714144e+01,		4.833678615472994e+01,		4.839761276303832e+01,		4.845835266598367e+01,
		4.851900609665453e+01,		4.857957328731423e+01,		4.864005446940434e+01,		4.870044987354800e+01,		4.876075972955326e+01
	},
	{
		7.936229561829952e-02,		2.379704238337373e-01,		3.962118279394186e-01,		5.540873782898703e-01,		7.115979268776341e-01,
		8.687443086411545e-01,		1.025527342710921e+00,		1.181947833596289e+00,		1.338006572315301e+00,		1.493704337469780e+00,
		1.649041896267820e+00,		1.804020005495758e+00,		1.958639412441637e+00,		2.112900855772055e+00,		2.266805066364266e+00,
		2.420352768095297e+00,		2.573544678589818e+00,		2.726381509928384e+00,		2.878863969317663e+00,		3.030992759724177e+00,
		3.182768580473015e+00,		3.334192127812970e+00,		3.485264095449455e+00,		3.635985175046504e+00,		3.786356056699173e+00,
		3.936377429377531e+00,		4.086049981343461e+00,		4.235374400541362e+00,		4.384351374963926e+00,		4.532981592993985e+00,
		4.681265743723493e+00,		4.829204517250611e+00,		4.976798604955865e+00,		5.124048699758272e+00,		5.270955496352341e+00,
		5.417519691426792e+00,		5.563741983865806e+00,		5.709623074933616e+00,		5.855163668443215e+00,		6.000364470909844e+00,
		6.145226191690086e+00,		6.289749543107142e+00,		6.433935240562999e+00,		6.577784002638128e+00,		6.721296551179286e+00,
		6.864473611376050e+00,		7.007315911826621e+00,		7.149824184593432e+00,		7.291999165249138e+00,		7.433841592913415e+00,
		7.575352210281108e+00,		7.716531763642170e+00,		7.857381002893828e+00,		7.997900681545458e+00,		8.138091556716486e+00,
		8.277954389127817e+00,		8.417489943087105e+00,		8.556698986468223e+00,		8.695582290685339e+00,		8.834140630661881e+00,
		8.972374784794741e+00,		9.110285534914006e+00,		9.247873666238521e+00,		9.385139967327582e+00,		9.522085230029012e+00,
		9.658710249423866e+00,		9.795015823768033e+00,		9.931002754430999e+00,		1.006667184583192e+01,		1.020202390537331e+01,
		1.033705974337246e+01,		1.047178017299090e+01,		1.060618601016195e+01,		1.074027807351670e+01,		1.087405718430841e+01,
		1.100752416633565e+01,		1.114067984586428e+01,		1.127352505154836e+01,		1.140606061435025e+01,		1.153828736745985e+01,
		1.167020614621335e+01,		1.180181778801142e+01,		1.193312313223697e+01,		1.206412302017271e+01,		1.219481829491849e+01,
		1.232520980130855e+01,		1.245529838582880e+01,		1.258508489653419e+01,		1.271457018296627e+01,		1.284375509607099e+01,
		1.297264048811677e+01,		1.310122721261311e+01,		1.322951612422949e+01,		1.335750807871485e+01,		1.348520393281771e+01,
		1.361260454420680e+01,		1.373971077139242e+01,		1.386652347364851e+01,		1.399304351093546e+01,		1.411927174382373e+01,
		1.424520903341833e+01,		1.437085624128406e+01,		1.449621422937181e+01,		1.462128385994561e+01,		1.474606599551075e+01,
		1.487056149874283e+01,		1.499477123241779e+01,		1.511869605934295e+01,		1.524233684228911e+01,		1.536569444392367e+01,
		1.548876972674478e+01,		1.561156355301661e+01,		1.573407678470563e+01,		1.585631028341806e+01,		1.597826491033832e+01,
		1.609994152616862e+01,		1.622134099106966e+01,		1.634246416460242e+01,		1.646331190567101e+01,		1.658388507246669e+01,
		1.670418452241298e+01,		1.682421111211186e+01,		1.694396569729099e+01,		1.706344913275220e+01,		1.718266227232090e+01,
		1.730160596879667e+01,		1.742028107390489e+01,		1.753868843824948e+01,		1.765682891126665e+01,		1.777470334117976e+01,
		1.789231257495520e+01,		1.800965745825932e+01,		1.812673883541635e+01,		1.824355754936747e+01,		1.836011444163068e+01,
		1.847641035226188e+01,		1.859244611981684e+01,		1.870822258131407e+01,		1.882374057219888e+01,		1.893900092630811e+01,
		1.905400447583611e+01,		1.916875205130130e+01,		1.928324448151403e+01,		1.939748259354499e+01,		1.951146721269480e+01,
		1.962519916246427e+01,		1.973867926452565e+01,		1.985190833869469e+01,		1.996488720290353e+01,		2.007761667317447e+01,
		2.019009756359445e+01,		2.030233068629047e+01,		2.041431685140568e+01,		2.052605686707631e+01,		2.063755153940932e+01,
		2.074880167246084e+01,		2.085980806821532e+01,		2.097057152656537e+01,		2.108109284529240e+01,		2.119137282004787e+01,
		2.130141224433523e+01,		2.141121190949259e+01,		2.152077260467600e+01,		2.163009511684335e+01,		2.173918023073898e+01,
		2.184802872887882e+01,		2.195664139153624e+01,		2.206501899672837e+01,		2.217316232020310e+01,		2.228107213542664e+01,
		2.238874921357158e+01,		2.249619432350554e+01,		2.260340823178038e+01,		2.271039170262188e+01,		2.281714549791996e+01,
		2.292367037721942e+01,		2.302996709771111e+01,		2.313603641422366e+01,		2.324187907921562e+01,		2.334749584276807e+01,
		2.345288745257770e+01,		2.355805465395032e+01,		2.366299818979476e+01,		2.376771880061725e+01,		2.387221722451616e+01,
		2.397649419717716e+01,		2.408055045186876e+01,		2.418438671943823e+01,		2.428800372830792e+01,		2.439140220447186e+01,
		2.449458287149284e+01,		2.459754645049970e+01,		2.470029366018502e+01,		2.480282521680317e+01,		2.490514183416862e+01,
		2.500724422365458e+01,		2.510913309419191e+01,		2.521080915226843e+01,		2.531227310192839e+01,		2.541352564477229e+01,
		2.551456747995693e+01,		2.561539930419578e+01,		2.571602181175959e+01,		2.581643569447718e+01,		2.591664164173659e+01,
		2.601664034048637e+01,		2.611643247523714e+01,		2.621601872806339e+01,		2.631539977860550e+01,		2.641457630407185e+01,
		2.651354897924135e+01,		2.661231847646604e+01,		2.671088546567378e+01,		2.680925061437143e+01,		2.690741458764784e+01,
		2.700537804817739e+01,		2.710314165622336e+01,		2.720070606964170e+01,		2.729807194388491e+01,		2.739523993200594e+01,
		2.749221068466249e+01,		2.758898485012121e+01,		2.768556307426223e+01,		2.778194600058367e+01,		2.787813427020644e+01,
		2.797412852187901e+01,		2.806992939198246e+01,		2.816553751453551e+01,		2.826095352119977e+01,		2.835617804128504e+01,
		2.845121170175477e+01,		2.854605512723154e+01,		2.864070894000275e+01,		2.873517376002631e+01,		2.882945020493653e+01,
		2.892353889004995e+01,		2.901744042837139e+01,		2.911115543060008e+01,		2.920468450513572e+01,		2.929802825808479e+01,
		2.939118729326694e+01,		2.948416221222120e+01,		2.957695361421262e+01,		2.966956209623869e+01,		2.976198825303594e+01,
		2.985423267708664e+01,		2.994629595862543e+01,		3.003817868564615e+01,		3.012988144390858e+01,		3.022140481694537e+01,
		3.031274938606895e+01,		3.040391573037840e+01,		3.049490442676656e+01,		3.058571604992699e+01,		3.067635117236108e+01,
		3.076681036438523e+01,		3.085709419413785e+01,		3.094720322758666e+01,		3.103713802853594e+01,		3.112689915863363e+01,
		3.121648717737875e+01,		3.130590264212861e+01,		3.139514610810616e+01,		3.148421812840735e+01,		3.157311925400846e+01,
		3.166185003377354e+01,		3.175041101446175e+01,		3.183880274073480e+01,		3.192702575516445e+01,		3.201508059823982e+01,
		3.210296780837499e+01,		3.219068792191639e+01,		3.227824147315031e+01,		3.236562899431037e+01,		3.245285101558502e+01,
		3.253990806512508e+01,		3.262680066905115e+01,		3.271352935146124e+01,		3.280009463443820e+01,		3.288649703805729e+01,
		3.297273708039359e+01,		3.305881527752968e+01,		3.314473214356300e+01,		3.323048819061344e+01,		3.331608392883081e+01,
		3.340151986640242e+01,		3.348679650956045e+01,		3.357191436258956e+01,		3.365687392783436e+01,		3.374167570570678e+01,
		3.382632019469369e+01,		3.391080789136430e+01,		3.399513929037757e+01,		3.407931488448974e+01,		3.416333516456169e+01,
		3.424720061956642e+01,		3.433091173659643e+01,		3.441446900087111e+01,		3.449787289574414e+01,		3.458112390271089e+01,
		3.466422250141572e+01,		3.474716916965937e+01,		3.482996438340630e+01,		3.491260861679189e+01,		3.499510234212999e+01,
		3.507744602991986e+01,		3.515964014885371e+01,		3.524168516582385e+01,		3.532358154592993e+01,		3.540532975248608e+01,
		3.548693024702826e+01,		3.556838348932129e+01,		3.564968993736613e+01,		3.573085004740687e+01,		3.581186427393797e+01,
		3.589273306971136e+01,		3.597345688574343e+01,		3.605403617132220e+01,		3.613447137401423e+01,		3.621476293967178e+01,
		3.629491131243968e+01,		3.637491693476239e+01,		3.645478024739094e+01,		3.653450168938981e+01,		3.661408169814394e+01,
		3.669352070936549e+01,		3.677281915710083e+01,		3.685197747373729e+01,		3.693099609001008e+01,		3.700987543500901e+01,
		3.708861593618524e+01,		3.716721801935815e+01,		3.724568210872197e+01,		3.732400862685254e+01,		3.740219799471398e+01,
		3.748025063166533e+01,		3.755816695546723e+01,		3.763594738228847e+01,		3.771359232671269e+01,		3.779110220174480e+01,
		3.786847741881765e+01,		3.794571838779850e+01,		3.802282551699550e+01,		3.809979921316421e+01,		3.817663988151396e+01,
		3.825334792571437e+01,		3.832992374790170e+01,		3.840636774868524e+01,		3.848268032715365e+01,		3.855886188088131e+01,
		3.863491280593456e+01,		3.871083349687809e+01,		3.878662434678107e+01,		3.886228574722346e+01,		3.893781808830222e+01,
		3.901322175863744e+01,		3.908849714537855e+01,		3.916364463421039e+01,		3.923866460935940e+01,		3.931355745359964e+01,
		3.938832354825887e+01,		3.946296327322466e+01,		3.953747700695021e+01,		3.961186512646054e+01,		3.968612800735840e+01,
		3.976026602383012e+01,		3.983427954865164e+01,		3.990816895319434e+01,		3.998193460743097e+01,		4.005557687994133e+01,
		4.012909613791835e+01,		4.020249274717366e+01,		4.027576707214348e+01,		4.034891947589433e+01,		4.042195032012874e+01,
		4.049485996519103e+01,		4.056764877007290e+01,		4.064031709241910e+01,		4.071286528853313e+01,		4.078529371338275e+01,
		4.085760272060564e+01,		4.092979266251491e+01,		4.100186389010467e+01,		4.107381675305557e+01,		4.114565159974017e+01,
		4.121736877722858e+01,		4.128896863129380e+01,		4.136045150641711e+01,		4.143181774579357e+01,		4.150306769133736e+01,
		4.157420168368706e+01,		4.164522006221110e+01,		4.171612316501298e+01,		4.178691132893660e+01,		4.185758488957151e+01,
		4.192814418125814e+01,		4.199858953709305e+01,		4.206892128893406e+01,		4.213913976740557e+01,		4.220924530190347e+01,
		4.227923822060051e+01,		4.234911885045133e+01,		4.241888751719743e+01,		4.248854454537243e+01,		4.255809025830698e+01,
		4.262752497813376e+01,		4.269684902579263e+01,		4.276606272103542e+01,		4.283516638243108e+01,		4.290416032737042e+01,
		4.297304487207118e+01,		4.304182033158284e+01,		4.311048701979150e+01,		4.317904524942476e+01,		4.324749533205653e+01,
		4.331583757811188e+01,		4.338407229687168e+01,		4.345219979647761e+01,		4.352022038393672e+01,		4.358813436512614e+01,
		4.365594204479801e+01,		4.372364372658387e+01,		4.379123971299952e+01,		4.385873030544962e+01,		4.392611580423230e+01,
		4.399339650854376e+01,		4.406057271648290e+01,		4.412764472505577e+01,		4.419461283018028e+01,		4.426147732669060e+01,
		4.432823850834170e+01,		4.439489666781387e+01,		4.446145209671710e+01,		4.452790508559566e+01,		4.459425592393237e+01,
		4.466050490015317e+01,		4.472665230163136e+01,		4.479269841469208e+01,		4.485864352461658e+01,		4.492448791564667e+01,
		4.499023187098886e+01,		4.505587567281877e+01,		4.512141960228544e+01,		4.518686393951548e+01,		4.525220896361738e+01,
		4.531745495268570e+01,		4.538260218380525e+01,		4.544765093305536e+01,		4.551260147551398e+01,		4.557745408526180e+01,
		4.564220903538641e+01,		4.570686659798646e+01,		4.577142704417570e+01,		4.583589064408700e+01,		4.590025766687656e+01,
		4.596452838072776e+01,		4.602870305285538e+01,		4.609278194950942e+01,		4.615676533597917e+01,		4.622065347659730e+01,
		4.628444663474354e+01,		4.634814507284885e+01,		4.641174905239921e+01,		4.647525883393958e+01,		4.653867467707781e+01,
		4.660199684048838e+01,		4.666522558191639e+01,		4.672836115818133e+01,		4.679140382518089e+01,		4.685435383789471e+01,
		4.691721145038835e+01,		4.697997691581678e+01,		4.704265048642842e+01,		4.710523241356864e+01,		4.716772294768355e+01,
		4.723012233832381e+01,		4.729243083414811e+01,		4.735464868292703e+01,		4.741677613154659e+01,		4.747881342601187e+01,
		4.754076081145072e+01,		4.760261853211730e+01,		4.766438683139568e+01,		4.772606595180338e+01,		4.778765613499498e+01,
		4.784915762176566e+01,		4.791057065205473e+01,		4.797189546494905e+01,		4.803313229868664e+01,		4.809428139066011e+01,
		4.815534297742014e+01,		4.821631729467889e+01,		4.827720457731350e+01,		4.833800505936948e+01,		4.839871897406406e+01,
		4.845934655378964e+01,		4.851988803011722e+01,		4.858034363379961e+01,		4.864071359477490e+01,		4.870099814216979e+01
	},
	{
		7.920592092122392e-02,		2.375018638122078e-01,		3.954322522813367e-01,		5.529979560652037e-01,		7.101998266825674e-01,
		8.670386987270526e-01,		1.023515391098914e+00,		1.179630708178255e+00,		1.335385440941999e+00,		1.490780368026833e+00,
		1.645816256740233e+00,		1.800493864021633e+00,		1.954813937355693e+00,		2.108777215639557e+00,		2.262384430005936e+00,
		2.415636304603755e+00,		2.568533557338063e+00,		2.721076900570826e+00,		2.873267041784184e+00,		3.025104684207663e+00,
		3.176590527410815e+00,		3.327725267862683e+00,		3.478509599459441e+00,		3.628944214021519e+00,		3.779029801761458e+00,
		3.928767051723735e+00,		4.078156652197690e+00,		4.227199291104707e+00,		4.375895656360735e+00,		4.524246436215178e+00,
		4.672252319567200e+00,		4.819913996260372e+00,		4.967232157356642e+00,		5.114207495390514e+00,		5.260840704604322e+00,
		5.407132481165405e+00,		5.553083523366057e+00,		5.698694531806973e+00,		5.843966209564978e+00,		5.988899262345767e+00,
		6.133494398622323e+00,		6.277752329759743e+00,		6.421673770127047e+00,		6.565259437196680e+00,		6.708510051632234e+00,
		6.851426337365005e+00,		6.994009021659962e+00,		7.136258835171600e+00,		7.278176511990274e+00,		7.419762789679449e+00,
		7.561018409304356e+00,		7.701944115452548e+00,		7.842540656246752e+00,		7.982808783350457e+00,		8.122749251966665e+00,
		8.262362820830152e+00,		8.401650252193676e+00,		8.540612311808411e+00,		8.679249768899048e+00,		8.817563396133814e+00,
		8.955553969589742e+00,		9.093222268713566e+00,		9.230569076278437e+00,		9.367595178336767e+00,		9.504301364169560e+00,
		9.640688426232296e+00,		9.776757160097837e+00,		9.912508364396398e+00,		1.004794284075293e+01,		1.018306139372209e+01,
		1.031786483072094e+01,		1.045235396195971e+01,		1.058652960037070e+01,		1.072039256153548e+01,		1.085394366361069e+01,
		1.098718372725243e+01,		1.112011357553956e+01,		1.125273403389591e+01,		1.138504593001168e+01,		1.151705009376397e+01,
		1.164874735713681e+01,		1.178013855414058e+01,		1.191122452073111e+01,		1.204200609472844e+01,		1.217248411573537e+01,
		1.230265942505602e+01,		1.243253286561427e+01,		1.256210528187231e+01,		1.269137751974942e+01,		1.282035042654091e+01,
		1.294902485083740e+01,		1.307740164244447e+01,		1.320548165230277e+01,		1.333326573240855e+01,		1.346075473573489e+01,
		1.358794951615338e+01,		1.371485092835654e+01,		1.384145982778091e+01,		1.396777707053088e+01,		1.409380351330332e+01,
		1.421954001331298e+01,		1.434498742821879e+01,		1.447014661605095e+01,		1.459501843513905e+01,		1.471960374404098e+01,
		1.484390340147293e+01,		1.496791826624024e+01,		1.509164919716929e+01,		1.521509705304048e+01,		1.533826269252203e+01,
		1.546114697410507e+01,		1.558375075603957e+01,		1.570607489627145e+01,		1.582812025238067e+01,		1.594988768152048e+01,
		1.607137804035767e+01,		1.619259218501398e+01,		1.631353097100848e+01,		1.643419525320115e+01,		1.655458588573752e+01,
		1.667470372199435e+01,		1.679454961452639e+01,		1.691412441501431e+01,		1.703342897421367e+01,		1.715246414190483e+01,
		1.727123076684418e+01,		1.738972969671625e+01,		1.750796177808690e+01,		1.762592785635761e+01,		1.774362877572083e+01,
		1.786106537911623e+01,		1.797823850818817e+01,		1.809514900324406e+01,		1.821179770321372e+01,		1.832818544560979e+01,
		1.844431306648918e+01,		1.856018140041529e+01,		1.867579128042147e+01,		1.879114353797523e+01,		1.890623900294345e+01,
		1.902107850355855e+01,		1.913566286638557e+01,		1.924999291629012e+01,		1.936406947640727e+01,		1.947789336811132e+01,
		1.959146541098636e+01,		1.970478642279778e+01,		1.981785721946466e+01,		1.993067861503278e+01,		2.004325142164870e+01,
		2.015557644953453e+01,		2.026765450696340e+01,		2.037948640023594e+01,		2.049107293365730e+01,		2.060241490951505e+01,
		2.071351312805775e+01,		2.082436838747432e+01,		2.093498148387406e+01,		2.104535321126743e+01,		2.115548436154740e+01,
		2.126537572447168e+01,		2.137502808764539e+01,		2.148444223650455e+01,		2.159361895430007e+01,		2.170255902208252e+01,
		2.181126321868738e+01,		2.191973232072090e+01,		2.202796710254669e+01,		2.213596833627271e+01,		2.224373679173895e+01,
		2.235127323650553e+01,		2.245857843584153e+01,		2.256565315271420e+01,		2.267249814777870e+01,		2.277911417936849e+01,
		2.288550200348597e+01,		2.299166237379384e+01,		2.309759604160689e+01,		2.320330375588403e+01,		2.330878626322117e+01,
		2.341404430784414e+01,		2.351907863160238e+01,		2.362388997396279e+01,		2.372847907200416e+01,		2.383284666041198e+01,
		2.393699347147354e+01,		2.404092023507359e+01,		2.414462767869018e+01,		2.424811652739105e+01,		2.435138750383026e+01,
		2.445444132824521e+01,		2.455727871845397e+01,		2.465990038985302e+01,		2.476230705541523e+01,		2.486449942568818e+01,
		2.496647820879281e+01,		2.506824411042239e+01,		2.516979783384167e+01,		2.527114007988646e+01,		2.537227154696339e+01,
		2.547319293104999e+01,		2.557390492569498e+01,		2.567440822201889e+01,		2.577470350871483e+01,		2.587479147204963e+01,
		2.597467279586507e+01,		2.607434816157948e+01,		2.617381824818946e+01,		2.627308373227183e+01,		2.637214528798585e+01,
		2.647100358707558e+01,		2.656965929887250e+01,		2.666811309029822e+01,		2.676636562586751e+01,		2.686441756769140e+01,
		2.696226957548049e+01,		2.705992230654851e+01,		2.715737641581584e+01,		2.725463255581352e+01,		2.735169137668702e+01,
		2.744855352620047e+01,		2.754521964974095e+01,		2.764169039032280e+01,		2.773796638859226e+01,		2.783404828283206e+01,
		2.792993670896633e+01,		2.802563230056540e+01,		2.812113568885099e+01,		2.821644750270122e+01,		2.831156836865602e+01,
		2.840649891092244e+01,		2.850123975138014e+01,		2.859579150958702e+01,		2.869015480278483e+01,		2.878433024590504e+01,
		2.887831845157463e+01,		2.897212003012206e+01,		2.906573558958335e+01,		2.915916573570815e+01,		2.925241107196593e+01,
		2.934547219955230e+01,		2.943834971739530e+01,		2.953104422216183e+01,		2.962355630826409e+01,		2.971588656786619e+01,
		2.980803559089066e+01,		2.990000396502515e+01,		2.999179227572915e+01,		3.008340110624069e+01,		3.017483103758322e+01,
		3.026608264857244e+01,		3.035715651582317e+01,		3.044805321375637e+01,		3.053877331460606e+01,		3.062931738842640e+01,
		3.071968600309869e+01,		3.080987972433855e+01,		3.089989911570300e+01,		3.098974473859761e+01,		3.107941715228376e+01,
		3.116891691388576e+01,		3.125824457839821e+01,		3.134740069869319e+01,		3.143638582552758e+01,		3.152520050755034e+01,
		3.161384529130995e+01,		3.170232072126160e+01,		3.179062733977470e+01,		3.187876568714019e+01,		3.196673630157790e+01,
		3.205453971924408e+01,		3.214217647423873e+01,		3.222964709861301e+01,		3.231695212237673e+01,		3.240409207350580e+01,
		3.249106747794961e+01,		3.257787885963858e+01,		3.266452674049154e+01,		3.275101164042322e+01,		3.283733407735173e+01,
		3.292349456720601e+01,		3.300949362393327e+01,		3.309533175950653e+01,		3.318100948393195e+01,		3.326652730525644e+01,
		3.335188572957497e+01,		3.343708526103814e+01,		3.352212640185957e+01,		3.360700965232330e+01,		3.369173551079132e+01,
		3.377630447371087e+01,		3.386071703562197e+01,		3.394497368916475e+01,		3.402907492508688e+01,		3.411302123225094e+01,
		3.419681309764181e+01,		3.428045100637401e+01,		3.436393544169908e+01,		3.444726688501288e+01,		3.453044581586300e+01,
		3.461347271195594e+01,		3.469634804916451e+01,		3.477907230153508e+01,		3.486164594129484e+01,		3.494406943885907e+01,
		3.502634326283836e+01,		3.510846788004584e+01,		3.519044375550437e+01,		3.527227135245372e+01,		3.535395113235779e+01,
		3.543548355491167e+01,		3.551686907804885e+01,		3.559810815794832e+01,		3.567920124904159e+01,		3.576014880401988e+01,
		3.584095127384110e+01,		3.592160910773689e+01,		3.600212275321966e+01,		3.608249265608956e+01,		3.616271926044148e+01,
		3.624280300867199e+01,		3.632274434148626e+01,		3.640254369790500e+01,		3.648220151527132e+01,		3.656171822925761e+01,
		3.664109427387243e+01,		3.672033008146722e+01,		3.679942608274327e+01,		3.687838270675828e+01,		3.695720038093337e+01,
		3.703587953105963e+01,		3.711442058130486e+01,		3.719282395422037e+01,		3.727109007074748e+01,		3.734921935022432e+01,
		3.742721221039236e+01,		3.750506906740299e+01,		3.758279033582416e+01,		3.766037642864693e+01,		3.773782775729195e+01,
		3.781514473161594e+01,		3.789232775991825e+01,		3.796937724894729e+01,		3.804629360390693e+01,		3.812307722846290e+01,
		3.819972852474928e+01,		3.827624789337468e+01,		3.835263573342878e+01,		3.842889244248844e+01,		3.850501841662416e+01,
		3.858101405040628e+01,		3.865687973691119e+01,		3.873261586772755e+01,		3.880822283296254e+01,		3.888370102124798e+01,
		3.895905081974651e+01,		3.903427261415763e+01,		3.910936678872389e+01,		3.918433372623696e+01,		3.925917380804360e+01,
		3.933388741405170e+01,		3.940847492273640e+01,		3.948293671114586e+01,		3.955727315490741e+01,		3.963148462823342e+01,
		3.970557150392705e+01,		3.977953415338838e+01,		3.985337294662011e+01,		3.992708825223342e+01,		4.000068043745377e+01,
		4.007414986812675e+01,		4.014749690872378e+01,		4.022072192234781e+01,		4.029382527073918e+01,		4.036680731428115e+01,
		4.043966841200562e+01,		4.051240892159887e+01,		4.058502919940704e+01,		4.065752960044178e+01,		4.072991047838586e+01,
		4.080217218559867e+01,		4.087431507312177e+01,		4.094633949068444e+01,		4.101824578670902e+01,		4.109003430831653e+01,
		4.116170540133202e+01,		4.123325941028999e+01,		4.130469667843980e+01,		4.137601754775102e+01,		4.144722235891876e+01,
		4.151831145136904e+01,		4.158928516326404e+01,		4.166014383150742e+01,		4.173088779174949e+01,		4.180151737839258e+01,
		4.187203292459610e+01,		4.194243476228183e+01,		4.201272322213905e+01,		4.208289863362970e+01,		4.215296132499346e+01,
		4.222291162325286e+01,		4.229274985421842e+01,		4.236247634249363e+01,		4.243209141148001e+01,		4.250159538338212e+01,
		4.257098857921258e+01,		4.264027131879700e+01,		4.270944392077891e+01,		4.277850670262478e+01,		4.284745998062879e+01,
		4.291630406991786e+01,		4.298503928445641e+01,		4.305366593705120e+01,		4.312218433935624e+01,		4.319059480187748e+01,
		4.325889763397775e+01,		4.332709314388124e+01,		4.339518163867857e+01,		4.346316342433128e+01,		4.353103880567661e+01,
		4.359880808643214e+01,		4.366647156920054e+01,		4.373402955547405e+01,		4.380148234563926e+01,		4.386883023898159e+01,
		4.393607353368990e+01,		4.400321252686111e+01,		4.407024751450462e+01,		4.413717879154694e+01,		4.420400665183610e+01,
		4.427073138814618e+01,		4.433735329218177e+01,		4.440387265458238e+01,		4.447028976492685e+01,		4.453660491173780e+01,
		4.460281838248603e+01,		4.466893046359472e+01,		4.473494144044402e+01,		4.480085159737514e+01,		4.486666121769488e+01,
		4.493237058367968e+01,		4.499797997658010e+01,		4.506348967662493e+01,		4.512889996302544e+01,		4.519421111397970e+01,
		4.525942340667665e+01,		4.532453711730032e+01,		4.538955252103401e+01,		4.545446989206438e+01,		4.551928950358565e+01,
		4.558401162780360e+01,		4.564863653593974e+01,		4.571316449823538e+01,		4.577759578395558e+01,		4.584193066139333e+01,
		4.590616939787339e+01,		4.597031225975649e+01,		4.603435951244313e+01,		4.609831142037766e+01,		4.616216824705215e+01,
		4.622593025501038e+01,		4.628959770585170e+01,		4.635317086023496e+01,		4.641664997788236e+01,		4.648003531758332e+01,
		4.654332713719835e+01,		4.660652569366282e+01,		4.666963124299082e+01,		4.673264404027895e+01,		4.679556433971003e+01,
		4.685839239455695e+01,		4.692112845718636e+01,		4.698377277906241e+01,		4.704632561075047e+01,		4.710878720192079e+01,
		4.717115780135227e+01,		4.723343765693597e+01,		4.729562701567889e+01,		4.735772612370754e+01,		4.741973522627161e+01,
		4.748165456774742e+01,		4.754348439164173e+01,		4.760522494059513e+01,		4.766687645638562e+01,		4.772843917993224e+01,
		4.778991335129848e+01,		4.785129920969584e+01,		4.791259699348731e+01,		4.797380694019085e+01,		4.803492928648282e+01,
		4.809596426820153e+01,		4.815691212035048e+01,		4.821777307710193e+01,		4.827854737180026e+01,		4.833923523696539e+01,
		4.839983690429599e+01,		4.846035260467305e+01,		4.852078256816310e+01,		4.858112702402155e+01,		4.864138620069598e+01
	},
	{
		7.905016144603749e-02,		2.370351470877522e-01,		3.946557431668509e-01,		5.519128187704284e-01,		7.088072249103849e-01,
		8.653397958011454e-01,		1.021511350077239e+00,		1.177322691953101e+00,		1.332774612327362e+00,		1.487867889833803e+00,
		1.642603291841074e+00,		1.796981575403192e+00,		1.951003488162749e+00,		2.104669769208710e+00,		2.257981149890590e+00,
		2.410938354590729e+00,		2.563542101456359e+00,		2.715793103093032e+00,		2.867692067220988e+00,		3.019239697295932e+00,
		3.170436693095658e+00,		3.321283751273920e+00,		3.471781565882861e+00,		3.621930828865302e+00,		3.771732230518129e+00,
		3.921186459927972e+00,		4.070294205380322e+00,		4.219056154743215e+00,		4.367472995826533e+00,		4.515545416717983e+00,
		4.663274106096726e+00,		4.810659753525623e+00,		4.957703049723039e+00,		5.104404686815089e+00,		5.250765358569185e+00,
		5.396785760609711e+00,		5.542466590616643e+00,		5.687808548507874e+00,		5.832812336605989e+00,		5.977478659790203e+00,
		6.121808225634167e+00,		6.265801744530279e+00,		6.409459929801194e+00,		6.552783497799067e+00,		6.695773167993211e+00,
		6.838429663046694e+00,		6.980753708882409e+00,		7.122746034739205e+00,		7.264407373218540e+00,		7.405738460322142e+00,
		7.546740035481215e+00,		7.687412841577549e+00,		7.827757624957045e+00,		7.967775135436031e+00,		8.107466126300809e+00,
		8.246831354300760e+00,		8.385871579635451e+00,		8.524587565936033e+00,		8.662980080241320e+00,		8.801049892968859e+00,
		8.938797777881264e+00,		9.076224512048233e+00,		9.213330875804372e+00,		9.350117652703245e+00,		9.486585629467839e+00,
		9.622735595937719e+00,		9.758568345013105e+00,		9.894084672596117e+00,		1.002928537752940e+01,		1.016417126153237e+01,
		1.029874312913519e+01,		1.043300178761078e+01,		1.056694804690505e+01,		1.070058271956535e+01,		1.083390662066760e+01,
		1.096692056774191e+01,		1.109962538069723e+01,		1.123202188174480e+01,		1.136411089532081e+01,		1.149589324800825e+01,
		1.162736976845816e+01,		1.175854128731034e+01,		1.188940863711367e+01,		1.201997265224609e+01,		1.215023416883439e+01,
		1.228019402467401e+01,		1.240985305914857e+01,		1.253921211314976e+01,		1.266827202899715e+01,		1.279703365035834e+01,
		1.292549782216938e+01,		1.305366539055553e+01,		1.318153720275246e+01,		1.330911410702794e+01,		1.343639695260401e+01,
		1.356338658957983e+01,		1.369008386885508e+01,		1.381648964205411e+01,		1.394260476145072e+01,		1.406843007989377e+01,
		1.419396645073363e+01,		1.431921472774927e+01,		1.444417576507645e+01,		1.456885041713663e+01,		1.469323953856680e+01,
		1.481734398415035e+01,		1.494116460874880e+01,		1.506470226723448e+01,		1.518795781442435e+01,		1.531093210501461e+01,
		1.543362599351653e+01,		1.555604033419316e+01,		1.567817598099719e+01,		1.580003378750980e+01,		1.592161460688052e+01,
		1.604291929176827e+01,		1.616394869428337e+01,		1.628470366593063e+01,		1.640518505755356e+01,		1.652539371927958e+01,
		1.664533050046636e+01,		1.676499624964920e+01,		1.688439181448944e+01,		1.700351804172402e+01,		1.712237577711602e+01,
		1.724096586540630e+01,		1.735928915026616e+01,		1.747734647425107e+01,		1.759513867875540e+01,		1.771266660396822e+01,
		1.782993108883008e+01,		1.794693297099086e+01,		1.806367308676854e+01,		1.818015227110903e+01,		1.829637135754698e+01,
		1.841233117816755e+01,		1.852803256356909e+01,		1.864347634282688e+01,		1.875866334345778e+01,		1.887359439138571e+01,
		1.898827031090818e+01,		1.910269192466368e+01,		1.921686005359995e+01,		1.933077551694314e+01,		1.944443913216784e+01,
		1.955785171496802e+01,		1.967101407922870e+01,		1.978392703699861e+01,		1.989659139846349e+01,		2.000900797192040e+01,
		2.012117756375262e+01,		2.023310097840552e+01,		2.034477901836307e+01,		2.045621248412514e+01,		2.056740217418559e+01,
		2.067834888501103e+01,		2.078905341102037e+01,		2.089951654456496e+01,		2.100973907590955e+01,		2.111972179321390e+01,
		2.122946548251496e+01,		2.133897092770984e+01,		2.144823891053937e+01,		2.155727021057222e+01,		2.166606560518980e+01,
		2.177462586957163e+01,		2.188295177668130e+01,		2.199104409725313e+01,		2.209890359977933e+01,		2.220653105049770e+01,
		2.231392721337988e+01,		2.242109285012016e+01,		2.252802872012492e+01,		2.263473558050229e+01,		2.274121418605271e+01,
		2.284746528925956e+01,		2.295348964028068e+01,		2.305928798694001e+01,		2.316486107471995e+01,		2.327020964675403e+01,
		2.337533444382007e+01,		2.348023620433374e+01,		2.358491566434254e+01,		2.368937355752026e+01,		2.379361061516178e+01,
		2.389762756617820e+01,		2.400142513709257e+01,		2.410500405203569e+01,		2.420836503274251e+01,		2.431150879854879e+01,
		2.441443606638817e+01,		2.451714755078944e+01,		2.461964396387433e+01,		2.472192601535544e+01,		2.482399441253461e+01,
		2.492584986030155e+01,		2.502749306113277e+01,		2.512892471509079e+01,		2.523014551982363e+01,		2.533115617056464e+01,
		2.543195736013247e+01,		2.553254977893143e+01,		2.563293411495206e+01,		2.573311105377185e+01,		2.583308127855642e+01,
		2.593284547006066e+01,		2.603240430663037e+01,		2.613175846420387e+01,		2.623090861631404e+01,		2.632985543409038e+01,
		2.642859958626146e+01,		2.652714173915743e+01,		2.662548255671268e+01,		2.672362270046895e+01,		2.682156282957825e+01,
		2.691930360080626e+01,		2.701684566853575e+01,		2.711418968477018e+01,		2.721133629913751e+01,		2.730828615889406e+01,
		2.740503990892870e+01,		2.750159819176699e+01,		2.759796164757559e+01,		2.769413091416669e+01,		2.779010662700275e+01,
		2.788588941920117e+01,		2.798147992153923e+01,		2.807687876245906e+01,		2.817208656807277e+01,		2.826710396216770e+01,
		2.836193156621168e+01,		2.845656999935857e+01,		2.855101987845372e+01,		2.864528181803966e+01,		2.873935643036178e+01,
		2.883324432537419e+01,		2.892694611074561e+01,		2.902046239186534e+01,		2.911379377184935e+01,		2.920694085154641e+01,
		2.929990422954430e+01,		2.939268450217614e+01,		2.948528226352671e+01,		2.957769810543885e+01,		2.966993261752000e+01,
		2.976198638714872e+01,		2.985385999948128e+01,		2.994555403745832e+01,		3.003706908181157e+01,		3.012840571107061e+01,
		3.021956450156966e+01,		3.031054602745444e+01,		3.040135086068908e+01,		3.049197957106302e+01,		3.058243272619804e+01,
		3.067271089155521e+01,		3.076281463044197e+01,		3.085274450401922e+01,		3.094250107130842e+01,		3.103208488919871e+01,
		3.112149651245412e+01,		3.121073649372073e+01,		3.129980538353388e+01,		3.138870373032547e+01,		3.147743208043115e+01,
		3.156599097809766e+01,		3.165438096549007e+01,		3.174260258269916e+01,		3.183065636774871e+01,		3.191854285660281e+01,
		3.200626258317334e+01,		3.209381607932718e+01,		3.218120387489373e+01,		3.226842649767217e+01,		3.235548447343893e+01,
		3.244237832595514e+01,		3.252910857697383e+01,		3.261567574624762e+01,		3.270208035153590e+01,		3.278832290861234e+01,
		3.287440393127230e+01,		3.296032393134028e+01,		3.304608341867720e+01,		3.313168290118799e+01,		3.321712288482887e+01,
		3.330240387361479e+01,		3.338752636962685e+01,		3.347249087301967e+01,		3.355729788202881e+01,		3.364194789297809e+01,
		3.372644140028704e+01,		3.381077889647822e+01,		3.389496087218460e+01,		3.397898781615687e+01,		3.406286021527082e+01,
		3.414657855453468e+01,		3.423014331709637e+01,		3.431355498425083e+01,		3.439681403544740e+01,		3.447992094829693e+01,
		3.456287619857918e+01,		3.464568026025004e+01,		3.472833360544869e+01,		3.481083670450499e+01,		3.489319002594645e+01,
		3.497539403650566e+01,		3.505744920112729e+01,		3.513935598297533e+01,		3.522111484344020e+01,		3.530272624214589e+01,
		3.538419063695706e+01,		3.546550848398613e+01,		3.554668023760029e+01,		3.562770635042867e+01,		3.570858727336925e+01,
		3.578932345559596e+01,		3.586991534456558e+01,		3.595036338602483e+01,		3.603066802401722e+01,		3.611082970089000e+01,
		3.619084885730112e+01,		3.627072593222607e+01,		3.635046136296480e+01,		3.643005558514843e+01,		3.650950903274631e+01,
		3.658882213807259e+01,		3.666799533179319e+01,		3.674702904293238e+01,		3.682592369887969e+01,		3.690467972539653e+01,
		3.698329754662286e+01,		3.706177758508398e+01,		3.714012026169703e+01,		3.721832599577772e+01,		3.729639520504691e+01,
		3.737432830563716e+01,		3.745212571209932e+01,		3.752978783740905e+01,		3.760731509297332e+01,		3.768470788863691e+01,
		3.776196663268892e+01,		3.783909173186905e+01,		3.791608359137426e+01,		3.799294261486491e+01,		3.806966920447131e+01,
		3.814626376080005e+01,		3.822272668294018e+01,		3.829905836846968e+01,		3.837525921346162e+01,		3.845132961249045e+01,
		3.852726995863824e+01,		3.860308064350088e+01,		3.867876205719425e+01,		3.875431458836030e+01,		3.882973862417336e+01,
		3.890503455034606e+01,		3.898020275113553e+01,		3.905524360934942e+01,		3.913015750635194e+01,		3.920494482206985e+01,
		3.927960593499848e+01,		3.935414122220772e+01,		3.942855105934783e+01,		3.950283582065555e+01,		3.957699587895981e+01,
		3.965103160568771e+01,		3.972494337087034e+01,		3.979873154314861e+01,		3.987239648977899e+01,		3.994593857663933e+01,
		4.001935816823465e+01,		4.009265562770278e+01,		4.016583131682012e+01,		4.023888559600731e+01,		4.031181882433487e+01,
		4.038463135952887e+01,		4.045732355797651e+01,		4.052989577473167e+01,		4.060234836352056e+01,		4.067468167674720e+01,
		4.074689606549893e+01,		4.081899187955200e+01,		4.089096946737687e+01,		4.096282917614380e+01,		4.103457135172825e+01,
		4.110619633871621e+01,		4.117770448040969e+01,		4.124909611883198e+01,		4.132037159473303e+01,		4.139153124759475e+01,
		4.146257541563632e+01,		4.153350443581942e+01,		4.160431864385350e+01,		4.167501837420104e+01,		4.174560396008263e+01,
		4.181607573348227e+01,		4.188643402515248e+01,		4.195667916461945e+01,		4.202681148018809e+01,		4.209683129894718e+01,
		4.216673894677448e+01,		4.223653474834165e+01,		4.230621902711938e+01,		4.237579210538236e+01,		4.244525430421428e+01,
		4.251460594351269e+01,		4.258384734199414e+01,		4.265297881719891e+01,		4.272200068549598e+01,		4.279091326208791e+01,
		4.285971686101569e+01,		4.292841179516358e+01,		4.299699837626388e+01,		4.306547691490182e+01,		4.313384772052018e+01,
		4.320211110142422e+01,		4.327026736478626e+01,		4.333831681665044e+01,		4.340625976193750e+01,		4.347409650444926e+01,
		4.354182734687343e+01,		4.360945259078822e+01,		4.367697253666686e+01,		4.374438748388224e+01,		4.381169773071154e+01,
		4.387890357434068e+01,		4.394600531086888e+01,		4.401300323531321e+01,		4.407989764161303e+01,		4.414668882263450e+01,
		4.421337707017501e+01,		4.427996267496756e+01,		4.434644592668533e+01,		4.441282711394589e+01,		4.447910652431568e+01,
		4.454528444431433e+01,		4.461136115941902e+01,		4.467733695406879e+01,		4.474321211166880e+01,		4.480898691459467e+01,
		4.487466164419672e+01,		4.494023658080416e+01,		4.500571200372942e+01,		4.507108819127225e+01,		4.513636542072396e+01,
		4.520154396837164e+01,		4.526662410950216e+01,		4.533160611840647e+01,		4.539649026838362e+01,		4.546127683174484e+01,
		4.552596607981773e+01,		4.559055828295020e+01,		4.565505371051454e+01,		4.571945263091158e+01,		4.578375531157444e+01,
		4.584796201897274e+01,		4.591207301861655e+01,		4.597608857506020e+01,		4.604000895190639e+01,		4.610383441181000e+01,
		4.616756521648205e+01,		4.623120162669355e+01,		4.629474390227944e+01,		4.635819230214231e+01,		4.642154708425640e+01,
		4.648480850567134e+01,		4.654797682251583e+01,		4.661105229000175e+01,		4.667403516242760e+01,		4.673692569318239e+01,
		4.679972413474943e+01,		4.686243073870995e+01,		4.692504575574687e+01,		4.698756943564844e+01,		4.705000202731196e+01,
		4.711234377874744e+01,		4.717459493708118e+01,		4.723675574855943e+01,		4.729882645855202e+01,		4.736080731155595e+01,
		4.742269855119889e+01,		4.748450042024288e+01,		4.754621316058774e+01,		4.760783701327468e+01,		4.766937221848978e+01,
		4.773081901556753e+01,		4.779217764299427e+01,		4.785344833841169e+01,		4.791463133862026e+01,		4.797572687958269e+01,
		4.803673519642738e+01,		4.809765652345169e+01,		4.815849109412554e+01,		4.821923914109466e+01,		4.827990089618398e+01,
		4.834047659040098e+01,		4.840096645393905e+01,		4.846137071618069e+01,		4.852168960570108e+01,		4.858192335027109e+01
	},
	{
		7.889501356792131e-02,		2.365702627932381e-01,		3.938822825064970e-01,		5.508319411143783e-01,		7.074200890895176e-01,
		8.636475602334459e-01,		1.019515172880177e+00,		1.175023731042774e+00,		1.330174025505117e+00,		1.484966834861044e+00,
		1.639402926502896e+00,		1.793483057561490e+00,		1.947207975799404e+00,		2.100578420459425e+00,		2.253595123069942e+00,
		2.406258808208956e+00,		2.558570194228392e+00,		2.710529993940271e+00,		2.862138915266261e+00,		3.013397661852098e+00,
		3.164306933648280e+00,		3.314867427458390e+00,		3.465079837456395e+00,		3.614944855674143e+00,		3.764463172460338e+00,
		3.913635476912114e+00,		4.062462457280394e+00,		4.210944801350101e+00,		4.359083196796290e+00,		4.506878331517227e+00,
		4.654330893945379e+00,		4.801441573337278e+00,		4.948211060043190e+00,		5.094640045757421e+00,		5.240729223750177e+00,
		5.386479289081723e+00,		5.531890938799705e+00,		5.676964872120353e+00,		5.821701790594289e+00,		5.966102398257690e+00,
		6.110167401769456e+00,		6.253897510535044e+00,		6.397293436817609e+00,		6.540355895837061e+00,		6.683085605857594e+00,
		6.825483288264319e+00,		6.967549667629473e+00,		7.109285471768746e+00,		7.250691431788288e+00,		7.391768282122786e+00,
		7.532516760565144e+00,		7.672937608288168e+00,		7.813031569858760e+00,		7.952799393244927e+00,		8.092241829816109e+00,
		8.231359634337105e+00,		8.370153564956086e+00,		8.508624383186902e+00,		8.646772853886155e+00,		8.784599745225270e+00,
		8.922105828657905e+00,		9.059291878883032e+00,		9.196158673803897e+00,		9.332706994483202e+00,		9.468937625094739e+00,
		9.604851352871741e+00,		9.740448968052158e+00,		9.875731263821125e+00,		1.001069903625083e+01,		1.014535308423798e+01,
		1.027969420943906e+01,		1.041372321620362e+01,		1.054744091150568e+01,		1.068084810487360e+01,		1.081394560831830e+01,
		1.094673423626033e+01,		1.107921480545563e+01,		1.121138813492034e+01,		1.134325504585468e+01,		1.147481636156607e+01,
		1.160607290739159e+01,		1.173702551061997e+01,		1.186767500041309e+01,		1.199802220772720e+01,		1.212806796523396e+01,
		1.225781310724130e+01,		1.238725846961430e+01,		1.251640488969610e+01,		1.264525320622895e+01,		1.277380425927547e+01,
		1.290205889014018e+01,		1.303001794129136e+01,		1.315768225628341e+01,		1.328505267967949e+01,		1.341213005697488e+01,
		1.353891523452079e+01,		1.366540905944878e+01,		1.379161237959592e+01,		1.391752604343063e+01,		1.404315089997916e+01,
		1.416848779875301e+01,		1.429353758967703e+01,		1.441830112301844e+01,		1.454277924931665e+01,		1.466697281931402e+01,
		1.479088268388753e+01,		1.491450969398137e+01,		1.503785470054049e+01,		1.516091855444514e+01,		1.528370210644634e+01,
		1.540620620710244e+01,		1.552843170671663e+01,		1.565037945527546e+01,		1.577205030238847e+01,		1.589344509722871e+01,
		1.601456468847452e+01,		1.613540992425212e+01,		1.625598165207944e+01,		1.637628071881086e+01,		1.649630797058316e+01,
		1.661606425276234e+01,		1.673555040989165e+01,		1.685476728564058e+01,		1.697371572275490e+01,		1.709239656300784e+01,
		1.721081064715215e+01,		1.732895881487333e+01,		1.744684190474383e+01,		1.756446075417827e+01,		1.768181619938968e+01,
		1.779890907534678e+01,		1.791574021573219e+01,		1.803231045290171e+01,		1.814862061784449e+01,		1.826467154014428e+01,
		1.838046404794155e+01,		1.849599896789657e+01,		1.861127712515352e+01,		1.872629934330543e+01,		1.884106644436008e+01,
		1.895557924870678e+01,		1.906983857508412e+01,		1.918384524054851e+01,		1.929760006044370e+01,		1.941110384837099e+01,
		1.952435741616052e+01,		1.963736157384318e+01,		1.975011712962349e+01,		1.986262488985325e+01,		1.997488565900591e+01,
		2.008690023965186e+01,		2.019866943243444e+01,		2.031019403604661e+01,		2.042147484720858e+01,		2.053251266064596e+01,
		2.064330826906879e+01,		2.075386246315119e+01,		2.086417603151178e+01,		2.097424976069466e+01,		2.108408443515128e+01,
		2.119368083722269e+01,		2.130303974712276e+01,		2.141216194292171e+01,		2.152104820053052e+01,		2.162969929368584e+01,
		2.173811599393548e+01,		2.184629907062458e+01,		2.195424929088226e+01,		2.206196741960889e+01,		2.216945421946394e+01,
		2.227671045085428e+01,		2.238373687192307e+01,		2.249053423853926e+01,		2.259710330428739e+01,		2.270344482045807e+01,
		2.280955953603889e+01,		2.291544819770575e+01,		2.302111154981479e+01,		2.312655033439463e+01,		2.323176529113913e+01,
		2.333675715740063e+01,		2.344152666818349e+01,		2.354607455613818e+01,		2.365040155155570e+01,		2.375450838236241e+01,
		2.385839577411525e+01,		2.396206444999738e+01,		2.406551513081411e+01,		2.416874853498926e+01,		2.427176537856185e+01,
		2.437456637518312e+01,		2.447715223611388e+01,		2.457952367022229e+01,		2.468168138398174e+01,		2.478362608146929e+01,
		2.488535846436424e+01,		2.498687923194708e+01,		2.508818908109868e+01,		2.518928870629979e+01,		2.529017879963082e+01,
		2.539086005077183e+01,		2.549133314700290e+01,		2.559159877320457e+01,		2.569165761185867e+01,		2.579151034304941e+01,
		2.589115764446452e+01,		2.599060019139682e+01,		2.608983865674588e+01,		2.618887371101999e+01,		2.628770602233819e+01,
		2.638633625643268e+01,		2.648476507665130e+01,		2.658299314396022e+01,		2.668102111694693e+01,		2.677884965182318e+01,
		2.687647940242831e+01,		2.697391102023266e+01,		2.707114515434115e+01,		2.716818245149695e+01,		2.726502355608546e+01,
		2.736166911013834e+01,		2.745811975333761e+01,		2.755437612302009e+01,		2.765043885418176e+01,		2.774630857948241e+01,
		2.784198592925034e+01,		2.793747153148717e+01,		2.803276601187286e+01,		2.812786999377072e+01,		2.822278409823263e+01,
		2.831750894400432e+01,		2.841204514753075e+01,		2.850639332296160e+01,		2.860055408215691e+01,		2.869452803469266e+01,
		2.878831578786666e+01,		2.888191794670428e+01,		2.897533511396451e+01,		2.906856789014588e+01,		2.916161687349263e+01,
		2.925448266000079e+01,		2.934716584342448e+01,		2.943966701528226e+01,		2.953198676486339e+01,		2.962412567923433e+01,
		2.971608434324524e+01,		2.980786333953647e+01,		2.989946324854528e+01,		2.999088464851237e+01,		3.008212811548865e+01,
		3.017319422334200e+01,		3.026408354376405e+01,		3.035479664627705e+01,		3.044533409824069e+01,		3.053569646485912e+01,
		3.062588430918784e+01,		3.071589819214071e+01,		3.080573867249698e+01,		3.089540630690837e+01,		3.098490164990612e+01,
		3.107422525390814e+01,		3.116337766922616e+01,		3.125235944407283e+01,		3.134117112456901e+01,		3.142981325475087e+01,
		3.151828637657723e+01,		3.160659102993672e+01,		3.169472775265509e+01,		3.178269708050248e+01,		3.187049954720070e+01,
		3.195813568443057e+01,		3.204560602183917e+01,		3.213291108704726e+01,		3.222005140565653e+01,		3.230702750125698e+01,
		3.239383989543428e+01,		3.248048910777711e+01,		3.256697565588451e+01,		3.265330005537325e+01,		3.273946281988520e+01,
		3.282546446109465e+01,		3.291130548871578e+01,		3.299698641050990e+01,		3.308250773229289e+01,		3.316786995794254e+01,
		3.325307358940585e+01,		3.333811912670654e+01,		3.342300706795217e+01,		3.350773790934167e+01,		3.359231214517259e+01,
		3.367673026784843e+01,		3.376099276788597e+01,		3.384510013392257e+01,		3.392905285272353e+01,		3.401285140918924e+01,
		3.409649628636264e+01,		3.417998796543628e+01,		3.426332692575985e+01,		3.434651364484712e+01,		3.442954859838342e+01,
		3.451243226023269e+01,		3.459516510244479e+01,		3.467774759526262e+01,		3.476018020712939e+01,		3.484246340469565e+01,
		3.492459765282653e+01,		3.500658341460882e+01,		3.508842115135814e+01,		3.517011132262594e+01,		3.525165438620670e+01,
		3.533305079814486e+01,		3.541430101274197e+01,		3.549540548256360e+01,		3.557636465844654e+01,		3.565717898950555e+01,
		3.573784892314048e+01,		3.581837490504316e+01,		3.589875737920434e+01,		3.597899678792066e+01,		3.605909357180140e+01,
		3.613904816977546e+01,		3.621886101909817e+01,		3.629853255535816e+01,		3.637806321248405e+01,		3.645745342275136e+01,
		3.653670361678922e+01,		3.661581422358708e+01,		3.669478567050151e+01,		3.677361838326278e+01,		3.685231278598166e+01,
		3.693086930115598e+01,		3.700928834967729e+01,		3.708757035083755e+01,		3.716571572233549e+01,		3.724372488028347e+01,
		3.732159823921375e+01,		3.739933621208520e+01,		3.747693921028971e+01,		3.755440764365864e+01,		3.763174192046932e+01,
		3.770894244745144e+01,		3.778600962979344e+01,		3.786294387114897e+01,		3.793974557364314e+01,		3.801641513787888e+01,
		3.809295296294329e+01,		3.816935944641390e+01,		3.824563498436489e+01,		3.832177997137336e+01,		3.839779480052560e+01,
		3.847367986342314e+01,		3.854943555018909e+01,		3.862506224947407e+01,		3.870056034846256e+01,		3.877593023287881e+01,
		3.885117228699299e+01,		3.892628689362721e+01,		3.900127443416162e+01,		3.907613528854030e+01,		3.915086983527727e+01,
		3.922547845146248e+01,		3.929996151276772e+01,		3.937431939345246e+01,		3.944855246636987e+01,		3.952266110297252e+01,
		3.959664567331833e+01,		3.967050654607629e+01,		3.974424408853235e+01,		3.981785866659509e+01,		3.989135064480148e+01,
		3.996472038632263e+01,		4.003796825296946e+01,		4.011109460519840e+01,		4.018409980211691e+01,		4.025698420148930e+01,
		4.032974815974219e+01,		4.040239203197009e+01,		4.047491617194105e+01,		4.054732093210205e+01,		4.061960666358466e+01,
		4.069177371621038e+01,		4.076382243849621e+01,		4.083575317766000e+01,		4.090756627962595e+01,		4.097926208902998e+01,
		4.105084094922501e+01,		4.112230320228645e+01,		4.119364918901738e+01,		4.126487924895400e+01,		4.133599372037081e+01,
		4.140699294028586e+01,		4.147787724446606e+01,		4.154864696743233e+01,		4.161930244246483e+01,		4.168984400160807e+01,
		4.176027197567614e+01,		4.183058669425780e+01,		4.190078848572152e+01,		4.197087767722065e+01,		4.204085459469845e+01,
		4.211071956289309e+01,		4.218047290534277e+01,		4.225011494439057e+01,		4.231964600118954e+01,		4.238906639570759e+01,
		4.245837644673244e+01,		4.252757647187657e+01,		4.259666678758197e+01,		4.266564770912522e+01,		4.273451955062218e+01,
		4.280328262503282e+01,		4.287193724416611e+01,		4.294048371868474e+01,		4.300892235810990e+01,		4.307725347082602e+01,
		4.314547736408548e+01,		4.321359434401337e+01,		4.328160471561208e+01,		4.334950878276608e+01,		4.341730684824640e+01,
		4.348499921371540e+01,		4.355258617973131e+01,		4.362006804575280e+01,		4.368744511014354e+01,		4.375471767017680e+01,
		4.382188602203991e+01,		4.388895046083876e+01,		4.395591128060234e+01,		4.402276877428714e+01,		4.408952323378165e+01,
		4.415617494991069e+01,		4.422272421243995e+01,		4.428917131008031e+01,		4.435551653049212e+01,		4.442176016028973e+01,
		4.448790248504564e+01,		4.455394378929498e+01,		4.461988435653961e+01,		4.468572446925257e+01,		4.475146440888223e+01,
		4.481710445585655e+01,		4.488264488958735e+01,		4.494808598847438e+01,		4.501342802990963e+01,		4.507867129028146e+01,
		4.514381604497872e+01,		4.520886256839484e+01,		4.527381113393201e+01,		4.533866201400531e+01,		4.540341548004657e+01,
		4.546807180250872e+01,		4.553263125086961e+01,		4.559709409363605e+01,		4.566146059834796e+01,		4.572573103158216e+01,
		4.578990565895651e+01,		4.585398474513371e+01,		4.591796855382535e+01,		4.598185734779575e+01,		4.604565138886591e+01,
		4.610935093791734e+01,		4.617295625489596e+01,		4.623646759881598e+01,		4.629988522776365e+01,		4.636320939890109e+01,
		4.642644036847015e+01,		4.648957839179613e+01,		4.655262372329160e+01,		4.661557661646010e+01,		4.667843732389984e+01,
		4.674120609730751e+01,		4.680388318748194e+01,		4.686646884432771e+01,		4.692896331685893e+01,		4.699136685320286e+01,
		4.705367970060345e+01,		4.711590210542509e+01,		4.717803431315611e+01,		4.724007656841247e+01,		4.730202911494128e+01,
		4.736389219562430e+01,		4.742566605248150e+01,		4.748735092667474e+01,		4.754894705851105e+01,		4.761045468744627e+01,
		4.767187405208851e+01,		4.773320539020157e+01,		4.779444893870839e+01,		4.785560493369456e+01,		4.791667361041166e+01,
		4.797765520328068e+01,		4.803854994589546e+01,		4.809935807102596e+01,		4.816007981062171e+01,		4.822071539581517e+01,
		4.828126505692496e+01,		4.834172902345925e+01,		4.840210752411907e+01,		4.846240078680157e+01,		4.852260903860324e+01
	},
	{
		7.874047369048702e-02,		2.361072001468805e-01,		3.931118523530643e-01,		5.497552980050251e-01,		7.060383870043849e-01,
		8.619619527067612e-01,		1.017526813111551e+00,		1.172733771995437e+00,		1.327583619991808e+00,		1.482077135618225e+00,
		1.636215086253961e+00,		1.789998229069571e+00,		1.943427311910388e+00,		2.096503074135743e+00,		2.249226247415680e+00,
		2.401597556486811e+00,		2.553617719868980e+00,		2.705287450544239e+00,		2.856607456599702e+00,		3.007578441835669e+00,
		3.158201106340454e+00,		3.308476147033249e+00,		3.458404258176330e+00,		3.607986131857836e+00,		3.757222458446362e+00,
		3.906113927018501e+00,		4.054661225760460e+00,		4.202865042344849e+00,		4.350726064283680e+00,		4.498244979258556e+00,
		4.645422475429074e+00,		4.792259241720323e+00,		4.938755968090409e+00,		5.084913345778881e+00,		5.230732067536880e+00,
		5.376212827839824e+00,		5.521356323083416e+00,		5.666163251763737e+00,		5.810634314642098e+00,		5.954770214895429e+00,
		6.098571658252802e+00,		6.242039353118782e+00,		6.385174010684219e+00,		6.527976345025063e+00,		6.670447073189828e+00,
		6.812586915276191e+00,		6.954396594497353e+00,		7.095876837238574e+00,		7.237028373104489e+00,		7.377851934957580e+00,
		7.518348258948353e+00,		7.658518084537580e+00,		7.798362154511107e+00,		7.937881214987576e+00,		8.077076015419507e+00,
		8.215947308588039e+00,		8.354495850591787e+00,		8.492722400830104e+00,		8.630627721981083e+00,		8.768212579974634e+00,
		8.905477743960938e+00,		9.042423986274567e+00,		9.179052082394588e+00,		9.315362810900815e+00,		9.451356953426648e+00,
		9.587035294608548e+00,		9.722398622032502e+00,		9.857447726177730e+00,		9.992183400357728e+00,		1.012660644065898e+01,
		1.026071764587744e+01,		1.039451781745307e+01,		1.052800775940250e+01,		1.066118827825011e+01,		1.079406018295755e+01,
		1.092662428485200e+01,		1.105888139755323e+01,		1.119083233689964e+01,		1.132247792087334e+01,		1.145381896952456e+01,
		1.158485630489531e+01,		1.171559075094259e+01,		1.184602313346107e+01,		1.197615428000558e+01,		1.210598501981325e+01,
		1.223551618372563e+01,		1.236474860411065e+01,		1.249368311478474e+01,		1.262232055093501e+01,		1.275066174904159e+01,
		1.287870754680033e+01,		1.300645878304571e+01,		1.313391629767424e+01,		1.326108093156828e+01,		1.338795352652030e+01,
		1.351453492515780e+01,		1.364082597086875e+01,		1.376682750772768e+01,		1.389254038042254e+01,		1.401796543418212e+01,
		1.414310351470444e+01,		1.426795546808572e+01,		1.439252214075033e+01,		1.451680437938150e+01,		1.464080303085296e+01,
		1.476451894216143e+01,		1.488795296036004e+01,		1.501110593249273e+01,		1.513397870552958e+01,		1.525657212630301e+01,
		1.537888704144516e+01,		1.550092429732612e+01,		1.562268473999317e+01,		1.574416921511109e+01,		1.586537856790350e+01,
		1.598631364309512e+01,		1.610697528485517e+01,		1.622736433674180e+01,		1.634748164164743e+01,		1.646732804174532e+01,
		1.658690437843701e+01,		1.670621149230090e+01,		1.682525022304179e+01,		1.694402140944152e+01,		1.706252588931062e+01,
		1.718076449944092e+01,		1.729873807555929e+01,		1.741644745228226e+01,		1.753389346307185e+01,		1.765107694019214e+01,
		1.776799871466703e+01,		1.788465961623891e+01,		1.800106047332834e+01,		1.811720211299465e+01,		1.823308536089750e+01,
		1.834871104125951e+01,		1.846407997682964e+01,		1.857919298884762e+01,		1.869405089700929e+01,		1.880865451943280e+01,
		1.892300467262580e+01,		1.903710217145334e+01,		1.915094782910689e+01,		1.926454245707396e+01,		1.937788686510880e+01,
		1.949098186120378e+01,		1.960382825156167e+01,		1.971642684056871e+01,		1.982877843076852e+01,		1.994088382283674e+01,
		2.005274381555648e+01,		2.016435920579456e+01,		2.027573078847844e+01,		2.038685935657396e+01,		2.049774570106376e+01,
		2.060839061092645e+01,		2.071879487311642e+01,		2.082895927254445e+01,		2.093888459205887e+01,		2.104857161242751e+01,
		2.115802111232022e+01,		2.126723386829206e+01,		2.137621065476710e+01,		2.148495224402291e+01,		2.159345940617556e+01,
		2.170173290916528e+01,		2.180977351874267e+01,		2.191758199845551e+01,		2.202515910963611e+01,		2.213250561138922e+01,
		2.223962226058043e+01,		2.234650981182525e+01,		2.245316901747841e+01,		2.255960062762405e+01,		2.266580539006607e+01,
		2.277178405031913e+01,		2.287753735160013e+01,		2.298306603482004e+01,		2.308837083857632e+01,		2.319345249914568e+01,
		2.329831175047732e+01,		2.340294932418657e+01,		2.350736594954900e+01,		2.361156235349485e+01,		2.371553926060387e+01,
		2.381929739310062e+01,		2.392283747085008e+01,		2.402616021135364e+01,		2.412926632974543e+01,		2.423215653878905e+01,
		2.433483154887456e+01,		2.443729206801597e+01,		2.453953880184877e+01,		2.464157245362809e+01,		2.474339372422694e+01,
		2.484500331213490e+01,		2.494640191345693e+01,		2.504759022191272e+01,		2.514856892883605e+01,		2.524933872317459e+01,
		2.534990029148993e+01,		2.545025431795785e+01,		2.555040148436879e+01,		2.565034247012870e+01,		2.575007795225999e+01,
		2.584960860540277e+01,		2.594893510181633e+01,		2.604805811138083e+01,		2.614697830159911e+01,		2.624569633759887e+01,
		2.634421288213494e+01,		2.644252859559176e+01,		2.654064413598606e+01,		2.663856015896970e+01,		2.673627731783274e+01,
		2.683379626350669e+01,		2.693111764456777e+01,		2.702824210724057e+01,		2.712517029540168e+01,		2.722190285058358e+01,
		2.731844041197863e+01,		2.741478361644318e+01,		2.751093309850190e+01,		2.760688949035218e+01,		2.770265342186867e+01,
		2.779822552060795e+01,		2.789360641181335e+01,		2.798879671841983e+01,		2.808379706105902e+01,		2.817860805806438e+01,
		2.827323032547639e+01,		2.836766447704795e+01,		2.846191112424980e+01,		2.855597087627605e+01,		2.864984434004985e+01,
		2.874353212022905e+01,		2.883703481921208e+01,		2.893035303714375e+01,		2.902348737192134e+01,		2.911643841920051e+01,
		2.920920677240155e+01,		2.930179302271541e+01,		2.939419775911012e+01,		2.948642156833704e+01,		2.957846503493719e+01,
		2.967032874124778e+01,		2.976201326740867e+01,		2.985351919136893e+01,		2.994484708889343e+01,		3.003599753356950e+01,
		3.012697109681370e+01,		3.021776834787845e+01,		3.030838985385893e+01,		3.039883617969983e+01,		3.048910788820230e+01,
		3.057920554003078e+01,		3.066912969372002e+01,		3.075888090568199e+01,		3.084845973021293e+01,		3.093786671950043e+01,
		3.102710242363030e+01,		3.111616739059397e+01,		3.120506216629532e+01,		3.129378729455800e+01,		3.138234331713249e+01,
		3.147073077370333e+01,		3.155895020189630e+01,		3.164700213728561e+01,		3.173488711340120e+01,		3.182260566173589e+01,
		3.191015831175268e+01,		3.199754559089208e+01,		3.208476802457922e+01,		3.217182613623134e+01,		3.225872044726488e+01,
		3.234545147710298e+01,		3.243201974318259e+01,		3.251842576096191e+01,		3.260467004392768e+01,		3.269075310360245e+01,
		3.277667544955191e+01,		3.286243758939226e+01,		3.294804002879745e+01,		3.303348327150650e+01,		3.311876781933088e+01,
		3.320389417216173e+01,		3.328886282797725e+01,		3.337367428284990e+01,		3.345832903095378e+01,		3.354282756457183e+01,
		3.362717037410324e+01,		3.371135794807056e+01,		3.379539077312707e+01,		3.387926933406399e+01,		3.396299411381779e+01,
		3.404656559347730e+01,		3.412998425229101e+01,		3.421325056767432e+01,		3.429636501521667e+01,		3.437932806868869e+01,
		3.446214020004950e+01,		3.454480187945374e+01,		3.462731357525880e+01,		3.470967575403191e+01,		3.479188888055727e+01,
		3.487395341784313e+01,		3.495586982712889e+01,		3.503763856789215e+01,		3.511926009785581e+01,		3.520073487299499e+01,
		3.528206334754422e+01,		3.536324597400426e+01,		3.544428320314919e+01,		3.552517548403334e+01,		3.560592326399823e+01,
		3.568652698867949e+01,		3.576698710201377e+01,		3.584730404624564e+01,		3.592747826193443e+01,		3.600751018796110e+01,
		3.608740026153502e+01,		3.616714891820085e+01,		3.624675659184524e+01,		3.632622371470364e+01,		3.640555071736708e+01,
		3.648473802878876e+01,		3.656378607629092e+01,		3.664269528557137e+01,		3.672146608071024e+01,		3.680009888417658e+01,
		3.687859411683494e+01,		3.695695219795203e+01,		3.703517354520324e+01,		3.711325857467919e+01,		3.719120770089225e+01,
		3.726902133678306e+01,		3.734669989372698e+01,		3.742424378154055e+01,		3.750165340848796e+01,		3.757892918128742e+01,
		3.765607150511751e+01,		3.773308078362361e+01,		3.780995741892425e+01,		3.788670181161731e+01,		3.796331436078647e+01,
		3.803979546400733e+01,		3.811614551735375e+01,		3.819236491540406e+01,		3.826845405124723e+01,		3.834441331648905e+01,
		3.842024310125831e+01,		3.849594379421288e+01,		3.857151578254587e+01,		3.864695945199167e+01,		3.872227518683204e+01,
		3.879746336990206e+01,		3.887252438259626e+01,		3.894745860487455e+01,		3.902226641526816e+01,		3.909694819088561e+01,
		3.917150430741859e+01,		3.924593513914795e+01,		3.932024105894940e+01,		3.939442243829955e+01,		3.946847964728154e+01,
		3.954241305459101e+01,		3.961622302754176e+01,		3.968990993207152e+01,		3.976347413274777e+01,		3.983691599277324e+01,
		3.991023587399189e+01,		3.998343413689424e+01,		4.005651114062324e+01,		4.012946724297984e+01,		4.020230280042846e+01,
		4.027501816810269e+01,		4.034761369981081e+01,		4.042008974804121e+01,		4.049244666396800e+01,		4.056468479745644e+01,
		4.063680449706841e+01,		4.070880611006775e+01,		4.078068998242581e+01,		4.085245645882677e+01,		4.092410588267288e+01,
		4.099563859609003e+01,		4.106705493993287e+01,		4.113835525379019e+01,		4.120953987599017e+01,		4.128060914360564e+01,
		4.135156339245929e+01,		4.142240295712892e+01,		4.149312817095251e+01,		4.156373936603352e+01,		4.163423687324591e+01,
		4.170462102223936e+01,		4.177489214144425e+01,		4.184505055807684e+01,		4.191509659814425e+01,		4.198503058644954e+01,
		4.205485284659664e+01,		4.212456370099545e+01,		4.219416347086666e+01,		4.226365247624686e+01,		4.233303103599332e+01,
		4.240229946778899e+01,		4.247145808814729e+01,		4.254050721241706e+01,		4.260944715478731e+01,		4.267827822829214e+01,
		4.274700074481544e+01,		4.281561501509571e+01,		4.288412134873082e+01,		4.295252005418273e+01,		4.302081143878221e+01,
		4.308899580873355e+01,		4.315707346911918e+01,		4.322504472390439e+01,		4.329290987594196e+01,		4.336066922697669e+01,
		4.342832307765006e+01,		4.349587172750484e+01,		4.356331547498959e+01,		4.363065461746316e+01,		4.369788945119928e+01,
		4.376502027139100e+01,		4.383204737215520e+01,		4.389897104653706e+01,		4.396579158651443e+01,		4.403250928300228e+01,
		4.409912442585715e+01,		4.416563730388143e+01,		4.423204820482778e+01,		4.429835741540352e+01,		4.436456522127484e+01,
		4.443067190707120e+01,		4.449667775638950e+01,		4.456258305179849e+01,		4.462838807484292e+01,		4.469409310604781e+01,
		4.475969842492263e+01,		4.482520430996546e+01,		4.489061103866733e+01,		4.495591888751617e+01,		4.502112813200105e+01,
		4.508623904661628e+01,		4.515125190486550e+01,		4.521616697926586e+01,		4.528098454135191e+01,		4.534570486167976e+01,
		4.541032820983114e+01,		4.547485485441735e+01,		4.553928506308321e+01,		4.560361910251119e+01,		4.566785723842527e+01,
		4.573199973559480e+01,		4.579604685783862e+01,		4.585999886802883e+01,		4.592385602809474e+01,		4.598761859902669e+01,
		4.605128684087998e+01,		4.611486101277865e+01,		4.617834137291936e+01,		4.624172817857512e+01,		4.630502168609922e+01,
		4.636822215092882e+01,		4.643132982758880e+01,		4.649434496969561e+01,		4.655726782996076e+01,		4.662009866019478e+01,
		4.668283771131070e+01,		4.674548523332783e+01,		4.680804147537548e+01,		4.687050668569650e+01,		4.693288111165086e+01,
		4.699516499971951e+01,		4.705735859550765e+01,		4.711946214374859e+01,		4.718147588830715e+01,		4.724340007218333e+01,
		4.730523493751567e+01,		4.736698072558493e+01,		4.742863767681761e+01,		4.749020603078927e+01,		4.755168602622813e+01,
		4.761307790101857e+01,		4.767438189220446e+01,		4.773559823599257e+01,		4.779672716775617e+01,		4.785776892203827e+01,
		4.791872373255501e+01,		4.797959183219905e+01,		4.804037345304299e+01,		4.810106882634263e+01,		4.816167818254034e+01,
		4.822220175126833e+01,		4.828263976135194e+01,		4.834299244081305e+01,		4.840326001687311e+01,		4.846344271595667e+01
	},
	{
		7.858653824549861e-02,		2.356459484514050e-01,		3.923444349001975e-01,		5.486828645475167e-01,		7.046620866928685e-01,
		8.602829342135997e-01,		1.015546224741066e+00,		1.170452761781248e+00,		1.325003335781994e+00,		1.479198725148966e+00,
		1.633039697212306e+00,		1.786527009145957e+00,		1.939661408841480e+00,		2.092443635738179e+00,		2.244874421611234e+00,
		2.396954491319523e+00,		2.548684563514707e+00,		2.700065351313133e+00,		2.851097562932043e+00,		3.001781902291490e+00,
		3.152119069583379e+00,		3.302109761808922e+00,		3.451754673285820e+00,		3.601054496126374e+00,		3.750009920687754e+00,
		3.898621635995537e+00,		4.046890330141639e+00,		4.194816690657717e+00,		4.342401404865039e+00,		4.489645160201867e+00,
		4.636548644529245e+00,		4.783112546416172e+00,		4.929337555405023e+00,		5.075224362258079e+00,		5.220773659185998e+00,
		5.365986140059029e+00,		5.510862500601720e+00,		5.655403438571892e+00,		5.799609653924569e+00,		5.943481848961560e+00,
		6.087020728467350e+00,		6.230226999831982e+00,		6.373101373161468e+00,		6.515644561376392e+00,		6.657857280299248e+00,
		6.799740248731064e+00,		6.941294188517853e+00,		7.082519824607362e+00,		7.223417885096692e+00,		7.363989101271157e+00,
		7.504234207634924e+00,		7.644153941933804e+00,		7.783749045170677e+00,		7.923020261613897e+00,		8.061968338799096e+00,
		8.200594027524746e+00,		8.338898081841858e+00,		8.476881259038139e+00,		8.614544319616922e+00,		8.751888027271242e+00,
		8.888913148853293e+00,		9.025620454339615e+00,		9.162010716792247e+00,		9.298084712316108e+00,		9.433843220012957e+00,
		9.569287021932004e+00,		9.704416903017570e+00,		9.839233651053956e+00,		9.973738056607678e+00,		1.010793091296739e+01,
		1.024181301608161e+01,		1.037538516449440e+01,		1.050864815927938e+01,		1.064160280397188e+01,		1.077424990449984e+01,
		1.090659026911320e+01,		1.103862470831225e+01,		1.117035403477484e+01,		1.130177906328274e+01,		1.143290061064721e+01,
		1.156371949563392e+01,		1.169423653888729e+01,		1.182445256285447e+01,		1.195436839170887e+01,		1.208398485127362e+01,
		1.221330276894472e+01,		1.234232297361425e+01,		1.247104629559356e+01,		1.259947356653656e+01,		1.272760561936326e+01,
		1.285544328818343e+01,		1.298298740822070e+01,		1.311023881573697e+01,		1.323719834795726e+01,		1.336386684299505e+01,
		1.349024513977816e+01,		1.361633407797523e+01,		1.374213449792278e+01,		1.386764724055298e+01,		1.399287314732211e+01,
		1.411781306013979e+01,		1.424246782129891e+01,		1.436683827340647e+01,		1.449092525931512e+01,		1.461472962205574e+01,
		1.473825220477066e+01,		1.486149385064805e+01,		1.498445540285695e+01,		1.510713770448351e+01,		1.522954159846794e+01,
		1.535166792754261e+01,		1.547351753417102e+01,		1.559509126048781e+01,		1.571638994823970e+01,		1.583741443872754e+01,
		1.595816557274926e+01,		1.607864419054390e+01,		1.619885113173669e+01,		1.631878723528498e+01,		1.643845333942544e+01,
		1.655785028162206e+01,		1.667697889851532e+01,		1.679584002587231e+01,		1.691443449853788e+01,		1.703276315038680e+01,
		1.715082681427690e+01,		1.726862632200332e+01,		1.738616250425364e+01,		1.750343619056406e+01,		1.762044820927655e+01,
		1.773719938749702e+01,		1.785369055105440e+01,		1.796992252446070e+01,		1.808589613087208e+01,		1.820161219205080e+01,
		1.831707152832816e+01,		1.843227495856826e+01,		1.854722330013288e+01,		1.866191736884705e+01,		1.877635797896563e+01,
		1.889054594314078e+01,		1.900448207239025e+01,		1.911816717606659e+01,		1.923160206182718e+01,		1.934478753560506e+01,
		1.945772440158076e+01,		1.957041346215465e+01,		1.968285551792041e+01,		1.979505136763905e+01,		1.990700180821391e+01,
		2.001870763466621e+01,		2.013016964011158e+01,		2.024138861573719e+01,		2.035236535077967e+01,		2.046310063250368e+01,
		2.057359524618131e+01,		2.068384997507207e+01,		2.079386560040362e+01,		2.090364290135312e+01,		2.101318265502934e+01,
		2.112248563645524e+01,		2.123155261855145e+01,		2.134038437212008e+01,		2.144898166582935e+01,		2.155734526619874e+01,
		2.166547593758474e+01,		2.177337444216722e+01,		2.188104153993622e+01,		2.198847798867955e+01,		2.209568454397065e+01,
		2.220266195915719e+01,		2.230941098535010e+01,		2.241593237141315e+01,		2.252222686395295e+01,		2.262829520730956e+01,
		2.273413814354751e+01,		2.283975641244725e+01,		2.294515075149716e+01,		2.305032189588594e+01,		2.315527057849541e+01,
		2.325999752989384e+01,		2.336450347832962e+01,		2.346878914972532e+01,		2.357285526767225e+01,		2.367670255342532e+01,
		2.378033172589829e+01,		2.388374350165948e+01,		2.398693859492769e+01,		2.408991771756867e+01,		2.419268157909173e+01,
		2.429523088664686e+01,		2.439756634502206e+01,		2.449968865664109e+01,		2.460159852156146e+01,		2.470329663747275e+01,
		2.480478369969524e+01,		2.490606040117881e+01,		2.500712743250215e+01,		2.510798548187224e+01,		2.520863523512407e+01,
		2.530907737572063e+01,		2.540931258475323e+01,		2.550934154094194e+01,		2.560916492063635e+01,		2.570878339781661e+01,
		2.580819764409456e+01,		2.590740832871524e+01,		2.600641611855847e+01,		2.610522167814080e+01,		2.620382566961750e+01,
		2.630222875278483e+01,		2.640043158508255e+01,		2.649843482159656e+01,		2.659623911506164e+01,		2.669384511586456e+01,
		2.679125347204725e+01,		2.688846482931006e+01,		2.698547983101533e+01,		2.708229911819104e+01,		2.717892332953463e+01,
		2.727535310141694e+01,		2.737158906788630e+01,		2.746763186067288e+01,		2.756348210919290e+01,		2.765914044055323e+01,
		2.775460747955604e+01,		2.784988384870349e+01,		2.794497016820263e+01,		2.803986705597037e+01,		2.813457512763862e+01,
		2.822909499655939e+01,		2.832342727381018e+01,		2.841757256819935e+01,		2.851153148627158e+01,		2.860530463231353e+01,
		2.869889260835941e+01,		2.879229601419683e+01,		2.888551544737258e+01,		2.897855150319863e+01,		2.907140477475800e+01,
		2.916407585291096e+01,		2.925656532630107e+01,		2.934887378136144e+01,		2.944100180232099e+01,		2.953294997121079e+01,
		2.962471886787039e+01,		2.971630906995440e+01,		2.980772115293885e+01,		2.989895569012786e+01,		2.999001325266015e+01,
		3.008089440951577e+01,		3.017159972752277e+01,		3.026212977136393e+01,		3.035248510358353e+01,		3.044266628459426e+01,
		3.053267387268392e+01,		3.062250842402249e+01,		3.071217049266891e+01,		3.080166063057812e+01,		3.089097938760802e+01,
		3.098012731152648e+01,		3.106910494801843e+01,		3.115791284069281e+01,		3.124655153108980e+01,		3.133502155868780e+01,
		3.142332346091066e+01,		3.151145777313479e+01,		3.159942502869624e+01,		3.168722575889806e+01,		3.177486049301729e+01,
		3.186232975831233e+01,		3.194963408003002e+01,		3.203677398141300e+01,		3.212374998370683e+01,		3.221056260616730e+01,
		3.229721236606766e+01,		3.238369977870585e+01,		3.247002535741181e+01,		3.255618961355470e+01,		3.264219305655017e+01,
		3.272803619386766e+01,		3.281371953103762e+01,		3.289924357165881e+01,		3.298460881740552e+01,		3.306981576803492e+01,
		3.315486492139421e+01,		3.323975677342794e+01,		3.332449181818526e+01,		3.340907054782714e+01,		3.349349345263362e+01,
		3.357776102101102e+01,		3.366187373949921e+01,		3.374583209277880e+01,		3.382963656367835e+01,		3.391328763318150e+01,
		3.399678578043428e+01,		3.408013148275220e+01,		3.416332521562745e+01,		3.424636745273602e+01,		3.432925866594486e+01,
		3.441199932531899e+01,		3.449458989912865e+01,		3.457703085385636e+01,		3.465932265420404e+01,		3.474146576310003e+01,
		3.482346064170618e+01,		3.490530774942490e+01,		3.498700754390614e+01,		3.506856048105443e+01,		3.514996701503585e+01,
		3.523122759828502e+01,		3.531234268151203e+01,		3.539331271370943e+01,		3.547413814215904e+01,		3.555481941243899e+01,
		3.563535696843046e+01,		3.571575125232468e+01,		3.579600270462964e+01,		3.587611176417702e+01,		3.595607886812890e+01,
		3.603590445198466e+01,		3.611558894958760e+01,		3.619513279313179e+01,		3.627453641316876e+01,		3.635380023861421e+01,
		3.643292469675463e+01,		3.651191021325402e+01,		3.659075721216055e+01,		3.666946611591310e+01,		3.674803734534786e+01,
		3.682647131970499e+01,		3.690476845663509e+01,		3.698292917220571e+01,		3.706095388090793e+01,		3.713884299566281e+01,
		3.721659692782779e+01,		3.729421608720325e+01,		3.737170088203879e+01,		3.744905171903974e+01,		3.752626900337345e+01,
		3.760335313867571e+01,		3.768030452705688e+01,		3.775712356910857e+01,		3.783381066390947e+01,		3.791036620903196e+01,
		3.798679060054810e+01,		3.806308423303598e+01,		3.813924749958592e+01,		3.821528079180643e+01,		3.829118449983061e+01,
		3.836695901232208e+01,		3.844260471648121e+01,		3.851812199805103e+01,		3.859351124132336e+01,		3.866877282914486e+01,
		3.874390714292299e+01,		3.881891456263199e+01,		3.889379546681878e+01,		3.896855023260903e+01,		3.904317923571286e+01,
		3.911768285043087e+01,		3.919206144966000e+01,		3.926631540489923e+01,		3.934044508625556e+01,		3.941445086244965e+01,
		3.948833310082170e+01,		3.956209216733710e+01,		3.963572842659217e+01,		3.970924224181992e+01,		3.978263397489562e+01,
		3.985590398634253e+01,		3.992905263533748e+01,		4.000208027971647e+01,		4.007498727598023e+01,		4.014777397929983e+01,
		4.022044074352223e+01,		4.029298792117567e+01,		4.036541586347526e+01,		4.043772492032845e+01,		4.050991544034036e+01,
		4.058198777081931e+01,		4.065394225778221e+01,		4.072577924595985e+01,		4.079749907880232e+01,		4.086910209848435e+01,
		4.094058864591050e+01,		4.101195906072066e+01,		4.108321368129505e+01,		4.115435284475964e+01,		4.122537688699136e+01,
		4.129628614262318e+01,		4.136708094504937e+01,		4.143776162643066e+01,		4.150832851769933e+01,		4.157878194856428e+01,
		4.164912224751624e+01,		4.171934974183270e+01,		4.178946475758305e+01,		4.185946761963353e+01,		4.192935865165228e+01,
		4.199913817611425e+01,		4.206880651430627e+01,		4.213836398633186e+01,		4.220781091111623e+01,		4.227714760641117e+01,
		4.234637438879979e+01,		4.241549157370164e+01,		4.248449947537723e+01,		4.255339840693308e+01,		4.262218868032635e+01,
		4.269087060636971e+01,		4.275944449473607e+01,		4.282791065396322e+01,		4.289626939145867e+01,		4.296452101350422e+01,
		4.303266582526072e+01,		4.310070413077265e+01,		4.316863623297275e+01,		4.323646243368669e+01,		4.330418303363754e+01,
		4.337179833245049e+01,		4.343930862865720e+01,		4.350671421970058e+01,		4.357401540193904e+01,		4.364121247065110e+01,
		4.370830572003993e+01,		4.377529544323762e+01,		4.384218193230976e+01,		4.390896547825980e+01,		4.397564637103343e+01,
		4.404222489952295e+01,		4.410870135157162e+01,		4.417507601397804e+01,		4.424134917250040e+01,		4.430752111186082e+01,
		4.437359211574962e+01,		4.443956246682959e+01,		4.450543244674017e+01,		4.457120233610169e+01,		4.463687241451971e+01,
		4.470244296058902e+01,		4.476791425189786e+01,		4.483328656503213e+01,		4.489856017557950e+01,		4.496373535813345e+01,
		4.502881238629745e+01,		4.509379153268900e+01,		4.515867306894368e+01,		4.522345726571928e+01,		4.528814439269961e+01,
		4.535273471859879e+01,		4.541722851116504e+01,		4.548162603718467e+01,		4.554592756248613e+01,		4.561013335194388e+01,
		4.567424366948228e+01,		4.573825877807960e+01,		4.580217893977174e+01,		4.586600441565631e+01,		4.592973546589629e+01,
		4.599337234972401e+01,		4.605691532544481e+01,		4.612036465044098e+01,		4.618372058117557e+01,		4.624698337319599e+01,
		4.631015328113790e+01,		4.637323055872891e+01,		4.643621545879228e+01,		4.649910823325069e+01,		4.656190913312981e+01,
		4.662461840856209e+01,		4.668723630879032e+01,		4.674976308217135e+01,		4.681219897617969e+01,		4.687454423741106e+01,
		4.693679911158604e+01,		4.699896384355367e+01,		4.706103867729492e+01,		4.712302385592631e+01,		4.718491962170346e+01,
		4.724672621602449e+01,		4.730844387943360e+01,		4.737007285162462e+01,		4.743161337144436e+01,		4.749306567689605e+01,
		4.755443000514295e+01,		4.761570659251155e+01,		4.767689567449515e+01,		4.773799748575717e+01,		4.779901226013458e+01,
		4.785994023064117e+01,		4.792078162947102e+01,		4.798153668800177e+01,		4.804220563679794e+01,		4.810278870561419e+01,
		4.816328612339876e+01,		4.822369811829662e+01,		4.828402491765273e+01,		4.834426674801534e+01,		4.840442383513923e+01
	},
	{
		7.843320369259715e-02,		2.351864970932197e-01,		3.915800124810149e-01,		5.476146160422403e-01,		7.032911564438168e-01,
		8.586104660531160e-01,		1.013573362100690e+00,		1.168180647788177e+00,		1.322433113343515e+00,		1.476331537025530e+00,
		1.629876686079873e+00,		1.783069317648212e+00,		1.935910179632512e+00,		2.088400011516163e+00,		2.240539545143664e+00,
		2.392329505460484e+00,		2.543770611214689e+00,		2.694863575621847e+00,		2.845609106994673e+00,		2.996007909338820e+00,
		3.146060682916194e+00,		3.295768124777069e+00,		3.445130929262299e+00,		3.594149788476828e+00,		3.742825392735663e+00,
		3.891158430983471e+00,		4.039149591188862e+00,		4.186799560714426e+00,		4.334109026663542e+00,		4.481078676204936e+00,
		4.627709196875918e+00,		4.774001276865238e+00,		4.919955605276416e+00,		5.065572872372400e+00,		5.210853769802375e+00,
		5.355798990811500e+00,		5.500409230434341e+00,		5.644685185672740e+00,		5.788627555658794e+00,		5.932237041803653e+00,
		6.075514347932798e+00,		6.218460180408405e+00,		6.361075248239410e+00,		6.503360263179877e+00,		6.645315939816221e+00,
		6.786942995643820e+00,		6.928242151133567e+00,		7.069214129788831e+00,		7.209859658193348e+00,		7.350179466050460e+00,
		7.490174286214212e+00,		7.629844854712687e+00,		7.769191910764007e+00,		7.908216196785416e+00,		8.046918458395810e+00,
		8.185299444412076e+00,		8.323359906839633e+00,		8.461100600857439e+00,		8.598522284797887e+00,		8.735625720121801e+00,
		8.872411671388921e+00,		9.008880906224098e+00,		9.145034195279511e+00,		9.280872312193162e+00,		9.416396033543899e+00,
		9.551606138803185e+00,		9.686503410283915e+00,		9.821088633086406e+00,		9.955362595041844e+00,		1.008932608665340e+01,
		1.022297990103511e+01,		1.035632483384883e+01,		1.048936168323933e+01,		1.062209124976783e+01,		1.075451433634395e+01,
		1.088663174815641e+01,		1.101844429260258e+01,		1.114995277921683e+01,		1.128115801959819e+01,		1.141206082733704e+01,
		1.154266201794126e+01,		1.167296240876175e+01,		1.180296281891756e+01,		1.193266406922063e+01,		1.206206698210035e+01,
		1.219117238152789e+01,		1.231998109294055e+01,		1.244849394316601e+01,		1.257671176034682e+01,		1.270463537386494e+01,
		1.283226561426653e+01,		1.295960331318709e+01,		1.308664930327695e+01,		1.321340441812709e+01,		1.333986949219556e+01,
		1.346604536073435e+01,		1.359193285971680e+01,		1.371753282576569e+01,		1.384284609608194e+01,		1.396787350837399e+01,
		1.409261590078793e+01,		1.421707411183842e+01,		1.434124898034029e+01,		1.446514134534101e+01,		1.458875204605412e+01,
		1.471208192179328e+01,		1.483513181190740e+01,		1.495790255571662e+01,		1.508039499244913e+01,		1.520260996117907e+01,
		1.532454830076523e+01,		1.544621084979084e+01,		1.556759844650423e+01,		1.568871192876050e+01,		1.580955213396422e+01,
		1.593011989901307e+01,		1.605041606024251e+01,		1.617044145337141e+01,		1.629019691344872e+01,		1.640968327480119e+01,
		1.652890137098197e+01,		1.664785203472032e+01,		1.676653609787231e+01,		1.688495439137249e+01,		1.700310774518655e+01,
		1.712099698826505e+01,		1.723862294849806e+01,		1.735598645267082e+01,		1.747308832642038e+01,		1.758992939419318e+01,
		1.770651047920369e+01,		1.782283240339388e+01,		1.793889598739370e+01,		1.805470205048262e+01,		1.817025141055180e+01,
		1.828554488406756e+01,		1.840058328603547e+01,		1.851536742996552e+01,		1.862989812783806e+01,		1.874417619007075e+01,
		1.885820242548628e+01,		1.897197764128103e+01,		1.908550264299452e+01,		1.919877823447972e+01,		1.931180521787427e+01,
		1.942458439357235e+01,		1.953711656019756e+01,		1.964940251457642e+01,		1.976144305171276e+01,		1.987323896476282e+01,
		1.998479104501117e+01,		2.009610008184735e+01,		2.020716686274323e+01,		2.031799217323107e+01,		2.042857679688239e+01,
		2.053892151528749e+01,		2.064902710803558e+01,		2.075889435269571e+01,		2.086852402479827e+01,		2.097791689781723e+01,
		2.108707374315295e+01,		2.119599533011563e+01,		2.130468242590941e+01,		2.141313579561704e+01,		2.152135620218520e+01,
		2.162934440641031e+01,		2.173710116692499e+01,		2.184462724018506e+01,		2.195192338045710e+01,		2.205899033980651e+01,
		2.216582886808610e+01,		2.227243971292529e+01,		2.237882361971967e+01,		2.248498133162118e+01,		2.259091358952869e+01,
		2.269662113207911e+01,		2.280210469563893e+01,		2.290736501429624e+01,		2.301240281985318e+01,		2.311721884181880e+01,
		2.322181380740243e+01,		2.332618844150736e+01,		2.343034346672493e+01,		2.353427960332923e+01,		2.363799756927179e+01,
		2.374149808017701e+01,		2.384478184933786e+01,		2.394784958771179e+01,		2.405070200391719e+01,		2.415333980423009e+01,
		2.425576369258123e+01,		2.435797437055341e+01,		2.445997253737926e+01,		2.456175888993921e+01,		2.466333412275977e+01,
		2.476469892801228e+01,		2.486585399551170e+01,		2.496680001271585e+01,		2.506753766472482e+01,		2.516806763428080e+01,
		2.526839060176794e+01,		2.536850724521270e+01,		2.546841824028431e+01,		2.556812426029546e+01,		2.566762597620331e+01,
		2.576692405661067e+01,		2.586601916776739e+01,		2.596491197357201e+01,		2.606360313557360e+01,		2.616209331297377e+01,
		2.626038316262895e+01,		2.635847333905277e+01,		2.645636449441870e+01,		2.655405727856286e+01,		2.665155233898696e+01,
		2.674885032086148e+01,		2.684595186702893e+01,		2.694285761800736e+01,		2.703956821199397e+01,		2.713608428486889e+01,
		2.723240647019908e+01,		2.732853539924241e+01,		2.742447170095188e+01,		2.752021600197993e+01,		2.761576892668288e+01,
		2.771113109712559e+01,		2.780630313308605e+01,		2.790128565206037e+01,		2.799607926926756e+01,		2.809068459765469e+01,
		2.818510224790193e+01,		2.827933282842794e+01,		2.837337694539509e+01,		2.846723520271499e+01,		2.856090820205403e+01,
		2.865439654283895e+01,		2.874770082226258e+01,		2.884082163528966e+01,		2.893375957466266e+01,		2.902651523090777e+01,
		2.911908919234088e+01,		2.921148204507375e+01,		2.930369437302005e+01,		2.939572675790167e+01,		2.948757977925496e+01,
		2.957925401443713e+01,		2.967075003863254e+01,		2.976206842485927e+01,		2.985320974397560e+01,		2.994417456468646e+01,
		3.003496345355022e+01,		3.012557697498514e+01,		3.021601569127621e+01,		3.030628016258180e+01,		3.039637094694050e+01,
		3.048628860027781e+01,		3.057603367641314e+01,		3.066560672706652e+01,		3.075500830186565e+01,		3.084423894835277e+01,
		3.093329921199159e+01,		3.102218963617435e+01,		3.111091076222878e+01,		3.119946312942520e+01,		3.128784727498349e+01,
		3.137606373408024e+01,		3.146411303985581e+01,		3.155199572342147e+01,		3.163971231386649e+01,		3.172726333826532e+01,
		3.181464932168473e+01,		3.190187078719093e+01,		3.198892825585687e+01,		3.207582224676928e+01,		3.216255327703595e+01,
		3.224912186179294e+01,		3.233552851421170e+01,		3.242177374550636e+01,		3.250785806494092e+01,		3.259378197983646e+01,
		3.267954599557839e+01,		3.276515061562355e+01,		3.285059634150764e+01,		3.293588367285221e+01,		3.302101310737203e+01,
		3.310598514088220e+01,		3.319080026730546e+01,		3.327545897867930e+01,		3.335996176516319e+01,		3.344430911504579e+01,
		3.352850151475212e+01,		3.361253944885070e+01,		3.369642340006079e+01,		3.378015384925951e+01,		3.386373127548892e+01,
		3.394715615596336e+01,		3.403042896607635e+01,		3.411355017940782e+01,		3.419652026773124e+01,		3.427933970102065e+01,
		3.436200894745780e+01,		3.444452847343911e+01,		3.452689874358288e+01,		3.460912022073623e+01,		3.469119336598214e+01,
		3.477311863864644e+01,		3.485489649630487e+01,		3.493652739478997e+01,		3.501801178819813e+01,		3.509935012889646e+01,
		3.518054286752979e+01,		3.526159045302749e+01,		3.534249333261047e+01,		3.542325195179792e+01,		3.550386675441435e+01,
		3.558433818259626e+01,		3.566466667679902e+01,		3.574485267580371e+01,		3.582489661672382e+01,		3.590479893501208e+01,
		3.598456006446717e+01,		3.606418043724047e+01,		3.614366048384269e+01,		3.622300063315060e+01,		3.630220131241376e+01,
		3.638126294726096e+01,		3.646018596170710e+01,		3.653897077815954e+01,		3.661761781742481e+01,		3.669612749871516e+01,
		3.677450023965503e+01,		3.685273645628760e+01,		3.693083656308134e+01,		3.700880097293629e+01,		3.708663009719070e+01,
		3.716432434562735e+01,		3.724188412648000e+01,		3.731930984643968e+01,		3.739660191066110e+01,		3.747376072276907e+01,
		3.755078668486461e+01,		3.762768019753139e+01,		3.770444165984193e+01,		3.778107146936387e+01,		3.785757002216616e+01,
		3.793393771282527e+01,		3.801017493443133e+01,		3.808628207859434e+01,		3.816225953545021e+01,		3.823810769366691e+01,
		3.831382694045059e+01,		3.838941766155152e+01,		3.846488024127023e+01,		3.854021506246347e+01,		3.861542250655019e+01,
		3.869050295351748e+01,		3.876545678192660e+01,		3.884028436891879e+01,		3.891498609022119e+01,		3.898956232015279e+01,
		3.906401343163012e+01,		3.913833979617321e+01,		3.921254178391133e+01,		3.928661976358874e+01,		3.936057410257053e+01,
		3.943440516684826e+01,		3.950811332104566e+01,		3.958169892842442e+01,		3.965516235088973e+01,		3.972850394899600e+01,
		3.980172408195238e+01,		3.987482310762848e+01,		3.994780138255982e+01,		4.002065926195345e+01,		4.009339709969343e+01,
		4.016601524834633e+01,		4.023851405916676e+01,		4.031089388210271e+01,		4.038315506580111e+01,		4.045529795761318e+01,
		4.052732290359981e+01,		4.059923024853688e+01,		4.067102033592075e+01,		4.074269350797339e+01,		4.081425010564780e+01,
		4.088569046863324e+01,		4.095701493536056e+01,		4.102822384300721e+01,		4.109931752750276e+01,		4.117029632353382e+01,
		4.124116056454935e+01,		4.131191058276575e+01,		4.138254670917198e+01,		4.145306927353468e+01,		4.152347860440324e+01,
		4.159377502911482e+01,		4.166395887379943e+01,		4.173403046338493e+01,		4.180399012160200e+01,		4.187383817098910e+01,
		4.194357493289755e+01,		4.201320072749621e+01,		4.208271587377658e+01,		4.215212068955766e+01,		4.222141549149072e+01,
		4.229060059506427e+01,		4.235967631460877e+01,		4.242864296330146e+01,		4.249750085317123e+01,		4.256625029510325e+01,
		4.263489159884378e+01,		4.270342507300491e+01,		4.277185102506916e+01,		4.284016976139429e+01,		4.290838158721787e+01,
		4.297648680666190e+01,		4.304448572273756e+01,		4.311237863734961e+01,		4.318016585130115e+01,		4.324784766429804e+01,
		4.331542437495362e+01,		4.338289628079296e+01,		4.345026367825763e+01,		4.351752686270999e+01,		4.358468612843774e+01,
		4.365174176865838e+01,		4.371869407552351e+01,		4.378554334012343e+01,		4.385228985249130e+01,		4.391893390160770e+01,
		4.398547577540482e+01,		4.405191576077096e+01,		4.411825414355460e+01,		4.418449120856892e+01,		4.425062723959595e+01,
		4.431666251939085e+01,		4.438259732968615e+01,		4.444843195119594e+01,		4.451416666362006e+01,		4.457980174564839e+01,
		4.464533747496482e+01,		4.471077412825154e+01,		4.477611198119313e+01,		4.484135130848063e+01,		4.490649238381569e+01,
		4.497153547991456e+01,		4.503648086851216e+01,		4.510132882036627e+01,		4.516607960526129e+01,		4.523073349201242e+01,
		4.529529074846961e+01,		4.535975164152146e+01,		4.542411643709925e+01,		4.548838540018085e+01,		4.555255879479457e+01,
		4.561663688402316e+01,		4.568061993000759e+01,		4.574450819395103e+01,		4.580830193612255e+01,		4.587200141586104e+01,
		4.593560689157906e+01,		4.599911862076655e+01,		4.606253685999459e+01,		4.612586186491932e+01,		4.618909389028548e+01,
		4.625223318993035e+01,		4.631528001678726e+01,		4.637823462288940e+01,		4.644109725937355e+01,		4.650386817648363e+01,
		4.656654762357439e+01,		4.662913584911511e+01,		4.669163310069308e+01,		4.675403962501736e+01,		4.681635566792226e+01,
		4.687858147437094e+01,		4.694071728845896e+01,		4.700276335341786e+01,		4.706471991161860e+01,		4.712658720457518e+01,
		4.718836547294801e+01,		4.725005495654751e+01,		4.731165589433746e+01,		4.737316852443852e+01,		4.743459308413171e+01,
		4.749592980986168e+01,		4.755717893724021e+01,		4.761834070104962e+01,		4.767941533524609e+01,		4.774040307296305e+01,
		4.780130414651452e+01,		4.786211878739837e+01,		4.792284722629979e+01,		4.798348969309443e+01,		4.804404641685180e+01,
		4.810451762583846e+01,		4.816490354752134e+01,		4.822520440857095e+01,		4.828542043486463e+01,		4.834555185148972e+01
	},
	{
		7.828046651902920e-02,		2.347288355415985e-01,		3.908185675667429e-01,		5.465505279829058e-01,		7.019255647945793e-01,
		8.569445098280928e-01,		1.011608179881089e+00,		1.165917377817880e+00,		1.319872893612803e+00,		1.473475505343590e+00,
		1.626725980136716e+00,		1.779625075066599e+00,		1.932173538010463e+00,		2.084372108460587e+00,		2.236221518295637e+00,
		2.387722492512680e+00,		2.538875749921442e+00,		2.689682003802293e+00,		2.840141962529417e+00,		2.990256330160556e+00,
		3.140025806994654e+00,		3.289451090098709e+00,		3.438532873805066e+00,		3.587271850180375e+00,		3.735668709467329e+00,
		3.883724140500353e+00,		4.031438831096280e+00,		4.178813468421065e+00,		4.325848739333555e+00,		4.472545330707257e+00,
		4.618903929731052e+00,		4.764925224189743e+00,		4.910609902725327e+00,		5.055958655079788e+00,		5.200972172320260e+00,
		5.345651147047302e+00,		5.489996273587060e+00,		5.634008248168023e+00,		5.777687769083075e+00,		5.921035536837522e+00,
		6.064052254283712e+00,		6.206738626742919e+00,		6.349095362115052e+00,		6.491123170976764e+00,		6.632822766668565e+00,
		6.774194865371427e+00,		6.915240186173415e+00,		7.055959451126840e+00,		7.196353385296426e+00,		7.336422716798920e+00,
		7.476168176834623e+00,		7.615590499711242e+00,		7.754690422860484e+00,		7.893468686847782e+00,		8.031926035375538e+00,
		8.170063215280223e+00,		8.307880976523732e+00,		8.445380072179260e+00,		8.582561258412102e+00,		8.719425294455577e+00,
		8.855972942582506e+00,		8.992204968072432e+00,		9.128122139174847e+00,		9.263725227068772e+00,		9.399015005818871e+00,
		9.533992252328330e+00,		9.668657746288783e+00,		9.803012270127482e+00,		9.937056608951876e+00,		1.007079155049190e+01,
		1.020421788504002e+01,		1.033733640538940e+01,		1.047014790677018e+01,		1.060265318678415e+01,		1.073485304533799e+01,
		1.086674828457508e+01,		1.099833970880624e+01,		1.112962812443939e+01,		1.126061433990821e+01,		1.139129916560018e+01,
		1.152168341378380e+01,		1.165176789853530e+01,		1.178155343566493e+01,		1.191104084264292e+01,		1.204023093852502e+01,
		1.216912454387811e+01,		1.229772248070557e+01,		1.242602557237272e+01,		1.255403464353230e+01,		1.268175052005014e+01,
		1.280917402893105e+01,		1.293630599824494e+01,		1.306314725705335e+01,		1.318969863533637e+01,		1.331596096391997e+01,
		1.344193507440389e+01,		1.356762179909003e+01,		1.369302197091148e+01,		1.381813642336217e+01,		1.394296599042719e+01,
		1.406751150651378e+01,		1.419177380638315e+01,		1.431575372508297e+01,		1.443945209788073e+01,		1.456286976019788e+01,
		1.468600754754484e+01,		1.480886629545688e+01,		1.493144683943083e+01,		1.505375001486279e+01,		1.517577665698663e+01,
		1.529752760081359e+01,		1.541900368107264e+01,		1.554020573215192e+01,		1.566113458804112e+01,		1.578179108227477e+01,
		1.590217604787659e+01,		1.602229031730477e+01,		1.614213472239824e+01,		1.626171009432397e+01,		1.638101726352517e+01,
		1.650005705967060e+01,		1.661883031160477e+01,		1.673733784729917e+01,		1.685558049380453e+01,		1.697355907720394e+01,
		1.709127442256709e+01,		1.720872735390543e+01,		1.732591869412826e+01,		1.744284926499985e+01,		1.755951988709749e+01,
		1.767593137977050e+01,		1.779208456110019e+01,		1.790798024786071e+01,		1.802361925548094e+01,		1.813900239800718e+01,
		1.825413048806684e+01,		1.836900433683297e+01,		1.848362475398972e+01,		1.859799254769874e+01,		1.871210852456629e+01,
		1.882597348961139e+01,		1.893958824623471e+01,		1.905295359618838e+01,		1.916607033954657e+01,		1.927893927467691e+01,
		1.939156119821274e+01,		1.950393690502611e+01,		1.961606718820165e+01,		1.972795283901112e+01,		1.983959464688874e+01,
		1.995099339940739e+01,		2.006214988225538e+01,		2.017306487921401e+01,		2.028373917213594e+01,		2.039417354092411e+01,
		2.050436876351149e+01,		2.061432561584137e+01,		2.072404487184849e+01,		2.083352730344068e+01,		2.094277368048118e+01,
		2.105178477077169e+01,		2.116056134003592e+01,		2.126910415190377e+01,		2.137741396789623e+01,		2.148549154741069e+01,
		2.159333764770696e+01,		2.170095302389378e+01,		2.180833842891597e+01,		2.191549461354200e+01,		2.202242232635226e+01,
		2.212912231372761e+01,		2.223559531983875e+01,		2.234184208663579e+01,		2.244786335383856e+01,		2.255365985892720e+01,
		2.265923233713338e+01,		2.276458152143187e+01,		2.286970814253259e+01,		2.297461292887314e+01,		2.307929660661174e+01,
		2.318375989962054e+01,		2.328800352947939e+01,		2.339202821547009e+01,		2.349583467457082e+01,		2.359942362145116e+01,
		2.370279576846740e+01,		2.380595182565827e+01,		2.390889250074085e+01,		2.401161849910712e+01,		2.411413052382061e+01,
		2.421642927561347e+01,		2.431851545288389e+01,		2.442038975169381e+01,		2.452205286576692e+01,		2.462350548648698e+01,
		2.472474830289644e+01,		2.482578200169538e+01,		2.492660726724062e+01,		2.502722478154523e+01,		2.512763522427822e+01,
		2.522783927276452e+01,		2.532783760198523e+01,		2.542763088457810e+01,		2.552721979083812e+01,		2.562660498871869e+01,
		2.572578714383257e+01,		2.582476691945340e+01,		2.592354497651723e+01,		2.602212197362442e+01,		2.612049856704152e+01,
		2.621867541070361e+01,		2.631665315621661e+01,		2.641443245285991e+01,		2.651201394758912e+01,		2.660939828503899e+01,
		2.670658610752658e+01,		2.680357805505441e+01,		2.690037476531406e+01,		2.699697687368960e+01,		2.709338501326145e+01,
		2.718959981481016e+01,		2.728562190682052e+01,		2.738145191548569e+01,		2.747709046471142e+01,		2.757253817612062e+01,
		2.766779566905780e+01,		2.776286356059371e+01,		2.785774246553025e+01,		2.795243299640523e+01,		2.804693576349745e+01,
		2.814125137483176e+01,		2.823538043618433e+01,		2.832932355108790e+01,		2.842308132083718e+01,		2.851665434449440e+01,
		2.861004321889481e+01,		2.870324853865242e+01,		2.879627089616567e+01,		2.888911088162337e+01,		2.898176908301041e+01,
		2.907424608611394e+01,		2.916654247452927e+01,		2.925865882966602e+01,		2.935059573075433e+01,		2.944235375485102e+01,
		2.953393347684596e+01,		2.962533546946835e+01,		2.971656030329318e+01,		2.980760854674767e+01,		2.989848076611776e+01,
		2.998917752555467e+01,		3.007969938708149e+01,		3.017004691059984e+01,		3.026022065389657e+01,		3.035022117265044e+01,
		3.044004902043884e+01,		3.052970474874471e+01,		3.061918890696323e+01,		3.070850204240877e+01,		3.079764470032172e+01,
		3.088661742387544e+01,		3.097542075418315e+01,		3.106405523030499e+01,		3.115252138925489e+01,		3.124081976600763e+01,
		3.132895089350592e+01,		3.141691530266736e+01,		3.150471352239152e+01,		3.159234607956710e+01,		3.167981349907890e+01,
		3.176711630381500e+01,		3.185425501467389e+01,		3.194123015057155e+01,		3.202804222844858e+01,		3.211469176327743e+01,
		3.220117926806943e+01,		3.228750525388203e+01,		3.237367022982595e+01,		3.245967470307232e+01,		3.254551917885985e+01,
		3.263120416050204e+01,		3.271673014939428e+01,		3.280209764502109e+01,		3.288730714496323e+01,		3.297235914490492e+01,
		3.305725413864094e+01,		3.314199261808388e+01,		3.322657507327116e+01,		3.331100199237233e+01,		3.339527386169612e+01,
		3.347939116569758e+01,		3.356335438698525e+01,		3.364716400632827e+01,		3.373082050266348e+01,		3.381432435310253e+01,
		3.389767603293896e+01,		3.398087601565530e+01,		3.406392477293016e+01,		3.414682277464522e+01,		3.422957048889239e+01,
		3.431216838198076e+01,		3.439461691844362e+01,		3.447691656104554e+01,		3.455906777078929e+01,		3.464107100692283e+01,
		3.472292672694637e+01,		3.480463538661915e+01,		3.488619743996656e+01,		3.496761333928693e+01,		3.504888353515847e+01,
		3.513000847644612e+01,		3.521098861030851e+01,		3.529182438220477e+01,		3.537251623590123e+01,		3.545306461347849e+01,
		3.553346995533797e+01,		3.561373270020884e+01,		3.569385328515473e+01,		3.577383214558046e+01,		3.585366971523874e+01,
		3.593336642623693e+01,		3.601292270904369e+01,		3.609233899249557e+01,		3.617161570380384e+01,		3.625075326856083e+01,
		3.632975211074680e+01,		3.640861265273634e+01,		3.648733531530499e+01,		3.656592051763574e+01,		3.664436867732564e+01,
		3.672268021039218e+01,		3.680085553127975e+01,		3.687889505286623e+01,		3.695679918646925e+01,		3.703456834185271e+01,
		3.711220292723313e+01,		3.718970334928593e+01,		3.726707001315191e+01,		3.734430332244346e+01,		3.742140367925088e+01,
		3.749837148414869e+01,		3.757520713620178e+01,		3.765191103297175e+01,		3.772848357052298e+01,		3.780492514342901e+01,
		3.788123614477846e+01,		3.795741696618132e+01,		3.803346799777498e+01,		3.810938962823042e+01,		3.818518224475812e+01,
		3.826084623311426e+01,		3.833638197760661e+01,		3.841178986110060e+01,		3.848707026502526e+01,		3.856222356937922e+01,
		3.863725015273651e+01,		3.871215039225263e+01,		3.878692466367029e+01,		3.886157334132534e+01,		3.893609679815259e+01,
		3.901049540569162e+01,		3.908476953409253e+01,		3.915891955212176e+01,		3.923294582716780e+01,		3.930684872524687e+01,
		3.938062861100874e+01,		3.945428584774226e+01,		3.952782079738105e+01,		3.960123382050921e+01,		3.967452527636679e+01,
		3.974769552285545e+01,		3.982074491654402e+01,		3.989367381267405e+01,		3.996648256516517e+01,		4.003917152662081e+01,
		4.011174104833351e+01,		4.018419148029043e+01,		4.025652317117868e+01,		4.032873646839086e+01,		4.040083171803033e+01,
		4.047280926491661e+01,		4.054466945259065e+01,		4.061641262332024e+01,		4.068803911810526e+01,		4.075954927668283e+01,
		4.083094343753275e+01,		4.090222193788257e+01,		4.097338511371284e+01,		4.104443329976231e+01,		4.111536682953302e+01,
		4.118618603529551e+01,		4.125689124809389e+01,		4.132748279775092e+01,		4.139796101287306e+01,		4.146832622085561e+01,
		4.153857874788762e+01,		4.160871891895698e+01,		4.167874705785535e+01,		4.174866348718315e+01,		4.181846852835447e+01,
		4.188816250160201e+01,		4.195774572598197e+01,		4.202721851937896e+01,		4.209658119851080e+01,		4.216583407893337e+01,
		4.223497747504546e+01,		4.230401170009350e+01,		4.237293706617644e+01,		4.244175388425032e+01,		4.251046246413325e+01,
		4.257906311450988e+01,		4.264755614293623e+01,		4.271594185584434e+01,		4.278422055854688e+01,		4.285239255524188e+01,
		4.292045814901715e+01,		4.298841764185507e+01,		4.305627133463707e+01,		4.312401952714819e+01,		4.319166251808161e+01,
		4.325920060504315e+01,		4.332663408455577e+01,		4.339396325206412e+01,		4.346118840193884e+01,		4.352830982748108e+01,
		4.359532782092699e+01,		4.366224267345194e+01,		4.372905467517508e+01,		4.379576411516352e+01,		4.386237128143686e+01,
		4.392887646097132e+01,		4.399527993970420e+01,		4.406158200253805e+01,		4.412778293334500e+01,		4.419388301497097e+01,
		4.425988252923989e+01,		4.432578175695801e+01,		4.439158097791788e+01,		4.445728047090273e+01,		4.452288051369056e+01,
		4.458838138305824e+01,		4.465378335478559e+01,		4.471908670365961e+01,		4.478429170347847e+01,		4.484939862705558e+01,
		4.491440774622365e+01,		4.497931933183871e+01,		4.504413365378414e+01,		4.510885098097468e+01,		4.517347158136035e+01,
		4.523799572193042e+01,		4.530242366871742e+01,		4.536675568680097e+01,		4.543099204031176e+01,		4.549513299243542e+01,
		4.555917880541632e+01,		4.562312974056161e+01,		4.568698605824486e+01,		4.575074801790998e+01,		4.581441587807502e+01,
		4.587798989633596e+01,		4.594147032937047e+01,		4.600485743294170e+01,		4.606815146190196e+01,		4.613135267019650e+01,
		4.619446131086717e+01,		4.625747763605618e+01,		4.632040189700971e+01,		4.638323434408161e+01,		4.644597522673702e+01,
		4.650862479355599e+01,		4.657118329223715e+01,		4.663365096960126e+01,		4.669602807159475e+01,		4.675831484329338e+01,
		4.682051152890575e+01,		4.688261837177677e+01,		4.694463561439131e+01,		4.700656349837757e+01,		4.706840226451064e+01,
		4.713015215271599e+01,		4.719181340207287e+01,		4.725338625081778e+01,		4.731487093634791e+01,		4.737626769522456e+01,
		4.743757676317647e+01,		4.749879837510333e+01,		4.755993276507897e+01,		4.762098016635494e+01,		4.768194081136365e+01,
		4.774281493172172e+01,		4.780360275823348e+01,		4.786430452089401e+01,		4.792492044889261e+01,		4.798545077061595e+01,
		4.804589571365134e+01,		4.810625550479010e+01,		4.816653037003061e+01,		4.822672053458162e+01,		4.828682622286538e+01
	},
	{
		7.812832323937823e-02,		2.342729533478722e-01,		3.900600827653675e-01,		5.454905760546555e-01,		7.005652805285683e-01,
		8.552850274419570e-01,		1.009650633128088e+00,		1.163662900081623e+00,		1.317322617990262e+00,		1.470630564717048e+00,
		1.623587507235271e+00,		1.776194202517797e+00,		1.928451398382634e+00,		2.080359834296415e+00,		2.231920242137498e+00,
		2.383133346920216e+00,		2.533999867481856e+00,		2.684520517133825e+00,		2.834696004278416e+00,		2.984527032992570e+00,
		3.134014303579930e+00,		3.283158513092483e+00,		3.431960355823004e+00,		3.580420523769491e+00,		3.728539707072741e+00,
		3.876318594428159e+00,		4.023757873472871e+00,		4.170858231149153e+00,		4.317620354045187e+00,		4.464044928714071e+00,
		4.610132641972035e+00,		4.755884181176705e+00,		4.901300234486326e+00,		5.046381491100719e+00,		5.191128641484799e+00,
		5.335542377575405e+00,		5.479623392972194e+00,		5.623372383113301e+00,		5.766790045436463e+00,		5.909877079526257e+00,
		6.052634187248097e+00,		6.195062072869615e+00,		6.337161443169998e+00,		6.478933007537871e+00,		6.620377478058269e+00,
		6.761495569589213e+00,		6.902287999828446e+00,		7.042755489370747e+00,		7.182898761756362e+00,		7.322718543510979e+00,
		7.462215564177683e+00,		7.601390556341309e+00,		7.740244255645605e+00,		7.878777400803604e+00,		8.016990733601546e+00,
		8.154884998896742e+00,		8.292460944609713e+00,		8.429719321710920e+00,		8.566660884202436e+00,		8.703286389094840e+00,
		8.839596596379593e+00,		8.975592268997289e+00,		9.111274172801913e+00,		9.246643076521449e+00,		9.381699751715066e+00,
		9.516444972727101e+00,		9.650879516638081e+00,		9.785004163213040e+00,		9.918819694847212e+00,		1.005232689650947e+01,
		1.018552655568358e+01,		1.031841946230743e+01,		1.045100640871059e+01,		1.058328818955010e+01,		1.071526560174486e+01,
		1.084693944440872e+01,		1.097831051878227e+01,		1.110937962816374e+01,		1.124014757783884e+01,		1.137061517500990e+01,
		1.150078322872430e+01,		1.163065254980236e+01,		1.176022395076467e+01,		1.188949824575924e+01,		1.201847625048820e+01,
		1.214715878213448e+01,		1.227554665928825e+01,		1.240364070187350e+01,		1.253144173107460e+01,		1.265895056926300e+01,
		1.278616803992415e+01,		1.291309496758473e+01,		1.303973217774015e+01,		1.316608049678246e+01,		1.329214075192869e+01,
		1.341791377114974e+01,		1.354340038309969e+01,		1.366860141704579e+01,		1.379351770279905e+01,		1.391815007064541e+01,
		1.404249935127773e+01,		1.416656637572836e+01,		1.429035197530261e+01,		1.441385698151287e+01,		1.453708222601362e+01,
		1.466002854053724e+01,		1.478269675683062e+01,		1.490508770659279e+01,		1.502720222141326e+01,		1.514904113271132e+01,
		1.527060527167634e+01,		1.539189546920887e+01,		1.551291255586277e+01,		1.563365736178821e+01,		1.575413071667573e+01,
		1.587433344970114e+01,		1.599426638947146e+01,		1.611393036397182e+01,		1.623332620051332e+01,		1.635245472568190e+01,
		1.647131676528808e+01,		1.658991314431785e+01,		1.670824468688436e+01,		1.682631221618071e+01,		1.694411655443361e+01,
		1.706165852285811e+01,		1.717893894161320e+01,		1.729595862975843e+01,		1.741271840521144e+01,		1.752921908470646e+01,
		1.764546148375376e+01,		1.776144641660002e+01,		1.787717469618960e+01,		1.799264713412678e+01,		1.810786454063886e+01,
		1.822282772454020e+01,		1.833753749319713e+01,		1.845199465249376e+01,		1.856620000679864e+01,		1.868015435893227e+01,
		1.879385851013555e+01,		1.890731326003895e+01,		1.902051940663259e+01,		1.913347774623715e+01,		1.924618907347552e+01,
		1.935865418124534e+01,		1.947087386069224e+01,		1.958284890118396e+01,		1.969458009028506e+01,		1.980606821373265e+01,
		1.991731405541260e+01,		2.002831839733664e+01,		2.013908201962011e+01,		2.024960570046049e+01,		2.035989021611651e+01,
		2.046993634088808e+01,		2.057974484709679e+01,		2.068931650506710e+01,		2.079865208310823e+01,		2.090775234749664e+01,
		2.101661806245909e+01,		2.112524999015646e+01,		2.123364889066802e+01,		2.134181552197640e+01,		2.144975063995309e+01,
		2.155745499834453e+01,		2.166492934875874e+01,		2.177217444065255e+01,		2.187919102131927e+01,		2.198597983587704e+01,
		2.209254162725756e+01,		2.219887713619534e+01,		2.230498710121756e+01,		2.241087225863429e+01,		2.251653334252923e+01,
		2.262197108475096e+01,		2.272718621490455e+01,		2.283217946034375e+01,		2.293695154616341e+01,		2.304150319519265e+01,
		2.314583512798804e+01,		2.324994806282756e+01,		2.335384271570473e+01,		2.345751980032320e+01,		2.356098002809173e+01,
		2.366422410811957e+01,		2.376725274721208e+01,		2.387006664986692e+01,		2.397266651827032e+01,		2.407505305229392e+01,
		2.417722694949182e+01,		2.427918890509797e+01,		2.438093961202392e+01,		2.448247976085677e+01,		2.458381003985757e+01,
		2.468493113495991e+01,		2.478584372976877e+01,		2.488654850555977e+01,		2.498704614127853e+01,		2.508733731354047e+01,
		2.518742269663068e+01,		2.528730296250420e+01,		2.538697878078647e+01,		2.548645081877397e+01,		2.558571974143524e+01,
		2.568478621141191e+01,		2.578365088902017e+01,		2.588231443225227e+01,		2.598077749677838e+01,		2.607904073594851e+01,
		2.617710480079472e+01,		2.627497034003348e+01,		2.637263800006826e+01,		2.647010842499217e+01,		2.656738225659097e+01,
		2.666446013434610e+01,		2.676134269543792e+01,		2.685803057474908e+01,		2.695452440486812e+01,		2.705082481609314e+01,
		2.714693243643567e+01,		2.724284789162460e+01,		2.733857180511039e+01,		2.743410479806920e+01,		2.752944748940740e+01,
		2.762460049576599e+01,		2.771956443152527e+01,		2.781433990880954e+01,		2.790892753749194e+01,		2.800332792519949e+01,
		2.809754167731806e+01,		2.819156939699758e+01,		2.828541168515731e+01,		2.837906914049115e+01,		2.847254235947313e+01,
		2.856583193636290e+01,		2.865893846321143e+01,		2.875186252986659e+01,		2.884460472397902e+01,		2.893716563100792e+01,
		2.902954583422706e+01,		2.912174591473064e+01,		2.921376645143948e+01,		2.930560802110707e+01,		2.939727119832576e+01,
		2.948875655553305e+01,		2.958006466301784e+01,		2.967119608892684e+01,		2.976215139927086e+01,		2.985293115793143e+01,
		2.994353592666719e+01,		3.003396626512048e+01,		3.012422273082389e+01,		3.021430587920697e+01,		3.030421626360280e+01,
		3.039395443525481e+01,		3.048352094332341e+01,		3.057291633489285e+01,		3.066214115497799e+01,		3.075119594653114e+01,
		3.084008125044891e+01,		3.092879760557915e+01,		3.101734554872779e+01,		3.110572561466584e+01,		3.119393833613632e+01,
		3.128198424386125e+01,		3.136986386654863e+01,		3.145757773089948e+01,		3.154512636161481e+01,		3.163251028140276e+01,
		3.171973001098558e+01,		3.180678606910669e+01,		3.189367897253785e+01,		3.198040923608615e+01,		3.206697737260109e+01,
		3.215338389298185e+01,		3.223962930618416e+01,		3.232571411922762e+01,		3.241163883720270e+01,		3.249740396327789e+01,
		3.258300999870679e+01,		3.266845744283531e+01,		3.275374679310873e+01,		3.283887854507882e+01,		3.292385319241099e+01,
		3.300867122689139e+01,		3.309333313843398e+01,		3.317783941508775e+01,		3.326219054304369e+01,		3.334638700664200e+01,
		3.343042928837909e+01,		3.351431786891472e+01,		3.359805322707908e+01,		3.368163583987981e+01,		3.376506618250910e+01,
		3.384834472835071e+01,		3.393147194898704e+01,		3.401444831420613e+01,		3.409727429200868e+01,		3.417995034861507e+01,
		3.426247694847232e+01,		3.434485455426111e+01,		3.442708362690272e+01,		3.450916462556595e+01,		3.459109800767411e+01,
		3.467288422891195e+01,		3.475452374323250e+01,		3.483601700286400e+01,		3.491736445831678e+01,		3.499856655839010e+01,
		3.507962375017905e+01,		3.516053647908125e+01,		3.524130518880381e+01,		3.532193032137000e+01,		3.540241231712605e+01,
		3.548275161474800e+01,		3.556294865124825e+01,		3.564300386198246e+01,		3.572291768065613e+01,		3.580269053933134e+01,
		3.588232286843337e+01,		3.596181509675733e+01,		3.604116765147483e+01,		3.612038095814054e+01,		3.619945544069878e+01,
		3.627839152149010e+01,		3.635718962125770e+01,		3.643585015915414e+01,		3.651437355274766e+01,		3.659276021802877e+01,
		3.667101056941664e+01,		3.674912501976553e+01,		3.682710398037121e+01,		3.690494786097737e+01,		3.698265706978201e+01,
		3.706023201344365e+01,		3.713767309708778e+01,		3.721498072431316e+01,		3.729215529719798e+01,		3.736919721630627e+01,
		3.744610688069400e+01,		3.752288468791533e+01,		3.759953103402887e+01,		3.767604631360374e+01,		3.775243091972578e+01,
		3.782868524400359e+01,		3.790480967657474e+01,		3.798080460611175e+01,		3.805667041982819e+01,		3.813240750348469e+01,
		3.820801624139492e+01,		3.828349701643164e+01,		3.835885021003257e+01,		3.843407620220641e+01,		3.850917537153872e+01,
		3.858414809519773e+01,		3.865899474894037e+01,		3.873371570711799e+01,		3.880831134268222e+01,		3.888278202719076e+01,
		3.895712813081317e+01,		3.903135002233658e+01,		3.910544806917151e+01,		3.917942263735746e+01,		3.925327409156869e+01,
		3.932700279511983e+01,		3.940060910997150e+01,		3.947409339673600e+01,		3.954745601468283e+01,		3.962069732174430e+01,
		3.969381767452104e+01,		3.976681742828757e+01,		3.983969693699777e+01,		3.991245655329034e+01,		3.998509662849433e+01,
		4.005761751263450e+01,		4.013001955443679e+01,		4.020230310133357e+01,		4.027446849946926e+01,		4.034651609370543e+01,
		4.041844622762623e+01,		4.049025924354370e+01,		4.056195548250304e+01,		4.063353528428780e+01,		4.070499898742522e+01,
		4.077634692919134e+01,		4.084757944561626e+01,		4.091869687148927e+01,		4.098969954036401e+01,		4.106058778456364e+01,
		4.113136193518581e+01,		4.120202232210787e+01,		4.127256927399191e+01,		4.134300311828970e+01,		4.141332418124787e+01,
		4.148353278791274e+01,		4.155362926213542e+01,		4.162361392657665e+01,		4.169348710271185e+01,		4.176324911083595e+01,
		4.183290027006829e+01,		4.190244089835751e+01,		4.197187131248637e+01,		4.204119182807663e+01,		4.211040275959379e+01,
		4.217950442035190e+01,		4.224849712251837e+01,		4.231738117711861e+01,		4.238615689404086e+01,		4.245482458204086e+01,
		4.252338454874652e+01,		4.259183710066256e+01,		4.266018254317521e+01,		4.272842118055677e+01,		4.279655331597031e+01,
		4.286457925147411e+01,		4.293249928802638e+01,		4.300031372548968e+01,		4.306802286263552e+01,		4.313562699714882e+01,
		4.320312642563239e+01,		4.327052144361146e+01,		4.333781234553807e+01,		4.340499942479549e+01,		4.347208297370268e+01,
		4.353906328351861e+01,		4.360594064444668e+01,		4.367271534563908e+01,		4.373938767520105e+01,		4.380595792019534e+01,
		4.387242636664625e+01,		4.393879329954422e+01,		4.400505900284980e+01,		4.407122375949811e+01,		4.413728785140290e+01,
		4.420325155946089e+01,		4.426911516355584e+01,		4.433487894256272e+01,		4.440054317435196e+01,		4.446610813579349e+01,
		4.453157410276087e+01,		4.459694135013542e+01,		4.466221015181020e+01,		4.472738078069419e+01,		4.479245350871622e+01,
		4.485742860682914e+01,		4.492230634501360e+01,		4.498708699228229e+01,		4.505177081668371e+01,		4.511635808530622e+01,
		4.518084906428196e+01,		4.524524401879076e+01,		4.530954321306405e+01,		4.537374691038876e+01,		4.543785537311115e+01,
		4.550186886264067e+01,		4.556578763945380e+01,		4.562961196309794e+01,		4.569334209219501e+01,		4.575697828444549e+01,
		4.582052079663204e+01,		4.588396988462319e+01,		4.594732580337728e+01,		4.601058880694597e+01,		4.607375914847806e+01,
		4.613683708022318e+01,		4.619982285353537e+01,		4.626271671887682e+01,		4.632551892582148e+01,		4.638822972305871e+01,
		4.645084935839681e+01,		4.651337807876666e+01,		4.657581613022537e+01,		4.663816375795970e+01,		4.670042120628965e+01,
		4.676258871867211e+01,		4.682466653770414e+01,		4.688665490512673e+01,		4.694855406182807e+01,		4.701036424784714e+01,
		4.707208570237707e+01,		4.713371866376871e+01,		4.719526336953398e+01,		4.725672005634916e+01,		4.731808896005851e+01,
		4.737937031567751e+01,		4.744056435739621e+01,		4.750167131858264e+01,		4.756269143178616e+01,		4.762362492874068e+01,
		4.768447204036806e+01,		4.774523299678135e+01,		4.780590802728814e+01,		4.786649736039367e+01,		4.792700122380427e+01,
		4.798741984443045e+01,		4.804775344839018e+01,		4.810800226101207e+01,		4.816816650683866e+01,		4.822824640962939e+01
	},
	{
		7.797677039529873e-02,		2.338188401446305e-01,		3.893045408202996e-01,		5.444347361321921e-01,		6.992102726728515e-01,
		8.536319810958325e-01,		1.007700677239191e+00,		1.161417163196249e+00,		1.314782228335685e+00,		1.467796650272921e+00,
		1.620461195794704e+00,		1.772776621738705e+00,		1.924743675829897e+00,		2.076363097475407e+00,		2.227635618519448e+00,
		2.378561963959940e+00,		2.529142852628287e+00,		2.679378997833796e+00,		2.829271107974136e+00,		2.978819887113181e+00,
		3.128026035527541e+00,		3.276890250223057e+00,		3.425413225422448e+00,		3.573595653025286e+00,		3.721438223041445e+00,
		3.868941623999078e+00,		4.016106543328205e+00,		4.162933667720893e+00,		4.309423683469022e+00,		4.455577276780589e+00,
		4.601395134075410e+00,		4.746877942261159e+00,		4.892026388990538e+00,		5.036841162900422e+00,		5.181322953833746e+00,
		5.325472453044894e+00,		5.469290353389343e+00,		5.612777349498225e+00,		5.755934137938523e+00,		5.898761417359534e+00,
		6.041259888626230e+00,		6.183430254940149e+00,		6.325273221948351e+00,		6.466789497841058e+00,		6.607979793438489e+00,
		6.748844822267419e+00,		6.889385300627964e+00,		7.029601947651093e+00,		7.169495485347291e+00,		7.309066638646894e+00,
		7.448316135432438e+00,		7.587244706563524e+00,		7.725853085894530e+00,		7.864142010285594e+00,		8.002112219607231e+00,
		8.139764456738924e+00,		8.277099467562032e+00,		8.414118000947369e+00,		8.550820808737742e+00,		8.687208645725720e+00,
		8.823282269627020e+00,		8.959042441049672e+00,		9.094489923459314e+00,		9.229625483140817e+00,		9.364449889156523e+00,
		9.498963913301321e+00,		9.633168330054753e+00,		9.767063916530406e+00,		9.900651452422773e+00,		1.003393171995180e+01,
		1.016690550380525e+01,		1.029957359107917e+01,		1.043193677121649e+01,		1.056399583594403e+01,		1.069575157920807e+01,
		1.082720479710852e+01,		1.095835628783195e+01,		1.108920685158359e+01,		1.121975729051834e+01,		1.135000840867105e+01,
		1.147996101188613e+01,		1.160961590774647e+01,		1.173897390550203e+01,		1.186803581599801e+01,		1.199680245160269e+01,
		1.212527462613521e+01,		1.225345315479308e+01,		1.238133885407986e+01,		1.250893254173273e+01,		1.263623503665032e+01,
		1.276324715882058e+01,		1.288996972924909e+01,		1.301640356988754e+01,		1.314254950356262e+01,		1.326840835390540e+01,
		1.339398094528110e+01,		1.351926810271939e+01,		1.364427065184533e+01,		1.376898941881079e+01,		1.389342523022666e+01,
		1.401757891309559e+01,		1.414145129474548e+01,		1.426504320276381e+01,		1.438835546493258e+01,		1.451138890916412e+01,
		1.463414436343773e+01,		1.475662265573710e+01,		1.487882461398860e+01,		1.500075106600046e+01,		1.512240283940284e+01,
		1.524378076158871e+01,		1.536488565965579e+01,		1.548571836034929e+01,		1.560627969000562e+01,		1.572657047449706e+01,
		1.584659153917732e+01,		1.596634370882814e+01,		1.608582780760674e+01,		1.620504465899430e+01,		1.632399508574537e+01,
		1.644267990983828e+01,		1.656109995242644e+01,		1.667925603379064e+01,		1.679714897329234e+01,		1.691477958932787e+01,
		1.703214869928359e+01,		1.714925711949198e+01,		1.726610566518877e+01,		1.738269515047089e+01,		1.749902638825540e+01,
		1.761510019023936e+01,		1.773091736686063e+01,		1.784647872725954e+01,		1.796178507924150e+01,		1.807683722924048e+01,
		1.819163598228344e+01,		1.830618214195556e+01,		1.842047651036639e+01,		1.853451988811684e+01,		1.864831307426707e+01,
		1.876185686630515e+01,		1.887515206011658e+01,		1.898819944995469e+01,		1.910099982841174e+01,		1.921355398639093e+01,
		1.932586271307915e+01,		1.943792679592048e+01,		1.954974702059049e+01,		1.966132417097136e+01,		1.977265902912760e+01,
		1.988375237528262e+01,		1.999460498779603e+01,		2.010521764314154e+01,		2.021559111588566e+01,		2.032572617866713e+01,
		2.043562360217683e+01,		2.054528415513859e+01,		2.065470860429049e+01,		2.076389771436691e+01,		2.087285224808113e+01,
		2.098157296610859e+01,		2.109006062707079e+01,		2.119831598751973e+01,		2.130633980192295e+01,		2.141413282264916e+01,
		2.152169579995450e+01,		2.162902948196919e+01,		2.173613461468490e+01,		2.184301194194254e+01,		2.194966220542064e+01,
		2.205608614462417e+01,		2.216228449687393e+01,		2.226825799729643e+01,		2.237400737881418e+01,		2.247953337213652e+01,
		2.258483670575089e+01,		2.268991810591458e+01,		2.279477829664684e+01,		2.289941799972150e+01,		2.300383793466004e+01,
		2.310803881872491e+01,		2.321202136691351e+01,		2.331578629195232e+01,		2.341933430429152e+01,		2.352266611210007e+01,
		2.362578242126100e+01,		2.372868393536718e+01,		2.383137135571736e+01,		2.393384538131265e+01,		2.403610670885323e+01,
		2.413815603273546e+01,		2.423999404504929e+01,		2.434162143557595e+01,		2.444303889178602e+01,		2.454424709883771e+01,
		2.464524673957551e+01,		2.474603849452902e+01,		2.484662304191218e+01,		2.494700105762267e+01,		2.504717321524165e+01,
		2.514714018603362e+01,		2.524690263894674e+01,		2.534646124061315e+01,		2.544581665534975e+01,		2.554496954515904e+01,
		2.564392056973027e+01,		2.574267038644077e+01,		2.584121965035754e+01,		2.593956901423896e+01,		2.603771912853676e+01,
		2.613567064139824e+01,		2.623342419866848e+01,		2.633098044389301e+01,		2.642834001832039e+01,		2.652550356090516e+01,
		2.662247170831085e+01,		2.671924509491319e+01,		2.681582435280345e+01,		2.691221011179199e+01,		2.700840299941194e+01,
		2.710440364092292e+01,		2.720021265931506e+01,		2.729583067531308e+01,		2.739125830738050e+01,		2.748649617172390e+01,
		2.758154488229753e+01,		2.767640505080773e+01,		2.777107728671778e+01,		2.786556219725258e+01,		2.795986038740363e+01,
		2.805397245993408e+01,		2.814789901538373e+01,		2.824164065207435e+01,		2.833519796611503e+01,		2.842857155140739e+01,
		2.852176199965128e+01,		2.861476990035023e+01,		2.870759584081710e+01,		2.880024040617989e+01,		2.889270417938745e+01,
		2.898498774121543e+01,		2.907709167027217e+01,		2.916901654300476e+01,		2.926076293370507e+01,		2.935233141451592e+01,
		2.944372255543727e+01,		2.953493692433245e+01,		2.962597508693451e+01,		2.971683760685252e+01,		2.980752504557803e+01,
		2.989803796249150e+01,		2.998837691486881e+01,		3.007854245788778e+01,		3.016853514463476e+01,		3.025835552611128e+01,
		3.034800415124065e+01,		3.043748156687474e+01,		3.052678831780063e+01,		3.061592494674736e+01,		3.070489199439282e+01,
		3.079368999937040e+01,		3.088231949827602e+01,		3.097078102567484e+01,		3.105907511410821e+01,		3.114720229410062e+01,
		3.123516309416650e+01,		3.132295804081735e+01,		3.141058765856855e+01,		3.149805246994641e+01,		3.158535299549512e+01,
		3.167248975378388e+01,		3.175946326141373e+01,		3.184627403302472e+01,		3.193292258130290e+01,		3.201940941698738e+01,
		3.210573504887736e+01,		3.219189998383926e+01,		3.227790472681365e+01,		3.236374978082246e+01,		3.244943564697600e+01,
		3.253496282447998e+01,		3.262033181064264e+01,		3.270554310088185e+01,		3.279059718873214e+01,		3.287549456585172e+01,
		3.296023572202971e+01,		3.304482114519302e+01,		3.312925132141353e+01,		3.321352673491511e+01,		3.329764786808068e+01,
		3.338161520145925e+01,		3.346542921377294e+01,		3.354909038192402e+01,		3.363259918100199e+01,		3.371595608429048e+01,
		3.379916156327436e+01,		3.388221608764663e+01,		3.396512012531554e+01,		3.404787414241140e+01,		3.413047860329366e+01,
		3.421293397055783e+01,		3.429524070504236e+01,		3.437739926583561e+01,		3.445941011028276e+01,		3.454127369399269e+01,
		3.462299047084487e+01,		3.470456089299615e+01,		3.478598541088773e+01,		3.486726447325190e+01,		3.494839852711889e+01,
		3.502938801782371e+01,		3.511023338901281e+01,		3.519093508265096e+01,		3.527149353902796e+01,		3.535190919676538e+01,
		3.543218249282323e+01,		3.551231386250672e+01,		3.559230373947288e+01,		3.567215255573721e+01,		3.575186074168041e+01,
		3.583142872605486e+01,		3.591085693599132e+01,		3.599014579700547e+01,		3.606929573300445e+01,		3.614830716629348e+01,
		3.622718051758223e+01,		3.630591620599147e+01,		3.638451464905946e+01,		3.646297626274843e+01,		3.654130146145097e+01,
		3.661949065799655e+01,		3.669754426365779e+01,		3.677546268815689e+01,		3.685324633967197e+01,		3.693089562484343e+01,
		3.700841094878017e+01,		3.708579271506598e+01,		3.716304132576569e+01,		3.724015718143151e+01,		3.731714068110918e+01,
		3.739399222234419e+01,		3.747071220118794e+01,		3.754730101220391e+01,		3.762375904847378e+01,		3.770008670160350e+01,
		3.777628436172943e+01,		3.785235241752435e+01,		3.792829125620356e+01,		3.800410126353079e+01,		3.807978282382430e+01,
		3.815533631996276e+01,		3.823076213339129e+01,		3.830606064412732e+01,		3.838123223076646e+01,		3.845627727048846e+01,
		3.853119613906298e+01,		3.860598921085558e+01,		3.868065685883324e+01,		3.875519945457048e+01,		3.882961736825486e+01,
		3.890391096869289e+01,		3.897808062331564e+01,		3.905212669818451e+01,		3.912604955799687e+01,		3.919984956609167e+01,
		3.927352708445515e+01,		3.934708247372643e+01,		3.942051609320295e+01,		3.949382830084629e+01,		3.956701945328742e+01,
		3.964008990583245e+01,		3.971304001246798e+01,		3.978587012586664e+01,		3.985858059739247e+01,		3.993117177710639e+01,
		4.000364401377162e+01,		4.007599765485904e+01,		4.014823304655248e+01,		4.022035053375419e+01,		4.029235046009002e+01,
		4.036423316791479e+01,		4.043599899831752e+01,		4.050764829112670e+01,		4.057918138491554e+01,		4.065059861700706e+01,
		4.072190032347942e+01,		4.079308683917099e+01,		4.086415849768547e+01,		4.093511563139707e+01,		4.100595857145559e+01,
		4.107668764779142e+01,		4.114730318912071e+01,		4.121780552295025e+01,		4.128819497558268e+01,		4.135847187212123e+01,
		4.142863653647494e+01,		4.149868929136336e+01,		4.156863045832172e+01,		4.163846035770558e+01,		4.170817930869588e+01,
		4.177778762930382e+01,		4.184728563637554e+01,		4.191667364559710e+01,		4.198595197149918e+01,		4.205512092746186e+01,
		4.212418082571952e+01,		4.219313197736534e+01,		4.226197469235621e+01,		4.233070927951730e+01,		4.239933604654688e+01,
		4.246785530002080e+01,		4.253626734539727e+01,		4.260457248702136e+01,		4.267277102812976e+01,		4.274086327085513e+01,
		4.280884951623083e+01,		4.287673006419543e+01,		4.294450521359715e+01,		4.301217526219844e+01,		4.307974050668042e+01,
		4.314720124264733e+01,		4.321455776463098e+01,		4.328181036609522e+01,		4.334895933944022e+01,		4.341600497600698e+01,
		4.348294756608162e+01,		4.354978739889972e+01,		4.361652476265071e+01,		4.368315994448211e+01,		4.374969323050386e+01,
		4.381612490579252e+01,		4.388245525439559e+01,		4.394868455933578e+01,		4.401481310261507e+01,		4.408084116521906e+01,
		4.414676902712110e+01,		4.421259696728637e+01,		4.427832526367616e+01,		4.434395419325187e+01,		4.440948403197918e+01,
		4.447491505483212e+01,		4.454024753579717e+01,		4.460548174787725e+01,		4.467061796309575e+01,		4.473565645250063e+01,
		4.480059748616841e+01,		4.486544133320804e+01,		4.493018826176498e+01,		4.499483853902502e+01,		4.505939243121845e+01,
		4.512385020362366e+01,		4.518821212057131e+01,		4.525247844544800e+01,		4.531664944070027e+01,		4.538072536783840e+01,
		4.544470648744019e+01,		4.550859305915488e+01,		4.557238534170682e+01,		4.563608359289935e+01,		4.569968806961850e+01,
		4.576319902783677e+01,		4.582661672261686e+01,		4.588994140811533e+01,		4.595317333758636e+01,		4.601631276338541e+01,
		4.607935993697287e+01,		4.614231510891773e+01,		4.620517852890121e+01,		4.626795044572033e+01,		4.633063110729162e+01,
		4.639322076065457e+01,		4.645571965197531e+01,		4.651812802655012e+01,		4.658044612880892e+01,		4.664267420231891e+01,
		4.670481248978799e+01,		4.676686123306828e+01,		4.682882067315954e+01,		4.689069105021281e+01,		4.695247260353357e+01,
		4.701416557158549e+01,		4.707577019199361e+01,		4.713728670154785e+01,		4.719871533620636e+01,		4.726005633109890e+01,
		4.732130992053029e+01,		4.738247633798355e+01,		4.744355581612343e+01,		4.750454858679963e+01,		4.756545488105009e+01,
		4.762627492910435e+01,		4.768700896038674e+01,		4.774765720351967e+01,		4.780821988632692e+01,		4.786869723583676e+01,
		4.792908947828526e+01,		4.798939683911951e+01,		4.804961954300063e+01,		4.810975781380726e+01,		4.816981187463837e+01
	},
	{
		7.782580455525430e-02,		2.333664856449327e-01,		3.885519246090580e-01,		5.433829842779314e-01,		6.978605104957725e-01,
		8.519853332856269e-01,		1.005758267960125e+00,		1.159180116180196e+00,		1.312251666963749e+00,		1.464973697646290e+00,
		1.617346974795315e+00,		1.769372255080306e+00,		1.921050286100042e+00,		2.072381807168909e+00,		2.223367550063804e+00,
		2.374008239733185e+00,		2.524304594969754e+00,		2.674257329048219e+00,		2.823867150329508e+00,		2.973134762832763e+00,
		3.122060866776435e+00,		3.270646159089669e+00,		3.418891333895219e+00,		3.566797082965019e+00,		3.714364096149538e+00,
		3.861593061781987e+00,		4.008484667058399e+00,		4.155039598394610e+00,		4.301258541761063e+00,		4.447142182996417e+00,
		4.592691208100791e+00,		4.737906303509570e+00,		4.882788156348554e+00,		5.027337454671304e+00,		5.171554887679406e+00,
		5.315441145926441e+00,		5.458996921506374e+00,		5.602222908227027e+00,		5.745119801769365e+00,		5.887688299833164e+00,
		6.029929102269755e+00,		6.171842911202401e+00,		6.313430431134899e+00,		6.454692369048944e+00,		6.595629434490845e+00,
		6.736242339648035e+00,		6.876531799415929e+00,		7.016498531455581e+00,		7.156143256242618e+00,		7.295466697107874e+00,
		7.434469580270173e+00,		7.573152634861638e+00,		7.711516592945982e+00,		7.849562189530073e+00,		7.987290162569223e+00,
		8.124701252966494e+00,		8.261796204566375e+00,		8.398575764143171e+00,		8.535040681384384e+00,		8.671191708869410e+00,
		8.807029602043796e+00,		8.942555119189413e+00,		9.077769021390711e+00,		9.212672072497368e+00,		9.347265039083553e+00,
		9.481548690404072e+00,		9.615523798347528e+00,		9.749191137386818e+00,		9.882551484527099e+00,		1.001560561925142e+01,
		1.014835432346426e+01,		1.028079838143304e+01,		1.041293857972796e+01,		1.054477570716008e+01,		1.067631055471802e+01,
		1.080754391550331e+01,		1.093847658466456e+01,		1.106910935933053e+01,		1.119944303854238e+01,		1.132947842318501e+01,
		1.145921631591778e+01,		1.158865752110459e+01,		1.171780284474361e+01,		1.184665309439643e+01,		1.197520907911713e+01,
		1.210347160938102e+01,		1.223144149701335e+01,		1.235911955511792e+01,		1.248650659800580e+01,		1.261360344112409e+01,
		1.274041090098495e+01,		1.286692979509479e+01,		1.299316094188378e+01,		1.311910516063578e+01,		1.324476327141859e+01,
		1.337013609501474e+01,		1.349522445285271e+01,		1.362002916693875e+01,		1.374455105978929e+01,		1.386879095436391e+01,
		1.399274967399905e+01,		1.411642804234236e+01,		1.423982688328779e+01,		1.436294702091142e+01,		1.448578927940809e+01,
		1.460835448302874e+01,		1.473064345601870e+01,		1.485265702255669e+01,		1.497439600669478e+01,		1.509586123229910e+01,
		1.521705352299155e+01,		1.533797370209235e+01,		1.545862259256348e+01,		1.557900101695304e+01,		1.569910979734062e+01,
		1.581894975528342e+01,		1.593852171176351e+01,		1.605782648713586e+01,		1.617686490107743e+01,		1.629563777253714e+01,
		1.641414591968679e+01,		1.653239015987299e+01,		1.665037130956992e+01,		1.676809018433317e+01,		1.688554759875439e+01,
		1.700274436641701e+01,		1.711968129985273e+01,		1.723635921049917e+01,		1.735277890865819e+01,		1.746894120345534e+01,
		1.758484690280012e+01,		1.770049681334710e+01,		1.781589174045816e+01,		1.793103248816531e+01,		1.804591985913466e+01,
		1.816055465463115e+01,		1.827493767448415e+01,		1.838906971705393e+01,		1.850295157919903e+01,		1.861658405624437e+01,
		1.872996794195032e+01,		1.884310402848244e+01,		1.895599310638220e+01,		1.906863596453836e+01,		1.918103339015921e+01,
		1.929318616874563e+01,		1.940509508406475e+01,		1.951676091812464e+01,		1.962818445114946e+01,		1.973936646155559e+01,
		1.985030772592829e+01,		1.996100901899923e+01,		2.007147111362464e+01,		2.018169478076415e+01,		2.029168078946035e+01,
		2.040142990681900e+01,		2.051094289798992e+01,		2.062022052614846e+01,		2.072926355247771e+01,		2.083807273615124e+01,
		2.094664883431655e+01,		2.105499260207899e+01,		2.116310479248642e+01,		2.127098615651438e+01,		2.137863744305175e+01,
		2.148605939888721e+01,		2.159325276869592e+01,		2.170021829502704e+01,		2.180695671829159e+01,		2.191346877675091e+01,
		2.201975520650560e+01,		2.212581674148493e+01,		2.223165411343684e+01,		2.233726805191828e+01,		2.244265928428614e+01,
		2.254782853568850e+01,		2.265277652905651e+01,		2.275750398509653e+01,		2.286201162228280e+01,		2.296630015685050e+01,
		2.307037030278926e+01,		2.317422277183696e+01,		2.327785827347407e+01,		2.338127751491826e+01,		2.348448120111946e+01,
		2.358747003475520e+01,		2.369024471622639e+01,		2.379280594365343e+01,		2.389515441287264e+01,		2.399729081743302e+01,
		2.409921584859333e+01,		2.420093019531955e+01,		2.430243454428260e+01,		2.440372957985631e+01,		2.450481598411580e+01,
		2.460569443683605e+01,		2.470636561549081e+01,		2.480683019525179e+01,		2.490708884898798e+01,		2.500714224726547e+01,
		2.510699105834730e+01,		2.520663594819365e+01,		2.530607758046235e+01,		2.540531661650940e+01,		2.550435371538998e+01,
		2.560318953385951e+01,		2.570182472637493e+01,		2.580025994509630e+01,		2.589849583988851e+01,		2.599653305832320e+01,
		2.609437224568086e+01,		2.619201404495322e+01,		2.628945909684566e+01,		2.638670803977996e+01,		2.648376150989708e+01,
		2.658062014106016e+01,		2.667728456485776e+01,		2.677375541060713e+01,		2.687003330535769e+01,		2.696611887389470e+01,
		2.706201273874298e+01,		2.715771552017081e+01,		2.725322783619408e+01,		2.734855030258032e+01,		2.744368353285306e+01,
		2.753862813829630e+01,		2.763338472795897e+01,		2.772795390865962e+01,		2.782233628499123e+01,		2.791653245932595e+01,
		2.801054303182024e+01,		2.810436860041983e+01,		2.819800976086492e+01,		2.829146710669548e+01,		2.838474122925656e+01,
		2.847783271770372e+01,		2.857074215900862e+01,		2.866347013796456e+01,		2.875601723719223e+01,		2.884838403714538e+01,
		2.894057111611674e+01,		2.903257905024380e+01,		2.912440841351492e+01,		2.921605977777529e+01,		2.930753371273293e+01,
		2.939883078596502e+01,		2.948995156292395e+01,		2.958089660694365e+01,		2.967166647924590e+01,		2.976226173894664e+01,
		2.985268294306243e+01,		2.994293064651687e+01,		3.003300540214711e+01,		3.012290776071037e+01,		3.021263827089052e+01,
		3.030219747930466e+01,		3.039158593050984e+01,		3.048080416700964e+01,		3.056985272926096e+01,		3.065873215568071e+01,
		3.074744298265257e+01,		3.083598574453383e+01,		3.092436097366217e+01,		3.101256920036249e+01,		3.110061095295380e+01,
		3.118848675775610e+01,		3.127619713909720e+01,		3.136374261931978e+01,		3.145112371878822e+01,		3.153834095589553e+01,
		3.162539484707040e+01,		3.171228590678407e+01,		3.179901464755741e+01,		3.188558157996780e+01,		3.197198721265624e+01,
		3.205823205233430e+01,		3.214431660379111e+01,		3.223024136990040e+01,		3.231600685162760e+01,		3.240161354803669e+01,
		3.248706195629737e+01,		3.257235257169209e+01,		3.265748588762295e+01,		3.274246239561887e+01,		3.282728258534249e+01,
		3.291194694459734e+01,		3.299645595933470e+01,		3.308081011366072e+01,		3.316500988984343e+01,		3.324905576831964e+01,
		3.333294822770208e+01,		3.341668774478632e+01,		3.350027479455772e+01,		3.358370985019851e+01,		3.366699338309465e+01,
		3.375012586284285e+01,		3.383310775725749e+01,		3.391593953237759e+01,		3.399862165247370e+01,		3.408115458005483e+01,
		3.416353877587536e+01,		3.424577469894191e+01,		3.432786280652027e+01,		3.440980355414218e+01,		3.449159739561220e+01,
		3.457324478301467e+01,		3.465474616672032e+01,		3.473610199539322e+01,		3.481731271599756e+01,		3.489837877380435e+01,
		3.497930061239827e+01,		3.506007867368430e+01,		3.514071339789456e+01,		3.522120522359493e+01,		3.530155458769178e+01,
		3.538176192543860e+01,		3.546182767044277e+01,		3.554175225467196e+01,		3.562153610846104e+01,		3.570117966051842e+01,
		3.578068333793278e+01,		3.586004756617955e+01,		3.593927276912752e+01,		3.601835936904525e+01,		3.609730778660769e+01,
		3.617611844090258e+01,		3.625479174943692e+01,		3.633332812814343e+01,		3.641172799138693e+01,		3.648999175197076e+01,
		3.656811982114316e+01,		3.664611260860357e+01,		3.672397052250906e+01,		3.680169396948053e+01,		3.687928335460911e+01,
		3.695673908146232e+01,		3.703406155209034e+01,		3.711125116703232e+01,		3.718830832532248e+01,		3.726523342449632e+01,
		3.734202686059681e+01,		3.741868902818045e+01,		3.749522032032350e+01,		3.757162112862792e+01,		3.764789184322763e+01,
		3.772403285279430e+01,		3.780004454454365e+01,		3.787592730424124e+01,		3.795168151620856e+01,		3.802730756332893e+01,
		3.810280582705349e+01,		3.817817668740704e+01,		3.825342052299401e+01,		3.832853771100422e+01,		3.840352862721883e+01,
		3.847839364601609e+01,		3.855313314037716e+01,		3.862774748189192e+01,		3.870223704076461e+01,		3.877660218581971e+01,
		3.885084328450755e+01,		3.892496070290999e+01,		3.899895480574611e+01,		3.907282595637791e+01,		3.914657451681576e+01,
		3.922020084772418e+01,		3.929370530842726e+01,		3.936708825691434e+01,		3.944035004984544e+01,		3.951349104255679e+01,
		3.958651158906628e+01,		3.965941204207904e+01,		3.973219275299273e+01,		3.980485407190300e+01,		3.987739634760896e+01,
		3.994981992761841e+01,		4.002212515815333e+01,		4.009431238415508e+01,		4.016638194928981e+01,		4.023833419595367e+01,
		4.031016946527807e+01,		4.038188809713495e+01,		4.045349043014202e+01,		4.052497680166788e+01,		4.059634754783724e+01,
		4.066760300353602e+01,		4.073874350241658e+01,		4.080976937690271e+01,		4.088068095819482e+01,		4.095147857627488e+01,
		4.102216255991160e+01,		4.109273323666535e+01,		4.116319093289321e+01,		4.123353597375391e+01,		4.130376868321282e+01,
		4.137388938404688e+01,		4.144389839784952e+01,		4.151379604503552e+01,		4.158358264484593e+01,		4.165325851535286e+01,
		4.172282397346441e+01,		4.179227933492941e+01,		4.186162491434218e+01,		4.193086102514736e+01,		4.199998797964469e+01,
		4.206900608899362e+01,		4.213791566321815e+01,		4.220671701121140e+01,		4.227541044074043e+01,		4.234399625845067e+01,
		4.241247476987077e+01,		4.248084627941709e+01,		4.254911109039828e+01,		4.261726950501990e+01,		4.268532182438897e+01,
		4.275326834851843e+01,		4.282110937633174e+01,		4.288884520566728e+01,		4.295647613328293e+01,		4.302400245486039e+01,
		4.309142446500973e+01,		4.315874245727375e+01,		4.322595672413234e+01,		4.329306755700694e+01,		4.336007524626482e+01,
		4.342698008122346e+01,		4.349378235015487e+01,		4.356048234028979e+01,		4.362708033782216e+01,		4.369357662791325e+01,
		4.375997149469587e+01,		4.382626522127872e+01,		4.389245808975051e+01,		4.395855038118420e+01,		4.402454237564107e+01,
		4.409043435217500e+01,		4.415622658883655e+01,		4.422191936267706e+01,		4.428751294975276e+01,		4.435300762512887e+01,
		4.441840366288363e+01,		4.448370133611235e+01,		4.454890091693152e+01,		4.461400267648266e+01,		4.467900688493644e+01,
		4.474391381149665e+01,		4.480872372440407e+01,		4.487343689094050e+01,		4.493805357743266e+01,		4.500257404925608e+01,
		4.506699857083896e+01,		4.513132740566612e+01,		4.519556081628281e+01,		4.525969906429853e+01,		4.532374241039093e+01,
		4.538769111430951e+01,		4.545154543487948e+01,		4.551530563000552e+01,		4.557897195667552e+01,		4.564254467096433e+01,
		4.570602402803751e+01,		4.576941028215496e+01,		4.583270368667475e+01,		4.589590449405659e+01,		4.595901295586572e+01,
		4.602202932277634e+01,		4.608495384457542e+01,		4.614778677016620e+01,		4.621052834757182e+01,		4.627317882393884e+01,
		4.633573844554095e+01,		4.639820745778241e+01,		4.646058610520154e+01,		4.652287463147434e+01,		4.658507327941800e+01,
		4.664718229099429e+01,		4.670920190731305e+01,		4.677113236863579e+01,		4.683297391437894e+01,		4.689472678311740e+01,
		4.695639121258787e+01,		4.701796743969238e+01,		4.707945570050151e+01,		4.714085623025784e+01,		4.720216926337935e+01,
		4.726339503346264e+01,		4.732453377328640e+01,		4.738558571481458e+01,		4.744655108919979e+01,		4.750743012678647e+01,
		4.756822305711432e+01,		4.762893010892138e+01,		4.768955151014740e+01,		4.775008748793704e+01,		4.781053826864296e+01,
		4.787090407782917e+01,		4.793118514027417e+01,		4.799138167997406e+01,		4.805149392014576e+01,		4.811152208323014e+01
	},
	{
		7.767542231425789e-02,		2.329158796415276e-01,		3.878022171419665e-01,		5.423352967401762e-01,		6.965159635045970e-01,
		8.503450467991530e-01,		1.003823361381443e+00,		1.156951708449564e+00,		1.309730876639541e+00,		1.462161642975299e+00,
		1.614244773773015e+00,		1.765981025501624e+00,		1.917371145601183e+00,		2.068415873260752e+00,		2.219115940157359e+00,
		2.369472071157583e+00,		2.519484984983239e+00,		2.669155394842543e+00,		2.818484009028167e+00,		2.967471531483470e+00,
		3.116118662338193e+00,		3.264426098414815e+00,		3.412394533706783e+00,		3.560024659829733e+00,		3.707317166446795e+00,
		3.854272741669064e+00,		4.000892072432228e+00,		4.147175844850360e+00,		4.293124744547818e+00,		4.438739456970162e+00,
		4.584020667674977e+00,		4.728969062603457e+00,		4.873585328333570e+00,		5.017870152315597e+00,		5.161824223090800e+00,
		5.305448230493981e+00,		5.448742865840617e+00,		5.591708822099268e+00,		5.734346794049926e+00,		5.876657478428920e+00,
		6.018641574061035e+00,		6.160299781979366e+00,		6.301632805533557e+00,		6.442641350486921e+00,		6.583326125102976e+00,
		6.723687840221946e+00,		6.863727209327659e+00,		7.003444948605352e+00,		7.142841776990853e+00,		7.281918416211521e+00,
		7.420675590819425e+00,		7.559114028217123e+00,		7.697234458676471e+00,		7.835037615350795e+00,		7.972524234280818e+00,
		8.109695054394665e+00,		8.246550817502314e+00,		8.383092268284745e+00,		8.519320154278189e+00,		8.655235225853682e+00,
		8.790838236192243e+00,		8.926129941255978e+00,		9.061111099755310e+00,		9.195782473112622e+00,		9.330144825422545e+00,
		9.464198923409123e+00,		9.597945536380049e+00,		9.731385436178224e+00,		9.864519397130797e+00,		9.997348195995921e+00,
		1.012987261190736e+01,		1.026209342631715e+01,		1.039401142293650e+01,		1.052562738767506e+01,		1.065694210857870e+01,
		1.078795637576598e+01,		1.091867098136346e+01,		1.104908671943991e+01,		1.117920438593963e+01,		1.130902477861494e+01,
		1.143854869695799e+01,		1.156777694213198e+01,		1.169671031690187e+01,		1.182534962556480e+01,		1.195369567388004e+01,
		1.208174926899897e+01,		1.220951121939471e+01,		1.233698233479185e+01,		1.246416342609617e+01,		1.259105530532446e+01,
		1.271765878553452e+01,		1.284397468075531e+01,		1.297000380591758e+01,		1.309574697678460e+01,		1.322120500988345e+01,
		1.334637872243674e+01,		1.347126893229476e+01,		1.359587645786816e+01,		1.372020211806131e+01,		1.384424673220610e+01,
		1.396801111999655e+01,		1.409149610142399e+01,		1.421470249671296e+01,		1.433763112625790e+01,		1.446028281056048e+01,
		1.458265837016788e+01,		1.470475862561166e+01,		1.482658439734769e+01,		1.494813650569670e+01,		1.506941577078577e+01,
		1.519042301249076e+01,		1.531115905037950e+01,		1.543162470365592e+01,		1.555182079110511e+01,		1.567174813103921e+01,
		1.579140754124431e+01,		1.591079983892818e+01,		1.602992584066900e+01,		1.614878636236495e+01,		1.626738221918479e+01,
		1.638571422551934e+01,		1.650378319493388e+01,		1.662158994012153e+01,		1.673913527285750e+01,		1.685642000395431e+01,
		1.697344494321792e+01,		1.709021089940479e+01,		1.720671868017985e+01,		1.732296909207538e+01,		1.743896294045083e+01,
		1.755470102945348e+01,		1.767018416198004e+01,		1.778541313963919e+01,		1.790038876271485e+01,		1.801511183013046e+01,
		1.812958313941413e+01,		1.824380348666454e+01,		1.835777366651774e+01,		1.847149447211488e+01,		1.858496669507060e+01,
		1.869819112544243e+01,		1.881116855170080e+01,		1.892389976070007e+01,		1.903638553765014e+01,		1.914862666608900e+01,
		1.926062392785598e+01,		1.937237810306578e+01,		1.948388997008323e+01,		1.959516030549882e+01,		1.970618988410492e+01,
		1.981697947887275e+01,		1.992752986093006e+01,		2.003784179953952e+01,		2.014791606207767e+01,		2.025775341401473e+01,
		2.036735461889496e+01,		2.047672043831773e+01,		2.058585163191908e+01,		2.069474895735420e+01,		2.080341317028019e+01,
		2.091184502433973e+01,		2.102004527114513e+01,		2.112801466026307e+01,		2.123575393919989e+01,		2.134326385338745e+01,
		2.145054514616956e+01,		2.155759855878891e+01,		2.166442483037458e+01,		2.177102469793002e+01,		2.187739889632164e+01,
		2.198354815826776e+01,		2.208947321432818e+01,		2.219517479289417e+01,		2.230065362017895e+01,		2.240591042020860e+01,
		2.251094591481349e+01,		2.261576082362012e+01,		2.272035586404331e+01,		2.282473175127897e+01,		2.292888919829722e+01,
		2.303282891583583e+01,		2.313655161239418e+01,		2.324005799422757e+01,		2.334334876534188e+01,		2.344642462748862e+01,
		2.354928628016035e+01,		2.365193442058648e+01,		2.375436974372932e+01,		2.385659294228060e+01,		2.395860470665822e+01,
		2.406040572500337e+01,		2.416199668317793e+01,		2.426337826476222e+01,		2.436455115105304e+01,		2.446551602106196e+01,
		2.456627355151394e+01,		2.466682441684621e+01,		2.476716928920743e+01,		2.486730883845711e+01,		2.496724373216528e+01,
		2.506697463561241e+01,		2.516650221178962e+01,		2.526582712139904e+01,		2.536495002285445e+01,		2.546387157228222e+01,
		2.556259242352231e+01,		2.566111322812960e+01,		2.575943463537544e+01,		2.585755729224929e+01,		2.595548184346066e+01,
		2.605320893144123e+01,		2.615073919634710e+01,		2.624807327606127e+01,		2.634521180619625e+01,		2.644215542009694e+01,
		2.653890474884355e+01,		2.663546042125472e+01,		2.673182306389086e+01,		2.682799330105759e+01,		2.692397175480927e+01,
		2.701975904495284e+01,		2.711535578905158e+01,		2.721076260242918e+01,		2.730598009817383e+01,		2.740100888714257e+01,
		2.749584957796553e+01,		2.759050277705055e+01,		2.768496908858775e+01,		2.777924911455420e+01,		2.787334345471889e+01,
		2.796725270664749e+01,		2.806097746570747e+01,		2.815451832507327e+01,		2.824787587573143e+01,		2.834105070648594e+01,
		2.843404340396365e+01,		2.852685455261971e+01,		2.861948473474318e+01,		2.871193453046264e+01,		2.880420451775186e+01,
		2.889629527243568e+01,		2.898820736819575e+01,		2.907994137657655e+01,		2.917149786699126e+01,		2.926287740672791e+01,
		2.935408056095545e+01,		2.944510789272983e+01,		2.953595996300030e+01,		2.962663733061565e+01,		2.971714055233050e+01,
		2.980747018281167e+01,		2.989762677464457e+01,		2.998761087833965e+01,		3.007742304233892e+01,		3.016706381302241e+01,
		3.025653373471478e+01,		3.034583334969189e+01,		3.043496319818744e+01,		3.052392381839962e+01,		3.061271574649782e+01,
		3.070133951662933e+01,		3.078979566092607e+01,		3.087808470951138e+01,		3.096620719050683e+01,		3.105416363003895e+01,
		3.114195455224618e+01,		3.122958047928559e+01,		3.131704193133989e+01,		3.140433942662419e+01,		3.149147348139295e+01,
		3.157844460994689e+01,		3.166525332463992e+01,		3.175190013588607e+01,		3.183838555216640e+01,		3.192471008003599e+01,
		3.201087422413091e+01,		3.209687848717514e+01,		3.218272336998754e+01,		3.226840937148890e+01,		3.235393698870882e+01,
		3.243930671679276e+01,		3.252451904900895e+01,		3.260957447675548e+01,		3.269447348956714e+01,		3.277921657512253e+01,
		3.286380421925094e+01,		3.294823690593941e+01,		3.303251511733960e+01,		3.311663933377484e+01,		3.320061003374705e+01,
		3.328442769394366e+01,		3.336809278924467e+01,		3.345160579272947e+01,		3.353496717568384e+01,		3.361817740760682e+01,
		3.370123695621766e+01,		3.378414628746276e+01,		3.386690586552248e+01,		3.394951615281808e+01,		3.403197761001856e+01,
		3.411429069604753e+01,		3.419645586809010e+01,		3.427847358159964e+01,		3.436034429030463e+01,		3.444206844621549e+01,
		3.452364649963134e+01,		3.460507889914675e+01,		3.468636609165863e+01,		3.476750852237282e+01,		3.484850663481092e+01,
		3.492936087081693e+01,		3.501007167056407e+01,		3.509063947256129e+01,		3.517106471366009e+01,		3.525134782906108e+01,
		3.533148925232067e+01,		3.541148941535759e+01,		3.549134874845957e+01,		3.557106768028990e+01,		3.565064663789391e+01,
		3.573008604670560e+01,		3.580938633055413e+01,		3.588854791167032e+01,		3.596757121069303e+01,		3.604645664667581e+01,
		3.612520463709320e+01,		3.620381559784714e+01,		3.628228994327345e+01,		3.636062808614815e+01,		3.643883043769382e+01,
		3.651689740758599e+01,		3.659482940395937e+01,		3.667262683341418e+01,		3.675029010102244e+01,		3.682781961033423e+01,
		3.690521576338383e+01,		3.698247896069607e+01,		3.705960960129239e+01,		3.713660808269707e+01,		3.721347480094334e+01,
		3.729021015057951e+01,		3.736681452467510e+01,		3.744328831482689e+01,		3.751963191116496e+01,		3.759584570235871e+01,
		3.767193007562292e+01,		3.774788541672374e+01,		3.782371210998458e+01,		3.789941053829212e+01,		3.797498108310218e+01,
		3.805042412444572e+01,		3.812574004093459e+01,		3.820092920976740e+01,		3.827599200673548e+01,		3.835092880622853e+01,
		3.842573998124047e+01,		3.850042590337522e+01,		3.857498694285243e+01,		3.864942346851314e+01,		3.872373584782561e+01,
		3.879792444689085e+01,		3.887198963044830e+01,		3.894593176188157e+01,		3.901975120322390e+01,		3.909344831516383e+01,
		3.916702345705070e+01,		3.924047698690028e+01,		3.931380926140016e+01,		3.938702063591541e+01,		3.946011146449381e+01,
		3.953308209987156e+01,		3.960593289347857e+01,		3.967866419544386e+01,		3.975127635460090e+01,		3.982376971849317e+01,
		3.989614463337926e+01,		3.996840144423835e+01,		4.004054049477533e+01,		4.011256212742633e+01,		4.018446668336374e+01,
		4.025625450250151e+01,		4.032792592350041e+01,		4.039948128377314e+01,		4.047092091948956e+01,		4.054224516558173e+01,
		4.061345435574915e+01,		4.068454882246380e+01,		4.075552889697519e+01,		4.082639490931545e+01,		4.089714718830441e+01,
		4.096778606155446e+01,		4.103831185547573e+01,		4.110872489528095e+01,		4.117902550499038e+01,		4.124921400743683e+01,
		4.131929072427048e+01,		4.138925597596383e+01,		4.145911008181654e+01,		4.152885335996022e+01,		4.159848612736333e+01,
		4.166800869983600e+01,		4.173742139203475e+01,		4.180672451746724e+01,		4.187591838849706e+01,		4.194500331634848e+01,
		4.201397961111103e+01,		4.208284758174434e+01,		4.215160753608266e+01,		4.222025978083960e+01,		4.228880462161266e+01,
		4.235724236288795e+01,		4.242557330804467e+01,		4.249379775935968e+01,		4.256191601801212e+01,		4.262992838408785e+01,
		4.269783515658398e+01,		4.276563663341334e+01,		4.283333311140898e+01,		4.290092488632862e+01,		4.296841225285898e+01,
		4.303579550462032e+01,		4.310307493417075e+01,		4.317025083301053e+01,		4.323732349158661e+01,		4.330429319929682e+01,
		4.337116024449416e+01,		4.343792491449116e+01,		4.350458749556421e+01,		4.357114827295764e+01,		4.363760753088812e+01,
		4.370396555254879e+01,		4.377022262011356e+01,		4.383637901474112e+01,		4.390243501657925e+01,		4.396839090476899e+01,
		4.403424695744856e+01,		4.410000345175774e+01,		4.416566066384176e+01,		4.423121886885546e+01,		4.429667834096737e+01,
		4.436203935336368e+01,		4.442730217825226e+01,		4.449246708686679e+01,		4.455753434947056e+01,		4.462250423536061e+01,
		4.468737701287156e+01,		4.475215294937958e+01,		4.481683231130639e+01,		4.488141536412304e+01,		4.494590237235379e+01,
		4.501029359958014e+01,		4.507458930844452e+01,		4.513878976065411e+01,		4.520289521698486e+01,		4.526690593728504e+01,
		4.533082218047914e+01,		4.539464420457166e+01,		4.545837226665088e+01,		4.552200662289244e+01,		4.558554752856321e+01,
		4.564899523802498e+01,		4.571235000473806e+01,		4.577561208126504e+01,		4.583878171927437e+01,		4.590185916954403e+01,
		4.596484468196522e+01,		4.602773850554581e+01,		4.609054088841408e+01,		4.615325207782223e+01,		4.621587232014991e+01,
		4.627840186090782e+01,		4.634084094474125e+01,		4.640318981543354e+01,		4.646544871590957e+01,		4.652761788823928e+01,
		4.658969757364117e+01,		4.665168801248569e+01,		4.671358944429866e+01,		4.677540210776479e+01,		4.683712624073100e+01,
		4.689876208020983e+01,		4.696030986238289e+01,		4.702176982260408e+01,		4.708314219540306e+01,		4.714442721448857e+01,
		4.720562511275172e+01,		4.726673612226924e+01,		4.732776047430693e+01,		4.738869839932277e+01,		4.744955012697027e+01,
		4.751031588610168e+01,		4.757099590477134e+01,		4.763159041023864e+01,		4.769209962897154e+01,		4.775252378664953e+01,
		4.781286310816694e+01,		4.787311781763600e+01,		4.793328813839010e+01,		4.799337429298684e+01,		4.805337650321123e+01
	},
	{
		7.752562029361568e-02,		2.324670120060823e-01,		3.870554015608664e-01,		5.412916499513095e-01,		6.951766014431899e-01,
		8.487110847132824e-01,		1.001895913935149e+00,		1.154731889814227e+00,		1.307219800574150e+00,		1.459360422896226e+00,
		1.611154522813868e+00,		1.762602856563734e+00,		1.913706171395258e+00,		2.064465206340210e+00,		2.214880692943823e+00,
		2.364953355959005e+00,		2.514683914005093e+00,		2.664073080192532e+00,		2.813121562714826e+00,		2.961830065409081e+00,
		3.110199288286357e+00,		3.258229928033064e+00,		3.405922678484563e+00,		3.553278231072067e+00,		3.700297275243965e+00,
		3.846980498862584e+00,		3.993328588577409e+00,		4.139342230175720e+00,		4.285022108911604e+00,		4.430368909814229e+00,
		4.575383317976249e+00,		4.720066018823210e+00,		4.864417698364718e+00,		5.008439043428210e+00,		5.152130741876039e+00,
		5.295493482806618e+00,		5.438527956740310e+00,		5.581234855790792e+00,		5.723614873822459e+00,		5.865668706594576e+00,
		6.007397051892751e+00,		6.148800609648297e+00,		6.289880082046087e+00,		6.430636173621415e+00,		6.571069591346373e+00,
		6.711181044706319e+00,		6.850971245766803e+00,		6.990440909231530e+00,		7.129590752491757e+00,		7.268421495667544e+00,
		7.406933861641317e+00,		7.545128576084093e+00,		7.683006367474810e+00,		7.820567967113069e+00,		7.957814109125713e+00,
		8.094745530467499e+00,		8.231362970916296e+00,		8.367667173063019e+00,		8.503658882296680e+00,		8.639338846784815e+00,
		8.774707817449562e+00,		8.909766547939668e+00,		9.044515794598691e+00,		9.178956316429606e+00,		9.313088875056106e+00,
		9.446914234680778e+00,		9.580433162040380e+00,		9.713646426358455e+00,		9.846554799295442e+00,		9.979159054896495e+00,
		1.011145996953719e+01,		1.024345832186728e+01,		1.037515489275269e+01,		1.050655046521588e+01,		1.063764582437476e+01,
		1.076844175738024e+01,		1.089893905335265e+01,		1.102913850331706e+01,		1.115904090013770e+01,		1.128864703845156e+01,
		1.141795771460124e+01,		1.154697372656732e+01,		1.167569587390014e+01,		1.180412495765123e+01,		1.193226178030442e+01,
		1.206010714570674e+01,		1.218766185899924e+01,		1.231492672654763e+01,		1.244190255587310e+01,		1.256859015558308e+01,
		1.269499033530228e+01,		1.282110390560385e+01,		1.294693167794086e+01,		1.307247446457811e+01,		1.319773307852432e+01,
		1.332270833346473e+01,		1.344740104369421e+01,		1.357181202405085e+01,		1.369594208985013e+01,		1.381979205681967e+01,
		1.394336274103462e+01,		1.406665495885372e+01,		1.418966952685599e+01,		1.431240726177824e+01,		1.443486898045322e+01,
		1.455705549974856e+01,		1.467896763650656e+01,		1.480060620748471e+01,		1.492197202929704e+01,		1.504306591835634e+01,
		1.516388869081723e+01,		1.528444116252002e+01,		1.540472414893559e+01,		1.552473846511099e+01,		1.564448492561603e+01,
		1.576396434449080e+01,		1.588317753519396e+01,		1.600212531055207e+01,		1.612080848270979e+01,		1.623922786308097e+01,
		1.635738426230070e+01,		1.647527849017826e+01,		1.659291135565095e+01,		1.671028366673892e+01,		1.682739623050083e+01,
		1.694424985299047e+01,		1.706084533921429e+01,		1.717718349308980e+01,		1.729326511740491e+01,		1.740909101377815e+01,
		1.752466198261978e+01,		1.763997882309375e+01,		1.775504233308063e+01,		1.786985330914128e+01,		1.798441254648151e+01,
		1.809872083891750e+01,		1.821277897884214e+01,		1.832658775719212e+01,		1.844014796341597e+01,		1.855346038544279e+01,
		1.866652580965190e+01,		1.877934502084320e+01,		1.889191880220844e+01,		1.900424793530312e+01,		1.911633320001929e+01,
		1.922817537455905e+01,		1.933977523540887e+01,		1.945113355731447e+01,		1.956225111325671e+01,		1.967312867442795e+01,
		1.978376701020926e+01,		1.989416688814827e+01,		2.000432907393775e+01,		2.011425433139481e+01,		2.022394342244084e+01,
		2.033339710708203e+01,		2.044261614339059e+01,		2.055160128748657e+01,		2.066035329352035e+01,		2.076887291365567e+01,
		2.087716089805331e+01,		2.098521799485540e+01,		2.109304495017017e+01,		2.120064250805747e+01,		2.130801141051466e+01,
		2.141515239746316e+01,		2.152206620673552e+01,		2.162875357406298e+01,		2.173521523306360e+01,		2.184145191523086e+01,
		2.194746434992277e+01,		2.205325326435146e+01,		2.215881938357329e+01,		2.226416343047933e+01,		2.236928612578643e+01,
		2.247418818802863e+01,		2.257887033354902e+01,		2.268333327649217e+01,		2.278757772879675e+01,		2.289160440018873e+01,
		2.299541399817494e+01,		2.309900722803706e+01,		2.320238479282585e+01,		2.330554739335595e+01,		2.340849572820095e+01,
		2.351123049368875e+01,		2.361375238389749e+01,		2.371606209065154e+01,		2.381816030351809e+01,		2.392004770980384e+01,
		2.402172499455220e+01,		2.412319284054069e+01,		2.422445192827866e+01,		2.432550293600534e+01,		2.442634653968815e+01,
		2.452698341302131e+01,		2.462741422742471e+01,		2.472763965204309e+01,		2.482766035374540e+01,		2.492747699712451e+01,
		2.502709024449711e+01,		2.512650075590385e+01,		2.522570918910978e+01,		2.532471619960490e+01,		2.542352244060513e+01,
		2.552212856305322e+01,		2.562053521562017e+01,		2.571874304470661e+01,		2.581675269444458e+01,		2.591456480669932e+01,
		2.601218002107138e+01,		2.610959897489894e+01,		2.620682230326010e+01,		2.630385063897564e+01,		2.640068461261170e+01,
		2.649732485248279e+01,		2.659377198465482e+01,		2.669002663294843e+01,		2.678608941894234e+01,		2.688196096197697e+01,
		2.697764187915804e+01,		2.707313278536053e+01,		2.716843429323253e+01,		2.726354701319940e+01,		2.735847155346797e+01,
		2.745320852003086e+01,		2.754775851667102e+01,		2.764212214496618e+01,		2.773630000429362e+01,		2.783029269183494e+01,
		2.792410080258092e+01,		2.801772492933653e+01,		2.811116566272600e+01,		2.820442359119805e+01,		2.829749930103106e+01,
		2.839039337633850e+01,		2.848310639907433e+01,		2.857563894903850e+01,		2.866799160388260e+01,		2.876016493911545e+01,
		2.885215952810888e+01,		2.894397594210355e+01,		2.903561475021474e+01,		2.912707651943840e+01,		2.921836181465703e+01,
		2.930947119864584e+01,		2.940040523207876e+01,		2.949116447353469e+01,		2.958174947950362e+01,		2.967216080439297e+01,
		2.976239900053389e+01,		2.985246461818755e+01,		2.994235820555164e+01,		3.003208030876668e+01,		3.012163147192264e+01,
		3.021101223706533e+01,		3.030022314420300e+01,		3.038926473131292e+01,		3.047813753434798e+01,		3.056684208724337e+01,
		3.065537892192315e+01,		3.074374856830707e+01,		3.083195155431720e+01,		3.091998840588471e+01,		3.100785964695661e+01,
		3.109556579950261e+01,		3.118310738352174e+01,		3.127048491704943e+01,		3.135769891616410e+01,		3.144474989499419e+01,
		3.153163836572491e+01,		3.161836483860516e+01,		3.170492982195443e+01,		3.179133382216966e+01,		3.187757734373217e+01,
		3.196366088921455e+01,		3.204958495928760e+01,		3.213535005272727e+01,		3.222095666642151e+01,		3.230640529537729e+01,
		3.239169643272748e+01,		3.247683056973779e+01,		3.256180819581375e+01,		3.264662979850756e+01,		3.273129586352510e+01,
		3.281580687473283e+01,		3.290016331416468e+01,		3.298436566202907e+01,		3.306841439671575e+01,		3.315230999480271e+01,
		3.323605293106314e+01,		3.331964367847232e+01,		3.340308270821449e+01,		3.348637048968972e+01,		3.356950749052083e+01,
		3.365249417656029e+01,		3.373533101189698e+01,		3.381801845886312e+01,		3.390055697804108e+01,		3.398294702827023e+01,
		3.406518906665369e+01,		3.414728354856523e+01,		3.422923092765597e+01,		3.431103165586123e+01,		3.439268618340725e+01,
		3.447419495881792e+01,		3.455555842892158e+01,		3.463677703885771e+01,		3.471785123208361e+01,		3.479878145038110e+01,
		3.487956813386324e+01,		3.496021172098092e+01,		3.504071264852953e+01,		3.512107135165558e+01,		3.520128826386334e+01,
		3.528136381702134e+01,		3.536129844136905e+01,		3.544109256552336e+01,		3.552074661648511e+01,		3.560026101964566e+01,
		3.567963619879334e+01,		3.575887257611994e+01,		3.583797057222718e+01,		3.591693060613315e+01,		3.599575309527867e+01,
		3.607443845553377e+01,		3.615298710120405e+01,		3.623139944503701e+01,		3.630967589822836e+01,		3.638781687042847e+01,
		3.646582276974848e+01,		3.654369400276676e+01,		3.662143097453501e+01,		3.669903408858459e+01,		3.677650374693270e+01,
		3.685384035008861e+01,		3.693104429705973e+01,		3.700811598535792e+01,		3.708505581100543e+01,		3.716186416854113e+01,
		3.723854145102658e+01,		3.731508805005208e+01,		3.739150435574266e+01,		3.746779075676419e+01,		3.754394764032929e+01,
		3.761997539220334e+01,		3.769587439671049e+01,		3.777164503673949e+01,		3.784728769374959e+01,		3.792280274777657e+01,
		3.799819057743846e+01,		3.807345155994140e+01,		3.814858607108555e+01,		3.822359448527076e+01,		3.829847717550248e+01,
		3.837323451339730e+01,		3.844786686918898e+01,		3.852237461173388e+01,		3.859675810851682e+01,		3.867101772565658e+01,
		3.874515382791174e+01,		3.881916677868617e+01,		3.889305694003460e+01,		3.896682467266827e+01,		3.904047033596046e+01,
		3.911399428795198e+01,		3.918739688535670e+01,		3.926067848356709e+01,		3.933383943665957e+01,		3.940688009739997e+01,
		3.947980081724909e+01,		3.955260194636789e+01,		3.962528383362304e+01,		3.969784682659210e+01,		3.977029127156896e+01,
		3.984261751356918e+01,		3.991482589633517e+01,		3.998691676234149e+01,		4.005889045280014e+01,		4.013074730766567e+01,
		4.020248766564053e+01,		4.027411186418013e+01,		4.034562023949799e+01,		4.041701312657096e+01,		4.048829085914426e+01,
		4.055945376973655e+01,		4.063050218964513e+01,		4.070143644895079e+01,		4.077225687652301e+01,		4.084296380002485e+01,
		4.091355754591803e+01,		4.098403843946775e+01,		4.105440680474780e+01,		4.112466296464537e+01,		4.119480724086598e+01,
		4.126483995393833e+01,		4.133476142321922e+01,		4.140457196689835e+01,		4.147427190200310e+01,		4.154386154440339e+01,
		4.161334120881642e+01,		4.168271120881145e+01,		4.175197185681448e+01,		4.182112346411304e+01,		4.189016634086078e+01,
		4.195910079608228e+01,		4.202792713767758e+01,		4.209664567242688e+01,		4.216525670599518e+01,		4.223376054293675e+01,
		4.230215748669983e+01,		4.237044783963117e+01,		4.243863190298043e+01,		4.250670997690496e+01,		4.257468236047398e+01,
		4.264254935167332e+01,		4.271031124740971e+01,		4.277796834351526e+01,		4.284552093475197e+01,		4.291296931481599e+01,
		4.298031377634208e+01,		4.304755461090797e+01,		4.311469210903865e+01,		4.318172656021079e+01,		4.324865825285693e+01,
		4.331548747436987e+01,		4.338221451110684e+01,		4.344883964839381e+01,		4.351536317052977e+01,		4.358178536079084e+01,
		4.364810650143446e+01,		4.371432687370367e+01,		4.378044675783123e+01,		4.384646643304366e+01,		4.391238617756554e+01,
		4.397820626862342e+01,		4.404392698245007e+01,		4.410954859428848e+01,		4.417507137839583e+01,		4.424049560804769e+01,
		4.430582155554192e+01,		4.437104949220270e+01,		4.443617968838451e+01,		4.450121241347608e+01,		4.456614793590433e+01,
		4.463098652313833e+01,		4.469572844169326e+01,		4.476037395713414e+01,		4.482492333407990e+01,		4.488937683620705e+01,
		4.495373472625375e+01,		4.501799726602339e+01,		4.508216471638864e+01,		4.514623733729503e+01,		4.521021538776490e+01,
		4.527409912590103e+01,		4.533788880889048e+01,		4.540158469300825e+01,		4.546518703362106e+01,		4.552869608519099e+01,
		4.559211210127919e+01,		4.565543533454952e+01,		4.571866603677222e+01,		4.578180445882752e+01,		4.584485085070934e+01,
		4.590780546152870e+01,		4.597066853951756e+01,		4.603344033203217e+01,		4.609612108555675e+01,		4.615871104570697e+01,
		4.622121045723348e+01,		4.628361956402551e+01,		4.634593860911421e+01,		4.640816783467620e+01,		4.647030748203708e+01,
		4.653235779167482e+01,		4.659431900322318e+01,		4.665619135547517e+01,		4.671797508638643e+01,		4.677967043307866e+01,
		4.684127763184289e+01,		4.690279691814291e+01,		4.696422852661871e+01,		4.702557269108957e+01,		4.708682964455761e+01,
		4.714799961921095e+01,		4.720908284642706e+01,		4.727007955677597e+01,		4.733098998002364e+01,		4.739181434513507e+01,
		4.745255288027764e+01,		4.751320581282423e+01,		4.757377336935652e+01,		4.763425577566807e+01,		4.769465325676764e+01,
		4.775496603688215e+01,		4.781519433946001e+01,		4.787533838717418e+01,		4.793539840192524e+01,		4.799537460484464e+01
	},
	{
		7.737639514067347e-02,		2.320198726884204e-01,		3.863114611378445e-01,		5.402520205260108e-01,		6.938423942897172e-01,
		8.470834103911361e-01,		9.999758823913767e-01,		1.152520610473984e+00,		1.304718382420305e+00,		1.456569974538605e+00,
		1.608076152548699e+00,		1.759237672423853e+00,		1.910055281191598e+00,		2.060529717695064e+00,		2.210661713316372e+00,
		2.360451992663572e+00,		2.509901274222543e+00,		2.659010270975269e+00,		2.807779690985762e+00,		2.956210237954977e+00,
		3.104302611745898e+00,		3.252057508880025e+00,		3.399475623006385e+00,		3.546557645344193e+00,		3.693304265100213e+00,
		3.839716169861864e+00,		3.985794045967062e+00,		4.131538578851743e+00,		4.276950453376013e+00,		4.422030354129801e+00,
		4.566778965718883e+00,		4.711196973032101e+00,		4.855285061490600e+00,		4.999043917279800e+00,		5.142474227564926e+00,
		5.285576680690749e+00,		5.428351966366259e+00,		5.570800775834946e+00,		5.712923802031307e+00,		5.854721739724212e+00,
		5.996195285647760e+00,		6.137345138620132e+00,		6.278171999651063e+00,		6.418676572038430e+00,		6.558859561454499e+00,
		6.698721676022296e+00,		6.838263626382612e+00,		6.977486125752077e+00,		7.116389889972777e+00,		7.254975637553806e+00,
		7.393244089705187e+00,		7.531195970364555e+00,		7.668832006216964e+00,		7.806152926708231e+00,		7.943159464052099e+00,
		8.079852353231603e+00,		8.216232331994979e+00,		8.352300140846367e+00,		8.488056523031668e+00,		8.623502224519806e+00,
		8.758637993979701e+00,		8.893464582753154e+00,		9.027982744824012e+00,		9.162193236783718e+00,		9.296096817793609e+00,
		9.429694249544077e+00,		9.562986296210887e+00,		9.695973724408812e+00,		9.828657303142803e+00,		9.961037803756867e+00,
		1.009311599988083e+01,		1.022489266737519e+01,		1.035636858427418e+01,		1.048754453072725e+01,		1.061842128893898e+01,
		1.074899964310787e+01,		1.087928037936368e+01,		1.100926428570400e+01,		1.113895215192960e+01,		1.126834476957925e+01,
		1.139744293186356e+01,		1.152624743359845e+01,		1.165475907113798e+01,		1.178297864230686e+01,		1.191090694633256e+01,
		1.203854478377732e+01,		1.216589295646990e+01,		1.229295226743735e+01,		1.241972352083674e+01,		1.254620752188696e+01,
		1.267240507680071e+01,		1.279831699271668e+01,		1.292394407763195e+01,		1.304928714033472e+01,		1.317434699033748e+01,
		1.329912443781049e+01,		1.342362029351579e+01,		1.354783536874169e+01,		1.367177047523776e+01,		1.379542642515055e+01,
		1.391880403095970e+01,		1.404190410541487e+01,		1.416472746147325e+01,		1.428727491223783e+01,		1.440954727089637e+01,
		1.453154535066109e+01,		1.465326996470919e+01,		1.477472192612411e+01,		1.489590204783762e+01,		1.501681114257267e+01,
		1.513745002278724e+01,		1.525781950061883e+01,		1.537792038782996e+01,		1.549775349575446e+01,		1.561731963524469e+01,
		1.573661961661957e+01,		1.585565424961363e+01,		1.597442434332680e+01,		1.609293070617521e+01,		1.621117414584285e+01,
		1.632915546923411e+01,		1.644687548242732e+01,		1.656433499062905e+01,		1.668153479812941e+01,		1.679847570825830e+01,
		1.691515852334238e+01,		1.703158404466312e+01,		1.714775307241564e+01,		1.726366640566847e+01,		1.737932484232420e+01,
		1.749472917908099e+01,		1.760988021139494e+01,		1.772477873344336e+01,		1.783942553808890e+01,		1.795382141684448e+01,
		1.806796715983913e+01,		1.818186355578459e+01,		1.829551139194281e+01,		1.840891145409427e+01,		1.852206452650701e+01,
		1.863497139190661e+01,		1.874763283144680e+01,		1.886004962468100e+01,		1.897222254953456e+01,		1.908415238227775e+01,
		1.919583989749954e+01,		1.930728586808209e+01,		1.941849106517606e+01,		1.952945625817645e+01,		1.964018221469939e+01,
		1.975066970055946e+01,		1.986091947974777e+01,		1.997093231441072e+01,		2.008070896482937e+01,		2.019025018939961e+01,
		2.029955674461278e+01,		2.040862938503711e+01,		2.051746886329968e+01,		2.062607593006900e+01,		2.073445133403830e+01,
		2.084259582190926e+01,		2.095051013837643e+01,		2.105819502611222e+01,		2.116565122575240e+01,		2.127287947588218e+01,
		2.137988051302289e+01,		2.148665507161908e+01,		2.159320388402622e+01,		2.169952768049891e+01,		2.180562718917958e+01,
		2.191150313608767e+01,		2.201715624510928e+01,		2.212258723798741e+01,		2.222779683431240e+01,		2.233278575151321e+01,
		2.243755470484873e+01,		2.254210440739989e+01,		2.264643557006191e+01,		2.275054890153714e+01,		2.285444510832827e+01,
		2.295812489473189e+01,		2.306158896283248e+01,		2.316483801249685e+01,		2.326787274136877e+01,		2.337069384486412e+01,
		2.347330201616639e+01,		2.357569794622249e+01,		2.367788232373881e+01,		2.377985583517785e+01,		2.388161916475489e+01,
		2.398317299443521e+01,		2.408451800393148e+01,		2.418565487070154e+01,		2.428658426994637e+01,		2.438730687460847e+01,
		2.448782335537047e+01,		2.458813438065394e+01,		2.468824061661859e+01,		2.478814272716164e+01,		2.488784137391754e+01,
		2.498733721625774e+01,		2.508663091129102e+01,		2.518572311386370e+01,		2.528461447656034e+01,		2.538330564970455e+01,
		2.548179728136005e+01,		2.558009001733188e+01,		2.567818450116793e+01,		2.577608137416054e+01,		2.587378127534843e+01,
		2.597128484151864e+01,		2.606859270720886e+01,		2.616570550470978e+01,		2.626262386406770e+01,		2.635934841308724e+01,
		2.645587977733426e+01,		2.655221858013901e+01,		2.664836544259925e+01,		2.674432098358363e+01,		2.684008581973530e+01,
		2.693566056547550e+01,		2.703104583300734e+01,		2.712624223231980e+01,		2.722125037119170e+01,		2.731607085519596e+01,
		2.741070428770385e+01,		2.750515126988942e+01,		2.759941240073405e+01,		2.769348827703106e+01,		2.778737949339047e+01,
		2.788108664224385e+01,		2.797461031384926e+01,		2.806795109629628e+01,		2.816110957551117e+01,		2.825408633526206e+01,
		2.834688195716426e+01,		2.843949702068566e+01,		2.853193210315224e+01,		2.862418777975350e+01,		2.871626462354822e+01,
		2.880816320547006e+01,		2.889988409433328e+01,		2.899142785683872e+01,		2.908279505757952e+01,		2.917398625904718e+01,
		2.926500202163750e+01,		2.935584290365667e+01,		2.944650946132739e+01,		2.953700224879500e+01,		2.962732181813376e+01,
		2.971746871935305e+01,		2.980744350040370e+01,		2.989724670718435e+01,		2.998687888354781e+01,		3.007634057130751e+01,
		3.016563231024395e+01,		3.025475463811126e+01,		3.034370809064361e+01,		3.043249320156188e+01,		3.052111050258021e+01,
		3.060956052341264e+01,		3.069784379177973e+01,		3.078596083341526e+01,		3.087391217207289e+01,		3.096169832953292e+01,
		3.104931982560898e+01,		3.113677717815483e+01,		3.122407090307111e+01,		3.131120151431208e+01,		3.139816952389256e+01,
		3.148497544189458e+01,		3.157161977647430e+01,		3.165810303386887e+01,		3.174442571840321e+01,		3.183058833249688e+01,
		3.191659137667104e+01,		3.200243534955516e+01,		3.208812074789404e+01,		3.217364806655459e+01,		3.225901779853281e+01,
		3.234423043496056e+01,		3.242928646511258e+01,		3.251418637641324e+01,		3.259893065444357e+01,		3.268351978294801e+01,
		3.276795424384140e+01,		3.285223451721583e+01,		3.293636108134746e+01,		3.302033441270353e+01,		3.310415498594907e+01,
		3.318782327395387e+01,		3.327133974779930e+01,		3.335470487678519e+01,		3.343791912843664e+01,		3.352098296851085e+01,
		3.360389686100397e+01,		3.368666126815789e+01,		3.376927665046711e+01,		3.385174346668543e+01,		3.393406217383283e+01,
		3.401623322720216e+01,		3.409825708036599e+01,		3.418013418518331e+01,		3.426186499180621e+01,		3.434344994868674e+01,
		3.442488950258345e+01,		3.450618409856823e+01,		3.458733418003288e+01,		3.466834018869584e+01,		3.474920256460884e+01,
		3.482992174616346e+01,		3.491049817009784e+01,		3.499093227150318e+01,		3.507122448383038e+01,		3.515137523889668e+01,
		3.523138496689205e+01,		3.531125409638579e+01,		3.539098305433308e+01,		3.547057226608145e+01,		3.555002215537723e+01,
		3.562933314437204e+01,		3.570850565362920e+01,		3.578754010213015e+01,		3.586643690728091e+01,		3.594519648491836e+01,
		3.602381924931667e+01,		3.610230561319364e+01,		3.618065598771695e+01,		3.625887078251060e+01,		3.633695040566101e+01,
		3.641489526372342e+01,		3.649270576172807e+01,		3.657038230318642e+01,		3.664792529009738e+01,		3.672533512295341e+01,
		3.680261220074677e+01,		3.687975692097557e+01,		3.695676967964997e+01,		3.703365087129815e+01,		3.711040088897249e+01,
		3.718702012425558e+01,		3.726350896726622e+01,		3.733986780666545e+01,		3.741609702966254e+01,		3.749219702202092e+01,
		3.756816816806410e+01,		3.764401085068175e+01,		3.771972545133531e+01,		3.779531235006409e+01,		3.787077192549106e+01,
		3.794610455482864e+01,		3.802131061388453e+01,		3.809639047706750e+01,		3.817134451739317e+01,		3.824617310648971e+01,
		3.832087661460351e+01,		3.839545541060505e+01,		3.846990986199439e+01,		3.854424033490690e+01,		3.861844719411887e+01,
		3.869253080305316e+01,		3.876649152378472e+01,		3.884032971704617e+01,		3.891404574223336e+01,		3.898763995741088e+01,
		3.906111271931756e+01,		3.913446438337193e+01,		3.920769530367762e+01,		3.928080583302899e+01,		3.935379632291618e+01,
		3.942666712353087e+01,		3.949941858377142e+01,		3.957205105124828e+01,		3.964456487228927e+01,		3.971696039194490e+01,
		3.978923795399371e+01,		3.986139790094742e+01,		3.993344057405619e+01,		4.000536631331386e+01,		4.007717545746317e+01,
		4.014886834400077e+01,		4.022044530918256e+01,		4.029190668802873e+01,		4.036325281432882e+01,		4.043448402064683e+01,
		4.050560063832637e+01,		4.057660299749554e+01,		4.064749142707205e+01,		4.071826625476821e+01,		4.078892780709587e+01,
		4.085947640937139e+01,		4.092991238572056e+01,		4.100023605908358e+01,		4.107044775121985e+01,		4.114054778271288e+01,
		4.121053647297519e+01,		4.128041414025303e+01,		4.135018110163134e+01,		4.141983767303838e+01,		4.148938416925060e+01,
		4.155882090389736e+01,		4.162814818946563e+01,		4.169736633730476e+01,		4.176647565763108e+01,		4.183547645953264e+01,
		4.190436905097383e+01,		4.197315373880000e+01,		4.204183082874205e+01,		4.211040062542110e+01,		4.217886343235291e+01,
		4.224721955195256e+01,		4.231546928553897e+01,		4.238361293333927e+01,		4.245165079449347e+01,		4.251958316705882e+01,
		4.258741034801427e+01,		4.265513263326491e+01,		4.272275031764647e+01,		4.279026369492949e+01,		4.285767305782399e+01,
		4.292497869798355e+01,		4.299218090600984e+01,		4.305927997145680e+01,		4.312627618283503e+01,		4.319316982761608e+01,
		4.325996119223663e+01,		4.332665056210275e+01,		4.339323822159418e+01,		4.345972445406854e+01,		4.352610954186541e+01,
		4.359239376631063e+01,		4.365857740772039e+01,		4.372466074540529e+01,		4.379064405767465e+01,		4.385652762184040e+01,
		4.392231171422130e+01,		4.398799661014694e+01,		4.405358258396177e+01,		4.411906990902921e+01,		4.418445885773552e+01,
		4.424974970149398e+01,		4.431494271074870e+01,		4.438003815497859e+01,		4.444503630270147e+01,		4.450993742147778e+01,
		4.457474177791457e+01,		4.463944963766946e+01,		4.470406126545441e+01,		4.476857692503958e+01,		4.483299687925729e+01,
		4.489732139000567e+01,		4.496155071825260e+01,		4.502568512403941e+01,		4.508972486648472e+01,		4.515367020378815e+01,
		4.521752139323408e+01,		4.528127869119537e+01,		4.534494235313707e+01,		4.540851263362008e+01,		4.547198978630489e+01,
		4.553537406395515e+01,		4.559866571844143e+01,		4.566186500074471e+01,		4.572497216096012e+01,		4.578798744830043e+01,
		4.585091111109970e+01,		4.591374339681683e+01,		4.597648455203908e+01,		4.603913482248564e+01,		4.610169445301112e+01,
		4.616416368760906e+01,		4.622654276941547e+01,		4.628883194071218e+01,		4.635103144293042e+01,		4.641314151665421e+01,
		4.647516240162379e+01,		4.653709433673902e+01,		4.659893756006284e+01,		4.666069230882455e+01,		4.672235881942326e+01,
		4.678393732743119e+01,		4.684542806759710e+01,		4.690683127384949e+01,		4.696814717930002e+01,		4.702937601624669e+01,
		4.709051801617727e+01,		4.715157340977242e+01,		4.721254242690908e+01,		4.727342529666355e+01,		4.733422224731488e+01,
		4.739493350634793e+01,		4.745555930045676e+01,		4.751609985554756e+01,		4.757655539674207e+01,		4.763692614838049e+01,
		4.769721233402489e+01,		4.775741417646209e+01,		4.781753189770698e+01,		4.787756571900543e+01,		4.793751586083756e+01
	},
	{
		7.722774352856654e-02,		2.315744517157685e-01,		3.855703792739752e-01,		5.392163852594950e-01,		6.925133122543755e-01,
		8.454619874793041e-01,		9.980632238550976e-01,		1.150317821014767e+00,		1.302226566268073e+00,		1.453790235520406e+00,
		1.605009594147759e+00,		1.755885397829499e+00,		1.906418393340576e+00,		2.056609319304735e+00,		2.206458906910274e+00,
		2.355967880589783e+00,		2.505136958665306e+00,		2.653966853960255e+00,		2.802458274379405e+00,		2.950611923458233e+00,
		3.098428500882809e+00,		3.245908702981423e+00,		3.393053223189074e+00,		3.539862752485919e+00,		3.686337979810725e+00,
		3.832479592450369e+00,		3.978288276406320e+00,		4.123764716739091e+00,		4.268909597891553e+00,		4.413723603992004e+00,
		4.558207419137814e+00,		4.702361727660508e+00,		4.846187214373037e+00,		4.989684564800030e+00,		5.132854465391745e+00,
		5.275697603722416e+00,		5.418214668673726e+00,		5.560406350604014e+00,		5.702273341503870e+00,		5.843816335138754e+00,
		5.985036027179193e+00,		6.125933115319147e+00,		6.266508299383095e+00,		6.406762281422356e+00,		6.546695765801152e+00,
		6.686309459272953e+00,		6.825604071047481e+00,		6.964580312848931e+00,		7.103238898965782e+00,		7.241580546292639e+00,
		7.379605974364504e+00,		7.517315905383908e+00,		7.654711064241189e+00,		7.791792178528386e+00,		7.928559978547024e+00,
		8.065015197310130e+00,		8.201158570538851e+00,		8.336990836653888e+00,		8.472512736762180e+00,		8.607725014638959e+00,
		8.742628416705582e+00,		8.877223692003351e+00,		9.011511592163540e+00,		9.145492871373934e+00,		9.279168286342053e+00,
		9.412538596255345e+00,		9.545604562738468e+00,		9.678366949807973e+00,		9.810826523824481e+00,		9.942984053442625e+00,
		1.007484030955886e+01,		1.020639606525738e+01,		1.033765209575424e+01,		1.046860917833988e+01,		1.059926809232020e+01,
		1.072962961895630e+01,		1.085969454140301e+01,		1.098946364464645e+01,		1.111893771544051e+01,		1.124811754224265e+01,
		1.137700391514892e+01,		1.150559762582838e+01,		1.163389946745705e+01,		1.176191023465137e+01,		1.188963072340148e+01,
		1.201706173100412e+01,		1.214420405599546e+01,		1.227105849808389e+01,		1.239762585808264e+01,		1.252390693784271e+01,
		1.264990254018573e+01,		1.277561346883708e+01,		1.290104052835930e+01,		1.302618452408571e+01,		1.315104626205451e+01,
		1.327562654894313e+01,		1.339992619200319e+01,		1.352394599899580e+01,		1.364768677812746e+01,		1.377114933798656e+01,
		1.389433448748040e+01,		1.401724303577285e+01,		1.413987579222276e+01,		1.426223356632292e+01,		1.438431716763982e+01,
		1.450612740575415e+01,		1.462766509020199e+01,		1.474893103041682e+01,		1.486992603567232e+01,		1.499065091502594e+01,
		1.511110647726336e+01,		1.523129353084371e+01,		1.535121288384567e+01,		1.547086534391443e+01,		1.559025171820950e+01,
		1.570937281335338e+01,		1.582822943538113e+01,		1.594682238969082e+01,		1.606515248099482e+01,		1.618322051327206e+01,
		1.630102728972108e+01,		1.641857361271407e+01,		1.653586028375172e+01,		1.665288810341898e+01,		1.676965787134176e+01,
		1.688617038614445e+01,		1.700242644540835e+01,		1.711842684563099e+01,		1.723417238218629e+01,		1.734966384928565e+01,
		1.746490203993983e+01,		1.757988774592178e+01,		1.769462175773022e+01,		1.780910486455415e+01,		1.792333785423817e+01,
		1.803732151324864e+01,		1.815105662664065e+01,		1.826454397802583e+01,		1.837778434954090e+01,		1.849077852181718e+01,
		1.860352727395066e+01,		1.871603138347312e+01,		1.882829162632374e+01,		1.894030877682169e+01,		1.905208360763946e+01,
		1.916361688977671e+01,		1.927490939253516e+01,		1.938596188349403e+01,		1.949677512848617e+01,		1.960734989157502e+01,
		1.971768693503211e+01,		1.982778701931544e+01,		1.993765090304834e+01,		2.004727934299904e+01,		2.015667309406103e+01,
		2.026583290923385e+01,		2.037475953960467e+01,		2.048345373433044e+01,		2.059191624062060e+01,		2.070014780372048e+01,
		2.080814916689523e+01,		2.091592107141430e+01,		2.102346425653662e+01,		2.113077945949616e+01,		2.123786741548819e+01,
		2.134472885765596e+01,		2.145136451707801e+01,		2.155777512275590e+01,		2.166396140160256e+01,		2.176992407843103e+01,
		2.187566387594371e+01,		2.198118151472217e+01,		2.208647771321736e+01,		2.219155318774021e+01,		2.229640865245288e+01,
		2.240104481936023e+01,		2.250546239830187e+01,		2.260966209694460e+01,		2.271364462077515e+01,		2.281741067309353e+01,
		2.292096095500663e+01,		2.302429616542224e+01,		2.312741700104339e+01,		2.323032415636326e+01,		2.333301832366016e+01,
		2.343550019299315e+01,		2.353777045219778e+01,		2.363982978688231e+01,		2.374167888042420e+01,		2.384331841396688e+01,
		2.394474906641701e+01,		2.404597151444179e+01,		2.414698643246680e+01,		2.424779449267399e+01,		2.434839636499999e+01,
		2.444879271713479e+01,		2.454898421452051e+01,		2.464897152035059e+01,		2.474875529556919e+01,		2.484833619887085e+01,
		2.494771488670033e+01,		2.504689201325278e+01,		2.514586823047411e+01,		2.524464418806155e+01,		2.534322053346453e+01,
		2.544159791188559e+01,		2.553977696628173e+01,		2.563775833736582e+01,		2.573554266360820e+01,		2.583313058123856e+01,
		2.593052272424789e+01,		2.602771972439079e+01,		2.612472221118776e+01,		2.622153081192777e+01,		2.631814615167101e+01,
		2.641456885325172e+01,		2.651079953728125e+01,		2.660683882215130e+01,		2.670268732403716e+01,		2.679834565690128e+01,
		2.689381443249686e+01,		2.698909426037158e+01,		2.708418574787160e+01,		2.717908950014542e+01,		2.727380612014815e+01,
		2.736833620864573e+01,		2.746268036421926e+01,		2.755683918326958e+01,		2.765081326002180e+01,		2.774460318653005e+01,
		2.783820955268222e+01,		2.793163294620492e+01,		2.802487395266849e+01,		2.811793315549199e+01,		2.821081113594851e+01,
		2.830350847317035e+01,		2.839602574415436e+01,		2.848836352376743e+01,		2.858052238475187e+01,		2.867250289773116e+01,
		2.876430563121543e+01,		2.885593115160724e+01,		2.894738002320739e+01,		2.903865280822068e+01,		2.912975006676189e+01,
		2.922067235686169e+01,		2.931142023447270e+01,		2.940199425347549e+01,		2.949239496568477e+01,		2.958262292085550e+01,
		2.967267866668913e+01,		2.976256274883993e+01,		2.985227571092111e+01,		2.994181809451134e+01,		3.003119043916107e+01,
		3.012039328239891e+01,		3.020942715973810e+01,		3.029829260468308e+01,		3.038699014873583e+01,		3.047552032140260e+01,
		3.056388365020036e+01,		3.065208066066347e+01,		3.074011187635023e+01,		3.082797781884961e+01,		3.091567900778787e+01,
		3.100321596083527e+01,		3.109058919371272e+01,		3.117779922019863e+01,		3.126484655213550e+01,		3.135173169943678e+01,
		3.143845517009362e+01,		3.152501747018161e+01,		3.161141910386763e+01,		3.169766057341661e+01,		3.178374237919833e+01,
		3.186966501969430e+01,		3.195542899150452e+01,		3.204103478935436e+01,		3.212648290610135e+01,		3.221177383274205e+01,
		3.229690805841889e+01,		3.238188607042699e+01,		3.246670835422101e+01,		3.255137539342198e+01,		3.263588766982426e+01,
		3.272024566340213e+01,		3.280444985231692e+01,		3.288850071292361e+01,		3.297239871977776e+01,		3.305614434564240e+01,
		3.313973806149468e+01,		3.322318033653284e+01,		3.330647163818293e+01,		3.338961243210566e+01,		3.347260318220312e+01,
		3.355544435062568e+01,		3.363813639777860e+01,		3.372067978232894e+01,		3.380307496121225e+01,		3.388532238963928e+01,
		3.396742252110279e+01,		3.404937580738417e+01,		3.413118269856027e+01,		3.421284364300994e+01,		3.429435908742084e+01,
		3.437572947679604e+01,		3.445695525446067e+01,		3.453803686206860e+01,		3.461897473960901e+01,		3.469976932541302e+01,
		3.478042105616030e+01,		3.486093036688560e+01,		3.494129769098537e+01,		3.502152346022419e+01,		3.510160810474148e+01,
		3.518155205305779e+01,		3.526135573208146e+01,		3.534101956711500e+01,		3.542054398186163e+01,		3.549992939843155e+01,
		3.557917623734858e+01,		3.565828491755637e+01,		3.573725585642490e+01,		3.581608946975678e+01,		3.589478617179358e+01,
		3.597334637522223e+01,		3.605177049118125e+01,		3.613005892926702e+01,		3.620821209754013e+01,		3.628623040253152e+01,
		3.636411424924878e+01,		3.644186404118230e+01,		3.651948018031146e+01,		3.659696306711083e+01,		3.667431310055627e+01,
		3.675153067813100e+01,		3.682861619583183e+01,		3.690557004817514e+01,		3.698239262820287e+01,		3.705908432748875e+01,
		3.713564553614412e+01,		3.721207664282400e+01,		3.728837803473307e+01,		3.736455009763160e+01,		3.744059321584139e+01,
		3.751650777225159e+01,		3.759229414832468e+01,		3.766795272410236e+01,		3.774348387821124e+01,		3.781888798786877e+01,
		3.789416542888898e+01,		3.796931657568835e+01,		3.804434180129140e+01,		3.811924147733651e+01,		3.819401597408166e+01,
		3.826866566041005e+01,		3.834319090383577e+01,		3.841759207050944e+01,		3.849186952522390e+01,		3.856602363141965e+01,
		3.864005475119055e+01,		3.871396324528941e+01,		3.878774947313333e+01,		3.886141379280938e+01,		3.893495656108002e+01,
		3.900837813338858e+01,		3.908167886386466e+01,		3.915485910532958e+01,		3.922791920930182e+01,		3.930085952600230e+01,
		3.937368040435980e+01,		3.944638219201628e+01,		3.951896523533219e+01,		3.959142987939171e+01,		3.966377646800811e+01,
		3.973600534372892e+01,		3.980811684784118e+01,		3.988011132037661e+01,		3.995198910011683e+01,		4.002375052459853e+01,
		4.009539593011853e+01,		4.016692565173899e+01,		4.023834002329242e+01,		4.030963937738681e+01,		4.038082404541066e+01,
		4.045189435753801e+01,		4.052285064273347e+01,		4.059369322875714e+01,		4.066442244216966e+01,		4.073503860833711e+01,
		4.080554205143599e+01,		4.087593309445796e+01,		4.094621205921497e+01,		4.101637926634397e+01,		4.108643503531170e+01,
		4.115637968441968e+01,		4.122621353080886e+01,		4.129593689046449e+01,		4.136555007822085e+01,		4.143505340776594e+01,
		4.150444719164633e+01,		4.157373174127174e+01,		4.164290736691969e+01,		4.171197437774035e+01,		4.178093308176098e+01,
		4.184978378589062e+01,		4.191852679592471e+01,		4.198716241654967e+01,		4.205569095134740e+01,		4.212411270279991e+01,
		4.219242797229376e+01,		4.226063706012459e+01,		4.232874026550167e+01,		4.239673788655221e+01,		4.246463022032593e+01,
		4.253241756279949e+01,		4.260010020888077e+01,		4.266767845241339e+01,		4.273515258618104e+01,		4.280252290191175e+01,
		4.286978969028235e+01,		4.293695324092265e+01,		4.300401384241986e+01,		4.307097178232273e+01,		4.313782734714589e+01,
		4.320458082237414e+01,		4.327123249246648e+01,		4.333778264086053e+01,		4.340423154997656e+01,		4.347057950122166e+01,
		4.353682677499400e+01,		4.360297365068688e+01,		4.366902040669278e+01,		4.373496732040758e+01,		4.380081466823452e+01,
		4.386656272558837e+01,		4.393221176689931e+01,		4.399776206561712e+01,		4.406321389421508e+01,		4.412856752419399e+01,
		4.419382322608615e+01,		4.425898126945923e+01,		4.432404192292033e+01,		4.438900545411984e+01,		4.445387212975530e+01,
		4.451864221557533e+01,		4.458331597638349e+01,		4.464789367604214e+01,		4.471237557747622e+01,		4.477676194267718e+01,
		4.484105303270659e+01,		4.490524910770015e+01,		4.496935042687127e+01,		4.503335724851492e+01,		4.509726983001136e+01,
		4.516108842782978e+01,		4.522481329753214e+01,		4.528844469377666e+01,		4.535198287032173e+01,		4.541542808002933e+01,
		4.547878057486884e+01,		4.554204060592057e+01,		4.560520842337939e+01,		4.566828427655832e+01,		4.573126841389212e+01,
		4.579416108294087e+01,		4.585696253039338e+01,		4.591967300207092e+01,		4.598229274293058e+01,		4.604482199706881e+01,
		4.610726100772494e+01,		4.616961001728463e+01,		4.623186926728332e+01,		4.629403899840955e+01,		4.635611945050865e+01,
		4.641811086258588e+01,		4.648001347281000e+01,		4.654182751851652e+01,		4.660355323621118e+01,		4.666519086157318e+01,
		4.672674062945862e+01,		4.678820277390383e+01,		4.684957752812850e+01,		4.691086512453919e+01,		4.697206579473244e+01,
		4.703317976949818e+01,		4.709420727882289e+01,		4.715514855189276e+01,		4.721600381709709e+01,		4.727677330203137e+01,
		4.733745723350052e+01,		4.739805583752201e+01,		4.745856933932913e+01,		4.751899796337404e+01,		4.757934193333097e+01,
		4.763960147209927e+01,		4.769977680180667e+01,		4.775986814381221e+01,		4.781987571870938e+01,		4.787979974632924e+01
	},
	{
		7.707966215597166e-02,		2.311307391920120e-01,		3.848321394980773e-01,		5.381847211257648e-01,		6.911893257771471e-01,
		8.438467799050994e-01,		9.961578957628741e-01,		1.148123472404887e+00,		1.299744296640592e+00,		1.451021143943271e+00,
		1.601954779315461e+00,		1.752545958112720e+00,		1.902795426827329e+00,		2.052703923833504e+00,		2.202272180095591e+00,
		2.351500919840724e+00,		2.500390861197294e+00,		2.648942716800618e+00,		2.797157194367050e+00,		2.945034997237826e+00,
		3.092576824893811e+00,		3.239783373442328e+00,		3.386655336077176e+00,		3.533193403512913e+00,		3.679398264394450e+00,
		3.825270605682969e+00,		3.970811113019100e+00,		4.116020471064319e+00,		4.260899363821468e+00,		4.405448474935246e+00,
		4.549668487973525e+00,		4.693560086690288e+00,		4.837123955270988e+00,		4.980360778561051e+00,		5.123271242278286e+00,
		5.265856033209857e+00,		5.408115839394537e+00,		5.550051350290860e+00,		5.691663256931827e+00,		5.832952252066739e+00,
		5.973919030290776e+00,		6.114564288162850e+00,		6.254888724312313e+00,		6.394893039534993e+00,		6.534577936879105e+00,
		6.673944121721505e+00,		6.812992301834744e+00,		6.951723187445395e+00,		7.090137491284048e+00,		7.228235928627446e+00,
		7.366019217333095e+00,		7.503488077866811e+00,		7.640643233323481e+00,		7.777485409441490e+00,		7.914015334611103e+00,
		8.050233739877131e+00,		8.186141358936213e+00,		8.321738928129029e+00,		8.457027186427718e+00,		8.592006875418761e+00,
		8.726678739281665e+00,		8.861043524763641e+00,		8.995101981150551e+00,		9.128854860234352e+00,		9.262302916277307e+00,
		9.395446905973104e+00,		9.528287588405153e+00,		9.660825725002267e+00,		9.793062079491859e+00,		9.924997417850886e+00,
		1.005663250825474e+01,		1.018796812102416e+01,		1.031900502857043e+01,		1.044974400533898e+01,		1.058018582775145e+01,
		1.071033127414656e+01,		1.084018112471966e+01,		1.096973616146132e+01,		1.109899716809495e+01,		1.122796493001356e+01,
		1.135664023421587e+01,		1.148502386924175e+01,		1.161311662510724e+01,		1.174091929323901e+01,		1.186843266640862e+01,
		1.199565753866652e+01,		1.212259470527579e+01,		1.224924496264594e+01,		1.237560910826661e+01,		1.250168794064127e+01,
		1.262748225922122e+01,		1.275299286433955e+01,		1.287822055714552e+01,		1.300316613953909e+01,		1.312783041410590e+01,
		1.325221418405255e+01,		1.337631825314242e+01,		1.350014342563181e+01,		1.362369050620674e+01,		1.374696029992022e+01,
		1.386995361213013e+01,		1.399267124843769e+01,		1.411511401462662e+01,		1.423728271660291e+01,		1.435917816033536e+01,
		1.448080115179674e+01,		1.460215249690578e+01,		1.472323300146991e+01,		1.484404347112867e+01,		1.496458471129810e+01,
		1.508485752711571e+01,		1.520486272338649e+01,		1.532460110452959e+01,		1.544407347452590e+01,		1.556328063686649e+01,
		1.568222339450189e+01,		1.580090254979221e+01,		1.591931890445818e+01,		1.603747325953298e+01,		1.615536641531505e+01,
		1.627299917132171e+01,		1.639037232624360e+01,		1.650748667790013e+01,		1.662434302319571e+01,		1.674094215807692e+01,
		1.685728487749047e+01,		1.697337197534207e+01,		1.708920424445624e+01,		1.720478247653685e+01,		1.732010746212862e+01,
		1.743517999057945e+01,		1.755000085000355e+01,		1.766457082724550e+01,		1.777889070784505e+01,		1.789296127600281e+01,
		1.800678331454678e+01,		1.812035760489964e+01,		1.823368492704682e+01,		1.834676605950550e+01,		1.845960177929429e+01,
		1.857219286190368e+01,		1.868454008126734e+01,		1.879664420973416e+01,		1.890850601804095e+01,		1.902012627528608e+01,
		1.913150574890365e+01,		1.924264520463847e+01,		1.935354540652186e+01,		1.946420711684793e+01,		1.957463109615079e+01,
		1.968481810318221e+01,		1.979476889489024e+01,		1.990448422639822e+01,		2.001396485098460e+01,		2.012321152006335e+01,
		2.023222498316508e+01,		2.034100598791864e+01,		2.044955528003346e+01,		2.055787360328248e+01,		2.066596169948563e+01,
		2.077382030849383e+01,		2.088145016817379e+01,		2.098885201439305e+01,		2.109602658100591e+01,		2.120297459983963e+01,
		2.130969680068132e+01,		2.141619391126523e+01,		2.152246665726076e+01,		2.162851576226070e+01,		2.173434194777016e+01,
		2.183994593319596e+01,		2.194532843583634e+01,		2.205049017087142e+01,		2.215543185135376e+01,		2.226015418819973e+01,
		2.236465789018100e+01,		2.246894366391664e+01,		2.257301221386565e+01,		2.267686424231973e+01,		2.278050044939671e+01,
		2.288392153303407e+01,		2.298712818898314e+01,		2.309012111080340e+01,		2.319290098985740e+01,		2.329546851530588e+01,
		2.339782437410324e+01,		2.349996925099348e+01,		2.360190382850627e+01,		2.370362878695360e+01,		2.380514480442651e+01,
		2.390645255679230e+01,		2.400755271769193e+01,		2.410844595853785e+01,		2.420913294851196e+01,		2.430961435456397e+01,
		2.440989084140999e+01,		2.450996307153141e+01,		2.460983170517404e+01,		2.470949740034746e+01,		2.480896081282469e+01,
		2.490822259614209e+01,		2.500728340159941e+01,		2.510614387826025e+01,		2.520480467295251e+01,		2.530326643026927e+01,
		2.540152979256978e+01,		2.549959539998069e+01,		2.559746389039741e+01,		2.569513589948580e+01,		2.579261206068394e+01,
		2.588989300520410e+01,		2.598697936203498e+01,		2.608387175794400e+01,		2.618057081747984e+01,		2.627707716297514e+01,
		2.637339141454936e+01,		2.646951419011175e+01,		2.656544610536450e+01,		2.666118777380610e+01,		2.675673980673477e+01,
		2.685210281325202e+01,		2.694727740026639e+01,		2.704226417249732e+01,		2.713706373247911e+01,		2.723167668056504e+01,
		2.732610361493158e+01,		2.742034513158270e+01,		2.751440182435443e+01,		2.760827428491927e+01,		2.770196310279095e+01,
		2.779546886532914e+01,		2.788879215774437e+01,		2.798193356310296e+01,		2.807489366233199e+01,		2.816767303422456e+01,
		2.826027225544492e+01,		2.835269190053383e+01,		2.844493254191386e+01,		2.853699474989493e+01,		2.862887909267980e+01,
		2.872058613636966e+01,		2.881211644496982e+01,		2.890347058039542e+01,		2.899464910247725e+01,		2.908565256896758e+01,
		2.917648153554610e+01,		2.926713655582585e+01,		2.935761818135930e+01,		2.944792696164433e+01,		2.953806344413048e+01,
		2.962802817422502e+01,		2.971782169529914e+01,		2.980744454869430e+01,		2.989689727372850e+01,		2.998618040770254e+01,
		3.007529448590646e+01,		3.016424004162594e+01,		3.025301760614870e+01,		3.034162770877099e+01,		3.043007087680412e+01,
		3.051834763558092e+01,		3.060645850846237e+01,		3.069440401684409e+01,		3.078218468016300e+01,		3.086980101590393e+01,
		3.095725353960629e+01,		3.104454276487064e+01,		3.113166920336547e+01,		3.121863336483385e+01,		3.130543575710011e+01,
		3.139207688607663e+01,		3.147855725577050e+01,		3.156487736829038e+01,		3.165103772385306e+01,		3.173703882079043e+01,
		3.182288115555617e+01,		3.190856522273247e+01,		3.199409151503692e+01,		3.207946052332922e+01,		3.216467273661798e+01,
		3.224972864206759e+01,		3.233462872500495e+01,		3.241937346892625e+01,		3.250396335550381e+01,		3.258839886459289e+01,
		3.267268047423842e+01,		3.275680866068188e+01,		3.284078389836798e+01,		3.292460665995159e+01,		3.300827741630437e+01,
		3.309179663652164e+01,		3.317516478792913e+01,		3.325838233608972e+01,		3.334144974481022e+01,		3.342436747614810e+01,
		3.350713599041826e+01,		3.358975574619974e+01,		3.367222720034236e+01,		3.375455080797361e+01,		3.383672702250514e+01,
		3.391875629563965e+01,		3.400063907737741e+01,		3.408237581602297e+01,		3.416396695819185e+01,		3.424541294881713e+01,
		3.432671423115610e+01,		3.440787124679684e+01,		3.448888443566485e+01,		3.456975423602962e+01,		3.465048108451116e+01,
		3.473106541608665e+01,		3.481150766409682e+01,		3.489180826025260e+01,		3.497196763464159e+01,		3.505198621573447e+01,
		3.513186443039159e+01,		3.521160270386928e+01,		3.529120145982647e+01,		3.537066112033091e+01,		3.544998210586566e+01,
		3.552916483533546e+01,		3.560820972607315e+01,		3.568711719384584e+01,		3.576588765286145e+01,		3.584452151577484e+01,
		3.592301919369418e+01,		3.600138109618718e+01,		3.607960763128737e+01,		3.615769920550027e+01,		3.623565622380966e+01,
		3.631347908968369e+01,		3.639116820508112e+01,		3.646872397045738e+01,		3.654614678477078e+01,		3.662343704548855e+01,
		3.670059514859297e+01,		3.677762148858734e+01,		3.685451645850217e+01,		3.693128044990100e+01,		3.700791385288660e+01,
		3.708441705610679e+01,		3.716079044676049e+01,		3.723703441060357e+01,		3.731314933195488e+01,		3.738913559370204e+01,
		3.746499357730726e+01,		3.754072366281336e+01,		3.761632622884949e+01,		3.769180165263689e+01,		3.776715030999473e+01,
		3.784237257534589e+01,		3.791746882172264e+01,		3.799243942077241e+01,		3.806728474276341e+01,		3.814200515659038e+01,
		3.821660102978021e+01,		3.829107272849757e+01,		3.836542061755049e+01,		3.843964506039597e+01,		3.851374641914554e+01,
		3.858772505457083e+01,		3.866158132610899e+01,		3.873531559186831e+01,		3.880892820863361e+01,		3.888241953187170e+01,
		3.895578991573691e+01,		3.902903971307631e+01,		3.910216927543528e+01,		3.917517895306279e+01,		3.924806909491670e+01,
		3.932084004866925e+01,		3.939349216071214e+01,		3.946602577616193e+01,		3.953844123886532e+01,		3.961073889140437e+01,
		3.968291907510157e+01,		3.975498213002530e+01,		3.982692839499475e+01,		3.989875820758520e+01,		3.997047190413316e+01,
		4.004206981974136e+01,		4.011355228828400e+01,		4.018491964241165e+01,		4.025617221355640e+01,		4.032731033193686e+01,
		4.039833432656313e+01,		4.046924452524180e+01,		4.054004125458093e+01,		4.061072483999496e+01,		4.068129560570961e+01,
		4.075175387476686e+01,		4.082209996902968e+01,		4.089233420918703e+01,		4.096245691475862e+01,		4.103246840409972e+01,
		4.110236899440602e+01,		4.117215900171828e+01,		4.124183874092726e+01,		4.131140852577823e+01,		4.138086866887586e+01,
		4.145021948168888e+01,		4.151946127455468e+01,		4.158859435668402e+01,		4.165761903616564e+01,		4.172653561997091e+01,
		4.179534441395838e+01,		4.186404572287829e+01,		4.193263985037735e+01,		4.200112709900297e+01,		4.206950777020804e+01,
		4.213778216435521e+01,		4.220595058072153e+01,		4.227401331750286e+01,		4.234197067181823e+01,		4.240982293971430e+01,
		4.247757041616986e+01,		4.254521339510005e+01,		4.261275216936080e+01,		4.268018703075318e+01,		4.274751827002770e+01,
		4.281474617688864e+01,		4.288187103999827e+01,		4.294889314698123e+01,		4.301581278442864e+01,		4.308263023790246e+01,
		4.314934579193960e+01,		4.321595973005618e+01,		4.328247233475168e+01,		4.334888388751310e+01,		4.341519466881910e+01,
		4.348140495814411e+01,		4.354751503396246e+01,		4.361352517375240e+01,		4.367943565400032e+01,		4.374524675020455e+01,
		4.381095873687972e+01,		4.387657188756042e+01,		4.394208647480549e+01,		4.400750277020178e+01,		4.407282104436834e+01,
		4.413804156696014e+01,		4.420316460667215e+01,		4.426819043124317e+01,		4.433311930745979e+01,		4.439795150116021e+01,
		4.446268727723812e+01,		4.452732689964658e+01,		4.459187063140178e+01,		4.465631873458690e+01,		4.472067147035590e+01,
		4.478492909893725e+01,		4.484909187963779e+01,		4.491316007084633e+01,		4.497713393003757e+01,		4.504101371377563e+01,
		4.510479967771781e+01,		4.516849207661832e+01,		4.523209116433193e+01,		4.529559719381752e+01,		4.535901041714182e+01,
		4.542233108548303e+01,		4.548555944913434e+01,		4.554869575750754e+01,		4.561174025913665e+01,		4.567469320168142e+01,
		4.573755483193091e+01,		4.580032539580693e+01,		4.586300513836762e+01,		4.592559430381093e+01,		4.598809313547812e+01,
		4.605050187585716e+01,		4.611282076658622e+01,		4.617505004845711e+01,		4.623718996141866e+01,		4.629924074458017e+01,
		4.636120263621478e+01,		4.642307587376281e+01,		4.648486069383512e+01,		4.654655733221660e+01,		4.660816602386925e+01,
		4.666968700293565e+01,		4.673112050274229e+01,		4.679246675580277e+01,		4.685372599382111e+01,		4.691489844769499e+01,
		4.697598434751905e+01,		4.703698392258799e+01,		4.709789740139997e+01,		4.715872501165964e+01,		4.721946698028145e+01,
		4.728012353339275e+01,		4.734069489633700e+01,		4.740118129367686e+01,		4.746158294919737e+01,		4.752190008590910e+01,
		4.758213292605115e+01,		4.764228169109436e+01,		4.770234660174425e+01,		4.776232787794427e+01,		4.782222573887872e+01
	},
	{
		7.693214774686261e-02,		2.306887252969591e-01,		3.840967254654862e-01,		5.371570052758926e-01,		6.898704055255841e-01,
		8.422377518738435e-01,		9.942598558796479e-01,		1.145937515991320e+00,		1.297271518489870e+00,		1.448262638387811e+00,
		1.598911640285176e+00,		1.749219279184385e+00,		1.899186301265558e+00,		2.048813444623810e+00,		2.198101439969999e+00,
		2.347051011296367e+00,		2.495662876508426e+00,		2.643937748024427e+00,		2.791876333343681e+00,		2.939479335584967e+00,
		3.086747453996196e+00,		3.233681384436498e+00,		3.380281819831819e+00,		3.526549450605087e+00,		3.672484965081993e+00,
		3.818089049873358e+00,		3.963362390235048e+00,		4.108305670406351e+00,		4.252919573927723e+00,		4.397204783938740e+00,
		4.541161983457088e+00,		4.684791855639400e+00,		4.828095084024693e+00,		4.971072352761170e+00,		5.113724346817066e+00,
		5.256051752176277e+00,		5.398055256019394e+00,		5.539735546890823e+00,		5.681093314852573e+00,		5.822129251625334e+00,
		5.962844050717427e+00,		6.103238407542151e+00,		6.243313019524094e+00,		6.383068586194897e+00,		6.522505809279001e+00,
		6.661625392769809e+00,		6.800428042996776e+00,		6.938914468683826e+00,		7.077085380999553e+00,		7.214941493599601e+00,
		7.352483522661638e+00,		7.489712186913275e+00,		7.626628207653319e+00,		7.763232308766717e+00,		7.899525216733519e+00,
		8.035507660632161e+00,		8.171180372137453e+00,		8.306544085513488e+00,		8.441599537601814e+00,		8.576347467805135e+00,
		8.710788618066827e+00,		8.844923732846429e+00,		8.978753559091533e+00,		9.112278846206120e+00,		9.245500346015689e+00,
		9.378418812729340e+00,		9.511035002899057e+00,		9.643349675376353e+00,		9.775363591266471e+00,		9.907077513880358e+00,
		1.003849220868455e+01,		1.016960844324912e+01,		1.030042698719392e+01,		1.043094861213319e+01,		1.056117409161874e+01,
		1.069110420108172e+01,		1.082073971777338e+01,		1.095008142070457e+01,		1.107913009058445e+01,		1.120788650975830e+01,
		1.133635146214464e+01,		1.146452573317169e+01,		1.159241010971341e+01,		1.172000538002497e+01,		1.184731233367806e+01,
		1.197433176149580e+01,		1.210106445548756e+01,		1.222751120878365e+01,		1.235367281557001e+01,		1.247955007102294e+01,
		1.260514377124390e+01,		1.273045471319455e+01,		1.285548369463191e+01,		1.298023151404393e+01,		1.310469897058525e+01,
		1.322888686401344e+01,		1.335279599462560e+01,		1.347642716319544e+01,		1.359978117091086e+01,		1.372285881931209e+01,
		1.384566091023031e+01,		1.396818824572699e+01,		1.409044162803378e+01,		1.421242185949306e+01,		1.433412974249922e+01,
		1.445556607944058e+01,		1.457673167264211e+01,		1.469762732430880e+01,		1.481825383646987e+01,		1.493861201092374e+01,
		1.505870264918374e+01,		1.517852655242471e+01,		1.529808452143034e+01,		1.541737735654136e+01,		1.553640585760462e+01,
		1.565517082392287e+01,		1.577367305420559e+01,		1.589191334652046e+01,		1.600989249824583e+01,		1.612761130602401e+01,
		1.624507056571544e+01,		1.636227107235367e+01,		1.647921362010121e+01,		1.659589900220633e+01,		1.671232801096066e+01,
		1.682850143765762e+01,		1.694442007255172e+01,		1.706008470481882e+01,		1.717549612251707e+01,		1.729065511254887e+01,
		1.740556246062347e+01,		1.752021895122065e+01,		1.763462536755502e+01,		1.774878249154127e+01,		1.786269110376014e+01,
		1.797635198342535e+01,		1.808976590835117e+01,		1.820293365492088e+01,		1.831585599805599e+01,		1.842853371118626e+01,
		1.854096756622048e+01,		1.865315833351800e+01,		1.876510678186099e+01,		1.887681367842758e+01,		1.898827978876555e+01,
		1.909950587676683e+01,		1.921049270464278e+01,		1.932124103290009e+01,		1.943175162031737e+01,		1.954202522392251e+01,
		1.965206259897066e+01,		1.976186449892283e+01,		1.987143167542531e+01,		1.998076487828956e+01,		2.008986485547277e+01,
		2.019873235305923e+01,		2.030736811524203e+01,		2.041577288430558e+01,		2.052394740060862e+01,		2.063189240256794e+01,
		2.073960862664247e+01,		2.084709680731817e+01,		2.095435767709327e+01,		2.106139196646424e+01,		2.116820040391213e+01,
		2.127478371588957e+01,		2.138114262680819e+01,		2.148727785902664e+01,		2.159319013283902e+01,		2.169888016646383e+01,
		2.180434867603341e+01,		2.190959637558388e+01,		2.201462397704545e+01,		2.211943219023325e+01,		2.222402172283860e+01,
		2.232839328042069e+01,		2.243254756639868e+01,		2.253648528204422e+01,		2.264020712647440e+01,		2.274371379664507e+01,
		2.284700598734457e+01,		2.295008439118779e+01,		2.305294969861066e+01,		2.315560259786501e+01,		2.325804377501370e+01,
		2.336027391392619e+01,		2.346229369627445e+01,		2.356410380152908e+01,		2.366570490695594e+01,		2.376709768761291e+01,
		2.386828281634712e+01,		2.396926096379235e+01,		2.407003279836685e+01,		2.417059898627135e+01,		2.427096019148733e+01,
		2.437111707577575e+01,		2.447107029867577e+01,		2.457082051750401e+01,		2.467036838735384e+01,		2.476971456109502e+01,
		2.486885968937361e+01,		2.496780442061208e+01,		2.506654940100958e+01,		2.516509527454259e+01,		2.526344268296562e+01,
		2.536159226581223e+01,		2.545954466039626e+01,		2.555730050181318e+01,		2.565486042294169e+01,		2.575222505444552e+01,
		2.584939502477540e+01,		2.594637096017118e+01,		2.604315348466422e+01,		2.613974322007974e+01,		2.623614078603968e+01,
		2.633234679996533e+01,		2.642836187708044e+01,		2.652418663041424e+01,		2.661982167080482e+01,		2.671526760690245e+01,
		2.681052504517319e+01,		2.690559458990254e+01,		2.700047684319930e+01,		2.709517240499949e+01,		2.718968187307039e+01,
		2.728400584301480e+01,		2.737814490827522e+01,		2.747209966013842e+01,		2.756587068773977e+01,		2.765945857806806e+01,
		2.775286391597002e+01,		2.784608728415534e+01,		2.793912926320138e+01,		2.803199043155837e+01,		2.812467136555433e+01,
		2.821717263940038e+01,		2.830949482519589e+01,		2.840163849293389e+01,		2.849360421050647e+01,		2.858539254371022e+01,
		2.867700405625183e+01,		2.876843930975369e+01,		2.885969886375959e+01,		2.895078327574045e+01,		2.904169310110017e+01,
		2.913242889318143e+01,		2.922299120327170e+01,		2.931338058060913e+01,		2.940359757238864e+01,		2.949364272376793e+01,
		2.958351657787368e+01,		2.967321967580768e+01,		2.976275255665299e+01,		2.985211575748027e+01,		2.994130981335401e+01,
		3.003033525733888e+01,		3.011919262050610e+01,		3.020788243193975e+01,		3.029640521874330e+01,		3.038476150604602e+01,
		3.047295181700941e+01,		3.056097667283379e+01,		3.064883659276477e+01,		3.073653209409983e+01,		3.082406369219485e+01,
		3.091143190047082e+01,		3.099863723042029e+01,		3.108568019161415e+01,		3.117256129170819e+01,		3.125928103644979e+01,
		3.134583992968459e+01,		3.143223847336322e+01,		3.151847716754789e+01,		3.160455651041925e+01,		3.169047699828296e+01,
		3.177623912557657e+01,		3.186184338487610e+01,		3.194729026690288e+01,		3.203258026053026e+01,		3.211771385279035e+01,
		3.220269152888078e+01,		3.228751377217150e+01,		3.237218106421142e+01,		3.245669388473524e+01,		3.254105271167023e+01,
		3.262525802114292e+01,		3.270931028748583e+01,		3.279320998324434e+01,		3.287695757918326e+01,		3.296055354429370e+01,
		3.304399834579976e+01,		3.312729244916521e+01,		3.321043631810029e+01,		3.329343041456838e+01,		3.337627519879263e+01,
		3.345897112926287e+01,		3.354151866274202e+01,		3.362391825427299e+01,		3.370617035718521e+01,		3.378827542310139e+01,
		3.387023390194406e+01,		3.395204624194228e+01,		3.403371288963824e+01,		3.411523428989383e+01,		3.419661088589733e+01,
		3.427784311916990e+01,		3.435893142957217e+01,		3.443987625531082e+01,		3.452067803294513e+01,		3.460133719739343e+01,
		3.468185418193969e+01,		3.476222941824000e+01,		3.484246333632900e+01,		3.492255636462638e+01,		3.500250892994335e+01,
		3.508232145748896e+01,		3.516199437087668e+01,		3.524152809213064e+01,		3.532092304169210e+01,		3.540017963842573e+01,
		3.547929829962604e+01,		3.555827944102362e+01,		3.563712347679150e+01,		3.571583081955139e+01,		3.579440188038000e+01,
		3.587283706881524e+01,		3.595113679286239e+01,		3.602930145900047e+01,		3.610733147218830e+01,		3.618522723587066e+01,
		3.626298915198451e+01,		3.634061762096509e+01,		3.641811304175199e+01,		3.649547581179527e+01,		3.657270632706152e+01,
		3.664980498203992e+01,		3.672677216974823e+01,		3.680360828173880e+01,		3.688031370810460e+01,		3.695688883748512e+01,
		3.703333405707231e+01,		3.710964975261656e+01,		3.718583630843255e+01,		3.726189410740513e+01,		3.733782353099519e+01,
		3.741362495924548e+01,		3.748929877078642e+01,		3.756484534284190e+01,		3.764026505123502e+01,		3.771555827039393e+01,
		3.779072537335740e+01,		3.786576673178070e+01,		3.794068271594109e+01,		3.801547369474368e+01,		3.809014003572690e+01,
		3.816468210506822e+01,		3.823910026758972e+01,		3.831339488676362e+01,		3.838756632471791e+01,		3.846161494224178e+01,
		3.853554109879125e+01,		3.860934515249452e+01,		3.868302746015757e+01,		3.875658837726949e+01,		3.883002825800796e+01,
		3.890334745524463e+01,		3.897654632055052e+01,		3.904962520420134e+01,		3.912258445518285e+01,		3.919542442119615e+01,
		3.926814544866301e+01,		3.934074788273109e+01,		3.941323206727924e+01,		3.948559834492266e+01,		3.955784705701816e+01,
		3.962997854366933e+01,		3.970199314373172e+01,		3.977389119481789e+01,		3.984567303330266e+01,		3.991733899432813e+01,
		3.998888941180874e+01,		4.006032461843639e+01,		4.013164494568546e+01,		4.020285072381775e+01,		4.027394228188755e+01,
		4.034491994774660e+01,		4.041578404804905e+01,		4.048653490825632e+01,		4.055717285264208e+01,		4.062769820429714e+01,
		4.069811128513427e+01,		4.076841241589306e+01,		4.083860191614477e+01,		4.090868010429716e+01,		4.097864729759918e+01,
		4.104850381214584e+01,		4.111824996288289e+01,		4.118788606361156e+01,		4.125741242699330e+01,		4.132682936455439e+01,
		4.139613718669070e+01,		4.146533620267226e+01,		4.153442672064786e+01,		4.160340904764982e+01,		4.167228348959834e+01,
		4.174105035130627e+01,		4.180970993648351e+01,		4.187826254774162e+01,		4.194670848659832e+01,		4.201504805348196e+01,
		4.208328154773594e+01,		4.215140926762329e+01,		4.221943151033094e+01,		4.228734857197428e+01,		4.235516074760142e+01,
		4.242286833119771e+01,		4.249047161568988e+01,		4.255797089295061e+01,		4.262536645380271e+01,		4.269265858802343e+01,
		4.275984758434877e+01,		4.282693373047772e+01,		4.289391731307654e+01,		4.296079861778290e+01,		4.302757792921019e+01,
		4.309425553095166e+01,		4.316083170558449e+01,		4.322730673467417e+01,		4.329368089877842e+01,		4.335995447745141e+01,
		4.342612774924780e+01,		4.349220099172688e+01,		4.355817448145664e+01,		4.362404849401770e+01,		4.368982330400747e+01,
		4.375549918504407e+01,		4.382107640977039e+01,		4.388655524985800e+01,		4.395193597601117e+01,		4.401721885797075e+01,
		4.408240416451812e+01,		4.414749216347909e+01,		4.421248312172785e+01,		4.427737730519072e+01,		4.434217497885010e+01,
		4.440687640674830e+01,		4.447148185199129e+01,		4.453599157675262e+01,		4.460040584227711e+01,		4.466472490888465e+01,
		4.472894903597400e+01,		4.479307848202644e+01,		4.485711350460962e+01,		4.492105436038113e+01,		4.498490130509231e+01,
		4.504865459359177e+01,		4.511231447982929e+01,		4.517588121685923e+01,		4.523935505684424e+01,		4.530273625105894e+01,
		4.536602504989342e+01,		4.542922170285681e+01,		4.549232645858103e+01,		4.555533956482404e+01,		4.561826126847365e+01,
		4.568109181555084e+01,		4.574383145121337e+01,		4.580648041975932e+01,		4.586903896463035e+01,		4.593150732841544e+01,
		4.599388575285400e+01,		4.605617447883969e+01,		4.611837374642349e+01,		4.618048379481726e+01,		4.624250486239712e+01,
		4.630443718670683e+01,		4.636628100446100e+01,		4.642803655154862e+01,		4.648970406303631e+01,		4.655128377317161e+01,
		4.661277591538626e+01,		4.667418072229954e+01,		4.673549842572153e+01,		4.679672925665630e+01,		4.685787344530525e+01,
		4.691893122107022e+01,		4.697990281255679e+01,		4.704078844757743e+01,		4.710158835315475e+01,		4.716230275552454e+01,
		4.722293188013909e+01,		4.728347595167019e+01,		4.734393519401234e+01,		4.740430983028590e+01,		4.746460008283999e+01,
		4.752480617325585e+01,		4.758492832234977e+01,		4.764496675017615e+01,		4.770492167603054e+01,		4.776479331845277e+01
	},
	{
		7.678519705026819e-02,		2.302484002856131e-01,		3.833641209568383e-01,		5.361332150363144e-01,		6.885565223926136e-01,
		8.406348678661835e-01,		9.923690622955644e-01,		1.143759903496049e+00,		1.294808177192623e+00,		1.445514657908951e+00,
		1.595880109814084e+00,		1.745905287528553e+00,		1.895590936891396e+00,		2.044937795689632e+00,		2.193946594351664e+00,
		2.342618056605978e+00,		2.490952900106532e+00,		2.638951837026105e+00,		2.786615574618894e+00,		2.933944815753540e+00,
		3.080940259417784e+00,		3.227602601195857e+00,		3.373932533719710e+00,		3.519930747095114e+00,		3.665597929303657e+00,
		3.810934766581614e+00,		3.955941943776628e+00,		4.100620144683093e+00,		4.244970052357165e+00,		4.388992349412189e+00,
		4.532687718295397e+00,		4.676056841546651e+00,		4.819100402039989e+00,		4.961819083208716e+00,		5.104213569254738e+00,
		5.246284545342818e+00,		5.388032697780428e+00,		5.529458714183810e+00,		5.670563283630886e+00,		5.811347096801565e+00,
		5.951810846106062e+00,		6.091955225801738e+00,		6.231780932099026e+00,		6.371288663256914e+00,		6.510479119668502e+00,
		6.649353003937101e+00,		6.787911020943320e+00,		6.926153877903585e+00,		7.064082284420529e+00,		7.201696952525621e+00,
		7.338998596714456e+00,		7.475987933975082e+00,		7.612665683809698e+00,		7.749032568250128e+00,		7.885089311867314e+00,
		8.020836641775258e+00,		8.156275287629645e+00,		8.291405981621468e+00,		8.426229458465947e+00,		8.560746455387003e+00,
		8.694957712097581e+00,		8.828863970776023e+00,		8.962465976038771e+00,		9.095764474909647e+00,		9.228760216785874e+00,
		9.361453953401110e+00,		9.493846438785681e+00,		9.625938429224190e+00,		9.757730683210710e+00,		9.889223961401747e+00,
		1.002041902656712e+01,		1.015131664353897e+01,		1.028191757915894e+01,		1.041222260222386e+01,		1.054223248342994e+01,
		1.067194799531558e+01,		1.080136991220311e+01,		1.093049901013938e+01,		1.105933606683546e+01,		1.118788186160546e+01,
		1.131613717530467e+01,		1.144410279026706e+01,		1.157177949024228e+01,		1.169916806033217e+01,		1.182626928692703e+01,
		1.195308395764151e+01,		1.207961286125043e+01,		1.220585678762440e+01,		1.233181652766550e+01,		1.245749287324291e+01,
		1.258288661712866e+01,		1.270799855293357e+01,		1.283282947504340e+01,		1.295738017855514e+01,		1.308165145921387e+01,
		1.320564411334966e+01,		1.332935893781517e+01,		1.345279672992352e+01,		1.357595828738670e+01,		1.369884440825448e+01,
		1.382145589085391e+01,		1.394379353372939e+01,		1.406585813558334e+01,		1.418765049521751e+01,		1.430917141147502e+01,
		1.443042168318298e+01,		1.455140210909590e+01,		1.467211348783983e+01,		1.479255661785720e+01,		1.491273229735245e+01,
		1.503264132423847e+01,		1.515228449608371e+01,		1.527166261006029e+01,		1.539077646289272e+01,		1.550962685080756e+01,
		1.562821456948387e+01,		1.574654041400449e+01,		1.586460517880818e+01,		1.598240965764259e+01,		1.609995464351806e+01,
		1.621724092866231e+01,		1.633426930447593e+01,		1.645104056148876e+01,		1.656755548931713e+01,		1.668381487662187e+01,
		1.679981951106727e+01,		1.691557017928084e+01,		1.703106766681390e+01,		1.714631275810304e+01,		1.726130623643235e+01,
		1.737604888389658e+01,		1.749054148136508e+01,		1.760478480844650e+01,		1.771877964345441e+01,		1.783252676337363e+01,
		1.794602694382743e+01,		1.805928095904554e+01,		1.817228958183279e+01,		1.828505358353877e+01,		1.839757373402805e+01,
		1.850985080165130e+01,		1.862188555321705e+01,		1.873367875396429e+01,		1.884523116753579e+01,		1.895654355595208e+01,
		1.906761667958623e+01,		1.917845129713927e+01,		1.928904816561638e+01,		1.939940804030371e+01,		1.950953167474589e+01,
		1.961941982072425e+01,		1.972907322823563e+01,		1.983849264547192e+01,		1.994767881880019e+01,		2.005663249274345e+01,
		2.016535440996205e+01,		2.027384531123567e+01,		2.038210593544596e+01,		2.049013701955967e+01,		2.059793929861251e+01,
		2.070551350569340e+01,		2.081286037192944e+01,		2.091998062647135e+01,		2.102687499647945e+01,		2.113354420711021e+01,
		2.123998898150329e+01,		2.134621004076912e+01,		2.145220810397689e+01,		2.155798388814323e+01,		2.166353810822112e+01,
		2.176887147708951e+01,		2.187398470554324e+01,		2.197887850228348e+01,		2.208355357390861e+01,		2.218801062490556e+01,
		2.229225035764152e+01,		2.239627347235615e+01,		2.250008066715409e+01,		2.260367263799801e+01,		2.270705007870193e+01,
		2.281021368092501e+01,		2.291316413416564e+01,		2.301590212575600e+01,		2.311842834085687e+01,		2.322074346245289e+01,
		2.332284817134807e+01,		2.342474314616173e+01,		2.352642906332473e+01,		2.362790659707596e+01,		2.372917641945927e+01,
		2.383023920032058e+01,		2.393109560730543e+01,		2.403174630585664e+01,		2.413219195921244e+01,		2.423243322840473e+01,
		2.433247077225776e+01,		2.443230524738691e+01,		2.453193730819786e+01,		2.463136760688596e+01,		2.473059679343584e+01,
		2.482962551562126e+01,		2.492845441900526e+01,		2.502708414694042e+01,		2.512551534056941e+01,		2.522374863882582e+01,
		2.532178467843504e+01,		2.541962409391549e+01,		2.551726751758001e+01,		2.561471557953737e+01,		2.571196890769409e+01,
		2.580902812775633e+01,		2.590589386323209e+01,		2.600256673543340e+01,		2.609904736347888e+01,		2.619533636429630e+01,
		2.629143435262545e+01,		2.638734194102096e+01,		2.648305973985549e+01,		2.657858835732298e+01,		2.667392839944195e+01,
		2.676908047005909e+01,		2.686404517085286e+01,		2.695882310133733e+01,		2.705341485886600e+01,		2.714782103863595e+01,
		2.724204223369189e+01,		2.733607903493041e+01,		2.742993203110445e+01,		2.752360180882769e+01,		2.761708895257914e+01,
		2.771039404470787e+01,		2.780351766543773e+01,		2.789646039287227e+01,		2.798922280299966e+01,		2.808180546969776e+01,
		2.817420896473923e+01,		2.826643385779681e+01,		2.835848071644852e+01,		2.845035010618309e+01,		2.854204259040538e+01,
		2.863355873044191e+01,		2.872489908554636e+01,		2.881606421290537e+01,		2.890705466764403e+01,		2.899787100283184e+01,
		2.908851376948844e+01,		2.917898351658949e+01,		2.926928079107259e+01,		2.935940613784334e+01,		2.944936009978123e+01,
		2.953914321774585e+01,		2.962875603058292e+01,		2.971819907513052e+01,		2.980747288622522e+01,		2.989657799670838e+01,
		2.998551493743237e+01,		3.007428423726698e+01,		3.016288642310564e+01,		3.025132201987187e+01,		3.033959155052568e+01,
		3.042769553606998e+01,		3.051563449555707e+01,		3.060340894609509e+01,		3.069101940285453e+01,		3.077846637907480e+01,
		3.086575038607074e+01,		3.095287193323921e+01,		3.103983152806563e+01,		3.112662967613065e+01,		3.121326688111671e+01,
		3.129974364481471e+01,		3.138606046713062e+01,		3.147221784609216e+01,		3.155821627785545e+01,		3.164405625671169e+01,
		3.172973827509383e+01,		3.181526282358326e+01,		3.190063039091652e+01,		3.198584146399200e+01,		3.207089652787660e+01,
		3.215579606581248e+01,		3.224054055922375e+01,		3.232513048772319e+01,		3.240956632911893e+01,		3.249384855942120e+01,
		3.257797765284899e+01,		3.266195408183678e+01,		3.274577831704128e+01,		3.282945082734800e+01,		3.291297207987814e+01,
		3.299634253999507e+01,		3.307956267131118e+01,		3.316263293569443e+01,		3.324555379327515e+01,		3.332832570245252e+01,
		3.341094911990143e+01,		3.349342450057897e+01,		3.357575229773114e+01,		3.365793296289943e+01,		3.373996694592746e+01,
		3.382185469496761e+01,		3.390359665648757e+01,		3.398519327527688e+01,		3.406664499445361e+01,		3.414795225547083e+01,
		3.422911549812321e+01,		3.431013516055343e+01,		3.439101167925885e+01,		3.447174548909791e+01,		3.455233702329662e+01,
		3.463278671345510e+01,		3.471309498955394e+01,		3.479326227996067e+01,		3.487328901143623e+01,		3.495317560914133e+01,
		3.503292249664283e+01,		3.511253009592012e+01,		3.519199882737152e+01,		3.527132910982055e+01,		3.535052136052228e+01,
		3.542957599516964e+01,		3.550849342789969e+01,		3.558727407129989e+01,		3.566591833641431e+01,		3.574442663274995e+01,
		3.582279936828285e+01,		3.590103694946429e+01,		3.597913978122705e+01,		3.605710826699145e+01,		3.613494280867153e+01,
		3.621264380668116e+01,		3.629021165994013e+01,		3.636764676588022e+01,		3.644494952045123e+01,		3.652212031812701e+01,
		3.659915955191153e+01,		3.667606761334476e+01,		3.675284489250876e+01,		3.682949177803351e+01,		3.690600865710294e+01,
		3.698239591546074e+01,		3.705865393741630e+01,		3.713478310585061e+01,		3.721078380222196e+01,		3.728665640657195e+01,
		3.736240129753111e+01,		3.743801885232483e+01,		3.751350944677898e+01,		3.758887345532576e+01,		3.766411125100932e+01,
		3.773922320549154e+01,		3.781420968905762e+01,		3.788907107062177e+01,		3.796380771773283e+01,		3.803841999657990e+01,
		3.811290827199785e+01,		3.818727290747294e+01,		3.826151426514842e+01,		3.833563270582989e+01,		3.840962858899095e+01,
		3.848350227277854e+01,		3.855725411401855e+01,		3.863088446822113e+01,		3.870439368958609e+01,		3.877778213100844e+01,
		3.885105014408360e+01,		3.892419807911277e+01,		3.899722628510830e+01,		3.907013510979905e+01,		3.914292489963551e+01,
		3.921559599979521e+01,		3.928814875418782e+01,		3.936058350546053e+01,		3.943290059500313e+01,		3.950510036295317e+01,
		3.957718314820124e+01,		3.964914928839596e+01,		3.972099911994918e+01,		3.979273297804099e+01,		3.986435119662489e+01,
		3.993585410843279e+01,		4.000724204497997e+01,		4.007851533657021e+01,		4.014967431230069e+01,		4.022071930006697e+01,
		4.029165062656789e+01,		4.036246861731065e+01,		4.043317359661551e+01,		4.050376588762077e+01,		4.057424581228766e+01,
		4.064461369140512e+01,		4.071486984459461e+01,		4.078501459031499e+01,		4.085504824586720e+01,		4.092497112739910e+01,
		4.099478354991015e+01,		4.106448582725613e+01,		4.113407827215391e+01,		4.120356119618604e+01,		4.127293490980543e+01,
		4.134219972234002e+01,		4.141135594199739e+01,		4.148040387586931e+01,		4.154934382993638e+01,		4.161817610907254e+01,
		4.168690101704965e+01,		4.175551885654198e+01,		4.182402992913071e+01,		4.189243453530848e+01,		4.196073297448372e+01,
		4.202892554498519e+01,		4.209701254406639e+01,		4.216499426790998e+01,		4.223287101163206e+01,		4.230064306928666e+01,
		4.236831073387012e+01,		4.243587429732521e+01,		4.250333405054562e+01,		4.257069028338026e+01,		4.263794328463738e+01,
		4.270509334208898e+01,		4.277214074247499e+01,		4.283908577150745e+01,		4.290592871387479e+01,		4.297266985324591e+01,
		4.303930947227444e+01,		4.310584785260281e+01,		4.317228527486643e+01,		4.323862201869779e+01,		4.330485836273051e+01,
		4.337099458460347e+01,		4.343703096096482e+01,		4.350296776747606e+01,		4.356880527881604e+01,		4.363454376868494e+01,
		4.370018350980826e+01,		4.376572477394087e+01,		4.383116783187087e+01,		4.389651295342354e+01,		4.396176040746528e+01,
		4.402691046190751e+01,		4.409196338371054e+01,		4.415691943888742e+01,		4.422177889250784e+01,		4.428654200870192e+01,
		4.435120905066406e+01,		4.441578028065666e+01,		4.448025596001405e+01,		4.454463634914609e+01,		4.460892170754206e+01,
		4.467311229377428e+01,		4.473720836550191e+01,		4.480121017947467e+01,		4.486511799153637e+01,		4.492893205662879e+01,
		4.499265262879518e+01,		4.505627996118396e+01,		4.511981430605237e+01,		4.518325591476996e+01,		4.524660503782233e+01,
		4.530986192481461e+01,		4.537302682447505e+01,		4.543609998465853e+01,		4.549908165235018e+01,		4.556197207366874e+01,
		4.562477149387026e+01,		4.568748015735132e+01,		4.575009830765281e+01,		4.581262618746315e+01,		4.587506403862177e+01,
		4.593741210212261e+01,		4.599967061811746e+01,		4.606183982591937e+01,		4.612391996400604e+01,		4.618591127002319e+01,
		4.624781398078787e+01,		4.630962833229185e+01,		4.637135455970486e+01,		4.643299289737799e+01,		4.649454357884694e+01,
		4.655600683683525e+01,		4.661738290325768e+01,		4.667867200922333e+01,		4.673987438503894e+01,		4.680099026021211e+01,
		4.686201986345451e+01,		4.692296342268506e+01,		4.698382116503311e+01,		4.704459331684159e+01,		4.710528010367020e+01,
		4.716588175029853e+01,		4.722639848072915e+01,		4.728683051819083e+01,		4.734717808514142e+01,		4.740744140327124e+01,
		4.746762069350587e+01,		4.752771617600938e+01,		4.758772807018728e+01,		4.764765659468961e+01,		4.770750196741395e+01
	},
	{
		7.663880684003320e-02,		2.298097544874535e-01,		3.826343098768710e-01,		5.351133279071487e-01,		6.872476474943722e-01,
		8.390380926354414e-01,		9.904854734228362e-01,		1.141590587012430e+00,		1.292354218546169e+00,		1.442777142031337e+00,
		1.592860121178094e+00,		1.742603910196899e+00,		1.892009254557347e+00,		2.041076891709940e+00,		2.189807551772210e+00,
		2.338201958180587e+00,		2.486260828309354e+00,		2.633984874057958e+00,		2.781374802407940e+00,		2.928431315950664e+00,
		3.075155113387001e+00,		3.221546890000094e+00,		3.367607338102262e+00,		3.513337147457074e+00,		3.658737005677622e+00,
		3.803807598601915e+00,		3.948549610646366e+00,		4.092963725138219e+00,		4.237050624627843e+00,		4.380810991181658e+00,
		4.524245506656579e+00,		4.667354852956665e+00,		4.810139712272805e+00,		4.952600767306105e+00,		5.094738701475721e+00,
		5.236554199111755e+00,		5.378047945633928e+00,		5.519220627716611e+00,		5.660072933440818e+00,		5.800605552433781e+00,
		5.940819175996622e+00,		6.080714497220703e+00,		6.220292211093138e+00,		6.359553014591999e+00,		6.498497606771702e+00,
		6.637126688838999e+00,		6.775440964220097e+00,		6.913441138619245e+00,		7.051127920069300e+00,		7.188502018974604e+00,
		7.325564148146588e+00,		7.462315022832487e+00,		7.598755360737472e+00,		7.734885882040629e+00,		7.870707309405006e+00,
		8.006220367982159e+00,		8.141425785411425e+00,		8.276324291814223e+00,		8.410916619783736e+00,		8.545203504370120e+00,
		8.679185683061633e+00,		8.812863895761852e+00,		8.946238884763211e+00,		9.079311394717177e+00,		9.212082172601166e+00,
		9.344551967682493e+00,		9.476721531479559e+00,		9.608591617720398e+00,		9.740162982298845e+00,		9.871436383228488e+00,
		1.000241258059452e+01,		1.013309233650374e+01,		1.026347641503275e+01,		1.039356558217466e+01,		1.052336060578423e+01,
		1.065286225552176e+01,		1.078207130279582e+01,		1.091098852070482e+01,		1.103961468397775e+01,		1.116795056891398e+01,
		1.129599695332245e+01,		1.142375461646012e+01,		1.155122433896995e+01,		1.167840690281847e+01,		1.180530309123290e+01,
		1.193191368863817e+01,		1.205823948059353e+01,		1.218428125372924e+01,		1.231003979568314e+01,		1.243551589503720e+01,
		1.256071034125425e+01,		1.268562392461475e+01,		1.281025743615384e+01,		1.293461166759860e+01,		1.305868741130564e+01,
		1.318248546019901e+01,		1.330600660770853e+01,		1.342925164770851e+01,		1.355222137445701e+01,		1.367491658253556e+01,
		1.379733806678938e+01,		1.391948662226832e+01,		1.404136304416819e+01,		1.416296812777291e+01,		1.428430266839722e+01,
		1.440536746133004e+01,		1.452616330177859e+01,		1.464669098481321e+01,		1.476695130531289e+01,		1.488694505791152e+01,
		1.500667303694503e+01,		1.512613603639913e+01,		1.524533484985798e+01,		1.536427027045356e+01,		1.548294309081595e+01,
		1.560135410302427e+01,		1.571950409855863e+01,		1.583739386825274e+01,		1.595502420224744e+01,		1.607239588994505e+01,
		1.618950971996450e+01,		1.630636648009744e+01,		1.642296695726496e+01,		1.653931193747540e+01,		1.665540220578280e+01,
		1.677123854624630e+01,		1.688682174189031e+01,		1.700215257466556e+01,		1.711723182541096e+01,		1.723206027381623e+01,
		1.734663869838547e+01,		1.746096787640137e+01,		1.757504858389045e+01,		1.768888159558891e+01,		1.780246768490932e+01,
		1.791580762390822e+01,		1.802890218325434e+01,		1.814175213219768e+01,		1.825435823853939e+01,		1.836672126860229e+01,
		1.847884198720231e+01,		1.859072115762051e+01,		1.870235954157595e+01,		1.881375789919924e+01,		1.892491698900679e+01,
		1.903583756787581e+01,		1.914652039102003e+01,		1.925696621196603e+01,		1.936717578253030e+01,		1.947714985279697e+01,
		1.958688917109622e+01,		1.969639448398329e+01,		1.980566653621822e+01,		1.991470607074609e+01,		2.002351382867802e+01,
		2.013209054927272e+01,		2.024043696991863e+01,		2.034855382611666e+01,		2.045644185146360e+01,		2.056410177763593e+01,
		2.067153433437437e+01,		2.077874024946888e+01,		2.088572024874425e+01,		2.099247505604620e+01,		2.109900539322805e+01,
		2.120531198013777e+01,		2.131139553460581e+01,		2.141725677243311e+01,		2.152289640737978e+01,		2.162831515115430e+01,
		2.173351371340301e+01,		2.183849280170021e+01,		2.194325312153870e+01,		2.204779537632062e+01,		2.215212026734897e+01,
		2.225622849381931e+01,		2.236012075281200e+01,		2.246379773928484e+01,		2.256726014606610e+01,		2.267050866384793e+01,
		2.277354398118013e+01,		2.287636678446437e+01,		2.297897775794868e+01,		2.308137758372237e+01,		2.318356694171126e+01,
		2.328554650967325e+01,		2.338731696319431e+01,		2.348887897568461e+01,		2.359023321837516e+01,		2.369138036031471e+01,
		2.379232106836683e+01,		2.389305600720749e+01,		2.399358583932278e+01,		2.409391122500697e+01,		2.419403282236079e+01,
		2.429395128729014e+01,		2.439366727350482e+01,		2.449318143251778e+01,		2.459249441364435e+01,		2.469160686400196e+01,
		2.479051942850997e+01,		2.488923274988970e+01,		2.498774746866481e+01,		2.508606422316177e+01,		2.518418364951064e+01,
		2.528210638164603e+01,		2.537983305130823e+01,		2.547736428804458e+01,		2.557470071921103e+01,		2.567184296997383e+01,
		2.576879166331151e+01,		2.586554742001694e+01,		2.596211085869960e+01,		2.605848259578803e+01,		2.615466324553242e+01,
		2.625065342000737e+01,		2.634645372911482e+01,		2.644206478058703e+01,		2.653748717998995e+01,		2.663272153072639e+01,
		2.672776843403960e+01,		2.682262848901690e+01,		2.691730229259337e+01,		2.701179043955576e+01,		2.710609352254644e+01,
		2.720021213206757e+01,		2.729414685648526e+01,		2.738789828203395e+01,		2.748146699282081e+01,		2.757485357083031e+01,
		2.766805859592884e+01,		2.776108264586946e+01,		2.785392629629673e+01,		2.794659012075161e+01,		2.803907469067648e+01,
		2.813138057542024e+01,		2.822350834224347e+01,		2.831545855632368e+01,		2.840723178076061e+01,		2.849882857658168e+01,
		2.859024950274742e+01,		2.868149511615701e+01,		2.877256597165384e+01,		2.886346262203126e+01,		2.895418561803822e+01,
		2.904473550838509e+01,		2.913511283974941e+01,		2.922531815678196e+01,		2.931535200211247e+01,		2.940521491635574e+01,
		2.949490743811763e+01,		2.958443010400117e+01,		2.967378344861262e+01,		2.976296800456765e+01,		2.985198430249757e+01,
		2.994083287105545e+01,		3.002951423692257e+01,		3.011802892481452e+01,		3.020637745748767e+01,		3.029456035574545e+01,
		3.038257813844480e+01,		3.047043132250250e+01,		3.055812042290173e+01,		3.064564595269838e+01,		3.073300842302766e+01,
		3.082020834311055e+01,		3.090724622026030e+01,		3.099412255988902e+01,		3.108083786551421e+01,		3.116739263876532e+01,
		3.125378737939036e+01,		3.134002258526250e+01,		3.142609875238661e+01,		3.151201637490597e+01,		3.159777594510888e+01,
		3.168337795343523e+01,		3.176882288848323e+01,		3.185411123701599e+01,		3.193924348396820e+01,		3.202422011245281e+01,
		3.210904160376767e+01,		3.219370843740216e+01,		3.227822109104392e+01,		3.236258004058546e+01,		3.244678576013087e+01,
		3.253083872200243e+01,		3.261473939674730e+01,		3.269848825314420e+01,		3.278208575821002e+01,		3.286553237720650e+01,
		3.294882857364686e+01,		3.303197480930245e+01,		3.311497154420935e+01,		3.319781923667509e+01,		3.328051834328513e+01,
		3.336306931890957e+01,		3.344547261670976e+01,		3.352772868814480e+01,		3.360983798297821e+01,		3.369180094928448e+01,
		3.377361803345557e+01,		3.385528968020763e+01,		3.393681633258731e+01,		3.401819843197844e+01,		3.409943641810851e+01,
		3.418053072905516e+01,		3.426148180125267e+01,		3.434229006949842e+01,		3.442295596695939e+01,		3.450347992517856e+01,
		3.458386237408138e+01,		3.466410374198212e+01,		3.474420445559033e+01,		3.482416494001724e+01,		3.490398561878200e+01,
		3.498366691381823e+01,		3.506320924548013e+01,		3.514261303254899e+01,		3.522187869223937e+01,		3.530100664020542e+01,
		3.537999729054712e+01,		3.545885105581657e+01,		3.553756834702420e+01,		3.561614957364493e+01,		3.569459514362441e+01,
		3.577290546338521e+01,		3.585108093783290e+01,		3.592912197036222e+01,		3.600702896286324e+01,		3.608480231572737e+01,
		3.616244242785347e+01,		3.623994969665392e+01,		3.631732451806064e+01,		3.639456728653107e+01,		3.647167839505423e+01,
		3.654865823515669e+01,		3.662550719690839e+01,		3.670222566892874e+01,		3.677881403839250e+01,		3.685527269103554e+01,
		3.693160201116088e+01,		3.700780238164445e+01,		3.708387418394091e+01,		3.715981779808948e+01,		3.723563360271976e+01,
		3.731132197505740e+01,		3.738688329092993e+01,		3.746231792477249e+01,		3.753762624963343e+01,		3.761280863718012e+01,
		3.768786545770449e+01,		3.776279708012874e+01,		3.783760387201094e+01,		3.791228619955060e+01,		3.798684442759428e+01,
		3.806127891964113e+01,		3.813559003784840e+01,		3.820977814303694e+01,		3.828384359469671e+01,		3.835778675099228e+01,
		3.843160796876818e+01,		3.850530760355447e+01,		3.857888600957190e+01,		3.865234353973759e+01,		3.872568054567010e+01,
		3.879889737769501e+01,		3.887199438485003e+01,		3.894497191489048e+01,		3.901783031429440e+01,		3.909056992826788e+01,
		3.916319110075032e+01,		3.923569417441956e+01,		3.930807949069711e+01,		3.938034738975330e+01,		3.945249821051249e+01,
		3.952453229065808e+01,		3.959644996663764e+01,		3.966825157366814e+01,		3.973993744574074e+01,		3.981150791562611e+01,
		3.988296331487921e+01,		3.995430397384449e+01,		4.002553022166069e+01,		4.009664238626593e+01,		4.016764079440259e+01,
		4.023852577162214e+01,		4.030929764229024e+01,		4.037995672959141e+01,		4.045050335553400e+01,		4.052093784095496e+01,
		4.059126050552469e+01,		4.066147166775180e+01,		4.073157164498795e+01,		4.080156075343249e+01,		4.087143930813727e+01,
		4.094120762301133e+01,		4.101086601082562e+01,		4.108041478321756e+01,		4.114985425069587e+01,		4.121918472264502e+01,
		4.128840650732999e+01,		4.135751991190072e+01,		4.142652524239682e+01,		4.149542280375204e+01,		4.156421289979878e+01,
		4.163289583327268e+01,		4.170147190581709e+01,		4.176994141798748e+01,		4.183830466925598e+01,		4.190656195801576e+01,
		4.197471358158550e+01,		4.204275983621372e+01,		4.211070101708321e+01,		4.217853741831539e+01,		4.224626933297458e+01,
		4.231389705307247e+01,		4.238142086957220e+01,		4.244884107239293e+01,		4.251615795041385e+01,		4.258337179147853e+01,
		4.265048288239920e+01,		4.271749150896089e+01,		4.278439795592566e+01,		4.285120250703673e+01,		4.291790544502272e+01,
		4.298450705160166e+01,		4.305100760748527e+01,		4.311740739238292e+01,		4.318370668500582e+01,		4.324990576307103e+01,
		4.331600490330554e+01,		4.338200438145021e+01,		4.344790447226402e+01,		4.351370544952773e+01,		4.357940758604818e+01,
		4.364501115366205e+01,		4.371051642323990e+01,		4.377592366469003e+01,		4.384123314696248e+01,		4.390644513805281e+01,
		4.397155990500611e+01,		4.403657771392077e+01,		4.410149882995235e+01,		4.416632351731739e+01,		4.423105203929725e+01,
		4.429568465824188e+01,		4.436022163557365e+01,		4.442466323179103e+01,		4.448900970647237e+01,		4.455326131827966e+01,
		4.461741832496221e+01,		4.468148098336036e+01,		4.474544954940914e+01,		4.480932427814196e+01,		4.487310542369423e+01,
		4.493679323930701e+01,		4.500038797733067e+01,		4.506388988922841e+01,		4.512729922557989e+01,		4.519061623608478e+01,
		4.525384116956634e+01,		4.531697427397498e+01,		4.538001579639171e+01,		4.544296598303168e+01,		4.550582507924774e+01,
		4.556859332953380e+01,		4.563127097752839e+01,		4.569385826601806e+01,		4.575635543694083e+01,		4.581876273138958e+01,
		4.588108038961553e+01,		4.594330865103152e+01,		4.600544775421545e+01,		4.606749793691367e+01,		4.612945943604419e+01,
		4.619133248770021e+01,		4.625311732715326e+01,		4.631481418885660e+01,		4.637642330644846e+01,		4.643794491275533e+01,
		4.649937923979524e+01,		4.656072651878094e+01,		4.662198698012322e+01,		4.668316085343402e+01,		4.674424836752979e+01,
		4.680524975043446e+01,		4.686616522938282e+01,		4.692699503082360e+01,		4.698773938042250e+01,		4.704839850306562e+01,
		4.710897262286221e+01,		4.716946196314812e+01,		4.722986674648864e+01,		4.729018719468170e+01,		4.735042352876097e+01,
		4.741057596899878e+01,		4.747064473490927e+01,		4.753063004525140e+01,		4.759053211803189e+01,		4.765035117050838e+01
	},
	{
		7.649297391458175e-02,		2.293727783057250e-01,		3.819072762532361e-01,		5.340973215605314e-01,		6.859437521680637e-01,
		8.374473912049916e-01,		9.886090479926419e-01,		1.139429519001622e+00,		1.289909588764360e+00,		1.440050030744787e+00,
		1.589851608166819e+00,		1.739315074803207e+00,		1.888441175726308e+00,		2.037230648022231e+00,		2.185684221469780e+00,
		2.333802619185575e+00,		2.481586558236645e+00,		2.629036750221780e+00,		2.776153901822862e+00,		2.922938715327352e+00,
		3.069391889123073e+00,		3.215514118166390e+00,		3.361306094424843e+00,		3.506768507295245e+00,		3.651902043998267e+00,
		3.796707389950396e+00,		3.941185229114253e+00,		4.085336244328114e+00,		4.229161117615486e+00,		4.372660530475601e+00,
		4.515835164155576e+00,		4.658685699905024e+00,		4.801212819213875e+00,		4.943417204034096e+00,		5.085299536986009e+00,
		5.226860501549861e+00,		5.368100782243307e+00,		5.509021064785419e+00,		5.649622036247786e+00,		5.789904385193333e+00,
		5.929868801803368e+00,		6.069515977993410e+00,		6.208846607518328e+00,		6.347861386067250e+00,		6.486561011348742e+00,
		6.624946183166750e+00,		6.763017603487678e+00,		6.900775976499075e+00,		7.038222008660359e+00,		7.175356408745943e+00,
		7.312179887881125e+00,		7.448693159571180e+00,		7.584896939723933e+00,		7.720791946666220e+00,		7.856378901154471e+00,
		7.991658526379858e+00,		8.126631547968188e+00,		8.261298693974906e+00,		8.395660694875454e+00,		8.529718283551279e+00,
		8.663472195271705e+00,		8.796923167671988e+00,		8.930071940727688e+00,		9.062919256725699e+00,		9.195465860232074e+00,
		9.327712498056858e+00,		9.459659919216220e+00,		9.591308874891917e+00,		9.722660118388440e+00,		9.853714405087890e+00,
		9.984472492402844e+00,		1.011493513972731e+01,		1.024510310838592e+01,		1.037497716158163e+01,		1.050455806434183e+01,
		1.063384658346329e+01,		1.076284348745579e+01,		1.089154954648479e+01,		1.101996553231308e+01,		1.114809221824164e+01,
		1.127593037904976e+01,		1.140348079093448e+01,		1.153074423144960e+01,		1.165772147944415e+01,		1.178441331500053e+01,
		1.191082051937240e+01,		1.203694387492236e+01,		1.216278416505949e+01,		1.228834217417684e+01,		1.241361868758895e+01,
		1.253861449146943e+01,		1.266333037278869e+01,		1.278776711925180e+01,		1.291192551923668e+01,		1.303580636173251e+01,
		1.315941043627849e+01,		1.328273853290304e+01,		1.340579144206329e+01,		1.352856995458517e+01,		1.365107486160392e+01,
		1.377330695450511e+01,		1.389526702486629e+01,		1.401695586439914e+01,		1.413837426489231e+01,		1.425952301815486e+01,
		1.438040291596036e+01,		1.450101474999168e+01,		1.462135931178648e+01,		1.474143739268343e+01,		1.486124978376914e+01,
		1.498079727582583e+01,		1.510008065927987e+01,		1.521910072415089e+01,		1.533785826000186e+01,		1.545635405588990e+01,
		1.557458890031785e+01,		1.569256358118667e+01,		1.581027888574871e+01,		1.592773560056170e+01,		1.604493451144366e+01,
		1.616187640342850e+01,		1.627856206072262e+01,		1.639499226666217e+01,		1.651116780367125e+01,		1.662708945322086e+01,
		1.674275799578874e+01,		1.685817421081992e+01,		1.697333887668830e+01,		1.708825277065878e+01,		1.720291666885040e+01,
		1.731733134620019e+01,		1.743149757642793e+01,		1.754541613200149e+01,		1.765908778410325e+01,		1.777251330259706e+01,
		1.788569345599615e+01,		1.799862901143167e+01,		1.811132073462216e+01,		1.822376938984360e+01,		1.833597573990033e+01,
		1.844794054609672e+01,		1.855966456820948e+01,		1.867114856446077e+01,		1.878239329149205e+01,		1.889339950433853e+01,
		1.900416795640445e+01,		1.911469939943901e+01,		1.922499458351286e+01,		1.933505425699547e+01,		1.944487916653305e+01,
		1.955447005702708e+01,		1.966382767161364e+01,		1.977295275164315e+01,		1.988184603666099e+01,		1.999050826438852e+01,
		2.009894017070487e+01,		2.020714248962920e+01,		2.031511595330359e+01,		2.042286129197660e+01,		2.053037923398724e+01,
		2.063767050574962e+01,		2.074473583173810e+01,		2.085157593447295e+01,		2.095819153450663e+01,		2.106458335041050e+01,
		2.117075209876210e+01,		2.127669849413284e+01,		2.138242324907637e+01,		2.148792707411723e+01,		2.159321067774005e+01,
		2.169827476637927e+01,		2.180312004440925e+01,		2.190774721413482e+01,		2.201215697578232e+01,		2.211635002749105e+01,
		2.222032706530507e+01,		2.232408878316559e+01,		2.242763587290349e+01,		2.253096902423255e+01,		2.263408892474280e+01,
		2.273699625989438e+01,		2.283969171301178e+01,		2.294217596527839e+01,		2.304444969573141e+01,		2.314651358125712e+01,
		2.324836829658650e+01,		2.335001451429120e+01,		2.345145290477973e+01,		2.355268413629410e+01,		2.365370887490669e+01,
		2.375452778451745e+01,		2.385514152685136e+01,		2.395555076145625e+01,		2.405575614570077e+01,		2.415575833477284e+01,
		2.425555798167816e+01,		2.435515573723906e+01,		2.445455225009371e+01,		2.455374816669537e+01,		2.465274413131206e+01,
		2.475154078602638e+01,		2.485013877073560e+01,		2.494853872315193e+01,		2.504674127880306e+01,		2.514474707103285e+01,
		2.524255673100235e+01,		2.534017088769081e+01,		2.543759016789713e+01,		2.553481519624135e+01,		2.563184659516633e+01,
		2.572868498493967e+01,		2.582533098365579e+01,		2.592178520723817e+01,		2.601804826944176e+01,		2.611412078185548e+01,
		2.621000335390510e+01,		2.630569659285599e+01,		2.640120110381617e+01,		2.649651748973955e+01,		2.659164635142917e+01,
		2.668658828754070e+01,		2.678134389458602e+01,		2.687591376693687e+01,		2.697029849682876e+01,		2.706449867436489e+01,
		2.715851488752023e+01,		2.725234772214567e+01,		2.734599776197238e+01,		2.743946558861613e+01,		2.753275178158187e+01,
		2.762585691826825e+01,		2.771878157397243e+01,		2.781152632189470e+01,		2.790409173314351e+01,		2.799647837674038e+01,
		2.808868681962493e+01,		2.818071762666002e+01,		2.827257136063698e+01,		2.836424858228087e+01,		2.845574985025581e+01,
		2.854707572117045e+01,		2.863822674958343e+01,		2.872920348800893e+01,		2.882000648692232e+01,		2.891063629476578e+01,
		2.900109345795409e+01,		2.909137852088036e+01,		2.918149202592193e+01,		2.927143451344621e+01,		2.936120652181665e+01,
		2.945080858739869e+01,		2.954024124456583e+01,		2.962950502570567e+01,		2.971860046122602e+01,		2.980752807956108e+01,
		2.989628840717760e+01,		2.998488196858109e+01,		3.007330928632209e+01,		3.016157088100245e+01,		3.024966727128166e+01,
		3.033759897388314e+01,		3.042536650360068e+01,		3.051297037330476e+01,		3.060041109394902e+01,		3.068768917457668e+01,
		3.077480512232697e+01,		3.086175944244167e+01,		3.094855263827150e+01,		3.103518521128276e+01,		3.112165766106376e+01,
		3.120797048533144e+01,		3.129412417993775e+01,		3.138011923887649e+01,		3.146595615428961e+01,		3.155163541647397e+01,
		3.163715751388790e+01,		3.172252293315768e+01,		3.180773215908433e+01,		3.189278567465006e+01,		3.197768396102502e+01,
		3.206242749757377e+01,		3.214701676186201e+01,		3.223145222966318e+01,		3.231573437496503e+01,		3.239986366997631e+01,
		3.248384058513333e+01,		3.256766558910662e+01,		3.265133914880748e+01,		3.273486172939472e+01,		3.281823379428112e+01,
		3.290145580514012e+01,		3.298452822191238e+01,		3.306745150281241e+01,		3.315022610433509e+01,		3.323285248126232e+01,
		3.331533108666955e+01,		3.339766237193233e+01,		3.347984678673285e+01,		3.356188477906656e+01,		3.364377679524861e+01,
		3.372552327992042e+01,		3.380712467605614e+01,		3.388858142496925e+01,		3.396989396631891e+01,		3.405106273811657e+01,
		3.413208817673230e+01,		3.421297071690135e+01,		3.429371079173049e+01,		3.437430883270447e+01,		3.445476526969249e+01,
		3.453508053095448e+01,		3.461525504314749e+01,		3.469528923133214e+01,		3.477518351897887e+01,		3.485493832797430e+01,
		3.493455407862754e+01,		3.501403118967651e+01,		3.509337007829419e+01,		3.517257116009484e+01,		3.525163484914034e+01,
		3.533056155794634e+01,		3.540935169748847e+01,		3.548800567720857e+01,		3.556652390502082e+01,		3.564490678731794e+01,
		3.572315472897726e+01,		3.580126813336689e+01,		3.587924740235178e+01,		3.595709293629982e+01,		3.603480513408787e+01,
		3.611238439310782e+01,		3.618983110927260e+01,		3.626714567702223e+01,		3.634432848932964e+01,		3.642137993770682e+01,
		3.649830041221066e+01,		3.657509030144883e+01,		3.665174999258581e+01,		3.672827987134859e+01,		3.680468032203269e+01,
		3.688095172750787e+01,		3.695709446922402e+01,		3.703310892721694e+01,		3.710899548011412e+01,		3.718475450514043e+01,
		3.726038637812391e+01,		3.733589147350148e+01,		3.741127016432460e+01,		3.748652282226496e+01,		3.756164981762012e+01,
		3.763665151931914e+01,		3.771152829492814e+01,		3.778628051065596e+01,		3.786090853135968e+01,		3.793541272055012e+01,
		3.800979344039740e+01,		3.808405105173652e+01,		3.815818591407263e+01,		3.823219838558669e+01,		3.830608882314083e+01,
		3.837985758228366e+01,		3.845350501725584e+01,		3.852703148099530e+01,		3.860043732514271e+01,		3.867372290004668e+01,
		3.874688855476919e+01,		3.881993463709075e+01,		3.889286149351580e+01,		3.896566946927781e+01,		3.903835890834458e+01,
		3.911093015342348e+01,		3.918338354596651e+01,		3.925571942617557e+01,		3.932793813300748e+01,		3.940004000417924e+01,
		3.947202537617301e+01,		3.954389458424118e+01,		3.961564796241154e+01,		3.968728584349214e+01,		3.975880855907647e+01,
		3.983021643954829e+01,		3.990150981408676e+01,		3.997268901067120e+01,		4.004375435608621e+01,		4.011470617592649e+01,
		4.018554479460163e+01,		4.025627053534117e+01,		4.032688372019927e+01,		4.039738467005962e+01,		4.046777370464029e+01,
		4.053805114249836e+01,		4.060821730103487e+01,		4.067827249649938e+01,		4.074821704399488e+01,		4.081805125748232e+01,
		4.088777544978539e+01,		4.095738993259518e+01,		4.102689501647481e+01,		4.109629101086401e+01,		4.116557822408382e+01,
		4.123475696334111e+01,		4.130382753473308e+01,		4.137279024325198e+01,		4.144164539278947e+01,		4.151039328614119e+01,
		4.157903422501131e+01,		4.164756851001685e+01,		4.171599644069228e+01,		4.178431831549386e+01,		4.185253443180404e+01,
		4.192064508593595e+01,		4.198865057313763e+01,		4.205655118759655e+01,		4.212434722244377e+01,		4.219203896975841e+01,
		4.225962672057182e+01,		4.232711076487200e+01,		4.239449139160764e+01,		4.246176888869267e+01,		4.252894354301019e+01,
		4.259601564041684e+01,		4.266298546574696e+01,		4.272985330281676e+01,		4.279661943442837e+01,		4.286328414237418e+01,
		4.292984770744079e+01,		4.299631040941308e+01,		4.306267252707849e+01,		4.312893433823088e+01,		4.319509611967467e+01,
		4.326115814722881e+01,		4.332712069573089e+01,		4.339298403904102e+01,		4.345874845004588e+01,		4.352441420066263e+01,
		4.358998156184292e+01,		4.365545080357666e+01,		4.372082219489616e+01,		4.378609600387976e+01,		4.385127249765597e+01,
		4.391635194240706e+01,		4.398133460337313e+01,		4.404622074485572e+01,		4.411101063022184e+01,		4.417570452190756e+01,
		4.424030268142189e+01,		4.430480536935053e+01,		4.436921284535957e+01,		4.443352536819925e+01,		4.449774319570763e+01,
		4.456186658481430e+01,		4.462589579154412e+01,		4.468983107102077e+01,		4.475367267747043e+01,		4.481742086422543e+01,
		4.488107588372790e+01,		4.494463798753326e+01,		4.500810742631385e+01,		4.507148444986256e+01,		4.513476930709630e+01,
		4.519796224605953e+01,		4.526106351392784e+01,		4.532407335701142e+01,		4.538699202075851e+01,		4.544981974975897e+01,
		4.551255678774761e+01,		4.557520337760776e+01,		4.563775976137464e+01,		4.570022618023874e+01,		4.576260287454924e+01,
		4.582489008381750e+01,		4.588708804672024e+01,		4.594919700110300e+01,		4.601121718398353e+01,		4.607314883155500e+01,
		4.613499217918941e+01,		4.619674746144081e+01,		4.625841491204858e+01,		4.631999476394088e+01,		4.638148724923759e+01,
		4.644289259925381e+01,		4.650421104450297e+01,		4.656544281470009e+01,		4.662658813876493e+01,		4.668764724482521e+01,
		4.674862036021975e+01,		4.680950771150171e+01,		4.687030952444159e+01,		4.693102602403047e+01,		4.699165743448313e+01,
		4.705220397924106e+01,		4.711266588097565e+01,		4.717304336159122e+01,		4.723333664222805e+01,		4.729354594326550e+01,
		4.735367148432501e+01,		4.741371348427312e+01,		4.747367216122442e+01,		4.753354773254474e+01,		4.759334041485393e+01
	},
	{
		7.634769509668370e-02,		2.289374622167348e-01,		3.811830042353269e-01,		5.330851738389715e-01,		6.846448079698413e-01,
		8.358627288656703e-01,		9.867397450520623e-01,		1.137276652289037e+00,		1.287474234473569e+00,		1.437333264499808e+00,
		1.586854505078608e+00,		1.736038709517931e+00,		1.884886622465646e+00,		2.033398980616135e+00,		2.181576513382166e+00,
		2.329419943533328e+00,		2.476929987802355e+00,		2.624107357460582e+00,		2.770952758863748e+00,		2.917466893969302e+00,
		3.063650460826342e+00,		3.209504154039261e+00,		3.355028665206162e+00,		3.500224683333031e+00,		3.645092895224640e+00,
		3.789633985853155e+00,		3.933848638705295e+00,		4.077737536108962e+00,		4.221301359540169e+00,		4.364540789911070e+00,
		4.507456507839905e+00,		4.650049193903570e+00,		4.792319528873603e+00,		4.934268193936226e+00,		5.075895870897186e+00,
		5.217203242372000e+00,		5.358190991962249e+00,		5.498859804418577e+00,		5.639210365790905e+00,		5.779243363566490e+00,
		5.918959486796346e+00,		6.058359426210570e+00,		6.197443874323073e+00,		6.336213525526210e+00,		6.474669076175753e+00,
		6.612811224666756e+00,		6.750640671500598e+00,		6.888158119343771e+00,		7.025364273078749e+00,		7.162259839847326e+00,
		7.298845529086828e+00,		7.435122052559541e+00,		7.571090124375726e+00,		7.706750461010530e+00,		7.842103781315132e+00,
		7.977150806522435e+00,		8.111892260247606e+00,		8.246328868483724e+00,		8.380461359592866e+00,		8.514290464292809e+00,
		8.647816915639732e+00,		8.781041449007006e+00,		8.913964802060443e+00,		9.046587714730151e+00,		9.178910929179228e+00,
		9.310935189769495e+00,		9.442661243024535e+00,		9.574089837590076e+00,		9.705221724192079e+00,		9.836057655592564e+00,
		9.966598386543414e+00,		1.009684467373831e+01,		1.022679727576292e+01,		1.035645695304351e+01,		1.048582446779409e+01,
		1.061490058396232e+01,		1.074368606717414e+01,		1.087218168467735e+01,		1.100038820528438e+01,		1.112830639931396e+01,
		1.125593703853231e+01,		1.138328089609359e+01,		1.151033874647973e+01,		1.163711136543999e+01,		1.176359952992997e+01,
		1.188980401805050e+01,		1.201572560898620e+01,		1.214136508294395e+01,		1.226672322109136e+01,		1.239180080549511e+01,
		1.251659861905946e+01,		1.264111744546485e+01,		1.276535806910668e+01,		1.288932127503427e+01,		1.301300784889020e+01,
		1.313641857684987e+01,		1.325955424556151e+01,		1.338241564208652e+01,		1.350500355384029e+01,		1.362731876853357e+01,
		1.374936207411421e+01,		1.387113425870957e+01,		1.399263611056943e+01,		1.411386841800958e+01,		1.423483196935589e+01,
		1.435552755288918e+01,		1.447595595679074e+01,		1.459611796908836e+01,		1.471601437760334e+01,		1.483564596989799e+01,
		1.495501353322398e+01,		1.507411785447146e+01,		1.519295972011877e+01,		1.531153991618319e+01,		1.542985922817220e+01,
		1.554791844103573e+01,		1.566571833911906e+01,		1.578325970611663e+01,		1.590054332502656e+01,		1.601756997810605e+01,
		1.613434044682755e+01,		1.625085551183576e+01,		1.636711595290542e+01,		1.648312254889994e+01,		1.659887607773084e+01,
		1.671437731631795e+01,		1.682962704055054e+01,		1.694462602524911e+01,		1.705937504412810e+01,		1.717387486975929e+01,
		1.728812627353616e+01,		1.740213002563886e+01,		1.751588689500007e+01,		1.762939764927170e+01,		1.774266305479212e+01,
		1.785568387655454e+01,		1.796846087817573e+01,		1.808099482186587e+01,		1.819328646839892e+01,		1.830533657708376e+01,
		1.841714590573618e+01,		1.852871521065148e+01,		1.864004524657778e+01,		1.875113676669016e+01,		1.886199052256540e+01,
		1.897260726415739e+01,		1.908298773977334e+01,		1.919313269605055e+01,		1.930304287793391e+01,		1.941271902865404e+01,
		1.952216188970603e+01,		1.963137220082893e+01,		1.974035069998577e+01,		1.984909812334417e+01,		1.995761520525777e+01,
		2.006590267824791e+01,		2.017396127298627e+01,		2.028179171827783e+01,		2.038939474104452e+01,		2.049677106630939e+01,
		2.060392141718136e+01,		2.071084651484053e+01,		2.081754707852389e+01,		2.092402382551180e+01,		2.103027747111474e+01,
		2.113630872866070e+01,		2.124211830948306e+01,		2.134770692290888e+01,		2.145307527624777e+01,		2.155822407478115e+01,
		2.166315402175206e+01,		2.176786581835526e+01,		2.187236016372795e+01,		2.197663775494085e+01,		2.208069928698963e+01,
		2.218454545278694e+01,		2.228817694315463e+01,		2.239159444681657e+01,		2.249479865039169e+01,		2.259779023838751e+01,
		2.270056989319406e+01,		2.280313829507806e+01,		2.290549612217752e+01,		2.300764405049679e+01,		2.310958275390172e+01,
		2.321131290411538e+01,		2.331283517071403e+01,		2.341415022112333e+01,		2.351525872061501e+01,		2.361616133230374e+01,
		2.371685871714432e+01,		2.381735153392919e+01,		2.391764043928623e+01,		2.401772608767678e+01,		2.411760913139399e+01,
		2.421729022056144e+01,		2.431677000313194e+01,		2.441604912488672e+01,		2.451512822943468e+01,		2.461400795821211e+01,
		2.471268895048241e+01,		2.481117184333625e+01,		2.490945727169177e+01,		2.500754586829510e+01,		2.510543826372114e+01,
		2.520313508637437e+01,		2.530063696249007e+01,		2.539794451613555e+01,		2.549505836921173e+01,		2.559197914145478e+01,
		2.568870745043800e+01,		2.578524391157387e+01,		2.588158913811629e+01,		2.597774374116291e+01,		2.607370832965773e+01,
		2.616948351039373e+01,		2.626506988801581e+01,		2.636046806502370e+01,		2.645567864177518e+01,		2.655070221648928e+01,
		2.664553938524979e+01,		2.674019074200874e+01,		2.683465687859008e+01,		2.692893838469349e+01,		2.702303584789835e+01,
		2.711694985366767e+01,		2.721068098535234e+01,		2.730422982419529e+01,		2.739759694933591e+01,		2.749078293781452e+01,
		2.758378836457690e+01,		2.767661380247892e+01,		2.776925982229138e+01,		2.786172699270474e+01,		2.795401588033412e+01,
		2.804612704972427e+01,		2.813806106335468e+01,		2.822981848164469e+01,		2.832139986295882e+01,		2.841280576361196e+01,
		2.850403673787491e+01,		2.859509333797961e+01,		2.868597611412488e+01,		2.877668561448183e+01,		2.886722238519954e+01,
		2.895758697041078e+01,		2.904777991223770e+01,		2.913780175079767e+01,		2.922765302420909e+01,		2.931733426859732e+01,
		2.940684601810054e+01,		2.949618880487584e+01,		2.958536315910520e+01,		2.967436960900152e+01,		2.976320868081477e+01,
		2.985188089883810e+01,		2.994038678541406e+01,		3.002872686094074e+01,		3.011690164387804e+01,		3.020491165075399e+01,
		3.029275739617094e+01,		3.038043939281199e+01,		3.046795815144724e+01,		3.055531418094024e+01,		3.064250798825433e+01,
		3.072954007845907e+01,		3.081641095473670e+01,		3.090312111838852e+01,		3.098967106884142e+01,		3.107606130365435e+01,
		3.116229231852476e+01,		3.124836460729521e+01,		3.133427866195977e+01,		3.142003497267064e+01,		3.150563402774463e+01,
		3.159107631366980e+01,		3.167636231511183e+01,		3.176149251492081e+01,		3.184646739413764e+01,		3.193128743200065e+01,
		3.201595310595217e+01,		3.210046489164513e+01,		3.218482326294961e+01,		3.226902869195940e+01,		3.235308164899863e+01,
		3.243698260262829e+01,		3.252073201965285e+01,		3.260433036512680e+01,		3.268777810236123e+01,		3.277107569293037e+01,
		3.285422359667824e+01,		3.293722227172508e+01,		3.302007217447396e+01,		3.310277375961734e+01,		3.318532748014359e+01,
		3.326773378734347e+01,		3.334999313081672e+01,		3.343210595847851e+01,		3.351407271656603e+01,		3.359589384964483e+01,
		3.367756980061546e+01,		3.375910101071980e+01,		3.384048791954767e+01,		3.392173096504306e+01,		3.400283058351085e+01,
		3.408378720962291e+01,		3.416460127642480e+01,		3.424527321534195e+01,		3.432580345618614e+01,		3.440619242716184e+01,
		3.448644055487261e+01,		3.456654826432732e+01,		3.464651597894660e+01,		3.472634412056905e+01,		3.480603310945759e+01,
		3.488558336430572e+01,		3.496499530224370e+01,		3.504426933884491e+01,		3.512340588813200e+01,		3.520240536258311e+01,
		3.528126817313805e+01,		3.535999472920449e+01,		3.543858543866408e+01,		3.551704070787863e+01,		3.559536094169616e+01,
		3.567354654345705e+01,		3.575159791500014e+01,		3.582951545666869e+01,		3.590729956731650e+01,		3.598495064431393e+01,
		3.606246908355388e+01,		3.613985527945773e+01,		3.621710962498143e+01,		3.629423251162125e+01,		3.637122432941992e+01,
		3.644808546697234e+01,		3.652481631143161e+01,		3.660141724851476e+01,		3.667788866250873e+01,		3.675423093627605e+01,
		3.683044445126077e+01,		3.690652958749413e+01,		3.698248672360041e+01,		3.705831623680263e+01,		3.713401850292825e+01,
		3.720959389641484e+01,		3.728504279031591e+01,		3.736036555630634e+01,		3.743556256468821e+01,		3.751063418439630e+01,
		3.758558078300371e+01,		3.766040272672744e+01,		3.773510038043396e+01,		3.780967410764465e+01,		3.788412427054145e+01,
		3.795845122997225e+01,		3.803265534545629e+01,		3.810673697518982e+01,		3.818069647605131e+01,		3.825453420360692e+01,
		3.832825051211593e+01,		3.840184575453606e+01,		3.847532028252878e+01,		3.854867444646468e+01,		3.862190859542872e+01,
		3.869502307722558e+01,		3.876801823838475e+01,		3.884089442416600e+01,		3.891365197856437e+01,		3.898629124431550e+01,
		3.905881256290071e+01,		3.913121627455222e+01,		3.920350271825824e+01,		3.927567223176806e+01,		3.934772515159718e+01,
		3.941966181303234e+01,		3.949148255013660e+01,		3.956318769575428e+01,		3.963477758151604e+01,		3.970625253784388e+01,
		3.977761289395599e+01,		3.984885897787181e+01,		3.991999111641686e+01,		3.999100963522772e+01,		4.006191485875681e+01,
		4.013270711027732e+01,		4.020338671188807e+01,		4.027395398451820e+01,		4.034440924793215e+01,		4.041475282073424e+01,
		4.048498502037359e+01,		4.055510616314876e+01,		4.062511656421253e+01,		4.069501653757649e+01,		4.076480639611587e+01,
		4.083448645157406e+01,		4.090405701456732e+01,		4.097351839458938e+01,		4.104287090001602e+01,		4.111211483810966e+01,
		4.118125051502396e+01,		4.125027823580825e+01,		4.131919830441217e+01,		4.138801102369011e+01,		4.145671669540565e+01,
		4.152531562023614e+01,		4.159380809777700e+01,		4.166219442654626e+01,		4.173047490398891e+01,		4.179864982648127e+01,
		4.186671948933540e+01,		4.193468418680341e+01,		4.200254421208183e+01,		4.207029985731585e+01,		4.213795141360368e+01,
		4.220549917100081e+01,		4.227294341852423e+01,		4.234028444415669e+01,		4.240752253485095e+01,		4.247465797653390e+01,
		4.254169105411082e+01,		4.260862205146950e+01,		4.267545125148435e+01,		4.274217893602070e+01,		4.280880538593861e+01,
		4.287533088109727e+01,		4.294175570035890e+01,		4.300808012159283e+01,		4.307430442167954e+01,		4.314042887651474e+01,
		4.320645376101327e+01,		4.327237934911322e+01,		4.333820591377976e+01,		4.340393372700917e+01,		4.346956305983281e+01,
		4.353509418232088e+01,		4.360052736358656e+01,		4.366586287178967e+01,		4.373110097414065e+01,		4.379624193690444e+01,
		4.386128602540418e+01,		4.392623350402518e+01,		4.399108463621861e+01,		4.405583968450538e+01,		4.412049891047976e+01,
		4.418506257481329e+01,		4.424953093725844e+01,		4.431390425665234e+01,		4.437818279092043e+01,		4.444236679708028e+01,
		4.450645653124507e+01,		4.457045224862746e+01,		4.463435420354303e+01,		4.469816264941399e+01,		4.476187783877288e+01,
		4.482550002326598e+01,		4.488902945365702e+01,		4.495246637983065e+01,		4.501581105079605e+01,		4.507906371469049e+01,
		4.514222461878267e+01,		4.520529400947648e+01,		4.526827213231427e+01,		4.533115923198037e+01,		4.539395555230464e+01,
		4.545666133626575e+01,		4.551927682599479e+01,		4.558180226277848e+01,		4.564423788706272e+01,		4.570658393845588e+01,
		4.576884065573219e+01,		4.583100827683516e+01,		4.589308703888076e+01,		4.595507717816091e+01,		4.601697893014662e+01,
		4.607879252949147e+01,		4.614051821003471e+01,		4.620215620480466e+01,		4.626370674602182e+01,		4.632517006510230e+01,
		4.638654639266083e+01,		4.644783595851412e+01,		4.650903899168400e+01,		4.657015572040059e+01,		4.663118637210543e+01,
		4.669213117345476e+01,		4.675299035032255e+01,		4.681376412780363e+01,		4.687445273021680e+01,		4.693505638110809e+01,
		4.699557530325352e+01,		4.705600971866252e+01,		4.711635984858071e+01,		4.717662591349316e+01,		4.723680813312725e+01,
		4.729690672645581e+01,		4.735692191170008e+01,		4.741685390633267e+01,		4.747670292708061e+01,		4.753646918992825e+01
	},
	{
		7.620296723322363e-02,		2.285037967691584e-01,		3.804614780931176e-01,		5.320768627537259e-01,		6.833507866727162e-01,
		8.342840711732159e-01,		9.848775239610482e-01,		1.135131940060849e+00,		1.285048102708728e+00,		1.434626784203152e+00,
		1.583868746715638e+00,		1.732774743062820e+00,		1.881345517441351e+00,		2.029581806127104e+00,		2.177484338140026e+00,
		2.325053835875989e+00,		2.472291015706913e+00,		2.619196588550400e+00,		2.765771260410077e+00,		2.912015732887776e+00,
		3.057930703668686e+00,		3.203516866980528e+00,		3.348774914027787e+00,		3.493705533401997e+00,		3.638309411469044e+00,
		3.782587232734402e+00,		3.926539680187208e+00,		4.070167435624017e+00,		4.213471179953103e+00,		4.356451593480070e+00,
		4.499109356175579e+00,		4.641445147925912e+00,		4.783459648767125e+00,		4.925153539103445e+00,		5.066527499910636e+00,
		5.207582212924908e+00,		5.348318360818078e+00,		5.488736627359522e+00,		5.628837697565518e+00,		5.768622257836557e+00,
		5.908090996083135e+00,		6.047244601840571e+00,		6.186083766373334e+00,		6.324609182769384e+00,		6.462821546024952e+00,
		6.600721553120289e+00,		6.738309903086713e+00,		6.875587297065450e+00,		7.012554438358658e+00,		7.149212032472973e+00,
		7.285560787156016e+00,		7.421601412426174e+00,		7.557334620596007e+00,		7.692761126289642e+00,		7.827881646454424e+00,
		7.962696900367191e+00,		8.097207609635390e+00,		8.231414498193407e+00,		8.365318292294326e+00,		8.498919720497366e+00,
		8.632219513651316e+00,		8.765218404874137e+00,		8.897917129529002e+00,		9.030316425196986e+00,		9.162417031646628e+00,
		9.294219690800547e+00,		9.425725146699344e+00,		9.556934145462913e+00,		9.687847435249457e+00,		9.818465766212229e+00,
		9.948789890454297e+00,		1.007882056198141e+01,		1.020855853665314e+01,		1.033800457213248e+01,		1.046715942783395e+01,
		1.059602386487044e+01,		1.072459864599880e+01,		1.085288453556450e+01,		1.098088229944516e+01,		1.110859270499338e+01,
		1.123601652097880e+01,		1.136315451752945e+01,		1.149000746607267e+01,		1.161657613927548e+01,		1.174286131098462e+01,
		1.186886375616629e+01,		1.199458425084567e+01,		1.212002357204635e+01,		1.224518249772957e+01,		1.237006180673360e+01,
		1.249466227871303e+01,		1.261898469407829e+01,		1.274302983393525e+01,		1.286679848002510e+01,		1.299029141466444e+01,
		1.311350942068573e+01,		1.323645328137803e+01,		1.335912378042826e+01,		1.348152170186273e+01,		1.360364782998925e+01,
		1.372550294933972e+01,		1.384708784461322e+01,		1.396840330061969e+01,		1.408945010222418e+01,		1.421022903429173e+01,
		1.433074088163286e+01,		1.445098642894973e+01,		1.457096646078298e+01,		1.469068176145922e+01,		1.481013311503930e+01,
		1.492932130526722e+01,		1.504824711551984e+01,		1.516691132875732e+01,		1.528531472747425e+01,		1.540345809365167e+01,
		1.552134220870976e+01,		1.563896785346135e+01,		1.575633580806621e+01,		1.587344685198614e+01,		1.599030176394085e+01,
		1.610690132186463e+01,		1.622324630286382e+01,		1.633933748317509e+01,		1.645517563812451e+01,		1.657076154208745e+01,
		1.668609596844921e+01,		1.680117968956654e+01,		1.691601347672991e+01,		1.703059810012655e+01,		1.714493432880428e+01,
		1.725902293063621e+01,		1.737286467228613e+01,		1.748646031917470e+01,		1.759981063544641e+01,		1.771291638393733e+01,
		1.782577832614363e+01,		1.793839722219074e+01,		1.805077383080344e+01,		1.816290890927652e+01,		1.827480321344630e+01,
		1.838645749766274e+01,		1.849787251476243e+01,		1.860904901604215e+01,		1.871998775123321e+01,		1.883068946847643e+01,
		1.894115491429786e+01,		1.905138483358512e+01,		1.916137996956446e+01,		1.927114106377843e+01,		1.938066885606420e+01,
		1.948996408453262e+01,		1.959902748554770e+01,		1.970785979370697e+01,		1.981646174182222e+01,		1.992483406090104e+01,
		2.003297748012875e+01,		2.014089272685111e+01,		2.024858052655750e+01,		2.035604160286466e+01,		2.046327667750101e+01,
		2.057028647029153e+01,		2.067707169914320e+01,		2.078363308003084e+01,		2.088997132698363e+01,		2.099608715207208e+01,
		2.110198126539543e+01,		2.120765437506967e+01,		2.131310718721591e+01,		2.141834040594935e+01,		2.152335473336862e+01,
		2.162815086954562e+01,		2.173272951251577e+01,		2.183709135826876e+01,		2.194123710073968e+01,		2.204516743180059e+01,
		2.214888304125246e+01,		2.225238461681763e+01,		2.235567284413249e+01,		2.245874840674071e+01,		2.256161198608679e+01,
		2.266426426150992e+01,		2.276670591023832e+01,		2.286893760738383e+01,		2.297096002593694e+01,		2.307277383676204e+01,
		2.317437970859319e+01,		2.327577830802996e+01,		2.337697029953387e+01,		2.347795634542492e+01,		2.357873710587852e+01,
		2.367931323892272e+01,		2.377968540043570e+01,		2.387985424414356e+01,		2.397982042161839e+01,		2.407958458227658e+01,
		2.417914737337748e+01,		2.427850944002214e+01,		2.437767142515256e+01,		2.447663396955091e+01,		2.457539771183923e+01,
		2.467396328847915e+01,		2.477233133377202e+01,		2.487050247985913e+01,		2.496847735672224e+01,		2.506625659218422e+01,
		2.516384081191002e+01,		2.526123063940771e+01,		2.535842669602982e+01,		2.545542960097478e+01,		2.555223997128865e+01,
		2.564885842186687e+01,		2.574528556545642e+01,		2.584152201265785e+01,		2.593756837192776e+01,		2.603342524958125e+01,
		2.612909324979465e+01,		2.622457297460823e+01,		2.631986502392929e+01,		2.641496999553522e+01,		2.650988848507671e+01,
		2.660462108608123e+01,		2.669916838995644e+01,		2.679353098599389e+01,		2.688770946137278e+01,		2.698170440116383e+01,
		2.707551638833326e+01,		2.716914600374695e+01,		2.726259382617458e+01,		2.735586043229406e+01,		2.744894639669583e+01,
		2.754185229188747e+01,		2.763457868829829e+01,		2.772712615428401e+01,		2.781949525613163e+01,		2.791168655806420e+01,
		2.800370062224589e+01,		2.809553800878697e+01,		2.818719927574900e+01,		2.827868497914991e+01,		2.836999567296938e+01,
		2.846113190915414e+01,		2.855209423762334e+01,		2.864288320627405e+01,		2.873349936098678e+01,		2.882394324563109e+01,
		2.891421540207119e+01,		2.900431637017164e+01,		2.909424668780317e+01,		2.918400689084840e+01,		2.927359751320772e+01,
		2.936301908680520e+01,		2.945227214159449e+01,		2.954135720556485e+01,		2.963027480474713e+01,		2.971902546321984e+01,
		2.980760970311525e+01,		2.989602804462552e+01,		2.998428100600887e+01,		3.007236910359572e+01,		3.016029285179502e+01,
		3.024805276310038e+01,		3.033564934809644e+01,		3.042308311546511e+01,		3.051035457199193e+01,		3.059746422257240e+01,
		3.068441257021838e+01,		3.077120011606444e+01,		3.085782735937426e+01,		3.094429479754706e+01,		3.103060292612409e+01,
		3.111675223879501e+01,		3.120274322740433e+01,		3.128857638195801e+01,		3.137425219062980e+01,		3.145977113976782e+01,
		3.154513371390107e+01,		3.163034039574587e+01,		3.171539166621244e+01,		3.180028800441141e+01,		3.188502988766031e+01,
		3.196961779149013e+01,		3.205405218965184e+01,		3.213833355412297e+01,		3.222246235511405e+01,		3.230643906107522e+01,
		3.239026413870275e+01,		3.247393805294555e+01,		3.255746126701170e+01,		3.264083424237501e+01,		3.272405743878149e+01,
		3.280713131425593e+01,		3.289005632510836e+01,		3.297283292594055e+01,		3.305546156965259e+01,		3.313794270744928e+01,
		3.322027678884668e+01,		3.330246426167859e+01,		3.338450557210297e+01,		3.346640116460842e+01,		3.354815148202068e+01,
		3.362975696550897e+01,		3.371121805459254e+01,		3.379253518714696e+01,		3.387370879941061e+01,		3.395473932599106e+01,
		3.403562719987141e+01,		3.411637285241670e+01,		3.419697671338029e+01,		3.427743921091008e+01,		3.435776077155497e+01,
		3.443794182027111e+01,		3.451798278042822e+01,		3.459788407381580e+01,		3.467764612064948e+01,		3.475726933957729e+01,
		3.483675414768579e+01,		3.491610096050635e+01,		3.499531019202136e+01,		3.507438225467040e+01,		3.515331755935640e+01,
		3.523211651545181e+01,		3.531077953080472e+01,		3.538930701174493e+01,		3.546769936309017e+01,		3.554595698815204e+01,
		3.562408028874215e+01,		3.570206966517814e+01,		3.577992551628972e+01,		3.585764823942460e+01,		3.593523823045464e+01,
		3.601269588378158e+01,		3.609002159234323e+01,		3.616721574761920e+01,		3.624427873963693e+01,		3.632121095697753e+01,
		3.639801278678163e+01,		3.647468461475528e+01,		3.655122682517575e+01,		3.662763980089729e+01,		3.670392392335700e+01,
		3.678007957258055e+01,		3.685610712718796e+01,		3.693200696439924e+01,		3.700777946004022e+01,		3.708342498854812e+01,
		3.715894392297727e+01,		3.723433663500478e+01,		3.730960349493611e+01,		3.738474487171067e+01,		3.745976113290742e+01,
		3.753465264475047e+01,		3.760941977211453e+01,		3.768406287853053e+01,		3.775858232619099e+01,		3.783297847595563e+01,
		3.790725168735671e+01,		3.798140231860457e+01,		3.805543072659292e+01,		3.812933726690438e+01,		3.820312229381570e+01,
		3.827678616030319e+01,		3.835032921804809e+01,		3.842375181744173e+01,		3.849705430759100e+01,		3.857023703632346e+01,
		3.864330035019268e+01,		3.871624459448340e+01,		3.878907011321680e+01,		3.886177724915565e+01,		3.893436634380939e+01,
		3.900683773743941e+01,		3.907919176906405e+01,		3.915142877646385e+01,		3.922354909618637e+01,		3.929555306355151e+01,
		3.936744101265640e+01,		3.943921327638046e+01,		3.951087018639033e+01,		3.958241207314500e+01,		3.965383926590055e+01,
		3.972515209271523e+01,		3.979635088045434e+01,		3.986743595479508e+01,		3.993840764023150e+01,		4.000926626007924e+01,
		4.008001213648046e+01,		4.015064559040860e+01,		4.022116694167316e+01,		4.029157650892454e+01,		4.036187460965865e+01,
		4.043206156022178e+01,		4.050213767581530e+01,		4.057210327050017e+01,		4.064195865720188e+01,		4.071170414771485e+01,
		4.078134005270728e+01,		4.085086668172556e+01,		4.092028434319896e+01,		4.098959334444425e+01,		4.105879399167013e+01,
		4.112788658998187e+01,		4.119687144338572e+01,		4.126574885479354e+01,		4.133451912602712e+01,		4.140318255782273e+01,
		4.147173944983553e+01,		4.154019010064403e+01,		4.160853480775440e+01,		4.167677386760491e+01,		4.174490757557027e+01,
		4.181293622596601e+01,		4.188086011205273e+01,		4.194867952604045e+01,		4.201639475909293e+01,		4.208400610133182e+01,
		4.215151384184107e+01,		4.221891826867100e+01,		4.228621966884263e+01,		4.235341832835183e+01,		4.242051453217345e+01,
		4.248750856426559e+01,		4.255440070757362e+01,		4.262119124403441e+01,		4.268788045458025e+01,		4.275446861914325e+01,
		4.282095601665907e+01,		4.288734292507117e+01,		4.295362962133481e+01,		4.301981638142109e+01,		4.308590348032080e+01,
		4.315189119204858e+01,		4.321777978964684e+01,		4.328356954518963e+01,		4.334926072978662e+01,		4.341485361358706e+01,
		4.348034846578355e+01,		4.354574555461609e+01,		4.361104514737578e+01,		4.367624751040874e+01,		4.374135290911996e+01,
		4.380636160797705e+01,		4.387127387051409e+01,		4.393608995933538e+01,		4.400081013611919e+01,		4.406543466162154e+01,
		4.412996379567991e+01,		4.419439779721697e+01,		4.425873692424426e+01,		4.432298143386584e+01,		4.438713158228204e+01,
		4.445118762479301e+01,		4.451514981580244e+01,		4.457901840882112e+01,		4.464279365647061e+01,		4.470647581048671e+01,
		4.477006512172311e+01,		4.483356184015500e+01,		4.489696621488248e+01,		4.496027849413415e+01,		4.502349892527067e+01,
		4.508662775478815e+01,		4.514966522832172e+01,		4.521261159064893e+01,		4.527546708569322e+01,		4.533823195652739e+01,
		4.540090644537696e+01,		4.546349079362358e+01,		4.552598524180852e+01,		4.558839002963586e+01,		4.565070539597602e+01,
		4.571293157886906e+01,		4.577506881552792e+01,		4.583711734234184e+01,		4.589907739487967e+01,		4.596094920789306e+01,
		4.602273301531981e+01,		4.608442905028711e+01,		4.614603754511481e+01,		4.620755873131858e+01,		4.626899283961323e+01,
		4.633034009991582e+01,		4.639160074134888e+01,		4.645277499224362e+01,		4.651386308014305e+01,		4.657486523180517e+01,
		4.663578167320604e+01,		4.669661262954295e+01,		4.675735832523753e+01,		4.681801898393883e+01,		4.687859482852638e+01,
		4.693908608111330e+01,		4.699949296304936e+01,		4.705981569492391e+01,		4.712005449656910e+01,		4.718020958706271e+01,
		4.724028118473125e+01,		4.730026950715295e+01,		4.736017477116069e+01,		4.741999719284501e+01,		4.747973698755702e+01
	},
	{
		7.605878719497242e-02,		2.280717725833515e-01,		3.797426822160180e-01,		5.310723664831914e-01,		6.820616602644868e-01,
		8.327113839457365e-01,		9.830223443894294e-01,		1.132995335860529e+00,		1.282631140909394e+00,		1.431930531213431e+00,
		1.580894268379070e+00,		1.729523104705594e+00,		1.877817783912261e+00,		2.025779041830165e+00,		2.173407607060178e+00,
		2.320704201598288e+00,		2.467669541429598e+00,		2.614304337092214e+00,		2.760609294212177e+00,		2.906585114010598e+00,
		3.052232493784066e+00,		3.197552127359400e+00,		3.342544705523759e+00,		3.487210916431073e+00,		3.631551445985779e+00,
		3.775566978204743e+00,		3.919258195558260e+00,		4.062625779290982e+00,		4.205670409723606e+00,		4.348392766536093e+00,
		4.490793529033205e+00,		4.632873376393075e+00,		4.774632987899542e+00,		4.916073043158926e+00,		5.057194222301910e+00,
		5.197997206171158e+00,		5.338482676495308e+00,		5.478651316049913e+00,		5.618503808805918e+00,		5.758040840066198e+00,
		5.897263096590756e+00,		6.036171266711003e+00,		6.174766040433699e+00,		6.313048109534999e+00,		6.451018167645027e+00,
		6.588676910323511e+00,		6.726025035126828e+00,		6.863063241666885e+00,		6.999792231662301e+00,		7.136212708982138e+00,
		7.272325379682710e+00,		7.408130952037679e+00,		7.543630136561881e+00,		7.678823646029165e+00,		7.813712195484549e+00,
		7.948296502251041e+00,		8.082577285931366e+00,		8.216555268404926e+00,		8.350231173820223e+00,		8.483605728583026e+00,
		8.616679661340532e+00,		8.749453702961741e+00,		8.881928586514293e+00,		9.014105047237999e+00,		9.145983822515193e+00,
		9.277565651838277e+00,		9.408851276774421e+00,		9.539841440927864e+00,		9.670536889899751e+00,		9.800938371245826e+00,
		9.931046634432137e+00,		1.006086243078881e+01,		1.019038651346216e+01,		1.031961963736520e+01,		1.044856255912674e+01,
		1.057721603703913e+01,		1.070558083100488e+01,		1.083365770248214e+01,		1.096144741442935e+01,		1.108895073124890e+01,
		1.121616841873014e+01,		1.134310124399174e+01,		1.146974997542349e+01,		1.159611538262759e+01,		1.172219823635968e+01,
		1.184799930846940e+01,		1.197351937184092e+01,		1.209875920033318e+01,		1.222371956872008e+01,		1.234840125263071e+01,
		1.247280502848952e+01,		1.259693167345669e+01,		1.272078196536860e+01,		1.284435668267852e+01,		1.296765660439754e+01,
		1.309068251003582e+01,		1.321343517954421e+01,		1.333591539325613e+01,		1.345812393183004e+01,		1.358006157619226e+01,
		1.370172910748027e+01,		1.382312730698659e+01,		1.394425695610317e+01,		1.406511883626635e+01,		1.418571372890240e+01,
		1.430604241537377e+01,		1.442610567692587e+01,		1.454590429463457e+01,		1.466543904935437e+01,		1.478471072166723e+01,
		1.490372009183219e+01,		1.502246793973561e+01,		1.514095504484222e+01,		1.525918218614689e+01,		1.537715014212710e+01,
		1.549485969069628e+01,		1.561231160915782e+01,		1.572950667415988e+01,		1.584644566165103e+01,		1.596312934683657e+01,
		1.607955850413575e+01,		1.619573390713969e+01,		1.631165632857013e+01,		1.642732654023894e+01,		1.654274531300845e+01,
		1.665791341675259e+01,		1.677283162031873e+01,		1.688750069149036e+01,		1.700192139695059e+01,		1.711609450224637e+01,
		1.723002077175346e+01,		1.734370096864230e+01,		1.745713585484443e+01,		1.757032619101997e+01,		1.768327273652550e+01,
		1.779597624938303e+01,		1.790843748624944e+01,		1.802065720238686e+01,		1.813263615163362e+01,		1.824437508637608e+01,
		1.835587475752102e+01,		1.846713591446883e+01,		1.857815930508741e+01,		1.868894567568667e+01,		1.879949577099386e+01,
		1.890981033412942e+01,		1.901989010658362e+01,		1.912973582819374e+01,		1.923934823712205e+01,		1.934872806983432e+01,
		1.945787606107895e+01,		1.956679294386682e+01,		1.967547944945166e+01,		1.978393630731113e+01,		1.989216424512830e+01,
		2.000016398877400e+01,		2.010793626228951e+01,		2.021548178786990e+01,		2.032280128584796e+01,		2.042989547467865e+01,
		2.053676507092409e+01,		2.064341078923908e+01,		2.074983334235717e+01,		2.085603344107719e+01,		2.096201179425033e+01,
		2.106776910876775e+01,		2.117330608954851e+01,		2.127862343952826e+01,		2.138372185964808e+01,		2.148860204884406e+01,
		2.159326470403713e+01,		2.169771052012338e+01,		2.180194018996499e+01,		2.190595440438127e+01,		2.200975385214039e+01,
		2.211333921995136e+01,		2.221671119245653e+01,		2.231987045222435e+01,		2.242281767974258e+01,		2.252555355341196e+01,
		2.262807874954007e+01,		2.273039394233570e+01,		2.283249980390350e+01,		2.293439700423900e+01,		2.303608621122399e+01,
		2.313756809062209e+01,		2.323884330607493e+01,		2.333991251909831e+01,		2.344077638907894e+01,		2.354143557327130e+01,
		2.364189072679489e+01,		2.374214250263176e+01,		2.384219155162426e+01,		2.394203852247315e+01,		2.404168406173593e+01,
		2.414112881382541e+01,		2.424037342100858e+01,		2.433941852340574e+01,		2.443826475898977e+01,		2.453691276358582e+01,
		2.463536317087101e+01,		2.473361661237459e+01,		2.483167371747805e+01,		2.492953511341573e+01,		2.502720142527543e+01,
		2.512467327599932e+01,		2.522195128638500e+01,		2.531903607508679e+01,		2.541592825861721e+01,		2.551262845134858e+01,
		2.560913726551488e+01,		2.570545531121376e+01,		2.580158319640865e+01,		2.589752152693111e+01,		2.599327090648339e+01,
		2.608883193664094e+01,		2.618420521685533e+01,		2.627939134445704e+01,		2.637439091465873e+01,		2.646920452055829e+01,
		2.656383275314228e+01,		2.665827620128938e+01,		2.675253545177399e+01,		2.684661108927001e+01,		2.694050369635458e+01,
		2.703421385351217e+01,		2.712774213913855e+01,		2.722108912954505e+01,		2.731425539896274e+01,		2.740724151954693e+01,
		2.750004806138156e+01,		2.759267559248386e+01,		2.768512467880894e+01,		2.777739588425459e+01,		2.786948977066611e+01,
		2.796140689784123e+01,		2.805314782353514e+01,		2.814471310346551e+01,		2.823610329131770e+01,		2.832731893874997e+01,
		2.841836059539878e+01,		2.850922880888411e+01,		2.859992412481494e+01,		2.869044708679469e+01,		2.878079823642683e+01,
		2.887097811332034e+01,		2.896098725509555e+01,		2.905082619738969e+01,		2.914049547386277e+01,		2.922999561620325e+01,
		2.931932715413405e+01,		2.940849061541828e+01,		2.949748652586533e+01,		2.958631540933673e+01,		2.967497778775218e+01,
		2.976347418109570e+01,		2.985180510742157e+01,		2.993997108286055e+01,		3.002797262162600e+01,		3.011581023602007e+01,
		3.020348443643983e+01,		3.029099573138365e+01,		3.037834462745728e+01,		3.046553162938033e+01,		3.055255723999237e+01,
		3.063942196025938e+01,		3.072612628928007e+01,		3.081267072429223e+01,		3.089905576067909e+01,		3.098528189197573e+01,
		3.107134960987549e+01,		3.115725940423639e+01,		3.124301176308755e+01,		3.132860717263562e+01,		3.141404611727123e+01,
		3.149932907957554e+01,		3.158445654032653e+01,		3.166942897850564e+01,		3.175424687130412e+01,		3.183891069412966e+01,
		3.192342092061270e+01,		3.200777802261305e+01,		3.209198247022634e+01,		3.217603473179047e+01,		3.225993527389220e+01,
		3.234368456137351e+01,		3.242728305733822e+01,		3.251073122315838e+01,		3.259402951848080e+01,		3.267717840123350e+01,
		3.276017832763225e+01,		3.284302975218694e+01,		3.292573312770813e+01,		3.300828890531348e+01,		3.309069753443420e+01,
		3.317295946282148e+01,		3.325507513655295e+01,		3.333704500003911e+01,		3.341886949602973e+01,		3.350054906562023e+01,
		3.358208414825818e+01,		3.366347518174956e+01,		3.374472260226524e+01,		3.382582684434728e+01,		3.390678834091532e+01,
		3.398760752327293e+01,		3.406828482111383e+01,		3.414882066252839e+01,		3.422921547400978e+01,		3.430946968046030e+01,
		3.438958370519772e+01,		3.446955796996138e+01,		3.454939289491865e+01,		3.462908889867095e+01,		3.470864639826009e+01,
		3.478806580917443e+01,		3.486734754535503e+01,		3.494649201920188e+01,		3.502549964158002e+01,		3.510437082182558e+01,
		3.518310596775208e+01,		3.526170548565634e+01,		3.534016978032469e+01,		3.541849925503890e+01,		3.549669431158242e+01,
		3.557475535024617e+01,		3.565268276983471e+01,		3.573047696767217e+01,		3.580813833960821e+01,		3.588566728002401e+01,
		3.596306418183813e+01,		3.604032943651251e+01,		3.611746343405827e+01,		3.619446656304167e+01,		3.627133921058989e+01,
		3.634808176239687e+01,		3.642469460272923e+01,		3.650117811443189e+01,		3.657753267893393e+01,		3.665375867625445e+01,
		3.672985648500805e+01,		3.680582648241080e+01,		3.688166904428577e+01,		3.695738454506876e+01,		3.703297335781394e+01,
		3.710843585419951e+01,		3.718377240453324e+01,		3.725898337775814e+01,		3.733406914145798e+01,		3.740903006186282e+01,
		3.748386650385461e+01,		3.755857883097263e+01,		3.763316740541901e+01,		3.770763258806417e+01,		3.778197473845226e+01,
		3.785619421480666e+01,		3.793029137403524e+01,		3.800426657173588e+01,		3.807812016220176e+01,		3.815185249842668e+01,
		3.822546393211044e+01,		3.829895481366414e+01,		3.837232549221532e+01,		3.844557631561341e+01,		3.851870763043481e+01,
		3.859171978198825e+01,		3.866461311431979e+01,		3.873738797021817e+01,		3.881004469121991e+01,		3.888258361761433e+01,
		3.895500508844885e+01,		3.902730944153392e+01,		3.909949701344815e+01,		3.917156813954337e+01,		3.924352315394967e+01,
		3.931536238958032e+01,		3.938708617813683e+01,		3.945869485011392e+01,		3.953018873480440e+01,		3.960156816030419e+01,
		3.967283345351713e+01,		3.974398494015990e+01,		3.981502294476687e+01,		3.988594779069503e+01,		3.995675980012866e+01,
		4.002745929408420e+01,		4.009804659241514e+01,		4.016852201381657e+01,		4.023888587583011e+01,		4.030913849484853e+01,
		4.037928018612048e+01,		4.044931126375515e+01,		4.051923204072699e+01,		4.058904282888032e+01,		4.065874393893387e+01,
		4.072833568048556e+01,		4.079781836201690e+01,		4.086719229089773e+01,		4.093645777339058e+01,		4.100561511465530e+01,
		4.107466461875363e+01,		4.114360658865353e+01,		4.121244132623375e+01,		4.128116913228830e+01,		4.134979030653072e+01,
		4.141830514759874e+01,		4.148671395305846e+01,		4.155501701940881e+01,		4.162321464208589e+01,		4.169130711546732e+01,
		4.175929473287653e+01,		4.182717778658708e+01,		4.189495656782694e+01,		4.196263136678271e+01,		4.203020247260390e+01,
		4.209767017340722e+01,		4.216503475628058e+01,		4.223229650728755e+01,		4.229945571147130e+01,		4.236651265285884e+01,
		4.243346761446522e+01,		4.250032087829756e+01,		4.256707272535915e+01,		4.263372343565356e+01,		4.270027328818868e+01,
		4.276672256098080e+01,		4.283307153105860e+01,		4.289932047446721e+01,		4.296546966627214e+01,		4.303151938056325e+01,
		4.309746989045884e+01,		4.316332146810938e+01,		4.322907438470165e+01,		4.329472891046249e+01,		4.336028531466270e+01,
		4.342574386562107e+01,		4.349110483070805e+01,		4.355636847634965e+01,		4.362153506803131e+01,		4.368660487030171e+01,
		4.375157814677643e+01,		4.381645516014189e+01,		4.388123617215901e+01,		4.394592144366698e+01,		4.401051123458692e+01,
		4.407500580392577e+01,		4.413940540977976e+01,		4.420371030933820e+01,		4.426792075888714e+01,		4.433203701381303e+01,
		4.439605932860623e+01,		4.445998795686481e+01,		4.452382315129802e+01,		4.458756516372983e+01,		4.465121424510266e+01,
		4.471477064548080e+01,		4.477823461405395e+01,		4.484160639914082e+01,		4.490488624819258e+01,		4.496807440779631e+01,
		4.503117112367855e+01,		4.509417664070874e+01,		4.515709120290264e+01,		4.521991505342577e+01,		4.528264843459682e+01,
		4.534529158789108e+01,		4.540784475394374e+01,		4.547030817255338e+01,		4.553268208268527e+01,		4.559496672247465e+01,
		4.565716232923018e+01,		4.571926913943709e+01,		4.578128738876072e+01,		4.584321731204949e+01,		4.590505914333843e+01,
		4.596681311585235e+01,		4.602847946200907e+01,		4.609005841342253e+01,		4.615155020090631e+01,		4.621295505447650e+01,
		4.627427320335509e+01,		4.633550487597304e+01,		4.639665029997351e+01,		4.645770970221496e+01,		4.651868330877424e+01,
		4.657957134494985e+01,		4.664037403526486e+01,		4.670109160347019e+01,		4.676172427254745e+01,		4.682227226471227e+01,
		4.688273580141716e+01,		4.694311510335460e+01,		4.700341039046010e+01,		4.706362188191520e+01,		4.712374979615036e+01,
		4.718379435084816e+01,		4.724375576294606e+01,		4.730363424863950e+01,		4.736343002338474e+01,		4.742314330190187e+01
	},
	{
		7.591515187636128e-02,		2.276413803506727e-01,		3.790266011117397e-01,		5.300716633713171e-01,		6.807774009456945e-01,
		8.311446332612082e-01,		9.811741663139516e-01,		1.130866793585436e+00,		1.280223296915884e+00,		1.429244447336781e+00,
		1.577931005864243e+00,		1.726283724254701e+00,		1.874303345724348e+00,		2.021990605633754e+00,		2.169346232138974e+00,
		2.316370946810459e+00,		2.463065465221003e+00,		2.609430497503946e+00,		2.755466748882776e+00,		2.901174920173259e+00,
		3.046555708259171e+00,		3.191609806542679e+00,		3.336337905370362e+00,		3.480740692435847e+00,		3.624818853160009e+00,
		3.768573071049609e+00,		3.912004028035267e+00,		4.055112404789577e+00,		4.197898881026219e+00,		4.340364135780804e+00,
		4.482508847674244e+00,		4.624333695159343e+00,		4.765839356751339e+00,		4.907026511243055e+00,		5.047895837905325e+00,
		5.188448016673327e+00,		5.328683728319399e+00,		5.468603654613006e+00,		5.608208478468314e+00,		5.747498884080007e+00,
		5.886475557047840e+00,		6.025139184490425e+00,		6.163490455148768e+00,		6.301530059479993e+00,		6.439258689741745e+00,
		6.576677040067692e+00,		6.713785806534546e+00,		6.850585687221007e+00,		6.987077382259050e+00,		7.123261593877892e+00,
		7.259139026441038e+00,		7.394710386476720e+00,		7.529976382702118e+00,		7.664937726041621e+00,		7.799595129639493e+00,
		7.933949308867225e+00,		8.068000981325854e+00,		8.201750866843547e+00,		8.335199687468672e+00,		8.468348167458682e+00,
		8.601197033264976e+00,		8.733747013514060e+00,		8.865998838985155e+00,		8.997953242584513e+00,		9.129610959316635e+00,
		9.260972726252623e+00,		9.392039282495793e+00,		9.522811369144790e+00,		9.653289729254372e+00,		9.783475107793985e+00,
		9.913368251604362e+00,		1.004296990935226e+01,		1.017228083148347e+01,		1.030130177017424e+01,		1.043003347928135e+01,
		1.055847671429078e+01,		1.068663223226522e+01,		1.081450079179059e+01,		1.094208315292152e+01,		1.106938007712600e+01,
		1.119639232722933e+01,		1.132312066735738e+01,		1.144956586287931e+01,		1.157572868034981e+01,		1.170160988745100e+01,
		1.182721025293394e+01,		1.195253054655999e+01,		1.207757153904200e+01,		1.220233400198535e+01,		1.232681870782903e+01,
		1.245102642978671e+01,		1.257495794178793e+01,		1.269861401841942e+01,		1.282199543486659e+01,		1.294510296685531e+01,
		1.306793739059396e+01,		1.319049948271580e+01,		1.331279002022169e+01,		1.343480978042327e+01,		1.355655954088657e+01,
		1.367804007937604e+01,		1.379925217379919e+01,		1.392019660215159e+01,		1.404087414246268e+01,		1.416128557274192e+01,
		1.428143167092568e+01,		1.440131321482478e+01,		1.452093098207255e+01,		1.464028575007370e+01,		1.475937829595374e+01,
		1.487820939650922e+01,		1.499677982815857e+01,		1.511509036689373e+01,		1.523314178823249e+01,		1.535093486717155e+01,
		1.546847037814035e+01,		1.558574909495565e+01,		1.570277179077687e+01,		1.581953923806219e+01,		1.593605220852545e+01,
		1.605231147309375e+01,		1.616831780186591e+01,		1.628407196407167e+01,		1.639957472803165e+01,		1.651482686111811e+01,
		1.662982912971647e+01,		1.674458229918765e+01,		1.685908713383110e+01,		1.697334439684870e+01,		1.708735485030932e+01,
		1.720111925511429e+01,		1.731463837096342e+01,		1.742791295632199e+01,		1.754094376838838e+01,		1.765373156306244e+01,
		1.776627709491464e+01,		1.787858111715592e+01,		1.799064438160831e+01,		1.810246763867623e+01,		1.821405163731848e+01,
		1.832539712502106e+01,		1.843650484777050e+01,		1.854737555002809e+01,		1.865800997470458e+01,		1.876840886313575e+01,
		1.887857295505854e+01,		1.898850298858784e+01,		1.909819970019396e+01,		1.920766382468072e+01,		1.931689609516424e+01,
		1.942589724305226e+01,		1.953466799802412e+01,		1.964320908801134e+01,		1.975152123917887e+01,		1.985960517590676e+01,
		1.996746162077260e+01,		2.007509129453440e+01,		2.018249491611410e+01,		2.028967320258162e+01,		2.039662686913941e+01,
		2.050335662910761e+01,		2.060986319390968e+01,		2.071614727305856e+01,		2.082220957414338e+01,		2.092805080281656e+01,
		2.103367166278155e+01,		2.113907285578093e+01,		2.124425508158507e+01,		2.134921903798113e+01,		2.145396542076270e+01,
		2.155849492371970e+01,		2.166280823862886e+01,		2.176690605524455e+01,		2.187078906129002e+01,		2.197445794244918e+01,
		2.207791338235857e+01,		2.218115606259995e+01,		2.228418666269313e+01,		2.238700586008922e+01,		2.248961433016429e+01,
		2.259201274621334e+01,		2.269420177944466e+01,		2.279618209897457e+01,		2.289795437182237e+01,		2.299951926290583e+01,
		2.310087743503681e+01,		2.320202954891733e+01,		2.330297626313588e+01,		2.340371823416416e+01,		2.350425611635383e+01,
		2.360459056193395e+01,		2.370472222100839e+01,		2.380465174155365e+01,		2.390437976941696e+01,		2.400390694831456e+01,
		2.410323391983037e+01,		2.420236132341480e+01,		2.430128979638384e+01,		2.440001997391845e+01,		2.449855248906405e+01,
		2.459688797273041e+01,		2.469502705369167e+01,		2.479297035858652e+01,		2.489071851191868e+01,		2.498827213605765e+01,
		2.508563185123947e+01,		2.518279827556785e+01,		2.527977202501539e+01,		2.537655371342505e+01,		2.547314395251175e+01,
		2.556954335186418e+01,		2.566575251894679e+01,		2.576177205910192e+01,		2.585760257555207e+01,		2.595324466940238e+01,
		2.604869893964329e+01,		2.614396598315322e+01,		2.623904639470154e+01,		2.633394076695159e+01,		2.642864969046387e+01,
		2.652317375369939e+01,		2.661751354302304e+01,		2.671166964270726e+01,		2.680564263493563e+01,		2.689943309980677e+01,
		2.699304161533824e+01,		2.708646875747053e+01,		2.717971510007127e+01,		2.727278121493942e+01,		2.736566767180965e+01,
		2.745837503835677e+01,		2.755090388020027e+01,		2.764325476090895e+01,		2.773542824200567e+01,		2.782742488297203e+01,
		2.791924524125343e+01,		2.801088987226390e+01,		2.810235932939118e+01,		2.819365416400186e+01,		2.828477492544647e+01,
		2.837572216106488e+01,		2.846649641619148e+01,		2.855709823416063e+01,		2.864752815631209e+01,		2.873778672199652e+01,
		2.882787446858104e+01,		2.891779193145482e+01,		2.900753964403477e+01,		2.909711813777126e+01,		2.918652794215383e+01,
		2.927576958471704e+01,		2.936484359104636e+01,		2.945375048478392e+01,		2.954249078763464e+01,		2.963106501937200e+01,
		2.971947369784419e+01,		2.980771733898010e+01,		2.989579645679538e+01,		2.998371156339858e+01,		3.007146316899725e+01,
		3.015905178190407e+01,		3.024647790854318e+01,		3.033374205345621e+01,		3.042084471930864e+01,		3.050778640689602e+01,
		3.059456761515024e+01,		3.068118884114584e+01,		3.076765058010631e+01,		3.085395332541046e+01,		3.094009756859874e+01,
		3.102608379937960e+01,		3.111191250563583e+01,		3.119758417343105e+01,		3.128309928701602e+01,		3.136845832883506e+01,
		3.145366177953248e+01,		3.153871011795901e+01,		3.162360382117821e+01,		3.170834336447291e+01,		3.179292922135166e+01,
		3.187736186355515e+01,		3.196164176106270e+01,		3.204576938209866e+01,		3.212974519313887e+01,		3.221356965891713e+01,
		3.229724324243163e+01,		3.238076640495139e+01,		3.246413960602272e+01,		3.254736330347571e+01,		3.263043795343050e+01,
		3.271336401030393e+01,		3.279614192681588e+01,		3.287877215399559e+01,		3.296125514118823e+01,		3.304359133606125e+01,
		3.312578118461080e+01,		3.320782513116805e+01,		3.328972361840570e+01,		3.337147708734425e+01,		3.345308597735845e+01,
		3.353455072618361e+01,		3.361587176992193e+01,		3.369704954304892e+01,		3.377808447841964e+01,		3.385897700727502e+01,
		3.393972755924825e+01,		3.402033656237097e+01,		3.410080444307960e+01,		3.418113162622152e+01,		3.426131853506148e+01,
		3.434136559128770e+01,		3.442127321501810e+01,		3.450104182480656e+01,		3.458067183764906e+01,		3.466016366898990e+01,
		3.473951773272783e+01,		3.481873444122220e+01,		3.489781420529908e+01,		3.497675743425739e+01,		3.505556453587493e+01,
		3.513423591641456e+01,		3.521277198063021e+01,		3.529117313177282e+01,		3.536943977159658e+01,		3.544757230036473e+01,
		3.552557111685569e+01,		3.560343661836892e+01,		3.568116920073096e+01,		3.575876925830131e+01,		3.583623718397836e+01,
		3.591357336920527e+01,		3.599077820397589e+01,		3.606785207684058e+01,		3.614479537491204e+01,		3.622160848387114e+01,
		3.629829178797272e+01,		3.637484567005139e+01,		3.645127051152726e+01,		3.652756669241166e+01,		3.660373459131295e+01,
		3.667977458544205e+01,		3.675568705061831e+01,		3.683147236127508e+01,		3.690713089046528e+01,		3.698266300986718e+01,
		3.705806908978984e+01,		3.713334949917876e+01,		3.720850460562148e+01,		3.728353477535303e+01,		3.735844037326142e+01,
		3.743322176289333e+01,		3.750787930645936e+01,		3.758241336483957e+01,		3.765682429758898e+01,		3.773111246294285e+01,
		3.780527821782218e+01,		3.787932191783905e+01,		3.795324391730192e+01,		3.802704456922103e+01,		3.810072422531369e+01,
		3.817428323600952e+01,		3.824772195045577e+01,		3.832104071652254e+01,		3.839423988080805e+01,		3.846731978864376e+01,
		3.854028078409959e+01,		3.861312320998916e+01,		3.868584740787483e+01,		3.875845371807284e+01,		3.883094247965845e+01,
		3.890331403047098e+01,		3.897556870711890e+01,		3.904770684498487e+01,		3.911972877823072e+01,		3.919163483980245e+01,
		3.926342536143530e+01,		3.933510067365857e+01,		3.940666110580064e+01,		3.947810698599388e+01,		3.954943864117956e+01,
		3.962065639711259e+01,		3.969176057836661e+01,		3.976275150833867e+01,		3.983362950925397e+01,		3.990439490217091e+01,
		3.997504800698559e+01,		4.004558914243675e+01,		4.011601862611043e+01,		4.018633677444469e+01,		4.025654390273429e+01,
		4.032664032513544e+01,		4.039662635467032e+01,		4.046650230323186e+01,		4.053626848158827e+01,		4.060592519938764e+01,
		4.067547276516257e+01,		4.074491148633464e+01,		4.081424166921909e+01,		4.088346361902912e+01,		4.095257763988064e+01,
		4.102158403479652e+01,		4.109048310571125e+01,		4.115927515347522e+01,		4.122796047785927e+01,		4.129653937755899e+01,
		4.136501215019917e+01,		4.143337909233815e+01,		4.150164049947219e+01,		4.156979666603969e+01,		4.163784788542571e+01,
		4.170579444996604e+01,		4.177363665095157e+01,		4.184137477863265e+01,		4.190900912222307e+01,		4.197653996990452e+01,
		4.204396760883072e+01,		4.211129232513153e+01,		4.217851440391716e+01,		4.224563412928238e+01,		4.231265178431051e+01,
		4.237956765107768e+01,		4.244638201065681e+01,		4.251309514312176e+01,		4.257970732755131e+01,		4.264621884203328e+01,
		4.271262996366849e+01,		4.277894096857484e+01,		4.284515213189115e+01,		4.291126372778135e+01,		4.297727602943820e+01,
		4.304318930908741e+01,		4.310900383799144e+01,		4.317471988645347e+01,		4.324033772382126e+01,		4.330585761849102e+01,
		4.337127983791123e+01,		4.343660464858656e+01,		4.350183231608156e+01,		4.356696310502460e+01,		4.363199727911156e+01,
		4.369693510110963e+01,		4.376177683286102e+01,		4.382652273528680e+01,		4.389117306839054e+01,		4.395572809126197e+01,
		4.402018806208078e+01,		4.408455323812022e+01,		4.414882387575081e+01,		4.421300023044378e+01,		4.427708255677511e+01,
		4.434107110842866e+01,		4.440496613820009e+01,		4.446876789800032e+01,		4.453247663885907e+01,		4.459609261092848e+01,
		4.465961606348655e+01,		4.472304724494077e+01,		4.478638640283147e+01,		4.484963378383545e+01,		4.491278963376936e+01,
		4.497585419759317e+01,		4.503882771941368e+01,		4.510171044248780e+01,		4.516450260922612e+01,		4.522720446119618e+01,
		4.528981623912591e+01,		4.535233818290704e+01,		4.541477053159829e+01,		4.547711352342893e+01,		4.553936739580189e+01,
		4.560153238529723e+01,		4.566360872767532e+01,		4.572559665788021e+01,		4.578749641004282e+01,		4.584930821748421e+01,
		4.591103231271887e+01,		4.597266892745787e+01,		4.603421829261209e+01,		4.609568063829546e+01,		4.615705619382808e+01,
		4.621834518773942e+01,		4.627954784777146e+01,		4.634066440088186e+01,		4.640169507324701e+01,		4.646264009026526e+01,
		4.652349967655991e+01,		4.658427405598238e+01,		4.664496345161520e+01,		4.670556808577512e+01,		4.676608818001620e+01,
		4.682652395513272e+01,		4.688687563116234e+01,		4.694714342738901e+01,		4.700732756234596e+01,		4.706742825381879e+01,
		4.712744571884829e+01,		4.718738017373353e+01,		4.724723183403469e+01,		4.730700091457608e+01,		4.736668762944901e+01
	},
	{
		7.577205819525858e-02,		2.272126108328109e-01,		3.783132194051757e-01,		5.290747319260320e-01,		6.794979811276028e-01,
		8.295837854550007e-01,		9.793329500153517e-01,		1.128746267483425e+00,		1.277824518965432e+00,		1.426568474822580e+00,
		1.574978895455944e+00,		1.723056532054117e+00,		1.870802127305071e+00,		2.018216416073614e+00,		2.165300126045750e+00,
		2.312053978341243e+00,		2.458478688095581e+00,		2.604574965012568e+00,		2.750343513888651e+00,		2.895785035110115e+00,
		3.040900225124183e+00,		3.185689776885075e+00,		3.330154380275995e+00,		3.474294722508012e+00,		3.618111488496756e+00,
		3.761605361217819e+00,		3.904777022041713e+00,		4.047627151049230e+00,		4.190156427327977e+00,		4.332365529250884e+00,
		4.474255134737428e+00,		4.615825921498259e+00,		4.757078567263960e+00,		4.898013749998604e+00,		5.038632148098722e+00,
		5.178934440578348e+00,		5.318921307240712e+00,		5.458593428837178e+00,		5.597951487213969e+00,		5.736996165447236e+00,
		5.875728147966981e+00,		6.014148120670345e+00,		6.152256771024727e+00,		6.290054788161219e+00,		6.427542862958791e+00,
		6.564721688119680e+00,		6.701591958236379e+00,		6.838154369850622e+00,		6.974409621504802e+00,		7.110358413786124e+00,
		7.246001449363906e+00,		7.381339433020350e+00,		7.516373071675123e+00,		7.651103074404062e+00,		7.785530152452323e+00,
		7.919655019242255e+00,		8.053478390376295e+00,		8.187000983635150e+00,		8.320223518971535e+00,		8.453146718499735e+00,
		8.585771306481174e+00,		8.718098009306328e+00,		8.850127555473080e+00,		8.981860675561849e+00,		9.113298102207628e+00,
		9.244440570069141e+00,		9.375288815795319e+00,		9.505843577989289e+00,		9.636105597170017e+00,		9.766075615731786e+00,
		9.895754377901691e+00,		1.002514262969526e+01,		1.015424111887041e+01,		1.028305059487978e+01,		1.041157180882170e+01,
		1.053980551338980e+01,		1.066775246282147e+01,		1.079541341284527e+01,		1.092278912062732e+01,		1.104988034471693e+01,
		1.117668784499142e+01,		1.130321238260030e+01,		1.142945471990891e+01,		1.155541562044157e+01,		1.168109584882434e+01,
		1.180649617072749e+01,		1.193161735280768e+01,		1.205646016265003e+01,		1.218102536871007e+01,		1.230531374025564e+01,
		1.242932604730881e+01,		1.255306306058792e+01,		1.267652555144971e+01,		1.279971429183164e+01,		1.292263005419447e+01,
		1.304527361146512e+01,		1.316764573697975e+01,		1.328974720442737e+01,		1.341157878779367e+01,		1.353314126130542e+01,
		1.365443539937524e+01,		1.377546197654692e+01,		1.389622176744120e+01,		1.401671554670216e+01,		1.413694408894419e+01,
		1.425690816869946e+01,		1.437660856036610e+01,		1.449604603815697e+01,		1.461522137604911e+01,		1.473413534773380e+01,
		1.485278872656739e+01,		1.497118228552276e+01,		1.508931679714149e+01,		1.520719303348677e+01,		1.532481176609704e+01,
		1.544217376594033e+01,		1.555927980336940e+01,		1.567613064807758e+01,		1.579272706905533e+01,		1.590906983454772e+01,
		1.602515971201242e+01,		1.614099746807871e+01,		1.625658386850703e+01,		1.637191967814949e+01,		1.648700566091101e+01,
		1.660184257971126e+01,		1.671643119644740e+01,		1.683077227195755e+01,		1.694486656598502e+01,		1.705871483714333e+01,
		1.717231784288190e+01,		1.728567633945262e+01,		1.739879108187703e+01,		1.751166282391434e+01,		1.762429231803013e+01,
		1.773668031536582e+01,		1.784882756570880e+01,		1.796073481746337e+01,		1.807240281762231e+01,		1.818383231173917e+01,
		1.829502404390133e+01,		1.840597875670364e+01,		1.851669719122282e+01,		1.862718008699251e+01,		1.873742818197900e+01,
		1.884744221255757e+01,		1.895722291348956e+01,		1.906677101790005e+01,		1.917608725725613e+01,		1.928517236134586e+01,
		1.939402705825785e+01,		1.950265207436133e+01,		1.961104813428702e+01,		1.971921596090845e+01,		1.982715627532384e+01,
		1.993486979683869e+01,		2.004235724294881e+01,		2.014961932932397e+01,		2.025665676979210e+01,		2.036347027632393e+01,
		2.047006055901835e+01,		2.057642832608809e+01,		2.068257428384604e+01,		2.078849913669204e+01,		2.089420358710013e+01,
		2.099968833560633e+01,		2.110495408079688e+01,		2.121000151929695e+01,		2.131483134575981e+01,		2.141944425285645e+01,
		2.152384093126560e+01,		2.162802206966430e+01,		2.173198835471876e+01,		2.183574047107572e+01,		2.193927910135424e+01,
		2.204260492613774e+01,		2.214571862396664e+01,		2.224862087133127e+01,		2.235131234266511e+01,		2.245379371033858e+01,
		2.255606564465294e+01,		2.265812881383480e+01,		2.275998388403073e+01,		2.286163151930246e+01,		2.296307238162224e+01,
		2.306430713086850e+01,		2.316533642482201e+01,		2.326616091916215e+01,		2.336678126746365e+01,		2.346719812119346e+01,
		2.356741212970808e+01,		2.366742394025103e+01,		2.376723419795068e+01,		2.386684354581837e+01,		2.396625262474665e+01,
		2.406546207350799e+01,		2.416447252875355e+01,		2.426328462501232e+01,		2.436189899469043e+01,		2.446031626807074e+01,
		2.455853707331264e+01,		2.465656203645202e+01,		2.475439178140154e+01,		2.485202692995109e+01,		2.494946810176845e+01,
		2.504671591440004e+01,		2.514377098327214e+01,		2.524063392169194e+01,		2.533730534084914e+01,		2.543378584981740e+01,
		2.553007605555619e+01,		2.562617656291279e+01,		2.572208797462428e+01,		2.581781089131989e+01,		2.591334591152346e+01,
		2.600869363165597e+01,		2.610385464603831e+01,		2.619882954689410e+01,		2.629361892435281e+01,		2.638822336645280e+01,
		2.648264345914470e+01,		2.657687978629476e+01,		2.667093292968842e+01,		2.676480346903397e+01,		2.685849198196632e+01,
		2.695199904405087e+01,		2.704532522878753e+01,		2.713847110761484e+01,		2.723143724991414e+01,		2.732422422301391e+01,
		2.741683259219417e+01,		2.750926292069097e+01,		2.760151576970097e+01,		2.769359169838615e+01,		2.778549126387854e+01,
		2.787721502128508e+01,		2.796876352369253e+01,		2.806013732217246e+01,		2.815133696578637e+01,		2.824236300159076e+01,
		2.833321597464237e+01,		2.842389642800351e+01,		2.851440490274731e+01,		2.860474193796315e+01,		2.869490807076217e+01,
		2.878490383628268e+01,		2.887472976769586e+01,		2.896438639621125e+01,		2.905387425108253e+01,		2.914319385961312e+01,
		2.923234574716209e+01,		2.932133043714984e+01,		2.941014845106399e+01,		2.949880030846528e+01,		2.958728652699352e+01,
		2.967560762237346e+01,		2.976376410842092e+01,		2.985175649704868e+01,		2.993958529827263e+01,		3.002725102021787e+01,
		3.011475416912475e+01,		3.020209524935511e+01,		3.028927476339834e+01,		3.037629321187766e+01,		3.046315109355629e+01,
		3.054984890534375e+01,		3.063638714230200e+01,		3.072276629765181e+01,		3.080898686277902e+01,		3.089504932724082e+01,
		3.098095417877209e+01,		3.106670190329175e+01,		3.115229298490907e+01,		3.123772790593003e+01,		3.132300714686368e+01,
		3.140813118642857e+01,		3.149310050155901e+01,		3.157791556741160e+01,		3.166257685737150e+01,		3.174708484305889e+01,
		3.183143999433538e+01,		3.191564277931035e+01,		3.199969366434744e+01,		3.208359311407087e+01,		3.216734159137193e+01,
		3.225093955741531e+01,		3.233438747164557e+01,		3.241768579179345e+01,		3.250083497388245e+01,		3.258383547223499e+01,
		3.266668773947899e+01,		3.274939222655418e+01,		3.283194938271848e+01,		3.291435965555441e+01,		3.299662349097543e+01,
		3.307874133323232e+01,		3.316071362491949e+01,		3.324254080698142e+01,		3.332422331871893e+01,		3.340576159779550e+01,
		3.348715608024362e+01,		3.356840720047112e+01,		3.364951539126736e+01,		3.373048108380966e+01,		3.381130470766951e+01,
		3.389198669081879e+01,		3.397252745963609e+01,		3.405292743891287e+01,		3.413318705185980e+01,		3.421330672011286e+01,
		3.429328686373956e+01,		3.437312790124520e+01,		3.445283024957891e+01,		3.453239432413991e+01,		3.461182053878359e+01,
		3.469110930582765e+01,		3.477026103605821e+01,		3.484927613873588e+01,		3.492815502160185e+01,		3.500689809088393e+01,
		3.508550575130265e+01,		3.516397840607715e+01,		3.524231645693134e+01,		3.532052030409981e+01,		3.539859034633376e+01,
		3.547652698090705e+01,		3.555433060362206e+01,		3.563200160881564e+01,		3.570954038936494e+01,		3.578694733669344e+01,
		3.586422284077666e+01,		3.594136729014805e+01,		3.601838107190483e+01,		3.609526457171379e+01,		3.617201817381705e+01,
		3.624864226103784e+01,		3.632513721478625e+01,		3.640150341506494e+01,		3.647774124047485e+01,		3.655385106822089e+01,
		3.662983327411765e+01,		3.670568823259492e+01,		3.678141631670346e+01,		3.685701789812050e+01,		3.693249334715537e+01,
		3.700784303275513e+01,		3.708306732250991e+01,		3.715816658265872e+01,		3.723314117809471e+01,		3.730799147237072e+01,
		3.738271782770493e+01,		3.745732060498595e+01,		3.753180016377856e+01,		3.760615686232892e+01,		3.768039105757008e+01,
		3.775450310512721e+01,		3.782849335932306e+01,		3.790236217318321e+01,		3.797610989844135e+01,		3.804973688554464e+01,
		3.812324348365890e+01,		3.819663004067385e+01,		3.826989690320838e+01,		3.834304441661567e+01,		3.841607292498839e+01,
		3.848898277116391e+01,		3.856177429672934e+01,		3.863444784202672e+01,		3.870700374615807e+01,		3.877944234699044e+01,
		3.885176398116107e+01,		3.892396898408228e+01,		3.899605768994656e+01,		3.906803043173154e+01,		3.913988754120498e+01,
		3.921162934892966e+01,		3.928325618426841e+01,		3.935476837538891e+01,		3.942616624926864e+01,		3.949745013169970e+01,
		3.956862034729376e+01,		3.963967721948675e+01,		3.971062107054377e+01,		3.978145222156385e+01,		3.985217099248466e+01,
		3.992277770208734e+01,		3.999327266800121e+01,		4.006365620670839e+01,		4.013392863354865e+01,		4.020409026272392e+01,
		4.027414140730304e+01,		4.034408237922632e+01,		4.041391348931020e+01,		4.048363504725182e+01,		4.055324736163360e+01,
		4.062275073992775e+01,		4.069214548850087e+01,		4.076143191261842e+01,		4.083061031644917e+01,		4.089968100306979e+01,
		4.096864427446919e+01,		4.103750043155302e+01,		4.110624977414808e+01,		4.117489260100665e+01,		4.124342920981100e+01,
		4.131185989717762e+01,		4.138018495866164e+01,		4.144840468876114e+01,		4.151651938092142e+01,		4.158452932753931e+01,
		4.165243481996746e+01,		4.172023614851854e+01,		4.178793360246953e+01,		4.185552747006583e+01,		4.192301803852559e+01,
		4.199040559404384e+01,		4.205769042179654e+01,		4.212487280594485e+01,		4.219195302963924e+01,		4.225893137502351e+01,
		4.232580812323901e+01,		4.239258355442853e+01,		4.245925794774052e+01,		4.252583158133304e+01,		4.259230473237781e+01,
		4.265867767706414e+01,		4.272495069060302e+01,		4.279112404723102e+01,		4.285719802021421e+01,		4.292317288185218e+01,
		4.298904890348184e+01,		4.305482635548142e+01,		4.312050550727427e+01,		4.318608662733283e+01,		4.325156998318234e+01,
		4.331695584140471e+01,		4.338224446764247e+01,		4.344743612660230e+01,		4.351253108205910e+01,		4.357752959685953e+01,
		4.364243193292589e+01,		4.370723835125977e+01,		4.377194911194582e+01,		4.383656447415538e+01,		4.390108469615032e+01,
		4.396551003528644e+01,		4.402984074801743e+01,		4.409407708989821e+01,		4.415821931558879e+01,		4.422226767885774e+01,
		4.428622243258581e+01,		4.435008382876947e+01,		4.441385211852453e+01,		4.447752755208968e+01,		4.454111037882991e+01,
		4.460460084724016e+01,		4.466799920494870e+01,		4.473130569872070e+01,		4.479452057446166e+01,		4.485764407722080e+01,
		4.492067645119457e+01,		4.498361793973010e+01,		4.504646878532855e+01,		4.510922922964840e+01,		4.517189951350905e+01,
		4.523447987689400e+01,		4.529697055895431e+01,		4.535937179801182e+01,		4.542168383156256e+01,		4.548390689628005e+01,
		4.554604122801852e+01,		4.560808706181622e+01,		4.567004463189874e+01,		4.573191417168213e+01,		4.579369591377629e+01,
		4.585539008998803e+01,		4.591699693132438e+01,		4.597851666799573e+01,		4.603994952941910e+01,		4.610129574422111e+01,
		4.616255554024135e+01,		4.622372914453538e+01,		4.628481678337785e+01,		4.634581868226574e+01,		4.640673506592126e+01,
		4.646756615829507e+01,		4.652831218256933e+01,		4.658897336116073e+01,		4.664954991572355e+01,		4.671004206715265e+01,
		4.677045003558652e+01,		4.683077404041033e+01,		4.689101430025878e+01,		4.695117103301925e+01,		4.701124445583464e+01,
		4.707123478510636e+01,		4.713114223649727e+01,		4.719096702493466e+01,		4.725070936461303e+01,		4.731036946899712e+01
	},
	{
		7.562950309274907e-02,		2.267854548611227e-01,		3.776025218372921e-01,		5.280815508176937e-01,		6.782233734301971e-01,
		8.280288071174322e-01,		9.774986560754642e-01,		1.126633712149520e+00,		1.275434755688409e+00,		1.423902556359205e+00,
		1.572037873923719e+00,		1.719841458978218e+00,		1.867314053657800e+00,		2.014456392306770e+00,		2.161269202116352e+00,
		2.307753203730962e+00,		2.453909111824280e+00,		2.599737635646287e+00,		2.745239479542385e+00,		2.890415343445704e+00,
		3.035265923343641e+00,		3.179791911719635e+00,		3.323993997971165e+00,		3.467872868804921e+00,		3.611429208610035e+00,
		3.754663699810273e+00,		3.897577023196029e+00,		4.040169858236926e+00,		4.182442883375828e+00,		4.324396776305032e+00,
		4.466032214225346e+00,		4.607349874088785e+00,		4.748350432825567e+00,		4.889034567556072e+00,		5.029402955788381e+00,
		5.169456275602045e+00,		5.309195205818631e+00,		5.448620426159676e+00,		5.587732617392547e+00,		5.726532461464765e+00,
		5.865020641627312e+00,		6.003197842547393e+00,		6.141064750411171e+00,		6.278622053016884e+00,		6.415870439858821e+00,
		6.552810602202586e+00,		6.689443233152052e+00,		6.825769027708390e+00,		6.961788682821592e+00,		7.097502897434808e+00,
		7.232912372521913e+00,		7.368017811118564e+00,		7.502819918347159e+00,		7.637319401435977e+00,		7.771516969732772e+00,
		7.905413334713178e+00,		8.039009209984160e+00,		8.172305311282804e+00,		8.305302356470674e+00,		8.438001065524057e+00,
		8.570402160520226e+00,		8.702506365620085e+00,		8.834314407047273e+00,		8.965827013064089e+00,		9.097044913944302e+00,
		9.227968841943140e+00,		9.358599531264614e+00,		9.488937718026337e+00,		9.618984140222027e+00,		9.748739537681882e+00,
		9.878204652030949e+00,		1.000738022664563e+01,		1.013626700660851e+01,		1.026486573866169e+01,		1.039317717115854e+01,
		1.052120205401429e+01,		1.064894113865540e+01,		1.077639517796784e+01,		1.090356492624444e+01,		1.103045113913140e+01,
		1.115705457357400e+01,		1.128337598776171e+01,		1.140941614107273e+01,		1.153517579401800e+01,		1.166065570818488e+01,
		1.178585664618046e+01,		1.191077937157466e+01,		1.203542464884310e+01,		1.215979324330997e+01,		1.228388592109073e+01,
		1.240770344903487e+01,		1.253124659466881e+01,		1.265451612613882e+01,		1.277751281215413e+01,		1.290023742193033e+01,
		1.302269072513299e+01,		1.314487349182157e+01,		1.326678649239368e+01,		1.338843049752978e+01,		1.350980627813823e+01,
		1.363091460530081e+01,		1.375175625021876e+01,		1.387233198415925e+01,		1.399264257840248e+01,		1.411268880418925e+01,
		1.423247143266917e+01,		1.435199123484946e+01,		1.447124898154437e+01,		1.459024544332519e+01,		1.470898139047102e+01,
		1.482745759292010e+01,		1.494567482022191e+01,		1.506363384148990e+01,		1.518133542535497e+01,		1.529878033991964e+01,
		1.541596935271290e+01,		1.553290323064592e+01,		1.564958273996839e+01,		1.576600864622557e+01,		1.588218171421622e+01,
		1.599810270795112e+01,		1.611377239061250e+01,		1.622919152451409e+01,		1.634436087106202e+01,		1.645928119071636e+01,
		1.657395324295361e+01,		1.668837778622967e+01,		1.680255557794382e+01,		1.691648737440334e+01,		1.703017393078879e+01,
		1.714361600112020e+01,		1.725681433822389e+01,		1.736976969370006e+01,		1.748248281789109e+01,		1.759495445985058e+01,
		1.770718536731318e+01,		1.781917628666493e+01,		1.793092796291457e+01,		1.804244113966537e+01,		1.815371655908769e+01,
		1.826475496189230e+01,		1.837555708730432e+01,		1.848612367303781e+01,		1.859645545527110e+01,		1.870655316862274e+01,
		1.881641754612813e+01,		1.892604931921665e+01,		1.903544921768974e+01,		1.914461796969920e+01,		1.925355630172652e+01,
		1.936226493856244e+01,		1.947074460328745e+01,		1.957899601725260e+01,		1.968701990006113e+01,		1.979481696955049e+01,
		1.990238794177503e+01,		2.000973353098924e+01,		2.011685444963151e+01,		2.022375140830848e+01,		2.033042511577979e+01,
		2.043687627894363e+01,		2.054310560282243e+01,		2.064911379054942e+01,		2.075490154335541e+01,		2.086046956055624e+01,
		2.096581853954061e+01,		2.107094917575843e+01,		2.117586216270960e+01,		2.128055819193331e+01,		2.138503795299766e+01,
		2.148930213348989e+01,		2.159335141900687e+01,		2.169718649314614e+01,		2.180080803749728e+01,		2.190421673163374e+01,
		2.200741325310504e+01,		2.211039827742937e+01,		2.221317247808652e+01,		2.231573652651130e+01,		2.241809109208723e+01,
		2.252023684214058e+01,		2.262217444193485e+01,		2.272390455466546e+01,		2.282542784145498e+01,		2.292674496134843e+01,
		2.302785657130910e+01,		2.312876332621463e+01,		2.322946587885337e+01,		2.332996487992106e+01,		2.343026097801774e+01,
		2.353035481964518e+01,		2.363024704920419e+01,		2.372993830899266e+01,		2.382942923920346e+01,		2.392872047792290e+01,
		2.402781266112929e+01,		2.412670642269175e+01,		2.422540239436941e+01,		2.432390120581061e+01,		2.442220348455258e+01,
		2.452030985602110e+01,		2.461822094353067e+01,		2.471593736828456e+01,		2.481345974937538e+01,		2.491078870378565e+01,
		2.500792484638864e+01,		2.510486878994942e+01,		2.520162114512607e+01,		2.529818252047105e+01,		2.539455352243285e+01,
		2.549073475535767e+01,		2.558672682149141e+01,		2.568253032098173e+01,		2.577814585188029e+01,		2.587357401014514e+01,
		2.596881538964337e+01,		2.606387058215369e+01,		2.615874017736938e+01,		2.625342476290121e+01,		2.634792492428059e+01,
		2.644224124496286e+01,		2.653637430633060e+01,		2.663032468769718e+01,		2.672409296631038e+01,		2.681767971735613e+01,
		2.691108551396233e+01,		2.700431092720290e+01,		2.709735652610176e+01,		2.719022287763702e+01,		2.728291054674531e+01,
		2.737542009632608e+01,		2.746775208724609e+01,		2.755990707834394e+01,		2.765188562643475e+01,		2.774368828631483e+01,
		2.783531561076654e+01,		2.792676815056309e+01,		2.801804645447360e+01,		2.810915106926804e+01,		2.820008253972238e+01,
		2.829084140862372e+01,		2.838142821677560e+01,		2.847184350300319e+01,		2.856208780415876e+01,		2.865216165512696e+01,
		2.874206558883046e+01,		2.883180013623531e+01,		2.892136582635666e+01,		2.901076318626425e+01,		2.909999274108822e+01,
		2.918905501402472e+01,		2.927795052634174e+01,		2.936667979738487e+01,		2.945524334458321e+01,		2.954364168345515e+01,
		2.963187532761441e+01,		2.971994478877588e+01,		2.980785057676169e+01,		2.989559319950718e+01,		2.998317316306699e+01,
		3.007059097162103e+01,		3.015784712748073e+01,		3.024494213109507e+01,		3.033187648105674e+01,		3.041865067410832e+01,
		3.050526520514846e+01,		3.059172056723816e+01,		3.067801725160686e+01,		3.076415574765882e+01,		3.085013654297931e+01,
		3.093596012334092e+01,		3.102162697270979e+01,		3.110713757325199e+01,		3.119249240533978e+01,		3.127769194755793e+01,
		3.136273667671009e+01,		3.144762706782506e+01,		3.153236359416320e+01,		3.161694672722275e+01,		3.170137693674619e+01,
		3.178565469072657e+01,		3.186978045541392e+01,		3.195375469532157e+01,		3.203757787323255e+01,		3.212125045020593e+01,
		3.220477288558320e+01,		3.228814563699461e+01,		3.237136916036557e+01,		3.245444390992296e+01,		3.253737033820153e+01,
		3.262014889605022e+01,		3.270278003263857e+01,		3.278526419546294e+01,		3.286760183035296e+01,		3.294979338147782e+01,
		3.303183929135260e+01,		3.311374000084454e+01,		3.319549594917941e+01,		3.327710757394781e+01,		3.335857531111135e+01,
		3.343989959500910e+01,		3.352108085836371e+01,		3.360211953228776e+01,		3.368301604628994e+01,		3.376377082828137e+01,
		3.384438430458170e+01,		3.392485689992548e+01,		3.400518903746823e+01,		3.408538113879268e+01,		3.416543362391489e+01,
		3.424534691129054e+01,		3.432512141782090e+01,		3.440475755885910e+01,		3.448425574821616e+01,		3.456361639816713e+01,
		3.464283991945715e+01,		3.472192672130754e+01,		3.480087721142186e+01,		3.487969179599194e+01,		3.495837087970383e+01,
		3.503691486574393e+01,		3.511532415580488e+01,		3.519359915009158e+01,		3.527174024732710e+01,		3.534974784475865e+01,
		3.542762233816348e+01,		3.550536412185478e+01,		3.558297358868758e+01,		3.566045113006456e+01,		3.573779713594198e+01,
		3.581501199483540e+01,		3.589209609382556e+01,		3.596904981856421e+01,		3.604587355327968e+01,		3.612256768078291e+01,
		3.619913258247294e+01,		3.627556863834276e+01,		3.635187622698498e+01,		3.642805572559742e+01,		3.650410750998886e+01,
		3.658003195458465e+01,		3.665582943243226e+01,		3.673150031520699e+01,		3.680704497321742e+01,		3.688246377541102e+01,
		3.695775708937970e+01,		3.703292528136531e+01,		3.710796871626506e+01,		3.718288775763716e+01,		3.725768276770608e+01,
		3.733235410736809e+01,		3.740690213619670e+01,		3.748132721244792e+01,		3.755562969306576e+01,		3.762980993368753e+01,
		3.770386828864915e+01,		3.777780511099051e+01,		3.785162075246068e+01,		3.792531556352327e+01,		3.799888989336159e+01,
		3.807234408988396e+01,		3.814567849972884e+01,		3.821889346827005e+01,		3.829198933962197e+01,		3.836496645664463e+01,
		3.843782516094883e+01,		3.851056579290130e+01,		3.858318869162974e+01,		3.865569419502788e+01,		3.872808263976056e+01,
		3.880035436126870e+01,		3.887250969377436e+01,		3.894454897028566e+01,		3.901647252260181e+01,		3.908828068131795e+01,
		3.915997377583020e+01,		3.923155213434046e+01,		3.930301608386130e+01,		3.937436595022088e+01,		3.944560205806778e+01,
		3.951672473087568e+01,		3.958773429094839e+01,		3.965863105942444e+01,		3.972941535628197e+01,		3.980008750034332e+01,
		3.987064780927995e+01,		3.994109659961696e+01,		4.001143418673784e+01,		4.008166088488920e+01,		4.015177700718524e+01,
		4.022178286561259e+01,		4.029167877103470e+01,		4.036146503319660e+01,		4.043114196072933e+01,		4.050070986115456e+01,
		4.057016904088909e+01,		4.063951980524935e+01,		4.070876245845594e+01,		4.077789730363800e+01,		4.084692464283771e+01,
		4.091584477701478e+01,		4.098465800605075e+01,		4.105336462875341e+01,		4.112196494286125e+01,		4.119045924504778e+01,
		4.125884783092575e+01,		4.132713099505163e+01,		4.139530903092983e+01,		4.146338223101699e+01,		4.153135088672622e+01,
		4.159921528843138e+01,		4.166697572547133e+01,		4.173463248615399e+01,		4.180218585776073e+01,		4.186963612655043e+01,
		4.193698357776362e+01,		4.200422849562666e+01,		4.207137116335581e+01,		4.213841186316139e+01,		4.220535087625186e+01,
		4.227218848283773e+01,		4.233892496213591e+01,		4.240556059237338e+01,		4.247209565079150e+01,		4.253853041364985e+01,
		4.260486515623019e+01,		4.267110015284054e+01,		4.273723567681901e+01,		4.280327200053780e+01,		4.286920939540703e+01,
		4.293504813187868e+01,		4.300078847945053e+01,		4.306643070666986e+01,		4.313197508113741e+01,		4.319742186951116e+01,
		4.326277133751021e+01,		4.332802374991845e+01,		4.339317937058840e+01,		4.345823846244497e+01,		4.352320128748921e+01,
		4.358806810680202e+01,		4.365283918054786e+01,		4.371751476797844e+01,		4.378209512743640e+01,		4.384658051635898e+01,
		4.391097119128165e+01,		4.397526740784176e+01,		4.403946942078215e+01,		4.410357748395472e+01,		4.416759185032404e+01,
		4.423151277197096e+01,		4.429534050009601e+01,		4.435907528502315e+01,		4.442271737620312e+01,		4.448626702221704e+01,
		4.454972447077981e+01,		4.461308996874373e+01,		4.467636376210179e+01,		4.473954609599126e+01,		4.480263721469701e+01,
		4.486563736165502e+01,		4.492854677945569e+01,		4.499136570984734e+01,		4.505409439373946e+01,		4.511673307120610e+01,
		4.517928198148926e+01,		4.524174136300224e+01,		4.530411145333280e+01,		4.536639248924666e+01,		4.542858470669064e+01,
		4.549068834079596e+01,		4.555270362588155e+01,		4.561463079545727e+01,		4.567647008222703e+01,		4.573822171809223e+01,
		4.579988593415474e+01,		4.586146296072018e+01,		4.592295302730115e+01,		4.598435636262026e+01,		4.604567319461338e+01,
		4.610690375043273e+01,		4.616804825644997e+01,		4.622910693825940e+01,		4.629008002068092e+01,		4.635096772776326e+01,
		4.641177028278687e+01,		4.647248790826713e+01,		4.653312082595729e+01,		4.659366925685155e+01,		4.665413342118803e+01,
		4.671451353845180e+01,		4.677480982737784e+01,		4.683502250595405e+01,		4.689515179142419e+01,		4.695519790029080e+01,
		4.701516104831821e+01,		4.707504145053534e+01,		4.713483932123876e+01,		4.719455487399549e+01,		4.725418832164589e+01
	},
	{
		7.548748353291569e-02,		2.263599033359752e-01,		3.768944932640348e-01,		5.270920988775530e-01,		6.769535506802093e-01,
		8.264796650913534e-01,		9.756712453743637e-01,		1.124529082522602e+00,		1.273053956104575e+00,		1.421246635069849e+00,
		1.569107878517244e+00,		1.716638436426708e+00,		1.863839050356296e+00,		2.010710454105576e+00,		2.157253374346738e+00,
		2.303468531224687e+00,		2.449356638927271e+00,		2.594918406226837e+00,		2.740154536994205e+00,		2.885065730686153e+00,
		3.029652682807424e+00,		3.173916085348291e+00,		3.317856627198602e+00,		3.461474994539272e+00,		3.604771871212102e+00,
		3.747747939068791e+00,		3.890403878299990e+00,		4.032740367745186e+00,		4.174758085184210e+00,		4.316457707611121e+00,
		4.457839911491186e+00,		4.598905373001646e+00,		4.739654768256967e+00,		4.880088773519213e+00,		5.020208065394175e+00,
		5.160013321013856e+00,		5.299505218205900e+00,		5.438684435650552e+00,		5.577551653025665e+00,		5.716107551140269e+00,
		5.854352812057281e+00,		5.992288119205739e+00,		6.129914157483133e+00,		6.267231613348216e+00,		6.404241174904767e+00,
		6.540943531976726e+00,		6.677339376175104e+00,		6.813429400957049e+00,		6.949214301677460e+00,		7.084694775633533e+00,
		7.219871522102522e+00,		7.354745242373144e+00,		7.489316639770867e+00,		7.623586419677456e+00,		7.757555289545055e+00,
		7.891223958905066e+00,		8.024593139372168e+00,		8.157663544643675e+00,		8.290435890494553e+00,		8.422910894768263e+00,
		8.555089277363772e+00,		8.686971760218873e+00,		8.818559067290053e+00,		8.949851924529161e+00,		9.080851059857027e+00,
		9.211557203134239e+00,		9.341971086129295e+00,		9.472093442484248e+00,		9.601925007678078e+00,		9.731466518987917e+00,
		9.860718715448266e+00,		9.989682337808416e+00,		1.011835812848817e+01,		1.024674683153197e+01,		1.037484919256167e+01,
		1.050266595872795e+01,		1.063019787866059e+01,		1.075744570241768e+01,		1.088441018143381e+01,		1.101109206846753e+01,
		1.113749211754793e+01,		1.126361108392063e+01,		1.138944972399322e+01,		1.151500879528014e+01,		1.164028905634722e+01,
		1.176529126675588e+01,		1.189001618700708e+01,		1.201446457848505e+01,		1.213863720340097e+01,		1.226253482473655e+01,
		1.238615820618758e+01,		1.250950811210767e+01,		1.263258530745193e+01,		1.275539055772094e+01,		1.287792462890489e+01,
		1.300018828742799e+01,		1.312218230009311e+01,		1.324390743402684e+01,		1.336536445662490e+01,		1.348655413549792e+01,
		1.360747723841766e+01,		1.372813453326378e+01,		1.384852678797099e+01,		1.396865477047680e+01,		1.408851924866982e+01,
		1.420812099033856e+01,		1.432746076312087e+01,		1.444653933445405e+01,		1.456535747152541e+01,		1.468391594122367e+01,
		1.480221551009090e+01,		1.492025694427515e+01,		1.503804100948379e+01,		1.515556847093748e+01,		1.527284009332497e+01,
		1.538985664075842e+01,		1.550661887672966e+01,		1.562312756406695e+01,		1.573938346489263e+01,		1.585538734058146e+01,
		1.597113995171968e+01,		1.608664205806479e+01,		1.620189441850616e+01,		1.631689779102624e+01,		1.643165293266267e+01,
		1.654616059947102e+01,		1.666042154648833e+01,		1.677443652769734e+01,		1.688820629599154e+01,		1.700173160314085e+01,
		1.711501319975814e+01,		1.722805183526640e+01,		1.734084825786662e+01,		1.745340321450653e+01,		1.756571745084991e+01,
		1.767779171124662e+01,		1.778962673870342e+01,		1.790122327485548e+01,		1.801258205993845e+01,		1.812370383276140e+01,
		1.823458933068035e+01,		1.834523928957237e+01,		1.845565444381064e+01,		1.856583552623980e+01,		1.867578326815228e+01,
		1.878549839926501e+01,		1.889498164769698e+01,		1.900423373994728e+01,		1.911325540087383e+01,		1.922204735367269e+01,
		1.933061031985798e+01,		1.943894501924248e+01,		1.954705216991862e+01,		1.965493248824031e+01,		1.976258668880501e+01,
		1.987001548443678e+01,		1.997721958616946e+01,		2.008419970323067e+01,		2.019095654302629e+01,		2.029749081112537e+01,
		2.040380321124569e+01,		2.050989444523973e+01,		2.061576521308119e+01,		2.072141621285200e+01,		2.082684814072981e+01,
		2.093206169097593e+01,		2.103705755592378e+01,		2.114183642596775e+01,		2.124639898955258e+01,		2.135074593316313e+01,
		2.145487794131454e+01,		2.155879569654296e+01,		2.166249987939653e+01,		2.176599116842687e+01,		2.186927024018099e+01,
		2.197233776919347e+01,		2.207519442797921e+01,		2.217784088702634e+01,		2.228027781478970e+01,		2.238250587768459e+01,
		2.248452574008084e+01,		2.258633806429729e+01,		2.268794351059663e+01,		2.278934273718048e+01,		2.289053640018487e+01,
		2.299152515367604e+01,		2.309230964964648e+01,		2.319289053801142e+01,		2.329326846660539e+01,		2.339344408117933e+01,
		2.349341802539782e+01,		2.359319094083658e+01,		2.369276346698036e+01,		2.379213624122101e+01,		2.389130989885579e+01,
		2.399028507308604e+01,		2.408906239501594e+01,		2.418764249365171e+01,		2.428602599590080e+01,		2.438421352657157e+01,
		2.448220570837302e+01,		2.458000316191475e+01,		2.467760650570724e+01,		2.477501635616223e+01,		2.487223332759335e+01,
		2.496925803221695e+01,		2.506609108015308e+01,		2.516273307942674e+01,		2.525918463596924e+01,		2.535544635361973e+01,
		2.545151883412698e+01,		2.554740267715126e+01,		2.564309848026640e+01,		2.573860683896204e+01,		2.583392834664596e+01,
		2.592906359464668e+01,		2.602401317221609e+01,		2.611877766653227e+01,		2.621335766270246e+01,		2.630775374376617e+01,
		2.640196649069834e+01,		2.649599648241276e+01,		2.658984429576556e+01,		2.668351050555865e+01,		2.677699568454364e+01,
		2.687030040342548e+01,		2.696342523086648e+01,		2.705637073349036e+01,		2.714913747588628e+01,		2.724172602061322e+01,
		2.733413692820416e+01,		2.742637075717064e+01,		2.751842806400715e+01,		2.761030940319586e+01,		2.770201532721112e+01,
		2.779354638652445e+01,		2.788490312960918e+01,		2.797608610294549e+01,		2.806709585102535e+01,		2.815793291635758e+01,
		2.824859783947300e+01,		2.833909115892960e+01,		2.842941341131780e+01,		2.851956513126580e+01,		2.860954685144489e+01,
		2.869935910257491e+01,		2.878900241342978e+01,		2.887847731084296e+01,		2.896778431971305e+01,		2.905692396300948e+01,
		2.914589676177811e+01,		2.923470323514700e+01,		2.932334390033216e+01,		2.941181927264334e+01,		2.950012986548987e+01,
		2.958827619038658e+01,		2.967625875695963e+01,		2.976407807295252e+01,		2.985173464423203e+01,		2.993922897479422e+01,
		3.002656156677052e+01,		3.011373292043370e+01,		3.020074353420398e+01,		3.028759390465520e+01,		3.037428452652085e+01,
		3.046081589270028e+01,		3.054718849426486e+01,		3.063340282046414e+01,		3.071945935873207e+01,		3.080535859469325e+01,
		3.089110101216909e+01,		3.097668709318410e+01,		3.106211731797218e+01,		3.114739216498280e+01,		3.123251211088735e+01,
		3.131747763058542e+01,		3.140228919721105e+01,		3.148694728213910e+01,		3.157145235499148e+01,		3.165580488364352e+01,
		3.174000533423027e+01,		3.182405417115282e+01,		3.190795185708458e+01,		3.199169885297770e+01,		3.207529561806930e+01,
		3.215874260988782e+01,		3.224204028425935e+01,		3.232518909531399e+01,		3.240818949549209e+01,		3.249104193555060e+01,
		3.257374686456939e+01,		3.265630472995758e+01,		3.273871597745978e+01,		3.282098105116241e+01,		3.290310039350005e+01,
		3.298507444526160e+01,		3.306690364559670e+01,		3.314858843202185e+01,		3.323012924042678e+01,		3.331152650508069e+01,
		3.339278065863839e+01,		3.347389213214664e+01,		3.355486135505036e+01,		3.363568875519876e+01,		3.371637475885161e+01,
		3.379691979068537e+01,		3.387732427379947e+01,		3.395758862972231e+01,		3.403771327841754e+01,		3.411769863829016e+01,
		3.419754512619259e+01,		3.427725315743083e+01,		3.435682314577055e+01,		3.443625550344313e+01,		3.451555064115179e+01,
		3.459470896807755e+01,		3.467373089188533e+01,		3.475261681872994e+01,		3.483136715326211e+01,		3.490998229863440e+01,
		3.498846265650724e+01,		3.506680862705487e+01,		3.514502060897123e+01,		3.522309899947594e+01,		3.530104419432012e+01,
		3.537885658779238e+01,		3.545653657272457e+01,		3.553408454049766e+01,		3.561150088104768e+01,		3.568878598287128e+01,
		3.576594023303181e+01,		3.584296401716490e+01,		3.591985771948429e+01,		3.599662172278750e+01,		3.607325640846163e+01,
		3.614976215648900e+01,		3.622613934545286e+01,		3.630238835254301e+01,		3.637850955356148e+01,		3.645450332292810e+01,
		3.653037003368619e+01,		3.660611005750800e+01,		3.668172376470039e+01,		3.675721152421037e+01,		3.683257370363049e+01,
		3.690781066920451e+01,		3.698292278583276e+01,		3.705791041707764e+01,		3.713277392516911e+01,		3.720751367100998e+01,
		3.728213001418145e+01,		3.735662331294844e+01,		3.743099392426490e+01,		3.750524220377923e+01,		3.757936850583951e+01,
		3.765337318349887e+01,		3.772725658852080e+01,		3.780101907138425e+01,		3.787466098128907e+01,		3.794818266616105e+01,
		3.802158447265724e+01,		3.809486674617106e+01,		3.816802983083750e+01,		3.824107406953821e+01,		3.831399980390663e+01,
		3.838680737433312e+01,		3.845949711997000e+01,		3.853206937873657e+01,		3.860452448732427e+01,		3.867686278120151e+01,
		3.874908459461881e+01,		3.882119026061373e+01,		3.889318011101582e+01,		3.896505447645151e+01,		3.903681368634910e+01,
		3.910845806894359e+01,		3.917998795128164e+01,		3.925140365922624e+01,		3.932270551746178e+01,		3.939389384949867e+01,
		3.946496897767823e+01,		3.953593122317744e+01,		3.960678090601365e+01,		3.967751834504949e+01,		3.974814385799723e+01,
		3.981865776142390e+01,		3.988906037075559e+01,		3.995935200028237e+01,		4.002953296316277e+01,		4.009960357142848e+01,
		4.016956413598889e+01,		4.023941496663571e+01,		4.030915637204748e+01,		4.037878865979414e+01,		4.044831213634154e+01,
		4.051772710705596e+01,		4.058703387620855e+01,		4.065623274697982e+01,		4.072532402146405e+01,		4.079430800067379e+01,
		4.086318498454415e+01,		4.093195527193730e+01,		4.100061916064672e+01,		4.106917694740167e+01,		4.113762892787143e+01,
		4.120597539666965e+01,		4.127421664735864e+01,		4.134235297245361e+01,		4.141038466342700e+01,		4.147831201071262e+01,
		4.154613530370994e+01,		4.161385483078828e+01,		4.168147087929097e+01,		4.174898373553955e+01,		4.181639368483788e+01,
		4.188370101147625e+01,		4.195090599873559e+01,		4.201800892889145e+01,		4.208501008321819e+01,		4.215190974199286e+01,
		4.221870818449948e+01,		4.228540568903283e+01,		4.235200253290264e+01,		4.241849899243747e+01,		4.248489534298869e+01,
		4.255119185893455e+01,		4.261738881368388e+01,		4.268348647968030e+01,		4.274948512840584e+01,		4.281538503038509e+01,
		4.288118645518885e+01,		4.294688967143814e+01,		4.301249494680791e+01,		4.307800254803097e+01,		4.314341274090171e+01,
		4.320872579027993e+01,		4.327394196009463e+01,		4.333906151334767e+01,		4.340408471211761e+01,		4.346901181756337e+01,
		4.353384308992801e+01,		4.359857878854225e+01,		4.366321917182837e+01,		4.372776449730368e+01,		4.379221502158429e+01,
		4.385657100038863e+01,		4.392083268854113e+01,		4.398500033997578e+01,		4.404907420773976e+01,		4.411305454399689e+01,
		4.417694160003128e+01,		4.424073562625091e+01,		4.430443687219093e+01,		4.436804558651743e+01,		4.443156201703068e+01,
		4.449498641066881e+01,		4.455831901351110e+01,		4.462156007078155e+01,		4.468470982685220e+01,		4.474776852524666e+01,
		4.481073640864332e+01,		4.487361371887901e+01,		4.493640069695204e+01,		4.499909758302582e+01,		4.506170461643207e+01,
		4.512422203567417e+01,		4.518665007843045e+01,		4.524898898155752e+01,		4.531123898109356e+01,		4.537340031226150e+01,
		4.543547320947235e+01,		4.549745790632848e+01,		4.555935463562670e+01,		4.562116362936163e+01,		4.568288511872871e+01,
		4.574451933412765e+01,		4.580606650516528e+01,		4.586752686065898e+01,		4.592890062863968e+01,		4.599018803635500e+01,
		4.605138931027237e+01,		4.611250467608215e+01,		4.617353435870076e+01,		4.623447858227360e+01,		4.629533757017830e+01,
		4.635611154502767e+01,		4.641680072867270e+01,		4.647740534220567e+01,		4.653792560596309e+01,		4.659836173952873e+01,
		4.665871396173662e+01,		4.671898249067394e+01,		4.677916754368407e+01,		4.683926933736949e+01,		4.689928808759468e+01,
		4.695922400948913e+01,		4.701907731745016e+01,		4.707884822514580e+01,		4.713853694551786e+01,		4.719814369078446e+01
	},
	{
		7.534599650262361e-02,		2.259359472260982e-01,		3.761891186552445e-01,		5.261063550962363e-01,		6.756884859091656e-01,
		8.249363264697552e-01,		9.738506790875360e-01,		1.122432333882151e+00,		1.270682069619375e+00,		1.418600654508382e+00,
		1.566188846961748e+00,		1.713447396319597e+00,		1.860377043539267e+00,		2.006978521851821e+00,		2.153252557386658e+00,
		2.299199869765477e+00,		2.444821172666749e+00,		2.590117174361844e+00,		2.735088578223932e+00,		2.879736083210685e+00,
		3.024060384321827e+00,		3.168062173032513e+00,		3.311742137703483e+00,		3.455100963968909e+00,		3.598139335102841e+00,
		3.740857932365069e+00,		3.883257435327272e+00,		4.025338522180210e+00,		4.167101870022756e+00,		4.308548155133499e+00,
		4.449678053225631e+00,		4.590492239685815e+00,		4.730991389797699e+00,		4.871176178950723e+00,		5.011047282834840e+00,
		5.150605377621730e+00,		5.289851140133128e+00,		5.428785247996786e+00,		5.567408379790621e+00,		5.705721215175569e+00,
		5.843724435017643e+00,		5.981418721499698e+00,		6.118804758223313e+00,		6.255883230301320e+00,		6.392654824441333e+00,
		6.529120229020764e+00,		6.665280134153668e+00,		6.801135231749841e+00,		6.936686215566555e+00,		7.071933781253231e+00,
		7.206878626389474e+00,		7.341521450516741e+00,		7.475862955163985e+00,		7.609903843867607e+00,		7.743644822185973e+00,
		7.877086597708804e+00,		8.010229880061717e+00,		8.143075380906160e+00,		8.275623813935045e+00,		8.407875894864233e+00,
		8.539832341420228e+00,		8.671493873324168e+00,		8.802861212272468e+00,		8.933935081914198e+00,		9.064716207825496e+00,
		9.195205317481140e+00,		9.325403140223473e+00,		9.455310407228927e+00,		9.584927851472175e+00,		9.714256207688226e+00,
		9.843296212332515e+00,		9.972048603539159e+00,		1.010051412107755e+01,		1.022869350630740e+01,		1.035658750213234e+01,
		1.048419685295226e+01,		1.061152230461442e+01,		1.073856460436359e+01,		1.086532450079111e+01,		1.099180274378322e+01,
		1.111800008446850e+01,		1.124391727516482e+01,		1.136955506932554e+01,		1.149491422148534e+01,		1.161999548720559e+01,
		1.174479962301939e+01,		1.186932738637639e+01,		1.199357953558735e+01,		1.211755682976867e+01,		1.224126002878675e+01,
		1.236468989320241e+01,		1.248784718421537e+01,		1.261073266360878e+01,		1.273334709369397e+01,		1.285569123725533e+01,
		1.297776585749547e+01,		1.309957171798071e+01,		1.322110958258676e+01,		1.334238021544493e+01,		1.346338438088861e+01,
		1.358412284340020e+01,		1.370459636755855e+01,		1.382480571798683e+01,		1.394475165930094e+01,		1.406443495605843e+01,
		1.418385637270797e+01,		1.430301667353947e+01,		1.442191662263470e+01,		1.454055698381860e+01,		1.465893852061112e+01,
		1.477706199617988e+01,		1.489492817329328e+01,		1.501253781427445e+01,		1.512989168095575e+01,		1.524699053463408e+01,
		1.536383513602679e+01,		1.548042624522833e+01,		1.559676462166766e+01,		1.571285102406628e+01,		1.582868621039706e+01,
		1.594427093784381e+01,		1.605960596276146e+01,		1.617469204063713e+01,		1.628952992605179e+01,		1.640412037264276e+01,
		1.651846413306686e+01,		1.663256195896435e+01,		1.674641460092359e+01,		1.686002280844637e+01,		1.697338732991406e+01,
		1.708650891255439e+01,		1.719938830240904e+01,		1.731202624430184e+01,		1.742442348180782e+01,		1.753658075722277e+01,
		1.764849881153375e+01,		1.776017838439004e+01,		1.787162021407499e+01,		1.798282503747845e+01,		1.809379359006984e+01,
		1.820452660587202e+01,		1.831502481743569e+01,		1.842528895581459e+01,		1.853531975054119e+01,		1.864511792960313e+01,
		1.875468421942031e+01,		1.886401934482250e+01,		1.897312402902770e+01,		1.908199899362101e+01,		1.919064495853419e+01,
		1.929906264202573e+01,		1.940725276066159e+01,		1.951521602929642e+01,		1.962295316105551e+01,		1.973046486731715e+01,
		1.983775185769559e+01,		1.994481484002459e+01,		2.005165452034144e+01,		2.015827160287165e+01,		2.026466679001390e+01,
		2.037084078232581e+01,		2.047679427850999e+01,		2.058252797540066e+01,		2.068804256795079e+01,		2.079333874921969e+01,
		2.089841721036106e+01,		2.100327864061148e+01,		2.110792372727944e+01,		2.121235315573476e+01,		2.131656760939839e+01,
		2.142056776973276e+01,		2.152435431623249e+01,		2.162792792641547e+01,		2.173128927581443e+01,		2.183443903796887e+01,
		2.193737788441732e+01,		2.204010648469013e+01,		2.214262550630248e+01,		2.224493561474782e+01,		2.234703747349173e+01,
		2.244893174396599e+01,		2.255061908556314e+01,		2.265210015563130e+01,		2.275337560946931e+01,		2.285444610032225e+01,
		2.295531227937720e+01,		2.305597479575945e+01,		2.315643429652877e+01,		2.325669142667623e+01,		2.335674682912119e+01,
		2.345660114470855e+01,		2.355625501220631e+01,		2.365570906830343e+01,		2.375496394760789e+01,		2.385402028264506e+01,
		2.395287870385632e+01,		2.405153983959784e+01,		2.415000431613977e+01,		2.424827275766544e+01,		2.434634578627104e+01,
		2.444422402196527e+01,		2.454190808266941e+01,		2.463939858421747e+01,		2.473669614035667e+01,		2.483380136274797e+01,
		2.493071486096688e+01,		2.502743724250454e+01,		2.512396911276877e+01,		2.522031107508559e+01,		2.531646373070062e+01,
		2.541242767878084e+01,		2.550820351641653e+01,		2.560379183862319e+01,		2.569919323834386e+01,		2.579440830645141e+01,
		2.588943763175106e+01,		2.598428180098299e+01,		2.607894139882521e+01,		2.617341700789644e+01,		2.626770920875913e+01,
		2.636181857992275e+01,		2.645574569784704e+01,		2.654949113694546e+01,		2.664305546958874e+01,		2.673643926610861e+01,
		2.682964309480149e+01,		2.692266752193246e+01,		2.701551311173924e+01,		2.710818042643624e+01,		2.720067002621886e+01,
		2.729298246926766e+01,		2.738511831175287e+01,		2.747707810783872e+01,		2.756886240968814e+01,		2.766047176746735e+01,
		2.775190672935053e+01,		2.784316784152470e+01,		2.793425564819456e+01,		2.802517069158745e+01,		2.811591351195838e+01,
		2.820648464759505e+01,		2.829688463482310e+01,		2.838711400801127e+01,		2.847717329957667e+01,		2.856706303999013e+01,
		2.865678375778158e+01,		2.874633597954549e+01,		2.883572022994638e+01,		2.892493703172433e+01,		2.901398690570060e+01,
		2.910287037078323e+01,		2.919158794397276e+01,		2.928014014036795e+01,		2.936852747317145e+01,		2.945675045369574e+01,
		2.954480959136884e+01,		2.963270539374022e+01,		2.972043836648675e+01,		2.980800901341851e+01,		2.989541783648491e+01,
		2.998266533578053e+01,		3.006975200955121e+01,		3.015667835420009e+01,		3.024344486429365e+01,		3.033005203256779e+01,
		3.041650034993395e+01,		3.050279030548528e+01,		3.058892238650265e+01,		3.067489707846098e+01,		3.076071486503526e+01,
		3.084637622810687e+01,		3.093188164776967e+01,		3.101723160233633e+01,		3.110242656834442e+01,		3.118746702056276e+01,
		3.127235343199762e+01,		3.135708627389899e+01,		3.144166601576680e+01,		3.152609312535724e+01,		3.161036806868895e+01,
		3.169449131004941e+01,		3.177846331200112e+01,		3.186228453538792e+01,		3.194595543934124e+01,		3.202947648128645e+01,
		3.211284811694911e+01,		3.219607080036118e+01,		3.227914498386737e+01,		3.236207111813148e+01,		3.244484965214254e+01,
		3.252748103322114e+01,		3.260996570702572e+01,		3.269230411755884e+01,		3.277449670717333e+01,		3.285654391657869e+01,
		3.293844618484723e+01,		3.302020394942033e+01,		3.310181764611469e+01,		3.318328770912851e+01,		3.326461457104776e+01,
		3.334579866285230e+01,		3.342684041392215e+01,		3.350774025204361e+01,		3.358849860341549e+01,		3.366911589265519e+01,
		3.374959254280493e+01,		3.382992897533785e+01,		3.391012561016409e+01,		3.399018286563700e+01,		3.407010115855912e+01,
		3.414988090418837e+01,		3.422952251624404e+01,		3.430902640691286e+01,		3.438839298685512e+01,		3.446762266521058e+01,
		3.454671584960455e+01,		3.462567294615386e+01,		3.470449435947287e+01,		3.478318049267941e+01,		3.486173174740070e+01,
		3.494014852377937e+01,		3.501843122047926e+01,		3.509658023469142e+01,		3.517459596213993e+01,		3.525247879708777e+01,
		3.533022913234272e+01,		3.540784735926310e+01,		3.548533386776364e+01,		3.556268904632130e+01,		3.563991328198096e+01,
		3.571700696036122e+01,		3.579397046566017e+01,		3.587080418066110e+01,		3.594750848673810e+01,		3.602408376386192e+01,
		3.610053039060548e+01,		3.617684874414957e+01,		3.625303920028851e+01,		3.632910213343568e+01,		3.640503791662921e+01,
		3.648084692153741e+01,		3.655652951846445e+01,		3.663208607635581e+01,		3.670751696280379e+01,		3.678282254405307e+01,
		3.685800318500608e+01,		3.693305924922848e+01,		3.700799109895466e+01,		3.708279909509306e+01,		3.715748359723158e+01,
		3.723204496364298e+01,		3.730648355129021e+01,		3.738079971583172e+01,		3.745499381162677e+01,		3.752906619174078e+01,
		3.760301720795054e+01,		3.767684721074943e+01,		3.775055654935272e+01,		3.782414557170274e+01,		3.789761462447407e+01,
		3.797096405307870e+01,		3.804419420167120e+01,		3.811730541315383e+01,		3.819029802918162e+01,		3.826317239016753e+01,
		3.833592883528741e+01,		3.840856770248514e+01,		3.848108932847761e+01,		3.855349404875979e+01,		3.862578219760954e+01,
		3.869795410809282e+01,		3.877001011206842e+01,		3.884195054019300e+01,		3.891377572192601e+01,		3.898548598553447e+01,
		3.905708165809793e+01,		3.912856306551329e+01,		3.919993053249956e+01,		3.927118438260280e+01,		3.934232493820080e+01,
		3.941335252050782e+01,		3.948426744957944e+01,		3.955507004431725e+01,		3.962576062247344e+01,		3.969633950065570e+01,
		3.976680699433175e+01,		3.983716341783392e+01,		3.990740908436393e+01,		3.997754430599746e+01,		4.004756939368867e+01,
		4.011748465727482e+01,		4.018729040548081e+01,		4.025698694592372e+01,		4.032657458511733e+01,		4.039605362847658e+01,
		4.046542438032207e+01,		4.053468714388447e+01,		4.060384222130907e+01,		4.067288991366004e+01,		4.074183052092495e+01,
		4.081066434201910e+01,		4.087939167478989e+01,		4.094801281602115e+01,		4.101652806143749e+01,		4.108493770570856e+01,
		4.115324204245339e+01,		4.122144136424461e+01,		4.128953596261274e+01,		4.135752612805042e+01,		4.142541215001654e+01,
		4.149319431694060e+01,		4.156087291622671e+01,		4.162844823425785e+01,		4.169592055640003e+01,		4.176329016700632e+01,
		4.183055734942106e+01,		4.189772238598383e+01,		4.196478555803367e+01,		4.203174714591299e+01,		4.209860742897170e+01,
		4.216536668557119e+01,		4.223202519308832e+01,		4.229858322791944e+01,		4.236504106548429e+01,		4.243139898023009e+01,
		4.249765724563525e+01,		4.256381613421350e+01,		4.262987591751766e+01,		4.269583686614362e+01,		4.276169924973404e+01,
		4.282746333698236e+01,		4.289312939563661e+01,		4.295869769250314e+01,		4.302416849345042e+01,		4.308954206341294e+01,
		4.315481866639488e+01,		4.321999856547389e+01,		4.328508202280474e+01,		4.335006929962320e+01,		4.341496065624958e+01,
		4.347975635209254e+01,		4.354445664565265e+01,		4.360906179452608e+01,		4.367357205540831e+01,		4.373798768409763e+01,
		4.380230893549881e+01,		4.386653606362672e+01,		4.393066932160981e+01,		4.399470896169377e+01,		4.405865523524497e+01,
		4.412250839275413e+01,		4.418626868383965e+01,		4.424993635725124e+01,		4.431351166087339e+01,		4.437699484172876e+01,
		4.444038614598173e+01,		4.450368581894175e+01,		4.456689410506679e+01,		4.463001124796680e+01,		4.469303749040702e+01,
		4.475597307431143e+01,		4.481881824076601e+01,		4.488157323002227e+01,		4.494423828150036e+01,		4.500681363379250e+01,
		4.506929952466639e+01,		4.513169619106831e+01,		4.519400386912648e+01,		4.525622279415434e+01,		4.531835320065380e+01,
		4.538039532231839e+01,		4.544234939203665e+01,		4.550421564189514e+01,		4.556599430318172e+01,		4.562768560638880e+01,
		4.568928978121637e+01,		4.575080705657530e+01,		4.581223766059026e+01,		4.587358182060311e+01,		4.593483976317581e+01,
		4.599601171409361e+01,		4.605709789836806e+01,		4.611809854024023e+01,		4.617901386318354e+01,		4.623984408990700e+01,
		4.630058944235819e+01,		4.636125014172624e+01,		4.642182640844482e+01,		4.648231846219515e+01,		4.654272652190910e+01,
		4.660305080577194e+01,		4.666329153122546e+01,		4.672344891497079e+01,		4.678352317297150e+01,		4.684351452045627e+01,
		4.690342317192206e+01,		4.696324934113677e+01,		4.702299324114224e+01,		4.708265508425713e+01,		4.714223508207971e+01
	},
	{
		7.520503901130693e-02,		2.255135775679422e-01,		3.754863830935875e-01,		5.251242986222440e-01,		6.744281523514528e-01,
		8.233987585934076e-01,		9.720369186830842e-01,		1.120343421845015e+00,		1.268319046020283e+00,		1.415964558655255e+00,
		1.563280717453490e+00,		1.710268271092255e+00,		1.856927959904969e+00,		2.003260516530908e+00,		2.149266666533392e+00,
		2.294947128987694e+00,		2.440302617039821e+00,		2.585333838437294e+00,		2.730041496033008e+00,		2.874426288263234e+00,
		3.018488909600746e+00,		3.162230050984068e+00,		3.305650400223776e+00,		3.448750642386751e+00,		3.591531460159269e+00,
		3.733993534189771e+00,		3.876137543412117e+00,		4.017964165350131e+00,		4.159474076404161e+00,		4.300667952120443e+00,
		4.441546467443906e+00,		4.582110296955159e+00,		4.722360115092282e+00,		4.862296596358092e+00,		5.001920415513443e+00,
		5.141232247757208e+00,		5.280232768893486e+00,		5.418922655486589e+00,		5.557302585004336e+00,		5.695373235950175e+00,
		5.833135287984629e+00,		5.970589422036536e+00,		6.107736320404536e+00,		6.244576666849279e+00,		6.381111146676740e+00,
		6.517340446813089e+00,		6.653265255871484e+00,		6.788886264211201e+00,		6.924204163989442e+00,		7.059219649206189e+00,
		7.193933415742443e+00,		7.328346161392184e+00,		7.462458585888363e+00,		7.596271390923222e+00,		7.729785280163267e+00,
		7.863000959259122e+00,		7.995919135850623e+00,		8.128540519567290e+00,		8.260865822024567e+00,		8.392895756815943e+00,
		8.524631039501294e+00,		8.656072387591598e+00,		8.787220520530242e+00,		8.918076159671187e+00,		9.048640028254097e+00,
		9.178912851376731e+00,		9.308895355964619e+00,		9.438588270738432e+00,		9.567992326178929e+00,		9.697108254489905e+00,
		9.825936789559098e+00,		9.954478666917327e+00,		1.008273462369593e+01,		1.021070539858265e+01,		1.033839173177613e+01,
		1.046579436493911e+01,		1.059291404115042e+01,		1.071975150485597e+01,		1.084630750181869e+01,		1.097258277906774e+01,
		1.109857808484682e+01,		1.122429416856195e+01,		1.134973178072854e+01,		1.147489167291813e+01,		1.159977459770452e+01,
		1.172438130860973e+01,		1.184871256004960e+01,		1.197276910727922e+01,		1.209655170633823e+01,		1.222006111399605e+01,
		1.234329808769708e+01,		1.246626338550596e+01,		1.258895776605288e+01,		1.271138198847914e+01,		1.283353681238277e+01,
		1.295542299776444e+01,		1.307704130497370e+01,		1.319839249465538e+01,		1.331947732769655e+01,		1.344029656517366e+01,
		1.356085096830022e+01,		1.368114129837489e+01,		1.380116831673005e+01,		1.392093278468082e+01,		1.404043546347467e+01,
		1.415967711424157e+01,		1.427865849794463e+01,		1.439738037533143e+01,		1.451584350688583e+01,		1.463404865278056e+01,
		1.475199657283026e+01,		1.486968802644529e+01,		1.498712377258619e+01,		1.510430456971874e+01,		1.522123117576974e+01,
		1.533790434808352e+01,		1.545432484337903e+01,		1.557049341770778e+01,		1.568641082641230e+01,		1.580207782408556e+01,
		1.591749516453079e+01,		1.603266360072237e+01,		1.614758388476708e+01,		1.626225676786640e+01,		1.637668300027925e+01,
		1.649086333128568e+01,		1.660479850915112e+01,		1.671848928109144e+01,		1.683193639323867e+01,		1.694514059060750e+01,
		1.705810261706240e+01,		1.717082321528558e+01,		1.728330312674550e+01,		1.739554309166623e+01,		1.750754384899739e+01,
		1.761930613638484e+01,		1.773083069014208e+01,		1.784211824522226e+01,		1.795316953519090e+01,		1.806398529219936e+01,
		1.817456624695877e+01,		1.828491312871485e+01,		1.839502666522326e+01,		1.850490758272553e+01,		1.861455660592578e+01,
		1.872397445796798e+01,		1.883316186041382e+01,		1.894211953322120e+01,		1.905084819472340e+01,		1.915934856160872e+01,
		1.926762134890082e+01,		1.937566726993957e+01,		1.948348703636256e+01,		1.959108135808705e+01,		1.969845094329260e+01,
		1.980559649840412e+01,		1.991251872807565e+01,		2.001921833517444e+01,		2.012569602076577e+01,		2.023195248409811e+01,
		2.033798842258892e+01,		2.044380453181087e+01,		2.054940150547859e+01,		2.065478003543586e+01,		2.075994081164333e+01,
		2.086488452216665e+01,		2.096961185316514e+01,		2.107412348888079e+01,		2.117842011162780e+01,		2.128250240178252e+01,
		2.138637103777381e+01,		2.149002669607381e+01,		2.159347005118916e+01,		2.169670177565257e+01,		2.179972254001483e+01,
		2.190253301283717e+01,		2.200513386068398e+01,		2.210752574811602e+01,		2.220970933768378e+01,		2.231168528992148e+01,
		2.241345426334111e+01,		2.251501691442706e+01,		2.261637389763096e+01,		2.271752586536686e+01,		2.281847346800674e+01,
		2.291921735387638e+01,		2.301975816925150e+01,		2.312009655835408e+01,		2.322023316334926e+01,		2.332016862434223e+01,
		2.341990357937554e+01,		2.351943866442674e+01,		2.361877451340614e+01,		2.371791175815495e+01,		2.381685102844362e+01,
		2.391559295197044e+01,		2.401413815436039e+01,		2.411248725916424e+01,		2.421064088785784e+01,		2.430859965984170e+01,
		2.440636419244071e+01,		2.450393510090414e+01,		2.460131299840584e+01,		2.469849849604462e+01,		2.479549220284488e+01,
		2.489229472575733e+01,		2.498890666966002e+01,		2.508532863735953e+01,		2.518156122959223e+01,		2.527760504502588e+01,
		2.537346068026126e+01,		2.546912872983409e+01,		2.556460978621697e+01,		2.565990443982165e+01,		2.575501327900125e+01,
		2.584993689005286e+01,		2.594467585722002e+01,		2.603923076269562e+01,		2.613360218662468e+01,		2.622779070710750e+01,
		2.632179690020272e+01,		2.641562133993066e+01,		2.650926459827669e+01,		2.660272724519482e+01,		2.669600984861126e+01,
		2.678911297442821e+01,		2.688203718652775e+01,		2.697478304677574e+01,		2.706735111502589e+01,		2.715974194912402e+01,
		2.725195610491215e+01,		2.734399413623302e+01,		2.743585659493436e+01,		2.752754403087355e+01,		2.761905699192215e+01,
		2.771039602397062e+01,		2.780156167093307e+01,		2.789255447475206e+01,		2.798337497540359e+01,		2.807402371090201e+01,
		2.816450121730509e+01,		2.825480802871913e+01,		2.834494467730414e+01,		2.843491169327908e+01,		2.852470960492711e+01,
		2.861433893860100e+01,		2.870380021872845e+01,		2.879309396781765e+01,		2.888222070646265e+01,		2.897118095334900e+01,
		2.905997522525933e+01,		2.914860403707895e+01,		2.923706790180155e+01,		2.932536733053495e+01,		2.941350283250677e+01,
		2.950147491507028e+01,		2.958928408371023e+01,		2.967693084204869e+01,		2.976441569185093e+01,		2.985173913303133e+01,
		2.993890166365939e+01,		3.002590377996559e+01,		3.011274597634748e+01,		3.019942874537570e+01,		3.028595257779995e+01,
		3.037231796255507e+01,		3.045852538676722e+01,		3.054457533575987e+01,		3.063046829305992e+01,		3.071620474040391e+01,
		3.080178515774412e+01,		3.088721002325475e+01,		3.097247981333802e+01,		3.105759500263045e+01,		3.114255606400901e+01,
		3.122736346859735e+01,		3.131201768577195e+01,		3.139651918316840e+01,		3.148086842668759e+01,		3.156506588050196e+01,
		3.164911200706171e+01,		3.173300726710106e+01,		3.181675211964445e+01,		3.190034702201286e+01,		3.198379242982995e+01,
		3.206708879702838e+01,		3.215023657585601e+01,		3.223323621688215e+01,		3.231608816900378e+01,		3.239879287945185e+01,
		3.248135079379741e+01,		3.256376235595794e+01,		3.264602800820346e+01,		3.272814819116286e+01,		3.281012334383001e+01,
		3.289195390357008e+01,		3.297364030612559e+01,		3.305518298562273e+01,		3.313658237457745e+01,		3.321783890390168e+01,
		3.329895300290949e+01,		3.337992509932322e+01,		3.346075561927967e+01,		3.354144498733613e+01,		3.362199362647664e+01,
		3.370240195811798e+01,		3.378267040211583e+01,		3.386279937677085e+01,		3.394278929883474e+01,		3.402264058351628e+01,
		3.410235364448742e+01,		3.418192889388933e+01,		3.426136674233830e+01,		3.434066759893187e+01,		3.441983187125479e+01,
		3.449885996538496e+01,		3.457775228589937e+01,		3.465650923588017e+01,		3.473513121692044e+01,		3.481361862913020e+01,
		3.489197187114230e+01,		3.497019134011821e+01,		3.504827743175403e+01,		3.512623054028622e+01,		3.520405105849748e+01,
		3.528173937772256e+01,		3.535929588785399e+01,		3.543672097734797e+01,		3.551401503323006e+01,		3.559117844110089e+01,
		3.566821158514196e+01,		3.574511484812132e+01,		3.582188861139921e+01,		3.589853325493374e+01,		3.597504915728664e+01,
		3.605143669562874e+01,		3.612769624574567e+01,		3.620382818204344e+01,		3.627983287755401e+01,		3.635571070394083e+01,
		3.643146203150437e+01,		3.650708722918770e+01,		3.658258666458186e+01,		3.665796070393149e+01,		3.673320971214017e+01,
		3.680833405277587e+01,		3.688333408807643e+01,		3.695821017895494e+01,		3.703296268500502e+01,		3.710759196450635e+01,
		3.718209837442981e+01,		3.725648227044300e+01,		3.733074400691535e+01,		3.740488393692358e+01,		3.747890241225677e+01,
		3.755279978342176e+01,		3.762657639964827e+01,		3.770023260889413e+01,		3.777376875785047e+01,		3.784718519194682e+01,
		3.792048225535633e+01,		3.799366029100086e+01,		3.806671964055602e+01,		3.813966064445631e+01,		3.821248364190015e+01,
		3.828518897085495e+01,		3.835777696806209e+01,		3.843024796904187e+01,		3.850260230809865e+01,		3.857484031832562e+01,
		3.864696233160986e+01,		3.871896867863719e+01,		3.879085968889708e+01,		3.886263569068758e+01,		3.893429701112009e+01,
		3.900584397612428e+01,		3.907727691045286e+01,		3.914859613768630e+01,		3.921980198023786e+01,		3.929089475935803e+01,
		3.936187479513949e+01,		3.943274240652174e+01,		3.950349791129583e+01,		3.957414162610901e+01,		3.964467386646940e+01,
		3.971509494675065e+01,		3.978540518019651e+01,		3.985560487892558e+01,		3.992569435393560e+01,		3.999567391510836e+01,
		4.006554387121397e+01,		4.013530452991554e+01,		4.020495619777361e+01,		4.027449918025071e+01,		4.034393378171573e+01,
		4.041326030544843e+01,		4.048247905364387e+01,		4.055159032741683e+01,		4.062059442680611e+01,		4.068949165077903e+01,
		4.075828229723576e+01,		4.082696666301354e+01,		4.089554504389113e+01,		4.096401773459309e+01,		4.103238502879397e+01,
		4.110064721912267e+01,		4.116880459716667e+01,		4.123685745347618e+01,		4.130480607756844e+01,		4.137265075793189e+01,
		4.144039178203027e+01,		4.150802943630689e+01,		4.157556400618864e+01,		4.164299577609022e+01,		4.171032502941816e+01,
		4.177755204857496e+01,		4.184467711496315e+01,		4.191170050898926e+01,		4.197862251006794e+01,		4.204544339662592e+01,
		4.211216344610607e+01,		4.217878293497132e+01,		4.224530213870860e+01,		4.231172133183284e+01,		4.237804078789090e+01,
		4.244426077946541e+01,		4.251038157817874e+01,		4.257640345469683e+01,		4.264232667873307e+01,		4.270815151905214e+01,
		4.277387824347382e+01,		4.283950711887684e+01,		4.290503841120259e+01,		4.297047238545898e+01,		4.303580930572419e+01,
		4.310104943515034e+01,		4.316619303596736e+01,		4.323124036948652e+01,		4.329619169610429e+01,		4.336104727530586e+01,
		4.342580736566898e+01,		4.349047222486749e+01,		4.355504210967494e+01,		4.361951727596829e+01,		4.368389797873146e+01,
		4.374818447205888e+01,		4.381237700915917e+01,		4.387647584235855e+01,		4.394048122310451e+01,		4.400439340196921e+01,
		4.406821262865309e+01,		4.413193915198833e+01,		4.419557321994230e+01,		4.425911507962107e+01,		4.432256497727278e+01,
		4.438592315829117e+01,		4.444918986721890e+01,		4.451236534775104e+01,		4.457544984273841e+01,		4.463844359419097e+01,
		4.470134684328115e+01,		4.476415983034722e+01,		4.482688279489660e+01,		4.488951597560924e+01,		4.495205961034081e+01,
		4.501451393612608e+01,		4.507687918918214e+01,		4.513915560491168e+01,		4.520134341790622e+01,		4.526344286194939e+01,
		4.532545417002004e+01,		4.538737757429558e+01,		4.544921330615503e+01,		4.551096159618231e+01,		4.557262267416931e+01,
		4.563419676911911e+01,		4.569568410924908e+01,		4.575708492199394e+01,		4.581839943400901e+01,		4.587962787117319e+01,
		4.594077045859203e+01,		4.600182742060093e+01,		4.606279898076799e+01,		4.612368536189724e+01,		4.618448678603154e+01,
		4.624520347445564e+01,		4.630583564769925e+01,		4.636638352553984e+01,		4.642684732700584e+01,		4.648722727037946e+01,
		4.654752357319965e+01,		4.660773645226511e+01,		4.666786612363713e+01,		4.672791280264250e+01,		4.678787670387657e+01,
		4.684775804120589e+01,		4.690755702777130e+01,		4.696727387599059e+01,		4.702690879756157e+01,		4.708646200346477e+01
	},
	{
		7.506460809075777e-02,		2.250927854650445e-01,		3.747862717734971e-01,		5.241459087604691e-01,		6.731725234424112e-01,
		8.218669290485244e-01,		9.702299259189665e-01,		1.118262302362222e+00,		1.265964835473185e+00,		1.413338291913459e+00,
		1.560383428655283e+00,		1.707100993690502e+00,		1.853491726705888e+00,		1.999556359726110e+00,		2.145295617725585e+00,
		2.290710219210403e+00,		2.435800876771487e+00,		2.580568297610076e+00,		2.725013184036628e+00,		2.869136233944151e+00,
		3.012938141256969e+00,		3.156419596355893e+00,		3.299581286480698e+00,		3.442423896110824e+00,		3.584948107325163e+00,
		3.727154600141747e+00,		3.869044052838158e+00,		4.010617142253425e+00,		4.151874544072182e+00,		4.292816933091766e+00,
		4.433444983472990e+00,		4.573759368975256e+00,		4.713760763176647e+00,		4.853449839679640e+00,		4.992827272303034e+00,
		5.131893735260677e+00,		5.270649903327576e+00,		5.409096451993910e+00,		5.547234057607470e+00,		5.685063397505066e+00,
		5.822585150133335e+00,		5.959799995159492e+00,		6.096708613572397e+00,		6.233311687774442e+00,		6.369609901664650e+00,
		6.505603940713401e+00,		6.641294492029168e+00,		6.776682244417655e+00,		6.911767888433701e+00,		7.046552116426272e+00,
		7.181035622576934e+00,		7.315219102932068e+00,		7.449103255429204e+00,		7.582688779917715e+00,		7.715976378174216e+00,
		7.848966753912897e+00,		7.981660612791116e+00,		8.114058662410439e+00,		8.246161612313450e+00,		8.377970173976525e+00,
		8.509485060798770e+00,		8.640706988087452e+00,		8.771636673040007e+00,		8.902274834722910e+00,		9.032622194047581e+00,
		9.162679473743484e+00,		9.292447398328664e+00,		9.421926694077831e+00,		9.551118088988188e+00,		9.680022312743130e+00,
		9.808640096674045e+00,		9.936972173720243e+00,		1.006501927838725e+01,		1.019278214670357e+01,		1.032026151617598e+01,
		1.044745812574364e+01,		1.057437271573091e+01,		1.070100602779919e+01,		1.082735880489777e+01,		1.095343179121383e+01,
		1.107922573212165e+01,		1.120474137413121e+01,		1.132997946483618e+01,		1.145494075286136e+01,		1.157962598780980e+01,
		1.170403592020951e+01,		1.182817130145988e+01,		1.195203288377796e+01,		1.207562142014456e+01,		1.219893766425028e+01,
		1.232198237044148e+01,		1.244475629366634e+01,		1.256726018942099e+01,		1.268949481369575e+01,		1.281146092292154e+01,
		1.293315927391658e+01,		1.305459062383327e+01,		1.317575573010542e+01,		1.329665535039580e+01,		1.341729024254410e+01,
		1.353766116451522e+01,		1.365776887434807e+01,		1.377761413010476e+01,		1.389719768982034e+01,		1.401652031145304e+01,
		1.413558275283498e+01,		1.425438577162351e+01,		1.437293012525308e+01,		1.449121657088775e+01,		1.460924586537418e+01,
		1.472701876519546e+01,		1.484453602642529e+01,		1.496179840468309e+01,		1.507880665508957e+01,		1.519556153222303e+01,
		1.531206379007635e+01,		1.542831418201468e+01,		1.554431346073370e+01,		1.566006237821877e+01,		1.577556168570457e+01,
		1.589081213363563e+01,		1.600581447162743e+01,		1.612056944842824e+01,		1.623507781188178e+01,		1.634934030889038e+01,
		1.646335768537904e+01,		1.657713068626013e+01,		1.669066005539877e+01,		1.680394653557894e+01,		1.691699086847035e+01,
		1.702979379459593e+01,		1.714235605330001e+01,		1.725467838271732e+01,		1.736676151974257e+01,		1.747860620000073e+01,
		1.759021315781800e+01,		1.770158312619353e+01,		1.781271683677169e+01,		1.792361501981510e+01,		1.803427840417831e+01,
		1.814470771728204e+01,		1.825490368508822e+01,		1.836486703207556e+01,		1.847459848121580e+01,		1.858409875395057e+01,
		1.869336857016887e+01,		1.880240864818521e+01,		1.891121970471827e+01,		1.901980245487024e+01,		1.912815761210669e+01,
		1.923628588823710e+01,		1.934418799339584e+01,		1.945186463602386e+01,		1.955931652285083e+01,		1.966654435887791e+01,
		1.977354884736098e+01,		1.988033068979450e+01,		1.998689058589579e+01,		2.009322923358992e+01,		2.019934732899509e+01,
		2.030524556640849e+01,		2.041092463829261e+01,		2.051638523526216e+01,		2.062162804607135e+01,		2.072665375760170e+01,
		2.083146305485029e+01,		2.093605662091846e+01,		2.104043513700098e+01,		2.114459928237564e+01,		2.124854973439324e+01,
		2.135228716846810e+01,		2.145581225806879e+01,		2.155912567470953e+01,		2.166222808794172e+01,		2.176512016534613e+01,
		2.186780257252518e+01,		2.197027597309583e+01,		2.207254102868275e+01,		2.217459839891179e+01,		2.227644874140399e+01,
		2.237809271176964e+01,		2.247953096360303e+01,		2.258076414847718e+01,		2.268179291593921e+01,		2.278261791350577e+01,
		2.288323978665895e+01,		2.298365917884247e+01,		2.308387673145803e+01,		2.318389308386216e+01,		2.328370887336318e+01,
		2.338332473521856e+01,		2.348274130263243e+01,		2.358195920675352e+01,		2.368097907667318e+01,		2.377980153942377e+01,
		2.387842721997726e+01,		2.397685674124410e+01,		2.407509072407226e+01,		2.417312978724657e+01,		2.427097454748828e+01,
		2.436862561945476e+01,		2.446608361573950e+01,		2.456334914687230e+01,		2.466042282131965e+01,		2.475730524548529e+01,
		2.485399702371102e+01,		2.495049875827763e+01,		2.504681104940605e+01,		2.514293449525869e+01,		2.523886969194094e+01,
		2.533461723350284e+01,		2.543017771194089e+01,		2.552555171720005e+01,		2.562073983717595e+01,		2.571574265771710e+01,
		2.581056076262742e+01,		2.590519473366877e+01,		2.599964515056374e+01,		2.609391259099848e+01,		2.618799763062574e+01,
		2.628190084306796e+01,		2.637562279992052e+01,		2.646916407075519e+01,		2.656252522312356e+01,		2.665570682256062e+01,
		2.674870943258856e+01,		2.684153361472050e+01,		2.693417992846453e+01,		2.702664893132760e+01,		2.711894117881977e+01,
		2.721105722445838e+01,		2.730299761977233e+01,		2.739476291430652e+01,		2.748635365562632e+01,		2.757777038932215e+01,
		2.766901365901409e+01,		2.776008400635667e+01,		2.785098197104359e+01,		2.794170809081266e+01,		2.803226290145066e+01,
		2.812264693679846e+01,		2.821286072875597e+01,		2.830290480728733e+01,		2.839277970042614e+01,		2.848248593428062e+01,
		2.857202403303900e+01,		2.866139451897483e+01,		2.875059791245242e+01,		2.883963473193224e+01,		2.892850549397649e+01,
		2.901721071325466e+01,		2.910575090254905e+01,		2.919412657276045e+01,		2.928233823291383e+01,		2.937038639016403e+01,
		2.945827154980147e+01,		2.954599421525803e+01,		2.963355488811279e+01,		2.972095406809789e+01,		2.980819225310437e+01,
		2.989526993918819e+01,		2.998218762057601e+01,		3.006894578967125e+01,		3.015554493706004e+01,		3.024198555151716e+01,
		3.032826812001220e+01,		3.041439312771546e+01,		3.050036105800403e+01,		3.058617239246796e+01,		3.067182761091625e+01,
		3.075732719138302e+01,		3.084267161013357e+01,		3.092786134167056e+01,		3.101289685874013e+01,		3.109777863233806e+01,
		3.118250713171594e+01,		3.126708282438729e+01,		3.135150617613380e+01,		3.143577765101150e+01,		3.151989771135690e+01,
		3.160386681779324e+01,		3.168768542923665e+01,		3.177135400290235e+01,		3.185487299431089e+01,		3.193824285729429e+01,
		3.202146404400231e+01,		3.210453700490852e+01,		3.218746218881672e+01,		3.227024004286691e+01,		3.235287101254159e+01,
		3.243535554167198e+01,		3.251769407244416e+01,		3.259988704540524e+01,		3.268193489946957e+01,		3.276383807192490e+01,
		3.284559699843854e+01,		3.292721211306353e+01,		3.300868384824474e+01,		3.309001263482512e+01,		3.317119890205171e+01,
		3.325224307758184e+01,		3.333314558748923e+01,		3.341390685627008e+01,		3.349452730684914e+01,		3.357500736058591e+01,
		3.365534743728056e+01,		3.373554795518006e+01,		3.381560933098427e+01,		3.389553197985186e+01,		3.397531631540648e+01,
		3.405496274974266e+01,		3.413447169343181e+01,		3.421384355552829e+01,		3.429307874357526e+01,		3.437217766361076e+01,
		3.445114072017353e+01,		3.452996831630898e+01,		3.460866085357515e+01,		3.468721873204854e+01,		3.476564235032995e+01,
		3.484393210555049e+01,		3.492208839337725e+01,		3.500011160801923e+01,		3.507800214223315e+01,		3.515576038732920e+01,
		3.523338673317685e+01,		3.531088156821061e+01,		3.538824527943572e+01,		3.546547825243396e+01,		3.554258087136932e+01,
		3.561955351899365e+01,		3.569639657665238e+01,		3.577311042429015e+01,		3.584969544045648e+01,		3.592615200231133e+01,
		3.600248048563075e+01,		3.607868126481239e+01,		3.615475471288114e+01,		3.623070120149461e+01,		3.630652110094869e+01,
		3.638221478018306e+01,		3.645778260678661e+01,		3.653322494700294e+01,		3.660854216573583e+01,		3.668373462655467e+01,
		3.675880269169978e+01,		3.683374672208789e+01,		3.690856707731749e+01,		3.698326411567411e+01,		3.705783819413572e+01,
		3.713228966837801e+01,		3.720661889277967e+01,		3.728082622042771e+01,		3.735491200312259e+01,		3.742887659138358e+01,
		3.750272033445389e+01,		3.757644358030588e+01,		3.765004667564621e+01,		3.772352996592105e+01,		3.779689379532105e+01,
		3.787013850678672e+01,		3.794326444201325e+01,		3.801627194145569e+01,		3.808916134433401e+01,		3.816193298863814e+01,
		3.823458721113290e+01,		3.830712434736307e+01,		3.837954473165831e+01,		3.845184869713812e+01,		3.852403657571678e+01,
		3.859610869810826e+01,		3.866806539383109e+01,		3.873990699121325e+01,		3.881163381739696e+01,		3.888324619834363e+01,
		3.895474445883856e+01,		3.902612892249574e+01,		3.909739991176270e+01,		3.916855774792515e+01,		3.923960275111182e+01,
		3.931053524029907e+01,		3.938135553331567e+01,		3.945206394684742e+01,		3.952266079644181e+01,		3.959314639651263e+01,
		3.966352106034470e+01,		3.973378510009830e+01,		3.980393882681386e+01,		3.987398255041641e+01,		3.994391657972030e+01,
		4.001374122243356e+01,		4.008345678516238e+01,		4.015306357341576e+01,		4.022256189160977e+01,		4.029195204307214e+01,
		4.036123433004668e+01,		4.043040905369750e+01,		4.049947651411365e+01,		4.056843701031333e+01,		4.063729084024826e+01,
		4.070603830080805e+01,		4.077467968782452e+01,		4.084321529607585e+01,		4.091164541929114e+01,		4.097997035015436e+01,
		4.104819038030873e+01,		4.111630580036100e+01,		4.118431689988557e+01,		4.125222396742863e+01,		4.132002729051248e+01,
		4.138772715563945e+01,		4.145532384829636e+01,		4.152281765295822e+01,		4.159020885309270e+01,		4.165749773116399e+01,
		4.172468456863692e+01,		4.179176964598100e+01,		4.185875324267448e+01,		4.192563563720829e+01,		4.199241710709006e+01,
		4.205909792884811e+01,		4.212567837803540e+01,		4.219215872923346e+01,		4.225853925605630e+01,		4.232482023115433e+01,
		4.239100192621829e+01,		4.245708461198300e+01,		4.252306855823134e+01,		4.258895403379806e+01,		4.265474130657352e+01,
		4.272043064350758e+01,		4.278602231061340e+01,		4.285151657297111e+01,		4.291691369473168e+01,		4.298221393912057e+01,
		4.304741756844154e+01,		4.311252484408026e+01,		4.317753602650805e+01,		4.324245137528557e+01,		4.330727114906647e+01,
		4.337199560560102e+01,		4.343662500173973e+01,		4.350115959343695e+01,		4.356559963575456e+01,		4.362994538286537e+01,
		4.369419708805690e+01,		4.375835500373474e+01,		4.382241938142620e+01,		4.388639047178383e+01,		4.395026852458882e+01,
		4.401405378875457e+01,		4.407774651233017e+01,		4.414134694250382e+01,		4.420485532560630e+01,		4.426827190711437e+01,
		4.433159693165419e+01,		4.439483064300472e+01,		4.445797328410119e+01,		4.452102509703826e+01,		4.458398632307360e+01,
		4.464685720263114e+01,		4.470963797530428e+01,		4.477232887985939e+01,		4.483493015423905e+01,		4.489744203556526e+01,
		4.495986476014274e+01,		4.502219856346224e+01,		4.508444368020373e+01,		4.514660034423962e+01,		4.520866878863798e+01,
		4.527064924566577e+01,		4.533254194679201e+01,		4.539434712269090e+01,		4.545606500324502e+01,		4.551769581754849e+01,
		4.557923979391008e+01,		4.564069715985632e+01,		4.570206814213458e+01,		4.576335296671623e+01,		4.582455185879965e+01,
		4.588566504281329e+01,		4.594669274241881e+01,		4.600763518051400e+01,		4.606849257923582e+01,		4.612926515996354e+01,
		4.618995314332156e+01,		4.625055674918250e+01,		4.631107619667016e+01,		4.637151170416246e+01,		4.643186348929434e+01,
		4.649213176896087e+01,		4.655231675931985e+01,		4.661241867579510e+01,		4.667243773307906e+01,		4.673237414513583e+01,
		4.679222812520393e+01,		4.685199988579931e+01,		4.691168963871800e+01,		4.697129759503915e+01,		4.703082396512767e+01
	},
	{
		7.492470079491753e-02,		2.246735620874019e-01,		3.740887700001272e-01,		5.231711649707281e-01,		6.719215728164452e-01,
		8.203408056644520e-01,		9.684296628402641e-01,		1.116188931715827e+00,		1.263619388518800e+00,		1.410721799104525e+00,
		1.557496919692075e+00,		1.703945497565772e+00,		1.850068271743470e+00,		1.995865973612874e+00,		2.141339327537130e+00,
		2.286489051430846e+00,		2.431315857307685e+00,		2.575820451800626e+00,		2.720003536655958e+00,		2.863865809202002e+00,
		3.007407962793567e+00,		3.150630687233073e+00,		3.293534669169273e+00,		3.436120592474427e+00,		3.578389138600815e+00,
		3.720340986917384e+00,		3.861976815027345e+00,		4.003297299067460e+00,		4.144303113989783e+00,		4.284994933826558e+00,
		4.425373431938961e+00,		4.565439281250353e+00,		4.705193154464686e+00,		4.844635724270695e+00,		4.983767663532436e+00,
		5.122589645466794e+00,		5.261102343808484e+00,		5.399306432963104e+00,		5.537202588148734e+00,		5.674791485526601e+00,
		5.812073802321301e+00,		5.949050216931004e+00,		6.085721409028137e+00,		6.222088059650938e+00,		6.358150851286339e+00,
		6.493910467944534e+00,		6.629367595225665e+00,		6.764522920378955e+00,		6.899377132354689e+00,		7.033930921849382e+00,
		7.168184981344415e+00,		7.302140005138547e+00,		7.435796689374550e+00,		7.569155732060287e+00,		7.702217833084517e+00,
		7.834983694227700e+00,		7.967454019168070e+00,		8.099629513483251e+00,		8.231510884647614e+00,		8.363098842025654e+00,
		8.494394096861598e+00,		8.625397362265463e+00,		8.756109353195788e+00,		8.886530786439186e+00,		9.016662380586991e+00,
		9.146504856009132e+00,		9.276058934825407e+00,		9.405325340874358e+00,		9.534304799679889e+00,		9.662998038415813e+00,
		9.791405785868395e+00,		9.919528772397175e+00,		1.004736772989406e+01,		1.017492339174090e+01,		1.030219649276569e+01,
		1.042918776919746e+01,		1.055589795861997e+01,		1.068232779992438e+01,		1.080847803326095e+01,		1.093434939998990e+01,
		1.105994264263144e+01,		1.118525850481523e+01,		1.131029773122916e+01,		1.143506106756769e+01,		1.155954926047974e+01,
		1.168376305751626e+01,		1.180770320707741e+01,		1.193137045835970e+01,		1.205476556130288e+01,		1.217788926653671e+01,
		1.230074232532777e+01,		1.242332548952628e+01,		1.254563951151298e+01,		1.266768514414612e+01,		1.278946314070864e+01,
		1.291097425485558e+01,		1.303221924056170e+01,		1.315319885206940e+01,		1.327391384383703e+01,		1.339436497048743e+01,
		1.351455298675704e+01,		1.363447864744524e+01,		1.375414270736430e+01,		1.387354592128970e+01,		1.399268904391100e+01,
		1.411157282978325e+01,		1.423019803327885e+01,		1.434856540854007e+01,		1.446667570943211e+01,		1.458452968949672e+01,
		1.470212810190653e+01,		1.481947169941985e+01,		1.493656123433624e+01,		1.505339745845268e+01,		1.516998112302035e+01,
		1.528631297870214e+01,		1.540239377553080e+01,		1.551822426286776e+01,		1.563380518936263e+01,		1.574913730291345e+01,
		1.586422135062752e+01,		1.597905807878302e+01,		1.609364823279133e+01,		1.620799255715994e+01,		1.632209179545618e+01,
		1.643594669027160e+01,		1.654955798318704e+01,		1.666292641473845e+01,		1.677605272438329e+01,		1.688893765046781e+01,
		1.700158193019483e+01,		1.711398629959236e+01,		1.722615149348278e+01,		1.733807824545284e+01,		1.744976728782422e+01,
		1.756121935162479e+01,		1.767243516656066e+01,		1.778341546098863e+01,		1.789416096188961e+01,		1.800467239484248e+01,
		1.811495048399865e+01,		1.822499595205728e+01,		1.833480952024113e+01,		1.844439190827306e+01,		1.855374383435305e+01,
		1.866286601513598e+01,		1.877175916570986e+01,		1.888042399957484e+01,		1.898886122862262e+01,		1.909707156311660e+01,
		1.920505571167249e+01,		1.931281438123958e+01,		1.942034827708249e+01,		1.952765810276357e+01,		1.963474456012575e+01,
		1.974160834927593e+01,		1.984825016856901e+01,		1.995467071459232e+01,		2.006087068215064e+01,		2.016685076425162e+01,
		2.027261165209184e+01,		2.037815403504328e+01,		2.048347860064025e+01,		2.058858603456682e+01,		2.069347702064475e+01,
		2.079815224082180e+01,		2.090261237516057e+01,		2.100685810182770e+01,		2.111089009708357e+01,		2.121470903527240e+01,
		2.131831558881274e+01,		2.142171042818842e+01,		2.152489422193986e+01,		2.162786763665581e+01,		2.173063133696542e+01,
		2.183318598553074e+01,		2.193553224303962e+01,		2.203767076819886e+01,		2.213960221772783e+01,		2.224132724635241e+01,
		2.234284650679916e+01,		2.244416064979010e+01,		2.254527032403749e+01,		2.264617617623914e+01,		2.274687885107399e+01,
		2.284737899119796e+01,		2.294767723724019e+01,		2.304777422779941e+01,		2.314767059944080e+01,		2.324736698669296e+01,
		2.334686402204531e+01,		2.344616233594559e+01,		2.354526255679778e+01,		2.364416531096018e+01,		2.374287122274376e+01,
		2.384138091441081e+01,		2.393969500617373e+01,		2.403781411619417e+01,		2.413573886058230e+01,		2.423346985339633e+01,
		2.433100770664230e+01,		2.442835303027403e+01,		2.452550643219327e+01,		2.462246851825007e+01,		2.471923989224339e+01,
		2.481582115592181e+01,		2.491221290898452e+01,		2.500841574908238e+01,		2.510443027181934e+01,		2.520025707075382e+01,
		2.529589673740038e+01,		2.539134986123159e+01,		2.548661702967989e+01,		2.558169882813984e+01,		2.567659583997033e+01,
		2.577130864649700e+01,		2.586583782701483e+01,		2.596018395879085e+01,		2.605434761706698e+01,		2.614832937506296e+01,
		2.624212980397953e+01,		2.633574947300157e+01,		2.642918894930152e+01,		2.652244879804277e+01,		2.661552958238329e+01,
		2.670843186347930e+01,		2.680115620048900e+01,		2.689370315057658e+01,		2.698607326891610e+01,		2.707826710869564e+01,
		2.717028522112147e+01,		2.726212815542232e+01,		2.735379645885374e+01,		2.744529067670258e+01,		2.753661135229146e+01,
		2.762775902698339e+01,		2.771873424018656e+01,		2.780953752935890e+01,		2.790016943001311e+01,		2.799063047572147e+01,
		2.808092119812075e+01,		2.817104212691737e+01,		2.826099378989239e+01,		2.835077671290669e+01,		2.844039141990621e+01,
		2.852983843292720e+01,		2.861911827210149e+01,		2.870823145566194e+01,		2.879717849994778e+01,		2.888595991941012e+01,
		2.897457622661747e+01,		2.906302793226124e+01,		2.915131554516138e+01,		2.923943957227199e+01,		2.932740051868700e+01,
		2.941519888764586e+01,		2.950283518053934e+01,		2.959030989691520e+01,		2.967762353448406e+01,		2.976477658912526e+01,
		2.985176955489263e+01,		2.993860292402049e+01,		3.002527718692944e+01,		3.011179283223241e+01,		3.019815034674056e+01,
		3.028435021546923e+01,		3.037039292164402e+01,		3.045627894670672e+01,		3.054200877032143e+01,		3.062758287038051e+01,
		3.071300172301073e+01,		3.079826580257931e+01,		3.088337558170002e+01,		3.096833153123923e+01,		3.105313412032210e+01,
		3.113778381633870e+01,		3.122228108495003e+01,		3.130662639009427e+01,		3.139082019399285e+01,		3.147486295715669e+01,
		3.155875513839221e+01,		3.164249719480761e+01,		3.172608958181896e+01,		3.180953275315638e+01,		3.189282716087020e+01,
		3.197597325533716e+01,		3.205897148526643e+01,		3.214182229770599e+01,		3.222452613804857e+01,		3.230708345003799e+01,
		3.238949467577511e+01,		3.247176025572419e+01,		3.255388062871891e+01,		3.263585623196848e+01,		3.271768750106389e+01,
		3.279937486998391e+01,		3.288091877110129e+01,		3.296231963518888e+01,		3.304357789142565e+01,		3.312469396740288e+01,
		3.320566828913016e+01,		3.328650128104152e+01,		3.336719336600152e+01,		3.344774496531125e+01,		3.352815649871437e+01,
		3.360842838440324e+01,		3.368856103902481e+01,		3.376855487768671e+01,		3.384841031396326e+01,		3.392812775990141e+01,
		3.400770762602675e+01,		3.408715032134945e+01,		3.416645625337018e+01,		3.424562582808611e+01,		3.432465944999678e+01,
		3.440355752211001e+01,		3.448232044594777e+01,		3.456094862155210e+01,		3.463944244749091e+01,		3.471780232086390e+01,
		3.479602863730830e+01,		3.487412179100473e+01,		3.495208217468299e+01,		3.502991017962778e+01,		3.510760619568457e+01,
		3.518517061126530e+01,		3.526260381335397e+01,		3.533990618751258e+01,		3.541707811788666e+01,		3.549411998721100e+01,
		3.557103217681531e+01,		3.564781506662980e+01,		3.572446903519087e+01,		3.580099445964674e+01,		3.587739171576286e+01,
		3.595366117792769e+01,		3.602980321915813e+01,		3.610581821110502e+01,		3.618170652405874e+01,		3.625746852695463e+01,
		3.633310458737851e+01,		3.640861507157207e+01,		3.648400034443834e+01,		3.655926076954716e+01,		3.663439670914043e+01,
		3.670940852413761e+01,		3.678429657414103e+01,		3.685906121744124e+01,		3.693370281102231e+01,		3.700822171056706e+01,
		3.708261827046255e+01,		3.715689284380507e+01,		3.723104578240556e+01,		3.730507743679473e+01,		3.737898815622832e+01,
		3.745277828869229e+01,		3.752644818090784e+01,		3.759999817833678e+01,		3.767342862518643e+01,		3.774673986441484e+01,
		3.781993223773581e+01,		3.789300608562402e+01,		3.796596174732000e+01,		3.803879956083516e+01,		3.811151986295683e+01,
		3.818412298925322e+01,		3.825660927407834e+01,		3.832897905057697e+01,		3.840123265068966e+01,		3.847337040515745e+01,
		3.854539264352690e+01,		3.861729969415496e+01,		3.868909188421367e+01,		3.876076953969511e+01,		3.883233298541617e+01,
		3.890378254502329e+01,		3.897511854099728e+01,		3.904634129465804e+01,		3.911745112616927e+01,		3.918844835454321e+01,
		3.925933329764526e+01,		3.933010627219873e+01,		3.940076759378943e+01,		3.947131757687028e+01,		3.954175653476600e+01,
		3.961208477967759e+01,		3.968230262268700e+01,		3.975241037376161e+01,		3.982240834175877e+01,		3.989229683443037e+01,
		3.996207615842726e+01,		4.003174661930372e+01,		4.010130852152202e+01,		4.017076216845675e+01,		4.024010786239926e+01,
		4.030934590456206e+01,		4.037847659508326e+01,		4.044750023303080e+01,		4.051641711640699e+01,		4.058522754215258e+01,
		4.065393180615131e+01,		4.072253020323405e+01,		4.079102302718311e+01,		4.085941057073649e+01,		4.092769312559215e+01,
		4.099587098241211e+01,		4.106394443082681e+01,		4.113191375943916e+01,		4.119977925582876e+01,		4.126754120655602e+01,
		4.133519989716630e+01,		4.140275561219398e+01,		4.147020863516661e+01,		4.153755924860898e+01,		4.160480773404707e+01,
		4.167195437201225e+01,		4.173899944204516e+01,		4.180594322269974e+01,		4.187278599154730e+01,		4.193952802518041e+01,
		4.200616959921685e+01,		4.207271098830361e+01,		4.213915246612068e+01,		4.220549430538512e+01,		4.227173677785476e+01,
		4.233788015433227e+01,		4.240392470466877e+01,		4.246987069776790e+01,		4.253571840158946e+01,		4.260146808315330e+01,
		4.266712000854309e+01,		4.273267444291005e+01,		4.279813165047677e+01,		4.286349189454082e+01,		4.292875543747864e+01,
		4.299392254074909e+01,		4.305899346489726e+01,		4.312396846955799e+01,		4.318884781345967e+01,		4.325363175442780e+01,
		4.331832054938866e+01,		4.338291445437283e+01,		4.344741372451890e+01,		4.351181861407696e+01,		4.357612937641217e+01,
		4.364034626400834e+01,		4.370446952847141e+01,		4.376849942053304e+01,		4.383243619005405e+01,		4.389628008602785e+01,
		4.396003135658407e+01,		4.402369024899183e+01,		4.408725700966335e+01,		4.415073188415720e+01,		4.421411511718188e+01,
		4.427740695259904e+01,		4.434060763342707e+01,		4.440371740184422e+01,		4.446673649919217e+01,		4.452966516597920e+01,
		4.459250364188364e+01,		4.465525216575711e+01,		4.471791097562775e+01,		4.478048030870368e+01,		4.484296040137605e+01,
		4.490535148922249e+01,		4.496765380701016e+01,		4.502986758869912e+01,		4.509199306744543e+01,		4.515403047560447e+01,
		4.521598004473397e+01,		4.527784200559727e+01,		4.533961658816645e+01,		4.540130402162548e+01,		4.546290453437334e+01,
		4.552441835402713e+01,		4.558584570742516e+01,		4.564718682063000e+01,		4.570844191893170e+01,		4.576961122685065e+01,
		4.583069496814076e+01,		4.589169336579245e+01,		4.595260664203567e+01,		4.601343501834288e+01,		4.607417871543210e+01,
		4.613483795326987e+01,		4.619541295107418e+01,		4.625590392731750e+01,		4.631631109972962e+01,		4.637663468530067e+01,
		4.643687490028398e+01,		4.649703196019905e+01,		4.655710607983434e+01,		4.661709747325025e+01,		4.667700635378195e+01,
		4.673683293404219e+01,		4.679657742592426e+01,		4.685624004060462e+01,		4.691582098854595e+01,		4.697532047949980e+01
	},
	{
		7.478531419967070e-02,		2.242558986708509e-01,		3.733938631883171e-01,		5.222000468663126e-01,		6.706752743051586e-01,
		8.188203565113870e-01,		9.666360917764809e-01,		1.114123266515793e+00,		1.261282656069144e+00,		1.408115025464569e+00,
		1.554621130146579e+00,		1.700801716670324e+00,		1.846657523362917e+00,		1.992189280953202e+00,		2.137397713171136e+00,
		2.282283537317986e+00,		2.426847464808427e+00,		2.571090201685639e+00,		2.715012449110443e+00,		2.858614903825475e+00,
		3.001898258595374e+00,		3.144863202623922e+00,		3.287510421949021e+00,		3.429840599816400e+00,		3.571854417032890e+00,
		3.713552552300063e+00,		3.854935682529031e+00,		3.996004483137155e+00,		4.136759628327408e+00,		4.277201791351079e+00,
		4.417331644754504e+00,		4.557149860610481e+00,		4.696657110735009e+00,		4.835854066889953e+00,		4.974741400972234e+00,
		5.113319785190089e+00,		5.251589892227005e+00,		5.389552395393795e+00,		5.527207968769368e+00,		5.664557287330670e+00,
		5.801601027072276e+00,		5.938339865116106e+00,		6.074774479811684e+00,		6.210905550827385e+00,		6.346733759233055e+00,
		6.482259787574476e+00,		6.617484319939940e+00,		6.752408042019412e+00,		6.887031641156587e+00,		7.021355806394156e+00,
		7.155381228512691e+00,		7.289108600063392e+00,		7.422538615395017e+00,		7.555671970675346e+00,		7.688509363907375e+00,
		7.821051494940592e+00,		7.953299065477514e+00,		8.085252779075855e+00,		8.216913341146427e+00,		8.348281458947140e+00,
		8.479357841573204e+00,		8.610143199943861e+00,		8.740638246785789e+00,		8.870843696613337e+00,		9.000760265705930e+00,
		9.130388672082637e+00,		9.259729635474230e+00,		9.388783877292830e+00,		9.517552120599287e+00,		9.646035090068516e+00,
		9.774233511952890e+00,		9.902148114043808e+00,		1.002977962563166e+01,		1.015712877746422e+01,		1.028419630170363e+01,
		1.041098293188217e+01,		1.053748940285675e+01,		1.066371645076247e+01,		1.078966481296510e+01,		1.091533522801276e+01,
		1.104072843558684e+01,		1.116584517645224e+01,		1.129068619240699e+01,		1.141525222623142e+01,		1.153954402163684e+01,
		1.166356232321391e+01,		1.178730787638068e+01,		1.191078142733049e+01,		1.203398372297958e+01,		1.215691551091478e+01,
		1.227957753934099e+01,		1.240197055702877e+01,		1.252409531326203e+01,		1.264595255778568e+01,		1.276754304075364e+01,
		1.288886751267691e+01,		1.300992672437192e+01,		1.313072142690914e+01,		1.325125237156214e+01,		1.337152030975674e+01,
		1.349152599302082e+01,		1.361127017293437e+01,		1.373075360107997e+01,		1.384997702899389e+01,		1.396894120811750e+01,
		1.408764688974926e+01,		1.420609482499730e+01,		1.432428576473245e+01,		1.444222045954188e+01,		1.455989965968333e+01,
		1.467732411503994e+01,		1.479449457507566e+01,		1.491141178879132e+01,		1.502807650468129e+01,		1.514448947069086e+01,
		1.526065143417416e+01,		1.537656314185281e+01,		1.549222533977529e+01,		1.560763877327683e+01,		1.572280418694015e+01,
		1.583772232455672e+01,		1.595239392908883e+01,		1.606681974263228e+01,		1.618100050637981e+01,		1.629493696058510e+01,
		1.640862984452765e+01,		1.652207989647817e+01,		1.663528785366477e+01,		1.674825445223977e+01,		1.686098042724728e+01,
		1.697346651259134e+01,		1.708571344100486e+01,		1.719772194401917e+01,		1.730949275193428e+01,		1.742102659378974e+01,
		1.753232419733628e+01,		1.764338628900797e+01,		1.775421359389521e+01,		1.786480683571814e+01,		1.797516673680096e+01,
		1.808529401804666e+01,		1.819518939891250e+01,		1.830485359738613e+01,		1.841428732996219e+01,		1.852349131161977e+01,
		1.863246625580019e+01,		1.874121287438559e+01,		1.884973187767804e+01,		1.895802397437919e+01,		1.906608987157061e+01,
		1.917393027469457e+01,		1.928154588753547e+01,		1.938893741220177e+01,		1.949610554910856e+01,		1.960305099696050e+01,
		1.970977445273552e+01,		1.981627661166878e+01,		1.992255816723738e+01,		2.002861981114545e+01,		2.013446223330976e+01,
		2.024008612184583e+01,		2.034549216305453e+01,		2.045068104140915e+01,		2.055565343954293e+01,		2.066041003823704e+01,
		2.076495151640907e+01,		2.086927855110187e+01,		2.097339181747293e+01,		2.107729198878408e+01,		2.118097973639171e+01,
		2.128445572973735e+01,		2.138772063633864e+01,		2.149077512178074e+01,		2.159361984970813e+01,		2.169625548181673e+01,
		2.179868267784650e+01,		2.190090209557427e+01,		2.200291439080712e+01,		2.210472021737586e+01,		2.220632022712911e+01,
		2.230771506992760e+01,		2.240890539363873e+01,		2.250989184413163e+01,		2.261067506527238e+01,		2.271125569891964e+01,
		2.281163438492055e+01,		2.291181176110691e+01,		2.301178846329169e+01,		2.311156512526583e+01,		2.321114237879521e+01,
		2.331052085361812e+01,		2.340970117744273e+01,		2.350868397594505e+01,		2.360746987276696e+01,		2.370605948951464e+01,
		2.380445344575714e+01,		2.390265235902527e+01,		2.400065684481060e+01,		2.409846751656487e+01,		2.419608498569941e+01,
		2.429350986158498e+01,		2.439074275155165e+01,		2.448778426088899e+01,		2.458463499284644e+01,		2.468129554863385e+01,
		2.477776652742221e+01,		2.487404852634462e+01,		2.497014214049736e+01,		2.506604796294123e+01,		2.516176658470296e+01,
		2.525729859477684e+01,		2.535264458012660e+01,		2.544780512568720e+01,		2.554278081436707e+01,		2.563757222705030e+01,
		2.573217994259907e+01,		2.582660453785616e+01,		2.592084658764765e+01,		2.601490666478571e+01,		2.610878534007161e+01,
		2.620248318229869e+01,		2.629600075825562e+01,		2.638933863272971e+01,		2.648249736851031e+01,		2.657547752639240e+01,
		2.666827966518015e+01,		2.676090434169081e+01,		2.685335211075843e+01,		2.694562352523787e+01,		2.703771913600895e+01,
		2.712963949198042e+01,		2.722138514009433e+01,		2.731295662533032e+01,		2.740435449071003e+01,		2.749557927730156e+01,
		2.758663152422406e+01,		2.767751176865243e+01,		2.776822054582196e+01,		2.785875838903319e+01,		2.794912582965669e+01,
		2.803932339713809e+01,		2.812935161900296e+01,		2.821921102086197e+01,		2.830890212641592e+01,		2.839842545746096e+01,
		2.848778153389378e+01,		2.857697087371692e+01,		2.866599399304409e+01,		2.875485140610548e+01,		2.884354362525330e+01,
		2.893207116096717e+01,		2.902043452185963e+01,		2.910863421468175e+01,		2.919667074432862e+01,		2.928454461384514e+01,
		2.937225632443147e+01,		2.945980637544893e+01,		2.954719526442561e+01,		2.963442348706217e+01,		2.972149153723765e+01,
		2.980839990701523e+01,		2.989514908664814e+01,		2.998173956458553e+01,		3.006817182747827e+01,		3.015444636018500e+01,
		3.024056364577798e+01,		3.032652416554908e+01,		3.041232839901569e+01,		3.049797682392685e+01,		3.058346991626911e+01,
		3.066880815027265e+01,		3.075399199841724e+01,		3.083902193143841e+01,		3.092389841833333e+01,		3.100862192636705e+01,
		3.109319292107847e+01,		3.117761186628649e+01,		3.126187922409608e+01,		3.134599545490435e+01,		3.142996101740673e+01,
		3.151377636860299e+01,		3.159744196380345e+01,		3.168095825663501e+01,		3.176432569904733e+01,		3.184754474131893e+01,
		3.193061583206329e+01,		3.201353941823501e+01,		3.209631594513592e+01,		3.217894585642114e+01,		3.226142959410530e+01,
		3.234376759856854e+01,		3.242596030856271e+01,		3.250800816121745e+01,		3.258991159204622e+01,		3.267167103495249e+01,
		3.275328692223577e+01,		3.283475968459773e+01,		3.291608975114822e+01,		3.299727754941139e+01,		3.307832350533168e+01,
		3.315922804327995e+01,		3.323999158605947e+01,		3.332061455491196e+01,		3.340109736952360e+01,		3.348144044803103e+01,
		3.356164420702740e+01,		3.364170906156829e+01,		3.372163542517771e+01,		3.380142370985408e+01,		3.388107432607620e+01,
		3.396058768280906e+01,		3.403996418750994e+01,		3.411920424613419e+01,		3.419830826314120e+01,		3.427727664150022e+01,
		3.435610978269629e+01,		3.443480808673603e+01,		3.451337195215356e+01,		3.459180177601623e+01,		3.467009795393050e+01,
		3.474826088004765e+01,		3.482629094706968e+01,		3.490418854625493e+01,		3.498195406742394e+01,		3.505958789896509e+01,
		3.513709042784036e+01,		3.521446203959097e+01,		3.529170311834316e+01,		3.536881404681371e+01,		3.544579520631569e+01,
		3.552264697676402e+01,		3.559936973668111e+01,		3.567596386320241e+01,		3.575242973208202e+01,		3.582876771769822e+01,
		3.590497819305899e+01,		3.598106152980755e+01,		3.605701809822785e+01,		3.613284826725000e+01,		3.620855240445581e+01,
		3.628413087608415e+01,		3.635958404703642e+01,		3.643491228088195e+01,		3.651011593986334e+01,		3.658519538490189e+01,
		3.666015097560282e+01,		3.673498307026075e+01,		3.680969202586493e+01,		3.688427819810450e+01,		3.695874194137376e+01,
		3.703308360877752e+01,		3.710730355213615e+01,		3.718140212199094e+01,		3.725537966760923e+01,		3.732923653698957e+01,
		3.740297307686684e+01,		3.747658963271749e+01,		3.755008654876451e+01,		3.762346416798263e+01,		3.769672283210328e+01,
		3.776986288161978e+01,		3.784288465579225e+01,		3.791578849265267e+01,		3.798857472900987e+01,		3.806124370045451e+01,
		3.813379574136398e+01,		3.820623118490742e+01,		3.827855036305053e+01,		3.835075360656057e+01,		3.842284124501111e+01,
		3.849481360678702e+01,		3.856667101908917e+01,		3.863841380793939e+01,		3.871004229818505e+01,		3.878155681350411e+01,
		3.885295767640963e+01,		3.892424520825469e+01,		3.899541972923692e+01,		3.906648155840342e+01,		3.913743101365523e+01,
		3.920826841175210e+01,		3.927899406831715e+01,		3.934960829784138e+01,		3.942011141368838e+01,		3.949050372809887e+01,
		3.956078555219521e+01,		3.963095719598607e+01,		3.970101896837084e+01,		3.977097117714413e+01,		3.984081412900040e+01,
		3.991054812953823e+01,		3.998017348326495e+01,		4.004969049360088e+01,		4.011909946288399e+01,		4.018840069237401e+01,
		4.025759448225703e+01,		4.032668113164975e+01,		4.039566093860384e+01,		4.046453420011021e+01,		4.053330121210341e+01,
		4.060196226946584e+01,		4.067051766603204e+01,		4.073896769459289e+01,		4.080731264689990e+01,		4.087555281366942e+01,
		4.094368848458670e+01,		4.101171994831030e+01,		4.107964749247603e+01,		4.114747140370117e+01,		4.121519196758862e+01,
		4.128280946873094e+01,		4.135032419071451e+01,		4.141773641612350e+01,		4.148504642654397e+01,		4.155225450256798e+01,
		4.161936092379744e+01,		4.168636596884824e+01,		4.175326991535417e+01,		4.182007303997089e+01,		4.188677561837991e+01,
		4.195337792529245e+01,		4.201988023445346e+01,		4.208628281864539e+01,		4.215258594969212e+01,		4.221878989846291e+01,
		4.228489493487606e+01,		4.235090132790290e+01,		4.241680934557152e+01,		4.248261925497061e+01,		4.254833132225318e+01,
		4.261394581264041e+01,		4.267946299042526e+01,		4.274488311897635e+01,		4.281020646074164e+01,		4.287543327725196e+01,
		4.294056382912495e+01,		4.300559837606856e+01,		4.307053717688472e+01,		4.313538048947300e+01,		4.320012857083425e+01,
		4.326478167707415e+01,		4.332934006340680e+01,		4.339380398415836e+01,		4.345817369277054e+01,		4.352244944180409e+01,
		4.358663148294251e+01,		4.365072006699534e+01,		4.371471544390181e+01,		4.377861786273426e+01,		4.384242757170158e+01,
		4.390614481815273e+01,		4.396976984858009e+01,		4.403330290862296e+01,		4.409674424307090e+01,		4.416009409586716e+01,
		4.422335271011201e+01,		4.428652032806619e+01,		4.434959719115418e+01,		4.441258353996748e+01,		4.447547961426808e+01,
		4.453828565299164e+01,		4.460100189425086e+01,		4.466362857533862e+01,		4.472616593273145e+01,		4.478861420209255e+01,
		4.485097361827518e+01,		4.491324441532585e+01,		4.497542682648746e+01,		4.503752108420252e+01,		4.509952742011638e+01,
		4.516144606508032e+01,		4.522327724915478e+01,		4.528502120161237e+01,		4.534667815094107e+01,		4.540824832484741e+01,
		4.546973195025944e+01,		4.553112925332983e+01,		4.559244045943903e+01,		4.565366579319824e+01,		4.571480547845245e+01,
		4.577585973828354e+01,		4.583682879501320e+01,		4.589771287020604e+01,		4.595851218467248e+01,		4.601922695847178e+01,
		4.607985741091498e+01,		4.614040376056793e+01,		4.620086622525408e+01,		4.626124502205751e+01,		4.632154036732587e+01,
		4.638175247667319e+01,		4.644188156498280e+01,		4.650192784641029e+01,		4.656189153438618e+01,		4.662177284161904e+01,
		4.668157198009806e+01,		4.674128916109608e+01,		4.680092459517226e+01,		4.686047849217497e+01,		4.691995106124459e+01
	},
	{
		7.464644540264082e-02,		2.238397865164543e-01,		3.727015368615686e-01,		5.212325342125538e-01,		6.694336019355067e-01,
		8.173055498981192e-01,		9.648491753388735e-01,		1.112065263696907e+00,		1.258954589404039e+00,		1.405517916640386e+00,
		1.551756000054948e+00,		1.697669585452498e+00,		1.843259410448042e+00,		1.988526205090093e+00,		2.133470692453952e+00,
		2.278093589206128e+00,		2.422395606141014e+00,		2.566377448690877e+00,		2.710039817410202e+00,		2.853383408435360e+00,
		2.996408913920585e+00,		3.139117022451160e+00,		3.281508419434718e+00,		3.423583787471499e+00,		3.565343806704425e+00,
		3.706789155149762e+00,		3.847920509009156e+00,		3.988738542963796e+00,		4.129243930451405e+00,		4.269437343926784e+00,
		4.409319455106547e+00,		4.548890935198717e+00,		4.688152455117808e+00,		4.827104685685982e+00,		4.965748297820892e+00,
		5.104083962710721e+00,		5.242112351977037e+00,		5.379834137825902e+00,		5.517249993187831e+00,		5.654360591846986e+00,
		5.791166608560173e+00,		5.927668719166041e+00,		6.063867600684933e+00,		6.199763931409794e+00,		6.335358390988590e+00,
		6.470651660498584e+00,		6.605644422512865e+00,		6.740337361159492e+00,		6.874731162173607e+00,		7.008826512942871e+00,
		7.142624102546494e+00,		7.276124621788255e+00,		7.409328763223747e+00,		7.542237221182146e+00,		7.674850691782860e+00,
		7.807169872947180e+00,		7.939195464405375e+00,		8.070928167699305e+00,		8.202368686180922e+00,		8.333517725006823e+00,
		8.464375991129105e+00,		8.594944193282686e+00,		8.725223041969409e+00,		8.855213249438973e+00,		8.984915529667006e+00,
		9.114330598330396e+00,		9.243459172780073e+00,		9.372301972011407e+00,		9.500859716632378e+00,		9.629133128829693e+00,
		9.757122932332932e+00,		9.884829852376965e+00,		1.001225461566269e+01,		1.013939795031622e+01,		1.026626058584677e+01,
		1.039284325310311e+01,		1.051914668422904e+01,		1.064517161261760e+01,		1.077091877286448e+01,		1.089638890072051e+01,
		1.102158273304337e+01,		1.114650100774866e+01,		1.127114446376032e+01,		1.139551384096064e+01,		1.151960988013970e+01,
		1.164343332294455e+01,		1.176698491182808e+01,		1.189026538999764e+01,		1.201327550136348e+01,		1.213601599048719e+01,
		1.225848760252990e+01,		1.238069108320076e+01,		1.250262717870516e+01,		1.262429663569333e+01,		1.274570020120892e+01,
		1.286683862263786e+01,		1.298771264765740e+01,		1.310832302418546e+01,		1.322867050033022e+01,		1.334875582434017e+01,
		1.346857974455440e+01,		1.358814300935339e+01,		1.370744636711011e+01,		1.382649056614173e+01,		1.394527635466171e+01,
		1.406380448073234e+01,		1.418207569221791e+01,		1.430009073673837e+01,		1.441785036162351e+01,		1.453535531386779e+01,
		1.465260634008566e+01,		1.476960418646757e+01,		1.488634959873651e+01,		1.500284332210526e+01,		1.511908610123418e+01,
		1.523507868018970e+01,		1.535082180240348e+01,		1.546631621063211e+01,		1.558156264691763e+01,		1.569656185254857e+01,
		1.581131456802179e+01,		1.592582153300489e+01,		1.604008348629931e+01,		1.615410116580422e+01,		1.626787530848091e+01,
		1.638140665031799e+01,		1.649469592629725e+01,		1.660774387036016e+01,		1.672055121537506e+01,		1.683311869310506e+01,
		1.694544703417656e+01,		1.705753696804848e+01,		1.716938922298215e+01,		1.728100452601187e+01,		1.739238360291609e+01,
		1.750352717818930e+01,		1.761443597501455e+01,		1.772511071523661e+01,		1.783555211933578e+01,		1.794576090640232e+01,
		1.805573779411155e+01,		1.816548349869949e+01,		1.827499873493928e+01,		1.838428421611801e+01,		1.849334065401428e+01,
		1.860216875887636e+01,		1.871076923940089e+01,		1.881914280271218e+01,		1.892729015434211e+01,		1.903521199821060e+01,
		1.914290903660657e+01,		1.925038197016961e+01,		1.935763149787202e+01,		1.946465831700148e+01,		1.957146312314430e+01,
		1.967804661016910e+01,		1.978440947021105e+01,		1.989055239365660e+01,		1.999647606912878e+01,		2.010218118347291e+01,
		2.020766842174281e+01,		2.031293846718754e+01,		2.041799200123859e+01,		2.052282970349747e+01,		2.062745225172383e+01,
		2.073186032182403e+01,		2.083605458784006e+01,		2.094003572193904e+01,		2.104380439440297e+01,		2.114736127361904e+01,
		2.125070702607025e+01,		2.135384231632654e+01,		2.145676780703617e+01,		2.155948415891762e+01,		2.166199203075180e+01,
		2.176429207937463e+01,		2.186638495967000e+01,		2.196827132456311e+01,		2.206995182501413e+01,		2.217142711001219e+01,
		2.227269782656976e+01,		2.237376461971728e+01,		2.247462813249820e+01,		2.257528900596430e+01,		2.267574787917126e+01,
		2.277600538917464e+01,		2.287606217102608e+01,		2.297591885776982e+01,		2.307557608043951e+01,		2.317503446805521e+01,
		2.327429464762085e+01,		2.337335724412173e+01,		2.347222288052249e+01,		2.357089217776515e+01,		2.366936575476750e+01,
		2.376764422842172e+01,		2.386572821359323e+01,		2.396361832311980e+01,		2.406131516781075e+01,		2.415881935644658e+01,
		2.425613149577865e+01,		2.435325219052913e+01,		2.445018204339118e+01,		2.454692165502923e+01,		2.464347162407963e+01,
		2.473983254715128e+01,		2.483600501882657e+01,		2.493198963166254e+01,		2.502778697619205e+01,		2.512339764092534e+01,
		2.521882221235147e+01,		2.531406127494031e+01,		2.540911541114423e+01,		2.550398520140040e+01,		2.559867122413281e+01,
		2.569317405575487e+01,		2.578749427067169e+01,		2.588163244128291e+01,		2.597558913798543e+01,		2.606936492917626e+01,
		2.616296038125567e+01,		2.625637605863028e+01,		2.634961252371636e+01,		2.644267033694324e+01,		2.653555005675682e+01,
		2.662825223962313e+01,		2.672077744003215e+01,		2.681312621050157e+01,		2.690529910158069e+01,		2.699729666185451e+01,
		2.708911943794783e+01,		2.718076797452937e+01,		2.727224281431617e+01,		2.736354449807789e+01,		2.745467356464128e+01,
		2.754563055089474e+01,		2.763641599179290e+01,		2.772703042036131e+01,		2.781747436770121e+01,		2.790774836299429e+01,
		2.799785293350770e+01,		2.808778860459888e+01,		2.817755589972064e+01,		2.826715534042617e+01,		2.835658744637430e+01,
		2.844585273533452e+01,		2.853495172319232e+01,		2.862388492395447e+01,		2.871265284975431e+01,		2.880125601085719e+01,
		2.888969491566584e+01,		2.897797007072588e+01,		2.906608198073132e+01,		2.915403114853011e+01,		2.924181807512971e+01,
		2.932944325970276e+01,		2.941690719959268e+01,		2.950421039031943e+01,		2.959135332558511e+01,		2.967833649727988e+01,
		2.976516039548758e+01,		2.985182550849163e+01,		2.993833232278083e+01,		3.002468132305520e+01,		3.011087299223189e+01,
		3.019690781145104e+01,		3.028278626008169e+01,		3.036850881572776e+01,		3.045407595423399e+01,		3.053948814969183e+01,
		3.062474587444554e+01,		3.070984959909810e+01,		3.079479979251725e+01,		3.087959692184149e+01,		3.096424145248614e+01,
		3.104873384814934e+01,		3.113307457081813e+01,		3.121726408077451e+01,		3.130130283660143e+01,		3.138519129518894e+01,
		3.146892991174024e+01,		3.155251913977769e+01,		3.163595943114900e+01,		3.171925123603319e+01,		3.180239500294681e+01,
		3.188539117874982e+01,		3.196824020865191e+01,		3.205094253621840e+01,		3.213349860337639e+01,		3.221590885042080e+01,
		3.229817371602053e+01,		3.238029363722441e+01,		3.246226904946736e+01,		3.254410038657637e+01,		3.262578808077666e+01,
		3.270733256269762e+01,		3.278873426137891e+01,		3.286999360427650e+01,		3.295111101726866e+01,		3.303208692466200e+01,
		3.311292174919753e+01,		3.319361591205653e+01,		3.327416983286670e+01,		3.335458392970805e+01,		3.343485861911885e+01,
		3.351499431610166e+01,		3.359499143412926e+01,		3.367485038515058e+01,		3.375457157959656e+01,		3.383415542638621e+01,
		3.391360233293238e+01,		3.399291270514768e+01,		3.407208694745042e+01,		3.415112546277038e+01,		3.423002865255470e+01,
		3.430879691677371e+01,		3.438743065392675e+01,		3.446593026104798e+01,		3.454429613371212e+01,		3.462252866604028e+01,
		3.470062825070569e+01,		3.477859527893948e+01,		3.485643014053628e+01,		3.493413322386014e+01,		3.501170491584999e+01,
		3.508914560202548e+01,		3.516645566649259e+01,		3.524363549194928e+01,		3.532068545969103e+01,		3.539760594961659e+01,
		3.547439734023347e+01,		3.555106000866354e+01,		3.562759433064858e+01,		3.570400068055582e+01,		3.578027943138346e+01,
		3.585643095476618e+01,		3.593245562098061e+01,		3.600835379895075e+01,		3.608412585625350e+01,		3.615977215912402e+01,
		3.623529307246120e+01,		3.631068895983294e+01,		3.638596018348164e+01,		3.646110710432948e+01,		3.653613008198380e+01,
		3.661102947474231e+01,		3.668580563959856e+01,		3.676045893224700e+01,		3.683498970708845e+01,		3.690939831723514e+01,
		3.698368511451610e+01,		3.705785044948222e+01,		3.713189467141147e+01,		3.720581812831412e+01,		3.727962116693781e+01,
		3.735330413277267e+01,		3.742686737005646e+01,		3.750031122177960e+01,		3.757363602969029e+01,		3.764684213429950e+01,
		3.771992987488600e+01,		3.779289958950142e+01,		3.786575161497510e+01,		3.793848628691924e+01,		3.801110393973363e+01,
		3.808360490661077e+01,		3.815598951954064e+01,		3.822825810931565e+01,		3.830041100553547e+01,		3.837244853661191e+01,
		3.844437102977371e+01,		3.851617881107136e+01,		3.858787220538193e+01,		3.865945153641375e+01,		3.873091712671120e+01,
		3.880226929765946e+01,		3.887350836948926e+01,		3.894463466128141e+01,		3.901564849097163e+01,		3.908655017535515e+01,
		3.915734003009131e+01,		3.922801836970822e+01,		3.929858550760733e+01,		3.936904175606802e+01,		3.943938742625210e+01,
		3.950962282820845e+01,		3.957974827087743e+01,		3.964976406209546e+01,		3.971967050859944e+01,		3.978946791603128e+01,
		3.985915658894226e+01,		3.992873683079752e+01,		3.999820894398044e+01,		4.006757322979703e+01,		4.013682998848027e+01,
		4.020597951919449e+01,		4.027502212003973e+01,		4.034395808805598e+01,		4.041278771922754e+01,		4.048151130848725e+01,
		4.055012914972077e+01,		4.061864153577086e+01,		4.068704875844146e+01,		4.075535110850207e+01,		4.082354887569186e+01,
		4.089164234872379e+01,		4.095963181528884e+01,		4.102751756206008e+01,		4.109529987469687e+01,		4.116297903784879e+01,
		4.123055533515994e+01,		4.129802904927283e+01,		4.136540046183249e+01,		4.143266985349049e+01,		4.149983750390896e+01,
		4.156690369176459e+01,		4.163386869475252e+01,		4.170073278959045e+01,		4.176749625202242e+01,		4.183415935682284e+01,
		4.190072237780040e+01,		4.196718558780186e+01,		4.203354925871606e+01,		4.209981366147762e+01,		4.216597906607096e+01,
		4.223204574153395e+01,		4.229801395596184e+01,		4.236388397651098e+01,		4.242965606940265e+01,		4.249533049992675e+01,
		4.256090753244560e+01,		4.262638743039764e+01,		4.269177045630113e+01,		4.275705687175789e+01,		4.282224693745687e+01,
		4.288734091317796e+01,		4.295233905779551e+01,		4.301724162928200e+01,		4.308204888471170e+01,		4.314676108026422e+01,
		4.321137847122806e+01,		4.327590131200423e+01,		4.334032985610984e+01,		4.340466435618150e+01,		4.346890506397899e+01,
		4.353305223038867e+01,		4.359710610542700e+01,		4.366106693824403e+01,		4.372493497712680e+01,		4.378871046950292e+01,
		4.385239366194382e+01,		4.391598480016828e+01,		4.397948412904583e+01,		4.404289189260007e+01,		4.410620833401214e+01,
		4.416943369562394e+01,		4.423256821894162e+01,		4.429561214463880e+01,		4.435856571255994e+01,		4.442142916172357e+01,
		4.448420273032571e+01,		4.454688665574297e+01,		4.460948117453594e+01,		4.467198652245238e+01,		4.473440293443039e+01,
		4.479673064460177e+01,		4.485896988629506e+01,		4.492112089203884e+01,		4.498318389356487e+01,		4.504515912181121e+01,
		4.510704680692539e+01,		4.516884717826758e+01,		4.523056046441368e+01,		4.529218689315839e+01,		4.535372669151833e+01,
		4.541518008573512e+01,		4.547654730127850e+01,		4.553782856284926e+01,		4.559902409438234e+01,		4.566013411904991e+01,
		4.572115885926427e+01,		4.578209853668097e+01,		4.584295337220169e+01,		4.590372358597727e+01,		4.596440939741069e+01,
		4.602501102515992e+01,		4.608552868714097e+01,		4.614596260053079e+01,		4.620631298177009e+01,		4.626658004656631e+01,
		4.632676400989656e+01,		4.638686508601037e+01,		4.644688348843261e+01,		4.650681942996638e+01,		4.656667312269573e+01,
		4.662644477798865e+01,		4.668613460649970e+01,		4.674574281817295e+01,		4.680526962224469e+01,		4.686471522724621e+01
	},
	{
		7.450809152298876e-02,		2.234252169898952e-01,		3.720117766510344e-01,		5.202686069254060e-01,		6.681965299279737e-01,
		8.157963543697994e-01,		9.630688764178115e-01,		1.110014880515735e+00,		1.256635140167650e+00,		1.402930418685583e+00,
		1.548901469902508e+00,		1.694549038852053e+00,		1.839873862416180e+00,		1.984876669942054e+00,		2.129558183829277e+00,
		2.273919120088618e+00,		2.417960188873321e+00,		2.561682094984058e+00,		2.705085538348518e+00,		2.848171214476644e+00,
		2.990939814892431e+00,		3.133392027543214e+00,		3.275528537187313e+00,		3.417350025760908e+00,		3.558857172724923e+00,
		3.700050655392757e+00,		3.840931149239579e+00,		3.981499328193974e+00,		4.121755864912579e+00,		4.261701431038502e+00,
		4.401336697444062e+00,		4.540662334458601e+00,		4.679679012081909e+00,		4.818387400183892e+00,		4.956788168691071e+00,
		5.094881987760427e+00,		5.232669527941157e+00,		5.370151460324861e+00,		5.507328456684641e+00,		5.644201189603602e+00,
		5.780770332593228e+00,		5.917036560202070e+00,		6.053000548115176e+00,		6.188662973244701e+00,		6.324024513812059e+00,
		6.459085849422059e+00,		6.593847661129352e+00,		6.728310631497567e+00,		6.862475444651484e+00,		6.996342786322586e+00,
		7.129913343888296e+00,		7.263187806405204e+00,		7.396166864636624e+00,		7.528851211074717e+00,		7.661241539957492e+00,
		7.793338547280921e+00,		7.925142930806491e+00,		8.056655390064313e+00,		8.187876626352187e+00,		8.318807342730715e+00,
		8.449448244014745e+00,		8.579800036761362e+00,		8.709863429254595e+00,		8.839639131487051e+00,		8.969127855138677e+00,
		9.098330313552815e+00,		9.227247221709689e+00,		9.355879296197578e+00,		9.484227255181722e+00,		9.612291818371201e+00,
		9.740073706983901e+00,		9.867573643709655e+00,		9.994792352671821e+00,		1.012173055938727e+01,		1.024838899072503e+01,
		1.037476837486360e+01,		1.050086944124718e+01,		1.062669292054075e+01,		1.075223954458423e+01,		1.087751004634582e+01,
		1.100250515987451e+01,		1.112722562025192e+01,		1.125167216354359e+01,		1.137584552674968e+01,		1.149974644775531e+01,
		1.162337566528050e+01,		1.174673391882974e+01,		1.186982194864148e+01,		1.199264049563734e+01,		1.211519030137116e+01,
		1.223747210797822e+01,		1.235948665812415e+01,		1.248123469495414e+01,		1.260271696204215e+01,		1.272393420334019e+01,
		1.284488716312796e+01,		1.296557658596250e+01,		1.308600321662829e+01,		1.320616780008753e+01,		1.332607108143078e+01,
		1.344571380582796e+01,		1.356509671847978e+01,		1.368422056456948e+01,		1.380308608921512e+01,		1.392169403742232e+01,
		1.404004515403740e+01,		1.415814018370111e+01,		1.427597987080293e+01,		1.439356495943573e+01,		1.451089619335121e+01,
		1.462797431591576e+01,		1.474480007006700e+01,		1.486137419827085e+01,		1.497769744247924e+01,		1.509377054408848e+01,
		1.520959424389820e+01,		1.532516928207093e+01,		1.544049639809239e+01,		1.555557633073236e+01,		1.567040981800622e+01,
		1.578499759713720e+01,		1.589934040451920e+01,		1.601343897568038e+01,		1.612729404524734e+01,		1.624090634691000e+01,
		1.635427661338716e+01,		1.646740557639266e+01,		1.658029396660234e+01,		1.669294251362157e+01,		1.680535194595340e+01,
		1.691752299096754e+01,		1.702945637486986e+01,		1.714115282267257e+01,		1.725261305816511e+01,		1.736383780388566e+01,
		1.747482778109327e+01,		1.758558370974069e+01,		1.769610630844781e+01,		1.780639629447568e+01,		1.791645438370126e+01,
		1.802628129059276e+01,		1.813587772818549e+01,		1.824524440805851e+01,		1.835438204031174e+01,		1.846329133354365e+01,
		1.857197299482976e+01,		1.868042772970138e+01,		1.878865624212522e+01,		1.889665923448350e+01,		1.900443740755451e+01,
		1.911199146049378e+01,		1.921932209081596e+01,		1.932642999437698e+01,		1.943331586535691e+01,		1.953998039624333e+01,
		1.964642427781517e+01,		1.975264819912711e+01,		1.985865284749441e+01,		1.996443890847837e+01,		2.007000706587212e+01,
		2.017535800168702e+01,		2.028049239613945e+01,		2.038541092763813e+01,		2.049011427277180e+01,		2.059460310629751e+01,
		2.069887810112915e+01,		2.080293992832664e+01,		2.090678925708530e+01,		2.101042675472586e+01,		2.111385308668480e+01,
		2.121706891650501e+01,		2.132007490582696e+01,		2.142287171438027e+01,		2.152545999997555e+01,		2.162784041849669e+01,
		2.173001362389357e+01,		2.183198026817500e+01,		2.193374100140214e+01,		2.203529647168211e+01,		2.213664732516223e+01,
		2.223779420602420e+01,		2.233873775647895e+01,		2.243947861676162e+01,		2.254001742512690e+01,		2.264035481784469e+01,
		2.274049142919606e+01,		2.284042789146951e+01,		2.294016483495742e+01,		2.303970288795298e+01,		2.313904267674719e+01,
		2.323818482562626e+01,		2.333712995686919e+01,		2.343587869074574e+01,		2.353443164551440e+01,		2.363278943742093e+01,
		2.373095268069684e+01,		2.382892198755834e+01,		2.392669796820535e+01,		2.402428123082081e+01,		2.412167238157022e+01,
		2.421887202460134e+01,		2.431588076204417e+01,		2.441269919401103e+01,		2.450932791859693e+01,		2.460576753188013e+01,
		2.470201862792281e+01,		2.479808179877197e+01,		2.489395763446056e+01,		2.498964672300866e+01,		2.508514965042498e+01,
		2.518046700070839e+01,		2.527559935584970e+01,		2.537054729583354e+01,		2.546531139864043e+01,		2.555989224024899e+01,
		2.565429039463830e+01,		2.574850643379034e+01,		2.584254092769265e+01,		2.593639444434113e+01,		2.603006754974282e+01,
		2.612356080791901e+01,		2.621687478090836e+01,		2.631001002877005e+01,		2.640296710958732e+01,		2.649574657947078e+01,
		2.658834899256211e+01,		2.668077490103768e+01,		2.677302485511236e+01,		2.686509940304344e+01,		2.695699909113459e+01,
		2.704872446373993e+01,		2.714027606326819e+01,		2.723165443018701e+01,		2.732286010302721e+01,		2.741389361838726e+01,
		2.750475551093776e+01,		2.759544631342600e+01,		2.768596655668062e+01,		2.777631676961633e+01,		2.786649747923866e+01,
		2.795650921064887e+01,		2.804635248704879e+01,		2.813602782974586e+01,		2.822553575815813e+01,		2.831487678981931e+01,
		2.840405144038404e+01,		2.849306022363295e+01,		2.858190365147795e+01,		2.867058223396761e+01,		2.875909647929235e+01,
		2.884744689378996e+01,		2.893563398195096e+01,		2.902365824642409e+01,		2.911152018802181e+01,		2.919922030572586e+01,
		2.928675909669285e+01,		2.937413705625984e+01,		2.946135467795003e+01,		2.954841245347842e+01,		2.963531087275750e+01,
		2.972205042390306e+01,		2.980863159323983e+01,		2.989505486530740e+01,		2.998132072286594e+01,		3.006742964690208e+01,
		3.015338211663476e+01,		3.023917860952105e+01,		3.032481960126215e+01,		3.041030556580919e+01,		3.049563697536922e+01,
		3.058081430041114e+01,		3.066583800967162e+01,		3.075070857016116e+01,		3.083542644716993e+01,		3.091999210427385e+01,
		3.100440600334061e+01,		3.108866860453558e+01,		3.117278036632792e+01,		3.125674174549656e+01,		3.134055319713619e+01,
		3.142421517466336e+01,		3.150772812982245e+01,		3.159109251269177e+01,		3.167430877168956e+01,		3.175737735358005e+01,
		3.184029870347944e+01,		3.192307326486206e+01,		3.200570147956629e+01,		3.208818378780072e+01,		3.217052062815004e+01,
		3.225271243758122e+01,		3.233475965144944e+01,		3.241666270350417e+01,		3.249842202589515e+01,		3.258003804917848e+01,
		3.266151120232254e+01,		3.274284191271404e+01,		3.282403060616406e+01,		3.290507770691391e+01,		3.298598363764129e+01,
		3.306674881946609e+01,		3.314737367195650e+01,		3.322785861313484e+01,		3.330820405948360e+01,		3.338841042595134e+01,
		3.346847812595858e+01,		3.354840757140379e+01,		3.362819917266922e+01,		3.370785333862681e+01,		3.378737047664411e+01,
		3.386675099259007e+01,		3.394599529084095e+01,		3.402510377428614e+01,		3.410407684433399e+01,		3.418291490091760e+01,
		3.426161834250065e+01,		3.434018756608315e+01,		3.441862296720723e+01,		3.449692493996293e+01,		3.457509387699382e+01,
		3.465313016950284e+01,		3.473103420725798e+01,		3.480880637859791e+01,		3.488644707043776e+01,		3.496395666827466e+01,
		3.504133555619347e+01,		3.511858411687239e+01,		3.519570273158850e+01,		3.527269178022349e+01,		3.534955164126908e+01,
		3.542628269183268e+01,		3.550288530764287e+01,		3.557935986305499e+01,		3.565570673105656e+01,		3.573192628327283e+01,
		3.580801888997222e+01,		3.588398492007180e+01,		3.595982474114264e+01,		3.603553871941534e+01,		3.611112721978532e+01,
		3.618659060581826e+01,		3.626192923975543e+01,		3.633714348251908e+01,		3.641223369371765e+01,		3.648720023165117e+01,
		3.656204345331651e+01,		3.663676371441264e+01,		3.671136136934589e+01,		3.678583677123512e+01,		3.686019027191703e+01,
		3.693442222195124e+01,		3.700853297062550e+01,		3.708252286596086e+01,		3.715639225471677e+01,		3.723014148239619e+01,
		3.730377089325071e+01,		3.737728083028553e+01,		3.745067163526468e+01,		3.752394364871588e+01,		3.759709720993565e+01,
		3.767013265699423e+01,		3.774305032674069e+01,		3.781585055480772e+01,		3.788853367561664e+01,		3.796110002238233e+01,
		3.803354992711812e+01,		3.810588372064064e+01,		3.817810173257466e+01,		3.825020429135805e+01,		3.832219172424637e+01,
		3.839406435731795e+01,		3.846582251547839e+01,		3.853746652246556e+01,		3.860899670085419e+01,		3.868041337206061e+01,
		3.875171685634754e+01,		3.882290747282865e+01,		3.889398553947331e+01,		3.896495137311121e+01,		3.903580528943701e+01,
		3.910654760301483e+01,		3.917717862728303e+01,		3.924769867455863e+01,		3.931810805604191e+01,		3.938840708182092e+01,
		3.945859606087605e+01,		3.952867530108442e+01,		3.959864510922444e+01,		3.966850579098023e+01,		3.973825765094611e+01,
		3.980790099263090e+01,		3.987743611846245e+01,		3.994686332979192e+01,		4.001618292689821e+01,		4.008539520899226e+01,
		4.015450047422139e+01,		4.022349901967362e+01,		4.029239114138198e+01,		4.036117713432868e+01,		4.042985729244946e+01,
		4.049843190863783e+01,		4.056690127474920e+01,		4.063526568160515e+01,		4.070352541899759e+01,		4.077168077569294e+01,
		4.083973203943619e+01,		4.090767949695518e+01,		4.097552343396454e+01,		4.104326413516996e+01,		4.111090188427205e+01,
		4.117843696397063e+01,		4.124586965596858e+01,		4.131320024097593e+01,		4.138042899871390e+01,		4.144755620791886e+01,
		4.151458214634629e+01,		4.158150709077471e+01,		4.164833131700971e+01,		4.171505509988771e+01,		4.178167871328003e+01,
		4.184820243009671e+01,		4.191462652229028e+01,		4.198095126085980e+01,		4.204717691585456e+01,		4.211330375637790e+01,
		4.217933205059109e+01,		4.224526206571706e+01,		4.231109406804418e+01,		4.237682832293003e+01,		4.244246509480507e+01,
		4.250800464717647e+01,		4.257344724263173e+01,		4.263879314284238e+01,		4.270404260856770e+01,		4.276919589965829e+01,
		4.283425327505981e+01,		4.289921499281656e+01,		4.296408131007505e+01,		4.302885248308766e+01,		4.309352876721616e+01,
		4.315811041693536e+01,		4.322259768583650e+01,		4.328699082663099e+01,		4.335129009115371e+01,		4.341549573036671e+01,
		4.347960799436252e+01,		4.354362713236776e+01,		4.360755339274655e+01,		4.367138702300385e+01,		4.373512826978909e+01,
		4.379877737889942e+01,		4.386233459528308e+01,		4.392580016304298e+01,		4.398917432543986e+01,		4.405245732489577e+01,
		4.411564940299728e+01,		4.417875080049902e+01,		4.424176175732671e+01,		4.430468251258072e+01,		4.436751330453914e+01,
		4.443025437066118e+01,		4.449290594759034e+01,		4.455546827115777e+01,		4.461794157638530e+01,		4.468032609748883e+01,
		4.474262206788146e+01,		4.480482972017661e+01,		4.486694928619128e+01,		4.492898099694923e+01,		4.499092508268395e+01,
		4.505278177284197e+01,		4.511455129608592e+01,		4.517623388029756e+01,		4.523782975258098e+01,		4.529933913926556e+01,
		4.536076226590916e+01,		4.542209935730101e+01,		4.548335063746492e+01,		4.554451632966213e+01,		4.560559665639448e+01,
		4.566659183940724e+01,		4.572750209969224e+01,		4.578832765749078e+01,		4.584906873229656e+01,		4.590972554285863e+01,
		4.597029830718441e+01,		4.603078724254247e+01,		4.609119256546555e+01,		4.615151449175337e+01,		4.621175323647559e+01,
		4.627190901397464e+01,		4.633198203786853e+01,		4.639197252105380e+01,		4.645188067570827e+01,		4.651170671329385e+01,
		4.657145084455946e+01,		4.663111327954368e+01,		4.669069422757761e+01,		4.675019389728768e+01,		4.680961249659829e+01
	},
	{
		7.437024970121323e-02,		2.230121815208772e-01,		3.713245682945171e-01,		5.193082450700431e-01,		6.669640326947673e-01,
		8.142927387057312e-01,		9.612951581801670e-01,		1.107972074547607e+00,		1.254324260365075e+00,		1.400352478056762e+00,
		1.546057480619530e+00,		1.691440012295525e+00,		1.836500809213161e+00,		1.981240599997661e+00,		2.125660106352320e+00,
		2.269760043611607e+00,		2.413541121267173e+00,		2.557004043467819e+00,		2.700149509494403e+00,		2.842978214210679e+00,
		2.985490848490966e+00,		3.127688099625586e+00,		3.269570651704904e+00,		3.411139185982828e+00,		3.552394381220570e+00,
		3.693336914011456e+00,		3.833967459087519e+00,		3.974286689608638e+00,		4.114295277434870e+00,		4.253993893382731e+00,
		4.393383207465995e+00,		4.532463889121698e+00,		4.671236607421957e+00,		4.809702031272149e+00,		4.947860829596074e+00,
		5.085713671508597e+00,		5.223261226476355e+00,		5.360504164466986e+00,		5.497443156087401e+00,		5.634078872711576e+00,
		5.770411986598319e+00,		5.906443170999439e+00,		6.042173100258772e+00,		6.177602449902461e+00,		6.312731896720869e+00,
		6.447562118842558e+00,		6.582093795800647e+00,		6.716327608591930e+00,		6.850264239729123e+00,		6.983904373286514e+00,
		7.117248694939370e+00,		7.250297891997429e+00,		7.383052653432704e+00,		7.515513669901957e+00,		7.647681633764085e+00,
		7.779557239092640e+00,		7.911141181683832e+00,		8.042434159060178e+00,		8.173436870470047e+00,		8.304150016883366e+00,
		8.434574300983638e+00,		8.564710427156564e+00,		8.694559101475377e+00,		8.824121031683154e+00,		8.953396927172244e+00,
		9.082387498961042e+00,		9.211093459668183e+00,		9.339515523484446e+00,		9.467654406142405e+00,		9.595510824884087e+00,
		9.723085498426652e+00,		9.850379146926379e+00,		9.977392491940950e+00,		1.010412625639028e+01,		1.023058116451593e+01,
		1.035675794183923e+01,		1.048265731511825e+01,		1.060828001230376e+01,		1.073362676249414e+01,		1.085869829588952e+01,
		1.098349534374507e+01,		1.110801863832368e+01,		1.123226891284798e+01,		1.135624690145190e+01,		1.147995333913170e+01,
		1.160338896169672e+01,		1.172655450571982e+01,		1.184945070848744e+01,		1.197207830794972e+01,		1.209443804267028e+01,
		1.221653065177608e+01,		1.233835687490719e+01,		1.245991745216668e+01,		1.258121312407047e+01,		1.270224463149744e+01,
		1.282301271563970e+01,		1.294351811795293e+01,		1.306376158010718e+01,		1.318374384393778e+01,		1.330346565139669e+01,
		1.342292774450410e+01,		1.354213086530051e+01,		1.366107575579912e+01,		1.377976315793871e+01,		1.389819381353698e+01,
		1.401636846424431e+01,		1.413428785149804e+01,		1.425195271647735e+01,		1.436936380005853e+01,		1.448652184277086e+01,
		1.460342758475315e+01,		1.472008176571065e+01,		1.483648512487278e+01,		1.495263840095126e+01,		1.506854233209898e+01,
		1.518419765586946e+01,		1.529960510917688e+01,		1.541476542825681e+01,		1.552967934862759e+01,		1.564434760505225e+01,
		1.575877093150121e+01,		1.587295006111554e+01,		1.598688572617095e+01,		1.610057865804234e+01,		1.621402958716911e+01,
		1.632723924302103e+01,		1.644020835406492e+01,		1.655293764773177e+01,		1.666542785038477e+01,		1.677767968728776e+01,
		1.688969388257449e+01,		1.700147115921851e+01,		1.711301223900365e+01,		1.722431784249516e+01,		1.733538868901161e+01,
		1.744622549659721e+01,		1.755682898199500e+01,		1.766719986062045e+01,		1.777733884653592e+01,		1.788724665242549e+01,
		1.799692398957061e+01,		1.810637156782625e+01,		1.821559009559768e+01,		1.832458027981781e+01,		1.843334282592525e+01,
		1.854187843784277e+01,		1.865018781795647e+01,		1.875827166709546e+01,		1.886613068451216e+01,		1.897376556786308e+01,
		1.908117701319022e+01,		1.918836571490295e+01,		1.929533236576050e+01,		1.940207765685491e+01,		1.950860227759453e+01,
		1.961490691568804e+01,		1.972099225712896e+01,		1.982685898618067e+01,		1.993250778536194e+01,		2.003793933543285e+01,
		2.014315431538133e+01,		2.024815340241006e+01,		2.035293727192387e+01,		2.045750659751759e+01,		2.056186205096434e+01,
		2.066600430220425e+01,		2.076993401933365e+01,		2.087365186859464e+01,		2.097715851436504e+01,		2.108045461914893e+01,
		2.118354084356731e+01,		2.128641784634939e+01,		2.138908628432418e+01,		2.149154681241237e+01,		2.159380008361880e+01,
		2.169584674902506e+01,		2.179768745778262e+01,		2.189932285710620e+01,		2.200075359226751e+01,		2.210198030658946e+01,
		2.220300364144039e+01,		2.230382423622899e+01,		2.240444272839930e+01,		2.250485975342607e+01,		2.260507594481046e+01,
		2.270509193407594e+01,		2.280490835076475e+01,		2.290452582243423e+01,		2.300394497465376e+01,		2.310316643100190e+01,
		2.320219081306364e+01,		2.330101874042814e+01,		2.339965083068655e+01,		2.349808769943020e+01,		2.359632996024892e+01,
		2.369437822472968e+01,		2.379223310245541e+01,		2.388989520100418e+01,		2.398736512594833e+01,		2.408464348085412e+01,
		2.418173086728140e+01,		2.427862788478354e+01,		2.437533513090752e+01,		2.447185320119437e+01,		2.456818268917958e+01,
		2.466432418639383e+01,		2.476027828236389e+01,		2.485604556461371e+01,		2.495162661866561e+01,		2.504702202804166e+01,
		2.514223237426535e+01,		2.523725823686323e+01,		2.533210019336679e+01,		2.542675881931457e+01,		2.552123468825426e+01,
		2.561552837174505e+01,		2.570964043936015e+01,		2.580357145868928e+01,		2.589732199534147e+01,		2.599089261294796e+01,
		2.608428387316507e+01,		2.617749633567740e+01,		2.627053055820100e+01,		2.636338709648673e+01,		2.645606650432369e+01,
		2.654856933354277e+01,		2.664089613402036e+01,		2.673304745368202e+01,		2.682502383850637e+01,		2.691682583252909e+01,
		2.700845397784690e+01,		2.709990881462172e+01,		2.719119088108489e+01,		2.728230071354142e+01,		2.737323884637448e+01,
		2.746400581204972e+01,		2.755460214111993e+01,		2.764502836222957e+01,		2.773528500211949e+01,		2.782537258563164e+01,
		2.791529163571391e+01,		2.800504267342499e+01,		2.809462621793931e+01,		2.818404278655203e+01,		2.827329289468411e+01,
		2.836237705588739e+01,		2.845129578184975e+01,		2.854004958240034e+01,		2.862863896551479e+01,		2.871706443732058e+01,
		2.880532650210234e+01,		2.889342566230722e+01,		2.898136241855039e+01,		2.906913726962043e+01,		2.915675071248491e+01,
		2.924420324229587e+01,		2.933149535239544e+01,		2.941862753432141e+01,		2.950560027781290e+01,		2.959241407081603e+01,
		2.967906939948959e+01,		2.976556674821078e+01,		2.985190659958094e+01,		2.993808943443139e+01,		3.002411573182911e+01,
		3.010998596908262e+01,		3.019570062174783e+01,		3.028126016363387e+01,		3.036666506680894e+01,		3.045191580160623e+01,
		3.053701283662979e+01,		3.062195663876045e+01,		3.070674767316180e+01,		3.079138640328602e+01,		3.087587329087995e+01,
		3.096020879599093e+01,		3.104439337697286e+01,		3.112842749049214e+01,		3.121231159153364e+01,		3.129604613340668e+01,
		3.137963156775107e+01,		3.146306834454305e+01,		3.154635691210130e+01,		3.162949771709298e+01,		3.171249120453968e+01,
		3.179533781782343e+01,		3.187803799869277e+01,		3.196059218726864e+01,		3.204300082205049e+01,		3.212526433992219e+01,
		3.220738317615809e+01,		3.228935776442898e+01,		3.237118853680808e+01,		3.245287592377706e+01,		3.253442035423194e+01,
		3.261582225548916e+01,		3.269708205329147e+01,		3.277820017181392e+01,		3.285917703366984e+01,		3.294001305991672e+01,
		3.302070867006220e+01,		3.310126428206999e+01,		3.318168031236576e+01,		3.326195717584308e+01,		3.334209528586929e+01,
		3.342209505429142e+01,		3.350195689144204e+01,		3.358168120614514e+01,		3.366126840572198e+01,		3.374071889599694e+01,
		3.382003308130332e+01,		3.389921136448920e+01,		3.397825414692318e+01,		3.405716182850027e+01,		3.413593480764757e+01,
		3.421457348133006e+01,		3.429307824505641e+01,		3.437144949288458e+01,		3.444968761742771e+01,		3.452779300985965e+01,
		3.460576605992080e+01,		3.468360715592370e+01,		3.476131668475866e+01,		3.483889503189950e+01,		3.491634258140908e+01,
		3.499365971594495e+01,		3.507084681676497e+01,		3.514790426373284e+01,		3.522483243532366e+01,		3.530163170862951e+01,
		3.537830245936494e+01,		3.545484506187246e+01,		3.553125988912809e+01,		3.560754731274681e+01,		3.568370770298795e+01,
		3.575974142876075e+01,		3.583564885762960e+01,		3.591143035581968e+01,		3.598708628822213e+01,		3.606261701839947e+01,
		3.613802290859103e+01,		3.621330431971815e+01,		3.628846161138964e+01,		3.636349514190686e+01,		3.643840526826924e+01,
		3.651319234617930e+01,		3.658785673004804e+01,		3.666239877300010e+01,		3.673681882687889e+01,		3.681111724225194e+01,
		3.688529436841586e+01,		3.695935055340163e+01,		3.703328614397959e+01,		3.710710148566461e+01,		3.718079692272126e+01,
		3.725437279816865e+01,		3.732782945378565e+01,		3.740116723011589e+01,		3.747438646647269e+01,		3.754748750094407e+01,
		3.762047067039779e+01,		3.769333631048622e+01,		3.776608475565122e+01,		3.783871633912922e+01,		3.791123139295588e+01,
		3.798363024797115e+01,		3.805591323382401e+01,		3.812808067897738e+01,		3.820013291071282e+01,		3.827207025513538e+01,
		3.834389303717844e+01,		3.841560158060834e+01,		3.848719620802922e+01,		3.855867724088763e+01,		3.863004499947731e+01,
		3.870129980294382e+01,		3.877244196928925e+01,		3.884347181537677e+01,		3.891438965693528e+01,		3.898519580856416e+01,
		3.905589058373753e+01,		3.912647429480911e+01,		3.919694725301665e+01,		3.926730976848644e+01,		3.933756215023779e+01,
		3.940770470618765e+01,		3.947773774315488e+01,		3.954766156686484e+01,		3.961747648195383e+01,		3.968718279197341e+01,
		3.975678079939483e+01,		3.982627080561343e+01,		3.989565311095298e+01,		3.996492801467001e+01,		4.003409581495812e+01,
		4.010315680895235e+01,		4.017211129273335e+01,		4.024095956133172e+01,		4.030970190873227e+01,		4.037833862787818e+01,
		4.044687001067528e+01,		4.051529634799621e+01,		4.058361792968456e+01,		4.065183504455914e+01,		4.071994798041796e+01,
		4.078795702404248e+01,		4.085586246120169e+01,		4.092366457665612e+01,		4.099136365416202e+01,		4.105895997647532e+01,
		4.112645382535572e+01,		4.119384548157066e+01,		4.126113522489939e+01,		4.132832333413684e+01,		4.139541008709775e+01,
		4.146239576062045e+01,		4.152928063057085e+01,		4.159606497184643e+01,		4.166274905838002e+01,		4.172933316314376e+01,
		4.179581755815296e+01,		4.186220251446983e+01,		4.192848830220755e+01,		4.199467519053380e+01,		4.206076344767478e+01,
		4.212675334091889e+01,		4.219264513662048e+01,		4.225843910020366e+01,		4.232413549616604e+01,		4.238973458808231e+01,
		4.245523663860808e+01,		4.252064190948360e+01,		4.258595066153725e+01,		4.265116315468927e+01,		4.271627964795555e+01,
		4.278130039945100e+01,		4.284622566639332e+01,		4.291105570510652e+01,		4.297579077102453e+01,		4.304043111869478e+01,
		4.310497700178163e+01,		4.316942867307002e+01,		4.323378638446891e+01,		4.329805038701487e+01,		4.336222093087541e+01,
		4.342629826535257e+01,		4.349028263888633e+01,		4.355417429905805e+01,		4.361797349259390e+01,		4.368168046536823e+01,
		4.374529546240702e+01,		4.380881872789120e+01,		4.387225050516007e+01,		4.393559103671462e+01,		4.399884056422081e+01,
		4.406199932851302e+01,		4.412506756959721e+01,		4.418804552665435e+01,		4.425093343804353e+01,		4.431373154130538e+01,
		4.437644007316528e+01,		4.443905926953650e+01,		4.450158936552352e+01,		4.456403059542523e+01,		4.462638319273807e+01,
		4.468864739015925e+01,		4.475082341958989e+01,		4.481291151213818e+01,		4.487491189812255e+01,		4.493682480707474e+01,
		4.499865046774293e+01,		4.506038910809485e+01,		4.512204095532090e+01,		4.518360623583708e+01,		4.524508517528825e+01,
		4.530647799855098e+01,		4.536778492973672e+01,		4.542900619219477e+01,		4.549014200851524e+01,		4.555119260053213e+01,
		4.561215818932623e+01,		4.567303899522813e+01,		4.573383523782119e+01,		4.579454713594438e+01,		4.585517490769535e+01,
		4.591571877043327e+01,		4.597617894078167e+01,		4.603655563463152e+01,		4.609684906714388e+01,		4.615705945275290e+01,
		4.621718700516870e+01,		4.627723193738009e+01,		4.633719446165752e+01,		4.639707478955578e+01,		4.645687313191692e+01,
		4.651658969887301e+01,		4.657622469984882e+01,		4.663577834356476e+01,		4.669525083803946e+01,		4.675464239059271e+01
	},
	{
		7.423291709895360e-02,		2.226006716025317e-01,		3.706398976354812e-01,		5.183514288594736e-01,		6.657360848380354e-01,
		8.127946719171898e-01,		9.595279840667353e-01,		1.105936803683637e+00,		1.252021902358963e+00,		1.397784041609742e+00,
		1.543223973577057e+00,		1.688342441691659e+00,		1.833140181308336e+00,		1.977617920310196e+00,		2.121776379684037e+00,
		2.265616274067885e+00,		2.409138312271773e+00,		2.552343197772768e+00,		2.695231629185260e+00,		2.837804300707447e+00,
		2.980061902544935e+00,		3.122005121312355e+00,		3.263634640413840e+00,		3.404951140403199e+00,		3.545955299324570e+00,
		3.686647793034353e+00,		3.827029295505127e+00,		3.967100479112299e+00,		4.106862014904173e+00,		4.246314572856092e+00,
		4.385458822109324e+00,		4.524295431195290e+00,		4.662825068245755e+00,		4.801048401189564e+00,		4.938966097936456e+00,
		5.076578826548543e+00,		5.213887255399934e+00,		5.350892053325036e+00,		5.487593889756010e+00,		5.623993434849837e+00,
		5.760091359605484e+00,		5.895888335971571e+00,		6.031385036944969e+00,		6.166582136660759e+00,		6.301480310473904e+00,
		6.436080235033066e+00,		6.570382588346866e+00,		6.704388049843001e+00,		6.838097300420513e+00,		6.971511022495573e+00,
		7.104629900041050e+00,		7.237454618620220e+00,		7.369985865414856e+00,		7.502224329248017e+00,		7.634170700601802e+00,
		7.765825671630298e+00,		7.897189936168009e+00,		8.028264189734005e+00,		8.159049129531988e+00,		8.289545454446538e+00,
		8.419753865035714e+00,		8.549675063520299e+00,		8.679309753769727e+00,		8.808658641285088e+00,		8.937722433179200e+00,
		9.066501838154069e+00,		9.194997566475820e+00,		9.323210329947287e+00,		9.451140841878418e+00,		9.578789817054657e+00,
		9.706157971703412e+00,		9.833246023458743e+00,		9.960054691324505e+00,		1.008658469563586e+01,		1.021283675801951e+01,
		1.033881160135262e+01,		1.046450994972056e+01,		1.058993252837361e+01,		1.071508006368273e+01,		1.083995328309442e+01,
		1.096455291508484e+01,		1.108887968911323e+01,		1.121293433557475e+01,		1.133671758575277e+01,		1.146023017177071e+01,
		1.158347282654356e+01,		1.170644628372900e+01,		1.182915127767833e+01,		1.195158854338724e+01,		1.207375881644640e+01,
		1.219566283299197e+01,		1.231730132965620e+01,		1.243867504351792e+01,		1.255978471205320e+01,		1.268063107308611e+01,
		1.280121486473963e+01,		1.292153682538680e+01,		1.304159769360203e+01,		1.316139820811281e+01,		1.328093910775160e+01,
		1.340022113140816e+01,		1.351924501798220e+01,		1.363801150633638e+01,		1.375652133524986e+01,		1.387477524337218e+01,
		1.399277396917761e+01,		1.411051825092008e+01,		1.422800882658847e+01,		1.434524643386260e+01,		1.446223181006958e+01,
		1.457896569214084e+01,		1.469544881656964e+01,		1.481168191936924e+01,		1.492766573603162e+01,		1.504340100148672e+01,
		1.515888845006246e+01,		1.527412881544525e+01,		1.538912283064112e+01,		1.550387122793752e+01,		1.561837473886581e+01,
		1.573263409416425e+01,		1.584665002374176e+01,		1.596042325664221e+01,		1.607395452100953e+01,		1.618724454405323e+01,
		1.630029405201480e+01,		1.641310377013459e+01,		1.652567442261948e+01,		1.663800673261107e+01,		1.675010142215459e+01,
		1.686195921216848e+01,		1.697358082241448e+01,		1.708496697146860e+01,		1.719611837669243e+01,		1.730703575420535e+01,
		1.741771981885722e+01,		1.752817128420170e+01,		1.763839086247031e+01,		1.774837926454691e+01,		1.785813719994302e+01,
		1.796766537677358e+01,		1.807696450173331e+01,		1.818603528007381e+01,		1.829487841558112e+01,		1.840349461055389e+01,
		1.851188456578215e+01,		1.862004898052662e+01,		1.872798855249865e+01,		1.883570397784062e+01,		1.894319595110698e+01,
		1.905046516524574e+01,		1.915751231158062e+01,		1.926433807979361e+01,		1.937094315790812e+01,		1.947732823227264e+01,
		1.958349398754486e+01,		1.968944110667635e+01,		1.979517027089772e+01,		1.990068215970426e+01,		2.000597745084196e+01,
		2.011105682029424e+01,		2.021592094226889e+01,		2.032057048918558e+01,		2.042500613166388e+01,		2.052922853851157e+01,
		2.063323837671351e+01,		2.073703631142087e+01,		2.084062300594082e+01,		2.094399912172660e+01,		2.104716531836800e+01,
		2.115012225358223e+01,		2.125287058320524e+01,		2.135541096118331e+01,		2.145774403956513e+01,		2.155987046849416e+01,
		2.166179089620142e+01,		2.176350596899860e+01,		2.186501633127148e+01,		2.196632262547378e+01,		2.206742549212127e+01,
		2.216832556978625e+01,		2.226902349509228e+01,		2.236951990270937e+01,		2.246981542534931e+01,		2.256991069376137e+01,
		2.266980633672837e+01,		2.276950298106290e+01,		2.286900125160392e+01,		2.296830177121362e+01,		2.306740516077447e+01,
		2.316631203918672e+01,		2.326502302336595e+01,		2.336353872824096e+01,		2.346185976675198e+01,		2.355998674984897e+01,
		2.365792028649033e+01,		2.375566098364164e+01,		2.385320944627481e+01,		2.395056627736736e+01,		2.404773207790192e+01,
		2.414470744686594e+01,		2.424149298125161e+01,		2.433808927605602e+01,		2.443449692428142e+01,		2.453071651693573e+01,
		2.462674864303331e+01,		2.472259388959575e+01,		2.481825284165289e+01,		2.491372608224420e+01,		2.500901419241994e+01,
		2.510411775124289e+01,		2.519903733578997e+01,		2.529377352115412e+01,		2.538832688044634e+01,		2.548269798479777e+01,
		2.557688740336209e+01,		2.567089570331789e+01,		2.576472344987124e+01,		2.585837120625847e+01,		2.595183953374887e+01,
		2.604512899164780e+01,		2.613824013729961e+01,		2.623117352609099e+01,		2.632392971145410e+01,		2.641650924487014e+01,
		2.650891267587278e+01,		2.660114055205182e+01,		2.669319341905690e+01,		2.678507182060132e+01,		2.687677629846597e+01,
		2.696830739250335e+01,		2.705966564064161e+01,		2.715085157888879e+01,		2.724186574133709e+01,		2.733270866016714e+01,
		2.742338086565250e+01,		2.751388288616415e+01,		2.760421524817500e+01,		2.769437847626461e+01,		2.778437309312383e+01,
		2.787419961955963e+01,		2.796385857449991e+01,		2.805335047499835e+01,		2.814267583623948e+01,		2.823183517154358e+01,
		2.832082899237179e+01,		2.840965780833126e+01,		2.849832212718026e+01,		2.858682245483344e+01,		2.867515929536705e+01,
		2.876333315102429e+01,		2.885134452222064e+01,		2.893919390754927e+01,		2.902688180378642e+01,		2.911440870589690e+01,
		2.920177510703962e+01,		2.928898149857305e+01,		2.937602837006088e+01,		2.946291620927753e+01,		2.954964550221385e+01,
		2.963621673308273e+01,		2.972263038432478e+01,		2.980888693661411e+01,		2.989498686886395e+01,		2.998093065823249e+01,
		3.006671878012862e+01,		3.015235170821770e+01,		3.023782991442741e+01,		3.032315386895359e+01,		3.040832404026605e+01,
		3.049334089511441e+01,		3.057820489853407e+01,		3.066291651385196e+01,		3.074747620269256e+01,		3.083188442498374e+01,
		3.091614163896269e+01,		3.100024830118188e+01,		3.108420486651493e+01,		3.116801178816260e+01,		3.125166951765878e+01,
		3.133517850487627e+01,		3.141853919803297e+01,		3.150175204369769e+01,		3.158481748679607e+01,		3.166773597061672e+01,
		3.175050793681703e+01,		3.183313382542915e+01,		3.191561407486607e+01,		3.199794912192747e+01,		3.208013940180565e+01,
		3.216218534809163e+01,		3.224408739278100e+01,		3.232584596627986e+01,		3.240746149741086e+01,		3.248893441341902e+01,
		3.257026513997778e+01,		3.265145410119484e+01,		3.273250171961813e+01,		3.281340841624173e+01,		3.289417461051175e+01,
		3.297480072033225e+01,		3.305528716207110e+01,		3.313563435056591e+01,		3.321584269912987e+01,		3.329591261955762e+01,
		3.337584452213111e+01,		3.345563881562539e+01,		3.353529590731456e+01,		3.361481620297745e+01,		3.369420010690348e+01,
		3.377344802189852e+01,		3.385256034929054e+01,		3.393153748893551e+01,		3.401037983922307e+01,		3.408908779708229e+01,
		3.416766175798744e+01,		3.424610211596362e+01,		3.432440926359256e+01,		3.440258359201820e+01,		3.448062549095246e+01,
		3.455853534868086e+01,		3.463631355206806e+01,		3.471396048656366e+01,		3.479147653620769e+01,		3.486886208363624e+01,
		3.494611751008699e+01,		3.502324319540488e+01,		3.510023951804750e+01,		3.517710685509073e+01,		3.525384558223422e+01,
		3.533045607380689e+01,		3.540693870277234e+01,		3.548329384073440e+01,		3.555952185794253e+01,		3.563562312329724e+01,
		3.571159800435544e+01,		3.578744686733601e+01,		3.586317007712490e+01,		3.593876799728070e+01,		3.601424099003988e+01,
		3.608958941632213e+01,		3.616481363573562e+01,		3.623991400658233e+01,		3.631489088586325e+01,		3.638974462928368e+01,
		3.646447559125842e+01,		3.653908412491696e+01,		3.661357058210869e+01,		3.668793531340808e+01,		3.676217866811975e+01,
		3.683630099428368e+01,		3.691030263868032e+01,		3.698418394683560e+01,		3.705794526302605e+01,		3.713158693028388e+01,
		3.720510929040197e+01,		3.727851268393889e+01,		3.735179745022391e+01,		3.742496392736198e+01,		3.749801245223860e+01,
		3.757094336052488e+01,		3.764375698668245e+01,		3.771645366396822e+01,		3.778903372443941e+01,		3.786149749895833e+01,
		3.793384531719725e+01,		3.800607750764322e+01,		3.807819439760284e+01,		3.815019631320709e+01,		3.822208357941608e+01,
		3.829385652002375e+01,		3.836551545766267e+01,		3.843706071380873e+01,		3.850849260878572e+01,		3.857981146177018e+01,
		3.865101759079589e+01,		3.872211131275862e+01,		3.879309294342063e+01,		3.886396279741535e+01,		3.893472118825197e+01,
		3.900536842831986e+01,		3.907590482889325e+01,		3.914633070013567e+01,		3.921664635110450e+01,		3.928685208975539e+01,
		3.935694822294674e+01,		3.942693505644423e+01,		3.949681289492507e+01,		3.956658204198257e+01,		3.963624280013044e+01,
		3.970579547080718e+01,		3.977524035438044e+01,		3.984457775015132e+01,		3.991380795635872e+01,		3.998293127018363e+01,
		4.005194798775339e+01,		4.012085840414595e+01,		4.018966281339414e+01,		4.025836150848983e+01,		4.032695478138824e+01,
		4.039544292301200e+01,		4.046382622325543e+01,		4.053210497098861e+01,		4.060027945406160e+01,		4.066834995930847e+01,
		4.073631677255140e+01,		4.080418017860485e+01,		4.087194046127959e+01,		4.093959790338664e+01,		4.100715278674147e+01,
		4.107460539216788e+01,		4.114195599950204e+01,		4.120920488759649e+01,		4.127635233432407e+01,		4.134339861658185e+01,
		4.141034401029511e+01,		4.147718879042122e+01,		4.154393323095346e+01,		4.161057760492508e+01,		4.167712218441294e+01,
		4.174356724054152e+01,		4.180991304348662e+01,		4.187615986247931e+01,		4.194230796580958e+01,		4.200835762083020e+01,
		4.207430909396049e+01,		4.214016265068997e+01,		4.220591855558219e+01,		4.227157707227844e+01,		4.233713846350134e+01,
		4.240260299105860e+01,		4.246797091584673e+01,		4.253324249785456e+01,		4.259841799616694e+01,		4.266349766896843e+01,
		4.272848177354675e+01,		4.279337056629650e+01,		4.285816430272263e+01,		4.292286323744402e+01,		4.298746762419712e+01,
		4.305197771583929e+01,		4.311639376435247e+01,		4.318071602084656e+01,		4.324494473556300e+01,		4.330908015787813e+01,
		4.337312253630667e+01,		4.343707211850523e+01,		4.350092915127567e+01,		4.356469388056843e+01,		4.362836655148601e+01,
		4.369194740828636e+01,		4.375543669438616e+01,		4.381883465236421e+01,		4.388214152396478e+01,		4.394535755010087e+01,
		4.400848297085754e+01,		4.407151802549523e+01,		4.413446295245295e+01,		4.419731798935164e+01,		4.426008337299734e+01,
		4.432275933938441e+01,		4.438534612369885e+01,		4.444784396032137e+01,		4.451025308283071e+01,		4.457257372400662e+01,
		4.463480611583333e+01,		4.469695048950233e+01,		4.475900707541579e+01,		4.482097610318960e+01,		4.488285780165636e+01,
		4.494465239886866e+01,		4.500636012210204e+01,		4.506798119785805e+01,		4.512951585186742e+01,		4.519096430909291e+01,
		4.525232679373254e+01,		4.531360352922248e+01,		4.537479473824008e+01,		4.543590064270686e+01,		4.549692146379150e+01,
		4.555785742191279e+01,		4.561870873674255e+01,		4.567947562720865e+01,		4.574015831149782e+01,		4.580075700705867e+01,
		4.586127193060452e+01,		4.592170329811632e+01,		4.598205132484552e+01,		4.604231622531691e+01,		4.610249821333151e+01,
		4.616259750196937e+01,		4.622261430359241e+01,		4.628254882984722e+01,		4.634240129166793e+01,		4.640217189927888e+01,
		4.646186086219750e+01,		4.652146838923703e+01,		4.658099468850924e+01,		4.664043996742731e+01,		4.669980443270837e+01
	},
	{
		7.409609089879486e-02,		2.221906787908319e-01,		3.699577506220735e-01,		5.173981386531693e-01,		6.645126611481010e-01,
		8.113021232452656e-01,		9.577673177896814e-01,		1.103909026127777e+00,		1.249728018866176e+00,		1.395225056595824e+00,
		1.540400890582774e+00,		1.685256263426891e+00,		1.829791909689665e+00,		1.974008556492338e+00,		2.117906924085432e+00,
		2.261487726390803e+00,		2.404751671517237e+00,		2.547699462250614e+00,		2.690331796519617e+00,		2.832649367837917e+00,
		2.974652865723748e+00,		3.116342976097751e+00,		3.257720381659930e+00,		3.398785762246519e+00,		3.539539795167583e+00,
		3.679983155526086e+00,		3.820116516519169e+00,		3.959940549722342e+00,		4.099455925357282e+00,		4.238663312543899e+00,
		4.377563379537294e+00,		4.516156793950235e+00,		4.654444222961751e+00,		4.792426333512408e+00,		4.930103792486815e+00,
		5.067477266883919e+00,		5.204547423975577e+00,		5.341314931453931e+00,		5.477780457568028e+00,		5.613944671250204e+00,
		5.749808242232613e+00,		5.885371841154413e+00,		6.020636139659932e+00,		6.155601810488299e+00,		6.290269527554886e+00,
		6.424639966024932e+00,		6.558713802379734e+00,		6.692491714475728e+00,		6.825974381596808e+00,		6.959162484500202e+00,
		7.092056705456217e+00,		7.224657728282154e+00,		7.356966238370662e+00,		7.488982922712870e+00,		7.620708469916452e+00,
		7.752143570219024e+00,		7.883288915496986e+00,		8.014145199270148e+00,		8.144713116702318e+00,		8.274993364598078e+00,
		8.404986641395956e+00,		8.534693647158257e+00,		8.664115083557638e+00,		8.793251653860697e+00,		8.922104062908776e+00,
		9.050673017096027e+00,		9.178959224345101e+00,		9.306963394080395e+00,		9.434686237199214e+00,		9.562128466040857e+00,
		9.689290794353841e+00,		9.816173937261363e+00,		9.942778611225132e+00,		1.006910553400772e+01,		1.019515542463353e+01,
		1.032092900334845e+01,		1.044642699157845e+01,		1.057165011188700e+01,		1.069659908793163e+01,		1.082127464441955e+01,
		1.094567750706259e+01,		1.106980840253133e+01,		1.119366805840876e+01,		1.131725720314327e+01,		1.144057656600135e+01,
		1.156362687701973e+01,		1.168640886695738e+01,		1.180892326724709e+01,		1.193117080994703e+01,		1.205315222769203e+01,
		1.217486825364487e+01,		1.229631962144751e+01,		1.241750706517236e+01,		1.253843131927360e+01,		1.265909311853866e+01,
		1.277949319803978e+01,		1.289963229308580e+01,		1.301951113917423e+01,		1.313913047194352e+01,		1.325849102712564e+01,
		1.337759354049900e+01,		1.349643874784175e+01,		1.361502738488543e+01,		1.373336018726902e+01,		1.385143789049348e+01,
		1.396926122987669e+01,		1.408683094050889e+01,		1.420414775720862e+01,		1.432121241447912e+01,		1.443802564646534e+01,
		1.455458818691146e+01,		1.467090076911888e+01,		1.478696412590495e+01,		1.490277898956210e+01,		1.501834609181769e+01,
		1.513366616379440e+01,		1.524873993597120e+01,		1.536356813814498e+01,		1.547815149939282e+01,		1.559249074803482e+01,
		1.570658661159756e+01,		1.582043981677827e+01,		1.593405108940953e+01,		1.604742115442476e+01,		1.616055073582410e+01,
		1.627344055664122e+01,		1.638609133891055e+01,		1.649850380363526e+01,		1.661067867075586e+01,		1.672261665911943e+01,
		1.683431848644944e+01,		1.694578486931631e+01,		1.705701652310852e+01,		1.716801416200437e+01,		1.727877849894436e+01,
		1.738931024560421e+01,		1.749961011236852e+01,		1.760967880830494e+01,		1.771951704113906e+01,		1.782912551722988e+01,
		1.793850494154586e+01,		1.804765601764151e+01,		1.815657944763472e+01,		1.826527593218449e+01,		1.837374617046937e+01,
		1.848199086016643e+01,		1.859001069743073e+01,		1.869780637687550e+01,		1.880537859155268e+01,		1.891272803293415e+01,
		1.901985539089344e+01,		1.912676135368800e+01,		1.923344660794189e+01,		1.933991183862916e+01,		1.944615772905760e+01,
		1.955218496085306e+01,		1.965799421394419e+01,		1.976358616654779e+01,		1.986896149515454e+01,		1.997412087451520e+01,
		2.007906497762738e+01,		2.018379447572264e+01,		2.028831003825410e+01,		2.039261233288457e+01,		2.049670202547490e+01,
		2.060057978007304e+01,		2.070424625890326e+01,		2.080770212235602e+01,		2.091094802897799e+01,		2.101398463546277e+01,
		2.111681259664170e+01,		2.121943256547532e+01,		2.132184519304499e+01,		2.142405112854502e+01,		2.152605101927515e+01,
		2.162784551063334e+01,		2.172943524610891e+01,		2.183082086727611e+01,		2.193200301378786e+01,		2.203298232337007e+01,
		2.213375943181601e+01,		2.223433497298118e+01,		2.233470957877849e+01,		2.243488387917360e+01,		2.253485850218069e+01,
		2.263463407385852e+01,		2.273421121830671e+01,		2.283359055766230e+01,		2.293277271209669e+01,		2.303175829981269e+01,
		2.313054793704199e+01,		2.322914223804275e+01,		2.332754181509755e+01,		2.342574727851148e+01,		2.352375923661060e+01,
		2.362157829574050e+01,		2.371920506026517e+01,		2.381664013256610e+01,		2.391388411304149e+01,		2.401093760010587e+01,
		2.410780119018968e+01,		2.420447547773933e+01,		2.430096105521716e+01,		2.439725851310187e+01,		2.449336843988895e+01,
		2.458929142209137e+01,		2.468502804424043e+01,		2.478057888888681e+01,		2.487594453660178e+01,		2.497112556597853e+01,
		2.506612255363370e+01,		2.516093607420913e+01,		2.525556670037362e+01,		2.535001500282498e+01,		2.544428155029212e+01,
		2.553836690953735e+01,		2.563227164535881e+01,		2.572599632059297e+01,		2.581954149611732e+01,		2.591290773085324e+01,
		2.600609558176882e+01,		2.609910560388197e+01,		2.619193835026360e+01,		2.628459437204084e+01,		2.637707421840041e+01,
		2.646937843659222e+01,		2.656150757193283e+01,		2.665346216780922e+01,		2.674524276568260e+01,		2.683684990509217e+01,
		2.692828412365924e+01,		2.701954595709121e+01,		2.711063593918575e+01,		2.720155460183499e+01,		2.729230247502987e+01,
		2.738288008686449e+01,		2.747328796354064e+01,		2.756352662937223e+01,		2.765359660679000e+01,		2.774349841634612e+01,
		2.783323257671893e+01,		2.792279960471779e+01,		2.801220001528786e+01,		2.810143432151513e+01,		2.819050303463124e+01,
		2.827940666401865e+01,		2.836814571721565e+01,		2.845672069992148e+01,		2.854513211600156e+01,		2.863338046749264e+01,
		2.872146625460815e+01,		2.880938997574343e+01,		2.889715212748115e+01,		2.898475320459665e+01,		2.907219370006338e+01,
		2.915947410505837e+01,		2.924659490896774e+01,		2.933355659939219e+01,		2.942035966215257e+01,		2.950700458129549e+01,
		2.959349183909892e+01,		2.967982191607785e+01,		2.976599529098991e+01,		2.985201244084110e+01,		2.993787384089153e+01,
		3.002357996466106e+01,		3.010913128393518e+01,		3.019452826877064e+01,		3.027977138750136e+01,		3.036486110674418e+01,
		3.044979789140469e+01,		3.053458220468307e+01,		3.061921450807990e+01,		3.070369526140207e+01,		3.078802492276862e+01,
		3.087220394861663e+01,		3.095623279370709e+01,		3.104011191113083e+01,		3.112384175231436e+01,		3.120742276702586e+01,
		3.129085540338101e+01,		3.137414010784899e+01,		3.145727732525833e+01,		3.154026749880283e+01,		3.162311107004757e+01,
		3.170580847893475e+01,		3.178836016378964e+01,		3.187076656132652e+01,		3.195302810665460e+01,		3.203514523328393e+01,
		3.211711837313131e+01,		3.219894795652627e+01,		3.228063441221689e+01,		3.236217816737578e+01,		3.244357964760594e+01,
		3.252483927694671e+01,		3.260595747787961e+01,		3.268693467133423e+01,		3.276777127669416e+01,		3.284846771180280e+01,
		3.292902439296926e+01,		3.300944173497420e+01,		3.308972015107567e+01,		3.316986005301499e+01,		3.324986185102251e+01,
		3.332972595382346e+01,		3.340945276864375e+01,		3.348904270121579e+01,		3.356849615578422e+01,		3.364781353511174e+01,
		3.372699524048483e+01,		3.380604167171949e+01,		3.388495322716701e+01,		3.396373030371967e+01,		3.404237329681646e+01,
		3.412088260044872e+01,		3.419925860716592e+01,		3.427750170808122e+01,		3.435561229287720e+01,		3.443359074981144e+01,
		3.451143746572218e+01,		3.458915282603392e+01,		3.466673721476300e+01,		3.474419101452313e+01,		3.482151460653107e+01,
		3.489870837061207e+01,		3.497577268520540e+01,		3.505270792736992e+01,		3.512951447278953e+01,		3.520619269577865e+01,
		3.528274296928772e+01,		3.535916566490855e+01,		3.543546115287985e+01,		3.551162980209259e+01,		3.558767198009539e+01,
		3.566358805309990e+01,		3.573937838598616e+01,		3.581504334230791e+01,		3.589058328429795e+01,		3.596599857287347e+01,
		3.604128956764117e+01,		3.611645662690276e+01,		3.619150010766003e+01,		3.626642036562016e+01,		3.634121775520089e+01,
		3.641589262953577e+01,		3.649044534047924e+01,		3.656487623861192e+01,		3.663918567324555e+01,		3.671337399242833e+01,
		3.678744154294986e+01,		3.686138867034628e+01,		3.693521571890530e+01,		3.700892303167132e+01,		3.708251095045035e+01,
		3.715597981581505e+01,		3.722932996710976e+01,		3.730256174245540e+01,		3.737567547875447e+01,		3.744867151169595e+01,
		3.752155017576020e+01,		3.759431180422386e+01,		3.766695672916476e+01,		3.773948528146670e+01,		3.781189779082432e+01,
		3.788419458574795e+01,		3.795637599356831e+01,		3.802844234044136e+01,		3.810039395135308e+01,		3.817223115012409e+01,
		3.824395425941449e+01,		3.831556360072852e+01,		3.838705949441920e+01,		3.845844225969306e+01,		3.852971221461468e+01,
		3.860086967611146e+01,		3.867191495997812e+01,		3.874284838088126e+01,		3.881367025236406e+01,		3.888438088685069e+01,
		3.895498059565087e+01,		3.902546968896449e+01,		3.909584847588594e+01,		3.916611726440873e+01,		3.923627636142979e+01,
		3.930632607275407e+01,		3.937626670309886e+01,		3.944609855609819e+01,		3.951582193430727e+01,		3.958543713920674e+01,
		3.965494447120722e+01,		3.972434422965335e+01,		3.979363671282834e+01,		3.986282221795821e+01,		3.993190104121591e+01,
		4.000087347772578e+01,		4.006973982156766e+01,		4.013850036578116e+01,		4.020715540236981e+01,		4.027570522230529e+01,
		4.034415011553158e+01,		4.041249037096911e+01,		4.048072627651887e+01,		4.054885811906652e+01,		4.061688618448652e+01,
		4.068481075764617e+01,		4.075263212240969e+01,		4.082035056164224e+01,		4.088796635721400e+01,		4.095547979000405e+01,
		4.102289113990451e+01,		4.109020068582442e+01,		4.115740870569373e+01,		4.122451547646723e+01,		4.129152127412845e+01,
		4.135842637369363e+01,		4.142523104921549e+01,		4.149193557378726e+01,		4.155854021954637e+01,		4.162504525767839e+01,
		4.169145095842085e+01,		4.175775759106702e+01,		4.182396542396966e+01,		4.189007472454488e+01,		4.195608575927579e+01,
		4.202199879371635e+01,		4.208781409249499e+01,		4.215353191931845e+01,		4.221915253697527e+01,		4.228467620733966e+01,
		4.235010319137508e+01,		4.241543374913783e+01,		4.248066813978082e+01,		4.254580662155701e+01,		4.261084945182312e+01,
		4.267579688704320e+01,		4.274064918279217e+01,		4.280540659375933e+01,		4.287006937375202e+01,		4.293463777569900e+01,
		4.299911205165401e+01,		4.306349245279932e+01,		4.312777922944908e+01,		4.319197263105290e+01,		4.325607290619916e+01,
		4.332008030261861e+01,		4.338399506718761e+01,		4.344781744593165e+01,		4.351154768402871e+01,		4.357518602581257e+01,
		4.363873271477623e+01,		4.370218799357521e+01,		4.376555210403092e+01,		4.382882528713394e+01,		4.389200778304728e+01,
		4.395509983110981e+01,		4.401810166983931e+01,		4.408101353693588e+01,		4.414383566928519e+01,		4.420656830296157e+01,
		4.426921167323137e+01,		4.433176601455612e+01,		4.439423156059560e+01,		4.445660854421116e+01,		4.451889719746887e+01,
		4.458109775164254e+01,		4.464321043721696e+01,		4.470523548389095e+01,		4.476717312058057e+01,		4.482902357542206e+01,
		4.489078707577503e+01,		4.495246384822546e+01,		4.501405411858882e+01,		4.507555811191304e+01,		4.513697605248151e+01,
		4.519830816381621e+01,		4.525955466868061e+01,		4.532071578908268e+01,		4.538179174627783e+01,		4.544278276077195e+01,
		4.550368905232428e+01,		4.556451083995039e+01,		4.562524834192509e+01,		4.568590177578525e+01,		4.574647135833291e+01,
		4.580695730563793e+01,		4.586735983304101e+01,		4.592767915515649e+01,		4.598791548587520e+01,		4.604806903836732e+01,
		4.610814002508513e+01,		4.616812865776600e+01,		4.622803514743493e+01,		4.628785970440755e+01,		4.634760253829276e+01,
		4.640726385799560e+01,		4.646684387171992e+01,		4.652634278697114e+01,		4.658576081055899e+01,		4.664509814860023e+01
	},
	{
		7.395976830407452e-02,		2.217821947040126e-01,		3.692781133061564e-01,		5.164483549557090e-01,		6.632937366017189e-01,
		8.098150621587277e-01,		9.560131233300181e-01,		1.101888700393908e+00,		1.247442562954484e+00,		1.392675470658097e+00,
		1.537588173876931e+00,		1.682181414360869e+00,		1.826455925858854e+00,		1.970412434710910e+00,		2.114051660411917e+00,
		2.257374316148234e+00,		2.400381109308177e+00,		2.543072741967376e+00,		2.685449911349957e+00,		2.827513310266481e+00,
		2.969263627529534e+00,		3.110701548347843e+00,		3.251827754699737e+00,		3.392642925686768e+00,		3.533147737868271e+00,
		3.673342865577613e+00,		3.813228981220841e+00,		3.952806755558454e+00,		4.092076857970961e+00,		4.231039956708867e+00,
		4.369696719127740e+00,		4.508047811908946e+00,		4.646093901266661e+00,		4.783835653141690e+00,		4.921273733382691e+00,
		5.058408807915283e+00,		5.195241542899579e+00,		5.331772604876624e+00,		5.468002660904228e+00,		5.603932378682601e+00,
		5.739562426670323e+00,		5.874893474190985e+00,		6.009926191530964e+00,		6.144661250028708e+00,		6.279099322155942e+00,
		6.413241081591109e+00,		6.547087203285487e+00,		6.680638363522208e+00,		6.813895239968637e+00,		6.946858511722342e+00,
		7.079528859350990e+00,		7.211906964926471e+00,		7.343993512053522e+00,		7.475789185893133e+00,		7.607294673181014e+00,
		7.738510662241335e+00,		7.869437842996030e+00,		8.000076906969872e+00,		8.130428547291569e+00,		8.260493458691055e+00,
		8.390272337493252e+00,		8.519765881608437e+00,		8.648974790519464e+00,		8.777899765265968e+00,		8.906541508425793e+00,
		9.034900724093793e+00,		9.162978117858099e+00,		9.290774396774166e+00,		9.418290269336568e+00,		9.545526445448854e+00,
		9.672483636391471e+00,		9.799162554787980e+00,		9.925563914569626e+00,		1.005168843093844e+01,		1.017753682032898e+01,
		1.030310980036871e+01,		1.042840808983738e+01,		1.055343240862521e+01,		1.067818347769021e+01,		1.080266201901456e+01,
		1.092686875556031e+01,		1.105080441122426e+01,		1.117446971079239e+01,		1.129786537989362e+01,		1.142099214495321e+01,
		1.154385073314570e+01,		1.166644187234760e+01,		1.178876629108975e+01,		1.191082471850955e+01,		1.203261788430301e+01,
		1.215414651867673e+01,		1.227541135229984e+01,		1.239641311625597e+01,		1.251715254199526e+01,		1.263763036128647e+01,
		1.275784730616930e+01,		1.287780410890681e+01,		1.299750150193809e+01,		1.311694021783122e+01,		1.323612098923649e+01,
		1.335504454883995e+01,		1.347371162931725e+01,		1.359212296328799e+01,		1.371027928327031e+01,		1.382818132163601e+01,
		1.394582981056609e+01,		1.406322548200674e+01,		1.418036906762580e+01,		1.429726129876976e+01,		1.441390290642127e+01,
		1.453029462115713e+01,		1.464643717310692e+01,		1.476233129191208e+01,		1.487797770668561e+01,		1.499337714597241e+01,
		1.510853033771007e+01,		1.522343800919035e+01,		1.533810088702128e+01,		1.545251969708978e+01,		1.556669516452498e+01,
		1.568062801366211e+01,		1.579431896800702e+01,		1.590776875020132e+01,		1.602097808198821e+01,		1.613394768417883e+01,
		1.624667827661932e+01,		1.635917057815852e+01,		1.647142530661619e+01,		1.658344317875205e+01,		1.669522491023524e+01,
		1.680677121561457e+01,		1.691808280828932e+01,		1.702916040048066e+01,		1.714000470320375e+01,		1.725061642624034e+01,
		1.736099627811214e+01,		1.747114496605467e+01,		1.758106319599178e+01,		1.769075167251076e+01,		1.780021109883801e+01,
		1.790944217681538e+01,		1.801844560687702e+01,		1.812722208802686e+01,		1.823577231781658e+01,		1.834409699232433e+01,
		1.845219680613380e+01,		1.856007245231397e+01,		1.866772462239940e+01,		1.877515400637105e+01,		1.888236129263761e+01,
		1.898934716801741e+01,		1.909611231772082e+01,		1.920265742533320e+01,		1.930898317279832e+01,		1.941509024040230e+01,
		1.952097930675806e+01,		1.962665104879027e+01,		1.973210614172069e+01,		1.983734525905415e+01,		1.994236907256483e+01,
		2.004717825228312e+01,		2.015177346648288e+01,		2.025615538166909e+01,		2.036032466256613e+01,		2.046428197210624e+01,
		2.056802797141863e+01,		2.067156331981880e+01,		2.077488867479849e+01,		2.087800469201585e+01,		2.098091202528607e+01,
		2.108361132657249e+01,		2.118610324597788e+01,		2.128838843173633e+01,		2.139046753020537e+01,		2.149234118585842e+01,
		2.159401004127779e+01,		2.169547473714773e+01,		2.179673591224813e+01,		2.189779420344831e+01,		2.199865024570130e+01,
		2.209930467203835e+01,		2.219975811356378e+01,		2.230001119945016e+01,		2.240006455693374e+01,		2.249991881131027e+01,
		2.259957458593096e+01,		2.269903250219891e+01,		2.279829317956566e+01,		2.289735723552807e+01,		2.299622528562550e+01,
		2.309489794343722e+01,		2.319337582058002e+01,		2.329165952670615e+01,		2.338974966950151e+01,		2.348764685468402e+01,
		2.358535168600217e+01,		2.368286476523399e+01,		2.378018669218603e+01,		2.387731806469271e+01,		2.397425947861577e+01,
		2.407101152784400e+01,		2.416757480429315e+01,		2.426394989790606e+01,		2.436013739665282e+01,		2.445613788653147e+01,
		2.455195195156850e+01,		2.464758017381977e+01,		2.474302313337143e+01,		2.483828140834126e+01,		2.493335557487989e+01,
		2.502824620717235e+01,		2.512295387743976e+01,		2.521747915594114e+01,		2.531182261097534e+01,		2.540598480888320e+01,
		2.549996631404979e+01,		2.559376768890674e+01,		2.568738949393487e+01,		2.578083228766677e+01,		2.587409662668955e+01,
		2.596718306564785e+01,		2.606009215724671e+01,		2.615282445225480e+01,		2.624538049950766e+01,		2.633776084591104e+01,
		2.642996603644429e+01,		2.652199661416406e+01,		2.661385312020783e+01,		2.670553609379776e+01,		2.679704607224443e+01,
		2.688838359095093e+01,		2.697954918341675e+01,		2.707054338124198e+01,		2.716136671413145e+01,		2.725201970989905e+01,
		2.734250289447201e+01,		2.743281679189545e+01,		2.752296192433673e+01,		2.761293881209014e+01,		2.770274797358142e+01,
		2.779238992537262e+01,		2.788186518216664e+01,		2.797117425681225e+01,		2.806031766030888e+01,		2.814929590181154e+01,
		2.823810948863586e+01,		2.832675892626309e+01,		2.841524471834521e+01,		2.850356736671008e+01,		2.859172737136657e+01,
		2.867972523050987e+01,		2.876756144052669e+01,		2.885523649600058e+01,		2.894275088971737e+01,		2.903010511267039e+01,
		2.911729965406606e+01,		2.920433500132923e+01,		2.929121164010875e+01,		2.937793005428291e+01,		2.946449072596505e+01,
		2.955089413550910e+01,		2.963714076151524e+01,		2.972323108083543e+01,		2.980916556857915e+01,		2.989494469811901e+01,
		2.998056894109650e+01,		3.006603876742768e+01,		3.015135464530887e+01,		3.023651704122249e+01,		3.032152641994271e+01,
		3.040638324454136e+01,		3.049108797639361e+01,		3.057564107518386e+01,		3.066004299891149e+01,		3.074429420389673e+01,
		3.082839514478655e+01,		3.091234627456038e+01,		3.099614804453607e+01,		3.107980090437571e+01,		3.116330530209152e+01,
		3.124666168405172e+01,		3.132987049498636e+01,		3.141293217799331e+01,		3.149584717454401e+01,		3.157861592448948e+01,
		3.166123886606611e+01,		3.174371643590161e+01,		3.182604906902088e+01,		3.190823719885187e+01,		3.199028125723149e+01,
		3.207218167441154e+01,		3.215393887906446e+01,		3.223555329828935e+01,		3.231702535761774e+01,		3.239835548101951e+01,
		3.247954409090872e+01,		3.256059160814950e+01,		3.264149845206187e+01,		3.272226504042758e+01,		3.280289178949596e+01,
		3.288337911398976e+01,		3.296372742711093e+01,		3.304393714054649e+01,		3.312400866447423e+01,		3.320394240756860e+01,
		3.328373877700648e+01,		3.336339817847283e+01,		3.344292101616665e+01,		3.352230769280655e+01,		3.360155860963661e+01,
		3.368067416643196e+01,		3.375965476150466e+01,		3.383850079170932e+01,		3.391721265244877e+01,		3.399579073767971e+01,
		3.407423543991847e+01,		3.415254715024659e+01,		3.423072625831642e+01,		3.430877315235683e+01,		3.438668821917869e+01,
		3.446447184418057e+01,		3.454212441135426e+01,		3.461964630329035e+01,		3.469703790118373e+01,		3.477429958483918e+01,
		3.485143173267679e+01,		3.492843472173758e+01,		3.500530892768888e+01,		3.508205472482975e+01,		3.515867248609663e+01,
		3.523516258306853e+01,		3.531152538597254e+01,		3.538776126368933e+01,		3.546387058375830e+01,		3.553985371238314e+01,
		3.561571101443708e+01,		3.569144285346822e+01,		3.576704959170491e+01,		3.584253159006087e+01,		3.591788920814066e+01,
		3.599312280424482e+01,		3.606823273537509e+01,		3.614321935723972e+01,		3.621808302425858e+01,		3.629282408956841e+01,
		3.636744290502791e+01,		3.644193982122292e+01,		3.651631518747160e+01,		3.659056935182942e+01,		3.666470266109436e+01,
		3.673871546081186e+01,		3.681260809528003e+01,		3.688638090755454e+01,		3.696003423945372e+01,		3.703356843156347e+01,
		3.710698382324232e+01,		3.718028075262637e+01,		3.725345955663416e+01,		3.732652057097170e+01,		3.739946413013728e+01,
		3.747229056742636e+01,		3.754500021493651e+01,		3.761759340357213e+01,		3.769007046304940e+01,		3.776243172190097e+01,
		3.783467750748084e+01,		3.790680814596909e+01,		3.797882396237663e+01,		3.805072528054991e+01,		3.812251242317566e+01,
		3.819418571178555e+01,		3.826574546676095e+01,		3.833719200733744e+01,		3.840852565160954e+01,		3.847974671653535e+01,
		3.855085551794107e+01,		3.862185237052566e+01,		3.869273758786527e+01,		3.876351148241799e+01,		3.883417436552817e+01,
		3.890472654743100e+01,		3.897516833725705e+01,		3.904550004303668e+01,		3.911572197170446e+01,		3.918583442910366e+01,
		3.925583771999067e+01,		3.932573214803932e+01,		3.939551801584533e+01,		3.946519562493061e+01,		3.953476527574762e+01,
		3.960422726768373e+01,		3.967358189906547e+01,		3.974282946716283e+01,		3.981197026819353e+01,		3.988100459732723e+01,
		3.994993274868985e+01,		4.001875501536769e+01,		4.008747168941169e+01,		4.015608306184156e+01,		4.022458942264992e+01,
		4.029299106080656e+01,		4.036128826426244e+01,		4.042948131995381e+01,		4.049757051380635e+01,		4.056555613073924e+01,
		4.063343845466917e+01,		4.070121776851436e+01,		4.076889435419868e+01,		4.083646849265556e+01,		4.090394046383200e+01,
		4.097131054669251e+01,		4.103857901922316e+01,		4.110574615843539e+01,		4.117281224037001e+01,		4.123977754010101e+01,
		4.130664233173959e+01,		4.137340688843788e+01,		4.144007148239287e+01,		4.150663638485022e+01,		4.157310186610808e+01,
		4.163946819552087e+01,		4.170573564150312e+01,		4.177190447153318e+01,		4.183797495215697e+01,		4.190394734899176e+01,
		4.196982192672986e+01,		4.203559894914235e+01,		4.210127867908269e+01,		4.216686137849049e+01,		4.223234730839513e+01,
		4.229773672891932e+01,		4.236302989928286e+01,		4.242822707780617e+01,		4.249332852191385e+01,		4.255833448813835e+01,
		4.262324523212344e+01,		4.268806100862784e+01,		4.275278207152864e+01,		4.281740867382494e+01,		4.288194106764125e+01,
		4.294637950423105e+01,		4.301072423398019e+01,		4.307497550641041e+01,		4.313913357018273e+01,		4.320319867310087e+01,
		4.326717106211474e+01,		4.333105098332371e+01,		4.339483868198013e+01,		4.345853440249255e+01,		4.352213838842923e+01,
		4.358565088252131e+01,		4.364907212666625e+01,		4.371240236193109e+01,		4.377564182855574e+01,		4.383879076595638e+01,
		4.390184941272845e+01,		4.396481800665021e+01,		4.402769678468576e+01,		4.409048598298836e+01,		4.415318583690365e+01,
		4.421579658097274e+01,		4.427831844893557e+01,		4.434075167373389e+01,		4.440309648751450e+01,		4.446535312163245e+01,
		4.452752180665401e+01,		4.458960277235999e+01,		4.465159624774863e+01,		4.471350246103883e+01,		4.477532163967315e+01,
		4.483705401032091e+01,		4.489869979888126e+01,		4.496025923048610e+01,		4.502173252950323e+01,		4.508311991953929e+01,
		4.514442162344275e+01,		4.520563786330694e+01,		4.526676886047296e+01,		4.532781483553268e+01,		4.538877600833167e+01,
		4.544965259797212e+01,		4.551044482281576e+01,		4.557115290048678e+01,		4.563177704787469e+01,		4.569231748113726e+01,
		4.575277441570334e+01,		4.581314806627570e+01,		4.587343864683393e+01,		4.593364637063726e+01,		4.599377145022731e+01,
		4.605381409743096e+01,		4.611377452336316e+01,		4.617365293842968e+01,		4.623344955232986e+01,		4.629316457405943e+01,
		4.635279821191320e+01,		4.641235067348784e+01,		4.647182216568452e+01,		4.653121289471181e+01,		4.659052306608812e+01
	},
	{
		7.382394653869197e-02,		2.213752110219968e-01,		3.686009718423515e-01,		5.155020584154382e-01,		6.620792863603495e-01,
		8.083334583519156e-01,		9.542653649351097e-01,		1.099875785302955e+00,		1.245165488039300e+00,		1.390135231827791e+00,
		1.534785766128298e+00,		1.679117831822037e+00,		1.823132161826549e+00,		1.966829481681696e+00,		2.110210510107746e+00,
		2.253275959536627e+00,		2.396026536617361e+00,		2.538462942696655e+00,		2.680585874275615e+00,		2.822396023443484e+00,
		2.963894078289295e+00,		3.105080723292300e+00,		3.245956639691976e+00,		3.386522505838434e+00,		3.526778997523965e+00,
		3.666726788296505e+00,		3.806366549755684e+00,		3.945698951832199e+00,		4.084724663051142e+00,		4.223444350779946e+00,
		4.361858681461572e+00,		4.499968320833515e+00,		4.637773934133237e+00,		4.775276186290575e+00,		4.912475742107650e+00,
		5.049373266426833e+00,		5.185969424287218e+00,		5.322264881070165e+00,		5.458260302634291e+00,		5.593956355440433e+00,
		5.729353706666993e+00,		5.864453024316082e+00,		5.999254977310876e+00,		6.133760235584577e+00,		6.267969470161346e+00,
		6.401883353229608e+00,		6.535502558208019e+00,		6.668827759804499e+00,		6.801859634068616e+00,		6.934598858437651e+00,
		7.067046111776643e+00,		7.199202074412714e+00,		7.331067428163948e+00,		7.462642856363099e+00,		7.593929043876378e+00,
		7.724926677117605e+00,		7.855636444057907e+00,		7.986059034231280e+00,		8.116195138736135e+00,		8.246045450233140e+00,
		8.375610662939513e+00,		8.504891472619963e+00,		8.633888576574515e+00,		8.762602673623327e+00,		8.891034464088753e+00,
		9.019184649774791e+00,		9.147053933944051e+00,		9.274643021292439e+00,		9.401952617921705e+00,		9.528983431309957e+00,
		9.655736170280340e+00,		9.782211544967941e+00,		9.908410266785149e+00,		1.003433304838544e+01,		1.015998060362586e+01,
		1.028535364752825e+01,		1.041045289623923e+01,		1.053527906698925e+01,		1.065983287805058e+01,		1.078411504869452e+01,
		1.090812629914779e+01,		1.103186735054817e+01,		1.115533892489972e+01,		1.127854174502721e+01,		1.140147653453033e+01,
		1.152414401773730e+01,		1.164654491965834e+01,		1.176867996593872e+01,		1.189054988281173e+01,		1.201215539705141e+01,
		1.213349723592528e+01,		1.225457612714694e+01,		1.237539279882871e+01,		1.249594797943438e+01,		1.261624239773195e+01,
		1.273627678274659e+01,		1.285605186371378e+01,		1.297556837003256e+01,		1.309482703121919e+01,		1.321382857686092e+01,
		1.333257373657021e+01,		1.345106323993916e+01,		1.356929781649446e+01,		1.368727819565255e+01,		1.380500510667535e+01,
		1.392247927862632e+01,		1.403970144032704e+01,		1.415667232031420e+01,		1.427339264679715e+01,		1.438986314761591e+01,
		1.450608455019969e+01,		1.462205758152601e+01,		1.473778296808029e+01,		1.485326143581604e+01,		1.496849371011563e+01,
		1.508348051575159e+01,		1.519822257684852e+01,		1.531272061684561e+01,		1.542697535845975e+01,		1.554098752364923e+01,
		1.565475783357800e+01,		1.576828700858072e+01,		1.588157576812817e+01,		1.599462483079349e+01,		1.610743491421896e+01,
		1.622000673508336e+01,		1.633234100907002e+01,		1.644443845083550e+01,		1.655629977397876e+01,		1.666792569101118e+01,
		1.677931691332696e+01,		1.689047415117426e+01,		1.700139811362701e+01,		1.711208950855717e+01,		1.722254904260775e+01,
		1.733277742116633e+01,		1.744277534833930e+01,		1.755254352692652e+01,		1.766208265839676e+01,		1.777139344286362e+01,
		1.788047657906205e+01,		1.798933276432550e+01,		1.809796269456351e+01,		1.820636706424008e+01,		1.831454656635240e+01,
		1.842250189241026e+01,		1.853023373241591e+01,		1.863774277484463e+01,		1.874502970662561e+01,		1.885209521312358e+01,
		1.895893997812080e+01,		1.906556468379967e+01,		1.917197001072581e+01,		1.927815663783167e+01,		1.938412524240057e+01,
		1.948987650005132e+01,		1.959541108472329e+01,		1.970072966866189e+01,		1.980583292240469e+01,		1.991072151476778e+01,
		2.001539611283277e+01,		2.011985738193415e+01,		2.022410598564709e+01,		2.032814258577573e+01,		2.043196784234181e+01,
		2.053558241357383e+01,		2.063898695589655e+01,		2.074218212392084e+01,		2.084516857043412e+01,		2.094794694639097e+01,
		2.105051790090429e+01,		2.115288208123672e+01,		2.125504013279254e+01,		2.135699269910987e+01,		2.145874042185321e+01,
		2.156028394080636e+01,		2.166162389386574e+01,		2.176276091703394e+01,		2.186369564441365e+01,		2.196442870820197e+01,
		2.206496073868490e+01,		2.216529236423235e+01,		2.226542421129321e+01,		2.236535690439093e+01,		2.246509106611923e+01,
		2.256462731713829e+01,		2.266396627617096e+01,		2.276310855999951e+01,		2.286205478346247e+01,		2.296080555945181e+01,
		2.305936149891033e+01,		2.315772321082940e+01,		2.325589130224682e+01,		2.335386637824496e+01,		2.345164904194927e+01,
		2.354923989452677e+01,		2.364663953518499e+01,		2.374384856117100e+01,		2.384086756777072e+01,		2.393769714830840e+01,
		2.403433789414631e+01,		2.413079039468468e+01,		2.422705523736176e+01,		2.432313300765408e+01,		2.441902428907704e+01,
		2.451472966318538e+01,		2.461024970957419e+01,		2.470558500587977e+01,		2.480073612778090e+01,		2.489570364900010e+01,
		2.499048814130515e+01,		2.508509017451077e+01,		2.517951031648037e+01,		2.527374913312800e+01,		2.536780718842048e+01,
		2.546168504437957e+01,		2.555538326108440e+01,		2.564890239667389e+01,		2.574224300734944e+01,		2.583540564737766e+01,
		2.592839086909323e+01,		2.602119922290189e+01,		2.611383125728354e+01,		2.620628751879547e+01,		2.629856855207569e+01,
		2.639067489984634e+01,		2.648260710291719e+01,		2.657436570018933e+01,		2.666595122865884e+01,		2.675736422342067e+01,
		2.684860521767247e+01,		2.693967474271864e+01,		2.703057332797437e+01,		2.712130150096985e+01,		2.721185978735443e+01,
		2.730224871090105e+01,		2.739246879351048e+01,		2.748252055521594e+01,		2.757240451418750e+01,		2.766212118673679e+01,
		2.775167108732153e+01,		2.784105472855038e+01,		2.793027262118767e+01,		2.801932527415819e+01,		2.810821319455217e+01,
		2.819693688763025e+01,		2.828549685682835e+01,		2.837389360376283e+01,		2.846212762823560e+01,		2.855019942823918e+01,
		2.863810949996197e+01,		2.872585833779343e+01,		2.881344643432938e+01,		2.890087428037730e+01,		2.898814236496170e+01,
		2.907525117532945e+01,		2.916220119695526e+01,		2.924899291354707e+01,		2.933562680705158e+01,		2.942210335765974e+01,
		2.950842304381228e+01,		2.959458634220525e+01,		2.968059372779567e+01,		2.976644567380712e+01,		2.985214265173530e+01,
		2.993768513135380e+01,		3.002307358071968e+01,		3.010830846617922e+01,		3.019339025237365e+01,		3.027831940224475e+01,
		3.036309637704076e+01,		3.044772163632201e+01,		3.053219563796675e+01,		3.061651883817690e+01,		3.070069169148388e+01,
		3.078471465075435e+01,		3.086858816719608e+01,		3.095231269036371e+01,		3.103588866816463e+01,		3.111931654686479e+01,
		3.120259677109452e+01,		3.128572978385436e+01,		3.136871602652095e+01,		3.145155593885284e+01,		3.153424995899634e+01,
		3.161679852349140e+01,		3.169920206727740e+01,		3.178146102369909e+01,		3.186357582451232e+01,		3.194554689989000e+01,
		3.202737467842790e+01,		3.210905958715045e+01,		3.219060205151666e+01,		3.227200249542587e+01,		3.235326134122369e+01,
		3.243437900970768e+01,		3.251535592013331e+01,		3.259619249021966e+01,		3.267688913615531e+01,		3.275744627260408e+01,
		3.283786431271087e+01,		3.291814366810740e+01,		3.299828474891800e+01,		3.307828796376540e+01,		3.315815371977641e+01,
		3.323788242258778e+01,		3.331747447635181e+01,		3.339693028374221e+01,		3.347625024595966e+01,		3.355543476273762e+01,
		3.363448423234802e+01,		3.371339905160687e+01,		3.379217961587997e+01,		3.387082631908856e+01,		3.394933955371497e+01,
		3.402771971080819e+01,		3.410596717998954e+01,		3.418408234945828e+01,		3.426206560599712e+01,		3.433991733497786e+01,
		3.441763792036691e+01,		3.449522774473084e+01,		3.457268718924189e+01,		3.465001663368352e+01,		3.472721645645586e+01,
		3.480428703458121e+01,		3.488122874370946e+01,		3.495804195812367e+01,		3.503472705074528e+01,		3.511128439313973e+01,
		3.518771435552177e+01,		3.526401730676078e+01,		3.534019361438628e+01,		3.541624364459312e+01,		3.549216776224692e+01,
		3.556796633088933e+01,		3.564363971274334e+01,		3.571918826871857e+01,		3.579461235841647e+01,		3.586991234013563e+01,
		3.594508857087698e+01,		3.602014140634899e+01,		3.609507120097282e+01,		3.616987830788761e+01,		3.624456307895547e+01,
		3.631912586476669e+01,		3.639356701464493e+01,		3.646788687665220e+01,		3.654208579759395e+01,		3.661616412302421e+01,
		3.669012219725055e+01,		3.676396036333912e+01,		3.683767896311971e+01,		3.691127833719065e+01,		3.698475882492387e+01,
		3.705812076446968e+01,		3.713136449276196e+01,		3.720449034552279e+01,		3.727749865726758e+01,		3.735038976130979e+01,
		3.742316398976579e+01,		3.749582167355982e+01,		3.756836314242867e+01,		3.764078872492649e+01,		3.771309874842972e+01,
		3.778529353914163e+01,		3.785737342209720e+01,		3.792933872116784e+01,		3.800118975906602e+01,		3.807292685735003e+01,
		3.814455033642857e+01,		3.821606051556550e+01,		3.828745771288436e+01,		3.835874224537305e+01,		3.842991442888838e+01,
		3.850097457816069e+01,		3.857192300679833e+01,		3.864276002729228e+01,		3.871348595102062e+01,		3.878410108825302e+01,
		3.885460574815525e+01,		3.892500023879357e+01,		3.899528486713930e+01,		3.906545993907315e+01,		3.913552575938959e+01,
		3.920548263180140e+01,		3.927533085894384e+01,		3.934507074237911e+01,		3.941470258260069e+01,		3.948422667903763e+01,
		3.955364333005886e+01,		3.962295283297740e+01,		3.969215548405472e+01,		3.976125157850495e+01,		3.983024141049906e+01,
		3.989912527316910e+01,		3.996790345861242e+01,		4.003657625789580e+01,		4.010514396105960e+01,		4.017360685712190e+01,
		4.024196523408270e+01,		4.031021937892785e+01,		4.037836957763327e+01,		4.044641611516901e+01,		4.051435927550324e+01,
		4.058219934160630e+01,		4.064993659545473e+01,		4.071757131803528e+01,		4.078510378934885e+01,		4.085253428841443e+01,
		4.091986309327317e+01,		4.098709048099220e+01,		4.105421672766852e+01,		4.112124210843298e+01,		4.118816689745411e+01,
		4.125499136794205e+01,		4.132171579215223e+01,		4.138834044138940e+01,		4.145486558601131e+01,		4.152129149543254e+01,
		4.158761843812832e+01,		4.165384668163820e+01,		4.171997649256991e+01,		4.178600813660298e+01,		4.185194187849255e+01,
		4.191777798207303e+01,		4.198351671026174e+01,		4.204915832506263e+01,		4.211470308756996e+01,		4.218015125797184e+01,
		4.224550309555389e+01,		4.231075885870292e+01,		4.237591880491037e+01,		4.244098319077604e+01,		4.250595227201153e+01,
		4.257082630344380e+01,		4.263560553901878e+01,		4.270029023180479e+01,		4.276488063399604e+01,		4.282937699691617e+01,
		4.289377957102167e+01,		4.295808860590534e+01,		4.302230435029973e+01,		4.308642705208057e+01,		4.315045695827012e+01,
		4.321439431504068e+01,		4.327823936771782e+01,		4.334199236078386e+01,		4.340565353788116e+01,		4.346922314181543e+01,
		4.353270141455915e+01,		4.359608859725472e+01,		4.365938493021795e+01,		4.372259065294109e+01,		4.378570600409631e+01,
		4.384873122153888e+01,		4.391166654231028e+01,		4.397451220264163e+01,		4.403726843795672e+01,		4.409993548287532e+01,
		4.416251357121625e+01,		4.422500293600063e+01,		4.428740380945502e+01,		4.434971642301452e+01,		4.441194100732593e+01,
		4.447407779225075e+01,		4.453612700686851e+01,		4.459808887947963e+01,		4.465996363760856e+01,		4.472175150800688e+01,
		4.478345271665624e+01,		4.484506748877157e+01,		4.490659604880391e+01,		4.496803862044351e+01,		4.502939542662277e+01,
		4.509066668951932e+01,		4.515185263055880e+01,		4.521295347041806e+01,		4.527396942902785e+01,		4.533490072557596e+01,
		4.539574757850993e+01,		4.545651020554018e+01,		4.551718882364268e+01,		4.557778364906201e+01,		4.563829489731403e+01,
		4.569872278318895e+01,		4.575906752075403e+01,		4.581932932335641e+01,		4.587950840362599e+01,		4.593960497347821e+01,
		4.599961924411679e+01,		4.605955142603658e+01,		4.611940172902631e+01,		4.617917036217135e+01,		4.623885753385637e+01,
		4.629846345176821e+01,		4.635798832289852e+01,		4.641743235354643e+01,		4.647679574932142e+01,		4.653607871514574e+01
	},
	{
		7.368862284691975e-02,		2.209697194858292e-01,		3.679263124870923e-01,		5.145592298231443e-01,		6.608692857684541e-01,
		8.068572817426533e-01,		9.525240071162068e-01,		1.097870239980038e+00,		1.242896747880452e+00,		1.387604288520664e+00,
		1.531993610430182e+00,		1.676065453603263e+00,		1.819820550107591e+00,		1.963259624664309e+00,		2.106383395200499e+00,
		2.249192573375123e+00,		2.391687865079460e+00,		2.533869970913011e+00,		2.675739586635770e+00,		2.817297403597833e+00,
		2.958544109147143e+00,		3.099480387016273e+00,		3.240106917689026e+00,		3.380424378747651e+00,		3.520433445201427e+00,
		3.660134789797351e+00,		3.799529083313636e+00,		3.938616994836687e+00,		4.077399192022246e+00,		4.215876341341300e+00,
		4.354049108311401e+00,		4.491918157713979e+00,		4.629484153798198e+00,		4.766747760471954e+00,		4.903709641480510e+00,
		5.040370460573284e+00,		5.176730881659320e+00,		5.312791568951889e+00,		5.448553187102693e+00,		5.584016401326121e+00,
		5.719181877513986e+00,		5.854050282341179e+00,		5.988622283362586e+00,		6.122898549101737e+00,		6.256879749131481e+00,
		6.390566554147099e+00,		6.523959636032188e+00,		6.657059667917641e+00,		6.789867324234062e+00,		6.922383280757916e+00,
		7.054608214651712e+00,		7.186542804498536e+00,		7.318187730331141e+00,		7.449543673655983e+00,		7.580611317472325e+00,
		7.711391346286750e+00,		7.841884446123303e+00,		7.972091304529451e+00,		8.102012610578157e+00,		8.231649054866198e+00,
		8.361001329509016e+00,		8.490070128132199e+00,		8.618856145859903e+00,		8.747360079300281e+00,		8.875582626528161e+00,
		9.003524487065141e+00,		9.131186361857216e+00,		9.258568953250153e+00,		9.385672964962676e+00,		9.512499102057753e+00,
		9.639048070911903e+00,		9.765320579182882e+00,		9.891317335775705e+00,		1.001703905080722e+01,		1.014248643556928e+01,
		1.026766020249070e+01,		1.039256106509804e+01,		1.051718973797532e+01,		1.064154693672282e+01,		1.076563337791495e+01,
		1.088944977905746e+01,		1.101299685854380e+01,		1.113627533561100e+01,		1.125928593029498e+01,		1.138202936338530e+01,
		1.150450635637968e+01,		1.162671763143805e+01,		1.174866391133639e+01,		1.187034591942038e+01,		1.199176437955886e+01,
		1.211292001609716e+01,		1.223381355381052e+01,		1.235444571785733e+01,		1.247481723373254e+01,		1.259492882722110e+01,
		1.271478122435159e+01,		1.283437515134994e+01,		1.295371133459338e+01,		1.307279050056467e+01,		1.319161337580655e+01,
		1.331018068687651e+01,		1.342849316030189e+01,		1.354655152253533e+01,		1.366435649991056e+01,		1.378190881859871e+01,
		1.389920920456491e+01,		1.401625838352539e+01,		1.413305708090508e+01,		1.424960602179562e+01,		1.436590593091392e+01,
		1.448195753256119e+01,		1.459776155058254e+01,		1.471331870832706e+01,		1.482862972860854e+01,		1.494369533366659e+01,
		1.505851624512852e+01,		1.517309318397164e+01,		1.528742687048622e+01,		1.540151802423903e+01,		1.551536736403743e+01,
		1.562897560789412e+01,		1.574234347299248e+01,		1.585547167565246e+01,		1.596836093129714e+01,		1.608101195441989e+01,
		1.619342545855212e+01,		1.630560215623166e+01,		1.641754275897175e+01,		1.652924797723064e+01,		1.664071852038179e+01,
		1.675195509668470e+01,		1.686295841325636e+01,		1.697372917604324e+01,		1.708426808979400e+01,		1.719457585803265e+01,
		1.730465318303244e+01,		1.741450076579030e+01,		1.752411930600182e+01,		1.763350950203690e+01,		1.774267205091590e+01,
		1.785160764828644e+01,		1.796031698840074e+01,		1.806880076409348e+01,		1.817705966676029e+01,		1.828509438633678e+01,
		1.839290561127811e+01,		1.850049402853906e+01,		1.860786032355476e+01,		1.871500518022177e+01,		1.882192928087989e+01,
		1.892863330629430e+01,		1.903511793563835e+01,		1.914138384647676e+01,		1.924743171474945e+01,		1.935326221475565e+01,
		1.945887601913871e+01,		1.956427379887126e+01,		1.966945622324092e+01,		1.977442395983636e+01,		1.987917767453397e+01,
		1.998371803148487e+01,		2.008804569310239e+01,		2.019216132004998e+01,		2.029606557122963e+01,		2.039975910377057e+01,
		2.050324257301850e+01,		2.060651663252519e+01,		2.070958193403846e+01,		2.081243912749265e+01,		2.091508886099929e+01,
		2.101753178083836e+01,		2.111976853144982e+01,		2.122179975542546e+01,		2.132362609350126e+01,		2.142524818454994e+01,
		2.152666666557399e+01,		2.162788217169895e+01,		2.172889533616705e+01,		2.182970679033122e+01,		2.193031716364938e+01,
		2.203072708367904e+01,		2.213093717607224e+01,		2.223094806457074e+01,		2.233076037100161e+01,		2.243037471527298e+01,
		2.252979171537017e+01,		2.262901198735207e+01,		2.272803614534774e+01,		2.282686480155345e+01,		2.292549856622966e+01,
		2.302393804769866e+01,		2.312218385234212e+01,		2.322023658459909e+01,		2.331809684696410e+01,		2.341576523998560e+01,
		2.351324236226462e+01,		2.361052881045357e+01,		2.370762517925533e+01,		2.380453206142252e+01,		2.390125004775706e+01,
		2.399777972710974e+01,		2.409412168638023e+01,		2.419027651051709e+01,		2.428624478251812e+01,		2.438202708343075e+01,
		2.447762399235270e+01,		2.457303608643282e+01,		2.466826394087202e+01,		2.476330812892455e+01,		2.485816922189911e+01,
		2.495284778916053e+01,		2.504734439813128e+01,		2.514165961429325e+01,		2.523579400118975e+01,		2.532974812042748e+01,
		2.542352253167881e+01,		2.551711779268410e+01,		2.561053445925412e+01,		2.570377308527274e+01,		2.579683422269958e+01,
		2.588971842157291e+01,		2.598242623001252e+01,		2.607495819422292e+01,		2.616731485849641e+01,		2.625949676521646e+01,
		2.635150445486104e+01,		2.644333846600616e+01,		2.653499933532946e+01,		2.662648759761388e+01,		2.671780378575150e+01,
		2.680894843074730e+01,		2.689992206172328e+01,		2.699072520592233e+01,		2.708135838871252e+01,		2.717182213359118e+01,
		2.726211696218925e+01,		2.735224339427560e+01,		2.744220194776146e+01,		2.753199313870496e+01,		2.762161748131560e+01,
		2.771107548795896e+01,		2.780036766916135e+01,		2.788949453361456e+01,		2.797845658818065e+01,		2.806725433789683e+01,
		2.815588828598038e+01,		2.824435893383358e+01,		2.833266678104878e+01,		2.842081232541338e+01,		2.850879606291501e+01,
		2.859661848774665e+01,		2.868428009231183e+01,		2.877178136722986e+01,		2.885912280134110e+01,		2.894630488171228e+01,
		2.903332809364182e+01,		2.912019292066523e+01,		2.920689984456052e+01,		2.929344934535363e+01,		2.937984190132390e+01,
		2.946607798900957e+01,		2.955215808321330e+01,		2.963808265700774e+01,		2.972385218174109e+01,		2.980946712704266e+01,
		2.989492796082852e+01,		2.998023514930717e+01,		3.006538915698510e+01,		3.015039044667256e+01,		3.023523947948917e+01,
		3.031993671486969e+01,		3.040448261056964e+01,		3.048887762267118e+01,		3.057312220558869e+01,		3.065721681207459e+01,
		3.074116189322518e+01,		3.082495789848625e+01,		3.090860527565900e+01,		3.099210447090575e+01,		3.107545592875576e+01,
		3.115866009211101e+01,		3.124171740225201e+01,		3.132462829884362e+01,		3.140739321994084e+01,		3.149001260199463e+01,
		3.157248687985770e+01,		3.165481648679036e+01,		3.173700185446631e+01,		3.181904341297843e+01,		3.190094159084465e+01,
		3.198269681501369e+01,		3.206430951087089e+01,		3.214578010224408e+01,		3.222710901140925e+01,		3.230829665909643e+01,
		3.238934346449546e+01,		3.247024984526179e+01,		3.255101621752219e+01,		3.263164299588062e+01,		3.271213059342391e+01,
		3.279247942172754e+01,		3.287268989086142e+01,		3.295276240939558e+01,		3.303269738440589e+01,		3.311249522147990e+01,
		3.319215632472235e+01,		3.327168109676107e+01,		3.335106993875252e+01,		3.343032325038757e+01,		3.350944142989708e+01,
		3.358842487405765e+01,		3.366727397819718e+01,		3.374598913620054e+01,		3.382457074051518e+01,		3.390301918215675e+01,
		3.398133485071470e+01,		3.405951813435780e+01,		3.413756941983976e+01,		3.421548909250478e+01,		3.429327753629302e+01,
		3.437093513374626e+01,		3.444846226601327e+01,		3.452585931285532e+01,		3.460312665265177e+01,		3.468026466240539e+01,
		3.475727371774793e+01,		3.483415419294540e+01,		3.491090646090365e+01,		3.498753089317364e+01,		3.506402785995693e+01,
		3.514039773011096e+01,		3.521664087115440e+01,		3.529275764927256e+01,		3.536874842932259e+01,		3.544461357483891e+01,
		3.552035344803840e+01,		3.559596840982566e+01,		3.567145881979832e+01,		3.574682503625222e+01,		3.582206741618661e+01,
		3.589718631530940e+01,		3.597218208804228e+01,		3.604705508752590e+01,		3.612180566562503e+01,		3.619643417293365e+01,
		3.627094095878005e+01,		3.634532637123194e+01,		3.641959075710150e+01,		3.649373446195046e+01,		3.656775783009507e+01,
		3.664166120461120e+01,		3.671544492733923e+01,		3.678910933888907e+01,		3.686265477864518e+01,		3.693608158477144e+01,
		3.700939009421602e+01,		3.708258064271645e+01,		3.715565356480428e+01,		3.722860919381016e+01,		3.730144786186848e+01,
		3.737416989992243e+01,		3.744677563772854e+01,		3.751926540386174e+01,		3.759163952571987e+01,		3.766389832952868e+01,
		3.773604214034633e+01,		3.780807128206833e+01,		3.787998607743203e+01,		3.795178684802146e+01,		3.802347391427185e+01,
		3.809504759547438e+01,		3.816650820978079e+01,		3.823785607420785e+01,		3.830909150464218e+01,		3.838021481584457e+01,
		3.845122632145467e+01,		3.852212633399554e+01,		3.859291516487801e+01,		3.866359312440538e+01,		3.873416052177766e+01,
		3.880461766509625e+01,		3.887496486136820e+01,		3.894520241651075e+01,		3.901533063535562e+01,		3.908534982165354e+01,
		3.915526027807842e+01,		3.922506230623188e+01,		3.929475620664743e+01,		3.936434227879490e+01,		3.943382082108464e+01,
		3.950319213087187e+01,		3.957245650446084e+01,		3.964161423710914e+01,		3.971066562303190e+01,		3.977961095540600e+01,
		3.984845052637423e+01,		3.991718462704949e+01,		3.998581354751890e+01,		4.005433757684792e+01,		4.012275700308457e+01,
		4.019107211326335e+01,		4.025928319340953e+01,		4.032739052854298e+01,		4.039539440268241e+01,		4.046329509884931e+01,
		4.053109289907190e+01,		4.059878808438925e+01,		4.066638093485520e+01,		4.073387172954227e+01,		4.080126074654566e+01,
		4.086854826298715e+01,		4.093573455501905e+01,		4.100281989782799e+01,		4.106980456563892e+01,		4.113668883171884e+01,
		4.120347296838077e+01,		4.127015724698746e+01,		4.133674193795527e+01,		4.140322731075795e+01,		4.146961363393036e+01,
		4.153590117507234e+01,		4.160209020085230e+01,		4.166818097701110e+01,		4.173417376836564e+01,		4.180006883881264e+01,
		4.186586645133228e+01,		4.193156686799183e+01,		4.199717034994934e+01,		4.206267715745732e+01,		4.212808754986624e+01,
		4.219340178562818e+01,		4.225862012230044e+01,		4.232374281654910e+01,		4.238877012415254e+01,		4.245370230000501e+01,
		4.251853959812014e+01,		4.258328227163444e+01,		4.264793057281081e+01,		4.271248475304198e+01,		4.277694506285404e+01,
		4.284131175190982e+01,		4.290558506901232e+01,		4.296976526210822e+01,		4.303385257829116e+01,		4.309784726380519e+01,
		4.316174956404814e+01,		4.322555972357500e+01,		4.328927798610119e+01,		4.335290459450598e+01,		4.341643979083570e+01,
		4.347988381630719e+01,		4.354323691131091e+01,		4.360649931541432e+01,		4.366967126736517e+01,		4.373275300509463e+01,
		4.379574476572059e+01,		4.385864678555090e+01,		4.392145930008649e+01,		4.398418254402463e+01,		4.404681675126206e+01,
		4.410936215489820e+01,		4.417181898723825e+01,		4.423418747979633e+01,		4.429646786329860e+01,		4.435866036768640e+01,
		4.442076522211931e+01,		4.448278265497823e+01,		4.454471289386845e+01,		4.460655616562271e+01,		4.466831269630425e+01,
		4.472998271120977e+01,		4.479156643487256e+01,		4.485306409106541e+01,		4.491447590280360e+01,		4.497580209234793e+01,
		4.503704288120763e+01,		4.509819849014335e+01,		4.515926913917004e+01,		4.522025504755993e+01,		4.528115643384544e+01,
		4.534197351582203e+01,		4.540270651055113e+01,		4.546335563436299e+01,		4.552392110285955e+01,		4.558440313091731e+01,
		4.564480193269014e+01,		4.570511772161206e+01,		4.576535071040018e+01,		4.582550111105741e+01,		4.588556913487523e+01,
		4.594555499243648e+01,		4.600545889361825e+01,		4.606528104759440e+01,		4.612502166283854e+01,		4.618468094712654e+01,
		4.624425910753949e+01,		4.630375635046613e+01,		4.636317288160576e+01,		4.642250890597087e+01,		4.648176462788974e+01
	},
	{
		7.355379449321699e-02,		2.205657118971152e-01,		3.672541215976908e-01,		5.136198501107445e-01,		6.596637103518078e-01,
		8.053865024701851e-01,		9.507890146460052e-01,		1.095872023851664e+00,		1.240636296578993e+00,		1.385082589533436e+00,
		1.529211650296481e+00,		1.673024217957521e+00,		1.816521023716311e+00,		1.959702791457119e+00,		2.102570238295644e+00,
		2.245124075099727e+00,		2.387365006984850e+00,		2.529293733785384e+00,		2.670910950502508e+00,		2.812217347729700e+00,
		2.953213612056631e+00,		3.093900426452354e+00,		3.234278470628516e+00,		3.374348421383430e+00,		3.514110952927720e+00,
		3.653566737192267e+00,		3.792716444119172e+00,		3.931560741936377e+00,		4.070100297416630e+00,		4.208335776121380e+00,
		4.346267842630266e+00,		4.483897160756712e+00,		4.621224393750262e+00,		4.758250204486157e+00,		4.894975255642700e+00,
		5.031400209866906e+00,		5.167525729928938e+00,		5.303352478865798e+00,		5.438881120114743e+00,		5.574112317636825e+00,
		5.709046736031047e+00,		5.843685040639493e+00,		5.978027897643849e+00,		6.112075974153694e+00,		6.245829938286938e+00,
		6.379290459242752e+00,		6.512458207367335e+00,		6.645333854212860e+00,		6.777918072589904e+00,		6.910211536613675e+00,
		7.042214921744343e+00,		7.173928904821739e+00,		7.305354164094709e+00,		7.436491379245400e+00,		7.567341231408712e+00,
		7.697904403187168e+00,		7.828181578661450e+00,		7.958173443396818e+00,		8.087880684445626e+00,		8.217303990346167e+00,
		8.346444051118009e+00,		8.475301558254078e+00,		8.603877204709613e+00,		8.732171684888211e+00,		8.860185694625120e+00,
		8.987919931167957e+00,		9.115375093154997e+00,		9.242551880591181e+00,		9.369450994822026e+00,		9.496073138505546e+00,
		9.622419015582286e+00,		9.748489331243706e+00,		9.874284791898916e+00,		9.999806105139946e+00,		1.012505397970568e+01,
		1.025002912544450e+01,		1.037473225327582e+01,		1.049916407515051e+01,		1.062332530401045e+01,		1.074721665374713e+01,
		1.087083883915955e+01,		1.099419257591136e+01,		1.111727858048745e+01,		1.124009757014992e+01,		1.136265026289366e+01,
		1.148493737740152e+01,		1.160695963299903e+01,		1.172871774960904e+01,		1.185021244770599e+01,		1.197144444827007e+01,
		1.209241447274129e+01,		1.221312324297353e+01,		1.233357148118843e+01,		1.245375990992953e+01,		1.257368925201631e+01,
		1.269336023049849e+01,		1.281277356861035e+01,		1.293192998972538e+01,		1.305083021731107e+01,		1.316947497488398e+01,
		1.328786498596513e+01,		1.340600097403568e+01,		1.352388366249293e+01,		1.364151377460677e+01,		1.375889203347645e+01,
		1.387601916198779e+01,		1.399289588277083e+01,		1.410952291815791e+01,		1.422590099014225e+01,		1.434203082033700e+01,
		1.445791312993480e+01,		1.457354863966782e+01,		1.468893806976837e+01,		1.480408213993006e+01,		1.491898156926943e+01,
		1.503363707628822e+01,		1.514804937883612e+01,		1.526221919407424e+01,		1.537614723843896e+01,		1.548983422760651e+01,
		1.560328087645812e+01,		1.571648789904570e+01,		1.582945600855816e+01,		1.594218591728836e+01,		1.605467833660055e+01,
		1.616693397689862e+01,		1.627895354759467e+01,		1.639073775707843e+01,		1.650228731268718e+01,		1.661360292067626e+01,
		1.672468528619023e+01,		1.683553511323457e+01,		1.694615310464803e+01,		1.705653996207559e+01,		1.716669638594190e+01,
		1.727662307542550e+01,		1.738632072843339e+01,		1.749579004157643e+01,		1.760503171014509e+01,		1.771404642808597e+01,
		1.782283488797873e+01,		1.793139778101368e+01,		1.803973579696991e+01,		1.814784962419398e+01,		1.825573994957906e+01,
		1.836340745854482e+01,		1.847085283501765e+01,		1.857807676141151e+01,		1.868507991860931e+01,		1.879186298594480e+01,
		1.889842664118489e+01,		1.900477156051265e+01,		1.911089841851063e+01,		1.921680788814480e+01,		1.932250064074889e+01,
		1.942797734600928e+01,		1.953323867195030e+01,		1.963828528492009e+01,		1.974311784957673e+01,		1.984773702887512e+01,
		1.995214348405401e+01,		2.005633787462362e+01,		2.016032085835371e+01,		2.026409309126199e+01,		2.036765522760302e+01,
		2.047100791985745e+01,		2.057415181872177e+01,		2.067708757309835e+01,		2.077981583008591e+01,		2.088233723497043e+01,
		2.098465243121635e+01,		2.108676206045816e+01,		2.118866676249245e+01,		2.129036717527013e+01,		2.139186393488924e+01,
		2.149315767558787e+01,		2.159424902973756e+01,		2.169513862783703e+01,		2.179582709850613e+01,		2.189631506848027e+01,
		2.199660316260499e+01,		2.209669200383096e+01,		2.219658221320923e+01,		2.229627440988678e+01,		2.239576921110235e+01,
		2.249506723218261e+01,		2.259416908653850e+01,		2.269307538566192e+01,		2.279178673912268e+01,		2.289030375456567e+01,
		2.298862703770836e+01,		2.308675719233839e+01,		2.318469482031161e+01,		2.328244052155020e+01,		2.337999489404110e+01,
		2.347735853383463e+01,		2.357453203504332e+01,		2.367151598984107e+01,		2.376831098846230e+01,		2.386491761920155e+01,
		2.396133646841312e+01,		2.405756812051096e+01,		2.415361315796875e+01,		2.424947216132016e+01,		2.434514570915934e+01,
		2.444063437814149e+01,		2.453593874298369e+01,		2.463105937646588e+01,		2.472599684943199e+01,		2.482075173079121e+01,
		2.491532458751951e+01,		2.500971598466118e+01,		2.510392648533063e+01,		2.519795665071427e+01,		2.529180704007258e+01,
		2.538547821074226e+01,		2.547897071813859e+01,		2.557228511575783e+01,		2.566542195517981e+01,		2.575838178607065e+01,
		2.585116515618555e+01,		2.594377261137173e+01,		2.603620469557146e+01,		2.612846195082527e+01,		2.622054491727515e+01,
		2.6312454