/*
 * Decompiled with CFR 0.152.
 */
package com.bar;

import com.foobar.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.spi.CalendarNameProvider;

public class CalendarNameProviderImpl
extends CalendarNameProvider {
    static final char FULLWIDTH_ZERO = '\uff10';
    static final Locale[] avail = new Locale[]{new Locale("ja", "JP", "kids")};

    @Override
    public String getDisplayName(String string, int n, int n2, int n3, Locale locale) {
        if (string == null || locale == null) {
            throw new NullPointerException();
        }
        if (!Utils.supportsLocale(Arrays.asList(avail), locale)) {
            throw new IllegalArgumentException("locale is not one of available locales: " + locale);
        }
        if (n != 2) {
            return null;
        }
        return CalendarNameProviderImpl.toMonthName(n2 + 1, n3);
    }

    @Override
    public Map<String, Integer> getDisplayNames(String string, int n, int n2, Locale locale) {
        if (string == null || locale == null) {
            throw new NullPointerException();
        }
        if (!Utils.supportsLocale(Arrays.asList(avail), locale)) {
            throw new IllegalArgumentException("locale is not one of available locales: " + locale);
        }
        if (n != 2) {
            return null;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (n2 == 32770) {
            n2 = 2;
        } else if (n2 == 32769) {
            n2 = 1;
        }
        for (int i = 0; i <= 11; ++i) {
            if (n2 == 0 || n2 == 2) {
                hashMap.put(CalendarNameProviderImpl.toMonthName(i + 1, 2), i);
            }
            if (n2 != 0 && n2 != 1) continue;
            hashMap.put(CalendarNameProviderImpl.toMonthName(i + 1, 1), i);
        }
        return hashMap;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return (Locale[])avail.clone();
    }

    public static String toMonthName(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n >= 10) {
            stringBuilder.append('\uff11');
            stringBuilder.appendCodePoint((char)(65296 + n % 10));
        } else {
            stringBuilder.appendCodePoint((char)(65296 + n));
        }
        if (n2 == 1 || n2 == 32769) {
            return stringBuilder.toString();
        }
        stringBuilder.append("\u304c\u3064");
        return stringBuilder.toString();
    }
}

