/* ========================================================================
 * Copyright (c) 2005-2022 The OPC Foundation, Inc. All rights reserved.
 *
 * OPC Foundation MIT License 1.00
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * The complete license agreement can be found here:
 * http://opcfoundation.org/License/MIT/1.00/
 * ======================================================================*/

#ifndef _OpcUa_Identifiers_H_
#define _OpcUa_Identifiers_H_ 1


/*============================================================================
* DataType Identifiers
 *===========================================================================*/
#define OpcUaId_BaseDataType 24
#define OpcUaId_Number 26
#define OpcUaId_Integer 27
#define OpcUaId_UInteger 28
#define OpcUaId_Enumeration 29
#define OpcUaId_Boolean 1
#define OpcUaId_SByte 2
#define OpcUaId_Byte 3
#define OpcUaId_Int16 4
#define OpcUaId_UInt16 5
#define OpcUaId_Int32 6
#define OpcUaId_UInt32 7
#define OpcUaId_Int64 8
#define OpcUaId_UInt64 9
#define OpcUaId_Float 10
#define OpcUaId_Double 11
#define OpcUaId_String 12
#define OpcUaId_DateTime 13
#define OpcUaId_Guid 14
#define OpcUaId_ByteString 15
#define OpcUaId_XmlElement 16
#define OpcUaId_NodeId 17
#define OpcUaId_ExpandedNodeId 18
#define OpcUaId_StatusCode 19
#define OpcUaId_QualifiedName 20
#define OpcUaId_LocalizedText 21
#define OpcUaId_Structure 22
#define OpcUaId_DataValue 23
#define OpcUaId_DiagnosticInfo 25
#define OpcUaId_Image 30
#define OpcUaId_Decimal 50
#define OpcUaId_NamingRuleType 120
#define OpcUaId_ImageBMP 2000
#define OpcUaId_ImageGIF 2001
#define OpcUaId_ImageJPG 2002
#define OpcUaId_ImagePNG 2003
#define OpcUaId_AudioDataType 16307
#define OpcUaId_Union 12756
#define OpcUaId_UriString 23751
#define OpcUaId_BitFieldMaskDataType 11737
#define OpcUaId_SemanticVersionString 24263
#define OpcUaId_KeyValuePair 14533
#define OpcUaId_AdditionalParametersType 16313
#define OpcUaId_EphemeralKeyType 17548
#define OpcUaId_EndpointType 15528
#define OpcUaId_Handle 31917
#define OpcUaId_TrimmedString 31918
#define OpcUaId_RationalNumber 18806
#define OpcUaId_Vector 18807
#define OpcUaId_ThreeDVector 18808
#define OpcUaId_CartesianCoordinates 18809
#define OpcUaId_ThreeDCartesianCoordinates 18810
#define OpcUaId_Orientation 18811
#define OpcUaId_ThreeDOrientation 18812
#define OpcUaId_Frame 18813
#define OpcUaId_ThreeDFrame 18814
#define OpcUaId_OpenFileMode 11939
#define OpcUaId_IdentityCriteriaType 15632
#define OpcUaId_IdentityMappingRuleType 15634
#define OpcUaId_CurrencyUnitType 23498
#define OpcUaId_AlarmMask 32251
#define OpcUaId_TrustListValidationOptions 23564
#define OpcUaId_TrustListMasks 12552
#define OpcUaId_TrustListDataType 12554
#define OpcUaId_TransactionErrorType 32285
#define OpcUaId_DecimalDataType 17861
#define OpcUaId_DataTypeSchemaHeader 15534
#define OpcUaId_DataTypeDescription 14525
#define OpcUaId_StructureDescription 15487
#define OpcUaId_EnumDescription 15488
#define OpcUaId_SimpleTypeDescription 15005
#define OpcUaId_UABinaryFileDataType 15006
#define OpcUaId_PortableQualifiedName 24105
#define OpcUaId_PortableNodeId 24106
#define OpcUaId_UnsignedRationalNumber 24107
#define OpcUaId_PubSubState 14647
#define OpcUaId_DataSetMetaDataType 14523
#define OpcUaId_FieldMetaData 14524
#define OpcUaId_DataSetFieldFlags 15904
#define OpcUaId_ConfigurationVersionDataType 14593
#define OpcUaId_PublishedDataSetDataType 15578
#define OpcUaId_PublishedDataSetSourceDataType 15580
#define OpcUaId_PublishedVariableDataType 14273
#define OpcUaId_PublishedDataItemsDataType 15581
#define OpcUaId_PublishedEventsDataType 15582
#define OpcUaId_PublishedDataSetCustomSourceDataType 25269
#define OpcUaId_DataSetFieldContentMask 15583
#define OpcUaId_DataSetWriterDataType 15597
#define OpcUaId_DataSetWriterTransportDataType 15598
#define OpcUaId_DataSetWriterMessageDataType 15605
#define OpcUaId_PubSubGroupDataType 15609
#define OpcUaId_WriterGroupDataType 15480
#define OpcUaId_WriterGroupTransportDataType 15611
#define OpcUaId_WriterGroupMessageDataType 15616
#define OpcUaId_PubSubConnectionDataType 15617
#define OpcUaId_ConnectionTransportDataType 15618
#define OpcUaId_NetworkAddressDataType 15502
#define OpcUaId_NetworkAddressUrlDataType 15510
#define OpcUaId_ReaderGroupDataType 15520
#define OpcUaId_ReaderGroupTransportDataType 15621
#define OpcUaId_ReaderGroupMessageDataType 15622
#define OpcUaId_DataSetReaderDataType 15623
#define OpcUaId_DataSetReaderTransportDataType 15628
#define OpcUaId_DataSetReaderMessageDataType 15629
#define OpcUaId_SubscribedDataSetDataType 15630
#define OpcUaId_TargetVariablesDataType 15631
#define OpcUaId_FieldTargetDataType 14744
#define OpcUaId_OverrideValueHandling 15874
#define OpcUaId_SubscribedDataSetMirrorDataType 15635
#define OpcUaId_PubSubConfigurationDataType 15530
#define OpcUaId_StandaloneSubscribedDataSetRefDataType 23599
#define OpcUaId_StandaloneSubscribedDataSetDataType 23600
#define OpcUaId_SecurityGroupDataType 23601
#define OpcUaId_PubSubKeyPushTargetDataType 25270
#define OpcUaId_PubSubConfiguration2DataType 23602
#define OpcUaId_DataSetOrderingType 20408
#define OpcUaId_UadpNetworkMessageContentMask 15642
#define OpcUaId_UadpWriterGroupMessageDataType 15645
#define OpcUaId_UadpDataSetMessageContentMask 15646
#define OpcUaId_UadpDataSetWriterMessageDataType 15652
#define OpcUaId_UadpDataSetReaderMessageDataType 15653
#define OpcUaId_JsonNetworkMessageContentMask 15654
#define OpcUaId_JsonWriterGroupMessageDataType 15657
#define OpcUaId_JsonDataSetMessageContentMask 15658
#define OpcUaId_JsonDataSetWriterMessageDataType 15664
#define OpcUaId_JsonDataSetReaderMessageDataType 15665
#define OpcUaId_QosDataType 23603
#define OpcUaId_TransmitQosDataType 23604
#define OpcUaId_TransmitQosPriorityDataType 23605
#define OpcUaId_ReceiveQosDataType 23608
#define OpcUaId_ReceiveQosPriorityDataType 23609
#define OpcUaId_DatagramConnectionTransportDataType 17467
#define OpcUaId_DatagramConnectionTransport2DataType 23612
#define OpcUaId_DatagramWriterGroupTransportDataType 15532
#define OpcUaId_DatagramWriterGroupTransport2DataType 23613
#define OpcUaId_DatagramDataSetReaderTransportDataType 23614
#define OpcUaId_BrokerConnectionTransportDataType 15007
#define OpcUaId_BrokerTransportQualityOfService 15008
#define OpcUaId_BrokerWriterGroupTransportDataType 15667
#define OpcUaId_BrokerDataSetWriterTransportDataType 15669
#define OpcUaId_BrokerDataSetReaderTransportDataType 15670
#define OpcUaId_PubSubConfigurationRefMask 25517
#define OpcUaId_PubSubConfigurationRefDataType 25519
#define OpcUaId_PubSubConfigurationValueDataType 25520
#define OpcUaId_DiagnosticsLevel 19723
#define OpcUaId_PubSubDiagnosticsCounterClassification 19730
#define OpcUaId_AliasNameDataType 23468
#define OpcUaId_PasswordOptionsMask 24277
#define OpcUaId_UserConfigurationMask 24279
#define OpcUaId_UserManagementDataType 24281
#define OpcUaId_EncodedTicket 25726
#define OpcUaId_Duplex 24210
#define OpcUaId_InterfaceAdminStatus 24212
#define OpcUaId_InterfaceOperStatus 24214
#define OpcUaId_NegotiationStatus 24216
#define OpcUaId_TsnFailureCode 24218
#define OpcUaId_TsnStreamState 24220
#define OpcUaId_TsnTalkerStatus 24222
#define OpcUaId_TsnListenerStatus 24224
#define OpcUaId_PriorityMappingEntryType 25220
#define OpcUaId_ReferenceDescriptionDataType 32659
#define OpcUaId_ReferenceListEntryDataType 32660
#define OpcUaId_IdType 256
#define OpcUaId_NodeClass 257
#define OpcUaId_PermissionType 94
#define OpcUaId_AccessLevelType 15031
#define OpcUaId_AccessLevelExType 15406
#define OpcUaId_EventNotifierType 15033
#define OpcUaId_AccessRestrictionType 95
#define OpcUaId_RolePermissionType 96
#define OpcUaId_DataTypeDefinition 97
#define OpcUaId_StructureType 98
#define OpcUaId_StructureField 101
#define OpcUaId_StructureDefinition 99
#define OpcUaId_EnumDefinition 100
#define OpcUaId_Node 258
#define OpcUaId_InstanceNode 11879
#define OpcUaId_TypeNode 11880
#define OpcUaId_ObjectNode 261
#define OpcUaId_ObjectTypeNode 264
#define OpcUaId_VariableNode 267
#define OpcUaId_VariableTypeNode 270
#define OpcUaId_ReferenceTypeNode 273
#define OpcUaId_MethodNode 276
#define OpcUaId_ViewNode 279
#define OpcUaId_DataTypeNode 282
#define OpcUaId_ReferenceNode 285
#define OpcUaId_Argument 296
#define OpcUaId_EnumValueType 7594
#define OpcUaId_EnumField 102
#define OpcUaId_OptionSet 12755
#define OpcUaId_NormalizedString 12877
#define OpcUaId_DecimalString 12878
#define OpcUaId_DurationString 12879
#define OpcUaId_TimeString 12880
#define OpcUaId_DateString 12881
#define OpcUaId_Duration 290
#define OpcUaId_UtcTime 294
#define OpcUaId_LocaleId 295
#define OpcUaId_TimeZoneDataType 8912
#define OpcUaId_Index 17588
#define OpcUaId_IntegerId 288
#define OpcUaId_ApplicationType 307
#define OpcUaId_ApplicationDescription 308
#define OpcUaId_RequestHeader 389
#define OpcUaId_ResponseHeader 392
#define OpcUaId_VersionTime 20998
#define OpcUaId_ServiceFault 395
#define OpcUaId_SessionlessInvokeRequestType 15901
#define OpcUaId_SessionlessInvokeResponseType 20999
#define OpcUaId_FindServersRequest 420
#define OpcUaId_FindServersResponse 423
#define OpcUaId_ServerOnNetwork 12189
#define OpcUaId_FindServersOnNetworkRequest 12190
#define OpcUaId_FindServersOnNetworkResponse 12191
#define OpcUaId_ApplicationInstanceCertificate 311
#define OpcUaId_MessageSecurityMode 302
#define OpcUaId_UserTokenType 303
#define OpcUaId_UserTokenPolicy 304
#define OpcUaId_EndpointDescription 312
#define OpcUaId_GetEndpointsRequest 426
#define OpcUaId_GetEndpointsResponse 429
#define OpcUaId_RegisteredServer 432
#define OpcUaId_RegisterServerRequest 435
#define OpcUaId_RegisterServerResponse 438
#define OpcUaId_DiscoveryConfiguration 12890
#define OpcUaId_MdnsDiscoveryConfiguration 12891
#define OpcUaId_RegisterServer2Request 12193
#define OpcUaId_RegisterServer2Response 12194
#define OpcUaId_SecurityTokenRequestType 315
#define OpcUaId_ChannelSecurityToken 441
#define OpcUaId_OpenSecureChannelRequest 444
#define OpcUaId_OpenSecureChannelResponse 447
#define OpcUaId_CloseSecureChannelRequest 450
#define OpcUaId_CloseSecureChannelResponse 453
#define OpcUaId_SignedSoftwareCertificate 344
#define OpcUaId_SessionAuthenticationToken 388
#define OpcUaId_SignatureData 456
#define OpcUaId_CreateSessionRequest 459
#define OpcUaId_CreateSessionResponse 462
#define OpcUaId_UserIdentityToken 316
#define OpcUaId_AnonymousIdentityToken 319
#define OpcUaId_UserNameIdentityToken 322
#define OpcUaId_X509IdentityToken 325
#define OpcUaId_IssuedIdentityToken 938
#define OpcUaId_RsaEncryptedSecret 17545
#define OpcUaId_EccEncryptedSecret 17546
#define OpcUaId_ActivateSessionRequest 465
#define OpcUaId_ActivateSessionResponse 468
#define OpcUaId_CloseSessionRequest 471
#define OpcUaId_CloseSessionResponse 474
#define OpcUaId_CancelRequest 477
#define OpcUaId_CancelResponse 480
#define OpcUaId_NodeAttributesMask 348
#define OpcUaId_NodeAttributes 349
#define OpcUaId_ObjectAttributes 352
#define OpcUaId_VariableAttributes 355
#define OpcUaId_MethodAttributes 358
#define OpcUaId_ObjectTypeAttributes 361
#define OpcUaId_VariableTypeAttributes 364
#define OpcUaId_ReferenceTypeAttributes 367
#define OpcUaId_DataTypeAttributes 370
#define OpcUaId_ViewAttributes 373
#define OpcUaId_GenericAttributeValue 17606
#define OpcUaId_GenericAttributes 17607
#define OpcUaId_AddNodesItem 376
#define OpcUaId_AddNodesResult 483
#define OpcUaId_AddNodesRequest 486
#define OpcUaId_AddNodesResponse 489
#define OpcUaId_AddReferencesItem 379
#define OpcUaId_AddReferencesRequest 492
#define OpcUaId_AddReferencesResponse 495
#define OpcUaId_DeleteNodesItem 382
#define OpcUaId_DeleteNodesRequest 498
#define OpcUaId_DeleteNodesResponse 501
#define OpcUaId_DeleteReferencesItem 385
#define OpcUaId_DeleteReferencesRequest 504
#define OpcUaId_DeleteReferencesResponse 507
#define OpcUaId_AttributeWriteMask 347
#define OpcUaId_BrowseDirection 510
#define OpcUaId_ViewDescription 511
#define OpcUaId_BrowseDescription 514
#define OpcUaId_BrowseResultMask 517
#define OpcUaId_ReferenceDescription 518
#define OpcUaId_ContinuationPoint 521
#define OpcUaId_BrowseResult 522
#define OpcUaId_BrowseRequest 525
#define OpcUaId_BrowseResponse 528
#define OpcUaId_BrowseNextRequest 531
#define OpcUaId_BrowseNextResponse 534
#define OpcUaId_RelativePathElement 537
#define OpcUaId_RelativePath 540
#define OpcUaId_BrowsePath 543
#define OpcUaId_BrowsePathTarget 546
#define OpcUaId_BrowsePathResult 549
#define OpcUaId_TranslateBrowsePathsToNodeIdsRequest 552
#define OpcUaId_TranslateBrowsePathsToNodeIdsResponse 555
#define OpcUaId_RegisterNodesRequest 558
#define OpcUaId_RegisterNodesResponse 561
#define OpcUaId_UnregisterNodesRequest 564
#define OpcUaId_UnregisterNodesResponse 567
#define OpcUaId_Counter 289
#define OpcUaId_NumericRange 291
#define OpcUaId_EndpointConfiguration 331
#define OpcUaId_QueryDataDescription 570
#define OpcUaId_NodeTypeDescription 573
#define OpcUaId_FilterOperator 576
#define OpcUaId_QueryDataSet 577
#define OpcUaId_NodeReference 580
#define OpcUaId_ContentFilterElement 583
#define OpcUaId_ContentFilter 586
#define OpcUaId_FilterOperand 589
#define OpcUaId_ElementOperand 592
#define OpcUaId_LiteralOperand 595
#define OpcUaId_AttributeOperand 598
#define OpcUaId_SimpleAttributeOperand 601
#define OpcUaId_ContentFilterElementResult 604
#define OpcUaId_ContentFilterResult 607
#define OpcUaId_ParsingResult 610
#define OpcUaId_QueryFirstRequest 613
#define OpcUaId_QueryFirstResponse 616
#define OpcUaId_QueryNextRequest 619
#define OpcUaId_QueryNextResponse 622
#define OpcUaId_TimestampsToReturn 625
#define OpcUaId_ReadValueId 626
#define OpcUaId_ReadRequest 629
#define OpcUaId_ReadResponse 632
#define OpcUaId_HistoryReadValueId 635
#define OpcUaId_HistoryReadResult 638
#define OpcUaId_HistoryReadDetails 641
#define OpcUaId_ReadEventDetails 644
#define OpcUaId_ReadRawModifiedDetails 647
#define OpcUaId_ReadProcessedDetails 650
#define OpcUaId_ReadAtTimeDetails 653
#define OpcUaId_ReadAnnotationDataDetails 23497
#define OpcUaId_HistoryData 656
#define OpcUaId_ModificationInfo 11216
#define OpcUaId_HistoryModifiedData 11217
#define OpcUaId_HistoryEvent 659
#define OpcUaId_HistoryReadRequest 662
#define OpcUaId_HistoryReadResponse 665
#define OpcUaId_WriteValue 668
#define OpcUaId_WriteRequest 671
#define OpcUaId_WriteResponse 674
#define OpcUaId_HistoryUpdateDetails 677
#define OpcUaId_HistoryUpdateType 11234
#define OpcUaId_PerformUpdateType 11293
#define OpcUaId_UpdateDataDetails 680
#define OpcUaId_UpdateStructureDataDetails 11295
#define OpcUaId_UpdateEventDetails 683
#define OpcUaId_DeleteRawModifiedDetails 686
#define OpcUaId_DeleteAtTimeDetails 689
#define OpcUaId_DeleteEventDetails 692
#define OpcUaId_HistoryUpdateResult 695
#define OpcUaId_HistoryUpdateRequest 698
#define OpcUaId_HistoryUpdateResponse 701
#define OpcUaId_CallMethodRequest 704
#define OpcUaId_CallMethodResult 707
#define OpcUaId_CallRequest 710
#define OpcUaId_CallResponse 713
#define OpcUaId_MonitoringMode 716
#define OpcUaId_DataChangeTrigger 717
#define OpcUaId_DeadbandType 718
#define OpcUaId_MonitoringFilter 719
#define OpcUaId_DataChangeFilter 722
#define OpcUaId_EventFilter 725
#define OpcUaId_AggregateConfiguration 948
#define OpcUaId_AggregateFilter 728
#define OpcUaId_MonitoringFilterResult 731
#define OpcUaId_EventFilterResult 734
#define OpcUaId_AggregateFilterResult 737
#define OpcUaId_MonitoringParameters 740
#define OpcUaId_MonitoredItemCreateRequest 743
#define OpcUaId_MonitoredItemCreateResult 746
#define OpcUaId_CreateMonitoredItemsRequest 749
#define OpcUaId_CreateMonitoredItemsResponse 752
#define OpcUaId_MonitoredItemModifyRequest 755
#define OpcUaId_MonitoredItemModifyResult 758
#define OpcUaId_ModifyMonitoredItemsRequest 761
#define OpcUaId_ModifyMonitoredItemsResponse 764
#define OpcUaId_SetMonitoringModeRequest 767
#define OpcUaId_SetMonitoringModeResponse 770
#define OpcUaId_SetTriggeringRequest 773
#define OpcUaId_SetTriggeringResponse 776
#define OpcUaId_DeleteMonitoredItemsRequest 779
#define OpcUaId_DeleteMonitoredItemsResponse 782
#define OpcUaId_CreateSubscriptionRequest 785
#define OpcUaId_CreateSubscriptionResponse 788
#define OpcUaId_ModifySubscriptionRequest 791
#define OpcUaId_ModifySubscriptionResponse 794
#define OpcUaId_SetPublishingModeRequest 797
#define OpcUaId_SetPublishingModeResponse 800
#define OpcUaId_NotificationMessage 803
#define OpcUaId_NotificationData 945
#define OpcUaId_DataChangeNotification 809
#define OpcUaId_MonitoredItemNotification 806
#define OpcUaId_EventNotificationList 914
#define OpcUaId_EventFieldList 917
#define OpcUaId_HistoryEventFieldList 920
#define OpcUaId_StatusChangeNotification 818
#define OpcUaId_SubscriptionAcknowledgement 821
#define OpcUaId_PublishRequest 824
#define OpcUaId_PublishResponse 827
#define OpcUaId_RepublishRequest 830
#define OpcUaId_RepublishResponse 833
#define OpcUaId_TransferResult 836
#define OpcUaId_TransferSubscriptionsRequest 839
#define OpcUaId_TransferSubscriptionsResponse 842
#define OpcUaId_DeleteSubscriptionsRequest 845
#define OpcUaId_DeleteSubscriptionsResponse 848
#define OpcUaId_BuildInfo 338
#define OpcUaId_RedundancySupport 851
#define OpcUaId_ServerState 852
#define OpcUaId_RedundantServerDataType 853
#define OpcUaId_EndpointUrlListDataType 11943
#define OpcUaId_NetworkGroupDataType 11944
#define OpcUaId_SamplingIntervalDiagnosticsDataType 856
#define OpcUaId_ServerDiagnosticsSummaryDataType 859
#define OpcUaId_ServerStatusDataType 862
#define OpcUaId_SessionDiagnosticsDataType 865
#define OpcUaId_SessionSecurityDiagnosticsDataType 868
#define OpcUaId_ServiceCounterDataType 871
#define OpcUaId_StatusResult 299
#define OpcUaId_SubscriptionDiagnosticsDataType 874
#define OpcUaId_ModelChangeStructureVerbMask 11941
#define OpcUaId_ModelChangeStructureDataType 877
#define OpcUaId_SemanticChangeStructureDataType 897
#define OpcUaId_Range 884
#define OpcUaId_EUInformation 887
#define OpcUaId_AxisScaleEnumeration 12077
#define OpcUaId_ComplexNumberType 12171
#define OpcUaId_DoubleComplexNumberType 12172
#define OpcUaId_AxisInformation 12079
#define OpcUaId_XVType 12080
#define OpcUaId_ProgramDiagnosticDataType 894
#define OpcUaId_ProgramDiagnostic2DataType 24033
#define OpcUaId_Annotation 891
#define OpcUaId_ExceptionDeviationFormat 890

/*============================================================================
* Method Identifiers
 *===========================================================================*/
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_Open 15971
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_Close 15974
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_Read 15976
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_Write 15979
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_GetPosition 15981
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_SetPosition 15984
#define OpcUaId_ServerType_ServerCapabilities_RoleSet_AddRole 16290
#define OpcUaId_ServerType_ServerCapabilities_RoleSet_RemoveRole 16293
#define OpcUaId_ServerType_GetMonitoredItems 11489
#define OpcUaId_ServerType_ResendData 12871
#define OpcUaId_ServerType_SetSubscriptionDurable 12746
#define OpcUaId_ServerType_RequestServerStateChange 12883
#define OpcUaId_ServerCapabilitiesType_RoleSet_AddRole 16296
#define OpcUaId_ServerCapabilitiesType_RoleSet_RemoveRole 16299
#define OpcUaId_FileType_Open 11580
#define OpcUaId_FileType_Close 11583
#define OpcUaId_FileType_Read 11585
#define OpcUaId_FileType_Write 11588
#define OpcUaId_FileType_GetPosition 11590
#define OpcUaId_FileType_SetPosition 11593
#define OpcUaId_AddressSpaceFileType_ExportNamespace 11615
#define OpcUaId_NamespaceMetadataType_NamespaceFile_Open 11629
#define OpcUaId_NamespaceMetadataType_NamespaceFile_Close 11632
#define OpcUaId_NamespaceMetadataType_NamespaceFile_Read 11634
#define OpcUaId_NamespaceMetadataType_NamespaceFile_Write 11637
#define OpcUaId_NamespaceMetadataType_NamespaceFile_GetPosition 11639
#define OpcUaId_NamespaceMetadataType_NamespaceFile_SetPosition 11642
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open 11659
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close 11662
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read 11664
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write 11667
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition 11669
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition 11672
#define OpcUaId_Server_ServerCapabilities_RoleSet_AddRole 16301
#define OpcUaId_Server_ServerCapabilities_RoleSet_RemoveRole 16304
#define OpcUaId_Server_GetMonitoredItems 11492
#define OpcUaId_Server_ResendData 12873
#define OpcUaId_Server_SetSubscriptionDurable 12749
#define OpcUaId_Server_RequestServerStateChange 12886
#define OpcUaId_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory 13355
#define OpcUaId_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile 13358
#define OpcUaId_FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject 17718
#define OpcUaId_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy 13363
#define OpcUaId_FileDirectoryType_FileName_Placeholder_Open 13372
#define OpcUaId_FileDirectoryType_FileName_Placeholder_Close 13375
#define OpcUaId_FileDirectoryType_FileName_Placeholder_Read 13377
#define OpcUaId_FileDirectoryType_FileName_Placeholder_Write 13380
#define OpcUaId_FileDirectoryType_FileName_Placeholder_GetPosition 13382
#define OpcUaId_FileDirectoryType_FileName_Placeholder_SetPosition 13385
#define OpcUaId_FileDirectoryType_CreateDirectory 13387
#define OpcUaId_FileDirectoryType_CreateFile 13390
#define OpcUaId_FileDirectoryType_DeleteFileSystemObject 13393
#define OpcUaId_FileDirectoryType_MoveOrCopy 13395
#define OpcUaId_FileSystem_FileDirectoryName_Placeholder_CreateDirectory 16316
#define OpcUaId_FileSystem_FileDirectoryName_Placeholder_CreateFile 16319
#define OpcUaId_FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject 17722
#define OpcUaId_FileSystem_FileDirectoryName_Placeholder_MoveOrCopy 16324
#define OpcUaId_FileSystem_FileName_Placeholder_Open 16333
#define OpcUaId_FileSystem_FileName_Placeholder_Close 16336
#define OpcUaId_FileSystem_FileName_Placeholder_Read 16338
#define OpcUaId_FileSystem_FileName_Placeholder_Write 16341
#define OpcUaId_FileSystem_FileName_Placeholder_GetPosition 16343
#define OpcUaId_FileSystem_FileName_Placeholder_SetPosition 16346
#define OpcUaId_FileSystem_CreateDirectory 16348
#define OpcUaId_FileSystem_CreateFile 16351
#define OpcUaId_FileSystem_DeleteFileSystemObject 16354
#define OpcUaId_FileSystem_MoveOrCopy 16356
#define OpcUaId_TemporaryFileTransferType_GenerateFileForRead 15746
#define OpcUaId_TemporaryFileTransferType_GenerateFileForWrite 15749
#define OpcUaId_TemporaryFileTransferType_CloseAndCommit 15751
#define OpcUaId_TemporaryFileTransferType_TransferState_Placeholder_Reset 15794
#define OpcUaId_FileTransferStateMachineType_Reset 15843
#define OpcUaId_RoleSetType_AddRole 15997
#define OpcUaId_RoleSetType_RemoveRole 16000
#define OpcUaId_RoleType_AddIdentity 15624
#define OpcUaId_RoleType_RemoveIdentity 15626
#define OpcUaId_RoleType_AddApplication 16176
#define OpcUaId_RoleType_RemoveApplication 16178
#define OpcUaId_RoleType_AddEndpoint 16180
#define OpcUaId_RoleType_RemoveEndpoint 16182
#define OpcUaId_WellKnownRole_Anonymous_AddIdentity 15648
#define OpcUaId_WellKnownRole_Anonymous_RemoveIdentity 15650
#define OpcUaId_WellKnownRole_Anonymous_AddApplication 16195
#define OpcUaId_WellKnownRole_Anonymous_RemoveApplication 16197
#define OpcUaId_WellKnownRole_Anonymous_AddEndpoint 16199
#define OpcUaId_WellKnownRole_Anonymous_RemoveEndpoint 16201
#define OpcUaId_WellKnownRole_AuthenticatedUser_AddIdentity 15660
#define OpcUaId_WellKnownRole_AuthenticatedUser_RemoveIdentity 15662
#define OpcUaId_WellKnownRole_AuthenticatedUser_AddApplication 16206
#define OpcUaId_WellKnownRole_AuthenticatedUser_RemoveApplication 16208
#define OpcUaId_WellKnownRole_AuthenticatedUser_AddEndpoint 16210
#define OpcUaId_WellKnownRole_AuthenticatedUser_RemoveEndpoint 16212
#define OpcUaId_WellKnownRole_Observer_AddIdentity 15672
#define OpcUaId_WellKnownRole_Observer_RemoveIdentity 15674
#define OpcUaId_WellKnownRole_Observer_AddApplication 16217
#define OpcUaId_WellKnownRole_Observer_RemoveApplication 16219
#define OpcUaId_WellKnownRole_Observer_AddEndpoint 16221
#define OpcUaId_WellKnownRole_Observer_RemoveEndpoint 16223
#define OpcUaId_WellKnownRole_Operator_AddIdentity 15684
#define OpcUaId_WellKnownRole_Operator_RemoveIdentity 15686
#define OpcUaId_WellKnownRole_Operator_AddApplication 16228
#define OpcUaId_WellKnownRole_Operator_RemoveApplication 16230
#define OpcUaId_WellKnownRole_Operator_AddEndpoint 16232
#define OpcUaId_WellKnownRole_Operator_RemoveEndpoint 16234
#define OpcUaId_WellKnownRole_Engineer_AddIdentity 16041
#define OpcUaId_WellKnownRole_Engineer_RemoveIdentity 16043
#define OpcUaId_WellKnownRole_Engineer_AddApplication 16239
#define OpcUaId_WellKnownRole_Engineer_RemoveApplication 16241
#define OpcUaId_WellKnownRole_Engineer_AddEndpoint 16243
#define OpcUaId_WellKnownRole_Engineer_RemoveEndpoint 16245
#define OpcUaId_WellKnownRole_Supervisor_AddIdentity 15696
#define OpcUaId_WellKnownRole_Supervisor_RemoveIdentity 15698
#define OpcUaId_WellKnownRole_Supervisor_AddApplication 16250
#define OpcUaId_WellKnownRole_Supervisor_RemoveApplication 16252
#define OpcUaId_WellKnownRole_Supervisor_AddEndpoint 16254
#define OpcUaId_WellKnownRole_Supervisor_RemoveEndpoint 16256
#define OpcUaId_WellKnownRole_ConfigureAdmin_AddIdentity 15720
#define OpcUaId_WellKnownRole_ConfigureAdmin_RemoveIdentity 15722
#define OpcUaId_WellKnownRole_ConfigureAdmin_AddApplication 16272
#define OpcUaId_WellKnownRole_ConfigureAdmin_RemoveApplication 16274
#define OpcUaId_WellKnownRole_ConfigureAdmin_AddEndpoint 16276
#define OpcUaId_WellKnownRole_ConfigureAdmin_RemoveEndpoint 16278
#define OpcUaId_WellKnownRole_SecurityAdmin_AddIdentity 15708
#define OpcUaId_WellKnownRole_SecurityAdmin_RemoveIdentity 15710
#define OpcUaId_WellKnownRole_SecurityAdmin_AddApplication 16261
#define OpcUaId_WellKnownRole_SecurityAdmin_RemoveApplication 16263
#define OpcUaId_WellKnownRole_SecurityAdmin_AddEndpoint 16265
#define OpcUaId_WellKnownRole_SecurityAdmin_RemoveEndpoint 16267
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_AddIdentity 25572
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity 25574
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_AddApplication 25576
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_RemoveApplication 25578
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_AddEndpoint 25580
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint 25582
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_AddIdentity 25610
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_RemoveIdentity 25612
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_AddApplication 25614
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_RemoveApplication 25616
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_AddEndpoint 25618
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint 25620
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_AddIdentity 25591
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_RemoveIdentity 25593
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_AddApplication 25595
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_RemoveApplication 25597
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_AddEndpoint 25599
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_RemoveEndpoint 25601
#define OpcUaId_ConditionType_Disable 9028
#define OpcUaId_ConditionType_Enable 9027
#define OpcUaId_ConditionType_AddComment 9029
#define OpcUaId_ConditionType_ConditionRefresh 3875
#define OpcUaId_ConditionType_ConditionRefresh2 12912
#define OpcUaId_DialogConditionType_Respond 9069
#define OpcUaId_DialogConditionType_Respond2 24312
#define OpcUaId_AcknowledgeableConditionType_Acknowledge 9111
#define OpcUaId_AcknowledgeableConditionType_Confirm 9113
#define OpcUaId_AlarmConditionType_ShelvingState_TimedShelve 9213
#define OpcUaId_AlarmConditionType_ShelvingState_Unshelve 9211
#define OpcUaId_AlarmConditionType_ShelvingState_OneShotShelve 9212
#define OpcUaId_AlarmConditionType_Silence 16402
#define OpcUaId_AlarmConditionType_Suppress 16403
#define OpcUaId_AlarmConditionType_Suppress2 24316
#define OpcUaId_AlarmConditionType_Unsuppress 17868
#define OpcUaId_AlarmConditionType_Unsuppress2 24318
#define OpcUaId_AlarmConditionType_RemoveFromService 17869
#define OpcUaId_AlarmConditionType_RemoveFromService2 24320
#define OpcUaId_AlarmConditionType_PlaceInService 17870
#define OpcUaId_AlarmConditionType_PlaceInService2 24322
#define OpcUaId_AlarmConditionType_Reset 18199
#define OpcUaId_AlarmConditionType_Reset2 24324
#define OpcUaId_AlarmConditionType_GetGroupMemberships 24744
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_Disable 16439
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_Enable 16440
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment 16441
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge 16461
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve 16517
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve 16515
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve 16516
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Disable 32098
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Enable 32099
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AddComment 32100
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Acknowledge 32120
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve 32167
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve 32171
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve 32174
#define OpcUaId_ShelvedStateMachineType_TimedShelve 2949
#define OpcUaId_ShelvedStateMachineType_TimedShelve2 24756
#define OpcUaId_ShelvedStateMachineType_Unshelve 2947
#define OpcUaId_ShelvedStateMachineType_Unshelve2 24758
#define OpcUaId_ShelvedStateMachineType_OneShotShelve 2948
#define OpcUaId_ShelvedStateMachineType_OneShotShelve2 24760
#define OpcUaId_LimitAlarmType_ShelvingState_TimedShelve 9314
#define OpcUaId_LimitAlarmType_ShelvingState_Unshelve 9312
#define OpcUaId_LimitAlarmType_ShelvingState_OneShotShelve 9313
#define OpcUaId_ExclusiveLimitAlarmType_ShelvingState_TimedShelve 9451
#define OpcUaId_ExclusiveLimitAlarmType_ShelvingState_Unshelve 9449
#define OpcUaId_ExclusiveLimitAlarmType_ShelvingState_OneShotShelve 9450
#define OpcUaId_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve 10016
#define OpcUaId_NonExclusiveLimitAlarmType_ShelvingState_Unshelve 10014
#define OpcUaId_NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve 10015
#define OpcUaId_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve 10170
#define OpcUaId_NonExclusiveLevelAlarmType_ShelvingState_Unshelve 10168
#define OpcUaId_NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve 10169
#define OpcUaId_ExclusiveLevelAlarmType_ShelvingState_TimedShelve 9592
#define OpcUaId_ExclusiveLevelAlarmType_ShelvingState_Unshelve 9590
#define OpcUaId_ExclusiveLevelAlarmType_ShelvingState_OneShotShelve 9591
#define OpcUaId_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve 10478
#define OpcUaId_NonExclusiveDeviationAlarmType_ShelvingState_Unshelve 10476
#define OpcUaId_NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve 10477
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve 10324
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve 10322
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve 10323
#define OpcUaId_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve 9874
#define OpcUaId_ExclusiveDeviationAlarmType_ShelvingState_Unshelve 9872
#define OpcUaId_ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve 9873
#define OpcUaId_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve 9733
#define OpcUaId_ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve 9731
#define OpcUaId_ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve 9732
#define OpcUaId_DiscreteAlarmType_ShelvingState_TimedShelve 10633
#define OpcUaId_DiscreteAlarmType_ShelvingState_Unshelve 10631
#define OpcUaId_DiscreteAlarmType_ShelvingState_OneShotShelve 10632
#define OpcUaId_OffNormalAlarmType_ShelvingState_TimedShelve 10747
#define OpcUaId_OffNormalAlarmType_ShelvingState_Unshelve 10745
#define OpcUaId_OffNormalAlarmType_ShelvingState_OneShotShelve 10746
#define OpcUaId_SystemOffNormalAlarmType_ShelvingState_TimedShelve 11846
#define OpcUaId_SystemOffNormalAlarmType_ShelvingState_Unshelve 11844
#define OpcUaId_SystemOffNormalAlarmType_ShelvingState_OneShotShelve 11845
#define OpcUaId_TripAlarmType_ShelvingState_TimedShelve 10861
#define OpcUaId_TripAlarmType_ShelvingState_Unshelve 10859
#define OpcUaId_TripAlarmType_ShelvingState_OneShotShelve 10860
#define OpcUaId_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve 18453
#define OpcUaId_InstrumentDiagnosticAlarmType_ShelvingState_Unshelve 18455
#define OpcUaId_InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve 18456
#define OpcUaId_SystemDiagnosticAlarmType_ShelvingState_TimedShelve 18602
#define OpcUaId_SystemDiagnosticAlarmType_ShelvingState_Unshelve 18604
#define OpcUaId_SystemDiagnosticAlarmType_ShelvingState_OneShotShelve 18605
#define OpcUaId_CertificateExpirationAlarmType_ShelvingState_TimedShelve 13320
#define OpcUaId_CertificateExpirationAlarmType_ShelvingState_Unshelve 13318
#define OpcUaId_CertificateExpirationAlarmType_ShelvingState_OneShotShelve 13319
#define OpcUaId_DiscrepancyAlarmType_ShelvingState_TimedShelve 17195
#define OpcUaId_DiscrepancyAlarmType_ShelvingState_Unshelve 17193
#define OpcUaId_DiscrepancyAlarmType_ShelvingState_OneShotShelve 17194
#define OpcUaId_AlarmMetricsType_Reset 18666
#define OpcUaId_ProgramStateMachineType_Start 2426
#define OpcUaId_ProgramStateMachineType_Suspend 2427
#define OpcUaId_ProgramStateMachineType_Resume 2428
#define OpcUaId_ProgramStateMachineType_Halt 2429
#define OpcUaId_ProgramStateMachineType_Reset 2430
#define OpcUaId_TrustListType_OpenWithMasks 12543
#define OpcUaId_TrustListType_CloseAndUpdate 12546
#define OpcUaId_TrustListType_AddCertificate 12548
#define OpcUaId_TrustListType_RemoveCertificate 12550
#define OpcUaId_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve 19403
#define OpcUaId_TrustListOutOfDateAlarmType_ShelvingState_Unshelve 19405
#define OpcUaId_TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve 19406
#define OpcUaId_CertificateGroupType_TrustList_Open 13605
#define OpcUaId_CertificateGroupType_TrustList_Close 13608
#define OpcUaId_CertificateGroupType_TrustList_Read 13610
#define OpcUaId_CertificateGroupType_TrustList_Write 13613
#define OpcUaId_CertificateGroupType_TrustList_GetPosition 13615
#define OpcUaId_CertificateGroupType_TrustList_SetPosition 13618
#define OpcUaId_CertificateGroupType_TrustList_OpenWithMasks 13621
#define OpcUaId_CertificateGroupType_TrustList_CloseAndUpdate 13624
#define OpcUaId_CertificateGroupType_TrustList_AddCertificate 13627
#define OpcUaId_CertificateGroupType_TrustList_RemoveCertificate 13629
#define OpcUaId_CertificateGroupType_GetRejectedList 23526
#define OpcUaId_CertificateGroupType_CertificateExpired_Disable 19483
#define OpcUaId_CertificateGroupType_CertificateExpired_Enable 19484
#define OpcUaId_CertificateGroupType_CertificateExpired_AddComment 19485
#define OpcUaId_CertificateGroupType_CertificateExpired_Acknowledge 19505
#define OpcUaId_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve 20097
#define OpcUaId_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve 20099
#define OpcUaId_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve 20100
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_Disable 20176
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_Enable 20177
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_AddComment 20178
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_Acknowledge 20198
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve 20245
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve 20247
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve 20248
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open 13821
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close 13824
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read 13826
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write 13829
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition 13831
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition 13834
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks 13837
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate 13840
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate 13843
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate 13845
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Disable 20324
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Enable 20325
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment 20326
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge 20346
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve 20393
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve 20395
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve 20396
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Disable 20474
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Enable 20475
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment 20476
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge 20496
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve 20543
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve 20545
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 20546
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open 13855
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close 13858
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read 13860
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write 13863
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition 13865
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition 13868
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks 13871
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate 13874
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate 13877
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate 13879
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Disable 20622
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Enable 20623
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment 20624
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge 20644
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve 20691
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve 20693
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve 20694
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Disable 20770
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Enable 20771
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment 20772
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge 20792
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve 20839
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve 20841
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 20842
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open 13889
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close 13892
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read 13894
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write 13897
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition 13899
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition 13902
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks 13905
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate 13908
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate 13911
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate 13913
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Disable 20918
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Enable 20919
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment 20920
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge 20940
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve 20987
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve 20989
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve 20990
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Disable 21269
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Enable 21270
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment 21271
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge 21291
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve 21338
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve 21340
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 21341
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open 13923
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close 13926
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read 13928
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write 13931
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition 13933
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition 13936
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks 13939
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate 13942
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate 13945
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate 13947
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Disable 21417
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Enable 21418
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment 21419
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge 21439
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve 21486
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve 21488
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve 21489
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Disable 21565
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Enable 21566
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment 21567
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge 21587
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve 21634
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve 21636
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve 21637
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open 13958
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close 13961
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read 13963
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write 13966
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition 13968
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition 13971
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks 13974
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate 13977
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate 13980
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate 13982
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable 21713
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable 21714
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment 21715
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge 21735
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve 21782
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve 21784
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve 21785
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable 21861
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable 21862
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment 21863
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge 21883
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve 21930
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve 21932
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 21933
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open 13992
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close 13995
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read 13997
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write 14000
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition 14002
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition 14005
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks 14008
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate 14011
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate 14014
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate 14016
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable 22009
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable 22010
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment 22011
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge 22031
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve 22078
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve 22080
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve 22081
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable 22157
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable 22158
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment 22159
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge 22179
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve 22226
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve 22228
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 22229
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open 14026
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close 14029
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read 14031
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write 14034
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition 14036
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition 14039
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks 14042
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate 14045
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate 14048
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate 14050
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable 22305
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable 22306
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment 22307
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge 22327
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve 22374
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve 22376
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve 22377
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable 22453
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable 22454
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment 22455
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge 22475
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve 22522
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve 22524
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 22525
#define OpcUaId_ServerConfigurationType_UpdateCertificate 12616
#define OpcUaId_ServerConfigurationType_GetCertificates 32296
#define OpcUaId_ServerConfigurationType_ApplyChanges 12734
#define OpcUaId_ServerConfigurationType_CancelChanges 25698
#define OpcUaId_ServerConfigurationType_CreateSigningRequest 12731
#define OpcUaId_ServerConfigurationType_GetRejectedList 12775
#define OpcUaId_ServerConfigurationType_ResetToServerDefaults 25699
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open 12647
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close 12650
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read 12652
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write 12655
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition 12657
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition 12660
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks 12663
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate 12666
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate 12668
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate 12670
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable 22601
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable 22602
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment 22603
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge 22623
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve 22670
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve 22672
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve 22673
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable 22749
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable 22750
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment 22751
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge 22771
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve 22818
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve 22820
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 22821
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open 14095
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close 14098
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read 14100
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write 14103
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition 14105
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition 14108
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks 14111
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate 14114
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate 14117
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate 14119
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable 22897
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable 22898
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment 22899
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge 22919
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve 22966
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve 22968
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve 22969
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable 23045
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable 23046
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment 23047
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge 23067
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve 23114
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve 23116
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 23117
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open 14129
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close 14132
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read 14134
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write 14137
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition 14139
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition 14142
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks 14145
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate 14148
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate 14151
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate 14153
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable 23193
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable 23194
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment 23195
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge 23215
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve 23262
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve 23264
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve 23265
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable 23341
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable 23342
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment 23343
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge 23363
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve 23410
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve 23412
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 23413
#define OpcUaId_ServerConfiguration_UpdateCertificate 13737
#define OpcUaId_ServerConfiguration_ApplyChanges 12740
#define OpcUaId_ServerConfiguration_CancelChanges 25708
#define OpcUaId_ServerConfiguration_CreateSigningRequest 12737
#define OpcUaId_ServerConfiguration_GetRejectedList 12777
#define OpcUaId_ServerConfiguration_ResetToServerDefaults 25709
#define OpcUaId_ServerConfiguration_SetAdminPassword 25710
#define OpcUaId_KeyCredentialConfigurationFolderType_CreateCredential 17522
#define OpcUaId_KeyCredentialConfigurationType_GetEncryptingKey 17534
#define OpcUaId_KeyCredentialConfigurationType_UpdateCredential 18006
#define OpcUaId_KeyCredentialConfigurationType_DeleteCredential 18008
#define OpcUaId_PubSubKeyServiceType_GetSecurityKeys 15907
#define OpcUaId_PubSubKeyServiceType_GetSecurityGroup 15910
#define OpcUaId_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup 15914
#define OpcUaId_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup 15917
#define OpcUaId_PubSubKeyServiceType_KeyPushTargets_AddPushTarget 25278
#define OpcUaId_PubSubKeyServiceType_KeyPushTargets_RemovePushTarget 25281
#define OpcUaId_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup 15454
#define OpcUaId_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup 15457
#define OpcUaId_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder 25293
#define OpcUaId_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder 25296
#define OpcUaId_SecurityGroupFolderType_AddSecurityGroup 15461
#define OpcUaId_SecurityGroupFolderType_RemoveSecurityGroup 15464
#define OpcUaId_SecurityGroupFolderType_AddSecurityGroupFolder 25312
#define OpcUaId_SecurityGroupFolderType_RemoveSecurityGroupFolder 25315
#define OpcUaId_SecurityGroupType_InvalidateKeys 25624
#define OpcUaId_SecurityGroupType_ForceKeyRotation 25625
#define OpcUaId_PubSubKeyPushTargetType_ConnectSecurityGroups 25641
#define OpcUaId_PubSubKeyPushTargetType_DisconnectSecurityGroups 25644
#define OpcUaId_PubSubKeyPushTargetType_TriggerKeyUpdate 25647
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget 25348
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget 25351
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder 25353
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder 25356
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups 25655
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups 25658
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_TriggerKeyUpdate 25661
#define OpcUaId_PubSubKeyPushTargetFolderType_AddPushTarget 25366
#define OpcUaId_PubSubKeyPushTargetFolderType_RemovePushTarget 25369
#define OpcUaId_PubSubKeyPushTargetFolderType_AddPushTargetFolder 25371
#define OpcUaId_PubSubKeyPushTargetFolderType_RemovePushTargetFolder 25374
#define OpcUaId_PublishSubscribeType_SecurityGroups_AddSecurityGroup 15435
#define OpcUaId_PublishSubscribeType_SecurityGroups_RemoveSecurityGroup 15438
#define OpcUaId_PublishSubscribeType_KeyPushTargets_AddPushTarget 25393
#define OpcUaId_PublishSubscribeType_KeyPushTargets_RemovePushTarget 25396
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Reset 18679
#define OpcUaId_PublishSubscribeType_SetSecurityKeys 17296
#define OpcUaId_PublishSubscribeType_AddConnection 16598
#define OpcUaId_PublishSubscribeType_RemoveConnection 14432
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_Open 25411
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_Close 25414
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_Read 25416
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_Write 25419
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_GetPosition 25421
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_SetPosition 25424
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_ReserveIds 25426
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate 25429
#define OpcUaId_PublishSubscribeType_Diagnostics_Reset 18727
#define OpcUaId_PublishSubscribe_GetSecurityKeys 15215
#define OpcUaId_PublishSubscribe_GetSecurityGroup 15440
#define OpcUaId_PublishSubscribe_SecurityGroups_AddSecurityGroup 15444
#define OpcUaId_PublishSubscribe_SecurityGroups_RemoveSecurityGroup 15447
#define OpcUaId_PublishSubscribe_KeyPushTargets_AddPushTarget 25441
#define OpcUaId_PublishSubscribe_KeyPushTargets_RemovePushTarget 25444
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Reset 16076
#define OpcUaId_PublishSubscribe_SetSecurityKeys 17364
#define OpcUaId_PublishSubscribe_AddConnection 17366
#define OpcUaId_PublishSubscribe_RemoveConnection 17369
#define OpcUaId_PublishSubscribe_PubSubConfiguration_Open 25459
#define OpcUaId_PublishSubscribe_PubSubConfiguration_Close 25462
#define OpcUaId_PublishSubscribe_PubSubConfiguration_Read 25464
#define OpcUaId_PublishSubscribe_PubSubConfiguration_Write 25467
#define OpcUaId_PublishSubscribe_PubSubConfiguration_GetPosition 25469
#define OpcUaId_PublishSubscribe_PubSubConfiguration_SetPosition 25472
#define OpcUaId_PublishSubscribe_PubSubConfiguration_ReserveIds 25474
#define OpcUaId_PublishSubscribe_PubSubConfiguration_CloseAndUpdate 25477
#define OpcUaId_PublishSubscribe_Diagnostics_Reset 17421
#define OpcUaId_DataSetClasses_GetSecurityKeys 32406
#define OpcUaId_DataSetClasses_GetSecurityGroup 32409
#define OpcUaId_DataSetClasses_SecurityGroups_AddSecurityGroup 32413
#define OpcUaId_DataSetClasses_SecurityGroups_RemoveSecurityGroup 32416
#define OpcUaId_DataSetClasses_KeyPushTargets_AddPushTarget 32425
#define OpcUaId_DataSetClasses_KeyPushTargets_RemovePushTarget 32428
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Reset 32464
#define OpcUaId_DataSetClasses_SetSecurityKeys 32508
#define OpcUaId_DataSetClasses_AddConnection 32510
#define OpcUaId_DataSetClasses_RemoveConnection 32513
#define OpcUaId_DataSetClasses_PubSubConfiguration_Open 32554
#define OpcUaId_DataSetClasses_PubSubConfiguration_Close 32557
#define OpcUaId_DataSetClasses_PubSubConfiguration_Read 32559
#define OpcUaId_DataSetClasses_PubSubConfiguration_Write 32562
#define OpcUaId_DataSetClasses_PubSubConfiguration_GetPosition 32564
#define OpcUaId_DataSetClasses_PubSubConfiguration_SetPosition 32567
#define OpcUaId_DataSetClasses_PubSubConfiguration_ReserveIds 32569
#define OpcUaId_DataSetClasses_PubSubConfiguration_CloseAndUpdate 32572
#define OpcUaId_DataSetClasses_Diagnostics_Reset 32591
#define OpcUaId_PubSubConfigurationType_ReserveIds 25505
#define OpcUaId_PubSubConfigurationType_CloseAndUpdate 25508
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Reset 18883
#define OpcUaId_PublishedDataSetType_ExtensionFields_AddExtensionField 15482
#define OpcUaId_PublishedDataSetType_ExtensionFields_RemoveExtensionField 15485
#define OpcUaId_ExtensionFieldsType_AddExtensionField 15491
#define OpcUaId_ExtensionFieldsType_RemoveExtensionField 15494
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Reset 18942
#define OpcUaId_PublishedDataItemsType_ExtensionFields_AddExtensionField 15504
#define OpcUaId_PublishedDataItemsType_ExtensionFields_RemoveExtensionField 15507
#define OpcUaId_PublishedDataItemsType_AddVariables 14555
#define OpcUaId_PublishedDataItemsType_RemoveVariables 14558
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Reset 19001
#define OpcUaId_PublishedEventsType_ExtensionFields_AddExtensionField 15512
#define OpcUaId_PublishedEventsType_ExtensionFields_RemoveExtensionField 15515
#define OpcUaId_PublishedEventsType_ModifyFieldSelection 15052
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems 14479
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents 14482
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate 16842
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate 16881
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet 14485
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder 16884
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder 16923
#define OpcUaId_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField 15474
#define OpcUaId_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField 15477
#define OpcUaId_DataSetFolderType_AddPublishedDataItems 14493
#define OpcUaId_DataSetFolderType_AddPublishedEvents 14496
#define OpcUaId_DataSetFolderType_AddPublishedDataItemsTemplate 16935
#define OpcUaId_DataSetFolderType_AddPublishedEventsTemplate 16960
#define OpcUaId_DataSetFolderType_RemovePublishedDataSet 14499
#define OpcUaId_DataSetFolderType_AddDataSetFolder 16994
#define OpcUaId_DataSetFolderType_RemoveDataSetFolder 16997
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Reset 19119
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Reset 19188
#define OpcUaId_PubSubConnectionType_Diagnostics_Reset 19253
#define OpcUaId_PubSubConnectionType_AddWriterGroup 17427
#define OpcUaId_PubSubConnectionType_AddReaderGroup 17465
#define OpcUaId_PubSubConnectionType_RemoveGroup 14225
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Reset 17765
#define OpcUaId_WriterGroupType_Diagnostics_Reset 17824
#define OpcUaId_WriterGroupType_AddDataSetWriter 17969
#define OpcUaId_WriterGroupType_RemoveDataSetWriter 17992
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Reset 18104
#define OpcUaId_ReaderGroupType_Diagnostics_Reset 21027
#define OpcUaId_ReaderGroupType_AddDataSetReader 21082
#define OpcUaId_ReaderGroupType_RemoveDataSetReader 21085
#define OpcUaId_DataSetWriterType_Diagnostics_Reset 19562
#define OpcUaId_DataSetReaderType_Diagnostics_Reset 19621
#define OpcUaId_DataSetReaderType_CreateTargetVariables 17386
#define OpcUaId_DataSetReaderType_CreateDataSetMirror 17389
#define OpcUaId_TargetVariablesType_AddTargetVariables 15115
#define OpcUaId_TargetVariablesType_RemoveTargetVariables 15118
#define OpcUaId_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddSubscribedDataSet 23797
#define OpcUaId_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveSubscribedDataSet 23800
#define OpcUaId_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddDataSetFolder 23802
#define OpcUaId_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveDataSetFolder 23805
#define OpcUaId_SubscribedDataSetFolderType_AddSubscribedDataSet 23811
#define OpcUaId_SubscribedDataSetFolderType_RemoveSubscribedDataSet 23814
#define OpcUaId_SubscribedDataSetFolderType_AddDataSetFolder 23816
#define OpcUaId_SubscribedDataSetFolderType_RemoveDataSetFolder 23819
#define OpcUaId_PubSubStatusType_Enable 14645
#define OpcUaId_PubSubStatusType_Disable 14646
#define OpcUaId_PubSubDiagnosticsType_Reset 19689
#define OpcUaId_AliasNameCategoryType_SubAliasNameCategories_Placeholder_FindAlias 23459
#define OpcUaId_AliasNameCategoryType_FindAlias 23462
#define OpcUaId_Aliases_SubAliasNameCategories_Placeholder_FindAlias 23473
#define OpcUaId_Aliases_FindAlias 23476
#define OpcUaId_TagVariables_SubAliasNameCategories_Placeholder_FindAlias 23482
#define OpcUaId_TagVariables_FindAlias 23485
#define OpcUaId_Topics_SubAliasNameCategories_Placeholder_FindAlias 23491
#define OpcUaId_Topics_FindAlias 23494
#define OpcUaId_UserManagementType_AddUser 24269
#define OpcUaId_UserManagementType_ModifyUser 24271
#define OpcUaId_UserManagementType_RemoveUser 24273
#define OpcUaId_UserManagementType_ChangePassword 24275
#define OpcUaId_UserManagement_AddUser 24304
#define OpcUaId_UserManagement_ModifyUser 24306
#define OpcUaId_UserManagement_RemoveUser 24308
#define OpcUaId_UserManagement_ChangePassword 24310
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open 25742
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close 25745
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read 25747
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write 25750
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition 25752
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition 25755
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks 25760
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate 25763
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate 25766
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate 25768
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable 25807
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable 25808
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment 25809
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge 25829
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve 25876
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve 25880
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve 25883
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable 25973
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable 25974
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment 25975
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge 25995
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve 26042
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve 26046
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 26049
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open 26114
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close 26117
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read 26119
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write 26122
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition 26124
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition 26127
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks 26132
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate 26135
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate 26138
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate 26140
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable 26179
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable 26180
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment 26181
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge 26201
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve 26248
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve 26252
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve 26255
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable 26345
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable 26346
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment 26347
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge 26367
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve 26414
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve 26418
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 26421
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open 26486
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close 26489
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read 26491
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write 26494
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition 26496
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition 26499
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks 26504
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate 26507
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate 26510
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate 26512
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable 26551
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable 26552
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment 26553
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge 26573
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve 26620
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve 26624
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve 26627
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable 26717
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable 26718
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment 26719
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge 26739
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve 26786
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve 26790
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 26793
#define OpcUaId_ProvisionableDeviceType_RequestTickets 26873
#define OpcUaId_ProvisionableDeviceType_SetRegistrarEndpoints 26875
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open 26889
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close 26892
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read 26894
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write 26897
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition 26899
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition 26902
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks 26907
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate 26910
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate 26913
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate 26915
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable 26954
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable 26955
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment 26956
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge 26976
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve 27023
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve 27027
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve 27030
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable 27120
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable 27121
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment 27122
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge 27142
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve 27189
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve 27193
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 27196
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open 27261
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close 27264
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read 27266
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write 27269
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition 27271
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition 27274
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks 27279
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate 27282
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate 27285
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate 27287
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable 27326
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable 27327
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment 27328
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge 27348
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve 27395
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve 27399
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve 27402
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable 27492
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable 27493
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment 27494
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge 27514
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve 27561
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve 27565
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 27568
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open 27633
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close 27636
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read 27638
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write 27641
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition 27643
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition 27646
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks 27651
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate 27654
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate 27657
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate 27659
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable 27698
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable 27699
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment 27700
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge 27720
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve 27767
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve 27771
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve 27774
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable 27864
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable 27865
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment 27866
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge 27886
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve 27933
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve 27937
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 27940
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate 28005
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_ApplyChanges 28008
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest 28010
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_GetRejectedList 28013
#define OpcUaId_ProvisionableDevice_RequestTickets 29880
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open 29896
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close 29899
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read 29901
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write 29904
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition 29906
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition 29909
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks 29914
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate 29917
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate 29920
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate 29922
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable 29961
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable 29962
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment 29963
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge 29983
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve 30030
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve 30034
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve 30037
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable 30127
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable 30128
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment 30129
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge 30149
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve 30196
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve 30200
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 30203
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open 30268
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close 30271
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read 30273
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write 30276
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition 30278
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition 30281
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks 30286
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate 30289
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate 30292
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate 30294
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable 30333
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable 30334
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment 30335
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge 30355
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve 30402
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve 30406
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve 30409
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable 30499
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable 30500
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment 30501
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge 30521
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve 30568
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve 30572
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 30575
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open 30640
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close 30643
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read 30645
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write 30648
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition 30650
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition 30653
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks 30658
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate 30661
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate 30664
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate 30666
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable 30705
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable 30706
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment 30707
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge 30727
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve 30774
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve 30778
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve 30781
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable 30871
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable 30872
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment 30873
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge 30893
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve 30940
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve 30944
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve 30947
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_UpdateCertificate 31384
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_ApplyChanges 31387
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CreateSigningRequest 31389
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_GetRejectedList 31392
#define OpcUaId_PriorityMappingTableType_AddPriorityMappingEntry 25229
#define OpcUaId_PriorityMappingTableType_DeletePriorityMappingEntry 25231

/*============================================================================
* Object Identifiers
 *===========================================================================*/
#define OpcUaId_DefaultBinary 3062
#define OpcUaId_DefaultXml 3063
#define OpcUaId_ModellingRule_Mandatory 78
#define OpcUaId_ModellingRule_Optional 80
#define OpcUaId_ModellingRule_ExposesItsArray 83
#define OpcUaId_ModellingRule_OptionalPlaceholder 11508
#define OpcUaId_ModellingRule_MandatoryPlaceholder 11510
#define OpcUaId_RootFolder 84
#define OpcUaId_ObjectsFolder 85
#define OpcUaId_TypesFolder 86
#define OpcUaId_ViewsFolder 87
#define OpcUaId_ObjectTypesFolder 88
#define OpcUaId_VariableTypesFolder 89
#define OpcUaId_DataTypesFolder 90
#define OpcUaId_ReferenceTypesFolder 91
#define OpcUaId_XmlSchema_TypeSystem 92
#define OpcUaId_OPCBinarySchema_TypeSystem 93
#define OpcUaId_OPCUANamespaceMetadata 15957
#define OpcUaId_ServerType_ServerCapabilities 2009
#define OpcUaId_ServerType_ServerCapabilities_ModellingRules 3093
#define OpcUaId_ServerType_ServerCapabilities_AggregateFunctions 3094
#define OpcUaId_ServerType_ServerDiagnostics 2010
#define OpcUaId_ServerType_ServerDiagnostics_SessionsDiagnosticsSummary 3111
#define OpcUaId_ServerType_VendorServerInfo 2011
#define OpcUaId_ServerType_ServerRedundancy 2012
#define OpcUaId_ServerType_Namespaces 11527
#define OpcUaId_ServerCapabilitiesType_OperationLimits 11551
#define OpcUaId_ServerCapabilitiesType_ModellingRules 2019
#define OpcUaId_ServerCapabilitiesType_AggregateFunctions 2754
#define OpcUaId_ServerCapabilitiesType_RoleSet 16295
#define OpcUaId_ServerDiagnosticsType_SessionsDiagnosticsSummary 2744
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder 12097
#define OpcUaId_NamespaceMetadataType_NamespaceFile 11624
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder 11646
#define OpcUaId_EventTypesFolder 3048
#define OpcUaId_Locations 31915
#define OpcUaId_Server 2253
#define OpcUaId_Server_ServerCapabilities 2268
#define OpcUaId_Server_ServerCapabilities_OperationLimits 11704
#define OpcUaId_Server_ServerCapabilities_ModellingRules 2996
#define OpcUaId_Server_ServerCapabilities_AggregateFunctions 2997
#define OpcUaId_Server_ServerCapabilities_RoleSet 15606
#define OpcUaId_Server_ServerDiagnostics 2274
#define OpcUaId_Server_ServerDiagnostics_SessionsDiagnosticsSummary 3706
#define OpcUaId_Server_VendorServerInfo 2295
#define OpcUaId_Server_ServerRedundancy 2296
#define OpcUaId_Server_Namespaces 11715
#define OpcUaId_HistoryServerCapabilities 11192
#define OpcUaId_HistoryServerCapabilities_AggregateFunctions 11201
#define OpcUaId_FileDirectoryType_FileDirectoryName_Placeholder 13354
#define OpcUaId_FileDirectoryType_FileName_Placeholder 13366
#define OpcUaId_FileSystem 16314
#define OpcUaId_TemporaryFileTransferType_TransferState_Placeholder 15754
#define OpcUaId_FileTransferStateMachineType_Idle 15815
#define OpcUaId_FileTransferStateMachineType_ReadPrepare 15817
#define OpcUaId_FileTransferStateMachineType_ReadTransfer 15819
#define OpcUaId_FileTransferStateMachineType_ApplyWrite 15821
#define OpcUaId_FileTransferStateMachineType_Error 15823
#define OpcUaId_FileTransferStateMachineType_IdleToReadPrepare 15825
#define OpcUaId_FileTransferStateMachineType_ReadPrepareToReadTransfer 15827
#define OpcUaId_FileTransferStateMachineType_ReadTransferToIdle 15829
#define OpcUaId_FileTransferStateMachineType_IdleToApplyWrite 15831
#define OpcUaId_FileTransferStateMachineType_ApplyWriteToIdle 15833
#define OpcUaId_FileTransferStateMachineType_ReadPrepareToError 15835
#define OpcUaId_FileTransferStateMachineType_ReadTransferToError 15837
#define OpcUaId_FileTransferStateMachineType_ApplyWriteToError 15839
#define OpcUaId_FileTransferStateMachineType_ErrorToIdle 15841
#define OpcUaId_RoleSetType_RoleName_Placeholder 15608
#define OpcUaId_WellKnownRole_Anonymous 15644
#define OpcUaId_WellKnownRole_AuthenticatedUser 15656
#define OpcUaId_WellKnownRole_Observer 15668
#define OpcUaId_WellKnownRole_Operator 15680
#define OpcUaId_WellKnownRole_Engineer 16036
#define OpcUaId_WellKnownRole_Supervisor 15692
#define OpcUaId_WellKnownRole_ConfigureAdmin 15716
#define OpcUaId_WellKnownRole_SecurityAdmin 15704
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin 25565
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess 25603
#define OpcUaId_WellKnownRole_SecurityKeyServerPush 25584
#define OpcUaId_DictionaryEntryType_DictionaryEntryName_Placeholder 17590
#define OpcUaId_DictionaryFolderType_DictionaryFolderName_Placeholder 17592
#define OpcUaId_DictionaryFolderType_DictionaryEntryName_Placeholder 17593
#define OpcUaId_Dictionaries 17594
#define OpcUaId_InterfaceTypes 17708
#define OpcUaId_OrderedListType_OrderedObject_Placeholder 23519
#define OpcUaId_AlarmConditionType_ShelvingState 9178
#define OpcUaId_AlarmConditionType_FirstInGroup 16398
#define OpcUaId_AlarmConditionType_AlarmGroup_Placeholder 16399
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder 16406
#define OpcUaId_ShelvedStateMachineType_Unshelved 2930
#define OpcUaId_ShelvedStateMachineType_TimedShelved 2932
#define OpcUaId_ShelvedStateMachineType_OneShotShelved 2933
#define OpcUaId_ShelvedStateMachineType_UnshelvedToTimedShelved 2935
#define OpcUaId_ShelvedStateMachineType_UnshelvedToOneShotShelved 2936
#define OpcUaId_ShelvedStateMachineType_TimedShelvedToUnshelved 2940
#define OpcUaId_ShelvedStateMachineType_TimedShelvedToOneShotShelved 2942
#define OpcUaId_ShelvedStateMachineType_OneShotShelvedToUnshelved 2943
#define OpcUaId_ShelvedStateMachineType_OneShotShelvedToTimedShelved 2945
#define OpcUaId_ExclusiveLimitStateMachineType_HighHigh 9329
#define OpcUaId_ExclusiveLimitStateMachineType_High 9331
#define OpcUaId_ExclusiveLimitStateMachineType_Low 9333
#define OpcUaId_ExclusiveLimitStateMachineType_LowLow 9335
#define OpcUaId_ExclusiveLimitStateMachineType_LowLowToLow 9337
#define OpcUaId_ExclusiveLimitStateMachineType_LowToLowLow 9338
#define OpcUaId_ExclusiveLimitStateMachineType_HighHighToHigh 9339
#define OpcUaId_ExclusiveLimitStateMachineType_HighToHighHigh 9340
#define OpcUaId_ExclusiveLimitAlarmType_LimitState 9455
#define OpcUaId_ProgramStateMachineType_FinalResultData 3850
#define OpcUaId_ProgramStateMachineType_Halted 2406
#define OpcUaId_ProgramStateMachineType_Ready 2400
#define OpcUaId_ProgramStateMachineType_Running 2402
#define OpcUaId_ProgramStateMachineType_Suspended 2404
#define OpcUaId_ProgramStateMachineType_HaltedToReady 2408
#define OpcUaId_ProgramStateMachineType_ReadyToRunning 2410
#define OpcUaId_ProgramStateMachineType_RunningToHalted 2412
#define OpcUaId_ProgramStateMachineType_RunningToReady 2414
#define OpcUaId_ProgramStateMachineType_RunningToSuspended 2416
#define OpcUaId_ProgramStateMachineType_SuspendedToRunning 2418
#define OpcUaId_ProgramStateMachineType_SuspendedToHalted 2420
#define OpcUaId_ProgramStateMachineType_SuspendedToReady 2422
#define OpcUaId_ProgramStateMachineType_ReadyToHalted 2424
#define OpcUaId_HistoricalDataConfigurationType_AggregateConfiguration 3059
#define OpcUaId_HistoricalDataConfigurationType_AggregateFunctions 11876
#define OpcUaId_HAConfiguration 11202
#define OpcUaId_HAConfiguration_AggregateConfiguration 11203
#define OpcUaId_HistoryServerCapabilitiesType_AggregateFunctions 11172
#define OpcUaId_CertificateGroupType_TrustList 13599
#define OpcUaId_CertificateGroupType_CertificateExpired 19450
#define OpcUaId_CertificateGroupType_TrustListOutOfDate 20143
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup 13814
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList 13815
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup 13848
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList 13849
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup 13882
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList 13883
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder 13916
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList 13917
#define OpcUaId_ServerConfigurationType_CertificateGroups 13950
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup 13951
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList 13952
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList 13986
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList 14020
#define OpcUaId_ServerConfigurationType_TransactionDiagnostics 32299
#define OpcUaId_ServerConfiguration 12637
#define OpcUaId_ServerConfiguration_CertificateGroups 14053
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup 14156
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList 12642
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup 14088
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList 14089
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup 14122
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList 14123
#define OpcUaId_KeyCredentialConfigurationFolderType_ServiceName_Placeholder 17511
#define OpcUaId_KeyCredentialConfiguration 18155
#define OpcUaId_AuthorizationServicesConfigurationFolderType_ServiceName_Placeholder 23557
#define OpcUaId_AuthorizationServices 17732
#define OpcUaId_AggregateFunction_Interpolative 2341
#define OpcUaId_AggregateFunction_Average 2342
#define OpcUaId_AggregateFunction_TimeAverage 2343
#define OpcUaId_AggregateFunction_TimeAverage2 11285
#define OpcUaId_AggregateFunction_Total 2344
#define OpcUaId_AggregateFunction_Total2 11304
#define OpcUaId_AggregateFunction_Minimum 2346
#define OpcUaId_AggregateFunction_Maximum 2347
#define OpcUaId_AggregateFunction_MinimumActualTime 2348
#define OpcUaId_AggregateFunction_MaximumActualTime 2349
#define OpcUaId_AggregateFunction_Range 2350
#define OpcUaId_AggregateFunction_Minimum2 11286
#define OpcUaId_AggregateFunction_Maximum2 11287
#define OpcUaId_AggregateFunction_MinimumActualTime2 11305
#define OpcUaId_AggregateFunction_MaximumActualTime2 11306
#define OpcUaId_AggregateFunction_Range2 11288
#define OpcUaId_AggregateFunction_AnnotationCount 2351
#define OpcUaId_AggregateFunction_Count 2352
#define OpcUaId_AggregateFunction_DurationInStateZero 11307
#define OpcUaId_AggregateFunction_DurationInStateNonZero 11308
#define OpcUaId_AggregateFunction_NumberOfTransitions 2355
#define OpcUaId_AggregateFunction_Start 2357
#define OpcUaId_AggregateFunction_End 2358
#define OpcUaId_AggregateFunction_Delta 2359
#define OpcUaId_AggregateFunction_StartBound 11505
#define OpcUaId_AggregateFunction_EndBound 11506
#define OpcUaId_AggregateFunction_DeltaBounds 11507
#define OpcUaId_AggregateFunction_DurationGood 2360
#define OpcUaId_AggregateFunction_DurationBad 2361
#define OpcUaId_AggregateFunction_PercentGood 2362
#define OpcUaId_AggregateFunction_PercentBad 2363
#define OpcUaId_AggregateFunction_WorstQuality 2364
#define OpcUaId_AggregateFunction_WorstQuality2 11292
#define OpcUaId_AggregateFunction_StandardDeviationSample 11426
#define OpcUaId_AggregateFunction_StandardDeviationPopulation 11427
#define OpcUaId_AggregateFunction_VarianceSample 11428
#define OpcUaId_AggregateFunction_VariancePopulation 11429
#define OpcUaId_PubSubKeyServiceType_SecurityGroups 15913
#define OpcUaId_PubSubKeyServiceType_KeyPushTargets 25277
#define OpcUaId_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder 15453
#define OpcUaId_SecurityGroupFolderType_SecurityGroupName_Placeholder 15459
#define OpcUaId_PubSubKeyPushTargetType_SecurityGroupName_Placeholder 25626
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder 25347
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder 25358
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder 14417
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Address 14423
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Status 14419
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters 18681
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues 18712
#define OpcUaId_PublishSubscribeType_PublishedDataSets 14434
#define OpcUaId_PublishSubscribeType_SubscribedDataSets 23622
#define OpcUaId_PublishSubscribeType_PubSubConfiguration 25403
#define OpcUaId_PublishSubscribeType_Status 15844
#define OpcUaId_PublishSubscribeType_Diagnostics 18715
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters 18729
#define OpcUaId_PublishSubscribeType_Diagnostics_LiveValues 18760
#define OpcUaId_PublishSubscribeType_PubSubCapablities 23642
#define OpcUaId_PublishSubscribeType_DataSetClasses 23649
#define OpcUaId_PublishSubscribe 14443
#define OpcUaId_PublishSubscribe_SecurityGroups 15443
#define OpcUaId_PublishSubscribe_KeyPushTargets 25440
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Address 15851
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Status 15865
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters 16102
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues 17352
#define OpcUaId_PublishSubscribe_PublishedDataSets 17371
#define OpcUaId_PublishSubscribe_SubscribedDataSets 23658
#define OpcUaId_PublishSubscribe_PubSubConfiguration 25451
#define OpcUaId_PublishSubscribe_Status 17405
#define OpcUaId_PublishSubscribe_Diagnostics 17409
#define OpcUaId_PublishSubscribe_Diagnostics_Counters 17423
#define OpcUaId_PublishSubscribe_Diagnostics_LiveValues 17457
#define OpcUaId_PublishSubscribe_PubSubCapablities 23678
#define OpcUaId_PublishSubscribe_DataSetClasses 23685
#define OpcUaId_DataSetClasses 32405
#define OpcUaId_DataSetClasses_SecurityGroups 32412
#define OpcUaId_DataSetClasses_KeyPushTargets 32424
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Address 32442
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Status 32448
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters 32466
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_LiveValues 32497
#define OpcUaId_DataSetClasses_PublishedDataSets 32515
#define OpcUaId_DataSetClasses_SubscribedDataSets 32535
#define OpcUaId_DataSetClasses_PubSubConfiguration 32546
#define OpcUaId_DataSetClasses_Status 32575
#define OpcUaId_DataSetClasses_Diagnostics 32579
#define OpcUaId_DataSetClasses_Diagnostics_Counters 32593
#define OpcUaId_DataSetClasses_Diagnostics_LiveValues 32624
#define OpcUaId_DataSetClasses_PubSubCapablities 32633
#define OpcUaId_DataSetClasses_DataSetClasses 32644
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder 15222
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Status 15223
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters 18885
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues 18916
#define OpcUaId_PublishedDataSetType_ExtensionFields 15481
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Status 15231
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters 18944
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues 18975
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Status 15239
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters 19003
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues 19034
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder 14478
#define OpcUaId_DataSetFolderType_PublishedDataSetName_Placeholder 14487
#define OpcUaId_PubSubConnectionType_Address 14221
#define OpcUaId_PubSubConnectionType_TransportSettings 17203
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder 17310
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Status 17314
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters 19121
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues 19152
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder 17325
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Status 17329
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters 19190
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues 19221
#define OpcUaId_PubSubConnectionType_Status 14600
#define OpcUaId_PubSubConnectionType_Diagnostics 19241
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters 19255
#define OpcUaId_PubSubConnectionType_Diagnostics_LiveValues 19286
#define OpcUaId_PubSubGroupType_Status 15265
#define OpcUaId_WriterGroupType_TransportSettings 17741
#define OpcUaId_WriterGroupType_MessageSettings 17742
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder 17743
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Status 17749
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters 17767
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues 17798
#define OpcUaId_WriterGroupType_Diagnostics 17812
#define OpcUaId_WriterGroupType_Diagnostics_Counters 17826
#define OpcUaId_WriterGroupType_Diagnostics_LiveValues 17858
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder 18076
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Status 18088
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters 18106
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues 18137
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_SubscribedDataSet 21006
#define OpcUaId_ReaderGroupType_Diagnostics 21015
#define OpcUaId_ReaderGroupType_Diagnostics_Counters 21029
#define OpcUaId_ReaderGroupType_Diagnostics_LiveValues 21060
#define OpcUaId_ReaderGroupType_TransportSettings 21080
#define OpcUaId_ReaderGroupType_MessageSettings 21081
#define OpcUaId_DataSetWriterType_TransportSettings 15303
#define OpcUaId_DataSetWriterType_MessageSettings 21095
#define OpcUaId_DataSetWriterType_Status 15299
#define OpcUaId_DataSetWriterType_Diagnostics 19550
#define OpcUaId_DataSetWriterType_Diagnostics_Counters 19564
#define OpcUaId_DataSetWriterType_Diagnostics_LiveValues 19595
#define OpcUaId_DataSetReaderType_TransportSettings 15311
#define OpcUaId_DataSetReaderType_MessageSettings 21103
#define OpcUaId_DataSetReaderType_Status 15307
#define OpcUaId_DataSetReaderType_Diagnostics 19609
#define OpcUaId_DataSetReaderType_Diagnostics_Counters 19623
#define OpcUaId_DataSetReaderType_Diagnostics_LiveValues 19654
#define OpcUaId_DataSetReaderType_SubscribedDataSet 15316
#define OpcUaId_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder 23796
#define OpcUaId_SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder 23807
#define OpcUaId_SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder_SubscribedDataSet 23808
#define OpcUaId_StandaloneSubscribedDataSetType_SubscribedDataSet 23829
#define OpcUaId_PubSubDiagnosticsType_Counters 19691
#define OpcUaId_PubSubDiagnosticsType_LiveValues 19722
#define OpcUaId_PubSubDiagnosticsRootType_LiveValues 19777
#define OpcUaId_PubSubDiagnosticsConnectionType_LiveValues 19831
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters 19848
#define OpcUaId_PubSubDiagnosticsWriterGroupType_LiveValues 19879
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters 19917
#define OpcUaId_PubSubDiagnosticsReaderGroupType_LiveValues 19948
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters 19982
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_LiveValues 20013
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters 20041
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_LiveValues 20072
#define OpcUaId_DatagramConnectionTransportType_DiscoveryAddress 15072
#define OpcUaId_DatagramWriterGroupTransportType_Address 23842
#define OpcUaId_DatagramDataSetReaderTransportType_Address 24017
#define OpcUaId_AliasNameCategoryType_Alias_Placeholder 23457
#define OpcUaId_AliasNameCategoryType_SubAliasNameCategories_Placeholder 23458
#define OpcUaId_Aliases 23470
#define OpcUaId_TagVariables 23479
#define OpcUaId_Topics 23488
#define OpcUaId_UserManagement 24290
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup 25733
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList 25734
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList 26106
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList 26478
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder 26878
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups 26879
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup 26880
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList 26881
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList 27253
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList 27625
#define OpcUaId_ProvisionableDevice 29878
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups 29886
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup 29887
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList 29888
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList 30260
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList 30632
#define OpcUaId_Resources 24226
#define OpcUaId_Communication 24227
#define OpcUaId_MappingTables 24228
#define OpcUaId_NetworkInterfaces 24229
#define OpcUaId_Streams 24230
#define OpcUaId_TalkerStreams 24231
#define OpcUaId_ListenerStreams 24232
#define OpcUaId_IetfBaseNetworkInterfaceType_InterfaceName_Placeholder 25226
#define OpcUaId_Union_Encoding_DefaultBinary 12766
#define OpcUaId_KeyValuePair_Encoding_DefaultBinary 14846
#define OpcUaId_AdditionalParametersType_Encoding_DefaultBinary 17537
#define OpcUaId_EphemeralKeyType_Encoding_DefaultBinary 17549
#define OpcUaId_EndpointType_Encoding_DefaultBinary 15671
#define OpcUaId_RationalNumber_Encoding_DefaultBinary 18815
#define OpcUaId_Vector_Encoding_DefaultBinary 18816
#define OpcUaId_ThreeDVector_Encoding_DefaultBinary 18817
#define OpcUaId_CartesianCoordinates_Encoding_DefaultBinary 18818
#define OpcUaId_ThreeDCartesianCoordinates_Encoding_DefaultBinary 18819
#define OpcUaId_Orientation_Encoding_DefaultBinary 18820
#define OpcUaId_ThreeDOrientation_Encoding_DefaultBinary 18821
#define OpcUaId_Frame_Encoding_DefaultBinary 18822
#define OpcUaId_ThreeDFrame_Encoding_DefaultBinary 18823
#define OpcUaId_IdentityMappingRuleType_Encoding_DefaultBinary 15736
#define OpcUaId_CurrencyUnitType_Encoding_DefaultBinary 23507
#define OpcUaId_TrustListDataType_Encoding_DefaultBinary 12680
#define OpcUaId_TransactionErrorType_Encoding_DefaultBinary 32382
#define OpcUaId_DecimalDataType_Encoding_DefaultBinary 17863
#define OpcUaId_DataTypeSchemaHeader_Encoding_DefaultBinary 15676
#define OpcUaId_DataTypeDescription_Encoding_DefaultBinary 125
#define OpcUaId_StructureDescription_Encoding_DefaultBinary 126
#define OpcUaId_EnumDescription_Encoding_DefaultBinary 127
#define OpcUaId_SimpleTypeDescription_Encoding_DefaultBinary 15421
#define OpcUaId_UABinaryFileDataType_Encoding_DefaultBinary 15422
#define OpcUaId_PortableQualifiedName_Encoding_DefaultBinary 24108
#define OpcUaId_PortableNodeId_Encoding_DefaultBinary 24109
#define OpcUaId_UnsignedRationalNumber_Encoding_DefaultBinary 24110
#define OpcUaId_DataSetMetaDataType_Encoding_DefaultBinary 124
#define OpcUaId_FieldMetaData_Encoding_DefaultBinary 14839
#define OpcUaId_ConfigurationVersionDataType_Encoding_DefaultBinary 14847
#define OpcUaId_PublishedDataSetDataType_Encoding_DefaultBinary 15677
#define OpcUaId_PublishedDataSetSourceDataType_Encoding_DefaultBinary 15678
#define OpcUaId_PublishedVariableDataType_Encoding_DefaultBinary 14323
#define OpcUaId_PublishedDataItemsDataType_Encoding_DefaultBinary 15679
#define OpcUaId_PublishedEventsDataType_Encoding_DefaultBinary 15681
#define OpcUaId_PublishedDataSetCustomSourceDataType_Encoding_DefaultBinary 25529
#define OpcUaId_DataSetWriterDataType_Encoding_DefaultBinary 15682
#define OpcUaId_DataSetWriterTransportDataType_Encoding_DefaultBinary 15683
#define OpcUaId_DataSetWriterMessageDataType_Encoding_DefaultBinary 15688
#define OpcUaId_PubSubGroupDataType_Encoding_DefaultBinary 15689
#define OpcUaId_WriterGroupDataType_Encoding_DefaultBinary 21150
#define OpcUaId_WriterGroupTransportDataType_Encoding_DefaultBinary 15691
#define OpcUaId_WriterGroupMessageDataType_Encoding_DefaultBinary 15693
#define OpcUaId_PubSubConnectionDataType_Encoding_DefaultBinary 15694
#define OpcUaId_ConnectionTransportDataType_Encoding_DefaultBinary 15695
#define OpcUaId_NetworkAddressDataType_Encoding_DefaultBinary 21151
#define OpcUaId_NetworkAddressUrlDataType_Encoding_DefaultBinary 21152
#define OpcUaId_ReaderGroupDataType_Encoding_DefaultBinary 21153
#define OpcUaId_ReaderGroupTransportDataType_Encoding_DefaultBinary 15701
#define OpcUaId_ReaderGroupMessageDataType_Encoding_DefaultBinary 15702
#define OpcUaId_DataSetReaderDataType_Encoding_DefaultBinary 15703
#define OpcUaId_DataSetReaderTransportDataType_Encoding_DefaultBinary 15705
#define OpcUaId_DataSetReaderMessageDataType_Encoding_DefaultBinary 15706
#define OpcUaId_SubscribedDataSetDataType_Encoding_DefaultBinary 15707
#define OpcUaId_TargetVariablesDataType_Encoding_DefaultBinary 15712
#define OpcUaId_FieldTargetDataType_Encoding_DefaultBinary 14848
#define OpcUaId_SubscribedDataSetMirrorDataType_Encoding_DefaultBinary 15713
#define OpcUaId_PubSubConfigurationDataType_Encoding_DefaultBinary 21154
#define OpcUaId_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultBinary 23851
#define OpcUaId_StandaloneSubscribedDataSetDataType_Encoding_DefaultBinary 23852
#define OpcUaId_SecurityGroupDataType_Encoding_DefaultBinary 23853
#define OpcUaId_PubSubKeyPushTargetDataType_Encoding_DefaultBinary 25530
#define OpcUaId_PubSubConfiguration2DataType_Encoding_DefaultBinary 23854
#define OpcUaId_UadpWriterGroupMessageDataType_Encoding_DefaultBinary 15715
#define OpcUaId_UadpDataSetWriterMessageDataType_Encoding_DefaultBinary 15717
#define OpcUaId_UadpDataSetReaderMessageDataType_Encoding_DefaultBinary 15718
#define OpcUaId_JsonWriterGroupMessageDataType_Encoding_DefaultBinary 15719
#define OpcUaId_JsonDataSetWriterMessageDataType_Encoding_DefaultBinary 15724
#define OpcUaId_JsonDataSetReaderMessageDataType_Encoding_DefaultBinary 15725
#define OpcUaId_QosDataType_Encoding_DefaultBinary 23855
#define OpcUaId_TransmitQosDataType_Encoding_DefaultBinary 23856
#define OpcUaId_TransmitQosPriorityDataType_Encoding_DefaultBinary 23857
#define OpcUaId_ReceiveQosDataType_Encoding_DefaultBinary 23860
#define OpcUaId_ReceiveQosPriorityDataType_Encoding_DefaultBinary 23861
#define OpcUaId_DatagramConnectionTransportDataType_Encoding_DefaultBinary 17468
#define OpcUaId_DatagramConnectionTransport2DataType_Encoding_DefaultBinary 23864
#define OpcUaId_DatagramWriterGroupTransportDataType_Encoding_DefaultBinary 21155
#define OpcUaId_DatagramWriterGroupTransport2DataType_Encoding_DefaultBinary 23865
#define OpcUaId_DatagramDataSetReaderTransportDataType_Encoding_DefaultBinary 23866
#define OpcUaId_BrokerConnectionTransportDataType_Encoding_DefaultBinary 15479
#define OpcUaId_BrokerWriterGroupTransportDataType_Encoding_DefaultBinary 15727
#define OpcUaId_BrokerDataSetWriterTransportDataType_Encoding_DefaultBinary 15729
#define OpcUaId_BrokerDataSetReaderTransportDataType_Encoding_DefaultBinary 15733
#define OpcUaId_PubSubConfigurationRefDataType_Encoding_DefaultBinary 25531
#define OpcUaId_PubSubConfigurationValueDataType_Encoding_DefaultBinary 25532
#define OpcUaId_AliasNameDataType_Encoding_DefaultBinary 23499
#define OpcUaId_UserManagementDataType_Encoding_DefaultBinary 24292
#define OpcUaId_PriorityMappingEntryType_Encoding_DefaultBinary 25239
#define OpcUaId_ReferenceDescriptionDataType_Encoding_DefaultBinary 32661
#define OpcUaId_ReferenceListEntryDataType_Encoding_DefaultBinary 32662
#define OpcUaId_RolePermissionType_Encoding_DefaultBinary 128
#define OpcUaId_DataTypeDefinition_Encoding_DefaultBinary 121
#define OpcUaId_StructureField_Encoding_DefaultBinary 14844
#define OpcUaId_StructureDefinition_Encoding_DefaultBinary 122
#define OpcUaId_EnumDefinition_Encoding_DefaultBinary 123
#define OpcUaId_Node_Encoding_DefaultBinary 260
#define OpcUaId_InstanceNode_Encoding_DefaultBinary 11889
#define OpcUaId_TypeNode_Encoding_DefaultBinary 11890
#define OpcUaId_ObjectNode_Encoding_DefaultBinary 263
#define OpcUaId_ObjectTypeNode_Encoding_DefaultBinary 266
#define OpcUaId_VariableNode_Encoding_DefaultBinary 269
#define OpcUaId_VariableTypeNode_Encoding_DefaultBinary 272
#define OpcUaId_ReferenceTypeNode_Encoding_DefaultBinary 275
#define OpcUaId_MethodNode_Encoding_DefaultBinary 278
#define OpcUaId_ViewNode_Encoding_DefaultBinary 281
#define OpcUaId_DataTypeNode_Encoding_DefaultBinary 284
#define OpcUaId_ReferenceNode_Encoding_DefaultBinary 287
#define OpcUaId_Argument_Encoding_DefaultBinary 298
#define OpcUaId_EnumValueType_Encoding_DefaultBinary 8251
#define OpcUaId_EnumField_Encoding_DefaultBinary 14845
#define OpcUaId_OptionSet_Encoding_DefaultBinary 12765
#define OpcUaId_TimeZoneDataType_Encoding_DefaultBinary 8917
#define OpcUaId_ApplicationDescription_Encoding_DefaultBinary 310
#define OpcUaId_RequestHeader_Encoding_DefaultBinary 391
#define OpcUaId_ResponseHeader_Encoding_DefaultBinary 394
#define OpcUaId_ServiceFault_Encoding_DefaultBinary 397
#define OpcUaId_SessionlessInvokeRequestType_Encoding_DefaultBinary 15903
#define OpcUaId_SessionlessInvokeResponseType_Encoding_DefaultBinary 21001
#define OpcUaId_FindServersRequest_Encoding_DefaultBinary 422
#define OpcUaId_FindServersResponse_Encoding_DefaultBinary 425
#define OpcUaId_ServerOnNetwork_Encoding_DefaultBinary 12207
#define OpcUaId_FindServersOnNetworkRequest_Encoding_DefaultBinary 12208
#define OpcUaId_FindServersOnNetworkResponse_Encoding_DefaultBinary 12209
#define OpcUaId_UserTokenPolicy_Encoding_DefaultBinary 306
#define OpcUaId_EndpointDescription_Encoding_DefaultBinary 314
#define OpcUaId_GetEndpointsRequest_Encoding_DefaultBinary 428
#define OpcUaId_GetEndpointsResponse_Encoding_DefaultBinary 431
#define OpcUaId_RegisteredServer_Encoding_DefaultBinary 434
#define OpcUaId_RegisterServerRequest_Encoding_DefaultBinary 437
#define OpcUaId_RegisterServerResponse_Encoding_DefaultBinary 440
#define OpcUaId_DiscoveryConfiguration_Encoding_DefaultBinary 12900
#define OpcUaId_MdnsDiscoveryConfiguration_Encoding_DefaultBinary 12901
#define OpcUaId_RegisterServer2Request_Encoding_DefaultBinary 12211
#define OpcUaId_RegisterServer2Response_Encoding_DefaultBinary 12212
#define OpcUaId_ChannelSecurityToken_Encoding_DefaultBinary 443
#define OpcUaId_OpenSecureChannelRequest_Encoding_DefaultBinary 446
#define OpcUaId_OpenSecureChannelResponse_Encoding_DefaultBinary 449
#define OpcUaId_CloseSecureChannelRequest_Encoding_DefaultBinary 452
#define OpcUaId_CloseSecureChannelResponse_Encoding_DefaultBinary 455
#define OpcUaId_SignedSoftwareCertificate_Encoding_DefaultBinary 346
#define OpcUaId_SignatureData_Encoding_DefaultBinary 458
#define OpcUaId_CreateSessionRequest_Encoding_DefaultBinary 461
#define OpcUaId_CreateSessionResponse_Encoding_DefaultBinary 464
#define OpcUaId_UserIdentityToken_Encoding_DefaultBinary 318
#define OpcUaId_AnonymousIdentityToken_Encoding_DefaultBinary 321
#define OpcUaId_UserNameIdentityToken_Encoding_DefaultBinary 324
#define OpcUaId_X509IdentityToken_Encoding_DefaultBinary 327
#define OpcUaId_IssuedIdentityToken_Encoding_DefaultBinary 940
#define OpcUaId_ActivateSessionRequest_Encoding_DefaultBinary 467
#define OpcUaId_ActivateSessionResponse_Encoding_DefaultBinary 470
#define OpcUaId_CloseSessionRequest_Encoding_DefaultBinary 473
#define OpcUaId_CloseSessionResponse_Encoding_DefaultBinary 476
#define OpcUaId_CancelRequest_Encoding_DefaultBinary 479
#define OpcUaId_CancelResponse_Encoding_DefaultBinary 482
#define OpcUaId_NodeAttributes_Encoding_DefaultBinary 351
#define OpcUaId_ObjectAttributes_Encoding_DefaultBinary 354
#define OpcUaId_VariableAttributes_Encoding_DefaultBinary 357
#define OpcUaId_MethodAttributes_Encoding_DefaultBinary 360
#define OpcUaId_ObjectTypeAttributes_Encoding_DefaultBinary 363
#define OpcUaId_VariableTypeAttributes_Encoding_DefaultBinary 366
#define OpcUaId_ReferenceTypeAttributes_Encoding_DefaultBinary 369
#define OpcUaId_DataTypeAttributes_Encoding_DefaultBinary 372
#define OpcUaId_ViewAttributes_Encoding_DefaultBinary 375
#define OpcUaId_GenericAttributeValue_Encoding_DefaultBinary 17610
#define OpcUaId_GenericAttributes_Encoding_DefaultBinary 17611
#define OpcUaId_AddNodesItem_Encoding_DefaultBinary 378
#define OpcUaId_AddNodesResult_Encoding_DefaultBinary 485
#define OpcUaId_AddNodesRequest_Encoding_DefaultBinary 488
#define OpcUaId_AddNodesResponse_Encoding_DefaultBinary 491
#define OpcUaId_AddReferencesItem_Encoding_DefaultBinary 381
#define OpcUaId_AddReferencesRequest_Encoding_DefaultBinary 494
#define OpcUaId_AddReferencesResponse_Encoding_DefaultBinary 497
#define OpcUaId_DeleteNodesItem_Encoding_DefaultBinary 384
#define OpcUaId_DeleteNodesRequest_Encoding_DefaultBinary 500
#define OpcUaId_DeleteNodesResponse_Encoding_DefaultBinary 503
#define OpcUaId_DeleteReferencesItem_Encoding_DefaultBinary 387
#define OpcUaId_DeleteReferencesRequest_Encoding_DefaultBinary 506
#define OpcUaId_DeleteReferencesResponse_Encoding_DefaultBinary 509
#define OpcUaId_ViewDescription_Encoding_DefaultBinary 513
#define OpcUaId_BrowseDescription_Encoding_DefaultBinary 516
#define OpcUaId_ReferenceDescription_Encoding_DefaultBinary 520
#define OpcUaId_BrowseResult_Encoding_DefaultBinary 524
#define OpcUaId_BrowseRequest_Encoding_DefaultBinary 527
#define OpcUaId_BrowseResponse_Encoding_DefaultBinary 530
#define OpcUaId_BrowseNextRequest_Encoding_DefaultBinary 533
#define OpcUaId_BrowseNextResponse_Encoding_DefaultBinary 536
#define OpcUaId_RelativePathElement_Encoding_DefaultBinary 539
#define OpcUaId_RelativePath_Encoding_DefaultBinary 542
#define OpcUaId_BrowsePath_Encoding_DefaultBinary 545
#define OpcUaId_BrowsePathTarget_Encoding_DefaultBinary 548
#define OpcUaId_BrowsePathResult_Encoding_DefaultBinary 551
#define OpcUaId_TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultBinary 554
#define OpcUaId_TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultBinary 557
#define OpcUaId_RegisterNodesRequest_Encoding_DefaultBinary 560
#define OpcUaId_RegisterNodesResponse_Encoding_DefaultBinary 563
#define OpcUaId_UnregisterNodesRequest_Encoding_DefaultBinary 566
#define OpcUaId_UnregisterNodesResponse_Encoding_DefaultBinary 569
#define OpcUaId_EndpointConfiguration_Encoding_DefaultBinary 333
#define OpcUaId_QueryDataDescription_Encoding_DefaultBinary 572
#define OpcUaId_NodeTypeDescription_Encoding_DefaultBinary 575
#define OpcUaId_QueryDataSet_Encoding_DefaultBinary 579
#define OpcUaId_NodeReference_Encoding_DefaultBinary 582
#define OpcUaId_ContentFilterElement_Encoding_DefaultBinary 585
#define OpcUaId_ContentFilter_Encoding_DefaultBinary 588
#define OpcUaId_FilterOperand_Encoding_DefaultBinary 591
#define OpcUaId_ElementOperand_Encoding_DefaultBinary 594
#define OpcUaId_LiteralOperand_Encoding_DefaultBinary 597
#define OpcUaId_AttributeOperand_Encoding_DefaultBinary 600
#define OpcUaId_SimpleAttributeOperand_Encoding_DefaultBinary 603
#define OpcUaId_ContentFilterElementResult_Encoding_DefaultBinary 606
#define OpcUaId_ContentFilterResult_Encoding_DefaultBinary 609
#define OpcUaId_ParsingResult_Encoding_DefaultBinary 612
#define OpcUaId_QueryFirstRequest_Encoding_DefaultBinary 615
#define OpcUaId_QueryFirstResponse_Encoding_DefaultBinary 618
#define OpcUaId_QueryNextRequest_Encoding_DefaultBinary 621
#define OpcUaId_QueryNextResponse_Encoding_DefaultBinary 624
#define OpcUaId_ReadValueId_Encoding_DefaultBinary 628
#define OpcUaId_ReadRequest_Encoding_DefaultBinary 631
#define OpcUaId_ReadResponse_Encoding_DefaultBinary 634
#define OpcUaId_HistoryReadValueId_Encoding_DefaultBinary 637
#define OpcUaId_HistoryReadResult_Encoding_DefaultBinary 640
#define OpcUaId_HistoryReadDetails_Encoding_DefaultBinary 643
#define OpcUaId_ReadEventDetails_Encoding_DefaultBinary 646
#define OpcUaId_ReadRawModifiedDetails_Encoding_DefaultBinary 649
#define OpcUaId_ReadProcessedDetails_Encoding_DefaultBinary 652
#define OpcUaId_ReadAtTimeDetails_Encoding_DefaultBinary 655
#define OpcUaId_ReadAnnotationDataDetails_Encoding_DefaultBinary 23500
#define OpcUaId_HistoryData_Encoding_DefaultBinary 658
#define OpcUaId_ModificationInfo_Encoding_DefaultBinary 11226
#define OpcUaId_HistoryModifiedData_Encoding_DefaultBinary 11227
#define OpcUaId_HistoryEvent_Encoding_DefaultBinary 661
#define OpcUaId_HistoryReadRequest_Encoding_DefaultBinary 664
#define OpcUaId_HistoryReadResponse_Encoding_DefaultBinary 667
#define OpcUaId_WriteValue_Encoding_DefaultBinary 670
#define OpcUaId_WriteRequest_Encoding_DefaultBinary 673
#define OpcUaId_WriteResponse_Encoding_DefaultBinary 676
#define OpcUaId_HistoryUpdateDetails_Encoding_DefaultBinary 679
#define OpcUaId_UpdateDataDetails_Encoding_DefaultBinary 682
#define OpcUaId_UpdateStructureDataDetails_Encoding_DefaultBinary 11300
#define OpcUaId_UpdateEventDetails_Encoding_DefaultBinary 685
#define OpcUaId_DeleteRawModifiedDetails_Encoding_DefaultBinary 688
#define OpcUaId_DeleteAtTimeDetails_Encoding_DefaultBinary 691
#define OpcUaId_DeleteEventDetails_Encoding_DefaultBinary 694
#define OpcUaId_HistoryUpdateResult_Encoding_DefaultBinary 697
#define OpcUaId_HistoryUpdateRequest_Encoding_DefaultBinary 700
#define OpcUaId_HistoryUpdateResponse_Encoding_DefaultBinary 703
#define OpcUaId_CallMethodRequest_Encoding_DefaultBinary 706
#define OpcUaId_CallMethodResult_Encoding_DefaultBinary 709
#define OpcUaId_CallRequest_Encoding_DefaultBinary 712
#define OpcUaId_CallResponse_Encoding_DefaultBinary 715
#define OpcUaId_MonitoringFilter_Encoding_DefaultBinary 721
#define OpcUaId_DataChangeFilter_Encoding_DefaultBinary 724
#define OpcUaId_EventFilter_Encoding_DefaultBinary 727
#define OpcUaId_AggregateConfiguration_Encoding_DefaultBinary 950
#define OpcUaId_AggregateFilter_Encoding_DefaultBinary 730
#define OpcUaId_MonitoringFilterResult_Encoding_DefaultBinary 733
#define OpcUaId_EventFilterResult_Encoding_DefaultBinary 736
#define OpcUaId_AggregateFilterResult_Encoding_DefaultBinary 739
#define OpcUaId_MonitoringParameters_Encoding_DefaultBinary 742
#define OpcUaId_MonitoredItemCreateRequest_Encoding_DefaultBinary 745
#define OpcUaId_MonitoredItemCreateResult_Encoding_DefaultBinary 748
#define OpcUaId_CreateMonitoredItemsRequest_Encoding_DefaultBinary 751
#define OpcUaId_CreateMonitoredItemsResponse_Encoding_DefaultBinary 754
#define OpcUaId_MonitoredItemModifyRequest_Encoding_DefaultBinary 757
#define OpcUaId_MonitoredItemModifyResult_Encoding_DefaultBinary 760
#define OpcUaId_ModifyMonitoredItemsRequest_Encoding_DefaultBinary 763
#define OpcUaId_ModifyMonitoredItemsResponse_Encoding_DefaultBinary 766
#define OpcUaId_SetMonitoringModeRequest_Encoding_DefaultBinary 769
#define OpcUaId_SetMonitoringModeResponse_Encoding_DefaultBinary 772
#define OpcUaId_SetTriggeringRequest_Encoding_DefaultBinary 775
#define OpcUaId_SetTriggeringResponse_Encoding_DefaultBinary 778
#define OpcUaId_DeleteMonitoredItemsRequest_Encoding_DefaultBinary 781
#define OpcUaId_DeleteMonitoredItemsResponse_Encoding_DefaultBinary 784
#define OpcUaId_CreateSubscriptionRequest_Encoding_DefaultBinary 787
#define OpcUaId_CreateSubscriptionResponse_Encoding_DefaultBinary 790
#define OpcUaId_ModifySubscriptionRequest_Encoding_DefaultBinary 793
#define OpcUaId_ModifySubscriptionResponse_Encoding_DefaultBinary 796
#define OpcUaId_SetPublishingModeRequest_Encoding_DefaultBinary 799
#define OpcUaId_SetPublishingModeResponse_Encoding_DefaultBinary 802
#define OpcUaId_NotificationMessage_Encoding_DefaultBinary 805
#define OpcUaId_NotificationData_Encoding_DefaultBinary 947
#define OpcUaId_DataChangeNotification_Encoding_DefaultBinary 811
#define OpcUaId_MonitoredItemNotification_Encoding_DefaultBinary 808
#define OpcUaId_EventNotificationList_Encoding_DefaultBinary 916
#define OpcUaId_EventFieldList_Encoding_DefaultBinary 919
#define OpcUaId_HistoryEventFieldList_Encoding_DefaultBinary 922
#define OpcUaId_StatusChangeNotification_Encoding_DefaultBinary 820
#define OpcUaId_SubscriptionAcknowledgement_Encoding_DefaultBinary 823
#define OpcUaId_PublishRequest_Encoding_DefaultBinary 826
#define OpcUaId_PublishResponse_Encoding_DefaultBinary 829
#define OpcUaId_RepublishRequest_Encoding_DefaultBinary 832
#define OpcUaId_RepublishResponse_Encoding_DefaultBinary 835
#define OpcUaId_TransferResult_Encoding_DefaultBinary 838
#define OpcUaId_TransferSubscriptionsRequest_Encoding_DefaultBinary 841
#define OpcUaId_TransferSubscriptionsResponse_Encoding_DefaultBinary 844
#define OpcUaId_DeleteSubscriptionsRequest_Encoding_DefaultBinary 847
#define OpcUaId_DeleteSubscriptionsResponse_Encoding_DefaultBinary 850
#define OpcUaId_BuildInfo_Encoding_DefaultBinary 340
#define OpcUaId_RedundantServerDataType_Encoding_DefaultBinary 855
#define OpcUaId_EndpointUrlListDataType_Encoding_DefaultBinary 11957
#define OpcUaId_NetworkGroupDataType_Encoding_DefaultBinary 11958
#define OpcUaId_SamplingIntervalDiagnosticsDataType_Encoding_DefaultBinary 858
#define OpcUaId_ServerDiagnosticsSummaryDataType_Encoding_DefaultBinary 861
#define OpcUaId_ServerStatusDataType_Encoding_DefaultBinary 864
#define OpcUaId_SessionDiagnosticsDataType_Encoding_DefaultBinary 867
#define OpcUaId_SessionSecurityDiagnosticsDataType_Encoding_DefaultBinary 870
#define OpcUaId_ServiceCounterDataType_Encoding_DefaultBinary 873
#define OpcUaId_StatusResult_Encoding_DefaultBinary 301
#define OpcUaId_SubscriptionDiagnosticsDataType_Encoding_DefaultBinary 876
#define OpcUaId_ModelChangeStructureDataType_Encoding_DefaultBinary 879
#define OpcUaId_SemanticChangeStructureDataType_Encoding_DefaultBinary 899
#define OpcUaId_Range_Encoding_DefaultBinary 886
#define OpcUaId_EUInformation_Encoding_DefaultBinary 889
#define OpcUaId_ComplexNumberType_Encoding_DefaultBinary 12181
#define OpcUaId_DoubleComplexNumberType_Encoding_DefaultBinary 12182
#define OpcUaId_AxisInformation_Encoding_DefaultBinary 12089
#define OpcUaId_XVType_Encoding_DefaultBinary 12090
#define OpcUaId_ProgramDiagnosticDataType_Encoding_DefaultBinary 896
#define OpcUaId_ProgramDiagnostic2DataType_Encoding_DefaultBinary 24034
#define OpcUaId_Annotation_Encoding_DefaultBinary 893
#define OpcUaId_Union_Encoding_DefaultXml 12758
#define OpcUaId_KeyValuePair_Encoding_DefaultXml 14802
#define OpcUaId_AdditionalParametersType_Encoding_DefaultXml 17541
#define OpcUaId_EphemeralKeyType_Encoding_DefaultXml 17553
#define OpcUaId_EndpointType_Encoding_DefaultXml 15949
#define OpcUaId_RationalNumber_Encoding_DefaultXml 18851
#define OpcUaId_Vector_Encoding_DefaultXml 18852
#define OpcUaId_ThreeDVector_Encoding_DefaultXml 18853
#define OpcUaId_CartesianCoordinates_Encoding_DefaultXml 18854
#define OpcUaId_ThreeDCartesianCoordinates_Encoding_DefaultXml 18855
#define OpcUaId_Orientation_Encoding_DefaultXml 18856
#define OpcUaId_ThreeDOrientation_Encoding_DefaultXml 18857
#define OpcUaId_Frame_Encoding_DefaultXml 18858
#define OpcUaId_ThreeDFrame_Encoding_DefaultXml 18859
#define OpcUaId_IdentityMappingRuleType_Encoding_DefaultXml 15728
#define OpcUaId_CurrencyUnitType_Encoding_DefaultXml 23520
#define OpcUaId_TrustListDataType_Encoding_DefaultXml 12676
#define OpcUaId_TransactionErrorType_Encoding_DefaultXml 32386
#define OpcUaId_DecimalDataType_Encoding_DefaultXml 17862
#define OpcUaId_DataTypeSchemaHeader_Encoding_DefaultXml 15950
#define OpcUaId_DataTypeDescription_Encoding_DefaultXml 14796
#define OpcUaId_StructureDescription_Encoding_DefaultXml 15589
#define OpcUaId_EnumDescription_Encoding_DefaultXml 15590
#define OpcUaId_SimpleTypeDescription_Encoding_DefaultXml 15529
#define OpcUaId_UABinaryFileDataType_Encoding_DefaultXml 15531
#define OpcUaId_PortableQualifiedName_Encoding_DefaultXml 24120
#define OpcUaId_PortableNodeId_Encoding_DefaultXml 24121
#define OpcUaId_UnsignedRationalNumber_Encoding_DefaultXml 24122
#define OpcUaId_DataSetMetaDataType_Encoding_DefaultXml 14794
#define OpcUaId_FieldMetaData_Encoding_DefaultXml 14795
#define OpcUaId_ConfigurationVersionDataType_Encoding_DefaultXml 14803
#define OpcUaId_PublishedDataSetDataType_Encoding_DefaultXml 15951
#define OpcUaId_PublishedDataSetSourceDataType_Encoding_DefaultXml 15952
#define OpcUaId_PublishedVariableDataType_Encoding_DefaultXml 14319
#define OpcUaId_PublishedDataItemsDataType_Encoding_DefaultXml 15953
#define OpcUaId_PublishedEventsDataType_Encoding_DefaultXml 15954
#define OpcUaId_PublishedDataSetCustomSourceDataType_Encoding_DefaultXml 25545
#define OpcUaId_DataSetWriterDataType_Encoding_DefaultXml 15955
#define OpcUaId_DataSetWriterTransportDataType_Encoding_DefaultXml 15956
#define OpcUaId_DataSetWriterMessageDataType_Encoding_DefaultXml 15987
#define OpcUaId_PubSubGroupDataType_Encoding_DefaultXml 15988
#define OpcUaId_WriterGroupDataType_Encoding_DefaultXml 21174
#define OpcUaId_WriterGroupTransportDataType_Encoding_DefaultXml 15990
#define OpcUaId_WriterGroupMessageDataType_Encoding_DefaultXml 15991
#define OpcUaId_PubSubConnectionDataType_Encoding_DefaultXml 15992
#define OpcUaId_ConnectionTransportDataType_Encoding_DefaultXml 15993
#define OpcUaId_NetworkAddressDataType_Encoding_DefaultXml 21175
#define OpcUaId_NetworkAddressUrlDataType_Encoding_DefaultXml 21176
#define OpcUaId_ReaderGroupDataType_Encoding_DefaultXml 21177
#define OpcUaId_ReaderGroupTransportDataType_Encoding_DefaultXml 15995
#define OpcUaId_ReaderGroupMessageDataType_Encoding_DefaultXml 15996
#define OpcUaId_DataSetReaderDataType_Encoding_DefaultXml 16007
#define OpcUaId_DataSetReaderTransportDataType_Encoding_DefaultXml 16008
#define OpcUaId_DataSetReaderMessageDataType_Encoding_DefaultXml 16009
#define OpcUaId_SubscribedDataSetDataType_Encoding_DefaultXml 16010
#define OpcUaId_TargetVariablesDataType_Encoding_DefaultXml 16011
#define OpcUaId_FieldTargetDataType_Encoding_DefaultXml 14804
#define OpcUaId_SubscribedDataSetMirrorDataType_Encoding_DefaultXml 16012
#define OpcUaId_PubSubConfigurationDataType_Encoding_DefaultXml 21178
#define OpcUaId_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultXml 23919
#define OpcUaId_StandaloneSubscribedDataSetDataType_Encoding_DefaultXml 23920
#define OpcUaId_SecurityGroupDataType_Encoding_DefaultXml 23921
#define OpcUaId_PubSubKeyPushTargetDataType_Encoding_DefaultXml 25546
#define OpcUaId_PubSubConfiguration2DataType_Encoding_DefaultXml 23922
#define OpcUaId_UadpWriterGroupMessageDataType_Encoding_DefaultXml 16014
#define OpcUaId_UadpDataSetWriterMessageDataType_Encoding_DefaultXml 16015
#define OpcUaId_UadpDataSetReaderMessageDataType_Encoding_DefaultXml 16016
#define OpcUaId_JsonWriterGroupMessageDataType_Encoding_DefaultXml 16017
#define OpcUaId_JsonDataSetWriterMessageDataType_Encoding_DefaultXml 16018
#define OpcUaId_JsonDataSetReaderMessageDataType_Encoding_DefaultXml 16019
#define OpcUaId_QosDataType_Encoding_DefaultXml 23923
#define OpcUaId_TransmitQosDataType_Encoding_DefaultXml 23924
#define OpcUaId_TransmitQosPriorityDataType_Encoding_DefaultXml 23925
#define OpcUaId_ReceiveQosDataType_Encoding_DefaultXml 23928
#define OpcUaId_ReceiveQosPriorityDataType_Encoding_DefaultXml 23929
#define OpcUaId_DatagramConnectionTransportDataType_Encoding_DefaultXml 17472
#define OpcUaId_DatagramConnectionTransport2DataType_Encoding_DefaultXml 23932
#define OpcUaId_DatagramWriterGroupTransportDataType_Encoding_DefaultXml 21179
#define OpcUaId_DatagramWriterGroupTransport2DataType_Encoding_DefaultXml 23933
#define OpcUaId_DatagramDataSetReaderTransportDataType_Encoding_DefaultXml 23934
#define OpcUaId_BrokerConnectionTransportDataType_Encoding_DefaultXml 15579
#define OpcUaId_BrokerWriterGroupTransportDataType_Encoding_DefaultXml 16021
#define OpcUaId_BrokerDataSetWriterTransportDataType_Encoding_DefaultXml 16022
#define OpcUaId_BrokerDataSetReaderTransportDataType_Encoding_DefaultXml 16023
#define OpcUaId_PubSubConfigurationRefDataType_Encoding_DefaultXml 25547
#define OpcUaId_PubSubConfigurationValueDataType_Encoding_DefaultXml 25548
#define OpcUaId_AliasNameDataType_Encoding_DefaultXml 23505
#define OpcUaId_UserManagementDataType_Encoding_DefaultXml 24296
#define OpcUaId_PriorityMappingEntryType_Encoding_DefaultXml 25243
#define OpcUaId_ReferenceDescriptionDataType_Encoding_DefaultXml 32669
#define OpcUaId_ReferenceListEntryDataType_Encoding_DefaultXml 32670
#define OpcUaId_RolePermissionType_Encoding_DefaultXml 16126
#define OpcUaId_DataTypeDefinition_Encoding_DefaultXml 14797
#define OpcUaId_StructureField_Encoding_DefaultXml 14800
#define OpcUaId_StructureDefinition_Encoding_DefaultXml 14798
#define OpcUaId_EnumDefinition_Encoding_DefaultXml 14799
#define OpcUaId_Node_Encoding_DefaultXml 259
#define OpcUaId_InstanceNode_Encoding_DefaultXml 11887
#define OpcUaId_TypeNode_Encoding_DefaultXml 11888
#define OpcUaId_ObjectNode_Encoding_DefaultXml 262
#define OpcUaId_ObjectTypeNode_Encoding_DefaultXml 265
#define OpcUaId_VariableNode_Encoding_DefaultXml 268
#define OpcUaId_VariableTypeNode_Encoding_DefaultXml 271
#define OpcUaId_ReferenceTypeNode_Encoding_DefaultXml 274
#define OpcUaId_MethodNode_Encoding_DefaultXml 277
#define OpcUaId_ViewNode_Encoding_DefaultXml 280
#define OpcUaId_DataTypeNode_Encoding_DefaultXml 283
#define OpcUaId_ReferenceNode_Encoding_DefaultXml 286
#define OpcUaId_Argument_Encoding_DefaultXml 297
#define OpcUaId_EnumValueType_Encoding_DefaultXml 7616
#define OpcUaId_EnumField_Encoding_DefaultXml 14801
#define OpcUaId_OptionSet_Encoding_DefaultXml 12757
#define OpcUaId_TimeZoneDataType_Encoding_DefaultXml 8913
#define OpcUaId_ApplicationDescription_Encoding_DefaultXml 309
#define OpcUaId_RequestHeader_Encoding_DefaultXml 390
#define OpcUaId_ResponseHeader_Encoding_DefaultXml 393
#define OpcUaId_ServiceFault_Encoding_DefaultXml 396
#define OpcUaId_SessionlessInvokeRequestType_Encoding_DefaultXml 15902
#define OpcUaId_SessionlessInvokeResponseType_Encoding_DefaultXml 21000
#define OpcUaId_FindServersRequest_Encoding_DefaultXml 421
#define OpcUaId_FindServersResponse_Encoding_DefaultXml 424
#define OpcUaId_ServerOnNetwork_Encoding_DefaultXml 12195
#define OpcUaId_FindServersOnNetworkRequest_Encoding_DefaultXml 12196
#define OpcUaId_FindServersOnNetworkResponse_Encoding_DefaultXml 12197
#define OpcUaId_UserTokenPolicy_Encoding_DefaultXml 305
#define OpcUaId_EndpointDescription_Encoding_DefaultXml 313
#define OpcUaId_GetEndpointsRequest_Encoding_DefaultXml 427
#define OpcUaId_GetEndpointsResponse_Encoding_DefaultXml 430
#define OpcUaId_RegisteredServer_Encoding_DefaultXml 433
#define OpcUaId_RegisterServerRequest_Encoding_DefaultXml 436
#define OpcUaId_RegisterServerResponse_Encoding_DefaultXml 439
#define OpcUaId_DiscoveryConfiguration_Encoding_DefaultXml 12892
#define OpcUaId_MdnsDiscoveryConfiguration_Encoding_DefaultXml 12893
#define OpcUaId_RegisterServer2Request_Encoding_DefaultXml 12199
#define OpcUaId_RegisterServer2Response_Encoding_DefaultXml 12200
#define OpcUaId_ChannelSecurityToken_Encoding_DefaultXml 442
#define OpcUaId_OpenSecureChannelRequest_Encoding_DefaultXml 445
#define OpcUaId_OpenSecureChannelResponse_Encoding_DefaultXml 448
#define OpcUaId_CloseSecureChannelRequest_Encoding_DefaultXml 451
#define OpcUaId_CloseSecureChannelResponse_Encoding_DefaultXml 454
#define OpcUaId_SignedSoftwareCertificate_Encoding_DefaultXml 345
#define OpcUaId_SignatureData_Encoding_DefaultXml 457
#define OpcUaId_CreateSessionRequest_Encoding_DefaultXml 460
#define OpcUaId_CreateSessionResponse_Encoding_DefaultXml 463
#define OpcUaId_UserIdentityToken_Encoding_DefaultXml 317
#define OpcUaId_AnonymousIdentityToken_Encoding_DefaultXml 320
#define OpcUaId_UserNameIdentityToken_Encoding_DefaultXml 323
#define OpcUaId_X509IdentityToken_Encoding_DefaultXml 326
#define OpcUaId_IssuedIdentityToken_Encoding_DefaultXml 939
#define OpcUaId_ActivateSessionRequest_Encoding_DefaultXml 466
#define OpcUaId_ActivateSessionResponse_Encoding_DefaultXml 469
#define OpcUaId_CloseSessionRequest_Encoding_DefaultXml 472
#define OpcUaId_CloseSessionResponse_Encoding_DefaultXml 475
#define OpcUaId_CancelRequest_Encoding_DefaultXml 478
#define OpcUaId_CancelResponse_Encoding_DefaultXml 481
#define OpcUaId_NodeAttributes_Encoding_DefaultXml 350
#define OpcUaId_ObjectAttributes_Encoding_DefaultXml 353
#define OpcUaId_VariableAttributes_Encoding_DefaultXml 356
#define OpcUaId_MethodAttributes_Encoding_DefaultXml 359
#define OpcUaId_ObjectTypeAttributes_Encoding_DefaultXml 362
#define OpcUaId_VariableTypeAttributes_Encoding_DefaultXml 365
#define OpcUaId_ReferenceTypeAttributes_Encoding_DefaultXml 368
#define OpcUaId_DataTypeAttributes_Encoding_DefaultXml 371
#define OpcUaId_ViewAttributes_Encoding_DefaultXml 374
#define OpcUaId_GenericAttributeValue_Encoding_DefaultXml 17608
#define OpcUaId_GenericAttributes_Encoding_DefaultXml 17609
#define OpcUaId_AddNodesItem_Encoding_DefaultXml 377
#define OpcUaId_AddNodesResult_Encoding_DefaultXml 484
#define OpcUaId_AddNodesRequest_Encoding_DefaultXml 487
#define OpcUaId_AddNodesResponse_Encoding_DefaultXml 490
#define OpcUaId_AddReferencesItem_Encoding_DefaultXml 380
#define OpcUaId_AddReferencesRequest_Encoding_DefaultXml 493
#define OpcUaId_AddReferencesResponse_Encoding_DefaultXml 496
#define OpcUaId_DeleteNodesItem_Encoding_DefaultXml 383
#define OpcUaId_DeleteNodesRequest_Encoding_DefaultXml 499
#define OpcUaId_DeleteNodesResponse_Encoding_DefaultXml 502
#define OpcUaId_DeleteReferencesItem_Encoding_DefaultXml 386
#define OpcUaId_DeleteReferencesRequest_Encoding_DefaultXml 505
#define OpcUaId_DeleteReferencesResponse_Encoding_DefaultXml 508
#define OpcUaId_ViewDescription_Encoding_DefaultXml 512
#define OpcUaId_BrowseDescription_Encoding_DefaultXml 515
#define OpcUaId_ReferenceDescription_Encoding_DefaultXml 519
#define OpcUaId_BrowseResult_Encoding_DefaultXml 523
#define OpcUaId_BrowseRequest_Encoding_DefaultXml 526
#define OpcUaId_BrowseResponse_Encoding_DefaultXml 529
#define OpcUaId_BrowseNextRequest_Encoding_DefaultXml 532
#define OpcUaId_BrowseNextResponse_Encoding_DefaultXml 535
#define OpcUaId_RelativePathElement_Encoding_DefaultXml 538
#define OpcUaId_RelativePath_Encoding_DefaultXml 541
#define OpcUaId_BrowsePath_Encoding_DefaultXml 544
#define OpcUaId_BrowsePathTarget_Encoding_DefaultXml 547
#define OpcUaId_BrowsePathResult_Encoding_DefaultXml 550
#define OpcUaId_TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultXml 553
#define OpcUaId_TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultXml 556
#define OpcUaId_RegisterNodesRequest_Encoding_DefaultXml 559
#define OpcUaId_RegisterNodesResponse_Encoding_DefaultXml 562
#define OpcUaId_UnregisterNodesRequest_Encoding_DefaultXml 565
#define OpcUaId_UnregisterNodesResponse_Encoding_DefaultXml 568
#define OpcUaId_EndpointConfiguration_Encoding_DefaultXml 332
#define OpcUaId_QueryDataDescription_Encoding_DefaultXml 571
#define OpcUaId_NodeTypeDescription_Encoding_DefaultXml 574
#define OpcUaId_QueryDataSet_Encoding_DefaultXml 578
#define OpcUaId_NodeReference_Encoding_DefaultXml 581
#define OpcUaId_ContentFilterElement_Encoding_DefaultXml 584
#define OpcUaId_ContentFilter_Encoding_DefaultXml 587
#define OpcUaId_FilterOperand_Encoding_DefaultXml 590
#define OpcUaId_ElementOperand_Encoding_DefaultXml 593
#define OpcUaId_LiteralOperand_Encoding_DefaultXml 596
#define OpcUaId_AttributeOperand_Encoding_DefaultXml 599
#define OpcUaId_SimpleAttributeOperand_Encoding_DefaultXml 602
#define OpcUaId_ContentFilterElementResult_Encoding_DefaultXml 605
#define OpcUaId_ContentFilterResult_Encoding_DefaultXml 608
#define OpcUaId_ParsingResult_Encoding_DefaultXml 611
#define OpcUaId_QueryFirstRequest_Encoding_DefaultXml 614
#define OpcUaId_QueryFirstResponse_Encoding_DefaultXml 617
#define OpcUaId_QueryNextRequest_Encoding_DefaultXml 620
#define OpcUaId_QueryNextResponse_Encoding_DefaultXml 623
#define OpcUaId_ReadValueId_Encoding_DefaultXml 627
#define OpcUaId_ReadRequest_Encoding_DefaultXml 630
#define OpcUaId_ReadResponse_Encoding_DefaultXml 633
#define OpcUaId_HistoryReadValueId_Encoding_DefaultXml 636
#define OpcUaId_HistoryReadResult_Encoding_DefaultXml 639
#define OpcUaId_HistoryReadDetails_Encoding_DefaultXml 642
#define OpcUaId_ReadEventDetails_Encoding_DefaultXml 645
#define OpcUaId_ReadRawModifiedDetails_Encoding_DefaultXml 648
#define OpcUaId_ReadProcessedDetails_Encoding_DefaultXml 651
#define OpcUaId_ReadAtTimeDetails_Encoding_DefaultXml 654
#define OpcUaId_ReadAnnotationDataDetails_Encoding_DefaultXml 23506
#define OpcUaId_HistoryData_Encoding_DefaultXml 657
#define OpcUaId_ModificationInfo_Encoding_DefaultXml 11218
#define OpcUaId_HistoryModifiedData_Encoding_DefaultXml 11219
#define OpcUaId_HistoryEvent_Encoding_DefaultXml 660
#define OpcUaId_HistoryReadRequest_Encoding_DefaultXml 663
#define OpcUaId_HistoryReadResponse_Encoding_DefaultXml 666
#define OpcUaId_WriteValue_Encoding_DefaultXml 669
#define OpcUaId_WriteRequest_Encoding_DefaultXml 672
#define OpcUaId_WriteResponse_Encoding_DefaultXml 675
#define OpcUaId_HistoryUpdateDetails_Encoding_DefaultXml 678
#define OpcUaId_UpdateDataDetails_Encoding_DefaultXml 681
#define OpcUaId_UpdateStructureDataDetails_Encoding_DefaultXml 11296
#define OpcUaId_UpdateEventDetails_Encoding_DefaultXml 684
#define OpcUaId_DeleteRawModifiedDetails_Encoding_DefaultXml 687
#define OpcUaId_DeleteAtTimeDetails_Encoding_DefaultXml 690
#define OpcUaId_DeleteEventDetails_Encoding_DefaultXml 693
#define OpcUaId_HistoryUpdateResult_Encoding_DefaultXml 696
#define OpcUaId_HistoryUpdateRequest_Encoding_DefaultXml 699
#define OpcUaId_HistoryUpdateResponse_Encoding_DefaultXml 702
#define OpcUaId_CallMethodRequest_Encoding_DefaultXml 705
#define OpcUaId_CallMethodResult_Encoding_DefaultXml 708
#define OpcUaId_CallRequest_Encoding_DefaultXml 711
#define OpcUaId_CallResponse_Encoding_DefaultXml 714
#define OpcUaId_MonitoringFilter_Encoding_DefaultXml 720
#define OpcUaId_DataChangeFilter_Encoding_DefaultXml 723
#define OpcUaId_EventFilter_Encoding_DefaultXml 726
#define OpcUaId_AggregateConfiguration_Encoding_DefaultXml 949
#define OpcUaId_AggregateFilter_Encoding_DefaultXml 729
#define OpcUaId_MonitoringFilterResult_Encoding_DefaultXml 732
#define OpcUaId_EventFilterResult_Encoding_DefaultXml 735
#define OpcUaId_AggregateFilterResult_Encoding_DefaultXml 738
#define OpcUaId_MonitoringParameters_Encoding_DefaultXml 741
#define OpcUaId_MonitoredItemCreateRequest_Encoding_DefaultXml 744
#define OpcUaId_MonitoredItemCreateResult_Encoding_DefaultXml 747
#define OpcUaId_CreateMonitoredItemsRequest_Encoding_DefaultXml 750
#define OpcUaId_CreateMonitoredItemsResponse_Encoding_DefaultXml 753
#define OpcUaId_MonitoredItemModifyRequest_Encoding_DefaultXml 756
#define OpcUaId_MonitoredItemModifyResult_Encoding_DefaultXml 759
#define OpcUaId_ModifyMonitoredItemsRequest_Encoding_DefaultXml 762
#define OpcUaId_ModifyMonitoredItemsResponse_Encoding_DefaultXml 765
#define OpcUaId_SetMonitoringModeRequest_Encoding_DefaultXml 768
#define OpcUaId_SetMonitoringModeResponse_Encoding_DefaultXml 771
#define OpcUaId_SetTriggeringRequest_Encoding_DefaultXml 774
#define OpcUaId_SetTriggeringResponse_Encoding_DefaultXml 777
#define OpcUaId_DeleteMonitoredItemsRequest_Encoding_DefaultXml 780
#define OpcUaId_DeleteMonitoredItemsResponse_Encoding_DefaultXml 783
#define OpcUaId_CreateSubscriptionRequest_Encoding_DefaultXml 786
#define OpcUaId_CreateSubscriptionResponse_Encoding_DefaultXml 789
#define OpcUaId_ModifySubscriptionRequest_Encoding_DefaultXml 792
#define OpcUaId_ModifySubscriptionResponse_Encoding_DefaultXml 795
#define OpcUaId_SetPublishingModeRequest_Encoding_DefaultXml 798
#define OpcUaId_SetPublishingModeResponse_Encoding_DefaultXml 801
#define OpcUaId_NotificationMessage_Encoding_DefaultXml 804
#define OpcUaId_NotificationData_Encoding_DefaultXml 946
#define OpcUaId_DataChangeNotification_Encoding_DefaultXml 810
#define OpcUaId_MonitoredItemNotification_Encoding_DefaultXml 807
#define OpcUaId_EventNotificationList_Encoding_DefaultXml 915
#define OpcUaId_EventFieldList_Encoding_DefaultXml 918
#define OpcUaId_HistoryEventFieldList_Encoding_DefaultXml 921
#define OpcUaId_StatusChangeNotification_Encoding_DefaultXml 819
#define OpcUaId_SubscriptionAcknowledgement_Encoding_DefaultXml 822
#define OpcUaId_PublishRequest_Encoding_DefaultXml 825
#define OpcUaId_PublishResponse_Encoding_DefaultXml 828
#define OpcUaId_RepublishRequest_Encoding_DefaultXml 831
#define OpcUaId_RepublishResponse_Encoding_DefaultXml 834
#define OpcUaId_TransferResult_Encoding_DefaultXml 837
#define OpcUaId_TransferSubscriptionsRequest_Encoding_DefaultXml 840
#define OpcUaId_TransferSubscriptionsResponse_Encoding_DefaultXml 843
#define OpcUaId_DeleteSubscriptionsRequest_Encoding_DefaultXml 846
#define OpcUaId_DeleteSubscriptionsResponse_Encoding_DefaultXml 849
#define OpcUaId_BuildInfo_Encoding_DefaultXml 339
#define OpcUaId_RedundantServerDataType_Encoding_DefaultXml 854
#define OpcUaId_EndpointUrlListDataType_Encoding_DefaultXml 11949
#define OpcUaId_NetworkGroupDataType_Encoding_DefaultXml 11950
#define OpcUaId_SamplingIntervalDiagnosticsDataType_Encoding_DefaultXml 857
#define OpcUaId_ServerDiagnosticsSummaryDataType_Encoding_DefaultXml 860
#define OpcUaId_ServerStatusDataType_Encoding_DefaultXml 863
#define OpcUaId_SessionDiagnosticsDataType_Encoding_DefaultXml 866
#define OpcUaId_SessionSecurityDiagnosticsDataType_Encoding_DefaultXml 869
#define OpcUaId_ServiceCounterDataType_Encoding_DefaultXml 872
#define OpcUaId_StatusResult_Encoding_DefaultXml 300
#define OpcUaId_SubscriptionDiagnosticsDataType_Encoding_DefaultXml 875
#define OpcUaId_ModelChangeStructureDataType_Encoding_DefaultXml 878
#define OpcUaId_SemanticChangeStructureDataType_Encoding_DefaultXml 898
#define OpcUaId_Range_Encoding_DefaultXml 885
#define OpcUaId_EUInformation_Encoding_DefaultXml 888
#define OpcUaId_ComplexNumberType_Encoding_DefaultXml 12173
#define OpcUaId_DoubleComplexNumberType_Encoding_DefaultXml 12174
#define OpcUaId_AxisInformation_Encoding_DefaultXml 12081
#define OpcUaId_XVType_Encoding_DefaultXml 12082
#define OpcUaId_ProgramDiagnosticDataType_Encoding_DefaultXml 895
#define OpcUaId_ProgramDiagnostic2DataType_Encoding_DefaultXml 24038
#define OpcUaId_Annotation_Encoding_DefaultXml 892
#define OpcUaId_Union_Encoding_DefaultJson 15085
#define OpcUaId_KeyValuePair_Encoding_DefaultJson 15041
#define OpcUaId_AdditionalParametersType_Encoding_DefaultJson 17547
#define OpcUaId_EphemeralKeyType_Encoding_DefaultJson 17557
#define OpcUaId_EndpointType_Encoding_DefaultJson 16150
#define OpcUaId_RationalNumber_Encoding_DefaultJson 19064
#define OpcUaId_Vector_Encoding_DefaultJson 19065
#define OpcUaId_ThreeDVector_Encoding_DefaultJson 19066
#define OpcUaId_CartesianCoordinates_Encoding_DefaultJson 19067
#define OpcUaId_ThreeDCartesianCoordinates_Encoding_DefaultJson 19068
#define OpcUaId_Orientation_Encoding_DefaultJson 19069
#define OpcUaId_ThreeDOrientation_Encoding_DefaultJson 19070
#define OpcUaId_Frame_Encoding_DefaultJson 19071
#define OpcUaId_ThreeDFrame_Encoding_DefaultJson 19072
#define OpcUaId_IdentityMappingRuleType_Encoding_DefaultJson 15042
#define OpcUaId_CurrencyUnitType_Encoding_DefaultJson 23528
#define OpcUaId_TrustListDataType_Encoding_DefaultJson 15044
#define OpcUaId_TransactionErrorType_Encoding_DefaultJson 32390
#define OpcUaId_DecimalDataType_Encoding_DefaultJson 15045
#define OpcUaId_DataTypeSchemaHeader_Encoding_DefaultJson 16151
#define OpcUaId_DataTypeDescription_Encoding_DefaultJson 15057
#define OpcUaId_StructureDescription_Encoding_DefaultJson 15058
#define OpcUaId_EnumDescription_Encoding_DefaultJson 15059
#define OpcUaId_SimpleTypeDescription_Encoding_DefaultJson 15700
#define OpcUaId_UABinaryFileDataType_Encoding_DefaultJson 15714
#define OpcUaId_PortableQualifiedName_Encoding_DefaultJson 24132
#define OpcUaId_PortableNodeId_Encoding_DefaultJson 24133
#define OpcUaId_UnsignedRationalNumber_Encoding_DefaultJson 24134
#define OpcUaId_DataSetMetaDataType_Encoding_DefaultJson 15050
#define OpcUaId_FieldMetaData_Encoding_DefaultJson 15051
#define OpcUaId_ConfigurationVersionDataType_Encoding_DefaultJson 15049
#define OpcUaId_PublishedDataSetDataType_Encoding_DefaultJson 16152
#define OpcUaId_PublishedDataSetSourceDataType_Encoding_DefaultJson 16153
#define OpcUaId_PublishedVariableDataType_Encoding_DefaultJson 15060
#define OpcUaId_PublishedDataItemsDataType_Encoding_DefaultJson 16154
#define OpcUaId_PublishedEventsDataType_Encoding_DefaultJson 16155
#define OpcUaId_PublishedDataSetCustomSourceDataType_Encoding_DefaultJson 25561
#define OpcUaId_DataSetWriterDataType_Encoding_DefaultJson 16156
#define OpcUaId_DataSetWriterTransportDataType_Encoding_DefaultJson 16157
#define OpcUaId_DataSetWriterMessageDataType_Encoding_DefaultJson 16158
#define OpcUaId_PubSubGroupDataType_Encoding_DefaultJson 16159
#define OpcUaId_WriterGroupDataType_Encoding_DefaultJson 21198
#define OpcUaId_WriterGroupTransportDataType_Encoding_DefaultJson 16161
#define OpcUaId_WriterGroupMessageDataType_Encoding_DefaultJson 16280
#define OpcUaId_PubSubConnectionDataType_Encoding_DefaultJson 16281
#define OpcUaId_ConnectionTransportDataType_Encoding_DefaultJson 16282
#define OpcUaId_NetworkAddressDataType_Encoding_DefaultJson 21199
#define OpcUaId_NetworkAddressUrlDataType_Encoding_DefaultJson 21200
#define OpcUaId_ReaderGroupDataType_Encoding_DefaultJson 21201
#define OpcUaId_ReaderGroupTransportDataType_Encoding_DefaultJson 16284
#define OpcUaId_ReaderGroupMessageDataType_Encoding_DefaultJson 16285
#define OpcUaId_DataSetReaderDataType_Encoding_DefaultJson 16286
#define OpcUaId_DataSetReaderTransportDataType_Encoding_DefaultJson 16287
#define OpcUaId_DataSetReaderMessageDataType_Encoding_DefaultJson 16288
#define OpcUaId_SubscribedDataSetDataType_Encoding_DefaultJson 16308
#define OpcUaId_TargetVariablesDataType_Encoding_DefaultJson 16310
#define OpcUaId_FieldTargetDataType_Encoding_DefaultJson 15061
#define OpcUaId_SubscribedDataSetMirrorDataType_Encoding_DefaultJson 16311
#define OpcUaId_PubSubConfigurationDataType_Encoding_DefaultJson 21202
#define OpcUaId_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultJson 23987
#define OpcUaId_StandaloneSubscribedDataSetDataType_Encoding_DefaultJson 23988
#define OpcUaId_SecurityGroupDataType_Encoding_DefaultJson 23989
#define OpcUaId_PubSubKeyPushTargetDataType_Encoding_DefaultJson 25562
#define OpcUaId_PubSubConfiguration2DataType_Encoding_DefaultJson 23990
#define OpcUaId_UadpWriterGroupMessageDataType_Encoding_DefaultJson 16323
#define OpcUaId_UadpDataSetWriterMessageDataType_Encoding_DefaultJson 16391
#define OpcUaId_UadpDataSetReaderMessageDataType_Encoding_DefaultJson 16392
#define OpcUaId_JsonWriterGroupMessageDataType_Encoding_DefaultJson 16393
#define OpcUaId_JsonDataSetWriterMessageDataType_Encoding_DefaultJson 16394
#define OpcUaId_JsonDataSetReaderMessageDataType_Encoding_DefaultJson 16404
#define OpcUaId_QosDataType_Encoding_DefaultJson 23991
#define OpcUaId_TransmitQosDataType_Encoding_DefaultJson 23992
#define OpcUaId_TransmitQosPriorityDataType_Encoding_DefaultJson 23993
#define OpcUaId_ReceiveQosDataType_Encoding_DefaultJson 23996
#define OpcUaId_ReceiveQosPriorityDataType_Encoding_DefaultJson 23997
#define OpcUaId_DatagramConnectionTransportDataType_Encoding_DefaultJson 17476
#define OpcUaId_DatagramConnectionTransport2DataType_Encoding_DefaultJson 24000
#define OpcUaId_DatagramWriterGroupTransportDataType_Encoding_DefaultJson 21203
#define OpcUaId_DatagramWriterGroupTransport2DataType_Encoding_DefaultJson 24001
#define OpcUaId_DatagramDataSetReaderTransportDataType_Encoding_DefaultJson 24002
#define OpcUaId_BrokerConnectionTransportDataType_Encoding_DefaultJson 15726
#define OpcUaId_BrokerWriterGroupTransportDataType_Encoding_DefaultJson 16524
#define OpcUaId_BrokerDataSetWriterTransportDataType_Encoding_DefaultJson 16525
#define OpcUaId_BrokerDataSetReaderTransportDataType_Encoding_DefaultJson 16526
#define OpcUaId_PubSubConfigurationRefDataType_Encoding_DefaultJson 25563
#define OpcUaId_PubSubConfigurationValueDataType_Encoding_DefaultJson 25564
#define OpcUaId_AliasNameDataType_Encoding_DefaultJson 23511
#define OpcUaId_UserManagementDataType_Encoding_DefaultJson 24300
#define OpcUaId_PriorityMappingEntryType_Encoding_DefaultJson 25247
#define OpcUaId_ReferenceDescriptionDataType_Encoding_DefaultJson 32677
#define OpcUaId_ReferenceListEntryDataType_Encoding_DefaultJson 32678
#define OpcUaId_RolePermissionType_Encoding_DefaultJson 15062
#define OpcUaId_DataTypeDefinition_Encoding_DefaultJson 15063
#define OpcUaId_StructureField_Encoding_DefaultJson 15065
#define OpcUaId_StructureDefinition_Encoding_DefaultJson 15066
#define OpcUaId_EnumDefinition_Encoding_DefaultJson 15067
#define OpcUaId_Node_Encoding_DefaultJson 15068
#define OpcUaId_InstanceNode_Encoding_DefaultJson 15069
#define OpcUaId_TypeNode_Encoding_DefaultJson 15070
#define OpcUaId_ObjectNode_Encoding_DefaultJson 15071
#define OpcUaId_ObjectTypeNode_Encoding_DefaultJson 15073
#define OpcUaId_VariableNode_Encoding_DefaultJson 15074
#define OpcUaId_VariableTypeNode_Encoding_DefaultJson 15075
#define OpcUaId_ReferenceTypeNode_Encoding_DefaultJson 15076
#define OpcUaId_MethodNode_Encoding_DefaultJson 15077
#define OpcUaId_ViewNode_Encoding_DefaultJson 15078
#define OpcUaId_DataTypeNode_Encoding_DefaultJson 15079
#define OpcUaId_ReferenceNode_Encoding_DefaultJson 15080
#define OpcUaId_Argument_Encoding_DefaultJson 15081
#define OpcUaId_EnumValueType_Encoding_DefaultJson 15082
#define OpcUaId_EnumField_Encoding_DefaultJson 15083
#define OpcUaId_OptionSet_Encoding_DefaultJson 15084
#define OpcUaId_TimeZoneDataType_Encoding_DefaultJson 15086
#define OpcUaId_ApplicationDescription_Encoding_DefaultJson 15087
#define OpcUaId_RequestHeader_Encoding_DefaultJson 15088
#define OpcUaId_ResponseHeader_Encoding_DefaultJson 15089
#define OpcUaId_ServiceFault_Encoding_DefaultJson 15090
#define OpcUaId_SessionlessInvokeRequestType_Encoding_DefaultJson 15091
#define OpcUaId_SessionlessInvokeResponseType_Encoding_DefaultJson 15092
#define OpcUaId_FindServersRequest_Encoding_DefaultJson 15093
#define OpcUaId_FindServersResponse_Encoding_DefaultJson 15094
#define OpcUaId_ServerOnNetwork_Encoding_DefaultJson 15095
#define OpcUaId_FindServersOnNetworkRequest_Encoding_DefaultJson 15096
#define OpcUaId_FindServersOnNetworkResponse_Encoding_DefaultJson 15097
#define OpcUaId_UserTokenPolicy_Encoding_DefaultJson 15098
#define OpcUaId_EndpointDescription_Encoding_DefaultJson 15099
#define OpcUaId_GetEndpointsRequest_Encoding_DefaultJson 15100
#define OpcUaId_GetEndpointsResponse_Encoding_DefaultJson 15101
#define OpcUaId_RegisteredServer_Encoding_DefaultJson 15102
#define OpcUaId_RegisterServerRequest_Encoding_DefaultJson 15103
#define OpcUaId_RegisterServerResponse_Encoding_DefaultJson 15104
#define OpcUaId_DiscoveryConfiguration_Encoding_DefaultJson 15105
#define OpcUaId_MdnsDiscoveryConfiguration_Encoding_DefaultJson 15106
#define OpcUaId_RegisterServer2Request_Encoding_DefaultJson 15107
#define OpcUaId_RegisterServer2Response_Encoding_DefaultJson 15130
#define OpcUaId_ChannelSecurityToken_Encoding_DefaultJson 15131
#define OpcUaId_OpenSecureChannelRequest_Encoding_DefaultJson 15132
#define OpcUaId_OpenSecureChannelResponse_Encoding_DefaultJson 15133
#define OpcUaId_CloseSecureChannelRequest_Encoding_DefaultJson 15134
#define OpcUaId_CloseSecureChannelResponse_Encoding_DefaultJson 15135
#define OpcUaId_SignedSoftwareCertificate_Encoding_DefaultJson 15136
#define OpcUaId_SignatureData_Encoding_DefaultJson 15137
#define OpcUaId_CreateSessionRequest_Encoding_DefaultJson 15138
#define OpcUaId_CreateSessionResponse_Encoding_DefaultJson 15139
#define OpcUaId_UserIdentityToken_Encoding_DefaultJson 15140
#define OpcUaId_AnonymousIdentityToken_Encoding_DefaultJson 15141
#define OpcUaId_UserNameIdentityToken_Encoding_DefaultJson 15142
#define OpcUaId_X509IdentityToken_Encoding_DefaultJson 15143
#define OpcUaId_IssuedIdentityToken_Encoding_DefaultJson 15144
#define OpcUaId_ActivateSessionRequest_Encoding_DefaultJson 15145
#define OpcUaId_ActivateSessionResponse_Encoding_DefaultJson 15146
#define OpcUaId_CloseSessionRequest_Encoding_DefaultJson 15147
#define OpcUaId_CloseSessionResponse_Encoding_DefaultJson 15148
#define OpcUaId_CancelRequest_Encoding_DefaultJson 15149
#define OpcUaId_CancelResponse_Encoding_DefaultJson 15150
#define OpcUaId_NodeAttributes_Encoding_DefaultJson 15151
#define OpcUaId_ObjectAttributes_Encoding_DefaultJson 15152
#define OpcUaId_VariableAttributes_Encoding_DefaultJson 15153
#define OpcUaId_MethodAttributes_Encoding_DefaultJson 15157
#define OpcUaId_ObjectTypeAttributes_Encoding_DefaultJson 15158
#define OpcUaId_VariableTypeAttributes_Encoding_DefaultJson 15159
#define OpcUaId_ReferenceTypeAttributes_Encoding_DefaultJson 15160
#define OpcUaId_DataTypeAttributes_Encoding_DefaultJson 15161
#define OpcUaId_ViewAttributes_Encoding_DefaultJson 15162
#define OpcUaId_GenericAttributeValue_Encoding_DefaultJson 15163
#define OpcUaId_GenericAttributes_Encoding_DefaultJson 15164
#define OpcUaId_AddNodesItem_Encoding_DefaultJson 15165
#define OpcUaId_AddNodesResult_Encoding_DefaultJson 15166
#define OpcUaId_AddNodesRequest_Encoding_DefaultJson 15167
#define OpcUaId_AddNodesResponse_Encoding_DefaultJson 15168
#define OpcUaId_AddReferencesItem_Encoding_DefaultJson 15169
#define OpcUaId_AddReferencesRequest_Encoding_DefaultJson 15170
#define OpcUaId_AddReferencesResponse_Encoding_DefaultJson 15171
#define OpcUaId_DeleteNodesItem_Encoding_DefaultJson 15172
#define OpcUaId_DeleteNodesRequest_Encoding_DefaultJson 15173
#define OpcUaId_DeleteNodesResponse_Encoding_DefaultJson 15174
#define OpcUaId_DeleteReferencesItem_Encoding_DefaultJson 15175
#define OpcUaId_DeleteReferencesRequest_Encoding_DefaultJson 15176
#define OpcUaId_DeleteReferencesResponse_Encoding_DefaultJson 15177
#define OpcUaId_ViewDescription_Encoding_DefaultJson 15179
#define OpcUaId_BrowseDescription_Encoding_DefaultJson 15180
#define OpcUaId_ReferenceDescription_Encoding_DefaultJson 15182
#define OpcUaId_BrowseResult_Encoding_DefaultJson 15183
#define OpcUaId_BrowseRequest_Encoding_DefaultJson 15184
#define OpcUaId_BrowseResponse_Encoding_DefaultJson 15185
#define OpcUaId_BrowseNextRequest_Encoding_DefaultJson 15186
#define OpcUaId_BrowseNextResponse_Encoding_DefaultJson 15187
#define OpcUaId_RelativePathElement_Encoding_DefaultJson 15188
#define OpcUaId_RelativePath_Encoding_DefaultJson 15189
#define OpcUaId_BrowsePath_Encoding_DefaultJson 15190
#define OpcUaId_BrowsePathTarget_Encoding_DefaultJson 15191
#define OpcUaId_BrowsePathResult_Encoding_DefaultJson 15192
#define OpcUaId_TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultJson 15193
#define OpcUaId_TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultJson 15194
#define OpcUaId_RegisterNodesRequest_Encoding_DefaultJson 15195
#define OpcUaId_RegisterNodesResponse_Encoding_DefaultJson 15196
#define OpcUaId_UnregisterNodesRequest_Encoding_DefaultJson 15197
#define OpcUaId_UnregisterNodesResponse_Encoding_DefaultJson 15198
#define OpcUaId_EndpointConfiguration_Encoding_DefaultJson 15199
#define OpcUaId_QueryDataDescription_Encoding_DefaultJson 15200
#define OpcUaId_NodeTypeDescription_Encoding_DefaultJson 15201
#define OpcUaId_QueryDataSet_Encoding_DefaultJson 15202
#define OpcUaId_NodeReference_Encoding_DefaultJson 15203
#define OpcUaId_ContentFilterElement_Encoding_DefaultJson 15204
#define OpcUaId_ContentFilter_Encoding_DefaultJson 15205
#define OpcUaId_FilterOperand_Encoding_DefaultJson 15206
#define OpcUaId_ElementOperand_Encoding_DefaultJson 15207
#define OpcUaId_LiteralOperand_Encoding_DefaultJson 15208
#define OpcUaId_AttributeOperand_Encoding_DefaultJson 15209
#define OpcUaId_SimpleAttributeOperand_Encoding_DefaultJson 15210
#define OpcUaId_ContentFilterElementResult_Encoding_DefaultJson 15211
#define OpcUaId_ContentFilterResult_Encoding_DefaultJson 15228
#define OpcUaId_ParsingResult_Encoding_DefaultJson 15236
#define OpcUaId_QueryFirstRequest_Encoding_DefaultJson 15244
#define OpcUaId_QueryFirstResponse_Encoding_DefaultJson 15252
#define OpcUaId_QueryNextRequest_Encoding_DefaultJson 15254
#define OpcUaId_QueryNextResponse_Encoding_DefaultJson 15255
#define OpcUaId_ReadValueId_Encoding_DefaultJson 15256
#define OpcUaId_ReadRequest_Encoding_DefaultJson 15257
#define OpcUaId_ReadResponse_Encoding_DefaultJson 15258
#define OpcUaId_HistoryReadValueId_Encoding_DefaultJson 15259
#define OpcUaId_HistoryReadResult_Encoding_DefaultJson 15260
#define OpcUaId_HistoryReadDetails_Encoding_DefaultJson 15261
#define OpcUaId_ReadEventDetails_Encoding_DefaultJson 15262
#define OpcUaId_ReadRawModifiedDetails_Encoding_DefaultJson 15263
#define OpcUaId_ReadProcessedDetails_Encoding_DefaultJson 15264
#define OpcUaId_ReadAtTimeDetails_Encoding_DefaultJson 15269
#define OpcUaId_ReadAnnotationDataDetails_Encoding_DefaultJson 23512
#define OpcUaId_HistoryData_Encoding_DefaultJson 15270
#define OpcUaId_ModificationInfo_Encoding_DefaultJson 15271
#define OpcUaId_HistoryModifiedData_Encoding_DefaultJson 15272
#define OpcUaId_HistoryEvent_Encoding_DefaultJson 15273
#define OpcUaId_HistoryReadRequest_Encoding_DefaultJson 15274
#define OpcUaId_HistoryReadResponse_Encoding_DefaultJson 15275
#define OpcUaId_WriteValue_Encoding_DefaultJson 15276
#define OpcUaId_WriteRequest_Encoding_DefaultJson 15277
#define OpcUaId_WriteResponse_Encoding_DefaultJson 15278
#define OpcUaId_HistoryUpdateDetails_Encoding_DefaultJson 15279
#define OpcUaId_UpdateDataDetails_Encoding_DefaultJson 15280
#define OpcUaId_UpdateStructureDataDetails_Encoding_DefaultJson 15281
#define OpcUaId_UpdateEventDetails_Encoding_DefaultJson 15282
#define OpcUaId_DeleteRawModifiedDetails_Encoding_DefaultJson 15283
#define OpcUaId_DeleteAtTimeDetails_Encoding_DefaultJson 15284
#define OpcUaId_DeleteEventDetails_Encoding_DefaultJson 15285
#define OpcUaId_HistoryUpdateResult_Encoding_DefaultJson 15286
#define OpcUaId_HistoryUpdateRequest_Encoding_DefaultJson 15287
#define OpcUaId_HistoryUpdateResponse_Encoding_DefaultJson 15288
#define OpcUaId_CallMethodRequest_Encoding_DefaultJson 15289
#define OpcUaId_CallMethodResult_Encoding_DefaultJson 15290
#define OpcUaId_CallRequest_Encoding_DefaultJson 15291
#define OpcUaId_CallResponse_Encoding_DefaultJson 15292
#define OpcUaId_MonitoringFilter_Encoding_DefaultJson 15293
#define OpcUaId_DataChangeFilter_Encoding_DefaultJson 15294
#define OpcUaId_EventFilter_Encoding_DefaultJson 15295
#define OpcUaId_AggregateConfiguration_Encoding_DefaultJson 15304
#define OpcUaId_AggregateFilter_Encoding_DefaultJson 15312
#define OpcUaId_MonitoringFilterResult_Encoding_DefaultJson 15313
#define OpcUaId_EventFilterResult_Encoding_DefaultJson 15314
#define OpcUaId_AggregateFilterResult_Encoding_DefaultJson 15315
#define OpcUaId_MonitoringParameters_Encoding_DefaultJson 15320
#define OpcUaId_MonitoredItemCreateRequest_Encoding_DefaultJson 15321
#define OpcUaId_MonitoredItemCreateResult_Encoding_DefaultJson 15322
#define OpcUaId_CreateMonitoredItemsRequest_Encoding_DefaultJson 15323
#define OpcUaId_CreateMonitoredItemsResponse_Encoding_DefaultJson 15324
#define OpcUaId_MonitoredItemModifyRequest_Encoding_DefaultJson 15325
#define OpcUaId_MonitoredItemModifyResult_Encoding_DefaultJson 15326
#define OpcUaId_ModifyMonitoredItemsRequest_Encoding_DefaultJson 15327
#define OpcUaId_ModifyMonitoredItemsResponse_Encoding_DefaultJson 15328
#define OpcUaId_SetMonitoringModeRequest_Encoding_DefaultJson 15329
#define OpcUaId_SetMonitoringModeResponse_Encoding_DefaultJson 15331
#define OpcUaId_SetTriggeringRequest_Encoding_DefaultJson 15332
#define OpcUaId_SetTriggeringResponse_Encoding_DefaultJson 15333
#define OpcUaId_DeleteMonitoredItemsRequest_Encoding_DefaultJson 15335
#define OpcUaId_DeleteMonitoredItemsResponse_Encoding_DefaultJson 15336
#define OpcUaId_CreateSubscriptionRequest_Encoding_DefaultJson 15337
#define OpcUaId_CreateSubscriptionResponse_Encoding_DefaultJson 15338
#define OpcUaId_ModifySubscriptionRequest_Encoding_DefaultJson 15339
#define OpcUaId_ModifySubscriptionResponse_Encoding_DefaultJson 15340
#define OpcUaId_SetPublishingModeRequest_Encoding_DefaultJson 15341
#define OpcUaId_SetPublishingModeResponse_Encoding_DefaultJson 15342
#define OpcUaId_NotificationMessage_Encoding_DefaultJson 15343
#define OpcUaId_NotificationData_Encoding_DefaultJson 15344
#define OpcUaId_DataChangeNotification_Encoding_DefaultJson 15345
#define OpcUaId_MonitoredItemNotification_Encoding_DefaultJson 15346
#define OpcUaId_EventNotificationList_Encoding_DefaultJson 15347
#define OpcUaId_EventFieldList_Encoding_DefaultJson 15348
#define OpcUaId_HistoryEventFieldList_Encoding_DefaultJson 15349
#define OpcUaId_StatusChangeNotification_Encoding_DefaultJson 15350
#define OpcUaId_SubscriptionAcknowledgement_Encoding_DefaultJson 15351
#define OpcUaId_PublishRequest_Encoding_DefaultJson 15352
#define OpcUaId_PublishResponse_Encoding_DefaultJson 15353
#define OpcUaId_RepublishRequest_Encoding_DefaultJson 15354
#define OpcUaId_RepublishResponse_Encoding_DefaultJson 15355
#define OpcUaId_TransferResult_Encoding_DefaultJson 15356
#define OpcUaId_TransferSubscriptionsRequest_Encoding_DefaultJson 15357
#define OpcUaId_TransferSubscriptionsResponse_Encoding_DefaultJson 15358
#define OpcUaId_DeleteSubscriptionsRequest_Encoding_DefaultJson 15359
#define OpcUaId_DeleteSubscriptionsResponse_Encoding_DefaultJson 15360
#define OpcUaId_BuildInfo_Encoding_DefaultJson 15361
#define OpcUaId_RedundantServerDataType_Encoding_DefaultJson 15362
#define OpcUaId_EndpointUrlListDataType_Encoding_DefaultJson 15363
#define OpcUaId_NetworkGroupDataType_Encoding_DefaultJson 15364
#define OpcUaId_SamplingIntervalDiagnosticsDataType_Encoding_DefaultJson 15365
#define OpcUaId_ServerDiagnosticsSummaryDataType_Encoding_DefaultJson 15366
#define OpcUaId_ServerStatusDataType_Encoding_DefaultJson 15367
#define OpcUaId_SessionDiagnosticsDataType_Encoding_DefaultJson 15368
#define OpcUaId_SessionSecurityDiagnosticsDataType_Encoding_DefaultJson 15369
#define OpcUaId_ServiceCounterDataType_Encoding_DefaultJson 15370
#define OpcUaId_StatusResult_Encoding_DefaultJson 15371
#define OpcUaId_SubscriptionDiagnosticsDataType_Encoding_DefaultJson 15372
#define OpcUaId_ModelChangeStructureDataType_Encoding_DefaultJson 15373
#define OpcUaId_SemanticChangeStructureDataType_Encoding_DefaultJson 15374
#define OpcUaId_Range_Encoding_DefaultJson 15375
#define OpcUaId_EUInformation_Encoding_DefaultJson 15376
#define OpcUaId_ComplexNumberType_Encoding_DefaultJson 15377
#define OpcUaId_DoubleComplexNumberType_Encoding_DefaultJson 15378
#define OpcUaId_AxisInformation_Encoding_DefaultJson 15379
#define OpcUaId_XVType_Encoding_DefaultJson 15380
#define OpcUaId_ProgramDiagnosticDataType_Encoding_DefaultJson 15381
#define OpcUaId_ProgramDiagnostic2DataType_Encoding_DefaultJson 24042
#define OpcUaId_Annotation_Encoding_DefaultJson 15382

/*============================================================================
* ObjectType Identifiers
 *===========================================================================*/
#define OpcUaId_BaseObjectType 58
#define OpcUaId_FolderType 61
#define OpcUaId_DataTypeSystemType 75
#define OpcUaId_DataTypeEncodingType 76
#define OpcUaId_ModellingRuleType 77
#define OpcUaId_ServerType 2004
#define OpcUaId_ServerCapabilitiesType 2013
#define OpcUaId_ServerDiagnosticsType 2020
#define OpcUaId_SessionsDiagnosticsSummaryType 2026
#define OpcUaId_SessionDiagnosticsObjectType 2029
#define OpcUaId_VendorServerInfoType 2033
#define OpcUaId_ServerRedundancyType 2034
#define OpcUaId_TransparentRedundancyType 2036
#define OpcUaId_NonTransparentRedundancyType 2039
#define OpcUaId_NonTransparentNetworkRedundancyType 11945
#define OpcUaId_OperationLimitsType 11564
#define OpcUaId_FileType 11575
#define OpcUaId_AddressSpaceFileType 11595
#define OpcUaId_NamespaceMetadataType 11616
#define OpcUaId_NamespacesType 11645
#define OpcUaId_BaseEventType 2041
#define OpcUaId_AuditEventType 2052
#define OpcUaId_AuditSecurityEventType 2058
#define OpcUaId_AuditChannelEventType 2059
#define OpcUaId_AuditOpenSecureChannelEventType 2060
#define OpcUaId_AuditSessionEventType 2069
#define OpcUaId_AuditCreateSessionEventType 2071
#define OpcUaId_AuditUrlMismatchEventType 2748
#define OpcUaId_AuditActivateSessionEventType 2075
#define OpcUaId_AuditCancelEventType 2078
#define OpcUaId_AuditCertificateEventType 2080
#define OpcUaId_AuditCertificateDataMismatchEventType 2082
#define OpcUaId_AuditCertificateExpiredEventType 2085
#define OpcUaId_AuditCertificateInvalidEventType 2086
#define OpcUaId_AuditCertificateUntrustedEventType 2087
#define OpcUaId_AuditCertificateRevokedEventType 2088
#define OpcUaId_AuditCertificateMismatchEventType 2089
#define OpcUaId_AuditNodeManagementEventType 2090
#define OpcUaId_AuditAddNodesEventType 2091
#define OpcUaId_AuditDeleteNodesEventType 2093
#define OpcUaId_AuditAddReferencesEventType 2095
#define OpcUaId_AuditDeleteReferencesEventType 2097
#define OpcUaId_AuditUpdateEventType 2099
#define OpcUaId_AuditWriteUpdateEventType 2100
#define OpcUaId_AuditHistoryUpdateEventType 2104
#define OpcUaId_AuditUpdateMethodEventType 2127
#define OpcUaId_SystemEventType 2130
#define OpcUaId_DeviceFailureEventType 2131
#define OpcUaId_SystemStatusChangeEventType 11446
#define OpcUaId_BaseModelChangeEventType 2132
#define OpcUaId_GeneralModelChangeEventType 2133
#define OpcUaId_SemanticChangeEventType 2738
#define OpcUaId_EventQueueOverflowEventType 3035
#define OpcUaId_ProgressEventType 11436
#define OpcUaId_AuditClientEventType 23606
#define OpcUaId_AuditClientUpdateMethodResultEventType 23926
#define OpcUaId_AggregateFunctionType 2340
#define OpcUaId_StateMachineType 2299
#define OpcUaId_FiniteStateMachineType 2771
#define OpcUaId_StateType 2307
#define OpcUaId_InitialStateType 2309
#define OpcUaId_TransitionType 2310
#define OpcUaId_ChoiceStateType 15109
#define OpcUaId_TransitionEventType 2311
#define OpcUaId_AuditUpdateStateEventType 2315
#define OpcUaId_FileDirectoryType 13353
#define OpcUaId_TemporaryFileTransferType 15744
#define OpcUaId_FileTransferStateMachineType 15803
#define OpcUaId_RoleSetType 15607
#define OpcUaId_RoleType 15620
#define OpcUaId_RoleMappingRuleChangedAuditEventType 17641
#define OpcUaId_DictionaryEntryType 17589
#define OpcUaId_DictionaryFolderType 17591
#define OpcUaId_IrdiDictionaryEntryType 17598
#define OpcUaId_UriDictionaryEntryType 17600
#define OpcUaId_BaseInterfaceType 17602
#define OpcUaId_IOrderedObjectType 23513
#define OpcUaId_OrderedListType 23518
#define OpcUaId_ConditionType 2782
#define OpcUaId_DialogConditionType 2830
#define OpcUaId_AcknowledgeableConditionType 2881
#define OpcUaId_AlarmConditionType 2915
#define OpcUaId_AlarmGroupType 16405
#define OpcUaId_AlarmSuppressionGroupType 32064
#define OpcUaId_ShelvedStateMachineType 2929
#define OpcUaId_LimitAlarmType 2955
#define OpcUaId_ExclusiveLimitStateMachineType 9318
#define OpcUaId_ExclusiveLimitAlarmType 9341
#define OpcUaId_NonExclusiveLimitAlarmType 9906
#define OpcUaId_NonExclusiveLevelAlarmType 10060
#define OpcUaId_ExclusiveLevelAlarmType 9482
#define OpcUaId_NonExclusiveDeviationAlarmType 10368
#define OpcUaId_NonExclusiveRateOfChangeAlarmType 10214
#define OpcUaId_ExclusiveDeviationAlarmType 9764
#define OpcUaId_ExclusiveRateOfChangeAlarmType 9623
#define OpcUaId_DiscreteAlarmType 10523
#define OpcUaId_OffNormalAlarmType 10637
#define OpcUaId_SystemOffNormalAlarmType 11753
#define OpcUaId_TripAlarmType 10751
#define OpcUaId_InstrumentDiagnosticAlarmType 18347
#define OpcUaId_SystemDiagnosticAlarmType 18496
#define OpcUaId_CertificateExpirationAlarmType 13225
#define OpcUaId_DiscrepancyAlarmType 17080
#define OpcUaId_BaseConditionClassType 11163
#define OpcUaId_ProcessConditionClassType 11164
#define OpcUaId_MaintenanceConditionClassType 11165
#define OpcUaId_SystemConditionClassType 11166
#define OpcUaId_SafetyConditionClassType 17218
#define OpcUaId_HighlyManagedAlarmConditionClassType 17219
#define OpcUaId_TrainingConditionClassType 17220
#define OpcUaId_StatisticalConditionClassType 18665
#define OpcUaId_TestingConditionClassType 17221
#define OpcUaId_AuditConditionEventType 2790
#define OpcUaId_AuditConditionEnableEventType 2803
#define OpcUaId_AuditConditionCommentEventType 2829
#define OpcUaId_AuditConditionRespondEventType 8927
#define OpcUaId_AuditConditionAcknowledgeEventType 8944
#define OpcUaId_AuditConditionConfirmEventType 8961
#define OpcUaId_AuditConditionShelvingEventType 11093
#define OpcUaId_AuditConditionSuppressionEventType 17225
#define OpcUaId_AuditConditionSilenceEventType 17242
#define OpcUaId_AuditConditionResetEventType 15013
#define OpcUaId_AuditConditionOutOfServiceEventType 17259
#define OpcUaId_RefreshStartEventType 2787
#define OpcUaId_RefreshEndEventType 2788
#define OpcUaId_RefreshRequiredEventType 2789
#define OpcUaId_AlarmMetricsType 17279
#define OpcUaId_ProgramStateMachineType 2391
#define OpcUaId_ProgramTransitionEventType 2378
#define OpcUaId_AuditProgramTransitionEventType 11856
#define OpcUaId_ProgramTransitionAuditEventType 3806
#define OpcUaId_HistoricalDataConfigurationType 2318
#define OpcUaId_HistoryServerCapabilitiesType 2330
#define OpcUaId_AuditHistoryEventUpdateEventType 2999
#define OpcUaId_AuditHistoryValueUpdateEventType 3006
#define OpcUaId_AuditHistoryAnnotationUpdateEventType 19095
#define OpcUaId_AuditHistoryDeleteEventType 3012
#define OpcUaId_AuditHistoryRawModifyDeleteEventType 3014
#define OpcUaId_AuditHistoryAtTimeDeleteEventType 3019
#define OpcUaId_AuditHistoryEventDeleteEventType 3022
#define OpcUaId_TrustListType 12522
#define OpcUaId_TrustListOutOfDateAlarmType 19297
#define OpcUaId_CertificateGroupType 12555
#define OpcUaId_CertificateGroupFolderType 13813
#define OpcUaId_CertificateType 12556
#define OpcUaId_ApplicationCertificateType 12557
#define OpcUaId_HttpsCertificateType 12558
#define OpcUaId_UserCredentialCertificateType 15181
#define OpcUaId_RsaMinApplicationCertificateType 12559
#define OpcUaId_RsaSha256ApplicationCertificateType 12560
#define OpcUaId_EccApplicationCertificateType 23537
#define OpcUaId_EccNistP256ApplicationCertificateType 23538
#define OpcUaId_EccNistP384ApplicationCertificateType 23539
#define OpcUaId_EccBrainpoolP256r1ApplicationCertificateType 23540
#define OpcUaId_EccBrainpoolP384r1ApplicationCertificateType 23541
#define OpcUaId_EccCurve25519ApplicationCertificateType 23542
#define OpcUaId_EccCurve448ApplicationCertificateType 23543
#define OpcUaId_TrustListUpdateRequestedAuditEventType 32260
#define OpcUaId_TrustListUpdatedAuditEventType 12561
#define OpcUaId_TransactionDiagnosticsType 32286
#define OpcUaId_ServerConfigurationType 12581
#define OpcUaId_CertificateUpdateRequestedAuditEventType 32306
#define OpcUaId_CertificateUpdatedAuditEventType 12620
#define OpcUaId_KeyCredentialConfigurationFolderType 17496
#define OpcUaId_KeyCredentialConfigurationType 18001
#define OpcUaId_KeyCredentialAuditEventType 18011
#define OpcUaId_KeyCredentialUpdatedAuditEventType 18029
#define OpcUaId_KeyCredentialDeletedAuditEventType 18047
#define OpcUaId_AuthorizationServicesConfigurationFolderType 23556
#define OpcUaId_AuthorizationServiceConfigurationType 17852
#define OpcUaId_AggregateConfigurationType 11187
#define OpcUaId_PubSubKeyServiceType 15906
#define OpcUaId_SecurityGroupFolderType 15452
#define OpcUaId_SecurityGroupType 15471
#define OpcUaId_PubSubKeyPushTargetType 25337
#define OpcUaId_PubSubKeyPushTargetFolderType 25346
#define OpcUaId_PublishSubscribeType 14416
#define OpcUaId_PubSubConfigurationType 25482
#define OpcUaId_PublishedDataSetType 14509
#define OpcUaId_ExtensionFieldsType 15489
#define OpcUaId_PublishedDataItemsType 14534
#define OpcUaId_PublishedEventsType 14572
#define OpcUaId_DataSetFolderType 14477
#define OpcUaId_PubSubConnectionType 14209
#define OpcUaId_ConnectionTransportType 17721
#define OpcUaId_PubSubGroupType 14232
#define OpcUaId_WriterGroupType 17725
#define OpcUaId_WriterGroupTransportType 17997
#define OpcUaId_WriterGroupMessageType 17998
#define OpcUaId_ReaderGroupType 17999
#define OpcUaId_ReaderGroupTransportType 21090
#define OpcUaId_ReaderGroupMessageType 21091
#define OpcUaId_DataSetWriterType 15298
#define OpcUaId_DataSetWriterTransportType 15305
#define OpcUaId_DataSetWriterMessageType 21096
#define OpcUaId_DataSetReaderType 15306
#define OpcUaId_DataSetReaderTransportType 15319
#define OpcUaId_DataSetReaderMessageType 21104
#define OpcUaId_SubscribedDataSetType 15108
#define OpcUaId_TargetVariablesType 15111
#define OpcUaId_SubscribedDataSetMirrorType 15127
#define OpcUaId_SubscribedDataSetFolderType 23795
#define OpcUaId_StandaloneSubscribedDataSetType 23828
#define OpcUaId_PubSubStatusType 14643
#define OpcUaId_PubSubDiagnosticsType 19677
#define OpcUaId_PubSubDiagnosticsRootType 19732
#define OpcUaId_PubSubDiagnosticsConnectionType 19786
#define OpcUaId_PubSubDiagnosticsWriterGroupType 19834
#define OpcUaId_PubSubDiagnosticsReaderGroupType 19903
#define OpcUaId_PubSubDiagnosticsDataSetWriterType 19968
#define OpcUaId_PubSubDiagnosticsDataSetReaderType 20027
#define OpcUaId_PubSubCapabilitiesType 23832
#define OpcUaId_PubSubStatusEventType 15535
#define OpcUaId_PubSubTransportLimitsExceedEventType 15548
#define OpcUaId_PubSubCommunicationFailureEventType 15563
#define OpcUaId_UadpWriterGroupMessageType 21105
#define OpcUaId_UadpDataSetWriterMessageType 21111
#define OpcUaId_UadpDataSetReaderMessageType 21116
#define OpcUaId_JsonWriterGroupMessageType 21126
#define OpcUaId_JsonDataSetWriterMessageType 21128
#define OpcUaId_JsonDataSetReaderMessageType 21130
#define OpcUaId_DatagramConnectionTransportType 15064
#define OpcUaId_DatagramWriterGroupTransportType 21133
#define OpcUaId_DatagramDataSetReaderTransportType 24016
#define OpcUaId_BrokerConnectionTransportType 15155
#define OpcUaId_BrokerWriterGroupTransportType 21136
#define OpcUaId_BrokerDataSetWriterTransportType 21138
#define OpcUaId_BrokerDataSetReaderTransportType 21142
#define OpcUaId_NetworkAddressType 21145
#define OpcUaId_NetworkAddressUrlType 21147
#define OpcUaId_AliasNameType 23455
#define OpcUaId_AliasNameCategoryType 23456
#define OpcUaId_UserManagementType 24264
#define OpcUaId_ApplicationConfigurationType 25731
#define OpcUaId_ProvisionableDeviceType 26871
#define OpcUaId_IIetfBaseNetworkInterfaceType 24148
#define OpcUaId_IIeeeBaseEthernetPortType 24158
#define OpcUaId_IIeeeAutoNegotiationStatusType 24233
#define OpcUaId_IBaseEthernetCapabilitiesType 24167
#define OpcUaId_IVlanIdType 25218
#define OpcUaId_ISrClassType 24169
#define OpcUaId_IIeeeBaseTsnStreamType 24173
#define OpcUaId_IIeeeBaseTsnTrafficSpecificationType 24179
#define OpcUaId_IIeeeBaseTsnStatusStreamType 24183
#define OpcUaId_IIeeeTsnInterfaceConfigurationType 24188
#define OpcUaId_IIeeeTsnInterfaceConfigurationTalkerType 24191
#define OpcUaId_IIeeeTsnInterfaceConfigurationListenerType 24195
#define OpcUaId_IIeeeTsnMacAddressType 24199
#define OpcUaId_IIeeeTsnVlanTagType 24202
#define OpcUaId_IPriorityMappingEntryType 24205
#define OpcUaId_IetfBaseNetworkInterfaceType 25221
#define OpcUaId_PriorityMappingTableType 25227

/*============================================================================
* ReferenceType Identifiers
 *===========================================================================*/
#define OpcUaId_References 31
#define OpcUaId_NonHierarchicalReferences 32
#define OpcUaId_HierarchicalReferences 33
#define OpcUaId_HasChild 34
#define OpcUaId_Organizes 35
#define OpcUaId_HasEventSource 36
#define OpcUaId_HasModellingRule 37
#define OpcUaId_HasEncoding 38
#define OpcUaId_HasDescription 39
#define OpcUaId_HasTypeDefinition 40
#define OpcUaId_GeneratesEvent 41
#define OpcUaId_AlwaysGeneratesEvent 3065
#define OpcUaId_Aggregates 44
#define OpcUaId_HasSubtype 45
#define OpcUaId_HasProperty 46
#define OpcUaId_HasComponent 47
#define OpcUaId_HasNotifier 48
#define OpcUaId_HasOrderedComponent 49
#define OpcUaId_FromState 51
#define OpcUaId_ToState 52
#define OpcUaId_HasCause 53
#define OpcUaId_HasEffect 54
#define OpcUaId_HasSubStateMachine 117
#define OpcUaId_HasHistoricalConfiguration 56
#define OpcUaId_HasStructuredComponent 24136
#define OpcUaId_AssociatedWith 24137
#define OpcUaId_HasArgumentDescription 129
#define OpcUaId_HasOptionalInputArgumentDescription 131
#define OpcUaId_IsDeprecated 23562
#define OpcUaId_HasGuard 15112
#define OpcUaId_HasDictionaryEntry 17597
#define OpcUaId_HasInterface 17603
#define OpcUaId_HasAddIn 17604
#define OpcUaId_HasTrueSubState 9004
#define OpcUaId_HasFalseSubState 9005
#define OpcUaId_HasAlarmSuppressionGroup 16361
#define OpcUaId_AlarmGroupMember 16362
#define OpcUaId_AlarmSuppressionGroupMember 32059
#define OpcUaId_HasCondition 9006
#define OpcUaId_HasEffectDisable 17276
#define OpcUaId_HasEffectEnable 17983
#define OpcUaId_HasEffectSuppressed 17984
#define OpcUaId_HasEffectUnsuppressed 17985
#define OpcUaId_HasPushedSecurityGroup 25345
#define OpcUaId_HasPubSubConnection 14476
#define OpcUaId_DataSetToWriter 14936
#define OpcUaId_HasDataSetWriter 15296
#define OpcUaId_HasWriterGroup 18804
#define OpcUaId_HasDataSetReader 15297
#define OpcUaId_HasReaderGroup 18805
#define OpcUaId_AliasFor 23469
#define OpcUaId_UsesPriorityMappingTable 25237
#define OpcUaId_HasLowerLayerInterface 25238
#define OpcUaId_IsExecutableOn 25253
#define OpcUaId_Controls 25254
#define OpcUaId_Utilizes 25255
#define OpcUaId_IsExecutingOn 25265
#define OpcUaId_Requires 25256
#define OpcUaId_IsPhysicallyConnectedTo 25257
#define OpcUaId_RepresentsSameEntityAs 25258
#define OpcUaId_RepresentsSameHardwareAs 25259
#define OpcUaId_RepresentsSameFunctionalityAs 25260
#define OpcUaId_IsHostedBy 25261
#define OpcUaId_HasPhysicalComponent 25262
#define OpcUaId_HasContainedComponent 25263
#define OpcUaId_HasAttachedComponent 25264
#define OpcUaId_HasReferenceDescription 32679

/*============================================================================
* Variable Identifiers
 *===========================================================================*/
#define OpcUaId_DataTypeDescriptionType_DataTypeVersion 104
#define OpcUaId_DataTypeDescriptionType_DictionaryFragment 105
#define OpcUaId_DataTypeDictionaryType_DataTypeVersion 106
#define OpcUaId_DataTypeDictionaryType_NamespaceUri 107
#define OpcUaId_DataTypeDictionaryType_Deprecated 15001
#define OpcUaId_NamingRuleType_EnumValues 12169
#define OpcUaId_OPCUANamespaceMetadata_NamespaceUri 15958
#define OpcUaId_OPCUANamespaceMetadata_NamespaceVersion 15959
#define OpcUaId_OPCUANamespaceMetadata_NamespacePublicationDate 15960
#define OpcUaId_OPCUANamespaceMetadata_IsNamespaceSubset 15961
#define OpcUaId_OPCUANamespaceMetadata_StaticNodeIdTypes 15962
#define OpcUaId_OPCUANamespaceMetadata_StaticNumericNodeIdRange 15963
#define OpcUaId_OPCUANamespaceMetadata_StaticStringNodeIdPattern 15964
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_Size 15966
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_Writable 15967
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_UserWritable 15968
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_OpenCount 15969
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_Open_InputArguments 15972
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_Open_OutputArguments 15973
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_Close_InputArguments 15975
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_Read_InputArguments 15977
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_Read_OutputArguments 15978
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_Write_InputArguments 15980
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_GetPosition_InputArguments 15982
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_GetPosition_OutputArguments 15983
#define OpcUaId_OPCUANamespaceMetadata_NamespaceFile_SetPosition_InputArguments 15985
#define OpcUaId_OPCUANamespaceMetadata_DefaultRolePermissions 16134
#define OpcUaId_OPCUANamespaceMetadata_DefaultUserRolePermissions 16135
#define OpcUaId_OPCUANamespaceMetadata_DefaultAccessRestrictions 16136
#define OpcUaId_NodeVersion 3068
#define OpcUaId_ViewVersion 12170
#define OpcUaId_Icon 3067
#define OpcUaId_LocalTime 3069
#define OpcUaId_AllowNulls 3070
#define OpcUaId_ValueAsText 11433
#define OpcUaId_MaxStringLength 11498
#define OpcUaId_MaxCharacters 15002
#define OpcUaId_MaxByteStringLength 12908
#define OpcUaId_MaxArrayLength 11512
#define OpcUaId_EngineeringUnits 11513
#define OpcUaId_EnumStrings 11432
#define OpcUaId_EnumValues 3071
#define OpcUaId_OptionSetValues 12745
#define OpcUaId_OptionSetLength 32750
#define OpcUaId_InputArguments 3072
#define OpcUaId_OutputArguments 3073
#define OpcUaId_DefaultInstanceBrowseName 17605
#define OpcUaId_ServerType_ServerArray 2005
#define OpcUaId_ServerType_NamespaceArray 2006
#define OpcUaId_ServerType_UrisVersion 15003
#define OpcUaId_ServerType_ServerStatus 2007
#define OpcUaId_ServerType_ServerStatus_StartTime 3074
#define OpcUaId_ServerType_ServerStatus_CurrentTime 3075
#define OpcUaId_ServerType_ServerStatus_State 3076
#define OpcUaId_ServerType_ServerStatus_BuildInfo 3077
#define OpcUaId_ServerType_ServerStatus_BuildInfo_ProductUri 3078
#define OpcUaId_ServerType_ServerStatus_BuildInfo_ManufacturerName 3079
#define OpcUaId_ServerType_ServerStatus_BuildInfo_ProductName 3080
#define OpcUaId_ServerType_ServerStatus_BuildInfo_SoftwareVersion 3081
#define OpcUaId_ServerType_ServerStatus_BuildInfo_BuildNumber 3082
#define OpcUaId_ServerType_ServerStatus_BuildInfo_BuildDate 3083
#define OpcUaId_ServerType_ServerStatus_SecondsTillShutdown 3084
#define OpcUaId_ServerType_ServerStatus_ShutdownReason 3085
#define OpcUaId_ServerType_ServiceLevel 2008
#define OpcUaId_ServerType_Auditing 2742
#define OpcUaId_ServerType_EstimatedReturnTime 12882
#define OpcUaId_ServerType_LocalTime 17612
#define OpcUaId_ServerType_ServerCapabilities_ServerProfileArray 3086
#define OpcUaId_ServerType_ServerCapabilities_LocaleIdArray 3087
#define OpcUaId_ServerType_ServerCapabilities_MinSupportedSampleRate 3088
#define OpcUaId_ServerType_ServerCapabilities_MaxBrowseContinuationPoints 3089
#define OpcUaId_ServerType_ServerCapabilities_MaxQueryContinuationPoints 3090
#define OpcUaId_ServerType_ServerCapabilities_MaxHistoryContinuationPoints 3091
#define OpcUaId_ServerType_ServerCapabilities_SoftwareCertificates 3092
#define OpcUaId_ServerType_ServerCapabilities_RoleSet_AddRole_InputArguments 16291
#define OpcUaId_ServerType_ServerCapabilities_RoleSet_AddRole_OutputArguments 16292
#define OpcUaId_ServerType_ServerCapabilities_RoleSet_RemoveRole_InputArguments 16294
#define OpcUaId_ServerType_ServerDiagnostics_ServerDiagnosticsSummary 3095
#define OpcUaId_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount 3096
#define OpcUaId_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount 3097
#define OpcUaId_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount 3098
#define OpcUaId_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount 3099
#define OpcUaId_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount 3100
#define OpcUaId_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount 3101
#define OpcUaId_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount 3102
#define OpcUaId_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount 3104
#define OpcUaId_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount 3105
#define OpcUaId_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount 3106
#define OpcUaId_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount 3107
#define OpcUaId_ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount 3108
#define OpcUaId_ServerType_ServerDiagnostics_SubscriptionDiagnosticsArray 3110
#define OpcUaId_ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray 3112
#define OpcUaId_ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray 3113
#define OpcUaId_ServerType_ServerDiagnostics_EnabledFlag 3114
#define OpcUaId_ServerType_ServerRedundancy_RedundancySupport 3115
#define OpcUaId_ServerType_GetMonitoredItems_InputArguments 11490
#define OpcUaId_ServerType_GetMonitoredItems_OutputArguments 11491
#define OpcUaId_ServerType_ResendData_InputArguments 12872
#define OpcUaId_ServerType_SetSubscriptionDurable_InputArguments 12747
#define OpcUaId_ServerType_SetSubscriptionDurable_OutputArguments 12748
#define OpcUaId_ServerType_RequestServerStateChange_InputArguments 12884
#define OpcUaId_ServerCapabilitiesType_ServerProfileArray 2014
#define OpcUaId_ServerCapabilitiesType_LocaleIdArray 2016
#define OpcUaId_ServerCapabilitiesType_MinSupportedSampleRate 2017
#define OpcUaId_ServerCapabilitiesType_MaxBrowseContinuationPoints 2732
#define OpcUaId_ServerCapabilitiesType_MaxQueryContinuationPoints 2733
#define OpcUaId_ServerCapabilitiesType_MaxHistoryContinuationPoints 2734
#define OpcUaId_ServerCapabilitiesType_SoftwareCertificates 3049
#define OpcUaId_ServerCapabilitiesType_MaxArrayLength 11549
#define OpcUaId_ServerCapabilitiesType_MaxStringLength 11550
#define OpcUaId_ServerCapabilitiesType_MaxByteStringLength 12910
#define OpcUaId_ServerCapabilitiesType_VendorCapability_Placeholder 11562
#define OpcUaId_ServerCapabilitiesType_RoleSet_AddRole_InputArguments 16297
#define OpcUaId_ServerCapabilitiesType_RoleSet_AddRole_OutputArguments 16298
#define OpcUaId_ServerCapabilitiesType_RoleSet_RemoveRole_InputArguments 16300
#define OpcUaId_ServerCapabilitiesType_MaxSessions 24088
#define OpcUaId_ServerCapabilitiesType_MaxSubscriptions 24089
#define OpcUaId_ServerCapabilitiesType_MaxMonitoredItems 24090
#define OpcUaId_ServerCapabilitiesType_MaxSubscriptionsPerSession 24091
#define OpcUaId_ServerCapabilitiesType_MaxMonitoredItemsPerSubscription 24103
#define OpcUaId_ServerCapabilitiesType_MaxSelectClauseParameters 24092
#define OpcUaId_ServerCapabilitiesType_MaxWhereClauseParameters 24093
#define OpcUaId_ServerCapabilitiesType_MaxMonitoredItemsQueueSize 31770
#define OpcUaId_ServerCapabilitiesType_ConformanceUnits 24094
#define OpcUaId_ServerDiagnosticsType_ServerDiagnosticsSummary 2021
#define OpcUaId_ServerDiagnosticsType_ServerDiagnosticsSummary_ServerViewCount 3116
#define OpcUaId_ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSessionCount 3117
#define OpcUaId_ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSessionCount 3118
#define OpcUaId_ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedSessionCount 3119
#define OpcUaId_ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedSessionCount 3120
#define OpcUaId_ServerDiagnosticsType_ServerDiagnosticsSummary_SessionTimeoutCount 3121
#define OpcUaId_ServerDiagnosticsType_ServerDiagnosticsSummary_SessionAbortCount 3122
#define OpcUaId_ServerDiagnosticsType_ServerDiagnosticsSummary_PublishingIntervalCount 3124
#define OpcUaId_ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSubscriptionCount 3125
#define OpcUaId_ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSubscriptionCount 3126
#define OpcUaId_ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedRequestsCount 3127
#define OpcUaId_ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedRequestsCount 3128
#define OpcUaId_ServerDiagnosticsType_SamplingIntervalDiagnosticsArray 2022
#define OpcUaId_ServerDiagnosticsType_SubscriptionDiagnosticsArray 2023
#define OpcUaId_ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionDiagnosticsArray 3129
#define OpcUaId_ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray 3130
#define OpcUaId_ServerDiagnosticsType_EnabledFlag 2025
#define OpcUaId_SessionsDiagnosticsSummaryType_SessionDiagnosticsArray 2027
#define OpcUaId_SessionsDiagnosticsSummaryType_SessionSecurityDiagnosticsArray 2028
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics 12098
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionId 12099
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionName 12100
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientDescription 12101
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ServerUri 12102
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_EndpointUrl 12103
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_LocaleIds 12104
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ActualSessionTimeout 12105
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_MaxResponseMessageSize 12106
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientConnectionTime 12107
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientLastContactTime 12108
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentSubscriptionsCount 12109
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentMonitoredItemsCount 12110
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentPublishRequestsInQueue 12111
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TotalRequestCount 12112
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnauthorizedRequestCount 12113
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ReadCount 12114
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryReadCount 12115
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_WriteCount 12116
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryUpdateCount 12117
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CallCount 12118
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateMonitoredItemsCount 12119
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifyMonitoredItemsCount 12120
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetMonitoringModeCount 12121
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetTriggeringCount 12122
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteMonitoredItemsCount 12123
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateSubscriptionCount 12124
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifySubscriptionCount 12125
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetPublishingModeCount 12126
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_PublishCount 12127
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RepublishCount 12128
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TransferSubscriptionsCount 12129
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteSubscriptionsCount 12130
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddNodesCount 12131
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddReferencesCount 12132
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteNodesCount 12133
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteReferencesCount 12134
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseCount 12135
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseNextCount 12136
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount 12137
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryFirstCount 12138
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryNextCount 12139
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RegisterNodesCount 12140
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnregisterNodesCount 12141
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics 12142
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SessionId 12143
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdOfSession 12144
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdHistory 12145
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_AuthenticationMechanism 12146
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_Encoding 12147
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_TransportProtocol 12148
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityMode 12149
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityPolicyUri 12150
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientCertificate 12151
#define OpcUaId_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SubscriptionDiagnosticsArray 12152
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics 2030
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_SessionId 3131
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_SessionName 3132
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_ClientDescription 3133
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_ServerUri 3134
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_EndpointUrl 3135
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_LocaleIds 3136
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_ActualSessionTimeout 3137
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_MaxResponseMessageSize 3138
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_ClientConnectionTime 3139
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_ClientLastContactTime 3140
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentSubscriptionsCount 3141
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentMonitoredItemsCount 3142
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_CurrentPublishRequestsInQueue 3143
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_TotalRequestCount 8898
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_UnauthorizedRequestCount 11891
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_ReadCount 3151
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_HistoryReadCount 3152
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_WriteCount 3153
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_HistoryUpdateCount 3154
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_CallCount 3155
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_CreateMonitoredItemsCount 3156
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_ModifyMonitoredItemsCount 3157
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_SetMonitoringModeCount 3158
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_SetTriggeringCount 3159
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteMonitoredItemsCount 3160
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_CreateSubscriptionCount 3161
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_ModifySubscriptionCount 3162
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_SetPublishingModeCount 3163
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_PublishCount 3164
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_RepublishCount 3165
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_TransferSubscriptionsCount 3166
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteSubscriptionsCount 3167
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_AddNodesCount 3168
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_AddReferencesCount 3169
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteNodesCount 3170
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_DeleteReferencesCount 3171
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_BrowseCount 3172
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_BrowseNextCount 3173
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount 3174
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_QueryFirstCount 3175
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_QueryNextCount 3176
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_RegisterNodesCount 3177
#define OpcUaId_SessionDiagnosticsObjectType_SessionDiagnostics_UnregisterNodesCount 3178
#define OpcUaId_SessionDiagnosticsObjectType_SessionSecurityDiagnostics 2031
#define OpcUaId_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SessionId 3179
#define OpcUaId_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdOfSession 3180
#define OpcUaId_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdHistory 3181
#define OpcUaId_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_AuthenticationMechanism 3182
#define OpcUaId_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_Encoding 3183
#define OpcUaId_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_TransportProtocol 3184
#define OpcUaId_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityMode 3185
#define OpcUaId_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityPolicyUri 3186
#define OpcUaId_SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientCertificate 3187
#define OpcUaId_SessionDiagnosticsObjectType_SubscriptionDiagnosticsArray 2032
#define OpcUaId_ServerRedundancyType_RedundancySupport 2035
#define OpcUaId_TransparentRedundancyType_CurrentServerId 2037
#define OpcUaId_TransparentRedundancyType_RedundantServerArray 2038
#define OpcUaId_NonTransparentRedundancyType_ServerUriArray 2040
#define OpcUaId_NonTransparentNetworkRedundancyType_ServerNetworkGroups 11948
#define OpcUaId_OperationLimitsType_MaxNodesPerRead 11565
#define OpcUaId_OperationLimitsType_MaxNodesPerHistoryReadData 12161
#define OpcUaId_OperationLimitsType_MaxNodesPerHistoryReadEvents 12162
#define OpcUaId_OperationLimitsType_MaxNodesPerWrite 11567
#define OpcUaId_OperationLimitsType_MaxNodesPerHistoryUpdateData 12163
#define OpcUaId_OperationLimitsType_MaxNodesPerHistoryUpdateEvents 12164
#define OpcUaId_OperationLimitsType_MaxNodesPerMethodCall 11569
#define OpcUaId_OperationLimitsType_MaxNodesPerBrowse 11570
#define OpcUaId_OperationLimitsType_MaxNodesPerRegisterNodes 11571
#define OpcUaId_OperationLimitsType_MaxNodesPerTranslateBrowsePathsToNodeIds 11572
#define OpcUaId_OperationLimitsType_MaxNodesPerNodeManagement 11573
#define OpcUaId_OperationLimitsType_MaxMonitoredItemsPerCall 11574
#define OpcUaId_FileType_Size 11576
#define OpcUaId_FileType_Writable 12686
#define OpcUaId_FileType_UserWritable 12687
#define OpcUaId_FileType_OpenCount 11579
#define OpcUaId_FileType_MimeType 13341
#define OpcUaId_FileType_MaxByteStringLength 24244
#define OpcUaId_FileType_LastModifiedTime 25200
#define OpcUaId_FileType_Open_InputArguments 11581
#define OpcUaId_FileType_Open_OutputArguments 11582
#define OpcUaId_FileType_Close_InputArguments 11584
#define OpcUaId_FileType_Read_InputArguments 11586
#define OpcUaId_FileType_Read_OutputArguments 11587
#define OpcUaId_FileType_Write_InputArguments 11589
#define OpcUaId_FileType_GetPosition_InputArguments 11591
#define OpcUaId_FileType_GetPosition_OutputArguments 11592
#define OpcUaId_FileType_SetPosition_InputArguments 11594
#define OpcUaId_AddressSpaceFileType_Open_InputArguments 11601
#define OpcUaId_AddressSpaceFileType_Open_OutputArguments 11602
#define OpcUaId_AddressSpaceFileType_Close_InputArguments 11604
#define OpcUaId_AddressSpaceFileType_Read_InputArguments 11606
#define OpcUaId_AddressSpaceFileType_Read_OutputArguments 11607
#define OpcUaId_AddressSpaceFileType_Write_InputArguments 11609
#define OpcUaId_AddressSpaceFileType_GetPosition_InputArguments 11611
#define OpcUaId_AddressSpaceFileType_GetPosition_OutputArguments 11612
#define OpcUaId_AddressSpaceFileType_SetPosition_InputArguments 11614
#define OpcUaId_NamespaceMetadataType_NamespaceUri 11617
#define OpcUaId_NamespaceMetadataType_NamespaceVersion 11618
#define OpcUaId_NamespaceMetadataType_NamespacePublicationDate 11619
#define OpcUaId_NamespaceMetadataType_IsNamespaceSubset 11620
#define OpcUaId_NamespaceMetadataType_StaticNodeIdTypes 11621
#define OpcUaId_NamespaceMetadataType_StaticNumericNodeIdRange 11622
#define OpcUaId_NamespaceMetadataType_StaticStringNodeIdPattern 11623
#define OpcUaId_NamespaceMetadataType_NamespaceFile_Size 11625
#define OpcUaId_NamespaceMetadataType_NamespaceFile_Writable 12690
#define OpcUaId_NamespaceMetadataType_NamespaceFile_UserWritable 12691
#define OpcUaId_NamespaceMetadataType_NamespaceFile_OpenCount 11628
#define OpcUaId_NamespaceMetadataType_NamespaceFile_Open_InputArguments 11630
#define OpcUaId_NamespaceMetadataType_NamespaceFile_Open_OutputArguments 11631
#define OpcUaId_NamespaceMetadataType_NamespaceFile_Close_InputArguments 11633
#define OpcUaId_NamespaceMetadataType_NamespaceFile_Read_InputArguments 11635
#define OpcUaId_NamespaceMetadataType_NamespaceFile_Read_OutputArguments 11636
#define OpcUaId_NamespaceMetadataType_NamespaceFile_Write_InputArguments 11638
#define OpcUaId_NamespaceMetadataType_NamespaceFile_GetPosition_InputArguments 11640
#define OpcUaId_NamespaceMetadataType_NamespaceFile_GetPosition_OutputArguments 11641
#define OpcUaId_NamespaceMetadataType_NamespaceFile_SetPosition_InputArguments 11643
#define OpcUaId_NamespaceMetadataType_DefaultRolePermissions 16137
#define OpcUaId_NamespaceMetadataType_DefaultUserRolePermissions 16138
#define OpcUaId_NamespaceMetadataType_DefaultAccessRestrictions 16139
#define OpcUaId_NamespaceMetadataType_ConfigurationVersion 25267
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceUri 11647
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceVersion 11648
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespacePublicationDate 11649
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_IsNamespaceSubset 11650
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_StaticNodeIdTypes 11651
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_StaticNumericNodeIdRange 11652
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_StaticStringNodeIdPattern 11653
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Size 11655
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Writable 12692
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_UserWritable 12693
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_OpenCount 11658
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open_InputArguments 11660
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open_OutputArguments 11661
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close_InputArguments 11663
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read_InputArguments 11665
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read_OutputArguments 11666
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write_InputArguments 11668
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition_InputArguments 11670
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition_OutputArguments 11671
#define OpcUaId_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition_InputArguments 11673
#define OpcUaId_BaseEventType_EventId 2042
#define OpcUaId_BaseEventType_EventType 2043
#define OpcUaId_BaseEventType_SourceNode 2044
#define OpcUaId_BaseEventType_SourceName 2045
#define OpcUaId_BaseEventType_Time 2046
#define OpcUaId_BaseEventType_ReceiveTime 2047
#define OpcUaId_BaseEventType_LocalTime 3190
#define OpcUaId_BaseEventType_Message 2050
#define OpcUaId_BaseEventType_Severity 2051
#define OpcUaId_BaseEventType_ConditionClassId 31771
#define OpcUaId_BaseEventType_ConditionClassName 31772
#define OpcUaId_BaseEventType_ConditionSubClassId 31773
#define OpcUaId_BaseEventType_ConditionSubClassName 31774
#define OpcUaId_AuditEventType_ActionTimeStamp 2053
#define OpcUaId_AuditEventType_Status 2054
#define OpcUaId_AuditEventType_ServerId 2055
#define OpcUaId_AuditEventType_ClientAuditEntryId 2056
#define OpcUaId_AuditEventType_ClientUserId 2057
#define OpcUaId_AuditSecurityEventType_StatusCodeId 17615
#define OpcUaId_AuditChannelEventType_SecureChannelId 2745
#define OpcUaId_AuditOpenSecureChannelEventType_ClientCertificate 2061
#define OpcUaId_AuditOpenSecureChannelEventType_ClientCertificateThumbprint 2746
#define OpcUaId_AuditOpenSecureChannelEventType_RequestType 2062
#define OpcUaId_AuditOpenSecureChannelEventType_SecurityPolicyUri 2063
#define OpcUaId_AuditOpenSecureChannelEventType_SecurityMode 2065
#define OpcUaId_AuditOpenSecureChannelEventType_RequestedLifetime 2066
#define OpcUaId_AuditOpenSecureChannelEventType_CertificateErrorEventId 24135
#define OpcUaId_AuditSessionEventType_SessionId 2070
#define OpcUaId_AuditCreateSessionEventType_SecureChannelId 2072
#define OpcUaId_AuditCreateSessionEventType_ClientCertificate 2073
#define OpcUaId_AuditCreateSessionEventType_ClientCertificateThumbprint 2747
#define OpcUaId_AuditCreateSessionEventType_RevisedSessionTimeout 2074
#define OpcUaId_AuditUrlMismatchEventType_EndpointUrl 2749
#define OpcUaId_AuditActivateSessionEventType_ClientSoftwareCertificates 2076
#define OpcUaId_AuditActivateSessionEventType_UserIdentityToken 2077
#define OpcUaId_AuditActivateSessionEventType_SecureChannelId 11485
#define OpcUaId_AuditCancelEventType_RequestHandle 2079
#define OpcUaId_AuditCertificateEventType_Certificate 2081
#define OpcUaId_AuditCertificateDataMismatchEventType_InvalidHostname 2083
#define OpcUaId_AuditCertificateDataMismatchEventType_InvalidUri 2084
#define OpcUaId_AuditAddNodesEventType_NodesToAdd 2092
#define OpcUaId_AuditDeleteNodesEventType_NodesToDelete 2094
#define OpcUaId_AuditAddReferencesEventType_ReferencesToAdd 2096
#define OpcUaId_AuditDeleteReferencesEventType_ReferencesToDelete 2098
#define OpcUaId_AuditWriteUpdateEventType_AttributeId 2750
#define OpcUaId_AuditWriteUpdateEventType_IndexRange 2101
#define OpcUaId_AuditWriteUpdateEventType_OldValue 2102
#define OpcUaId_AuditWriteUpdateEventType_NewValue 2103
#define OpcUaId_AuditHistoryUpdateEventType_ParameterDataTypeId 2751
#define OpcUaId_AuditUpdateMethodEventType_MethodId 2128
#define OpcUaId_AuditUpdateMethodEventType_InputArguments 2129
#define OpcUaId_SystemStatusChangeEventType_SystemState 11696
#define OpcUaId_GeneralModelChangeEventType_Changes 2134
#define OpcUaId_SemanticChangeEventType_Changes 2739
#define OpcUaId_ProgressEventType_Context 12502
#define OpcUaId_ProgressEventType_Progress 12503
#define OpcUaId_AuditClientEventType_ServerUri 23908
#define OpcUaId_AuditClientUpdateMethodResultEventType_ObjectId 23994
#define OpcUaId_AuditClientUpdateMethodResultEventType_MethodId 23995
#define OpcUaId_AuditClientUpdateMethodResultEventType_StatusCodeId 23998
#define OpcUaId_AuditClientUpdateMethodResultEventType_InputArguments 23999
#define OpcUaId_AuditClientUpdateMethodResultEventType_OutputArguments 25684
#define OpcUaId_ServerStatusType_StartTime 2139
#define OpcUaId_ServerStatusType_CurrentTime 2140
#define OpcUaId_ServerStatusType_State 2141
#define OpcUaId_ServerStatusType_BuildInfo 2142
#define OpcUaId_ServerStatusType_BuildInfo_ProductUri 3698
#define OpcUaId_ServerStatusType_BuildInfo_ManufacturerName 3699
#define OpcUaId_ServerStatusType_BuildInfo_ProductName 3700
#define OpcUaId_ServerStatusType_BuildInfo_SoftwareVersion 3701
#define OpcUaId_ServerStatusType_BuildInfo_BuildNumber 3702
#define OpcUaId_ServerStatusType_BuildInfo_BuildDate 3703
#define OpcUaId_ServerStatusType_SecondsTillShutdown 2752
#define OpcUaId_ServerStatusType_ShutdownReason 2753
#define OpcUaId_BuildInfoType_ProductUri 3052
#define OpcUaId_BuildInfoType_ManufacturerName 3053
#define OpcUaId_BuildInfoType_ProductName 3054
#define OpcUaId_BuildInfoType_SoftwareVersion 3055
#define OpcUaId_BuildInfoType_BuildNumber 3056
#define OpcUaId_BuildInfoType_BuildDate 3057
#define OpcUaId_ServerDiagnosticsSummaryType_ServerViewCount 2151
#define OpcUaId_ServerDiagnosticsSummaryType_CurrentSessionCount 2152
#define OpcUaId_ServerDiagnosticsSummaryType_CumulatedSessionCount 2153
#define OpcUaId_ServerDiagnosticsSummaryType_SecurityRejectedSessionCount 2154
#define OpcUaId_ServerDiagnosticsSummaryType_RejectedSessionCount 2155
#define OpcUaId_ServerDiagnosticsSummaryType_SessionTimeoutCount 2156
#define OpcUaId_ServerDiagnosticsSummaryType_SessionAbortCount 2157
#define OpcUaId_ServerDiagnosticsSummaryType_PublishingIntervalCount 2159
#define OpcUaId_ServerDiagnosticsSummaryType_CurrentSubscriptionCount 2160
#define OpcUaId_ServerDiagnosticsSummaryType_CumulatedSubscriptionCount 2161
#define OpcUaId_ServerDiagnosticsSummaryType_SecurityRejectedRequestsCount 2162
#define OpcUaId_ServerDiagnosticsSummaryType_RejectedRequestsCount 2163
#define OpcUaId_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics 12779
#define OpcUaId_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SamplingInterval 12780
#define OpcUaId_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SampledMonitoredItemsCount 12781
#define OpcUaId_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_MaxSampledMonitoredItemsCount 12782
#define OpcUaId_SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_DisabledMonitoredItemsSamplingCount 12783
#define OpcUaId_SamplingIntervalDiagnosticsType_SamplingInterval 2166
#define OpcUaId_SamplingIntervalDiagnosticsType_SampledMonitoredItemsCount 11697
#define OpcUaId_SamplingIntervalDiagnosticsType_MaxSampledMonitoredItemsCount 11698
#define OpcUaId_SamplingIntervalDiagnosticsType_DisabledMonitoredItemsSamplingCount 11699
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics 12784
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SessionId 12785
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SubscriptionId 12786
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_Priority 12787
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingInterval 12788
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxKeepAliveCount 12789
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxLifetimeCount 12790
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxNotificationsPerPublish 12791
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingEnabled 12792
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_ModifyCount 12793
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EnableCount 12794
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisableCount 12795
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishRequestCount 12796
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageRequestCount 12797
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageCount 12798
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferRequestCount 12799
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToAltClientCount 12800
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToSameClientCount 12801
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishRequestCount 12802
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DataChangeNotificationsCount 12803
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventNotificationsCount 12804
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NotificationsCount 12805
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_LatePublishRequestCount 12806
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentKeepAliveCount 12807
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentLifetimeCount 12808
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_UnacknowledgedMessageCount 12809
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DiscardedMessageCount 12810
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoredItemCount 12811
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisabledMonitoredItemCount 12812
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoringQueueOverflowCount 12813
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NextSequenceNumber 12814
#define OpcUaId_SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventQueueOverflowCount 12815
#define OpcUaId_SubscriptionDiagnosticsType_SessionId 2173
#define OpcUaId_SubscriptionDiagnosticsType_SubscriptionId 2174
#define OpcUaId_SubscriptionDiagnosticsType_Priority 2175
#define OpcUaId_SubscriptionDiagnosticsType_PublishingInterval 2176
#define OpcUaId_SubscriptionDiagnosticsType_MaxKeepAliveCount 2177
#define OpcUaId_SubscriptionDiagnosticsType_MaxLifetimeCount 8888
#define OpcUaId_SubscriptionDiagnosticsType_MaxNotificationsPerPublish 2179
#define OpcUaId_SubscriptionDiagnosticsType_PublishingEnabled 2180
#define OpcUaId_SubscriptionDiagnosticsType_ModifyCount 2181
#define OpcUaId_SubscriptionDiagnosticsType_EnableCount 2182
#define OpcUaId_SubscriptionDiagnosticsType_DisableCount 2183
#define OpcUaId_SubscriptionDiagnosticsType_RepublishRequestCount 2184
#define OpcUaId_SubscriptionDiagnosticsType_RepublishMessageRequestCount 2185
#define OpcUaId_SubscriptionDiagnosticsType_RepublishMessageCount 2186
#define OpcUaId_SubscriptionDiagnosticsType_TransferRequestCount 2187
#define OpcUaId_SubscriptionDiagnosticsType_TransferredToAltClientCount 2188
#define OpcUaId_SubscriptionDiagnosticsType_TransferredToSameClientCount 2189
#define OpcUaId_SubscriptionDiagnosticsType_PublishRequestCount 2190
#define OpcUaId_SubscriptionDiagnosticsType_DataChangeNotificationsCount 2191
#define OpcUaId_SubscriptionDiagnosticsType_EventNotificationsCount 2998
#define OpcUaId_SubscriptionDiagnosticsType_NotificationsCount 2193
#define OpcUaId_SubscriptionDiagnosticsType_LatePublishRequestCount 8889
#define OpcUaId_SubscriptionDiagnosticsType_CurrentKeepAliveCount 8890
#define OpcUaId_SubscriptionDiagnosticsType_CurrentLifetimeCount 8891
#define OpcUaId_SubscriptionDiagnosticsType_UnacknowledgedMessageCount 8892
#define OpcUaId_SubscriptionDiagnosticsType_DiscardedMessageCount 8893
#define OpcUaId_SubscriptionDiagnosticsType_MonitoredItemCount 8894
#define OpcUaId_SubscriptionDiagnosticsType_DisabledMonitoredItemCount 8895
#define OpcUaId_SubscriptionDiagnosticsType_MonitoringQueueOverflowCount 8896
#define OpcUaId_SubscriptionDiagnosticsType_NextSequenceNumber 8897
#define OpcUaId_SubscriptionDiagnosticsType_EventQueueOverflowCount 8902
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics 12816
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_SessionId 12817
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_SessionName 12818
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_ClientDescription 12819
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_ServerUri 12820
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_EndpointUrl 12821
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_LocaleIds 12822
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_ActualSessionTimeout 12823
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_MaxResponseMessageSize 12824
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_ClientConnectionTime 12825
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_ClientLastContactTime 12826
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentSubscriptionsCount 12827
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentMonitoredItemsCount 12828
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_CurrentPublishRequestsInQueue 12829
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_TotalRequestCount 12830
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_UnauthorizedRequestCount 12831
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_ReadCount 12832
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_HistoryReadCount 12833
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_WriteCount 12834
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_HistoryUpdateCount 12835
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_CallCount 12836
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_CreateMonitoredItemsCount 12837
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_ModifyMonitoredItemsCount 12838
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_SetMonitoringModeCount 12839
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_SetTriggeringCount 12840
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteMonitoredItemsCount 12841
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_CreateSubscriptionCount 12842
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_ModifySubscriptionCount 12843
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_SetPublishingModeCount 12844
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_PublishCount 12845
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_RepublishCount 12846
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_TransferSubscriptionsCount 12847
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteSubscriptionsCount 12848
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_AddNodesCount 12849
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_AddReferencesCount 12850
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteNodesCount 12851
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_DeleteReferencesCount 12852
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_BrowseCount 12853
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_BrowseNextCount 12854
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount 12855
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_QueryFirstCount 12856
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_QueryNextCount 12857
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_RegisterNodesCount 12858
#define OpcUaId_SessionDiagnosticsArrayType_SessionDiagnostics_UnregisterNodesCount 12859
#define OpcUaId_SessionDiagnosticsVariableType_SessionId 2198
#define OpcUaId_SessionDiagnosticsVariableType_SessionName 2199
#define OpcUaId_SessionDiagnosticsVariableType_ClientDescription 2200
#define OpcUaId_SessionDiagnosticsVariableType_ServerUri 2201
#define OpcUaId_SessionDiagnosticsVariableType_EndpointUrl 2202
#define OpcUaId_SessionDiagnosticsVariableType_LocaleIds 2203
#define OpcUaId_SessionDiagnosticsVariableType_ActualSessionTimeout 2204
#define OpcUaId_SessionDiagnosticsVariableType_MaxResponseMessageSize 3050
#define OpcUaId_SessionDiagnosticsVariableType_ClientConnectionTime 2205
#define OpcUaId_SessionDiagnosticsVariableType_ClientLastContactTime 2206
#define OpcUaId_SessionDiagnosticsVariableType_CurrentSubscriptionsCount 2207
#define OpcUaId_SessionDiagnosticsVariableType_CurrentMonitoredItemsCount 2208
#define OpcUaId_SessionDiagnosticsVariableType_CurrentPublishRequestsInQueue 2209
#define OpcUaId_SessionDiagnosticsVariableType_TotalRequestCount 8900
#define OpcUaId_SessionDiagnosticsVariableType_UnauthorizedRequestCount 11892
#define OpcUaId_SessionDiagnosticsVariableType_ReadCount 2217
#define OpcUaId_SessionDiagnosticsVariableType_HistoryReadCount 2218
#define OpcUaId_SessionDiagnosticsVariableType_WriteCount 2219
#define OpcUaId_SessionDiagnosticsVariableType_HistoryUpdateCount 2220
#define OpcUaId_SessionDiagnosticsVariableType_CallCount 2221
#define OpcUaId_SessionDiagnosticsVariableType_CreateMonitoredItemsCount 2222
#define OpcUaId_SessionDiagnosticsVariableType_ModifyMonitoredItemsCount 2223
#define OpcUaId_SessionDiagnosticsVariableType_SetMonitoringModeCount 2224
#define OpcUaId_SessionDiagnosticsVariableType_SetTriggeringCount 2225
#define OpcUaId_SessionDiagnosticsVariableType_DeleteMonitoredItemsCount 2226
#define OpcUaId_SessionDiagnosticsVariableType_CreateSubscriptionCount 2227
#define OpcUaId_SessionDiagnosticsVariableType_ModifySubscriptionCount 2228
#define OpcUaId_SessionDiagnosticsVariableType_SetPublishingModeCount 2229
#define OpcUaId_SessionDiagnosticsVariableType_PublishCount 2230
#define OpcUaId_SessionDiagnosticsVariableType_RepublishCount 2231
#define OpcUaId_SessionDiagnosticsVariableType_TransferSubscriptionsCount 2232
#define OpcUaId_SessionDiagnosticsVariableType_DeleteSubscriptionsCount 2233
#define OpcUaId_SessionDiagnosticsVariableType_AddNodesCount 2234
#define OpcUaId_SessionDiagnosticsVariableType_AddReferencesCount 2235
#define OpcUaId_SessionDiagnosticsVariableType_DeleteNodesCount 2236
#define OpcUaId_SessionDiagnosticsVariableType_DeleteReferencesCount 2237
#define OpcUaId_SessionDiagnosticsVariableType_BrowseCount 2238
#define OpcUaId_SessionDiagnosticsVariableType_BrowseNextCount 2239
#define OpcUaId_SessionDiagnosticsVariableType_TranslateBrowsePathsToNodeIdsCount 2240
#define OpcUaId_SessionDiagnosticsVariableType_QueryFirstCount 2241
#define OpcUaId_SessionDiagnosticsVariableType_QueryNextCount 2242
#define OpcUaId_SessionDiagnosticsVariableType_RegisterNodesCount 2730
#define OpcUaId_SessionDiagnosticsVariableType_UnregisterNodesCount 2731
#define OpcUaId_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics 12860
#define OpcUaId_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SessionId 12861
#define OpcUaId_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdOfSession 12862
#define OpcUaId_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdHistory 12863
#define OpcUaId_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_AuthenticationMechanism 12864
#define OpcUaId_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_Encoding 12865
#define OpcUaId_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_TransportProtocol 12866
#define OpcUaId_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityMode 12867
#define OpcUaId_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityPolicyUri 12868
#define OpcUaId_SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientCertificate 12869
#define OpcUaId_SessionSecurityDiagnosticsType_SessionId 2245
#define OpcUaId_SessionSecurityDiagnosticsType_ClientUserIdOfSession 2246
#define OpcUaId_SessionSecurityDiagnosticsType_ClientUserIdHistory 2247
#define OpcUaId_SessionSecurityDiagnosticsType_AuthenticationMechanism 2248
#define OpcUaId_SessionSecurityDiagnosticsType_Encoding 2249
#define OpcUaId_SessionSecurityDiagnosticsType_TransportProtocol 2250
#define OpcUaId_SessionSecurityDiagnosticsType_SecurityMode 2251
#define OpcUaId_SessionSecurityDiagnosticsType_SecurityPolicyUri 2252
#define OpcUaId_SessionSecurityDiagnosticsType_ClientCertificate 3058
#define OpcUaId_OptionSetType_OptionSetValues 11488
#define OpcUaId_OptionSetType_BitMask 11701
#define OpcUaId_SelectionListType_Selections 17632
#define OpcUaId_SelectionListType_SelectionDescriptions 17633
#define OpcUaId_SelectionListType_RestrictToList 16312
#define OpcUaId_AudioVariableType_ListId 17988
#define OpcUaId_AudioVariableType_AgencyId 17989
#define OpcUaId_AudioVariableType_VersionId 17990
#define OpcUaId_Server_ServerArray 2254
#define OpcUaId_Server_NamespaceArray 2255
#define OpcUaId_Server_UrisVersion 15004
#define OpcUaId_Server_ServerStatus 2256
#define OpcUaId_Server_ServerStatus_StartTime 2257
#define OpcUaId_Server_ServerStatus_CurrentTime 2258
#define OpcUaId_Server_ServerStatus_State 2259
#define OpcUaId_Server_ServerStatus_BuildInfo 2260
#define OpcUaId_Server_ServerStatus_BuildInfo_ProductUri 2262
#define OpcUaId_Server_ServerStatus_BuildInfo_ManufacturerName 2263
#define OpcUaId_Server_ServerStatus_BuildInfo_ProductName 2261
#define OpcUaId_Server_ServerStatus_BuildInfo_SoftwareVersion 2264
#define OpcUaId_Server_ServerStatus_BuildInfo_BuildNumber 2265
#define OpcUaId_Server_ServerStatus_BuildInfo_BuildDate 2266
#define OpcUaId_Server_ServerStatus_SecondsTillShutdown 2992
#define OpcUaId_Server_ServerStatus_ShutdownReason 2993
#define OpcUaId_Server_ServiceLevel 2267
#define OpcUaId_Server_Auditing 2994
#define OpcUaId_Server_EstimatedReturnTime 12885
#define OpcUaId_Server_LocalTime 17634
#define OpcUaId_Server_ServerCapabilities_ServerProfileArray 2269
#define OpcUaId_Server_ServerCapabilities_LocaleIdArray 2271
#define OpcUaId_Server_ServerCapabilities_MinSupportedSampleRate 2272
#define OpcUaId_Server_ServerCapabilities_MaxBrowseContinuationPoints 2735
#define OpcUaId_Server_ServerCapabilities_MaxQueryContinuationPoints 2736
#define OpcUaId_Server_ServerCapabilities_MaxHistoryContinuationPoints 2737
#define OpcUaId_Server_ServerCapabilities_SoftwareCertificates 3704
#define OpcUaId_Server_ServerCapabilities_MaxArrayLength 11702
#define OpcUaId_Server_ServerCapabilities_MaxStringLength 11703
#define OpcUaId_Server_ServerCapabilities_MaxByteStringLength 12911
#define OpcUaId_Server_ServerCapabilities_OperationLimits_MaxNodesPerRead 11705
#define OpcUaId_Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData 12165
#define OpcUaId_Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents 12166
#define OpcUaId_Server_ServerCapabilities_OperationLimits_MaxNodesPerWrite 11707
#define OpcUaId_Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData 12167
#define OpcUaId_Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents 12168
#define OpcUaId_Server_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall 11709
#define OpcUaId_Server_ServerCapabilities_OperationLimits_MaxNodesPerBrowse 11710
#define OpcUaId_Server_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes 11711
#define OpcUaId_Server_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds 11712
#define OpcUaId_Server_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement 11713
#define OpcUaId_Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall 11714
#define OpcUaId_Server_ServerCapabilities_RoleSet_AddRole_InputArguments 16302
#define OpcUaId_Server_ServerCapabilities_RoleSet_AddRole_OutputArguments 16303
#define OpcUaId_Server_ServerCapabilities_RoleSet_RemoveRole_InputArguments 16305
#define OpcUaId_Server_ServerCapabilities_MaxSessions 24095
#define OpcUaId_Server_ServerCapabilities_MaxSubscriptions 24096
#define OpcUaId_Server_ServerCapabilities_MaxMonitoredItems 24097
#define OpcUaId_Server_ServerCapabilities_MaxSubscriptionsPerSession 24098
#define OpcUaId_Server_ServerCapabilities_MaxMonitoredItemsPerSubscription 24104
#define OpcUaId_Server_ServerCapabilities_MaxSelectClauseParameters 24099
#define OpcUaId_Server_ServerCapabilities_MaxWhereClauseParameters 24100
#define OpcUaId_Server_ServerCapabilities_MaxMonitoredItemsQueueSize 31916
#define OpcUaId_Server_ServerCapabilities_ConformanceUnits 24101
#define OpcUaId_Server_ServerDiagnostics_ServerDiagnosticsSummary 2275
#define OpcUaId_Server_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount 2276
#define OpcUaId_Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount 2277
#define OpcUaId_Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount 2278
#define OpcUaId_Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount 2279
#define OpcUaId_Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount 3705
#define OpcUaId_Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount 2281
#define OpcUaId_Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount 2282
#define OpcUaId_Server_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount 2284
#define OpcUaId_Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount 2285
#define OpcUaId_Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount 2286
#define OpcUaId_Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount 2287
#define OpcUaId_Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount 2288
#define OpcUaId_Server_ServerDiagnostics_SamplingIntervalDiagnosticsArray 2289
#define OpcUaId_Server_ServerDiagnostics_SubscriptionDiagnosticsArray 2290
#define OpcUaId_Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray 3707
#define OpcUaId_Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray 3708
#define OpcUaId_Server_ServerDiagnostics_EnabledFlag 2294
#define OpcUaId_Server_ServerRedundancy_RedundancySupport 3709
#define OpcUaId_Server_GetMonitoredItems_InputArguments 11493
#define OpcUaId_Server_GetMonitoredItems_OutputArguments 11494
#define OpcUaId_Server_ResendData_InputArguments 12874
#define OpcUaId_Server_SetSubscriptionDurable_InputArguments 12750
#define OpcUaId_Server_SetSubscriptionDurable_OutputArguments 12751
#define OpcUaId_Server_RequestServerStateChange_InputArguments 12887
#define OpcUaId_Server_ServerRedundancy_CurrentServerId 11312
#define OpcUaId_Server_ServerRedundancy_RedundantServerArray 11313
#define OpcUaId_Server_ServerRedundancy_ServerUriArray 11314
#define OpcUaId_Server_ServerRedundancy_ServerNetworkGroups 14415
#define OpcUaId_HistoryServerCapabilities_AccessHistoryDataCapability 11193
#define OpcUaId_HistoryServerCapabilities_AccessHistoryEventsCapability 11242
#define OpcUaId_HistoryServerCapabilities_MaxReturnDataValues 11273
#define OpcUaId_HistoryServerCapabilities_MaxReturnEventValues 11274
#define OpcUaId_HistoryServerCapabilities_InsertDataCapability 11196
#define OpcUaId_HistoryServerCapabilities_ReplaceDataCapability 11197
#define OpcUaId_HistoryServerCapabilities_UpdateDataCapability 11198
#define OpcUaId_HistoryServerCapabilities_DeleteRawCapability 11199
#define OpcUaId_HistoryServerCapabilities_DeleteAtTimeCapability 11200
#define OpcUaId_HistoryServerCapabilities_InsertEventCapability 11281
#define OpcUaId_HistoryServerCapabilities_ReplaceEventCapability 11282
#define OpcUaId_HistoryServerCapabilities_UpdateEventCapability 11283
#define OpcUaId_HistoryServerCapabilities_DeleteEventCapability 11502
#define OpcUaId_HistoryServerCapabilities_InsertAnnotationCapability 11275
#define OpcUaId_HistoryServerCapabilities_ServerTimestampSupported 19091
#define OpcUaId_StateMachineType_CurrentState 2769
#define OpcUaId_StateMachineType_CurrentState_Id 3720
#define OpcUaId_StateMachineType_LastTransition 2770
#define OpcUaId_StateMachineType_LastTransition_Id 3724
#define OpcUaId_StateVariableType_Id 2756
#define OpcUaId_StateVariableType_Name 2757
#define OpcUaId_StateVariableType_Number 2758
#define OpcUaId_StateVariableType_EffectiveDisplayName 2759
#define OpcUaId_TransitionVariableType_Id 2763
#define OpcUaId_TransitionVariableType_Name 2764
#define OpcUaId_TransitionVariableType_Number 2765
#define OpcUaId_TransitionVariableType_TransitionTime 2766
#define OpcUaId_TransitionVariableType_EffectiveTransitionTime 11456
#define OpcUaId_FiniteStateMachineType_CurrentState 2772
#define OpcUaId_FiniteStateMachineType_CurrentState_Id 3728
#define OpcUaId_FiniteStateMachineType_LastTransition 2773
#define OpcUaId_FiniteStateMachineType_LastTransition_Id 3732
#define OpcUaId_FiniteStateMachineType_AvailableStates 17635
#define OpcUaId_FiniteStateMachineType_AvailableTransitions 17636
#define OpcUaId_FiniteStateVariableType_Id 2761
#define OpcUaId_FiniteTransitionVariableType_Id 2768
#define OpcUaId_StateType_StateNumber 2308
#define OpcUaId_TransitionType_TransitionNumber 2312
#define OpcUaId_ExpressionGuardVariableType_Expression 15129
#define OpcUaId_RationalNumberType_Numerator 17712
#define OpcUaId_RationalNumberType_Denominator 17713
#define OpcUaId_VectorType_VectorUnit 17715
#define OpcUaId_ThreeDVectorType_X 18769
#define OpcUaId_ThreeDVectorType_Y 18770
#define OpcUaId_ThreeDVectorType_Z 18771
#define OpcUaId_CartesianCoordinatesType_LengthUnit 18773
#define OpcUaId_ThreeDCartesianCoordinatesType_X 18776
#define OpcUaId_ThreeDCartesianCoordinatesType_Y 18777
#define OpcUaId_ThreeDCartesianCoordinatesType_Z 18778
#define OpcUaId_OrientationType_AngleUnit 18780
#define OpcUaId_ThreeDOrientationType_A 18783
#define OpcUaId_ThreeDOrientationType_B 18784
#define OpcUaId_ThreeDOrientationType_C 18785
#define OpcUaId_FrameType_CartesianCoordinates 18801
#define OpcUaId_FrameType_Orientation 18787
#define OpcUaId_FrameType_Constant 18788
#define OpcUaId_FrameType_BaseFrame 18789
#define OpcUaId_FrameType_FixedBase 18790
#define OpcUaId_ThreeDFrameType_CartesianCoordinates 18796
#define OpcUaId_ThreeDFrameType_Orientation 18792
#define OpcUaId_ThreeDFrameType_CartesianCoordinates_X 18798
#define OpcUaId_ThreeDFrameType_CartesianCoordinates_Y 18799
#define OpcUaId_ThreeDFrameType_CartesianCoordinates_Z 18800
#define OpcUaId_ThreeDFrameType_Orientation_A 19074
#define OpcUaId_ThreeDFrameType_Orientation_B 19075
#define OpcUaId_ThreeDFrameType_Orientation_C 19076
#define OpcUaId_TransitionEventType_Transition 2774
#define OpcUaId_TransitionEventType_Transition_Id 3754
#define OpcUaId_TransitionEventType_FromState 2775
#define OpcUaId_TransitionEventType_FromState_Id 3746
#define OpcUaId_TransitionEventType_ToState 2776
#define OpcUaId_TransitionEventType_ToState_Id 3750
#define OpcUaId_AuditUpdateStateEventType_OldStateId 2777
#define OpcUaId_AuditUpdateStateEventType_NewStateId 2778
#define OpcUaId_OpenFileMode_EnumValues 11940
#define OpcUaId_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_InputArguments 13356
#define OpcUaId_FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments 13357
#define OpcUaId_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_InputArguments 13359
#define OpcUaId_FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_OutputArguments 13360
#define OpcUaId_FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments 17719
#define OpcUaId_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments 13364
#define OpcUaId_FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments 13365
#define OpcUaId_FileDirectoryType_FileName_Placeholder_Size 13367
#define OpcUaId_FileDirectoryType_FileName_Placeholder_Writable 13368
#define OpcUaId_FileDirectoryType_FileName_Placeholder_UserWritable 13369
#define OpcUaId_FileDirectoryType_FileName_Placeholder_OpenCount 13370
#define OpcUaId_FileDirectoryType_FileName_Placeholder_Open_InputArguments 13373
#define OpcUaId_FileDirectoryType_FileName_Placeholder_Open_OutputArguments 13374
#define OpcUaId_FileDirectoryType_FileName_Placeholder_Close_InputArguments 13376
#define OpcUaId_FileDirectoryType_FileName_Placeholder_Read_InputArguments 13378
#define OpcUaId_FileDirectoryType_FileName_Placeholder_Read_OutputArguments 13379
#define OpcUaId_FileDirectoryType_FileName_Placeholder_Write_InputArguments 13381
#define OpcUaId_FileDirectoryType_FileName_Placeholder_GetPosition_InputArguments 13383
#define OpcUaId_FileDirectoryType_FileName_Placeholder_GetPosition_OutputArguments 13384
#define OpcUaId_FileDirectoryType_FileName_Placeholder_SetPosition_InputArguments 13386
#define OpcUaId_FileDirectoryType_CreateDirectory_InputArguments 13388
#define OpcUaId_FileDirectoryType_CreateDirectory_OutputArguments 13389
#define OpcUaId_FileDirectoryType_CreateFile_InputArguments 13391
#define OpcUaId_FileDirectoryType_CreateFile_OutputArguments 13392
#define OpcUaId_FileDirectoryType_DeleteFileSystemObject_InputArguments 13394
#define OpcUaId_FileDirectoryType_MoveOrCopy_InputArguments 13396
#define OpcUaId_FileDirectoryType_MoveOrCopy_OutputArguments 13397
#define OpcUaId_FileSystem_FileDirectoryName_Placeholder_CreateDirectory_InputArguments 16317
#define OpcUaId_FileSystem_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments 16318
#define OpcUaId_FileSystem_FileDirectoryName_Placeholder_CreateFile_InputArguments 16320
#define OpcUaId_FileSystem_FileDirectoryName_Placeholder_CreateFile_OutputArguments 16321
#define OpcUaId_FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments 17723
#define OpcUaId_FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments 16325
#define OpcUaId_FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments 16326
#define OpcUaId_FileSystem_FileName_Placeholder_Size 16328
#define OpcUaId_FileSystem_FileName_Placeholder_Writable 16329
#define OpcUaId_FileSystem_FileName_Placeholder_UserWritable 16330
#define OpcUaId_FileSystem_FileName_Placeholder_OpenCount 16331
#define OpcUaId_FileSystem_FileName_Placeholder_Open_InputArguments 16334
#define OpcUaId_FileSystem_FileName_Placeholder_Open_OutputArguments 16335
#define OpcUaId_FileSystem_FileName_Placeholder_Close_InputArguments 16337
#define OpcUaId_FileSystem_FileName_Placeholder_Read_InputArguments 16339
#define OpcUaId_FileSystem_FileName_Placeholder_Read_OutputArguments 16340
#define OpcUaId_FileSystem_FileName_Placeholder_Write_InputArguments 16342
#define OpcUaId_FileSystem_FileName_Placeholder_GetPosition_InputArguments 16344
#define OpcUaId_FileSystem_FileName_Placeholder_GetPosition_OutputArguments 16345
#define OpcUaId_FileSystem_FileName_Placeholder_SetPosition_InputArguments 16347
#define OpcUaId_FileSystem_CreateDirectory_InputArguments 16349
#define OpcUaId_FileSystem_CreateDirectory_OutputArguments 16350
#define OpcUaId_FileSystem_CreateFile_InputArguments 16352
#define OpcUaId_FileSystem_CreateFile_OutputArguments 16353
#define OpcUaId_FileSystem_DeleteFileSystemObject_InputArguments 16355
#define OpcUaId_FileSystem_MoveOrCopy_InputArguments 16357
#define OpcUaId_FileSystem_MoveOrCopy_OutputArguments 16358
#define OpcUaId_TemporaryFileTransferType_ClientProcessingTimeout 15745
#define OpcUaId_TemporaryFileTransferType_GenerateFileForRead_InputArguments 15747
#define OpcUaId_TemporaryFileTransferType_GenerateFileForRead_OutputArguments 15748
#define OpcUaId_TemporaryFileTransferType_GenerateFileForWrite_InputArguments 16359
#define OpcUaId_TemporaryFileTransferType_GenerateFileForWrite_OutputArguments 15750
#define OpcUaId_TemporaryFileTransferType_CloseAndCommit_InputArguments 15752
#define OpcUaId_TemporaryFileTransferType_CloseAndCommit_OutputArguments 15753
#define OpcUaId_TemporaryFileTransferType_TransferState_Placeholder_CurrentState 15755
#define OpcUaId_TemporaryFileTransferType_TransferState_Placeholder_CurrentState_Id 15756
#define OpcUaId_TemporaryFileTransferType_TransferState_Placeholder_LastTransition_Id 15761
#define OpcUaId_FileTransferStateMachineType_CurrentState_Id 15805
#define OpcUaId_FileTransferStateMachineType_LastTransition_Id 15810
#define OpcUaId_FileTransferStateMachineType_Idle_StateNumber 15816
#define OpcUaId_FileTransferStateMachineType_ReadPrepare_StateNumber 15818
#define OpcUaId_FileTransferStateMachineType_ReadTransfer_StateNumber 15820
#define OpcUaId_FileTransferStateMachineType_ApplyWrite_StateNumber 15822
#define OpcUaId_FileTransferStateMachineType_Error_StateNumber 15824
#define OpcUaId_FileTransferStateMachineType_IdleToReadPrepare_TransitionNumber 15826
#define OpcUaId_FileTransferStateMachineType_ReadPrepareToReadTransfer_TransitionNumber 15828
#define OpcUaId_FileTransferStateMachineType_ReadTransferToIdle_TransitionNumber 15830
#define OpcUaId_FileTransferStateMachineType_IdleToApplyWrite_TransitionNumber 15832
#define OpcUaId_FileTransferStateMachineType_ApplyWriteToIdle_TransitionNumber 15834
#define OpcUaId_FileTransferStateMachineType_ReadPrepareToError_TransitionNumber 15836
#define OpcUaId_FileTransferStateMachineType_ReadTransferToError_TransitionNumber 15838
#define OpcUaId_FileTransferStateMachineType_ApplyWriteToError_TransitionNumber 15840
#define OpcUaId_FileTransferStateMachineType_ErrorToIdle_TransitionNumber 15842
#define OpcUaId_RoleSetType_RoleName_Placeholder_Identities 16162
#define OpcUaId_RoleSetType_RoleName_Placeholder_AddIdentity_InputArguments 15613
#define OpcUaId_RoleSetType_RoleName_Placeholder_RemoveIdentity_InputArguments 15615
#define OpcUaId_RoleSetType_RoleName_Placeholder_AddApplication_InputArguments 16166
#define OpcUaId_RoleSetType_RoleName_Placeholder_RemoveApplication_InputArguments 16168
#define OpcUaId_RoleSetType_RoleName_Placeholder_AddEndpoint_InputArguments 16170
#define OpcUaId_RoleSetType_RoleName_Placeholder_RemoveEndpoint_InputArguments 16172
#define OpcUaId_RoleSetType_AddRole_InputArguments 15998
#define OpcUaId_RoleSetType_AddRole_OutputArguments 15999
#define OpcUaId_RoleSetType_RemoveRole_InputArguments 16001
#define OpcUaId_RoleType_Identities 16173
#define OpcUaId_RoleType_ApplicationsExclude 15410
#define OpcUaId_RoleType_Applications 16174
#define OpcUaId_RoleType_EndpointsExclude 15411
#define OpcUaId_RoleType_Endpoints 16175
#define OpcUaId_RoleType_CustomConfiguration 24139
#define OpcUaId_RoleType_AddIdentity_InputArguments 15625
#define OpcUaId_RoleType_RemoveIdentity_InputArguments 15627
#define OpcUaId_RoleType_AddApplication_InputArguments 16177
#define OpcUaId_RoleType_RemoveApplication_InputArguments 16179
#define OpcUaId_RoleType_AddEndpoint_InputArguments 16181
#define OpcUaId_RoleType_RemoveEndpoint_InputArguments 16183
#define OpcUaId_IdentityCriteriaType_EnumValues 15633
#define OpcUaId_WellKnownRole_Anonymous_Identities 16192
#define OpcUaId_WellKnownRole_Anonymous_ApplicationsExclude 15412
#define OpcUaId_WellKnownRole_Anonymous_Applications 16193
#define OpcUaId_WellKnownRole_Anonymous_EndpointsExclude 15413
#define OpcUaId_WellKnownRole_Anonymous_Endpoints 16194
#define OpcUaId_WellKnownRole_Anonymous_AddIdentity_InputArguments 15649
#define OpcUaId_WellKnownRole_Anonymous_RemoveIdentity_InputArguments 15651
#define OpcUaId_WellKnownRole_Anonymous_AddApplication_InputArguments 16196
#define OpcUaId_WellKnownRole_Anonymous_RemoveApplication_InputArguments 16198
#define OpcUaId_WellKnownRole_Anonymous_AddEndpoint_InputArguments 16200
#define OpcUaId_WellKnownRole_Anonymous_RemoveEndpoint_InputArguments 16202
#define OpcUaId_WellKnownRole_AuthenticatedUser_Identities 16203
#define OpcUaId_WellKnownRole_AuthenticatedUser_ApplicationsExclude 15414
#define OpcUaId_WellKnownRole_AuthenticatedUser_Applications 16204
#define OpcUaId_WellKnownRole_AuthenticatedUser_EndpointsExclude 15415
#define OpcUaId_WellKnownRole_AuthenticatedUser_Endpoints 16205
#define OpcUaId_WellKnownRole_AuthenticatedUser_CustomConfiguration 24141
#define OpcUaId_WellKnownRole_AuthenticatedUser_AddIdentity_InputArguments 15661
#define OpcUaId_WellKnownRole_AuthenticatedUser_RemoveIdentity_InputArguments 15663
#define OpcUaId_WellKnownRole_AuthenticatedUser_AddApplication_InputArguments 16207
#define OpcUaId_WellKnownRole_AuthenticatedUser_RemoveApplication_InputArguments 16209
#define OpcUaId_WellKnownRole_AuthenticatedUser_AddEndpoint_InputArguments 16211
#define OpcUaId_WellKnownRole_AuthenticatedUser_RemoveEndpoint_InputArguments 16213
#define OpcUaId_WellKnownRole_Observer_Identities 16214
#define OpcUaId_WellKnownRole_Observer_ApplicationsExclude 15416
#define OpcUaId_WellKnownRole_Observer_Applications 16215
#define OpcUaId_WellKnownRole_Observer_EndpointsExclude 15417
#define OpcUaId_WellKnownRole_Observer_Endpoints 16216
#define OpcUaId_WellKnownRole_Observer_CustomConfiguration 24142
#define OpcUaId_WellKnownRole_Observer_AddIdentity_InputArguments 15673
#define OpcUaId_WellKnownRole_Observer_RemoveIdentity_InputArguments 15675
#define OpcUaId_WellKnownRole_Observer_AddApplication_InputArguments 16218
#define OpcUaId_WellKnownRole_Observer_RemoveApplication_InputArguments 16220
#define OpcUaId_WellKnownRole_Observer_AddEndpoint_InputArguments 16222
#define OpcUaId_WellKnownRole_Observer_RemoveEndpoint_InputArguments 16224
#define OpcUaId_WellKnownRole_Operator_Identities 16225
#define OpcUaId_WellKnownRole_Operator_ApplicationsExclude 15418
#define OpcUaId_WellKnownRole_Operator_Applications 16226
#define OpcUaId_WellKnownRole_Operator_EndpointsExclude 15423
#define OpcUaId_WellKnownRole_Operator_Endpoints 16227
#define OpcUaId_WellKnownRole_Operator_CustomConfiguration 24143
#define OpcUaId_WellKnownRole_Operator_AddIdentity_InputArguments 15685
#define OpcUaId_WellKnownRole_Operator_RemoveIdentity_InputArguments 15687
#define OpcUaId_WellKnownRole_Operator_AddApplication_InputArguments 16229
#define OpcUaId_WellKnownRole_Operator_RemoveApplication_InputArguments 16231
#define OpcUaId_WellKnownRole_Operator_AddEndpoint_InputArguments 16233
#define OpcUaId_WellKnownRole_Operator_RemoveEndpoint_InputArguments 16235
#define OpcUaId_WellKnownRole_Engineer_Identities 16236
#define OpcUaId_WellKnownRole_Engineer_ApplicationsExclude 15424
#define OpcUaId_WellKnownRole_Engineer_Applications 16237
#define OpcUaId_WellKnownRole_Engineer_EndpointsExclude 15425
#define OpcUaId_WellKnownRole_Engineer_Endpoints 16238
#define OpcUaId_WellKnownRole_Engineer_CustomConfiguration 24144
#define OpcUaId_WellKnownRole_Engineer_AddIdentity_InputArguments 16042
#define OpcUaId_WellKnownRole_Engineer_RemoveIdentity_InputArguments 16044
#define OpcUaId_WellKnownRole_Engineer_AddApplication_InputArguments 16240
#define OpcUaId_WellKnownRole_Engineer_RemoveApplication_InputArguments 16242
#define OpcUaId_WellKnownRole_Engineer_AddEndpoint_InputArguments 16244
#define OpcUaId_WellKnownRole_Engineer_RemoveEndpoint_InputArguments 16246
#define OpcUaId_WellKnownRole_Supervisor_Identities 16247
#define OpcUaId_WellKnownRole_Supervisor_ApplicationsExclude 15426
#define OpcUaId_WellKnownRole_Supervisor_Applications 16248
#define OpcUaId_WellKnownRole_Supervisor_EndpointsExclude 15427
#define OpcUaId_WellKnownRole_Supervisor_Endpoints 16249
#define OpcUaId_WellKnownRole_Supervisor_CustomConfiguration 24145
#define OpcUaId_WellKnownRole_Supervisor_AddIdentity_InputArguments 15697
#define OpcUaId_WellKnownRole_Supervisor_RemoveIdentity_InputArguments 15699
#define OpcUaId_WellKnownRole_Supervisor_AddApplication_InputArguments 16251
#define OpcUaId_WellKnownRole_Supervisor_RemoveApplication_InputArguments 16253
#define OpcUaId_WellKnownRole_Supervisor_AddEndpoint_InputArguments 16255
#define OpcUaId_WellKnownRole_Supervisor_RemoveEndpoint_InputArguments 16257
#define OpcUaId_WellKnownRole_ConfigureAdmin_Identities 16269
#define OpcUaId_WellKnownRole_ConfigureAdmin_ApplicationsExclude 15428
#define OpcUaId_WellKnownRole_ConfigureAdmin_Applications 16270
#define OpcUaId_WellKnownRole_ConfigureAdmin_EndpointsExclude 15429
#define OpcUaId_WellKnownRole_ConfigureAdmin_Endpoints 16271
#define OpcUaId_WellKnownRole_ConfigureAdmin_CustomConfiguration 24146
#define OpcUaId_WellKnownRole_ConfigureAdmin_AddIdentity_InputArguments 15721
#define OpcUaId_WellKnownRole_ConfigureAdmin_RemoveIdentity_InputArguments 15723
#define OpcUaId_WellKnownRole_ConfigureAdmin_AddApplication_InputArguments 16273
#define OpcUaId_WellKnownRole_ConfigureAdmin_RemoveApplication_InputArguments 16275
#define OpcUaId_WellKnownRole_ConfigureAdmin_AddEndpoint_InputArguments 16277
#define OpcUaId_WellKnownRole_ConfigureAdmin_RemoveEndpoint_InputArguments 16279
#define OpcUaId_WellKnownRole_SecurityAdmin_Identities 16258
#define OpcUaId_WellKnownRole_SecurityAdmin_ApplicationsExclude 15430
#define OpcUaId_WellKnownRole_SecurityAdmin_Applications 16259
#define OpcUaId_WellKnownRole_SecurityAdmin_EndpointsExclude 15527
#define OpcUaId_WellKnownRole_SecurityAdmin_Endpoints 16260
#define OpcUaId_WellKnownRole_SecurityAdmin_CustomConfiguration 24147
#define OpcUaId_WellKnownRole_SecurityAdmin_AddIdentity_InputArguments 15709
#define OpcUaId_WellKnownRole_SecurityAdmin_RemoveIdentity_InputArguments 15711
#define OpcUaId_WellKnownRole_SecurityAdmin_AddApplication_InputArguments 16262
#define OpcUaId_WellKnownRole_SecurityAdmin_RemoveApplication_InputArguments 16264
#define OpcUaId_WellKnownRole_SecurityAdmin_AddEndpoint_InputArguments 16266
#define OpcUaId_WellKnownRole_SecurityAdmin_RemoveEndpoint_InputArguments 16268
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_Identities 25566
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_ApplicationsExclude 25567
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_Applications 25568
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_EndpointsExclude 25569
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_Endpoints 25570
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_CustomConfiguration 25571
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_AddIdentity_InputArguments 25573
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity_InputArguments 25575
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_AddApplication_InputArguments 25577
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_RemoveApplication_InputArguments 25579
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_AddEndpoint_InputArguments 25581
#define OpcUaId_WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint_InputArguments 25583
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_Identities 25604
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_ApplicationsExclude 25605
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_Applications 25606
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_EndpointsExclude 25607
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_Endpoints 25608
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_CustomConfiguration 25609
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_AddIdentity_InputArguments 25611
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_RemoveIdentity_InputArguments 25613
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_AddApplication_InputArguments 25615
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_RemoveApplication_InputArguments 25617
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_AddEndpoint_InputArguments 25619
#define OpcUaId_WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint_InputArguments 25621
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_Identities 25585
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_ApplicationsExclude 25586
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_Applications 25587
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_EndpointsExclude 25588
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_Endpoints 25589
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_CustomConfiguration 25590
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_AddIdentity_InputArguments 25592
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_RemoveIdentity_InputArguments 25594
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_AddApplication_InputArguments 25596
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_RemoveApplication_InputArguments 25598
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_AddEndpoint_InputArguments 25600
#define OpcUaId_WellKnownRole_SecurityKeyServerPush_RemoveEndpoint_InputArguments 25602
#define OpcUaId_CurrencyUnit 23501
#define OpcUaId_IOrderedObjectType_NumberInList 23517
#define OpcUaId_OrderedListType_OrderedObject_Placeholder_NumberInList 23521
#define OpcUaId_OrderedListType_NodeVersion 23525
#define OpcUaId_DataItemType_Definition 2366
#define OpcUaId_DataItemType_ValuePrecision 2367
#define OpcUaId_BaseAnalogType_InstrumentRange 17567
#define OpcUaId_BaseAnalogType_EURange 17568
#define OpcUaId_BaseAnalogType_EngineeringUnits 17569
#define OpcUaId_AnalogItemType_EURange 2369
#define OpcUaId_AnalogUnitType_EngineeringUnits 17502
#define OpcUaId_AnalogUnitRangeType_EngineeringUnits 17575
#define OpcUaId_TwoStateDiscreteType_FalseState 2374
#define OpcUaId_TwoStateDiscreteType_TrueState 2375
#define OpcUaId_MultiStateDiscreteType_EnumStrings 2377
#define OpcUaId_MultiStateValueDiscreteType_EnumValues 11241
#define OpcUaId_MultiStateValueDiscreteType_ValueAsText 11461
#define OpcUaId_ArrayItemType_InstrumentRange 12024
#define OpcUaId_ArrayItemType_EURange 12025
#define OpcUaId_ArrayItemType_EngineeringUnits 12026
#define OpcUaId_ArrayItemType_Title 12027
#define OpcUaId_ArrayItemType_AxisScaleType 12028
#define OpcUaId_YArrayItemType_XAxisDefinition 12037
#define OpcUaId_XYArrayItemType_XAxisDefinition 12046
#define OpcUaId_ImageItemType_XAxisDefinition 12055
#define OpcUaId_ImageItemType_YAxisDefinition 12056
#define OpcUaId_CubeItemType_XAxisDefinition 12065
#define OpcUaId_CubeItemType_YAxisDefinition 12066
#define OpcUaId_CubeItemType_ZAxisDefinition 12067
#define OpcUaId_NDimensionArrayItemType_AxisDefinition 12076
#define OpcUaId_TwoStateVariableType_Id 8996
#define OpcUaId_TwoStateVariableType_TransitionTime 9000
#define OpcUaId_TwoStateVariableType_EffectiveTransitionTime 9001
#define OpcUaId_TwoStateVariableType_TrueState 11110
#define OpcUaId_TwoStateVariableType_FalseState 11111
#define OpcUaId_ConditionVariableType_SourceTimestamp 9003
#define OpcUaId_ConditionType_ConditionClassId 11112
#define OpcUaId_ConditionType_ConditionClassName 11113
#define OpcUaId_ConditionType_ConditionName 9009
#define OpcUaId_ConditionType_BranchId 9010
#define OpcUaId_ConditionType_Retain 3874
#define OpcUaId_ConditionType_SupportsFilteredRetain 32060
#define OpcUaId_ConditionType_EnabledState 9011
#define OpcUaId_ConditionType_EnabledState_Id 9012
#define OpcUaId_ConditionType_EnabledState_EffectiveDisplayName 9015
#define OpcUaId_ConditionType_EnabledState_TransitionTime 9016
#define OpcUaId_ConditionType_EnabledState_EffectiveTransitionTime 9017
#define OpcUaId_ConditionType_EnabledState_TrueState 9018
#define OpcUaId_ConditionType_EnabledState_FalseState 9019
#define OpcUaId_ConditionType_Quality 9020
#define OpcUaId_ConditionType_Quality_SourceTimestamp 9021
#define OpcUaId_ConditionType_LastSeverity 9022
#define OpcUaId_ConditionType_LastSeverity_SourceTimestamp 9023
#define OpcUaId_ConditionType_Comment 9024
#define OpcUaId_ConditionType_Comment_SourceTimestamp 9025
#define OpcUaId_ConditionType_ClientUserId 9026
#define OpcUaId_ConditionType_AddComment_InputArguments 9030
#define OpcUaId_ConditionType_ConditionRefresh_InputArguments 3876
#define OpcUaId_ConditionType_ConditionRefresh2_InputArguments 12913
#define OpcUaId_DialogConditionType_EnabledState 9035
#define OpcUaId_DialogConditionType_EnabledState_Id 9036
#define OpcUaId_DialogConditionType_Quality_SourceTimestamp 9045
#define OpcUaId_DialogConditionType_LastSeverity_SourceTimestamp 9047
#define OpcUaId_DialogConditionType_Comment_SourceTimestamp 9049
#define OpcUaId_DialogConditionType_AddComment_InputArguments 9054
#define OpcUaId_DialogConditionType_ConditionRefresh_InputArguments 4199
#define OpcUaId_DialogConditionType_ConditionRefresh2_InputArguments 12917
#define OpcUaId_DialogConditionType_DialogState 9055
#define OpcUaId_DialogConditionType_DialogState_Id 9056
#define OpcUaId_DialogConditionType_DialogState_TransitionTime 9060
#define OpcUaId_DialogConditionType_DialogState_TrueState 9062
#define OpcUaId_DialogConditionType_DialogState_FalseState 9063
#define OpcUaId_DialogConditionType_Prompt 2831
#define OpcUaId_DialogConditionType_ResponseOptionSet 9064
#define OpcUaId_DialogConditionType_DefaultResponse 9065
#define OpcUaId_DialogConditionType_OkResponse 9066
#define OpcUaId_DialogConditionType_CancelResponse 9067
#define OpcUaId_DialogConditionType_LastResponse 9068
#define OpcUaId_DialogConditionType_Respond_InputArguments 9070
#define OpcUaId_DialogConditionType_Respond2_InputArguments 24313
#define OpcUaId_AcknowledgeableConditionType_EnabledState 9073
#define OpcUaId_AcknowledgeableConditionType_EnabledState_Id 9074
#define OpcUaId_AcknowledgeableConditionType_Quality_SourceTimestamp 9083
#define OpcUaId_AcknowledgeableConditionType_LastSeverity_SourceTimestamp 9085
#define OpcUaId_AcknowledgeableConditionType_Comment_SourceTimestamp 9087
#define OpcUaId_AcknowledgeableConditionType_AddComment_InputArguments 9092
#define OpcUaId_AcknowledgeableConditionType_ConditionRefresh_InputArguments 5124
#define OpcUaId_AcknowledgeableConditionType_ConditionRefresh2_InputArguments 12919
#define OpcUaId_AcknowledgeableConditionType_AckedState 9093
#define OpcUaId_AcknowledgeableConditionType_AckedState_Id 9094
#define OpcUaId_AcknowledgeableConditionType_AckedState_TransitionTime 9098
#define OpcUaId_AcknowledgeableConditionType_AckedState_TrueState 9100
#define OpcUaId_AcknowledgeableConditionType_AckedState_FalseState 9101
#define OpcUaId_AcknowledgeableConditionType_ConfirmedState 9102
#define OpcUaId_AcknowledgeableConditionType_ConfirmedState_Id 9103
#define OpcUaId_AcknowledgeableConditionType_ConfirmedState_TransitionTime 9107
#define OpcUaId_AcknowledgeableConditionType_ConfirmedState_TrueState 9109
#define OpcUaId_AcknowledgeableConditionType_ConfirmedState_FalseState 9110
#define OpcUaId_AcknowledgeableConditionType_Acknowledge_InputArguments 9112
#define OpcUaId_AcknowledgeableConditionType_Confirm_InputArguments 9114
#define OpcUaId_AlarmConditionType_EnabledState 9118
#define OpcUaId_AlarmConditionType_EnabledState_Id 9119
#define OpcUaId_AlarmConditionType_Quality_SourceTimestamp 9128
#define OpcUaId_AlarmConditionType_LastSeverity_SourceTimestamp 9130
#define OpcUaId_AlarmConditionType_Comment_SourceTimestamp 9132
#define OpcUaId_AlarmConditionType_AddComment_InputArguments 9137
#define OpcUaId_AlarmConditionType_ConditionRefresh_InputArguments 5551
#define OpcUaId_AlarmConditionType_ConditionRefresh2_InputArguments 12985
#define OpcUaId_AlarmConditionType_AckedState_Id 9139
#define OpcUaId_AlarmConditionType_ConfirmedState_Id 9148
#define OpcUaId_AlarmConditionType_Acknowledge_InputArguments 9157
#define OpcUaId_AlarmConditionType_Confirm_InputArguments 9159
#define OpcUaId_AlarmConditionType_ActiveState 9160
#define OpcUaId_AlarmConditionType_ActiveState_Id 9161
#define OpcUaId_AlarmConditionType_ActiveState_EffectiveDisplayName 9164
#define OpcUaId_AlarmConditionType_ActiveState_TransitionTime 9165
#define OpcUaId_AlarmConditionType_ActiveState_EffectiveTransitionTime 9166
#define OpcUaId_AlarmConditionType_ActiveState_TrueState 9167
#define OpcUaId_AlarmConditionType_ActiveState_FalseState 9168
#define OpcUaId_AlarmConditionType_InputNode 11120
#define OpcUaId_AlarmConditionType_SuppressedState 9169
#define OpcUaId_AlarmConditionType_SuppressedState_Id 9170
#define OpcUaId_AlarmConditionType_SuppressedState_TransitionTime 9174
#define OpcUaId_AlarmConditionType_SuppressedState_TrueState 9176
#define OpcUaId_AlarmConditionType_SuppressedState_FalseState 9177
#define OpcUaId_AlarmConditionType_OutOfServiceState 16371
#define OpcUaId_AlarmConditionType_OutOfServiceState_Id 16372
#define OpcUaId_AlarmConditionType_OutOfServiceState_TransitionTime 16376
#define OpcUaId_AlarmConditionType_OutOfServiceState_TrueState 16378
#define OpcUaId_AlarmConditionType_OutOfServiceState_FalseState 16379
#define OpcUaId_AlarmConditionType_ShelvingState_CurrentState 9179
#define OpcUaId_AlarmConditionType_ShelvingState_CurrentState_Id 9180
#define OpcUaId_AlarmConditionType_ShelvingState_LastTransition 9184
#define OpcUaId_AlarmConditionType_ShelvingState_LastTransition_Id 9185
#define OpcUaId_AlarmConditionType_ShelvingState_LastTransition_TransitionTime 9188
#define OpcUaId_AlarmConditionType_ShelvingState_UnshelveTime 9189
#define OpcUaId_AlarmConditionType_ShelvingState_TimedShelve_InputArguments 9214
#define OpcUaId_AlarmConditionType_ShelvingState_TimedShelve2_InputArguments 24739
#define OpcUaId_AlarmConditionType_ShelvingState_Unshelve2_InputArguments 24741
#define OpcUaId_AlarmConditionType_ShelvingState_OneShotShelve2_InputArguments 24743
#define OpcUaId_AlarmConditionType_SuppressedOrShelved 9215
#define OpcUaId_AlarmConditionType_MaxTimeShelved 9216
#define OpcUaId_AlarmConditionType_AudibleEnabled 16389
#define OpcUaId_AlarmConditionType_AudibleSound 16390
#define OpcUaId_AlarmConditionType_SilenceState 16380
#define OpcUaId_AlarmConditionType_SilenceState_Id 16381
#define OpcUaId_AlarmConditionType_SilenceState_TransitionTime 16385
#define OpcUaId_AlarmConditionType_SilenceState_TrueState 16387
#define OpcUaId_AlarmConditionType_SilenceState_FalseState 16388
#define OpcUaId_AlarmConditionType_OnDelay 16395
#define OpcUaId_AlarmConditionType_OffDelay 16396
#define OpcUaId_AlarmConditionType_FirstInGroupFlag 16397
#define OpcUaId_AlarmConditionType_LatchedState 18190
#define OpcUaId_AlarmConditionType_LatchedState_Id 18191
#define OpcUaId_AlarmConditionType_LatchedState_TransitionTime 18195
#define OpcUaId_AlarmConditionType_LatchedState_TrueState 18197
#define OpcUaId_AlarmConditionType_LatchedState_FalseState 18198
#define OpcUaId_AlarmConditionType_ReAlarmTime 16400
#define OpcUaId_AlarmConditionType_ReAlarmRepeatCount 16401
#define OpcUaId_AlarmConditionType_Suppress2_InputArguments 24317
#define OpcUaId_AlarmConditionType_Unsuppress2_InputArguments 24319
#define OpcUaId_AlarmConditionType_RemoveFromService2_InputArguments 24321
#define OpcUaId_AlarmConditionType_PlaceInService2_InputArguments 24323
#define OpcUaId_AlarmConditionType_Reset2_InputArguments 24325
#define OpcUaId_AlarmConditionType_GetGroupMemberships_OutputArguments 25154
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_EventId 16407
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_EventType 16408
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_SourceNode 16409
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_SourceName 16410
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_Time 16411
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ReceiveTime 16412
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_Message 16414
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_Severity 16415
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionClassId 16416
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionClassName 16417
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionName 16420
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_BranchId 16421
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_Retain 16422
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState 16423
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_Id 16424
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_Quality 16432
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_Quality_SourceTimestamp 16433
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_LastSeverity 16434
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_LastSeverity_SourceTimestamp 16435
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_Comment 16436
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_Comment_SourceTimestamp 16437
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ClientUserId 16438
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment_InputArguments 16442
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState 16443
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_Id 16444
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_Id 16453
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge_InputArguments 16462
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm_InputArguments 16464
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState 16465
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_Id 16466
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_InputNode 16474
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_Id 16476
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_Id 16485
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState 16503
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_Id 16504
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_Id 16509
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_UnshelveTime 16514
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve_InputArguments 16518
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2_InputArguments 24749
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2_InputArguments 24751
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2_InputArguments 24753
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedOrShelved 16519
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_Id 16494
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_Id 18204
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress2_InputArguments 24329
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress2_InputArguments 24331
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2_InputArguments 24333
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService2_InputArguments 24335
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_Reset2_InputArguments 24337
#define OpcUaId_AlarmGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships_OutputArguments 25156
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EventId 32066
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EventType 32067
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SourceNode 32068
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SourceName 32069
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Time 32070
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ReceiveTime 32071
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Message 32073
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Severity 32074
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConditionClassId 32075
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConditionClassName 32076
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConditionName 32079
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_BranchId 32080
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Retain 32081
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EnabledState 32082
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EnabledState_Id 32083
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Quality 32091
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Quality_SourceTimestamp 32092
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LastSeverity 32093
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LastSeverity_SourceTimestamp 32094
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Comment 32095
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Comment_SourceTimestamp 32096
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ClientUserId 32097
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AddComment_InputArguments 32101
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AckedState 32102
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AckedState_Id 32103
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_Id 32112
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Acknowledge_InputArguments 32121
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Confirm_InputArguments 32123
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ActiveState 32124
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ActiveState_Id 32125
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_InputNode 32133
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SuppressedState_Id 32135
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_Id 32144
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState 32153
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_Id 32154
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_Id 32159
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_UnshelveTime 32166
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve_InputArguments 32168
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2_InputArguments 32170
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2_InputArguments 32173
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2_InputArguments 32176
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SuppressedOrShelved 32177
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SilenceState_Id 32185
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LatchedState_Id 32198
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Suppress2_InputArguments 32211
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Unsuppress2_InputArguments 32214
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2_InputArguments 32217
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_PlaceInService2_InputArguments 32220
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Reset2_InputArguments 32223
#define OpcUaId_AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships_OutputArguments 32225
#define OpcUaId_AlarmSuppressionGroupType_DigitalVariable_Placeholder 32226
#define OpcUaId_ShelvedStateMachineType_CurrentState_Id 6089
#define OpcUaId_ShelvedStateMachineType_LastTransition_Id 6094
#define OpcUaId_ShelvedStateMachineType_UnshelveTime 9115
#define OpcUaId_ShelvedStateMachineType_Unshelved_StateNumber 6098
#define OpcUaId_ShelvedStateMachineType_TimedShelved_StateNumber 6100
#define OpcUaId_ShelvedStateMachineType_OneShotShelved_StateNumber 6101
#define OpcUaId_ShelvedStateMachineType_UnshelvedToTimedShelved_TransitionNumber 11322
#define OpcUaId_ShelvedStateMachineType_UnshelvedToOneShotShelved_TransitionNumber 11323
#define OpcUaId_ShelvedStateMachineType_TimedShelvedToUnshelved_TransitionNumber 11324
#define OpcUaId_ShelvedStateMachineType_TimedShelvedToOneShotShelved_TransitionNumber 11325
#define OpcUaId_ShelvedStateMachineType_OneShotShelvedToUnshelved_TransitionNumber 11326
#define OpcUaId_ShelvedStateMachineType_OneShotShelvedToTimedShelved_TransitionNumber 11327
#define OpcUaId_ShelvedStateMachineType_TimedShelve_InputArguments 2991
#define OpcUaId_ShelvedStateMachineType_TimedShelve2_InputArguments 24757
#define OpcUaId_ShelvedStateMachineType_Unshelve2_InputArguments 24759
#define OpcUaId_ShelvedStateMachineType_OneShotShelve2_InputArguments 24761
#define OpcUaId_LimitAlarmType_EnabledState_Id 9220
#define OpcUaId_LimitAlarmType_Quality_SourceTimestamp 9229
#define OpcUaId_LimitAlarmType_LastSeverity_SourceTimestamp 9231
#define OpcUaId_LimitAlarmType_Comment_SourceTimestamp 9233
#define OpcUaId_LimitAlarmType_AddComment_InputArguments 9238
#define OpcUaId_LimitAlarmType_ConditionRefresh_InputArguments 6127
#define OpcUaId_LimitAlarmType_ConditionRefresh2_InputArguments 12987
#define OpcUaId_LimitAlarmType_AckedState_Id 9240
#define OpcUaId_LimitAlarmType_ConfirmedState_Id 9249
#define OpcUaId_LimitAlarmType_Acknowledge_InputArguments 9258
#define OpcUaId_LimitAlarmType_Confirm_InputArguments 9260
#define OpcUaId_LimitAlarmType_ActiveState_Id 9262
#define OpcUaId_LimitAlarmType_SuppressedState_Id 9271
#define OpcUaId_LimitAlarmType_OutOfServiceState_Id 16539
#define OpcUaId_LimitAlarmType_ShelvingState_CurrentState 9280
#define OpcUaId_LimitAlarmType_ShelvingState_CurrentState_Id 9281
#define OpcUaId_LimitAlarmType_ShelvingState_LastTransition_Id 9286
#define OpcUaId_LimitAlarmType_ShelvingState_UnshelveTime 9290
#define OpcUaId_LimitAlarmType_ShelvingState_TimedShelve_InputArguments 9315
#define OpcUaId_LimitAlarmType_ShelvingState_TimedShelve2_InputArguments 24763
#define OpcUaId_LimitAlarmType_ShelvingState_Unshelve2_InputArguments 24765
#define OpcUaId_LimitAlarmType_ShelvingState_OneShotShelve2_InputArguments 24767
#define OpcUaId_LimitAlarmType_SilenceState_Id 16548
#define OpcUaId_LimitAlarmType_LatchedState_Id 18214
#define OpcUaId_LimitAlarmType_Suppress2_InputArguments 24339
#define OpcUaId_LimitAlarmType_Unsuppress2_InputArguments 24341
#define OpcUaId_LimitAlarmType_RemoveFromService2_InputArguments 24343
#define OpcUaId_LimitAlarmType_PlaceInService2_InputArguments 24345
#define OpcUaId_LimitAlarmType_Reset2_InputArguments 24347
#define OpcUaId_LimitAlarmType_GetGroupMemberships_OutputArguments 25159
#define OpcUaId_LimitAlarmType_HighHighLimit 11124
#define OpcUaId_LimitAlarmType_HighLimit 11125
#define OpcUaId_LimitAlarmType_LowLimit 11126
#define OpcUaId_LimitAlarmType_LowLowLimit 11127
#define OpcUaId_LimitAlarmType_BaseHighHighLimit 16572
#define OpcUaId_LimitAlarmType_BaseHighLimit 16573
#define OpcUaId_LimitAlarmType_BaseLowLimit 16574
#define OpcUaId_LimitAlarmType_BaseLowLowLimit 16575
#define OpcUaId_LimitAlarmType_SeverityHighHigh 24770
#define OpcUaId_LimitAlarmType_SeverityHigh 24771
#define OpcUaId_LimitAlarmType_SeverityLow 24772
#define OpcUaId_LimitAlarmType_SeverityLowLow 24773
#define OpcUaId_LimitAlarmType_HighHighDeadband 24774
#define OpcUaId_LimitAlarmType_HighDeadband 24775
#define OpcUaId_LimitAlarmType_LowDeadband 24776
#define OpcUaId_LimitAlarmType_LowLowDeadband 24777
#define OpcUaId_ExclusiveLimitStateMachineType_CurrentState_Id 9320
#define OpcUaId_ExclusiveLimitStateMachineType_LastTransition_Id 9325
#define OpcUaId_ExclusiveLimitStateMachineType_HighHigh_StateNumber 9330
#define OpcUaId_ExclusiveLimitStateMachineType_High_StateNumber 9332
#define OpcUaId_ExclusiveLimitStateMachineType_Low_StateNumber 9334
#define OpcUaId_ExclusiveLimitStateMachineType_LowLow_StateNumber 9336
#define OpcUaId_ExclusiveLimitStateMachineType_LowLowToLow_TransitionNumber 11340
#define OpcUaId_ExclusiveLimitStateMachineType_LowToLowLow_TransitionNumber 11341
#define OpcUaId_ExclusiveLimitStateMachineType_HighHighToHigh_TransitionNumber 11342
#define OpcUaId_ExclusiveLimitStateMachineType_HighToHighHigh_TransitionNumber 11343
#define OpcUaId_ExclusiveLimitAlarmType_EnabledState_Id 9355
#define OpcUaId_ExclusiveLimitAlarmType_Quality_SourceTimestamp 9364
#define OpcUaId_ExclusiveLimitAlarmType_LastSeverity_SourceTimestamp 9366
#define OpcUaId_ExclusiveLimitAlarmType_Comment_SourceTimestamp 9368
#define OpcUaId_ExclusiveLimitAlarmType_AddComment_InputArguments 9373
#define OpcUaId_ExclusiveLimitAlarmType_ConditionRefresh_InputArguments 9375
#define OpcUaId_ExclusiveLimitAlarmType_ConditionRefresh2_InputArguments 12989
#define OpcUaId_ExclusiveLimitAlarmType_AckedState_Id 9377
#define OpcUaId_ExclusiveLimitAlarmType_ConfirmedState_Id 9386
#define OpcUaId_ExclusiveLimitAlarmType_Acknowledge_InputArguments 9395
#define OpcUaId_ExclusiveLimitAlarmType_Confirm_InputArguments 9397
#define OpcUaId_ExclusiveLimitAlarmType_ActiveState 9398
#define OpcUaId_ExclusiveLimitAlarmType_ActiveState_Id 9399
#define OpcUaId_ExclusiveLimitAlarmType_SuppressedState_Id 9408
#define OpcUaId_ExclusiveLimitAlarmType_OutOfServiceState_Id 16579
#define OpcUaId_ExclusiveLimitAlarmType_ShelvingState_CurrentState 9417
#define OpcUaId_ExclusiveLimitAlarmType_ShelvingState_CurrentState_Id 9418
#define OpcUaId_ExclusiveLimitAlarmType_ShelvingState_LastTransition_Id 9423
#define OpcUaId_ExclusiveLimitAlarmType_ShelvingState_UnshelveTime 9427
#define OpcUaId_ExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments 9452
#define OpcUaId_ExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments 24779
#define OpcUaId_ExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments 24781
#define OpcUaId_ExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments 24783
#define OpcUaId_ExclusiveLimitAlarmType_SilenceState_Id 16588
#define OpcUaId_ExclusiveLimitAlarmType_LatchedState_Id 18224
#define OpcUaId_ExclusiveLimitAlarmType_Suppress2_InputArguments 24349
#define OpcUaId_ExclusiveLimitAlarmType_Unsuppress2_InputArguments 24351
#define OpcUaId_ExclusiveLimitAlarmType_RemoveFromService2_InputArguments 24353
#define OpcUaId_ExclusiveLimitAlarmType_PlaceInService2_InputArguments 24355
#define OpcUaId_ExclusiveLimitAlarmType_Reset2_InputArguments 24357
#define OpcUaId_ExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments 25160
#define OpcUaId_ExclusiveLimitAlarmType_LimitState_CurrentState 9456
#define OpcUaId_ExclusiveLimitAlarmType_LimitState_CurrentState_Id 9457
#define OpcUaId_ExclusiveLimitAlarmType_LimitState_LastTransition 9461
#define OpcUaId_ExclusiveLimitAlarmType_LimitState_LastTransition_Id 9462
#define OpcUaId_ExclusiveLimitAlarmType_LimitState_LastTransition_TransitionTime 9465
#define OpcUaId_NonExclusiveLimitAlarmType_EnabledState_Id 9920
#define OpcUaId_NonExclusiveLimitAlarmType_Quality_SourceTimestamp 9929
#define OpcUaId_NonExclusiveLimitAlarmType_LastSeverity_SourceTimestamp 9931
#define OpcUaId_NonExclusiveLimitAlarmType_Comment_SourceTimestamp 9933
#define OpcUaId_NonExclusiveLimitAlarmType_AddComment_InputArguments 9938
#define OpcUaId_NonExclusiveLimitAlarmType_ConditionRefresh_InputArguments 9940
#define OpcUaId_NonExclusiveLimitAlarmType_ConditionRefresh2_InputArguments 12991
#define OpcUaId_NonExclusiveLimitAlarmType_AckedState_Id 9942
#define OpcUaId_NonExclusiveLimitAlarmType_ConfirmedState_Id 9951
#define OpcUaId_NonExclusiveLimitAlarmType_Acknowledge_InputArguments 9960
#define OpcUaId_NonExclusiveLimitAlarmType_Confirm_InputArguments 9962
#define OpcUaId_NonExclusiveLimitAlarmType_ActiveState 9963
#define OpcUaId_NonExclusiveLimitAlarmType_ActiveState_Id 9964
#define OpcUaId_NonExclusiveLimitAlarmType_SuppressedState_Id 9973
#define OpcUaId_NonExclusiveLimitAlarmType_OutOfServiceState_Id 16619
#define OpcUaId_NonExclusiveLimitAlarmType_ShelvingState_CurrentState 9982
#define OpcUaId_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Id 9983
#define OpcUaId_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Id 9988
#define OpcUaId_NonExclusiveLimitAlarmType_ShelvingState_UnshelveTime 9992
#define OpcUaId_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments 10017
#define OpcUaId_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments 24795
#define OpcUaId_NonExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments 24797
#define OpcUaId_NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments 24799
#define OpcUaId_NonExclusiveLimitAlarmType_SilenceState_Id 16628
#define OpcUaId_NonExclusiveLimitAlarmType_LatchedState_Id 18234
#define OpcUaId_NonExclusiveLimitAlarmType_Suppress2_InputArguments 24359
#define OpcUaId_NonExclusiveLimitAlarmType_Unsuppress2_InputArguments 24361
#define OpcUaId_NonExclusiveLimitAlarmType_RemoveFromService2_InputArguments 24363
#define OpcUaId_NonExclusiveLimitAlarmType_PlaceInService2_InputArguments 24365
#define OpcUaId_NonExclusiveLimitAlarmType_Reset2_InputArguments 24367
#define OpcUaId_NonExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments 25161
#define OpcUaId_NonExclusiveLimitAlarmType_HighHighState 10020
#define OpcUaId_NonExclusiveLimitAlarmType_HighHighState_Id 10021
#define OpcUaId_NonExclusiveLimitAlarmType_HighHighState_TransitionTime 10025
#define OpcUaId_NonExclusiveLimitAlarmType_HighHighState_TrueState 10027
#define OpcUaId_NonExclusiveLimitAlarmType_HighHighState_FalseState 10028
#define OpcUaId_NonExclusiveLimitAlarmType_HighState 10029
#define OpcUaId_NonExclusiveLimitAlarmType_HighState_Id 10030
#define OpcUaId_NonExclusiveLimitAlarmType_HighState_TransitionTime 10034
#define OpcUaId_NonExclusiveLimitAlarmType_HighState_TrueState 10036
#define OpcUaId_NonExclusiveLimitAlarmType_HighState_FalseState 10037
#define OpcUaId_NonExclusiveLimitAlarmType_LowState 10038
#define OpcUaId_NonExclusiveLimitAlarmType_LowState_Id 10039
#define OpcUaId_NonExclusiveLimitAlarmType_LowState_TransitionTime 10043
#define OpcUaId_NonExclusiveLimitAlarmType_LowState_TrueState 10045
#define OpcUaId_NonExclusiveLimitAlarmType_LowState_FalseState 10046
#define OpcUaId_NonExclusiveLimitAlarmType_LowLowState 10047
#define OpcUaId_NonExclusiveLimitAlarmType_LowLowState_Id 10048
#define OpcUaId_NonExclusiveLimitAlarmType_LowLowState_TransitionTime 10052
#define OpcUaId_NonExclusiveLimitAlarmType_LowLowState_TrueState 10054
#define OpcUaId_NonExclusiveLimitAlarmType_LowLowState_FalseState 10055
#define OpcUaId_NonExclusiveLevelAlarmType_EnabledState_Id 10074
#define OpcUaId_NonExclusiveLevelAlarmType_Quality_SourceTimestamp 10083
#define OpcUaId_NonExclusiveLevelAlarmType_LastSeverity_SourceTimestamp 10085
#define OpcUaId_NonExclusiveLevelAlarmType_Comment_SourceTimestamp 10087
#define OpcUaId_NonExclusiveLevelAlarmType_AddComment_InputArguments 10092
#define OpcUaId_NonExclusiveLevelAlarmType_ConditionRefresh_InputArguments 10094
#define OpcUaId_NonExclusiveLevelAlarmType_ConditionRefresh2_InputArguments 12993
#define OpcUaId_NonExclusiveLevelAlarmType_AckedState_Id 10096
#define OpcUaId_NonExclusiveLevelAlarmType_ConfirmedState_Id 10105
#define OpcUaId_NonExclusiveLevelAlarmType_Acknowledge_InputArguments 10114
#define OpcUaId_NonExclusiveLevelAlarmType_Confirm_InputArguments 10116
#define OpcUaId_NonExclusiveLevelAlarmType_ActiveState_Id 10118
#define OpcUaId_NonExclusiveLevelAlarmType_SuppressedState_Id 10127
#define OpcUaId_NonExclusiveLevelAlarmType_OutOfServiceState_Id 16659
#define OpcUaId_NonExclusiveLevelAlarmType_ShelvingState_CurrentState 10136
#define OpcUaId_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Id 10137
#define OpcUaId_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Id 10142
#define OpcUaId_NonExclusiveLevelAlarmType_ShelvingState_UnshelveTime 10146
#define OpcUaId_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments 10171
#define OpcUaId_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments 24811
#define OpcUaId_NonExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments 24813
#define OpcUaId_NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments 24815
#define OpcUaId_NonExclusiveLevelAlarmType_SilenceState_Id 16668
#define OpcUaId_NonExclusiveLevelAlarmType_LatchedState_Id 18247
#define OpcUaId_NonExclusiveLevelAlarmType_Suppress2_InputArguments 24369
#define OpcUaId_NonExclusiveLevelAlarmType_Unsuppress2_InputArguments 24371
#define OpcUaId_NonExclusiveLevelAlarmType_RemoveFromService2_InputArguments 24373
#define OpcUaId_NonExclusiveLevelAlarmType_PlaceInService2_InputArguments 24375
#define OpcUaId_NonExclusiveLevelAlarmType_Reset2_InputArguments 24377
#define OpcUaId_NonExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments 25162
#define OpcUaId_NonExclusiveLevelAlarmType_HighHighState_Id 10175
#define OpcUaId_NonExclusiveLevelAlarmType_HighState_Id 10184
#define OpcUaId_NonExclusiveLevelAlarmType_LowState_Id 10193
#define OpcUaId_NonExclusiveLevelAlarmType_LowLowState_Id 10202
#define OpcUaId_ExclusiveLevelAlarmType_EnabledState_Id 9496
#define OpcUaId_ExclusiveLevelAlarmType_Quality_SourceTimestamp 9505
#define OpcUaId_ExclusiveLevelAlarmType_LastSeverity_SourceTimestamp 9507
#define OpcUaId_ExclusiveLevelAlarmType_Comment_SourceTimestamp 9509
#define OpcUaId_ExclusiveLevelAlarmType_AddComment_InputArguments 9514
#define OpcUaId_ExclusiveLevelAlarmType_ConditionRefresh_InputArguments 9516
#define OpcUaId_ExclusiveLevelAlarmType_ConditionRefresh2_InputArguments 12995
#define OpcUaId_ExclusiveLevelAlarmType_AckedState_Id 9518
#define OpcUaId_ExclusiveLevelAlarmType_ConfirmedState_Id 9527
#define OpcUaId_ExclusiveLevelAlarmType_Acknowledge_InputArguments 9536
#define OpcUaId_ExclusiveLevelAlarmType_Confirm_InputArguments 9538
#define OpcUaId_ExclusiveLevelAlarmType_ActiveState_Id 9540
#define OpcUaId_ExclusiveLevelAlarmType_SuppressedState_Id 9549
#define OpcUaId_ExclusiveLevelAlarmType_OutOfServiceState_Id 16699
#define OpcUaId_ExclusiveLevelAlarmType_ShelvingState_CurrentState 9558
#define OpcUaId_ExclusiveLevelAlarmType_ShelvingState_CurrentState_Id 9559
#define OpcUaId_ExclusiveLevelAlarmType_ShelvingState_LastTransition_Id 9564
#define OpcUaId_ExclusiveLevelAlarmType_ShelvingState_UnshelveTime 9568
#define OpcUaId_ExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments 9593
#define OpcUaId_ExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments 24827
#define OpcUaId_ExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments 24829
#define OpcUaId_ExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments 24831
#define OpcUaId_ExclusiveLevelAlarmType_SilenceState_Id 16708
#define OpcUaId_ExclusiveLevelAlarmType_LatchedState_Id 18258
#define OpcUaId_ExclusiveLevelAlarmType_Suppress2_InputArguments 24379
#define OpcUaId_ExclusiveLevelAlarmType_Unsuppress2_InputArguments 24381
#define OpcUaId_ExclusiveLevelAlarmType_RemoveFromService2_InputArguments 24383
#define OpcUaId_ExclusiveLevelAlarmType_PlaceInService2_InputArguments 24385
#define OpcUaId_ExclusiveLevelAlarmType_Reset2_InputArguments 24387
#define OpcUaId_ExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments 25163
#define OpcUaId_ExclusiveLevelAlarmType_LimitState_CurrentState 9597
#define OpcUaId_ExclusiveLevelAlarmType_LimitState_CurrentState_Id 9598
#define OpcUaId_ExclusiveLevelAlarmType_LimitState_LastTransition_Id 9603
#define OpcUaId_NonExclusiveDeviationAlarmType_EnabledState_Id 10382
#define OpcUaId_NonExclusiveDeviationAlarmType_Quality_SourceTimestamp 10391
#define OpcUaId_NonExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp 10393
#define OpcUaId_NonExclusiveDeviationAlarmType_Comment_SourceTimestamp 10395
#define OpcUaId_NonExclusiveDeviationAlarmType_AddComment_InputArguments 10400
#define OpcUaId_NonExclusiveDeviationAlarmType_ConditionRefresh_InputArguments 10402
#define OpcUaId_NonExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments 12997
#define OpcUaId_NonExclusiveDeviationAlarmType_AckedState_Id 10404
#define OpcUaId_NonExclusiveDeviationAlarmType_ConfirmedState_Id 10413
#define OpcUaId_NonExclusiveDeviationAlarmType_Acknowledge_InputArguments 10422
#define OpcUaId_NonExclusiveDeviationAlarmType_Confirm_InputArguments 10424
#define OpcUaId_NonExclusiveDeviationAlarmType_ActiveState_Id 10426
#define OpcUaId_NonExclusiveDeviationAlarmType_SuppressedState_Id 10435
#define OpcUaId_NonExclusiveDeviationAlarmType_OutOfServiceState_Id 16739
#define OpcUaId_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState 10444
#define OpcUaId_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id 10445
#define OpcUaId_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id 10450
#define OpcUaId_NonExclusiveDeviationAlarmType_ShelvingState_UnshelveTime 10454
#define OpcUaId_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments 10479
#define OpcUaId_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments 24843
#define OpcUaId_NonExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments 24845
#define OpcUaId_NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments 24847
#define OpcUaId_NonExclusiveDeviationAlarmType_SilenceState_Id 16748
#define OpcUaId_NonExclusiveDeviationAlarmType_LatchedState_Id 18268
#define OpcUaId_NonExclusiveDeviationAlarmType_Suppress2_InputArguments 24389
#define OpcUaId_NonExclusiveDeviationAlarmType_Unsuppress2_InputArguments 24391
#define OpcUaId_NonExclusiveDeviationAlarmType_RemoveFromService2_InputArguments 24393
#define OpcUaId_NonExclusiveDeviationAlarmType_PlaceInService2_InputArguments 24395
#define OpcUaId_NonExclusiveDeviationAlarmType_Reset2_InputArguments 24397
#define OpcUaId_NonExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments 25164
#define OpcUaId_NonExclusiveDeviationAlarmType_HighHighState_Id 10483
#define OpcUaId_NonExclusiveDeviationAlarmType_HighState_Id 10492
#define OpcUaId_NonExclusiveDeviationAlarmType_LowState_Id 10501
#define OpcUaId_NonExclusiveDeviationAlarmType_LowLowState_Id 10510
#define OpcUaId_NonExclusiveDeviationAlarmType_SetpointNode 10522
#define OpcUaId_NonExclusiveDeviationAlarmType_BaseSetpointNode 16776
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_EnabledState_Id 10228
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp 10237
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp 10239
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp 10241
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_AddComment_InputArguments 10246
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments 10248
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments 13001
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_AckedState_Id 10250
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_ConfirmedState_Id 10259
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments 10268
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_Confirm_InputArguments 10270
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_ActiveState_Id 10272
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_SuppressedState_Id 10281
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Id 16821
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState 10290
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id 10291
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id 10296
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime 10300
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments 10325
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments 24859
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments 24861
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments 24863
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_SilenceState_Id 16830
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_LatchedState_Id 18278
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_Suppress2_InputArguments 24399
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments 24401
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments 24403
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments 24405
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_Reset2_InputArguments 24407
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments 25165
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_HighHighState_Id 10329
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_HighState_Id 10338
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_LowState_Id 10347
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_LowLowState_Id 10356
#define OpcUaId_NonExclusiveRateOfChangeAlarmType_EngineeringUnits 16858
#define OpcUaId_ExclusiveDeviationAlarmType_EnabledState_Id 9778
#define OpcUaId_ExclusiveDeviationAlarmType_Quality_SourceTimestamp 9787
#define OpcUaId_ExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp 9789
#define OpcUaId_ExclusiveDeviationAlarmType_Comment_SourceTimestamp 9791
#define OpcUaId_ExclusiveDeviationAlarmType_AddComment_InputArguments 9796
#define OpcUaId_ExclusiveDeviationAlarmType_ConditionRefresh_InputArguments 9798
#define OpcUaId_ExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments 12999
#define OpcUaId_ExclusiveDeviationAlarmType_AckedState_Id 9800
#define OpcUaId_ExclusiveDeviationAlarmType_ConfirmedState_Id 9809
#define OpcUaId_ExclusiveDeviationAlarmType_Acknowledge_InputArguments 9818
#define OpcUaId_ExclusiveDeviationAlarmType_Confirm_InputArguments 9820
#define OpcUaId_ExclusiveDeviationAlarmType_ActiveState_Id 9822
#define OpcUaId_ExclusiveDeviationAlarmType_SuppressedState_Id 9831
#define OpcUaId_ExclusiveDeviationAlarmType_OutOfServiceState_Id 16780
#define OpcUaId_ExclusiveDeviationAlarmType_ShelvingState_CurrentState 9840
#define OpcUaId_ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id 9841
#define OpcUaId_ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id 9846
#define OpcUaId_ExclusiveDeviationAlarmType_ShelvingState_UnshelveTime 9850
#define OpcUaId_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments 9875
#define OpcUaId_ExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments 24875
#define OpcUaId_ExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments 24877
#define OpcUaId_ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments 24879
#define OpcUaId_ExclusiveDeviationAlarmType_SilenceState_Id 16789
#define OpcUaId_ExclusiveDeviationAlarmType_LatchedState_Id 18288
#define OpcUaId_ExclusiveDeviationAlarmType_Suppress2_InputArguments 24409
#define OpcUaId_ExclusiveDeviationAlarmType_Unsuppress2_InputArguments 24411
#define OpcUaId_ExclusiveDeviationAlarmType_RemoveFromService2_InputArguments 24413
#define OpcUaId_ExclusiveDeviationAlarmType_PlaceInService2_InputArguments 24415
#define OpcUaId_ExclusiveDeviationAlarmType_Reset2_InputArguments 24417
#define OpcUaId_ExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments 25166
#define OpcUaId_ExclusiveDeviationAlarmType_LimitState_CurrentState 9879
#define OpcUaId_ExclusiveDeviationAlarmType_LimitState_CurrentState_Id 9880
#define OpcUaId_ExclusiveDeviationAlarmType_LimitState_LastTransition_Id 9885
#define OpcUaId_ExclusiveDeviationAlarmType_SetpointNode 9905
#define OpcUaId_ExclusiveDeviationAlarmType_BaseSetpointNode 16817
#define OpcUaId_ExclusiveRateOfChangeAlarmType_EnabledState_Id 9637
#define OpcUaId_ExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp 9646
#define OpcUaId_ExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp 9648
#define OpcUaId_ExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp 9650
#define OpcUaId_ExclusiveRateOfChangeAlarmType_AddComment_InputArguments 9655
#define OpcUaId_ExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments 9657
#define OpcUaId_ExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments 13003
#define OpcUaId_ExclusiveRateOfChangeAlarmType_AckedState_Id 9659
#define OpcUaId_ExclusiveRateOfChangeAlarmType_ConfirmedState_Id 9668
#define OpcUaId_ExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments 9677
#define OpcUaId_ExclusiveRateOfChangeAlarmType_Confirm_InputArguments 9679
#define OpcUaId_ExclusiveRateOfChangeAlarmType_ActiveState_Id 9681
#define OpcUaId_ExclusiveRateOfChangeAlarmType_SuppressedState_Id 9690
#define OpcUaId_ExclusiveRateOfChangeAlarmType_OutOfServiceState_Id 16862
#define OpcUaId_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState 9699
#define OpcUaId_ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id 9700
#define OpcUaId_ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id 9705
#define OpcUaId_ExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime 9709
#define OpcUaId_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments 9734
#define OpcUaId_ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments 24891
#define OpcUaId_ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments 24893
#define OpcUaId_ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments 24895
#define OpcUaId_ExclusiveRateOfChangeAlarmType_SilenceState_Id 16871
#define OpcUaId_ExclusiveRateOfChangeAlarmType_LatchedState_Id 18298
#define OpcUaId_ExclusiveRateOfChangeAlarmType_Suppress2_InputArguments 24419
#define OpcUaId_ExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments 24421
#define OpcUaId_ExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments 24423
#define OpcUaId_ExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments 24425
#define OpcUaId_ExclusiveRateOfChangeAlarmType_Reset2_InputArguments 24427
#define OpcUaId_ExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments 25167
#define OpcUaId_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState 9738
#define OpcUaId_ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Id 9739
#define OpcUaId_ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Id 9744
#define OpcUaId_ExclusiveRateOfChangeAlarmType_EngineeringUnits 16899
#define OpcUaId_DiscreteAlarmType_EnabledState_Id 10537
#define OpcUaId_DiscreteAlarmType_Quality_SourceTimestamp 10546
#define OpcUaId_DiscreteAlarmType_LastSeverity_SourceTimestamp 10548
#define OpcUaId_DiscreteAlarmType_Comment_SourceTimestamp 10550
#define OpcUaId_DiscreteAlarmType_AddComment_InputArguments 10555
#define OpcUaId_DiscreteAlarmType_ConditionRefresh_InputArguments 10557
#define OpcUaId_DiscreteAlarmType_ConditionRefresh2_InputArguments 13005
#define OpcUaId_DiscreteAlarmType_AckedState_Id 10559
#define OpcUaId_DiscreteAlarmType_ConfirmedState_Id 10568
#define OpcUaId_DiscreteAlarmType_Acknowledge_InputArguments 10577
#define OpcUaId_DiscreteAlarmType_Confirm_InputArguments 10579
#define OpcUaId_DiscreteAlarmType_ActiveState_Id 10581
#define OpcUaId_DiscreteAlarmType_SuppressedState_Id 10590
#define OpcUaId_DiscreteAlarmType_OutOfServiceState_Id 16903
#define OpcUaId_DiscreteAlarmType_ShelvingState_CurrentState 10599
#define OpcUaId_DiscreteAlarmType_ShelvingState_CurrentState_Id 10600
#define OpcUaId_DiscreteAlarmType_ShelvingState_LastTransition_Id 10605
#define OpcUaId_DiscreteAlarmType_ShelvingState_UnshelveTime 10609
#define OpcUaId_DiscreteAlarmType_ShelvingState_TimedShelve_InputArguments 10634
#define OpcUaId_DiscreteAlarmType_ShelvingState_TimedShelve2_InputArguments 24907
#define OpcUaId_DiscreteAlarmType_ShelvingState_Unshelve2_InputArguments 24909
#define OpcUaId_DiscreteAlarmType_ShelvingState_OneShotShelve2_InputArguments 24911
#define OpcUaId_DiscreteAlarmType_SilenceState_Id 16912
#define OpcUaId_DiscreteAlarmType_LatchedState_Id 18308
#define OpcUaId_DiscreteAlarmType_Suppress2_InputArguments 24429
#define OpcUaId_DiscreteAlarmType_Unsuppress2_InputArguments 24431
#define OpcUaId_DiscreteAlarmType_RemoveFromService2_InputArguments 24433
#define OpcUaId_DiscreteAlarmType_PlaceInService2_InputArguments 24435
#define OpcUaId_DiscreteAlarmType_Reset2_InputArguments 24437
#define OpcUaId_DiscreteAlarmType_GetGroupMemberships_OutputArguments 25168
#define OpcUaId_OffNormalAlarmType_EnabledState_Id 10651
#define OpcUaId_OffNormalAlarmType_Quality_SourceTimestamp 10660
#define OpcUaId_OffNormalAlarmType_LastSeverity_SourceTimestamp 10662
#define OpcUaId_OffNormalAlarmType_Comment_SourceTimestamp 10664
#define OpcUaId_OffNormalAlarmType_AddComment_InputArguments 10669
#define OpcUaId_OffNormalAlarmType_ConditionRefresh_InputArguments 10671
#define OpcUaId_OffNormalAlarmType_ConditionRefresh2_InputArguments 13007
#define OpcUaId_OffNormalAlarmType_AckedState_Id 10673
#define OpcUaId_OffNormalAlarmType_ConfirmedState_Id 10682
#define OpcUaId_OffNormalAlarmType_Acknowledge_InputArguments 10691
#define OpcUaId_OffNormalAlarmType_Confirm_InputArguments 10693
#define OpcUaId_OffNormalAlarmType_ActiveState_Id 10695
#define OpcUaId_OffNormalAlarmType_SuppressedState_Id 10704
#define OpcUaId_OffNormalAlarmType_OutOfServiceState_Id 16939
#define OpcUaId_OffNormalAlarmType_ShelvingState_CurrentState 10713
#define OpcUaId_OffNormalAlarmType_ShelvingState_CurrentState_Id 10714
#define OpcUaId_OffNormalAlarmType_ShelvingState_LastTransition_Id 10719
#define OpcUaId_OffNormalAlarmType_ShelvingState_UnshelveTime 10723
#define OpcUaId_OffNormalAlarmType_ShelvingState_TimedShelve_InputArguments 10748
#define OpcUaId_OffNormalAlarmType_ShelvingState_TimedShelve2_InputArguments 24915
#define OpcUaId_OffNormalAlarmType_ShelvingState_Unshelve2_InputArguments 24917
#define OpcUaId_OffNormalAlarmType_ShelvingState_OneShotShelve2_InputArguments 24919
#define OpcUaId_OffNormalAlarmType_SilenceState_Id 16948
#define OpcUaId_OffNormalAlarmType_LatchedState_Id 18318
#define OpcUaId_OffNormalAlarmType_Suppress2_InputArguments 24439
#define OpcUaId_OffNormalAlarmType_Unsuppress2_InputArguments 24441
#define OpcUaId_OffNormalAlarmType_RemoveFromService2_InputArguments 24443
#define OpcUaId_OffNormalAlarmType_PlaceInService2_InputArguments 24445
#define OpcUaId_OffNormalAlarmType_Reset2_InputArguments 24447
#define OpcUaId_OffNormalAlarmType_GetGroupMemberships_OutputArguments 25169
#define OpcUaId_OffNormalAlarmType_NormalState 11158
#define OpcUaId_SystemOffNormalAlarmType_EnabledState_Id 11769
#define OpcUaId_SystemOffNormalAlarmType_Quality_SourceTimestamp 11778
#define OpcUaId_SystemOffNormalAlarmType_LastSeverity_SourceTimestamp 11780
#define OpcUaId_SystemOffNormalAlarmType_Comment_SourceTimestamp 11782
#define OpcUaId_SystemOffNormalAlarmType_AddComment_InputArguments 11787
#define OpcUaId_SystemOffNormalAlarmType_ConditionRefresh_InputArguments 11789
#define OpcUaId_SystemOffNormalAlarmType_ConditionRefresh2_InputArguments 13009
#define OpcUaId_SystemOffNormalAlarmType_AckedState_Id 11791
#define OpcUaId_SystemOffNormalAlarmType_ConfirmedState_Id 11800
#define OpcUaId_SystemOffNormalAlarmType_Acknowledge_InputArguments 11809
#define OpcUaId_SystemOffNormalAlarmType_Confirm_InputArguments 11811
#define OpcUaId_SystemOffNormalAlarmType_ActiveState_Id 11813
#define OpcUaId_SystemOffNormalAlarmType_SuppressedState_Id 11823
#define OpcUaId_SystemOffNormalAlarmType_OutOfServiceState_Id 16975
#define OpcUaId_SystemOffNormalAlarmType_ShelvingState_CurrentState 11832
#define OpcUaId_SystemOffNormalAlarmType_ShelvingState_CurrentState_Id 11833
#define OpcUaId_SystemOffNormalAlarmType_ShelvingState_LastTransition_Id 11838
#define OpcUaId_SystemOffNormalAlarmType_ShelvingState_UnshelveTime 11843
#define OpcUaId_SystemOffNormalAlarmType_ShelvingState_TimedShelve_InputArguments 11847
#define OpcUaId_SystemOffNormalAlarmType_ShelvingState_TimedShelve2_InputArguments 24923
#define OpcUaId_SystemOffNormalAlarmType_ShelvingState_Unshelve2_InputArguments 24925
#define OpcUaId_SystemOffNormalAlarmType_ShelvingState_OneShotShelve2_InputArguments 24927
#define OpcUaId_SystemOffNormalAlarmType_SilenceState_Id 16984
#define OpcUaId_SystemOffNormalAlarmType_LatchedState_Id 18328
#define OpcUaId_SystemOffNormalAlarmType_Suppress2_InputArguments 24449
#define OpcUaId_SystemOffNormalAlarmType_Unsuppress2_InputArguments 24451
#define OpcUaId_SystemOffNormalAlarmType_RemoveFromService2_InputArguments 24453
#define OpcUaId_SystemOffNormalAlarmType_PlaceInService2_InputArguments 24455
#define OpcUaId_SystemOffNormalAlarmType_Reset2_InputArguments 24457
#define OpcUaId_SystemOffNormalAlarmType_GetGroupMemberships_OutputArguments 25170
#define OpcUaId_TripAlarmType_EnabledState_Id 10765
#define OpcUaId_TripAlarmType_Quality_SourceTimestamp 10774
#define OpcUaId_TripAlarmType_LastSeverity_SourceTimestamp 10776
#define OpcUaId_TripAlarmType_Comment_SourceTimestamp 10778
#define OpcUaId_TripAlarmType_AddComment_InputArguments 10783
#define OpcUaId_TripAlarmType_ConditionRefresh_InputArguments 10785
#define OpcUaId_TripAlarmType_ConditionRefresh2_InputArguments 13011
#define OpcUaId_TripAlarmType_AckedState_Id 10787
#define OpcUaId_TripAlarmType_ConfirmedState_Id 10796
#define OpcUaId_TripAlarmType_Acknowledge_InputArguments 10805
#define OpcUaId_TripAlarmType_Confirm_InputArguments 10807
#define OpcUaId_TripAlarmType_ActiveState_Id 10809
#define OpcUaId_TripAlarmType_SuppressedState_Id 10818
#define OpcUaId_TripAlarmType_OutOfServiceState_Id 17011
#define OpcUaId_TripAlarmType_ShelvingState_CurrentState 10827
#define OpcUaId_TripAlarmType_ShelvingState_CurrentState_Id 10828
#define OpcUaId_TripAlarmType_ShelvingState_LastTransition_Id 10833
#define OpcUaId_TripAlarmType_ShelvingState_UnshelveTime 10837
#define OpcUaId_TripAlarmType_ShelvingState_TimedShelve_InputArguments 10862
#define OpcUaId_TripAlarmType_ShelvingState_TimedShelve2_InputArguments 24931
#define OpcUaId_TripAlarmType_ShelvingState_Unshelve2_InputArguments 24933
#define OpcUaId_TripAlarmType_ShelvingState_OneShotShelve2_InputArguments 24935
#define OpcUaId_TripAlarmType_SilenceState_Id 17020
#define OpcUaId_TripAlarmType_LatchedState_Id 18338
#define OpcUaId_TripAlarmType_Suppress2_InputArguments 24459
#define OpcUaId_TripAlarmType_Unsuppress2_InputArguments 24461
#define OpcUaId_TripAlarmType_RemoveFromService2_InputArguments 24463
#define OpcUaId_TripAlarmType_PlaceInService2_InputArguments 24465
#define OpcUaId_TripAlarmType_Reset2_InputArguments 24467
#define OpcUaId_TripAlarmType_GetGroupMemberships_OutputArguments 25171
#define OpcUaId_InstrumentDiagnosticAlarmType_EnabledState_Id 18365
#define OpcUaId_InstrumentDiagnosticAlarmType_Quality_SourceTimestamp 18374
#define OpcUaId_InstrumentDiagnosticAlarmType_LastSeverity_SourceTimestamp 18376
#define OpcUaId_InstrumentDiagnosticAlarmType_Comment_SourceTimestamp 18378
#define OpcUaId_InstrumentDiagnosticAlarmType_AddComment_InputArguments 18383
#define OpcUaId_InstrumentDiagnosticAlarmType_ConditionRefresh_InputArguments 18385
#define OpcUaId_InstrumentDiagnosticAlarmType_ConditionRefresh2_InputArguments 18387
#define OpcUaId_InstrumentDiagnosticAlarmType_AckedState_Id 18389
#define OpcUaId_InstrumentDiagnosticAlarmType_ConfirmedState_Id 18398
#define OpcUaId_InstrumentDiagnosticAlarmType_Acknowledge_InputArguments 18407
#define OpcUaId_InstrumentDiagnosticAlarmType_Confirm_InputArguments 18409
#define OpcUaId_InstrumentDiagnosticAlarmType_ActiveState_Id 18411
#define OpcUaId_InstrumentDiagnosticAlarmType_SuppressedState_Id 18421
#define OpcUaId_InstrumentDiagnosticAlarmType_OutOfServiceState_Id 18430
#define OpcUaId_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState 18439
#define OpcUaId_InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Id 18440
#define OpcUaId_InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Id 18445
#define OpcUaId_InstrumentDiagnosticAlarmType_ShelvingState_UnshelveTime 18452
#define OpcUaId_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve_InputArguments 18454
#define OpcUaId_InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve2_InputArguments 24939
#define OpcUaId_InstrumentDiagnosticAlarmType_ShelvingState_Unshelve2_InputArguments 24941
#define OpcUaId_InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve2_InputArguments 24943
#define OpcUaId_InstrumentDiagnosticAlarmType_SilenceState_Id 18465
#define OpcUaId_InstrumentDiagnosticAlarmType_LatchedState_Id 18478
#define OpcUaId_InstrumentDiagnosticAlarmType_Suppress2_InputArguments 24469
#define OpcUaId_InstrumentDiagnosticAlarmType_Unsuppress2_InputArguments 24471
#define OpcUaId_InstrumentDiagnosticAlarmType_RemoveFromService2_InputArguments 24473
#define OpcUaId_InstrumentDiagnosticAlarmType_PlaceInService2_InputArguments 24475
#define OpcUaId_InstrumentDiagnosticAlarmType_Reset2_InputArguments 24477
#define OpcUaId_InstrumentDiagnosticAlarmType_GetGroupMemberships_OutputArguments 25172
#define OpcUaId_SystemDiagnosticAlarmType_EnabledState_Id 18514
#define OpcUaId_SystemDiagnosticAlarmType_Quality_SourceTimestamp 18523
#define OpcUaId_SystemDiagnosticAlarmType_LastSeverity_SourceTimestamp 18525
#define OpcUaId_SystemDiagnosticAlarmType_Comment_SourceTimestamp 18527
#define OpcUaId_SystemDiagnosticAlarmType_AddComment_InputArguments 18532
#define OpcUaId_SystemDiagnosticAlarmType_ConditionRefresh_InputArguments 18534
#define OpcUaId_SystemDiagnosticAlarmType_ConditionRefresh2_InputArguments 18536
#define OpcUaId_SystemDiagnosticAlarmType_AckedState_Id 18538
#define OpcUaId_SystemDiagnosticAlarmType_ConfirmedState_Id 18547
#define OpcUaId_SystemDiagnosticAlarmType_Acknowledge_InputArguments 18556
#define OpcUaId_SystemDiagnosticAlarmType_Confirm_InputArguments 18558
#define OpcUaId_SystemDiagnosticAlarmType_ActiveState_Id 18560
#define OpcUaId_SystemDiagnosticAlarmType_SuppressedState_Id 18570
#define OpcUaId_SystemDiagnosticAlarmType_OutOfServiceState_Id 18579
#define OpcUaId_SystemDiagnosticAlarmType_ShelvingState_CurrentState 18588
#define OpcUaId_SystemDiagnosticAlarmType_ShelvingState_CurrentState_Id 18589
#define OpcUaId_SystemDiagnosticAlarmType_ShelvingState_LastTransition_Id 18594
#define OpcUaId_SystemDiagnosticAlarmType_ShelvingState_UnshelveTime 18601
#define OpcUaId_SystemDiagnosticAlarmType_ShelvingState_TimedShelve_InputArguments 18603
#define OpcUaId_SystemDiagnosticAlarmType_ShelvingState_TimedShelve2_InputArguments 24947
#define OpcUaId_SystemDiagnosticAlarmType_ShelvingState_Unshelve2_InputArguments 24949
#define OpcUaId_SystemDiagnosticAlarmType_ShelvingState_OneShotShelve2_InputArguments 24951
#define OpcUaId_SystemDiagnosticAlarmType_SilenceState_Id 18614
#define OpcUaId_SystemDiagnosticAlarmType_LatchedState_Id 18627
#define OpcUaId_SystemDiagnosticAlarmType_Suppress2_InputArguments 24479
#define OpcUaId_SystemDiagnosticAlarmType_Unsuppress2_InputArguments 24481
#define OpcUaId_SystemDiagnosticAlarmType_RemoveFromService2_InputArguments 24483
#define OpcUaId_SystemDiagnosticAlarmType_PlaceInService2_InputArguments 24485
#define OpcUaId_SystemDiagnosticAlarmType_Reset2_InputArguments 24487
#define OpcUaId_SystemDiagnosticAlarmType_GetGroupMemberships_OutputArguments 25173
#define OpcUaId_CertificateExpirationAlarmType_EnabledState_Id 13241
#define OpcUaId_CertificateExpirationAlarmType_Quality_SourceTimestamp 13250
#define OpcUaId_CertificateExpirationAlarmType_LastSeverity_SourceTimestamp 13252
#define OpcUaId_CertificateExpirationAlarmType_Comment_SourceTimestamp 13254
#define OpcUaId_CertificateExpirationAlarmType_AddComment_InputArguments 13259
#define OpcUaId_CertificateExpirationAlarmType_ConditionRefresh_InputArguments 13261
#define OpcUaId_CertificateExpirationAlarmType_ConditionRefresh2_InputArguments 13263
#define OpcUaId_CertificateExpirationAlarmType_AckedState_Id 13265
#define OpcUaId_CertificateExpirationAlarmType_ConfirmedState_Id 13274
#define OpcUaId_CertificateExpirationAlarmType_Acknowledge_InputArguments 13283
#define OpcUaId_CertificateExpirationAlarmType_Confirm_InputArguments 13285
#define OpcUaId_CertificateExpirationAlarmType_ActiveState_Id 13287
#define OpcUaId_CertificateExpirationAlarmType_SuppressedState_Id 13297
#define OpcUaId_CertificateExpirationAlarmType_OutOfServiceState_Id 17047
#define OpcUaId_CertificateExpirationAlarmType_ShelvingState_CurrentState 13306
#define OpcUaId_CertificateExpirationAlarmType_ShelvingState_CurrentState_Id 13307
#define OpcUaId_CertificateExpirationAlarmType_ShelvingState_LastTransition_Id 13312
#define OpcUaId_CertificateExpirationAlarmType_ShelvingState_UnshelveTime 13317
#define OpcUaId_CertificateExpirationAlarmType_ShelvingState_TimedShelve_InputArguments 13321
#define OpcUaId_CertificateExpirationAlarmType_ShelvingState_TimedShelve2_InputArguments 24955
#define OpcUaId_CertificateExpirationAlarmType_ShelvingState_Unshelve2_InputArguments 24957
#define OpcUaId_CertificateExpirationAlarmType_ShelvingState_OneShotShelve2_InputArguments 24959
#define OpcUaId_CertificateExpirationAlarmType_SilenceState_Id 17056
#define OpcUaId_CertificateExpirationAlarmType_LatchedState_Id 18646
#define OpcUaId_CertificateExpirationAlarmType_Suppress2_InputArguments 24489
#define OpcUaId_CertificateExpirationAlarmType_Unsuppress2_InputArguments 24491
#define OpcUaId_CertificateExpirationAlarmType_RemoveFromService2_InputArguments 24493
#define OpcUaId_CertificateExpirationAlarmType_PlaceInService2_InputArguments 24495
#define OpcUaId_CertificateExpirationAlarmType_Reset2_InputArguments 24497
#define OpcUaId_CertificateExpirationAlarmType_GetGroupMemberships_OutputArguments 25174
#define OpcUaId_CertificateExpirationAlarmType_ExpirationDate 13325
#define OpcUaId_CertificateExpirationAlarmType_ExpirationLimit 14900
#define OpcUaId_CertificateExpirationAlarmType_CertificateType 13326
#define OpcUaId_CertificateExpirationAlarmType_Certificate 13327
#define OpcUaId_DiscrepancyAlarmType_EnabledState_Id 17098
#define OpcUaId_DiscrepancyAlarmType_Quality_SourceTimestamp 17107
#define OpcUaId_DiscrepancyAlarmType_LastSeverity_SourceTimestamp 17109
#define OpcUaId_DiscrepancyAlarmType_Comment_SourceTimestamp 17111
#define OpcUaId_DiscrepancyAlarmType_AddComment_InputArguments 17116
#define OpcUaId_DiscrepancyAlarmType_ConditionRefresh_InputArguments 17118
#define OpcUaId_DiscrepancyAlarmType_ConditionRefresh2_InputArguments 17120
#define OpcUaId_DiscrepancyAlarmType_AckedState_Id 17122
#define OpcUaId_DiscrepancyAlarmType_ConfirmedState_Id 17131
#define OpcUaId_DiscrepancyAlarmType_Acknowledge_InputArguments 17140
#define OpcUaId_DiscrepancyAlarmType_Confirm_InputArguments 17142
#define OpcUaId_DiscrepancyAlarmType_ActiveState_Id 17144
#define OpcUaId_DiscrepancyAlarmType_SuppressedState_Id 17154
#define OpcUaId_DiscrepancyAlarmType_OutOfServiceState_Id 17163
#define OpcUaId_DiscrepancyAlarmType_ShelvingState_CurrentState 17181
#define OpcUaId_DiscrepancyAlarmType_ShelvingState_CurrentState_Id 17182
#define OpcUaId_DiscrepancyAlarmType_ShelvingState_LastTransition_Id 17187
#define OpcUaId_DiscrepancyAlarmType_ShelvingState_UnshelveTime 17192
#define OpcUaId_DiscrepancyAlarmType_ShelvingState_TimedShelve_InputArguments 17196
#define OpcUaId_DiscrepancyAlarmType_ShelvingState_TimedShelve2_InputArguments 24963
#define OpcUaId_DiscrepancyAlarmType_ShelvingState_Unshelve2_InputArguments 24965
#define OpcUaId_DiscrepancyAlarmType_ShelvingState_OneShotShelve2_InputArguments 24967
#define OpcUaId_DiscrepancyAlarmType_SilenceState_Id 17172
#define OpcUaId_DiscrepancyAlarmType_LatchedState_Id 18656
#define OpcUaId_DiscrepancyAlarmType_Suppress2_InputArguments 24499
#define OpcUaId_DiscrepancyAlarmType_Unsuppress2_InputArguments 24501
#define OpcUaId_DiscrepancyAlarmType_RemoveFromService2_InputArguments 24503
#define OpcUaId_DiscrepancyAlarmType_PlaceInService2_InputArguments 24505
#define OpcUaId_DiscrepancyAlarmType_Reset2_InputArguments 24507
#define OpcUaId_DiscrepancyAlarmType_GetGroupMemberships_OutputArguments 25175
#define OpcUaId_DiscrepancyAlarmType_TargetValueNode 17215
#define OpcUaId_DiscrepancyAlarmType_ExpectedTime 17216
#define OpcUaId_DiscrepancyAlarmType_Tolerance 17217
#define OpcUaId_AuditConditionCommentEventType_ConditionEventId 17222
#define OpcUaId_AuditConditionCommentEventType_Comment 11851
#define OpcUaId_AuditConditionRespondEventType_SelectedResponse 11852
#define OpcUaId_AuditConditionAcknowledgeEventType_ConditionEventId 17223
#define OpcUaId_AuditConditionAcknowledgeEventType_Comment 11853
#define OpcUaId_AuditConditionConfirmEventType_ConditionEventId 17224
#define OpcUaId_AuditConditionConfirmEventType_Comment 11854
#define OpcUaId_AuditConditionShelvingEventType_ShelvingTime 11855
#define OpcUaId_AlarmMetricsType_AlarmCount 17280
#define OpcUaId_AlarmMetricsType_StartTime 17991
#define OpcUaId_AlarmMetricsType_MaximumActiveState 17281
#define OpcUaId_AlarmMetricsType_MaximumUnAck 17282
#define OpcUaId_AlarmMetricsType_CurrentAlarmRate 17284
#define OpcUaId_AlarmMetricsType_CurrentAlarmRate_Rate 17285
#define OpcUaId_AlarmMetricsType_MaximumAlarmRate 17286
#define OpcUaId_AlarmMetricsType_MaximumAlarmRate_Rate 17287
#define OpcUaId_AlarmMetricsType_MaximumReAlarmCount 17283
#define OpcUaId_AlarmMetricsType_AverageAlarmRate 17288
#define OpcUaId_AlarmMetricsType_AverageAlarmRate_Rate 17289
#define OpcUaId_AlarmRateVariableType_Rate 17278
#define OpcUaId_AlarmStateVariableType_HighestActiveSeverity 32245
#define OpcUaId_AlarmStateVariableType_HighestUnackSeverity 32246
#define OpcUaId_AlarmStateVariableType_ActiveCount 32247
#define OpcUaId_AlarmStateVariableType_UnacknowledgedCount 32248
#define OpcUaId_AlarmStateVariableType_UnconfirmedCount 32249
#define OpcUaId_AlarmStateVariableType_Filter 32250
#define OpcUaId_AlarmMask_OptionSetValues 32252
#define OpcUaId_ProgramStateMachineType_CurrentState 3830
#define OpcUaId_ProgramStateMachineType_CurrentState_Id 3831
#define OpcUaId_ProgramStateMachineType_CurrentState_Number 3833
#define OpcUaId_ProgramStateMachineType_LastTransition 3835
#define OpcUaId_ProgramStateMachineType_LastTransition_Id 3836
#define OpcUaId_ProgramStateMachineType_LastTransition_Number 3838
#define OpcUaId_ProgramStateMachineType_LastTransition_TransitionTime 3839
#define OpcUaId_ProgramStateMachineType_Creatable 2392
#define OpcUaId_ProgramStateMachineType_Deletable 2393
#define OpcUaId_ProgramStateMachineType_AutoDelete 2394
#define OpcUaId_ProgramStateMachineType_RecycleCount 2395
#define OpcUaId_ProgramStateMachineType_InstanceCount 2396
#define OpcUaId_ProgramStateMachineType_MaxInstanceCount 2397
#define OpcUaId_ProgramStateMachineType_MaxRecycleCount 2398
#define OpcUaId_ProgramStateMachineType_ProgramDiagnostic 2399
#define OpcUaId_ProgramStateMachineType_ProgramDiagnostic_CreateSessionId 3840
#define OpcUaId_ProgramStateMachineType_ProgramDiagnostic_CreateClientName 3841
#define OpcUaId_ProgramStateMachineType_ProgramDiagnostic_InvocationCreationTime 3842
#define OpcUaId_ProgramStateMachineType_ProgramDiagnostic_LastTransitionTime 3843
#define OpcUaId_ProgramStateMachineType_ProgramDiagnostic_LastMethodCall 3844
#define OpcUaId_ProgramStateMachineType_ProgramDiagnostic_LastMethodSessionId 3845
#define OpcUaId_ProgramStateMachineType_ProgramDiagnostic_LastMethodInputArguments 3846
#define OpcUaId_ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputArguments 3847
#define OpcUaId_ProgramStateMachineType_ProgramDiagnostic_LastMethodInputValues 15038
#define OpcUaId_ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputValues 15040
#define OpcUaId_ProgramStateMachineType_ProgramDiagnostic_LastMethodCallTime 3848
#define OpcUaId_ProgramStateMachineType_ProgramDiagnostic_LastMethodReturnStatus 3849
#define OpcUaId_ProgramStateMachineType_Halted_StateNumber 2407
#define OpcUaId_ProgramStateMachineType_Ready_StateNumber 2401
#define OpcUaId_ProgramStateMachineType_Running_StateNumber 2403
#define OpcUaId_ProgramStateMachineType_Suspended_StateNumber 2405
#define OpcUaId_ProgramStateMachineType_HaltedToReady_TransitionNumber 2409
#define OpcUaId_ProgramStateMachineType_ReadyToRunning_TransitionNumber 2411
#define OpcUaId_ProgramStateMachineType_RunningToHalted_TransitionNumber 2413
#define OpcUaId_ProgramStateMachineType_RunningToReady_TransitionNumber 2415
#define OpcUaId_ProgramStateMachineType_RunningToSuspended_TransitionNumber 2417
#define OpcUaId_ProgramStateMachineType_SuspendedToRunning_TransitionNumber 2419
#define OpcUaId_ProgramStateMachineType_SuspendedToHalted_TransitionNumber 2421
#define OpcUaId_ProgramStateMachineType_SuspendedToReady_TransitionNumber 2423
#define OpcUaId_ProgramStateMachineType_ReadyToHalted_TransitionNumber 2425
#define OpcUaId_ProgramTransitionEventType_Transition_Id 3802
#define OpcUaId_ProgramTransitionEventType_FromState_Id 3792
#define OpcUaId_ProgramTransitionEventType_ToState_Id 3797
#define OpcUaId_ProgramTransitionEventType_IntermediateResult 2379
#define OpcUaId_AuditProgramTransitionEventType_TransitionNumber 11875
#define OpcUaId_ProgramTransitionAuditEventType_Transition 3825
#define OpcUaId_ProgramTransitionAuditEventType_Transition_Id 3826
#define OpcUaId_ProgramDiagnosticType_CreateSessionId 2381
#define OpcUaId_ProgramDiagnosticType_CreateClientName 2382
#define OpcUaId_ProgramDiagnosticType_InvocationCreationTime 2383
#define OpcUaId_ProgramDiagnosticType_LastTransitionTime 2384
#define OpcUaId_ProgramDiagnosticType_LastMethodCall 2385
#define OpcUaId_ProgramDiagnosticType_LastMethodSessionId 2386
#define OpcUaId_ProgramDiagnosticType_LastMethodInputArguments 2387
#define OpcUaId_ProgramDiagnosticType_LastMethodOutputArguments 2388
#define OpcUaId_ProgramDiagnosticType_LastMethodCallTime 2389
#define OpcUaId_ProgramDiagnosticType_LastMethodReturnStatus 2390
#define OpcUaId_ProgramDiagnostic2Type_CreateSessionId 15384
#define OpcUaId_ProgramDiagnostic2Type_CreateClientName 15385
#define OpcUaId_ProgramDiagnostic2Type_InvocationCreationTime 15386
#define OpcUaId_ProgramDiagnostic2Type_LastTransitionTime 15387
#define OpcUaId_ProgramDiagnostic2Type_LastMethodCall 15388
#define OpcUaId_ProgramDiagnostic2Type_LastMethodSessionId 15389
#define OpcUaId_ProgramDiagnostic2Type_LastMethodInputArguments 15390
#define OpcUaId_ProgramDiagnostic2Type_LastMethodOutputArguments 15391
#define OpcUaId_ProgramDiagnostic2Type_LastMethodInputValues 15392
#define OpcUaId_ProgramDiagnostic2Type_LastMethodOutputValues 15393
#define OpcUaId_ProgramDiagnostic2Type_LastMethodCallTime 15394
#define OpcUaId_ProgramDiagnostic2Type_LastMethodReturnStatus 15395
#define OpcUaId_Annotations 11214
#define OpcUaId_HistoricalDataConfigurationType_AggregateConfiguration_TreatUncertainAsBad 11168
#define OpcUaId_HistoricalDataConfigurationType_AggregateConfiguration_PercentDataBad 11169
#define OpcUaId_HistoricalDataConfigurationType_AggregateConfiguration_PercentDataGood 11170
#define OpcUaId_HistoricalDataConfigurationType_AggregateConfiguration_UseSlopedExtrapolation 11171
#define OpcUaId_HistoricalDataConfigurationType_Stepped 2323
#define OpcUaId_HistoricalDataConfigurationType_Definition 2324
#define OpcUaId_HistoricalDataConfigurationType_MaxTimeInterval 2325
#define OpcUaId_HistoricalDataConfigurationType_MinTimeInterval 2326
#define OpcUaId_HistoricalDataConfigurationType_ExceptionDeviation 2327
#define OpcUaId_HistoricalDataConfigurationType_ExceptionDeviationFormat 2328
#define OpcUaId_HistoricalDataConfigurationType_StartOfArchive 11499
#define OpcUaId_HistoricalDataConfigurationType_StartOfOnlineArchive 11500
#define OpcUaId_HistoricalDataConfigurationType_ServerTimestampSupported 19092
#define OpcUaId_HAConfiguration_AggregateConfiguration_TreatUncertainAsBad 11204
#define OpcUaId_HAConfiguration_AggregateConfiguration_PercentDataBad 11205
#define OpcUaId_HAConfiguration_AggregateConfiguration_PercentDataGood 11206
#define OpcUaId_HAConfiguration_AggregateConfiguration_UseSlopedExtrapolation 11207
#define OpcUaId_HAConfiguration_Stepped 11208
#define OpcUaId_HistoricalEventFilter 11215
#define OpcUaId_HistoryServerCapabilitiesType_AccessHistoryDataCapability 2331
#define OpcUaId_HistoryServerCapabilitiesType_AccessHistoryEventsCapability 2332
#define OpcUaId_HistoryServerCapabilitiesType_MaxReturnDataValues 11268
#define OpcUaId_HistoryServerCapabilitiesType_MaxReturnEventValues 11269
#define OpcUaId_HistoryServerCapabilitiesType_InsertDataCapability 2334
#define OpcUaId_HistoryServerCapabilitiesType_ReplaceDataCapability 2335
#define OpcUaId_HistoryServerCapabilitiesType_UpdateDataCapability 2336
#define OpcUaId_HistoryServerCapabilitiesType_DeleteRawCapability 2337
#define OpcUaId_HistoryServerCapabilitiesType_DeleteAtTimeCapability 2338
#define OpcUaId_HistoryServerCapabilitiesType_InsertEventCapability 11278
#define OpcUaId_HistoryServerCapabilitiesType_ReplaceEventCapability 11279
#define OpcUaId_HistoryServerCapabilitiesType_UpdateEventCapability 11280
#define OpcUaId_HistoryServerCapabilitiesType_DeleteEventCapability 11501
#define OpcUaId_HistoryServerCapabilitiesType_InsertAnnotationCapability 11270
#define OpcUaId_HistoryServerCapabilitiesType_ServerTimestampSupported 19094
#define OpcUaId_AuditHistoryEventUpdateEventType_UpdatedNode 3025
#define OpcUaId_AuditHistoryEventUpdateEventType_PerformInsertReplace 3028
#define OpcUaId_AuditHistoryEventUpdateEventType_Filter 3003
#define OpcUaId_AuditHistoryEventUpdateEventType_NewValues 3029
#define OpcUaId_AuditHistoryEventUpdateEventType_OldValues 3030
#define OpcUaId_AuditHistoryValueUpdateEventType_UpdatedNode 3026
#define OpcUaId_AuditHistoryValueUpdateEventType_PerformInsertReplace 3031
#define OpcUaId_AuditHistoryValueUpdateEventType_NewValues 3032
#define OpcUaId_AuditHistoryValueUpdateEventType_OldValues 3033
#define OpcUaId_AuditHistoryAnnotationUpdateEventType_PerformInsertReplace 19293
#define OpcUaId_AuditHistoryAnnotationUpdateEventType_NewValues 19294
#define OpcUaId_AuditHistoryAnnotationUpdateEventType_OldValues 19295
#define OpcUaId_AuditHistoryDeleteEventType_UpdatedNode 3027
#define OpcUaId_AuditHistoryRawModifyDeleteEventType_IsDeleteModified 3015
#define OpcUaId_AuditHistoryRawModifyDeleteEventType_StartTime 3016
#define OpcUaId_AuditHistoryRawModifyDeleteEventType_EndTime 3017
#define OpcUaId_AuditHistoryRawModifyDeleteEventType_OldValues 3034
#define OpcUaId_AuditHistoryAtTimeDeleteEventType_ReqTimes 3020
#define OpcUaId_AuditHistoryAtTimeDeleteEventType_OldValues 3021
#define OpcUaId_AuditHistoryEventDeleteEventType_EventIds 3023
#define OpcUaId_AuditHistoryEventDeleteEventType_OldValues 3024
#define OpcUaId_TrustListType_Open_InputArguments 12528
#define OpcUaId_TrustListType_Open_OutputArguments 12529
#define OpcUaId_TrustListType_Close_InputArguments 12531
#define OpcUaId_TrustListType_Read_InputArguments 12533
#define OpcUaId_TrustListType_Read_OutputArguments 12534
#define OpcUaId_TrustListType_Write_InputArguments 12536
#define OpcUaId_TrustListType_GetPosition_InputArguments 12538
#define OpcUaId_TrustListType_GetPosition_OutputArguments 12539
#define OpcUaId_TrustListType_SetPosition_InputArguments 12541
#define OpcUaId_TrustListType_LastUpdateTime 12542
#define OpcUaId_TrustListType_UpdateFrequency 19296
#define OpcUaId_TrustListType_ActivityTimeout 32254
#define OpcUaId_TrustListType_DefaultValidationOptions 23563
#define OpcUaId_TrustListType_OpenWithMasks_InputArguments 12544
#define OpcUaId_TrustListType_OpenWithMasks_OutputArguments 12545
#define OpcUaId_TrustListType_CloseAndUpdate_InputArguments 12705
#define OpcUaId_TrustListType_CloseAndUpdate_OutputArguments 12547
#define OpcUaId_TrustListType_AddCertificate_InputArguments 12549
#define OpcUaId_TrustListType_RemoveCertificate_InputArguments 12551
#define OpcUaId_TrustListValidationOptions_OptionSetValues 23565
#define OpcUaId_TrustListMasks_EnumValues 12553
#define OpcUaId_TrustListOutOfDateAlarmType_EnabledState_Id 19315
#define OpcUaId_TrustListOutOfDateAlarmType_Quality_SourceTimestamp 19324
#define OpcUaId_TrustListOutOfDateAlarmType_LastSeverity_SourceTimestamp 19326
#define OpcUaId_TrustListOutOfDateAlarmType_Comment_SourceTimestamp 19328
#define OpcUaId_TrustListOutOfDateAlarmType_AddComment_InputArguments 19333
#define OpcUaId_TrustListOutOfDateAlarmType_ConditionRefresh_InputArguments 19335
#define OpcUaId_TrustListOutOfDateAlarmType_ConditionRefresh2_InputArguments 19337
#define OpcUaId_TrustListOutOfDateAlarmType_AckedState_Id 19339
#define OpcUaId_TrustListOutOfDateAlarmType_ConfirmedState_Id 19348
#define OpcUaId_TrustListOutOfDateAlarmType_Acknowledge_InputArguments 19357
#define OpcUaId_TrustListOutOfDateAlarmType_Confirm_InputArguments 19359
#define OpcUaId_TrustListOutOfDateAlarmType_ActiveState_Id 19361
#define OpcUaId_TrustListOutOfDateAlarmType_SuppressedState_Id 19371
#define OpcUaId_TrustListOutOfDateAlarmType_OutOfServiceState_Id 19380
#define OpcUaId_TrustListOutOfDateAlarmType_ShelvingState_CurrentState 19389
#define OpcUaId_TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Id 19390
#define OpcUaId_TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Id 19395
#define OpcUaId_TrustListOutOfDateAlarmType_ShelvingState_UnshelveTime 19402
#define OpcUaId_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve_InputArguments 19404
#define OpcUaId_TrustListOutOfDateAlarmType_ShelvingState_TimedShelve2_InputArguments 24971
#define OpcUaId_TrustListOutOfDateAlarmType_ShelvingState_Unshelve2_InputArguments 24973
#define OpcUaId_TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve2_InputArguments 24975
#define OpcUaId_TrustListOutOfDateAlarmType_SilenceState_Id 19415
#define OpcUaId_TrustListOutOfDateAlarmType_LatchedState_Id 19428
#define OpcUaId_TrustListOutOfDateAlarmType_Suppress2_InputArguments 24509
#define OpcUaId_TrustListOutOfDateAlarmType_Unsuppress2_InputArguments 24511
#define OpcUaId_TrustListOutOfDateAlarmType_RemoveFromService2_InputArguments 24513
#define OpcUaId_TrustListOutOfDateAlarmType_PlaceInService2_InputArguments 24515
#define OpcUaId_TrustListOutOfDateAlarmType_Reset2_InputArguments 24517
#define OpcUaId_TrustListOutOfDateAlarmType_GetGroupMemberships_OutputArguments 25176
#define OpcUaId_TrustListOutOfDateAlarmType_TrustListId 19446
#define OpcUaId_TrustListOutOfDateAlarmType_LastUpdateTime 19447
#define OpcUaId_TrustListOutOfDateAlarmType_UpdateFrequency 19448
#define OpcUaId_CertificateGroupType_TrustList_Size 13600
#define OpcUaId_CertificateGroupType_TrustList_Writable 13601
#define OpcUaId_CertificateGroupType_TrustList_UserWritable 13602
#define OpcUaId_CertificateGroupType_TrustList_OpenCount 13603
#define OpcUaId_CertificateGroupType_TrustList_Open_InputArguments 13606
#define OpcUaId_CertificateGroupType_TrustList_Open_OutputArguments 13607
#define OpcUaId_CertificateGroupType_TrustList_Close_InputArguments 13609
#define OpcUaId_CertificateGroupType_TrustList_Read_InputArguments 13611
#define OpcUaId_CertificateGroupType_TrustList_Read_OutputArguments 13612
#define OpcUaId_CertificateGroupType_TrustList_Write_InputArguments 13614
#define OpcUaId_CertificateGroupType_TrustList_GetPosition_InputArguments 13616
#define OpcUaId_CertificateGroupType_TrustList_GetPosition_OutputArguments 13617
#define OpcUaId_CertificateGroupType_TrustList_SetPosition_InputArguments 13619
#define OpcUaId_CertificateGroupType_TrustList_LastUpdateTime 13620
#define OpcUaId_CertificateGroupType_TrustList_OpenWithMasks_InputArguments 13622
#define OpcUaId_CertificateGroupType_TrustList_OpenWithMasks_OutputArguments 13623
#define OpcUaId_CertificateGroupType_TrustList_CloseAndUpdate_InputArguments 13625
#define OpcUaId_CertificateGroupType_TrustList_CloseAndUpdate_OutputArguments 13626
#define OpcUaId_CertificateGroupType_TrustList_AddCertificate_InputArguments 13628
#define OpcUaId_CertificateGroupType_TrustList_RemoveCertificate_InputArguments 13630
#define OpcUaId_CertificateGroupType_CertificateTypes 13631
#define OpcUaId_CertificateGroupType_GetRejectedList_OutputArguments 23527
#define OpcUaId_CertificateGroupType_CertificateExpired_EventId 19451
#define OpcUaId_CertificateGroupType_CertificateExpired_EventType 19452
#define OpcUaId_CertificateGroupType_CertificateExpired_SourceNode 19453
#define OpcUaId_CertificateGroupType_CertificateExpired_SourceName 19454
#define OpcUaId_CertificateGroupType_CertificateExpired_Time 19455
#define OpcUaId_CertificateGroupType_CertificateExpired_ReceiveTime 19456
#define OpcUaId_CertificateGroupType_CertificateExpired_Message 19458
#define OpcUaId_CertificateGroupType_CertificateExpired_Severity 19459
#define OpcUaId_CertificateGroupType_CertificateExpired_ConditionClassId 19460
#define OpcUaId_CertificateGroupType_CertificateExpired_ConditionClassName 19461
#define OpcUaId_CertificateGroupType_CertificateExpired_ConditionName 19464
#define OpcUaId_CertificateGroupType_CertificateExpired_BranchId 19465
#define OpcUaId_CertificateGroupType_CertificateExpired_Retain 19466
#define OpcUaId_CertificateGroupType_CertificateExpired_EnabledState 19467
#define OpcUaId_CertificateGroupType_CertificateExpired_EnabledState_Id 19468
#define OpcUaId_CertificateGroupType_CertificateExpired_Quality 19476
#define OpcUaId_CertificateGroupType_CertificateExpired_Quality_SourceTimestamp 19477
#define OpcUaId_CertificateGroupType_CertificateExpired_LastSeverity 19478
#define OpcUaId_CertificateGroupType_CertificateExpired_LastSeverity_SourceTimestamp 19479
#define OpcUaId_CertificateGroupType_CertificateExpired_Comment 19480
#define OpcUaId_CertificateGroupType_CertificateExpired_Comment_SourceTimestamp 19481
#define OpcUaId_CertificateGroupType_CertificateExpired_ClientUserId 19482
#define OpcUaId_CertificateGroupType_CertificateExpired_AddComment_InputArguments 19486
#define OpcUaId_CertificateGroupType_CertificateExpired_AckedState 19487
#define OpcUaId_CertificateGroupType_CertificateExpired_AckedState_Id 19488
#define OpcUaId_CertificateGroupType_CertificateExpired_ConfirmedState_Id 19497
#define OpcUaId_CertificateGroupType_CertificateExpired_Acknowledge_InputArguments 19506
#define OpcUaId_CertificateGroupType_CertificateExpired_Confirm_InputArguments 19508
#define OpcUaId_CertificateGroupType_CertificateExpired_ActiveState 19509
#define OpcUaId_CertificateGroupType_CertificateExpired_ActiveState_Id 19510
#define OpcUaId_CertificateGroupType_CertificateExpired_InputNode 19518
#define OpcUaId_CertificateGroupType_CertificateExpired_SuppressedState_Id 19520
#define OpcUaId_CertificateGroupType_CertificateExpired_OutOfServiceState_Id 19529
#define OpcUaId_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState 19538
#define OpcUaId_CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Id 19539
#define OpcUaId_CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Id 19544
#define OpcUaId_CertificateGroupType_CertificateExpired_ShelvingState_UnshelveTime 20096
#define OpcUaId_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve_InputArguments 20098
#define OpcUaId_CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 24979
#define OpcUaId_CertificateGroupType_CertificateExpired_ShelvingState_Unshelve2_InputArguments 24981
#define OpcUaId_CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 24983
#define OpcUaId_CertificateGroupType_CertificateExpired_SuppressedOrShelved 20101
#define OpcUaId_CertificateGroupType_CertificateExpired_SilenceState_Id 20109
#define OpcUaId_CertificateGroupType_CertificateExpired_LatchedState_Id 20122
#define OpcUaId_CertificateGroupType_CertificateExpired_Suppress2_InputArguments 24519
#define OpcUaId_CertificateGroupType_CertificateExpired_Unsuppress2_InputArguments 24521
#define OpcUaId_CertificateGroupType_CertificateExpired_RemoveFromService2_InputArguments 24523
#define OpcUaId_CertificateGroupType_CertificateExpired_PlaceInService2_InputArguments 24525
#define OpcUaId_CertificateGroupType_CertificateExpired_Reset2_InputArguments 24527
#define OpcUaId_CertificateGroupType_CertificateExpired_GetGroupMemberships_OutputArguments 25177
#define OpcUaId_CertificateGroupType_CertificateExpired_NormalState 20138
#define OpcUaId_CertificateGroupType_CertificateExpired_ExpirationDate 20139
#define OpcUaId_CertificateGroupType_CertificateExpired_CertificateType 20141
#define OpcUaId_CertificateGroupType_CertificateExpired_Certificate 20142
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_EventId 20144
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_EventType 20145
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_SourceNode 20146
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_SourceName 20147
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_Time 20148
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ReceiveTime 20149
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_Message 20151
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_Severity 20152
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ConditionClassId 20153
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ConditionClassName 20154
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ConditionName 20157
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_BranchId 20158
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_Retain 20159
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_EnabledState 20160
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_EnabledState_Id 20161
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_Quality 20169
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_Quality_SourceTimestamp 20170
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_LastSeverity 20171
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_LastSeverity_SourceTimestamp 20172
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_Comment 20173
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_Comment_SourceTimestamp 20174
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ClientUserId 20175
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_AddComment_InputArguments 20179
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_AckedState 20180
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_AckedState_Id 20181
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ConfirmedState_Id 20190
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_Acknowledge_InputArguments 20199
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_Confirm_InputArguments 20201
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ActiveState 20202
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ActiveState_Id 20203
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_InputNode 20211
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_SuppressedState_Id 20213
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Id 20222
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState 20231
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Id 20232
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Id 20237
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ShelvingState_UnshelveTime 20244
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 20246
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 24987
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 24989
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 24991
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_SuppressedOrShelved 20249
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_SilenceState_Id 20257
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_LatchedState_Id 20270
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_Suppress2_InputArguments 24529
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_Unsuppress2_InputArguments 24531
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_RemoveFromService2_InputArguments 24533
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_PlaceInService2_InputArguments 24535
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_Reset2_InputArguments 24537
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_GetGroupMemberships_OutputArguments 25178
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_NormalState 20286
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_TrustListId 20287
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_LastUpdateTime 20288
#define OpcUaId_CertificateGroupType_TrustListOutOfDate_UpdateFrequency 20289
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Size 13816
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Writable 13817
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UserWritable 13818
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenCount 13819
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_InputArguments 13822
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_OutputArguments 13823
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close_InputArguments 13825
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_InputArguments 13827
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_OutputArguments 13828
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write_InputArguments 13830
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_InputArguments 13832
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments 13833
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition_InputArguments 13835
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_LastUpdateTime 13836
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments 13838
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments 13839
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments 13841
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments 13842
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments 13844
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments 13846
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateTypes 13847
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_GetRejectedList_OutputArguments 23530
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventId 20292
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventType 20293
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceNode 20294
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceName 20295
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Time 20296
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReceiveTime 20297
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Message 20299
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Severity 20300
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassId 20301
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassName 20302
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionName 20305
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_BranchId 20306
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Retain 20307
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState 20308
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Id 20309
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality 20317
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp 20318
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity 20319
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp 20320
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment 20321
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp 20322
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ClientUserId 20323
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments 20327
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState 20328
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Id 20329
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id 20338
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments 20347
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments 20349
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState 20350
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Id 20351
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_InputNode 20359
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id 20361
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id 20370
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState 20379
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id 20380
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id 20385
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime 20392
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 20394
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 24995
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 24997
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 24999
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved 20397
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Id 20405
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Id 20420
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments 24539
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments 24541
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments 24543
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments 24545
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments 24547
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments 25179
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_NormalState 20436
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ExpirationDate 20437
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_CertificateType 20439
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Certificate 20440
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventId 20442
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventType 20443
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceNode 20444
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceName 20445
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Time 20446
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime 20447
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Message 20449
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Severity 20450
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId 20451
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName 20452
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionName 20455
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_BranchId 20456
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Retain 20457
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState 20458
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id 20459
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality 20467
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp 20468
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity 20469
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 20470
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment 20471
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp 20472
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId 20473
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments 20477
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState 20478
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id 20479
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id 20488
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments 20497
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments 20499
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState 20500
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id 20501
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_InputNode 20509
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id 20511
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id 20520
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState 20529
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 20530
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 20535
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 20542
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 20544
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 25003
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 25005
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 25007
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved 20547
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id 20555
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id 20568
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments 24549
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments 24551
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 24553
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments 24555
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments 24557
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 25180
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_NormalState 20584
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_TrustListId 20585
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime 20586
#define OpcUaId_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency 20587
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Size 13850
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Writable 13851
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_UserWritable 13852
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenCount 13853
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_InputArguments 13856
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_OutputArguments 13857
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close_InputArguments 13859
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_InputArguments 13861
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_OutputArguments 13862
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write_InputArguments 13864
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_InputArguments 13866
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments 13867
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition_InputArguments 13869
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_LastUpdateTime 13870
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments 13872
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments 13873
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments 13875
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments 13876
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments 13878
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments 13880
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateTypes 13881
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_GetRejectedList_OutputArguments 23532
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EventId 20590
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EventType 20591
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SourceNode 20592
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SourceName 20593
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Time 20594
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ReceiveTime 20595
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Message 20597
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Severity 20598
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionClassId 20599
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionClassName 20600
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionName 20603
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_BranchId 20604
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Retain 20605
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState 20606
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_Id 20607
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Quality 20615
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp 20616
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LastSeverity 20617
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp 20618
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Comment 20619
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp 20620
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ClientUserId 20621
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments 20625
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState 20626
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_Id 20627
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id 20636
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments 20645
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments 20647
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState 20648
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_Id 20649
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_InputNode 20657
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id 20659
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id 20668
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState 20677
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id 20678
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id 20683
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime 20690
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 20692
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 25011
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 25013
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 25015
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved 20695
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_Id 20703
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_Id 20716
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments 24559
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments 24561
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments 24563
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments 24565
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments 24567
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments 25181
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_NormalState 20732
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ExpirationDate 20733
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_CertificateType 20735
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Certificate 20736
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EventId 20738
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EventType 20739
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SourceNode 20740
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SourceName 20741
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Time 20742
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime 20743
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Message 20745
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Severity 20746
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId 20747
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName 20748
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionName 20751
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_BranchId 20752
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Retain 20753
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState 20754
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id 20755
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Quality 20763
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp 20764
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity 20765
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 20766
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Comment 20767
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp 20768
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId 20769
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments 20773
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState 20774
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id 20775
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id 20784
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments 20793
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments 20795
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState 20796
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id 20797
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_InputNode 20805
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id 20807
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id 20816
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState 20825
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 20826
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 20831
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 20838
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 20840
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 25019
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 25021
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 25023
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved 20843
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id 20851
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id 20864
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments 24569
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments 24571
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 24573
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments 24575
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments 24577
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 25182
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_NormalState 20880
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_TrustListId 20881
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime 20882
#define OpcUaId_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency 20883
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Size 13884
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Writable 13885
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_UserWritable 13886
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenCount 13887
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_InputArguments 13890
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_OutputArguments 13891
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close_InputArguments 13893
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_InputArguments 13895
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_OutputArguments 13896
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write_InputArguments 13898
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments 13900
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments 13901
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments 13903
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_LastUpdateTime 13904
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments 13906
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments 13907
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments 13909
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments 13910
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments 13912
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments 13914
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateTypes 13915
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_GetRejectedList_OutputArguments 23534
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EventId 20886
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EventType 20887
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SourceNode 20888
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SourceName 20889
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Time 20890
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ReceiveTime 20891
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Message 20893
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Severity 20894
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionClassId 20895
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionClassName 20896
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionName 20899
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_BranchId 20900
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Retain 20901
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState 20902
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id 20903
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Quality 20911
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp 20912
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LastSeverity 20913
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp 20914
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Comment 20915
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp 20916
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ClientUserId 20917
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments 20921
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState 20922
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_Id 20923
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id 20932
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments 20941
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments 20943
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState 20944
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id 20945
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_InputNode 20953
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id 20955
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id 20964
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState 20973
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id 20974
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id 20979
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime 20986
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 20988
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 25027
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 25029
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 25031
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved 20991
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id 21008
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id 21215
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments 24579
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments 24581
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments 24583
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments 24585
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments 24587
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments 25183
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_NormalState 21231
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ExpirationDate 21232
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_CertificateType 21234
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Certificate 21235
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EventId 21237
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EventType 21238
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode 21239
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SourceName 21240
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Time 21241
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime 21242
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Message 21244
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Severity 21245
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId 21246
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName 21247
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName 21250
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_BranchId 21251
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Retain 21252
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState 21253
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id 21254
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Quality 21262
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp 21263
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity 21264
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 21265
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Comment 21266
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp 21267
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId 21268
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments 21272
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState 21273
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id 21274
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id 21283
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments 21292
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments 21294
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState 21295
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id 21296
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_InputNode 21304
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id 21306
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id 21315
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState 21324
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 21325
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 21330
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 21337
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 21339
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 25035
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 25037
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 25039
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved 21342
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id 21350
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id 21363
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments 24589
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments 24591
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 24593
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments 24595
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments 24597
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 25184
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_NormalState 21379
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId 21380
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime 21381
#define OpcUaId_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency 21382
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Size 13918
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Writable 13919
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_UserWritable 13920
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenCount 13921
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_InputArguments 13924
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_OutputArguments 13925
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close_InputArguments 13927
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_InputArguments 13929
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_OutputArguments 13930
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write_InputArguments 13932
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_InputArguments 13934
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_OutputArguments 13935
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition_InputArguments 13937
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_LastUpdateTime 13938
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_InputArguments 13940
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_OutputArguments 13941
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_InputArguments 13943
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_OutputArguments 13944
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate_InputArguments 13946
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate_InputArguments 13948
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateTypes 13949
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_GetRejectedList_OutputArguments 23536
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EventId 21385
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EventType 21386
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SourceNode 21387
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SourceName 21388
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Time 21389
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ReceiveTime 21390
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Message 21392
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Severity 21393
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionClassId 21394
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionClassName 21395
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionName 21398
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_BranchId 21399
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Retain 21400
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState 21401
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_Id 21402
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Quality 21410
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Quality_SourceTimestamp 21411
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LastSeverity 21412
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LastSeverity_SourceTimestamp 21413
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Comment 21414
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Comment_SourceTimestamp 21415
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ClientUserId 21416
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment_InputArguments 21420
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState 21421
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_Id 21422
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_Id 21431
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge_InputArguments 21440
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Confirm_InputArguments 21442
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState 21443
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_Id 21444
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_InputNode 21452
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_Id 21454
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_Id 21463
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState 21472
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_Id 21473
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_Id 21478
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_UnshelveTime 21485
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve_InputArguments 21487
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 25043
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve2_InputArguments 25045
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 25047
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedOrShelved 21490
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_Id 21498
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_Id 21511
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress2_InputArguments 24599
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress2_InputArguments 24601
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService2_InputArguments 24603
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService2_InputArguments 24605
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset2_InputArguments 24607
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_GetGroupMemberships_OutputArguments 25185
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_NormalState 21527
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ExpirationDate 21528
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_CertificateType 21530
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Certificate 21531
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EventId 21533
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EventType 21534
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SourceNode 21535
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SourceName 21536
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Time 21537
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ReceiveTime 21538
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Message 21540
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Severity 21541
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionClassId 21542
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionClassName 21543
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionName 21546
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_BranchId 21547
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Retain 21548
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState 21549
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_Id 21550
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Quality 21558
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Quality_SourceTimestamp 21559
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastSeverity 21560
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastSeverity_SourceTimestamp 21561
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Comment 21562
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Comment_SourceTimestamp 21563
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ClientUserId 21564
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment_InputArguments 21568
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState 21569
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_Id 21570
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_Id 21579
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge_InputArguments 21588
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Confirm_InputArguments 21590
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState 21591
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_Id 21592
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_InputNode 21600
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_Id 21602
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_Id 21611
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState 21620
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_Id 21621
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_Id 21626
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_UnshelveTime 21633
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 21635
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 25051
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 25053
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 25055
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedOrShelved 21638
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_Id 21646
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_Id 21659
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress2_InputArguments 24609
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress2_InputArguments 24611
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService2_InputArguments 24613
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService2_InputArguments 24615
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset2_InputArguments 24617
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_GetGroupMemberships_OutputArguments 25186
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_NormalState 21675
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_TrustListId 21676
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastUpdateTime 21677
#define OpcUaId_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_UpdateFrequency 21678
#define OpcUaId_TrustListUpdatedAuditEventType_TrustListId 32281
#define OpcUaId_TransactionDiagnosticsType_StartTime 32287
#define OpcUaId_TransactionDiagnosticsType_EndTime 32288
#define OpcUaId_TransactionDiagnosticsType_Result 32289
#define OpcUaId_TransactionDiagnosticsType_AffectedTrustLists 32290
#define OpcUaId_TransactionDiagnosticsType_AffectedCertificateGroups 32291
#define OpcUaId_TransactionDiagnosticsType_Errors 32292
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Size 13953
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Writable 13954
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable 13955
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount 13956
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments 13959
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments 13960
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments 13962
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments 13964
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments 13965
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments 13967
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments 13969
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments 13970
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments 13972
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime 13973
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments 13975
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments 13976
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments 13978
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments 13979
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments 13981
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments 13983
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateTypes 13984
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments 23545
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId 21681
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType 21682
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode 21683
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName 21684
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time 21685
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime 21686
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message 21688
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity 21689
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId 21690
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName 21691
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName 21694
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId 21695
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain 21696
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState 21697
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id 21698
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality 21706
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp 21707
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity 21708
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp 21709
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment 21710
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp 21711
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId 21712
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments 21716
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState 21717
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id 21718
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id 21727
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments 21736
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments 21738
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState 21739
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id 21740
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode 21748
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id 21750
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id 21759
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState 21768
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id 21769
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id 21774
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime 21781
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 21783
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 25059
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 25061
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 25063
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved 21786
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id 21794
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id 21807
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments 24619
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments 24621
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments 24623
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments 24625
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments 24627
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments 25187
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState 21823
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate 21824
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType 21826
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate 21827
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId 21829
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType 21830
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode 21831
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName 21832
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time 21833
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime 21834
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message 21836
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity 21837
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId 21838
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName 21839
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName 21842
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId 21843
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain 21844
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState 21845
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id 21846
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality 21854
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp 21855
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity 21856
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 21857
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment 21858
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp 21859
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId 21860
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments 21864
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState 21865
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id 21866
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id 21875
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments 21884
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments 21886
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState 21887
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id 21888
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode 21896
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id 21898
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id 21907
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState 21916
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 21917
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 21922
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 21929
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 21931
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 25067
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 25069
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 25071
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved 21934
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id 21942
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id 21955
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments 24629
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments 24631
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 24633
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments 24635
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments 24637
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 25188
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState 21971
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId 21972
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime 21973
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency 21974
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Size 13987
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Writable 13988
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable 13989
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount 13990
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments 13993
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments 13994
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments 13996
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments 13998
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments 13999
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments 14001
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments 14003
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments 14004
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments 14006
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime 14007
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments 14009
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments 14010
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments 14012
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments 14013
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments 14015
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments 14017
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateTypes 14018
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments 23547
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId 21977
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType 21978
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode 21979
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName 21980
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time 21981
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime 21982
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message 21984
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity 21985
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId 21986
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName 21987
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName 21990
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId 21991
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain 21992
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState 21993
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id 21994
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality 22002
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp 22003
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity 22004
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp 22005
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment 22006
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp 22007
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId 22008
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments 22012
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState 22013
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id 22014
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id 22023
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments 22032
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments 22034
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState 22035
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id 22036
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode 22044
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id 22046
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id 22055
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState 22064
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id 22065
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id 22070
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime 22077
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 22079
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 25075
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 25077
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 25079
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved 22082
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id 22090
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id 22103
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments 24639
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments 24641
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments 24643
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments 24645
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments 24647
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments 25189
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState 22119
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate 22120
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType 22122
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate 22123
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId 22125
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType 22126
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode 22127
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName 22128
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time 22129
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime 22130
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message 22132
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity 22133
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId 22134
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName 22135
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName 22138
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId 22139
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain 22140
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState 22141
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id 22142
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality 22150
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp 22151
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity 22152
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 22153
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment 22154
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp 22155
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId 22156
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments 22160
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState 22161
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id 22162
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id 22171
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments 22180
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments 22182
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState 22183
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id 22184
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode 22192
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id 22194
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id 22203
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState 22212
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 22213
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 22218
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 22225
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 22227
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 25083
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 25085
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 25087
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved 22230
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id 22238
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id 22251
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments 24649
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments 24651
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 24653
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments 24655
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments 24657
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 25190
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState 22267
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId 22268
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime 22269
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency 22270
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Size 14021
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable 14022
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable 14023
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount 14024
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments 14027
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments 14028
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments 14030
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments 14032
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments 14033
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments 14035
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments 14037
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments 14038
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments 14040
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime 14041
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments 14043
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments 14044
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments 14046
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments 14047
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments 14049
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments 14051
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateTypes 14052
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments 23549
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId 22273
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType 22274
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode 22275
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName 22276
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time 22277
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime 22278
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message 22280
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity 22281
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId 22282
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName 22283
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName 22286
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId 22287
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain 22288
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState 22289
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id 22290
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality 22298
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp 22299
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity 22300
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp 22301
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment 22302
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp 22303
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId 22304
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments 22308
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState 22309
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id 22310
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id 22319
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments 22328
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments 22330
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState 22331
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id 22332
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode 22340
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id 22342
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id 22351
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState 22360
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id 22361
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id 22366
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime 22373
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 22375
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 25091
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 25093
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 25095
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved 22378
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id 22386
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id 22399
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments 24659
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments 24661
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments 24663
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments 24665
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments 24667
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments 25191
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState 22415
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate 22416
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType 22418
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate 22419
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId 22421
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType 22422
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode 22423
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName 22424
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time 22425
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime 22426
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message 22428
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity 22429
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId 22430
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName 22431
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName 22434
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId 22435
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain 22436
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState 22437
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id 22438
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality 22446
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp 22447
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity 22448
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 22449
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment 22450
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp 22451
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId 22452
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments 22456
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState 22457
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id 22458
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id 22467
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments 22476
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments 22478
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState 22479
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id 22480
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode 22488
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id 22490
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id 22499
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState 22508
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 22509
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 22514
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 22521
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 22523
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 25099
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 25101
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 25103
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved 22526
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id 22534
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id 22547
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments 24669
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments 24671
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 24673
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments 24675
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments 24677
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 25192
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState 22563
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId 22564
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime 22565
#define OpcUaId_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency 22566
#define OpcUaId_ServerConfigurationType_ApplicationUri 25696
#define OpcUaId_ServerConfigurationType_ProductUri 25724
#define OpcUaId_ServerConfigurationType_ApplicationType 25697
#define OpcUaId_ServerConfigurationType_ServerCapabilities 12708
#define OpcUaId_ServerConfigurationType_SupportedPrivateKeyFormats 12583
#define OpcUaId_ServerConfigurationType_MaxTrustListSize 12584
#define OpcUaId_ServerConfigurationType_MulticastDnsEnabled 12585
#define OpcUaId_ServerConfigurationType_HasSecureElement 23593
#define OpcUaId_ServerConfigurationType_UpdateCertificate_InputArguments 12617
#define OpcUaId_ServerConfigurationType_UpdateCertificate_OutputArguments 12618
#define OpcUaId_ServerConfigurationType_GetCertificates_InputArguments 32297
#define OpcUaId_ServerConfigurationType_GetCertificates_OutputArguments 32298
#define OpcUaId_ServerConfigurationType_CreateSigningRequest_InputArguments 12732
#define OpcUaId_ServerConfigurationType_CreateSigningRequest_OutputArguments 12733
#define OpcUaId_ServerConfigurationType_GetRejectedList_OutputArguments 12776
#define OpcUaId_ServerConfigurationType_TransactionDiagnostics_StartTime 32300
#define OpcUaId_ServerConfigurationType_TransactionDiagnostics_EndTime 32301
#define OpcUaId_ServerConfigurationType_TransactionDiagnostics_Result 32302
#define OpcUaId_ServerConfigurationType_TransactionDiagnostics_AffectedTrustLists 32303
#define OpcUaId_ServerConfigurationType_TransactionDiagnostics_AffectedCertificateGroups 32304
#define OpcUaId_ServerConfigurationType_TransactionDiagnostics_Errors 32305
#define OpcUaId_CertificateUpdatedAuditEventType_CertificateGroup 13735
#define OpcUaId_CertificateUpdatedAuditEventType_CertificateType 13736
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Size 12643
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Writable 14157
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable 14158
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount 12646
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments 12648
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments 12649
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments 12651
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments 12653
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments 12654
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments 12656
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments 12658
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments 12659
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments 12661
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime 12662
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments 12664
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments 12665
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments 14160
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments 12667
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments 12669
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments 12671
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateTypes 14161
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments 23551
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId 22569
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType 22570
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode 22571
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName 22572
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time 22573
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime 22574
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message 22576
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity 22577
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId 22578
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName 22579
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName 22582
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId 22583
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain 22584
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState 22585
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id 22586
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality 22594
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp 22595
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity 22596
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp 22597
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment 22598
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp 22599
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId 22600
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments 22604
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState 22605
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id 22606
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id 22615
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments 22624
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments 22626
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState 22627
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id 22628
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode 22636
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id 22638
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id 22647
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState 22656
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id 22657
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id 22662
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime 22669
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 22671
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 25107
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 25109
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 25111
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved 22674
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id 22682
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id 22695
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments 24679
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments 24681
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments 24683
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments 24685
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments 24687
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments 25193
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState 22711
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate 22712
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType 22714
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate 22715
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId 22717
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType 22718
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode 22719
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName 22720
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time 22721
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime 22722
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message 22724
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity 22725
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId 22726
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName 22727
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName 22730
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId 22731
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain 22732
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState 22733
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id 22734
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality 22742
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp 22743
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity 22744
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 22745
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment 22746
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp 22747
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId 22748
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments 22752
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState 22753
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id 22754
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id 22763
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments 22772
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments 22774
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState 22775
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id 22776
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode 22784
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id 22786
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id 22795
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState 22804
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 22805
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 22810
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 22817
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 22819
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 25115
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 25117
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 25119
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved 22822
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id 22830
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id 22843
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments 24689
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments 24691
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 24693
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments 24695
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments 24697
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 25194
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState 22859
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId 22860
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime 22861
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency 22862
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Size 14090
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Writable 14091
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable 14092
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount 14093
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments 14096
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments 14097
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments 14099
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments 14101
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments 14102
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments 14104
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments 14106
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments 14107
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments 14109
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime 14110
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments 14112
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments 14113
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments 14115
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments 14116
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments 14118
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments 14120
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateTypes 14121
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments 23553
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId 22865
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType 22866
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode 22867
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName 22868
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time 22869
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime 22870
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message 22872
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity 22873
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId 22874
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName 22875
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName 22878
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId 22879
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain 22880
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState 22881
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id 22882
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality 22890
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp 22891
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity 22892
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp 22893
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment 22894
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp 22895
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId 22896
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments 22900
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState 22901
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id 22902
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id 22911
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments 22920
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments 22922
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState 22923
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id 22924
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode 22932
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id 22934
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id 22943
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState 22952
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id 22953
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id 22958
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime 22965
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 22967
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 25123
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 25125
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 25127
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved 22970
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id 22978
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id 22991
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments 24699
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments 24701
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments 24703
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments 24705
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments 24707
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments 25195
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState 23007
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate 23008
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType 23010
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate 23011
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId 23013
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType 23014
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode 23015
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName 23016
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time 23017
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime 23018
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message 23020
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity 23021
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId 23022
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName 23023
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName 23026
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId 23027
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain 23028
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState 23029
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id 23030
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality 23038
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp 23039
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity 23040
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 23041
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment 23042
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp 23043
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId 23044
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments 23048
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState 23049
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id 23050
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id 23059
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments 23068
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments 23070
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState 23071
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id 23072
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode 23080
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id 23082
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id 23091
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState 23100
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 23101
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 23106
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 23113
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 23115
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 25131
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 25133
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 25135
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved 23118
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id 23126
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id 23139
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments 24709
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments 24711
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 24713
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments 24715
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments 24717
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 25196
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState 23155
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId 23156
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime 23157
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency 23158
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Size 14124
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable 14125
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable 14126
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount 14127
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments 14130
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments 14131
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments 14133
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments 14135
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments 14136
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments 14138
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments 14140
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments 14141
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments 14143
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime 14144
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments 14146
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments 14147
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments 14149
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments 14150
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments 14152
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments 14154
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateTypes 14155
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments 23555
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId 23161
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType 23162
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode 23163
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName 23164
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time 23165
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime 23166
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message 23168
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity 23169
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId 23170
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName 23171
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName 23174
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId 23175
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain 23176
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState 23177
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id 23178
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality 23186
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp 23187
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity 23188
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp 23189
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment 23190
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp 23191
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId 23192
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments 23196
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState 23197
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id 23198
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id 23207
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments 23216
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments 23218
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState 23219
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id 23220
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode 23228
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id 23230
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id 23239
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState 23248
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id 23249
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id 23254
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime 23261
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 23263
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 25139
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 25141
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 25143
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved 23266
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id 23274
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id 23287
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments 24719
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments 24721
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments 24723
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments 24725
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments 24727
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments 25197
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState 23303
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate 23304
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType 23306
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate 23307
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId 23309
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType 23310
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode 23311
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName 23312
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time 23313
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime 23314
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message 23316
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity 23317
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId 23318
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName 23319
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName 23322
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId 23323
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain 23324
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState 23325
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id 23326
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality 23334
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp 23335
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity 23336
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 23337
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment 23338
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp 23339
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId 23340
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments 23344
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState 23345
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id 23346
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id 23355
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments 23364
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments 23366
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState 23367
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id 23368
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode 23376
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id 23378
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id 23387
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState 23396
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 23397
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 23402
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 23409
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 23411
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 25147
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 25149
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 25151
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved 23414
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id 23422
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id 23435
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments 24729
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments 24731
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 24733
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments 24735
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments 24737
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 25198
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState 23451
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId 23452
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime 23453
#define OpcUaId_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency 23454
#define OpcUaId_ServerConfiguration_ApplicationUri 25706
#define OpcUaId_ServerConfiguration_ProductUri 25725
#define OpcUaId_ServerConfiguration_ApplicationType 25707
#define OpcUaId_ServerConfiguration_ServerCapabilities 12710
#define OpcUaId_ServerConfiguration_SupportedPrivateKeyFormats 12639
#define OpcUaId_ServerConfiguration_MaxTrustListSize 12640
#define OpcUaId_ServerConfiguration_MulticastDnsEnabled 12641
#define OpcUaId_ServerConfiguration_HasSecureElement 23597
#define OpcUaId_ServerConfiguration_UpdateCertificate_InputArguments 13738
#define OpcUaId_ServerConfiguration_UpdateCertificate_OutputArguments 13739
#define OpcUaId_ServerConfiguration_GetCertificates_InputArguments 32334
#define OpcUaId_ServerConfiguration_GetCertificates_OutputArguments 32335
#define OpcUaId_ServerConfiguration_CreateSigningRequest_InputArguments 12738
#define OpcUaId_ServerConfiguration_CreateSigningRequest_OutputArguments 12739
#define OpcUaId_ServerConfiguration_GetRejectedList_OutputArguments 12778
#define OpcUaId_ServerConfiguration_TransactionDiagnostics_StartTime 32337
#define OpcUaId_ServerConfiguration_TransactionDiagnostics_EndTime 32338
#define OpcUaId_ServerConfiguration_TransactionDiagnostics_Result 32339
#define OpcUaId_ServerConfiguration_TransactionDiagnostics_AffectedTrustLists 32340
#define OpcUaId_ServerConfiguration_TransactionDiagnostics_AffectedCertificateGroups 32341
#define OpcUaId_ServerConfiguration_TransactionDiagnostics_Errors 32342
#define OpcUaId_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_ResourceUri 17512
#define OpcUaId_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_ProfileUri 17513
#define OpcUaId_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_GetEncryptingKey_InputArguments 17517
#define OpcUaId_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_GetEncryptingKey_OutputArguments 17518
#define OpcUaId_KeyCredentialConfigurationFolderType_ServiceName_Placeholder_UpdateCredential_InputArguments 17520
#define OpcUaId_KeyCredentialConfigurationFolderType_CreateCredential_InputArguments 17523
#define OpcUaId_KeyCredentialConfigurationFolderType_CreateCredential_OutputArguments 17524
#define OpcUaId_KeyCredentialConfiguration_ServiceName_Placeholder_ResourceUri 18157
#define OpcUaId_KeyCredentialConfiguration_ServiceName_Placeholder_ProfileUri 18164
#define OpcUaId_KeyCredentialConfiguration_ServiceName_Placeholder_GetEncryptingKey_InputArguments 17526
#define OpcUaId_KeyCredentialConfiguration_ServiceName_Placeholder_GetEncryptingKey_OutputArguments 17527
#define OpcUaId_KeyCredentialConfiguration_ServiceName_Placeholder_UpdateCredential_InputArguments 18162
#define OpcUaId_KeyCredentialConfiguration_CreateCredential_InputArguments 17529
#define OpcUaId_KeyCredentialConfiguration_CreateCredential_OutputArguments 17530
#define OpcUaId_KeyCredentialConfigurationType_ResourceUri 18069
#define OpcUaId_KeyCredentialConfigurationType_ProfileUri 18165
#define OpcUaId_KeyCredentialConfigurationType_EndpointUrls 18004
#define OpcUaId_KeyCredentialConfigurationType_ServiceStatus 18005
#define OpcUaId_KeyCredentialConfigurationType_GetEncryptingKey_InputArguments 17535
#define OpcUaId_KeyCredentialConfigurationType_GetEncryptingKey_OutputArguments 17536
#define OpcUaId_KeyCredentialConfigurationType_UpdateCredential_InputArguments 18007
#define OpcUaId_KeyCredentialAuditEventType_ResourceUri 18028
#define OpcUaId_KeyCredentialDeletedAuditEventType_ResourceUri 18064
#define OpcUaId_AuthorizationServicesConfigurationFolderType_ServiceName_Placeholder_ServiceUri 23558
#define OpcUaId_AuthorizationServicesConfigurationFolderType_ServiceName_Placeholder_ServiceCertificate 23559
#define OpcUaId_AuthorizationServicesConfigurationFolderType_ServiceName_Placeholder_IssuerEndpointUrl 23560
#define OpcUaId_AuthorizationServiceConfigurationType_ServiceUri 18072
#define OpcUaId_AuthorizationServiceConfigurationType_ServiceCertificate 17860
#define OpcUaId_AuthorizationServiceConfigurationType_IssuerEndpointUrl 18073
#define OpcUaId_AggregateConfigurationType_TreatUncertainAsBad 11188
#define OpcUaId_AggregateConfigurationType_PercentDataBad 11189
#define OpcUaId_AggregateConfigurationType_PercentDataGood 11190
#define OpcUaId_AggregateConfigurationType_UseSlopedExtrapolation 11191
#define OpcUaId_PubSubState_EnumStrings 14648
#define OpcUaId_DataSetFieldFlags_OptionSetValues 15577
#define OpcUaId_DataSetFieldContentMask_OptionSetValues 15584
#define OpcUaId_OverrideValueHandling_EnumStrings 15875
#define OpcUaId_DataSetOrderingType_EnumStrings 15641
#define OpcUaId_UadpNetworkMessageContentMask_OptionSetValues 15643
#define OpcUaId_UadpDataSetMessageContentMask_OptionSetValues 15647
#define OpcUaId_JsonNetworkMessageContentMask_OptionSetValues 15655
#define OpcUaId_JsonDataSetMessageContentMask_OptionSetValues 15659
#define OpcUaId_BrokerTransportQualityOfService_EnumStrings 15009
#define OpcUaId_PubSubKeyServiceType_GetSecurityKeys_InputArguments 15908
#define OpcUaId_PubSubKeyServiceType_GetSecurityKeys_OutputArguments 15909
#define OpcUaId_PubSubKeyServiceType_GetSecurityGroup_InputArguments 15911
#define OpcUaId_PubSubKeyServiceType_GetSecurityGroup_OutputArguments 15912
#define OpcUaId_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_InputArguments 15915
#define OpcUaId_PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_OutputArguments 15916
#define OpcUaId_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup_InputArguments 15918
#define OpcUaId_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_InputArguments 25272
#define OpcUaId_PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder_OutputArguments 25273
#define OpcUaId_PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments 25275
#define OpcUaId_PubSubKeyServiceType_KeyPushTargets_AddPushTarget_InputArguments 25279
#define OpcUaId_PubSubKeyServiceType_KeyPushTargets_AddPushTarget_OutputArguments 25280
#define OpcUaId_PubSubKeyServiceType_KeyPushTargets_RemovePushTarget_InputArguments 25282
#define OpcUaId_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_InputArguments 25284
#define OpcUaId_PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder_OutputArguments 25285
#define OpcUaId_PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder_InputArguments 25287
#define OpcUaId_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_InputArguments 15455
#define OpcUaId_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_OutputArguments 15456
#define OpcUaId_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup_InputArguments 15458
#define OpcUaId_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_InputArguments 25294
#define OpcUaId_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder_OutputArguments 25295
#define OpcUaId_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder_InputArguments 25297
#define OpcUaId_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_SupportedSecurityPolicyUris 25298
#define OpcUaId_SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityGroupId 15460
#define OpcUaId_SecurityGroupFolderType_SecurityGroupName_Placeholder_KeyLifetime 15010
#define OpcUaId_SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityPolicyUri 15011
#define OpcUaId_SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxFutureKeyCount 15012
#define OpcUaId_SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxPastKeyCount 15043
#define OpcUaId_SecurityGroupFolderType_AddSecurityGroup_InputArguments 15462
#define OpcUaId_SecurityGroupFolderType_AddSecurityGroup_OutputArguments 15463
#define OpcUaId_SecurityGroupFolderType_RemoveSecurityGroup_InputArguments 15465
#define OpcUaId_SecurityGroupFolderType_AddSecurityGroupFolder_InputArguments 25313
#define OpcUaId_SecurityGroupFolderType_AddSecurityGroupFolder_OutputArguments 25314
#define OpcUaId_SecurityGroupFolderType_RemoveSecurityGroupFolder_InputArguments 25316
#define OpcUaId_SecurityGroupFolderType_SupportedSecurityPolicyUris 25317
#define OpcUaId_SecurityGroupType_SecurityGroupId 15472
#define OpcUaId_SecurityGroupType_KeyLifetime 15046
#define OpcUaId_SecurityGroupType_SecurityPolicyUri 15047
#define OpcUaId_SecurityGroupType_MaxFutureKeyCount 15048
#define OpcUaId_SecurityGroupType_MaxPastKeyCount 15056
#define OpcUaId_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityGroupId 25627
#define OpcUaId_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_KeyLifetime 25628
#define OpcUaId_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_SecurityPolicyUri 25629
#define OpcUaId_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxFutureKeyCount 25630
#define OpcUaId_PubSubKeyPushTargetType_SecurityGroupName_Placeholder_MaxPastKeyCount 25631
#define OpcUaId_PubSubKeyPushTargetType_ApplicationUri 25634
#define OpcUaId_PubSubKeyPushTargetType_EndpointUrl 25635
#define OpcUaId_PubSubKeyPushTargetType_SecurityPolicyUri 25340
#define OpcUaId_PubSubKeyPushTargetType_UserTokenType 25636
#define OpcUaId_PubSubKeyPushTargetType_RequestedKeyCount 25637
#define OpcUaId_PubSubKeyPushTargetType_RetryInterval 25638
#define OpcUaId_PubSubKeyPushTargetType_LastPushExecutionTime 25639
#define OpcUaId_PubSubKeyPushTargetType_LastPushErrorTime 25640
#define OpcUaId_PubSubKeyPushTargetType_ConnectSecurityGroups_InputArguments 25642
#define OpcUaId_PubSubKeyPushTargetType_ConnectSecurityGroups_OutputArguments 25643
#define OpcUaId_PubSubKeyPushTargetType_DisconnectSecurityGroups_InputArguments 25645
#define OpcUaId_PubSubKeyPushTargetType_DisconnectSecurityGroups_OutputArguments 25646
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_InputArguments 25349
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget_OutputArguments 25350
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget_InputArguments 25352
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_InputArguments 25354
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder_OutputArguments 25355
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder_InputArguments 25357
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ApplicationUri 25648
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_EndpointUrl 25649
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_SecurityPolicyUri 25361
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_UserTokenType 25650
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RequestedKeyCount 25651
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_RetryInterval 25652
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushExecutionTime 25653
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_LastPushErrorTime 25654
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_InputArguments 25656
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups_OutputArguments 25657
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_InputArguments 25659
#define OpcUaId_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups_OutputArguments 25660
#define OpcUaId_PubSubKeyPushTargetFolderType_AddPushTarget_InputArguments 25367
#define OpcUaId_PubSubKeyPushTargetFolderType_AddPushTarget_OutputArguments 25368
#define OpcUaId_PubSubKeyPushTargetFolderType_RemovePushTarget_InputArguments 25370
#define OpcUaId_PubSubKeyPushTargetFolderType_AddPushTargetFolder_InputArguments 25372
#define OpcUaId_PubSubKeyPushTargetFolderType_AddPushTargetFolder_OutputArguments 25373
#define OpcUaId_PubSubKeyPushTargetFolderType_RemovePushTargetFolder_InputArguments 25375
#define OpcUaId_PublishSubscribeType_GetSecurityKeys_InputArguments 15213
#define OpcUaId_PublishSubscribeType_GetSecurityKeys_OutputArguments 15214
#define OpcUaId_PublishSubscribeType_GetSecurityGroup_InputArguments 15432
#define OpcUaId_PublishSubscribeType_GetSecurityGroup_OutputArguments 15433
#define OpcUaId_PublishSubscribeType_SecurityGroups_AddSecurityGroup_InputArguments 15436
#define OpcUaId_PublishSubscribeType_SecurityGroups_AddSecurityGroup_OutputArguments 15437
#define OpcUaId_PublishSubscribeType_SecurityGroups_RemoveSecurityGroup_InputArguments 15439
#define OpcUaId_PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_InputArguments 25387
#define OpcUaId_PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_OutputArguments 25388
#define OpcUaId_PublishSubscribeType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments 25390
#define OpcUaId_PublishSubscribeType_KeyPushTargets_AddPushTarget_InputArguments 25394
#define OpcUaId_PublishSubscribeType_KeyPushTargets_AddPushTarget_OutputArguments 25395
#define OpcUaId_PublishSubscribeType_KeyPushTargets_RemovePushTarget_InputArguments 25397
#define OpcUaId_PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_InputArguments 25399
#define OpcUaId_PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_OutputArguments 25400
#define OpcUaId_PublishSubscribeType_KeyPushTargets_RemovePushTargetFolder_InputArguments 25402
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_PublisherId 14418
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri 17292
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_Selections 17706
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_ConnectionProperties 17478
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface 15533
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_Selections 17503
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Status_State 14420
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel 18668
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation 18669
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active 18670
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification 18671
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel 18672
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError 18674
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Active 18675
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Classification 18676
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel 18677
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_SubError 18680
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError 18682
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active 18683
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification 18684
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel 18685
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod 18687
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active 18688
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification 18689
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 18690
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent 18692
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active 18693
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification 18694
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 18695
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError 18697
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active 18698
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification 18699
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 18700
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent 18702
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active 18703
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification 18704
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 18705
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod 18707
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active 18708
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification 18709
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 18710
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress 18713
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel 18714
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_InputArguments 16558
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_OutputArguments 16559
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_InputArguments 16561
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_OutputArguments 16571
#define OpcUaId_PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup_InputArguments 14425
#define OpcUaId_PublishSubscribeType_SetSecurityKeys_InputArguments 17297
#define OpcUaId_PublishSubscribeType_AddConnection_InputArguments 16599
#define OpcUaId_PublishSubscribeType_AddConnection_OutputArguments 16600
#define OpcUaId_PublishSubscribeType_RemoveConnection_InputArguments 14433
#define OpcUaId_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_InputArguments 14436
#define OpcUaId_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_OutputArguments 14437
#define OpcUaId_PublishSubscribeType_PublishedDataSets_AddPublishedEvents_InputArguments 14439
#define OpcUaId_PublishSubscribeType_PublishedDataSets_AddPublishedEvents_OutputArguments 14440
#define OpcUaId_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments 16611
#define OpcUaId_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments 16638
#define OpcUaId_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_InputArguments 16640
#define OpcUaId_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments 16641
#define OpcUaId_PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet_InputArguments 14442
#define OpcUaId_PublishSubscribeType_PublishedDataSets_AddDataSetFolder_InputArguments 16678
#define OpcUaId_PublishSubscribeType_PublishedDataSets_AddDataSetFolder_OutputArguments 16679
#define OpcUaId_PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder_InputArguments 16681
#define OpcUaId_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_InputArguments 24005
#define OpcUaId_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_OutputArguments 24006
#define OpcUaId_PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments 24008
#define OpcUaId_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_InputArguments 23638
#define OpcUaId_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_OutputArguments 23639
#define OpcUaId_PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder_InputArguments 23641
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_Size 25404
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_Writable 25405
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_UserWritable 25406
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_OpenCount 25407
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_Open_InputArguments 25412
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_Open_OutputArguments 25413
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_Close_InputArguments 25415
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_Read_InputArguments 25417
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_Read_OutputArguments 25418
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_Write_InputArguments 25420
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_GetPosition_InputArguments 25422
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_GetPosition_OutputArguments 25423
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_SetPosition_InputArguments 25425
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_ReserveIds_InputArguments 25427
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_ReserveIds_OutputArguments 25428
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_InputArguments 25430
#define OpcUaId_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_OutputArguments 25431
#define OpcUaId_PublishSubscribeType_Status_State 15845
#define OpcUaId_PublishSubscribeType_Diagnostics_DiagnosticsLevel 18716
#define OpcUaId_PublishSubscribeType_Diagnostics_TotalInformation 18717
#define OpcUaId_PublishSubscribeType_Diagnostics_TotalInformation_Active 18718
#define OpcUaId_PublishSubscribeType_Diagnostics_TotalInformation_Classification 18719
#define OpcUaId_PublishSubscribeType_Diagnostics_TotalInformation_DiagnosticsLevel 18720
#define OpcUaId_PublishSubscribeType_Diagnostics_TotalError 18722
#define OpcUaId_PublishSubscribeType_Diagnostics_TotalError_Active 18723
#define OpcUaId_PublishSubscribeType_Diagnostics_TotalError_Classification 18724
#define OpcUaId_PublishSubscribeType_Diagnostics_TotalError_DiagnosticsLevel 18725
#define OpcUaId_PublishSubscribeType_Diagnostics_SubError 18728
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateError 18730
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateError_Active 18731
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateError_Classification 18732
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateError_DiagnosticsLevel 18733
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod 18735
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Active 18736
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Classification 18737
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 18738
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent 18740
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Active 18741
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Classification 18742
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 18743
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError 18745
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Active 18746
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Classification 18747
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 18748
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent 18750
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Active 18751
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Classification 18752
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 18753
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod 18755
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Active 18756
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Classification 18757
#define OpcUaId_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 18758
#define OpcUaId_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters 18761
#define OpcUaId_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel 18762
#define OpcUaId_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders 18763
#define OpcUaId_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel 18764
#define OpcUaId_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters 18765
#define OpcUaId_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel 18766
#define OpcUaId_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders 18767
#define OpcUaId_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel 18768
#define OpcUaId_PublishSubscribeType_PubSubCapablities_MaxPubSubConnections 23643
#define OpcUaId_PublishSubscribeType_PubSubCapablities_MaxWriterGroups 23644
#define OpcUaId_PublishSubscribeType_PubSubCapablities_MaxReaderGroups 23645
#define OpcUaId_PublishSubscribeType_PubSubCapablities_MaxDataSetWriters 23646
#define OpcUaId_PublishSubscribeType_PubSubCapablities_MaxDataSetReaders 23647
#define OpcUaId_PublishSubscribeType_PubSubCapablities_MaxFieldsPerDataSet 23648
#define OpcUaId_PublishSubscribeType_DataSetClasses_DataSetName_Placeholder 24009
#define OpcUaId_PublishSubscribeType_SupportedTransportProfiles 17479
#define OpcUaId_PublishSubscribeType_DefaultDatagramPublisherId 25432
#define OpcUaId_PublishSubscribeType_ConfigurationVersion 25433
#define OpcUaId_PublishSubscribeType_DefaultSecurityKeyServices 32396
#define OpcUaId_PublishSubscribeType_ConfigurationProperties 32397
#define OpcUaId_PublishSubscribe_GetSecurityKeys_InputArguments 15216
#define OpcUaId_PublishSubscribe_GetSecurityKeys_OutputArguments 15217
#define OpcUaId_PublishSubscribe_GetSecurityGroup_InputArguments 15441
#define OpcUaId_PublishSubscribe_GetSecurityGroup_OutputArguments 15442
#define OpcUaId_PublishSubscribe_SecurityGroups_AddSecurityGroup_InputArguments 15445
#define OpcUaId_PublishSubscribe_SecurityGroups_AddSecurityGroup_OutputArguments 15446
#define OpcUaId_PublishSubscribe_SecurityGroups_RemoveSecurityGroup_InputArguments 15448
#define OpcUaId_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_InputArguments 25435
#define OpcUaId_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_OutputArguments 25436
#define OpcUaId_PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder_InputArguments 25438
#define OpcUaId_PublishSubscribe_KeyPushTargets_AddPushTarget_InputArguments 25442
#define OpcUaId_PublishSubscribe_KeyPushTargets_AddPushTarget_OutputArguments 25443
#define OpcUaId_PublishSubscribe_KeyPushTargets_RemovePushTarget_InputArguments 25445
#define OpcUaId_PublishSubscribe_KeyPushTargets_AddPushTargetFolder_InputArguments 25447
#define OpcUaId_PublishSubscribe_KeyPushTargets_AddPushTargetFolder_OutputArguments 25448
#define OpcUaId_PublishSubscribe_KeyPushTargets_RemovePushTargetFolder_InputArguments 25450
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_PublisherId 15791
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri 15792
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_Selections 15848
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_ConnectionProperties 17480
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface 15863
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_Selections 17506
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Status_State 15892
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel 15938
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation 15939
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active 15989
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification 15994
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel 16013
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError 16059
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Active 16060
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Classification 16061
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel 16074
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_SubError 16101
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError 16103
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active 16122
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification 16123
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel 16124
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod 16283
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active 16322
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification 16523
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 17300
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent 17304
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active 17305
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification 17320
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 17335
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError 17337
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active 17338
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification 17339
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 17340
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent 17342
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active 17343
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification 17344
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 17345
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod 17347
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active 17348
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification 17349
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 17350
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress 17353
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel 17354
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_InputArguments 17357
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_OutputArguments 17358
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_InputArguments 17360
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_OutputArguments 17361
#define OpcUaId_PublishSubscribe_ConnectionName_Placeholder_RemoveGroup_InputArguments 17363
#define OpcUaId_PublishSubscribe_SetSecurityKeys_InputArguments 17365
#define OpcUaId_PublishSubscribe_AddConnection_InputArguments 17367
#define OpcUaId_PublishSubscribe_AddConnection_OutputArguments 17368
#define OpcUaId_PublishSubscribe_RemoveConnection_InputArguments 17370
#define OpcUaId_PublishSubscribe_PublishedDataSets_AddPublishedDataItems_InputArguments 17373
#define OpcUaId_PublishSubscribe_PublishedDataSets_AddPublishedDataItems_OutputArguments 17374
#define OpcUaId_PublishSubscribe_PublishedDataSets_AddPublishedEvents_InputArguments 17376
#define OpcUaId_PublishSubscribe_PublishedDataSets_AddPublishedEvents_OutputArguments 17377
#define OpcUaId_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments 17379
#define OpcUaId_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments 17380
#define OpcUaId_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_InputArguments 17382
#define OpcUaId_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments 17383
#define OpcUaId_PublishSubscribe_PublishedDataSets_RemovePublishedDataSet_InputArguments 17385
#define OpcUaId_PublishSubscribe_PublishedDataSets_AddDataSetFolder_InputArguments 17401
#define OpcUaId_PublishSubscribe_PublishedDataSets_AddDataSetFolder_OutputArguments 17402
#define OpcUaId_PublishSubscribe_PublishedDataSets_RemoveDataSetFolder_InputArguments 17404
#define OpcUaId_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_InputArguments 24011
#define OpcUaId_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_OutputArguments 24012
#define OpcUaId_PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments 24014
#define OpcUaId_PublishSubscribe_SubscribedDataSets_AddDataSetFolder_InputArguments 23674
#define OpcUaId_PublishSubscribe_SubscribedDataSets_AddDataSetFolder_OutputArguments 23675
#define OpcUaId_PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder_InputArguments 23677
#define OpcUaId_PublishSubscribe_PubSubConfiguration_Size 25452
#define OpcUaId_PublishSubscribe_PubSubConfiguration_Writable 25453
#define OpcUaId_PublishSubscribe_PubSubConfiguration_UserWritable 25454
#define OpcUaId_PublishSubscribe_PubSubConfiguration_OpenCount 25455
#define OpcUaId_PublishSubscribe_PubSubConfiguration_Open_InputArguments 25460
#define OpcUaId_PublishSubscribe_PubSubConfiguration_Open_OutputArguments 25461
#define OpcUaId_PublishSubscribe_PubSubConfiguration_Close_InputArguments 25463
#define OpcUaId_PublishSubscribe_PubSubConfiguration_Read_InputArguments 25465
#define OpcUaId_PublishSubscribe_PubSubConfiguration_Read_OutputArguments 25466
#define OpcUaId_PublishSubscribe_PubSubConfiguration_Write_InputArguments 25468
#define OpcUaId_PublishSubscribe_PubSubConfiguration_GetPosition_InputArguments 25470
#define OpcUaId_PublishSubscribe_PubSubConfiguration_GetPosition_OutputArguments 25471
#define OpcUaId_PublishSubscribe_PubSubConfiguration_SetPosition_InputArguments 25473
#define OpcUaId_PublishSubscribe_PubSubConfiguration_ReserveIds_InputArguments 25475
#define OpcUaId_PublishSubscribe_PubSubConfiguration_ReserveIds_OutputArguments 25476
#define OpcUaId_PublishSubscribe_PubSubConfiguration_CloseAndUpdate_InputArguments 25478
#define OpcUaId_PublishSubscribe_PubSubConfiguration_CloseAndUpdate_OutputArguments 25479
#define OpcUaId_PublishSubscribe_Status_State 17406
#define OpcUaId_PublishSubscribe_Diagnostics_DiagnosticsLevel 17410
#define OpcUaId_PublishSubscribe_Diagnostics_TotalInformation 17411
#define OpcUaId_PublishSubscribe_Diagnostics_TotalInformation_Active 17412
#define OpcUaId_PublishSubscribe_Diagnostics_TotalInformation_Classification 17413
#define OpcUaId_PublishSubscribe_Diagnostics_TotalInformation_DiagnosticsLevel 17414
#define OpcUaId_PublishSubscribe_Diagnostics_TotalError 17416
#define OpcUaId_PublishSubscribe_Diagnostics_TotalError_Active 17417
#define OpcUaId_PublishSubscribe_Diagnostics_TotalError_Classification 17418
#define OpcUaId_PublishSubscribe_Diagnostics_TotalError_DiagnosticsLevel 17419
#define OpcUaId_PublishSubscribe_Diagnostics_SubError 17422
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateError 17424
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateError_Active 17425
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateError_Classification 17426
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateError_DiagnosticsLevel 17429
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod 17431
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Active 17432
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Classification 17433
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 17434
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent 17436
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Active 17437
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Classification 17438
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 17439
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError 17441
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Active 17442
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Classification 17443
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 17444
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StatePausedByParent 17446
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Active 17447
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Classification 17448
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 17449
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod 17451
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Active 17452
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Classification 17453
#define OpcUaId_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 17454
#define OpcUaId_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters 17458
#define OpcUaId_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel 17459
#define OpcUaId_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders 17460
#define OpcUaId_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel 17461
#define OpcUaId_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters 17462
#define OpcUaId_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel 17463
#define OpcUaId_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders 17464
#define OpcUaId_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel 17466
#define OpcUaId_PublishSubscribe_PubSubCapablities_MaxPubSubConnections 23679
#define OpcUaId_PublishSubscribe_PubSubCapablities_MaxWriterGroups 23680
#define OpcUaId_PublishSubscribe_PubSubCapablities_MaxReaderGroups 23681
#define OpcUaId_PublishSubscribe_PubSubCapablities_MaxDataSetWriters 23682
#define OpcUaId_PublishSubscribe_PubSubCapablities_MaxDataSetReaders 23683
#define OpcUaId_PublishSubscribe_PubSubCapablities_MaxFieldsPerDataSet 23684
#define OpcUaId_PublishSubscribe_SupportedTransportProfiles 17481
#define OpcUaId_PublishSubscribe_DefaultDatagramPublisherId 25480
#define OpcUaId_PublishSubscribe_ConfigurationVersion 25481
#define OpcUaId_PublishSubscribe_DefaultSecurityKeyServices 32403
#define OpcUaId_PublishSubscribe_ConfigurationProperties 32404
#define OpcUaId_DataSetClasses_GetSecurityKeys_InputArguments 32407
#define OpcUaId_DataSetClasses_GetSecurityKeys_OutputArguments 32408
#define OpcUaId_DataSetClasses_GetSecurityGroup_InputArguments 32410
#define OpcUaId_DataSetClasses_GetSecurityGroup_OutputArguments 32411
#define OpcUaId_DataSetClasses_SecurityGroups_AddSecurityGroup_InputArguments 32414
#define OpcUaId_DataSetClasses_SecurityGroups_AddSecurityGroup_OutputArguments 32415
#define OpcUaId_DataSetClasses_SecurityGroups_RemoveSecurityGroup_InputArguments 32417
#define OpcUaId_DataSetClasses_SecurityGroups_AddSecurityGroupFolder_InputArguments 32419
#define OpcUaId_DataSetClasses_SecurityGroups_AddSecurityGroupFolder_OutputArguments 32420
#define OpcUaId_DataSetClasses_SecurityGroups_RemoveSecurityGroupFolder_InputArguments 32422
#define OpcUaId_DataSetClasses_KeyPushTargets_AddPushTarget_InputArguments 32426
#define OpcUaId_DataSetClasses_KeyPushTargets_AddPushTarget_OutputArguments 32427
#define OpcUaId_DataSetClasses_KeyPushTargets_RemovePushTarget_InputArguments 32429
#define OpcUaId_DataSetClasses_KeyPushTargets_AddPushTargetFolder_InputArguments 32431
#define OpcUaId_DataSetClasses_KeyPushTargets_AddPushTargetFolder_OutputArguments 32432
#define OpcUaId_DataSetClasses_KeyPushTargets_RemovePushTargetFolder_InputArguments 32434
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_PublisherId 32436
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_TransportProfileUri 32437
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_TransportProfileUri_Selections 32438
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_ConnectionProperties 32441
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Address_NetworkInterface 32443
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Address_NetworkInterface_Selections 32444
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Status_State 32449
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel 32453
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_TotalInformation 32454
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active 32455
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification 32456
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel 32457
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_TotalError 32459
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_TotalError_Active 32460
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_TotalError_Classification 32461
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel 32462
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_SubError 32465
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateError 32467
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active 32468
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification 32469
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel 32470
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod 32472
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active 32473
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification 32474
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 32475
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent 32477
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active 32478
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification 32479
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 32480
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError 32482
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active 32483
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification 32484
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 32485
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent 32487
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active 32488
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification 32489
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 32490
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod 32492
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active 32493
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification 32494
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 32495
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress 32498
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel 32499
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_AddWriterGroup_InputArguments 32501
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_AddWriterGroup_OutputArguments 32502
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_AddReaderGroup_InputArguments 32504
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_AddReaderGroup_OutputArguments 32505
#define OpcUaId_DataSetClasses_ConnectionName_Placeholder_RemoveGroup_InputArguments 32507
#define OpcUaId_DataSetClasses_SetSecurityKeys_InputArguments 32509
#define OpcUaId_DataSetClasses_AddConnection_InputArguments 32511
#define OpcUaId_DataSetClasses_AddConnection_OutputArguments 32512
#define OpcUaId_DataSetClasses_RemoveConnection_InputArguments 32514
#define OpcUaId_DataSetClasses_PublishedDataSets_AddPublishedDataItems_InputArguments 32517
#define OpcUaId_DataSetClasses_PublishedDataSets_AddPublishedDataItems_OutputArguments 32518
#define OpcUaId_DataSetClasses_PublishedDataSets_AddPublishedEvents_InputArguments 32520
#define OpcUaId_DataSetClasses_PublishedDataSets_AddPublishedEvents_OutputArguments 32521
#define OpcUaId_DataSetClasses_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments 32523
#define OpcUaId_DataSetClasses_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments 32524
#define OpcUaId_DataSetClasses_PublishedDataSets_AddPublishedEventsTemplate_InputArguments 32526
#define OpcUaId_DataSetClasses_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments 32527
#define OpcUaId_DataSetClasses_PublishedDataSets_RemovePublishedDataSet_InputArguments 32529
#define OpcUaId_DataSetClasses_PublishedDataSets_AddDataSetFolder_InputArguments 32531
#define OpcUaId_DataSetClasses_PublishedDataSets_AddDataSetFolder_OutputArguments 32532
#define OpcUaId_DataSetClasses_PublishedDataSets_RemoveDataSetFolder_InputArguments 32534
#define OpcUaId_DataSetClasses_SubscribedDataSets_AddSubscribedDataSet_InputArguments 32537
#define OpcUaId_DataSetClasses_SubscribedDataSets_AddSubscribedDataSet_OutputArguments 32538
#define OpcUaId_DataSetClasses_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments 32540
#define OpcUaId_DataSetClasses_SubscribedDataSets_AddDataSetFolder_InputArguments 32542
#define OpcUaId_DataSetClasses_SubscribedDataSets_AddDataSetFolder_OutputArguments 32543
#define OpcUaId_DataSetClasses_SubscribedDataSets_RemoveDataSetFolder_InputArguments 32545
#define OpcUaId_DataSetClasses_PubSubConfiguration_Size 32547
#define OpcUaId_DataSetClasses_PubSubConfiguration_Writable 32548
#define OpcUaId_DataSetClasses_PubSubConfiguration_UserWritable 32549
#define OpcUaId_DataSetClasses_PubSubConfiguration_OpenCount 32550
#define OpcUaId_DataSetClasses_PubSubConfiguration_Open_InputArguments 32555
#define OpcUaId_DataSetClasses_PubSubConfiguration_Open_OutputArguments 32556
#define OpcUaId_DataSetClasses_PubSubConfiguration_Close_InputArguments 32558
#define OpcUaId_DataSetClasses_PubSubConfiguration_Read_InputArguments 32560
#define OpcUaId_DataSetClasses_PubSubConfiguration_Read_OutputArguments 32561
#define OpcUaId_DataSetClasses_PubSubConfiguration_Write_InputArguments 32563
#define OpcUaId_DataSetClasses_PubSubConfiguration_GetPosition_InputArguments 32565
#define OpcUaId_DataSetClasses_PubSubConfiguration_GetPosition_OutputArguments 32566
#define OpcUaId_DataSetClasses_PubSubConfiguration_SetPosition_InputArguments 32568
#define OpcUaId_DataSetClasses_PubSubConfiguration_ReserveIds_InputArguments 32570
#define OpcUaId_DataSetClasses_PubSubConfiguration_ReserveIds_OutputArguments 32571
#define OpcUaId_DataSetClasses_PubSubConfiguration_CloseAndUpdate_InputArguments 32573
#define OpcUaId_DataSetClasses_PubSubConfiguration_CloseAndUpdate_OutputArguments 32574
#define OpcUaId_DataSetClasses_Status_State 32576
#define OpcUaId_DataSetClasses_Diagnostics_DiagnosticsLevel 32580
#define OpcUaId_DataSetClasses_Diagnostics_TotalInformation 32581
#define OpcUaId_DataSetClasses_Diagnostics_TotalInformation_Active 32582
#define OpcUaId_DataSetClasses_Diagnostics_TotalInformation_Classification 32583
#define OpcUaId_DataSetClasses_Diagnostics_TotalInformation_DiagnosticsLevel 32584
#define OpcUaId_DataSetClasses_Diagnostics_TotalError 32586
#define OpcUaId_DataSetClasses_Diagnostics_TotalError_Active 32587
#define OpcUaId_DataSetClasses_Diagnostics_TotalError_Classification 32588
#define OpcUaId_DataSetClasses_Diagnostics_TotalError_DiagnosticsLevel 32589
#define OpcUaId_DataSetClasses_Diagnostics_SubError 32592
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateError 32594
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateError_Active 32595
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateError_Classification 32596
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateError_DiagnosticsLevel 32597
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateOperationalByMethod 32599
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateOperationalByMethod_Active 32600
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateOperationalByMethod_Classification 32601
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 32602
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateOperationalByParent 32604
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateOperationalByParent_Active 32605
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateOperationalByParent_Classification 32606
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 32607
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateOperationalFromError 32609
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateOperationalFromError_Active 32610
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateOperationalFromError_Classification 32611
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 32612
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StatePausedByParent 32614
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StatePausedByParent_Active 32615
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StatePausedByParent_Classification 32616
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 32617
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateDisabledByMethod 32619
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateDisabledByMethod_Active 32620
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateDisabledByMethod_Classification 32621
#define OpcUaId_DataSetClasses_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 32622
#define OpcUaId_DataSetClasses_Diagnostics_LiveValues_ConfiguredDataSetWriters 32625
#define OpcUaId_DataSetClasses_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel 32626
#define OpcUaId_DataSetClasses_Diagnostics_LiveValues_ConfiguredDataSetReaders 32627
#define OpcUaId_DataSetClasses_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel 32628
#define OpcUaId_DataSetClasses_Diagnostics_LiveValues_OperationalDataSetWriters 32629
#define OpcUaId_DataSetClasses_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel 32630
#define OpcUaId_DataSetClasses_Diagnostics_LiveValues_OperationalDataSetReaders 32631
#define OpcUaId_DataSetClasses_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel 32632
#define OpcUaId_DataSetClasses_PubSubCapablities_MaxPubSubConnections 32634
#define OpcUaId_DataSetClasses_PubSubCapablities_MaxWriterGroups 32635
#define OpcUaId_DataSetClasses_PubSubCapablities_MaxReaderGroups 32636
#define OpcUaId_DataSetClasses_PubSubCapablities_MaxDataSetWriters 32637
#define OpcUaId_DataSetClasses_PubSubCapablities_MaxDataSetReaders 32638
#define OpcUaId_DataSetClasses_PubSubCapablities_MaxFieldsPerDataSet 32656
#define OpcUaId_DataSetClasses_SupportedTransportProfiles 32646
#define OpcUaId_DataSetClasses_DefaultDatagramPublisherId 32647
#define OpcUaId_DataSetClasses_ConfigurationVersion 32648
#define OpcUaId_PubSubConfigurationType_Open_InputArguments 25491
#define OpcUaId_PubSubConfigurationType_Open_OutputArguments 25492
#define OpcUaId_PubSubConfigurationType_Close_InputArguments 25494
#define OpcUaId_PubSubConfigurationType_Read_InputArguments 25496
#define OpcUaId_PubSubConfigurationType_Read_OutputArguments 25497
#define OpcUaId_PubSubConfigurationType_Write_InputArguments 25499
#define OpcUaId_PubSubConfigurationType_GetPosition_InputArguments 25501
#define OpcUaId_PubSubConfigurationType_GetPosition_OutputArguments 25502
#define OpcUaId_PubSubConfigurationType_SetPosition_InputArguments 25504
#define OpcUaId_PubSubConfigurationType_ReserveIds_InputArguments 25506
#define OpcUaId_PubSubConfigurationType_ReserveIds_OutputArguments 25507
#define OpcUaId_PubSubConfigurationType_CloseAndUpdate_InputArguments 25509
#define OpcUaId_PubSubConfigurationType_CloseAndUpdate_OutputArguments 25510
#define OpcUaId_PubSubConfigurationRefMask_OptionSetValues 25518
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterId 16720
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask 16721
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterProperties 17482
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Status_State 15224
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel 18872
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation 18873
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active 18874
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification 18875
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel 18876
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError 18878
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active 18879
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification 18880
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel 18881
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_SubError 18884
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError 18886
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active 18887
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification 18888
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel 18889
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod 18891
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active 18892
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification 18893
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 18894
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent 18896
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active 18897
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification 18898
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 18899
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError 18901
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active 18902
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification 18903
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 18904
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent 18906
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active 18907
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification 18908
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 18909
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod 18911
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active 18912
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification 18913
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 18914
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages 18917
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active 18918
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification 18919
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel 18920
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel 18923
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel 18925
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel 18927
#define OpcUaId_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel 18929
#define OpcUaId_PublishedDataSetType_ConfigurationVersion 14519
#define OpcUaId_PublishedDataSetType_DataSetMetaData 15229
#define OpcUaId_PublishedDataSetType_DataSetClassId 16759
#define OpcUaId_PublishedDataSetType_CyclicDataSet 25521
#define OpcUaId_PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments 15483
#define OpcUaId_PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments 15484
#define OpcUaId_PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments 15486
#define OpcUaId_ExtensionFieldsType_ExtensionFieldName_Placeholder 15490
#define OpcUaId_ExtensionFieldsType_AddExtensionField_InputArguments 15492
#define OpcUaId_ExtensionFieldsType_AddExtensionField_OutputArguments 15493
#define OpcUaId_ExtensionFieldsType_RemoveExtensionField_InputArguments 15495
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterId 16760
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetFieldContentMask 16761
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterProperties 17483
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Status_State 15232
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel 18931
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation 18932
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active 18933
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification 18934
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel 18935
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError 18937
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active 18938
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification 18939
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel 18940
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_SubError 18943
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError 18945
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active 18946
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification 18947
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel 18948
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod 18950
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active 18951
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification 18952
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 18953
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent 18955
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active 18956
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification 18957
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 18958
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError 18960
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active 18961
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification 18962
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 18963
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent 18965
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active 18966
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification 18967
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 18968
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod 18970
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active 18971
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification 18972
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 18973
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages 18976
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active 18977
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification 18978
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel 18979
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel 18982
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel 18984
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel 18986
#define OpcUaId_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel 18988
#define OpcUaId_PublishedDataItemsType_ExtensionFields_AddExtensionField_InputArguments 15505
#define OpcUaId_PublishedDataItemsType_ExtensionFields_AddExtensionField_OutputArguments 15506
#define OpcUaId_PublishedDataItemsType_ExtensionFields_RemoveExtensionField_InputArguments 15508
#define OpcUaId_PublishedDataItemsType_PublishedData 14548
#define OpcUaId_PublishedDataItemsType_AddVariables_InputArguments 14556
#define OpcUaId_PublishedDataItemsType_AddVariables_OutputArguments 14557
#define OpcUaId_PublishedDataItemsType_RemoveVariables_InputArguments 14559
#define OpcUaId_PublishedDataItemsType_RemoveVariables_OutputArguments 14560
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterId 16801
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_DataSetFieldContentMask 16802
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterProperties 17484
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Status_State 15240
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel 18990
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation 18991
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active 18992
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification 18993
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel 18994
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError 18996
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active 18997
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification 18998
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel 18999
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_SubError 19002
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError 19004
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active 19005
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification 19006
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel 19007
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod 19009
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active 19010
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification 19011
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 19012
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent 19014
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active 19015
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification 19016
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 19017
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError 19019
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active 19020
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification 19021
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 19022
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent 19024
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active 19025
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification 19026
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 19027
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod 19029
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active 19030
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification 19031
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 19032
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages 19035
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active 19036
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification 19037
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel 19038
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel 19041
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel 19043
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel 19045
#define OpcUaId_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel 19047
#define OpcUaId_PublishedEventsType_ExtensionFields_AddExtensionField_InputArguments 15513
#define OpcUaId_PublishedEventsType_ExtensionFields_AddExtensionField_OutputArguments 15514
#define OpcUaId_PublishedEventsType_ExtensionFields_RemoveExtensionField_InputArguments 15516
#define OpcUaId_PublishedEventsType_PubSubEventNotifier 14586
#define OpcUaId_PublishedEventsType_SelectedFields 14587
#define OpcUaId_PublishedEventsType_Filter 14588
#define OpcUaId_PublishedEventsType_ModifyFieldSelection_InputArguments 15053
#define OpcUaId_PublishedEventsType_ModifyFieldSelection_OutputArguments 15517
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems_InputArguments 14480
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems_OutputArguments 14481
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents_InputArguments 14483
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents_OutputArguments 14484
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate_InputArguments 16843
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate_OutputArguments 16853
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate_InputArguments 16882
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate_OutputArguments 16883
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet_InputArguments 14486
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder_InputArguments 16894
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder_OutputArguments 16922
#define OpcUaId_DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder_InputArguments 16924
#define OpcUaId_DataSetFolderType_PublishedDataSetName_Placeholder_ConfigurationVersion 14489
#define OpcUaId_DataSetFolderType_PublishedDataSetName_Placeholder_DataSetMetaData 15221
#define OpcUaId_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField_InputArguments 15475
#define OpcUaId_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField_OutputArguments 15476
#define OpcUaId_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField_InputArguments 15478
#define OpcUaId_DataSetFolderType_AddPublishedDataItems_InputArguments 14494
#define OpcUaId_DataSetFolderType_AddPublishedDataItems_OutputArguments 14495
#define OpcUaId_DataSetFolderType_AddPublishedEvents_InputArguments 14497
#define OpcUaId_DataSetFolderType_AddPublishedEvents_OutputArguments 14498
#define OpcUaId_DataSetFolderType_AddPublishedDataItemsTemplate_InputArguments 16958
#define OpcUaId_DataSetFolderType_AddPublishedDataItemsTemplate_OutputArguments 16959
#define OpcUaId_DataSetFolderType_AddPublishedEventsTemplate_InputArguments 16961
#define OpcUaId_DataSetFolderType_AddPublishedEventsTemplate_OutputArguments 16971
#define OpcUaId_DataSetFolderType_RemovePublishedDataSet_InputArguments 14500
#define OpcUaId_DataSetFolderType_AddDataSetFolder_InputArguments 16995
#define OpcUaId_DataSetFolderType_AddDataSetFolder_OutputArguments 16996
#define OpcUaId_DataSetFolderType_RemoveDataSetFolder_InputArguments 17007
#define OpcUaId_PubSubConnectionType_PublisherId 14595
#define OpcUaId_PubSubConnectionType_TransportProfileUri 17306
#define OpcUaId_PubSubConnectionType_TransportProfileUri_Selections 17710
#define OpcUaId_PubSubConnectionType_ConnectionProperties 17485
#define OpcUaId_PubSubConnectionType_Address_NetworkInterface 17202
#define OpcUaId_PubSubConnectionType_Address_NetworkInterface_Selections 17576
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_SecurityMode 17311
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_MaxNetworkMessageSize 17204
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_GroupProperties 17486
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Status_State 17315
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_WriterGroupId 17214
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_PublishingInterval 17318
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_KeepAliveTime 17319
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Priority 17321
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_LocaleIds 17322
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_HeaderLayoutUri 17558
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_DiagnosticsLevel 19108
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation 19109
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Active 19110
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Classification 19111
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel 19112
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError 19114
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Active 19115
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Classification 19116
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel 19117
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_SubError 19120
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError 19122
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Active 19123
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Classification 19124
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel 19125
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod 19127
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active 19128
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification 19129
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 19130
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent 19132
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active 19133
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification 19134
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 19135
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError 19137
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active 19138
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification 19139
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 19140
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent 19142
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active 19143
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification 19144
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 19145
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod 19147
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active 19148
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification 19149
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 19150
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages 19153
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Active 19154
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Classification 19155
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel 19156
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions 19158
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Active 19159
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Classification 19160
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel 19161
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors 19163
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Active 19164
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Classification 19165
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel 19166
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters 19168
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel 19169
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters 19170
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel 19171
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel 19173
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel 19175
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_InputArguments 17294
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_OutputArguments 17301
#define OpcUaId_PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter_InputArguments 17324
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_SecurityMode 17326
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_MaxNetworkMessageSize 17302
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_GroupProperties 17487
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Status_State 17330
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_DiagnosticsLevel 19177
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation 19178
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Active 19179
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Classification 19180
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel 19181
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError 19183
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Active 19184
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Classification 19185
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel 19186
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_SubError 19189
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError 19191
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Active 19192
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Classification 19193
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel 19194
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod 19196
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active 19197
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification 19198
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 19199
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent 19201
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active 19202
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification 19203
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 19204
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError 19206
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active 19207
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification 19208
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 19209
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent 19211
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active 19212
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification 19213
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 19214
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod 19216
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active 19217
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification 19218
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 19219
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages 19222
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Active 19223
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Classification 19224
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel 19225
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active 19228
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification 19229
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel 19230
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active 19233
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification 19234
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel 19235
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders 19237
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel 19238
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders 19239
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel 19240
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_InputArguments 17399
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_OutputArguments 17400
#define OpcUaId_PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader_InputArguments 17334
#define OpcUaId_PubSubConnectionType_Status_State 14601
#define OpcUaId_PubSubConnectionType_Diagnostics_DiagnosticsLevel 19242
#define OpcUaId_PubSubConnectionType_Diagnostics_TotalInformation 19243
#define OpcUaId_PubSubConnectionType_Diagnostics_TotalInformation_Active 19244
#define OpcUaId_PubSubConnectionType_Diagnostics_TotalInformation_Classification 19245
#define OpcUaId_PubSubConnectionType_Diagnostics_TotalInformation_DiagnosticsLevel 19246
#define OpcUaId_PubSubConnectionType_Diagnostics_TotalError 19248
#define OpcUaId_PubSubConnectionType_Diagnostics_TotalError_Active 19249
#define OpcUaId_PubSubConnectionType_Diagnostics_TotalError_Classification 19250
#define OpcUaId_PubSubConnectionType_Diagnostics_TotalError_DiagnosticsLevel 19251
#define OpcUaId_PubSubConnectionType_Diagnostics_SubError 19254
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateError 19256
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateError_Active 19257
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateError_Classification 19258
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateError_DiagnosticsLevel 19259
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod 19261
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Active 19262
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Classification 19263
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 19264
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent 19266
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Active 19267
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Classification 19268
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 19269
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError 19271
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Active 19272
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Classification 19273
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 19274
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent 19276
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Active 19277
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Classification 19278
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 19279
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod 19281
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Active 19282
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Classification 19283
#define OpcUaId_PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 19284
#define OpcUaId_PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress 19287
#define OpcUaId_PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel 19288
#define OpcUaId_PubSubConnectionType_AddWriterGroup_InputArguments 17428
#define OpcUaId_PubSubConnectionType_AddWriterGroup_OutputArguments 17456
#define OpcUaId_PubSubConnectionType_AddReaderGroup_InputArguments 17507
#define OpcUaId_PubSubConnectionType_AddReaderGroup_OutputArguments 17508
#define OpcUaId_PubSubConnectionType_RemoveGroup_InputArguments 14226
#define OpcUaId_PubSubGroupType_SecurityMode 15926
#define OpcUaId_PubSubGroupType_SecurityGroupId 15927
#define OpcUaId_PubSubGroupType_SecurityKeyServices 15928
#define OpcUaId_PubSubGroupType_MaxNetworkMessageSize 17724
#define OpcUaId_PubSubGroupType_GroupProperties 17488
#define OpcUaId_PubSubGroupType_Status_State 15266
#define OpcUaId_WriterGroupType_Status_State 17731
#define OpcUaId_WriterGroupType_WriterGroupId 17736
#define OpcUaId_WriterGroupType_PublishingInterval 17737
#define OpcUaId_WriterGroupType_KeepAliveTime 17738
#define OpcUaId_WriterGroupType_Priority 17739
#define OpcUaId_WriterGroupType_LocaleIds 17740
#define OpcUaId_WriterGroupType_HeaderLayoutUri 17559
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterId 17744
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_DataSetFieldContentMask 17745
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterProperties 17490
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Status_State 17750
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel 17754
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation 17755
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active 17756
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification 17757
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel 17758
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError 17760
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active 17761
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification 17762
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel 17763
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_SubError 17766
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError 17768
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active 17769
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification 17770
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel 17771
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod 17773
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active 17774
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification 17775
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 17776
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent 17778
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active 17779
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification 17780
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 17781
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError 17783
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active 17784
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification 17785
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 17786
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent 17788
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active 17789
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification 17790
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 17791
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod 17793
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active 17794
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification 17795
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 17796
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages 17799
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active 17800
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification 17801
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel 17802
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel 17805
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel 17807
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel 17809
#define OpcUaId_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel 17811
#define OpcUaId_WriterGroupType_Diagnostics_DiagnosticsLevel 17813
#define OpcUaId_WriterGroupType_Diagnostics_TotalInformation 17814
#define OpcUaId_WriterGroupType_Diagnostics_TotalInformation_Active 17815
#define OpcUaId_WriterGroupType_Diagnostics_TotalInformation_Classification 17816
#define OpcUaId_WriterGroupType_Diagnostics_TotalInformation_DiagnosticsLevel 17817
#define OpcUaId_WriterGroupType_Diagnostics_TotalError 17819
#define OpcUaId_WriterGroupType_Diagnostics_TotalError_Active 17820
#define OpcUaId_WriterGroupType_Diagnostics_TotalError_Classification 17821
#define OpcUaId_WriterGroupType_Diagnostics_TotalError_DiagnosticsLevel 17822
#define OpcUaId_WriterGroupType_Diagnostics_SubError 17825
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateError 17827
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateError_Active 17828
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateError_Classification 17829
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel 17830
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod 17832
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Active 17833
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification 17834
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 17835
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateOperationalByParent 17837
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Active 17838
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Classification 17839
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 17840
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateOperationalFromError 17842
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Active 17843
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Classification 17844
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 17845
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StatePausedByParent 17847
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StatePausedByParent_Active 17848
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StatePausedByParent_Classification 17849
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 17850
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod 17853
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Active 17854
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification 17855
#define OpcUaId_WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 17856
#define OpcUaId_WriterGroupType_Diagnostics_Counters_SentNetworkMessages 17859
#define OpcUaId_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Active 17864
#define OpcUaId_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Classification 17871
#define OpcUaId_WriterGroupType_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel 17872
#define OpcUaId_WriterGroupType_Diagnostics_Counters_FailedTransmissions 17874
#define OpcUaId_WriterGroupType_Diagnostics_Counters_FailedTransmissions_Active 17878
#define OpcUaId_WriterGroupType_Diagnostics_Counters_FailedTransmissions_Classification 17885
#define OpcUaId_WriterGroupType_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel 17892
#define OpcUaId_WriterGroupType_Diagnostics_Counters_EncryptionErrors 17900
#define OpcUaId_WriterGroupType_Diagnostics_Counters_EncryptionErrors_Active 17901
#define OpcUaId_WriterGroupType_Diagnostics_Counters_EncryptionErrors_Classification 17902
#define OpcUaId_WriterGroupType_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel 17903
#define OpcUaId_WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters 17913
#define OpcUaId_WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel 17920
#define OpcUaId_WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters 17927
#define OpcUaId_WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel 17934
#define OpcUaId_WriterGroupType_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel 17948
#define OpcUaId_WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel 17962
#define OpcUaId_WriterGroupType_AddDataSetWriter_InputArguments 17976
#define OpcUaId_WriterGroupType_AddDataSetWriter_OutputArguments 17987
#define OpcUaId_WriterGroupType_RemoveDataSetWriter_InputArguments 17993
#define OpcUaId_ReaderGroupType_Status_State 18068
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_PublisherId 18077
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_WriterGroupId 18078
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_DataSetWriterId 18079
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_DataSetMetaData 18080
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_DataSetFieldContentMask 18081
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_MessageReceiveTimeout 18082
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_KeyFrameCount 17560
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_HeaderLayoutUri 17562
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_DataSetReaderProperties 17492
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Status_State 18089
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_DiagnosticsLevel 18093
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation 18094
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Active 18095
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Classification 18096
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel 18097
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError 18099
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Active 18100
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Classification 18101
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel 18102
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_SubError 18105
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError 18107
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Active 18108
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Classification 18109
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel 18110
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod 18112
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active 18113
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification 18114
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 18115
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent 18117
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active 18118
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification 18119
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 18120
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError 18122
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active 18123
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification 18124
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 18125
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent 18127
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active 18128
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification 18129
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 18130
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod 18132
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active 18133
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification 18134
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 18135
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages 18138
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active 18139
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification 18140
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel 18141
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active 18144
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification 18145
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel 18146
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel 18149
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel 18151
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel 18153
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel 18158
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel 21003
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel 21005
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_InputArguments 21010
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_OutputArguments 21011
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_InputArguments 21013
#define OpcUaId_ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_OutputArguments 21014
#define OpcUaId_ReaderGroupType_Diagnostics_DiagnosticsLevel 21016
#define OpcUaId_ReaderGroupType_Diagnostics_TotalInformation 21017
#define OpcUaId_ReaderGroupType_Diagnostics_TotalInformation_Active 21018
#define OpcUaId_ReaderGroupType_Diagnostics_TotalInformation_Classification 21019
#define OpcUaId_ReaderGroupType_Diagnostics_TotalInformation_DiagnosticsLevel 21020
#define OpcUaId_ReaderGroupType_Diagnostics_TotalError 21022
#define OpcUaId_ReaderGroupType_Diagnostics_TotalError_Active 21023
#define OpcUaId_ReaderGroupType_Diagnostics_TotalError_Classification 21024
#define OpcUaId_ReaderGroupType_Diagnostics_TotalError_DiagnosticsLevel 21025
#define OpcUaId_ReaderGroupType_Diagnostics_SubError 21028
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateError 21030
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateError_Active 21031
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateError_Classification 21032
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel 21033
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod 21035
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Active 21036
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification 21037
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 21038
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent 21040
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Active 21041
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Classification 21042
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 21043
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError 21045
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Active 21046
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Classification 21047
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 21048
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StatePausedByParent 21050
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Active 21051
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Classification 21052
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 21053
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod 21055
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Active 21056
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification 21057
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 21058
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages 21061
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Active 21062
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Classification 21063
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel 21064
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active 21067
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification 21068
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel 21069
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Active 21072
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Classification 21073
#define OpcUaId_ReaderGroupType_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel 21074
#define OpcUaId_ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders 21076
#define OpcUaId_ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel 21077
#define OpcUaId_ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders 21078
#define OpcUaId_ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel 21079
#define OpcUaId_ReaderGroupType_AddDataSetReader_InputArguments 21083
#define OpcUaId_ReaderGroupType_AddDataSetReader_OutputArguments 21084
#define OpcUaId_ReaderGroupType_RemoveDataSetReader_InputArguments 21086
#define OpcUaId_DataSetWriterType_DataSetWriterId 21092
#define OpcUaId_DataSetWriterType_DataSetFieldContentMask 21093
#define OpcUaId_DataSetWriterType_KeyFrameCount 21094
#define OpcUaId_DataSetWriterType_DataSetWriterProperties 17493
#define OpcUaId_DataSetWriterType_Status_State 15300
#define OpcUaId_DataSetWriterType_Diagnostics_DiagnosticsLevel 19551
#define OpcUaId_DataSetWriterType_Diagnostics_TotalInformation 19552
#define OpcUaId_DataSetWriterType_Diagnostics_TotalInformation_Active 19553
#define OpcUaId_DataSetWriterType_Diagnostics_TotalInformation_Classification 19554
#define OpcUaId_DataSetWriterType_Diagnostics_TotalInformation_DiagnosticsLevel 19555
#define OpcUaId_DataSetWriterType_Diagnostics_TotalError 19557
#define OpcUaId_DataSetWriterType_Diagnostics_TotalError_Active 19558
#define OpcUaId_DataSetWriterType_Diagnostics_TotalError_Classification 19559
#define OpcUaId_DataSetWriterType_Diagnostics_TotalError_DiagnosticsLevel 19560
#define OpcUaId_DataSetWriterType_Diagnostics_SubError 19563
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateError 19565
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateError_Active 19566
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateError_Classification 19567
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateError_DiagnosticsLevel 19568
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateOperationalByMethod 19570
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateOperationalByMethod_Active 19571
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateOperationalByMethod_Classification 19572
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 19573
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateOperationalByParent 19575
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateOperationalByParent_Active 19576
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateOperationalByParent_Classification 19577
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 19578
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateOperationalFromError 19580
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateOperationalFromError_Active 19581
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateOperationalFromError_Classification 19582
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 19583
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StatePausedByParent 19585
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StatePausedByParent_Active 19586
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StatePausedByParent_Classification 19587
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 19588
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateDisabledByMethod 19590
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateDisabledByMethod_Active 19591
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateDisabledByMethod_Classification 19592
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 19593
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_FailedDataSetMessages 19596
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_FailedDataSetMessages_Active 19597
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_FailedDataSetMessages_Classification 19598
#define OpcUaId_DataSetWriterType_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel 19599
#define OpcUaId_DataSetWriterType_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel 19602
#define OpcUaId_DataSetWriterType_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel 19604
#define OpcUaId_DataSetWriterType_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel 19606
#define OpcUaId_DataSetWriterType_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel 19608
#define OpcUaId_DataSetReaderType_PublisherId 21097
#define OpcUaId_DataSetReaderType_WriterGroupId 21098
#define OpcUaId_DataSetReaderType_DataSetWriterId 21099
#define OpcUaId_DataSetReaderType_DataSetMetaData 21100
#define OpcUaId_DataSetReaderType_DataSetFieldContentMask 21101
#define OpcUaId_DataSetReaderType_MessageReceiveTimeout 21102
#define OpcUaId_DataSetReaderType_KeyFrameCount 17563
#define OpcUaId_DataSetReaderType_HeaderLayoutUri 17564
#define OpcUaId_DataSetReaderType_SecurityMode 15932
#define OpcUaId_DataSetReaderType_SecurityGroupId 15933
#define OpcUaId_DataSetReaderType_SecurityKeyServices 15934
#define OpcUaId_DataSetReaderType_DataSetReaderProperties 17494
#define OpcUaId_DataSetReaderType_Status_State 15308
#define OpcUaId_DataSetReaderType_Diagnostics_DiagnosticsLevel 19610
#define OpcUaId_DataSetReaderType_Diagnostics_TotalInformation 19611
#define OpcUaId_DataSetReaderType_Diagnostics_TotalInformation_Active 19612
#define OpcUaId_DataSetReaderType_Diagnostics_TotalInformation_Classification 19613
#define OpcUaId_DataSetReaderType_Diagnostics_TotalInformation_DiagnosticsLevel 19614
#define OpcUaId_DataSetReaderType_Diagnostics_TotalError 19616
#define OpcUaId_DataSetReaderType_Diagnostics_TotalError_Active 19617
#define OpcUaId_DataSetReaderType_Diagnostics_TotalError_Classification 19618
#define OpcUaId_DataSetReaderType_Diagnostics_TotalError_DiagnosticsLevel 19619
#define OpcUaId_DataSetReaderType_Diagnostics_SubError 19622
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateError 19624
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateError_Active 19625
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateError_Classification 19626
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateError_DiagnosticsLevel 19627
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateOperationalByMethod 19629
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateOperationalByMethod_Active 19630
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateOperationalByMethod_Classification 19631
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel 19632
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateOperationalByParent 19634
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateOperationalByParent_Active 19635
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateOperationalByParent_Classification 19636
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel 19637
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateOperationalFromError 19639
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateOperationalFromError_Active 19640
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateOperationalFromError_Classification 19641
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel 19642
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StatePausedByParent 19644
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StatePausedByParent_Active 19645
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StatePausedByParent_Classification 19646
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel 19647
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateDisabledByMethod 19649
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateDisabledByMethod_Active 19650
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateDisabledByMethod_Classification 19651
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel 19652
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_FailedDataSetMessages 19655
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_FailedDataSetMessages_Active 19656
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_FailedDataSetMessages_Classification 19657
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel 19658
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_DecryptionErrors_Active 19661
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_DecryptionErrors_Classification 19662
#define OpcUaId_DataSetReaderType_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel 19663
#define OpcUaId_DataSetReaderType_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel 19666
#define OpcUaId_DataSetReaderType_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel 19668
#define OpcUaId_DataSetReaderType_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel 19670
#define OpcUaId_DataSetReaderType_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel 19672
#define OpcUaId_DataSetReaderType_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel 19674
#define OpcUaId_DataSetReaderType_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel 19676
#define OpcUaId_DataSetReaderType_CreateTargetVariables_InputArguments 17387
#define OpcUaId_DataSetReaderType_CreateTargetVariables_OutputArguments 17388
#define OpcUaId_DataSetReaderType_CreateDataSetMirror_InputArguments 17390
#define OpcUaId_DataSetReaderType_CreateDataSetMirror_OutputArguments 17391
#define OpcUaId_TargetVariablesType_TargetVariables 15114
#define OpcUaId_TargetVariablesType_AddTargetVariables_InputArguments 15116
#define OpcUaId_TargetVariablesType_AddTargetVariables_OutputArguments 15117
#define OpcUaId_TargetVariablesType_RemoveTargetVariables_InputArguments 15119
#define OpcUaId_TargetVariablesType_RemoveTargetVariables_OutputArguments 15120
#define OpcUaId_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddSubscribedDataSet_InputArguments 23798
#define OpcUaId_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddSubscribedDataSet_OutputArguments 23799
#define OpcUaId_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveSubscribedDataSet_InputArguments 23801
#define OpcUaId_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddDataSetFolder_InputArguments 23803
#define OpcUaId_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddDataSetFolder_OutputArguments 23804
#define OpcUaId_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveDataSetFolder_InputArguments 23806
#define OpcUaId_SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder_DataSetMetaData 23809
#define OpcUaId_SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder_IsConnected 23810
#define OpcUaId_SubscribedDataSetFolderType_AddSubscribedDataSet_InputArguments 23812
#define OpcUaId_SubscribedDataSetFolderType_AddSubscribedDataSet_OutputArguments 23813
#define OpcUaId_SubscribedDataSetFolderType_RemoveSubscribedDataSet_InputArguments 23815
#define OpcUaId_SubscribedDataSetFolderType_AddDataSetFolder_InputArguments 23817
#define OpcUaId_SubscribedDataSetFolderType_AddDataSetFolder_OutputArguments 23818
#define OpcUaId_SubscribedDataSetFolderType_RemoveDataSetFolder_InputArguments 23820
#define OpcUaId_StandaloneSubscribedDataSetType_DataSetMetaData 23830
#define OpcUaId_StandaloneSubscribedDataSetType_IsConnected 23831
#define OpcUaId_PubSubStatusType_State 14644
#define OpcUaId_PubSubDiagnosticsType_DiagnosticsLevel 19678
#define OpcUaId_PubSubDiagnosticsType_TotalInformation 19679
#define OpcUaId_PubSubDiagnosticsType_TotalInformation_Active 19680
#define OpcUaId_PubSubDiagnosticsType_TotalInformation_Classification 19681
#define OpcUaId_PubSubDiagnosticsType_TotalInformation_DiagnosticsLevel 19682
#define OpcUaId_PubSubDiagnosticsType_TotalError 19684
#define OpcUaId_PubSubDiagnosticsType_TotalError_Active 19685
#define OpcUaId_PubSubDiagnosticsType_TotalError_Classification 19686
#define OpcUaId_PubSubDiagnosticsType_TotalError_DiagnosticsLevel 19687
#define OpcUaId_PubSubDiagnosticsType_SubError 19690
#define OpcUaId_PubSubDiagnosticsType_Counters_StateError 19692
#define OpcUaId_PubSubDiagnosticsType_Counters_StateError_Active 19693
#define OpcUaId_PubSubDiagnosticsType_Counters_StateError_Classification 19694
#define OpcUaId_PubSubDiagnosticsType_Counters_StateError_DiagnosticsLevel 19695
#define OpcUaId_PubSubDiagnosticsType_Counters_StateOperationalByMethod 19697
#define OpcUaId_PubSubDiagnosticsType_Counters_StateOperationalByMethod_Active 19698
#define OpcUaId_PubSubDiagnosticsType_Counters_StateOperationalByMethod_Classification 19699
#define OpcUaId_PubSubDiagnosticsType_Counters_StateOperationalByMethod_DiagnosticsLevel 19700
#define OpcUaId_PubSubDiagnosticsType_Counters_StateOperationalByParent 19702
#define OpcUaId_PubSubDiagnosticsType_Counters_StateOperationalByParent_Active 19703
#define OpcUaId_PubSubDiagnosticsType_Counters_StateOperationalByParent_Classification 19704
#define OpcUaId_PubSubDiagnosticsType_Counters_StateOperationalByParent_DiagnosticsLevel 19705
#define OpcUaId_PubSubDiagnosticsType_Counters_StateOperationalFromError 19707
#define OpcUaId_PubSubDiagnosticsType_Counters_StateOperationalFromError_Active 19708
#define OpcUaId_PubSubDiagnosticsType_Counters_StateOperationalFromError_Classification 19709
#define OpcUaId_PubSubDiagnosticsType_Counters_StateOperationalFromError_DiagnosticsLevel 19710
#define OpcUaId_PubSubDiagnosticsType_Counters_StatePausedByParent 19712
#define OpcUaId_PubSubDiagnosticsType_Counters_StatePausedByParent_Active 19713
#define OpcUaId_PubSubDiagnosticsType_Counters_StatePausedByParent_Classification 19714
#define OpcUaId_PubSubDiagnosticsType_Counters_StatePausedByParent_DiagnosticsLevel 19715
#define OpcUaId_PubSubDiagnosticsType_Counters_StateDisabledByMethod 19717
#define OpcUaId_PubSubDiagnosticsType_Counters_StateDisabledByMethod_Active 19718
#define OpcUaId_PubSubDiagnosticsType_Counters_StateDisabledByMethod_Classification 19719
#define OpcUaId_PubSubDiagnosticsType_Counters_StateDisabledByMethod_DiagnosticsLevel 19720
#define OpcUaId_DiagnosticsLevel_EnumStrings 19724
#define OpcUaId_PubSubDiagnosticsCounterType_Active 19726
#define OpcUaId_PubSubDiagnosticsCounterType_Classification 19727
#define OpcUaId_PubSubDiagnosticsCounterType_DiagnosticsLevel 19728
#define OpcUaId_PubSubDiagnosticsCounterType_TimeFirstChange 19729
#define OpcUaId_PubSubDiagnosticsCounterClassification_EnumStrings 19731
#define OpcUaId_PubSubDiagnosticsRootType_TotalInformation_Active 19735
#define OpcUaId_PubSubDiagnosticsRootType_TotalInformation_Classification 19736
#define OpcUaId_PubSubDiagnosticsRootType_TotalInformation_DiagnosticsLevel 19737
#define OpcUaId_PubSubDiagnosticsRootType_TotalError_Active 19740
#define OpcUaId_PubSubDiagnosticsRootType_TotalError_Classification 19741
#define OpcUaId_PubSubDiagnosticsRootType_TotalError_DiagnosticsLevel 19742
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateError 19747
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateError_Active 19748
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateError_Classification 19749
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateError_DiagnosticsLevel 19750
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateOperationalByMethod 19752
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateOperationalByMethod_Active 19753
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateOperationalByMethod_Classification 19754
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateOperationalByMethod_DiagnosticsLevel 19755
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateOperationalByParent 19757
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateOperationalByParent_Active 19758
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateOperationalByParent_Classification 19759
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateOperationalByParent_DiagnosticsLevel 19760
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateOperationalFromError 19762
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateOperationalFromError_Active 19763
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateOperationalFromError_Classification 19764
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateOperationalFromError_DiagnosticsLevel 19765
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StatePausedByParent 19767
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StatePausedByParent_Active 19768
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StatePausedByParent_Classification 19769
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StatePausedByParent_DiagnosticsLevel 19770
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateDisabledByMethod 19772
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateDisabledByMethod_Active 19773
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateDisabledByMethod_Classification 19774
#define OpcUaId_PubSubDiagnosticsRootType_Counters_StateDisabledByMethod_DiagnosticsLevel 19775
#define OpcUaId_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters 19778
#define OpcUaId_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel 19779
#define OpcUaId_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders 19780
#define OpcUaId_PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel 19781
#define OpcUaId_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters 19782
#define OpcUaId_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel 19783
#define OpcUaId_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders 19784
#define OpcUaId_PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel 19785
#define OpcUaId_PubSubDiagnosticsConnectionType_TotalInformation_Active 19789
#define OpcUaId_PubSubDiagnosticsConnectionType_TotalInformation_Classification 19790
#define OpcUaId_PubSubDiagnosticsConnectionType_TotalInformation_DiagnosticsLevel 19791
#define OpcUaId_PubSubDiagnosticsConnectionType_TotalError_Active 19794
#define OpcUaId_PubSubDiagnosticsConnectionType_TotalError_Classification 19795
#define OpcUaId_PubSubDiagnosticsConnectionType_TotalError_DiagnosticsLevel 19796
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateError 19801
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateError_Active 19802
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateError_Classification 19803
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateError_DiagnosticsLevel 19804
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateOperationalByMethod 19806
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateOperationalByMethod_Active 19807
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateOperationalByMethod_Classification 19808
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateOperationalByMethod_DiagnosticsLevel 19809
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateOperationalByParent 19811
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateOperationalByParent_Active 19812
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateOperationalByParent_Classification 19813
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateOperationalByParent_DiagnosticsLevel 19814
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateOperationalFromError 19816
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateOperationalFromError_Active 19817
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateOperationalFromError_Classification 19818
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateOperationalFromError_DiagnosticsLevel 19819
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StatePausedByParent 19821
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StatePausedByParent_Active 19822
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StatePausedByParent_Classification 19823
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StatePausedByParent_DiagnosticsLevel 19824
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateDisabledByMethod 19826
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateDisabledByMethod_Active 19827
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateDisabledByMethod_Classification 19828
#define OpcUaId_PubSubDiagnosticsConnectionType_Counters_StateDisabledByMethod_DiagnosticsLevel 19829
#define OpcUaId_PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress 19832
#define OpcUaId_PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress_DiagnosticsLevel 19833
#define OpcUaId_PubSubDiagnosticsWriterGroupType_TotalInformation_Active 19837
#define OpcUaId_PubSubDiagnosticsWriterGroupType_TotalInformation_Classification 19838
#define OpcUaId_PubSubDiagnosticsWriterGroupType_TotalInformation_DiagnosticsLevel 19839
#define OpcUaId_PubSubDiagnosticsWriterGroupType_TotalError_Active 19842
#define OpcUaId_PubSubDiagnosticsWriterGroupType_TotalError_Classification 19843
#define OpcUaId_PubSubDiagnosticsWriterGroupType_TotalError_DiagnosticsLevel 19844
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateError 19849
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateError_Active 19850
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateError_Classification 19851
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateError_DiagnosticsLevel 19852
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod 19854
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Active 19855
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Classification 19856
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel 19857
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent 19859
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Active 19860
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Classification 19861
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_DiagnosticsLevel 19862
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError 19864
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Active 19865
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Classification 19866
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_DiagnosticsLevel 19867
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent 19869
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Active 19870
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Classification 19871
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_DiagnosticsLevel 19872
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod 19874
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Active 19875
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Classification 19876
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel 19877
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages 19880
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Active 19881
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Classification 19882
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_DiagnosticsLevel 19883
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions 19885
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Active 19886
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Classification 19887
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_DiagnosticsLevel 19888
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors 19890
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Active 19891
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Classification 19892
#define OpcUaId_PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_DiagnosticsLevel 19893
#define OpcUaId_PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters 19895
#define OpcUaId_PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel 19896
#define OpcUaId_PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters 19897
#define OpcUaId_PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel 19898
#define OpcUaId_PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID 19899
#define OpcUaId_PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID_DiagnosticsLevel 19900
#define OpcUaId_PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID 19901
#define OpcUaId_PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID_DiagnosticsLevel 19902
#define OpcUaId_PubSubDiagnosticsReaderGroupType_TotalInformation_Active 19906
#define OpcUaId_PubSubDiagnosticsReaderGroupType_TotalInformation_Classification 19907
#define OpcUaId_PubSubDiagnosticsReaderGroupType_TotalInformation_DiagnosticsLevel 19908
#define OpcUaId_PubSubDiagnosticsReaderGroupType_TotalError_Active 19911
#define OpcUaId_PubSubDiagnosticsReaderGroupType_TotalError_Classification 19912
#define OpcUaId_PubSubDiagnosticsReaderGroupType_TotalError_DiagnosticsLevel 19913
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateError 19918
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateError_Active 19919
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateError_Classification 19920
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateError_DiagnosticsLevel 19921
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod 19923
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Active 19924
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Classification 19925
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel 19926
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent 19928
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Active 19929
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Classification 19930
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_DiagnosticsLevel 19931
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError 19933
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Active 19934
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Classification 19935
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_DiagnosticsLevel 19936
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent 19938
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Active 19939
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Classification 19940
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_DiagnosticsLevel 19941
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod 19943
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Active 19944
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Classification 19945
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel 19946
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages 19949
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Active 19950
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Classification 19951
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_DiagnosticsLevel 19952
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages 19954
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Active 19955
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Classification 19956
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel 19957
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors 19959
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Active 19960
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Classification 19961
#define OpcUaId_PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_DiagnosticsLevel 19962
#define OpcUaId_PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders 19964
#define OpcUaId_PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel 19965
#define OpcUaId_PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders 19966
#define OpcUaId_PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel 19967
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_TotalInformation_Active 19971
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_TotalInformation_Classification 19972
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_TotalInformation_DiagnosticsLevel 19973
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_TotalError_Active 19976
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_TotalError_Classification 19977
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_TotalError_DiagnosticsLevel 19978
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateError 19983
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateError_Active 19984
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateError_Classification 19985
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateError_DiagnosticsLevel 19986
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod 19988
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Active 19989
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Classification 19990
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_DiagnosticsLevel 19991
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent 19993
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Active 19994
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Classification 19995
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_DiagnosticsLevel 19996
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError 19998
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Active 19999
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Classification 20000
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_DiagnosticsLevel 20001
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent 20003
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Active 20004
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Classification 20005
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_DiagnosticsLevel 20006
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod 20008
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Active 20009
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Classification 20010
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_DiagnosticsLevel 20011
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages 20014
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Active 20015
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Classification 20016
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_DiagnosticsLevel 20017
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber 20019
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber_DiagnosticsLevel 20020
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode 20021
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode_DiagnosticsLevel 20022
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion 20023
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion_DiagnosticsLevel 20024
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion 20025
#define OpcUaId_PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion_DiagnosticsLevel 20026
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_TotalInformation_Active 20030
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_TotalInformation_Classification 20031
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_TotalInformation_DiagnosticsLevel 20032
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_TotalError_Active 20035
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_TotalError_Classification 20036
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_TotalError_DiagnosticsLevel 20037
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateError 20042
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateError_Active 20043
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateError_Classification 20044
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateError_DiagnosticsLevel 20045
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod 20047
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Active 20048
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Classification 20049
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_DiagnosticsLevel 20050
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent 20052
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Active 20053
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Classification 20054
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_DiagnosticsLevel 20055
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError 20057
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Active 20058
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Classification 20059
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_DiagnosticsLevel 20060
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent 20062
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Active 20063
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Classification 20064
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_DiagnosticsLevel 20065
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod 20067
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Active 20068
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Classification 20069
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_DiagnosticsLevel 20070
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages 20073
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Active 20074
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Classification 20075
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_DiagnosticsLevel 20076
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors 20078
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Active 20079
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Classification 20080
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_DiagnosticsLevel 20081
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber 20083
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber_DiagnosticsLevel 20084
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode 20085
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode_DiagnosticsLevel 20086
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion 20087
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion_DiagnosticsLevel 20088
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion 20089
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion_DiagnosticsLevel 20090
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID 20091
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID_DiagnosticsLevel 20092
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID 20093
#define OpcUaId_PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID_DiagnosticsLevel 20094
#define OpcUaId_PubSubCapabilitiesType_MaxPubSubConnections 23833
#define OpcUaId_PubSubCapabilitiesType_MaxWriterGroups 23834
#define OpcUaId_PubSubCapabilitiesType_MaxReaderGroups 23835
#define OpcUaId_PubSubCapabilitiesType_MaxDataSetWriters 23836
#define OpcUaId_PubSubCapabilitiesType_MaxDataSetReaders 23837
#define OpcUaId_PubSubCapabilitiesType_MaxFieldsPerDataSet 23838
#define OpcUaId_PubSubCapabilitiesType_MaxDataSetWritersPerGroup 32651
#define OpcUaId_PubSubCapabilitiesType_MaxNetworkMessageSizeDatagram 32652
#define OpcUaId_PubSubCapabilitiesType_MaxNetworkMessageSizeBroker 32653
#define OpcUaId_PubSubCapabilitiesType_SupportSecurityKeyPull 32654
#define OpcUaId_PubSubCapabilitiesType_SupportSecurityKeyPush 32655
#define OpcUaId_PubSubStatusEventType_ConnectionId 15545
#define OpcUaId_PubSubStatusEventType_GroupId 15546
#define OpcUaId_PubSubStatusEventType_State 15547
#define OpcUaId_PubSubTransportLimitsExceedEventType_Actual 15561
#define OpcUaId_PubSubTransportLimitsExceedEventType_Maximum 15562
#define OpcUaId_PubSubCommunicationFailureEventType_Error 15576
#define OpcUaId_UadpWriterGroupMessageType_GroupVersion 21106
#define OpcUaId_UadpWriterGroupMessageType_DataSetOrdering 21107
#define OpcUaId_UadpWriterGroupMessageType_NetworkMessageContentMask 21108
#define OpcUaId_UadpWriterGroupMessageType_SamplingOffset 21109
#define OpcUaId_UadpWriterGroupMessageType_PublishingOffset 21110
#define OpcUaId_UadpDataSetWriterMessageType_DataSetMessageContentMask 21112
#define OpcUaId_UadpDataSetWriterMessageType_ConfiguredSize 21113
#define OpcUaId_UadpDataSetWriterMessageType_NetworkMessageNumber 21114
#define OpcUaId_UadpDataSetWriterMessageType_DataSetOffset 21115
#define OpcUaId_UadpDataSetReaderMessageType_GroupVersion 21117
#define OpcUaId_UadpDataSetReaderMessageType_NetworkMessageNumber 21119
#define OpcUaId_UadpDataSetReaderMessageType_DataSetOffset 17477
#define OpcUaId_UadpDataSetReaderMessageType_DataSetClassId 21120
#define OpcUaId_UadpDataSetReaderMessageType_NetworkMessageContentMask 21121
#define OpcUaId_UadpDataSetReaderMessageType_DataSetMessageContentMask 21122
#define OpcUaId_UadpDataSetReaderMessageType_PublishingInterval 21123
#define OpcUaId_UadpDataSetReaderMessageType_ProcessingOffset 21124
#define OpcUaId_UadpDataSetReaderMessageType_ReceiveOffset 21125
#define OpcUaId_JsonWriterGroupMessageType_NetworkMessageContentMask 21127
#define OpcUaId_JsonDataSetWriterMessageType_DataSetMessageContentMask 21129
#define OpcUaId_JsonDataSetReaderMessageType_NetworkMessageContentMask 21131
#define OpcUaId_JsonDataSetReaderMessageType_DataSetMessageContentMask 21132
#define OpcUaId_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface 15154
#define OpcUaId_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_Selections 17579
#define OpcUaId_DatagramConnectionTransportType_DiscoveryAnnounceRate 23839
#define OpcUaId_DatagramConnectionTransportType_DiscoveryMaxMessageSize 23840
#define OpcUaId_DatagramConnectionTransportType_QosCategory 25525
#define OpcUaId_DatagramConnectionTransportType_DatagramQos 25526
#define OpcUaId_DatagramWriterGroupTransportType_MessageRepeatCount 21134
#define OpcUaId_DatagramWriterGroupTransportType_MessageRepeatDelay 21135
#define OpcUaId_DatagramWriterGroupTransportType_Address_NetworkInterface 23843
#define OpcUaId_DatagramWriterGroupTransportType_Address_NetworkInterface_Selections 23844
#define OpcUaId_DatagramWriterGroupTransportType_QosCategory 25527
#define OpcUaId_DatagramWriterGroupTransportType_DatagramQos 23847
#define OpcUaId_DatagramWriterGroupTransportType_DiscoveryAnnounceRate 23848
#define OpcUaId_DatagramWriterGroupTransportType_Topic 23849
#define OpcUaId_DatagramDataSetReaderTransportType_Address_NetworkInterface 24018
#define OpcUaId_DatagramDataSetReaderTransportType_Address_NetworkInterface_Selections 24019
#define OpcUaId_DatagramDataSetReaderTransportType_QosCategory 25528
#define OpcUaId_DatagramDataSetReaderTransportType_DatagramQos 24022
#define OpcUaId_DatagramDataSetReaderTransportType_Topic 24023
#define OpcUaId_BrokerConnectionTransportType_ResourceUri 15156
#define OpcUaId_BrokerConnectionTransportType_AuthenticationProfileUri 15178
#define OpcUaId_BrokerWriterGroupTransportType_QueueName 21137
#define OpcUaId_BrokerWriterGroupTransportType_ResourceUri 15246
#define OpcUaId_BrokerWriterGroupTransportType_AuthenticationProfileUri 15247
#define OpcUaId_BrokerWriterGroupTransportType_RequestedDeliveryGuarantee 15249
#define OpcUaId_BrokerDataSetWriterTransportType_QueueName 21139
#define OpcUaId_BrokerDataSetWriterTransportType_MetaDataQueueName 21140
#define OpcUaId_BrokerDataSetWriterTransportType_ResourceUri 15250
#define OpcUaId_BrokerDataSetWriterTransportType_AuthenticationProfileUri 15251
#define OpcUaId_BrokerDataSetWriterTransportType_RequestedDeliveryGuarantee 15330
#define OpcUaId_BrokerDataSetWriterTransportType_MetaDataUpdateTime 21141
#define OpcUaId_BrokerDataSetReaderTransportType_QueueName 21143
#define OpcUaId_BrokerDataSetReaderTransportType_ResourceUri 15334
#define OpcUaId_BrokerDataSetReaderTransportType_AuthenticationProfileUri 15419
#define OpcUaId_BrokerDataSetReaderTransportType_RequestedDeliveryGuarantee 15420
#define OpcUaId_BrokerDataSetReaderTransportType_MetaDataQueueName 21144
#define OpcUaId_NetworkAddressType_NetworkInterface 21146
#define OpcUaId_NetworkAddressType_NetworkInterface_Selections 17582
#define OpcUaId_NetworkAddressUrlType_NetworkInterface_Selections 17585
#define OpcUaId_NetworkAddressUrlType_Url 21149
#define OpcUaId_AliasNameCategoryType_SubAliasNameCategories_Placeholder_FindAlias_InputArguments 23460
#define OpcUaId_AliasNameCategoryType_SubAliasNameCategories_Placeholder_FindAlias_OutputArguments 23461
#define OpcUaId_AliasNameCategoryType_FindAlias_InputArguments 23463
#define OpcUaId_AliasNameCategoryType_FindAlias_OutputArguments 23464
#define OpcUaId_Aliases_SubAliasNameCategories_Placeholder_FindAlias_InputArguments 23474
#define OpcUaId_Aliases_SubAliasNameCategories_Placeholder_FindAlias_OutputArguments 23475
#define OpcUaId_Aliases_FindAlias_InputArguments 23477
#define OpcUaId_Aliases_FindAlias_OutputArguments 23478
#define OpcUaId_TagVariables_SubAliasNameCategories_Placeholder_FindAlias_InputArguments 23483
#define OpcUaId_TagVariables_SubAliasNameCategories_Placeholder_FindAlias_OutputArguments 23484
#define OpcUaId_TagVariables_FindAlias_InputArguments 23486
#define OpcUaId_TagVariables_FindAlias_OutputArguments 23487
#define OpcUaId_Topics_SubAliasNameCategories_Placeholder_FindAlias_InputArguments 23492
#define OpcUaId_Topics_SubAliasNameCategories_Placeholder_FindAlias_OutputArguments 23493
#define OpcUaId_Topics_FindAlias_InputArguments 23495
#define OpcUaId_Topics_FindAlias_OutputArguments 23496
#define OpcUaId_UserManagementType_Users 24265
#define OpcUaId_UserManagementType_PasswordLength 24266
#define OpcUaId_UserManagementType_PasswordOptions 24267
#define OpcUaId_UserManagementType_PasswordRestrictions 24268
#define OpcUaId_UserManagementType_AddUser_InputArguments 24270
#define OpcUaId_UserManagementType_ModifyUser_InputArguments 24272
#define OpcUaId_UserManagementType_RemoveUser_InputArguments 24274
#define OpcUaId_UserManagementType_ChangePassword_InputArguments 24276
#define OpcUaId_PasswordOptionsMask_OptionSetValues 24278
#define OpcUaId_UserConfigurationMask_OptionSetValues 24280
#define OpcUaId_UserManagement_Users 24301
#define OpcUaId_UserManagement_PasswordLength 24302
#define OpcUaId_UserManagement_PasswordOptions 24303
#define OpcUaId_UserManagement_PasswordRestrictions 24291
#define OpcUaId_UserManagement_AddUser_InputArguments 24305
#define OpcUaId_UserManagement_ModifyUser_InputArguments 24307
#define OpcUaId_UserManagement_RemoveUser_InputArguments 24309
#define OpcUaId_UserManagement_ChangePassword_InputArguments 24311
#define OpcUaId_MultiStateDictionaryEntryDiscreteBaseType_EnumDictionaryEntries 19082
#define OpcUaId_MultiStateDictionaryEntryDiscreteBaseType_ValueAsDictionaryEntries 19083
#define OpcUaId_MultiStateDictionaryEntryDiscreteType_ValueAsDictionaryEntries 19090
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Size 25735
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Writable 25736
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable 25737
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount 25738
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments 25743
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments 25744
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments 25746
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments 25748
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments 25749
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments 25751
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments 25753
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments 25754
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments 25756
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime 25757
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments 25761
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments 25762
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments 25764
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments 25765
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments 25767
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments 25769
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateTypes 25770
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments 25773
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId 25775
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType 25776
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode 25777
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName 25778
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time 25779
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime 25780
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message 25782
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity 25783
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId 25784
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName 25785
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName 25788
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId 25789
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain 25790
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState 25791
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id 25792
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality 25800
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp 25801
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity 25802
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp 25803
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment 25804
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp 25805
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId 25806
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments 25810
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState 25811
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id 25812
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id 25821
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments 25830
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments 25832
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState 25833
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id 25834
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode 25842
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id 25844
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id 25853
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState 25862
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id 25863
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id 25868
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime 25875
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 25877
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 25879
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 25882
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 25885
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved 25886
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id 25894
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id 25907
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments 25920
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments 25923
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments 25926
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments 25929
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments 25932
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments 25934
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState 25935
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate 25936
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType 25938
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate 25939
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId 25941
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType 25942
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode 25943
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName 25944
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time 25945
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime 25946
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message 25948
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity 25949
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId 25950
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName 25951
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName 25954
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId 25955
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain 25956
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState 25957
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id 25958
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality 25966
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp 25967
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity 25968
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 25969
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment 25970
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp 25971
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId 25972
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments 25976
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState 25977
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id 25978
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id 25987
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments 25996
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments 25998
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState 25999
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id 26000
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode 26008
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id 26010
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id 26019
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState 26028
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 26029
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 26034
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 26041
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 26043
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 26045
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 26048
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 26051
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved 26052
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id 26060
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id 26073
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments 26086
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments 26089
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 26092
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments 26095
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments 26098
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 26100
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState 26101
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId 26102
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime 26103
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency 26104
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Size 26107
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Writable 26108
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable 26109
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount 26110
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments 26115
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments 26116
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments 26118
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments 26120
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments 26121
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments 26123
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments 26125
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments 26126
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments 26128
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime 26129
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments 26133
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments 26134
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments 26136
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments 26137
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments 26139
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments 26141
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateTypes 26142
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments 26145
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId 26147
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType 26148
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode 26149
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName 26150
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time 26151
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime 26152
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message 26154
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity 26155
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId 26156
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName 26157
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName 26160
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId 26161
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain 26162
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState 26163
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id 26164
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality 26172
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp 26173
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity 26174
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp 26175
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment 26176
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp 26177
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId 26178
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments 26182
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState 26183
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id 26184
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id 26193
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments 26202
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments 26204
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState 26205
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id 26206
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode 26214
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id 26216
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id 26225
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState 26234
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id 26235
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id 26240
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime 26247
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 26249
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 26251
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 26254
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 26257
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved 26258
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id 26266
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id 26279
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments 26292
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments 26295
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments 26298
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments 26301
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments 26304
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments 26306
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState 26307
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate 26308
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType 26310
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate 26311
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId 26313
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType 26314
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode 26315
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName 26316
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time 26317
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime 26318
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message 26320
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity 26321
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId 26322
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName 26323
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName 26326
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId 26327
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain 26328
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState 26329
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id 26330
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality 26338
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp 26339
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity 26340
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 26341
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment 26342
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp 26343
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId 26344
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments 26348
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState 26349
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id 26350
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id 26359
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments 26368
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments 26370
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState 26371
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id 26372
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode 26380
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id 26382
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id 26391
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState 26400
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 26401
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 26406
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 26413
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 26415
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 26417
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 26420
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 26423
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved 26424
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id 26432
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id 26445
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments 26458
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments 26461
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 26464
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments 26467
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments 26470
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 26472
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState 26473
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId 26474
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime 26475
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency 26476
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Size 26479
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable 26480
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable 26481
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount 26482
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments 26487
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments 26488
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments 26490
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments 26492
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments 26493
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments 26495
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments 26497
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments 26498
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments 26500
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime 26501
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments 26505
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments 26506
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments 26508
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments 26509
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments 26511
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments 26513
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateTypes 26514
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments 26517
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId 26519
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType 26520
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode 26521
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName 26522
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time 26523
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime 26524
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message 26526
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity 26527
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId 26528
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName 26529
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName 26532
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId 26533
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain 26534
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState 26535
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id 26536
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality 26544
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp 26545
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity 26546
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp 26547
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment 26548
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp 26549
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId 26550
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments 26554
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState 26555
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id 26556
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id 26565
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments 26574
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments 26576
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState 26577
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id 26578
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode 26586
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id 26588
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id 26597
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState 26606
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id 26607
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id 26612
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime 26619
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 26621
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 26623
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 26626
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 26629
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved 26630
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id 26638
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id 26651
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments 26664
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments 26667
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments 26670
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments 26673
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments 26676
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments 26678
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState 26679
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate 26680
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType 26682
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate 26683
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId 26685
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType 26686
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode 26687
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName 26688
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time 26689
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime 26690
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message 26692
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity 26693
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId 26694
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName 26695
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName 26698
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId 26699
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain 26700
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState 26701
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id 26702
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality 26710
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp 26711
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity 26712
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 26713
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment 26714
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp 26715
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId 26716
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments 26720
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState 26721
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id 26722
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id 26731
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments 26740
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments 26742
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState 26743
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id 26744
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode 26752
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id 26754
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id 26763
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState 26772
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 26773
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 26778
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 26785
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 26787
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 26789
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 26792
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 26795
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved 26796
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id 26804
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id 26817
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments 26830
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments 26833
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 26836
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments 26839
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments 26842
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 26844
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState 26845
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId 26846
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime 26847
#define OpcUaId_ApplicationConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency 26848
#define OpcUaId_ApplicationConfigurationType_ApplicationUri 26850
#define OpcUaId_ApplicationConfigurationType_ProductUri 26851
#define OpcUaId_ApplicationConfigurationType_ApplicationType 26852
#define OpcUaId_ApplicationConfigurationType_UpdateCertificate_InputArguments 26859
#define OpcUaId_ApplicationConfigurationType_UpdateCertificate_OutputArguments 26860
#define OpcUaId_ApplicationConfigurationType_GetCertificates_InputArguments 32347
#define OpcUaId_ApplicationConfigurationType_GetCertificates_OutputArguments 32348
#define OpcUaId_ApplicationConfigurationType_CreateSigningRequest_InputArguments 26864
#define OpcUaId_ApplicationConfigurationType_CreateSigningRequest_OutputArguments 26865
#define OpcUaId_ApplicationConfigurationType_GetRejectedList_OutputArguments 26867
#define OpcUaId_ApplicationConfigurationType_TransactionDiagnostics_StartTime 32350
#define OpcUaId_ApplicationConfigurationType_TransactionDiagnostics_EndTime 32351
#define OpcUaId_ApplicationConfigurationType_TransactionDiagnostics_Result 32352
#define OpcUaId_ApplicationConfigurationType_TransactionDiagnostics_AffectedTrustLists 32353
#define OpcUaId_ApplicationConfigurationType_TransactionDiagnostics_AffectedCertificateGroups 32354
#define OpcUaId_ApplicationConfigurationType_TransactionDiagnostics_Errors 32355
#define OpcUaId_ApplicationConfigurationType_Enabled 26849
#define OpcUaId_ProvisionableDeviceType_IsSingleton 26872
#define OpcUaId_ProvisionableDeviceType_RequestTickets_OutputArguments 26874
#define OpcUaId_ProvisionableDeviceType_SetRegistrarEndpoints_InputArguments 26876
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Size 26882
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Writable 26883
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable 26884
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount 26885
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments 26890
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments 26891
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments 26893
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments 26895
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments 26896
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments 26898
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments 26900
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments 26901
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments 26903
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime 26904
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments 26908
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments 26909
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments 26911
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments 26912
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments 26914
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments 26916
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateTypes 26917
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments 26920
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId 26922
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType 26923
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode 26924
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName 26925
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time 26926
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime 26927
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message 26929
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity 26930
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId 26931
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName 26932
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName 26935
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId 26936
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain 26937
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState 26938
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id 26939
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality 26947
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp 26948
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity 26949
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp 26950
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment 26951
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp 26952
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId 26953
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments 26957
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState 26958
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id 26959
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id 26968
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments 26977
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments 26979
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState 26980
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id 26981
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode 26989
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id 26991
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id 27000
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState 27009
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id 27010
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id 27015
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime 27022
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 27024
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 27026
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 27029
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 27032
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved 27033
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id 27041
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id 27054
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments 27067
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments 27070
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments 27073
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments 27076
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments 27079
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments 27081
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState 27082
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate 27083
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType 27085
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate 27086
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId 27088
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType 27089
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode 27090
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName 27091
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time 27092
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime 27093
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message 27095
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity 27096
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId 27097
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName 27098
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName 27101
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId 27102
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain 27103
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState 27104
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id 27105
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality 27113
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp 27114
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity 27115
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 27116
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment 27117
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp 27118
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId 27119
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments 27123
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState 27124
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id 27125
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id 27134
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments 27143
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments 27145
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState 27146
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id 27147
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode 27155
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id 27157
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id 27166
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState 27175
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 27176
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 27181
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 27188
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 27190
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 27192
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 27195
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 27198
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved 27199
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id 27207
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id 27220
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments 27233
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments 27236
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 27239
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments 27242
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments 27245
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 27247
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState 27248
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId 27249
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime 27250
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency 27251
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Size 27254
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Writable 27255
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable 27256
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount 27257
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments 27262
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments 27263
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments 27265
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments 27267
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments 27268
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments 27270
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments 27272
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments 27273
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments 27275
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime 27276
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments 27280
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments 27281
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments 27283
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments 27284
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments 27286
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments 27288
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateTypes 27289
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments 27292
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId 27294
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType 27295
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode 27296
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName 27297
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time 27298
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime 27299
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message 27301
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity 27302
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId 27303
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName 27304
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName 27307
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId 27308
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain 27309
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState 27310
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id 27311
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality 27319
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp 27320
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity 27321
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp 27322
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment 27323
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp 27324
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId 27325
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments 27329
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState 27330
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id 27331
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id 27340
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments 27349
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments 27351
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState 27352
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id 27353
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode 27361
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id 27363
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id 27372
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState 27381
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id 27382
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id 27387
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime 27394
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 27396
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 27398
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 27401
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 27404
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved 27405
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id 27413
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id 27426
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments 27439
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments 27442
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments 27445
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments 27448
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments 27451
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments 27453
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState 27454
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate 27455
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType 27457
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate 27458
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId 27460
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType 27461
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode 27462
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName 27463
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time 27464
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime 27465
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message 27467
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity 27468
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId 27469
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName 27470
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName 27473
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId 27474
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain 27475
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState 27476
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id 27477
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality 27485
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp 27486
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity 27487
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 27488
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment 27489
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp 27490
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId 27491
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments 27495
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState 27496
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id 27497
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id 27506
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments 27515
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments 27517
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState 27518
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id 27519
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode 27527
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id 27529
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id 27538
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState 27547
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 27548
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 27553
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 27560
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 27562
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 27564
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 27567
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 27570
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved 27571
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id 27579
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id 27592
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments 27605
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments 27608
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 27611
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments 27614
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments 27617
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 27619
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState 27620
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId 27621
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime 27622
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency 27623
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Size 27626
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable 27627
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable 27628
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount 27629
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments 27634
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments 27635
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments 27637
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments 27639
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments 27640
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments 27642
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments 27644
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments 27645
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments 27647
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime 27648
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments 27652
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments 27653
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments 27655
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments 27656
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments 27658
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments 27660
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateTypes 27661
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments 27664
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId 27666
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType 27667
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode 27668
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName 27669
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time 27670
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime 27671
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message 27673
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity 27674
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId 27675
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName 27676
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName 27679
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId 27680
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain 27681
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState 27682
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id 27683
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality 27691
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp 27692
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity 27693
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp 27694
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment 27695
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp 27696
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId 27697
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments 27701
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState 27702
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id 27703
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id 27712
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments 27721
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments 27723
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState 27724
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id 27725
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode 27733
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id 27735
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id 27744
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState 27753
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id 27754
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id 27759
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime 27766
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 27768
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 27770
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 27773
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 27776
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved 27777
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id 27785
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id 27798
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments 27811
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments 27814
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments 27817
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments 27820
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments 27823
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments 27825
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState 27826
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate 27827
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType 27829
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate 27830
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId 27832
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType 27833
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode 27834
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName 27835
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time 27836
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime 27837
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message 27839
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity 27840
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId 27841
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName 27842
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName 27845
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId 27846
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain 27847
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState 27848
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id 27849
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality 27857
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp 27858
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity 27859
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 27860
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment 27861
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp 27862
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId 27863
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments 27867
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState 27868
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id 27869
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id 27878
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments 27887
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments 27889
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState 27890
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id 27891
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode 27899
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id 27901
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id 27910
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState 27919
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 27920
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 27925
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 27932
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 27934
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 27936
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 27939
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 27942
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved 27943
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id 27951
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id 27964
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments 27977
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments 27980
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 27983
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments 27986
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments 27989
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 27991
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState 27992
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId 27993
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime 27994
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency 27995
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationUri 27997
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_ProductUri 27998
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationType 27999
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_ServerCapabilities 28000
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_SupportedPrivateKeyFormats 28001
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_MaxTrustListSize 28002
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_MulticastDnsEnabled 28003
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate_InputArguments 28006
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate_OutputArguments 28007
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates_InputArguments 32360
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates_OutputArguments 32361
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest_InputArguments 28011
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest_OutputArguments 28012
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_GetRejectedList_OutputArguments 28014
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_StartTime 32363
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_EndTime 32364
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_Result 32365
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_AffectedTrustLists 32366
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_AffectedCertificateGroups 32367
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_Errors 32368
#define OpcUaId_ProvisionableDeviceType_ApplicationName_Placeholder_Enabled 27996
#define OpcUaId_ProvisionableDevice_IsSingleton 29879
#define OpcUaId_ProvisionableDevice_RequestTickets_OutputArguments 29881
#define OpcUaId_ProvisionableDevice_SetRegistrarEndpoints_InputArguments 29883
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Size 29889
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Writable 29890
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable 29891
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount 29892
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments 29897
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments 29898
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments 29900
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments 29902
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments 29903
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments 29905
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments 29907
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments 29908
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments 29910
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime 29911
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments 29915
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments 29916
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments 29918
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments 29919
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments 29921
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments 29923
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateTypes 29924
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments 29927
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId 29929
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType 29930
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode 29931
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName 29932
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time 29933
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime 29934
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message 29936
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity 29937
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId 29938
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName 29939
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName 29942
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId 29943
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain 29944
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState 29945
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id 29946
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality 29954
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp 29955
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity 29956
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp 29957
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment 29958
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp 29959
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId 29960
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments 29964
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState 29965
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id 29966
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id 29975
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments 29984
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments 29986
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState 29987
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id 29988
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode 29996
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id 29998
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id 30007
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState 30016
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id 30017
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id 30022
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime 30029
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 30031
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 30033
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 30036
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 30039
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved 30040
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id 30048
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id 30061
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments 30074
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments 30077
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments 30080
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments 30083
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments 30086
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments 30088
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState 30089
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate 30090
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType 30092
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate 30093
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId 30095
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType 30096
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode 30097
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName 30098
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time 30099
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime 30100
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message 30102
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity 30103
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId 30104
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName 30105
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName 30108
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId 30109
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain 30110
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState 30111
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id 30112
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality 30120
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp 30121
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity 30122
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 30123
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment 30124
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp 30125
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId 30126
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments 30130
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState 30131
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id 30132
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id 30141
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments 30150
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments 30152
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState 30153
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id 30154
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode 30162
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id 30164
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id 30173
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState 30182
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 30183
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 30188
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 30195
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 30197
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 30199
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 30202
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 30205
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved 30206
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id 30214
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id 30227
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments 30240
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments 30243
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 30246
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments 30249
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments 30252
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 30254
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState 30255
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId 30256
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime 30257
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency 30258
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Size 30261
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Writable 30262
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable 30263
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount 30264
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments 30269
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments 30270
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments 30272
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments 30274
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments 30275
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments 30277
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments 30279
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments 30280
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments 30282
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime 30283
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments 30287
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments 30288
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments 30290
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments 30291
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments 30293
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments 30295
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateTypes 30296
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments 30299
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId 30301
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType 30302
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode 30303
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName 30304
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time 30305
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime 30306
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message 30308
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity 30309
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId 30310
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName 30311
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName 30314
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId 30315
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain 30316
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState 30317
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id 30318
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality 30326
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp 30327
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity 30328
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp 30329
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment 30330
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp 30331
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId 30332
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments 30336
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState 30337
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id 30338
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id 30347
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments 30356
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments 30358
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState 30359
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id 30360
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode 30368
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id 30370
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id 30379
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState 30388
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id 30389
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id 30394
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime 30401
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 30403
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 30405
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 30408
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 30411
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved 30412
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id 30420
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id 30433
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments 30446
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments 30449
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments 30452
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments 30455
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments 30458
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments 30460
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState 30461
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate 30462
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType 30464
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate 30465
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId 30467
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType 30468
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode 30469
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName 30470
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time 30471
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime 30472
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message 30474
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity 30475
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId 30476
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName 30477
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName 30480
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId 30481
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain 30482
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState 30483
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id 30484
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality 30492
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp 30493
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity 30494
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 30495
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment 30496
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp 30497
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId 30498
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments 30502
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState 30503
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id 30504
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id 30513
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments 30522
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments 30524
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState 30525
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id 30526
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode 30534
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id 30536
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id 30545
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState 30554
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 30555
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 30560
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 30567
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 30569
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 30571
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 30574
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 30577
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved 30578
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id 30586
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id 30599
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments 30612
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments 30615
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 30618
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments 30621
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments 30624
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 30626
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState 30627
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId 30628
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime 30629
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency 30630
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Size 30633
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable 30634
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable 30635
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount 30636
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments 30641
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments 30642
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments 30644
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments 30646
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments 30647
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments 30649
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments 30651
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments 30652
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments 30654
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime 30655
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments 30659
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments 30660
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments 30662
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments 30663
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments 30665
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments 30667
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateTypes 30668
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments 30671
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId 30673
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType 30674
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode 30675
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName 30676
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time 30677
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime 30678
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message 30680
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity 30681
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId 30682
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName 30683
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName 30686
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId 30687
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain 30688
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState 30689
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id 30690
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality 30698
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp 30699
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity 30700
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp 30701
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment 30702
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp 30703
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId 30704
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments 30708
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState 30709
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id 30710
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id 30719
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments 30728
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments 30730
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState 30731
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id 30732
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode 30740
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id 30742
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id 30751
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState 30760
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id 30761
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id 30766
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime 30773
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments 30775
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments 30777
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments 30780
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments 30783
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved 30784
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id 30792
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id 30805
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments 30818
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments 30821
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments 30824
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments 30827
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments 30830
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments 30832
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState 30833
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate 30834
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType 30836
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate 30837
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId 30839
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType 30840
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode 30841
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName 30842
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time 30843
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime 30844
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message 30846
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity 30847
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId 30848
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName 30849
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName 30852
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId 30853
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain 30854
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState 30855
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id 30856
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality 30864
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp 30865
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity 30866
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp 30867
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment 30868
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp 30869
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId 30870
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments 30874
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState 30875
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id 30876
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id 30885
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments 30894
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments 30896
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState 30897
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id 30898
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode 30906
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id 30908
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id 30917
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState 30926
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id 30927
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id 30932
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime 30939
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments 30941
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments 30943
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments 30946
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments 30949
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved 30950
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id 30958
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id 30971
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments 30984
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments 30987
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments 30990
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments 30993
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments 30996
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments 30998
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState 30999
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId 31000
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime 31001
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency 31002
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_ApplicationUri 31376
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_ProductUri 31377
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_ApplicationType 31378
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_ServerCapabilities 31379
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_SupportedPrivateKeyFormats 31380
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_MaxTrustListSize 31381
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_MulticastDnsEnabled 31382
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_UpdateCertificate_InputArguments 31385
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_UpdateCertificate_OutputArguments 31386
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_GetCertificates_InputArguments 32373
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_GetCertificates_OutputArguments 32374
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CreateSigningRequest_InputArguments 31390
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_CreateSigningRequest_OutputArguments 31391
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_GetRejectedList_OutputArguments 31393
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_TransactionDiagnostics_StartTime 32376
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_TransactionDiagnostics_EndTime 32377
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_TransactionDiagnostics_Result 32378
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_TransactionDiagnostics_AffectedTrustLists 32379
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_TransactionDiagnostics_AffectedCertificateGroups 32380
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_TransactionDiagnostics_Errors 32381
#define OpcUaId_ProvisionableDevice_ApplicationName_Placeholder_Enabled 31375
#define OpcUaId_IIetfBaseNetworkInterfaceType_AdminStatus 24149
#define OpcUaId_IIetfBaseNetworkInterfaceType_OperStatus 24150
#define OpcUaId_IIetfBaseNetworkInterfaceType_PhysAddress 24151
#define OpcUaId_IIetfBaseNetworkInterfaceType_Speed 24152
#define OpcUaId_IIetfBaseNetworkInterfaceType_Speed_EngineeringUnits 24157
#define OpcUaId_IIeeeBaseEthernetPortType_Speed 24159
#define OpcUaId_IIeeeBaseEthernetPortType_Speed_EngineeringUnits 24164
#define OpcUaId_IIeeeBaseEthernetPortType_Duplex 24165
#define OpcUaId_IIeeeBaseEthernetPortType_MaxFrameLength 24166
#define OpcUaId_IIeeeAutoNegotiationStatusType_NegotiationStatus 24234
#define OpcUaId_IBaseEthernetCapabilitiesType_VlanTagCapable 24168
#define OpcUaId_IVlanIdType_VlanId 25219
#define OpcUaId_ISrClassType_Id 24170
#define OpcUaId_ISrClassType_Priority 24171
#define OpcUaId_ISrClassType_Vid 24172
#define OpcUaId_IIeeeBaseTsnStreamType_StreamId 24174
#define OpcUaId_IIeeeBaseTsnStreamType_StreamName 24175
#define OpcUaId_IIeeeBaseTsnStreamType_State 24176
#define OpcUaId_IIeeeBaseTsnStreamType_AccumulatedLatency 24177
#define OpcUaId_IIeeeBaseTsnStreamType_SrClassId 24178
#define OpcUaId_IIeeeBaseTsnTrafficSpecificationType_MaxIntervalFrames 24180
#define OpcUaId_IIeeeBaseTsnTrafficSpecificationType_MaxFrameSize 24181
#define OpcUaId_IIeeeBaseTsnTrafficSpecificationType_Interval 24182
#define OpcUaId_IIeeeBaseTsnStatusStreamType_TalkerStatus 24184
#define OpcUaId_IIeeeBaseTsnStatusStreamType_ListenerStatus 24185
#define OpcUaId_IIeeeBaseTsnStatusStreamType_FailureCode 24186
#define OpcUaId_IIeeeBaseTsnStatusStreamType_FailureSystemIdentifier 24187
#define OpcUaId_IIeeeTsnInterfaceConfigurationType_MacAddress 24189
#define OpcUaId_IIeeeTsnInterfaceConfigurationType_InterfaceName 24190
#define OpcUaId_IIeeeTsnInterfaceConfigurationTalkerType_TimeAwareOffset 24194
#define OpcUaId_IIeeeTsnInterfaceConfigurationListenerType_ReceiveOffset 24198
#define OpcUaId_IIeeeTsnMacAddressType_DestinationAddress 24200
#define OpcUaId_IIeeeTsnMacAddressType_SourceAddress 24201
#define OpcUaId_IIeeeTsnVlanTagType_VlanId 24203
#define OpcUaId_IIeeeTsnVlanTagType_PriorityCodePoint 24204
#define OpcUaId_IPriorityMappingEntryType_MappingUri 24206
#define OpcUaId_IPriorityMappingEntryType_PriorityLabel 24207
#define OpcUaId_IPriorityMappingEntryType_PriorityValue_PCP 24208
#define OpcUaId_IPriorityMappingEntryType_PriorityValue_DSCP 24209
#define OpcUaId_Duplex_EnumValues 24235
#define OpcUaId_InterfaceAdminStatus_EnumValues 24236
#define OpcUaId_InterfaceOperStatus_EnumValues 24237
#define OpcUaId_NegotiationStatus_EnumValues 24238
#define OpcUaId_TsnFailureCode_EnumValues 24239
#define OpcUaId_TsnStreamState_EnumValues 24240
#define OpcUaId_TsnTalkerStatus_EnumValues 24241
#define OpcUaId_TsnListenerStatus_EnumValues 24242
#define OpcUaId_IetfBaseNetworkInterfaceType_AdminStatus 25222
#define OpcUaId_IetfBaseNetworkInterfaceType_OperStatus 25223
#define OpcUaId_IetfBaseNetworkInterfaceType_PhysAddress 25224
#define OpcUaId_IetfBaseNetworkInterfaceType_Speed 25225
#define OpcUaId_IetfBaseNetworkInterfaceType_Speed_EngineeringUnits 25252
#define OpcUaId_PriorityMappingTableType_PriorityMapppingEntries 25228
#define OpcUaId_PriorityMappingTableType_AddPriorityMappingEntry_InputArguments 25230
#define OpcUaId_PriorityMappingTableType_DeletePriorityMappingEntry_InputArguments 25232
#define OpcUaId_ReferenceDescriptionVariableType_ReferenceRefinement 32658
#define OpcUaId_IdType_EnumStrings 7591
#define OpcUaId_NodeClass_EnumValues 11878
#define OpcUaId_PermissionType_OptionSetValues 15030
#define OpcUaId_AccessLevelType_OptionSetValues 15032
#define OpcUaId_AccessLevelExType_OptionSetValues 15407
#define OpcUaId_EventNotifierType_OptionSetValues 15034
#define OpcUaId_AccessRestrictionType_OptionSetValues 15035
#define OpcUaId_StructureType_EnumStrings 14528
#define OpcUaId_ApplicationType_EnumStrings 7597
#define OpcUaId_MessageSecurityMode_EnumStrings 7595
#define OpcUaId_UserTokenType_EnumStrings 7596
#define OpcUaId_SecurityTokenRequestType_EnumStrings 7598
#define OpcUaId_NodeAttributesMask_EnumValues 11881
#define OpcUaId_AttributeWriteMask_OptionSetValues 15036
#define OpcUaId_BrowseDirection_EnumStrings 7603
#define OpcUaId_BrowseResultMask_EnumValues 11883
#define OpcUaId_FilterOperator_EnumStrings 7605
#define OpcUaId_TimestampsToReturn_EnumStrings 7606
#define OpcUaId_HistoryUpdateType_EnumValues 11884
#define OpcUaId_PerformUpdateType_EnumValues 11885
#define OpcUaId_MonitoringMode_EnumStrings 7608
#define OpcUaId_DataChangeTrigger_EnumStrings 7609
#define OpcUaId_DeadbandType_EnumStrings 7610
#define OpcUaId_RedundancySupport_EnumStrings 7611
#define OpcUaId_ServerState_EnumStrings 7612
#define OpcUaId_ModelChangeStructureVerbMask_EnumValues 11942
#define OpcUaId_AxisScaleEnumeration_EnumStrings 12078
#define OpcUaId_ExceptionDeviationFormat_EnumStrings 7614
#define OpcUaId_OpcUa_BinarySchema 7617
#define OpcUaId_OpcUa_BinarySchema_NamespaceUri 7619
#define OpcUaId_OpcUa_BinarySchema_Deprecated 15037
#define OpcUaId_OpcUa_BinarySchema_Union 12770
#define OpcUaId_OpcUa_BinarySchema_KeyValuePair 14873
#define OpcUaId_OpcUa_BinarySchema_AdditionalParametersType 17538
#define OpcUaId_OpcUa_BinarySchema_EphemeralKeyType 17550
#define OpcUaId_OpcUa_BinarySchema_EndpointType 15734
#define OpcUaId_OpcUa_BinarySchema_RationalNumber 18824
#define OpcUaId_OpcUa_BinarySchema_Vector 18827
#define OpcUaId_OpcUa_BinarySchema_ThreeDVector 18830
#define OpcUaId_OpcUa_BinarySchema_CartesianCoordinates 18833
#define OpcUaId_OpcUa_BinarySchema_ThreeDCartesianCoordinates 18836
#define OpcUaId_OpcUa_BinarySchema_Orientation 18839
#define OpcUaId_OpcUa_BinarySchema_ThreeDOrientation 18842
#define OpcUaId_OpcUa_BinarySchema_Frame 18845
#define OpcUaId_OpcUa_BinarySchema_ThreeDFrame 18848
#define OpcUaId_OpcUa_BinarySchema_IdentityMappingRuleType 15738
#define OpcUaId_OpcUa_BinarySchema_CurrencyUnitType 23514
#define OpcUaId_OpcUa_BinarySchema_TrustListDataType 12681
#define OpcUaId_OpcUa_BinarySchema_TransactionErrorType 32383
#define OpcUaId_OpcUa_BinarySchema_DataTypeSchemaHeader 15741
#define OpcUaId_OpcUa_BinarySchema_DataTypeDescription 14855
#define OpcUaId_OpcUa_BinarySchema_StructureDescription 15599
#define OpcUaId_OpcUa_BinarySchema_EnumDescription 15602
#define OpcUaId_OpcUa_BinarySchema_SimpleTypeDescription 15501
#define OpcUaId_OpcUa_BinarySchema_UABinaryFileDataType 15521
#define OpcUaId_OpcUa_BinarySchema_PortableQualifiedName 24111
#define OpcUaId_OpcUa_BinarySchema_PortableNodeId 24114
#define OpcUaId_OpcUa_BinarySchema_UnsignedRationalNumber 24117
#define OpcUaId_OpcUa_BinarySchema_DataSetMetaDataType 14849
#define OpcUaId_OpcUa_BinarySchema_FieldMetaData 14852
#define OpcUaId_OpcUa_BinarySchema_ConfigurationVersionDataType 14876
#define OpcUaId_OpcUa_BinarySchema_PublishedDataSetDataType 15766
#define OpcUaId_OpcUa_BinarySchema_PublishedDataSetSourceDataType 15769
#define OpcUaId_OpcUa_BinarySchema_PublishedVariableDataType 14324
#define OpcUaId_OpcUa_BinarySchema_PublishedDataItemsDataType 15772
#define OpcUaId_OpcUa_BinarySchema_PublishedEventsDataType 15775
#define OpcUaId_OpcUa_BinarySchema_PublishedDataSetCustomSourceDataType 25533
#define OpcUaId_OpcUa_BinarySchema_DataSetWriterDataType 15778
#define OpcUaId_OpcUa_BinarySchema_DataSetWriterTransportDataType 15781
#define OpcUaId_OpcUa_BinarySchema_DataSetWriterMessageDataType 15784
#define OpcUaId_OpcUa_BinarySchema_PubSubGroupDataType 15787
#define OpcUaId_OpcUa_BinarySchema_WriterGroupDataType 21156
#define OpcUaId_OpcUa_BinarySchema_WriterGroupTransportDataType 15793
#define OpcUaId_OpcUa_BinarySchema_WriterGroupMessageDataType 15854
#define OpcUaId_OpcUa_BinarySchema_PubSubConnectionDataType 15857
#define OpcUaId_OpcUa_BinarySchema_ConnectionTransportDataType 15860
#define OpcUaId_OpcUa_BinarySchema_NetworkAddressDataType 21159
#define OpcUaId_OpcUa_BinarySchema_NetworkAddressUrlDataType 21162
#define OpcUaId_OpcUa_BinarySchema_ReaderGroupDataType 21165
#define OpcUaId_OpcUa_BinarySchema_ReaderGroupTransportDataType 15866
#define OpcUaId_OpcUa_BinarySchema_ReaderGroupMessageDataType 15869
#define OpcUaId_OpcUa_BinarySchema_DataSetReaderDataType 15872
#define OpcUaId_OpcUa_BinarySchema_DataSetReaderTransportDataType 15877
#define OpcUaId_OpcUa_BinarySchema_DataSetReaderMessageDataType 15880
#define OpcUaId_OpcUa_BinarySchema_SubscribedDataSetDataType 15883
#define OpcUaId_OpcUa_BinarySchema_TargetVariablesDataType 15886
#define OpcUaId_OpcUa_BinarySchema_FieldTargetDataType 21002
#define OpcUaId_OpcUa_BinarySchema_SubscribedDataSetMirrorDataType 15889
#define OpcUaId_OpcUa_BinarySchema_PubSubConfigurationDataType 21168
#define OpcUaId_OpcUa_BinarySchema_StandaloneSubscribedDataSetRefDataType 23870
#define OpcUaId_OpcUa_BinarySchema_StandaloneSubscribedDataSetDataType 23873
#define OpcUaId_OpcUa_BinarySchema_SecurityGroupDataType 23876
#define OpcUaId_OpcUa_BinarySchema_PubSubKeyPushTargetDataType 25536
#define OpcUaId_OpcUa_BinarySchema_PubSubConfiguration2DataType 23879
#define OpcUaId_OpcUa_BinarySchema_UadpWriterGroupMessageDataType 15895
#define OpcUaId_OpcUa_BinarySchema_UadpDataSetWriterMessageDataType 15898
#define OpcUaId_OpcUa_BinarySchema_UadpDataSetReaderMessageDataType 15919
#define OpcUaId_OpcUa_BinarySchema_JsonWriterGroupMessageDataType 15922
#define OpcUaId_OpcUa_BinarySchema_JsonDataSetWriterMessageDataType 15925
#define OpcUaId_OpcUa_BinarySchema_JsonDataSetReaderMessageDataType 15931
#define OpcUaId_OpcUa_BinarySchema_QosDataType 23882
#define OpcUaId_OpcUa_BinarySchema_TransmitQosDataType 23885
#define OpcUaId_OpcUa_BinarySchema_TransmitQosPriorityDataType 23888
#define OpcUaId_OpcUa_BinarySchema_ReceiveQosDataType 23897
#define OpcUaId_OpcUa_BinarySchema_ReceiveQosPriorityDataType 23900
#define OpcUaId_OpcUa_BinarySchema_DatagramConnectionTransportDataType 17469
#define OpcUaId_OpcUa_BinarySchema_DatagramConnectionTransport2DataType 23909
#define OpcUaId_OpcUa_BinarySchema_DatagramWriterGroupTransportDataType 21171
#define OpcUaId_OpcUa_BinarySchema_DatagramWriterGroupTransport2DataType 23912
#define OpcUaId_OpcUa_BinarySchema_DatagramDataSetReaderTransportDataType 23915
#define OpcUaId_OpcUa_BinarySchema_BrokerConnectionTransportDataType 15524
#define OpcUaId_OpcUa_BinarySchema_BrokerWriterGroupTransportDataType 15940
#define OpcUaId_OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType 15943
#define OpcUaId_OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType 15946
#define OpcUaId_OpcUa_BinarySchema_PubSubConfigurationRefDataType 25539
#define OpcUaId_OpcUa_BinarySchema_PubSubConfigurationValueDataType 25542
#define OpcUaId_OpcUa_BinarySchema_AliasNameDataType 23502
#define OpcUaId_OpcUa_BinarySchema_UserManagementDataType 24293
#define OpcUaId_OpcUa_BinarySchema_PriorityMappingEntryType 25240
#define OpcUaId_OpcUa_BinarySchema_ReferenceDescriptionDataType 32663
#define OpcUaId_OpcUa_BinarySchema_ReferenceListEntryDataType 32666
#define OpcUaId_OpcUa_BinarySchema_RolePermissionType 16131
#define OpcUaId_OpcUa_BinarySchema_DataTypeDefinition 18178
#define OpcUaId_OpcUa_BinarySchema_StructureField 18181
#define OpcUaId_OpcUa_BinarySchema_StructureDefinition 18184
#define OpcUaId_OpcUa_BinarySchema_EnumDefinition 18187
#define OpcUaId_OpcUa_BinarySchema_Argument 7650
#define OpcUaId_OpcUa_BinarySchema_EnumValueType 7656
#define OpcUaId_OpcUa_BinarySchema_EnumField 14870
#define OpcUaId_OpcUa_BinarySchema_OptionSet 12767
#define OpcUaId_OpcUa_BinarySchema_TimeZoneDataType 8914
#define OpcUaId_OpcUa_BinarySchema_ApplicationDescription 7665
#define OpcUaId_OpcUa_BinarySchema_ServerOnNetwork 12213
#define OpcUaId_OpcUa_BinarySchema_UserTokenPolicy 7662
#define OpcUaId_OpcUa_BinarySchema_EndpointDescription 7668
#define OpcUaId_OpcUa_BinarySchema_RegisteredServer 7782
#define OpcUaId_OpcUa_BinarySchema_DiscoveryConfiguration 12902
#define OpcUaId_OpcUa_BinarySchema_MdnsDiscoveryConfiguration 12905
#define OpcUaId_OpcUa_BinarySchema_SignedSoftwareCertificate 7698
#define OpcUaId_OpcUa_BinarySchema_UserIdentityToken 7671
#define OpcUaId_OpcUa_BinarySchema_AnonymousIdentityToken 7674
#define OpcUaId_OpcUa_BinarySchema_UserNameIdentityToken 7677
#define OpcUaId_OpcUa_BinarySchema_X509IdentityToken 7680
#define OpcUaId_OpcUa_BinarySchema_IssuedIdentityToken 7683
#define OpcUaId_OpcUa_BinarySchema_AddNodesItem 7728
#define OpcUaId_OpcUa_BinarySchema_AddReferencesItem 7731
#define OpcUaId_OpcUa_BinarySchema_DeleteNodesItem 7734
#define OpcUaId_OpcUa_BinarySchema_DeleteReferencesItem 7737
#define OpcUaId_OpcUa_BinarySchema_RelativePathElement 12718
#define OpcUaId_OpcUa_BinarySchema_RelativePath 12721
#define OpcUaId_OpcUa_BinarySchema_EndpointConfiguration 7686
#define OpcUaId_OpcUa_BinarySchema_ContentFilterElement 7929
#define OpcUaId_OpcUa_BinarySchema_ContentFilter 7932
#define OpcUaId_OpcUa_BinarySchema_FilterOperand 7935
#define OpcUaId_OpcUa_BinarySchema_ElementOperand 7938
#define OpcUaId_OpcUa_BinarySchema_LiteralOperand 7941
#define OpcUaId_OpcUa_BinarySchema_AttributeOperand 7944
#define OpcUaId_OpcUa_BinarySchema_SimpleAttributeOperand 7947
#define OpcUaId_OpcUa_BinarySchema_HistoryEvent 8004
#define OpcUaId_OpcUa_BinarySchema_MonitoringFilter 8067
#define OpcUaId_OpcUa_BinarySchema_EventFilter 8073
#define OpcUaId_OpcUa_BinarySchema_AggregateConfiguration 8076
#define OpcUaId_OpcUa_BinarySchema_HistoryEventFieldList 8172
#define OpcUaId_OpcUa_BinarySchema_BuildInfo 7692
#define OpcUaId_OpcUa_BinarySchema_RedundantServerDataType 8208
#define OpcUaId_OpcUa_BinarySchema_EndpointUrlListDataType 11959
#define OpcUaId_OpcUa_BinarySchema_NetworkGroupDataType 11962
#define OpcUaId_OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType 8211
#define OpcUaId_OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType 8214
#define OpcUaId_OpcUa_BinarySchema_ServerStatusDataType 8217
#define OpcUaId_OpcUa_BinarySchema_SessionDiagnosticsDataType 8220
#define OpcUaId_OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType 8223
#define OpcUaId_OpcUa_BinarySchema_ServiceCounterDataType 8226
#define OpcUaId_OpcUa_BinarySchema_StatusResult 7659
#define OpcUaId_OpcUa_BinarySchema_SubscriptionDiagnosticsDataType 8229
#define OpcUaId_OpcUa_BinarySchema_ModelChangeStructureDataType 8232
#define OpcUaId_OpcUa_BinarySchema_SemanticChangeStructureDataType 8235
#define OpcUaId_OpcUa_BinarySchema_Range 8238
#define OpcUaId_OpcUa_BinarySchema_EUInformation 8241
#define OpcUaId_OpcUa_BinarySchema_ComplexNumberType 12183
#define OpcUaId_OpcUa_BinarySchema_DoubleComplexNumberType 12186
#define OpcUaId_OpcUa_BinarySchema_AxisInformation 12091
#define OpcUaId_OpcUa_BinarySchema_XVType 12094
#define OpcUaId_OpcUa_BinarySchema_ProgramDiagnosticDataType 8247
#define OpcUaId_OpcUa_BinarySchema_ProgramDiagnostic2DataType 24035
#define OpcUaId_OpcUa_BinarySchema_Annotation 8244
#define OpcUaId_OpcUa_XmlSchema 8252
#define OpcUaId_OpcUa_XmlSchema_NamespaceUri 8254
#define OpcUaId_OpcUa_XmlSchema_Deprecated 15039
#define OpcUaId_OpcUa_XmlSchema_Union 12762
#define OpcUaId_OpcUa_XmlSchema_KeyValuePair 14829
#define OpcUaId_OpcUa_XmlSchema_AdditionalParametersType 17542
#define OpcUaId_OpcUa_XmlSchema_EphemeralKeyType 17554
#define OpcUaId_OpcUa_XmlSchema_EndpointType 16024
#define OpcUaId_OpcUa_XmlSchema_RationalNumber 18860
#define OpcUaId_OpcUa_XmlSchema_Vector 18863
#define OpcUaId_OpcUa_XmlSchema_ThreeDVector 18866
#define OpcUaId_OpcUa_XmlSchema_CartesianCoordinates 18869
#define OpcUaId_OpcUa_XmlSchema_ThreeDCartesianCoordinates 19049
#define OpcUaId_OpcUa_XmlSchema_Orientation 19052
#define OpcUaId_OpcUa_XmlSchema_ThreeDOrientation 19055
#define OpcUaId_OpcUa_XmlSchema_Frame 19058
#define OpcUaId_OpcUa_XmlSchema_ThreeDFrame 19061
#define OpcUaId_OpcUa_XmlSchema_IdentityMappingRuleType 15730
#define OpcUaId_OpcUa_XmlSchema_CurrencyUnitType 23522
#define OpcUaId_OpcUa_XmlSchema_TrustListDataType 12677
#define OpcUaId_OpcUa_XmlSchema_TransactionErrorType 32387
#define OpcUaId_OpcUa_XmlSchema_DataTypeSchemaHeader 16027
#define OpcUaId_OpcUa_XmlSchema_DataTypeDescription 14811
#define OpcUaId_OpcUa_XmlSchema_StructureDescription 15591
#define OpcUaId_OpcUa_XmlSchema_EnumDescription 15594
#define OpcUaId_OpcUa_XmlSchema_SimpleTypeDescription 15585
#define OpcUaId_OpcUa_XmlSchema_UABinaryFileDataType 15588
#define OpcUaId_OpcUa_XmlSchema_PortableQualifiedName 24123
#define OpcUaId_OpcUa_XmlSchema_PortableNodeId 24126
#define OpcUaId_OpcUa_XmlSchema_UnsignedRationalNumber 24129
#define OpcUaId_OpcUa_XmlSchema_DataSetMetaDataType 14805
#define OpcUaId_OpcUa_XmlSchema_FieldMetaData 14808
#define OpcUaId_OpcUa_XmlSchema_ConfigurationVersionDataType 14832
#define OpcUaId_OpcUa_XmlSchema_PublishedDataSetDataType 16030
#define OpcUaId_OpcUa_XmlSchema_PublishedDataSetSourceDataType 16033
#define OpcUaId_OpcUa_XmlSchema_PublishedVariableDataType 14320
#define OpcUaId_OpcUa_XmlSchema_PublishedDataItemsDataType 16037
#define OpcUaId_OpcUa_XmlSchema_PublishedEventsDataType 16040
#define OpcUaId_OpcUa_XmlSchema_PublishedDataSetCustomSourceDataType 25549
#define OpcUaId_OpcUa_XmlSchema_DataSetWriterDataType 16047
#define OpcUaId_OpcUa_XmlSchema_DataSetWriterTransportDataType 16050
#define OpcUaId_OpcUa_XmlSchema_DataSetWriterMessageDataType 16053
#define OpcUaId_OpcUa_XmlSchema_PubSubGroupDataType 16056
#define OpcUaId_OpcUa_XmlSchema_WriterGroupDataType 21180
#define OpcUaId_OpcUa_XmlSchema_WriterGroupTransportDataType 16062
#define OpcUaId_OpcUa_XmlSchema_WriterGroupMessageDataType 16065
#define OpcUaId_OpcUa_XmlSchema_PubSubConnectionDataType 16068
#define OpcUaId_OpcUa_XmlSchema_ConnectionTransportDataType 16071
#define OpcUaId_OpcUa_XmlSchema_NetworkAddressDataType 21183
#define OpcUaId_OpcUa_XmlSchema_NetworkAddressUrlDataType 21186
#define OpcUaId_OpcUa_XmlSchema_ReaderGroupDataType 21189
#define OpcUaId_OpcUa_XmlSchema_ReaderGroupTransportDataType 16077
#define OpcUaId_OpcUa_XmlSchema_ReaderGroupMessageDataType 16080
#define OpcUaId_OpcUa_XmlSchema_DataSetReaderDataType 16083
#define OpcUaId_OpcUa_XmlSchema_DataSetReaderTransportDataType 16086
#define OpcUaId_OpcUa_XmlSchema_DataSetReaderMessageDataType 16089
#define OpcUaId_OpcUa_XmlSchema_SubscribedDataSetDataType 16092
#define OpcUaId_OpcUa_XmlSchema_TargetVariablesDataType 16095
#define OpcUaId_OpcUa_XmlSchema_FieldTargetDataType 14835
#define OpcUaId_OpcUa_XmlSchema_SubscribedDataSetMirrorDataType 16098
#define OpcUaId_OpcUa_XmlSchema_PubSubConfigurationDataType 21192
#define OpcUaId_OpcUa_XmlSchema_StandaloneSubscribedDataSetRefDataType 23938
#define OpcUaId_OpcUa_XmlSchema_StandaloneSubscribedDataSetDataType 23941
#define OpcUaId_OpcUa_XmlSchema_SecurityGroupDataType 23944
#define OpcUaId_OpcUa_XmlSchema_PubSubKeyPushTargetDataType 25552
#define OpcUaId_OpcUa_XmlSchema_PubSubConfiguration2DataType 23947
#define OpcUaId_OpcUa_XmlSchema_UadpWriterGroupMessageDataType 16104
#define OpcUaId_OpcUa_XmlSchema_UadpDataSetWriterMessageDataType 16107
#define OpcUaId_OpcUa_XmlSchema_UadpDataSetReaderMessageDataType 16110
#define OpcUaId_OpcUa_XmlSchema_JsonWriterGroupMessageDataType 16113
#define OpcUaId_OpcUa_XmlSchema_JsonDataSetWriterMessageDataType 16116
#define OpcUaId_OpcUa_XmlSchema_JsonDataSetReaderMessageDataType 16119
#define OpcUaId_OpcUa_XmlSchema_QosDataType 23950
#define OpcUaId_OpcUa_XmlSchema_TransmitQosDataType 23953
#define OpcUaId_OpcUa_XmlSchema_TransmitQosPriorityDataType 23956
#define OpcUaId_OpcUa_XmlSchema_ReceiveQosDataType 23965
#define OpcUaId_OpcUa_XmlSchema_ReceiveQosPriorityDataType 23968
#define OpcUaId_OpcUa_XmlSchema_DatagramConnectionTransportDataType 17473
#define OpcUaId_OpcUa_XmlSchema_DatagramConnectionTransport2DataType 23977
#define OpcUaId_OpcUa_XmlSchema_DatagramWriterGroupTransportDataType 21195
#define OpcUaId_OpcUa_XmlSchema_DatagramWriterGroupTransport2DataType 23980
#define OpcUaId_OpcUa_XmlSchema_DatagramDataSetReaderTransportDataType 23983
#define OpcUaId_OpcUa_XmlSchema_BrokerConnectionTransportDataType 15640
#define OpcUaId_OpcUa_XmlSchema_BrokerWriterGroupTransportDataType 16125
#define OpcUaId_OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType 16144
#define OpcUaId_OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType 16147
#define OpcUaId_OpcUa_XmlSchema_PubSubConfigurationRefDataType 25555
#define OpcUaId_OpcUa_XmlSchema_PubSubConfigurationValueDataType 25558
#define OpcUaId_OpcUa_XmlSchema_AliasNameDataType 23508
#define OpcUaId_OpcUa_XmlSchema_UserManagementDataType 24297
#define OpcUaId_OpcUa_XmlSchema_PriorityMappingEntryType 25244
#define OpcUaId_OpcUa_XmlSchema_ReferenceDescriptionDataType 32671
#define OpcUaId_OpcUa_XmlSchema_ReferenceListEntryDataType 32674
#define OpcUaId_OpcUa_XmlSchema_RolePermissionType 16127
#define OpcUaId_OpcUa_XmlSchema_DataTypeDefinition 18166
#define OpcUaId_OpcUa_XmlSchema_StructureField 18169
#define OpcUaId_OpcUa_XmlSchema_StructureDefinition 18172
#define OpcUaId_OpcUa_XmlSchema_EnumDefinition 18175
#define OpcUaId_OpcUa_XmlSchema_Argument 8285
#define OpcUaId_OpcUa_XmlSchema_EnumValueType 8291
#define OpcUaId_OpcUa_XmlSchema_EnumField 14826
#define OpcUaId_OpcUa_XmlSchema_OptionSet 12759
#define OpcUaId_OpcUa_XmlSchema_TimeZoneDataType 8918
#define OpcUaId_OpcUa_XmlSchema_ApplicationDescription 8300
#define OpcUaId_OpcUa_XmlSchema_ServerOnNetwork 12201
#define OpcUaId_OpcUa_XmlSchema_UserTokenPolicy 8297
#define OpcUaId_OpcUa_XmlSchema_EndpointDescription 8303
#define OpcUaId_OpcUa_XmlSchema_RegisteredServer 8417
#define OpcUaId_OpcUa_XmlSchema_DiscoveryConfiguration 12894
#define OpcUaId_OpcUa_XmlSchema_MdnsDiscoveryConfiguration 12897
#define OpcUaId_OpcUa_XmlSchema_SignedSoftwareCertificate 8333
#define OpcUaId_OpcUa_XmlSchema_UserIdentityToken 8306
#define OpcUaId_OpcUa_XmlSchema_AnonymousIdentityToken 8309
#define OpcUaId_OpcUa_XmlSchema_UserNameIdentityToken 8312
#define OpcUaId_OpcUa_XmlSchema_X509IdentityToken 8315
#define OpcUaId_OpcUa_XmlSchema_IssuedIdentityToken 8318
#define OpcUaId_OpcUa_XmlSchema_AddNodesItem 8363
#define OpcUaId_OpcUa_XmlSchema_AddReferencesItem 8366
#define OpcUaId_OpcUa_XmlSchema_DeleteNodesItem 8369
#define OpcUaId_OpcUa_XmlSchema_DeleteReferencesItem 8372
#define OpcUaId_OpcUa_XmlSchema_RelativePathElement 12712
#define OpcUaId_OpcUa_XmlSchema_RelativePath 12715
#define OpcUaId_OpcUa_XmlSchema_EndpointConfiguration 8321
#define OpcUaId_OpcUa_XmlSchema_ContentFilterElement 8564
#define OpcUaId_OpcUa_XmlSchema_ContentFilter 8567
#define OpcUaId_OpcUa_XmlSchema_FilterOperand 8570
#define OpcUaId_OpcUa_XmlSchema_ElementOperand 8573
#define OpcUaId_OpcUa_XmlSchema_LiteralOperand 8576
#define OpcUaId_OpcUa_XmlSchema_AttributeOperand 8579
#define OpcUaId_OpcUa_XmlSchema_SimpleAttributeOperand 8582
#define OpcUaId_OpcUa_XmlSchema_HistoryEvent 8639
#define OpcUaId_OpcUa_XmlSchema_MonitoringFilter 8702
#define OpcUaId_OpcUa_XmlSchema_EventFilter 8708
#define OpcUaId_OpcUa_XmlSchema_AggregateConfiguration 8711
#define OpcUaId_OpcUa_XmlSchema_HistoryEventFieldList 8807
#define OpcUaId_OpcUa_XmlSchema_BuildInfo 8327
#define OpcUaId_OpcUa_XmlSchema_RedundantServerDataType 8843
#define OpcUaId_OpcUa_XmlSchema_EndpointUrlListDataType 11951
#define OpcUaId_OpcUa_XmlSchema_NetworkGroupDataType 11954
#define OpcUaId_OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType 8846
#define OpcUaId_OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType 8849
#define OpcUaId_OpcUa_XmlSchema_ServerStatusDataType 8852
#define OpcUaId_OpcUa_XmlSchema_SessionDiagnosticsDataType 8855
#define OpcUaId_OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType 8858
#define OpcUaId_OpcUa_XmlSchema_ServiceCounterDataType 8861
#define OpcUaId_OpcUa_XmlSchema_StatusResult 8294
#define OpcUaId_OpcUa_XmlSchema_SubscriptionDiagnosticsDataType 8864
#define OpcUaId_OpcUa_XmlSchema_ModelChangeStructureDataType 8867
#define OpcUaId_OpcUa_XmlSchema_SemanticChangeStructureDataType 8870
#define OpcUaId_OpcUa_XmlSchema_Range 8873
#define OpcUaId_OpcUa_XmlSchema_EUInformation 8876
#define OpcUaId_OpcUa_XmlSchema_ComplexNumberType 12175
#define OpcUaId_OpcUa_XmlSchema_DoubleComplexNumberType 12178
#define OpcUaId_OpcUa_XmlSchema_AxisInformation 12083
#define OpcUaId_OpcUa_XmlSchema_XVType 12086
#define OpcUaId_OpcUa_XmlSchema_ProgramDiagnosticDataType 8882
#define OpcUaId_OpcUa_XmlSchema_ProgramDiagnostic2DataType 24039
#define OpcUaId_OpcUa_XmlSchema_Annotation 8879

/*============================================================================
* VariableType Identifiers
 *===========================================================================*/
#define OpcUaId_BaseVariableType 62
#define OpcUaId_BaseDataVariableType 63
#define OpcUaId_PropertyType 68
#define OpcUaId_DataTypeDescriptionType 69
#define OpcUaId_DataTypeDictionaryType 72
#define OpcUaId_ServerVendorCapabilityType 2137
#define OpcUaId_ServerStatusType 2138
#define OpcUaId_BuildInfoType 3051
#define OpcUaId_ServerDiagnosticsSummaryType 2150
#define OpcUaId_SamplingIntervalDiagnosticsArrayType 2164
#define OpcUaId_SamplingIntervalDiagnosticsType 2165
#define OpcUaId_SubscriptionDiagnosticsArrayType 2171
#define OpcUaId_SubscriptionDiagnosticsType 2172
#define OpcUaId_SessionDiagnosticsArrayType 2196
#define OpcUaId_SessionDiagnosticsVariableType 2197
#define OpcUaId_SessionSecurityDiagnosticsArrayType 2243
#define OpcUaId_SessionSecurityDiagnosticsType 2244
#define OpcUaId_OptionSetType 11487
#define OpcUaId_SelectionListType 16309
#define OpcUaId_AudioVariableType 17986
#define OpcUaId_StateVariableType 2755
#define OpcUaId_TransitionVariableType 2762
#define OpcUaId_FiniteStateVariableType 2760
#define OpcUaId_FiniteTransitionVariableType 2767
#define OpcUaId_GuardVariableType 15113
#define OpcUaId_ExpressionGuardVariableType 15128
#define OpcUaId_ElseGuardVariableType 15317
#define OpcUaId_RationalNumberType 17709
#define OpcUaId_VectorType 17714
#define OpcUaId_ThreeDVectorType 17716
#define OpcUaId_CartesianCoordinatesType 18772
#define OpcUaId_ThreeDCartesianCoordinatesType 18774
#define OpcUaId_OrientationType 18779
#define OpcUaId_ThreeDOrientationType 18781
#define OpcUaId_FrameType 18786
#define OpcUaId_ThreeDFrameType 18791
#define OpcUaId_DataItemType 2365
#define OpcUaId_BaseAnalogType 15318
#define OpcUaId_AnalogItemType 2368
#define OpcUaId_AnalogUnitType 17497
#define OpcUaId_AnalogUnitRangeType 17570
#define OpcUaId_DiscreteItemType 2372
#define OpcUaId_TwoStateDiscreteType 2373
#define OpcUaId_MultiStateDiscreteType 2376
#define OpcUaId_MultiStateValueDiscreteType 11238
#define OpcUaId_ArrayItemType 12021
#define OpcUaId_YArrayItemType 12029
#define OpcUaId_XYArrayItemType 12038
#define OpcUaId_ImageItemType 12047
#define OpcUaId_CubeItemType 12057
#define OpcUaId_NDimensionArrayItemType 12068
#define OpcUaId_TwoStateVariableType 8995
#define OpcUaId_ConditionVariableType 9002
#define OpcUaId_AlarmRateVariableType 17277
#define OpcUaId_AlarmStateVariableType 32244
#define OpcUaId_ProgramDiagnosticType 2380
#define OpcUaId_ProgramDiagnostic2Type 15383
#define OpcUaId_PubSubDiagnosticsCounterType 19725
#define OpcUaId_MultiStateDictionaryEntryDiscreteBaseType 19077
#define OpcUaId_MultiStateDictionaryEntryDiscreteType 19084
#define OpcUaId_ReferenceDescriptionVariableType 32657

#endif /* _OpcUa_Identifiers_H_ */
/* This is the last line of an autogenerated file. */
