<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Square Root of the Golden Ratio

> Square root of the [Golden ratio][@stdlib/constants/float64/phi] (φ).

<section class="usage">

## Usage

```javascript
var SQRT_PHI = require( '@stdlib/constants/float64/sqrt-phi' );
```

#### SQRT_PHI

Square root of the [golden ratio][@stdlib/constants/float64/phi].

```javascript
var bool = ( SQRT_PHI === 1.272019649514069 );
// returns true
```

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- TODO: better example -->

<!-- eslint no-undef: "error" -->

```javascript
var SQRT_PHI = require( '@stdlib/constants/float64/sqrt-phi' );

console.log( SQRT_PHI );
// => 1.272019649514069
```

</section>

<!-- /.examples -->

<section class="links">

[@stdlib/constants/float64/phi]: https://github.com/stdlib-js/constants/tree/main/float64/phi

</section>

<!-- /.links -->
