#!/bin/bash

cat > copyblob.txt <<EOF
// Copyright (C) 2004-2021 Artifex Software, Inc.
//
// This file is part of MuPDF.
//
// MuPDF is free software: you can redistribute it and/or modify it under the
// terms of the GNU Affero General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.
//
// MuPDF is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
// details.
//
// You should have received a copy of the GNU Affero General Public License
// along with MuPDF. If not, see <https://www.gnu.org/licenses/agpl-3.0.en.html>
//
// Alternative licensing terms are available from the licensor.
// For commercial licensing, see <https://www.artifex.com/> or contact
// Artifex Software, Inc., 1305 Grant Avenue - Suite 200, Novato,
// CA 94945, U.S.A., +1(415)492-9861, for further information.

EOF

for F in $(find platform source include -name '*.[ch]' -or -name '*.java' -or -name '*.js')
do
	if grep -q 'Copyright\|automatically generated file\|file was generated by\|DO NOT EDIT THIS FILE\|public domain' $F
	then
		touch .
	else
		echo $F
		cat copyblob.txt $F > copyblob-tmp.txt && mv copyblob-tmp.txt $F
	fi
done
