// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System;
using System.Runtime.CompilerServices;
using System.Runtime.InteropServices;

namespace System.Runtime.InteropServices
{
    /// <summary>
    /// This is used to mark our Interop APIs as generated by MCG so that MCG can skip them 
    /// Ideally we should be able to ignore them when they are blittable but we still would emit the structs & 
    /// enums today and I'd like to avoid that. 
    /// </summary> 
    [System.AttributeUsageAttribute(System.AttributeTargets.Method)]
    public class McgGeneratedNativeCallCodeAttribute : System.Attribute
    {
    }
}
