BEGIN;
CREATE TABLE Settings(db_model_version UNSIGNED INTEGER NOT NULL,max_task_attempts UNSIGNED INTEGER NOT NULL,max_link_task_attempts UNSIGNED INTEGER NOT NULL);
CREATE TABLE Device(id_device INTEGER PRIMARY KEY AUTOINCREMENT,uuid TEXT COLLATE NOCASE,scheme TEXT,is_removable BOOLEAN,is_present BOOLEAN,is_network BOOLEAN,last_seen UNSIGNED INTEGER,UNIQUE(uuid,scheme) ON CONFLICT FAIL);
CREATE TABLE DeviceMountpoint(device_id INTEGER,mrl TEXT COLLATE NOCASE,last_seen INTEGER,PRIMARY KEY(device_id, mrl) ON CONFLICT REPLACE,FOREIGN KEY(device_id) REFERENCES Device(id_device) ON DELETE CASCADE);
CREATE TABLE Folder(id_folder INTEGER PRIMARY KEY AUTOINCREMENT,path TEXT,name TEXT COLLATE NOCASE,parent_id UNSIGNED INTEGER,is_banned BOOLEAN NOT NULL DEFAULT 0,device_id UNSIGNED INTEGER,is_removable BOOLEAN NOT NULL,nb_audio UNSIGNED INTEGER NOT NULL DEFAULT 0,nb_video UNSIGNED INTEGER NOT NULL DEFAULT 0,FOREIGN KEY(parent_id) REFERENCES Folder(id_folder) ON DELETE CASCADE,FOREIGN KEY(device_id) REFERENCES Device(id_device) ON DELETE CASCADE,UNIQUE(path,device_id) ON CONFLICT FAIL);
CREATE VIRTUAL TABLE FolderFts USING FTS3(name)
CREATE TABLE IF NOT EXISTS 'FolderFts_content'(docid INTEGER PRIMARY KEY, 'c0name');
CREATE TABLE IF NOT EXISTS 'FolderFts_segments'(blockid INTEGER PRIMARY KEY, block BLOB);
CREATE TABLE IF NOT EXISTS 'FolderFts_segdir'(level INTEGER,idx INTEGER,start_block INTEGER,leaves_end_block INTEGER,end_block INTEGER,root BLOB,PRIMARY KEY(level, idx));
CREATE TABLE Thumbnail(id_thumbnail INTEGER PRIMARY KEY AUTOINCREMENT,mrl TEXT,status UNSIGNED INTEGER NOT NULL,nb_attempts UNSIGNED INTEGER DEFAULT 0,is_owned BOOLEAN NOT NULL,shared_counter INTEGER NOT NULL DEFAULT 0,file_size INTEGER,hash TEXT);
CREATE TABLE ThumbnailLinking(entity_id UNSIGNED INTEGER NOT NULL,entity_type UNSIGNED INTEGER NOT NULL,size_type UNSIGNED INTEGER NOT NULL,thumbnail_id UNSIGNED INTEGER NOT NULL,origin UNSIGNED INT NOT NULL,PRIMARY KEY(entity_id,entity_type,size_type),FOREIGN KEY(thumbnail_id) REFERENCES Thumbnail(id_thumbnail) ON DELETE CASCADE);
CREATE TABLE ThumbnailCleanup(id_request INTEGER PRIMARY KEY AUTOINCREMENT,mrl TEXT);
CREATE TABLE Media(id_media INTEGER PRIMARY KEY AUTOINCREMENT,type INTEGER,subtype INTEGER NOT NULL DEFAULT 0,duration INTEGER DEFAULT -1,last_position REAL DEFAULT -1,last_time INTEGER DEFAULT -1,play_count UNSIGNED INTEGER NOT NULL DEFAULT 0,last_played_date UNSIGNED INTEGER,insertion_date UNSIGNED INTEGER,release_date UNSIGNED INTEGER,title TEXT COLLATE NOCASE,filename TEXT COLLATE NOCASE,is_favorite BOOLEAN NOT NULL DEFAULT 0,is_present BOOLEAN NOT NULL DEFAULT 1,device_id INTEGER,nb_playlists UNSIGNED INTEGER NOT NULL DEFAULT 0,folder_id UNSIGNED INTEGER,import_type UNSIGNED INTEGER NOT NULL,group_id UNSIGNED INTEGER,forced_title BOOLEAN NOT NULL DEFAULT 0,artist_id UNSIGNED INTEGER,genre_id UNSIGNED INTEGER,track_number UNSIGEND INTEGER,album_id UNSIGNED INTEGER,disc_number UNSIGNED INTEGER,lyrics TEXT,FOREIGN KEY(group_id) REFERENCES MediaGroup(id_group) ON DELETE RESTRICT,FOREIGN KEY(folder_id) REFERENCES Folder(id_folder)FOREIGN KEY(artist_id) REFERENCES Artist(id_artist) ON DELETE SET NULL,FOREIGN KEY(genre_id) REFERENCES Genre(id_genre),FOREIGN KEY(album_id) REFERENCES Album(id_album)  ON DELETE SET NULL);
CREATE VIRTUAL TABLE MediaFts USING FTS3(title,labels)
CREATE TABLE IF NOT EXISTS 'MediaFts_content'(docid INTEGER PRIMARY KEY, 'c0title', 'c1labels');
CREATE TABLE IF NOT EXISTS 'MediaFts_segments'(blockid INTEGER PRIMARY KEY, block BLOB);
CREATE TABLE IF NOT EXISTS 'MediaFts_segdir'(level INTEGER,idx INTEGER,start_block INTEGER,leaves_end_block INTEGER,end_block INTEGER,root BLOB,PRIMARY KEY(level, idx));
CREATE TABLE File(id_file INTEGER PRIMARY KEY AUTOINCREMENT,media_id UNSIGNED INT DEFAULT NULL,playlist_id UNSIGNED INT DEFAULT NULL,mrl TEXT,type UNSIGNED INTEGER,last_modification_date UNSIGNED INT,size UNSIGNED INT,folder_id UNSIGNED INTEGER,is_removable BOOLEAN NOT NULL,is_external BOOLEAN NOT NULL,is_network BOOLEAN NOT NULL,FOREIGN KEY(media_id) REFERENCES Media(id_media) ON DELETE CASCADE,FOREIGN KEY(playlist_id) REFERENCES Playlist(id_playlist) ON DELETE CASCADE,FOREIGN KEY(folder_id) REFERENCES Folder(id_folder) ON DELETE CASCADE,UNIQUE(mrl,folder_id) ON CONFLICT FAIL);
CREATE TABLE Label(id_label INTEGER PRIMARY KEY AUTOINCREMENT,name TEXT UNIQUE ON CONFLICT FAIL);
CREATE TABLE LabelFileRelation(label_id INTEGER,media_id INTEGER,PRIMARY KEY(label_id,media_id),FOREIGN KEY(label_id) REFERENCES Label(id_label) ON DELETE CASCADE,FOREIGN KEY(media_id) REFERENCES Media(id_media) ON DELETE CASCADE);
CREATE TABLE Playlist(id_playlist INTEGER PRIMARY KEY AUTOINCREMENT,name TEXT COLLATE NOCASE,creation_date UNSIGNED INT NOT NULL,artwork_mrl TEXT,nb_video UNSIGNED INT NOT NULL DEFAULT 0,nb_audio UNSIGNED INT NOT NULL DEFAULT 0,nb_unknown UNSIGNED INT NOT NULL DEFAULT 0,nb_present_video UNSIGNED INT NOT NULL DEFAULT 0 CHECK(nb_present_video <= nb_video),nb_present_audio UNSIGNED INT NOT NULL DEFAULT 0 CHECK(nb_present_audio <= nb_audio),nb_present_unknown UNSIGNED INT NOT NULL DEFAULT 0 CHECK(nb_present_unknown <= nb_unknown),duration UNSIGNED INT NOT NULL DEFAULT 0,nb_duration_unknown UNSIGNED INT NOT NULL DEFAULT 0);
CREATE VIRTUAL TABLE PlaylistFts USING FTS3(name)
CREATE TABLE IF NOT EXISTS 'PlaylistFts_content'(docid INTEGER PRIMARY KEY, 'c0name');
CREATE TABLE IF NOT EXISTS 'PlaylistFts_segments'(blockid INTEGER PRIMARY KEY, block BLOB);
CREATE TABLE IF NOT EXISTS 'PlaylistFts_segdir'(level INTEGER,idx INTEGER,start_block INTEGER,leaves_end_block INTEGER,end_block INTEGER,root BLOB,PRIMARY KEY(level, idx));
CREATE TABLE PlaylistMediaRelation(media_id INTEGER,playlist_id INTEGER,position INTEGER,FOREIGN KEY(media_id) REFERENCES Media(id_media) ON DELETE NO ACTION,FOREIGN KEY(playlist_id) REFERENCES Playlist(id_playlist) ON DELETE CASCADE);
CREATE TABLE Genre(id_genre INTEGER PRIMARY KEY AUTOINCREMENT,name TEXT COLLATE NOCASE UNIQUE ON CONFLICT FAIL,nb_tracks INTEGER NOT NULL DEFAULT 0,is_present INTEGER NOT NULL DEFAULT 0 CHECK(is_present <= nb_tracks));
CREATE VIRTUAL TABLE GenreFts USING FTS3(name)
CREATE TABLE IF NOT EXISTS 'GenreFts_content'(docid INTEGER PRIMARY KEY, 'c0name');
CREATE TABLE IF NOT EXISTS 'GenreFts_segments'(blockid INTEGER PRIMARY KEY, block BLOB);
CREATE TABLE IF NOT EXISTS 'GenreFts_segdir'(level INTEGER,idx INTEGER,start_block INTEGER,leaves_end_block INTEGER,end_block INTEGER,root BLOB,PRIMARY KEY(level, idx));
CREATE TABLE Album(id_album INTEGER PRIMARY KEY AUTOINCREMENT,title TEXT COLLATE NOCASE,artist_id UNSIGNED INTEGER,release_year UNSIGNED INTEGER,short_summary TEXT,nb_tracks UNSIGNED INTEGER DEFAULT 0,duration UNSIGNED INTEGER NOT NULL DEFAULT 0,nb_discs UNSIGNED INTEGER NOT NULL DEFAULT 1,is_present UNSIGNED INTEGER NOT NULL DEFAULT 0 CHECK(is_present <= nb_tracks),FOREIGN KEY(artist_id) REFERENCES Artist(id_artist) ON DELETE CASCADE);
CREATE VIRTUAL TABLE AlbumFts USING FTS3(title,artist)
CREATE TABLE IF NOT EXISTS 'AlbumFts_content'(docid INTEGER PRIMARY KEY, 'c0title', 'c1artist');
CREATE TABLE IF NOT EXISTS 'AlbumFts_segments'(blockid INTEGER PRIMARY KEY, block BLOB);
CREATE TABLE IF NOT EXISTS 'AlbumFts_segdir'(level INTEGER,idx INTEGER,start_block INTEGER,leaves_end_block INTEGER,end_block INTEGER,root BLOB,PRIMARY KEY(level, idx));
CREATE TABLE Show(id_show INTEGER PRIMARY KEY AUTOINCREMENT,title TEXT,nb_episodes UNSIGNED INTEGER NOT NULL DEFAULT 0,release_date UNSIGNED INTEGER,short_summary TEXT,artwork_mrl TEXT,tvdb_id TEXT,is_present UNSIGNED INTEGER NOT NULL DEFAULT 0 CHECK(is_present <= nb_episodes));
CREATE VIRTUAL TABLE ShowFts USING FTS3(title)
CREATE TABLE IF NOT EXISTS 'ShowFts_content'(docid INTEGER PRIMARY KEY, 'c0title');
CREATE TABLE IF NOT EXISTS 'ShowFts_segments'(blockid INTEGER PRIMARY KEY, block BLOB);
CREATE TABLE IF NOT EXISTS 'ShowFts_segdir'(level INTEGER,idx INTEGER,start_block INTEGER,leaves_end_block INTEGER,end_block INTEGER,root BLOB,PRIMARY KEY(level, idx));
CREATE TABLE ShowEpisode(id_episode INTEGER PRIMARY KEY AUTOINCREMENT,media_id UNSIGNED INTEGER NOT NULL,episode_number UNSIGNED INT,season_number UNSIGNED INT,episode_title TEXT,episode_summary TEXT,tvdb_id TEXT,show_id UNSIGNED INT,FOREIGN KEY(media_id) REFERENCES Media(id_media) ON DELETE CASCADE,FOREIGN KEY(show_id) REFERENCES Show(id_show) ON DELETE CASCADE);
CREATE TABLE Movie(id_movie INTEGER PRIMARY KEY AUTOINCREMENT,media_id UNSIGNED INTEGER NOT NULL,summary TEXT,imdb_id TEXT,FOREIGN KEY(media_id) REFERENCES Media(id_media) ON DELETE CASCADE);
CREATE TABLE VideoTrack(id_track INTEGER PRIMARY KEY AUTOINCREMENT,codec TEXT,width UNSIGNED INTEGER,height UNSIGNED INTEGER,fps_num UNSIGNED INTEGER,fps_den UNSIGNED INTEGER,bitrate UNSIGNED INTEGER,sar_num UNSIGNED INTEGER,sar_den UNSIGNED INTEGER,media_id UNSIGNED INT,language TEXT,description TEXT,FOREIGN KEY(media_id) REFERENCES Media(id_media) ON DELETE CASCADE);
CREATE TABLE AudioTrack(id_track INTEGER PRIMARY KEY AUTOINCREMENT,codec TEXT,bitrate UNSIGNED INTEGER,samplerate UNSIGNED INTEGER,nb_channels UNSIGNED INTEGER,language TEXT,description TEXT,media_id UNSIGNED INT,attached_file_id UNSIGNED INT,FOREIGN KEY(media_id) REFERENCES Media(id_media) ON DELETE CASCADE,FOREIGN KEY(attached_file_id) REFERENCES File(id_file) ON DELETE CASCADE);
CREATE TABLE Artist(id_artist INTEGER PRIMARY KEY AUTOINCREMENT,name TEXT COLLATE NOCASE UNIQUE ON CONFLICT FAIL,shortbio TEXT,nb_albums UNSIGNED INT DEFAULT 0,nb_tracks UNSIGNED INT DEFAULT 0,mb_id TEXT,is_present UNSIGNED INTEGER NOT NULL DEFAULT 0 CHECK(is_present <= nb_tracks));
CREATE VIRTUAL TABLE ArtistFts USING FTS3(name)
CREATE TABLE IF NOT EXISTS 'ArtistFts_content'(docid INTEGER PRIMARY KEY, 'c0name');
CREATE TABLE IF NOT EXISTS 'ArtistFts_segments'(blockid INTEGER PRIMARY KEY, block BLOB);
CREATE TABLE IF NOT EXISTS 'ArtistFts_segdir'(level INTEGER,idx INTEGER,start_block INTEGER,leaves_end_block INTEGER,end_block INTEGER,root BLOB,PRIMARY KEY(level, idx));
CREATE TABLE MediaArtistRelation(media_id INTEGER NOT NULL,artist_id INTEGER,PRIMARY KEY(media_id,artist_id),FOREIGN KEY(media_id) REFERENCES Media(id_media) ON DELETE CASCADE,FOREIGN KEY(artist_id) REFERENCES Artist(id_artist) ON DELETE CASCADE);
CREATE TABLE Task(id_task INTEGER PRIMARY KEY AUTOINCREMENT,step INTEGER NOT NULL DEFAULT 0,attempts_left INTEGER NOT NULL,type INTEGER NOT NULL,mrl TEXT,file_type INTEGER NOT NULL,file_id UNSIGNED INTEGER,parent_folder_id UNSIGNED INTEGER,link_to_id UNSIGNED INTEGER NOT NULL,link_to_type UNSIGNED INTEGER NOT NULL,link_extra UNSIGNED INTEGER NOT NULL,link_to_mrl TEXT NOT NULL,UNIQUE(mrl,type, link_to_id, link_to_type, link_extra, link_to_mrl) ON CONFLICT FAIL,FOREIGN KEY(parent_folder_id) REFERENCES Folder(id_folder) ON DELETE CASCADE,FOREIGN KEY(file_id) REFERENCES File(id_file) ON DELETE CASCADE);
CREATE TABLE Metadata(id_media INTEGER,entity_type INTEGER,type INTEGER,value TEXT,PRIMARY KEY(id_media,entity_type,type));
CREATE TABLE SubtitleTrack(id_track INTEGER PRIMARY KEY AUTOINCREMENT,codec TEXT,language TEXT,description TEXT,encoding TEXT,media_id UNSIGNED INT,attached_file_id UNSIGNED INT,FOREIGN KEY(media_id) REFERENCES Media(id_media) ON DELETE CASCADE,FOREIGN KEY(attached_file_id) REFERENCES File(id_file) ON DELETE CASCADE,UNIQUE(media_id, attached_file_id) ON CONFLICT FAIL);
CREATE TABLE Chapter(id_chapter INTEGER PRIMARY KEY AUTOINCREMENT,offset INTEGER NOT NULL,duration INTEGER NOT NULL,name TEXT,media_id INTEGER,FOREIGN KEY(media_id) REFERENCES Media(id_media) ON DELETE CASCADE);
CREATE TABLE Bookmark(id_bookmark INTEGER PRIMARY KEY AUTOINCREMENT,time UNSIGNED INTEGER NOT NULL,name TEXT,description TEXT,media_id UNSIGNED INTEGER NOT NULL,creation_date UNSIGNED INTEGER NOT NULL,type UNSIGNED INTEGER NOT NULL,FOREIGN KEY(media_id) REFERENCES Media(id_media) ON DELETE CASCADE,UNIQUE(time,media_id) ON CONFLICT FAIL);
CREATE TABLE MediaGroup(id_group INTEGER PRIMARY KEY AUTOINCREMENT,name TEXT COLLATE NOCASE,nb_video UNSIGNED INTEGER DEFAULT 0,nb_audio UNSIGNED INTEGER DEFAULT 0,nb_unknown UNSIGNED INTEGER DEFAULT 0,nb_seen UNSIGNED INTEGER DEFAULT 0,nb_external UNSIGNED INTEGER DEFAULT 0,nb_present_video UNSIGNED INTEGER DEFAULT 0 CHECK(nb_present_video <= nb_video),nb_present_audio UNSIGNED INTEGER DEFAULT 0 CHECK(nb_present_audio <= nb_audio),nb_present_unknown UNSIGNED INTEGER DEFAULT 0 CHECK(nb_present_unknown <= nb_unknown),nb_present_seen UNSIGNED INTEGER DEFAULT 0 CHECK(nb_present_seen <= nb_seen),duration INTEGER DEFAULT 0,creation_date INTEGER NOT NULL,last_modification_date INTEGER NOT NULL,user_interacted BOOLEAN,forced_singleton BOOLEAN);
CREATE VIRTUAL TABLE MediaGroupFts USING FTS3(name)
CREATE TABLE IF NOT EXISTS 'MediaGroupFts_content'(docid INTEGER PRIMARY KEY, 'c0name');
CREATE TABLE IF NOT EXISTS 'MediaGroupFts_segments'(blockid INTEGER PRIMARY KEY, block BLOB);
CREATE TABLE IF NOT EXISTS 'MediaGroupFts_segdir'(level INTEGER,idx INTEGER,start_block INTEGER,leaves_end_block INTEGER,end_block INTEGER,root BLOB,PRIMARY KEY(level, idx));
CREATE TRIGGER insert_folder_fts AFTER INSERT ON Folder BEGIN INSERT INTO FolderFts(rowid,name) VALUES(new.id_folder,new.name);END;
CREATE TRIGGER delete_folder_fts BEFORE DELETE ON Folder BEGIN DELETE FROM FolderFts WHERE rowid = old.id_folder;END;
CREATE TRIGGER update_folder_nb_media_on_insert AFTER INSERT ON Media WHEN new.folder_id IS NOT NULL BEGIN UPDATE Folder SET nb_audio = nb_audio + (CASE new.type WHEN 2 THEN 1 ELSE 0 END),nb_video = nb_video + (CASE new.type WHEN 1 THEN 1 ELSE 0 END) WHERE id_folder = new.folder_id;END;
CREATE TRIGGER update_folder_nb_media_on_delete AFTER DELETE ON Media WHEN old.folder_id IS NOT NULL BEGIN UPDATE Folder SET nb_audio = nb_audio + (CASE old.type WHEN 2 THEN -1 ELSE 0 END),nb_video = nb_video + (CASE old.type WHEN 1 THEN -1 ELSE 0 END) WHERE id_folder = old.folder_id;END;
CREATE TRIGGER folder_update_nb_media_on_media_update AFTER UPDATE OF folder_id, type ON Media WHEN IFNULL(old.folder_id, 0) != IFNULL(new.folder_id, 0) OR old.type != new.type BEGIN UPDATE Folder SET nb_audio = nb_audio + (CASE new.type WHEN 2 THEN 1 ELSE 0 END),nb_video = nb_video + (CASE new.type WHEN 1 THEN 1 ELSE 0 END)WHERE new.folder_id IS NOT NULL AND id_folder = new.folder_id;UPDATE Folder SET nb_audio = nb_audio - (CASE old.type WHEN 2 THEN -1 ELSE 0 END),nb_video = nb_video - (CASE old.type WHEN 1 THEN 1 ELSE 0 END)WHERE old.folder_id IS NOT NULL AND id_folder = old.folder_id; END;
CREATE INDEX folder_device_id_idx ON Folder (device_id);
CREATE INDEX parent_folder_id_idx ON Folder (parent_id);
CREATE TRIGGER album_is_present AFTER UPDATE OF is_present ON Media WHEN new.subtype = 3 AND old.is_present != new.is_present BEGIN  UPDATE Album SET is_present=is_present + (CASE new.is_present WHEN 0 THEN -1 ELSE 1 END)WHERE id_album = new.album_id; END;
CREATE TRIGGER album_delete_track AFTER DELETE ON Media WHEN old.subtype = 3 BEGIN  UPDATE Album SET nb_tracks = nb_tracks - 1, is_present = is_present - IIF(old.is_present != 0, 1, 0), duration = duration - MAX(old.duration, 0) WHERE id_album = old.album_id; END;
CREATE TRIGGER insert_album_fts AFTER INSERT ON Album WHEN new.title IS NOT NULL BEGIN INSERT INTO AlbumFts(rowid, title) VALUES(new.id_album, new.title); END;
CREATE TRIGGER delete_album_fts BEFORE DELETE ON Album WHEN old.title IS NOT NULL BEGIN DELETE FROM AlbumFts WHERE rowid = old.id_album; END;
CREATE TRIGGER album_delete_empty AFTER UPDATE OF nb_tracks ON Album WHEN new.nb_tracks = 0 BEGIN  DELETE FROM Album WHERE id_album=new.id_album; END;
CREATE INDEX album_artist_id_idx ON Album(artist_id);
CREATE INDEX album_nb_tracks_idx ON Album(nb_tracks, is_present);
CREATE TRIGGER artist_has_tracks_present AFTER UPDATE OF is_present ON Media WHEN new.subtype = 3 AND old.is_present != new.is_present BEGIN  UPDATE Artist SET is_present=is_present + (CASE new.is_present WHEN 0 THEN -1 ELSE 1 END)WHERE id_artist = new.artist_id; END;
CREATE TRIGGER insert_artist_fts AFTER INSERT ON Artist WHEN new.name IS NOT NULL BEGIN INSERT INTO ArtistFts(rowid,name) VALUES(new.id_artist, new.name); END;
CREATE TRIGGER delete_artist_fts BEFORE DELETE ON Artist WHEN old.name IS NOT NULL BEGIN DELETE FROM ArtistFts WHERE rowid=old.id_artist; END;
CREATE TRIGGER delete_artist_without_tracks AFTER UPDATE OF nb_tracks, nb_albums ON Artist WHEN new.nb_tracks = 0 AND new.nb_albums = 0 AND new.id_artist != 1 AND new.id_artist != 2 BEGIN DELETE FROM Artist WHERE id_artist = old.id_artist; END;
CREATE TRIGGER artist_increment_nb_tracks AFTER INSERT ON MediaArtistRelation BEGIN UPDATE Artist SET nb_tracks = nb_tracks + 1, is_present = is_present + 1 WHERE id_artist = new.artist_id; END;
CREATE TRIGGER artist_decrement_nb_tracks AFTER DELETE ON MediaArtistRelation BEGIN UPDATE Artist SET nb_tracks = nb_tracks - 1, is_present = is_present - 1 WHERE id_artist = old.artist_id; END;
CREATE TRIGGER artist_update_nb_albums AFTER UPDATE OF artist_id ON Album BEGIN UPDATE Artist SET nb_albums = nb_albums + 1 WHERE id_artist = new.artist_id; UPDATE Artist SET nb_albums = nb_albums - 1 WHERE id_artist = old.artist_id; END;
CREATE TRIGGER artist_decrement_nb_albums AFTER DELETE ON Album BEGIN UPDATE Artist SET nb_albums = nb_albums - 1 WHERE id_artist = old.artist_id; END;
CREATE TRIGGER artist_increment_nb_albums_unknown_album AFTER INSERT ON Album WHEN new.artist_id IS NOT NULL BEGIN UPDATE Artist SET nb_albums = nb_albums + 1 WHERE id_artist = new.artist_id; END;
CREATE INDEX artist_media_rel_artist_id_idx ON MediaArtistRelation(artist_id);
CREATE TRIGGER media_update_device_presence AFTER UPDATE OF is_present ON Device WHEN old.is_present != new.is_present BEGIN UPDATE Media SET is_present=new.is_present WHERE device_id=new.id_device;END;
CREATE TRIGGER media_cascade_file_deletion AFTER DELETE ON File WHEN old.type = 1 OR old.type = 6 BEGIN  DELETE FROM Media WHERE id_media=old.media_id; END;
CREATE TRIGGER insert_media_fts AFTER INSERT ON Media BEGIN INSERT INTO MediaFts(rowid,title,labels) VALUES(new.id_media, new.title, ''); END;
CREATE TRIGGER media_cascade_file_update AFTER UPDATE OF media_id ON File WHEN old.media_id != new.media_id AND old.type = 1 BEGIN DELETE FROM Media WHERE id_media = old.media_id;END;
CREATE TRIGGER delete_media_fts BEFORE DELETE ON Media BEGIN DELETE FROM MediaFts WHERE rowid = old.id_media; END;
CREATE TRIGGER update_media_title_fts AFTER UPDATE OF title ON Media BEGIN UPDATE MediaFts SET title = new.title WHERE rowid = new.id_media; END;
CREATE TRIGGER increment_media_nb_playlist AFTER INSERT ON PlaylistMediaRelation BEGIN UPDATE Media SET nb_playlists = nb_playlists + 1  WHERE id_media = new.media_id; END;
CREATE TRIGGER decrement_media_nb_playlist AFTER DELETE ON PlaylistMediaRelation BEGIN UPDATE Media SET nb_playlists = nb_playlists - 1  WHERE id_media = old.media_id; END;
CREATE INDEX index_last_played_date ON Media(last_played_date DESC);
CREATE INDEX index_media_presence ON Media(is_present);
CREATE INDEX media_types_idx ON Media(type, subtype);
CREATE INDEX media_insertion_date_idx ON Media(insertion_date);
CREATE INDEX media_folder_id_idx ON Media(folder_id);
CREATE INDEX media_group_id_idx ON Media(group_id);
CREATE INDEX media_last_pos_time_idx ON Media(last_position, last_time);
CREATE INDEX media_album_track_idx ON Media(album_id, genre_id, artist_id);
CREATE INDEX media_duration_idx ON Media(duration);
CREATE INDEX media_release_date_idx ON Media(release_date);
CREATE INDEX media_play_count_idx ON Media(play_count);
CREATE INDEX media_title_idx ON Media(title);
CREATE INDEX media_filename_idx ON Media(filename);
CREATE INDEX media_genre_id_idx ON Media(genre_id);
CREATE INDEX media_artist_id_idx ON Media(artist_id);
CREATE INDEX file_media_id_index ON File(media_id);
CREATE INDEX file_folder_id_index ON File(folder_id);
CREATE INDEX file_playlist_id_idx ON File(playlist_id);
CREATE TRIGGER insert_genre_fts AFTER INSERT ON Genre BEGIN INSERT INTO GenreFts(rowid,name) VALUES(new.id_genre, new.name); END;
CREATE TRIGGER delete_genre_fts BEFORE DELETE ON Genre BEGIN DELETE FROM GenreFts WHERE rowid = old.id_genre; END;
CREATE TRIGGER genre_update_on_track_deleted AFTER DELETE ON Media WHEN old.subtype = 3 BEGIN UPDATE Genre SET is_present = is_present - IIF(old.is_present != 0, 1, 0), nb_tracks = nb_tracks - 1 WHERE id_genre = old.genre_id; END;
CREATE TRIGGER genre_update_is_present AFTER UPDATE OF is_present ON Media WHEN new.subtype = 3 AND old.is_present != new.is_present BEGIN UPDATE Genre SET is_present = is_present + (CASE new.is_present WHEN 0 THEN -1 ELSE 1 END) WHERE id_genre = new.genre_id; END;
CREATE TRIGGER genre_delete_empty AFTER UPDATE OF nb_tracks ON Genre WHEN new.nb_tracks = 0 BEGIN DELETE FROM Genre WHERE id_genre = old.id_genre; END;
CREATE TRIGGER update_playlist_order_on_insert AFTER INSERT ON PlaylistMediaRelation WHEN new.position IS NOT NULL BEGIN UPDATE PlaylistMediaRelation SET position = position + 1 WHERE playlist_id = new.playlist_id AND position >= new.position AND rowid != new.rowid; END;
CREATE TRIGGER update_playlist_order_on_delete AFTER DELETE ON PlaylistMediaRelation BEGIN UPDATE PlaylistMediaRelation SET position = position - 1 WHERE playlist_id = old.playlist_id AND position > old.position; END;
CREATE TRIGGER insert_playlist_fts AFTER INSERT ON Playlist BEGIN INSERT INTO PlaylistFts(rowid, name) VALUES(new.id_playlist, new.name); END;
CREATE TRIGGER update_playlist_fts AFTER UPDATE OF name ON Playlist BEGIN UPDATE PlaylistFts SET name = new.name WHERE rowid = new.id_playlist; END;
CREATE TRIGGER delete_playlist_fts BEFORE DELETE ON Playlist BEGIN DELETE FROM PlaylistFts WHERE rowid = old.id_playlist; END;
CREATE TRIGGER playlist_update_nb_media_on_media_deletion AFTER DELETE ON Media WHEN old.nb_playlists > 0 BEGIN UPDATE Playlist SET nb_video = nb_video - IIF(old.type = 1, items.count, 0),nb_present_video = nb_present_video - IIF( old.is_present != 0, IIF(old.type = 1, items.count, 0), 0),nb_audio = nb_audio - IIF(old.type = 2, items.count, 0),nb_present_audio = nb_present_audio - IIF( old.is_present != 0, IIF(old.type = 2, items.count, 0), 0),nb_unknown = nb_unknown - IIF(old.type = 0, items.count, 0),nb_present_unknown = nb_present_unknown - IIF( old.is_present != 0, IIF(old.type = 0, items.count, 0), 0), duration = duration - items.dur, nb_duration_unknown = nb_duration_unknown -IIF(items.dur <= 0, items.count, 0) FROM (SELECT COUNT(media_id) AS count, TOTAL(IIF(old.duration > 0, old.duration, 0)) AS dur, playlist_id FROM PlaylistMediaRelation WHERE media_id = old.id_media GROUP BY playlist_id) AS items WHERE id_playlist = items.playlist_id; DELETE FROM PlaylistMediaRelation WHERE media_id = old.id_media; END;
CREATE TRIGGER playlist_update_duration_on_media_change AFTER UPDATE OF duration ON Media WHEN old.duration != new.duration BEGIN UPDATE Playlist SET duration = duration - IIF(old.duration > 0, old.duration, 0) + IIF(new.duration > 0, new.duration, 0), nb_duration_unknown = nb_duration_unknown - IIF(old.duration <= 0, 1, 0) + IIF(new.duration <= 0, 1, 0) WHERE id_playlist IN (SELECT DISTINCT playlist_id FROM PlaylistMediaRelation WHERE media_id = new.id_media); END;
CREATE TRIGGER playlist_update_nb_media_on_media_change AFTER UPDATE OF type, is_present ON Media WHEN old.type != new.type OR old.is_present != new.is_present AND old.nb_playlists > 0 BEGIN UPDATE Playlist SET nb_present_video = nb_present_video - IIF(old.is_present != 0,IIF(old.type = 1, items.count, 0), 0), nb_video = nb_video - IIF(old.type = 1, items.count, 0), nb_present_audio = nb_present_audio - IIF(old.is_present != 0,IIF(old.type = 2, items.count, 0), 0), nb_audio = nb_audio - IIF(old.type = 2, items.count, 0), nb_present_unknown = nb_present_unknown - IIF(old.is_present != 0,IIF(old.type = 0, items.count, 0), 0), nb_unknown = nb_unknown - IIF(old.type = 0, items.count, 0)  FROM (SELECT COUNT(media_id) AS count, playlist_id FROM PlaylistMediaRelation WHERE media_id = old.id_media GROUP BY playlist_id) AS items WHERE id_playlist = items.playlist_id; UPDATE Playlist SET nb_video = nb_video + IIF(new.type = 1, items.count, 0), nb_present_video = nb_present_video + IIF(new.is_present != 0,IIF(new.type = 1, items.count, 0), 0), nb_audio = nb_audio + IIF(new.type = 2, items.count, 0), nb_present_audio = nb_present_audio + IIF(new.is_present != 0,IIF(new.type = 2, items.count, 0), 0), nb_unknown = nb_unknown + IIF(new.type = 0, items.count, 0), nb_present_unknown = nb_present_unknown + IIF(new.is_present != 0,IIF(new.type = 0, items.count, 0), 0)  FROM (SELECT COUNT(media_id) AS count, playlist_id FROM PlaylistMediaRelation WHERE media_id = old.id_media GROUP BY playlist_id) AS items WHERE id_playlist = items.playlist_id; END;
CREATE TRIGGER playlist_cascade_file_deletion AFTER DELETE ON File WHEN old.type = 5 BEGIN  DELETE FROM Playlist WHERE id_playlist=old.playlist_id; END;
CREATE INDEX playlist_position_pl_id_index ON PlaylistMediaRelation(playlist_id,position);
CREATE INDEX playlist_rel_media_id_idx ON PlaylistMediaRelation(media_id);
CREATE TRIGGER delete_label_fts BEFORE DELETE ON Label BEGIN UPDATE MediaFts SET labels = TRIM(REPLACE(labels, old.name, '')) WHERE labels MATCH old.name; END;
CREATE TRIGGER insert_show_fts AFTER INSERT ON Show BEGIN INSERT INTO ShowFts(rowid,title) VALUES(new.id_show, new.title); END;
CREATE TRIGGER delete_show_fts BEFORE DELETE ON Show BEGIN DELETE FROM ShowFts WHERE rowid = old.id_show; END;
CREATE TRIGGER show_increment_nb_episode AFTER INSERT ON ShowEpisode BEGIN UPDATE Show SET nb_episodes = nb_episodes + 1, is_present = is_present + 1 WHERE id_show = new.show_id; END;
CREATE TRIGGER show_decrement_nb_episode AFTER DELETE ON ShowEpisode BEGIN UPDATE Show SET nb_episodes = nb_episodes - 1, is_present = is_present - 1 WHERE id_show = old.show_id; END;
CREATE TRIGGER show_update_is_present AFTER UPDATE OF is_present ON Media WHEN new.subtype = 1 AND new.is_present != old.is_present BEGIN  UPDATE Show SET is_present=is_present + (CASE new.is_present WHEN 0 THEN -1 ELSE 1 END) WHERE id_show = (SELECT show_id FROM ShowEpisode WHERE media_id = new.id_media); END;
CREATE INDEX show_episode_media_idx ON ShowEpisode(media_id);
CREATE INDEX show_episode_show_id_idx ON ShowEpisode(show_id);
CREATE TRIGGER auto_delete_album_thumbnail AFTER DELETE ON Album BEGIN DELETE FROM ThumbnailLinking WHERE entity_id = old.id_album AND entity_type = 1; END;
CREATE TRIGGER auto_delete_artist_thumbnail AFTER DELETE ON Artist BEGIN DELETE FROM ThumbnailLinking WHERE entity_id = old.id_artist AND entity_type = 2; END;
CREATE TRIGGER auto_delete_media_thumbnail AFTER DELETE ON Media BEGIN DELETE FROM ThumbnailLinking WHERE entity_id = old.id_media AND entity_type = 0; END;
CREATE TRIGGER incr_thumbnail_refcount AFTER INSERT ON ThumbnailLinking BEGIN UPDATE Thumbnail SET shared_counter = shared_counter + 1 WHERE id_thumbnail = new.thumbnail_id;END;
CREATE TRIGGER decr_thumbnail_refcount AFTER DELETE ON ThumbnailLinking BEGIN UPDATE Thumbnail SET shared_counter = shared_counter - 1 WHERE id_thumbnail = old.thumbnail_id;END;
CREATE TRIGGER update_thumbnail_refcount AFTER UPDATE OF thumbnail_id ON ThumbnailLinking WHEN old.thumbnail_id != new.thumbnail_id BEGIN UPDATE Thumbnail SET shared_counter = shared_counter - 1 WHERE id_thumbnail = old.thumbnail_id;UPDATE Thumbnail SET shared_counter = shared_counter + 1 WHERE id_thumbnail = new.thumbnail_id;END;
CREATE TRIGGER delete_unused_thumbnail AFTER UPDATE OF shared_counter ON Thumbnail WHEN new.shared_counter = 0 BEGIN DELETE FROM Thumbnail WHERE id_thumbnail = new.id_thumbnail;END;
CREATE TRIGGER thumbnail_insert_cleanup AFTER DELETE ON Thumbnail WHEN old.is_owned != 0 AND old.status = 1 BEGIN INSERT INTO ThumbnailCleanup(mrl) VALUES(old.mrl); END;
CREATE INDEX thumbnail_link_index ON ThumbnailLinking(thumbnail_id);
CREATE TRIGGER delete_playlist_linking_tasks AFTER DELETE ON Playlist BEGIN DELETE FROM Task WHERE link_to_type = 1 AND link_to_id = old.id_playlist AND type = 1;END;
CREATE INDEX audio_track_media_idx ON AudioTrack(media_id);
CREATE INDEX audio_track_attached_file_idx ON AudioTrack(attached_file_id);
CREATE INDEX subtitle_track_media_idx ON SubtitleTrack(media_id);
CREATE INDEX subtitle_track_attached_file_idx ON SubtitleTrack(attached_file_id);
CREATE INDEX video_track_media_idx ON VideoTrack(media_id);
CREATE TRIGGER media_group_insert_fts AFTER INSERT ON MediaGroup BEGIN INSERT INTO MediaGroupFts(rowid, name) VALUES(new.rowid, new.name); END;
CREATE TRIGGER media_group_delete_fts AFTER DELETE ON MediaGroup BEGIN DELETE FROM MediaGroupFts WHERE rowid = old.id_group; END;
CREATE TRIGGER media_group_update_nb_media_types AFTER UPDATE OF type, play_count, group_id ON Media WHEN (IFNULL(old.group_id, 0) != IFNULL(new.group_id, 0) OR old.type != new.type OR new.play_count != old.play_count) AND new.import_type = 0 BEGIN UPDATE MediaGroup SET nb_video = nb_video + (CASE new.type WHEN 1 THEN 1 ELSE 0 END), nb_present_video = nb_present_video + (CASE new.is_present WHEN 0 THEN 0 ELSE (CASE new.type WHEN 1 THEN 1 ELSE 0 END) END), nb_audio = nb_audio + (CASE new.type WHEN 2 THEN 1 ELSE 0 END), nb_seen = nb_seen + IIF(new.play_count > 0, 1, 0), nb_present_audio = nb_present_audio + (CASE new.is_present WHEN 0 THEN 0 ELSE (CASE new.type WHEN 2 THEN 1 ELSE 0 END) END), nb_unknown = nb_unknown + (CASE new.type WHEN 0 THEN 1 ELSE 0 END), nb_present_unknown = nb_present_unknown + (CASE new.is_present WHEN 0 THEN 0 ELSE (CASE new.type WHEN 0 THEN 1 ELSE 0 END) END), nb_present_seen = nb_present_seen + IIF(new.play_count > 0 AND new.is_present, 1, 0), last_modification_date = strftime('%s') WHERE new.group_id IS NOT NULL AND id_group = new.group_id; UPDATE MediaGroup SET nb_present_video = nb_present_video - (CASE old.is_present WHEN 0 THEN 0 ELSE (CASE old.type WHEN 1 THEN 1 ELSE 0 END) END), nb_video = nb_video - (CASE old.type WHEN 1 THEN 1 ELSE 0 END), nb_present_audio = nb_present_audio - (CASE old.is_present WHEN 0 THEN 0 ELSE (CASE old.type WHEN 2 THEN 1 ELSE 0 END) END), nb_present_seen = nb_present_seen - IIF(old.play_count > 0 AND old.is_present != 0, 1, 0), nb_audio = nb_audio - (CASE old.type WHEN 2 THEN 1 ELSE 0 END), nb_present_unknown = nb_present_unknown - (CASE old.is_present WHEN 0 THEN 0 ELSE (CASE old.type WHEN 0 THEN 1 ELSE 0 END) END), nb_unknown = nb_unknown - (CASE old.type WHEN 0 THEN 1 ELSE 0 END), nb_seen = nb_seen - IIF(old.play_count > 0, 1, 0), last_modification_date = strftime('%s') WHERE old.group_id IS NOT NULL AND id_group = old.group_id; END;
CREATE TRIGGER media_group_decrement_nb_media_on_deletion AFTER DELETE ON Media WHEN old.group_id IS NOT NULL BEGIN UPDATE MediaGroup SET nb_present_video = nb_present_video - (CASE old.is_present WHEN 0 THEN 0 ELSE (CASE old.type WHEN 1 THEN 1 ELSE 0 END) END), nb_video = nb_video - (CASE old.type WHEN 1 THEN 1 ELSE 0 END), nb_present_audio = nb_present_audio - (CASE old.is_present WHEN 0 THEN 0 ELSE (CASE old.type WHEN 2 THEN 1 ELSE 0 END) END), nb_present_seen = nb_present_seen - IIF(old.play_count > 0 AND old.is_present > 0, 1, 0), nb_audio = nb_audio - (CASE old.type WHEN 2 THEN 1 ELSE 0 END), nb_present_unknown = nb_present_unknown - (CASE old.is_present WHEN 0 THEN 0 ELSE (CASE old.type WHEN 0 THEN 1 ELSE 0 END) END), nb_unknown = nb_unknown - (CASE old.type WHEN 0 THEN 1 ELSE 0 END), nb_seen = nb_seen - IIF(old.play_count > 0, 1, 0), last_modification_date = strftime('%s') WHERE id_group = old.group_id; END;
CREATE TRIGGER media_group_delete_empty_group AFTER UPDATE OF nb_video, nb_audio, nb_unknown, nb_external ON MediaGroup WHEN new.nb_video = 0 AND new.nb_audio = 0 AND new.nb_unknown = 0 AND new.nb_external = 0 BEGIN DELETE FROM MediaGroup WHERE id_group = new.id_group; END;
CREATE TRIGGER media_group_rename_forced_singleton AFTER UPDATE OF title ON Media WHEN new.group_id IS NOT NULL BEGIN UPDATE MediaGroup SET name = new.title WHERE id_group = new.group_id AND forced_singleton != 0; END;
CREATE TRIGGER media_group_update_duration_on_media_change AFTER UPDATE OF duration, group_id ON Media BEGIN UPDATE MediaGroup SET duration = duration - max(old.duration, 0) WHERE id_group = old.group_id; UPDATE MediaGroup SET duration = duration + max(new.duration, 0) WHERE id_group = new.group_id; END;
CREATE TRIGGER media_group_update_duration_on_media_deletion AFTER DELETE ON Media WHEN old.group_id IS NOT NULL AND old.duration > 0 BEGIN UPDATE MediaGroup SET duration = duration - old.duration WHERE id_group = old.group_id; END;
CREATE TRIGGER media_group_update_nb_media_types_presence AFTER UPDATE OF is_present ON Media WHEN old.is_present != new.is_present AND new.group_id IS NOT NULL BEGIN UPDATE MediaGroup SET nb_present_video = nb_present_video +  (CASE new.type WHEN 1 THEN 1 ELSE 0 END) * (CASE new.is_present WHEN 0 THEN -1 ELSE 1 END), nb_present_audio = nb_present_audio +  (CASE new.type WHEN 2 THEN 1 ELSE 0 END) * (CASE new.is_present WHEN 0 THEN -1 ELSE 1 END), nb_present_unknown = nb_present_unknown +  (CASE new.type WHEN 0 THEN 1 ELSE 0 END) * (CASE new.is_present WHEN 0 THEN -1 ELSE 1 END), nb_present_seen = nb_present_seen + IIF(new.play_count > 0, 1, 0) * IIF(new.is_present != 0, 1, -1) WHERE id_group = new.group_id; END;
CREATE TRIGGER media_group_update_media_count_on_import_type_change AFTER UPDATE OF group_id, import_type ON Media WHEN ( IFNULL(old.group_id, 0) != IFNULL(new.group_id, 0)  AND new.import_type != 0 ) OR new.import_type != old.import_type BEGIN UPDATE MediaGroup SET nb_video = nb_video + (CASE new.import_type WHEN 0 THEN (CASE new.type WHEN 1 THEN 1 ELSE 0 END) ELSE 0 END), nb_present_video = nb_present_video + (CASE new.import_type WHEN 0 THEN (CASE new.is_present WHEN 0 THEN 0 ELSE (CASE new.type WHEN 1 THEN 1 ELSE 0 END) END) ELSE 0 END), nb_audio = nb_audio + (CASE new.import_type WHEN 0 THEN (CASE new.type WHEN 2 THEN 1 ELSE 0 END) ELSE 0 END), nb_present_audio = nb_present_audio + (CASE new.import_type WHEN 0 THEN (CASE new.is_present WHEN 0 THEN 0 ELSE (CASE new.type WHEN 2 THEN 1 ELSE 0 END) END) ELSE 0 END), nb_unknown = nb_unknown + (CASE new.import_type WHEN 0 THEN (CASE new.type WHEN 0 THEN 1 ELSE 0 END) ELSE 0 END), nb_present_unknown = nb_present_unknown + (CASE new.import_type WHEN 0 THEN (CASE new.is_present WHEN 0 THEN 0 ELSE (CASE new.type WHEN 0 THEN 1 ELSE 0 END) END) ELSE 0 END), nb_external = nb_external + (CASE new.import_type WHEN 0 THEN 0 ELSE 1 END), last_modification_date = strftime('%s') WHERE new.group_id IS NOT NULL AND id_group = new.group_id; UPDATE MediaGroup SET nb_present_video = nb_present_video - (CASE old.import_type WHEN 0 THEN (CASE old.is_present WHEN 0 THEN 0 ELSE (CASE old.type WHEN 1 THEN 1 ELSE 0 END) END) ELSE 0 END), nb_video = nb_video - (CASE old.import_type WHEN 0 THEN (CASE old.type WHEN 1 THEN 1 ELSE 0 END) ELSE 0 END), nb_present_audio = nb_present_audio - (CASE old.import_type WHEN 0 THEN (CASE old.is_present WHEN 0 THEN 0 ELSE (CASE old.type WHEN 2 THEN 1 ELSE 0 END) END) ELSE 0 END), nb_audio = nb_audio - (CASE old.import_type WHEN 0 THEN (CASE old.type WHEN 2 THEN 1 ELSE 0 END) ELSE 0 END), nb_present_unknown = nb_present_unknown - (CASE old.import_type WHEN 0 THEN (CASE old.is_present WHEN 0 THEN 0 ELSE (CASE old.type WHEN 0 THEN 1 ELSE 0 END) END) ELSE 0 END), nb_unknown = nb_unknown - (CASE old.import_type WHEN 0 THEN (CASE old.type WHEN 0 THEN 1 ELSE 0 END) ELSE 0 END), nb_external = nb_external - (CASE old.import_type WHEN 0 THEN 0 ELSE 1 END), last_modification_date = strftime('%s') WHERE old.group_id IS NOT NULL AND id_group = old.group_id; END;
CREATE INDEX media_group_forced_singleton ON MediaGroup(forced_singleton);
CREATE INDEX media_group_duration ON MediaGroup(duration);
CREATE INDEX media_group_creation_date ON MediaGroup(creation_date);
CREATE INDEX media_group_last_modification_date ON MediaGroup(last_modification_date);
CREATE INDEX movie_media_idx ON Movie(media_id);
CREATE INDEX task_parent_folder_id_idx ON Task(parent_folder_id);
CREATE INDEX task_file_id_idx ON Task(file_id);
CREATE INDEX bookmark_media_id_idx ON Bookmark(media_id);
CREATE INDEX chapter_media_id_idx ON Chapter(media_id);
CREATE INDEX label_rel_media_id_idx ON LabelFileRelation(media_id);
INSERT INTO Settings VALUES(35,2,6);
INSERT INTO Device VALUES(1,'{dummy-device}','file://',0,1,0,0);
INSERT INTO Folder VALUES(1,'file:///builds/videolan/medialibrary/dummysamples/','dummysamples',NULL,0,1,0,0,0);
INSERT INTO Folder VALUES(2,'file:///builds/videolan/medialibrary/dummysamples/artist_10/','artist_10',1,0,1,0,0,0);
INSERT INTO Folder VALUES(3,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/','album_10',2,0,1,0,10,0);
INSERT INTO Folder VALUES(4,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/','album_9',2,0,1,0,10,0);
INSERT INTO Folder VALUES(5,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/','album_8',2,0,1,0,10,0);
INSERT INTO Folder VALUES(6,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/','album_7',2,0,1,0,10,0);
INSERT INTO Folder VALUES(7,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/','album_6',2,0,1,0,10,0);
INSERT INTO Folder VALUES(8,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/','album_5',2,0,1,0,10,0);
INSERT INTO Folder VALUES(9,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/','album_4',2,0,1,0,10,0);
INSERT INTO Folder VALUES(10,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/','album_3',2,0,1,0,10,0);
INSERT INTO Folder VALUES(11,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/','album_2',2,0,1,0,10,0);
INSERT INTO Folder VALUES(12,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/','album_1',2,0,1,0,10,0);
INSERT INTO Folder VALUES(13,'file:///builds/videolan/medialibrary/dummysamples/artist_9/','artist_9',1,0,1,0,0,0);
INSERT INTO Folder VALUES(14,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/','album_10',13,0,1,0,10,0);
INSERT INTO Folder VALUES(15,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/','album_9',13,0,1,0,10,0);
INSERT INTO Folder VALUES(16,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/','album_8',13,0,1,0,10,0);
INSERT INTO Folder VALUES(17,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/','album_7',13,0,1,0,10,0);
INSERT INTO Folder VALUES(18,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/','album_6',13,0,1,0,10,0);
INSERT INTO Folder VALUES(19,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/','album_5',13,0,1,0,10,0);
INSERT INTO Folder VALUES(20,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/','album_4',13,0,1,0,10,0);
INSERT INTO Folder VALUES(21,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/','album_3',13,0,1,0,10,0);
INSERT INTO Folder VALUES(22,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/','album_2',13,0,1,0,10,0);
INSERT INTO Folder VALUES(23,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/','album_1',13,0,1,0,10,0);
INSERT INTO Folder VALUES(24,'file:///builds/videolan/medialibrary/dummysamples/artist_8/','artist_8',1,0,1,0,0,0);
INSERT INTO Folder VALUES(25,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/','album_10',24,0,1,0,10,0);
INSERT INTO Folder VALUES(26,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/','album_9',24,0,1,0,10,0);
INSERT INTO Folder VALUES(27,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/','album_8',24,0,1,0,10,0);
INSERT INTO Folder VALUES(28,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/','album_7',24,0,1,0,10,0);
INSERT INTO Folder VALUES(29,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/','album_6',24,0,1,0,10,0);
INSERT INTO Folder VALUES(30,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/','album_5',24,0,1,0,10,0);
INSERT INTO Folder VALUES(31,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/','album_4',24,0,1,0,10,0);
INSERT INTO Folder VALUES(32,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/','album_3',24,0,1,0,10,0);
INSERT INTO Folder VALUES(33,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/','album_2',24,0,1,0,10,0);
INSERT INTO Folder VALUES(34,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/','album_1',24,0,1,0,10,0);
INSERT INTO Folder VALUES(35,'file:///builds/videolan/medialibrary/dummysamples/artist_7/','artist_7',1,0,1,0,0,0);
INSERT INTO Folder VALUES(36,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/','album_10',35,0,1,0,10,0);
INSERT INTO Folder VALUES(37,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/','album_9',35,0,1,0,10,0);
INSERT INTO Folder VALUES(38,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/','album_8',35,0,1,0,10,0);
INSERT INTO Folder VALUES(39,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/','album_7',35,0,1,0,10,0);
INSERT INTO Folder VALUES(40,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/','album_6',35,0,1,0,10,0);
INSERT INTO Folder VALUES(41,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/','album_5',35,0,1,0,10,0);
INSERT INTO Folder VALUES(42,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/','album_4',35,0,1,0,10,0);
INSERT INTO Folder VALUES(43,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/','album_3',35,0,1,0,10,0);
INSERT INTO Folder VALUES(44,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/','album_2',35,0,1,0,10,0);
INSERT INTO Folder VALUES(45,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/','album_1',35,0,1,0,10,0);
INSERT INTO Folder VALUES(46,'file:///builds/videolan/medialibrary/dummysamples/artist_6/','artist_6',1,0,1,0,0,0);
INSERT INTO Folder VALUES(47,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/','album_10',46,0,1,0,10,0);
INSERT INTO Folder VALUES(48,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/','album_9',46,0,1,0,10,0);
INSERT INTO Folder VALUES(49,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/','album_8',46,0,1,0,10,0);
INSERT INTO Folder VALUES(50,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/','album_7',46,0,1,0,10,0);
INSERT INTO Folder VALUES(51,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/','album_6',46,0,1,0,10,0);
INSERT INTO Folder VALUES(52,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/','album_5',46,0,1,0,10,0);
INSERT INTO Folder VALUES(53,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/','album_4',46,0,1,0,10,0);
INSERT INTO Folder VALUES(54,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/','album_3',46,0,1,0,10,0);
INSERT INTO Folder VALUES(55,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/','album_2',46,0,1,0,10,0);
INSERT INTO Folder VALUES(56,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/','album_1',46,0,1,0,10,0);
INSERT INTO Folder VALUES(57,'file:///builds/videolan/medialibrary/dummysamples/artist_5/','artist_5',1,0,1,0,0,0);
INSERT INTO Folder VALUES(58,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/','album_10',57,0,1,0,10,0);
INSERT INTO Folder VALUES(59,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/','album_9',57,0,1,0,10,0);
INSERT INTO Folder VALUES(60,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/','album_8',57,0,1,0,10,0);
INSERT INTO Folder VALUES(61,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/','album_7',57,0,1,0,10,0);
INSERT INTO Folder VALUES(62,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/','album_6',57,0,1,0,10,0);
INSERT INTO Folder VALUES(63,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/','album_5',57,0,1,0,10,0);
INSERT INTO Folder VALUES(64,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/','album_4',57,0,1,0,10,0);
INSERT INTO Folder VALUES(65,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/','album_3',57,0,1,0,10,0);
INSERT INTO Folder VALUES(66,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/','album_2',57,0,1,0,10,0);
INSERT INTO Folder VALUES(67,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/','album_1',57,0,1,0,10,0);
INSERT INTO Folder VALUES(68,'file:///builds/videolan/medialibrary/dummysamples/artist_4/','artist_4',1,0,1,0,0,0);
INSERT INTO Folder VALUES(69,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/','album_10',68,0,1,0,10,0);
INSERT INTO Folder VALUES(70,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/','album_9',68,0,1,0,10,0);
INSERT INTO Folder VALUES(71,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/','album_8',68,0,1,0,10,0);
INSERT INTO Folder VALUES(72,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/','album_7',68,0,1,0,10,0);
INSERT INTO Folder VALUES(73,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/','album_6',68,0,1,0,10,0);
INSERT INTO Folder VALUES(74,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/','album_5',68,0,1,0,10,0);
INSERT INTO Folder VALUES(75,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/','album_4',68,0,1,0,10,0);
INSERT INTO Folder VALUES(76,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/','album_3',68,0,1,0,10,0);
INSERT INTO Folder VALUES(77,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/','album_2',68,0,1,0,10,0);
INSERT INTO Folder VALUES(78,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/','album_1',68,0,1,0,10,0);
INSERT INTO Folder VALUES(79,'file:///builds/videolan/medialibrary/dummysamples/artist_3/','artist_3',1,0,1,0,0,0);
INSERT INTO Folder VALUES(80,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/','album_10',79,0,1,0,10,0);
INSERT INTO Folder VALUES(81,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/','album_9',79,0,1,0,10,0);
INSERT INTO Folder VALUES(82,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/','album_8',79,0,1,0,10,0);
INSERT INTO Folder VALUES(83,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/','album_7',79,0,1,0,10,0);
INSERT INTO Folder VALUES(84,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/','album_6',79,0,1,0,10,0);
INSERT INTO Folder VALUES(85,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/','album_5',79,0,1,0,10,0);
INSERT INTO Folder VALUES(86,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/','album_4',79,0,1,0,10,0);
INSERT INTO Folder VALUES(87,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/','album_3',79,0,1,0,10,0);
INSERT INTO Folder VALUES(88,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/','album_2',79,0,1,0,10,0);
INSERT INTO Folder VALUES(89,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/','album_1',79,0,1,0,10,0);
INSERT INTO Folder VALUES(90,'file:///builds/videolan/medialibrary/dummysamples/artist_2/','artist_2',1,0,1,0,0,0);
INSERT INTO Folder VALUES(91,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/','album_10',90,0,1,0,10,0);
INSERT INTO Folder VALUES(92,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/','album_9',90,0,1,0,10,0);
INSERT INTO Folder VALUES(93,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/','album_8',90,0,1,0,10,0);
INSERT INTO Folder VALUES(94,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/','album_7',90,0,1,0,10,0);
INSERT INTO Folder VALUES(95,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/','album_6',90,0,1,0,10,0);
INSERT INTO Folder VALUES(96,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/','album_5',90,0,1,0,10,0);
INSERT INTO Folder VALUES(97,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/','album_4',90,0,1,0,10,0);
INSERT INTO Folder VALUES(98,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/','album_3',90,0,1,0,10,0);
INSERT INTO Folder VALUES(99,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/','album_2',90,0,1,0,10,0);
INSERT INTO Folder VALUES(100,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/','album_1',90,0,1,0,10,0);
INSERT INTO Folder VALUES(101,'file:///builds/videolan/medialibrary/dummysamples/artist_1/','artist_1',1,0,1,0,0,0);
INSERT INTO Folder VALUES(102,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/','album_10',101,0,1,0,10,0);
INSERT INTO Folder VALUES(103,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/','album_9',101,0,1,0,10,0);
INSERT INTO Folder VALUES(104,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/','album_8',101,0,1,0,10,0);
INSERT INTO Folder VALUES(105,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/','album_7',101,0,1,0,10,0);
INSERT INTO Folder VALUES(106,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/','album_6',101,0,1,0,10,0);
INSERT INTO Folder VALUES(107,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/','album_5',101,0,1,0,10,0);
INSERT INTO Folder VALUES(108,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/','album_4',101,0,1,0,10,0);
INSERT INTO Folder VALUES(109,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/','album_3',101,0,1,0,10,0);
INSERT INTO Folder VALUES(110,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/','album_2',101,0,1,0,10,0);
INSERT INTO Folder VALUES(111,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/','album_1',101,0,1,0,10,0);
INSERT INTO Media VALUES(1,2,3,639,-1.0,-1,0,NULL,1648793056,2010,'track_1','track_1.mp3',0,1,1,0,3,0,NULL,0,3,1,1,1,0,NULL);
INSERT INTO Media VALUES(2,2,3,639,-1.0,-1,0,NULL,1648793056,2010,'track_2','track_2.mp3',0,1,1,0,3,0,NULL,0,3,2,2,1,0,NULL);
INSERT INTO Media VALUES(3,2,3,639,-1.0,-1,0,NULL,1648793056,2010,'track_3','track_3.mp3',0,1,1,0,3,0,NULL,0,3,3,3,1,0,NULL);
INSERT INTO Media VALUES(4,2,3,639,-1.0,-1,0,NULL,1648793056,2010,'track_4','track_4.mp3',0,1,1,0,3,0,NULL,0,3,4,4,1,0,NULL);
INSERT INTO Media VALUES(5,2,3,639,-1.0,-1,0,NULL,1648793056,2010,'track_5','track_5.mp3',0,1,1,0,3,0,NULL,0,3,5,5,1,0,NULL);
INSERT INTO Media VALUES(6,2,3,639,-1.0,-1,0,NULL,1648793056,2010,'track_6','track_6.mp3',0,1,1,0,3,0,NULL,0,3,6,6,1,0,NULL);
INSERT INTO Media VALUES(7,2,3,639,-1.0,-1,0,NULL,1648793056,2010,'track_7','track_7.mp3',0,1,1,0,3,0,NULL,0,3,7,7,1,0,NULL);
INSERT INTO Media VALUES(8,2,3,639,-1.0,-1,0,NULL,1648793056,2010,'track_8','track_8.mp3',0,1,1,0,3,0,NULL,0,3,8,8,1,0,NULL);
INSERT INTO Media VALUES(9,2,3,639,-1.0,-1,0,NULL,1648793056,2010,'track_9','track_9.mp3',0,1,1,0,3,0,NULL,0,3,9,9,1,0,NULL);
INSERT INTO Media VALUES(10,2,3,639,-1.0,-1,0,NULL,1648793056,2010,'track_10','track_10.mp3',0,1,1,0,3,0,NULL,0,3,7,10,1,0,NULL);
INSERT INTO Media VALUES(11,2,3,639,-1.0,-1,0,NULL,1648793056,2009,'track_1','track_1.mp3',0,1,1,0,4,0,NULL,0,3,10,1,2,0,NULL);
INSERT INTO Media VALUES(12,2,3,639,-1.0,-1,0,NULL,1648793056,2009,'track_2','track_2.mp3',0,1,1,0,4,0,NULL,0,3,11,2,2,0,NULL);
INSERT INTO Media VALUES(13,2,3,639,-1.0,-1,0,NULL,1648793056,2009,'track_3','track_3.mp3',0,1,1,0,4,0,NULL,0,3,12,3,2,0,NULL);
INSERT INTO Media VALUES(14,2,3,639,-1.0,-1,0,NULL,1648793056,2009,'track_4','track_4.mp3',0,1,1,0,4,0,NULL,0,3,4,4,2,0,NULL);
INSERT INTO Media VALUES(15,2,3,639,-1.0,-1,0,NULL,1648793056,2009,'track_5','track_5.mp3',0,1,1,0,4,0,NULL,0,3,13,5,2,0,NULL);
INSERT INTO Media VALUES(16,2,3,639,-1.0,-1,0,NULL,1648793056,2009,'track_6','track_6.mp3',0,1,1,0,4,0,NULL,0,3,14,6,2,0,NULL);
INSERT INTO Media VALUES(17,2,3,639,-1.0,-1,0,NULL,1648793056,2009,'track_7','track_7.mp3',0,1,1,0,4,0,NULL,0,3,9,7,2,0,NULL);
INSERT INTO Media VALUES(18,2,3,639,-1.0,-1,0,NULL,1648793056,2009,'track_8','track_8.mp3',0,1,1,0,4,0,NULL,0,3,12,8,2,0,NULL);
INSERT INTO Media VALUES(19,2,3,639,-1.0,-1,0,NULL,1648793056,2009,'track_9','track_9.mp3',0,1,1,0,4,0,NULL,0,3,7,9,2,0,NULL);
INSERT INTO Media VALUES(20,2,3,639,-1.0,-1,0,NULL,1648793056,2009,'track_10','track_10.mp3',0,1,1,0,4,0,NULL,0,3,15,10,2,0,NULL);
INSERT INTO Media VALUES(21,2,3,639,-1.0,-1,0,NULL,1648793056,2008,'track_1','track_1.mp3',0,1,1,0,5,0,NULL,0,3,16,1,3,0,NULL);
INSERT INTO Media VALUES(22,2,3,639,-1.0,-1,0,NULL,1648793056,2008,'track_2','track_2.mp3',0,1,1,0,5,0,NULL,0,3,17,2,3,0,NULL);
INSERT INTO Media VALUES(23,2,3,639,-1.0,-1,0,NULL,1648793056,2008,'track_3','track_3.mp3',0,1,1,0,5,0,NULL,0,3,10,3,3,0,NULL);
INSERT INTO Media VALUES(24,2,3,639,-1.0,-1,0,NULL,1648793056,2008,'track_4','track_4.mp3',0,1,1,0,5,0,NULL,0,3,18,4,3,0,NULL);
INSERT INTO Media VALUES(25,2,3,639,-1.0,-1,0,NULL,1648793056,2008,'track_5','track_5.mp3',0,1,1,0,5,0,NULL,0,3,5,5,3,0,NULL);
INSERT INTO Media VALUES(26,2,3,639,-1.0,-1,0,NULL,1648793056,2008,'track_6','track_6.mp3',0,1,1,0,5,0,NULL,0,3,17,6,3,0,NULL);
INSERT INTO Media VALUES(27,2,3,639,-1.0,-1,0,NULL,1648793056,2008,'track_7','track_7.mp3',0,1,1,0,5,0,NULL,0,3,19,7,3,0,NULL);
INSERT INTO Media VALUES(28,2,3,639,-1.0,-1,0,NULL,1648793056,2008,'track_8','track_8.mp3',0,1,1,0,5,0,NULL,0,3,20,8,3,0,NULL);
INSERT INTO Media VALUES(29,2,3,639,-1.0,-1,0,NULL,1648793056,2008,'track_9','track_9.mp3',0,1,1,0,5,0,NULL,0,3,21,9,3,0,NULL);
INSERT INTO Media VALUES(30,2,3,639,-1.0,-1,0,NULL,1648793056,2008,'track_10','track_10.mp3',0,1,1,0,5,0,NULL,0,3,9,10,3,0,NULL);
INSERT INTO Media VALUES(31,2,3,639,-1.0,-1,0,NULL,1648793056,2007,'track_1','track_1.mp3',0,1,1,0,6,0,NULL,0,3,22,1,4,0,NULL);
INSERT INTO Media VALUES(32,2,3,639,-1.0,-1,0,NULL,1648793056,2007,'track_2','track_2.mp3',0,1,1,0,6,0,NULL,0,3,7,2,4,0,NULL);
INSERT INTO Media VALUES(33,2,3,639,-1.0,-1,0,NULL,1648793056,2007,'track_3','track_3.mp3',0,1,1,0,6,0,NULL,0,3,23,3,4,0,NULL);
INSERT INTO Media VALUES(34,2,3,639,-1.0,-1,0,NULL,1648793056,2007,'track_4','track_4.mp3',0,1,1,0,6,0,NULL,0,3,6,4,4,0,NULL);
INSERT INTO Media VALUES(35,2,3,639,-1.0,-1,0,NULL,1648793056,2007,'track_5','track_5.mp3',0,1,1,0,6,0,NULL,0,3,24,5,4,0,NULL);
INSERT INTO Media VALUES(36,2,3,639,-1.0,-1,0,NULL,1648793056,2007,'track_6','track_6.mp3',0,1,1,0,6,0,NULL,0,3,12,6,4,0,NULL);
INSERT INTO Media VALUES(37,2,3,639,-1.0,-1,0,NULL,1648793056,2007,'track_7','track_7.mp3',0,1,1,0,6,0,NULL,0,3,9,7,4,0,NULL);
INSERT INTO Media VALUES(38,2,3,639,-1.0,-1,0,NULL,1648793056,2007,'track_8','track_8.mp3',0,1,1,0,6,0,NULL,0,3,1,8,4,0,NULL);
INSERT INTO Media VALUES(39,2,3,639,-1.0,-1,0,NULL,1648793056,2007,'track_9','track_9.mp3',0,1,1,0,6,0,NULL,0,3,25,9,4,0,NULL);
INSERT INTO Media VALUES(40,2,3,639,-1.0,-1,0,NULL,1648793056,2007,'track_10','track_10.mp3',0,1,1,0,6,0,NULL,0,3,26,10,4,0,NULL);
INSERT INTO Media VALUES(41,2,3,639,-1.0,-1,0,NULL,1648793056,2006,'track_1','track_1.mp3',0,1,1,0,7,0,NULL,0,3,27,1,5,0,NULL);
INSERT INTO Media VALUES(42,2,3,639,-1.0,-1,0,NULL,1648793056,2006,'track_2','track_2.mp3',0,1,1,0,7,0,NULL,0,3,28,2,5,0,NULL);
INSERT INTO Media VALUES(43,2,3,639,-1.0,-1,0,NULL,1648793056,2006,'track_3','track_3.mp3',0,1,1,0,7,0,NULL,0,3,29,3,5,0,NULL);
INSERT INTO Media VALUES(44,2,3,639,-1.0,-1,0,NULL,1648793056,2006,'track_4','track_4.mp3',0,1,1,0,7,0,NULL,0,3,28,4,5,0,NULL);
INSERT INTO Media VALUES(45,2,3,639,-1.0,-1,0,NULL,1648793056,2006,'track_5','track_5.mp3',0,1,1,0,7,0,NULL,0,3,19,5,5,0,NULL);
INSERT INTO Media VALUES(46,2,3,639,-1.0,-1,0,NULL,1648793056,2006,'track_6','track_6.mp3',0,1,1,0,7,0,NULL,0,3,30,6,5,0,NULL);
INSERT INTO Media VALUES(47,2,3,639,-1.0,-1,0,NULL,1648793056,2006,'track_7','track_7.mp3',0,1,1,0,7,0,NULL,0,3,31,7,5,0,NULL);
INSERT INTO Media VALUES(48,2,3,639,-1.0,-1,0,NULL,1648793056,2006,'track_8','track_8.mp3',0,1,1,0,7,0,NULL,0,3,20,8,5,0,NULL);
INSERT INTO Media VALUES(49,2,3,639,-1.0,-1,0,NULL,1648793056,2006,'track_9','track_9.mp3',0,1,1,0,7,0,NULL,0,3,19,9,5,0,NULL);
INSERT INTO Media VALUES(50,2,3,639,-1.0,-1,0,NULL,1648793056,2006,'track_10','track_10.mp3',0,1,1,0,7,0,NULL,0,3,20,10,5,0,NULL);
INSERT INTO Media VALUES(51,2,3,639,-1.0,-1,0,NULL,1648793056,2005,'track_1','track_1.mp3',0,1,1,0,8,0,NULL,0,3,11,1,6,0,NULL);
INSERT INTO Media VALUES(52,2,3,639,-1.0,-1,0,NULL,1648793056,2005,'track_2','track_2.mp3',0,1,1,0,8,0,NULL,0,3,32,2,6,0,NULL);
INSERT INTO Media VALUES(53,2,3,639,-1.0,-1,0,NULL,1648793056,2005,'track_3','track_3.mp3',0,1,1,0,8,0,NULL,0,3,33,3,6,0,NULL);
INSERT INTO Media VALUES(54,2,3,639,-1.0,-1,0,NULL,1648793056,2005,'track_4','track_4.mp3',0,1,1,0,8,0,NULL,0,3,34,4,6,0,NULL);
INSERT INTO Media VALUES(55,2,3,639,-1.0,-1,0,NULL,1648793056,2005,'track_5','track_5.mp3',0,1,1,0,8,0,NULL,0,3,35,5,6,0,NULL);
INSERT INTO Media VALUES(56,2,3,639,-1.0,-1,0,NULL,1648793056,2005,'track_6','track_6.mp3',0,1,1,0,8,0,NULL,0,3,36,6,6,0,NULL);
INSERT INTO Media VALUES(57,2,3,639,-1.0,-1,0,NULL,1648793056,2005,'track_7','track_7.mp3',0,1,1,0,8,0,NULL,0,3,37,7,6,0,NULL);
INSERT INTO Media VALUES(58,2,3,639,-1.0,-1,0,NULL,1648793056,2005,'track_8','track_8.mp3',0,1,1,0,8,0,NULL,0,3,13,8,6,0,NULL);
INSERT INTO Media VALUES(59,2,3,639,-1.0,-1,0,NULL,1648793056,2005,'track_9','track_9.mp3',0,1,1,0,8,0,NULL,0,3,38,9,6,0,NULL);
INSERT INTO Media VALUES(60,2,3,639,-1.0,-1,0,NULL,1648793056,2005,'track_10','track_10.mp3',0,1,1,0,8,0,NULL,0,3,24,10,6,0,NULL);
INSERT INTO Media VALUES(61,2,3,639,-1.0,-1,0,NULL,1648793056,2004,'track_1','track_1.mp3',0,1,1,0,9,0,NULL,0,3,32,1,7,0,NULL);
INSERT INTO Media VALUES(62,2,3,639,-1.0,-1,0,NULL,1648793056,2004,'track_2','track_2.mp3',0,1,1,0,9,0,NULL,0,3,39,2,7,0,NULL);
INSERT INTO Media VALUES(63,2,3,639,-1.0,-1,0,NULL,1648793056,2004,'track_3','track_3.mp3',0,1,1,0,9,0,NULL,0,3,7,3,7,0,NULL);
INSERT INTO Media VALUES(64,2,3,639,-1.0,-1,0,NULL,1648793056,2004,'track_4','track_4.mp3',0,1,1,0,9,0,NULL,0,3,34,4,7,0,NULL);
INSERT INTO Media VALUES(65,2,3,639,-1.0,-1,0,NULL,1648793056,2004,'track_5','track_5.mp3',0,1,1,0,9,0,NULL,0,3,40,5,7,0,NULL);
INSERT INTO Media VALUES(66,2,3,639,-1.0,-1,0,NULL,1648793056,2004,'track_6','track_6.mp3',0,1,1,0,9,0,NULL,0,3,6,6,7,0,NULL);
INSERT INTO Media VALUES(67,2,3,639,-1.0,-1,0,NULL,1648793056,2004,'track_7','track_7.mp3',0,1,1,0,9,0,NULL,0,3,41,7,7,0,NULL);
INSERT INTO Media VALUES(68,2,3,639,-1.0,-1,0,NULL,1648793056,2004,'track_8','track_8.mp3',0,1,1,0,9,0,NULL,0,3,7,8,7,0,NULL);
INSERT INTO Media VALUES(69,2,3,639,-1.0,-1,0,NULL,1648793056,2004,'track_9','track_9.mp3',0,1,1,0,9,0,NULL,0,3,42,9,7,0,NULL);
INSERT INTO Media VALUES(70,2,3,639,-1.0,-1,0,NULL,1648793056,2004,'track_10','track_10.mp3',0,1,1,0,9,0,NULL,0,3,19,10,7,0,NULL);
INSERT INTO Media VALUES(71,2,3,639,-1.0,-1,0,NULL,1648793056,2003,'track_1','track_1.mp3',0,1,1,0,10,0,NULL,0,3,43,1,8,0,NULL);
INSERT INTO Media VALUES(72,2,3,639,-1.0,-1,0,NULL,1648793056,2003,'track_2','track_2.mp3',0,1,1,0,10,0,NULL,0,3,44,2,8,0,NULL);
INSERT INTO Media VALUES(73,2,3,639,-1.0,-1,0,NULL,1648793056,2003,'track_3','track_3.mp3',0,1,1,0,10,0,NULL,0,3,45,3,8,0,NULL);
INSERT INTO Media VALUES(74,2,3,639,-1.0,-1,0,NULL,1648793056,2003,'track_4','track_4.mp3',0,1,1,0,10,0,NULL,0,3,36,4,8,0,NULL);
INSERT INTO Media VALUES(75,2,3,639,-1.0,-1,0,NULL,1648793056,2003,'track_5','track_5.mp3',0,1,1,0,10,0,NULL,0,3,46,5,8,0,NULL);
INSERT INTO Media VALUES(76,2,3,639,-1.0,-1,0,NULL,1648793056,2003,'track_6','track_6.mp3',0,1,1,0,10,0,NULL,0,3,47,6,8,0,NULL);
INSERT INTO Media VALUES(77,2,3,639,-1.0,-1,0,NULL,1648793056,2003,'track_7','track_7.mp3',0,1,1,0,10,0,NULL,0,3,30,7,8,0,NULL);
INSERT INTO Media VALUES(78,2,3,639,-1.0,-1,0,NULL,1648793056,2003,'track_8','track_8.mp3',0,1,1,0,10,0,NULL,0,3,43,8,8,0,NULL);
INSERT INTO Media VALUES(79,2,3,639,-1.0,-1,0,NULL,1648793056,2003,'track_9','track_9.mp3',0,1,1,0,10,0,NULL,0,3,48,9,8,0,NULL);
INSERT INTO Media VALUES(80,2,3,639,-1.0,-1,0,NULL,1648793056,2003,'track_10','track_10.mp3',0,1,1,0,10,0,NULL,0,3,49,10,8,0,NULL);
INSERT INTO Media VALUES(81,2,3,639,-1.0,-1,0,NULL,1648793056,2002,'track_1','track_1.mp3',0,1,1,0,11,0,NULL,0,3,50,1,9,0,NULL);
INSERT INTO Media VALUES(82,2,3,639,-1.0,-1,0,NULL,1648793056,2002,'track_2','track_2.mp3',0,1,1,0,11,0,NULL,0,3,24,2,9,0,NULL);
INSERT INTO Media VALUES(83,2,3,639,-1.0,-1,0,NULL,1648793056,2002,'track_3','track_3.mp3',0,1,1,0,11,0,NULL,0,3,46,3,9,0,NULL);
INSERT INTO Media VALUES(84,2,3,639,-1.0,-1,0,NULL,1648793056,2002,'track_4','track_4.mp3',0,1,1,0,11,0,NULL,0,3,51,4,9,0,NULL);
INSERT INTO Media VALUES(85,2,3,639,-1.0,-1,0,NULL,1648793056,2002,'track_5','track_5.mp3',0,1,1,0,11,0,NULL,0,3,2,5,9,0,NULL);
INSERT INTO Media VALUES(86,2,3,639,-1.0,-1,0,NULL,1648793056,2002,'track_6','track_6.mp3',0,1,1,0,11,0,NULL,0,3,40,6,9,0,NULL);
INSERT INTO Media VALUES(87,2,3,639,-1.0,-1,0,NULL,1648793056,2002,'track_7','track_7.mp3',0,1,1,0,11,0,NULL,0,3,40,7,9,0,NULL);
INSERT INTO Media VALUES(88,2,3,639,-1.0,-1,0,NULL,1648793056,2002,'track_8','track_8.mp3',0,1,1,0,11,0,NULL,0,3,52,8,9,0,NULL);
INSERT INTO Media VALUES(89,2,3,639,-1.0,-1,0,NULL,1648793056,2002,'track_9','track_9.mp3',0,1,1,0,11,0,NULL,0,3,18,9,9,0,NULL);
INSERT INTO Media VALUES(90,2,3,639,-1.0,-1,0,NULL,1648793056,2002,'track_10','track_10.mp3',0,1,1,0,11,0,NULL,0,3,28,10,9,0,NULL);
INSERT INTO Media VALUES(91,2,3,639,-1.0,-1,0,NULL,1648793056,2001,'track_1','track_1.mp3',0,1,1,0,12,0,NULL,0,3,34,1,10,0,NULL);
INSERT INTO Media VALUES(92,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_2','track_2.mp3',0,1,1,0,12,0,NULL,0,3,53,2,10,0,NULL);
INSERT INTO Media VALUES(93,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_3','track_3.mp3',0,1,1,0,12,0,NULL,0,3,54,3,10,0,NULL);
INSERT INTO Media VALUES(94,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_4','track_4.mp3',0,1,1,0,12,0,NULL,0,3,55,4,10,0,NULL);
INSERT INTO Media VALUES(95,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_5','track_5.mp3',0,1,1,0,12,0,NULL,0,3,29,5,10,0,NULL);
INSERT INTO Media VALUES(96,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_6','track_6.mp3',0,1,1,0,12,0,NULL,0,3,51,6,10,0,NULL);
INSERT INTO Media VALUES(97,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_7','track_7.mp3',0,1,1,0,12,0,NULL,0,3,18,7,10,0,NULL);
INSERT INTO Media VALUES(98,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_8','track_8.mp3',0,1,1,0,12,0,NULL,0,3,56,8,10,0,NULL);
INSERT INTO Media VALUES(99,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_9','track_9.mp3',0,1,1,0,12,0,NULL,0,3,57,9,10,0,NULL);
INSERT INTO Media VALUES(100,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_10','track_10.mp3',0,1,1,0,12,0,NULL,0,3,15,10,10,0,NULL);
INSERT INTO Media VALUES(101,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_1','track_1.mp3',0,1,1,0,14,0,NULL,0,4,58,1,11,0,NULL);
INSERT INTO Media VALUES(102,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_2','track_2.mp3',0,1,1,0,14,0,NULL,0,4,59,2,11,0,NULL);
INSERT INTO Media VALUES(103,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_3','track_3.mp3',0,1,1,0,14,0,NULL,0,4,53,3,11,0,NULL);
INSERT INTO Media VALUES(104,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_4','track_4.mp3',0,1,1,0,14,0,NULL,0,4,17,4,11,0,NULL);
INSERT INTO Media VALUES(105,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_5','track_5.mp3',0,1,1,0,14,0,NULL,0,4,43,5,11,0,NULL);
INSERT INTO Media VALUES(106,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_6','track_6.mp3',0,1,1,0,14,0,NULL,0,4,10,6,11,0,NULL);
INSERT INTO Media VALUES(107,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_7','track_7.mp3',0,1,1,0,14,0,NULL,0,4,24,7,11,0,NULL);
INSERT INTO Media VALUES(108,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_8','track_8.mp3',0,1,1,0,14,0,NULL,0,4,50,8,11,0,NULL);
INSERT INTO Media VALUES(109,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_9','track_9.mp3',0,1,1,0,14,0,NULL,0,4,23,9,11,0,NULL);
INSERT INTO Media VALUES(110,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_10','track_10.mp3',0,1,1,0,14,0,NULL,0,4,60,10,11,0,NULL);
INSERT INTO Media VALUES(111,2,3,639,-1.0,-1,0,NULL,1648793057,2009,'track_1','track_1.mp3',0,1,1,0,15,0,NULL,0,4,61,1,12,0,NULL);
INSERT INTO Media VALUES(112,2,3,639,-1.0,-1,0,NULL,1648793057,2009,'track_2','track_2.mp3',0,1,1,0,15,0,NULL,0,4,14,2,12,0,NULL);
INSERT INTO Media VALUES(113,2,3,639,-1.0,-1,0,NULL,1648793057,2009,'track_3','track_3.mp3',0,1,1,0,15,0,NULL,0,4,62,3,12,0,NULL);
INSERT INTO Media VALUES(114,2,3,639,-1.0,-1,0,NULL,1648793057,2009,'track_4','track_4.mp3',0,1,1,0,15,0,NULL,0,4,63,4,12,0,NULL);
INSERT INTO Media VALUES(115,2,3,639,-1.0,-1,0,NULL,1648793057,2009,'track_5','track_5.mp3',0,1,1,0,15,0,NULL,0,4,36,5,12,0,NULL);
INSERT INTO Media VALUES(116,2,3,639,-1.0,-1,0,NULL,1648793057,2009,'track_6','track_6.mp3',0,1,1,0,15,0,NULL,0,4,27,6,12,0,NULL);
INSERT INTO Media VALUES(117,2,3,639,-1.0,-1,0,NULL,1648793057,2009,'track_7','track_7.mp3',0,1,1,0,15,0,NULL,0,4,64,7,12,0,NULL);
INSERT INTO Media VALUES(118,2,3,639,-1.0,-1,0,NULL,1648793057,2009,'track_8','track_8.mp3',0,1,1,0,15,0,NULL,0,4,26,8,12,0,NULL);
INSERT INTO Media VALUES(119,2,3,639,-1.0,-1,0,NULL,1648793057,2009,'track_9','track_9.mp3',0,1,1,0,15,0,NULL,0,4,65,9,12,0,NULL);
INSERT INTO Media VALUES(120,2,3,639,-1.0,-1,0,NULL,1648793057,2009,'track_10','track_10.mp3',0,1,1,0,15,0,NULL,0,4,41,10,12,0,NULL);
INSERT INTO Media VALUES(121,2,3,639,-1.0,-1,0,NULL,1648793057,2008,'track_1','track_1.mp3',0,1,1,0,16,0,NULL,0,4,30,1,13,0,NULL);
INSERT INTO Media VALUES(122,2,3,639,-1.0,-1,0,NULL,1648793057,2008,'track_2','track_2.mp3',0,1,1,0,16,0,NULL,0,4,51,2,13,0,NULL);
INSERT INTO Media VALUES(123,2,3,639,-1.0,-1,0,NULL,1648793057,2008,'track_3','track_3.mp3',0,1,1,0,16,0,NULL,0,4,1,3,13,0,NULL);
INSERT INTO Media VALUES(124,2,3,639,-1.0,-1,0,NULL,1648793057,2008,'track_4','track_4.mp3',0,1,1,0,16,0,NULL,0,4,66,4,13,0,NULL);
INSERT INTO Media VALUES(125,2,3,639,-1.0,-1,0,NULL,1648793057,2008,'track_5','track_5.mp3',0,1,1,0,16,0,NULL,0,4,9,5,13,0,NULL);
INSERT INTO Media VALUES(126,2,3,639,-1.0,-1,0,NULL,1648793057,2008,'track_6','track_6.mp3',0,1,1,0,16,0,NULL,0,4,40,6,13,0,NULL);
INSERT INTO Media VALUES(127,2,3,639,-1.0,-1,0,NULL,1648793057,2008,'track_7','track_7.mp3',0,1,1,0,16,0,NULL,0,4,50,7,13,0,NULL);
INSERT INTO Media VALUES(128,2,3,639,-1.0,-1,0,NULL,1648793057,2008,'track_8','track_8.mp3',0,1,1,0,16,0,NULL,0,4,22,8,13,0,NULL);
INSERT INTO Media VALUES(129,2,3,639,-1.0,-1,0,NULL,1648793057,2008,'track_9','track_9.mp3',0,1,1,0,16,0,NULL,0,4,16,9,13,0,NULL);
INSERT INTO Media VALUES(130,2,3,639,-1.0,-1,0,NULL,1648793057,2008,'track_10','track_10.mp3',0,1,1,0,16,0,NULL,0,4,63,10,13,0,NULL);
INSERT INTO Media VALUES(131,2,3,639,-1.0,-1,0,NULL,1648793057,2007,'track_1','track_1.mp3',0,1,1,0,17,0,NULL,0,4,54,1,14,0,NULL);
INSERT INTO Media VALUES(132,2,3,639,-1.0,-1,0,NULL,1648793057,2007,'track_2','track_2.mp3',0,1,1,0,17,0,NULL,0,4,40,2,14,0,NULL);
INSERT INTO Media VALUES(133,2,3,639,-1.0,-1,0,NULL,1648793057,2007,'track_3','track_3.mp3',0,1,1,0,17,0,NULL,0,4,11,3,14,0,NULL);
INSERT INTO Media VALUES(134,2,3,639,-1.0,-1,0,NULL,1648793057,2007,'track_4','track_4.mp3',0,1,1,0,17,0,NULL,0,4,55,4,14,0,NULL);
INSERT INTO Media VALUES(135,2,3,639,-1.0,-1,0,NULL,1648793057,2007,'track_5','track_5.mp3',0,1,1,0,17,0,NULL,0,4,36,5,14,0,NULL);
INSERT INTO Media VALUES(136,2,3,639,-1.0,-1,0,NULL,1648793057,2007,'track_6','track_6.mp3',0,1,1,0,17,0,NULL,0,4,63,6,14,0,NULL);
INSERT INTO Media VALUES(137,2,3,639,-1.0,-1,0,NULL,1648793057,2007,'track_7','track_7.mp3',0,1,1,0,17,0,NULL,0,4,27,7,14,0,NULL);
INSERT INTO Media VALUES(138,2,3,639,-1.0,-1,0,NULL,1648793057,2007,'track_8','track_8.mp3',0,1,1,0,17,0,NULL,0,4,67,8,14,0,NULL);
INSERT INTO Media VALUES(139,2,3,639,-1.0,-1,0,NULL,1648793057,2007,'track_9','track_9.mp3',0,1,1,0,17,0,NULL,0,4,60,9,14,0,NULL);
INSERT INTO Media VALUES(140,2,3,639,-1.0,-1,0,NULL,1648793057,2007,'track_10','track_10.mp3',0,1,1,0,17,0,NULL,0,4,68,10,14,0,NULL);
INSERT INTO Media VALUES(141,2,3,639,-1.0,-1,0,NULL,1648793057,2006,'track_1','track_1.mp3',0,1,1,0,18,0,NULL,0,4,44,1,15,0,NULL);
INSERT INTO Media VALUES(142,2,3,639,-1.0,-1,0,NULL,1648793057,2006,'track_2','track_2.mp3',0,1,1,0,18,0,NULL,0,4,69,2,15,0,NULL);
INSERT INTO Media VALUES(143,2,3,639,-1.0,-1,0,NULL,1648793057,2006,'track_3','track_3.mp3',0,1,1,0,18,0,NULL,0,4,46,3,15,0,NULL);
INSERT INTO Media VALUES(144,2,3,639,-1.0,-1,0,NULL,1648793057,2006,'track_4','track_4.mp3',0,1,1,0,18,0,NULL,0,4,70,4,15,0,NULL);
INSERT INTO Media VALUES(145,2,3,639,-1.0,-1,0,NULL,1648793057,2006,'track_5','track_5.mp3',0,1,1,0,18,0,NULL,0,4,53,5,15,0,NULL);
INSERT INTO Media VALUES(146,2,3,639,-1.0,-1,0,NULL,1648793057,2006,'track_6','track_6.mp3',0,1,1,0,18,0,NULL,0,4,71,6,15,0,NULL);
INSERT INTO Media VALUES(147,2,3,639,-1.0,-1,0,NULL,1648793057,2006,'track_7','track_7.mp3',0,1,1,0,18,0,NULL,0,4,16,7,15,0,NULL);
INSERT INTO Media VALUES(148,2,3,639,-1.0,-1,0,NULL,1648793057,2006,'track_8','track_8.mp3',0,1,1,0,18,0,NULL,0,4,72,8,15,0,NULL);
INSERT INTO Media VALUES(149,2,3,639,-1.0,-1,0,NULL,1648793057,2006,'track_9','track_9.mp3',0,1,1,0,18,0,NULL,0,4,61,9,15,0,NULL);
INSERT INTO Media VALUES(150,2,3,639,-1.0,-1,0,NULL,1648793057,2006,'track_10','track_10.mp3',0,1,1,0,18,0,NULL,0,4,20,10,15,0,NULL);
INSERT INTO Media VALUES(151,2,3,639,-1.0,-1,0,NULL,1648793057,2005,'track_1','track_1.mp3',0,1,1,0,19,0,NULL,0,4,15,1,16,0,NULL);
INSERT INTO Media VALUES(152,2,3,639,-1.0,-1,0,NULL,1648793057,2005,'track_2','track_2.mp3',0,1,1,0,19,0,NULL,0,4,19,2,16,0,NULL);
INSERT INTO Media VALUES(153,2,3,639,-1.0,-1,0,NULL,1648793057,2005,'track_3','track_3.mp3',0,1,1,0,19,0,NULL,0,4,4,3,16,0,NULL);
INSERT INTO Media VALUES(154,2,3,639,-1.0,-1,0,NULL,1648793057,2005,'track_4','track_4.mp3',0,1,1,0,19,0,NULL,0,4,8,4,16,0,NULL);
INSERT INTO Media VALUES(155,2,3,639,-1.0,-1,0,NULL,1648793057,2005,'track_5','track_5.mp3',0,1,1,0,19,0,NULL,0,4,48,5,16,0,NULL);
INSERT INTO Media VALUES(156,2,3,639,-1.0,-1,0,NULL,1648793057,2005,'track_6','track_6.mp3',0,1,1,0,19,0,NULL,0,4,28,6,16,0,NULL);
INSERT INTO Media VALUES(157,2,3,639,-1.0,-1,0,NULL,1648793057,2005,'track_7','track_7.mp3',0,1,1,0,19,0,NULL,0,4,31,7,16,0,NULL);
INSERT INTO Media VALUES(158,2,3,639,-1.0,-1,0,NULL,1648793057,2005,'track_8','track_8.mp3',0,1,1,0,19,0,NULL,0,4,21,8,16,0,NULL);
INSERT INTO Media VALUES(159,2,3,639,-1.0,-1,0,NULL,1648793057,2005,'track_9','track_9.mp3',0,1,1,0,19,0,NULL,0,4,21,9,16,0,NULL);
INSERT INTO Media VALUES(160,2,3,639,-1.0,-1,0,NULL,1648793057,2005,'track_10','track_10.mp3',0,1,1,0,19,0,NULL,0,4,27,10,16,0,NULL);
INSERT INTO Media VALUES(161,2,3,639,-1.0,-1,0,NULL,1648793057,2004,'track_1','track_1.mp3',0,1,1,0,20,0,NULL,0,4,73,1,17,0,NULL);
INSERT INTO Media VALUES(162,2,3,639,-1.0,-1,0,NULL,1648793057,2004,'track_2','track_2.mp3',0,1,1,0,20,0,NULL,0,4,6,2,17,0,NULL);
INSERT INTO Media VALUES(163,2,3,639,-1.0,-1,0,NULL,1648793057,2004,'track_3','track_3.mp3',0,1,1,0,20,0,NULL,0,4,66,3,17,0,NULL);
INSERT INTO Media VALUES(164,2,3,639,-1.0,-1,0,NULL,1648793057,2004,'track_4','track_4.mp3',0,1,1,0,20,0,NULL,0,4,51,4,17,0,NULL);
INSERT INTO Media VALUES(165,2,3,639,-1.0,-1,0,NULL,1648793057,2004,'track_5','track_5.mp3',0,1,1,0,20,0,NULL,0,4,2,5,17,0,NULL);
INSERT INTO Media VALUES(166,2,3,639,-1.0,-1,0,NULL,1648793057,2004,'track_6','track_6.mp3',0,1,1,0,20,0,NULL,0,4,31,6,17,0,NULL);
INSERT INTO Media VALUES(167,2,3,639,-1.0,-1,0,NULL,1648793057,2004,'track_7','track_7.mp3',0,1,1,0,20,0,NULL,0,4,64,7,17,0,NULL);
INSERT INTO Media VALUES(168,2,3,639,-1.0,-1,0,NULL,1648793057,2004,'track_8','track_8.mp3',0,1,1,0,20,0,NULL,0,4,70,8,17,0,NULL);
INSERT INTO Media VALUES(169,2,3,639,-1.0,-1,0,NULL,1648793057,2004,'track_9','track_9.mp3',0,1,1,0,20,0,NULL,0,4,17,9,17,0,NULL);
INSERT INTO Media VALUES(170,2,3,639,-1.0,-1,0,NULL,1648793057,2004,'track_10','track_10.mp3',0,1,1,0,20,0,NULL,0,4,7,10,17,0,NULL);
INSERT INTO Media VALUES(171,2,3,639,-1.0,-1,0,NULL,1648793057,2003,'track_1','track_1.mp3',0,1,1,0,21,0,NULL,0,4,52,1,18,0,NULL);
INSERT INTO Media VALUES(172,2,3,639,-1.0,-1,0,NULL,1648793057,2003,'track_2','track_2.mp3',0,1,1,0,21,0,NULL,0,4,11,2,18,0,NULL);
INSERT INTO Media VALUES(173,2,3,639,-1.0,-1,0,NULL,1648793057,2003,'track_3','track_3.mp3',0,1,1,0,21,0,NULL,0,4,48,3,18,0,NULL);
INSERT INTO Media VALUES(174,2,3,639,-1.0,-1,0,NULL,1648793057,2003,'track_4','track_4.mp3',0,1,1,0,21,0,NULL,0,4,73,4,18,0,NULL);
INSERT INTO Media VALUES(175,2,3,639,-1.0,-1,0,NULL,1648793057,2003,'track_5','track_5.mp3',0,1,1,0,21,0,NULL,0,4,61,5,18,0,NULL);
INSERT INTO Media VALUES(176,2,3,639,-1.0,-1,0,NULL,1648793057,2003,'track_6','track_6.mp3',0,1,1,0,21,0,NULL,0,4,32,6,18,0,NULL);
INSERT INTO Media VALUES(177,2,3,639,-1.0,-1,0,NULL,1648793057,2003,'track_7','track_7.mp3',0,1,1,0,21,0,NULL,0,4,74,7,18,0,NULL);
INSERT INTO Media VALUES(178,2,3,639,-1.0,-1,0,NULL,1648793057,2003,'track_8','track_8.mp3',0,1,1,0,21,0,NULL,0,4,5,8,18,0,NULL);
INSERT INTO Media VALUES(179,2,3,639,-1.0,-1,0,NULL,1648793057,2003,'track_9','track_9.mp3',0,1,1,0,21,0,NULL,0,4,55,9,18,0,NULL);
INSERT INTO Media VALUES(180,2,3,639,-1.0,-1,0,NULL,1648793057,2003,'track_10','track_10.mp3',0,1,1,0,21,0,NULL,0,4,43,10,18,0,NULL);
INSERT INTO Media VALUES(181,2,3,639,-1.0,-1,0,NULL,1648793057,2002,'track_1','track_1.mp3',0,1,1,0,22,0,NULL,0,4,21,1,19,0,NULL);
INSERT INTO Media VALUES(182,2,3,639,-1.0,-1,0,NULL,1648793057,2002,'track_2','track_2.mp3',0,1,1,0,22,0,NULL,0,4,51,2,19,0,NULL);
INSERT INTO Media VALUES(183,2,3,639,-1.0,-1,0,NULL,1648793057,2002,'track_3','track_3.mp3',0,1,1,0,22,0,NULL,0,4,45,3,19,0,NULL);
INSERT INTO Media VALUES(184,2,3,639,-1.0,-1,0,NULL,1648793057,2002,'track_4','track_4.mp3',0,1,1,0,22,0,NULL,0,4,44,4,19,0,NULL);
INSERT INTO Media VALUES(185,2,3,639,-1.0,-1,0,NULL,1648793057,2002,'track_5','track_5.mp3',0,1,1,0,22,0,NULL,0,4,41,5,19,0,NULL);
INSERT INTO Media VALUES(186,2,3,639,-1.0,-1,0,NULL,1648793057,2002,'track_6','track_6.mp3',0,1,1,0,22,0,NULL,0,4,5,6,19,0,NULL);
INSERT INTO Media VALUES(187,2,3,639,-1.0,-1,0,NULL,1648793057,2002,'track_7','track_7.mp3',0,1,1,0,22,0,NULL,0,4,28,7,19,0,NULL);
INSERT INTO Media VALUES(188,2,3,639,-1.0,-1,0,NULL,1648793057,2002,'track_8','track_8.mp3',0,1,1,0,22,0,NULL,0,4,73,8,19,0,NULL);
INSERT INTO Media VALUES(189,2,3,639,-1.0,-1,0,NULL,1648793057,2002,'track_9','track_9.mp3',0,1,1,0,22,0,NULL,0,4,69,9,19,0,NULL);
INSERT INTO Media VALUES(190,2,3,639,-1.0,-1,0,NULL,1648793057,2002,'track_10','track_10.mp3',0,1,1,0,22,0,NULL,0,4,9,10,19,0,NULL);
INSERT INTO Media VALUES(191,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_1','track_1.mp3',0,1,1,0,23,0,NULL,0,4,69,1,20,0,NULL);
INSERT INTO Media VALUES(192,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_2','track_2.mp3',0,1,1,0,23,0,NULL,0,4,40,2,20,0,NULL);
INSERT INTO Media VALUES(193,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_3','track_3.mp3',0,1,1,0,23,0,NULL,0,4,28,3,20,0,NULL);
INSERT INTO Media VALUES(194,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_4','track_4.mp3',0,1,1,0,23,0,NULL,0,4,59,4,20,0,NULL);
INSERT INTO Media VALUES(195,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_5','track_5.mp3',0,1,1,0,23,0,NULL,0,4,75,5,20,0,NULL);
INSERT INTO Media VALUES(196,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_6','track_6.mp3',0,1,1,0,23,0,NULL,0,4,68,6,20,0,NULL);
INSERT INTO Media VALUES(197,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_7','track_7.mp3',0,1,1,0,23,0,NULL,0,4,27,7,20,0,NULL);
INSERT INTO Media VALUES(198,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_8','track_8.mp3',0,1,1,0,23,0,NULL,0,4,6,8,20,0,NULL);
INSERT INTO Media VALUES(199,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_9','track_9.mp3',0,1,1,0,23,0,NULL,0,4,59,9,20,0,NULL);
INSERT INTO Media VALUES(200,2,3,639,-1.0,-1,0,NULL,1648793057,2001,'track_10','track_10.mp3',0,1,1,0,23,0,NULL,0,4,74,10,20,0,NULL);
INSERT INTO Media VALUES(201,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_1','track_1.mp3',0,1,1,0,25,0,NULL,0,5,66,1,21,0,NULL);
INSERT INTO Media VALUES(202,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_2','track_2.mp3',0,1,1,0,25,0,NULL,0,5,3,2,21,0,NULL);
INSERT INTO Media VALUES(203,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_3','track_3.mp3',0,1,1,0,25,0,NULL,0,5,22,3,21,0,NULL);
INSERT INTO Media VALUES(204,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_4','track_4.mp3',0,1,1,0,25,0,NULL,0,5,46,4,21,0,NULL);
INSERT INTO Media VALUES(205,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_5','track_5.mp3',0,1,1,0,25,0,NULL,0,5,9,5,21,0,NULL);
INSERT INTO Media VALUES(206,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_6','track_6.mp3',0,1,1,0,25,0,NULL,0,5,31,6,21,0,NULL);
INSERT INTO Media VALUES(207,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_7','track_7.mp3',0,1,1,0,25,0,NULL,0,5,65,7,21,0,NULL);
INSERT INTO Media VALUES(208,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_8','track_8.mp3',0,1,1,0,25,0,NULL,0,5,63,8,21,0,NULL);
INSERT INTO Media VALUES(209,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_9','track_9.mp3',0,1,1,0,25,0,NULL,0,5,10,9,21,0,NULL);
INSERT INTO Media VALUES(210,2,3,639,-1.0,-1,0,NULL,1648793057,2010,'track_10','track_10.mp3',0,1,1,0,25,0,NULL,0,5,39,10,21,0,NULL);
INSERT INTO Media VALUES(211,2,3,639,-1.0,-1,0,NULL,1648793057,2009,'track_1','track_1.mp3',0,1,1,0,26,0,NULL,0,5,75,1,22,0,NULL);
INSERT INTO Media VALUES(212,2,3,639,-1.0,-1,0,NULL,1648793057,2009,'track_2','track_2.mp3',0,1,1,0,26,0,NULL,0,5,76,2,22,0,NULL);
INSERT INTO Media VALUES(213,2,3,639,-1.0,-1,0,NULL,1648793057,2009,'track_3','track_3.mp3',0,1,1,0,26,0,NULL,0,5,62,3,22,0,NULL);
INSERT INTO Media VALUES(214,2,3,639,-1.0,-1,0,NULL,1648793057,2009,'track_4','track_4.mp3',0,1,1,0,26,0,NULL,0,5,76,4,22,0,NULL);
INSERT INTO Media VALUES(215,2,3,639,-1.0,-1,0,NULL,1648793057,2009,'track_5','track_5.mp3',0,1,1,0,26,0,NULL,0,5,29,5,22,0,NULL);
INSERT INTO Media VALUES(216,2,3,639,-1.0,-1,0,NULL,1648793058,2009,'track_6','track_6.mp3',0,1,1,0,26,0,NULL,0,5,64,6,22,0,NULL);
INSERT INTO Media VALUES(217,2,3,639,-1.0,-1,0,NULL,1648793058,2009,'track_7','track_7.mp3',0,1,1,0,26,0,NULL,0,5,20,7,22,0,NULL);
INSERT INTO Media VALUES(218,2,3,639,-1.0,-1,0,NULL,1648793058,2009,'track_8','track_8.mp3',0,1,1,0,26,0,NULL,0,5,75,8,22,0,NULL);
INSERT INTO Media VALUES(219,2,3,639,-1.0,-1,0,NULL,1648793058,2009,'track_9','track_9.mp3',0,1,1,0,26,0,NULL,0,5,10,9,22,0,NULL);
INSERT INTO Media VALUES(220,2,3,639,-1.0,-1,0,NULL,1648793058,2009,'track_10','track_10.mp3',0,1,1,0,26,0,NULL,0,5,7,10,22,0,NULL);
INSERT INTO Media VALUES(221,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_1','track_1.mp3',0,1,1,0,27,0,NULL,0,5,77,1,23,0,NULL);
INSERT INTO Media VALUES(222,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_2','track_2.mp3',0,1,1,0,27,0,NULL,0,5,49,2,23,0,NULL);
INSERT INTO Media VALUES(223,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_3','track_3.mp3',0,1,1,0,27,0,NULL,0,5,63,3,23,0,NULL);
INSERT INTO Media VALUES(224,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_4','track_4.mp3',0,1,1,0,27,0,NULL,0,5,45,4,23,0,NULL);
INSERT INTO Media VALUES(225,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_5','track_5.mp3',0,1,1,0,27,0,NULL,0,5,33,5,23,0,NULL);
INSERT INTO Media VALUES(226,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_6','track_6.mp3',0,1,1,0,27,0,NULL,0,5,55,6,23,0,NULL);
INSERT INTO Media VALUES(227,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_7','track_7.mp3',0,1,1,0,27,0,NULL,0,5,13,7,23,0,NULL);
INSERT INTO Media VALUES(228,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_8','track_8.mp3',0,1,1,0,27,0,NULL,0,5,69,8,23,0,NULL);
INSERT INTO Media VALUES(229,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_9','track_9.mp3',0,1,1,0,27,0,NULL,0,5,58,9,23,0,NULL);
INSERT INTO Media VALUES(230,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_10','track_10.mp3',0,1,1,0,27,0,NULL,0,5,67,10,23,0,NULL);
INSERT INTO Media VALUES(231,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_1','track_1.mp3',0,1,1,0,28,0,NULL,0,5,6,1,24,0,NULL);
INSERT INTO Media VALUES(232,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_2','track_2.mp3',0,1,1,0,28,0,NULL,0,5,5,2,24,0,NULL);
INSERT INTO Media VALUES(233,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_3','track_3.mp3',0,1,1,0,28,0,NULL,0,5,73,3,24,0,NULL);
INSERT INTO Media VALUES(234,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_4','track_4.mp3',0,1,1,0,28,0,NULL,0,5,26,4,24,0,NULL);
INSERT INTO Media VALUES(235,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_5','track_5.mp3',0,1,1,0,28,0,NULL,0,5,18,5,24,0,NULL);
INSERT INTO Media VALUES(236,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_6','track_6.mp3',0,1,1,0,28,0,NULL,0,5,71,6,24,0,NULL);
INSERT INTO Media VALUES(237,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_7','track_7.mp3',0,1,1,0,28,0,NULL,0,5,23,7,24,0,NULL);
INSERT INTO Media VALUES(238,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_8','track_8.mp3',0,1,1,0,28,0,NULL,0,5,56,8,24,0,NULL);
INSERT INTO Media VALUES(239,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_9','track_9.mp3',0,1,1,0,28,0,NULL,0,5,39,9,24,0,NULL);
INSERT INTO Media VALUES(240,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_10','track_10.mp3',0,1,1,0,28,0,NULL,0,5,78,10,24,0,NULL);
INSERT INTO Media VALUES(241,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_1','track_1.mp3',0,1,1,0,29,0,NULL,0,5,25,1,25,0,NULL);
INSERT INTO Media VALUES(242,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_2','track_2.mp3',0,1,1,0,29,0,NULL,0,5,47,2,25,0,NULL);
INSERT INTO Media VALUES(243,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_3','track_3.mp3',0,1,1,0,29,0,NULL,0,5,66,3,25,0,NULL);
INSERT INTO Media VALUES(244,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_4','track_4.mp3',0,1,1,0,29,0,NULL,0,5,30,4,25,0,NULL);
INSERT INTO Media VALUES(245,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_5','track_5.mp3',0,1,1,0,29,0,NULL,0,5,75,5,25,0,NULL);
INSERT INTO Media VALUES(246,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_6','track_6.mp3',0,1,1,0,29,0,NULL,0,5,22,6,25,0,NULL);
INSERT INTO Media VALUES(247,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_7','track_7.mp3',0,1,1,0,29,0,NULL,0,5,61,7,25,0,NULL);
INSERT INTO Media VALUES(248,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_8','track_8.mp3',0,1,1,0,29,0,NULL,0,5,57,8,25,0,NULL);
INSERT INTO Media VALUES(249,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_9','track_9.mp3',0,1,1,0,29,0,NULL,0,5,61,9,25,0,NULL);
INSERT INTO Media VALUES(250,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_10','track_10.mp3',0,1,1,0,29,0,NULL,0,5,8,10,25,0,NULL);
INSERT INTO Media VALUES(251,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_1','track_1.mp3',0,1,1,0,30,0,NULL,0,5,76,1,26,0,NULL);
INSERT INTO Media VALUES(252,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_2','track_2.mp3',0,1,1,0,30,0,NULL,0,5,21,2,26,0,NULL);
INSERT INTO Media VALUES(253,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_3','track_3.mp3',0,1,1,0,30,0,NULL,0,5,67,3,26,0,NULL);
INSERT INTO Media VALUES(254,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_4','track_4.mp3',0,1,1,0,30,0,NULL,0,5,63,4,26,0,NULL);
INSERT INTO Media VALUES(255,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_5','track_5.mp3',0,1,1,0,30,0,NULL,0,5,38,5,26,0,NULL);
INSERT INTO Media VALUES(256,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_6','track_6.mp3',0,1,1,0,30,0,NULL,0,5,13,6,26,0,NULL);
INSERT INTO Media VALUES(257,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_7','track_7.mp3',0,1,1,0,30,0,NULL,0,5,52,7,26,0,NULL);
INSERT INTO Media VALUES(258,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_8','track_8.mp3',0,1,1,0,30,0,NULL,0,5,69,8,26,0,NULL);
INSERT INTO Media VALUES(259,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_9','track_9.mp3',0,1,1,0,30,0,NULL,0,5,45,9,26,0,NULL);
INSERT INTO Media VALUES(260,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_10','track_10.mp3',0,1,1,0,30,0,NULL,0,5,12,10,26,0,NULL);
INSERT INTO Media VALUES(261,2,3,639,-1.0,-1,0,NULL,1648793058,2004,'track_1','track_1.mp3',0,1,1,0,31,0,NULL,0,5,54,1,27,0,NULL);
INSERT INTO Media VALUES(262,2,3,639,-1.0,-1,0,NULL,1648793058,2004,'track_2','track_2.mp3',0,1,1,0,31,0,NULL,0,5,70,2,27,0,NULL);
INSERT INTO Media VALUES(263,2,3,639,-1.0,-1,0,NULL,1648793058,2004,'track_3','track_3.mp3',0,1,1,0,31,0,NULL,0,5,52,3,27,0,NULL);
INSERT INTO Media VALUES(264,2,3,639,-1.0,-1,0,NULL,1648793058,2004,'track_4','track_4.mp3',0,1,1,0,31,0,NULL,0,5,1,4,27,0,NULL);
INSERT INTO Media VALUES(265,2,3,639,-1.0,-1,0,NULL,1648793058,2004,'track_5','track_5.mp3',0,1,1,0,31,0,NULL,0,5,41,5,27,0,NULL);
INSERT INTO Media VALUES(266,2,3,639,-1.0,-1,0,NULL,1648793058,2004,'track_6','track_6.mp3',0,1,1,0,31,0,NULL,0,5,23,6,27,0,NULL);
INSERT INTO Media VALUES(267,2,3,639,-1.0,-1,0,NULL,1648793058,2004,'track_7','track_7.mp3',0,1,1,0,31,0,NULL,0,5,29,7,27,0,NULL);
INSERT INTO Media VALUES(268,2,3,639,-1.0,-1,0,NULL,1648793058,2004,'track_8','track_8.mp3',0,1,1,0,31,0,NULL,0,5,34,8,27,0,NULL);
INSERT INTO Media VALUES(269,2,3,639,-1.0,-1,0,NULL,1648793058,2004,'track_9','track_9.mp3',0,1,1,0,31,0,NULL,0,5,56,9,27,0,NULL);
INSERT INTO Media VALUES(270,2,3,639,-1.0,-1,0,NULL,1648793058,2004,'track_10','track_10.mp3',0,1,1,0,31,0,NULL,0,5,34,10,27,0,NULL);
INSERT INTO Media VALUES(271,2,3,639,-1.0,-1,0,NULL,1648793058,2003,'track_1','track_1.mp3',0,1,1,0,32,0,NULL,0,5,30,1,28,0,NULL);
INSERT INTO Media VALUES(272,2,3,639,-1.0,-1,0,NULL,1648793058,2003,'track_2','track_2.mp3',0,1,1,0,32,0,NULL,0,5,20,2,28,0,NULL);
INSERT INTO Media VALUES(273,2,3,639,-1.0,-1,0,NULL,1648793058,2003,'track_3','track_3.mp3',0,1,1,0,32,0,NULL,0,5,67,3,28,0,NULL);
INSERT INTO Media VALUES(274,2,3,639,-1.0,-1,0,NULL,1648793058,2003,'track_4','track_4.mp3',0,1,1,0,32,0,NULL,0,5,42,4,28,0,NULL);
INSERT INTO Media VALUES(275,2,3,639,-1.0,-1,0,NULL,1648793058,2003,'track_5','track_5.mp3',0,1,1,0,32,0,NULL,0,5,2,5,28,0,NULL);
INSERT INTO Media VALUES(276,2,3,639,-1.0,-1,0,NULL,1648793058,2003,'track_6','track_6.mp3',0,1,1,0,32,0,NULL,0,5,35,6,28,0,NULL);
INSERT INTO Media VALUES(277,2,3,639,-1.0,-1,0,NULL,1648793058,2003,'track_7','track_7.mp3',0,1,1,0,32,0,NULL,0,5,77,7,28,0,NULL);
INSERT INTO Media VALUES(278,2,3,639,-1.0,-1,0,NULL,1648793058,2003,'track_8','track_8.mp3',0,1,1,0,32,0,NULL,0,5,33,8,28,0,NULL);
INSERT INTO Media VALUES(279,2,3,639,-1.0,-1,0,NULL,1648793058,2003,'track_9','track_9.mp3',0,1,1,0,32,0,NULL,0,5,73,9,28,0,NULL);
INSERT INTO Media VALUES(280,2,3,639,-1.0,-1,0,NULL,1648793058,2003,'track_10','track_10.mp3',0,1,1,0,32,0,NULL,0,5,42,10,28,0,NULL);
INSERT INTO Media VALUES(281,2,3,639,-1.0,-1,0,NULL,1648793058,2002,'track_1','track_1.mp3',0,1,1,0,33,0,NULL,0,5,69,1,29,0,NULL);
INSERT INTO Media VALUES(282,2,3,639,-1.0,-1,0,NULL,1648793058,2002,'track_2','track_2.mp3',0,1,1,0,33,0,NULL,0,5,22,2,29,0,NULL);
INSERT INTO Media VALUES(283,2,3,639,-1.0,-1,0,NULL,1648793058,2002,'track_3','track_3.mp3',0,1,1,0,33,0,NULL,0,5,22,3,29,0,NULL);
INSERT INTO Media VALUES(284,2,3,639,-1.0,-1,0,NULL,1648793058,2002,'track_4','track_4.mp3',0,1,1,0,33,0,NULL,0,5,23,4,29,0,NULL);
INSERT INTO Media VALUES(285,2,3,639,-1.0,-1,0,NULL,1648793058,2002,'track_5','track_5.mp3',0,1,1,0,33,0,NULL,0,5,15,5,29,0,NULL);
INSERT INTO Media VALUES(286,2,3,639,-1.0,-1,0,NULL,1648793058,2002,'track_6','track_6.mp3',0,1,1,0,33,0,NULL,0,5,14,6,29,0,NULL);
INSERT INTO Media VALUES(287,2,3,639,-1.0,-1,0,NULL,1648793058,2002,'track_7','track_7.mp3',0,1,1,0,33,0,NULL,0,5,49,7,29,0,NULL);
INSERT INTO Media VALUES(288,2,3,639,-1.0,-1,0,NULL,1648793058,2002,'track_8','track_8.mp3',0,1,1,0,33,0,NULL,0,5,13,8,29,0,NULL);
INSERT INTO Media VALUES(289,2,3,639,-1.0,-1,0,NULL,1648793058,2002,'track_9','track_9.mp3',0,1,1,0,33,0,NULL,0,5,76,9,29,0,NULL);
INSERT INTO Media VALUES(290,2,3,639,-1.0,-1,0,NULL,1648793058,2002,'track_10','track_10.mp3',0,1,1,0,33,0,NULL,0,5,24,10,29,0,NULL);
INSERT INTO Media VALUES(291,2,3,639,-1.0,-1,0,NULL,1648793058,2001,'track_1','track_1.mp3',0,1,1,0,34,0,NULL,0,5,42,1,30,0,NULL);
INSERT INTO Media VALUES(292,2,3,639,-1.0,-1,0,NULL,1648793058,2001,'track_2','track_2.mp3',0,1,1,0,34,0,NULL,0,5,55,2,30,0,NULL);
INSERT INTO Media VALUES(293,2,3,639,-1.0,-1,0,NULL,1648793058,2001,'track_3','track_3.mp3',0,1,1,0,34,0,NULL,0,5,25,3,30,0,NULL);
INSERT INTO Media VALUES(294,2,3,639,-1.0,-1,0,NULL,1648793058,2001,'track_4','track_4.mp3',0,1,1,0,34,0,NULL,0,5,10,4,30,0,NULL);
INSERT INTO Media VALUES(295,2,3,639,-1.0,-1,0,NULL,1648793058,2001,'track_5','track_5.mp3',0,1,1,0,34,0,NULL,0,5,75,5,30,0,NULL);
INSERT INTO Media VALUES(296,2,3,639,-1.0,-1,0,NULL,1648793058,2001,'track_6','track_6.mp3',0,1,1,0,34,0,NULL,0,5,44,6,30,0,NULL);
INSERT INTO Media VALUES(297,2,3,639,-1.0,-1,0,NULL,1648793058,2001,'track_7','track_7.mp3',0,1,1,0,34,0,NULL,0,5,73,7,30,0,NULL);
INSERT INTO Media VALUES(298,2,3,639,-1.0,-1,0,NULL,1648793058,2001,'track_8','track_8.mp3',0,1,1,0,34,0,NULL,0,5,17,8,30,0,NULL);
INSERT INTO Media VALUES(299,2,3,639,-1.0,-1,0,NULL,1648793058,2001,'track_9','track_9.mp3',0,1,1,0,34,0,NULL,0,5,61,9,30,0,NULL);
INSERT INTO Media VALUES(300,2,3,639,-1.0,-1,0,NULL,1648793058,2001,'track_10','track_10.mp3',0,1,1,0,34,0,NULL,0,5,63,10,30,0,NULL);
INSERT INTO Media VALUES(301,2,3,639,-1.0,-1,0,NULL,1648793058,2010,'track_1','track_1.mp3',0,1,1,0,36,0,NULL,0,6,37,1,31,0,NULL);
INSERT INTO Media VALUES(302,2,3,639,-1.0,-1,0,NULL,1648793058,2010,'track_2','track_2.mp3',0,1,1,0,36,0,NULL,0,6,75,2,31,0,NULL);
INSERT INTO Media VALUES(303,2,3,639,-1.0,-1,0,NULL,1648793058,2010,'track_3','track_3.mp3',0,1,1,0,36,0,NULL,0,6,40,3,31,0,NULL);
INSERT INTO Media VALUES(304,2,3,639,-1.0,-1,0,NULL,1648793058,2010,'track_4','track_4.mp3',0,1,1,0,36,0,NULL,0,6,57,4,31,0,NULL);
INSERT INTO Media VALUES(305,2,3,639,-1.0,-1,0,NULL,1648793058,2010,'track_5','track_5.mp3',0,1,1,0,36,0,NULL,0,6,8,5,31,0,NULL);
INSERT INTO Media VALUES(306,2,3,639,-1.0,-1,0,NULL,1648793058,2010,'track_6','track_6.mp3',0,1,1,0,36,0,NULL,0,6,3,6,31,0,NULL);
INSERT INTO Media VALUES(307,2,3,639,-1.0,-1,0,NULL,1648793058,2010,'track_7','track_7.mp3',0,1,1,0,36,0,NULL,0,6,30,7,31,0,NULL);
INSERT INTO Media VALUES(308,2,3,639,-1.0,-1,0,NULL,1648793058,2010,'track_8','track_8.mp3',0,1,1,0,36,0,NULL,0,6,79,8,31,0,NULL);
INSERT INTO Media VALUES(309,2,3,639,-1.0,-1,0,NULL,1648793058,2010,'track_9','track_9.mp3',0,1,1,0,36,0,NULL,0,6,56,9,31,0,NULL);
INSERT INTO Media VALUES(310,2,3,639,-1.0,-1,0,NULL,1648793058,2010,'track_10','track_10.mp3',0,1,1,0,36,0,NULL,0,6,32,10,31,0,NULL);
INSERT INTO Media VALUES(311,2,3,639,-1.0,-1,0,NULL,1648793058,2009,'track_1','track_1.mp3',0,1,1,0,37,0,NULL,0,6,69,1,32,0,NULL);
INSERT INTO Media VALUES(312,2,3,639,-1.0,-1,0,NULL,1648793058,2009,'track_2','track_2.mp3',0,1,1,0,37,0,NULL,0,6,54,2,32,0,NULL);
INSERT INTO Media VALUES(313,2,3,639,-1.0,-1,0,NULL,1648793058,2009,'track_3','track_3.mp3',0,1,1,0,37,0,NULL,0,6,17,3,32,0,NULL);
INSERT INTO Media VALUES(314,2,3,639,-1.0,-1,0,NULL,1648793058,2009,'track_4','track_4.mp3',0,1,1,0,37,0,NULL,0,6,71,4,32,0,NULL);
INSERT INTO Media VALUES(315,2,3,639,-1.0,-1,0,NULL,1648793058,2009,'track_5','track_5.mp3',0,1,1,0,37,0,NULL,0,6,29,5,32,0,NULL);
INSERT INTO Media VALUES(316,2,3,639,-1.0,-1,0,NULL,1648793058,2009,'track_6','track_6.mp3',0,1,1,0,37,0,NULL,0,6,67,6,32,0,NULL);
INSERT INTO Media VALUES(317,2,3,639,-1.0,-1,0,NULL,1648793058,2009,'track_7','track_7.mp3',0,1,1,0,37,0,NULL,0,6,58,7,32,0,NULL);
INSERT INTO Media VALUES(318,2,3,639,-1.0,-1,0,NULL,1648793058,2009,'track_8','track_8.mp3',0,1,1,0,37,0,NULL,0,6,7,8,32,0,NULL);
INSERT INTO Media VALUES(319,2,3,639,-1.0,-1,0,NULL,1648793058,2009,'track_9','track_9.mp3',0,1,1,0,37,0,NULL,0,6,31,9,32,0,NULL);
INSERT INTO Media VALUES(320,2,3,639,-1.0,-1,0,NULL,1648793058,2009,'track_10','track_10.mp3',0,1,1,0,37,0,NULL,0,6,47,10,32,0,NULL);
INSERT INTO Media VALUES(321,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_1','track_1.mp3',0,1,1,0,38,0,NULL,0,6,7,1,33,0,NULL);
INSERT INTO Media VALUES(322,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_2','track_2.mp3',0,1,1,0,38,0,NULL,0,6,62,2,33,0,NULL);
INSERT INTO Media VALUES(323,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_3','track_3.mp3',0,1,1,0,38,0,NULL,0,6,9,3,33,0,NULL);
INSERT INTO Media VALUES(324,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_4','track_4.mp3',0,1,1,0,38,0,NULL,0,6,73,4,33,0,NULL);
INSERT INTO Media VALUES(325,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_5','track_5.mp3',0,1,1,0,38,0,NULL,0,6,10,5,33,0,NULL);
INSERT INTO Media VALUES(326,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_6','track_6.mp3',0,1,1,0,38,0,NULL,0,6,78,6,33,0,NULL);
INSERT INTO Media VALUES(327,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_7','track_7.mp3',0,1,1,0,38,0,NULL,0,6,20,7,33,0,NULL);
INSERT INTO Media VALUES(328,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_8','track_8.mp3',0,1,1,0,38,0,NULL,0,6,6,8,33,0,NULL);
INSERT INTO Media VALUES(329,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_9','track_9.mp3',0,1,1,0,38,0,NULL,0,6,79,9,33,0,NULL);
INSERT INTO Media VALUES(330,2,3,639,-1.0,-1,0,NULL,1648793058,2008,'track_10','track_10.mp3',0,1,1,0,38,0,NULL,0,6,16,10,33,0,NULL);
INSERT INTO Media VALUES(331,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_1','track_1.mp3',0,1,1,0,39,0,NULL,0,6,73,1,34,0,NULL);
INSERT INTO Media VALUES(332,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_2','track_2.mp3',0,1,1,0,39,0,NULL,0,6,70,2,34,0,NULL);
INSERT INTO Media VALUES(333,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_3','track_3.mp3',0,1,1,0,39,0,NULL,0,6,60,3,34,0,NULL);
INSERT INTO Media VALUES(334,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_4','track_4.mp3',0,1,1,0,39,0,NULL,0,6,42,4,34,0,NULL);
INSERT INTO Media VALUES(335,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_5','track_5.mp3',0,1,1,0,39,0,NULL,0,6,25,5,34,0,NULL);
INSERT INTO Media VALUES(336,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_6','track_6.mp3',0,1,1,0,39,0,NULL,0,6,80,6,34,0,NULL);
INSERT INTO Media VALUES(337,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_7','track_7.mp3',0,1,1,0,39,0,NULL,0,6,20,7,34,0,NULL);
INSERT INTO Media VALUES(338,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_8','track_8.mp3',0,1,1,0,39,0,NULL,0,6,25,8,34,0,NULL);
INSERT INTO Media VALUES(339,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_9','track_9.mp3',0,1,1,0,39,0,NULL,0,6,30,9,34,0,NULL);
INSERT INTO Media VALUES(340,2,3,639,-1.0,-1,0,NULL,1648793058,2007,'track_10','track_10.mp3',0,1,1,0,39,0,NULL,0,6,41,10,34,0,NULL);
INSERT INTO Media VALUES(341,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_1','track_1.mp3',0,1,1,0,40,0,NULL,0,6,62,1,35,0,NULL);
INSERT INTO Media VALUES(342,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_2','track_2.mp3',0,1,1,0,40,0,NULL,0,6,51,2,35,0,NULL);
INSERT INTO Media VALUES(343,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_3','track_3.mp3',0,1,1,0,40,0,NULL,0,6,71,3,35,0,NULL);
INSERT INTO Media VALUES(344,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_4','track_4.mp3',0,1,1,0,40,0,NULL,0,6,72,4,35,0,NULL);
INSERT INTO Media VALUES(345,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_5','track_5.mp3',0,1,1,0,40,0,NULL,0,6,60,5,35,0,NULL);
INSERT INTO Media VALUES(346,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_6','track_6.mp3',0,1,1,0,40,0,NULL,0,6,18,6,35,0,NULL);
INSERT INTO Media VALUES(347,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_7','track_7.mp3',0,1,1,0,40,0,NULL,0,6,56,7,35,0,NULL);
INSERT INTO Media VALUES(348,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_8','track_8.mp3',0,1,1,0,40,0,NULL,0,6,28,8,35,0,NULL);
INSERT INTO Media VALUES(349,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_9','track_9.mp3',0,1,1,0,40,0,NULL,0,6,30,9,35,0,NULL);
INSERT INTO Media VALUES(350,2,3,639,-1.0,-1,0,NULL,1648793058,2006,'track_10','track_10.mp3',0,1,1,0,40,0,NULL,0,6,8,10,35,0,NULL);
INSERT INTO Media VALUES(351,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_1','track_1.mp3',0,1,1,0,41,0,NULL,0,6,4,1,36,0,NULL);
INSERT INTO Media VALUES(352,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_2','track_2.mp3',0,1,1,0,41,0,NULL,0,6,15,2,36,0,NULL);
INSERT INTO Media VALUES(353,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_3','track_3.mp3',0,1,1,0,41,0,NULL,0,6,20,3,36,0,NULL);
INSERT INTO Media VALUES(354,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_4','track_4.mp3',0,1,1,0,41,0,NULL,0,6,54,4,36,0,NULL);
INSERT INTO Media VALUES(355,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_5','track_5.mp3',0,1,1,0,41,0,NULL,0,6,35,5,36,0,NULL);
INSERT INTO Media VALUES(356,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_6','track_6.mp3',0,1,1,0,41,0,NULL,0,6,11,6,36,0,NULL);
INSERT INTO Media VALUES(357,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_7','track_7.mp3',0,1,1,0,41,0,NULL,0,6,53,7,36,0,NULL);
INSERT INTO Media VALUES(358,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_8','track_8.mp3',0,1,1,0,41,0,NULL,0,6,46,8,36,0,NULL);
INSERT INTO Media VALUES(359,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_9','track_9.mp3',0,1,1,0,41,0,NULL,0,6,37,9,36,0,NULL);
INSERT INTO Media VALUES(360,2,3,639,-1.0,-1,0,NULL,1648793058,2005,'track_10','track_10.mp3',0,1,1,0,41,0,NULL,0,6,29,10,36,0,NULL);
INSERT INTO Media VALUES(361,2,3,639,-1.0,-1,0,NULL,1648793058,2004,'track_1','track_1.mp3',0,1,1,0,42,0,NULL,0,6,52,1,37,0,NULL);
INSERT INTO Media VALUES(362,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_2','track_2.mp3',0,1,1,0,42,0,NULL,0,6,13,2,37,0,NULL);
INSERT INTO Media VALUES(363,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_3','track_3.mp3',0,1,1,0,42,0,NULL,0,6,61,3,37,0,NULL);
INSERT INTO Media VALUES(364,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_4','track_4.mp3',0,1,1,0,42,0,NULL,0,6,18,4,37,0,NULL);
INSERT INTO Media VALUES(365,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_5','track_5.mp3',0,1,1,0,42,0,NULL,0,6,64,5,37,0,NULL);
INSERT INTO Media VALUES(366,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_6','track_6.mp3',0,1,1,0,42,0,NULL,0,6,38,6,37,0,NULL);
INSERT INTO Media VALUES(367,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_7','track_7.mp3',0,1,1,0,42,0,NULL,0,6,9,7,37,0,NULL);
INSERT INTO Media VALUES(368,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_8','track_8.mp3',0,1,1,0,42,0,NULL,0,6,30,8,37,0,NULL);
INSERT INTO Media VALUES(369,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_9','track_9.mp3',0,1,1,0,42,0,NULL,0,6,45,9,37,0,NULL);
INSERT INTO Media VALUES(370,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_10','track_10.mp3',0,1,1,0,42,0,NULL,0,6,42,10,37,0,NULL);
INSERT INTO Media VALUES(371,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_1','track_1.mp3',0,1,1,0,43,0,NULL,0,6,80,1,38,0,NULL);
INSERT INTO Media VALUES(372,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_2','track_2.mp3',0,1,1,0,43,0,NULL,0,6,36,2,38,0,NULL);
INSERT INTO Media VALUES(373,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_3','track_3.mp3',0,1,1,0,43,0,NULL,0,6,9,3,38,0,NULL);
INSERT INTO Media VALUES(374,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_4','track_4.mp3',0,1,1,0,43,0,NULL,0,6,10,4,38,0,NULL);
INSERT INTO Media VALUES(375,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_5','track_5.mp3',0,1,1,0,43,0,NULL,0,6,41,5,38,0,NULL);
INSERT INTO Media VALUES(376,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_6','track_6.mp3',0,1,1,0,43,0,NULL,0,6,38,6,38,0,NULL);
INSERT INTO Media VALUES(377,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_7','track_7.mp3',0,1,1,0,43,0,NULL,0,6,62,7,38,0,NULL);
INSERT INTO Media VALUES(378,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_8','track_8.mp3',0,1,1,0,43,0,NULL,0,6,68,8,38,0,NULL);
INSERT INTO Media VALUES(379,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_9','track_9.mp3',0,1,1,0,43,0,NULL,0,6,52,9,38,0,NULL);
INSERT INTO Media VALUES(380,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_10','track_10.mp3',0,1,1,0,43,0,NULL,0,6,45,10,38,0,NULL);
INSERT INTO Media VALUES(381,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_1','track_1.mp3',0,1,1,0,44,0,NULL,0,6,35,1,39,0,NULL);
INSERT INTO Media VALUES(382,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_2','track_2.mp3',0,1,1,0,44,0,NULL,0,6,15,2,39,0,NULL);
INSERT INTO Media VALUES(383,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_3','track_3.mp3',0,1,1,0,44,0,NULL,0,6,67,3,39,0,NULL);
INSERT INTO Media VALUES(384,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_4','track_4.mp3',0,1,1,0,44,0,NULL,0,6,13,4,39,0,NULL);
INSERT INTO Media VALUES(385,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_5','track_5.mp3',0,1,1,0,44,0,NULL,0,6,53,5,39,0,NULL);
INSERT INTO Media VALUES(386,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_6','track_6.mp3',0,1,1,0,44,0,NULL,0,6,2,6,39,0,NULL);
INSERT INTO Media VALUES(387,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_7','track_7.mp3',0,1,1,0,44,0,NULL,0,6,55,7,39,0,NULL);
INSERT INTO Media VALUES(388,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_8','track_8.mp3',0,1,1,0,44,0,NULL,0,6,70,8,39,0,NULL);
INSERT INTO Media VALUES(389,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_9','track_9.mp3',0,1,1,0,44,0,NULL,0,6,12,9,39,0,NULL);
INSERT INTO Media VALUES(390,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_10','track_10.mp3',0,1,1,0,44,0,NULL,0,6,32,10,39,0,NULL);
INSERT INTO Media VALUES(391,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_1','track_1.mp3',0,1,1,0,45,0,NULL,0,6,71,1,40,0,NULL);
INSERT INTO Media VALUES(392,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_2','track_2.mp3',0,1,1,0,45,0,NULL,0,6,25,2,40,0,NULL);
INSERT INTO Media VALUES(393,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_3','track_3.mp3',0,1,1,0,45,0,NULL,0,6,56,3,40,0,NULL);
INSERT INTO Media VALUES(394,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_4','track_4.mp3',0,1,1,0,45,0,NULL,0,6,61,4,40,0,NULL);
INSERT INTO Media VALUES(395,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_5','track_5.mp3',0,1,1,0,45,0,NULL,0,6,22,5,40,0,NULL);
INSERT INTO Media VALUES(396,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_6','track_6.mp3',0,1,1,0,45,0,NULL,0,6,36,6,40,0,NULL);
INSERT INTO Media VALUES(397,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_7','track_7.mp3',0,1,1,0,45,0,NULL,0,6,36,7,40,0,NULL);
INSERT INTO Media VALUES(398,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_8','track_8.mp3',0,1,1,0,45,0,NULL,0,6,26,8,40,0,NULL);
INSERT INTO Media VALUES(399,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_9','track_9.mp3',0,1,1,0,45,0,NULL,0,6,21,9,40,0,NULL);
INSERT INTO Media VALUES(400,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_10','track_10.mp3',0,1,1,0,45,0,NULL,0,6,66,10,40,0,NULL);
INSERT INTO Media VALUES(401,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_1','track_1.mp3',0,1,1,0,47,0,NULL,0,7,50,1,41,0,NULL);
INSERT INTO Media VALUES(402,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_2','track_2.mp3',0,1,1,0,47,0,NULL,0,7,28,2,41,0,NULL);
INSERT INTO Media VALUES(403,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_3','track_3.mp3',0,1,1,0,47,0,NULL,0,7,44,3,41,0,NULL);
INSERT INTO Media VALUES(404,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_4','track_4.mp3',0,1,1,0,47,0,NULL,0,7,41,4,41,0,NULL);
INSERT INTO Media VALUES(405,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_5','track_5.mp3',0,1,1,0,47,0,NULL,0,7,10,5,41,0,NULL);
INSERT INTO Media VALUES(406,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_6','track_6.mp3',0,1,1,0,47,0,NULL,0,7,30,6,41,0,NULL);
INSERT INTO Media VALUES(407,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_7','track_7.mp3',0,1,1,0,47,0,NULL,0,7,37,7,41,0,NULL);
INSERT INTO Media VALUES(408,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_8','track_8.mp3',0,1,1,0,47,0,NULL,0,7,16,8,41,0,NULL);
INSERT INTO Media VALUES(409,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_9','track_9.mp3',0,1,1,0,47,0,NULL,0,7,28,9,41,0,NULL);
INSERT INTO Media VALUES(410,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_10','track_10.mp3',0,1,1,0,47,0,NULL,0,7,34,10,41,0,NULL);
INSERT INTO Media VALUES(411,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_1','track_1.mp3',0,1,1,0,48,0,NULL,0,7,64,1,42,0,NULL);
INSERT INTO Media VALUES(412,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_2','track_2.mp3',0,1,1,0,48,0,NULL,0,7,1,2,42,0,NULL);
INSERT INTO Media VALUES(413,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_3','track_3.mp3',0,1,1,0,48,0,NULL,0,7,33,3,42,0,NULL);
INSERT INTO Media VALUES(414,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_4','track_4.mp3',0,1,1,0,48,0,NULL,0,7,38,4,42,0,NULL);
INSERT INTO Media VALUES(415,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_5','track_5.mp3',0,1,1,0,48,0,NULL,0,7,32,5,42,0,NULL);
INSERT INTO Media VALUES(416,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_6','track_6.mp3',0,1,1,0,48,0,NULL,0,7,11,6,42,0,NULL);
INSERT INTO Media VALUES(417,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_7','track_7.mp3',0,1,1,0,48,0,NULL,0,7,45,7,42,0,NULL);
INSERT INTO Media VALUES(418,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_8','track_8.mp3',0,1,1,0,48,0,NULL,0,7,4,8,42,0,NULL);
INSERT INTO Media VALUES(419,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_9','track_9.mp3',0,1,1,0,48,0,NULL,0,7,47,9,42,0,NULL);
INSERT INTO Media VALUES(420,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_10','track_10.mp3',0,1,1,0,48,0,NULL,0,7,46,10,42,0,NULL);
INSERT INTO Media VALUES(421,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_1','track_1.mp3',0,1,1,0,49,0,NULL,0,7,13,1,43,0,NULL);
INSERT INTO Media VALUES(422,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_2','track_2.mp3',0,1,1,0,49,0,NULL,0,7,5,2,43,0,NULL);
INSERT INTO Media VALUES(423,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_3','track_3.mp3',0,1,1,0,49,0,NULL,0,7,30,3,43,0,NULL);
INSERT INTO Media VALUES(424,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_4','track_4.mp3',0,1,1,0,49,0,NULL,0,7,71,4,43,0,NULL);
INSERT INTO Media VALUES(425,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_5','track_5.mp3',0,1,1,0,49,0,NULL,0,7,30,5,43,0,NULL);
INSERT INTO Media VALUES(426,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_6','track_6.mp3',0,1,1,0,49,0,NULL,0,7,4,6,43,0,NULL);
INSERT INTO Media VALUES(427,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_7','track_7.mp3',0,1,1,0,49,0,NULL,0,7,6,7,43,0,NULL);
INSERT INTO Media VALUES(428,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_8','track_8.mp3',0,1,1,0,49,0,NULL,0,7,76,8,43,0,NULL);
INSERT INTO Media VALUES(429,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_9','track_9.mp3',0,1,1,0,49,0,NULL,0,7,5,9,43,0,NULL);
INSERT INTO Media VALUES(430,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_10','track_10.mp3',0,1,1,0,49,0,NULL,0,7,38,10,43,0,NULL);
INSERT INTO Media VALUES(431,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_1','track_1.mp3',0,1,1,0,50,0,NULL,0,7,80,1,44,0,NULL);
INSERT INTO Media VALUES(432,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_2','track_2.mp3',0,1,1,0,50,0,NULL,0,7,9,2,44,0,NULL);
INSERT INTO Media VALUES(433,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_3','track_3.mp3',0,1,1,0,50,0,NULL,0,7,27,3,44,0,NULL);
INSERT INTO Media VALUES(434,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_4','track_4.mp3',0,1,1,0,50,0,NULL,0,7,6,4,44,0,NULL);
INSERT INTO Media VALUES(435,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_5','track_5.mp3',0,1,1,0,50,0,NULL,0,7,21,5,44,0,NULL);
INSERT INTO Media VALUES(436,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_6','track_6.mp3',0,1,1,0,50,0,NULL,0,7,29,6,44,0,NULL);
INSERT INTO Media VALUES(437,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_7','track_7.mp3',0,1,1,0,50,0,NULL,0,7,52,7,44,0,NULL);
INSERT INTO Media VALUES(438,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_8','track_8.mp3',0,1,1,0,50,0,NULL,0,7,55,8,44,0,NULL);
INSERT INTO Media VALUES(439,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_9','track_9.mp3',0,1,1,0,50,0,NULL,0,7,40,9,44,0,NULL);
INSERT INTO Media VALUES(440,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_10','track_10.mp3',0,1,1,0,50,0,NULL,0,7,60,10,44,0,NULL);
INSERT INTO Media VALUES(441,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_1','track_1.mp3',0,1,1,0,51,0,NULL,0,7,2,1,45,0,NULL);
INSERT INTO Media VALUES(442,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_2','track_2.mp3',0,1,1,0,51,0,NULL,0,7,26,2,45,0,NULL);
INSERT INTO Media VALUES(443,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_3','track_3.mp3',0,1,1,0,51,0,NULL,0,7,72,3,45,0,NULL);
INSERT INTO Media VALUES(444,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_4','track_4.mp3',0,1,1,0,51,0,NULL,0,7,3,4,45,0,NULL);
INSERT INTO Media VALUES(445,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_5','track_5.mp3',0,1,1,0,51,0,NULL,0,7,41,5,45,0,NULL);
INSERT INTO Media VALUES(446,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_6','track_6.mp3',0,1,1,0,51,0,NULL,0,7,48,6,45,0,NULL);
INSERT INTO Media VALUES(447,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_7','track_7.mp3',0,1,1,0,51,0,NULL,0,7,3,7,45,0,NULL);
INSERT INTO Media VALUES(448,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_8','track_8.mp3',0,1,1,0,51,0,NULL,0,7,5,8,45,0,NULL);
INSERT INTO Media VALUES(449,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_9','track_9.mp3',0,1,1,0,51,0,NULL,0,7,9,9,45,0,NULL);
INSERT INTO Media VALUES(450,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_10','track_10.mp3',0,1,1,0,51,0,NULL,0,7,33,10,45,0,NULL);
INSERT INTO Media VALUES(451,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_1','track_1.mp3',0,1,1,0,52,0,NULL,0,7,31,1,46,0,NULL);
INSERT INTO Media VALUES(452,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_2','track_2.mp3',0,1,1,0,52,0,NULL,0,7,4,2,46,0,NULL);
INSERT INTO Media VALUES(453,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_3','track_3.mp3',0,1,1,0,52,0,NULL,0,7,54,3,46,0,NULL);
INSERT INTO Media VALUES(454,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_4','track_4.mp3',0,1,1,0,52,0,NULL,0,7,68,4,46,0,NULL);
INSERT INTO Media VALUES(455,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_5','track_5.mp3',0,1,1,0,52,0,NULL,0,7,28,5,46,0,NULL);
INSERT INTO Media VALUES(456,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_6','track_6.mp3',0,1,1,0,52,0,NULL,0,7,58,6,46,0,NULL);
INSERT INTO Media VALUES(457,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_7','track_7.mp3',0,1,1,0,52,0,NULL,0,7,25,7,46,0,NULL);
INSERT INTO Media VALUES(458,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_8','track_8.mp3',0,1,1,0,52,0,NULL,0,7,9,8,46,0,NULL);
INSERT INTO Media VALUES(459,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_9','track_9.mp3',0,1,1,0,52,0,NULL,0,7,29,9,46,0,NULL);
INSERT INTO Media VALUES(460,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_10','track_10.mp3',0,1,1,0,52,0,NULL,0,7,18,10,46,0,NULL);
INSERT INTO Media VALUES(461,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_1','track_1.mp3',0,1,1,0,53,0,NULL,0,7,9,1,47,0,NULL);
INSERT INTO Media VALUES(462,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_2','track_2.mp3',0,1,1,0,53,0,NULL,0,7,17,2,47,0,NULL);
INSERT INTO Media VALUES(463,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_3','track_3.mp3',0,1,1,0,53,0,NULL,0,7,52,3,47,0,NULL);
INSERT INTO Media VALUES(464,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_4','track_4.mp3',0,1,1,0,53,0,NULL,0,7,39,4,47,0,NULL);
INSERT INTO Media VALUES(465,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_5','track_5.mp3',0,1,1,0,53,0,NULL,0,7,40,5,47,0,NULL);
INSERT INTO Media VALUES(466,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_6','track_6.mp3',0,1,1,0,53,0,NULL,0,7,32,6,47,0,NULL);
INSERT INTO Media VALUES(467,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_7','track_7.mp3',0,1,1,0,53,0,NULL,0,7,71,7,47,0,NULL);
INSERT INTO Media VALUES(468,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_8','track_8.mp3',0,1,1,0,53,0,NULL,0,7,15,8,47,0,NULL);
INSERT INTO Media VALUES(469,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_9','track_9.mp3',0,1,1,0,53,0,NULL,0,7,3,9,47,0,NULL);
INSERT INTO Media VALUES(470,2,3,639,-1.0,-1,0,NULL,1648793059,2004,'track_10','track_10.mp3',0,1,1,0,53,0,NULL,0,7,19,10,47,0,NULL);
INSERT INTO Media VALUES(471,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_1','track_1.mp3',0,1,1,0,54,0,NULL,0,7,60,1,48,0,NULL);
INSERT INTO Media VALUES(472,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_2','track_2.mp3',0,1,1,0,54,0,NULL,0,7,41,2,48,0,NULL);
INSERT INTO Media VALUES(473,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_3','track_3.mp3',0,1,1,0,54,0,NULL,0,7,76,3,48,0,NULL);
INSERT INTO Media VALUES(474,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_4','track_4.mp3',0,1,1,0,54,0,NULL,0,7,14,4,48,0,NULL);
INSERT INTO Media VALUES(475,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_5','track_5.mp3',0,1,1,0,54,0,NULL,0,7,80,5,48,0,NULL);
INSERT INTO Media VALUES(476,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_6','track_6.mp3',0,1,1,0,54,0,NULL,0,7,24,6,48,0,NULL);
INSERT INTO Media VALUES(477,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_7','track_7.mp3',0,1,1,0,54,0,NULL,0,7,27,7,48,0,NULL);
INSERT INTO Media VALUES(478,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_8','track_8.mp3',0,1,1,0,54,0,NULL,0,7,19,8,48,0,NULL);
INSERT INTO Media VALUES(479,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_9','track_9.mp3',0,1,1,0,54,0,NULL,0,7,61,9,48,0,NULL);
INSERT INTO Media VALUES(480,2,3,639,-1.0,-1,0,NULL,1648793059,2003,'track_10','track_10.mp3',0,1,1,0,54,0,NULL,0,7,79,10,48,0,NULL);
INSERT INTO Media VALUES(481,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_1','track_1.mp3',0,1,1,0,55,0,NULL,0,7,37,1,49,0,NULL);
INSERT INTO Media VALUES(482,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_2','track_2.mp3',0,1,1,0,55,0,NULL,0,7,4,2,49,0,NULL);
INSERT INTO Media VALUES(483,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_3','track_3.mp3',0,1,1,0,55,0,NULL,0,7,32,3,49,0,NULL);
INSERT INTO Media VALUES(484,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_4','track_4.mp3',0,1,1,0,55,0,NULL,0,7,20,4,49,0,NULL);
INSERT INTO Media VALUES(485,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_5','track_5.mp3',0,1,1,0,55,0,NULL,0,7,50,5,49,0,NULL);
INSERT INTO Media VALUES(486,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_6','track_6.mp3',0,1,1,0,55,0,NULL,0,7,47,6,49,0,NULL);
INSERT INTO Media VALUES(487,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_7','track_7.mp3',0,1,1,0,55,0,NULL,0,7,39,7,49,0,NULL);
INSERT INTO Media VALUES(488,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_8','track_8.mp3',0,1,1,0,55,0,NULL,0,7,70,8,49,0,NULL);
INSERT INTO Media VALUES(489,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_9','track_9.mp3',0,1,1,0,55,0,NULL,0,7,57,9,49,0,NULL);
INSERT INTO Media VALUES(490,2,3,639,-1.0,-1,0,NULL,1648793059,2002,'track_10','track_10.mp3',0,1,1,0,55,0,NULL,0,7,14,10,49,0,NULL);
INSERT INTO Media VALUES(491,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_1','track_1.mp3',0,1,1,0,56,0,NULL,0,7,50,1,50,0,NULL);
INSERT INTO Media VALUES(492,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_2','track_2.mp3',0,1,1,0,56,0,NULL,0,7,73,2,50,0,NULL);
INSERT INTO Media VALUES(493,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_3','track_3.mp3',0,1,1,0,56,0,NULL,0,7,39,3,50,0,NULL);
INSERT INTO Media VALUES(494,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_4','track_4.mp3',0,1,1,0,56,0,NULL,0,7,22,4,50,0,NULL);
INSERT INTO Media VALUES(495,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_5','track_5.mp3',0,1,1,0,56,0,NULL,0,7,65,5,50,0,NULL);
INSERT INTO Media VALUES(496,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_6','track_6.mp3',0,1,1,0,56,0,NULL,0,7,50,6,50,0,NULL);
INSERT INTO Media VALUES(497,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_7','track_7.mp3',0,1,1,0,56,0,NULL,0,7,35,7,50,0,NULL);
INSERT INTO Media VALUES(498,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_8','track_8.mp3',0,1,1,0,56,0,NULL,0,7,48,8,50,0,NULL);
INSERT INTO Media VALUES(499,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_9','track_9.mp3',0,1,1,0,56,0,NULL,0,7,31,9,50,0,NULL);
INSERT INTO Media VALUES(500,2,3,639,-1.0,-1,0,NULL,1648793059,2001,'track_10','track_10.mp3',0,1,1,0,56,0,NULL,0,7,22,10,50,0,NULL);
INSERT INTO Media VALUES(501,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_1','track_1.mp3',0,1,1,0,58,0,NULL,0,8,56,1,51,0,NULL);
INSERT INTO Media VALUES(502,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_2','track_2.mp3',0,1,1,0,58,0,NULL,0,8,8,2,51,0,NULL);
INSERT INTO Media VALUES(503,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_3','track_3.mp3',0,1,1,0,58,0,NULL,0,8,59,3,51,0,NULL);
INSERT INTO Media VALUES(504,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_4','track_4.mp3',0,1,1,0,58,0,NULL,0,8,25,4,51,0,NULL);
INSERT INTO Media VALUES(505,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_5','track_5.mp3',0,1,1,0,58,0,NULL,0,8,70,5,51,0,NULL);
INSERT INTO Media VALUES(506,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_6','track_6.mp3',0,1,1,0,58,0,NULL,0,8,25,6,51,0,NULL);
INSERT INTO Media VALUES(507,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_7','track_7.mp3',0,1,1,0,58,0,NULL,0,8,51,7,51,0,NULL);
INSERT INTO Media VALUES(508,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_8','track_8.mp3',0,1,1,0,58,0,NULL,0,8,36,8,51,0,NULL);
INSERT INTO Media VALUES(509,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_9','track_9.mp3',0,1,1,0,58,0,NULL,0,8,17,9,51,0,NULL);
INSERT INTO Media VALUES(510,2,3,639,-1.0,-1,0,NULL,1648793059,2010,'track_10','track_10.mp3',0,1,1,0,58,0,NULL,0,8,27,10,51,0,NULL);
INSERT INTO Media VALUES(511,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_1','track_1.mp3',0,1,1,0,59,0,NULL,0,8,37,1,52,0,NULL);
INSERT INTO Media VALUES(512,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_2','track_2.mp3',0,1,1,0,59,0,NULL,0,8,74,2,52,0,NULL);
INSERT INTO Media VALUES(513,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_3','track_3.mp3',0,1,1,0,59,0,NULL,0,8,10,3,52,0,NULL);
INSERT INTO Media VALUES(514,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_4','track_4.mp3',0,1,1,0,59,0,NULL,0,8,51,4,52,0,NULL);
INSERT INTO Media VALUES(515,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_5','track_5.mp3',0,1,1,0,59,0,NULL,0,8,73,5,52,0,NULL);
INSERT INTO Media VALUES(516,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_6','track_6.mp3',0,1,1,0,59,0,NULL,0,8,15,6,52,0,NULL);
INSERT INTO Media VALUES(517,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_7','track_7.mp3',0,1,1,0,59,0,NULL,0,8,54,7,52,0,NULL);
INSERT INTO Media VALUES(518,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_8','track_8.mp3',0,1,1,0,59,0,NULL,0,8,40,8,52,0,NULL);
INSERT INTO Media VALUES(519,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_9','track_9.mp3',0,1,1,0,59,0,NULL,0,8,49,9,52,0,NULL);
INSERT INTO Media VALUES(520,2,3,639,-1.0,-1,0,NULL,1648793059,2009,'track_10','track_10.mp3',0,1,1,0,59,0,NULL,0,8,65,10,52,0,NULL);
INSERT INTO Media VALUES(521,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_1','track_1.mp3',0,1,1,0,60,0,NULL,0,8,11,1,53,0,NULL);
INSERT INTO Media VALUES(522,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_2','track_2.mp3',0,1,1,0,60,0,NULL,0,8,42,2,53,0,NULL);
INSERT INTO Media VALUES(523,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_3','track_3.mp3',0,1,1,0,60,0,NULL,0,8,35,3,53,0,NULL);
INSERT INTO Media VALUES(524,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_4','track_4.mp3',0,1,1,0,60,0,NULL,0,8,23,4,53,0,NULL);
INSERT INTO Media VALUES(525,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_5','track_5.mp3',0,1,1,0,60,0,NULL,0,8,6,5,53,0,NULL);
INSERT INTO Media VALUES(526,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_6','track_6.mp3',0,1,1,0,60,0,NULL,0,8,55,6,53,0,NULL);
INSERT INTO Media VALUES(527,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_7','track_7.mp3',0,1,1,0,60,0,NULL,0,8,74,7,53,0,NULL);
INSERT INTO Media VALUES(528,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_8','track_8.mp3',0,1,1,0,60,0,NULL,0,8,11,8,53,0,NULL);
INSERT INTO Media VALUES(529,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_9','track_9.mp3',0,1,1,0,60,0,NULL,0,8,3,9,53,0,NULL);
INSERT INTO Media VALUES(530,2,3,639,-1.0,-1,0,NULL,1648793059,2008,'track_10','track_10.mp3',0,1,1,0,60,0,NULL,0,8,23,10,53,0,NULL);
INSERT INTO Media VALUES(531,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_1','track_1.mp3',0,1,1,0,61,0,NULL,0,8,5,1,54,0,NULL);
INSERT INTO Media VALUES(532,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_2','track_2.mp3',0,1,1,0,61,0,NULL,0,8,70,2,54,0,NULL);
INSERT INTO Media VALUES(533,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_3','track_3.mp3',0,1,1,0,61,0,NULL,0,8,41,3,54,0,NULL);
INSERT INTO Media VALUES(534,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_4','track_4.mp3',0,1,1,0,61,0,NULL,0,8,39,4,54,0,NULL);
INSERT INTO Media VALUES(535,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_5','track_5.mp3',0,1,1,0,61,0,NULL,0,8,76,5,54,0,NULL);
INSERT INTO Media VALUES(536,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_6','track_6.mp3',0,1,1,0,61,0,NULL,0,8,40,6,54,0,NULL);
INSERT INTO Media VALUES(537,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_7','track_7.mp3',0,1,1,0,61,0,NULL,0,8,38,7,54,0,NULL);
INSERT INTO Media VALUES(538,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_8','track_8.mp3',0,1,1,0,61,0,NULL,0,8,48,8,54,0,NULL);
INSERT INTO Media VALUES(539,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_9','track_9.mp3',0,1,1,0,61,0,NULL,0,8,11,9,54,0,NULL);
INSERT INTO Media VALUES(540,2,3,639,-1.0,-1,0,NULL,1648793059,2007,'track_10','track_10.mp3',0,1,1,0,61,0,NULL,0,8,6,10,54,0,NULL);
INSERT INTO Media VALUES(541,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_1','track_1.mp3',0,1,1,0,62,0,NULL,0,8,37,1,55,0,NULL);
INSERT INTO Media VALUES(542,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_2','track_2.mp3',0,1,1,0,62,0,NULL,0,8,37,2,55,0,NULL);
INSERT INTO Media VALUES(543,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_3','track_3.mp3',0,1,1,0,62,0,NULL,0,8,62,3,55,0,NULL);
INSERT INTO Media VALUES(544,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_4','track_4.mp3',0,1,1,0,62,0,NULL,0,8,80,4,55,0,NULL);
INSERT INTO Media VALUES(545,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_5','track_5.mp3',0,1,1,0,62,0,NULL,0,8,24,5,55,0,NULL);
INSERT INTO Media VALUES(546,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_6','track_6.mp3',0,1,1,0,62,0,NULL,0,8,29,6,55,0,NULL);
INSERT INTO Media VALUES(547,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_7','track_7.mp3',0,1,1,0,62,0,NULL,0,8,6,7,55,0,NULL);
INSERT INTO Media VALUES(548,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_8','track_8.mp3',0,1,1,0,62,0,NULL,0,8,50,8,55,0,NULL);
INSERT INTO Media VALUES(549,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_9','track_9.mp3',0,1,1,0,62,0,NULL,0,8,66,9,55,0,NULL);
INSERT INTO Media VALUES(550,2,3,639,-1.0,-1,0,NULL,1648793059,2006,'track_10','track_10.mp3',0,1,1,0,62,0,NULL,0,8,18,10,55,0,NULL);
INSERT INTO Media VALUES(551,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_1','track_1.mp3',0,1,1,0,63,0,NULL,0,8,67,1,56,0,NULL);
INSERT INTO Media VALUES(552,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_2','track_2.mp3',0,1,1,0,63,0,NULL,0,8,26,2,56,0,NULL);
INSERT INTO Media VALUES(553,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_3','track_3.mp3',0,1,1,0,63,0,NULL,0,8,9,3,56,0,NULL);
INSERT INTO Media VALUES(554,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_4','track_4.mp3',0,1,1,0,63,0,NULL,0,8,72,4,56,0,NULL);
INSERT INTO Media VALUES(555,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_5','track_5.mp3',0,1,1,0,63,0,NULL,0,8,55,5,56,0,NULL);
INSERT INTO Media VALUES(556,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_6','track_6.mp3',0,1,1,0,63,0,NULL,0,8,61,6,56,0,NULL);
INSERT INTO Media VALUES(557,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_7','track_7.mp3',0,1,1,0,63,0,NULL,0,8,69,7,56,0,NULL);
INSERT INTO Media VALUES(558,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_8','track_8.mp3',0,1,1,0,63,0,NULL,0,8,47,8,56,0,NULL);
INSERT INTO Media VALUES(559,2,3,639,-1.0,-1,0,NULL,1648793059,2005,'track_9','track_9.mp3',0,1,1,0,63,0,NULL,0,8,3,9,56,0,NULL);
INSERT INTO Media VALUES(560,2,3,639,-1.0,-1,0,NULL,1648793060,2005,'track_10','track_10.mp3',0,1,1,0,63,0,NULL,0,8,30,10,56,0,NULL);
INSERT INTO Media VALUES(561,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_1','track_1.mp3',0,1,1,0,64,0,NULL,0,8,33,1,57,0,NULL);
INSERT INTO Media VALUES(562,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_2','track_2.mp3',0,1,1,0,64,0,NULL,0,8,58,2,57,0,NULL);
INSERT INTO Media VALUES(563,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_3','track_3.mp3',0,1,1,0,64,0,NULL,0,8,70,3,57,0,NULL);
INSERT INTO Media VALUES(564,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_4','track_4.mp3',0,1,1,0,64,0,NULL,0,8,47,4,57,0,NULL);
INSERT INTO Media VALUES(565,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_5','track_5.mp3',0,1,1,0,64,0,NULL,0,8,5,5,57,0,NULL);
INSERT INTO Media VALUES(566,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_6','track_6.mp3',0,1,1,0,64,0,NULL,0,8,15,6,57,0,NULL);
INSERT INTO Media VALUES(567,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_7','track_7.mp3',0,1,1,0,64,0,NULL,0,8,63,7,57,0,NULL);
INSERT INTO Media VALUES(568,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_8','track_8.mp3',0,1,1,0,64,0,NULL,0,8,41,8,57,0,NULL);
INSERT INTO Media VALUES(569,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_9','track_9.mp3',0,1,1,0,64,0,NULL,0,8,60,9,57,0,NULL);
INSERT INTO Media VALUES(570,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_10','track_10.mp3',0,1,1,0,64,0,NULL,0,8,46,10,57,0,NULL);
INSERT INTO Media VALUES(571,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_1','track_1.mp3',0,1,1,0,65,0,NULL,0,8,64,1,58,0,NULL);
INSERT INTO Media VALUES(572,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_2','track_2.mp3',0,1,1,0,65,0,NULL,0,8,56,2,58,0,NULL);
INSERT INTO Media VALUES(573,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_3','track_3.mp3',0,1,1,0,65,0,NULL,0,8,14,3,58,0,NULL);
INSERT INTO Media VALUES(574,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_4','track_4.mp3',0,1,1,0,65,0,NULL,0,8,18,4,58,0,NULL);
INSERT INTO Media VALUES(575,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_5','track_5.mp3',0,1,1,0,65,0,NULL,0,8,13,5,58,0,NULL);
INSERT INTO Media VALUES(576,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_6','track_6.mp3',0,1,1,0,65,0,NULL,0,8,59,6,58,0,NULL);
INSERT INTO Media VALUES(577,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_7','track_7.mp3',0,1,1,0,65,0,NULL,0,8,51,7,58,0,NULL);
INSERT INTO Media VALUES(578,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_8','track_8.mp3',0,1,1,0,65,0,NULL,0,8,71,8,58,0,NULL);
INSERT INTO Media VALUES(579,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_9','track_9.mp3',0,1,1,0,65,0,NULL,0,8,9,9,58,0,NULL);
INSERT INTO Media VALUES(580,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_10','track_10.mp3',0,1,1,0,65,0,NULL,0,8,5,10,58,0,NULL);
INSERT INTO Media VALUES(581,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_1','track_1.mp3',0,1,1,0,66,0,NULL,0,8,21,1,59,0,NULL);
INSERT INTO Media VALUES(582,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_2','track_2.mp3',0,1,1,0,66,0,NULL,0,8,31,2,59,0,NULL);
INSERT INTO Media VALUES(583,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_3','track_3.mp3',0,1,1,0,66,0,NULL,0,8,68,3,59,0,NULL);
INSERT INTO Media VALUES(584,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_4','track_4.mp3',0,1,1,0,66,0,NULL,0,8,7,4,59,0,NULL);
INSERT INTO Media VALUES(585,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_5','track_5.mp3',0,1,1,0,66,0,NULL,0,8,19,5,59,0,NULL);
INSERT INTO Media VALUES(586,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_6','track_6.mp3',0,1,1,0,66,0,NULL,0,8,43,6,59,0,NULL);
INSERT INTO Media VALUES(587,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_7','track_7.mp3',0,1,1,0,66,0,NULL,0,8,26,7,59,0,NULL);
INSERT INTO Media VALUES(588,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_8','track_8.mp3',0,1,1,0,66,0,NULL,0,8,10,8,59,0,NULL);
INSERT INTO Media VALUES(589,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_9','track_9.mp3',0,1,1,0,66,0,NULL,0,8,59,9,59,0,NULL);
INSERT INTO Media VALUES(590,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_10','track_10.mp3',0,1,1,0,66,0,NULL,0,8,67,10,59,0,NULL);
INSERT INTO Media VALUES(591,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_1','track_1.mp3',0,1,1,0,67,0,NULL,0,8,17,1,60,0,NULL);
INSERT INTO Media VALUES(592,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_2','track_2.mp3',0,1,1,0,67,0,NULL,0,8,15,2,60,0,NULL);
INSERT INTO Media VALUES(593,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_3','track_3.mp3',0,1,1,0,67,0,NULL,0,8,46,3,60,0,NULL);
INSERT INTO Media VALUES(594,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_4','track_4.mp3',0,1,1,0,67,0,NULL,0,8,76,4,60,0,NULL);
INSERT INTO Media VALUES(595,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_5','track_5.mp3',0,1,1,0,67,0,NULL,0,8,64,5,60,0,NULL);
INSERT INTO Media VALUES(596,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_6','track_6.mp3',0,1,1,0,67,0,NULL,0,8,78,6,60,0,NULL);
INSERT INTO Media VALUES(597,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_7','track_7.mp3',0,1,1,0,67,0,NULL,0,8,30,7,60,0,NULL);
INSERT INTO Media VALUES(598,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_8','track_8.mp3',0,1,1,0,67,0,NULL,0,8,66,8,60,0,NULL);
INSERT INTO Media VALUES(599,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_9','track_9.mp3',0,1,1,0,67,0,NULL,0,8,12,9,60,0,NULL);
INSERT INTO Media VALUES(600,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_10','track_10.mp3',0,1,1,0,67,0,NULL,0,8,21,10,60,0,NULL);
INSERT INTO Media VALUES(601,2,3,639,-1.0,-1,0,NULL,1648793060,2010,'track_1','track_1.mp3',0,1,1,0,69,0,NULL,0,9,71,1,61,0,NULL);
INSERT INTO Media VALUES(602,2,3,639,-1.0,-1,0,NULL,1648793060,2010,'track_2','track_2.mp3',0,1,1,0,69,0,NULL,0,9,65,2,61,0,NULL);
INSERT INTO Media VALUES(603,2,3,639,-1.0,-1,0,NULL,1648793060,2010,'track_3','track_3.mp3',0,1,1,0,69,0,NULL,0,9,49,3,61,0,NULL);
INSERT INTO Media VALUES(604,2,3,639,-1.0,-1,0,NULL,1648793060,2010,'track_4','track_4.mp3',0,1,1,0,69,0,NULL,0,9,21,4,61,0,NULL);
INSERT INTO Media VALUES(605,2,3,639,-1.0,-1,0,NULL,1648793060,2010,'track_5','track_5.mp3',0,1,1,0,69,0,NULL,0,9,6,5,61,0,NULL);
INSERT INTO Media VALUES(606,2,3,639,-1.0,-1,0,NULL,1648793060,2010,'track_6','track_6.mp3',0,1,1,0,69,0,NULL,0,9,27,6,61,0,NULL);
INSERT INTO Media VALUES(607,2,3,639,-1.0,-1,0,NULL,1648793060,2010,'track_7','track_7.mp3',0,1,1,0,69,0,NULL,0,9,27,7,61,0,NULL);
INSERT INTO Media VALUES(608,2,3,639,-1.0,-1,0,NULL,1648793060,2010,'track_8','track_8.mp3',0,1,1,0,69,0,NULL,0,9,59,8,61,0,NULL);
INSERT INTO Media VALUES(609,2,3,639,-1.0,-1,0,NULL,1648793060,2010,'track_9','track_9.mp3',0,1,1,0,69,0,NULL,0,9,64,9,61,0,NULL);
INSERT INTO Media VALUES(610,2,3,639,-1.0,-1,0,NULL,1648793060,2010,'track_10','track_10.mp3',0,1,1,0,69,0,NULL,0,9,62,10,61,0,NULL);
INSERT INTO Media VALUES(611,2,3,639,-1.0,-1,0,NULL,1648793060,2009,'track_1','track_1.mp3',0,1,1,0,70,0,NULL,0,9,6,1,62,0,NULL);
INSERT INTO Media VALUES(612,2,3,639,-1.0,-1,0,NULL,1648793060,2009,'track_2','track_2.mp3',0,1,1,0,70,0,NULL,0,9,10,2,62,0,NULL);
INSERT INTO Media VALUES(613,2,3,639,-1.0,-1,0,NULL,1648793060,2009,'track_3','track_3.mp3',0,1,1,0,70,0,NULL,0,9,66,3,62,0,NULL);
INSERT INTO Media VALUES(614,2,3,639,-1.0,-1,0,NULL,1648793060,2009,'track_4','track_4.mp3',0,1,1,0,70,0,NULL,0,9,26,4,62,0,NULL);
INSERT INTO Media VALUES(615,2,3,639,-1.0,-1,0,NULL,1648793060,2009,'track_5','track_5.mp3',0,1,1,0,70,0,NULL,0,9,14,5,62,0,NULL);
INSERT INTO Media VALUES(616,2,3,639,-1.0,-1,0,NULL,1648793060,2009,'track_6','track_6.mp3',0,1,1,0,70,0,NULL,0,9,52,6,62,0,NULL);
INSERT INTO Media VALUES(617,2,3,639,-1.0,-1,0,NULL,1648793060,2009,'track_7','track_7.mp3',0,1,1,0,70,0,NULL,0,9,27,7,62,0,NULL);
INSERT INTO Media VALUES(618,2,3,639,-1.0,-1,0,NULL,1648793060,2009,'track_8','track_8.mp3',0,1,1,0,70,0,NULL,0,9,74,8,62,0,NULL);
INSERT INTO Media VALUES(619,2,3,639,-1.0,-1,0,NULL,1648793060,2009,'track_9','track_9.mp3',0,1,1,0,70,0,NULL,0,9,53,9,62,0,NULL);
INSERT INTO Media VALUES(620,2,3,639,-1.0,-1,0,NULL,1648793060,2009,'track_10','track_10.mp3',0,1,1,0,70,0,NULL,0,9,54,10,62,0,NULL);
INSERT INTO Media VALUES(621,2,3,639,-1.0,-1,0,NULL,1648793060,2008,'track_1','track_1.mp3',0,1,1,0,71,0,NULL,0,9,44,1,63,0,NULL);
INSERT INTO Media VALUES(622,2,3,639,-1.0,-1,0,NULL,1648793060,2008,'track_2','track_2.mp3',0,1,1,0,71,0,NULL,0,9,73,2,63,0,NULL);
INSERT INTO Media VALUES(623,2,3,639,-1.0,-1,0,NULL,1648793060,2008,'track_3','track_3.mp3',0,1,1,0,71,0,NULL,0,9,60,3,63,0,NULL);
INSERT INTO Media VALUES(624,2,3,639,-1.0,-1,0,NULL,1648793060,2008,'track_4','track_4.mp3',0,1,1,0,71,0,NULL,0,9,57,4,63,0,NULL);
INSERT INTO Media VALUES(625,2,3,639,-1.0,-1,0,NULL,1648793060,2008,'track_5','track_5.mp3',0,1,1,0,71,0,NULL,0,9,10,5,63,0,NULL);
INSERT INTO Media VALUES(626,2,3,639,-1.0,-1,0,NULL,1648793060,2008,'track_6','track_6.mp3',0,1,1,0,71,0,NULL,0,9,35,6,63,0,NULL);
INSERT INTO Media VALUES(627,2,3,639,-1.0,-1,0,NULL,1648793060,2008,'track_7','track_7.mp3',0,1,1,0,71,0,NULL,0,9,46,7,63,0,NULL);
INSERT INTO Media VALUES(628,2,3,639,-1.0,-1,0,NULL,1648793060,2008,'track_8','track_8.mp3',0,1,1,0,71,0,NULL,0,9,32,8,63,0,NULL);
INSERT INTO Media VALUES(629,2,3,639,-1.0,-1,0,NULL,1648793060,2008,'track_9','track_9.mp3',0,1,1,0,71,0,NULL,0,9,52,9,63,0,NULL);
INSERT INTO Media VALUES(630,2,3,639,-1.0,-1,0,NULL,1648793060,2008,'track_10','track_10.mp3',0,1,1,0,71,0,NULL,0,9,24,10,63,0,NULL);
INSERT INTO Media VALUES(631,2,3,639,-1.0,-1,0,NULL,1648793060,2007,'track_1','track_1.mp3',0,1,1,0,72,0,NULL,0,9,47,1,64,0,NULL);
INSERT INTO Media VALUES(632,2,3,639,-1.0,-1,0,NULL,1648793060,2007,'track_2','track_2.mp3',0,1,1,0,72,0,NULL,0,9,33,2,64,0,NULL);
INSERT INTO Media VALUES(633,2,3,639,-1.0,-1,0,NULL,1648793060,2007,'track_3','track_3.mp3',0,1,1,0,72,0,NULL,0,9,22,3,64,0,NULL);
INSERT INTO Media VALUES(634,2,3,639,-1.0,-1,0,NULL,1648793060,2007,'track_4','track_4.mp3',0,1,1,0,72,0,NULL,0,9,33,4,64,0,NULL);
INSERT INTO Media VALUES(635,2,3,639,-1.0,-1,0,NULL,1648793060,2007,'track_5','track_5.mp3',0,1,1,0,72,0,NULL,0,9,38,5,64,0,NULL);
INSERT INTO Media VALUES(636,2,3,639,-1.0,-1,0,NULL,1648793060,2007,'track_6','track_6.mp3',0,1,1,0,72,0,NULL,0,9,41,6,64,0,NULL);
INSERT INTO Media VALUES(637,2,3,639,-1.0,-1,0,NULL,1648793060,2007,'track_7','track_7.mp3',0,1,1,0,72,0,NULL,0,9,53,7,64,0,NULL);
INSERT INTO Media VALUES(638,2,3,639,-1.0,-1,0,NULL,1648793060,2007,'track_8','track_8.mp3',0,1,1,0,72,0,NULL,0,9,78,8,64,0,NULL);
INSERT INTO Media VALUES(639,2,3,639,-1.0,-1,0,NULL,1648793060,2007,'track_9','track_9.mp3',0,1,1,0,72,0,NULL,0,9,48,9,64,0,NULL);
INSERT INTO Media VALUES(640,2,3,639,-1.0,-1,0,NULL,1648793060,2007,'track_10','track_10.mp3',0,1,1,0,72,0,NULL,0,9,45,10,64,0,NULL);
INSERT INTO Media VALUES(641,2,3,639,-1.0,-1,0,NULL,1648793060,2006,'track_1','track_1.mp3',0,1,1,0,73,0,NULL,0,9,51,1,65,0,NULL);
INSERT INTO Media VALUES(642,2,3,639,-1.0,-1,0,NULL,1648793060,2006,'track_2','track_2.mp3',0,1,1,0,73,0,NULL,0,9,40,2,65,0,NULL);
INSERT INTO Media VALUES(643,2,3,639,-1.0,-1,0,NULL,1648793060,2006,'track_3','track_3.mp3',0,1,1,0,73,0,NULL,0,9,76,3,65,0,NULL);
INSERT INTO Media VALUES(644,2,3,639,-1.0,-1,0,NULL,1648793060,2006,'track_4','track_4.mp3',0,1,1,0,73,0,NULL,0,9,55,4,65,0,NULL);
INSERT INTO Media VALUES(645,2,3,639,-1.0,-1,0,NULL,1648793060,2006,'track_5','track_5.mp3',0,1,1,0,73,0,NULL,0,9,63,5,65,0,NULL);
INSERT INTO Media VALUES(646,2,3,639,-1.0,-1,0,NULL,1648793060,2006,'track_6','track_6.mp3',0,1,1,0,73,0,NULL,0,9,29,6,65,0,NULL);
INSERT INTO Media VALUES(647,2,3,639,-1.0,-1,0,NULL,1648793060,2006,'track_7','track_7.mp3',0,1,1,0,73,0,NULL,0,9,26,7,65,0,NULL);
INSERT INTO Media VALUES(648,2,3,639,-1.0,-1,0,NULL,1648793060,2006,'track_8','track_8.mp3',0,1,1,0,73,0,NULL,0,9,41,8,65,0,NULL);
INSERT INTO Media VALUES(649,2,3,639,-1.0,-1,0,NULL,1648793060,2006,'track_9','track_9.mp3',0,1,1,0,73,0,NULL,0,9,70,9,65,0,NULL);
INSERT INTO Media VALUES(650,2,3,639,-1.0,-1,0,NULL,1648793060,2006,'track_10','track_10.mp3',0,1,1,0,73,0,NULL,0,9,20,10,65,0,NULL);
INSERT INTO Media VALUES(651,2,3,639,-1.0,-1,0,NULL,1648793060,2005,'track_1','track_1.mp3',0,1,1,0,74,0,NULL,0,9,16,1,66,0,NULL);
INSERT INTO Media VALUES(652,2,3,639,-1.0,-1,0,NULL,1648793060,2005,'track_2','track_2.mp3',0,1,1,0,74,0,NULL,0,9,54,2,66,0,NULL);
INSERT INTO Media VALUES(653,2,3,639,-1.0,-1,0,NULL,1648793060,2005,'track_3','track_3.mp3',0,1,1,0,74,0,NULL,0,9,50,3,66,0,NULL);
INSERT INTO Media VALUES(654,2,3,639,-1.0,-1,0,NULL,1648793060,2005,'track_4','track_4.mp3',0,1,1,0,74,0,NULL,0,9,18,4,66,0,NULL);
INSERT INTO Media VALUES(655,2,3,639,-1.0,-1,0,NULL,1648793060,2005,'track_5','track_5.mp3',0,1,1,0,74,0,NULL,0,9,14,5,66,0,NULL);
INSERT INTO Media VALUES(656,2,3,639,-1.0,-1,0,NULL,1648793060,2005,'track_6','track_6.mp3',0,1,1,0,74,0,NULL,0,9,39,6,66,0,NULL);
INSERT INTO Media VALUES(657,2,3,639,-1.0,-1,0,NULL,1648793060,2005,'track_7','track_7.mp3',0,1,1,0,74,0,NULL,0,9,77,7,66,0,NULL);
INSERT INTO Media VALUES(658,2,3,639,-1.0,-1,0,NULL,1648793060,2005,'track_8','track_8.mp3',0,1,1,0,74,0,NULL,0,9,18,8,66,0,NULL);
INSERT INTO Media VALUES(659,2,3,639,-1.0,-1,0,NULL,1648793060,2005,'track_9','track_9.mp3',0,1,1,0,74,0,NULL,0,9,38,9,66,0,NULL);
INSERT INTO Media VALUES(660,2,3,639,-1.0,-1,0,NULL,1648793060,2005,'track_10','track_10.mp3',0,1,1,0,74,0,NULL,0,9,28,10,66,0,NULL);
INSERT INTO Media VALUES(661,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_1','track_1.mp3',0,1,1,0,75,0,NULL,0,9,41,1,67,0,NULL);
INSERT INTO Media VALUES(662,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_2','track_2.mp3',0,1,1,0,75,0,NULL,0,9,73,2,67,0,NULL);
INSERT INTO Media VALUES(663,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_3','track_3.mp3',0,1,1,0,75,0,NULL,0,9,48,3,67,0,NULL);
INSERT INTO Media VALUES(664,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_4','track_4.mp3',0,1,1,0,75,0,NULL,0,9,29,4,67,0,NULL);
INSERT INTO Media VALUES(665,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_5','track_5.mp3',0,1,1,0,75,0,NULL,0,9,3,5,67,0,NULL);
INSERT INTO Media VALUES(666,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_6','track_6.mp3',0,1,1,0,75,0,NULL,0,9,45,6,67,0,NULL);
INSERT INTO Media VALUES(667,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_7','track_7.mp3',0,1,1,0,75,0,NULL,0,9,57,7,67,0,NULL);
INSERT INTO Media VALUES(668,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_8','track_8.mp3',0,1,1,0,75,0,NULL,0,9,61,8,67,0,NULL);
INSERT INTO Media VALUES(669,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_9','track_9.mp3',0,1,1,0,75,0,NULL,0,9,39,9,67,0,NULL);
INSERT INTO Media VALUES(670,2,3,639,-1.0,-1,0,NULL,1648793060,2004,'track_10','track_10.mp3',0,1,1,0,75,0,NULL,0,9,66,10,67,0,NULL);
INSERT INTO Media VALUES(671,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_1','track_1.mp3',0,1,1,0,76,0,NULL,0,9,73,1,68,0,NULL);
INSERT INTO Media VALUES(672,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_2','track_2.mp3',0,1,1,0,76,0,NULL,0,9,63,2,68,0,NULL);
INSERT INTO Media VALUES(673,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_3','track_3.mp3',0,1,1,0,76,0,NULL,0,9,58,3,68,0,NULL);
INSERT INTO Media VALUES(674,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_4','track_4.mp3',0,1,1,0,76,0,NULL,0,9,15,4,68,0,NULL);
INSERT INTO Media VALUES(675,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_5','track_5.mp3',0,1,1,0,76,0,NULL,0,9,33,5,68,0,NULL);
INSERT INTO Media VALUES(676,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_6','track_6.mp3',0,1,1,0,76,0,NULL,0,9,33,6,68,0,NULL);
INSERT INTO Media VALUES(677,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_7','track_7.mp3',0,1,1,0,76,0,NULL,0,9,59,7,68,0,NULL);
INSERT INTO Media VALUES(678,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_8','track_8.mp3',0,1,1,0,76,0,NULL,0,9,43,8,68,0,NULL);
INSERT INTO Media VALUES(679,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_9','track_9.mp3',0,1,1,0,76,0,NULL,0,9,49,9,68,0,NULL);
INSERT INTO Media VALUES(680,2,3,639,-1.0,-1,0,NULL,1648793060,2003,'track_10','track_10.mp3',0,1,1,0,76,0,NULL,0,9,7,10,68,0,NULL);
INSERT INTO Media VALUES(681,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_1','track_1.mp3',0,1,1,0,77,0,NULL,0,9,11,1,69,0,NULL);
INSERT INTO Media VALUES(682,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_2','track_2.mp3',0,1,1,0,77,0,NULL,0,9,19,2,69,0,NULL);
INSERT INTO Media VALUES(683,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_3','track_3.mp3',0,1,1,0,77,0,NULL,0,9,75,3,69,0,NULL);
INSERT INTO Media VALUES(684,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_4','track_4.mp3',0,1,1,0,77,0,NULL,0,9,72,4,69,0,NULL);
INSERT INTO Media VALUES(685,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_5','track_5.mp3',0,1,1,0,77,0,NULL,0,9,31,5,69,0,NULL);
INSERT INTO Media VALUES(686,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_6','track_6.mp3',0,1,1,0,77,0,NULL,0,9,73,6,69,0,NULL);
INSERT INTO Media VALUES(687,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_7','track_7.mp3',0,1,1,0,77,0,NULL,0,9,35,7,69,0,NULL);
INSERT INTO Media VALUES(688,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_8','track_8.mp3',0,1,1,0,77,0,NULL,0,9,19,8,69,0,NULL);
INSERT INTO Media VALUES(689,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_9','track_9.mp3',0,1,1,0,77,0,NULL,0,9,36,9,69,0,NULL);
INSERT INTO Media VALUES(690,2,3,639,-1.0,-1,0,NULL,1648793060,2002,'track_10','track_10.mp3',0,1,1,0,77,0,NULL,0,9,33,10,69,0,NULL);
INSERT INTO Media VALUES(691,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_1','track_1.mp3',0,1,1,0,78,0,NULL,0,9,4,1,70,0,NULL);
INSERT INTO Media VALUES(692,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_2','track_2.mp3',0,1,1,0,78,0,NULL,0,9,73,2,70,0,NULL);
INSERT INTO Media VALUES(693,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_3','track_3.mp3',0,1,1,0,78,0,NULL,0,9,54,3,70,0,NULL);
INSERT INTO Media VALUES(694,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_4','track_4.mp3',0,1,1,0,78,0,NULL,0,9,28,4,70,0,NULL);
INSERT INTO Media VALUES(695,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_5','track_5.mp3',0,1,1,0,78,0,NULL,0,9,68,5,70,0,NULL);
INSERT INTO Media VALUES(696,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_6','track_6.mp3',0,1,1,0,78,0,NULL,0,9,29,6,70,0,NULL);
INSERT INTO Media VALUES(697,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_7','track_7.mp3',0,1,1,0,78,0,NULL,0,9,28,7,70,0,NULL);
INSERT INTO Media VALUES(698,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_8','track_8.mp3',0,1,1,0,78,0,NULL,0,9,33,8,70,0,NULL);
INSERT INTO Media VALUES(699,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_9','track_9.mp3',0,1,1,0,78,0,NULL,0,9,71,9,70,0,NULL);
INSERT INTO Media VALUES(700,2,3,639,-1.0,-1,0,NULL,1648793060,2001,'track_10','track_10.mp3',0,1,1,0,78,0,NULL,0,9,75,10,70,0,NULL);
INSERT INTO Media VALUES(701,2,3,639,-1.0,-1,0,NULL,1648793060,2010,'track_1','track_1.mp3',0,1,1,0,80,0,NULL,0,10,40,1,71,0,NULL);
INSERT INTO Media VALUES(702,2,3,639,-1.0,-1,0,NULL,1648793060,2010,'track_2','track_2.mp3',0,1,1,0,80,0,NULL,0,10,64,2,71,0,NULL);
INSERT INTO Media VALUES(703,2,3,639,-1.0,-1,0,NULL,1648793060,2010,'track_3','track_3.mp3',0,1,1,0,80,0,NULL,0,10,60,3,71,0,NULL);
INSERT INTO Media VALUES(704,2,3,639,-1.0,-1,0,NULL,1648793060,2010,'track_4','track_4.mp3',0,1,1,0,80,0,NULL,0,10,64,4,71,0,NULL);
INSERT INTO Media VALUES(705,2,3,639,-1.0,-1,0,NULL,1648793061,2010,'track_5','track_5.mp3',0,1,1,0,80,0,NULL,0,10,66,5,71,0,NULL);
INSERT INTO Media VALUES(706,2,3,639,-1.0,-1,0,NULL,1648793061,2010,'track_6','track_6.mp3',0,1,1,0,80,0,NULL,0,10,45,6,71,0,NULL);
INSERT INTO Media VALUES(707,2,3,639,-1.0,-1,0,NULL,1648793061,2010,'track_7','track_7.mp3',0,1,1,0,80,0,NULL,0,10,62,7,71,0,NULL);
INSERT INTO Media VALUES(708,2,3,639,-1.0,-1,0,NULL,1648793061,2010,'track_8','track_8.mp3',0,1,1,0,80,0,NULL,0,10,48,8,71,0,NULL);
INSERT INTO Media VALUES(709,2,3,639,-1.0,-1,0,NULL,1648793061,2010,'track_9','track_9.mp3',0,1,1,0,80,0,NULL,0,10,50,9,71,0,NULL);
INSERT INTO Media VALUES(710,2,3,639,-1.0,-1,0,NULL,1648793061,2010,'track_10','track_10.mp3',0,1,1,0,80,0,NULL,0,10,63,10,71,0,NULL);
INSERT INTO Media VALUES(711,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_1','track_1.mp3',0,1,1,0,81,0,NULL,0,10,32,1,72,0,NULL);
INSERT INTO Media VALUES(712,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_2','track_2.mp3',0,1,1,0,81,0,NULL,0,10,49,2,72,0,NULL);
INSERT INTO Media VALUES(713,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_3','track_3.mp3',0,1,1,0,81,0,NULL,0,10,54,3,72,0,NULL);
INSERT INTO Media VALUES(714,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_4','track_4.mp3',0,1,1,0,81,0,NULL,0,10,73,4,72,0,NULL);
INSERT INTO Media VALUES(715,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_5','track_5.mp3',0,1,1,0,81,0,NULL,0,10,46,5,72,0,NULL);
INSERT INTO Media VALUES(716,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_6','track_6.mp3',0,1,1,0,81,0,NULL,0,10,62,6,72,0,NULL);
INSERT INTO Media VALUES(717,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_7','track_7.mp3',0,1,1,0,81,0,NULL,0,10,9,7,72,0,NULL);
INSERT INTO Media VALUES(718,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_8','track_8.mp3',0,1,1,0,81,0,NULL,0,10,45,8,72,0,NULL);
INSERT INTO Media VALUES(719,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_9','track_9.mp3',0,1,1,0,81,0,NULL,0,10,34,9,72,0,NULL);
INSERT INTO Media VALUES(720,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_10','track_10.mp3',0,1,1,0,81,0,NULL,0,10,29,10,72,0,NULL);
INSERT INTO Media VALUES(721,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_1','track_1.mp3',0,1,1,0,82,0,NULL,0,10,45,1,73,0,NULL);
INSERT INTO Media VALUES(722,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_2','track_2.mp3',0,1,1,0,82,0,NULL,0,10,50,2,73,0,NULL);
INSERT INTO Media VALUES(723,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_3','track_3.mp3',0,1,1,0,82,0,NULL,0,10,46,3,73,0,NULL);
INSERT INTO Media VALUES(724,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_4','track_4.mp3',0,1,1,0,82,0,NULL,0,10,64,4,73,0,NULL);
INSERT INTO Media VALUES(725,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_5','track_5.mp3',0,1,1,0,82,0,NULL,0,10,32,5,73,0,NULL);
INSERT INTO Media VALUES(726,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_6','track_6.mp3',0,1,1,0,82,0,NULL,0,10,16,6,73,0,NULL);
INSERT INTO Media VALUES(727,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_7','track_7.mp3',0,1,1,0,82,0,NULL,0,10,68,7,73,0,NULL);
INSERT INTO Media VALUES(728,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_8','track_8.mp3',0,1,1,0,82,0,NULL,0,10,62,8,73,0,NULL);
INSERT INTO Media VALUES(729,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_9','track_9.mp3',0,1,1,0,82,0,NULL,0,10,68,9,73,0,NULL);
INSERT INTO Media VALUES(730,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_10','track_10.mp3',0,1,1,0,82,0,NULL,0,10,33,10,73,0,NULL);
INSERT INTO Media VALUES(731,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_1','track_1.mp3',0,1,1,0,83,0,NULL,0,10,47,1,74,0,NULL);
INSERT INTO Media VALUES(732,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_2','track_2.mp3',0,1,1,0,83,0,NULL,0,10,50,2,74,0,NULL);
INSERT INTO Media VALUES(733,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_3','track_3.mp3',0,1,1,0,83,0,NULL,0,10,32,3,74,0,NULL);
INSERT INTO Media VALUES(734,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_4','track_4.mp3',0,1,1,0,83,0,NULL,0,10,42,4,74,0,NULL);
INSERT INTO Media VALUES(735,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_5','track_5.mp3',0,1,1,0,83,0,NULL,0,10,42,5,74,0,NULL);
INSERT INTO Media VALUES(736,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_6','track_6.mp3',0,1,1,0,83,0,NULL,0,10,23,6,74,0,NULL);
INSERT INTO Media VALUES(737,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_7','track_7.mp3',0,1,1,0,83,0,NULL,0,10,42,7,74,0,NULL);
INSERT INTO Media VALUES(738,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_8','track_8.mp3',0,1,1,0,83,0,NULL,0,10,32,8,74,0,NULL);
INSERT INTO Media VALUES(739,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_9','track_9.mp3',0,1,1,0,83,0,NULL,0,10,63,9,74,0,NULL);
INSERT INTO Media VALUES(740,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_10','track_10.mp3',0,1,1,0,83,0,NULL,0,10,41,10,74,0,NULL);
INSERT INTO Media VALUES(741,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_1','track_1.mp3',0,1,1,0,84,0,NULL,0,10,51,1,75,0,NULL);
INSERT INTO Media VALUES(742,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_2','track_2.mp3',0,1,1,0,84,0,NULL,0,10,57,2,75,0,NULL);
INSERT INTO Media VALUES(743,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_3','track_3.mp3',0,1,1,0,84,0,NULL,0,10,76,3,75,0,NULL);
INSERT INTO Media VALUES(744,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_4','track_4.mp3',0,1,1,0,84,0,NULL,0,10,31,4,75,0,NULL);
INSERT INTO Media VALUES(745,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_5','track_5.mp3',0,1,1,0,84,0,NULL,0,10,68,5,75,0,NULL);
INSERT INTO Media VALUES(746,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_6','track_6.mp3',0,1,1,0,84,0,NULL,0,10,20,6,75,0,NULL);
INSERT INTO Media VALUES(747,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_7','track_7.mp3',0,1,1,0,84,0,NULL,0,10,33,7,75,0,NULL);
INSERT INTO Media VALUES(748,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_8','track_8.mp3',0,1,1,0,84,0,NULL,0,10,65,8,75,0,NULL);
INSERT INTO Media VALUES(749,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_9','track_9.mp3',0,1,1,0,84,0,NULL,0,10,22,9,75,0,NULL);
INSERT INTO Media VALUES(750,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_10','track_10.mp3',0,1,1,0,84,0,NULL,0,10,6,10,75,0,NULL);
INSERT INTO Media VALUES(751,2,3,639,-1.0,-1,0,NULL,1648793061,2005,'track_1','track_1.mp3',0,1,1,0,85,0,NULL,0,10,10,1,76,0,NULL);
INSERT INTO Media VALUES(752,2,3,639,-1.0,-1,0,NULL,1648793061,2005,'track_2','track_2.mp3',0,1,1,0,85,0,NULL,0,10,23,2,76,0,NULL);
INSERT INTO Media VALUES(753,2,3,639,-1.0,-1,0,NULL,1648793061,2005,'track_3','track_3.mp3',0,1,1,0,85,0,NULL,0,10,60,3,76,0,NULL);
INSERT INTO Media VALUES(754,2,3,639,-1.0,-1,0,NULL,1648793061,2005,'track_4','track_4.mp3',0,1,1,0,85,0,NULL,0,10,6,4,76,0,NULL);
INSERT INTO Media VALUES(755,2,3,639,-1.0,-1,0,NULL,1648793061,2005,'track_5','track_5.mp3',0,1,1,0,85,0,NULL,0,10,37,5,76,0,NULL);
INSERT INTO Media VALUES(756,2,3,639,-1.0,-1,0,NULL,1648793061,2005,'track_6','track_6.mp3',0,1,1,0,85,0,NULL,0,10,17,6,76,0,NULL);
INSERT INTO Media VALUES(757,2,3,639,-1.0,-1,0,NULL,1648793061,2005,'track_7','track_7.mp3',0,1,1,0,85,0,NULL,0,10,52,7,76,0,NULL);
INSERT INTO Media VALUES(758,2,3,639,-1.0,-1,0,NULL,1648793061,2005,'track_8','track_8.mp3',0,1,1,0,85,0,NULL,0,10,64,8,76,0,NULL);
INSERT INTO Media VALUES(759,2,3,639,-1.0,-1,0,NULL,1648793061,2005,'track_9','track_9.mp3',0,1,1,0,85,0,NULL,0,10,1,9,76,0,NULL);
INSERT INTO Media VALUES(760,2,3,639,-1.0,-1,0,NULL,1648793061,2005,'track_10','track_10.mp3',0,1,1,0,85,0,NULL,0,10,77,10,76,0,NULL);
INSERT INTO Media VALUES(761,2,3,639,-1.0,-1,0,NULL,1648793061,2004,'track_1','track_1.mp3',0,1,1,0,86,0,NULL,0,10,16,1,77,0,NULL);
INSERT INTO Media VALUES(762,2,3,639,-1.0,-1,0,NULL,1648793061,2004,'track_2','track_2.mp3',0,1,1,0,86,0,NULL,0,10,47,2,77,0,NULL);
INSERT INTO Media VALUES(763,2,3,639,-1.0,-1,0,NULL,1648793061,2004,'track_3','track_3.mp3',0,1,1,0,86,0,NULL,0,10,43,3,77,0,NULL);
INSERT INTO Media VALUES(764,2,3,639,-1.0,-1,0,NULL,1648793061,2004,'track_4','track_4.mp3',0,1,1,0,86,0,NULL,0,10,23,4,77,0,NULL);
INSERT INTO Media VALUES(765,2,3,639,-1.0,-1,0,NULL,1648793061,2004,'track_5','track_5.mp3',0,1,1,0,86,0,NULL,0,10,44,5,77,0,NULL);
INSERT INTO Media VALUES(766,2,3,639,-1.0,-1,0,NULL,1648793061,2004,'track_6','track_6.mp3',0,1,1,0,86,0,NULL,0,10,19,6,77,0,NULL);
INSERT INTO Media VALUES(767,2,3,639,-1.0,-1,0,NULL,1648793061,2004,'track_7','track_7.mp3',0,1,1,0,86,0,NULL,0,10,8,7,77,0,NULL);
INSERT INTO Media VALUES(768,2,3,639,-1.0,-1,0,NULL,1648793061,2004,'track_8','track_8.mp3',0,1,1,0,86,0,NULL,0,10,16,8,77,0,NULL);
INSERT INTO Media VALUES(769,2,3,639,-1.0,-1,0,NULL,1648793061,2004,'track_9','track_9.mp3',0,1,1,0,86,0,NULL,0,10,36,9,77,0,NULL);
INSERT INTO Media VALUES(770,2,3,639,-1.0,-1,0,NULL,1648793061,2004,'track_10','track_10.mp3',0,1,1,0,86,0,NULL,0,10,6,10,77,0,NULL);
INSERT INTO Media VALUES(771,2,3,639,-1.0,-1,0,NULL,1648793061,2003,'track_1','track_1.mp3',0,1,1,0,87,0,NULL,0,10,13,1,78,0,NULL);
INSERT INTO Media VALUES(772,2,3,639,-1.0,-1,0,NULL,1648793061,2003,'track_2','track_2.mp3',0,1,1,0,87,0,NULL,0,10,70,2,78,0,NULL);
INSERT INTO Media VALUES(773,2,3,639,-1.0,-1,0,NULL,1648793061,2003,'track_3','track_3.mp3',0,1,1,0,87,0,NULL,0,10,60,3,78,0,NULL);
INSERT INTO Media VALUES(774,2,3,639,-1.0,-1,0,NULL,1648793061,2003,'track_4','track_4.mp3',0,1,1,0,87,0,NULL,0,10,31,4,78,0,NULL);
INSERT INTO Media VALUES(775,2,3,639,-1.0,-1,0,NULL,1648793061,2003,'track_5','track_5.mp3',0,1,1,0,87,0,NULL,0,10,32,5,78,0,NULL);
INSERT INTO Media VALUES(776,2,3,639,-1.0,-1,0,NULL,1648793061,2003,'track_6','track_6.mp3',0,1,1,0,87,0,NULL,0,10,77,6,78,0,NULL);
INSERT INTO Media VALUES(777,2,3,639,-1.0,-1,0,NULL,1648793061,2003,'track_7','track_7.mp3',0,1,1,0,87,0,NULL,0,10,64,7,78,0,NULL);
INSERT INTO Media VALUES(778,2,3,639,-1.0,-1,0,NULL,1648793061,2003,'track_8','track_8.mp3',0,1,1,0,87,0,NULL,0,10,60,8,78,0,NULL);
INSERT INTO Media VALUES(779,2,3,639,-1.0,-1,0,NULL,1648793061,2003,'track_9','track_9.mp3',0,1,1,0,87,0,NULL,0,10,52,9,78,0,NULL);
INSERT INTO Media VALUES(780,2,3,639,-1.0,-1,0,NULL,1648793061,2003,'track_10','track_10.mp3',0,1,1,0,87,0,NULL,0,10,33,10,78,0,NULL);
INSERT INTO Media VALUES(781,2,3,639,-1.0,-1,0,NULL,1648793061,2002,'track_1','track_1.mp3',0,1,1,0,88,0,NULL,0,10,42,1,79,0,NULL);
INSERT INTO Media VALUES(782,2,3,639,-1.0,-1,0,NULL,1648793061,2002,'track_2','track_2.mp3',0,1,1,0,88,0,NULL,0,10,39,2,79,0,NULL);
INSERT INTO Media VALUES(783,2,3,639,-1.0,-1,0,NULL,1648793061,2002,'track_3','track_3.mp3',0,1,1,0,88,0,NULL,0,10,10,3,79,0,NULL);
INSERT INTO Media VALUES(784,2,3,639,-1.0,-1,0,NULL,1648793061,2002,'track_4','track_4.mp3',0,1,1,0,88,0,NULL,0,10,70,4,79,0,NULL);
INSERT INTO Media VALUES(785,2,3,639,-1.0,-1,0,NULL,1648793061,2002,'track_5','track_5.mp3',0,1,1,0,88,0,NULL,0,10,59,5,79,0,NULL);
INSERT INTO Media VALUES(786,2,3,639,-1.0,-1,0,NULL,1648793061,2002,'track_6','track_6.mp3',0,1,1,0,88,0,NULL,0,10,65,6,79,0,NULL);
INSERT INTO Media VALUES(787,2,3,639,-1.0,-1,0,NULL,1648793061,2002,'track_7','track_7.mp3',0,1,1,0,88,0,NULL,0,10,17,7,79,0,NULL);
INSERT INTO Media VALUES(788,2,3,639,-1.0,-1,0,NULL,1648793061,2002,'track_8','track_8.mp3',0,1,1,0,88,0,NULL,0,10,19,8,79,0,NULL);
INSERT INTO Media VALUES(789,2,3,639,-1.0,-1,0,NULL,1648793061,2002,'track_9','track_9.mp3',0,1,1,0,88,0,NULL,0,10,73,9,79,0,NULL);
INSERT INTO Media VALUES(790,2,3,639,-1.0,-1,0,NULL,1648793061,2002,'track_10','track_10.mp3',0,1,1,0,88,0,NULL,0,10,49,10,79,0,NULL);
INSERT INTO Media VALUES(791,2,3,639,-1.0,-1,0,NULL,1648793061,2001,'track_1','track_1.mp3',0,1,1,0,89,0,NULL,0,10,76,1,80,0,NULL);
INSERT INTO Media VALUES(792,2,3,639,-1.0,-1,0,NULL,1648793061,2001,'track_2','track_2.mp3',0,1,1,0,89,0,NULL,0,10,2,2,80,0,NULL);
INSERT INTO Media VALUES(793,2,3,639,-1.0,-1,0,NULL,1648793061,2001,'track_3','track_3.mp3',0,1,1,0,89,0,NULL,0,10,39,3,80,0,NULL);
INSERT INTO Media VALUES(794,2,3,639,-1.0,-1,0,NULL,1648793061,2001,'track_4','track_4.mp3',0,1,1,0,89,0,NULL,0,10,69,4,80,0,NULL);
INSERT INTO Media VALUES(795,2,3,639,-1.0,-1,0,NULL,1648793061,2001,'track_5','track_5.mp3',0,1,1,0,89,0,NULL,0,10,17,5,80,0,NULL);
INSERT INTO Media VALUES(796,2,3,639,-1.0,-1,0,NULL,1648793061,2001,'track_6','track_6.mp3',0,1,1,0,89,0,NULL,0,10,18,6,80,0,NULL);
INSERT INTO Media VALUES(797,2,3,639,-1.0,-1,0,NULL,1648793061,2001,'track_7','track_7.mp3',0,1,1,0,89,0,NULL,0,10,65,7,80,0,NULL);
INSERT INTO Media VALUES(798,2,3,639,-1.0,-1,0,NULL,1648793061,2001,'track_8','track_8.mp3',0,1,1,0,89,0,NULL,0,10,55,8,80,0,NULL);
INSERT INTO Media VALUES(799,2,3,639,-1.0,-1,0,NULL,1648793061,2001,'track_9','track_9.mp3',0,1,1,0,89,0,NULL,0,10,36,9,80,0,NULL);
INSERT INTO Media VALUES(800,2,3,639,-1.0,-1,0,NULL,1648793061,2001,'track_10','track_10.mp3',0,1,1,0,89,0,NULL,0,10,46,10,80,0,NULL);
INSERT INTO Media VALUES(801,2,3,639,-1.0,-1,0,NULL,1648793061,2010,'track_1','track_1.mp3',0,1,1,0,91,0,NULL,0,11,39,1,81,0,NULL);
INSERT INTO Media VALUES(802,2,3,639,-1.0,-1,0,NULL,1648793061,2010,'track_2','track_2.mp3',0,1,1,0,91,0,NULL,0,11,17,2,81,0,NULL);
INSERT INTO Media VALUES(803,2,3,639,-1.0,-1,0,NULL,1648793061,2010,'track_3','track_3.mp3',0,1,1,0,91,0,NULL,0,11,11,3,81,0,NULL);
INSERT INTO Media VALUES(804,2,3,639,-1.0,-1,0,NULL,1648793061,2010,'track_4','track_4.mp3',0,1,1,0,91,0,NULL,0,11,62,4,81,0,NULL);
INSERT INTO Media VALUES(805,2,3,639,-1.0,-1,0,NULL,1648793061,2010,'track_5','track_5.mp3',0,1,1,0,91,0,NULL,0,11,49,5,81,0,NULL);
INSERT INTO Media VALUES(806,2,3,639,-1.0,-1,0,NULL,1648793061,2010,'track_6','track_6.mp3',0,1,1,0,91,0,NULL,0,11,80,6,81,0,NULL);
INSERT INTO Media VALUES(807,2,3,639,-1.0,-1,0,NULL,1648793061,2010,'track_7','track_7.mp3',0,1,1,0,91,0,NULL,0,11,53,7,81,0,NULL);
INSERT INTO Media VALUES(808,2,3,639,-1.0,-1,0,NULL,1648793061,2010,'track_8','track_8.mp3',0,1,1,0,91,0,NULL,0,11,62,8,81,0,NULL);
INSERT INTO Media VALUES(809,2,3,639,-1.0,-1,0,NULL,1648793061,2010,'track_9','track_9.mp3',0,1,1,0,91,0,NULL,0,11,67,9,81,0,NULL);
INSERT INTO Media VALUES(810,2,3,639,-1.0,-1,0,NULL,1648793061,2010,'track_10','track_10.mp3',0,1,1,0,91,0,NULL,0,11,80,10,81,0,NULL);
INSERT INTO Media VALUES(811,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_1','track_1.mp3',0,1,1,0,92,0,NULL,0,11,72,1,82,0,NULL);
INSERT INTO Media VALUES(812,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_2','track_2.mp3',0,1,1,0,92,0,NULL,0,11,27,2,82,0,NULL);
INSERT INTO Media VALUES(813,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_3','track_3.mp3',0,1,1,0,92,0,NULL,0,11,57,3,82,0,NULL);
INSERT INTO Media VALUES(814,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_4','track_4.mp3',0,1,1,0,92,0,NULL,0,11,28,4,82,0,NULL);
INSERT INTO Media VALUES(815,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_5','track_5.mp3',0,1,1,0,92,0,NULL,0,11,9,5,82,0,NULL);
INSERT INTO Media VALUES(816,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_6','track_6.mp3',0,1,1,0,92,0,NULL,0,11,6,6,82,0,NULL);
INSERT INTO Media VALUES(817,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_7','track_7.mp3',0,1,1,0,92,0,NULL,0,11,7,7,82,0,NULL);
INSERT INTO Media VALUES(818,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_8','track_8.mp3',0,1,1,0,92,0,NULL,0,11,29,8,82,0,NULL);
INSERT INTO Media VALUES(819,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_9','track_9.mp3',0,1,1,0,92,0,NULL,0,11,30,9,82,0,NULL);
INSERT INTO Media VALUES(820,2,3,639,-1.0,-1,0,NULL,1648793061,2009,'track_10','track_10.mp3',0,1,1,0,92,0,NULL,0,11,58,10,82,0,NULL);
INSERT INTO Media VALUES(821,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_1','track_1.mp3',0,1,1,0,93,0,NULL,0,11,56,1,83,0,NULL);
INSERT INTO Media VALUES(822,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_2','track_2.mp3',0,1,1,0,93,0,NULL,0,11,6,2,83,0,NULL);
INSERT INTO Media VALUES(823,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_3','track_3.mp3',0,1,1,0,93,0,NULL,0,11,9,3,83,0,NULL);
INSERT INTO Media VALUES(824,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_4','track_4.mp3',0,1,1,0,93,0,NULL,0,11,21,4,83,0,NULL);
INSERT INTO Media VALUES(825,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_5','track_5.mp3',0,1,1,0,93,0,NULL,0,11,53,5,83,0,NULL);
INSERT INTO Media VALUES(826,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_6','track_6.mp3',0,1,1,0,93,0,NULL,0,11,63,6,83,0,NULL);
INSERT INTO Media VALUES(827,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_7','track_7.mp3',0,1,1,0,93,0,NULL,0,11,40,7,83,0,NULL);
INSERT INTO Media VALUES(828,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_8','track_8.mp3',0,1,1,0,93,0,NULL,0,11,75,8,83,0,NULL);
INSERT INTO Media VALUES(829,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_9','track_9.mp3',0,1,1,0,93,0,NULL,0,11,55,9,83,0,NULL);
INSERT INTO Media VALUES(830,2,3,639,-1.0,-1,0,NULL,1648793061,2008,'track_10','track_10.mp3',0,1,1,0,93,0,NULL,0,11,65,10,83,0,NULL);
INSERT INTO Media VALUES(831,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_1','track_1.mp3',0,1,1,0,94,0,NULL,0,11,29,1,84,0,NULL);
INSERT INTO Media VALUES(832,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_2','track_2.mp3',0,1,1,0,94,0,NULL,0,11,61,2,84,0,NULL);
INSERT INTO Media VALUES(833,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_3','track_3.mp3',0,1,1,0,94,0,NULL,0,11,58,3,84,0,NULL);
INSERT INTO Media VALUES(834,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_4','track_4.mp3',0,1,1,0,94,0,NULL,0,11,47,4,84,0,NULL);
INSERT INTO Media VALUES(835,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_5','track_5.mp3',0,1,1,0,94,0,NULL,0,11,72,5,84,0,NULL);
INSERT INTO Media VALUES(836,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_6','track_6.mp3',0,1,1,0,94,0,NULL,0,11,21,6,84,0,NULL);
INSERT INTO Media VALUES(837,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_7','track_7.mp3',0,1,1,0,94,0,NULL,0,11,31,7,84,0,NULL);
INSERT INTO Media VALUES(838,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_8','track_8.mp3',0,1,1,0,94,0,NULL,0,11,64,8,84,0,NULL);
INSERT INTO Media VALUES(839,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_9','track_9.mp3',0,1,1,0,94,0,NULL,0,11,61,9,84,0,NULL);
INSERT INTO Media VALUES(840,2,3,639,-1.0,-1,0,NULL,1648793061,2007,'track_10','track_10.mp3',0,1,1,0,94,0,NULL,0,11,21,10,84,0,NULL);
INSERT INTO Media VALUES(841,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_1','track_1.mp3',0,1,1,0,95,0,NULL,0,11,66,1,85,0,NULL);
INSERT INTO Media VALUES(842,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_2','track_2.mp3',0,1,1,0,95,0,NULL,0,11,73,2,85,0,NULL);
INSERT INTO Media VALUES(843,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_3','track_3.mp3',0,1,1,0,95,0,NULL,0,11,62,3,85,0,NULL);
INSERT INTO Media VALUES(844,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_4','track_4.mp3',0,1,1,0,95,0,NULL,0,11,10,4,85,0,NULL);
INSERT INTO Media VALUES(845,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_5','track_5.mp3',0,1,1,0,95,0,NULL,0,11,66,5,85,0,NULL);
INSERT INTO Media VALUES(846,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_6','track_6.mp3',0,1,1,0,95,0,NULL,0,11,39,6,85,0,NULL);
INSERT INTO Media VALUES(847,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_7','track_7.mp3',0,1,1,0,95,0,NULL,0,11,20,7,85,0,NULL);
INSERT INTO Media VALUES(848,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_8','track_8.mp3',0,1,1,0,95,0,NULL,0,11,34,8,85,0,NULL);
INSERT INTO Media VALUES(849,2,3,639,-1.0,-1,0,NULL,1648793061,2006,'track_9','track_9.mp3',0,1,1,0,95,0,NULL,0,11,7,9,85,0,NULL);
INSERT INTO Media VALUES(850,2,3,639,-1.0,-1,0,NULL,1648793062,2006,'track_10','track_10.mp3',0,1,1,0,95,0,NULL,0,11,32,10,85,0,NULL);
INSERT INTO Media VALUES(851,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_1','track_1.mp3',0,1,1,0,96,0,NULL,0,11,77,1,86,0,NULL);
INSERT INTO Media VALUES(852,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_2','track_2.mp3',0,1,1,0,96,0,NULL,0,11,10,2,86,0,NULL);
INSERT INTO Media VALUES(853,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_3','track_3.mp3',0,1,1,0,96,0,NULL,0,11,20,3,86,0,NULL);
INSERT INTO Media VALUES(854,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_4','track_4.mp3',0,1,1,0,96,0,NULL,0,11,42,4,86,0,NULL);
INSERT INTO Media VALUES(855,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_5','track_5.mp3',0,1,1,0,96,0,NULL,0,11,67,5,86,0,NULL);
INSERT INTO Media VALUES(856,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_6','track_6.mp3',0,1,1,0,96,0,NULL,0,11,37,6,86,0,NULL);
INSERT INTO Media VALUES(857,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_7','track_7.mp3',0,1,1,0,96,0,NULL,0,11,27,7,86,0,NULL);
INSERT INTO Media VALUES(858,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_8','track_8.mp3',0,1,1,0,96,0,NULL,0,11,70,8,86,0,NULL);
INSERT INTO Media VALUES(859,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_9','track_9.mp3',0,1,1,0,96,0,NULL,0,11,31,9,86,0,NULL);
INSERT INTO Media VALUES(860,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_10','track_10.mp3',0,1,1,0,96,0,NULL,0,11,7,10,86,0,NULL);
INSERT INTO Media VALUES(861,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_1','track_1.mp3',0,1,1,0,97,0,NULL,0,11,77,1,87,0,NULL);
INSERT INTO Media VALUES(862,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_2','track_2.mp3',0,1,1,0,97,0,NULL,0,11,11,2,87,0,NULL);
INSERT INTO Media VALUES(863,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_3','track_3.mp3',0,1,1,0,97,0,NULL,0,11,28,3,87,0,NULL);
INSERT INTO Media VALUES(864,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_4','track_4.mp3',0,1,1,0,97,0,NULL,0,11,47,4,87,0,NULL);
INSERT INTO Media VALUES(865,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_5','track_5.mp3',0,1,1,0,97,0,NULL,0,11,53,5,87,0,NULL);
INSERT INTO Media VALUES(866,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_6','track_6.mp3',0,1,1,0,97,0,NULL,0,11,28,6,87,0,NULL);
INSERT INTO Media VALUES(867,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_7','track_7.mp3',0,1,1,0,97,0,NULL,0,11,50,7,87,0,NULL);
INSERT INTO Media VALUES(868,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_8','track_8.mp3',0,1,1,0,97,0,NULL,0,11,25,8,87,0,NULL);
INSERT INTO Media VALUES(869,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_9','track_9.mp3',0,1,1,0,97,0,NULL,0,11,73,9,87,0,NULL);
INSERT INTO Media VALUES(870,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_10','track_10.mp3',0,1,1,0,97,0,NULL,0,11,14,10,87,0,NULL);
INSERT INTO Media VALUES(871,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_1','track_1.mp3',0,1,1,0,98,0,NULL,0,11,8,1,88,0,NULL);
INSERT INTO Media VALUES(872,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_2','track_2.mp3',0,1,1,0,98,0,NULL,0,11,49,2,88,0,NULL);
INSERT INTO Media VALUES(873,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_3','track_3.mp3',0,1,1,0,98,0,NULL,0,11,34,3,88,0,NULL);
INSERT INTO Media VALUES(874,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_4','track_4.mp3',0,1,1,0,98,0,NULL,0,11,33,4,88,0,NULL);
INSERT INTO Media VALUES(875,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_5','track_5.mp3',0,1,1,0,98,0,NULL,0,11,1,5,88,0,NULL);
INSERT INTO Media VALUES(876,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_6','track_6.mp3',0,1,1,0,98,0,NULL,0,11,78,6,88,0,NULL);
INSERT INTO Media VALUES(877,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_7','track_7.mp3',0,1,1,0,98,0,NULL,0,11,34,7,88,0,NULL);
INSERT INTO Media VALUES(878,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_8','track_8.mp3',0,1,1,0,98,0,NULL,0,11,4,8,88,0,NULL);
INSERT INTO Media VALUES(879,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_9','track_9.mp3',0,1,1,0,98,0,NULL,0,11,43,9,88,0,NULL);
INSERT INTO Media VALUES(880,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_10','track_10.mp3',0,1,1,0,98,0,NULL,0,11,40,10,88,0,NULL);
INSERT INTO Media VALUES(881,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_1','track_1.mp3',0,1,1,0,99,0,NULL,0,11,13,1,89,0,NULL);
INSERT INTO Media VALUES(882,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_2','track_2.mp3',0,1,1,0,99,0,NULL,0,11,15,2,89,0,NULL);
INSERT INTO Media VALUES(883,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_3','track_3.mp3',0,1,1,0,99,0,NULL,0,11,50,3,89,0,NULL);
INSERT INTO Media VALUES(884,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_4','track_4.mp3',0,1,1,0,99,0,NULL,0,11,37,4,89,0,NULL);
INSERT INTO Media VALUES(885,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_5','track_5.mp3',0,1,1,0,99,0,NULL,0,11,54,5,89,0,NULL);
INSERT INTO Media VALUES(886,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_6','track_6.mp3',0,1,1,0,99,0,NULL,0,11,69,6,89,0,NULL);
INSERT INTO Media VALUES(887,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_7','track_7.mp3',0,1,1,0,99,0,NULL,0,11,31,7,89,0,NULL);
INSERT INTO Media VALUES(888,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_8','track_8.mp3',0,1,1,0,99,0,NULL,0,11,70,8,89,0,NULL);
INSERT INTO Media VALUES(889,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_9','track_9.mp3',0,1,1,0,99,0,NULL,0,11,37,9,89,0,NULL);
INSERT INTO Media VALUES(890,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_10','track_10.mp3',0,1,1,0,99,0,NULL,0,11,58,10,89,0,NULL);
INSERT INTO Media VALUES(891,2,3,639,-1.0,-1,0,NULL,1648793062,2001,'track_1','track_1.mp3',0,1,1,0,100,0,NULL,0,11,59,1,90,0,NULL);
INSERT INTO Media VALUES(892,2,3,639,-1.0,-1,0,NULL,1648793062,2001,'track_2','track_2.mp3',0,1,1,0,100,0,NULL,0,11,17,2,90,0,NULL);
INSERT INTO Media VALUES(893,2,3,639,-1.0,-1,0,NULL,1648793062,2001,'track_3','track_3.mp3',0,1,1,0,100,0,NULL,0,11,60,3,90,0,NULL);
INSERT INTO Media VALUES(894,2,3,639,-1.0,-1,0,NULL,1648793062,2001,'track_4','track_4.mp3',0,1,1,0,100,0,NULL,0,11,67,4,90,0,NULL);
INSERT INTO Media VALUES(895,2,3,639,-1.0,-1,0,NULL,1648793062,2001,'track_5','track_5.mp3',0,1,1,0,100,0,NULL,0,11,77,5,90,0,NULL);
INSERT INTO Media VALUES(896,2,3,639,-1.0,-1,0,NULL,1648793062,2001,'track_6','track_6.mp3',0,1,1,0,100,0,NULL,0,11,66,6,90,0,NULL);
INSERT INTO Media VALUES(897,2,3,639,-1.0,-1,0,NULL,1648793062,2001,'track_7','track_7.mp3',0,1,1,0,100,0,NULL,0,11,77,7,90,0,NULL);
INSERT INTO Media VALUES(898,2,3,639,-1.0,-1,0,NULL,1648793062,2001,'track_8','track_8.mp3',0,1,1,0,100,0,NULL,0,11,65,8,90,0,NULL);
INSERT INTO Media VALUES(899,2,3,639,-1.0,-1,0,NULL,1648793062,2001,'track_9','track_9.mp3',0,1,1,0,100,0,NULL,0,11,31,9,90,0,NULL);
INSERT INTO Media VALUES(900,2,3,639,-1.0,-1,0,NULL,1648793062,2001,'track_10','track_10.mp3',0,1,1,0,100,0,NULL,0,11,60,10,90,0,NULL);
INSERT INTO Media VALUES(901,2,3,639,-1.0,-1,0,NULL,1648793062,2010,'track_1','track_1.mp3',0,1,1,0,102,0,NULL,0,12,62,1,91,0,NULL);
INSERT INTO Media VALUES(902,2,3,639,-1.0,-1,0,NULL,1648793062,2010,'track_2','track_2.mp3',0,1,1,0,102,0,NULL,0,12,32,2,91,0,NULL);
INSERT INTO Media VALUES(903,2,3,639,-1.0,-1,0,NULL,1648793062,2010,'track_3','track_3.mp3',0,1,1,0,102,0,NULL,0,12,76,3,91,0,NULL);
INSERT INTO Media VALUES(904,2,3,639,-1.0,-1,0,NULL,1648793062,2010,'track_4','track_4.mp3',0,1,1,0,102,0,NULL,0,12,60,4,91,0,NULL);
INSERT INTO Media VALUES(905,2,3,639,-1.0,-1,0,NULL,1648793062,2010,'track_5','track_5.mp3',0,1,1,0,102,0,NULL,0,12,22,5,91,0,NULL);
INSERT INTO Media VALUES(906,2,3,639,-1.0,-1,0,NULL,1648793062,2010,'track_6','track_6.mp3',0,1,1,0,102,0,NULL,0,12,63,6,91,0,NULL);
INSERT INTO Media VALUES(907,2,3,639,-1.0,-1,0,NULL,1648793062,2010,'track_7','track_7.mp3',0,1,1,0,102,0,NULL,0,12,16,7,91,0,NULL);
INSERT INTO Media VALUES(908,2,3,639,-1.0,-1,0,NULL,1648793062,2010,'track_8','track_8.mp3',0,1,1,0,102,0,NULL,0,12,13,8,91,0,NULL);
INSERT INTO Media VALUES(909,2,3,639,-1.0,-1,0,NULL,1648793062,2010,'track_9','track_9.mp3',0,1,1,0,102,0,NULL,0,12,62,9,91,0,NULL);
INSERT INTO Media VALUES(910,2,3,639,-1.0,-1,0,NULL,1648793062,2010,'track_10','track_10.mp3',0,1,1,0,102,0,NULL,0,12,74,10,91,0,NULL);
INSERT INTO Media VALUES(911,2,3,639,-1.0,-1,0,NULL,1648793062,2009,'track_1','track_1.mp3',0,1,1,0,103,0,NULL,0,12,72,1,92,0,NULL);
INSERT INTO Media VALUES(912,2,3,639,-1.0,-1,0,NULL,1648793062,2009,'track_2','track_2.mp3',0,1,1,0,103,0,NULL,0,12,18,2,92,0,NULL);
INSERT INTO Media VALUES(913,2,3,639,-1.0,-1,0,NULL,1648793062,2009,'track_3','track_3.mp3',0,1,1,0,103,0,NULL,0,12,16,3,92,0,NULL);
INSERT INTO Media VALUES(914,2,3,639,-1.0,-1,0,NULL,1648793062,2009,'track_4','track_4.mp3',0,1,1,0,103,0,NULL,0,12,60,4,92,0,NULL);
INSERT INTO Media VALUES(915,2,3,639,-1.0,-1,0,NULL,1648793062,2009,'track_5','track_5.mp3',0,1,1,0,103,0,NULL,0,12,69,5,92,0,NULL);
INSERT INTO Media VALUES(916,2,3,639,-1.0,-1,0,NULL,1648793062,2009,'track_6','track_6.mp3',0,1,1,0,103,0,NULL,0,12,15,6,92,0,NULL);
INSERT INTO Media VALUES(917,2,3,639,-1.0,-1,0,NULL,1648793062,2009,'track_7','track_7.mp3',0,1,1,0,103,0,NULL,0,12,31,7,92,0,NULL);
INSERT INTO Media VALUES(918,2,3,639,-1.0,-1,0,NULL,1648793062,2009,'track_8','track_8.mp3',0,1,1,0,103,0,NULL,0,12,1,8,92,0,NULL);
INSERT INTO Media VALUES(919,2,3,639,-1.0,-1,0,NULL,1648793062,2009,'track_9','track_9.mp3',0,1,1,0,103,0,NULL,0,12,55,9,92,0,NULL);
INSERT INTO Media VALUES(920,2,3,639,-1.0,-1,0,NULL,1648793062,2009,'track_10','track_10.mp3',0,1,1,0,103,0,NULL,0,12,66,10,92,0,NULL);
INSERT INTO Media VALUES(921,2,3,639,-1.0,-1,0,NULL,1648793062,2008,'track_1','track_1.mp3',0,1,1,0,104,0,NULL,0,12,45,1,93,0,NULL);
INSERT INTO Media VALUES(922,2,3,639,-1.0,-1,0,NULL,1648793062,2008,'track_2','track_2.mp3',0,1,1,0,104,0,NULL,0,12,49,2,93,0,NULL);
INSERT INTO Media VALUES(923,2,3,639,-1.0,-1,0,NULL,1648793062,2008,'track_3','track_3.mp3',0,1,1,0,104,0,NULL,0,12,25,3,93,0,NULL);
INSERT INTO Media VALUES(924,2,3,639,-1.0,-1,0,NULL,1648793062,2008,'track_4','track_4.mp3',0,1,1,0,104,0,NULL,0,12,29,4,93,0,NULL);
INSERT INTO Media VALUES(925,2,3,639,-1.0,-1,0,NULL,1648793062,2008,'track_5','track_5.mp3',0,1,1,0,104,0,NULL,0,12,53,5,93,0,NULL);
INSERT INTO Media VALUES(926,2,3,639,-1.0,-1,0,NULL,1648793062,2008,'track_6','track_6.mp3',0,1,1,0,104,0,NULL,0,12,23,6,93,0,NULL);
INSERT INTO Media VALUES(927,2,3,639,-1.0,-1,0,NULL,1648793062,2008,'track_7','track_7.mp3',0,1,1,0,104,0,NULL,0,12,3,7,93,0,NULL);
INSERT INTO Media VALUES(928,2,3,639,-1.0,-1,0,NULL,1648793062,2008,'track_8','track_8.mp3',0,1,1,0,104,0,NULL,0,12,50,8,93,0,NULL);
INSERT INTO Media VALUES(929,2,3,639,-1.0,-1,0,NULL,1648793062,2008,'track_9','track_9.mp3',0,1,1,0,104,0,NULL,0,12,38,9,93,0,NULL);
INSERT INTO Media VALUES(930,2,3,639,-1.0,-1,0,NULL,1648793062,2008,'track_10','track_10.mp3',0,1,1,0,104,0,NULL,0,12,18,10,93,0,NULL);
INSERT INTO Media VALUES(931,2,3,639,-1.0,-1,0,NULL,1648793062,2007,'track_1','track_1.mp3',0,1,1,0,105,0,NULL,0,12,23,1,94,0,NULL);
INSERT INTO Media VALUES(932,2,3,639,-1.0,-1,0,NULL,1648793062,2007,'track_2','track_2.mp3',0,1,1,0,105,0,NULL,0,12,19,2,94,0,NULL);
INSERT INTO Media VALUES(933,2,3,639,-1.0,-1,0,NULL,1648793062,2007,'track_3','track_3.mp3',0,1,1,0,105,0,NULL,0,12,25,3,94,0,NULL);
INSERT INTO Media VALUES(934,2,3,639,-1.0,-1,0,NULL,1648793062,2007,'track_4','track_4.mp3',0,1,1,0,105,0,NULL,0,12,80,4,94,0,NULL);
INSERT INTO Media VALUES(935,2,3,639,-1.0,-1,0,NULL,1648793062,2007,'track_5','track_5.mp3',0,1,1,0,105,0,NULL,0,12,57,5,94,0,NULL);
INSERT INTO Media VALUES(936,2,3,639,-1.0,-1,0,NULL,1648793062,2007,'track_6','track_6.mp3',0,1,1,0,105,0,NULL,0,12,70,6,94,0,NULL);
INSERT INTO Media VALUES(937,2,3,639,-1.0,-1,0,NULL,1648793062,2007,'track_7','track_7.mp3',0,1,1,0,105,0,NULL,0,12,63,7,94,0,NULL);
INSERT INTO Media VALUES(938,2,3,639,-1.0,-1,0,NULL,1648793062,2007,'track_8','track_8.mp3',0,1,1,0,105,0,NULL,0,12,70,8,94,0,NULL);
INSERT INTO Media VALUES(939,2,3,639,-1.0,-1,0,NULL,1648793062,2007,'track_9','track_9.mp3',0,1,1,0,105,0,NULL,0,12,59,9,94,0,NULL);
INSERT INTO Media VALUES(940,2,3,639,-1.0,-1,0,NULL,1648793062,2007,'track_10','track_10.mp3',0,1,1,0,105,0,NULL,0,12,80,10,94,0,NULL);
INSERT INTO Media VALUES(941,2,3,639,-1.0,-1,0,NULL,1648793062,2006,'track_1','track_1.mp3',0,1,1,0,106,0,NULL,0,12,78,1,95,0,NULL);
INSERT INTO Media VALUES(942,2,3,639,-1.0,-1,0,NULL,1648793062,2006,'track_2','track_2.mp3',0,1,1,0,106,0,NULL,0,12,61,2,95,0,NULL);
INSERT INTO Media VALUES(943,2,3,639,-1.0,-1,0,NULL,1648793062,2006,'track_3','track_3.mp3',0,1,1,0,106,0,NULL,0,12,56,3,95,0,NULL);
INSERT INTO Media VALUES(944,2,3,639,-1.0,-1,0,NULL,1648793062,2006,'track_4','track_4.mp3',0,1,1,0,106,0,NULL,0,12,29,4,95,0,NULL);
INSERT INTO Media VALUES(945,2,3,639,-1.0,-1,0,NULL,1648793062,2006,'track_5','track_5.mp3',0,1,1,0,106,0,NULL,0,12,76,5,95,0,NULL);
INSERT INTO Media VALUES(946,2,3,639,-1.0,-1,0,NULL,1648793062,2006,'track_6','track_6.mp3',0,1,1,0,106,0,NULL,0,12,4,6,95,0,NULL);
INSERT INTO Media VALUES(947,2,3,639,-1.0,-1,0,NULL,1648793062,2006,'track_7','track_7.mp3',0,1,1,0,106,0,NULL,0,12,76,7,95,0,NULL);
INSERT INTO Media VALUES(948,2,3,639,-1.0,-1,0,NULL,1648793062,2006,'track_8','track_8.mp3',0,1,1,0,106,0,NULL,0,12,46,8,95,0,NULL);
INSERT INTO Media VALUES(949,2,3,639,-1.0,-1,0,NULL,1648793062,2006,'track_9','track_9.mp3',0,1,1,0,106,0,NULL,0,12,71,9,95,0,NULL);
INSERT INTO Media VALUES(950,2,3,639,-1.0,-1,0,NULL,1648793062,2006,'track_10','track_10.mp3',0,1,1,0,106,0,NULL,0,12,38,10,95,0,NULL);
INSERT INTO Media VALUES(951,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_1','track_1.mp3',0,1,1,0,107,0,NULL,0,12,25,1,96,0,NULL);
INSERT INTO Media VALUES(952,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_2','track_2.mp3',0,1,1,0,107,0,NULL,0,12,68,2,96,0,NULL);
INSERT INTO Media VALUES(953,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_3','track_3.mp3',0,1,1,0,107,0,NULL,0,12,13,3,96,0,NULL);
INSERT INTO Media VALUES(954,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_4','track_4.mp3',0,1,1,0,107,0,NULL,0,12,57,4,96,0,NULL);
INSERT INTO Media VALUES(955,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_5','track_5.mp3',0,1,1,0,107,0,NULL,0,12,40,5,96,0,NULL);
INSERT INTO Media VALUES(956,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_6','track_6.mp3',0,1,1,0,107,0,NULL,0,12,80,6,96,0,NULL);
INSERT INTO Media VALUES(957,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_7','track_7.mp3',0,1,1,0,107,0,NULL,0,12,39,7,96,0,NULL);
INSERT INTO Media VALUES(958,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_8','track_8.mp3',0,1,1,0,107,0,NULL,0,12,73,8,96,0,NULL);
INSERT INTO Media VALUES(959,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_9','track_9.mp3',0,1,1,0,107,0,NULL,0,12,46,9,96,0,NULL);
INSERT INTO Media VALUES(960,2,3,639,-1.0,-1,0,NULL,1648793062,2005,'track_10','track_10.mp3',0,1,1,0,107,0,NULL,0,12,16,10,96,0,NULL);
INSERT INTO Media VALUES(961,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_1','track_1.mp3',0,1,1,0,108,0,NULL,0,12,55,1,97,0,NULL);
INSERT INTO Media VALUES(962,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_2','track_2.mp3',0,1,1,0,108,0,NULL,0,12,15,2,97,0,NULL);
INSERT INTO Media VALUES(963,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_3','track_3.mp3',0,1,1,0,108,0,NULL,0,12,38,3,97,0,NULL);
INSERT INTO Media VALUES(964,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_4','track_4.mp3',0,1,1,0,108,0,NULL,0,12,22,4,97,0,NULL);
INSERT INTO Media VALUES(965,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_5','track_5.mp3',0,1,1,0,108,0,NULL,0,12,10,5,97,0,NULL);
INSERT INTO Media VALUES(966,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_6','track_6.mp3',0,1,1,0,108,0,NULL,0,12,32,6,97,0,NULL);
INSERT INTO Media VALUES(967,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_7','track_7.mp3',0,1,1,0,108,0,NULL,0,12,55,7,97,0,NULL);
INSERT INTO Media VALUES(968,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_8','track_8.mp3',0,1,1,0,108,0,NULL,0,12,73,8,97,0,NULL);
INSERT INTO Media VALUES(969,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_9','track_9.mp3',0,1,1,0,108,0,NULL,0,12,42,9,97,0,NULL);
INSERT INTO Media VALUES(970,2,3,639,-1.0,-1,0,NULL,1648793062,2004,'track_10','track_10.mp3',0,1,1,0,108,0,NULL,0,12,66,10,97,0,NULL);
INSERT INTO Media VALUES(971,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_1','track_1.mp3',0,1,1,0,109,0,NULL,0,12,56,1,98,0,NULL);
INSERT INTO Media VALUES(972,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_2','track_2.mp3',0,1,1,0,109,0,NULL,0,12,61,2,98,0,NULL);
INSERT INTO Media VALUES(973,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_3','track_3.mp3',0,1,1,0,109,0,NULL,0,12,42,3,98,0,NULL);
INSERT INTO Media VALUES(974,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_4','track_4.mp3',0,1,1,0,109,0,NULL,0,12,5,4,98,0,NULL);
INSERT INTO Media VALUES(975,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_5','track_5.mp3',0,1,1,0,109,0,NULL,0,12,62,5,98,0,NULL);
INSERT INTO Media VALUES(976,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_6','track_6.mp3',0,1,1,0,109,0,NULL,0,12,41,6,98,0,NULL);
INSERT INTO Media VALUES(977,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_7','track_7.mp3',0,1,1,0,109,0,NULL,0,12,35,7,98,0,NULL);
INSERT INTO Media VALUES(978,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_8','track_8.mp3',0,1,1,0,109,0,NULL,0,12,12,8,98,0,NULL);
INSERT INTO Media VALUES(979,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_9','track_9.mp3',0,1,1,0,109,0,NULL,0,12,17,9,98,0,NULL);
INSERT INTO Media VALUES(980,2,3,639,-1.0,-1,0,NULL,1648793062,2003,'track_10','track_10.mp3',0,1,1,0,109,0,NULL,0,12,14,10,98,0,NULL);
INSERT INTO Media VALUES(981,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_1','track_1.mp3',0,1,1,0,110,0,NULL,0,12,64,1,99,0,NULL);
INSERT INTO Media VALUES(982,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_2','track_2.mp3',0,1,1,0,110,0,NULL,0,12,32,2,99,0,NULL);
INSERT INTO Media VALUES(983,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_3','track_3.mp3',0,1,1,0,110,0,NULL,0,12,65,3,99,0,NULL);
INSERT INTO Media VALUES(984,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_4','track_4.mp3',0,1,1,0,110,0,NULL,0,12,76,4,99,0,NULL);
INSERT INTO Media VALUES(985,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_5','track_5.mp3',0,1,1,0,110,0,NULL,0,12,16,5,99,0,NULL);
INSERT INTO Media VALUES(986,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_6','track_6.mp3',0,1,1,0,110,0,NULL,0,12,1,6,99,0,NULL);
INSERT INTO Media VALUES(987,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_7','track_7.mp3',0,1,1,0,110,0,NULL,0,12,19,7,99,0,NULL);
INSERT INTO Media VALUES(988,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_8','track_8.mp3',0,1,1,0,110,0,NULL,0,12,46,8,99,0,NULL);
INSERT INTO Media VALUES(989,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_9','track_9.mp3',0,1,1,0,110,0,NULL,0,12,20,9,99,0,NULL);
INSERT INTO Media VALUES(990,2,3,639,-1.0,-1,0,NULL,1648793062,2002,'track_10','track_10.mp3',0,1,1,0,110,0,NULL,0,12,60,10,99,0,NULL);
INSERT INTO Media VALUES(991,2,3,639,-1.0,-1,0,NULL,1648793062,2001,'track_1','track_1.mp3',0,1,1,0,111,0,NULL,0,12,68,1,100,0,NULL);
INSERT INTO Media VALUES(992,2,3,639,-1.0,-1,0,NULL,1648793062,2001,'track_2','track_2.mp3',0,1,1,0,111,0,NULL,0,12,22,2,100,0,NULL);
INSERT INTO Media VALUES(993,2,3,639,-1.0,-1,0,NULL,1648793063,2001,'track_3','track_3.mp3',0,1,1,0,111,0,NULL,0,12,45,3,100,0,NULL);
INSERT INTO Media VALUES(994,2,3,639,-1.0,-1,0,NULL,1648793063,2001,'track_4','track_4.mp3',0,1,1,0,111,0,NULL,0,12,22,4,100,0,NULL);
INSERT INTO Media VALUES(995,2,3,639,-1.0,-1,0,NULL,1648793063,2001,'track_5','track_5.mp3',0,1,1,0,111,0,NULL,0,12,2,5,100,0,NULL);
INSERT INTO Media VALUES(996,2,3,639,-1.0,-1,0,NULL,1648793063,2001,'track_6','track_6.mp3',0,1,1,0,111,0,NULL,0,12,8,6,100,0,NULL);
INSERT INTO Media VALUES(997,2,3,639,-1.0,-1,0,NULL,1648793063,2001,'track_7','track_7.mp3',0,1,1,0,111,0,NULL,0,12,69,7,100,0,NULL);
INSERT INTO Media VALUES(998,2,3,639,-1.0,-1,0,NULL,1648793063,2001,'track_8','track_8.mp3',0,1,1,0,111,0,NULL,0,12,69,8,100,0,NULL);
INSERT INTO Media VALUES(999,2,3,639,-1.0,-1,0,NULL,1648793063,2001,'track_9','track_9.mp3',0,1,1,0,111,0,NULL,0,12,36,9,100,0,NULL);
INSERT INTO Media VALUES(1000,2,3,639,-1.0,-1,0,NULL,1648793063,2001,'track_10','track_10.mp3',0,1,1,0,111,0,NULL,0,12,24,10,100,0,NULL);
INSERT INTO File VALUES(1,1,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_1.mp3',1,1648793056,6272,3,0,0,0);
INSERT INTO File VALUES(2,2,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_2.mp3',1,1648793056,6272,3,0,0,0);
INSERT INTO File VALUES(3,3,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_3.mp3',1,1648793056,6272,3,0,0,0);
INSERT INTO File VALUES(4,4,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_4.mp3',1,1648793056,6272,3,0,0,0);
INSERT INTO File VALUES(5,5,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_5.mp3',1,1648793056,6272,3,0,0,0);
INSERT INTO File VALUES(6,6,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_6.mp3',1,1648793056,6272,3,0,0,0);
INSERT INTO File VALUES(7,7,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_7.mp3',1,1648793056,6272,3,0,0,0);
INSERT INTO File VALUES(8,8,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_8.mp3',1,1648793056,6272,3,0,0,0);
INSERT INTO File VALUES(9,9,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_9.mp3',1,1648793056,6272,3,0,0,0);
INSERT INTO File VALUES(10,10,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_10.mp3',1,1648793056,6272,3,0,0,0);
INSERT INTO File VALUES(11,11,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_1.mp3',1,1648793055,6272,4,0,0,0);
INSERT INTO File VALUES(12,12,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_2.mp3',1,1648793056,6272,4,0,0,0);
INSERT INTO File VALUES(13,13,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_3.mp3',1,1648793056,6272,4,0,0,0);
INSERT INTO File VALUES(14,14,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_4.mp3',1,1648793056,6272,4,0,0,0);
INSERT INTO File VALUES(15,15,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_5.mp3',1,1648793056,6272,4,0,0,0);
INSERT INTO File VALUES(16,16,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_6.mp3',1,1648793056,6272,4,0,0,0);
INSERT INTO File VALUES(17,17,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_7.mp3',1,1648793056,6272,4,0,0,0);
INSERT INTO File VALUES(18,18,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_8.mp3',1,1648793056,6272,4,0,0,0);
INSERT INTO File VALUES(19,19,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_9.mp3',1,1648793056,6272,4,0,0,0);
INSERT INTO File VALUES(20,20,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_10.mp3',1,1648793056,6272,4,0,0,0);
INSERT INTO File VALUES(21,21,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_1.mp3',1,1648793055,6272,5,0,0,0);
INSERT INTO File VALUES(22,22,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_2.mp3',1,1648793055,6272,5,0,0,0);
INSERT INTO File VALUES(23,23,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_3.mp3',1,1648793055,6272,5,0,0,0);
INSERT INTO File VALUES(24,24,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_4.mp3',1,1648793055,6272,5,0,0,0);
INSERT INTO File VALUES(25,25,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_5.mp3',1,1648793055,6272,5,0,0,0);
INSERT INTO File VALUES(26,26,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_6.mp3',1,1648793055,6272,5,0,0,0);
INSERT INTO File VALUES(27,27,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_7.mp3',1,1648793055,6272,5,0,0,0);
INSERT INTO File VALUES(28,28,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_8.mp3',1,1648793055,6272,5,0,0,0);
INSERT INTO File VALUES(29,29,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_9.mp3',1,1648793055,6272,5,0,0,0);
INSERT INTO File VALUES(30,30,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_10.mp3',1,1648793055,6272,5,0,0,0);
INSERT INTO File VALUES(31,31,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_1.mp3',1,1648793055,6272,6,0,0,0);
INSERT INTO File VALUES(32,32,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_2.mp3',1,1648793055,6272,6,0,0,0);
INSERT INTO File VALUES(33,33,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_3.mp3',1,1648793055,6272,6,0,0,0);
INSERT INTO File VALUES(34,34,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_4.mp3',1,1648793055,6272,6,0,0,0);
INSERT INTO File VALUES(35,35,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_5.mp3',1,1648793055,6272,6,0,0,0);
INSERT INTO File VALUES(36,36,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_6.mp3',1,1648793055,6272,6,0,0,0);
INSERT INTO File VALUES(37,37,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_7.mp3',1,1648793055,6272,6,0,0,0);
INSERT INTO File VALUES(38,38,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_8.mp3',1,1648793055,6272,6,0,0,0);
INSERT INTO File VALUES(39,39,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_9.mp3',1,1648793055,6272,6,0,0,0);
INSERT INTO File VALUES(40,40,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_10.mp3',1,1648793055,6272,6,0,0,0);
INSERT INTO File VALUES(41,41,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_1.mp3',1,1648793055,6272,7,0,0,0);
INSERT INTO File VALUES(42,42,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_2.mp3',1,1648793055,6272,7,0,0,0);
INSERT INTO File VALUES(43,43,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_3.mp3',1,1648793055,6272,7,0,0,0);
INSERT INTO File VALUES(44,44,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_4.mp3',1,1648793055,6272,7,0,0,0);
INSERT INTO File VALUES(45,45,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_5.mp3',1,1648793055,6272,7,0,0,0);
INSERT INTO File VALUES(46,46,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_6.mp3',1,1648793055,6272,7,0,0,0);
INSERT INTO File VALUES(47,47,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_7.mp3',1,1648793055,6272,7,0,0,0);
INSERT INTO File VALUES(48,48,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_8.mp3',1,1648793055,6272,7,0,0,0);
INSERT INTO File VALUES(49,49,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_9.mp3',1,1648793055,6272,7,0,0,0);
INSERT INTO File VALUES(50,50,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_10.mp3',1,1648793055,6272,7,0,0,0);
INSERT INTO File VALUES(51,51,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_1.mp3',1,1648793055,6272,8,0,0,0);
INSERT INTO File VALUES(52,52,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_2.mp3',1,1648793055,6272,8,0,0,0);
INSERT INTO File VALUES(53,53,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_3.mp3',1,1648793055,6272,8,0,0,0);
INSERT INTO File VALUES(54,54,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_4.mp3',1,1648793055,6272,8,0,0,0);
INSERT INTO File VALUES(55,55,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_5.mp3',1,1648793055,6272,8,0,0,0);
INSERT INTO File VALUES(56,56,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_6.mp3',1,1648793055,6272,8,0,0,0);
INSERT INTO File VALUES(57,57,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_7.mp3',1,1648793055,6272,8,0,0,0);
INSERT INTO File VALUES(58,58,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_8.mp3',1,1648793055,6272,8,0,0,0);
INSERT INTO File VALUES(59,59,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_9.mp3',1,1648793055,6272,8,0,0,0);
INSERT INTO File VALUES(60,60,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_10.mp3',1,1648793055,6272,8,0,0,0);
INSERT INTO File VALUES(61,61,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_1.mp3',1,1648793055,6272,9,0,0,0);
INSERT INTO File VALUES(62,62,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_2.mp3',1,1648793055,6272,9,0,0,0);
INSERT INTO File VALUES(63,63,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_3.mp3',1,1648793055,6272,9,0,0,0);
INSERT INTO File VALUES(64,64,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_4.mp3',1,1648793055,6272,9,0,0,0);
INSERT INTO File VALUES(65,65,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_5.mp3',1,1648793055,6272,9,0,0,0);
INSERT INTO File VALUES(66,66,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_6.mp3',1,1648793055,6272,9,0,0,0);
INSERT INTO File VALUES(67,67,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_7.mp3',1,1648793055,6272,9,0,0,0);
INSERT INTO File VALUES(68,68,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_8.mp3',1,1648793055,6272,9,0,0,0);
INSERT INTO File VALUES(69,69,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_9.mp3',1,1648793055,6272,9,0,0,0);
INSERT INTO File VALUES(70,70,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_10.mp3',1,1648793055,6272,9,0,0,0);
INSERT INTO File VALUES(71,71,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_1.mp3',1,1648793055,6272,10,0,0,0);
INSERT INTO File VALUES(72,72,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_2.mp3',1,1648793055,6272,10,0,0,0);
INSERT INTO File VALUES(73,73,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_3.mp3',1,1648793055,6272,10,0,0,0);
INSERT INTO File VALUES(74,74,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_4.mp3',1,1648793055,6272,10,0,0,0);
INSERT INTO File VALUES(75,75,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_5.mp3',1,1648793055,6272,10,0,0,0);
INSERT INTO File VALUES(76,76,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_6.mp3',1,1648793055,6272,10,0,0,0);
INSERT INTO File VALUES(77,77,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_7.mp3',1,1648793055,6272,10,0,0,0);
INSERT INTO File VALUES(78,78,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_8.mp3',1,1648793055,6272,10,0,0,0);
INSERT INTO File VALUES(79,79,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_9.mp3',1,1648793055,6272,10,0,0,0);
INSERT INTO File VALUES(80,80,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_10.mp3',1,1648793055,6272,10,0,0,0);
INSERT INTO File VALUES(81,81,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_1.mp3',1,1648793055,6272,11,0,0,0);
INSERT INTO File VALUES(82,82,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_2.mp3',1,1648793055,6272,11,0,0,0);
INSERT INTO File VALUES(83,83,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_3.mp3',1,1648793055,6272,11,0,0,0);
INSERT INTO File VALUES(84,84,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_4.mp3',1,1648793055,6272,11,0,0,0);
INSERT INTO File VALUES(85,85,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_5.mp3',1,1648793055,6272,11,0,0,0);
INSERT INTO File VALUES(86,86,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_6.mp3',1,1648793055,6272,11,0,0,0);
INSERT INTO File VALUES(87,87,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_7.mp3',1,1648793055,6272,11,0,0,0);
INSERT INTO File VALUES(88,88,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_8.mp3',1,1648793055,6272,11,0,0,0);
INSERT INTO File VALUES(89,89,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_9.mp3',1,1648793055,6272,11,0,0,0);
INSERT INTO File VALUES(90,90,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_10.mp3',1,1648793055,6272,11,0,0,0);
INSERT INTO File VALUES(91,91,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_1.mp3',1,1648793055,6272,12,0,0,0);
INSERT INTO File VALUES(92,92,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_2.mp3',1,1648793055,6272,12,0,0,0);
INSERT INTO File VALUES(93,93,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_3.mp3',1,1648793055,6272,12,0,0,0);
INSERT INTO File VALUES(94,94,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_4.mp3',1,1648793055,6272,12,0,0,0);
INSERT INTO File VALUES(95,95,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_5.mp3',1,1648793055,6272,12,0,0,0);
INSERT INTO File VALUES(96,96,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_6.mp3',1,1648793055,6272,12,0,0,0);
INSERT INTO File VALUES(97,97,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_7.mp3',1,1648793055,6272,12,0,0,0);
INSERT INTO File VALUES(98,98,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_8.mp3',1,1648793055,6272,12,0,0,0);
INSERT INTO File VALUES(99,99,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_9.mp3',1,1648793055,6272,12,0,0,0);
INSERT INTO File VALUES(100,100,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_10.mp3',1,1648793055,6272,12,0,0,0);
INSERT INTO File VALUES(101,101,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_1.mp3',1,1648793055,6272,14,0,0,0);
INSERT INTO File VALUES(102,102,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_2.mp3',1,1648793055,6272,14,0,0,0);
INSERT INTO File VALUES(103,103,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_3.mp3',1,1648793055,6272,14,0,0,0);
INSERT INTO File VALUES(104,104,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_4.mp3',1,1648793055,6272,14,0,0,0);
INSERT INTO File VALUES(105,105,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_5.mp3',1,1648793055,6272,14,0,0,0);
INSERT INTO File VALUES(106,106,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_6.mp3',1,1648793055,6272,14,0,0,0);
INSERT INTO File VALUES(107,107,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_7.mp3',1,1648793055,6272,14,0,0,0);
INSERT INTO File VALUES(108,108,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_8.mp3',1,1648793055,6272,14,0,0,0);
INSERT INTO File VALUES(109,109,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_9.mp3',1,1648793055,6272,14,0,0,0);
INSERT INTO File VALUES(110,110,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_10.mp3',1,1648793055,6272,14,0,0,0);
INSERT INTO File VALUES(111,111,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_1.mp3',1,1648793055,6272,15,0,0,0);
INSERT INTO File VALUES(112,112,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_2.mp3',1,1648793055,6272,15,0,0,0);
INSERT INTO File VALUES(113,113,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_3.mp3',1,1648793055,6272,15,0,0,0);
INSERT INTO File VALUES(114,114,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_4.mp3',1,1648793055,6272,15,0,0,0);
INSERT INTO File VALUES(115,115,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_5.mp3',1,1648793055,6272,15,0,0,0);
INSERT INTO File VALUES(116,116,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_6.mp3',1,1648793055,6272,15,0,0,0);
INSERT INTO File VALUES(117,117,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_7.mp3',1,1648793055,6272,15,0,0,0);
INSERT INTO File VALUES(118,118,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_8.mp3',1,1648793055,6272,15,0,0,0);
INSERT INTO File VALUES(119,119,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_9.mp3',1,1648793055,6272,15,0,0,0);
INSERT INTO File VALUES(120,120,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_10.mp3',1,1648793055,6272,15,0,0,0);
INSERT INTO File VALUES(121,121,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_1.mp3',1,1648793055,6272,16,0,0,0);
INSERT INTO File VALUES(122,122,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_2.mp3',1,1648793055,6272,16,0,0,0);
INSERT INTO File VALUES(123,123,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_3.mp3',1,1648793055,6272,16,0,0,0);
INSERT INTO File VALUES(124,124,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_4.mp3',1,1648793055,6272,16,0,0,0);
INSERT INTO File VALUES(125,125,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_5.mp3',1,1648793055,6272,16,0,0,0);
INSERT INTO File VALUES(126,126,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_6.mp3',1,1648793055,6272,16,0,0,0);
INSERT INTO File VALUES(127,127,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_7.mp3',1,1648793055,6272,16,0,0,0);
INSERT INTO File VALUES(128,128,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_8.mp3',1,1648793055,6272,16,0,0,0);
INSERT INTO File VALUES(129,129,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_9.mp3',1,1648793055,6272,16,0,0,0);
INSERT INTO File VALUES(130,130,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_10.mp3',1,1648793055,6272,16,0,0,0);
INSERT INTO File VALUES(131,131,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_1.mp3',1,1648793055,6272,17,0,0,0);
INSERT INTO File VALUES(132,132,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_2.mp3',1,1648793055,6272,17,0,0,0);
INSERT INTO File VALUES(133,133,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_3.mp3',1,1648793055,6272,17,0,0,0);
INSERT INTO File VALUES(134,134,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_4.mp3',1,1648793055,6272,17,0,0,0);
INSERT INTO File VALUES(135,135,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_5.mp3',1,1648793055,6272,17,0,0,0);
INSERT INTO File VALUES(136,136,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_6.mp3',1,1648793055,6272,17,0,0,0);
INSERT INTO File VALUES(137,137,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_7.mp3',1,1648793055,6272,17,0,0,0);
INSERT INTO File VALUES(138,138,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_8.mp3',1,1648793055,6272,17,0,0,0);
INSERT INTO File VALUES(139,139,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_9.mp3',1,1648793055,6272,17,0,0,0);
INSERT INTO File VALUES(140,140,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_10.mp3',1,1648793055,6272,17,0,0,0);
INSERT INTO File VALUES(141,141,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_1.mp3',1,1648793055,6272,18,0,0,0);
INSERT INTO File VALUES(142,142,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_2.mp3',1,1648793055,6272,18,0,0,0);
INSERT INTO File VALUES(143,143,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_3.mp3',1,1648793055,6272,18,0,0,0);
INSERT INTO File VALUES(144,144,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_4.mp3',1,1648793055,6272,18,0,0,0);
INSERT INTO File VALUES(145,145,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_5.mp3',1,1648793055,6272,18,0,0,0);
INSERT INTO File VALUES(146,146,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_6.mp3',1,1648793055,6272,18,0,0,0);
INSERT INTO File VALUES(147,147,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_7.mp3',1,1648793055,6272,18,0,0,0);
INSERT INTO File VALUES(148,148,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_8.mp3',1,1648793055,6272,18,0,0,0);
INSERT INTO File VALUES(149,149,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_9.mp3',1,1648793055,6272,18,0,0,0);
INSERT INTO File VALUES(150,150,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_10.mp3',1,1648793055,6272,18,0,0,0);
INSERT INTO File VALUES(151,151,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_1.mp3',1,1648793055,6272,19,0,0,0);
INSERT INTO File VALUES(152,152,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_2.mp3',1,1648793055,6272,19,0,0,0);
INSERT INTO File VALUES(153,153,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_3.mp3',1,1648793055,6272,19,0,0,0);
INSERT INTO File VALUES(154,154,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_4.mp3',1,1648793055,6272,19,0,0,0);
INSERT INTO File VALUES(155,155,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_5.mp3',1,1648793055,6272,19,0,0,0);
INSERT INTO File VALUES(156,156,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_6.mp3',1,1648793055,6272,19,0,0,0);
INSERT INTO File VALUES(157,157,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_7.mp3',1,1648793055,6272,19,0,0,0);
INSERT INTO File VALUES(158,158,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_8.mp3',1,1648793055,6272,19,0,0,0);
INSERT INTO File VALUES(159,159,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_9.mp3',1,1648793055,6272,19,0,0,0);
INSERT INTO File VALUES(160,160,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_10.mp3',1,1648793055,6272,19,0,0,0);
INSERT INTO File VALUES(161,161,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_1.mp3',1,1648793055,6272,20,0,0,0);
INSERT INTO File VALUES(162,162,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_2.mp3',1,1648793055,6272,20,0,0,0);
INSERT INTO File VALUES(163,163,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_3.mp3',1,1648793055,6272,20,0,0,0);
INSERT INTO File VALUES(164,164,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_4.mp3',1,1648793055,6272,20,0,0,0);
INSERT INTO File VALUES(165,165,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_5.mp3',1,1648793055,6272,20,0,0,0);
INSERT INTO File VALUES(166,166,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_6.mp3',1,1648793055,6272,20,0,0,0);
INSERT INTO File VALUES(167,167,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_7.mp3',1,1648793055,6272,20,0,0,0);
INSERT INTO File VALUES(168,168,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_8.mp3',1,1648793055,6272,20,0,0,0);
INSERT INTO File VALUES(169,169,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_9.mp3',1,1648793055,6272,20,0,0,0);
INSERT INTO File VALUES(170,170,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_10.mp3',1,1648793055,6272,20,0,0,0);
INSERT INTO File VALUES(171,171,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_1.mp3',1,1648793055,6272,21,0,0,0);
INSERT INTO File VALUES(172,172,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_2.mp3',1,1648793055,6272,21,0,0,0);
INSERT INTO File VALUES(173,173,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_3.mp3',1,1648793055,6272,21,0,0,0);
INSERT INTO File VALUES(174,174,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_4.mp3',1,1648793055,6272,21,0,0,0);
INSERT INTO File VALUES(175,175,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_5.mp3',1,1648793055,6272,21,0,0,0);
INSERT INTO File VALUES(176,176,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_6.mp3',1,1648793055,6272,21,0,0,0);
INSERT INTO File VALUES(177,177,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_7.mp3',1,1648793055,6272,21,0,0,0);
INSERT INTO File VALUES(178,178,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_8.mp3',1,1648793055,6272,21,0,0,0);
INSERT INTO File VALUES(179,179,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_9.mp3',1,1648793055,6272,21,0,0,0);
INSERT INTO File VALUES(180,180,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_10.mp3',1,1648793055,6272,21,0,0,0);
INSERT INTO File VALUES(181,181,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_1.mp3',1,1648793054,6272,22,0,0,0);
INSERT INTO File VALUES(182,182,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_2.mp3',1,1648793055,6272,22,0,0,0);
INSERT INTO File VALUES(183,183,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_3.mp3',1,1648793055,6272,22,0,0,0);
INSERT INTO File VALUES(184,184,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_4.mp3',1,1648793055,6272,22,0,0,0);
INSERT INTO File VALUES(185,185,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_5.mp3',1,1648793055,6272,22,0,0,0);
INSERT INTO File VALUES(186,186,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_6.mp3',1,1648793055,6272,22,0,0,0);
INSERT INTO File VALUES(187,187,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_7.mp3',1,1648793055,6272,22,0,0,0);
INSERT INTO File VALUES(188,188,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_8.mp3',1,1648793055,6272,22,0,0,0);
INSERT INTO File VALUES(189,189,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_9.mp3',1,1648793055,6272,22,0,0,0);
INSERT INTO File VALUES(190,190,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_10.mp3',1,1648793055,6272,22,0,0,0);
INSERT INTO File VALUES(191,191,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_1.mp3',1,1648793054,6272,23,0,0,0);
INSERT INTO File VALUES(192,192,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_2.mp3',1,1648793054,6272,23,0,0,0);
INSERT INTO File VALUES(193,193,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_3.mp3',1,1648793054,6272,23,0,0,0);
INSERT INTO File VALUES(194,194,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_4.mp3',1,1648793054,6272,23,0,0,0);
INSERT INTO File VALUES(195,195,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_5.mp3',1,1648793054,6272,23,0,0,0);
INSERT INTO File VALUES(196,196,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_6.mp3',1,1648793054,6272,23,0,0,0);
INSERT INTO File VALUES(197,197,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_7.mp3',1,1648793054,6272,23,0,0,0);
INSERT INTO File VALUES(198,198,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_8.mp3',1,1648793054,6272,23,0,0,0);
INSERT INTO File VALUES(199,199,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_9.mp3',1,1648793054,6272,23,0,0,0);
INSERT INTO File VALUES(200,200,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_10.mp3',1,1648793054,6272,23,0,0,0);
INSERT INTO File VALUES(201,201,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_1.mp3',1,1648793054,6272,25,0,0,0);
INSERT INTO File VALUES(202,202,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_2.mp3',1,1648793054,6272,25,0,0,0);
INSERT INTO File VALUES(203,203,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_3.mp3',1,1648793054,6272,25,0,0,0);
INSERT INTO File VALUES(204,204,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_4.mp3',1,1648793054,6272,25,0,0,0);
INSERT INTO File VALUES(205,205,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_5.mp3',1,1648793054,6272,25,0,0,0);
INSERT INTO File VALUES(206,206,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_6.mp3',1,1648793054,6272,25,0,0,0);
INSERT INTO File VALUES(207,207,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_7.mp3',1,1648793054,6272,25,0,0,0);
INSERT INTO File VALUES(208,208,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_8.mp3',1,1648793054,6272,25,0,0,0);
INSERT INTO File VALUES(209,209,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_9.mp3',1,1648793054,6272,25,0,0,0);
INSERT INTO File VALUES(210,210,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_10.mp3',1,1648793054,6272,25,0,0,0);
INSERT INTO File VALUES(211,211,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_1.mp3',1,1648793054,6272,26,0,0,0);
INSERT INTO File VALUES(212,212,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_2.mp3',1,1648793054,6272,26,0,0,0);
INSERT INTO File VALUES(213,213,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_3.mp3',1,1648793054,6272,26,0,0,0);
INSERT INTO File VALUES(214,214,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_4.mp3',1,1648793054,6272,26,0,0,0);
INSERT INTO File VALUES(215,215,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_5.mp3',1,1648793054,6272,26,0,0,0);
INSERT INTO File VALUES(216,216,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_6.mp3',1,1648793054,6272,26,0,0,0);
INSERT INTO File VALUES(217,217,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_7.mp3',1,1648793054,6272,26,0,0,0);
INSERT INTO File VALUES(218,218,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_8.mp3',1,1648793054,6272,26,0,0,0);
INSERT INTO File VALUES(219,219,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_9.mp3',1,1648793054,6272,26,0,0,0);
INSERT INTO File VALUES(220,220,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_10.mp3',1,1648793054,6272,26,0,0,0);
INSERT INTO File VALUES(221,221,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_1.mp3',1,1648793054,6272,27,0,0,0);
INSERT INTO File VALUES(222,222,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_2.mp3',1,1648793054,6272,27,0,0,0);
INSERT INTO File VALUES(223,223,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_3.mp3',1,1648793054,6272,27,0,0,0);
INSERT INTO File VALUES(224,224,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_4.mp3',1,1648793054,6272,27,0,0,0);
INSERT INTO File VALUES(225,225,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_5.mp3',1,1648793054,6272,27,0,0,0);
INSERT INTO File VALUES(226,226,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_6.mp3',1,1648793054,6272,27,0,0,0);
INSERT INTO File VALUES(227,227,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_7.mp3',1,1648793054,6272,27,0,0,0);
INSERT INTO File VALUES(228,228,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_8.mp3',1,1648793054,6272,27,0,0,0);
INSERT INTO File VALUES(229,229,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_9.mp3',1,1648793054,6272,27,0,0,0);
INSERT INTO File VALUES(230,230,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_10.mp3',1,1648793054,6272,27,0,0,0);
INSERT INTO File VALUES(231,231,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_1.mp3',1,1648793054,6272,28,0,0,0);
INSERT INTO File VALUES(232,232,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_2.mp3',1,1648793054,6272,28,0,0,0);
INSERT INTO File VALUES(233,233,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_3.mp3',1,1648793054,6272,28,0,0,0);
INSERT INTO File VALUES(234,234,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_4.mp3',1,1648793054,6272,28,0,0,0);
INSERT INTO File VALUES(235,235,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_5.mp3',1,1648793054,6272,28,0,0,0);
INSERT INTO File VALUES(236,236,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_6.mp3',1,1648793054,6272,28,0,0,0);
INSERT INTO File VALUES(237,237,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_7.mp3',1,1648793054,6272,28,0,0,0);
INSERT INTO File VALUES(238,238,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_8.mp3',1,1648793054,6272,28,0,0,0);
INSERT INTO File VALUES(239,239,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_9.mp3',1,1648793054,6272,28,0,0,0);
INSERT INTO File VALUES(240,240,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_10.mp3',1,1648793054,6272,28,0,0,0);
INSERT INTO File VALUES(241,241,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_1.mp3',1,1648793054,6272,29,0,0,0);
INSERT INTO File VALUES(242,242,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_2.mp3',1,1648793054,6272,29,0,0,0);
INSERT INTO File VALUES(243,243,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_3.mp3',1,1648793054,6272,29,0,0,0);
INSERT INTO File VALUES(244,244,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_4.mp3',1,1648793054,6272,29,0,0,0);
INSERT INTO File VALUES(245,245,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_5.mp3',1,1648793054,6272,29,0,0,0);
INSERT INTO File VALUES(246,246,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_6.mp3',1,1648793054,6272,29,0,0,0);
INSERT INTO File VALUES(247,247,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_7.mp3',1,1648793054,6272,29,0,0,0);
INSERT INTO File VALUES(248,248,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_8.mp3',1,1648793054,6272,29,0,0,0);
INSERT INTO File VALUES(249,249,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_9.mp3',1,1648793054,6272,29,0,0,0);
INSERT INTO File VALUES(250,250,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_10.mp3',1,1648793054,6272,29,0,0,0);
INSERT INTO File VALUES(251,251,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_1.mp3',1,1648793054,6272,30,0,0,0);
INSERT INTO File VALUES(252,252,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_2.mp3',1,1648793054,6272,30,0,0,0);
INSERT INTO File VALUES(253,253,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_3.mp3',1,1648793054,6272,30,0,0,0);
INSERT INTO File VALUES(254,254,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_4.mp3',1,1648793054,6272,30,0,0,0);
INSERT INTO File VALUES(255,255,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_5.mp3',1,1648793054,6272,30,0,0,0);
INSERT INTO File VALUES(256,256,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_6.mp3',1,1648793054,6272,30,0,0,0);
INSERT INTO File VALUES(257,257,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_7.mp3',1,1648793054,6272,30,0,0,0);
INSERT INTO File VALUES(258,258,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_8.mp3',1,1648793054,6272,30,0,0,0);
INSERT INTO File VALUES(259,259,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_9.mp3',1,1648793054,6272,30,0,0,0);
INSERT INTO File VALUES(260,260,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_10.mp3',1,1648793054,6272,30,0,0,0);
INSERT INTO File VALUES(261,261,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_1.mp3',1,1648793054,6272,31,0,0,0);
INSERT INTO File VALUES(262,262,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_2.mp3',1,1648793054,6272,31,0,0,0);
INSERT INTO File VALUES(263,263,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_3.mp3',1,1648793054,6272,31,0,0,0);
INSERT INTO File VALUES(264,264,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_4.mp3',1,1648793054,6272,31,0,0,0);
INSERT INTO File VALUES(265,265,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_5.mp3',1,1648793054,6272,31,0,0,0);
INSERT INTO File VALUES(266,266,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_6.mp3',1,1648793054,6272,31,0,0,0);
INSERT INTO File VALUES(267,267,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_7.mp3',1,1648793054,6272,31,0,0,0);
INSERT INTO File VALUES(268,268,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_8.mp3',1,1648793054,6272,31,0,0,0);
INSERT INTO File VALUES(269,269,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_9.mp3',1,1648793054,6272,31,0,0,0);
INSERT INTO File VALUES(270,270,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_10.mp3',1,1648793054,6272,31,0,0,0);
INSERT INTO File VALUES(271,271,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_1.mp3',1,1648793054,6272,32,0,0,0);
INSERT INTO File VALUES(272,272,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_2.mp3',1,1648793054,6272,32,0,0,0);
INSERT INTO File VALUES(273,273,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_3.mp3',1,1648793054,6272,32,0,0,0);
INSERT INTO File VALUES(274,274,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_4.mp3',1,1648793054,6272,32,0,0,0);
INSERT INTO File VALUES(275,275,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_5.mp3',1,1648793054,6272,32,0,0,0);
INSERT INTO File VALUES(276,276,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_6.mp3',1,1648793054,6272,32,0,0,0);
INSERT INTO File VALUES(277,277,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_7.mp3',1,1648793054,6272,32,0,0,0);
INSERT INTO File VALUES(278,278,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_8.mp3',1,1648793054,6272,32,0,0,0);
INSERT INTO File VALUES(279,279,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_9.mp3',1,1648793054,6272,32,0,0,0);
INSERT INTO File VALUES(280,280,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_10.mp3',1,1648793054,6272,32,0,0,0);
INSERT INTO File VALUES(281,281,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_1.mp3',1,1648793054,6272,33,0,0,0);
INSERT INTO File VALUES(282,282,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_2.mp3',1,1648793054,6272,33,0,0,0);
INSERT INTO File VALUES(283,283,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_3.mp3',1,1648793054,6272,33,0,0,0);
INSERT INTO File VALUES(284,284,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_4.mp3',1,1648793054,6272,33,0,0,0);
INSERT INTO File VALUES(285,285,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_5.mp3',1,1648793054,6272,33,0,0,0);
INSERT INTO File VALUES(286,286,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_6.mp3',1,1648793054,6272,33,0,0,0);
INSERT INTO File VALUES(287,287,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_7.mp3',1,1648793054,6272,33,0,0,0);
INSERT INTO File VALUES(288,288,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_8.mp3',1,1648793054,6272,33,0,0,0);
INSERT INTO File VALUES(289,289,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_9.mp3',1,1648793054,6272,33,0,0,0);
INSERT INTO File VALUES(290,290,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_10.mp3',1,1648793054,6272,33,0,0,0);
INSERT INTO File VALUES(291,291,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_1.mp3',1,1648793054,6272,34,0,0,0);
INSERT INTO File VALUES(292,292,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_2.mp3',1,1648793054,6272,34,0,0,0);
INSERT INTO File VALUES(293,293,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_3.mp3',1,1648793054,6272,34,0,0,0);
INSERT INTO File VALUES(294,294,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_4.mp3',1,1648793054,6272,34,0,0,0);
INSERT INTO File VALUES(295,295,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_5.mp3',1,1648793054,6272,34,0,0,0);
INSERT INTO File VALUES(296,296,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_6.mp3',1,1648793054,6272,34,0,0,0);
INSERT INTO File VALUES(297,297,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_7.mp3',1,1648793054,6272,34,0,0,0);
INSERT INTO File VALUES(298,298,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_8.mp3',1,1648793054,6272,34,0,0,0);
INSERT INTO File VALUES(299,299,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_9.mp3',1,1648793054,6272,34,0,0,0);
INSERT INTO File VALUES(300,300,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_10.mp3',1,1648793054,6272,34,0,0,0);
INSERT INTO File VALUES(301,301,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_1.mp3',1,1648793054,6272,36,0,0,0);
INSERT INTO File VALUES(302,302,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_2.mp3',1,1648793054,6272,36,0,0,0);
INSERT INTO File VALUES(303,303,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_3.mp3',1,1648793054,6272,36,0,0,0);
INSERT INTO File VALUES(304,304,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_4.mp3',1,1648793054,6272,36,0,0,0);
INSERT INTO File VALUES(305,305,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_5.mp3',1,1648793054,6272,36,0,0,0);
INSERT INTO File VALUES(306,306,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_6.mp3',1,1648793054,6272,36,0,0,0);
INSERT INTO File VALUES(307,307,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_7.mp3',1,1648793054,6272,36,0,0,0);
INSERT INTO File VALUES(308,308,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_8.mp3',1,1648793054,6272,36,0,0,0);
INSERT INTO File VALUES(309,309,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_9.mp3',1,1648793054,6272,36,0,0,0);
INSERT INTO File VALUES(310,310,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_10.mp3',1,1648793054,6272,36,0,0,0);
INSERT INTO File VALUES(311,311,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_1.mp3',1,1648793054,6272,37,0,0,0);
INSERT INTO File VALUES(312,312,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_2.mp3',1,1648793054,6272,37,0,0,0);
INSERT INTO File VALUES(313,313,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_3.mp3',1,1648793054,6272,37,0,0,0);
INSERT INTO File VALUES(314,314,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_4.mp3',1,1648793054,6272,37,0,0,0);
INSERT INTO File VALUES(315,315,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_5.mp3',1,1648793054,6272,37,0,0,0);
INSERT INTO File VALUES(316,316,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_6.mp3',1,1648793054,6272,37,0,0,0);
INSERT INTO File VALUES(317,317,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_7.mp3',1,1648793054,6272,37,0,0,0);
INSERT INTO File VALUES(318,318,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_8.mp3',1,1648793054,6272,37,0,0,0);
INSERT INTO File VALUES(319,319,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_9.mp3',1,1648793054,6272,37,0,0,0);
INSERT INTO File VALUES(320,320,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_10.mp3',1,1648793054,6272,37,0,0,0);
INSERT INTO File VALUES(321,321,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_1.mp3',1,1648793054,6272,38,0,0,0);
INSERT INTO File VALUES(322,322,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_2.mp3',1,1648793054,6272,38,0,0,0);
INSERT INTO File VALUES(323,323,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_3.mp3',1,1648793054,6272,38,0,0,0);
INSERT INTO File VALUES(324,324,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_4.mp3',1,1648793054,6272,38,0,0,0);
INSERT INTO File VALUES(325,325,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_5.mp3',1,1648793054,6272,38,0,0,0);
INSERT INTO File VALUES(326,326,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_6.mp3',1,1648793054,6272,38,0,0,0);
INSERT INTO File VALUES(327,327,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_7.mp3',1,1648793054,6272,38,0,0,0);
INSERT INTO File VALUES(328,328,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_8.mp3',1,1648793054,6272,38,0,0,0);
INSERT INTO File VALUES(329,329,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_9.mp3',1,1648793054,6272,38,0,0,0);
INSERT INTO File VALUES(330,330,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_10.mp3',1,1648793054,6272,38,0,0,0);
INSERT INTO File VALUES(331,331,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_1.mp3',1,1648793054,6272,39,0,0,0);
INSERT INTO File VALUES(332,332,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_2.mp3',1,1648793054,6272,39,0,0,0);
INSERT INTO File VALUES(333,333,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_3.mp3',1,1648793054,6272,39,0,0,0);
INSERT INTO File VALUES(334,334,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_4.mp3',1,1648793054,6272,39,0,0,0);
INSERT INTO File VALUES(335,335,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_5.mp3',1,1648793054,6272,39,0,0,0);
INSERT INTO File VALUES(336,336,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_6.mp3',1,1648793054,6272,39,0,0,0);
INSERT INTO File VALUES(337,337,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_7.mp3',1,1648793054,6272,39,0,0,0);
INSERT INTO File VALUES(338,338,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_8.mp3',1,1648793054,6272,39,0,0,0);
INSERT INTO File VALUES(339,339,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_9.mp3',1,1648793054,6272,39,0,0,0);
INSERT INTO File VALUES(340,340,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_10.mp3',1,1648793054,6272,39,0,0,0);
INSERT INTO File VALUES(341,341,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_1.mp3',1,1648793054,6272,40,0,0,0);
INSERT INTO File VALUES(342,342,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_2.mp3',1,1648793054,6272,40,0,0,0);
INSERT INTO File VALUES(343,343,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_3.mp3',1,1648793054,6272,40,0,0,0);
INSERT INTO File VALUES(344,344,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_4.mp3',1,1648793054,6272,40,0,0,0);
INSERT INTO File VALUES(345,345,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_5.mp3',1,1648793054,6272,40,0,0,0);
INSERT INTO File VALUES(346,346,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_6.mp3',1,1648793054,6272,40,0,0,0);
INSERT INTO File VALUES(347,347,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_7.mp3',1,1648793054,6272,40,0,0,0);
INSERT INTO File VALUES(348,348,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_8.mp3',1,1648793054,6272,40,0,0,0);
INSERT INTO File VALUES(349,349,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_9.mp3',1,1648793054,6272,40,0,0,0);
INSERT INTO File VALUES(350,350,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_10.mp3',1,1648793054,6272,40,0,0,0);
INSERT INTO File VALUES(351,351,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_1.mp3',1,1648793054,6272,41,0,0,0);
INSERT INTO File VALUES(352,352,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_2.mp3',1,1648793054,6272,41,0,0,0);
INSERT INTO File VALUES(353,353,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_3.mp3',1,1648793054,6272,41,0,0,0);
INSERT INTO File VALUES(354,354,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_4.mp3',1,1648793054,6272,41,0,0,0);
INSERT INTO File VALUES(355,355,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_5.mp3',1,1648793054,6272,41,0,0,0);
INSERT INTO File VALUES(356,356,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_6.mp3',1,1648793054,6272,41,0,0,0);
INSERT INTO File VALUES(357,357,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_7.mp3',1,1648793054,6272,41,0,0,0);
INSERT INTO File VALUES(358,358,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_8.mp3',1,1648793054,6272,41,0,0,0);
INSERT INTO File VALUES(359,359,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_9.mp3',1,1648793054,6272,41,0,0,0);
INSERT INTO File VALUES(360,360,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_10.mp3',1,1648793054,6272,41,0,0,0);
INSERT INTO File VALUES(361,361,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_1.mp3',1,1648793053,6272,42,0,0,0);
INSERT INTO File VALUES(362,362,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_2.mp3',1,1648793053,6272,42,0,0,0);
INSERT INTO File VALUES(363,363,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_3.mp3',1,1648793053,6272,42,0,0,0);
INSERT INTO File VALUES(364,364,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_4.mp3',1,1648793053,6272,42,0,0,0);
INSERT INTO File VALUES(365,365,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_5.mp3',1,1648793053,6272,42,0,0,0);
INSERT INTO File VALUES(366,366,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_6.mp3',1,1648793053,6272,42,0,0,0);
INSERT INTO File VALUES(367,367,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_7.mp3',1,1648793053,6272,42,0,0,0);
INSERT INTO File VALUES(368,368,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_8.mp3',1,1648793053,6272,42,0,0,0);
INSERT INTO File VALUES(369,369,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_9.mp3',1,1648793053,6272,42,0,0,0);
INSERT INTO File VALUES(370,370,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_10.mp3',1,1648793053,6272,42,0,0,0);
INSERT INTO File VALUES(371,371,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_1.mp3',1,1648793053,6272,43,0,0,0);
INSERT INTO File VALUES(372,372,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_2.mp3',1,1648793053,6272,43,0,0,0);
INSERT INTO File VALUES(373,373,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_3.mp3',1,1648793053,6272,43,0,0,0);
INSERT INTO File VALUES(374,374,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_4.mp3',1,1648793053,6272,43,0,0,0);
INSERT INTO File VALUES(375,375,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_5.mp3',1,1648793053,6272,43,0,0,0);
INSERT INTO File VALUES(376,376,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_6.mp3',1,1648793053,6272,43,0,0,0);
INSERT INTO File VALUES(377,377,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_7.mp3',1,1648793053,6272,43,0,0,0);
INSERT INTO File VALUES(378,378,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_8.mp3',1,1648793053,6272,43,0,0,0);
INSERT INTO File VALUES(379,379,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_9.mp3',1,1648793053,6272,43,0,0,0);
INSERT INTO File VALUES(380,380,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_10.mp3',1,1648793053,6272,43,0,0,0);
INSERT INTO File VALUES(381,381,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_1.mp3',1,1648793053,6272,44,0,0,0);
INSERT INTO File VALUES(382,382,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_2.mp3',1,1648793053,6272,44,0,0,0);
INSERT INTO File VALUES(383,383,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_3.mp3',1,1648793053,6272,44,0,0,0);
INSERT INTO File VALUES(384,384,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_4.mp3',1,1648793053,6272,44,0,0,0);
INSERT INTO File VALUES(385,385,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_5.mp3',1,1648793053,6272,44,0,0,0);
INSERT INTO File VALUES(386,386,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_6.mp3',1,1648793053,6272,44,0,0,0);
INSERT INTO File VALUES(387,387,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_7.mp3',1,1648793053,6272,44,0,0,0);
INSERT INTO File VALUES(388,388,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_8.mp3',1,1648793053,6272,44,0,0,0);
INSERT INTO File VALUES(389,389,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_9.mp3',1,1648793053,6272,44,0,0,0);
INSERT INTO File VALUES(390,390,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_10.mp3',1,1648793053,6272,44,0,0,0);
INSERT INTO File VALUES(391,391,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_1.mp3',1,1648793053,6272,45,0,0,0);
INSERT INTO File VALUES(392,392,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_2.mp3',1,1648793053,6272,45,0,0,0);
INSERT INTO File VALUES(393,393,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_3.mp3',1,1648793053,6272,45,0,0,0);
INSERT INTO File VALUES(394,394,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_4.mp3',1,1648793053,6272,45,0,0,0);
INSERT INTO File VALUES(395,395,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_5.mp3',1,1648793053,6272,45,0,0,0);
INSERT INTO File VALUES(396,396,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_6.mp3',1,1648793053,6272,45,0,0,0);
INSERT INTO File VALUES(397,397,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_7.mp3',1,1648793053,6272,45,0,0,0);
INSERT INTO File VALUES(398,398,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_8.mp3',1,1648793053,6272,45,0,0,0);
INSERT INTO File VALUES(399,399,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_9.mp3',1,1648793053,6272,45,0,0,0);
INSERT INTO File VALUES(400,400,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_10.mp3',1,1648793053,6272,45,0,0,0);
INSERT INTO File VALUES(401,401,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_1.mp3',1,1648793053,6272,47,0,0,0);
INSERT INTO File VALUES(402,402,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_2.mp3',1,1648793053,6272,47,0,0,0);
INSERT INTO File VALUES(403,403,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_3.mp3',1,1648793053,6272,47,0,0,0);
INSERT INTO File VALUES(404,404,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_4.mp3',1,1648793053,6272,47,0,0,0);
INSERT INTO File VALUES(405,405,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_5.mp3',1,1648793053,6272,47,0,0,0);
INSERT INTO File VALUES(406,406,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_6.mp3',1,1648793053,6272,47,0,0,0);
INSERT INTO File VALUES(407,407,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_7.mp3',1,1648793053,6272,47,0,0,0);
INSERT INTO File VALUES(408,408,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_8.mp3',1,1648793053,6272,47,0,0,0);
INSERT INTO File VALUES(409,409,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_9.mp3',1,1648793053,6272,47,0,0,0);
INSERT INTO File VALUES(410,410,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_10.mp3',1,1648793053,6272,47,0,0,0);
INSERT INTO File VALUES(411,411,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_1.mp3',1,1648793053,6272,48,0,0,0);
INSERT INTO File VALUES(412,412,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_2.mp3',1,1648793053,6272,48,0,0,0);
INSERT INTO File VALUES(413,413,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_3.mp3',1,1648793053,6272,48,0,0,0);
INSERT INTO File VALUES(414,414,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_4.mp3',1,1648793053,6272,48,0,0,0);
INSERT INTO File VALUES(415,415,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_5.mp3',1,1648793053,6272,48,0,0,0);
INSERT INTO File VALUES(416,416,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_6.mp3',1,1648793053,6272,48,0,0,0);
INSERT INTO File VALUES(417,417,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_7.mp3',1,1648793053,6272,48,0,0,0);
INSERT INTO File VALUES(418,418,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_8.mp3',1,1648793053,6272,48,0,0,0);
INSERT INTO File VALUES(419,419,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_9.mp3',1,1648793053,6272,48,0,0,0);
INSERT INTO File VALUES(420,420,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_10.mp3',1,1648793053,6272,48,0,0,0);
INSERT INTO File VALUES(421,421,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_1.mp3',1,1648793053,6272,49,0,0,0);
INSERT INTO File VALUES(422,422,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_2.mp3',1,1648793053,6272,49,0,0,0);
INSERT INTO File VALUES(423,423,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_3.mp3',1,1648793053,6272,49,0,0,0);
INSERT INTO File VALUES(424,424,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_4.mp3',1,1648793053,6272,49,0,0,0);
INSERT INTO File VALUES(425,425,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_5.mp3',1,1648793053,6272,49,0,0,0);
INSERT INTO File VALUES(426,426,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_6.mp3',1,1648793053,6272,49,0,0,0);
INSERT INTO File VALUES(427,427,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_7.mp3',1,1648793053,6272,49,0,0,0);
INSERT INTO File VALUES(428,428,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_8.mp3',1,1648793053,6272,49,0,0,0);
INSERT INTO File VALUES(429,429,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_9.mp3',1,1648793053,6272,49,0,0,0);
INSERT INTO File VALUES(430,430,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_10.mp3',1,1648793053,6272,49,0,0,0);
INSERT INTO File VALUES(431,431,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_1.mp3',1,1648793053,6272,50,0,0,0);
INSERT INTO File VALUES(432,432,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_2.mp3',1,1648793053,6272,50,0,0,0);
INSERT INTO File VALUES(433,433,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_3.mp3',1,1648793053,6272,50,0,0,0);
INSERT INTO File VALUES(434,434,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_4.mp3',1,1648793053,6272,50,0,0,0);
INSERT INTO File VALUES(435,435,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_5.mp3',1,1648793053,6272,50,0,0,0);
INSERT INTO File VALUES(436,436,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_6.mp3',1,1648793053,6272,50,0,0,0);
INSERT INTO File VALUES(437,437,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_7.mp3',1,1648793053,6272,50,0,0,0);
INSERT INTO File VALUES(438,438,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_8.mp3',1,1648793053,6272,50,0,0,0);
INSERT INTO File VALUES(439,439,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_9.mp3',1,1648793053,6272,50,0,0,0);
INSERT INTO File VALUES(440,440,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_10.mp3',1,1648793053,6272,50,0,0,0);
INSERT INTO File VALUES(441,441,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_1.mp3',1,1648793053,6272,51,0,0,0);
INSERT INTO File VALUES(442,442,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_2.mp3',1,1648793053,6272,51,0,0,0);
INSERT INTO File VALUES(443,443,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_3.mp3',1,1648793053,6272,51,0,0,0);
INSERT INTO File VALUES(444,444,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_4.mp3',1,1648793053,6272,51,0,0,0);
INSERT INTO File VALUES(445,445,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_5.mp3',1,1648793053,6272,51,0,0,0);
INSERT INTO File VALUES(446,446,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_6.mp3',1,1648793053,6272,51,0,0,0);
INSERT INTO File VALUES(447,447,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_7.mp3',1,1648793053,6272,51,0,0,0);
INSERT INTO File VALUES(448,448,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_8.mp3',1,1648793053,6272,51,0,0,0);
INSERT INTO File VALUES(449,449,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_9.mp3',1,1648793053,6272,51,0,0,0);
INSERT INTO File VALUES(450,450,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_10.mp3',1,1648793053,6272,51,0,0,0);
INSERT INTO File VALUES(451,451,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_1.mp3',1,1648793053,6272,52,0,0,0);
INSERT INTO File VALUES(452,452,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_2.mp3',1,1648793053,6272,52,0,0,0);
INSERT INTO File VALUES(453,453,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_3.mp3',1,1648793053,6272,52,0,0,0);
INSERT INTO File VALUES(454,454,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_4.mp3',1,1648793053,6272,52,0,0,0);
INSERT INTO File VALUES(455,455,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_5.mp3',1,1648793053,6272,52,0,0,0);
INSERT INTO File VALUES(456,456,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_6.mp3',1,1648793053,6272,52,0,0,0);
INSERT INTO File VALUES(457,457,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_7.mp3',1,1648793053,6272,52,0,0,0);
INSERT INTO File VALUES(458,458,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_8.mp3',1,1648793053,6272,52,0,0,0);
INSERT INTO File VALUES(459,459,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_9.mp3',1,1648793053,6272,52,0,0,0);
INSERT INTO File VALUES(460,460,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_10.mp3',1,1648793053,6272,52,0,0,0);
INSERT INTO File VALUES(461,461,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_1.mp3',1,1648793053,6272,53,0,0,0);
INSERT INTO File VALUES(462,462,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_2.mp3',1,1648793053,6272,53,0,0,0);
INSERT INTO File VALUES(463,463,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_3.mp3',1,1648793053,6272,53,0,0,0);
INSERT INTO File VALUES(464,464,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_4.mp3',1,1648793053,6272,53,0,0,0);
INSERT INTO File VALUES(465,465,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_5.mp3',1,1648793053,6272,53,0,0,0);
INSERT INTO File VALUES(466,466,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_6.mp3',1,1648793053,6272,53,0,0,0);
INSERT INTO File VALUES(467,467,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_7.mp3',1,1648793053,6272,53,0,0,0);
INSERT INTO File VALUES(468,468,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_8.mp3',1,1648793053,6272,53,0,0,0);
INSERT INTO File VALUES(469,469,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_9.mp3',1,1648793053,6272,53,0,0,0);
INSERT INTO File VALUES(470,470,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_10.mp3',1,1648793053,6272,53,0,0,0);
INSERT INTO File VALUES(471,471,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_1.mp3',1,1648793053,6272,54,0,0,0);
INSERT INTO File VALUES(472,472,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_2.mp3',1,1648793053,6272,54,0,0,0);
INSERT INTO File VALUES(473,473,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_3.mp3',1,1648793053,6272,54,0,0,0);
INSERT INTO File VALUES(474,474,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_4.mp3',1,1648793053,6272,54,0,0,0);
INSERT INTO File VALUES(475,475,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_5.mp3',1,1648793053,6272,54,0,0,0);
INSERT INTO File VALUES(476,476,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_6.mp3',1,1648793053,6272,54,0,0,0);
INSERT INTO File VALUES(477,477,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_7.mp3',1,1648793053,6272,54,0,0,0);
INSERT INTO File VALUES(478,478,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_8.mp3',1,1648793053,6272,54,0,0,0);
INSERT INTO File VALUES(479,479,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_9.mp3',1,1648793053,6272,54,0,0,0);
INSERT INTO File VALUES(480,480,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_10.mp3',1,1648793053,6272,54,0,0,0);
INSERT INTO File VALUES(481,481,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_1.mp3',1,1648793053,6272,55,0,0,0);
INSERT INTO File VALUES(482,482,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_2.mp3',1,1648793053,6272,55,0,0,0);
INSERT INTO File VALUES(483,483,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_3.mp3',1,1648793053,6272,55,0,0,0);
INSERT INTO File VALUES(484,484,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_4.mp3',1,1648793053,6272,55,0,0,0);
INSERT INTO File VALUES(485,485,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_5.mp3',1,1648793053,6272,55,0,0,0);
INSERT INTO File VALUES(486,486,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_6.mp3',1,1648793053,6272,55,0,0,0);
INSERT INTO File VALUES(487,487,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_7.mp3',1,1648793053,6272,55,0,0,0);
INSERT INTO File VALUES(488,488,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_8.mp3',1,1648793053,6272,55,0,0,0);
INSERT INTO File VALUES(489,489,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_9.mp3',1,1648793053,6272,55,0,0,0);
INSERT INTO File VALUES(490,490,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_10.mp3',1,1648793053,6272,55,0,0,0);
INSERT INTO File VALUES(491,491,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_1.mp3',1,1648793053,6272,56,0,0,0);
INSERT INTO File VALUES(492,492,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_2.mp3',1,1648793053,6272,56,0,0,0);
INSERT INTO File VALUES(493,493,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_3.mp3',1,1648793053,6272,56,0,0,0);
INSERT INTO File VALUES(494,494,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_4.mp3',1,1648793053,6272,56,0,0,0);
INSERT INTO File VALUES(495,495,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_5.mp3',1,1648793053,6272,56,0,0,0);
INSERT INTO File VALUES(496,496,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_6.mp3',1,1648793053,6272,56,0,0,0);
INSERT INTO File VALUES(497,497,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_7.mp3',1,1648793053,6272,56,0,0,0);
INSERT INTO File VALUES(498,498,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_8.mp3',1,1648793053,6272,56,0,0,0);
INSERT INTO File VALUES(499,499,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_9.mp3',1,1648793053,6272,56,0,0,0);
INSERT INTO File VALUES(500,500,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_10.mp3',1,1648793053,6272,56,0,0,0);
INSERT INTO File VALUES(501,501,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_1.mp3',1,1648793053,6272,58,0,0,0);
INSERT INTO File VALUES(502,502,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_2.mp3',1,1648793053,6272,58,0,0,0);
INSERT INTO File VALUES(503,503,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_3.mp3',1,1648793053,6272,58,0,0,0);
INSERT INTO File VALUES(504,504,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_4.mp3',1,1648793053,6272,58,0,0,0);
INSERT INTO File VALUES(505,505,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_5.mp3',1,1648793053,6272,58,0,0,0);
INSERT INTO File VALUES(506,506,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_6.mp3',1,1648793053,6272,58,0,0,0);
INSERT INTO File VALUES(507,507,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_7.mp3',1,1648793053,6272,58,0,0,0);
INSERT INTO File VALUES(508,508,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_8.mp3',1,1648793053,6272,58,0,0,0);
INSERT INTO File VALUES(509,509,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_9.mp3',1,1648793053,6272,58,0,0,0);
INSERT INTO File VALUES(510,510,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_10.mp3',1,1648793053,6272,58,0,0,0);
INSERT INTO File VALUES(511,511,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_1.mp3',1,1648793053,6272,59,0,0,0);
INSERT INTO File VALUES(512,512,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_2.mp3',1,1648793053,6272,59,0,0,0);
INSERT INTO File VALUES(513,513,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_3.mp3',1,1648793053,6272,59,0,0,0);
INSERT INTO File VALUES(514,514,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_4.mp3',1,1648793053,6272,59,0,0,0);
INSERT INTO File VALUES(515,515,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_5.mp3',1,1648793053,6272,59,0,0,0);
INSERT INTO File VALUES(516,516,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_6.mp3',1,1648793053,6272,59,0,0,0);
INSERT INTO File VALUES(517,517,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_7.mp3',1,1648793053,6272,59,0,0,0);
INSERT INTO File VALUES(518,518,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_8.mp3',1,1648793053,6272,59,0,0,0);
INSERT INTO File VALUES(519,519,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_9.mp3',1,1648793053,6272,59,0,0,0);
INSERT INTO File VALUES(520,520,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_10.mp3',1,1648793053,6272,59,0,0,0);
INSERT INTO File VALUES(521,521,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_1.mp3',1,1648793053,6272,60,0,0,0);
INSERT INTO File VALUES(522,522,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_2.mp3',1,1648793053,6272,60,0,0,0);
INSERT INTO File VALUES(523,523,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_3.mp3',1,1648793053,6272,60,0,0,0);
INSERT INTO File VALUES(524,524,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_4.mp3',1,1648793053,6272,60,0,0,0);
INSERT INTO File VALUES(525,525,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_5.mp3',1,1648793053,6272,60,0,0,0);
INSERT INTO File VALUES(526,526,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_6.mp3',1,1648793053,6272,60,0,0,0);
INSERT INTO File VALUES(527,527,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_7.mp3',1,1648793053,6272,60,0,0,0);
INSERT INTO File VALUES(528,528,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_8.mp3',1,1648793053,6272,60,0,0,0);
INSERT INTO File VALUES(529,529,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_9.mp3',1,1648793053,6272,60,0,0,0);
INSERT INTO File VALUES(530,530,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_10.mp3',1,1648793053,6272,60,0,0,0);
INSERT INTO File VALUES(531,531,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_1.mp3',1,1648793052,6272,61,0,0,0);
INSERT INTO File VALUES(532,532,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_2.mp3',1,1648793052,6272,61,0,0,0);
INSERT INTO File VALUES(533,533,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_3.mp3',1,1648793052,6272,61,0,0,0);
INSERT INTO File VALUES(534,534,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_4.mp3',1,1648793052,6272,61,0,0,0);
INSERT INTO File VALUES(535,535,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_5.mp3',1,1648793052,6272,61,0,0,0);
INSERT INTO File VALUES(536,536,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_6.mp3',1,1648793052,6272,61,0,0,0);
INSERT INTO File VALUES(537,537,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_7.mp3',1,1648793052,6272,61,0,0,0);
INSERT INTO File VALUES(538,538,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_8.mp3',1,1648793052,6272,61,0,0,0);
INSERT INTO File VALUES(539,539,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_9.mp3',1,1648793052,6272,61,0,0,0);
INSERT INTO File VALUES(540,540,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_10.mp3',1,1648793052,6272,61,0,0,0);
INSERT INTO File VALUES(541,541,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_1.mp3',1,1648793052,6272,62,0,0,0);
INSERT INTO File VALUES(542,542,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_2.mp3',1,1648793052,6272,62,0,0,0);
INSERT INTO File VALUES(543,543,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_3.mp3',1,1648793052,6272,62,0,0,0);
INSERT INTO File VALUES(544,544,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_4.mp3',1,1648793052,6272,62,0,0,0);
INSERT INTO File VALUES(545,545,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_5.mp3',1,1648793052,6272,62,0,0,0);
INSERT INTO File VALUES(546,546,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_6.mp3',1,1648793052,6272,62,0,0,0);
INSERT INTO File VALUES(547,547,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_7.mp3',1,1648793052,6272,62,0,0,0);
INSERT INTO File VALUES(548,548,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_8.mp3',1,1648793052,6272,62,0,0,0);
INSERT INTO File VALUES(549,549,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_9.mp3',1,1648793052,6272,62,0,0,0);
INSERT INTO File VALUES(550,550,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_10.mp3',1,1648793052,6272,62,0,0,0);
INSERT INTO File VALUES(551,551,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_1.mp3',1,1648793052,6272,63,0,0,0);
INSERT INTO File VALUES(552,552,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_2.mp3',1,1648793052,6272,63,0,0,0);
INSERT INTO File VALUES(553,553,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_3.mp3',1,1648793052,6272,63,0,0,0);
INSERT INTO File VALUES(554,554,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_4.mp3',1,1648793052,6272,63,0,0,0);
INSERT INTO File VALUES(555,555,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_5.mp3',1,1648793052,6272,63,0,0,0);
INSERT INTO File VALUES(556,556,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_6.mp3',1,1648793052,6272,63,0,0,0);
INSERT INTO File VALUES(557,557,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_7.mp3',1,1648793052,6272,63,0,0,0);
INSERT INTO File VALUES(558,558,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_8.mp3',1,1648793052,6272,63,0,0,0);
INSERT INTO File VALUES(559,559,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_9.mp3',1,1648793052,6272,63,0,0,0);
INSERT INTO File VALUES(560,560,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_10.mp3',1,1648793052,6272,63,0,0,0);
INSERT INTO File VALUES(561,561,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_1.mp3',1,1648793052,6272,64,0,0,0);
INSERT INTO File VALUES(562,562,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_2.mp3',1,1648793052,6272,64,0,0,0);
INSERT INTO File VALUES(563,563,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_3.mp3',1,1648793052,6272,64,0,0,0);
INSERT INTO File VALUES(564,564,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_4.mp3',1,1648793052,6272,64,0,0,0);
INSERT INTO File VALUES(565,565,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_5.mp3',1,1648793052,6272,64,0,0,0);
INSERT INTO File VALUES(566,566,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_6.mp3',1,1648793052,6272,64,0,0,0);
INSERT INTO File VALUES(567,567,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_7.mp3',1,1648793052,6272,64,0,0,0);
INSERT INTO File VALUES(568,568,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_8.mp3',1,1648793052,6272,64,0,0,0);
INSERT INTO File VALUES(569,569,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_9.mp3',1,1648793052,6272,64,0,0,0);
INSERT INTO File VALUES(570,570,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_10.mp3',1,1648793052,6272,64,0,0,0);
INSERT INTO File VALUES(571,571,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_1.mp3',1,1648793052,6272,65,0,0,0);
INSERT INTO File VALUES(572,572,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_2.mp3',1,1648793052,6272,65,0,0,0);
INSERT INTO File VALUES(573,573,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_3.mp3',1,1648793052,6272,65,0,0,0);
INSERT INTO File VALUES(574,574,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_4.mp3',1,1648793052,6272,65,0,0,0);
INSERT INTO File VALUES(575,575,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_5.mp3',1,1648793052,6272,65,0,0,0);
INSERT INTO File VALUES(576,576,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_6.mp3',1,1648793052,6272,65,0,0,0);
INSERT INTO File VALUES(577,577,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_7.mp3',1,1648793052,6272,65,0,0,0);
INSERT INTO File VALUES(578,578,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_8.mp3',1,1648793052,6272,65,0,0,0);
INSERT INTO File VALUES(579,579,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_9.mp3',1,1648793052,6272,65,0,0,0);
INSERT INTO File VALUES(580,580,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_10.mp3',1,1648793052,6272,65,0,0,0);
INSERT INTO File VALUES(581,581,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_1.mp3',1,1648793052,6272,66,0,0,0);
INSERT INTO File VALUES(582,582,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_2.mp3',1,1648793052,6272,66,0,0,0);
INSERT INTO File VALUES(583,583,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_3.mp3',1,1648793052,6272,66,0,0,0);
INSERT INTO File VALUES(584,584,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_4.mp3',1,1648793052,6272,66,0,0,0);
INSERT INTO File VALUES(585,585,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_5.mp3',1,1648793052,6272,66,0,0,0);
INSERT INTO File VALUES(586,586,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_6.mp3',1,1648793052,6272,66,0,0,0);
INSERT INTO File VALUES(587,587,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_7.mp3',1,1648793052,6272,66,0,0,0);
INSERT INTO File VALUES(588,588,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_8.mp3',1,1648793052,6272,66,0,0,0);
INSERT INTO File VALUES(589,589,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_9.mp3',1,1648793052,6272,66,0,0,0);
INSERT INTO File VALUES(590,590,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_10.mp3',1,1648793052,6272,66,0,0,0);
INSERT INTO File VALUES(591,591,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_1.mp3',1,1648793052,6272,67,0,0,0);
INSERT INTO File VALUES(592,592,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_2.mp3',1,1648793052,6272,67,0,0,0);
INSERT INTO File VALUES(593,593,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_3.mp3',1,1648793052,6272,67,0,0,0);
INSERT INTO File VALUES(594,594,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_4.mp3',1,1648793052,6272,67,0,0,0);
INSERT INTO File VALUES(595,595,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_5.mp3',1,1648793052,6272,67,0,0,0);
INSERT INTO File VALUES(596,596,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_6.mp3',1,1648793052,6272,67,0,0,0);
INSERT INTO File VALUES(597,597,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_7.mp3',1,1648793052,6272,67,0,0,0);
INSERT INTO File VALUES(598,598,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_8.mp3',1,1648793052,6272,67,0,0,0);
INSERT INTO File VALUES(599,599,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_9.mp3',1,1648793052,6272,67,0,0,0);
INSERT INTO File VALUES(600,600,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_10.mp3',1,1648793052,6272,67,0,0,0);
INSERT INTO File VALUES(601,601,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_1.mp3',1,1648793052,6272,69,0,0,0);
INSERT INTO File VALUES(602,602,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_2.mp3',1,1648793052,6272,69,0,0,0);
INSERT INTO File VALUES(603,603,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_3.mp3',1,1648793052,6272,69,0,0,0);
INSERT INTO File VALUES(604,604,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_4.mp3',1,1648793052,6272,69,0,0,0);
INSERT INTO File VALUES(605,605,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_5.mp3',1,1648793052,6272,69,0,0,0);
INSERT INTO File VALUES(606,606,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_6.mp3',1,1648793052,6272,69,0,0,0);
INSERT INTO File VALUES(607,607,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_7.mp3',1,1648793052,6272,69,0,0,0);
INSERT INTO File VALUES(608,608,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_8.mp3',1,1648793052,6272,69,0,0,0);
INSERT INTO File VALUES(609,609,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_9.mp3',1,1648793052,6272,69,0,0,0);
INSERT INTO File VALUES(610,610,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_10.mp3',1,1648793052,6272,69,0,0,0);
INSERT INTO File VALUES(611,611,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_1.mp3',1,1648793052,6272,70,0,0,0);
INSERT INTO File VALUES(612,612,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_2.mp3',1,1648793052,6272,70,0,0,0);
INSERT INTO File VALUES(613,613,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_3.mp3',1,1648793052,6272,70,0,0,0);
INSERT INTO File VALUES(614,614,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_4.mp3',1,1648793052,6272,70,0,0,0);
INSERT INTO File VALUES(615,615,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_5.mp3',1,1648793052,6272,70,0,0,0);
INSERT INTO File VALUES(616,616,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_6.mp3',1,1648793052,6272,70,0,0,0);
INSERT INTO File VALUES(617,617,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_7.mp3',1,1648793052,6272,70,0,0,0);
INSERT INTO File VALUES(618,618,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_8.mp3',1,1648793052,6272,70,0,0,0);
INSERT INTO File VALUES(619,619,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_9.mp3',1,1648793052,6272,70,0,0,0);
INSERT INTO File VALUES(620,620,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_10.mp3',1,1648793052,6272,70,0,0,0);
INSERT INTO File VALUES(621,621,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_1.mp3',1,1648793052,6272,71,0,0,0);
INSERT INTO File VALUES(622,622,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_2.mp3',1,1648793052,6272,71,0,0,0);
INSERT INTO File VALUES(623,623,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_3.mp3',1,1648793052,6272,71,0,0,0);
INSERT INTO File VALUES(624,624,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_4.mp3',1,1648793052,6272,71,0,0,0);
INSERT INTO File VALUES(625,625,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_5.mp3',1,1648793052,6272,71,0,0,0);
INSERT INTO File VALUES(626,626,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_6.mp3',1,1648793052,6272,71,0,0,0);
INSERT INTO File VALUES(627,627,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_7.mp3',1,1648793052,6272,71,0,0,0);
INSERT INTO File VALUES(628,628,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_8.mp3',1,1648793052,6272,71,0,0,0);
INSERT INTO File VALUES(629,629,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_9.mp3',1,1648793052,6272,71,0,0,0);
INSERT INTO File VALUES(630,630,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_10.mp3',1,1648793052,6272,71,0,0,0);
INSERT INTO File VALUES(631,631,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_1.mp3',1,1648793052,6272,72,0,0,0);
INSERT INTO File VALUES(632,632,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_2.mp3',1,1648793052,6272,72,0,0,0);
INSERT INTO File VALUES(633,633,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_3.mp3',1,1648793052,6272,72,0,0,0);
INSERT INTO File VALUES(634,634,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_4.mp3',1,1648793052,6272,72,0,0,0);
INSERT INTO File VALUES(635,635,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_5.mp3',1,1648793052,6272,72,0,0,0);
INSERT INTO File VALUES(636,636,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_6.mp3',1,1648793052,6272,72,0,0,0);
INSERT INTO File VALUES(637,637,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_7.mp3',1,1648793052,6272,72,0,0,0);
INSERT INTO File VALUES(638,638,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_8.mp3',1,1648793052,6272,72,0,0,0);
INSERT INTO File VALUES(639,639,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_9.mp3',1,1648793052,6272,72,0,0,0);
INSERT INTO File VALUES(640,640,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_10.mp3',1,1648793052,6272,72,0,0,0);
INSERT INTO File VALUES(641,641,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_1.mp3',1,1648793052,6272,73,0,0,0);
INSERT INTO File VALUES(642,642,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_2.mp3',1,1648793052,6272,73,0,0,0);
INSERT INTO File VALUES(643,643,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_3.mp3',1,1648793052,6272,73,0,0,0);
INSERT INTO File VALUES(644,644,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_4.mp3',1,1648793052,6272,73,0,0,0);
INSERT INTO File VALUES(645,645,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_5.mp3',1,1648793052,6272,73,0,0,0);
INSERT INTO File VALUES(646,646,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_6.mp3',1,1648793052,6272,73,0,0,0);
INSERT INTO File VALUES(647,647,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_7.mp3',1,1648793052,6272,73,0,0,0);
INSERT INTO File VALUES(648,648,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_8.mp3',1,1648793052,6272,73,0,0,0);
INSERT INTO File VALUES(649,649,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_9.mp3',1,1648793052,6272,73,0,0,0);
INSERT INTO File VALUES(650,650,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_10.mp3',1,1648793052,6272,73,0,0,0);
INSERT INTO File VALUES(651,651,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_1.mp3',1,1648793052,6272,74,0,0,0);
INSERT INTO File VALUES(652,652,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_2.mp3',1,1648793052,6272,74,0,0,0);
INSERT INTO File VALUES(653,653,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_3.mp3',1,1648793052,6272,74,0,0,0);
INSERT INTO File VALUES(654,654,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_4.mp3',1,1648793052,6272,74,0,0,0);
INSERT INTO File VALUES(655,655,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_5.mp3',1,1648793052,6272,74,0,0,0);
INSERT INTO File VALUES(656,656,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_6.mp3',1,1648793052,6272,74,0,0,0);
INSERT INTO File VALUES(657,657,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_7.mp3',1,1648793052,6272,74,0,0,0);
INSERT INTO File VALUES(658,658,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_8.mp3',1,1648793052,6272,74,0,0,0);
INSERT INTO File VALUES(659,659,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_9.mp3',1,1648793052,6272,74,0,0,0);
INSERT INTO File VALUES(660,660,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_10.mp3',1,1648793052,6272,74,0,0,0);
INSERT INTO File VALUES(661,661,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_1.mp3',1,1648793052,6272,75,0,0,0);
INSERT INTO File VALUES(662,662,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_2.mp3',1,1648793052,6272,75,0,0,0);
INSERT INTO File VALUES(663,663,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_3.mp3',1,1648793052,6272,75,0,0,0);
INSERT INTO File VALUES(664,664,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_4.mp3',1,1648793052,6272,75,0,0,0);
INSERT INTO File VALUES(665,665,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_5.mp3',1,1648793052,6272,75,0,0,0);
INSERT INTO File VALUES(666,666,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_6.mp3',1,1648793052,6272,75,0,0,0);
INSERT INTO File VALUES(667,667,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_7.mp3',1,1648793052,6272,75,0,0,0);
INSERT INTO File VALUES(668,668,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_8.mp3',1,1648793052,6272,75,0,0,0);
INSERT INTO File VALUES(669,669,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_9.mp3',1,1648793052,6272,75,0,0,0);
INSERT INTO File VALUES(670,670,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_10.mp3',1,1648793052,6272,75,0,0,0);
INSERT INTO File VALUES(671,671,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_1.mp3',1,1648793052,6272,76,0,0,0);
INSERT INTO File VALUES(672,672,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_2.mp3',1,1648793052,6272,76,0,0,0);
INSERT INTO File VALUES(673,673,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_3.mp3',1,1648793052,6272,76,0,0,0);
INSERT INTO File VALUES(674,674,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_4.mp3',1,1648793052,6272,76,0,0,0);
INSERT INTO File VALUES(675,675,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_5.mp3',1,1648793052,6272,76,0,0,0);
INSERT INTO File VALUES(676,676,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_6.mp3',1,1648793052,6272,76,0,0,0);
INSERT INTO File VALUES(677,677,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_7.mp3',1,1648793052,6272,76,0,0,0);
INSERT INTO File VALUES(678,678,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_8.mp3',1,1648793052,6272,76,0,0,0);
INSERT INTO File VALUES(679,679,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_9.mp3',1,1648793052,6272,76,0,0,0);
INSERT INTO File VALUES(680,680,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_10.mp3',1,1648793052,6272,76,0,0,0);
INSERT INTO File VALUES(681,681,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_1.mp3',1,1648793052,6272,77,0,0,0);
INSERT INTO File VALUES(682,682,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_2.mp3',1,1648793052,6272,77,0,0,0);
INSERT INTO File VALUES(683,683,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_3.mp3',1,1648793052,6272,77,0,0,0);
INSERT INTO File VALUES(684,684,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_4.mp3',1,1648793052,6272,77,0,0,0);
INSERT INTO File VALUES(685,685,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_5.mp3',1,1648793052,6272,77,0,0,0);
INSERT INTO File VALUES(686,686,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_6.mp3',1,1648793052,6272,77,0,0,0);
INSERT INTO File VALUES(687,687,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_7.mp3',1,1648793052,6272,77,0,0,0);
INSERT INTO File VALUES(688,688,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_8.mp3',1,1648793052,6272,77,0,0,0);
INSERT INTO File VALUES(689,689,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_9.mp3',1,1648793052,6272,77,0,0,0);
INSERT INTO File VALUES(690,690,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_10.mp3',1,1648793052,6272,77,0,0,0);
INSERT INTO File VALUES(691,691,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_1.mp3',1,1648793052,6272,78,0,0,0);
INSERT INTO File VALUES(692,692,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_2.mp3',1,1648793052,6272,78,0,0,0);
INSERT INTO File VALUES(693,693,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_3.mp3',1,1648793052,6272,78,0,0,0);
INSERT INTO File VALUES(694,694,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_4.mp3',1,1648793052,6272,78,0,0,0);
INSERT INTO File VALUES(695,695,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_5.mp3',1,1648793052,6272,78,0,0,0);
INSERT INTO File VALUES(696,696,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_6.mp3',1,1648793052,6272,78,0,0,0);
INSERT INTO File VALUES(697,697,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_7.mp3',1,1648793052,6272,78,0,0,0);
INSERT INTO File VALUES(698,698,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_8.mp3',1,1648793052,6272,78,0,0,0);
INSERT INTO File VALUES(699,699,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_9.mp3',1,1648793052,6272,78,0,0,0);
INSERT INTO File VALUES(700,700,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_10.mp3',1,1648793052,6272,78,0,0,0);
INSERT INTO File VALUES(701,701,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_1.mp3',1,1648793051,6272,80,0,0,0);
INSERT INTO File VALUES(702,702,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_2.mp3',1,1648793051,6272,80,0,0,0);
INSERT INTO File VALUES(703,703,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_3.mp3',1,1648793051,6272,80,0,0,0);
INSERT INTO File VALUES(704,704,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_4.mp3',1,1648793051,6272,80,0,0,0);
INSERT INTO File VALUES(705,705,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_5.mp3',1,1648793051,6272,80,0,0,0);
INSERT INTO File VALUES(706,706,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_6.mp3',1,1648793051,6272,80,0,0,0);
INSERT INTO File VALUES(707,707,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_7.mp3',1,1648793051,6272,80,0,0,0);
INSERT INTO File VALUES(708,708,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_8.mp3',1,1648793051,6272,80,0,0,0);
INSERT INTO File VALUES(709,709,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_9.mp3',1,1648793051,6272,80,0,0,0);
INSERT INTO File VALUES(710,710,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_10.mp3',1,1648793051,6272,80,0,0,0);
INSERT INTO File VALUES(711,711,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_1.mp3',1,1648793051,6272,81,0,0,0);
INSERT INTO File VALUES(712,712,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_2.mp3',1,1648793051,6272,81,0,0,0);
INSERT INTO File VALUES(713,713,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_3.mp3',1,1648793051,6272,81,0,0,0);
INSERT INTO File VALUES(714,714,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_4.mp3',1,1648793051,6272,81,0,0,0);
INSERT INTO File VALUES(715,715,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_5.mp3',1,1648793051,6272,81,0,0,0);
INSERT INTO File VALUES(716,716,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_6.mp3',1,1648793051,6272,81,0,0,0);
INSERT INTO File VALUES(717,717,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_7.mp3',1,1648793051,6272,81,0,0,0);
INSERT INTO File VALUES(718,718,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_8.mp3',1,1648793051,6272,81,0,0,0);
INSERT INTO File VALUES(719,719,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_9.mp3',1,1648793051,6272,81,0,0,0);
INSERT INTO File VALUES(720,720,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_10.mp3',1,1648793051,6272,81,0,0,0);
INSERT INTO File VALUES(721,721,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_1.mp3',1,1648793051,6272,82,0,0,0);
INSERT INTO File VALUES(722,722,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_2.mp3',1,1648793051,6272,82,0,0,0);
INSERT INTO File VALUES(723,723,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_3.mp3',1,1648793051,6272,82,0,0,0);
INSERT INTO File VALUES(724,724,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_4.mp3',1,1648793051,6272,82,0,0,0);
INSERT INTO File VALUES(725,725,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_5.mp3',1,1648793051,6272,82,0,0,0);
INSERT INTO File VALUES(726,726,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_6.mp3',1,1648793051,6272,82,0,0,0);
INSERT INTO File VALUES(727,727,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_7.mp3',1,1648793051,6272,82,0,0,0);
INSERT INTO File VALUES(728,728,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_8.mp3',1,1648793051,6272,82,0,0,0);
INSERT INTO File VALUES(729,729,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_9.mp3',1,1648793051,6272,82,0,0,0);
INSERT INTO File VALUES(730,730,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_10.mp3',1,1648793051,6272,82,0,0,0);
INSERT INTO File VALUES(731,731,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_1.mp3',1,1648793051,6272,83,0,0,0);
INSERT INTO File VALUES(732,732,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_2.mp3',1,1648793051,6272,83,0,0,0);
INSERT INTO File VALUES(733,733,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_3.mp3',1,1648793051,6272,83,0,0,0);
INSERT INTO File VALUES(734,734,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_4.mp3',1,1648793051,6272,83,0,0,0);
INSERT INTO File VALUES(735,735,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_5.mp3',1,1648793051,6272,83,0,0,0);
INSERT INTO File VALUES(736,736,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_6.mp3',1,1648793051,6272,83,0,0,0);
INSERT INTO File VALUES(737,737,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_7.mp3',1,1648793051,6272,83,0,0,0);
INSERT INTO File VALUES(738,738,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_8.mp3',1,1648793051,6272,83,0,0,0);
INSERT INTO File VALUES(739,739,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_9.mp3',1,1648793051,6272,83,0,0,0);
INSERT INTO File VALUES(740,740,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_10.mp3',1,1648793051,6272,83,0,0,0);
INSERT INTO File VALUES(741,741,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_1.mp3',1,1648793051,6272,84,0,0,0);
INSERT INTO File VALUES(742,742,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_2.mp3',1,1648793051,6272,84,0,0,0);
INSERT INTO File VALUES(743,743,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_3.mp3',1,1648793051,6272,84,0,0,0);
INSERT INTO File VALUES(744,744,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_4.mp3',1,1648793051,6272,84,0,0,0);
INSERT INTO File VALUES(745,745,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_5.mp3',1,1648793051,6272,84,0,0,0);
INSERT INTO File VALUES(746,746,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_6.mp3',1,1648793051,6272,84,0,0,0);
INSERT INTO File VALUES(747,747,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_7.mp3',1,1648793051,6272,84,0,0,0);
INSERT INTO File VALUES(748,748,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_8.mp3',1,1648793051,6272,84,0,0,0);
INSERT INTO File VALUES(749,749,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_9.mp3',1,1648793051,6272,84,0,0,0);
INSERT INTO File VALUES(750,750,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_10.mp3',1,1648793051,6272,84,0,0,0);
INSERT INTO File VALUES(751,751,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_1.mp3',1,1648793051,6272,85,0,0,0);
INSERT INTO File VALUES(752,752,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_2.mp3',1,1648793051,6272,85,0,0,0);
INSERT INTO File VALUES(753,753,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_3.mp3',1,1648793051,6272,85,0,0,0);
INSERT INTO File VALUES(754,754,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_4.mp3',1,1648793051,6272,85,0,0,0);
INSERT INTO File VALUES(755,755,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_5.mp3',1,1648793051,6272,85,0,0,0);
INSERT INTO File VALUES(756,756,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_6.mp3',1,1648793051,6272,85,0,0,0);
INSERT INTO File VALUES(757,757,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_7.mp3',1,1648793051,6272,85,0,0,0);
INSERT INTO File VALUES(758,758,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_8.mp3',1,1648793051,6272,85,0,0,0);
INSERT INTO File VALUES(759,759,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_9.mp3',1,1648793051,6272,85,0,0,0);
INSERT INTO File VALUES(760,760,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_10.mp3',1,1648793051,6272,85,0,0,0);
INSERT INTO File VALUES(761,761,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_1.mp3',1,1648793051,6272,86,0,0,0);
INSERT INTO File VALUES(762,762,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_2.mp3',1,1648793051,6272,86,0,0,0);
INSERT INTO File VALUES(763,763,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_3.mp3',1,1648793051,6272,86,0,0,0);
INSERT INTO File VALUES(764,764,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_4.mp3',1,1648793051,6272,86,0,0,0);
INSERT INTO File VALUES(765,765,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_5.mp3',1,1648793051,6272,86,0,0,0);
INSERT INTO File VALUES(766,766,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_6.mp3',1,1648793051,6272,86,0,0,0);
INSERT INTO File VALUES(767,767,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_7.mp3',1,1648793051,6272,86,0,0,0);
INSERT INTO File VALUES(768,768,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_8.mp3',1,1648793051,6272,86,0,0,0);
INSERT INTO File VALUES(769,769,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_9.mp3',1,1648793051,6272,86,0,0,0);
INSERT INTO File VALUES(770,770,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_10.mp3',1,1648793051,6272,86,0,0,0);
INSERT INTO File VALUES(771,771,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_1.mp3',1,1648793051,6272,87,0,0,0);
INSERT INTO File VALUES(772,772,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_2.mp3',1,1648793051,6272,87,0,0,0);
INSERT INTO File VALUES(773,773,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_3.mp3',1,1648793051,6272,87,0,0,0);
INSERT INTO File VALUES(774,774,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_4.mp3',1,1648793051,6272,87,0,0,0);
INSERT INTO File VALUES(775,775,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_5.mp3',1,1648793051,6272,87,0,0,0);
INSERT INTO File VALUES(776,776,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_6.mp3',1,1648793051,6272,87,0,0,0);
INSERT INTO File VALUES(777,777,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_7.mp3',1,1648793051,6272,87,0,0,0);
INSERT INTO File VALUES(778,778,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_8.mp3',1,1648793051,6272,87,0,0,0);
INSERT INTO File VALUES(779,779,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_9.mp3',1,1648793051,6272,87,0,0,0);
INSERT INTO File VALUES(780,780,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_10.mp3',1,1648793051,6272,87,0,0,0);
INSERT INTO File VALUES(781,781,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_1.mp3',1,1648793051,6272,88,0,0,0);
INSERT INTO File VALUES(782,782,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_2.mp3',1,1648793051,6272,88,0,0,0);
INSERT INTO File VALUES(783,783,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_3.mp3',1,1648793051,6272,88,0,0,0);
INSERT INTO File VALUES(784,784,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_4.mp3',1,1648793051,6272,88,0,0,0);
INSERT INTO File VALUES(785,785,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_5.mp3',1,1648793051,6272,88,0,0,0);
INSERT INTO File VALUES(786,786,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_6.mp3',1,1648793051,6272,88,0,0,0);
INSERT INTO File VALUES(787,787,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_7.mp3',1,1648793051,6272,88,0,0,0);
INSERT INTO File VALUES(788,788,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_8.mp3',1,1648793051,6272,88,0,0,0);
INSERT INTO File VALUES(789,789,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_9.mp3',1,1648793051,6272,88,0,0,0);
INSERT INTO File VALUES(790,790,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_10.mp3',1,1648793051,6272,88,0,0,0);
INSERT INTO File VALUES(791,791,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_1.mp3',1,1648793051,6272,89,0,0,0);
INSERT INTO File VALUES(792,792,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_2.mp3',1,1648793051,6272,89,0,0,0);
INSERT INTO File VALUES(793,793,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_3.mp3',1,1648793051,6272,89,0,0,0);
INSERT INTO File VALUES(794,794,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_4.mp3',1,1648793051,6272,89,0,0,0);
INSERT INTO File VALUES(795,795,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_5.mp3',1,1648793051,6272,89,0,0,0);
INSERT INTO File VALUES(796,796,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_6.mp3',1,1648793051,6272,89,0,0,0);
INSERT INTO File VALUES(797,797,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_7.mp3',1,1648793051,6272,89,0,0,0);
INSERT INTO File VALUES(798,798,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_8.mp3',1,1648793051,6272,89,0,0,0);
INSERT INTO File VALUES(799,799,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_9.mp3',1,1648793051,6272,89,0,0,0);
INSERT INTO File VALUES(800,800,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_10.mp3',1,1648793051,6272,89,0,0,0);
INSERT INTO File VALUES(801,801,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_1.mp3',1,1648793051,6272,91,0,0,0);
INSERT INTO File VALUES(802,802,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_2.mp3',1,1648793051,6272,91,0,0,0);
INSERT INTO File VALUES(803,803,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_3.mp3',1,1648793051,6272,91,0,0,0);
INSERT INTO File VALUES(804,804,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_4.mp3',1,1648793051,6272,91,0,0,0);
INSERT INTO File VALUES(805,805,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_5.mp3',1,1648793051,6272,91,0,0,0);
INSERT INTO File VALUES(806,806,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_6.mp3',1,1648793051,6272,91,0,0,0);
INSERT INTO File VALUES(807,807,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_7.mp3',1,1648793051,6272,91,0,0,0);
INSERT INTO File VALUES(808,808,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_8.mp3',1,1648793051,6272,91,0,0,0);
INSERT INTO File VALUES(809,809,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_9.mp3',1,1648793051,6272,91,0,0,0);
INSERT INTO File VALUES(810,810,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_10.mp3',1,1648793051,6272,91,0,0,0);
INSERT INTO File VALUES(811,811,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_1.mp3',1,1648793051,6272,92,0,0,0);
INSERT INTO File VALUES(812,812,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_2.mp3',1,1648793051,6272,92,0,0,0);
INSERT INTO File VALUES(813,813,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_3.mp3',1,1648793051,6272,92,0,0,0);
INSERT INTO File VALUES(814,814,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_4.mp3',1,1648793051,6272,92,0,0,0);
INSERT INTO File VALUES(815,815,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_5.mp3',1,1648793051,6272,92,0,0,0);
INSERT INTO File VALUES(816,816,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_6.mp3',1,1648793051,6272,92,0,0,0);
INSERT INTO File VALUES(817,817,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_7.mp3',1,1648793051,6272,92,0,0,0);
INSERT INTO File VALUES(818,818,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_8.mp3',1,1648793051,6272,92,0,0,0);
INSERT INTO File VALUES(819,819,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_9.mp3',1,1648793051,6272,92,0,0,0);
INSERT INTO File VALUES(820,820,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_10.mp3',1,1648793051,6272,92,0,0,0);
INSERT INTO File VALUES(821,821,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_1.mp3',1,1648793051,6272,93,0,0,0);
INSERT INTO File VALUES(822,822,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_2.mp3',1,1648793051,6272,93,0,0,0);
INSERT INTO File VALUES(823,823,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_3.mp3',1,1648793051,6272,93,0,0,0);
INSERT INTO File VALUES(824,824,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_4.mp3',1,1648793051,6272,93,0,0,0);
INSERT INTO File VALUES(825,825,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_5.mp3',1,1648793051,6272,93,0,0,0);
INSERT INTO File VALUES(826,826,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_6.mp3',1,1648793051,6272,93,0,0,0);
INSERT INTO File VALUES(827,827,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_7.mp3',1,1648793051,6272,93,0,0,0);
INSERT INTO File VALUES(828,828,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_8.mp3',1,1648793051,6272,93,0,0,0);
INSERT INTO File VALUES(829,829,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_9.mp3',1,1648793051,6272,93,0,0,0);
INSERT INTO File VALUES(830,830,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_10.mp3',1,1648793051,6272,93,0,0,0);
INSERT INTO File VALUES(831,831,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_1.mp3',1,1648793051,6272,94,0,0,0);
INSERT INTO File VALUES(832,832,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_2.mp3',1,1648793051,6272,94,0,0,0);
INSERT INTO File VALUES(833,833,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_3.mp3',1,1648793051,6272,94,0,0,0);
INSERT INTO File VALUES(834,834,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_4.mp3',1,1648793051,6272,94,0,0,0);
INSERT INTO File VALUES(835,835,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_5.mp3',1,1648793051,6272,94,0,0,0);
INSERT INTO File VALUES(836,836,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_6.mp3',1,1648793051,6272,94,0,0,0);
INSERT INTO File VALUES(837,837,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_7.mp3',1,1648793051,6272,94,0,0,0);
INSERT INTO File VALUES(838,838,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_8.mp3',1,1648793051,6272,94,0,0,0);
INSERT INTO File VALUES(839,839,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_9.mp3',1,1648793051,6272,94,0,0,0);
INSERT INTO File VALUES(840,840,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_10.mp3',1,1648793051,6272,94,0,0,0);
INSERT INTO File VALUES(841,841,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_1.mp3',1,1648793051,6272,95,0,0,0);
INSERT INTO File VALUES(842,842,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_2.mp3',1,1648793051,6272,95,0,0,0);
INSERT INTO File VALUES(843,843,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_3.mp3',1,1648793051,6272,95,0,0,0);
INSERT INTO File VALUES(844,844,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_4.mp3',1,1648793051,6272,95,0,0,0);
INSERT INTO File VALUES(845,845,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_5.mp3',1,1648793051,6272,95,0,0,0);
INSERT INTO File VALUES(846,846,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_6.mp3',1,1648793051,6272,95,0,0,0);
INSERT INTO File VALUES(847,847,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_7.mp3',1,1648793051,6272,95,0,0,0);
INSERT INTO File VALUES(848,848,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_8.mp3',1,1648793051,6272,95,0,0,0);
INSERT INTO File VALUES(849,849,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_9.mp3',1,1648793051,6272,95,0,0,0);
INSERT INTO File VALUES(850,850,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_10.mp3',1,1648793051,6272,95,0,0,0);
INSERT INTO File VALUES(851,851,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_1.mp3',1,1648793051,6272,96,0,0,0);
INSERT INTO File VALUES(852,852,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_2.mp3',1,1648793051,6272,96,0,0,0);
INSERT INTO File VALUES(853,853,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_3.mp3',1,1648793051,6272,96,0,0,0);
INSERT INTO File VALUES(854,854,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_4.mp3',1,1648793051,6272,96,0,0,0);
INSERT INTO File VALUES(855,855,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_5.mp3',1,1648793051,6272,96,0,0,0);
INSERT INTO File VALUES(856,856,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_6.mp3',1,1648793051,6272,96,0,0,0);
INSERT INTO File VALUES(857,857,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_7.mp3',1,1648793051,6272,96,0,0,0);
INSERT INTO File VALUES(858,858,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_8.mp3',1,1648793051,6272,96,0,0,0);
INSERT INTO File VALUES(859,859,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_9.mp3',1,1648793051,6272,96,0,0,0);
INSERT INTO File VALUES(860,860,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_10.mp3',1,1648793051,6272,96,0,0,0);
INSERT INTO File VALUES(861,861,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_1.mp3',1,1648793051,6272,97,0,0,0);
INSERT INTO File VALUES(862,862,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_2.mp3',1,1648793051,6272,97,0,0,0);
INSERT INTO File VALUES(863,863,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_3.mp3',1,1648793051,6272,97,0,0,0);
INSERT INTO File VALUES(864,864,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_4.mp3',1,1648793051,6272,97,0,0,0);
INSERT INTO File VALUES(865,865,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_5.mp3',1,1648793051,6272,97,0,0,0);
INSERT INTO File VALUES(866,866,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_6.mp3',1,1648793051,6272,97,0,0,0);
INSERT INTO File VALUES(867,867,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_7.mp3',1,1648793051,6272,97,0,0,0);
INSERT INTO File VALUES(868,868,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_8.mp3',1,1648793051,6272,97,0,0,0);
INSERT INTO File VALUES(869,869,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_9.mp3',1,1648793051,6272,97,0,0,0);
INSERT INTO File VALUES(870,870,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_10.mp3',1,1648793051,6272,97,0,0,0);
INSERT INTO File VALUES(871,871,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_1.mp3',1,1648793050,6272,98,0,0,0);
INSERT INTO File VALUES(872,872,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_2.mp3',1,1648793050,6272,98,0,0,0);
INSERT INTO File VALUES(873,873,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_3.mp3',1,1648793050,6272,98,0,0,0);
INSERT INTO File VALUES(874,874,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_4.mp3',1,1648793050,6272,98,0,0,0);
INSERT INTO File VALUES(875,875,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_5.mp3',1,1648793050,6272,98,0,0,0);
INSERT INTO File VALUES(876,876,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_6.mp3',1,1648793050,6272,98,0,0,0);
INSERT INTO File VALUES(877,877,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_7.mp3',1,1648793050,6272,98,0,0,0);
INSERT INTO File VALUES(878,878,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_8.mp3',1,1648793050,6272,98,0,0,0);
INSERT INTO File VALUES(879,879,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_9.mp3',1,1648793050,6272,98,0,0,0);
INSERT INTO File VALUES(880,880,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_10.mp3',1,1648793050,6272,98,0,0,0);
INSERT INTO File VALUES(881,881,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_1.mp3',1,1648793050,6272,99,0,0,0);
INSERT INTO File VALUES(882,882,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_2.mp3',1,1648793050,6272,99,0,0,0);
INSERT INTO File VALUES(883,883,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_3.mp3',1,1648793050,6272,99,0,0,0);
INSERT INTO File VALUES(884,884,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_4.mp3',1,1648793050,6272,99,0,0,0);
INSERT INTO File VALUES(885,885,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_5.mp3',1,1648793050,6272,99,0,0,0);
INSERT INTO File VALUES(886,886,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_6.mp3',1,1648793050,6272,99,0,0,0);
INSERT INTO File VALUES(887,887,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_7.mp3',1,1648793050,6272,99,0,0,0);
INSERT INTO File VALUES(888,888,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_8.mp3',1,1648793050,6272,99,0,0,0);
INSERT INTO File VALUES(889,889,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_9.mp3',1,1648793050,6272,99,0,0,0);
INSERT INTO File VALUES(890,890,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_10.mp3',1,1648793050,6272,99,0,0,0);
INSERT INTO File VALUES(891,891,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_1.mp3',1,1648793050,6272,100,0,0,0);
INSERT INTO File VALUES(892,892,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_2.mp3',1,1648793050,6272,100,0,0,0);
INSERT INTO File VALUES(893,893,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_3.mp3',1,1648793050,6272,100,0,0,0);
INSERT INTO File VALUES(894,894,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_4.mp3',1,1648793050,6272,100,0,0,0);
INSERT INTO File VALUES(895,895,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_5.mp3',1,1648793050,6272,100,0,0,0);
INSERT INTO File VALUES(896,896,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_6.mp3',1,1648793050,6272,100,0,0,0);
INSERT INTO File VALUES(897,897,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_7.mp3',1,1648793050,6272,100,0,0,0);
INSERT INTO File VALUES(898,898,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_8.mp3',1,1648793050,6272,100,0,0,0);
INSERT INTO File VALUES(899,899,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_9.mp3',1,1648793050,6272,100,0,0,0);
INSERT INTO File VALUES(900,900,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_10.mp3',1,1648793050,6272,100,0,0,0);
INSERT INTO File VALUES(901,901,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_1.mp3',1,1648793050,6272,102,0,0,0);
INSERT INTO File VALUES(902,902,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_2.mp3',1,1648793050,6272,102,0,0,0);
INSERT INTO File VALUES(903,903,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_3.mp3',1,1648793050,6272,102,0,0,0);
INSERT INTO File VALUES(904,904,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_4.mp3',1,1648793050,6272,102,0,0,0);
INSERT INTO File VALUES(905,905,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_5.mp3',1,1648793050,6272,102,0,0,0);
INSERT INTO File VALUES(906,906,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_6.mp3',1,1648793050,6272,102,0,0,0);
INSERT INTO File VALUES(907,907,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_7.mp3',1,1648793050,6272,102,0,0,0);
INSERT INTO File VALUES(908,908,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_8.mp3',1,1648793050,6272,102,0,0,0);
INSERT INTO File VALUES(909,909,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_9.mp3',1,1648793050,6272,102,0,0,0);
INSERT INTO File VALUES(910,910,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_10.mp3',1,1648793050,6272,102,0,0,0);
INSERT INTO File VALUES(911,911,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_1.mp3',1,1648793050,6272,103,0,0,0);
INSERT INTO File VALUES(912,912,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_2.mp3',1,1648793050,6272,103,0,0,0);
INSERT INTO File VALUES(913,913,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_3.mp3',1,1648793050,6272,103,0,0,0);
INSERT INTO File VALUES(914,914,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_4.mp3',1,1648793050,6272,103,0,0,0);
INSERT INTO File VALUES(915,915,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_5.mp3',1,1648793050,6272,103,0,0,0);
INSERT INTO File VALUES(916,916,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_6.mp3',1,1648793050,6272,103,0,0,0);
INSERT INTO File VALUES(917,917,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_7.mp3',1,1648793050,6272,103,0,0,0);
INSERT INTO File VALUES(918,918,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_8.mp3',1,1648793050,6272,103,0,0,0);
INSERT INTO File VALUES(919,919,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_9.mp3',1,1648793050,6272,103,0,0,0);
INSERT INTO File VALUES(920,920,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_10.mp3',1,1648793050,6272,103,0,0,0);
INSERT INTO File VALUES(921,921,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_1.mp3',1,1648793050,6272,104,0,0,0);
INSERT INTO File VALUES(922,922,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_2.mp3',1,1648793050,6272,104,0,0,0);
INSERT INTO File VALUES(923,923,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_3.mp3',1,1648793050,6272,104,0,0,0);
INSERT INTO File VALUES(924,924,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_4.mp3',1,1648793050,6272,104,0,0,0);
INSERT INTO File VALUES(925,925,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_5.mp3',1,1648793050,6272,104,0,0,0);
INSERT INTO File VALUES(926,926,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_6.mp3',1,1648793050,6272,104,0,0,0);
INSERT INTO File VALUES(927,927,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_7.mp3',1,1648793050,6272,104,0,0,0);
INSERT INTO File VALUES(928,928,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_8.mp3',1,1648793050,6272,104,0,0,0);
INSERT INTO File VALUES(929,929,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_9.mp3',1,1648793050,6272,104,0,0,0);
INSERT INTO File VALUES(930,930,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_10.mp3',1,1648793050,6272,104,0,0,0);
INSERT INTO File VALUES(931,931,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_1.mp3',1,1648793050,6272,105,0,0,0);
INSERT INTO File VALUES(932,932,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_2.mp3',1,1648793050,6272,105,0,0,0);
INSERT INTO File VALUES(933,933,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_3.mp3',1,1648793050,6272,105,0,0,0);
INSERT INTO File VALUES(934,934,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_4.mp3',1,1648793050,6272,105,0,0,0);
INSERT INTO File VALUES(935,935,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_5.mp3',1,1648793050,6272,105,0,0,0);
INSERT INTO File VALUES(936,936,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_6.mp3',1,1648793050,6272,105,0,0,0);
INSERT INTO File VALUES(937,937,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_7.mp3',1,1648793050,6272,105,0,0,0);
INSERT INTO File VALUES(938,938,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_8.mp3',1,1648793050,6272,105,0,0,0);
INSERT INTO File VALUES(939,939,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_9.mp3',1,1648793050,6272,105,0,0,0);
INSERT INTO File VALUES(940,940,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_10.mp3',1,1648793050,6272,105,0,0,0);
INSERT INTO File VALUES(941,941,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_1.mp3',1,1648793050,6272,106,0,0,0);
INSERT INTO File VALUES(942,942,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_2.mp3',1,1648793050,6272,106,0,0,0);
INSERT INTO File VALUES(943,943,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_3.mp3',1,1648793050,6272,106,0,0,0);
INSERT INTO File VALUES(944,944,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_4.mp3',1,1648793050,6272,106,0,0,0);
INSERT INTO File VALUES(945,945,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_5.mp3',1,1648793050,6272,106,0,0,0);
INSERT INTO File VALUES(946,946,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_6.mp3',1,1648793050,6272,106,0,0,0);
INSERT INTO File VALUES(947,947,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_7.mp3',1,1648793050,6272,106,0,0,0);
INSERT INTO File VALUES(948,948,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_8.mp3',1,1648793050,6272,106,0,0,0);
INSERT INTO File VALUES(949,949,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_9.mp3',1,1648793050,6272,106,0,0,0);
INSERT INTO File VALUES(950,950,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_10.mp3',1,1648793050,6272,106,0,0,0);
INSERT INTO File VALUES(951,951,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_1.mp3',1,1648793050,6272,107,0,0,0);
INSERT INTO File VALUES(952,952,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_2.mp3',1,1648793050,6272,107,0,0,0);
INSERT INTO File VALUES(953,953,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_3.mp3',1,1648793050,6272,107,0,0,0);
INSERT INTO File VALUES(954,954,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_4.mp3',1,1648793050,6272,107,0,0,0);
INSERT INTO File VALUES(955,955,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_5.mp3',1,1648793050,6272,107,0,0,0);
INSERT INTO File VALUES(956,956,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_6.mp3',1,1648793050,6272,107,0,0,0);
INSERT INTO File VALUES(957,957,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_7.mp3',1,1648793050,6272,107,0,0,0);
INSERT INTO File VALUES(958,958,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_8.mp3',1,1648793050,6272,107,0,0,0);
INSERT INTO File VALUES(959,959,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_9.mp3',1,1648793050,6272,107,0,0,0);
INSERT INTO File VALUES(960,960,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_10.mp3',1,1648793050,6272,107,0,0,0);
INSERT INTO File VALUES(961,961,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_1.mp3',1,1648793050,6272,108,0,0,0);
INSERT INTO File VALUES(962,962,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_2.mp3',1,1648793050,6272,108,0,0,0);
INSERT INTO File VALUES(963,963,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_3.mp3',1,1648793050,6272,108,0,0,0);
INSERT INTO File VALUES(964,964,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_4.mp3',1,1648793050,6272,108,0,0,0);
INSERT INTO File VALUES(965,965,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_5.mp3',1,1648793050,6272,108,0,0,0);
INSERT INTO File VALUES(966,966,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_6.mp3',1,1648793050,6272,108,0,0,0);
INSERT INTO File VALUES(967,967,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_7.mp3',1,1648793050,6272,108,0,0,0);
INSERT INTO File VALUES(968,968,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_8.mp3',1,1648793050,6272,108,0,0,0);
INSERT INTO File VALUES(969,969,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_9.mp3',1,1648793050,6272,108,0,0,0);
INSERT INTO File VALUES(970,970,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_10.mp3',1,1648793050,6272,108,0,0,0);
INSERT INTO File VALUES(971,971,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_1.mp3',1,1648793050,6272,109,0,0,0);
INSERT INTO File VALUES(972,972,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_2.mp3',1,1648793050,6272,109,0,0,0);
INSERT INTO File VALUES(973,973,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_3.mp3',1,1648793050,6272,109,0,0,0);
INSERT INTO File VALUES(974,974,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_4.mp3',1,1648793050,6272,109,0,0,0);
INSERT INTO File VALUES(975,975,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_5.mp3',1,1648793050,6272,109,0,0,0);
INSERT INTO File VALUES(976,976,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_6.mp3',1,1648793050,6272,109,0,0,0);
INSERT INTO File VALUES(977,977,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_7.mp3',1,1648793050,6272,109,0,0,0);
INSERT INTO File VALUES(978,978,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_8.mp3',1,1648793050,6272,109,0,0,0);
INSERT INTO File VALUES(979,979,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_9.mp3',1,1648793050,6272,109,0,0,0);
INSERT INTO File VALUES(980,980,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_10.mp3',1,1648793050,6272,109,0,0,0);
INSERT INTO File VALUES(981,981,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_1.mp3',1,1648793050,6272,110,0,0,0);
INSERT INTO File VALUES(982,982,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_2.mp3',1,1648793050,6272,110,0,0,0);
INSERT INTO File VALUES(983,983,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_3.mp3',1,1648793050,6272,110,0,0,0);
INSERT INTO File VALUES(984,984,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_4.mp3',1,1648793050,6272,110,0,0,0);
INSERT INTO File VALUES(985,985,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_5.mp3',1,1648793050,6272,110,0,0,0);
INSERT INTO File VALUES(986,986,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_6.mp3',1,1648793050,6272,110,0,0,0);
INSERT INTO File VALUES(987,987,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_7.mp3',1,1648793050,6272,110,0,0,0);
INSERT INTO File VALUES(988,988,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_8.mp3',1,1648793050,6272,110,0,0,0);
INSERT INTO File VALUES(989,989,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_9.mp3',1,1648793050,6272,110,0,0,0);
INSERT INTO File VALUES(990,990,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_10.mp3',1,1648793050,6272,110,0,0,0);
INSERT INTO File VALUES(991,991,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_1.mp3',1,1648793050,6272,111,0,0,0);
INSERT INTO File VALUES(992,992,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_2.mp3',1,1648793050,6272,111,0,0,0);
INSERT INTO File VALUES(993,993,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_3.mp3',1,1648793050,6272,111,0,0,0);
INSERT INTO File VALUES(994,994,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_4.mp3',1,1648793050,6272,111,0,0,0);
INSERT INTO File VALUES(995,995,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_5.mp3',1,1648793050,6272,111,0,0,0);
INSERT INTO File VALUES(996,996,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_6.mp3',1,1648793050,6272,111,0,0,0);
INSERT INTO File VALUES(997,997,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_7.mp3',1,1648793050,6272,111,0,0,0);
INSERT INTO File VALUES(998,998,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_8.mp3',1,1648793050,6272,111,0,0,0);
INSERT INTO File VALUES(999,999,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_9.mp3',1,1648793050,6272,111,0,0,0);
INSERT INTO File VALUES(1000,1000,NULL,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_10.mp3',1,1648793050,6272,111,0,0,0);
INSERT INTO Genre VALUES(1,'Hip-Hop',9,9);
INSERT INTO Genre VALUES(2,'Native American',8,8);
INSERT INTO Genre VALUES(3,'Death Metal',10,10);
INSERT INTO Genre VALUES(4,'Jazz-Funk',11,11);
INSERT INTO Genre VALUES(5,'Other',12,12);
INSERT INTO Genre VALUES(6,'Polka',19,19);
INSERT INTO Genre VALUES(7,'Fusion',15,15);
INSERT INTO Genre VALUES(8,'Dream',9,9);
INSERT INTO Genre VALUES(9,'Hard Rock',19,19);
INSERT INTO Genre VALUES(10,'Grunge',18,18);
INSERT INTO Genre VALUES(11,'Cabaret',12,12);
INSERT INTO Genre VALUES(12,'Eurodance',7,7);
INSERT INTO Genre VALUES(13,'Dance',13,13);
INSERT INTO Genre VALUES(14,'Tribal',10,10);
INSERT INTO Genre VALUES(15,'Jazz',14,14);
INSERT INTO Genre VALUES(16,'Noise',13,13);
INSERT INTO Genre VALUES(17,'Techno',15,15);
INSERT INTO Genre VALUES(18,'Reggae',14,14);
INSERT INTO Genre VALUES(19,'Pop-Folk',14,14);
INSERT INTO Genre VALUES(20,'Meditative',15,15);
INSERT INTO Genre VALUES(21,'Christian Rap',13,13);
INSERT INTO Genre VALUES(22,'Top 40',15,15);
INSERT INTO Genre VALUES(23,'Euro-Techno',12,12);
INSERT INTO Genre VALUES(24,'R&B',9,9);
INSERT INTO Genre VALUES(25,'Classic Rock',13,13);
INSERT INTO Genre VALUES(26,'Country',9,9);
INSERT INTO Genre VALUES(27,'Retro',13,13);
INSERT INTO Genre VALUES(28,'Lo-Fi',16,16);
INSERT INTO Genre VALUES(29,'Acid Punk',17,17);
INSERT INTO Genre VALUES(30,'Funk',15,15);
INSERT INTO Genre VALUES(31,'Gangsta',16,16);
INSERT INTO Genre VALUES(32,'Folk',18,18);
INSERT INTO Genre VALUES(33,'Soul',16,16);
INSERT INTO Genre VALUES(34,'Trailer',10,10);
INSERT INTO Genre VALUES(35,'Bass',9,9);
INSERT INTO Genre VALUES(36,'Pranks',12,12);
INSERT INTO Genre VALUES(37,'Ska',12,12);
INSERT INTO Genre VALUES(38,'Oldies',12,12);
INSERT INTO Genre VALUES(39,'New Age',14,14);
INSERT INTO Genre VALUES(40,'Game',16,16);
INSERT INTO Genre VALUES(41,'Electronic',16,16);
INSERT INTO Genre VALUES(42,'Punk',14,14);
INSERT INTO Genre VALUES(43,'Instrumental',8,8);
INSERT INTO Genre VALUES(44,'Darkwave',7,7);
INSERT INTO Genre VALUES(45,'Metal',14,14);
INSERT INTO Genre VALUES(46,'Acid Jazz',15,15);
INSERT INTO Genre VALUES(47,'Rave',12,12);
INSERT INTO Genre VALUES(48,'Vocal',9,9);
INSERT INTO Genre VALUES(49,'Musical',11,11);
INSERT INTO Genre VALUES(50,'Cult',15,15);
INSERT INTO Genre VALUES(51,'Southern Rock',11,11);
INSERT INTO Genre VALUES(52,'Pop',12,12);
INSERT INTO Genre VALUES(53,'Disco',11,11);
INSERT INTO Genre VALUES(54,'Alternative Rock',12,12);
INSERT INTO Genre VALUES(55,'Jungle',15,15);
INSERT INTO Genre VALUES(56,'Rock',11,11);
INSERT INTO Genre VALUES(57,'Space',10,10);
INSERT INTO Genre VALUES(58,'Ethnic',9,9);
INSERT INTO Genre VALUES(59,'Trance',11,11);
INSERT INTO Genre VALUES(60,'Showtunes',17,17);
INSERT INTO Genre VALUES(61,'House',15,15);
INSERT INTO Genre VALUES(62,'Soundtrack',16,16);
INSERT INTO Genre VALUES(63,'Instrumental Rock',15,15);
INSERT INTO Genre VALUES(64,'Pop/Funk',15,15);
INSERT INTO Genre VALUES(65,'Instrumental Pop',11,11);
INSERT INTO Genre VALUES(66,'Sound Clip',15,15);
INSERT INTO Genre VALUES(67,'New Wave',11,11);
INSERT INTO Genre VALUES(68,'Trip-Hop',11,11);
INSERT INTO Genre VALUES(69,'Techno-Industrial',13,13);
INSERT INTO Genre VALUES(70,'Gothic',16,16);
INSERT INTO Genre VALUES(71,'Rock & Roll',11,11);
INSERT INTO Genre VALUES(72,'Acid',8,8);
INSERT INTO Genre VALUES(73,'Gospel',21,21);
INSERT INTO Genre VALUES(74,'Ambient',6,6);
INSERT INTO Genre VALUES(75,'Rap',9,9);
INSERT INTO Genre VALUES(76,'Comedy',15,15);
INSERT INTO Genre VALUES(77,'Classical',9,9);
INSERT INTO Genre VALUES(78,'Psychedelic',6,6);
INSERT INTO Genre VALUES(79,'Industrial',3,3);
INSERT INTO Genre VALUES(80,'Alternative',10,10);
INSERT INTO Album VALUES(1,'album_10',3,2010,NULL,10,6390,1,10);
INSERT INTO Album VALUES(2,'album_9',3,2009,NULL,10,6390,1,10);
INSERT INTO Album VALUES(3,'album_8',3,2008,NULL,10,6390,1,10);
INSERT INTO Album VALUES(4,'album_7',3,2007,NULL,10,6390,1,10);
INSERT INTO Album VALUES(5,'album_6',3,2006,NULL,10,6390,1,10);
INSERT INTO Album VALUES(6,'album_5',3,2005,NULL,10,6390,1,10);
INSERT INTO Album VALUES(7,'album_4',3,2004,NULL,10,6390,1,10);
INSERT INTO Album VALUES(8,'album_3',3,2003,NULL,10,6390,1,10);
INSERT INTO Album VALUES(9,'album_2',3,2002,NULL,10,6390,1,10);
INSERT INTO Album VALUES(10,'album_1',3,2001,NULL,10,6390,1,10);
INSERT INTO Album VALUES(11,'album_10',4,2010,NULL,10,6390,1,10);
INSERT INTO Album VALUES(12,'album_9',4,2009,NULL,10,6390,1,10);
INSERT INTO Album VALUES(13,'album_8',4,2008,NULL,10,6390,1,10);
INSERT INTO Album VALUES(14,'album_7',4,2007,NULL,10,6390,1,10);
INSERT INTO Album VALUES(15,'album_6',4,2006,NULL,10,6390,1,10);
INSERT INTO Album VALUES(16,'album_5',4,2005,NULL,10,6390,1,10);
INSERT INTO Album VALUES(17,'album_4',4,2004,NULL,10,6390,1,10);
INSERT INTO Album VALUES(18,'album_3',4,2003,NULL,10,6390,1,10);
INSERT INTO Album VALUES(19,'album_2',4,2002,NULL,10,6390,1,10);
INSERT INTO Album VALUES(20,'album_1',4,2001,NULL,10,6390,1,10);
INSERT INTO Album VALUES(21,'album_10',5,2010,NULL,10,6390,1,10);
INSERT INTO Album VALUES(22,'album_9',5,2009,NULL,10,6390,1,10);
INSERT INTO Album VALUES(23,'album_8',5,2008,NULL,10,6390,1,10);
INSERT INTO Album VALUES(24,'album_7',5,2007,NULL,10,6390,1,10);
INSERT INTO Album VALUES(25,'album_6',5,2006,NULL,10,6390,1,10);
INSERT INTO Album VALUES(26,'album_5',5,2005,NULL,10,6390,1,10);
INSERT INTO Album VALUES(27,'album_4',5,2004,NULL,10,6390,1,10);
INSERT INTO Album VALUES(28,'album_3',5,2003,NULL,10,6390,1,10);
INSERT INTO Album VALUES(29,'album_2',5,2002,NULL,10,6390,1,10);
INSERT INTO Album VALUES(30,'album_1',5,2001,NULL,10,6390,1,10);
INSERT INTO Album VALUES(31,'album_10',6,2010,NULL,10,6390,1,10);
INSERT INTO Album VALUES(32,'album_9',6,2009,NULL,10,6390,1,10);
INSERT INTO Album VALUES(33,'album_8',6,2008,NULL,10,6390,1,10);
INSERT INTO Album VALUES(34,'album_7',6,2007,NULL,10,6390,1,10);
INSERT INTO Album VALUES(35,'album_6',6,2006,NULL,10,6390,1,10);
INSERT INTO Album VALUES(36,'album_5',6,2005,NULL,10,6390,1,10);
INSERT INTO Album VALUES(37,'album_4',6,2004,NULL,10,6390,1,10);
INSERT INTO Album VALUES(38,'album_3',6,2003,NULL,10,6390,1,10);
INSERT INTO Album VALUES(39,'album_2',6,2002,NULL,10,6390,1,10);
INSERT INTO Album VALUES(40,'album_1',6,2001,NULL,10,6390,1,10);
INSERT INTO Album VALUES(41,'album_10',7,2010,NULL,10,6390,1,10);
INSERT INTO Album VALUES(42,'album_9',7,2009,NULL,10,6390,1,10);
INSERT INTO Album VALUES(43,'album_8',7,2008,NULL,10,6390,1,10);
INSERT INTO Album VALUES(44,'album_7',7,2007,NULL,10,6390,1,10);
INSERT INTO Album VALUES(45,'album_6',7,2006,NULL,10,6390,1,10);
INSERT INTO Album VALUES(46,'album_5',7,2005,NULL,10,6390,1,10);
INSERT INTO Album VALUES(47,'album_4',7,2004,NULL,10,6390,1,10);
INSERT INTO Album VALUES(48,'album_3',7,2003,NULL,10,6390,1,10);
INSERT INTO Album VALUES(49,'album_2',7,2002,NULL,10,6390,1,10);
INSERT INTO Album VALUES(50,'album_1',7,2001,NULL,10,6390,1,10);
INSERT INTO Album VALUES(51,'album_10',8,2010,NULL,10,6390,1,10);
INSERT INTO Album VALUES(52,'album_9',8,2009,NULL,10,6390,1,10);
INSERT INTO Album VALUES(53,'album_8',8,2008,NULL,10,6390,1,10);
INSERT INTO Album VALUES(54,'album_7',8,2007,NULL,10,6390,1,10);
INSERT INTO Album VALUES(55,'album_6',8,2006,NULL,10,6390,1,10);
INSERT INTO Album VALUES(56,'album_5',8,2005,NULL,10,6390,1,10);
INSERT INTO Album VALUES(57,'album_4',8,2004,NULL,10,6390,1,10);
INSERT INTO Album VALUES(58,'album_3',8,2003,NULL,10,6390,1,10);
INSERT INTO Album VALUES(59,'album_2',8,2002,NULL,10,6390,1,10);
INSERT INTO Album VALUES(60,'album_1',8,2001,NULL,10,6390,1,10);
INSERT INTO Album VALUES(61,'album_10',9,2010,NULL,10,6390,1,10);
INSERT INTO Album VALUES(62,'album_9',9,2009,NULL,10,6390,1,10);
INSERT INTO Album VALUES(63,'album_8',9,2008,NULL,10,6390,1,10);
INSERT INTO Album VALUES(64,'album_7',9,2007,NULL,10,6390,1,10);
INSERT INTO Album VALUES(65,'album_6',9,2006,NULL,10,6390,1,10);
INSERT INTO Album VALUES(66,'album_5',9,2005,NULL,10,6390,1,10);
INSERT INTO Album VALUES(67,'album_4',9,2004,NULL,10,6390,1,10);
INSERT INTO Album VALUES(68,'album_3',9,2003,NULL,10,6390,1,10);
INSERT INTO Album VALUES(69,'album_2',9,2002,NULL,10,6390,1,10);
INSERT INTO Album VALUES(70,'album_1',9,2001,NULL,10,6390,1,10);
INSERT INTO Album VALUES(71,'album_10',10,2010,NULL,10,6390,1,10);
INSERT INTO Album VALUES(72,'album_9',10,2009,NULL,10,6390,1,10);
INSERT INTO Album VALUES(73,'album_8',10,2008,NULL,10,6390,1,10);
INSERT INTO Album VALUES(74,'album_7',10,2007,NULL,10,6390,1,10);
INSERT INTO Album VALUES(75,'album_6',10,2006,NULL,10,6390,1,10);
INSERT INTO Album VALUES(76,'album_5',10,2005,NULL,10,6390,1,10);
INSERT INTO Album VALUES(77,'album_4',10,2004,NULL,10,6390,1,10);
INSERT INTO Album VALUES(78,'album_3',10,2003,NULL,10,6390,1,10);
INSERT INTO Album VALUES(79,'album_2',10,2002,NULL,10,6390,1,10);
INSERT INTO Album VALUES(80,'album_1',10,2001,NULL,10,6390,1,10);
INSERT INTO Album VALUES(81,'album_10',11,2010,NULL,10,6390,1,10);
INSERT INTO Album VALUES(82,'album_9',11,2009,NULL,10,6390,1,10);
INSERT INTO Album VALUES(83,'album_8',11,2008,NULL,10,6390,1,10);
INSERT INTO Album VALUES(84,'album_7',11,2007,NULL,10,6390,1,10);
INSERT INTO Album VALUES(85,'album_6',11,2006,NULL,10,6390,1,10);
INSERT INTO Album VALUES(86,'album_5',11,2005,NULL,10,6390,1,10);
INSERT INTO Album VALUES(87,'album_4',11,2004,NULL,10,6390,1,10);
INSERT INTO Album VALUES(88,'album_3',11,2003,NULL,10,6390,1,10);
INSERT INTO Album VALUES(89,'album_2',11,2002,NULL,10,6390,1,10);
INSERT INTO Album VALUES(90,'album_1',11,2001,NULL,10,6390,1,10);
INSERT INTO Album VALUES(91,'album_10',12,2010,NULL,10,6390,1,10);
INSERT INTO Album VALUES(92,'album_9',12,2009,NULL,10,6390,1,10);
INSERT INTO Album VALUES(93,'album_8',12,2008,NULL,10,6390,1,10);
INSERT INTO Album VALUES(94,'album_7',12,2007,NULL,10,6390,1,10);
INSERT INTO Album VALUES(95,'album_6',12,2006,NULL,10,6390,1,10);
INSERT INTO Album VALUES(96,'album_5',12,2005,NULL,10,6390,1,10);
INSERT INTO Album VALUES(97,'album_4',12,2004,NULL,10,6390,1,10);
INSERT INTO Album VALUES(98,'album_3',12,2003,NULL,10,6390,1,10);
INSERT INTO Album VALUES(99,'album_2',12,2002,NULL,10,6390,1,10);
INSERT INTO Album VALUES(100,'album_1',12,2001,NULL,10,6390,1,10);
INSERT INTO Show VALUES(1,NULL,0,NULL,NULL,NULL,NULL,0);
INSERT INTO AudioTrack VALUES(1,'mpga',56000,44100,1,'','',1,NULL);
INSERT INTO AudioTrack VALUES(2,'mpga',56000,44100,1,'','',2,NULL);
INSERT INTO AudioTrack VALUES(3,'mpga',56000,44100,1,'','',3,NULL);
INSERT INTO AudioTrack VALUES(4,'mpga',56000,44100,1,'','',4,NULL);
INSERT INTO AudioTrack VALUES(5,'mpga',56000,44100,1,'','',5,NULL);
INSERT INTO AudioTrack VALUES(6,'mpga',56000,44100,1,'','',6,NULL);
INSERT INTO AudioTrack VALUES(7,'mpga',56000,44100,1,'','',7,NULL);
INSERT INTO AudioTrack VALUES(8,'mpga',56000,44100,1,'','',8,NULL);
INSERT INTO AudioTrack VALUES(9,'mpga',56000,44100,1,'','',9,NULL);
INSERT INTO AudioTrack VALUES(10,'mpga',56000,44100,1,'','',10,NULL);
INSERT INTO AudioTrack VALUES(11,'mpga',56000,44100,1,'','',11,NULL);
INSERT INTO AudioTrack VALUES(12,'mpga',56000,44100,1,'','',12,NULL);
INSERT INTO AudioTrack VALUES(13,'mpga',56000,44100,1,'','',13,NULL);
INSERT INTO AudioTrack VALUES(14,'mpga',56000,44100,1,'','',14,NULL);
INSERT INTO AudioTrack VALUES(15,'mpga',56000,44100,1,'','',15,NULL);
INSERT INTO AudioTrack VALUES(16,'mpga',56000,44100,1,'','',16,NULL);
INSERT INTO AudioTrack VALUES(17,'mpga',56000,44100,1,'','',17,NULL);
INSERT INTO AudioTrack VALUES(18,'mpga',56000,44100,1,'','',18,NULL);
INSERT INTO AudioTrack VALUES(19,'mpga',56000,44100,1,'','',19,NULL);
INSERT INTO AudioTrack VALUES(20,'mpga',56000,44100,1,'','',20,NULL);
INSERT INTO AudioTrack VALUES(21,'mpga',56000,44100,1,'','',21,NULL);
INSERT INTO AudioTrack VALUES(22,'mpga',56000,44100,1,'','',22,NULL);
INSERT INTO AudioTrack VALUES(23,'mpga',56000,44100,1,'','',23,NULL);
INSERT INTO AudioTrack VALUES(24,'mpga',56000,44100,1,'','',24,NULL);
INSERT INTO AudioTrack VALUES(25,'mpga',56000,44100,1,'','',25,NULL);
INSERT INTO AudioTrack VALUES(26,'mpga',56000,44100,1,'','',26,NULL);
INSERT INTO AudioTrack VALUES(27,'mpga',56000,44100,1,'','',27,NULL);
INSERT INTO AudioTrack VALUES(28,'mpga',56000,44100,1,'','',28,NULL);
INSERT INTO AudioTrack VALUES(29,'mpga',56000,44100,1,'','',29,NULL);
INSERT INTO AudioTrack VALUES(30,'mpga',56000,44100,1,'','',30,NULL);
INSERT INTO AudioTrack VALUES(31,'mpga',56000,44100,1,'','',31,NULL);
INSERT INTO AudioTrack VALUES(32,'mpga',56000,44100,1,'','',32,NULL);
INSERT INTO AudioTrack VALUES(33,'mpga',56000,44100,1,'','',33,NULL);
INSERT INTO AudioTrack VALUES(34,'mpga',56000,44100,1,'','',34,NULL);
INSERT INTO AudioTrack VALUES(35,'mpga',56000,44100,1,'','',35,NULL);
INSERT INTO AudioTrack VALUES(36,'mpga',56000,44100,1,'','',36,NULL);
INSERT INTO AudioTrack VALUES(37,'mpga',56000,44100,1,'','',37,NULL);
INSERT INTO AudioTrack VALUES(38,'mpga',56000,44100,1,'','',38,NULL);
INSERT INTO AudioTrack VALUES(39,'mpga',56000,44100,1,'','',39,NULL);
INSERT INTO AudioTrack VALUES(40,'mpga',56000,44100,1,'','',40,NULL);
INSERT INTO AudioTrack VALUES(41,'mpga',56000,44100,1,'','',41,NULL);
INSERT INTO AudioTrack VALUES(42,'mpga',56000,44100,1,'','',42,NULL);
INSERT INTO AudioTrack VALUES(43,'mpga',56000,44100,1,'','',43,NULL);
INSERT INTO AudioTrack VALUES(44,'mpga',56000,44100,1,'','',44,NULL);
INSERT INTO AudioTrack VALUES(45,'mpga',56000,44100,1,'','',45,NULL);
INSERT INTO AudioTrack VALUES(46,'mpga',56000,44100,1,'','',46,NULL);
INSERT INTO AudioTrack VALUES(47,'mpga',56000,44100,1,'','',47,NULL);
INSERT INTO AudioTrack VALUES(48,'mpga',56000,44100,1,'','',48,NULL);
INSERT INTO AudioTrack VALUES(49,'mpga',56000,44100,1,'','',49,NULL);
INSERT INTO AudioTrack VALUES(50,'mpga',56000,44100,1,'','',50,NULL);
INSERT INTO AudioTrack VALUES(51,'mpga',56000,44100,1,'','',51,NULL);
INSERT INTO AudioTrack VALUES(52,'mpga',56000,44100,1,'','',52,NULL);
INSERT INTO AudioTrack VALUES(53,'mpga',56000,44100,1,'','',53,NULL);
INSERT INTO AudioTrack VALUES(54,'mpga',56000,44100,1,'','',54,NULL);
INSERT INTO AudioTrack VALUES(55,'mpga',56000,44100,1,'','',55,NULL);
INSERT INTO AudioTrack VALUES(56,'mpga',56000,44100,1,'','',56,NULL);
INSERT INTO AudioTrack VALUES(57,'mpga',56000,44100,1,'','',57,NULL);
INSERT INTO AudioTrack VALUES(58,'mpga',56000,44100,1,'','',58,NULL);
INSERT INTO AudioTrack VALUES(59,'mpga',56000,44100,1,'','',59,NULL);
INSERT INTO AudioTrack VALUES(60,'mpga',56000,44100,1,'','',60,NULL);
INSERT INTO AudioTrack VALUES(61,'mpga',56000,44100,1,'','',61,NULL);
INSERT INTO AudioTrack VALUES(62,'mpga',56000,44100,1,'','',62,NULL);
INSERT INTO AudioTrack VALUES(63,'mpga',56000,44100,1,'','',63,NULL);
INSERT INTO AudioTrack VALUES(64,'mpga',56000,44100,1,'','',64,NULL);
INSERT INTO AudioTrack VALUES(65,'mpga',56000,44100,1,'','',65,NULL);
INSERT INTO AudioTrack VALUES(66,'mpga',56000,44100,1,'','',66,NULL);
INSERT INTO AudioTrack VALUES(67,'mpga',56000,44100,1,'','',67,NULL);
INSERT INTO AudioTrack VALUES(68,'mpga',56000,44100,1,'','',68,NULL);
INSERT INTO AudioTrack VALUES(69,'mpga',56000,44100,1,'','',69,NULL);
INSERT INTO AudioTrack VALUES(70,'mpga',56000,44100,1,'','',70,NULL);
INSERT INTO AudioTrack VALUES(71,'mpga',56000,44100,1,'','',71,NULL);
INSERT INTO AudioTrack VALUES(72,'mpga',56000,44100,1,'','',72,NULL);
INSERT INTO AudioTrack VALUES(73,'mpga',56000,44100,1,'','',73,NULL);
INSERT INTO AudioTrack VALUES(74,'mpga',56000,44100,1,'','',74,NULL);
INSERT INTO AudioTrack VALUES(75,'mpga',56000,44100,1,'','',75,NULL);
INSERT INTO AudioTrack VALUES(76,'mpga',56000,44100,1,'','',76,NULL);
INSERT INTO AudioTrack VALUES(77,'mpga',56000,44100,1,'','',77,NULL);
INSERT INTO AudioTrack VALUES(78,'mpga',56000,44100,1,'','',78,NULL);
INSERT INTO AudioTrack VALUES(79,'mpga',56000,44100,1,'','',79,NULL);
INSERT INTO AudioTrack VALUES(80,'mpga',56000,44100,1,'','',80,NULL);
INSERT INTO AudioTrack VALUES(81,'mpga',56000,44100,1,'','',81,NULL);
INSERT INTO AudioTrack VALUES(82,'mpga',56000,44100,1,'','',82,NULL);
INSERT INTO AudioTrack VALUES(83,'mpga',56000,44100,1,'','',83,NULL);
INSERT INTO AudioTrack VALUES(84,'mpga',56000,44100,1,'','',84,NULL);
INSERT INTO AudioTrack VALUES(85,'mpga',56000,44100,1,'','',85,NULL);
INSERT INTO AudioTrack VALUES(86,'mpga',56000,44100,1,'','',86,NULL);
INSERT INTO AudioTrack VALUES(87,'mpga',56000,44100,1,'','',87,NULL);
INSERT INTO AudioTrack VALUES(88,'mpga',56000,44100,1,'','',88,NULL);
INSERT INTO AudioTrack VALUES(89,'mpga',56000,44100,1,'','',89,NULL);
INSERT INTO AudioTrack VALUES(90,'mpga',56000,44100,1,'','',90,NULL);
INSERT INTO AudioTrack VALUES(91,'mpga',56000,44100,1,'','',91,NULL);
INSERT INTO AudioTrack VALUES(92,'mpga',56000,44100,1,'','',92,NULL);
INSERT INTO AudioTrack VALUES(93,'mpga',56000,44100,1,'','',93,NULL);
INSERT INTO AudioTrack VALUES(94,'mpga',56000,44100,1,'','',94,NULL);
INSERT INTO AudioTrack VALUES(95,'mpga',56000,44100,1,'','',95,NULL);
INSERT INTO AudioTrack VALUES(96,'mpga',56000,44100,1,'','',96,NULL);
INSERT INTO AudioTrack VALUES(97,'mpga',56000,44100,1,'','',97,NULL);
INSERT INTO AudioTrack VALUES(98,'mpga',56000,44100,1,'','',98,NULL);
INSERT INTO AudioTrack VALUES(99,'mpga',56000,44100,1,'','',99,NULL);
INSERT INTO AudioTrack VALUES(100,'mpga',56000,44100,1,'','',100,NULL);
INSERT INTO AudioTrack VALUES(101,'mpga',56000,44100,1,'','',101,NULL);
INSERT INTO AudioTrack VALUES(102,'mpga',56000,44100,1,'','',102,NULL);
INSERT INTO AudioTrack VALUES(103,'mpga',56000,44100,1,'','',103,NULL);
INSERT INTO AudioTrack VALUES(104,'mpga',56000,44100,1,'','',104,NULL);
INSERT INTO AudioTrack VALUES(105,'mpga',56000,44100,1,'','',105,NULL);
INSERT INTO AudioTrack VALUES(106,'mpga',56000,44100,1,'','',106,NULL);
INSERT INTO AudioTrack VALUES(107,'mpga',56000,44100,1,'','',107,NULL);
INSERT INTO AudioTrack VALUES(108,'mpga',56000,44100,1,'','',108,NULL);
INSERT INTO AudioTrack VALUES(109,'mpga',56000,44100,1,'','',109,NULL);
INSERT INTO AudioTrack VALUES(110,'mpga',56000,44100,1,'','',110,NULL);
INSERT INTO AudioTrack VALUES(111,'mpga',56000,44100,1,'','',111,NULL);
INSERT INTO AudioTrack VALUES(112,'mpga',56000,44100,1,'','',112,NULL);
INSERT INTO AudioTrack VALUES(113,'mpga',56000,44100,1,'','',113,NULL);
INSERT INTO AudioTrack VALUES(114,'mpga',56000,44100,1,'','',114,NULL);
INSERT INTO AudioTrack VALUES(115,'mpga',56000,44100,1,'','',115,NULL);
INSERT INTO AudioTrack VALUES(116,'mpga',56000,44100,1,'','',116,NULL);
INSERT INTO AudioTrack VALUES(117,'mpga',56000,44100,1,'','',117,NULL);
INSERT INTO AudioTrack VALUES(118,'mpga',56000,44100,1,'','',118,NULL);
INSERT INTO AudioTrack VALUES(119,'mpga',56000,44100,1,'','',119,NULL);
INSERT INTO AudioTrack VALUES(120,'mpga',56000,44100,1,'','',120,NULL);
INSERT INTO AudioTrack VALUES(121,'mpga',56000,44100,1,'','',121,NULL);
INSERT INTO AudioTrack VALUES(122,'mpga',56000,44100,1,'','',122,NULL);
INSERT INTO AudioTrack VALUES(123,'mpga',56000,44100,1,'','',123,NULL);
INSERT INTO AudioTrack VALUES(124,'mpga',56000,44100,1,'','',124,NULL);
INSERT INTO AudioTrack VALUES(125,'mpga',56000,44100,1,'','',125,NULL);
INSERT INTO AudioTrack VALUES(126,'mpga',56000,44100,1,'','',126,NULL);
INSERT INTO AudioTrack VALUES(127,'mpga',56000,44100,1,'','',127,NULL);
INSERT INTO AudioTrack VALUES(128,'mpga',56000,44100,1,'','',128,NULL);
INSERT INTO AudioTrack VALUES(129,'mpga',56000,44100,1,'','',129,NULL);
INSERT INTO AudioTrack VALUES(130,'mpga',56000,44100,1,'','',130,NULL);
INSERT INTO AudioTrack VALUES(131,'mpga',56000,44100,1,'','',131,NULL);
INSERT INTO AudioTrack VALUES(132,'mpga',56000,44100,1,'','',132,NULL);
INSERT INTO AudioTrack VALUES(133,'mpga',56000,44100,1,'','',133,NULL);
INSERT INTO AudioTrack VALUES(134,'mpga',56000,44100,1,'','',134,NULL);
INSERT INTO AudioTrack VALUES(135,'mpga',56000,44100,1,'','',135,NULL);
INSERT INTO AudioTrack VALUES(136,'mpga',56000,44100,1,'','',136,NULL);
INSERT INTO AudioTrack VALUES(137,'mpga',56000,44100,1,'','',137,NULL);
INSERT INTO AudioTrack VALUES(138,'mpga',56000,44100,1,'','',138,NULL);
INSERT INTO AudioTrack VALUES(139,'mpga',56000,44100,1,'','',139,NULL);
INSERT INTO AudioTrack VALUES(140,'mpga',56000,44100,1,'','',140,NULL);
INSERT INTO AudioTrack VALUES(141,'mpga',56000,44100,1,'','',141,NULL);
INSERT INTO AudioTrack VALUES(142,'mpga',56000,44100,1,'','',142,NULL);
INSERT INTO AudioTrack VALUES(143,'mpga',56000,44100,1,'','',143,NULL);
INSERT INTO AudioTrack VALUES(144,'mpga',56000,44100,1,'','',144,NULL);
INSERT INTO AudioTrack VALUES(145,'mpga',56000,44100,1,'','',145,NULL);
INSERT INTO AudioTrack VALUES(146,'mpga',56000,44100,1,'','',146,NULL);
INSERT INTO AudioTrack VALUES(147,'mpga',56000,44100,1,'','',147,NULL);
INSERT INTO AudioTrack VALUES(148,'mpga',56000,44100,1,'','',148,NULL);
INSERT INTO AudioTrack VALUES(149,'mpga',56000,44100,1,'','',149,NULL);
INSERT INTO AudioTrack VALUES(150,'mpga',56000,44100,1,'','',150,NULL);
INSERT INTO AudioTrack VALUES(151,'mpga',56000,44100,1,'','',151,NULL);
INSERT INTO AudioTrack VALUES(152,'mpga',56000,44100,1,'','',152,NULL);
INSERT INTO AudioTrack VALUES(153,'mpga',56000,44100,1,'','',153,NULL);
INSERT INTO AudioTrack VALUES(154,'mpga',56000,44100,1,'','',154,NULL);
INSERT INTO AudioTrack VALUES(155,'mpga',56000,44100,1,'','',155,NULL);
INSERT INTO AudioTrack VALUES(156,'mpga',56000,44100,1,'','',156,NULL);
INSERT INTO AudioTrack VALUES(157,'mpga',56000,44100,1,'','',157,NULL);
INSERT INTO AudioTrack VALUES(158,'mpga',56000,44100,1,'','',158,NULL);
INSERT INTO AudioTrack VALUES(159,'mpga',56000,44100,1,'','',159,NULL);
INSERT INTO AudioTrack VALUES(160,'mpga',56000,44100,1,'','',160,NULL);
INSERT INTO AudioTrack VALUES(161,'mpga',56000,44100,1,'','',161,NULL);
INSERT INTO AudioTrack VALUES(162,'mpga',56000,44100,1,'','',162,NULL);
INSERT INTO AudioTrack VALUES(163,'mpga',56000,44100,1,'','',163,NULL);
INSERT INTO AudioTrack VALUES(164,'mpga',56000,44100,1,'','',164,NULL);
INSERT INTO AudioTrack VALUES(165,'mpga',56000,44100,1,'','',165,NULL);
INSERT INTO AudioTrack VALUES(166,'mpga',56000,44100,1,'','',166,NULL);
INSERT INTO AudioTrack VALUES(167,'mpga',56000,44100,1,'','',167,NULL);
INSERT INTO AudioTrack VALUES(168,'mpga',56000,44100,1,'','',168,NULL);
INSERT INTO AudioTrack VALUES(169,'mpga',56000,44100,1,'','',169,NULL);
INSERT INTO AudioTrack VALUES(170,'mpga',56000,44100,1,'','',170,NULL);
INSERT INTO AudioTrack VALUES(171,'mpga',56000,44100,1,'','',171,NULL);
INSERT INTO AudioTrack VALUES(172,'mpga',56000,44100,1,'','',172,NULL);
INSERT INTO AudioTrack VALUES(173,'mpga',56000,44100,1,'','',173,NULL);
INSERT INTO AudioTrack VALUES(174,'mpga',56000,44100,1,'','',174,NULL);
INSERT INTO AudioTrack VALUES(175,'mpga',56000,44100,1,'','',175,NULL);
INSERT INTO AudioTrack VALUES(176,'mpga',56000,44100,1,'','',176,NULL);
INSERT INTO AudioTrack VALUES(177,'mpga',56000,44100,1,'','',177,NULL);
INSERT INTO AudioTrack VALUES(178,'mpga',56000,44100,1,'','',178,NULL);
INSERT INTO AudioTrack VALUES(179,'mpga',56000,44100,1,'','',179,NULL);
INSERT INTO AudioTrack VALUES(180,'mpga',56000,44100,1,'','',180,NULL);
INSERT INTO AudioTrack VALUES(181,'mpga',56000,44100,1,'','',181,NULL);
INSERT INTO AudioTrack VALUES(182,'mpga',56000,44100,1,'','',182,NULL);
INSERT INTO AudioTrack VALUES(183,'mpga',56000,44100,1,'','',183,NULL);
INSERT INTO AudioTrack VALUES(184,'mpga',56000,44100,1,'','',184,NULL);
INSERT INTO AudioTrack VALUES(185,'mpga',56000,44100,1,'','',185,NULL);
INSERT INTO AudioTrack VALUES(186,'mpga',56000,44100,1,'','',186,NULL);
INSERT INTO AudioTrack VALUES(187,'mpga',56000,44100,1,'','',187,NULL);
INSERT INTO AudioTrack VALUES(188,'mpga',56000,44100,1,'','',188,NULL);
INSERT INTO AudioTrack VALUES(189,'mpga',56000,44100,1,'','',189,NULL);
INSERT INTO AudioTrack VALUES(190,'mpga',56000,44100,1,'','',190,NULL);
INSERT INTO AudioTrack VALUES(191,'mpga',56000,44100,1,'','',191,NULL);
INSERT INTO AudioTrack VALUES(192,'mpga',56000,44100,1,'','',192,NULL);
INSERT INTO AudioTrack VALUES(193,'mpga',56000,44100,1,'','',193,NULL);
INSERT INTO AudioTrack VALUES(194,'mpga',56000,44100,1,'','',194,NULL);
INSERT INTO AudioTrack VALUES(195,'mpga',56000,44100,1,'','',195,NULL);
INSERT INTO AudioTrack VALUES(196,'mpga',56000,44100,1,'','',196,NULL);
INSERT INTO AudioTrack VALUES(197,'mpga',56000,44100,1,'','',197,NULL);
INSERT INTO AudioTrack VALUES(198,'mpga',56000,44100,1,'','',198,NULL);
INSERT INTO AudioTrack VALUES(199,'mpga',56000,44100,1,'','',199,NULL);
INSERT INTO AudioTrack VALUES(200,'mpga',56000,44100,1,'','',200,NULL);
INSERT INTO AudioTrack VALUES(201,'mpga',56000,44100,1,'','',201,NULL);
INSERT INTO AudioTrack VALUES(202,'mpga',56000,44100,1,'','',202,NULL);
INSERT INTO AudioTrack VALUES(203,'mpga',56000,44100,1,'','',203,NULL);
INSERT INTO AudioTrack VALUES(204,'mpga',56000,44100,1,'','',204,NULL);
INSERT INTO AudioTrack VALUES(205,'mpga',56000,44100,1,'','',205,NULL);
INSERT INTO AudioTrack VALUES(206,'mpga',56000,44100,1,'','',206,NULL);
INSERT INTO AudioTrack VALUES(207,'mpga',56000,44100,1,'','',207,NULL);
INSERT INTO AudioTrack VALUES(208,'mpga',56000,44100,1,'','',208,NULL);
INSERT INTO AudioTrack VALUES(209,'mpga',56000,44100,1,'','',209,NULL);
INSERT INTO AudioTrack VALUES(210,'mpga',56000,44100,1,'','',210,NULL);
INSERT INTO AudioTrack VALUES(211,'mpga',56000,44100,1,'','',211,NULL);
INSERT INTO AudioTrack VALUES(212,'mpga',56000,44100,1,'','',212,NULL);
INSERT INTO AudioTrack VALUES(213,'mpga',56000,44100,1,'','',213,NULL);
INSERT INTO AudioTrack VALUES(214,'mpga',56000,44100,1,'','',214,NULL);
INSERT INTO AudioTrack VALUES(215,'mpga',56000,44100,1,'','',215,NULL);
INSERT INTO AudioTrack VALUES(216,'mpga',56000,44100,1,'','',216,NULL);
INSERT INTO AudioTrack VALUES(217,'mpga',56000,44100,1,'','',217,NULL);
INSERT INTO AudioTrack VALUES(218,'mpga',56000,44100,1,'','',218,NULL);
INSERT INTO AudioTrack VALUES(219,'mpga',56000,44100,1,'','',219,NULL);
INSERT INTO AudioTrack VALUES(220,'mpga',56000,44100,1,'','',220,NULL);
INSERT INTO AudioTrack VALUES(221,'mpga',56000,44100,1,'','',221,NULL);
INSERT INTO AudioTrack VALUES(222,'mpga',56000,44100,1,'','',222,NULL);
INSERT INTO AudioTrack VALUES(223,'mpga',56000,44100,1,'','',223,NULL);
INSERT INTO AudioTrack VALUES(224,'mpga',56000,44100,1,'','',224,NULL);
INSERT INTO AudioTrack VALUES(225,'mpga',56000,44100,1,'','',225,NULL);
INSERT INTO AudioTrack VALUES(226,'mpga',56000,44100,1,'','',226,NULL);
INSERT INTO AudioTrack VALUES(227,'mpga',56000,44100,1,'','',227,NULL);
INSERT INTO AudioTrack VALUES(228,'mpga',56000,44100,1,'','',228,NULL);
INSERT INTO AudioTrack VALUES(229,'mpga',56000,44100,1,'','',229,NULL);
INSERT INTO AudioTrack VALUES(230,'mpga',56000,44100,1,'','',230,NULL);
INSERT INTO AudioTrack VALUES(231,'mpga',56000,44100,1,'','',231,NULL);
INSERT INTO AudioTrack VALUES(232,'mpga',56000,44100,1,'','',232,NULL);
INSERT INTO AudioTrack VALUES(233,'mpga',56000,44100,1,'','',233,NULL);
INSERT INTO AudioTrack VALUES(234,'mpga',56000,44100,1,'','',234,NULL);
INSERT INTO AudioTrack VALUES(235,'mpga',56000,44100,1,'','',235,NULL);
INSERT INTO AudioTrack VALUES(236,'mpga',56000,44100,1,'','',236,NULL);
INSERT INTO AudioTrack VALUES(237,'mpga',56000,44100,1,'','',237,NULL);
INSERT INTO AudioTrack VALUES(238,'mpga',56000,44100,1,'','',238,NULL);
INSERT INTO AudioTrack VALUES(239,'mpga',56000,44100,1,'','',239,NULL);
INSERT INTO AudioTrack VALUES(240,'mpga',56000,44100,1,'','',240,NULL);
INSERT INTO AudioTrack VALUES(241,'mpga',56000,44100,1,'','',241,NULL);
INSERT INTO AudioTrack VALUES(242,'mpga',56000,44100,1,'','',242,NULL);
INSERT INTO AudioTrack VALUES(243,'mpga',56000,44100,1,'','',243,NULL);
INSERT INTO AudioTrack VALUES(244,'mpga',56000,44100,1,'','',244,NULL);
INSERT INTO AudioTrack VALUES(245,'mpga',56000,44100,1,'','',245,NULL);
INSERT INTO AudioTrack VALUES(246,'mpga',56000,44100,1,'','',246,NULL);
INSERT INTO AudioTrack VALUES(247,'mpga',56000,44100,1,'','',247,NULL);
INSERT INTO AudioTrack VALUES(248,'mpga',56000,44100,1,'','',248,NULL);
INSERT INTO AudioTrack VALUES(249,'mpga',56000,44100,1,'','',249,NULL);
INSERT INTO AudioTrack VALUES(250,'mpga',56000,44100,1,'','',250,NULL);
INSERT INTO AudioTrack VALUES(251,'mpga',56000,44100,1,'','',251,NULL);
INSERT INTO AudioTrack VALUES(252,'mpga',56000,44100,1,'','',252,NULL);
INSERT INTO AudioTrack VALUES(253,'mpga',56000,44100,1,'','',253,NULL);
INSERT INTO AudioTrack VALUES(254,'mpga',56000,44100,1,'','',254,NULL);
INSERT INTO AudioTrack VALUES(255,'mpga',56000,44100,1,'','',255,NULL);
INSERT INTO AudioTrack VALUES(256,'mpga',56000,44100,1,'','',256,NULL);
INSERT INTO AudioTrack VALUES(257,'mpga',56000,44100,1,'','',257,NULL);
INSERT INTO AudioTrack VALUES(258,'mpga',56000,44100,1,'','',258,NULL);
INSERT INTO AudioTrack VALUES(259,'mpga',56000,44100,1,'','',259,NULL);
INSERT INTO AudioTrack VALUES(260,'mpga',56000,44100,1,'','',260,NULL);
INSERT INTO AudioTrack VALUES(261,'mpga',56000,44100,1,'','',261,NULL);
INSERT INTO AudioTrack VALUES(262,'mpga',56000,44100,1,'','',262,NULL);
INSERT INTO AudioTrack VALUES(263,'mpga',56000,44100,1,'','',263,NULL);
INSERT INTO AudioTrack VALUES(264,'mpga',56000,44100,1,'','',264,NULL);
INSERT INTO AudioTrack VALUES(265,'mpga',56000,44100,1,'','',265,NULL);
INSERT INTO AudioTrack VALUES(266,'mpga',56000,44100,1,'','',266,NULL);
INSERT INTO AudioTrack VALUES(267,'mpga',56000,44100,1,'','',267,NULL);
INSERT INTO AudioTrack VALUES(268,'mpga',56000,44100,1,'','',268,NULL);
INSERT INTO AudioTrack VALUES(269,'mpga',56000,44100,1,'','',269,NULL);
INSERT INTO AudioTrack VALUES(270,'mpga',56000,44100,1,'','',270,NULL);
INSERT INTO AudioTrack VALUES(271,'mpga',56000,44100,1,'','',271,NULL);
INSERT INTO AudioTrack VALUES(272,'mpga',56000,44100,1,'','',272,NULL);
INSERT INTO AudioTrack VALUES(273,'mpga',56000,44100,1,'','',273,NULL);
INSERT INTO AudioTrack VALUES(274,'mpga',56000,44100,1,'','',274,NULL);
INSERT INTO AudioTrack VALUES(275,'mpga',56000,44100,1,'','',275,NULL);
INSERT INTO AudioTrack VALUES(276,'mpga',56000,44100,1,'','',276,NULL);
INSERT INTO AudioTrack VALUES(277,'mpga',56000,44100,1,'','',277,NULL);
INSERT INTO AudioTrack VALUES(278,'mpga',56000,44100,1,'','',278,NULL);
INSERT INTO AudioTrack VALUES(279,'mpga',56000,44100,1,'','',279,NULL);
INSERT INTO AudioTrack VALUES(280,'mpga',56000,44100,1,'','',280,NULL);
INSERT INTO AudioTrack VALUES(281,'mpga',56000,44100,1,'','',281,NULL);
INSERT INTO AudioTrack VALUES(282,'mpga',56000,44100,1,'','',282,NULL);
INSERT INTO AudioTrack VALUES(283,'mpga',56000,44100,1,'','',283,NULL);
INSERT INTO AudioTrack VALUES(284,'mpga',56000,44100,1,'','',284,NULL);
INSERT INTO AudioTrack VALUES(285,'mpga',56000,44100,1,'','',285,NULL);
INSERT INTO AudioTrack VALUES(286,'mpga',56000,44100,1,'','',286,NULL);
INSERT INTO AudioTrack VALUES(287,'mpga',56000,44100,1,'','',287,NULL);
INSERT INTO AudioTrack VALUES(288,'mpga',56000,44100,1,'','',288,NULL);
INSERT INTO AudioTrack VALUES(289,'mpga',56000,44100,1,'','',289,NULL);
INSERT INTO AudioTrack VALUES(290,'mpga',56000,44100,1,'','',290,NULL);
INSERT INTO AudioTrack VALUES(291,'mpga',56000,44100,1,'','',291,NULL);
INSERT INTO AudioTrack VALUES(292,'mpga',56000,44100,1,'','',292,NULL);
INSERT INTO AudioTrack VALUES(293,'mpga',56000,44100,1,'','',293,NULL);
INSERT INTO AudioTrack VALUES(294,'mpga',56000,44100,1,'','',294,NULL);
INSERT INTO AudioTrack VALUES(295,'mpga',56000,44100,1,'','',295,NULL);
INSERT INTO AudioTrack VALUES(296,'mpga',56000,44100,1,'','',296,NULL);
INSERT INTO AudioTrack VALUES(297,'mpga',56000,44100,1,'','',297,NULL);
INSERT INTO AudioTrack VALUES(298,'mpga',56000,44100,1,'','',298,NULL);
INSERT INTO AudioTrack VALUES(299,'mpga',56000,44100,1,'','',299,NULL);
INSERT INTO AudioTrack VALUES(300,'mpga',56000,44100,1,'','',300,NULL);
INSERT INTO AudioTrack VALUES(301,'mpga',56000,44100,1,'','',301,NULL);
INSERT INTO AudioTrack VALUES(302,'mpga',56000,44100,1,'','',302,NULL);
INSERT INTO AudioTrack VALUES(303,'mpga',56000,44100,1,'','',303,NULL);
INSERT INTO AudioTrack VALUES(304,'mpga',56000,44100,1,'','',304,NULL);
INSERT INTO AudioTrack VALUES(305,'mpga',56000,44100,1,'','',305,NULL);
INSERT INTO AudioTrack VALUES(306,'mpga',56000,44100,1,'','',306,NULL);
INSERT INTO AudioTrack VALUES(307,'mpga',56000,44100,1,'','',307,NULL);
INSERT INTO AudioTrack VALUES(308,'mpga',56000,44100,1,'','',308,NULL);
INSERT INTO AudioTrack VALUES(309,'mpga',56000,44100,1,'','',309,NULL);
INSERT INTO AudioTrack VALUES(310,'mpga',56000,44100,1,'','',310,NULL);
INSERT INTO AudioTrack VALUES(311,'mpga',56000,44100,1,'','',311,NULL);
INSERT INTO AudioTrack VALUES(312,'mpga',56000,44100,1,'','',312,NULL);
INSERT INTO AudioTrack VALUES(313,'mpga',56000,44100,1,'','',313,NULL);
INSERT INTO AudioTrack VALUES(314,'mpga',56000,44100,1,'','',314,NULL);
INSERT INTO AudioTrack VALUES(315,'mpga',56000,44100,1,'','',315,NULL);
INSERT INTO AudioTrack VALUES(316,'mpga',56000,44100,1,'','',316,NULL);
INSERT INTO AudioTrack VALUES(317,'mpga',56000,44100,1,'','',317,NULL);
INSERT INTO AudioTrack VALUES(318,'mpga',56000,44100,1,'','',318,NULL);
INSERT INTO AudioTrack VALUES(319,'mpga',56000,44100,1,'','',319,NULL);
INSERT INTO AudioTrack VALUES(320,'mpga',56000,44100,1,'','',320,NULL);
INSERT INTO AudioTrack VALUES(321,'mpga',56000,44100,1,'','',321,NULL);
INSERT INTO AudioTrack VALUES(322,'mpga',56000,44100,1,'','',322,NULL);
INSERT INTO AudioTrack VALUES(323,'mpga',56000,44100,1,'','',323,NULL);
INSERT INTO AudioTrack VALUES(324,'mpga',56000,44100,1,'','',324,NULL);
INSERT INTO AudioTrack VALUES(325,'mpga',56000,44100,1,'','',325,NULL);
INSERT INTO AudioTrack VALUES(326,'mpga',56000,44100,1,'','',326,NULL);
INSERT INTO AudioTrack VALUES(327,'mpga',56000,44100,1,'','',327,NULL);
INSERT INTO AudioTrack VALUES(328,'mpga',56000,44100,1,'','',328,NULL);
INSERT INTO AudioTrack VALUES(329,'mpga',56000,44100,1,'','',329,NULL);
INSERT INTO AudioTrack VALUES(330,'mpga',56000,44100,1,'','',330,NULL);
INSERT INTO AudioTrack VALUES(331,'mpga',56000,44100,1,'','',331,NULL);
INSERT INTO AudioTrack VALUES(332,'mpga',56000,44100,1,'','',332,NULL);
INSERT INTO AudioTrack VALUES(333,'mpga',56000,44100,1,'','',333,NULL);
INSERT INTO AudioTrack VALUES(334,'mpga',56000,44100,1,'','',334,NULL);
INSERT INTO AudioTrack VALUES(335,'mpga',56000,44100,1,'','',335,NULL);
INSERT INTO AudioTrack VALUES(336,'mpga',56000,44100,1,'','',336,NULL);
INSERT INTO AudioTrack VALUES(337,'mpga',56000,44100,1,'','',337,NULL);
INSERT INTO AudioTrack VALUES(338,'mpga',56000,44100,1,'','',338,NULL);
INSERT INTO AudioTrack VALUES(339,'mpga',56000,44100,1,'','',339,NULL);
INSERT INTO AudioTrack VALUES(340,'mpga',56000,44100,1,'','',340,NULL);
INSERT INTO AudioTrack VALUES(341,'mpga',56000,44100,1,'','',341,NULL);
INSERT INTO AudioTrack VALUES(342,'mpga',56000,44100,1,'','',342,NULL);
INSERT INTO AudioTrack VALUES(343,'mpga',56000,44100,1,'','',343,NULL);
INSERT INTO AudioTrack VALUES(344,'mpga',56000,44100,1,'','',344,NULL);
INSERT INTO AudioTrack VALUES(345,'mpga',56000,44100,1,'','',345,NULL);
INSERT INTO AudioTrack VALUES(346,'mpga',56000,44100,1,'','',346,NULL);
INSERT INTO AudioTrack VALUES(347,'mpga',56000,44100,1,'','',347,NULL);
INSERT INTO AudioTrack VALUES(348,'mpga',56000,44100,1,'','',348,NULL);
INSERT INTO AudioTrack VALUES(349,'mpga',56000,44100,1,'','',349,NULL);
INSERT INTO AudioTrack VALUES(350,'mpga',56000,44100,1,'','',350,NULL);
INSERT INTO AudioTrack VALUES(351,'mpga',56000,44100,1,'','',351,NULL);
INSERT INTO AudioTrack VALUES(352,'mpga',56000,44100,1,'','',352,NULL);
INSERT INTO AudioTrack VALUES(353,'mpga',56000,44100,1,'','',353,NULL);
INSERT INTO AudioTrack VALUES(354,'mpga',56000,44100,1,'','',354,NULL);
INSERT INTO AudioTrack VALUES(355,'mpga',56000,44100,1,'','',355,NULL);
INSERT INTO AudioTrack VALUES(356,'mpga',56000,44100,1,'','',356,NULL);
INSERT INTO AudioTrack VALUES(357,'mpga',56000,44100,1,'','',357,NULL);
INSERT INTO AudioTrack VALUES(358,'mpga',56000,44100,1,'','',358,NULL);
INSERT INTO AudioTrack VALUES(359,'mpga',56000,44100,1,'','',359,NULL);
INSERT INTO AudioTrack VALUES(360,'mpga',56000,44100,1,'','',360,NULL);
INSERT INTO AudioTrack VALUES(361,'mpga',56000,44100,1,'','',361,NULL);
INSERT INTO AudioTrack VALUES(362,'mpga',56000,44100,1,'','',362,NULL);
INSERT INTO AudioTrack VALUES(363,'mpga',56000,44100,1,'','',363,NULL);
INSERT INTO AudioTrack VALUES(364,'mpga',56000,44100,1,'','',364,NULL);
INSERT INTO AudioTrack VALUES(365,'mpga',56000,44100,1,'','',365,NULL);
INSERT INTO AudioTrack VALUES(366,'mpga',56000,44100,1,'','',366,NULL);
INSERT INTO AudioTrack VALUES(367,'mpga',56000,44100,1,'','',367,NULL);
INSERT INTO AudioTrack VALUES(368,'mpga',56000,44100,1,'','',368,NULL);
INSERT INTO AudioTrack VALUES(369,'mpga',56000,44100,1,'','',369,NULL);
INSERT INTO AudioTrack VALUES(370,'mpga',56000,44100,1,'','',370,NULL);
INSERT INTO AudioTrack VALUES(371,'mpga',56000,44100,1,'','',371,NULL);
INSERT INTO AudioTrack VALUES(372,'mpga',56000,44100,1,'','',372,NULL);
INSERT INTO AudioTrack VALUES(373,'mpga',56000,44100,1,'','',373,NULL);
INSERT INTO AudioTrack VALUES(374,'mpga',56000,44100,1,'','',374,NULL);
INSERT INTO AudioTrack VALUES(375,'mpga',56000,44100,1,'','',375,NULL);
INSERT INTO AudioTrack VALUES(376,'mpga',56000,44100,1,'','',376,NULL);
INSERT INTO AudioTrack VALUES(377,'mpga',56000,44100,1,'','',377,NULL);
INSERT INTO AudioTrack VALUES(378,'mpga',56000,44100,1,'','',378,NULL);
INSERT INTO AudioTrack VALUES(379,'mpga',56000,44100,1,'','',379,NULL);
INSERT INTO AudioTrack VALUES(380,'mpga',56000,44100,1,'','',380,NULL);
INSERT INTO AudioTrack VALUES(381,'mpga',56000,44100,1,'','',381,NULL);
INSERT INTO AudioTrack VALUES(382,'mpga',56000,44100,1,'','',382,NULL);
INSERT INTO AudioTrack VALUES(383,'mpga',56000,44100,1,'','',383,NULL);
INSERT INTO AudioTrack VALUES(384,'mpga',56000,44100,1,'','',384,NULL);
INSERT INTO AudioTrack VALUES(385,'mpga',56000,44100,1,'','',385,NULL);
INSERT INTO AudioTrack VALUES(386,'mpga',56000,44100,1,'','',386,NULL);
INSERT INTO AudioTrack VALUES(387,'mpga',56000,44100,1,'','',387,NULL);
INSERT INTO AudioTrack VALUES(388,'mpga',56000,44100,1,'','',388,NULL);
INSERT INTO AudioTrack VALUES(389,'mpga',56000,44100,1,'','',389,NULL);
INSERT INTO AudioTrack VALUES(390,'mpga',56000,44100,1,'','',390,NULL);
INSERT INTO AudioTrack VALUES(391,'mpga',56000,44100,1,'','',391,NULL);
INSERT INTO AudioTrack VALUES(392,'mpga',56000,44100,1,'','',392,NULL);
INSERT INTO AudioTrack VALUES(393,'mpga',56000,44100,1,'','',393,NULL);
INSERT INTO AudioTrack VALUES(394,'mpga',56000,44100,1,'','',394,NULL);
INSERT INTO AudioTrack VALUES(395,'mpga',56000,44100,1,'','',395,NULL);
INSERT INTO AudioTrack VALUES(396,'mpga',56000,44100,1,'','',396,NULL);
INSERT INTO AudioTrack VALUES(397,'mpga',56000,44100,1,'','',397,NULL);
INSERT INTO AudioTrack VALUES(398,'mpga',56000,44100,1,'','',398,NULL);
INSERT INTO AudioTrack VALUES(399,'mpga',56000,44100,1,'','',399,NULL);
INSERT INTO AudioTrack VALUES(400,'mpga',56000,44100,1,'','',400,NULL);
INSERT INTO AudioTrack VALUES(401,'mpga',56000,44100,1,'','',401,NULL);
INSERT INTO AudioTrack VALUES(402,'mpga',56000,44100,1,'','',402,NULL);
INSERT INTO AudioTrack VALUES(403,'mpga',56000,44100,1,'','',403,NULL);
INSERT INTO AudioTrack VALUES(404,'mpga',56000,44100,1,'','',404,NULL);
INSERT INTO AudioTrack VALUES(405,'mpga',56000,44100,1,'','',405,NULL);
INSERT INTO AudioTrack VALUES(406,'mpga',56000,44100,1,'','',406,NULL);
INSERT INTO AudioTrack VALUES(407,'mpga',56000,44100,1,'','',407,NULL);
INSERT INTO AudioTrack VALUES(408,'mpga',56000,44100,1,'','',408,NULL);
INSERT INTO AudioTrack VALUES(409,'mpga',56000,44100,1,'','',409,NULL);
INSERT INTO AudioTrack VALUES(410,'mpga',56000,44100,1,'','',410,NULL);
INSERT INTO AudioTrack VALUES(411,'mpga',56000,44100,1,'','',411,NULL);
INSERT INTO AudioTrack VALUES(412,'mpga',56000,44100,1,'','',412,NULL);
INSERT INTO AudioTrack VALUES(413,'mpga',56000,44100,1,'','',413,NULL);
INSERT INTO AudioTrack VALUES(414,'mpga',56000,44100,1,'','',414,NULL);
INSERT INTO AudioTrack VALUES(415,'mpga',56000,44100,1,'','',415,NULL);
INSERT INTO AudioTrack VALUES(416,'mpga',56000,44100,1,'','',416,NULL);
INSERT INTO AudioTrack VALUES(417,'mpga',56000,44100,1,'','',417,NULL);
INSERT INTO AudioTrack VALUES(418,'mpga',56000,44100,1,'','',418,NULL);
INSERT INTO AudioTrack VALUES(419,'mpga',56000,44100,1,'','',419,NULL);
INSERT INTO AudioTrack VALUES(420,'mpga',56000,44100,1,'','',420,NULL);
INSERT INTO AudioTrack VALUES(421,'mpga',56000,44100,1,'','',421,NULL);
INSERT INTO AudioTrack VALUES(422,'mpga',56000,44100,1,'','',422,NULL);
INSERT INTO AudioTrack VALUES(423,'mpga',56000,44100,1,'','',423,NULL);
INSERT INTO AudioTrack VALUES(424,'mpga',56000,44100,1,'','',424,NULL);
INSERT INTO AudioTrack VALUES(425,'mpga',56000,44100,1,'','',425,NULL);
INSERT INTO AudioTrack VALUES(426,'mpga',56000,44100,1,'','',426,NULL);
INSERT INTO AudioTrack VALUES(427,'mpga',56000,44100,1,'','',427,NULL);
INSERT INTO AudioTrack VALUES(428,'mpga',56000,44100,1,'','',428,NULL);
INSERT INTO AudioTrack VALUES(429,'mpga',56000,44100,1,'','',429,NULL);
INSERT INTO AudioTrack VALUES(430,'mpga',56000,44100,1,'','',430,NULL);
INSERT INTO AudioTrack VALUES(431,'mpga',56000,44100,1,'','',431,NULL);
INSERT INTO AudioTrack VALUES(432,'mpga',56000,44100,1,'','',432,NULL);
INSERT INTO AudioTrack VALUES(433,'mpga',56000,44100,1,'','',433,NULL);
INSERT INTO AudioTrack VALUES(434,'mpga',56000,44100,1,'','',434,NULL);
INSERT INTO AudioTrack VALUES(435,'mpga',56000,44100,1,'','',435,NULL);
INSERT INTO AudioTrack VALUES(436,'mpga',56000,44100,1,'','',436,NULL);
INSERT INTO AudioTrack VALUES(437,'mpga',56000,44100,1,'','',437,NULL);
INSERT INTO AudioTrack VALUES(438,'mpga',56000,44100,1,'','',438,NULL);
INSERT INTO AudioTrack VALUES(439,'mpga',56000,44100,1,'','',439,NULL);
INSERT INTO AudioTrack VALUES(440,'mpga',56000,44100,1,'','',440,NULL);
INSERT INTO AudioTrack VALUES(441,'mpga',56000,44100,1,'','',441,NULL);
INSERT INTO AudioTrack VALUES(442,'mpga',56000,44100,1,'','',442,NULL);
INSERT INTO AudioTrack VALUES(443,'mpga',56000,44100,1,'','',443,NULL);
INSERT INTO AudioTrack VALUES(444,'mpga',56000,44100,1,'','',444,NULL);
INSERT INTO AudioTrack VALUES(445,'mpga',56000,44100,1,'','',445,NULL);
INSERT INTO AudioTrack VALUES(446,'mpga',56000,44100,1,'','',446,NULL);
INSERT INTO AudioTrack VALUES(447,'mpga',56000,44100,1,'','',447,NULL);
INSERT INTO AudioTrack VALUES(448,'mpga',56000,44100,1,'','',448,NULL);
INSERT INTO AudioTrack VALUES(449,'mpga',56000,44100,1,'','',449,NULL);
INSERT INTO AudioTrack VALUES(450,'mpga',56000,44100,1,'','',450,NULL);
INSERT INTO AudioTrack VALUES(451,'mpga',56000,44100,1,'','',451,NULL);
INSERT INTO AudioTrack VALUES(452,'mpga',56000,44100,1,'','',452,NULL);
INSERT INTO AudioTrack VALUES(453,'mpga',56000,44100,1,'','',453,NULL);
INSERT INTO AudioTrack VALUES(454,'mpga',56000,44100,1,'','',454,NULL);
INSERT INTO AudioTrack VALUES(455,'mpga',56000,44100,1,'','',455,NULL);
INSERT INTO AudioTrack VALUES(456,'mpga',56000,44100,1,'','',456,NULL);
INSERT INTO AudioTrack VALUES(457,'mpga',56000,44100,1,'','',457,NULL);
INSERT INTO AudioTrack VALUES(458,'mpga',56000,44100,1,'','',458,NULL);
INSERT INTO AudioTrack VALUES(459,'mpga',56000,44100,1,'','',459,NULL);
INSERT INTO AudioTrack VALUES(460,'mpga',56000,44100,1,'','',460,NULL);
INSERT INTO AudioTrack VALUES(461,'mpga',56000,44100,1,'','',461,NULL);
INSERT INTO AudioTrack VALUES(462,'mpga',56000,44100,1,'','',462,NULL);
INSERT INTO AudioTrack VALUES(463,'mpga',56000,44100,1,'','',463,NULL);
INSERT INTO AudioTrack VALUES(464,'mpga',56000,44100,1,'','',464,NULL);
INSERT INTO AudioTrack VALUES(465,'mpga',56000,44100,1,'','',465,NULL);
INSERT INTO AudioTrack VALUES(466,'mpga',56000,44100,1,'','',466,NULL);
INSERT INTO AudioTrack VALUES(467,'mpga',56000,44100,1,'','',467,NULL);
INSERT INTO AudioTrack VALUES(468,'mpga',56000,44100,1,'','',468,NULL);
INSERT INTO AudioTrack VALUES(469,'mpga',56000,44100,1,'','',469,NULL);
INSERT INTO AudioTrack VALUES(470,'mpga',56000,44100,1,'','',470,NULL);
INSERT INTO AudioTrack VALUES(471,'mpga',56000,44100,1,'','',471,NULL);
INSERT INTO AudioTrack VALUES(472,'mpga',56000,44100,1,'','',472,NULL);
INSERT INTO AudioTrack VALUES(473,'mpga',56000,44100,1,'','',473,NULL);
INSERT INTO AudioTrack VALUES(474,'mpga',56000,44100,1,'','',474,NULL);
INSERT INTO AudioTrack VALUES(475,'mpga',56000,44100,1,'','',475,NULL);
INSERT INTO AudioTrack VALUES(476,'mpga',56000,44100,1,'','',476,NULL);
INSERT INTO AudioTrack VALUES(477,'mpga',56000,44100,1,'','',477,NULL);
INSERT INTO AudioTrack VALUES(478,'mpga',56000,44100,1,'','',478,NULL);
INSERT INTO AudioTrack VALUES(479,'mpga',56000,44100,1,'','',479,NULL);
INSERT INTO AudioTrack VALUES(480,'mpga',56000,44100,1,'','',480,NULL);
INSERT INTO AudioTrack VALUES(481,'mpga',56000,44100,1,'','',481,NULL);
INSERT INTO AudioTrack VALUES(482,'mpga',56000,44100,1,'','',482,NULL);
INSERT INTO AudioTrack VALUES(483,'mpga',56000,44100,1,'','',483,NULL);
INSERT INTO AudioTrack VALUES(484,'mpga',56000,44100,1,'','',484,NULL);
INSERT INTO AudioTrack VALUES(485,'mpga',56000,44100,1,'','',485,NULL);
INSERT INTO AudioTrack VALUES(486,'mpga',56000,44100,1,'','',486,NULL);
INSERT INTO AudioTrack VALUES(487,'mpga',56000,44100,1,'','',487,NULL);
INSERT INTO AudioTrack VALUES(488,'mpga',56000,44100,1,'','',488,NULL);
INSERT INTO AudioTrack VALUES(489,'mpga',56000,44100,1,'','',489,NULL);
INSERT INTO AudioTrack VALUES(490,'mpga',56000,44100,1,'','',490,NULL);
INSERT INTO AudioTrack VALUES(491,'mpga',56000,44100,1,'','',491,NULL);
INSERT INTO AudioTrack VALUES(492,'mpga',56000,44100,1,'','',492,NULL);
INSERT INTO AudioTrack VALUES(493,'mpga',56000,44100,1,'','',493,NULL);
INSERT INTO AudioTrack VALUES(494,'mpga',56000,44100,1,'','',494,NULL);
INSERT INTO AudioTrack VALUES(495,'mpga',56000,44100,1,'','',495,NULL);
INSERT INTO AudioTrack VALUES(496,'mpga',56000,44100,1,'','',496,NULL);
INSERT INTO AudioTrack VALUES(497,'mpga',56000,44100,1,'','',497,NULL);
INSERT INTO AudioTrack VALUES(498,'mpga',56000,44100,1,'','',498,NULL);
INSERT INTO AudioTrack VALUES(499,'mpga',56000,44100,1,'','',499,NULL);
INSERT INTO AudioTrack VALUES(500,'mpga',56000,44100,1,'','',500,NULL);
INSERT INTO AudioTrack VALUES(501,'mpga',56000,44100,1,'','',501,NULL);
INSERT INTO AudioTrack VALUES(502,'mpga',56000,44100,1,'','',502,NULL);
INSERT INTO AudioTrack VALUES(503,'mpga',56000,44100,1,'','',503,NULL);
INSERT INTO AudioTrack VALUES(504,'mpga',56000,44100,1,'','',504,NULL);
INSERT INTO AudioTrack VALUES(505,'mpga',56000,44100,1,'','',505,NULL);
INSERT INTO AudioTrack VALUES(506,'mpga',56000,44100,1,'','',506,NULL);
INSERT INTO AudioTrack VALUES(507,'mpga',56000,44100,1,'','',507,NULL);
INSERT INTO AudioTrack VALUES(508,'mpga',56000,44100,1,'','',508,NULL);
INSERT INTO AudioTrack VALUES(509,'mpga',56000,44100,1,'','',509,NULL);
INSERT INTO AudioTrack VALUES(510,'mpga',56000,44100,1,'','',510,NULL);
INSERT INTO AudioTrack VALUES(511,'mpga',56000,44100,1,'','',511,NULL);
INSERT INTO AudioTrack VALUES(512,'mpga',56000,44100,1,'','',512,NULL);
INSERT INTO AudioTrack VALUES(513,'mpga',56000,44100,1,'','',513,NULL);
INSERT INTO AudioTrack VALUES(514,'mpga',56000,44100,1,'','',514,NULL);
INSERT INTO AudioTrack VALUES(515,'mpga',56000,44100,1,'','',515,NULL);
INSERT INTO AudioTrack VALUES(516,'mpga',56000,44100,1,'','',516,NULL);
INSERT INTO AudioTrack VALUES(517,'mpga',56000,44100,1,'','',517,NULL);
INSERT INTO AudioTrack VALUES(518,'mpga',56000,44100,1,'','',518,NULL);
INSERT INTO AudioTrack VALUES(519,'mpga',56000,44100,1,'','',519,NULL);
INSERT INTO AudioTrack VALUES(520,'mpga',56000,44100,1,'','',520,NULL);
INSERT INTO AudioTrack VALUES(521,'mpga',56000,44100,1,'','',521,NULL);
INSERT INTO AudioTrack VALUES(522,'mpga',56000,44100,1,'','',522,NULL);
INSERT INTO AudioTrack VALUES(523,'mpga',56000,44100,1,'','',523,NULL);
INSERT INTO AudioTrack VALUES(524,'mpga',56000,44100,1,'','',524,NULL);
INSERT INTO AudioTrack VALUES(525,'mpga',56000,44100,1,'','',525,NULL);
INSERT INTO AudioTrack VALUES(526,'mpga',56000,44100,1,'','',526,NULL);
INSERT INTO AudioTrack VALUES(527,'mpga',56000,44100,1,'','',527,NULL);
INSERT INTO AudioTrack VALUES(528,'mpga',56000,44100,1,'','',528,NULL);
INSERT INTO AudioTrack VALUES(529,'mpga',56000,44100,1,'','',529,NULL);
INSERT INTO AudioTrack VALUES(530,'mpga',56000,44100,1,'','',530,NULL);
INSERT INTO AudioTrack VALUES(531,'mpga',56000,44100,1,'','',531,NULL);
INSERT INTO AudioTrack VALUES(532,'mpga',56000,44100,1,'','',532,NULL);
INSERT INTO AudioTrack VALUES(533,'mpga',56000,44100,1,'','',533,NULL);
INSERT INTO AudioTrack VALUES(534,'mpga',56000,44100,1,'','',534,NULL);
INSERT INTO AudioTrack VALUES(535,'mpga',56000,44100,1,'','',535,NULL);
INSERT INTO AudioTrack VALUES(536,'mpga',56000,44100,1,'','',536,NULL);
INSERT INTO AudioTrack VALUES(537,'mpga',56000,44100,1,'','',537,NULL);
INSERT INTO AudioTrack VALUES(538,'mpga',56000,44100,1,'','',538,NULL);
INSERT INTO AudioTrack VALUES(539,'mpga',56000,44100,1,'','',539,NULL);
INSERT INTO AudioTrack VALUES(540,'mpga',56000,44100,1,'','',540,NULL);
INSERT INTO AudioTrack VALUES(541,'mpga',56000,44100,1,'','',541,NULL);
INSERT INTO AudioTrack VALUES(542,'mpga',56000,44100,1,'','',542,NULL);
INSERT INTO AudioTrack VALUES(543,'mpga',56000,44100,1,'','',543,NULL);
INSERT INTO AudioTrack VALUES(544,'mpga',56000,44100,1,'','',544,NULL);
INSERT INTO AudioTrack VALUES(545,'mpga',56000,44100,1,'','',545,NULL);
INSERT INTO AudioTrack VALUES(546,'mpga',56000,44100,1,'','',546,NULL);
INSERT INTO AudioTrack VALUES(547,'mpga',56000,44100,1,'','',547,NULL);
INSERT INTO AudioTrack VALUES(548,'mpga',56000,44100,1,'','',548,NULL);
INSERT INTO AudioTrack VALUES(549,'mpga',56000,44100,1,'','',549,NULL);
INSERT INTO AudioTrack VALUES(550,'mpga',56000,44100,1,'','',550,NULL);
INSERT INTO AudioTrack VALUES(551,'mpga',56000,44100,1,'','',551,NULL);
INSERT INTO AudioTrack VALUES(552,'mpga',56000,44100,1,'','',552,NULL);
INSERT INTO AudioTrack VALUES(553,'mpga',56000,44100,1,'','',553,NULL);
INSERT INTO AudioTrack VALUES(554,'mpga',56000,44100,1,'','',554,NULL);
INSERT INTO AudioTrack VALUES(555,'mpga',56000,44100,1,'','',555,NULL);
INSERT INTO AudioTrack VALUES(556,'mpga',56000,44100,1,'','',556,NULL);
INSERT INTO AudioTrack VALUES(557,'mpga',56000,44100,1,'','',557,NULL);
INSERT INTO AudioTrack VALUES(558,'mpga',56000,44100,1,'','',558,NULL);
INSERT INTO AudioTrack VALUES(559,'mpga',56000,44100,1,'','',559,NULL);
INSERT INTO AudioTrack VALUES(560,'mpga',56000,44100,1,'','',560,NULL);
INSERT INTO AudioTrack VALUES(561,'mpga',56000,44100,1,'','',561,NULL);
INSERT INTO AudioTrack VALUES(562,'mpga',56000,44100,1,'','',562,NULL);
INSERT INTO AudioTrack VALUES(563,'mpga',56000,44100,1,'','',563,NULL);
INSERT INTO AudioTrack VALUES(564,'mpga',56000,44100,1,'','',564,NULL);
INSERT INTO AudioTrack VALUES(565,'mpga',56000,44100,1,'','',565,NULL);
INSERT INTO AudioTrack VALUES(566,'mpga',56000,44100,1,'','',566,NULL);
INSERT INTO AudioTrack VALUES(567,'mpga',56000,44100,1,'','',567,NULL);
INSERT INTO AudioTrack VALUES(568,'mpga',56000,44100,1,'','',568,NULL);
INSERT INTO AudioTrack VALUES(569,'mpga',56000,44100,1,'','',569,NULL);
INSERT INTO AudioTrack VALUES(570,'mpga',56000,44100,1,'','',570,NULL);
INSERT INTO AudioTrack VALUES(571,'mpga',56000,44100,1,'','',571,NULL);
INSERT INTO AudioTrack VALUES(572,'mpga',56000,44100,1,'','',572,NULL);
INSERT INTO AudioTrack VALUES(573,'mpga',56000,44100,1,'','',573,NULL);
INSERT INTO AudioTrack VALUES(574,'mpga',56000,44100,1,'','',574,NULL);
INSERT INTO AudioTrack VALUES(575,'mpga',56000,44100,1,'','',575,NULL);
INSERT INTO AudioTrack VALUES(576,'mpga',56000,44100,1,'','',576,NULL);
INSERT INTO AudioTrack VALUES(577,'mpga',56000,44100,1,'','',577,NULL);
INSERT INTO AudioTrack VALUES(578,'mpga',56000,44100,1,'','',578,NULL);
INSERT INTO AudioTrack VALUES(579,'mpga',56000,44100,1,'','',579,NULL);
INSERT INTO AudioTrack VALUES(580,'mpga',56000,44100,1,'','',580,NULL);
INSERT INTO AudioTrack VALUES(581,'mpga',56000,44100,1,'','',581,NULL);
INSERT INTO AudioTrack VALUES(582,'mpga',56000,44100,1,'','',582,NULL);
INSERT INTO AudioTrack VALUES(583,'mpga',56000,44100,1,'','',583,NULL);
INSERT INTO AudioTrack VALUES(584,'mpga',56000,44100,1,'','',584,NULL);
INSERT INTO AudioTrack VALUES(585,'mpga',56000,44100,1,'','',585,NULL);
INSERT INTO AudioTrack VALUES(586,'mpga',56000,44100,1,'','',586,NULL);
INSERT INTO AudioTrack VALUES(587,'mpga',56000,44100,1,'','',587,NULL);
INSERT INTO AudioTrack VALUES(588,'mpga',56000,44100,1,'','',588,NULL);
INSERT INTO AudioTrack VALUES(589,'mpga',56000,44100,1,'','',589,NULL);
INSERT INTO AudioTrack VALUES(590,'mpga',56000,44100,1,'','',590,NULL);
INSERT INTO AudioTrack VALUES(591,'mpga',56000,44100,1,'','',591,NULL);
INSERT INTO AudioTrack VALUES(592,'mpga',56000,44100,1,'','',592,NULL);
INSERT INTO AudioTrack VALUES(593,'mpga',56000,44100,1,'','',593,NULL);
INSERT INTO AudioTrack VALUES(594,'mpga',56000,44100,1,'','',594,NULL);
INSERT INTO AudioTrack VALUES(595,'mpga',56000,44100,1,'','',595,NULL);
INSERT INTO AudioTrack VALUES(596,'mpga',56000,44100,1,'','',596,NULL);
INSERT INTO AudioTrack VALUES(597,'mpga',56000,44100,1,'','',597,NULL);
INSERT INTO AudioTrack VALUES(598,'mpga',56000,44100,1,'','',598,NULL);
INSERT INTO AudioTrack VALUES(599,'mpga',56000,44100,1,'','',599,NULL);
INSERT INTO AudioTrack VALUES(600,'mpga',56000,44100,1,'','',600,NULL);
INSERT INTO AudioTrack VALUES(601,'mpga',56000,44100,1,'','',601,NULL);
INSERT INTO AudioTrack VALUES(602,'mpga',56000,44100,1,'','',602,NULL);
INSERT INTO AudioTrack VALUES(603,'mpga',56000,44100,1,'','',603,NULL);
INSERT INTO AudioTrack VALUES(604,'mpga',56000,44100,1,'','',604,NULL);
INSERT INTO AudioTrack VALUES(605,'mpga',56000,44100,1,'','',605,NULL);
INSERT INTO AudioTrack VALUES(606,'mpga',56000,44100,1,'','',606,NULL);
INSERT INTO AudioTrack VALUES(607,'mpga',56000,44100,1,'','',607,NULL);
INSERT INTO AudioTrack VALUES(608,'mpga',56000,44100,1,'','',608,NULL);
INSERT INTO AudioTrack VALUES(609,'mpga',56000,44100,1,'','',609,NULL);
INSERT INTO AudioTrack VALUES(610,'mpga',56000,44100,1,'','',610,NULL);
INSERT INTO AudioTrack VALUES(611,'mpga',56000,44100,1,'','',611,NULL);
INSERT INTO AudioTrack VALUES(612,'mpga',56000,44100,1,'','',612,NULL);
INSERT INTO AudioTrack VALUES(613,'mpga',56000,44100,1,'','',613,NULL);
INSERT INTO AudioTrack VALUES(614,'mpga',56000,44100,1,'','',614,NULL);
INSERT INTO AudioTrack VALUES(615,'mpga',56000,44100,1,'','',615,NULL);
INSERT INTO AudioTrack VALUES(616,'mpga',56000,44100,1,'','',616,NULL);
INSERT INTO AudioTrack VALUES(617,'mpga',56000,44100,1,'','',617,NULL);
INSERT INTO AudioTrack VALUES(618,'mpga',56000,44100,1,'','',618,NULL);
INSERT INTO AudioTrack VALUES(619,'mpga',56000,44100,1,'','',619,NULL);
INSERT INTO AudioTrack VALUES(620,'mpga',56000,44100,1,'','',620,NULL);
INSERT INTO AudioTrack VALUES(621,'mpga',56000,44100,1,'','',621,NULL);
INSERT INTO AudioTrack VALUES(622,'mpga',56000,44100,1,'','',622,NULL);
INSERT INTO AudioTrack VALUES(623,'mpga',56000,44100,1,'','',623,NULL);
INSERT INTO AudioTrack VALUES(624,'mpga',56000,44100,1,'','',624,NULL);
INSERT INTO AudioTrack VALUES(625,'mpga',56000,44100,1,'','',625,NULL);
INSERT INTO AudioTrack VALUES(626,'mpga',56000,44100,1,'','',626,NULL);
INSERT INTO AudioTrack VALUES(627,'mpga',56000,44100,1,'','',627,NULL);
INSERT INTO AudioTrack VALUES(628,'mpga',56000,44100,1,'','',628,NULL);
INSERT INTO AudioTrack VALUES(629,'mpga',56000,44100,1,'','',629,NULL);
INSERT INTO AudioTrack VALUES(630,'mpga',56000,44100,1,'','',630,NULL);
INSERT INTO AudioTrack VALUES(631,'mpga',56000,44100,1,'','',631,NULL);
INSERT INTO AudioTrack VALUES(632,'mpga',56000,44100,1,'','',632,NULL);
INSERT INTO AudioTrack VALUES(633,'mpga',56000,44100,1,'','',633,NULL);
INSERT INTO AudioTrack VALUES(634,'mpga',56000,44100,1,'','',634,NULL);
INSERT INTO AudioTrack VALUES(635,'mpga',56000,44100,1,'','',635,NULL);
INSERT INTO AudioTrack VALUES(636,'mpga',56000,44100,1,'','',636,NULL);
INSERT INTO AudioTrack VALUES(637,'mpga',56000,44100,1,'','',637,NULL);
INSERT INTO AudioTrack VALUES(638,'mpga',56000,44100,1,'','',638,NULL);
INSERT INTO AudioTrack VALUES(639,'mpga',56000,44100,1,'','',639,NULL);
INSERT INTO AudioTrack VALUES(640,'mpga',56000,44100,1,'','',640,NULL);
INSERT INTO AudioTrack VALUES(641,'mpga',56000,44100,1,'','',641,NULL);
INSERT INTO AudioTrack VALUES(642,'mpga',56000,44100,1,'','',642,NULL);
INSERT INTO AudioTrack VALUES(643,'mpga',56000,44100,1,'','',643,NULL);
INSERT INTO AudioTrack VALUES(644,'mpga',56000,44100,1,'','',644,NULL);
INSERT INTO AudioTrack VALUES(645,'mpga',56000,44100,1,'','',645,NULL);
INSERT INTO AudioTrack VALUES(646,'mpga',56000,44100,1,'','',646,NULL);
INSERT INTO AudioTrack VALUES(647,'mpga',56000,44100,1,'','',647,NULL);
INSERT INTO AudioTrack VALUES(648,'mpga',56000,44100,1,'','',648,NULL);
INSERT INTO AudioTrack VALUES(649,'mpga',56000,44100,1,'','',649,NULL);
INSERT INTO AudioTrack VALUES(650,'mpga',56000,44100,1,'','',650,NULL);
INSERT INTO AudioTrack VALUES(651,'mpga',56000,44100,1,'','',651,NULL);
INSERT INTO AudioTrack VALUES(652,'mpga',56000,44100,1,'','',652,NULL);
INSERT INTO AudioTrack VALUES(653,'mpga',56000,44100,1,'','',653,NULL);
INSERT INTO AudioTrack VALUES(654,'mpga',56000,44100,1,'','',654,NULL);
INSERT INTO AudioTrack VALUES(655,'mpga',56000,44100,1,'','',655,NULL);
INSERT INTO AudioTrack VALUES(656,'mpga',56000,44100,1,'','',656,NULL);
INSERT INTO AudioTrack VALUES(657,'mpga',56000,44100,1,'','',657,NULL);
INSERT INTO AudioTrack VALUES(658,'mpga',56000,44100,1,'','',658,NULL);
INSERT INTO AudioTrack VALUES(659,'mpga',56000,44100,1,'','',659,NULL);
INSERT INTO AudioTrack VALUES(660,'mpga',56000,44100,1,'','',660,NULL);
INSERT INTO AudioTrack VALUES(661,'mpga',56000,44100,1,'','',661,NULL);
INSERT INTO AudioTrack VALUES(662,'mpga',56000,44100,1,'','',662,NULL);
INSERT INTO AudioTrack VALUES(663,'mpga',56000,44100,1,'','',663,NULL);
INSERT INTO AudioTrack VALUES(664,'mpga',56000,44100,1,'','',664,NULL);
INSERT INTO AudioTrack VALUES(665,'mpga',56000,44100,1,'','',665,NULL);
INSERT INTO AudioTrack VALUES(666,'mpga',56000,44100,1,'','',666,NULL);
INSERT INTO AudioTrack VALUES(667,'mpga',56000,44100,1,'','',667,NULL);
INSERT INTO AudioTrack VALUES(668,'mpga',56000,44100,1,'','',668,NULL);
INSERT INTO AudioTrack VALUES(669,'mpga',56000,44100,1,'','',669,NULL);
INSERT INTO AudioTrack VALUES(670,'mpga',56000,44100,1,'','',670,NULL);
INSERT INTO AudioTrack VALUES(671,'mpga',56000,44100,1,'','',671,NULL);
INSERT INTO AudioTrack VALUES(672,'mpga',56000,44100,1,'','',672,NULL);
INSERT INTO AudioTrack VALUES(673,'mpga',56000,44100,1,'','',673,NULL);
INSERT INTO AudioTrack VALUES(674,'mpga',56000,44100,1,'','',674,NULL);
INSERT INTO AudioTrack VALUES(675,'mpga',56000,44100,1,'','',675,NULL);
INSERT INTO AudioTrack VALUES(676,'mpga',56000,44100,1,'','',676,NULL);
INSERT INTO AudioTrack VALUES(677,'mpga',56000,44100,1,'','',677,NULL);
INSERT INTO AudioTrack VALUES(678,'mpga',56000,44100,1,'','',678,NULL);
INSERT INTO AudioTrack VALUES(679,'mpga',56000,44100,1,'','',679,NULL);
INSERT INTO AudioTrack VALUES(680,'mpga',56000,44100,1,'','',680,NULL);
INSERT INTO AudioTrack VALUES(681,'mpga',56000,44100,1,'','',681,NULL);
INSERT INTO AudioTrack VALUES(682,'mpga',56000,44100,1,'','',682,NULL);
INSERT INTO AudioTrack VALUES(683,'mpga',56000,44100,1,'','',683,NULL);
INSERT INTO AudioTrack VALUES(684,'mpga',56000,44100,1,'','',684,NULL);
INSERT INTO AudioTrack VALUES(685,'mpga',56000,44100,1,'','',685,NULL);
INSERT INTO AudioTrack VALUES(686,'mpga',56000,44100,1,'','',686,NULL);
INSERT INTO AudioTrack VALUES(687,'mpga',56000,44100,1,'','',687,NULL);
INSERT INTO AudioTrack VALUES(688,'mpga',56000,44100,1,'','',688,NULL);
INSERT INTO AudioTrack VALUES(689,'mpga',56000,44100,1,'','',689,NULL);
INSERT INTO AudioTrack VALUES(690,'mpga',56000,44100,1,'','',690,NULL);
INSERT INTO AudioTrack VALUES(691,'mpga',56000,44100,1,'','',691,NULL);
INSERT INTO AudioTrack VALUES(692,'mpga',56000,44100,1,'','',692,NULL);
INSERT INTO AudioTrack VALUES(693,'mpga',56000,44100,1,'','',693,NULL);
INSERT INTO AudioTrack VALUES(694,'mpga',56000,44100,1,'','',694,NULL);
INSERT INTO AudioTrack VALUES(695,'mpga',56000,44100,1,'','',695,NULL);
INSERT INTO AudioTrack VALUES(696,'mpga',56000,44100,1,'','',696,NULL);
INSERT INTO AudioTrack VALUES(697,'mpga',56000,44100,1,'','',697,NULL);
INSERT INTO AudioTrack VALUES(698,'mpga',56000,44100,1,'','',698,NULL);
INSERT INTO AudioTrack VALUES(699,'mpga',56000,44100,1,'','',699,NULL);
INSERT INTO AudioTrack VALUES(700,'mpga',56000,44100,1,'','',700,NULL);
INSERT INTO AudioTrack VALUES(701,'mpga',56000,44100,1,'','',701,NULL);
INSERT INTO AudioTrack VALUES(702,'mpga',56000,44100,1,'','',702,NULL);
INSERT INTO AudioTrack VALUES(703,'mpga',56000,44100,1,'','',703,NULL);
INSERT INTO AudioTrack VALUES(704,'mpga',56000,44100,1,'','',704,NULL);
INSERT INTO AudioTrack VALUES(705,'mpga',56000,44100,1,'','',705,NULL);
INSERT INTO AudioTrack VALUES(706,'mpga',56000,44100,1,'','',706,NULL);
INSERT INTO AudioTrack VALUES(707,'mpga',56000,44100,1,'','',707,NULL);
INSERT INTO AudioTrack VALUES(708,'mpga',56000,44100,1,'','',708,NULL);
INSERT INTO AudioTrack VALUES(709,'mpga',56000,44100,1,'','',709,NULL);
INSERT INTO AudioTrack VALUES(710,'mpga',56000,44100,1,'','',710,NULL);
INSERT INTO AudioTrack VALUES(711,'mpga',56000,44100,1,'','',711,NULL);
INSERT INTO AudioTrack VALUES(712,'mpga',56000,44100,1,'','',712,NULL);
INSERT INTO AudioTrack VALUES(713,'mpga',56000,44100,1,'','',713,NULL);
INSERT INTO AudioTrack VALUES(714,'mpga',56000,44100,1,'','',714,NULL);
INSERT INTO AudioTrack VALUES(715,'mpga',56000,44100,1,'','',715,NULL);
INSERT INTO AudioTrack VALUES(716,'mpga',56000,44100,1,'','',716,NULL);
INSERT INTO AudioTrack VALUES(717,'mpga',56000,44100,1,'','',717,NULL);
INSERT INTO AudioTrack VALUES(718,'mpga',56000,44100,1,'','',718,NULL);
INSERT INTO AudioTrack VALUES(719,'mpga',56000,44100,1,'','',719,NULL);
INSERT INTO AudioTrack VALUES(720,'mpga',56000,44100,1,'','',720,NULL);
INSERT INTO AudioTrack VALUES(721,'mpga',56000,44100,1,'','',721,NULL);
INSERT INTO AudioTrack VALUES(722,'mpga',56000,44100,1,'','',722,NULL);
INSERT INTO AudioTrack VALUES(723,'mpga',56000,44100,1,'','',723,NULL);
INSERT INTO AudioTrack VALUES(724,'mpga',56000,44100,1,'','',724,NULL);
INSERT INTO AudioTrack VALUES(725,'mpga',56000,44100,1,'','',725,NULL);
INSERT INTO AudioTrack VALUES(726,'mpga',56000,44100,1,'','',726,NULL);
INSERT INTO AudioTrack VALUES(727,'mpga',56000,44100,1,'','',727,NULL);
INSERT INTO AudioTrack VALUES(728,'mpga',56000,44100,1,'','',728,NULL);
INSERT INTO AudioTrack VALUES(729,'mpga',56000,44100,1,'','',729,NULL);
INSERT INTO AudioTrack VALUES(730,'mpga',56000,44100,1,'','',730,NULL);
INSERT INTO AudioTrack VALUES(731,'mpga',56000,44100,1,'','',731,NULL);
INSERT INTO AudioTrack VALUES(732,'mpga',56000,44100,1,'','',732,NULL);
INSERT INTO AudioTrack VALUES(733,'mpga',56000,44100,1,'','',733,NULL);
INSERT INTO AudioTrack VALUES(734,'mpga',56000,44100,1,'','',734,NULL);
INSERT INTO AudioTrack VALUES(735,'mpga',56000,44100,1,'','',735,NULL);
INSERT INTO AudioTrack VALUES(736,'mpga',56000,44100,1,'','',736,NULL);
INSERT INTO AudioTrack VALUES(737,'mpga',56000,44100,1,'','',737,NULL);
INSERT INTO AudioTrack VALUES(738,'mpga',56000,44100,1,'','',738,NULL);
INSERT INTO AudioTrack VALUES(739,'mpga',56000,44100,1,'','',739,NULL);
INSERT INTO AudioTrack VALUES(740,'mpga',56000,44100,1,'','',740,NULL);
INSERT INTO AudioTrack VALUES(741,'mpga',56000,44100,1,'','',741,NULL);
INSERT INTO AudioTrack VALUES(742,'mpga',56000,44100,1,'','',742,NULL);
INSERT INTO AudioTrack VALUES(743,'mpga',56000,44100,1,'','',743,NULL);
INSERT INTO AudioTrack VALUES(744,'mpga',56000,44100,1,'','',744,NULL);
INSERT INTO AudioTrack VALUES(745,'mpga',56000,44100,1,'','',745,NULL);
INSERT INTO AudioTrack VALUES(746,'mpga',56000,44100,1,'','',746,NULL);
INSERT INTO AudioTrack VALUES(747,'mpga',56000,44100,1,'','',747,NULL);
INSERT INTO AudioTrack VALUES(748,'mpga',56000,44100,1,'','',748,NULL);
INSERT INTO AudioTrack VALUES(749,'mpga',56000,44100,1,'','',749,NULL);
INSERT INTO AudioTrack VALUES(750,'mpga',56000,44100,1,'','',750,NULL);
INSERT INTO AudioTrack VALUES(751,'mpga',56000,44100,1,'','',751,NULL);
INSERT INTO AudioTrack VALUES(752,'mpga',56000,44100,1,'','',752,NULL);
INSERT INTO AudioTrack VALUES(753,'mpga',56000,44100,1,'','',753,NULL);
INSERT INTO AudioTrack VALUES(754,'mpga',56000,44100,1,'','',754,NULL);
INSERT INTO AudioTrack VALUES(755,'mpga',56000,44100,1,'','',755,NULL);
INSERT INTO AudioTrack VALUES(756,'mpga',56000,44100,1,'','',756,NULL);
INSERT INTO AudioTrack VALUES(757,'mpga',56000,44100,1,'','',757,NULL);
INSERT INTO AudioTrack VALUES(758,'mpga',56000,44100,1,'','',758,NULL);
INSERT INTO AudioTrack VALUES(759,'mpga',56000,44100,1,'','',759,NULL);
INSERT INTO AudioTrack VALUES(760,'mpga',56000,44100,1,'','',760,NULL);
INSERT INTO AudioTrack VALUES(761,'mpga',56000,44100,1,'','',761,NULL);
INSERT INTO AudioTrack VALUES(762,'mpga',56000,44100,1,'','',762,NULL);
INSERT INTO AudioTrack VALUES(763,'mpga',56000,44100,1,'','',763,NULL);
INSERT INTO AudioTrack VALUES(764,'mpga',56000,44100,1,'','',764,NULL);
INSERT INTO AudioTrack VALUES(765,'mpga',56000,44100,1,'','',765,NULL);
INSERT INTO AudioTrack VALUES(766,'mpga',56000,44100,1,'','',766,NULL);
INSERT INTO AudioTrack VALUES(767,'mpga',56000,44100,1,'','',767,NULL);
INSERT INTO AudioTrack VALUES(768,'mpga',56000,44100,1,'','',768,NULL);
INSERT INTO AudioTrack VALUES(769,'mpga',56000,44100,1,'','',769,NULL);
INSERT INTO AudioTrack VALUES(770,'mpga',56000,44100,1,'','',770,NULL);
INSERT INTO AudioTrack VALUES(771,'mpga',56000,44100,1,'','',771,NULL);
INSERT INTO AudioTrack VALUES(772,'mpga',56000,44100,1,'','',772,NULL);
INSERT INTO AudioTrack VALUES(773,'mpga',56000,44100,1,'','',773,NULL);
INSERT INTO AudioTrack VALUES(774,'mpga',56000,44100,1,'','',774,NULL);
INSERT INTO AudioTrack VALUES(775,'mpga',56000,44100,1,'','',775,NULL);
INSERT INTO AudioTrack VALUES(776,'mpga',56000,44100,1,'','',776,NULL);
INSERT INTO AudioTrack VALUES(777,'mpga',56000,44100,1,'','',777,NULL);
INSERT INTO AudioTrack VALUES(778,'mpga',56000,44100,1,'','',778,NULL);
INSERT INTO AudioTrack VALUES(779,'mpga',56000,44100,1,'','',779,NULL);
INSERT INTO AudioTrack VALUES(780,'mpga',56000,44100,1,'','',780,NULL);
INSERT INTO AudioTrack VALUES(781,'mpga',56000,44100,1,'','',781,NULL);
INSERT INTO AudioTrack VALUES(782,'mpga',56000,44100,1,'','',782,NULL);
INSERT INTO AudioTrack VALUES(783,'mpga',56000,44100,1,'','',783,NULL);
INSERT INTO AudioTrack VALUES(784,'mpga',56000,44100,1,'','',784,NULL);
INSERT INTO AudioTrack VALUES(785,'mpga',56000,44100,1,'','',785,NULL);
INSERT INTO AudioTrack VALUES(786,'mpga',56000,44100,1,'','',786,NULL);
INSERT INTO AudioTrack VALUES(787,'mpga',56000,44100,1,'','',787,NULL);
INSERT INTO AudioTrack VALUES(788,'mpga',56000,44100,1,'','',788,NULL);
INSERT INTO AudioTrack VALUES(789,'mpga',56000,44100,1,'','',789,NULL);
INSERT INTO AudioTrack VALUES(790,'mpga',56000,44100,1,'','',790,NULL);
INSERT INTO AudioTrack VALUES(791,'mpga',56000,44100,1,'','',791,NULL);
INSERT INTO AudioTrack VALUES(792,'mpga',56000,44100,1,'','',792,NULL);
INSERT INTO AudioTrack VALUES(793,'mpga',56000,44100,1,'','',793,NULL);
INSERT INTO AudioTrack VALUES(794,'mpga',56000,44100,1,'','',794,NULL);
INSERT INTO AudioTrack VALUES(795,'mpga',56000,44100,1,'','',795,NULL);
INSERT INTO AudioTrack VALUES(796,'mpga',56000,44100,1,'','',796,NULL);
INSERT INTO AudioTrack VALUES(797,'mpga',56000,44100,1,'','',797,NULL);
INSERT INTO AudioTrack VALUES(798,'mpga',56000,44100,1,'','',798,NULL);
INSERT INTO AudioTrack VALUES(799,'mpga',56000,44100,1,'','',799,NULL);
INSERT INTO AudioTrack VALUES(800,'mpga',56000,44100,1,'','',800,NULL);
INSERT INTO AudioTrack VALUES(801,'mpga',56000,44100,1,'','',801,NULL);
INSERT INTO AudioTrack VALUES(802,'mpga',56000,44100,1,'','',802,NULL);
INSERT INTO AudioTrack VALUES(803,'mpga',56000,44100,1,'','',803,NULL);
INSERT INTO AudioTrack VALUES(804,'mpga',56000,44100,1,'','',804,NULL);
INSERT INTO AudioTrack VALUES(805,'mpga',56000,44100,1,'','',805,NULL);
INSERT INTO AudioTrack VALUES(806,'mpga',56000,44100,1,'','',806,NULL);
INSERT INTO AudioTrack VALUES(807,'mpga',56000,44100,1,'','',807,NULL);
INSERT INTO AudioTrack VALUES(808,'mpga',56000,44100,1,'','',808,NULL);
INSERT INTO AudioTrack VALUES(809,'mpga',56000,44100,1,'','',809,NULL);
INSERT INTO AudioTrack VALUES(810,'mpga',56000,44100,1,'','',810,NULL);
INSERT INTO AudioTrack VALUES(811,'mpga',56000,44100,1,'','',811,NULL);
INSERT INTO AudioTrack VALUES(812,'mpga',56000,44100,1,'','',812,NULL);
INSERT INTO AudioTrack VALUES(813,'mpga',56000,44100,1,'','',813,NULL);
INSERT INTO AudioTrack VALUES(814,'mpga',56000,44100,1,'','',814,NULL);
INSERT INTO AudioTrack VALUES(815,'mpga',56000,44100,1,'','',815,NULL);
INSERT INTO AudioTrack VALUES(816,'mpga',56000,44100,1,'','',816,NULL);
INSERT INTO AudioTrack VALUES(817,'mpga',56000,44100,1,'','',817,NULL);
INSERT INTO AudioTrack VALUES(818,'mpga',56000,44100,1,'','',818,NULL);
INSERT INTO AudioTrack VALUES(819,'mpga',56000,44100,1,'','',819,NULL);
INSERT INTO AudioTrack VALUES(820,'mpga',56000,44100,1,'','',820,NULL);
INSERT INTO AudioTrack VALUES(821,'mpga',56000,44100,1,'','',821,NULL);
INSERT INTO AudioTrack VALUES(822,'mpga',56000,44100,1,'','',822,NULL);
INSERT INTO AudioTrack VALUES(823,'mpga',56000,44100,1,'','',823,NULL);
INSERT INTO AudioTrack VALUES(824,'mpga',56000,44100,1,'','',824,NULL);
INSERT INTO AudioTrack VALUES(825,'mpga',56000,44100,1,'','',825,NULL);
INSERT INTO AudioTrack VALUES(826,'mpga',56000,44100,1,'','',826,NULL);
INSERT INTO AudioTrack VALUES(827,'mpga',56000,44100,1,'','',827,NULL);
INSERT INTO AudioTrack VALUES(828,'mpga',56000,44100,1,'','',828,NULL);
INSERT INTO AudioTrack VALUES(829,'mpga',56000,44100,1,'','',829,NULL);
INSERT INTO AudioTrack VALUES(830,'mpga',56000,44100,1,'','',830,NULL);
INSERT INTO AudioTrack VALUES(831,'mpga',56000,44100,1,'','',831,NULL);
INSERT INTO AudioTrack VALUES(832,'mpga',56000,44100,1,'','',832,NULL);
INSERT INTO AudioTrack VALUES(833,'mpga',56000,44100,1,'','',833,NULL);
INSERT INTO AudioTrack VALUES(834,'mpga',56000,44100,1,'','',834,NULL);
INSERT INTO AudioTrack VALUES(835,'mpga',56000,44100,1,'','',835,NULL);
INSERT INTO AudioTrack VALUES(836,'mpga',56000,44100,1,'','',836,NULL);
INSERT INTO AudioTrack VALUES(837,'mpga',56000,44100,1,'','',837,NULL);
INSERT INTO AudioTrack VALUES(838,'mpga',56000,44100,1,'','',838,NULL);
INSERT INTO AudioTrack VALUES(839,'mpga',56000,44100,1,'','',839,NULL);
INSERT INTO AudioTrack VALUES(840,'mpga',56000,44100,1,'','',840,NULL);
INSERT INTO AudioTrack VALUES(841,'mpga',56000,44100,1,'','',841,NULL);
INSERT INTO AudioTrack VALUES(842,'mpga',56000,44100,1,'','',842,NULL);
INSERT INTO AudioTrack VALUES(843,'mpga',56000,44100,1,'','',843,NULL);
INSERT INTO AudioTrack VALUES(844,'mpga',56000,44100,1,'','',844,NULL);
INSERT INTO AudioTrack VALUES(845,'mpga',56000,44100,1,'','',845,NULL);
INSERT INTO AudioTrack VALUES(846,'mpga',56000,44100,1,'','',846,NULL);
INSERT INTO AudioTrack VALUES(847,'mpga',56000,44100,1,'','',847,NULL);
INSERT INTO AudioTrack VALUES(848,'mpga',56000,44100,1,'','',848,NULL);
INSERT INTO AudioTrack VALUES(849,'mpga',56000,44100,1,'','',849,NULL);
INSERT INTO AudioTrack VALUES(850,'mpga',56000,44100,1,'','',850,NULL);
INSERT INTO AudioTrack VALUES(851,'mpga',56000,44100,1,'','',851,NULL);
INSERT INTO AudioTrack VALUES(852,'mpga',56000,44100,1,'','',852,NULL);
INSERT INTO AudioTrack VALUES(853,'mpga',56000,44100,1,'','',853,NULL);
INSERT INTO AudioTrack VALUES(854,'mpga',56000,44100,1,'','',854,NULL);
INSERT INTO AudioTrack VALUES(855,'mpga',56000,44100,1,'','',855,NULL);
INSERT INTO AudioTrack VALUES(856,'mpga',56000,44100,1,'','',856,NULL);
INSERT INTO AudioTrack VALUES(857,'mpga',56000,44100,1,'','',857,NULL);
INSERT INTO AudioTrack VALUES(858,'mpga',56000,44100,1,'','',858,NULL);
INSERT INTO AudioTrack VALUES(859,'mpga',56000,44100,1,'','',859,NULL);
INSERT INTO AudioTrack VALUES(860,'mpga',56000,44100,1,'','',860,NULL);
INSERT INTO AudioTrack VALUES(861,'mpga',56000,44100,1,'','',861,NULL);
INSERT INTO AudioTrack VALUES(862,'mpga',56000,44100,1,'','',862,NULL);
INSERT INTO AudioTrack VALUES(863,'mpga',56000,44100,1,'','',863,NULL);
INSERT INTO AudioTrack VALUES(864,'mpga',56000,44100,1,'','',864,NULL);
INSERT INTO AudioTrack VALUES(865,'mpga',56000,44100,1,'','',865,NULL);
INSERT INTO AudioTrack VALUES(866,'mpga',56000,44100,1,'','',866,NULL);
INSERT INTO AudioTrack VALUES(867,'mpga',56000,44100,1,'','',867,NULL);
INSERT INTO AudioTrack VALUES(868,'mpga',56000,44100,1,'','',868,NULL);
INSERT INTO AudioTrack VALUES(869,'mpga',56000,44100,1,'','',869,NULL);
INSERT INTO AudioTrack VALUES(870,'mpga',56000,44100,1,'','',870,NULL);
INSERT INTO AudioTrack VALUES(871,'mpga',56000,44100,1,'','',871,NULL);
INSERT INTO AudioTrack VALUES(872,'mpga',56000,44100,1,'','',872,NULL);
INSERT INTO AudioTrack VALUES(873,'mpga',56000,44100,1,'','',873,NULL);
INSERT INTO AudioTrack VALUES(874,'mpga',56000,44100,1,'','',874,NULL);
INSERT INTO AudioTrack VALUES(875,'mpga',56000,44100,1,'','',875,NULL);
INSERT INTO AudioTrack VALUES(876,'mpga',56000,44100,1,'','',876,NULL);
INSERT INTO AudioTrack VALUES(877,'mpga',56000,44100,1,'','',877,NULL);
INSERT INTO AudioTrack VALUES(878,'mpga',56000,44100,1,'','',878,NULL);
INSERT INTO AudioTrack VALUES(879,'mpga',56000,44100,1,'','',879,NULL);
INSERT INTO AudioTrack VALUES(880,'mpga',56000,44100,1,'','',880,NULL);
INSERT INTO AudioTrack VALUES(881,'mpga',56000,44100,1,'','',881,NULL);
INSERT INTO AudioTrack VALUES(882,'mpga',56000,44100,1,'','',882,NULL);
INSERT INTO AudioTrack VALUES(883,'mpga',56000,44100,1,'','',883,NULL);
INSERT INTO AudioTrack VALUES(884,'mpga',56000,44100,1,'','',884,NULL);
INSERT INTO AudioTrack VALUES(885,'mpga',56000,44100,1,'','',885,NULL);
INSERT INTO AudioTrack VALUES(886,'mpga',56000,44100,1,'','',886,NULL);
INSERT INTO AudioTrack VALUES(887,'mpga',56000,44100,1,'','',887,NULL);
INSERT INTO AudioTrack VALUES(888,'mpga',56000,44100,1,'','',888,NULL);
INSERT INTO AudioTrack VALUES(889,'mpga',56000,44100,1,'','',889,NULL);
INSERT INTO AudioTrack VALUES(890,'mpga',56000,44100,1,'','',890,NULL);
INSERT INTO AudioTrack VALUES(891,'mpga',56000,44100,1,'','',891,NULL);
INSERT INTO AudioTrack VALUES(892,'mpga',56000,44100,1,'','',892,NULL);
INSERT INTO AudioTrack VALUES(893,'mpga',56000,44100,1,'','',893,NULL);
INSERT INTO AudioTrack VALUES(894,'mpga',56000,44100,1,'','',894,NULL);
INSERT INTO AudioTrack VALUES(895,'mpga',56000,44100,1,'','',895,NULL);
INSERT INTO AudioTrack VALUES(896,'mpga',56000,44100,1,'','',896,NULL);
INSERT INTO AudioTrack VALUES(897,'mpga',56000,44100,1,'','',897,NULL);
INSERT INTO AudioTrack VALUES(898,'mpga',56000,44100,1,'','',898,NULL);
INSERT INTO AudioTrack VALUES(899,'mpga',56000,44100,1,'','',899,NULL);
INSERT INTO AudioTrack VALUES(900,'mpga',56000,44100,1,'','',900,NULL);
INSERT INTO AudioTrack VALUES(901,'mpga',56000,44100,1,'','',901,NULL);
INSERT INTO AudioTrack VALUES(902,'mpga',56000,44100,1,'','',902,NULL);
INSERT INTO AudioTrack VALUES(903,'mpga',56000,44100,1,'','',903,NULL);
INSERT INTO AudioTrack VALUES(904,'mpga',56000,44100,1,'','',904,NULL);
INSERT INTO AudioTrack VALUES(905,'mpga',56000,44100,1,'','',905,NULL);
INSERT INTO AudioTrack VALUES(906,'mpga',56000,44100,1,'','',906,NULL);
INSERT INTO AudioTrack VALUES(907,'mpga',56000,44100,1,'','',907,NULL);
INSERT INTO AudioTrack VALUES(908,'mpga',56000,44100,1,'','',908,NULL);
INSERT INTO AudioTrack VALUES(909,'mpga',56000,44100,1,'','',909,NULL);
INSERT INTO AudioTrack VALUES(910,'mpga',56000,44100,1,'','',910,NULL);
INSERT INTO AudioTrack VALUES(911,'mpga',56000,44100,1,'','',911,NULL);
INSERT INTO AudioTrack VALUES(912,'mpga',56000,44100,1,'','',912,NULL);
INSERT INTO AudioTrack VALUES(913,'mpga',56000,44100,1,'','',913,NULL);
INSERT INTO AudioTrack VALUES(914,'mpga',56000,44100,1,'','',914,NULL);
INSERT INTO AudioTrack VALUES(915,'mpga',56000,44100,1,'','',915,NULL);
INSERT INTO AudioTrack VALUES(916,'mpga',56000,44100,1,'','',916,NULL);
INSERT INTO AudioTrack VALUES(917,'mpga',56000,44100,1,'','',917,NULL);
INSERT INTO AudioTrack VALUES(918,'mpga',56000,44100,1,'','',918,NULL);
INSERT INTO AudioTrack VALUES(919,'mpga',56000,44100,1,'','',919,NULL);
INSERT INTO AudioTrack VALUES(920,'mpga',56000,44100,1,'','',920,NULL);
INSERT INTO AudioTrack VALUES(921,'mpga',56000,44100,1,'','',921,NULL);
INSERT INTO AudioTrack VALUES(922,'mpga',56000,44100,1,'','',922,NULL);
INSERT INTO AudioTrack VALUES(923,'mpga',56000,44100,1,'','',923,NULL);
INSERT INTO AudioTrack VALUES(924,'mpga',56000,44100,1,'','',924,NULL);
INSERT INTO AudioTrack VALUES(925,'mpga',56000,44100,1,'','',925,NULL);
INSERT INTO AudioTrack VALUES(926,'mpga',56000,44100,1,'','',926,NULL);
INSERT INTO AudioTrack VALUES(927,'mpga',56000,44100,1,'','',927,NULL);
INSERT INTO AudioTrack VALUES(928,'mpga',56000,44100,1,'','',928,NULL);
INSERT INTO AudioTrack VALUES(929,'mpga',56000,44100,1,'','',929,NULL);
INSERT INTO AudioTrack VALUES(930,'mpga',56000,44100,1,'','',930,NULL);
INSERT INTO AudioTrack VALUES(931,'mpga',56000,44100,1,'','',931,NULL);
INSERT INTO AudioTrack VALUES(932,'mpga',56000,44100,1,'','',932,NULL);
INSERT INTO AudioTrack VALUES(933,'mpga',56000,44100,1,'','',933,NULL);
INSERT INTO AudioTrack VALUES(934,'mpga',56000,44100,1,'','',934,NULL);
INSERT INTO AudioTrack VALUES(935,'mpga',56000,44100,1,'','',935,NULL);
INSERT INTO AudioTrack VALUES(936,'mpga',56000,44100,1,'','',936,NULL);
INSERT INTO AudioTrack VALUES(937,'mpga',56000,44100,1,'','',937,NULL);
INSERT INTO AudioTrack VALUES(938,'mpga',56000,44100,1,'','',938,NULL);
INSERT INTO AudioTrack VALUES(939,'mpga',56000,44100,1,'','',939,NULL);
INSERT INTO AudioTrack VALUES(940,'mpga',56000,44100,1,'','',940,NULL);
INSERT INTO AudioTrack VALUES(941,'mpga',56000,44100,1,'','',941,NULL);
INSERT INTO AudioTrack VALUES(942,'mpga',56000,44100,1,'','',942,NULL);
INSERT INTO AudioTrack VALUES(943,'mpga',56000,44100,1,'','',943,NULL);
INSERT INTO AudioTrack VALUES(944,'mpga',56000,44100,1,'','',944,NULL);
INSERT INTO AudioTrack VALUES(945,'mpga',56000,44100,1,'','',945,NULL);
INSERT INTO AudioTrack VALUES(946,'mpga',56000,44100,1,'','',946,NULL);
INSERT INTO AudioTrack VALUES(947,'mpga',56000,44100,1,'','',947,NULL);
INSERT INTO AudioTrack VALUES(948,'mpga',56000,44100,1,'','',948,NULL);
INSERT INTO AudioTrack VALUES(949,'mpga',56000,44100,1,'','',949,NULL);
INSERT INTO AudioTrack VALUES(950,'mpga',56000,44100,1,'','',950,NULL);
INSERT INTO AudioTrack VALUES(951,'mpga',56000,44100,1,'','',951,NULL);
INSERT INTO AudioTrack VALUES(952,'mpga',56000,44100,1,'','',952,NULL);
INSERT INTO AudioTrack VALUES(953,'mpga',56000,44100,1,'','',953,NULL);
INSERT INTO AudioTrack VALUES(954,'mpga',56000,44100,1,'','',954,NULL);
INSERT INTO AudioTrack VALUES(955,'mpga',56000,44100,1,'','',955,NULL);
INSERT INTO AudioTrack VALUES(956,'mpga',56000,44100,1,'','',956,NULL);
INSERT INTO AudioTrack VALUES(957,'mpga',56000,44100,1,'','',957,NULL);
INSERT INTO AudioTrack VALUES(958,'mpga',56000,44100,1,'','',958,NULL);
INSERT INTO AudioTrack VALUES(959,'mpga',56000,44100,1,'','',959,NULL);
INSERT INTO AudioTrack VALUES(960,'mpga',56000,44100,1,'','',960,NULL);
INSERT INTO AudioTrack VALUES(961,'mpga',56000,44100,1,'','',961,NULL);
INSERT INTO AudioTrack VALUES(962,'mpga',56000,44100,1,'','',962,NULL);
INSERT INTO AudioTrack VALUES(963,'mpga',56000,44100,1,'','',963,NULL);
INSERT INTO AudioTrack VALUES(964,'mpga',56000,44100,1,'','',964,NULL);
INSERT INTO AudioTrack VALUES(965,'mpga',56000,44100,1,'','',965,NULL);
INSERT INTO AudioTrack VALUES(966,'mpga',56000,44100,1,'','',966,NULL);
INSERT INTO AudioTrack VALUES(967,'mpga',56000,44100,1,'','',967,NULL);
INSERT INTO AudioTrack VALUES(968,'mpga',56000,44100,1,'','',968,NULL);
INSERT INTO AudioTrack VALUES(969,'mpga',56000,44100,1,'','',969,NULL);
INSERT INTO AudioTrack VALUES(970,'mpga',56000,44100,1,'','',970,NULL);
INSERT INTO AudioTrack VALUES(971,'mpga',56000,44100,1,'','',971,NULL);
INSERT INTO AudioTrack VALUES(972,'mpga',56000,44100,1,'','',972,NULL);
INSERT INTO AudioTrack VALUES(973,'mpga',56000,44100,1,'','',973,NULL);
INSERT INTO AudioTrack VALUES(974,'mpga',56000,44100,1,'','',974,NULL);
INSERT INTO AudioTrack VALUES(975,'mpga',56000,44100,1,'','',975,NULL);
INSERT INTO AudioTrack VALUES(976,'mpga',56000,44100,1,'','',976,NULL);
INSERT INTO AudioTrack VALUES(977,'mpga',56000,44100,1,'','',977,NULL);
INSERT INTO AudioTrack VALUES(978,'mpga',56000,44100,1,'','',978,NULL);
INSERT INTO AudioTrack VALUES(979,'mpga',56000,44100,1,'','',979,NULL);
INSERT INTO AudioTrack VALUES(980,'mpga',56000,44100,1,'','',980,NULL);
INSERT INTO AudioTrack VALUES(981,'mpga',56000,44100,1,'','',981,NULL);
INSERT INTO AudioTrack VALUES(982,'mpga',56000,44100,1,'','',982,NULL);
INSERT INTO AudioTrack VALUES(983,'mpga',56000,44100,1,'','',983,NULL);
INSERT INTO AudioTrack VALUES(984,'mpga',56000,44100,1,'','',984,NULL);
INSERT INTO AudioTrack VALUES(985,'mpga',56000,44100,1,'','',985,NULL);
INSERT INTO AudioTrack VALUES(986,'mpga',56000,44100,1,'','',986,NULL);
INSERT INTO AudioTrack VALUES(987,'mpga',56000,44100,1,'','',987,NULL);
INSERT INTO AudioTrack VALUES(988,'mpga',56000,44100,1,'','',988,NULL);
INSERT INTO AudioTrack VALUES(989,'mpga',56000,44100,1,'','',989,NULL);
INSERT INTO AudioTrack VALUES(990,'mpga',56000,44100,1,'','',990,NULL);
INSERT INTO AudioTrack VALUES(991,'mpga',56000,44100,1,'','',991,NULL);
INSERT INTO AudioTrack VALUES(992,'mpga',56000,44100,1,'','',992,NULL);
INSERT INTO AudioTrack VALUES(993,'mpga',56000,44100,1,'','',993,NULL);
INSERT INTO AudioTrack VALUES(994,'mpga',56000,44100,1,'','',994,NULL);
INSERT INTO AudioTrack VALUES(995,'mpga',56000,44100,1,'','',995,NULL);
INSERT INTO AudioTrack VALUES(996,'mpga',56000,44100,1,'','',996,NULL);
INSERT INTO AudioTrack VALUES(997,'mpga',56000,44100,1,'','',997,NULL);
INSERT INTO AudioTrack VALUES(998,'mpga',56000,44100,1,'','',998,NULL);
INSERT INTO AudioTrack VALUES(999,'mpga',56000,44100,1,'','',999,NULL);
INSERT INTO AudioTrack VALUES(1000,'mpga',56000,44100,1,'','',1000,NULL);
INSERT INTO Artist VALUES(1,NULL,NULL,0,0,NULL,0);
INSERT INTO Artist VALUES(2,NULL,NULL,0,0,NULL,0);
INSERT INTO Artist VALUES(3,'artist_10',NULL,10,100,NULL,100);
INSERT INTO Artist VALUES(4,'artist_9',NULL,10,100,NULL,100);
INSERT INTO Artist VALUES(5,'artist_8',NULL,10,100,NULL,100);
INSERT INTO Artist VALUES(6,'artist_7',NULL,10,100,NULL,100);
INSERT INTO Artist VALUES(7,'artist_6',NULL,10,100,NULL,100);
INSERT INTO Artist VALUES(8,'artist_5',NULL,10,100,NULL,100);
INSERT INTO Artist VALUES(9,'artist_4',NULL,10,100,NULL,100);
INSERT INTO Artist VALUES(10,'artist_3',NULL,10,100,NULL,100);
INSERT INTO Artist VALUES(11,'artist_2',NULL,10,100,NULL,100);
INSERT INTO Artist VALUES(12,'artist_1',NULL,10,100,NULL,100);
INSERT INTO MediaArtistRelation VALUES(1,3);
INSERT INTO MediaArtistRelation VALUES(2,3);
INSERT INTO MediaArtistRelation VALUES(3,3);
INSERT INTO MediaArtistRelation VALUES(4,3);
INSERT INTO MediaArtistRelation VALUES(5,3);
INSERT INTO MediaArtistRelation VALUES(6,3);
INSERT INTO MediaArtistRelation VALUES(7,3);
INSERT INTO MediaArtistRelation VALUES(8,3);
INSERT INTO MediaArtistRelation VALUES(9,3);
INSERT INTO MediaArtistRelation VALUES(10,3);
INSERT INTO MediaArtistRelation VALUES(11,3);
INSERT INTO MediaArtistRelation VALUES(12,3);
INSERT INTO MediaArtistRelation VALUES(13,3);
INSERT INTO MediaArtistRelation VALUES(14,3);
INSERT INTO MediaArtistRelation VALUES(15,3);
INSERT INTO MediaArtistRelation VALUES(16,3);
INSERT INTO MediaArtistRelation VALUES(17,3);
INSERT INTO MediaArtistRelation VALUES(18,3);
INSERT INTO MediaArtistRelation VALUES(19,3);
INSERT INTO MediaArtistRelation VALUES(20,3);
INSERT INTO MediaArtistRelation VALUES(21,3);
INSERT INTO MediaArtistRelation VALUES(22,3);
INSERT INTO MediaArtistRelation VALUES(23,3);
INSERT INTO MediaArtistRelation VALUES(24,3);
INSERT INTO MediaArtistRelation VALUES(25,3);
INSERT INTO MediaArtistRelation VALUES(26,3);
INSERT INTO MediaArtistRelation VALUES(27,3);
INSERT INTO MediaArtistRelation VALUES(28,3);
INSERT INTO MediaArtistRelation VALUES(29,3);
INSERT INTO MediaArtistRelation VALUES(30,3);
INSERT INTO MediaArtistRelation VALUES(31,3);
INSERT INTO MediaArtistRelation VALUES(32,3);
INSERT INTO MediaArtistRelation VALUES(33,3);
INSERT INTO MediaArtistRelation VALUES(34,3);
INSERT INTO MediaArtistRelation VALUES(35,3);
INSERT INTO MediaArtistRelation VALUES(36,3);
INSERT INTO MediaArtistRelation VALUES(37,3);
INSERT INTO MediaArtistRelation VALUES(38,3);
INSERT INTO MediaArtistRelation VALUES(39,3);
INSERT INTO MediaArtistRelation VALUES(40,3);
INSERT INTO MediaArtistRelation VALUES(41,3);
INSERT INTO MediaArtistRelation VALUES(42,3);
INSERT INTO MediaArtistRelation VALUES(43,3);
INSERT INTO MediaArtistRelation VALUES(44,3);
INSERT INTO MediaArtistRelation VALUES(45,3);
INSERT INTO MediaArtistRelation VALUES(46,3);
INSERT INTO MediaArtistRelation VALUES(47,3);
INSERT INTO MediaArtistRelation VALUES(48,3);
INSERT INTO MediaArtistRelation VALUES(49,3);
INSERT INTO MediaArtistRelation VALUES(50,3);
INSERT INTO MediaArtistRelation VALUES(51,3);
INSERT INTO MediaArtistRelation VALUES(52,3);
INSERT INTO MediaArtistRelation VALUES(53,3);
INSERT INTO MediaArtistRelation VALUES(54,3);
INSERT INTO MediaArtistRelation VALUES(55,3);
INSERT INTO MediaArtistRelation VALUES(56,3);
INSERT INTO MediaArtistRelation VALUES(57,3);
INSERT INTO MediaArtistRelation VALUES(58,3);
INSERT INTO MediaArtistRelation VALUES(59,3);
INSERT INTO MediaArtistRelation VALUES(60,3);
INSERT INTO MediaArtistRelation VALUES(61,3);
INSERT INTO MediaArtistRelation VALUES(62,3);
INSERT INTO MediaArtistRelation VALUES(63,3);
INSERT INTO MediaArtistRelation VALUES(64,3);
INSERT INTO MediaArtistRelation VALUES(65,3);
INSERT INTO MediaArtistRelation VALUES(66,3);
INSERT INTO MediaArtistRelation VALUES(67,3);
INSERT INTO MediaArtistRelation VALUES(68,3);
INSERT INTO MediaArtistRelation VALUES(69,3);
INSERT INTO MediaArtistRelation VALUES(70,3);
INSERT INTO MediaArtistRelation VALUES(71,3);
INSERT INTO MediaArtistRelation VALUES(72,3);
INSERT INTO MediaArtistRelation VALUES(73,3);
INSERT INTO MediaArtistRelation VALUES(74,3);
INSERT INTO MediaArtistRelation VALUES(75,3);
INSERT INTO MediaArtistRelation VALUES(76,3);
INSERT INTO MediaArtistRelation VALUES(77,3);
INSERT INTO MediaArtistRelation VALUES(78,3);
INSERT INTO MediaArtistRelation VALUES(79,3);
INSERT INTO MediaArtistRelation VALUES(80,3);
INSERT INTO MediaArtistRelation VALUES(81,3);
INSERT INTO MediaArtistRelation VALUES(82,3);
INSERT INTO MediaArtistRelation VALUES(83,3);
INSERT INTO MediaArtistRelation VALUES(84,3);
INSERT INTO MediaArtistRelation VALUES(85,3);
INSERT INTO MediaArtistRelation VALUES(86,3);
INSERT INTO MediaArtistRelation VALUES(87,3);
INSERT INTO MediaArtistRelation VALUES(88,3);
INSERT INTO MediaArtistRelation VALUES(89,3);
INSERT INTO MediaArtistRelation VALUES(90,3);
INSERT INTO MediaArtistRelation VALUES(91,3);
INSERT INTO MediaArtistRelation VALUES(92,3);
INSERT INTO MediaArtistRelation VALUES(93,3);
INSERT INTO MediaArtistRelation VALUES(94,3);
INSERT INTO MediaArtistRelation VALUES(95,3);
INSERT INTO MediaArtistRelation VALUES(96,3);
INSERT INTO MediaArtistRelation VALUES(97,3);
INSERT INTO MediaArtistRelation VALUES(98,3);
INSERT INTO MediaArtistRelation VALUES(99,3);
INSERT INTO MediaArtistRelation VALUES(100,3);
INSERT INTO MediaArtistRelation VALUES(101,4);
INSERT INTO MediaArtistRelation VALUES(102,4);
INSERT INTO MediaArtistRelation VALUES(103,4);
INSERT INTO MediaArtistRelation VALUES(104,4);
INSERT INTO MediaArtistRelation VALUES(105,4);
INSERT INTO MediaArtistRelation VALUES(106,4);
INSERT INTO MediaArtistRelation VALUES(107,4);
INSERT INTO MediaArtistRelation VALUES(108,4);
INSERT INTO MediaArtistRelation VALUES(109,4);
INSERT INTO MediaArtistRelation VALUES(110,4);
INSERT INTO MediaArtistRelation VALUES(111,4);
INSERT INTO MediaArtistRelation VALUES(112,4);
INSERT INTO MediaArtistRelation VALUES(113,4);
INSERT INTO MediaArtistRelation VALUES(114,4);
INSERT INTO MediaArtistRelation VALUES(115,4);
INSERT INTO MediaArtistRelation VALUES(116,4);
INSERT INTO MediaArtistRelation VALUES(117,4);
INSERT INTO MediaArtistRelation VALUES(118,4);
INSERT INTO MediaArtistRelation VALUES(119,4);
INSERT INTO MediaArtistRelation VALUES(120,4);
INSERT INTO MediaArtistRelation VALUES(121,4);
INSERT INTO MediaArtistRelation VALUES(122,4);
INSERT INTO MediaArtistRelation VALUES(123,4);
INSERT INTO MediaArtistRelation VALUES(124,4);
INSERT INTO MediaArtistRelation VALUES(125,4);
INSERT INTO MediaArtistRelation VALUES(126,4);
INSERT INTO MediaArtistRelation VALUES(127,4);
INSERT INTO MediaArtistRelation VALUES(128,4);
INSERT INTO MediaArtistRelation VALUES(129,4);
INSERT INTO MediaArtistRelation VALUES(130,4);
INSERT INTO MediaArtistRelation VALUES(131,4);
INSERT INTO MediaArtistRelation VALUES(132,4);
INSERT INTO MediaArtistRelation VALUES(133,4);
INSERT INTO MediaArtistRelation VALUES(134,4);
INSERT INTO MediaArtistRelation VALUES(135,4);
INSERT INTO MediaArtistRelation VALUES(136,4);
INSERT INTO MediaArtistRelation VALUES(137,4);
INSERT INTO MediaArtistRelation VALUES(138,4);
INSERT INTO MediaArtistRelation VALUES(139,4);
INSERT INTO MediaArtistRelation VALUES(140,4);
INSERT INTO MediaArtistRelation VALUES(141,4);
INSERT INTO MediaArtistRelation VALUES(142,4);
INSERT INTO MediaArtistRelation VALUES(143,4);
INSERT INTO MediaArtistRelation VALUES(144,4);
INSERT INTO MediaArtistRelation VALUES(145,4);
INSERT INTO MediaArtistRelation VALUES(146,4);
INSERT INTO MediaArtistRelation VALUES(147,4);
INSERT INTO MediaArtistRelation VALUES(148,4);
INSERT INTO MediaArtistRelation VALUES(149,4);
INSERT INTO MediaArtistRelation VALUES(150,4);
INSERT INTO MediaArtistRelation VALUES(151,4);
INSERT INTO MediaArtistRelation VALUES(152,4);
INSERT INTO MediaArtistRelation VALUES(153,4);
INSERT INTO MediaArtistRelation VALUES(154,4);
INSERT INTO MediaArtistRelation VALUES(155,4);
INSERT INTO MediaArtistRelation VALUES(156,4);
INSERT INTO MediaArtistRelation VALUES(157,4);
INSERT INTO MediaArtistRelation VALUES(158,4);
INSERT INTO MediaArtistRelation VALUES(159,4);
INSERT INTO MediaArtistRelation VALUES(160,4);
INSERT INTO MediaArtistRelation VALUES(161,4);
INSERT INTO MediaArtistRelation VALUES(162,4);
INSERT INTO MediaArtistRelation VALUES(163,4);
INSERT INTO MediaArtistRelation VALUES(164,4);
INSERT INTO MediaArtistRelation VALUES(165,4);
INSERT INTO MediaArtistRelation VALUES(166,4);
INSERT INTO MediaArtistRelation VALUES(167,4);
INSERT INTO MediaArtistRelation VALUES(168,4);
INSERT INTO MediaArtistRelation VALUES(169,4);
INSERT INTO MediaArtistRelation VALUES(170,4);
INSERT INTO MediaArtistRelation VALUES(171,4);
INSERT INTO MediaArtistRelation VALUES(172,4);
INSERT INTO MediaArtistRelation VALUES(173,4);
INSERT INTO MediaArtistRelation VALUES(174,4);
INSERT INTO MediaArtistRelation VALUES(175,4);
INSERT INTO MediaArtistRelation VALUES(176,4);
INSERT INTO MediaArtistRelation VALUES(177,4);
INSERT INTO MediaArtistRelation VALUES(178,4);
INSERT INTO MediaArtistRelation VALUES(179,4);
INSERT INTO MediaArtistRelation VALUES(180,4);
INSERT INTO MediaArtistRelation VALUES(181,4);
INSERT INTO MediaArtistRelation VALUES(182,4);
INSERT INTO MediaArtistRelation VALUES(183,4);
INSERT INTO MediaArtistRelation VALUES(184,4);
INSERT INTO MediaArtistRelation VALUES(185,4);
INSERT INTO MediaArtistRelation VALUES(186,4);
INSERT INTO MediaArtistRelation VALUES(187,4);
INSERT INTO MediaArtistRelation VALUES(188,4);
INSERT INTO MediaArtistRelation VALUES(189,4);
INSERT INTO MediaArtistRelation VALUES(190,4);
INSERT INTO MediaArtistRelation VALUES(191,4);
INSERT INTO MediaArtistRelation VALUES(192,4);
INSERT INTO MediaArtistRelation VALUES(193,4);
INSERT INTO MediaArtistRelation VALUES(194,4);
INSERT INTO MediaArtistRelation VALUES(195,4);
INSERT INTO MediaArtistRelation VALUES(196,4);
INSERT INTO MediaArtistRelation VALUES(197,4);
INSERT INTO MediaArtistRelation VALUES(198,4);
INSERT INTO MediaArtistRelation VALUES(199,4);
INSERT INTO MediaArtistRelation VALUES(200,4);
INSERT INTO MediaArtistRelation VALUES(201,5);
INSERT INTO MediaArtistRelation VALUES(202,5);
INSERT INTO MediaArtistRelation VALUES(203,5);
INSERT INTO MediaArtistRelation VALUES(204,5);
INSERT INTO MediaArtistRelation VALUES(205,5);
INSERT INTO MediaArtistRelation VALUES(206,5);
INSERT INTO MediaArtistRelation VALUES(207,5);
INSERT INTO MediaArtistRelation VALUES(208,5);
INSERT INTO MediaArtistRelation VALUES(209,5);
INSERT INTO MediaArtistRelation VALUES(210,5);
INSERT INTO MediaArtistRelation VALUES(211,5);
INSERT INTO MediaArtistRelation VALUES(212,5);
INSERT INTO MediaArtistRelation VALUES(213,5);
INSERT INTO MediaArtistRelation VALUES(214,5);
INSERT INTO MediaArtistRelation VALUES(215,5);
INSERT INTO MediaArtistRelation VALUES(216,5);
INSERT INTO MediaArtistRelation VALUES(217,5);
INSERT INTO MediaArtistRelation VALUES(218,5);
INSERT INTO MediaArtistRelation VALUES(219,5);
INSERT INTO MediaArtistRelation VALUES(220,5);
INSERT INTO MediaArtistRelation VALUES(221,5);
INSERT INTO MediaArtistRelation VALUES(222,5);
INSERT INTO MediaArtistRelation VALUES(223,5);
INSERT INTO MediaArtistRelation VALUES(224,5);
INSERT INTO MediaArtistRelation VALUES(225,5);
INSERT INTO MediaArtistRelation VALUES(226,5);
INSERT INTO MediaArtistRelation VALUES(227,5);
INSERT INTO MediaArtistRelation VALUES(228,5);
INSERT INTO MediaArtistRelation VALUES(229,5);
INSERT INTO MediaArtistRelation VALUES(230,5);
INSERT INTO MediaArtistRelation VALUES(231,5);
INSERT INTO MediaArtistRelation VALUES(232,5);
INSERT INTO MediaArtistRelation VALUES(233,5);
INSERT INTO MediaArtistRelation VALUES(234,5);
INSERT INTO MediaArtistRelation VALUES(235,5);
INSERT INTO MediaArtistRelation VALUES(236,5);
INSERT INTO MediaArtistRelation VALUES(237,5);
INSERT INTO MediaArtistRelation VALUES(238,5);
INSERT INTO MediaArtistRelation VALUES(239,5);
INSERT INTO MediaArtistRelation VALUES(240,5);
INSERT INTO MediaArtistRelation VALUES(241,5);
INSERT INTO MediaArtistRelation VALUES(242,5);
INSERT INTO MediaArtistRelation VALUES(243,5);
INSERT INTO MediaArtistRelation VALUES(244,5);
INSERT INTO MediaArtistRelation VALUES(245,5);
INSERT INTO MediaArtistRelation VALUES(246,5);
INSERT INTO MediaArtistRelation VALUES(247,5);
INSERT INTO MediaArtistRelation VALUES(248,5);
INSERT INTO MediaArtistRelation VALUES(249,5);
INSERT INTO MediaArtistRelation VALUES(250,5);
INSERT INTO MediaArtistRelation VALUES(251,5);
INSERT INTO MediaArtistRelation VALUES(252,5);
INSERT INTO MediaArtistRelation VALUES(253,5);
INSERT INTO MediaArtistRelation VALUES(254,5);
INSERT INTO MediaArtistRelation VALUES(255,5);
INSERT INTO MediaArtistRelation VALUES(256,5);
INSERT INTO MediaArtistRelation VALUES(257,5);
INSERT INTO MediaArtistRelation VALUES(258,5);
INSERT INTO MediaArtistRelation VALUES(259,5);
INSERT INTO MediaArtistRelation VALUES(260,5);
INSERT INTO MediaArtistRelation VALUES(261,5);
INSERT INTO MediaArtistRelation VALUES(262,5);
INSERT INTO MediaArtistRelation VALUES(263,5);
INSERT INTO MediaArtistRelation VALUES(264,5);
INSERT INTO MediaArtistRelation VALUES(265,5);
INSERT INTO MediaArtistRelation VALUES(266,5);
INSERT INTO MediaArtistRelation VALUES(267,5);
INSERT INTO MediaArtistRelation VALUES(268,5);
INSERT INTO MediaArtistRelation VALUES(269,5);
INSERT INTO MediaArtistRelation VALUES(270,5);
INSERT INTO MediaArtistRelation VALUES(271,5);
INSERT INTO MediaArtistRelation VALUES(272,5);
INSERT INTO MediaArtistRelation VALUES(273,5);
INSERT INTO MediaArtistRelation VALUES(274,5);
INSERT INTO MediaArtistRelation VALUES(275,5);
INSERT INTO MediaArtistRelation VALUES(276,5);
INSERT INTO MediaArtistRelation VALUES(277,5);
INSERT INTO MediaArtistRelation VALUES(278,5);
INSERT INTO MediaArtistRelation VALUES(279,5);
INSERT INTO MediaArtistRelation VALUES(280,5);
INSERT INTO MediaArtistRelation VALUES(281,5);
INSERT INTO MediaArtistRelation VALUES(282,5);
INSERT INTO MediaArtistRelation VALUES(283,5);
INSERT INTO MediaArtistRelation VALUES(284,5);
INSERT INTO MediaArtistRelation VALUES(285,5);
INSERT INTO MediaArtistRelation VALUES(286,5);
INSERT INTO MediaArtistRelation VALUES(287,5);
INSERT INTO MediaArtistRelation VALUES(288,5);
INSERT INTO MediaArtistRelation VALUES(289,5);
INSERT INTO MediaArtistRelation VALUES(290,5);
INSERT INTO MediaArtistRelation VALUES(291,5);
INSERT INTO MediaArtistRelation VALUES(292,5);
INSERT INTO MediaArtistRelation VALUES(293,5);
INSERT INTO MediaArtistRelation VALUES(294,5);
INSERT INTO MediaArtistRelation VALUES(295,5);
INSERT INTO MediaArtistRelation VALUES(296,5);
INSERT INTO MediaArtistRelation VALUES(297,5);
INSERT INTO MediaArtistRelation VALUES(298,5);
INSERT INTO MediaArtistRelation VALUES(299,5);
INSERT INTO MediaArtistRelation VALUES(300,5);
INSERT INTO MediaArtistRelation VALUES(301,6);
INSERT INTO MediaArtistRelation VALUES(302,6);
INSERT INTO MediaArtistRelation VALUES(303,6);
INSERT INTO MediaArtistRelation VALUES(304,6);
INSERT INTO MediaArtistRelation VALUES(305,6);
INSERT INTO MediaArtistRelation VALUES(306,6);
INSERT INTO MediaArtistRelation VALUES(307,6);
INSERT INTO MediaArtistRelation VALUES(308,6);
INSERT INTO MediaArtistRelation VALUES(309,6);
INSERT INTO MediaArtistRelation VALUES(310,6);
INSERT INTO MediaArtistRelation VALUES(311,6);
INSERT INTO MediaArtistRelation VALUES(312,6);
INSERT INTO MediaArtistRelation VALUES(313,6);
INSERT INTO MediaArtistRelation VALUES(314,6);
INSERT INTO MediaArtistRelation VALUES(315,6);
INSERT INTO MediaArtistRelation VALUES(316,6);
INSERT INTO MediaArtistRelation VALUES(317,6);
INSERT INTO MediaArtistRelation VALUES(318,6);
INSERT INTO MediaArtistRelation VALUES(319,6);
INSERT INTO MediaArtistRelation VALUES(320,6);
INSERT INTO MediaArtistRelation VALUES(321,6);
INSERT INTO MediaArtistRelation VALUES(322,6);
INSERT INTO MediaArtistRelation VALUES(323,6);
INSERT INTO MediaArtistRelation VALUES(324,6);
INSERT INTO MediaArtistRelation VALUES(325,6);
INSERT INTO MediaArtistRelation VALUES(326,6);
INSERT INTO MediaArtistRelation VALUES(327,6);
INSERT INTO MediaArtistRelation VALUES(328,6);
INSERT INTO MediaArtistRelation VALUES(329,6);
INSERT INTO MediaArtistRelation VALUES(330,6);
INSERT INTO MediaArtistRelation VALUES(331,6);
INSERT INTO MediaArtistRelation VALUES(332,6);
INSERT INTO MediaArtistRelation VALUES(333,6);
INSERT INTO MediaArtistRelation VALUES(334,6);
INSERT INTO MediaArtistRelation VALUES(335,6);
INSERT INTO MediaArtistRelation VALUES(336,6);
INSERT INTO MediaArtistRelation VALUES(337,6);
INSERT INTO MediaArtistRelation VALUES(338,6);
INSERT INTO MediaArtistRelation VALUES(339,6);
INSERT INTO MediaArtistRelation VALUES(340,6);
INSERT INTO MediaArtistRelation VALUES(341,6);
INSERT INTO MediaArtistRelation VALUES(342,6);
INSERT INTO MediaArtistRelation VALUES(343,6);
INSERT INTO MediaArtistRelation VALUES(344,6);
INSERT INTO MediaArtistRelation VALUES(345,6);
INSERT INTO MediaArtistRelation VALUES(346,6);
INSERT INTO MediaArtistRelation VALUES(347,6);
INSERT INTO MediaArtistRelation VALUES(348,6);
INSERT INTO MediaArtistRelation VALUES(349,6);
INSERT INTO MediaArtistRelation VALUES(350,6);
INSERT INTO MediaArtistRelation VALUES(351,6);
INSERT INTO MediaArtistRelation VALUES(352,6);
INSERT INTO MediaArtistRelation VALUES(353,6);
INSERT INTO MediaArtistRelation VALUES(354,6);
INSERT INTO MediaArtistRelation VALUES(355,6);
INSERT INTO MediaArtistRelation VALUES(356,6);
INSERT INTO MediaArtistRelation VALUES(357,6);
INSERT INTO MediaArtistRelation VALUES(358,6);
INSERT INTO MediaArtistRelation VALUES(359,6);
INSERT INTO MediaArtistRelation VALUES(360,6);
INSERT INTO MediaArtistRelation VALUES(361,6);
INSERT INTO MediaArtistRelation VALUES(362,6);
INSERT INTO MediaArtistRelation VALUES(363,6);
INSERT INTO MediaArtistRelation VALUES(364,6);
INSERT INTO MediaArtistRelation VALUES(365,6);
INSERT INTO MediaArtistRelation VALUES(366,6);
INSERT INTO MediaArtistRelation VALUES(367,6);
INSERT INTO MediaArtistRelation VALUES(368,6);
INSERT INTO MediaArtistRelation VALUES(369,6);
INSERT INTO MediaArtistRelation VALUES(370,6);
INSERT INTO MediaArtistRelation VALUES(371,6);
INSERT INTO MediaArtistRelation VALUES(372,6);
INSERT INTO MediaArtistRelation VALUES(373,6);
INSERT INTO MediaArtistRelation VALUES(374,6);
INSERT INTO MediaArtistRelation VALUES(375,6);
INSERT INTO MediaArtistRelation VALUES(376,6);
INSERT INTO MediaArtistRelation VALUES(377,6);
INSERT INTO MediaArtistRelation VALUES(378,6);
INSERT INTO MediaArtistRelation VALUES(379,6);
INSERT INTO MediaArtistRelation VALUES(380,6);
INSERT INTO MediaArtistRelation VALUES(381,6);
INSERT INTO MediaArtistRelation VALUES(382,6);
INSERT INTO MediaArtistRelation VALUES(383,6);
INSERT INTO MediaArtistRelation VALUES(384,6);
INSERT INTO MediaArtistRelation VALUES(385,6);
INSERT INTO MediaArtistRelation VALUES(386,6);
INSERT INTO MediaArtistRelation VALUES(387,6);
INSERT INTO MediaArtistRelation VALUES(388,6);
INSERT INTO MediaArtistRelation VALUES(389,6);
INSERT INTO MediaArtistRelation VALUES(390,6);
INSERT INTO MediaArtistRelation VALUES(391,6);
INSERT INTO MediaArtistRelation VALUES(392,6);
INSERT INTO MediaArtistRelation VALUES(393,6);
INSERT INTO MediaArtistRelation VALUES(394,6);
INSERT INTO MediaArtistRelation VALUES(395,6);
INSERT INTO MediaArtistRelation VALUES(396,6);
INSERT INTO MediaArtistRelation VALUES(397,6);
INSERT INTO MediaArtistRelation VALUES(398,6);
INSERT INTO MediaArtistRelation VALUES(399,6);
INSERT INTO MediaArtistRelation VALUES(400,6);
INSERT INTO MediaArtistRelation VALUES(401,7);
INSERT INTO MediaArtistRelation VALUES(402,7);
INSERT INTO MediaArtistRelation VALUES(403,7);
INSERT INTO MediaArtistRelation VALUES(404,7);
INSERT INTO MediaArtistRelation VALUES(405,7);
INSERT INTO MediaArtistRelation VALUES(406,7);
INSERT INTO MediaArtistRelation VALUES(407,7);
INSERT INTO MediaArtistRelation VALUES(408,7);
INSERT INTO MediaArtistRelation VALUES(409,7);
INSERT INTO MediaArtistRelation VALUES(410,7);
INSERT INTO MediaArtistRelation VALUES(411,7);
INSERT INTO MediaArtistRelation VALUES(412,7);
INSERT INTO MediaArtistRelation VALUES(413,7);
INSERT INTO MediaArtistRelation VALUES(414,7);
INSERT INTO MediaArtistRelation VALUES(415,7);
INSERT INTO MediaArtistRelation VALUES(416,7);
INSERT INTO MediaArtistRelation VALUES(417,7);
INSERT INTO MediaArtistRelation VALUES(418,7);
INSERT INTO MediaArtistRelation VALUES(419,7);
INSERT INTO MediaArtistRelation VALUES(420,7);
INSERT INTO MediaArtistRelation VALUES(421,7);
INSERT INTO MediaArtistRelation VALUES(422,7);
INSERT INTO MediaArtistRelation VALUES(423,7);
INSERT INTO MediaArtistRelation VALUES(424,7);
INSERT INTO MediaArtistRelation VALUES(425,7);
INSERT INTO MediaArtistRelation VALUES(426,7);
INSERT INTO MediaArtistRelation VALUES(427,7);
INSERT INTO MediaArtistRelation VALUES(428,7);
INSERT INTO MediaArtistRelation VALUES(429,7);
INSERT INTO MediaArtistRelation VALUES(430,7);
INSERT INTO MediaArtistRelation VALUES(431,7);
INSERT INTO MediaArtistRelation VALUES(432,7);
INSERT INTO MediaArtistRelation VALUES(433,7);
INSERT INTO MediaArtistRelation VALUES(434,7);
INSERT INTO MediaArtistRelation VALUES(435,7);
INSERT INTO MediaArtistRelation VALUES(436,7);
INSERT INTO MediaArtistRelation VALUES(437,7);
INSERT INTO MediaArtistRelation VALUES(438,7);
INSERT INTO MediaArtistRelation VALUES(439,7);
INSERT INTO MediaArtistRelation VALUES(440,7);
INSERT INTO MediaArtistRelation VALUES(441,7);
INSERT INTO MediaArtistRelation VALUES(442,7);
INSERT INTO MediaArtistRelation VALUES(443,7);
INSERT INTO MediaArtistRelation VALUES(444,7);
INSERT INTO MediaArtistRelation VALUES(445,7);
INSERT INTO MediaArtistRelation VALUES(446,7);
INSERT INTO MediaArtistRelation VALUES(447,7);
INSERT INTO MediaArtistRelation VALUES(448,7);
INSERT INTO MediaArtistRelation VALUES(449,7);
INSERT INTO MediaArtistRelation VALUES(450,7);
INSERT INTO MediaArtistRelation VALUES(451,7);
INSERT INTO MediaArtistRelation VALUES(452,7);
INSERT INTO MediaArtistRelation VALUES(453,7);
INSERT INTO MediaArtistRelation VALUES(454,7);
INSERT INTO MediaArtistRelation VALUES(455,7);
INSERT INTO MediaArtistRelation VALUES(456,7);
INSERT INTO MediaArtistRelation VALUES(457,7);
INSERT INTO MediaArtistRelation VALUES(458,7);
INSERT INTO MediaArtistRelation VALUES(459,7);
INSERT INTO MediaArtistRelation VALUES(460,7);
INSERT INTO MediaArtistRelation VALUES(461,7);
INSERT INTO MediaArtistRelation VALUES(462,7);
INSERT INTO MediaArtistRelation VALUES(463,7);
INSERT INTO MediaArtistRelation VALUES(464,7);
INSERT INTO MediaArtistRelation VALUES(465,7);
INSERT INTO MediaArtistRelation VALUES(466,7);
INSERT INTO MediaArtistRelation VALUES(467,7);
INSERT INTO MediaArtistRelation VALUES(468,7);
INSERT INTO MediaArtistRelation VALUES(469,7);
INSERT INTO MediaArtistRelation VALUES(470,7);
INSERT INTO MediaArtistRelation VALUES(471,7);
INSERT INTO MediaArtistRelation VALUES(472,7);
INSERT INTO MediaArtistRelation VALUES(473,7);
INSERT INTO MediaArtistRelation VALUES(474,7);
INSERT INTO MediaArtistRelation VALUES(475,7);
INSERT INTO MediaArtistRelation VALUES(476,7);
INSERT INTO MediaArtistRelation VALUES(477,7);
INSERT INTO MediaArtistRelation VALUES(478,7);
INSERT INTO MediaArtistRelation VALUES(479,7);
INSERT INTO MediaArtistRelation VALUES(480,7);
INSERT INTO MediaArtistRelation VALUES(481,7);
INSERT INTO MediaArtistRelation VALUES(482,7);
INSERT INTO MediaArtistRelation VALUES(483,7);
INSERT INTO MediaArtistRelation VALUES(484,7);
INSERT INTO MediaArtistRelation VALUES(485,7);
INSERT INTO MediaArtistRelation VALUES(486,7);
INSERT INTO MediaArtistRelation VALUES(487,7);
INSERT INTO MediaArtistRelation VALUES(488,7);
INSERT INTO MediaArtistRelation VALUES(489,7);
INSERT INTO MediaArtistRelation VALUES(490,7);
INSERT INTO MediaArtistRelation VALUES(491,7);
INSERT INTO MediaArtistRelation VALUES(492,7);
INSERT INTO MediaArtistRelation VALUES(493,7);
INSERT INTO MediaArtistRelation VALUES(494,7);
INSERT INTO MediaArtistRelation VALUES(495,7);
INSERT INTO MediaArtistRelation VALUES(496,7);
INSERT INTO MediaArtistRelation VALUES(497,7);
INSERT INTO MediaArtistRelation VALUES(498,7);
INSERT INTO MediaArtistRelation VALUES(499,7);
INSERT INTO MediaArtistRelation VALUES(500,7);
INSERT INTO MediaArtistRelation VALUES(501,8);
INSERT INTO MediaArtistRelation VALUES(502,8);
INSERT INTO MediaArtistRelation VALUES(503,8);
INSERT INTO MediaArtistRelation VALUES(504,8);
INSERT INTO MediaArtistRelation VALUES(505,8);
INSERT INTO MediaArtistRelation VALUES(506,8);
INSERT INTO MediaArtistRelation VALUES(507,8);
INSERT INTO MediaArtistRelation VALUES(508,8);
INSERT INTO MediaArtistRelation VALUES(509,8);
INSERT INTO MediaArtistRelation VALUES(510,8);
INSERT INTO MediaArtistRelation VALUES(511,8);
INSERT INTO MediaArtistRelation VALUES(512,8);
INSERT INTO MediaArtistRelation VALUES(513,8);
INSERT INTO MediaArtistRelation VALUES(514,8);
INSERT INTO MediaArtistRelation VALUES(515,8);
INSERT INTO MediaArtistRelation VALUES(516,8);
INSERT INTO MediaArtistRelation VALUES(517,8);
INSERT INTO MediaArtistRelation VALUES(518,8);
INSERT INTO MediaArtistRelation VALUES(519,8);
INSERT INTO MediaArtistRelation VALUES(520,8);
INSERT INTO MediaArtistRelation VALUES(521,8);
INSERT INTO MediaArtistRelation VALUES(522,8);
INSERT INTO MediaArtistRelation VALUES(523,8);
INSERT INTO MediaArtistRelation VALUES(524,8);
INSERT INTO MediaArtistRelation VALUES(525,8);
INSERT INTO MediaArtistRelation VALUES(526,8);
INSERT INTO MediaArtistRelation VALUES(527,8);
INSERT INTO MediaArtistRelation VALUES(528,8);
INSERT INTO MediaArtistRelation VALUES(529,8);
INSERT INTO MediaArtistRelation VALUES(530,8);
INSERT INTO MediaArtistRelation VALUES(531,8);
INSERT INTO MediaArtistRelation VALUES(532,8);
INSERT INTO MediaArtistRelation VALUES(533,8);
INSERT INTO MediaArtistRelation VALUES(534,8);
INSERT INTO MediaArtistRelation VALUES(535,8);
INSERT INTO MediaArtistRelation VALUES(536,8);
INSERT INTO MediaArtistRelation VALUES(537,8);
INSERT INTO MediaArtistRelation VALUES(538,8);
INSERT INTO MediaArtistRelation VALUES(539,8);
INSERT INTO MediaArtistRelation VALUES(540,8);
INSERT INTO MediaArtistRelation VALUES(541,8);
INSERT INTO MediaArtistRelation VALUES(542,8);
INSERT INTO MediaArtistRelation VALUES(543,8);
INSERT INTO MediaArtistRelation VALUES(544,8);
INSERT INTO MediaArtistRelation VALUES(545,8);
INSERT INTO MediaArtistRelation VALUES(546,8);
INSERT INTO MediaArtistRelation VALUES(547,8);
INSERT INTO MediaArtistRelation VALUES(548,8);
INSERT INTO MediaArtistRelation VALUES(549,8);
INSERT INTO MediaArtistRelation VALUES(550,8);
INSERT INTO MediaArtistRelation VALUES(551,8);
INSERT INTO MediaArtistRelation VALUES(552,8);
INSERT INTO MediaArtistRelation VALUES(553,8);
INSERT INTO MediaArtistRelation VALUES(554,8);
INSERT INTO MediaArtistRelation VALUES(555,8);
INSERT INTO MediaArtistRelation VALUES(556,8);
INSERT INTO MediaArtistRelation VALUES(557,8);
INSERT INTO MediaArtistRelation VALUES(558,8);
INSERT INTO MediaArtistRelation VALUES(559,8);
INSERT INTO MediaArtistRelation VALUES(560,8);
INSERT INTO MediaArtistRelation VALUES(561,8);
INSERT INTO MediaArtistRelation VALUES(562,8);
INSERT INTO MediaArtistRelation VALUES(563,8);
INSERT INTO MediaArtistRelation VALUES(564,8);
INSERT INTO MediaArtistRelation VALUES(565,8);
INSERT INTO MediaArtistRelation VALUES(566,8);
INSERT INTO MediaArtistRelation VALUES(567,8);
INSERT INTO MediaArtistRelation VALUES(568,8);
INSERT INTO MediaArtistRelation VALUES(569,8);
INSERT INTO MediaArtistRelation VALUES(570,8);
INSERT INTO MediaArtistRelation VALUES(571,8);
INSERT INTO MediaArtistRelation VALUES(572,8);
INSERT INTO MediaArtistRelation VALUES(573,8);
INSERT INTO MediaArtistRelation VALUES(574,8);
INSERT INTO MediaArtistRelation VALUES(575,8);
INSERT INTO MediaArtistRelation VALUES(576,8);
INSERT INTO MediaArtistRelation VALUES(577,8);
INSERT INTO MediaArtistRelation VALUES(578,8);
INSERT INTO MediaArtistRelation VALUES(579,8);
INSERT INTO MediaArtistRelation VALUES(580,8);
INSERT INTO MediaArtistRelation VALUES(581,8);
INSERT INTO MediaArtistRelation VALUES(582,8);
INSERT INTO MediaArtistRelation VALUES(583,8);
INSERT INTO MediaArtistRelation VALUES(584,8);
INSERT INTO MediaArtistRelation VALUES(585,8);
INSERT INTO MediaArtistRelation VALUES(586,8);
INSERT INTO MediaArtistRelation VALUES(587,8);
INSERT INTO MediaArtistRelation VALUES(588,8);
INSERT INTO MediaArtistRelation VALUES(589,8);
INSERT INTO MediaArtistRelation VALUES(590,8);
INSERT INTO MediaArtistRelation VALUES(591,8);
INSERT INTO MediaArtistRelation VALUES(592,8);
INSERT INTO MediaArtistRelation VALUES(593,8);
INSERT INTO MediaArtistRelation VALUES(594,8);
INSERT INTO MediaArtistRelation VALUES(595,8);
INSERT INTO MediaArtistRelation VALUES(596,8);
INSERT INTO MediaArtistRelation VALUES(597,8);
INSERT INTO MediaArtistRelation VALUES(598,8);
INSERT INTO MediaArtistRelation VALUES(599,8);
INSERT INTO MediaArtistRelation VALUES(600,8);
INSERT INTO MediaArtistRelation VALUES(601,9);
INSERT INTO MediaArtistRelation VALUES(602,9);
INSERT INTO MediaArtistRelation VALUES(603,9);
INSERT INTO MediaArtistRelation VALUES(604,9);
INSERT INTO MediaArtistRelation VALUES(605,9);
INSERT INTO MediaArtistRelation VALUES(606,9);
INSERT INTO MediaArtistRelation VALUES(607,9);
INSERT INTO MediaArtistRelation VALUES(608,9);
INSERT INTO MediaArtistRelation VALUES(609,9);
INSERT INTO MediaArtistRelation VALUES(610,9);
INSERT INTO MediaArtistRelation VALUES(611,9);
INSERT INTO MediaArtistRelation VALUES(612,9);
INSERT INTO MediaArtistRelation VALUES(613,9);
INSERT INTO MediaArtistRelation VALUES(614,9);
INSERT INTO MediaArtistRelation VALUES(615,9);
INSERT INTO MediaArtistRelation VALUES(616,9);
INSERT INTO MediaArtistRelation VALUES(617,9);
INSERT INTO MediaArtistRelation VALUES(618,9);
INSERT INTO MediaArtistRelation VALUES(619,9);
INSERT INTO MediaArtistRelation VALUES(620,9);
INSERT INTO MediaArtistRelation VALUES(621,9);
INSERT INTO MediaArtistRelation VALUES(622,9);
INSERT INTO MediaArtistRelation VALUES(623,9);
INSERT INTO MediaArtistRelation VALUES(624,9);
INSERT INTO MediaArtistRelation VALUES(625,9);
INSERT INTO MediaArtistRelation VALUES(626,9);
INSERT INTO MediaArtistRelation VALUES(627,9);
INSERT INTO MediaArtistRelation VALUES(628,9);
INSERT INTO MediaArtistRelation VALUES(629,9);
INSERT INTO MediaArtistRelation VALUES(630,9);
INSERT INTO MediaArtistRelation VALUES(631,9);
INSERT INTO MediaArtistRelation VALUES(632,9);
INSERT INTO MediaArtistRelation VALUES(633,9);
INSERT INTO MediaArtistRelation VALUES(634,9);
INSERT INTO MediaArtistRelation VALUES(635,9);
INSERT INTO MediaArtistRelation VALUES(636,9);
INSERT INTO MediaArtistRelation VALUES(637,9);
INSERT INTO MediaArtistRelation VALUES(638,9);
INSERT INTO MediaArtistRelation VALUES(639,9);
INSERT INTO MediaArtistRelation VALUES(640,9);
INSERT INTO MediaArtistRelation VALUES(641,9);
INSERT INTO MediaArtistRelation VALUES(642,9);
INSERT INTO MediaArtistRelation VALUES(643,9);
INSERT INTO MediaArtistRelation VALUES(644,9);
INSERT INTO MediaArtistRelation VALUES(645,9);
INSERT INTO MediaArtistRelation VALUES(646,9);
INSERT INTO MediaArtistRelation VALUES(647,9);
INSERT INTO MediaArtistRelation VALUES(648,9);
INSERT INTO MediaArtistRelation VALUES(649,9);
INSERT INTO MediaArtistRelation VALUES(650,9);
INSERT INTO MediaArtistRelation VALUES(651,9);
INSERT INTO MediaArtistRelation VALUES(652,9);
INSERT INTO MediaArtistRelation VALUES(653,9);
INSERT INTO MediaArtistRelation VALUES(654,9);
INSERT INTO MediaArtistRelation VALUES(655,9);
INSERT INTO MediaArtistRelation VALUES(656,9);
INSERT INTO MediaArtistRelation VALUES(657,9);
INSERT INTO MediaArtistRelation VALUES(658,9);
INSERT INTO MediaArtistRelation VALUES(659,9);
INSERT INTO MediaArtistRelation VALUES(660,9);
INSERT INTO MediaArtistRelation VALUES(661,9);
INSERT INTO MediaArtistRelation VALUES(662,9);
INSERT INTO MediaArtistRelation VALUES(663,9);
INSERT INTO MediaArtistRelation VALUES(664,9);
INSERT INTO MediaArtistRelation VALUES(665,9);
INSERT INTO MediaArtistRelation VALUES(666,9);
INSERT INTO MediaArtistRelation VALUES(667,9);
INSERT INTO MediaArtistRelation VALUES(668,9);
INSERT INTO MediaArtistRelation VALUES(669,9);
INSERT INTO MediaArtistRelation VALUES(670,9);
INSERT INTO MediaArtistRelation VALUES(671,9);
INSERT INTO MediaArtistRelation VALUES(672,9);
INSERT INTO MediaArtistRelation VALUES(673,9);
INSERT INTO MediaArtistRelation VALUES(674,9);
INSERT INTO MediaArtistRelation VALUES(675,9);
INSERT INTO MediaArtistRelation VALUES(676,9);
INSERT INTO MediaArtistRelation VALUES(677,9);
INSERT INTO MediaArtistRelation VALUES(678,9);
INSERT INTO MediaArtistRelation VALUES(679,9);
INSERT INTO MediaArtistRelation VALUES(680,9);
INSERT INTO MediaArtistRelation VALUES(681,9);
INSERT INTO MediaArtistRelation VALUES(682,9);
INSERT INTO MediaArtistRelation VALUES(683,9);
INSERT INTO MediaArtistRelation VALUES(684,9);
INSERT INTO MediaArtistRelation VALUES(685,9);
INSERT INTO MediaArtistRelation VALUES(686,9);
INSERT INTO MediaArtistRelation VALUES(687,9);
INSERT INTO MediaArtistRelation VALUES(688,9);
INSERT INTO MediaArtistRelation VALUES(689,9);
INSERT INTO MediaArtistRelation VALUES(690,9);
INSERT INTO MediaArtistRelation VALUES(691,9);
INSERT INTO MediaArtistRelation VALUES(692,9);
INSERT INTO MediaArtistRelation VALUES(693,9);
INSERT INTO MediaArtistRelation VALUES(694,9);
INSERT INTO MediaArtistRelation VALUES(695,9);
INSERT INTO MediaArtistRelation VALUES(696,9);
INSERT INTO MediaArtistRelation VALUES(697,9);
INSERT INTO MediaArtistRelation VALUES(698,9);
INSERT INTO MediaArtistRelation VALUES(699,9);
INSERT INTO MediaArtistRelation VALUES(700,9);
INSERT INTO MediaArtistRelation VALUES(701,10);
INSERT INTO MediaArtistRelation VALUES(702,10);
INSERT INTO MediaArtistRelation VALUES(703,10);
INSERT INTO MediaArtistRelation VALUES(704,10);
INSERT INTO MediaArtistRelation VALUES(705,10);
INSERT INTO MediaArtistRelation VALUES(706,10);
INSERT INTO MediaArtistRelation VALUES(707,10);
INSERT INTO MediaArtistRelation VALUES(708,10);
INSERT INTO MediaArtistRelation VALUES(709,10);
INSERT INTO MediaArtistRelation VALUES(710,10);
INSERT INTO MediaArtistRelation VALUES(711,10);
INSERT INTO MediaArtistRelation VALUES(712,10);
INSERT INTO MediaArtistRelation VALUES(713,10);
INSERT INTO MediaArtistRelation VALUES(714,10);
INSERT INTO MediaArtistRelation VALUES(715,10);
INSERT INTO MediaArtistRelation VALUES(716,10);
INSERT INTO MediaArtistRelation VALUES(717,10);
INSERT INTO MediaArtistRelation VALUES(718,10);
INSERT INTO MediaArtistRelation VALUES(719,10);
INSERT INTO MediaArtistRelation VALUES(720,10);
INSERT INTO MediaArtistRelation VALUES(721,10);
INSERT INTO MediaArtistRelation VALUES(722,10);
INSERT INTO MediaArtistRelation VALUES(723,10);
INSERT INTO MediaArtistRelation VALUES(724,10);
INSERT INTO MediaArtistRelation VALUES(725,10);
INSERT INTO MediaArtistRelation VALUES(726,10);
INSERT INTO MediaArtistRelation VALUES(727,10);
INSERT INTO MediaArtistRelation VALUES(728,10);
INSERT INTO MediaArtistRelation VALUES(729,10);
INSERT INTO MediaArtistRelation VALUES(730,10);
INSERT INTO MediaArtistRelation VALUES(731,10);
INSERT INTO MediaArtistRelation VALUES(732,10);
INSERT INTO MediaArtistRelation VALUES(733,10);
INSERT INTO MediaArtistRelation VALUES(734,10);
INSERT INTO MediaArtistRelation VALUES(735,10);
INSERT INTO MediaArtistRelation VALUES(736,10);
INSERT INTO MediaArtistRelation VALUES(737,10);
INSERT INTO MediaArtistRelation VALUES(738,10);
INSERT INTO MediaArtistRelation VALUES(739,10);
INSERT INTO MediaArtistRelation VALUES(740,10);
INSERT INTO MediaArtistRelation VALUES(741,10);
INSERT INTO MediaArtistRelation VALUES(742,10);
INSERT INTO MediaArtistRelation VALUES(743,10);
INSERT INTO MediaArtistRelation VALUES(744,10);
INSERT INTO MediaArtistRelation VALUES(745,10);
INSERT INTO MediaArtistRelation VALUES(746,10);
INSERT INTO MediaArtistRelation VALUES(747,10);
INSERT INTO MediaArtistRelation VALUES(748,10);
INSERT INTO MediaArtistRelation VALUES(749,10);
INSERT INTO MediaArtistRelation VALUES(750,10);
INSERT INTO MediaArtistRelation VALUES(751,10);
INSERT INTO MediaArtistRelation VALUES(752,10);
INSERT INTO MediaArtistRelation VALUES(753,10);
INSERT INTO MediaArtistRelation VALUES(754,10);
INSERT INTO MediaArtistRelation VALUES(755,10);
INSERT INTO MediaArtistRelation VALUES(756,10);
INSERT INTO MediaArtistRelation VALUES(757,10);
INSERT INTO MediaArtistRelation VALUES(758,10);
INSERT INTO MediaArtistRelation VALUES(759,10);
INSERT INTO MediaArtistRelation VALUES(760,10);
INSERT INTO MediaArtistRelation VALUES(761,10);
INSERT INTO MediaArtistRelation VALUES(762,10);
INSERT INTO MediaArtistRelation VALUES(763,10);
INSERT INTO MediaArtistRelation VALUES(764,10);
INSERT INTO MediaArtistRelation VALUES(765,10);
INSERT INTO MediaArtistRelation VALUES(766,10);
INSERT INTO MediaArtistRelation VALUES(767,10);
INSERT INTO MediaArtistRelation VALUES(768,10);
INSERT INTO MediaArtistRelation VALUES(769,10);
INSERT INTO MediaArtistRelation VALUES(770,10);
INSERT INTO MediaArtistRelation VALUES(771,10);
INSERT INTO MediaArtistRelation VALUES(772,10);
INSERT INTO MediaArtistRelation VALUES(773,10);
INSERT INTO MediaArtistRelation VALUES(774,10);
INSERT INTO MediaArtistRelation VALUES(775,10);
INSERT INTO MediaArtistRelation VALUES(776,10);
INSERT INTO MediaArtistRelation VALUES(777,10);
INSERT INTO MediaArtistRelation VALUES(778,10);
INSERT INTO MediaArtistRelation VALUES(779,10);
INSERT INTO MediaArtistRelation VALUES(780,10);
INSERT INTO MediaArtistRelation VALUES(781,10);
INSERT INTO MediaArtistRelation VALUES(782,10);
INSERT INTO MediaArtistRelation VALUES(783,10);
INSERT INTO MediaArtistRelation VALUES(784,10);
INSERT INTO MediaArtistRelation VALUES(785,10);
INSERT INTO MediaArtistRelation VALUES(786,10);
INSERT INTO MediaArtistRelation VALUES(787,10);
INSERT INTO MediaArtistRelation VALUES(788,10);
INSERT INTO MediaArtistRelation VALUES(789,10);
INSERT INTO MediaArtistRelation VALUES(790,10);
INSERT INTO MediaArtistRelation VALUES(791,10);
INSERT INTO MediaArtistRelation VALUES(792,10);
INSERT INTO MediaArtistRelation VALUES(793,10);
INSERT INTO MediaArtistRelation VALUES(794,10);
INSERT INTO MediaArtistRelation VALUES(795,10);
INSERT INTO MediaArtistRelation VALUES(796,10);
INSERT INTO MediaArtistRelation VALUES(797,10);
INSERT INTO MediaArtistRelation VALUES(798,10);
INSERT INTO MediaArtistRelation VALUES(799,10);
INSERT INTO MediaArtistRelation VALUES(800,10);
INSERT INTO MediaArtistRelation VALUES(801,11);
INSERT INTO MediaArtistRelation VALUES(802,11);
INSERT INTO MediaArtistRelation VALUES(803,11);
INSERT INTO MediaArtistRelation VALUES(804,11);
INSERT INTO MediaArtistRelation VALUES(805,11);
INSERT INTO MediaArtistRelation VALUES(806,11);
INSERT INTO MediaArtistRelation VALUES(807,11);
INSERT INTO MediaArtistRelation VALUES(808,11);
INSERT INTO MediaArtistRelation VALUES(809,11);
INSERT INTO MediaArtistRelation VALUES(810,11);
INSERT INTO MediaArtistRelation VALUES(811,11);
INSERT INTO MediaArtistRelation VALUES(812,11);
INSERT INTO MediaArtistRelation VALUES(813,11);
INSERT INTO MediaArtistRelation VALUES(814,11);
INSERT INTO MediaArtistRelation VALUES(815,11);
INSERT INTO MediaArtistRelation VALUES(816,11);
INSERT INTO MediaArtistRelation VALUES(817,11);
INSERT INTO MediaArtistRelation VALUES(818,11);
INSERT INTO MediaArtistRelation VALUES(819,11);
INSERT INTO MediaArtistRelation VALUES(820,11);
INSERT INTO MediaArtistRelation VALUES(821,11);
INSERT INTO MediaArtistRelation VALUES(822,11);
INSERT INTO MediaArtistRelation VALUES(823,11);
INSERT INTO MediaArtistRelation VALUES(824,11);
INSERT INTO MediaArtistRelation VALUES(825,11);
INSERT INTO MediaArtistRelation VALUES(826,11);
INSERT INTO MediaArtistRelation VALUES(827,11);
INSERT INTO MediaArtistRelation VALUES(828,11);
INSERT INTO MediaArtistRelation VALUES(829,11);
INSERT INTO MediaArtistRelation VALUES(830,11);
INSERT INTO MediaArtistRelation VALUES(831,11);
INSERT INTO MediaArtistRelation VALUES(832,11);
INSERT INTO MediaArtistRelation VALUES(833,11);
INSERT INTO MediaArtistRelation VALUES(834,11);
INSERT INTO MediaArtistRelation VALUES(835,11);
INSERT INTO MediaArtistRelation VALUES(836,11);
INSERT INTO MediaArtistRelation VALUES(837,11);
INSERT INTO MediaArtistRelation VALUES(838,11);
INSERT INTO MediaArtistRelation VALUES(839,11);
INSERT INTO MediaArtistRelation VALUES(840,11);
INSERT INTO MediaArtistRelation VALUES(841,11);
INSERT INTO MediaArtistRelation VALUES(842,11);
INSERT INTO MediaArtistRelation VALUES(843,11);
INSERT INTO MediaArtistRelation VALUES(844,11);
INSERT INTO MediaArtistRelation VALUES(845,11);
INSERT INTO MediaArtistRelation VALUES(846,11);
INSERT INTO MediaArtistRelation VALUES(847,11);
INSERT INTO MediaArtistRelation VALUES(848,11);
INSERT INTO MediaArtistRelation VALUES(849,11);
INSERT INTO MediaArtistRelation VALUES(850,11);
INSERT INTO MediaArtistRelation VALUES(851,11);
INSERT INTO MediaArtistRelation VALUES(852,11);
INSERT INTO MediaArtistRelation VALUES(853,11);
INSERT INTO MediaArtistRelation VALUES(854,11);
INSERT INTO MediaArtistRelation VALUES(855,11);
INSERT INTO MediaArtistRelation VALUES(856,11);
INSERT INTO MediaArtistRelation VALUES(857,11);
INSERT INTO MediaArtistRelation VALUES(858,11);
INSERT INTO MediaArtistRelation VALUES(859,11);
INSERT INTO MediaArtistRelation VALUES(860,11);
INSERT INTO MediaArtistRelation VALUES(861,11);
INSERT INTO MediaArtistRelation VALUES(862,11);
INSERT INTO MediaArtistRelation VALUES(863,11);
INSERT INTO MediaArtistRelation VALUES(864,11);
INSERT INTO MediaArtistRelation VALUES(865,11);
INSERT INTO MediaArtistRelation VALUES(866,11);
INSERT INTO MediaArtistRelation VALUES(867,11);
INSERT INTO MediaArtistRelation VALUES(868,11);
INSERT INTO MediaArtistRelation VALUES(869,11);
INSERT INTO MediaArtistRelation VALUES(870,11);
INSERT INTO MediaArtistRelation VALUES(871,11);
INSERT INTO MediaArtistRelation VALUES(872,11);
INSERT INTO MediaArtistRelation VALUES(873,11);
INSERT INTO MediaArtistRelation VALUES(874,11);
INSERT INTO MediaArtistRelation VALUES(875,11);
INSERT INTO MediaArtistRelation VALUES(876,11);
INSERT INTO MediaArtistRelation VALUES(877,11);
INSERT INTO MediaArtistRelation VALUES(878,11);
INSERT INTO MediaArtistRelation VALUES(879,11);
INSERT INTO MediaArtistRelation VALUES(880,11);
INSERT INTO MediaArtistRelation VALUES(881,11);
INSERT INTO MediaArtistRelation VALUES(882,11);
INSERT INTO MediaArtistRelation VALUES(883,11);
INSERT INTO MediaArtistRelation VALUES(884,11);
INSERT INTO MediaArtistRelation VALUES(885,11);
INSERT INTO MediaArtistRelation VALUES(886,11);
INSERT INTO MediaArtistRelation VALUES(887,11);
INSERT INTO MediaArtistRelation VALUES(888,11);
INSERT INTO MediaArtistRelation VALUES(889,11);
INSERT INTO MediaArtistRelation VALUES(890,11);
INSERT INTO MediaArtistRelation VALUES(891,11);
INSERT INTO MediaArtistRelation VALUES(892,11);
INSERT INTO MediaArtistRelation VALUES(893,11);
INSERT INTO MediaArtistRelation VALUES(894,11);
INSERT INTO MediaArtistRelation VALUES(895,11);
INSERT INTO MediaArtistRelation VALUES(896,11);
INSERT INTO MediaArtistRelation VALUES(897,11);
INSERT INTO MediaArtistRelation VALUES(898,11);
INSERT INTO MediaArtistRelation VALUES(899,11);
INSERT INTO MediaArtistRelation VALUES(900,11);
INSERT INTO MediaArtistRelation VALUES(901,12);
INSERT INTO MediaArtistRelation VALUES(902,12);
INSERT INTO MediaArtistRelation VALUES(903,12);
INSERT INTO MediaArtistRelation VALUES(904,12);
INSERT INTO MediaArtistRelation VALUES(905,12);
INSERT INTO MediaArtistRelation VALUES(906,12);
INSERT INTO MediaArtistRelation VALUES(907,12);
INSERT INTO MediaArtistRelation VALUES(908,12);
INSERT INTO MediaArtistRelation VALUES(909,12);
INSERT INTO MediaArtistRelation VALUES(910,12);
INSERT INTO MediaArtistRelation VALUES(911,12);
INSERT INTO MediaArtistRelation VALUES(912,12);
INSERT INTO MediaArtistRelation VALUES(913,12);
INSERT INTO MediaArtistRelation VALUES(914,12);
INSERT INTO MediaArtistRelation VALUES(915,12);
INSERT INTO MediaArtistRelation VALUES(916,12);
INSERT INTO MediaArtistRelation VALUES(917,12);
INSERT INTO MediaArtistRelation VALUES(918,12);
INSERT INTO MediaArtistRelation VALUES(919,12);
INSERT INTO MediaArtistRelation VALUES(920,12);
INSERT INTO MediaArtistRelation VALUES(921,12);
INSERT INTO MediaArtistRelation VALUES(922,12);
INSERT INTO MediaArtistRelation VALUES(923,12);
INSERT INTO MediaArtistRelation VALUES(924,12);
INSERT INTO MediaArtistRelation VALUES(925,12);
INSERT INTO MediaArtistRelation VALUES(926,12);
INSERT INTO MediaArtistRelation VALUES(927,12);
INSERT INTO MediaArtistRelation VALUES(928,12);
INSERT INTO MediaArtistRelation VALUES(929,12);
INSERT INTO MediaArtistRelation VALUES(930,12);
INSERT INTO MediaArtistRelation VALUES(931,12);
INSERT INTO MediaArtistRelation VALUES(932,12);
INSERT INTO MediaArtistRelation VALUES(933,12);
INSERT INTO MediaArtistRelation VALUES(934,12);
INSERT INTO MediaArtistRelation VALUES(935,12);
INSERT INTO MediaArtistRelation VALUES(936,12);
INSERT INTO MediaArtistRelation VALUES(937,12);
INSERT INTO MediaArtistRelation VALUES(938,12);
INSERT INTO MediaArtistRelation VALUES(939,12);
INSERT INTO MediaArtistRelation VALUES(940,12);
INSERT INTO MediaArtistRelation VALUES(941,12);
INSERT INTO MediaArtistRelation VALUES(942,12);
INSERT INTO MediaArtistRelation VALUES(943,12);
INSERT INTO MediaArtistRelation VALUES(944,12);
INSERT INTO MediaArtistRelation VALUES(945,12);
INSERT INTO MediaArtistRelation VALUES(946,12);
INSERT INTO MediaArtistRelation VALUES(947,12);
INSERT INTO MediaArtistRelation VALUES(948,12);
INSERT INTO MediaArtistRelation VALUES(949,12);
INSERT INTO MediaArtistRelation VALUES(950,12);
INSERT INTO MediaArtistRelation VALUES(951,12);
INSERT INTO MediaArtistRelation VALUES(952,12);
INSERT INTO MediaArtistRelation VALUES(953,12);
INSERT INTO MediaArtistRelation VALUES(954,12);
INSERT INTO MediaArtistRelation VALUES(955,12);
INSERT INTO MediaArtistRelation VALUES(956,12);
INSERT INTO MediaArtistRelation VALUES(957,12);
INSERT INTO MediaArtistRelation VALUES(958,12);
INSERT INTO MediaArtistRelation VALUES(959,12);
INSERT INTO MediaArtistRelation VALUES(960,12);
INSERT INTO MediaArtistRelation VALUES(961,12);
INSERT INTO MediaArtistRelation VALUES(962,12);
INSERT INTO MediaArtistRelation VALUES(963,12);
INSERT INTO MediaArtistRelation VALUES(964,12);
INSERT INTO MediaArtistRelation VALUES(965,12);
INSERT INTO MediaArtistRelation VALUES(966,12);
INSERT INTO MediaArtistRelation VALUES(967,12);
INSERT INTO MediaArtistRelation VALUES(968,12);
INSERT INTO MediaArtistRelation VALUES(969,12);
INSERT INTO MediaArtistRelation VALUES(970,12);
INSERT INTO MediaArtistRelation VALUES(971,12);
INSERT INTO MediaArtistRelation VALUES(972,12);
INSERT INTO MediaArtistRelation VALUES(973,12);
INSERT INTO MediaArtistRelation VALUES(974,12);
INSERT INTO MediaArtistRelation VALUES(975,12);
INSERT INTO MediaArtistRelation VALUES(976,12);
INSERT INTO MediaArtistRelation VALUES(977,12);
INSERT INTO MediaArtistRelation VALUES(978,12);
INSERT INTO MediaArtistRelation VALUES(979,12);
INSERT INTO MediaArtistRelation VALUES(980,12);
INSERT INTO MediaArtistRelation VALUES(981,12);
INSERT INTO MediaArtistRelation VALUES(982,12);
INSERT INTO MediaArtistRelation VALUES(983,12);
INSERT INTO MediaArtistRelation VALUES(984,12);
INSERT INTO MediaArtistRelation VALUES(985,12);
INSERT INTO MediaArtistRelation VALUES(986,12);
INSERT INTO MediaArtistRelation VALUES(987,12);
INSERT INTO MediaArtistRelation VALUES(988,12);
INSERT INTO MediaArtistRelation VALUES(989,12);
INSERT INTO MediaArtistRelation VALUES(990,12);
INSERT INTO MediaArtistRelation VALUES(991,12);
INSERT INTO MediaArtistRelation VALUES(992,12);
INSERT INTO MediaArtistRelation VALUES(993,12);
INSERT INTO MediaArtistRelation VALUES(994,12);
INSERT INTO MediaArtistRelation VALUES(995,12);
INSERT INTO MediaArtistRelation VALUES(996,12);
INSERT INTO MediaArtistRelation VALUES(997,12);
INSERT INTO MediaArtistRelation VALUES(998,12);
INSERT INTO MediaArtistRelation VALUES(999,12);
INSERT INTO MediaArtistRelation VALUES(1000,12);
INSERT INTO Task VALUES(1,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_1.mp3',1,1,3,0,0,0,'');
INSERT INTO Task VALUES(2,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_2.mp3',1,2,3,0,0,0,'');
INSERT INTO Task VALUES(3,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_3.mp3',1,3,3,0,0,0,'');
INSERT INTO Task VALUES(4,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_4.mp3',1,4,3,0,0,0,'');
INSERT INTO Task VALUES(5,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_5.mp3',1,5,3,0,0,0,'');
INSERT INTO Task VALUES(6,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_6.mp3',1,6,3,0,0,0,'');
INSERT INTO Task VALUES(7,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_7.mp3',1,7,3,0,0,0,'');
INSERT INTO Task VALUES(8,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_8.mp3',1,8,3,0,0,0,'');
INSERT INTO Task VALUES(9,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_9.mp3',1,9,3,0,0,0,'');
INSERT INTO Task VALUES(10,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_10/track_10.mp3',1,10,3,0,0,0,'');
INSERT INTO Task VALUES(11,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_1.mp3',1,11,4,0,0,0,'');
INSERT INTO Task VALUES(12,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_2.mp3',1,12,4,0,0,0,'');
INSERT INTO Task VALUES(13,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_3.mp3',1,13,4,0,0,0,'');
INSERT INTO Task VALUES(14,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_4.mp3',1,14,4,0,0,0,'');
INSERT INTO Task VALUES(15,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_5.mp3',1,15,4,0,0,0,'');
INSERT INTO Task VALUES(16,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_6.mp3',1,16,4,0,0,0,'');
INSERT INTO Task VALUES(17,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_7.mp3',1,17,4,0,0,0,'');
INSERT INTO Task VALUES(18,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_8.mp3',1,18,4,0,0,0,'');
INSERT INTO Task VALUES(19,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_9.mp3',1,19,4,0,0,0,'');
INSERT INTO Task VALUES(20,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_9/track_10.mp3',1,20,4,0,0,0,'');
INSERT INTO Task VALUES(21,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_1.mp3',1,21,5,0,0,0,'');
INSERT INTO Task VALUES(22,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_2.mp3',1,22,5,0,0,0,'');
INSERT INTO Task VALUES(23,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_3.mp3',1,23,5,0,0,0,'');
INSERT INTO Task VALUES(24,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_4.mp3',1,24,5,0,0,0,'');
INSERT INTO Task VALUES(25,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_5.mp3',1,25,5,0,0,0,'');
INSERT INTO Task VALUES(26,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_6.mp3',1,26,5,0,0,0,'');
INSERT INTO Task VALUES(27,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_7.mp3',1,27,5,0,0,0,'');
INSERT INTO Task VALUES(28,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_8.mp3',1,28,5,0,0,0,'');
INSERT INTO Task VALUES(29,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_9.mp3',1,29,5,0,0,0,'');
INSERT INTO Task VALUES(30,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_8/track_10.mp3',1,30,5,0,0,0,'');
INSERT INTO Task VALUES(31,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_1.mp3',1,31,6,0,0,0,'');
INSERT INTO Task VALUES(32,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_2.mp3',1,32,6,0,0,0,'');
INSERT INTO Task VALUES(33,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_3.mp3',1,33,6,0,0,0,'');
INSERT INTO Task VALUES(34,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_4.mp3',1,34,6,0,0,0,'');
INSERT INTO Task VALUES(35,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_5.mp3',1,35,6,0,0,0,'');
INSERT INTO Task VALUES(36,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_6.mp3',1,36,6,0,0,0,'');
INSERT INTO Task VALUES(37,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_7.mp3',1,37,6,0,0,0,'');
INSERT INTO Task VALUES(38,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_8.mp3',1,38,6,0,0,0,'');
INSERT INTO Task VALUES(39,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_9.mp3',1,39,6,0,0,0,'');
INSERT INTO Task VALUES(40,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_7/track_10.mp3',1,40,6,0,0,0,'');
INSERT INTO Task VALUES(41,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_1.mp3',1,41,7,0,0,0,'');
INSERT INTO Task VALUES(42,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_2.mp3',1,42,7,0,0,0,'');
INSERT INTO Task VALUES(43,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_3.mp3',1,43,7,0,0,0,'');
INSERT INTO Task VALUES(44,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_4.mp3',1,44,7,0,0,0,'');
INSERT INTO Task VALUES(45,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_5.mp3',1,45,7,0,0,0,'');
INSERT INTO Task VALUES(46,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_6.mp3',1,46,7,0,0,0,'');
INSERT INTO Task VALUES(47,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_7.mp3',1,47,7,0,0,0,'');
INSERT INTO Task VALUES(48,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_8.mp3',1,48,7,0,0,0,'');
INSERT INTO Task VALUES(49,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_9.mp3',1,49,7,0,0,0,'');
INSERT INTO Task VALUES(50,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_6/track_10.mp3',1,50,7,0,0,0,'');
INSERT INTO Task VALUES(51,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_1.mp3',1,51,8,0,0,0,'');
INSERT INTO Task VALUES(52,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_2.mp3',1,52,8,0,0,0,'');
INSERT INTO Task VALUES(53,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_3.mp3',1,53,8,0,0,0,'');
INSERT INTO Task VALUES(54,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_4.mp3',1,54,8,0,0,0,'');
INSERT INTO Task VALUES(55,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_5.mp3',1,55,8,0,0,0,'');
INSERT INTO Task VALUES(56,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_6.mp3',1,56,8,0,0,0,'');
INSERT INTO Task VALUES(57,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_7.mp3',1,57,8,0,0,0,'');
INSERT INTO Task VALUES(58,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_8.mp3',1,58,8,0,0,0,'');
INSERT INTO Task VALUES(59,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_9.mp3',1,59,8,0,0,0,'');
INSERT INTO Task VALUES(60,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_5/track_10.mp3',1,60,8,0,0,0,'');
INSERT INTO Task VALUES(61,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_1.mp3',1,61,9,0,0,0,'');
INSERT INTO Task VALUES(62,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_2.mp3',1,62,9,0,0,0,'');
INSERT INTO Task VALUES(63,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_3.mp3',1,63,9,0,0,0,'');
INSERT INTO Task VALUES(64,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_4.mp3',1,64,9,0,0,0,'');
INSERT INTO Task VALUES(65,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_5.mp3',1,65,9,0,0,0,'');
INSERT INTO Task VALUES(66,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_6.mp3',1,66,9,0,0,0,'');
INSERT INTO Task VALUES(67,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_7.mp3',1,67,9,0,0,0,'');
INSERT INTO Task VALUES(68,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_8.mp3',1,68,9,0,0,0,'');
INSERT INTO Task VALUES(69,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_9.mp3',1,69,9,0,0,0,'');
INSERT INTO Task VALUES(70,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_4/track_10.mp3',1,70,9,0,0,0,'');
INSERT INTO Task VALUES(71,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_1.mp3',1,71,10,0,0,0,'');
INSERT INTO Task VALUES(72,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_2.mp3',1,72,10,0,0,0,'');
INSERT INTO Task VALUES(73,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_3.mp3',1,73,10,0,0,0,'');
INSERT INTO Task VALUES(74,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_4.mp3',1,74,10,0,0,0,'');
INSERT INTO Task VALUES(75,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_5.mp3',1,75,10,0,0,0,'');
INSERT INTO Task VALUES(76,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_6.mp3',1,76,10,0,0,0,'');
INSERT INTO Task VALUES(77,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_7.mp3',1,77,10,0,0,0,'');
INSERT INTO Task VALUES(78,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_8.mp3',1,78,10,0,0,0,'');
INSERT INTO Task VALUES(79,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_9.mp3',1,79,10,0,0,0,'');
INSERT INTO Task VALUES(80,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_3/track_10.mp3',1,80,10,0,0,0,'');
INSERT INTO Task VALUES(81,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_1.mp3',1,81,11,0,0,0,'');
INSERT INTO Task VALUES(82,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_2.mp3',1,82,11,0,0,0,'');
INSERT INTO Task VALUES(83,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_3.mp3',1,83,11,0,0,0,'');
INSERT INTO Task VALUES(84,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_4.mp3',1,84,11,0,0,0,'');
INSERT INTO Task VALUES(85,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_5.mp3',1,85,11,0,0,0,'');
INSERT INTO Task VALUES(86,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_6.mp3',1,86,11,0,0,0,'');
INSERT INTO Task VALUES(87,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_7.mp3',1,87,11,0,0,0,'');
INSERT INTO Task VALUES(88,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_8.mp3',1,88,11,0,0,0,'');
INSERT INTO Task VALUES(89,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_9.mp3',1,89,11,0,0,0,'');
INSERT INTO Task VALUES(90,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_2/track_10.mp3',1,90,11,0,0,0,'');
INSERT INTO Task VALUES(91,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_1.mp3',1,91,12,0,0,0,'');
INSERT INTO Task VALUES(92,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_2.mp3',1,92,12,0,0,0,'');
INSERT INTO Task VALUES(93,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_3.mp3',1,93,12,0,0,0,'');
INSERT INTO Task VALUES(94,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_4.mp3',1,94,12,0,0,0,'');
INSERT INTO Task VALUES(95,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_5.mp3',1,95,12,0,0,0,'');
INSERT INTO Task VALUES(96,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_6.mp3',1,96,12,0,0,0,'');
INSERT INTO Task VALUES(97,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_7.mp3',1,97,12,0,0,0,'');
INSERT INTO Task VALUES(98,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_8.mp3',1,98,12,0,0,0,'');
INSERT INTO Task VALUES(99,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_9.mp3',1,99,12,0,0,0,'');
INSERT INTO Task VALUES(100,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_10/album_1/track_10.mp3',1,100,12,0,0,0,'');
INSERT INTO Task VALUES(101,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_1.mp3',1,101,14,0,0,0,'');
INSERT INTO Task VALUES(102,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_2.mp3',1,102,14,0,0,0,'');
INSERT INTO Task VALUES(103,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_3.mp3',1,103,14,0,0,0,'');
INSERT INTO Task VALUES(104,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_4.mp3',1,104,14,0,0,0,'');
INSERT INTO Task VALUES(105,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_5.mp3',1,105,14,0,0,0,'');
INSERT INTO Task VALUES(106,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_6.mp3',1,106,14,0,0,0,'');
INSERT INTO Task VALUES(107,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_7.mp3',1,107,14,0,0,0,'');
INSERT INTO Task VALUES(108,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_8.mp3',1,108,14,0,0,0,'');
INSERT INTO Task VALUES(109,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_9.mp3',1,109,14,0,0,0,'');
INSERT INTO Task VALUES(110,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_10/track_10.mp3',1,110,14,0,0,0,'');
INSERT INTO Task VALUES(111,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_1.mp3',1,111,15,0,0,0,'');
INSERT INTO Task VALUES(112,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_2.mp3',1,112,15,0,0,0,'');
INSERT INTO Task VALUES(113,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_3.mp3',1,113,15,0,0,0,'');
INSERT INTO Task VALUES(114,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_4.mp3',1,114,15,0,0,0,'');
INSERT INTO Task VALUES(115,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_5.mp3',1,115,15,0,0,0,'');
INSERT INTO Task VALUES(116,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_6.mp3',1,116,15,0,0,0,'');
INSERT INTO Task VALUES(117,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_7.mp3',1,117,15,0,0,0,'');
INSERT INTO Task VALUES(118,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_8.mp3',1,118,15,0,0,0,'');
INSERT INTO Task VALUES(119,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_9.mp3',1,119,15,0,0,0,'');
INSERT INTO Task VALUES(120,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_9/track_10.mp3',1,120,15,0,0,0,'');
INSERT INTO Task VALUES(121,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_1.mp3',1,121,16,0,0,0,'');
INSERT INTO Task VALUES(122,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_2.mp3',1,122,16,0,0,0,'');
INSERT INTO Task VALUES(123,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_3.mp3',1,123,16,0,0,0,'');
INSERT INTO Task VALUES(124,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_4.mp3',1,124,16,0,0,0,'');
INSERT INTO Task VALUES(125,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_5.mp3',1,125,16,0,0,0,'');
INSERT INTO Task VALUES(126,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_6.mp3',1,126,16,0,0,0,'');
INSERT INTO Task VALUES(127,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_7.mp3',1,127,16,0,0,0,'');
INSERT INTO Task VALUES(128,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_8.mp3',1,128,16,0,0,0,'');
INSERT INTO Task VALUES(129,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_9.mp3',1,129,16,0,0,0,'');
INSERT INTO Task VALUES(130,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_8/track_10.mp3',1,130,16,0,0,0,'');
INSERT INTO Task VALUES(131,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_1.mp3',1,131,17,0,0,0,'');
INSERT INTO Task VALUES(132,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_2.mp3',1,132,17,0,0,0,'');
INSERT INTO Task VALUES(133,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_3.mp3',1,133,17,0,0,0,'');
INSERT INTO Task VALUES(134,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_4.mp3',1,134,17,0,0,0,'');
INSERT INTO Task VALUES(135,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_5.mp3',1,135,17,0,0,0,'');
INSERT INTO Task VALUES(136,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_6.mp3',1,136,17,0,0,0,'');
INSERT INTO Task VALUES(137,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_7.mp3',1,137,17,0,0,0,'');
INSERT INTO Task VALUES(138,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_8.mp3',1,138,17,0,0,0,'');
INSERT INTO Task VALUES(139,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_9.mp3',1,139,17,0,0,0,'');
INSERT INTO Task VALUES(140,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_7/track_10.mp3',1,140,17,0,0,0,'');
INSERT INTO Task VALUES(141,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_1.mp3',1,141,18,0,0,0,'');
INSERT INTO Task VALUES(142,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_2.mp3',1,142,18,0,0,0,'');
INSERT INTO Task VALUES(143,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_3.mp3',1,143,18,0,0,0,'');
INSERT INTO Task VALUES(144,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_4.mp3',1,144,18,0,0,0,'');
INSERT INTO Task VALUES(145,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_5.mp3',1,145,18,0,0,0,'');
INSERT INTO Task VALUES(146,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_6.mp3',1,146,18,0,0,0,'');
INSERT INTO Task VALUES(147,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_7.mp3',1,147,18,0,0,0,'');
INSERT INTO Task VALUES(148,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_8.mp3',1,148,18,0,0,0,'');
INSERT INTO Task VALUES(149,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_9.mp3',1,149,18,0,0,0,'');
INSERT INTO Task VALUES(150,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_6/track_10.mp3',1,150,18,0,0,0,'');
INSERT INTO Task VALUES(151,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_1.mp3',1,151,19,0,0,0,'');
INSERT INTO Task VALUES(152,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_2.mp3',1,152,19,0,0,0,'');
INSERT INTO Task VALUES(153,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_3.mp3',1,153,19,0,0,0,'');
INSERT INTO Task VALUES(154,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_4.mp3',1,154,19,0,0,0,'');
INSERT INTO Task VALUES(155,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_5.mp3',1,155,19,0,0,0,'');
INSERT INTO Task VALUES(156,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_6.mp3',1,156,19,0,0,0,'');
INSERT INTO Task VALUES(157,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_7.mp3',1,157,19,0,0,0,'');
INSERT INTO Task VALUES(158,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_8.mp3',1,158,19,0,0,0,'');
INSERT INTO Task VALUES(159,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_9.mp3',1,159,19,0,0,0,'');
INSERT INTO Task VALUES(160,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_5/track_10.mp3',1,160,19,0,0,0,'');
INSERT INTO Task VALUES(161,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_1.mp3',1,161,20,0,0,0,'');
INSERT INTO Task VALUES(162,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_2.mp3',1,162,20,0,0,0,'');
INSERT INTO Task VALUES(163,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_3.mp3',1,163,20,0,0,0,'');
INSERT INTO Task VALUES(164,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_4.mp3',1,164,20,0,0,0,'');
INSERT INTO Task VALUES(165,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_5.mp3',1,165,20,0,0,0,'');
INSERT INTO Task VALUES(166,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_6.mp3',1,166,20,0,0,0,'');
INSERT INTO Task VALUES(167,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_7.mp3',1,167,20,0,0,0,'');
INSERT INTO Task VALUES(168,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_8.mp3',1,168,20,0,0,0,'');
INSERT INTO Task VALUES(169,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_9.mp3',1,169,20,0,0,0,'');
INSERT INTO Task VALUES(170,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_4/track_10.mp3',1,170,20,0,0,0,'');
INSERT INTO Task VALUES(171,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_1.mp3',1,171,21,0,0,0,'');
INSERT INTO Task VALUES(172,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_2.mp3',1,172,21,0,0,0,'');
INSERT INTO Task VALUES(173,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_3.mp3',1,173,21,0,0,0,'');
INSERT INTO Task VALUES(174,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_4.mp3',1,174,21,0,0,0,'');
INSERT INTO Task VALUES(175,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_5.mp3',1,175,21,0,0,0,'');
INSERT INTO Task VALUES(176,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_6.mp3',1,176,21,0,0,0,'');
INSERT INTO Task VALUES(177,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_7.mp3',1,177,21,0,0,0,'');
INSERT INTO Task VALUES(178,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_8.mp3',1,178,21,0,0,0,'');
INSERT INTO Task VALUES(179,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_9.mp3',1,179,21,0,0,0,'');
INSERT INTO Task VALUES(180,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_3/track_10.mp3',1,180,21,0,0,0,'');
INSERT INTO Task VALUES(181,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_1.mp3',1,181,22,0,0,0,'');
INSERT INTO Task VALUES(182,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_2.mp3',1,182,22,0,0,0,'');
INSERT INTO Task VALUES(183,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_3.mp3',1,183,22,0,0,0,'');
INSERT INTO Task VALUES(184,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_4.mp3',1,184,22,0,0,0,'');
INSERT INTO Task VALUES(185,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_5.mp3',1,185,22,0,0,0,'');
INSERT INTO Task VALUES(186,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_6.mp3',1,186,22,0,0,0,'');
INSERT INTO Task VALUES(187,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_7.mp3',1,187,22,0,0,0,'');
INSERT INTO Task VALUES(188,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_8.mp3',1,188,22,0,0,0,'');
INSERT INTO Task VALUES(189,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_9.mp3',1,189,22,0,0,0,'');
INSERT INTO Task VALUES(190,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_2/track_10.mp3',1,190,22,0,0,0,'');
INSERT INTO Task VALUES(191,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_1.mp3',1,191,23,0,0,0,'');
INSERT INTO Task VALUES(192,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_2.mp3',1,192,23,0,0,0,'');
INSERT INTO Task VALUES(193,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_3.mp3',1,193,23,0,0,0,'');
INSERT INTO Task VALUES(194,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_4.mp3',1,194,23,0,0,0,'');
INSERT INTO Task VALUES(195,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_5.mp3',1,195,23,0,0,0,'');
INSERT INTO Task VALUES(196,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_6.mp3',1,196,23,0,0,0,'');
INSERT INTO Task VALUES(197,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_7.mp3',1,197,23,0,0,0,'');
INSERT INTO Task VALUES(198,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_8.mp3',1,198,23,0,0,0,'');
INSERT INTO Task VALUES(199,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_9.mp3',1,199,23,0,0,0,'');
INSERT INTO Task VALUES(200,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_9/album_1/track_10.mp3',1,200,23,0,0,0,'');
INSERT INTO Task VALUES(201,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_1.mp3',1,201,25,0,0,0,'');
INSERT INTO Task VALUES(202,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_2.mp3',1,202,25,0,0,0,'');
INSERT INTO Task VALUES(203,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_3.mp3',1,203,25,0,0,0,'');
INSERT INTO Task VALUES(204,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_4.mp3',1,204,25,0,0,0,'');
INSERT INTO Task VALUES(205,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_5.mp3',1,205,25,0,0,0,'');
INSERT INTO Task VALUES(206,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_6.mp3',1,206,25,0,0,0,'');
INSERT INTO Task VALUES(207,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_7.mp3',1,207,25,0,0,0,'');
INSERT INTO Task VALUES(208,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_8.mp3',1,208,25,0,0,0,'');
INSERT INTO Task VALUES(209,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_9.mp3',1,209,25,0,0,0,'');
INSERT INTO Task VALUES(210,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_10/track_10.mp3',1,210,25,0,0,0,'');
INSERT INTO Task VALUES(211,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_1.mp3',1,211,26,0,0,0,'');
INSERT INTO Task VALUES(212,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_2.mp3',1,212,26,0,0,0,'');
INSERT INTO Task VALUES(213,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_3.mp3',1,213,26,0,0,0,'');
INSERT INTO Task VALUES(214,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_4.mp3',1,214,26,0,0,0,'');
INSERT INTO Task VALUES(215,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_5.mp3',1,215,26,0,0,0,'');
INSERT INTO Task VALUES(216,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_6.mp3',1,216,26,0,0,0,'');
INSERT INTO Task VALUES(217,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_7.mp3',1,217,26,0,0,0,'');
INSERT INTO Task VALUES(218,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_8.mp3',1,218,26,0,0,0,'');
INSERT INTO Task VALUES(219,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_9.mp3',1,219,26,0,0,0,'');
INSERT INTO Task VALUES(220,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_9/track_10.mp3',1,220,26,0,0,0,'');
INSERT INTO Task VALUES(221,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_1.mp3',1,221,27,0,0,0,'');
INSERT INTO Task VALUES(222,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_2.mp3',1,222,27,0,0,0,'');
INSERT INTO Task VALUES(223,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_3.mp3',1,223,27,0,0,0,'');
INSERT INTO Task VALUES(224,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_4.mp3',1,224,27,0,0,0,'');
INSERT INTO Task VALUES(225,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_5.mp3',1,225,27,0,0,0,'');
INSERT INTO Task VALUES(226,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_6.mp3',1,226,27,0,0,0,'');
INSERT INTO Task VALUES(227,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_7.mp3',1,227,27,0,0,0,'');
INSERT INTO Task VALUES(228,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_8.mp3',1,228,27,0,0,0,'');
INSERT INTO Task VALUES(229,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_9.mp3',1,229,27,0,0,0,'');
INSERT INTO Task VALUES(230,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_8/track_10.mp3',1,230,27,0,0,0,'');
INSERT INTO Task VALUES(231,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_1.mp3',1,231,28,0,0,0,'');
INSERT INTO Task VALUES(232,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_2.mp3',1,232,28,0,0,0,'');
INSERT INTO Task VALUES(233,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_3.mp3',1,233,28,0,0,0,'');
INSERT INTO Task VALUES(234,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_4.mp3',1,234,28,0,0,0,'');
INSERT INTO Task VALUES(235,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_5.mp3',1,235,28,0,0,0,'');
INSERT INTO Task VALUES(236,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_6.mp3',1,236,28,0,0,0,'');
INSERT INTO Task VALUES(237,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_7.mp3',1,237,28,0,0,0,'');
INSERT INTO Task VALUES(238,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_8.mp3',1,238,28,0,0,0,'');
INSERT INTO Task VALUES(239,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_9.mp3',1,239,28,0,0,0,'');
INSERT INTO Task VALUES(240,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_7/track_10.mp3',1,240,28,0,0,0,'');
INSERT INTO Task VALUES(241,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_1.mp3',1,241,29,0,0,0,'');
INSERT INTO Task VALUES(242,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_2.mp3',1,242,29,0,0,0,'');
INSERT INTO Task VALUES(243,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_3.mp3',1,243,29,0,0,0,'');
INSERT INTO Task VALUES(244,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_4.mp3',1,244,29,0,0,0,'');
INSERT INTO Task VALUES(245,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_5.mp3',1,245,29,0,0,0,'');
INSERT INTO Task VALUES(246,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_6.mp3',1,246,29,0,0,0,'');
INSERT INTO Task VALUES(247,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_7.mp3',1,247,29,0,0,0,'');
INSERT INTO Task VALUES(248,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_8.mp3',1,248,29,0,0,0,'');
INSERT INTO Task VALUES(249,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_9.mp3',1,249,29,0,0,0,'');
INSERT INTO Task VALUES(250,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_6/track_10.mp3',1,250,29,0,0,0,'');
INSERT INTO Task VALUES(251,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_1.mp3',1,251,30,0,0,0,'');
INSERT INTO Task VALUES(252,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_2.mp3',1,252,30,0,0,0,'');
INSERT INTO Task VALUES(253,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_3.mp3',1,253,30,0,0,0,'');
INSERT INTO Task VALUES(254,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_4.mp3',1,254,30,0,0,0,'');
INSERT INTO Task VALUES(255,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_5.mp3',1,255,30,0,0,0,'');
INSERT INTO Task VALUES(256,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_6.mp3',1,256,30,0,0,0,'');
INSERT INTO Task VALUES(257,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_7.mp3',1,257,30,0,0,0,'');
INSERT INTO Task VALUES(258,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_8.mp3',1,258,30,0,0,0,'');
INSERT INTO Task VALUES(259,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_9.mp3',1,259,30,0,0,0,'');
INSERT INTO Task VALUES(260,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_5/track_10.mp3',1,260,30,0,0,0,'');
INSERT INTO Task VALUES(261,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_1.mp3',1,261,31,0,0,0,'');
INSERT INTO Task VALUES(262,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_2.mp3',1,262,31,0,0,0,'');
INSERT INTO Task VALUES(263,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_3.mp3',1,263,31,0,0,0,'');
INSERT INTO Task VALUES(264,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_4.mp3',1,264,31,0,0,0,'');
INSERT INTO Task VALUES(265,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_5.mp3',1,265,31,0,0,0,'');
INSERT INTO Task VALUES(266,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_6.mp3',1,266,31,0,0,0,'');
INSERT INTO Task VALUES(267,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_7.mp3',1,267,31,0,0,0,'');
INSERT INTO Task VALUES(268,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_8.mp3',1,268,31,0,0,0,'');
INSERT INTO Task VALUES(269,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_9.mp3',1,269,31,0,0,0,'');
INSERT INTO Task VALUES(270,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_4/track_10.mp3',1,270,31,0,0,0,'');
INSERT INTO Task VALUES(271,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_1.mp3',1,271,32,0,0,0,'');
INSERT INTO Task VALUES(272,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_2.mp3',1,272,32,0,0,0,'');
INSERT INTO Task VALUES(273,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_3.mp3',1,273,32,0,0,0,'');
INSERT INTO Task VALUES(274,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_4.mp3',1,274,32,0,0,0,'');
INSERT INTO Task VALUES(275,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_5.mp3',1,275,32,0,0,0,'');
INSERT INTO Task VALUES(276,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_6.mp3',1,276,32,0,0,0,'');
INSERT INTO Task VALUES(277,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_7.mp3',1,277,32,0,0,0,'');
INSERT INTO Task VALUES(278,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_8.mp3',1,278,32,0,0,0,'');
INSERT INTO Task VALUES(279,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_9.mp3',1,279,32,0,0,0,'');
INSERT INTO Task VALUES(280,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_3/track_10.mp3',1,280,32,0,0,0,'');
INSERT INTO Task VALUES(281,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_1.mp3',1,281,33,0,0,0,'');
INSERT INTO Task VALUES(282,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_2.mp3',1,282,33,0,0,0,'');
INSERT INTO Task VALUES(283,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_3.mp3',1,283,33,0,0,0,'');
INSERT INTO Task VALUES(284,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_4.mp3',1,284,33,0,0,0,'');
INSERT INTO Task VALUES(285,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_5.mp3',1,285,33,0,0,0,'');
INSERT INTO Task VALUES(286,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_6.mp3',1,286,33,0,0,0,'');
INSERT INTO Task VALUES(287,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_7.mp3',1,287,33,0,0,0,'');
INSERT INTO Task VALUES(288,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_8.mp3',1,288,33,0,0,0,'');
INSERT INTO Task VALUES(289,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_9.mp3',1,289,33,0,0,0,'');
INSERT INTO Task VALUES(290,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_2/track_10.mp3',1,290,33,0,0,0,'');
INSERT INTO Task VALUES(291,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_1.mp3',1,291,34,0,0,0,'');
INSERT INTO Task VALUES(292,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_2.mp3',1,292,34,0,0,0,'');
INSERT INTO Task VALUES(293,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_3.mp3',1,293,34,0,0,0,'');
INSERT INTO Task VALUES(294,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_4.mp3',1,294,34,0,0,0,'');
INSERT INTO Task VALUES(295,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_5.mp3',1,295,34,0,0,0,'');
INSERT INTO Task VALUES(296,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_6.mp3',1,296,34,0,0,0,'');
INSERT INTO Task VALUES(297,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_7.mp3',1,297,34,0,0,0,'');
INSERT INTO Task VALUES(298,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_8.mp3',1,298,34,0,0,0,'');
INSERT INTO Task VALUES(299,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_9.mp3',1,299,34,0,0,0,'');
INSERT INTO Task VALUES(300,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_8/album_1/track_10.mp3',1,300,34,0,0,0,'');
INSERT INTO Task VALUES(301,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_1.mp3',1,301,36,0,0,0,'');
INSERT INTO Task VALUES(302,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_2.mp3',1,302,36,0,0,0,'');
INSERT INTO Task VALUES(303,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_3.mp3',1,303,36,0,0,0,'');
INSERT INTO Task VALUES(304,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_4.mp3',1,304,36,0,0,0,'');
INSERT INTO Task VALUES(305,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_5.mp3',1,305,36,0,0,0,'');
INSERT INTO Task VALUES(306,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_6.mp3',1,306,36,0,0,0,'');
INSERT INTO Task VALUES(307,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_7.mp3',1,307,36,0,0,0,'');
INSERT INTO Task VALUES(308,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_8.mp3',1,308,36,0,0,0,'');
INSERT INTO Task VALUES(309,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_9.mp3',1,309,36,0,0,0,'');
INSERT INTO Task VALUES(310,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_10/track_10.mp3',1,310,36,0,0,0,'');
INSERT INTO Task VALUES(311,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_1.mp3',1,311,37,0,0,0,'');
INSERT INTO Task VALUES(312,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_2.mp3',1,312,37,0,0,0,'');
INSERT INTO Task VALUES(313,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_3.mp3',1,313,37,0,0,0,'');
INSERT INTO Task VALUES(314,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_4.mp3',1,314,37,0,0,0,'');
INSERT INTO Task VALUES(315,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_5.mp3',1,315,37,0,0,0,'');
INSERT INTO Task VALUES(316,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_6.mp3',1,316,37,0,0,0,'');
INSERT INTO Task VALUES(317,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_7.mp3',1,317,37,0,0,0,'');
INSERT INTO Task VALUES(318,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_8.mp3',1,318,37,0,0,0,'');
INSERT INTO Task VALUES(319,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_9.mp3',1,319,37,0,0,0,'');
INSERT INTO Task VALUES(320,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_9/track_10.mp3',1,320,37,0,0,0,'');
INSERT INTO Task VALUES(321,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_1.mp3',1,321,38,0,0,0,'');
INSERT INTO Task VALUES(322,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_2.mp3',1,322,38,0,0,0,'');
INSERT INTO Task VALUES(323,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_3.mp3',1,323,38,0,0,0,'');
INSERT INTO Task VALUES(324,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_4.mp3',1,324,38,0,0,0,'');
INSERT INTO Task VALUES(325,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_5.mp3',1,325,38,0,0,0,'');
INSERT INTO Task VALUES(326,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_6.mp3',1,326,38,0,0,0,'');
INSERT INTO Task VALUES(327,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_7.mp3',1,327,38,0,0,0,'');
INSERT INTO Task VALUES(328,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_8.mp3',1,328,38,0,0,0,'');
INSERT INTO Task VALUES(329,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_9.mp3',1,329,38,0,0,0,'');
INSERT INTO Task VALUES(330,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_8/track_10.mp3',1,330,38,0,0,0,'');
INSERT INTO Task VALUES(331,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_1.mp3',1,331,39,0,0,0,'');
INSERT INTO Task VALUES(332,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_2.mp3',1,332,39,0,0,0,'');
INSERT INTO Task VALUES(333,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_3.mp3',1,333,39,0,0,0,'');
INSERT INTO Task VALUES(334,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_4.mp3',1,334,39,0,0,0,'');
INSERT INTO Task VALUES(335,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_5.mp3',1,335,39,0,0,0,'');
INSERT INTO Task VALUES(336,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_6.mp3',1,336,39,0,0,0,'');
INSERT INTO Task VALUES(337,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_7.mp3',1,337,39,0,0,0,'');
INSERT INTO Task VALUES(338,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_8.mp3',1,338,39,0,0,0,'');
INSERT INTO Task VALUES(339,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_9.mp3',1,339,39,0,0,0,'');
INSERT INTO Task VALUES(340,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_7/track_10.mp3',1,340,39,0,0,0,'');
INSERT INTO Task VALUES(341,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_1.mp3',1,341,40,0,0,0,'');
INSERT INTO Task VALUES(342,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_2.mp3',1,342,40,0,0,0,'');
INSERT INTO Task VALUES(343,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_3.mp3',1,343,40,0,0,0,'');
INSERT INTO Task VALUES(344,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_4.mp3',1,344,40,0,0,0,'');
INSERT INTO Task VALUES(345,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_5.mp3',1,345,40,0,0,0,'');
INSERT INTO Task VALUES(346,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_6.mp3',1,346,40,0,0,0,'');
INSERT INTO Task VALUES(347,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_7.mp3',1,347,40,0,0,0,'');
INSERT INTO Task VALUES(348,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_8.mp3',1,348,40,0,0,0,'');
INSERT INTO Task VALUES(349,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_9.mp3',1,349,40,0,0,0,'');
INSERT INTO Task VALUES(350,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_6/track_10.mp3',1,350,40,0,0,0,'');
INSERT INTO Task VALUES(351,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_1.mp3',1,351,41,0,0,0,'');
INSERT INTO Task VALUES(352,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_2.mp3',1,352,41,0,0,0,'');
INSERT INTO Task VALUES(353,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_3.mp3',1,353,41,0,0,0,'');
INSERT INTO Task VALUES(354,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_4.mp3',1,354,41,0,0,0,'');
INSERT INTO Task VALUES(355,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_5.mp3',1,355,41,0,0,0,'');
INSERT INTO Task VALUES(356,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_6.mp3',1,356,41,0,0,0,'');
INSERT INTO Task VALUES(357,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_7.mp3',1,357,41,0,0,0,'');
INSERT INTO Task VALUES(358,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_8.mp3',1,358,41,0,0,0,'');
INSERT INTO Task VALUES(359,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_9.mp3',1,359,41,0,0,0,'');
INSERT INTO Task VALUES(360,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_5/track_10.mp3',1,360,41,0,0,0,'');
INSERT INTO Task VALUES(361,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_1.mp3',1,361,42,0,0,0,'');
INSERT INTO Task VALUES(362,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_2.mp3',1,362,42,0,0,0,'');
INSERT INTO Task VALUES(363,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_3.mp3',1,363,42,0,0,0,'');
INSERT INTO Task VALUES(364,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_4.mp3',1,364,42,0,0,0,'');
INSERT INTO Task VALUES(365,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_5.mp3',1,365,42,0,0,0,'');
INSERT INTO Task VALUES(366,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_6.mp3',1,366,42,0,0,0,'');
INSERT INTO Task VALUES(367,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_7.mp3',1,367,42,0,0,0,'');
INSERT INTO Task VALUES(368,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_8.mp3',1,368,42,0,0,0,'');
INSERT INTO Task VALUES(369,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_9.mp3',1,369,42,0,0,0,'');
INSERT INTO Task VALUES(370,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_4/track_10.mp3',1,370,42,0,0,0,'');
INSERT INTO Task VALUES(371,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_1.mp3',1,371,43,0,0,0,'');
INSERT INTO Task VALUES(372,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_2.mp3',1,372,43,0,0,0,'');
INSERT INTO Task VALUES(373,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_3.mp3',1,373,43,0,0,0,'');
INSERT INTO Task VALUES(374,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_4.mp3',1,374,43,0,0,0,'');
INSERT INTO Task VALUES(375,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_5.mp3',1,375,43,0,0,0,'');
INSERT INTO Task VALUES(376,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_6.mp3',1,376,43,0,0,0,'');
INSERT INTO Task VALUES(377,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_7.mp3',1,377,43,0,0,0,'');
INSERT INTO Task VALUES(378,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_8.mp3',1,378,43,0,0,0,'');
INSERT INTO Task VALUES(379,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_9.mp3',1,379,43,0,0,0,'');
INSERT INTO Task VALUES(380,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_3/track_10.mp3',1,380,43,0,0,0,'');
INSERT INTO Task VALUES(381,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_1.mp3',1,381,44,0,0,0,'');
INSERT INTO Task VALUES(382,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_2.mp3',1,382,44,0,0,0,'');
INSERT INTO Task VALUES(383,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_3.mp3',1,383,44,0,0,0,'');
INSERT INTO Task VALUES(384,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_4.mp3',1,384,44,0,0,0,'');
INSERT INTO Task VALUES(385,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_5.mp3',1,385,44,0,0,0,'');
INSERT INTO Task VALUES(386,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_6.mp3',1,386,44,0,0,0,'');
INSERT INTO Task VALUES(387,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_7.mp3',1,387,44,0,0,0,'');
INSERT INTO Task VALUES(388,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_8.mp3',1,388,44,0,0,0,'');
INSERT INTO Task VALUES(389,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_9.mp3',1,389,44,0,0,0,'');
INSERT INTO Task VALUES(390,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_2/track_10.mp3',1,390,44,0,0,0,'');
INSERT INTO Task VALUES(391,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_1.mp3',1,391,45,0,0,0,'');
INSERT INTO Task VALUES(392,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_2.mp3',1,392,45,0,0,0,'');
INSERT INTO Task VALUES(393,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_3.mp3',1,393,45,0,0,0,'');
INSERT INTO Task VALUES(394,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_4.mp3',1,394,45,0,0,0,'');
INSERT INTO Task VALUES(395,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_5.mp3',1,395,45,0,0,0,'');
INSERT INTO Task VALUES(396,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_6.mp3',1,396,45,0,0,0,'');
INSERT INTO Task VALUES(397,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_7.mp3',1,397,45,0,0,0,'');
INSERT INTO Task VALUES(398,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_8.mp3',1,398,45,0,0,0,'');
INSERT INTO Task VALUES(399,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_9.mp3',1,399,45,0,0,0,'');
INSERT INTO Task VALUES(400,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_7/album_1/track_10.mp3',1,400,45,0,0,0,'');
INSERT INTO Task VALUES(401,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_1.mp3',1,401,47,0,0,0,'');
INSERT INTO Task VALUES(402,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_2.mp3',1,402,47,0,0,0,'');
INSERT INTO Task VALUES(403,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_3.mp3',1,403,47,0,0,0,'');
INSERT INTO Task VALUES(404,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_4.mp3',1,404,47,0,0,0,'');
INSERT INTO Task VALUES(405,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_5.mp3',1,405,47,0,0,0,'');
INSERT INTO Task VALUES(406,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_6.mp3',1,406,47,0,0,0,'');
INSERT INTO Task VALUES(407,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_7.mp3',1,407,47,0,0,0,'');
INSERT INTO Task VALUES(408,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_8.mp3',1,408,47,0,0,0,'');
INSERT INTO Task VALUES(409,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_9.mp3',1,409,47,0,0,0,'');
INSERT INTO Task VALUES(410,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_10/track_10.mp3',1,410,47,0,0,0,'');
INSERT INTO Task VALUES(411,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_1.mp3',1,411,48,0,0,0,'');
INSERT INTO Task VALUES(412,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_2.mp3',1,412,48,0,0,0,'');
INSERT INTO Task VALUES(413,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_3.mp3',1,413,48,0,0,0,'');
INSERT INTO Task VALUES(414,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_4.mp3',1,414,48,0,0,0,'');
INSERT INTO Task VALUES(415,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_5.mp3',1,415,48,0,0,0,'');
INSERT INTO Task VALUES(416,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_6.mp3',1,416,48,0,0,0,'');
INSERT INTO Task VALUES(417,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_7.mp3',1,417,48,0,0,0,'');
INSERT INTO Task VALUES(418,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_8.mp3',1,418,48,0,0,0,'');
INSERT INTO Task VALUES(419,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_9.mp3',1,419,48,0,0,0,'');
INSERT INTO Task VALUES(420,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_9/track_10.mp3',1,420,48,0,0,0,'');
INSERT INTO Task VALUES(421,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_1.mp3',1,421,49,0,0,0,'');
INSERT INTO Task VALUES(422,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_2.mp3',1,422,49,0,0,0,'');
INSERT INTO Task VALUES(423,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_3.mp3',1,423,49,0,0,0,'');
INSERT INTO Task VALUES(424,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_4.mp3',1,424,49,0,0,0,'');
INSERT INTO Task VALUES(425,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_5.mp3',1,425,49,0,0,0,'');
INSERT INTO Task VALUES(426,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_6.mp3',1,426,49,0,0,0,'');
INSERT INTO Task VALUES(427,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_7.mp3',1,427,49,0,0,0,'');
INSERT INTO Task VALUES(428,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_8.mp3',1,428,49,0,0,0,'');
INSERT INTO Task VALUES(429,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_9.mp3',1,429,49,0,0,0,'');
INSERT INTO Task VALUES(430,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_8/track_10.mp3',1,430,49,0,0,0,'');
INSERT INTO Task VALUES(431,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_1.mp3',1,431,50,0,0,0,'');
INSERT INTO Task VALUES(432,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_2.mp3',1,432,50,0,0,0,'');
INSERT INTO Task VALUES(433,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_3.mp3',1,433,50,0,0,0,'');
INSERT INTO Task VALUES(434,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_4.mp3',1,434,50,0,0,0,'');
INSERT INTO Task VALUES(435,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_5.mp3',1,435,50,0,0,0,'');
INSERT INTO Task VALUES(436,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_6.mp3',1,436,50,0,0,0,'');
INSERT INTO Task VALUES(437,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_7.mp3',1,437,50,0,0,0,'');
INSERT INTO Task VALUES(438,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_8.mp3',1,438,50,0,0,0,'');
INSERT INTO Task VALUES(439,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_9.mp3',1,439,50,0,0,0,'');
INSERT INTO Task VALUES(440,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_7/track_10.mp3',1,440,50,0,0,0,'');
INSERT INTO Task VALUES(441,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_1.mp3',1,441,51,0,0,0,'');
INSERT INTO Task VALUES(442,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_2.mp3',1,442,51,0,0,0,'');
INSERT INTO Task VALUES(443,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_3.mp3',1,443,51,0,0,0,'');
INSERT INTO Task VALUES(444,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_4.mp3',1,444,51,0,0,0,'');
INSERT INTO Task VALUES(445,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_5.mp3',1,445,51,0,0,0,'');
INSERT INTO Task VALUES(446,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_6.mp3',1,446,51,0,0,0,'');
INSERT INTO Task VALUES(447,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_7.mp3',1,447,51,0,0,0,'');
INSERT INTO Task VALUES(448,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_8.mp3',1,448,51,0,0,0,'');
INSERT INTO Task VALUES(449,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_9.mp3',1,449,51,0,0,0,'');
INSERT INTO Task VALUES(450,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_6/track_10.mp3',1,450,51,0,0,0,'');
INSERT INTO Task VALUES(451,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_1.mp3',1,451,52,0,0,0,'');
INSERT INTO Task VALUES(452,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_2.mp3',1,452,52,0,0,0,'');
INSERT INTO Task VALUES(453,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_3.mp3',1,453,52,0,0,0,'');
INSERT INTO Task VALUES(454,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_4.mp3',1,454,52,0,0,0,'');
INSERT INTO Task VALUES(455,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_5.mp3',1,455,52,0,0,0,'');
INSERT INTO Task VALUES(456,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_6.mp3',1,456,52,0,0,0,'');
INSERT INTO Task VALUES(457,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_7.mp3',1,457,52,0,0,0,'');
INSERT INTO Task VALUES(458,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_8.mp3',1,458,52,0,0,0,'');
INSERT INTO Task VALUES(459,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_9.mp3',1,459,52,0,0,0,'');
INSERT INTO Task VALUES(460,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_5/track_10.mp3',1,460,52,0,0,0,'');
INSERT INTO Task VALUES(461,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_1.mp3',1,461,53,0,0,0,'');
INSERT INTO Task VALUES(462,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_2.mp3',1,462,53,0,0,0,'');
INSERT INTO Task VALUES(463,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_3.mp3',1,463,53,0,0,0,'');
INSERT INTO Task VALUES(464,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_4.mp3',1,464,53,0,0,0,'');
INSERT INTO Task VALUES(465,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_5.mp3',1,465,53,0,0,0,'');
INSERT INTO Task VALUES(466,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_6.mp3',1,466,53,0,0,0,'');
INSERT INTO Task VALUES(467,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_7.mp3',1,467,53,0,0,0,'');
INSERT INTO Task VALUES(468,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_8.mp3',1,468,53,0,0,0,'');
INSERT INTO Task VALUES(469,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_9.mp3',1,469,53,0,0,0,'');
INSERT INTO Task VALUES(470,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_4/track_10.mp3',1,470,53,0,0,0,'');
INSERT INTO Task VALUES(471,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_1.mp3',1,471,54,0,0,0,'');
INSERT INTO Task VALUES(472,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_2.mp3',1,472,54,0,0,0,'');
INSERT INTO Task VALUES(473,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_3.mp3',1,473,54,0,0,0,'');
INSERT INTO Task VALUES(474,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_4.mp3',1,474,54,0,0,0,'');
INSERT INTO Task VALUES(475,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_5.mp3',1,475,54,0,0,0,'');
INSERT INTO Task VALUES(476,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_6.mp3',1,476,54,0,0,0,'');
INSERT INTO Task VALUES(477,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_7.mp3',1,477,54,0,0,0,'');
INSERT INTO Task VALUES(478,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_8.mp3',1,478,54,0,0,0,'');
INSERT INTO Task VALUES(479,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_9.mp3',1,479,54,0,0,0,'');
INSERT INTO Task VALUES(480,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_3/track_10.mp3',1,480,54,0,0,0,'');
INSERT INTO Task VALUES(481,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_1.mp3',1,481,55,0,0,0,'');
INSERT INTO Task VALUES(482,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_2.mp3',1,482,55,0,0,0,'');
INSERT INTO Task VALUES(483,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_3.mp3',1,483,55,0,0,0,'');
INSERT INTO Task VALUES(484,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_4.mp3',1,484,55,0,0,0,'');
INSERT INTO Task VALUES(485,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_5.mp3',1,485,55,0,0,0,'');
INSERT INTO Task VALUES(486,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_6.mp3',1,486,55,0,0,0,'');
INSERT INTO Task VALUES(487,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_7.mp3',1,487,55,0,0,0,'');
INSERT INTO Task VALUES(488,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_8.mp3',1,488,55,0,0,0,'');
INSERT INTO Task VALUES(489,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_9.mp3',1,489,55,0,0,0,'');
INSERT INTO Task VALUES(490,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_2/track_10.mp3',1,490,55,0,0,0,'');
INSERT INTO Task VALUES(491,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_1.mp3',1,491,56,0,0,0,'');
INSERT INTO Task VALUES(492,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_2.mp3',1,492,56,0,0,0,'');
INSERT INTO Task VALUES(493,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_3.mp3',1,493,56,0,0,0,'');
INSERT INTO Task VALUES(494,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_4.mp3',1,494,56,0,0,0,'');
INSERT INTO Task VALUES(495,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_5.mp3',1,495,56,0,0,0,'');
INSERT INTO Task VALUES(496,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_6.mp3',1,496,56,0,0,0,'');
INSERT INTO Task VALUES(497,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_7.mp3',1,497,56,0,0,0,'');
INSERT INTO Task VALUES(498,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_8.mp3',1,498,56,0,0,0,'');
INSERT INTO Task VALUES(499,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_9.mp3',1,499,56,0,0,0,'');
INSERT INTO Task VALUES(500,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_6/album_1/track_10.mp3',1,500,56,0,0,0,'');
INSERT INTO Task VALUES(501,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_1.mp3',1,501,58,0,0,0,'');
INSERT INTO Task VALUES(502,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_2.mp3',1,502,58,0,0,0,'');
INSERT INTO Task VALUES(503,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_3.mp3',1,503,58,0,0,0,'');
INSERT INTO Task VALUES(504,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_4.mp3',1,504,58,0,0,0,'');
INSERT INTO Task VALUES(505,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_5.mp3',1,505,58,0,0,0,'');
INSERT INTO Task VALUES(506,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_6.mp3',1,506,58,0,0,0,'');
INSERT INTO Task VALUES(507,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_7.mp3',1,507,58,0,0,0,'');
INSERT INTO Task VALUES(508,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_8.mp3',1,508,58,0,0,0,'');
INSERT INTO Task VALUES(509,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_9.mp3',1,509,58,0,0,0,'');
INSERT INTO Task VALUES(510,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_10/track_10.mp3',1,510,58,0,0,0,'');
INSERT INTO Task VALUES(511,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_1.mp3',1,511,59,0,0,0,'');
INSERT INTO Task VALUES(512,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_2.mp3',1,512,59,0,0,0,'');
INSERT INTO Task VALUES(513,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_3.mp3',1,513,59,0,0,0,'');
INSERT INTO Task VALUES(514,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_4.mp3',1,514,59,0,0,0,'');
INSERT INTO Task VALUES(515,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_5.mp3',1,515,59,0,0,0,'');
INSERT INTO Task VALUES(516,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_6.mp3',1,516,59,0,0,0,'');
INSERT INTO Task VALUES(517,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_7.mp3',1,517,59,0,0,0,'');
INSERT INTO Task VALUES(518,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_8.mp3',1,518,59,0,0,0,'');
INSERT INTO Task VALUES(519,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_9.mp3',1,519,59,0,0,0,'');
INSERT INTO Task VALUES(520,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_9/track_10.mp3',1,520,59,0,0,0,'');
INSERT INTO Task VALUES(521,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_1.mp3',1,521,60,0,0,0,'');
INSERT INTO Task VALUES(522,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_2.mp3',1,522,60,0,0,0,'');
INSERT INTO Task VALUES(523,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_3.mp3',1,523,60,0,0,0,'');
INSERT INTO Task VALUES(524,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_4.mp3',1,524,60,0,0,0,'');
INSERT INTO Task VALUES(525,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_5.mp3',1,525,60,0,0,0,'');
INSERT INTO Task VALUES(526,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_6.mp3',1,526,60,0,0,0,'');
INSERT INTO Task VALUES(527,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_7.mp3',1,527,60,0,0,0,'');
INSERT INTO Task VALUES(528,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_8.mp3',1,528,60,0,0,0,'');
INSERT INTO Task VALUES(529,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_9.mp3',1,529,60,0,0,0,'');
INSERT INTO Task VALUES(530,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_8/track_10.mp3',1,530,60,0,0,0,'');
INSERT INTO Task VALUES(531,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_1.mp3',1,531,61,0,0,0,'');
INSERT INTO Task VALUES(532,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_2.mp3',1,532,61,0,0,0,'');
INSERT INTO Task VALUES(533,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_3.mp3',1,533,61,0,0,0,'');
INSERT INTO Task VALUES(534,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_4.mp3',1,534,61,0,0,0,'');
INSERT INTO Task VALUES(535,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_5.mp3',1,535,61,0,0,0,'');
INSERT INTO Task VALUES(536,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_6.mp3',1,536,61,0,0,0,'');
INSERT INTO Task VALUES(537,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_7.mp3',1,537,61,0,0,0,'');
INSERT INTO Task VALUES(538,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_8.mp3',1,538,61,0,0,0,'');
INSERT INTO Task VALUES(539,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_9.mp3',1,539,61,0,0,0,'');
INSERT INTO Task VALUES(540,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_7/track_10.mp3',1,540,61,0,0,0,'');
INSERT INTO Task VALUES(541,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_1.mp3',1,541,62,0,0,0,'');
INSERT INTO Task VALUES(542,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_2.mp3',1,542,62,0,0,0,'');
INSERT INTO Task VALUES(543,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_3.mp3',1,543,62,0,0,0,'');
INSERT INTO Task VALUES(544,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_4.mp3',1,544,62,0,0,0,'');
INSERT INTO Task VALUES(545,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_5.mp3',1,545,62,0,0,0,'');
INSERT INTO Task VALUES(546,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_6.mp3',1,546,62,0,0,0,'');
INSERT INTO Task VALUES(547,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_7.mp3',1,547,62,0,0,0,'');
INSERT INTO Task VALUES(548,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_8.mp3',1,548,62,0,0,0,'');
INSERT INTO Task VALUES(549,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_9.mp3',1,549,62,0,0,0,'');
INSERT INTO Task VALUES(550,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_6/track_10.mp3',1,550,62,0,0,0,'');
INSERT INTO Task VALUES(551,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_1.mp3',1,551,63,0,0,0,'');
INSERT INTO Task VALUES(552,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_2.mp3',1,552,63,0,0,0,'');
INSERT INTO Task VALUES(553,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_3.mp3',1,553,63,0,0,0,'');
INSERT INTO Task VALUES(554,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_4.mp3',1,554,63,0,0,0,'');
INSERT INTO Task VALUES(555,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_5.mp3',1,555,63,0,0,0,'');
INSERT INTO Task VALUES(556,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_6.mp3',1,556,63,0,0,0,'');
INSERT INTO Task VALUES(557,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_7.mp3',1,557,63,0,0,0,'');
INSERT INTO Task VALUES(558,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_8.mp3',1,558,63,0,0,0,'');
INSERT INTO Task VALUES(559,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_9.mp3',1,559,63,0,0,0,'');
INSERT INTO Task VALUES(560,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_5/track_10.mp3',1,560,63,0,0,0,'');
INSERT INTO Task VALUES(561,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_1.mp3',1,561,64,0,0,0,'');
INSERT INTO Task VALUES(562,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_2.mp3',1,562,64,0,0,0,'');
INSERT INTO Task VALUES(563,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_3.mp3',1,563,64,0,0,0,'');
INSERT INTO Task VALUES(564,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_4.mp3',1,564,64,0,0,0,'');
INSERT INTO Task VALUES(565,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_5.mp3',1,565,64,0,0,0,'');
INSERT INTO Task VALUES(566,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_6.mp3',1,566,64,0,0,0,'');
INSERT INTO Task VALUES(567,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_7.mp3',1,567,64,0,0,0,'');
INSERT INTO Task VALUES(568,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_8.mp3',1,568,64,0,0,0,'');
INSERT INTO Task VALUES(569,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_9.mp3',1,569,64,0,0,0,'');
INSERT INTO Task VALUES(570,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_4/track_10.mp3',1,570,64,0,0,0,'');
INSERT INTO Task VALUES(571,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_1.mp3',1,571,65,0,0,0,'');
INSERT INTO Task VALUES(572,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_2.mp3',1,572,65,0,0,0,'');
INSERT INTO Task VALUES(573,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_3.mp3',1,573,65,0,0,0,'');
INSERT INTO Task VALUES(574,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_4.mp3',1,574,65,0,0,0,'');
INSERT INTO Task VALUES(575,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_5.mp3',1,575,65,0,0,0,'');
INSERT INTO Task VALUES(576,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_6.mp3',1,576,65,0,0,0,'');
INSERT INTO Task VALUES(577,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_7.mp3',1,577,65,0,0,0,'');
INSERT INTO Task VALUES(578,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_8.mp3',1,578,65,0,0,0,'');
INSERT INTO Task VALUES(579,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_9.mp3',1,579,65,0,0,0,'');
INSERT INTO Task VALUES(580,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_3/track_10.mp3',1,580,65,0,0,0,'');
INSERT INTO Task VALUES(581,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_1.mp3',1,581,66,0,0,0,'');
INSERT INTO Task VALUES(582,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_2.mp3',1,582,66,0,0,0,'');
INSERT INTO Task VALUES(583,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_3.mp3',1,583,66,0,0,0,'');
INSERT INTO Task VALUES(584,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_4.mp3',1,584,66,0,0,0,'');
INSERT INTO Task VALUES(585,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_5.mp3',1,585,66,0,0,0,'');
INSERT INTO Task VALUES(586,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_6.mp3',1,586,66,0,0,0,'');
INSERT INTO Task VALUES(587,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_7.mp3',1,587,66,0,0,0,'');
INSERT INTO Task VALUES(588,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_8.mp3',1,588,66,0,0,0,'');
INSERT INTO Task VALUES(589,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_9.mp3',1,589,66,0,0,0,'');
INSERT INTO Task VALUES(590,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_2/track_10.mp3',1,590,66,0,0,0,'');
INSERT INTO Task VALUES(591,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_1.mp3',1,591,67,0,0,0,'');
INSERT INTO Task VALUES(592,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_2.mp3',1,592,67,0,0,0,'');
INSERT INTO Task VALUES(593,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_3.mp3',1,593,67,0,0,0,'');
INSERT INTO Task VALUES(594,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_4.mp3',1,594,67,0,0,0,'');
INSERT INTO Task VALUES(595,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_5.mp3',1,595,67,0,0,0,'');
INSERT INTO Task VALUES(596,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_6.mp3',1,596,67,0,0,0,'');
INSERT INTO Task VALUES(597,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_7.mp3',1,597,67,0,0,0,'');
INSERT INTO Task VALUES(598,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_8.mp3',1,598,67,0,0,0,'');
INSERT INTO Task VALUES(599,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_9.mp3',1,599,67,0,0,0,'');
INSERT INTO Task VALUES(600,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_5/album_1/track_10.mp3',1,600,67,0,0,0,'');
INSERT INTO Task VALUES(601,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_1.mp3',1,601,69,0,0,0,'');
INSERT INTO Task VALUES(602,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_2.mp3',1,602,69,0,0,0,'');
INSERT INTO Task VALUES(603,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_3.mp3',1,603,69,0,0,0,'');
INSERT INTO Task VALUES(604,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_4.mp3',1,604,69,0,0,0,'');
INSERT INTO Task VALUES(605,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_5.mp3',1,605,69,0,0,0,'');
INSERT INTO Task VALUES(606,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_6.mp3',1,606,69,0,0,0,'');
INSERT INTO Task VALUES(607,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_7.mp3',1,607,69,0,0,0,'');
INSERT INTO Task VALUES(608,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_8.mp3',1,608,69,0,0,0,'');
INSERT INTO Task VALUES(609,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_9.mp3',1,609,69,0,0,0,'');
INSERT INTO Task VALUES(610,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_10/track_10.mp3',1,610,69,0,0,0,'');
INSERT INTO Task VALUES(611,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_1.mp3',1,611,70,0,0,0,'');
INSERT INTO Task VALUES(612,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_2.mp3',1,612,70,0,0,0,'');
INSERT INTO Task VALUES(613,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_3.mp3',1,613,70,0,0,0,'');
INSERT INTO Task VALUES(614,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_4.mp3',1,614,70,0,0,0,'');
INSERT INTO Task VALUES(615,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_5.mp3',1,615,70,0,0,0,'');
INSERT INTO Task VALUES(616,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_6.mp3',1,616,70,0,0,0,'');
INSERT INTO Task VALUES(617,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_7.mp3',1,617,70,0,0,0,'');
INSERT INTO Task VALUES(618,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_8.mp3',1,618,70,0,0,0,'');
INSERT INTO Task VALUES(619,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_9.mp3',1,619,70,0,0,0,'');
INSERT INTO Task VALUES(620,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_9/track_10.mp3',1,620,70,0,0,0,'');
INSERT INTO Task VALUES(621,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_1.mp3',1,621,71,0,0,0,'');
INSERT INTO Task VALUES(622,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_2.mp3',1,622,71,0,0,0,'');
INSERT INTO Task VALUES(623,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_3.mp3',1,623,71,0,0,0,'');
INSERT INTO Task VALUES(624,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_4.mp3',1,624,71,0,0,0,'');
INSERT INTO Task VALUES(625,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_5.mp3',1,625,71,0,0,0,'');
INSERT INTO Task VALUES(626,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_6.mp3',1,626,71,0,0,0,'');
INSERT INTO Task VALUES(627,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_7.mp3',1,627,71,0,0,0,'');
INSERT INTO Task VALUES(628,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_8.mp3',1,628,71,0,0,0,'');
INSERT INTO Task VALUES(629,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_9.mp3',1,629,71,0,0,0,'');
INSERT INTO Task VALUES(630,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_8/track_10.mp3',1,630,71,0,0,0,'');
INSERT INTO Task VALUES(631,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_1.mp3',1,631,72,0,0,0,'');
INSERT INTO Task VALUES(632,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_2.mp3',1,632,72,0,0,0,'');
INSERT INTO Task VALUES(633,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_3.mp3',1,633,72,0,0,0,'');
INSERT INTO Task VALUES(634,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_4.mp3',1,634,72,0,0,0,'');
INSERT INTO Task VALUES(635,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_5.mp3',1,635,72,0,0,0,'');
INSERT INTO Task VALUES(636,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_6.mp3',1,636,72,0,0,0,'');
INSERT INTO Task VALUES(637,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_7.mp3',1,637,72,0,0,0,'');
INSERT INTO Task VALUES(638,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_8.mp3',1,638,72,0,0,0,'');
INSERT INTO Task VALUES(639,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_9.mp3',1,639,72,0,0,0,'');
INSERT INTO Task VALUES(640,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_7/track_10.mp3',1,640,72,0,0,0,'');
INSERT INTO Task VALUES(641,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_1.mp3',1,641,73,0,0,0,'');
INSERT INTO Task VALUES(642,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_2.mp3',1,642,73,0,0,0,'');
INSERT INTO Task VALUES(643,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_3.mp3',1,643,73,0,0,0,'');
INSERT INTO Task VALUES(644,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_4.mp3',1,644,73,0,0,0,'');
INSERT INTO Task VALUES(645,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_5.mp3',1,645,73,0,0,0,'');
INSERT INTO Task VALUES(646,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_6.mp3',1,646,73,0,0,0,'');
INSERT INTO Task VALUES(647,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_7.mp3',1,647,73,0,0,0,'');
INSERT INTO Task VALUES(648,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_8.mp3',1,648,73,0,0,0,'');
INSERT INTO Task VALUES(649,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_9.mp3',1,649,73,0,0,0,'');
INSERT INTO Task VALUES(650,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_6/track_10.mp3',1,650,73,0,0,0,'');
INSERT INTO Task VALUES(651,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_1.mp3',1,651,74,0,0,0,'');
INSERT INTO Task VALUES(652,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_2.mp3',1,652,74,0,0,0,'');
INSERT INTO Task VALUES(653,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_3.mp3',1,653,74,0,0,0,'');
INSERT INTO Task VALUES(654,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_4.mp3',1,654,74,0,0,0,'');
INSERT INTO Task VALUES(655,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_5.mp3',1,655,74,0,0,0,'');
INSERT INTO Task VALUES(656,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_6.mp3',1,656,74,0,0,0,'');
INSERT INTO Task VALUES(657,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_7.mp3',1,657,74,0,0,0,'');
INSERT INTO Task VALUES(658,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_8.mp3',1,658,74,0,0,0,'');
INSERT INTO Task VALUES(659,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_9.mp3',1,659,74,0,0,0,'');
INSERT INTO Task VALUES(660,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_5/track_10.mp3',1,660,74,0,0,0,'');
INSERT INTO Task VALUES(661,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_1.mp3',1,661,75,0,0,0,'');
INSERT INTO Task VALUES(662,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_2.mp3',1,662,75,0,0,0,'');
INSERT INTO Task VALUES(663,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_3.mp3',1,663,75,0,0,0,'');
INSERT INTO Task VALUES(664,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_4.mp3',1,664,75,0,0,0,'');
INSERT INTO Task VALUES(665,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_5.mp3',1,665,75,0,0,0,'');
INSERT INTO Task VALUES(666,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_6.mp3',1,666,75,0,0,0,'');
INSERT INTO Task VALUES(667,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_7.mp3',1,667,75,0,0,0,'');
INSERT INTO Task VALUES(668,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_8.mp3',1,668,75,0,0,0,'');
INSERT INTO Task VALUES(669,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_9.mp3',1,669,75,0,0,0,'');
INSERT INTO Task VALUES(670,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_4/track_10.mp3',1,670,75,0,0,0,'');
INSERT INTO Task VALUES(671,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_1.mp3',1,671,76,0,0,0,'');
INSERT INTO Task VALUES(672,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_2.mp3',1,672,76,0,0,0,'');
INSERT INTO Task VALUES(673,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_3.mp3',1,673,76,0,0,0,'');
INSERT INTO Task VALUES(674,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_4.mp3',1,674,76,0,0,0,'');
INSERT INTO Task VALUES(675,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_5.mp3',1,675,76,0,0,0,'');
INSERT INTO Task VALUES(676,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_6.mp3',1,676,76,0,0,0,'');
INSERT INTO Task VALUES(677,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_7.mp3',1,677,76,0,0,0,'');
INSERT INTO Task VALUES(678,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_8.mp3',1,678,76,0,0,0,'');
INSERT INTO Task VALUES(679,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_9.mp3',1,679,76,0,0,0,'');
INSERT INTO Task VALUES(680,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_3/track_10.mp3',1,680,76,0,0,0,'');
INSERT INTO Task VALUES(681,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_1.mp3',1,681,77,0,0,0,'');
INSERT INTO Task VALUES(682,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_2.mp3',1,682,77,0,0,0,'');
INSERT INTO Task VALUES(683,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_3.mp3',1,683,77,0,0,0,'');
INSERT INTO Task VALUES(684,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_4.mp3',1,684,77,0,0,0,'');
INSERT INTO Task VALUES(685,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_5.mp3',1,685,77,0,0,0,'');
INSERT INTO Task VALUES(686,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_6.mp3',1,686,77,0,0,0,'');
INSERT INTO Task VALUES(687,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_7.mp3',1,687,77,0,0,0,'');
INSERT INTO Task VALUES(688,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_8.mp3',1,688,77,0,0,0,'');
INSERT INTO Task VALUES(689,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_9.mp3',1,689,77,0,0,0,'');
INSERT INTO Task VALUES(690,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_2/track_10.mp3',1,690,77,0,0,0,'');
INSERT INTO Task VALUES(691,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_1.mp3',1,691,78,0,0,0,'');
INSERT INTO Task VALUES(692,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_2.mp3',1,692,78,0,0,0,'');
INSERT INTO Task VALUES(693,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_3.mp3',1,693,78,0,0,0,'');
INSERT INTO Task VALUES(694,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_4.mp3',1,694,78,0,0,0,'');
INSERT INTO Task VALUES(695,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_5.mp3',1,695,78,0,0,0,'');
INSERT INTO Task VALUES(696,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_6.mp3',1,696,78,0,0,0,'');
INSERT INTO Task VALUES(697,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_7.mp3',1,697,78,0,0,0,'');
INSERT INTO Task VALUES(698,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_8.mp3',1,698,78,0,0,0,'');
INSERT INTO Task VALUES(699,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_9.mp3',1,699,78,0,0,0,'');
INSERT INTO Task VALUES(700,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_4/album_1/track_10.mp3',1,700,78,0,0,0,'');
INSERT INTO Task VALUES(701,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_1.mp3',1,701,80,0,0,0,'');
INSERT INTO Task VALUES(702,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_2.mp3',1,702,80,0,0,0,'');
INSERT INTO Task VALUES(703,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_3.mp3',1,703,80,0,0,0,'');
INSERT INTO Task VALUES(704,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_4.mp3',1,704,80,0,0,0,'');
INSERT INTO Task VALUES(705,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_5.mp3',1,705,80,0,0,0,'');
INSERT INTO Task VALUES(706,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_6.mp3',1,706,80,0,0,0,'');
INSERT INTO Task VALUES(707,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_7.mp3',1,707,80,0,0,0,'');
INSERT INTO Task VALUES(708,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_8.mp3',1,708,80,0,0,0,'');
INSERT INTO Task VALUES(709,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_9.mp3',1,709,80,0,0,0,'');
INSERT INTO Task VALUES(710,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_10/track_10.mp3',1,710,80,0,0,0,'');
INSERT INTO Task VALUES(711,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_1.mp3',1,711,81,0,0,0,'');
INSERT INTO Task VALUES(712,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_2.mp3',1,712,81,0,0,0,'');
INSERT INTO Task VALUES(713,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_3.mp3',1,713,81,0,0,0,'');
INSERT INTO Task VALUES(714,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_4.mp3',1,714,81,0,0,0,'');
INSERT INTO Task VALUES(715,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_5.mp3',1,715,81,0,0,0,'');
INSERT INTO Task VALUES(716,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_6.mp3',1,716,81,0,0,0,'');
INSERT INTO Task VALUES(717,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_7.mp3',1,717,81,0,0,0,'');
INSERT INTO Task VALUES(718,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_8.mp3',1,718,81,0,0,0,'');
INSERT INTO Task VALUES(719,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_9.mp3',1,719,81,0,0,0,'');
INSERT INTO Task VALUES(720,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_9/track_10.mp3',1,720,81,0,0,0,'');
INSERT INTO Task VALUES(721,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_1.mp3',1,721,82,0,0,0,'');
INSERT INTO Task VALUES(722,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_2.mp3',1,722,82,0,0,0,'');
INSERT INTO Task VALUES(723,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_3.mp3',1,723,82,0,0,0,'');
INSERT INTO Task VALUES(724,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_4.mp3',1,724,82,0,0,0,'');
INSERT INTO Task VALUES(725,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_5.mp3',1,725,82,0,0,0,'');
INSERT INTO Task VALUES(726,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_6.mp3',1,726,82,0,0,0,'');
INSERT INTO Task VALUES(727,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_7.mp3',1,727,82,0,0,0,'');
INSERT INTO Task VALUES(728,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_8.mp3',1,728,82,0,0,0,'');
INSERT INTO Task VALUES(729,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_9.mp3',1,729,82,0,0,0,'');
INSERT INTO Task VALUES(730,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_8/track_10.mp3',1,730,82,0,0,0,'');
INSERT INTO Task VALUES(731,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_1.mp3',1,731,83,0,0,0,'');
INSERT INTO Task VALUES(732,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_2.mp3',1,732,83,0,0,0,'');
INSERT INTO Task VALUES(733,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_3.mp3',1,733,83,0,0,0,'');
INSERT INTO Task VALUES(734,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_4.mp3',1,734,83,0,0,0,'');
INSERT INTO Task VALUES(735,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_5.mp3',1,735,83,0,0,0,'');
INSERT INTO Task VALUES(736,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_6.mp3',1,736,83,0,0,0,'');
INSERT INTO Task VALUES(737,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_7.mp3',1,737,83,0,0,0,'');
INSERT INTO Task VALUES(738,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_8.mp3',1,738,83,0,0,0,'');
INSERT INTO Task VALUES(739,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_9.mp3',1,739,83,0,0,0,'');
INSERT INTO Task VALUES(740,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_7/track_10.mp3',1,740,83,0,0,0,'');
INSERT INTO Task VALUES(741,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_1.mp3',1,741,84,0,0,0,'');
INSERT INTO Task VALUES(742,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_2.mp3',1,742,84,0,0,0,'');
INSERT INTO Task VALUES(743,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_3.mp3',1,743,84,0,0,0,'');
INSERT INTO Task VALUES(744,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_4.mp3',1,744,84,0,0,0,'');
INSERT INTO Task VALUES(745,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_5.mp3',1,745,84,0,0,0,'');
INSERT INTO Task VALUES(746,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_6.mp3',1,746,84,0,0,0,'');
INSERT INTO Task VALUES(747,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_7.mp3',1,747,84,0,0,0,'');
INSERT INTO Task VALUES(748,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_8.mp3',1,748,84,0,0,0,'');
INSERT INTO Task VALUES(749,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_9.mp3',1,749,84,0,0,0,'');
INSERT INTO Task VALUES(750,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_6/track_10.mp3',1,750,84,0,0,0,'');
INSERT INTO Task VALUES(751,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_1.mp3',1,751,85,0,0,0,'');
INSERT INTO Task VALUES(752,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_2.mp3',1,752,85,0,0,0,'');
INSERT INTO Task VALUES(753,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_3.mp3',1,753,85,0,0,0,'');
INSERT INTO Task VALUES(754,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_4.mp3',1,754,85,0,0,0,'');
INSERT INTO Task VALUES(755,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_5.mp3',1,755,85,0,0,0,'');
INSERT INTO Task VALUES(756,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_6.mp3',1,756,85,0,0,0,'');
INSERT INTO Task VALUES(757,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_7.mp3',1,757,85,0,0,0,'');
INSERT INTO Task VALUES(758,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_8.mp3',1,758,85,0,0,0,'');
INSERT INTO Task VALUES(759,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_9.mp3',1,759,85,0,0,0,'');
INSERT INTO Task VALUES(760,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_5/track_10.mp3',1,760,85,0,0,0,'');
INSERT INTO Task VALUES(761,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_1.mp3',1,761,86,0,0,0,'');
INSERT INTO Task VALUES(762,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_2.mp3',1,762,86,0,0,0,'');
INSERT INTO Task VALUES(763,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_3.mp3',1,763,86,0,0,0,'');
INSERT INTO Task VALUES(764,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_4.mp3',1,764,86,0,0,0,'');
INSERT INTO Task VALUES(765,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_5.mp3',1,765,86,0,0,0,'');
INSERT INTO Task VALUES(766,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_6.mp3',1,766,86,0,0,0,'');
INSERT INTO Task VALUES(767,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_7.mp3',1,767,86,0,0,0,'');
INSERT INTO Task VALUES(768,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_8.mp3',1,768,86,0,0,0,'');
INSERT INTO Task VALUES(769,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_9.mp3',1,769,86,0,0,0,'');
INSERT INTO Task VALUES(770,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_4/track_10.mp3',1,770,86,0,0,0,'');
INSERT INTO Task VALUES(771,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_1.mp3',1,771,87,0,0,0,'');
INSERT INTO Task VALUES(772,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_2.mp3',1,772,87,0,0,0,'');
INSERT INTO Task VALUES(773,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_3.mp3',1,773,87,0,0,0,'');
INSERT INTO Task VALUES(774,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_4.mp3',1,774,87,0,0,0,'');
INSERT INTO Task VALUES(775,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_5.mp3',1,775,87,0,0,0,'');
INSERT INTO Task VALUES(776,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_6.mp3',1,776,87,0,0,0,'');
INSERT INTO Task VALUES(777,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_7.mp3',1,777,87,0,0,0,'');
INSERT INTO Task VALUES(778,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_8.mp3',1,778,87,0,0,0,'');
INSERT INTO Task VALUES(779,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_9.mp3',1,779,87,0,0,0,'');
INSERT INTO Task VALUES(780,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_3/track_10.mp3',1,780,87,0,0,0,'');
INSERT INTO Task VALUES(781,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_1.mp3',1,781,88,0,0,0,'');
INSERT INTO Task VALUES(782,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_2.mp3',1,782,88,0,0,0,'');
INSERT INTO Task VALUES(783,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_3.mp3',1,783,88,0,0,0,'');
INSERT INTO Task VALUES(784,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_4.mp3',1,784,88,0,0,0,'');
INSERT INTO Task VALUES(785,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_5.mp3',1,785,88,0,0,0,'');
INSERT INTO Task VALUES(786,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_6.mp3',1,786,88,0,0,0,'');
INSERT INTO Task VALUES(787,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_7.mp3',1,787,88,0,0,0,'');
INSERT INTO Task VALUES(788,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_8.mp3',1,788,88,0,0,0,'');
INSERT INTO Task VALUES(789,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_9.mp3',1,789,88,0,0,0,'');
INSERT INTO Task VALUES(790,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_2/track_10.mp3',1,790,88,0,0,0,'');
INSERT INTO Task VALUES(791,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_1.mp3',1,791,89,0,0,0,'');
INSERT INTO Task VALUES(792,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_2.mp3',1,792,89,0,0,0,'');
INSERT INTO Task VALUES(793,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_3.mp3',1,793,89,0,0,0,'');
INSERT INTO Task VALUES(794,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_4.mp3',1,794,89,0,0,0,'');
INSERT INTO Task VALUES(795,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_5.mp3',1,795,89,0,0,0,'');
INSERT INTO Task VALUES(796,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_6.mp3',1,796,89,0,0,0,'');
INSERT INTO Task VALUES(797,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_7.mp3',1,797,89,0,0,0,'');
INSERT INTO Task VALUES(798,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_8.mp3',1,798,89,0,0,0,'');
INSERT INTO Task VALUES(799,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_9.mp3',1,799,89,0,0,0,'');
INSERT INTO Task VALUES(800,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_3/album_1/track_10.mp3',1,800,89,0,0,0,'');
INSERT INTO Task VALUES(801,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_1.mp3',1,801,91,0,0,0,'');
INSERT INTO Task VALUES(802,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_2.mp3',1,802,91,0,0,0,'');
INSERT INTO Task VALUES(803,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_3.mp3',1,803,91,0,0,0,'');
INSERT INTO Task VALUES(804,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_4.mp3',1,804,91,0,0,0,'');
INSERT INTO Task VALUES(805,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_5.mp3',1,805,91,0,0,0,'');
INSERT INTO Task VALUES(806,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_6.mp3',1,806,91,0,0,0,'');
INSERT INTO Task VALUES(807,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_7.mp3',1,807,91,0,0,0,'');
INSERT INTO Task VALUES(808,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_8.mp3',1,808,91,0,0,0,'');
INSERT INTO Task VALUES(809,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_9.mp3',1,809,91,0,0,0,'');
INSERT INTO Task VALUES(810,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_10/track_10.mp3',1,810,91,0,0,0,'');
INSERT INTO Task VALUES(811,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_1.mp3',1,811,92,0,0,0,'');
INSERT INTO Task VALUES(812,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_2.mp3',1,812,92,0,0,0,'');
INSERT INTO Task VALUES(813,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_3.mp3',1,813,92,0,0,0,'');
INSERT INTO Task VALUES(814,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_4.mp3',1,814,92,0,0,0,'');
INSERT INTO Task VALUES(815,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_5.mp3',1,815,92,0,0,0,'');
INSERT INTO Task VALUES(816,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_6.mp3',1,816,92,0,0,0,'');
INSERT INTO Task VALUES(817,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_7.mp3',1,817,92,0,0,0,'');
INSERT INTO Task VALUES(818,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_8.mp3',1,818,92,0,0,0,'');
INSERT INTO Task VALUES(819,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_9.mp3',1,819,92,0,0,0,'');
INSERT INTO Task VALUES(820,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_9/track_10.mp3',1,820,92,0,0,0,'');
INSERT INTO Task VALUES(821,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_1.mp3',1,821,93,0,0,0,'');
INSERT INTO Task VALUES(822,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_2.mp3',1,822,93,0,0,0,'');
INSERT INTO Task VALUES(823,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_3.mp3',1,823,93,0,0,0,'');
INSERT INTO Task VALUES(824,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_4.mp3',1,824,93,0,0,0,'');
INSERT INTO Task VALUES(825,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_5.mp3',1,825,93,0,0,0,'');
INSERT INTO Task VALUES(826,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_6.mp3',1,826,93,0,0,0,'');
INSERT INTO Task VALUES(827,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_7.mp3',1,827,93,0,0,0,'');
INSERT INTO Task VALUES(828,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_8.mp3',1,828,93,0,0,0,'');
INSERT INTO Task VALUES(829,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_9.mp3',1,829,93,0,0,0,'');
INSERT INTO Task VALUES(830,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_8/track_10.mp3',1,830,93,0,0,0,'');
INSERT INTO Task VALUES(831,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_1.mp3',1,831,94,0,0,0,'');
INSERT INTO Task VALUES(832,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_2.mp3',1,832,94,0,0,0,'');
INSERT INTO Task VALUES(833,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_3.mp3',1,833,94,0,0,0,'');
INSERT INTO Task VALUES(834,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_4.mp3',1,834,94,0,0,0,'');
INSERT INTO Task VALUES(835,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_5.mp3',1,835,94,0,0,0,'');
INSERT INTO Task VALUES(836,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_6.mp3',1,836,94,0,0,0,'');
INSERT INTO Task VALUES(837,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_7.mp3',1,837,94,0,0,0,'');
INSERT INTO Task VALUES(838,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_8.mp3',1,838,94,0,0,0,'');
INSERT INTO Task VALUES(839,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_9.mp3',1,839,94,0,0,0,'');
INSERT INTO Task VALUES(840,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_7/track_10.mp3',1,840,94,0,0,0,'');
INSERT INTO Task VALUES(841,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_1.mp3',1,841,95,0,0,0,'');
INSERT INTO Task VALUES(842,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_2.mp3',1,842,95,0,0,0,'');
INSERT INTO Task VALUES(843,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_3.mp3',1,843,95,0,0,0,'');
INSERT INTO Task VALUES(844,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_4.mp3',1,844,95,0,0,0,'');
INSERT INTO Task VALUES(845,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_5.mp3',1,845,95,0,0,0,'');
INSERT INTO Task VALUES(846,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_6.mp3',1,846,95,0,0,0,'');
INSERT INTO Task VALUES(847,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_7.mp3',1,847,95,0,0,0,'');
INSERT INTO Task VALUES(848,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_8.mp3',1,848,95,0,0,0,'');
INSERT INTO Task VALUES(849,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_9.mp3',1,849,95,0,0,0,'');
INSERT INTO Task VALUES(850,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_6/track_10.mp3',1,850,95,0,0,0,'');
INSERT INTO Task VALUES(851,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_1.mp3',1,851,96,0,0,0,'');
INSERT INTO Task VALUES(852,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_2.mp3',1,852,96,0,0,0,'');
INSERT INTO Task VALUES(853,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_3.mp3',1,853,96,0,0,0,'');
INSERT INTO Task VALUES(854,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_4.mp3',1,854,96,0,0,0,'');
INSERT INTO Task VALUES(855,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_5.mp3',1,855,96,0,0,0,'');
INSERT INTO Task VALUES(856,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_6.mp3',1,856,96,0,0,0,'');
INSERT INTO Task VALUES(857,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_7.mp3',1,857,96,0,0,0,'');
INSERT INTO Task VALUES(858,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_8.mp3',1,858,96,0,0,0,'');
INSERT INTO Task VALUES(859,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_9.mp3',1,859,96,0,0,0,'');
INSERT INTO Task VALUES(860,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_5/track_10.mp3',1,860,96,0,0,0,'');
INSERT INTO Task VALUES(861,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_1.mp3',1,861,97,0,0,0,'');
INSERT INTO Task VALUES(862,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_2.mp3',1,862,97,0,0,0,'');
INSERT INTO Task VALUES(863,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_3.mp3',1,863,97,0,0,0,'');
INSERT INTO Task VALUES(864,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_4.mp3',1,864,97,0,0,0,'');
INSERT INTO Task VALUES(865,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_5.mp3',1,865,97,0,0,0,'');
INSERT INTO Task VALUES(866,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_6.mp3',1,866,97,0,0,0,'');
INSERT INTO Task VALUES(867,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_7.mp3',1,867,97,0,0,0,'');
INSERT INTO Task VALUES(868,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_8.mp3',1,868,97,0,0,0,'');
INSERT INTO Task VALUES(869,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_9.mp3',1,869,97,0,0,0,'');
INSERT INTO Task VALUES(870,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_4/track_10.mp3',1,870,97,0,0,0,'');
INSERT INTO Task VALUES(871,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_1.mp3',1,871,98,0,0,0,'');
INSERT INTO Task VALUES(872,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_2.mp3',1,872,98,0,0,0,'');
INSERT INTO Task VALUES(873,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_3.mp3',1,873,98,0,0,0,'');
INSERT INTO Task VALUES(874,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_4.mp3',1,874,98,0,0,0,'');
INSERT INTO Task VALUES(875,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_5.mp3',1,875,98,0,0,0,'');
INSERT INTO Task VALUES(876,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_6.mp3',1,876,98,0,0,0,'');
INSERT INTO Task VALUES(877,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_7.mp3',1,877,98,0,0,0,'');
INSERT INTO Task VALUES(878,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_8.mp3',1,878,98,0,0,0,'');
INSERT INTO Task VALUES(879,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_9.mp3',1,879,98,0,0,0,'');
INSERT INTO Task VALUES(880,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_3/track_10.mp3',1,880,98,0,0,0,'');
INSERT INTO Task VALUES(881,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_1.mp3',1,881,99,0,0,0,'');
INSERT INTO Task VALUES(882,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_2.mp3',1,882,99,0,0,0,'');
INSERT INTO Task VALUES(883,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_3.mp3',1,883,99,0,0,0,'');
INSERT INTO Task VALUES(884,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_4.mp3',1,884,99,0,0,0,'');
INSERT INTO Task VALUES(885,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_5.mp3',1,885,99,0,0,0,'');
INSERT INTO Task VALUES(886,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_6.mp3',1,886,99,0,0,0,'');
INSERT INTO Task VALUES(887,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_7.mp3',1,887,99,0,0,0,'');
INSERT INTO Task VALUES(888,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_8.mp3',1,888,99,0,0,0,'');
INSERT INTO Task VALUES(889,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_9.mp3',1,889,99,0,0,0,'');
INSERT INTO Task VALUES(890,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_2/track_10.mp3',1,890,99,0,0,0,'');
INSERT INTO Task VALUES(891,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_1.mp3',1,891,100,0,0,0,'');
INSERT INTO Task VALUES(892,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_2.mp3',1,892,100,0,0,0,'');
INSERT INTO Task VALUES(893,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_3.mp3',1,893,100,0,0,0,'');
INSERT INTO Task VALUES(894,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_4.mp3',1,894,100,0,0,0,'');
INSERT INTO Task VALUES(895,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_5.mp3',1,895,100,0,0,0,'');
INSERT INTO Task VALUES(896,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_6.mp3',1,896,100,0,0,0,'');
INSERT INTO Task VALUES(897,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_7.mp3',1,897,100,0,0,0,'');
INSERT INTO Task VALUES(898,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_8.mp3',1,898,100,0,0,0,'');
INSERT INTO Task VALUES(899,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_9.mp3',1,899,100,0,0,0,'');
INSERT INTO Task VALUES(900,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_2/album_1/track_10.mp3',1,900,100,0,0,0,'');
INSERT INTO Task VALUES(901,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_1.mp3',1,901,102,0,0,0,'');
INSERT INTO Task VALUES(902,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_2.mp3',1,902,102,0,0,0,'');
INSERT INTO Task VALUES(903,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_3.mp3',1,903,102,0,0,0,'');
INSERT INTO Task VALUES(904,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_4.mp3',1,904,102,0,0,0,'');
INSERT INTO Task VALUES(905,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_5.mp3',1,905,102,0,0,0,'');
INSERT INTO Task VALUES(906,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_6.mp3',1,906,102,0,0,0,'');
INSERT INTO Task VALUES(907,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_7.mp3',1,907,102,0,0,0,'');
INSERT INTO Task VALUES(908,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_8.mp3',1,908,102,0,0,0,'');
INSERT INTO Task VALUES(909,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_9.mp3',1,909,102,0,0,0,'');
INSERT INTO Task VALUES(910,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_10/track_10.mp3',1,910,102,0,0,0,'');
INSERT INTO Task VALUES(911,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_1.mp3',1,911,103,0,0,0,'');
INSERT INTO Task VALUES(912,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_2.mp3',1,912,103,0,0,0,'');
INSERT INTO Task VALUES(913,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_3.mp3',1,913,103,0,0,0,'');
INSERT INTO Task VALUES(914,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_4.mp3',1,914,103,0,0,0,'');
INSERT INTO Task VALUES(915,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_5.mp3',1,915,103,0,0,0,'');
INSERT INTO Task VALUES(916,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_6.mp3',1,916,103,0,0,0,'');
INSERT INTO Task VALUES(917,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_7.mp3',1,917,103,0,0,0,'');
INSERT INTO Task VALUES(918,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_8.mp3',1,918,103,0,0,0,'');
INSERT INTO Task VALUES(919,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_9.mp3',1,919,103,0,0,0,'');
INSERT INTO Task VALUES(920,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_9/track_10.mp3',1,920,103,0,0,0,'');
INSERT INTO Task VALUES(921,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_1.mp3',1,921,104,0,0,0,'');
INSERT INTO Task VALUES(922,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_2.mp3',1,922,104,0,0,0,'');
INSERT INTO Task VALUES(923,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_3.mp3',1,923,104,0,0,0,'');
INSERT INTO Task VALUES(924,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_4.mp3',1,924,104,0,0,0,'');
INSERT INTO Task VALUES(925,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_5.mp3',1,925,104,0,0,0,'');
INSERT INTO Task VALUES(926,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_6.mp3',1,926,104,0,0,0,'');
INSERT INTO Task VALUES(927,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_7.mp3',1,927,104,0,0,0,'');
INSERT INTO Task VALUES(928,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_8.mp3',1,928,104,0,0,0,'');
INSERT INTO Task VALUES(929,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_9.mp3',1,929,104,0,0,0,'');
INSERT INTO Task VALUES(930,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_8/track_10.mp3',1,930,104,0,0,0,'');
INSERT INTO Task VALUES(931,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_1.mp3',1,931,105,0,0,0,'');
INSERT INTO Task VALUES(932,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_2.mp3',1,932,105,0,0,0,'');
INSERT INTO Task VALUES(933,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_3.mp3',1,933,105,0,0,0,'');
INSERT INTO Task VALUES(934,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_4.mp3',1,934,105,0,0,0,'');
INSERT INTO Task VALUES(935,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_5.mp3',1,935,105,0,0,0,'');
INSERT INTO Task VALUES(936,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_6.mp3',1,936,105,0,0,0,'');
INSERT INTO Task VALUES(937,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_7.mp3',1,937,105,0,0,0,'');
INSERT INTO Task VALUES(938,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_8.mp3',1,938,105,0,0,0,'');
INSERT INTO Task VALUES(939,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_9.mp3',1,939,105,0,0,0,'');
INSERT INTO Task VALUES(940,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_7/track_10.mp3',1,940,105,0,0,0,'');
INSERT INTO Task VALUES(941,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_1.mp3',1,941,106,0,0,0,'');
INSERT INTO Task VALUES(942,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_2.mp3',1,942,106,0,0,0,'');
INSERT INTO Task VALUES(943,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_3.mp3',1,943,106,0,0,0,'');
INSERT INTO Task VALUES(944,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_4.mp3',1,944,106,0,0,0,'');
INSERT INTO Task VALUES(945,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_5.mp3',1,945,106,0,0,0,'');
INSERT INTO Task VALUES(946,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_6.mp3',1,946,106,0,0,0,'');
INSERT INTO Task VALUES(947,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_7.mp3',1,947,106,0,0,0,'');
INSERT INTO Task VALUES(948,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_8.mp3',1,948,106,0,0,0,'');
INSERT INTO Task VALUES(949,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_9.mp3',1,949,106,0,0,0,'');
INSERT INTO Task VALUES(950,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_6/track_10.mp3',1,950,106,0,0,0,'');
INSERT INTO Task VALUES(951,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_1.mp3',1,951,107,0,0,0,'');
INSERT INTO Task VALUES(952,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_2.mp3',1,952,107,0,0,0,'');
INSERT INTO Task VALUES(953,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_3.mp3',1,953,107,0,0,0,'');
INSERT INTO Task VALUES(954,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_4.mp3',1,954,107,0,0,0,'');
INSERT INTO Task VALUES(955,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_5.mp3',1,955,107,0,0,0,'');
INSERT INTO Task VALUES(956,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_6.mp3',1,956,107,0,0,0,'');
INSERT INTO Task VALUES(957,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_7.mp3',1,957,107,0,0,0,'');
INSERT INTO Task VALUES(958,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_8.mp3',1,958,107,0,0,0,'');
INSERT INTO Task VALUES(959,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_9.mp3',1,959,107,0,0,0,'');
INSERT INTO Task VALUES(960,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_5/track_10.mp3',1,960,107,0,0,0,'');
INSERT INTO Task VALUES(961,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_1.mp3',1,961,108,0,0,0,'');
INSERT INTO Task VALUES(962,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_2.mp3',1,962,108,0,0,0,'');
INSERT INTO Task VALUES(963,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_3.mp3',1,963,108,0,0,0,'');
INSERT INTO Task VALUES(964,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_4.mp3',1,964,108,0,0,0,'');
INSERT INTO Task VALUES(965,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_5.mp3',1,965,108,0,0,0,'');
INSERT INTO Task VALUES(966,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_6.mp3',1,966,108,0,0,0,'');
INSERT INTO Task VALUES(967,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_7.mp3',1,967,108,0,0,0,'');
INSERT INTO Task VALUES(968,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_8.mp3',1,968,108,0,0,0,'');
INSERT INTO Task VALUES(969,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_9.mp3',1,969,108,0,0,0,'');
INSERT INTO Task VALUES(970,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_4/track_10.mp3',1,970,108,0,0,0,'');
INSERT INTO Task VALUES(971,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_1.mp3',1,971,109,0,0,0,'');
INSERT INTO Task VALUES(972,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_2.mp3',1,972,109,0,0,0,'');
INSERT INTO Task VALUES(973,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_3.mp3',1,973,109,0,0,0,'');
INSERT INTO Task VALUES(974,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_4.mp3',1,974,109,0,0,0,'');
INSERT INTO Task VALUES(975,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_5.mp3',1,975,109,0,0,0,'');
INSERT INTO Task VALUES(976,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_6.mp3',1,976,109,0,0,0,'');
INSERT INTO Task VALUES(977,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_7.mp3',1,977,109,0,0,0,'');
INSERT INTO Task VALUES(978,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_8.mp3',1,978,109,0,0,0,'');
INSERT INTO Task VALUES(979,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_9.mp3',1,979,109,0,0,0,'');
INSERT INTO Task VALUES(980,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_3/track_10.mp3',1,980,109,0,0,0,'');
INSERT INTO Task VALUES(981,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_1.mp3',1,981,110,0,0,0,'');
INSERT INTO Task VALUES(982,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_2.mp3',1,982,110,0,0,0,'');
INSERT INTO Task VALUES(983,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_3.mp3',1,983,110,0,0,0,'');
INSERT INTO Task VALUES(984,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_4.mp3',1,984,110,0,0,0,'');
INSERT INTO Task VALUES(985,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_5.mp3',1,985,110,0,0,0,'');
INSERT INTO Task VALUES(986,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_6.mp3',1,986,110,0,0,0,'');
INSERT INTO Task VALUES(987,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_7.mp3',1,987,110,0,0,0,'');
INSERT INTO Task VALUES(988,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_8.mp3',1,988,110,0,0,0,'');
INSERT INTO Task VALUES(989,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_9.mp3',1,989,110,0,0,0,'');
INSERT INTO Task VALUES(990,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_2/track_10.mp3',1,990,110,0,0,0,'');
INSERT INTO Task VALUES(991,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_1.mp3',1,991,111,0,0,0,'');
INSERT INTO Task VALUES(992,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_2.mp3',1,992,111,0,0,0,'');
INSERT INTO Task VALUES(993,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_3.mp3',1,993,111,0,0,0,'');
INSERT INTO Task VALUES(994,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_4.mp3',1,994,111,0,0,0,'');
INSERT INTO Task VALUES(995,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_5.mp3',1,995,111,0,0,0,'');
INSERT INTO Task VALUES(996,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_6.mp3',1,996,111,0,0,0,'');
INSERT INTO Task VALUES(997,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_7.mp3',1,997,111,0,0,0,'');
INSERT INTO Task VALUES(998,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_8.mp3',1,998,111,0,0,0,'');
INSERT INTO Task VALUES(999,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_9.mp3',1,999,111,0,0,0,'');
INSERT INTO Task VALUES(1000,3,2,0,'file:///builds/videolan/medialibrary/dummysamples/artist_1/album_1/track_10.mp3',1,1000,111,0,0,0,'');
COMMIT;
