# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_set_algorithm import DataSetAlgorithm


class MarkBoundaryFilter(DataSetAlgorithm):
    r"""
    MarkBoundaryFilter - mark points and cells that lie on the
    boundary of a dataset
    
    Superclass: DataSetAlgorithm
    
    MarkBoundaryFilter is a general-purpose filter to mark those cells
    and points on the boundary of a dataset. The output of the filter is
    identical to the input, with the exception that two, new data arrays
    are added to the output that indicate which input points, and input
    cells, are on the boundary. (Cells and points on the boundary are
    indicated by a non-zero value, accessed in the appropriate data array
    by cell id or point id.)
    
    In general, n-dimensional faces are on the boundary of a
    (n+1)-dataset if used by a single (n+1)-dimensional cell. So for
    example the boundary cells of a volumetric dataset are those with
    quad faces used by only one voxel. Boundary points are those points
    used by the boundary faces. A cell may have multiple boundary faces.
    
    An optional array can be produced that encodes the boundary faces of
    each cell. For each cell cellId that is on the boundary, the nth bit
    of the value of the faces tuple at location cellId is set.
    
    @warning
    This filter is similar to GeometryFilter in that it identifies
    boundary cells and points. However, GeometryFilter produces output
    boundary faces and points as output. MarkBoundaryFilter simply
    identifies which cells and points are on the boundary. (This filter
    is often used in parallel computing applications to help distrbute
    data across multiple processes.)
    
    @warning
    The points and cells boundary arrays are of type unsigned char.  The
    optional boundary faces array is of type of IdType (either a
    32-bit or 64-but integral value depending on compilation flags).
    Hence if the number of cell faces exceeds the number of bits in a
    face array value, then the faces array cannot properly encode the
    boundary faces for that cell. This may be a problem for cell types
    with an arbitrary number of faces such as Polyhedron and
    Polygon.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    GeometryFilter DataSetSurfaceFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMarkBoundaryFilter, obj, update, **traits)
    
    generate_boundary_faces = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable the creation of the boundary faces array. This array
        encodes which faces are on the boundary of the ith cell. By
        default, this array is not created. To use this array, bit
        masking is required to determine if the jth face is on the
        boundary.
        """
    )

    def _generate_boundary_faces_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateBoundaryFaces,
                        self.generate_boundary_faces_)

    boundary_cells_name = traits.String('BoundaryCells', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _boundary_cells_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBoundaryCellsName,
                        self.boundary_cells_name)

    boundary_faces_name = traits.String('BoundaryFaces', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _boundary_faces_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBoundaryFacesName,
                        self.boundary_faces_name)

    boundary_points_name = traits.String('BoundaryPoints', enter_set=True, auto_set=False, desc=\
        r"""
        Specify the names of the two data arrays which indicate which
        cells and points are on the boundary. By default,
        "boundary_points", "boundary_cells", and "boundary_faces" are used.
        """
    )

    def _boundary_points_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBoundaryPointsName,
                        self.boundary_points_name)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    _updateable_traits_ = \
    (('generate_boundary_faces', 'GetGenerateBoundaryFaces'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('boundary_cells_name', 'GetBoundaryCellsName'),
    ('boundary_faces_name', 'GetBoundaryFacesName'),
    ('boundary_points_name', 'GetBoundaryPointsName'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'generate_boundary_faces',
    'global_warning_display', 'release_data_flag', 'boundary_cells_name',
    'boundary_faces_name', 'boundary_points_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MarkBoundaryFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MarkBoundaryFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['generate_boundary_faces'], [], ['boundary_cells_name',
            'boundary_faces_name', 'boundary_points_name']),
            title='Edit MarkBoundaryFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MarkBoundaryFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

