message("WIN10-UCRT64 environment https://www.msys2.org/")
message("Please run the configuration like this:")
message("cmake -G \"Unix Makefiles\" -DCMAKE_BUILD_TYPE=Release ../development")

# Comment out these two lines that make the build fail with #include_next math.h
# file not found error.
# set(CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES "c:/msys64/ucrt64/include")
# set(CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES "c:/msys64/ucrt64/include")


set(HOME_DEVEL_DIR "$ENV{HOME}/devel")
set(SHIPPED_DLLS_DIR "${HOME_DEVEL_DIR}/dll-set-for-packages")

# We are building the lib, so need to export the symbols.
add_definitions(-D EXPORT_LIB_SYMBOLS)

find_package(
    Qt6
    COMPONENTS
    REQUIRED   Core
               Svg
               Xml
               Network
               PrintSupport
               Qml
               Sql
               Concurrent
               Core5Compat
)

set(IsoSpec++_FOUND 1)
set(IsoSpec++_INCLUDE_DIRS "${HOME_DEVEL_DIR}/isospec/development/src")
set(IsoSpec++_LIBRARIES "${SHIPPED_DLLS_DIR}/libIsoSpec++.dll")
#set(IsoSpec++_LIBRARIES "c:/msys64/home/polipo/devel/dll-set-for-packages/libIsoSpec++.dll")
if(NOT TARGET IsoSpec++::IsoSpec++)
  add_library(IsoSpec++::IsoSpec++ UNKNOWN IMPORTED)
  set_target_properties(IsoSpec++::IsoSpec++ PROPERTIES
    IMPORTED_LOCATION             "${IsoSpec++_LIBRARIES}"
    INTERFACE_INCLUDE_DIRECTORIES "${IsoSpec++_INCLUDE_DIRS}")
endif()


set(PappsoMSpp_FOUND 1)
set(PappsoMSpp_INCLUDE_DIRS "${HOME_DEVEL_DIR}/pappsomspp/development/src")
set(PappsoMSpp_LIBRARIES
  "${SHIPPED_DLLS_DIR}/libpappsomspp-core.dll")
if(NOT TARGET PappsoMSpp::Core)

  add_library(PappsoMSpp::Core UNKNOWN IMPORTED GLOBAL)
  set_target_properties(PappsoMSpp::Core PROPERTIES
    IMPORTED_LOCATION ${PappsoMSpp_LIBRARIES}
    INTERFACE_INCLUDE_DIRECTORIES ${PappsoMSpp_INCLUDE_DIRS})

endif()


set(PappsoMSppGui_FOUND 1)
set(PappsoMSppGui_LIBRARIES
  "${SHIPPED_DLLS_DIR}/libpappsomspp-gui.dll")
if(NOT TARGET PappsoMSpp::Gui)

  add_library(PappsoMSpp::Gui UNKNOWN IMPORTED GLOBAL)
  set_target_properties(PappsoMSpp::Gui PROPERTIES
    IMPORTED_LOCATION ${PappsoMSppGui_LIBRARIES}
    INTERFACE_INCLUDE_DIRECTORIES ${PappsoMSpp_INCLUDE_DIRS})

endif()

include_directories(${include_directories} ${PappsoMSpp_INCLUDE_DIRS} ${PappsoMSpp_INCLUDE_DIRS})


find_package(ZLIB REQUIRED)

find_package(SQLite3 REQUIRED)

find_package(
    Boost
    COMPONENTS chrono
               container
               filesystem
               iostreams
               thread
    REQUIRED
)

find_package(Catch2)
message("Catch2 major version found: " ${Catch2_VERSION_MAJOR})
add_compile_definitions(CATCH2_MAJOR_VERSION_${Catch2_VERSION_MAJOR})

set(QCustomPlotQt6_FOUND 1)
set(QCustomPlotQt6_INCLUDE_DIR "${HOME_DEVEL_DIR}/qcustomplot/development")
set(QCustomPlotQt6_LIBRARIES "${SHIPPED_DLLS_DIR}/libQCustomPlotQt6.dll")
if(NOT TARGET QCustomPlotQt6::QCustomPlotQt6)
    add_library(QCustomPlotQt6::QCustomPlotQt6 UNKNOWN IMPORTED)
    set_target_properties(
        QCustomPlotQt6::QCustomPlotQt6
        PROPERTIES IMPORTED_LOCATION "${QCustomPlotQt6_LIBRARIES}"
                   INTERFACE_INCLUDE_DIRECTORIES "${QCustomPlotQt6_INCLUDE_DIR}"
                   INTERFACE_COMPILE_DEFINITIONS QCUSTOMPLOT_USE_LIBRARY
    )
endif()

find_package(Zstd REQUIRED)

set(PwizLite_FOUND 1)
set(PwizLite_INCLUDE_DIRS "${HOME_DEVEL_DIR}/pwizlite/development/src")
set(PwizLite_LIBRARIES "${SHIPPED_DLLS_DIR}/libpwizlite.dll")
if(NOT TARGET PwizLite::PwizLite)
    add_library(PwizLite::PwizLite UNKNOWN IMPORTED)
    set_target_properties(
        PwizLite::PwizLite PROPERTIES IMPORTED_LOCATION "${PwizLite_LIBRARIES}" INTERFACE_INCLUDE_DIRECTORIES
                                                                                "${PwizLite_INCLUDE_DIRS}"
    )
endif()

set(liblzf_FOUND 1)
set(liblzf_INCLUDE_DIRS "${HOME_DEVEL_DIR}/lzf/development")

set(liblzf_LIBRARIES "${SHIPPED_DLLS_DIR}/liblzf.dll")
if(NOT TARGET liblzf::liblzf)
    add_library(liblzf::liblzf UNKNOWN IMPORTED)
    set_target_properties(
        liblzf::liblzf
        PROPERTIES IMPORTED_LOCATION "${liblzf_LIBRARIES}"
                   INTERFACE_INCLUDE_DIRECTORIES "${liblzf_INCLUDE_DIRS}"
                   INTERFACE_COMPILE_DEFINITIONS LIBLZF_USE_LIBRARY
    )
endif()


find_package(QuaZip-Qt6 REQUIRED)

set(QScintilla_FOUND 1)
set(QScintilla_INCLUDE_DIRS "c:/msys64/ucrt64/include/qt6/Qsci")
set(QScintilla_LIBRARIES "${SHIPPED_DLLS_DIR}/qscintilla2_qt6.dll")
if(NOT TARGET QScintilla::QScintilla)
    add_library(QScintilla::QScintilla UNKNOWN IMPORTED)
    set_target_properties(
        QScintilla::QScintilla PROPERTIES IMPORTED_LOCATION "${QScintilla_LIBRARIES}" INTERFACE_INCLUDE_DIRECTORIES
                                                                                      "${QScintilla_INCLUDE_DIRS}"
    )
endif()

#OPENMP
message(STATUS "${BoldYellow}OpenMP support is compulsory.${ColourReset}")
#message(STATUS "CMAKE_MODULE_PATH: ${CMAKE_MODULE_PATH}")
#set(OpenMP_DIR ${CMAKE_MODULE_PATH})

# Unfortunately that does not work as it does not find the
# include directories. So we need to do the work manually.

find_package(OpenMP REQUIRED)

set(OpenMP_FOUND 1)
set(OpenMP_INCLUDE_DIRS "C:/msys64/ucrt64/lib/gcc/x86_64-w64-mingw32/13.2.0/include/omp.h")
set(OpenMP_LIBRARIES "C:/msys64/ucrt64/bin/libgomp-1.dll")
if(NOT TARGET OpenMP::OpenMP_CXX)

  add_library(OpenMP::OpenMP UNKNOWN IMPORTED)

  set_target_properties(OpenMP::OpenMP_CXX PROPERTIES
    IMPORTED_LOCATION             "${OpenMP_LIBRARIES}"
    INTERFACE_INCLUDE_DIRECTORIES "${OpenMP_INCLUDE_DIRS}"
    )
endif()

message(STATUS "OpenMP libraries: ${OpenMP_LIBRARIES}")
message(STATUS "OpenMP include dirs: ${OpenMP_INCLUDE_DIRS}")


## Platform-dependent compiler flags:
include(CheckCXXCompilerFlag)

set(CORE_SOURCE_LIB ${CMAKE_BINARY_DIR}/source/XpertMassCore/libXpertMassCore.dll)
set(GUI_SOURCE_LIB ${CMAKE_BINARY_DIR}/source/XpertMassGui/libXpertMassGui.dll)

add_custom_target(
    dllinstall
    COMMAND ${CMAKE_COMMAND} -E copy ${CORE_SOURCE_LIB} ${GUI_SOURCE_LIB} ${SHIPPED_DLLS_DIR}
    COMMENT "Build and copy the dll files to their MXE destination."
    DEPENDS Core Gui
    VERBATIM
)

# On Win10 all the code is relocatable.
remove_definitions(-fPIC)
