/* ----- encode/953xfreeze3, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_953xfreeze3_checksums[] = {
  "072c38c98e9744daf3b6761d57bf6ea58f590165eb3a418379211720cfcb7dc0",
  "6105c1a5693f0c92e5afdadd2c1990b5ca456f6362ac010e8051d59e8c420bfe",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_953xfreeze3_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_953xfreeze3_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_953xfreeze3_ITEMBYTES

static void *storage_encode_953xfreeze3_s;
static unsigned char *test_encode_953xfreeze3_s;
static void *storage_encode_953xfreeze3_x;
static unsigned char *test_encode_953xfreeze3_x;
static void *storage_encode_953xfreeze3_s2;
static unsigned char *test_encode_953xfreeze3_s2;
static void *storage_encode_953xfreeze3_x2;
static unsigned char *test_encode_953xfreeze3_x2;

#define precomputed_encode_953xfreeze3_NUM 4

static const unsigned char precomputed_encode_953xfreeze3_s[precomputed_encode_953xfreeze3_NUM][crypto_encode_STRBYTES] = {
  {0,0,254,0,0,255,1,1,255,255,0,2,255,255,254,2,255,0,255,0,0,255,1,254,255,255,0,255,0,0,1,255,0,255,0,255,2,0,255,1,255,255,0,0,254,0,2,1,0,255,0,255,1,254,255,0,0,0,255,255,255,1,255,0,0,0,255,255,0,1,255,255,1,255,1,255,255,1,0,1,254,0,255,2,255,255,0,0,254,0,255,255,254,1,255,2,2,2,255,0,1,0,0,0,2,1,0,1,1,255,2,255,0,255,1,0,0,0,255,2,0,0,1,1,2,255,0,255,0,0,255,1,1,255,0,255,1,255,1,255,2,0,255,255,255,255,1,1,1,1,0,1,0,0,1,255,255,254,0,0,0,255,0,1,254,1,0,255,255,0,0,1,2,255,255,0,255,1,0,254,1,2,1,1,0,0,254,0,1,254,255,0,255,0,0,254,1,255,1,0,255,255,255,255,1,2,255,0,2,255,0,0,255,0,0,0,2,2,0,255,2,255,0,255,1,255,0,255,2,0,2,1,255,0,1,255,0,255,0,0,0,1,0,0,255,1,254,1,0,255,1,255,0,0,1,255,255,2,0,0,1,0,255,1,0,1,0,1,0,2,0,1,1,0,0,0,254,254,0,2,1,0,255,0,0,255,0,1,2,2,0,254,255,255,2,1,255,0,254,1,1,0,1,254,254,0,0,255,1,255,1,255,0,255,1,2,255,0,255,0,1,1,0,255,255,255,2,255,0,0,0,255,255,2,0,0,0,1,255,0,255,0,0,0,254,1,2,1,254,0,255,1,255,255,1,254,255,255,255,2,0,0,255,255,0,1,0,0,1,1,0,255,254,1,1,1,1,255,254,254,2,0,1,2,255,0,0,254,0,254,2,255,2,1,255,0,0,254,2,0,1,0,255,1,255,254,254,255,1,255,255,0,0,0,0,1,0,255,1,255,2,1,2,1,2,1,2,2,255,255,255,255,0,1,255,254,0,255,0,0,1,254,2,0,255,0,0,255,1,1,0,0,255,0,0,1,0,0,254,255,2,0,255,0,0,255,1,254,254,1,255,0,2,1,1,1,0,2,1,0,255,255,1,0,2,254,0,2,255,254,254,255,1,1,1,0,254,2,255,255,254,0,1,255,255,255,255,1,0,1,0,0,0,2,255,1,0,2,255,255,1,1,2,255,255,1,0,2,2,0,1,255,0,255,0,1,0,0,2,1,2,1,0,255,0,0,1,0,0,0,2,255,0,254,0,0,2,0,1,1,0,1,1,0,255,0,255,0,0,2,255,255,2,255,0,1,0,0,0,1,0,255,0,255,1,2,254,0,255,1,1,1,254,0,0,0,255,0,1,255,1,254,0,254,255,255,0,255,255,0,1,1,254,0,2,255,0,0,2,1,0,0,0,1,0,0,1,2,1,1,1,1,0,0,0,1,2,1,255,1,0,0,1,255,1,255,0,255,255,255,0,255,0,0,1,1,255,0,1,255,1,0,0,0,255,254,1,254,255,1,0,255,1,1,1,255,1,2,0,255,0,254,255,0,1,255,0,1,0,255,254,255,0,255,2,254,255,0,255,254,0,1,1,0,0,255,1,0,0,0,255,0,255,255,255,0,255,254,1,0,0,1,0,0,2,255,1,0,254,255,254,0,0,255,0,0,1,1,255,0,255,255,0,0,254,255,1,254,0,0,0,1,255,0,0,1,255,255,0,1,2,0,2,0,0,1,1,0,0,1,0,0,1,0,0,255,0,254,255,0,0,255,1,1,1,1,1,1,1,0,0,255,1,0,0,0,2,2,0,255,1,254,0,2,1,1,254,2,255,255,254,255,1,255,255,1,254,255,0,1,0,0,254,0,255,1,0,0,254,2,1,1,1,0,0,1,0,1,1,1,0,1,0,0,1,255,1,2,0,255,0,0,255,1,1,0,1,0,2,255,255,2,255,255,255,0,0,0,0,255,0,0,0,255,0,255,255,0,1,255,0,0,255,254,0,255,255,1,1,0,1,0,2,0,255,255,0,0,255,0,255,0,1,0,1,1,2,1,254,255,255,0,0,255,0,0,255,2,1,255,255,255,0,1,255,0,0,1,255,255,1,1,1,255,1,254,2,1,255,255,0,0,255,1,1,1,254,254,0,255,2,2,1},
  {2,255,0,255,254,0,255,255,0,255,0,255,255,0,0,2,1,0,0,0,0,0,0,0,255,0,2,255,255,255,0,255,255,1,1,255,0,255,254,0,1,254,1,0,0,1,255,254,2,255,255,0,255,255,255,2,254,0,1,1,1,0,0,2,255,0,0,2,1,0,1,1,0,0,0,1,1,1,1,0,255,0,255,1,2,0,0,0,255,255,0,2,0,0,0,0,2,1,0,1,0,0,1,1,254,255,0,255,1,0,255,0,2,0,1,254,0,0,0,0,1,1,0,0,1,0,0,1,255,255,255,0,255,1,0,255,0,0,0,1,0,0,255,1,255,255,254,0,1,0,1,255,1,255,0,0,0,0,0,254,255,255,0,1,0,255,255,0,0,254,0,0,1,0,0,1,2,0,0,0,254,0,254,0,1,0,255,1,255,255,1,255,1,0,255,0,1,254,1,2,1,255,255,255,2,1,0,1,254,0,0,0,255,254,0,255,255,1,254,0,1,0,1,2,255,255,0,255,255,255,255,1,254,0,254,1,1,0,255,0,0,2,2,255,2,255,1,0,0,255,255,254,255,2,1,1,0,255,1,254,2,1,0,255,0,0,0,255,255,255,255,1,1,255,2,255,2,1,0,255,255,255,1,1,254,1,0,0,1,255,2,255,0,0,0,255,0,255,1,0,0,1,1,0,1,0,1,0,1,254,255,2,255,2,2,1,0,254,0,0,1,1,255,255,2,2,1,1,254,1,1,1,255,0,0,255,1,255,1,0,0,1,1,1,0,0,0,1,255,255,1,255,1,0,255,1,255,255,0,0,2,255,2,0,255,0,255,0,2,0,0,2,0,0,0,255,0,255,254,255,1,0,1,2,1,255,1,1,1,255,254,1,255,1,255,255,0,255,2,1,255,1,0,2,1,255,1,0,0,255,1,255,0,254,255,0,0,0,1,255,0,254,1,0,0,255,255,254,2,1,255,1,1,255,2,255,2,2,2,255,255,0,0,254,1,0,255,0,255,1,1,1,1,255,255,1,254,1,255,255,255,254,255,1,255,1,1,255,1,255,0,255,0,0,1,255,0,255,0,0,0,1,1,1,0,255,0,1,0,0,1,0,0,0,255,0,255,255,0,255,255,1,0,0,1,1,0,255,2,254,0,255,0,1,1,255,1,2,255,1,255,1,255,1,255,1,0,1,0,255,1,1,1,254,0,2,2,1,0,255,255,0,1,1,0,0,0,0,1,1,0,1,255,1,1,255,0,255,255,254,255,1,0,1,2,255,0,2,255,255,255,0,255,1,0,1,254,254,0,2,255,255,1,1,255,0,0,1,2,1,0,1,255,255,0,255,255,2,1,1,2,1,0,1,255,254,0,255,0,254,2,0,1,0,0,255,0,1,0,255,1,0,255,254,0,255,255,0,254,0,0,254,0,0,1,0,255,0,254,0,1,255,255,255,1,255,255,255,255,1,0,1,1,1,255,0,255,1,0,0,0,0,255,0,0,1,1,1,1,0,0,1,254,1,1,255,0,0,254,255,255,255,1,1,255,255,0,254,0,255,0,0,0,1,255,0,0,255,0,1,254,0,2,1,255,255,0,1,255,254,0,0,255,1,255,1,255,254,254,255,0,254,254,254,0,1,1,2,1,2,255,0,255,255,2,0,0,1,1,0,0,255,255,0,255,255,0,0,0,254,1,0,254,1,1,1,1,0,255,2,255,255,255,0,255,1,255,255,0,0,1,255,0,0,0,1,1,0,0,0,255,255,0,255,0,1,0,255,255,0,254,2,0,255,1,0,255,0,1,0,0,1,255,255,0,255,0,254,0,0,2,0,1,255,1,0,1,2,1,0,255,1,1,2,1,254,1,1,255,255,0,1,0,0,254,0,254,255,1,255,1,255,0,0,0,255,255,255,255,1,0,255,0,0,255,0,0,1,1,0,0,255,1,1,0,254,255,0,255,0,254,1,1,0,0,255,255,1,0,0,0,254,0,255,0,1,0,1,0,255,0,255,255,255,254,0,1,2,0,0,255,255,1,1,0,2,254,1,0,255,255,255,0,255,1,255,1,254,255,0,2,255,1,255,1,2,1,1,255,0,255,1,0,1,0,1,0,255,1,255,0,1,1,2,0,0,0,2,0,2,255,0,255},
  {0,254,0,2,1,1,0,255,255,0,0,255,2,1,1,255,0,0,255,1,0,0,0,0,2,1,1,255,0,255,255,1,255,1,1,0,0,255,0,255,255,0,0,254,255,1,1,255,254,1,1,254,255,255,255,2,0,1,255,1,254,1,255,255,255,254,254,1,255,0,2,1,2,2,1,1,0,0,254,0,0,0,0,1,1,0,255,1,254,255,255,0,2,255,0,2,254,0,0,1,254,255,254,255,254,0,0,254,255,254,255,255,255,0,1,255,1,2,1,254,1,0,1,255,255,255,255,0,255,0,0,255,1,1,255,254,255,0,254,1,0,254,1,1,1,1,1,2,254,1,255,255,1,1,254,1,0,1,1,0,0,254,0,1,254,2,255,255,0,1,1,0,254,255,0,255,1,254,2,254,255,255,255,255,0,0,255,255,1,254,0,1,254,1,1,0,0,2,0,0,0,1,255,254,0,255,0,255,0,255,254,255,0,2,254,1,255,0,255,1,0,1,0,1,255,254,1,2,0,1,0,255,255,2,0,2,1,1,255,0,1,1,0,2,0,1,0,0,1,1,255,1,1,255,255,255,0,1,0,1,255,1,1,0,0,0,255,0,0,0,2,255,2,0,1,255,0,255,255,0,0,0,254,255,0,254,0,1,1,0,255,255,255,0,1,255,1,0,0,255,254,0,0,0,0,2,254,255,0,255,1,254,255,0,1,0,0,0,0,1,1,255,1,0,254,0,0,254,255,255,255,255,0,0,1,1,255,254,2,255,0,0,1,0,0,0,0,1,0,254,1,1,255,0,0,0,254,1,254,0,254,1,0,0,1,0,255,255,1,1,255,0,0,0,1,255,255,0,0,255,255,255,0,0,0,1,0,254,0,2,1,1,255,1,255,1,255,2,1,254,0,255,255,255,0,255,255,2,1,255,1,1,1,0,0,254,1,0,2,0,255,1,255,1,1,1,0,1,0,255,0,2,1,255,255,255,0,1,255,255,255,2,255,255,0,2,0,1,0,255,255,255,255,2,254,1,255,1,255,255,1,254,0,1,1,0,0,1,255,255,1,1,2,1,2,2,1,255,255,2,0,255,2,255,1,1,0,0,0,0,0,255,1,1,1,0,1,2,254,255,0,255,255,1,0,0,0,0,1,0,255,0,0,0,1,255,254,1,254,254,0,0,1,1,254,255,254,1,0,1,0,0,0,254,254,255,0,0,254,0,255,1,1,255,0,255,0,254,1,1,1,255,0,0,1,2,255,0,1,255,2,0,1,2,0,255,255,2,1,0,255,2,255,1,255,1,0,1,255,255,0,255,255,0,1,1,0,0,255,0,1,255,254,255,0,255,255,254,2,0,0,1,1,254,0,1,1,255,2,255,0,1,255,0,1,1,1,254,0,1,1,1,255,0,1,0,255,0,255,1,255,255,2,0,255,255,1,1,1,255,0,0,1,255,0,2,255,255,255,0,2,0,1,255,255,255,255,0,2,254,1,254,1,255,2,254,254,2,0,255,1,255,255,255,1,255,0,0,0,1,1,2,0,1,0,255,0,0,0,0,1,1,255,254,2,1,0,254,255,0,2,254,0,0,0,0,0,1,0,1,0,255,254,0,255,0,1,0,0,1,0,255,1,255,1,255,2,0,2,254,1,1,1,2,0,255,0,1,255,1,1,254,2,255,254,254,0,1,0,255,255,255,255,0,0,255,0,0,0,255,2,255,0,0,1,0,255,1,0,254,0,0,0,0,0,1,0,0,255,1,0,255,0,0,0,0,0,1,0,255,0,255,255,0,255,0,0,0,254,0,1,255,1,255,1,0,255,255,255,255,255,0,0,0,0,0,1,255,1,255,0,1,0,1,255,0,0,0,0,254,0,1,0,255,2,0,255,2,1,1,0,1,0,0,255,0,254,0,255,2,0,0,1,2,255,255,0,1,0,0,255,1,0,255,2,1,1,2,1,0,1,254,254,1,255,254,1,1,0,0,0,255,1,0,1,254,0,0,255,1,0,0,255,2,1,2,254,0,1,254,1,0,255,0,0,1,255,255,0,1,1,1,255,2,2,0,1,0,0,0,255,255,0,0,254,255,0,1,0,0,255,255,1,1,1,0,1,1,255,0,1,2,0,0,254,0,0,1,254,255,0,254,0},
  {255,2,2,0,0,1,1,254,0,1,1,0,255,1,255,1,255,1,254,0,254,0,0,1,1,1,255,255,1,1,0,0,2,1,2,0,0,255,1,255,254,255,254,255,2,255,0,0,0,0,0,0,255,2,255,1,0,0,1,2,255,1,1,254,1,0,254,1,1,0,0,254,0,0,1,255,0,0,255,1,0,2,0,254,0,1,0,2,1,0,255,0,1,0,0,255,255,1,0,0,1,0,1,0,0,0,0,1,255,255,255,0,255,254,1,255,255,0,1,0,0,0,255,1,255,0,255,1,255,1,0,0,0,0,1,0,0,2,255,1,2,2,1,255,2,2,0,1,0,0,0,2,255,0,2,0,0,0,1,254,255,1,255,0,255,0,0,255,0,255,255,0,255,255,2,0,1,255,0,0,1,1,254,1,255,1,255,0,2,0,0,255,254,1,255,0,0,0,1,1,255,1,1,1,0,1,0,1,255,0,1,255,1,1,254,2,1,1,0,2,1,2,254,0,255,254,254,2,1,1,0,255,0,2,2,1,1,0,2,0,255,255,0,255,1,0,0,0,2,1,0,0,0,0,1,0,255,254,0,1,0,255,2,0,254,0,255,254,1,1,0,1,0,2,255,255,254,0,2,0,255,1,1,254,254,0,255,255,0,254,1,255,0,1,2,254,255,255,0,0,1,1,0,0,255,255,255,1,0,0,0,0,0,255,0,255,2,255,0,1,254,0,255,0,1,2,255,1,0,0,255,0,254,255,0,1,0,254,0,0,2,254,255,0,254,254,1,0,255,0,255,1,255,255,2,0,2,254,1,1,2,255,0,2,255,0,0,255,2,255,255,0,0,0,255,2,0,255,1,255,1,0,0,1,0,0,0,1,0,255,255,1,0,2,0,255,0,1,254,0,0,1,255,0,255,255,0,1,1,0,254,1,0,1,1,2,1,0,1,255,254,1,0,0,255,255,1,255,1,0,2,255,1,0,254,1,255,0,0,255,255,0,2,1,255,0,2,1,1,0,1,0,255,0,1,0,0,2,2,255,0,0,255,1,1,255,0,1,0,255,255,255,255,0,255,255,254,0,0,255,0,1,0,254,254,1,255,1,254,255,0,2,0,0,0,0,255,2,255,0,0,0,1,254,2,0,0,255,1,0,0,1,254,255,1,255,255,1,2,255,0,0,1,1,254,0,255,1,0,255,255,0,254,1,255,1,254,254,1,1,255,1,0,1,1,255,1,1,255,0,0,0,0,255,255,255,255,1,0,255,255,0,255,255,255,2,255,255,255,0,0,1,255,1,2,0,0,0,254,1,0,0,1,255,1,254,1,255,2,0,255,1,255,255,1,0,255,254,1,0,0,0,0,0,0,0,255,0,0,0,255,254,255,0,254,1,1,255,1,254,1,2,0,2,0,0,255,1,255,255,1,1,0,254,0,0,255,255,255,1,0,0,0,255,1,1,2,1,255,255,0,0,255,1,254,2,255,1,0,0,0,255,0,1,0,1,254,1,1,1,1,2,1,0,1,0,254,0,255,254,255,255,1,1,1,255,0,1,255,2,255,1,255,0,254,255,1,1,0,1,1,0,1,1,0,1,254,1,0,255,1,0,255,255,1,255,255,254,0,2,0,0,0,1,255,1,1,255,255,1,0,0,2,1,0,0,1,1,255,255,1,1,1,255,0,255,255,0,1,0,1,1,0,0,0,1,1,255,0,0,0,255,1,1,0,255,1,255,0,1,0,255,1,254,255,0,254,254,1,0,0,1,255,0,1,255,254,1,1,1,2,255,0,2,255,255,255,1,1,1,1,0,255,1,0,255,255,254,0,0,0,255,0,1,1,254,0,1,1,254,1,2,254,1,2,254,254,0,255,1,255,2,1,1,0,255,1,0,255,2,254,1,255,0,254,0,0,254,1,0,1,1,1,1,254,1,0,1,0,0,1,1,0,0,1,1,0,2,0,0,255,255,0,0,255,2,255,1,2,1,2,2,0,254,255,1,255,0,255,254,1,255,1,1,1,0,0,1,255,255,0,0,2,255,255,255,254,255,0,255,1,1,1,0,1,0,0,255,1,1,0,2,255,0,1,254,255,255,255,1,0,2,255,1,255,255,0,1,0,255,1,1,254,1,0,0,255,0,1,0,1,2,1},
} ;

static const int16_t precomputed_encode_953xfreeze3_x[precomputed_encode_953xfreeze3_NUM][crypto_encode_ITEMS] = {
  {-20367,-2838,31933,-26736,7308,6242,10165,-29372,3965,15812,26997,-18658,25862,9041,26179,-24346,28958,10416,29216,-3285,-8697,-10816,-1754,27316,-6955,-5371,20067,-2017,30759,-30297,-22955,-11614,-13491,6878,-537,10868,-30388,-18336,16952,-17489,-7243,11111,20175,18867,26701,-10257,-24517,-10697,10656,-10663,-21708,-14425,-32276,29500,20069,30867,-32037,13695,20795,26495,24863,-26105,-12568,30996,-32421,6834,-3214,11978,-24741,-29426,10985,-8392,8377,-11203,-15176,29168,1073,-1868,-3720,-4364,20842,-21783,4229,-24280,-274,6077,27534,-6681,20359,108,6536,32600,24313,10972,29408,-31819,-25132,-29770,10805,-18861,-1892,8037,24147,24873,-28117,6301,-4890,-27518,-15428,22985,-32056,18911,19620,5642,10366,-26691,-5127,-2052,-502,-24844,-13308,9990,-27173,-21680,-25738,2816,-17526,25649,-5868,15588,-4936,91,-16214,10256,-24360,25670,2476,-6964,-10046,-13186,-19843,-23169,20570,3239,17813,6221,13918,2707,1246,-26378,-9873,1303,10581,16185,-18119,30335,21035,29602,16395,-5493,30129,-7852,-32514,6517,19402,-7406,-27609,-5521,28664,-28290,3747,15625,-25666,14375,-13090,-13110,24221,-11588,-4047,23923,-13646,-28561,-6602,-16709,26394,-8103,29581,-1299,9433,32746,24371,27441,22208,-9231,-22419,30871,-28595,-7489,7933,5370,30695,12149,-2893,25028,-6266,-20830,-15064,-32532,-28792,-15133,11331,-4992,3569,14088,28746,-1338,-31744,-17527,-9423,11,-21103,9215,-21435,-298,-24617,17084,-14787,-12061,-25537,5025,-17365,12124,-1939,16044,-9191,23510,-6537,7661,-31599,-28767,2550,13141,3501,-8271,16604,12388,28504,10945,10131,30176,-24683,-9943,-4758,-30594,8488,15290,18941,-21997,21675,-7314,-383,-32148,4571,-4655,-8094,7069,-3807,6157,18258,-22003,22032,-22760,-19349,24909,22761,-13209,28309,18556,-30729,-24817,-32618,669,10697,31911,15120,13385,19896,-2963,-20353,-26167,26640,23446,15695,16592,-20617,-30098,19010,29136,24238,-3668,-26771,4410,-27383,17239,21775,-25395,-25230,-5161,3124,15053,9598,-12931,7470,22109,-15401,-27871,-3319,-21786,-14656,-13476,4258,1882,28335,-13999,9170,-139,-20110,18299,-30966,-8028,-8901,29234,21491,-28402,-30687,-5505,-4512,9679,17405,29310,-9817,-32373,-10035,24972,26275,15304,-32524,14833,30712,29883,-10411,4567,25700,-10114,6358,30187,28943,24863,15281,-18988,-10212,-25782,4214,-7222,-19233,-23546,-12042,-23862,-12788,-3143,8568,10694,17287,-2489,-8984,-2483,-23489,4409,27454,32317,-23296,489,-21929,-17698,27443,20682,-14487,20491,23745,32362,-24679,-14212,-17650,15724,27368,32757,20277,31420,-16660,5361,-10442,-2058,14972,11869,-8413,19102,29482,6233,8188,-7195,-12604,-23553,-24213,13782,-18207,-4682,15165,12095,-25100,-13777,-30172,14128,-25753,-19913,-28588,-22688,-19468,-27280,12224,-14941,15125,6452,10803,12616,-14368,31513,5040,-8452,-30816,-10587,-31715,30802,-30301,-11454,5843,-9174,-9387,-10498,-23102,-9095,-30357,-1740,-8674,10356,-31095,-30911,23583,-14019,17725,16100,-25906,19149,-5056,-12120,-9372,-4882,-9995,31777,26083,-18530,19781,24687,-22714,-1400,-32570,8104,-5679,-26041,10495,2952,-4222,1304,-18767,11703,-27352,22816,7278,-23737,10175,25540,29422,12395,-791,-5489,-22352,-6147,24982,-30472,101,25763,18910,20895,-5954,9821,-9790,22715,-5383,14665,-13656,-23927,17643,-9810,9699,-26011,6308,-4412,-14073,-24919,20273,29045,-18134,-15128,-27673,-5992,25721,-21149,-17691,-19663,-31495,-14148,1270,-3619,23781,8381,11385,15364,-4572,-303,-22516,10816,-22420,-12404,6147,4925,29607,19287,-29633,32436,-12045,12351,-20950,21818,-16350,26260,25347,25113,-31963,16299,-31985,-18854,31152,-3614,5266,23940,19565,-17388,-6775,13074,13569,-32146,-15976,-2983,-26506,31520,-7740,-3278,24702,24228,8331,-2006,-21975,-385,21666,25511,-6380,-19444,25354,5589,-12226,475,1126,-5975,31873,-10062,7320,-7962,24191,-8112,10261,-9070,-12959,20068,-5040,18403,26378,29003,-31536,5696,12275,-16497,-44,10930,23320,-6780,-17134,8183,-26283,-1587,-18028,-3875,29532,-6648,-25008,6988,-26970,-24327,-617,-19975,-29189,-4634,-12509,-24644,-11991,-11235,30888,-14654,-24913,-5120,-8326,-30317,-19356,-28335,10657,-13744,-30254,665,-16200,7292,14354,14285,18558,950,-7725,12486,-1184,-24806,-3862,4572,-17744,134,-19319,27789,-852,-15714,-10465,32260,-32699,27121,-805,-8339,17751,23480,-5891,-15827,13099,-1285,-6623,-18589,-951,-15712,4437,21250,22754,7434,15199,10328,-31560,-7193,-28104,22037,31078,1997,3276,-3268,-22051,17731,-2992,11232,536,21364,-105,-7331,388,12456,24120,-13162,-8126,18390,-32454,15558,25598,-25383,-8821,22640,-10483,8922,-15136,25822,-29936,15492,-7290,-4997,-20865,13317,-28276,10994,-20720,22419,24478,8069,25243,-30822,-29829,32519,-23061,-18234,10759,-2888,-13537,-15720,-15259,29276,29997,26238,30013,26597,15490,28258,-31512,-3741,-14694,15454,25799,-11511,-15630,-15176,3614,2213,-25179,-80,-32365,-24510,-18265,-30966,-3156,-18146,-4676,-7575,12687,-1808,2637,6102,-10778,17151,-14196,29264,-31167,19309,4166,-13608,29142,27635,-24785,-21785,8425,-1214,-17816,10057,-27176,4068,25032,-8950,-28151,17868,-582,-27561,-19072,-28849,-19614,25049,-6416,30292,12564,-32224,-434,-7493,20710,-23011,20087,17315,25117,-10906,-16937,5588,1511,3052,29593,-9745,2631,25,-24069,-18399,23611,8649,15008,2662,-96,16416,27298,-27574,-22346,-8309,-17930,-17439,-14091,-18485,13464,8335,-18653,-17942,-10293,13297,10164,-29748,-16952,-2824,-899,-24322,-1605,20258,-8775,-16305,12674,-13145,-25082,3249,4918,-21933,-32107,28487,20399,-27391,-736,-559,-7813,-24810,18372,13626,-31056,-4393,-10155,-6165,18735,18779,-13635,22484,-6118,18198,8149,25973,1737,-11757,1400,28327,-8802,30977,-6397,895,-16601,-10614,-22541,459,-26665,-10596,11648,-2707,-3261,-19743,2666,17955,26972,19581,-16205,-18450,-30383,-26885,-24589,-13034,26884,31694,4016,17022,-29589,-2776,25299,-21672,24506,-17503,-14885,-8917,29153,8156,29544,13567,-14164,-30963,-15336,-17435,-15559,11489,-17837,-13199,-21815,6872,-26339,26428,-29569,-32159,27917,31364,-31686,-14847,-1363,1066,-31367,-260,26278,26185,13419,1166,-20518,-29452,-4463},
  {-29944,28289,-18072,-12988,31141,16872,18236,26618,-19218,5417,32484,14000,25031,23001,-16113,-16546,7009,10209,24768,21597,-19131,9474,-19854,-26133,-1159,-672,-22747,14468,27059,-5401,-3900,-15742,-10936,-3056,-21194,5354,7887,24989,24118,-9867,2449,18811,-32471,-6300,14454,-27191,29150,17284,-17188,5009,1577,14733,-10438,8783,6809,-23173,25165,12960,-27380,-7319,14695,-7173,6663,-24448,-12277,-10116,-27609,-26842,-18896,10713,-26312,-23054,22536,11829,30396,12169,-28073,-14594,-15986,-18354,16961,-23988,3560,808,-23005,-2886,-13287,-13338,-9625,10949,22563,-16699,31089,-26922,-25674,-22914,-22936,3205,22923,-22655,13707,-10791,5032,-17078,18343,32414,28800,-10030,-29690,-15783,-5062,-31008,-16759,19632,14983,19930,28164,-28269,-17814,-28608,4813,-9890,-27255,3159,-26111,-324,25746,-18440,7388,-7708,25853,11601,19739,8728,-19638,29456,-15243,-14769,-9270,1552,28605,32322,6263,-27566,15056,-15232,17872,-28659,3181,-15912,15538,-1432,1876,16241,20790,32130,31134,-4500,24555,29911,-3691,-5530,6708,-3149,-25131,26630,6989,-12657,-16545,28114,17526,17355,-7991,-2217,-1299,-14495,-27625,16530,25779,-30375,31114,-20529,16384,-16464,-10757,243,-12685,-8963,-1981,30359,-28421,9053,-23657,15222,8138,21885,-23072,16546,-20828,-24604,-17867,19049,22886,20972,-22255,-8747,-846,-14402,31441,12594,12603,14586,-13450,24934,-22449,5867,-10921,6805,30157,-648,-23795,-16167,8506,-24676,7886,-5032,25689,11636,21707,16496,-12508,-21959,22138,20205,25975,14803,-14375,-32616,-4810,-2502,-435,-16420,-16489,-9778,-29239,17534,12070,19044,32739,9839,23726,20074,12608,-25699,-5834,3142,21912,21914,-11135,22306,-29506,11740,23040,980,-7683,-1437,-18063,2189,28256,23309,12275,-30914,-17297,14423,-30733,-16240,-24520,-20570,32685,-4264,5573,28940,-10835,-32249,21535,-13010,24447,24069,-23840,-4,-27955,-7561,-20787,5580,-31284,16541,-32745,24566,-21761,-16737,1950,-23612,16255,-2244,12835,17973,15304,28380,-22880,20440,21878,-25927,-14671,-18523,-23149,-27107,13848,29344,24753,11088,13057,10516,-15331,323,-16840,-23215,-9932,-9305,21283,15925,-11960,14014,7766,-27120,2556,-553,1378,3029,-6647,32757,5109,8233,-20573,-11195,12378,5322,24441,3214,-12517,13340,-1385,26075,-19910,20823,15041,-28211,7079,28019,14358,-1113,-23848,29258,-24424,19599,5192,-225,12446,20385,-23692,-16734,18108,-25414,930,10896,8907,15263,-25884,11309,16384,16439,5974,-25965,-13121,-25369,8668,17918,-31133,4537,-878,-4252,22006,-25325,-8674,-28931,16574,21701,-23022,22769,-29746,14305,-2671,9538,-17556,-29146,-32270,24911,-21398,4260,-19347,-15070,-17399,-9835,32127,19735,7388,27384,4593,1179,15175,-3682,1542,25426,2746,-25395,18021,5705,4430,26473,-31900,-15218,-15877,-19697,-32171,13595,-19171,14666,-23329,-16744,-27211,11060,17129,11184,30261,25843,-12941,1167,6482,-11334,29159,11167,-2711,-32339,-8891,-1420,27953,8980,27031,-17243,8564,19709,-13195,23686,20336,-29069,-11293,-29846,-15038,28271,6121,17540,7530,20924,1185,-20028,6517,9668,-32211,23144,-30525,12078,-8592,-17747,-11969,-32762,-25518,4943,25152,-25754,-13308,14199,7210,-30915,12228,28758,4952,-3138,-5689,-1708,-20508,-13192,8084,-9419,-22914,-16101,-12515,-19601,-24900,-2812,-16507,26641,-32136,17660,-25674,-32318,2692,-16372,4321,-29086,22616,-21734,24437,-5042,317,-10034,-4531,12835,16356,-5078,14409,-6460,-12797,5800,14974,17935,7656,-19369,-24028,421,25371,25781,-2266,-14931,8047,-4805,-30828,14847,-2097,-246,-28244,16261,6078,-3527,-14317,-1523,-20522,18071,-5193,28916,22178,20971,28202,-4199,-3144,-20921,-18445,458,12690,-17527,-658,31046,-3478,-17628,-2554,-31865,27828,79,26320,22309,-32112,-22231,-12238,74,-13757,-18461,24983,31206,4656,-31073,-16501,-21752,-29121,-10112,17780,2555,2106,4427,377,-26566,-32231,-29963,-22798,-22697,-5856,-11099,-6670,24220,5832,6737,-2028,31297,-23626,19485,-4976,24969,8340,-11356,-27528,-8213,-21066,-2716,-31583,-15198,14738,27190,9249,31586,7115,-13251,26296,-26805,13635,30400,-32496,4512,-4358,13479,-3367,-27438,29122,1053,-13415,30509,-14113,14657,-17597,-10075,6779,-7618,12218,-24302,24159,-25157,-6644,-24662,26003,3195,32747,6319,5151,-24321,-27360,-31875,1112,31095,25887,13549,16012,-25091,-8861,-2970,-5406,-22403,20806,-15086,-31151,18215,17460,-16818,17581,-16168,-5797,21914,-29315,-30062,-11860,6485,-16089,18865,-22170,-1828,24519,-5235,11094,11374,18650,-13932,-831,4562,26724,1723,19477,1641,-18118,-21368,7382,9113,-18474,-24158,-6829,16522,-17460,-26820,-12850,-11114,21296,11293,15878,31597,25189,-8365,-12393,16510,21811,30448,-6648,3151,-8240,-30919,-8633,-21661,-9004,-918,-6886,-11872,-27979,-5397,24450,-869,-9650,-8454,-3885,3980,1418,28107,13400,-13255,-7410,8418,27576,21880,-275,-17175,19183,-22367,-25928,-4949,-10286,-6081,-12994,-24406,13616,10895,13247,-26352,16478,-2702,104,3977,-14961,-20616,3361,25079,23748,7533,16788,-30383,-950,-5661,17481,-28008,29492,-7087,12714,-5929,14658,7633,-13098,-3331,9041,-3201,23392,-22840,-10638,-13486,-21806,28914,14528,-26247,-17891,-17172,8193,15481,4571,16850,-14421,23870,12375,23098,-17157,24657,-29377,15396,-23888,-6157,-32669,-13482,-12077,-29248,-20939,-6255,-8320,-1403,8656,-21187,-15572,16705,-1691,8059,29255,-6775,22065,12718,-4617,-23841,24577,24144,19144,26087,-30146,31337,-31766,24104,13599,26214,8550,-11362,15845,-8983,-1822,8002,13062,-2707,25323,25749,-5113,16563,-23277,517,-3923,30180,-17727,-3160,-4883,15166,16362,23194,20912,21204,-15331,-7539,22903,-2876,-13727,-24864,17037,22409,-13624,-16853,16779,-18837,15624,27889,12048,32420,20214,-24044,5412,-16979,15204,17357,28353,10883,13076,-8764,17068,-26277,-269,-21010,5937,15579,-3049,1730,-26420,-22247,-11487,-23971,19006,-7286,489,-8203,19751,11729,3054,24833,8131,2939,-16028,32263,-11023,4266,-30643,19568,-21020,6932,15274,-25843,4567,-2567,28058,-1113,11861,2914,12546,-17501,-6780,-5144,2481,28754,-4937,17162,-5613,-18002,-22799,-18295,-6450,-3165,28275,-25345,21846,-22813,-10015,8847,-16231},
  {-8313,28684,28707,-17791,-9800,-11597,-28344,9956,9884,3066,3522,7457,-23293,15901,-1511,-5335,-29778,-31362,-16228,-17513,28317,25347,24063,7953,-21505,10648,-10364,26834,9057,-2254,-10591,6457,28682,-10760,-22247,22668,-25224,18419,-29049,16334,-11830,23847,7917,26503,25955,-22760,-2795,-4681,23902,-28913,8290,19591,30227,18506,17978,-30589,5025,-14066,31991,-25742,28804,3985,26306,30593,28295,32602,21277,7216,-13771,25224,-24283,-31481,-27046,-32044,-18389,-14969,3153,-81,30619,423,7362,30879,25692,7273,-8060,21768,-10771,-29879,20143,17921,2894,-3810,-17767,22133,-10401,-18613,25159,24975,13584,-19727,24646,-7990,19906,26828,22951,28725,-21453,29209,3365,32377,7754,647,-15532,-28236,-4214,7691,-6824,-31984,-19577,17314,-30812,22791,-28460,-4381,-11704,11123,2870,-13779,-13381,-20481,29199,17744,-15476,-9041,-3085,31315,-2341,13662,22942,-8264,-18237,24784,11482,-13643,4465,-25838,10345,-26752,31246,-7562,-4354,16802,8578,-1154,29521,-28700,-11445,-9746,3166,-24306,3369,28732,-28206,-10682,30244,-31246,-5887,8324,19752,15523,-19328,-18153,22336,-4606,2889,31196,-3605,28591,-24322,22099,29120,-7111,-1615,-8893,3993,22614,22565,-8101,11806,23416,28134,4726,23122,3109,-30752,17313,-11952,-25318,-2115,8586,-26598,-21647,6743,28618,-4593,16499,5850,23315,-21207,-4132,23038,-1567,-21507,-19057,17941,-24083,-400,-27516,-10762,-20348,6849,-1265,18651,-2945,19532,28240,-13214,-17215,-2973,4363,-13281,368,-13693,-32563,16731,-28579,-32597,-11171,-7075,7146,-2195,-10133,-4557,-27628,-588,-3236,31428,22002,9892,-10295,28568,-30023,-22355,8588,-8518,28586,6456,-14609,29700,-27791,-7501,5122,11980,23988,13695,28077,-15124,-1140,29115,-16314,-28870,20339,-17602,1164,-5921,-8491,13701,3851,-14764,-3357,-7032,-8097,18409,14807,-9588,21265,8841,-28817,-14537,-15693,-2965,-706,-7576,-15657,-25340,23879,-17660,6705,-28170,-3007,17965,-17181,21300,18630,-17124,-28135,25720,31583,-1110,25604,-9374,32326,26576,-22821,-10016,28077,20997,-2337,3720,7876,7807,-14212,15022,13254,17650,3561,21030,30331,-12052,-3352,26885,8561,-6576,27987,-1823,-24866,15941,27064,-18079,8501,-30396,-10638,-9770,18348,19545,-17949,11460,4912,2382,25249,-20120,10372,-7684,28695,7155,26490,29920,1318,27628,19908,24799,13603,-4215,-22497,9694,7725,422,-232,1498,-18257,-12256,-15015,20760,14184,15856,14834,22160,6432,-7662,-15559,-3274,737,31347,11535,-14802,7129,-15108,29263,-11598,-29593,-4193,-10181,-11287,-29612,25076,-32012,31688,-30655,-2978,25813,1701,27518,32285,2435,20721,9920,25376,-28882,-30647,-7204,12466,-5318,15595,-24714,-30936,20035,13429,27303,-17128,-28782,5747,2872,21035,-17087,-31367,-4523,-13965,-16028,-26592,14249,-21759,-29386,14500,8033,17819,18140,-3072,-15500,23552,-2413,1571,-16912,20852,4592,-25272,-21397,3138,-22790,-15957,-16324,31679,-13894,23996,-17770,31105,-24893,-15061,-4721,-139,3248,7639,16396,-7800,-31799,-23900,9501,4461,-13718,31949,-14917,-17435,9382,-31012,-21860,-26698,-17596,15853,3677,25829,-23308,23373,21641,-29242,-10564,-19262,-16424,-2601,-17313,5673,-15975,-14295,29582,-23285,-15911,-8735,-32376,-6161,-20161,21025,-3670,19662,8759,2126,14869,2724,21351,25287,-12438,16171,-678,32621,31281,-22869,6639,-24119,3545,24517,-116,19618,24601,-11109,13086,-31865,3856,19711,8204,25828,-18275,7635,-29333,2973,8709,-19008,24073,27544,6902,-18726,-28095,30301,-16053,17858,-284,-27434,7277,23289,8186,-32532,18388,-8837,-4208,-7364,26303,-16581,-22533,-21053,-26272,-13102,19824,-9779,-14581,-32197,2091,-22181,-21712,-15639,1193,-10198,-21916,-10019,-29064,32705,-30772,15104,7471,-8221,16357,-32088,-4463,-9067,-10729,17406,18401,13628,30471,-29909,-26264,-18144,15678,9092,501,-17792,-12580,28717,7124,-1263,28517,30299,19984,-20839,-22842,-3870,5758,-5303,20467,18165,5773,-6881,10352,-31081,4142,23721,-8261,-9517,26142,-9872,-30374,-28544,29710,-11403,-15479,6454,-14174,-6805,-20607,-17738,-24939,20942,6687,16676,9475,-12694,-5041,-31732,21690,14885,23183,1918,2380,-29906,-4645,30,26973,-1322,-4753,-27600,-23557,10814,5822,32102,-19320,-31444,-1878,-12752,22259,-10579,-15034,20135,14259,-19591,24412,-17096,19780,5242,12911,-20998,19993,29239,-22438,31758,30509,-31136,-13009,-12607,15563,13804,-4153,29772,7329,30459,-6035,-8996,-30919,-25467,-24917,22194,8852,-9330,17964,7428,15582,-12614,-5453,7589,24868,-27940,-24287,28251,21907,-9487,32037,-25777,28108,13341,12822,5184,14127,31833,-21974,-5724,-14822,-5556,-10045,19666,-21843,4034,-23919,13156,-22374,-4428,-22172,14970,-805,-2444,32240,-11483,-5254,-30937,14598,-18535,21724,-22325,-26006,-746,-23008,15120,5372,-21045,-12014,25232,-4547,-24455,26683,-24028,10946,32110,18754,-14592,13411,-30351,-9931,-8734,16409,20183,8634,-9453,-1549,28536,-30288,22959,6305,-16825,-9610,-4506,-9618,-25514,-32235,15044,-11042,-26550,16975,2586,-28602,-4338,7818,-14586,-4502,-6711,-14502,17351,-14489,84,12401,27528,-27909,-21495,16524,-15528,-2528,12255,7664,-15144,2642,-6745,-31770,12758,-6282,27783,-1284,27796,-2529,13696,-4708,-14171,14354,-29402,23508,27005,12065,3341,24803,-15541,-30942,-10143,4953,-12249,3429,-32321,23141,-13193,2369,-14439,-21155,8712,-8771,14006,-24291,-18960,17517,26139,25822,4854,-14774,-3015,1049,-21793,-1581,-9742,-29341,12238,12178,26469,-17615,20547,-13089,18245,19221,22066,23874,13082,-19357,-29916,4257,10144,-25009,8561,30884,-24954,883,10167,-32214,18620,13699,-25005,22121,-31612,-266,463,-25363,-9254,648,-32399,18151,20527,-28634,-15787,17800,-4838,-17237,-11424,-28722,7398,24224,-12398,-22575,-6614,25531,-3762,-927,28412,-13550,26250,31827,7880,-22786,-21050,-25423,18598,7842,1936,31504,5320,7572,31160,-16920,12666,-3554,8597,29297,-28884,-31280,-20483,4828,377,-26344,-16831,-2823,-27245,-4266,-13134,5181,1349,-16081,20298,12471,20041,27803,-28188,-3548,-6774,-6543,25745,-7966,-1619,-3611,-6974,-2760,14539,4315,30314,7218,-25010,-22450,-2286,-3555,19450,21924,-30465,-30704,20728,-7867,31377,28126,-31584},
  {29135,-24802,-21907,-27462,8529,11641,-23318,26056,-8730,-20507,10354,11502,31412,5479,4427,-24572,-3439,-14105,16900,28722,30664,19578,-12276,-9365,-24017,-16886,6200,17255,-23198,-9764,-10083,-2742,-23347,-1703,-20203,20775,26841,11258,9469,-3094,29551,20021,24100,-12568,-29785,7271,4332,13194,2820,26889,-1323,32295,-8716,-21490,-11782,-22115,-25326,20268,-17099,-18925,-9088,-29696,-26471,21559,9613,28698,19891,-19697,5446,32634,7212,23584,-30120,-21168,-4325,-14044,30144,-29709,5576,10237,30948,-25648,10407,17659,-6213,-16541,30759,-30778,-29021,9303,-14770,8850,241,22209,-9939,28928,-10396,-28745,-20130,-14382,4336,-29811,2647,-26211,14376,4113,24885,5875,12929,10991,17711,-31872,1712,25192,4918,19943,884,5958,-27017,25668,-29445,-21468,17906,3745,10997,1476,-14278,-11321,30443,2899,-20955,30114,24135,-10548,-28547,7860,-5091,-24727,8729,9505,-22132,-21379,-6005,-15703,-22900,-22900,-2328,-1307,-8862,4506,-14562,-30352,-2356,-17643,-25855,-12894,-9537,9933,-9392,21379,-7078,-28175,-4201,-24771,7958,17049,-30465,-10795,-4752,-11572,-8488,-6489,30485,24923,-27562,-17457,-4802,-8464,-8709,3837,11146,-30161,29569,-10880,-2341,9874,-3901,-2817,-24631,22173,-20901,6287,19915,-15800,8969,-26865,-29964,18723,-11858,-28373,-4945,-10856,-24647,7186,2703,-23471,-22215,1387,8441,19317,4099,-11539,-17105,-17159,22888,-16729,-22685,2797,20199,-31168,6523,-32302,26335,9237,-11761,28888,17140,-22084,11164,595,11394,8408,26583,-20572,-18772,-21857,6856,8883,-18199,-20730,29084,-6781,-16047,31541,14524,-12480,20418,17103,-27283,3691,-30798,54,20037,-13533,-9968,6930,-2497,24133,3768,-23360,21420,32399,-20362,-32328,16915,255,-15499,24262,11767,5272,6885,-27341,17217,-29146,-7465,-526,21538,21561,-21202,-32400,4781,-19985,-10409,29284,17776,-2685,-5821,28985,8406,30073,-578,26420,1242,-2864,-28747,31741,22676,-5464,-12702,-32406,-32621,-2597,-5778,-3885,16154,1724,-14662,-9422,-1926,3525,12030,15618,-30168,-6817,-21378,3929,-20044,17543,1188,-9935,30748,-26550,11720,2604,-3275,-23182,17474,10846,-1098,6096,-16030,14802,26761,971,11439,-2072,4170,28027,8178,-6135,-18412,28351,-11419,-1872,27646,28876,-4616,-32442,-8872,22854,22640,7699,22298,6689,-24817,-31719,-19561,21355,-22871,10027,-19603,-6073,4398,-19306,30572,-16779,18378,-11764,-30655,15941,12995,-10419,30288,27969,20672,-32662,-11733,20066,-23045,28016,-25865,-18336,-4092,-13460,-17568,-12204,11223,-14981,-26820,31673,-13951,-16169,15882,-21139,-25782,29834,-22695,-15650,30979,-17709,12576,-2171,29294,13410,-190,-15805,23922,-24155,-13751,29871,27973,-18842,5979,12988,-29825,-25381,-12098,27918,7081,12437,30226,-7013,-9057,-16749,4085,28193,-16880,17159,-3320,-7785,-19576,2312,3076,4560,17257,-30896,28871,10761,-756,3803,23111,-27819,-26302,3481,25886,-16290,-28291,7864,13678,-22767,13240,8388,-3322,-32730,-18584,-17667,20472,-20047,-21526,-2815,-6783,-4527,-10537,1342,-15461,25538,4323,-869,22689,-8719,677,27215,3275,-25776,-6586,-4498,24406,-1614,-28782,10535,16521,-28421,24606,17617,18145,-15329,3794,6160,26629,-14026,-11874,-29584,6399,24552,2418,-5430,28766,-30820,23504,-1080,28299,17538,-17159,19795,-30166,-7632,11169,11702,-5963,1575,29766,6004,18352,-1756,-12383,-14161,-13939,-3644,-23518,27506,-17790,24894,2326,-13130,29374,-21240,32651,-20327,30858,-8617,-4768,15012,24670,-3152,13673,-3368,17728,31618,12982,-13640,29123,-22520,-32466,-2108,-15881,21011,1699,-15341,1454,14337,24018,5481,6240,17021,24026,14285,-8986,11665,-29436,-14299,14189,27888,12659,17369,22592,-24058,-3082,27473,-4447,22209,19842,-16907,21536,6601,-26560,-4101,20439,7212,24115,-22232,24117,17631,-22454,-8824,-13010,30568,-21497,284,-21658,13404,28520,13816,3287,2315,-15113,-7806,23345,28945,11590,21096,-30435,-21330,-84,1071,-27198,-25023,-3034,2814,-18096,12849,-11653,20953,24362,-30948,24607,-28214,-18437,24995,7129,26011,-31712,-23893,1602,-25993,-32238,14163,-2299,-28079,-16030,26012,-9326,-7838,-3090,20998,9648,10032,-7861,21974,488,964,17388,1833,-20271,4259,-1802,-20918,-20149,16045,-4924,-3415,-18237,-39,10181,-30875,23872,-31696,-1213,-8051,1170,-57,-3666,-6115,8913,-18878,942,-26468,28651,-3305,-17252,-30338,-3161,-22678,7087,-8916,-5846,17475,32488,7416,8432,23923,-11137,-4405,-26690,-19625,10324,26003,-387,-25106,-9358,-20323,-15916,-10829,-8140,-14979,28075,10955,-17660,-29279,8043,1546,3898,2001,1075,4891,-17742,-31697,31429,-2441,6648,530,15991,18729,22277,15107,15346,12704,2036,18241,16281,-31765,-26082,4173,-20646,7627,30821,14737,-16331,-14725,-3382,6052,28335,-14793,-29809,-5933,-10620,-8025,-12119,-737,-13459,15134,-12401,-8561,-26870,2495,-10791,-14833,19382,28335,-10571,25788,-2081,-3128,-1143,5868,8247,-8435,-9206,16922,21675,-1650,32001,2312,-14384,-29453,6489,4949,4969,-11896,-15264,-15059,-25521,-4789,-12161,30553,1046,-29190,21271,28468,-15143,-23484,13905,8590,28973,12924,-20684,-11614,28351,-5750,13453,-2210,-17905,-12484,-13788,-26746,4643,-9649,260,-1223,9553,-12383,-22556,16017,-6262,-18104,11265,6527,24650,25813,27354,-10869,15225,-6871,32295,-11126,-17546,28846,-23877,12898,13036,29824,-8303,-22318,25393,-17189,-32332,18961,22444,-26229,23849,-30791,2540,-22534,-16049,-15842,24636,-7318,-11834,-26085,-7951,-17452,25912,-2351,25274,5529,19195,5532,22134,26473,-25562,27666,-3182,-12656,3574,-26375,28300,-20861,-14673,-30356,-25905,1503,-22259,-5144,9813,555,4630,-16769,15219,-29560,-23508,-12219,30407,3167,16038,26460,-14398,-17467,7682,-23,-28999,6862,-28915,-17356,-5739,17698,26156,10987,2855,-20643,25661,32527,-26951,28199,-13688,-30251,-6854,-16212,-4821,-15596,9845,22526,-6738,4698,-18610,11372,5288,10739,18448,30635,18222,836,265,-6863,15811,13815,853,18366,22194,-13945,2668,9151,6342,-30949,26651,-14142,-22493,21226,29702,-10126,13682,-3392,-6465,-22846,25583,-857,-12259,20537,9897,14731,-30687,11186,5695,-19943,28975,-15362,-30735,27975,22277,-24498,-21623,-21453,-20375,-24931,-13145},
} ;

static void test_encode_953xfreeze3_impl(long long impl)
{
  unsigned char *s = test_encode_953xfreeze3_s;
  unsigned char *x = test_encode_953xfreeze3_x;
  unsigned char *s2 = test_encode_953xfreeze3_s2;
  unsigned char *x2 = test_encode_953xfreeze3_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_953xfreeze3_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_953xfreeze3(impl);
    printf("encode_953xfreeze3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_953xfreeze3_implementation(impl),ntruprime_dispatch_encode_953xfreeze3_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_953xfreeze3;
    printf("encode_953xfreeze3 selected implementation %s compiler %s\n",ntruprime_encode_953xfreeze3_implementation(),ntruprime_encode_953xfreeze3_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_953xfreeze3_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_953xfreeze3_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_953xfreeze3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_953xfreeze3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_953xfreeze3_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_953xfreeze3_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_953xfreeze3(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"953xfreeze3")) return;
  storage_encode_953xfreeze3_s = callocplus(crypto_encode_STRBYTES);
  test_encode_953xfreeze3_s = aligned(storage_encode_953xfreeze3_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_953xfreeze3_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_953xfreeze3_x = aligned(storage_encode_953xfreeze3_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_953xfreeze3_s2 = callocplus(maxalloc);
  test_encode_953xfreeze3_s2 = aligned(storage_encode_953xfreeze3_s2,crypto_encode_STRBYTES);
  storage_encode_953xfreeze3_x2 = callocplus(maxalloc);
  test_encode_953xfreeze3_x2 = aligned(storage_encode_953xfreeze3_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_953xfreeze3 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_953xfreeze3();++impl)
      forked(test_encode_953xfreeze3_impl,impl);
    ++test_encode_953xfreeze3_s;
    ++test_encode_953xfreeze3_x;
    ++test_encode_953xfreeze3_s2;
    ++test_encode_953xfreeze3_x2;
  }
  free(storage_encode_953xfreeze3_x2);
  free(storage_encode_953xfreeze3_s2);
  free(storage_encode_953xfreeze3_x);
  free(storage_encode_953xfreeze3_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

