/*
    libmaus2
    Copyright (C) 2019 German Tischler-Höhle

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <libmaus2/protein/Blosum62.hpp>
#include <cassert>

static int64_t const blosum62[24][24] = {
{4,-1,-2,-2,0,-1,-1,0,-2,-1,-1,-1,-1,-2,-1,1,0,-3,-2,0,-2,-1,0,-4},
{-1,5,0,-2,-3,1,0,-2,0,-3,-2,2,-1,-3,-2,-1,-1,-3,-2,-3,-1,0,-1,-4},
{-2,0,6,1,-3,0,0,0,1,-3,-3,0,-2,-3,-2,1,0,-4,-2,-3,3,0,-1,-4},
{-2,-2,1,6,-3,0,2,-1,-1,-3,-4,-1,-3,-3,-1,0,-1,-4,-3,-3,4,1,-1,-4},
{0,-3,-3,-3,9,-3,-4,-3,-3,-1,-1,-3,-1,-2,-3,-1,-1,-2,-2,-1,-3,-3,-2,-4},
{-1,1,0,0,-3,5,2,-2,0,-3,-2,1,0,-3,-1,0,-1,-2,-1,-2,0,3,-1,-4},
{-1,0,0,2,-4,2,5,-2,0,-3,-3,1,-2,-3,-1,0,-1,-3,-2,-2,1,4,-1,-4},
{0,-2,0,-1,-3,-2,-2,6,-2,-4,-4,-2,-3,-3,-2,0,-2,-2,-3,-3,-1,-2,-1,-4},
{-2,0,1,-1,-3,0,0,-2,8,-3,-3,-1,-2,-1,-2,-1,-2,-2,2,-3,0,0,-1,-4},
{-1,-3,-3,-3,-1,-3,-3,-4,-3,4,2,-3,1,0,-3,-2,-1,-3,-1,3,-3,-3,-1,-4},
{-1,-2,-3,-4,-1,-2,-3,-4,-3,2,4,-2,2,0,-3,-2,-1,-2,-1,1,-4,-3,-1,-4},
{-1,2,0,-1,-3,1,1,-2,-1,-3,-2,5,-1,-3,-1,0,-1,-3,-2,-2,0,1,-1,-4},
{-1,-1,-2,-3,-1,0,-2,-3,-2,1,2,-1,5,0,-2,-1,-1,-1,-1,1,-3,-1,-1,-4},
{-2,-3,-3,-3,-2,-3,-3,-3,-1,0,0,-3,0,6,-4,-2,-2,1,3,-1,-3,-3,-1,-4},
{-1,-2,-2,-1,-3,-1,-1,-2,-2,-3,-3,-1,-2,-4,7,-1,-1,-4,-3,-2,-2,-1,-2,-4},
{1,-1,1,0,-1,0,0,0,-1,-2,-2,0,-1,-2,-1,4,1,-3,-2,-2,0,0,0,-4},
{0,-1,0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1,1,5,-2,-2,0,-1,-1,0,-4},
{-3,-3,-4,-4,-2,-2,-3,-2,-2,-3,-2,-3,-1,1,-4,-3,-2,11,2,-3,-4,-3,-2,-4},
{-2,-2,-2,-3,-2,-1,-2,-3,2,-1,-1,-2,-1,3,-3,-2,-2,2,7,-1,-3,-2,-1,-4},
{0,-3,-3,-3,-1,-2,-2,-3,-3,3,1,-2,1,-1,-2,-2,0,-3,-1,4,-3,-2,-1,-4},
{-2,-1,3,4,-3,0,1,-1,0,-3,-4,0,-3,-3,-2,0,-1,-4,-3,-3,4,1,-1,-4},
{-1,0,0,1,-3,3,4,-2,0,-3,-3,1,-1,-3,-1,0,-1,-3,-2,-2,1,4,-1,-4},
{0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,0,0,-2,-1,-1,-1,-1,-1,-4},
{-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,1}
};
static int64_t const blosum62Map[256] = {
	22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,
	22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,
	22,22,23,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,
	22,22,22,22,22,0,20,4,3,6,13,7,8,9,22,11,10,12,2,22,14,5,1,
	15,16,22,19,17,22,18,21,22,22,22,22,22,22,22,22,22,22,22,22,
	22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,
	22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,
	22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,
	22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,
	22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,
	22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,
	22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,
	22,22,22,22,22,22,22,22,22,22,22,22,22
};

int64_t libmaus2::protein::Blosum62::getMaxScore()
{
	int64_t score = blosum62[0][0];

	for ( uint64_t i = 0; i < 24; ++i )
		for ( uint64_t j = 0; j < 24; ++j )
			if ( blosum62[i][j] > score )
				score = blosum62[i][j];

	return score;
}

int64_t libmaus2::protein::Blosum62::getScore(int64_t const syma, int64_t const symb)
{
	assert ( syma >= 0 && syma < 256 );
	assert ( symb >= 0 && symb < 256 );
	return blosum62[blosum62Map[syma]][blosum62Map[symb]];
}
