{-# OPTIONS_GHC -F -pgmF tasty-discover -optF --in-place #-}
-- GENERATED BY tasty-discover
{-# LANGUAGE FlexibleInstances #-}

module Main (main, ingredients, tests) where

import Prelude
import qualified ConfigTest
import qualified DiscoverTest
import qualified SubMod.FooBaz
import qualified SubMod.PropTest
import qualified SubMod.SubSubMod.PropTest
import qualified System.Environment as E
import qualified Test.Tasty as T
import qualified Test.Tasty.Discover as TD
import qualified Test.Tasty.HUnit as HU
import qualified Test.Tasty.Hedgehog as H
import qualified Test.Tasty.Hspec as HS
import qualified Test.Tasty.Ingredients as T
import qualified Test.Tasty.QuickCheck as QC
import qualified Test.Tasty.SmallCheck as SC

{- HLINT ignore "Use let" -}






class TestGroup a where testGroup :: String -> a -> IO T.TestTree
instance TestGroup T.TestTree        where testGroup _ a = pure a
instance TestGroup [T.TestTree]      where testGroup n a = pure $ T.testGroup n a
instance TestGroup (IO T.TestTree)   where testGroup _ a = a
instance TestGroup (IO [T.TestTree]) where testGroup n a = T.testGroup n <$> a

class TestCase a where testCase :: String -> a -> IO T.TestTree
instance TestCase (IO ())                      where testCase n = pure . HU.testCase      n
instance TestCase (IO String)                  where testCase n = pure . HU.testCaseInfo  n
instance TestCase ((String -> IO ()) -> IO ()) where testCase n = pure . HU.testCaseSteps n

tests :: IO T.TestTree
tests = do
  t0 <- HS.testSpec "modules" ConfigTest.spec_modules

  t1 <- HS.testSpec "ignores" ConfigTest.spec_ignores

  t2 <- HS.testSpec "badModuleGlob" ConfigTest.spec_badModuleGlob

  t3 <- HS.testSpec "customModuleName" ConfigTest.spec_customModuleName

  t4 <- testCase "noTreeDisplayDefault" ConfigTest.unit_noTreeDisplayDefault

  t5 <- testCase "treeDisplay" ConfigTest.unit_treeDisplay

  t6 <- pure $ QC.testProperty "mkModuleTree" ConfigTest.prop_mkModuleTree

  t7 <- testCase "listCompare" DiscoverTest.unit_listCompare

  t8 <- pure $ QC.testProperty "additionCommutative" DiscoverTest.prop_additionCommutative

  t9 <- pure $ SC.testProperty "sortReverse" DiscoverTest.scprop_sortReverse

  t10 <- HS.testSpec "prelude" DiscoverTest.spec_prelude

  t11 <- testGroup "addition" DiscoverTest.test_addition

  t12 <- testGroup "multiplication" DiscoverTest.test_multiplication

  t13 <- testGroup "generateTree" DiscoverTest.test_generateTree

  t14 <- testGroup "generateTrees" DiscoverTest.test_generateTrees

  t15 <- TD.tasty (TD.description "reverse" <> TD.name "DiscoverTest.tasty_reverse") DiscoverTest.tasty_reverse

  t16 <- pure $ H.testProperty "reverse" DiscoverTest.hprop_reverse

  t17 <- pure $ QC.testProperty "additionCommutative" SubMod.FooBaz.prop_additionCommutative

  t18 <- pure $ QC.testProperty "multiplationDistributiveOverAddition" SubMod.FooBaz.prop_multiplationDistributiveOverAddition

  t19 <- pure $ QC.testProperty "additionAssociative" SubMod.PropTest.prop_additionAssociative

  t20 <- pure $ QC.testProperty "additionCommutative" SubMod.SubSubMod.PropTest.prop_additionCommutative

  pure $ T.testGroup "test/Driver.hs" [t0,t1,t2,t3,t4,t5,t6,t7,t8,t9,t10,t11,t12,t13,t14,t15,t16,t17,t18,t19,t20]
ingredients :: [T.Ingredient]
ingredients = T.defaultIngredients
main :: IO ()
main = do
  args <- E.getArgs
  E.withArgs ([] ++ args) $    tests >>= T.defaultMainWithIngredients ingredients

