// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/cloudcontrolspartner/v1/violations.proto

package cloudcontrolspartnerpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	interval "google.golang.org/genproto/googleapis/type/interval"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Violation State Values
type Violation_State int32

const (
	// Unspecified state.
	Violation_STATE_UNSPECIFIED Violation_State = 0
	// Violation is resolved.
	Violation_RESOLVED Violation_State = 1
	// Violation is Unresolved
	Violation_UNRESOLVED Violation_State = 2
	// Violation is Exception
	Violation_EXCEPTION Violation_State = 3
)

// Enum value maps for Violation_State.
var (
	Violation_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RESOLVED",
		2: "UNRESOLVED",
		3: "EXCEPTION",
	}
	Violation_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RESOLVED":          1,
		"UNRESOLVED":        2,
		"EXCEPTION":         3,
	}
)

func (x Violation_State) Enum() *Violation_State {
	p := new(Violation_State)
	*p = x
	return p
}

func (x Violation_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Violation_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_cloudcontrolspartner_v1_violations_proto_enumTypes[0].Descriptor()
}

func (Violation_State) Type() protoreflect.EnumType {
	return &file_google_cloud_cloudcontrolspartner_v1_violations_proto_enumTypes[0]
}

func (x Violation_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Violation_State.Descriptor instead.
func (Violation_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDescGZIP(), []int{0, 0}
}

// Classifying remediation into various types based on the kind of
// violation. For example, violations caused due to changes in boolean org
// policy requires different remediation instructions compared to violation
// caused due to changes in allowed values of list org policy.
type Violation_Remediation_RemediationType int32

const (
	// Unspecified remediation type
	Violation_Remediation_REMEDIATION_TYPE_UNSPECIFIED Violation_Remediation_RemediationType = 0
	// Remediation type for boolean org policy
	Violation_Remediation_REMEDIATION_BOOLEAN_ORG_POLICY_VIOLATION Violation_Remediation_RemediationType = 1
	// Remediation type for list org policy which have allowed values in the
	// monitoring rule
	Violation_Remediation_REMEDIATION_LIST_ALLOWED_VALUES_ORG_POLICY_VIOLATION Violation_Remediation_RemediationType = 2
	// Remediation type for list org policy which have denied values in the
	// monitoring rule
	Violation_Remediation_REMEDIATION_LIST_DENIED_VALUES_ORG_POLICY_VIOLATION Violation_Remediation_RemediationType = 3
	// Remediation type for gcp.restrictCmekCryptoKeyProjects
	Violation_Remediation_REMEDIATION_RESTRICT_CMEK_CRYPTO_KEY_PROJECTS_ORG_POLICY_VIOLATION Violation_Remediation_RemediationType = 4
	// Remediation type for resource violation.
	Violation_Remediation_REMEDIATION_RESOURCE_VIOLATION Violation_Remediation_RemediationType = 5
)

// Enum value maps for Violation_Remediation_RemediationType.
var (
	Violation_Remediation_RemediationType_name = map[int32]string{
		0: "REMEDIATION_TYPE_UNSPECIFIED",
		1: "REMEDIATION_BOOLEAN_ORG_POLICY_VIOLATION",
		2: "REMEDIATION_LIST_ALLOWED_VALUES_ORG_POLICY_VIOLATION",
		3: "REMEDIATION_LIST_DENIED_VALUES_ORG_POLICY_VIOLATION",
		4: "REMEDIATION_RESTRICT_CMEK_CRYPTO_KEY_PROJECTS_ORG_POLICY_VIOLATION",
		5: "REMEDIATION_RESOURCE_VIOLATION",
	}
	Violation_Remediation_RemediationType_value = map[string]int32{
		"REMEDIATION_TYPE_UNSPECIFIED":                                       0,
		"REMEDIATION_BOOLEAN_ORG_POLICY_VIOLATION":                           1,
		"REMEDIATION_LIST_ALLOWED_VALUES_ORG_POLICY_VIOLATION":               2,
		"REMEDIATION_LIST_DENIED_VALUES_ORG_POLICY_VIOLATION":                3,
		"REMEDIATION_RESTRICT_CMEK_CRYPTO_KEY_PROJECTS_ORG_POLICY_VIOLATION": 4,
		"REMEDIATION_RESOURCE_VIOLATION":                                     5,
	}
)

func (x Violation_Remediation_RemediationType) Enum() *Violation_Remediation_RemediationType {
	p := new(Violation_Remediation_RemediationType)
	*p = x
	return p
}

func (x Violation_Remediation_RemediationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Violation_Remediation_RemediationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_cloudcontrolspartner_v1_violations_proto_enumTypes[1].Descriptor()
}

func (Violation_Remediation_RemediationType) Type() protoreflect.EnumType {
	return &file_google_cloud_cloudcontrolspartner_v1_violations_proto_enumTypes[1]
}

func (x Violation_Remediation_RemediationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Violation_Remediation_RemediationType.Descriptor instead.
func (Violation_Remediation_RemediationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDescGZIP(), []int{0, 0, 0}
}

// Details of resource Violation
type Violation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Format:
	// `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}/violations/{violation}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Description for the Violation.
	// e.g. OrgPolicy gcp.resourceLocations has non compliant value.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Time of the event which triggered the Violation.
	BeginTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=begin_time,json=beginTime,proto3" json:"begin_time,omitempty"`
	// Output only. The last time when the Violation record was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Time of the event which fixed the Violation.
	// If the violation is ACTIVE this will be empty.
	ResolveTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=resolve_time,json=resolveTime,proto3" json:"resolve_time,omitempty"`
	// Output only. Category under which this violation is mapped.
	// e.g. Location, Service Usage, Access, Encryption, etc.
	Category string `protobuf:"bytes,6,opt,name=category,proto3" json:"category,omitempty"`
	// Output only. State of the violation
	State Violation_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.cloudcontrolspartner.v1.Violation_State" json:"state,omitempty"`
	// Output only. Immutable. Name of the OrgPolicy which was modified with
	// non-compliant change and resulted this violation. Format:
	//
	//	`projects/{project_number}/policies/{constraint_name}`
	//	`folders/{folder_id}/policies/{constraint_name}`
	//	`organizations/{organization_id}/policies/{constraint_name}`
	NonCompliantOrgPolicy string `protobuf:"bytes,8,opt,name=non_compliant_org_policy,json=nonCompliantOrgPolicy,proto3" json:"non_compliant_org_policy,omitempty"`
	// The folder_id of the violation
	FolderId int64 `protobuf:"varint,9,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Output only. Compliance violation remediation
	Remediation *Violation_Remediation `protobuf:"bytes,13,opt,name=remediation,proto3" json:"remediation,omitempty"`
}

func (x *Violation) Reset() {
	*x = Violation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Violation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Violation) ProtoMessage() {}

func (x *Violation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Violation.ProtoReflect.Descriptor instead.
func (*Violation) Descriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDescGZIP(), []int{0}
}

func (x *Violation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Violation) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Violation) GetBeginTime() *timestamppb.Timestamp {
	if x != nil {
		return x.BeginTime
	}
	return nil
}

func (x *Violation) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Violation) GetResolveTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ResolveTime
	}
	return nil
}

func (x *Violation) GetCategory() string {
	if x != nil {
		return x.Category
	}
	return ""
}

func (x *Violation) GetState() Violation_State {
	if x != nil {
		return x.State
	}
	return Violation_STATE_UNSPECIFIED
}

func (x *Violation) GetNonCompliantOrgPolicy() string {
	if x != nil {
		return x.NonCompliantOrgPolicy
	}
	return ""
}

func (x *Violation) GetFolderId() int64 {
	if x != nil {
		return x.FolderId
	}
	return 0
}

func (x *Violation) GetRemediation() *Violation_Remediation {
	if x != nil {
		return x.Remediation
	}
	return nil
}

// Message for requesting list of Violations
type ListViolationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource
	// Format
	// `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of customers row to return. The service may
	// return fewer than this value. If unspecified, at most 10 customers will be
	// returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListViolations` call.
	// Provide this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering results
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Hint for how to order the results
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. Specifies the interval for retrieving violations.
	// if unspecified, all violations will be returned.
	Interval *interval.Interval `protobuf:"bytes,6,opt,name=interval,proto3" json:"interval,omitempty"`
}

func (x *ListViolationsRequest) Reset() {
	*x = ListViolationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListViolationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListViolationsRequest) ProtoMessage() {}

func (x *ListViolationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListViolationsRequest.ProtoReflect.Descriptor instead.
func (*ListViolationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDescGZIP(), []int{1}
}

func (x *ListViolationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListViolationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListViolationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListViolationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListViolationsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListViolationsRequest) GetInterval() *interval.Interval {
	if x != nil {
		return x.Interval
	}
	return nil
}

// Response message for list customer violation requests
type ListViolationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of violation
	Violations []*Violation `protobuf:"bytes,1,rep,name=violations,proto3" json:"violations,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Workloads that could not be reached due to permission errors or any other
	// error. Ref: https://google.aip.dev/217
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListViolationsResponse) Reset() {
	*x = ListViolationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListViolationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListViolationsResponse) ProtoMessage() {}

func (x *ListViolationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListViolationsResponse.ProtoReflect.Descriptor instead.
func (*ListViolationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDescGZIP(), []int{2}
}

func (x *ListViolationsResponse) GetViolations() []*Violation {
	if x != nil {
		return x.Violations
	}
	return nil
}

func (x *ListViolationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListViolationsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a Violation
type GetViolationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format:
	// `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}/violations/{violation}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetViolationRequest) Reset() {
	*x = GetViolationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetViolationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetViolationRequest) ProtoMessage() {}

func (x *GetViolationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetViolationRequest.ProtoReflect.Descriptor instead.
func (*GetViolationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDescGZIP(), []int{3}
}

func (x *GetViolationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents remediation guidance to resolve compliance violation for
// AssuredWorkload
type Violation_Remediation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Remediation instructions to resolve violations
	Instructions *Violation_Remediation_Instructions `protobuf:"bytes,1,opt,name=instructions,proto3" json:"instructions,omitempty"`
	// Values that can resolve the violation
	// For example: for list org policy violations, this will either be the list
	// of allowed or denied values
	CompliantValues []string `protobuf:"bytes,2,rep,name=compliant_values,json=compliantValues,proto3" json:"compliant_values,omitempty"`
	// Output only. Remediation type based on the type of org policy values
	// violated
	RemediationType Violation_Remediation_RemediationType `protobuf:"varint,3,opt,name=remediation_type,json=remediationType,proto3,enum=google.cloud.cloudcontrolspartner.v1.Violation_Remediation_RemediationType" json:"remediation_type,omitempty"`
}

func (x *Violation_Remediation) Reset() {
	*x = Violation_Remediation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Violation_Remediation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Violation_Remediation) ProtoMessage() {}

func (x *Violation_Remediation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Violation_Remediation.ProtoReflect.Descriptor instead.
func (*Violation_Remediation) Descriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Violation_Remediation) GetInstructions() *Violation_Remediation_Instructions {
	if x != nil {
		return x.Instructions
	}
	return nil
}

func (x *Violation_Remediation) GetCompliantValues() []string {
	if x != nil {
		return x.CompliantValues
	}
	return nil
}

func (x *Violation_Remediation) GetRemediationType() Violation_Remediation_RemediationType {
	if x != nil {
		return x.RemediationType
	}
	return Violation_Remediation_REMEDIATION_TYPE_UNSPECIFIED
}

// Instructions to remediate violation
type Violation_Remediation_Instructions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Remediation instructions to resolve violation via gcloud cli
	GcloudInstructions *Violation_Remediation_Instructions_Gcloud `protobuf:"bytes,1,opt,name=gcloud_instructions,json=gcloudInstructions,proto3" json:"gcloud_instructions,omitempty"`
	// Remediation instructions to resolve violation via cloud console
	ConsoleInstructions *Violation_Remediation_Instructions_Console `protobuf:"bytes,2,opt,name=console_instructions,json=consoleInstructions,proto3" json:"console_instructions,omitempty"`
}

func (x *Violation_Remediation_Instructions) Reset() {
	*x = Violation_Remediation_Instructions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Violation_Remediation_Instructions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Violation_Remediation_Instructions) ProtoMessage() {}

func (x *Violation_Remediation_Instructions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Violation_Remediation_Instructions.ProtoReflect.Descriptor instead.
func (*Violation_Remediation_Instructions) Descriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *Violation_Remediation_Instructions) GetGcloudInstructions() *Violation_Remediation_Instructions_Gcloud {
	if x != nil {
		return x.GcloudInstructions
	}
	return nil
}

func (x *Violation_Remediation_Instructions) GetConsoleInstructions() *Violation_Remediation_Instructions_Console {
	if x != nil {
		return x.ConsoleInstructions
	}
	return nil
}

// Remediation instructions to resolve violation via gcloud cli
type Violation_Remediation_Instructions_Gcloud struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gcloud command to resolve violation
	GcloudCommands []string `protobuf:"bytes,1,rep,name=gcloud_commands,json=gcloudCommands,proto3" json:"gcloud_commands,omitempty"`
	// Steps to resolve violation via gcloud cli
	Steps []string `protobuf:"bytes,2,rep,name=steps,proto3" json:"steps,omitempty"`
	// Additional urls for more information about steps
	AdditionalLinks []string `protobuf:"bytes,3,rep,name=additional_links,json=additionalLinks,proto3" json:"additional_links,omitempty"`
}

func (x *Violation_Remediation_Instructions_Gcloud) Reset() {
	*x = Violation_Remediation_Instructions_Gcloud{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Violation_Remediation_Instructions_Gcloud) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Violation_Remediation_Instructions_Gcloud) ProtoMessage() {}

func (x *Violation_Remediation_Instructions_Gcloud) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Violation_Remediation_Instructions_Gcloud.ProtoReflect.Descriptor instead.
func (*Violation_Remediation_Instructions_Gcloud) Descriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDescGZIP(), []int{0, 0, 0, 0}
}

func (x *Violation_Remediation_Instructions_Gcloud) GetGcloudCommands() []string {
	if x != nil {
		return x.GcloudCommands
	}
	return nil
}

func (x *Violation_Remediation_Instructions_Gcloud) GetSteps() []string {
	if x != nil {
		return x.Steps
	}
	return nil
}

func (x *Violation_Remediation_Instructions_Gcloud) GetAdditionalLinks() []string {
	if x != nil {
		return x.AdditionalLinks
	}
	return nil
}

// Remediation instructions to resolve violation via cloud console
type Violation_Remediation_Instructions_Console struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Link to console page where violations can be resolved
	ConsoleUris []string `protobuf:"bytes,1,rep,name=console_uris,json=consoleUris,proto3" json:"console_uris,omitempty"`
	// Steps to resolve violation via cloud console
	Steps []string `protobuf:"bytes,2,rep,name=steps,proto3" json:"steps,omitempty"`
	// Additional urls for more information about steps
	AdditionalLinks []string `protobuf:"bytes,3,rep,name=additional_links,json=additionalLinks,proto3" json:"additional_links,omitempty"`
}

func (x *Violation_Remediation_Instructions_Console) Reset() {
	*x = Violation_Remediation_Instructions_Console{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Violation_Remediation_Instructions_Console) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Violation_Remediation_Instructions_Console) ProtoMessage() {}

func (x *Violation_Remediation_Instructions_Console) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Violation_Remediation_Instructions_Console.ProtoReflect.Descriptor instead.
func (*Violation_Remediation_Instructions_Console) Descriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDescGZIP(), []int{0, 0, 0, 1}
}

func (x *Violation_Remediation_Instructions_Console) GetConsoleUris() []string {
	if x != nil {
		return x.ConsoleUris
	}
	return nil
}

func (x *Violation_Remediation_Instructions_Console) GetSteps() []string {
	if x != nil {
		return x.Steps
	}
	return nil
}

func (x *Violation_Remediation_Instructions_Console) GetAdditionalLinks() []string {
	if x != nil {
		return x.AdditionalLinks
	}
	return nil
}

var File_google_cloud_cloudcontrolspartner_v1_violations_proto protoreflect.FileDescriptor

var file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbf, 0x0f, 0x0a, 0x09, 0x56, 0x69, 0x6f, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x0a, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x62, 0x65, 0x67, 0x69, 0x6e,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72,
	0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x63, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x50, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3f, 0x0a,
	0x18, 0x6e, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x6f,
	0x72, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x15, 0x6e, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70,
	0x6c, 0x69, 0x61, 0x6e, 0x74, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1b,
	0x0a, 0x09, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x08, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x62, 0x0a, 0x0b, 0x72,
	0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72,
	0x74, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x52, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a,
	0xe8, 0x08, 0x0a, 0x0b, 0x52, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x71, 0x0a, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x6f,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x74, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x7b, 0x0a,
	0x10, 0x72, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x72, 0x65, 0x6d, 0x65, 0x64,
	0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x1a, 0xfa, 0x03, 0x0a, 0x0c, 0x49,
	0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x80, 0x01, 0x0a, 0x13,
	0x67, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6d, 0x65, 0x64,
	0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x47, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x12, 0x67, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x83,
	0x01, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52,
	0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x52,
	0x13, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x72, 0x0a, 0x06, 0x47, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x27,
	0x0a, 0x0f, 0x67, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x67, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x12, 0x29, 0x0a,
	0x10, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x1a, 0x6d, 0x0a, 0x07, 0x43, 0x6f, 0x6e, 0x73,
	0x6f, 0x6c, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x5f, 0x75,
	0x72, 0x69, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x6f,
	0x6c, 0x65, 0x55, 0x72, 0x69, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x12, 0x29, 0x0a, 0x10,
	0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x22, 0xc0, 0x02, 0x0a, 0x0f, 0x52, 0x65, 0x6d, 0x65,
	0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x52,
	0x45, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x2c, 0x0a,
	0x28, 0x52, 0x45, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x42, 0x4f, 0x4f,
	0x4c, 0x45, 0x41, 0x4e, 0x5f, 0x4f, 0x52, 0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f,
	0x56, 0x49, 0x4f, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x38, 0x0a, 0x34, 0x52,
	0x45, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x5f,
	0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x45, 0x44, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x53, 0x5f, 0x4f,
	0x52, 0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x56, 0x49, 0x4f, 0x4c, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x37, 0x0a, 0x33, 0x52, 0x45, 0x4d, 0x45, 0x44, 0x49, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44,
	0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x53, 0x5f, 0x4f, 0x52, 0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x49,
	0x43, 0x59, 0x5f, 0x56, 0x49, 0x4f, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x46,
	0x0a, 0x42, 0x52, 0x45, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45,
	0x53, 0x54, 0x52, 0x49, 0x43, 0x54, 0x5f, 0x43, 0x4d, 0x45, 0x4b, 0x5f, 0x43, 0x52, 0x59, 0x50,
	0x54, 0x4f, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x53, 0x5f,
	0x4f, 0x52, 0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x56, 0x49, 0x4f, 0x4c, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45, 0x4d, 0x45, 0x44, 0x49,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x56,
	0x49, 0x4f, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x05, 0x22, 0x4b, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45,
	0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x55, 0x4e, 0x52, 0x45,
	0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x58, 0x43, 0x45,
	0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x3a, 0xbe, 0x01, 0xea, 0x41, 0xba, 0x01, 0x0a, 0x2d,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72,
	0x74, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x72, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2f,
	0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x7d, 0x2f, 0x76, 0x69, 0x6f, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2a, 0x0a, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x09, 0x76,
	0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa1, 0x02, 0x0a, 0x15, 0x4c, 0x69, 0x73,
	0x74, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x42, 0x79, 0x12, 0x36, 0x0a, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x22, 0xb3, 0x01, 0x0a,
	0x16, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4f, 0x0a, 0x0a, 0x76, 0x69, 0x6f, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x76, 0x69,
	0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x22, 0x60, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a,
	0x2d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61,
	0x72, 0x74, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x42, 0x93, 0x02, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x42, 0x0f, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x5c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
	0x70, 0x62, 0xaa, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x50,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x50,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDescOnce sync.Once
	file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDescData = file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDesc
)

func file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDescGZIP() []byte {
	file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDescOnce.Do(func() {
		file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDescData)
	})
	return file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDescData
}

var file_google_cloud_cloudcontrolspartner_v1_violations_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_cloudcontrolspartner_v1_violations_proto_goTypes = []interface{}{
	(Violation_State)(0),                               // 0: google.cloud.cloudcontrolspartner.v1.Violation.State
	(Violation_Remediation_RemediationType)(0),         // 1: google.cloud.cloudcontrolspartner.v1.Violation.Remediation.RemediationType
	(*Violation)(nil),                                  // 2: google.cloud.cloudcontrolspartner.v1.Violation
	(*ListViolationsRequest)(nil),                      // 3: google.cloud.cloudcontrolspartner.v1.ListViolationsRequest
	(*ListViolationsResponse)(nil),                     // 4: google.cloud.cloudcontrolspartner.v1.ListViolationsResponse
	(*GetViolationRequest)(nil),                        // 5: google.cloud.cloudcontrolspartner.v1.GetViolationRequest
	(*Violation_Remediation)(nil),                      // 6: google.cloud.cloudcontrolspartner.v1.Violation.Remediation
	(*Violation_Remediation_Instructions)(nil),         // 7: google.cloud.cloudcontrolspartner.v1.Violation.Remediation.Instructions
	(*Violation_Remediation_Instructions_Gcloud)(nil),  // 8: google.cloud.cloudcontrolspartner.v1.Violation.Remediation.Instructions.Gcloud
	(*Violation_Remediation_Instructions_Console)(nil), // 9: google.cloud.cloudcontrolspartner.v1.Violation.Remediation.Instructions.Console
	(*timestamppb.Timestamp)(nil),                      // 10: google.protobuf.Timestamp
	(*interval.Interval)(nil),                          // 11: google.type.Interval
}
var file_google_cloud_cloudcontrolspartner_v1_violations_proto_depIdxs = []int32{
	10, // 0: google.cloud.cloudcontrolspartner.v1.Violation.begin_time:type_name -> google.protobuf.Timestamp
	10, // 1: google.cloud.cloudcontrolspartner.v1.Violation.update_time:type_name -> google.protobuf.Timestamp
	10, // 2: google.cloud.cloudcontrolspartner.v1.Violation.resolve_time:type_name -> google.protobuf.Timestamp
	0,  // 3: google.cloud.cloudcontrolspartner.v1.Violation.state:type_name -> google.cloud.cloudcontrolspartner.v1.Violation.State
	6,  // 4: google.cloud.cloudcontrolspartner.v1.Violation.remediation:type_name -> google.cloud.cloudcontrolspartner.v1.Violation.Remediation
	11, // 5: google.cloud.cloudcontrolspartner.v1.ListViolationsRequest.interval:type_name -> google.type.Interval
	2,  // 6: google.cloud.cloudcontrolspartner.v1.ListViolationsResponse.violations:type_name -> google.cloud.cloudcontrolspartner.v1.Violation
	7,  // 7: google.cloud.cloudcontrolspartner.v1.Violation.Remediation.instructions:type_name -> google.cloud.cloudcontrolspartner.v1.Violation.Remediation.Instructions
	1,  // 8: google.cloud.cloudcontrolspartner.v1.Violation.Remediation.remediation_type:type_name -> google.cloud.cloudcontrolspartner.v1.Violation.Remediation.RemediationType
	8,  // 9: google.cloud.cloudcontrolspartner.v1.Violation.Remediation.Instructions.gcloud_instructions:type_name -> google.cloud.cloudcontrolspartner.v1.Violation.Remediation.Instructions.Gcloud
	9,  // 10: google.cloud.cloudcontrolspartner.v1.Violation.Remediation.Instructions.console_instructions:type_name -> google.cloud.cloudcontrolspartner.v1.Violation.Remediation.Instructions.Console
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_cloudcontrolspartner_v1_violations_proto_init() }
func file_google_cloud_cloudcontrolspartner_v1_violations_proto_init() {
	if File_google_cloud_cloudcontrolspartner_v1_violations_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Violation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListViolationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListViolationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetViolationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Violation_Remediation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Violation_Remediation_Instructions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Violation_Remediation_Instructions_Gcloud); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Violation_Remediation_Instructions_Console); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_cloudcontrolspartner_v1_violations_proto_goTypes,
		DependencyIndexes: file_google_cloud_cloudcontrolspartner_v1_violations_proto_depIdxs,
		EnumInfos:         file_google_cloud_cloudcontrolspartner_v1_violations_proto_enumTypes,
		MessageInfos:      file_google_cloud_cloudcontrolspartner_v1_violations_proto_msgTypes,
	}.Build()
	File_google_cloud_cloudcontrolspartner_v1_violations_proto = out.File
	file_google_cloud_cloudcontrolspartner_v1_violations_proto_rawDesc = nil
	file_google_cloud_cloudcontrolspartner_v1_violations_proto_goTypes = nil
	file_google_cloud_cloudcontrolspartner_v1_violations_proto_depIdxs = nil
}
