using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

#region Google Calendar specific imports
using Google.GData.Client;
using Google.GData.Extensions;
using Google.GData.Calendar;
using Google.GData.AccessControl;
using Google.GData.Tools;
#endregion

namespace Google_CalendarApplication
{
    public partial class Form1 : Form
    {

        private String googleAuthToken = null;
        private CalendarService calendarService = null;

        public Form1()
        {
            InitializeComponent();

            this.calendarService = new CalendarService("GoogleCalendarSample");

            if (this.googleAuthToken == null)
            {
                GoogleClientLogin loginDialog = new GoogleClientLogin(this.calendarService, "youremailhere@gmail.com");
                loginDialog.ShowDialog();

                this.googleAuthToken = loginDialog.AuthenticationToken;

                if (this.googleAuthToken != null)
                {
                    this.calendarService.SetAuthenticationToken(this.googleAuthToken);
                    this.Text = "Successfully logged in";

                    EventQuery query = new EventQuery("http://www.google.com/calendar/feeds/default/private/full/");
                    this.listView.Clear();

                    EventFeed feed = this.calendarService.Query(query);

                    if (feed != null && feed.Entries.Count > 0)
                    {
                        foreach (EventEntry entry in feed.Entries)
                        {
                            ListViewItem item = new ListViewItem(entry.Title.Text);
                            item.Tag = entry;
                            this.listView.Items.Add(item);
                        }
                    }
                    this.listView.Update();
                }
            }
        }
    }
}