/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __WHILE_LOOP_STAT_HPP_INCLUDED
#define __WHILE_LOOP_STAT_HPP_INCLUDED

#include "frontend/ast/LoopStat.hpp"
#include "frontend/ast/Expression.hpp"

namespace ast {

//! VHDL while loop.
/** a VHDL while loop statement. */
class WhileLoopStat : public LoopStat {
public:
	//! c'tor
	/** @param lbl optional label of the loop.
          * @param stats sequential statements enclosed by the loop.
          * @param cond while-condition of the loop.
          * @param loc location of the while statement.
          */
	WhileLoopStat(
		std::string *lbl,
		std::list<SeqStat*> *stats,
		Expression *cond,
		Location loc
		) : 	LoopStat(lbl, stats, loc),
			condition(cond) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor &visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << "WHILE " << this->condition;
	}

	/** while condition */
	Expression *condition;

protected:
	/** Destructor */
	virtual ~WhileLoopStat() {
		util::MiscUtil::terminate(condition);
	}
};

}; /* namespace ast */

#endif /* __WHILE_LOOP_STAT_HPP_INCLUDED */
