/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jorbis.Drft;

class Lpc {
    Drft fft = new Drft();
    int ln;
    int m;

    Lpc() {
    }

    static float lpc_from_data(float[] fArray, float[] fArray2, int n, int n2) {
        int n3;
        float f;
        float[] fArray3 = new float[n2 + 1];
        int n4 = n2 + 1;
        while (n4-- != 0) {
            f = 0.0f;
            n3 = n4;
            while (n3 < n) {
                f += fArray[n3] * fArray[n3 - n4];
                ++n3;
            }
            fArray3[n4] = f;
        }
        float f2 = fArray3[0];
        n3 = 0;
        while (n3 < n2) {
            f = -fArray3[n3 + 1];
            if (f2 == 0.0f) {
                int n5 = 0;
                while (n5 < n2) {
                    fArray2[n5] = 0.0f;
                    ++n5;
                }
                return 0.0f;
            }
            n4 = 0;
            while (n4 < n3) {
                f -= fArray2[n4] * fArray3[n3 - n4];
                ++n4;
            }
            fArray2[n3] = f /= f2;
            n4 = 0;
            while (n4 < n3 / 2) {
                float f3 = fArray2[n4];
                int n6 = n4;
                fArray2[n6] = fArray2[n6] + f * fArray2[n3 - 1 - n4];
                int n7 = n3 - 1 - n4;
                fArray2[n7] = fArray2[n7] + f * f3;
                ++n4;
            }
            if (n3 % 2 != 0) {
                int n8 = n4;
                fArray2[n8] = fArray2[n8] + fArray2[n4] * f;
            }
            f2 = (float)((double)f2 * (1.0 - (double)(f * f)));
            ++n3;
        }
        return f2;
    }

    float lpc_from_curve(float[] fArray, float[] fArray2) {
        int n = this.ln;
        float[] fArray3 = new float[n + n];
        float f = (float)(0.5 / (double)n);
        int n2 = 0;
        while (n2 < n) {
            fArray3[n2 * 2] = fArray[n2] * f;
            fArray3[n2 * 2 + 1] = 0.0f;
            ++n2;
        }
        fArray3[n * 2 - 1] = fArray[n - 1] * f;
        this.fft.backward(fArray3);
        n2 = 0;
        int n3 = (n *= 2) / 2;
        while (n2 < n / 2) {
            float f2 = fArray3[n2];
            fArray3[n2++] = fArray3[n3];
            fArray3[n3++] = f2;
        }
        return Lpc.lpc_from_data(fArray3, fArray2, n, this.m);
    }

    void init(int n, int n2) {
        this.ln = n;
        this.m = n2;
        this.fft.init(n * 2);
    }

    void clear() {
        this.fft.clear();
    }

    static float FAST_HYPOT(float f, float f2) {
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    void lpc_to_curve(float[] fArray, float[] fArray2, float f) {
        int n = 0;
        while (n < this.ln * 2) {
            fArray[n] = 0.0f;
            ++n;
        }
        if (f == 0.0f) {
            return;
        }
        n = 0;
        while (n < this.m) {
            fArray[n * 2 + 1] = fArray2[n] / (4.0f * f);
            fArray[n * 2 + 2] = -fArray2[n] / (4.0f * f);
            ++n;
        }
        this.fft.backward(fArray);
        n = this.ln * 2;
        float f2 = (float)(1.0 / (double)f);
        fArray[0] = (float)(1.0 / (double)(fArray[0] * 2.0f + f2));
        int n2 = 1;
        while (n2 < this.ln) {
            float f3 = fArray[n2] + fArray[n - n2];
            float f4 = fArray[n2] - fArray[n - n2];
            float f5 = f3 + f2;
            fArray[n2] = (float)(1.0 / (double)Lpc.FAST_HYPOT(f5, f4));
            ++n2;
        }
    }
}

