#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
    {TR_NO_PATCH_TITLE, "Το patch 1.0.1.0 δεν είναι εγκατεστημένο"},
    {TR_NO_PATCH_MESSAGE,
        "Η εγκατεστημένη έκδοση του Caesar 3 δεν περιλαμβάνει το patch 1.0.1.0 "
        "Μπορείτε να κατεβάσετε το patch από εδώ:\n"
        URL_PATCHES "\n"
        "Συνεχίζετε με δική σας ευθύνη."},
    // Do not translate the following message since it cannot be shown in Greek:
    {TR_MISSING_FONTS_TITLE, "Missing fonts"},
    {TR_MISSING_FONTS_MESSAGE,
        "Your Caesar 3 installation requires extra font files. "
        "You can download them for your language from:\n"
        URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "Ο επεξεργαστής δεν έχει εγκατασταθεί"},
    {TR_NO_EDITOR_MESSAGE,
        "Η εγκατάστασή σας στο Caesar 3 δεν περιέχει τα αρχεία του επεξεργαστή. "
        "Μπορείτε να τα κατεβάσετε από εδώ:\n"
        URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "Μη έγκυρος γλωσσικός κατάλογος"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "Ο κατάλογος που επιλέξατε δεν περιέχει έγκυρο πακέτο γλωσσών. "
        "Ελέγξτε το αρχείο καταγραφής για σφάλματα."},
    {TR_BUILD_ALL_TEMPLES, "Όλοι"},
    {TR_BUTTON_OK, "ΟΚ"},
    {TR_BUTTON_CANCEL, "Ακύρωση"},
    {TR_BUTTON_RESET_DEFAULTS, "Επαναφορά προεπιλογών"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "Πλήκτρα συντομεύσεων"},
    {TR_CONFIG_TITLE, "Επιλογές διαμόρφωσης Julius"},
    {TR_CONFIG_LANGUAGE_LABEL, "Γλώσσα:"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(προεπιλογή)"},
    {TR_CONFIG_DISPLAY_SCALE, "Κλίμακα απεικόνισης:"},
    {TR_CONFIG_CURSOR_SCALE, "Κλίμακα κέρσορα:"},
    {TR_CONFIG_HEADER_UI_CHANGES, "Αλλαγές διεπαφής χρήστη"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "Αλλαγές παιχνιδιού"},
    {TR_CONFIG_SHOW_INTRO_VIDEO, "Αναπαραγωγή εισαγωγικών βίντεο"},
    {TR_CONFIG_SIDEBAR_INFO, "Πρόσθετες πληροφορίες στον πίνακα ελέγχου"},
    {TR_CONFIG_SMOOTH_SCROLLING, "Ενεργοποίηση ομαλής κύλισης"},
    {TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Απενεργοποίηση κύλισης χάρτη στην άκρη του παραθύρου"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Απενεργοποίηση κύλισης με το δεξί κουμπί του ποντικιού"},
    {TR_CONFIG_INVERSE_RIGHT_CLICK_MAP_DRAG, "Αντιστροφή συρσίματος χάρτη με το δεξί πλήκτρο του ποντικιού"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "Βελτίωση της οπτικής ανατροφοδότησης κατά την εκκαθάριση γης"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "Δυνατότητα κατασκευής κάθε ναού διαδοχικά"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "Εμφάνιση εύρους κατά την οικοδόμηση δεξαμενών, σιντριβανιών και πηγαδιών"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Εμφάνιση συρόμενου μεγέθους κατασκευής"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "Επισήμανση λεγεώνας στο πέρασμα του κέρσορα"},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "Ενεργοποίηση πλευρικής στήλης στρατού"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "Επιδιόρθωση σφάλματος μετανάστευσης στο πολύ δύσκολο επίπεδο"},
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "Επιδιόρθωση φαντασμάτων 100 ετών"},
    {TR_HOTKEY_TITLE, "Ρύθμιση πλήκτρων συντομεύσεων του Julius"},
    {TR_HOTKEY_LABEL, "Πλήκτρα συντόμευσης"},
    {TR_HOTKEY_ALTERNATIVE_LABEL, "Εναλλακτικά"},
    {TR_HOTKEY_HEADER_ARROWS, "Πλήκτρα βέλους"},
    {TR_HOTKEY_HEADER_GLOBAL, "Γενικά πλήκτρα συντόμευσης"},
    {TR_HOTKEY_HEADER_CITY, "Πλήκτρα συντομεύσεων πόλης"},
    {TR_HOTKEY_HEADER_ADVISORS, "Σύμβουλοι"},
    {TR_HOTKEY_HEADER_OVERLAYS, "Επικαλύψεις"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "Σελιδοδείκτες χάρτη πόλης"},
    {TR_HOTKEY_HEADER_EDITOR, "Επεξεργαστής"},
    {TR_HOTKEY_HEADER_BUILD, "Πλήκτρα συντόμευσης κατασκευών"},
    {TR_HOTKEY_ARROW_UP, "Πάνω"},
    {TR_HOTKEY_ARROW_DOWN, "Κάτω"},
    {TR_HOTKEY_ARROW_LEFT, "Αριστερά"},
    {TR_HOTKEY_ARROW_RIGHT, "Δεξιά"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "Εναλλαγή πλήρους οθόνης"},
    {TR_HOTKEY_CENTER_WINDOW, "Παράθυρο στο κέντρο"},
    {TR_HOTKEY_RESIZE_TO_640, "Αλλαγή μεγέθους παραθύρου σε 640x480"},
    {TR_HOTKEY_RESIZE_TO_800, "Αλλαγή μεγέθους παραθύρου σε 800x600"},
    {TR_HOTKEY_RESIZE_TO_1024, "Αλλαγή μεγέθους παραθύρου σε 1024x768"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "Αποθήκευση στιγμιότυπου οθόνης"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "Αποθήκευση στιγμιoτύπου οθόνης ολόκληρης της πόλης"},
    {TR_HOTKEY_BUILD_CLONE, "Κλωνοποίηση κτιρίου κάτω από τον κέρσορα"},
    {TR_HOTKEY_LOAD_FILE, "Φόρτωση αρχείου"},
    {TR_HOTKEY_SAVE_FILE, "Αποθήκευση αρχείου"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "Αύξηση ταχύτητας παιχνιδιού"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "Μείωση ταχύτητας παιχνιδιού"},
    {TR_HOTKEY_TOGGLE_PAUSE, "Εναλλαγή παύσης"},
    {TR_HOTKEY_CYCLE_LEGION, "Περιοδεία στις λεγεώνες"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "Περιστροφή χάρτη αριστερά"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "Περιστροφή χάρτη δεξιά"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "Σύμβουλος εργασίας"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "Σύμβουλος στρατού"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "Σύμβουλος Αυτοκράτορα"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "Σύμβουλος αξιολογήσεων"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "Σύμβουλος εμπορίου"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "Σύμβουλος πληθυσμού"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "Σύμβουλος υγείας"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "Σύμβουλος εκπαίδευσης"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "Σύμβουλος ψυχαγωγίας"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "Σύμβουλος θρησκείας"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "Σύμβουλος οικονομικών"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "Επικεφαλής σύμβουλος"},
    {TR_HOTKEY_TOGGLE_OVERLAY, "Εναλλαγή τρέχουσας επικάλυψης"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "Επικάλυψη νερού"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "Επικάλυψη πυρκαγιάς"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "Επικάλυψη ζημιών"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "Επικάλυψη εγκλήματος"},
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "Επικάλυψη προβλημάτων"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "Μετάβαση στο σελιδοδείκτη 1"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "Μετάβαση στο σελιδοδείκτη 2"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "Μετάβαση στο σελιδοδείκτη 3"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "Μετάβαση στο σελιδοδείκτη 4"},
    {TR_HOTKEY_SET_BOOKMARK_1, "Ορισμός σελιδοδείκτη 1"},
    {TR_HOTKEY_SET_BOOKMARK_2, "Ορισμός σελιδοδείκτη 2"},
    {TR_HOTKEY_SET_BOOKMARK_3, "Ορισμός σελιδοδείκτη 3"},
    {TR_HOTKEY_SET_BOOKMARK_4, "Ορισμός σελιδοδείκτη 4"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "Εναλλαγή πληροφοριών μάχης"},
    {TR_HOTKEY_EDIT_TITLE, "Πατήστε το νέο πλήκτρο συντόμευσης"},
    {TR_HOTKEY_DUPLICATE_TITLE, "Το πλήκτρο συντόμευσης έχει ήδη χρησιμοποιηθεί"},
    {TR_HOTKEY_DUPLICATE_MESSAGE, "Αυτός ο συνδυασμός πλήκτρων έχει ήδη εκχωρηθεί στην ακόλουθη ενέργεια:"},
    {TR_WARNING_SCREENSHOT_SAVED, "Το στιγμιότυπο οθόνης αποθηκεύτηκε: "},
};

void translation_greek(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
