/*-
 * Copyright (c) 2006 The FreeBSD Project
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/8/usr.sbin/asf/asf_kld.c 159720 2006-06-18 11:14:40Z yar $");

#include <sys/param.h>
#include <sys/linker.h>
#include <err.h>
#include <string.h>

#include "asf.h"

/*
 * Get the linker file list using the kld interface.
 * Works with a live kernel only.
 */
void
asf_kld()
{
	struct kld_file_stat kfs;
	int fid = 0;	/* indicates the beginning of the linker file list */

	while ((fid = kldnext(fid)) != 0) {
		if (fid == -1)
			err(2, "kldnext");
		kfs.version = sizeof(kfs);	/* must be set for kldstat(2) */
		/* Get info on this linker file */
		if (kldstat(fid, &kfs) == -1)
			err(2, "kldstat");
		if (strcmp(kfs.name, KERNFILE) == 0)
			continue;
		/* Add to our list of linker files */
		kfile_add(kfs.name, kfs.address);
	}
}
