/*
 *  Copyright (C) 2021 - This file is part of libecc project
 *
 *  Authors:
 *      Arnaud EBALARD <arnaud.ebalard@ssi.gouv.fr>
 *      Ryad BENADJILA <ryadbenadjila@gmail.com>
 *
 *  This software is licensed under a dual BSD and GPL v2 license.
 *  See LICENSE file at the root folder of the project.
 */
#ifndef __ED25519CTX_TEST_VECTORS_H__
#define __ED25519CTX_TEST_VECTORS_H__

/************************************************/
static const u8 ed25519ctx_1_test_vectors_priv_key[] = {
	0x03, 0x05, 0x33, 0x4e, 0x38, 0x1a, 0xf7, 0x8f, 0x14, 0x1c, 0xb6, 0x66, 0xf6, 0x19, 0x9f, 0x57, 0xbc, 0x34, 0x95, 0x33, 0x5a, 0x25, 0x6a, 0x95, 0xbd, 0x2a, 0x55, 0xbf, 0x54, 0x66, 0x63, 0xf6,
};
static const u8 ed25519ctx_1_test_vectors_message[] = {
	0xf7, 0x26, 0x93, 0x6d, 0x19, 0xc8, 0x00, 0x49, 0x4e, 0x3f, 0xda, 0xff, 0x20, 0xb2, 0x76, 0xa8,
};
static const u8 ed25519ctx_1_test_vectors_expected_sig[] = {
	0x55, 0xa4, 0xcc, 0x2f, 0x70, 0xa5, 0x4e, 0x04, 0x28, 0x8c, 0x5f, 0x4c, 0xd1, 0xe4, 0x5a, 0x7b, 0xb5, 0x20, 0xb3, 0x62, 0x92, 0x91, 0x18, 0x76, 0xca, 0xda, 0x73, 0x23, 0x19, 0x8d, 0xd8, 0x7a, 0x8b, 0x36, 0x95, 0x0b, 0x95, 0x13, 0x00, 0x22, 0x90, 0x7a, 0x7f, 0xb7, 0xc4, 0xe9, 0xb2, 0xd5, 0xf6, 0xcc, 0xa6, 0x85, 0xa5, 0x87, 0xb4, 0xb2, 0x1f, 0x4b, 0x88, 0x8e, 0x4e, 0x7e, 0xdb, 0x0d,
};
static const u8 ed25519ctx_1_test_vectors_adata[] = {
	0x66, 0x6f, 0x6f,
};
static const ec_test_case ed25519ctx_1_test_case = {
	.name = "EDDSA25519CTX-SHA512/wei25519 1",
	.ec_str_p = &wei25519_str_params,
	.priv_key = ed25519ctx_1_test_vectors_priv_key,
	.priv_key_len = sizeof(ed25519ctx_1_test_vectors_priv_key),
	.nn_random = NULL,
	.hash_type = SHA512,
	.msg = (const char *)ed25519ctx_1_test_vectors_message,
	.msglen = sizeof(ed25519ctx_1_test_vectors_message),
	.sig_type = EDDSA25519CTX,
	.exp_sig = ed25519ctx_1_test_vectors_expected_sig,
	.exp_siglen = sizeof(ed25519ctx_1_test_vectors_expected_sig),
	.adata = ed25519ctx_1_test_vectors_adata,
	.adata_len = sizeof(ed25519ctx_1_test_vectors_adata),
};

/************************************************/
static const u8 ed25519ctx_2_test_vectors_priv_key[] = {
	0x03, 0x05, 0x33, 0x4e, 0x38, 0x1a, 0xf7, 0x8f, 0x14, 0x1c, 0xb6, 0x66, 0xf6, 0x19, 0x9f, 0x57, 0xbc, 0x34, 0x95, 0x33, 0x5a, 0x25, 0x6a, 0x95, 0xbd, 0x2a, 0x55, 0xbf, 0x54, 0x66, 0x63, 0xf6,
};
static const u8 ed25519ctx_2_test_vectors_message[] = {
	0xf7, 0x26, 0x93, 0x6d, 0x19, 0xc8, 0x00, 0x49, 0x4e, 0x3f, 0xda, 0xff, 0x20, 0xb2, 0x76, 0xa8,
};
static const u8 ed25519ctx_2_test_vectors_expected_sig[] = {
	0xfc, 0x60, 0xd5, 0x87, 0x2f, 0xc4, 0x6b, 0x3a, 0xa6, 0x9f, 0x8b, 0x5b, 0x43, 0x51, 0xd5, 0x80, 0x8f, 0x92, 0xbc, 0xc0, 0x44, 0x60, 0x6d, 0xb0, 0x97, 0xab, 0xab, 0x6d, 0xbc, 0xb1, 0xae, 0xe3, 0x21, 0x6c, 0x48, 0xe8, 0xb3, 0xb6, 0x64, 0x31, 0xb5, 0xb1, 0x86, 0xd1, 0xd2, 0x8f, 0x8e, 0xe1, 0x5a, 0x5c, 0xa2, 0xdf, 0x66, 0x68, 0x34, 0x62, 0x91, 0xc2, 0x04, 0x3d, 0x4e, 0xb3, 0xe9, 0x0d,
};
static const u8 ed25519ctx_2_test_vectors_adata[] = {
	0x62, 0x61, 0x72,
};
static const ec_test_case ed25519ctx_2_test_case = {
	.name = "EDDSA25519CTX-SHA512/wei25519 2",
	.ec_str_p = &wei25519_str_params,
	.priv_key = ed25519ctx_2_test_vectors_priv_key,
	.priv_key_len = sizeof(ed25519ctx_2_test_vectors_priv_key),
	.nn_random = NULL,
	.hash_type = SHA512,
	.msg = (const char *)ed25519ctx_2_test_vectors_message,
	.msglen = sizeof(ed25519ctx_2_test_vectors_message),
	.sig_type = EDDSA25519CTX,
	.exp_sig = ed25519ctx_2_test_vectors_expected_sig,
	.exp_siglen = sizeof(ed25519ctx_2_test_vectors_expected_sig),
	.adata = ed25519ctx_2_test_vectors_adata,
	.adata_len = sizeof(ed25519ctx_2_test_vectors_adata),
};

/************************************************/
static const u8 ed25519ctx_3_test_vectors_priv_key[] = {
	0x03, 0x05, 0x33, 0x4e, 0x38, 0x1a, 0xf7, 0x8f, 0x14, 0x1c, 0xb6, 0x66, 0xf6, 0x19, 0x9f, 0x57, 0xbc, 0x34, 0x95, 0x33, 0x5a, 0x25, 0x6a, 0x95, 0xbd, 0x2a, 0x55, 0xbf, 0x54, 0x66, 0x63, 0xf6,
};
static const u8 ed25519ctx_3_test_vectors_message[] = {
	0x50, 0x8e, 0x9e, 0x68, 0x82, 0xb9, 0x79, 0xfe, 0xa9, 0x00, 0xf6, 0x2a, 0xdc, 0xea, 0xca, 0x35,
};
static const u8 ed25519ctx_3_test_vectors_expected_sig[] = {
	0x8b, 0x70, 0xc1, 0xcc, 0x83, 0x10, 0xe1, 0xde, 0x20, 0xac, 0x53, 0xce, 0x28, 0xae, 0x6e, 0x72, 0x07, 0xf3, 0x3c, 0x32, 0x95, 0xe0, 0x3b, 0xb5, 0xc0, 0x73, 0x2a, 0x1d, 0x20, 0xdc, 0x64, 0x90, 0x89, 0x22, 0xa8, 0xb0, 0x52, 0xcf, 0x99, 0xb7, 0xc4, 0xfe, 0x10, 0x7a, 0x5a, 0xbb, 0x5b, 0x2c, 0x40, 0x85, 0xae, 0x75, 0x89, 0x0d, 0x02, 0xdf, 0x26, 0x26, 0x9d, 0x89, 0x45, 0xf8, 0x4b, 0x0b,
};
static const u8 ed25519ctx_3_test_vectors_adata[] = {
	0x66, 0x6f, 0x6f,
};
static const ec_test_case ed25519ctx_3_test_case = {
	.name = "EDDSA25519CTX-SHA512/wei25519 3",
	.ec_str_p = &wei25519_str_params,
	.priv_key = ed25519ctx_3_test_vectors_priv_key,
	.priv_key_len = sizeof(ed25519ctx_3_test_vectors_priv_key),
	.nn_random = NULL,
	.hash_type = SHA512,
	.msg = (const char *)ed25519ctx_3_test_vectors_message,
	.msglen = sizeof(ed25519ctx_3_test_vectors_message),
	.sig_type = EDDSA25519CTX,
	.exp_sig = ed25519ctx_3_test_vectors_expected_sig,
	.exp_siglen = sizeof(ed25519ctx_3_test_vectors_expected_sig),
	.adata = ed25519ctx_3_test_vectors_adata,
	.adata_len = sizeof(ed25519ctx_3_test_vectors_adata),
};

/************************************************/
static const u8 ed25519ctx_4_test_vectors_priv_key[] = {
	0xab, 0x9c, 0x28, 0x53, 0xce, 0x29, 0x7d, 0xda, 0xb8, 0x5c, 0x99, 0x3b, 0x3a, 0xe1, 0x4b, 0xca, 0xd3, 0x9b, 0x2c, 0x68, 0x2b, 0xea, 0xbc, 0x27, 0xd6, 0xd4, 0xeb, 0x20, 0x71, 0x1d, 0x65, 0x60,
};
static const u8 ed25519ctx_4_test_vectors_message[] = {
	0xf7, 0x26, 0x93, 0x6d, 0x19, 0xc8, 0x00, 0x49, 0x4e, 0x3f, 0xda, 0xff, 0x20, 0xb2, 0x76, 0xa8,
};
static const u8 ed25519ctx_4_test_vectors_expected_sig[] = {
	0x21, 0x65, 0x5b, 0x5f, 0x1a, 0xa9, 0x65, 0x99, 0x6b, 0x3f, 0x97, 0xb3, 0xc8, 0x49, 0xea, 0xfb, 0xa9, 0x22, 0xa0, 0xa6, 0x29, 0x92, 0xf7, 0x3b, 0x3d, 0x1b, 0x73, 0x10, 0x6a, 0x84, 0xad, 0x85, 0xe9, 0xb8, 0x6a, 0x7b, 0x60, 0x05, 0xea, 0x86, 0x83, 0x37, 0xff, 0x2d, 0x20, 0xa7, 0xf5, 0xfb, 0xd4, 0xcd, 0x10, 0xb0, 0xbe, 0x49, 0xa6, 0x8d, 0xa2, 0xb2, 0xe0, 0xdc, 0x0a, 0xd8, 0x96, 0x0f,
};
static const u8 ed25519ctx_4_test_vectors_adata[] = {
	0x66, 0x6f, 0x6f,
};
static const ec_test_case ed25519ctx_4_test_case = {
	.name = "EDDSA25519CTX-SHA512/wei25519 4",
	.ec_str_p = &wei25519_str_params,
	.priv_key = ed25519ctx_4_test_vectors_priv_key,
	.priv_key_len = sizeof(ed25519ctx_4_test_vectors_priv_key),
	.nn_random = NULL,
	.hash_type = SHA512,
	.msg = (const char *)ed25519ctx_4_test_vectors_message,
	.msglen = sizeof(ed25519ctx_4_test_vectors_message),
	.sig_type = EDDSA25519CTX,
	.exp_sig = ed25519ctx_4_test_vectors_expected_sig,
	.exp_siglen = sizeof(ed25519ctx_4_test_vectors_expected_sig),
	.adata = ed25519ctx_4_test_vectors_adata,
	.adata_len = sizeof(ed25519ctx_4_test_vectors_adata),
};


/************************************************/
#define EDDSA25519CTX_SHA512_WEI25519_ALL_TESTS() \
	&ed25519ctx_1_test_case,\
	&ed25519ctx_2_test_case,\
	&ed25519ctx_3_test_case,\
	&ed25519ctx_4_test_case,

#endif /* __ED25519CTX_TEST_VECTORS_H__ */
