#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_0
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_0_test_vector_our_priv_key[] = {
	0xf1, 0x7d, 0x3f, 0xea, 0x36, 0x7b, 0x74, 0xd3, 0x40, 0x85, 0x1c, 0xa4, 0x27, 0x0d, 0xcb, 0x24, 0xc2, 0x71, 0xf4, 0x45, 0xbe, 0xd9, 0xd5, 0x27,
};
static const u8 ecccdh_SECP192R1_0_test_vector_peer_pub_key[] = {
	0x42, 0xea, 0x6d, 0xd9, 0x96, 0x9d, 0xd2, 0xa6, 0x1f, 0xea, 0x1a, 0xac, 0x7f, 0x8e, 0x98, 0xed, 0xcc, 0x89, 0x6c, 0x6e, 0x55, 0x85, 0x7c, 0xc0, 0xdf, 0xbe, 0x5d, 0x7c, 0x61, 0xfa, 0xc8, 0x8b, 0x11, 0x81, 0x1b, 0xde, 0x32, 0x8e, 0x8a, 0x0d, 0x12, 0xbf, 0x01, 0xa9, 0xd2, 0x04, 0xb5, 0x23,
};
static const u8 ecccdh_SECP192R1_0_test_vector_our_pub_key[] = {
	0xb1, 0x50, 0x53, 0x40, 0x1f, 0x57, 0x28, 0x56, 0x37, 0xec, 0x32, 0x4c, 0x1c, 0xd2, 0x13, 0x9e, 0x3a, 0x67, 0xde, 0x37, 0x39, 0x23, 0x4b, 0x37, 0xf2, 0x69, 0xc1, 0x58, 0x63, 0x74, 0x82, 0xaa, 0xd6, 0x44, 0xcd, 0x69, 0x2d, 0xd1, 0xd3, 0xef, 0x2c, 0x8a, 0x7c, 0x49, 0xe3, 0x89, 0xf7, 0xf6,
};
static const u8 ecccdh_SECP192R1_0_test_vector_shared_secret[] = {
	0x80, 0x3d, 0x8a, 0xb2, 0xe5, 0xb6, 0xe6, 0xfc, 0xa7, 0x15, 0x73, 0x7c, 0x3a, 0x82, 0xf7, 0xce, 0x3c, 0x78, 0x31, 0x24, 0xf6, 0xd5, 0x1c, 0xd0,
};
static const ecdh_test_case ecccdh_SECP192R1_0_test_case = {
	.name = "ECCCDH/SECP192R1 0",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_0_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_0_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_0_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_0_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_0_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_0_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_0_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_0_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_1
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_1_test_vector_our_priv_key[] = {
	0x56, 0xe8, 0x53, 0x34, 0x9d, 0x96, 0xfe, 0x4c, 0x44, 0x24, 0x48, 0xda, 0xcb, 0x7c, 0xf9, 0x2b, 0xb7, 0xa9, 0x5d, 0xcf, 0x57, 0x4a, 0x9b, 0xd5,
};
static const u8 ecccdh_SECP192R1_1_test_vector_peer_pub_key[] = {
	0xde, 0xb5, 0x71, 0x2f, 0xa0, 0x27, 0xac, 0x8d, 0x2f, 0x22, 0xc4, 0x55, 0xcc, 0xb7, 0x3a, 0x91, 0xe1, 0x7b, 0x65, 0x12, 0xb5, 0xe0, 0x30, 0xe7, 0x7e, 0x26, 0x90, 0xa0, 0x2c, 0xc9, 0xb2, 0x87, 0x08, 0x43, 0x1a, 0x29, 0xfb, 0x54, 0xb8, 0x7b, 0x1f, 0x0c, 0x14, 0xe0, 0x11, 0xac, 0x21, 0x25,
};
static const u8 ecccdh_SECP192R1_1_test_vector_our_pub_key[] = {
	0xc0, 0x0d, 0x43, 0x57, 0x16, 0xff, 0xea, 0x53, 0xfd, 0x8c, 0x16, 0x27, 0x92, 0x41, 0x4c, 0x37, 0x66, 0x51, 0x87, 0xe5, 0x82, 0x71, 0x65, 0x39, 0xab, 0x71, 0x1c, 0x62, 0xaa, 0x71, 0xa5, 0xa1, 0x8e, 0x8a, 0x3c, 0x48, 0xf8, 0x9d, 0xc6, 0xfa, 0x52, 0xfa, 0xc0, 0x10, 0x8e, 0x52, 0xa8, 0xa0,
};
static const u8 ecccdh_SECP192R1_1_test_vector_shared_secret[] = {
	0xc2, 0x08, 0x84, 0x75, 0x68, 0xb9, 0x88, 0x35, 0xd7, 0x31, 0x2c, 0xef, 0x1f, 0x97, 0xf7, 0xaa, 0x29, 0x82, 0x83, 0x15, 0x23, 0x13, 0xc2, 0x9d,
};
static const ecdh_test_case ecccdh_SECP192R1_1_test_case = {
	.name = "ECCCDH/SECP192R1 1",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_1_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_1_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_1_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_1_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_1_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_1_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_1_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_1_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_2
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_2_test_vector_our_priv_key[] = {
	0xc6, 0xef, 0x61, 0xfe, 0x12, 0xe8, 0x0b, 0xf5, 0x6f, 0x2d, 0x3f, 0x7d, 0x0b, 0xb7, 0x57, 0x39, 0x45, 0x19, 0x90, 0x6d, 0x55, 0x50, 0x09, 0x49,
};
static const u8 ecccdh_SECP192R1_2_test_vector_peer_pub_key[] = {
	0x4e, 0xda, 0xa8, 0xef, 0xc5, 0xa0, 0xf4, 0x0f, 0x84, 0x36, 0x63, 0xec, 0x58, 0x15, 0xe7, 0x76, 0x2d, 0xdd, 0xc0, 0x08, 0xe6, 0x63, 0xc2, 0x0f, 0x0a, 0x9f, 0x8d, 0xc6, 0x7a, 0x3e, 0x60, 0xef, 0x6d, 0x64, 0xb5, 0x22, 0x18, 0x5d, 0x03, 0xdf, 0x1f, 0xc0, 0xad, 0xfd, 0x42, 0x47, 0x82, 0x79,
};
static const u8 ecccdh_SECP192R1_2_test_vector_our_pub_key[] = {
	0xe1, 0x84, 0xbc, 0x18, 0x24, 0x82, 0xf3, 0x40, 0x3c, 0x87, 0x87, 0xb8, 0x38, 0x42, 0x47, 0x74, 0x67, 0xfc, 0xd0, 0x11, 0xdb, 0x0f, 0x6c, 0x64, 0xf9, 0xd1, 0xc1, 0x41, 0x42, 0xf4, 0x0d, 0xe8, 0x63, 0x9d, 0xb9, 0x7d, 0x51, 0xa6, 0x3d, 0x2c, 0xce, 0x10, 0x07, 0xcc, 0xf7, 0x73, 0xcd, 0xcb,
};
static const u8 ecccdh_SECP192R1_2_test_vector_shared_secret[] = {
	0x87, 0x22, 0x91, 0x07, 0x04, 0x7a, 0x3b, 0x61, 0x19, 0x20, 0xd6, 0xe3, 0xb2, 0xc0, 0xc8, 0x9b, 0xea, 0x4f, 0x49, 0x41, 0x22, 0x60, 0xb8, 0xdd,
};
static const ecdh_test_case ecccdh_SECP192R1_2_test_case = {
	.name = "ECCCDH/SECP192R1 2",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_2_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_2_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_2_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_2_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_2_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_2_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_2_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_2_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_3
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_3_test_vector_our_priv_key[] = {
	0xe6, 0x74, 0x7b, 0x9c, 0x23, 0xba, 0x70, 0x44, 0xf3, 0x8f, 0xf7, 0xe6, 0x2c, 0x35, 0xe4, 0x03, 0x89, 0x20, 0xf5, 0xa0, 0x16, 0x3d, 0x3c, 0xda,
};
static const u8 ecccdh_SECP192R1_3_test_vector_peer_pub_key[] = {
	0x88, 0x87, 0xc2, 0x76, 0xed, 0xee, 0xd3, 0xe9, 0xe8, 0x66, 0xb4, 0x6d, 0x58, 0xd8, 0x95, 0xc7, 0x3f, 0xbd, 0x80, 0xb6, 0x3e, 0x38, 0x2e, 0x88, 0x04, 0xc5, 0x09, 0x7b, 0xa6, 0x64, 0x5e, 0x16, 0x20, 0x6c, 0xfb, 0x70, 0xf7, 0x05, 0x26, 0x55, 0x94, 0x7d, 0xd4, 0x4a, 0x17, 0xf1, 0xf9, 0xd5,
};
static const u8 ecccdh_SECP192R1_3_test_vector_our_pub_key[] = {
	0x2b, 0x83, 0x8d, 0xbe, 0x73, 0x73, 0x5f, 0x37, 0xa3, 0x9a, 0x78, 0xd3, 0x19, 0x57, 0x83, 0xd2, 0x69, 0x91, 0xe8, 0x6f, 0xf4, 0xd9, 0x2d, 0x1a, 0x60, 0xd3, 0x44, 0x94, 0x22, 0x74, 0x48, 0x9f, 0x98, 0x90, 0x3b, 0x2e, 0x7f, 0x93, 0xf8, 0xd1, 0x97, 0xfc, 0x9a, 0xe6, 0x0a, 0x0e, 0xd5, 0x3a,
};
static const u8 ecccdh_SECP192R1_3_test_vector_shared_secret[] = {
	0xee, 0xc0, 0xbe, 0xd8, 0xfc, 0x55, 0xe1, 0xfe, 0xdd, 0xc8, 0x21, 0x58, 0xfd, 0x6d, 0xc0, 0xd4, 0x8a, 0x4d, 0x79, 0x6a, 0xaf, 0x47, 0xd4, 0x6c,
};
static const ecdh_test_case ecccdh_SECP192R1_3_test_case = {
	.name = "ECCCDH/SECP192R1 3",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_3_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_3_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_3_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_3_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_3_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_3_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_3_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_3_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_4
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_4_test_vector_our_priv_key[] = {
	0xbe, 0xab, 0xed, 0xd0, 0x15, 0x4a, 0x1a, 0xfc, 0xfc, 0x85, 0xd5, 0x21, 0x81, 0xc1, 0x0f, 0x5e, 0xb4, 0x7a, 0xdc, 0x51, 0xf6, 0x55, 0x04, 0x7d,
};
static const u8 ecccdh_SECP192R1_4_test_vector_peer_pub_key[] = {
	0x0d, 0x04, 0x5f, 0x30, 0x25, 0x4a, 0xdc, 0x1f, 0xce, 0xfa, 0x8a, 0x5b, 0x1f, 0x31, 0xbf, 0x4e, 0x73, 0x9d, 0xd3, 0x27, 0xcd, 0x18, 0xd5, 0x94, 0x54, 0x2c, 0x31, 0x4e, 0x41, 0x42, 0x7c, 0x08, 0x27, 0x8a, 0x08, 0xce, 0x8d, 0x73, 0x05, 0xf3, 0xb5, 0xb8, 0x49, 0xc7, 0x2d, 0x8a, 0xff, 0x73,
};
static const u8 ecccdh_SECP192R1_4_test_vector_our_pub_key[] = {
	0x1f, 0x65, 0xcf, 0x6e, 0x89, 0x78, 0xe1, 0xc1, 0xbc, 0x10, 0xbb, 0x61, 0xa7, 0xdb, 0x31, 0x1d, 0xe3, 0x10, 0x08, 0x8c, 0x8c, 0xf9, 0x76, 0x8b, 0xf7, 0xd4, 0x38, 0x16, 0x8e, 0x7f, 0x42, 0xab, 0x14, 0xb1, 0x6a, 0xf5, 0x3a, 0x7a, 0x2f, 0x64, 0x6f, 0xf4, 0x0b, 0x53, 0xd7, 0x4c, 0xbc, 0xc7,
};
static const u8 ecccdh_SECP192R1_4_test_vector_shared_secret[] = {
	0x71, 0x6e, 0x74, 0x3b, 0x1b, 0x37, 0xa2, 0xcd, 0x84, 0x79, 0xf0, 0xa3, 0xd5, 0xa7, 0x4c, 0x10, 0xba, 0x25, 0x99, 0xbe, 0x18, 0xd7, 0xe2, 0xf4,
};
static const ecdh_test_case ecccdh_SECP192R1_4_test_case = {
	.name = "ECCCDH/SECP192R1 4",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_4_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_4_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_4_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_4_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_4_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_4_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_4_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_4_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_5
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_5_test_vector_our_priv_key[] = {
	0xcf, 0x70, 0x35, 0x42, 0x26, 0x66, 0x73, 0x21, 0xd6, 0xe2, 0xba, 0xf4, 0x09, 0x99, 0xe2, 0xfd, 0x74, 0xc7, 0xa0, 0xf7, 0x93, 0xfa, 0x86, 0x99,
};
static const u8 ecccdh_SECP192R1_5_test_vector_peer_pub_key[] = {
	0xfb, 0x35, 0xca, 0x20, 0xd2, 0xe9, 0x66, 0x65, 0xc5, 0x1b, 0x98, 0xe8, 0xf6, 0xeb, 0x3d, 0x79, 0x11, 0x35, 0x08, 0xd8, 0xbc, 0xcd, 0x45, 0x16, 0x36, 0x8e, 0xec, 0x0d, 0x5b, 0xfb, 0x84, 0x77, 0x21, 0xdf, 0x6a, 0xaf, 0xf0, 0xe5, 0xd4, 0x8c, 0x44, 0x4f, 0x74, 0xbf, 0x9c, 0xd8, 0xa5, 0xa7,
};
static const u8 ecccdh_SECP192R1_5_test_vector_our_pub_key[] = {
	0x5f, 0x48, 0x44, 0xff, 0xcc, 0xe6, 0x10, 0x05, 0xd2, 0x4f, 0x73, 0x7d, 0xb9, 0x86, 0x75, 0xe9, 0x2f, 0x7b, 0x65, 0x43, 0xae, 0xb6, 0x10, 0x6c, 0x54, 0x24, 0xf5, 0x98, 0x13, 0x92, 0x15, 0xd3, 0x89, 0xb6, 0xb1, 0x2b, 0x86, 0xd5, 0x80, 0x14, 0x85, 0x7f, 0x2d, 0xda, 0xdb, 0x54, 0x0f, 0x51,
};
static const u8 ecccdh_SECP192R1_5_test_vector_shared_secret[] = {
	0xf6, 0x70, 0x53, 0xb9, 0x34, 0x45, 0x99, 0x85, 0xa3, 0x15, 0xcb, 0x01, 0x7b, 0xf0, 0x30, 0x28, 0x91, 0x79, 0x8d, 0x45, 0xd0, 0xe1, 0x95, 0x08,
};
static const ecdh_test_case ecccdh_SECP192R1_5_test_case = {
	.name = "ECCCDH/SECP192R1 5",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_5_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_5_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_5_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_5_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_5_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_5_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_5_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_5_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_6
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_6_test_vector_our_priv_key[] = {
	0xfe, 0x94, 0x25, 0x15, 0x23, 0x7f, 0xff, 0xdd, 0x7b, 0x4e, 0xb5, 0xc6, 0x49, 0x09, 0xee, 0xe4, 0x85, 0x6a, 0x07, 0x6c, 0xdf, 0x12, 0xba, 0xe2,
};
static const u8 ecccdh_SECP192R1_6_test_vector_peer_pub_key[] = {
	0x82, 0x47, 0x52, 0x96, 0x0c, 0x13, 0x07, 0xe5, 0xf1, 0x3a, 0x83, 0xda, 0x21, 0xc7, 0x99, 0x8c, 0xa8, 0xb5, 0xb0, 0x0b, 0x95, 0x49, 0xf6, 0xd0, 0xbc, 0x52, 0xd9, 0x1e, 0x23, 0x43, 0x63, 0xbc, 0x32, 0xee, 0x0b, 0x67, 0x78, 0xf2, 0x5c, 0xd8, 0xc1, 0x84, 0x75, 0x10, 0xf4, 0x34, 0x8b, 0x94,
};
static const u8 ecccdh_SECP192R1_6_test_vector_our_pub_key[] = {
	0xe6, 0x36, 0x9d, 0xf7, 0x9b, 0x20, 0x7b, 0x8b, 0x86, 0x79, 0xf7, 0xc8, 0x69, 0xcf, 0xc2, 0x64, 0x85, 0x9d, 0x1a, 0xb5, 0x5a, 0xa4, 0x01, 0xe8, 0x1f, 0x99, 0xc7, 0x1f, 0x80, 0x1a, 0x30, 0xb5, 0x2f, 0x74, 0xda, 0x6e, 0x5e, 0x6d, 0xbb, 0x62, 0xee, 0x4c, 0x5d, 0xa1, 0x09, 0x0c, 0xc0, 0x20,
};
static const u8 ecccdh_SECP192R1_6_test_vector_shared_secret[] = {
	0x75, 0x82, 0x29, 0x71, 0x19, 0x3e, 0xdd, 0x47, 0x2b, 0xf3, 0x01, 0x51, 0xa7, 0x82, 0x61, 0x9c, 0x55, 0xad, 0x0b, 0x27, 0x9c, 0x93, 0x03, 0xdd,
};
static const ecdh_test_case ecccdh_SECP192R1_6_test_case = {
	.name = "ECCCDH/SECP192R1 6",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_6_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_6_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_6_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_6_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_6_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_6_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_6_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_6_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_7
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_7_test_vector_our_priv_key[] = {
	0x33, 0xfe, 0xd1, 0x04, 0x92, 0xaf, 0xa5, 0xbe, 0xa0, 0x33, 0x3c, 0x0a, 0xf1, 0x2c, 0xac, 0x94, 0x0c, 0x4d, 0x22, 0x24, 0x55, 0xbc, 0xd0, 0xfe,
};
static const u8 ecccdh_SECP192R1_7_test_vector_peer_pub_key[] = {
	0x10, 0xbb, 0x57, 0x02, 0x02, 0x91, 0x14, 0x19, 0x81, 0xf8, 0x33, 0xb4, 0x74, 0x9e, 0x56, 0x11, 0x03, 0x4b, 0x30, 0x8e, 0x84, 0x01, 0x1d, 0x21, 0xe1, 0xca, 0xcd, 0x6b, 0x7b, 0xd1, 0x7e, 0xd8, 0xdd, 0xb5, 0x0b, 0x6a, 0xee, 0x06, 0x54, 0xc3, 0x5f, 0x2d, 0x0e, 0xdd, 0xc1, 0xcf, 0xfc, 0xf6,
};
static const u8 ecccdh_SECP192R1_7_test_vector_our_pub_key[] = {
	0xef, 0x0b, 0x28, 0xaf, 0xc4, 0x16, 0x37, 0xd7, 0x37, 0xf4, 0x2e, 0x4c, 0x8a, 0xac, 0xea, 0xdc, 0x84, 0xba, 0x2e, 0x0b, 0x84, 0x9c, 0xa1, 0x8c, 0x57, 0x79, 0x79, 0x42, 0xe5, 0x52, 0x17, 0x3b, 0xba, 0x17, 0xf7, 0x32, 0x78, 0xe0, 0x29, 0xf4, 0x23, 0x35, 0x06, 0x8b, 0xd7, 0x70, 0xdd, 0xf2,
};
static const u8 ecccdh_SECP192R1_7_test_vector_shared_secret[] = {
	0x67, 0xcb, 0xa2, 0xcb, 0xb6, 0x9e, 0xe7, 0x8b, 0xf1, 0xab, 0xaf, 0xb0, 0xe6, 0xfb, 0xe3, 0x3f, 0xa2, 0x09, 0x4c, 0x12, 0x8d, 0x59, 0x65, 0x2d,
};
static const ecdh_test_case ecccdh_SECP192R1_7_test_case = {
	.name = "ECCCDH/SECP192R1 7",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_7_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_7_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_7_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_7_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_7_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_7_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_7_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_7_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_8
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_8_test_vector_our_priv_key[] = {
	0xf3, 0x55, 0x7c, 0x5d, 0x70, 0xb4, 0xc7, 0x95, 0x49, 0x60, 0xc3, 0x35, 0x68, 0x77, 0x6a, 0xdb, 0xe8, 0xe4, 0x36, 0x19, 0xab, 0xe2, 0x6b, 0x13,
};
static const u8 ecccdh_SECP192R1_8_test_vector_peer_pub_key[] = {
	0x51, 0x92, 0xfc, 0xe4, 0x18, 0x5a, 0x77, 0x58, 0xea, 0x1b, 0xc5, 0x6e, 0x0e, 0x4f, 0x4e, 0x8b, 0x2d, 0xce, 0x32, 0x34, 0x8d, 0x0d, 0xce, 0xd1, 0x20, 0x98, 0x99, 0x81, 0xbe, 0xaa, 0xf0, 0x00, 0x6d, 0x88, 0xa9, 0x6e, 0x79, 0x71, 0xa2, 0xfa, 0x3a, 0x33, 0xba, 0x46, 0x04, 0x7f, 0xc7, 0xba,
};
static const u8 ecccdh_SECP192R1_8_test_vector_our_pub_key[] = {
	0xd7, 0x01, 0x12, 0xc5, 0xf0, 0xf0, 0x84, 0x43, 0x86, 0x49, 0x4a, 0xc1, 0xad, 0x99, 0xdc, 0xe2, 0x21, 0x41, 0x34, 0x17, 0x6e, 0xbf, 0xb9, 0xaf, 0xd3, 0xc1, 0x87, 0xa0, 0x38, 0x51, 0x0a, 0xb3, 0x1d, 0x45, 0x9e, 0x2b, 0x7a, 0xf1, 0xa3, 0x80, 0xdd, 0x75, 0x76, 0xaf, 0x06, 0x26, 0x75, 0x48,
};
static const u8 ecccdh_SECP192R1_8_test_vector_shared_secret[] = {
	0xcf, 0x99, 0xa2, 0x77, 0x0a, 0x38, 0x6c, 0xa0, 0x13, 0x7d, 0x1e, 0xca, 0x0a, 0x22, 0x6e, 0x48, 0x42, 0x97, 0xac, 0x3c, 0x51, 0x3f, 0x36, 0x31,
};
static const ecdh_test_case ecccdh_SECP192R1_8_test_case = {
	.name = "ECCCDH/SECP192R1 8",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_8_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_8_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_8_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_8_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_8_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_8_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_8_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_8_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_9
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_9_test_vector_our_priv_key[] = {
	0x58, 0x6c, 0xfb, 0xa1, 0xc6, 0xe8, 0x17, 0x66, 0xed, 0x52, 0x82, 0x8f, 0x17, 0x7b, 0x1b, 0xe1, 0x4e, 0xbb, 0xc5, 0xb8, 0x33, 0x48, 0xc3, 0x11,
};
static const u8 ecccdh_SECP192R1_9_test_vector_peer_pub_key[] = {
	0x26, 0xd0, 0x19, 0xdb, 0xe2, 0x79, 0xea, 0xd0, 0x1e, 0xed, 0x14, 0x3a, 0x91, 0x60, 0x1a, 0xda, 0x26, 0xe2, 0xf4, 0x22, 0x25, 0xb1, 0xc6, 0x2b, 0x6c, 0xa6, 0x53, 0xf0, 0x82, 0x72, 0xe0, 0x38, 0x6f, 0xc9, 0x42, 0x1f, 0xbd, 0x58, 0x00, 0x93, 0xd7, 0xae, 0x63, 0x01, 0xbc, 0xa9, 0x44, 0x76,
};
static const u8 ecccdh_SECP192R1_9_test_vector_our_pub_key[] = {
	0x58, 0xb3, 0xc6, 0x3e, 0x56, 0xbe, 0xc9, 0xd6, 0x96, 0xbf, 0x9a, 0x88, 0xdf, 0x28, 0x73, 0x73, 0x83, 0x91, 0xf7, 0x63, 0x68, 0xaa, 0x2b, 0x49, 0x57, 0x76, 0x77, 0x3b, 0x26, 0x1f, 0xaf, 0x7b, 0xa2, 0xfd, 0xc4, 0xfe, 0x43, 0xb9, 0x2c, 0x0b, 0x1c, 0x7a, 0x2f, 0xd0, 0x54, 0xa4, 0x36, 0x50,
};
static const u8 ecccdh_SECP192R1_9_test_vector_shared_secret[] = {
	0x57, 0x63, 0x31, 0xe2, 0xb4, 0xfb, 0x38, 0xa1, 0x12, 0x81, 0x0e, 0x15, 0x29, 0x83, 0x4d, 0xe8, 0x30, 0x7f, 0xb0, 0xa0, 0xd2, 0x75, 0x68, 0x77,
};
static const ecdh_test_case ecccdh_SECP192R1_9_test_case = {
	.name = "ECCCDH/SECP192R1 9",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_9_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_9_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_9_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_9_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_9_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_9_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_9_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_9_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_10
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_10_test_vector_our_priv_key[] = {
	0xca, 0xd8, 0x10, 0x06, 0x03, 0xa4, 0xf6, 0x5b, 0xe0, 0x8d, 0x8f, 0xc8, 0xa1, 0xb7, 0xe8, 0x84, 0xc5, 0xff, 0x65, 0xde, 0xb3, 0xc9, 0x6d, 0x99,
};
static const u8 ecccdh_SECP192R1_10_test_vector_peer_pub_key[] = {
	0x53, 0x9b, 0xc4, 0x0f, 0xe2, 0x0a, 0x0f, 0xb2, 0x67, 0x88, 0x8b, 0x64, 0x7b, 0x03, 0xea, 0xaf, 0x6e, 0xc2, 0x0c, 0x02, 0xa1, 0xe1, 0xf8, 0xc8, 0x69, 0x09, 0x5e, 0x5b, 0xb7, 0xb4, 0xd4, 0x4c, 0x32, 0x78, 0xa7, 0xee, 0x6b, 0xec, 0xa3, 0x97, 0xc4, 0x52, 0x46, 0xda, 0x9a, 0x34, 0xc8, 0xbe,
};
static const u8 ecccdh_SECP192R1_10_test_vector_our_pub_key[] = {
	0xb7, 0xfc, 0xc0, 0xf5, 0x2c, 0x7a, 0x41, 0x1e, 0xdb, 0xed, 0x39, 0xe1, 0x0b, 0xf0, 0x2b, 0x6a, 0xe0, 0xf2, 0x66, 0x14, 0xc6, 0xb3, 0x25, 0xa2, 0x47, 0x48, 0x3b, 0x26, 0xeb, 0x67, 0x77, 0x6d, 0xe2, 0xb9, 0x3a, 0xb7, 0x11, 0x9d, 0x54, 0x47, 0x57, 0x37, 0x39, 0xe3, 0xd5, 0x5e, 0x72, 0xfb,
};
static const u8 ecccdh_SECP192R1_10_test_vector_shared_secret[] = {
	0x90, 0x2f, 0x45, 0x01, 0x91, 0x6a, 0x0d, 0xd9, 0x45, 0x55, 0x4c, 0x3a, 0x37, 0xb3, 0xd7, 0x80, 0xd3, 0x75, 0xa6, 0xda, 0x71, 0x31, 0x97, 0xc4,
};
static const ecdh_test_case ecccdh_SECP192R1_10_test_case = {
	.name = "ECCCDH/SECP192R1 10",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_10_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_10_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_10_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_10_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_10_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_10_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_10_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_10_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_11
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_11_test_vector_our_priv_key[] = {
	0x1e, 0xdd, 0x87, 0x9c, 0xc5, 0xc7, 0x96, 0x19, 0xca, 0xe6, 0xc7, 0x3a, 0x69, 0x1b, 0xd5, 0xa0, 0x39, 0x5c, 0x0e, 0xf3, 0xb3, 0x56, 0xfc, 0xd2,
};
static const u8 ecccdh_SECP192R1_11_test_vector_peer_pub_key[] = {
	0x5d, 0x34, 0x3d, 0xdb, 0x96, 0x31, 0x8f, 0xb4, 0x79, 0x4d, 0x10, 0xf6, 0xc5, 0x73, 0xf9, 0x9f, 0xee, 0x5d, 0x0d, 0x57, 0xb9, 0x96, 0x25, 0x0f, 0x99, 0xfb, 0xdf, 0x9d, 0x97, 0xdd, 0x88, 0xad, 0x41, 0x02, 0x35, 0xda, 0xc3, 0x6e, 0x5b, 0x92, 0xce, 0x28, 0x24, 0xb8, 0xe5, 0x87, 0xa8, 0x2c,
};
static const u8 ecccdh_SECP192R1_11_test_vector_our_pub_key[] = {
	0x6c, 0xe6, 0xad, 0xb2, 0xc3, 0x08, 0x08, 0xf5, 0x90, 0x04, 0x8c, 0x33, 0xdf, 0xfa, 0xd4, 0x52, 0x4e, 0xbf, 0x7a, 0x5f, 0xd3, 0x9b, 0x74, 0x7b, 0x49, 0x66, 0xbd, 0x2f, 0x3d, 0x00, 0x56, 0x9b, 0x4d, 0x4c, 0x04, 0x09, 0xfb, 0xd7, 0xa2, 0xdb, 0x75, 0x2f, 0x6d, 0x09, 0xbc, 0xa8, 0xc2, 0x5f,
};
static const u8 ecccdh_SECP192R1_11_test_vector_shared_secret[] = {
	0x46, 0xe4, 0xde, 0x33, 0x50, 0x54, 0xd4, 0x29, 0x86, 0x32, 0x18, 0xae, 0x33, 0x63, 0x6f, 0xc9, 0xb8, 0x9c, 0x62, 0x8b, 0x64, 0xb5, 0x06, 0xc7,
};
static const ecdh_test_case ecccdh_SECP192R1_11_test_case = {
	.name = "ECCCDH/SECP192R1 11",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_11_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_11_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_11_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_11_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_11_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_11_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_11_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_11_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_12
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_12_test_vector_our_priv_key[] = {
	0x46, 0x0e, 0x45, 0x22, 0x73, 0xfe, 0x18, 0x27, 0x60, 0x21, 0x87, 0xad, 0x3b, 0xeb, 0xee, 0x65, 0xcb, 0x84, 0x42, 0x3b, 0xb4, 0xf4, 0x75, 0x37,
};
static const u8 ecccdh_SECP192R1_12_test_vector_peer_pub_key[] = {
	0x8d, 0x3d, 0xb9, 0xbd, 0xce, 0x13, 0x7f, 0xfb, 0xfb, 0x89, 0x13, 0x88, 0xc3, 0x7d, 0xf6, 0xc0, 0xcb, 0xc9, 0x0a, 0xa5, 0xe5, 0x37, 0x62, 0x20, 0x13, 0x5d, 0x30, 0xb5, 0xcb, 0x66, 0x0e, 0xef, 0x87, 0x64, 0xff, 0xc7, 0x44, 0xf1, 0x5c, 0x1b, 0x5d, 0x6d, 0xc0, 0x6b, 0xa4, 0x41, 0x6d, 0x37,
};
static const u8 ecccdh_SECP192R1_12_test_vector_our_pub_key[] = {
	0xd1, 0xbd, 0x3a, 0x3e, 0xfa, 0xbf, 0x47, 0x67, 0xfe, 0x63, 0x80, 0xbd, 0xf0, 0xdb, 0xf4, 0x9d, 0x52, 0xd4, 0xcf, 0x0c, 0xbb, 0x89, 0x40, 0x4c, 0xc1, 0x50, 0xc2, 0xb4, 0xc8, 0xb3, 0xaa, 0x35, 0xf7, 0x65, 0xf8, 0x47, 0xe4, 0xf7, 0xf8, 0xfd, 0x87, 0x04, 0xd2, 0x41, 0xa1, 0x81, 0xee, 0x99,
};
static const u8 ecccdh_SECP192R1_12_test_vector_shared_secret[] = {
	0x1b, 0xfe, 0x9e, 0x5a, 0x20, 0xac, 0x7a, 0x38, 0xd8, 0xf6, 0x05, 0xb4, 0x25, 0xbb, 0x90, 0x30, 0xbe, 0x31, 0xef, 0x97, 0xc1, 0x01, 0xc7, 0x6c,
};
static const ecdh_test_case ecccdh_SECP192R1_12_test_case = {
	.name = "ECCCDH/SECP192R1 12",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_12_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_12_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_12_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_12_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_12_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_12_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_12_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_12_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_13
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_13_test_vector_our_priv_key[] = {
	0xb9, 0x70, 0x36, 0x50, 0x08, 0x45, 0x6f, 0x87, 0x58, 0xec, 0xc5, 0xa3, 0xb3, 0x3c, 0xf3, 0xae, 0x6a, 0x8d, 0x56, 0x81, 0x07, 0xa5, 0x21, 0x67,
};
static const u8 ecccdh_SECP192R1_13_test_vector_peer_pub_key[] = {
	0x9e, 0x0a, 0x69, 0x49, 0x51, 0x9c, 0x7f, 0x5b, 0xe6, 0x8c, 0x04, 0x33, 0xc5, 0xfd, 0xf1, 0x30, 0x64, 0xaa, 0x13, 0xfb, 0x29, 0x48, 0x3d, 0xc3, 0xe1, 0xc8, 0xba, 0x63, 0xe1, 0xf4, 0x71, 0xdb, 0x23, 0x18, 0x5f, 0x50, 0xd9, 0xc8, 0x71, 0xed, 0xea, 0x21, 0x25, 0x5b, 0x3a, 0x63, 0xb4, 0xb7,
};
static const u8 ecccdh_SECP192R1_13_test_vector_our_pub_key[] = {
	0xc1, 0xb8, 0x61, 0x0c, 0x8c, 0x63, 0xf8, 0xd4, 0xab, 0xda, 0x09, 0x3b, 0x9a, 0x11, 0xa5, 0x66, 0x04, 0x4b, 0xf6, 0x5c, 0x6f, 0xaa, 0x89, 0x99, 0xa5, 0xbc, 0x4b, 0x3c, 0xa0, 0x95, 0x38, 0x2e, 0x97, 0x38, 0xae, 0xe9, 0x5f, 0xe9, 0x47, 0x9b, 0x17, 0x87, 0x9b, 0x3a, 0xd5, 0x29, 0x55, 0x59,
};
static const u8 ecccdh_SECP192R1_13_test_vector_shared_secret[] = {
	0x0e, 0x8c, 0x49, 0x3a, 0x4a, 0xdc, 0x44, 0x5d, 0xc9, 0x28, 0x8a, 0x3b, 0x9b, 0x27, 0x25, 0x99, 0x22, 0x40, 0x54, 0x59, 0x2d, 0x72, 0x65, 0xb3,
};
static const ecdh_test_case ecccdh_SECP192R1_13_test_case = {
	.name = "ECCCDH/SECP192R1 13",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_13_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_13_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_13_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_13_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_13_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_13_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_13_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_13_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_14
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_14_test_vector_our_priv_key[] = {
	0x59, 0xc1, 0x5b, 0x8a, 0x24, 0x64, 0xe4, 0x1d, 0xfe, 0x43, 0x71, 0xc7, 0xf7, 0xda, 0xdf, 0x47, 0x0a, 0xe4, 0x25, 0x54, 0x4f, 0x81, 0x13, 0xbd,
};
static const u8 ecccdh_SECP192R1_14_test_vector_peer_pub_key[] = {
	0xbe, 0x08, 0x82, 0x38, 0x90, 0x2e, 0x99, 0x39, 0xb3, 0xd0, 0x54, 0xee, 0xeb, 0x84, 0x92, 0xda, 0xf4, 0xbd, 0xcf, 0x09, 0xa2, 0xab, 0x77, 0xf1, 0x58, 0xd6, 0x74, 0x9a, 0x3a, 0x92, 0x3d, 0xc8, 0x04, 0x40, 0xf2, 0x66, 0x1f, 0xd3, 0x5b, 0x65, 0x16, 0x17, 0xe6, 0x52, 0x94, 0xb4, 0x63, 0x75,
};
static const u8 ecccdh_SECP192R1_14_test_vector_our_pub_key[] = {
	0x1f, 0xe7, 0x76, 0xf7, 0x35, 0x67, 0xb6, 0xac, 0x0b, 0x0d, 0x67, 0x64, 0x16, 0x4d, 0xe6, 0xc5, 0xbe, 0x75, 0x1b, 0xa8, 0xd1, 0xff, 0x45, 0x5e, 0x4c, 0x16, 0x0b, 0xf3, 0x8a, 0xfb, 0x2b, 0x71, 0xf6, 0x84, 0x26, 0x16, 0x64, 0x11, 0x5c, 0xe8, 0x74, 0x55, 0x3e, 0x8b, 0x05, 0x94, 0x32, 0xd2,
};
static const u8 ecccdh_SECP192R1_14_test_vector_shared_secret[] = {
	0x0f, 0x19, 0x91, 0x08, 0x6b, 0x45, 0x5d, 0xed, 0x6a, 0x1c, 0x41, 0x46, 0xf7, 0xbf, 0x59, 0xfe, 0x9b, 0x49, 0x5d, 0xe5, 0x66, 0xeb, 0xc6, 0xbf,
};
static const ecdh_test_case ecccdh_SECP192R1_14_test_case = {
	.name = "ECCCDH/SECP192R1 14",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_14_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_14_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_14_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_14_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_14_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_14_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_14_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_14_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_15
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_15_test_vector_our_priv_key[] = {
	0xa6, 0xe9, 0xb8, 0x85, 0xc6, 0x6b, 0x95, 0x9d, 0x1f, 0xc2, 0x70, 0x8d, 0x59, 0x1b, 0x6d, 0x32, 0x28, 0xe4, 0x9e, 0xb9, 0x8f, 0x72, 0x6d, 0x61,
};
static const u8 ecccdh_SECP192R1_15_test_vector_peer_pub_key[] = {
	0xbf, 0x5a, 0xe0, 0x50, 0x25, 0xe1, 0xbe, 0x61, 0x7e, 0x66, 0x6d, 0x87, 0xa4, 0x16, 0x83, 0x63, 0x87, 0x3d, 0x57, 0x61, 0xb3, 0x76, 0xb5, 0x03, 0xe1, 0xe6, 0xe3, 0x8b, 0x37, 0x2b, 0x6b, 0xee, 0x0f, 0xf5, 0xb3, 0x50, 0x2d, 0x83, 0x73, 0x5e, 0x3b, 0x2c, 0x26, 0x82, 0x5e, 0x4f, 0x0f, 0xcc,
};
static const u8 ecccdh_SECP192R1_15_test_vector_our_pub_key[] = {
	0x63, 0x2b, 0xb7, 0x65, 0x1d, 0xbf, 0x49, 0xdd, 0xe9, 0xdd, 0x12, 0x5d, 0x13, 0xfb, 0x23, 0x4e, 0x06, 0x61, 0x77, 0x23, 0xbe, 0xed, 0x3d, 0x1b, 0xf4, 0xad, 0x52, 0x09, 0x63, 0x84, 0x88, 0x39, 0x7c, 0x5f, 0x44, 0xf9, 0x94, 0xdd, 0x74, 0x79, 0x80, 0x7e, 0x79, 0xf4, 0x88, 0x7d, 0x2e, 0x71,
};
static const u8 ecccdh_SECP192R1_15_test_vector_shared_secret[] = {
	0xb3, 0x0f, 0x21, 0x27, 0xc3, 0x4d, 0xf3, 0x5a, 0xaa, 0x91, 0xdb, 0xf0, 0xbb, 0xe1, 0x57, 0x98, 0xe7, 0x99, 0xa0, 0x3e, 0xd1, 0x16, 0x98, 0xc1,
};
static const ecdh_test_case ecccdh_SECP192R1_15_test_case = {
	.name = "ECCCDH/SECP192R1 15",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_15_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_15_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_15_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_15_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_15_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_15_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_15_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_15_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_16
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_16_test_vector_our_priv_key[] = {
	0xbd, 0xb7, 0x54, 0x09, 0x6f, 0xfb, 0xfb, 0xd8, 0xb0, 0xf3, 0xcb, 0x04, 0x6c, 0xcb, 0x7c, 0xa1, 0x49, 0xc4, 0xe7, 0x19, 0x20, 0x67, 0xa3, 0xee,
};
static const u8 ecccdh_SECP192R1_16_test_vector_peer_pub_key[] = {
	0x6c, 0xc4, 0xfe, 0xed, 0x84, 0xc7, 0xab, 0x0d, 0x09, 0x00, 0x5d, 0x66, 0x0e, 0xd3, 0x4d, 0xe6, 0x95, 0x5a, 0x94, 0x61, 0xc4, 0x13, 0x8d, 0x11, 0x31, 0x22, 0x5f, 0x33, 0x86, 0x4e, 0xd4, 0x8d, 0xa0, 0x6f, 0xa4, 0x5a, 0x91, 0x3b, 0x46, 0xcf, 0x42, 0x55, 0x77, 0x42, 0xe3, 0x50, 0x85, 0xe6,
};
static const u8 ecccdh_SECP192R1_16_test_vector_our_pub_key[] = {
	0xd9, 0xc0, 0x98, 0xd4, 0x21, 0xd7, 0x41, 0xf6, 0xfa, 0xab, 0x11, 0x6f, 0x3e, 0x47, 0x31, 0xd2, 0x8c, 0x55, 0x58, 0xe1, 0x9f, 0xe1, 0x12, 0xa1, 0x38, 0xd4, 0xdc, 0x48, 0xcc, 0xdb, 0x1d, 0x3e, 0xd8, 0xd3, 0x1f, 0xd0, 0x67, 0x84, 0xa4, 0xf8, 0x7a, 0x68, 0xae, 0xc1, 0xcb, 0xd5, 0xb0, 0x8f,
};
static const u8 ecccdh_SECP192R1_16_test_vector_shared_secret[] = {
	0x64, 0xa5, 0xc2, 0x46, 0x59, 0x9d, 0x3e, 0x81, 0x77, 0xa2, 0x40, 0x2a, 0x11, 0x10, 0xeb, 0x81, 0xe6, 0xc4, 0x56, 0xab, 0x4e, 0xdb, 0x51, 0x27,
};
static const ecdh_test_case ecccdh_SECP192R1_16_test_case = {
	.name = "ECCCDH/SECP192R1 16",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_16_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_16_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_16_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_16_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_16_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_16_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_16_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_16_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_17
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_17_test_vector_our_priv_key[] = {
	0xd5, 0xbc, 0xf2, 0x53, 0x4d, 0xaf, 0xc3, 0xd9, 0x99, 0x64, 0xc7, 0xbd, 0x63, 0xab, 0x7b, 0xd1, 0x59, 0x99, 0xfe, 0x56, 0xdd, 0x96, 0x9c, 0x42,
};
static const u8 ecccdh_SECP192R1_17_test_vector_peer_pub_key[] = {
	0x36, 0x15, 0x73, 0x15, 0xbe, 0xe7, 0xaf, 0xed, 0xde, 0xd5, 0x8c, 0x4e, 0x8b, 0xa1, 0x4d, 0x34, 0x21, 0xc4, 0x01, 0xe5, 0x11, 0x35, 0xbc, 0xc9, 0x37, 0xc2, 0x97, 0xca, 0x70, 0x3f, 0x77, 0xc5, 0x2b, 0xb0, 0x62, 0xd8, 0xce, 0x97, 0x1d, 0xb8, 0x40, 0x97, 0xba, 0x0c, 0x75, 0x3a, 0x41, 0x8f,
};
static const u8 ecccdh_SECP192R1_17_test_vector_our_pub_key[] = {
	0xfd, 0xa1, 0xd5, 0xd2, 0x8d, 0x6f, 0xe0, 0xe7, 0x90, 0x9d, 0x6a, 0x8b, 0xaf, 0xa7, 0x82, 0x4d, 0xb5, 0x57, 0x2a, 0xb9, 0x2f, 0xfe, 0x7d, 0xe6, 0x13, 0x4a, 0x29, 0x7c, 0x1d, 0x9c, 0x8b, 0xba, 0xb2, 0x49, 0xab, 0xac, 0xd9, 0x51, 0xed, 0x11, 0xe5, 0xa9, 0x9f, 0x92, 0xe7, 0x99, 0x15, 0x72,
};
static const u8 ecccdh_SECP192R1_17_test_vector_shared_secret[] = {
	0x01, 0x7b, 0x8c, 0xa5, 0x3c, 0x82, 0xfa, 0xb1, 0x63, 0xda, 0x2a, 0xb7, 0x83, 0x96, 0x6a, 0x39, 0xe0, 0x61, 0xb3, 0x2c, 0x8c, 0xfa, 0x33, 0x4d,
};
static const ecdh_test_case ecccdh_SECP192R1_17_test_case = {
	.name = "ECCCDH/SECP192R1 17",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_17_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_17_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_17_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_17_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_17_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_17_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_17_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_17_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_18
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_18_test_vector_our_priv_key[] = {
	0x43, 0xd4, 0xb9, 0xdf, 0x10, 0x53, 0xbe, 0x5b, 0x42, 0x68, 0x10, 0x4c, 0x02, 0x24, 0x4d, 0x3b, 0xf9, 0x59, 0x4b, 0x01, 0x0b, 0x46, 0xa8, 0xb2,
};
static const u8 ecccdh_SECP192R1_18_test_vector_peer_pub_key[] = {
	0x98, 0x46, 0x4d, 0x47, 0xf0, 0x25, 0x6f, 0x82, 0x92, 0xe0, 0x27, 0xe8, 0xc9, 0x25, 0x82, 0xea, 0x77, 0xcf, 0x90, 0x51, 0xf5, 0xce, 0x8e, 0x5d, 0x44, 0x95, 0x52, 0xef, 0x75, 0x78, 0xbe, 0x96, 0x23, 0x6f, 0xe5, 0xed, 0x9d, 0x06, 0x43, 0xc0, 0xbb, 0x6c, 0x5a, 0x91, 0x34, 0xb0, 0x10, 0x8d,
};
static const u8 ecccdh_SECP192R1_18_test_vector_our_pub_key[] = {
	0xc3, 0x02, 0x0b, 0x70, 0x91, 0x46, 0x3d, 0x78, 0x8f, 0x1f, 0x1d, 0x76, 0xf7, 0xcf, 0xee, 0xc8, 0x2e, 0xcd, 0xb3, 0xb7, 0xd9, 0x9c, 0x34, 0x5c, 0x9a, 0x77, 0x10, 0xd5, 0x17, 0x95, 0x91, 0xd8, 0xf3, 0xdf, 0x0a, 0xa1, 0x22, 0x30, 0x17, 0x68, 0xae, 0x7d, 0xb7, 0xee, 0xe2, 0xd7, 0xf5, 0x83,
};
static const u8 ecccdh_SECP192R1_18_test_vector_shared_secret[] = {
	0x34, 0x0e, 0xf3, 0xdb, 0x3d, 0xbe, 0xbd, 0xd9, 0x1c, 0x62, 0xc3, 0xd4, 0xe1, 0xa3, 0xda, 0x2c, 0x7c, 0x52, 0xa3, 0x33, 0x8b, 0x86, 0x52, 0x59,
};
static const ecdh_test_case ecccdh_SECP192R1_18_test_case = {
	.name = "ECCCDH/SECP192R1 18",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_18_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_18_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_18_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_18_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_18_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_18_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_18_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_18_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_19
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_19_test_vector_our_priv_key[] = {
	0x94, 0xca, 0xc2, 0xc2, 0xca, 0x71, 0x47, 0x46, 0x40, 0x16, 0x70, 0xd9, 0x4e, 0xdb, 0xf3, 0xf6, 0x77, 0x86, 0x7b, 0x5a, 0x03, 0xbe, 0xe7, 0xad,
};
static const u8 ecccdh_SECP192R1_19_test_vector_peer_pub_key[] = {
	0x56, 0x3e, 0xb6, 0x6c, 0x33, 0x4c, 0xf6, 0xf1, 0x23, 0xbf, 0x04, 0xc7, 0x80, 0x3b, 0x48, 0xa3, 0x11, 0x02, 0x14, 0x23, 0x7e, 0x98, 0x3b, 0xf5, 0x0f, 0x35, 0x11, 0x04, 0x81, 0x91, 0x99, 0xef, 0x07, 0xc9, 0xa6, 0x05, 0x1d, 0x20, 0x75, 0x8f, 0x3a, 0xf7, 0x90, 0x27, 0xea, 0x66, 0xa5, 0x3f,
};
static const u8 ecccdh_SECP192R1_19_test_vector_our_pub_key[] = {
	0xb1, 0x85, 0x54, 0xa2, 0xe7, 0x43, 0xef, 0x0a, 0xa2, 0xf0, 0x40, 0x98, 0x7c, 0x4c, 0x45, 0x10, 0x04, 0xe0, 0x96, 0xdf, 0x3d, 0x80, 0xdd, 0xae, 0x6e, 0x3e, 0x2c, 0x61, 0x8f, 0x89, 0x6e, 0x36, 0xba, 0x62, 0x00, 0x77, 0x68, 0x4b, 0x70, 0xa0, 0x5f, 0xfb, 0x79, 0xbf, 0x5e, 0x6c, 0x76, 0x40,
};
static const u8 ecccdh_SECP192R1_19_test_vector_shared_secret[] = {
	0x21, 0x62, 0x14, 0x49, 0x21, 0xdf, 0x51, 0x03, 0xd0, 0xe6, 0xa6, 0x50, 0xfb, 0x13, 0xfd, 0x24, 0x6f, 0x47, 0x38, 0xd0, 0x89, 0x6c, 0xe9, 0x2f,
};
static const ecdh_test_case ecccdh_SECP192R1_19_test_case = {
	.name = "ECCCDH/SECP192R1 19",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_19_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_19_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_19_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_19_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_19_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_19_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_19_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_19_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_20
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_20_test_vector_our_priv_key[] = {
	0x2a, 0x3a, 0x9e, 0x33, 0xc8, 0xcc, 0x31, 0x07, 0xa9, 0xf9, 0x26, 0x5c, 0x3b, 0xde, 0xa1, 0x20, 0x65, 0x70, 0xe8, 0x6f, 0x92, 0xac, 0x70, 0x14,
};
static const u8 ecccdh_SECP192R1_20_test_vector_peer_pub_key[] = {
	0x86, 0x82, 0x8c, 0x4a, 0xc9, 0x2b, 0x55, 0x07, 0x61, 0x8a, 0xec, 0x78, 0x73, 0xa1, 0xd4, 0xfc, 0x65, 0x43, 0xc5, 0xbe, 0x33, 0xcf, 0x30, 0x78, 0xb2, 0x2c, 0xa7, 0x24, 0x37, 0x54, 0x5e, 0x10, 0xd6, 0xd4, 0xf0, 0x52, 0x42, 0x2e, 0xb8, 0x98, 0xb7, 0x37, 0xa4, 0xb8, 0x54, 0x3e, 0xe5, 0x50,
};
static const u8 ecccdh_SECP192R1_20_test_vector_our_pub_key[] = {
	0xa7, 0xba, 0x38, 0xbe, 0x1b, 0xc6, 0x69, 0xdd, 0x23, 0xcc, 0xfc, 0xee, 0x06, 0x45, 0xb1, 0xf0, 0xdb, 0x8c, 0xf9, 0x42, 0xde, 0xaf, 0xae, 0xb6, 0xb8, 0x2d, 0xb7, 0x9d, 0x80, 0xcd, 0x0e, 0x37, 0xf2, 0x8d, 0x41, 0x63, 0xad, 0xc3, 0x89, 0xde, 0xe8, 0xfc, 0x77, 0x97, 0xb5, 0xc9, 0x83, 0x1b,
};
static const u8 ecccdh_SECP192R1_20_test_vector_shared_secret[] = {
	0x4c, 0x69, 0xe7, 0xfe, 0xed, 0x4b, 0x11, 0x15, 0x9a, 0xdf, 0xc1, 0x6a, 0x60, 0x47, 0xa9, 0x25, 0x72, 0xea, 0x44, 0xe0, 0x74, 0x0b, 0x23, 0xaf,
};
static const ecdh_test_case ecccdh_SECP192R1_20_test_case = {
	.name = "ECCCDH/SECP192R1 20",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_20_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_20_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_20_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_20_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_20_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_20_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_20_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_20_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_21
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_21_test_vector_our_priv_key[] = {
	0x4a, 0x6b, 0x78, 0xa9, 0x8a, 0xc9, 0x8f, 0xa8, 0xe9, 0x9a, 0x8e, 0xce, 0x08, 0xec, 0x02, 0x51, 0x12, 0x5f, 0x85, 0xc6, 0xfd, 0x0e, 0x28, 0x9b,
};
static const u8 ecccdh_SECP192R1_21_test_vector_peer_pub_key[] = {
	0x67, 0x00, 0xa1, 0x02, 0x43, 0x77, 0x81, 0xa9, 0x58, 0x1d, 0xa2, 0xbc, 0x25, 0xce, 0xd5, 0xab, 0xf4, 0x19, 0xda, 0x91, 0xd3, 0xc8, 0x03, 0xdf, 0x71, 0x39, 0x6c, 0x9c, 0xf0, 0x8b, 0xcd, 0x91, 0x85, 0x4e, 0x3e, 0x6e, 0x42, 0xd8, 0xc6, 0x57, 0xce, 0x0f, 0x27, 0xab, 0x77, 0xa9, 0xdc, 0x4b,
};
static const u8 ecccdh_SECP192R1_21_test_vector_our_pub_key[] = {
	0xe7, 0x69, 0xdb, 0xbc, 0xd5, 0xce, 0x2d, 0x83, 0x51, 0x4b, 0x76, 0x8d, 0x3d, 0x2d, 0x5a, 0xa0, 0xbc, 0xd8, 0xf6, 0x6a, 0xf1, 0x5f, 0x55, 0x00, 0x2f, 0xc6, 0xd0, 0xb0, 0x39, 0xe0, 0xf2, 0x8f, 0x74, 0xfb, 0xef, 0xfe, 0x9e, 0x88, 0x3d, 0x4d, 0xd7, 0x22, 0x96, 0xe4, 0xe9, 0x5c, 0xae, 0x71,
};
static const u8 ecccdh_SECP192R1_21_test_vector_shared_secret[] = {
	0x46, 0x07, 0x2a, 0xce, 0xfd, 0x67, 0xbf, 0xf5, 0x0d, 0xe3, 0x55, 0xca, 0x7a, 0x31, 0xfa, 0x6b, 0xe5, 0x9f, 0x26, 0xe4, 0x67, 0x58, 0x72, 0x59,
};
static const ecdh_test_case ecccdh_SECP192R1_21_test_case = {
	.name = "ECCCDH/SECP192R1 21",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_21_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_21_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_21_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_21_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_21_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_21_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_21_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_21_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_22
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_22_test_vector_our_priv_key[] = {
	0xc5, 0xa6, 0x49, 0x1d, 0x78, 0x84, 0x4d, 0x66, 0x17, 0xef, 0x33, 0xbe, 0x6b, 0x8b, 0xd5, 0x4d, 0xa2, 0x21, 0x45, 0x08, 0x85, 0xd5, 0x95, 0x0f,
};
static const u8 ecccdh_SECP192R1_22_test_vector_peer_pub_key[] = {
	0xa8, 0x2f, 0x35, 0x4c, 0xf9, 0x7b, 0xee, 0x5d, 0x22, 0xdc, 0x6c, 0x07, 0x9f, 0x29, 0x02, 0xea, 0xd4, 0x4d, 0x96, 0xa8, 0xf6, 0x14, 0xf1, 0x78, 0xa6, 0x54, 0xa9, 0xaa, 0x8a, 0x1a, 0x08, 0x02, 0xf2, 0xce, 0x0e, 0xe8, 0xa0, 0xf4, 0xeb, 0xe9, 0x6d, 0xee, 0x1b, 0x37, 0x46, 0x4b, 0x1f, 0xf2,
};
static const u8 ecccdh_SECP192R1_22_test_vector_our_pub_key[] = {
	0xdb, 0x1b, 0x24, 0xf7, 0x46, 0x6b, 0xc1, 0x54, 0xe9, 0xd7, 0xd2, 0xc3, 0xca, 0x52, 0xdc, 0xfe, 0x0b, 0xfc, 0x95, 0x63, 0xc5, 0xfd, 0xb6, 0xf3, 0x1c, 0x74, 0xfb, 0xbf, 0x5b, 0xd9, 0x99, 0x21, 0xf1, 0xa9, 0xa7, 0x44, 0xf8, 0xe1, 0xcf, 0x77, 0x0b, 0xd6, 0xa7, 0x6a, 0x77, 0x2b, 0x30, 0x03,
};
static const u8 ecccdh_SECP192R1_22_test_vector_shared_secret[] = {
	0xec, 0x55, 0x80, 0xea, 0xbc, 0xa9, 0xf3, 0x38, 0x9d, 0x2b, 0x42, 0x7d, 0xdf, 0x6e, 0x49, 0xe2, 0x6d, 0x62, 0x9a, 0xfd, 0x03, 0xfa, 0x76, 0x6e,
};
static const ecdh_test_case ecccdh_SECP192R1_22_test_case = {
	.name = "ECCCDH/SECP192R1 22",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_22_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_22_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_22_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_22_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_22_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_22_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_22_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_22_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_23
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_23_test_vector_our_priv_key[] = {
	0x2b, 0xa2, 0x70, 0x3c, 0x5e, 0x23, 0xf6, 0x46, 0x3c, 0x5b, 0x88, 0xdc, 0x37, 0x29, 0x2f, 0xab, 0xd3, 0x39, 0x9b, 0x5e, 0x1f, 0xb6, 0x7c, 0x05,
};
static const u8 ecccdh_SECP192R1_23_test_vector_peer_pub_key[] = {
	0x3c, 0xec, 0x21, 0xb2, 0x86, 0x68, 0xa1, 0x2a, 0x2c, 0xf7, 0x8e, 0x1a, 0x8e, 0x55, 0xd0, 0xef, 0xe0, 0x65, 0x15, 0x2f, 0xff, 0xc3, 0x47, 0x18, 0x10, 0x29, 0x55, 0x7b, 0xeb, 0xa4, 0xff, 0x19, 0x92, 0xbd, 0x21, 0xc2, 0x3c, 0xb4, 0x82, 0x5f, 0x6d, 0xae, 0x70, 0xe3, 0x31, 0x8f, 0xd1, 0xca,
};
static const u8 ecccdh_SECP192R1_23_test_vector_our_pub_key[] = {
	0x75, 0x43, 0x14, 0x89, 0x06, 0xce, 0xf9, 0xb3, 0x7a, 0x71, 0xa7, 0xc0, 0x83, 0x63, 0xcd, 0xd3, 0xbb, 0xa5, 0x01, 0x42, 0xd6, 0x52, 0x41, 0xaa, 0x8b, 0x3a, 0x69, 0x73, 0xde, 0x8d, 0xc2, 0x71, 0xe2, 0x7c, 0x1e, 0xad, 0x1e, 0x96, 0x2f, 0xda, 0xae, 0x37, 0x10, 0xc7, 0x24, 0xda, 0xac, 0x38,
};
static const u8 ecccdh_SECP192R1_23_test_vector_shared_secret[] = {
	0x7f, 0x39, 0x29, 0xdd, 0x3c, 0xbf, 0x76, 0x73, 0xbc, 0x30, 0xd8, 0x59, 0xd9, 0x0b, 0x88, 0x03, 0x07, 0x47, 0x5f, 0x80, 0x06, 0x60, 0xea, 0x32,
};
static const ecdh_test_case ecccdh_SECP192R1_23_test_case = {
	.name = "ECCCDH/SECP192R1 23",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_23_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_23_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_23_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_23_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_23_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_23_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_23_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_23_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP192R1
#define ECCCDH_SECP192R1_SELF_TEST_24
/*** Tests for ECCCDH/SECP192R1 ***/
static const u8 ecccdh_SECP192R1_24_test_vector_our_priv_key[] = {
	0x83, 0x61, 0x18, 0xc6, 0x24, 0x8f, 0x88, 0x2e, 0x91, 0x47, 0x97, 0x6f, 0x76, 0x48, 0x26, 0xc1, 0xa2, 0x87, 0x55, 0xa6, 0x10, 0x29, 0x77, 0xd5,
};
static const u8 ecccdh_SECP192R1_24_test_vector_peer_pub_key[] = {
	0x70, 0x82, 0x64, 0x47, 0x15, 0xb8, 0xb7, 0x31, 0xf8, 0x22, 0x8b, 0x51, 0x18, 0xe7, 0x27, 0x0d, 0x34, 0xd1, 0x81, 0xf3, 0x61, 0xa2, 0x21, 0xfc, 0x46, 0x46, 0x49, 0xd6, 0xc8, 0x8c, 0xa8, 0x96, 0x14, 0x48, 0x8a, 0x1c, 0xc7, 0xb8, 0x44, 0x2b, 0xb4, 0x2f, 0x9f, 0xb3, 0x02, 0x0a, 0x3d, 0x76,
};
static const u8 ecccdh_SECP192R1_24_test_vector_our_pub_key[] = {
	0xfc, 0xd3, 0x45, 0xa9, 0x76, 0xc7, 0x20, 0xca, 0xaa, 0x97, 0xde, 0x66, 0x97, 0x22, 0x68, 0x25, 0x61, 0x5e, 0x12, 0x87, 0xa9, 0xef, 0xf6, 0x7e, 0x58, 0xea, 0x42, 0xed, 0xbe, 0xea, 0xfc, 0xa9, 0xff, 0x44, 0xcf, 0xd7, 0xf2, 0x9a, 0xbd, 0x2c, 0xbd, 0xe7, 0x62, 0x6d, 0x79, 0xe4, 0x22, 0xc9,
};
static const u8 ecccdh_SECP192R1_24_test_vector_shared_secret[] = {
	0x72, 0xe8, 0x8f, 0x3e, 0xa6, 0x7d, 0x46, 0xd4, 0x6d, 0xbf, 0x83, 0x92, 0x6e, 0x7e, 0x2a, 0x6b, 0x85, 0xb5, 0x45, 0x36, 0x74, 0x1e, 0x6d, 0x2c,
};
static const ecdh_test_case ecccdh_SECP192R1_24_test_case = {
	.name = "ECCCDH/SECP192R1 24",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp192r1_str_params,
	.our_priv_key = ecccdh_SECP192R1_24_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP192R1_24_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP192R1_24_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP192R1_24_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP192R1_24_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP192R1_24_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP192R1_24_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP192R1_24_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP192R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_0
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_0_test_vector_our_priv_key[] = {
	0x83, 0x46, 0xa6, 0x0f, 0xc6, 0xf2, 0x93, 0xca, 0x5a, 0x0d, 0x2a, 0xf6, 0x8b, 0xa7, 0x1d, 0x1d, 0xd3, 0x89, 0xe5, 0xe4, 0x08, 0x37, 0x94, 0x2d, 0xf3, 0xe4, 0x3c, 0xbd,
};
static const u8 ecccdh_SECP224R1_0_test_vector_peer_pub_key[] = {
	0xaf, 0x33, 0xcd, 0x06, 0x29, 0xbc, 0x7e, 0x99, 0x63, 0x20, 0xa3, 0xf4, 0x03, 0x68, 0xf7, 0x4d, 0xe8, 0x70, 0x4f, 0xa3, 0x7b, 0x8f, 0xab, 0x69, 0xab, 0xaa, 0xe2, 0x80, 0x88, 0x20, 0x92, 0xcc, 0xbb, 0xa7, 0x93, 0x0f, 0x41, 0x9a, 0x8a, 0x4f, 0x9b, 0xb1, 0x69, 0x78, 0xbb, 0xc3, 0x83, 0x87, 0x29, 0x99, 0x25, 0x59, 0xa6, 0xf2, 0xe2, 0xd7,
};
static const u8 ecccdh_SECP224R1_0_test_vector_our_pub_key[] = {
	0x8d, 0xe2, 0xe2, 0x6a, 0xdf, 0x72, 0xc5, 0x82, 0xd6, 0x56, 0x8e, 0xf6, 0x38, 0xc4, 0xfd, 0x59, 0xb1, 0x8d, 0xa1, 0x71, 0xbd, 0xf5, 0x01, 0xf1, 0xd9, 0x29, 0xe0, 0x48, 0x4a, 0x68, 0xa1, 0xc2, 0xb0, 0xfb, 0x22, 0x93, 0x0d, 0x12, 0x05, 0x55, 0xc1, 0xec, 0xe5, 0x0e, 0xa9, 0x8d, 0xea, 0x84, 0x07, 0xf7, 0x1b, 0xe3, 0x6e, 0xfa, 0xc0, 0xde,
};
static const u8 ecccdh_SECP224R1_0_test_vector_shared_secret[] = {
	0x7d, 0x96, 0xf9, 0xa3, 0xbd, 0x3c, 0x05, 0xcf, 0x5c, 0xc3, 0x7f, 0xeb, 0x8b, 0x9d, 0x52, 0x09, 0xd5, 0xc2, 0x59, 0x74, 0x64, 0xde, 0xc3, 0xe9, 0x98, 0x37, 0x43, 0xe8,
};
static const ecdh_test_case ecccdh_SECP224R1_0_test_case = {
	.name = "ECCCDH/SECP224R1 0",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_0_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_0_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_0_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_0_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_0_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_0_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_0_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_0_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_1
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_1_test_vector_our_priv_key[] = {
	0x04, 0x3c, 0xb2, 0x16, 0xf4, 0xb7, 0x2c, 0xdf, 0x76, 0x29, 0xd6, 0x37, 0x20, 0xa5, 0x4a, 0xee, 0x0c, 0x99, 0xeb, 0x32, 0xd7, 0x44, 0x77, 0xda, 0xc0, 0xc2, 0xf7, 0x3d,
};
static const u8 ecccdh_SECP224R1_1_test_vector_peer_pub_key[] = {
	0x13, 0xbf, 0xcd, 0x4f, 0x8e, 0x94, 0x42, 0x39, 0x3c, 0xab, 0x8f, 0xb4, 0x6b, 0x9f, 0x05, 0x66, 0xc2, 0x26, 0xb2, 0x2b, 0x37, 0x07, 0x69, 0x76, 0xf0, 0x61, 0x7a, 0x46, 0xee, 0xb2, 0x42, 0x75, 0x29, 0xb2, 0x88, 0xc6, 0x3c, 0x2f, 0x89, 0x63, 0xc1, 0xe4, 0x73, 0xdf, 0x2f, 0xca, 0x6c, 0xaa, 0x90, 0xd5, 0x2e, 0x2f, 0x8d, 0xb5, 0x6d, 0xd4,
};
static const u8 ecccdh_SECP224R1_1_test_vector_our_pub_key[] = {
	0x2f, 0x90, 0xf5, 0xc8, 0xea, 0xc9, 0xc7, 0xde, 0xcd, 0xbb, 0x97, 0xb6, 0xc2, 0xf7, 0x15, 0xab, 0x72, 0x5e, 0x4f, 0xe4, 0x0f, 0xe6, 0xd7, 0x46, 0xef, 0xbf, 0x4e, 0x1b, 0x66, 0x89, 0x73, 0x51, 0x45, 0x4f, 0x92, 0x7a, 0x30, 0x9b, 0x26, 0x9c, 0x5a, 0x6d, 0x31, 0x33, 0x8b, 0xe4, 0xc1, 0x9a, 0x5a, 0xcf, 0xc3, 0x2c, 0xf6, 0x56, 0xf4, 0x5c,
};
static const u8 ecccdh_SECP224R1_1_test_vector_shared_secret[] = {
	0xee, 0x93, 0xce, 0x06, 0xb8, 0x9f, 0xf7, 0x20, 0x09, 0xe8, 0x58, 0xc6, 0x8e, 0xb7, 0x08, 0xe7, 0xbc, 0x79, 0xee, 0x03, 0x00, 0xf7, 0x3b, 0xed, 0x69, 0xbb, 0xca, 0x09,
};
static const ecdh_test_case ecccdh_SECP224R1_1_test_case = {
	.name = "ECCCDH/SECP224R1 1",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_1_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_1_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_1_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_1_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_1_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_1_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_1_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_1_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_2
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_2_test_vector_our_priv_key[] = {
	0x5a, 0xd0, 0xdd, 0x6d, 0xba, 0xbb, 0x4f, 0x3c, 0x2e, 0xa5, 0xfe, 0x32, 0xe5, 0x61, 0xb2, 0xca, 0x55, 0x08, 0x14, 0x86, 0xdf, 0x2c, 0x7c, 0x15, 0xc9, 0x62, 0x2b, 0x08,
};
static const u8 ecccdh_SECP224R1_2_test_vector_peer_pub_key[] = {
	0x75, 0x6d, 0xd8, 0x06, 0xb9, 0xd9, 0xc3, 0x4d, 0x89, 0x96, 0x91, 0xec, 0xb4, 0x5b, 0x77, 0x1a, 0xf4, 0x68, 0xec, 0x00, 0x44, 0x86, 0xa0, 0xfd, 0xd2, 0x83, 0x41, 0x1e, 0x4d, 0x02, 0xc2, 0xca, 0x61, 0x7b, 0xb2, 0xc5, 0xd9, 0x61, 0x3f, 0x25, 0xdd, 0x72, 0x41, 0x3d, 0x22, 0x9f, 0xd2, 0x90, 0x15, 0x13, 0xaa, 0x29, 0x50, 0x4e, 0xee, 0xfb,
};
static const u8 ecccdh_SECP224R1_2_test_vector_our_pub_key[] = {
	0x00, 0x5b, 0xca, 0x45, 0xd7, 0x93, 0xe7, 0xfe, 0x99, 0xa8, 0x43, 0x70, 0x4e, 0xd8, 0x38, 0x31, 0x5a, 0xb1, 0x4a, 0x5f, 0x62, 0x77, 0x50, 0x7e, 0x9b, 0xc3, 0x75, 0x31, 0x43, 0xe9, 0xd4, 0x21, 0xe1, 0x48, 0x6a, 0xe5, 0x89, 0x3b, 0xfd, 0x23, 0xc2, 0x10, 0xe5, 0xc1, 0x40, 0xd7, 0xc6, 0xb1, 0xad, 0xa5, 0x9d, 0x84, 0x2c, 0x9a, 0x98, 0xde,
};
static const u8 ecccdh_SECP224R1_2_test_vector_shared_secret[] = {
	0x3f, 0xcc, 0x01, 0xe3, 0x4d, 0x44, 0x49, 0xda, 0x2a, 0x97, 0x4b, 0x23, 0xfc, 0x36, 0xf9, 0x56, 0x67, 0x54, 0x25, 0x9d, 0x39, 0x14, 0x97, 0x90, 0xcf, 0xa1, 0xeb, 0xd3,
};
static const ecdh_test_case ecccdh_SECP224R1_2_test_case = {
	.name = "ECCCDH/SECP224R1 2",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_2_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_2_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_2_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_2_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_2_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_2_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_2_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_2_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_3
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_3_test_vector_our_priv_key[] = {
	0x0a, 0xa6, 0xff, 0x55, 0xa5, 0xd8, 0x20, 0xef, 0xcb, 0x4e, 0x7d, 0x10, 0xb8, 0x45, 0xea, 0x3c, 0x9f, 0x9b, 0xc5, 0xdf, 0xf8, 0x61, 0x06, 0xdb, 0x85, 0x31, 0x8e, 0x22,
};
static const u8 ecccdh_SECP224R1_3_test_vector_peer_pub_key[] = {
	0x0f, 0x53, 0x7b, 0xf1, 0xc1, 0x12, 0x2c, 0x55, 0x65, 0x6d, 0x25, 0xe8, 0xaa, 0x84, 0x17, 0xe0, 0xb4, 0x4b, 0x15, 0x26, 0xae, 0x05, 0x23, 0x14, 0x4f, 0x99, 0x21, 0xc4, 0xf7, 0x9b, 0x26, 0xd3, 0x0e, 0x49, 0x1a, 0x77, 0x36, 0x96, 0xcc, 0x2c, 0x79, 0xb4, 0xf0, 0x59, 0x6b, 0xc5, 0xb9, 0xee, 0xba, 0xf3, 0x94, 0xd1, 0x62, 0xfb, 0x86, 0x84,
};
static const u8 ecccdh_SECP224R1_3_test_vector_our_pub_key[] = {
	0x2f, 0x96, 0x75, 0x41, 0x31, 0xe0, 0x96, 0x81, 0x98, 0xaa, 0x78, 0xfb, 0xe8, 0xc2, 0x01, 0xdc, 0x5f, 0x35, 0x81, 0xc7, 0x92, 0xde, 0x48, 0x73, 0x40, 0xd3, 0x24, 0x48, 0x61, 0xe8, 0xa5, 0xcd, 0x79, 0x61, 0x52, 0x03, 0xb6, 0xd8, 0x9e, 0x94, 0x96, 0xf9, 0xe2, 0x36, 0xfe, 0x3b, 0x6b, 0xe8, 0x73, 0x1e, 0x74, 0x3d, 0x61, 0x55, 0x19, 0xc6,
};
static const u8 ecccdh_SECP224R1_3_test_vector_shared_secret[] = {
	0x49, 0x12, 0x96, 0x28, 0xb2, 0x3a, 0xfc, 0xef, 0x48, 0x13, 0x9a, 0x3f, 0x6f, 0x59, 0xff, 0x5e, 0x98, 0x11, 0xaa, 0x74, 0x6a, 0xa4, 0xff, 0x33, 0xc2, 0x4b, 0xb9, 0x40,
};
static const ecdh_test_case ecccdh_SECP224R1_3_test_case = {
	.name = "ECCCDH/SECP224R1 3",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_3_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_3_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_3_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_3_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_3_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_3_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_3_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_3_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_4
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_4_test_vector_our_priv_key[] = {
	0xef, 0xe6, 0xe6, 0xe2, 0x5a, 0xff, 0xaf, 0x54, 0xc9, 0x8d, 0x00, 0x2a, 0xbb, 0xc6, 0x32, 0x8d, 0xa1, 0x59, 0x40, 0x5a, 0x1b, 0x75, 0x2e, 0x32, 0xdc, 0x23, 0x95, 0x0a,
};
static const u8 ecccdh_SECP224R1_4_test_vector_peer_pub_key[] = {
	0x2b, 0x36, 0x31, 0xd2, 0xb0, 0x61, 0x79, 0xb3, 0x17, 0x4a, 0x10, 0x0f, 0x7f, 0x57, 0x13, 0x1e, 0xee, 0xa8, 0x94, 0x7b, 0xe0, 0x78, 0x6c, 0x3d, 0xc6, 0x4b, 0x22, 0x39, 0x83, 0xde, 0x29, 0xae, 0x3d, 0xad, 0x31, 0xad, 0xc0, 0x23, 0x6c, 0x6d, 0xe7, 0xf1, 0x45, 0x61, 0xca, 0x2e, 0xa0, 0x83, 0xc5, 0x27, 0x0c, 0x78, 0xa2, 0xe6, 0xcb, 0xc0,
};
static const u8 ecccdh_SECP224R1_4_test_vector_our_pub_key[] = {
	0x35, 0x5e, 0x96, 0x29, 0x20, 0xbd, 0xe0, 0x43, 0x69, 0x5f, 0x6b, 0xff, 0xb4, 0xb3, 0x55, 0xc6, 0x3d, 0xa6, 0xf5, 0xde, 0x66, 0x5e, 0xd4, 0x6f, 0x2e, 0xc8, 0x17, 0xe2, 0x74, 0x8e, 0x09, 0x53, 0x68, 0xf6, 0x2e, 0x1d, 0x36, 0x4e, 0xdd, 0x46, 0x17, 0x19, 0x79, 0x3b, 0x40, 0x4a, 0xdb, 0xda, 0xac, 0xbc, 0xad, 0xd8, 0x89, 0x22, 0xff, 0x37,
};
static const u8 ecccdh_SECP224R1_4_test_vector_shared_secret[] = {
	0xfc, 0xdc, 0x69, 0xa4, 0x05, 0x01, 0xd3, 0x08, 0xa6, 0x83, 0x96, 0x53, 0xa8, 0xf0, 0x43, 0x09, 0xec, 0x00, 0x23, 0x39, 0x49, 0x52, 0x29, 0x02, 0xff, 0xa5, 0xea, 0xc6,
};
static const ecdh_test_case ecccdh_SECP224R1_4_test_case = {
	.name = "ECCCDH/SECP224R1 4",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_4_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_4_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_4_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_4_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_4_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_4_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_4_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_4_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_5
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_5_test_vector_our_priv_key[] = {
	0x61, 0xcb, 0x29, 0x32, 0x52, 0x40, 0x01, 0xe5, 0xe9, 0xee, 0xed, 0x6d, 0xf7, 0xd9, 0xc8, 0x93, 0x5e, 0xe3, 0x32, 0x20, 0x29, 0xed, 0xd7, 0xaa, 0x8a, 0xcb, 0xfd, 0x51,
};
static const u8 ecccdh_SECP224R1_5_test_vector_peer_pub_key[] = {
	0x45, 0x11, 0x40, 0x3d, 0xe2, 0x90, 0x59, 0xf6, 0x9a, 0x47, 0x5c, 0x5a, 0x6a, 0x5f, 0x6c, 0xab, 0xed, 0x5d, 0x9f, 0x01, 0x44, 0x36, 0xa8, 0xcb, 0x70, 0xa0, 0x23, 0x38, 0x7d, 0x2d, 0x1b, 0x62, 0xaa, 0x04, 0x6d, 0xf9, 0x34, 0x0f, 0x9c, 0x37, 0xa0, 0x87, 0xa0, 0x6b, 0x32, 0xcf, 0x7f, 0x08, 0xa2, 0x23, 0xf9, 0x92, 0x81, 0x2a, 0x82, 0x8b,
};
static const u8 ecccdh_SECP224R1_5_test_vector_our_pub_key[] = {
	0xd5, 0x0e, 0x4a, 0xda, 0xbf, 0xd9, 0x89, 0xd7, 0xdb, 0xc7, 0xcf, 0x40, 0x52, 0x54, 0x6c, 0xc7, 0xc4, 0x47, 0xa9, 0x76, 0x30, 0x43, 0x69, 0x97, 0xad, 0x4b, 0x95, 0x36, 0x5b, 0xea, 0x50, 0x34, 0x73, 0xc5, 0xea, 0xef, 0x95, 0x52, 0xd4, 0x2c, 0x40, 0xb1, 0xf2, 0xf7, 0xca, 0x29, 0x27, 0x33, 0xb2, 0x55, 0xb9, 0xbb, 0xe1, 0xb1, 0x23, 0x37,
};
static const u8 ecccdh_SECP224R1_5_test_vector_shared_secret[] = {
	0x82, 0x7e, 0x90, 0x25, 0xcb, 0x62, 0xe0, 0xe8, 0x37, 0xc5, 0x96, 0x06, 0x3f, 0x3b, 0x9b, 0x5a, 0x0f, 0x7a, 0xfd, 0x8d, 0x87, 0x83, 0x20, 0x00, 0x86, 0xd6, 0x1e, 0xc1,
};
static const ecdh_test_case ecccdh_SECP224R1_5_test_case = {
	.name = "ECCCDH/SECP224R1 5",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_5_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_5_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_5_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_5_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_5_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_5_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_5_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_5_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_6
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_6_test_vector_our_priv_key[] = {
	0x8c, 0x7a, 0xce, 0x34, 0x71, 0x71, 0xf9, 0x2d, 0xef, 0x98, 0xd8, 0x45, 0x47, 0x5f, 0xc8, 0x2e, 0x1d, 0x14, 0x96, 0xda, 0x81, 0xee, 0x58, 0xf5, 0x05, 0xb9, 0x85, 0xfa,
};
static const u8 ecccdh_SECP224R1_6_test_vector_peer_pub_key[] = {
	0x31, 0x4a, 0x0b, 0x26, 0xdd, 0x31, 0xc2, 0x48, 0x84, 0x5d, 0x7c, 0xc1, 0x7b, 0x61, 0xca, 0xd4, 0x60, 0x82, 0x59, 0xbe, 0xd8, 0x5a, 0x58, 0xd1, 0xf1, 0xff, 0xd3, 0x78, 0x66, 0xe4, 0xb3, 0x50, 0x35, 0x2e, 0x11, 0x9e, 0xec, 0xad, 0xa3, 0x82, 0x90, 0x7f, 0x36, 0x19, 0xfd, 0x74, 0x8e, 0xa7, 0x3a, 0xe4, 0x89, 0x9d, 0xfd, 0x49, 0x63, 0x02,
};
static const u8 ecccdh_SECP224R1_6_test_vector_our_pub_key[] = {
	0xb1, 0xa8, 0xdc, 0xac, 0x89, 0xac, 0xa2, 0x79, 0x93, 0x20, 0xb4, 0x51, 0xdf, 0x1c, 0x7f, 0xf4, 0xd9, 0x75, 0x67, 0xab, 0xb6, 0x81, 0x41, 0xc0, 0xd9, 0x5f, 0xc2, 0xaa, 0x35, 0x24, 0x95, 0x09, 0x02, 0xb1, 0x51, 0x0b, 0xdc, 0x98, 0x7d, 0x86, 0x0a, 0xfc, 0x27, 0xad, 0x87, 0x1c, 0xea, 0xea, 0x66, 0x93, 0x5a, 0xbd, 0x3c, 0x0a, 0x99, 0xa8,
};
static const u8 ecccdh_SECP224R1_6_test_vector_shared_secret[] = {
	0x33, 0x5b, 0xa5, 0x12, 0x28, 0xd9, 0x4a, 0xcb, 0xed, 0x85, 0x1c, 0xa7, 0x82, 0x1c, 0x80, 0x1d, 0x5c, 0xb1, 0xc7, 0x97, 0x5d, 0x7a, 0xa9, 0x0a, 0x71, 0x59, 0xf8, 0xfa,
};
static const ecdh_test_case ecccdh_SECP224R1_6_test_case = {
	.name = "ECCCDH/SECP224R1 6",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_6_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_6_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_6_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_6_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_6_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_6_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_6_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_6_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_7
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_7_test_vector_our_priv_key[] = {
	0x38, 0x2f, 0xeb, 0x9b, 0x9b, 0xa1, 0x0f, 0x18, 0x9d, 0x99, 0xe7, 0x1a, 0x89, 0xcd, 0xfe, 0x44, 0xcb, 0x55, 0x4c, 0xec, 0x13, 0xa2, 0x12, 0x84, 0x09, 0x77, 0xfb, 0x68,
};
static const u8 ecccdh_SECP224R1_7_test_vector_peer_pub_key[] = {
	0xab, 0xe6, 0x84, 0x3b, 0xee, 0xc2, 0xfd, 0x9e, 0x5f, 0xb6, 0x47, 0x30, 0xd0, 0xbe, 0x4d, 0x16, 0x54, 0x38, 0xce, 0x92, 0x2e, 0xd7, 0x5d, 0xd8, 0x0b, 0x46, 0x03, 0xe5, 0x6a, 0xfe, 0x86, 0x73, 0xa9, 0x6c, 0x4b, 0xa9, 0x90, 0x0a, 0xd8, 0x59, 0x95, 0xe6, 0x31, 0xe4, 0x36, 0xc6, 0xcc, 0x88, 0xa2, 0xc2, 0xb4, 0x7b, 0x7c, 0x48, 0x86, 0xb8,
};
static const u8 ecccdh_SECP224R1_7_test_vector_our_pub_key[] = {
	0xab, 0xb6, 0xf1, 0xe3, 0x77, 0x3f, 0xf8, 0xfc, 0x73, 0xae, 0xa2, 0xa0, 0xb1, 0x07, 0x80, 0x9c, 0xe7, 0x0a, 0xdc, 0xef, 0xed, 0x6e, 0x41, 0xfc, 0x5c, 0xb4, 0x30, 0x45, 0xa9, 0x63, 0x89, 0x7a, 0xe9, 0x06, 0xc1, 0x0a, 0x05, 0x5e, 0xea, 0xdb, 0x97, 0xff, 0xdd, 0x6f, 0x74, 0x8d, 0x3e, 0x56, 0x21, 0xe5, 0xff, 0xf3, 0x04, 0xe4, 0x8b, 0xa7,
};
static const u8 ecccdh_SECP224R1_7_test_vector_shared_secret[] = {
	0x8c, 0x2e, 0x62, 0x75, 0x94, 0x20, 0x6b, 0x34, 0xf7, 0x35, 0x6d, 0x34, 0x26, 0xeb, 0x3d, 0x79, 0xf5, 0x18, 0xef, 0x84, 0x3f, 0xbe, 0x94, 0x01, 0x4c, 0xce, 0xac, 0xe3,
};
static const ecdh_test_case ecccdh_SECP224R1_7_test_case = {
	.name = "ECCCDH/SECP224R1 7",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_7_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_7_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_7_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_7_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_7_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_7_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_7_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_7_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_8
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_8_test_vector_our_priv_key[] = {
	0xe0, 0xd6, 0x20, 0x35, 0x10, 0x1e, 0xf4, 0x87, 0xc4, 0x85, 0xc6, 0x0f, 0xb4, 0x50, 0x0e, 0xeb, 0xe6, 0xa3, 0x2e, 0xc6, 0x4d, 0xbe, 0x97, 0xdb, 0xe0, 0x23, 0x2c, 0x46,
};
static const u8 ecccdh_SECP224R1_8_test_vector_peer_pub_key[] = {
	0x13, 0xcf, 0x9d, 0x6d, 0x2c, 0x9a, 0xae, 0x82, 0x74, 0xc2, 0x7d, 0x44, 0x6a, 0xfd, 0x0c, 0x88, 0x8f, 0xfd, 0xd5, 0x2a, 0xe2, 0x99, 0xa3, 0x59, 0x84, 0xd4, 0xf5, 0x27, 0xdc, 0xbe, 0xe7, 0x5b, 0x51, 0x57, 0x51, 0xf8, 0xee, 0x2a, 0xe3, 0x55, 0xe8, 0xaf, 0xd5, 0xde, 0x21, 0xc6, 0x2a, 0x93, 0x9a, 0x65, 0x07, 0xb5, 0x38, 0xcb, 0xc4, 0xaf,
};
static const u8 ecccdh_SECP224R1_8_test_vector_our_pub_key[] = {
	0x88, 0x53, 0x77, 0x35, 0xe9, 0xb2, 0x3e, 0x3e, 0x0e, 0x07, 0x6f, 0x13, 0x5a, 0x82, 0xd3, 0x3f, 0x9b, 0xff, 0xb4, 0x65, 0xf3, 0xab, 0xce, 0x83, 0x22, 0xa6, 0x2a, 0x62, 0xb4, 0xc8, 0xc1, 0x23, 0x67, 0x31, 0x97, 0x87, 0x5c, 0x0b, 0xd1, 0x4e, 0xd0, 0x97, 0x60, 0x6d, 0x33, 0x0f, 0xba, 0x2b, 0x92, 0x00, 0xef, 0x65, 0xa4, 0x47, 0x64, 0xd3,
};
static const u8 ecccdh_SECP224R1_8_test_vector_shared_secret[] = {
	0x63, 0x2a, 0xbb, 0x66, 0x27, 0x28, 0xdb, 0xc9, 0x94, 0x50, 0x88, 0x73, 0xd5, 0xc5, 0x27, 0xca, 0x5e, 0xf9, 0x23, 0xc0, 0xd3, 0x1f, 0xa6, 0xc4, 0x7e, 0xf4, 0xc8, 0x25,
};
static const ecdh_test_case ecccdh_SECP224R1_8_test_case = {
	.name = "ECCCDH/SECP224R1 8",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_8_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_8_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_8_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_8_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_8_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_8_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_8_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_8_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_9
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_9_test_vector_our_priv_key[] = {
	0xb9, 0x6a, 0xde, 0x5b, 0x73, 0xba, 0x72, 0xaa, 0x8b, 0x6e, 0x4d, 0x74, 0xd7, 0xbf, 0x9c, 0x58, 0xe9, 0x62, 0xff, 0x78, 0xeb, 0x54, 0x22, 0x87, 0xc7, 0xb4, 0x4b, 0xa2,
};
static const u8 ecccdh_SECP224R1_9_test_vector_peer_pub_key[] = {
	0x96, 0x5b, 0x63, 0x7c, 0x0d, 0xfb, 0xc0, 0xcf, 0x95, 0x40, 0x35, 0x68, 0x6d, 0x70, 0xf7, 0xec, 0x30, 0x92, 0x9e, 0x66, 0x4e, 0x52, 0x1d, 0xba, 0xa2, 0x28, 0x06, 0x59, 0x82, 0xa5, 0x8f, 0xf6, 0x1b, 0xc9, 0x00, 0x19, 0xbb, 0xcb, 0xb5, 0x87, 0x5d, 0x38, 0x63, 0xdb, 0x0b, 0xc2, 0xa1, 0xfa, 0x34, 0xb0, 0xad, 0x4d, 0xe1, 0xa8, 0x3f, 0x99,
};
static const u8 ecccdh_SECP224R1_9_test_vector_our_pub_key[] = {
	0x37, 0x68, 0x29, 0x26, 0xa5, 0x4f, 0x70, 0xa4, 0xc1, 0x74, 0x8f, 0x54, 0xd5, 0x0d, 0x5b, 0x00, 0x13, 0x8a, 0x05, 0x5f, 0x92, 0x4f, 0x2c, 0x65, 0xe5, 0xb0, 0xbb, 0xe4, 0x59, 0x6a, 0xfe, 0xfc, 0xdd, 0x64, 0x0d, 0x29, 0x63, 0x50, 0x15, 0xb8, 0x9b, 0xdd, 0xdd, 0x1f, 0x8c, 0x27, 0x23, 0x68, 0x6d, 0x33, 0x2e, 0x7a, 0x06, 0xca, 0x87, 0x99,
};
static const u8 ecccdh_SECP224R1_9_test_vector_shared_secret[] = {
	0x34, 0x64, 0x11, 0x41, 0xaa, 0xb0, 0x5e, 0xf5, 0x8b, 0xd3, 0x76, 0xd6, 0x09, 0x34, 0x59, 0x01, 0xfb, 0x8f, 0x63, 0x47, 0x7c, 0x6b, 0xe9, 0x09, 0x7f, 0x03, 0x7f, 0x1f,
};
static const ecdh_test_case ecccdh_SECP224R1_9_test_case = {
	.name = "ECCCDH/SECP224R1 9",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_9_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_9_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_9_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_9_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_9_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_9_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_9_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_9_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_10
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_10_test_vector_our_priv_key[] = {
	0xa4, 0x0d, 0x7e, 0x12, 0x04, 0x9c, 0x71, 0xe6, 0x52, 0x2c, 0x7f, 0xf2, 0x38, 0x42, 0x24, 0x06, 0x1c, 0x3a, 0x45, 0x70, 0x58, 0xb3, 0x10, 0x55, 0x76, 0x55, 0xb8, 0x54,
};
static const u8 ecccdh_SECP224R1_10_test_vector_peer_pub_key[] = {
	0x73, 0xcc, 0x64, 0x53, 0x72, 0xca, 0x2e, 0x71, 0x63, 0x7c, 0xda, 0x94, 0x3d, 0x81, 0x48, 0xf3, 0x38, 0x2a, 0xb6, 0xdd, 0x0f, 0x2e, 0x1a, 0x49, 0xda, 0x94, 0xe1, 0x34, 0xdf, 0x5c, 0x35, 0x5c, 0x23, 0xe6, 0xe2, 0x32, 0xeb, 0xc3, 0xbe, 0xe2, 0xab, 0x18, 0x73, 0xee, 0x0d, 0x83, 0xe3, 0x38, 0x2f, 0x8e, 0x6f, 0xe6, 0x13, 0xf6, 0x34, 0x3c,
};
static const u8 ecccdh_SECP224R1_10_test_vector_our_pub_key[] = {
	0x39, 0x98, 0x01, 0x24, 0x3b, 0xfe, 0x0c, 0x2d, 0xa9, 0xb0, 0xa5, 0x3c, 0x8c, 0xa5, 0x7f, 0x2e, 0xee, 0x87, 0xaa, 0xa9, 0x4a, 0x8e, 0x4d, 0x5e, 0x02, 0x9f, 0x42, 0xca, 0xaa, 0x49, 0xe6, 0xd4, 0xb4, 0x7c, 0xee, 0x7a, 0x5c, 0x4a, 0xb7, 0x1d, 0x5a, 0x67, 0xda, 0x84, 0xe0, 0xb9, 0xb4, 0x25, 0xce, 0x3e, 0x70, 0xda, 0x68, 0xc8, 0x89, 0xe7,
};
static const u8 ecccdh_SECP224R1_10_test_vector_shared_secret[] = {
	0x4f, 0x74, 0xac, 0x85, 0x07, 0x50, 0x1a, 0x32, 0xbf, 0xc5, 0xa7, 0x8d, 0x82, 0x71, 0xc2, 0x00, 0xe8, 0x35, 0x96, 0x6e, 0x18, 0x7e, 0x8d, 0x00, 0x01, 0x1a, 0x8c, 0x75,
};
static const ecdh_test_case ecccdh_SECP224R1_10_test_case = {
	.name = "ECCCDH/SECP224R1 10",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_10_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_10_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_10_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_10_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_10_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_10_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_10_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_10_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_11
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_11_test_vector_our_priv_key[] = {
	0xad, 0x25, 0x19, 0xbc, 0x72, 0x4d, 0x48, 0x4e, 0x02, 0xa6, 0x9f, 0x05, 0x14, 0x9b, 0xb0, 0x47, 0x71, 0x4b, 0xf0, 0xf5, 0x98, 0x6f, 0xac, 0x2e, 0x22, 0x2c, 0xd9, 0x46,
};
static const u8 ecccdh_SECP224R1_11_test_vector_peer_pub_key[] = {
	0x54, 0x65, 0x78, 0x21, 0x62, 0x50, 0x35, 0x4e, 0x44, 0x9e, 0x21, 0x54, 0x6d, 0xd1, 0x1c, 0xd1, 0xc5, 0x17, 0x42, 0x36, 0x73, 0x9a, 0xca, 0xd9, 0xce, 0x0f, 0x45, 0x12, 0xd2, 0xa2, 0x2f, 0xcd, 0x66, 0xd1, 0xab, 0xed, 0xc7, 0x67, 0x66, 0x83, 0x27, 0xc5, 0xcb, 0x9c, 0x59, 0x90, 0x43, 0x27, 0x62, 0x39, 0xcf, 0x3c, 0x85, 0x16, 0xaf, 0x24,
};
static const u8 ecccdh_SECP224R1_11_test_vector_our_pub_key[] = {
	0xdf, 0x9c, 0x1e, 0x0e, 0xf1, 0x5e, 0x53, 0xb9, 0xf6, 0x26, 0xe2, 0xbe, 0x1c, 0xbe, 0x89, 0x36, 0x39, 0xc0, 0x6f, 0x3e, 0x04, 0x39, 0xee, 0x95, 0xd7, 0xd4, 0xb1, 0xe3, 0x7a, 0x52, 0xa7, 0x38, 0x6a, 0xdd, 0xa2, 0x43, 0xef, 0xdf, 0x89, 0x41, 0x08, 0x5c, 0x84, 0xe3, 0x12, 0x39, 0xca, 0xb9, 0x2b, 0x80, 0x17, 0x33, 0x67, 0x48, 0x96, 0x5e,
};
static const u8 ecccdh_SECP224R1_11_test_vector_shared_secret[] = {
	0xad, 0x09, 0xc9, 0xae, 0x4d, 0x23, 0x24, 0xea, 0x81, 0xbb, 0x55, 0x5b, 0x20, 0x0d, 0x3c, 0x00, 0x3e, 0x22, 0xa6, 0x87, 0x0e, 0xe0, 0x3b, 0x52, 0xdf, 0x49, 0xe4, 0xde,
};
static const ecdh_test_case ecccdh_SECP224R1_11_test_case = {
	.name = "ECCCDH/SECP224R1 11",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_11_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_11_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_11_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_11_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_11_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_11_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_11_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_11_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_12
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_12_test_vector_our_priv_key[] = {
	0x3d, 0x31, 0x2a, 0x9b, 0x9d, 0x8e, 0xd0, 0x91, 0x40, 0x90, 0x0b, 0xba, 0xc1, 0xe0, 0x95, 0x52, 0x7e, 0xbc, 0x9e, 0x3c, 0x64, 0x93, 0xbc, 0xf3, 0x66, 0x6e, 0x3a, 0x29,
};
static const u8 ecccdh_SECP224R1_12_test_vector_peer_pub_key[] = {
	0x1d, 0x46, 0xb1, 0xdc, 0x3a, 0x28, 0x12, 0x3c, 0xb5, 0x13, 0x46, 0xe6, 0x7b, 0xae, 0xc5, 0x64, 0x04, 0x86, 0x86, 0x78, 0xfa, 0xf7, 0xd0, 0xe8, 0xb2, 0xaf, 0xa2, 0x2a, 0x0e, 0xc9, 0xe6, 0x5e, 0xc9, 0x7e, 0x21, 0x83, 0x73, 0xe7, 0xfc, 0x11, 0x5c, 0x22, 0x74, 0xd5, 0xb8, 0x29, 0xa6, 0x0d, 0x93, 0xf7, 0x1e, 0x01, 0xd5, 0x81, 0x36, 0xc3,
};
static const u8 ecccdh_SECP224R1_12_test_vector_our_pub_key[] = {
	0xb4, 0xa0, 0x19, 0x8d, 0xc8, 0x81, 0x0e, 0x88, 0x44, 0x25, 0xb7, 0x50, 0x92, 0x8b, 0x0c, 0x96, 0x0c, 0x31, 0xf7, 0xa9, 0x96, 0x63, 0x40, 0x0b, 0x01, 0xa1, 0x79, 0xdf, 0x81, 0x2b, 0x60, 0x1b, 0xfc, 0x07, 0x38, 0x24, 0x2c, 0x6f, 0x86, 0xf8, 0x30, 0xf2, 0x7a, 0xcd, 0x63, 0x2c, 0xa6, 0x18, 0xa0, 0xb5, 0x28, 0x0c, 0x9d, 0x57, 0x69, 0xf7,
};
static const u8 ecccdh_SECP224R1_12_test_vector_shared_secret[] = {
	0xef, 0x02, 0x9c, 0x28, 0xc6, 0x80, 0x64, 0xb8, 0xab, 0xd2, 0x96, 0x5a, 0x38, 0xc4, 0x04, 0xfb, 0x5e, 0x94, 0x4a, 0xce, 0x57, 0xe8, 0x63, 0x8d, 0xab, 0xa9, 0xd3, 0xcd,
};
static const ecdh_test_case ecccdh_SECP224R1_12_test_case = {
	.name = "ECCCDH/SECP224R1 12",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_12_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_12_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_12_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_12_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_12_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_12_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_12_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_12_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_13
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_13_test_vector_our_priv_key[] = {
	0x8c, 0xe0, 0x82, 0x2d, 0xc2, 0x4c, 0x15, 0x39, 0x95, 0x75, 0x5a, 0xc3, 0x50, 0x73, 0x7e, 0xf5, 0x06, 0x64, 0x1c, 0x7d, 0x75, 0x2b, 0x4f, 0x93, 0x00, 0xc6, 0x12, 0xed,
};
static const u8 ecccdh_SECP224R1_13_test_vector_peer_pub_key[] = {
	0x26, 0x6d, 0x03, 0x8c, 0xc7, 0xa4, 0xfe, 0x21, 0xf6, 0xc9, 0x76, 0x31, 0x8e, 0x82, 0x7b, 0x82, 0xbb, 0x5b, 0x8f, 0x74, 0x43, 0xa5, 0x52, 0x98, 0x13, 0x65, 0x06, 0xe0, 0xdf, 0x12, 0x3d, 0x98, 0xa7, 0xa2, 0x0b, 0xbd, 0xf3, 0x94, 0x3d, 0xf2, 0xe3, 0x56, 0x34, 0x22, 0xf8, 0xc0, 0xcf, 0x74, 0xd5, 0x3a, 0xaa, 0xbd, 0xd7, 0xc9, 0x73, 0xba,
};
static const u8 ecccdh_SECP224R1_13_test_vector_our_pub_key[] = {
	0x00, 0xdf, 0xc7, 0xec, 0x13, 0x76, 0x90, 0xcd, 0x6d, 0x12, 0xfd, 0xb2, 0xfd, 0x0b, 0x8c, 0x53, 0x14, 0x58, 0x21, 0x08, 0x76, 0x9c, 0x2b, 0x72, 0x2f, 0xfb, 0x39, 0x58, 0x5e, 0xef, 0x3d, 0xa4, 0xba, 0x45, 0x81, 0x27, 0x34, 0x6b, 0xb6, 0x40, 0x23, 0x86, 0x8b, 0xdd, 0xb7, 0x55, 0x8a, 0x2e, 0xcf, 0xc8, 0x13, 0x64, 0x5f, 0x4c, 0xe9, 0xfe,
};
static const u8 ecccdh_SECP224R1_13_test_vector_shared_secret[] = {
	0xf8, 0x3c, 0x16, 0x66, 0x1d, 0xfc, 0xba, 0xd0, 0x21, 0xcc, 0x3b, 0x5a, 0x5a, 0xf5, 0x1d, 0x9a, 0x18, 0xdb, 0x46, 0x53, 0x86, 0x6b, 0x3f, 0xf9, 0x07, 0x87, 0xce, 0x3e,
};
static const ecdh_test_case ecccdh_SECP224R1_13_test_case = {
	.name = "ECCCDH/SECP224R1 13",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_13_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_13_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_13_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_13_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_13_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_13_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_13_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_13_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_14
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_14_test_vector_our_priv_key[] = {
	0x0f, 0xf9, 0xb4, 0x85, 0x32, 0x5a, 0xb7, 0x7f, 0x29, 0xe7, 0xbc, 0x37, 0x9f, 0xed, 0x74, 0xbf, 0xac, 0x85, 0x94, 0x82, 0xda, 0x0d, 0xee, 0x75, 0x28, 0xc1, 0x9d, 0xb2,
};
static const u8 ecccdh_SECP224R1_14_test_vector_peer_pub_key[] = {
	0xeb, 0x0a, 0x09, 0xf7, 0xa1, 0xc2, 0x36, 0xa6, 0x1f, 0x59, 0x58, 0x09, 0xec, 0x56, 0x70, 0xef, 0xd9, 0x2e, 0x45, 0x98, 0xd5, 0xe6, 0x13, 0xe0, 0x92, 0xcd, 0xfd, 0xca, 0x50, 0x78, 0x7a, 0xe2, 0xf2, 0xf1, 0x5b, 0x88, 0xbc, 0x10, 0xf7, 0xb5, 0xf0, 0xae, 0xe1, 0x41, 0x83, 0x73, 0xf1, 0x61, 0x53, 0xae, 0xbd, 0x1f, 0xba, 0x54, 0x28, 0x8d,
};
static const u8 ecccdh_SECP224R1_14_test_vector_our_pub_key[] = {
	0x7e, 0x60, 0x3e, 0x69, 0x76, 0xdb, 0x83, 0xc3, 0x60, 0x11, 0x50, 0x8f, 0xa6, 0x95, 0xd1, 0xb5, 0x15, 0x24, 0x9e, 0x2e, 0x54, 0xb4, 0x8f, 0xcb, 0xcf, 0xb9, 0x02, 0x47, 0x01, 0x79, 0xa6, 0x00, 0xce, 0x86, 0xad, 0xfc, 0xa9, 0xb1, 0xb9, 0x31, 0xfa, 0x51, 0x73, 0xd6, 0x18, 0xda, 0x09, 0xe8, 0x41, 0x80, 0x3d, 0x19, 0xb0, 0x26, 0x42, 0x86,
};
static const u8 ecccdh_SECP224R1_14_test_vector_shared_secret[] = {
	0xf5, 0x12, 0x58, 0xc6, 0x3f, 0x23, 0x2e, 0x55, 0xa6, 0x6a, 0xa2, 0x5e, 0xbd, 0x59, 0x7b, 0x20, 0x18, 0xd1, 0x05, 0x2c, 0x02, 0xee, 0xb6, 0x38, 0x66, 0x75, 0x80, 0x05,
};
static const ecdh_test_case ecccdh_SECP224R1_14_test_case = {
	.name = "ECCCDH/SECP224R1 14",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_14_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_14_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_14_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_14_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_14_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_14_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_14_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_14_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_15
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_15_test_vector_our_priv_key[] = {
	0x19, 0xcf, 0x5f, 0xf6, 0x30, 0x64, 0x67, 0xf2, 0x8b, 0x9f, 0xe0, 0x67, 0x5a, 0x43, 0xc0, 0x58, 0x25, 0x52, 0xc8, 0xc1, 0x2e, 0x59, 0xce, 0x7c, 0x38, 0xf2, 0x92, 0xb1,
};
static const u8 ecccdh_SECP224R1_15_test_vector_peer_pub_key[] = {
	0x6b, 0x2f, 0x6b, 0x18, 0xa5, 0x87, 0xf5, 0x62, 0xff, 0xc6, 0x1b, 0xd9, 0xb0, 0x04, 0x73, 0x22, 0x28, 0x69, 0x86, 0xa7, 0x8f, 0x1f, 0xd1, 0x39, 0xb8, 0x4f, 0x7c, 0x24, 0x70, 0x96, 0x90, 0x8e, 0x46, 0x15, 0x26, 0x6b, 0xe5, 0x9a, 0x53, 0xcd, 0x65, 0x55, 0x15, 0x05, 0x6f, 0xf9, 0x23, 0x70, 0xa6, 0x27, 0x1a, 0x5d, 0x38, 0x23, 0xd7, 0x04,
};
static const u8 ecccdh_SECP224R1_15_test_vector_our_pub_key[] = {
	0xfc, 0x20, 0xe9, 0x06, 0xe6, 0x09, 0xc1, 0x12, 0xcf, 0xc2, 0xe0, 0xfe, 0xa6, 0x30, 0x38, 0x82, 0xc5, 0xdb, 0x94, 0xe8, 0x7e, 0x02, 0x23, 0x73, 0xab, 0x2c, 0x08, 0x2a, 0xae, 0xcd, 0xf1, 0xda, 0xa7, 0x17, 0x82, 0xbc, 0x5a, 0x26, 0xbb, 0xbd, 0x8d, 0x7e, 0x8a, 0x76, 0x49, 0x0e, 0x26, 0xab, 0xc1, 0x7d, 0xff, 0xc7, 0x74, 0xbd, 0x73, 0x41,
};
static const u8 ecccdh_SECP224R1_15_test_vector_shared_secret[] = {
	0x7f, 0xdc, 0x96, 0x9a, 0x18, 0x6f, 0xf1, 0x84, 0x29, 0xf2, 0xa2, 0x76, 0xda, 0xc4, 0x3b, 0xee, 0xa2, 0x11, 0x82, 0xd8, 0x2c, 0xe2, 0xe5, 0xa0, 0x87, 0x65, 0x52, 0xb1,
};
static const ecdh_test_case ecccdh_SECP224R1_15_test_case = {
	.name = "ECCCDH/SECP224R1 15",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_15_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_15_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_15_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_15_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_15_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_15_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_15_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_15_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_16
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_16_test_vector_our_priv_key[] = {
	0x90, 0xa1, 0x53, 0x68, 0xe3, 0x53, 0x2c, 0x0b, 0x1e, 0x51, 0xe5, 0x5d, 0x13, 0x94, 0x47, 0xc2, 0xc8, 0x9b, 0xc1, 0x60, 0x71, 0x9d, 0x69, 0x72, 0x91, 0xea, 0x7c, 0x14,
};
static const u8 ecccdh_SECP224R1_16_test_vector_peer_pub_key[] = {
	0x32, 0x81, 0x01, 0xba, 0x82, 0x6a, 0xcd, 0x75, 0xff, 0x9f, 0x34, 0xd5, 0x57, 0x4c, 0xe0, 0xdb, 0xc9, 0x2f, 0x70, 0x9b, 0xad, 0x8d, 0x7a, 0x33, 0xc4, 0x79, 0x40, 0xc1, 0xdf, 0x39, 0xf1, 0xea, 0x88, 0x48, 0x8c, 0x55, 0xd5, 0x53, 0x81, 0x60, 0x87, 0x8b, 0x9c, 0xed, 0x18, 0xa8, 0x87, 0xea, 0x26, 0x1d, 0xd7, 0x12, 0xd1, 0x40, 0x24, 0xff,
};
static const u8 ecccdh_SECP224R1_16_test_vector_our_pub_key[] = {
	0xc6, 0x83, 0x7d, 0x50, 0x6e, 0x97, 0x6d, 0xa7, 0xdb, 0x3a, 0xd1, 0x26, 0x7c, 0x35, 0x9d, 0xff, 0x2e, 0xa6, 0xfb, 0x0b, 0x7f, 0x7f, 0x8e, 0x77, 0x02, 0x4c, 0x59, 0xe9, 0x67, 0xeb, 0x49, 0x1d, 0x2f, 0xc8, 0xa5, 0x30, 0xc4, 0x65, 0x25, 0xd2, 0xa8, 0xb2, 0xd7, 0xc1, 0xdf, 0x5f, 0xba, 0x1a, 0xe7, 0x40, 0xa4, 0x64, 0x9c, 0x68, 0x3e, 0xe6,
};
static const u8 ecccdh_SECP224R1_16_test_vector_shared_secret[] = {
	0x3d, 0x60, 0xab, 0x6d, 0xb2, 0xb3, 0xff, 0xe2, 0xd2, 0x9c, 0xcf, 0xf4, 0x6d, 0x05, 0x6e, 0x54, 0x23, 0x0c, 0xf3, 0x49, 0x82, 0xe2, 0x41, 0x55, 0x6e, 0xd2, 0x92, 0x0c,
};
static const ecdh_test_case ecccdh_SECP224R1_16_test_case = {
	.name = "ECCCDH/SECP224R1 16",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_16_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_16_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_16_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_16_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_16_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_16_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_16_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_16_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_17
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_17_test_vector_our_priv_key[] = {
	0x8e, 0x08, 0x38, 0xe0, 0x5e, 0x17, 0x21, 0x49, 0x10, 0x67, 0xe1, 0xca, 0xbc, 0x2e, 0x80, 0x51, 0xb2, 0x90, 0xe2, 0x61, 0x6e, 0xec, 0x42, 0x7b, 0x71, 0x21, 0x89, 0x7d,
};
static const u8 ecccdh_SECP224R1_17_test_vector_peer_pub_key[] = {
	0x00, 0x81, 0xe3, 0x42, 0x70, 0x87, 0x1e, 0x2e, 0xbb, 0xd9, 0x41, 0x83, 0xf6, 0x17, 0xb4, 0xae, 0x15, 0xf0, 0x41, 0x6d, 0xd6, 0x34, 0xfe, 0x6e, 0x93, 0x4c, 0xf3, 0xc0, 0x3a, 0x1e, 0x9f, 0x38, 0xa7, 0xb9, 0x0b, 0x73, 0x17, 0xd2, 0x6b, 0x9f, 0x63, 0x11, 0x06, 0x3a, 0xb5, 0x8b, 0x26, 0x8c, 0xf4, 0x89, 0xb2, 0xe5, 0x03, 0x86, 0xd5, 0xd6,
};
static const u8 ecccdh_SECP224R1_17_test_vector_our_pub_key[] = {
	0xe9, 0x15, 0x0f, 0x77, 0x00, 0x75, 0x62, 0x60, 0x19, 0xe1, 0x8f, 0x95, 0x47, 0x3b, 0x71, 0xe6, 0x82, 0x80, 0x41, 0x79, 0x1d, 0x3f, 0x08, 0xd3, 0xfa, 0xee, 0xaa, 0x2b, 0x47, 0x5f, 0x70, 0x73, 0x5e, 0xaa, 0xe5, 0x23, 0x08, 0xa3, 0xb7, 0x63, 0xdc, 0x88, 0xef, 0xe1, 0x8a, 0xb5, 0x90, 0xeb, 0xaf, 0xa0, 0x35, 0xf6, 0xe0, 0x8b, 0x00, 0x1c,
};
static const u8 ecccdh_SECP224R1_17_test_vector_shared_secret[] = {
	0x91, 0x16, 0xd7, 0x27, 0x86, 0xf4, 0xdb, 0x5d, 0xf7, 0xa8, 0xb4, 0x30, 0x78, 0xc6, 0xab, 0x91, 0x60, 0xd4, 0x23, 0x51, 0x3d, 0x35, 0xea, 0x5e, 0x25, 0x59, 0x30, 0x6d,
};
static const ecdh_test_case ecccdh_SECP224R1_17_test_case = {
	.name = "ECCCDH/SECP224R1 17",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_17_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_17_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_17_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_17_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_17_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_17_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_17_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_17_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_18
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_18_test_vector_our_priv_key[] = {
	0x38, 0x10, 0x6e, 0x93, 0xf1, 0x6a, 0x38, 0x1a, 0xdb, 0x1d, 0x72, 0xce, 0xe3, 0xda, 0x66, 0xae, 0x46, 0x2a, 0xd4, 0xbb, 0xfe, 0xa9, 0xec, 0xdf, 0x35, 0xd0, 0x81, 0x4e,
};
static const u8 ecccdh_SECP224R1_18_test_vector_peer_pub_key[] = {
	0x26, 0x23, 0x63, 0x2f, 0xdf, 0x0b, 0xd8, 0x56, 0x80, 0x5a, 0x69, 0xaa, 0x18, 0x6d, 0x41, 0x33, 0xef, 0x59, 0x04, 0xe1, 0xf6, 0x55, 0xa9, 0x72, 0xd6, 0x6c, 0xce, 0x07, 0x2c, 0xef, 0x97, 0x28, 0xdd, 0x06, 0xfb, 0x8b, 0x50, 0x15, 0x0f, 0x52, 0x9b, 0x69, 0x50, 0x76, 0xd4, 0x50, 0x79, 0x83, 0x91, 0x25, 0x85, 0xc8, 0x9b, 0xd0, 0x68, 0x2e,
};
static const u8 ecccdh_SECP224R1_18_test_vector_our_pub_key[] = {
	0x7b, 0xe6, 0xc4, 0xc9, 0x17, 0x82, 0x9a, 0xb6, 0x57, 0xdd, 0x79, 0xe8, 0x63, 0x7d, 0x7a, 0xef, 0xd2, 0xf8, 0x1f, 0x0d, 0xe7, 0x65, 0x4d, 0x95, 0x7e, 0x97, 0x65, 0x8d, 0x43, 0x0d, 0x22, 0xd9, 0xe8, 0x43, 0x83, 0x10, 0xf6, 0x1e, 0x0d, 0x43, 0xf2, 0x5f, 0xa3, 0xe3, 0x45, 0x85, 0xf4, 0x32, 0xba, 0xad, 0x27, 0xdb, 0x30, 0x21, 0xbf, 0x0d,
};
static const u8 ecccdh_SECP224R1_18_test_vector_shared_secret[] = {
	0x20, 0x7c, 0x53, 0xdc, 0xef, 0xac, 0x78, 0x9a, 0xaa, 0x02, 0x76, 0xd9, 0x20, 0x0b, 0x3a, 0x94, 0x0c, 0xe5, 0xf2, 0x29, 0x6f, 0x4c, 0xb2, 0xe8, 0x1a, 0x18, 0x5d, 0x3d,
};
static const ecdh_test_case ecccdh_SECP224R1_18_test_case = {
	.name = "ECCCDH/SECP224R1 18",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_18_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_18_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_18_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_18_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_18_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_18_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_18_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_18_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_19
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_19_test_vector_our_priv_key[] = {
	0xe5, 0xd1, 0x71, 0x84, 0x31, 0xcf, 0x50, 0xf6, 0xcb, 0xd1, 0xbc, 0x80, 0x19, 0xfa, 0x16, 0x76, 0x2d, 0xfa, 0x12, 0xc9, 0x89, 0xe5, 0x99, 0x99, 0x77, 0xfb, 0x4e, 0xa2,
};
static const u8 ecccdh_SECP224R1_19_test_vector_peer_pub_key[] = {
	0x8e, 0xe4, 0xd1, 0xdc, 0xc3, 0x1d, 0xee, 0x4b, 0xf6, 0xfe, 0x21, 0xca, 0x8a, 0x58, 0x77, 0x21, 0xd9, 0x10, 0xac, 0xfb, 0x12, 0x2c, 0x16, 0xc2, 0xa7, 0x7a, 0x81, 0x52, 0x4e, 0xbf, 0x32, 0x3f, 0xff, 0x04, 0xeb, 0x47, 0x70, 0x69, 0xa0, 0xac, 0x68, 0xb3, 0x45, 0xf6, 0xb1, 0xae, 0x13, 0x4e, 0xfc, 0x31, 0x94, 0x0e, 0x51, 0x3c, 0xb9, 0x9f,
};
static const u8 ecccdh_SECP224R1_19_test_vector_our_pub_key[] = {
	0x2e, 0xa4, 0x96, 0x6e, 0x7f, 0x92, 0xed, 0x7f, 0x5c, 0xc6, 0x1f, 0xde, 0x79, 0x20, 0x45, 0xf6, 0x3b, 0x73, 0x1d, 0x6e, 0x7d, 0x0d, 0xe2, 0x57, 0x7f, 0x2d, 0x8e, 0xce, 0x1c, 0x4a, 0x7b, 0x1e, 0xde, 0x6f, 0x83, 0x91, 0x62, 0x29, 0x2d, 0xf4, 0x24, 0xbe, 0x78, 0xe8, 0x17, 0x6f, 0xb6, 0xf9, 0x42, 0xa3, 0xc0, 0x23, 0x91, 0x70, 0x0f, 0x31,
};
static const u8 ecccdh_SECP224R1_19_test_vector_shared_secret[] = {
	0x10, 0xe4, 0x67, 0xda, 0x34, 0xf4, 0x8a, 0xd7, 0x07, 0x20, 0x05, 0xbc, 0xcd, 0x6d, 0xa1, 0xb2, 0xba, 0x3f, 0x71, 0xea, 0xfa, 0x1c, 0x39, 0x38, 0x42, 0xf9, 0x1d, 0x74,
};
static const ecdh_test_case ecccdh_SECP224R1_19_test_case = {
	.name = "ECCCDH/SECP224R1 19",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_19_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_19_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_19_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_19_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_19_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_19_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_19_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_19_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_20
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_20_test_vector_our_priv_key[] = {
	0x3d, 0x63, 0x56, 0x91, 0xb6, 0x2a, 0x9a, 0x92, 0x7c, 0x63, 0x39, 0x51, 0xc9, 0x36, 0x9c, 0x88, 0x62, 0xbd, 0x21, 0x19, 0xd3, 0x09, 0x70, 0xc2, 0x64, 0x47, 0x27, 0xd6,
};
static const u8 ecccdh_SECP224R1_20_test_vector_peer_pub_key[] = {
	0x97, 0xdc, 0xbe, 0x6d, 0x28, 0x33, 0x58, 0x82, 0xa6, 0xd1, 0x93, 0xcc, 0x54, 0xa1, 0x06, 0x3d, 0xd0, 0x77, 0x5d, 0xc3, 0x28, 0x56, 0x53, 0x00, 0xbb, 0x99, 0xe6, 0x91, 0xda, 0xd1, 0x1d, 0xd5, 0xec, 0xe8, 0xcf, 0xd9, 0xf9, 0x7c, 0x9a, 0x52, 0x6e, 0x4a, 0x15, 0x06, 0xe6, 0x35, 0x59, 0x69, 0xee, 0x87, 0x82, 0x6f, 0xc3, 0x8b, 0xcd, 0x24,
};
static const u8 ecccdh_SECP224R1_20_test_vector_our_pub_key[] = {
	0x43, 0x8b, 0xbb, 0x98, 0x05, 0x17, 0xaf, 0xb2, 0x0b, 0xe1, 0xd6, 0x74, 0xe3, 0xac, 0x2b, 0x31, 0xce, 0xf0, 0x7a, 0x9b, 0x23, 0xfb, 0x8f, 0x6e, 0x38, 0xe0, 0xd6, 0xc0, 0x0b, 0xe5, 0xf1, 0xc4, 0x7d, 0x58, 0xd2, 0x1b, 0x6e, 0xd2, 0x84, 0x23, 0xb3, 0x2f, 0x5a, 0x94, 0x75, 0x0d, 0xa4, 0x7e, 0xdc, 0xef, 0x33, 0xea, 0x79, 0x94, 0x2a, 0xfd,
};
static const u8 ecccdh_SECP224R1_20_test_vector_shared_secret[] = {
	0x82, 0xfd, 0x2f, 0x9c, 0x60, 0xc4, 0xf9, 0x99, 0xac, 0x00, 0xbb, 0xe6, 0x4b, 0xfc, 0x11, 0xda, 0x8f, 0xf8, 0xcd, 0xa2, 0xe4, 0x99, 0xfc, 0xed, 0x65, 0x23, 0x0b, 0xb1,
};
static const ecdh_test_case ecccdh_SECP224R1_20_test_case = {
	.name = "ECCCDH/SECP224R1 20",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_20_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_20_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_20_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_20_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_20_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_20_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_20_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_20_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_21
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_21_test_vector_our_priv_key[] = {
	0xac, 0xf3, 0xc8, 0x5b, 0xbd, 0xc3, 0x79, 0xf0, 0x2f, 0x5e, 0xa3, 0x6e, 0x7f, 0x0f, 0x53, 0x09, 0x5a, 0x9e, 0x70, 0x46, 0xa2, 0x86, 0x85, 0xa8, 0x65, 0x9b, 0xf7, 0x98,
};
static const u8 ecccdh_SECP224R1_21_test_vector_peer_pub_key[] = {
	0xce, 0x91, 0x26, 0xdd, 0x53, 0x97, 0x2d, 0xea, 0x1d, 0xe1, 0xd1, 0x1e, 0xfe, 0xf9, 0x00, 0xde, 0x34, 0xb6, 0x61, 0x85, 0x9c, 0x46, 0x48, 0xc5, 0xc0, 0xe5, 0x34, 0xf7, 0xe1, 0x13, 0xb6, 0xf2, 0xc1, 0x65, 0x9d, 0x07, 0xf2, 0x71, 0x6e, 0x64, 0xa8, 0x3c, 0x18, 0xbb, 0xce, 0x34, 0x4d, 0xd2, 0x12, 0x1f, 0xe8, 0x51, 0x68, 0xea, 0xe0, 0x85,
};
static const u8 ecccdh_SECP224R1_21_test_vector_our_pub_key[] = {
	0xff, 0x75, 0x11, 0x21, 0x5c, 0x71, 0xd7, 0x96, 0xbd, 0x64, 0x6e, 0x84, 0x74, 0xbe, 0x44, 0x16, 0xb9, 0x16, 0x84, 0xce, 0x0d, 0x26, 0x9e, 0xf6, 0xf4, 0x22, 0x01, 0x3b, 0xb7, 0xbf, 0x5e, 0x79, 0xb5, 0xa9, 0x39, 0x3b, 0xb9, 0xea, 0x42, 0xc0, 0xbd, 0xb2, 0xd3, 0xc2, 0xdc, 0x80, 0x6e, 0x1a, 0x73, 0x06, 0xaa, 0x58, 0xe4, 0xfd, 0xbe, 0xa5,
};
static const u8 ecccdh_SECP224R1_21_test_vector_shared_secret[] = {
	0x53, 0x0f, 0x7e, 0x7f, 0xc9, 0x32, 0x61, 0x3b, 0x29, 0xc9, 0x81, 0xf2, 0x61, 0xcb, 0x03, 0x6c, 0xba, 0x3f, 0x1d, 0xf3, 0x86, 0x4e, 0x0e, 0x1c, 0xba, 0x26, 0x85, 0xa2,
};
static const ecdh_test_case ecccdh_SECP224R1_21_test_case = {
	.name = "ECCCDH/SECP224R1 21",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_21_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_21_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_21_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_21_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_21_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_21_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_21_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_21_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_22
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_22_test_vector_our_priv_key[] = {
	0xcf, 0xfd, 0x62, 0xcb, 0x00, 0xa0, 0xe3, 0x16, 0x3f, 0xbf, 0x2c, 0x39, 0x7f, 0xad, 0xc9, 0x61, 0x82, 0x10, 0xf8, 0x6b, 0x4f, 0x54, 0xa6, 0x75, 0x28, 0x73, 0x05, 0xf0,
};
static const u8 ecccdh_SECP224R1_22_test_vector_peer_pub_key[] = {
	0x84, 0x41, 0x99, 0x67, 0xd6, 0xcf, 0xad, 0x41, 0xe7, 0x5a, 0x02, 0xb6, 0xda, 0x60, 0x5a, 0x97, 0x94, 0x9a, 0x18, 0x3a, 0x97, 0xc3, 0x06, 0xc4, 0xb4, 0x6e, 0x66, 0xa5, 0x5c, 0xc9, 0xb2, 0x59, 0x71, 0x8b, 0x1b, 0xc8, 0xb1, 0x44, 0xfd, 0xe6, 0x33, 0xa8, 0x94, 0x61, 0x6f, 0xfd, 0x59, 0xa3, 0xa6, 0xd5, 0xd8, 0xe9, 0x42, 0xc7, 0xcb, 0xb7,
};
static const u8 ecccdh_SECP224R1_22_test_vector_our_pub_key[] = {
	0x04, 0xbf, 0x4d, 0x94, 0x8f, 0x44, 0x30, 0xd1, 0x8b, 0x4e, 0xd6, 0xc9, 0x6d, 0xba, 0xf9, 0x81, 0xfa, 0x11, 0xa4, 0x03, 0xed, 0x16, 0x88, 0x7f, 0x06, 0x75, 0x49, 0x81, 0x7c, 0x13, 0x26, 0xa9, 0xce, 0xf5, 0x1f, 0x79, 0xd4, 0xe7, 0x83, 0x03, 0xd6, 0x06, 0x4b, 0x45, 0x9f, 0x61, 0x25, 0x84, 0xac, 0x2f, 0xdf, 0x59, 0x3d, 0x7d, 0x5d, 0x84,
};
static const u8 ecccdh_SECP224R1_22_test_vector_shared_secret[] = {
	0x49, 0xf6, 0xfd, 0x01, 0x39, 0x24, 0x8e, 0xf4, 0xdf, 0x2d, 0xb0, 0x5d, 0x13, 0x19, 0xbd, 0x5b, 0x14, 0x89, 0xe2, 0x49, 0x82, 0x7a, 0x45, 0xa8, 0xa5, 0xf1, 0x24, 0x27,
};
static const ecdh_test_case ecccdh_SECP224R1_22_test_case = {
	.name = "ECCCDH/SECP224R1 22",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_22_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_22_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_22_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_22_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_22_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_22_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_22_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_22_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_23
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_23_test_vector_our_priv_key[] = {
	0x85, 0xf9, 0x03, 0xe4, 0x39, 0x43, 0xd1, 0x3c, 0x68, 0x93, 0x2e, 0x71, 0x0e, 0x80, 0xde, 0x52, 0xcb, 0xc0, 0xb8, 0xf1, 0xa1, 0x41, 0x8e, 0xa4, 0xda, 0x07, 0x92, 0x99,
};
static const u8 ecccdh_SECP224R1_23_test_vector_peer_pub_key[] = {
	0x7c, 0x9c, 0xac, 0x35, 0x76, 0x80, 0x63, 0xc2, 0x82, 0x7f, 0x60, 0xa7, 0xf5, 0x13, 0x88, 0xf2, 0xa8, 0xf4, 0xb7, 0xf8, 0xcd, 0x73, 0x6b, 0xd6, 0xbc, 0x33, 0x74, 0x77, 0x29, 0xee, 0x6b, 0x84, 0x9c, 0x60, 0x25, 0xd5, 0x77, 0xdb, 0xcc, 0x55, 0xfb, 0xd1, 0x70, 0x18, 0xf4, 0xed, 0xbc, 0x2e, 0xf1, 0x05, 0xb0, 0x04, 0xd6, 0x25, 0x7b, 0xcd,
};
static const u8 ecccdh_SECP224R1_23_test_vector_our_pub_key[] = {
	0x97, 0x0a, 0x4a, 0x7e, 0x01, 0xd4, 0x18, 0x84, 0x97, 0xce, 0xb4, 0x69, 0x55, 0xeb, 0x1b, 0x84, 0x2d, 0x90, 0x85, 0x81, 0x9a, 0x9b, 0x92, 0x5c, 0x84, 0x52, 0x9d, 0x3d, 0xdf, 0xa2, 0x52, 0x64, 0x80, 0xf8, 0x33, 0xea, 0x0e, 0xdb, 0xd2, 0x04, 0xe4, 0xe3, 0x65, 0xfe, 0xf3, 0x47, 0x28, 0x88, 0xfe, 0x7d, 0x96, 0x91, 0xc3, 0xeb, 0xc0, 0x9f,
};
static const u8 ecccdh_SECP224R1_23_test_vector_shared_secret[] = {
	0x8f, 0x7e, 0x34, 0xe5, 0x97, 0xae, 0x80, 0x93, 0xb9, 0x82, 0x70, 0xa7, 0x4a, 0x8d, 0xfc, 0xdb, 0xed, 0x45, 0x7f, 0x42, 0xf4, 0x3d, 0xf4, 0x87, 0xc5, 0x48, 0x71, 0x61,
};
static const ecdh_test_case ecccdh_SECP224R1_23_test_case = {
	.name = "ECCCDH/SECP224R1 23",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_23_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_23_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_23_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_23_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_23_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_23_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_23_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_23_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP224R1
#define ECCCDH_SECP224R1_SELF_TEST_24
/*** Tests for ECCCDH/SECP224R1 ***/
static const u8 ecccdh_SECP224R1_24_test_vector_our_priv_key[] = {
	0xcc, 0xe6, 0x48, 0x91, 0xa3, 0xd0, 0x12, 0x9f, 0xee, 0x0d, 0x4a, 0x96, 0xcf, 0xbe, 0x7a, 0xc4, 0x70, 0xb8, 0x5e, 0x96, 0x75, 0x29, 0x05, 0x7c, 0xfa, 0x31, 0xa1, 0xd9,
};
static const u8 ecccdh_SECP224R1_24_test_vector_peer_pub_key[] = {
	0x08, 0x5a, 0x76, 0x42, 0xad, 0x8e, 0x59, 0xb1, 0xa3, 0xe8, 0x72, 0x6a, 0x75, 0x47, 0xaf, 0xbe, 0xcf, 0xfd, 0xac, 0x1d, 0xab, 0x7e, 0x57, 0x23, 0x0c, 0x6a, 0x9d, 0xf4, 0xf9, 0x1c, 0x36, 0xd8, 0x81, 0xfe, 0x9b, 0x80, 0x47, 0xa3, 0x53, 0x07, 0x13, 0x55, 0x4a, 0x1a, 0xf4, 0xc2, 0x5c, 0x5a, 0x8e, 0x65, 0x4d, 0xcd, 0xcf, 0x68, 0x9f, 0x2e,
};
static const u8 ecccdh_SECP224R1_24_test_vector_our_pub_key[] = {
	0xa6, 0xb2, 0x96, 0x32, 0xdb, 0x94, 0xda, 0x21, 0x25, 0xdc, 0x1c, 0xf8, 0x0e, 0x03, 0x70, 0x26, 0x87, 0xb2, 0xac, 0xc1, 0x12, 0x20, 0x22, 0xfa, 0x21, 0x74, 0x76, 0x5a, 0x61, 0x72, 0x3e, 0xdd, 0x73, 0xe1, 0x0d, 0xae, 0xd7, 0x37, 0x75, 0x27, 0x8f, 0x19, 0x58, 0xba, 0x56, 0xf1, 0xfc, 0x9d, 0x08, 0x5e, 0xbc, 0x2b, 0x64, 0xc8, 0x4f, 0xe5,
};
static const u8 ecccdh_SECP224R1_24_test_vector_shared_secret[] = {
	0x71, 0x95, 0x4e, 0x22, 0x61, 0xe8, 0x51, 0x0b, 0xe1, 0xa0, 0x60, 0x73, 0x36, 0x71, 0xd2, 0xe9, 0xd0, 0xa2, 0xd0, 0x12, 0xeb, 0x4e, 0x09, 0x55, 0x6d, 0x69, 0x7d, 0x2a,
};
static const ecdh_test_case ecccdh_SECP224R1_24_test_case = {
	.name = "ECCCDH/SECP224R1 24",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp224r1_str_params,
	.our_priv_key = ecccdh_SECP224R1_24_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP224R1_24_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP224R1_24_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP224R1_24_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP224R1_24_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP224R1_24_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP224R1_24_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP224R1_24_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP224R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_0
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_0_test_vector_our_priv_key[] = {
	0x7d, 0x7d, 0xc5, 0xf7, 0x1e, 0xb2, 0x9d, 0xda, 0xf8, 0x0d, 0x62, 0x14, 0x63, 0x2e, 0xea, 0xe0, 0x3d, 0x90, 0x58, 0xaf, 0x1f, 0xb6, 0xd2, 0x2e, 0xd8, 0x0b, 0xad, 0xb6, 0x2b, 0xc1, 0xa5, 0x34,
};
static const u8 ecccdh_SECP256R1_0_test_vector_peer_pub_key[] = {
	0x70, 0x0c, 0x48, 0xf7, 0x7f, 0x56, 0x58, 0x4c, 0x5c, 0xc6, 0x32, 0xca, 0x65, 0x64, 0x0d, 0xb9, 0x1b, 0x6b, 0xac, 0xce, 0x3a, 0x4d, 0xf6, 0xb4, 0x2c, 0xe7, 0xcc, 0x83, 0x88, 0x33, 0xd2, 0x87, 0xdb, 0x71, 0xe5, 0x09, 0xe3, 0xfd, 0x9b, 0x06, 0x0d, 0xdb, 0x20, 0xba, 0x5c, 0x51, 0xdc, 0xc5, 0x94, 0x8d, 0x46, 0xfb, 0xf6, 0x40, 0xdf, 0xe0, 0x44, 0x17, 0x82, 0xca, 0xb8, 0x5f, 0xa4, 0xac,
};
static const u8 ecccdh_SECP256R1_0_test_vector_our_pub_key[] = {
	0xea, 0xd2, 0x18, 0x59, 0x01, 0x19, 0xe8, 0x87, 0x6b, 0x29, 0x14, 0x6f, 0xf8, 0x9c, 0xa6, 0x17, 0x70, 0xc4, 0xed, 0xbb, 0xf9, 0x7d, 0x38, 0xce, 0x38, 0x5e, 0xd2, 0x81, 0xd8, 0xa6, 0xb2, 0x30, 0x28, 0xaf, 0x61, 0x28, 0x1f, 0xd3, 0x5e, 0x2f, 0xa7, 0x00, 0x25, 0x23, 0xac, 0xc8, 0x5a, 0x42, 0x9c, 0xb0, 0x6e, 0xe6, 0x64, 0x83, 0x25, 0x38, 0x9f, 0x59, 0xed, 0xfc, 0xe1, 0x40, 0x51, 0x41,
};
static const u8 ecccdh_SECP256R1_0_test_vector_shared_secret[] = {
	0x46, 0xfc, 0x62, 0x10, 0x64, 0x20, 0xff, 0x01, 0x2e, 0x54, 0xa4, 0x34, 0xfb, 0xdd, 0x2d, 0x25, 0xcc, 0xc5, 0x85, 0x20, 0x60, 0x56, 0x1e, 0x68, 0x04, 0x0d, 0xd7, 0x77, 0x89, 0x97, 0xbd, 0x7b,
};
static const ecdh_test_case ecccdh_SECP256R1_0_test_case = {
	.name = "ECCCDH/SECP256R1 0",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_0_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_0_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_0_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_0_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_0_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_0_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_0_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_0_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_1
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_1_test_vector_our_priv_key[] = {
	0x38, 0xf6, 0x5d, 0x6d, 0xce, 0x47, 0x67, 0x60, 0x44, 0xd5, 0x8c, 0xe5, 0x13, 0x95, 0x82, 0xd5, 0x68, 0xf6, 0x4b, 0xb1, 0x60, 0x98, 0xd1, 0x79, 0xdb, 0xab, 0x07, 0x74, 0x1d, 0xd5, 0xca, 0xf5,
};
static const u8 ecccdh_SECP256R1_1_test_vector_peer_pub_key[] = {
	0x80, 0x9f, 0x04, 0x28, 0x9c, 0x64, 0x34, 0x8c, 0x01, 0x51, 0x5e, 0xb0, 0x3d, 0x5c, 0xe7, 0xac, 0x1a, 0x8c, 0xb9, 0x49, 0x8f, 0x5c, 0xaa, 0x50, 0x19, 0x7e, 0x58, 0xd4, 0x3a, 0x86, 0xa7, 0xae, 0xb2, 0x9d, 0x84, 0xe8, 0x11, 0x19, 0x7f, 0x25, 0xeb, 0xa8, 0xf5, 0x19, 0x40, 0x92, 0xcb, 0x6f, 0xf4, 0x40, 0xe2, 0x6d, 0x44, 0x21, 0x01, 0x13, 0x72, 0x46, 0x1f, 0x57, 0x92, 0x71, 0xcd, 0xa3,
};
static const u8 ecccdh_SECP256R1_1_test_vector_our_pub_key[] = {
	0x11, 0x9f, 0x2f, 0x04, 0x79, 0x02, 0x78, 0x2a, 0xb0, 0xc9, 0xe2, 0x7a, 0x54, 0xaf, 0xf5, 0xeb, 0x9b, 0x96, 0x48, 0x29, 0xca, 0x99, 0xc0, 0x6b, 0x02, 0xdd, 0xba, 0x95, 0xb0, 0xa3, 0xf6, 0xd0, 0x8f, 0x52, 0xb7, 0x26, 0x66, 0x4c, 0xac, 0x36, 0x6f, 0xc9, 0x8a, 0xc7, 0xa0, 0x12, 0xb2, 0x68, 0x2c, 0xbd, 0x96, 0x2e, 0x5a, 0xcb, 0x54, 0x46, 0x71, 0xd4, 0x1b, 0x94, 0x45, 0x70, 0x4d, 0x1d,
};
static const u8 ecccdh_SECP256R1_1_test_vector_shared_secret[] = {
	0x05, 0x7d, 0x63, 0x60, 0x96, 0xcb, 0x80, 0xb6, 0x7a, 0x8c, 0x03, 0x8c, 0x89, 0x0e, 0x88, 0x7d, 0x1a, 0xdf, 0xa4, 0x19, 0x5e, 0x9b, 0x3c, 0xe2, 0x41, 0xc8, 0xa7, 0x78, 0xc5, 0x9c, 0xda, 0x67,
};
static const ecdh_test_case ecccdh_SECP256R1_1_test_case = {
	.name = "ECCCDH/SECP256R1 1",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_1_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_1_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_1_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_1_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_1_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_1_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_1_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_1_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_2
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_2_test_vector_our_priv_key[] = {
	0x1a, 0xcc, 0xfa, 0xf1, 0xb9, 0x77, 0x12, 0xb8, 0x5a, 0x6f, 0x54, 0xb1, 0x48, 0x98, 0x5a, 0x1b, 0xdc, 0x4c, 0x9b, 0xec, 0x0b, 0xd2, 0x58, 0xca, 0xd4, 0xb3, 0xd6, 0x03, 0xf4, 0x9f, 0x32, 0xc8,
};
static const u8 ecccdh_SECP256R1_2_test_vector_peer_pub_key[] = {
	0xa2, 0x33, 0x9c, 0x12, 0xd4, 0xa0, 0x3c, 0x33, 0x54, 0x6d, 0xe5, 0x33, 0x26, 0x8b, 0x4a, 0xd6, 0x67, 0xde, 0xbf, 0x45, 0x8b, 0x46, 0x4d, 0x77, 0x44, 0x36, 0x36, 0x44, 0x0e, 0xe7, 0xfe, 0xc3, 0xef, 0x48, 0xa3, 0xab, 0x26, 0xe2, 0x02, 0x20, 0xbc, 0xda, 0x2c, 0x18, 0x51, 0x07, 0x68, 0x39, 0xda, 0xe8, 0x8e, 0xae, 0x96, 0x28, 0x69, 0xa4, 0x97, 0xbf, 0x73, 0xcb, 0x66, 0xfa, 0xf5, 0x36,
};
static const u8 ecccdh_SECP256R1_2_test_vector_our_pub_key[] = {
	0xd9, 0xf2, 0xb7, 0x9c, 0x17, 0x28, 0x45, 0xbf, 0xdb, 0x56, 0x0b, 0xbb, 0x01, 0x44, 0x7c, 0xa5, 0xec, 0xc0, 0x47, 0x0a, 0x09, 0x51, 0x3b, 0x61, 0x26, 0x90, 0x2c, 0x6b, 0x4f, 0x8d, 0x10, 0x51, 0xf8, 0x15, 0xef, 0x5e, 0xc3, 0x21, 0x28, 0xd3, 0x48, 0x78, 0x34, 0x76, 0x46, 0x78, 0x70, 0x2e, 0x64, 0xe1, 0x64, 0xff, 0x73, 0x15, 0x18, 0x5e, 0x23, 0xaf, 0xf5, 0xfa, 0xcd, 0x96, 0xd7, 0xbc,
};
static const u8 ecccdh_SECP256R1_2_test_vector_shared_secret[] = {
	0x2d, 0x45, 0x7b, 0x78, 0xb4, 0x61, 0x41, 0x32, 0x47, 0x76, 0x18, 0xa5, 0xb0, 0x77, 0x96, 0x5e, 0xc9, 0x07, 0x30, 0xa8, 0xc8, 0x1a, 0x1c, 0x75, 0xd6, 0xd4, 0xec, 0x68, 0x00, 0x5d, 0x67, 0xec,
};
static const ecdh_test_case ecccdh_SECP256R1_2_test_case = {
	.name = "ECCCDH/SECP256R1 2",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_2_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_2_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_2_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_2_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_2_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_2_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_2_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_2_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_3
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_3_test_vector_our_priv_key[] = {
	0x20, 0x7c, 0x43, 0xa7, 0x9b, 0xfe, 0xe0, 0x3d, 0xb6, 0xf4, 0xb9, 0x44, 0xf5, 0x3d, 0x2f, 0xb7, 0x6c, 0xc4, 0x9e, 0xf1, 0xc9, 0xc4, 0xd3, 0x4d, 0x51, 0xb6, 0xc6, 0x5c, 0x4d, 0xb6, 0x93, 0x2d,
};
static const u8 ecccdh_SECP256R1_3_test_vector_peer_pub_key[] = {
	0xdf, 0x39, 0x89, 0xb9, 0xfa, 0x55, 0x49, 0x57, 0x19, 0xb3, 0xcf, 0x46, 0xdc, 0xcd, 0x28, 0xb5, 0x15, 0x3f, 0x78, 0x08, 0x19, 0x1d, 0xd5, 0x18, 0xef, 0xf0, 0xc3, 0xcf, 0xf2, 0xb7, 0x05, 0xed, 0x42, 0x22, 0x94, 0xff, 0x46, 0x00, 0x34, 0x29, 0xd7, 0x39, 0xa3, 0x32, 0x06, 0xc8, 0x75, 0x25, 0x52, 0xc8, 0xba, 0x54, 0xa2, 0x70, 0xde, 0xfc, 0x06, 0xe2, 0x21, 0xe0, 0xfe, 0xaf, 0x6a, 0xc4,
};
static const u8 ecccdh_SECP256R1_3_test_vector_our_pub_key[] = {
	0x24, 0x27, 0x7c, 0x33, 0xf4, 0x50, 0x46, 0x2d, 0xcb, 0x3d, 0x48, 0x01, 0xd5, 0x7b, 0x9c, 0xed, 0x05, 0x18, 0x8f, 0x16, 0xc2, 0x8e, 0xda, 0x87, 0x32, 0x58, 0x04, 0x8c, 0xd1, 0x60, 0x7e, 0x0d, 0xc4, 0x78, 0x97, 0x53, 0xe2, 0xb1, 0xf6, 0x3b, 0x32, 0xff, 0x01, 0x4e, 0xc4, 0x2c, 0xd6, 0xa6, 0x9f, 0xac, 0x81, 0xdf, 0xe6, 0xd0, 0xd6, 0xfd, 0x4a, 0xf3, 0x72, 0xae, 0x27, 0xc4, 0x6f, 0x88,
};
static const u8 ecccdh_SECP256R1_3_test_vector_shared_secret[] = {
	0x96, 0x44, 0x12, 0x59, 0x53, 0x4b, 0x80, 0xf6, 0xae, 0xe3, 0xd2, 0x87, 0xa6, 0xbb, 0x17, 0xb5, 0x09, 0x4d, 0xd4, 0x27, 0x7d, 0x9e, 0x29, 0x4f, 0x8f, 0xe7, 0x3e, 0x48, 0xbf, 0x2a, 0x00, 0x24,
};
static const ecdh_test_case ecccdh_SECP256R1_3_test_case = {
	.name = "ECCCDH/SECP256R1 3",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_3_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_3_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_3_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_3_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_3_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_3_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_3_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_3_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_4
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_4_test_vector_our_priv_key[] = {
	0x59, 0x13, 0x7e, 0x38, 0x15, 0x23, 0x50, 0xb1, 0x95, 0xc9, 0x71, 0x8d, 0x39, 0x67, 0x3d, 0x51, 0x98, 0x38, 0x05, 0x5a, 0xd9, 0x08, 0xdd, 0x47, 0x57, 0x15, 0x2f, 0xd8, 0x25, 0x5c, 0x09, 0xbf,
};
static const u8 ecccdh_SECP256R1_4_test_vector_peer_pub_key[] = {
	0x41, 0x19, 0x2d, 0x28, 0x13, 0xe7, 0x95, 0x61, 0xe6, 0xa1, 0xd6, 0xf5, 0x3c, 0x8b, 0xc1, 0xa4, 0x33, 0xa1, 0x99, 0xc8, 0x35, 0xe1, 0x41, 0xb0, 0x5a, 0x74, 0xa9, 0x7b, 0x0f, 0xae, 0xb9, 0x22, 0x1a, 0xf9, 0x8c, 0xc4, 0x5e, 0x98, 0xa7, 0xe0, 0x41, 0xb0, 0x1c, 0xf3, 0x5f, 0x46, 0x2b, 0x75, 0x62, 0x28, 0x13, 0x51, 0xc8, 0xeb, 0xf3, 0xff, 0xa0, 0x2e, 0x33, 0xa0, 0x72, 0x2a, 0x13, 0x28,
};
static const u8 ecccdh_SECP256R1_4_test_vector_our_pub_key[] = {
	0xa8, 0xc5, 0xfd, 0xce, 0x8b, 0x62, 0xc5, 0xad, 0xa5, 0x98, 0xf1, 0x41, 0xad, 0xb3, 0xb2, 0x6c, 0xf2, 0x54, 0xc2, 0x80, 0xb2, 0x85, 0x7a, 0x63, 0xd2, 0xad, 0x78, 0x3a, 0x73, 0x11, 0x5f, 0x6b, 0x80, 0x6e, 0x1a, 0xaf, 0xec, 0x4a, 0xf8, 0x0a, 0x0d, 0x78, 0x6b, 0x3d, 0xe4, 0x53, 0x75, 0xb5, 0x17, 0xa7, 0xe5, 0xb5, 0x1f, 0xfb, 0x2c, 0x35, 0x65, 0x37, 0xc9, 0xe6, 0xef, 0x22, 0x7d, 0x4a,
};
static const u8 ecccdh_SECP256R1_4_test_vector_shared_secret[] = {
	0x19, 0xd4, 0x4c, 0x8d, 0x63, 0xe8, 0xe8, 0xdd, 0x12, 0xc2, 0x2a, 0x87, 0xb8, 0xcd, 0x4e, 0xce, 0x27, 0xac, 0xdd, 0xe0, 0x4d, 0xbf, 0x47, 0xf7, 0xf2, 0x75, 0x37, 0xa6, 0x99, 0x9a, 0x8e, 0x62,
};
static const ecdh_test_case ecccdh_SECP256R1_4_test_case = {
	.name = "ECCCDH/SECP256R1 4",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_4_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_4_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_4_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_4_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_4_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_4_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_4_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_4_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_5
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_5_test_vector_our_priv_key[] = {
	0xf5, 0xf8, 0xe0, 0x17, 0x46, 0x10, 0xa6, 0x61, 0x27, 0x79, 0x79, 0xb5, 0x8c, 0xe5, 0xc9, 0x0f, 0xee, 0x6c, 0x9b, 0x3b, 0xb3, 0x46, 0xa9, 0x0a, 0x71, 0x96, 0x25, 0x5e, 0x40, 0xb1, 0x32, 0xef,
};
static const u8 ecccdh_SECP256R1_5_test_vector_peer_pub_key[] = {
	0x33, 0xe8, 0x20, 0x92, 0xa0, 0xf1, 0xfb, 0x38, 0xf5, 0x64, 0x9d, 0x58, 0x67, 0xfb, 0xa2, 0x8b, 0x50, 0x31, 0x72, 0xb7, 0x03, 0x55, 0x74, 0xbf, 0x8e, 0x5b, 0x71, 0x00, 0xa3, 0x05, 0x27, 0x92, 0xf2, 0xcf, 0x6b, 0x60, 0x1e, 0x0a, 0x05, 0x94, 0x5e, 0x33, 0x55, 0x50, 0xbf, 0x64, 0x8d, 0x78, 0x2f, 0x46, 0x18, 0x6c, 0x77, 0x2c, 0x0f, 0x20, 0xd3, 0xcd, 0x0d, 0x6b, 0x8c, 0xa1, 0x4b, 0x2f,
};
static const u8 ecccdh_SECP256R1_5_test_vector_our_pub_key[] = {
	0x7b, 0x86, 0x1d, 0xcd, 0x28, 0x44, 0xa5, 0xa8, 0x36, 0x3f, 0x6b, 0x8e, 0xf8, 0xd4, 0x93, 0x64, 0x0f, 0x55, 0x87, 0x92, 0x17, 0x18, 0x9d, 0x80, 0x32, 0x6a, 0xad, 0x94, 0x80, 0xdf, 0xc1, 0x49, 0xc4, 0x67, 0x5b, 0x45, 0xee, 0xb3, 0x06, 0x40, 0x5f, 0x6c, 0x33, 0xc3, 0x8b, 0xc6, 0x9e, 0xb2, 0xbd, 0xec, 0x9b, 0x75, 0xad, 0x5a, 0xf4, 0x70, 0x6a, 0xab, 0x84, 0x54, 0x3b, 0x9c, 0xc6, 0x3a,
};
static const u8 ecccdh_SECP256R1_5_test_vector_shared_secret[] = {
	0x66, 0x4e, 0x45, 0xd5, 0xbb, 0xa4, 0xac, 0x93, 0x1c, 0xd6, 0x5d, 0x52, 0x01, 0x7e, 0x4b, 0xe9, 0xb1, 0x9a, 0x51, 0x5f, 0x66, 0x9b, 0xea, 0x47, 0x03, 0x54, 0x2a, 0x2c, 0x52, 0x5c, 0xd3, 0xd3,
};
static const ecdh_test_case ecccdh_SECP256R1_5_test_case = {
	.name = "ECCCDH/SECP256R1 5",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_5_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_5_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_5_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_5_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_5_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_5_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_5_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_5_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_6
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_6_test_vector_our_priv_key[] = {
	0x3b, 0x58, 0x9a, 0xf7, 0xdb, 0x03, 0x45, 0x9c, 0x23, 0x06, 0x8b, 0x64, 0xf6, 0x3f, 0x28, 0xd3, 0xc3, 0xc6, 0xbc, 0x25, 0xb5, 0xbf, 0x76, 0xac, 0x05, 0xf3, 0x54, 0x82, 0x88, 0x8b, 0x51, 0x90,
};
static const u8 ecccdh_SECP256R1_6_test_vector_peer_pub_key[] = {
	0x6a, 0x9e, 0x0c, 0x3f, 0x91, 0x6e, 0x4e, 0x31, 0x5c, 0x91, 0x14, 0x7b, 0xe5, 0x71, 0x68, 0x6d, 0x90, 0x46, 0x4e, 0x8b, 0xf9, 0x81, 0xd3, 0x4a, 0x90, 0xb6, 0x35, 0x3b, 0xca, 0x6e, 0xeb, 0xa7, 0x40, 0xf9, 0xbe, 0xad, 0x39, 0xc2, 0xf2, 0xbc, 0xc2, 0x60, 0x2f, 0x75, 0xb8, 0xa7, 0x3e, 0xc7, 0xbd, 0xff, 0xcb, 0xce, 0xad, 0x15, 0x9d, 0x01, 0x74, 0xc6, 0xc4, 0xd3, 0xc5, 0x35, 0x7f, 0x05,
};
static const u8 ecccdh_SECP256R1_6_test_vector_our_pub_key[] = {
	0x9f, 0xb3, 0x8e, 0x2d, 0x58, 0xea, 0x1b, 0xaf, 0x76, 0x22, 0xe9, 0x67, 0x20, 0x10, 0x1c, 0xae, 0x3c, 0xde, 0x4b, 0xa6, 0xc1, 0xe9, 0xfa, 0x26, 0xd9, 0xb1, 0xde, 0x08, 0x99, 0x10, 0x28, 0x63, 0xd5, 0x56, 0x1b, 0x90, 0x04, 0x06, 0xed, 0xf5, 0x08, 0x02, 0xdd, 0x7d, 0x73, 0xe8, 0x93, 0x95, 0xf8, 0xae, 0xd7, 0x2f, 0xba, 0x0e, 0x1d, 0x1b, 0x61, 0xfe, 0x1d, 0x22, 0x30, 0x22, 0x60, 0xf0,
};
static const u8 ecccdh_SECP256R1_6_test_vector_shared_secret[] = {
	0xca, 0x34, 0x2d, 0xaa, 0x50, 0xdc, 0x09, 0xd6, 0x1b, 0xe7, 0xc1, 0x96, 0xc8, 0x5e, 0x60, 0xa8, 0x0c, 0x5c, 0xb0, 0x49, 0x31, 0x74, 0x68, 0x20, 0xbe, 0x54, 0x8c, 0xdd, 0xe0, 0x55, 0x67, 0x9d,
};
static const ecdh_test_case ecccdh_SECP256R1_6_test_case = {
	.name = "ECCCDH/SECP256R1 6",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_6_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_6_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_6_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_6_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_6_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_6_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_6_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_6_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_7
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_7_test_vector_our_priv_key[] = {
	0xd8, 0xbf, 0x92, 0x9a, 0x20, 0xea, 0x74, 0x36, 0xb2, 0x46, 0x1b, 0x54, 0x1a, 0x11, 0xc8, 0x0e, 0x61, 0xd8, 0x26, 0xc0, 0xa4, 0xc9, 0xd3, 0x22, 0xb3, 0x1d, 0xd5, 0x4e, 0x7f, 0x58, 0xb9, 0xc8,
};
static const u8 ecccdh_SECP256R1_7_test_vector_peer_pub_key[] = {
	0xa9, 0xc0, 0xac, 0xad, 0xe5, 0x5c, 0x2a, 0x73, 0xea, 0xd1, 0xa8, 0x6f, 0xb0, 0xa9, 0x71, 0x32, 0x23, 0xc8, 0x24, 0x75, 0x79, 0x1c, 0xd0, 0xe2, 0x10, 0xb0, 0x46, 0x41, 0x2c, 0xe2, 0x24, 0xbb, 0xf6, 0xde, 0x0a, 0xfa, 0x20, 0xe9, 0x3e, 0x07, 0x84, 0x67, 0xc0, 0x53, 0xd2, 0x41, 0x90, 0x3e, 0xda, 0xd7, 0x34, 0xc6, 0xb4, 0x03, 0xba, 0x75, 0x8c, 0x2b, 0x5f, 0xf0, 0x4c, 0x9d, 0x42, 0x29,
};
static const u8 ecccdh_SECP256R1_7_test_vector_our_pub_key[] = {
	0x20, 0xf0, 0x76, 0x31, 0xe4, 0xa6, 0x51, 0x2a, 0x89, 0xad, 0x48, 0x7c, 0x4e, 0x9d, 0x63, 0x03, 0x9e, 0x57, 0x9c, 0xb0, 0xd7, 0xa5, 0x56, 0xcb, 0x9e, 0x66, 0x1c, 0xd5, 0x9c, 0x1e, 0x7f, 0xa4, 0x6d, 0xe9, 0x18, 0x46, 0xb3, 0xee, 0xe8, 0xa5, 0xec, 0x09, 0xc2, 0xab, 0x1f, 0x41, 0xe2, 0x1b, 0xd8, 0x36, 0x20, 0xcc, 0xdd, 0x1b, 0xdc, 0xe3, 0xab, 0x7e, 0xa6, 0xe0, 0x2d, 0xd2, 0x74, 0xf5,
};
static const u8 ecccdh_SECP256R1_7_test_vector_shared_secret[] = {
	0x35, 0xaa, 0x9b, 0x52, 0x53, 0x6a, 0x46, 0x1b, 0xfd, 0xe4, 0xe8, 0x5f, 0xc7, 0x56, 0xbe, 0x92, 0x8c, 0x7d, 0xe9, 0x79, 0x23, 0xf0, 0x41, 0x6c, 0x7a, 0x3a, 0xc8, 0xf8, 0x8b, 0x3d, 0x44, 0x89,
};
static const ecdh_test_case ecccdh_SECP256R1_7_test_case = {
	.name = "ECCCDH/SECP256R1 7",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_7_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_7_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_7_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_7_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_7_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_7_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_7_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_7_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_8
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_8_test_vector_our_priv_key[] = {
	0x0f, 0x98, 0x83, 0xba, 0x0e, 0xf3, 0x2e, 0xe7, 0x5d, 0xed, 0x0d, 0x8b, 0xda, 0x39, 0xa5, 0x14, 0x6a, 0x29, 0xf1, 0xf2, 0x50, 0x7b, 0x3b, 0xd4, 0x58, 0xdb, 0xea, 0x0b, 0x2b, 0xb0, 0x5b, 0x4d,
};
static const u8 ecccdh_SECP256R1_8_test_vector_peer_pub_key[] = {
	0x94, 0xe9, 0x4f, 0x16, 0xa9, 0x82, 0x55, 0xff, 0xf2, 0xb9, 0xac, 0x0c, 0x95, 0x98, 0xaa, 0xc3, 0x54, 0x87, 0xb3, 0x23, 0x2d, 0x32, 0x31, 0xbd, 0x93, 0xb7, 0xdb, 0x7d, 0xf3, 0x6f, 0x9e, 0xb9, 0xd8, 0x04, 0x9a, 0x43, 0x57, 0x9c, 0xfa, 0x90, 0xb8, 0x09, 0x3a, 0x94, 0x41, 0x6c, 0xbe, 0xfb, 0xf9, 0x33, 0x86, 0xf1, 0x5b, 0x3f, 0x6e, 0x19, 0x0b, 0x6e, 0x34, 0x55, 0xfe, 0xdf, 0xe6, 0x9a,
};
static const u8 ecccdh_SECP256R1_8_test_vector_our_pub_key[] = {
	0xab, 0xb6, 0x1b, 0x42, 0x3b, 0xe5, 0xd6, 0xc2, 0x6e, 0x21, 0xc6, 0x05, 0x83, 0x2c, 0x91, 0x42, 0xdc, 0x1d, 0xfe, 0x5a, 0x5f, 0xff, 0x28, 0x72, 0x67, 0x37, 0x93, 0x6e, 0x6f, 0xbf, 0x51, 0x6d, 0x73, 0x3d, 0x25, 0x13, 0xef, 0x58, 0xbe, 0xab, 0x20, 0x20, 0x90, 0x58, 0x6f, 0xac, 0x91, 0xbf, 0x0f, 0xee, 0x31, 0xe8, 0x0a, 0xb3, 0x34, 0x73, 0xab, 0x23, 0xa2, 0xd8, 0x9e, 0x58, 0xfa, 0xd6,
};
static const u8 ecccdh_SECP256R1_8_test_vector_shared_secret[] = {
	0x60, 0x5c, 0x16, 0x17, 0x8a, 0x9b, 0xc8, 0x75, 0xdc, 0xbf, 0xf5, 0x4d, 0x63, 0xfe, 0x00, 0xdf, 0x69, 0x9c, 0x03, 0xe8, 0xa8, 0x88, 0xe9, 0xe9, 0x4d, 0xfb, 0xab, 0x90, 0xb2, 0x5f, 0x39, 0xb4,
};
static const ecdh_test_case ecccdh_SECP256R1_8_test_case = {
	.name = "ECCCDH/SECP256R1 8",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_8_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_8_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_8_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_8_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_8_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_8_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_8_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_8_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_9
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_9_test_vector_our_priv_key[] = {
	0x2b, 0xee, 0xdb, 0x04, 0xb0, 0x5c, 0x69, 0x88, 0xf6, 0xa6, 0x75, 0x00, 0xbb, 0x81, 0x3f, 0xaf, 0x2c, 0xae, 0x0d, 0x58, 0x0c, 0x92, 0x53, 0xb6, 0x33, 0x9e, 0x4a, 0x33, 0x37, 0xbb, 0x6c, 0x08,
};
static const u8 ecccdh_SECP256R1_9_test_vector_peer_pub_key[] = {
	0xe0, 0x99, 0xbf, 0x2a, 0x4d, 0x55, 0x74, 0x60, 0xb5, 0x54, 0x44, 0x30, 0xbb, 0xf6, 0xda, 0x11, 0x00, 0x4d, 0x12, 0x7c, 0xb5, 0xd6, 0x7f, 0x64, 0xab, 0x07, 0xc9, 0x4f, 0xcd, 0xf5, 0x27, 0x4f, 0xd9, 0xc5, 0x0d, 0xbe, 0x70, 0xd7, 0x14, 0xed, 0xb5, 0xe2, 0x21, 0xf4, 0xe0, 0x20, 0x61, 0x0e, 0xeb, 0x62, 0x70, 0x51, 0x7e, 0x68, 0x8c, 0xa6, 0x4f, 0xb0, 0xe9, 0x8c, 0x7e, 0xf8, 0xc1, 0xc5,
};
static const u8 ecccdh_SECP256R1_9_test_vector_our_pub_key[] = {
	0x3d, 0x63, 0xe4, 0x29, 0xcb, 0x5f, 0xa8, 0x95, 0xa9, 0x24, 0x71, 0x29, 0xbf, 0x4e, 0x48, 0xe8, 0x9f, 0x35, 0xd7, 0xb1, 0x1d, 0xe8, 0x15, 0x8e, 0xfe, 0xb3, 0xe1, 0x06, 0xa2, 0xa8, 0x73, 0x95, 0x0c, 0xae, 0x9e, 0x47, 0x7e, 0xf4, 0x1e, 0x7c, 0x8c, 0x10, 0x64, 0x37, 0x9b, 0xb7, 0xb5, 0x54, 0xdd, 0xcb, 0xca, 0xe7, 0x9f, 0x98, 0x14, 0x28, 0x1f, 0x1e, 0x50, 0xf0, 0x40, 0x3c, 0x61, 0xf3,
};
static const u8 ecccdh_SECP256R1_9_test_vector_shared_secret[] = {
	0xf9, 0x6e, 0x40, 0xa1, 0xb7, 0x28, 0x40, 0x85, 0x4b, 0xb6, 0x2b, 0xc1, 0x3c, 0x40, 0xcc, 0x27, 0x95, 0xe3, 0x73, 0xd4, 0xe7, 0x15, 0x98, 0x0b, 0x26, 0x14, 0x76, 0x83, 0x5a, 0x09, 0x2e, 0x0b,
};
static const ecdh_test_case ecccdh_SECP256R1_9_test_case = {
	.name = "ECCCDH/SECP256R1 9",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_9_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_9_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_9_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_9_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_9_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_9_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_9_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_9_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_10
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_10_test_vector_our_priv_key[] = {
	0x77, 0xc1, 0x5d, 0xcf, 0x44, 0x61, 0x0e, 0x41, 0x69, 0x6b, 0xab, 0x75, 0x89, 0x43, 0xef, 0xf1, 0x40, 0x93, 0x33, 0xe4, 0xd5, 0xa1, 0x1b, 0xbe, 0x72, 0xc8, 0xf6, 0xc3, 0x95, 0xe9, 0xf8, 0x48,
};
static const u8 ecccdh_SECP256R1_10_test_vector_peer_pub_key[] = {
	0xf7, 0x5a, 0x5f, 0xe5, 0x6b, 0xda, 0x34, 0xf3, 0xc1, 0x39, 0x62, 0x96, 0x62, 0x6e, 0xf0, 0x12, 0xdc, 0x07, 0xe4, 0x82, 0x58, 0x38, 0x77, 0x8a, 0x64, 0x5c, 0x82, 0x48, 0xcf, 0xf0, 0x16, 0x58, 0x33, 0xbb, 0xdf, 0x1b, 0x17, 0x72, 0xd8, 0x05, 0x9d, 0xf5, 0x68, 0xb0, 0x61, 0xf3, 0xf1, 0x12, 0x2f, 0x28, 0xa8, 0xd8, 0x19, 0x16, 0x7c, 0x97, 0xbe, 0x44, 0x8e, 0x3d, 0xc3, 0xfb, 0x0c, 0x3c,
};
static const u8 ecccdh_SECP256R1_10_test_vector_our_pub_key[] = {
	0xad, 0x5d, 0x13, 0xc3, 0xdb, 0x50, 0x8d, 0xdc, 0xd3, 0x84, 0x57, 0xe5, 0x99, 0x14, 0x34, 0xa2, 0x51, 0xbe, 0xd4, 0x9c, 0xf5, 0xdd, 0xcb, 0x59, 0xcd, 0xee, 0x73, 0x86, 0x5f, 0x13, 0x8c, 0x9f, 0x62, 0xce, 0xc1, 0xe7, 0x05, 0x88, 0xaa, 0x4f, 0xdf, 0xc7, 0xb9, 0xa0, 0x9d, 0xaa, 0x67, 0x80, 0x81, 0xc0, 0x4e, 0x12, 0x08, 0xb9, 0xd6, 0x62, 0xb8, 0xa2, 0x21, 0x4b, 0xf8, 0xe8, 0x1a, 0x21,
};
static const u8 ecccdh_SECP256R1_10_test_vector_shared_secret[] = {
	0x83, 0x88, 0xfa, 0x79, 0xc4, 0xba, 0xbd, 0xca, 0x02, 0xa8, 0xe8, 0xa3, 0x4f, 0x9e, 0x43, 0x55, 0x49, 0x76, 0xe4, 0x20, 0xa4, 0xad, 0x27, 0x3c, 0x81, 0xb2, 0x6e, 0x42, 0x28, 0xe9, 0xd3, 0xa3,
};
static const ecdh_test_case ecccdh_SECP256R1_10_test_case = {
	.name = "ECCCDH/SECP256R1 10",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_10_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_10_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_10_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_10_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_10_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_10_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_10_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_10_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_11
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_11_test_vector_our_priv_key[] = {
	0x42, 0xa8, 0x3b, 0x98, 0x50, 0x11, 0xd1, 0x23, 0x03, 0xdb, 0x1a, 0x80, 0x0f, 0x26, 0x10, 0xf7, 0x4a, 0xa7, 0x1c, 0xdf, 0x19, 0xc6, 0x7d, 0x54, 0xce, 0x6c, 0x9e, 0xd9, 0x51, 0xe9, 0x09, 0x3e,
};
static const u8 ecccdh_SECP256R1_11_test_vector_peer_pub_key[] = {
	0x2d, 0xb4, 0x54, 0x0d, 0x50, 0x23, 0x07, 0x56, 0x15, 0x8a, 0xbf, 0x61, 0xd9, 0x83, 0x57, 0x12, 0xb6, 0x48, 0x6c, 0x74, 0x31, 0x21, 0x83, 0xcc, 0xef, 0xca, 0xef, 0x27, 0x97, 0xb7, 0x67, 0x4d, 0x62, 0xf5, 0x7f, 0x31, 0x4e, 0x3f, 0x34, 0x95, 0xdc, 0x4e, 0x09, 0x90, 0x12, 0xf5, 0xe0, 0xba, 0x71, 0x77, 0x0f, 0x96, 0x60, 0xa1, 0xea, 0xda, 0x54, 0x10, 0x4c, 0xdf, 0xde, 0x77, 0x24, 0x3e,
};
static const u8 ecccdh_SECP256R1_11_test_vector_our_pub_key[] = {
	0xab, 0x48, 0xca, 0xa6, 0x1e, 0xa3, 0x5f, 0x13, 0xf8, 0xed, 0x07, 0xff, 0xa6, 0xa1, 0x3e, 0x8d, 0xb2, 0x24, 0xdf, 0xec, 0xfa, 0xe1, 0xa7, 0xdf, 0x8b, 0x1b, 0xb6, 0xeb, 0xaf, 0x0c, 0xb9, 0x7d, 0x12, 0x74, 0x53, 0x0c, 0xa2, 0xc3, 0x85, 0xa3, 0x21, 0x8b, 0xdd, 0xfb, 0xcb, 0xf0, 0xb4, 0x02, 0x4c, 0x9b, 0xad, 0xd5, 0x24, 0x3b, 0xff, 0x83, 0x4e, 0xbf, 0xf2, 0x4a, 0x86, 0x18, 0xdc, 0xcb,
};
static const u8 ecccdh_SECP256R1_11_test_vector_shared_secret[] = {
	0x72, 0x87, 0x7c, 0xea, 0x33, 0xcc, 0xc4, 0x71, 0x50, 0x38, 0xd4, 0xbc, 0xbd, 0xfe, 0x0e, 0x43, 0xf4, 0x2a, 0x9e, 0x2c, 0x0c, 0x3b, 0x01, 0x7f, 0xc2, 0x37, 0x0f, 0x4b, 0x9a, 0xcb, 0xda, 0x4a,
};
static const ecdh_test_case ecccdh_SECP256R1_11_test_case = {
	.name = "ECCCDH/SECP256R1 11",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_11_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_11_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_11_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_11_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_11_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_11_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_11_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_11_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_12
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_12_test_vector_our_priv_key[] = {
	0xce, 0xed, 0x35, 0x50, 0x7b, 0x5c, 0x93, 0xea, 0xd5, 0x98, 0x91, 0x19, 0xb9, 0xba, 0x34, 0x2c, 0xfe, 0x38, 0xe6, 0xe6, 0x38, 0xba, 0x6e, 0xea, 0x34, 0x3a, 0x55, 0x47, 0x5d, 0xe2, 0x80, 0x0b,
};
static const u8 ecccdh_SECP256R1_12_test_vector_peer_pub_key[] = {
	0xcd, 0x94, 0xfc, 0x94, 0x97, 0xe8, 0x99, 0x07, 0x50, 0x30, 0x9e, 0x9a, 0x85, 0x34, 0xfd, 0x11, 0x4b, 0x0a, 0x6e, 0x54, 0xda, 0x89, 0xc4, 0x79, 0x61, 0x01, 0x89, 0x70, 0x41, 0xd1, 0x4e, 0xcb, 0xc3, 0xde, 0xf4, 0xb5, 0xfe, 0x04, 0xfa, 0xee, 0x0a, 0x11, 0x93, 0x22, 0x29, 0xff, 0xf5, 0x63, 0x63, 0x7b, 0xfd, 0xee, 0x0e, 0x79, 0xc6, 0xde, 0xea, 0xf4, 0x49, 0xf8, 0x54, 0x01, 0xc5, 0xc4,
};
static const u8 ecccdh_SECP256R1_12_test_vector_our_pub_key[] = {
	0x9a, 0x8c, 0xd9, 0xbd, 0x72, 0xe7, 0x17, 0x52, 0xdf, 0x91, 0x44, 0x0f, 0x77, 0xc5, 0x47, 0x50, 0x9a, 0x84, 0xdf, 0x98, 0x11, 0x4e, 0x7d, 0xe4, 0xf2, 0x6c, 0xdb, 0x39, 0x23, 0x4a, 0x62, 0x5d, 0xd0, 0x7c, 0xfc, 0x84, 0xc8, 0xe1, 0x44, 0xfa, 0xb2, 0x83, 0x9f, 0x51, 0x89, 0xbb, 0x1d, 0x7c, 0x88, 0x63, 0x1d, 0x57, 0x9b, 0xbc, 0x58, 0x01, 0x2e, 0xd9, 0xa2, 0x32, 0x7d, 0xa5, 0x2f, 0x62,
};
static const u8 ecccdh_SECP256R1_12_test_vector_shared_secret[] = {
	0xe4, 0xe7, 0x40, 0x8d, 0x85, 0xff, 0x0e, 0x0e, 0x9c, 0x83, 0x80, 0x03, 0xf2, 0x8c, 0xdb, 0xd5, 0x24, 0x7c, 0xdc, 0xe3, 0x1f, 0x32, 0xf6, 0x24, 0x94, 0xb7, 0x0e, 0x5f, 0x1b, 0xc3, 0x63, 0x07,
};
static const ecdh_test_case ecccdh_SECP256R1_12_test_case = {
	.name = "ECCCDH/SECP256R1 12",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_12_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_12_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_12_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_12_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_12_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_12_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_12_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_12_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_13
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_13_test_vector_our_priv_key[] = {
	0x43, 0xe0, 0xe9, 0xd9, 0x5a, 0xf4, 0xdc, 0x36, 0x48, 0x3c, 0xdd, 0x19, 0x68, 0xd2, 0xb7, 0xee, 0xb8, 0x61, 0x1f, 0xcc, 0xe7, 0x7f, 0x3a, 0x4e, 0x7d, 0x05, 0x9a, 0xe4, 0x3e, 0x50, 0x96, 0x04,
};
static const u8 ecccdh_SECP256R1_13_test_vector_peer_pub_key[] = {
	0x15, 0xb9, 0xe4, 0x67, 0xaf, 0x4d, 0x29, 0x0c, 0x41, 0x74, 0x02, 0xe0, 0x40, 0x42, 0x6f, 0xe4, 0xcf, 0x23, 0x6b, 0xae, 0x72, 0xba, 0xa3, 0x92, 0xed, 0x89, 0x78, 0x0d, 0xfc, 0xcd, 0xb4, 0x71, 0xcd, 0xf4, 0xe9, 0x17, 0x0f, 0xb9, 0x04, 0x30, 0x2b, 0x8f, 0xd9, 0x3a, 0x82, 0x0b, 0xa8, 0xcc, 0x7e, 0xd4, 0xef, 0xd3, 0xa6, 0xf2, 0xd6, 0xb0, 0x5b, 0x80, 0xb2, 0xff, 0x2a, 0xee, 0x4e, 0x77,
};
static const u8 ecccdh_SECP256R1_13_test_vector_our_pub_key[] = {
	0xf9, 0x89, 0xcf, 0x8e, 0xe9, 0x56, 0xa8, 0x2e, 0x7e, 0xbd, 0x98, 0x81, 0xcd, 0xbf, 0xb2, 0xfd, 0x94, 0x61, 0x89, 0xb0, 0x8d, 0xb5, 0x35, 0x59, 0xbc, 0x8c, 0xfd, 0xd4, 0x80, 0x71, 0xeb, 0x14, 0x5e, 0xff, 0x28, 0xf1, 0xa1, 0x8a, 0x61, 0x6b, 0x04, 0xb7, 0xd3, 0x37, 0x86, 0x86, 0x79, 0xf6, 0xdd, 0x84, 0xf9, 0xa7, 0xb3, 0xd7, 0xb6, 0xf8, 0xaf, 0x27, 0x6c, 0x19, 0x61, 0x1a, 0x54, 0x1d,
};
static const u8 ecccdh_SECP256R1_13_test_vector_shared_secret[] = {
	0xed, 0x56, 0xbc, 0xf6, 0x95, 0xb7, 0x34, 0x14, 0x2c, 0x24, 0xec, 0xb1, 0xfc, 0x1b, 0xb6, 0x4d, 0x08, 0xf1, 0x75, 0xeb, 0x24, 0x3a, 0x31, 0xf3, 0x7b, 0x3d, 0x9b, 0xb4, 0x40, 0x7f, 0x3b, 0x96,
};
static const ecdh_test_case ecccdh_SECP256R1_13_test_case = {
	.name = "ECCCDH/SECP256R1 13",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_13_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_13_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_13_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_13_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_13_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_13_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_13_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_13_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_14
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_14_test_vector_our_priv_key[] = {
	0xb2, 0xf3, 0x60, 0x0d, 0xf3, 0x36, 0x8e, 0xf8, 0xa0, 0xbb, 0x85, 0xab, 0x22, 0xf4, 0x1f, 0xc0, 0xe5, 0xf4, 0xfd, 0xd5, 0x4b, 0xe8, 0x16, 0x7a, 0x5c, 0x3c, 0xd4, 0xb0, 0x8d, 0xb0, 0x49, 0x03,
};
static const u8 ecccdh_SECP256R1_14_test_vector_peer_pub_key[] = {
	0x49, 0xc5, 0x03, 0xba, 0x6c, 0x4f, 0xa6, 0x05, 0x18, 0x2e, 0x18, 0x6b, 0x5e, 0x81, 0x11, 0x3f, 0x07, 0x5b, 0xc1, 0x1d, 0xcf, 0xd5, 0x1c, 0x93, 0x2f, 0xb2, 0x1e, 0x95, 0x1e, 0xee, 0x2f, 0xa1, 0x8a, 0xf7, 0x06, 0xff, 0x09, 0x22, 0xd8, 0x7b, 0x3f, 0x0c, 0x5e, 0x4e, 0x31, 0xd8, 0xb2, 0x59, 0xae, 0xb2, 0x60, 0xa9, 0x26, 0x96, 0x43, 0xed, 0x52, 0x0a, 0x13, 0xbb, 0x25, 0xda, 0x59, 0x24,
};
static const u8 ecccdh_SECP256R1_14_test_vector_our_pub_key[] = {
	0x69, 0xc6, 0x27, 0x62, 0x5b, 0x36, 0xa4, 0x29, 0xc3, 0x98, 0xb4, 0x5c, 0x38, 0x67, 0x7c, 0xb3, 0x5d, 0x8b, 0xeb, 0x1c, 0xf7, 0x8a, 0x57, 0x1e, 0x40, 0xe9, 0x9f, 0xe4, 0xea, 0xc1, 0xcd, 0x4e, 0x81, 0x69, 0x01, 0x12, 0xb0, 0xa8, 0x8f, 0x20, 0xf7, 0x13, 0x6b, 0x28, 0xd7, 0xd4, 0x7e, 0x5f, 0xbc, 0x2a, 0xda, 0x3c, 0x8e, 0xdd, 0x87, 0x58, 0x9b, 0xc1, 0x9e, 0xc9, 0x59, 0x06, 0x37, 0xbd,
};
static const u8 ecccdh_SECP256R1_14_test_vector_shared_secret[] = {
	0xbc, 0x5c, 0x70, 0x55, 0x08, 0x9f, 0xc9, 0xd6, 0xc8, 0x9f, 0x83, 0xc1, 0xea, 0x1a, 0xda, 0x87, 0x9d, 0x99, 0x34, 0xb2, 0xea, 0x28, 0xfc, 0xf4, 0xe4, 0xa7, 0xe9, 0x84, 0xb2, 0x8a, 0xd2, 0xcf,
};
static const ecdh_test_case ecccdh_SECP256R1_14_test_case = {
	.name = "ECCCDH/SECP256R1 14",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_14_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_14_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_14_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_14_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_14_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_14_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_14_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_14_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_15
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_15_test_vector_our_priv_key[] = {
	0x40, 0x02, 0x53, 0x43, 0x07, 0xf8, 0xb6, 0x2a, 0x9b, 0xf6, 0x7f, 0xf6, 0x41, 0xdd, 0xc6, 0x0f, 0xef, 0x59, 0x3b, 0x17, 0xc3, 0x34, 0x12, 0x39, 0xe9, 0x5b, 0xdb, 0x3e, 0x57, 0x9b, 0xfd, 0xc8,
};
static const u8 ecccdh_SECP256R1_15_test_vector_peer_pub_key[] = {
	0x19, 0xb3, 0x8d, 0xe3, 0x9f, 0xdd, 0x2f, 0x70, 0xf7, 0x09, 0x16, 0x31, 0xa4, 0xf7, 0x5d, 0x19, 0x93, 0x74, 0x0b, 0xa9, 0x42, 0x91, 0x62, 0xc2, 0xa4, 0x53, 0x12, 0x40, 0x16, 0x36, 0xb2, 0x9c, 0x09, 0xae, 0xd7, 0x23, 0x2b, 0x28, 0xe0, 0x60, 0x94, 0x17, 0x41, 0xb6, 0x82, 0x8b, 0xcd, 0xfa, 0x2b, 0xc4, 0x9c, 0xc8, 0x44, 0xf3, 0x77, 0x36, 0x11, 0x50, 0x4f, 0x82, 0xa3, 0x90, 0xa5, 0xae,
};
static const u8 ecccdh_SECP256R1_15_test_vector_our_pub_key[] = {
	0x5f, 0xe9, 0x64, 0x67, 0x13, 0x15, 0xa1, 0x8a, 0xa6, 0x8a, 0x2a, 0x6e, 0x3d, 0xd1, 0xfd, 0xe7, 0xe2, 0x3b, 0x8c, 0xe7, 0x18, 0x14, 0x71, 0xcf, 0xac, 0x43, 0xc9, 0x9e, 0x1a, 0xe8, 0x02, 0x62, 0xd5, 0x82, 0x7b, 0xe2, 0x82, 0xe6, 0x2c, 0x84, 0xde, 0x53, 0x1b, 0x96, 0x38, 0x84, 0xba, 0x83, 0x2d, 0xb5, 0xd6, 0xb2, 0xc3, 0xa2, 0x56, 0xf0, 0xe6, 0x04, 0xfe, 0x7e, 0x6b, 0x8a, 0x7f, 0x72,
};
static const u8 ecccdh_SECP256R1_15_test_vector_shared_secret[] = {
	0x9a, 0x4e, 0x8e, 0x65, 0x7f, 0x6b, 0x0e, 0x09, 0x7f, 0x47, 0x95, 0x4a, 0x63, 0xc7, 0x5d, 0x74, 0xfc, 0xba, 0x71, 0xa3, 0x0d, 0x83, 0x65, 0x1e, 0x3e, 0x5a, 0x91, 0xaa, 0x7c, 0xcd, 0x83, 0x43,
};
static const ecdh_test_case ecccdh_SECP256R1_15_test_case = {
	.name = "ECCCDH/SECP256R1 15",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_15_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_15_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_15_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_15_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_15_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_15_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_15_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_15_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_16
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_16_test_vector_our_priv_key[] = {
	0x4d, 0xfa, 0x12, 0xde, 0xfc, 0x60, 0x31, 0x90, 0x21, 0xb6, 0x81, 0xb3, 0xff, 0x84, 0xa1, 0x0a, 0x51, 0x19, 0x58, 0xc8, 0x50, 0x93, 0x9e, 0xd4, 0x56, 0x35, 0x93, 0x4b, 0xa4, 0x97, 0x91, 0x47,
};
static const u8 ecccdh_SECP256R1_16_test_vector_peer_pub_key[] = {
	0x2c, 0x91, 0xc6, 0x1f, 0x33, 0xad, 0xfe, 0x93, 0x11, 0xc9, 0x42, 0xfd, 0xbf, 0xf6, 0xba, 0x47, 0x02, 0x0f, 0xef, 0xf4, 0x16, 0xb7, 0xbb, 0x63, 0xce, 0xc1, 0x3f, 0xaf, 0x9b, 0x09, 0x99, 0x54, 0x6c, 0xab, 0x31, 0xb0, 0x64, 0x19, 0xe5, 0x22, 0x1f, 0xca, 0x01, 0x4f, 0xb8, 0x4e, 0xc8, 0x70, 0x62, 0x2a, 0x1b, 0x12, 0xba, 0xb5, 0xae, 0x43, 0x68, 0x2a, 0xa7, 0xea, 0x73, 0xea, 0x08, 0xd0,
};
static const u8 ecccdh_SECP256R1_16_test_vector_our_pub_key[] = {
	0xc9, 0xb2, 0xb8, 0x49, 0x6f, 0x14, 0x40, 0xbd, 0x4a, 0x2d, 0x1e, 0x52, 0x75, 0x2f, 0xd3, 0x72, 0x83, 0x5b, 0x36, 0x48, 0x85, 0xe1, 0x54, 0xa7, 0xda, 0xc4, 0x92, 0x95, 0xf2, 0x81, 0xec, 0x7c, 0xfb, 0xe6, 0xb9, 0x26, 0xa8, 0xa4, 0xde, 0x26, 0xcc, 0xc8, 0x3b, 0x80, 0x2b, 0x12, 0x12, 0x40, 0x07, 0x54, 0xbe, 0x25, 0xd9, 0xf3, 0xee, 0xaf, 0x00, 0x8b, 0x09, 0x87, 0x0a, 0xe7, 0x63, 0x21,
};
static const u8 ecccdh_SECP256R1_16_test_vector_shared_secret[] = {
	0x3c, 0xa1, 0xfc, 0x7a, 0xd8, 0x58, 0xfb, 0x1a, 0x6a, 0xba, 0x23, 0x25, 0x42, 0xf3, 0xe2, 0xa7, 0x49, 0xff, 0xc7, 0x20, 0x3a, 0x23, 0x74, 0xa3, 0xf3, 0xd3, 0x26, 0x7f, 0x1f, 0xc9, 0x7b, 0x78,
};
static const ecdh_test_case ecccdh_SECP256R1_16_test_case = {
	.name = "ECCCDH/SECP256R1 16",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_16_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_16_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_16_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_16_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_16_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_16_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_16_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_16_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_17
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_17_test_vector_our_priv_key[] = {
	0x13, 0x31, 0xf6, 0xd8, 0x74, 0xa4, 0xed, 0x3b, 0xc4, 0xa2, 0xc6, 0xe9, 0xc7, 0x43, 0x31, 0xd3, 0x03, 0x97, 0x96, 0x31, 0x4b, 0xee, 0xe3, 0xb7, 0x15, 0x2f, 0xcd, 0xba, 0x55, 0x56, 0x30, 0x4e,
};
static const u8 ecccdh_SECP256R1_17_test_vector_peer_pub_key[] = {
	0xa2, 0x8a, 0x2e, 0xdf, 0x58, 0x02, 0x56, 0x68, 0xf7, 0x24, 0xaa, 0xf8, 0x3a, 0x50, 0x95, 0x6b, 0x7a, 0xc1, 0xcf, 0xbb, 0xff, 0x79, 0xb0, 0x8c, 0x3b, 0xf8, 0x7d, 0xfd, 0x28, 0x28, 0xd7, 0x67, 0xdf, 0xa7, 0xbf, 0xff, 0xd4, 0xc7, 0x66, 0xb8, 0x6a, 0xbe, 0xaf, 0x5c, 0x99, 0xb6, 0xe5, 0x0c, 0xb9, 0xcc, 0xc9, 0xd9, 0xd0, 0x0b, 0x7f, 0xfc, 0x78, 0x04, 0xb0, 0x49, 0x1b, 0x67, 0xbc, 0x03,
};
static const u8 ecccdh_SECP256R1_17_test_vector_our_pub_key[] = {
	0x59, 0xe1, 0xe1, 0x01, 0x52, 0x10, 0x46, 0xad, 0x9c, 0xf1, 0xd0, 0x82, 0xe9, 0xd2, 0xec, 0x7d, 0xd2, 0x25, 0x30, 0xcc, 0xe0, 0x64, 0x99, 0x1f, 0x1e, 0x55, 0xc5, 0xbc, 0xf5, 0xfc, 0xb5, 0x91, 0x48, 0x2f, 0x4f, 0x67, 0x31, 0x76, 0xc8, 0xfd, 0xaa, 0x0b, 0xb6, 0xe5, 0x9b, 0x15, 0xa3, 0xe4, 0x74, 0x54, 0xe3, 0xa0, 0x42, 0x97, 0xd3, 0x86, 0x3c, 0x93, 0x38, 0xd9, 0x8a, 0xdd, 0x1f, 0x37,
};
static const u8 ecccdh_SECP256R1_17_test_vector_shared_secret[] = {
	0x1a, 0xaa, 0xbe, 0x7e, 0xe6, 0xe4, 0xa6, 0xfa, 0x73, 0x22, 0x91, 0x20, 0x24, 0x33, 0xa2, 0x37, 0xdf, 0x1b, 0x49, 0xbc, 0x53, 0x86, 0x6b, 0xfb, 0xe0, 0x0d, 0xb9, 0x6a, 0x0f, 0x58, 0x22, 0x4f,
};
static const ecdh_test_case ecccdh_SECP256R1_17_test_case = {
	.name = "ECCCDH/SECP256R1 17",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_17_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_17_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_17_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_17_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_17_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_17_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_17_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_17_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_18
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_18_test_vector_our_priv_key[] = {
	0xdd, 0x5e, 0x9f, 0x70, 0xae, 0x74, 0x00, 0x73, 0xca, 0x02, 0x04, 0xdf, 0x60, 0x76, 0x3f, 0xb6, 0x03, 0x6c, 0x45, 0x70, 0x9b, 0xf4, 0xa7, 0xbb, 0x4e, 0x67, 0x14, 0x12, 0xfa, 0xd6, 0x5d, 0xa3,
};
static const u8 ecccdh_SECP256R1_18_test_vector_peer_pub_key[] = {
	0xa2, 0xef, 0x85, 0x7a, 0x08, 0x1f, 0x9d, 0x6e, 0xb2, 0x06, 0xa8, 0x1c, 0x4c, 0xf7, 0x8a, 0x80, 0x2b, 0xdf, 0x59, 0x8a, 0xe3, 0x80, 0xc8, 0x88, 0x6e, 0xcd, 0x85, 0xfd, 0xc1, 0xed, 0x76, 0x44, 0x56, 0x3c, 0x4c, 0x20, 0x41, 0x9f, 0x07, 0xbc, 0x17, 0xd0, 0x53, 0x9f, 0xad, 0xe1, 0x85, 0x5e, 0x34, 0x83, 0x95, 0x15, 0xb8, 0x92, 0xc0, 0xf5, 0xd2, 0x65, 0x61, 0xf9, 0x7f, 0xa0, 0x4d, 0x1a,
};
static const u8 ecccdh_SECP256R1_18_test_vector_our_pub_key[] = {
	0x30, 0xb9, 0xdb, 0x2e, 0x2e, 0x97, 0x7b, 0xcd, 0xc9, 0x8c, 0xb8, 0x7d, 0xd7, 0x36, 0xcb, 0xd8, 0xe7, 0x85, 0x52, 0x12, 0x19, 0x25, 0xcf, 0x16, 0xe1, 0x93, 0x36, 0x57, 0xc2, 0xfb, 0x23, 0x14, 0x6a, 0x45, 0x02, 0x88, 0x00, 0xb8, 0x12, 0x91, 0xbc, 0xe5, 0xc2, 0xe1, 0xfe, 0xd7, 0xde, 0xd6, 0x50, 0x62, 0x0e, 0xbb, 0xe6, 0x05, 0x0c, 0x6f, 0x3a, 0x7f, 0x0d, 0xfb, 0x46, 0x73, 0xab, 0x5c,
};
static const u8 ecccdh_SECP256R1_18_test_vector_shared_secret[] = {
	0x43, 0x0e, 0x6a, 0x4f, 0xba, 0x44, 0x49, 0xd7, 0x00, 0xd2, 0x73, 0x3e, 0x55, 0x7f, 0x66, 0xa3, 0xbf, 0x3d, 0x50, 0x51, 0x7c, 0x12, 0x71, 0xb1, 0xdd, 0xae, 0x11, 0x61, 0xb7, 0xac, 0x79, 0x8c,
};
static const ecdh_test_case ecccdh_SECP256R1_18_test_case = {
	.name = "ECCCDH/SECP256R1 18",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_18_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_18_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_18_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_18_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_18_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_18_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_18_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_18_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_19
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_19_test_vector_our_priv_key[] = {
	0x5a, 0xe0, 0x26, 0xcf, 0xc0, 0x60, 0xd5, 0x56, 0x00, 0x71, 0x7e, 0x55, 0xb8, 0xa1, 0x2e, 0x11, 0x6d, 0x1d, 0x0d, 0xf3, 0x4a, 0xf8, 0x31, 0x97, 0x90, 0x57, 0x60, 0x7c, 0x2d, 0x9c, 0x2f, 0x76,
};
static const u8 ecccdh_SECP256R1_19_test_vector_peer_pub_key[] = {
	0xcc, 0xd8, 0xa2, 0xd8, 0x6b, 0xc9, 0x2f, 0x2e, 0x01, 0xbc, 0xe4, 0xd6, 0x92, 0x2c, 0xf7, 0xfe, 0x16, 0x26, 0xae, 0xd0, 0x44, 0x68, 0x5e, 0x95, 0xe2, 0xee, 0xbd, 0x46, 0x45, 0x05, 0xf0, 0x1f, 0xe9, 0xdd, 0xd5, 0x83, 0xa9, 0x63, 0x5a, 0x66, 0x77, 0x77, 0xd5, 0xb8, 0xa8, 0xf3, 0x1b, 0x0f, 0x79, 0xeb, 0xa1, 0x2c, 0x75, 0x02, 0x34, 0x10, 0xb5, 0x4b, 0x85, 0x67, 0xdd, 0xdc, 0x0f, 0x38,
};
static const u8 ecccdh_SECP256R1_19_test_vector_our_pub_key[] = {
	0x46, 0xc9, 0xeb, 0xd1, 0xa4, 0xa3, 0xc8, 0xc0, 0xb6, 0xd5, 0x72, 0xb5, 0xdc, 0xfb, 0xa1, 0x24, 0x67, 0x60, 0x32, 0x08, 0xa9, 0xcb, 0x5d, 0x2a, 0xcf, 0xbb, 0x73, 0x3c, 0x40, 0xcf, 0x63, 0x91, 0x46, 0xc9, 0x13, 0xa2, 0x7d, 0x04, 0x41, 0x85, 0xd3, 0x8b, 0x46, 0x7a, 0xce, 0x01, 0x1e, 0x04, 0xd4, 0xd9, 0xbb, 0xbb, 0x8c, 0xb9, 0xae, 0x25, 0xfa, 0x92, 0xaa, 0xf1, 0x5a, 0x59, 0x5e, 0x86,
};
static const u8 ecccdh_SECP256R1_19_test_vector_shared_secret[] = {
	0x1c, 0xe9, 0xe6, 0x74, 0x05, 0x29, 0x49, 0x9f, 0x98, 0xd1, 0xf1, 0xd7, 0x13, 0x29, 0x14, 0x7a, 0x33, 0xdf, 0x1d, 0x05, 0xe4, 0x76, 0x5b, 0x53, 0x9b, 0x11, 0xcf, 0x61, 0x5d, 0x69, 0x74, 0xd3,
};
static const ecdh_test_case ecccdh_SECP256R1_19_test_case = {
	.name = "ECCCDH/SECP256R1 19",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_19_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_19_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_19_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_19_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_19_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_19_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_19_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_19_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_20
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_20_test_vector_our_priv_key[] = {
	0xb6, 0x01, 0xac, 0x42, 0x5d, 0x5d, 0xbf, 0x9e, 0x17, 0x35, 0xc5, 0xe2, 0xd5, 0xbd, 0xb7, 0x9c, 0xa9, 0x8b, 0x3d, 0x5b, 0xe4, 0xa2, 0xcf, 0xd6, 0xf2, 0x27, 0x3f, 0x15, 0x0e, 0x06, 0x4d, 0x9d,
};
static const u8 ecccdh_SECP256R1_20_test_vector_peer_pub_key[] = {
	0xc1, 0x88, 0xff, 0xc8, 0x94, 0x7f, 0x73, 0x01, 0xfb, 0x7b, 0x53, 0xe3, 0x67, 0x46, 0x09, 0x7c, 0x21, 0x34, 0xbf, 0x9c, 0xc9, 0x81, 0xba, 0x74, 0xb4, 0xe9, 0xc4, 0x36, 0x1f, 0x59, 0x5e, 0x4e, 0xbf, 0x7d, 0x2f, 0x20, 0x56, 0xe7, 0x24, 0x21, 0xef, 0x39, 0x3f, 0x0c, 0x0f, 0x2b, 0x0e, 0x00, 0x13, 0x0e, 0x3c, 0xac, 0x4a, 0xbb, 0xcc, 0x00, 0x28, 0x61, 0x68, 0xe8, 0x5e, 0xc5, 0x50, 0x51,
};
static const u8 ecccdh_SECP256R1_20_test_vector_our_pub_key[] = {
	0x7c, 0x9e, 0x95, 0x08, 0x41, 0xd2, 0x6c, 0x8d, 0xde, 0x89, 0x94, 0x39, 0x8b, 0x8f, 0x5d, 0x47, 0x5a, 0x02, 0x2b, 0xc6, 0x3d, 0xe7, 0x77, 0x3f, 0xcf, 0x8d, 0x55, 0x2e, 0x01, 0xf1, 0xba, 0x0a, 0xcc, 0x42, 0xb9, 0x88, 0x5c, 0x9b, 0x3b, 0xee, 0x0f, 0x8d, 0x8c, 0x57, 0xd3, 0xa8, 0xf6, 0x35, 0x50, 0x16, 0xc0, 0x19, 0xc4, 0x06, 0x2f, 0xa2, 0x2c, 0xff, 0x2f, 0x20, 0x9b, 0x5c, 0xc2, 0xe1,
};
static const u8 ecccdh_SECP256R1_20_test_vector_shared_secret[] = {
	0x46, 0x90, 0xe3, 0x74, 0x3c, 0x07, 0xd6, 0x43, 0xf1, 0xbc, 0x18, 0x36, 0x36, 0xab, 0x2a, 0x9c, 0xb9, 0x36, 0xa6, 0x0a, 0x80, 0x21, 0x13, 0xc4, 0x9b, 0xb1, 0xb3, 0xf2, 0xd0, 0x66, 0x16, 0x60,
};
static const ecdh_test_case ecccdh_SECP256R1_20_test_case = {
	.name = "ECCCDH/SECP256R1 20",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_20_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_20_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_20_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_20_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_20_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_20_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_20_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_20_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_21
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_21_test_vector_our_priv_key[] = {
	0xfe, 0xfb, 0x1d, 0xda, 0x18, 0x45, 0x31, 0x2b, 0x5f, 0xce, 0x6b, 0x81, 0xb2, 0xbe, 0x20, 0x5a, 0xf2, 0xf3, 0xa2, 0x74, 0xf5, 0xa2, 0x12, 0xf6, 0x6c, 0x0d, 0x9f, 0xc3, 0x3d, 0x7a, 0xe5, 0x35,
};
static const u8 ecccdh_SECP256R1_21_test_vector_peer_pub_key[] = {
	0x31, 0x7e, 0x10, 0x20, 0xff, 0x53, 0xfc, 0xce, 0xf1, 0x8b, 0xf4, 0x7b, 0xb7, 0xf2, 0xdd, 0x77, 0x07, 0xfb, 0x7b, 0x7a, 0x75, 0x78, 0xe0, 0x4f, 0x35, 0xb3, 0xbe, 0xed, 0x22, 0x2a, 0x0e, 0xb6, 0x09, 0x42, 0x0c, 0xe5, 0xa1, 0x9d, 0x77, 0xc6, 0xfe, 0x1e, 0xe5, 0x87, 0xe6, 0xa4, 0x9f, 0xba, 0xf8, 0xf2, 0x80, 0xe8, 0xdf, 0x03, 0x3d, 0x75, 0x40, 0x33, 0x02, 0xe5, 0xa2, 0x7d, 0xb2, 0xae,
};
static const u8 ecccdh_SECP256R1_21_test_vector_our_pub_key[] = {
	0x38, 0xb5, 0x4d, 0xb8, 0x55, 0x00, 0xcb, 0x20, 0xc6, 0x10, 0x56, 0xed, 0xd3, 0xd8, 0x8b, 0x6a, 0x9d, 0xc2, 0x67, 0x80, 0xa0, 0x47, 0xf2, 0x13, 0xa6, 0xe1, 0xb9, 0x00, 0xf7, 0x65, 0x96, 0xeb, 0x63, 0x87, 0xe4, 0xe5, 0x78, 0x15, 0x71, 0xe4, 0xeb, 0x8a, 0xe6, 0x29, 0x91, 0xa3, 0x3b, 0x5d, 0xc3, 0x33, 0x01, 0xc5, 0xbc, 0x7e, 0x12, 0x5d, 0x53, 0x79, 0x4a, 0x39, 0x16, 0x0d, 0x8f, 0xd0,
};
static const u8 ecccdh_SECP256R1_21_test_vector_shared_secret[] = {
	0x30, 0xc2, 0x26, 0x1b, 0xd0, 0x00, 0x4e, 0x61, 0xfe, 0xda, 0x2c, 0x16, 0xaa, 0x5e, 0x21, 0xff, 0xa8, 0xd7, 0xe7, 0xf7, 0xdb, 0xf6, 0xec, 0x37, 0x9a, 0x43, 0xb4, 0x8e, 0x4b, 0x36, 0xae, 0xb0,
};
static const ecdh_test_case ecccdh_SECP256R1_21_test_case = {
	.name = "ECCCDH/SECP256R1 21",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_21_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_21_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_21_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_21_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_21_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_21_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_21_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_21_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_22
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_22_test_vector_our_priv_key[] = {
	0x33, 0x4a, 0xe0, 0xc4, 0x69, 0x3d, 0x23, 0x93, 0x5a, 0x7e, 0x8e, 0x04, 0x3e, 0xbb, 0xde, 0x21, 0xe1, 0x68, 0xa7, 0xcb, 0xa3, 0xfa, 0x50, 0x7c, 0x9b, 0xe4, 0x1d, 0x76, 0x81, 0xe0, 0x49, 0xce,
};
static const u8 ecccdh_SECP256R1_22_test_vector_peer_pub_key[] = {
	0x45, 0xfb, 0x02, 0xb2, 0xce, 0xb9, 0xd7, 0xc7, 0x9d, 0x9c, 0x2f, 0xa9, 0x3e, 0x9c, 0x79, 0x67, 0xc2, 0xfa, 0x4d, 0xf5, 0x78, 0x9f, 0x96, 0x40, 0xb2, 0x42, 0x64, 0xb1, 0xe5, 0x24, 0xfc, 0xb1, 0x5c, 0x6e, 0x8e, 0xcf, 0x1f, 0x7d, 0x30, 0x23, 0x89, 0x3b, 0x7b, 0x1c, 0xa1, 0xe4, 0xd1, 0x78, 0x97, 0x2e, 0xe2, 0xa2, 0x30, 0x75, 0x7d, 0xdc, 0x56, 0x4f, 0xfe, 0x37, 0xf5, 0xc5, 0xa3, 0x21,
};
static const u8 ecccdh_SECP256R1_22_test_vector_our_pub_key[] = {
	0x3f, 0x2b, 0xf1, 0x58, 0x9a, 0xbf, 0x30, 0x47, 0xbf, 0x3e, 0x54, 0xac, 0x9a, 0x95, 0x37, 0x9b, 0xff, 0x95, 0xf8, 0xf5, 0x54, 0x05, 0xf6, 0x4e, 0xca, 0x36, 0xa7, 0xee, 0xbe, 0x8f, 0xfc, 0xa7, 0x52, 0x12, 0xa9, 0x4e, 0x66, 0xc5, 0xae, 0x9a, 0x89, 0x91, 0x87, 0x2f, 0x66, 0xa7, 0x27, 0x23, 0xd8, 0x0e, 0xc5, 0xb2, 0xe9, 0x25, 0x74, 0x5c, 0x45, 0x6f, 0x53, 0x71, 0x94, 0x3b, 0x3a, 0x06,
};
static const u8 ecccdh_SECP256R1_22_test_vector_shared_secret[] = {
	0x2a, 0xda, 0xe4, 0xa1, 0x38, 0xa2, 0x39, 0xdc, 0xd9, 0x3c, 0x24, 0x3a, 0x38, 0x03, 0xc3, 0xe4, 0xcf, 0x96, 0xe3, 0x7f, 0xe1, 0x4e, 0x6a, 0x9b, 0x71, 0x7b, 0xe9, 0x59, 0x99, 0x59, 0xb1, 0x1c,
};
static const ecdh_test_case ecccdh_SECP256R1_22_test_case = {
	.name = "ECCCDH/SECP256R1 22",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_22_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_22_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_22_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_22_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_22_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_22_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_22_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_22_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_23
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_23_test_vector_our_priv_key[] = {
	0x2c, 0x4b, 0xde, 0x40, 0x21, 0x4f, 0xcc, 0x3b, 0xfc, 0x47, 0xd4, 0xcf, 0x43, 0x4b, 0x62, 0x9a, 0xcb, 0xe9, 0x15, 0x7f, 0x8f, 0xd0, 0x28, 0x25, 0x40, 0x33, 0x1d, 0xe7, 0x94, 0x2c, 0xf0, 0x9d,
};
static const u8 ecccdh_SECP256R1_23_test_vector_peer_pub_key[] = {
	0xa1, 0x9e, 0xf7, 0xbf, 0xf9, 0x8a, 0xda, 0x78, 0x18, 0x42, 0xfb, 0xfc, 0x51, 0xa4, 0x7a, 0xff, 0x39, 0xb5, 0x93, 0x5a, 0x1c, 0x7d, 0x96, 0x25, 0xc8, 0xd3, 0x23, 0xd5, 0x11, 0xc9, 0x2d, 0xe6, 0xe9, 0xc1, 0x84, 0xdf, 0x75, 0xc9, 0x55, 0xe0, 0x2e, 0x02, 0xe4, 0x00, 0xff, 0xe4, 0x5f, 0x78, 0xf3, 0x39, 0xe1, 0xaf, 0xe6, 0xd0, 0x56, 0xfb, 0x32, 0x45, 0xf4, 0x70, 0x0c, 0xe6, 0x06, 0xef,
};
static const u8 ecccdh_SECP256R1_23_test_vector_our_pub_key[] = {
	0x29, 0xc0, 0x80, 0x7f, 0x10, 0xcb, 0xc4, 0x2f, 0xb4, 0x5c, 0x99, 0x89, 0xda, 0x50, 0x68, 0x1e, 0xea, 0xd7, 0x16, 0xda, 0xa7, 0xb9, 0xe9, 0x1f, 0xd3, 0x2e, 0x06, 0x2f, 0x5e, 0xb9, 0x2c, 0xa0, 0xff, 0x1d, 0x6d, 0x19, 0x55, 0xd7, 0x37, 0x6b, 0x2d, 0xa2, 0x4f, 0xe1, 0x16, 0x3a, 0x27, 0x16, 0x59, 0x13, 0x63, 0x41, 0xbc, 0x2e, 0xb1, 0x19, 0x5f, 0xc7, 0x06, 0xdc, 0x62, 0xe7, 0xf3, 0x4d,
};
static const u8 ecccdh_SECP256R1_23_test_vector_shared_secret[] = {
	0x2e, 0x27, 0x7e, 0xc3, 0x0f, 0x5e, 0xa0, 0x7d, 0x6c, 0xe5, 0x13, 0x14, 0x9b, 0x94, 0x79, 0xb9, 0x6e, 0x07, 0xf4, 0xb6, 0x91, 0x3b, 0x1b, 0x5c, 0x11, 0x30, 0x5c, 0x14, 0x44, 0xa1, 0xbc, 0x0b,
};
static const ecdh_test_case ecccdh_SECP256R1_23_test_case = {
	.name = "ECCCDH/SECP256R1 23",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_23_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_23_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_23_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_23_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_23_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_23_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_23_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_23_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP256R1
#define ECCCDH_SECP256R1_SELF_TEST_24
/*** Tests for ECCCDH/SECP256R1 ***/
static const u8 ecccdh_SECP256R1_24_test_vector_our_priv_key[] = {
	0x85, 0xa2, 0x68, 0xf9, 0xd7, 0x77, 0x2f, 0x99, 0x0c, 0x36, 0xb4, 0x2b, 0x0a, 0x33, 0x1a, 0xdc, 0x92, 0xb5, 0x94, 0x1d, 0xe0, 0xb8, 0x62, 0xd5, 0xd8, 0x9a, 0x34, 0x7c, 0xbf, 0x8f, 0xaa, 0xb0,
};
static const u8 ecccdh_SECP256R1_24_test_vector_peer_pub_key[] = {
	0x35, 0x6c, 0x5a, 0x44, 0x4c, 0x04, 0x9a, 0x52, 0xfe, 0xe0, 0xad, 0xeb, 0x7e, 0x5d, 0x82, 0xae, 0x5a, 0xa8, 0x30, 0x30, 0xbf, 0xff, 0x31, 0xbb, 0xf8, 0xce, 0x20, 0x96, 0xcf, 0x16, 0x1c, 0x4b, 0x57, 0xd1, 0x28, 0xde, 0x8b, 0x2a, 0x57, 0xa0, 0x94, 0xd1, 0xa0, 0x01, 0xe5, 0x72, 0x17, 0x3f, 0x96, 0xe8, 0x86, 0x6a, 0xe3, 0x52, 0xbf, 0x29, 0xcd, 0xda, 0xf9, 0x2f, 0xc8, 0x5b, 0x2f, 0x92,
};
static const u8 ecccdh_SECP256R1_24_test_vector_our_pub_key[] = {
	0x9c, 0xf4, 0xb9, 0x85, 0x81, 0xca, 0x17, 0x79, 0x45, 0x3c, 0xc8, 0x16, 0xff, 0x28, 0xb4, 0x10, 0x0a, 0xf5, 0x6c, 0xf1, 0xbf, 0x2e, 0x5b, 0xc3, 0x12, 0xd8, 0x3b, 0x6b, 0x1b, 0x21, 0xd3, 0x33, 0x7a, 0x55, 0x04, 0xfc, 0xac, 0x52, 0x31, 0xa0, 0xd1, 0x2d, 0x65, 0x82, 0x18, 0x28, 0x48, 0x68, 0x22, 0x9c, 0x84, 0x4a, 0x04, 0xa3, 0x45, 0x0d, 0x6c, 0x73, 0x81, 0xab, 0xe0, 0x80, 0xbf, 0x3b,
};
static const u8 ecccdh_SECP256R1_24_test_vector_shared_secret[] = {
	0x1e, 0x51, 0x37, 0x3b, 0xd2, 0xc6, 0x04, 0x4c, 0x12, 0x9c, 0x43, 0x6e, 0x74, 0x2a, 0x55, 0xbe, 0x2a, 0x66, 0x8a, 0x85, 0xae, 0x08, 0x44, 0x1b, 0x67, 0x56, 0x44, 0x5d, 0xf5, 0x49, 0x38, 0x57,
};
static const ecdh_test_case ecccdh_SECP256R1_24_test_case = {
	.name = "ECCCDH/SECP256R1 24",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp256r1_str_params,
	.our_priv_key = ecccdh_SECP256R1_24_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP256R1_24_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP256R1_24_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP256R1_24_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP256R1_24_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP256R1_24_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP256R1_24_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP256R1_24_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP256R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_0
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_0_test_vector_our_priv_key[] = {
	0x3c, 0xc3, 0x12, 0x2a, 0x68, 0xf0, 0xd9, 0x50, 0x27, 0xad, 0x38, 0xc0, 0x67, 0x91, 0x6b, 0xa0, 0xeb, 0x8c, 0x38, 0x89, 0x4d, 0x22, 0xe1, 0xb1, 0x56, 0x18, 0xb6, 0x81, 0x8a, 0x66, 0x17, 0x74, 0xad, 0x46, 0x3b, 0x20, 0x5d, 0xa8, 0x8c, 0xf6, 0x99, 0xab, 0x4d, 0x43, 0xc9, 0xcf, 0x98, 0xa1,
};
static const u8 ecccdh_SECP384R1_0_test_vector_peer_pub_key[] = {
	0xa7, 0xc7, 0x6b, 0x97, 0x0c, 0x3b, 0x5f, 0xe8, 0xb0, 0x5d, 0x28, 0x38, 0xae, 0x04, 0xab, 0x47, 0x69, 0x7b, 0x9e, 0xaf, 0x52, 0xe7, 0x64, 0x59, 0x2e, 0xfd, 0xa2, 0x7f, 0xe7, 0x51, 0x32, 0x72, 0x73, 0x44, 0x66, 0xb4, 0x00, 0x09, 0x1a, 0xdb, 0xf2, 0xd6, 0x8c, 0x58, 0xe0, 0xc5, 0x00, 0x66, 0xac, 0x68, 0xf1, 0x9f, 0x2e, 0x1c, 0xb8, 0x79, 0xae, 0xd4, 0x3a, 0x99, 0x69, 0xb9, 0x1a, 0x08, 0x39, 0xc4, 0xc3, 0x8a, 0x49, 0x74, 0x9b, 0x66, 0x1e, 0xfe, 0xdf, 0x24, 0x34, 0x51, 0x91, 0x5e, 0xd0, 0x90, 0x5a, 0x32, 0xb0, 0x60, 0x99, 0x2b, 0x46, 0x8c, 0x64, 0x76, 0x6f, 0xc8, 0x43, 0x7a,
};
static const u8 ecccdh_SECP384R1_0_test_vector_our_pub_key[] = {
	0x98, 0x03, 0x80, 0x7f, 0x2f, 0x6d, 0x2f, 0xd9, 0x66, 0xcd, 0xd0, 0x29, 0x0b, 0xd4, 0x10, 0xc0, 0x19, 0x03, 0x52, 0xfb, 0xec, 0x7f, 0xf6, 0x24, 0x7d, 0xe1, 0x30, 0x2d, 0xf8, 0x6f, 0x25, 0xd3, 0x4f, 0xe4, 0xa9, 0x7b, 0xef, 0x60, 0xcf, 0xf5, 0x48, 0x35, 0x5c, 0x01, 0x5d, 0xbb, 0x3e, 0x5f, 0xba, 0x26, 0xca, 0x69, 0xec, 0x2f, 0x5b, 0x5d, 0x9d, 0xad, 0x20, 0xcc, 0x9d, 0xa7, 0x11, 0x38, 0x3a, 0x9d, 0xbe, 0x34, 0xea, 0x3f, 0xa5, 0xa2, 0xaf, 0x75, 0xb4, 0x65, 0x02, 0x62, 0x9a, 0xd5, 0x4d, 0xd8, 0xb7, 0xd7, 0x3a, 0x8a, 0xbb, 0x06, 0xa3, 0xa3, 0xbe, 0x47, 0xd6, 0x50, 0xcc, 0x99,
};
static const u8 ecccdh_SECP384R1_0_test_vector_shared_secret[] = {
	0x5f, 0x9d, 0x29, 0xdc, 0x5e, 0x31, 0xa1, 0x63, 0x06, 0x03, 0x56, 0x21, 0x36, 0x69, 0xc8, 0xce, 0x13, 0x2e, 0x22, 0xf5, 0x7c, 0x9a, 0x04, 0xf4, 0x0b, 0xa7, 0xfc, 0xea, 0xd4, 0x93, 0xb4, 0x57, 0xe5, 0x62, 0x1e, 0x76, 0x6c, 0x40, 0xa2, 0xe3, 0xd4, 0xd6, 0xa0, 0x4b, 0x25, 0xe5, 0x33, 0xf1,
};
static const ecdh_test_case ecccdh_SECP384R1_0_test_case = {
	.name = "ECCCDH/SECP384R1 0",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_0_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_0_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_0_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_0_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_0_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_0_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_0_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_0_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_1
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_1_test_vector_our_priv_key[] = {
	0x92, 0x86, 0x0c, 0x21, 0xbd, 0xe0, 0x61, 0x65, 0xf8, 0xe9, 0x00, 0xc6, 0x87, 0xf8, 0xef, 0x0a, 0x05, 0xd1, 0x4f, 0x29, 0x0b, 0x3f, 0x07, 0xd8, 0xb3, 0xa8, 0xcc, 0x64, 0x04, 0x36, 0x6e, 0x5d, 0x51, 0x19, 0xcd, 0x6d, 0x03, 0xfb, 0x12, 0xdc, 0x58, 0xe8, 0x9f, 0x13, 0xdf, 0x9c, 0xd7, 0x83,
};
static const u8 ecccdh_SECP384R1_1_test_vector_peer_pub_key[] = {
	0x30, 0xf4, 0x3f, 0xcf, 0x2b, 0x6b, 0x00, 0xde, 0x53, 0xf6, 0x24, 0xf1, 0x54, 0x30, 0x90, 0x68, 0x18, 0x39, 0x71, 0x7d, 0x53, 0xc7, 0xc9, 0x55, 0xd1, 0xd6, 0x9e, 0xfa, 0xf0, 0x34, 0x9b, 0x73, 0x63, 0xac, 0xb4, 0x47, 0x24, 0x01, 0x01, 0xcb, 0xb3, 0xaf, 0x66, 0x41, 0xce, 0x4b, 0x88, 0xe0, 0x25, 0xe4, 0x6c, 0x0c, 0x54, 0xf0, 0x16, 0x2a, 0x77, 0xef, 0xcc, 0x27, 0xb6, 0xea, 0x79, 0x20, 0x02, 0xae, 0x2b, 0xa8, 0x27, 0x14, 0x29, 0x9c, 0x86, 0x08, 0x57, 0xa6, 0x81, 0x53, 0xab, 0x62, 0xe5, 0x25, 0xec, 0x05, 0x30, 0xd8, 0x1b, 0x5a, 0xa1, 0x58, 0x97, 0x98, 0x1e, 0x85, 0x87, 0x57,
};
static const u8 ecccdh_SECP384R1_1_test_vector_our_pub_key[] = {
	0xea, 0x40, 0x18, 0xf5, 0xa3, 0x07, 0xc3, 0x79, 0x18, 0x0b, 0xf6, 0xa6, 0x2f, 0xd2, 0xce, 0xce, 0xeb, 0xee, 0xb7, 0xd4, 0xdf, 0x06, 0x3a, 0x66, 0xfb, 0x83, 0x8a, 0xa3, 0x52, 0x43, 0x41, 0x97, 0x91, 0xf7, 0xe2, 0xc9, 0xd4, 0x80, 0x3c, 0x93, 0x19, 0xaa, 0x0e, 0xb0, 0x3c, 0x41, 0x6b, 0x66, 0x68, 0x83, 0x5a, 0x91, 0x48, 0x4f, 0x05, 0xef, 0x02, 0x82, 0x84, 0xdf, 0x64, 0x36, 0xfb, 0x88, 0xff, 0xeb, 0xab, 0xcd, 0xd6, 0x9a, 0xb0, 0x13, 0x3e, 0x67, 0x35, 0xa1, 0xbc, 0xfb, 0x37, 0x20, 0x3d, 0x10, 0xd3, 0x40, 0xa8, 0x32, 0x8a, 0x7b, 0x68, 0x77, 0x0c, 0xa7, 0x58, 0x78, 0xa1, 0xa6,
};
static const u8 ecccdh_SECP384R1_1_test_vector_shared_secret[] = {
	0xa2, 0x37, 0x42, 0xa2, 0xc2, 0x67, 0xd7, 0x42, 0x5f, 0xda, 0x94, 0xb9, 0x3f, 0x93, 0xbb, 0xcc, 0x24, 0x79, 0x1a, 0xc5, 0x1c, 0xd8, 0xfd, 0x50, 0x1a, 0x23, 0x8d, 0x40, 0x81, 0x2f, 0x4c, 0xbf, 0xc5, 0x9a, 0xac, 0x95, 0x20, 0xd7, 0x58, 0xcf, 0x78, 0x9c, 0x76, 0x30, 0x0c, 0x69, 0xd2, 0xff,
};
static const ecdh_test_case ecccdh_SECP384R1_1_test_case = {
	.name = "ECCCDH/SECP384R1 1",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_1_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_1_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_1_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_1_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_1_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_1_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_1_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_1_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_2
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_2_test_vector_our_priv_key[] = {
	0x12, 0xcf, 0x6a, 0x22, 0x3a, 0x72, 0x35, 0x25, 0x43, 0x83, 0x0f, 0x3f, 0x18, 0x53, 0x0d, 0x5c, 0xb3, 0x7f, 0x26, 0x88, 0x0a, 0x0b, 0x29, 0x44, 0x82, 0xc8, 0xa8, 0xef, 0x8a, 0xfa, 0xd0, 0x9a, 0xa7, 0x8b, 0x7d, 0xc2, 0xf2, 0x78, 0x9a, 0x78, 0xc6, 0x6a, 0xf5, 0xd1, 0xcc, 0x55, 0x38, 0x53,
};
static const u8 ecccdh_SECP384R1_2_test_vector_peer_pub_key[] = {
	0x1a, 0xef, 0xbf, 0xa2, 0xc6, 0xc8, 0xc8, 0x55, 0xa1, 0xa2, 0x16, 0x77, 0x45, 0x50, 0xb7, 0x9a, 0x24, 0xcd, 0xa3, 0x76, 0x07, 0xbb, 0x1f, 0x7c, 0xc9, 0x06, 0x65, 0x0e, 0xe4, 0xb3, 0x81, 0x6d, 0x68, 0xf6, 0xa9, 0xc7, 0x5d, 0xa6, 0xe4, 0x24, 0x2c, 0xeb, 0xfb, 0x66, 0x52, 0xf6, 0x51, 0x80, 0x41, 0x9d, 0x28, 0xb7, 0x23, 0xeb, 0xad, 0xb7, 0x65, 0x8f, 0xce, 0xbb, 0x9a, 0xd9, 0xb7, 0xad, 0xea, 0x67, 0x4f, 0x1d, 0xa3, 0xdc, 0x6b, 0x63, 0x97, 0xb5, 0x5d, 0xa0, 0xf6, 0x1a, 0x3e, 0xdd, 0xac, 0xb4, 0xac, 0xdb, 0x14, 0x44, 0x1c, 0xb2, 0x14, 0xb0, 0x4a, 0x08, 0x44, 0xc0, 0x2f, 0xa3,
};
static const u8 ecccdh_SECP384R1_2_test_vector_our_pub_key[] = {
	0xfc, 0xfc, 0xea, 0x08, 0x5e, 0x8c, 0xf7, 0x4d, 0x0d, 0xce, 0xd1, 0x62, 0x0b, 0xa8, 0x42, 0x36, 0x94, 0xf9, 0x03, 0xa2, 0x19, 0xbb, 0xf9, 0x01, 0xb0, 0xb5, 0x9d, 0x6a, 0xc8, 0x1b, 0xaa, 0xd3, 0x16, 0xa2, 0x42, 0xba, 0x32, 0xbd, 0xe8, 0x5c, 0xb2, 0x48, 0x11, 0x9b, 0x85, 0x2f, 0xab, 0x66, 0x97, 0x2e, 0x3c, 0x68, 0xc7, 0xab, 0x40, 0x2c, 0x58, 0x36, 0xf2, 0xa1, 0x6e, 0xd4, 0x51, 0xa3, 0x31, 0x20, 0xa7, 0x75, 0x0a, 0x60, 0x39, 0xf3, 0xff, 0x15, 0x38, 0x8e, 0xe6, 0x22, 0xb7, 0x06, 0x5f, 0x71, 0x22, 0xbf, 0x6d, 0x51, 0xae, 0xfb, 0xc2, 0x9b, 0x37, 0xb0, 0x34, 0x04, 0x58, 0x1b,
};
static const u8 ecccdh_SECP384R1_2_test_vector_shared_secret[] = {
	0x3d, 0x2e, 0x64, 0x0f, 0x35, 0x08, 0x05, 0xee, 0xd1, 0xff, 0x43, 0xb4, 0x0a, 0x72, 0xb2, 0xab, 0xed, 0x0a, 0x51, 0x8b, 0xce, 0xbe, 0x8f, 0x2d, 0x15, 0xb1, 0x11, 0xb6, 0x77, 0x32, 0x23, 0xda, 0x3c, 0x34, 0x89, 0x12, 0x1d, 0xb1, 0x73, 0xd4, 0x14, 0xb5, 0xbd, 0x5a, 0xd7, 0x15, 0x34, 0x35,
};
static const ecdh_test_case ecccdh_SECP384R1_2_test_case = {
	.name = "ECCCDH/SECP384R1 2",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_2_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_2_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_2_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_2_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_2_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_2_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_2_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_2_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_3
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_3_test_vector_our_priv_key[] = {
	0x8d, 0xd4, 0x80, 0x63, 0xa3, 0xa0, 0x58, 0xc3, 0x34, 0xb5, 0xcc, 0x7a, 0x4c, 0xe0, 0x7d, 0x02, 0xe5, 0xee, 0x6d, 0x8f, 0x1f, 0x3c, 0x51, 0xa1, 0x60, 0x09, 0x62, 0xcb, 0xab, 0x46, 0x26, 0x90, 0xae, 0x3c, 0xd9, 0x74, 0xfb, 0x39, 0xe4, 0x0b, 0x0e, 0x84, 0x3d, 0xaa, 0x0f, 0xd3, 0x2d, 0xe1,
};
static const u8 ecccdh_SECP384R1_3_test_vector_peer_pub_key[] = {
	0x8b, 0xc0, 0x89, 0x32, 0x6e, 0xc5, 0x5b, 0x9c, 0xf5, 0x9b, 0x34, 0xf0, 0xeb, 0x75, 0x4d, 0x93, 0x59, 0x6c, 0xa2, 0x90, 0xfc, 0xb3, 0x44, 0x4c, 0x83, 0xd4, 0xde, 0x3a, 0x56, 0x07, 0x03, 0x7e, 0xc3, 0x97, 0x68, 0x3f, 0x8c, 0xef, 0x07, 0xea, 0xb2, 0xfe, 0x35, 0x7e, 0xae, 0x36, 0xc4, 0x49, 0xd9, 0xd1, 0x6c, 0xe8, 0xac, 0x85, 0xb3, 0xf1, 0xe9, 0x45, 0x68, 0x52, 0x1a, 0xae, 0x53, 0x4e, 0x67, 0x13, 0x9e, 0x31, 0x0e, 0xc7, 0x26, 0x93, 0x52, 0x6a, 0xa2, 0xe9, 0x27, 0xb5, 0xb3, 0x22, 0xc9, 0x5a, 0x1a, 0x03, 0x3c, 0x22, 0x9c, 0xb6, 0x77, 0x0c, 0x95, 0x7c, 0xd3, 0x14, 0x8d, 0xd7,
};
static const u8 ecccdh_SECP384R1_3_test_vector_our_pub_key[] = {
	0xe3, 0x8c, 0x98, 0x46, 0x24, 0x81, 0x23, 0xc3, 0x42, 0x18, 0x61, 0xea, 0x4d, 0x32, 0x66, 0x9a, 0x7b, 0x5c, 0x3c, 0x08, 0x37, 0x6a, 0xd2, 0x81, 0x04, 0x39, 0x94, 0x94, 0xc8, 0x4f, 0xf5, 0xef, 0xa3, 0x89, 0x4a, 0xdb, 0x2c, 0x6c, 0xbe, 0x8c, 0x3c, 0x91, 0x3e, 0xf2, 0xee, 0xc5, 0xbd, 0x3c, 0x9f, 0xa8, 0x40, 0x24, 0xa1, 0x02, 0x87, 0x96, 0xdf, 0x84, 0x02, 0x1f, 0x7b, 0x6c, 0x9d, 0x02, 0xf0, 0xf4, 0xbd, 0x1a, 0x61, 0x2a, 0x03, 0xcb, 0xf7, 0x5a, 0x0b, 0xee, 0xa4, 0x3f, 0xef, 0x8a, 0xe8, 0x4b, 0x48, 0xc6, 0x01, 0x72, 0xaa, 0xdf, 0x09, 0xc1, 0xad, 0x01, 0x6d, 0x0b, 0xf3, 0xce,
};
static const u8 ecccdh_SECP384R1_3_test_vector_shared_secret[] = {
	0x6a, 0x42, 0xcf, 0xc3, 0x92, 0xab, 0xa0, 0xbf, 0xd3, 0xd1, 0x7b, 0x7c, 0xcf, 0x06, 0x2b, 0x91, 0xfc, 0x09, 0xbb, 0xf3, 0x41, 0x76, 0x12, 0xd0, 0x2a, 0x90, 0xbd, 0xde, 0x62, 0xae, 0x40, 0xc5, 0x4b, 0xb2, 0xe5, 0x6e, 0x16, 0x7d, 0x6b, 0x70, 0xdb, 0x67, 0x00, 0x97, 0xeb, 0x8d, 0xb8, 0x54,
};
static const ecdh_test_case ecccdh_SECP384R1_3_test_case = {
	.name = "ECCCDH/SECP384R1 3",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_3_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_3_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_3_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_3_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_3_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_3_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_3_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_3_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_4
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_4_test_vector_our_priv_key[] = {
	0x84, 0xec, 0xe6, 0xcc, 0x34, 0x29, 0x30, 0x9b, 0xd5, 0xb2, 0x3e, 0x95, 0x97, 0x93, 0xed, 0x2b, 0x11, 0x1e, 0xc5, 0xcb, 0x43, 0xb6, 0xc1, 0x80, 0x85, 0xfc, 0xae, 0xa9, 0xef, 0xa0, 0x68, 0x5d, 0x98, 0xa6, 0x26, 0x2e, 0xe0, 0xd3, 0x30, 0xee, 0x25, 0x0b, 0xc8, 0xa6, 0x7d, 0x0e, 0x73, 0x3f,
};
static const u8 ecccdh_SECP384R1_4_test_vector_peer_pub_key[] = {
	0xeb, 0x95, 0x2e, 0x2d, 0x9a, 0xc0, 0xc2, 0x0c, 0x6c, 0xc4, 0x8f, 0xb2, 0x25, 0xc2, 0xad, 0x15, 0x4f, 0x53, 0xc8, 0x75, 0x0b, 0x00, 0x3f, 0xd3, 0xb4, 0xed, 0x8e, 0xd1, 0xdc, 0x0d, 0xef, 0xac, 0x61, 0xbc, 0xdd, 0xe0, 0x2a, 0x2b, 0xcf, 0xee, 0x70, 0x67, 0xd7, 0x5d, 0x34, 0x2e, 0xd2, 0xb0, 0xf1, 0x82, 0x82, 0x05, 0xba, 0xec, 0xe8, 0x2d, 0x1b, 0x26, 0x7d, 0x0d, 0x7f, 0xf2, 0xf9, 0xc9, 0xe1, 0x5b, 0x69, 0xa7, 0x2d, 0xf4, 0x70, 0x58, 0xa9, 0x7f, 0x38, 0x91, 0x00, 0x5d, 0x1f, 0xb3, 0x88, 0x58, 0xf5, 0x60, 0x3d, 0xe8, 0x40, 0xe5, 0x91, 0xdf, 0xa4, 0xf6, 0xe7, 0xd4, 0x89, 0xe1,
};
static const u8 ecccdh_SECP384R1_4_test_vector_our_pub_key[] = {
	0x32, 0x22, 0x06, 0x3a, 0x29, 0x97, 0xb3, 0x02, 0xee, 0x60, 0xee, 0x19, 0x61, 0x10, 0x8f, 0xf4, 0xc7, 0xac, 0xf1, 0xc0, 0xef, 0x1d, 0x5f, 0xb0, 0xd1, 0x64, 0xb8, 0x4b, 0xce, 0x71, 0xc4, 0x31, 0x70, 0x5c, 0xb9, 0xae, 0xa9, 0xa4, 0x5f, 0x5d, 0x73, 0x80, 0x66, 0x55, 0xa0, 0x58, 0xbe, 0xe3, 0xe6, 0x1f, 0xa9, 0xe7, 0xfb, 0xe7, 0xcd, 0x43, 0xab, 0xf9, 0x95, 0x96, 0xa3, 0xd3, 0xa0, 0x39, 0xe9, 0x9f, 0xa9, 0xdc, 0x93, 0xb0, 0xbd, 0xd9, 0xca, 0xd8, 0x19, 0x66, 0xd1, 0x7e, 0xea, 0xf5, 0x57, 0x06, 0x8a, 0xfa, 0x7c, 0x78, 0x46, 0x6b, 0xb5, 0xb2, 0x20, 0x32, 0xd1, 0x10, 0x0f, 0xa6,
};
static const u8 ecccdh_SECP384R1_4_test_vector_shared_secret[] = {
	0xce, 0x7b, 0xa4, 0x54, 0xd4, 0x41, 0x27, 0x29, 0xa3, 0x2b, 0xb8, 0x33, 0xa2, 0xd1, 0xfd, 0x2a, 0xe6, 0x12, 0xd4, 0x66, 0x7c, 0x3a, 0x90, 0x0e, 0x06, 0x92, 0x14, 0x81, 0x86, 0x13, 0x44, 0x7d, 0xf8, 0xc6, 0x11, 0xde, 0x66, 0xda, 0x20, 0x0d, 0xb7, 0xc3, 0x75, 0xcf, 0x91, 0x3e, 0x44, 0x05,
};
static const ecdh_test_case ecccdh_SECP384R1_4_test_case = {
	.name = "ECCCDH/SECP384R1 4",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_4_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_4_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_4_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_4_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_4_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_4_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_4_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_4_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_5
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_5_test_vector_our_priv_key[] = {
	0x68, 0xfc, 0xe2, 0x12, 0x1d, 0xc3, 0xa1, 0xe3, 0x7b, 0x10, 0xf1, 0xdd, 0xe3, 0x09, 0xf9, 0xe2, 0xe1, 0x8f, 0xac, 0x47, 0xcd, 0x17, 0x70, 0x95, 0x14, 0x51, 0xc3, 0x48, 0x4c, 0xdb, 0x77, 0xcb, 0x13, 0x6d, 0x00, 0xe7, 0x31, 0x26, 0x05, 0x97, 0xcc, 0x28, 0x59, 0x60, 0x1c, 0x01, 0xa2, 0x5b,
};
static const u8 ecccdh_SECP384R1_5_test_vector_peer_pub_key[] = {
	0x44, 0x1d, 0x02, 0x9e, 0x24, 0x4e, 0xb7, 0x16, 0x8d, 0x64, 0x7d, 0x4d, 0xf5, 0x0d, 0xb5, 0xf4, 0xe4, 0x97, 0x4a, 0xb3, 0xfd, 0xaf, 0x02, 0x2a, 0xff, 0x05, 0x8b, 0x36, 0x95, 0xd0, 0xb8, 0xc8, 0x14, 0xcc, 0x88, 0xda, 0x62, 0x85, 0xdc, 0x6d, 0xf1, 0xac, 0x55, 0xc5, 0x53, 0x88, 0x50, 0x03, 0xe8, 0x02, 0x5a, 0xc2, 0x3a, 0x41, 0xd4, 0xb1, 0xea, 0x2a, 0xa4, 0x6c, 0x50, 0xc6, 0xe4, 0x79, 0x94, 0x6b, 0x59, 0xb6, 0xd7, 0x64, 0x97, 0xcd, 0x92, 0x49, 0x97, 0x7e, 0x0b, 0xfe, 0x4a, 0x62, 0x62, 0x62, 0x2f, 0x13, 0xd4, 0x2a, 0x3c, 0x43, 0xd6, 0x6b, 0xdb, 0xb3, 0x04, 0x03, 0xc3, 0x45,
};
static const u8 ecccdh_SECP384R1_5_test_vector_our_pub_key[] = {
	0x86, 0x8b, 0xe0, 0xe6, 0x94, 0x84, 0x18, 0x30, 0xe4, 0x24, 0xd9, 0x13, 0xd8, 0xe7, 0xd8, 0x6b, 0x84, 0xee, 0x10, 0x21, 0xd8, 0x2b, 0x0e, 0xcf, 0x52, 0x3f, 0x09, 0xfe, 0x89, 0xa7, 0x6c, 0x0c, 0x95, 0xc4, 0x9f, 0x2d, 0xfb, 0xcf, 0x82, 0x9c, 0x1e, 0x39, 0x70, 0x9d, 0x55, 0xef, 0xbb, 0x3b, 0x91, 0x95, 0xeb, 0x18, 0x36, 0x75, 0xb4, 0x0f, 0xd9, 0x2f, 0x51, 0xf3, 0x77, 0x13, 0x31, 0x7e, 0x4a, 0x9b, 0x4f, 0x71, 0x5c, 0x8a, 0xb2, 0x2e, 0x07, 0x73, 0xb1, 0xbc, 0x71, 0xd3, 0xa2, 0x19, 0xf0, 0x5b, 0x81, 0x16, 0x07, 0x46, 0x58, 0xee, 0x86, 0xb5, 0x2e, 0x36, 0xf3, 0x89, 0x71, 0x16,
};
static const u8 ecccdh_SECP384R1_5_test_vector_shared_secret[] = {
	0xba, 0x69, 0xf0, 0xac, 0xdf, 0x3e, 0x1c, 0xa9, 0x5c, 0xaa, 0xac, 0x4e, 0xca, 0xf4, 0x75, 0xbb, 0xe5, 0x1b, 0x54, 0x77, 0x7e, 0xfc, 0xe0, 0x1c, 0xa3, 0x81, 0xf4, 0x53, 0x70, 0xe4, 0x86, 0xfe, 0x87, 0xf9, 0xf4, 0x19, 0xb1, 0x50, 0xc6, 0x1e, 0x32, 0x9a, 0x28, 0x6d, 0x1a, 0xa2, 0x65, 0xec,
};
static const ecdh_test_case ecccdh_SECP384R1_5_test_case = {
	.name = "ECCCDH/SECP384R1 5",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_5_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_5_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_5_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_5_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_5_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_5_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_5_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_5_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_6
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_6_test_vector_our_priv_key[] = {
	0xb1, 0x76, 0x4c, 0x54, 0x89, 0x7e, 0x7a, 0xae, 0x6d, 0xe9, 0xe7, 0x75, 0x1f, 0x2f, 0x37, 0xde, 0x84, 0x92, 0x91, 0xf8, 0x8f, 0x0f, 0x91, 0x09, 0x31, 0x55, 0xb8, 0x58, 0xd1, 0xcc, 0x32, 0xa3, 0xa8, 0x79, 0x80, 0xf7, 0x06, 0xb8, 0x6c, 0xc8, 0x3f, 0x92, 0x7b, 0xdf, 0xdb, 0xea, 0xe0, 0xbd,
};
static const u8 ecccdh_SECP384R1_6_test_vector_peer_pub_key[] = {
	0x3d, 0x4e, 0x6b, 0xf0, 0x8a, 0x73, 0x40, 0x4a, 0xcc, 0xc1, 0x62, 0x98, 0x73, 0x46, 0x8e, 0x42, 0x69, 0xe8, 0x2d, 0x90, 0xd8, 0x32, 0xe5, 0x8a, 0xd7, 0x21, 0x42, 0x63, 0x9b, 0x5a, 0x05, 0x6a, 0xd8, 0xd3, 0x5c, 0x66, 0xc6, 0x0e, 0x81, 0x49, 0xfa, 0xc0, 0xc7, 0x97, 0xbc, 0xeb, 0x7c, 0x2f, 0x9b, 0x03, 0x08, 0xdc, 0x7f, 0x0e, 0x6d, 0x29, 0xf8, 0xc2, 0x77, 0xac, 0xbc, 0x65, 0xa2, 0x1e, 0x5a, 0xdb, 0x83, 0xd1, 0x1e, 0x68, 0x73, 0xbc, 0x0a, 0x07, 0xfd, 0xa0, 0x99, 0x7f, 0x48, 0x25, 0x04, 0x60, 0x2f, 0x59, 0xe1, 0x0b, 0xc5, 0xcb, 0x47, 0x6b, 0x83, 0xd0, 0xa4, 0xf7, 0x5e, 0x71,
};
static const u8 ecccdh_SECP384R1_6_test_vector_our_pub_key[] = {
	0xc3, 0x71, 0x22, 0x2f, 0xea, 0xa6, 0x77, 0x0c, 0x6f, 0x3e, 0xa3, 0xe0, 0xda, 0xc9, 0x74, 0x0d, 0xef, 0x4f, 0xcf, 0x82, 0x13, 0x78, 0xb7, 0xf9, 0x1f, 0xf9, 0x37, 0xc2, 0x1e, 0x04, 0x70, 0xf7, 0x0f, 0x3a, 0x31, 0xd5, 0xc6, 0xb2, 0x91, 0x21, 0x95, 0xf1, 0x09, 0x26, 0x94, 0x2b, 0x48, 0xae, 0x04, 0x7d, 0x6b, 0x4d, 0x76, 0x51, 0x23, 0x56, 0x3f, 0x81, 0x11, 0x6b, 0xc6, 0x65, 0xb7, 0xb8, 0xcc, 0x62, 0x07, 0x83, 0x0d, 0x80, 0x5f, 0xd8, 0x4d, 0xa7, 0xcb, 0x80, 0x5a, 0x65, 0xba, 0xa7, 0xc1, 0x2f, 0xd5, 0x92, 0xd1, 0xb5, 0xb5, 0xe3, 0xe6, 0x5d, 0x96, 0x72, 0xa9, 0xef, 0x76, 0x62,
};
static const u8 ecccdh_SECP384R1_6_test_vector_shared_secret[] = {
	0x1a, 0x66, 0x88, 0xee, 0x1d, 0x6e, 0x59, 0x86, 0x5d, 0x8e, 0x3a, 0xda, 0x37, 0x78, 0x1d, 0x36, 0xbb, 0x0c, 0x27, 0x17, 0xee, 0xf9, 0x2e, 0x61, 0x96, 0x4d, 0x39, 0x27, 0xcb, 0x76, 0x5c, 0x29, 0x65, 0xea, 0x80, 0xf7, 0xf6, 0x3e, 0x58, 0xc3, 0x22, 0xba, 0x03, 0x97, 0xfa, 0xea, 0xf6, 0x2b,
};
static const ecdh_test_case ecccdh_SECP384R1_6_test_case = {
	.name = "ECCCDH/SECP384R1 6",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_6_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_6_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_6_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_6_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_6_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_6_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_6_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_6_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_7
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_7_test_vector_our_priv_key[] = {
	0xf0, 0xf7, 0xa9, 0x6e, 0x70, 0xd9, 0x8f, 0xd5, 0xa3, 0x0a, 0xd6, 0x40, 0x6c, 0xf5, 0x6e, 0xb5, 0xb7, 0x2a, 0x51, 0x0e, 0x9f, 0x19, 0x2f, 0x50, 0xe1, 0xf8, 0x45, 0x24, 0xdb, 0xf3, 0xd2, 0x43, 0x9f, 0x72, 0x87, 0xbb, 0x36, 0xf5, 0xaa, 0x91, 0x2a, 0x79, 0xde, 0xaa, 0xb4, 0xad, 0xea, 0x82,
};
static const u8 ecccdh_SECP384R1_7_test_vector_peer_pub_key[] = {
	0xf5, 0xf6, 0xbe, 0xf1, 0xd1, 0x10, 0xda, 0x03, 0xbe, 0x00, 0x17, 0xea, 0xc7, 0x60, 0xcc, 0x34, 0xb2, 0x4d, 0x09, 0x2f, 0x73, 0x6f, 0x23, 0x7b, 0xc7, 0x05, 0x4b, 0x38, 0x65, 0x31, 0x2a, 0x81, 0x3b, 0xcb, 0x62, 0xd2, 0x97, 0xfb, 0x10, 0xa4, 0xf7, 0xab, 0xf5, 0x47, 0x08, 0xfe, 0x2d, 0x3d, 0x06, 0xfd, 0xf8, 0xd7, 0xdc, 0x03, 0x2f, 0x4e, 0x10, 0x01, 0x0b, 0xf1, 0x9c, 0xbf, 0x61, 0x59, 0x32, 0x12, 0x52, 0xff, 0x41, 0x5f, 0xb9, 0x19, 0x20, 0xd4, 0x38, 0xf2, 0x4e, 0x67, 0xe6, 0x0c, 0x2e, 0xb0, 0x46, 0x32, 0x04, 0x67, 0x9f, 0xa3, 0x56, 0xaf, 0x44, 0xce, 0xa9, 0xc9, 0xeb, 0xf5,
};
static const u8 ecccdh_SECP384R1_7_test_vector_our_pub_key[] = {
	0x99, 0xc8, 0xc4, 0x1c, 0xb1, 0xab, 0x5e, 0x08, 0x54, 0xa3, 0x46, 0xe4, 0xb0, 0x8a, 0x53, 0x7c, 0x17, 0x06, 0xa6, 0x15, 0x53, 0x38, 0x7c, 0x8d, 0x94, 0x94, 0x3a, 0xb1, 0x51, 0x96, 0xd4, 0x0d, 0xba, 0xa5, 0x5b, 0x82, 0x10, 0xa7, 0x7a, 0x5d, 0x00, 0x91, 0x5f, 0x2c, 0x4e, 0xa6, 0x9e, 0xab, 0x55, 0x31, 0x06, 0x5b, 0xdc, 0xf1, 0x7b, 0xfb, 0x3c, 0xb5, 0x5a, 0x02, 0xe4, 0x1a, 0x57, 0xc7, 0xf6, 0x94, 0xc3, 0x83, 0xad, 0x28, 0x9f, 0x90, 0x0f, 0xbd, 0x65, 0x6c, 0x22, 0x33, 0xa9, 0x3c, 0x92, 0xe9, 0x33, 0xe7, 0xa2, 0x6f, 0x54, 0xcb, 0xb5, 0x6f, 0x0a, 0xd8, 0x75, 0xc5, 0x1b, 0xb0,
};
static const u8 ecccdh_SECP384R1_7_test_vector_shared_secret[] = {
	0xd0, 0x6a, 0x56, 0x8b, 0xf2, 0x33, 0x6b, 0x90, 0xcb, 0xac, 0x32, 0x51, 0x61, 0xbe, 0x76, 0x95, 0xea, 0xcb, 0x22, 0x95, 0xf5, 0x99, 0x50, 0x0d, 0x78, 0x7f, 0x07, 0x26, 0x12, 0xac, 0xa3, 0x13, 0xee, 0x5d, 0x87, 0x4f, 0x80, 0x7d, 0xde, 0xf6, 0xc1, 0xf0, 0x23, 0xfe, 0x2b, 0x6e, 0x7c, 0xd0,
};
static const ecdh_test_case ecccdh_SECP384R1_7_test_case = {
	.name = "ECCCDH/SECP384R1 7",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_7_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_7_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_7_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_7_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_7_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_7_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_7_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_7_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_8
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_8_test_vector_our_priv_key[] = {
	0x9e, 0xfb, 0x87, 0xdd, 0xc6, 0x1d, 0x43, 0xc4, 0x82, 0xba, 0x66, 0xe1, 0xb1, 0x43, 0xae, 0xf6, 0x78, 0xfb, 0xd0, 0xd1, 0xbe, 0xbc, 0x20, 0x00, 0x94, 0x1f, 0xab, 0xe6, 0x77, 0xfe, 0x5b, 0x70, 0x6b, 0xf7, 0x8f, 0xce, 0x36, 0xd1, 0x00, 0xb1, 0x7c, 0xc7, 0x87, 0xea, 0xd7, 0x4b, 0xbc, 0xa2,
};
static const u8 ecccdh_SECP384R1_8_test_vector_peer_pub_key[] = {
	0x7c, 0xde, 0xc7, 0x7e, 0x07, 0x37, 0xea, 0x37, 0xc6, 0x7b, 0x89, 0xb7, 0x13, 0x7f, 0xe3, 0x88, 0x18, 0x01, 0x0f, 0x44, 0x64, 0x43, 0x8e, 0xe4, 0xd1, 0xd3, 0x5a, 0x0c, 0x48, 0x8c, 0xad, 0x3f, 0xde, 0x2f, 0x37, 0xd0, 0x08, 0x85, 0xd3, 0x6d, 0x3b, 0x79, 0x5b, 0x9f, 0x93, 0xd2, 0x3a, 0x67, 0x28, 0xc4, 0x2e, 0xe8, 0xd6, 0x02, 0x7c, 0x56, 0xcf, 0x97, 0x9b, 0xa4, 0xc2, 0x29, 0xfd, 0xb0, 0x1d, 0x23, 0x49, 0x44, 0xf8, 0xac, 0x43, 0x36, 0x50, 0x11, 0x2c, 0x3c, 0xf0, 0xf0, 0x28, 0x44, 0xe8, 0x88, 0xa3, 0x56, 0x9d, 0xfe, 0xf7, 0x82, 0x8a, 0x8a, 0x88, 0x45, 0x89, 0xaa, 0x05, 0x5e,
};
static const u8 ecccdh_SECP384R1_8_test_vector_our_pub_key[] = {
	0x4c, 0x34, 0xef, 0xee, 0x8f, 0x0c, 0x95, 0x56, 0x5d, 0x20, 0x65, 0xd1, 0xbb, 0xac, 0x2a, 0x2d, 0xd2, 0x5a, 0xe9, 0x64, 0x32, 0x0e, 0xb6, 0xbc, 0xce, 0xdc, 0x5f, 0x3a, 0x9b, 0x42, 0xa8, 0x81, 0xa1, 0xaf, 0xca, 0x1b, 0xb6, 0xb8, 0x80, 0x58, 0x4f, 0xa2, 0x7b, 0x01, 0xc1, 0x93, 0xcd, 0x92, 0xd8, 0xfb, 0x01, 0xdb, 0xf7, 0xcd, 0x0a, 0x38, 0x68, 0xc2, 0x6b, 0x95, 0x1f, 0x39, 0x3c, 0x3c, 0x56, 0xc2, 0x85, 0x8c, 0xee, 0x90, 0x1f, 0x77, 0x93, 0xff, 0x5d, 0x27, 0x19, 0x25, 0xd1, 0x3a, 0x41, 0xf8, 0xe5, 0x24, 0x09, 0xf4, 0xeb, 0xa1, 0x99, 0x0f, 0x33, 0xac, 0xb0, 0xba, 0xc6, 0x69,
};
static const u8 ecccdh_SECP384R1_8_test_vector_shared_secret[] = {
	0xbb, 0x3b, 0x1e, 0xda, 0x9c, 0x65, 0x60, 0xd8, 0x2f, 0xf5, 0xbe, 0xe4, 0x03, 0x33, 0x9f, 0x1e, 0x80, 0x34, 0x23, 0x38, 0xa9, 0x91, 0x34, 0x48, 0x53, 0xb5, 0x6b, 0x24, 0xf1, 0x09, 0xa4, 0xd9, 0x4b, 0x92, 0xf6, 0x54, 0xf0, 0x42, 0x5e, 0xdd, 0x4c, 0x20, 0x59, 0x03, 0xd7, 0x58, 0x61, 0x04,
};
static const ecdh_test_case ecccdh_SECP384R1_8_test_case = {
	.name = "ECCCDH/SECP384R1 8",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_8_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_8_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_8_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_8_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_8_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_8_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_8_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_8_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_9
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_9_test_vector_our_priv_key[] = {
	0xd7, 0x87, 0xa5, 0x7f, 0xde, 0x22, 0xec, 0x65, 0x6a, 0x0a, 0x52, 0x5c, 0xf3, 0xc7, 0x38, 0xb3, 0x0d, 0x73, 0xaf, 0x61, 0xe7, 0x43, 0xea, 0x90, 0x89, 0x3e, 0xcb, 0x2d, 0x7b, 0x62, 0x2a, 0xdd, 0x2f, 0x94, 0xee, 0x25, 0xc2, 0x17, 0x14, 0x67, 0xaf, 0xb0, 0x93, 0xf3, 0xf8, 0x4d, 0x00, 0x18,
};
static const u8 ecccdh_SECP384R1_9_test_vector_peer_pub_key[] = {
	0x8e, 0xee, 0xa3, 0xa3, 0x19, 0xc8, 0xdf, 0x99, 0xfb, 0xc2, 0x9c, 0xb5, 0x5f, 0x24, 0x3a, 0x72, 0x0d, 0x95, 0x50, 0x95, 0x15, 0xee, 0x5c, 0xc5, 0x87, 0xa5, 0xc5, 0xae, 0x22, 0xfb, 0xbd, 0x00, 0x9e, 0x62, 0x6d, 0xb3, 0xe9, 0x11, 0xde, 0xf0, 0xb9, 0x9a, 0x4f, 0x7a, 0xe3, 0x04, 0xb1, 0xba, 0x73, 0x87, 0x7d, 0xc9, 0x4d, 0xb9, 0xad, 0xdd, 0xc0, 0xd9, 0xa4, 0xb2, 0x4e, 0x89, 0x76, 0xc2, 0x2d, 0x73, 0xc8, 0x44, 0x37, 0x0e, 0x1e, 0xe8, 0x57, 0xf8, 0xd1, 0xb1, 0x29, 0xa3, 0xbd, 0x5f, 0x63, 0xf4, 0x0c, 0xaf, 0x3b, 0xd0, 0x53, 0x3e, 0x38, 0xa5, 0xf5, 0x77, 0x70, 0x74, 0xff, 0x9e,
};
static const u8 ecccdh_SECP384R1_9_test_vector_our_pub_key[] = {
	0x17, 0x15, 0x46, 0x92, 0x3b, 0x87, 0xb2, 0xcb, 0xba, 0xd6, 0x64, 0xf0, 0x1c, 0xe9, 0x32, 0xbf, 0x09, 0xd6, 0xa6, 0x11, 0x81, 0x68, 0x67, 0x84, 0x46, 0xbf, 0xa9, 0xf0, 0x93, 0x86, 0x08, 0xcb, 0x46, 0x67, 0xa9, 0x8f, 0x4e, 0xc8, 0xac, 0x14, 0x62, 0x28, 0x5c, 0x25, 0x08, 0xf7, 0x48, 0x62, 0xfa, 0x41, 0xcb, 0x4d, 0xb6, 0x8a, 0xe7, 0x1f, 0x1f, 0x8a, 0x3e, 0x89, 0x39, 0xdc, 0x52, 0xc2, 0xde, 0xc6, 0x1a, 0x83, 0xc9, 0x83, 0xbe, 0xb2, 0xa0, 0x2b, 0xaf, 0x29, 0xec, 0x49, 0x27, 0x80, 0x88, 0x88, 0x2e, 0xd0, 0xcf, 0x56, 0xc7, 0x4b, 0x5c, 0x17, 0x3b, 0x55, 0x2c, 0xcf, 0x63, 0xcf,
};
static const u8 ecccdh_SECP384R1_9_test_vector_shared_secret[] = {
	0x1e, 0x97, 0xb6, 0x0a, 0xdd, 0x7c, 0xb3, 0x5c, 0x74, 0x03, 0xdd, 0x88, 0x4c, 0x0a, 0x75, 0x79, 0x5b, 0x76, 0x83, 0xff, 0xf8, 0xb4, 0x9f, 0x9d, 0x86, 0x72, 0xa8, 0x20, 0x6b, 0xfd, 0xcf, 0x0a, 0x10, 0x6b, 0x87, 0x68, 0xf9, 0x83, 0x25, 0x8c, 0x74, 0x16, 0x74, 0x22, 0xe4, 0x4e, 0x4d, 0x14,
};
static const ecdh_test_case ecccdh_SECP384R1_9_test_case = {
	.name = "ECCCDH/SECP384R1 9",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_9_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_9_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_9_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_9_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_9_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_9_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_9_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_9_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_10
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_10_test_vector_our_priv_key[] = {
	0x83, 0xd7, 0x0f, 0x7b, 0x16, 0x4d, 0x9f, 0x4c, 0x22, 0x7c, 0x76, 0x70, 0x46, 0xb2, 0x0e, 0xb3, 0x4d, 0xfc, 0x77, 0x8f, 0x53, 0x87, 0xe3, 0x2e, 0x83, 0x4b, 0x1e, 0x6d, 0xae, 0xc2, 0x0e, 0xdb, 0x8c, 0xa5, 0xbb, 0x41, 0x92, 0x09, 0x3f, 0x54, 0x3b, 0x68, 0xe6, 0xae, 0xb7, 0xce, 0x78, 0x8b,
};
static const u8 ecccdh_SECP384R1_10_test_vector_peer_pub_key[] = {
	0xa7, 0x21, 0xf6, 0xa2, 0xd4, 0x52, 0x74, 0x11, 0x83, 0x4b, 0x13, 0xd4, 0xd3, 0xa3, 0x3c, 0x29, 0xbe, 0xb8, 0x3a, 0xb7, 0x68, 0x24, 0x65, 0xc6, 0xcb, 0xaf, 0x66, 0x24, 0xac, 0xa6, 0xea, 0x58, 0xc3, 0x0e, 0xb0, 0xf2, 0x9d, 0xd8, 0x42, 0x88, 0x66, 0x95, 0x40, 0x0d, 0x72, 0x54, 0xf2, 0x0f, 0x14, 0xba, 0x6e, 0x26, 0x35, 0x51, 0x09, 0xad, 0x35, 0x12, 0x93, 0x66, 0xd5, 0xe3, 0xa6, 0x40, 0xae, 0x79, 0x85, 0x05, 0xa7, 0xfa, 0x55, 0xa9, 0x6a, 0x36, 0xb5, 0xda, 0xd3, 0x3d, 0xe0, 0x04, 0x74, 0xf6, 0x67, 0x0f, 0x52, 0x22, 0x14, 0xdd, 0x79, 0x52, 0x14, 0x0a, 0xb0, 0xa7, 0xeb, 0x68,
};
static const u8 ecccdh_SECP384R1_10_test_vector_our_pub_key[] = {
	0x57, 0xcd, 0x77, 0x0f, 0x3b, 0xbc, 0xbe, 0x0c, 0x78, 0xc7, 0x70, 0xea, 0xb0, 0xb1, 0x69, 0xbc, 0x45, 0xe1, 0x39, 0xf8, 0x63, 0x78, 0xff, 0xae, 0x1c, 0x2b, 0x16, 0x96, 0x67, 0x27, 0xc2, 0xf2, 0xeb, 0x72, 0x45, 0x72, 0xb8, 0xf3, 0xeb, 0x22, 0x8d, 0x13, 0x0d, 0xb4, 0xff, 0x86, 0x2c, 0x63, 0x7e, 0xc5, 0xc8, 0x81, 0x3b, 0x68, 0x55, 0x58, 0xd8, 0x3e, 0x92, 0x4f, 0x14, 0xbc, 0x71, 0x9f, 0x6e, 0xb7, 0xae, 0x0c, 0xbb, 0x2c, 0x47, 0x42, 0x27, 0xc5, 0xbd, 0xa8, 0x86, 0x37, 0xa4, 0xf2, 0x6c, 0x64, 0x81, 0x79, 0x29, 0xaf, 0x99, 0x95, 0x92, 0xda, 0x6f, 0x78, 0x74, 0x90, 0x33, 0x2f,
};
static const u8 ecccdh_SECP384R1_10_test_vector_shared_secret[] = {
	0x10, 0x23, 0x47, 0x88, 0x40, 0xe5, 0x47, 0x75, 0xbf, 0xc6, 0x92, 0x93, 0xa3, 0xcf, 0x97, 0xf5, 0xbc, 0x91, 0x47, 0x26, 0x45, 0x5c, 0x66, 0x53, 0x8e, 0xb5, 0x62, 0x3e, 0x21, 0x8f, 0xee, 0xf7, 0xdf, 0x4b, 0xef, 0xa2, 0x3e, 0x09, 0xd7, 0x71, 0x45, 0xad, 0x57, 0x7d, 0xb3, 0x2b, 0x41, 0xf9,
};
static const ecdh_test_case ecccdh_SECP384R1_10_test_case = {
	.name = "ECCCDH/SECP384R1 10",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_10_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_10_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_10_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_10_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_10_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_10_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_10_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_10_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_11
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_11_test_vector_our_priv_key[] = {
	0x8f, 0x55, 0x8e, 0x05, 0x81, 0x8b, 0x88, 0xed, 0x38, 0x3d, 0x5f, 0xca, 0x96, 0x2e, 0x53, 0x41, 0x3d, 0xb1, 0xa0, 0xe4, 0x63, 0x7e, 0xda, 0x19, 0x4f, 0x76, 0x19, 0x44, 0xcb, 0xea, 0x11, 0x4a, 0xb9, 0xd5, 0xda, 0x17, 0x5a, 0x7d, 0x57, 0x88, 0x25, 0x50, 0xb0, 0xe4, 0x32, 0xf3, 0x95, 0xa9,
};
static const u8 ecccdh_SECP384R1_11_test_vector_peer_pub_key[] = {
	0xd8, 0x82, 0xa8, 0x50, 0x5c, 0x2d, 0x5c, 0xb9, 0xb8, 0x85, 0x1f, 0xc6, 0x76, 0x67, 0x7b, 0xb0, 0x08, 0x76, 0x81, 0xad, 0x53, 0xfa, 0xce, 0xba, 0x17, 0x38, 0x28, 0x6b, 0x45, 0x82, 0x75, 0x61, 0xe7, 0xda, 0x37, 0xb8, 0x80, 0x27, 0x6c, 0x65, 0x6c, 0xfc, 0x38, 0xb3, 0x2a, 0xde, 0x84, 0x7e, 0x34, 0xb3, 0x14, 0xbd, 0xc1, 0x34, 0x57, 0x56, 0x54, 0x57, 0x3c, 0xff, 0xaf, 0x40, 0x44, 0x5d, 0xa2, 0xe6, 0xaa, 0xf9, 0x87, 0xf7, 0xe9, 0x13, 0xcd, 0x4c, 0x30, 0x91, 0x52, 0x30, 0x58, 0x98, 0x4a, 0x25, 0xd8, 0xf2, 0x1d, 0xa8, 0x32, 0x61, 0x92, 0x45, 0x6c, 0x6a, 0x0f, 0xa5, 0xf6, 0x0c,
};
static const u8 ecccdh_SECP384R1_11_test_vector_our_pub_key[] = {
	0x9a, 0x2f, 0x57, 0xf4, 0x86, 0x7c, 0xe7, 0x53, 0xd7, 0x2b, 0x0d, 0x95, 0x19, 0x5d, 0xf6, 0xf9, 0x6c, 0x1f, 0xae, 0x93, 0x4f, 0x60, 0x2e, 0xfd, 0x7b, 0x6a, 0x54, 0x58, 0x2f, 0x55, 0x6c, 0xfa, 0x53, 0x9d, 0x89, 0x00, 0x5c, 0xa2, 0xed, 0xac, 0x08, 0xad, 0x9b, 0x72, 0xdd, 0x1f, 0x60, 0xba, 0xd9, 0xb9, 0x4e, 0xe8, 0x2d, 0xa9, 0xcc, 0x60, 0x1f, 0x34, 0x60, 0x44, 0x99, 0x8b, 0xa3, 0x87, 0xae, 0xe5, 0x64, 0x04, 0xdc, 0x6e, 0xcc, 0x8a, 0xb2, 0xb5, 0x90, 0x44, 0x33, 0x19, 0xd0, 0xb2, 0xb6, 0x17, 0x6f, 0x9d, 0x0e, 0xac, 0x2d, 0x44, 0x67, 0x8e, 0xd5, 0x61, 0x60, 0x7d, 0x09, 0xa9,
};
static const u8 ecccdh_SECP384R1_11_test_vector_shared_secret[] = {
	0x6a, 0xd6, 0xb9, 0xdc, 0x8a, 0x6c, 0xf0, 0xd3, 0x69, 0x1c, 0x50, 0x1c, 0xbb, 0x96, 0x78, 0x67, 0xf6, 0xe4, 0xbb, 0xb7, 0x64, 0xb6, 0x0d, 0xbf, 0xf8, 0xfc, 0xff, 0x3e, 0xd4, 0x2d, 0xbb, 0xa3, 0x9d, 0x63, 0xcf, 0x32, 0x5b, 0x4b, 0x40, 0x78, 0x85, 0x84, 0x95, 0xdd, 0xee, 0x75, 0xf9, 0x54,
};
static const ecdh_test_case ecccdh_SECP384R1_11_test_case = {
	.name = "ECCCDH/SECP384R1 11",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_11_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_11_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_11_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_11_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_11_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_11_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_11_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_11_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_12
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_12_test_vector_our_priv_key[] = {
	0x0f, 0x5d, 0xee, 0x0a, 0xff, 0xa7, 0xbb, 0xf2, 0x39, 0xd5, 0xdf, 0xf3, 0x29, 0x87, 0xeb, 0xb7, 0xcf, 0x84, 0xfc, 0xce, 0xed, 0x64, 0x3e, 0x1d, 0x3c, 0x62, 0xd0, 0xb3, 0x35, 0x2a, 0xec, 0x23, 0xb6, 0xe5, 0xac, 0x7f, 0xa4, 0x10, 0x5c, 0x8c, 0xb2, 0x61, 0x26, 0xad, 0x2d, 0x18, 0x92, 0xcb,
};
static const u8 ecccdh_SECP384R1_12_test_vector_peer_pub_key[] = {
	0x81, 0x5c, 0x9d, 0x77, 0x3d, 0xbf, 0x5f, 0xb6, 0xa1, 0xb8, 0x67, 0x99, 0x96, 0x62, 0x47, 0xf4, 0x00, 0x6a, 0x23, 0xc9, 0x2e, 0x68, 0xc5, 0x5e, 0x9e, 0xaa, 0x99, 0x8b, 0x17, 0xd8, 0x83, 0x2d, 0xd4, 0xd8, 0x4d, 0x92, 0x7d, 0x83, 0x1d, 0x4f, 0x68, 0xda, 0xc6, 0x7c, 0x64, 0x88, 0x21, 0x9f, 0xe7, 0x92, 0x69, 0x94, 0x8b, 0x26, 0x11, 0x48, 0x45, 0x60, 0xfd, 0x49, 0x0f, 0xee, 0xc8, 0x87, 0xcb, 0x55, 0xef, 0x99, 0xa4, 0xb5, 0x24, 0x88, 0x0f, 0xa7, 0x49, 0x9d, 0x6a, 0x07, 0x28, 0x3a, 0xae, 0x2a, 0xfa, 0x33, 0xfe, 0xab, 0x97, 0xde, 0xca, 0x40, 0xbc, 0x60, 0x6c, 0x4d, 0x87, 0x64,
};
static const u8 ecccdh_SECP384R1_12_test_vector_our_pub_key[] = {
	0x23, 0x34, 0x6b, 0xdf, 0xbc, 0x9d, 0x7c, 0x7c, 0x73, 0x6e, 0x02, 0xbd, 0xf6, 0x07, 0x67, 0x1f, 0xf6, 0x08, 0x2f, 0xdd, 0x27, 0x33, 0x4a, 0x8b, 0xc7, 0x5f, 0x3b, 0x23, 0x68, 0x1e, 0xbe, 0x61, 0x4d, 0x05, 0x97, 0xdd, 0x61, 0x4f, 0xae, 0x58, 0x67, 0x7c, 0x83, 0x5a, 0x9f, 0x0b, 0x27, 0x3b, 0x82, 0xba, 0x36, 0x29, 0x0d, 0x2f, 0x94, 0xdb, 0x41, 0x47, 0x9e, 0xb4, 0x5a, 0xb4, 0xea, 0xf6, 0x79, 0x28, 0xa2, 0x31, 0x51, 0x38, 0xd5, 0x9e, 0xec, 0xc9, 0xb5, 0x28, 0x5d, 0xfd, 0xdd, 0x67, 0x14, 0xf7, 0x75, 0x57, 0x21, 0x6e, 0xa4, 0x4c, 0xc6, 0xfc, 0x11, 0x9d, 0x82, 0x43, 0xef, 0xaf,
};
static const u8 ecccdh_SECP384R1_12_test_vector_shared_secret[] = {
	0xcc, 0x9e, 0x06, 0x35, 0x66, 0xd4, 0x6b, 0x35, 0x7b, 0x3f, 0xca, 0xe2, 0x18, 0x27, 0x37, 0x73, 0x31, 0xe5, 0xe2, 0x90, 0xa3, 0x6e, 0x60, 0xcd, 0x7c, 0x39, 0x10, 0x2b, 0x82, 0x8a, 0xe0, 0xb9, 0x18, 0xdc, 0x5a, 0x02, 0x21, 0x6b, 0x07, 0xfe, 0x6f, 0x19, 0x58, 0xd8, 0x34, 0xe4, 0x24, 0x37,
};
static const ecdh_test_case ecccdh_SECP384R1_12_test_case = {
	.name = "ECCCDH/SECP384R1 12",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_12_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_12_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_12_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_12_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_12_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_12_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_12_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_12_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_13
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_13_test_vector_our_priv_key[] = {
	0x03, 0x7b, 0x63, 0x3b, 0x5b, 0x8b, 0xa8, 0x57, 0xc0, 0xfc, 0x85, 0x65, 0x68, 0x68, 0x23, 0x2e, 0x2f, 0xeb, 0xf5, 0x95, 0x78, 0x71, 0x83, 0x91, 0xb8, 0x1d, 0xa8, 0x54, 0x1a, 0x00, 0xbf, 0xe5, 0x3c, 0x30, 0xae, 0x04, 0x15, 0x18, 0x47, 0xf2, 0x74, 0x99, 0xf8, 0xd7, 0xab, 0xad, 0x8c, 0xf4,
};
static const u8 ecccdh_SECP384R1_13_test_vector_peer_pub_key[] = {
	0x1c, 0x0e, 0xed, 0xa7, 0xa2, 0xbe, 0x00, 0x0c, 0x5b, 0xdc, 0xda, 0x04, 0x78, 0xae, 0xd4, 0xdb, 0x73, 0x3d, 0x2a, 0x9e, 0x34, 0x12, 0x24, 0x37, 0x91, 0x23, 0xad, 0x84, 0x70, 0x30, 0xf2, 0x9e, 0x3b, 0x16, 0x8f, 0xa1, 0x8e, 0x89, 0xa3, 0xc0, 0xfb, 0xa2, 0xa6, 0xce, 0x1c, 0x28, 0xfc, 0x3b, 0xec, 0x8c, 0x1c, 0x83, 0xc1, 0x18, 0xc4, 0xdb, 0xea, 0x94, 0x27, 0x18, 0x69, 0xf2, 0xd8, 0x68, 0xeb, 0x65, 0xe8, 0xb4, 0x4e, 0x21, 0xe6, 0xf1, 0x4b, 0x0f, 0x4d, 0x9b, 0x38, 0xc0, 0x68, 0xda, 0xef, 0xa2, 0x71, 0x14, 0x25, 0x5b, 0x9a, 0x41, 0xd0, 0x84, 0xcc, 0x4a, 0x1a, 0xd8, 0x54, 0x56,
};
static const u8 ecccdh_SECP384R1_13_test_vector_our_pub_key[] = {
	0x88, 0x78, 0xac, 0x8a, 0x94, 0x7f, 0x7d, 0x5c, 0xb2, 0xb4, 0x7a, 0xad, 0x24, 0xfb, 0xb8, 0x21, 0x0d, 0x86, 0x12, 0x65, 0x85, 0x39, 0x9a, 0x28, 0x71, 0xf8, 0x4a, 0xa9, 0xc5, 0xfd, 0xe3, 0x07, 0x4a, 0xe5, 0x40, 0xc6, 0xbf, 0x82, 0x27, 0x5c, 0xa8, 0x22, 0xd0, 0xfe, 0xb8, 0x62, 0xbc, 0x74, 0x63, 0x2f, 0x5c, 0xd2, 0xf9, 0x00, 0xc2, 0x71, 0x1c, 0x32, 0xf8, 0x93, 0x07, 0x28, 0xeb, 0x64, 0x7d, 0x31, 0xed, 0xd8, 0xd6, 0x50, 0xf9, 0x65, 0x4e, 0x7d, 0x33, 0xe5, 0xed, 0x1b, 0x47, 0x54, 0x89, 0xd0, 0x8d, 0xaa, 0x30, 0xd8, 0xcb, 0xcb, 0xa6, 0xbf, 0xc3, 0xb6, 0x0d, 0x9b, 0x5a, 0x37,
};
static const u8 ecccdh_SECP384R1_13_test_vector_shared_secret[] = {
	0xde, 0xff, 0x7f, 0x03, 0xbd, 0x09, 0x86, 0x5b, 0xaf, 0x94, 0x5e, 0x73, 0xed, 0xff, 0x6d, 0x51, 0x22, 0xc0, 0x3f, 0xb5, 0x61, 0xdb, 0x87, 0xde, 0xc8, 0x66, 0x2e, 0x09, 0xbe, 0xd4, 0x34, 0x0b, 0x28, 0xa9, 0xef, 0xe1, 0x18, 0x33, 0x7b, 0xb7, 0xd3, 0xd4, 0xf7, 0xf5, 0x68, 0x63, 0x5f, 0xf9,
};
static const ecdh_test_case ecccdh_SECP384R1_13_test_case = {
	.name = "ECCCDH/SECP384R1 13",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_13_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_13_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_13_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_13_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_13_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_13_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_13_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_13_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_14
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_14_test_vector_our_priv_key[] = {
	0xe3, 0xd0, 0x71, 0x06, 0xbe, 0xdc, 0xc0, 0x96, 0xe7, 0xd9, 0x16, 0x30, 0xff, 0xd3, 0x09, 0x4d, 0xf2, 0xc7, 0x85, 0x9d, 0xb8, 0xd7, 0xed, 0xbb, 0x2e, 0x37, 0xb4, 0xac, 0x47, 0xf4, 0x29, 0xa6, 0x37, 0xd0, 0x6a, 0x67, 0xd2, 0xfb, 0xa3, 0x38, 0x38, 0x76, 0x4e, 0xf2, 0x03, 0x46, 0x49, 0x91,
};
static const u8 ecccdh_SECP384R1_14_test_vector_peer_pub_key[] = {
	0xc9, 0x5c, 0x18, 0x5e, 0x25, 0x6b, 0xf9, 0x97, 0xf3, 0x0b, 0x31, 0x15, 0x48, 0xae, 0x7f, 0x76, 0x8a, 0x38, 0xde, 0xe4, 0x3e, 0xee, 0xef, 0x43, 0x08, 0x3f, 0x30, 0x77, 0xbe, 0x70, 0xe2, 0xbf, 0x39, 0xac, 0x1d, 0x4d, 0xaf, 0x36, 0x0c, 0x51, 0x4c, 0x8c, 0x6b, 0xe6, 0x23, 0x44, 0x3d, 0x1a, 0x3e, 0x63, 0xa6, 0x63, 0xea, 0xf7, 0x5d, 0x8a, 0x76, 0x5a, 0xb2, 0xb9, 0xa3, 0x55, 0x13, 0xd7, 0x93, 0x3f, 0xa5, 0xe2, 0x64, 0x20, 0xa5, 0x24, 0x45, 0x50, 0xec, 0x6c, 0x3b, 0x6f, 0x03, 0x3b, 0x96, 0xdb, 0x2a, 0xca, 0x3d, 0x6a, 0xc6, 0xaa, 0xb0, 0x52, 0xce, 0x92, 0x95, 0x95, 0xae, 0xa5,
};
static const u8 ecccdh_SECP384R1_14_test_vector_our_pub_key[] = {
	0xe7, 0x4a, 0x1a, 0x2b, 0x85, 0xf1, 0xcb, 0xf8, 0xdb, 0xbd, 0xf0, 0x50, 0xcf, 0x1a, 0xff, 0x8a, 0xcb, 0x02, 0xfd, 0xa2, 0xfb, 0x65, 0x91, 0xf9, 0xd3, 0xcf, 0xe4, 0xe7, 0x9d, 0x0a, 0xe9, 0x38, 0xa9, 0xc1, 0x48, 0x3e, 0x7b, 0x75, 0xf8, 0xdb, 0x24, 0x50, 0x5d, 0x65, 0x06, 0x5c, 0xdb, 0x18, 0x17, 0x73, 0xee, 0x59, 0x18, 0x22, 0xf7, 0xab, 0xaa, 0x85, 0x6a, 0x1a, 0x60, 0xbc, 0x0a, 0x52, 0x03, 0x54, 0x8d, 0xbd, 0x1c, 0xb5, 0x02, 0x54, 0x66, 0xef, 0xf8, 0x48, 0x1b, 0xd0, 0x76, 0x14, 0xea, 0xa0, 0x4a, 0x16, 0xc3, 0xdb, 0x76, 0x90, 0x59, 0x13, 0xe9, 0x72, 0xa5, 0xb6, 0xb5, 0x9d,
};
static const u8 ecccdh_SECP384R1_14_test_vector_shared_secret[] = {
	0xc8, 0xb1, 0x03, 0x8f, 0x73, 0x5a, 0xd3, 0xbb, 0x3e, 0x46, 0x37, 0xc3, 0xe4, 0x7e, 0xab, 0x48, 0x76, 0x37, 0x91, 0x1a, 0x6b, 0x79, 0x50, 0xa4, 0xe4, 0x61, 0x94, 0x83, 0x29, 0xd3, 0x92, 0x3b, 0x96, 0x9e, 0x5d, 0xb6, 0x63, 0x67, 0x56, 0x23, 0x61, 0x1a, 0x45, 0x7f, 0xcd, 0xa3, 0x5a, 0x71,
};
static const ecdh_test_case ecccdh_SECP384R1_14_test_case = {
	.name = "ECCCDH/SECP384R1 14",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_14_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_14_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_14_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_14_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_14_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_14_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_14_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_14_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_15
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_15_test_vector_our_priv_key[] = {
	0xf3, 0xf9, 0xb0, 0xc6, 0x5a, 0x49, 0xa5, 0x06, 0x63, 0x2c, 0x8a, 0x45, 0xb1, 0x0f, 0x66, 0xb5, 0x31, 0x6f, 0x9e, 0xeb, 0x06, 0xfa, 0xe2, 0x18, 0xf2, 0xda, 0x62, 0x33, 0x3f, 0x99, 0x90, 0x51, 0x17, 0xb1, 0x41, 0xc7, 0x60, 0xe8, 0x97, 0x4e, 0xfc, 0x4a, 0xf1, 0x05, 0x70, 0x63, 0x57, 0x91,
};
static const u8 ecccdh_SECP384R1_15_test_vector_peer_pub_key[] = {
	0x34, 0x97, 0x23, 0x8a, 0x7e, 0x6a, 0xd1, 0x66, 0xdf, 0x2d, 0xac, 0x03, 0x9a, 0xa4, 0xda, 0xc8, 0xd1, 0x7a, 0xa9, 0x25, 0xe7, 0xc7, 0x63, 0x1e, 0xb3, 0xb5, 0x6e, 0x3a, 0xaa, 0x1c, 0x54, 0x5f, 0xcd, 0x54, 0xd2, 0xe5, 0x98, 0x58, 0x07, 0x91, 0x0f, 0xb2, 0x02, 0xb1, 0xfc, 0x19, 0x1d, 0x2a, 0xa4, 0x9e, 0x5c, 0x48, 0x7d, 0xcc, 0x7a, 0xa4, 0x0a, 0x8f, 0x23, 0x4c, 0x97, 0x94, 0x46, 0x04, 0x0d, 0x91, 0x74, 0xe3, 0xad, 0x35, 0x7d, 0x40, 0x4d, 0x77, 0x65, 0x18, 0x31, 0x95, 0xae, 0xd3, 0xf9, 0x13, 0x64, 0x1b, 0x90, 0xc8, 0x1a, 0x30, 0x6e, 0xbf, 0x0d, 0x89, 0x13, 0x86, 0x13, 0x16,
};
static const u8 ecccdh_SECP384R1_15_test_vector_our_pub_key[] = {
	0xa4, 0xad, 0x77, 0xaa, 0x7d, 0x86, 0xe5, 0x36, 0x11, 0x18, 0xa6, 0xb9, 0x21, 0x71, 0x0c, 0x82, 0x07, 0x21, 0x21, 0x07, 0x12, 0xf4, 0xc3, 0x47, 0x98, 0x5f, 0xde, 0xe5, 0x8a, 0xa4, 0xef, 0xfa, 0x1e, 0x28, 0xbe, 0x80, 0xa1, 0x7b, 0x12, 0x0b, 0x13, 0x9f, 0x96, 0x30, 0x0f, 0x89, 0xb4, 0x9b, 0x1d, 0xdf, 0x22, 0xe0, 0x7e, 0x03, 0xf1, 0x56, 0x0d, 0x8f, 0x45, 0xa4, 0x80, 0x09, 0x45, 0x60, 0xdb, 0xa9, 0xfa, 0xe7, 0xf9, 0x53, 0x11, 0x30, 0xc1, 0xb5, 0x7e, 0xbb, 0x95, 0x98, 0x24, 0x96, 0x52, 0x4f, 0x31, 0xd3, 0x79, 0x77, 0x93, 0x39, 0x6f, 0xa8, 0x23, 0xf2, 0x2b, 0xdb, 0x43, 0x28,
};
static const u8 ecccdh_SECP384R1_15_test_vector_shared_secret[] = {
	0xd3, 0x37, 0xea, 0xa3, 0x2b, 0x9f, 0x71, 0x6b, 0x87, 0x47, 0xb0, 0x05, 0xb9, 0x7a, 0x55, 0x3c, 0x59, 0xda, 0xb0, 0xc5, 0x1d, 0xf4, 0x1a, 0x2d, 0x49, 0x03, 0x9c, 0xda, 0xe7, 0x05, 0xaa, 0x75, 0xc7, 0xb9, 0xe7, 0xbc, 0x0b, 0x6a, 0x0e, 0x8c, 0x57, 0x8c, 0x90, 0x2b, 0xc4, 0xff, 0xf2, 0x3e,
};
static const ecdh_test_case ecccdh_SECP384R1_15_test_case = {
	.name = "ECCCDH/SECP384R1 15",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_15_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_15_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_15_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_15_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_15_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_15_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_15_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_15_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_16
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_16_test_vector_our_priv_key[] = {
	0x59, 0xfc, 0xe7, 0xfa, 0xd7, 0xde, 0x28, 0xba, 0xc0, 0x23, 0x06, 0x90, 0xc9, 0x57, 0x10, 0xc7, 0x20, 0xe5, 0x28, 0xf9, 0xa4, 0xe5, 0x4d, 0x3a, 0x6a, 0x8c, 0xd5, 0xfc, 0x5c, 0x5f, 0x21, 0x63, 0x70, 0x31, 0xce, 0x1c, 0x5b, 0x4e, 0x3d, 0x39, 0x64, 0x7d, 0x8d, 0xcb, 0x9b, 0x79, 0x46, 0x64,
};
static const u8 ecccdh_SECP384R1_16_test_vector_peer_pub_key[] = {
	0x90, 0xa3, 0x47, 0x37, 0xd4, 0x5b, 0x1a, 0xa6, 0x5f, 0x74, 0xe0, 0xbd, 0x06, 0x59, 0xbc, 0x11, 0x8f, 0x8e, 0x4b, 0x77, 0x4b, 0x76, 0x19, 0x44, 0xff, 0xa6, 0x57, 0x3c, 0x6d, 0xf4, 0xf4, 0x1d, 0xec, 0x0d, 0x11, 0xb6, 0x97, 0xab, 0xd9, 0x34, 0xd3, 0x90, 0x87, 0x1d, 0x4b, 0x45, 0x32, 0x40, 0x9b, 0x59, 0x07, 0x19, 0xbb, 0x33, 0x07, 0xc1, 0x49, 0xa7, 0x81, 0x7b, 0xe3, 0x55, 0xd6, 0x84, 0x89, 0x3a, 0x30, 0x77, 0x64, 0xb5, 0x12, 0xee, 0xff, 0xe0, 0x7c, 0xb6, 0x99, 0xed, 0xb5, 0xa6, 0xff, 0xbf, 0x8d, 0x60, 0x32, 0xe6, 0xc7, 0x9d, 0x5e, 0x93, 0xe9, 0x42, 0x12, 0xc2, 0xaa, 0x4e,
};
static const u8 ecccdh_SECP384R1_16_test_vector_our_pub_key[] = {
	0x9c, 0x43, 0xbf, 0x97, 0x1e, 0xdf, 0x09, 0x40, 0x28, 0x76, 0xee, 0x74, 0x20, 0x95, 0x38, 0x1f, 0x78, 0xb1, 0xbd, 0x3a, 0xa3, 0x9b, 0x51, 0x32, 0xaf, 0x75, 0xdb, 0xfe, 0x7e, 0x98, 0xbd, 0x78, 0xbd, 0xe1, 0x0f, 0xe2, 0xe9, 0x03, 0xc2, 0xb6, 0x37, 0x9e, 0x1d, 0xee, 0xe1, 0x75, 0xa1, 0xb0, 0xa6, 0xc5, 0x8e, 0xce, 0xa5, 0xa4, 0x77, 0xbb, 0x01, 0xbd, 0x54, 0x3b, 0x33, 0x9f, 0x1c, 0xc4, 0x9f, 0x13, 0x71, 0xa2, 0xcd, 0xa4, 0xd4, 0x6e, 0xb4, 0xe5, 0x3e, 0x25, 0x05, 0x97, 0x94, 0x23, 0x51, 0xa9, 0x96, 0x65, 0xa1, 0x22, 0xff, 0xea, 0x9b, 0xde, 0x06, 0x36, 0xc3, 0x75, 0xda, 0xf2,
};
static const u8 ecccdh_SECP384R1_16_test_vector_shared_secret[] = {
	0x32, 0xd2, 0x92, 0xb6, 0x95, 0xa4, 0x48, 0x8e, 0x42, 0xa7, 0xb7, 0x92, 0x2e, 0x1a, 0xe5, 0x37, 0xd7, 0x6a, 0x3d, 0x21, 0xa0, 0xb2, 0xe3, 0x68, 0x75, 0xf6, 0x0e, 0x9f, 0x6d, 0x3e, 0x87, 0x79, 0xc2, 0xaf, 0xb3, 0xa4, 0x13, 0xb9, 0xdd, 0x79, 0xae, 0x18, 0xe7, 0x0b, 0x47, 0xd3, 0x37, 0xc1,
};
static const ecdh_test_case ecccdh_SECP384R1_16_test_case = {
	.name = "ECCCDH/SECP384R1 16",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_16_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_16_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_16_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_16_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_16_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_16_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_16_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_16_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_17
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_17_test_vector_our_priv_key[] = {
	0x3e, 0x49, 0xfb, 0xf9, 0x50, 0xa4, 0x24, 0xc5, 0xd8, 0x02, 0x28, 0xdc, 0x4b, 0xc3, 0x5e, 0x9f, 0x6c, 0x6c, 0x0c, 0x1d, 0x04, 0x44, 0x09, 0x98, 0xda, 0x0a, 0x60, 0x9a, 0x87, 0x75, 0x75, 0xdb, 0xe4, 0x37, 0xd6, 0xa5, 0xce, 0xda, 0xa2, 0xdd, 0xd2, 0xa1, 0xa1, 0x7f, 0xd1, 0x12, 0xad, 0xed,
};
static const u8 ecccdh_SECP384R1_17_test_vector_peer_pub_key[] = {
	0xdd, 0xa5, 0x46, 0xac, 0xfc, 0x8f, 0x90, 0x3d, 0x11, 0xe2, 0xe3, 0x92, 0x06, 0x69, 0x63, 0x6d, 0x44, 0xb2, 0x06, 0x8a, 0xeb, 0x66, 0xff, 0x07, 0xaa, 0x26, 0x6f, 0x00, 0x30, 0xe1, 0x53, 0x5b, 0x0e, 0xd0, 0x20, 0x3c, 0xb8, 0xa4, 0x60, 0xac, 0x99, 0x0f, 0x13, 0x94, 0xfa, 0xf2, 0x2f, 0x1d, 0x15, 0xbb, 0xb2, 0x59, 0x79, 0x13, 0x03, 0x5f, 0xaa, 0xdf, 0x41, 0x34, 0x76, 0xf4, 0xc7, 0x0f, 0x72, 0x79, 0x76, 0x9a, 0x40, 0xc9, 0x86, 0xf4, 0x70, 0xc4, 0x27, 0xb4, 0xee, 0x49, 0x62, 0xab, 0xdf, 0x81, 0x73, 0xbb, 0xad, 0x81, 0x87, 0x47, 0x72, 0x92, 0x5f, 0xd3, 0x2f, 0x0b, 0x15, 0x9f,
};
static const u8 ecccdh_SECP384R1_17_test_vector_our_pub_key[] = {
	0x5a, 0x94, 0x95, 0x94, 0x22, 0x8b, 0x1a, 0x3d, 0x6f, 0x59, 0x9e, 0xb3, 0xdb, 0x0d, 0x06, 0x07, 0x0f, 0xbc, 0x55, 0x1c, 0x65, 0x7b, 0x58, 0x23, 0x4b, 0xa1, 0x64, 0xce, 0x3f, 0xe4, 0x15, 0xfa, 0x5f, 0x3e, 0xb8, 0x23, 0xc0, 0x8d, 0xc2, 0x9b, 0x8c, 0x34, 0x12, 0x19, 0xc7, 0x7b, 0x6b, 0x3d, 0x2b, 0xaa, 0xd4, 0x47, 0xc8, 0xc2, 0x90, 0xcf, 0xed, 0x25, 0xed, 0xd9, 0x03, 0x1c, 0x41, 0xd0, 0xb7, 0x69, 0x21, 0x45, 0x73, 0x27, 0xf4, 0x2d, 0xb3, 0x11, 0x22, 0xb8, 0x1f, 0x33, 0x7b, 0xbf, 0x0b, 0x10, 0x39, 0xec, 0x83, 0x0c, 0xe9, 0x06, 0x1a, 0x37, 0x61, 0x95, 0x3c, 0x75, 0xe4, 0xa8,
};
static const u8 ecccdh_SECP384R1_17_test_vector_shared_secret[] = {
	0x12, 0x20, 0xe7, 0xe6, 0xca, 0xd7, 0xb2, 0x5d, 0xf9, 0x8e, 0x5b, 0xbd, 0xcc, 0x6c, 0x0b, 0x65, 0xca, 0x6c, 0x2a, 0x50, 0xc5, 0xff, 0x6c, 0x41, 0xdc, 0xa7, 0x1e, 0x47, 0x56, 0x46, 0xfd, 0x48, 0x96, 0x15, 0x97, 0x9c, 0xa9, 0x2f, 0xb4, 0x38, 0x9a, 0xea, 0xde, 0xfd, 0xe7, 0x9a, 0x24, 0xf1,
};
static const ecdh_test_case ecccdh_SECP384R1_17_test_case = {
	.name = "ECCCDH/SECP384R1 17",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_17_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_17_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_17_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_17_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_17_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_17_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_17_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_17_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_18
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_18_test_vector_our_priv_key[] = {
	0x50, 0xcc, 0xc1, 0xf7, 0x07, 0x6e, 0x92, 0xf4, 0x63, 0x8e, 0x85, 0xf2, 0xdb, 0x98, 0xe0, 0xb4, 0x83, 0xe6, 0xe2, 0x20, 0x4c, 0x92, 0xbd, 0xd4, 0x40, 0xa6, 0xde, 0xea, 0x04, 0xe3, 0x7a, 0x07, 0xc6, 0xe7, 0x27, 0x91, 0xc1, 0x90, 0xad, 0x4e, 0x4e, 0x86, 0xe0, 0x1e, 0xfb, 0xa8, 0x42, 0x69,
};
static const u8 ecccdh_SECP384R1_18_test_vector_peer_pub_key[] = {
	0x78, 0x8b, 0xe2, 0x33, 0x6c, 0x52, 0xf4, 0x45, 0x4d, 0x63, 0xee, 0x94, 0x4b, 0x1e, 0x49, 0xbf, 0xb6, 0x19, 0xa0, 0x83, 0x71, 0x04, 0x8e, 0x6d, 0xa9, 0x2e, 0x58, 0x4e, 0xae, 0x70, 0xbd, 0xe1, 0xf1, 0x71, 0xc4, 0xdf, 0x37, 0x8b, 0xd1, 0xf3, 0xc0, 0xab, 0x03, 0x04, 0x8a, 0x23, 0x78, 0x02, 0x46, 0x73, 0xeb, 0xd8, 0xdb, 0x60, 0x4e, 0xaf, 0x41, 0x71, 0x17, 0x48, 0xba, 0xb2, 0x96, 0x8a, 0x23, 0xca, 0x44, 0x76, 0xce, 0x14, 0x4e, 0x72, 0x82, 0x47, 0xf0, 0x8a, 0xf7, 0x52, 0x92, 0x91, 0x57, 0xb5, 0x83, 0x0f, 0x1e, 0x26, 0x06, 0x74, 0x66, 0xbd, 0xfa, 0x8b, 0x65, 0x14, 0x5a, 0x33,
};
static const u8 ecccdh_SECP384R1_18_test_vector_our_pub_key[] = {
	0x75, 0x6c, 0x07, 0xdf, 0x0c, 0xe3, 0x2c, 0x83, 0x9d, 0xac, 0x9f, 0xb4, 0x73, 0x3c, 0x9c, 0x28, 0xb7, 0x01, 0x13, 0xa6, 0x76, 0xa7, 0x05, 0x7c, 0x38, 0xd2, 0x23, 0xf2, 0x2a, 0x3a, 0x90, 0x95, 0xa8, 0xd5, 0x64, 0x65, 0x3a, 0xf5, 0x28, 0xe0, 0x4c, 0x7e, 0x18, 0x24, 0xbe, 0x4a, 0x65, 0x12, 0x17, 0xc2, 0xce, 0x69, 0x62, 0xcb, 0xd2, 0xa2, 0xe0, 0x66, 0x29, 0x7b, 0x39, 0xd5, 0x7d, 0xd9, 0xbb, 0x46, 0x80, 0xf0, 0x19, 0x1d, 0x39, 0x0f, 0x70, 0xb4, 0xe4, 0x61, 0x41, 0x9b, 0x29, 0x72, 0xce, 0x68, 0xad, 0x46, 0x12, 0x7f, 0xdd, 0xa6, 0xc3, 0x91, 0x95, 0x77, 0x4e, 0xa8, 0x6d, 0xf3,
};
static const u8 ecccdh_SECP384R1_18_test_vector_shared_secret[] = {
	0x79, 0x3b, 0xb9, 0xcd, 0x22, 0xa9, 0x3c, 0xf4, 0x68, 0xfa, 0xf8, 0x04, 0xa3, 0x8d, 0x12, 0xb7, 0x8c, 0xb1, 0x21, 0x89, 0xec, 0x67, 0x9d, 0xdd, 0x2e, 0x9a, 0xa2, 0x1f, 0xa9, 0xa5, 0xa0, 0xb0, 0x49, 0xab, 0x16, 0xa2, 0x35, 0x74, 0xfe, 0x04, 0xc1, 0xc3, 0xc0, 0x23, 0x43, 0xb9, 0x1b, 0xeb,
};
static const ecdh_test_case ecccdh_SECP384R1_18_test_case = {
	.name = "ECCCDH/SECP384R1 18",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_18_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_18_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_18_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_18_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_18_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_18_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_18_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_18_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_19
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_19_test_vector_our_priv_key[] = {
	0x06, 0xf1, 0x32, 0xb7, 0x1f, 0x74, 0xd8, 0x7b, 0xf9, 0x98, 0x57, 0xe1, 0xe4, 0x35, 0x0a, 0x59, 0x4e, 0x5f, 0xe3, 0x55, 0x33, 0xb8, 0x88, 0x55, 0x2c, 0xec, 0xcb, 0xc0, 0xd8, 0x92, 0x3c, 0x90, 0x2e, 0x36, 0x14, 0x1d, 0x76, 0x91, 0xe2, 0x86, 0x31, 0xb8, 0xbc, 0x9b, 0xaf, 0xe5, 0xe0, 0x64,
};
static const u8 ecccdh_SECP384R1_19_test_vector_peer_pub_key[] = {
	0xd0, 0x9b, 0xb8, 0x22, 0xeb, 0x99, 0xe3, 0x80, 0x60, 0x95, 0x47, 0x47, 0xc8, 0x2b, 0xb3, 0x27, 0x8c, 0xf9, 0x6b, 0xbf, 0x36, 0xfe, 0xce, 0x34, 0x00, 0xf4, 0xc8, 0x73, 0x83, 0x8a, 0x40, 0xc1, 0x35, 0xeb, 0x3b, 0xab, 0xb9, 0x29, 0x3b, 0xd1, 0x00, 0x1b, 0xf3, 0xec, 0xde, 0xe7, 0xbf, 0x26, 0xd4, 0x16, 0xdb, 0x6e, 0x1b, 0x87, 0xbb, 0xb7, 0x42, 0x77, 0x88, 0xa3, 0xb6, 0xc7, 0xa7, 0xab, 0x2c, 0x16, 0x5b, 0x1e, 0x36, 0x6f, 0x96, 0x08, 0xdf, 0x51, 0x20, 0x37, 0x58, 0x4f, 0x21, 0x3a, 0x64, 0x8d, 0x47, 0xf1, 0x6a, 0xc3, 0x26, 0xe1, 0x9a, 0xae, 0x97, 0x2f, 0x63, 0xfd, 0x76, 0xc9,
};
static const u8 ecccdh_SECP384R1_19_test_vector_our_pub_key[] = {
	0x2a, 0x3c, 0xc6, 0xb8, 0xff, 0x5c, 0xde, 0x92, 0x6e, 0x7e, 0x3a, 0x18, 0x9a, 0x1b, 0xd0, 0x29, 0xc9, 0xb5, 0x86, 0x35, 0x1a, 0xf8, 0x83, 0x8f, 0x4f, 0x20, 0x1c, 0xb8, 0xf4, 0xb7, 0x0e, 0xf3, 0xb0, 0xda, 0x06, 0xd3, 0x52, 0xc8, 0x0f, 0xc2, 0x6b, 0xaf, 0x8f, 0x42, 0xb7, 0x84, 0x45, 0x9e, 0xbf, 0x99, 0x85, 0x96, 0x01, 0x76, 0xda, 0x6d, 0x23, 0xc7, 0x45, 0x2a, 0x29, 0x54, 0xff, 0xcb, 0xbc, 0xb2, 0x42, 0x49, 0xb4, 0x30, 0x19, 0xa2, 0xa0, 0x23, 0xe0, 0xb3, 0xda, 0xbd, 0x46, 0x1f, 0x19, 0xad, 0x3e, 0x77, 0x5c, 0x36, 0x4f, 0x3f, 0x11, 0xad, 0x49, 0xf3, 0x09, 0x94, 0x00, 0xd3,
};
static const u8 ecccdh_SECP384R1_19_test_vector_shared_secret[] = {
	0x01, 0x2d, 0x19, 0x1c, 0xf7, 0x40, 0x4a, 0x52, 0x36, 0x78, 0xc6, 0xfc, 0x07, 0x5d, 0xe8, 0x28, 0x5b, 0x24, 0x37, 0x20, 0xa9, 0x03, 0x04, 0x77, 0x08, 0xbb, 0x33, 0xe5, 0x01, 0xe0, 0xdb, 0xee, 0x5b, 0xcc, 0x40, 0xd7, 0xc3, 0xef, 0x6c, 0x6d, 0xa3, 0x9e, 0xa2, 0x4d, 0x83, 0x0d, 0xa1, 0xe8,
};
static const ecdh_test_case ecccdh_SECP384R1_19_test_case = {
	.name = "ECCCDH/SECP384R1 19",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_19_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_19_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_19_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_19_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_19_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_19_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_19_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_19_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_20
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_20_test_vector_our_priv_key[] = {
	0x12, 0x04, 0x8e, 0xbb, 0x43, 0x31, 0xec, 0x19, 0xa1, 0xe2, 0x3f, 0x1a, 0x2c, 0x77, 0x3b, 0x66, 0x4c, 0xcf, 0xe9, 0x0a, 0x28, 0xbf, 0xb8, 0x46, 0xfc, 0x12, 0xf8, 0x1d, 0xff, 0x44, 0xb7, 0x44, 0x3c, 0x77, 0x64, 0x71, 0x64, 0xbf, 0x1e, 0x9e, 0x67, 0xfd, 0x2c, 0x07, 0xa6, 0x76, 0x62, 0x41,
};
static const u8 ecccdh_SECP384R1_20_test_vector_peer_pub_key[] = {
	0x13, 0x74, 0x12, 0x62, 0xed, 0xe5, 0x86, 0x1d, 0xad, 0x71, 0x06, 0x3d, 0xfd, 0x20, 0x4b, 0x91, 0xea, 0x1d, 0x3b, 0x7c, 0x63, 0x1d, 0xf6, 0x8e, 0xb9, 0x49, 0x96, 0x95, 0x27, 0xd7, 0x9a, 0x1d, 0xc5, 0x92, 0x95, 0xef, 0x7d, 0x2b, 0xca, 0x67, 0x43, 0xe8, 0xcd, 0x77, 0xb0, 0x4d, 0x1b, 0x58, 0x0b, 0xaa, 0xea, 0xdc, 0x7e, 0x19, 0xd7, 0x4a, 0x8a, 0x04, 0x45, 0x1a, 0x13, 0x5f, 0x1b, 0xe1, 0xb0, 0x2f, 0xe2, 0x99, 0xf9, 0xdc, 0x00, 0xbf, 0xdf, 0x20, 0x1e, 0x83, 0xd9, 0x95, 0xc6, 0x95, 0x0b, 0xcc, 0x1c, 0xb8, 0x9d, 0x6f, 0x7b, 0x30, 0xbf, 0x54, 0x65, 0x6b, 0x9a, 0x4d, 0xa5, 0x86,
};
static const u8 ecccdh_SECP384R1_20_test_vector_our_pub_key[] = {
	0xbc, 0x18, 0x83, 0x6b, 0xc7, 0xa9, 0xfd, 0xf5, 0x4b, 0x53, 0x52, 0xf3, 0x7d, 0x75, 0x28, 0xab, 0x8f, 0xa8, 0xec, 0x54, 0x4a, 0x8c, 0x61, 0x80, 0x51, 0x1c, 0xbf, 0xdd, 0x49, 0xcc, 0xe3, 0x77, 0xc3, 0x9e, 0x34, 0xc0, 0x31, 0xb5, 0x24, 0x0d, 0xc9, 0x98, 0x05, 0x03, 0xed, 0x2f, 0x26, 0x2c, 0x80, 0x86, 0xcb, 0xe3, 0x38, 0x19, 0x10, 0x80, 0xf0, 0xb7, 0xa1, 0x6c, 0x7a, 0xfc, 0x4c, 0x7b, 0x03, 0x26, 0xf9, 0xac, 0x66, 0xf5, 0x85, 0x52, 0xef, 0x4b, 0xb9, 0xd2, 0x4d, 0xe3, 0x42, 0x9e, 0xd5, 0xd3, 0x27, 0x7e, 0xd5, 0x8f, 0xcf, 0x48, 0xf2, 0xb5, 0xf6, 0x13, 0x26, 0xbe, 0xc6, 0xc6,
};
static const u8 ecccdh_SECP384R1_20_test_vector_shared_secret[] = {
	0xad, 0x0f, 0xd3, 0xdd, 0xff, 0xe8, 0x88, 0x4b, 0x92, 0x63, 0xf3, 0xc1, 0x5f, 0xe1, 0xf0, 0x7f, 0x2a, 0x5a, 0x22, 0xff, 0xdc, 0x7e, 0x96, 0x70, 0x85, 0xee, 0xa4, 0x5f, 0x0c, 0xd9, 0x59, 0xf2, 0x0f, 0x18, 0xf5, 0x22, 0x76, 0x3e, 0x28, 0xbc, 0xc9, 0x25, 0xe4, 0x96, 0xa5, 0x2d, 0xda, 0x98,
};
static const ecdh_test_case ecccdh_SECP384R1_20_test_case = {
	.name = "ECCCDH/SECP384R1 20",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_20_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_20_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_20_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_20_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_20_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_20_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_20_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_20_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_21
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_21_test_vector_our_priv_key[] = {
	0x34, 0xd6, 0x1a, 0x69, 0x9c, 0xa5, 0x76, 0x16, 0x9f, 0xcd, 0xc0, 0xcc, 0x7e, 0x44, 0xe4, 0xe1, 0x22, 0x1d, 0xb0, 0xfe, 0x63, 0xd1, 0x68, 0x50, 0xc8, 0x10, 0x40, 0x29, 0xf7, 0xd4, 0x84, 0x49, 0x71, 0x4b, 0x98, 0x84, 0x32, 0x8c, 0xae, 0x18, 0x99, 0x78, 0x75, 0x4a, 0xb4, 0x60, 0xb4, 0x86,
};
static const u8 ecccdh_SECP384R1_21_test_vector_peer_pub_key[] = {
	0x9e, 0x22, 0xcb, 0xc1, 0x86, 0x57, 0xf5, 0x16, 0xa8, 0x64, 0xb3, 0x7b, 0x78, 0x33, 0x48, 0xb6, 0x6f, 0x1a, 0xa9, 0x62, 0x6c, 0xd6, 0x31, 0xf4, 0xfa, 0x1b, 0xd3, 0x2a, 0xd8, 0x8c, 0xf1, 0x1d, 0xb5, 0x20, 0x57, 0xc6, 0x60, 0x86, 0x0d, 0x39, 0xd1, 0x1f, 0xbf, 0x02, 0x4f, 0xab, 0xd4, 0x44, 0x6b, 0x0d, 0x53, 0xc7, 0x96, 0x81, 0xc2, 0x81, 0x16, 0xdf, 0x71, 0xe9, 0xce, 0xe7, 0x4f, 0xd5, 0x6c, 0x8b, 0x7f, 0x04, 0xb3, 0x9f, 0x11, 0x98, 0xcc, 0x72, 0x28, 0x4e, 0x98, 0xbe, 0x95, 0x62, 0xe3, 0x59, 0x26, 0xfb, 0x4f, 0x48, 0xa9, 0xfb, 0xec, 0xaf, 0xe7, 0x29, 0x30, 0x9e, 0x8b, 0x6f,
};
static const u8 ecccdh_SECP384R1_21_test_vector_our_pub_key[] = {
	0x86, 0x7f, 0x81, 0x10, 0x4c, 0xcd, 0x6b, 0x16, 0x3a, 0x79, 0x02, 0xb6, 0x70, 0xef, 0x40, 0x60, 0x42, 0xcb, 0x0c, 0xce, 0x7d, 0xcd, 0xc6, 0x3d, 0x1d, 0xfc, 0x91, 0xb2, 0xc4, 0x0e, 0x3c, 0xdf, 0x75, 0x95, 0x83, 0x4b, 0xf9, 0xec, 0xeb, 0x79, 0x84, 0x9f, 0x16, 0x36, 0xfc, 0x84, 0x62, 0xfc, 0x9d, 0x4b, 0xde, 0x8e, 0x87, 0x5e, 0xc4, 0x96, 0x97, 0xd2, 0x58, 0xd1, 0xd5, 0x94, 0x65, 0xf8, 0x43, 0x1c, 0x6f, 0x55, 0x31, 0xe1, 0xc5, 0x9e, 0x9f, 0x9e, 0xbe, 0x3c, 0xf1, 0x64, 0xa8, 0xd9, 0xce, 0x10, 0xa1, 0x2f, 0x19, 0x79, 0x28, 0x3a, 0x95, 0x9b, 0xad, 0x24, 0x4d, 0xd8, 0x38, 0x63,
};
static const u8 ecccdh_SECP384R1_21_test_vector_shared_secret[] = {
	0xdc, 0x4c, 0xa3, 0x92, 0xdc, 0x15, 0xe2, 0x01, 0x85, 0xf2, 0xc6, 0xa8, 0xea, 0x5e, 0xc3, 0x1d, 0xfc, 0x96, 0xf5, 0x61, 0x53, 0xa4, 0x73, 0x94, 0xb3, 0x07, 0x2b, 0x13, 0xd0, 0x01, 0x5f, 0x5d, 0x4a, 0xe1, 0x3b, 0xeb, 0x3b, 0xed, 0x54, 0xd6, 0x58, 0x48, 0xf9, 0xb8, 0x38, 0x3e, 0x6c, 0x95,
};
static const ecdh_test_case ecccdh_SECP384R1_21_test_case = {
	.name = "ECCCDH/SECP384R1 21",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_21_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_21_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_21_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_21_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_21_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_21_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_21_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_21_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_22
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_22_test_vector_our_priv_key[] = {
	0xdc, 0x60, 0xfa, 0x87, 0x36, 0xd7, 0x02, 0x13, 0x5f, 0xf1, 0x6a, 0xab, 0x99, 0x2b, 0xb8, 0x8e, 0xac, 0x39, 0x7f, 0x59, 0x72, 0x45, 0x6c, 0x72, 0xec, 0x44, 0x73, 0x74, 0xd0, 0xd8, 0xce, 0x61, 0x15, 0x38, 0x31, 0xbf, 0xc8, 0x6a, 0xd5, 0xa6, 0xeb, 0x5b, 0x60, 0xbf, 0xb9, 0x6a, 0x86, 0x2c,
};
static const u8 ecccdh_SECP384R1_22_test_vector_peer_pub_key[] = {
	0x2d, 0xb5, 0xda, 0x5f, 0x94, 0x0e, 0xaa, 0x88, 0x4f, 0x4d, 0xb5, 0xec, 0x21, 0x39, 0xb0, 0x46, 0x9f, 0x38, 0xe4, 0xe6, 0xfb, 0xbc, 0xc5, 0x2d, 0xf1, 0x5c, 0x0f, 0x7c, 0xf7, 0xfc, 0xb1, 0x80, 0x8c, 0x74, 0x97, 0x64, 0xb6, 0xbe, 0x85, 0xd2, 0xfd, 0xc5, 0xb1, 0x6f, 0x58, 0xad, 0x5d, 0xc0, 0x22, 0xe8, 0xb0, 0x2d, 0xcf, 0x33, 0xe1, 0xb5, 0xa0, 0x83, 0x84, 0x95, 0x45, 0xf8, 0x4a, 0xd5, 0xe4, 0x3f, 0x77, 0xcb, 0x71, 0x54, 0x6d, 0xbb, 0xac, 0x0d, 0x11, 0xbd, 0xb2, 0xee, 0x20, 0x2e, 0x9d, 0x38, 0x72, 0xe8, 0xd0, 0x28, 0xc0, 0x89, 0x90, 0x74, 0x6c, 0x5e, 0x1d, 0xde, 0x99, 0x89,
};
static const u8 ecccdh_SECP384R1_22_test_vector_our_pub_key[] = {
	0xb6, 0x9b, 0xee, 0xde, 0x85, 0xd0, 0xf8, 0x29, 0xfe, 0xc1, 0xb8, 0x93, 0xcc, 0xb9, 0xc3, 0xe0, 0x52, 0xff, 0x69, 0x2e, 0x13, 0xb9, 0x74, 0x53, 0x7b, 0xc5, 0xb0, 0xf9, 0xfe, 0xaf, 0x7b, 0x22, 0xe8, 0x4f, 0x03, 0x23, 0x16, 0x29, 0xb2, 0x48, 0x66, 0xbd, 0xb4, 0xb8, 0xcf, 0x90, 0x89, 0x14, 0x66, 0xf8, 0x5e, 0x2b, 0xfc, 0xab, 0xa2, 0x84, 0x32, 0x85, 0xb0, 0xe1, 0x4e, 0xbc, 0x07, 0xef, 0x7d, 0xaf, 0xff, 0x8b, 0x42, 0x44, 0x16, 0xfe, 0xe6, 0x47, 0xb5, 0x98, 0x97, 0xb6, 0x19, 0xf2, 0x0e, 0xed, 0x95, 0xa6, 0x32, 0xe6, 0xa4, 0x20, 0x6b, 0xf7, 0xda, 0x42, 0x9c, 0x04, 0xc5, 0x60,
};
static const u8 ecccdh_SECP384R1_22_test_vector_shared_secret[] = {
	0xd7, 0x65, 0xb2, 0x08, 0x11, 0x2d, 0x2b, 0x9e, 0xd5, 0xad, 0x10, 0xc4, 0x04, 0x6e, 0x2e, 0x3b, 0x0d, 0xbf, 0x57, 0xc4, 0x69, 0x32, 0x95, 0x19, 0xe2, 0x39, 0xac, 0x28, 0xb2, 0x5c, 0x7d, 0x85, 0x2b, 0xf7, 0x57, 0xd5, 0xde, 0x0e, 0xe2, 0x71, 0xca, 0xdd, 0x02, 0x1d, 0x86, 0xcf, 0xd3, 0x47,
};
static const ecdh_test_case ecccdh_SECP384R1_22_test_case = {
	.name = "ECCCDH/SECP384R1 22",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_22_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_22_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_22_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_22_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_22_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_22_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_22_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_22_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_23
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_23_test_vector_our_priv_key[] = {
	0x6f, 0xa6, 0xa1, 0xc7, 0x04, 0x73, 0x09, 0x87, 0xaa, 0x63, 0x4b, 0x05, 0x16, 0xa8, 0x26, 0xab, 0xa8, 0xc6, 0xd6, 0x41, 0x1d, 0x3a, 0x4c, 0x89, 0x77, 0x2d, 0x7a, 0x62, 0x61, 0x02, 0x56, 0xa2, 0xe2, 0xf2, 0x89, 0xf5, 0xc3, 0x44, 0x0b, 0x0e, 0xc1, 0xe7, 0x0f, 0xa3, 0x39, 0xe2, 0x51, 0xce,
};
static const u8 ecccdh_SECP384R1_23_test_vector_peer_pub_key[] = {
	0x32, 0x96, 0x47, 0xba, 0xa3, 0x54, 0x22, 0x4e, 0xb4, 0x41, 0x48, 0x29, 0xc5, 0x36, 0x8c, 0x82, 0xd7, 0x89, 0x3b, 0x39, 0x80, 0x4e, 0x08, 0xcb, 0xb2, 0x18, 0x0f, 0x45, 0x9b, 0xef, 0xc4, 0xb3, 0x47, 0xa3, 0x89, 0xa7, 0x0c, 0x91, 0xa2, 0x3b, 0xd9, 0xd3, 0x0c, 0x83, 0xbe, 0x52, 0x95, 0xd3, 0xcc, 0x8f, 0x61, 0x92, 0x3f, 0xad, 0x2a, 0xa8, 0xe5, 0x05, 0xd6, 0xcf, 0xa1, 0x26, 0xb9, 0xfa, 0xbd, 0x5a, 0xf9, 0xdc, 0xe2, 0x90, 0xb7, 0x56, 0x60, 0xef, 0x06, 0xd1, 0xca, 0xa7, 0x36, 0x81, 0xd0, 0x60, 0x89, 0xc3, 0x3b, 0xc4, 0x24, 0x6b, 0x3a, 0xa3, 0x0d, 0xbc, 0xd2, 0x43, 0x5b, 0x12,
};
static const u8 ecccdh_SECP384R1_23_test_vector_our_pub_key[] = {
	0x53, 0xde, 0x1f, 0xc1, 0x32, 0x8e, 0x8d, 0xe1, 0x4a, 0xec, 0xab, 0x29, 0xad, 0x8a, 0x40, 0xd6, 0xb1, 0x37, 0x68, 0xf8, 0x6f, 0x7d, 0x29, 0x84, 0x33, 0xd2, 0x0f, 0xec, 0x79, 0x1f, 0x86, 0xf8, 0xbc, 0x73, 0xf3, 0x58, 0x09, 0x8b, 0x25, 0x6a, 0x29, 0x8b, 0xb4, 0x88, 0xde, 0x25, 0x7b, 0xf4, 0xac, 0x28, 0x94, 0x4f, 0xd2, 0x7f, 0x17, 0xb8, 0x29, 0x46, 0xc0, 0x4c, 0x66, 0xc4, 0x1f, 0x00, 0x53, 0xd3, 0x69, 0x2f, 0x27, 0x5d, 0xa5, 0x5c, 0xd8, 0x73, 0x9a, 0x95, 0xbd, 0x8c, 0xd3, 0xaf, 0x2f, 0x96, 0xe4, 0xde, 0x95, 0x9e, 0xa8, 0x34, 0x4d, 0x89, 0x45, 0x37, 0x59, 0x05, 0x85, 0x8b,
};
static const u8 ecccdh_SECP384R1_23_test_vector_shared_secret[] = {
	0xd3, 0x77, 0x88, 0x50, 0xae, 0xb5, 0x88, 0x04, 0xfb, 0xe9, 0xdf, 0xe6, 0xf3, 0x8b, 0x9f, 0xa8, 0xe2, 0x0c, 0x2c, 0xa4, 0xe0, 0xde, 0xc3, 0x35, 0xaa, 0xfc, 0xec, 0xa0, 0x33, 0x3e, 0x3f, 0x24, 0x90, 0xb5, 0x3c, 0x0c, 0x1a, 0x14, 0xa8, 0x31, 0xba, 0x37, 0xc4, 0xb9, 0xd7, 0x4b, 0xe0, 0xf2,
};
static const ecdh_test_case ecccdh_SECP384R1_23_test_case = {
	.name = "ECCCDH/SECP384R1 23",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_23_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_23_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_23_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_23_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_23_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_23_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_23_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_23_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP384R1
#define ECCCDH_SECP384R1_SELF_TEST_24
/*** Tests for ECCCDH/SECP384R1 ***/
static const u8 ecccdh_SECP384R1_24_test_vector_our_priv_key[] = {
	0x74, 0xad, 0x83, 0x86, 0xc1, 0xcb, 0x2c, 0xa0, 0xfc, 0xde, 0xb3, 0x1e, 0x08, 0x69, 0xbb, 0x3f, 0x48, 0xc0, 0x36, 0xaf, 0xe2, 0xef, 0x11, 0x0c, 0xa3, 0x02, 0xbc, 0x8b, 0x91, 0x0f, 0x62, 0x1c, 0x9f, 0xcc, 0x54, 0xce, 0xc3, 0x2b, 0xb8, 0x9e, 0xc7, 0xca, 0xa8, 0x4c, 0x7b, 0x8e, 0x54, 0xa8,
};
static const u8 ecccdh_SECP384R1_24_test_vector_peer_pub_key[] = {
	0x29, 0xd8, 0xa3, 0x6d, 0x22, 0x20, 0x0a, 0x75, 0xb7, 0xae, 0xa1, 0xbb, 0x47, 0xcd, 0xfc, 0xb1, 0xb7, 0xfd, 0x66, 0xde, 0x96, 0x70, 0x41, 0x43, 0x47, 0x28, 0xab, 0x5d, 0x53, 0x3a, 0x06, 0x0d, 0xf7, 0x32, 0x13, 0x06, 0x00, 0xfe, 0x6f, 0x75, 0x85, 0x2a, 0x87, 0x1f, 0xb2, 0x93, 0x8e, 0x39, 0xe1, 0x9b, 0x53, 0xdb, 0x52, 0x83, 0x95, 0xde, 0x89, 0x7a, 0x45, 0x10, 0x89, 0x67, 0x71, 0x5e, 0xb8, 0xcb, 0x55, 0xc3, 0xfc, 0xbf, 0x23, 0x37, 0x93, 0x72, 0xc0, 0x87, 0x3a, 0x05, 0x8d, 0x57, 0x54, 0x4b, 0x10, 0x2e, 0xcc, 0xe7, 0x22, 0xb2, 0xcc, 0xab, 0xb1, 0xa6, 0x03, 0x77, 0x4f, 0xd5,
};
static const u8 ecccdh_SECP384R1_24_test_vector_our_pub_key[] = {
	0x27, 0xa3, 0xe8, 0x3c, 0xfb, 0x9d, 0x51, 0x22, 0xe7, 0x31, 0x29, 0xd8, 0x01, 0x61, 0x58, 0x57, 0xda, 0x7c, 0xc0, 0x89, 0xcc, 0xcc, 0x9c, 0x54, 0xab, 0x30, 0x32, 0xa1, 0x9e, 0x0a, 0x0a, 0x9f, 0x67, 0x73, 0x46, 0xe3, 0x7f, 0x08, 0xa0, 0xb3, 0xed, 0x8d, 0xa6, 0xe5, 0xdd, 0x69, 0x10, 0x63, 0x8d, 0x60, 0xe4, 0x4a, 0xa5, 0xe0, 0xfd, 0x30, 0xc9, 0x18, 0x45, 0x67, 0x96, 0xaf, 0x37, 0xf0, 0xe4, 0x19, 0x57, 0x90, 0x16, 0x45, 0xe5, 0xc5, 0x96, 0xc6, 0xd9, 0x89, 0xf5, 0x85, 0x9b, 0x03, 0xa0, 0xbd, 0x7d, 0x1f, 0x4e, 0x77, 0x93, 0x6f, 0xff, 0x3c, 0x74, 0xd2, 0x04, 0xe5, 0x38, 0x8e,
};
static const u8 ecccdh_SECP384R1_24_test_vector_shared_secret[] = {
	0x81, 0xe1, 0xe7, 0x15, 0x75, 0xbb, 0x45, 0x05, 0x49, 0x8d, 0xe0, 0x97, 0x35, 0x01, 0x86, 0x43, 0x0a, 0x62, 0x42, 0xfa, 0x6c, 0x57, 0xb8, 0x5a, 0x5f, 0x98, 0x4a, 0x23, 0x37, 0x11, 0x23, 0xd2, 0xd1, 0x42, 0x4e, 0xef, 0xbf, 0x80, 0x42, 0x58, 0x39, 0x2b, 0xc7, 0x23, 0xe4, 0xef, 0x1e, 0x35,
};
static const ecdh_test_case ecccdh_SECP384R1_24_test_case = {
	.name = "ECCCDH/SECP384R1 24",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp384r1_str_params,
	.our_priv_key = ecccdh_SECP384R1_24_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP384R1_24_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP384R1_24_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP384R1_24_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP384R1_24_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP384R1_24_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP384R1_24_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP384R1_24_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP384R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_0
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_0_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x01, 0x7e, 0xec, 0xc0, 0x7a, 0xb4, 0xb3, 0x29, 0x06, 0x8f, 0xba, 0x65, 0xe5, 0x6a, 0x1f, 0x88, 0x90, 0xaa, 0x93, 0x5e, 0x57, 0x13, 0x4a, 0xe0, 0xff, 0xcc, 0xe8, 0x02, 0x73, 0x51, 0x51, 0xf4, 0xea, 0xc6, 0x56, 0x4f, 0x6e, 0xe9, 0x97, 0x4c, 0x5e, 0x68, 0x87, 0xa1, 0xfe, 0xfe, 0xe5, 0x74, 0x3a, 0xe2, 0x24, 0x1b, 0xfe, 0xb9, 0x5d, 0x5c, 0xe3, 0x1d, 0xdc, 0xb6, 0xf9, 0xed, 0xb4, 0xd6, 0xfc, 0x47,
};
static const u8 ecccdh_SECP521R1_0_test_vector_peer_pub_key[] = {
	0x00, 0x68, 0x5a, 0x48, 0xe8, 0x6c, 0x79, 0xf0, 0xf0, 0x87, 0x5f, 0x7b, 0xc1, 0x8d, 0x25, 0xeb, 0x5f, 0xc8, 0xc0, 0xb0, 0x7e, 0x5d, 0xa4, 0xf4, 0x37, 0x0f, 0x3a, 0x94, 0x90, 0x34, 0x08, 0x54, 0x33, 0x4b, 0x1e, 0x1b, 0x87, 0xfa, 0x39, 0x54, 0x64, 0xc6, 0x06, 0x26, 0x12, 0x4a, 0x4e, 0x70, 0xd0, 0xf7, 0x85, 0x60, 0x1d, 0x37, 0xc0, 0x98, 0x70, 0xeb, 0xf1, 0x76, 0x66, 0x68, 0x77, 0xa2, 0x04, 0x6d, 0x01, 0xba, 0x52, 0xc5, 0x6f, 0xc8, 0x77, 0x6d, 0x9e, 0x8f, 0x5d, 0xb4, 0xf0, 0xcc, 0x27, 0x63, 0x6d, 0x0b, 0x74, 0x1b, 0xbe, 0x05, 0x40, 0x06, 0x97, 0x94, 0x2e, 0x80, 0xb7, 0x39, 0x88, 0x4a, 0x83, 0xbd, 0xe9, 0x9e, 0x0f, 0x67, 0x16, 0x93, 0x9e, 0x63, 0x2b, 0xc8, 0x98, 0x6f, 0xa1, 0x8d, 0xcc, 0xd4, 0x43, 0xa3, 0x48, 0xb6, 0xc3, 0xe5, 0x22, 0x49, 0x79, 0x55, 0xa4, 0xf3, 0xc3, 0x02, 0xf6, 0x76,
};
static const u8 ecccdh_SECP521R1_0_test_vector_our_pub_key[] = {
	0x00, 0x60, 0x2f, 0x9d, 0x0c, 0xf9, 0xe5, 0x26, 0xb2, 0x9e, 0x22, 0x38, 0x1c, 0x20, 0x3c, 0x48, 0xa8, 0x86, 0xc2, 0xb0, 0x67, 0x30, 0x33, 0x36, 0x63, 0x14, 0xf1, 0xff, 0xbc, 0xba, 0x24, 0x0b, 0xa4, 0x2f, 0x4e, 0xf3, 0x8a, 0x76, 0x17, 0x46, 0x35, 0xf9, 0x1e, 0x6b, 0x4e, 0xd3, 0x42, 0x75, 0xeb, 0x01, 0xc8, 0x46, 0x7d, 0x05, 0xca, 0x80, 0x31, 0x5b, 0xf1, 0xa7, 0xbb, 0xd9, 0x45, 0xf5, 0x50, 0xa5, 0x01, 0xb7, 0xc8, 0x5f, 0x26, 0xf5, 0xd4, 0xb2, 0xd7, 0x35, 0x5c, 0xf6, 0xb0, 0x21, 0x17, 0x65, 0x99, 0x43, 0x76, 0x2b, 0x6d, 0x1d, 0xb5, 0xab, 0x4f, 0x1d, 0xbc, 0x44, 0xce, 0x7b, 0x29, 0x46, 0xeb, 0x6c, 0x7d, 0xe3, 0x42, 0x96, 0x28, 0x93, 0xfd, 0x38, 0x7d, 0x1b, 0x73, 0xd7, 0xa8, 0x67, 0x2d, 0x1f, 0x23, 0x69, 0x61, 0x17, 0x0b, 0x7e, 0xb3, 0x57, 0x99, 0x53, 0xee, 0x5c, 0xdc, 0x88, 0xcd, 0x2d,
};
static const u8 ecccdh_SECP521R1_0_test_vector_shared_secret[] = {
	0x00, 0x5f, 0xc7, 0x04, 0x77, 0xc3, 0xe6, 0x3b, 0xc3, 0x95, 0x4b, 0xd0, 0xdf, 0x3e, 0xa0, 0xd1, 0xf4, 0x1e, 0xe2, 0x17, 0x46, 0xed, 0x95, 0xfc, 0x5e, 0x1f, 0xdf, 0x90, 0x93, 0x0d, 0x5e, 0x13, 0x66, 0x72, 0xd7, 0x2c, 0xc7, 0x70, 0x74, 0x2d, 0x17, 0x11, 0xc3, 0xc3, 0xa4, 0xc3, 0x34, 0xa0, 0xad, 0x97, 0x59, 0x43, 0x6a, 0x4d, 0x3c, 0x5b, 0xf6, 0xe7, 0x4b, 0x95, 0x78, 0xfa, 0xc1, 0x48, 0xc8, 0x31,
};
static const ecdh_test_case ecccdh_SECP521R1_0_test_case = {
	.name = "ECCCDH/SECP521R1 0",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_0_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_0_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_0_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_0_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_0_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_0_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_0_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_0_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_1
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_1_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x00, 0x81, 0x6f, 0x19, 0xc1, 0xfb, 0x10, 0xef, 0x94, 0xd4, 0xa1, 0xd8, 0x1c, 0x15, 0x6e, 0xc3, 0xd1, 0xde, 0x08, 0xb6, 0x67, 0x61, 0xf0, 0x3f, 0x06, 0xee, 0x4b, 0xb9, 0xdc, 0xeb, 0xbb, 0xfe, 0x1e, 0xaa, 0x1e, 0xd4, 0x9a, 0x6a, 0x99, 0x08, 0x38, 0xd8, 0xed, 0x31, 0x8c, 0x14, 0xd7, 0x4c, 0xc8, 0x72, 0xf9, 0x5d, 0x05, 0xd0, 0x7a, 0xd5, 0x0f, 0x62, 0x1c, 0xeb, 0x62, 0x0c, 0xd9, 0x05, 0xcf, 0xb8,
};
static const u8 ecccdh_SECP521R1_1_test_vector_peer_pub_key[] = {
	0x01, 0xdf, 0x27, 0x7c, 0x15, 0x21, 0x08, 0x34, 0x9b, 0xc3, 0x4d, 0x53, 0x9e, 0xe0, 0xcf, 0x06, 0xb2, 0x4f, 0x5d, 0x35, 0x00, 0x67, 0x7b, 0x44, 0x45, 0x45, 0x3c, 0xcc, 0x21, 0x40, 0x94, 0x53, 0xaa, 0xfb, 0x8a, 0x72, 0xa0, 0xbe, 0x9e, 0xbe, 0x54, 0xd1, 0x22, 0x70, 0xaa, 0x51, 0xb3, 0xab, 0x7f, 0x31, 0x6a, 0xa5, 0xe7, 0x4a, 0x95, 0x1c, 0x5e, 0x53, 0xf7, 0x4c, 0xd9, 0x5f, 0xc2, 0x9a, 0xee, 0x7a, 0x01, 0x3d, 0x52, 0xf3, 0x3a, 0x9f, 0x3c, 0x14, 0x38, 0x4d, 0x15, 0x87, 0xfa, 0x8a, 0xbe, 0x7a, 0xed, 0x74, 0xbc, 0x33, 0x74, 0x9a, 0xd9, 0xc5, 0x70, 0xb4, 0x71, 0x77, 0x64, 0x22, 0xc7, 0xd4, 0x50, 0x5d, 0x9b, 0x0a, 0x96, 0xb3, 0xbf, 0xac, 0x04, 0x1e, 0x4c, 0x6a, 0x69, 0x90, 0xae, 0x7f, 0x70, 0x0e, 0x5b, 0x4a, 0x66, 0x40, 0x22, 0x91, 0x12, 0xde, 0xaf, 0xa0, 0xcd, 0x8b, 0xb0, 0xd0, 0x89, 0xb0,
};
static const u8 ecccdh_SECP521R1_1_test_vector_our_pub_key[] = {
	0x00, 0xd4, 0x56, 0x15, 0xed, 0x5d, 0x37, 0xfd, 0xe6, 0x99, 0x61, 0x0a, 0x62, 0xcd, 0x43, 0xba, 0x76, 0xbe, 0xdd, 0x8f, 0x85, 0xed, 0x31, 0x00, 0x5f, 0xe0, 0x0d, 0x64, 0x50, 0xfb, 0xbd, 0x10, 0x12, 0x91, 0xab, 0xd9, 0x6d, 0x49, 0x45, 0xa8, 0xb5, 0x7b, 0xc7, 0x3b, 0x3f, 0xe9, 0xf4, 0x67, 0x11, 0x05, 0x30, 0x9e, 0xc9, 0xb6, 0x87, 0x9d, 0x05, 0x51, 0xd9, 0x30, 0xda, 0xc8, 0xba, 0x45, 0xd2, 0x55, 0x01, 0x42, 0x53, 0x32, 0x84, 0x4e, 0x59, 0x2b, 0x44, 0x0c, 0x00, 0x27, 0x97, 0x2a, 0xd1, 0x52, 0x64, 0x31, 0xc0, 0x67, 0x32, 0xdf, 0x19, 0xcd, 0x46, 0xa2, 0x42, 0x17, 0x2d, 0x4d, 0xd6, 0x7c, 0x2c, 0x8c, 0x99, 0xdf, 0xc2, 0x2e, 0x49, 0x94, 0x9a, 0x56, 0xcf, 0x90, 0xc6, 0x47, 0x36, 0x35, 0xce, 0x82, 0xf2, 0x5b, 0x33, 0x68, 0x2f, 0xb1, 0x9b, 0xc3, 0x3b, 0xd9, 0x10, 0xed, 0x8c, 0xe3, 0xa7, 0xfa,
};
static const u8 ecccdh_SECP521R1_1_test_vector_shared_secret[] = {
	0x00, 0x0b, 0x39, 0x20, 0xac, 0x83, 0x0a, 0xde, 0x81, 0x2c, 0x8f, 0x96, 0x80, 0x5d, 0xa2, 0x23, 0x6e, 0x00, 0x2a, 0xcb, 0xbf, 0x13, 0x59, 0x6a, 0x9a, 0xb2, 0x54, 0xd4, 0x4d, 0x0e, 0x91, 0xb6, 0x25, 0x5e, 0xbf, 0x12, 0x29, 0xf3, 0x66, 0xfb, 0x5a, 0x05, 0xc5, 0x88, 0x4e, 0xf4, 0x60, 0x32, 0xc2, 0x6d, 0x42, 0x18, 0x92, 0x73, 0xca, 0x4e, 0xfa, 0x4c, 0x3d, 0xb6, 0xbd, 0x12, 0xa6, 0x85, 0x37, 0x59,
};
static const ecdh_test_case ecccdh_SECP521R1_1_test_case = {
	.name = "ECCCDH/SECP521R1 1",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_1_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_1_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_1_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_1_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_1_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_1_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_1_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_1_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_2
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_2_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x01, 0x2f, 0x2e, 0x0c, 0x6d, 0x9e, 0x9d, 0x11, 0x7c, 0xeb, 0x97, 0x23, 0xbc, 0xed, 0x02, 0xeb, 0x3d, 0x4e, 0xeb, 0xf5, 0xfe, 0xea, 0xf8, 0xee, 0x01, 0x13, 0xcc, 0xd8, 0x05, 0x7b, 0x13, 0xdd, 0xd4, 0x16, 0xe0, 0xb7, 0x42, 0x80, 0xc2, 0xd0, 0xba, 0x8e, 0xd2, 0x91, 0xc4, 0x43, 0xbc, 0x1b, 0x14, 0x1c, 0xaf, 0x8a, 0xfb, 0x3a, 0x71, 0xf9, 0x7f, 0x57, 0xc2, 0x25, 0xc0, 0x3e, 0x1e, 0x4d, 0x42, 0xb0,
};
static const u8 ecccdh_SECP521R1_2_test_vector_peer_pub_key[] = {
	0x00, 0x92, 0xdb, 0x31, 0x42, 0x56, 0x4d, 0x27, 0xa5, 0xf0, 0x00, 0x6f, 0x81, 0x99, 0x08, 0xfb, 0xa1, 0xb8, 0x50, 0x38, 0xa5, 0xbc, 0x25, 0x09, 0x90, 0x6a, 0x49, 0x7d, 0xaa, 0xc6, 0x7f, 0xd7, 0xae, 0xe0, 0xfc, 0x2d, 0xab, 0xa4, 0xe4, 0x33, 0x4e, 0xea, 0xef, 0x0e, 0x00, 0x19, 0x20, 0x4b, 0x47, 0x1c, 0xd8, 0x80, 0x24, 0xf8, 0x21, 0x15, 0xd8, 0x14, 0x9c, 0xc0, 0xcf, 0x4f, 0x7c, 0xe1, 0xa4, 0xd5, 0x01, 0x6b, 0xad, 0x06, 0x23, 0xf5, 0x17, 0xb1, 0x58, 0xd9, 0x88, 0x18, 0x41, 0xd2, 0x57, 0x1e, 0xfb, 0xad, 0x63, 0xf8, 0x5c, 0xbe, 0x2e, 0x58, 0x19, 0x60, 0xc5, 0xd6, 0x70, 0x60, 0x1a, 0x67, 0x60, 0x27, 0x26, 0x75, 0xa5, 0x48, 0x99, 0x62, 0x17, 0xe4, 0xab, 0x2b, 0x8e, 0xbc, 0xe3, 0x1d, 0x71, 0xfc, 0xa6, 0x3f, 0xcc, 0x3c, 0x08, 0xe9, 0x1c, 0x1d, 0x8e, 0xdd, 0x91, 0xcf, 0x6f, 0xe8, 0x45, 0xf8,
};
static const u8 ecccdh_SECP521R1_2_test_vector_our_pub_key[] = {
	0x00, 0x71, 0x7f, 0xcb, 0x3d, 0x4a, 0x40, 0xd1, 0x03, 0x87, 0x1e, 0xde, 0x04, 0x4d, 0xc8, 0x03, 0xdb, 0x50, 0x8a, 0xaa, 0x4a, 0xe7, 0x4b, 0x70, 0xb9, 0xfb, 0x8d, 0x8d, 0xfd, 0x84, 0xbf, 0xec, 0xfa, 0xd1, 0x78, 0x71, 0x87, 0x96, 0x98, 0xc2, 0x92, 0xd2, 0xfd, 0x5e, 0x17, 0xb4, 0xf9, 0x34, 0x36, 0x36, 0xc5, 0x31, 0xa4, 0xfa, 0xc6, 0x8a, 0x35, 0xa9, 0x36, 0x65, 0x54, 0x6b, 0x9a, 0x87, 0x86, 0x79, 0x00, 0xf3, 0xd9, 0x6a, 0x86, 0x37, 0x03, 0x69, 0x93, 0xab, 0x5d, 0x24, 0x45, 0x00, 0xff, 0xf9, 0xd2, 0x77, 0x21, 0x12, 0x82, 0x6f, 0x64, 0x36, 0x60, 0x3d, 0x3e, 0xb2, 0x34, 0xa4, 0x4d, 0x5c, 0x4e, 0x5c, 0x57, 0x72, 0x34, 0x67, 0x9c, 0x4f, 0x9d, 0xf7, 0x25, 0xee, 0x5b, 0x91, 0x18, 0xf2, 0x3d, 0x8a, 0x58, 0xd0, 0xcc, 0x01, 0x09, 0x6d, 0xaf, 0x70, 0xe8, 0xdf, 0xec, 0x01, 0x28, 0xbd, 0xc2, 0xe8,
};
static const u8 ecccdh_SECP521R1_2_test_vector_shared_secret[] = {
	0x00, 0x6b, 0x38, 0x0a, 0x6e, 0x95, 0x67, 0x92, 0x77, 0xcf, 0xee, 0x4e, 0x83, 0x53, 0xbf, 0x96, 0xef, 0x2a, 0x1e, 0xbd, 0xd0, 0x60, 0x74, 0x9f, 0x2f, 0x04, 0x6f, 0xe5, 0x71, 0x05, 0x37, 0x40, 0xbb, 0xcc, 0x9a, 0x0b, 0x55, 0x79, 0x0b, 0xc9, 0xab, 0x56, 0xc3, 0x20, 0x8a, 0xa0, 0x5d, 0xdf, 0x74, 0x6a, 0x10, 0xa3, 0xad, 0x69, 0x4d, 0xaa, 0xe0, 0x0d, 0x98, 0x0d, 0x94, 0x4a, 0xab, 0xc6, 0xa0, 0x8f,
};
static const ecdh_test_case ecccdh_SECP521R1_2_test_case = {
	.name = "ECCCDH/SECP521R1 2",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_2_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_2_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_2_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_2_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_2_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_2_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_2_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_2_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_3
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_3_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x00, 0xe5, 0x48, 0xa7, 0x9d, 0x8b, 0x05, 0xf9, 0x23, 0xb9, 0x82, 0x5d, 0x11, 0xb6, 0x56, 0xf2, 0x22, 0xe8, 0xcb, 0x98, 0xb0, 0xf8, 0x9d, 0xe1, 0xd3, 0x17, 0x18, 0x4d, 0xc5, 0xa6, 0x98, 0xf7, 0xc7, 0x11, 0x61, 0xee, 0x7d, 0xc1, 0x1c, 0xd3, 0x1f, 0x4f, 0x4f, 0x8a, 0xe3, 0xa9, 0x81, 0xe1, 0xa3, 0xe7, 0x8b, 0xde, 0xbb, 0x97, 0xd7, 0xc2, 0x04, 0xb9, 0x26, 0x1b, 0x4e, 0xf9, 0x2e, 0x09, 0x18, 0xe0,
};
static const u8 ecccdh_SECP521R1_3_test_vector_peer_pub_key[] = {
	0x00, 0xfd, 0xd4, 0x0d, 0x9e, 0x9d, 0x97, 0x40, 0x27, 0xcb, 0x3b, 0xae, 0x68, 0x21, 0x62, 0xea, 0xc1, 0x32, 0x8a, 0xd6, 0x1b, 0xc4, 0x35, 0x3c, 0x45, 0xbf, 0x5a, 0xfe, 0x76, 0xbf, 0x60, 0x7d, 0x28, 0x94, 0xc8, 0xcc, 0xe2, 0x36, 0x95, 0xd9, 0x20, 0xf2, 0x46, 0x4f, 0xda, 0x47, 0x73, 0xd4, 0x69, 0x3b, 0xe4, 0xb3, 0x77, 0x35, 0x84, 0x69, 0x1b, 0xdb, 0x03, 0x29, 0xb7, 0xf4, 0xc8, 0x6c, 0xc2, 0x99, 0x00, 0x34, 0xce, 0xac, 0x6a, 0x3f, 0xef, 0x1c, 0x3e, 0x1c, 0x49, 0x4b, 0xfe, 0x8d, 0x87, 0x2b, 0x18, 0x38, 0x32, 0x21, 0x9a, 0x7e, 0x14, 0xda, 0x41, 0x4d, 0x4e, 0x34, 0x74, 0x57, 0x36, 0x71, 0xec, 0x19, 0xb0, 0x33, 0xbe, 0x83, 0x1b, 0x91, 0x54, 0x35, 0x90, 0x59, 0x25, 0xb4, 0x49, 0x47, 0xc5, 0x92, 0x95, 0x99, 0x45, 0xb4, 0xeb, 0x7c, 0x95, 0x1c, 0x3b, 0x9c, 0x8c, 0xf5, 0x25, 0x30, 0xba, 0x23,
};
static const u8 ecccdh_SECP521R1_3_test_vector_our_pub_key[] = {
	0x00, 0x0c, 0xe8, 0x00, 0x21, 0x7e, 0xd2, 0x43, 0xdd, 0x10, 0xa7, 0x9a, 0xd7, 0x3d, 0xf5, 0x78, 0xaa, 0x8a, 0x3f, 0x91, 0x94, 0xaf, 0x52, 0x8c, 0xd1, 0x09, 0x4b, 0xbf, 0xee, 0x27, 0xa3, 0xb5, 0x48, 0x1a, 0xd5, 0x86, 0x2c, 0x88, 0x76, 0xc0, 0xc3, 0xf9, 0x12, 0x94, 0xc0, 0xab, 0x3a, 0xa8, 0x06, 0xd9, 0x02, 0x0c, 0xba, 0xa2, 0xed, 0x72, 0xb7, 0xfe, 0xcd, 0xc5, 0xa0, 0x9a, 0x6d, 0xad, 0x6f, 0x32, 0x01, 0x54, 0x3c, 0x9a, 0xb4, 0x5b, 0x12, 0x46, 0x92, 0x32, 0x91, 0x8e, 0x21, 0xd5, 0xa3, 0x51, 0xf9, 0xa4, 0xb9, 0xcb, 0xf9, 0xef, 0xb2, 0xaf, 0xcc, 0x40, 0x2f, 0xa9, 0xb3, 0x16, 0x50, 0xbe, 0xc2, 0xd6, 0x41, 0xa0, 0x5c, 0x44, 0x0d, 0x35, 0x33, 0x1c, 0x08, 0x93, 0xd1, 0x1f, 0xb1, 0x31, 0x51, 0x33, 0x59, 0x88, 0xb3, 0x03, 0x34, 0x13, 0x01, 0xa7, 0x3d, 0xc5, 0xf6, 0x1d, 0x57, 0x4e, 0x67, 0xd9,
};
static const u8 ecccdh_SECP521R1_3_test_vector_shared_secret[] = {
	0x00, 0xfb, 0xbc, 0xd0, 0xb8, 0xd0, 0x53, 0x31, 0xfe, 0xf6, 0x08, 0x6f, 0x22, 0xa6, 0xcc, 0xe4, 0xd3, 0x57, 0x24, 0xab, 0x7a, 0x2f, 0x49, 0xdd, 0x84, 0x58, 0xd0, 0xbf, 0xd5, 0x7a, 0x0b, 0x8b, 0x70, 0xf2, 0x46, 0xc1, 0x7c, 0x44, 0x68, 0xc0, 0x76, 0x87, 0x4b, 0x0d, 0xff, 0x7a, 0x03, 0x36, 0x82, 0x3b, 0x19, 0xe9, 0x8b, 0xf1, 0xce, 0xc0, 0x5e, 0x4b, 0xef, 0xfb, 0x05, 0x91, 0xf9, 0x77, 0x13, 0xc6,
};
static const ecdh_test_case ecccdh_SECP521R1_3_test_case = {
	.name = "ECCCDH/SECP521R1 3",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_3_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_3_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_3_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_3_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_3_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_3_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_3_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_3_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_4
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_4_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x01, 0xc8, 0xaa, 0xe9, 0x4b, 0xb1, 0x0b, 0x8c, 0xa4, 0xf7, 0xbe, 0x57, 0x7b, 0x4f, 0xb3, 0x2b, 0xb2, 0x38, 0x10, 0x32, 0xc4, 0x94, 0x2c, 0x24, 0xfc, 0x2d, 0x75, 0x3e, 0x7c, 0xc5, 0xe4, 0x7b, 0x48, 0x33, 0x89, 0xd9, 0xf3, 0xb9, 0x56, 0xd2, 0x0e, 0xe9, 0x00, 0x1b, 0x1e, 0xef, 0x9f, 0x23, 0x54, 0x5f, 0x72, 0xc5, 0x60, 0x21, 0x40, 0x04, 0x68, 0x39, 0xe9, 0x63, 0x31, 0x3c, 0x3d, 0xec, 0xc8, 0x64,
};
static const u8 ecccdh_SECP521R1_4_test_vector_peer_pub_key[] = {
	0x00, 0x98, 0xd9, 0x9d, 0xee, 0x08, 0x16, 0x55, 0x0e, 0x84, 0xdb, 0xfc, 0xed, 0x7e, 0x88, 0x13, 0x7f, 0xdd, 0xcf, 0x58, 0x1a, 0x72, 0x5a, 0x45, 0x50, 0x21, 0x11, 0x5f, 0xe4, 0x9f, 0x8d, 0xc3, 0xcf, 0x23, 0x3c, 0xd9, 0xea, 0x0e, 0x6f, 0x03, 0x9d, 0xc7, 0x91, 0x9d, 0xa9, 0x73, 0xcd, 0xce, 0xac, 0xa2, 0x05, 0xda, 0x39, 0xe0, 0xbd, 0x98, 0xc8, 0x06, 0x25, 0x36, 0xc4, 0x7f, 0x25, 0x8f, 0x44, 0xb5, 0x00, 0xcd, 0x22, 0x5c, 0x87, 0x97, 0x37, 0x1b, 0xe0, 0xc4, 0x29, 0x7d, 0x2b, 0x45, 0x77, 0x40, 0x10, 0x0c, 0x77, 0x41, 0x41, 0xd8, 0xf2, 0x14, 0xc2, 0x3b, 0x61, 0xaa, 0x2b, 0x6c, 0xd4, 0x80, 0x6b, 0x9b, 0x70, 0x72, 0x2a, 0xa4, 0x96, 0x5f, 0xb6, 0x22, 0xf4, 0x2b, 0x73, 0x91, 0xe2, 0x7e, 0x5e, 0xc2, 0x1c, 0x56, 0x79, 0xc5, 0xb0, 0x6b, 0x59, 0x12, 0x73, 0x72, 0x99, 0x7d, 0x42, 0x1a, 0xdc, 0x1e,
};
static const u8 ecccdh_SECP521R1_4_test_vector_our_pub_key[] = {
	0x01, 0x06, 0xa1, 0x4e, 0x2e, 0xe8, 0xff, 0x97, 0x0a, 0xa8, 0xab, 0x0c, 0x79, 0xb9, 0x7a, 0x33, 0xbb, 0xa2, 0x95, 0x8e, 0x07, 0x0b, 0x75, 0xb9, 0x47, 0x36, 0xb7, 0x7b, 0xbe, 0x3f, 0x77, 0x73, 0x24, 0xfa, 0x52, 0x87, 0x27, 0x71, 0xaa, 0x88, 0xa6, 0x3a, 0x9e, 0x84, 0x90, 0xc3, 0x37, 0x8d, 0xf4, 0xdc, 0x76, 0x0c, 0xd1, 0x4d, 0x62, 0xbe, 0x70, 0x07, 0x79, 0xdd, 0x1a, 0x43, 0x77, 0x94, 0x36, 0x56, 0x00, 0x23, 0x66, 0xce, 0x39, 0x41, 0xe0, 0xb2, 0x84, 0xb1, 0xaa, 0x81, 0x21, 0x5d, 0x0d, 0x3b, 0x97, 0x78, 0xfc, 0xe2, 0x3c, 0x8c, 0xd1, 0xe4, 0xed, 0x6f, 0xa0, 0xab, 0xf6, 0x21, 0x56, 0xc9, 0x1d, 0x4b, 0x3e, 0xb5, 0x59, 0x99, 0xc3, 0x47, 0x1b, 0xed, 0x27, 0x5e, 0x9e, 0x60, 0xe5, 0xaa, 0x9d, 0x69, 0x0d, 0x31, 0x0b, 0xfb, 0x15, 0xc9, 0xc5, 0xbb, 0xd6, 0xf5, 0xe9, 0xeb, 0x39, 0x68, 0x2b, 0x74,
};
static const u8 ecccdh_SECP521R1_4_test_vector_shared_secret[] = {
	0x01, 0x45, 0xcf, 0xa3, 0x8f, 0x25, 0x94, 0x35, 0x16, 0xc9, 0x6a, 0x5f, 0xd4, 0xbf, 0xeb, 0xb2, 0xf6, 0x45, 0xd1, 0x05, 0x20, 0x11, 0x7a, 0xa5, 0x19, 0x71, 0xef, 0xf4, 0x42, 0x80, 0x8a, 0x23, 0xb4, 0xe2, 0x3c, 0x18, 0x7e, 0x63, 0x9f, 0xf9, 0x28, 0xc3, 0x72, 0x5f, 0xbd, 0x1c, 0x0c, 0x2a, 0xd0, 0xd4, 0xae, 0xb2, 0x07, 0xbc, 0x1a, 0x6f, 0xb6, 0xcb, 0x6d, 0x46, 0x78, 0x88, 0xdc, 0x04, 0x4b, 0x3c,
};
static const ecdh_test_case ecccdh_SECP521R1_4_test_case = {
	.name = "ECCCDH/SECP521R1 4",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_4_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_4_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_4_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_4_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_4_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_4_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_4_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_4_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_5
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_5_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x00, 0x9b, 0x0a, 0xf1, 0x37, 0xc9, 0x69, 0x6c, 0x75, 0xb7, 0xe6, 0xdf, 0x7b, 0x73, 0x15, 0x6b, 0xb2, 0xd4, 0x5f, 0x48, 0x2e, 0x5a, 0x42, 0x17, 0x32, 0x4f, 0x47, 0x8b, 0x10, 0xce, 0xb7, 0x6a, 0xf0, 0x97, 0x24, 0xcf, 0x86, 0xaf, 0xa3, 0x16, 0xe7, 0xf8, 0x99, 0x18, 0xd3, 0x1d, 0x54, 0x82, 0x4a, 0x5c, 0x33, 0x10, 0x7a, 0x48, 0x3c, 0x15, 0xc1, 0x5b, 0x96, 0xed, 0xc6, 0x61, 0x34, 0x0b, 0x1c, 0x0e,
};
static const u8 ecccdh_SECP521R1_5_test_vector_peer_pub_key[] = {
	0x00, 0x7a, 0xe1, 0x15, 0xad, 0xaa, 0xf0, 0x41, 0x69, 0x1a, 0xb6, 0xb7, 0xfb, 0x8c, 0x92, 0x1f, 0x99, 0xd8, 0xed, 0x32, 0xd2, 0x83, 0xd6, 0x70, 0x84, 0xe8, 0x0b, 0x9a, 0xd9, 0xc4, 0x0c, 0x56, 0xcd, 0x98, 0x38, 0x9f, 0xb0, 0xa8, 0x49, 0xd9, 0xec, 0xf7, 0x26, 0x8c, 0x29, 0x7b, 0x6f, 0x93, 0x40, 0x61, 0x19, 0xf4, 0x0e, 0x32, 0xb5, 0x77, 0x3e, 0xd2, 0x5a, 0x28, 0xa9, 0xa8, 0x5c, 0x4a, 0x75, 0x88, 0x01, 0xa2, 0x8e, 0x00, 0x4e, 0x37, 0xee, 0xae, 0xfe, 0x1f, 0x4d, 0xbb, 0x71, 0xf1, 0x87, 0x86, 0x96, 0x14, 0x1a, 0xf3, 0xa1, 0x0a, 0x96, 0x91, 0xc4, 0xed, 0x93, 0x48, 0x72, 0x14, 0x64, 0x3b, 0x76, 0x1f, 0xa4, 0xb0, 0xfb, 0xee, 0xb2, 0x47, 0xcf, 0x6d, 0x3f, 0xba, 0x7a, 0x60, 0x69, 0x75, 0x36, 0xad, 0x03, 0xf4, 0x9b, 0x80, 0xa9, 0xd1, 0xcb, 0x07, 0x96, 0x73, 0x65, 0x49, 0x77, 0xc5, 0xfa, 0x94,
};
static const u8 ecccdh_SECP521R1_5_test_vector_our_pub_key[] = {
	0x00, 0x74, 0x8c, 0xdb, 0xb8, 0x75, 0xd3, 0x5f, 0x4b, 0xcc, 0xb6, 0x2a, 0xbe, 0x20, 0xe8, 0x2d, 0x32, 0xe4, 0xc1, 0x4d, 0xc2, 0xfe, 0xb5, 0xb8, 0x7d, 0xa2, 0xd0, 0xcc, 0xb1, 0x1c, 0x9b, 0x6d, 0x4b, 0x77, 0x37, 0xb6, 0xc4, 0x6f, 0x0d, 0xfb, 0x4d, 0x89, 0x6e, 0x2d, 0xb9, 0x2f, 0xcf, 0x53, 0xcd, 0xbb, 0xae, 0x2a, 0x40, 0x4c, 0x0b, 0xab, 0xd5, 0x64, 0xad, 0x7a, 0xde, 0xac, 0x62, 0x73, 0xef, 0xa3, 0x01, 0x98, 0x4a, 0xca, 0xb8, 0xd8, 0xf1, 0x73, 0x32, 0x3d, 0xe0, 0xbb, 0x60, 0x27, 0x4b, 0x22, 0x88, 0x71, 0x60, 0x93, 0x73, 0xbb, 0x22, 0xa1, 0x72, 0x87, 0xe9, 0xde, 0xc7, 0x49, 0x58, 0x73, 0xab, 0xc0, 0x9a, 0x89, 0x15, 0xb5, 0x4c, 0x84, 0x55, 0xc8, 0xe0, 0x2f, 0x65, 0x4f, 0x60, 0x2e, 0x23, 0xa2, 0xbb, 0xd7, 0xa9, 0xeb, 0xb7, 0x4f, 0x30, 0x09, 0xbd, 0x65, 0xec, 0xc6, 0x50, 0x81, 0x4c, 0xc0,
};
static const u8 ecccdh_SECP521R1_5_test_vector_shared_secret[] = {
	0x00, 0x5c, 0x57, 0x21, 0xe9, 0x6c, 0x27, 0x33, 0x19, 0xfd, 0x60, 0xec, 0xc4, 0x6b, 0x59, 0x62, 0xf6, 0x98, 0xe9, 0x74, 0xb4, 0x29, 0xf2, 0x8f, 0xe6, 0x96, 0x2f, 0x4a, 0xc6, 0x56, 0xbe, 0x2e, 0xb8, 0x67, 0x4c, 0x4a, 0xaf, 0xc0, 0x37, 0xea, 0xb4, 0x8e, 0xce, 0x61, 0x29, 0x53, 0xb1, 0xe8, 0xd8, 0x61, 0x01, 0x6b, 0x6a, 0xd0, 0xc7, 0x98, 0x05, 0x78, 0x4c, 0x67, 0xf7, 0x3a, 0xda, 0x96, 0xf3, 0x51,
};
static const ecdh_test_case ecccdh_SECP521R1_5_test_case = {
	.name = "ECCCDH/SECP521R1 5",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_5_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_5_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_5_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_5_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_5_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_5_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_5_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_5_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_6
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_6_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x01, 0xe4, 0x8f, 0xaa, 0xce, 0xe6, 0xde, 0xc8, 0x3f, 0xfc, 0xde, 0x94, 0x4c, 0xf6, 0xbd, 0xf4, 0xce, 0x4b, 0xae, 0x72, 0x74, 0x78, 0x88, 0xeb, 0xaf, 0xee, 0x45, 0x5b, 0x1e, 0x91, 0x58, 0x49, 0x71, 0xef, 0xb4, 0x91, 0x27, 0x97, 0x6a, 0x52, 0xf4, 0x14, 0x29, 0x52, 0xf7, 0xc2, 0x07, 0xec, 0x02, 0x65, 0xf2, 0xb7, 0x18, 0xcf, 0x3e, 0xad, 0x96, 0xea, 0x4f, 0x62, 0xc7, 0x52, 0xe4, 0xf7, 0xac, 0xd3,
};
static const u8 ecccdh_SECP521R1_6_test_vector_peer_pub_key[] = {
	0x01, 0x25, 0x88, 0x11, 0x5e, 0x6f, 0x7f, 0x7b, 0xdc, 0xfd, 0xf5, 0x7f, 0x03, 0xb1, 0x69, 0xb4, 0x79, 0x75, 0x8b, 0xaa, 0xfd, 0xaf, 0x56, 0x9d, 0x04, 0x13, 0x59, 0x87, 0xb2, 0xce, 0x61, 0x64, 0xc0, 0x2a, 0x57, 0x68, 0x5e, 0xb5, 0x27, 0x6b, 0x5d, 0xae, 0x62, 0x95, 0xd3, 0xfe, 0x90, 0x62, 0x0f, 0x38, 0xb5, 0x53, 0x5c, 0x6d, 0x22, 0x60, 0xc1, 0x73, 0xe6, 0x1e, 0xb8, 0x88, 0xca, 0x92, 0x02, 0x03, 0x01, 0x54, 0x2c, 0x16, 0x9c, 0xf9, 0x7c, 0x25, 0x96, 0xfe, 0x2d, 0xdd, 0x84, 0x8a, 0x22, 0x2e, 0x36, 0x7c, 0x5f, 0x7e, 0x62, 0x67, 0xeb, 0xc1, 0xbc, 0xd9, 0xab, 0x5d, 0xcf, 0x49, 0x15, 0x8f, 0x1a, 0x48, 0xe4, 0xaf, 0x29, 0xa8, 0x97, 0xb7, 0xe6, 0xa8, 0x20, 0x91, 0xc2, 0xdb, 0x87, 0x4d, 0x8e, 0x7a, 0xbf, 0x0f, 0x58, 0x06, 0x46, 0x91, 0x34, 0x41, 0x54, 0xf3, 0x96, 0xdb, 0xae, 0xd1, 0x88, 0xb6,
};
static const u8 ecccdh_SECP521R1_6_test_vector_our_pub_key[] = {
	0x01, 0x0e, 0xb1, 0xb4, 0xd9, 0x17, 0x2b, 0xcc, 0x23, 0xf4, 0xf2, 0x0c, 0xc9, 0x56, 0x0f, 0xc5, 0x49, 0x28, 0xc3, 0xf3, 0x4e, 0xa6, 0x1c, 0x00, 0x39, 0x1d, 0xc7, 0x66, 0xc7, 0x6e, 0xd9, 0xfa, 0x60, 0x84, 0x49, 0x37, 0x7d, 0x1e, 0x4f, 0xad, 0xd1, 0x23, 0x60, 0x25, 0x41, 0x73, 0x30, 0xb4, 0xb9, 0x10, 0x86, 0x70, 0x4a, 0xce, 0x3e, 0x4e, 0x64, 0x84, 0xc6, 0x06, 0xe2, 0xa9, 0x43, 0x47, 0x8c, 0x86, 0x01, 0x49, 0x41, 0x38, 0x64, 0x06, 0x98, 0x25, 0xee, 0x1d, 0x08, 0x28, 0xda, 0x9f, 0x4a, 0x97, 0x71, 0x30, 0x05, 0xe9, 0xbd, 0x1a, 0xdb, 0xc3, 0xb3, 0x8c, 0x5b, 0x94, 0x69, 0x00, 0x72, 0x1a, 0x96, 0x0f, 0xe9, 0x6a, 0xd2, 0xc1, 0xb3, 0xa4, 0x4f, 0xe3, 0xde, 0x91, 0x56, 0x13, 0x6d, 0x44, 0xcb, 0x17, 0xcb, 0xc2, 0x41, 0x57, 0x29, 0xbb, 0x78, 0x2e, 0x16, 0xbf, 0xe2, 0xde, 0xb3, 0x06, 0x9e, 0x43,
};
static const u8 ecccdh_SECP521R1_6_test_vector_shared_secret[] = {
	0x01, 0x73, 0x6d, 0x97, 0x17, 0x42, 0x9b, 0x4f, 0x41, 0x2e, 0x90, 0x3f, 0xeb, 0xe2, 0xf9, 0xe0, 0xff, 0xfd, 0x81, 0x35, 0x5d, 0x6c, 0xe2, 0xc0, 0x6f, 0xf3, 0xf6, 0x6a, 0x3b, 0xe1, 0x5c, 0xee, 0xc6, 0xe6, 0x5e, 0x30, 0x83, 0x47, 0x59, 0x3f, 0x00, 0xd7, 0xf3, 0x35, 0x91, 0xda, 0x40, 0x43, 0xc3, 0x07, 0x63, 0xd7, 0x27, 0x49, 0xf7, 0x2c, 0xdc, 0xee, 0xbe, 0x82, 0x5e, 0x4b, 0x34, 0xec, 0xd5, 0x70,
};
static const ecdh_test_case ecccdh_SECP521R1_6_test_case = {
	.name = "ECCCDH/SECP521R1 6",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_6_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_6_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_6_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_6_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_6_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_6_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_6_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_6_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_7
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_7_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x00, 0xc2, 0x9a, 0xa2, 0x23, 0xea, 0x8d, 0x64, 0xb4, 0xa1, 0xed, 0xa2, 0x7f, 0x39, 0xd3, 0xbc, 0x98, 0xea, 0x01, 0x48, 0xdd, 0x98, 0xc1, 0xcb, 0xe5, 0x95, 0xf8, 0xfd, 0x2b, 0xfb, 0xde, 0x11, 0x9c, 0x9e, 0x01, 0x7a, 0x50, 0xf5, 0xd1, 0xfc, 0x12, 0x1c, 0x08, 0xc1, 0xce, 0xf3, 0x1b, 0x75, 0x88, 0x59, 0x55, 0x6e, 0xb3, 0xe0, 0xe0, 0x42, 0xd8, 0xdd, 0x6a, 0xaa, 0xc5, 0x7a, 0x05, 0xca, 0x61, 0xe3,
};
static const u8 ecccdh_SECP521R1_7_test_vector_peer_pub_key[] = {
	0x01, 0x69, 0x49, 0x1d, 0x55, 0xbd, 0x09, 0x04, 0x9f, 0xdf, 0x4c, 0x2a, 0x53, 0xa6, 0x60, 0x48, 0x0f, 0xee, 0x4c, 0x03, 0xa0, 0x53, 0x86, 0x75, 0xd1, 0xcd, 0x09, 0xb5, 0xbb, 0xa7, 0x8d, 0xac, 0x48, 0x54, 0x3e, 0xf1, 0x18, 0xa1, 0x17, 0x3b, 0x3f, 0xbf, 0x8b, 0x20, 0xe3, 0x9c, 0xe0, 0xe6, 0xb8, 0x90, 0xa1, 0x63, 0xc5, 0x0f, 0x96, 0x45, 0xb3, 0xd2, 0x1d, 0x1c, 0xbb, 0x3b, 0x60, 0xa6, 0xff, 0xf4, 0x00, 0x83, 0x49, 0x4b, 0x2e, 0xba, 0x76, 0x91, 0x0f, 0xed, 0x33, 0xc7, 0x61, 0x80, 0x45, 0x15, 0x01, 0x1f, 0xab, 0x50, 0xe3, 0xb3, 0x77, 0xab, 0xd8, 0xa8, 0xa0, 0x45, 0xd8, 0x86, 0xd2, 0x23, 0x8d, 0x2c, 0x26, 0x8a, 0xc1, 0xb6, 0xec, 0x88, 0xbd, 0x71, 0xb7, 0xba, 0x78, 0xe2, 0xc3, 0x3c, 0x15, 0x2e, 0x4b, 0xf7, 0xda, 0x5d, 0x56, 0x5e, 0x4a, 0xcb, 0xec, 0xf5, 0xe9, 0x2c, 0x7a, 0xd6, 0x62, 0xbb,
};
static const u8 ecccdh_SECP521R1_7_test_vector_our_pub_key[] = {
	0x00, 0x15, 0x11, 0xc8, 0x48, 0xef, 0x60, 0xd5, 0x41, 0x9a, 0x98, 0xd1, 0x02, 0x04, 0xdb, 0x0f, 0xe5, 0x82, 0x24, 0x12, 0x43, 0x70, 0x06, 0x1b, 0xcf, 0xa4, 0xe9, 0x24, 0x9d, 0x50, 0x61, 0x8c, 0x56, 0xbf, 0x37, 0x22, 0x47, 0x1b, 0x25, 0x9f, 0x38, 0x26, 0x3b, 0xb7, 0xb2, 0x80, 0xd2, 0x3c, 0xaf, 0x2a, 0x1e, 0xe8, 0x73, 0x7f, 0x93, 0x71, 0xcd, 0xb2, 0x73, 0x2c, 0xdc, 0x95, 0x83, 0x69, 0x93, 0x0c, 0x01, 0xd4, 0x61, 0x68, 0x1a, 0xe6, 0xd8, 0xc4, 0x9b, 0x4c, 0x5f, 0x4d, 0x60, 0x16, 0x14, 0x3f, 0xb1, 0xbd, 0x74, 0x91, 0x57, 0x3e, 0x3e, 0xd0, 0xe6, 0xc4, 0x8b, 0x82, 0xe8, 0x21, 0x64, 0x4f, 0x87, 0xf8, 0x2f, 0x0e, 0x5f, 0x08, 0xfd, 0x16, 0xf1, 0xf9, 0x8f, 0xa1, 0x75, 0x86, 0x20, 0x0a, 0xb0, 0x2e, 0xd8, 0xc6, 0x27, 0xb3, 0x5c, 0x3f, 0x27, 0x61, 0x7e, 0xc5, 0xfd, 0x92, 0xf4, 0x56, 0x20, 0x3f,
};
static const u8 ecccdh_SECP521R1_7_test_vector_shared_secret[] = {
	0x01, 0x8f, 0x2a, 0xe9, 0x47, 0x6c, 0x77, 0x17, 0x26, 0xa7, 0x77, 0x80, 0x20, 0x8d, 0xed, 0xfe, 0xfa, 0x20, 0x54, 0x88, 0x99, 0x6b, 0x18, 0xfe, 0xcc, 0x50, 0xbf, 0xd4, 0xc1, 0x32, 0x75, 0x3f, 0x57, 0x66, 0xb2, 0xcd, 0x74, 0x4a, 0xfa, 0x99, 0x18, 0x60, 0x6d, 0xe2, 0xe0, 0x16, 0xef, 0xfc, 0x63, 0x62, 0x2e, 0x90, 0x29, 0xe7, 0x6d, 0xc6, 0xe3, 0xf0, 0xc6, 0x9f, 0x7a, 0xec, 0xed, 0x56, 0x5c, 0x2c,
};
static const ecdh_test_case ecccdh_SECP521R1_7_test_case = {
	.name = "ECCCDH/SECP521R1 7",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_7_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_7_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_7_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_7_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_7_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_7_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_7_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_7_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_8
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_8_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x00, 0x28, 0x69, 0x2b, 0xe2, 0xbf, 0x5c, 0x4b, 0x48, 0x93, 0x98, 0x46, 0xfb, 0x3d, 0x5b, 0xce, 0x74, 0x65, 0x4b, 0xb2, 0x64, 0x6e, 0x15, 0xf8, 0x38, 0x9e, 0x23, 0x70, 0x8a, 0x1a, 0xfa, 0xdf, 0x56, 0x15, 0x11, 0xea, 0x0d, 0x99, 0x57, 0xd0, 0xb5, 0x34, 0x53, 0x81, 0x9d, 0x60, 0xfb, 0xa8, 0xf6, 0x5a, 0x18, 0xf7, 0xb2, 0x9d, 0xf0, 0x21, 0xb1, 0xbb, 0x01, 0xcd, 0x16, 0x32, 0x93, 0xac, 0xc3, 0xcc,
};
static const u8 ecccdh_SECP521R1_8_test_vector_peer_pub_key[] = {
	0x00, 0x84, 0x15, 0xf5, 0xbb, 0xd0, 0xee, 0xe3, 0x87, 0xd6, 0xc0, 0x9d, 0x0e, 0xf8, 0xac, 0xaf, 0x29, 0xc6, 0x6d, 0xb4, 0x5d, 0x6b, 0xa1, 0x01, 0x86, 0x0a, 0xe4, 0x5d, 0x3c, 0x60, 0xe1, 0xe0, 0xe3, 0xf7, 0x24, 0x7a, 0x46, 0x26, 0xa6, 0x0f, 0xdd, 0x40, 0x49, 0x65, 0xc3, 0x56, 0x6c, 0x79, 0xf6, 0x44, 0x9e, 0x85, 0x6c, 0xe0, 0xbf, 0x94, 0x61, 0x9f, 0x97, 0xda, 0x8d, 0xa2, 0x4b, 0xd2, 0xcf, 0xb6, 0x00, 0xfd, 0xd7, 0xc5, 0x9c, 0x58, 0xc3, 0x61, 0xbc, 0x50, 0xa7, 0xa5, 0xd0, 0xd3, 0x6f, 0x72, 0x3b, 0x17, 0xc4, 0xf2, 0xad, 0x2b, 0x03, 0xc2, 0x4d, 0x42, 0xdc, 0x50, 0xf7, 0x4a, 0x8c, 0x46, 0x5a, 0x0a, 0xfc, 0x46, 0x83, 0xf1, 0x0f, 0xab, 0x84, 0x65, 0x2d, 0xfe, 0x9e, 0x92, 0x8c, 0x26, 0x26, 0xb5, 0x45, 0x64, 0x53, 0xe1, 0x57, 0x3f, 0xf6, 0x0b, 0xe1, 0x50, 0x74, 0x67, 0xd4, 0x31, 0xfb, 0xb2,
};
static const u8 ecccdh_SECP521R1_8_test_vector_our_pub_key[] = {
	0x01, 0xcf, 0xdc, 0x10, 0xc7, 0x99, 0xf5, 0xc7, 0x9c, 0xb6, 0x93, 0x0a, 0x65, 0xfb, 0xa3, 0x51, 0x74, 0x8e, 0x07, 0x56, 0x79, 0x93, 0xe5, 0xe4, 0x10, 0xef, 0x4c, 0xac, 0xc4, 0xcd, 0x8a, 0x25, 0x78, 0x49, 0x91, 0xeb, 0x46, 0x74, 0xe4, 0x10, 0x50, 0xf9, 0x30, 0xc7, 0x19, 0x0a, 0xc8, 0x12, 0xb9, 0x24, 0x5f, 0x48, 0xa7, 0x97, 0x3b, 0x65, 0x8d, 0xaf, 0x40, 0x88, 0x22, 0xfe, 0x5b, 0x85, 0xf6, 0x68, 0x01, 0x80, 0xd9, 0xdd, 0xfc, 0x9a, 0xf7, 0x7b, 0x9c, 0x4a, 0x6f, 0x02, 0xa8, 0x34, 0xdb, 0x15, 0xe5, 0x35, 0xe0, 0xb3, 0x84, 0x5b, 0x2c, 0xce, 0x30, 0x38, 0x83, 0x01, 0xb5, 0x1c, 0xec, 0xbe, 0x32, 0x76, 0x30, 0x7e, 0xf4, 0x39, 0xb5, 0xc9, 0xe6, 0xa7, 0x2d, 0xc2, 0xd9, 0x4d, 0x87, 0x9b, 0xc3, 0x95, 0x05, 0x2d, 0xbb, 0x4a, 0x57, 0x87, 0xd0, 0x6e, 0xfb, 0x28, 0x02, 0x10, 0xfb, 0x8b, 0xe0, 0x37,
};
static const u8 ecccdh_SECP521R1_8_test_vector_shared_secret[] = {
	0x01, 0x05, 0xa3, 0x46, 0x98, 0x8b, 0x92, 0xed, 0x8c, 0x7a, 0x25, 0xce, 0x4d, 0x79, 0xd2, 0x1b, 0xc8, 0x6c, 0xfc, 0xc7, 0xf9, 0x9c, 0x6c, 0xd1, 0x9d, 0xbb, 0x4a, 0x39, 0xf4, 0x8a, 0xb9, 0x43, 0xb7, 0x9e, 0x4f, 0x06, 0x47, 0x34, 0x8d, 0xa0, 0xb8, 0x0b, 0xd8, 0x64, 0xb8, 0x5c, 0x6b, 0x8d, 0x92, 0x53, 0x6d, 0x6a, 0xa5, 0x44, 0xdc, 0x75, 0x37, 0xa0, 0x0c, 0x85, 0x8f, 0x8b, 0x66, 0x31, 0x9e, 0x25,
};
static const ecdh_test_case ecccdh_SECP521R1_8_test_case = {
	.name = "ECCCDH/SECP521R1 8",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_8_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_8_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_8_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_8_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_8_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_8_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_8_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_8_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_9
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_9_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x01, 0x19, 0x4d, 0x1e, 0xe6, 0x13, 0xf5, 0x36, 0x6c, 0xbc, 0x44, 0xb5, 0x04, 0xd2, 0x1a, 0x0c, 0xf6, 0x71, 0x5e, 0x20, 0x9c, 0xd3, 0x58, 0xf2, 0xdd, 0x5f, 0x3e, 0x71, 0xcc, 0x0d, 0x67, 0xd0, 0xe9, 0x64, 0x16, 0x8c, 0x42, 0xa0, 0x84, 0xeb, 0xda, 0x74, 0x6f, 0x98, 0x63, 0xa8, 0x6b, 0xac, 0xff, 0xc8, 0x19, 0xf1, 0xed, 0xf1, 0xb8, 0xc7, 0x27, 0xcc, 0xfb, 0x30, 0x47, 0x24, 0x0a, 0x57, 0xc4, 0x35,
};
static const u8 ecccdh_SECP521R1_9_test_vector_peer_pub_key[] = {
	0x01, 0xc7, 0x21, 0xee, 0xa8, 0x05, 0xa5, 0xcb, 0xa2, 0x9f, 0x34, 0xba, 0x57, 0x58, 0x77, 0x5b, 0xe0, 0xcf, 0x61, 0x60, 0xe6, 0xc0, 0x87, 0x23, 0xf5, 0xab, 0x17, 0xbf, 0x96, 0xa1, 0xff, 0x2b, 0xd9, 0x42, 0x79, 0x61, 0xa4, 0xf3, 0x4b, 0x07, 0xfc, 0x0b, 0x14, 0xca, 0x4b, 0x2b, 0xf6, 0x84, 0x5d, 0xeb, 0xd5, 0xa8, 0x69, 0xf1, 0x24, 0xeb, 0xfa, 0x7a, 0xa7, 0x2f, 0xe5, 0x65, 0x05, 0x0b, 0x7f, 0x18, 0x00, 0xb6, 0xe8, 0x9e, 0xb0, 0xe1, 0xdc, 0xf1, 0x81, 0x23, 0x6f, 0x7c, 0x54, 0x8f, 0xd1, 0xa8, 0xc1, 0x6b, 0x25, 0x8b, 0x52, 0xc1, 0xa9, 0xbf, 0xd3, 0xfe, 0x8f, 0x22, 0x84, 0x1b, 0x26, 0x76, 0x32, 0x65, 0xf0, 0x74, 0xc4, 0xcc, 0xf2, 0xd6, 0x34, 0xae, 0x97, 0xb7, 0x01, 0x95, 0x6f, 0x67, 0xa1, 0x10, 0x06, 0xc5, 0x2d, 0x97, 0x19, 0x7d, 0x92, 0xf5, 0x85, 0xf5, 0x74, 0x8b, 0xc2, 0x67, 0x2e, 0xeb,
};
static const u8 ecccdh_SECP521R1_9_test_vector_our_pub_key[] = {
	0x01, 0x6b, 0xd1, 0x5c, 0x8a, 0x58, 0xd3, 0x66, 0xf7, 0xf2, 0xb2, 0xf2, 0x98, 0xcc, 0x87, 0xb7, 0x48, 0x5e, 0x9e, 0xe7, 0x0d, 0x11, 0xd1, 0x24, 0x48, 0xb8, 0x37, 0x7c, 0x0a, 0x82, 0xc7, 0x62, 0x6f, 0x67, 0xaf, 0xf7, 0xf9, 0x7b, 0xe7, 0xa3, 0x54, 0x6b, 0xf4, 0x17, 0xee, 0xed, 0xdf, 0x75, 0xa9, 0x3c, 0x13, 0x01, 0x91, 0xc8, 0x41, 0x08, 0x04, 0x2e, 0xa2, 0xfc, 0xa1, 0x7f, 0xd3, 0xf8, 0x0d, 0x14, 0x01, 0x56, 0x05, 0x02, 0xd0, 0x4b, 0x74, 0xfc, 0xe1, 0x74, 0x3a, 0xab, 0x47, 0x7a, 0x9d, 0x1e, 0xac, 0x93, 0xe5, 0x22, 0x69, 0x81, 0xfd, 0xb9, 0x7a, 0x74, 0x78, 0xce, 0x4c, 0xe5, 0x66, 0xff, 0x72, 0x43, 0x93, 0x12, 0x84, 0xfa, 0xd8, 0x50, 0xb0, 0xc2, 0xbc, 0xae, 0x0d, 0xdd, 0x2d, 0x97, 0x79, 0x01, 0x60, 0xc1, 0xa2, 0xe7, 0x7c, 0x3e, 0xd6, 0xc9, 0x5e, 0xcc, 0x44, 0xb8, 0x9e, 0x26, 0x37, 0xfc,
};
static const u8 ecccdh_SECP521R1_9_test_vector_shared_secret[] = {
	0x00, 0x45, 0x31, 0xb3, 0xd2, 0xc6, 0xcd, 0x12, 0xf2, 0x16, 0x04, 0xc8, 0x61, 0x0e, 0x67, 0x23, 0xdb, 0xf4, 0xda, 0xf8, 0x0b, 0x5a, 0x45, 0x9d, 0x6b, 0xa5, 0x81, 0x43, 0x97, 0xd1, 0xc1, 0xf7, 0xa2, 0x1d, 0x7c, 0x11, 0x4b, 0xe9, 0x64, 0xe2, 0x73, 0x76, 0xaa, 0xeb, 0xe3, 0xa7, 0xbc, 0x3d, 0x6a, 0xf7, 0xa7, 0xf8, 0xc7, 0xbe, 0xfb, 0x61, 0x1a, 0xfe, 0x48, 0x7f, 0xf0, 0x32, 0x92, 0x1f, 0x75, 0x0f,
};
static const ecdh_test_case ecccdh_SECP521R1_9_test_case = {
	.name = "ECCCDH/SECP521R1 9",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_9_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_9_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_9_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_9_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_9_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_9_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_9_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_9_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_10
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_10_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x01, 0xfd, 0x90, 0xe3, 0xe4, 0x16, 0xe9, 0x8a, 0xa3, 0xf2, 0xb6, 0xaf, 0xa7, 0xf3, 0xbf, 0x36, 0x8e, 0x45, 0x1a, 0xd9, 0xca, 0x5b, 0xd5, 0x4b, 0x5b, 0x14, 0xae, 0xe2, 0xed, 0x67, 0x23, 0xdd, 0xe5, 0x18, 0x1f, 0x50, 0x85, 0xb6, 0x81, 0x69, 0xb0, 0x9f, 0xbe, 0xc7, 0x21, 0x37, 0x2c, 0xcf, 0x6b, 0x28, 0x47, 0x13, 0xf9, 0xa6, 0x35, 0x6b, 0x8d, 0x56, 0x0a, 0x8f, 0xf7, 0x8c, 0xa3, 0x73, 0x7c, 0x88,
};
static const u8 ecccdh_SECP521R1_10_test_vector_peer_pub_key[] = {
	0x01, 0xc3, 0x58, 0x23, 0xe4, 0x40, 0xa9, 0x36, 0x3a, 0xb9, 0x8d, 0x9f, 0xc7, 0xa7, 0xbc, 0x0c, 0x05, 0x32, 0xdc, 0x79, 0x77, 0xa7, 0x91, 0x65, 0x59, 0x9b, 0xf1, 0xa9, 0xcc, 0x64, 0xc0, 0x0f, 0xb3, 0x87, 0xb4, 0x2c, 0xca, 0x36, 0x52, 0x86, 0xe8, 0x43, 0x03, 0x60, 0xbf, 0xad, 0x36, 0x43, 0xbc, 0x31, 0x35, 0x4e, 0xda, 0x50, 0xdc, 0x93, 0x6c, 0x32, 0x9e, 0xcd, 0xb6, 0x09, 0x05, 0xc4, 0x0f, 0xcb, 0x00, 0xd9, 0xe7, 0xf4, 0x33, 0x53, 0x1e, 0x44, 0xdf, 0x4f, 0x6d, 0x51, 0x42, 0x01, 0xcb, 0xaa, 0xbb, 0x06, 0xba, 0xdd, 0x67, 0x83, 0xe0, 0x11, 0x11, 0x72, 0x6d, 0x81, 0x55, 0x31, 0xd2, 0x33, 0xc5, 0xcd, 0xb7, 0x22, 0x89, 0x3f, 0xfb, 0xb2, 0x02, 0x72, 0x59, 0xd5, 0x94, 0xde, 0x77, 0x43, 0x88, 0x09, 0x73, 0x81, 0x20, 0xc6, 0xf7, 0x83, 0x93, 0x4f, 0x92, 0x6c, 0x3f, 0xb6, 0x9b, 0x40, 0xc4, 0x09,
};
static const u8 ecccdh_SECP521R1_10_test_vector_our_pub_key[] = {
	0x01, 0xeb, 0xea, 0x1b, 0x10, 0xd3, 0xe3, 0xb9, 0x71, 0xb7, 0xef, 0xb6, 0x9f, 0xc8, 0x78, 0xde, 0x11, 0xc7, 0xf4, 0x72, 0xe4, 0xe4, 0xd3, 0x84, 0xc3, 0x1b, 0x8d, 0x62, 0x88, 0xd8, 0x07, 0x15, 0x17, 0xac, 0xad, 0xe9, 0xb3, 0x97, 0x96, 0xc7, 0xaf, 0x51, 0x63, 0xbc, 0xf7, 0x1a, 0xed, 0xa7, 0x77, 0x53, 0x3f, 0x38, 0x2c, 0x6c, 0xf0, 0xa4, 0xd9, 0xbb, 0xb9, 0x38, 0xc8, 0x5f, 0x44, 0xb7, 0x80, 0x37, 0x01, 0x6b, 0x0e, 0x3e, 0x19, 0xc2, 0x99, 0x6b, 0x2c, 0xbd, 0x1f, 0xf6, 0x47, 0x30, 0xe7, 0xca, 0x90, 0xed, 0xca, 0x19, 0x84, 0xf9, 0xb2, 0x95, 0x13, 0x33, 0x53, 0x5e, 0x57, 0x48, 0xba, 0xa3, 0x4a, 0x99, 0xf6, 0x1f, 0xf4, 0xd5, 0xf8, 0x12, 0x07, 0x9e, 0x0f, 0x01, 0xe8, 0x77, 0x89, 0xf3, 0x4e, 0xfd, 0xad, 0x80, 0x98, 0x01, 0x5e, 0xe7, 0x4a, 0x4f, 0x84, 0x6d, 0xd1, 0x90, 0xd1, 0x6d, 0xc6, 0xe1,
};
static const u8 ecccdh_SECP521R1_10_test_vector_shared_secret[] = {
	0x01, 0x00, 0xc8, 0x93, 0x59, 0x69, 0x07, 0x7b, 0xae, 0x0b, 0xa8, 0x9e, 0xf0, 0xdf, 0x81, 0x61, 0xd9, 0x75, 0xec, 0x58, 0x70, 0xac, 0x81, 0x1a, 0xe7, 0xe6, 0x5c, 0xa5, 0x39, 0x4e, 0xfb, 0xa4, 0xf0, 0x63, 0x3d, 0x41, 0xbf, 0x79, 0xea, 0x5e, 0x5b, 0x94, 0x96, 0xbb, 0xd7, 0xaa, 0xe0, 0x00, 0xb0, 0x59, 0x4b, 0xaa, 0x82, 0xef, 0x8f, 0x24, 0x4e, 0x69, 0x84, 0xae, 0x87, 0xae, 0x1e, 0xd1, 0x24, 0xb7,
};
static const ecdh_test_case ecccdh_SECP521R1_10_test_case = {
	.name = "ECCCDH/SECP521R1 10",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_10_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_10_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_10_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_10_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_10_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_10_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_10_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_10_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_11
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_11_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x00, 0x90, 0x12, 0xec, 0xfd, 0xad, 0xc8, 0x5c, 0xed, 0x63, 0x0a, 0xfe, 0xa5, 0x34, 0xcd, 0xc8, 0xe9, 0xd1, 0xab, 0x8b, 0xe5, 0xf3, 0x75, 0x3d, 0xcf, 0x5f, 0x2b, 0x09, 0xb4, 0x0e, 0xda, 0x66, 0xfc, 0x68, 0x58, 0x54, 0x9b, 0xc3, 0x6e, 0x6f, 0x8d, 0xf5, 0x59, 0x98, 0xcf, 0xa9, 0xa0, 0x70, 0x3a, 0xec, 0xf6, 0xc4, 0x27, 0x99, 0xc2, 0x45, 0x01, 0x10, 0x64, 0xf5, 0x30, 0xc0, 0x9d, 0xb9, 0x83, 0x69,
};
static const u8 ecccdh_SECP521R1_11_test_vector_peer_pub_key[] = {
	0x00, 0x09, 0x30, 0x57, 0xfb, 0x86, 0x2f, 0x2a, 0xd2, 0xe8, 0x2e, 0x58, 0x1b, 0xae, 0xb3, 0x32, 0x4e, 0x7b, 0x32, 0x94, 0x6f, 0x2b, 0xa8, 0x45, 0xa9, 0xbe, 0xee, 0xd8, 0x7d, 0x69, 0x95, 0xf5, 0x49, 0x18, 0xec, 0x66, 0x19, 0xb9, 0x93, 0x19, 0x55, 0xd5, 0xa8, 0x9d, 0x4d, 0x74, 0xad, 0xf1, 0x04, 0x6b, 0xb3, 0x62, 0x19, 0x2f, 0x2e, 0xf6, 0xbd, 0x3e, 0x3d, 0x2d, 0x04, 0xdd, 0x1f, 0x87, 0x05, 0x4a, 0x00, 0xaa, 0x3f, 0xb2, 0x44, 0x83, 0x35, 0xf6, 0x94, 0xe3, 0xcd, 0xa4, 0xae, 0x0c, 0xc7, 0x1b, 0x1b, 0x2f, 0x2a, 0x20, 0x6f, 0xa8, 0x02, 0xd7, 0x26, 0x2f, 0x19, 0x98, 0x3c, 0x44, 0x67, 0x4f, 0xe1, 0x53, 0x27, 0xac, 0xaa, 0xc1, 0xfa, 0x40, 0x42, 0x4c, 0x39, 0x5a, 0x65, 0x56, 0xcb, 0x81, 0x67, 0x31, 0x25, 0x27, 0xfa, 0xe5, 0x86, 0x5e, 0xcf, 0xfc, 0x14, 0xbb, 0xdc, 0x17, 0xda, 0x78, 0xcd, 0xcf,
};
static const u8 ecccdh_SECP521R1_11_test_vector_our_pub_key[] = {
	0x00, 0x23, 0x4e, 0x32, 0xbe, 0x0a, 0x90, 0x71, 0x31, 0xd2, 0xd1, 0x28, 0xa6, 0x47, 0x7e, 0x0c, 0xac, 0xeb, 0x86, 0xf0, 0x24, 0x79, 0x74, 0x5e, 0x0f, 0xe2, 0x45, 0xcb, 0x33, 0x2d, 0xe6, 0x31, 0xc0, 0x78, 0x87, 0x11, 0x60, 0x48, 0x2e, 0xee, 0xf5, 0x84, 0xe2, 0x74, 0xdf, 0x7f, 0xa4, 0x12, 0xce, 0xa3, 0xe1, 0xe9, 0x1f, 0x71, 0xec, 0xba, 0x87, 0x81, 0xd9, 0x20, 0x5d, 0x48, 0x38, 0x63, 0x41, 0xad, 0x01, 0xcf, 0x86, 0x45, 0x5b, 0x09, 0xb1, 0xc0, 0x05, 0xcf, 0xfb, 0xa8, 0xd7, 0x62, 0x89, 0xa3, 0x75, 0x96, 0x28, 0xc8, 0x74, 0xbe, 0xea, 0x46, 0x2f, 0x51, 0xf3, 0x0b, 0xd5, 0x81, 0xe3, 0x80, 0x31, 0x34, 0x30, 0x7d, 0xed, 0xbb, 0x77, 0x1b, 0x33, 0x34, 0xee, 0x15, 0xbe, 0x2e, 0x24, 0x2c, 0xd7, 0x9c, 0x34, 0x07, 0xd2, 0xf5, 0x89, 0x35, 0x45, 0x6c, 0x69, 0x41, 0xdd, 0x9b, 0x6d, 0x15, 0x5a, 0x46,
};
static const u8 ecccdh_SECP521R1_11_test_vector_shared_secret[] = {
	0x01, 0x7f, 0x36, 0xaf, 0x19, 0x30, 0x38, 0x41, 0xd1, 0x3a, 0x38, 0x9d, 0x95, 0xec, 0x0b, 0x80, 0x1c, 0x7f, 0x9a, 0x67, 0x9a, 0x82, 0x31, 0x46, 0xc7, 0x5c, 0x17, 0xbc, 0x44, 0x25, 0x6e, 0x9a, 0xd4, 0x22, 0xa4, 0xf8, 0xb3, 0x1f, 0x14, 0x64, 0x7b, 0x2c, 0x7d, 0x31, 0x7b, 0x93, 0x3f, 0x7c, 0x29, 0x46, 0xc4, 0xb8, 0xab, 0xd1, 0xd5, 0x6d, 0x62, 0x0f, 0xab, 0x1b, 0x5f, 0xf1, 0xa3, 0xad, 0xc7, 0x1f,
};
static const ecdh_test_case ecccdh_SECP521R1_11_test_case = {
	.name = "ECCCDH/SECP521R1 11",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_11_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_11_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_11_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_11_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_11_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_11_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_11_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_11_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_12
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_12_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x01, 0xb5, 0xff, 0x84, 0x7f, 0x8e, 0xff, 0x20, 0xb8, 0x8c, 0xfa, 0xd4, 0x2c, 0x06, 0xe5, 0x8c, 0x37, 0x42, 0xf2, 0xf8, 0xf1, 0xfd, 0xfd, 0x64, 0xb5, 0x39, 0xba, 0x48, 0xc2, 0x59, 0x26, 0x92, 0x6b, 0xd5, 0xe3, 0x32, 0xb4, 0x56, 0x49, 0xc0, 0xb1, 0x84, 0xf7, 0x72, 0x55, 0xe9, 0xd5, 0x8f, 0xe8, 0xaf, 0xa1, 0xa6, 0xd9, 0x68, 0xe2, 0xcb, 0x1d, 0x46, 0x37, 0x77, 0x71, 0x20, 0xc7, 0x65, 0xc1, 0x28,
};
static const u8 ecccdh_SECP521R1_12_test_vector_peer_pub_key[] = {
	0x00, 0x83, 0x19, 0x2e, 0xd0, 0xb1, 0xcb, 0x31, 0xf7, 0x58, 0x17, 0x79, 0x49, 0x37, 0xf6, 0x6a, 0xd9, 0x1c, 0xf7, 0x45, 0x52, 0xcd, 0x51, 0x0c, 0xed, 0xb9, 0xfd, 0x64, 0x13, 0x10, 0x42, 0x2a, 0xf5, 0xd0, 0x9f, 0x22, 0x1c, 0xad, 0x24, 0x9e, 0xe8, 0x14, 0xd1, 0x6d, 0xd7, 0xac, 0x84, 0xde, 0xd9, 0xea, 0xcd, 0xc2, 0x83, 0x40, 0xfc, 0xfc, 0x9c, 0x0c, 0x06, 0xab, 0xe3, 0x0a, 0x2f, 0xc2, 0x8c, 0xd8, 0x00, 0x22, 0x12, 0xed, 0x86, 0x8c, 0x9b, 0xa0, 0xfb, 0x2c, 0x91, 0xe2, 0xc3, 0x9b, 0xa9, 0x39, 0x96, 0xa3, 0xe4, 0xeb, 0xf4, 0x5f, 0x28, 0x52, 0xd0, 0x92, 0x8c, 0x48, 0x93, 0x0e, 0x87, 0x5c, 0xc7, 0xb4, 0x28, 0xd0, 0xe7, 0xf3, 0xf4, 0xd5, 0x03, 0xe5, 0xd6, 0x0c, 0x68, 0xcb, 0x49, 0xb1, 0x3c, 0x24, 0x80, 0xcd, 0x48, 0x6b, 0xed, 0x92, 0x00, 0xca, 0xdd, 0xad, 0xdf, 0xe4, 0xff, 0x8e, 0x35, 0x62,
};
static const u8 ecccdh_SECP521R1_12_test_vector_our_pub_key[] = {
	0x01, 0xde, 0x3d, 0xc9, 0x26, 0x3b, 0xc8, 0xc4, 0x96, 0x9d, 0xc6, 0x84, 0xbe, 0x0e, 0xec, 0x54, 0xbe, 0xfd, 0x9a, 0x9f, 0x3d, 0xba, 0x19, 0x4d, 0x86, 0x58, 0xa7, 0x89, 0x34, 0x1b, 0xf0, 0xd7, 0x8d, 0x84, 0xda, 0x67, 0x35, 0x22, 0x7c, 0xaf, 0xaf, 0x09, 0x35, 0x19, 0x51, 0x69, 0x11, 0x97, 0x57, 0x3c, 0x8c, 0x36, 0x0a, 0x11, 0xe5, 0x28, 0x57, 0x12, 0xb8, 0xbb, 0xdf, 0x5a, 0xc9, 0x1b, 0x97, 0x7c, 0x00, 0x81, 0x2d, 0xe5, 0x8c, 0xd0, 0x95, 0xec, 0x2e, 0x5a, 0x9b, 0x24, 0x7e, 0xb3, 0xed, 0x41, 0xd8, 0xbe, 0xf6, 0xae, 0xac, 0xe1, 0x94, 0xa7, 0xa0, 0x5b, 0x65, 0xaa, 0x5d, 0x28, 0x9f, 0xbc, 0x9b, 0x17, 0x70, 0xec, 0x84, 0xbb, 0x6b, 0xe0, 0xc2, 0xc6, 0x4c, 0xc3, 0x7c, 0x1d, 0x54, 0xa7, 0xf5, 0xd7, 0x13, 0x77, 0xa9, 0xad, 0xbe, 0x20, 0xf2, 0x6f, 0x6f, 0x2b, 0x54, 0x4a, 0x82, 0x1e, 0xa8, 0x31,
};
static const u8 ecccdh_SECP521R1_12_test_vector_shared_secret[] = {
	0x00, 0x06, 0x2f, 0x9f, 0xc2, 0x9a, 0xe1, 0xa6, 0x8b, 0x2e, 0xe0, 0xdc, 0xf9, 0x56, 0xcb, 0xd3, 0x8c, 0x88, 0xae, 0x5f, 0x64, 0x5e, 0xaa, 0x54, 0x6b, 0x00, 0xeb, 0xe8, 0x7a, 0x72, 0x60, 0xbf, 0x72, 0x4b, 0xe2, 0x0d, 0x34, 0xb9, 0xd0, 0x20, 0x76, 0x65, 0x5c, 0x93, 0x3d, 0x05, 0x6b, 0x21, 0xe3, 0x04, 0xc2, 0x4d, 0xdb, 0x1d, 0xed, 0xf1, 0xdd, 0x76, 0xde, 0x61, 0x1f, 0xc4, 0xa2, 0x34, 0x03, 0x36,
};
static const ecdh_test_case ecccdh_SECP521R1_12_test_case = {
	.name = "ECCCDH/SECP521R1 12",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_12_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_12_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_12_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_12_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_12_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_12_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_12_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_12_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_13
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_13_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x01, 0x1a, 0x63, 0x47, 0xd4, 0xe8, 0x01, 0xc9, 0x19, 0x23, 0x48, 0x83, 0x54, 0xcc, 0x53, 0x3e, 0x7e, 0x35, 0xfd, 0xdf, 0x81, 0xff, 0x0f, 0xb7, 0xf5, 0x6b, 0xb0, 0x72, 0x6e, 0x0c, 0x29, 0xee, 0x5d, 0xcd, 0xc5, 0xf3, 0x94, 0xba, 0x54, 0xcf, 0x57, 0x26, 0x90, 0x48, 0xaa, 0xb6, 0xe0, 0x55, 0x89, 0x5c, 0x8d, 0xa2, 0x4b, 0x8b, 0x06, 0x39, 0xa7, 0x42, 0x31, 0x43, 0x90, 0xcc, 0x04, 0x19, 0x0e, 0xd6,
};
static const u8 ecccdh_SECP521R1_13_test_vector_peer_pub_key[] = {
	0x01, 0xa8, 0x9b, 0x63, 0x6a, 0x93, 0xe5, 0xd2, 0xba, 0x6c, 0x22, 0x92, 0xbf, 0x23, 0x03, 0x3a, 0x84, 0xf0, 0x6a, 0x3a, 0xc1, 0x22, 0x0e, 0xa7, 0x1e, 0x80, 0x6a, 0xfb, 0xe0, 0x97, 0xa8, 0x04, 0xcc, 0x67, 0xe9, 0xba, 0xa5, 0x14, 0xcf, 0xb6, 0xc1, 0x2c, 0x91, 0x94, 0xbe, 0x30, 0x21, 0x2b, 0xf7, 0xaa, 0xe7, 0xfd, 0xf6, 0xd3, 0x76, 0xc2, 0x12, 0xf0, 0x55, 0x4e, 0x65, 0x64, 0x63, 0xff, 0xab, 0x7e, 0x01, 0x82, 0xef, 0xca, 0xf7, 0x0f, 0xc4, 0x12, 0xd3, 0x36, 0x60, 0x2e, 0x01, 0x4d, 0xa4, 0x72, 0x56, 0xa0, 0xb6, 0x06, 0xf2, 0xad, 0xdc, 0xce, 0x80, 0x53, 0xbf, 0x81, 0x7a, 0xc8, 0x65, 0x6b, 0xb4, 0xe4, 0x2f, 0x14, 0xc8, 0xcb, 0xf2, 0xa6, 0x8f, 0x48, 0x8a, 0xb3, 0x5d, 0xcd, 0xf6, 0x40, 0x56, 0x27, 0x1d, 0xee, 0x1f, 0x60, 0x6a, 0x44, 0x0b, 0xa4, 0xbd, 0x4e, 0x5a, 0x11, 0xb8, 0xb8, 0xe5, 0x4f,
};
static const u8 ecccdh_SECP521R1_13_test_vector_our_pub_key[] = {
	0x00, 0xfe, 0x30, 0x26, 0x7f, 0x33, 0xba, 0x5c, 0xde, 0xfc, 0x25, 0xcb, 0xb3, 0xc9, 0x32, 0x0d, 0xad, 0x9c, 0xcb, 0x1d, 0x7d, 0x37, 0x66, 0x44, 0x62, 0x0c, 0xa4, 0xfa, 0xde, 0xe5, 0x62, 0x6a, 0x3c, 0xed, 0xe2, 0x5a, 0xd2, 0x54, 0x62, 0x4d, 0xef, 0x72, 0x7a, 0x70, 0x48, 0xf7, 0x14, 0x5f, 0x76, 0x16, 0x2a, 0xa9, 0x80, 0x42, 0xf9, 0xb1, 0x23, 0xb2, 0x07, 0x6f, 0x8e, 0x8c, 0xf5, 0x9b, 0x3f, 0xdf, 0x00, 0x11, 0x45, 0xdc, 0x66, 0x31, 0x95, 0x3b, 0x6e, 0x29, 0x45, 0xe9, 0x43, 0x01, 0xd6, 0xcb, 0xb0, 0x98, 0xfe, 0x4b, 0x04, 0xf7, 0xee, 0x9b, 0x09, 0x41, 0x1d, 0xf1, 0x04, 0xdc, 0x82, 0xd7, 0xd7, 0x9e, 0xc4, 0x6a, 0x01, 0xed, 0x0f, 0x2d, 0x3e, 0x7d, 0xb6, 0xeb, 0x68, 0x06, 0x94, 0xbd, 0xeb, 0x10, 0x7c, 0x10, 0x78, 0xae, 0xc6, 0xca, 0xbd, 0x9e, 0xbe, 0xe3, 0xd3, 0x42, 0xfe, 0x7e, 0x54, 0xdf,
};
static const u8 ecccdh_SECP521R1_13_test_vector_shared_secret[] = {
	0x01, 0x28, 0xab, 0x09, 0xbf, 0xec, 0x54, 0x06, 0x79, 0x9e, 0x61, 0x0f, 0x77, 0x2b, 0xa1, 0x7e, 0x89, 0x22, 0x49, 0xfa, 0x8e, 0x0e, 0x7b, 0x18, 0xa0, 0x4b, 0x91, 0x97, 0x03, 0x4b, 0x25, 0x0b, 0x48, 0x29, 0x4f, 0x18, 0x67, 0xfb, 0x96, 0x41, 0x51, 0x8f, 0x92, 0x76, 0x60, 0x66, 0xa0, 0x7a, 0x8b, 0x91, 0x7b, 0x0e, 0x76, 0x87, 0x9e, 0x10, 0x11, 0xe5, 0x1c, 0xcb, 0xd9, 0xf5, 0x40, 0xc5, 0x4d, 0x4f,
};
static const ecdh_test_case ecccdh_SECP521R1_13_test_case = {
	.name = "ECCCDH/SECP521R1 13",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_13_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_13_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_13_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_13_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_13_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_13_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_13_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_13_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_14
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_14_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x00, 0x22, 0xb6, 0xd2, 0xa2, 0x2d, 0x71, 0xdf, 0xaa, 0x81, 0x1d, 0x2d, 0x9f, 0x9f, 0x31, 0xfb, 0xed, 0x27, 0xf2, 0xe1, 0xf3, 0xd2, 0x39, 0x53, 0x8d, 0xdf, 0x3e, 0x4c, 0xc8, 0xc3, 0x9a, 0x33, 0x02, 0x66, 0xdb, 0x25, 0xb7, 0xbc, 0x0a, 0x97, 0x04, 0xf1, 0x7b, 0xde, 0x7f, 0x35, 0x92, 0xbf, 0x5f, 0x1f, 0x2d, 0x4b, 0x56, 0x01, 0x3a, 0xac, 0xc3, 0xd8, 0xd1, 0xbc, 0x02, 0xf0, 0x0d, 0x31, 0x46, 0xcc,
};
static const u8 ecccdh_SECP521R1_14_test_vector_peer_pub_key[] = {
	0x01, 0x72, 0x00, 0xb3, 0xf1, 0x6a, 0x68, 0xcb, 0xae, 0xd2, 0xbf, 0x78, 0xba, 0x8c, 0xdd, 0xfb, 0x6c, 0xff, 0xac, 0x26, 0x2b, 0xba, 0x00, 0xfb, 0xc2, 0x5f, 0x9d, 0xc7, 0x2a, 0x07, 0xce, 0x59, 0x37, 0x29, 0x04, 0x89, 0x9f, 0x36, 0x4c, 0x44, 0xcb, 0x26, 0x4c, 0x09, 0x7b, 0x64, 0x7d, 0x44, 0x12, 0xbe, 0xe3, 0xe5, 0x19, 0x89, 0x2d, 0x53, 0x4d, 0x91, 0x29, 0xf8, 0xa2, 0x8f, 0x75, 0x00, 0xfe, 0xe7, 0x00, 0xba, 0xba, 0x8d, 0x67, 0x2a, 0x4f, 0x4a, 0x3b, 0x63, 0xde, 0x48, 0xb9, 0x6f, 0x56, 0xe1, 0x8d, 0xf5, 0xd6, 0x8f, 0x7d, 0x70, 0xd5, 0x10, 0x98, 0x33, 0xf4, 0x37, 0x70, 0xd6, 0x73, 0x2e, 0x06, 0xb3, 0x9a, 0xd6, 0x0d, 0x93, 0xe5, 0xb4, 0x3d, 0xb8, 0x78, 0x9f, 0x1e, 0xc0, 0xab, 0xa4, 0x72, 0x86, 0xa3, 0x9e, 0xa5, 0x84, 0x23, 0x5a, 0xce, 0xa7, 0x57, 0xdb, 0xf1, 0x3d, 0x53, 0xb5, 0x83, 0x64,
};
static const u8 ecccdh_SECP521R1_14_test_vector_our_pub_key[] = {
	0x00, 0xba, 0x38, 0xcf, 0xbf, 0x9f, 0xd2, 0x51, 0x8a, 0x3f, 0x61, 0xd4, 0x35, 0x49, 0xe7, 0xa6, 0xa6, 0xd2, 0x8b, 0x2b, 0xe5, 0x7f, 0xfd, 0x3e, 0x0f, 0xac, 0xeb, 0x63, 0x6b, 0x34, 0xed, 0x17, 0xe0, 0x44, 0xa9, 0xf2, 0x49, 0xda, 0xe8, 0xfc, 0x13, 0x2e, 0x93, 0x7e, 0x2d, 0x93, 0x49, 0xcd, 0x2e, 0xd7, 0x7b, 0xb1, 0x04, 0x9c, 0xeb, 0x69, 0x2a, 0x2e, 0xc5, 0xb1, 0x7a, 0xd6, 0x15, 0x02, 0xa6, 0x4c, 0x00, 0x1e, 0xc9, 0x1d, 0x30, 0x58, 0x57, 0x3f, 0xa6, 0xc0, 0x56, 0x4a, 0x02, 0xa1, 0xa0, 0x10, 0x16, 0x0c, 0x31, 0x3b, 0xc7, 0xc7, 0x35, 0x10, 0xdc, 0x98, 0x3e, 0x54, 0x61, 0x68, 0x2b, 0x5b, 0xe0, 0x0d, 0xbc, 0xe7, 0xe2, 0xc6, 0x82, 0xad, 0x73, 0xf2, 0x9c, 0xa8, 0x22, 0xcd, 0xc1, 0x11, 0xf6, 0x8f, 0xab, 0xe3, 0x3a, 0x7b, 0x38, 0x4a, 0x64, 0x83, 0x42, 0xc3, 0xcd, 0xb9, 0xf0, 0x50, 0xbc, 0xdb,
};
static const u8 ecccdh_SECP521R1_14_test_vector_shared_secret[] = {
	0x01, 0x01, 0xe4, 0x62, 0xe9, 0xd9, 0x15, 0x99, 0x68, 0xf6, 0x44, 0x0e, 0x95, 0x6f, 0x11, 0xdc, 0xf2, 0x22, 0x7a, 0xe4, 0xae, 0xa8, 0x16, 0x67, 0x12, 0x2b, 0x6a, 0xf9, 0x23, 0x9a, 0x29, 0x1e, 0xb5, 0xd6, 0xcf, 0x5a, 0x40, 0x87, 0xf3, 0x58, 0x52, 0x5f, 0xca, 0xcf, 0xa4, 0x6b, 0xb2, 0xdb, 0x01, 0xa7, 0x5a, 0xf1, 0xba, 0x51, 0x9b, 0x2d, 0x31, 0xda, 0x33, 0xed, 0xa8, 0x7a, 0x9d, 0x56, 0x57, 0x48,
};
static const ecdh_test_case ecccdh_SECP521R1_14_test_case = {
	.name = "ECCCDH/SECP521R1 14",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_14_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_14_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_14_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_14_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_14_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_14_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_14_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_14_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_15
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_15_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x00, 0x5b, 0xac, 0xff, 0xf2, 0x68, 0xac, 0xf6, 0x55, 0x3c, 0x3c, 0x58, 0x3b, 0x46, 0x4e, 0xa3, 0x6a, 0x1d, 0x35, 0xe2, 0xb2, 0x57, 0xa5, 0xd4, 0x9e, 0xb3, 0x41, 0x9d, 0x5a, 0x09, 0x50, 0x87, 0xc2, 0xfb, 0x4d, 0x15, 0xcf, 0x5b, 0xf5, 0xaf, 0x81, 0x6d, 0x0f, 0x3f, 0xf7, 0x58, 0x64, 0x90, 0xcc, 0xd3, 0xdd, 0xc1, 0xa9, 0x8b, 0x39, 0xce, 0x63, 0x74, 0x9c, 0x62, 0x88, 0xce, 0x0d, 0xbd, 0xac, 0x7d,
};
static const u8 ecccdh_SECP521R1_15_test_vector_peer_pub_key[] = {
	0x00, 0x4e, 0xfd, 0x5d, 0xbd, 0x2f, 0x97, 0x9e, 0x38, 0x31, 0xce, 0x98, 0xf8, 0x23, 0x55, 0xd6, 0xca, 0x14, 0xa5, 0x75, 0x78, 0x42, 0x87, 0x58, 0x82, 0x99, 0x0a, 0xb8, 0x5a, 0xb9, 0xb7, 0x35, 0x2d, 0xd6, 0xb9, 0xb2, 0xf4, 0xea, 0x9a, 0x1e, 0x95, 0xc3, 0x88, 0x0d, 0x65, 0xd1, 0xf3, 0x60, 0x2f, 0x9c, 0xa6, 0x53, 0xdc, 0x34, 0x6f, 0xac, 0x85, 0x86, 0x58, 0xd7, 0x56, 0x26, 0xf4, 0xd4, 0xfb, 0x08, 0x00, 0x61, 0xcf, 0x15, 0xdb, 0xda, 0xa7, 0xf3, 0x15, 0x89, 0xc9, 0x84, 0x00, 0x37, 0x3d, 0xa2, 0x84, 0x50, 0x6d, 0x70, 0xc8, 0x9f, 0x07, 0x4e, 0xd2, 0x62, 0xa9, 0xe2, 0x81, 0x40, 0x79, 0x6b, 0x72, 0x36, 0xc2, 0xee, 0xf9, 0x90, 0x16, 0x08, 0x5e, 0x71, 0x55, 0x2f, 0xf4, 0x88, 0xc7, 0x2b, 0x73, 0x39, 0xfe, 0xfb, 0x79, 0x15, 0xc3, 0x84, 0x59, 0xcb, 0x20, 0xab, 0x85, 0xae, 0xc4, 0xe4, 0x50, 0x52,
};
static const u8 ecccdh_SECP521R1_15_test_vector_our_pub_key[] = {
	0x00, 0x36, 0xe4, 0x88, 0xda, 0x75, 0x81, 0x47, 0x2a, 0x9d, 0x8e, 0x62, 0x8c, 0x58, 0xd6, 0xad, 0x72, 0x73, 0x11, 0xb7, 0xe6, 0xa3, 0xf6, 0xae, 0x33, 0xa8, 0x54, 0x4f, 0x34, 0xb0, 0x92, 0x80, 0x24, 0x90, 0x20, 0xbe, 0x71, 0x96, 0x91, 0x6f, 0xaf, 0xd9, 0x0e, 0x2e, 0xc5, 0x4b, 0x66, 0xb5, 0x46, 0x8d, 0x23, 0x61, 0xb9, 0x9b, 0x56, 0xfa, 0x00, 0xd7, 0xac, 0x37, 0xab, 0xb8, 0xc6, 0xf1, 0x66, 0x53, 0x01, 0x1e, 0xdb, 0x9f, 0xb8, 0xad, 0xb6, 0xa4, 0x3f, 0x4f, 0x5f, 0x5f, 0xdc, 0x14, 0x21, 0xc9, 0xfe, 0x04, 0xfc, 0x8b, 0xa4, 0x6c, 0x9b, 0x66, 0x33, 0x4e, 0x3a, 0xf9, 0x27, 0xc8, 0xbe, 0xfb, 0x43, 0x07, 0x10, 0x4f, 0x29, 0x9a, 0xce, 0xc4, 0xe3, 0x0f, 0x81, 0x2d, 0x93, 0x45, 0xc9, 0x72, 0x0d, 0x19, 0x86, 0x9d, 0xbf, 0xff, 0xd4, 0xca, 0x3e, 0x7d, 0x27, 0x13, 0xeb, 0x5f, 0xc3, 0xf4, 0x26, 0x15,
};
static const u8 ecccdh_SECP521R1_15_test_vector_shared_secret[] = {
	0x01, 0x41, 0xd6, 0xa4, 0xb7, 0x19, 0xab, 0x67, 0xea, 0xf0, 0x4a, 0x92, 0xc0, 0xa4, 0x1e, 0x2d, 0xda, 0x78, 0xf4, 0x35, 0x4f, 0xb9, 0x0b, 0xdc, 0x35, 0x20, 0x2c, 0xc7, 0x69, 0x9b, 0x9b, 0x04, 0xd4, 0x96, 0x16, 0xf8, 0x22, 0x55, 0xde, 0xbf, 0x7b, 0xbe, 0xc0, 0x45, 0xae, 0x58, 0xf9, 0x82, 0xa6, 0x69, 0x05, 0xfc, 0xfa, 0xe6, 0x9d, 0x68, 0x97, 0x85, 0xe3, 0x8c, 0x86, 0x8e, 0xb4, 0xa2, 0x7e, 0x7b,
};
static const ecdh_test_case ecccdh_SECP521R1_15_test_case = {
	.name = "ECCCDH/SECP521R1 15",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_15_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_15_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_15_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_15_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_15_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_15_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_15_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_15_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_16
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_16_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x00, 0x8e, 0x2c, 0x93, 0xc5, 0x42, 0x38, 0x76, 0x22, 0x3a, 0x63, 0x7c, 0xad, 0x36, 0x7c, 0x85, 0x89, 0xda, 0x69, 0xa2, 0xd0, 0xfc, 0x68, 0x61, 0x2f, 0x31, 0x92, 0x3a, 0xe5, 0x02, 0x19, 0xdf, 0x24, 0x52, 0xe7, 0xcc, 0x92, 0x61, 0x5b, 0x67, 0xf1, 0x7b, 0x57, 0xff, 0xd2, 0xf5, 0x2b, 0x19, 0x15, 0x4b, 0xb4, 0x0d, 0x77, 0x15, 0x33, 0x64, 0x20, 0xfd, 0xe2, 0xe8, 0x9f, 0xee, 0x24, 0x4f, 0x59, 0xdc,
};
static const u8 ecccdh_SECP521R1_16_test_vector_peer_pub_key[] = {
	0x01, 0x29, 0x89, 0x1d, 0xe0, 0xcf, 0x3c, 0xf8, 0x2e, 0x8c, 0x2c, 0xf1, 0xbf, 0x90, 0xbb, 0x29, 0x6f, 0xe0, 0x0a, 0xb0, 0x8c, 0xa4, 0x5b, 0xb7, 0x89, 0x2e, 0x0e, 0x22, 0x7a, 0x50, 0x4f, 0xdd, 0x05, 0xd2, 0x38, 0x1a, 0x44, 0x48, 0xb6, 0x8a, 0xdf, 0xf9, 0xc4, 0x15, 0x3c, 0x87, 0xea, 0xcb, 0x78, 0x33, 0x0d, 0x8b, 0xd5, 0x25, 0x15, 0xf9, 0xf9, 0xa0, 0xb5, 0x8e, 0x85, 0xf4, 0x46, 0xbb, 0x4e, 0x10, 0x00, 0x9e, 0xdd, 0x67, 0x96, 0x96, 0xd3, 0xd1, 0xd0, 0xef, 0x32, 0x7f, 0x20, 0x03, 0x83, 0x25, 0x3f, 0x64, 0x13, 0x68, 0x3d, 0x9e, 0x4f, 0xcc, 0x87, 0xbb, 0x35, 0xf1, 0x12, 0xc2, 0xf1, 0x10, 0x09, 0x8d, 0x15, 0xe5, 0x70, 0x1d, 0x7c, 0xee, 0xe4, 0x16, 0x29, 0x1f, 0xf5, 0xfe, 0xd8, 0x5e, 0x68, 0x7f, 0x72, 0x73, 0x88, 0xb9, 0xaf, 0xe2, 0x6a, 0x4f, 0x6f, 0xee, 0xd5, 0x60, 0xb2, 0x18, 0xe6, 0xbb,
};
static const u8 ecccdh_SECP521R1_16_test_vector_our_pub_key[] = {
	0x00, 0xfa, 0x3b, 0x35, 0x11, 0x8d, 0x6c, 0x42, 0x25, 0x70, 0xf7, 0x24, 0xa2, 0x6f, 0x90, 0xb2, 0x83, 0x3b, 0x19, 0x23, 0x91, 0x74, 0xce, 0xa0, 0x81, 0xc5, 0x31, 0x33, 0xf6, 0x4d, 0xb6, 0x0d, 0x69, 0x40, 0xea, 0x12, 0x61, 0x29, 0x9c, 0x04, 0xc1, 0xf4, 0x58, 0x7c, 0xdb, 0x0c, 0x4c, 0x39, 0x61, 0x64, 0x79, 0xc1, 0xbb, 0x0c, 0x14, 0x67, 0x99, 0xa1, 0x18, 0x03, 0x2d, 0xcf, 0x98, 0xf8, 0x99, 0xc0, 0x00, 0x69, 0xf0, 0x40, 0x22, 0x90, 0x06, 0x15, 0x1f, 0xa3, 0x2b, 0x51, 0xf6, 0x79, 0xc8, 0x81, 0x6f, 0x7c, 0x17, 0x50, 0x6b, 0x40, 0x38, 0x09, 0xdc, 0x77, 0xcd, 0x58, 0xa2, 0xae, 0xc4, 0x30, 0xd9, 0x4d, 0x13, 0xb6, 0xc9, 0x16, 0xde, 0x99, 0xf3, 0x55, 0xaa, 0x45, 0xfc, 0xfb, 0xc6, 0x85, 0x3d, 0x68, 0x6c, 0x71, 0xbe, 0x49, 0x6a, 0x06, 0x7d, 0x24, 0xbf, 0xae, 0xa4, 0x81, 0x8f, 0xc5, 0x1f, 0x75,
};
static const u8 ecccdh_SECP521R1_16_test_vector_shared_secret[] = {
	0x00, 0x34, 0x5e, 0x26, 0xe0, 0xab, 0xb1, 0xaa, 0xc1, 0x2b, 0x75, 0xf3, 0xa9, 0xcf, 0x41, 0xef, 0xe1, 0xc3, 0x36, 0x39, 0x6d, 0xff, 0xa4, 0xa0, 0x67, 0xa4, 0xc2, 0xcf, 0xeb, 0x87, 0x8c, 0x68, 0xb2, 0xb0, 0x45, 0xfa, 0xa4, 0xe5, 0xb4, 0xe6, 0xfa, 0x46, 0x78, 0xf5, 0xb6, 0x03, 0xc3, 0x51, 0x90, 0x3b, 0x14, 0xbf, 0x9a, 0x6a, 0x70, 0xc4, 0x39, 0x25, 0x71, 0x99, 0xa6, 0x40, 0x89, 0x0b, 0x61, 0xd1,
};
static const ecdh_test_case ecccdh_SECP521R1_16_test_case = {
	.name = "ECCCDH/SECP521R1 16",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_16_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_16_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_16_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_16_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_16_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_16_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_16_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_16_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_17
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_17_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x00, 0x04, 0xd4, 0x9d, 0x39, 0xd4, 0x0d, 0x81, 0x11, 0xbf, 0x16, 0xd2, 0x8c, 0x59, 0x36, 0x55, 0x43, 0x26, 0xb1, 0x97, 0x35, 0x3e, 0xeb, 0xbc, 0xf4, 0x75, 0x45, 0x39, 0x3b, 0xc8, 0xd3, 0xaa, 0xf9, 0x8f, 0x14, 0xf5, 0xbe, 0x70, 0x74, 0xbf, 0xb3, 0x8e, 0x6c, 0xc9, 0x7b, 0x98, 0x97, 0x54, 0x07, 0x4d, 0xad, 0xdb, 0x30, 0x45, 0xf4, 0xe4, 0xce, 0x74, 0x56, 0x69, 0xfd, 0xb3, 0xec, 0x0d, 0x5f, 0xa8,
};
static const u8 ecccdh_SECP521R1_17_test_vector_peer_pub_key[] = {
	0x01, 0xa3, 0xc2, 0x02, 0x40, 0xe5, 0x9f, 0x5b, 0x7a, 0x3e, 0x17, 0xc2, 0x75, 0xd2, 0x31, 0x4b, 0xa1, 0x74, 0x12, 0x10, 0xad, 0x58, 0xb7, 0x10, 0x36, 0xf8, 0xc8, 0x3c, 0xc1, 0xf6, 0xb0, 0xf4, 0x09, 0xdf, 0xdd, 0x91, 0x13, 0xe9, 0x4b, 0x67, 0xec, 0x39, 0xc3, 0x29, 0x14, 0x26, 0xc2, 0x3f, 0xfc, 0xc4, 0x47, 0x05, 0x46, 0x70, 0xd2, 0x90, 0x8f, 0xf8, 0xfe, 0x67, 0xdc, 0x23, 0x06, 0x03, 0x4c, 0x5c, 0x01, 0xd2, 0x82, 0x5b, 0xfd, 0x3a, 0xf8, 0xb1, 0xe1, 0x32, 0x05, 0x78, 0x0c, 0x13, 0x7f, 0xe9, 0x38, 0xf8, 0x4f, 0xde, 0x40, 0x18, 0x8e, 0x61, 0xea, 0x02, 0xce, 0xad, 0x81, 0xba, 0xdf, 0xdb, 0x42, 0x5c, 0x29, 0xf7, 0xd7, 0xfb, 0x03, 0x24, 0xde, 0xba, 0xdc, 0x10, 0xbb, 0xb9, 0x3d, 0xe6, 0x8f, 0x62, 0xc3, 0x50, 0x69, 0x26, 0x82, 0x83, 0xf5, 0x26, 0x58, 0x65, 0xdb, 0x57, 0xa7, 0x9f, 0x7b, 0xf7,
};
static const u8 ecccdh_SECP521R1_17_test_vector_our_pub_key[] = {
	0x01, 0x2e, 0xc2, 0x26, 0xd0, 0x50, 0xce, 0x07, 0xc7, 0x9b, 0x3d, 0xf4, 0xd0, 0xf0, 0x89, 0x1f, 0x9f, 0x7a, 0xdf, 0x46, 0x2e, 0x8c, 0x98, 0xdb, 0xc1, 0xa2, 0xa1, 0x4f, 0x5e, 0x53, 0xa3, 0xf5, 0xad, 0x89, 0x44, 0x33, 0x58, 0x7c, 0xc4, 0x29, 0xa8, 0xbe, 0x9e, 0xa1, 0xd8, 0x4f, 0xa3, 0x3b, 0x18, 0x03, 0x69, 0x0d, 0xae, 0x04, 0xda, 0x72, 0x18, 0xd3, 0x00, 0x26, 0x15, 0x7f, 0xc9, 0x95, 0xcf, 0x52, 0x00, 0x48, 0x37, 0xdf, 0xbf, 0x34, 0x26, 0xf5, 0x7b, 0x5c, 0x79, 0x32, 0x69, 0x13, 0x0a, 0xbb, 0x9a, 0x38, 0xf6, 0x18, 0x53, 0x22, 0x11, 0x93, 0x11, 0x54, 0xdb, 0x4e, 0xeb, 0x9a, 0xed, 0xe8, 0x8e, 0x57, 0x29, 0x0f, 0x84, 0x2e, 0xa0, 0xf2, 0xea, 0x9a, 0x5f, 0x74, 0xc6, 0x20, 0x3a, 0x39, 0x20, 0xfe, 0x4e, 0x30, 0x5f, 0x61, 0x18, 0xf6, 0x76, 0xb1, 0x54, 0xe1, 0xd7, 0x5b, 0x9c, 0xb5, 0xeb, 0x88,
};
static const u8 ecccdh_SECP521R1_17_test_vector_shared_secret[] = {
	0x00, 0x6f, 0xe9, 0xde, 0x6f, 0xb8, 0xe6, 0x72, 0xe7, 0xfd, 0x15, 0x0f, 0xdc, 0x5e, 0x61, 0x7f, 0xab, 0xb0, 0xd4, 0x39, 0x06, 0x35, 0x4c, 0xcf, 0xd2, 0x24, 0x75, 0x7c, 0x72, 0x76, 0xf7, 0xa1, 0x01, 0x00, 0x91, 0xb1, 0x7e, 0xd0, 0x72, 0x07, 0x4f, 0x8d, 0x10, 0xa5, 0xec, 0x97, 0x1e, 0xb3, 0x5a, 0x5c, 0xb7, 0x07, 0x66, 0x03, 0xb7, 0xbc, 0x38, 0xd4, 0x32, 0xcb, 0xc0, 0x59, 0xf8, 0x0f, 0x94, 0x88,
};
static const ecdh_test_case ecccdh_SECP521R1_17_test_case = {
	.name = "ECCCDH/SECP521R1 17",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_17_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_17_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_17_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_17_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_17_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_17_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_17_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_17_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_18
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_18_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x01, 0x1a, 0x5d, 0x1c, 0xc7, 0x9c, 0xd2, 0xbf, 0x73, 0xea, 0x10, 0x6f, 0x0e, 0x60, 0xa5, 0xac, 0xe2, 0x20, 0x81, 0x3b, 0x53, 0xe2, 0x7b, 0x73, 0x98, 0x64, 0x33, 0x4a, 0x07, 0xc0, 0x33, 0x67, 0xef, 0xda, 0x7a, 0x46, 0x19, 0xfa, 0x6e, 0xef, 0x3a, 0x97, 0x46, 0x49, 0x22, 0x83, 0xb3, 0xc4, 0x45, 0x61, 0x0a, 0x02, 0x3a, 0x9c, 0xc4, 0x9b, 0xf4, 0x59, 0x11, 0x40, 0x38, 0x4f, 0xca, 0x5c, 0x8b, 0xb5,
};
static const u8 ecccdh_SECP521R1_18_test_vector_peer_pub_key[] = {
	0x00, 0x7e, 0x2d, 0x13, 0x8f, 0x28, 0x32, 0xe3, 0x45, 0xae, 0x8f, 0xf6, 0x59, 0x57, 0xe4, 0x0e, 0x5e, 0xc7, 0x16, 0x3f, 0x01, 0x6b, 0xdf, 0x6d, 0x24, 0xa2, 0x24, 0x3d, 0xaa, 0x63, 0x1d, 0x87, 0x8a, 0x4a, 0x16, 0x78, 0x39, 0x90, 0xc7, 0x22, 0x38, 0x21, 0x30, 0xf9, 0xe5, 0x1f, 0x0c, 0x1b, 0xd6, 0xff, 0x5a, 0xc9, 0x67, 0x80, 0xe4, 0x8b, 0x68, 0xf5, 0xde, 0xc9, 0x5f, 0x42, 0xe6, 0x14, 0x4b, 0xb5, 0x00, 0xb0, 0xde, 0x5c, 0x89, 0x67, 0x91, 0xf5, 0x28, 0x86, 0xb0, 0xf0, 0x99, 0x13, 0xe2, 0x6e, 0x78, 0xdd, 0x0b, 0x69, 0x79, 0x8f, 0xc4, 0xdf, 0x6d, 0x95, 0xe3, 0xca, 0x70, 0x8e, 0xcb, 0xcb, 0xcc, 0xe1, 0xc1, 0x89, 0x5f, 0x55, 0x61, 0xbb, 0xab, 0xaa, 0xe3, 0x72, 0xe9, 0xe6, 0x7e, 0x6e, 0x1a, 0x3b, 0xe6, 0x0e, 0x19, 0xb4, 0x70, 0xcd, 0xf6, 0x73, 0xec, 0x1f, 0xc3, 0x93, 0xd3, 0x42, 0x6e, 0x20,
};
static const u8 ecccdh_SECP521R1_18_test_vector_our_pub_key[] = {
	0x00, 0xeb, 0x07, 0xc7, 0x33, 0x2e, 0xed, 0xb7, 0xd3, 0x03, 0x60, 0x59, 0xd3, 0x5f, 0x7d, 0x22, 0x88, 0xd4, 0x37, 0x7d, 0x5f, 0x42, 0x33, 0x7a, 0xd3, 0x96, 0x40, 0x79, 0xfb, 0x12, 0x0c, 0xcd, 0x4c, 0x8b, 0xd3, 0x84, 0xb5, 0x85, 0x62, 0x10, 0x55, 0x21, 0x70, 0x23, 0xac, 0xd9, 0xa9, 0x4f, 0xcb, 0x3b, 0x96, 0x5b, 0xfb, 0x39, 0x46, 0x75, 0xe7, 0x88, 0xad, 0xe4, 0x1a, 0x1d, 0xe7, 0x3e, 0x62, 0x0c, 0x00, 0x49, 0x1a, 0x83, 0x5d, 0xe2, 0xe6, 0xe7, 0xde, 0xb7, 0xe0, 0x90, 0xf4, 0xa1, 0x1f, 0x2c, 0x46, 0x0c, 0x0b, 0x1f, 0x3d, 0x5e, 0x94, 0xee, 0x8d, 0x75, 0x10, 0x14, 0xdc, 0x72, 0x07, 0x84, 0xfd, 0x3b, 0x54, 0x50, 0x0c, 0x86, 0xeb, 0xae, 0xf1, 0x84, 0x29, 0xf0, 0x9e, 0x8e, 0x87, 0x6d, 0x5d, 0x15, 0x38, 0x96, 0x8a, 0x03, 0x0d, 0x77, 0x15, 0xdd, 0xe9, 0x9f, 0x0d, 0x8f, 0x06, 0xe2, 0x9d, 0x59,
};
static const u8 ecccdh_SECP521R1_18_test_vector_shared_secret[] = {
	0x01, 0xe4, 0xe7, 0x59, 0xec, 0xed, 0xce, 0x10, 0x13, 0xba, 0xf7, 0x3e, 0x6f, 0xcc, 0x0b, 0x92, 0x45, 0x1d, 0x03, 0xbd, 0xd5, 0x04, 0x89, 0xb7, 0x88, 0x71, 0xc3, 0x33, 0x11, 0x49, 0x90, 0xc9, 0xba, 0x6a, 0x9b, 0x2f, 0xc7, 0xb1, 0xa2, 0xd9, 0xa1, 0x79, 0x4c, 0x1b, 0x60, 0xd9, 0x27, 0x9a, 0xf6, 0xf1, 0x46, 0xf0, 0xbb, 0xfb, 0x06, 0x83, 0x14, 0x04, 0x03, 0xbf, 0xa4, 0xcc, 0xdb, 0x52, 0x4a, 0x29,
};
static const ecdh_test_case ecccdh_SECP521R1_18_test_case = {
	.name = "ECCCDH/SECP521R1 18",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_18_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_18_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_18_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_18_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_18_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_18_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_18_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_18_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_19
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_19_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x01, 0x0c, 0x90, 0x8c, 0xaf, 0x1b, 0xe7, 0x4c, 0x61, 0x6b, 0x62, 0x5f, 0xc8, 0xc1, 0xf5, 0x14, 0x44, 0x6a, 0x6a, 0xec, 0x83, 0xb5, 0x93, 0x71, 0x41, 0xd6, 0xaf, 0xbb, 0x0a, 0x8c, 0x76, 0x66, 0xa7, 0x74, 0x6f, 0xa1, 0xf7, 0xa6, 0x66, 0x4a, 0x21, 0x23, 0xe8, 0xcd, 0xf6, 0xcd, 0x8b, 0xf8, 0x36, 0xc5, 0x6d, 0x3c, 0x0e, 0xbd, 0xcc, 0x98, 0x0e, 0x43, 0xa1, 0x86, 0xf9, 0x38, 0xf3, 0xa7, 0x8a, 0xe7,
};
static const u8 ecccdh_SECP521R1_19_test_vector_peer_pub_key[] = {
	0x00, 0x11, 0x8c, 0x36, 0x02, 0x22, 0x09, 0xb1, 0xaf, 0x8e, 0xba, 0xd1, 0xa1, 0x2b, 0x56, 0x6f, 0xc4, 0x87, 0x44, 0x57, 0x6e, 0x11, 0x99, 0xfe, 0x80, 0xde, 0x1c, 0xdf, 0x85, 0x1c, 0xdf, 0x03, 0xe5, 0xb9, 0x09, 0x1a, 0x8f, 0x7e, 0x07, 0x9e, 0x83, 0xb7, 0xf8, 0x27, 0x25, 0x9b, 0x69, 0x1d, 0x0c, 0x22, 0xee, 0x29, 0xd6, 0xbd, 0xf7, 0x3e, 0xc7, 0xbb, 0xfd, 0x74, 0x6f, 0x2c, 0xd9, 0x7a, 0x35, 0x7d, 0x00, 0xda, 0x5f, 0xf4, 0x90, 0x45, 0x48, 0xa3, 0x42, 0xe2, 0xe7, 0xba, 0x6a, 0x1f, 0x4e, 0xe5, 0xf8, 0x40, 0x41, 0x1a, 0x96, 0xcf, 0x63, 0xe6, 0xfe, 0x62, 0x2f, 0x22, 0xc1, 0x3e, 0x61, 0x4e, 0x0a, 0x84, 0x7c, 0x11, 0xa1, 0xab, 0x3f, 0x1d, 0x12, 0xcc, 0x85, 0x0c, 0x32, 0xe0, 0x95, 0x61, 0x4c, 0xa8, 0xf7, 0xe2, 0x72, 0x14, 0x77, 0xb4, 0x86, 0xe9, 0xff, 0x40, 0x37, 0x29, 0x77, 0xc3, 0xf6, 0x5c,
};
static const u8 ecccdh_SECP521R1_19_test_vector_our_pub_key[] = {
	0x00, 0x31, 0x89, 0x0f, 0x4c, 0x7a, 0xbe, 0xc3, 0xf7, 0x23, 0x36, 0x22, 0x85, 0xd7, 0x7d, 0x26, 0x36, 0xf8, 0x76, 0x81, 0x7d, 0xb3, 0xbb, 0xc8, 0x8b, 0x01, 0xe7, 0x73, 0x59, 0x7b, 0x96, 0x9f, 0xf6, 0xf0, 0x13, 0xea, 0x47, 0x0c, 0x85, 0x4a, 0xb4, 0xa7, 0x73, 0x90, 0x04, 0xeb, 0x8c, 0xbe, 0xa6, 0x9b, 0x82, 0xdd, 0xf3, 0x6a, 0xca, 0xdd, 0x40, 0x68, 0x71, 0x79, 0x8e, 0xcb, 0x2a, 0xc3, 0xaa, 0x7f, 0x00, 0xd8, 0xb4, 0x29, 0xae, 0x32, 0x50, 0x26, 0x6b, 0x96, 0x43, 0xc0, 0xc7, 0x65, 0xa6, 0x0d, 0xc1, 0x01, 0x55, 0xbc, 0x25, 0x31, 0xcf, 0x86, 0x27, 0x29, 0x6f, 0x49, 0x78, 0xb6, 0x64, 0x0a, 0x9e, 0x60, 0x0e, 0x19, 0xd0, 0x03, 0x7d, 0x58, 0x50, 0x3f, 0xa8, 0x07, 0x99, 0x54, 0x6a, 0x81, 0x4d, 0x74, 0x78, 0xa5, 0x50, 0xaa, 0x90, 0xe5, 0xeb, 0xeb, 0x05, 0x25, 0x27, 0xfa, 0xae, 0xae, 0x5d, 0x08,
};
static const u8 ecccdh_SECP521R1_19_test_vector_shared_secret[] = {
	0x01, 0x63, 0xc9, 0x19, 0x1d, 0x65, 0x10, 0x39, 0xa5, 0xfe, 0x98, 0x5a, 0x0e, 0xea, 0x1e, 0xba, 0x01, 0x8a, 0x40, 0xab, 0x19, 0x37, 0xfc, 0xd2, 0xb6, 0x12, 0x20, 0x82, 0x0e, 0xe8, 0xf2, 0x30, 0x2e, 0x97, 0x99, 0xf6, 0xed, 0xfc, 0x3f, 0x51, 0x74, 0xf3, 0x69, 0xd6, 0x72, 0xd3, 0x77, 0xea, 0x89, 0x54, 0xa8, 0xd0, 0xc8, 0xb8, 0x51, 0xe8, 0x1a, 0x56, 0xfd, 0xa9, 0x52, 0x12, 0xa6, 0x57, 0x8f, 0x0e,
};
static const ecdh_test_case ecccdh_SECP521R1_19_test_case = {
	.name = "ECCCDH/SECP521R1 19",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_19_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_19_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_19_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_19_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_19_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_19_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_19_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_19_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_20
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_20_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x01, 0xb3, 0x7d, 0x6b, 0x72, 0x88, 0xde, 0x67, 0x13, 0x60, 0x42, 0x5d, 0x3e, 0x5a, 0xc1, 0xcc, 0xb2, 0x18, 0x15, 0x07, 0x9d, 0x8d, 0x73, 0x43, 0x1e, 0x9b, 0x74, 0xa6, 0xf0, 0xe7, 0xae, 0x00, 0x4a, 0x35, 0x75, 0x75, 0xb1, 0x1a, 0xd6, 0x66, 0x42, 0xce, 0x8b, 0x77, 0x55, 0x93, 0xeb, 0xa9, 0xd9, 0x8b, 0xf2, 0x5c, 0x75, 0xef, 0x0b, 0x4d, 0x3a, 0x20, 0x98, 0xbb, 0xc6, 0x41, 0xf5, 0x9a, 0x2b, 0x77,
};
static const u8 ecccdh_SECP521R1_20_test_vector_peer_pub_key[] = {
	0x01, 0x78, 0x0e, 0xdf, 0xf1, 0xca, 0x1c, 0x03, 0xcf, 0xbe, 0x59, 0x3e, 0xdc, 0x6c, 0x04, 0x9b, 0xcb, 0x28, 0x60, 0x29, 0x4a, 0x92, 0xc3, 0x55, 0x48, 0x9d, 0x9a, 0xfb, 0x2e, 0x70, 0x20, 0x75, 0xad, 0xe1, 0xc9, 0x53, 0x89, 0x5a, 0x45, 0x62, 0x30, 0xa0, 0xcd, 0xe9, 0x05, 0xde, 0x4a, 0x3f, 0x38, 0x57, 0x3d, 0xbf, 0xcc, 0xcd, 0x67, 0xad, 0x6e, 0x7e, 0x93, 0xf0, 0xb5, 0x58, 0x1e, 0x92, 0x6a, 0x5d, 0x00, 0xa5, 0x48, 0x19, 0x62, 0xc9, 0x16, 0x29, 0x62, 0xe7, 0xf0, 0xeb, 0xde, 0xc9, 0x36, 0x93, 0x5d, 0x0e, 0xaa, 0x81, 0x3e, 0x82, 0x26, 0xd4, 0x0d, 0x7f, 0x61, 0x19, 0xbf, 0xd9, 0x40, 0x60, 0x23, 0x80, 0xc8, 0x67, 0x21, 0xe6, 0x1d, 0xb1, 0x83, 0x0f, 0x51, 0xe1, 0x39, 0xf2, 0x10, 0x00, 0x0b, 0xce, 0xc0, 0xd8, 0xed, 0xd3, 0x9e, 0x54, 0xd7, 0x3a, 0x9a, 0x12, 0x9f, 0x95, 0xcd, 0x5f, 0xa9, 0x79,
};
static const u8 ecccdh_SECP521R1_20_test_vector_our_pub_key[] = {
	0x00, 0x18, 0x9a, 0x5e, 0xe3, 0x4d, 0xe7, 0xe3, 0x5a, 0xef, 0xea, 0xee, 0xf9, 0x22, 0x0c, 0x18, 0x07, 0x1b, 0x4c, 0x29, 0xa4, 0xc3, 0xbd, 0x9d, 0x95, 0x44, 0x58, 0xbd, 0x3e, 0x82, 0xa7, 0xa3, 0x4d, 0xa3, 0x4c, 0xff, 0x55, 0x79, 0xb8, 0x10, 0x1c, 0x06, 0x5b, 0x1f, 0x2f, 0x52, 0x7c, 0xf4, 0x58, 0x15, 0x01, 0xe2, 0x8e, 0xf5, 0x67, 0x18, 0x73, 0xe6, 0x52, 0x67, 0x73, 0x3d, 0x00, 0x35, 0x20, 0xaf, 0x01, 0xeb, 0x4b, 0xc5, 0x0a, 0x7b, 0x4d, 0x45, 0x99, 0xd7, 0xe3, 0xfa, 0x77, 0x3d, 0xdb, 0x9e, 0xb2, 0x52, 0xc9, 0xb3, 0x42, 0x28, 0x72, 0xe5, 0x44, 0xbd, 0xf7, 0x5c, 0x7b, 0xf6, 0x0f, 0x51, 0x66, 0xdd, 0xc1, 0x1e, 0xb0, 0x8f, 0xa7, 0xc3, 0x08, 0x22, 0xda, 0xba, 0xee, 0x37, 0x3a, 0xb4, 0x68, 0xeb, 0x2d, 0x92, 0x2e, 0x48, 0x4e, 0x2a, 0x52, 0x7f, 0xff, 0x2e, 0xbb, 0x80, 0x4b, 0x7d, 0x9a, 0x37,
};
static const u8 ecccdh_SECP521R1_20_test_vector_shared_secret[] = {
	0x01, 0x5d, 0x61, 0x3e, 0x26, 0x7a, 0x36, 0x34, 0x2e, 0x0d, 0x12, 0x5c, 0xda, 0xd6, 0x43, 0xd8, 0x0d, 0x97, 0xed, 0x06, 0x00, 0xaf, 0xb9, 0xe6, 0xb9, 0x54, 0x5c, 0x9e, 0x64, 0xa9, 0x8c, 0xc6, 0xda, 0x7c, 0x5a, 0xaa, 0x3a, 0x8d, 0xa0, 0xbd, 0xd9, 0xdd, 0x3b, 0x97, 0xe9, 0x78, 0x82, 0x18, 0xa8, 0x0a, 0xba, 0xfc, 0x10, 0x6e, 0xf0, 0x65, 0xc8, 0xf1, 0xc4, 0xe1, 0x11, 0x9e, 0xf5, 0x8d, 0x29, 0x8b,
};
static const ecdh_test_case ecccdh_SECP521R1_20_test_case = {
	.name = "ECCCDH/SECP521R1 20",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_20_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_20_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_20_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_20_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_20_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_20_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_20_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_20_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_21
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_21_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x00, 0xf2, 0x66, 0x1a, 0xc7, 0x62, 0xf6, 0x0c, 0x5f, 0xff, 0x23, 0xbe, 0x5d, 0x96, 0x9c, 0xcd, 0x4e, 0xc6, 0xf9, 0x8e, 0x4e, 0x72, 0x61, 0x8d, 0x12, 0xbd, 0xcd, 0xb9, 0xb4, 0x10, 0x21, 0x62, 0x33, 0x37, 0x88, 0xc0, 0xba, 0xe5, 0x9f, 0x91, 0xcd, 0xfc, 0x17, 0x2c, 0x7a, 0x16, 0x81, 0xee, 0x44, 0xd9, 0x6a, 0xb2, 0x13, 0x5a, 0x6e, 0x5f, 0x34, 0x15, 0xeb, 0xbc, 0xd5, 0x51, 0x65, 0xb1, 0xaf, 0xb0,
};
static const u8 ecccdh_SECP521R1_21_test_vector_peer_pub_key[] = {
	0x01, 0x6d, 0xac, 0xff, 0xa1, 0x83, 0xe5, 0x30, 0x30, 0x83, 0xa3, 0x34, 0xf7, 0x65, 0xde, 0x72, 0x4e, 0xc5, 0xec, 0x94, 0x02, 0x02, 0x6d, 0x47, 0x97, 0x88, 0x4a, 0x98, 0x28, 0xa0, 0xd3, 0x21, 0xa8, 0xcf, 0xac, 0x74, 0xab, 0x73, 0x7f, 0xe2, 0x0a, 0x7d, 0x6b, 0xef, 0xcf, 0xc7, 0x3b, 0x6a, 0x35, 0xc1, 0xc7, 0xb0, 0x1d, 0x37, 0x3e, 0x31, 0xab, 0xc1, 0x92, 0xd4, 0x8a, 0x42, 0x41, 0xa3, 0x58, 0x03, 0x01, 0x1e, 0x53, 0x27, 0xca, 0xc2, 0x2d, 0x30, 0x5e, 0x71, 0x56, 0xe5, 0x59, 0x17, 0x6e, 0x19, 0xbe, 0xe7, 0xe4, 0xf2, 0xf5, 0x9e, 0x86, 0xf1, 0xa9, 0xd0, 0xb6, 0x60, 0x3b, 0x6a, 0x7d, 0xf1, 0x06, 0x9b, 0xde, 0x63, 0x87, 0xfe, 0xb7, 0x15, 0x87, 0xb8, 0xff, 0xce, 0x5b, 0x26, 0x6e, 0x1b, 0xae, 0x86, 0xde, 0x29, 0x37, 0x8a, 0x34, 0xe5, 0xc7, 0x4b, 0x67, 0x24, 0xc4, 0xd4, 0x0a, 0x71, 0x99, 0x23,
};
static const u8 ecccdh_SECP521R1_21_test_vector_our_pub_key[] = {
	0x00, 0xa8, 0xe2, 0x5a, 0x69, 0x02, 0xd6, 0x87, 0xb4, 0x78, 0x7c, 0xdc, 0x94, 0xc3, 0x64, 0xac, 0x7c, 0xec, 0xc5, 0xc4, 0x95, 0x48, 0x3e, 0xd3, 0x63, 0xdc, 0x0a, 0xa9, 0x5e, 0xe2, 0xbd, 0x73, 0x9c, 0x4c, 0x4d, 0x46, 0xb1, 0x70, 0x06, 0xc7, 0x28, 0xb0, 0x76, 0x35, 0x0d, 0x7d, 0x7e, 0x54, 0xc6, 0x82, 0x2f, 0x52, 0xf4, 0x71, 0x62, 0xa2, 0x51, 0x09, 0xaa, 0xab, 0xa6, 0x90, 0xca, 0xb6, 0x96, 0xec, 0x01, 0x68, 0xd2, 0xf0, 0x8f, 0xe1, 0x9e, 0x4d, 0xc9, 0xee, 0x7a, 0x19, 0x5b, 0x03, 0xc9, 0xf7, 0xfe, 0x66, 0x76, 0xf9, 0xf5, 0x20, 0xb6, 0x27, 0x05, 0x57, 0x50, 0x4e, 0x72, 0xca, 0x43, 0x94, 0xa2, 0xc6, 0x91, 0x86, 0x25, 0xe1, 0x5a, 0xc0, 0xc5, 0x1b, 0x8f, 0x95, 0xcd, 0x56, 0x01, 0x23, 0x65, 0x3f, 0xb8, 0xe8, 0xee, 0x6d, 0xb9, 0x61, 0xe2, 0xc4, 0xc6, 0x2c, 0xc5, 0x4e, 0x92, 0xe2, 0xa2, 0xa9,
};
static const u8 ecccdh_SECP521R1_21_test_vector_shared_secret[] = {
	0x01, 0x4d, 0x60, 0x82, 0xa3, 0xb5, 0xce, 0xd1, 0xab, 0x8c, 0xa2, 0x65, 0xa8, 0x10, 0x6f, 0x30, 0x21, 0x46, 0xc4, 0xac, 0xb8, 0xc3, 0x0b, 0xb1, 0x4a, 0x4c, 0x99, 0x1e, 0x3c, 0x82, 0xa9, 0x73, 0x12, 0x88, 0xbd, 0xb9, 0x1e, 0x0e, 0x85, 0xbd, 0xa3, 0x13, 0x91, 0x2d, 0x06, 0x38, 0x4f, 0xc4, 0x4f, 0x21, 0x53, 0xfb, 0x13, 0x50, 0x6f, 0xa9, 0xcf, 0x43, 0xc9, 0xaa, 0xb5, 0x75, 0x09, 0x88, 0xc9, 0x43,
};
static const ecdh_test_case ecccdh_SECP521R1_21_test_case = {
	.name = "ECCCDH/SECP521R1 21",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_21_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_21_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_21_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_21_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_21_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_21_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_21_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_21_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_22
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_22_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x00, 0xf4, 0x30, 0xca, 0x12, 0x61, 0xf0, 0x96, 0x81, 0xa9, 0x28, 0x2e, 0x9e, 0x97, 0x0a, 0x92, 0x34, 0x22, 0x7b, 0x1d, 0x5e, 0x58, 0xd5, 0x58, 0xc3, 0xcc, 0x6e, 0xff, 0x44, 0xd1, 0xbd, 0xf5, 0x3d, 0xe1, 0x6a, 0xd5, 0xee, 0x2b, 0x18, 0xb9, 0x2d, 0x62, 0xfc, 0x79, 0x58, 0x61, 0x16, 0xb0, 0xef, 0xc1, 0x5f, 0x79, 0x34, 0x0f, 0xb7, 0xea, 0xf5, 0xce, 0x6c, 0x44, 0x34, 0x1d, 0xcf, 0x8d, 0xde, 0x27,
};
static const u8 ecccdh_SECP521R1_22_test_vector_peer_pub_key[] = {
	0x00, 0xa0, 0x91, 0x42, 0x1d, 0x37, 0x03, 0xe3, 0xb3, 0x41, 0xe9, 0xf1, 0xe7, 0xd5, 0x8f, 0x8c, 0xf7, 0xbd, 0xbd, 0x17, 0x98, 0xd0, 0x01, 0x96, 0x7b, 0x80, 0x1d, 0x1c, 0xec, 0x27, 0xe6, 0x05, 0xc5, 0x80, 0xb2, 0x38, 0x7c, 0x1c, 0xb4, 0x64, 0xf5, 0x5c, 0xe7, 0xac, 0x80, 0x33, 0x41, 0x02, 0xab, 0x03, 0xcf, 0xb8, 0x6d, 0x88, 0xaf, 0x76, 0xc9, 0xf4, 0x12, 0x9c, 0x01, 0xbe, 0xdd, 0x3b, 0xbf, 0xc4, 0x00, 0x8c, 0x9c, 0x57, 0x7a, 0x8e, 0x6f, 0xc4, 0x46, 0x81, 0x5e, 0x9d, 0x40, 0xba, 0xa6, 0x60, 0x25, 0xf1, 0x5d, 0xae, 0x28, 0x5f, 0x19, 0xeb, 0x66, 0x8e, 0xe6, 0x0a, 0xe9, 0xc9, 0x8e, 0x7e, 0xcd, 0xbf, 0x2b, 0x2a, 0x68, 0xe2, 0x29, 0x28, 0x05, 0x9f, 0x67, 0xdb, 0x18, 0x80, 0x07, 0x16, 0x1d, 0x3e, 0xcf, 0x39, 0x7e, 0x08, 0x83, 0xf0, 0xc4, 0xeb, 0x7e, 0xaf, 0x78, 0x27, 0xa6, 0x22, 0x05, 0xcc,
};
static const u8 ecccdh_SECP521R1_22_test_vector_our_pub_key[] = {
	0x00, 0x6c, 0x1d, 0x9b, 0x5e, 0xca, 0x87, 0xde, 0x1f, 0xb8, 0x71, 0xa0, 0xa3, 0x2f, 0x80, 0x7c, 0x72, 0x5a, 0xdc, 0xcd, 0xe9, 0xb3, 0x96, 0x74, 0x53, 0xa7, 0x13, 0x47, 0xd6, 0x08, 0xf0, 0xc0, 0x30, 0xcd, 0x09, 0xe3, 0x38, 0xcd, 0xec, 0xbf, 0x4a, 0x02, 0x01, 0x5b, 0xc8, 0xa6, 0xe8, 0xd3, 0xe2, 0x59, 0x5f, 0xe7, 0x73, 0xff, 0xc2, 0xfc, 0x4e, 0x4a, 0x55, 0xd0, 0xb1, 0xa2, 0xcc, 0x00, 0x32, 0x3b, 0x01, 0x14, 0x1b, 0x21, 0x09, 0xe7, 0xf4, 0x98, 0x1c, 0x95, 0x2a, 0xa8, 0x18, 0xa2, 0xb9, 0xf6, 0xf5, 0xc4, 0x1f, 0xec, 0xcd, 0xb7, 0xa7, 0xa4, 0x5b, 0x9b, 0x4b, 0x67, 0x29, 0x37, 0x77, 0x1b, 0x00, 0x8c, 0xae, 0x5f, 0x93, 0x4d, 0xfe, 0x3f, 0xed, 0x10, 0xd3, 0x83, 0xab, 0x1f, 0x38, 0x76, 0x9c, 0x92, 0xce, 0x88, 0xd9, 0xbe, 0x54, 0x14, 0x81, 0x7e, 0xcb, 0x07, 0x3a, 0x31, 0xab, 0x36, 0x8c, 0xcb,
};
static const u8 ecccdh_SECP521R1_22_test_vector_shared_secret[] = {
	0x00, 0x20, 0xc0, 0x07, 0x47, 0xcb, 0x8d, 0x49, 0x2f, 0xd4, 0x97, 0xe0, 0xfe, 0xc5, 0x46, 0x44, 0xbf, 0x02, 0x7d, 0x41, 0x8a, 0xb6, 0x86, 0x38, 0x1f, 0x10, 0x97, 0x12, 0xa9, 0x9c, 0xab, 0xe3, 0x28, 0xb9, 0x74, 0x3d, 0x22, 0x25, 0x83, 0x6f, 0x9a, 0xd6, 0x6e, 0x5d, 0x7f, 0xed, 0x1d, 0xe2, 0x47, 0xe0, 0xda, 0x92, 0xf6, 0x0d, 0x5b, 0x31, 0xf9, 0xe4, 0x76, 0x72, 0xe5, 0x7f, 0x71, 0x05, 0x98, 0xf4,
};
static const ecdh_test_case ecccdh_SECP521R1_22_test_case = {
	.name = "ECCCDH/SECP521R1 22",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_22_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_22_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_22_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_22_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_22_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_22_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_22_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_22_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_23
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_23_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x00, 0x5d, 0xc3, 0x3a, 0xed, 0xa0, 0x3c, 0x2e, 0xb2, 0x33, 0x01, 0x4e, 0xe4, 0x68, 0xdf, 0xf7, 0x53, 0xb7, 0x2f, 0x73, 0xb0, 0x09, 0x91, 0x04, 0x3e, 0xa3, 0x53, 0x82, 0x8a, 0xe6, 0x9d, 0x4c, 0xd0, 0xfa, 0xde, 0xda, 0x7b, 0xb2, 0x78, 0xb5, 0x35, 0xd7, 0xc5, 0x74, 0x06, 0xff, 0x2e, 0x6e, 0x47, 0x3a, 0x5a, 0x4f, 0xf9, 0x8e, 0x90, 0xf9, 0x0d, 0x6d, 0xad, 0xd2, 0x51, 0x00, 0xe8, 0xd8, 0x56, 0x66,
};
static const u8 ecccdh_SECP521R1_23_test_vector_peer_pub_key[] = {
	0x00, 0x4f, 0x38, 0x81, 0x66, 0x81, 0x77, 0x12, 0x89, 0xce, 0x0c, 0xb8, 0x3a, 0x5e, 0x29, 0xa1, 0xab, 0x06, 0xfc, 0x91, 0xf7, 0x86, 0x99, 0x4b, 0x23, 0x70, 0x8f, 0xf0, 0x8a, 0x08, 0xa0, 0xf6, 0x75, 0xb8, 0x09, 0xae, 0x99, 0xe9, 0xf9, 0x96, 0x7e, 0xb1, 0xa4, 0x9f, 0x19, 0x60, 0x57, 0xd6, 0x9e, 0x50, 0xd6, 0xde, 0xdb, 0x4d, 0xd2, 0xd9, 0xa8, 0x1c, 0x02, 0xbd, 0xcc, 0x8f, 0x7f, 0x51, 0x84, 0x60, 0x00, 0x9e, 0xfb, 0x24, 0x4c, 0x8b, 0x91, 0x08, 0x7d, 0xe1, 0xee, 0xd7, 0x66, 0x50, 0x0f, 0x0e, 0x81, 0x53, 0x07, 0x52, 0xd4, 0x69, 0x25, 0x6e, 0xf7, 0x9f, 0x6b, 0x96, 0x5d, 0x8a, 0x22, 0x32, 0xa0, 0xc2, 0xdb, 0xc4, 0xe8, 0xe1, 0xd0, 0x92, 0x14, 0xba, 0xb3, 0x84, 0x85, 0xbe, 0x6e, 0x35, 0x7c, 0x42, 0x00, 0xd0, 0x73, 0xb5, 0x2f, 0x04, 0xe4, 0xa1, 0x6f, 0xc6, 0xf5, 0x24, 0x71, 0x87, 0xae, 0xcb,
};
static const u8 ecccdh_SECP521R1_23_test_vector_our_pub_key[] = {
	0x00, 0xc8, 0x25, 0xba, 0x30, 0x73, 0x73, 0xce, 0xc8, 0xdd, 0x24, 0x98, 0xee, 0xf8, 0x2e, 0x21, 0xfd, 0x98, 0x62, 0x16, 0x8d, 0xbf, 0xeb, 0x83, 0x59, 0x39, 0x80, 0xca, 0x9f, 0x82, 0x87, 0x53, 0x33, 0x89, 0x9f, 0xe9, 0x4f, 0x13, 0x7d, 0xaf, 0x1c, 0x41, 0x89, 0xeb, 0x50, 0x29, 0x37, 0xc3, 0xa3, 0x67, 0xea, 0x79, 0x51, 0xed, 0x8b, 0x0f, 0x33, 0x77, 0xfc, 0xdf, 0x29, 0x22, 0x02, 0x1d, 0x46, 0xa5, 0x01, 0x6b, 0x8a, 0x25, 0x40, 0xd5, 0xe6, 0x54, 0x93, 0x88, 0x8b, 0xc3, 0x37, 0x24, 0x9e, 0x67, 0xc0, 0xa6, 0x87, 0x74, 0xf3, 0xe8, 0xd8, 0x1e, 0x3b, 0x45, 0x74, 0xa0, 0x12, 0x51, 0x65, 0xf0, 0xbd, 0x58, 0xb8, 0xaf, 0x9d, 0xe7, 0x4b, 0x35, 0x83, 0x25, 0x39, 0xf9, 0x5c, 0x3c, 0xd9, 0xf1, 0xb7, 0x59, 0x40, 0x85, 0x60, 0xaa, 0x68, 0x51, 0xae, 0x3a, 0xc7, 0x55, 0x53, 0x47, 0xb0, 0xd3, 0xb1, 0x3b,
};
static const u8 ecccdh_SECP521R1_23_test_vector_shared_secret[] = {
	0x00, 0xc2, 0xbf, 0xaf, 0xcd, 0x7f, 0xbd, 0x3e, 0x2f, 0xd1, 0xc7, 0x50, 0xfd, 0xea, 0x61, 0xe7, 0x0b, 0xd4, 0x78, 0x7a, 0x7e, 0x68, 0x46, 0x8c, 0x57, 0x4e, 0xe9, 0x9e, 0xbc, 0x47, 0xee, 0xde, 0xf0, 0x64, 0xe8, 0x94, 0x4a, 0x73, 0xbc, 0xb7, 0x91, 0x3d, 0xba, 0xb5, 0xd9, 0x3d, 0xca, 0x66, 0x0d, 0x21, 0x6c, 0x55, 0x36, 0x22, 0x36, 0x27, 0x94, 0xf7, 0xa2, 0xac, 0xc7, 0x10, 0x22, 0xbd, 0xb1, 0x6f,
};
static const ecdh_test_case ecccdh_SECP521R1_23_test_case = {
	.name = "ECCCDH/SECP521R1 23",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_23_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_23_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_23_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_23_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_23_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_23_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_23_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_23_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

#ifdef WITH_CURVE_SECP521R1
#define ECCCDH_SECP521R1_SELF_TEST_24
/*** Tests for ECCCDH/SECP521R1 ***/
static const u8 ecccdh_SECP521R1_24_test_vector_our_priv_key[] = {
	0x00, 0x00, 0x00, 0xdf, 0x14, 0xb1, 0xf1, 0x43, 0x2a, 0x7b, 0x0f, 0xb0, 0x53, 0x96, 0x5f, 0xd8, 0x64, 0x3a, 0xfe, 0xe2, 0x6b, 0x24, 0x51, 0xec, 0xb6, 0xa8, 0xa5, 0x3a, 0x65, 0x5d, 0x5f, 0xbe, 0x16, 0xe4, 0xc6, 0x4c, 0xe8, 0x64, 0x72, 0x25, 0xeb, 0x11, 0xe7, 0xfd, 0xcb, 0x23, 0x62, 0x74, 0x71, 0xdf, 0xfc, 0x5c, 0x25, 0x23, 0xbd, 0x2a, 0xe8, 0x99, 0x57, 0xcb, 0xa3, 0xa5, 0x7a, 0x23, 0x93, 0x3e, 0x5a, 0x78,
};
static const u8 ecccdh_SECP521R1_24_test_vector_peer_pub_key[] = {
	0x01, 0xa3, 0x20, 0x99, 0xb0, 0x2c, 0x0b, 0xd8, 0x53, 0x71, 0xf6, 0x0b, 0x0d, 0xd2, 0x08, 0x90, 0xe6, 0xc7, 0xaf, 0x04, 0x8c, 0x81, 0x79, 0x89, 0x0f, 0xda, 0x30, 0x8b, 0x35, 0x9d, 0xbb, 0xc2, 0xb7, 0xa8, 0x32, 0xbb, 0x8c, 0x65, 0x26, 0xc4, 0xaf, 0x99, 0xa7, 0xea, 0x3f, 0x0b, 0x3c, 0xb9, 0x6a, 0xe1, 0xeb, 0x76, 0x84, 0x13, 0x27, 0x95, 0xc4, 0x78, 0xad, 0x6f, 0x96, 0x2e, 0x4a, 0x6f, 0x44, 0x6d, 0x01, 0x76, 0x27, 0x35, 0x7b, 0x39, 0xe9, 0xd7, 0x63, 0x2a, 0x13, 0x70, 0xb3, 0xe9, 0x3c, 0x1a, 0xfb, 0x5c, 0x85, 0x1b, 0x91, 0x0e, 0xb4, 0xea, 0xd0, 0xc9, 0xd3, 0x87, 0xdf, 0x67, 0xcd, 0xe8, 0x50, 0x03, 0xe0, 0xe4, 0x27, 0x55, 0x2f, 0x1c, 0xd0, 0x90, 0x59, 0xaa, 0xd0, 0x26, 0x2e, 0x23, 0x5c, 0xce, 0x5f, 0xba, 0x8c, 0xed, 0xc4, 0xfd, 0xc1, 0x46, 0x3d, 0xa7, 0x6d, 0xcd, 0x4b, 0x6d, 0x1a, 0x46,
};
static const u8 ecccdh_SECP521R1_24_test_vector_our_pub_key[] = {
	0x00, 0x4e, 0x85, 0x83, 0xbb, 0xbb, 0x2e, 0xcd, 0x93, 0xf0, 0x71, 0x4c, 0x33, 0x2d, 0xff, 0x5a, 0xb3, 0xbc, 0x63, 0x96, 0xe6, 0x2f, 0x3c, 0x56, 0x02, 0x29, 0x66, 0x43, 0x29, 0xba, 0xa5, 0x13, 0x8c, 0x3b, 0xb1, 0xc3, 0x64, 0x28, 0xab, 0xd4, 0xe2, 0x3d, 0x17, 0xfc, 0xb7, 0xa2, 0xcf, 0xcc, 0x22, 0x4b, 0x2e, 0x73, 0x4c, 0x89, 0x41, 0xf6, 0xf1, 0x21, 0x72, 0x2d, 0x7b, 0x6b, 0x94, 0x15, 0x45, 0x76, 0x01, 0xcf, 0x08, 0x74, 0xf2, 0x04, 0xb0, 0x36, 0x3f, 0x02, 0x08, 0x64, 0x67, 0x2f, 0xad, 0xbf, 0x87, 0xc8, 0x81, 0x1e, 0xb1, 0x47, 0x75, 0x8b, 0x25, 0x4b, 0x74, 0xb1, 0x4f, 0xae, 0x74, 0x21, 0x59, 0xf0, 0xf6, 0x71, 0xa0, 0x18, 0x21, 0x2b, 0xbf, 0x25, 0xb8, 0x51, 0x9e, 0x12, 0x6d, 0x4c, 0xad, 0x77, 0x8c, 0xff, 0xf5, 0x0d, 0x28, 0x8f, 0xd3, 0x9c, 0xeb, 0x0c, 0xac, 0x63, 0x5b, 0x17, 0x5e, 0xc0,
};
static const u8 ecccdh_SECP521R1_24_test_vector_shared_secret[] = {
	0x01, 0xaa, 0xf2, 0x4e, 0x5d, 0x47, 0xe4, 0x08, 0x0c, 0x18, 0xc5, 0x5e, 0xa3, 0x55, 0x81, 0xcd, 0x8d, 0xa3, 0x0f, 0x1a, 0x07, 0x95, 0x65, 0x04, 0x5d, 0x20, 0x08, 0xd5, 0x1b, 0x12, 0xd0, 0xab, 0xb4, 0x41, 0x1c, 0xda, 0x7a, 0x07, 0x85, 0xb1, 0x5d, 0x14, 0x9e, 0xd3, 0x01, 0xa3, 0x69, 0x70, 0x62, 0xf4, 0x2d, 0xa2, 0x37, 0xaa, 0x7f, 0x07, 0xe0, 0xaf, 0x3f, 0xd0, 0x0e, 0xb1, 0x80, 0x0d, 0x9c, 0x41,
};
static const ecdh_test_case ecccdh_SECP521R1_24_test_case = {
	.name = "ECCCDH/SECP521R1 24",
	.ecdh_type = ECCCDH,
	.ec_str_p = &secp521r1_str_params,
	.our_priv_key = ecccdh_SECP521R1_24_test_vector_our_priv_key,
	.our_priv_key_len = sizeof(ecccdh_SECP521R1_24_test_vector_our_priv_key),
	.peer_pub_key = ecccdh_SECP521R1_24_test_vector_peer_pub_key,
	.peer_pub_key_len = sizeof(ecccdh_SECP521R1_24_test_vector_peer_pub_key),
	.exp_our_pub_key = ecccdh_SECP521R1_24_test_vector_our_pub_key,
	.exp_our_pub_key_len = sizeof(ecccdh_SECP521R1_24_test_vector_our_pub_key),
	.exp_shared_secret = ecccdh_SECP521R1_24_test_vector_shared_secret,
	.exp_shared_secret_len = sizeof(ecccdh_SECP521R1_24_test_vector_shared_secret),
};
#endif /* WITH_CURVE_SECP521R1 */

