/*
 * Copyright (c) 2010 The FreeBSD Foundation 
 * All rights reserved. 
 * 
 * This software was developed by Rui Paulo under sponsorship from the
 * FreeBSD Foundation. 
 *  
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE 
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE. 
 *
 * $FreeBSD: stable/10/lib/libproc/test/t1-bkpt/t1-bkpt.c 244692 2012-12-26 05:11:48Z pluknet $
 */
#include <sys/types.h>
#include <sys/wait.h>

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <libproc.h>

int __noinline
t1_bkpt_t()
{
	printf("TEST OK\n");
}

int
t1_bkpt_d()
{
	struct proc_handle *phdl;
	char *targv[] = { "t1-bkpt-t", NULL};
	unsigned long saved;

	proc_create("./t1-bkpt", targv, NULL, NULL, &phdl);
	assert(proc_bkptset(phdl, (uintptr_t)t1_bkpt_t, &saved) == 0);
	proc_continue(phdl);
	assert(proc_wstatus(phdl) == PS_STOP);
	proc_bkptexec(phdl, saved);
	proc_continue(phdl);
	proc_wstatus(phdl);
	proc_free(phdl);
}


int
main(int argc, char **argv)
{
	if (!strcmp(argv[0], "t1-bkpt-t"))
		t1_bkpt_t();
	else
		t1_bkpt_d();
}

