Obtained from Gentoo:
	https://gitweb.gentoo.org/repo/gentoo.git/commit/?id=8f113e301d3d56ef3c9623c40014000a102db15c

--- pam.c.orig	2018-01-02 11:11:25 UTC
+++ pam.c
@@ -227,8 +227,13 @@ int chpass_pam_talker(int num_msg,
 PHP_FUNCTION(pam_auth)
 {
 	char *username, *password;
+#if PHP_MAJOR_VERSION >= 7
+ 	size_t username_len, password_len;
+	zval *status = NULL, *server, *remote_addr;
+#else
 	int username_len, password_len;
 	zval *status = NULL, **server, **remote_addr;
+#endif
 	zend_bool checkacctmgmt = 1;
 
 	pam_auth_t userinfo = {NULL, NULL};
@@ -248,22 +253,37 @@ PHP_FUNCTION(pam_auth)
 		if (status) {
 			spprintf(&error_msg, 0, "%s (in %s)", (char *) pam_strerror(pamh, result), "pam_start");
 			zval_dtor(status);
+#if PHP_MAJOR_VERSION >= 7
+			ZVAL_STRING(status, error_msg);
+			efree(error_msg);
+#else
 			ZVAL_STRING(status, error_msg, 0);
+#endif
 		}
 		RETURN_FALSE;
 	}
 
+#if PHP_MAJOR_VERSION >= 7
+	if ((remote_addr = zend_hash_str_find(Z_ARR(PG(http_globals)[TRACK_VARS_SERVER]), "REMOTE_ADDR", sizeof("REMOTE_ADDR")-1)) != NULL && Z_TYPE_P(remote_addr) == IS_STRING) {
+		pam_set_item(pamh, PAM_RHOST, Z_STRVAL_P(remote_addr));
+#else
 	if (zend_hash_find(&EG(symbol_table), "_SERVER", sizeof("_SERVER"), (void **)&server) == SUCCESS && Z_TYPE_PP(server) == IS_ARRAY) {
 		if (zend_hash_find(Z_ARRVAL_PP(server), "REMOTE_ADDR", sizeof("REMOTE_ADDR"), (void **)&remote_addr) == SUCCESS && Z_TYPE_PP(remote_addr) == IS_STRING) {
 			pam_set_item(pamh, PAM_RHOST, Z_STRVAL_PP(remote_addr));
 		}
+#endif
 	}
 
 	if ((result = pam_authenticate(pamh, PAM_DISALLOW_NULL_AUTHTOK)) != PAM_SUCCESS) {
 		if (status) {
 			spprintf(&error_msg, 0, "%s (in %s)", (char *) pam_strerror(pamh, result), "pam_authenticate");
 			zval_dtor(status);
+#if PHP_MAJOR_VERSION >= 7
+			ZVAL_STRING(status, error_msg);
+			efree(error_msg);
+#else
 			ZVAL_STRING(status, error_msg, 0);
+#endif
 		}
 		pam_end(pamh, PAM_SUCCESS);
 		RETURN_FALSE;
@@ -274,7 +294,12 @@ PHP_FUNCTION(pam_auth)
 			if (status) {
 				spprintf(&error_msg, 0, "%s (in %s)", (char *) pam_strerror(pamh, result), "pam_acct_mgmt");
 				zval_dtor(status);
+#if PHP_MAJOR_VERSION >= 7
+				ZVAL_STRING(status, error_msg);
+				efree(error_msg);
+#else
 				ZVAL_STRING(status, error_msg, 0);
+#endif
 			}
 			pam_end(pamh, PAM_SUCCESS);
 			RETURN_FALSE;
@@ -291,7 +316,11 @@ PHP_FUNCTION(pam_auth)
 PHP_FUNCTION(pam_chpass)
 {
 	char *username, *oldpass, *newpass;
+#if PHP_MAJOR_VERSION >= 7
+	size_t username_len, oldpass_len, newpass_len;
+#else
 	int username_len, oldpass_len, newpass_len;
+#endif
 	zval *status = NULL;
 
 	pam_chpass_t userinfo = {NULL, NULL, NULL, 0};
@@ -312,7 +341,12 @@ PHP_FUNCTION(pam_chpass)
 		if (status) {
 			spprintf(&error_msg, 0, "%s (in %s)", (char *) pam_strerror(pamh, result), "pam_start");
 			zval_dtor(status);
+#if PHP_MAJOR_VERSION >= 7
+			ZVAL_STRING(status, error_msg);
+			efree(error_msg);
+#else
 			ZVAL_STRING(status, error_msg, 0);
+#endif
 		}
 		RETURN_FALSE;
 	}
@@ -321,7 +355,12 @@ PHP_FUNCTION(pam_chpass)
 		if (status) {
 			spprintf(&error_msg, 0, "%s (in %s)", (char *) pam_strerror(pamh, result), "pam_authenticate");
 			zval_dtor(status);
+#if PHP_MAJOR_VERSION >= 7
+			ZVAL_STRING(status, error_msg);
+			efree(error_msg);
+#else
 			ZVAL_STRING(status, error_msg, 0);
+#endif
 		}
 		pam_end(pamh, PAM_SUCCESS);
 		RETURN_FALSE;
@@ -331,7 +370,12 @@ PHP_FUNCTION(pam_chpass)
 		if (status) {
 			spprintf(&error_msg, 0, "%s (in %s)", (char *) pam_strerror(pamh, result), "pam_chauthtok");
 			zval_dtor(status);
+#if PHP_MAJOR_VERSION >= 7
+			ZVAL_STRING(status, error_msg);
+			efree(error_msg);
+#else
 			ZVAL_STRING(status, error_msg, 0);
+#endif
 		}
 		pam_end(pamh, PAM_SUCCESS);
 		RETURN_FALSE;
