#
# ovirt-hosted-engine-setup -- ovirt hosted engine setup
# Copyright (C) 2013-2021 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global         package_version 2.5.4
%global         ovirt_hosted_engine_setup_templates %{_datadir}/%{name}/templates
%global         ovirt_hosted_engine_setup_scripts %{_datadir}/%{name}/scripts
%global         vdsmhooksdir %{_libexecdir}/vdsm/hooks

%global         python_interpreter %{__python3}
%global         python_target_version python3
%global         python_sitelib %{python3_sitelib}


Summary:        oVirt Hosted Engine setup tool
Name:           ovirt-hosted-engine-setup
Version:        2.5.4
Release:        1%{?release_suffix}%{?dist}
License:        LGPLv2+
URL:            http://www.ovirt.org
Source:         http://resources.ovirt.org/pub/src/%{name}/%{name}-%{package_version}.tar.gz
Group:          Applications/System

BuildArch:      noarch

# Python dependencies

Requires:       %{python_target_version}

Requires:       %{python_target_version}-ethtool >= 0.6-3
Requires:       %{python_target_version}-ovirt-engine-sdk4 >= 4.3.1
Requires:       %{python_target_version}-sanlock
Requires:       %{python_target_version}-libselinux

Requires:       %{python_target_version}-dateutil
Requires:       %{python_target_version}-distro
Requires:       %{python_target_version}-netaddr
Requires:       %{python_target_version}-otopi >= 1.9.0
Requires:       %{python_target_version}-ovirt-setup-lib >= 1.3.2
Requires:       %{python_target_version}-six

BuildRequires:  %{python_target_version}-devel
BuildRequires:  %{python_target_version}-pytest

# Non Python dependencies
Requires:       bind-utils
Requires:       lsof
Requires:       openssh-server
Requires:       openssl
Requires:       sanlock >= 2.8
Requires:       sudo
Requires:       libvirt-client >= 6.6.0-9
Requires:       virt-install
%if 0%{?rhel} < 9
# On CentOS Stream 9 we are going to use ansible 2.11
# The whole way of consuming anisble roles is going to change
# skipping ansible dependencies until we have something working.
Requires:       ansible >= 2.9.21, ansible < 2.10.0
Requires:       ovirt-ansible-collection >= 1.5.4
%endif
# default libvirt network
Requires:       libvirt-daemon-config-network

BuildRequires:  gettext >= 0.18.2

%if 0%{?fedora}
Requires:       qemu-img
%endif

%if 0%{?centos}
Requires:       qemu-img
%else
Requires:       qemu-img >= 15:3.1.0-20.module+el8+2888+cdc893a8
%endif


Requires:       ovirt-hosted-engine-ha >= 2.4
Requires:       glusterfs-cli >= 5.6
Requires:       vdsm-python >= 4.50
Requires(post): vdsm-python >= 4.50
Requires:       ovirt-host >= 4.5.0

Conflicts:      ovirt-engine-appliance < 4.5
Conflicts:      ovirt-engine-appliance >= 4.6


%description
Hosted Engine setup tool for oVirt project.

%prep
%setup -q -n %{name}-%{package_version}

%build
%configure \
        --docdir="%{_docdir}/%{name}-%{version}" \
        --disable-python-syntax-check \
        --disable-ansible-syntax-check \
        %{?conf}
make %{?_smp_mflags}

%check
make test

%install
make %{?_smp_mflags} install DESTDIR="%{buildroot}"
%find_lang %{name}

%files -f %{name}.lang
%license COPYING
%doc README.md
%doc readme.appliance
%doc readme.rollback
%dir %{_sysconfdir}/ovirt-hosted-engine-setup.env.d
%dir %{_sysconfdir}/ovirt-hosted-engine
%ghost %attr(600, root, root) %{_sysconfdir}/ovirt-hosted-engine/virsh_auth.conf
%dir %attr(700, root, root) %{_localstatedir}/log/ovirt-hosted-engine-setup
%dir %{_localstatedir}/lib/ovirt-hosted-engine-setup
%dir %{_localstatedir}/lib/ovirt-hosted-engine-setup/answers
%{_sbindir}/hosted-engine
%{_sbindir}/ovirt-hosted-engine-setup
%{_sbindir}/ovirt-hosted-engine-cleanup
%{python_sitelib}/ovirt_hosted_engine_setup/
%{_datadir}/%{name}/
%{_mandir}/man8/*

#move to a separate package?
%{vdsmhooksdir}/before_vm_start/

%post
touch %{_sysconfdir}/ovirt-hosted-engine/virsh_auth.conf
chmod 600 %{_sysconfdir}/ovirt-hosted-engine/virsh_auth.conf
%{python_interpreter} -c '
from vdsm.tool.configurators import passwd
print((
    "[credentials-vdsm]\n"
    "authname={authname}\n"
    "password={password}\n\n"
    "[auth-libvirt-localhost]\n"
    "credentials=vdsm\n"
).format(
    authname=passwd.SASL_USERNAME,
    password=passwd.libvirt_password(),
))
' > %{_sysconfdir}/ovirt-hosted-engine/virsh_auth.conf

%changelog
* Thu Oct 14 2021 Asaf Rachmani <arachman@redhat.com> - 2.5.4-1
- 2.5.4-1

* Tue Jul 27 2021 Asaf Rachmani <arachman@redhat.com> - 2.5.4-0.0.master
- 2.5.4-0.0.master

* Tue Jul 27 2021 Asaf Rachmani <arachman@redhat.com> - 2.5.3-1
- 2.5.3-1

* Thu Jul 08 2021 Sandro Bonazzola <sbonazzo@redhat.com> - 2.5.3-0.0.master
- 2.5.3-0.0.master

* Thu Jul 08 2021 Sandro Bonazzola <sbonazzo@redhat.com> - 2.5.2-1
- 2.5.2-1
- Drop RHEL 7 support in spec file

* Tue Jun 08 2021 Asaf Rachmani <arachman@redhat.com> - 2.5.2-0.0.master
- 2.5.2-0.0.master

* Tue Jun 08 2021 Asaf Rachmani <arachman@redhat.com> - 2.5.1-1
- 2.5.1-1

* Wed Apr 14 2021 Asaf Rachmani <arachman@redhat.com> - 2.5.1-0.0.master
- 2.5.1-0.0.master

* Wed Apr 14 2021 Asaf Rachmani <arachman@redhat.com> - 2.5.0-1
- 2.5.0-1

# This version built accidentally instead of 2.4.10-0.0.master,
# therfore, we'll move forward with 2.5.x
* Thu Nov 26 2020 Asaf Rachmani <arachman@redhat.com> - 2.5.0-0.0.master
- 2.5.0-0.0.master

* Thu Nov 26 2020 Asaf Rachmani <arachman@redhat.com> - 2.4.9-1
- 2.4.9-1

* Wed Oct 28 2020 Asaf Rachmani <arachman@redhat.com> - 2.4.9-0.0.master
- 2.4.9-0.0.master

* Wed Oct 28 2020 Asaf Rachmani <arachman@redhat.com> - 2.4.8-1
- 2.4.8-1

* Tue Oct 06 2020 Asaf Rachmani <arachman@redhat.com> - 2.4.8-0.0.master
- 2.4.8-0.0.master

* Tue Oct 06 2020 Asaf Rachmani <arachman@redhat.com> - 2.4.7-1
- 2.4.7-1

* Mon Aug 10 2020 Asaf Rachmani <arachman@redhat.com> - 2.4.7-0.0.master
- 2.4.7-0.0.master

* Mon Aug 10 2020 Asaf Rachmani <arachman@redhat.com> - 2.4.6-1
- 2.4.6-1

* Tue Jun 09 2020 Asaf Rachmani <arachman@redhat.com> - 2.4.6-0.0.master
- 2.4.6-0.0.master

* Tue Jun 09 2020 Asaf Rachmani <arachman@redhat.com> - 2.4.5-1
- 2.4.5-1

* Mon Mar 23 2020 Asaf Rachmani <arachman@redhat.com> - 2.4.5-0.0.master
- 2.4.5-0.0.master

* Mon Mar 23 2020 Asaf Rachmani <arachman@redhat.com> - 2.4.4-1
- 2.4.4-1

* Tue Mar 10 2020 Evgeny Slutsky <eslutsky@redhat.com> - 2.4.4-0.0.master
- 2.4.4-0.0.master

* Tue Mar 10 2020 Evgeny Slutsky <eslutsky@redhat.com> - 2.4.3-1
- 2.4.3-1

* Tue Feb 25 2020 Evgeny Slutsky <eslutsky@redhat.com> - 2.4.3-0.0.master
- 2.4.3-0.0.master

* Tue Feb 25 2020 Evgeny Slutsky <eslutsky@redhat.com> - 2.4.2-1
- 2.4.2-1

* Wed Jan 22 2020 Lev Veyde <lveyde@redhat.com> - 2.4.2-0.0.master
- 2.4.2-0.0.master

* Wed Jan 22 2020 Lev Veyde <lveyde@redhat.com> - 2.4.1-1
- 2.4.1-1

* Mon Nov 25 2019 Evgeny Slutsky <eslutsky@redhat.com> - 2.4.1-0.0.master
- 2.4.1-0.0.master

* Mon Nov 25 2019 Evgeny Slutsky <eslutsky@redhat.com> - 2.4.0-1
- 2.4.0-1

* Thu Feb 07 2019 Simone Tiraboschi <stirabos@redhat.com> - 2.4.0-0.0.master
- 2.4.0-0.0.master

* Fri Jan 25 2019 Simone Tiraboschi <stirabos@redhat.com> - 2.3.3-1
- 2.3.3-1

* Mon Jan 14 2019 Simone Tiraboschi <stirabos@redhat.com> - 2.3.3-0.0.master
- 2.3.3-0.0.master

* Mon Jan 14 2019 Simone Tiraboschi <stirabos@redhat.com> - 2.3.2-1
- 2.3.2-1

* Fri Jan 11 2019 Simone Tiraboschi <stirabos@redhat.com> - 2.3.2-0.0.master
- 2.3.2-0.0.master

* Fri Jan 11 2019 Simone Tiraboschi <stirabos@redhat.com> - 2.3.1-1
- 2.3.1-1

* Wed Jan 09 2019 Simone Tiraboschi <stirabos@redhat.com> - 2.3.1-0.0.master
- 2.3.1-0.0.master

* Wed Jan 09 2019 Simone Tiraboschi <stirabos@redhat.com> - 2.3.0-1
- 2.3.0-1

* Wed Nov 21 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.3.0-0.2.master
- 2.3.0-0.2.master

* Wed Nov 21 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.3.0-0.1.beta
- 2.3.0-0.1.beta

* Thu Feb 01 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.3.0-0.0.master
- 2.3.0-0.0.master

* Wed Jan 24 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.9-0.0.master
- 2.2.9-0.0.master

* Wed Jan 24 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.8-1
- 2.2.8-1

* Tue Jan 23 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.8-0.0.master
- 2.2.8-0.0.master

* Tue Jan 23 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.7-1
- 2.2.7-1

* Wed Jan 17 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.7-0.0.master
- 2.2.7-0.0.master

* Wed Jan 17 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.6-1
- 2.2.6-1

* Wed Jan 10 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.6-0.0.master
- 2.2.6-0.0.master

* Wed Jan 10 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.5-1
- 2.2.5-1

* Wed Jan 10 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.5-0.0.master
- 2.2.5-0.0.master

* Wed Jan 10 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.4-1
- 2.2.4-1

* Tue Dec 19 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.2.4-0.0.master
- 2.2.4-0.0.master

* Tue Dec 19 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.2.3-1
- 2.2.3-1

* Thu Dec 14 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.2.3-0.0.master
- 2.2.3-0.0.master

* Thu Dec 14 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.2.2-1
- 2.2.2-1

* Mon Dec 11 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.2.2-0.0.master
- 2.2.2-0.0.master

* Mon Dec 11 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.2.1-1
- 2.2.1-1

* Thu Nov 30 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 2.2.1-0.0.master
- 2.2.1-0.0.master

* Thu Nov 30 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 2.2.0-1
- 2.2.0-1

* Wed Dec 21 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.2.0-0.0.master
- 2.2.0-0.0.master

* Tue Jun 14 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.1.0-0.0.master
- 2.1.0-0.0.master

* Wed Jun 08 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.0.2-0.0.master
- 2.0.0.2-0.0.master

* Wed Jun 08 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.0.1-1
- 2.0.0.1-1

* Tue May 31 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 2.0.0-1
- 2.0.0-1

* Thu Aug  6 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 2.0.0-0.0.master
- 2.0.0-0.0.master
