#
# ovirt-hosted-engine-setup -- ovirt hosted engine setup
# Copyright (C) 2013-2017 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global         package_version 2.2.30
%global         ovirt_hosted_engine_setup_templates %{_datadir}/%{name}/templates
%global         ovirt_hosted_engine_setup_scripts %{_datadir}/%{name}/scripts
%global         vdsmhooksdir %{_libexecdir}/vdsm/hooks


Summary:        oVirt Hosted Engine setup tool
Name:           ovirt-hosted-engine-setup
Version:        2.2.30
Release:        1%{?release_suffix}%{?dist}
License:        LGPLv2+
URL:            http://www.ovirt.org
Source:         http://resources.ovirt.org/pub/src/%{name}/%{name}-%{package_version}.tar.gz
Group:          Applications/System

BuildArch:      noarch

Requires:       bind-utils
Requires:       genisoimage
Requires:       iptables
Requires:       iptables-services
Requires:       libselinux-python
Requires:       lsof
Requires:       openssh-server
Requires:       openssl
Requires:       pyliblzma
Requires:       python
Requires:       python-dateutil
Requires:       python-ethtool >= 0.6-3
Requires:       python-netaddr
Requires:       python-libguestfs
Requires:       python-six
Requires:       sanlock >= 2.8
Requires:       sanlock-python >= 2.8
Requires:       socat
Requires:       sudo
Requires:       libvirt-client
Requires:       m2crypto
Requires:       virt-install
Requires:       python-ovirt-engine-sdk4 >= 4.2.4
Requires:       ansible >= 2.5.2
# default libvirt network
Requires:       libvirt-daemon-config-network

BuildRequires:  gettext >= 0.18.2
BuildRequires:  python2-devel
BuildRequires:  pytest

%if 0%{?fedora}
Requires:       qemu-img
%endif

%if 0%{?rhel}
Requires:       qemu-img-rhev
%endif


Requires:       otopi >= 1.7.3
Requires:       ovirt-host-deploy >= 1.7.0
Requires:       ovirt-hosted-engine-ha >= 2.2.13
Requires:       ovirt-engine-sdk-python >= 3.6.9.1
Requires:       ovirt-setup-lib >= 1.1.3
Requires:       glusterfs-cli >= 3.12.0
Requires:       vdsm-python >= 4.20.21
Requires(post): vdsm-python >= 4.20.21
Requires:       ovirt-host >= 4.2.2

Conflicts:      ovirt-engine-appliance < 4.0
Conflicts:      ovirt-engine-appliance >= 4.3


%description
Hosted Engine setup tool for oVirt project.

%prep
%setup -q -n %{name}-%{package_version}

%build
%configure \
        --docdir="%{_docdir}/%{name}-%{version}" \
        --disable-python-syntax-check \
        %{?conf}
make %{?_smp_mflags}

%check
make test

%install
make %{?_smp_mflags} install DESTDIR="%{buildroot}"
%find_lang %{name}

%files -f %{name}.lang
%license COPYING
%doc README
%doc readme.appliance
%doc readme.rollback
%dir %{_sysconfdir}/ovirt-hosted-engine-setup.env.d
%dir %{_sysconfdir}/ovirt-hosted-engine
%ghost %attr(600, root, root) %{_sysconfdir}/ovirt-hosted-engine/virsh_auth.conf
%dir %attr(700, root, root) %{_localstatedir}/log/ovirt-hosted-engine-setup
%dir %{_localstatedir}/lib/ovirt-hosted-engine-setup
%dir %{_localstatedir}/lib/ovirt-hosted-engine-setup/answers
%{_sbindir}/hosted-engine
%{_sbindir}/ovirt-hosted-engine-setup
%{_sbindir}/ovirt-hosted-engine-cleanup
%{python_sitelib}/ovirt_hosted_engine_setup/
%{_datadir}/%{name}/
%{_mandir}/man8/*

#move to a separate package?
%{vdsmhooksdir}/before_vm_start/

%post
touch %{_sysconfdir}/ovirt-hosted-engine/virsh_auth.conf
chmod 600 %{_sysconfdir}/ovirt-hosted-engine/virsh_auth.conf
python -c '
from vdsm.tool.configurators import passwd
print((
    "[credentials-vdsm]\n"
    "authname={authname}\n"
    "password={password}\n\n"
    "[auth-libvirt-localhost]\n"
    "credentials=vdsm\n"
).format(
    authname=passwd.SASL_USERNAME,
    password=passwd.libvirt_password(),
))
' > %{_sysconfdir}/ovirt-hosted-engine/virsh_auth.conf

%changelog
* Wed Oct 24 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.30-1
- 2.2.30-1

* Mon Oct 22 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.30-0.0.master
- 2.2.30-0.0.master

* Mon Oct 22 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.29-1
- 2.2.29-1

* Mon Oct 01 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.29-0.0.master
- 2.2.29-0.0.master

* Mon Oct 01 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.28-1
- 2.2.28-1

* Mon Sep 17 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.28-0.0.master
- 2.2.28-0.0.master

* Mon Sep 17 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.27-1
- 2.2.27-1

* Fri Aug 10 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.27-0.0.master
- 2.2.27-0.0.master

* Fri Aug 10 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.26-1
- 2.2.26-1

* Mon Jul 30 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.26-0.0.master
- 2.2.26-0.0.master

* Mon Jul 30 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.25-1
- 2.2.25-1

* Thu Jul 19 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.25-0.0.master
- 2.2.25-0.0.master

* Thu Jul 19 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.24-1
- 2.2.24-1

* Thu Jun 28 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.24-0.0.master
- 2.2.24-0.0.master

* Thu Jun 28 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.23-1
- 2.2.23-1

* Wed May 30 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.23-0.0.master
- 2.2.23-0.0.master

* Wed May 30 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.22-1
- 2.2.22-1

* Wed May 23 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.22-0.0.master
- 2.2.22-0.0.master

* Wed May 23 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.21-1
- 2.2.21-1

* Wed May  2 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.21-0.0.master
- 2.2.21-0.0.master

* Wed May  2 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.20-1
- 2.2.20-1

* Tue Apr 24 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.20-0.0.master
- 2.2.20-0.0.master

* Tue Apr 24 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.19-1
- 2.2.19-1

* Tue Apr 17 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.19-0.0.master
- 2.2.19-0.0.master

* Tue Apr 17 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.18-1
- 2.2.18-1

* Tue Apr 10 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.18-0.0.master
- 2.2.18-0.0.master

* Tue Apr 10 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.17-1
- 2.2.17-1

* Thu Apr  5 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.17-0.0.master
- 2.2.17-0.0.master

* Thu Apr  5 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.16-1
- 2.2.16-1

* Mon Mar 26 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.16-0.0.master
- 2.2.16-0.0.master

* Mon Mar 26 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.15-1
- 2.2.15-1

* Wed Mar 21 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.15-0.0.master
- 2.2.15-0.0.master

* Wed Mar 21 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.14-1
- 2.2.14-1

* Wed Mar 14 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.14-0.0.master
- 2.2.14-0.0.master

* Wed Mar 14 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.13-1
- 2.2.13-1

* Thu Mar 01 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.13-0.0.master
- 2.2.13-0.0.master

* Thu Mar 01 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.12-1
- 2.2.12-1

* Tue Feb 20 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.12-0.0.master
- 2.2.12-0.0.master

* Tue Feb 20 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.11-1
- 2.2.11-1

* Wed Feb 14 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.11-0.0.master
- 2.2.11-0.0.master

* Wed Feb 14 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.10-1
- 2.2.10-1

* Thu Feb 01 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.10-0.0.master
- 2.2.10-0.0.master

* Thu Feb 01 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.9-1
- 2.2.9-1

* Wed Jan 24 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.9-0.0.master
- 2.2.9-0.0.master

* Wed Jan 24 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.8-1
- 2.2.8-1

* Tue Jan 23 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.8-0.0.master
- 2.2.8-0.0.master

* Tue Jan 23 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.7-1
- 2.2.7-1

* Wed Jan 17 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.7-0.0.master
- 2.2.7-0.0.master

* Wed Jan 17 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.6-1
- 2.2.6-1

* Wed Jan 10 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.6-0.0.master
- 2.2.6-0.0.master

* Wed Jan 10 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.5-1
- 2.2.5-1

* Wed Jan 10 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.5-0.0.master
- 2.2.5-0.0.master

* Wed Jan 10 2018 Simone Tiraboschi <stirabos@redhat.com> - 2.2.4-1
- 2.2.4-1

* Tue Dec 19 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.2.4-0.0.master
- 2.2.4-0.0.master

* Tue Dec 19 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.2.3-1
- 2.2.3-1

* Thu Dec 14 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.2.3-0.0.master
- 2.2.3-0.0.master

* Thu Dec 14 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.2.2-1
- 2.2.2-1

* Mon Dec 11 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.2.2-0.0.master
- 2.2.2-0.0.master

* Mon Dec 11 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.2.1-1
- 2.2.1-1

* Thu Nov 30 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 2.2.1-0.0.master
- 2.2.1-0.0.master

* Thu Nov 30 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 2.2.0-1
- 2.2.0-1

* Wed Dec 21 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.2.0-0.0.master
- 2.2.0-0.0.master

* Tue Jun 14 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.1.0-0.0.master
- 2.1.0-0.0.master

* Wed Jun 08 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.0.2-0.0.master
- 2.0.0.2-0.0.master

* Wed Jun 08 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.0.1-1
- 2.0.0.1-1

* Tue May 31 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 2.0.0-1
- 2.0.0-1

* Thu Aug  6 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 2.0.0-0.0.master
- 2.0.0-0.0.master
