//
// Copyright (c) 2012 Red Hat, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//           http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// *********************************************************************
// ********************* GENERATED CODE - DO NOT MODIFY ****************
// *********************************************************************

package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;

import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.entities.Action;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.HttpHeaderUtils;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

/**
 * <p>OpenStackNetworkProvider providing relation and functional services
 * <p>to {@link org.ovirt.engine.sdk.entities.OpenStackNetworkProvider }.
 */
@SuppressWarnings("unused")
public class OpenStackNetworkProvider extends
        org.ovirt.engine.sdk.entities.OpenStackNetworkProvider {

    private HttpProxyBroker proxy;
    private final Object LOCK = new Object();

    private volatile OpenStackNetworkProviderCertificates openStackNetworkProviderCertificates;
    private volatile OpenStackNetworkProviderOpenStackNetworks openStackNetworkProviderOpenStackNetworks;


    /**
     * @param proxy HttpProxyBroker
     */
    public OpenStackNetworkProvider(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    /**
     * @return HttpProxyBroker
     */
    private HttpProxyBroker getProxy() {
        return proxy;
    }

    /**
     * Gets the value of the OpenStackNetworkProviderCertificates property.
     *
     * @return
     *     {@link OpenStackNetworkProviderCertificates }
     */
    public OpenStackNetworkProviderCertificates getCertificates() {
        if (this.openStackNetworkProviderCertificates == null) {
            synchronized (this.LOCK) {
                if (this.openStackNetworkProviderCertificates == null) {
                    this.openStackNetworkProviderCertificates = new OpenStackNetworkProviderCertificates(proxy, this);
                }
            }
        }
        return openStackNetworkProviderCertificates;
    }
    /**
     * Gets the value of the OpenStackNetworkProviderOpenStackNetworks property.
     *
     * @return
     *     {@link OpenStackNetworkProviderOpenStackNetworks }
     */
    public OpenStackNetworkProviderOpenStackNetworks getOpenStackNetworks() {
        if (this.openStackNetworkProviderOpenStackNetworks == null) {
            synchronized (this.LOCK) {
                if (this.openStackNetworkProviderOpenStackNetworks == null) {
                    this.openStackNetworkProviderOpenStackNetworks = new OpenStackNetworkProviderOpenStackNetworks(proxy, this);
                }
            }
        }
        return openStackNetworkProviderOpenStackNetworks;
    }


    /**
     * Deletes object.
     *
     * @return
     *     {@link Response }
     *
     * @throws ClientProtocolException
     *             Signals that HTTP/S protocol error has occurred.
     * @throws ServerException
     *             Signals that an oVirt api error has occurred.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred.
     */
    public Response delete() throws ClientProtocolException,
            ServerException, IOException {
        String url = this.getHref();

        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();

        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();

        return getProxy().delete(url, Response.class, headers);
    }
    /**
     * Deletes object.
     * @param async
     *    <pre>
     *    [true|false]
     *    </pre>
     * @return
     *     {@link Response }
     *
     * @throws ClientProtocolException
     *             Signals that HTTP/S protocol error has occurred.
     * @throws ServerException
     *             Signals that an oVirt api error has occurred.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred.
     */
    public Response delete(Boolean async) throws ClientProtocolException,
            ServerException, IOException {
        String url = this.getHref();

        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();

        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }

        url = urlBuilder.build();

        return getProxy().delete(url, Response.class, headers);
    }
    /**
     * Deletes object.
     * @param async
     *    <pre>
     *    [true|false]
     *    </pre>
     * @param correlationId
     *    <pre>
     *    [any string]
     *    </pre>
     * @return
     *     {@link Response }
     *
     * @throws ClientProtocolException
     *             Signals that HTTP/S protocol error has occurred.
     * @throws ServerException
     *             Signals that an oVirt api error has occurred.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred.
     */
    public Response delete(Boolean async, String correlationId) throws ClientProtocolException,
            ServerException, IOException {
        String url = this.getHref();

        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();

        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }

        url = urlBuilder.build();

        return getProxy().delete(url, Response.class, headers);
    }
    /**
     * Performs importcertificates action.
     *
     * @param action {@link org.ovirt.engine.sdk.entities.Action}
     *
     * @return
     *     {@link Action }
     *
     * @throws ClientProtocolException
     *             Signals that HTTP/S protocol error has occurred.
     * @throws ServerException
     *             Signals that an oVirt api error has occurred.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred.
     */
    public Action importcertificates(Action action) throws ClientProtocolException,
            ServerException, IOException {
        String url = this.getHref() + "/importcertificates";

        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();

        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();

        return getProxy().action(url, action, Action.class, Action.class, headers);
    }
    /**
     * Performs importcertificates action.
     *
     * @param action {@link org.ovirt.engine.sdk.entities.Action}
     * @param async
     *    <pre>
     *    [true|false]
     *    </pre>
     * @return
     *     {@link Action }
     *
     * @throws ClientProtocolException
     *             Signals that HTTP/S protocol error has occurred.
     * @throws ServerException
     *             Signals that an oVirt api error has occurred.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred.
     */
    public Action importcertificates(Action action, Boolean async) throws ClientProtocolException,
            ServerException, IOException {
        String url = this.getHref() + "/importcertificates";

        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();

        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }

        url = urlBuilder.build();

        return getProxy().action(url, action, Action.class, Action.class, headers);
    }
    /**
     * Performs testconnectivity action.
     *
     * @param action {@link org.ovirt.engine.sdk.entities.Action}
     *
     * @return
     *     {@link Action }
     *
     * @throws ClientProtocolException
     *             Signals that HTTP/S protocol error has occurred.
     * @throws ServerException
     *             Signals that an oVirt api error has occurred.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred.
     */
    public Action testconnectivity(Action action) throws ClientProtocolException,
            ServerException, IOException {
        String url = this.getHref() + "/testconnectivity";

        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();

        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();

        return getProxy().action(url, action, Action.class, Action.class, headers);
    }
    /**
     * Performs testconnectivity action.
     *
     * @param action {@link org.ovirt.engine.sdk.entities.Action}
     * @param async
     *    <pre>
     *    [true|false]
     *    </pre>
     * @return
     *     {@link Action }
     *
     * @throws ClientProtocolException
     *             Signals that HTTP/S protocol error has occurred.
     * @throws ServerException
     *             Signals that an oVirt api error has occurred.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred.
     */
    public Action testconnectivity(Action action, Boolean async) throws ClientProtocolException,
            ServerException, IOException {
        String url = this.getHref() + "/testconnectivity";

        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();

        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }

        url = urlBuilder.build();

        return getProxy().action(url, action, Action.class, Action.class, headers);
    }
    /**
     * Updates OpenStackNetworkProvider object.
     *
     * @param openstacknetworkprovider {@link org.ovirt.engine.sdk.entities.OpenStackNetworkProvider}
     *    <pre>
     *    [openstack_network_provider.name]
     *    [openstack_network_provider.description]
     *    [openstack_network_provider.requires_authentication]
     *    [openstack_network_provider.username]
     *    [openstack_network_provider.password]
     *    [openstack_network_provider.authentication_url]
     *    [openstack_network_provider.properties.property]
     *    [openstack_network_provider.tenant_name]
     *    </pre>
     *
     *
     * @return
     *     {@link OpenStackNetworkProvider }
     *
     * @throws ClientProtocolException
     *             Signals that HTTP/S protocol error has occurred.
     * @throws ServerException
     *             Signals that an oVirt api error has occurred.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred.
     */
    public OpenStackNetworkProvider update() throws ClientProtocolException,
            ServerException, IOException {
        String url = this.getHref();

        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();

        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();

        return getProxy().update(
                url,
                this,
                org.ovirt.engine.sdk.entities.OpenStackNetworkProvider.class,
                OpenStackNetworkProvider.class,
                headers);
    }
    /**
     * Updates OpenStackNetworkProvider object.
     *
     * @param openstacknetworkprovider {@link org.ovirt.engine.sdk.entities.OpenStackNetworkProvider}
     *    <pre>
     *    [openstack_network_provider.name]
     *    [openstack_network_provider.description]
     *    [openstack_network_provider.requires_authentication]
     *    [openstack_network_provider.username]
     *    [openstack_network_provider.password]
     *    [openstack_network_provider.authentication_url]
     *    [openstack_network_provider.properties.property]
     *    [openstack_network_provider.tenant_name]
     *    </pre>
     *
     * @param async
     *    <pre>
     *    [true|false]
     *    </pre>
     * @return
     *     {@link OpenStackNetworkProvider }
     *
     * @throws ClientProtocolException
     *             Signals that HTTP/S protocol error has occurred.
     * @throws ServerException
     *             Signals that an oVirt api error has occurred.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred.
     */
    public OpenStackNetworkProvider update(Boolean async) throws ClientProtocolException,
            ServerException, IOException {
        String url = this.getHref();

        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();

        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }

        url = urlBuilder.build();

        return getProxy().update(
                url,
                this,
                org.ovirt.engine.sdk.entities.OpenStackNetworkProvider.class,
                OpenStackNetworkProvider.class,
                headers);
    }
    /**
     * Updates OpenStackNetworkProvider object.
     *
     * @param openstacknetworkprovider {@link org.ovirt.engine.sdk.entities.OpenStackNetworkProvider}
     *    <pre>
     *    [openstack_network_provider.name]
     *    [openstack_network_provider.description]
     *    [openstack_network_provider.requires_authentication]
     *    [openstack_network_provider.username]
     *    [openstack_network_provider.password]
     *    [openstack_network_provider.authentication_url]
     *    [openstack_network_provider.properties.property]
     *    [openstack_network_provider.tenant_name]
     *    </pre>
     *
     * @param async
     *    <pre>
     *    [true|false]
     *    </pre>
     * @param correlationId
     *    <pre>
     *    [any string]
     *    </pre>
     * @return
     *     {@link OpenStackNetworkProvider }
     *
     * @throws ClientProtocolException
     *             Signals that HTTP/S protocol error has occurred.
     * @throws ServerException
     *             Signals that an oVirt api error has occurred.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred.
     */
    public OpenStackNetworkProvider update(Boolean async, String correlationId) throws ClientProtocolException,
            ServerException, IOException {
        String url = this.getHref();

        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();

        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }

        url = urlBuilder.build();

        return getProxy().update(
                url,
                this,
                org.ovirt.engine.sdk.entities.OpenStackNetworkProvider.class,
                OpenStackNetworkProvider.class,
                headers);
    }
    /**
     * Updates OpenStackNetworkProvider object.
     *
     * @param openstacknetworkprovider {@link org.ovirt.engine.sdk.entities.OpenStackNetworkProvider}
     *    <pre>
     *    [openstack_network_provider.name]
     *    [openstack_network_provider.description]
     *    [openstack_network_provider.requires_authentication]
     *    [openstack_network_provider.username]
     *    [openstack_network_provider.password]
     *    [openstack_network_provider.authentication_url]
     *    [openstack_network_provider.properties.property]
     *    [openstack_network_provider.tenant_name]
     *    </pre>
     *
     * @param async
     *    <pre>
     *    [true|false]
     *    </pre>
     * @param correlationId
     *    <pre>
     *    [any string]
     *    </pre>
     * @param expect
     *    <pre>
     *    [202-accepted]
     *    </pre>
     * @return
     *     {@link OpenStackNetworkProvider }
     *
     * @throws ClientProtocolException
     *             Signals that HTTP/S protocol error has occurred.
     * @throws ServerException
     *             Signals that an oVirt api error has occurred.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred.
     */
    public OpenStackNetworkProvider update(Boolean async, String correlationId, String expect) throws ClientProtocolException,
            ServerException, IOException {
        String url = this.getHref();

        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();

        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }

        url = urlBuilder.build();

        return getProxy().update(
                url,
                this,
                org.ovirt.engine.sdk.entities.OpenStackNetworkProvider.class,
                OpenStackNetworkProvider.class,
                headers);
    }

}
