/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.ProductInfoContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlVersionReader;
import org.ovirt.engine.sdk4.types.ProductInfo;

public class XmlProductInfoReader {
    public static ProductInfo readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        ProductInfoContainer object = new ProductInfoContainer();
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block14: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "instance_id": {
                    object.instanceId(reader.readString());
                    continue block14;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block14;
                }
                case "vendor": {
                    object.vendor(reader.readString());
                    continue block14;
                }
                case "version": {
                    object.version(XmlVersionReader.readOne(reader));
                    continue block14;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block14;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlProductInfoReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<ProductInfo> iterateMany(final XmlReader reader) {
        return new Iterator<ProductInfo>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public ProductInfo next() {
                ProductInfo next = XmlProductInfoReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<ProductInfo> readMany(XmlReader reader) {
        ArrayList<ProductInfo> list = new ArrayList<ProductInfo>();
        Iterator<ProductInfo> iterator = XmlProductInfoReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(ProductInfoContainer object, String[] link) {
    }
}

