/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.OpenStackImageProviderContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlCertificateReader;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackImageReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPropertyReader;
import org.ovirt.engine.sdk4.types.Certificate;
import org.ovirt.engine.sdk4.types.OpenStackImage;
import org.ovirt.engine.sdk4.types.OpenStackImageProvider;

public class XmlOpenStackImageProviderReader {
    public static OpenStackImageProvider readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        OpenStackImageProviderContainer object = new OpenStackImageProviderContainer();
        block38: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block38;
                }
                case "id": {
                    object.id(image);
                    continue block38;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block39: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "authentication_url": {
                    object.authenticationUrl(reader.readString());
                    continue block39;
                }
                case "certificates": {
                    object.certificates(XmlCertificateReader.readMany(reader));
                    continue block39;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block39;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block39;
                }
                case "images": {
                    object.images(XmlOpenStackImageReader.readMany(reader));
                    continue block39;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block39;
                }
                case "password": {
                    object.password(reader.readString());
                    continue block39;
                }
                case "properties": {
                    object.properties(XmlPropertyReader.readMany(reader));
                    continue block39;
                }
                case "requires_authentication": {
                    object.requiresAuthentication(reader.readBoolean());
                    continue block39;
                }
                case "tenant_name": {
                    object.tenantName(reader.readString());
                    continue block39;
                }
                case "url": {
                    object.url(reader.readString());
                    continue block39;
                }
                case "username": {
                    object.username(reader.readString());
                    continue block39;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block39;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlOpenStackImageProviderReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<OpenStackImageProvider> iterateMany(final XmlReader reader) {
        return new Iterator<OpenStackImageProvider>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public OpenStackImageProvider next() {
                OpenStackImageProvider next = XmlOpenStackImageProviderReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<OpenStackImageProvider> readMany(XmlReader reader) {
        ArrayList<OpenStackImageProvider> list = new ArrayList<OpenStackImageProvider>();
        Iterator<OpenStackImageProvider> iterator = XmlOpenStackImageProviderReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(OpenStackImageProviderContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "certificates": {
                    ArrayListWithHref<Certificate> list = new ArrayListWithHref<Certificate>(object.certificates());
                    list.href(href);
                    object.certificates(list);
                    break;
                }
                case "images": {
                    ArrayListWithHref<OpenStackImage> list = new ArrayListWithHref<OpenStackImage>(object.images());
                    list.href(href);
                    object.images(list);
                    break;
                }
            }
        }
    }
}

