/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.MacPoolContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlPermissionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlRangeReader;
import org.ovirt.engine.sdk4.types.MacPool;
import org.ovirt.engine.sdk4.types.Permission;

public class XmlMacPoolReader {
    public static MacPool readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        MacPoolContainer object = new MacPoolContainer();
        block28: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block28;
                }
                case "id": {
                    object.id(image);
                    continue block28;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block29: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "allow_duplicates": {
                    object.allowDuplicates(reader.readBoolean());
                    continue block29;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block29;
                }
                case "default_pool": {
                    object.defaultPool(reader.readBoolean());
                    continue block29;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block29;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block29;
                }
                case "permissions": {
                    object.permissions(XmlPermissionReader.readMany(reader));
                    continue block29;
                }
                case "ranges": {
                    object.ranges(XmlRangeReader.readMany(reader));
                    continue block29;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block29;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlMacPoolReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<MacPool> iterateMany(final XmlReader reader) {
        return new Iterator<MacPool>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public MacPool next() {
                MacPool next = XmlMacPoolReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<MacPool> readMany(XmlReader reader) {
        ArrayList<MacPool> list = new ArrayList<MacPool>();
        Iterator<MacPool> iterator = XmlMacPoolReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(MacPoolContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "permissions": {
                    ArrayListWithHref<Permission> list = new ArrayListWithHref<Permission>(object.permissions());
                    list.href(href);
                    object.permissions(list);
                    break;
                }
            }
        }
    }
}

