/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.DomainUserServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlUserReader;
import org.ovirt.engine.sdk4.services.DomainUserService;
import org.ovirt.engine.sdk4.services.DomainUsersService;
import org.ovirt.engine.sdk4.types.User;

public class DomainUsersServiceImpl
extends ServiceImpl
implements DomainUsersService {
    public DomainUsersServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public DomainUsersService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public DomainUserService userService(String id) {
        return new DomainUserServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.userService(path);
        }
        return this.userService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "DomainUsersService:" + this.getPath();
    }

    private class ListResponseImpl
    implements DomainUsersService.ListResponse {
        private List<User> users;

        private ListResponseImpl() {
        }

        public void users(List<User> users) {
            this.users = users;
        }

        @Override
        public List<User> users() {
            return this.users;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<DomainUsersService.ListRequest, DomainUsersService.ListResponse>
    implements DomainUsersService.ListRequest {
        private Boolean caseSensitive;
        private String follow;
        private BigInteger max;
        private String search;

        private ListRequestImpl() {
        }

        @Override
        public DomainUsersService.ListRequest caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        @Override
        public DomainUsersService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public DomainUsersService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public DomainUsersService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public DomainUsersService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public DomainUsersService.ListRequest search(String search) {
            this.search = search;
            return this;
        }

        @Override
        public DomainUsersService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(DomainUsersServiceImpl.this.getConnection().getUrl() + DomainUsersServiceImpl.this.getPath());
                if (this.caseSensitive != null) {
                    uriBuilder.addParameter("case_sensitive", XmlWriter.renderBoolean(this.caseSensitive));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.search != null) {
                    uriBuilder.addParameter("search", XmlWriter.renderString(this.search));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = DomainUsersServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.users(XmlUserReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            DomainUsersServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }
}

