/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BootDevice {
    CDROM("cdrom"),
    HD("hd"),
    NETWORK("network");

    private static final Logger log;
    private String image;

    private BootDevice(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static BootDevice fromValue(String value) {
        try {
            return BootDevice.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'BootDevice' enumerated type. Valid values are 'cdrom', 'hd' and 'network'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(BootDevice.class);
    }
}

