/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.internal.containers.VolumeGroupContainer;
import org.ovirt.engine.sdk4.types.LogicalUnit;
import org.ovirt.engine.sdk4.types.VolumeGroup;

public class VolumeGroupBuilder {
    private String id;
    private List<LogicalUnit> logicalUnits;
    private String name;
    
    public VolumeGroupBuilder id(String newId) {
        id = newId;
        return this;
    }
    
    
    public VolumeGroupBuilder logicalUnits(List<LogicalUnit> newLogicalUnits) {
        if (newLogicalUnits != null) {
            if (logicalUnits == null) {
                logicalUnits = new ArrayList<>(newLogicalUnits);
            }
            else {
                logicalUnits.addAll(newLogicalUnits);
            }
        }
        return this;
    }
    
    public VolumeGroupBuilder logicalUnits(LogicalUnit... newLogicalUnits) {
        if (newLogicalUnits != null) {
            if (logicalUnits == null) {
                logicalUnits = new ArrayList<>(newLogicalUnits.length);
            }
            Collections.addAll(logicalUnits, newLogicalUnits);
        }
        return this;
    }
    
    public VolumeGroupBuilder logicalUnits(LogicalUnitBuilder... newLogicalUnits) {
        if (newLogicalUnits != null) {
            if (logicalUnits == null) {
                logicalUnits = new ArrayList<>(newLogicalUnits.length);
            }
            for (LogicalUnitBuilder builder : newLogicalUnits) {
                logicalUnits.add(builder.build());
            }
        }
        return this;
    }
    
    
    public VolumeGroupBuilder name(String newName) {
        name = newName;
        return this;
    }
    
    
    public VolumeGroup build() {
        VolumeGroupContainer container = new VolumeGroupContainer();
        container.id(id);
        container.logicalUnits(logicalUnits);
        container.name(name);
        return container;
    }
}
