/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.CdromBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlCdromReader;
import org.ovirt.engine.sdk4.internal.xml.XmlCdromWriter;
import org.ovirt.engine.sdk4.services.VmCdromService;
import org.ovirt.engine.sdk4.types.Cdrom;

public class VmCdromServiceImpl
extends ServiceImpl
implements VmCdromService {
    public VmCdromServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public VmCdromService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public VmCdromService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "VmCdromService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements VmCdromService.UpdateResponse {
        private Cdrom cdrom;

        private UpdateResponseImpl() {
        }

        public void cdrom(Cdrom cdrom) {
            this.cdrom = cdrom;
        }

        @Override
        public Cdrom cdrom() {
            return this.cdrom;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<VmCdromService.UpdateRequest, VmCdromService.UpdateResponse>
    implements VmCdromService.UpdateRequest {
        private Cdrom cdrom;
        private Boolean current;

        private UpdateRequestImpl() {
        }

        @Override
        public VmCdromService.UpdateRequest cdrom(Cdrom cdrom) {
            this.cdrom = cdrom;
            return this;
        }

        @Override
        public VmCdromService.UpdateRequest cdrom(CdromBuilder cdrom) {
            this.cdrom = cdrom.build();
            return this;
        }

        @Override
        public VmCdromService.UpdateRequest current(Boolean current) {
            this.current = current;
            return this;
        }

        @Override
        public VmCdromService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmCdromServiceImpl.this.getConnection().getUrl() + VmCdromServiceImpl.this.getPath());
                if (this.current != null) {
                    uriBuilder.addParameter("current", XmlWriter.renderBoolean(this.current));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlCdromWriter.writeOne(this.cdrom, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmCdromServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.cdrom(XmlCdromReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmCdromServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class GetResponseImpl
    implements VmCdromService.GetResponse {
        private Cdrom cdrom;

        private GetResponseImpl() {
        }

        public void cdrom(Cdrom cdrom) {
            this.cdrom = cdrom;
        }

        @Override
        public Cdrom cdrom() {
            return this.cdrom;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<VmCdromService.GetRequest, VmCdromService.GetResponse>
    implements VmCdromService.GetRequest {
        private Boolean current;
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public VmCdromService.GetRequest current(Boolean current) {
            this.current = current;
            return this;
        }

        @Override
        public VmCdromService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public VmCdromService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmCdromServiceImpl.this.getConnection().getUrl() + VmCdromServiceImpl.this.getPath());
                if (this.current != null) {
                    uriBuilder.addParameter("current", XmlWriter.renderBoolean(this.current));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmCdromServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.cdrom(XmlCdromReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmCdromServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

