/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import org.ovirt.engine.sdk4.builders.IpBuilder;
import org.ovirt.engine.sdk4.internal.containers.NicConfigurationContainer;
import org.ovirt.engine.sdk4.types.BootProtocol;
import org.ovirt.engine.sdk4.types.Ip;
import org.ovirt.engine.sdk4.types.NicConfiguration;

public class NicConfigurationBuilder {
    private BootProtocol bootProtocol;
    private Ip ip;
    private Ip ipv6;
    private BootProtocol ipv6BootProtocol;
    private String name;
    private Boolean onBoot;

    public NicConfigurationBuilder bootProtocol(BootProtocol newBootProtocol) {
        this.bootProtocol = newBootProtocol;
        return this;
    }

    public NicConfigurationBuilder ip(Ip newIp) {
        this.ip = newIp;
        return this;
    }

    public NicConfigurationBuilder ip(IpBuilder newIp) {
        this.ip = newIp == null ? null : newIp.build();
        return this;
    }

    public NicConfigurationBuilder ipv6(Ip newIpv6) {
        this.ipv6 = newIpv6;
        return this;
    }

    public NicConfigurationBuilder ipv6(IpBuilder newIpv6) {
        this.ipv6 = newIpv6 == null ? null : newIpv6.build();
        return this;
    }

    public NicConfigurationBuilder ipv6BootProtocol(BootProtocol newIpv6BootProtocol) {
        this.ipv6BootProtocol = newIpv6BootProtocol;
        return this;
    }

    public NicConfigurationBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public NicConfigurationBuilder onBoot(boolean newOnBoot) {
        this.onBoot = newOnBoot;
        return this;
    }

    public NicConfigurationBuilder onBoot(Boolean newOnBoot) {
        this.onBoot = newOnBoot;
        return this;
    }

    public NicConfiguration build() {
        NicConfigurationContainer container = new NicConfigurationContainer();
        container.bootProtocol(this.bootProtocol);
        container.ip(this.ip);
        container.ipv6(this.ipv6);
        container.ipv6BootProtocol(this.ipv6BootProtocol);
        container.name(this.name);
        container.onBoot(this.onBoot);
        return container;
    }
}

