/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.internal.containers.StorageConnectionContainer;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.NfsVersion;
import org.ovirt.engine.sdk4.types.StorageConnection;
import org.ovirt.engine.sdk4.types.StorageType;

public class StorageConnectionBuilder {
    private String address;
    private String comment;
    private String description;
    private Host host;
    private String href;
    private String id;
    private String mountOptions;
    private String name;
    private BigInteger nfsRetrans;
    private BigInteger nfsTimeo;
    private NfsVersion nfsVersion;
    private String password;
    private String path;
    private BigInteger port;
    private String portal;
    private String target;
    private StorageType type;
    private String username;
    private String vfsType;

    public StorageConnectionBuilder address(String newAddress) {
        this.address = newAddress;
        return this;
    }

    public StorageConnectionBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public StorageConnectionBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public StorageConnectionBuilder host(Host newHost) {
        this.host = newHost;
        return this;
    }

    public StorageConnectionBuilder host(HostBuilder newHost) {
        this.host = newHost == null ? null : newHost.build();
        return this;
    }

    public StorageConnectionBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public StorageConnectionBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public StorageConnectionBuilder mountOptions(String newMountOptions) {
        this.mountOptions = newMountOptions;
        return this;
    }

    public StorageConnectionBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public StorageConnectionBuilder nfsRetrans(int newNfsRetrans) {
        this.nfsRetrans = BigInteger.valueOf(newNfsRetrans);
        return this;
    }

    public StorageConnectionBuilder nfsRetrans(Integer newNfsRetrans) {
        this.nfsRetrans = newNfsRetrans == null ? null : BigInteger.valueOf(newNfsRetrans.longValue());
        return this;
    }

    public StorageConnectionBuilder nfsRetrans(long newNfsRetrans) {
        this.nfsRetrans = BigInteger.valueOf(newNfsRetrans);
        return this;
    }

    public StorageConnectionBuilder nfsRetrans(Long newNfsRetrans) {
        this.nfsRetrans = newNfsRetrans == null ? null : BigInteger.valueOf(newNfsRetrans);
        return this;
    }

    public StorageConnectionBuilder nfsRetrans(BigInteger newNfsRetrans) {
        this.nfsRetrans = newNfsRetrans;
        return this;
    }

    public StorageConnectionBuilder nfsTimeo(int newNfsTimeo) {
        this.nfsTimeo = BigInteger.valueOf(newNfsTimeo);
        return this;
    }

    public StorageConnectionBuilder nfsTimeo(Integer newNfsTimeo) {
        this.nfsTimeo = newNfsTimeo == null ? null : BigInteger.valueOf(newNfsTimeo.longValue());
        return this;
    }

    public StorageConnectionBuilder nfsTimeo(long newNfsTimeo) {
        this.nfsTimeo = BigInteger.valueOf(newNfsTimeo);
        return this;
    }

    public StorageConnectionBuilder nfsTimeo(Long newNfsTimeo) {
        this.nfsTimeo = newNfsTimeo == null ? null : BigInteger.valueOf(newNfsTimeo);
        return this;
    }

    public StorageConnectionBuilder nfsTimeo(BigInteger newNfsTimeo) {
        this.nfsTimeo = newNfsTimeo;
        return this;
    }

    public StorageConnectionBuilder nfsVersion(NfsVersion newNfsVersion) {
        this.nfsVersion = newNfsVersion;
        return this;
    }

    public StorageConnectionBuilder password(String newPassword) {
        this.password = newPassword;
        return this;
    }

    public StorageConnectionBuilder path(String newPath) {
        this.path = newPath;
        return this;
    }

    public StorageConnectionBuilder port(int newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public StorageConnectionBuilder port(Integer newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort.longValue());
        return this;
    }

    public StorageConnectionBuilder port(long newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public StorageConnectionBuilder port(Long newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort);
        return this;
    }

    public StorageConnectionBuilder port(BigInteger newPort) {
        this.port = newPort;
        return this;
    }

    public StorageConnectionBuilder portal(String newPortal) {
        this.portal = newPortal;
        return this;
    }

    public StorageConnectionBuilder target(String newTarget) {
        this.target = newTarget;
        return this;
    }

    public StorageConnectionBuilder type(StorageType newType) {
        this.type = newType;
        return this;
    }

    public StorageConnectionBuilder username(String newUsername) {
        this.username = newUsername;
        return this;
    }

    public StorageConnectionBuilder vfsType(String newVfsType) {
        this.vfsType = newVfsType;
        return this;
    }

    public StorageConnection build() {
        StorageConnectionContainer container = new StorageConnectionContainer();
        container.address(this.address);
        container.comment(this.comment);
        container.description(this.description);
        container.host(this.host);
        container.href(this.href);
        container.id(this.id);
        container.mountOptions(this.mountOptions);
        container.name(this.name);
        container.nfsRetrans(this.nfsRetrans);
        container.nfsTimeo(this.nfsTimeo);
        container.nfsVersion(this.nfsVersion);
        container.password(this.password);
        container.path(this.path);
        container.port(this.port);
        container.portal(this.portal);
        container.target(this.target);
        container.type(this.type);
        container.username(this.username);
        container.vfsType(this.vfsType);
        return container;
    }
}

