/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import org.ovirt.engine.sdk4.types.ExternalComputeResource;
import org.ovirt.engine.sdk4.types.ExternalHostProvider;

public class ExternalComputeResourceContainer extends IdentifiedContainer implements ExternalComputeResource {
    private String provider;
    private String url;
    private String user;
    private ExternalHostProvider externalHostProvider;
    
    public String provider() {
        return provider;
    }
    
    public void provider(String newProvider) {
        provider = newProvider;
    }
    
    public boolean providerPresent() {
        return provider != null;
    }
    
    public String url() {
        return url;
    }
    
    public void url(String newUrl) {
        url = newUrl;
    }
    
    public boolean urlPresent() {
        return url != null;
    }
    
    public String user() {
        return user;
    }
    
    public void user(String newUser) {
        user = newUser;
    }
    
    public boolean userPresent() {
        return user != null;
    }
    
    public ExternalHostProvider externalHostProvider() {
        return externalHostProvider;
    }
    
    public void externalHostProvider(ExternalHostProvider newExternalHostProvider) {
        externalHostProvider = newExternalHostProvider;
    }
    
    public boolean externalHostProviderPresent() {
        return externalHostProvider != null;
    }
    
}
