/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import java.util.List;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.CertificateBuilder;
import org.ovirt.engine.sdk4.types.Certificate;

public interface ExternalProviderService extends Service {
    public interface ImportCertificatesRequest extends Request<ImportCertificatesRequest, ImportCertificatesResponse> {
        ImportCertificatesRequest certificates(List<Certificate> certificates);
        ImportCertificatesRequest certificates(Certificate... certificates);
        ImportCertificatesRequest certificates(CertificateBuilder... certificates);
    }
    
    public interface ImportCertificatesResponse extends Response {
    }
    
    ImportCertificatesRequest importCertificates();
    
    public interface TestConnectivityRequest extends Request<TestConnectivityRequest, TestConnectivityResponse> {
        /**
         * Indicates if the test should be performed asynchronously.
         */
        TestConnectivityRequest async(Boolean async);
    }
    
    public interface TestConnectivityResponse extends Response {
    }
    
    TestConnectivityRequest testConnectivity();
    
    ExternalProviderCertificatesService certificatesService();
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

