/*
 * KubeVirt API
 * This is KubeVirt API an add-on for Kubernetes.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: kubevirt-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package kubevirt.io;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kubevirt.io.V1VirtualMachineCondition;
import kubevirt.io.V1VirtualMachineStateChangeRequest;

/**
 * VirtualMachineStatus represents the status returned by the controller to describe how the VirtualMachine is doing
 */
@ApiModel(description = "VirtualMachineStatus represents the status returned by the controller to describe how the VirtualMachine is doing")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-11-10T14:44:51.030+02:00")
public class V1VirtualMachineStatus {
  @SerializedName("conditions")
  private List<V1VirtualMachineCondition> conditions = null;

  @SerializedName("created")
  private Boolean created = null;

  @SerializedName("ready")
  private Boolean ready = null;

  @SerializedName("stateChangeRequests")
  private List<V1VirtualMachineStateChangeRequest> stateChangeRequests = null;

  public V1VirtualMachineStatus conditions(List<V1VirtualMachineCondition> conditions) {
    this.conditions = conditions;
    return this;
  }

  public V1VirtualMachineStatus addConditionsItem(V1VirtualMachineCondition conditionsItem) {
    if (this.conditions == null) {
      this.conditions = new ArrayList<>();
    }
    this.conditions.add(conditionsItem);
    return this;
  }

   /**
   * Hold the state information of the VirtualMachine and its VirtualMachineInstance
   * @return conditions
  **/
  @ApiModelProperty(value = "Hold the state information of the VirtualMachine and its VirtualMachineInstance")
  public List<V1VirtualMachineCondition> getConditions() {
    return conditions;
  }

  public void setConditions(List<V1VirtualMachineCondition> conditions) {
    this.conditions = conditions;
  }

  public V1VirtualMachineStatus created(Boolean created) {
    this.created = created;
    return this;
  }

   /**
   * Created indicates if the virtual machine is created in the cluster
   * @return created
  **/
  @ApiModelProperty(value = "Created indicates if the virtual machine is created in the cluster")
  public Boolean isCreated() {
    return created;
  }

  public void setCreated(Boolean created) {
    this.created = created;
  }

  public V1VirtualMachineStatus ready(Boolean ready) {
    this.ready = ready;
    return this;
  }

   /**
   * Ready indicates if the virtual machine is running and ready
   * @return ready
  **/
  @ApiModelProperty(value = "Ready indicates if the virtual machine is running and ready")
  public Boolean isReady() {
    return ready;
  }

  public void setReady(Boolean ready) {
    this.ready = ready;
  }

  public V1VirtualMachineStatus stateChangeRequests(List<V1VirtualMachineStateChangeRequest> stateChangeRequests) {
    this.stateChangeRequests = stateChangeRequests;
    return this;
  }

  public V1VirtualMachineStatus addStateChangeRequestsItem(V1VirtualMachineStateChangeRequest stateChangeRequestsItem) {
    if (this.stateChangeRequests == null) {
      this.stateChangeRequests = new ArrayList<>();
    }
    this.stateChangeRequests.add(stateChangeRequestsItem);
    return this;
  }

   /**
   * StateChangeRequests indicates a list of actions that should be taken on a VMI e.g. stop a specific VMI then start a new one.
   * @return stateChangeRequests
  **/
  @ApiModelProperty(value = "StateChangeRequests indicates a list of actions that should be taken on a VMI e.g. stop a specific VMI then start a new one.")
  public List<V1VirtualMachineStateChangeRequest> getStateChangeRequests() {
    return stateChangeRequests;
  }

  public void setStateChangeRequests(List<V1VirtualMachineStateChangeRequest> stateChangeRequests) {
    this.stateChangeRequests = stateChangeRequests;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1VirtualMachineStatus v1VirtualMachineStatus = (V1VirtualMachineStatus) o;
    return Objects.equals(this.conditions, v1VirtualMachineStatus.conditions) &&
        Objects.equals(this.created, v1VirtualMachineStatus.created) &&
        Objects.equals(this.ready, v1VirtualMachineStatus.ready) &&
        Objects.equals(this.stateChangeRequests, v1VirtualMachineStatus.stateChangeRequests);
  }

  @Override
  public int hashCode() {
    return Objects.hash(conditions, created, ready, stateChangeRequests);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1VirtualMachineStatus {\n");
    
    sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    ready: ").append(toIndentedString(ready)).append("\n");
    sb.append("    stateChangeRequests: ").append(toIndentedString(stateChangeRequests)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

