--
-- PostgreSQL database dump
--

-- Dumped from database version 9.1.3
-- Dumped by pg_dump version 9.1.3
-- Started on 2013-04-12 17:03:12

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 202 (class 3079 OID 11639)
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- TOC entry 2152 (class 0 OID 0)
-- Dependencies: 202
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

SET default_with_oids = false;

--
-- TOC entry 178 (class 1259 OID 56581)
-- Dependencies: 5
-- Name: account; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE account (
    account_id integer NOT NULL,
    account_parent integer,
    account_description character varying(30),
    account_type character varying(30) NOT NULL,
    account_rollup character varying(30) NOT NULL,
    custom_members character varying(255)
);


--
-- TOC entry 171 (class 1259 OID 56560)
-- Dependencies: 5
-- Name: agg_c_10_sales_fact_1997; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE agg_c_10_sales_fact_1997 (
    month_of_year smallint NOT NULL,
    quarter character varying(30) NOT NULL,
    the_year smallint NOT NULL,
    store_sales numeric(10,4) NOT NULL,
    store_cost numeric(10,4) NOT NULL,
    unit_sales numeric(10,4) NOT NULL,
    customer_count integer NOT NULL,
    fact_count integer NOT NULL
);


--
-- TOC entry 172 (class 1259 OID 56563)
-- Dependencies: 5
-- Name: agg_c_14_sales_fact_1997; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE agg_c_14_sales_fact_1997 (
    product_id integer NOT NULL,
    customer_id integer NOT NULL,
    store_id integer NOT NULL,
    promotion_id integer NOT NULL,
    month_of_year smallint NOT NULL,
    quarter character varying(30) NOT NULL,
    the_year smallint NOT NULL,
    store_sales numeric(10,4) NOT NULL,
    store_cost numeric(10,4) NOT NULL,
    unit_sales numeric(10,4) NOT NULL,
    fact_count integer NOT NULL
);


--
-- TOC entry 174 (class 1259 OID 56569)
-- Dependencies: 5
-- Name: agg_c_special_sales_fact_1997; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE agg_c_special_sales_fact_1997 (
    product_id integer NOT NULL,
    promotion_id integer NOT NULL,
    customer_id integer NOT NULL,
    store_id integer NOT NULL,
    time_month smallint NOT NULL,
    time_quarter character varying(30) NOT NULL,
    time_year smallint NOT NULL,
    store_sales_sum numeric(10,4) NOT NULL,
    store_cost_sum numeric(10,4) NOT NULL,
    unit_sales_sum numeric(10,4) NOT NULL,
    fact_count integer NOT NULL
);


--
-- TOC entry 175 (class 1259 OID 56572)
-- Dependencies: 5
-- Name: agg_g_ms_pcat_sales_fact_1997; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE agg_g_ms_pcat_sales_fact_1997 (
    gender character varying(30) NOT NULL,
    marital_status character varying(30) NOT NULL,
    product_family character varying(30),
    product_department character varying(30),
    product_category character varying(30),
    month_of_year smallint NOT NULL,
    quarter character varying(30) NOT NULL,
    the_year smallint NOT NULL,
    store_sales numeric(10,4) NOT NULL,
    store_cost numeric(10,4) NOT NULL,
    unit_sales numeric(10,4) NOT NULL,
    customer_count integer NOT NULL,
    fact_count integer NOT NULL
);


--
-- TOC entry 168 (class 1259 OID 56551)
-- Dependencies: 5
-- Name: agg_l_03_sales_fact_1997; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE agg_l_03_sales_fact_1997 (
    time_id integer NOT NULL,
    customer_id integer NOT NULL,
    store_sales numeric(10,4) NOT NULL,
    store_cost numeric(10,4) NOT NULL,
    unit_sales numeric(10,4) NOT NULL,
    fact_count integer NOT NULL
);


--
-- TOC entry 169 (class 1259 OID 56554)
-- Dependencies: 5
-- Name: agg_l_04_sales_fact_1997; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE agg_l_04_sales_fact_1997 (
    time_id integer NOT NULL,
    store_sales numeric(10,4) NOT NULL,
    store_cost numeric(10,4) NOT NULL,
    unit_sales numeric(10,4) NOT NULL,
    customer_count integer NOT NULL,
    fact_count integer NOT NULL
);


--
-- TOC entry 170 (class 1259 OID 56557)
-- Dependencies: 5
-- Name: agg_l_05_sales_fact_1997; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE agg_l_05_sales_fact_1997 (
    product_id integer NOT NULL,
    customer_id integer NOT NULL,
    promotion_id integer NOT NULL,
    store_id integer NOT NULL,
    store_sales numeric(10,4) NOT NULL,
    store_cost numeric(10,4) NOT NULL,
    unit_sales numeric(10,4) NOT NULL,
    fact_count integer NOT NULL
);


--
-- TOC entry 176 (class 1259 OID 56575)
-- Dependencies: 5
-- Name: agg_lc_06_sales_fact_1997; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE agg_lc_06_sales_fact_1997 (
    time_id integer NOT NULL,
    city character varying(30) NOT NULL,
    state_province character varying(30) NOT NULL,
    country character varying(30) NOT NULL,
    store_sales numeric(10,4) NOT NULL,
    store_cost numeric(10,4) NOT NULL,
    unit_sales numeric(10,4) NOT NULL,
    fact_count integer NOT NULL
);


--
-- TOC entry 173 (class 1259 OID 56566)
-- Dependencies: 5
-- Name: agg_lc_100_sales_fact_1997; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE agg_lc_100_sales_fact_1997 (
    product_id integer NOT NULL,
    customer_id integer NOT NULL,
    quarter character varying(30) NOT NULL,
    the_year smallint NOT NULL,
    store_sales numeric(10,4) NOT NULL,
    store_cost numeric(10,4) NOT NULL,
    unit_sales numeric(10,4) NOT NULL,
    fact_count integer NOT NULL
);


--
-- TOC entry 167 (class 1259 OID 56548)
-- Dependencies: 5
-- Name: agg_ll_01_sales_fact_1997; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE agg_ll_01_sales_fact_1997 (
    product_id integer NOT NULL,
    time_id integer NOT NULL,
    customer_id integer NOT NULL,
    store_sales numeric(10,4) NOT NULL,
    store_cost numeric(10,4) NOT NULL,
    unit_sales numeric(10,4) NOT NULL,
    fact_count integer NOT NULL
);


--
-- TOC entry 166 (class 1259 OID 56545)
-- Dependencies: 5
-- Name: agg_pl_01_sales_fact_1997; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE agg_pl_01_sales_fact_1997 (
    product_id integer NOT NULL,
    time_id integer NOT NULL,
    customer_id integer NOT NULL,
    store_sales_sum numeric(10,4) NOT NULL,
    store_cost_sum numeric(10,4) NOT NULL,
    unit_sales_sum numeric(10,4) NOT NULL,
    fact_count integer NOT NULL
);


--
-- TOC entry 179 (class 1259 OID 56584)
-- Dependencies: 5
-- Name: category; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE category (
    category_id character varying(30) NOT NULL,
    category_parent character varying(30),
    category_description character varying(30) NOT NULL,
    category_rollup character varying(30)
);


--
-- TOC entry 177 (class 1259 OID 56578)
-- Dependencies: 5
-- Name: currency; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE currency (
    currency_id integer NOT NULL,
    date date NOT NULL,
    currency character varying(30) NOT NULL,
    conversion_ratio numeric(10,4) NOT NULL
);


--
-- TOC entry 180 (class 1259 OID 56587)
-- Dependencies: 5
-- Name: customer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE customer (
    customer_id integer NOT NULL,
    account_num bigint NOT NULL,
    lname character varying(30) NOT NULL,
    fname character varying(30) NOT NULL,
    mi character varying(30),
    address1 character varying(30),
    address2 character varying(30),
    address3 character varying(30),
    address4 character varying(30),
    city character varying(30),
    state_province character varying(30),
    postal_code character varying(30) NOT NULL,
    country character varying(30) NOT NULL,
    customer_region_id integer NOT NULL,
    phone1 character varying(30) NOT NULL,
    phone2 character varying(30) NOT NULL,
    birthdate date NOT NULL,
    marital_status character varying(30) NOT NULL,
    yearly_income character varying(30) NOT NULL,
    gender character varying(30) NOT NULL,
    total_children smallint NOT NULL,
    num_children_at_home smallint NOT NULL,
    education character varying(30) NOT NULL,
    date_accnt_opened date NOT NULL,
    member_card character varying(30),
    occupation character varying(30),
    houseowner character varying(30),
    num_cars_owned integer,
    fullname character varying(60) NOT NULL
);


--
-- TOC entry 200 (class 1259 OID 56757)
-- Dependencies: 5
-- Name: customer_sales; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE customer_sales (
    customer_fullname character varying(60),
    store_sales numeric,
    customer_id integer
);


--
-- TOC entry 181 (class 1259 OID 56593)
-- Dependencies: 5
-- Name: days; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE days (
    day integer NOT NULL,
    week_day character varying(30) NOT NULL
);


--
-- TOC entry 182 (class 1259 OID 56596)
-- Dependencies: 5
-- Name: department; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE department (
    department_id integer NOT NULL,
    department_description character varying(30) NOT NULL
);


--
-- TOC entry 183 (class 1259 OID 56599)
-- Dependencies: 5
-- Name: employee; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE employee (
    employee_id integer NOT NULL,
    full_name character varying(30) NOT NULL,
    first_name character varying(30) NOT NULL,
    last_name character varying(30) NOT NULL,
    position_id integer,
    position_title character varying(30),
    store_id integer NOT NULL,
    department_id integer NOT NULL,
    birth_date date NOT NULL,
    hire_date timestamp without time zone,
    end_date timestamp without time zone,
    salary numeric(10,4) NOT NULL,
    supervisor_id integer,
    education_level character varying(30) NOT NULL,
    marital_status character varying(30) NOT NULL,
    gender character varying(30) NOT NULL,
    management_role character varying(30)
);


--
-- TOC entry 184 (class 1259 OID 56602)
-- Dependencies: 5
-- Name: employee_closure; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE employee_closure (
    employee_id integer NOT NULL,
    supervisor_id integer NOT NULL,
    distance integer
);


--
-- TOC entry 185 (class 1259 OID 56605)
-- Dependencies: 5
-- Name: expense_fact; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE expense_fact (
    store_id integer NOT NULL,
    account_id integer NOT NULL,
    exp_date timestamp without time zone NOT NULL,
    time_id integer NOT NULL,
    category_id character varying(30) NOT NULL,
    currency_id integer NOT NULL,
    amount numeric(10,4) NOT NULL
);


--
-- TOC entry 164 (class 1259 OID 56539)
-- Dependencies: 5
-- Name: inventory_fact_1997; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE inventory_fact_1997 (
    product_id integer NOT NULL,
    time_id integer,
    warehouse_id integer,
    store_id integer,
    units_ordered integer,
    units_shipped integer,
    warehouse_sales numeric(10,4),
    warehouse_cost numeric(10,4),
    supply_time smallint,
    store_invoice numeric(10,4)
);


--
-- TOC entry 165 (class 1259 OID 56542)
-- Dependencies: 5
-- Name: inventory_fact_1998; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE inventory_fact_1998 (
    product_id integer NOT NULL,
    time_id integer,
    warehouse_id integer,
    store_id integer,
    units_ordered integer,
    units_shipped integer,
    warehouse_sales numeric(10,4),
    warehouse_cost numeric(10,4),
    supply_time smallint,
    store_invoice numeric(10,4)
);


--
-- TOC entry 198 (class 1259 OID 56745)
-- Dependencies: 5
-- Name: monthly_profit; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE monthly_profit (
    the_date timestamp without time zone,
    the_year smallint,
    the_month character varying(30),
    the_quarter character varying(30),
    time_by_day_month_of_year smallint,
    store_sales numeric,
    profit numeric,
    store_state character varying(30)
);


--
-- TOC entry 186 (class 1259 OID 56608)
-- Dependencies: 5
-- Name: position; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE "position" (
    position_id integer NOT NULL,
    position_title character varying(30) NOT NULL,
    pay_type character varying(30) NOT NULL,
    min_scale numeric(10,4) NOT NULL,
    max_scale numeric(10,4) NOT NULL,
    management_role character varying(30) NOT NULL
);


--
-- TOC entry 187 (class 1259 OID 56611)
-- Dependencies: 5
-- Name: product; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE product (
    product_class_id integer NOT NULL,
    product_id integer NOT NULL,
    brand_name character varying(60),
    product_name character varying(60) NOT NULL,
    sku bigint NOT NULL,
    srp numeric(10,4),
    gross_weight real,
    net_weight real,
    recyclable_package boolean,
    low_fat boolean,
    units_per_case smallint,
    cases_per_pallet smallint,
    shelf_width real,
    shelf_height real,
    shelf_depth real
);


--
-- TOC entry 188 (class 1259 OID 56614)
-- Dependencies: 5
-- Name: product_class; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE product_class (
    product_class_id integer NOT NULL,
    product_subcategory character varying(30),
    product_category character varying(30),
    product_department character varying(30),
    product_family character varying(30)
);


--
-- TOC entry 199 (class 1259 OID 56751)
-- Dependencies: 5
-- Name: product_sales; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE product_sales (
    product_product_name character varying(60),
    store_sales numeric,
    product_product_id integer
);


--
-- TOC entry 189 (class 1259 OID 56617)
-- Dependencies: 5
-- Name: promotion; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE promotion (
    promotion_id integer NOT NULL,
    promotion_district_id integer,
    promotion_name character varying(30),
    media_type character varying(30),
    cost numeric(10,4),
    start_date timestamp without time zone,
    end_date timestamp without time zone
);


--
-- TOC entry 201 (class 1259 OID 56763)
-- Dependencies: 5
-- Name: promotion_sales; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE promotion_sales (
    promotion_promotion_name character varying(30),
    store_sales numeric,
    promotion_promotion_id integer
);


--
-- TOC entry 190 (class 1259 OID 56620)
-- Dependencies: 5
-- Name: region; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE region (
    region_id integer NOT NULL,
    sales_city character varying(30),
    sales_state_province character varying(30),
    sales_district character varying(30),
    sales_region character varying(30),
    sales_country character varying(30),
    sales_district_id integer
);


--
-- TOC entry 191 (class 1259 OID 56623)
-- Dependencies: 5
-- Name: reserve_employee; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE reserve_employee (
    employee_id integer NOT NULL,
    full_name character varying(30) NOT NULL,
    first_name character varying(30) NOT NULL,
    last_name character varying(30) NOT NULL,
    position_id integer,
    position_title character varying(30),
    store_id integer NOT NULL,
    department_id integer NOT NULL,
    birth_date timestamp without time zone NOT NULL,
    hire_date timestamp without time zone,
    end_date timestamp without time zone,
    salary numeric(10,4) NOT NULL,
    supervisor_id integer,
    education_level character varying(30) NOT NULL,
    marital_status character varying(30) NOT NULL,
    gender character varying(30) NOT NULL
);


--
-- TOC entry 192 (class 1259 OID 56626)
-- Dependencies: 5
-- Name: salary; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE salary (
    pay_date timestamp without time zone NOT NULL,
    employee_id integer NOT NULL,
    department_id integer NOT NULL,
    currency_id integer NOT NULL,
    salary_paid numeric(10,4) NOT NULL,
    overtime_paid numeric(10,4) NOT NULL,
    vacation_accrued real NOT NULL,
    vacation_used real NOT NULL
);


--
-- TOC entry 161 (class 1259 OID 56530)
-- Dependencies: 5
-- Name: sales_fact_1997; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE sales_fact_1997 (
    product_id integer NOT NULL,
    time_id integer NOT NULL,
    customer_id integer NOT NULL,
    promotion_id integer NOT NULL,
    store_id integer NOT NULL,
    store_sales numeric(10,4) NOT NULL,
    store_cost numeric(10,4) NOT NULL,
    unit_sales numeric(10,4) NOT NULL
);


--
-- TOC entry 162 (class 1259 OID 56533)
-- Dependencies: 5
-- Name: sales_fact_1998; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE sales_fact_1998 (
    product_id integer NOT NULL,
    time_id integer NOT NULL,
    customer_id integer NOT NULL,
    promotion_id integer NOT NULL,
    store_id integer NOT NULL,
    store_sales numeric(10,4) NOT NULL,
    store_cost numeric(10,4) NOT NULL,
    unit_sales numeric(10,4) NOT NULL
);


--
-- TOC entry 163 (class 1259 OID 56536)
-- Dependencies: 5
-- Name: sales_fact_dec_1998; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE sales_fact_dec_1998 (
    product_id integer NOT NULL,
    time_id integer NOT NULL,
    customer_id integer NOT NULL,
    promotion_id integer NOT NULL,
    store_id integer NOT NULL,
    store_sales numeric(10,4) NOT NULL,
    store_cost numeric(10,4) NOT NULL,
    unit_sales numeric(10,4) NOT NULL
);


--
-- TOC entry 193 (class 1259 OID 56629)
-- Dependencies: 5
-- Name: store; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE store (
    store_id integer NOT NULL,
    store_type character varying(30),
    region_id integer,
    store_name character varying(30),
    store_number integer,
    store_street_address character varying(30),
    store_city character varying(30),
    store_state character varying(30),
    store_postal_code character varying(30),
    store_country character varying(30),
    store_manager character varying(30),
    store_phone character varying(30),
    store_fax character varying(30),
    first_opened_date timestamp without time zone,
    last_remodel_date timestamp without time zone,
    store_sqft integer,
    grocery_sqft integer,
    frozen_sqft integer,
    meat_sqft integer,
    coffee_bar boolean,
    video_store boolean,
    salad_bar boolean,
    prepared_food boolean,
    florist boolean
);


--
-- TOC entry 194 (class 1259 OID 56632)
-- Dependencies: 5
-- Name: store_ragged; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE store_ragged (
    store_id integer NOT NULL,
    store_type character varying(30),
    region_id integer,
    store_name character varying(30),
    store_number integer,
    store_street_address character varying(30),
    store_city character varying(30),
    store_state character varying(30),
    store_postal_code character varying(30),
    store_country character varying(30),
    store_manager character varying(30),
    store_phone character varying(30),
    store_fax character varying(30),
    first_opened_date timestamp without time zone,
    last_remodel_date timestamp without time zone,
    store_sqft integer,
    grocery_sqft integer,
    frozen_sqft integer,
    meat_sqft integer,
    coffee_bar boolean,
    video_store boolean,
    salad_bar boolean,
    prepared_food boolean,
    florist boolean
);


--
-- TOC entry 195 (class 1259 OID 56635)
-- Dependencies: 5
-- Name: time_by_day; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE time_by_day (
    time_id integer NOT NULL,
    the_date timestamp without time zone,
    the_day character varying(30),
    the_month character varying(30),
    the_year smallint,
    day_of_month smallint,
    week_of_year integer,
    month_of_year smallint,
    quarter character varying(30),
    fiscal_period character varying(30),
    day_of_week integer
);


--
-- TOC entry 196 (class 1259 OID 56638)
-- Dependencies: 5
-- Name: warehouse; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE warehouse (
    warehouse_id integer NOT NULL,
    warehouse_class_id integer,
    stores_id integer,
    warehouse_name character varying(60),
    wa_address1 character varying(30),
    wa_address2 character varying(30),
    wa_address3 character varying(30),
    wa_address4 character varying(30),
    warehouse_city character varying(30),
    warehouse_state_province character varying(30),
    warehouse_postal_code character varying(30),
    warehouse_country character varying(30),
    warehouse_owner_name character varying(30),
    warehouse_phone character varying(30),
    warehouse_fax character varying(30)
);


--
-- TOC entry 197 (class 1259 OID 56641)
-- Dependencies: 5
-- Name: warehouse_class; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE warehouse_class (
    warehouse_class_id integer NOT NULL,
    description character varying(30)
);


--
-- TOC entry 2124 (class 0 OID 56581)
-- Dependencies: 178
-- Data for Name: account; Type: TABLE DATA; Schema: public; Owner: -
--

COPY account (account_id, account_parent, account_description, account_type, account_rollup, custom_members) FROM stdin;
1000	\N	Assets	Asset	~	\N
2000	\N	Liabilities	Liability	~	\N
3000	5000	Net Sales	Income	+	\N
3100	3000	Gross Sales	Income	+	LookUpCube("[Sales]","(Measures.[Store Sales],"+time.currentmember.UniqueName+","+ Store.currentmember.UniqueName+")")
3200	3000	Cost of Goods Sold	Income	-	\N
4000	5000	Total Expense	Expense	-	\N
4100	4000	General & Administration	Expense	+	\N
4200	4000	Information Systems	Expense	+	\N
4300	4000	Marketing	Expense	+	\N
4400	4000	Lease	Expense	+	\N
5000	\N	Net Income	Income	+	\N
\.


--
-- TOC entry 2117 (class 0 OID 56560)
-- Dependencies: 171
-- Data for Name: agg_c_10_sales_fact_1997; Type: TABLE DATA; Schema: public; Owner: -
--

COPY agg_c_10_sales_fact_1997 (month_of_year, quarter, the_year, store_sales, store_cost, unit_sales, customer_count, fact_count) FROM stdin;
1	Q1	2012	45539.6900	18178.4926	21628.0000	1396	7034
2	Q1	2012	44058.7900	17599.6688	20957.0000	1331	6844
3	Q1	2012	50029.8700	19974.0791	23706.0000	1478	7710
4	Q2	2012	42878.2500	17111.6993	20179.0000	1317	6590
5	Q2	2012	44456.2900	17782.5557	21081.0000	1371	6866
6	Q2	2012	45331.7300	18069.9698	21350.0000	1336	6912
7	Q3	2012	50246.8800	20005.7910	23763.0000	1462	7752
8	Q3	2012	46199.0400	18435.9608	21697.0000	1408	7038
9	Q3	2012	43825.9700	17463.1176	20388.0000	1315	6663
10	Q4	2012	42342.2700	16902.0056	19958.0000	1293	6479
11	Q4	2012	53363.7100	21357.7586	25270.0000	1546	8232
12	Q4	2012	56965.6400	22746.1347	26796.0000	1694	8717
\.


--
-- TOC entry 2118 (class 0 OID 56563)
-- Dependencies: 172
-- Data for Name: agg_c_14_sales_fact_1997; Type: TABLE DATA; Schema: public; Owner: -
--

COPY agg_c_14_sales_fact_1997 (product_id, customer_id, store_id, promotion_id, month_of_year, quarter, the_year, store_sales, store_cost, unit_sales, fact_count) FROM stdin;
1	157	24	1869	12	Q4	2012	8.5500	2.9925	3.0000	1
1	456	15	0	6	Q2	2012	11.4000	4.3320	4.0000	1
1	638	11	0	9	Q3	2012	8.5500	2.9925	3.0000	1
1	916	7	0	4	Q2	2012	11.4000	4.9020	4.0000	1
1	923	15	0	7	Q3	2012	8.5500	2.7360	3.0000	1
1	1312	3	0	5	Q2	2012	8.5500	3.6765	3.0000	1
1	1565	24	0	9	Q3	2012	8.5500	4.1895	3.0000	1
1	2270	11	0	11	Q4	2012	8.5500	4.0185	3.0000	1
1	3065	3	0	11	Q4	2012	5.7000	2.5080	2.0000	1
1	3441	3	0	8	Q3	2012	8.5500	3.4200	3.0000	1
1	3528	17	0	10	Q4	2012	8.5500	3.8475	3.0000	1
1	4461	11	0	4	Q2	2012	8.5500	2.9925	3.0000	1
1	4707	11	0	12	Q4	2012	8.5500	4.0185	3.0000	1
1	4728	7	501	1	Q1	2012	11.4000	3.9900	4.0000	1
1	5313	24	0	3	Q1	2012	8.5500	3.7620	3.0000	1
1	5607	6	0	6	Q2	2012	11.4000	4.9020	4.0000	1
1	5929	15	0	8	Q3	2012	14.2500	5.5575	5.0000	1
1	6248	24	1860	8	Q3	2012	11.4000	3.8760	4.0000	1
1	6666	17	0	2	Q1	2012	8.5500	4.1895	3.0000	1
1	7704	3	0	7	Q3	2012	5.7000	2.5080	2.0000	1
1	8202	3	0	12	Q4	2012	8.5500	4.1040	3.0000	1
1	9169	23	0	5	Q2	2012	11.4000	5.3580	4.0000	1
1	9358	15	0	7	Q3	2012	8.5500	4.2750	3.0000	1
1	9652	14	0	9	Q3	2012	5.7000	1.8810	2.0000	1
1	9788	13	0	1	Q1	2012	8.5500	4.0185	3.0000	1
1	10140	17	0	9	Q3	2012	8.5500	2.9925	3.0000	1
2	430	16	0	5	Q2	2012	2.9600	1.3616	4.0000	1
2	647	3	0	12	Q4	2012	2.2200	0.7548	3.0000	1
2	650	11	0	10	Q4	2012	2.9600	1.3320	4.0000	1
2	663	16	1220	4	Q2	2012	2.2200	0.7770	3.0000	1
2	878	3	0	1	Q1	2012	2.2200	0.9546	3.0000	1
2	878	3	0	6	Q2	2012	1.4800	0.4736	2.0000	1
2	1209	24	0	10	Q4	2012	2.9600	1.3320	4.0000	1
2	1399	24	0	5	Q2	2012	3.7000	1.1840	5.0000	1
2	1415	16	1236	12	Q4	2012	2.9600	1.0360	4.0000	1
2	1485	15	1152	9	Q3	2012	2.2200	1.0878	3.0000	1
2	1696	22	0	3	Q1	2012	1.4800	0.6216	2.0000	1
2	1773	13	0	1	Q1	2012	1.4800	0.6660	2.0000	1
2	2211	17	0	3	Q1	2012	3.7000	1.2580	5.0000	1
2	2278	7	0	11	Q4	2012	1.4800	0.5180	2.0000	1
2	2769	16	0	8	Q3	2012	2.2200	1.0434	3.0000	1
2	3000	17	0	4	Q2	2012	2.2200	0.7326	3.0000	1
2	3000	17	1293	1	Q1	2012	2.2200	0.7770	3.0000	1
2	3211	2	0	1	Q1	2012	0.7400	0.2960	1.0000	1
2	3458	24	0	1	Q1	2012	2.2200	0.6882	3.0000	1
2	3596	11	837	10	Q4	2012	2.2200	0.7326	3.0000	1
2	3759	13	0	7	Q3	2012	2.2200	1.0212	3.0000	1
2	4185	24	0	11	Q4	2012	2.2200	1.1100	3.0000	1
2	4508	13	0	2	Q1	2012	2.2200	0.7770	3.0000	1
2	4575	15	0	2	Q1	2012	3.7000	1.7390	5.0000	1
2	4926	6	521	10	Q4	2012	1.4800	0.7252	2.0000	1
2	4990	7	0	6	Q2	2012	2.9600	1.3024	4.0000	1
2	5009	7	0	1	Q1	2012	2.9600	1.2432	4.0000	1
2	5104	24	0	8	Q3	2012	2.2200	0.8658	3.0000	1
2	5161	6	0	10	Q4	2012	2.9600	0.9768	4.0000	1
2	5259	7	521	10	Q4	2012	2.9600	0.9176	4.0000	1
2	5374	16	1228	8	Q3	2012	2.2200	0.7104	3.0000	1
2	5398	17	1303	6	Q2	2012	2.9600	1.3912	4.0000	1
2	5635	6	508	4	Q2	2012	2.2200	0.9768	3.0000	1
2	5763	24	0	9	Q3	2012	2.9600	1.4800	4.0000	1
2	5887	7	0	9	Q3	2012	2.9600	0.9176	4.0000	1
2	6105	23	0	12	Q4	2012	1.4800	0.5772	2.0000	1
2	6712	16	0	9	Q3	2012	2.2200	0.8658	3.0000	1
2	6836	7	0	7	Q3	2012	2.9600	1.1248	4.0000	1
2	6956	13	0	2	Q1	2012	1.4800	0.7252	2.0000	1
2	6974	2	0	11	Q4	2012	0.7400	0.2294	1.0000	1
2	6978	24	1859	8	Q3	2012	2.2200	1.0878	3.0000	1
2	7035	7	0	6	Q2	2012	1.4800	0.5920	2.0000	1
2	7149	13	0	2	Q1	2012	1.4800	0.4736	2.0000	1
2	7780	13	0	7	Q3	2012	2.2200	0.7548	3.0000	1
2	7897	15	0	10	Q4	2012	1.4800	0.4736	2.0000	1
2	8306	24	0	4	Q2	2012	2.2200	0.7548	3.0000	1
2	8324	24	0	10	Q4	2012	1.4800	0.6660	2.0000	1
2	8526	11	0	4	Q2	2012	1.4800	0.5920	2.0000	1
2	8571	3	207	11	Q4	2012	2.9600	0.9768	4.0000	1
2	8768	11	0	8	Q3	2012	2.2200	0.7326	3.0000	1
2	9263	16	1225	7	Q3	2012	2.2200	0.7104	3.0000	1
2	9357	7	504	2	Q1	2012	2.2200	1.0878	3.0000	1
2	9591	7	0	10	Q4	2012	1.4800	0.5328	2.0000	1
2	9668	13	0	12	Q4	2012	2.2200	0.7548	3.0000	1
2	9788	13	986	6	Q2	2012	2.2200	1.0434	3.0000	1
2	10020	11	837	10	Q4	2012	2.9600	1.1544	4.0000	1
3	161	24	1846	2	Q1	2012	1.6600	0.6142	2.0000	1
3	417	6	0	12	Q4	2012	3.3200	1.2616	4.0000	1
3	694	11	0	11	Q4	2012	4.1500	1.2865	5.0000	1
3	720	24	1845	1	Q1	2012	3.3200	1.4276	4.0000	1
3	768	15	0	10	Q4	2012	2.4900	0.7719	3.0000	1
3	964	7	0	12	Q4	2012	2.4900	0.8217	3.0000	1
3	1170	24	0	10	Q4	2012	4.1500	1.9505	5.0000	1
3	1298	17	0	10	Q4	2012	3.3200	1.1288	4.0000	1
3	1339	13	0	11	Q4	2012	2.4900	1.1703	3.0000	1
3	1361	24	0	7	Q3	2012	3.3200	1.4940	4.0000	1
3	1387	11	821	3	Q1	2012	2.4900	0.7968	3.0000	1
3	1675	15	0	6	Q2	2012	1.6600	0.5312	2.0000	1
3	2233	14	0	7	Q3	2012	1.6600	0.7138	2.0000	1
3	3021	16	1233	10	Q4	2012	2.4900	0.9711	3.0000	1
3	3258	6	0	4	Q2	2012	2.4900	1.1952	3.0000	1
3	3321	24	0	3	Q1	2012	3.3200	1.4940	4.0000	1
3	3541	15	1138	3	Q1	2012	2.4900	1.1952	3.0000	1
3	3633	15	1141	4	Q2	2012	3.3200	1.4276	4.0000	1
3	3692	16	0	12	Q4	2012	2.4900	0.7719	3.0000	1
3	3693	3	207	11	Q4	2012	3.3200	1.2284	4.0000	1
3	3952	7	0	8	Q3	2012	1.6600	0.6142	2.0000	1
3	4315	17	0	12	Q4	2012	2.4900	1.0458	3.0000	1
3	4518	13	0	3	Q1	2012	3.3200	1.3280	4.0000	1
3	4727	16	0	1	Q1	2012	3.3200	1.4940	4.0000	1
3	4845	24	1869	12	Q4	2012	3.3200	1.2616	4.0000	1
3	5255	24	0	10	Q4	2012	2.4900	1.0707	3.0000	1
3	5419	17	0	5	Q2	2012	2.4900	0.8964	3.0000	1
3	6061	17	0	4	Q2	2012	3.3200	1.0624	4.0000	1
3	6163	13	0	1	Q1	2012	1.6600	0.6474	2.0000	1
3	6388	11	0	3	Q1	2012	3.3200	1.0292	4.0000	1
3	6897	6	0	6	Q2	2012	3.3200	1.0956	4.0000	1
3	7179	11	0	1	Q1	2012	2.4900	1.1703	3.0000	1
3	7241	17	0	3	Q1	2012	1.6600	0.5478	2.0000	1
3	7896	23	0	6	Q2	2012	2.4900	0.8217	3.0000	1
3	8207	13	0	7	Q3	2012	2.4900	0.8466	3.0000	1
3	8288	7	0	8	Q3	2012	1.6600	0.6640	2.0000	1
3	8312	6	0	9	Q3	2012	4.1500	1.9505	5.0000	1
3	8454	17	0	5	Q2	2012	3.3200	1.4276	4.0000	1
3	8659	13	0	3	Q1	2012	2.4900	1.1454	3.0000	1
3	8687	23	0	1	Q1	2012	1.6600	0.5146	2.0000	1
3	8892	13	0	10	Q4	2012	2.4900	0.7719	3.0000	1
3	9006	17	0	1	Q1	2012	1.6600	0.6640	2.0000	1
3	9721	15	0	6	Q2	2012	3.3200	1.5604	4.0000	1
3	9812	13	0	8	Q3	2012	2.4900	0.8466	3.0000	1
3	9863	13	0	12	Q4	2012	2.4900	1.0458	3.0000	1
3	9991	6	521	10	Q4	2012	2.4900	0.7719	3.0000	1
3	10043	22	1710	12	Q4	2012	0.8300	0.3818	1.0000	1
4	512	24	1847	2	Q1	2012	10.9200	3.3852	3.0000	1
4	673	11	0	9	Q3	2012	10.9200	4.8048	3.0000	1
4	863	17	0	10	Q4	2012	10.9200	5.2416	3.0000	1
4	997	3	0	6	Q2	2012	10.9200	4.3680	3.0000	1
4	1153	13	0	5	Q2	2012	14.5600	6.2608	4.0000	1
4	1266	13	986	6	Q2	2012	14.5600	6.6976	4.0000	1
4	1271	13	988	7	Q3	2012	7.2800	2.9848	2.0000	1
4	1328	17	1292	1	Q1	2012	10.9200	3.4944	3.0000	1
4	1660	13	0	10	Q4	2012	7.2800	3.5672	2.0000	1
4	1994	15	0	9	Q3	2012	18.2000	5.6420	5.0000	1
4	2019	16	1236	12	Q4	2012	10.9200	4.5864	3.0000	1
4	2065	17	1314	11	Q4	2012	10.9200	5.3508	3.0000	1
4	2251	13	0	4	Q2	2012	7.2800	3.5672	2.0000	1
4	2441	17	1307	8	Q3	2012	14.5600	6.8432	4.0000	1
4	2550	24	0	11	Q4	2012	14.5600	4.8048	4.0000	1
4	2648	24	0	12	Q4	2012	7.2800	2.7664	2.0000	1
4	2791	11	0	8	Q3	2012	10.9200	5.3508	3.0000	1
4	3283	15	0	6	Q2	2012	7.2800	2.4024	2.0000	1
4	3389	7	0	11	Q4	2012	7.2800	2.9848	2.0000	1
4	3449	6	0	1	Q1	2012	14.5600	4.8048	4.0000	1
4	3633	15	1150	8	Q3	2012	10.9200	3.3852	3.0000	1
4	4117	2	129	11	Q4	2012	7.2800	2.8392	2.0000	1
4	4257	3	0	6	Q2	2012	10.9200	5.1324	3.0000	1
4	4282	15	0	10	Q4	2012	7.2800	2.9120	2.0000	1
4	4498	17	1314	11	Q4	2012	7.2800	2.6936	2.0000	1
4	4711	3	0	10	Q4	2012	14.5600	5.0960	4.0000	1
4	4850	15	0	5	Q2	2012	14.5600	6.4064	4.0000	1
4	4925	16	1228	8	Q3	2012	7.2800	2.8392	2.0000	1
4	4928	13	980	3	Q1	2012	10.9200	4.6956	3.0000	1
4	5183	6	508	4	Q2	2012	10.9200	3.7128	3.0000	1
4	6113	16	0	5	Q2	2012	10.9200	4.6956	3.0000	1
4	6713	13	0	7	Q3	2012	10.9200	5.3508	3.0000	1
4	6739	24	0	6	Q2	2012	14.5600	6.4064	4.0000	1
4	6866	17	1293	1	Q1	2012	10.9200	5.0232	3.0000	1
4	7175	7	0	1	Q1	2012	10.9200	5.1324	3.0000	1
4	7185	11	0	6	Q2	2012	7.2800	3.0576	2.0000	1
4	7212	24	0	1	Q1	2012	7.2800	3.3488	2.0000	1
4	7355	13	0	2	Q1	2012	7.2800	2.4024	2.0000	1
4	7363	6	0	1	Q1	2012	7.2800	3.5672	2.0000	1
4	7370	23	0	1	Q1	2012	10.9200	4.0404	3.0000	1
4	7370	23	0	2	Q1	2012	14.5600	6.2608	4.0000	1
4	7477	6	0	7	Q3	2012	7.2800	2.9120	2.0000	1
4	7556	17	0	7	Q3	2012	10.9200	4.4772	3.0000	1
4	7813	17	0	5	Q2	2012	10.9200	4.2588	3.0000	1
4	7920	17	0	1	Q1	2012	7.2800	3.2760	2.0000	1
4	8098	13	0	2	Q1	2012	7.2800	2.4024	2.0000	1
4	8281	17	0	7	Q3	2012	14.5600	4.5136	4.0000	1
4	8485	15	0	12	Q4	2012	10.9200	5.1324	3.0000	1
4	8840	17	0	5	Q2	2012	7.2800	2.9848	2.0000	1
4	8862	11	0	7	Q3	2012	10.9200	5.3508	3.0000	1
4	9667	23	0	10	Q4	2012	7.2800	3.2760	2.0000	1
4	9748	24	0	4	Q2	2012	10.9200	5.3508	3.0000	1
4	10034	15	0	2	Q1	2012	10.9200	4.4772	3.0000	1
4	10067	7	0	4	Q2	2012	10.9200	5.4600	3.0000	1
5	186	24	0	9	Q3	2012	6.5700	2.2995	3.0000	1
5	269	14	1065	6	Q2	2012	4.3800	1.3140	2.0000	1
5	475	7	523	11	Q4	2012	8.7600	3.5916	4.0000	1
5	1584	7	0	8	Q3	2012	4.3800	1.9272	2.0000	1
5	2850	3	0	4	Q2	2012	10.9500	3.7230	5.0000	1
5	3462	6	508	4	Q2	2012	6.5700	2.2338	3.0000	1
5	3921	23	0	7	Q3	2012	8.7600	4.0296	4.0000	1
5	4094	16	0	9	Q3	2012	6.5700	2.1681	3.0000	1
5	4292	7	505	2	Q1	2012	8.7600	3.4164	4.0000	1
5	4499	13	992	9	Q3	2012	4.3800	1.4454	2.0000	1
5	5001	6	522	10	Q4	2012	10.9500	3.6135	5.0000	1
5	5183	7	0	3	Q1	2012	4.3800	1.4454	2.0000	1
5	5204	23	0	9	Q3	2012	6.5700	2.4309	3.0000	1
5	5451	11	0	8	Q3	2012	6.5700	2.5623	3.0000	1
5	5542	16	0	7	Q3	2012	4.3800	2.1462	2.0000	1
5	5623	7	0	6	Q2	2012	6.5700	2.2338	3.0000	1
5	5746	15	0	6	Q2	2012	6.5700	2.3652	3.0000	1
5	5790	17	0	7	Q3	2012	8.7600	3.8544	4.0000	1
5	5842	24	0	9	Q3	2012	8.7600	3.6792	4.0000	1
5	6012	13	0	12	Q4	2012	6.5700	3.2850	3.0000	1
5	6570	11	0	5	Q2	2012	8.7600	3.9420	4.0000	1
5	6760	17	0	2	Q1	2012	6.5700	2.4309	3.0000	1
5	6760	17	1311	10	Q4	2012	6.5700	2.1024	3.0000	1
5	6775	15	0	11	Q4	2012	10.9500	4.7085	5.0000	1
5	6835	16	1235	11	Q4	2012	4.3800	1.5330	2.0000	1
5	6930	24	0	4	Q2	2012	4.3800	1.4454	2.0000	1
5	7192	2	112	3	Q1	2012	4.3800	1.9272	2.0000	1
5	7291	11	833	8	Q3	2012	6.5700	3.2850	3.0000	1
5	7695	6	526	12	Q4	2012	8.7600	3.8544	4.0000	1
5	7822	3	0	2	Q1	2012	8.7600	4.2924	4.0000	1
5	8172	17	0	6	Q2	2012	4.3800	1.5330	2.0000	1
5	8242	17	0	6	Q2	2012	4.3800	1.6206	2.0000	1
5	8306	24	0	9	Q3	2012	6.5700	2.6937	3.0000	1
5	8311	23	1773	4	Q2	2012	6.5700	2.8251	3.0000	1
5	8473	13	0	1	Q1	2012	6.5700	2.1024	3.0000	1
5	8511	16	0	6	Q2	2012	6.5700	3.0222	3.0000	1
5	9256	13	988	7	Q3	2012	6.5700	3.0879	3.0000	1
5	9307	11	0	7	Q3	2012	6.5700	1.9710	3.0000	1
5	9745	17	0	2	Q1	2012	4.3800	1.3578	2.0000	1
5	9747	13	0	9	Q3	2012	4.3800	1.3140	2.0000	1
5	9781	3	0	5	Q2	2012	8.7600	4.1172	4.0000	1
5	10068	23	0	5	Q2	2012	4.3800	1.5768	2.0000	1
5	10173	16	0	10	Q4	2012	8.7600	4.2048	4.0000	1
5	10274	7	0	5	Q2	2012	4.3800	1.8396	2.0000	1
6	177	13	0	9	Q3	2012	2.3000	0.7590	2.0000	1
6	188	13	0	11	Q4	2012	3.4500	1.3455	3.0000	1
6	216	17	0	9	Q3	2012	3.4500	1.2075	3.0000	1
6	261	24	1860	8	Q3	2012	3.4500	1.2075	3.0000	1
6	302	15	0	3	Q1	2012	2.3000	1.0120	2.0000	1
6	398	13	0	9	Q3	2012	4.6000	1.5180	4.0000	1
6	477	15	1152	9	Q3	2012	2.3000	0.7820	2.0000	1
6	1005	3	0	2	Q1	2012	3.4500	1.6215	3.0000	1
6	1216	17	1307	8	Q3	2012	4.6000	2.0700	4.0000	1
6	1446	24	0	6	Q2	2012	3.4500	1.1730	3.0000	1
6	1890	24	0	11	Q4	2012	4.6000	1.5640	4.0000	1
6	2019	16	1220	4	Q2	2012	4.6000	1.9780	4.0000	1
6	2211	17	0	7	Q3	2012	5.7500	2.1275	5.0000	1
6	2673	11	0	1	Q1	2012	3.4500	1.1730	3.0000	1
6	2674	11	818	1	Q1	2012	2.3000	1.0580	2.0000	1
6	2839	15	0	6	Q2	2012	2.3000	1.0120	2.0000	1
6	2996	13	988	7	Q3	2012	3.4500	1.0695	3.0000	1
6	3139	24	0	8	Q3	2012	2.3000	0.9660	2.0000	1
6	3357	24	0	9	Q3	2012	3.4500	1.1730	3.0000	1
6	3706	13	980	3	Q1	2012	3.4500	1.2420	3.0000	1
6	3936	6	0	4	Q2	2012	3.4500	1.3455	3.0000	1
6	4021	16	0	12	Q4	2012	3.4500	1.5180	3.0000	1
6	4078	3	0	2	Q1	2012	3.4500	1.4835	3.0000	1
6	4461	11	0	4	Q2	2012	2.3000	0.7360	2.0000	1
6	4525	6	523	11	Q4	2012	5.7500	2.7600	5.0000	1
6	4824	3	0	6	Q2	2012	3.4500	1.0695	3.0000	1
6	4925	16	0	6	Q2	2012	4.6000	1.9320	4.0000	1
6	5256	17	0	11	Q4	2012	3.4500	1.3455	3.0000	1
6	5295	16	0	8	Q3	2012	3.4500	1.5180	3.0000	1
6	5433	13	0	1	Q1	2012	2.3000	1.0120	2.0000	1
6	5479	14	0	8	Q3	2012	1.1500	0.4830	1.0000	1
6	5633	13	0	12	Q4	2012	2.3000	0.9200	2.0000	1
6	6001	17	0	4	Q2	2012	2.3000	1.1500	2.0000	1
6	6208	17	0	3	Q1	2012	3.4500	1.5525	3.0000	1
6	6261	6	0	8	Q3	2012	3.4500	1.6560	3.0000	1
6	6372	17	0	9	Q3	2012	2.3000	0.9430	2.0000	1
6	6486	13	0	12	Q4	2012	4.6000	1.5180	4.0000	1
6	6541	23	0	12	Q4	2012	3.4500	1.6215	3.0000	1
6	6589	17	0	3	Q1	2012	3.4500	1.3110	3.0000	1
6	6940	7	519	9	Q3	2012	4.6000	1.7940	4.0000	1
6	6995	11	0	11	Q4	2012	2.3000	0.8970	2.0000	1
6	7141	17	0	12	Q4	2012	3.4500	1.2420	3.0000	1
6	7655	17	0	6	Q2	2012	4.6000	1.6100	4.0000	1
6	7831	17	0	8	Q3	2012	4.6000	2.2080	4.0000	1
6	7853	15	1142	5	Q2	2012	4.6000	1.8860	4.0000	1
6	7859	7	0	12	Q4	2012	4.6000	2.0240	4.0000	1
6	8055	14	0	8	Q3	2012	2.3000	1.0120	2.0000	1
6	8291	13	0	7	Q3	2012	2.3000	0.8280	2.0000	1
6	8311	23	0	6	Q2	2012	3.4500	1.1730	3.0000	1
6	8311	23	1773	4	Q2	2012	4.6000	2.2540	4.0000	1
6	8427	16	0	12	Q4	2012	4.6000	1.6100	4.0000	1
6	8473	13	0	1	Q1	2012	3.4500	1.2765	3.0000	1
6	8768	11	0	11	Q4	2012	4.6000	1.4260	4.0000	1
6	8897	11	0	2	Q1	2012	3.4500	1.1385	3.0000	1
6	9331	11	0	4	Q2	2012	4.6000	1.9780	4.0000	1
6	9396	13	980	3	Q1	2012	4.6000	1.5640	4.0000	1
6	9867	13	0	11	Q4	2012	3.4500	1.6215	3.0000	1
6	9951	3	0	5	Q2	2012	3.4500	1.1040	3.0000	1
7	467	13	980	3	Q1	2012	5.2200	2.2968	2.0000	1
7	1112	24	1845	1	Q1	2012	10.4400	4.4892	4.0000	1
7	1267	13	0	7	Q3	2012	7.8300	2.6622	3.0000	1
7	1430	3	0	2	Q1	2012	10.4400	3.5496	4.0000	1
7	1445	15	0	11	Q4	2012	5.2200	2.3490	2.0000	1
7	2431	3	0	11	Q4	2012	5.2200	2.0358	2.0000	1
7	2594	17	1314	11	Q4	2012	5.2200	2.1402	2.0000	1
7	2610	7	0	11	Q4	2012	7.8300	3.6801	3.0000	1
7	2673	11	0	5	Q2	2012	10.4400	3.6540	4.0000	1
7	2756	3	0	3	Q1	2012	7.8300	3.0537	3.0000	1
7	2773	11	0	4	Q2	2012	5.2200	2.0358	2.0000	1
7	3075	23	1775	5	Q2	2012	5.2200	1.6704	2.0000	1
7	3316	6	0	11	Q4	2012	10.4400	3.6540	4.0000	1
7	3497	17	1314	11	Q4	2012	7.8300	2.3490	3.0000	1
7	3796	11	0	11	Q4	2012	7.8300	2.8971	3.0000	1
7	3840	15	0	3	Q1	2012	7.8300	3.7584	3.0000	1
7	4261	13	0	6	Q2	2012	5.2200	2.1924	2.0000	1
7	4283	15	1136	2	Q1	2012	7.8300	3.6018	3.0000	1
7	4340	17	1303	6	Q2	2012	7.8300	3.2886	3.0000	1
7	4401	11	0	7	Q3	2012	5.2200	2.4012	2.0000	1
7	4767	16	1216	2	Q1	2012	7.8300	3.6801	3.0000	1
7	4767	16	1220	4	Q2	2012	10.4400	4.4892	4.0000	1
7	5158	3	0	5	Q2	2012	10.4400	4.5936	4.0000	1
7	5168	6	0	12	Q4	2012	10.4400	3.7584	4.0000	1
7	5222	7	0	4	Q2	2012	7.8300	3.7584	3.0000	1
7	5302	11	833	8	Q3	2012	5.2200	1.8792	2.0000	1
7	5590	17	0	4	Q2	2012	10.4400	3.7584	4.0000	1
7	5681	11	842	12	Q4	2012	5.2200	1.9314	2.0000	1
7	5923	23	1789	12	Q4	2012	10.4400	4.4892	4.0000	1
7	6114	16	0	1	Q1	2012	10.4400	4.1760	4.0000	1
7	6306	13	0	1	Q1	2012	5.2200	2.1924	2.0000	1
7	6367	3	210	12	Q4	2012	7.8300	3.6018	3.0000	1
7	6372	17	0	8	Q3	2012	10.4400	3.5496	4.0000	1
7	6421	7	0	5	Q2	2012	7.8300	2.5056	3.0000	1
7	6423	17	1307	8	Q3	2012	5.2200	1.7226	2.0000	1
7	6465	6	0	3	Q1	2012	5.2200	1.8270	2.0000	1
7	6574	13	0	9	Q3	2012	7.8300	2.7405	3.0000	1
7	6712	16	0	9	Q3	2012	7.8300	3.0537	3.0000	1
7	6912	16	1220	4	Q2	2012	10.4400	3.1320	4.0000	1
7	7065	17	1312	10	Q4	2012	5.2200	2.0880	2.0000	1
7	7357	24	1851	4	Q2	2012	5.2200	2.0358	2.0000	1
7	7493	24	0	1	Q1	2012	10.4400	4.5936	4.0000	1
7	7591	15	0	9	Q3	2012	10.4400	4.0716	4.0000	1
7	7607	17	1292	1	Q1	2012	10.4400	3.7584	4.0000	1
7	7702	16	0	4	Q2	2012	7.8300	2.8188	3.0000	1
7	7714	7	504	2	Q1	2012	10.4400	4.6980	4.0000	1
7	7981	14	0	12	Q4	2012	5.2200	2.0358	2.0000	1
7	8274	13	0	2	Q1	2012	10.4400	3.7584	4.0000	1
7	8284	22	0	11	Q4	2012	5.2200	2.0880	2.0000	1
7	8912	7	0	6	Q2	2012	7.8300	2.9754	3.0000	1
7	9169	23	0	11	Q4	2012	5.2200	1.9836	2.0000	1
7	9263	16	0	7	Q3	2012	10.4400	4.9068	4.0000	1
7	9418	24	0	3	Q1	2012	10.4400	3.6540	4.0000	1
7	9555	17	0	12	Q4	2012	7.8300	3.7584	3.0000	1
7	9698	23	0	8	Q3	2012	5.2200	2.1402	2.0000	1
7	9814	6	0	7	Q3	2012	10.4400	5.1156	4.0000	1
7	9825	13	0	12	Q4	2012	7.8300	2.6622	3.0000	1
7	9871	13	0	8	Q3	2012	5.2200	1.6704	2.0000	1
7	10065	6	0	10	Q4	2012	5.2200	2.1402	2.0000	1
7	10101	7	0	6	Q2	2012	10.4400	3.9672	4.0000	1
8	125	6	0	4	Q2	2012	7.7700	2.8749	3.0000	1
8	467	13	0	7	Q3	2012	5.1800	2.2792	2.0000	1
8	598	6	0	4	Q2	2012	5.1800	1.8648	2.0000	1
8	663	16	0	3	Q1	2012	5.1800	2.4864	2.0000	1
8	992	7	0	12	Q4	2012	10.3600	3.2116	4.0000	1
8	1076	2	0	11	Q4	2012	5.1800	2.5382	2.0000	1
8	1124	3	0	11	Q4	2012	7.7700	2.6418	3.0000	1
8	1470	17	0	12	Q4	2012	7.7700	3.0303	3.0000	1
8	1470	17	1303	6	Q2	2012	7.7700	3.0303	3.0000	1
8	1610	3	0	7	Q3	2012	7.7700	3.8850	3.0000	1
8	1720	16	0	1	Q1	2012	12.9500	6.2160	5.0000	1
8	1825	23	0	2	Q1	2012	10.3600	3.5224	4.0000	1
8	2548	13	0	6	Q2	2012	7.7700	2.7972	3.0000	1
8	2556	3	188	2	Q1	2012	10.3600	4.4548	4.0000	1
8	2640	6	0	2	Q1	2012	10.3600	3.2116	4.0000	1
8	2689	3	207	11	Q4	2012	5.1800	2.0720	2.0000	1
8	3046	13	0	9	Q3	2012	5.1800	2.2274	2.0000	1
8	3434	24	0	7	Q3	2012	15.5400	5.7498	6.0000	1
8	3647	13	992	9	Q3	2012	10.3600	3.9368	4.0000	1
8	3725	23	1773	4	Q2	2012	5.1800	2.4864	2.0000	1
8	3840	15	0	8	Q3	2012	7.7700	3.1080	3.0000	1
8	4261	13	0	8	Q3	2012	5.1800	2.1756	2.0000	1
8	4411	2	129	11	Q4	2012	2.5900	0.8547	1.0000	1
8	4680	6	526	12	Q4	2012	7.7700	3.4965	3.0000	1
8	4704	6	0	6	Q2	2012	12.9500	3.8850	5.0000	1
8	4886	24	1845	1	Q1	2012	7.7700	3.7296	3.0000	1
8	5120	7	504	2	Q1	2012	10.3600	3.5224	4.0000	1
8	5153	11	0	9	Q3	2012	7.7700	3.4965	3.0000	1
8	5153	11	0	11	Q4	2012	10.3600	3.6260	4.0000	1
8	5206	13	0	12	Q4	2012	7.7700	3.4188	3.0000	1
8	5298	7	0	12	Q4	2012	7.7700	2.7972	3.0000	1
8	5419	17	0	10	Q4	2012	10.3600	4.5584	4.0000	1
8	5473	24	1859	8	Q3	2012	7.7700	3.3411	3.0000	1
8	5685	13	0	4	Q2	2012	7.7700	3.3411	3.0000	1
8	5809	13	984	5	Q2	2012	7.7700	3.5742	3.0000	1
8	5906	15	0	1	Q1	2012	10.3600	4.4548	4.0000	1
8	6324	23	0	1	Q1	2012	10.3600	4.4548	4.0000	1
8	6376	6	0	5	Q2	2012	15.5400	4.8174	6.0000	1
8	6547	15	0	1	Q1	2012	7.7700	2.7972	3.0000	1
8	6788	7	0	5	Q2	2012	7.7700	3.5742	3.0000	1
8	6919	11	833	8	Q3	2012	7.7700	2.9526	3.0000	1
8	6967	24	1845	1	Q1	2012	5.1800	1.9166	2.0000	1
8	7003	15	0	9	Q3	2012	5.1800	2.4346	2.0000	1
8	7234	16	0	6	Q2	2012	7.7700	3.8073	3.0000	1
8	7269	13	0	7	Q3	2012	10.3600	4.7656	4.0000	1
8	7348	11	0	12	Q4	2012	7.7700	2.4087	3.0000	1
8	7510	15	0	5	Q2	2012	7.7700	3.4188	3.0000	1
8	7577	7	0	9	Q3	2012	10.3600	4.1440	4.0000	1
8	7871	6	519	9	Q3	2012	10.3600	3.7296	4.0000	1
8	8171	24	1866	11	Q4	2012	10.3600	4.9728	4.0000	1
8	8472	17	1303	6	Q2	2012	10.3600	4.5584	4.0000	1
8	8511	16	0	7	Q3	2012	10.3600	4.8692	4.0000	1
8	8511	16	1220	4	Q2	2012	5.1800	2.1756	2.0000	1
8	8550	11	0	3	Q1	2012	5.1800	2.0720	2.0000	1
8	9115	11	829	6	Q2	2012	10.3600	4.8692	4.0000	1
8	9297	13	0	11	Q4	2012	7.7700	3.1857	3.0000	1
8	9487	17	0	8	Q3	2012	7.7700	2.8749	3.0000	1
8	9500	6	523	11	Q4	2012	7.7700	3.8073	3.0000	1
8	9712	6	0	2	Q1	2012	7.7700	3.4965	3.0000	1
8	10007	7	0	11	Q4	2012	7.7700	3.1857	3.0000	1
9	278	15	0	5	Q2	2012	7.2600	2.4684	3.0000	1
9	619	13	1000	12	Q4	2012	7.2600	3.0492	3.0000	1
9	1281	3	0	8	Q3	2012	4.8400	1.5972	2.0000	1
9	1316	7	516	8	Q3	2012	7.2600	2.3232	3.0000	1
9	1508	22	0	12	Q4	2012	4.8400	1.7908	2.0000	1
9	1528	16	1225	7	Q3	2012	4.8400	2.1296	2.0000	1
9	1819	7	0	8	Q3	2012	7.2600	2.3958	3.0000	1
9	1850	16	0	10	Q4	2012	7.2600	2.9766	3.0000	1
9	2001	6	0	6	Q2	2012	9.6800	3.4848	4.0000	1
9	2428	24	1858	7	Q3	2012	4.8400	1.9844	2.0000	1
9	2444	13	0	2	Q1	2012	7.2600	2.6136	3.0000	1
9	2466	24	0	9	Q3	2012	4.8400	1.9360	2.0000	1
9	2672	24	0	7	Q3	2012	7.2600	2.6862	3.0000	1
9	2678	3	0	8	Q3	2012	4.8400	2.1296	2.0000	1
9	3199	24	0	7	Q3	2012	9.6800	4.4528	4.0000	1
9	3240	7	0	1	Q1	2012	4.8400	1.7908	2.0000	1
9	3442	3	201	8	Q3	2012	9.6800	4.1624	4.0000	1
9	3719	23	0	6	Q2	2012	7.2600	2.5410	3.0000	1
9	3993	24	0	11	Q4	2012	4.8400	1.7908	2.0000	1
9	4155	7	0	5	Q2	2012	7.2600	2.1780	3.0000	1
9	4342	13	0	9	Q3	2012	7.2600	3.0492	3.0000	1
9	4535	15	0	12	Q4	2012	4.8400	2.1780	2.0000	1
9	4644	11	0	4	Q2	2012	7.2600	3.5574	3.0000	1
9	4691	17	0	11	Q4	2012	4.8400	1.5972	2.0000	1
9	4727	16	0	2	Q1	2012	9.6800	3.6784	4.0000	1
9	4906	11	0	11	Q4	2012	7.2600	3.4848	3.0000	1
9	5037	24	0	1	Q1	2012	4.8400	1.8876	2.0000	1
9	6695	2	0	6	Q2	2012	4.8400	1.9360	2.0000	1
9	6741	24	0	5	Q2	2012	9.6800	4.4528	4.0000	1
9	7059	17	0	4	Q2	2012	7.2600	2.8314	3.0000	1
9	7384	3	0	7	Q3	2012	12.1000	5.3240	5.0000	1
9	7486	3	0	4	Q2	2012	7.2600	2.4684	3.0000	1
9	7713	17	0	5	Q2	2012	9.6800	4.5496	4.0000	1
9	7731	7	0	12	Q4	2012	4.8400	1.6940	2.0000	1
9	7822	3	190	3	Q1	2012	7.2600	2.3958	3.0000	1
9	7910	15	0	8	Q3	2012	7.2600	3.0492	3.0000	1
9	7920	17	0	2	Q1	2012	7.2600	3.5574	3.0000	1
9	8141	22	0	10	Q4	2012	2.4200	1.1858	1.0000	1
9	8252	13	0	1	Q1	2012	7.2600	2.3232	3.0000	1
9	8452	16	0	6	Q2	2012	9.6800	3.9688	4.0000	1
9	8906	11	0	4	Q2	2012	4.8400	2.1296	2.0000	1
9	9133	24	1860	8	Q3	2012	9.6800	3.2912	4.0000	1
9	9194	17	1292	1	Q1	2012	12.1000	3.6300	5.0000	1
9	9715	17	0	9	Q3	2012	7.2600	3.0492	3.0000	1
9	10145	13	0	7	Q3	2012	4.8400	2.0328	2.0000	1
10	467	13	0	9	Q3	2012	5.6800	2.7264	4.0000	1
10	863	17	0	3	Q1	2012	4.2600	1.4484	3.0000	1
10	1197	23	1789	12	Q4	2012	5.6800	2.6696	4.0000	1
10	1304	13	0	11	Q4	2012	4.2600	1.4484	3.0000	1
10	1361	24	0	7	Q3	2012	5.6800	2.4424	4.0000	1
10	1366	13	0	11	Q4	2012	2.8400	0.9940	2.0000	1
10	1821	13	0	12	Q4	2012	5.6800	2.7832	4.0000	1
10	2019	16	0	1	Q1	2012	2.8400	1.0792	2.0000	1
10	2052	13	980	3	Q1	2012	5.6800	2.4992	4.0000	1
10	2211	17	0	2	Q1	2012	7.1000	2.6270	5.0000	1
10	2381	6	0	4	Q2	2012	4.2600	1.3632	3.0000	1
10	2570	16	0	7	Q3	2012	5.6800	2.1584	4.0000	1
10	2763	15	0	5	Q2	2012	5.6800	1.8176	4.0000	1
10	2777	13	0	6	Q2	2012	2.8400	1.1928	2.0000	1
10	2942	17	0	4	Q2	2012	4.2600	2.0022	3.0000	1
10	2942	17	0	10	Q4	2012	4.2600	1.8744	3.0000	1
10	3130	13	0	7	Q3	2012	4.2600	1.3206	3.0000	1
10	3142	14	0	9	Q3	2012	2.8400	1.4200	2.0000	1
10	3418	3	0	3	Q1	2012	5.6800	1.7608	4.0000	1
10	3460	11	0	9	Q3	2012	4.2600	1.9170	3.0000	1
10	4273	11	824	4	Q2	2012	2.8400	1.1360	2.0000	1
10	4351	23	0	11	Q4	2012	5.6800	2.6696	4.0000	1
10	4391	16	0	5	Q2	2012	4.2600	1.8744	3.0000	1
10	4398	7	0	9	Q3	2012	7.1000	2.5560	5.0000	1
10	4465	13	0	5	Q2	2012	4.2600	1.5336	3.0000	1
10	4727	16	1235	11	Q4	2012	4.2600	1.3632	3.0000	1
10	5019	23	0	11	Q4	2012	4.2600	1.6614	3.0000	1
10	5249	7	0	1	Q1	2012	5.6800	1.7608	4.0000	1
10	5380	6	0	4	Q2	2012	4.2600	1.9170	3.0000	1
10	5423	11	826	5	Q2	2012	5.6800	2.2720	4.0000	1
10	5471	6	523	11	Q4	2012	5.6800	2.4992	4.0000	1
10	6367	3	0	9	Q3	2012	4.2600	1.7040	3.0000	1
10	6710	13	0	11	Q4	2012	4.2600	1.8744	3.0000	1
10	6718	6	0	10	Q4	2012	5.6800	1.8744	4.0000	1
10	7178	24	1846	2	Q1	2012	2.8400	0.9656	2.0000	1
10	7190	23	1772	4	Q2	2012	2.8400	1.0224	2.0000	1
10	7573	3	0	9	Q3	2012	2.8400	1.3916	2.0000	1
10	7801	7	0	1	Q1	2012	2.8400	0.9372	2.0000	1
10	7963	11	0	11	Q4	2012	4.2600	1.5762	3.0000	1
10	8060	22	0	12	Q4	2012	1.4200	0.5822	1.0000	1
10	8181	17	0	5	Q2	2012	2.8400	1.3632	2.0000	1
10	8298	13	0	3	Q1	2012	2.8400	1.0508	2.0000	1
10	8647	3	202	8	Q3	2012	2.8400	1.3064	2.0000	1
10	8668	13	0	5	Q2	2012	5.6800	1.7608	4.0000	1
10	9170	7	0	1	Q1	2012	2.8400	1.1644	2.0000	1
10	9234	24	0	11	Q4	2012	4.2600	1.8744	3.0000	1
10	9271	17	0	8	Q3	2012	4.2600	1.7466	3.0000	1
10	9306	24	0	2	Q1	2012	2.8400	0.9940	2.0000	1
10	9499	7	0	12	Q4	2012	5.6800	2.4992	4.0000	1
10	9511	24	0	10	Q4	2012	2.8400	0.9088	2.0000	1
10	9534	17	0	5	Q2	2012	4.2600	1.5762	3.0000	1
10	9619	11	0	11	Q4	2012	4.2600	1.4910	3.0000	1
10	10233	24	0	1	Q1	2012	5.6800	2.1584	4.0000	1
11	177	13	0	2	Q1	2012	7.0200	2.8782	2.0000	1
11	179	6	0	7	Q3	2012	7.0200	2.7378	2.0000	1
11	251	24	1851	4	Q2	2012	7.0200	2.3166	2.0000	1
11	285	7	512	6	Q2	2012	14.0400	5.7564	4.0000	1
11	288	6	521	10	Q4	2012	17.5500	8.0730	5.0000	1
11	336	6	508	4	Q2	2012	7.0200	2.2464	2.0000	1
11	360	24	0	1	Q1	2012	14.0400	4.7736	4.0000	1
11	430	16	0	5	Q2	2012	14.0400	4.4928	4.0000	1
11	511	16	0	12	Q4	2012	10.5300	5.0544	3.0000	1
11	588	23	1789	12	Q4	2012	14.0400	5.8968	4.0000	1
11	612	22	0	8	Q3	2012	7.0200	3.0186	2.0000	1
11	921	23	0	6	Q2	2012	7.0200	3.0186	2.0000	1
11	1145	17	0	9	Q3	2012	10.5300	3.7908	3.0000	1
11	1266	13	0	10	Q4	2012	10.5300	4.9491	3.0000	1
11	1676	3	0	10	Q4	2012	17.5500	5.9670	5.0000	1
11	1813	17	0	3	Q1	2012	14.0400	6.7392	4.0000	1
11	1896	22	0	11	Q4	2012	7.0200	3.0888	2.0000	1
11	1953	7	526	12	Q4	2012	14.0400	6.1776	4.0000	1
11	2110	11	0	11	Q4	2012	14.0400	6.8796	4.0000	1
11	2147	13	976	1	Q1	2012	10.5300	3.7908	3.0000	1
11	2195	6	0	12	Q4	2012	7.0200	2.1762	2.0000	1
11	2277	6	0	6	Q2	2012	10.5300	4.5279	3.0000	1
11	2327	13	0	1	Q1	2012	17.5500	7.1955	5.0000	1
11	2556	3	210	12	Q4	2012	10.5300	4.6332	3.0000	1
11	2558	7	0	5	Q2	2012	14.0400	6.4584	4.0000	1
11	2942	17	0	11	Q4	2012	10.5300	4.9491	3.0000	1
11	3115	7	523	11	Q4	2012	14.0400	4.3524	4.0000	1
11	3130	13	0	12	Q4	2012	10.5300	4.9491	3.0000	1
11	3153	13	0	1	Q1	2012	10.5300	3.2643	3.0000	1
11	3236	15	0	4	Q2	2012	10.5300	4.9491	3.0000	1
11	3305	13	984	5	Q2	2012	14.0400	5.4756	4.0000	1
11	3422	23	0	10	Q4	2012	10.5300	4.8438	3.0000	1
11	3427	24	0	5	Q2	2012	17.5500	5.9670	5.0000	1
11	3441	3	0	3	Q1	2012	7.0200	2.4570	2.0000	1
11	3484	14	0	7	Q3	2012	7.0200	2.3166	2.0000	1
11	3509	24	1856	6	Q2	2012	7.0200	2.5974	2.0000	1
11	3726	6	0	5	Q2	2012	14.0400	5.7564	4.0000	1
11	3925	11	0	1	Q1	2012	14.0400	6.8796	4.0000	1
11	4029	17	0	12	Q4	2012	14.0400	4.4928	4.0000	1
11	5001	7	0	10	Q4	2012	14.0400	4.6332	4.0000	1
11	5001	6	522	10	Q4	2012	14.0400	4.3524	4.0000	1
11	5079	6	504	2	Q1	2012	17.5500	7.5465	5.0000	1
11	5215	14	0	10	Q4	2012	7.0200	3.0888	2.0000	1
11	5295	16	0	10	Q4	2012	10.5300	4.2120	3.0000	1
11	5768	3	0	10	Q4	2012	14.0400	4.7736	4.0000	1
11	6098	3	205	10	Q4	2012	10.5300	3.1590	3.0000	1
11	6114	16	0	9	Q3	2012	10.5300	4.6332	3.0000	1
11	6155	15	0	3	Q1	2012	10.5300	3.4749	3.0000	1
11	6484	22	1711	12	Q4	2012	7.0200	3.2292	2.0000	1
11	6888	23	0	11	Q4	2012	10.5300	4.1067	3.0000	1
11	7032	2	0	12	Q4	2012	7.0200	2.8782	2.0000	1
11	7101	15	0	9	Q3	2012	7.0200	3.4398	2.0000	1
11	7204	11	0	12	Q4	2012	14.0400	5.3352	4.0000	1
11	7247	24	0	5	Q2	2012	14.0400	4.3524	4.0000	1
11	7282	17	0	12	Q4	2012	14.0400	6.3180	4.0000	1
11	7354	3	205	10	Q4	2012	10.5300	3.8961	3.0000	1
11	7502	16	1220	4	Q2	2012	14.0400	6.5988	4.0000	1
11	7801	7	0	3	Q1	2012	10.5300	3.7908	3.0000	1
11	8054	15	1134	1	Q1	2012	10.5300	3.8961	3.0000	1
11	8619	13	0	8	Q3	2012	7.0200	2.5974	2.0000	1
11	8814	13	0	4	Q2	2012	14.0400	4.3524	4.0000	1
11	8937	7	523	11	Q4	2012	14.0400	6.5988	4.0000	1
11	8946	23	1773	4	Q2	2012	14.0400	5.7564	4.0000	1
11	9065	13	0	3	Q1	2012	14.0400	4.7736	4.0000	1
11	9111	17	1307	8	Q3	2012	10.5300	3.1590	3.0000	1
11	9161	24	0	2	Q1	2012	10.5300	4.9491	3.0000	1
11	9263	16	1220	4	Q2	2012	10.5300	5.0544	3.0000	1
11	9324	3	0	8	Q3	2012	7.0200	3.5100	2.0000	1
11	9401	13	0	2	Q1	2012	10.5300	5.0544	3.0000	1
11	9418	24	0	3	Q1	2012	10.5300	3.8961	3.0000	1
11	9699	15	1152	9	Q3	2012	17.5500	7.7220	5.0000	1
11	9851	3	201	8	Q3	2012	7.0200	2.6676	2.0000	1
11	9980	6	526	12	Q4	2012	14.0400	4.7736	4.0000	1
12	644	13	0	10	Q4	2012	6.1600	2.9568	4.0000	1
12	647	3	0	4	Q2	2012	4.6200	1.7094	3.0000	1
12	647	3	0	12	Q4	2012	3.0800	1.4476	2.0000	1
12	652	6	0	3	Q1	2012	3.0800	1.1704	2.0000	1
12	663	16	1220	4	Q2	2012	4.6200	2.1714	3.0000	1
12	863	17	0	11	Q4	2012	6.1600	2.8336	4.0000	1
12	950	13	986	6	Q2	2012	4.6200	2.2638	3.0000	1
12	1004	17	1311	10	Q4	2012	6.1600	2.7104	4.0000	1
12	1185	17	0	6	Q2	2012	6.1600	2.8336	4.0000	1
12	1203	7	0	6	Q2	2012	4.6200	1.6170	3.0000	1
12	1205	15	0	2	Q1	2012	6.1600	2.3408	4.0000	1
12	1267	13	0	8	Q3	2012	7.7000	2.4640	5.0000	1
12	1276	24	0	1	Q1	2012	7.7000	3.3110	5.0000	1
12	1994	15	0	9	Q3	2012	6.1600	2.0944	4.0000	1
12	2077	23	1781	8	Q3	2012	6.1600	2.2792	4.0000	1
12	2129	7	518	8	Q3	2012	4.6200	1.8480	3.0000	1
12	2147	13	0	1	Q1	2012	6.1600	2.8952	4.0000	1
12	2390	17	1292	1	Q1	2012	4.6200	1.5708	3.0000	1
12	2421	7	0	11	Q4	2012	4.6200	1.7094	3.0000	1
12	2612	24	0	7	Q3	2012	3.0800	1.0780	2.0000	1
12	2738	15	1140	4	Q2	2012	4.6200	2.1714	3.0000	1
12	3065	3	0	3	Q1	2012	3.0800	1.4168	2.0000	1
12	3113	13	0	3	Q1	2012	4.6200	1.8018	3.0000	1
12	3291	6	0	3	Q1	2012	6.1600	2.9568	4.0000	1
12	3463	13	0	3	Q1	2012	3.0800	0.9856	2.0000	1
12	3550	11	0	12	Q4	2012	3.0800	1.0472	2.0000	1
12	3640	24	0	6	Q2	2012	3.0800	1.1704	2.0000	1
12	3816	3	0	6	Q2	2012	3.0800	1.3860	2.0000	1
12	4082	24	0	10	Q4	2012	4.6200	1.5708	3.0000	1
12	4372	13	0	10	Q4	2012	3.0800	1.2936	2.0000	1
12	4479	7	0	3	Q1	2012	6.1600	2.8336	4.0000	1
12	4659	13	0	3	Q1	2012	4.6200	1.8942	3.0000	1
12	4736	13	0	8	Q3	2012	6.1600	2.7720	4.0000	1
12	4910	24	1869	12	Q4	2012	4.6200	1.5708	3.0000	1
12	5118	11	836	9	Q3	2012	4.6200	1.6170	3.0000	1
12	5245	11	0	11	Q4	2012	6.1600	2.1560	4.0000	1
12	5738	3	0	4	Q2	2012	4.6200	2.2176	3.0000	1
12	5895	17	0	3	Q1	2012	3.0800	0.9856	2.0000	1
12	6299	7	0	7	Q3	2012	4.6200	2.2638	3.0000	1
12	6332	6	519	9	Q3	2012	6.1600	3.0800	4.0000	1
12	6764	7	0	7	Q3	2012	6.1600	2.8336	4.0000	1
12	7005	15	0	11	Q4	2012	6.1600	2.8336	4.0000	1
12	7051	16	1220	4	Q2	2012	4.6200	2.2638	3.0000	1
12	7265	24	1866	11	Q4	2012	7.7000	2.6950	5.0000	1
12	7266	24	0	4	Q2	2012	6.1600	1.9712	4.0000	1
12	7368	11	0	1	Q1	2012	4.6200	2.1714	3.0000	1
12	7579	15	0	10	Q4	2012	4.6200	2.3100	3.0000	1
12	7775	6	0	8	Q3	2012	4.6200	1.7556	3.0000	1
12	8511	16	0	1	Q1	2012	4.6200	1.6170	3.0000	1
12	8577	23	0	1	Q1	2012	4.6200	2.3100	3.0000	1
12	8687	23	0	5	Q2	2012	3.0800	1.2936	2.0000	1
12	8841	13	0	11	Q4	2012	4.6200	1.7094	3.0000	1
12	8887	17	0	6	Q2	2012	7.7000	2.3870	5.0000	1
12	9101	7	0	3	Q1	2012	3.0800	1.3860	2.0000	1
12	9167	11	0	12	Q4	2012	6.1600	2.6488	4.0000	1
12	9176	23	1775	5	Q2	2012	6.1600	2.9568	4.0000	1
12	9271	17	0	5	Q2	2012	4.6200	1.8480	3.0000	1
12	9448	13	0	9	Q3	2012	4.6200	1.4322	3.0000	1
12	9581	24	1853	5	Q2	2012	6.1600	2.4640	4.0000	1
12	9797	16	0	9	Q3	2012	3.0800	1.2628	2.0000	1
13	28	15	1134	1	Q1	2012	10.6000	3.1800	4.0000	1
13	293	22	1694	4	Q2	2012	5.3000	2.5970	2.0000	1
13	341	17	0	3	Q1	2012	7.9500	2.8620	3.0000	1
13	571	3	204	9	Q3	2012	10.6000	4.3460	4.0000	1
13	813	11	821	3	Q1	2012	7.9500	3.1005	3.0000	1
13	817	17	0	10	Q4	2012	5.3000	2.4910	2.0000	1
13	819	13	0	3	Q1	2012	7.9500	3.8955	3.0000	1
13	975	7	504	2	Q1	2012	7.9500	2.9415	3.0000	1
13	994	13	0	10	Q4	2012	10.6000	3.2860	4.0000	1
13	1187	13	0	1	Q1	2012	7.9500	3.8955	3.0000	1
13	1216	17	0	1	Q1	2012	5.3000	2.3320	2.0000	1
13	1341	3	207	11	Q4	2012	5.3000	1.8020	2.0000	1
13	1451	3	0	3	Q1	2012	10.6000	4.4520	4.0000	1
13	1598	3	0	11	Q4	2012	7.9500	2.7030	3.0000	1
13	1647	7	523	11	Q4	2012	5.3000	1.6430	2.0000	1
13	2211	17	0	6	Q2	2012	10.6000	3.1800	4.0000	1
13	2610	7	0	6	Q2	2012	10.6000	3.4980	4.0000	1
13	2817	7	0	12	Q4	2012	5.3000	2.4380	2.0000	1
13	2942	17	1314	11	Q4	2012	7.9500	3.0210	3.0000	1
13	3258	7	518	8	Q3	2012	5.3000	1.9080	2.0000	1
13	3291	7	0	3	Q1	2012	5.3000	2.2790	2.0000	1
13	3316	7	517	8	Q3	2012	7.9500	3.4185	3.0000	1
13	3320	24	0	8	Q3	2012	5.3000	2.1730	2.0000	1
13	3448	3	0	3	Q1	2012	13.2500	4.3725	5.0000	1
13	3448	3	0	4	Q2	2012	10.6000	4.7700	4.0000	1
13	3463	13	0	7	Q3	2012	5.3000	1.6960	2.0000	1
13	3539	17	0	8	Q3	2012	7.9500	2.5440	3.0000	1
13	3819	23	1788	11	Q4	2012	7.9500	2.6235	3.0000	1
13	4301	11	829	6	Q2	2012	7.9500	2.5440	3.0000	1
13	4536	13	0	1	Q1	2012	10.6000	4.1340	4.0000	1
13	4589	13	992	9	Q3	2012	7.9500	3.2595	3.0000	1
13	4776	6	0	5	Q2	2012	7.9500	2.7030	3.0000	1
13	5063	3	190	3	Q1	2012	10.6000	3.7100	4.0000	1
13	5174	16	0	4	Q2	2012	10.6000	4.2400	4.0000	1
13	5592	16	0	10	Q4	2012	7.9500	2.9415	3.0000	1
13	5956	22	0	10	Q4	2012	2.6500	0.9540	1.0000	1
13	6324	23	1768	2	Q1	2012	10.6000	4.5580	4.0000	1
13	6710	13	0	7	Q3	2012	7.9500	2.8620	3.0000	1
13	6751	22	0	12	Q4	2012	7.9500	2.6235	3.0000	1
13	7072	16	0	6	Q2	2012	7.9500	3.4185	3.0000	1
13	7250	13	0	11	Q4	2012	10.6000	5.1940	4.0000	1
13	7262	13	0	11	Q4	2012	7.9500	3.3390	3.0000	1
13	7302	14	0	10	Q4	2012	5.3000	1.6430	2.0000	1
13	7341	24	1845	1	Q1	2012	5.3000	1.9610	2.0000	1
13	7434	11	842	12	Q4	2012	5.3000	1.6430	2.0000	1
13	7535	7	0	1	Q1	2012	5.3000	2.5440	2.0000	1
13	7743	3	0	1	Q1	2012	5.3000	2.3320	2.0000	1
13	7813	17	0	10	Q4	2012	10.6000	3.7100	4.0000	1
13	8165	15	0	6	Q2	2012	7.9500	2.8620	3.0000	1
13	8207	13	986	6	Q2	2012	7.9500	2.7030	3.0000	1
13	8289	17	0	9	Q3	2012	7.9500	2.7825	3.0000	1
13	8841	13	0	6	Q2	2012	7.9500	2.9415	3.0000	1
13	8976	13	982	4	Q2	2012	5.3000	2.0140	2.0000	1
13	9618	2	0	3	Q1	2012	2.6500	1.1130	1.0000	1
13	9747	13	0	12	Q4	2012	5.3000	2.0670	2.0000	1
14	834	24	0	9	Q3	2012	5.7900	1.7949	3.0000	1
14	1319	11	820	2	Q1	2012	3.8600	1.6984	2.0000	1
14	1511	11	0	5	Q2	2012	9.6500	4.2460	5.0000	1
14	1527	24	1869	12	Q4	2012	7.7200	3.7056	4.0000	1
14	1653	7	0	4	Q2	2012	3.8600	1.1966	2.0000	1
14	1759	7	0	7	Q3	2012	3.8600	1.8914	2.0000	1
14	1970	3	0	6	Q2	2012	5.7900	2.0265	3.0000	1
14	3473	15	0	7	Q3	2012	5.7900	2.8950	3.0000	1
14	3580	6	0	11	Q4	2012	5.7900	2.6055	3.0000	1
14	4000	15	0	9	Q3	2012	3.8600	1.5826	2.0000	1
14	4088	24	0	12	Q4	2012	5.7900	2.3160	3.0000	1
14	4122	15	1140	4	Q2	2012	5.7900	2.7792	3.0000	1
14	4466	13	992	9	Q3	2012	7.7200	3.6284	4.0000	1
14	4490	13	0	12	Q4	2012	7.7200	3.5512	4.0000	1
14	4543	13	988	7	Q3	2012	3.8600	1.6212	2.0000	1
14	4564	17	0	10	Q4	2012	5.7900	2.4318	3.0000	1
14	4727	16	0	1	Q1	2012	5.7900	2.8950	3.0000	1
14	4810	23	1776	6	Q2	2012	3.8600	1.4282	2.0000	1
14	4867	24	0	3	Q1	2012	7.7200	3.5512	4.0000	1
14	4939	2	126	10	Q4	2012	1.9300	0.7913	1.0000	1
14	5038	17	1304	7	Q3	2012	5.7900	2.4897	3.0000	1
14	5436	7	0	6	Q2	2012	5.7900	2.6634	3.0000	1
14	5590	17	0	1	Q1	2012	3.8600	1.3124	2.0000	1
14	5742	16	0	5	Q2	2012	5.7900	1.8528	3.0000	1
14	5923	23	1775	5	Q2	2012	7.7200	2.6248	4.0000	1
14	6220	24	0	2	Q1	2012	3.8600	1.5054	2.0000	1
14	6434	14	1065	6	Q2	2012	1.9300	0.7141	1.0000	1
14	6739	24	0	4	Q2	2012	5.7900	2.8371	3.0000	1
14	6799	17	1304	7	Q3	2012	3.8600	1.3896	2.0000	1
14	6904	13	0	1	Q1	2012	5.7900	2.8950	3.0000	1
14	7100	17	0	4	Q2	2012	5.7900	2.2581	3.0000	1
14	7813	17	0	12	Q4	2012	3.8600	1.3510	2.0000	1
14	7843	2	126	10	Q4	2012	5.7900	2.0265	3.0000	1
14	8452	16	0	1	Q1	2012	7.7200	2.7020	4.0000	1
14	9144	13	0	6	Q2	2012	5.7900	1.7949	3.0000	1
14	9160	6	508	4	Q2	2012	5.7900	1.7370	3.0000	1
14	9276	7	504	2	Q1	2012	5.7900	2.2581	3.0000	1
14	9276	7	512	6	Q2	2012	5.7900	2.5476	3.0000	1
14	9337	15	1138	3	Q1	2012	9.6500	4.1495	5.0000	1
14	9364	15	1141	4	Q2	2012	7.7200	3.3968	4.0000	1
14	9471	7	0	3	Q1	2012	3.8600	1.7370	2.0000	1
14	9510	16	0	10	Q4	2012	7.7200	3.3968	4.0000	1
14	9858	24	1850	3	Q1	2012	3.8600	1.3510	2.0000	1
14	10053	6	508	4	Q2	2012	7.7200	3.6284	4.0000	1
15	341	17	0	5	Q2	2012	4.5800	1.8778	2.0000	1
15	739	23	1789	12	Q4	2012	6.8700	3.0228	3.0000	1
15	997	3	0	6	Q2	2012	9.1600	4.1220	4.0000	1
15	1387	11	0	1	Q1	2012	9.1600	4.1220	4.0000	1
15	1758	3	0	1	Q1	2012	4.5800	1.6488	2.0000	1
15	1771	2	0	1	Q1	2012	4.5800	1.6030	2.0000	1
15	1813	17	1314	11	Q4	2012	6.8700	2.8167	3.0000	1
15	2067	17	0	3	Q1	2012	4.5800	1.9694	2.0000	1
15	2086	13	0	6	Q2	2012	4.5800	2.0152	2.0000	1
15	2168	24	0	4	Q2	2012	11.4500	5.0380	5.0000	1
15	2180	2	0	9	Q3	2012	6.8700	3.0228	3.0000	1
15	2197	11	0	11	Q4	2012	9.1600	2.7480	4.0000	1
15	2556	3	195	5	Q2	2012	6.8700	2.2671	3.0000	1
15	3000	17	0	4	Q2	2012	6.8700	3.2289	3.0000	1
15	3000	17	1293	1	Q1	2012	4.5800	2.0152	2.0000	1
15	3199	24	0	9	Q3	2012	4.5800	2.1526	2.0000	1
15	3538	11	0	3	Q1	2012	4.5800	2.1984	2.0000	1
15	3691	17	1311	10	Q4	2012	6.8700	3.1602	3.0000	1
15	3847	11	826	5	Q2	2012	4.5800	1.6488	2.0000	1
15	4868	16	0	8	Q3	2012	6.8700	2.9541	3.0000	1
15	5001	6	0	12	Q4	2012	6.8700	2.3358	3.0000	1
15	5410	17	0	4	Q2	2012	6.8700	3.0228	3.0000	1
15	5542	16	0	5	Q2	2012	6.8700	2.8167	3.0000	1
15	5560	13	0	7	Q3	2012	6.8700	3.4350	3.0000	1
15	5674	6	0	6	Q2	2012	9.1600	3.9388	4.0000	1
15	5945	7	0	7	Q3	2012	6.8700	2.6106	3.0000	1
15	6056	15	0	5	Q2	2012	9.1600	4.2136	4.0000	1
15	6307	16	0	2	Q1	2012	9.1600	3.2976	4.0000	1
15	6433	15	1143	5	Q2	2012	9.1600	4.0304	4.0000	1
15	6531	13	984	5	Q2	2012	9.1600	3.2976	4.0000	1
15	6574	13	0	9	Q3	2012	6.8700	2.1297	3.0000	1
15	6712	16	0	11	Q4	2012	6.8700	2.1297	3.0000	1
15	6792	13	0	4	Q2	2012	6.8700	2.4732	3.0000	1
15	6866	17	1314	11	Q4	2012	6.8700	3.0228	3.0000	1
15	7469	7	0	10	Q4	2012	9.1600	3.7556	4.0000	1
15	7526	17	0	3	Q1	2012	6.8700	2.0610	3.0000	1
15	7695	6	526	12	Q4	2012	6.8700	2.4732	3.0000	1
15	7913	17	0	2	Q1	2012	6.8700	3.2976	3.0000	1
15	8009	15	0	7	Q3	2012	4.5800	1.7862	2.0000	1
15	8310	13	0	1	Q1	2012	6.8700	2.3358	3.0000	1
15	8356	15	0	6	Q2	2012	9.1600	3.7556	4.0000	1
15	9504	13	0	2	Q1	2012	6.8700	2.1297	3.0000	1
15	9694	7	0	11	Q4	2012	6.8700	2.6793	3.0000	1
15	9823	13	0	7	Q3	2012	9.1600	3.3892	4.0000	1
15	9866	3	0	7	Q3	2012	4.5800	1.7404	2.0000	1
15	10079	24	0	2	Q1	2012	4.5800	1.4656	2.0000	1
16	118	3	0	4	Q2	2012	11.4900	3.9066	3.0000	1
16	121	6	0	10	Q4	2012	15.3200	6.7408	4.0000	1
16	190	13	0	3	Q1	2012	7.6600	3.6002	2.0000	1
16	466	7	0	11	Q4	2012	7.6600	3.0640	2.0000	1
16	530	24	0	11	Q4	2012	15.3200	6.7408	4.0000	1
16	760	3	0	12	Q4	2012	11.4900	4.1364	3.0000	1
16	813	11	0	12	Q4	2012	15.3200	5.8216	4.0000	1
16	1141	11	0	4	Q2	2012	7.6600	2.4512	2.0000	1
16	1297	16	1231	9	Q3	2012	15.3200	5.9748	4.0000	1
16	1632	7	501	1	Q1	2012	11.4900	3.7917	3.0000	1
16	2006	11	0	3	Q1	2012	11.4900	4.2513	3.0000	1
16	3020	13	0	12	Q4	2012	15.3200	5.2088	4.0000	1
16	3215	15	1150	8	Q3	2012	11.4900	4.8258	3.0000	1
16	3821	15	0	1	Q1	2012	15.3200	6.4344	4.0000	1
16	3826	16	1236	12	Q4	2012	11.4900	3.5619	3.0000	1
16	4369	15	0	11	Q4	2012	15.3200	5.5152	4.0000	1
16	4373	11	0	3	Q1	2012	11.4900	4.9407	3.0000	1
16	4727	16	0	6	Q2	2012	11.4900	3.5619	3.0000	1
16	4810	23	1789	12	Q4	2012	15.3200	7.5068	4.0000	1
16	5000	11	826	5	Q2	2012	7.6600	2.4512	2.0000	1
16	5560	13	0	5	Q2	2012	11.4900	5.7450	3.0000	1
16	5592	16	0	1	Q1	2012	11.4900	3.9066	3.0000	1
16	5714	7	505	2	Q1	2012	15.3200	7.3536	4.0000	1
16	5962	17	0	11	Q4	2012	19.1500	8.4260	5.0000	1
16	6348	16	0	1	Q1	2012	7.6600	2.8342	2.0000	1
16	6802	6	0	2	Q1	2012	11.4900	3.5619	3.0000	1
16	7133	22	0	3	Q1	2012	3.8300	1.8767	1.0000	1
16	7502	16	1236	12	Q4	2012	15.3200	5.5152	4.0000	1
16	7521	13	0	3	Q1	2012	11.4900	3.4470	3.0000	1
16	7573	3	0	2	Q1	2012	7.6600	2.5278	2.0000	1
16	7841	6	0	9	Q3	2012	15.3200	7.5068	4.0000	1
16	8033	24	0	10	Q4	2012	11.4900	5.2854	3.0000	1
16	8220	24	0	1	Q1	2012	11.4900	4.0215	3.0000	1
16	8310	13	986	6	Q2	2012	11.4900	3.9066	3.0000	1
16	8454	17	0	6	Q2	2012	15.3200	6.5876	4.0000	1
16	8668	13	0	9	Q3	2012	11.4900	4.9407	3.0000	1
16	8872	24	1866	11	Q4	2012	15.3200	7.5068	4.0000	1
16	9064	17	1304	7	Q3	2012	11.4900	3.4470	3.0000	1
16	9315	7	516	8	Q3	2012	11.4900	5.6301	3.0000	1
16	9556	15	1152	9	Q3	2012	15.3200	6.5876	4.0000	1
16	10225	23	0	10	Q4	2012	15.3200	4.7492	4.0000	1
17	158	17	0	9	Q3	2012	5.9800	1.9136	2.0000	1
17	723	6	0	9	Q3	2012	8.9700	4.4850	3.0000	1
17	763	6	502	1	Q1	2012	11.9600	5.6212	4.0000	1
17	1185	17	0	1	Q1	2012	8.9700	3.9468	3.0000	1
17	1253	13	0	3	Q1	2012	8.9700	2.9601	3.0000	1
17	1389	6	0	12	Q4	2012	8.9700	4.2159	3.0000	1
17	1567	16	0	1	Q1	2012	8.9700	3.1395	3.0000	1
17	1607	17	0	11	Q4	2012	8.9700	3.9468	3.0000	1
17	1611	13	0	8	Q3	2012	8.9700	3.0498	3.0000	1
17	2151	13	0	9	Q3	2012	5.9800	2.6312	2.0000	1
17	2165	24	0	9	Q3	2012	8.9700	3.6777	3.0000	1
17	2448	16	0	9	Q3	2012	8.9700	3.4983	3.0000	1
17	2460	24	1859	8	Q3	2012	11.9600	5.8604	4.0000	1
17	2571	6	519	9	Q3	2012	5.9800	1.9136	2.0000	1
17	3020	13	0	1	Q1	2012	11.9600	5.7408	4.0000	1
17	3742	11	826	5	Q2	2012	5.9800	2.6312	2.0000	1
17	3976	17	0	3	Q1	2012	8.9700	4.2159	3.0000	1
17	4021	16	0	5	Q2	2012	11.9600	4.3056	4.0000	1
17	4075	3	0	3	Q1	2012	11.9600	4.4252	4.0000	1
17	4161	7	0	12	Q4	2012	8.9700	2.7807	3.0000	1
17	4181	24	0	8	Q3	2012	5.9800	2.6312	2.0000	1
17	4397	16	0	11	Q4	2012	11.9600	5.6212	4.0000	1
17	5019	23	0	1	Q1	2012	11.9600	5.5016	4.0000	1
17	5040	15	0	7	Q3	2012	5.9800	2.3322	2.0000	1
17	5158	3	0	3	Q1	2012	8.9700	3.4983	3.0000	1
17	5293	7	0	7	Q3	2012	8.9700	4.3056	3.0000	1
17	5293	7	0	11	Q4	2012	8.9700	4.3056	3.0000	1
17	5883	24	0	12	Q4	2012	11.9600	4.5448	4.0000	1
17	6049	15	0	10	Q4	2012	11.9600	3.9468	4.0000	1
17	6132	3	195	5	Q2	2012	5.9800	2.0930	2.0000	1
17	6134	15	0	3	Q1	2012	11.9600	5.5016	4.0000	1
17	6207	7	517	8	Q3	2012	8.9700	3.4983	3.0000	1
17	6683	17	0	9	Q3	2012	5.9800	2.3920	2.0000	1
17	6835	16	0	5	Q2	2012	11.9600	5.2624	4.0000	1
17	6988	7	505	2	Q1	2012	14.9500	4.7840	5.0000	1
17	7067	13	0	6	Q2	2012	8.9700	2.6910	3.0000	1
17	7120	15	0	12	Q4	2012	8.9700	3.2292	3.0000	1
17	7355	13	0	12	Q4	2012	11.9600	5.0232	4.0000	1
17	7459	7	0	11	Q4	2012	5.9800	2.9302	2.0000	1
17	7678	23	0	8	Q3	2012	5.9800	2.1528	2.0000	1
17	7831	17	0	4	Q2	2012	11.9600	3.5880	4.0000	1
17	7933	14	1078	12	Q4	2012	5.9800	2.6910	2.0000	1
17	8073	24	0	1	Q1	2012	5.9800	2.2126	2.0000	1
17	8301	24	0	2	Q1	2012	11.9600	3.9468	4.0000	1
17	8373	13	0	3	Q1	2012	11.9600	3.5880	4.0000	1
17	8467	13	0	9	Q3	2012	14.9500	7.3255	5.0000	1
17	8511	16	0	11	Q4	2012	8.9700	3.1395	3.0000	1
17	8570	11	0	11	Q4	2012	5.9800	2.7508	2.0000	1
17	8629	24	1853	5	Q2	2012	8.9700	3.4086	3.0000	1
17	8746	23	1783	9	Q3	2012	8.9700	3.7674	3.0000	1
17	8960	3	185	1	Q1	2012	8.9700	2.6910	3.0000	1
17	9111	17	1293	1	Q1	2012	8.9700	3.3189	3.0000	1
17	9318	16	0	6	Q2	2012	8.9700	3.0498	3.0000	1
17	9760	13	0	9	Q3	2012	8.9700	4.2159	3.0000	1
17	9937	17	1304	7	Q3	2012	5.9800	2.0930	2.0000	1
17	10273	17	0	9	Q3	2012	11.9600	4.0664	4.0000	1
18	265	11	0	9	Q3	2012	8.0100	2.7234	3.0000	1
18	294	24	0	9	Q3	2012	5.3400	1.6554	2.0000	1
18	392	13	984	5	Q2	2012	5.3400	1.7088	2.0000	1
18	1186	7	0	5	Q2	2012	8.0100	3.3642	3.0000	1
18	1285	15	0	11	Q4	2012	10.6800	5.2332	4.0000	1
18	1491	16	0	8	Q3	2012	10.6800	3.7380	4.0000	1
18	1920	6	0	9	Q3	2012	10.6800	5.2332	4.0000	1
18	1999	11	0	5	Q2	2012	5.3400	2.4030	2.0000	1
18	2077	23	1789	12	Q4	2012	10.6800	5.0196	4.0000	1
18	2663	16	1235	11	Q4	2012	8.0100	2.9637	3.0000	1
18	2689	3	207	11	Q4	2012	5.3400	2.5632	2.0000	1
18	2772	24	0	11	Q4	2012	10.6800	4.3788	4.0000	1
18	2900	7	0	6	Q2	2012	8.0100	2.4831	3.0000	1
18	3113	13	0	6	Q2	2012	8.0100	3.2040	3.0000	1
18	3305	13	0	11	Q4	2012	8.0100	3.5244	3.0000	1
18	4261	13	0	7	Q3	2012	5.3400	1.9758	2.0000	1
18	4431	13	0	4	Q2	2012	5.3400	2.2962	2.0000	1
18	4547	13	0	2	Q1	2012	8.0100	3.7647	3.0000	1
18	4875	13	980	3	Q1	2012	5.3400	2.4564	2.0000	1
18	5346	3	0	6	Q2	2012	10.6800	3.8448	4.0000	1
18	5387	7	0	7	Q3	2012	8.0100	3.5244	3.0000	1
18	5461	22	1709	11	Q4	2012	2.6700	1.0947	1.0000	1
18	5598	24	0	11	Q4	2012	8.0100	3.5244	3.0000	1
18	5646	14	0	9	Q3	2012	2.6700	0.9879	1.0000	1
18	5707	23	1773	4	Q2	2012	8.0100	3.3642	3.0000	1
18	5734	13	0	3	Q1	2012	5.3400	1.8690	2.0000	1
18	5829	22	0	12	Q4	2012	5.3400	1.8156	2.0000	1
18	5873	2	0	3	Q1	2012	2.6700	0.8544	1.0000	1
18	6047	17	1314	11	Q4	2012	8.0100	3.2040	3.0000	1
18	6506	6	0	10	Q4	2012	10.6800	3.4176	4.0000	1
18	6531	13	0	5	Q2	2012	5.3400	1.9224	2.0000	1
18	6630	24	1860	8	Q3	2012	5.3400	2.0826	2.0000	1
18	6670	7	504	2	Q1	2012	5.3400	2.4030	2.0000	1
18	6698	13	980	3	Q1	2012	8.0100	3.1239	3.0000	1
18	6866	17	1314	11	Q4	2012	5.3400	2.2428	2.0000	1
18	7051	16	1220	4	Q2	2012	8.0100	3.3642	3.0000	1
18	7283	13	976	1	Q1	2012	8.0100	3.9249	3.0000	1
18	7290	24	1866	11	Q4	2012	10.6800	3.6312	4.0000	1
18	8171	24	0	1	Q1	2012	5.3400	2.6166	2.0000	1
18	8257	24	1851	4	Q2	2012	10.6800	5.0196	4.0000	1
18	8347	24	0	8	Q3	2012	8.0100	2.4030	3.0000	1
18	9604	24	0	8	Q3	2012	10.6800	3.6312	4.0000	1
18	9671	13	0	1	Q1	2012	5.3400	1.8690	2.0000	1
18	9826	13	0	4	Q2	2012	10.6800	4.2720	4.0000	1
18	9846	24	1845	1	Q1	2012	10.6800	4.4856	4.0000	1
18	10034	15	0	2	Q1	2012	8.0100	3.1239	3.0000	1
19	490	11	0	5	Q2	2012	12.7600	3.9556	4.0000	1
19	705	6	0	7	Q3	2012	15.9500	5.1040	5.0000	1
19	819	13	0	12	Q4	2012	6.3800	2.4244	2.0000	1
19	905	3	210	12	Q4	2012	12.7600	6.1248	4.0000	1
19	1007	11	818	1	Q1	2012	9.5700	4.3065	3.0000	1
19	1053	13	0	9	Q3	2012	6.3800	1.9778	2.0000	1
19	1224	24	0	11	Q4	2012	12.7600	5.1040	4.0000	1
19	1531	6	0	9	Q3	2012	9.5700	4.6893	3.0000	1
19	1613	7	0	9	Q3	2012	6.3800	2.8072	2.0000	1
19	1755	24	1846	2	Q1	2012	9.5700	2.8710	3.0000	1
19	2147	13	982	4	Q2	2012	9.5700	4.1151	3.0000	1
19	2548	13	0	7	Q3	2012	9.5700	3.4452	3.0000	1
19	2556	3	188	2	Q1	2012	6.3800	2.8072	2.0000	1
19	2570	16	1223	6	Q2	2012	12.7600	4.7212	4.0000	1
19	2690	3	0	2	Q1	2012	9.5700	4.1151	3.0000	1
19	2808	13	0	7	Q3	2012	9.5700	4.4022	3.0000	1
19	2850	3	0	9	Q3	2012	9.5700	3.1581	3.0000	1
19	3253	13	0	10	Q4	2012	12.7600	4.2108	4.0000	1
19	3334	17	0	5	Q2	2012	12.7600	6.1248	4.0000	1
19	3524	13	0	8	Q3	2012	6.3800	2.6158	2.0000	1
19	3719	23	0	7	Q3	2012	6.3800	1.9778	2.0000	1
19	3977	13	0	6	Q2	2012	12.7600	4.8488	4.0000	1
19	4021	16	0	5	Q2	2012	9.5700	4.4979	3.0000	1
19	4220	11	0	11	Q4	2012	9.5700	3.1581	3.0000	1
19	4342	13	0	7	Q3	2012	12.7600	4.7212	4.0000	1
19	4507	13	0	10	Q4	2012	12.7600	5.2316	4.0000	1
19	5067	17	1312	10	Q4	2012	6.3800	3.1262	2.0000	1
19	5070	13	0	5	Q2	2012	12.7600	5.1040	4.0000	1
19	5353	23	1765	1	Q1	2012	6.3800	2.1054	2.0000	1
19	5444	15	1138	3	Q1	2012	9.5700	4.1151	3.0000	1
19	5610	13	992	9	Q3	2012	9.5700	2.8710	3.0000	1
19	5717	7	517	8	Q3	2012	12.7600	5.6144	4.0000	1
19	5731	6	0	12	Q4	2012	12.7600	4.8488	4.0000	1
19	5862	2	0	12	Q4	2012	6.3800	1.9778	2.0000	1
19	6256	7	0	12	Q4	2012	9.5700	2.9667	3.0000	1
19	6799	17	0	3	Q1	2012	9.5700	4.6893	3.0000	1
19	7117	15	0	6	Q2	2012	9.5700	4.5936	3.0000	1
19	7181	7	0	12	Q4	2012	9.5700	2.9667	3.0000	1
19	7241	17	0	4	Q2	2012	6.3800	1.9778	2.0000	1
19	7276	23	0	3	Q1	2012	6.3800	2.2968	2.0000	1
19	7453	24	0	9	Q3	2012	12.7600	5.2316	4.0000	1
19	7478	6	0	1	Q1	2012	9.5700	4.6893	3.0000	1
19	7502	16	0	8	Q3	2012	12.7600	5.9972	4.0000	1
19	7571	6	0	12	Q4	2012	6.3800	3.1262	2.0000	1
19	7818	11	829	6	Q2	2012	9.5700	2.9667	3.0000	1
19	7909	3	0	9	Q3	2012	12.7600	4.0832	4.0000	1
19	8003	3	0	4	Q2	2012	6.3800	3.0624	2.0000	1
19	8096	6	0	8	Q3	2012	9.5700	4.1151	3.0000	1
19	8218	22	0	10	Q4	2012	6.3800	1.9778	2.0000	1
19	8351	16	0	6	Q2	2012	12.7600	4.0832	4.0000	1
19	8452	16	0	11	Q4	2012	15.9500	5.4230	5.0000	1
19	8505	7	0	11	Q4	2012	9.5700	3.5409	3.0000	1
19	9124	24	0	8	Q3	2012	12.7600	5.4868	4.0000	1
19	9397	11	0	11	Q4	2012	12.7600	5.8696	4.0000	1
19	9431	7	0	12	Q4	2012	12.7600	4.9764	4.0000	1
19	9815	16	1236	12	Q4	2012	6.3800	3.0624	2.0000	1
20	99	3	0	6	Q2	2012	11.1200	3.8920	4.0000	1
20	133	6	523	11	Q4	2012	8.3400	3.3360	3.0000	1
20	373	13	986	6	Q2	2012	5.5600	2.6132	2.0000	1
20	625	13	0	12	Q4	2012	5.5600	1.8904	2.0000	1
20	751	6	0	6	Q2	2012	11.1200	4.7816	4.0000	1
20	1168	17	0	7	Q3	2012	11.1200	4.5592	4.0000	1
20	1310	16	0	10	Q4	2012	8.3400	3.1692	3.0000	1
20	1339	13	0	8	Q3	2012	11.1200	4.8928	4.0000	1
20	1538	6	521	10	Q4	2012	5.5600	2.1684	2.0000	1
20	1545	15	0	9	Q3	2012	8.3400	3.6696	3.0000	1
20	1720	16	0	1	Q1	2012	11.1200	3.5584	4.0000	1
20	1922	15	0	5	Q2	2012	8.3400	2.5854	3.0000	1
20	2245	11	0	10	Q4	2012	11.1200	3.6696	4.0000	1
20	2431	3	0	11	Q4	2012	8.3400	3.9198	3.0000	1
20	2909	15	0	10	Q4	2012	11.1200	4.4480	4.0000	1
20	2918	17	0	8	Q3	2012	8.3400	3.5862	3.0000	1
20	3161	13	0	2	Q1	2012	13.9000	5.9770	5.0000	1
20	3386	24	0	7	Q3	2012	8.3400	3.0858	3.0000	1
20	3418	3	0	9	Q3	2012	5.5600	2.0016	2.0000	1
20	3804	24	0	7	Q3	2012	5.5600	2.0572	2.0000	1
20	4273	11	0	8	Q3	2012	5.5600	2.0016	2.0000	1
20	4445	17	0	3	Q1	2012	8.3400	4.1700	3.0000	1
20	4609	23	1772	4	Q2	2012	11.1200	4.8928	4.0000	1
20	5374	16	1235	11	Q4	2012	5.5600	2.2240	2.0000	1
20	5592	16	0	6	Q2	2012	8.3400	3.0858	3.0000	1
20	5913	7	0	5	Q2	2012	11.1200	5.1152	4.0000	1
20	5992	15	0	7	Q3	2012	11.1200	4.6704	4.0000	1
20	6153	16	0	3	Q1	2012	13.9000	5.6990	5.0000	1
20	6301	15	0	8	Q3	2012	11.1200	5.1152	4.0000	1
20	6389	24	0	9	Q3	2012	11.1200	3.8920	4.0000	1
20	6526	13	980	3	Q1	2012	11.1200	4.8928	4.0000	1
20	6941	15	0	11	Q4	2012	5.5600	2.0016	2.0000	1
20	6997	13	0	8	Q3	2012	5.5600	2.1684	2.0000	1
20	7220	3	0	3	Q1	2012	8.3400	3.6696	3.0000	1
20	7297	11	0	6	Q2	2012	13.9000	6.3940	5.0000	1
20	7314	14	1056	1	Q1	2012	5.5600	1.8348	2.0000	1
20	7386	6	0	6	Q2	2012	5.5600	1.9460	2.0000	1
20	7534	13	0	10	Q4	2012	8.3400	3.2526	3.0000	1
20	7750	15	1138	3	Q1	2012	11.1200	5.2264	4.0000	1
20	7822	3	0	10	Q4	2012	8.3400	3.1692	3.0000	1
20	7920	17	0	9	Q3	2012	11.1200	5.2264	4.0000	1
20	8171	24	0	8	Q3	2012	5.5600	2.2796	2.0000	1
20	8283	17	1304	7	Q3	2012	8.3400	3.5862	3.0000	1
20	8291	13	0	9	Q3	2012	5.5600	2.5020	2.0000	1
20	8633	24	1860	8	Q3	2012	5.5600	1.7236	2.0000	1
20	9134	23	1773	4	Q2	2012	5.5600	2.0572	2.0000	1
20	9817	14	0	10	Q4	2012	2.7800	1.1954	1.0000	1
20	9920	15	0	8	Q3	2012	8.3400	3.6696	3.0000	1
20	10161	6	0	4	Q2	2012	8.3400	3.2526	3.0000	1
21	190	13	0	3	Q1	2012	6.9900	2.8659	3.0000	1
21	545	13	0	10	Q4	2012	9.3200	3.0756	4.0000	1
21	625	13	0	10	Q4	2012	4.6600	1.5378	2.0000	1
21	878	3	0	6	Q2	2012	6.9900	2.4465	3.0000	1
21	893	13	0	9	Q3	2012	6.9900	3.3552	3.0000	1
21	930	17	1303	6	Q2	2012	6.9900	2.1669	3.0000	1
21	936	24	0	6	Q2	2012	6.9900	2.2368	3.0000	1
21	1310	16	0	8	Q3	2012	6.9900	3.4251	3.0000	1
21	1339	13	0	4	Q2	2012	6.9900	2.2368	3.0000	1
21	1352	17	0	12	Q4	2012	11.6500	3.8445	5.0000	1
21	1528	16	1231	9	Q3	2012	9.3200	4.3804	4.0000	1
21	1724	6	0	10	Q4	2012	6.9900	2.5863	3.0000	1
21	1795	24	1869	12	Q4	2012	9.3200	4.0076	4.0000	1
21	1811	11	0	12	Q4	2012	6.9900	2.5863	3.0000	1
21	1832	23	0	11	Q4	2012	9.3200	4.1008	4.0000	1
21	1979	3	0	10	Q4	2012	6.9900	3.2154	3.0000	1
21	2011	23	1789	12	Q4	2012	11.6500	5.1260	5.0000	1
21	2043	24	0	5	Q2	2012	6.9900	3.4950	3.0000	1
21	2147	13	976	1	Q1	2012	6.9900	3.2853	3.0000	1
21	2241	7	0	11	Q4	2012	9.3200	4.5668	4.0000	1
21	2246	13	0	8	Q3	2012	9.3200	3.9144	4.0000	1
21	2293	7	0	12	Q4	2012	4.6600	1.9572	2.0000	1
21	2327	13	0	6	Q2	2012	4.6600	2.0970	2.0000	1
21	2378	16	0	11	Q4	2012	6.9900	2.4465	3.0000	1
21	2553	16	0	6	Q2	2012	9.3200	3.1688	4.0000	1
21	2556	3	210	12	Q4	2012	6.9900	3.0756	3.0000	1
21	2740	11	0	1	Q1	2012	6.9900	2.3067	3.0000	1
21	2896	3	0	9	Q3	2012	6.9900	3.2853	3.0000	1
21	2993	24	0	3	Q1	2012	9.3200	2.8892	4.0000	1
21	3004	7	0	7	Q3	2012	6.9900	2.3067	3.0000	1
21	3012	24	0	2	Q1	2012	9.3200	3.3552	4.0000	1
21	3288	3	0	11	Q4	2012	6.9900	2.1669	3.0000	1
21	3693	3	0	11	Q4	2012	4.6600	1.5378	2.0000	1
21	3923	15	0	3	Q1	2012	4.6600	1.6310	2.0000	1
21	3925	11	0	3	Q1	2012	9.3200	4.1008	4.0000	1
21	4228	15	0	8	Q3	2012	6.9900	3.4251	3.0000	1
21	4234	3	0	3	Q1	2012	6.9900	3.0756	3.0000	1
21	4241	14	0	5	Q2	2012	2.3300	1.1417	1.0000	1
21	4693	3	0	8	Q3	2012	9.3200	4.2872	4.0000	1
21	4727	16	0	7	Q3	2012	9.3200	3.5416	4.0000	1
21	4928	13	980	3	Q1	2012	6.9900	2.9358	3.0000	1
21	5013	7	504	2	Q1	2012	6.9900	3.4251	3.0000	1
21	5047	11	829	6	Q2	2012	6.9900	2.4465	3.0000	1
21	5158	3	0	3	Q1	2012	6.9900	2.4465	3.0000	1
21	5355	15	0	2	Q1	2012	9.3200	4.1940	4.0000	1
21	5419	17	0	9	Q3	2012	4.6600	1.5844	2.0000	1
21	5419	17	1312	10	Q4	2012	6.9900	2.7261	3.0000	1
21	5501	17	1292	1	Q1	2012	9.3200	3.6348	4.0000	1
21	5616	17	0	4	Q2	2012	4.6600	1.5844	2.0000	1
21	5626	6	526	12	Q4	2012	6.9900	3.2154	3.0000	1
21	5745	15	0	3	Q1	2012	9.3200	4.3804	4.0000	1
21	5869	13	0	8	Q3	2012	4.6600	2.2834	2.0000	1
21	5899	13	0	7	Q3	2012	6.9900	2.4465	3.0000	1
21	6069	13	0	2	Q1	2012	4.6600	1.8640	2.0000	1
21	6146	15	0	7	Q3	2012	4.6600	1.9572	2.0000	1
21	7052	23	0	12	Q4	2012	6.9900	3.0756	3.0000	1
21	7072	16	0	11	Q4	2012	4.6600	1.5844	2.0000	1
21	7501	24	1866	11	Q4	2012	6.9900	2.3766	3.0000	1
21	7913	17	0	4	Q2	2012	6.9900	2.0970	3.0000	1
21	8071	15	0	1	Q1	2012	9.3200	2.8892	4.0000	1
21	8296	6	515	7	Q3	2012	6.9900	2.9358	3.0000	1
21	8511	16	1235	11	Q4	2012	6.9900	2.4465	3.0000	1
21	8749	13	0	5	Q2	2012	9.3200	2.9824	4.0000	1
21	8936	2	0	10	Q4	2012	2.3300	1.0951	1.0000	1
21	9095	6	0	5	Q2	2012	6.9900	2.4465	3.0000	1
21	9101	7	0	12	Q4	2012	4.6600	2.3300	2.0000	1
21	9497	15	0	5	Q2	2012	4.6600	2.0504	2.0000	1
21	10186	13	0	12	Q4	2012	9.3200	4.1008	4.0000	1
22	311	6	506	3	Q1	2012	6.8700	2.8854	3.0000	1
22	454	17	0	8	Q3	2012	6.8700	3.2976	3.0000	1
22	636	17	1303	6	Q2	2012	4.5800	1.5114	2.0000	1
22	863	17	0	6	Q2	2012	6.8700	2.5419	3.0000	1
22	1057	2	114	4	Q2	2012	4.5800	1.8778	2.0000	1
22	1210	6	0	12	Q4	2012	4.5800	1.4656	2.0000	1
22	1214	11	0	3	Q1	2012	4.5800	1.8778	2.0000	1
22	1582	11	0	10	Q4	2012	4.5800	2.0610	2.0000	1
22	1599	7	0	1	Q1	2012	4.5800	1.7862	2.0000	1
22	2077	23	0	1	Q1	2012	4.5800	1.5114	2.0000	1
22	2129	7	518	8	Q3	2012	9.1600	4.1220	4.0000	1
22	2246	13	980	3	Q1	2012	9.1600	4.3968	4.0000	1
22	2295	17	1303	6	Q2	2012	4.5800	2.2442	2.0000	1
22	2472	7	504	2	Q1	2012	6.8700	2.4045	3.0000	1
22	2609	7	0	1	Q1	2012	6.8700	3.3663	3.0000	1
22	2820	7	0	11	Q4	2012	6.8700	2.9541	3.0000	1
22	2888	24	1866	11	Q4	2012	6.8700	2.2671	3.0000	1
22	2905	3	0	2	Q1	2012	6.8700	3.3663	3.0000	1
22	3104	11	0	9	Q3	2012	6.8700	3.0228	3.0000	1
22	3160	17	1314	11	Q4	2012	4.5800	1.7404	2.0000	1
22	3251	6	526	12	Q4	2012	6.8700	3.0915	3.0000	1
22	3351	22	1706	10	Q4	2012	2.2900	0.7786	1.0000	1
22	3826	16	1216	2	Q1	2012	6.8700	2.1984	3.0000	1
22	3994	15	0	1	Q1	2012	4.5800	1.6946	2.0000	1
22	4045	15	1157	12	Q4	2012	9.1600	4.3052	4.0000	1
22	4527	3	210	12	Q4	2012	6.8700	2.8167	3.0000	1
22	4597	17	0	9	Q3	2012	6.8700	2.8854	3.0000	1
22	4775	17	0	9	Q3	2012	9.1600	3.6640	4.0000	1
22	4874	24	1866	11	Q4	2012	6.8700	2.8167	3.0000	1
22	5342	15	0	12	Q4	2012	9.1600	3.7556	4.0000	1
22	5392	14	1079	12	Q4	2012	2.2900	0.7099	1.0000	1
22	5419	17	0	11	Q4	2012	9.1600	4.0304	4.0000	1
22	5671	7	0	12	Q4	2012	11.4500	5.0380	5.0000	1
22	5686	3	0	12	Q4	2012	4.5800	1.9236	2.0000	1
22	5782	13	0	12	Q4	2012	6.8700	2.8167	3.0000	1
22	5827	11	826	5	Q2	2012	9.1600	3.3892	4.0000	1
22	6038	7	0	11	Q4	2012	11.4500	5.3815	5.0000	1
22	6799	17	1314	11	Q4	2012	11.4500	4.0075	5.0000	1
22	6953	2	0	11	Q4	2012	4.5800	1.6946	2.0000	1
22	7149	13	0	9	Q3	2012	9.1600	3.6640	4.0000	1
22	7206	7	504	2	Q1	2012	6.8700	3.2289	3.0000	1
22	7293	22	0	2	Q1	2012	2.2900	0.8244	1.0000	1
22	7421	6	0	2	Q1	2012	9.1600	3.0228	4.0000	1
22	7525	2	108	1	Q1	2012	6.8700	3.0915	3.0000	1
22	7731	6	0	5	Q2	2012	9.1600	4.3968	4.0000	1
22	8647	3	0	5	Q2	2012	4.5800	1.6946	2.0000	1
22	8794	17	0	8	Q3	2012	9.1600	4.3968	4.0000	1
22	9033	7	0	6	Q2	2012	9.1600	3.3892	4.0000	1
22	9929	13	0	11	Q4	2012	9.1600	3.2976	4.0000	1
22	10102	7	0	4	Q2	2012	6.8700	3.2289	3.0000	1
23	387	22	0	8	Q3	2012	3.5000	1.4350	2.0000	1
23	878	3	0	6	Q2	2012	5.2500	1.8375	3.0000	1
23	1345	17	0	3	Q1	2012	5.2500	2.6250	3.0000	1
23	1481	15	0	7	Q3	2012	5.2500	2.3625	3.0000	1
23	1839	11	829	6	Q2	2012	7.0000	2.2400	4.0000	1
23	1897	13	0	12	Q4	2012	3.5000	1.4000	2.0000	1
23	2143	17	0	10	Q4	2012	3.5000	1.5400	2.0000	1
23	2171	23	0	4	Q2	2012	3.5000	1.1900	2.0000	1
23	2177	15	0	12	Q4	2012	7.0000	3.3600	4.0000	1
23	2441	17	0	3	Q1	2012	5.2500	1.8375	3.0000	1
23	2444	13	0	7	Q3	2012	3.5000	1.4700	2.0000	1
23	2636	17	0	5	Q2	2012	8.7500	4.2875	5.0000	1
23	2636	17	1307	8	Q3	2012	5.2500	2.5725	3.0000	1
23	2639	15	0	10	Q4	2012	3.5000	1.4000	2.0000	1
23	2788	7	0	7	Q3	2012	7.0000	3.0100	4.0000	1
23	2918	17	0	10	Q4	2012	3.5000	1.4700	2.0000	1
23	3428	24	0	1	Q1	2012	7.0000	3.1500	4.0000	1
23	3815	2	0	9	Q3	2012	1.7500	0.8575	1.0000	1
23	3932	15	1138	3	Q1	2012	5.2500	1.6800	3.0000	1
23	3980	13	0	5	Q2	2012	5.2500	1.8375	3.0000	1
23	4094	16	1235	11	Q4	2012	8.7500	4.2000	5.0000	1
23	4165	3	0	12	Q4	2012	3.5000	1.4700	2.0000	1
23	4417	3	0	8	Q3	2012	5.2500	1.5750	3.0000	1
23	4767	16	1220	4	Q2	2012	7.0000	2.9400	4.0000	1
23	5587	7	0	12	Q4	2012	5.2500	2.2050	3.0000	1
23	6182	13	0	3	Q1	2012	5.2500	2.4150	3.0000	1
23	6348	16	1220	4	Q2	2012	3.5000	1.2600	2.0000	1
23	6611	7	0	4	Q2	2012	5.2500	1.8900	3.0000	1
23	6760	17	0	1	Q1	2012	7.0000	2.3800	4.0000	1
23	6766	24	0	11	Q4	2012	5.2500	2.5200	3.0000	1
23	6866	17	0	3	Q1	2012	5.2500	2.4150	3.0000	1
23	7018	7	0	11	Q4	2012	7.0000	2.3800	4.0000	1
23	7052	23	0	5	Q2	2012	5.2500	1.7325	3.0000	1
23	7319	13	0	1	Q1	2012	7.0000	3.2200	4.0000	1
23	7655	17	1303	6	Q2	2012	5.2500	1.5750	3.0000	1
23	7672	7	0	12	Q4	2012	3.5000	1.4700	2.0000	1
23	7851	7	0	7	Q3	2012	8.7500	3.3250	5.0000	1
23	8017	7	523	11	Q4	2012	5.2500	1.6275	3.0000	1
23	8089	17	0	8	Q3	2012	5.2500	1.7850	3.0000	1
23	8242	17	0	10	Q4	2012	5.2500	1.8375	3.0000	1
23	8340	6	504	2	Q1	2012	5.2500	1.6275	3.0000	1
23	8463	23	0	5	Q2	2012	10.5000	4.1475	6.0000	2
23	9027	6	522	10	Q4	2012	5.2500	2.0475	3.0000	1
23	9787	13	0	8	Q3	2012	5.2500	2.3100	3.0000	1
23	9977	11	0	3	Q1	2012	5.2500	1.8375	3.0000	1
23	10080	6	0	5	Q2	2012	7.0000	2.5900	4.0000	1
23	10104	6	0	3	Q1	2012	5.2500	2.4150	3.0000	1
24	41	11	0	3	Q1	2012	6.9200	3.3216	4.0000	1
24	115	6	0	12	Q4	2012	5.1900	1.5570	3.0000	1
24	276	15	0	3	Q1	2012	5.1900	2.2836	3.0000	1
24	378	16	0	5	Q2	2012	5.1900	2.1798	3.0000	1
24	420	22	0	12	Q4	2012	1.7300	0.5536	1.0000	1
24	565	15	1157	12	Q4	2012	6.9200	3.3908	4.0000	1
24	666	24	0	1	Q1	2012	5.1900	1.7646	3.0000	1
24	754	3	202	8	Q3	2012	5.1900	2.4393	3.0000	1
24	897	6	526	12	Q4	2012	5.1900	1.5570	3.0000	1
24	1175	7	0	11	Q4	2012	5.1900	2.2836	3.0000	1
24	1281	3	188	2	Q1	2012	3.4600	1.7300	2.0000	1
24	1360	13	0	8	Q3	2012	6.9200	3.1832	4.0000	1
24	1391	6	519	9	Q3	2012	5.1900	2.5950	3.0000	1
24	1432	11	0	12	Q4	2012	3.4600	1.4532	2.0000	1
24	1821	13	0	4	Q2	2012	3.4600	1.2110	2.0000	1
24	2143	17	0	1	Q1	2012	3.4600	1.4878	2.0000	1
24	2550	24	0	2	Q1	2012	5.1900	1.9203	3.0000	1
24	2588	23	0	6	Q2	2012	6.9200	2.0760	4.0000	1
24	2698	15	0	1	Q1	2012	5.1900	1.8684	3.0000	1
24	2700	24	0	4	Q2	2012	6.9200	3.1140	4.0000	1
24	2878	3	185	1	Q1	2012	5.1900	2.3355	3.0000	1
24	2987	15	0	7	Q3	2012	5.1900	1.8165	3.0000	1
24	3231	17	0	2	Q1	2012	5.1900	2.2317	3.0000	1
24	3435	11	0	12	Q4	2012	5.1900	2.5431	3.0000	1
24	3639	24	0	5	Q2	2012	3.4600	1.4186	2.0000	1
24	3700	15	1142	5	Q2	2012	5.1900	2.3874	3.0000	1
24	4017	15	1140	4	Q2	2012	3.4600	1.2110	2.0000	1
24	4021	16	1214	2	Q1	2012	5.1900	2.5431	3.0000	1
24	4069	17	0	2	Q1	2012	3.4600	1.3148	2.0000	1
24	4108	11	818	1	Q1	2012	5.1900	1.8165	3.0000	1
24	4340	17	0	11	Q4	2012	6.9200	3.2524	4.0000	1
24	4727	16	0	7	Q3	2012	6.9200	2.6296	4.0000	1
24	4858	17	0	8	Q3	2012	6.9200	3.3908	4.0000	1
24	4902	6	508	4	Q2	2012	6.9200	2.3528	4.0000	1
24	5313	24	0	3	Q1	2012	5.1900	2.0760	3.0000	1
24	5438	24	0	8	Q3	2012	5.1900	1.7127	3.0000	1
24	5924	13	0	7	Q3	2012	5.1900	2.5950	3.0000	1
24	6426	24	1869	12	Q4	2012	5.1900	1.9203	3.0000	1
24	6571	24	1856	6	Q2	2012	5.1900	2.3355	3.0000	1
24	6930	24	1858	7	Q3	2012	5.1900	2.1279	3.0000	1
24	6970	6	502	1	Q1	2012	5.1900	2.2836	3.0000	1
24	6997	13	0	7	Q3	2012	5.1900	1.8684	3.0000	1
24	7002	24	1866	11	Q4	2012	5.1900	2.4393	3.0000	1
24	7642	7	0	11	Q4	2012	3.4600	1.2110	2.0000	1
24	7702	16	0	3	Q1	2012	5.1900	2.4393	3.0000	1
24	8023	15	0	3	Q1	2012	3.4600	1.2110	2.0000	1
24	8068	3	0	12	Q4	2012	3.4600	1.0726	2.0000	1
24	8164	13	0	2	Q1	2012	3.4600	1.5570	2.0000	1
24	8594	7	504	2	Q1	2012	5.1900	2.4912	3.0000	1
24	8731	3	0	9	Q3	2012	3.4600	1.6262	2.0000	1
24	9467	11	841	12	Q4	2012	8.6500	4.0655	5.0000	1
24	9524	3	0	1	Q1	2012	8.6500	2.6815	5.0000	1
24	9615	15	0	2	Q1	2012	5.1900	1.6608	3.0000	1
24	9815	16	0	7	Q3	2012	6.9200	2.2836	4.0000	1
24	9951	3	0	3	Q1	2012	5.1900	2.0241	3.0000	1
24	10116	17	0	5	Q2	2012	5.1900	2.4912	3.0000	1
24	10264	15	0	5	Q2	2012	5.1900	2.2836	3.0000	1
24	10265	7	0	1	Q1	2012	6.9200	3.2524	4.0000	1
25	190	13	0	3	Q1	2012	6.2000	3.1000	4.0000	1
25	446	13	0	7	Q3	2012	6.2000	2.2940	4.0000	1
25	893	13	980	3	Q1	2012	4.6500	1.8600	3.0000	1
25	1042	11	0	7	Q3	2012	3.1000	0.9610	2.0000	1
25	1692	24	0	9	Q3	2012	3.1000	1.3020	2.0000	1
25	1720	16	0	11	Q4	2012	6.2000	1.9840	4.0000	1
25	1979	3	0	10	Q4	2012	4.6500	2.1390	3.0000	1
25	2448	16	1235	11	Q4	2012	4.6500	2.2320	3.0000	1
25	2553	16	0	1	Q1	2012	7.7500	3.7975	5.0000	1
25	2662	11	824	4	Q2	2012	4.6500	1.5810	3.0000	1
25	2664	17	0	10	Q4	2012	4.6500	1.7670	3.0000	1
25	2674	11	0	8	Q3	2012	4.6500	2.1855	3.0000	1
25	2688	6	0	1	Q1	2012	4.6500	1.6275	3.0000	1
25	3321	24	1850	3	Q1	2012	6.2000	2.2320	4.0000	1
25	3838	17	0	7	Q3	2012	4.6500	1.9065	3.0000	1
25	3942	15	1138	3	Q1	2012	7.7500	2.4800	5.0000	1
25	4094	16	0	10	Q4	2012	4.6500	1.8135	3.0000	1
25	4094	16	0	12	Q4	2012	3.1000	1.0540	2.0000	1
25	4140	15	0	4	Q2	2012	4.6500	1.9065	3.0000	1
25	4396	13	0	11	Q4	2012	3.1000	1.1470	2.0000	1
25	4552	17	1314	11	Q4	2012	4.6500	2.1390	3.0000	1
25	4649	17	0	9	Q3	2012	6.2000	2.8520	4.0000	1
25	4719	23	1783	9	Q3	2012	6.2000	1.9840	4.0000	1
25	5047	11	829	6	Q2	2012	3.1000	1.1470	2.0000	1
25	5210	17	0	7	Q3	2012	4.6500	2.1390	3.0000	1
25	5361	24	1869	12	Q4	2012	3.1000	1.0230	2.0000	1
25	5410	17	0	4	Q2	2012	3.1000	1.3640	2.0000	1
25	5533	13	0	8	Q3	2012	4.6500	1.7205	3.0000	1
25	5644	17	0	4	Q2	2012	3.1000	1.0540	2.0000	1
25	5799	15	0	11	Q4	2012	4.6500	2.0460	3.0000	1
25	5894	11	829	6	Q2	2012	6.2000	2.2320	4.0000	1
25	5943	2	0	11	Q4	2012	1.5500	0.6975	1.0000	1
25	6112	11	829	6	Q2	2012	6.2000	2.2320	4.0000	1
25	6138	17	0	8	Q3	2012	3.1000	1.4880	2.0000	1
25	6154	15	0	9	Q3	2012	4.6500	1.9995	3.0000	1
25	6301	15	0	1	Q1	2012	3.1000	1.1780	2.0000	1
25	6510	13	0	1	Q1	2012	4.6500	2.1390	3.0000	1
25	6551	11	0	2	Q1	2012	4.6500	1.8600	3.0000	1
25	6568	14	0	2	Q1	2012	3.1000	1.1470	2.0000	1
25	6712	16	0	3	Q1	2012	6.2000	2.7900	4.0000	1
25	7262	13	0	2	Q1	2012	4.6500	2.0460	3.0000	1
25	7281	17	0	11	Q4	2012	6.2000	3.0380	4.0000	1
25	7361	11	841	12	Q4	2012	4.6500	1.8135	3.0000	1
25	7419	14	1066	6	Q2	2012	3.1000	1.5190	2.0000	1
25	7510	15	0	5	Q2	2012	4.6500	2.1855	3.0000	1
25	7534	13	0	3	Q1	2012	6.2000	3.0380	4.0000	1
25	7572	15	0	11	Q4	2012	4.6500	1.3950	3.0000	1
25	7720	17	0	4	Q2	2012	3.1000	1.2710	2.0000	1
25	7979	24	0	4	Q2	2012	4.6500	1.9065	3.0000	1
25	7989	17	0	1	Q1	2012	4.6500	1.6740	3.0000	1
25	7997	13	984	5	Q2	2012	6.2000	2.9760	4.0000	1
25	8084	22	0	1	Q1	2012	1.5500	0.6355	1.0000	1
25	8113	24	0	10	Q4	2012	6.2000	1.8600	4.0000	1
25	8196	24	0	7	Q3	2012	3.1000	1.4880	2.0000	1
25	8509	24	0	8	Q3	2012	4.6500	1.5810	3.0000	1
25	8600	6	0	10	Q4	2012	6.2000	3.0380	4.0000	1
25	8994	17	0	10	Q4	2012	6.2000	2.0460	4.0000	1
25	9233	24	1866	11	Q4	2012	4.6500	1.4415	3.0000	1
25	9318	16	1225	7	Q3	2012	6.2000	2.9140	4.0000	1
25	9898	15	0	5	Q2	2012	4.6500	2.3250	3.0000	1
26	20	24	1856	6	Q2	2012	3.5200	1.5840	4.0000	1
26	426	15	0	3	Q1	2012	1.7600	0.8448	2.0000	1
26	454	17	0	2	Q1	2012	2.6400	1.2672	3.0000	1
26	467	13	0	2	Q1	2012	2.6400	1.2408	3.0000	1
26	805	7	0	3	Q1	2012	1.7600	0.7568	2.0000	1
26	1214	11	0	1	Q1	2012	2.6400	1.1352	3.0000	1
26	1263	13	0	2	Q1	2012	3.5200	1.7600	4.0000	1
26	1338	24	1869	12	Q4	2012	2.6400	1.2936	3.0000	1
26	1491	16	0	12	Q4	2012	2.6400	1.3200	3.0000	1
26	1615	17	0	12	Q4	2012	2.6400	1.1352	3.0000	1
26	1680	6	0	8	Q3	2012	2.6400	0.8184	3.0000	1
26	1818	11	826	5	Q2	2012	2.6400	0.9768	3.0000	1
26	1915	11	0	1	Q1	2012	1.7600	0.7216	2.0000	1
26	2210	13	0	8	Q3	2012	3.5200	1.5488	4.0000	1
26	2231	7	0	3	Q1	2012	1.7600	0.6160	2.0000	1
26	2335	17	0	11	Q4	2012	2.6400	0.9504	3.0000	1
26	2441	17	1297	3	Q1	2012	2.6400	0.8184	3.0000	1
26	2472	7	504	2	Q1	2012	1.7600	0.6688	2.0000	1
26	2521	7	505	2	Q1	2012	2.6400	0.9768	3.0000	1
26	2674	11	0	1	Q1	2012	2.6400	0.9504	3.0000	1
26	2687	24	0	9	Q3	2012	3.5200	1.4080	4.0000	1
26	3000	17	0	11	Q4	2012	2.6400	0.9504	3.0000	1
26	3115	6	0	11	Q4	2012	2.6400	0.8976	3.0000	1
26	3197	23	0	9	Q3	2012	3.5200	1.5136	4.0000	1
26	3397	17	0	3	Q1	2012	2.6400	1.2936	3.0000	1
26	3801	11	833	8	Q3	2012	2.6400	1.1616	3.0000	1
26	3928	23	1788	11	Q4	2012	2.6400	1.1616	3.0000	1
26	3979	13	980	3	Q1	2012	1.7600	0.5632	2.0000	1
26	4282	15	0	2	Q1	2012	2.6400	1.0032	3.0000	1
26	4687	24	0	10	Q4	2012	2.6400	0.9768	3.0000	1
26	4849	15	1140	4	Q2	2012	1.7600	0.7568	2.0000	1
26	5174	16	1216	2	Q1	2012	2.6400	0.8712	3.0000	1
26	5255	24	0	10	Q4	2012	2.6400	0.8976	3.0000	1
26	5303	17	1312	10	Q4	2012	2.6400	0.8712	3.0000	1
26	5328	2	0	4	Q2	2012	1.7600	0.5632	2.0000	1
26	5682	11	0	10	Q4	2012	2.6400	1.2408	3.0000	1
26	6180	13	0	1	Q1	2012	2.6400	0.9240	3.0000	1
26	6295	24	1859	8	Q3	2012	2.6400	1.2408	3.0000	1
26	6560	17	0	9	Q3	2012	1.7600	0.5808	2.0000	1
26	6836	7	0	3	Q1	2012	3.5200	1.7248	4.0000	1
26	6842	24	1851	4	Q2	2012	2.6400	1.2672	3.0000	1
26	7072	16	1216	2	Q1	2012	1.7600	0.5984	2.0000	1
26	7281	17	1304	7	Q3	2012	2.6400	0.9240	3.0000	1
26	7413	3	188	2	Q1	2012	1.7600	0.7568	2.0000	1
26	7553	24	0	11	Q4	2012	3.5200	1.7248	4.0000	1
26	7556	17	0	8	Q3	2012	2.6400	1.2936	3.0000	1
26	7704	3	0	2	Q1	2012	2.6400	1.0824	3.0000	1
26	8089	17	0	3	Q1	2012	2.6400	0.8712	3.0000	1
26	8092	15	1140	4	Q2	2012	1.7600	0.6688	2.0000	1
26	8108	17	0	10	Q4	2012	1.7600	0.5456	2.0000	1
26	8281	17	0	4	Q2	2012	2.6400	0.9240	3.0000	1
26	8546	7	0	10	Q4	2012	3.5200	1.0912	4.0000	1
26	9014	13	0	2	Q1	2012	1.7600	0.6512	2.0000	1
26	9603	6	521	10	Q4	2012	2.6400	1.0296	3.0000	1
26	10126	6	0	12	Q4	2012	1.7600	0.7040	2.0000	1
27	467	13	0	7	Q3	2012	7.9500	2.7825	3.0000	1
27	543	13	984	5	Q2	2012	7.9500	2.9415	3.0000	1
27	1091	7	0	9	Q3	2012	7.9500	3.2595	3.0000	1
27	1214	11	0	11	Q4	2012	7.9500	3.4980	3.0000	1
27	1309	24	1860	8	Q3	2012	7.9500	3.8160	3.0000	1
27	1366	13	0	12	Q4	2012	10.6000	4.7700	4.0000	1
27	1388	13	0	6	Q2	2012	7.9500	3.4185	3.0000	1
27	1451	3	202	8	Q3	2012	5.3000	1.6430	2.0000	1
27	1490	13	980	3	Q1	2012	7.9500	3.4185	3.0000	1
27	1758	3	0	4	Q2	2012	10.6000	3.4980	4.0000	1
27	1785	3	0	7	Q3	2012	7.9500	3.6570	3.0000	1
27	1822	7	0	7	Q3	2012	7.9500	2.4645	3.0000	1
27	1850	16	0	12	Q4	2012	7.9500	2.9415	3.0000	1
27	2059	17	0	4	Q2	2012	10.6000	5.1940	4.0000	1
27	2228	15	0	11	Q4	2012	7.9500	2.4645	3.0000	1
27	2361	24	0	8	Q3	2012	10.6000	5.0880	4.0000	1
27	2779	6	0	10	Q4	2012	10.6000	5.1940	4.0000	1
27	3799	13	976	1	Q1	2012	7.9500	3.1800	3.0000	1
27	3979	13	0	7	Q3	2012	5.3000	1.6960	2.0000	1
27	4065	3	0	7	Q3	2012	5.3000	2.0670	2.0000	1
27	4490	13	0	12	Q4	2012	10.6000	4.0280	4.0000	1
27	4527	3	0	12	Q4	2012	7.9500	3.2595	3.0000	1
27	4535	15	0	10	Q4	2012	5.3000	2.1200	2.0000	1
27	5068	22	0	9	Q3	2012	7.9500	2.3850	3.0000	1
27	5143	17	0	12	Q4	2012	7.9500	3.4185	3.0000	1
27	5192	7	514	7	Q3	2012	7.9500	2.7825	3.0000	1
27	5288	13	0	1	Q1	2012	7.9500	3.7365	3.0000	1
27	5541	7	523	11	Q4	2012	7.9500	2.3850	3.0000	1
27	5592	16	0	10	Q4	2012	7.9500	3.0210	3.0000	1
27	5714	6	0	10	Q4	2012	7.9500	2.6235	3.0000	1
27	5766	16	0	5	Q2	2012	7.9500	2.8620	3.0000	1
27	5896	6	0	2	Q1	2012	7.9500	3.5775	3.0000	1
27	5944	3	0	2	Q1	2012	5.3000	2.4380	2.0000	1
27	6113	16	0	5	Q2	2012	7.9500	3.1005	3.0000	1
27	6168	17	0	7	Q3	2012	13.2500	5.3000	5.0000	1
27	6254	7	0	3	Q1	2012	10.6000	4.4520	4.0000	1
27	6460	24	1845	1	Q1	2012	7.9500	2.9415	3.0000	1
27	6469	6	0	11	Q4	2012	10.6000	3.6040	4.0000	1
27	6681	17	0	3	Q1	2012	5.3000	2.2260	2.0000	1
27	6760	17	0	12	Q4	2012	10.6000	3.6040	4.0000	1
27	7035	6	0	8	Q3	2012	10.6000	4.0280	4.0000	1
27	7293	22	0	3	Q1	2012	2.6500	0.9540	1.0000	1
27	7474	7	526	12	Q4	2012	7.9500	3.5775	3.0000	1
27	7534	13	0	7	Q3	2012	10.6000	5.1940	4.0000	1
27	7920	17	0	1	Q1	2012	10.6000	5.0880	4.0000	1
27	8146	11	0	1	Q1	2012	10.6000	4.3460	4.0000	1
27	8342	24	0	1	Q1	2012	7.9500	3.7365	3.0000	1
27	8511	16	0	7	Q3	2012	5.3000	2.2260	2.0000	1
27	8747	7	0	10	Q4	2012	7.9500	3.8160	3.0000	1
27	9144	13	0	6	Q2	2012	7.9500	2.5440	3.0000	1
27	9366	17	0	6	Q2	2012	5.3000	2.2790	2.0000	1
27	9396	13	0	5	Q2	2012	7.9500	3.8160	3.0000	1
27	9499	7	0	12	Q4	2012	5.3000	2.5970	2.0000	1
27	9505	15	0	3	Q1	2012	10.6000	3.6040	4.0000	1
27	9594	6	0	12	Q4	2012	7.9500	2.7825	3.0000	1
27	9631	16	0	12	Q4	2012	7.9500	3.8160	3.0000	1
27	9851	3	207	11	Q4	2012	10.6000	4.0280	4.0000	1
28	260	11	0	10	Q4	2012	19.5500	9.3840	5.0000	1
28	467	13	0	5	Q2	2012	11.7300	4.1055	3.0000	1
28	505	7	523	11	Q4	2012	11.7300	5.2785	3.0000	1
28	653	6	0	11	Q4	2012	15.6400	5.6304	4.0000	1
28	905	3	205	10	Q4	2012	15.6400	7.3508	4.0000	1
28	1033	24	0	5	Q2	2012	15.6400	6.5688	4.0000	1
28	1468	13	0	7	Q3	2012	7.8200	2.7370	2.0000	1
28	1632	7	501	1	Q1	2012	11.7300	5.6304	3.0000	1
28	1862	17	0	7	Q3	2012	7.8200	2.8152	2.0000	1
28	1979	3	0	8	Q3	2012	11.7300	4.1055	3.0000	1
28	2105	24	0	10	Q4	2012	11.7300	5.7477	3.0000	1
28	2195	7	0	4	Q2	2012	15.6400	7.1944	4.0000	1
28	2397	11	0	9	Q3	2012	7.8200	3.3626	2.0000	1
28	2422	13	0	9	Q3	2012	15.6400	5.3176	4.0000	1
28	2547	23	1776	6	Q2	2012	7.8200	2.3460	2.0000	1
28	2674	11	0	9	Q3	2012	11.7300	3.7536	3.0000	1
28	2869	6	0	10	Q4	2012	11.7300	5.7477	3.0000	1
28	2878	3	0	4	Q2	2012	15.6400	7.5072	4.0000	1
28	2907	15	1140	4	Q2	2012	11.7300	3.6363	3.0000	1
28	2942	17	0	11	Q4	2012	11.7300	5.5131	3.0000	1
28	3130	13	0	3	Q1	2012	11.7300	3.9882	3.0000	1
28	3395	11	0	2	Q1	2012	15.6400	6.5688	4.0000	1
28	3993	24	0	2	Q1	2012	7.8200	2.8934	2.0000	1
28	4021	16	0	5	Q2	2012	7.8200	3.6754	2.0000	1
28	4297	6	0	11	Q4	2012	11.7300	4.1055	3.0000	1
28	4324	15	0	3	Q1	2012	11.7300	3.7536	3.0000	1
28	4434	15	0	9	Q3	2012	7.8200	3.0498	2.0000	1
28	4600	2	0	2	Q1	2012	3.9100	1.3685	1.0000	1
28	4657	17	0	2	Q1	2012	15.6400	7.1944	4.0000	1
28	4743	7	504	2	Q1	2012	7.8200	3.6754	2.0000	1
28	4875	13	980	3	Q1	2012	7.8200	2.5806	2.0000	1
28	5237	2	0	12	Q4	2012	3.9100	1.4858	1.0000	1
28	5302	11	0	7	Q3	2012	7.8200	2.8934	2.0000	1
28	5354	15	0	11	Q4	2012	15.6400	5.1612	4.0000	1
28	5376	3	190	3	Q1	2012	11.7300	4.3401	3.0000	1
28	5821	15	0	5	Q2	2012	19.5500	7.8200	5.0000	1
28	5947	7	518	8	Q3	2012	15.6400	4.8484	4.0000	1
28	5948	6	0	5	Q2	2012	11.7300	3.6363	3.0000	1
28	6070	15	0	9	Q3	2012	15.6400	4.8484	4.0000	1
28	6576	7	0	10	Q4	2012	11.7300	5.7477	3.0000	1
28	6628	6	508	4	Q2	2012	11.7300	3.8709	3.0000	1
28	6799	17	0	8	Q3	2012	15.6400	5.3176	4.0000	1
28	6888	23	0	9	Q3	2012	11.7300	5.0439	3.0000	1
28	7051	16	0	5	Q2	2012	15.6400	7.6636	4.0000	1
28	7051	16	0	6	Q2	2012	11.7300	5.7477	3.0000	1
28	7325	15	0	4	Q2	2012	15.6400	7.1944	4.0000	1
28	7655	17	1297	3	Q1	2012	15.6400	7.0380	4.0000	1
28	8414	17	0	4	Q2	2012	7.8200	2.7370	2.0000	1
28	8818	15	0	1	Q1	2012	7.8200	3.2844	2.0000	1
28	9270	11	833	8	Q3	2012	15.6400	5.3176	4.0000	1
28	9404	7	0	10	Q4	2012	7.8200	3.2062	2.0000	1
28	9498	23	0	7	Q3	2012	7.8200	2.8152	2.0000	1
28	9814	6	0	2	Q1	2012	15.6400	7.5072	4.0000	1
28	9814	6	0	7	Q3	2012	11.7300	5.5131	3.0000	1
28	9814	6	0	9	Q3	2012	11.7300	4.1055	3.0000	1
28	9825	13	0	4	Q2	2012	7.8200	2.3460	2.0000	1
28	9967	23	0	2	Q1	2012	19.5500	8.9930	5.0000	1
29	188	13	0	2	Q1	2012	3.5600	1.4240	2.0000	1
29	274	13	0	11	Q4	2012	5.3400	1.9224	3.0000	1
29	454	17	0	6	Q2	2012	3.5600	1.1392	2.0000	1
29	511	16	0	12	Q4	2012	5.3400	1.9224	3.0000	1
29	739	23	0	12	Q4	2012	5.3400	1.9758	3.0000	1
29	806	17	1294	2	Q1	2012	3.5600	1.4952	2.0000	1
29	905	3	199	7	Q3	2012	7.1200	2.5632	4.0000	1
29	1005	3	0	1	Q1	2012	3.5600	1.5308	2.0000	1
29	1280	6	0	6	Q2	2012	3.5600	1.4952	2.0000	1
29	1334	17	0	4	Q2	2012	5.3400	1.8156	3.0000	1
29	1491	16	0	9	Q3	2012	5.3400	1.8690	3.0000	1
29	2201	16	0	7	Q3	2012	3.5600	1.1748	2.0000	1
29	2378	16	0	2	Q1	2012	7.1200	2.9904	4.0000	1
29	2533	7	0	5	Q2	2012	3.5600	1.1748	2.0000	1
29	2533	7	0	8	Q3	2012	7.1200	3.0616	4.0000	1
29	2548	13	0	7	Q3	2012	5.3400	2.5098	3.0000	1
29	2570	16	0	3	Q1	2012	3.5600	1.4240	2.0000	1
29	2715	15	0	7	Q3	2012	5.3400	1.6020	3.0000	1
29	2815	22	0	7	Q3	2012	3.5600	1.2460	2.0000	1
29	2823	24	1850	3	Q1	2012	5.3400	1.9758	3.0000	1
29	3069	15	1141	4	Q2	2012	7.1200	3.2040	4.0000	1
29	3163	7	0	3	Q1	2012	3.5600	1.4596	2.0000	1
29	3253	13	976	1	Q1	2012	3.5600	1.5308	2.0000	1
29	3627	3	0	10	Q4	2012	7.1200	3.2040	4.0000	1
29	3826	16	0	11	Q4	2012	7.1200	3.2752	4.0000	1
29	4066	3	0	4	Q2	2012	7.1200	2.4920	4.0000	1
29	4165	3	0	9	Q3	2012	5.3400	1.8156	3.0000	1
29	4211	11	842	12	Q4	2012	8.9000	2.8480	5.0000	1
29	4394	2	124	9	Q3	2012	3.5600	1.5308	2.0000	1
29	4461	11	821	2	Q1	2012	5.3400	2.0826	3.0000	1
29	4552	17	1314	11	Q4	2012	5.3400	2.4564	3.0000	1
29	4609	23	0	3	Q1	2012	7.1200	3.1328	4.0000	1
29	4829	11	0	6	Q2	2012	7.1200	2.2072	4.0000	1
29	4846	17	0	6	Q2	2012	7.1200	2.8480	4.0000	1
29	5088	13	0	8	Q3	2012	7.1200	3.1328	4.0000	1
29	5188	2	112	3	Q1	2012	5.3400	1.6554	3.0000	1
29	5210	17	0	2	Q1	2012	5.3400	2.4564	3.0000	1
29	5374	16	0	4	Q2	2012	5.3400	1.6554	3.0000	1
29	5579	15	0	11	Q4	2012	5.3400	1.6554	3.0000	1
29	5592	16	0	4	Q2	2012	5.3400	1.7622	3.0000	1
29	5592	16	0	5	Q2	2012	5.3400	2.6166	3.0000	1
29	5912	11	0	9	Q3	2012	3.5600	1.3172	2.0000	1
29	5956	22	0	11	Q4	2012	3.5600	1.7444	2.0000	1
29	6504	14	1071	8	Q3	2012	1.7800	0.6408	1.0000	1
29	6564	13	0	9	Q3	2012	7.1200	2.3496	4.0000	1
29	6838	15	0	10	Q4	2012	5.3400	1.7088	3.0000	1
29	7132	13	0	3	Q1	2012	7.1200	3.4176	4.0000	1
29	7171	23	0	12	Q4	2012	5.3400	2.6166	3.0000	1
29	7187	7	0	7	Q3	2012	7.1200	3.4888	4.0000	1
29	7283	13	0	5	Q2	2012	7.1200	2.5632	4.0000	1
29	7654	15	0	5	Q2	2012	8.9000	4.0050	5.0000	1
29	7655	17	0	3	Q1	2012	5.3400	1.6020	3.0000	1
29	7979	24	0	4	Q2	2012	7.1200	2.1360	4.0000	1
29	8396	24	1866	11	Q4	2012	5.3400	2.5098	3.0000	1
29	8541	15	1150	8	Q3	2012	7.1200	3.2752	4.0000	1
29	8577	23	0	6	Q2	2012	7.1200	2.2072	4.0000	1
29	9134	23	1773	4	Q2	2012	3.5600	1.3528	2.0000	1
29	9176	23	0	3	Q1	2012	5.3400	2.1894	3.0000	1
29	9391	11	818	1	Q1	2012	5.3400	1.6554	3.0000	1
29	9550	6	526	12	Q4	2012	7.1200	2.4920	4.0000	1
29	9931	6	0	5	Q2	2012	7.1200	3.2040	4.0000	1
30	191	6	0	9	Q3	2012	4.2300	1.5651	3.0000	1
30	198	24	0	9	Q3	2012	2.8200	0.9306	2.0000	1
30	221	15	0	1	Q1	2012	5.6400	2.1996	4.0000	1
30	234	24	1856	6	Q2	2012	2.8200	0.8742	2.0000	1
30	484	13	0	1	Q1	2012	5.6400	2.3688	4.0000	1
30	538	11	0	9	Q3	2012	4.2300	1.4805	3.0000	1
30	551	7	0	4	Q2	2012	4.2300	1.5228	3.0000	1
30	916	7	0	4	Q2	2012	2.8200	0.9306	2.0000	1
30	1064	24	0	9	Q3	2012	7.0500	3.3135	5.0000	1
30	1264	2	0	4	Q2	2012	2.8200	1.1562	2.0000	1
30	1428	24	1866	11	Q4	2012	5.6400	1.9176	4.0000	1
30	1630	14	0	12	Q4	2012	2.8200	0.9024	2.0000	1
30	1923	11	0	11	Q4	2012	2.8200	1.1562	2.0000	1
30	1990	6	0	9	Q3	2012	4.2300	2.1150	3.0000	1
30	2077	23	1769	3	Q1	2012	4.2300	1.4805	3.0000	1
30	2143	17	0	8	Q3	2012	2.8200	1.3536	2.0000	1
30	2213	24	0	9	Q3	2012	2.8200	1.0434	2.0000	1
30	2234	13	0	10	Q4	2012	2.8200	1.0152	2.0000	1
30	2270	11	826	5	Q2	2012	2.8200	1.0998	2.0000	1
30	2443	13	0	12	Q4	2012	2.8200	1.0434	2.0000	1
30	2918	17	1314	11	Q4	2012	4.2300	1.4382	3.0000	1
30	3000	17	1297	3	Q1	2012	2.8200	1.1562	2.0000	1
30	3208	14	0	2	Q1	2012	2.8200	1.1280	2.0000	1
30	3267	23	0	8	Q3	2012	4.2300	1.5651	3.0000	1
30	3448	3	0	5	Q2	2012	2.8200	1.0152	2.0000	1
30	3706	13	982	4	Q2	2012	5.6400	2.7636	4.0000	1
30	3770	14	0	6	Q2	2012	1.4100	0.7050	1.0000	1
30	4094	16	1236	12	Q4	2012	2.8200	0.9870	2.0000	1
30	4591	15	1150	8	Q3	2012	4.2300	1.4805	3.0000	1
30	4666	13	0	2	Q1	2012	4.2300	2.0727	3.0000	1
30	4711	3	0	6	Q2	2012	2.8200	1.1562	2.0000	1
30	4764	24	0	12	Q4	2012	5.6400	2.5944	4.0000	1
30	4803	23	0	7	Q3	2012	5.6400	2.6508	4.0000	1
30	4873	17	0	9	Q3	2012	4.2300	1.8189	3.0000	1
30	5038	17	1304	7	Q3	2012	4.2300	1.7766	3.0000	1
30	5625	24	0	4	Q2	2012	2.8200	1.2690	2.0000	1
30	5684	24	0	6	Q2	2012	4.2300	1.6920	3.0000	1
30	5686	3	0	12	Q4	2012	4.2300	1.7343	3.0000	1
30	5739	11	0	6	Q2	2012	7.0500	2.3265	5.0000	1
30	5895	17	0	12	Q4	2012	4.2300	1.8612	3.0000	1
30	5999	23	0	10	Q4	2012	2.8200	0.9870	2.0000	1
30	6021	13	0	11	Q4	2012	4.2300	1.4805	3.0000	1
30	6096	7	0	12	Q4	2012	2.8200	1.2690	2.0000	1
30	6161	17	0	1	Q1	2012	5.6400	2.4816	4.0000	1
30	6606	24	0	8	Q3	2012	5.6400	2.1432	4.0000	1
30	6686	13	0	10	Q4	2012	5.6400	2.5380	4.0000	1
30	6709	11	0	4	Q2	2012	5.6400	2.4816	4.0000	1
30	6997	13	0	1	Q1	2012	2.8200	1.1844	2.0000	1
30	7065	17	0	12	Q4	2012	5.6400	2.1432	4.0000	1
30	7138	11	0	6	Q2	2012	4.2300	1.8189	3.0000	1
30	7241	17	0	4	Q2	2012	4.2300	1.4382	3.0000	1
30	7704	3	0	2	Q1	2012	5.6400	1.6920	4.0000	1
30	7940	13	984	5	Q2	2012	4.2300	1.6920	3.0000	1
30	8477	3	0	9	Q3	2012	5.6400	2.4816	4.0000	1
30	8511	16	0	8	Q3	2012	2.8200	1.0152	2.0000	1
30	8524	15	0	12	Q4	2012	5.6400	2.7072	4.0000	1
30	8551	17	0	6	Q2	2012	7.0500	3.0315	5.0000	1
30	8684	6	0	9	Q3	2012	2.8200	1.2126	2.0000	1
30	8684	7	0	5	Q2	2012	4.2300	2.0304	3.0000	1
30	8814	13	0	12	Q4	2012	5.6400	2.7636	4.0000	1
30	8947	3	201	8	Q3	2012	2.8200	1.2126	2.0000	1
30	8960	3	0	9	Q3	2012	2.8200	1.1562	2.0000	1
30	9040	16	0	11	Q4	2012	4.2300	1.5228	3.0000	1
30	9109	7	0	8	Q3	2012	4.2300	1.6074	3.0000	1
30	9271	17	1307	8	Q3	2012	5.6400	2.0868	4.0000	1
30	9276	7	504	2	Q1	2012	4.2300	1.7343	3.0000	1
31	544	2	119	7	Q3	2012	3.1000	1.5190	2.0000	1
31	625	13	0	10	Q4	2012	4.6500	1.6275	3.0000	1
31	2258	11	0	1	Q1	2012	3.1000	1.3020	2.0000	1
31	2335	17	0	4	Q2	2012	3.1000	1.3330	2.0000	1
31	2430	24	0	5	Q2	2012	4.6500	1.6740	3.0000	1
31	2444	13	0	9	Q3	2012	6.2000	2.1700	4.0000	1
31	2664	17	0	3	Q1	2012	4.6500	2.2785	3.0000	1
31	2793	24	0	1	Q1	2012	4.6500	1.9530	3.0000	1
31	2942	17	0	4	Q2	2012	3.1000	1.2090	2.0000	1
31	3109	11	836	9	Q3	2012	6.2000	2.5420	4.0000	1
31	3388	13	982	4	Q2	2012	3.1000	1.5190	2.0000	1
31	3826	16	0	8	Q3	2012	6.2000	2.8520	4.0000	1
31	4137	15	0	9	Q3	2012	6.2000	1.9840	4.0000	1
31	4204	17	0	9	Q3	2012	7.7500	2.7900	5.0000	1
31	4275	24	0	2	Q1	2012	6.2000	2.2320	4.0000	1
31	4351	23	0	11	Q4	2012	3.1000	1.2090	2.0000	1
31	4659	13	0	3	Q1	2012	6.2000	2.9140	4.0000	1
31	4868	16	0	8	Q3	2012	4.6500	1.9530	3.0000	1
31	5200	24	0	12	Q4	2012	4.6500	1.4415	3.0000	1
31	5467	2	0	11	Q4	2012	3.1000	1.0850	2.0000	1
31	5543	24	0	10	Q4	2012	4.6500	2.1390	3.0000	1
31	5592	16	0	6	Q2	2012	6.2000	2.2320	4.0000	1
31	5630	6	0	12	Q4	2012	4.6500	2.1855	3.0000	1
31	5766	16	0	5	Q2	2012	3.1000	1.1780	2.0000	1
31	5824	7	0	4	Q2	2012	6.2000	2.8520	4.0000	1
31	5877	17	0	12	Q4	2012	3.1000	1.4570	2.0000	1
31	6168	17	0	12	Q4	2012	3.1000	1.3020	2.0000	1
31	6424	6	518	8	Q3	2012	4.6500	2.0925	3.0000	1
31	7507	6	0	5	Q2	2012	3.1000	1.4570	2.0000	1
31	7811	11	0	6	Q2	2012	4.6500	1.7205	3.0000	1
31	7878	15	0	12	Q4	2012	4.6500	1.6740	3.0000	1
31	8046	7	0	12	Q4	2012	4.6500	1.8600	3.0000	1
31	8070	6	0	6	Q2	2012	3.1000	1.1780	2.0000	1
31	8083	24	1851	4	Q2	2012	6.2000	2.1080	4.0000	1
31	8151	6	0	6	Q2	2012	4.6500	2.1855	3.0000	1
31	8172	17	0	6	Q2	2012	3.1000	1.2710	2.0000	1
31	8215	11	0	2	Q1	2012	3.1000	1.3950	2.0000	1
31	8289	17	0	12	Q4	2012	4.6500	1.8135	3.0000	1
31	8687	23	0	3	Q1	2012	4.6500	1.9530	3.0000	1
31	8687	23	1789	12	Q4	2012	3.1000	1.1160	2.0000	1
31	8737	11	837	10	Q4	2012	3.1000	1.4260	2.0000	1
31	8746	23	0	1	Q1	2012	6.2000	2.8520	4.0000	1
31	9146	22	0	10	Q4	2012	3.1000	1.4260	2.0000	1
31	9276	7	512	6	Q2	2012	4.6500	2.1855	3.0000	1
31	9643	13	0	10	Q4	2012	6.2000	2.2940	4.0000	1
31	9686	6	510	5	Q2	2012	3.1000	1.5500	2.0000	1
31	9752	17	0	5	Q2	2012	4.6500	1.7205	3.0000	1
31	9873	15	0	8	Q3	2012	4.6500	1.4880	3.0000	1
31	9998	6	0	5	Q2	2012	4.6500	1.7670	3.0000	1
32	625	13	0	2	Q1	2012	8.5800	4.0326	3.0000	1
32	997	3	0	11	Q4	2012	8.5800	3.7752	3.0000	1
32	1024	17	0	12	Q4	2012	11.4400	3.6608	4.0000	1
32	1098	15	0	10	Q4	2012	11.4400	4.2328	4.0000	1
32	1337	17	1312	10	Q4	2012	8.5800	2.7456	3.0000	1
32	1533	3	0	8	Q3	2012	8.5800	3.5178	3.0000	1
32	1607	17	0	12	Q4	2012	8.5800	2.7456	3.0000	1
32	1874	17	1307	8	Q3	2012	11.4400	4.8048	4.0000	1
32	2042	13	0	4	Q2	2012	11.4400	5.4912	4.0000	1
32	2059	17	0	2	Q1	2012	5.7200	2.0592	2.0000	1
32	2059	17	1292	1	Q1	2012	5.7200	2.5168	2.0000	1
32	2259	15	1140	4	Q2	2012	5.7200	2.4024	2.0000	1
32	2352	11	0	1	Q1	2012	8.5800	3.0888	3.0000	1
32	2587	16	1231	9	Q3	2012	11.4400	5.4912	4.0000	1
32	2632	13	988	7	Q3	2012	8.5800	4.1184	3.0000	1
32	2723	3	0	3	Q1	2012	8.5800	4.2042	3.0000	1
32	2850	3	0	10	Q4	2012	8.5800	3.7752	3.0000	1
32	2942	17	0	11	Q4	2012	5.7200	2.2308	2.0000	1
32	3395	11	0	2	Q1	2012	14.3000	4.4330	5.0000	1
32	3586	11	0	11	Q4	2012	11.4400	3.7752	4.0000	1
32	3755	24	0	8	Q3	2012	8.5800	3.7752	3.0000	1
32	4644	11	0	4	Q2	2012	5.7200	2.1164	2.0000	1
32	4674	7	0	10	Q4	2012	14.3000	6.5780	5.0000	1
32	4819	6	0	7	Q3	2012	5.7200	1.7160	2.0000	1
32	4873	17	0	12	Q4	2012	8.5800	4.2042	3.0000	1
32	4938	13	976	1	Q1	2012	11.4400	4.9192	4.0000	1
32	5245	11	0	7	Q3	2012	11.4400	5.4912	4.0000	1
32	5288	13	986	6	Q2	2012	8.5800	3.5178	3.0000	1
32	5600	14	0	2	Q1	2012	8.5800	3.0888	3.0000	1
32	6168	17	0	8	Q3	2012	5.7200	2.4024	2.0000	1
32	6304	6	0	6	Q2	2012	8.5800	4.2042	3.0000	1
32	6567	15	0	6	Q2	2012	11.4400	4.1184	4.0000	1
32	6759	22	0	4	Q2	2012	5.7200	1.8876	2.0000	1
32	6877	24	0	10	Q4	2012	5.7200	1.8304	2.0000	1
32	7060	7	0	1	Q1	2012	5.7200	2.8028	2.0000	1
32	7234	16	0	7	Q3	2012	8.5800	3.7752	3.0000	1
32	7502	16	1236	12	Q4	2012	8.5800	3.0030	3.0000	1
32	7556	17	1303	6	Q2	2012	11.4400	4.6904	4.0000	1
32	7577	7	0	9	Q3	2012	11.4400	5.0336	4.0000	1
32	7694	13	0	5	Q2	2012	11.4400	5.6056	4.0000	1
32	8196	24	0	8	Q3	2012	5.7200	2.0020	2.0000	1
32	8511	16	0	11	Q4	2012	8.5800	3.6894	3.0000	1
32	8916	11	842	12	Q4	2012	5.7200	2.2880	2.0000	1
32	9175	24	1845	1	Q1	2012	8.5800	2.9172	3.0000	1
32	10182	24	0	12	Q4	2012	5.7200	2.4596	2.0000	1
33	213	7	0	8	Q3	2012	5.4400	2.4480	4.0000	1
33	274	13	0	11	Q4	2012	2.7200	1.0336	2.0000	1
33	625	13	984	5	Q2	2012	4.0800	1.4280	3.0000	1
33	854	2	0	3	Q1	2012	1.3600	0.4216	1.0000	1
33	1216	17	0	5	Q2	2012	5.4400	2.5568	4.0000	1
33	2086	13	0	11	Q4	2012	5.4400	2.3936	4.0000	1
33	2244	17	1307	8	Q3	2012	4.0800	1.9992	3.0000	1
33	2271	7	519	9	Q3	2012	4.0800	1.4280	3.0000	1
33	2897	15	0	7	Q3	2012	2.7200	1.3328	2.0000	1
33	3591	24	0	1	Q1	2012	4.0800	1.9992	3.0000	1
33	3669	24	0	7	Q3	2012	4.0800	1.3056	3.0000	1
33	3799	13	0	3	Q1	2012	4.0800	1.7136	3.0000	1
33	3813	6	0	6	Q2	2012	2.7200	1.1696	2.0000	1
33	3825	22	0	6	Q2	2012	4.0800	1.9992	3.0000	1
33	3937	13	0	7	Q3	2012	5.4400	1.7952	4.0000	1
33	4369	15	0	11	Q4	2012	4.0800	1.8768	3.0000	1
33	4391	16	1220	4	Q2	2012	5.4400	2.3936	4.0000	1
33	4481	15	0	1	Q1	2012	6.8000	2.0400	5.0000	1
33	4518	13	0	1	Q1	2012	2.7200	1.1424	2.0000	1
33	4562	11	0	2	Q1	2012	2.7200	1.1968	2.0000	1
33	5493	6	523	11	Q4	2012	5.4400	2.5024	4.0000	1
33	5982	13	0	10	Q4	2012	4.0800	1.5096	3.0000	1
33	6271	7	521	10	Q4	2012	4.0800	1.6728	3.0000	1
33	6547	15	0	5	Q2	2012	4.0800	1.4688	3.0000	1
33	6687	7	0	6	Q2	2012	5.4400	2.5024	4.0000	1
33	6878	7	0	9	Q3	2012	4.0800	1.7544	3.0000	1
33	7075	15	0	1	Q1	2012	2.7200	1.3328	2.0000	1
33	7130	24	0	7	Q3	2012	4.0800	1.8360	3.0000	1
33	7343	6	0	10	Q4	2012	4.0800	1.5912	3.0000	1
33	7348	11	0	9	Q3	2012	5.4400	1.6864	4.0000	1
33	7406	11	0	3	Q1	2012	4.0800	1.7544	3.0000	1
33	7455	13	0	4	Q2	2012	4.0800	1.4688	3.0000	1
33	7813	17	0	6	Q2	2012	5.4400	2.4480	4.0000	1
33	7849	3	205	10	Q4	2012	2.7200	1.1424	2.0000	1
33	8411	15	0	4	Q2	2012	4.0800	1.3872	3.0000	1
33	8432	7	0	9	Q3	2012	5.4400	1.9040	4.0000	1
33	8665	15	0	12	Q4	2012	4.0800	1.9176	3.0000	1
33	8864	7	0	5	Q2	2012	4.0800	1.3056	3.0000	1
33	8901	13	0	2	Q1	2012	4.0800	1.3872	3.0000	1
33	9008	15	0	7	Q3	2012	4.0800	1.7544	3.0000	1
33	9601	11	0	7	Q3	2012	4.0800	1.7136	3.0000	1
33	9631	16	1235	11	Q4	2012	5.4400	2.3936	4.0000	1
33	9797	16	1220	4	Q2	2012	4.0800	1.9992	3.0000	1
33	9823	13	0	12	Q4	2012	4.0800	1.9584	3.0000	1
34	187	13	0	10	Q4	2012	3.3800	1.0140	2.0000	1
34	511	16	0	9	Q3	2012	5.0700	2.1294	3.0000	1
34	819	13	0	3	Q1	2012	3.3800	1.3858	2.0000	1
34	976	16	1220	4	Q2	2012	5.0700	1.8252	3.0000	1
34	1153	13	0	5	Q2	2012	3.3800	1.1154	2.0000	1
34	1235	11	0	1	Q1	2012	3.3800	1.2844	2.0000	1
34	1310	16	1231	9	Q3	2012	6.7600	2.2308	4.0000	1
34	1347	13	0	11	Q4	2012	3.3800	1.4872	2.0000	1
34	1491	16	0	3	Q1	2012	5.0700	2.3322	3.0000	1
34	1555	24	0	4	Q2	2012	6.7600	2.4336	4.0000	1
34	1626	13	984	5	Q2	2012	5.0700	1.8759	3.0000	1
34	1649	24	1869	12	Q4	2012	3.3800	1.6900	2.0000	1
34	1690	16	0	11	Q4	2012	5.0700	1.7238	3.0000	1
34	1780	24	0	4	Q2	2012	3.3800	1.3520	2.0000	1
34	1847	11	829	6	Q2	2012	6.7600	3.0420	4.0000	1
34	1850	16	0	6	Q2	2012	6.7600	2.9744	4.0000	1
34	2059	17	0	7	Q3	2012	5.0700	2.5350	3.0000	1
34	2587	16	0	5	Q2	2012	5.0700	1.8759	3.0000	1
34	2648	24	0	2	Q1	2012	5.0700	1.6224	3.0000	1
34	2769	16	0	1	Q1	2012	5.0700	1.8759	3.0000	1
34	2870	7	0	11	Q4	2012	3.3800	1.3858	2.0000	1
34	3092	15	1150	8	Q3	2012	5.0700	1.8759	3.0000	1
34	3133	24	0	5	Q2	2012	6.7600	3.3124	4.0000	1
34	3204	24	0	3	Q1	2012	3.3800	1.1830	2.0000	1
34	3435	11	837	10	Q4	2012	6.7600	2.0280	4.0000	1
34	3528	17	0	5	Q2	2012	5.0700	1.7745	3.0000	1
34	3711	3	202	8	Q3	2012	3.3800	1.6562	2.0000	1
34	5063	3	0	6	Q2	2012	3.3800	1.3858	2.0000	1
34	5138	24	0	11	Q4	2012	5.0700	1.9266	3.0000	1
34	5245	11	0	1	Q1	2012	6.7600	2.9744	4.0000	1
34	5398	17	0	12	Q4	2012	3.3800	1.5886	2.0000	1
34	5590	17	1307	8	Q3	2012	6.7600	3.3124	4.0000	1
34	5639	11	0	11	Q4	2012	5.0700	2.0280	3.0000	1
34	5742	16	0	11	Q4	2012	5.0700	1.7238	3.0000	1
34	5820	17	0	6	Q2	2012	5.0700	1.5210	3.0000	1
34	6114	16	0	9	Q3	2012	6.7600	2.9068	4.0000	1
34	6352	13	992	9	Q3	2012	6.7600	2.3660	4.0000	1
34	6598	11	0	4	Q2	2012	3.3800	1.4196	2.0000	1
34	6683	17	0	4	Q2	2012	6.7600	3.1096	4.0000	1
34	6919	11	0	8	Q3	2012	6.7600	2.9068	4.0000	1
34	6936	17	0	2	Q1	2012	6.7600	2.3660	4.0000	1
34	7292	13	0	12	Q4	2012	3.3800	1.6562	2.0000	1
34	7357	24	0	7	Q3	2012	6.7600	3.3124	4.0000	1
34	8134	11	0	2	Q1	2012	5.0700	2.4336	3.0000	1
34	8242	17	0	5	Q2	2012	6.7600	2.4336	4.0000	1
34	8412	11	842	12	Q4	2012	5.0700	2.3322	3.0000	1
34	8682	7	0	12	Q4	2012	6.7600	3.3124	4.0000	1
34	9064	17	0	10	Q4	2012	6.7600	2.1632	4.0000	1
34	9297	13	0	9	Q3	2012	5.0700	1.6224	3.0000	1
34	9427	24	0	3	Q1	2012	6.7600	2.9744	4.0000	1
34	9501	13	0	1	Q1	2012	6.7600	2.3660	4.0000	1
34	9622	6	0	12	Q4	2012	6.7600	3.1772	4.0000	1
34	10102	6	0	7	Q3	2012	5.0700	2.4843	3.0000	1
35	372	2	126	10	Q4	2012	2.2100	0.9282	1.0000	1
35	511	16	0	3	Q1	2012	4.4200	2.0774	2.0000	1
35	726	15	0	5	Q2	2012	6.6300	2.2542	3.0000	1
35	905	3	197	6	Q2	2012	8.8400	3.2708	4.0000	1
35	1097	23	0	4	Q2	2012	4.4200	1.5470	2.0000	1
35	1147	13	0	7	Q3	2012	6.6300	2.9172	3.0000	1
35	1297	16	0	2	Q1	2012	8.8400	3.8012	4.0000	1
35	1351	24	0	10	Q4	2012	6.6300	2.3868	3.0000	1
35	1409	24	0	6	Q2	2012	6.6300	2.9835	3.0000	1
35	1941	15	0	7	Q3	2012	4.4200	1.3260	2.0000	1
35	2193	7	0	10	Q4	2012	6.6300	2.7846	3.0000	1
35	2479	13	0	7	Q3	2012	8.8400	3.7128	4.0000	1
35	2493	17	0	4	Q2	2012	4.4200	1.9006	2.0000	1
35	3000	17	0	4	Q2	2012	4.4200	1.7238	2.0000	1
35	3173	11	0	10	Q4	2012	6.6300	2.3205	3.0000	1
35	3246	7	0	3	Q1	2012	6.6300	2.4531	3.0000	1
35	3441	3	202	8	Q3	2012	8.8400	2.7404	4.0000	1
35	3469	24	1869	12	Q4	2012	6.6300	2.9172	3.0000	1
35	3596	11	0	7	Q3	2012	4.4200	2.0774	2.0000	1
35	3946	6	0	4	Q2	2012	4.4200	1.8564	2.0000	1
35	4304	15	1152	9	Q3	2012	6.6300	2.4531	3.0000	1
35	4564	17	0	9	Q3	2012	4.4200	2.1658	2.0000	1
35	4595	11	837	10	Q4	2012	8.8400	4.2432	4.0000	1
35	4726	11	0	3	Q1	2012	6.6300	2.5194	3.0000	1
35	4838	15	0	8	Q3	2012	6.6300	2.3205	3.0000	1
35	5219	17	1293	1	Q1	2012	4.4200	1.3702	2.0000	1
35	5374	16	0	6	Q2	2012	6.6300	2.9172	3.0000	1
35	5501	17	0	9	Q3	2012	8.8400	3.0940	4.0000	1
35	5835	24	0	10	Q4	2012	4.4200	1.9890	2.0000	1
35	5958	13	980	3	Q1	2012	6.6300	2.8509	3.0000	1
35	6301	15	0	1	Q1	2012	4.4200	1.5470	2.0000	1
35	6432	24	0	8	Q3	2012	4.4200	2.1216	2.0000	1
35	6623	14	0	7	Q3	2012	2.2100	1.0829	1.0000	1
35	7241	17	0	2	Q1	2012	8.8400	3.3592	4.0000	1
35	7276	23	1789	12	Q4	2012	4.4200	1.9890	2.0000	1
35	7621	13	0	12	Q4	2012	8.8400	2.9172	4.0000	1
35	7674	7	0	10	Q4	2012	4.4200	1.4586	2.0000	1
35	7702	16	0	2	Q1	2012	6.6300	2.3868	3.0000	1
35	7789	15	0	7	Q3	2012	8.8400	4.0664	4.0000	1
35	8307	14	0	4	Q2	2012	2.2100	0.9061	1.0000	1
35	9012	24	0	10	Q4	2012	6.6300	1.9890	3.0000	1
35	9420	13	0	9	Q3	2012	8.8400	2.8288	4.0000	1
35	9447	13	0	7	Q3	2012	4.4200	1.8564	2.0000	1
35	9747	13	0	8	Q3	2012	6.6300	2.1216	3.0000	1
35	9951	3	0	1	Q1	2012	6.6300	2.7846	3.0000	1
35	10120	6	508	4	Q2	2012	6.6300	3.1824	3.0000	1
36	217	13	0	12	Q4	2012	3.6000	1.1520	2.0000	1
36	417	6	0	9	Q3	2012	3.6000	1.5480	2.0000	1
36	551	6	0	7	Q3	2012	5.4000	2.0520	3.0000	1
36	901	13	0	7	Q3	2012	5.4000	1.8900	3.0000	1
36	927	6	504	2	Q1	2012	3.6000	1.7640	2.0000	1
36	1093	13	0	7	Q3	2012	5.4000	1.9440	3.0000	1
36	1207	14	0	6	Q2	2012	1.8000	0.8100	1.0000	1
36	1249	15	0	6	Q2	2012	5.4000	2.3760	3.0000	1
36	1263	13	0	5	Q2	2012	5.4000	2.3760	3.0000	1
36	1341	3	205	10	Q4	2012	3.6000	1.5480	2.0000	1
36	1533	3	0	11	Q4	2012	3.6000	1.2600	2.0000	1
36	1556	17	1292	1	Q1	2012	7.2000	3.1680	4.0000	1
36	1594	11	0	11	Q4	2012	5.4000	1.7280	3.0000	1
36	2078	24	0	9	Q3	2012	7.2000	2.2320	4.0000	1
36	2313	24	1845	1	Q1	2012	7.2000	2.3040	4.0000	1
36	2368	3	207	11	Q4	2012	3.6000	1.4400	2.0000	1
36	2656	13	0	12	Q4	2012	5.4000	2.4840	3.0000	1
36	2662	11	0	1	Q1	2012	3.6000	1.6200	2.0000	1
36	2678	3	0	8	Q3	2012	3.6000	1.2240	2.0000	1
36	2933	24	0	6	Q2	2012	5.4000	2.2680	3.0000	1
36	3005	6	0	2	Q1	2012	9.0000	4.3200	5.0000	1
36	3242	3	0	7	Q3	2012	7.2000	2.6640	4.0000	1
36	3258	6	0	2	Q1	2012	3.6000	1.3320	2.0000	1
36	3407	7	0	12	Q4	2012	5.4000	1.9440	3.0000	1
36	3467	15	0	7	Q3	2012	3.6000	1.4760	2.0000	1
36	3627	3	0	9	Q3	2012	7.2000	3.1680	4.0000	1
36	4021	16	1233	10	Q4	2012	7.2000	2.1600	4.0000	1
36	4094	16	0	6	Q2	2012	5.4000	2.5380	3.0000	1
36	4450	7	0	1	Q1	2012	5.4000	1.6200	3.0000	1
36	4453	11	0	5	Q2	2012	5.4000	2.3220	3.0000	1
36	4461	11	0	11	Q4	2012	3.6000	1.3680	2.0000	1
36	4623	13	0	3	Q1	2012	3.6000	1.3320	2.0000	1
36	5173	15	1134	1	Q1	2012	3.6000	1.3680	2.0000	1
36	5182	15	1146	7	Q3	2012	5.4000	2.1600	3.0000	1
36	5195	15	0	4	Q2	2012	7.2000	2.7360	4.0000	1
36	5209	14	0	8	Q3	2012	1.8000	0.8460	1.0000	1
36	5228	24	1847	2	Q1	2012	5.4000	1.7820	3.0000	1
36	5501	17	1303	6	Q2	2012	5.4000	2.1600	3.0000	1
36	5734	13	0	2	Q1	2012	7.2000	2.9520	4.0000	1
36	5742	16	1235	11	Q4	2012	5.4000	2.0520	3.0000	1
36	6003	13	0	4	Q2	2012	5.4000	2.3220	3.0000	1
36	6324	23	1789	12	Q4	2012	7.2000	2.5920	4.0000	1
36	6423	17	0	1	Q1	2012	3.6000	1.6200	2.0000	1
36	6849	6	0	7	Q3	2012	7.2000	2.8800	4.0000	1
36	6912	16	0	5	Q2	2012	7.2000	2.8080	4.0000	1
36	6974	2	0	11	Q4	2012	1.8000	0.8280	1.0000	1
36	7035	6	0	6	Q2	2012	5.4000	1.6200	3.0000	1
36	7411	7	0	5	Q2	2012	3.6000	1.3680	2.0000	1
36	7526	17	0	4	Q2	2012	5.4000	1.9440	3.0000	1
36	7572	15	0	11	Q4	2012	5.4000	2.5380	3.0000	1
36	7692	24	0	11	Q4	2012	7.2000	2.8080	4.0000	1
36	7725	14	0	2	Q1	2012	3.6000	1.6920	2.0000	1
36	7896	23	0	6	Q2	2012	7.2000	2.4480	4.0000	1
36	7989	17	0	1	Q1	2012	3.6000	1.5120	2.0000	1
36	8068	3	0	12	Q4	2012	3.6000	1.5480	2.0000	1
36	8442	17	1314	11	Q4	2012	3.6000	1.5120	2.0000	1
36	8597	7	0	10	Q4	2012	7.2000	2.2320	4.0000	1
36	8606	15	1134	1	Q1	2012	5.4000	2.3760	3.0000	1
36	8717	17	0	2	Q1	2012	7.2000	2.8080	4.0000	1
36	9353	15	0	10	Q4	2012	7.2000	3.5280	4.0000	1
36	9391	11	0	4	Q2	2012	3.6000	1.4400	2.0000	1
36	9550	6	524	11	Q4	2012	7.2000	3.0240	4.0000	1
36	9668	13	984	5	Q2	2012	5.4000	1.9980	3.0000	1
36	9863	13	0	7	Q3	2012	5.4000	2.5920	3.0000	1
36	9863	13	0	9	Q3	2012	7.2000	2.5200	4.0000	1
36	10126	6	0	12	Q4	2012	3.6000	1.7280	2.0000	1
37	142	15	0	1	Q1	2012	6.3600	2.1624	4.0000	1
37	676	7	0	7	Q3	2012	4.7700	1.8126	3.0000	1
37	905	3	0	11	Q4	2012	4.7700	2.0511	3.0000	1
37	997	3	0	12	Q4	2012	6.3600	2.3532	4.0000	1
37	1290	15	1154	10	Q4	2012	6.3600	2.4168	4.0000	1
37	1415	16	1235	11	Q4	2012	6.3600	2.9892	4.0000	1
37	1433	6	0	5	Q2	2012	4.7700	1.9557	3.0000	1
37	1798	3	205	10	Q4	2012	4.7700	1.6218	3.0000	1
37	1850	16	1214	2	Q1	2012	4.7700	2.0511	3.0000	1
37	2044	15	0	9	Q3	2012	4.7700	1.6218	3.0000	1
37	2211	17	0	11	Q4	2012	7.9500	3.8955	5.0000	1
37	2255	24	1866	11	Q4	2012	6.3600	2.0988	4.0000	1
37	2547	23	1768	2	Q1	2012	6.3600	2.4168	4.0000	1
37	2908	11	0	1	Q1	2012	4.7700	1.4787	3.0000	1
37	2925	11	0	10	Q4	2012	4.7700	1.4787	3.0000	1
37	4291	15	0	7	Q3	2012	6.3600	2.2260	4.0000	1
37	4434	15	0	10	Q4	2012	3.1800	1.4310	2.0000	1
37	4666	13	0	7	Q3	2012	6.3600	2.9892	4.0000	1
37	5276	15	0	12	Q4	2012	7.9500	3.7365	5.0000	1
37	5522	24	0	11	Q4	2012	4.7700	2.0034	3.0000	1
37	5954	6	504	2	Q1	2012	6.3600	1.9716	4.0000	1
37	6051	11	0	5	Q2	2012	4.7700	2.2419	3.0000	1
37	6139	14	0	9	Q3	2012	1.5900	0.5565	1.0000	1
37	6348	16	0	3	Q1	2012	3.1800	1.5264	2.0000	1
37	6434	14	1065	6	Q2	2012	1.5900	0.7791	1.0000	1
37	6541	23	0	11	Q4	2012	4.7700	1.7172	3.0000	1
37	6567	15	0	6	Q2	2012	4.7700	1.8126	3.0000	1
37	6841	3	0	1	Q1	2012	3.1800	1.1130	2.0000	1
37	7031	11	0	6	Q2	2012	3.1800	1.2402	2.0000	1
37	7079	11	0	12	Q4	2012	7.9500	3.8955	5.0000	1
37	7100	17	0	3	Q1	2012	4.7700	1.7172	3.0000	1
37	7276	23	0	10	Q4	2012	3.1800	1.4946	2.0000	1
37	7292	13	0	1	Q1	2012	6.3600	2.2896	4.0000	1
37	7470	13	0	6	Q2	2012	6.3600	2.9256	4.0000	1
37	7523	7	504	2	Q1	2012	4.7700	1.6218	3.0000	1
37	7657	11	821	2	Q1	2012	6.3600	2.3532	4.0000	1
37	7696	23	0	1	Q1	2012	3.1800	1.1448	2.0000	1
37	7733	13	0	2	Q1	2012	6.3600	3.1164	4.0000	1
37	7831	17	0	1	Q1	2012	4.7700	1.5264	3.0000	1
37	8124	6	523	11	Q4	2012	4.7700	1.4310	3.0000	1
37	8189	17	0	3	Q1	2012	3.1800	1.1448	2.0000	1
37	8250	15	0	11	Q4	2012	4.7700	2.2419	3.0000	1
37	8418	22	1694	4	Q2	2012	4.7700	1.8126	3.0000	1
37	8443	24	0	3	Q1	2012	4.7700	1.4787	3.0000	1
37	8695	15	0	1	Q1	2012	4.7700	1.7649	3.0000	1
37	8902	3	0	11	Q4	2012	4.7700	1.7172	3.0000	1
37	9194	17	0	6	Q2	2012	4.7700	2.0034	3.0000	1
37	9217	6	524	11	Q4	2012	6.3600	2.0352	4.0000	1
37	9390	7	501	1	Q1	2012	4.7700	2.3373	3.0000	1
37	9491	13	0	9	Q3	2012	4.7700	1.5264	3.0000	1
37	9491	13	980	3	Q1	2012	6.3600	2.3532	4.0000	1
37	9960	7	0	1	Q1	2012	4.7700	1.8126	3.0000	1
37	9997	17	0	6	Q2	2012	4.7700	2.2419	3.0000	1
37	10168	15	0	10	Q4	2012	6.3600	2.1624	4.0000	1
37	10228	24	0	9	Q3	2012	3.1800	1.1766	2.0000	1
38	293	22	0	12	Q4	2012	3.9300	1.8471	3.0000	1
38	338	2	0	4	Q2	2012	1.3100	0.4061	1.0000	1
38	352	11	0	4	Q2	2012	2.6200	1.1528	2.0000	1
38	734	6	522	10	Q4	2012	3.9300	1.9257	3.0000	1
38	997	3	0	10	Q4	2012	2.6200	0.7860	2.0000	1
38	1034	24	0	4	Q2	2012	2.6200	0.9432	2.0000	1
38	1555	24	0	4	Q2	2012	5.2400	1.9912	4.0000	1
38	1701	13	0	4	Q2	2012	3.9300	1.6506	3.0000	1
38	1931	15	0	6	Q2	2012	5.2400	2.5676	4.0000	1
38	1931	15	1134	1	Q1	2012	3.9300	1.9257	3.0000	1
38	2368	3	197	6	Q2	2012	2.6200	0.8908	2.0000	1
38	2378	16	0	2	Q1	2012	3.9300	1.8471	3.0000	1
38	2942	17	1314	11	Q4	2012	5.2400	1.5720	4.0000	1
38	2981	23	0	7	Q3	2012	3.9300	1.5720	3.0000	1
38	3012	24	0	2	Q1	2012	5.2400	1.8864	4.0000	1
38	3443	15	0	8	Q3	2012	5.2400	1.9388	4.0000	1
38	4344	6	0	3	Q1	2012	3.9300	1.3362	3.0000	1
38	4344	7	0	12	Q4	2012	3.9300	1.5327	3.0000	1
38	4413	13	988	7	Q3	2012	5.2400	1.9388	4.0000	1
38	4808	11	0	3	Q1	2012	3.9300	1.4934	3.0000	1
38	5013	7	504	2	Q1	2012	3.9300	1.8864	3.0000	1
38	5063	3	0	7	Q3	2012	3.9300	1.6899	3.0000	1
38	5088	13	0	10	Q4	2012	5.2400	1.7292	4.0000	1
38	5317	15	1154	10	Q4	2012	3.9300	1.2183	3.0000	1
38	5547	6	0	12	Q4	2012	3.9300	1.4148	3.0000	1
38	5593	13	0	11	Q4	2012	5.2400	2.0436	4.0000	1
38	5799	15	0	6	Q2	2012	3.9300	1.2576	3.0000	1
38	6168	17	0	7	Q3	2012	3.9300	1.4148	3.0000	1
38	7056	3	0	3	Q1	2012	3.9300	1.7685	3.0000	1
38	7241	17	0	4	Q2	2012	2.6200	0.9956	2.0000	1
38	7601	24	0	3	Q1	2012	3.9300	1.2183	3.0000	1
38	7621	13	0	1	Q1	2012	5.2400	1.6768	4.0000	1
38	7811	11	818	1	Q1	2012	2.6200	1.1266	2.0000	1
38	8074	17	0	12	Q4	2012	9.1700	3.8776	7.0000	2
38	8133	6	0	11	Q4	2012	5.2400	2.3056	4.0000	1
38	8242	17	0	5	Q2	2012	3.9300	1.2576	3.0000	1
38	8253	24	0	9	Q3	2012	3.9300	1.8864	3.0000	1
38	8310	13	984	5	Q2	2012	2.6200	1.3100	2.0000	1
38	8780	15	1136	2	Q1	2012	2.6200	0.9694	2.0000	1
38	9026	13	0	9	Q3	2012	3.9300	1.8864	3.0000	1
38	9075	7	0	6	Q2	2012	3.9300	1.4541	3.0000	1
38	9194	17	1292	1	Q1	2012	6.5500	3.0785	5.0000	1
38	9200	16	0	6	Q2	2012	3.9300	1.9257	3.0000	1
38	9929	13	0	1	Q1	2012	5.2400	2.1484	4.0000	1
38	10243	17	0	11	Q4	2012	3.9300	1.8864	3.0000	1
39	548	7	0	8	Q3	2012	12.4400	4.1052	4.0000	1
39	739	23	0	12	Q4	2012	6.2200	3.0478	2.0000	1
39	779	15	0	10	Q4	2012	9.3300	3.6387	3.0000	1
39	868	6	0	11	Q4	2012	9.3300	3.5454	3.0000	1
39	901	13	0	4	Q2	2012	9.3300	3.8253	3.0000	1
39	923	15	1138	3	Q1	2012	12.4400	5.5980	4.0000	1
39	1412	11	0	12	Q4	2012	9.3300	4.5717	3.0000	1
39	1468	13	0	8	Q3	2012	9.3300	3.6387	3.0000	1
39	1490	13	0	1	Q1	2012	6.2200	2.3636	2.0000	1
39	1850	16	0	11	Q4	2012	9.3300	2.9856	3.0000	1
39	2371	16	0	9	Q3	2012	9.3300	3.3588	3.0000	1
39	2426	17	0	5	Q2	2012	6.2200	1.9282	2.0000	1
39	2672	24	0	7	Q3	2012	12.4400	4.4784	4.0000	1
39	2817	7	523	11	Q4	2012	12.4400	4.8516	4.0000	1
39	2829	23	0	1	Q1	2012	6.2200	2.5502	2.0000	1
39	3166	24	0	5	Q2	2012	6.2200	2.8612	2.0000	1
39	3242	3	0	6	Q2	2012	9.3300	3.6387	3.0000	1
39	3540	24	1866	11	Q4	2012	9.3300	3.5454	3.0000	1
39	3543	11	0	5	Q2	2012	12.4400	5.9712	4.0000	1
39	3645	2	0	7	Q3	2012	3.1100	1.2440	1.0000	1
39	3768	7	0	6	Q2	2012	9.3300	3.1722	3.0000	1
39	3977	13	0	1	Q1	2012	9.3300	3.1722	3.0000	1
39	4390	11	0	11	Q4	2012	9.3300	4.1985	3.0000	1
39	4541	3	202	8	Q3	2012	9.3300	4.3851	3.0000	1
39	4670	17	1311	10	Q4	2012	9.3300	2.7990	3.0000	1
39	4803	23	0	3	Q1	2012	6.2200	2.6746	2.0000	1
39	5501	17	0	12	Q4	2012	12.4400	4.2296	4.0000	1
39	5505	15	1157	12	Q4	2012	6.2200	2.9234	2.0000	1
39	5533	13	0	1	Q1	2012	9.3300	4.3851	3.0000	1
39	5592	16	0	8	Q3	2012	6.2200	2.1770	2.0000	1
39	5644	17	0	5	Q2	2012	12.4400	5.4736	4.0000	1
39	5647	15	0	5	Q2	2012	9.3300	4.4784	3.0000	1
39	5827	11	826	5	Q2	2012	9.3300	3.4521	3.0000	1
39	5847	22	1710	12	Q4	2012	6.2200	1.9282	2.0000	1
39	6114	16	0	3	Q1	2012	6.2200	2.3636	2.0000	1
39	6706	7	526	12	Q4	2012	12.4400	3.8564	4.0000	1
39	7190	23	0	6	Q2	2012	9.3300	2.8923	3.0000	1
39	7370	23	1771	3	Q1	2012	12.4400	5.5980	4.0000	1
39	7822	3	0	5	Q2	2012	9.3300	4.1985	3.0000	1
39	7841	6	0	9	Q3	2012	9.3300	2.7990	3.0000	1
39	7893	11	821	3	Q1	2012	12.4400	5.4736	4.0000	1
39	7905	13	984	5	Q2	2012	12.4400	6.0956	4.0000	1
39	8164	13	0	11	Q4	2012	9.3300	3.2655	3.0000	1
39	8198	11	824	4	Q2	2012	12.4400	4.8516	4.0000	1
39	8412	11	842	12	Q4	2012	9.3300	4.2918	3.0000	1
39	8736	24	0	5	Q2	2012	12.4400	4.1052	4.0000	1
39	8736	24	0	9	Q3	2012	12.4400	3.9808	4.0000	1
39	8942	6	0	10	Q4	2012	9.3300	4.1052	3.0000	1
39	9224	17	1303	6	Q2	2012	15.5500	7.1530	5.0000	1
39	9335	11	0	8	Q3	2012	6.2200	2.3014	2.0000	1
39	9499	6	511	5	Q2	2012	9.3300	3.3588	3.0000	1
39	9557	3	0	11	Q4	2012	6.2200	1.9282	2.0000	1
39	9810	24	0	3	Q1	2012	9.3300	4.1985	3.0000	1
39	9881	3	0	12	Q4	2012	6.2200	2.6746	2.0000	1
39	9927	24	0	11	Q4	2012	9.3300	2.9856	3.0000	1
39	9929	13	0	11	Q4	2012	9.3300	3.4521	3.0000	1
39	10116	17	0	9	Q3	2012	6.2200	1.9282	2.0000	1
39	10176	13	0	5	Q2	2012	6.2200	2.4880	2.0000	1
40	638	11	824	4	Q2	2012	3.9600	1.2276	4.0000	1
40	694	11	0	11	Q4	2012	2.9700	1.1286	3.0000	1
40	886	15	1146	7	Q3	2012	3.9600	1.5444	4.0000	1
40	988	15	0	8	Q3	2012	3.9600	1.5444	4.0000	1
40	1033	24	0	1	Q1	2012	4.9500	1.6830	5.0000	1
40	1097	23	1772	4	Q2	2012	1.9800	0.6138	2.0000	1
40	1187	13	0	1	Q1	2012	2.9700	1.1583	3.0000	1
40	1289	23	0	9	Q3	2012	3.9600	1.9008	4.0000	1
40	1497	17	0	5	Q2	2012	3.9600	1.2276	4.0000	1
40	1793	13	0	5	Q2	2012	1.9800	0.9306	2.0000	1
40	1897	13	0	12	Q4	2012	2.9700	1.0692	3.0000	1
40	2046	7	0	8	Q3	2012	3.9600	1.9800	4.0000	1
40	2204	3	0	6	Q2	2012	1.9800	0.8910	2.0000	1
40	2570	16	0	7	Q3	2012	3.9600	1.7028	4.0000	1
40	2625	13	0	2	Q1	2012	1.9800	0.7128	2.0000	1
40	3426	11	829	6	Q2	2012	2.9700	1.0395	3.0000	1
40	3980	13	0	3	Q1	2012	3.9600	1.5048	4.0000	1
40	3980	13	0	9	Q3	2012	3.9600	1.5048	4.0000	1
40	4420	11	0	1	Q1	2012	2.9700	0.9801	3.0000	1
40	5052	14	0	5	Q2	2012	1.9800	0.5940	2.0000	1
40	5063	3	195	5	Q2	2012	3.9600	1.8216	4.0000	1
40	5302	11	833	8	Q3	2012	2.9700	0.9207	3.0000	1
40	5568	23	0	5	Q2	2012	2.9700	1.2177	3.0000	1
40	5882	11	826	5	Q2	2012	2.9700	1.0692	3.0000	1
40	5954	7	0	3	Q1	2012	2.9700	1.0692	3.0000	1
40	6105	23	0	5	Q2	2012	1.9800	0.7128	2.0000	1
40	6120	24	0	6	Q2	2012	1.9800	0.8712	2.0000	1
40	6324	23	1789	12	Q4	2012	3.9600	1.5048	4.0000	1
40	6531	13	0	9	Q3	2012	3.9600	1.8216	4.0000	1
40	6551	11	0	6	Q2	2012	4.9500	2.3760	5.0000	1
40	6570	11	0	1	Q1	2012	2.9700	0.9504	3.0000	1
40	6575	11	0	12	Q4	2012	3.9600	1.9008	4.0000	1
40	6718	6	0	10	Q4	2012	1.9800	0.6930	2.0000	1
40	6733	13	0	1	Q1	2012	2.9700	1.0395	3.0000	1
40	7072	16	1216	2	Q1	2012	3.9600	1.3068	4.0000	1
40	7757	7	504	2	Q1	2012	3.9600	1.8612	4.0000	1
40	7822	3	0	4	Q2	2012	2.9700	1.2177	3.0000	1
40	7940	13	984	5	Q2	2012	3.9600	1.8216	4.0000	1
40	8179	11	0	12	Q4	2012	2.9700	1.4256	3.0000	1
40	8298	13	0	1	Q1	2012	1.9800	0.9306	2.0000	1
40	8340	7	0	12	Q4	2012	1.9800	0.7524	2.0000	1
40	8746	23	1788	11	Q4	2012	1.9800	0.7524	2.0000	1
40	8768	11	0	6	Q2	2012	1.9800	0.9702	2.0000	1
40	8860	17	0	3	Q1	2012	4.9500	2.1285	5.0000	1
40	9040	16	1214	2	Q1	2012	3.9600	1.6236	4.0000	1
40	9257	7	516	8	Q3	2012	3.9600	1.6632	4.0000	1
40	9375	24	1858	7	Q3	2012	1.9800	0.6930	2.0000	1
40	9578	13	0	10	Q4	2012	3.9600	1.2672	4.0000	1
40	9703	24	0	5	Q2	2012	2.9700	1.1583	3.0000	1
40	9703	24	1869	12	Q4	2012	2.9700	1.1583	3.0000	1
40	9937	17	0	12	Q4	2012	2.9700	1.0989	3.0000	1
41	376	11	821	2	Q1	2012	3.5600	1.7088	4.0000	1
41	599	2	126	10	Q4	2012	1.7800	0.6586	2.0000	1
41	650	11	0	8	Q3	2012	1.7800	0.7298	2.0000	1
41	819	13	0	2	Q1	2012	3.5600	1.0680	4.0000	1
41	903	24	0	2	Q1	2012	3.5600	1.7444	4.0000	1
41	1173	13	0	1	Q1	2012	2.6700	1.2282	3.0000	1
41	1388	13	0	2	Q1	2012	2.6700	1.1214	3.0000	1
41	1451	3	0	7	Q3	2012	3.5600	1.6376	4.0000	1
41	1669	11	833	8	Q3	2012	1.7800	0.6230	2.0000	1
41	1727	24	0	4	Q2	2012	1.7800	0.6230	2.0000	1
41	1994	15	0	2	Q1	2012	1.7800	0.8010	2.0000	1
41	2068	6	0	10	Q4	2012	1.7800	0.6230	2.0000	1
41	2625	13	0	10	Q4	2012	1.7800	0.6408	2.0000	1
41	2734	7	504	2	Q1	2012	1.7800	0.7298	2.0000	1
41	2777	13	0	11	Q4	2012	3.5600	1.5664	4.0000	1
41	2968	13	0	1	Q1	2012	3.5600	1.6732	4.0000	1
41	3132	15	0	3	Q1	2012	2.6700	1.1214	3.0000	1
41	3173	11	0	4	Q2	2012	3.5600	1.3528	4.0000	1
41	3425	11	0	11	Q4	2012	2.6700	0.9345	3.0000	1
41	3463	13	0	2	Q1	2012	1.7800	0.6230	2.0000	1
41	3533	3	0	7	Q3	2012	2.6700	0.9879	3.0000	1
41	3580	7	504	2	Q1	2012	2.6700	0.9879	3.0000	1
41	3597	7	512	6	Q2	2012	2.6700	0.9078	3.0000	1
41	3599	13	0	7	Q3	2012	2.6700	1.2282	3.0000	1
41	3759	13	0	7	Q3	2012	2.6700	1.0947	3.0000	1
41	3921	23	0	2	Q1	2012	1.7800	0.5696	2.0000	1
41	4176	24	1856	6	Q2	2012	2.6700	0.9078	3.0000	1
41	4204	17	0	6	Q2	2012	2.6700	1.1214	3.0000	1
41	4420	11	0	10	Q4	2012	2.6700	1.2015	3.0000	1
41	4500	14	1070	8	Q3	2012	1.7800	0.7298	2.0000	1
41	4557	22	0	7	Q3	2012	1.7800	0.8722	2.0000	1
41	5526	15	0	3	Q1	2012	2.6700	0.8277	3.0000	1
41	5537	3	0	6	Q2	2012	2.6700	0.9879	3.0000	1
41	5572	24	0	10	Q4	2012	4.4500	2.0915	5.0000	1
41	5647	15	0	2	Q1	2012	2.6700	1.2816	3.0000	1
41	5827	11	0	4	Q2	2012	2.6700	1.3083	3.0000	1
41	5970	13	0	11	Q4	2012	1.7800	0.8188	2.0000	1
41	6113	16	0	5	Q2	2012	2.6700	0.9612	3.0000	1
41	6120	24	0	12	Q4	2012	1.7800	0.8010	2.0000	1
41	6153	16	0	5	Q2	2012	3.5600	1.4240	4.0000	1
41	6313	17	0	2	Q1	2012	1.7800	0.7654	2.0000	1
41	6403	2	0	9	Q3	2012	0.8900	0.4094	1.0000	1
41	6424	6	0	3	Q1	2012	3.5600	1.3172	4.0000	1
41	6479	2	0	11	Q4	2012	1.7800	0.8366	2.0000	1
41	6630	24	1860	8	Q3	2012	3.5600	1.4596	4.0000	1
41	6933	15	0	5	Q2	2012	2.6700	0.8544	3.0000	1
41	7914	24	0	5	Q2	2012	1.7800	0.6230	2.0000	1
41	7985	24	1859	8	Q3	2012	2.6700	1.0413	3.0000	1
41	8059	17	1294	2	Q1	2012	1.7800	0.7298	2.0000	1
41	8140	13	0	11	Q4	2012	1.7800	0.8010	2.0000	1
41	8659	13	0	1	Q1	2012	2.6700	1.3350	3.0000	1
41	8886	11	821	3	Q1	2012	1.7800	0.6764	2.0000	1
41	8923	24	0	4	Q2	2012	2.6700	0.8010	3.0000	1
41	8945	23	0	10	Q4	2012	3.5600	1.6732	4.0000	1
41	9129	15	0	8	Q3	2012	2.6700	1.0680	3.0000	1
41	9162	13	0	1	Q1	2012	1.7800	0.6408	2.0000	1
41	9200	16	0	7	Q3	2012	2.6700	1.0947	3.0000	1
41	9313	6	0	2	Q1	2012	4.4500	2.0915	5.0000	1
41	10238	16	0	12	Q4	2012	2.6700	1.2816	3.0000	1
42	360	24	0	11	Q4	2012	8.4600	4.1454	3.0000	1
42	591	11	0	10	Q4	2012	11.2800	3.6096	4.0000	1
42	967	6	0	9	Q3	2012	8.4600	2.9610	3.0000	1
42	967	7	0	5	Q2	2012	5.6400	1.9740	2.0000	1
42	975	7	504	2	Q1	2012	8.4600	3.2994	3.0000	1
42	1074	13	0	5	Q2	2012	8.4600	2.8764	3.0000	1
42	1132	11	0	9	Q3	2012	8.4600	3.8916	3.0000	1
42	1159	11	829	6	Q2	2012	5.6400	2.2560	2.0000	1
42	1529	13	0	2	Q1	2012	8.4600	4.0608	3.0000	1
42	1794	13	0	3	Q1	2012	5.6400	2.6508	2.0000	1
42	2084	17	0	7	Q3	2012	5.6400	2.1432	2.0000	1
42	2483	24	0	1	Q1	2012	11.2800	3.9480	4.0000	1
42	2688	7	0	3	Q1	2012	11.2800	5.4144	4.0000	1
42	2690	3	0	2	Q1	2012	8.4600	2.8764	3.0000	1
42	2723	3	0	3	Q1	2012	8.4600	4.1454	3.0000	1
42	2818	6	526	12	Q4	2012	8.4600	3.5532	3.0000	1
42	2850	3	188	2	Q1	2012	5.6400	2.1432	2.0000	1
42	2863	17	0	6	Q2	2012	8.4600	3.8070	3.0000	1
42	2918	17	0	9	Q3	2012	11.2800	4.2864	4.0000	1
42	3158	15	1140	4	Q2	2012	5.6400	2.3688	2.0000	1
42	3321	24	1850	3	Q1	2012	8.4600	3.1302	3.0000	1
42	3463	13	0	3	Q1	2012	5.6400	2.0868	2.0000	1
42	3516	7	0	3	Q1	2012	11.2800	4.9632	4.0000	1
42	3572	11	0	9	Q3	2012	5.6400	2.3124	2.0000	1
42	3640	24	0	10	Q4	2012	14.1000	6.0630	5.0000	1
42	3758	24	1853	5	Q2	2012	8.4600	3.8916	3.0000	1
42	3803	24	0	8	Q3	2012	11.2800	4.0608	4.0000	1
42	4185	24	0	11	Q4	2012	8.4600	3.4686	3.0000	1
42	4397	16	0	2	Q1	2012	5.6400	2.5944	2.0000	1
42	4553	15	1138	3	Q1	2012	11.2800	4.7376	4.0000	1
42	4564	17	1307	8	Q3	2012	8.4600	3.2148	3.0000	1
42	4695	13	0	8	Q3	2012	8.4600	2.9610	3.0000	1
42	4707	11	833	8	Q3	2012	8.4600	4.1454	3.0000	1
42	4767	16	1225	7	Q3	2012	11.2800	4.3992	4.0000	1
42	4772	2	0	2	Q1	2012	5.6400	2.2560	2.0000	1
42	5026	17	0	9	Q3	2012	16.9200	6.0348	6.0000	2
42	5280	7	0	9	Q3	2012	5.6400	1.7484	2.0000	1
42	5649	2	0	2	Q1	2012	5.6400	2.5944	2.0000	1
42	5731	6	0	12	Q4	2012	5.6400	2.0304	2.0000	1
42	5742	16	0	6	Q2	2012	8.4600	4.1454	3.0000	1
42	6019	6	0	6	Q2	2012	8.4600	3.7224	3.0000	1
42	6056	15	0	5	Q2	2012	11.2800	4.0608	4.0000	1
42	6113	16	1233	10	Q4	2012	8.4600	3.0456	3.0000	1
42	6138	17	0	8	Q3	2012	11.2800	4.0608	4.0000	1
42	6153	16	1216	2	Q1	2012	8.4600	3.7224	3.0000	1
42	6328	15	1146	7	Q3	2012	11.2800	4.5120	4.0000	1
42	6360	24	1859	8	Q3	2012	11.2800	3.6096	4.0000	1
42	6392	7	0	5	Q2	2012	8.4600	4.0608	3.0000	1
42	6551	11	0	2	Q1	2012	11.2800	4.8504	4.0000	1
42	7262	13	0	2	Q1	2012	8.4600	3.9762	3.0000	1
42	7361	11	841	12	Q4	2012	8.4600	3.4686	3.0000	1
42	7481	6	0	7	Q3	2012	11.2800	4.7376	4.0000	1
42	7704	3	0	8	Q3	2012	8.4600	2.6226	3.0000	1
42	7878	15	0	12	Q4	2012	8.4600	3.9762	3.0000	1
42	8003	3	0	3	Q1	2012	11.2800	5.5272	4.0000	1
42	8351	16	0	12	Q4	2012	8.4600	3.6378	3.0000	1
42	8384	15	0	4	Q2	2012	5.6400	2.3124	2.0000	1
42	9169	23	0	12	Q4	2012	11.2800	4.3992	4.0000	1
42	9299	24	0	6	Q2	2012	8.4600	3.8070	3.0000	1
42	9488	24	0	8	Q3	2012	5.6400	2.0304	2.0000	1
42	9512	23	0	7	Q3	2012	11.2800	5.6400	4.0000	1
42	9787	13	980	3	Q1	2012	11.2800	5.4144	4.0000	1
42	9871	13	988	7	Q3	2012	5.6400	2.7072	2.0000	1
42	10079	24	0	5	Q2	2012	8.4600	3.2148	3.0000	1
43	352	11	0	4	Q2	2012	6.6800	2.8056	4.0000	1
43	501	24	0	7	Q3	2012	6.6800	2.9392	4.0000	1
43	780	13	0	7	Q3	2012	8.3500	2.8390	5.0000	1
43	901	13	0	4	Q2	2012	6.6800	2.0040	4.0000	1
43	1005	3	204	9	Q3	2012	3.3400	1.6032	2.0000	1
43	1057	2	124	9	Q3	2012	3.3400	1.5364	2.0000	1
43	1193	13	0	6	Q2	2012	5.0100	2.0541	3.0000	1
43	1216	17	0	1	Q1	2012	3.3400	1.5698	2.0000	1
43	1252	24	1853	5	Q2	2012	3.3400	1.4696	2.0000	1
43	1266	13	0	7	Q3	2012	5.0100	2.4048	3.0000	1
43	1310	16	0	5	Q2	2012	5.0100	1.8036	3.0000	1
43	1352	17	0	1	Q1	2012	6.6800	2.6720	4.0000	1
43	1576	7	0	12	Q4	2012	6.6800	2.8724	4.0000	1
43	1676	3	207	11	Q4	2012	3.3400	1.4362	2.0000	1
43	1954	13	0	7	Q3	2012	8.3500	2.5050	5.0000	1
43	1991	13	0	10	Q4	2012	6.6800	3.0060	4.0000	1
43	2019	16	1225	7	Q3	2012	6.6800	2.4716	4.0000	1
43	2171	23	0	4	Q2	2012	3.3400	1.6366	2.0000	1
43	2272	17	1314	11	Q4	2012	5.0100	1.8036	3.0000	1
43	2295	17	0	4	Q2	2012	6.6800	2.1376	4.0000	1
43	2570	16	0	12	Q4	2012	6.6800	3.2732	4.0000	1
43	3097	6	0	1	Q1	2012	6.6800	2.1376	4.0000	1
43	3490	13	980	3	Q1	2012	5.0100	2.5050	3.0000	1
43	3567	16	0	3	Q1	2012	3.3400	1.5030	2.0000	1
43	3819	23	0	8	Q3	2012	6.6800	2.0708	4.0000	1
43	4021	16	0	9	Q3	2012	5.0100	1.5531	3.0000	1
43	4204	17	1312	10	Q4	2012	5.0100	2.1543	3.0000	1
43	4232	6	515	7	Q3	2012	3.3400	1.3026	2.0000	1
43	4257	3	0	10	Q4	2012	5.0100	1.7034	3.0000	1
43	4564	17	0	10	Q4	2012	5.0100	2.4048	3.0000	1
43	4695	13	980	3	Q1	2012	5.0100	2.5050	3.0000	1
43	4727	16	1225	7	Q3	2012	8.3500	3.9245	5.0000	1
43	4938	13	0	4	Q2	2012	8.3500	2.7555	5.0000	1
43	5346	3	0	4	Q2	2012	5.0100	2.3046	3.0000	1
43	5473	24	1845	1	Q1	2012	5.0100	2.1543	3.0000	1
43	5612	15	0	4	Q2	2012	3.3400	1.4696	2.0000	1
43	5765	7	0	6	Q2	2012	3.3400	1.3360	2.0000	1
43	5839	7	0	3	Q1	2012	5.0100	1.7034	3.0000	1
43	5972	15	0	7	Q3	2012	5.0100	2.3547	3.0000	1
43	6161	17	0	3	Q1	2012	6.6800	2.4716	4.0000	1
43	6307	16	1220	4	Q2	2012	5.0100	2.2545	3.0000	1
43	6690	17	0	8	Q3	2012	3.3400	1.0020	2.0000	1
43	6712	16	0	4	Q2	2012	6.6800	2.0708	4.0000	1
43	6832	3	207	11	Q4	2012	5.0100	1.8036	3.0000	1
43	6912	16	0	1	Q1	2012	6.6800	2.6720	4.0000	1
43	7003	15	1154	10	Q4	2012	6.6800	2.9392	4.0000	1
43	7027	15	0	9	Q3	2012	5.0100	2.3046	3.0000	1
43	7149	13	0	7	Q3	2012	6.6800	2.2712	4.0000	1
43	7246	7	0	8	Q3	2012	5.0100	2.4549	3.0000	1
43	7490	24	1853	5	Q2	2012	5.0100	2.3547	3.0000	1
43	7583	6	0	3	Q1	2012	5.0100	2.0541	3.0000	1
43	7849	3	0	7	Q3	2012	3.3400	1.6366	2.0000	1
43	8034	24	0	9	Q3	2012	6.6800	2.9392	4.0000	1
43	8289	17	1303	6	Q2	2012	3.3400	1.2024	2.0000	1
43	8301	24	0	2	Q1	2012	5.0100	2.1543	3.0000	1
43	8370	11	0	2	Q1	2012	6.6800	2.0040	4.0000	1
43	8502	14	0	7	Q3	2012	1.6700	0.5678	1.0000	1
43	9062	11	0	7	Q3	2012	3.3400	1.0354	2.0000	1
43	9064	17	0	11	Q4	2012	5.0100	1.5531	3.0000	1
43	9364	15	1141	4	Q2	2012	3.3400	1.1022	2.0000	1
43	9501	13	0	2	Q1	2012	5.0100	2.2044	3.0000	1
43	9704	24	0	8	Q3	2012	5.0100	2.4549	3.0000	1
43	9748	24	0	3	Q1	2012	3.3400	1.4028	2.0000	1
43	9781	3	207	11	Q4	2012	3.3400	1.0354	2.0000	1
43	9992	24	0	2	Q1	2012	6.6800	2.9392	4.0000	1
43	10043	22	0	12	Q4	2012	1.6700	0.5678	1.0000	1
43	10110	24	0	7	Q3	2012	3.3400	1.5030	2.0000	1
44	780	13	0	1	Q1	2012	14.6500	4.9810	5.0000	1
44	873	24	0	2	Q1	2012	8.7900	3.6918	3.0000	1
44	873	24	0	12	Q4	2012	14.6500	7.0320	5.0000	1
44	874	6	508	4	Q2	2012	5.8600	2.5198	2.0000	1
44	976	16	1220	4	Q2	2012	8.7900	4.1313	3.0000	1
44	976	16	1223	6	Q2	2012	11.7200	4.9224	4.0000	1
44	1094	15	0	4	Q2	2012	5.8600	1.9924	2.0000	1
44	1607	17	1304	7	Q3	2012	5.8600	2.9300	2.0000	1
44	1979	3	0	7	Q3	2012	14.6500	5.1275	5.0000	1
44	2547	23	0	11	Q4	2012	11.7200	4.4536	4.0000	1
44	2581	7	0	3	Q1	2012	11.7200	3.8676	4.0000	1
44	2699	24	1859	8	Q3	2012	5.8600	2.0510	2.0000	1
44	3287	14	0	4	Q2	2012	8.7900	4.3950	3.0000	1
44	3476	3	0	5	Q2	2012	8.7900	3.4281	3.0000	1
44	3655	7	0	6	Q2	2012	11.7200	4.1020	4.0000	1
44	3826	16	1225	7	Q3	2012	8.7900	4.0434	3.0000	1
44	3886	15	1150	8	Q3	2012	8.7900	2.7249	3.0000	1
44	4065	3	0	9	Q3	2012	8.7900	4.3071	3.0000	1
44	4100	7	0	4	Q2	2012	11.7200	5.6256	4.0000	1
44	4191	6	0	10	Q4	2012	8.7900	3.9555	3.0000	1
44	4215	15	0	9	Q3	2012	8.7900	3.6918	3.0000	1
44	4497	17	0	5	Q2	2012	11.7200	5.6256	4.0000	1
44	4547	13	0	1	Q1	2012	5.8600	2.8128	2.0000	1
44	4695	13	0	7	Q3	2012	11.7200	4.3364	4.0000	1
44	4767	16	0	7	Q3	2012	11.7200	4.6880	4.0000	1
44	4778	3	197	6	Q2	2012	5.8600	2.4026	2.0000	1
44	4900	13	0	11	Q4	2012	11.7200	3.7504	4.0000	1
44	5249	6	0	5	Q2	2012	11.7200	4.2192	4.0000	1
44	5331	24	1866	11	Q4	2012	8.7900	2.9886	3.0000	1
44	5379	17	0	10	Q4	2012	8.7900	4.0434	3.0000	1
44	5790	17	0	7	Q3	2012	11.7200	4.8052	4.0000	1
44	5814	15	1140	4	Q2	2012	11.7200	4.6880	4.0000	1
44	6024	6	0	4	Q2	2012	8.7900	3.7797	3.0000	1
44	6153	16	0	11	Q4	2012	11.7200	5.1568	4.0000	1
44	6207	7	517	8	Q3	2012	8.7900	4.3071	3.0000	1
44	6420	14	1070	8	Q3	2012	2.9300	1.2306	1.0000	1
44	6912	16	0	12	Q4	2012	14.6500	4.9810	5.0000	1
44	6957	16	0	11	Q4	2012	11.7200	5.3912	4.0000	1
44	7130	24	0	1	Q1	2012	5.8600	2.6370	2.0000	1
44	7189	13	0	5	Q2	2012	8.7900	3.9555	3.0000	1
44	7291	11	0	12	Q4	2012	11.7200	3.8676	4.0000	1
44	7822	3	0	4	Q2	2012	11.7200	3.5160	4.0000	1
44	7822	3	205	10	Q4	2012	5.8600	2.7542	2.0000	1
44	7831	17	0	1	Q1	2012	11.7200	4.2192	4.0000	1
44	8142	6	0	4	Q2	2012	8.7900	3.1644	3.0000	1
44	8164	13	0	5	Q2	2012	11.7200	3.6332	4.0000	1
44	8252	13	0	9	Q3	2012	11.7200	5.1568	4.0000	1
44	8311	23	0	11	Q4	2012	11.7200	3.7504	4.0000	1
44	8411	15	0	10	Q4	2012	11.7200	5.0396	4.0000	1
44	8574	15	0	6	Q2	2012	11.7200	5.7428	4.0000	1
44	8779	13	0	10	Q4	2012	11.7200	5.0396	4.0000	1
44	9200	16	0	7	Q3	2012	8.7900	3.6918	3.0000	1
44	9469	17	0	6	Q2	2012	11.7200	5.3912	4.0000	1
44	9481	24	0	8	Q3	2012	5.8600	2.0510	2.0000	1
44	9851	3	188	2	Q1	2012	11.7200	3.5160	4.0000	1
44	9967	23	0	11	Q4	2012	11.7200	4.5708	4.0000	1
44	9975	24	0	12	Q4	2012	11.7200	4.9224	4.0000	1
44	10020	11	837	10	Q4	2012	14.6500	7.1785	5.0000	1
45	115	7	512	6	Q2	2012	1.5900	0.7632	3.0000	1
45	192	16	0	12	Q4	2012	1.5900	0.7632	3.0000	1
45	505	7	523	11	Q4	2012	1.5900	0.7473	3.0000	1
45	976	16	0	1	Q1	2012	1.5900	0.5724	3.0000	1
45	1099	15	0	9	Q3	2012	1.5900	0.7155	3.0000	1
45	1187	13	0	3	Q1	2012	1.5900	0.5724	3.0000	1
45	1334	17	1311	10	Q4	2012	1.0600	0.4982	2.0000	1
45	1548	13	0	1	Q1	2012	2.1200	0.9328	4.0000	1
45	1690	16	0	11	Q4	2012	2.1200	0.9116	4.0000	1
45	1723	7	0	11	Q4	2012	1.5900	0.7632	3.0000	1
45	2244	17	0	1	Q1	2012	1.5900	0.6837	3.0000	1
45	2272	17	0	12	Q4	2012	2.1200	1.0176	4.0000	1
45	2371	16	0	1	Q1	2012	1.5900	0.7632	3.0000	1
45	2525	13	0	2	Q1	2012	1.5900	0.7632	3.0000	1
45	2735	24	0	10	Q4	2012	2.6500	0.9805	5.0000	1
45	3130	13	0	2	Q1	2012	1.5900	0.7155	3.0000	1
45	3231	17	0	3	Q1	2012	2.6500	1.1660	5.0000	1
45	3271	13	0	12	Q4	2012	1.5900	0.7314	3.0000	1
45	3497	17	0	9	Q3	2012	2.1200	1.0176	4.0000	1
45	3627	3	207	11	Q4	2012	1.0600	0.3710	2.0000	1
45	3632	7	523	11	Q4	2012	2.1200	0.8268	4.0000	1
45	3649	11	0	7	Q3	2012	1.5900	0.7632	3.0000	1
45	3922	7	523	11	Q4	2012	1.5900	0.6678	3.0000	1
45	3925	11	837	10	Q4	2012	1.0600	0.4028	2.0000	1
45	4436	3	0	10	Q4	2012	1.5900	0.7632	3.0000	1
45	4557	22	1711	12	Q4	2012	0.5300	0.2067	1.0000	1
45	4629	13	984	5	Q2	2012	1.5900	0.5883	3.0000	1
45	4670	17	1292	1	Q1	2012	1.5900	0.4770	3.0000	1
45	4950	7	504	2	Q1	2012	1.5900	0.5406	3.0000	1
45	5185	24	0	9	Q3	2012	2.1200	0.7420	4.0000	1
45	5230	13	0	3	Q1	2012	2.1200	0.8480	4.0000	1
45	5685	13	0	4	Q2	2012	1.5900	0.7632	3.0000	1
45	5742	16	0	11	Q4	2012	1.5900	0.6042	3.0000	1
45	5790	17	0	5	Q2	2012	2.1200	0.9328	4.0000	1
45	5799	15	0	6	Q2	2012	1.0600	0.4240	2.0000	1
45	5867	11	0	9	Q3	2012	1.5900	0.7791	3.0000	1
45	6164	24	0	5	Q2	2012	1.5900	0.6519	3.0000	1
45	6168	17	0	5	Q2	2012	1.5900	0.6996	3.0000	1
45	6367	3	0	1	Q1	2012	1.0600	0.4452	2.0000	1
45	6544	13	0	6	Q2	2012	1.5900	0.5406	3.0000	1
45	6703	11	0	5	Q2	2012	1.5900	0.7314	3.0000	1
45	6899	7	519	9	Q3	2012	2.1200	0.6572	4.0000	1
45	7502	16	0	3	Q1	2012	1.5900	0.4770	3.0000	1
45	7502	16	1235	11	Q4	2012	2.1200	1.0388	4.0000	1
45	8300	15	0	2	Q1	2012	1.5900	0.7791	3.0000	1
45	8336	17	1314	11	Q4	2012	2.1200	0.6572	4.0000	1
45	8445	6	0	9	Q3	2012	1.5900	0.5724	3.0000	1
45	8570	11	0	10	Q4	2012	1.5900	0.4770	3.0000	1
45	8947	3	0	4	Q2	2012	1.5900	0.6837	3.0000	1
45	8947	3	0	6	Q2	2012	1.0600	0.5088	2.0000	1
45	9125	13	992	9	Q3	2012	1.0600	0.4876	2.0000	1
45	9230	15	1140	4	Q2	2012	2.1200	0.9964	4.0000	1
45	9433	24	1851	4	Q2	2012	1.5900	0.5724	3.0000	1
45	9697	23	1783	9	Q3	2012	1.5900	0.7473	3.0000	1
45	9891	23	0	10	Q4	2012	2.1200	0.9540	4.0000	1
46	899	14	1077	11	Q4	2012	6.8800	3.3712	2.0000	1
46	1133	6	523	11	Q4	2012	10.3200	4.2312	3.0000	1
46	1271	13	0	1	Q1	2012	10.3200	3.7152	3.0000	1
46	1271	13	0	4	Q2	2012	10.3200	4.9536	3.0000	1
46	1634	3	0	8	Q3	2012	13.7600	4.5408	4.0000	1
46	1682	13	0	3	Q1	2012	6.8800	2.6144	2.0000	1
46	1714	6	508	4	Q2	2012	10.3200	4.6440	3.0000	1
46	2158	11	841	12	Q4	2012	10.3200	3.3024	3.0000	1
46	2378	16	0	3	Q1	2012	10.3200	4.7472	3.0000	1
46	2417	14	0	3	Q1	2012	6.8800	2.6832	2.0000	1
46	2570	16	0	5	Q2	2012	13.7600	4.5408	4.0000	1
46	2610	7	0	6	Q2	2012	13.7600	4.6784	4.0000	1
46	3098	15	1149	8	Q3	2012	10.3200	4.0248	3.0000	1
46	3258	7	518	8	Q3	2012	10.3200	4.6440	3.0000	1
46	3748	13	0	3	Q1	2012	13.7600	6.7424	4.0000	1
46	3942	15	0	5	Q2	2012	10.3200	3.8184	3.0000	1
46	4175	16	1214	2	Q1	2012	6.8800	2.8896	2.0000	1
46	4490	13	980	3	Q1	2012	10.3200	4.4376	3.0000	1
46	4676	16	1233	10	Q4	2012	10.3200	4.7472	3.0000	1
46	5345	6	0	9	Q3	2012	10.3200	3.8184	3.0000	1
46	5537	3	195	5	Q2	2012	13.7600	5.0912	4.0000	1
46	5545	15	0	3	Q1	2012	10.3200	3.9216	3.0000	1
46	5635	7	0	4	Q2	2012	10.3200	3.7152	3.0000	1
46	5742	16	0	2	Q1	2012	10.3200	3.9216	3.0000	1
46	5931	24	0	6	Q2	2012	13.7600	5.2288	4.0000	1
46	6113	16	1233	10	Q4	2012	6.8800	2.2016	2.0000	1
46	6307	16	0	8	Q3	2012	13.7600	6.7424	4.0000	1
46	6347	17	0	7	Q3	2012	10.3200	4.0248	3.0000	1
46	6766	24	0	11	Q4	2012	6.8800	3.3712	2.0000	1
46	7139	7	0	10	Q4	2012	17.2000	8.2560	5.0000	1
46	7153	3	0	3	Q1	2012	10.3200	4.0248	3.0000	1
46	7196	6	0	1	Q1	2012	6.8800	2.4080	2.0000	1
46	7287	24	0	10	Q4	2012	6.8800	2.2016	2.0000	1
46	7293	22	1702	8	Q3	2012	6.8800	3.3712	2.0000	1
46	7298	11	0	7	Q3	2012	10.3200	3.8184	3.0000	1
46	7514	17	0	11	Q4	2012	10.3200	3.4056	3.0000	1
46	7538	6	504	2	Q1	2012	13.7600	4.8160	4.0000	1
46	7573	3	0	12	Q4	2012	13.7600	6.3296	4.0000	1
46	7607	17	0	5	Q2	2012	13.7600	5.2288	4.0000	1
46	7849	3	0	1	Q1	2012	10.3200	4.8504	3.0000	1
46	8038	24	0	5	Q2	2012	10.3200	4.5408	3.0000	1
46	8367	13	0	3	Q1	2012	17.2000	5.5040	5.0000	1
46	8382	15	0	10	Q4	2012	10.3200	3.5088	3.0000	1
46	8411	15	0	9	Q3	2012	10.3200	5.0568	3.0000	1
46	8891	11	0	7	Q3	2012	10.3200	3.7152	3.0000	1
46	9184	3	0	5	Q2	2012	10.3200	3.0960	3.0000	1
46	9213	11	0	12	Q4	2012	10.3200	3.8184	3.0000	1
46	9318	16	0	1	Q1	2012	6.8800	2.8208	2.0000	1
46	9499	6	0	3	Q1	2012	10.3200	4.0248	3.0000	1
46	9639	17	0	3	Q1	2012	10.3200	4.2312	3.0000	1
46	9668	13	0	12	Q4	2012	10.3200	4.0248	3.0000	1
46	9747	13	0	7	Q3	2012	6.8800	3.2336	2.0000	1
46	10033	3	0	8	Q3	2012	13.7600	5.6416	4.0000	1
46	10070	13	0	1	Q1	2012	6.8800	2.4768	2.0000	1
46	10098	6	510	5	Q2	2012	10.3200	5.0568	3.0000	1
46	10167	17	0	12	Q4	2012	10.3200	4.6440	3.0000	1
46	10259	6	515	7	Q3	2012	10.3200	4.6440	3.0000	1
47	711	17	0	9	Q3	2012	5.1400	2.3130	2.0000	1
47	763	7	0	6	Q2	2012	7.7100	3.7008	3.0000	1
47	886	15	0	6	Q2	2012	10.2800	3.4952	4.0000	1
47	1107	22	0	12	Q4	2012	2.5700	1.1822	1.0000	1
47	1185	17	0	12	Q4	2012	10.2800	3.5980	4.0000	1
47	1271	13	0	3	Q1	2012	10.2800	3.9064	4.0000	1
47	1917	23	1778	7	Q3	2012	10.2800	4.9344	4.0000	1
47	2084	17	1293	1	Q1	2012	5.1400	2.3644	2.0000	1
47	2134	11	0	12	Q4	2012	10.2800	4.7288	4.0000	1
47	2290	7	0	12	Q4	2012	5.1400	2.5186	2.0000	1
47	2769	16	1235	11	Q4	2012	5.1400	2.1074	2.0000	1
47	2905	3	0	5	Q2	2012	7.7100	3.7008	3.0000	1
47	3302	13	0	6	Q2	2012	5.1400	2.0046	2.0000	1
47	3328	17	0	3	Q1	2012	5.1400	2.5186	2.0000	1
47	3490	13	0	1	Q1	2012	7.7100	2.7756	3.0000	1
47	3497	17	0	2	Q1	2012	10.2800	4.5232	4.0000	1
47	3532	7	0	11	Q4	2012	12.8500	6.0395	5.0000	1
47	3635	15	0	8	Q3	2012	10.2800	3.3924	4.0000	1
47	4234	3	207	11	Q4	2012	10.2800	3.9064	4.0000	1
47	4397	16	0	3	Q1	2012	10.2800	4.8316	4.0000	1
47	4468	11	0	11	Q4	2012	10.2800	3.7008	4.0000	1
47	4490	13	0	7	Q3	2012	7.7100	3.3153	3.0000	1
47	4541	3	0	11	Q4	2012	7.7100	3.7008	3.0000	1
47	4858	17	0	8	Q3	2012	7.7100	2.3130	3.0000	1
47	5047	11	0	3	Q1	2012	7.7100	3.0069	3.0000	1
47	5147	13	0	8	Q3	2012	10.2800	4.4204	4.0000	1
47	5297	7	505	2	Q1	2012	7.7100	2.5443	3.0000	1
47	5449	15	0	7	Q3	2012	5.1400	2.3130	2.0000	1
47	5630	6	521	10	Q4	2012	7.7100	2.3130	3.0000	1
47	5895	17	0	12	Q4	2012	7.7100	3.6237	3.0000	1
47	5972	15	0	6	Q2	2012	10.2800	3.5980	4.0000	1
47	5972	15	0	7	Q3	2012	7.7100	3.5466	3.0000	1
47	6114	16	0	9	Q3	2012	10.2800	5.1400	4.0000	1
47	6248	24	1860	8	Q3	2012	5.1400	1.6448	2.0000	1
47	6301	15	0	8	Q3	2012	10.2800	3.7008	4.0000	1
47	6351	11	824	4	Q2	2012	5.1400	2.5700	2.0000	1
47	6471	15	0	10	Q4	2012	7.7100	3.4695	3.0000	1
47	6598	11	0	4	Q2	2012	10.2800	4.7288	4.0000	1
47	6996	24	0	2	Q1	2012	10.2800	3.4952	4.0000	1
47	7810	3	0	11	Q4	2012	10.2800	4.8316	4.0000	1
47	7849	3	201	8	Q3	2012	7.7100	2.6985	3.0000	1
47	8140	13	980	3	Q1	2012	5.1400	2.2102	2.0000	1
47	8404	3	0	2	Q1	2012	5.1400	2.5186	2.0000	1
47	8594	7	504	2	Q1	2012	5.1400	2.5186	2.0000	1
47	8606	15	1134	1	Q1	2012	5.1400	2.2616	2.0000	1
47	9112	7	519	9	Q3	2012	7.7100	2.3901	3.0000	1
47	9728	16	0	4	Q2	2012	10.2800	4.5232	4.0000	1
47	9772	7	0	7	Q3	2012	7.7100	2.6985	3.0000	1
47	10058	15	1140	4	Q2	2012	7.7100	3.3924	3.0000	1
47	10238	16	0	10	Q4	2012	7.7100	3.6237	3.0000	1
48	314	15	0	4	Q2	2012	5.6400	1.9176	3.0000	1
48	341	17	1314	11	Q4	2012	7.5200	3.6848	4.0000	1
48	692	11	820	2	Q1	2012	3.7600	1.6168	2.0000	1
48	924	3	188	2	Q1	2012	9.4000	3.1960	5.0000	1
48	997	3	0	4	Q2	2012	7.5200	3.6096	4.0000	1
48	1070	3	0	10	Q4	2012	5.6400	2.2560	3.0000	1
48	1429	13	0	1	Q1	2012	5.6400	2.2560	3.0000	1
48	1631	24	1851	4	Q2	2012	5.6400	1.9176	3.0000	1
48	2019	16	0	3	Q1	2012	7.5200	2.9328	4.0000	1
48	2102	6	0	12	Q4	2012	5.6400	1.7484	3.0000	1
48	2136	6	0	12	Q4	2012	5.6400	2.7636	3.0000	1
48	2200	6	0	1	Q1	2012	5.6400	2.0304	3.0000	1
48	2390	17	0	4	Q2	2012	7.5200	2.4064	4.0000	1
48	2466	24	0	7	Q3	2012	9.4000	4.6060	5.0000	1
48	2594	17	0	10	Q4	2012	5.6400	2.5944	3.0000	1
48	2664	17	0	10	Q4	2012	3.7600	1.3912	2.0000	1
48	2878	3	0	4	Q2	2012	9.4000	4.3240	5.0000	1
48	2929	24	0	6	Q2	2012	5.6400	1.8048	3.0000	1
48	3462	6	508	4	Q2	2012	5.6400	2.2560	3.0000	1
48	3814	7	504	2	Q1	2012	5.6400	2.4252	3.0000	1
48	4021	16	0	3	Q1	2012	5.6400	2.0868	3.0000	1
48	4069	17	0	2	Q1	2012	7.5200	3.7600	4.0000	1
48	4498	17	0	9	Q3	2012	3.7600	1.4664	2.0000	1
48	4544	7	501	1	Q1	2012	7.5200	3.3088	4.0000	1
48	4678	13	976	1	Q1	2012	7.5200	3.3840	4.0000	1
48	4682	15	1134	1	Q1	2012	7.5200	3.3840	4.0000	1
48	4693	3	0	8	Q3	2012	7.5200	2.7072	4.0000	1
48	4767	16	1220	4	Q2	2012	7.5200	2.3312	4.0000	1
48	4868	16	1225	7	Q3	2012	7.5200	2.9328	4.0000	1
48	4876	15	1140	4	Q2	2012	7.5200	2.4064	4.0000	1
48	5249	6	0	5	Q2	2012	7.5200	2.8576	4.0000	1
48	5396	11	0	1	Q1	2012	7.5200	3.4592	4.0000	1
48	5419	17	1312	10	Q4	2012	5.6400	2.7636	3.0000	1
48	5731	6	0	9	Q3	2012	7.5200	3.0080	4.0000	1
48	5765	6	0	5	Q2	2012	7.5200	3.3088	4.0000	1
48	5895	17	1293	1	Q1	2012	7.5200	2.7072	4.0000	1
48	5922	15	0	7	Q3	2012	7.5200	2.8576	4.0000	1
48	6880	15	1138	3	Q1	2012	3.7600	1.2784	2.0000	1
48	6933	15	0	5	Q2	2012	5.6400	2.0304	3.0000	1
48	6978	24	0	10	Q4	2012	7.5200	3.2336	4.0000	1
48	7095	24	0	4	Q2	2012	3.7600	1.8424	2.0000	1
48	7203	13	0	9	Q3	2012	3.7600	1.6544	2.0000	1
48	7207	13	980	3	Q1	2012	7.5200	3.3088	4.0000	1
48	7281	17	0	11	Q4	2012	3.7600	1.1280	2.0000	1
48	7365	13	0	11	Q4	2012	7.5200	3.3840	4.0000	1
48	7461	14	0	7	Q3	2012	3.7600	1.2784	2.0000	1
48	7619	7	0	12	Q4	2012	3.7600	1.6920	2.0000	1
48	7772	15	0	1	Q1	2012	3.7600	1.3160	2.0000	1
48	7871	7	505	2	Q1	2012	5.6400	2.3688	3.0000	1
48	7963	11	0	11	Q4	2012	5.6400	2.1996	3.0000	1
48	8272	6	523	11	Q4	2012	5.6400	2.7636	3.0000	1
48	8291	13	0	1	Q1	2012	3.7600	1.6920	2.0000	1
48	8367	13	0	2	Q1	2012	5.6400	2.8200	3.0000	1
48	8427	16	1233	10	Q4	2012	5.6400	1.6920	3.0000	1
48	8600	6	0	10	Q4	2012	3.7600	1.1280	2.0000	1
48	8916	11	842	12	Q4	2012	7.5200	2.6320	4.0000	1
48	9057	24	1846	2	Q1	2012	5.6400	2.0868	3.0000	1
48	9488	24	0	9	Q3	2012	7.5200	2.4064	4.0000	1
48	9497	15	0	5	Q2	2012	3.7600	1.2784	2.0000	1
48	9858	24	1856	6	Q2	2012	7.5200	3.3840	4.0000	1
48	10070	13	0	9	Q3	2012	3.7600	1.3912	2.0000	1
48	10100	15	1157	12	Q4	2012	7.5200	3.6848	4.0000	1
48	10248	15	0	11	Q4	2012	5.6400	2.0304	3.0000	1
49	391	6	523	11	Q4	2012	6.7600	2.5012	2.0000	1
49	548	7	0	8	Q3	2012	6.7600	2.2984	2.0000	1
49	760	3	0	12	Q4	2012	10.1400	3.1434	3.0000	1
49	955	6	524	11	Q4	2012	13.5200	6.0840	4.0000	1
49	997	3	0	11	Q4	2012	10.1400	4.7658	3.0000	1
49	1197	23	0	11	Q4	2012	13.5200	4.8672	4.0000	1
49	1267	13	0	7	Q3	2012	6.7600	3.1096	2.0000	1
49	1331	7	517	8	Q3	2012	13.5200	5.0024	4.0000	1
49	1466	15	0	2	Q1	2012	10.1400	3.8532	3.0000	1
49	1632	7	501	1	Q1	2012	6.7600	2.7040	2.0000	1
49	1922	15	0	10	Q4	2012	6.7600	3.3124	2.0000	1
49	3127	7	0	12	Q4	2012	6.7600	2.7716	2.0000	1
49	3239	17	0	4	Q2	2012	13.5200	6.3544	4.0000	1
49	3361	24	1869	12	Q4	2012	13.5200	5.6784	4.0000	1
49	3386	24	0	7	Q3	2012	13.5200	4.8672	4.0000	1
49	3426	11	0	2	Q1	2012	6.7600	3.1772	2.0000	1
49	3448	3	201	8	Q3	2012	13.5200	6.0840	4.0000	1
49	4234	3	0	6	Q2	2012	13.5200	5.1376	4.0000	1
49	4259	15	0	8	Q3	2012	10.1400	3.1434	3.0000	1
49	4351	23	0	7	Q3	2012	6.7600	2.9068	2.0000	1
49	4609	23	0	8	Q3	2012	16.9000	8.1120	5.0000	1
49	4819	7	523	11	Q4	2012	13.5200	5.9488	4.0000	1
49	5226	6	0	6	Q2	2012	10.1400	3.0420	3.0000	1
49	5799	15	0	6	Q2	2012	16.9000	7.6050	5.0000	1
49	5839	6	0	12	Q4	2012	10.1400	3.3462	3.0000	1
49	5970	13	0	5	Q2	2012	10.1400	3.6504	3.0000	1
49	6001	17	1314	11	Q4	2012	13.5200	6.0840	4.0000	1
49	6172	15	1142	5	Q2	2012	13.5200	5.1376	4.0000	1
49	6273	24	0	2	Q1	2012	13.5200	5.2728	4.0000	1
49	6381	24	0	5	Q2	2012	6.7600	2.7716	2.0000	1
49	7224	7	505	2	Q1	2012	13.5200	6.4896	4.0000	1
49	7611	7	0	5	Q2	2012	6.7600	2.4336	2.0000	1
49	7721	13	0	7	Q3	2012	10.1400	4.4616	3.0000	1
49	7808	6	0	1	Q1	2012	10.1400	4.9686	3.0000	1
49	7823	7	0	1	Q1	2012	13.5200	4.1912	4.0000	1
49	7828	11	0	12	Q4	2012	13.5200	4.1912	4.0000	1
49	8123	24	0	8	Q3	2012	10.1400	3.0420	3.0000	1
49	8172	17	0	5	Q2	2012	10.1400	3.2448	3.0000	1
49	8206	23	1773	4	Q2	2012	6.7600	2.9068	2.0000	1
49	8340	6	504	2	Q1	2012	10.1400	3.9546	3.0000	1
49	8942	6	0	10	Q4	2012	6.7600	2.9744	2.0000	1
49	9184	3	0	8	Q3	2012	13.5200	4.7320	4.0000	1
49	9353	15	0	5	Q2	2012	6.7600	3.2448	2.0000	1
49	9447	13	0	5	Q2	2012	10.1400	3.1434	3.0000	1
49	9494	7	504	2	Q1	2012	13.5200	6.4896	4.0000	1
49	9524	3	0	3	Q1	2012	13.5200	4.1912	4.0000	1
49	9881	3	0	11	Q4	2012	13.5200	5.2728	4.0000	1
49	9897	16	0	2	Q1	2012	6.7600	2.7716	2.0000	1
49	9943	7	0	12	Q4	2012	13.5200	5.8136	4.0000	1
49	10100	15	1138	3	Q1	2012	10.1400	3.0420	3.0000	1
50	346	13	0	5	Q2	2012	7.9000	3.3970	2.0000	1
50	461	11	821	3	Q1	2012	11.8500	4.1475	3.0000	1
50	467	13	0	5	Q2	2012	11.8500	3.9105	3.0000	1
50	501	24	0	5	Q2	2012	11.8500	5.8065	3.0000	1
50	776	24	1866	11	Q4	2012	15.8000	5.0560	4.0000	1
50	976	16	1214	2	Q1	2012	15.8000	6.6360	4.0000	1
50	1133	6	523	11	Q4	2012	15.8000	4.7400	4.0000	1
50	1297	16	0	11	Q4	2012	11.8500	4.2660	3.0000	1
50	1366	13	0	4	Q2	2012	11.8500	4.8585	3.0000	1
50	1388	13	0	6	Q2	2012	11.8500	4.6215	3.0000	1
50	1429	13	0	7	Q3	2012	11.8500	5.8065	3.0000	1
50	1524	13	0	1	Q1	2012	7.9000	2.6860	2.0000	1
50	2244	17	0	5	Q2	2012	15.8000	7.9000	4.0000	1
50	2251	13	0	2	Q1	2012	11.8500	4.0290	3.0000	1
50	2266	7	0	7	Q3	2012	11.8500	4.7400	3.0000	1
50	2648	24	0	12	Q4	2012	11.8500	5.0955	3.0000	1
50	2656	13	0	7	Q3	2012	7.9000	2.8440	2.0000	1
50	2689	3	0	4	Q2	2012	11.8500	4.2660	3.0000	1
50	2729	15	0	1	Q1	2012	15.8000	5.0560	4.0000	1
50	2854	2	126	10	Q4	2012	7.9000	2.9230	2.0000	1
50	3328	17	0	5	Q2	2012	7.9000	3.7130	2.0000	1
50	3334	17	0	12	Q4	2012	7.9000	3.8710	2.0000	1
50	3588	24	0	3	Q1	2012	11.8500	4.2660	3.0000	1
50	3719	23	0	10	Q4	2012	11.8500	4.5030	3.0000	1
50	3941	3	0	6	Q2	2012	15.8000	7.2680	4.0000	1
50	4021	16	0	8	Q3	2012	15.8000	7.2680	4.0000	1
50	4096	3	0	7	Q3	2012	11.8500	4.6215	3.0000	1
50	4282	15	1138	3	Q1	2012	7.9000	3.9500	2.0000	1
50	4615	17	0	7	Q3	2012	15.8000	5.5300	4.0000	1
50	4875	13	0	12	Q4	2012	11.8500	5.0955	3.0000	1
50	4938	13	0	12	Q4	2012	11.8500	4.7400	3.0000	1
50	4998	3	0	3	Q1	2012	7.9000	3.3970	2.0000	1
50	5542	16	1214	2	Q1	2012	7.9000	3.3970	2.0000	1
50	5566	6	526	12	Q4	2012	11.8500	5.9250	3.0000	1
50	5808	7	0	7	Q3	2012	15.8000	5.0560	4.0000	1
50	5944	3	0	12	Q4	2012	19.7500	5.9250	5.0000	1
50	6155	15	1146	7	Q3	2012	11.8500	5.8065	3.0000	1
50	6208	17	0	3	Q1	2012	11.8500	4.7400	3.0000	1
50	6299	7	0	7	Q3	2012	15.8000	6.3200	4.0000	1
50	6602	2	0	11	Q4	2012	11.8500	3.9105	3.0000	1
50	6846	15	0	8	Q3	2012	7.9000	2.6070	2.0000	1
50	7065	17	0	3	Q1	2012	11.8500	4.3845	3.0000	1
50	7275	17	1304	7	Q3	2012	11.8500	4.2660	3.0000	1
50	7362	11	826	5	Q2	2012	15.8000	5.0560	4.0000	1
50	7810	3	0	9	Q3	2012	11.8500	4.8585	3.0000	1
50	7942	24	1866	11	Q4	2012	7.9000	3.3970	2.0000	1
50	8164	13	0	2	Q1	2012	11.8500	4.0290	3.0000	1
50	8466	17	0	11	Q4	2012	11.8500	4.2660	3.0000	1
50	8499	24	1847	2	Q1	2012	11.8500	5.3325	3.0000	1
50	8746	23	1788	11	Q4	2012	7.9000	2.7650	2.0000	1
50	8747	7	0	10	Q4	2012	7.9000	3.8710	2.0000	1
50	8754	7	0	6	Q2	2012	7.9000	2.7650	2.0000	1
50	9224	17	1304	7	Q3	2012	7.9000	3.0020	2.0000	1
50	9447	13	0	11	Q4	2012	11.8500	5.2140	3.0000	1
50	9760	13	0	5	Q2	2012	11.8500	3.5550	3.0000	1
50	10156	14	1072	9	Q3	2012	3.9500	1.4220	1.0000	1
51	348	2	0	11	Q4	2012	2.9400	0.9114	2.0000	1
51	527	6	0	7	Q3	2012	4.4100	2.0286	3.0000	1
51	829	24	1869	12	Q4	2012	5.8800	2.5872	4.0000	1
51	983	11	0	11	Q4	2012	2.9400	1.1466	2.0000	1
51	1483	7	519	9	Q3	2012	2.9400	1.4406	2.0000	1
51	1914	24	0	2	Q1	2012	2.9400	1.0290	2.0000	1
51	1917	23	0	5	Q2	2012	4.4100	1.9404	3.0000	1
51	2065	17	0	8	Q3	2012	2.9400	1.0290	2.0000	1
51	2368	3	0	1	Q1	2012	4.4100	1.4994	3.0000	1
51	2496	11	0	1	Q1	2012	2.9400	1.3524	2.0000	1
51	3246	6	0	12	Q4	2012	2.9400	1.2642	2.0000	1
51	4168	13	976	1	Q1	2012	2.9400	1.3818	2.0000	1
51	4258	7	0	4	Q2	2012	4.4100	1.4112	3.0000	1
51	4283	15	0	10	Q4	2012	4.4100	1.8081	3.0000	1
51	4315	17	0	5	Q2	2012	4.4100	2.0727	3.0000	1
51	4340	17	0	11	Q4	2012	5.8800	2.1168	4.0000	1
51	4397	16	0	3	Q1	2012	4.4100	2.0286	3.0000	1
51	4434	15	0	9	Q3	2012	5.8800	2.4108	4.0000	1
51	4434	15	1142	5	Q2	2012	2.9400	0.8820	2.0000	1
51	4625	15	0	1	Q1	2012	4.4100	1.6317	3.0000	1
51	5109	15	0	10	Q4	2012	4.4100	1.5876	3.0000	1
51	5220	6	0	4	Q2	2012	4.4100	1.7199	3.0000	1
51	5250	6	0	9	Q3	2012	2.9400	0.9408	2.0000	1
51	5436	6	0	5	Q2	2012	2.9400	1.2348	2.0000	1
51	5948	6	0	5	Q2	2012	4.4100	1.3671	3.0000	1
51	6265	23	1789	12	Q4	2012	2.9400	0.9408	2.0000	1
51	6307	16	0	8	Q3	2012	4.4100	1.9845	3.0000	1
51	6372	17	1292	1	Q1	2012	2.9400	0.9114	2.0000	1
51	6792	13	0	2	Q1	2012	7.3500	3.6015	5.0000	1
51	7100	17	0	12	Q4	2012	5.8800	2.1168	4.0000	1
51	7362	11	0	7	Q3	2012	4.4100	1.7199	3.0000	1
51	7871	6	519	9	Q3	2012	4.4100	1.9845	3.0000	1
51	8248	7	0	9	Q3	2012	5.8800	1.9992	4.0000	1
51	8482	11	837	10	Q4	2012	4.4100	1.8963	3.0000	1
51	8557	6	0	5	Q2	2012	5.8800	2.6460	4.0000	1
51	9123	3	0	6	Q2	2012	2.9400	1.2054	2.0000	1
51	9190	7	0	3	Q1	2012	4.4100	2.1609	3.0000	1
51	9248	15	0	2	Q1	2012	5.8800	2.5284	4.0000	1
51	9642	3	0	4	Q2	2012	5.8800	2.2932	4.0000	1
51	9825	13	0	12	Q4	2012	4.4100	1.7640	3.0000	1
52	76	3	0	9	Q3	2012	4.3400	1.6492	2.0000	1
52	112	6	521	10	Q4	2012	8.6800	4.2532	4.0000	1
52	338	2	0	4	Q2	2012	4.3400	1.9964	2.0000	1
52	541	24	0	3	Q1	2012	4.3400	1.7360	2.0000	1
52	1071	13	0	6	Q2	2012	6.5100	2.0181	3.0000	1
52	1328	17	0	8	Q3	2012	8.6800	2.7776	4.0000	1
52	1744	17	0	4	Q2	2012	6.5100	2.7993	3.0000	1
52	2237	7	0	6	Q2	2012	8.6800	3.6456	4.0000	1
52	2487	15	0	12	Q4	2012	10.8500	3.6890	5.0000	1
52	2553	16	0	12	Q4	2012	6.5100	2.4738	3.0000	1
52	2662	11	841	12	Q4	2012	6.5100	2.4738	3.0000	1
52	2775	24	1846	2	Q1	2012	6.5100	2.2134	3.0000	1
52	2908	11	0	2	Q1	2012	10.8500	4.6655	5.0000	1
52	3075	23	1771	3	Q1	2012	8.6800	3.7324	4.0000	1
52	3357	24	0	9	Q3	2012	6.5100	2.0832	3.0000	1
52	3388	13	984	5	Q2	2012	4.3400	2.0832	2.0000	1
52	3469	24	1869	12	Q4	2012	6.5100	3.0597	3.0000	1
52	3645	2	114	4	Q2	2012	2.1700	1.0850	1.0000	1
52	3922	7	0	10	Q4	2012	4.3400	1.7794	2.0000	1
52	3962	14	0	1	Q1	2012	4.3400	1.8228	2.0000	1
52	4143	11	0	11	Q4	2012	4.3400	2.1266	2.0000	1
52	4423	13	0	2	Q1	2012	6.5100	2.2134	3.0000	1
52	4436	3	0	5	Q2	2012	6.5100	3.1899	3.0000	1
52	4436	3	199	7	Q3	2012	6.5100	1.9530	3.0000	1
52	5210	17	0	4	Q2	2012	6.5100	1.9530	3.0000	1
52	5373	24	0	1	Q1	2012	6.5100	2.7993	3.0000	1
52	5374	16	0	6	Q2	2012	6.5100	3.0597	3.0000	1
52	5537	3	0	6	Q2	2012	8.6800	3.7324	4.0000	1
52	5639	11	829	6	Q2	2012	4.3400	1.3888	2.0000	1
52	5923	23	1788	11	Q4	2012	8.6800	2.8644	4.0000	1
52	6047	17	1314	11	Q4	2012	8.6800	3.4720	4.0000	1
52	6084	11	0	11	Q4	2012	6.5100	2.8644	3.0000	1
52	6304	6	0	6	Q2	2012	4.3400	2.0398	2.0000	1
52	6318	15	0	8	Q3	2012	8.6800	3.2984	4.0000	1
52	6666	17	0	12	Q4	2012	8.6800	2.7776	4.0000	1
52	6784	15	0	10	Q4	2012	4.3400	1.3454	2.0000	1
52	7236	24	0	12	Q4	2012	6.5100	3.0597	3.0000	1
52	7292	13	0	7	Q3	2012	4.3400	1.8228	2.0000	1
52	7806	13	0	12	Q4	2012	6.5100	3.1248	3.0000	1
52	7849	3	0	7	Q3	2012	6.5100	2.2785	3.0000	1
52	8003	3	0	3	Q1	2012	4.3400	1.9964	2.0000	1
52	8015	13	0	2	Q1	2012	6.5100	2.7993	3.0000	1
52	8777	17	0	12	Q4	2012	6.5100	2.1483	3.0000	1
52	8837	11	821	2	Q1	2012	8.6800	2.6040	4.0000	1
52	8843	13	0	5	Q2	2012	6.5100	2.7342	3.0000	1
52	9068	7	0	8	Q3	2012	6.5100	1.9530	3.0000	1
52	9134	23	1781	8	Q3	2012	6.5100	2.3436	3.0000	1
52	9642	3	188	2	Q1	2012	10.8500	5.0995	5.0000	1
52	9823	13	0	3	Q1	2012	6.5100	2.7342	3.0000	1
52	10176	13	0	1	Q1	2012	8.6800	4.1664	4.0000	1
53	6	15	0	7	Q3	2012	18.0500	8.3030	5.0000	1
53	198	24	1845	1	Q1	2012	7.2200	2.6714	2.0000	1
53	454	17	1292	1	Q1	2012	7.2200	3.3934	2.0000	1
53	863	17	0	1	Q1	2012	10.8300	3.8988	3.0000	1
53	1097	23	0	12	Q4	2012	14.4400	4.7652	4.0000	1
53	1304	13	980	3	Q1	2012	7.2200	3.3934	2.0000	1
53	1430	3	0	2	Q1	2012	14.4400	6.3536	4.0000	1
53	1551	3	185	1	Q1	2012	14.4400	6.0648	4.0000	1
53	1683	6	513	6	Q2	2012	10.8300	4.3320	3.0000	1
53	1820	7	0	11	Q4	2012	10.8300	5.3067	3.0000	1
53	1862	17	1293	1	Q1	2012	10.8300	4.9818	3.0000	1
53	1906	6	522	10	Q4	2012	10.8300	4.0071	3.0000	1
53	1917	23	0	6	Q2	2012	7.2200	3.3212	2.0000	1
53	1965	17	0	12	Q4	2012	10.8300	5.4150	3.0000	1
53	2096	24	0	3	Q1	2012	7.2200	3.0324	2.0000	1
53	2241	6	0	8	Q3	2012	14.4400	6.6424	4.0000	1
53	2304	13	0	5	Q2	2012	10.8300	3.4656	3.0000	1
53	2673	11	0	5	Q2	2012	7.2200	2.4548	2.0000	1
53	2769	16	0	4	Q2	2012	10.8300	5.3067	3.0000	1
53	2882	24	1858	7	Q3	2012	7.2200	2.6714	2.0000	1
53	2908	11	0	7	Q3	2012	18.0500	6.4980	5.0000	1
53	3188	6	0	9	Q3	2012	10.8300	3.6822	3.0000	1
53	3193	24	1853	5	Q2	2012	7.2200	2.8880	2.0000	1
53	3577	11	0	11	Q4	2012	14.4400	4.6208	4.0000	1
53	3758	24	0	9	Q3	2012	7.2200	2.6714	2.0000	1
53	3854	13	0	12	Q4	2012	10.8300	3.3573	3.0000	1
53	4029	17	0	9	Q3	2012	14.4400	6.4980	4.0000	1
53	4232	7	0	12	Q4	2012	14.4400	5.6316	4.0000	1
53	4466	13	0	12	Q4	2012	10.8300	4.1154	3.0000	1
53	4527	3	0	11	Q4	2012	10.8300	3.4656	3.0000	1
53	4541	3	199	7	Q3	2012	14.4400	5.9204	4.0000	1
53	4567	23	1776	6	Q2	2012	10.8300	5.0901	3.0000	1
53	4993	14	0	10	Q4	2012	7.2200	3.4656	2.0000	1
53	5079	6	0	2	Q1	2012	7.2200	3.3934	2.0000	1
53	5120	7	504	2	Q1	2012	7.2200	2.3104	2.0000	1
53	5238	17	1304	7	Q3	2012	10.8300	4.8735	3.0000	1
53	5376	3	188	2	Q1	2012	14.4400	6.2092	4.0000	1
53	5379	17	1292	1	Q1	2012	14.4400	4.7652	4.0000	1
53	5419	17	1307	8	Q3	2012	7.2200	3.3934	2.0000	1
53	5802	7	0	4	Q2	2012	7.2200	3.1046	2.0000	1
53	5895	17	0	7	Q3	2012	14.4400	6.3536	4.0000	1
53	5957	11	0	3	Q1	2012	14.4400	6.0648	4.0000	1
53	6003	13	0	4	Q2	2012	10.8300	4.6569	3.0000	1
53	6149	2	0	10	Q4	2012	3.6100	1.4079	1.0000	1
53	6513	14	0	11	Q4	2012	3.6100	1.4801	1.0000	1
53	6554	17	1293	1	Q1	2012	10.8300	5.0901	3.0000	1
53	6642	24	1850	3	Q1	2012	14.4400	5.6316	4.0000	1
53	6982	13	0	11	Q4	2012	14.4400	5.0540	4.0000	1
53	7271	6	0	11	Q4	2012	10.8300	3.4656	3.0000	1
53	7314	14	1056	1	Q1	2012	3.6100	1.6606	1.0000	1
53	7433	11	820	2	Q1	2012	10.8300	3.5739	3.0000	1
53	7806	13	0	5	Q2	2012	10.8300	4.9818	3.0000	1
53	7896	23	0	6	Q2	2012	10.8300	4.1154	3.0000	1
53	8367	13	0	2	Q1	2012	14.4400	7.0756	4.0000	1
53	8577	23	1765	1	Q1	2012	14.4400	5.6316	4.0000	1
53	8622	7	0	1	Q1	2012	10.8300	3.5739	3.0000	1
53	8717	17	0	2	Q1	2012	14.4400	6.0648	4.0000	1
53	9032	13	0	3	Q1	2012	14.4400	5.4872	4.0000	1
53	9145	7	0	4	Q2	2012	7.2200	3.4656	2.0000	1
53	9879	24	1846	2	Q1	2012	7.2200	3.3934	2.0000	1
54	39	13	0	8	Q3	2012	14.6500	6.5925	5.0000	1
54	192	16	0	8	Q3	2012	8.7900	3.0765	3.0000	1
54	471	24	0	9	Q3	2012	8.7900	4.0434	3.0000	1
54	511	16	0	11	Q4	2012	8.7900	4.2192	3.0000	1
54	603	24	1869	12	Q4	2012	8.7900	4.3071	3.0000	1
54	625	13	0	1	Q1	2012	8.7900	2.8128	3.0000	1
54	1202	11	821	3	Q1	2012	11.7200	5.6256	4.0000	1
54	1445	15	0	3	Q1	2012	11.7200	4.1020	4.0000	1
54	1533	3	0	2	Q1	2012	5.8600	1.8752	2.0000	1
54	2272	17	1314	11	Q4	2012	8.7900	4.2192	3.0000	1
54	2511	17	0	2	Q1	2012	8.7900	4.3950	3.0000	1
54	2553	16	0	6	Q2	2012	11.7200	3.6332	4.0000	1
54	2555	15	0	7	Q3	2012	5.8600	2.5784	2.0000	1
54	2568	11	0	4	Q2	2012	5.8600	2.4026	2.0000	1
54	2674	11	0	8	Q3	2012	11.7200	4.2192	4.0000	1
54	3004	7	0	7	Q3	2012	11.7200	5.7428	4.0000	1
54	3283	15	0	6	Q2	2012	11.7200	5.8600	4.0000	1
54	3386	24	0	3	Q1	2012	11.7200	4.3364	4.0000	1
54	3423	13	0	9	Q3	2012	5.8600	2.2268	2.0000	1
54	3474	15	1154	10	Q4	2012	5.8600	2.5198	2.0000	1
54	3497	17	0	2	Q1	2012	8.7900	3.1644	3.0000	1
54	3688	24	0	9	Q3	2012	8.7900	4.2192	3.0000	1
54	3746	24	0	12	Q4	2012	8.7900	3.5160	3.0000	1
54	3921	23	0	8	Q3	2012	11.7200	5.3912	4.0000	1
54	4029	17	1312	10	Q4	2012	11.7200	5.7428	4.0000	1
54	4239	17	1297	3	Q1	2012	8.7900	3.3402	3.0000	1
54	4261	13	0	1	Q1	2012	5.8600	2.5198	2.0000	1
54	4358	24	0	7	Q3	2012	5.8600	1.7580	2.0000	1
54	4535	15	0	3	Q1	2012	5.8600	2.9300	2.0000	1
54	4573	7	0	5	Q2	2012	5.8600	2.5784	2.0000	1
54	5295	16	0	12	Q4	2012	11.7200	3.9848	4.0000	1
54	5419	17	0	12	Q4	2012	5.8600	2.7542	2.0000	1
54	5471	7	0	9	Q3	2012	11.7200	5.5084	4.0000	1
54	5650	2	0	4	Q2	2012	5.8600	2.7542	2.0000	1
54	5842	24	0	4	Q2	2012	11.7200	4.1020	4.0000	1
54	6124	7	0	8	Q3	2012	5.8600	2.6956	2.0000	1
54	6141	7	523	11	Q4	2012	5.8600	2.6956	2.0000	1
54	6324	23	0	2	Q1	2012	8.7900	2.9886	3.0000	1
54	6372	17	0	5	Q2	2012	5.8600	1.8166	2.0000	1
54	6688	7	0	10	Q4	2012	11.7200	5.7428	4.0000	1
54	6696	6	0	5	Q2	2012	5.8600	2.7542	2.0000	1
54	6766	24	0	7	Q3	2012	8.7900	3.7797	3.0000	1
54	6894	24	1846	2	Q1	2012	5.8600	2.1096	2.0000	1
54	7079	11	0	8	Q3	2012	8.7900	3.0765	3.0000	1
54	7103	15	0	1	Q1	2012	8.7900	2.9886	3.0000	1
54	7171	23	0	4	Q2	2012	8.7900	4.3071	3.0000	1
54	7576	13	0	10	Q4	2012	8.7900	3.1644	3.0000	1
54	7672	6	0	3	Q1	2012	11.7200	5.1568	4.0000	1
54	7683	22	0	12	Q4	2012	5.8600	2.9300	2.0000	1
54	8003	3	185	1	Q1	2012	5.8600	2.8714	2.0000	1
54	8189	17	0	4	Q2	2012	8.7900	2.8128	3.0000	1
54	8243	13	0	2	Q1	2012	5.8600	2.4026	2.0000	1
54	9064	17	0	5	Q2	2012	11.7200	5.2740	4.0000	1
54	9144	13	0	4	Q2	2012	8.7900	4.3071	3.0000	1
54	9237	11	0	6	Q2	2012	11.7200	4.2192	4.0000	1
54	9401	13	0	5	Q2	2012	5.8600	2.0510	2.0000	1
54	9797	16	0	6	Q2	2012	5.8600	2.9300	2.0000	1
55	182	15	0	9	Q3	2012	10.5000	3.1500	3.0000	1
55	260	11	0	10	Q4	2012	14.0000	5.0400	4.0000	1
55	424	6	0	9	Q3	2012	7.0000	2.2400	2.0000	1
55	874	6	508	4	Q2	2012	14.0000	6.3000	4.0000	1
55	976	16	0	1	Q1	2012	10.5000	5.0400	3.0000	1
55	1185	17	0	11	Q4	2012	10.5000	3.8850	3.0000	1
55	1297	16	1235	11	Q4	2012	14.0000	6.5800	4.0000	1
55	1304	13	0	1	Q1	2012	7.0000	3.2200	2.0000	1
55	1551	3	202	8	Q3	2012	14.0000	6.4400	4.0000	1
55	1785	3	0	10	Q4	2012	14.0000	4.7600	4.0000	1
55	2059	17	0	12	Q4	2012	14.0000	6.4400	4.0000	1
55	2195	6	0	1	Q1	2012	10.5000	5.0400	3.0000	1
55	2390	17	1303	6	Q2	2012	10.5000	3.1500	3.0000	1
55	2460	24	1859	8	Q3	2012	14.0000	5.4600	4.0000	1
55	2511	17	0	12	Q4	2012	10.5000	3.1500	3.0000	1
55	2815	22	0	9	Q3	2012	7.0000	2.2400	2.0000	1
55	2850	3	0	8	Q3	2012	14.0000	7.0000	4.0000	1
55	3065	3	207	11	Q4	2012	10.5000	3.4650	3.0000	1
55	3319	11	826	5	Q2	2012	10.5000	4.9350	3.0000	1
55	3587	6	0	8	Q3	2012	10.5000	4.7250	3.0000	1
55	3693	3	0	1	Q1	2012	10.5000	4.9350	3.0000	1
55	3773	17	1311	10	Q4	2012	10.5000	3.3600	3.0000	1
55	4099	17	0	7	Q3	2012	14.0000	4.9000	4.0000	1
55	4103	24	0	3	Q1	2012	7.0000	2.7300	2.0000	1
55	4488	7	0	12	Q4	2012	10.5000	4.6200	3.0000	1
55	4595	11	837	10	Q4	2012	7.0000	2.8000	2.0000	1
55	4676	16	0	10	Q4	2012	10.5000	4.8300	3.0000	1
55	4810	23	1776	6	Q2	2012	10.5000	5.0400	3.0000	1
55	4900	13	0	12	Q4	2012	7.0000	2.9400	2.0000	1
55	5419	17	0	8	Q3	2012	7.0000	3.2900	2.0000	1
55	5462	24	0	3	Q1	2012	7.0000	2.6600	2.0000	1
55	5542	16	0	9	Q3	2012	7.0000	3.0100	2.0000	1
55	5671	6	0	4	Q2	2012	7.0000	2.8700	2.0000	1
55	5790	17	0	5	Q2	2012	7.0000	3.0800	2.0000	1
55	6554	17	1304	7	Q3	2012	14.0000	6.8600	4.0000	1
55	7209	11	842	12	Q4	2012	10.5000	3.9900	3.0000	1
55	8172	17	0	5	Q2	2012	10.5000	3.7800	3.0000	1
55	8193	6	0	6	Q2	2012	14.0000	6.5800	4.0000	1
55	8291	13	0	4	Q2	2012	10.5000	3.8850	3.0000	1
55	8682	7	0	12	Q4	2012	7.0000	2.7300	2.0000	1
55	8779	13	0	4	Q2	2012	10.5000	4.8300	3.0000	1
55	9504	13	0	12	Q4	2012	7.0000	2.4500	2.0000	1
55	9642	3	210	12	Q4	2012	17.5000	5.7750	5.0000	1
56	524	7	519	9	Q3	2012	2.1300	1.0437	3.0000	1
56	979	15	0	12	Q4	2012	1.4200	0.6106	2.0000	1
56	999	24	1860	8	Q3	2012	3.5500	1.5620	5.0000	1
56	1493	2	0	1	Q1	2012	0.7100	0.2982	1.0000	1
56	1580	15	0	4	Q2	2012	2.1300	0.7455	3.0000	1
56	1587	11	0	12	Q4	2012	2.8400	0.8804	4.0000	1
56	1610	3	197	6	Q2	2012	2.8400	1.2212	4.0000	1
56	1666	6	0	11	Q4	2012	2.1300	0.6816	3.0000	1
56	1718	13	0	3	Q1	2012	2.8400	1.0792	4.0000	1
56	2141	7	0	6	Q2	2012	2.1300	1.0437	3.0000	1
56	2359	24	1850	3	Q1	2012	1.4200	0.4970	2.0000	1
56	3652	7	504	2	Q1	2012	2.1300	0.6603	3.0000	1
56	3664	22	0	2	Q1	2012	1.4200	0.6816	2.0000	1
56	3825	22	0	6	Q2	2012	0.7100	0.2982	1.0000	1
56	4021	16	1233	10	Q4	2012	3.5500	1.7040	5.0000	1
56	4078	3	0	10	Q4	2012	2.8400	1.3916	4.0000	1
56	4082	24	0	10	Q4	2012	1.4200	0.5680	2.0000	1
56	4397	16	0	11	Q4	2012	1.4200	0.4970	2.0000	1
56	4816	24	0	7	Q3	2012	1.4200	0.7100	2.0000	1
56	4868	16	0	8	Q3	2012	2.1300	0.8307	3.0000	1
56	4903	3	0	2	Q1	2012	1.4200	0.5112	2.0000	1
56	4985	23	0	3	Q1	2012	2.8400	1.1076	4.0000	1
56	5232	7	504	2	Q1	2012	2.1300	0.9372	3.0000	1
56	5423	11	0	5	Q2	2012	2.1300	0.6603	3.0000	1
56	5429	11	0	3	Q1	2012	2.1300	0.7881	3.0000	1
56	5694	11	0	9	Q3	2012	2.8400	1.2212	4.0000	1
56	6681	17	1303	6	Q2	2012	2.1300	0.8307	3.0000	1
56	7018	6	0	6	Q2	2012	2.1300	1.0011	3.0000	1
56	7138	11	0	11	Q4	2012	2.1300	0.7668	3.0000	1
56	7190	23	1769	3	Q1	2012	2.8400	1.3916	4.0000	1
56	7209	11	0	1	Q1	2012	2.1300	0.9372	3.0000	1
56	7236	24	0	12	Q4	2012	2.1300	0.9798	3.0000	1
56	7478	6	0	1	Q1	2012	2.1300	0.8307	3.0000	1
56	7721	13	988	7	Q3	2012	1.4200	0.6958	2.0000	1
56	8260	7	505	2	Q1	2012	2.1300	1.0437	3.0000	1
56	8457	7	0	9	Q3	2012	2.8400	0.9088	4.0000	1
56	8500	17	0	10	Q4	2012	2.1300	1.0437	3.0000	1
56	8577	23	0	2	Q1	2012	2.8400	1.2496	4.0000	1
56	9286	13	0	6	Q2	2012	2.8400	1.1644	4.0000	1
56	9318	16	0	10	Q4	2012	2.1300	0.7881	3.0000	1
56	9422	7	517	8	Q3	2012	2.8400	1.3348	4.0000	1
56	9564	17	0	12	Q4	2012	2.1300	0.8733	3.0000	1
56	9788	13	0	7	Q3	2012	1.4200	0.4402	2.0000	1
56	9823	13	0	12	Q4	2012	2.1300	0.7668	3.0000	1
56	10098	7	512	6	Q2	2012	2.8400	0.9940	4.0000	1
56	10098	7	523	11	Q4	2012	2.8400	0.9656	4.0000	1
56	10144	7	523	11	Q4	2012	2.1300	0.9159	3.0000	1
57	551	7	0	4	Q2	2012	1.8300	0.6771	3.0000	1
57	624	15	0	3	Q1	2012	1.8300	0.8601	3.0000	1
57	886	15	1146	7	Q3	2012	2.4400	1.0248	4.0000	1
57	1281	3	0	4	Q2	2012	1.2200	0.5734	2.0000	1
57	1565	24	1847	2	Q1	2012	1.8300	0.9150	3.0000	1
57	1658	15	0	8	Q3	2012	1.2200	0.5734	2.0000	1
57	1720	16	0	7	Q3	2012	2.4400	1.1956	4.0000	1
57	1798	3	0	4	Q2	2012	1.8300	0.7686	3.0000	1
57	1850	16	1216	2	Q1	2012	1.2200	0.5978	2.0000	1
57	2371	16	0	3	Q1	2012	1.8300	0.7137	3.0000	1
57	2587	16	1236	12	Q4	2012	2.4400	1.1956	4.0000	1
57	3130	13	0	7	Q3	2012	1.8300	0.8784	3.0000	1
57	3434	24	0	8	Q3	2012	1.2200	0.4514	2.0000	1
57	3476	3	197	6	Q2	2012	2.4400	0.8540	4.0000	1
57	3567	16	0	12	Q4	2012	2.4400	0.7564	4.0000	1
57	3825	22	0	3	Q1	2012	1.8300	0.7137	3.0000	1
57	4004	13	0	12	Q4	2012	1.2200	0.5734	2.0000	1
57	4165	3	0	2	Q1	2012	2.4400	0.8540	4.0000	1
57	4413	13	0	3	Q1	2012	2.4400	1.0492	4.0000	1
57	4466	13	0	10	Q4	2012	1.8300	0.7686	3.0000	1
57	4961	13	0	8	Q3	2012	2.4400	0.8784	4.0000	1
57	4968	24	0	4	Q2	2012	1.8300	0.5856	3.0000	1
57	5168	7	0	5	Q2	2012	1.8300	0.7503	3.0000	1
57	5431	6	0	12	Q4	2012	1.8300	0.8418	3.0000	1
57	5501	17	1303	6	Q2	2012	1.2200	0.4758	2.0000	1
57	5834	11	0	12	Q4	2012	1.8300	0.7137	3.0000	1
57	6084	11	818	1	Q1	2012	1.2200	0.4392	2.0000	1
57	6529	17	0	12	Q4	2012	1.8300	0.7869	3.0000	1
57	6997	13	0	7	Q3	2012	2.4400	0.7564	4.0000	1
57	7035	6	0	6	Q2	2012	1.8300	0.8967	3.0000	1
57	7153	3	0	12	Q4	2012	1.2200	0.5246	2.0000	1
57	7192	2	0	12	Q4	2012	1.2200	0.4026	2.0000	1
57	7209	11	826	5	Q2	2012	2.4400	1.1712	4.0000	1
57	7455	13	0	12	Q4	2012	2.4400	1.1224	4.0000	1
57	7719	24	0	7	Q3	2012	1.8300	0.5673	3.0000	1
57	7729	24	0	1	Q1	2012	2.4400	0.7808	4.0000	1
57	8059	17	0	5	Q2	2012	1.8300	0.6588	3.0000	1
57	8411	15	0	10	Q4	2012	1.2200	0.5856	2.0000	1
57	8578	23	0	8	Q3	2012	2.4400	1.1956	4.0000	1
57	9045	24	0	1	Q1	2012	1.2200	0.4880	2.0000	1
57	9069	6	524	11	Q4	2012	1.8300	0.8967	3.0000	1
57	9580	15	0	3	Q1	2012	1.2200	0.4880	2.0000	1
57	9642	3	0	3	Q1	2012	1.8300	0.8601	3.0000	1
57	9776	15	0	8	Q3	2012	1.8300	0.5673	3.0000	1
57	9871	13	0	7	Q3	2012	1.8300	0.6222	3.0000	1
57	10102	6	0	7	Q3	2012	2.4400	0.9028	4.0000	1
58	74	15	1136	2	Q1	2012	9.2400	4.6200	4.0000	1
58	335	17	0	4	Q2	2012	4.6200	1.9866	2.0000	1
58	623	24	0	3	Q1	2012	9.2400	4.1580	4.0000	1
58	652	6	0	3	Q1	2012	6.9300	3.1185	3.0000	1
58	769	16	0	1	Q1	2012	6.9300	3.3957	3.0000	1
58	820	24	0	4	Q2	2012	9.2400	3.2340	4.0000	1
58	1748	7	0	5	Q2	2012	9.2400	2.9568	4.0000	1
58	1839	11	0	8	Q3	2012	6.9300	2.8413	3.0000	1
58	1850	16	0	6	Q2	2012	9.2400	4.1580	4.0000	1
58	1874	17	0	1	Q1	2012	6.9300	3.0492	3.0000	1
58	1987	13	0	7	Q3	2012	6.9300	2.6334	3.0000	1
58	1994	15	0	9	Q3	2012	4.6200	1.4784	2.0000	1
58	2678	3	195	5	Q2	2012	6.9300	2.4948	3.0000	1
58	2683	2	0	8	Q3	2012	4.6200	1.6632	2.0000	1
58	2886	11	0	10	Q4	2012	4.6200	1.8480	2.0000	1
58	2973	15	0	7	Q3	2012	4.6200	2.0328	2.0000	1
58	3497	17	0	3	Q1	2012	6.9300	2.7720	3.0000	1
58	3609	24	1853	5	Q2	2012	6.9300	2.7027	3.0000	1
58	3702	6	0	2	Q1	2012	6.9300	2.2869	3.0000	1
58	3759	13	0	7	Q3	2012	9.2400	4.6200	4.0000	1
58	4204	17	1307	8	Q3	2012	11.5500	4.5045	5.0000	1
58	4763	24	0	12	Q4	2012	9.2400	4.2504	4.0000	1
58	4942	11	0	12	Q4	2012	6.9300	2.8413	3.0000	1
58	5376	3	0	1	Q1	2012	9.2400	3.9732	4.0000	1
58	5685	13	0	6	Q2	2012	9.2400	3.9732	4.0000	1
58	5887	6	0	11	Q4	2012	4.6200	1.6632	2.0000	1
58	5892	15	0	1	Q1	2012	4.6200	1.9866	2.0000	1
58	5894	11	829	6	Q2	2012	6.9300	3.0492	3.0000	1
58	6060	11	0	4	Q2	2012	9.2400	3.8808	4.0000	1
58	6288	13	984	5	Q2	2012	9.2400	4.3428	4.0000	1
58	6355	7	0	12	Q4	2012	6.9300	3.3264	3.0000	1
58	6854	17	0	3	Q1	2012	4.6200	1.8480	2.0000	1
58	6904	13	1000	12	Q4	2012	9.2400	3.1416	4.0000	1
58	7003	15	0	6	Q2	2012	6.9300	2.4948	3.0000	1
58	7359	13	0	7	Q3	2012	6.9300	2.3562	3.0000	1
58	7393	24	0	7	Q3	2012	4.6200	2.0328	2.0000	1
58	7733	13	0	2	Q1	2012	4.6200	2.1714	2.0000	1
58	7750	15	1149	8	Q3	2012	6.9300	2.9106	3.0000	1
58	7891	15	0	6	Q2	2012	11.5500	5.0820	5.0000	1
58	8252	13	0	9	Q3	2012	9.2400	4.4352	4.0000	1
58	8329	15	0	8	Q3	2012	4.6200	1.7556	2.0000	1
58	9067	7	516	8	Q3	2012	6.9300	2.4948	3.0000	1
58	9088	15	0	7	Q3	2012	11.5500	3.5805	5.0000	1
58	9324	3	204	9	Q3	2012	9.2400	3.0492	4.0000	1
58	9331	11	837	10	Q4	2012	6.9300	2.0790	3.0000	1
58	9648	13	980	3	Q1	2012	4.6200	2.1252	2.0000	1
58	9890	15	0	4	Q2	2012	9.2400	4.0656	4.0000	1
58	10120	6	508	4	Q2	2012	6.9300	2.4948	3.0000	1
58	10176	13	0	10	Q4	2012	9.2400	2.9568	4.0000	1
58	10238	16	0	11	Q4	2012	4.6200	1.6632	2.0000	1
59	20	24	0	1	Q1	2012	4.2000	2.1000	3.0000	1
59	181	3	0	4	Q2	2012	4.2000	1.9740	3.0000	1
59	1191	24	0	1	Q1	2012	5.6000	2.4640	4.0000	1
59	1491	16	0	1	Q1	2012	4.2000	2.0580	3.0000	1
59	1533	3	0	11	Q4	2012	4.2000	1.8060	3.0000	1
59	1556	17	1292	1	Q1	2012	2.8000	0.9800	2.0000	1
59	2511	17	0	5	Q2	2012	5.6000	2.7440	4.0000	1
59	2723	3	205	10	Q4	2012	2.8000	1.3160	2.0000	1
59	2818	7	504	2	Q1	2012	4.2000	1.4700	3.0000	1
59	2850	3	0	10	Q4	2012	4.2000	1.4280	3.0000	1
59	2916	13	0	12	Q4	2012	4.2000	1.8060	3.0000	1
59	2942	17	1314	11	Q4	2012	2.8000	1.2040	2.0000	1
59	3253	13	0	10	Q4	2012	7.0000	3.3600	5.0000	1
59	3275	24	1853	5	Q2	2012	2.8000	0.9800	2.0000	1
59	3540	24	0	10	Q4	2012	5.6000	1.7360	4.0000	1
59	4031	14	0	4	Q2	2012	1.4000	0.6020	1.0000	1
59	4305	15	1140	4	Q2	2012	5.6000	2.1840	4.0000	1
59	4390	11	842	12	Q4	2012	4.2000	1.7640	3.0000	1
59	4436	3	210	12	Q4	2012	4.2000	1.8900	3.0000	1
59	4498	17	1304	7	Q3	2012	2.8000	1.0360	2.0000	1
59	4674	7	0	10	Q4	2012	5.6000	2.0160	4.0000	1
59	5001	6	0	12	Q4	2012	2.8000	1.1200	2.0000	1
59	5009	7	0	1	Q1	2012	4.2000	1.8480	3.0000	1
59	5019	23	0	11	Q4	2012	5.6000	2.5200	4.0000	1
59	5026	17	0	12	Q4	2012	2.8000	1.0640	2.0000	1
59	5070	13	0	10	Q4	2012	2.8000	1.1760	2.0000	1
59	5107	6	0	4	Q2	2012	5.6000	2.1840	4.0000	1
59	5328	2	0	4	Q2	2012	1.4000	0.6580	1.0000	1
59	5844	17	0	5	Q2	2012	4.2000	1.8480	3.0000	1
59	5944	3	204	9	Q3	2012	4.2000	2.1000	3.0000	1
59	6056	15	0	5	Q2	2012	4.2000	1.5540	3.0000	1
59	6145	15	0	5	Q2	2012	2.8000	0.8960	2.0000	1
59	6529	17	0	9	Q3	2012	4.2000	1.8060	3.0000	1
59	7384	3	0	7	Q3	2012	5.6000	2.7440	4.0000	1
59	7446	13	0	1	Q1	2012	5.6000	2.0160	4.0000	1
59	7529	17	0	8	Q3	2012	4.2000	1.8900	3.0000	1
59	7546	13	0	11	Q4	2012	5.6000	2.6880	4.0000	1
59	7589	17	0	12	Q4	2012	4.2000	1.5120	3.0000	1
59	8374	3	0	4	Q2	2012	2.8000	1.3160	2.0000	1
59	8410	13	984	5	Q2	2012	2.8000	1.1480	2.0000	1
59	8477	3	195	5	Q2	2012	4.2000	1.3440	3.0000	1
59	8554	24	0	11	Q4	2012	2.8000	0.8680	2.0000	1
59	8579	15	0	12	Q4	2012	4.2000	1.9320	3.0000	1
59	8677	24	0	12	Q4	2012	2.8000	1.3160	2.0000	1
59	8749	13	0	9	Q3	2012	2.8000	1.2600	2.0000	1
59	8914	15	0	4	Q2	2012	2.8000	1.0360	2.0000	1
59	9477	6	0	8	Q3	2012	4.2000	1.5960	3.0000	1
59	9640	6	0	9	Q3	2012	4.2000	1.5120	3.0000	1
59	9863	13	0	7	Q3	2012	4.2000	1.5120	3.0000	1
59	9875	24	0	8	Q3	2012	2.8000	0.8400	2.0000	1
59	9928	16	1225	7	Q3	2012	2.8000	1.1480	2.0000	1
59	10088	24	0	9	Q3	2012	5.6000	2.1280	4.0000	1
59	10090	14	0	2	Q1	2012	4.2000	1.2600	3.0000	1
59	10231	6	524	11	Q4	2012	5.6000	1.7360	4.0000	1
60	10	11	821	2	Q1	2012	5.3200	2.5004	2.0000	1
60	277	2	0	10	Q4	2012	5.3200	1.8088	2.0000	1
60	387	22	0	8	Q3	2012	5.3200	2.5004	2.0000	1
60	1003	17	1303	6	Q2	2012	7.9800	3.8304	3.0000	1
60	1031	6	0	12	Q4	2012	7.9800	3.2718	3.0000	1
60	1297	16	0	11	Q4	2012	7.9800	3.8304	3.0000	1
60	1366	13	0	12	Q4	2012	7.9800	2.8728	3.0000	1
60	1368	6	0	10	Q4	2012	7.9800	2.5536	3.0000	1
60	1442	3	0	10	Q4	2012	7.9800	3.9102	3.0000	1
60	1543	15	0	9	Q3	2012	10.6400	4.2560	4.0000	1
60	1562	2	0	8	Q3	2012	2.6600	1.3034	1.0000	1
60	1798	3	0	11	Q4	2012	7.9800	3.3516	3.0000	1
60	1833	15	0	1	Q1	2012	10.6400	3.8304	4.0000	1
60	2298	3	187	2	Q1	2012	13.3000	4.2560	5.0000	1
60	2308	14	0	7	Q3	2012	5.3200	2.3408	2.0000	1
60	2378	16	0	6	Q2	2012	10.6400	3.8304	4.0000	1
60	2668	7	0	11	Q4	2012	10.6400	3.8304	4.0000	1
60	2965	2	0	2	Q1	2012	5.3200	1.9684	2.0000	1
60	3124	3	0	3	Q1	2012	5.3200	1.6492	2.0000	1
60	3305	13	0	10	Q4	2012	10.6400	4.4688	4.0000	1
60	3327	7	0	12	Q4	2012	5.3200	1.8620	2.0000	1
60	3589	13	0	7	Q3	2012	5.3200	2.0216	2.0000	1
60	4105	3	0	3	Q1	2012	7.9800	2.8728	3.0000	1
60	4269	15	1143	5	Q2	2012	7.9800	3.7506	3.0000	1
60	4330	13	980	3	Q1	2012	10.6400	5.2136	4.0000	1
60	4925	16	1216	2	Q1	2012	10.6400	5.1072	4.0000	1
60	5048	15	0	5	Q2	2012	7.9800	2.5536	3.0000	1
60	5305	11	842	12	Q4	2012	5.3200	2.2876	2.0000	1
60	5568	23	0	11	Q4	2012	7.9800	2.8728	3.0000	1
60	5686	3	0	9	Q3	2012	5.3200	1.6492	2.0000	1
60	5742	16	0	8	Q3	2012	10.6400	3.4048	4.0000	1
60	5827	11	0	2	Q1	2012	7.9800	2.3940	3.0000	1
60	5923	23	1775	5	Q2	2012	5.3200	1.8088	2.0000	1
60	6271	6	0	10	Q4	2012	5.3200	1.7024	2.0000	1
60	6589	17	0	9	Q3	2012	7.9800	3.9102	3.0000	1
60	6921	24	0	1	Q1	2012	7.9800	2.8728	3.0000	1
60	7138	11	0	11	Q4	2012	7.9800	3.0324	3.0000	1
60	7180	11	0	2	Q1	2012	10.6400	4.7880	4.0000	1
60	7250	13	0	7	Q3	2012	10.6400	3.6176	4.0000	1
60	7278	14	1061	4	Q2	2012	5.3200	1.9152	2.0000	1
60	7297	11	0	11	Q4	2012	10.6400	3.8304	4.0000	1
60	7382	22	0	8	Q3	2012	7.9800	2.5536	3.0000	1
60	7586	2	0	3	Q1	2012	5.3200	2.2876	2.0000	1
60	7704	3	0	4	Q2	2012	10.6400	4.5752	4.0000	1
60	7769	11	837	10	Q4	2012	7.9800	3.8304	3.0000	1
60	7915	13	0	7	Q3	2012	5.3200	1.6492	2.0000	1
60	7951	15	0	6	Q2	2012	7.9800	2.5536	3.0000	1
60	8123	24	0	12	Q4	2012	5.3200	1.9152	2.0000	1
60	8149	24	0	3	Q1	2012	7.9800	3.8304	3.0000	1
60	8189	17	0	4	Q2	2012	7.9800	2.8728	3.0000	1
60	8303	15	0	4	Q2	2012	7.9800	3.4314	3.0000	1
60	8358	11	0	9	Q3	2012	7.9800	3.5910	3.0000	1
60	8411	15	0	4	Q2	2012	7.9800	3.4314	3.0000	1
60	8457	7	526	12	Q4	2012	7.9800	3.4314	3.0000	1
60	8841	13	0	9	Q3	2012	5.3200	2.3940	2.0000	1
60	8947	3	0	5	Q2	2012	10.6400	5.1072	4.0000	1
60	9505	15	0	3	Q1	2012	10.6400	3.8304	4.0000	1
61	117	13	0	1	Q1	2012	2.9600	0.9472	4.0000	1
61	273	7	505	2	Q1	2012	2.9600	1.0064	4.0000	1
61	461	11	842	12	Q4	2012	2.2200	1.0212	3.0000	1
61	699	24	0	12	Q4	2012	2.2200	0.6882	3.0000	1
61	808	15	1154	10	Q4	2012	2.2200	0.8880	3.0000	1
61	934	15	0	8	Q3	2012	2.9600	1.2728	4.0000	1
61	1247	6	0	8	Q3	2012	1.4800	0.5476	2.0000	1
61	1282	3	0	6	Q2	2012	2.2200	1.0656	3.0000	1
61	1414	7	0	6	Q2	2012	2.2200	0.6882	3.0000	1
61	1415	16	0	8	Q3	2012	1.4800	0.7400	2.0000	1
61	1451	3	0	3	Q1	2012	2.2200	0.9324	3.0000	1
61	1548	13	980	3	Q1	2012	2.2200	0.7992	3.0000	1
61	1582	11	842	12	Q4	2012	2.2200	0.8880	3.0000	1
61	1584	7	0	8	Q3	2012	2.9600	1.3024	4.0000	1
61	1690	16	0	11	Q4	2012	2.2200	0.9546	3.0000	1
61	1773	13	0	3	Q1	2012	2.2200	0.9546	3.0000	1
61	1906	6	523	11	Q4	2012	2.2200	0.7548	3.0000	1
61	2448	16	0	9	Q3	2012	2.9600	1.3616	4.0000	1
61	2729	15	0	1	Q1	2012	2.9600	1.1840	4.0000	1
61	2769	16	0	4	Q2	2012	2.2200	0.6882	3.0000	1
61	2915	6	0	2	Q1	2012	1.4800	0.6068	2.0000	1
61	2942	17	1304	7	Q3	2012	2.2200	1.0212	3.0000	1
61	3079	6	504	2	Q1	2012	1.4800	0.5476	2.0000	1
61	3161	13	980	3	Q1	2012	1.4800	0.6216	2.0000	1
61	3328	17	1297	3	Q1	2012	2.9600	0.8880	4.0000	1
61	3349	6	0	6	Q2	2012	2.9600	1.3320	4.0000	1
61	3441	3	0	3	Q1	2012	2.9600	1.0064	4.0000	1
61	3691	17	0	12	Q4	2012	3.7000	1.8130	5.0000	1
61	3706	13	984	5	Q2	2012	2.2200	1.0878	3.0000	1
61	4330	13	0	7	Q3	2012	2.9600	1.4504	4.0000	1
61	4536	13	0	4	Q2	2012	2.2200	0.9990	3.0000	1
61	4543	13	988	7	Q3	2012	2.9600	1.4208	4.0000	1
61	4547	13	0	1	Q1	2012	2.9600	1.0360	4.0000	1
61	5088	13	0	12	Q4	2012	2.9600	1.1248	4.0000	1
61	5276	15	0	12	Q4	2012	2.9600	1.3320	4.0000	1
61	5431	6	0	12	Q4	2012	2.2200	1.0212	3.0000	1
61	5528	24	1847	2	Q1	2012	2.9600	1.3912	4.0000	1
61	5644	17	0	12	Q4	2012	1.4800	0.6808	2.0000	1
61	5766	16	0	3	Q1	2012	1.4800	0.7104	2.0000	1
61	5768	3	0	10	Q4	2012	1.4800	0.5476	2.0000	1
61	5983	7	0	12	Q4	2012	1.4800	0.5328	2.0000	1
61	6018	11	0	10	Q4	2012	2.2200	0.7770	3.0000	1
61	6265	23	0	9	Q3	2012	3.7000	1.1840	5.0000	1
61	6672	2	126	10	Q4	2012	0.7400	0.3108	1.0000	1
61	6713	13	0	3	Q1	2012	1.4800	0.6364	2.0000	1
61	6793	7	0	4	Q2	2012	2.2200	0.7548	3.0000	1
61	7529	17	0	3	Q1	2012	2.2200	0.9324	3.0000	1
61	7806	13	988	7	Q3	2012	1.4800	0.6956	2.0000	1
61	7861	15	0	8	Q3	2012	2.9600	1.3320	4.0000	1
61	7862	16	0	8	Q3	2012	2.9600	1.3912	4.0000	1
61	8060	22	0	1	Q1	2012	0.7400	0.3108	1.0000	1
61	8367	13	982	4	Q2	2012	2.2200	0.7992	3.0000	1
61	8477	3	199	7	Q3	2012	2.2200	1.0212	3.0000	1
61	8731	3	199	7	Q3	2012	2.2200	0.7992	3.0000	1
61	9101	7	0	5	Q2	2012	2.2200	0.7770	3.0000	1
61	9264	24	0	2	Q1	2012	2.2200	0.8214	3.0000	1
61	9504	13	0	11	Q4	2012	2.2200	1.0212	3.0000	1
61	9512	23	1776	6	Q2	2012	1.4800	0.6068	2.0000	1
61	9753	11	0	12	Q4	2012	1.4800	0.5328	2.0000	1
61	10067	7	0	3	Q1	2012	2.2200	0.8880	3.0000	1
62	118	3	0	4	Q2	2012	11.4600	3.5526	3.0000	1
62	170	7	521	10	Q4	2012	11.4600	3.5526	3.0000	1
62	294	24	0	9	Q3	2012	15.2800	4.8896	4.0000	1
62	350	6	502	1	Q1	2012	15.2800	5.3480	4.0000	1
62	378	16	0	5	Q2	2012	11.4600	5.7300	3.0000	1
62	400	23	1773	4	Q2	2012	7.6400	3.5908	2.0000	1
62	493	15	1140	4	Q2	2012	11.4600	5.6154	3.0000	1
62	548	7	0	6	Q2	2012	11.4600	5.5008	3.0000	1
62	553	7	0	3	Q1	2012	11.4600	5.5008	3.0000	1
62	651	24	0	1	Q1	2012	7.6400	2.8268	2.0000	1
62	829	24	1869	12	Q4	2012	7.6400	3.3616	2.0000	1
62	1187	13	0	7	Q3	2012	7.6400	3.1324	2.0000	1
62	1529	13	0	2	Q1	2012	7.6400	3.0560	2.0000	1
62	1529	13	0	6	Q2	2012	7.6400	3.0560	2.0000	1
62	1744	17	0	12	Q4	2012	11.4600	4.0110	3.0000	1
62	2086	13	0	11	Q4	2012	7.6400	2.5976	2.0000	1
62	2431	3	0	12	Q4	2012	11.4600	3.8964	3.0000	1
62	2678	3	195	5	Q2	2012	11.4600	4.3548	3.0000	1
62	2683	2	0	8	Q3	2012	3.8200	1.5280	1.0000	1
62	2723	3	0	3	Q1	2012	7.6400	3.5908	2.0000	1
62	3258	7	0	10	Q4	2012	7.6400	2.5212	2.0000	1
62	3388	13	980	3	Q1	2012	11.4600	3.5526	3.0000	1
62	3428	24	1866	11	Q4	2012	11.4600	3.6672	3.0000	1
62	3458	24	0	1	Q1	2012	15.2800	5.5008	4.0000	1
62	3540	24	0	7	Q3	2012	11.4600	4.1256	3.0000	1
62	3589	13	0	8	Q3	2012	15.2800	5.1952	4.0000	1
62	3692	16	0	12	Q4	2012	15.2800	4.8896	4.0000	1
62	3945	15	0	7	Q3	2012	7.6400	2.3684	2.0000	1
62	3954	24	0	10	Q4	2012	15.2800	7.6400	4.0000	1
62	4066	3	0	4	Q2	2012	15.2800	5.5008	4.0000	1
62	4067	11	0	4	Q2	2012	7.6400	2.3684	2.0000	1
62	4094	16	1225	7	Q3	2012	7.6400	3.2852	2.0000	1
62	5091	24	1869	12	Q4	2012	11.4600	4.1256	3.0000	1
62	5153	11	0	11	Q4	2012	11.4600	3.8964	3.0000	1
62	5410	17	0	8	Q3	2012	11.4600	3.4380	3.0000	1
62	5542	16	0	6	Q2	2012	11.4600	4.9278	3.0000	1
62	5580	7	0	8	Q3	2012	7.6400	3.4380	2.0000	1
62	5597	3	0	12	Q4	2012	11.4600	5.0424	3.0000	1
62	5647	15	0	5	Q2	2012	7.6400	3.7436	2.0000	1
62	5809	13	0	11	Q4	2012	11.4600	4.6986	3.0000	1
62	5912	11	0	9	Q3	2012	11.4600	3.5526	3.0000	1
62	5923	23	1788	11	Q4	2012	15.2800	6.2648	4.0000	1
62	6119	24	1858	7	Q3	2012	11.4600	4.4694	3.0000	1
62	6136	6	0	7	Q3	2012	7.6400	3.1324	2.0000	1
62	6184	6	0	9	Q3	2012	15.2800	4.7368	4.0000	1
62	6439	7	501	1	Q1	2012	19.1000	6.3030	5.0000	1
62	6490	6	0	11	Q4	2012	11.4600	4.1256	3.0000	1
62	6518	6	502	1	Q1	2012	7.6400	3.2852	2.0000	1
62	6835	16	0	6	Q2	2012	11.4600	3.8964	3.0000	1
62	6949	15	0	2	Q1	2012	15.2800	7.4872	4.0000	1
62	7106	24	0	10	Q4	2012	11.4600	5.2716	3.0000	1
62	7132	13	0	3	Q1	2012	11.4600	4.1256	3.0000	1
62	7188	24	1869	12	Q4	2012	11.4600	4.9278	3.0000	1
62	7274	13	0	3	Q1	2012	11.4600	3.8964	3.0000	1
62	7305	24	1858	7	Q3	2012	7.6400	3.1324	2.0000	1
62	7529	17	0	10	Q4	2012	15.2800	5.1952	4.0000	1
62	7578	24	0	12	Q4	2012	7.6400	3.3616	2.0000	1
62	8207	13	0	1	Q1	2012	7.6400	2.5976	2.0000	1
62	8864	6	522	10	Q4	2012	15.2800	5.0424	4.0000	1
62	8966	3	202	8	Q3	2012	7.6400	2.8268	2.0000	1
62	9263	16	1225	7	Q3	2012	11.4600	4.8132	3.0000	1
62	9327	17	1304	7	Q3	2012	19.1000	8.7860	5.0000	1
62	9396	13	0	10	Q4	2012	15.2800	6.8760	4.0000	1
62	9673	13	980	3	Q1	2012	7.6400	2.6740	2.0000	1
62	10240	3	0	1	Q1	2012	15.2800	5.9592	4.0000	1
63	121	6	506	3	Q1	2012	8.8500	3.8055	3.0000	1
63	180	15	0	6	Q2	2012	8.8500	2.7435	3.0000	1
63	1529	13	0	11	Q4	2012	11.8000	4.1300	4.0000	1
63	1533	3	207	11	Q4	2012	8.8500	3.8055	3.0000	1
63	1633	3	0	7	Q3	2012	14.7500	6.6375	5.0000	1
63	1979	3	0	7	Q3	2012	8.8500	3.8055	3.0000	1
63	2065	17	1307	8	Q3	2012	8.8500	3.8055	3.0000	1
63	2237	7	0	6	Q2	2012	14.7500	6.4900	5.0000	1
63	2556	3	0	9	Q3	2012	8.8500	2.6550	3.0000	1
63	2610	7	0	6	Q2	2012	8.8500	3.3630	3.0000	1
63	2829	23	0	1	Q1	2012	8.8500	3.6285	3.0000	1
63	3046	13	0	11	Q4	2012	8.8500	3.8055	3.0000	1
63	3308	13	986	6	Q2	2012	8.8500	2.8320	3.0000	1
63	3497	17	1314	11	Q4	2012	5.9000	2.3600	2.0000	1
63	3538	11	0	12	Q4	2012	5.9000	2.5370	2.0000	1
63	3796	11	0	7	Q3	2012	5.9000	2.8320	2.0000	1
63	3796	11	0	12	Q4	2012	8.8500	3.2745	3.0000	1
63	4017	15	0	5	Q2	2012	8.8500	3.0975	3.0000	1
63	4021	16	0	12	Q4	2012	11.8000	4.9560	4.0000	1
63	4076	2	0	12	Q4	2012	2.9500	1.0915	1.0000	1
63	4122	15	1138	3	Q1	2012	8.8500	4.2480	3.0000	1
63	4315	17	0	7	Q3	2012	8.8500	3.4515	3.0000	1
63	4597	17	0	6	Q2	2012	5.9000	2.8320	2.0000	1
63	5410	17	1307	8	Q3	2012	8.8500	2.6550	3.0000	1
63	5616	17	0	2	Q1	2012	5.9000	2.7730	2.0000	1
63	5647	15	0	2	Q1	2012	5.9000	2.8910	2.0000	1
63	5696	15	0	11	Q4	2012	11.8000	3.6580	4.0000	1
63	5739	11	0	6	Q2	2012	8.8500	3.0090	3.0000	1
63	5766	16	1225	7	Q3	2012	8.8500	3.3630	3.0000	1
63	5827	11	0	4	Q2	2012	8.8500	3.1860	3.0000	1
63	6301	15	0	8	Q3	2012	8.8500	3.1860	3.0000	1
63	6307	16	0	3	Q1	2012	11.8000	4.7200	4.0000	1
63	6500	7	517	8	Q3	2012	5.9000	2.4190	2.0000	1
63	6592	13	0	3	Q1	2012	11.8000	5.5460	4.0000	1
63	6741	24	0	3	Q1	2012	8.8500	3.7170	3.0000	1
63	6792	13	976	1	Q1	2012	11.8000	4.6020	4.0000	1
63	6814	2	0	4	Q2	2012	5.9000	2.7730	2.0000	1
63	6850	15	0	10	Q4	2012	8.8500	2.9205	3.0000	1
63	6888	23	0	7	Q3	2012	8.8500	3.1860	3.0000	1
63	7072	16	0	7	Q3	2012	5.9000	2.1240	2.0000	1
63	7200	11	820	2	Q1	2012	11.8000	4.0120	4.0000	1
63	7341	24	0	2	Q1	2012	5.9000	2.4190	2.0000	1
63	7639	13	0	9	Q3	2012	11.8000	5.4280	4.0000	1
63	7832	7	0	3	Q1	2012	11.8000	5.1920	4.0000	1
63	8139	11	0	7	Q3	2012	11.8000	5.4280	4.0000	1
63	8574	15	0	10	Q4	2012	5.9000	2.5960	2.0000	1
63	8935	15	1157	12	Q4	2012	8.8500	2.8320	3.0000	1
63	9067	7	0	11	Q4	2012	8.8500	3.2745	3.0000	1
63	9169	23	0	11	Q4	2012	5.9000	2.4190	2.0000	1
63	9387	6	0	11	Q4	2012	11.8000	4.9560	4.0000	1
63	9510	16	1214	2	Q1	2012	8.8500	3.8055	3.0000	1
63	9727	7	0	3	Q1	2012	5.9000	2.1240	2.0000	1
63	9892	13	0	12	Q4	2012	8.8500	2.9205	3.0000	1
63	9991	6	521	10	Q4	2012	11.8000	4.3660	4.0000	1
64	557	7	0	9	Q3	2012	3.2200	1.2236	2.0000	1
64	596	15	0	11	Q4	2012	4.8300	2.1252	3.0000	1
64	769	16	0	9	Q3	2012	6.4400	2.9624	4.0000	1
64	897	7	0	8	Q3	2012	4.8300	1.5939	3.0000	1
64	992	7	0	9	Q3	2012	6.4400	2.9624	4.0000	1
64	1003	17	0	11	Q4	2012	3.2200	1.4812	2.0000	1
64	1070	3	0	6	Q2	2012	6.4400	2.8336	4.0000	1
64	1124	3	0	9	Q3	2012	6.4400	3.0912	4.0000	1
64	1297	16	0	11	Q4	2012	4.8300	1.7388	3.0000	1
64	1633	3	0	12	Q4	2012	6.4400	2.8980	4.0000	1
64	1914	24	1846	2	Q1	2012	4.8300	2.3667	3.0000	1
64	1987	13	0	1	Q1	2012	4.8300	1.6905	3.0000	1
64	2921	16	0	7	Q3	2012	4.8300	1.8354	3.0000	1
64	3312	15	0	4	Q2	2012	3.2200	1.3846	2.0000	1
64	3577	11	0	11	Q4	2012	6.4400	2.5760	4.0000	1
64	3586	11	0	6	Q2	2012	6.4400	3.0268	4.0000	1
64	4315	17	0	11	Q4	2012	4.8300	1.9320	3.0000	1
64	4443	11	0	2	Q1	2012	3.2200	1.5778	2.0000	1
64	4460	3	0	9	Q3	2012	4.8300	1.6422	3.0000	1
64	4649	17	0	12	Q4	2012	6.4400	2.1252	4.0000	1
64	4676	16	1235	11	Q4	2012	4.8300	2.2218	3.0000	1
64	4693	3	0	8	Q3	2012	4.8300	1.7388	3.0000	1
64	5809	13	984	5	Q2	2012	3.2200	1.5778	2.0000	1
64	6142	24	0	2	Q1	2012	6.4400	2.4472	4.0000	1
64	6194	11	0	5	Q2	2012	6.4400	2.8980	4.0000	1
64	6307	16	1235	11	Q4	2012	4.8300	2.2218	3.0000	1
64	6516	15	1138	3	Q1	2012	3.2200	1.1914	2.0000	1
64	7109	11	0	6	Q2	2012	3.2200	1.2880	2.0000	1
64	7149	13	1000	12	Q4	2012	4.8300	2.3667	3.0000	1
64	7269	13	0	7	Q3	2012	8.0500	2.8175	5.0000	1
64	7274	13	0	7	Q3	2012	4.8300	1.6422	3.0000	1
64	7290	24	1866	11	Q4	2012	3.2200	1.0626	2.0000	1
64	7297	11	0	11	Q4	2012	6.4400	2.4472	4.0000	1
64	7653	7	516	8	Q3	2012	8.0500	3.7835	5.0000	1
64	7856	6	508	4	Q2	2012	4.8300	1.7388	3.0000	1
64	7862	16	0	4	Q2	2012	6.4400	2.7048	4.0000	1
64	7985	24	1859	8	Q3	2012	6.4400	2.6404	4.0000	1
64	8149	24	0	3	Q1	2012	4.8300	2.2218	3.0000	1
64	8202	3	202	8	Q3	2012	4.8300	1.5939	3.0000	1
64	8951	24	0	9	Q3	2012	4.8300	2.3184	3.0000	1
64	8976	13	992	9	Q3	2012	4.8300	2.3667	3.0000	1
64	9115	11	829	6	Q2	2012	8.0500	2.8980	5.0000	1
64	9536	24	0	5	Q2	2012	3.2200	1.5134	2.0000	1
64	10161	6	0	4	Q2	2012	3.2200	1.4490	2.0000	1
65	137	7	0	9	Q3	2012	15.0400	7.5200	4.0000	1
65	159	11	0	5	Q2	2012	15.0400	5.1136	4.0000	1
65	176	14	1077	11	Q4	2012	3.7600	1.8048	1.0000	1
65	354	23	1773	4	Q2	2012	11.2800	3.4968	3.0000	1
65	454	17	0	1	Q1	2012	7.5200	3.2336	2.0000	1
65	465	13	0	11	Q4	2012	15.0400	6.1664	4.0000	1
65	543	13	0	7	Q3	2012	11.2800	5.5272	3.0000	1
65	545	13	0	5	Q2	2012	7.5200	2.7072	2.0000	1
65	578	24	0	4	Q2	2012	11.2800	3.4968	3.0000	1
65	813	11	0	12	Q4	2012	11.2800	5.4144	3.0000	1
65	819	13	0	12	Q4	2012	7.5200	3.3088	2.0000	1
65	1245	17	1312	10	Q4	2012	7.5200	2.8576	2.0000	1
65	1261	24	0	9	Q3	2012	7.5200	2.9328	2.0000	1
65	1297	16	1235	11	Q4	2012	18.8000	7.3320	5.0000	1
65	1310	16	1225	7	Q3	2012	11.2800	5.0760	3.0000	1
65	1328	17	0	9	Q3	2012	15.0400	4.9632	4.0000	1
65	1607	17	1307	8	Q3	2012	11.2800	3.4968	3.0000	1
65	1743	6	0	4	Q2	2012	7.5200	2.9328	2.0000	1
65	1865	7	0	6	Q2	2012	11.2800	3.6096	3.0000	1
65	1897	13	0	11	Q4	2012	11.2800	3.8352	3.0000	1
65	2039	11	829	6	Q2	2012	11.2800	4.0608	3.0000	1
65	2431	3	0	6	Q2	2012	7.5200	3.4592	2.0000	1
65	2640	7	0	4	Q2	2012	7.5200	2.6320	2.0000	1
65	2775	24	0	12	Q4	2012	11.2800	4.9632	3.0000	1
65	3322	6	0	6	Q2	2012	7.5200	2.7824	2.0000	1
65	3462	6	0	6	Q2	2012	7.5200	2.6320	2.0000	1
65	3711	3	190	3	Q1	2012	11.2800	5.3016	3.0000	1
65	4372	13	0	7	Q3	2012	11.2800	4.0608	3.0000	1
65	4391	16	0	4	Q2	2012	15.0400	5.1136	4.0000	1
65	4391	16	1235	11	Q4	2012	11.2800	4.0608	3.0000	1
65	4617	14	0	3	Q1	2012	11.2800	4.9632	3.0000	1
65	5130	11	0	5	Q2	2012	11.2800	5.3016	3.0000	1
65	5361	24	0	6	Q2	2012	15.0400	7.2192	4.0000	1
65	5410	17	1314	11	Q4	2012	15.0400	5.4144	4.0000	1
65	5542	16	0	11	Q4	2012	15.0400	5.1136	4.0000	1
65	5592	16	0	11	Q4	2012	7.5200	3.3840	2.0000	1
65	6688	7	0	10	Q4	2012	7.5200	3.4592	2.0000	1
65	7109	11	821	2	Q1	2012	11.2800	4.3992	3.0000	1
65	7171	23	0	4	Q2	2012	11.2800	3.6096	3.0000	1
65	7470	13	0	2	Q1	2012	11.2800	3.6096	3.0000	1
65	7470	13	0	6	Q2	2012	15.0400	5.5648	4.0000	1
65	7486	3	0	12	Q4	2012	7.5200	3.3840	2.0000	1
65	7736	6	0	10	Q4	2012	11.2800	4.7376	3.0000	1
65	7808	6	0	1	Q1	2012	11.2800	5.4144	3.0000	1
65	7813	17	0	8	Q3	2012	11.2800	4.0608	3.0000	1
65	8059	17	0	8	Q3	2012	11.2800	4.2864	3.0000	1
65	8108	17	0	4	Q2	2012	11.2800	4.9632	3.0000	1
65	8129	7	504	2	Q1	2012	11.2800	4.0608	3.0000	1
65	8277	2	0	8	Q3	2012	11.2800	3.9480	3.0000	1
65	8300	15	0	2	Q1	2012	7.5200	3.5344	2.0000	1
65	8359	17	1303	6	Q2	2012	15.0400	7.3696	4.0000	1
65	8384	15	0	11	Q4	2012	7.5200	3.2336	2.0000	1
65	9510	16	1235	11	Q4	2012	15.0400	5.5648	4.0000	1
65	9536	24	1845	1	Q1	2012	15.0400	5.2640	4.0000	1
65	10152	13	0	12	Q4	2012	11.2800	5.4144	3.0000	1
66	181	3	0	11	Q4	2012	6.8800	2.2016	2.0000	1
66	1310	16	0	6	Q2	2012	10.3200	3.7152	3.0000	1
66	1330	13	0	11	Q4	2012	6.8800	2.9584	2.0000	1
66	1529	13	0	6	Q2	2012	13.7600	6.1920	4.0000	1
66	1633	3	0	5	Q2	2012	17.2000	5.6760	5.0000	1
66	1669	11	0	1	Q1	2012	10.3200	3.3024	3.0000	1
66	1890	24	0	10	Q4	2012	13.7600	5.2288	4.0000	1
66	2039	11	0	3	Q1	2012	10.3200	4.1280	3.0000	1
66	2086	13	0	10	Q4	2012	10.3200	3.3024	3.0000	1
66	2105	24	1850	3	Q1	2012	10.3200	4.6440	3.0000	1
66	2511	17	0	6	Q2	2012	6.8800	2.9584	2.0000	1
66	2815	22	0	10	Q4	2012	3.4400	1.4448	1.0000	1
66	3039	6	0	9	Q3	2012	10.3200	3.3024	3.0000	1
66	3300	24	0	4	Q2	2012	13.7600	4.8160	4.0000	1
66	3498	24	0	2	Q1	2012	10.3200	4.0248	3.0000	1
66	3711	3	0	8	Q3	2012	10.3200	4.0248	3.0000	1
66	3728	13	0	12	Q4	2012	17.2000	6.1920	5.0000	1
66	3738	7	526	12	Q4	2012	13.7600	4.4032	4.0000	1
66	3813	6	0	6	Q2	2012	13.7600	5.5040	4.0000	1
66	3813	7	504	2	Q1	2012	13.7600	5.0912	4.0000	1
66	3898	6	0	6	Q2	2012	13.7600	6.1920	4.0000	1
66	4021	16	0	10	Q4	2012	13.7600	5.6416	4.0000	1
66	4105	3	0	3	Q1	2012	10.3200	4.3344	3.0000	1
66	4232	6	515	7	Q3	2012	10.3200	4.2312	3.0000	1
66	4391	16	1235	11	Q4	2012	10.3200	4.4376	3.0000	1
66	4643	22	0	1	Q1	2012	6.8800	3.2336	2.0000	1
66	4727	16	0	6	Q2	2012	13.7600	4.8160	4.0000	1
66	4925	16	0	8	Q3	2012	13.7600	5.3664	4.0000	1
66	5031	6	0	4	Q2	2012	13.7600	6.7424	4.0000	1
66	5085	24	1847	2	Q1	2012	10.3200	3.9216	3.0000	1
66	5088	13	0	4	Q2	2012	17.2000	5.5040	5.0000	1
66	5302	11	0	3	Q1	2012	13.7600	6.8800	4.0000	1
66	5473	24	0	8	Q3	2012	13.7600	5.5040	4.0000	1
66	5530	13	0	7	Q3	2012	10.3200	3.0960	3.0000	1
66	5766	16	0	1	Q1	2012	6.8800	2.2016	2.0000	1
66	5845	24	0	12	Q4	2012	13.7600	6.1920	4.0000	1
66	6087	13	0	7	Q3	2012	13.7600	4.2656	4.0000	1
66	6124	7	0	9	Q3	2012	6.8800	2.0640	2.0000	1
66	6133	11	0	8	Q3	2012	10.3200	3.9216	3.0000	1
66	6565	15	0	3	Q1	2012	10.3200	4.9536	3.0000	1
66	6567	15	1152	9	Q3	2012	6.8800	2.5456	2.0000	1
66	6736	17	0	6	Q2	2012	10.3200	4.4376	3.0000	1
66	7190	23	1769	3	Q1	2012	6.8800	3.1648	2.0000	1
66	7601	24	0	2	Q1	2012	6.8800	3.0960	2.0000	1
66	7617	11	0	2	Q1	2012	13.7600	4.9536	4.0000	1
66	7641	13	0	1	Q1	2012	10.3200	4.7472	3.0000	1
66	7721	13	0	7	Q3	2012	10.3200	4.8504	3.0000	1
66	7951	15	0	6	Q2	2012	10.3200	3.7152	3.0000	1
66	8220	24	0	1	Q1	2012	10.3200	3.0960	3.0000	1
66	8238	15	1154	10	Q4	2012	10.3200	5.0568	3.0000	1
66	8242	17	0	6	Q2	2012	6.8800	2.5456	2.0000	1
66	8266	7	0	11	Q4	2012	10.3200	3.7152	3.0000	1
66	8291	13	0	9	Q3	2012	13.7600	6.0544	4.0000	1
66	8292	14	1066	6	Q2	2012	6.8800	2.4080	2.0000	1
66	8373	13	0	8	Q3	2012	6.8800	2.6144	2.0000	1
66	8432	7	0	9	Q3	2012	10.3200	3.6120	3.0000	1
66	8578	23	1786	10	Q4	2012	13.7600	6.8800	4.0000	1
66	8701	15	0	3	Q1	2012	13.7600	4.9536	4.0000	1
66	9161	24	0	9	Q3	2012	13.7600	6.1920	4.0000	1
66	9441	14	0	2	Q1	2012	3.4400	1.1352	1.0000	1
66	9584	13	0	9	Q3	2012	10.3200	4.3344	3.0000	1
66	9675	24	1859	8	Q3	2012	10.3200	3.7152	3.0000	1
66	9688	7	523	11	Q4	2012	6.8800	2.6144	2.0000	1
66	9757	24	1869	12	Q4	2012	13.7600	6.6048	4.0000	1
66	9807	6	0	8	Q3	2012	10.3200	3.7152	3.0000	1
67	49	7	0	3	Q1	2012	3.7200	1.6740	2.0000	1
67	240	7	0	1	Q1	2012	5.5800	2.0088	3.0000	1
67	1178	11	0	7	Q3	2012	3.7200	1.6740	2.0000	1
67	1240	15	0	11	Q4	2012	5.5800	2.7900	3.0000	1
67	1297	16	0	4	Q2	2012	5.5800	2.2320	3.0000	1
67	1310	16	1231	9	Q3	2012	5.5800	1.9530	3.0000	1
67	1366	13	0	12	Q4	2012	5.5800	2.2878	3.0000	1
67	1385	15	0	7	Q3	2012	3.7200	1.3392	2.0000	1
67	1744	17	0	10	Q4	2012	7.4400	3.5712	4.0000	1
67	1832	23	1786	10	Q4	2012	3.7200	1.1532	2.0000	1
67	1864	15	0	12	Q4	2012	7.4400	3.5712	4.0000	1
67	2150	7	0	11	Q4	2012	3.7200	1.8600	2.0000	1
67	2201	16	0	9	Q3	2012	5.5800	2.1762	3.0000	1
67	2360	24	0	11	Q4	2012	9.3000	4.4640	5.0000	1
67	2378	16	0	10	Q4	2012	7.4400	2.6784	4.0000	1
67	2636	17	0	1	Q1	2012	5.5800	2.4552	3.0000	1
67	2715	15	0	7	Q3	2012	7.4400	2.9016	4.0000	1
67	2779	6	524	11	Q4	2012	7.4400	3.2736	4.0000	1
67	2839	15	0	6	Q2	2012	3.7200	1.3020	2.0000	1
67	2842	6	524	11	Q4	2012	3.7200	1.3764	2.0000	1
67	3099	7	0	7	Q3	2012	7.4400	3.6456	4.0000	1
67	3297	7	0	6	Q2	2012	5.5800	2.3436	3.0000	1
67	3497	17	1314	11	Q4	2012	7.4400	3.3480	4.0000	1
67	3549	22	1708	11	Q4	2012	3.7200	1.5252	2.0000	1
67	3647	13	980	3	Q1	2012	3.7200	1.7856	2.0000	1
67	3691	17	0	5	Q2	2012	3.7200	1.2648	2.0000	1
67	4315	17	0	1	Q1	2012	7.4400	3.1248	4.0000	1
67	4881	13	0	12	Q4	2012	5.5800	2.0646	3.0000	1
67	5429	11	0	3	Q1	2012	3.7200	1.8228	2.0000	1
67	5524	11	836	9	Q3	2012	5.5800	2.3994	3.0000	1
67	5944	3	0	12	Q4	2012	5.5800	1.9530	3.0000	1
67	5958	13	0	5	Q2	2012	7.4400	3.5712	4.0000	1
67	6020	24	0	11	Q4	2012	7.4400	2.6040	4.0000	1
67	6113	16	0	8	Q3	2012	3.7200	1.1532	2.0000	1
67	6155	15	1146	7	Q3	2012	5.5800	2.6784	3.0000	1
67	6494	6	0	4	Q2	2012	5.5800	2.7342	3.0000	1
67	6577	15	1149	8	Q3	2012	7.4400	3.4968	4.0000	1
67	6672	2	126	10	Q4	2012	3.7200	1.1904	2.0000	1
67	6888	23	0	7	Q3	2012	3.7200	1.2276	2.0000	1
67	7501	24	0	8	Q3	2012	3.7200	1.5252	2.0000	1
67	7858	15	0	11	Q4	2012	3.7200	1.3020	2.0000	1
67	7956	14	1065	6	Q2	2012	5.5800	2.2878	3.0000	1
67	7963	11	0	1	Q1	2012	9.3000	3.8130	5.0000	1
67	8013	14	0	3	Q1	2012	3.7200	1.1904	2.0000	1
67	8116	13	0	12	Q4	2012	7.4400	2.9760	4.0000	1
67	8117	11	841	12	Q4	2012	5.5800	2.7342	3.0000	1
67	8301	24	1853	5	Q2	2012	7.4400	2.3808	4.0000	1
67	8336	17	0	1	Q1	2012	5.5800	1.7298	3.0000	1
67	8411	15	0	9	Q3	2012	3.7200	1.7484	2.0000	1
67	8452	16	1235	11	Q4	2012	7.4400	2.8272	4.0000	1
67	8687	23	1769	3	Q1	2012	3.7200	1.3392	2.0000	1
67	9115	11	0	11	Q4	2012	7.4400	3.4968	4.0000	1
67	9351	2	0	6	Q2	2012	3.7200	1.5252	2.0000	1
67	9535	11	824	4	Q2	2012	7.4400	2.4552	4.0000	1
67	9629	24	0	12	Q4	2012	3.7200	1.1532	2.0000	1
67	9745	17	1312	10	Q4	2012	7.4400	2.8272	4.0000	1
67	9997	17	0	10	Q4	2012	5.5800	2.6226	3.0000	1
68	115	7	512	6	Q2	2012	7.1200	3.4888	2.0000	1
68	906	24	1851	4	Q2	2012	10.6800	3.3108	3.0000	1
68	950	13	0	6	Q2	2012	14.2400	4.6992	4.0000	1
68	1112	24	0	12	Q4	2012	10.6800	4.3788	3.0000	1
68	1157	24	0	3	Q1	2012	14.2400	5.1264	4.0000	1
68	1271	13	0	4	Q2	2012	7.1200	3.4888	2.0000	1
68	1548	13	0	8	Q3	2012	10.6800	3.7380	3.0000	1
68	1813	17	1303	6	Q2	2012	7.1200	2.2784	2.0000	1
68	2011	23	0	7	Q3	2012	14.2400	6.2656	4.0000	1
68	2371	16	0	1	Q1	2012	7.1200	3.4888	2.0000	1
68	2869	6	0	12	Q4	2012	10.6800	4.9128	3.0000	1
68	2869	7	0	4	Q2	2012	10.6800	4.6992	3.0000	1
68	3145	24	0	3	Q1	2012	7.1200	2.4208	2.0000	1
68	3160	17	1314	11	Q4	2012	7.1200	3.1328	2.0000	1
68	3695	13	0	11	Q4	2012	10.6800	3.3108	3.0000	1
68	4081	24	1845	1	Q1	2012	7.1200	2.5632	2.0000	1
68	4211	11	0	12	Q4	2012	10.6800	4.8060	3.0000	1
68	4295	11	0	6	Q2	2012	10.6800	3.4176	3.0000	1
68	4340	17	0	11	Q4	2012	10.6800	3.9516	3.0000	1
68	4460	3	201	8	Q3	2012	10.6800	3.6312	3.0000	1
68	4490	13	986	6	Q2	2012	7.1200	3.3464	2.0000	1
68	4563	2	112	3	Q1	2012	7.1200	2.2784	2.0000	1
68	4589	13	0	2	Q1	2012	10.6800	5.2332	3.0000	1
68	4606	3	0	5	Q2	2012	10.6800	3.4176	3.0000	1
68	5113	7	0	7	Q3	2012	10.6800	5.2332	3.0000	1
68	5313	24	0	3	Q1	2012	7.1200	3.2752	2.0000	1
68	5433	13	0	9	Q3	2012	7.1200	2.9904	2.0000	1
68	6084	11	0	11	Q4	2012	7.1200	3.5600	2.0000	1
68	6606	24	0	7	Q3	2012	10.6800	5.2332	3.0000	1
68	6666	17	0	2	Q1	2012	7.1200	3.2752	2.0000	1
68	7171	23	0	2	Q1	2012	10.6800	4.6992	3.0000	1
68	7419	14	1066	6	Q2	2012	3.5600	1.2460	1.0000	1
68	7547	24	1856	6	Q2	2012	10.6800	3.9516	3.0000	1
68	7608	15	0	5	Q2	2012	7.1200	3.4176	2.0000	1
68	7696	23	0	8	Q3	2012	14.2400	4.6992	4.0000	1
68	7704	3	0	1	Q1	2012	10.6800	4.6992	3.0000	1
68	7906	13	0	1	Q1	2012	10.6800	3.3108	3.0000	1
68	7948	17	1293	1	Q1	2012	17.8000	6.0520	5.0000	1
68	7956	14	0	4	Q2	2012	7.1200	2.7056	2.0000	1
68	7989	17	1312	10	Q4	2012	10.6800	4.8060	3.0000	1
68	8048	6	0	4	Q2	2012	14.2400	6.6928	4.0000	1
68	8329	15	0	8	Q3	2012	7.1200	2.4920	2.0000	1
68	8511	16	0	2	Q1	2012	10.6800	3.5244	3.0000	1
68	8843	13	0	3	Q1	2012	14.2400	4.5568	4.0000	1
68	9271	17	0	5	Q2	2012	10.6800	4.9128	3.0000	1
68	9309	17	0	9	Q3	2012	14.2400	5.6960	4.0000	1
68	9318	16	1216	2	Q1	2012	10.6800	4.8060	3.0000	1
68	9318	16	1225	7	Q3	2012	10.6800	4.3788	3.0000	1
68	9345	15	0	2	Q1	2012	7.1200	2.1360	2.0000	1
68	9348	15	0	11	Q4	2012	17.8000	8.1880	5.0000	1
68	9815	16	0	12	Q4	2012	14.2400	4.9840	4.0000	1
68	9997	17	0	7	Q3	2012	10.6800	4.5924	3.0000	1
68	10026	13	0	11	Q4	2012	14.2400	5.4112	4.0000	1
69	187	13	976	1	Q1	2012	9.3000	3.7200	3.0000	1
69	454	17	1314	11	Q4	2012	6.2000	2.6040	2.0000	1
69	781	24	1858	7	Q3	2012	9.3000	3.9990	3.0000	1
69	964	6	0	4	Q2	2012	12.4000	5.3320	4.0000	1
69	1069	7	0	10	Q4	2012	9.3000	2.8830	3.0000	1
69	1191	24	0	1	Q1	2012	6.2000	2.7280	2.0000	1
69	1829	11	0	11	Q4	2012	12.4000	4.5880	4.0000	1
69	2075	13	0	9	Q3	2012	12.4000	5.9520	4.0000	1
69	2084	17	0	6	Q2	2012	6.2000	2.2940	2.0000	1
69	2466	24	0	7	Q3	2012	12.4000	5.8280	4.0000	1
69	2737	15	0	8	Q3	2012	12.4000	4.3400	4.0000	1
69	2756	3	195	5	Q2	2012	6.2000	2.9140	2.0000	1
69	3163	6	0	9	Q3	2012	12.4000	4.4640	4.0000	1
69	3632	7	0	1	Q1	2012	12.4000	5.8280	4.0000	1
69	3838	17	0	12	Q4	2012	15.5000	7.7500	5.0000	1
69	4221	17	0	12	Q4	2012	9.3000	4.5570	3.0000	1
69	4315	17	1304	7	Q3	2012	6.2000	2.3560	2.0000	1
69	4450	6	526	12	Q4	2012	12.4000	4.5880	4.0000	1
69	4543	13	0	11	Q4	2012	12.4000	5.3320	4.0000	1
69	4597	17	0	4	Q2	2012	6.2000	2.2320	2.0000	1
69	4691	17	0	1	Q1	2012	6.2000	2.2320	2.0000	1
69	4824	3	0	4	Q2	2012	15.5000	7.2850	5.0000	1
69	5050	17	0	7	Q3	2012	6.2000	2.6660	2.0000	1
69	5126	24	0	12	Q4	2012	12.4000	4.0920	4.0000	1
69	5407	24	0	6	Q2	2012	9.3000	3.8130	3.0000	1
69	5592	16	1235	11	Q4	2012	6.2000	2.6660	2.0000	1
69	5667	24	0	2	Q1	2012	9.3000	4.2780	3.0000	1
69	5760	13	0	12	Q4	2012	6.2000	2.7900	2.0000	1
69	5766	16	1228	8	Q3	2012	12.4000	3.9680	4.0000	1
69	5935	6	0	4	Q2	2012	12.4000	4.8360	4.0000	1
69	6112	11	829	6	Q2	2012	12.4000	5.5800	4.0000	1
69	6223	7	0	7	Q3	2012	6.2000	2.6660	2.0000	1
69	6278	7	0	1	Q1	2012	6.2000	2.8520	2.0000	1
69	6745	7	0	6	Q2	2012	6.2000	2.1700	2.0000	1
69	6760	17	0	1	Q1	2012	6.2000	2.1080	2.0000	1
69	7196	7	0	4	Q2	2012	9.3000	3.7200	3.0000	1
69	7275	17	0	7	Q3	2012	9.3000	3.9990	3.0000	1
69	7618	11	829	6	Q2	2012	12.4000	4.3400	4.0000	1
69	7639	13	0	10	Q4	2012	12.4000	5.7040	4.0000	1
69	7696	23	0	3	Q1	2012	12.4000	4.5880	4.0000	1
69	8068	3	0	12	Q4	2012	6.2000	2.2940	2.0000	1
69	8254	17	0	7	Q3	2012	12.4000	5.9520	4.0000	1
69	8272	6	523	11	Q4	2012	9.3000	3.6270	3.0000	1
69	8319	24	1859	8	Q3	2012	9.3000	2.7900	3.0000	1
69	8324	24	0	5	Q2	2012	6.2000	2.5420	2.0000	1
69	8324	24	0	9	Q3	2012	6.2000	2.5420	2.0000	1
69	9184	3	0	7	Q3	2012	6.2000	2.2320	2.0000	1
69	9602	11	0	4	Q2	2012	9.3000	3.0690	3.0000	1
69	9837	17	0	6	Q2	2012	9.3000	3.9060	3.0000	1
69	10174	7	0	7	Q3	2012	12.4000	5.3320	4.0000	1
70	19	14	0	7	Q3	2012	1.9400	0.7954	2.0000	1
70	293	22	0	9	Q3	2012	1.9400	0.6014	2.0000	1
70	453	24	1845	1	Q1	2012	1.9400	0.5820	2.0000	1
70	504	13	0	2	Q1	2012	1.9400	0.7178	2.0000	1
70	511	16	0	5	Q2	2012	2.9100	0.9312	3.0000	1
70	624	15	0	9	Q3	2012	2.9100	1.2513	3.0000	1
70	897	7	0	8	Q3	2012	2.9100	1.1058	3.0000	1
70	1071	13	0	5	Q2	2012	2.9100	1.0185	3.0000	1
70	1387	11	821	3	Q1	2012	3.8800	1.6296	4.0000	1
70	1414	7	0	6	Q2	2012	2.9100	1.3677	3.0000	1
70	1430	3	0	11	Q4	2012	1.9400	0.6014	2.0000	1
70	1490	13	0	12	Q4	2012	2.9100	0.9021	3.0000	1
70	1624	11	826	5	Q2	2012	3.8800	1.2028	4.0000	1
70	1635	15	0	1	Q1	2012	2.9100	1.4259	3.0000	1
70	1798	3	0	6	Q2	2012	1.9400	0.8730	2.0000	1
70	1994	15	0	11	Q4	2012	2.9100	1.3386	3.0000	1
70	2132	15	0	12	Q4	2012	1.9400	0.8342	2.0000	1
70	2241	6	0	4	Q2	2012	1.9400	0.6984	2.0000	1
70	2255	24	1866	11	Q4	2012	2.9100	1.0185	3.0000	1
70	2296	6	0	4	Q2	2012	2.9100	1.4259	3.0000	1
70	2570	16	1220	4	Q2	2012	2.9100	1.2804	3.0000	1
70	2667	7	0	10	Q4	2012	3.8800	1.2804	4.0000	1
70	2878	3	0	10	Q4	2012	2.9100	1.0476	3.0000	1
70	2918	17	1314	11	Q4	2012	2.9100	1.3386	3.0000	1
70	3591	24	0	1	Q1	2012	2.9100	1.1349	3.0000	1
70	3799	13	976	1	Q1	2012	1.9400	0.8924	2.0000	1
70	4088	24	0	12	Q4	2012	1.9400	0.9312	2.0000	1
70	4094	16	0	3	Q1	2012	3.8800	1.6296	4.0000	1
70	4094	16	0	10	Q4	2012	1.9400	0.8536	2.0000	1
70	4340	17	0	8	Q3	2012	2.9100	0.9312	3.0000	1
70	4401	11	0	7	Q3	2012	2.9100	1.0767	3.0000	1
70	4449	7	0	6	Q2	2012	3.8800	1.7460	4.0000	1
70	4487	2	0	6	Q2	2012	1.9400	0.6790	2.0000	1
70	4541	3	0	11	Q4	2012	2.9100	1.0476	3.0000	1
70	4867	24	0	3	Q1	2012	3.8800	1.9400	4.0000	1
70	5026	17	0	12	Q4	2012	1.9400	0.6790	2.0000	1
70	5085	24	1847	2	Q1	2012	3.8800	1.6684	4.0000	1
70	5255	24	0	10	Q4	2012	1.9400	0.7760	2.0000	1
70	5346	3	0	12	Q4	2012	2.9100	1.4259	3.0000	1
70	5490	7	517	8	Q3	2012	1.9400	0.8342	2.0000	1
70	5592	16	1216	2	Q1	2012	1.9400	0.8730	2.0000	1
70	5612	15	0	1	Q1	2012	3.8800	1.8236	4.0000	1
70	5678	6	0	12	Q4	2012	2.9100	1.2513	3.0000	1
70	5686	3	0	1	Q1	2012	1.9400	0.7954	2.0000	1
70	5781	11	0	3	Q1	2012	2.9100	0.8730	3.0000	1
70	5870	14	0	8	Q3	2012	1.9400	0.6790	2.0000	1
70	6001	17	0	9	Q3	2012	2.9100	1.2804	3.0000	1
70	6171	15	0	5	Q2	2012	3.8800	1.4744	4.0000	1
70	6696	6	0	1	Q1	2012	2.9100	0.8730	3.0000	1
70	7130	24	0	10	Q4	2012	2.9100	1.3968	3.0000	1
70	7384	3	0	11	Q4	2012	3.8800	1.2416	4.0000	1
70	7641	13	0	1	Q1	2012	2.9100	1.3677	3.0000	1
70	8091	13	0	3	Q1	2012	3.8800	1.7460	4.0000	1
70	8222	15	1143	5	Q2	2012	2.9100	0.9312	3.0000	1
70	8266	7	0	11	Q4	2012	2.9100	1.1058	3.0000	1
70	8269	13	980	3	Q1	2012	1.9400	0.9118	2.0000	1
70	8317	7	0	3	Q1	2012	2.9100	1.1349	3.0000	1
70	8477	3	0	5	Q2	2012	1.9400	0.6984	2.0000	1
70	8695	15	0	1	Q1	2012	4.8500	1.5035	5.0000	1
70	8701	15	0	3	Q1	2012	3.8800	1.4744	4.0000	1
70	8844	13	0	11	Q4	2012	2.9100	1.2222	3.0000	1
70	8912	6	0	9	Q3	2012	2.9100	0.9894	3.0000	1
70	9300	6	523	11	Q4	2012	3.8800	1.6684	4.0000	1
70	9419	11	818	1	Q1	2012	3.8800	1.6684	4.0000	1
70	9433	24	0	5	Q2	2012	2.9100	1.2222	3.0000	1
70	9433	24	0	9	Q3	2012	2.9100	1.2222	3.0000	1
70	9728	16	1225	7	Q3	2012	3.8800	1.3580	4.0000	1
70	9747	13	0	10	Q4	2012	2.9100	1.2222	3.0000	1
70	9810	24	0	3	Q1	2012	3.8800	1.1640	4.0000	1
70	10233	24	0	2	Q1	2012	1.9400	0.9118	2.0000	1
71	230	2	0	10	Q4	2012	2.7600	1.1868	1.0000	1
71	260	11	0	10	Q4	2012	8.2800	3.0636	3.0000	1
71	363	7	0	1	Q1	2012	11.0400	3.7536	4.0000	1
71	461	11	0	11	Q4	2012	5.5200	2.5944	2.0000	1
71	475	7	523	11	Q4	2012	5.5200	2.0976	2.0000	1
71	806	17	1297	3	Q1	2012	11.0400	5.4096	4.0000	1
71	1015	7	0	9	Q3	2012	8.2800	4.1400	3.0000	1
71	1075	24	0	5	Q2	2012	8.2800	2.8980	3.0000	1
71	1312	3	185	1	Q1	2012	5.5200	2.6496	2.0000	1
71	1319	11	820	2	Q1	2012	11.0400	5.4096	4.0000	1
71	1660	13	0	3	Q1	2012	5.5200	2.5392	2.0000	1
71	1747	24	1869	12	Q4	2012	5.5200	2.0424	2.0000	1
71	1874	17	0	5	Q2	2012	11.0400	3.5328	4.0000	1
71	2052	13	0	5	Q2	2012	8.2800	3.5604	3.0000	1
71	2151	13	0	12	Q4	2012	8.2800	2.6496	3.0000	1
71	2368	3	210	12	Q4	2012	11.0400	3.7536	4.0000	1
71	2941	24	1847	2	Q1	2012	5.5200	2.3736	2.0000	1
71	2947	17	0	3	Q1	2012	8.2800	3.1464	3.0000	1
71	3004	7	0	7	Q3	2012	8.2800	3.1464	3.0000	1
71	3005	7	0	4	Q2	2012	11.0400	4.9680	4.0000	1
71	3164	7	526	12	Q4	2012	8.2800	3.6432	3.0000	1
71	3263	14	1062	4	Q2	2012	5.5200	2.1528	2.0000	1
71	3529	13	976	1	Q1	2012	5.5200	1.9872	2.0000	1
71	3593	3	0	1	Q1	2012	8.2800	2.8152	3.0000	1
71	4069	17	0	2	Q1	2012	11.0400	5.1888	4.0000	1
71	4351	23	0	2	Q1	2012	13.8000	4.5540	5.0000	1
71	4445	17	0	6	Q2	2012	11.0400	3.7536	4.0000	1
71	5766	16	0	6	Q2	2012	5.5200	2.0424	2.0000	1
71	5944	3	0	5	Q2	2012	11.0400	5.4096	4.0000	1
71	6079	13	980	3	Q1	2012	5.5200	2.7048	2.0000	1
71	6133	11	0	11	Q4	2012	11.0400	4.8576	4.0000	1
71	6337	14	1077	11	Q4	2012	2.7600	0.8280	1.0000	1
71	6960	17	0	12	Q4	2012	11.0400	3.5328	4.0000	1
71	7065	17	0	6	Q2	2012	11.0400	4.7472	4.0000	1
71	7455	13	0	7	Q3	2012	5.5200	1.9872	2.0000	1
71	7481	6	0	7	Q3	2012	8.2800	3.8916	3.0000	1
71	7580	17	1304	7	Q3	2012	8.2800	2.9808	3.0000	1
71	7582	11	0	6	Q2	2012	11.0400	4.9680	4.0000	1
71	8091	13	0	9	Q3	2012	11.0400	4.9680	4.0000	1
71	8133	7	0	9	Q3	2012	8.2800	2.9808	3.0000	1
71	8214	6	0	12	Q4	2012	8.2800	3.1464	3.0000	1
71	8281	17	1307	8	Q3	2012	8.2800	2.6496	3.0000	1
71	8284	22	0	5	Q2	2012	5.5200	2.2080	2.0000	1
71	8414	17	0	4	Q2	2012	11.0400	4.9680	4.0000	1
71	8758	7	504	2	Q1	2012	5.5200	2.1528	2.0000	1
71	9417	15	0	10	Q4	2012	8.2800	3.3120	3.0000	1
71	9858	24	0	12	Q4	2012	13.8000	5.6580	5.0000	1
71	10091	17	0	11	Q4	2012	11.0400	4.6368	4.0000	1
71	10182	24	1869	12	Q4	2012	8.2800	2.6496	3.0000	1
72	453	24	0	11	Q4	2012	8.2200	2.7126	3.0000	1
72	739	23	0	2	Q1	2012	10.9600	4.2744	4.0000	1
72	993	13	0	7	Q3	2012	5.4800	1.6988	2.0000	1
72	1071	13	0	3	Q1	2012	8.2200	2.9592	3.0000	1
72	1567	16	0	10	Q4	2012	8.2200	3.9456	3.0000	1
72	1741	11	818	1	Q1	2012	10.9600	5.1512	4.0000	1
72	1771	2	0	1	Q1	2012	5.4800	2.0824	2.0000	1
72	2151	13	988	7	Q3	2012	8.2200	2.9592	3.0000	1
72	2246	13	0	1	Q1	2012	10.9600	4.3840	4.0000	1
72	2383	2	0	11	Q4	2012	2.7400	1.1234	1.0000	1
72	3097	7	0	3	Q1	2012	8.2200	3.2058	3.0000	1
72	3160	17	1293	1	Q1	2012	10.9600	4.6032	4.0000	1
72	3352	7	0	9	Q3	2012	10.9600	3.5072	4.0000	1
72	3471	11	0	2	Q1	2012	5.4800	1.8632	2.0000	1
72	3742	11	837	10	Q4	2012	10.9600	4.6032	4.0000	1
72	3755	24	0	11	Q4	2012	10.9600	4.8224	4.0000	1
72	3799	13	0	6	Q2	2012	8.2200	3.5346	3.0000	1
72	3941	3	0	4	Q2	2012	8.2200	2.6304	3.0000	1
72	4010	11	0	10	Q4	2012	8.2200	3.2880	3.0000	1
72	4029	17	0	12	Q4	2012	5.4800	2.3564	2.0000	1
72	4234	3	0	7	Q3	2012	10.9600	3.3976	4.0000	1
72	4413	13	0	10	Q4	2012	5.4800	1.9728	2.0000	1
72	4431	13	0	6	Q2	2012	10.9600	3.9456	4.0000	1
72	4431	13	976	1	Q1	2012	10.9600	3.9456	4.0000	1
72	4621	24	1860	8	Q3	2012	5.4800	2.2468	2.0000	1
72	4846	17	0	8	Q3	2012	10.9600	3.8360	4.0000	1
72	5018	6	0	10	Q4	2012	13.7000	4.7950	5.0000	1
72	5216	3	0	3	Q1	2012	5.4800	1.9728	2.0000	1
72	5637	15	0	10	Q4	2012	8.2200	3.7812	3.0000	1
72	5842	24	0	9	Q3	2012	5.4800	2.0824	2.0000	1
72	6291	3	0	8	Q3	2012	8.2200	3.0414	3.0000	1
72	6490	6	0	11	Q4	2012	5.4800	2.6304	2.0000	1
72	6995	11	829	6	Q2	2012	8.2200	3.9456	3.0000	1
72	7051	16	0	12	Q4	2012	8.2200	2.7948	3.0000	1
72	7813	17	0	8	Q3	2012	8.2200	3.4524	3.0000	1
72	7849	3	0	3	Q1	2012	8.2200	2.6304	3.0000	1
72	8181	17	1297	3	Q1	2012	8.2200	2.9592	3.0000	1
72	8414	17	0	1	Q1	2012	5.4800	1.7536	2.0000	1
72	8772	11	0	4	Q2	2012	5.4800	2.4112	2.0000	1
72	8814	13	0	11	Q4	2012	8.2200	3.6168	3.0000	1
72	9016	23	0	9	Q3	2012	8.2200	3.7812	3.0000	1
72	9125	13	992	9	Q3	2012	8.2200	2.7948	3.0000	1
72	9346	15	1146	7	Q3	2012	8.2200	2.7126	3.0000	1
72	9358	15	0	7	Q3	2012	5.4800	2.4660	2.0000	1
72	9815	16	1236	12	Q4	2012	10.9600	5.1512	4.0000	1
72	9860	11	0	8	Q3	2012	8.2200	2.7126	3.0000	1
72	10273	17	1304	7	Q3	2012	8.2200	3.6990	3.0000	1
73	293	22	1694	4	Q2	2012	6.9900	2.6562	3.0000	1
73	432	15	0	6	Q2	2012	9.3200	4.0076	4.0000	1
73	569	23	1788	11	Q4	2012	4.6600	2.1436	2.0000	1
73	665	7	504	2	Q1	2012	6.9900	2.3766	3.0000	1
73	758	22	0	1	Q1	2012	4.6600	1.8174	2.0000	1
73	973	24	0	8	Q3	2012	6.9900	3.0057	3.0000	1
73	1035	13	0	8	Q3	2012	9.3200	3.9144	4.0000	1
73	1102	7	0	10	Q4	2012	6.9900	3.2853	3.0000	1
73	1138	6	0	4	Q2	2012	9.3200	4.6600	4.0000	1
73	1146	24	1856	6	Q2	2012	9.3200	4.3804	4.0000	1
73	1253	13	986	6	Q2	2012	6.9900	2.2368	3.0000	1
73	1622	3	204	9	Q3	2012	9.3200	4.2872	4.0000	1
73	1720	16	1214	2	Q1	2012	4.6600	2.2368	2.0000	1
73	1750	7	505	2	Q1	2012	6.9900	2.2368	3.0000	1
73	2019	16	0	10	Q4	2012	9.3200	4.2872	4.0000	1
73	2298	3	0	8	Q3	2012	4.6600	1.6310	2.0000	1
73	2553	16	0	5	Q2	2012	11.6500	5.0095	5.0000	1
73	2815	22	0	10	Q4	2012	4.6600	1.4912	2.0000	1
73	3060	2	0	11	Q4	2012	4.6600	1.7708	2.0000	1
73	3236	15	0	9	Q3	2012	9.3200	4.4736	4.0000	1
73	3667	15	0	3	Q1	2012	6.9900	2.7960	3.0000	1
73	3863	6	0	3	Q1	2012	9.3200	3.8212	4.0000	1
73	4065	3	0	11	Q4	2012	9.3200	4.1008	4.0000	1
73	4090	6	0	2	Q1	2012	6.9900	3.4251	3.0000	1
73	4180	7	0	5	Q2	2012	6.9900	2.5863	3.0000	1
73	4487	2	0	5	Q2	2012	2.3300	0.8155	1.0000	1
73	4676	16	0	9	Q3	2012	4.6600	1.5378	2.0000	1
73	4690	13	0	10	Q4	2012	9.3200	4.0076	4.0000	1
73	4868	16	0	8	Q3	2012	6.9900	2.9358	3.0000	1
73	5295	16	1228	8	Q3	2012	9.3200	4.4736	4.0000	1
73	5484	6	0	7	Q3	2012	6.9900	3.3552	3.0000	1
73	5766	16	0	3	Q1	2012	9.3200	3.2620	4.0000	1
73	5895	17	0	4	Q2	2012	6.9900	3.3552	3.0000	1
73	6065	15	1157	12	Q4	2012	6.9900	2.2368	3.0000	1
73	6352	13	986	6	Q2	2012	4.6600	1.4446	2.0000	1
73	6551	11	0	6	Q2	2012	9.3200	2.8892	4.0000	1
73	6570	11	836	9	Q3	2012	4.6600	2.1902	2.0000	1
73	6647	17	0	7	Q3	2012	6.9900	2.7960	3.0000	1
73	6760	17	0	12	Q4	2012	4.6600	1.5844	2.0000	1
73	6760	17	1307	8	Q3	2012	4.6600	1.5844	2.0000	1
73	7072	16	1216	2	Q1	2012	9.3200	3.2620	4.0000	1
73	7952	13	0	8	Q3	2012	6.9900	2.5164	3.0000	1
73	7959	15	0	11	Q4	2012	6.9900	2.3766	3.0000	1
73	8018	11	842	12	Q4	2012	9.3200	3.1688	4.0000	1
73	8140	13	0	12	Q4	2012	6.9900	2.8659	3.0000	1
73	8477	3	0	11	Q4	2012	4.6600	1.6776	2.0000	1
73	8541	15	0	5	Q2	2012	4.6600	1.5844	2.0000	1
73	8601	7	0	3	Q1	2012	6.9900	2.7960	3.0000	1
73	8608	24	0	6	Q2	2012	6.9900	2.2368	3.0000	1
73	9318	16	0	9	Q3	2012	9.3200	3.8212	4.0000	1
73	9639	17	0	3	Q1	2012	6.9900	2.1669	3.0000	1
73	9728	16	1220	4	Q2	2012	4.6600	2.2834	2.0000	1
73	9974	6	511	5	Q2	2012	4.6600	1.5378	2.0000	1
74	543	13	0	9	Q3	2012	3.1400	1.1932	2.0000	1
74	658	7	0	3	Q1	2012	4.7100	2.1666	3.0000	1
74	709	6	0	6	Q2	2012	3.1400	1.1618	2.0000	1
74	795	14	1078	12	Q4	2012	3.1400	1.0676	2.0000	1
74	916	7	0	9	Q3	2012	6.2800	2.6376	4.0000	1
74	1089	15	0	5	Q2	2012	6.2800	2.2608	4.0000	1
74	1161	15	0	10	Q4	2012	6.2800	1.9468	4.0000	1
74	1233	15	0	6	Q2	2012	4.7100	1.9782	3.0000	1
74	1297	16	0	1	Q1	2012	4.7100	1.4601	3.0000	1
74	1297	16	0	11	Q4	2012	3.1400	1.5072	2.0000	1
74	1548	13	0	10	Q4	2012	3.1400	1.1304	2.0000	1
74	1698	7	504	2	Q1	2012	4.7100	1.4601	3.0000	1
74	1923	11	0	5	Q2	2012	4.7100	2.2137	3.0000	1
74	1932	15	0	5	Q2	2012	4.7100	2.3079	3.0000	1
74	1979	3	0	11	Q4	2012	7.8500	2.6690	5.0000	1
74	2019	16	1235	11	Q4	2012	6.2800	2.1352	4.0000	1
74	3100	6	526	12	Q4	2012	6.2800	2.7632	4.0000	1
74	3773	17	0	1	Q1	2012	4.7100	2.1195	3.0000	1
74	4234	3	0	7	Q3	2012	4.7100	1.6956	3.0000	1
74	4307	6	0	5	Q2	2012	4.7100	2.2137	3.0000	1
74	4391	16	1231	9	Q3	2012	6.2800	2.3236	4.0000	1
74	4541	3	0	12	Q4	2012	6.2800	2.3236	4.0000	1
74	5499	11	0	8	Q3	2012	4.7100	1.6956	3.0000	1
74	5873	2	0	3	Q1	2012	3.1400	1.3502	2.0000	1
74	5929	15	0	8	Q3	2012	6.2800	3.0144	4.0000	1
74	6221	24	0	12	Q4	2012	3.1400	1.5386	2.0000	1
74	6799	17	0	8	Q3	2012	3.1400	1.0676	2.0000	1
74	7003	15	0	9	Q3	2012	6.2800	2.6376	4.0000	1
74	7377	3	199	7	Q3	2012	4.7100	1.9782	3.0000	1
74	7377	3	210	12	Q4	2012	6.2800	1.9468	4.0000	1
74	7416	13	988	7	Q3	2012	6.2800	2.1980	4.0000	1
74	7852	11	0	9	Q3	2012	4.7100	1.8369	3.0000	1
74	7862	16	0	3	Q1	2012	7.8500	2.5120	5.0000	1
74	8108	17	0	10	Q4	2012	6.2800	2.1980	4.0000	1
74	8254	17	0	12	Q4	2012	3.1400	1.2874	2.0000	1
74	8348	24	0	7	Q3	2012	4.7100	2.1666	3.0000	1
74	8414	17	1303	6	Q2	2012	3.1400	0.9420	2.0000	1
74	8495	15	1143	5	Q2	2012	3.1400	1.1304	2.0000	1
74	8526	11	833	8	Q3	2012	6.2800	1.9468	4.0000	1
74	8668	13	0	7	Q3	2012	6.2800	3.0772	4.0000	1
74	8717	17	1294	2	Q1	2012	4.7100	1.4601	3.0000	1
74	8749	13	0	10	Q4	2012	4.7100	2.0253	3.0000	1
74	8814	13	0	2	Q1	2012	4.7100	2.1666	3.0000	1
74	8824	15	0	3	Q1	2012	6.2800	2.5120	4.0000	1
74	8851	6	518	8	Q3	2012	3.1400	1.0676	2.0000	1
74	9014	13	980	3	Q1	2012	3.1400	1.3188	2.0000	1
74	9187	17	0	8	Q3	2012	6.2800	2.9516	4.0000	1
74	9200	16	1235	11	Q4	2012	4.7100	2.1666	3.0000	1
74	9977	11	836	9	Q3	2012	4.7100	1.4601	3.0000	1
74	10026	13	0	3	Q1	2012	4.7100	2.1666	3.0000	1
74	10035	15	0	1	Q1	2012	3.1400	1.0362	2.0000	1
74	10243	17	0	11	Q4	2012	3.1400	1.3188	2.0000	1
74	10277	11	0	4	Q2	2012	6.2800	2.7632	4.0000	1
75	395	24	0	3	Q1	2012	1.3600	0.4216	2.0000	1
75	604	14	0	2	Q1	2012	1.3600	0.6664	2.0000	1
75	992	7	0	12	Q4	2012	2.0400	0.8568	3.0000	1
75	1280	6	0	6	Q2	2012	2.0400	0.9588	3.0000	1
75	1310	16	1228	8	Q3	2012	2.0400	0.9588	3.0000	1
75	1442	3	210	12	Q4	2012	2.7200	1.0608	4.0000	1
75	1793	13	0	12	Q4	2012	2.0400	0.9180	3.0000	1
75	1850	16	1225	7	Q3	2012	2.0400	1.0200	3.0000	1
75	1896	22	0	5	Q2	2012	0.6800	0.2380	1.0000	1
75	1964	11	0	11	Q4	2012	2.0400	0.6732	3.0000	1
75	2052	13	0	10	Q4	2012	2.7200	0.9248	4.0000	1
75	2135	22	1708	11	Q4	2012	1.3600	0.6528	2.0000	1
75	2335	17	0	8	Q3	2012	1.3600	0.4080	2.0000	1
75	2640	7	504	2	Q1	2012	1.3600	0.4896	2.0000	1
75	3036	24	0	9	Q3	2012	2.0400	0.9180	3.0000	1
75	3294	24	0	5	Q2	2012	1.3600	0.6120	2.0000	1
75	3337	7	0	12	Q4	2012	2.0400	0.8160	3.0000	1
75	3605	14	0	5	Q2	2012	0.6800	0.2924	1.0000	1
75	3773	17	1311	10	Q4	2012	2.7200	1.2512	4.0000	1
75	4094	16	0	9	Q3	2012	2.7200	1.1424	4.0000	1
75	4099	17	0	10	Q4	2012	2.0400	0.8160	3.0000	1
75	4243	11	0	4	Q2	2012	2.7200	1.2784	4.0000	1
75	4316	22	0	6	Q2	2012	0.6800	0.2448	1.0000	1
75	4467	11	0	12	Q4	2012	2.0400	1.0200	3.0000	1
75	4497	17	0	11	Q4	2012	2.0400	0.6528	3.0000	1
75	4573	7	504	2	Q1	2012	2.7200	1.1152	4.0000	1
75	4767	16	0	5	Q2	2012	2.7200	1.0880	4.0000	1
75	5062	6	0	2	Q1	2012	1.3600	0.5032	2.0000	1
75	5388	11	0	3	Q1	2012	2.7200	1.1152	4.0000	1
75	5635	6	508	4	Q2	2012	2.0400	0.6732	3.0000	1
75	5894	11	829	6	Q2	2012	1.3600	0.6800	2.0000	1
75	6466	7	501	1	Q1	2012	3.4000	1.2920	5.0000	1
75	6560	17	0	7	Q3	2012	2.0400	0.6732	3.0000	1
75	6609	6	0	4	Q2	2012	2.7200	1.3328	4.0000	1
75	6700	15	1150	8	Q3	2012	2.7200	1.1152	4.0000	1
75	6772	24	1853	5	Q2	2012	2.7200	0.8704	4.0000	1
75	6854	17	0	3	Q1	2012	2.0400	0.7548	3.0000	1
75	7556	17	1294	2	Q1	2012	2.0400	0.9180	3.0000	1
75	7809	2	118	6	Q2	2012	1.3600	0.6392	2.0000	1
75	7887	11	821	2	Q1	2012	2.7200	0.9520	4.0000	1
75	8038	24	0	5	Q2	2012	1.3600	0.6528	2.0000	1
75	8111	15	0	2	Q1	2012	2.0400	0.7140	3.0000	1
75	8308	17	0	4	Q2	2012	2.0400	0.6936	3.0000	1
75	8318	24	1847	2	Q1	2012	1.3600	0.5848	2.0000	1
75	8356	15	0	10	Q4	2012	2.0400	0.7344	3.0000	1
75	8549	6	508	4	Q2	2012	2.7200	0.9520	4.0000	1
75	8644	13	988	7	Q3	2012	1.3600	0.5440	2.0000	1
75	8687	23	0	1	Q1	2012	2.7200	1.1424	4.0000	1
75	8919	13	0	1	Q1	2012	2.7200	1.3600	4.0000	1
75	9213	11	0	11	Q4	2012	1.3600	0.5168	2.0000	1
75	9348	15	1138	3	Q1	2012	2.7200	1.0880	4.0000	1
75	9353	15	1150	8	Q3	2012	1.3600	0.4760	2.0000	1
75	9671	13	0	4	Q2	2012	2.7200	0.8704	4.0000	1
75	9956	17	0	4	Q2	2012	1.3600	0.5168	2.0000	1
75	10147	7	0	10	Q4	2012	3.4000	1.0880	5.0000	1
75	10274	6	0	5	Q2	2012	3.4000	1.0880	5.0000	1
76	121	6	506	3	Q1	2012	3.3800	1.5886	2.0000	1
76	892	6	0	12	Q4	2012	5.0700	2.3322	3.0000	1
76	907	6	510	5	Q2	2012	6.7600	3.0420	4.0000	1
76	1249	15	0	1	Q1	2012	5.0700	1.8252	3.0000	1
76	1310	16	0	6	Q2	2012	3.3800	1.6224	2.0000	1
76	1412	11	0	12	Q4	2012	5.0700	1.9773	3.0000	1
76	1633	3	207	11	Q4	2012	5.0700	2.1294	3.0000	1
76	1652	2	124	9	Q3	2012	3.3800	1.3520	2.0000	1
76	1675	15	0	6	Q2	2012	3.3800	1.5886	2.0000	1
76	1734	2	0	6	Q2	2012	1.6900	0.7098	1.0000	1
76	1798	3	205	10	Q4	2012	3.3800	1.4872	2.0000	1
76	2065	17	1303	6	Q2	2012	5.0700	1.7745	3.0000	1
76	2077	23	1769	3	Q1	2012	5.0700	1.7238	3.0000	1
76	2210	13	0	7	Q3	2012	6.7600	3.1096	4.0000	1
76	2285	24	0	4	Q2	2012	6.7600	2.5688	4.0000	1
76	2335	17	1292	1	Q1	2012	3.3800	1.2168	2.0000	1
76	2378	16	1235	11	Q4	2012	6.7600	2.4336	4.0000	1
76	3292	6	0	7	Q3	2012	5.0700	1.8252	3.0000	1
76	3449	6	0	1	Q1	2012	6.7600	3.2448	4.0000	1
76	3463	13	0	3	Q1	2012	5.0700	2.3322	3.0000	1
76	3889	3	0	9	Q3	2012	5.0700	2.4336	3.0000	1
76	3976	17	0	10	Q4	2012	6.7600	3.3800	4.0000	1
76	4423	13	982	4	Q2	2012	5.0700	1.5210	3.0000	1
76	4541	3	0	2	Q1	2012	5.0700	1.5717	3.0000	1
76	4659	13	980	3	Q1	2012	5.0700	2.0787	3.0000	1
76	4674	7	0	10	Q4	2012	5.0700	1.8252	3.0000	1
76	4700	17	0	3	Q1	2012	5.0700	2.3322	3.0000	1
76	4727	16	1235	11	Q4	2012	3.3800	1.2844	2.0000	1
76	4858	17	0	2	Q1	2012	6.7600	2.3660	4.0000	1
76	4917	14	0	9	Q3	2012	3.3800	1.4872	2.0000	1
76	4938	13	0	4	Q2	2012	5.0700	1.7745	3.0000	1
76	4958	23	0	5	Q2	2012	6.7600	2.3660	4.0000	1
76	5637	15	0	10	Q4	2012	8.4500	3.9715	5.0000	1
76	5685	13	0	9	Q3	2012	5.0700	2.3829	3.0000	1
76	5913	7	0	5	Q2	2012	8.4500	2.9575	5.0000	1
76	6088	14	0	4	Q2	2012	3.3800	1.5548	2.0000	1
76	6113	16	1236	12	Q4	2012	3.3800	1.5548	2.0000	1
76	6313	17	0	12	Q4	2012	6.7600	3.2448	4.0000	1
76	6675	22	0	5	Q2	2012	3.3800	1.5886	2.0000	1
76	6958	6	0	5	Q2	2012	3.3800	1.0816	2.0000	1
76	7051	16	0	9	Q3	2012	3.3800	1.2168	2.0000	1
76	7065	17	0	12	Q4	2012	3.3800	1.5210	2.0000	1
76	7743	3	0	10	Q4	2012	6.7600	3.0420	4.0000	1
76	8059	17	0	3	Q1	2012	5.0700	2.0787	3.0000	1
76	8207	13	0	7	Q3	2012	5.0700	2.0787	3.0000	1
76	8669	23	1781	8	Q3	2012	3.3800	1.1830	2.0000	1
76	8749	13	0	7	Q3	2012	5.0700	2.1801	3.0000	1
76	8830	14	0	1	Q1	2012	3.3800	1.1492	2.0000	1
76	8902	3	199	7	Q3	2012	5.0700	2.1801	3.0000	1
76	9040	16	0	3	Q1	2012	5.0700	2.4336	3.0000	1
76	9176	23	1768	2	Q1	2012	5.0700	2.3829	3.0000	1
76	9194	17	0	5	Q2	2012	10.1400	4.7658	6.0000	1
76	9397	11	0	11	Q4	2012	8.4500	2.9575	5.0000	1
76	9527	7	0	9	Q3	2012	5.0700	1.7745	3.0000	1
76	9621	7	0	11	Q4	2012	3.3800	1.6224	2.0000	1
76	9715	17	0	8	Q3	2012	8.4500	3.3800	5.0000	1
76	10152	13	986	6	Q2	2012	5.0700	1.7238	3.0000	1
77	456	15	1149	8	Q3	2012	8.4000	2.9400	3.0000	1
77	788	15	0	8	Q3	2012	11.2000	3.9200	4.0000	1
77	1293	2	0	1	Q1	2012	5.6000	2.8000	2.0000	1
77	1445	15	0	5	Q2	2012	11.2000	5.3760	4.0000	1
77	1676	3	0	10	Q4	2012	5.6000	1.7920	2.0000	1
77	1720	16	0	7	Q3	2012	5.6000	2.6880	2.0000	1
77	1856	24	0	1	Q1	2012	8.4000	3.5280	3.0000	1
77	1994	15	0	11	Q4	2012	5.6000	2.8000	2.0000	1
77	2143	17	0	6	Q2	2012	11.2000	3.6960	4.0000	1
77	2234	13	0	8	Q3	2012	8.4000	3.9480	3.0000	1
77	2405	24	1866	11	Q4	2012	8.4000	3.1920	3.0000	1
77	2587	16	0	8	Q3	2012	11.2000	4.0320	4.0000	1
77	2695	13	0	7	Q3	2012	5.6000	1.6800	2.0000	1
77	2870	7	0	9	Q3	2012	5.6000	2.5760	2.0000	1
77	3060	2	0	11	Q4	2012	5.6000	2.6880	2.0000	1
77	3114	7	0	4	Q2	2012	16.8000	7.8960	6.0000	1
77	3268	13	0	10	Q4	2012	11.2000	3.8080	4.0000	1
77	3302	13	0	6	Q2	2012	11.2000	4.7040	4.0000	1
77	3455	7	0	6	Q2	2012	11.2000	3.8080	4.0000	1
77	3532	6	0	3	Q1	2012	11.2000	4.4800	4.0000	1
77	4113	6	0	12	Q4	2012	8.4000	2.6040	3.0000	1
77	4162	6	0	5	Q2	2012	11.2000	3.5840	4.0000	1
77	4181	24	0	8	Q3	2012	8.4000	2.9400	3.0000	1
77	4690	13	0	12	Q4	2012	11.2000	3.9200	4.0000	1
77	4691	17	1304	7	Q3	2012	8.4000	3.9480	3.0000	1
77	4898	24	1859	8	Q3	2012	5.6000	2.2960	2.0000	1
77	4915	24	1846	2	Q1	2012	5.6000	1.9040	2.0000	1
77	5162	22	0	1	Q1	2012	5.6000	2.0160	2.0000	1
77	5765	6	0	5	Q2	2012	5.6000	1.9040	2.0000	1
77	5991	3	0	3	Q1	2012	5.6000	2.2960	2.0000	1
77	6352	13	0	2	Q1	2012	8.4000	4.2000	3.0000	1
77	6793	7	526	12	Q4	2012	14.0000	6.8600	5.0000	1
77	7038	24	0	4	Q2	2012	11.2000	4.5920	4.0000	1
77	7556	17	0	11	Q4	2012	11.2000	4.7040	4.0000	1
77	7653	6	519	9	Q3	2012	8.4000	3.0240	3.0000	1
77	7733	13	0	1	Q1	2012	8.4000	2.6880	3.0000	1
77	7806	13	0	7	Q3	2012	5.6000	2.5200	2.0000	1
77	7909	3	207	11	Q4	2012	11.2000	4.0320	4.0000	1
77	8074	17	0	9	Q3	2012	8.4000	3.7800	3.0000	1
77	8189	17	0	6	Q2	2012	8.4000	3.0240	3.0000	1
77	8304	13	0	6	Q2	2012	5.6000	1.8480	2.0000	1
77	8454	17	0	8	Q3	2012	5.6000	1.7920	2.0000	1
77	8758	7	504	2	Q1	2012	5.6000	2.4080	2.0000	1
77	8758	7	512	6	Q2	2012	8.4000	3.6120	3.0000	1
77	9379	15	0	7	Q3	2012	5.6000	2.6880	2.0000	1
77	9434	6	0	11	Q4	2012	5.6000	2.5760	2.0000	1
77	9505	15	0	3	Q1	2012	8.4000	3.2760	3.0000	1
77	9552	7	501	1	Q1	2012	5.6000	2.0160	2.0000	1
77	9622	6	0	8	Q3	2012	14.0000	6.7200	5.0000	1
78	602	17	0	10	Q4	2012	6.5700	2.1681	3.0000	1
78	712	6	0	2	Q1	2012	4.3800	1.5768	2.0000	1
78	722	24	1845	1	Q1	2012	6.5700	3.2850	3.0000	1
78	790	13	0	7	Q3	2012	4.3800	2.1024	2.0000	1
78	1071	13	0	1	Q1	2012	4.3800	1.4454	2.0000	1
78	1491	16	0	11	Q4	2012	6.5700	2.6280	3.0000	1
78	1611	13	0	11	Q4	2012	6.5700	2.2995	3.0000	1
78	2468	13	0	10	Q4	2012	10.9500	5.3655	5.0000	1
78	2530	6	513	6	Q2	2012	6.5700	3.2193	3.0000	1
78	2890	7	0	12	Q4	2012	8.7600	2.8032	4.0000	1
78	3012	24	0	7	Q3	2012	6.5700	2.4966	3.0000	1
78	3020	13	0	4	Q2	2012	4.3800	1.3140	2.0000	1
78	3157	7	0	10	Q4	2012	8.7600	3.4164	4.0000	1
78	3427	24	0	5	Q2	2012	4.3800	1.4016	2.0000	1
78	3443	15	1140	4	Q2	2012	8.7600	2.8032	4.0000	1
78	3540	24	0	5	Q2	2012	6.5700	2.9565	3.0000	1
78	3716	17	0	5	Q2	2012	6.5700	2.1024	3.0000	1
78	4243	11	0	9	Q3	2012	6.5700	2.1024	3.0000	1
78	4344	7	0	6	Q2	2012	8.7600	2.8032	4.0000	1
78	4417	3	187	2	Q1	2012	6.5700	2.1024	3.0000	1
78	4454	15	0	12	Q4	2012	8.7600	2.7156	4.0000	1
78	4537	7	0	3	Q1	2012	6.5700	2.4309	3.0000	1
78	4547	13	992	9	Q3	2012	8.7600	3.5040	4.0000	1
78	4700	17	0	4	Q2	2012	4.3800	2.1024	2.0000	1
78	4798	6	0	3	Q1	2012	4.3800	2.1462	2.0000	1
78	4814	11	0	8	Q3	2012	6.5700	2.8251	3.0000	1
78	4833	24	0	3	Q1	2012	4.3800	1.3140	2.0000	1
78	5072	6	0	7	Q3	2012	4.3800	1.7958	2.0000	1
78	5360	11	821	3	Q1	2012	6.5700	2.2995	3.0000	1
78	5368	24	0	8	Q3	2012	8.7600	3.5040	4.0000	1
78	5405	11	0	3	Q1	2012	6.5700	2.3652	3.0000	1
78	5592	16	0	1	Q1	2012	4.3800	2.1024	2.0000	1
78	6348	16	0	4	Q2	2012	6.5700	3.0222	3.0000	1
78	6403	2	0	2	Q1	2012	4.3800	1.4892	2.0000	1
78	6530	17	1294	2	Q1	2012	6.5700	2.2338	3.0000	1
78	6788	7	0	5	Q2	2012	8.7600	3.4164	4.0000	1
78	6930	24	0	4	Q2	2012	6.5700	2.3652	3.0000	1
78	7060	7	0	1	Q1	2012	6.5700	3.0879	3.0000	1
78	7243	13	0	6	Q2	2012	8.7600	3.8544	4.0000	1
78	7414	15	1142	5	Q2	2012	6.5700	2.1024	3.0000	1
78	7622	3	188	2	Q1	2012	6.5700	2.6937	3.0000	1
78	7704	3	207	11	Q4	2012	4.3800	1.9710	2.0000	1
78	7849	3	205	10	Q4	2012	6.5700	3.0879	3.0000	1
78	7856	6	0	7	Q3	2012	8.7600	2.8032	4.0000	1
78	8042	7	0	9	Q3	2012	6.5700	3.0879	3.0000	1
78	8123	24	0	4	Q2	2012	4.3800	1.4454	2.0000	1
78	8242	17	0	10	Q4	2012	6.5700	2.4309	3.0000	1
78	8254	17	0	9	Q3	2012	4.3800	1.7958	2.0000	1
78	8384	15	0	11	Q4	2012	8.7600	4.1172	4.0000	1
78	8746	23	0	5	Q2	2012	6.5700	3.1536	3.0000	1
78	8947	3	0	2	Q1	2012	4.3800	1.5768	2.0000	1
78	9033	6	519	9	Q3	2012	4.3800	1.9272	2.0000	1
78	9134	23	0	7	Q3	2012	4.3800	1.7958	2.0000	1
78	9270	11	833	8	Q3	2012	4.3800	1.6644	2.0000	1
78	9578	13	0	12	Q4	2012	4.3800	1.9710	2.0000	1
78	9974	6	526	12	Q4	2012	4.3800	1.7520	2.0000	1
78	10173	16	0	4	Q2	2012	8.7600	4.2924	4.0000	1
78	10182	24	0	12	Q4	2012	6.5700	3.1536	3.0000	1
79	56	24	0	9	Q3	2012	3.9600	1.6632	3.0000	1
79	841	14	1077	11	Q4	2012	2.6400	0.9504	2.0000	1
79	1310	16	1228	8	Q3	2012	3.9600	1.8612	3.0000	1
79	1337	17	0	12	Q4	2012	2.6400	1.1088	2.0000	1
79	1347	13	0	11	Q4	2012	3.9600	1.2672	3.0000	1
79	1381	15	0	5	Q2	2012	3.9600	1.7424	3.0000	1
79	1415	16	0	7	Q3	2012	5.2800	2.4816	4.0000	1
79	1582	11	0	10	Q4	2012	5.2800	2.3232	4.0000	1
79	1610	3	0	7	Q3	2012	3.9600	1.7820	3.0000	1
79	1634	3	0	8	Q3	2012	3.9600	1.3860	3.0000	1
79	2638	13	980	3	Q1	2012	5.2800	2.1120	4.0000	1
79	2917	15	0	11	Q4	2012	5.2800	1.7952	4.0000	1
79	3130	13	982	4	Q2	2012	5.2800	2.1120	4.0000	1
79	3245	17	0	7	Q3	2012	3.9600	1.4256	3.0000	1
79	3415	15	0	8	Q3	2012	5.2800	2.5344	4.0000	1
79	3589	13	0	8	Q3	2012	6.6000	2.6400	5.0000	1
79	3720	7	0	10	Q4	2012	3.9600	1.4256	3.0000	1
79	3799	13	0	1	Q1	2012	2.6400	0.8976	2.0000	1
79	3816	3	0	5	Q2	2012	5.2800	1.6896	4.0000	1
79	3979	13	0	7	Q3	2012	2.6400	0.9504	2.0000	1
79	4066	3	0	4	Q2	2012	3.9600	1.5444	3.0000	1
79	4163	14	0	4	Q2	2012	1.3200	0.5280	1.0000	1
79	4498	17	0	9	Q3	2012	5.2800	2.2176	4.0000	1
79	4555	11	0	4	Q2	2012	5.2800	2.6400	4.0000	1
79	4666	13	980	3	Q1	2012	3.9600	1.6236	3.0000	1
79	4772	2	0	1	Q1	2012	1.3200	0.5544	1.0000	1
79	4803	23	0	2	Q1	2012	2.6400	0.9240	2.0000	1
79	4859	14	1079	12	Q4	2012	1.3200	0.3960	1.0000	1
79	4881	13	0	4	Q2	2012	3.9600	1.9008	3.0000	1
79	5774	24	1860	8	Q3	2012	3.9600	1.9800	3.0000	1
79	6313	17	1293	1	Q1	2012	3.9600	1.5048	3.0000	1
79	6486	13	0	12	Q4	2012	2.6400	1.1088	2.0000	1
79	7051	16	1216	2	Q1	2012	3.9600	1.5840	3.0000	1
79	7133	22	0	3	Q1	2012	2.6400	1.0296	2.0000	1
79	7179	11	0	2	Q1	2012	3.9600	1.3860	3.0000	1
79	7269	13	0	3	Q1	2012	5.2800	2.4816	4.0000	1
79	7708	6	508	4	Q2	2012	3.9600	1.2672	3.0000	1
79	7743	3	0	12	Q4	2012	5.2800	1.7424	4.0000	1
79	7826	24	0	3	Q1	2012	3.9600	1.2276	3.0000	1
79	8164	13	0	2	Q1	2012	5.2800	1.9536	4.0000	1
79	8165	15	1146	7	Q3	2012	3.9600	1.2276	3.0000	1
79	8308	17	0	7	Q3	2012	2.6400	1.2144	2.0000	1
79	8843	13	0	3	Q1	2012	5.2800	2.1120	4.0000	1
79	8899	7	0	12	Q4	2012	2.6400	1.1088	2.0000	1
79	9045	24	0	1	Q1	2012	5.2800	2.1648	4.0000	1
79	9318	16	0	6	Q2	2012	5.2800	2.4816	4.0000	1
79	9498	23	0	8	Q3	2012	5.2800	2.0064	4.0000	1
79	9548	15	0	3	Q1	2012	3.9600	1.5840	3.0000	1
79	9639	17	0	2	Q1	2012	3.9600	1.4256	3.0000	1
79	9801	11	0	9	Q3	2012	5.2800	2.6400	4.0000	1
79	10144	7	504	2	Q1	2012	3.9600	1.2276	3.0000	1
80	879	7	504	2	Q1	2012	14.5200	5.5176	4.0000	1
80	921	23	0	9	Q3	2012	10.8900	3.7026	3.0000	1
80	1273	15	1150	8	Q3	2012	10.8900	4.4649	3.0000	1
80	1337	17	1294	2	Q1	2012	10.8900	3.5937	3.0000	1
80	1415	16	0	9	Q3	2012	7.2600	3.2670	2.0000	1
80	1549	6	0	12	Q4	2012	7.2600	2.5410	2.0000	1
80	1794	13	0	3	Q1	2012	7.2600	3.4848	2.0000	1
80	2086	13	0	1	Q1	2012	14.5200	4.6464	4.0000	1
80	2547	23	0	5	Q2	2012	10.8900	5.2272	3.0000	1
80	2639	15	0	10	Q4	2012	7.2600	3.3396	2.0000	1
80	3172	15	1146	7	Q3	2012	14.5200	5.0820	4.0000	1
80	3204	24	0	10	Q4	2012	14.5200	5.5176	4.0000	1
80	3239	17	1311	10	Q4	2012	10.8900	3.7026	3.0000	1
80	3352	7	0	8	Q3	2012	10.8900	4.0293	3.0000	1
80	3711	3	202	8	Q3	2012	10.8900	5.1183	3.0000	1
80	3735	24	0	4	Q2	2012	10.8900	4.9005	3.0000	1
80	3796	11	0	7	Q3	2012	14.5200	5.0820	4.0000	1
80	4094	16	0	10	Q4	2012	14.5200	5.9532	4.0000	1
80	4099	17	0	3	Q1	2012	7.2600	2.5410	2.0000	1
80	4116	11	0	11	Q4	2012	14.5200	5.5176	4.0000	1
80	4149	11	0	5	Q2	2012	14.5200	5.6628	4.0000	1
80	4341	11	0	5	Q2	2012	10.8900	3.3759	3.0000	1
80	4387	14	1056	1	Q1	2012	7.2600	2.4684	2.0000	1
80	4397	16	1231	9	Q3	2012	10.8900	3.9204	3.0000	1
80	4881	13	0	2	Q1	2012	10.8900	5.2272	3.0000	1
80	5592	16	0	7	Q3	2012	10.8900	4.6827	3.0000	1
80	5824	7	0	4	Q2	2012	10.8900	3.9204	3.0000	1
80	5923	23	1789	12	Q4	2012	10.8900	3.9204	3.0000	1
80	6283	6	0	4	Q2	2012	7.2600	2.5410	2.0000	1
80	6400	6	508	4	Q2	2012	7.2600	2.3232	2.0000	1
80	6426	24	1858	7	Q3	2012	18.1500	8.3490	5.0000	1
80	6496	3	0	5	Q2	2012	14.5200	7.1148	4.0000	1
80	6529	17	0	10	Q4	2012	7.2600	3.6300	2.0000	1
80	6955	11	0	4	Q2	2012	7.2600	2.6862	2.0000	1
80	6977	24	0	4	Q2	2012	7.2600	2.1780	2.0000	1
80	7079	11	837	10	Q4	2012	10.8900	3.9204	3.0000	1
80	7190	23	1772	4	Q2	2012	10.8900	4.7916	3.0000	1
80	7269	13	0	7	Q3	2012	10.8900	4.2471	3.0000	1
80	7331	11	0	11	Q4	2012	10.8900	3.7026	3.0000	1
80	7570	13	0	5	Q2	2012	10.8900	4.0293	3.0000	1
80	7720	17	0	11	Q4	2012	10.8900	3.9204	3.0000	1
80	7818	11	829	6	Q2	2012	14.5200	5.2272	4.0000	1
80	8283	17	0	6	Q2	2012	7.2600	2.6862	2.0000	1
80	8442	17	0	11	Q4	2012	14.5200	6.9696	4.0000	1
80	8617	17	1304	7	Q3	2012	7.2600	3.5574	2.0000	1
80	8859	15	0	4	Q2	2012	14.5200	5.5176	4.0000	1
80	8886	11	0	7	Q3	2012	14.5200	4.5012	4.0000	1
80	9065	13	984	5	Q2	2012	14.5200	6.8244	4.0000	1
80	9303	15	0	6	Q2	2012	10.8900	4.6827	3.0000	1
80	9449	6	0	9	Q3	2012	10.8900	3.7026	3.0000	1
80	9715	17	0	2	Q1	2012	18.1500	7.2600	5.0000	1
80	9891	23	0	10	Q4	2012	10.8900	3.7026	3.0000	1
81	311	7	0	1	Q1	2012	8.5200	3.4932	4.0000	1
81	314	15	0	4	Q2	2012	8.5200	4.1748	4.0000	1
81	905	3	0	5	Q2	2012	6.3900	2.2365	3.0000	1
81	909	7	0	5	Q2	2012	8.5200	3.2376	4.0000	1
81	1187	13	0	12	Q4	2012	6.3900	2.1726	3.0000	1
81	1261	24	0	9	Q3	2012	6.3900	2.2365	3.0000	1
81	1298	17	1303	6	Q2	2012	4.2600	1.9170	2.0000	1
81	1821	13	0	4	Q2	2012	4.2600	2.0874	2.0000	1
81	1862	17	0	12	Q4	2012	8.5200	2.8116	4.0000	1
81	2054	15	0	3	Q1	2012	8.5200	4.0044	4.0000	1
81	2164	14	0	7	Q3	2012	2.1300	0.8733	1.0000	1
81	2426	17	1294	2	Q1	2012	6.3900	2.8116	3.0000	1
81	2496	11	837	10	Q4	2012	6.3900	3.0033	3.0000	1
81	2769	16	1236	12	Q4	2012	8.5200	3.2376	4.0000	1
81	2947	17	0	3	Q1	2012	4.2600	2.0448	2.0000	1
81	3245	17	1304	7	Q3	2012	6.3900	2.3004	3.0000	1
81	3418	3	0	12	Q4	2012	6.3900	3.0672	3.0000	1
81	3422	23	0	12	Q4	2012	6.3900	2.3643	3.0000	1
81	3512	24	0	9	Q3	2012	6.3900	2.8116	3.0000	1
81	3609	24	1853	5	Q2	2012	4.2600	1.5336	2.0000	1
81	4118	17	0	4	Q2	2012	8.5200	4.1748	4.0000	1
81	4204	17	1307	8	Q3	2012	4.2600	1.5336	2.0000	1
81	4234	3	185	1	Q1	2012	6.3900	2.3004	3.0000	1
81	4372	13	988	7	Q3	2012	6.3900	2.9394	3.0000	1
81	4395	11	824	4	Q2	2012	4.2600	1.6188	2.0000	1
81	4618	3	0	2	Q1	2012	4.2600	1.6614	2.0000	1
81	4804	13	0	1	Q1	2012	6.3900	2.6199	3.0000	1
81	4892	17	0	9	Q3	2012	8.5200	2.9820	4.0000	1
81	5394	6	0	9	Q3	2012	6.3900	2.3004	3.0000	1
81	5394	7	519	9	Q3	2012	4.2600	2.0448	2.0000	1
81	5616	17	1294	2	Q1	2012	6.3900	1.9809	3.0000	1
81	5846	11	829	6	Q2	2012	6.3900	2.8755	3.0000	1
81	6124	7	0	8	Q3	2012	4.2600	1.4484	2.0000	1
81	6141	7	523	11	Q4	2012	4.2600	1.5336	2.0000	1
81	6301	15	0	1	Q1	2012	8.5200	2.8968	4.0000	1
81	6462	13	0	8	Q3	2012	6.3900	3.1950	3.0000	1
81	6544	13	0	11	Q4	2012	6.3900	2.6199	3.0000	1
81	6894	24	0	8	Q3	2012	6.3900	1.9809	3.0000	1
81	6957	16	0	3	Q1	2012	8.5200	2.7264	4.0000	1
81	6960	17	0	12	Q4	2012	10.6500	4.3665	5.0000	1
81	7137	11	826	5	Q2	2012	4.2600	1.3632	2.0000	1
81	7149	13	1000	12	Q4	2012	6.3900	3.0672	3.0000	1
81	7319	13	976	1	Q1	2012	8.5200	4.0896	4.0000	1
81	7715	13	0	12	Q4	2012	10.6500	3.7275	5.0000	1
81	7762	7	518	8	Q3	2012	6.3900	3.0672	3.0000	1
81	8003	3	0	5	Q2	2012	6.3900	2.3004	3.0000	1
81	8151	7	0	6	Q2	2012	8.5200	4.1748	4.0000	1
81	8214	6	0	12	Q4	2012	4.2600	2.0874	2.0000	1
81	8448	24	1850	3	Q1	2012	6.3900	2.4921	3.0000	1
81	8758	7	504	2	Q1	2012	4.2600	1.5336	2.0000	1
81	8794	17	0	5	Q2	2012	8.5200	2.6412	4.0000	1
81	9504	13	0	3	Q1	2012	6.3900	2.8116	3.0000	1
81	9648	13	980	3	Q1	2012	8.5200	2.8116	4.0000	1
81	9698	23	0	7	Q3	2012	8.5200	4.1748	4.0000	1
81	9728	16	0	8	Q3	2012	4.2600	2.0874	2.0000	1
81	9825	13	982	4	Q2	2012	4.2600	2.1300	2.0000	1
81	10116	17	0	1	Q1	2012	8.5200	4.1748	4.0000	1
82	39	13	0	11	Q4	2012	10.8000	3.6720	4.0000	1
82	96	11	0	9	Q3	2012	8.1000	3.8880	3.0000	1
82	136	15	0	6	Q2	2012	8.1000	2.9160	3.0000	1
82	158	17	0	4	Q2	2012	10.8000	4.7520	4.0000	1
82	477	15	1138	3	Q1	2012	8.1000	2.6730	3.0000	1
82	532	13	0	8	Q3	2012	10.8000	5.1840	4.0000	1
82	699	24	0	12	Q4	2012	10.8000	5.2920	4.0000	1
82	997	3	0	4	Q2	2012	8.1000	2.9160	3.0000	1
82	1282	3	0	8	Q3	2012	13.5000	4.3200	5.0000	1
82	1607	17	0	7	Q3	2012	10.8000	4.5360	4.0000	1
82	1610	3	0	11	Q4	2012	8.1000	2.6730	3.0000	1
82	1702	7	0	8	Q3	2012	8.1000	2.9160	3.0000	1
82	1747	24	1869	12	Q4	2012	8.1000	3.6450	3.0000	1
82	1850	16	1235	11	Q4	2012	8.1000	4.0500	3.0000	1
82	1890	24	0	10	Q4	2012	10.8000	3.6720	4.0000	1
82	1917	23	0	4	Q2	2012	8.1000	2.5920	3.0000	1
82	2011	23	1768	2	Q1	2012	8.1000	3.8070	3.0000	1
82	2088	6	0	4	Q2	2012	10.8000	5.4000	4.0000	1
82	2245	11	0	4	Q2	2012	13.5000	6.6150	5.0000	1
82	3082	6	0	9	Q3	2012	8.1000	3.1590	3.0000	1
82	3197	23	0	3	Q1	2012	13.5000	4.8600	5.0000	1
82	3422	23	0	12	Q4	2012	5.4000	2.4300	2.0000	1
82	3499	13	976	1	Q1	2012	8.1000	3.7260	3.0000	1
82	4063	15	0	6	Q2	2012	5.4000	2.3760	2.0000	1
82	4179	24	1845	1	Q1	2012	5.4000	2.4300	2.0000	1
82	4282	15	0	2	Q1	2012	5.4000	2.3760	2.0000	1
82	4537	7	0	10	Q4	2012	10.8000	3.8880	4.0000	1
82	4564	17	0	10	Q4	2012	8.1000	2.7540	3.0000	1
82	4566	11	818	1	Q1	2012	8.1000	3.5640	3.0000	1
82	4676	16	0	12	Q4	2012	10.8000	5.1840	4.0000	1
82	5050	17	0	7	Q3	2012	10.8000	5.0760	4.0000	1
82	5135	6	0	12	Q4	2012	10.8000	4.9680	4.0000	1
82	5191	15	0	5	Q2	2012	5.4000	2.7000	2.0000	1
82	5230	13	0	11	Q4	2012	8.1000	4.0500	3.0000	1
82	5493	7	0	9	Q3	2012	8.1000	2.9970	3.0000	1
82	5704	24	0	11	Q4	2012	10.8000	4.8600	4.0000	1
82	5735	7	523	11	Q4	2012	5.4000	2.0520	2.0000	1
82	5834	11	0	11	Q4	2012	8.1000	2.6730	3.0000	1
82	5898	3	0	4	Q2	2012	8.1000	3.4830	3.0000	1
82	6074	2	0	9	Q3	2012	5.4000	2.1060	2.0000	1
82	6332	6	519	9	Q3	2012	10.8000	4.8600	4.0000	1
82	6664	15	1146	7	Q3	2012	8.1000	2.5920	3.0000	1
82	6698	13	0	7	Q3	2012	5.4000	1.9980	2.0000	1
82	6957	16	0	12	Q4	2012	8.1000	3.3210	3.0000	1
82	7032	2	0	12	Q4	2012	2.7000	1.1340	1.0000	1
82	7265	24	1866	11	Q4	2012	10.8000	4.9680	4.0000	1
82	7319	13	0	6	Q2	2012	10.8000	5.2920	4.0000	1
82	7406	11	0	11	Q4	2012	5.4000	1.8900	2.0000	1
82	7567	24	0	8	Q3	2012	10.8000	5.1840	4.0000	1
82	7622	3	0	1	Q1	2012	8.1000	3.3210	3.0000	1
82	7656	2	0	3	Q1	2012	2.7000	1.2420	1.0000	1
82	8042	7	0	9	Q3	2012	8.1000	3.8070	3.0000	1
82	9102	3	199	7	Q3	2012	5.4000	2.1600	2.0000	1
82	9327	17	0	6	Q2	2012	5.4000	1.9980	2.0000	1
82	9417	15	0	10	Q4	2012	8.1000	2.9970	3.0000	1
82	9920	15	0	12	Q4	2012	10.8000	4.5360	4.0000	1
82	10035	15	0	11	Q4	2012	5.4000	1.9980	2.0000	1
82	10073	23	0	7	Q3	2012	8.1000	3.2400	3.0000	1
82	10173	16	0	11	Q4	2012	8.1000	3.1590	3.0000	1
83	711	17	0	2	Q1	2012	7.7600	3.3368	2.0000	1
83	769	16	0	9	Q3	2012	15.5200	4.9664	4.0000	1
83	873	24	0	11	Q4	2012	11.6400	3.7248	3.0000	1
83	1267	13	0	3	Q1	2012	11.6400	5.7036	3.0000	1
83	1497	17	0	11	Q4	2012	11.6400	3.9576	3.0000	1
83	1676	3	0	7	Q3	2012	7.7600	3.4920	2.0000	1
83	1954	13	0	7	Q3	2012	11.6400	5.3544	3.0000	1
83	2619	7	519	9	Q3	2012	11.6400	4.7724	3.0000	1
83	3099	7	0	9	Q3	2012	11.6400	5.5872	3.0000	1
83	3480	7	0	1	Q1	2012	11.6400	5.3544	3.0000	1
83	3491	16	0	6	Q2	2012	11.6400	4.8888	3.0000	1
83	3497	17	1294	2	Q1	2012	15.5200	4.9664	4.0000	1
83	3539	17	1304	7	Q3	2012	11.6400	4.8888	3.0000	1
83	3936	7	0	6	Q2	2012	15.5200	6.0528	4.0000	1
83	3936	7	0	10	Q4	2012	19.4000	6.0140	5.0000	1
83	4282	15	1138	3	Q1	2012	11.6400	4.4232	3.0000	1
83	4630	15	0	6	Q2	2012	11.6400	4.1904	3.0000	1
83	4925	16	1216	2	Q1	2012	7.7600	3.8800	2.0000	1
83	4938	13	0	3	Q1	2012	11.6400	4.7724	3.0000	1
83	4986	15	0	9	Q3	2012	15.5200	5.7424	4.0000	1
83	5063	3	190	3	Q1	2012	11.6400	4.7724	3.0000	1
83	5067	17	1312	10	Q4	2012	15.5200	7.2944	4.0000	1
83	5162	22	0	11	Q4	2012	11.6400	3.7248	3.0000	1
83	5374	16	1233	10	Q4	2012	15.5200	6.9840	4.0000	1
83	5528	24	0	5	Q2	2012	15.5200	5.4320	4.0000	1
83	5592	16	0	8	Q3	2012	11.6400	4.4232	3.0000	1
83	6289	6	513	6	Q2	2012	11.6400	3.6084	3.0000	1
83	6321	14	1058	2	Q1	2012	7.7600	3.8024	2.0000	1
83	6496	3	0	11	Q4	2012	15.5200	7.6048	4.0000	1
83	6710	13	0	11	Q4	2012	15.5200	5.1216	4.0000	1
83	7075	15	1143	5	Q2	2012	11.6400	4.3068	3.0000	1
83	7229	15	0	11	Q4	2012	7.7600	2.9488	2.0000	1
83	7625	7	0	8	Q3	2012	11.6400	5.7036	3.0000	1
83	7841	6	0	9	Q3	2012	7.7600	2.4056	2.0000	1
83	7920	17	0	1	Q1	2012	15.5200	4.8112	4.0000	1
83	8066	15	0	2	Q1	2012	11.6400	4.6560	3.0000	1
83	8068	3	0	7	Q3	2012	15.5200	6.5184	4.0000	1
83	8179	11	842	12	Q4	2012	11.6400	4.1904	3.0000	1
83	8238	15	1154	10	Q4	2012	11.6400	5.8200	3.0000	1
83	8370	11	0	11	Q4	2012	15.5200	7.1392	4.0000	1
83	8373	13	0	4	Q2	2012	7.7600	2.5608	2.0000	1
83	8394	6	0	6	Q2	2012	11.6400	5.4708	3.0000	1
83	8632	24	0	8	Q3	2012	15.5200	7.2944	4.0000	1
83	8665	15	1138	3	Q1	2012	11.6400	5.4708	3.0000	1
83	9263	16	0	6	Q2	2012	11.6400	5.3544	3.0000	1
83	9318	16	1233	10	Q4	2012	11.6400	5.4708	3.0000	1
83	9355	7	0	5	Q2	2012	11.6400	3.8412	3.0000	1
83	9396	13	982	4	Q2	2012	15.5200	7.2944	4.0000	1
83	9527	6	508	4	Q2	2012	11.6400	3.9576	3.0000	1
83	9679	6	0	4	Q2	2012	11.6400	3.6084	3.0000	1
83	9747	13	0	9	Q3	2012	7.7600	3.4920	2.0000	1
84	328	11	0	4	Q2	2012	11.2400	5.3952	4.0000	1
84	485	15	0	12	Q4	2012	11.2400	4.9456	4.0000	1
84	950	13	992	9	Q3	2012	11.2400	5.6200	4.0000	1
84	1187	13	0	11	Q4	2012	5.6200	1.7984	2.0000	1
84	1798	3	0	9	Q3	2012	8.4300	3.3720	3.0000	1
84	1916	13	984	5	Q2	2012	11.2400	4.0464	4.0000	1
84	1983	17	0	10	Q4	2012	8.4300	3.9621	3.0000	1
84	2215	11	0	8	Q3	2012	5.6200	2.0794	2.0000	1
84	2246	13	984	5	Q2	2012	11.2400	5.3952	4.0000	1
84	2272	17	0	4	Q2	2012	8.4300	2.8662	3.0000	1
84	2378	16	0	7	Q3	2012	8.4300	2.6976	3.0000	1
84	2568	11	0	4	Q2	2012	11.2400	4.9456	4.0000	1
84	2674	11	0	2	Q1	2012	5.6200	2.7538	2.0000	1
84	2715	15	0	7	Q3	2012	11.2400	4.7208	4.0000	1
84	2875	7	0	11	Q4	2012	8.4300	3.7092	3.0000	1
84	3000	17	1304	7	Q3	2012	5.6200	2.5290	2.0000	1
84	3012	24	0	7	Q3	2012	11.2400	4.8332	4.0000	1
84	3100	6	526	12	Q4	2012	5.6200	2.5290	2.0000	1
84	3196	13	0	4	Q2	2012	8.4300	3.0348	3.0000	1
84	3231	17	1312	10	Q4	2012	8.4300	3.5406	3.0000	1
84	3308	13	0	9	Q3	2012	8.4300	2.9505	3.0000	1
84	3351	22	1709	11	Q4	2012	5.6200	1.9108	2.0000	1
84	3471	11	0	9	Q3	2012	8.4300	3.3720	3.0000	1
84	3627	3	0	7	Q3	2012	5.6200	2.5290	2.0000	1
84	3742	11	0	2	Q1	2012	8.4300	2.8662	3.0000	1
84	3878	3	0	10	Q4	2012	11.2400	3.8216	4.0000	1
84	4231	17	0	4	Q2	2012	14.0500	7.0250	5.0000	1
84	4925	16	0	5	Q2	2012	8.4300	3.4563	3.0000	1
84	4998	3	0	2	Q1	2012	8.4300	3.0348	3.0000	1
84	5215	14	0	10	Q4	2012	2.8100	1.0116	1.0000	1
84	5742	16	0	7	Q3	2012	11.2400	3.5968	4.0000	1
84	5753	15	1150	8	Q3	2012	8.4300	3.6249	3.0000	1
84	5877	17	0	12	Q4	2012	8.4300	3.1191	3.0000	1
84	6086	7	0	3	Q1	2012	8.4300	2.8662	3.0000	1
84	6136	6	0	7	Q3	2012	14.0500	4.7770	5.0000	1
84	6628	6	508	4	Q2	2012	8.4300	2.6133	3.0000	1
84	6683	17	0	9	Q3	2012	5.6200	2.4166	2.0000	1
84	7056	3	210	12	Q4	2012	8.4300	3.5406	3.0000	1
84	7138	11	0	5	Q2	2012	5.6200	2.5852	2.0000	1
84	7357	24	1851	4	Q2	2012	11.2400	3.8216	4.0000	1
84	7496	13	0	1	Q1	2012	11.2400	5.2828	4.0000	1
84	7865	22	1694	4	Q2	2012	2.8100	1.1802	1.0000	1
84	7962	14	0	1	Q1	2012	2.8100	1.1240	1.0000	1
84	7988	11	0	7	Q3	2012	8.4300	3.6249	3.0000	1
84	8110	13	0	1	Q1	2012	8.4300	3.1191	3.0000	1
84	8110	13	0	10	Q4	2012	8.4300	4.1307	3.0000	1
84	8253	24	0	9	Q3	2012	11.2400	5.1704	4.0000	1
84	8291	13	0	1	Q1	2012	5.6200	2.8100	2.0000	1
84	8601	7	0	3	Q1	2012	8.4300	2.9505	3.0000	1
84	8976	13	992	9	Q3	2012	8.4300	4.0464	3.0000	1
84	9026	13	0	9	Q3	2012	11.2400	5.1704	4.0000	1
84	9612	15	1149	8	Q3	2012	8.4300	2.8662	3.0000	1
84	9897	16	1235	11	Q4	2012	8.4300	4.0464	3.0000	1
84	10007	7	0	10	Q4	2012	14.0500	4.4960	5.0000	1
84	10034	15	1140	4	Q2	2012	8.4300	3.3720	3.0000	1
84	10243	17	0	4	Q2	2012	5.6200	2.3604	2.0000	1
84	10273	17	0	9	Q3	2012	8.4300	2.6133	3.0000	1
85	419	14	1079	12	Q4	2012	2.7200	1.3328	2.0000	1
85	472	17	0	5	Q2	2012	4.0800	1.2648	3.0000	1
85	476	7	0	4	Q2	2012	2.7200	1.2240	2.0000	1
85	664	13	0	1	Q1	2012	5.4400	1.6864	4.0000	1
85	882	24	0	12	Q4	2012	4.0800	1.9584	3.0000	1
85	993	13	0	9	Q3	2012	4.0800	1.9584	3.0000	1
85	1255	6	0	6	Q2	2012	4.0800	1.4688	3.0000	1
85	1281	3	0	10	Q4	2012	4.0800	1.5096	3.0000	1
85	1289	23	1781	8	Q3	2012	4.0800	1.7136	3.0000	1
85	1492	15	0	8	Q3	2012	4.0800	1.6728	3.0000	1
85	1598	3	202	8	Q3	2012	2.7200	1.3600	2.0000	1
85	1758	3	0	9	Q3	2012	2.7200	1.1152	2.0000	1
85	2011	23	0	1	Q1	2012	4.0800	1.7952	3.0000	1
85	2159	14	0	5	Q2	2012	1.3600	0.4488	1.0000	1
85	2272	17	0	3	Q1	2012	4.0800	1.4280	3.0000	1
85	2280	13	980	3	Q1	2012	4.0800	1.4688	3.0000	1
85	2311	7	526	12	Q4	2012	5.4400	2.7200	4.0000	1
85	2448	16	0	2	Q1	2012	4.0800	1.7136	3.0000	1
85	2448	16	0	11	Q4	2012	4.0800	1.4688	3.0000	1
85	2483	24	0	1	Q1	2012	6.8000	3.0600	5.0000	1
85	2487	15	0	12	Q4	2012	4.0800	1.4280	3.0000	1
85	2640	6	0	4	Q2	2012	5.4400	1.7952	4.0000	1
85	3070	7	0	4	Q2	2012	4.0800	1.7952	3.0000	1
85	3463	13	0	2	Q1	2012	5.4400	2.4480	4.0000	1
85	3539	17	1307	8	Q3	2012	5.4400	2.0128	4.0000	1
85	3748	13	0	4	Q2	2012	4.0800	1.4280	3.0000	1
85	4070	23	0	3	Q1	2012	4.0800	1.2648	3.0000	1
85	4117	2	118	6	Q2	2012	1.3600	0.4488	1.0000	1
85	4327	7	0	3	Q1	2012	4.0800	1.4688	3.0000	1
85	4422	6	0	12	Q4	2012	5.4400	2.7200	4.0000	1
85	4507	13	0	8	Q3	2012	2.7200	0.9792	2.0000	1
85	4727	16	0	3	Q1	2012	4.0800	1.3872	3.0000	1
85	5295	16	1236	12	Q4	2012	2.7200	1.0336	2.0000	1
85	5407	24	0	6	Q2	2012	4.0800	1.7544	3.0000	1
85	5944	3	205	10	Q4	2012	4.0800	1.6320	3.0000	1
85	5956	22	1702	8	Q3	2012	1.3600	0.6392	1.0000	1
85	6313	17	0	5	Q2	2012	2.7200	1.1696	2.0000	1
85	6347	17	0	9	Q3	2012	2.7200	1.3600	2.0000	1
85	6630	24	1860	8	Q3	2012	2.7200	0.8432	2.0000	1
85	6954	24	1845	1	Q1	2012	2.7200	0.9520	2.0000	1
85	7124	6	511	5	Q2	2012	4.0800	1.8360	3.0000	1
85	7384	3	0	7	Q3	2012	2.7200	1.1152	2.0000	1
85	8185	2	0	11	Q4	2012	2.7200	0.9248	2.0000	1
85	8269	13	976	1	Q1	2012	5.4400	2.5568	4.0000	1
85	8283	17	1292	1	Q1	2012	5.4400	1.7408	4.0000	1
85	8416	11	0	4	Q2	2012	4.0800	1.4280	3.0000	1
85	8549	7	0	12	Q4	2012	5.4400	1.6864	4.0000	1
85	8779	13	0	4	Q2	2012	4.0800	1.6320	3.0000	1
85	8824	15	0	10	Q4	2012	4.0800	1.4280	3.0000	1
85	9103	6	506	3	Q1	2012	5.4400	2.1760	4.0000	1
85	9169	23	0	10	Q4	2012	4.0800	1.5504	3.0000	1
85	9236	13	0	12	Q4	2012	4.0800	1.5912	3.0000	1
85	9556	15	0	3	Q1	2012	2.7200	1.0336	2.0000	1
85	9697	23	1789	12	Q4	2012	5.4400	2.6112	4.0000	1
85	9721	15	0	6	Q2	2012	4.0800	1.7952	3.0000	1
85	9823	13	0	7	Q3	2012	5.4400	2.5568	4.0000	1
85	10166	11	0	5	Q2	2012	2.7200	1.1152	2.0000	1
86	192	16	0	9	Q3	2012	11.8800	5.2272	4.0000	1
86	280	13	0	10	Q4	2012	11.8800	5.9400	4.0000	1
86	424	6	0	9	Q3	2012	11.8800	3.5640	4.0000	1
86	481	24	0	10	Q4	2012	8.9100	4.2768	3.0000	1
86	1033	24	0	1	Q1	2012	5.9400	1.9602	2.0000	1
86	1069	6	511	5	Q2	2012	11.8800	5.2272	4.0000	1
86	1130	15	1141	4	Q2	2012	14.8500	7.1280	5.0000	1
86	1360	13	0	11	Q4	2012	8.9100	3.0294	3.0000	1
86	1598	3	0	11	Q4	2012	8.9100	3.7422	3.0000	1
86	1619	7	523	11	Q4	2012	11.8800	4.7520	4.0000	1
86	1798	3	0	11	Q4	2012	8.9100	3.8313	3.0000	1
86	1906	6	522	10	Q4	2012	8.9100	2.7621	3.0000	1
86	2224	16	0	10	Q4	2012	11.8800	4.7520	4.0000	1
86	2737	15	0	4	Q2	2012	8.9100	4.0986	3.0000	1
86	2787	17	0	3	Q1	2012	8.9100	2.7621	3.0000	1
86	2882	24	1858	7	Q3	2012	8.9100	2.7621	3.0000	1
86	3000	17	0	6	Q2	2012	5.9400	2.7324	2.0000	1
86	3254	15	0	4	Q2	2012	8.9100	4.2768	3.0000	1
86	3316	7	523	11	Q4	2012	8.9100	4.0986	3.0000	1
86	3387	11	826	5	Q2	2012	11.8800	4.9896	4.0000	1
86	3453	14	0	3	Q1	2012	2.9700	1.2771	1.0000	1
86	3469	24	0	9	Q3	2012	8.9100	3.9204	3.0000	1
86	3628	2	108	1	Q1	2012	5.9400	2.0790	2.0000	1
86	3702	7	512	6	Q2	2012	5.9400	2.2572	2.0000	1
86	3719	23	0	12	Q4	2012	8.9100	3.6531	3.0000	1
86	3744	6	0	9	Q3	2012	8.9100	4.4550	3.0000	1
86	4085	24	0	11	Q4	2012	8.9100	3.0294	3.0000	1
86	4315	17	0	7	Q3	2012	11.8800	4.2768	4.0000	1
86	4351	23	1781	8	Q3	2012	5.9400	2.6730	2.0000	1
86	4507	13	0	10	Q4	2012	5.9400	2.2572	2.0000	1
86	4518	13	0	3	Q1	2012	8.9100	3.2076	3.0000	1
86	4548	7	0	3	Q1	2012	8.9100	2.9403	3.0000	1
86	4711	3	197	6	Q2	2012	11.8800	5.7024	4.0000	1
86	4813	7	0	1	Q1	2012	8.9100	3.2967	3.0000	1
86	4824	3	0	1	Q1	2012	11.8800	4.9896	4.0000	1
86	4917	14	0	5	Q2	2012	8.9100	4.1877	3.0000	1
86	5060	13	0	5	Q2	2012	8.9100	4.0095	3.0000	1
86	5625	24	0	4	Q2	2012	14.8500	7.4250	5.0000	1
86	5742	16	0	6	Q2	2012	5.9400	2.7918	2.0000	1
86	5865	15	1146	7	Q3	2012	8.9100	3.0294	3.0000	1
86	6018	11	0	5	Q2	2012	5.9400	2.5542	2.0000	1
86	6132	3	0	6	Q2	2012	8.9100	2.8512	3.0000	1
86	6741	24	0	5	Q2	2012	8.9100	3.2076	3.0000	1
86	6763	7	0	9	Q3	2012	8.9100	2.7621	3.0000	1
86	6957	16	0	1	Q1	2012	8.9100	2.9403	3.0000	1
86	7179	11	0	1	Q1	2012	5.9400	2.7324	2.0000	1
86	7215	11	0	9	Q3	2012	5.9400	2.2572	2.0000	1
86	7276	23	0	5	Q2	2012	8.9100	4.3659	3.0000	1
86	7426	7	0	10	Q4	2012	8.9100	2.8512	3.0000	1
86	7607	17	0	5	Q2	2012	5.9400	2.6730	2.0000	1
86	7880	7	0	7	Q3	2012	14.8500	5.6430	5.0000	1
86	8089	17	1304	7	Q3	2012	11.8800	5.1084	4.0000	1
86	8175	15	0	3	Q1	2012	11.8800	4.9896	4.0000	1
86	8414	17	0	12	Q4	2012	5.9400	2.7324	2.0000	1
86	8436	15	0	1	Q1	2012	5.9400	2.6730	2.0000	1
86	8466	17	1307	8	Q3	2012	8.9100	3.0294	3.0000	1
86	8606	15	0	10	Q4	2012	8.9100	2.7621	3.0000	1
86	8902	3	0	2	Q1	2012	8.9100	4.0986	3.0000	1
86	8946	23	1788	11	Q4	2012	11.8800	4.0392	4.0000	1
86	9017	15	0	11	Q4	2012	5.9400	2.3760	2.0000	1
86	9064	17	0	5	Q2	2012	8.9100	4.0095	3.0000	1
86	9109	7	0	8	Q3	2012	8.9100	4.4550	3.0000	1
86	9176	23	0	3	Q1	2012	11.8800	3.5640	4.0000	1
86	9218	7	504	2	Q1	2012	11.8800	5.7024	4.0000	1
86	9498	23	0	9	Q3	2012	11.8800	4.9896	4.0000	1
86	9704	24	0	8	Q3	2012	8.9100	3.7422	3.0000	1
86	9721	15	0	2	Q1	2012	8.9100	3.9204	3.0000	1
86	9745	17	0	4	Q2	2012	14.8500	6.8310	5.0000	1
86	9760	13	980	3	Q1	2012	11.8800	5.4648	4.0000	1
86	10174	7	0	7	Q3	2012	5.9400	2.9106	2.0000	1
87	281	7	0	12	Q4	2012	3.5600	1.1748	2.0000	1
87	398	13	0	3	Q1	2012	7.1200	3.5600	4.0000	1
87	398	13	0	7	Q3	2012	5.3400	1.8690	3.0000	1
87	467	13	0	10	Q4	2012	3.5600	1.6376	2.0000	1
87	769	16	0	9	Q3	2012	7.1200	2.2784	4.0000	1
87	770	17	0	10	Q4	2012	5.3400	1.8156	3.0000	1
87	992	7	519	9	Q3	2012	7.1200	2.2784	4.0000	1
87	1202	11	821	3	Q1	2012	5.3400	1.9224	3.0000	1
87	1304	13	986	6	Q2	2012	7.1200	2.8480	4.0000	1
87	1633	3	207	11	Q4	2012	5.3400	1.9224	3.0000	1
87	1822	7	0	7	Q3	2012	7.1200	2.5632	4.0000	1
87	1994	15	0	11	Q4	2012	5.3400	2.6166	3.0000	1
87	2378	16	1228	8	Q3	2012	7.1200	2.2784	4.0000	1
87	2452	6	0	12	Q4	2012	5.3400	1.8690	3.0000	1
87	2829	23	1765	1	Q1	2012	7.1200	3.4888	4.0000	1
87	3054	24	0	4	Q2	2012	7.1200	2.9904	4.0000	1
87	3744	7	0	3	Q1	2012	7.1200	2.4920	4.0000	1
87	3897	13	0	4	Q2	2012	5.3400	2.3496	3.0000	1
87	4240	24	0	8	Q3	2012	7.1200	2.4920	4.0000	1
87	4473	15	1157	12	Q4	2012	5.3400	2.1360	3.0000	1
87	4589	13	988	7	Q3	2012	7.1200	3.3464	4.0000	1
87	5358	3	190	3	Q1	2012	3.5600	1.2816	2.0000	1
87	5923	23	0	8	Q3	2012	7.1200	2.9192	4.0000	1
87	5984	17	1293	1	Q1	2012	5.3400	1.9758	3.0000	1
87	6844	11	0	1	Q1	2012	3.5600	1.1036	2.0000	1
87	7175	7	0	1	Q1	2012	3.5600	1.6376	2.0000	1
87	7234	16	0	11	Q4	2012	5.3400	1.7088	3.0000	1
87	7683	22	0	12	Q4	2012	3.5600	1.4240	2.0000	1
87	8172	17	0	4	Q2	2012	5.3400	1.7088	3.0000	1
87	8275	16	0	4	Q2	2012	7.1200	2.9904	4.0000	1
87	8275	16	0	11	Q4	2012	7.1200	3.1328	4.0000	1
87	8358	11	0	9	Q3	2012	5.3400	1.8156	3.0000	1
87	8485	15	0	12	Q4	2012	3.5600	1.6376	2.0000	1
87	8571	3	0	12	Q4	2012	5.3400	2.1894	3.0000	1
87	8623	24	1856	6	Q2	2012	7.1200	3.4176	4.0000	1
87	8937	7	0	5	Q2	2012	3.5600	1.4952	2.0000	1
87	9401	13	0	8	Q3	2012	7.1200	3.5600	4.0000	1
87	9510	16	0	8	Q3	2012	7.1200	3.0616	4.0000	1
87	9668	13	0	7	Q3	2012	5.3400	2.3496	3.0000	1
87	9780	15	0	4	Q2	2012	5.3400	2.5632	3.0000	1
87	9956	17	0	9	Q3	2012	5.3400	1.6020	3.0000	1
87	10273	17	0	5	Q2	2012	3.5600	1.5308	2.0000	1
88	274	13	0	10	Q4	2012	2.5800	1.0836	3.0000	1
88	378	16	0	1	Q1	2012	2.5800	0.8514	3.0000	1
88	554	23	0	3	Q1	2012	3.4400	1.4104	4.0000	1
88	647	3	0	2	Q1	2012	3.4400	1.3072	4.0000	1
88	1720	16	0	11	Q4	2012	2.5800	1.2384	3.0000	1
88	1738	6	0	9	Q3	2012	1.7200	0.8084	2.0000	1
88	1874	17	1292	1	Q1	2012	2.5800	0.9288	3.0000	1
88	1916	13	984	5	Q2	2012	2.5800	0.9804	3.0000	1
88	1917	23	0	3	Q1	2012	1.7200	0.7740	2.0000	1
88	1928	7	523	11	Q4	2012	2.5800	1.1352	3.0000	1
88	2110	11	0	11	Q4	2012	3.4400	1.1008	4.0000	1
88	2171	23	0	4	Q2	2012	2.5800	1.0062	3.0000	1
88	2468	13	980	3	Q1	2012	2.5800	1.0578	3.0000	1
88	2699	24	1859	8	Q3	2012	3.4400	1.5480	4.0000	1
88	2767	11	0	9	Q3	2012	3.4400	1.5480	4.0000	1
88	3153	13	0	1	Q1	2012	1.7200	0.6536	2.0000	1
88	3268	13	0	12	Q4	2012	2.5800	1.1352	3.0000	1
88	3425	11	818	1	Q1	2012	1.7200	0.6020	2.0000	1
88	3691	17	0	3	Q1	2012	3.4400	1.0664	4.0000	1
88	3883	2	129	11	Q4	2012	0.8600	0.4300	1.0000	1
88	4099	17	1307	8	Q3	2012	2.5800	1.1610	3.0000	1
88	4160	24	0	5	Q2	2012	1.7200	0.7568	2.0000	1
88	4227	24	0	3	Q1	2012	2.5800	1.2126	3.0000	1
88	4231	17	0	4	Q2	2012	4.3000	2.1500	5.0000	1
88	4524	24	1845	1	Q1	2012	3.4400	1.5136	4.0000	1
88	4535	15	0	3	Q1	2012	2.5800	0.9804	3.0000	1
88	4600	2	0	2	Q1	2012	0.8600	0.4214	1.0000	1
88	5276	15	0	8	Q3	2012	3.4400	1.5480	4.0000	1
88	5353	23	0	10	Q4	2012	1.7200	0.6708	2.0000	1
88	5437	7	504	2	Q1	2012	2.5800	1.0578	3.0000	1
88	5542	16	0	5	Q2	2012	3.4400	1.2384	4.0000	1
88	5644	17	0	12	Q4	2012	2.5800	0.7998	3.0000	1
88	6008	17	0	7	Q3	2012	2.5800	1.2126	3.0000	1
88	6162	17	0	12	Q4	2012	2.5800	1.2900	3.0000	1
88	6171	15	0	8	Q3	2012	2.5800	1.1094	3.0000	1
88	6529	17	0	8	Q3	2012	2.5800	0.7998	3.0000	1
88	6937	11	0	7	Q3	2012	1.7200	0.8428	2.0000	1
88	7032	2	0	12	Q4	2012	1.7200	0.5504	2.0000	1
88	7109	11	821	2	Q1	2012	1.7200	0.6192	2.0000	1
88	7263	11	0	11	Q4	2012	2.5800	1.1868	3.0000	1
88	7502	16	1231	9	Q3	2012	3.4400	1.1696	4.0000	1
88	7747	6	0	11	Q4	2012	2.5800	0.9804	3.0000	1
88	8242	17	0	12	Q4	2012	2.5800	0.9288	3.0000	1
88	8312	7	0	4	Q2	2012	1.7200	0.7396	2.0000	1
88	8403	11	0	3	Q1	2012	2.5800	1.0062	3.0000	1
88	8687	23	1769	3	Q1	2012	2.5800	1.0320	3.0000	1
88	8782	7	0	1	Q1	2012	2.5800	0.7998	3.0000	1
88	9088	15	0	7	Q3	2012	3.4400	1.6168	4.0000	1
88	9468	11	829	6	Q2	2012	2.5800	1.1610	3.0000	1
88	9892	13	980	3	Q1	2012	2.5800	1.0836	3.0000	1
88	10106	13	0	5	Q2	2012	2.5800	1.1610	3.0000	1
89	398	13	0	9	Q3	2012	4.7700	1.4787	3.0000	1
89	502	15	0	3	Q1	2012	6.3600	1.9080	4.0000	1
89	621	11	0	11	Q4	2012	3.1800	1.4310	2.0000	1
89	769	16	0	12	Q4	2012	6.3600	3.1800	4.0000	1
89	873	24	0	2	Q1	2012	6.3600	3.0528	4.0000	1
89	1083	11	842	12	Q4	2012	3.1800	1.1448	2.0000	1
89	1216	17	1307	8	Q3	2012	4.7700	1.6695	3.0000	1
89	1528	16	0	5	Q2	2012	3.1800	1.3674	2.0000	1
89	1785	3	0	10	Q4	2012	4.7700	1.6695	3.0000	1
89	2077	23	0	3	Q1	2012	6.3600	2.6076	4.0000	1
89	2263	11	0	10	Q4	2012	6.3600	2.7984	4.0000	1
89	2663	16	0	8	Q3	2012	3.1800	1.1448	2.0000	1
89	2674	11	818	1	Q1	2012	6.3600	2.0352	4.0000	1
89	2724	24	0	8	Q3	2012	4.7700	1.5741	3.0000	1
89	2762	13	0	7	Q3	2012	4.7700	1.7172	3.0000	1
89	2961	7	0	8	Q3	2012	6.3600	2.0352	4.0000	1
89	3166	24	0	11	Q4	2012	4.7700	1.5264	3.0000	1
89	3250	15	0	5	Q2	2012	6.3600	2.0988	4.0000	1
89	3524	13	0	8	Q3	2012	4.7700	2.0988	3.0000	1
89	3799	13	0	6	Q2	2012	3.1800	1.5900	2.0000	1
89	3969	7	0	10	Q4	2012	6.3600	2.4168	4.0000	1
89	4094	16	1235	11	Q4	2012	6.3600	2.6712	4.0000	1
89	4261	13	0	11	Q4	2012	3.1800	1.1448	2.0000	1
89	4351	23	1769	3	Q1	2012	6.3600	2.0352	4.0000	1
89	4630	15	0	1	Q1	2012	3.1800	1.3674	2.0000	1
89	4677	11	0	5	Q2	2012	3.1800	1.3674	2.0000	1
89	4842	6	0	7	Q3	2012	6.3600	2.6712	4.0000	1
89	5022	15	0	11	Q4	2012	3.1800	1.4310	2.0000	1
89	5302	11	0	3	Q1	2012	3.1800	0.9858	2.0000	1
89	5450	24	1869	12	Q4	2012	4.7700	1.6218	3.0000	1
89	5530	13	988	7	Q3	2012	3.1800	1.1448	2.0000	1
89	5644	17	1307	8	Q3	2012	4.7700	1.4787	3.0000	1
89	5958	13	0	9	Q3	2012	6.3600	2.8620	4.0000	1
89	6380	14	0	5	Q2	2012	4.7700	1.6695	3.0000	1
89	6690	17	0	8	Q3	2012	4.7700	2.3373	3.0000	1
89	6939	7	526	12	Q4	2012	6.3600	2.6076	4.0000	1
89	7196	6	0	1	Q1	2012	6.3600	2.8620	4.0000	1
89	7232	11	820	2	Q1	2012	3.1800	1.1448	2.0000	1
89	7282	17	0	8	Q3	2012	3.1800	1.3038	2.0000	1
89	7853	15	1142	5	Q2	2012	4.7700	2.2896	3.0000	1
89	7906	13	0	7	Q3	2012	4.7700	2.1465	3.0000	1
89	7921	14	0	9	Q3	2012	3.1800	1.2720	2.0000	1
89	8269	13	976	1	Q1	2012	4.7700	1.4310	3.0000	1
89	8442	17	0	12	Q4	2012	6.3600	2.0988	4.0000	1
89	8452	16	0	9	Q3	2012	6.3600	2.4168	4.0000	1
89	8577	23	0	7	Q3	2012	4.7700	1.8603	3.0000	1
89	8731	3	0	9	Q3	2012	4.7700	1.6695	3.0000	1
89	9412	15	0	9	Q3	2012	4.7700	2.2419	3.0000	1
89	9447	13	0	2	Q1	2012	4.7700	2.2419	3.0000	1
89	9510	16	0	8	Q3	2012	4.7700	2.1465	3.0000	1
89	9512	23	1786	10	Q4	2012	6.3600	2.4168	4.0000	1
89	9639	17	1304	7	Q3	2012	4.7700	1.8126	3.0000	1
89	9682	15	0	9	Q3	2012	3.1800	1.1766	2.0000	1
89	9757	24	1869	12	Q4	2012	3.1800	1.5900	2.0000	1
89	9916	6	523	11	Q4	2012	4.7700	2.2896	3.0000	1
89	10033	3	0	2	Q1	2012	4.7700	2.3850	3.0000	1
89	10098	7	512	6	Q2	2012	4.7700	1.6695	3.0000	1
89	10098	7	523	11	Q4	2012	4.7700	1.6695	3.0000	1
89	10250	17	0	12	Q4	2012	6.3600	2.4804	4.0000	1
90	74	15	0	7	Q3	2012	2.3100	1.1088	3.0000	1
90	394	14	1061	4	Q2	2012	0.7700	0.3003	1.0000	1
90	527	7	0	3	Q1	2012	1.5400	0.6930	2.0000	1
90	545	13	0	6	Q2	2012	3.0800	1.3552	4.0000	1
90	588	23	0	4	Q2	2012	3.0800	1.4168	4.0000	1
90	950	13	0	7	Q3	2012	3.0800	1.2936	4.0000	1
90	1079	7	0	5	Q2	2012	1.5400	0.6930	2.0000	1
90	1112	24	1845	1	Q1	2012	2.3100	0.8316	3.0000	1
90	1310	16	0	1	Q1	2012	2.3100	0.9933	3.0000	1
90	1658	15	0	10	Q4	2012	3.0800	0.9240	4.0000	1
90	1791	13	0	1	Q1	2012	1.5400	0.5236	2.0000	1
90	2019	16	1216	2	Q1	2012	3.0800	1.5400	4.0000	1
90	2189	7	0	9	Q3	2012	1.5400	0.7238	2.0000	1
90	2232	6	0	3	Q1	2012	2.3100	1.1088	3.0000	1
90	2270	11	0	11	Q4	2012	1.5400	0.6776	2.0000	1
90	2390	17	0	3	Q1	2012	3.0800	1.3860	4.0000	1
90	2636	17	0	12	Q4	2012	1.5400	0.5082	2.0000	1
90	2784	15	1154	10	Q4	2012	3.0800	1.2628	4.0000	1
90	3068	11	833	8	Q3	2012	2.3100	0.9240	3.0000	1
90	3102	24	0	11	Q4	2012	3.0800	1.2628	4.0000	1
90	3418	3	0	9	Q3	2012	2.3100	1.0164	3.0000	1
90	3706	13	0	5	Q2	2012	2.3100	0.9471	3.0000	1
90	3735	24	0	4	Q2	2012	3.0800	1.1704	4.0000	1
90	3799	13	976	1	Q1	2012	3.0800	1.5092	4.0000	1
90	3813	7	504	2	Q1	2012	3.0800	1.2936	4.0000	1
90	3825	22	1689	2	Q1	2012	2.3100	0.9702	3.0000	1
90	4021	16	0	8	Q3	2012	3.0800	0.9856	4.0000	1
90	4029	17	1293	1	Q1	2012	1.5400	0.7392	2.0000	1
90	4096	3	0	10	Q4	2012	2.3100	1.1088	3.0000	1
90	4165	3	0	2	Q1	2012	2.3100	0.8316	3.0000	1
90	4289	24	0	9	Q3	2012	2.3100	1.0164	3.0000	1
90	4351	23	0	9	Q3	2012	3.0800	0.9856	4.0000	1
90	4858	17	0	8	Q3	2012	2.3100	0.7392	3.0000	1
90	5590	17	1307	8	Q3	2012	2.3100	0.9933	3.0000	1
90	5655	7	504	2	Q1	2012	3.0800	1.4784	4.0000	1
90	5781	11	0	11	Q4	2012	2.3100	0.9240	3.0000	1
90	5870	14	0	8	Q3	2012	1.5400	0.4774	2.0000	1
90	5947	6	0	7	Q3	2012	3.0800	1.5092	4.0000	1
90	5962	17	1312	10	Q4	2012	2.3100	1.1088	3.0000	1
90	6096	7	0	3	Q1	2012	2.3100	0.8085	3.0000	1
90	6105	23	0	6	Q2	2012	3.0800	0.9856	4.0000	1
90	6113	16	0	7	Q3	2012	1.5400	0.5698	2.0000	1
90	6421	6	0	10	Q4	2012	2.3100	0.8316	3.0000	1
90	6421	7	0	5	Q2	2012	1.5400	0.7546	2.0000	1
90	6766	24	0	11	Q4	2012	2.3100	0.7161	3.0000	1
90	7072	16	1216	2	Q1	2012	2.3100	0.8778	3.0000	1
90	7233	22	0	8	Q3	2012	0.7700	0.2849	1.0000	1
90	7276	23	0	3	Q1	2012	2.3100	1.0164	3.0000	1
90	7434	11	0	12	Q4	2012	3.0800	1.3244	4.0000	1
90	7573	3	0	4	Q2	2012	1.5400	0.4774	2.0000	1
90	7607	17	0	5	Q2	2012	3.0800	1.2936	4.0000	1
90	7704	3	187	2	Q1	2012	2.3100	0.7854	3.0000	1
90	8181	17	0	3	Q1	2012	2.3100	1.0395	3.0000	1
90	8269	13	0	8	Q3	2012	1.5400	0.5544	2.0000	1
90	8435	17	0	3	Q1	2012	1.5400	0.5698	2.0000	1
90	8464	15	1157	12	Q4	2012	3.0800	1.1704	4.0000	1
90	8731	3	187	2	Q1	2012	1.5400	0.5698	2.0000	1
90	8937	7	0	7	Q3	2012	2.3100	0.9009	3.0000	1
90	9025	13	0	10	Q4	2012	2.3100	0.6930	3.0000	1
90	9184	3	210	12	Q4	2012	3.0800	1.5092	4.0000	1
90	9781	3	0	10	Q4	2012	2.3100	0.9009	3.0000	1
90	9871	13	0	8	Q3	2012	2.3100	0.9240	3.0000	1
90	9956	17	1312	10	Q4	2012	2.3100	0.8316	3.0000	1
90	10149	7	512	6	Q2	2012	1.5400	0.6006	2.0000	1
90	10149	7	523	11	Q4	2012	2.3100	1.1088	3.0000	1
90	10225	23	0	11	Q4	2012	2.3100	0.9240	3.0000	1
91	447	6	519	9	Q3	2012	8.0400	2.4924	3.0000	1
91	661	7	517	8	Q3	2012	8.0400	3.6180	3.0000	1
91	710	15	0	12	Q4	2012	10.7200	4.6096	4.0000	1
91	1237	7	0	12	Q4	2012	5.3600	1.8760	2.0000	1
91	1319	11	820	2	Q1	2012	10.7200	5.1456	4.0000	1
91	1352	17	0	8	Q3	2012	10.7200	4.9312	4.0000	1
91	1690	16	0	1	Q1	2012	10.7200	5.0384	4.0000	1
91	2168	24	0	4	Q2	2012	10.7200	4.0736	4.0000	1
91	2448	16	0	12	Q4	2012	8.0400	3.0552	3.0000	1
91	2777	13	0	11	Q4	2012	8.0400	4.0200	3.0000	1
91	2850	3	0	4	Q2	2012	8.0400	2.8140	3.0000	1
91	2929	24	0	5	Q2	2012	8.0400	3.5376	3.0000	1
91	3236	15	1157	12	Q4	2012	10.7200	5.3600	4.0000	1
91	3239	17	0	4	Q2	2012	8.0400	3.5376	3.0000	1
91	3325	13	980	3	Q1	2012	5.3600	2.5728	2.0000	1
91	3422	23	0	12	Q4	2012	10.7200	4.7168	4.0000	1
91	3434	24	0	8	Q3	2012	13.4000	4.1540	5.0000	1
91	3567	16	0	9	Q3	2012	5.3600	1.9832	2.0000	1
91	4056	11	0	12	Q4	2012	5.3600	1.7688	2.0000	1
91	4460	3	0	5	Q2	2012	10.7200	5.0384	4.0000	1
91	4466	13	988	7	Q3	2012	5.3600	2.4656	2.0000	1
91	4767	16	1235	11	Q4	2012	8.0400	3.6984	3.0000	1
91	4804	13	0	1	Q1	2012	8.0400	2.8140	3.0000	1
91	4948	13	0	6	Q2	2012	10.7200	3.8592	4.0000	1
91	5002	23	1786	10	Q4	2012	8.0400	2.7336	3.0000	1
91	5200	24	0	12	Q4	2012	10.7200	3.8592	4.0000	1
91	5724	11	0	4	Q2	2012	5.3600	2.5192	2.0000	1
91	6153	16	0	3	Q1	2012	13.4000	5.0920	5.0000	1
91	6423	17	0	12	Q4	2012	10.7200	3.6448	4.0000	1
91	6698	13	980	3	Q1	2012	8.0400	3.8592	3.0000	1
91	7051	16	0	5	Q2	2012	5.3600	1.9296	2.0000	1
91	7065	17	0	6	Q2	2012	5.3600	2.1976	2.0000	1
91	7141	17	0	10	Q4	2012	10.7200	3.5376	4.0000	1
91	7149	13	0	7	Q3	2012	10.7200	5.3600	4.0000	1
91	7153	3	0	4	Q2	2012	5.3600	2.4120	2.0000	1
91	8477	3	0	9	Q3	2012	8.0400	2.6532	3.0000	1
91	8594	7	504	2	Q1	2012	8.0400	2.4924	3.0000	1
91	8699	7	0	6	Q2	2012	8.0400	3.4572	3.0000	1
91	8731	3	0	9	Q3	2012	8.0400	3.5376	3.0000	1
91	8772	11	0	5	Q2	2012	10.7200	3.2160	4.0000	1
91	8902	3	0	4	Q2	2012	8.0400	2.5728	3.0000	1
91	9698	23	0	7	Q3	2012	5.3600	2.4656	2.0000	1
91	9745	17	1297	3	Q1	2012	8.0400	3.4572	3.0000	1
91	9851	3	0	2	Q1	2012	5.3600	2.5192	2.0000	1
92	753	3	197	6	Q2	2012	3.3200	1.0956	4.0000	1
92	769	16	1216	2	Q1	2012	3.3200	1.6600	4.0000	1
92	1193	13	0	1	Q1	2012	3.3200	1.6268	4.0000	1
92	1675	15	0	1	Q1	2012	3.3200	1.4276	4.0000	1
92	1850	16	1235	11	Q4	2012	2.4900	1.1952	3.0000	1
92	1890	24	0	11	Q4	2012	3.3200	1.0292	4.0000	1
92	1913	15	0	12	Q4	2012	1.6600	0.6806	2.0000	1
92	1978	15	0	12	Q4	2012	3.3200	1.4608	4.0000	1
92	2075	13	0	9	Q3	2012	1.6600	0.8300	2.0000	1
92	2197	11	0	11	Q4	2012	3.3200	1.1288	4.0000	1
92	2444	13	0	6	Q2	2012	2.4900	1.1205	3.0000	1
92	2662	11	0	1	Q1	2012	3.3200	1.4608	4.0000	1
92	2947	17	1312	10	Q4	2012	1.6600	0.6142	2.0000	1
92	3187	24	0	10	Q4	2012	1.6600	0.6142	2.0000	1
92	3467	15	0	7	Q3	2012	1.6600	0.7968	2.0000	1
92	3786	15	1141	4	Q2	2012	2.4900	0.9711	3.0000	1
92	3826	16	0	5	Q2	2012	2.4900	0.9213	3.0000	1
92	4175	16	1214	2	Q1	2012	2.4900	1.1703	3.0000	1
92	4664	6	0	12	Q4	2012	3.3200	1.6268	4.0000	1
92	5013	7	0	12	Q4	2012	2.4900	1.1205	3.0000	1
92	5432	16	0	7	Q3	2012	3.3200	1.1620	4.0000	1
92	5503	6	0	11	Q4	2012	2.4900	0.8217	3.0000	1
92	5612	15	1140	4	Q2	2012	3.3200	1.1288	4.0000	1
92	5741	24	0	1	Q1	2012	1.6600	0.6806	2.0000	1
92	5744	3	201	8	Q3	2012	3.3200	1.1952	4.0000	1
92	5898	3	0	4	Q2	2012	3.3200	1.4608	4.0000	1
92	6423	17	0	1	Q1	2012	3.3200	1.4608	4.0000	1
92	6736	17	0	2	Q1	2012	2.4900	0.7719	3.0000	1
92	6966	24	1860	8	Q3	2012	1.6600	0.6142	2.0000	1
92	7105	24	1858	7	Q3	2012	2.4900	0.8964	3.0000	1
92	7195	7	0	3	Q1	2012	3.3200	1.5604	4.0000	1
92	7281	17	0	11	Q4	2012	2.4900	0.7719	3.0000	1
92	7743	3	0	9	Q3	2012	2.4900	0.8715	3.0000	1
92	7871	6	0	10	Q4	2012	2.4900	1.1205	3.0000	1
92	7909	3	0	9	Q3	2012	3.3200	1.5604	4.0000	1
92	8199	17	0	12	Q4	2012	2.4900	0.9462	3.0000	1
92	8439	13	0	6	Q2	2012	1.6600	0.7470	2.0000	1
92	8477	3	0	11	Q4	2012	2.4900	0.7968	3.0000	1
92	8490	24	0	9	Q3	2012	2.4900	0.8466	3.0000	1
92	8600	6	0	10	Q4	2012	2.4900	0.7719	3.0000	1
92	8863	6	0	12	Q4	2012	3.3200	1.1620	4.0000	1
92	9029	3	0	8	Q3	2012	1.6600	0.5312	2.0000	1
92	9487	17	0	12	Q4	2012	1.6600	0.5976	2.0000	1
93	130	14	0	12	Q4	2012	1.9200	0.6528	2.0000	1
93	229	15	1143	5	Q2	2012	2.8800	1.0080	3.0000	1
93	377	7	0	3	Q1	2012	2.8800	1.1520	3.0000	1
93	551	7	0	4	Q2	2012	1.9200	0.9216	2.0000	1
93	690	24	1856	6	Q2	2012	3.8400	1.8432	4.0000	1
93	733	24	1851	4	Q2	2012	2.8800	1.2384	3.0000	1
93	734	7	0	7	Q3	2012	1.9200	0.8640	2.0000	1
93	741	24	0	9	Q3	2012	2.8800	1.2096	3.0000	1
93	1039	24	1856	6	Q2	2012	2.8800	1.4112	3.0000	1
93	1338	24	1869	12	Q4	2012	1.9200	0.6144	2.0000	1
93	1426	13	0	4	Q2	2012	2.8800	1.2384	3.0000	1
93	2134	11	0	3	Q1	2012	2.8800	0.9504	3.0000	1
93	2185	14	1064	5	Q2	2012	0.9600	0.3456	1.0000	1
93	2760	7	501	1	Q1	2012	1.9200	0.5952	2.0000	1
93	2896	3	0	9	Q3	2012	2.8800	1.1808	3.0000	1
93	3413	15	0	2	Q1	2012	2.8800	1.2384	3.0000	1
93	3418	3	0	3	Q1	2012	2.8800	1.3536	3.0000	1
93	3985	11	0	1	Q1	2012	3.8400	1.5360	4.0000	1
93	3985	11	0	10	Q4	2012	3.8400	1.5360	4.0000	1
93	4161	6	502	1	Q1	2012	1.9200	0.7296	2.0000	1
93	4204	17	0	12	Q4	2012	2.8800	1.1808	3.0000	1
93	4375	6	508	4	Q2	2012	1.9200	0.9216	2.0000	1
93	4938	13	0	3	Q1	2012	2.8800	1.0080	3.0000	1
93	5542	16	0	4	Q2	2012	2.8800	0.8928	3.0000	1
93	5925	15	0	2	Q1	2012	3.8400	1.7280	4.0000	1
93	6218	11	837	10	Q4	2012	1.9200	0.8256	2.0000	1
93	6320	24	0	9	Q3	2012	3.8400	1.3440	4.0000	1
93	6348	16	0	1	Q1	2012	3.8400	1.2288	4.0000	1
93	6348	16	1220	4	Q2	2012	2.8800	1.2672	3.0000	1
93	6792	13	0	3	Q1	2012	4.8000	1.4880	5.0000	1
93	6951	15	0	11	Q4	2012	2.8800	1.1808	3.0000	1
93	7366	3	210	12	Q4	2012	3.8400	1.3824	4.0000	1
93	7433	11	0	4	Q2	2012	2.8800	0.9792	3.0000	1
93	7449	24	1860	8	Q3	2012	3.8400	1.7664	4.0000	1
93	7868	24	0	4	Q2	2012	1.9200	0.5952	2.0000	1
93	7951	15	0	9	Q3	2012	2.8800	1.0080	3.0000	1
93	8403	11	820	2	Q1	2012	1.9200	0.7488	2.0000	1
93	8430	6	0	12	Q4	2012	2.8800	1.1232	3.0000	1
93	8576	11	0	9	Q3	2012	1.9200	0.5952	2.0000	1
93	8663	13	1000	12	Q4	2012	3.8400	1.1904	4.0000	1
93	8747	7	0	10	Q4	2012	2.8800	0.8928	3.0000	1
93	9102	3	0	12	Q4	2012	2.8800	1.0368	3.0000	1
93	9639	17	1304	7	Q3	2012	1.9200	0.6528	2.0000	1
93	9747	13	0	5	Q2	2012	1.9200	0.8256	2.0000	1
93	9863	13	0	12	Q4	2012	2.8800	1.1232	3.0000	1
93	9928	16	0	11	Q4	2012	4.8000	1.5360	5.0000	1
93	9960	7	0	1	Q1	2012	2.8800	1.4400	3.0000	1
93	10186	13	0	6	Q2	2012	3.8400	1.2288	4.0000	1
93	10250	17	1297	3	Q1	2012	2.8800	1.1232	3.0000	1
94	280	13	992	9	Q3	2012	1.8600	0.8370	3.0000	1
94	611	24	0	4	Q2	2012	1.8600	0.8370	3.0000	1
94	1516	14	0	10	Q4	2012	0.6200	0.2480	1.0000	1
94	1599	7	0	1	Q1	2012	1.8600	0.6138	3.0000	1
94	1856	24	0	2	Q1	2012	1.2400	0.4464	2.0000	1
94	2093	7	0	12	Q4	2012	1.8600	0.8184	3.0000	1
94	2201	16	0	8	Q3	2012	1.8600	0.6696	3.0000	1
94	2236	15	1149	8	Q3	2012	2.4800	0.9176	4.0000	1
94	2548	13	0	1	Q1	2012	2.4800	0.7936	4.0000	1
94	2584	24	0	9	Q3	2012	1.8600	0.8928	3.0000	1
94	2850	3	0	12	Q4	2012	1.8600	0.9114	3.0000	1
94	3239	17	0	12	Q4	2012	1.2400	0.5580	2.0000	1
94	3283	15	0	8	Q3	2012	1.8600	0.9114	3.0000	1
94	3298	6	0	4	Q2	2012	2.4800	0.8184	4.0000	1
94	3410	24	0	11	Q4	2012	1.2400	0.4588	2.0000	1
94	3539	17	1304	7	Q3	2012	1.8600	0.6696	3.0000	1
94	4078	3	0	4	Q2	2012	1.8600	0.6324	3.0000	1
94	4289	24	1853	5	Q2	2012	2.4800	0.9424	4.0000	1
94	4330	13	992	9	Q3	2012	1.8600	0.8742	3.0000	1
94	4453	11	836	9	Q3	2012	1.8600	0.8556	3.0000	1
94	4787	2	0	12	Q4	2012	0.6200	0.2976	1.0000	1
94	4873	17	1314	11	Q4	2012	1.8600	0.6882	3.0000	1
94	5206	13	0	11	Q4	2012	2.4800	1.0416	4.0000	1
94	5295	16	0	10	Q4	2012	2.4800	1.1408	4.0000	1
94	5340	11	829	6	Q2	2012	1.2400	0.4588	2.0000	1
94	5354	15	0	12	Q4	2012	2.4800	1.1904	4.0000	1
94	6530	17	1304	7	Q3	2012	2.4800	1.1160	4.0000	1
94	6851	7	0	12	Q4	2012	1.8600	0.7812	3.0000	1
94	6888	23	0	11	Q4	2012	2.4800	0.9424	4.0000	1
94	6916	7	512	6	Q2	2012	2.4800	1.0168	4.0000	1
94	6957	16	0	1	Q1	2012	2.4800	0.8432	4.0000	1
94	7031	11	0	6	Q2	2012	1.8600	0.6696	3.0000	1
94	7095	24	0	4	Q2	2012	1.8600	0.8742	3.0000	1
94	7132	13	0	5	Q2	2012	2.4800	0.9920	4.0000	1
94	7580	17	1304	7	Q3	2012	1.8600	0.7998	3.0000	1
94	7768	15	0	3	Q1	2012	2.4800	0.7936	4.0000	1
94	7769	11	0	7	Q3	2012	1.8600	0.7998	3.0000	1
94	8146	11	0	1	Q1	2012	1.2400	0.4712	2.0000	1
94	8872	24	0	3	Q1	2012	1.8600	0.7440	3.0000	1
94	9057	24	1846	2	Q1	2012	1.2400	0.4340	2.0000	1
94	9230	15	0	1	Q1	2012	1.2400	0.5332	2.0000	1
94	9297	13	0	12	Q4	2012	2.4800	1.2152	4.0000	1
94	9327	17	0	1	Q1	2012	2.4800	1.0664	4.0000	1
94	9471	6	508	4	Q2	2012	1.2400	0.4340	2.0000	1
94	9694	7	504	2	Q1	2012	1.2400	0.4464	2.0000	1
94	9797	16	1231	9	Q3	2012	1.8600	0.7626	3.0000	1
94	10049	7	0	5	Q2	2012	1.2400	0.4092	2.0000	1
95	14	24	0	7	Q3	2012	4.3800	1.4454	3.0000	1
95	273	7	505	2	Q1	2012	4.3800	1.5330	3.0000	1
95	499	24	0	1	Q1	2012	5.8400	1.8104	4.0000	1
95	499	24	0	10	Q4	2012	4.3800	1.8834	3.0000	1
95	653	6	0	11	Q4	2012	2.9200	0.9344	2.0000	1
95	750	13	0	3	Q1	2012	5.8400	2.7448	4.0000	1
95	886	15	0	2	Q1	2012	2.9200	0.9052	2.0000	1
95	901	13	0	4	Q2	2012	4.3800	1.5330	3.0000	1
95	994	13	0	7	Q3	2012	4.3800	1.6206	3.0000	1
95	1003	17	0	11	Q4	2012	5.8400	2.8032	4.0000	1
95	1145	17	1307	8	Q3	2012	4.3800	2.1024	3.0000	1
95	1289	23	1781	8	Q3	2012	4.3800	1.5768	3.0000	1
95	1684	15	1140	4	Q2	2012	4.3800	2.1900	3.0000	1
95	2127	15	0	4	Q2	2012	4.3800	1.9710	3.0000	1
95	2368	3	188	2	Q1	2012	4.3800	1.8396	3.0000	1
95	2426	17	0	2	Q1	2012	2.9200	1.4016	2.0000	1
95	2448	16	1223	6	Q2	2012	4.3800	1.7082	3.0000	1
95	2724	24	0	8	Q3	2012	4.3800	1.6206	3.0000	1
95	3066	24	0	11	Q4	2012	2.9200	1.1388	2.0000	1
95	3075	23	1789	12	Q4	2012	2.9200	0.9636	2.0000	1
95	3252	24	1850	3	Q1	2012	2.9200	1.1680	2.0000	1
95	3538	11	0	9	Q3	2012	5.8400	2.2192	4.0000	1
95	3567	16	1235	11	Q4	2012	4.3800	1.6206	3.0000	1
95	3611	24	0	7	Q3	2012	4.3800	1.8396	3.0000	1
95	3852	24	1866	11	Q4	2012	5.8400	2.8032	4.0000	1
95	3889	3	0	12	Q4	2012	4.3800	2.0586	3.0000	1
95	4251	6	510	5	Q2	2012	5.8400	1.9856	4.0000	1
95	4434	15	0	9	Q3	2012	4.3800	1.3578	3.0000	1
95	4633	7	0	5	Q2	2012	4.3800	2.1024	3.0000	1
95	4659	13	0	3	Q1	2012	4.3800	1.5768	3.0000	1
95	4821	6	0	10	Q4	2012	4.3800	2.1900	3.0000	1
95	4873	17	0	5	Q2	2012	4.3800	1.8834	3.0000	1
95	4875	13	0	3	Q1	2012	2.9200	1.4600	2.0000	1
95	4909	7	504	2	Q1	2012	2.9200	1.0512	2.0000	1
95	5026	17	0	1	Q1	2012	4.3800	1.6206	3.0000	1
95	5742	16	0	7	Q3	2012	5.8400	2.3360	4.0000	1
95	6113	16	0	5	Q2	2012	5.8400	2.4528	4.0000	1
95	6153	16	0	3	Q1	2012	4.3800	1.4892	3.0000	1
95	6372	17	0	9	Q3	2012	4.3800	1.8834	3.0000	1
95	7266	24	0	4	Q2	2012	2.9200	1.4308	2.0000	1
95	7355	13	0	6	Q2	2012	5.8400	2.8032	4.0000	1
95	7362	11	836	9	Q3	2012	5.8400	2.2192	4.0000	1
95	7368	11	0	1	Q1	2012	2.9200	1.3432	2.0000	1
95	7464	11	0	10	Q4	2012	2.9200	1.1388	2.0000	1
95	7667	7	0	7	Q3	2012	5.8400	2.8032	4.0000	1
95	7769	11	0	1	Q1	2012	4.3800	2.0586	3.0000	1
95	7852	11	829	6	Q2	2012	4.3800	2.1462	3.0000	1
95	7919	2	121	8	Q3	2012	4.3800	1.4016	3.0000	1
95	8215	11	836	9	Q3	2012	4.3800	1.3578	3.0000	1
95	8359	17	0	7	Q3	2012	4.3800	1.6206	3.0000	1
95	8578	23	0	2	Q1	2012	5.8400	1.8688	4.0000	1
95	8787	7	0	4	Q2	2012	4.3800	2.0148	3.0000	1
95	9187	17	1294	2	Q1	2012	4.3800	2.1462	3.0000	1
95	9373	15	0	7	Q3	2012	2.9200	1.0220	2.0000	1
95	9795	11	0	2	Q1	2012	4.3800	1.8834	3.0000	1
95	9825	13	980	3	Q1	2012	4.3800	1.9272	3.0000	1
95	10026	13	0	1	Q1	2012	4.3800	1.9710	3.0000	1
95	10173	16	0	10	Q4	2012	4.3800	1.7520	3.0000	1
96	230	2	0	12	Q4	2012	4.2200	1.9412	2.0000	1
96	350	6	502	1	Q1	2012	6.3300	2.2155	3.0000	1
96	377	6	523	11	Q4	2012	4.2200	1.9834	2.0000	1
96	619	13	0	7	Q3	2012	6.3300	2.2155	3.0000	1
96	1042	11	0	9	Q3	2012	6.3300	2.4687	3.0000	1
96	1144	6	0	12	Q4	2012	8.4400	2.5320	4.0000	1
96	1297	16	0	3	Q1	2012	8.4400	4.1356	4.0000	1
96	1322	7	0	12	Q4	2012	10.5500	3.7980	5.0000	1
96	1468	13	0	8	Q3	2012	4.2200	1.3082	2.0000	1
96	1850	16	1225	7	Q3	2012	6.3300	3.0384	3.0000	1
96	1899	6	518	8	Q3	2012	6.3300	2.0889	3.0000	1
96	2194	7	518	8	Q3	2012	6.3300	2.8485	3.0000	1
96	2422	13	0	6	Q2	2012	6.3300	2.3421	3.0000	1
96	2784	15	1146	7	Q3	2012	8.4400	2.7008	4.0000	1
96	3207	15	0	4	Q2	2012	4.2200	1.4770	2.0000	1
96	3301	11	0	2	Q1	2012	4.2200	1.3082	2.0000	1
96	3401	11	842	12	Q4	2012	4.2200	1.4770	2.0000	1
96	3480	6	0	10	Q4	2012	4.2200	1.3504	2.0000	1
96	3680	6	0	12	Q4	2012	10.5500	3.6925	5.0000	1
96	3693	3	0	5	Q2	2012	4.2200	1.2660	2.0000	1
96	3897	13	1000	12	Q4	2012	8.4400	2.6164	4.0000	1
96	3979	13	0	4	Q2	2012	4.2200	1.3082	2.0000	1
96	4096	3	0	4	Q2	2012	6.3300	2.7852	3.0000	1
96	4301	11	829	6	Q2	2012	4.2200	2.0678	2.0000	1
96	4364	17	0	10	Q4	2012	6.3300	2.3421	3.0000	1
96	4481	15	0	1	Q1	2012	6.3300	2.5320	3.0000	1
96	4606	3	0	11	Q4	2012	6.3300	2.1522	3.0000	1
96	4633	6	0	9	Q3	2012	6.3300	2.4687	3.0000	1
96	4664	7	0	6	Q2	2012	8.4400	3.6292	4.0000	1
96	4691	17	0	11	Q4	2012	6.3300	2.2155	3.0000	1
96	4814	11	829	6	Q2	2012	6.3300	2.5320	3.0000	1
96	5051	24	0	5	Q2	2012	6.3300	3.1017	3.0000	1
96	5259	7	0	10	Q4	2012	8.4400	3.6292	4.0000	1
96	5293	6	0	4	Q2	2012	8.4400	3.2072	4.0000	1
96	5398	17	0	8	Q3	2012	8.4400	4.0512	4.0000	1
96	5542	16	0	11	Q4	2012	6.3300	2.3421	3.0000	1
96	5633	13	976	1	Q1	2012	6.3300	2.4687	3.0000	1
96	5674	7	0	5	Q2	2012	8.4400	4.1356	4.0000	1
96	5733	11	0	3	Q1	2012	8.4400	3.2916	4.0000	1
96	6014	7	0	8	Q3	2012	8.4400	2.6164	4.0000	1
96	6429	6	0	6	Q2	2012	6.3300	1.8990	3.0000	1
96	6683	17	0	8	Q3	2012	6.3300	2.7219	3.0000	1
96	6716	6	0	8	Q3	2012	6.3300	2.7219	3.0000	1
96	6816	11	0	6	Q2	2012	8.4400	3.8824	4.0000	1
96	6838	15	0	10	Q4	2012	8.4400	3.5448	4.0000	1
96	6861	11	0	6	Q2	2012	6.3300	2.2155	3.0000	1
96	7065	17	0	3	Q1	2012	4.2200	1.5192	2.0000	1
96	7190	23	1768	2	Q1	2012	6.3300	2.4054	3.0000	1
96	7200	11	820	2	Q1	2012	6.3300	2.2155	3.0000	1
96	7384	3	0	7	Q3	2012	8.4400	3.2916	4.0000	1
96	7510	15	0	5	Q2	2012	8.4400	3.2916	4.0000	1
96	7514	17	0	11	Q4	2012	8.4400	4.0512	4.0000	1
96	7702	16	0	4	Q2	2012	4.2200	1.9412	2.0000	1
96	7752	13	0	1	Q1	2012	6.3300	2.0256	3.0000	1
96	7806	13	982	4	Q2	2012	8.4400	3.9668	4.0000	1
96	8000	7	0	9	Q3	2012	6.3300	2.5320	3.0000	1
96	8414	17	0	12	Q4	2012	6.3300	2.2788	3.0000	1
96	8578	23	0	12	Q4	2012	6.3300	3.1650	3.0000	1
96	8746	23	1788	11	Q4	2012	8.4400	2.8696	4.0000	1
96	9064	17	1303	6	Q2	2012	6.3300	2.7852	3.0000	1
96	9629	24	0	12	Q4	2012	6.3300	2.9751	3.0000	1
96	9643	13	0	10	Q4	2012	6.3300	2.5320	3.0000	1
96	9662	7	0	9	Q3	2012	6.3300	2.6586	3.0000	1
96	9757	24	0	10	Q4	2012	8.4400	3.4604	4.0000	1
96	10053	7	0	12	Q4	2012	6.3300	2.2155	3.0000	1
96	10068	23	0	8	Q3	2012	6.3300	3.0384	3.0000	1
96	10087	24	0	7	Q3	2012	4.2200	1.8990	2.0000	1
96	10131	17	1304	7	Q3	2012	8.4400	3.2072	4.0000	1
96	10186	13	0	3	Q1	2012	4.2200	1.2660	2.0000	1
97	179	6	526	12	Q4	2012	1.7700	0.7080	3.0000	1
97	217	13	0	3	Q1	2012	2.3600	0.8260	4.0000	1
97	376	11	821	2	Q1	2012	2.3600	0.9676	4.0000	1
97	463	23	0	1	Q1	2012	1.1800	0.5664	2.0000	1
97	517	7	521	10	Q4	2012	2.3600	0.8260	4.0000	1
97	1142	13	0	11	Q4	2012	2.3600	0.9912	4.0000	1
97	1193	13	0	1	Q1	2012	1.1800	0.4720	2.0000	1
97	1193	13	0	8	Q3	2012	1.1800	0.4720	2.0000	1
97	1599	6	0	6	Q2	2012	2.3600	0.8024	4.0000	1
97	1810	2	0	5	Q2	2012	1.1800	0.4012	2.0000	1
97	1828	24	1847	2	Q1	2012	1.7700	0.8496	3.0000	1
97	1974	22	0	9	Q3	2012	0.5900	0.2124	1.0000	1
97	2052	13	980	3	Q1	2012	1.7700	0.6903	3.0000	1
97	2295	17	0	7	Q3	2012	1.1800	0.4248	2.0000	1
97	2371	16	0	5	Q2	2012	2.3600	1.1800	4.0000	1
97	2511	17	0	7	Q3	2012	1.1800	0.5074	2.0000	1
97	2686	11	0	7	Q3	2012	2.3600	0.8024	4.0000	1
97	3010	7	523	11	Q4	2012	2.3600	1.0148	4.0000	1
97	3068	11	0	3	Q1	2012	1.1800	0.4248	2.0000	1
97	3434	24	1846	2	Q1	2012	2.9500	0.9145	5.0000	1
97	3532	7	526	12	Q4	2012	2.3600	0.7788	4.0000	1
97	3533	3	0	11	Q4	2012	1.7700	0.7788	3.0000	1
97	4115	7	504	2	Q1	2012	2.3600	1.1800	4.0000	1
97	4410	13	0	1	Q1	2012	1.7700	0.8142	3.0000	1
97	4434	15	1142	5	Q2	2012	1.7700	0.8673	3.0000	1
97	4614	11	820	2	Q1	2012	2.3600	1.1328	4.0000	1
97	4739	15	0	12	Q4	2012	2.3600	0.8024	4.0000	1
97	4873	17	0	1	Q1	2012	2.3600	0.9912	4.0000	1
97	4964	2	0	12	Q4	2012	1.1800	0.5546	2.0000	1
97	5253	7	0	1	Q1	2012	1.7700	0.8142	3.0000	1
97	5353	23	1776	6	Q2	2012	1.7700	0.7434	3.0000	1
97	5374	16	0	12	Q4	2012	1.7700	0.8850	3.0000	1
97	5387	7	0	8	Q3	2012	1.7700	0.8319	3.0000	1
97	5742	16	0	11	Q4	2012	1.1800	0.5664	2.0000	1
97	6139	14	0	9	Q3	2012	1.1800	0.5782	2.0000	1
97	6452	11	0	10	Q4	2012	1.7700	0.7611	3.0000	1
97	6468	2	0	3	Q1	2012	0.5900	0.2891	1.0000	1
97	7131	11	841	12	Q4	2012	1.7700	0.7965	3.0000	1
97	7276	23	0	5	Q2	2012	1.7700	0.7257	3.0000	1
97	7535	7	0	1	Q1	2012	2.3600	0.7788	4.0000	1
97	7835	13	0	6	Q2	2012	1.7700	0.8319	3.0000	1
97	8140	13	0	11	Q4	2012	2.3600	1.0384	4.0000	1
97	8351	16	0	6	Q2	2012	2.3600	1.1800	4.0000	1
97	8695	15	1141	4	Q2	2012	2.3600	1.1564	4.0000	1
97	8912	6	0	4	Q2	2012	2.3600	0.9440	4.0000	1
97	9588	6	523	11	Q4	2012	1.7700	0.6195	3.0000	1
97	9667	23	0	1	Q1	2012	1.7700	0.8319	3.0000	1
97	9823	13	0	5	Q2	2012	1.1800	0.4366	2.0000	1
97	9891	23	0	11	Q4	2012	2.3600	0.9676	4.0000	1
97	10007	7	0	11	Q4	2012	1.7700	0.8673	3.0000	1
97	10209	6	0	10	Q4	2012	1.1800	0.4720	2.0000	1
98	208	13	0	3	Q1	2012	7.3200	2.4888	4.0000	1
98	295	14	1077	11	Q4	2012	3.6600	1.1712	2.0000	1
98	314	15	0	4	Q2	2012	5.4900	2.0862	3.0000	1
98	504	13	0	3	Q1	2012	5.4900	2.3058	3.0000	1
98	612	22	1701	7	Q3	2012	5.4900	2.6352	3.0000	1
98	921	23	0	9	Q3	2012	5.4900	2.6901	3.0000	1
98	1124	3	0	9	Q3	2012	5.4900	1.9764	3.0000	1
98	1298	17	0	10	Q4	2012	5.4900	1.6470	3.0000	1
98	1298	17	1303	6	Q2	2012	5.4900	1.9215	3.0000	1
98	1994	15	0	2	Q1	2012	7.3200	3.2208	4.0000	1
98	2002	15	0	12	Q4	2012	3.6600	1.1712	2.0000	1
98	2241	7	0	11	Q4	2012	9.1500	3.0195	5.0000	1
98	2280	13	0	1	Q1	2012	5.4900	1.7019	3.0000	1
98	2751	6	0	10	Q4	2012	3.6600	1.7202	2.0000	1
98	2863	17	1307	8	Q3	2012	3.6600	1.1346	2.0000	1
98	2909	15	0	8	Q3	2012	7.3200	3.0012	4.0000	1
98	3000	17	1293	1	Q1	2012	5.4900	1.8666	3.0000	1
98	3218	3	0	5	Q2	2012	5.4900	1.7019	3.0000	1
98	3418	3	0	5	Q2	2012	5.4900	1.9764	3.0000	1
98	3596	11	837	10	Q4	2012	5.4900	1.7568	3.0000	1
98	3620	15	0	1	Q1	2012	5.4900	2.6901	3.0000	1
98	3682	13	0	7	Q3	2012	7.3200	3.2940	4.0000	1
98	3944	14	0	3	Q1	2012	3.6600	1.4274	2.0000	1
98	4143	11	0	11	Q4	2012	5.4900	2.6352	3.0000	1
98	4175	16	1216	2	Q1	2012	7.3200	2.4156	4.0000	1
98	4275	24	0	2	Q1	2012	3.6600	1.1712	2.0000	1
98	4436	3	0	12	Q4	2012	5.4900	2.0862	3.0000	1
98	4892	17	0	12	Q4	2012	5.4900	2.5254	3.0000	1
98	4928	13	0	11	Q4	2012	5.4900	2.5254	3.0000	1
98	5009	7	0	5	Q2	2012	3.6600	1.5738	2.0000	1
98	5317	15	1154	10	Q4	2012	7.3200	2.7084	4.0000	1
98	5329	13	0	7	Q3	2012	5.4900	2.2509	3.0000	1
98	5353	23	0	2	Q1	2012	3.6600	1.4640	2.0000	1
98	5616	17	0	9	Q3	2012	5.4900	2.5803	3.0000	1
98	6392	7	0	5	Q2	2012	3.6600	1.1346	2.0000	1
98	6530	17	0	10	Q4	2012	7.3200	3.5868	4.0000	1
98	6666	17	0	8	Q3	2012	7.3200	2.7084	4.0000	1
98	6716	7	0	6	Q2	2012	7.3200	3.0744	4.0000	1
98	6957	16	1223	6	Q2	2012	5.4900	1.8666	3.0000	1
98	7079	11	0	8	Q3	2012	9.1500	4.1175	5.0000	1
98	7105	24	1850	3	Q1	2012	3.6600	1.2444	2.0000	1
98	7189	13	976	1	Q1	2012	7.3200	2.9280	4.0000	1
98	7384	3	0	12	Q4	2012	9.1500	3.2940	5.0000	1
98	7534	13	0	7	Q3	2012	3.6600	1.5372	2.0000	1
98	7619	7	0	12	Q4	2012	7.3200	3.5868	4.0000	1
98	7753	6	0	7	Q3	2012	3.6600	1.2078	2.0000	1
98	7905	13	0	10	Q4	2012	7.3200	2.4156	4.0000	1
98	8048	7	0	10	Q4	2012	5.4900	1.9215	3.0000	1
98	8171	24	1853	5	Q2	2012	7.3200	3.0744	4.0000	1
98	8356	15	0	6	Q2	2012	5.4900	1.9764	3.0000	1
98	8452	16	0	6	Q2	2012	7.3200	3.1476	4.0000	1
98	8578	23	0	2	Q1	2012	3.6600	1.7202	2.0000	1
98	9481	24	0	3	Q1	2012	7.3200	3.5136	4.0000	1
98	9488	24	0	5	Q2	2012	5.4900	2.1960	3.0000	1
98	9815	16	0	3	Q1	2012	5.4900	2.4156	3.0000	1
98	9855	7	0	8	Q3	2012	7.3200	3.6600	4.0000	1
98	10273	17	0	3	Q1	2012	5.4900	2.1411	3.0000	1
99	91	6	0	8	Q3	2012	7.0800	2.9028	3.0000	1
99	420	22	0	1	Q1	2012	2.3600	1.0148	1.0000	1
99	781	24	1858	7	Q3	2012	4.7200	2.2184	2.0000	1
99	790	13	0	7	Q3	2012	7.0800	2.8320	3.0000	1
99	819	13	0	7	Q3	2012	7.0800	2.4780	3.0000	1
99	1253	13	0	7	Q3	2012	4.7200	2.1240	2.0000	1
99	1337	17	1312	10	Q4	2012	9.4400	3.9648	4.0000	1
99	1429	13	0	2	Q1	2012	7.0800	3.4692	3.0000	1
99	1476	6	0	10	Q4	2012	9.4400	4.3424	4.0000	1
99	1575	13	980	3	Q1	2012	9.4400	3.2096	4.0000	1
99	1610	3	0	3	Q1	2012	7.0800	2.3364	3.0000	1
99	1813	17	0	3	Q1	2012	9.4400	4.7200	4.0000	1
99	2019	16	0	3	Q1	2012	7.0800	2.9028	3.0000	1
99	2258	11	0	8	Q3	2012	4.7200	2.1240	2.0000	1
99	2952	23	0	11	Q4	2012	9.4400	3.8704	4.0000	1
99	3395	11	0	4	Q2	2012	7.0800	3.1860	3.0000	1
99	3480	7	523	11	Q4	2012	9.4400	4.1536	4.0000	1
99	4030	7	0	9	Q3	2012	9.4400	3.2096	4.0000	1
99	4094	16	1228	8	Q3	2012	7.0800	2.4072	3.0000	1
99	4259	15	0	8	Q3	2012	4.7200	1.4632	2.0000	1
99	4498	17	0	4	Q2	2012	7.0800	2.6196	3.0000	1
99	5568	23	1765	1	Q1	2012	7.0800	2.1240	3.0000	1
99	6295	24	1859	8	Q3	2012	7.0800	2.9736	3.0000	1
99	6309	2	0	5	Q2	2012	7.0800	2.1948	3.0000	1
99	6844	11	829	6	Q2	2012	9.4400	4.1536	4.0000	1
99	6849	6	0	12	Q4	2012	7.0800	3.2568	3.0000	1
99	7051	16	1233	10	Q4	2012	9.4400	3.2096	4.0000	1
99	7188	24	0	1	Q1	2012	9.4400	3.2096	4.0000	1
99	7220	3	0	8	Q3	2012	4.7200	1.7464	2.0000	1
99	7573	3	0	2	Q1	2012	7.0800	2.9736	3.0000	1
99	7715	13	0	12	Q4	2012	9.4400	4.2480	4.0000	1
99	7951	15	0	9	Q3	2012	9.4400	3.6816	4.0000	1
99	8466	17	0	6	Q2	2012	7.0800	3.3984	3.0000	1
99	8782	6	0	4	Q2	2012	4.7200	1.7464	2.0000	1
99	9187	17	0	10	Q4	2012	7.0800	3.1152	3.0000	1
99	9517	2	119	7	Q3	2012	2.3600	1.0148	1.0000	1
100	50	7	0	7	Q3	2012	3.9000	1.5600	2.0000	1
100	190	13	0	3	Q1	2012	7.8000	2.4960	4.0000	1
100	1147	13	0	12	Q4	2012	5.8500	2.5155	3.0000	1
100	1322	7	0	12	Q4	2012	5.8500	1.9305	3.0000	1
100	1468	13	0	8	Q3	2012	5.8500	2.6325	3.0000	1
100	1524	13	0	1	Q1	2012	9.7500	4.7775	5.0000	1
100	2006	11	0	12	Q4	2012	5.8500	1.8135	3.0000	1
100	2150	6	519	9	Q3	2012	5.8500	2.8080	3.0000	1
100	2244	17	0	4	Q2	2012	7.8000	2.4960	4.0000	1
100	2442	24	0	7	Q3	2012	7.8000	3.5100	4.0000	1
100	2787	17	0	9	Q3	2012	5.8500	2.5740	3.0000	1
100	2863	17	0	5	Q2	2012	3.9000	1.2090	2.0000	1
100	2918	17	1304	7	Q3	2012	7.8000	3.1980	4.0000	1
100	2957	6	0	10	Q4	2012	7.8000	2.8080	4.0000	1
100	3124	3	0	9	Q3	2012	7.8000	3.6660	4.0000	1
100	3288	3	0	10	Q4	2012	3.9000	1.5210	2.0000	1
100	3302	13	984	5	Q2	2012	5.8500	2.1645	3.0000	1
100	3418	3	0	6	Q2	2012	5.8500	2.6325	3.0000	1
100	3633	15	1150	8	Q3	2012	5.8500	2.3400	3.0000	1
100	3935	24	1847	2	Q1	2012	3.9000	1.4040	2.0000	1
100	4282	15	1138	3	Q1	2012	7.8000	2.6520	4.0000	1
100	4557	22	1701	7	Q3	2012	1.9500	0.9555	1.0000	1
100	4656	7	0	10	Q4	2012	7.8000	3.5100	4.0000	1
100	4767	16	0	10	Q4	2012	5.8500	2.0475	3.0000	1
100	5518	6	0	9	Q3	2012	7.8000	3.5880	4.0000	1
100	5590	17	0	11	Q4	2012	7.8000	3.7440	4.0000	1
100	5786	13	0	3	Q1	2012	9.7500	3.7050	5.0000	1
100	5827	11	0	7	Q3	2012	5.8500	2.2815	3.0000	1
100	5877	17	0	12	Q4	2012	5.8500	1.8135	3.0000	1
100	6053	6	0	9	Q3	2012	7.8000	2.8860	4.0000	1
100	6105	23	0	6	Q2	2012	7.8000	3.1200	4.0000	1
100	6105	23	1769	3	Q1	2012	5.8500	2.2230	3.0000	1
100	6120	24	0	6	Q2	2012	3.9000	1.4040	2.0000	1
100	6162	17	1304	7	Q3	2012	7.8000	3.1980	4.0000	1
100	6223	6	521	10	Q4	2012	5.8500	2.5155	3.0000	1
100	6526	13	0	7	Q3	2012	5.8500	2.6910	3.0000	1
100	6766	24	1859	8	Q3	2012	3.9000	1.2870	2.0000	1
100	7130	24	0	1	Q1	2012	7.8000	3.5100	4.0000	1
100	7366	3	0	6	Q2	2012	3.9000	1.7550	2.0000	1
100	7715	13	0	6	Q2	2012	9.7500	4.8750	5.0000	1
100	7862	16	0	5	Q2	2012	7.8000	3.5100	4.0000	1
100	7882	13	0	12	Q4	2012	9.7500	3.7050	5.0000	1
100	7920	17	0	9	Q3	2012	5.8500	1.8720	3.0000	1
100	8241	17	1304	7	Q3	2012	5.8500	2.3400	3.0000	1
100	8454	17	0	2	Q1	2012	5.8500	2.2815	3.0000	1
100	8619	13	0	10	Q4	2012	5.8500	1.9305	3.0000	1
100	8921	13	0	10	Q4	2012	7.8000	2.8080	4.0000	1
100	8977	6	523	11	Q4	2012	5.8500	2.3985	3.0000	1
100	9303	15	0	9	Q3	2012	7.8000	3.1200	4.0000	1
100	9318	16	0	9	Q3	2012	7.8000	2.8080	4.0000	1
100	9467	11	0	3	Q1	2012	7.8000	2.4180	4.0000	1
100	9688	7	523	11	Q4	2012	5.8500	1.8135	3.0000	1
100	10222	7	504	2	Q1	2012	3.9000	1.7550	2.0000	1
101	1310	16	0	3	Q1	2012	2.1600	1.0584	3.0000	1
101	1785	3	0	2	Q1	2012	2.1600	0.8856	3.0000	1
101	2193	7	0	3	Q1	2012	2.8800	0.9504	4.0000	1
101	2390	17	0	2	Q1	2012	1.4400	0.5184	2.0000	1
101	2626	11	0	11	Q4	2012	2.8800	1.2096	4.0000	1
101	2879	6	0	2	Q1	2012	2.8800	0.9504	4.0000	1
101	2943	14	1071	8	Q3	2012	0.7200	0.2952	1.0000	1
101	3242	3	0	4	Q2	2012	2.8800	0.8640	4.0000	1
101	3799	13	976	1	Q1	2012	2.1600	0.9504	3.0000	1
101	4196	13	0	8	Q3	2012	2.8800	1.2384	4.0000	1
101	4251	6	510	5	Q2	2012	2.1600	0.7128	3.0000	1
101	4349	15	0	11	Q4	2012	2.1600	0.8640	3.0000	1
101	4359	14	0	10	Q4	2012	1.4400	0.7056	2.0000	1
101	4503	13	0	7	Q3	2012	2.1600	0.7344	3.0000	1
101	4554	24	0	11	Q4	2012	3.6000	1.7640	5.0000	1
101	4658	17	0	5	Q2	2012	2.1600	0.7776	3.0000	1
101	4767	16	1225	7	Q3	2012	2.8800	1.2384	4.0000	1
101	4809	6	0	12	Q4	2012	2.1600	1.0368	3.0000	1
101	4881	13	0	12	Q4	2012	2.8800	0.8928	4.0000	1
101	5526	15	0	3	Q1	2012	2.8800	1.0656	4.0000	1
101	5530	13	980	3	Q1	2012	2.1600	0.9072	3.0000	1
101	5568	23	0	11	Q4	2012	1.4400	0.5616	2.0000	1
101	5626	7	0	12	Q4	2012	2.1600	1.0152	3.0000	1
101	6047	17	1314	11	Q4	2012	2.8800	1.3248	4.0000	1
101	6120	24	0	12	Q4	2012	2.1600	0.7992	3.0000	1
101	6465	6	508	4	Q2	2012	1.4400	0.4464	2.0000	1
101	6506	6	0	10	Q4	2012	2.1600	1.0368	3.0000	1
101	6590	7	518	8	Q3	2012	1.4400	0.4320	2.0000	1
101	7124	6	511	5	Q2	2012	2.1600	1.0152	3.0000	1
101	7567	24	0	10	Q4	2012	2.1600	1.0368	3.0000	1
101	7624	11	0	8	Q3	2012	2.1600	0.7560	3.0000	1
101	8206	23	1776	6	Q2	2012	2.1600	0.8208	3.0000	1
101	8248	7	0	9	Q3	2012	1.4400	0.5472	2.0000	1
101	8314	15	0	5	Q2	2012	2.8800	1.2096	4.0000	1
101	8514	14	0	12	Q4	2012	0.7200	0.2880	1.0000	1
101	8815	7	505	2	Q1	2012	1.4400	0.5472	2.0000	1
101	9029	3	201	8	Q3	2012	2.8800	1.3824	4.0000	1
101	9187	17	0	2	Q1	2012	2.1600	1.0368	3.0000	1
101	9276	7	504	2	Q1	2012	2.8800	1.1232	4.0000	1
101	9276	7	512	6	Q2	2012	2.8800	1.1232	4.0000	1
101	9358	15	0	7	Q3	2012	1.4400	0.6912	2.0000	1
101	9667	23	0	2	Q1	2012	2.1600	0.9936	3.0000	1
101	9903	6	0	1	Q1	2012	1.4400	0.5328	2.0000	1
101	10065	7	0	9	Q3	2012	2.1600	0.8856	3.0000	1
102	128	13	0	10	Q4	2012	7.3500	3.4545	3.0000	1
102	196	14	0	10	Q4	2012	2.4500	1.0535	1.0000	1
102	354	23	0	1	Q1	2012	9.8000	4.6060	4.0000	1
102	430	16	0	12	Q4	2012	7.3500	2.3520	3.0000	1
102	490	11	0	5	Q2	2012	7.3500	3.4545	3.0000	1
102	997	3	201	8	Q3	2012	9.8000	4.8020	4.0000	1
102	1097	23	0	4	Q2	2012	7.3500	2.5725	3.0000	1
102	1140	22	1704	9	Q3	2012	4.9000	2.2540	2.0000	1
102	1192	17	0	4	Q2	2012	7.3500	2.4990	3.0000	1
102	1282	3	205	10	Q4	2012	4.9000	2.3030	2.0000	1
102	1531	6	0	9	Q3	2012	7.3500	2.3520	3.0000	1
102	1610	3	0	11	Q4	2012	7.3500	2.7195	3.0000	1
102	1791	13	0	7	Q3	2012	7.3500	3.6750	3.0000	1
102	1813	17	0	5	Q2	2012	4.9000	1.9110	2.0000	1
102	1977	23	1783	9	Q3	2012	7.3500	2.2785	3.0000	1
102	2078	24	0	9	Q3	2012	4.9000	1.5680	2.0000	1
102	2116	14	0	7	Q3	2012	4.9000	1.5190	2.0000	1
102	2168	24	1866	11	Q4	2012	7.3500	2.4255	3.0000	1
102	2224	16	1235	11	Q4	2012	7.3500	2.5725	3.0000	1
102	2272	17	0	1	Q1	2012	7.3500	2.6460	3.0000	1
102	2441	17	0	6	Q2	2012	9.8000	4.6060	4.0000	1
102	2553	16	1225	7	Q3	2012	7.3500	3.0870	3.0000	1
102	2850	3	0	9	Q3	2012	4.9000	1.5680	2.0000	1
102	2947	17	0	3	Q1	2012	7.3500	3.6015	3.0000	1
102	3351	22	0	9	Q3	2012	2.4500	0.8575	1.0000	1
102	4021	16	0	5	Q2	2012	9.8000	3.1360	4.0000	1
102	4649	17	0	9	Q3	2012	7.3500	2.2785	3.0000	1
102	4892	17	1314	11	Q4	2012	4.9000	2.3520	2.0000	1
102	5026	17	1307	8	Q3	2012	4.9000	1.6660	2.0000	1
102	5060	13	0	7	Q3	2012	9.8000	4.6060	4.0000	1
102	5394	7	519	9	Q3	2012	7.3500	2.9400	3.0000	1
102	5742	16	0	2	Q1	2012	7.3500	2.9400	3.0000	1
102	5760	13	0	12	Q4	2012	9.8000	4.5080	4.0000	1
102	5846	11	842	12	Q4	2012	7.3500	2.8665	3.0000	1
102	5855	13	0	1	Q1	2012	9.8000	3.7240	4.0000	1
102	6592	13	980	3	Q1	2012	7.3500	3.4545	3.0000	1
102	6609	7	516	8	Q3	2012	4.9000	1.6660	2.0000	1
102	6717	6	0	8	Q3	2012	7.3500	3.3075	3.0000	1
102	7352	7	0	1	Q1	2012	7.3500	3.0870	3.0000	1
102	7457	13	0	1	Q1	2012	7.3500	3.2340	3.0000	1
102	7643	24	0	7	Q3	2012	7.3500	3.6015	3.0000	1
102	7762	7	518	8	Q3	2012	4.9000	1.9600	2.0000	1
102	8218	22	0	10	Q4	2012	7.3500	3.2340	3.0000	1
102	8351	16	0	6	Q2	2012	4.9000	2.4010	2.0000	1
102	8435	17	0	5	Q2	2012	9.8000	4.1160	4.0000	1
102	9631	16	0	8	Q3	2012	7.3500	3.6015	3.0000	1
102	9673	13	0	1	Q1	2012	9.8000	3.9200	4.0000	1
102	9716	15	0	10	Q4	2012	7.3500	2.8665	3.0000	1
102	9801	11	0	9	Q3	2012	7.3500	2.2785	3.0000	1
102	9851	3	0	9	Q3	2012	4.9000	1.7150	2.0000	1
102	9881	3	199	7	Q3	2012	7.3500	3.3810	3.0000	1
102	9974	7	512	6	Q2	2012	7.3500	2.7195	3.0000	1
102	10012	24	0	10	Q4	2012	7.3500	2.7930	3.0000	1
103	465	13	0	11	Q4	2012	1.9000	0.9310	2.0000	1
103	551	7	0	4	Q2	2012	1.9000	0.6650	2.0000	1
103	847	15	0	10	Q4	2012	2.8500	1.2255	3.0000	1
103	1347	13	980	3	Q1	2012	1.9000	0.8550	2.0000	1
103	1388	13	0	11	Q4	2012	2.8500	0.9690	3.0000	1
103	1850	16	1235	11	Q4	2012	2.8500	1.3680	3.0000	1
103	1917	23	1778	7	Q3	2012	2.8500	1.1685	3.0000	1
103	2270	11	826	5	Q2	2012	2.8500	0.9405	3.0000	1
103	2769	16	1235	11	Q4	2012	1.9000	0.8930	2.0000	1
103	2850	3	188	2	Q1	2012	1.9000	0.7030	2.0000	1
103	2951	24	0	7	Q3	2012	3.8000	1.8620	4.0000	1
103	3124	3	207	11	Q4	2012	3.8000	1.1780	4.0000	1
103	3285	6	0	3	Q1	2012	2.8500	0.8835	3.0000	1
103	3469	24	0	9	Q3	2012	2.8500	1.2255	3.0000	1
103	3951	6	0	10	Q4	2012	1.9000	0.7030	2.0000	1
103	4204	17	0	12	Q4	2012	2.8500	0.9975	3.0000	1
103	4397	16	0	8	Q3	2012	1.9000	0.6840	2.0000	1
103	4451	7	0	5	Q2	2012	4.7500	1.6150	5.0000	1
103	4707	11	833	8	Q3	2012	4.7500	2.2800	5.0000	1
103	4810	23	0	3	Q1	2012	3.8000	1.7100	4.0000	1
103	4892	17	0	1	Q1	2012	4.7500	1.8050	5.0000	1
103	4928	13	980	3	Q1	2012	2.8500	1.2255	3.0000	1
103	5009	7	0	7	Q3	2012	3.8000	1.4440	4.0000	1
103	5011	24	1851	4	Q2	2012	3.8000	1.4440	4.0000	1
103	5126	24	0	11	Q4	2012	1.9000	0.6270	2.0000	1
103	5147	13	0	8	Q3	2012	2.8500	1.2540	3.0000	1
103	5374	16	1235	11	Q4	2012	2.8500	1.3110	3.0000	1
103	5508	6	0	3	Q1	2012	4.7500	2.2800	5.0000	1
103	5592	16	1233	10	Q4	2012	2.8500	1.2825	3.0000	1
103	5612	15	0	4	Q2	2012	1.9000	0.6840	2.0000	1
103	6229	24	0	8	Q3	2012	2.8500	1.3110	3.0000	1
103	6392	7	0	5	Q2	2012	1.9000	0.6460	2.0000	1
103	6560	17	0	12	Q4	2012	2.8500	1.2825	3.0000	1
103	6686	13	0	4	Q2	2012	2.8500	1.1685	3.0000	1
103	6846	15	0	8	Q3	2012	2.8500	0.9120	3.0000	1
103	6897	6	0	6	Q2	2012	2.8500	1.3110	3.0000	1
103	7242	24	1845	1	Q1	2012	2.8500	1.3965	3.0000	1
103	7655	17	0	2	Q1	2012	1.9000	0.7600	2.0000	1
103	8367	13	0	8	Q3	2012	1.9000	0.6840	2.0000	1
103	9286	13	0	6	Q2	2012	3.8000	1.8240	4.0000	1
103	9623	15	0	6	Q2	2012	2.8500	0.9975	3.0000	1
103	9664	2	0	10	Q4	2012	1.9000	0.7030	2.0000	1
103	9721	15	0	6	Q2	2012	2.8500	1.1115	3.0000	1
103	9780	15	0	9	Q3	2012	1.9000	0.6840	2.0000	1
103	9785	15	0	7	Q3	2012	2.8500	1.1115	3.0000	1
103	9810	24	0	1	Q1	2012	3.8000	1.8240	4.0000	1
103	10031	24	0	6	Q2	2012	1.9000	0.7410	2.0000	1
104	373	13	986	6	Q2	2012	15.5600	4.9792	4.0000	1
104	395	24	0	3	Q1	2012	11.6700	5.4849	3.0000	1
104	461	11	0	12	Q4	2012	15.5600	7.3132	4.0000	1
104	464	15	1154	10	Q4	2012	15.5600	7.3132	4.0000	1
104	973	24	0	8	Q3	2012	7.7800	3.6566	2.0000	1
104	1080	6	0	5	Q2	2012	11.6700	3.8511	3.0000	1
104	1297	16	1235	11	Q4	2012	7.7800	3.8900	2.0000	1
104	1339	13	0	4	Q2	2012	7.7800	3.8122	2.0000	1
104	1527	24	1869	12	Q4	2012	11.6700	3.6177	3.0000	1
104	1582	11	0	4	Q2	2012	11.6700	3.5010	3.0000	1
104	1720	16	0	5	Q2	2012	7.7800	2.8786	2.0000	1
104	1744	17	0	6	Q2	2012	11.6700	5.3682	3.0000	1
104	1798	3	204	9	Q3	2012	7.7800	3.8900	2.0000	1
104	1850	16	1236	12	Q4	2012	11.6700	5.6016	3.0000	1
104	2061	3	0	6	Q2	2012	11.6700	4.6680	3.0000	1
104	2136	7	504	2	Q1	2012	7.7800	3.5010	2.0000	1
104	2194	6	526	12	Q4	2012	7.7800	3.5788	2.0000	1
104	2441	17	1307	8	Q3	2012	15.5600	6.0684	4.0000	1
104	2482	13	0	2	Q1	2012	7.7800	3.6566	2.0000	1
104	2586	6	513	6	Q2	2012	11.6700	5.3682	3.0000	1
104	2588	23	1772	4	Q2	2012	15.5600	7.0020	4.0000	1
104	2617	13	0	7	Q3	2012	15.5600	5.6016	4.0000	1
104	3124	3	0	9	Q3	2012	11.6700	3.6177	3.0000	1
104	3124	3	201	8	Q3	2012	15.5600	7.3132	4.0000	1
104	3140	6	513	6	Q2	2012	15.5600	5.2904	4.0000	1
104	3404	24	1858	7	Q3	2012	11.6700	4.7847	3.0000	1
104	3497	17	0	10	Q4	2012	11.6700	3.7344	3.0000	1
104	4291	15	0	7	Q3	2012	7.7800	2.4896	2.0000	1
104	4301	11	0	11	Q4	2012	7.7800	2.8786	2.0000	1
104	4417	3	0	10	Q4	2012	7.7800	3.0342	2.0000	1
104	4535	15	0	3	Q1	2012	15.5600	5.2904	4.0000	1
104	4614	11	0	10	Q4	2012	11.6700	5.2515	3.0000	1
104	4676	16	0	6	Q2	2012	15.5600	7.6244	4.0000	1
104	4705	15	0	12	Q4	2012	15.5600	7.4688	4.0000	1
104	4958	23	0	2	Q1	2012	15.5600	5.7572	4.0000	1
104	4992	6	508	4	Q2	2012	11.6700	5.6016	3.0000	1
104	5109	15	0	10	Q4	2012	11.6700	4.6680	3.0000	1
104	5358	3	197	6	Q2	2012	11.6700	3.8511	3.0000	1
104	5608	7	0	1	Q1	2012	11.6700	5.7183	3.0000	1
104	5808	7	0	1	Q1	2012	15.5600	5.1348	4.0000	1
104	5868	15	0	5	Q2	2012	7.7800	3.6566	2.0000	1
104	5869	13	0	8	Q3	2012	7.7800	2.4896	2.0000	1
104	5954	6	504	2	Q1	2012	7.7800	2.4896	2.0000	1
104	6376	6	0	5	Q2	2012	15.5600	6.2240	4.0000	1
104	6551	11	0	8	Q3	2012	11.6700	4.2012	3.0000	1
104	6553	24	0	7	Q3	2012	15.5600	7.1576	4.0000	1
104	7406	11	0	4	Q2	2012	7.7800	2.5674	2.0000	1
104	7683	22	0	12	Q4	2012	7.7800	3.2676	2.0000	1
104	8291	13	0	1	Q1	2012	15.5600	7.0020	4.0000	1
104	9224	17	1294	2	Q1	2012	11.6700	4.0845	3.0000	1
104	9251	24	1856	6	Q2	2012	7.7800	3.4232	2.0000	1
104	9324	3	0	8	Q3	2012	11.6700	5.3682	3.0000	1
104	9327	17	1314	11	Q4	2012	7.7800	2.5674	2.0000	1
104	10118	13	0	2	Q1	2012	7.7800	3.2676	2.0000	1
104	10118	13	0	9	Q3	2012	7.7800	3.2676	2.0000	1
104	10169	11	842	12	Q4	2012	7.7800	3.0342	2.0000	1
105	228	24	0	12	Q4	2012	7.4400	2.6040	2.0000	1
105	625	13	988	7	Q3	2012	7.4400	2.3064	2.0000	1
105	1214	11	0	3	Q1	2012	11.1600	5.1336	3.0000	1
105	1281	3	0	10	Q4	2012	14.8800	6.9936	4.0000	1
105	1436	14	0	10	Q4	2012	3.7200	1.8228	1.0000	1
105	1567	16	0	3	Q1	2012	18.6000	6.3240	5.0000	1
105	1646	15	1141	4	Q2	2012	7.4400	2.6784	2.0000	1
105	2195	7	0	4	Q2	2012	11.1600	4.0176	3.0000	1
105	2195	7	0	6	Q2	2012	14.8800	6.9936	4.0000	1
105	2905	3	0	2	Q1	2012	11.1600	3.5712	3.0000	1
105	3012	24	1850	3	Q1	2012	18.6000	5.9520	5.0000	1
105	3166	24	0	5	Q2	2012	11.1600	4.6872	3.0000	1
105	3263	14	1062	4	Q2	2012	3.7200	1.8228	1.0000	1
105	3388	13	0	5	Q2	2012	7.4400	2.8272	2.0000	1
105	3388	13	0	12	Q4	2012	7.4400	2.8272	2.0000	1
105	3460	11	821	2	Q1	2012	7.4400	2.3064	2.0000	1
105	3664	22	0	6	Q2	2012	3.7200	1.5252	1.0000	1
105	4141	14	1079	12	Q4	2012	3.7200	1.2648	1.0000	1
105	4410	13	0	5	Q2	2012	11.1600	3.6828	3.0000	1
105	4445	17	0	6	Q2	2012	11.1600	3.9060	3.0000	1
105	4463	24	0	12	Q4	2012	7.4400	2.5296	2.0000	1
105	4657	17	0	2	Q1	2012	11.1600	3.4596	3.0000	1
105	4680	6	0	4	Q2	2012	11.1600	4.3524	3.0000	1
105	4843	24	0	12	Q4	2012	11.1600	4.7988	3.0000	1
105	4925	16	0	11	Q4	2012	14.8800	5.2080	4.0000	1
105	4963	24	1853	5	Q2	2012	14.8800	6.3984	4.0000	1
105	5214	7	519	9	Q3	2012	7.4400	3.0504	2.0000	1
105	6001	17	0	8	Q3	2012	14.8800	7.1424	4.0000	1
105	6265	23	0	12	Q4	2012	11.1600	5.3568	3.0000	1
105	6584	6	508	4	Q2	2012	14.8800	5.6544	4.0000	1
105	6617	7	526	12	Q4	2012	7.4400	2.9760	2.0000	1
105	7133	22	0	5	Q2	2012	3.7200	1.4508	1.0000	1
105	7355	13	0	1	Q1	2012	14.8800	5.0592	4.0000	1
105	7694	13	0	7	Q3	2012	11.1600	4.2408	3.0000	1
105	7822	3	0	2	Q1	2012	7.4400	3.4224	2.0000	1
105	7822	3	190	3	Q1	2012	11.1600	3.6828	3.0000	1
105	7857	15	1138	3	Q1	2012	7.4400	2.6784	2.0000	1
105	7924	7	523	11	Q4	2012	11.1600	4.1292	3.0000	1
105	7989	17	0	10	Q4	2012	11.1600	5.2452	3.0000	1
105	8777	17	0	11	Q4	2012	7.4400	3.1248	2.0000	1
105	8901	13	0	1	Q1	2012	11.1600	4.7988	3.0000	1
105	8954	7	0	12	Q4	2012	11.1600	3.5712	3.0000	1
105	9123	3	0	5	Q2	2012	11.1600	3.9060	3.0000	1
105	9123	3	0	8	Q3	2012	14.8800	7.1424	4.0000	1
105	9357	7	526	12	Q4	2012	11.1600	4.1292	3.0000	1
105	9494	7	504	2	Q1	2012	14.8800	6.2496	4.0000	1
105	9752	17	0	2	Q1	2012	14.8800	5.3568	4.0000	1
105	9928	16	0	4	Q2	2012	14.8800	5.2080	4.0000	1
106	404	6	510	5	Q2	2012	8.8800	3.6408	3.0000	1
106	430	16	0	12	Q4	2012	8.8800	2.8416	3.0000	1
106	638	11	824	4	Q2	2012	5.9200	1.8944	2.0000	1
106	1144	6	0	12	Q4	2012	5.9200	2.1312	2.0000	1
106	1741	11	829	6	Q2	2012	11.8400	5.2096	4.0000	1
106	1954	13	0	7	Q3	2012	8.8800	3.7296	3.0000	1
106	2053	11	829	6	Q2	2012	5.9200	2.1904	2.0000	1
106	2211	17	0	3	Q1	2012	14.8000	5.0320	5.0000	1
106	2381	6	0	12	Q4	2012	5.9200	2.4272	2.0000	1
106	2572	6	0	12	Q4	2012	5.9200	2.7824	2.0000	1
106	2586	7	0	8	Q3	2012	8.8800	3.9960	3.0000	1
106	2712	6	521	10	Q4	2012	11.8400	4.2624	4.0000	1
106	2863	17	1303	6	Q2	2012	5.9200	2.1312	2.0000	1
106	3127	7	0	12	Q4	2012	5.9200	2.7824	2.0000	1
106	3271	13	0	5	Q2	2012	8.8800	3.8184	3.0000	1
106	3361	24	1866	11	Q4	2012	8.8800	3.6408	3.0000	1
106	3423	13	0	10	Q4	2012	8.8800	3.2856	3.0000	1
106	3611	24	0	7	Q3	2012	8.8800	3.2856	3.0000	1
106	3647	13	986	6	Q2	2012	5.9200	2.5456	2.0000	1
106	3759	13	0	7	Q3	2012	8.8800	3.8184	3.0000	1
106	3838	17	1314	11	Q4	2012	8.8800	3.3744	3.0000	1
106	4175	16	0	7	Q3	2012	8.8800	3.0192	3.0000	1
106	4215	15	1157	12	Q4	2012	8.8800	4.3512	3.0000	1
106	4479	7	0	7	Q3	2012	5.9200	2.1904	2.0000	1
106	4589	13	0	7	Q3	2012	8.8800	4.0848	3.0000	1
106	4626	6	504	2	Q1	2012	8.8800	2.8416	3.0000	1
106	4676	16	0	5	Q2	2012	5.9200	1.9536	2.0000	1
106	5192	7	0	3	Q1	2012	8.8800	4.0848	3.0000	1
106	5305	11	842	12	Q4	2012	8.8800	4.1736	3.0000	1
106	5625	24	0	4	Q2	2012	11.8400	5.6832	4.0000	1
106	5647	15	0	5	Q2	2012	8.8800	2.7528	3.0000	1
106	5668	7	514	7	Q3	2012	8.8800	4.2624	3.0000	1
106	5714	7	505	2	Q1	2012	8.8800	2.7528	3.0000	1
106	5895	17	1311	10	Q4	2012	11.8400	3.5520	4.0000	1
106	6675	22	0	2	Q1	2012	2.9600	1.4208	1.0000	1
106	6854	17	0	12	Q4	2012	8.8800	3.0192	3.0000	1
106	6932	13	0	5	Q2	2012	8.8800	3.6408	3.0000	1
106	6949	15	0	2	Q1	2012	8.8800	4.2624	3.0000	1
106	7052	23	0	5	Q2	2012	5.9200	1.8944	2.0000	1
106	7534	13	0	3	Q1	2012	8.8800	2.9304	3.0000	1
106	7780	13	0	7	Q3	2012	11.8400	4.0256	4.0000	1
106	7801	7	0	1	Q1	2012	8.8800	2.9304	3.0000	1
106	7831	17	0	6	Q2	2012	14.8000	7.1040	5.0000	1
106	8303	15	0	4	Q2	2012	8.8800	4.1736	3.0000	1
106	8668	13	0	5	Q2	2012	11.8400	4.7360	4.0000	1
106	8902	3	0	3	Q1	2012	5.9200	2.0720	2.0000	1
106	8970	22	0	7	Q3	2012	5.9200	1.8352	2.0000	1
106	9047	15	1157	12	Q4	2012	14.8000	5.1800	5.0000	1
106	9487	17	0	12	Q4	2012	8.8800	4.3512	3.0000	1
106	9688	7	0	4	Q2	2012	5.9200	1.8352	2.0000	1
106	9760	13	0	5	Q2	2012	5.9200	2.1904	2.0000	1
106	9760	13	0	7	Q3	2012	8.8800	3.3744	3.0000	1
106	9831	15	0	7	Q3	2012	11.8400	3.6704	4.0000	1
106	9853	14	1064	5	Q2	2012	2.9600	1.0656	1.0000	1
107	76	3	0	3	Q1	2012	5.4300	2.7150	3.0000	1
107	158	17	1297	3	Q1	2012	5.4300	2.6064	3.0000	1
107	346	13	988	7	Q3	2012	5.4300	2.1177	3.0000	1
107	565	15	1157	12	Q4	2012	5.4300	1.7376	3.0000	1
107	624	15	1154	10	Q4	2012	5.4300	2.6064	3.0000	1
107	764	6	0	6	Q2	2012	3.6200	1.3032	2.0000	1
107	991	24	0	4	Q2	2012	3.6200	1.4842	2.0000	1
107	997	3	0	7	Q3	2012	7.2400	3.5476	4.0000	1
107	1203	6	0	5	Q2	2012	5.4300	1.7919	3.0000	1
107	1230	14	1072	9	Q3	2012	1.8100	0.6516	1.0000	1
107	1309	24	1860	8	Q3	2012	5.4300	2.4435	3.0000	1
107	1423	13	0	9	Q3	2012	5.4300	2.6607	3.0000	1
107	1426	13	0	10	Q4	2012	5.4300	1.7376	3.0000	1
107	1648	11	0	4	Q2	2012	5.4300	1.6833	3.0000	1
107	1676	3	0	7	Q3	2012	3.6200	1.3032	2.0000	1
107	1690	16	0	5	Q2	2012	7.2400	3.5476	4.0000	1
107	1914	24	1846	2	Q1	2012	3.6200	1.7376	2.0000	1
107	1920	6	0	3	Q1	2012	3.6200	1.3032	2.0000	1
107	1979	3	0	11	Q4	2012	5.4300	1.9005	3.0000	1
107	2295	17	1292	1	Q1	2012	7.2400	2.3168	4.0000	1
107	2298	3	0	8	Q3	2012	5.4300	2.7150	3.0000	1
107	2378	16	0	7	Q3	2012	5.4300	1.7376	3.0000	1
107	2568	11	0	4	Q2	2012	5.4300	1.9005	3.0000	1
107	3020	13	0	1	Q1	2012	5.4300	2.1720	3.0000	1
107	3196	13	0	7	Q3	2012	5.4300	2.2263	3.0000	1
107	3413	15	0	10	Q4	2012	5.4300	1.7376	3.0000	1
107	3446	22	0	9	Q3	2012	3.6200	1.5204	2.0000	1
107	3628	2	108	1	Q1	2012	3.6200	1.1222	2.0000	1
107	3639	24	0	5	Q2	2012	5.4300	2.4978	3.0000	1
107	3679	24	0	7	Q3	2012	3.6200	1.3032	2.0000	1
107	3708	14	0	6	Q2	2012	3.6200	1.5566	2.0000	1
107	3718	11	0	1	Q1	2012	7.2400	3.0408	4.0000	1
107	3718	11	0	11	Q4	2012	7.2400	3.0408	4.0000	1
107	3889	3	0	3	Q1	2012	5.4300	2.4978	3.0000	1
107	4165	3	0	2	Q1	2012	3.6200	1.4480	2.0000	1
107	4261	13	0	1	Q1	2012	9.0500	3.8915	5.0000	1
107	4283	15	0	10	Q4	2012	3.6200	1.7014	2.0000	1
107	4609	23	1773	4	Q2	2012	5.4300	2.4978	3.0000	1
107	5047	11	820	2	Q1	2012	5.4300	2.6607	3.0000	1
107	5400	15	0	12	Q4	2012	5.4300	2.4435	3.0000	1
107	5438	24	0	8	Q3	2012	3.6200	1.1584	2.0000	1
107	5508	6	0	12	Q4	2012	5.4300	2.4435	3.0000	1
107	5647	15	0	2	Q1	2012	5.4300	1.6833	3.0000	1
107	6001	17	0	2	Q1	2012	3.6200	1.6290	2.0000	1
107	6681	17	0	12	Q4	2012	3.6200	1.6652	2.0000	1
107	6712	16	1220	4	Q2	2012	7.2400	2.8960	4.0000	1
107	6888	23	1765	1	Q1	2012	7.2400	3.1856	4.0000	1
107	7077	24	1847	2	Q1	2012	3.6200	1.2670	2.0000	1
107	7479	15	0	8	Q3	2012	3.6200	1.4842	2.0000	1
107	7595	24	1869	12	Q4	2012	9.0500	3.2580	5.0000	1
107	7618	11	0	9	Q3	2012	7.2400	2.6788	4.0000	1
107	7653	7	516	8	Q3	2012	5.4300	1.9548	3.0000	1
107	7985	24	1859	8	Q3	2012	5.4300	1.6833	3.0000	1
107	8018	11	842	12	Q4	2012	5.4300	1.9005	3.0000	1
107	8116	13	0	2	Q1	2012	3.6200	1.7014	2.0000	1
107	8247	7	0	11	Q4	2012	7.2400	2.2444	4.0000	1
107	8629	24	1851	4	Q2	2012	7.2400	3.0408	4.0000	1
107	9248	15	0	2	Q1	2012	5.4300	2.2806	3.0000	1
107	9286	13	0	6	Q2	2012	5.4300	1.6833	3.0000	1
107	9422	6	504	2	Q1	2012	5.4300	2.0634	3.0000	1
107	9568	6	0	8	Q3	2012	5.4300	1.6833	3.0000	1
107	9727	7	0	3	Q1	2012	7.2400	3.2580	4.0000	1
107	9727	7	0	12	Q4	2012	5.4300	1.7919	3.0000	1
107	9851	3	0	2	Q1	2012	7.2400	3.6200	4.0000	1
107	9897	16	0	1	Q1	2012	5.4300	2.4435	3.0000	1
108	158	17	1314	11	Q4	2012	4.3800	1.8396	2.0000	1
108	160	15	1141	4	Q2	2012	6.5700	2.1681	3.0000	1
108	161	24	1856	6	Q2	2012	4.3800	1.7082	2.0000	1
108	837	11	0	7	Q3	2012	8.7600	4.3800	4.0000	1
108	983	11	0	11	Q4	2012	6.5700	2.1681	3.0000	1
108	1203	7	0	6	Q2	2012	6.5700	2.2338	3.0000	1
108	1532	6	0	2	Q1	2012	8.7600	2.9784	4.0000	1
108	1609	14	0	12	Q4	2012	2.1900	0.8322	1.0000	1
108	1610	3	0	7	Q3	2012	4.3800	2.1024	2.0000	1
108	1669	11	837	10	Q4	2012	8.7600	3.5040	4.0000	1
108	2226	15	1138	3	Q1	2012	8.7600	3.3288	4.0000	1
108	2424	6	508	4	Q2	2012	4.3800	1.7520	2.0000	1
108	2441	17	0	9	Q3	2012	8.7600	3.3288	4.0000	1
108	2617	13	0	7	Q3	2012	4.3800	1.4454	2.0000	1
108	2638	13	0	10	Q4	2012	4.3800	2.1900	2.0000	1
108	2658	7	0	5	Q2	2012	4.3800	1.4892	2.0000	1
108	3068	11	841	12	Q4	2012	6.5700	2.0367	3.0000	1
108	3688	24	0	9	Q3	2012	6.5700	2.1024	3.0000	1
108	4136	14	0	10	Q4	2012	4.3800	1.6644	2.0000	1
108	4295	11	0	6	Q2	2012	6.5700	2.8908	3.0000	1
108	4342	13	980	3	Q1	2012	8.7600	2.8908	4.0000	1
108	4417	3	0	11	Q4	2012	8.7600	4.2048	4.0000	1
108	4422	6	0	12	Q4	2012	4.3800	1.3578	2.0000	1
108	4422	7	0	12	Q4	2012	4.3800	2.1900	2.0000	1
108	4555	11	0	3	Q1	2012	4.3800	1.5330	2.0000	1
108	4690	13	0	11	Q4	2012	4.3800	1.7082	2.0000	1
108	4739	15	0	8	Q3	2012	4.3800	1.5768	2.0000	1
108	4951	15	0	7	Q3	2012	8.7600	3.2412	4.0000	1
108	5056	15	0	2	Q1	2012	10.9500	5.4750	5.0000	1
108	5238	17	0	4	Q2	2012	6.5700	2.2338	3.0000	1
108	5329	13	0	3	Q1	2012	6.5700	2.3652	3.0000	1
108	5329	13	0	7	Q3	2012	6.5700	2.2995	3.0000	1
108	5824	7	0	4	Q2	2012	6.5700	2.0367	3.0000	1
108	5960	7	526	12	Q4	2012	6.5700	2.5623	3.0000	1
108	6314	24	0	11	Q4	2012	8.7600	2.6280	4.0000	1
108	6529	17	0	1	Q1	2012	4.3800	1.8834	2.0000	1
108	6894	24	1858	7	Q3	2012	8.7600	4.0296	4.0000	1
108	6904	13	0	6	Q2	2012	8.7600	3.5916	4.0000	1
108	7203	13	0	9	Q3	2012	6.5700	2.3652	3.0000	1
108	7594	11	0	9	Q3	2012	4.3800	1.4454	2.0000	1
108	7813	17	0	9	Q3	2012	4.3800	1.7520	2.0000	1
108	7871	6	0	10	Q4	2012	6.5700	3.1536	3.0000	1
108	7919	2	121	8	Q3	2012	4.3800	2.1462	2.0000	1
108	8435	17	0	1	Q1	2012	4.3800	1.5768	2.0000	1
108	8489	2	0	7	Q3	2012	2.1900	0.8760	1.0000	1
108	8526	11	0	5	Q2	2012	8.7600	3.2412	4.0000	1
108	8549	6	508	4	Q2	2012	4.3800	1.5768	2.0000	1
108	8731	3	0	5	Q2	2012	4.3800	1.8834	2.0000	1
108	8746	23	0	1	Q1	2012	6.5700	2.0367	3.0000	1
108	8749	13	0	6	Q2	2012	4.3800	2.1024	2.0000	1
108	9065	13	0	11	Q4	2012	4.3800	1.6206	2.0000	1
108	9134	23	0	8	Q3	2012	4.3800	2.1024	2.0000	1
108	9504	13	0	2	Q1	2012	8.7600	4.1172	4.0000	1
108	9999	15	0	6	Q2	2012	6.5700	2.2995	3.0000	1
108	10145	13	0	8	Q3	2012	4.3800	1.5768	2.0000	1
108	10186	13	0	12	Q4	2012	8.7600	3.7668	4.0000	1
108	10243	17	0	9	Q3	2012	8.7600	2.8908	4.0000	1
109	158	17	0	1	Q1	2012	7.9000	3.3180	2.0000	1
109	158	17	0	5	Q2	2012	15.8000	7.9000	4.0000	1
109	439	13	0	1	Q1	2012	15.8000	7.5840	4.0000	1
109	481	24	0	11	Q4	2012	11.8500	5.3325	3.0000	1
109	485	15	1143	5	Q2	2012	15.8000	7.7420	4.0000	1
109	543	13	0	7	Q3	2012	7.9000	3.7920	2.0000	1
109	573	11	0	11	Q4	2012	7.9000	2.8440	2.0000	1
109	1034	24	0	4	Q2	2012	15.8000	6.9520	4.0000	1
109	1058	7	0	7	Q3	2012	7.9000	3.1600	2.0000	1
109	1388	13	0	3	Q1	2012	7.9000	3.5550	2.0000	1
109	1415	16	1216	2	Q1	2012	11.8500	3.7920	3.0000	1
109	2556	3	188	2	Q1	2012	19.7500	6.7150	5.0000	1
109	2724	24	0	11	Q4	2012	7.9000	3.1600	2.0000	1
109	3124	3	201	8	Q3	2012	11.8500	3.6735	3.0000	1
109	3282	6	522	10	Q4	2012	15.8000	6.9520	4.0000	1
109	3352	6	0	5	Q2	2012	7.9000	3.6340	2.0000	1
109	3499	13	976	1	Q1	2012	7.9000	2.7650	2.0000	1
109	3567	16	0	4	Q2	2012	11.8500	3.9105	3.0000	1
109	3725	23	0	9	Q3	2012	11.8500	5.5695	3.0000	1
109	4063	15	0	6	Q2	2012	15.8000	6.4780	4.0000	1
109	4232	6	515	7	Q3	2012	11.8500	3.6735	3.0000	1
109	4351	23	0	7	Q3	2012	15.8000	5.3720	4.0000	1
109	4397	16	0	2	Q1	2012	11.8500	4.9770	3.0000	1
109	4713	6	0	3	Q1	2012	15.8000	4.8980	4.0000	1
109	4767	16	1235	11	Q4	2012	11.8500	4.1475	3.0000	1
109	4836	11	0	11	Q4	2012	7.9000	3.1600	2.0000	1
109	4846	17	0	4	Q2	2012	15.8000	5.8460	4.0000	1
109	4917	14	0	9	Q3	2012	3.9500	1.9355	1.0000	1
109	5050	17	0	5	Q2	2012	15.8000	6.7940	4.0000	1
109	5357	11	826	5	Q2	2012	7.9000	2.9230	2.0000	1
109	5766	16	1235	11	Q4	2012	15.8000	5.3720	4.0000	1
109	5844	17	1312	10	Q4	2012	11.8500	5.5695	3.0000	1
109	5958	13	0	10	Q4	2012	11.8500	4.6215	3.0000	1
109	6001	17	0	8	Q3	2012	11.8500	3.7920	3.0000	1
109	6162	17	0	12	Q4	2012	11.8500	5.6880	3.0000	1
109	6367	3	0	3	Q1	2012	11.8500	4.0290	3.0000	1
109	6609	7	504	2	Q1	2012	11.8500	5.8065	3.0000	1
109	7117	15	0	6	Q2	2012	11.8500	3.6735	3.0000	1
109	7401	24	0	9	Q3	2012	15.8000	5.2140	4.0000	1
109	7502	16	0	8	Q3	2012	7.9000	2.9230	2.0000	1
109	7553	24	0	11	Q4	2012	11.8500	3.7920	3.0000	1
109	7582	11	0	3	Q1	2012	19.7500	8.6900	5.0000	1
109	8068	3	0	12	Q4	2012	15.8000	6.9520	4.0000	1
109	8196	24	0	7	Q3	2012	15.8000	5.2140	4.0000	1
109	8336	17	1303	6	Q2	2012	11.8500	5.9250	3.0000	1
109	8359	17	0	12	Q4	2012	19.7500	7.7025	5.0000	1
109	8700	7	504	2	Q1	2012	15.8000	5.8460	4.0000	1
109	8843	13	0	7	Q3	2012	11.8500	3.6735	3.0000	1
109	8863	6	0	12	Q4	2012	11.8500	5.6880	3.0000	1
109	8901	13	0	6	Q2	2012	11.8500	5.0955	3.0000	1
109	9102	3	0	12	Q4	2012	7.9000	2.3700	2.0000	1
109	9236	13	976	1	Q1	2012	7.9000	2.4490	2.0000	1
109	9307	11	0	6	Q2	2012	19.7500	9.8750	5.0000	1
109	9318	16	0	7	Q3	2012	7.9000	3.6340	2.0000	1
109	9555	17	0	5	Q2	2012	7.9000	2.3700	2.0000	1
109	9866	3	0	3	Q1	2012	7.9000	3.6340	2.0000	1
109	10058	15	0	2	Q1	2012	11.8500	4.1475	3.0000	1
109	10249	7	0	10	Q4	2012	15.8000	5.6880	4.0000	1
110	91	6	0	8	Q3	2012	7.0500	2.4675	3.0000	1
110	208	13	980	3	Q1	2012	4.7000	1.4100	2.0000	1
110	229	15	1143	5	Q2	2012	4.7000	1.4100	2.0000	1
110	647	3	0	12	Q4	2012	7.0500	3.1020	3.0000	1
110	806	17	1307	8	Q3	2012	4.7000	1.9740	2.0000	1
110	937	6	0	10	Q4	2012	7.0500	2.8905	3.0000	1
110	1015	6	0	10	Q4	2012	4.7000	2.1620	2.0000	1
110	1205	15	0	9	Q3	2012	7.0500	3.0315	3.0000	1
110	1720	16	0	12	Q4	2012	11.7500	5.5225	5.0000	1
110	1897	13	0	12	Q4	2012	7.0500	3.3840	3.0000	1
110	2019	16	1216	2	Q1	2012	7.0500	3.3840	3.0000	1
110	2587	16	0	8	Q3	2012	7.0500	3.1020	3.0000	1
110	2829	23	1765	1	Q1	2012	4.7000	2.3500	2.0000	1
110	3187	24	1869	12	Q4	2012	4.7000	1.7390	2.0000	1
110	3207	15	1140	4	Q2	2012	7.0500	3.1725	3.0000	1
110	3271	13	0	5	Q2	2012	9.4000	3.0080	4.0000	1
110	3490	13	980	3	Q1	2012	4.7000	1.5040	2.0000	1
110	3548	13	0	9	Q3	2012	4.7000	1.7860	2.0000	1
110	3642	24	0	4	Q2	2012	7.0500	2.8905	3.0000	1
110	3794	24	0	3	Q1	2012	4.7000	1.6920	2.0000	1
110	4322	15	0	7	Q3	2012	7.0500	3.0315	3.0000	1
110	4443	11	0	2	Q1	2012	7.0500	3.4545	3.0000	1
110	4632	15	0	10	Q4	2012	7.0500	2.6085	3.0000	1
110	4892	17	0	6	Q2	2012	4.7000	1.5980	2.0000	1
110	5216	3	0	6	Q2	2012	7.0500	2.9610	3.0000	1
110	5264	15	0	2	Q1	2012	7.0500	3.5250	3.0000	1
110	5295	16	0	5	Q2	2012	9.4000	4.6060	4.0000	1
110	5358	3	197	6	Q2	2012	7.0500	2.6085	3.0000	1
110	6313	17	0	12	Q4	2012	7.0500	2.5380	3.0000	1
110	6347	17	0	4	Q2	2012	9.4000	3.7600	4.0000	1
110	6559	3	0	6	Q2	2012	7.0500	3.4545	3.0000	1
110	6675	22	0	3	Q1	2012	2.3500	1.1045	1.0000	1
110	6718	6	0	10	Q4	2012	7.0500	3.1725	3.0000	1
110	7072	16	0	5	Q2	2012	4.7000	1.6920	2.0000	1
110	7250	13	0	7	Q3	2012	4.7000	1.8330	2.0000	1
110	7281	17	0	10	Q4	2012	4.7000	1.5980	2.0000	1
110	7653	7	516	8	Q3	2012	9.4000	3.1020	4.0000	1
110	7847	24	1859	8	Q3	2012	9.4000	3.4780	4.0000	1
110	7967	15	0	3	Q1	2012	4.7000	1.6920	2.0000	1
110	8059	17	0	12	Q4	2012	4.7000	2.2090	2.0000	1
110	8164	13	0	1	Q1	2012	9.4000	3.1020	4.0000	1
110	8263	11	0	8	Q3	2012	4.7000	1.5980	2.0000	1
110	8551	17	0	9	Q3	2012	9.4000	3.6660	4.0000	1
110	8578	23	0	2	Q1	2012	4.7000	1.5510	2.0000	1
110	8858	6	0	9	Q3	2012	11.7500	4.3475	5.0000	1
110	9123	3	0	10	Q4	2012	9.4000	4.6060	4.0000	1
110	9997	17	0	6	Q2	2012	7.0500	2.9610	3.0000	1
111	208	13	0	7	Q3	2012	6.9600	2.0880	2.0000	1
111	392	13	0	7	Q3	2012	10.4400	4.0716	3.0000	1
111	806	17	0	2	Q1	2012	6.9600	2.9232	2.0000	1
111	1005	3	204	9	Q3	2012	10.4400	4.6980	3.0000	1
111	1005	3	205	10	Q4	2012	10.4400	4.1760	3.0000	1
111	1136	24	1846	2	Q1	2012	13.9200	6.5424	4.0000	1
111	1442	3	0	4	Q2	2012	13.9200	6.4032	4.0000	1
111	1451	3	0	3	Q1	2012	6.9600	2.4360	2.0000	1
111	1573	24	0	12	Q4	2012	10.4400	5.1156	3.0000	1
111	1785	3	0	2	Q1	2012	10.4400	3.6540	3.0000	1
111	1979	3	0	7	Q3	2012	6.9600	2.2272	2.0000	1
111	2293	7	0	12	Q4	2012	10.4400	5.1156	3.0000	1
111	2869	6	0	10	Q4	2012	10.4400	3.3408	3.0000	1
111	2878	3	0	4	Q2	2012	13.9200	6.5424	4.0000	1
111	2942	17	0	11	Q4	2012	13.9200	4.4544	4.0000	1
111	3057	7	0	3	Q1	2012	10.4400	4.6980	3.0000	1
111	3302	13	976	1	Q1	2012	10.4400	4.3848	3.0000	1
111	3373	15	1150	8	Q3	2012	10.4400	4.6980	3.0000	1
111	3593	3	204	9	Q3	2012	10.4400	3.1320	3.0000	1
111	3749	15	0	11	Q4	2012	10.4400	4.6980	3.0000	1
111	3883	2	129	11	Q4	2012	6.9600	2.5752	2.0000	1
111	4021	16	0	5	Q2	2012	13.9200	6.4032	4.0000	1
111	4222	6	0	6	Q2	2012	10.4400	4.3848	3.0000	1
111	4258	7	0	4	Q2	2012	13.9200	5.1504	4.0000	1
111	4397	16	0	7	Q3	2012	6.9600	2.9928	2.0000	1
111	4460	3	188	2	Q1	2012	10.4400	4.1760	3.0000	1
111	4537	7	0	3	Q1	2012	10.4400	3.3408	3.0000	1
111	4622	22	0	7	Q3	2012	3.4800	1.0440	1.0000	1
111	4836	11	0	11	Q4	2012	13.9200	6.2640	4.0000	1
111	4868	16	0	6	Q2	2012	6.9600	3.4104	2.0000	1
111	4875	13	0	3	Q1	2012	6.9600	3.1320	2.0000	1
111	5500	11	0	5	Q2	2012	10.4400	3.9672	3.0000	1
111	5590	17	1307	8	Q3	2012	13.9200	4.7328	4.0000	1
111	6001	17	0	12	Q4	2012	6.9600	3.1320	2.0000	1
111	6261	6	0	12	Q4	2012	13.9200	4.4544	4.0000	1
111	6421	7	0	5	Q2	2012	10.4400	4.2804	3.0000	1
111	6703	11	0	5	Q2	2012	17.4000	7.3080	5.0000	1
111	6713	13	0	1	Q1	2012	13.9200	5.8464	4.0000	1
111	7446	13	0	1	Q1	2012	6.9600	2.1576	2.0000	1
111	7505	15	0	1	Q1	2012	10.4400	3.9672	3.0000	1
111	7622	3	0	5	Q2	2012	10.4400	3.3408	3.0000	1
111	8304	13	0	3	Q1	2012	13.9200	4.4544	4.0000	1
111	8403	11	0	3	Q1	2012	17.4000	8.1780	5.0000	1
111	8504	13	0	2	Q1	2012	13.9200	5.2896	4.0000	2
111	8657	15	0	11	Q4	2012	6.9600	3.2016	2.0000	1
111	8805	7	0	4	Q2	2012	13.9200	6.5424	4.0000	1
111	8889	11	0	1	Q1	2012	13.9200	4.7328	4.0000	1
111	8947	3	0	6	Q2	2012	13.9200	6.1248	4.0000	1
111	8966	3	0	11	Q4	2012	10.4400	3.7584	3.0000	1
111	9123	3	0	4	Q2	2012	6.9600	3.4800	2.0000	1
111	9307	11	0	7	Q3	2012	17.4000	7.1340	5.0000	1
111	9567	15	0	6	Q2	2012	10.4400	3.4452	3.0000	1
111	9863	13	0	11	Q4	2012	6.9600	2.5752	2.0000	1
111	10167	17	0	3	Q1	2012	10.4400	3.2364	3.0000	1
112	115	7	512	6	Q2	2012	3.3900	1.0509	3.0000	1
112	625	13	0	3	Q1	2012	2.2600	0.9492	2.0000	1
112	650	11	0	8	Q3	2012	3.3900	1.4916	3.0000	1
112	723	6	0	3	Q1	2012	4.5200	2.1244	4.0000	1
112	726	15	0	5	Q2	2012	2.2600	0.8814	2.0000	1
112	976	16	0	12	Q4	2012	3.3900	1.0170	3.0000	1
112	1089	15	0	3	Q1	2012	3.3900	1.2204	3.0000	1
112	1271	13	0	4	Q2	2012	3.3900	1.0848	3.0000	1
112	1297	16	0	4	Q2	2012	3.3900	1.6272	3.0000	1
112	1313	15	0	1	Q1	2012	3.3900	1.6272	3.0000	1
112	1584	7	516	8	Q3	2012	3.3900	1.3899	3.0000	1
112	1596	24	0	10	Q4	2012	2.2600	1.0396	2.0000	1
112	1653	6	511	5	Q2	2012	3.3900	1.5255	3.0000	1
112	1761	24	0	11	Q4	2012	3.3900	1.6272	3.0000	1
112	2158	11	0	7	Q3	2012	4.5200	1.6272	4.0000	1
112	2263	11	0	5	Q2	2012	3.3900	1.6272	3.0000	1
112	2371	16	0	1	Q1	2012	3.3900	1.0848	3.0000	1
112	2444	13	0	7	Q3	2012	3.3900	1.4577	3.0000	1
112	2588	23	0	12	Q4	2012	4.5200	2.0340	4.0000	1
112	2739	6	523	11	Q4	2012	3.3900	1.2543	3.0000	1
112	2798	11	0	5	Q2	2012	3.3900	1.5255	3.0000	1
112	2917	15	0	11	Q4	2012	4.5200	1.5820	4.0000	1
112	3000	17	1304	7	Q3	2012	2.2600	0.9492	2.0000	1
112	3242	3	205	10	Q4	2012	2.2600	1.0170	2.0000	1
112	3308	13	986	6	Q2	2012	2.2600	0.7910	2.0000	1
112	3469	24	0	6	Q2	2012	2.2600	0.9492	2.0000	1
112	3691	17	0	6	Q2	2012	4.5200	1.9436	4.0000	1
112	3819	23	0	7	Q3	2012	3.3900	1.0848	3.0000	1
112	3828	24	0	4	Q2	2012	4.5200	1.6272	4.0000	1
112	4081	24	1845	1	Q1	2012	4.5200	2.0792	4.0000	1
112	4105	3	0	4	Q2	2012	3.3900	1.6272	3.0000	1
112	4163	14	0	4	Q2	2012	2.2600	0.6780	2.0000	1
112	4243	11	0	2	Q1	2012	4.5200	2.0792	4.0000	1
112	4391	16	1235	11	Q4	2012	3.3900	1.5933	3.0000	1
112	4552	17	0	7	Q3	2012	4.5200	1.4916	4.0000	1
112	4633	7	0	5	Q2	2012	3.3900	1.6611	3.0000	1
112	4750	11	829	6	Q2	2012	2.2600	1.0170	2.0000	1
112	5174	16	0	12	Q4	2012	4.5200	1.4012	4.0000	1
112	5192	7	0	3	Q1	2012	2.2600	1.1300	2.0000	1
112	5530	13	980	3	Q1	2012	3.3900	1.2543	3.0000	1
112	5867	11	829	6	Q2	2012	2.2600	0.8136	2.0000	1
112	6003	13	984	5	Q2	2012	3.3900	1.3221	3.0000	1
112	6332	6	519	9	Q3	2012	3.3900	1.6272	3.0000	1
112	6861	11	0	6	Q2	2012	5.6500	1.6950	5.0000	1
112	7171	23	0	12	Q4	2012	3.3900	1.0848	3.0000	1
112	7262	13	0	2	Q1	2012	4.5200	1.8080	4.0000	1
112	7391	7	505	2	Q1	2012	3.3900	1.2543	3.0000	1
112	7457	13	0	3	Q1	2012	4.5200	1.5368	4.0000	1
112	7542	24	0	9	Q3	2012	3.3900	1.2882	3.0000	1
112	7674	6	0	12	Q4	2012	2.2600	0.6780	2.0000	1
112	7789	15	0	7	Q3	2012	3.3900	1.2204	3.0000	1
112	7831	17	0	9	Q3	2012	2.2600	0.9040	2.0000	1
112	8059	17	0	9	Q3	2012	2.2600	1.0170	2.0000	1
112	8306	24	0	4	Q2	2012	2.2600	0.9944	2.0000	1
112	8396	24	1866	11	Q4	2012	4.5200	1.4464	4.0000	1
112	8526	11	0	5	Q2	2012	2.2600	0.7910	2.0000	1
112	8556	11	820	2	Q1	2012	3.3900	1.2543	3.0000	1
112	9019	7	523	11	Q4	2012	4.5200	2.2148	4.0000	1
112	9125	13	988	7	Q3	2012	2.2600	0.8362	2.0000	1
112	9184	3	0	3	Q1	2012	4.5200	2.2148	4.0000	1
112	9194	17	1307	8	Q3	2012	4.5200	1.7176	4.0000	1
112	9357	7	504	2	Q1	2012	2.2600	1.0848	2.0000	1
112	9461	17	0	1	Q1	2012	2.2600	0.9944	2.0000	1
112	9591	7	0	10	Q4	2012	2.2600	1.0848	2.0000	1
112	10050	6	0	12	Q4	2012	2.2600	0.7006	2.0000	1
113	953	15	0	2	Q1	2012	4.5800	1.4198	2.0000	1
113	1253	13	0	3	Q1	2012	9.1600	4.0304	4.0000	1
113	1375	15	0	11	Q4	2012	6.8700	2.0610	3.0000	1
113	1567	16	1228	8	Q3	2012	11.4500	4.1220	5.0000	1
113	1762	24	0	7	Q3	2012	6.8700	2.5419	3.0000	1
113	1785	3	0	2	Q1	2012	6.8700	2.4732	3.0000	1
113	2150	6	0	10	Q4	2012	9.1600	4.3968	4.0000	1
113	2224	16	0	8	Q3	2012	4.5800	1.5572	2.0000	1
113	2244	17	0	12	Q4	2012	6.8700	2.6106	3.0000	1
113	2302	15	0	11	Q4	2012	6.8700	2.9541	3.0000	1
113	3149	11	0	2	Q1	2012	6.8700	2.1297	3.0000	1
113	3163	7	0	3	Q1	2012	6.8700	3.1602	3.0000	1
113	3245	17	0	1	Q1	2012	6.8700	2.9541	3.0000	1
113	3448	3	0	3	Q1	2012	6.8700	3.0915	3.0000	1
113	3539	17	0	10	Q4	2012	6.8700	3.0228	3.0000	1
113	3692	16	0	8	Q3	2012	6.8700	3.4350	3.0000	1
113	3889	3	188	2	Q1	2012	4.5800	1.5572	2.0000	1
113	4175	16	0	9	Q3	2012	4.5800	2.0610	2.0000	1
113	4186	7	523	11	Q4	2012	4.5800	2.1526	2.0000	1
113	4234	3	0	4	Q2	2012	6.8700	2.6793	3.0000	1
113	4522	17	0	11	Q4	2012	6.8700	2.8167	3.0000	1
113	4618	3	207	11	Q4	2012	11.4500	5.4960	5.0000	1
113	5219	17	0	4	Q2	2012	9.1600	3.9388	4.0000	1
113	5298	6	504	2	Q1	2012	4.5800	1.6946	2.0000	1
113	5590	17	0	5	Q2	2012	6.8700	2.4732	3.0000	1
113	6021	13	0	11	Q4	2012	4.5800	2.1526	2.0000	1
113	6499	17	0	7	Q3	2012	9.1600	3.1144	4.0000	1
113	6717	6	0	8	Q3	2012	6.8700	3.0915	3.0000	1
113	6861	11	842	12	Q4	2012	6.8700	2.6106	3.0000	1
113	7361	11	841	12	Q4	2012	9.1600	3.6640	4.0000	1
113	7373	13	0	1	Q1	2012	6.8700	2.1984	3.0000	1
113	7618	11	0	2	Q1	2012	6.8700	2.4045	3.0000	1
113	7743	3	185	1	Q1	2012	4.5800	1.9236	2.0000	1
113	7792	15	1150	8	Q3	2012	6.8700	2.4732	3.0000	1
113	7880	6	522	10	Q4	2012	6.8700	3.0915	3.0000	1
113	7883	15	0	8	Q3	2012	4.5800	1.6488	2.0000	1
113	7910	15	0	2	Q1	2012	6.8700	3.0228	3.0000	1
113	8000	7	0	9	Q3	2012	6.8700	2.8854	3.0000	1
113	8059	17	0	4	Q2	2012	6.8700	2.5419	3.0000	1
113	8935	15	1157	12	Q4	2012	6.8700	2.4045	3.0000	1
113	9203	24	0	8	Q3	2012	9.1600	3.9388	4.0000	1
113	9306	24	0	5	Q2	2012	9.1600	4.3968	4.0000	1
113	9353	15	0	10	Q4	2012	9.1600	3.0228	4.0000	1
113	9512	23	1778	7	Q3	2012	6.8700	2.8854	3.0000	1
113	9727	7	0	12	Q4	2012	6.8700	2.6106	3.0000	1
113	9747	13	982	4	Q2	2012	6.8700	3.2976	3.0000	1
113	9863	13	980	3	Q1	2012	6.8700	2.7480	3.0000	1
113	9866	3	199	7	Q3	2012	4.5800	1.8778	2.0000	1
113	10033	3	0	8	Q3	2012	4.5800	1.7404	2.0000	1
114	159	11	0	5	Q2	2012	1.8400	0.7176	2.0000	1
114	282	24	0	5	Q2	2012	1.8400	0.7176	2.0000	1
114	467	13	0	10	Q4	2012	1.8400	0.6624	2.0000	1
114	571	3	0	5	Q2	2012	2.7600	1.1868	3.0000	1
114	785	15	0	5	Q2	2012	2.7600	0.9108	3.0000	1
114	1206	24	1847	2	Q1	2012	3.6800	1.2512	4.0000	1
114	1297	16	0	8	Q3	2012	3.6800	1.8032	4.0000	1
114	1540	24	1869	12	Q4	2012	2.7600	1.1592	3.0000	1
114	1690	16	0	1	Q1	2012	1.8400	0.7912	2.0000	1
114	2224	16	0	12	Q4	2012	3.6800	1.5456	4.0000	1
114	2553	16	0	1	Q1	2012	2.7600	1.1040	3.0000	1
114	2769	16	0	3	Q1	2012	1.8400	0.6992	2.0000	1
114	2981	23	1772	4	Q2	2012	3.6800	1.1040	4.0000	1
114	3010	6	511	5	Q2	2012	2.7600	1.2696	3.0000	1
114	3242	3	0	10	Q4	2012	3.6800	1.7296	4.0000	1
114	3267	23	1775	5	Q2	2012	2.7600	1.3524	3.0000	1
114	3310	17	0	9	Q3	2012	1.8400	0.6256	2.0000	1
114	4099	17	0	12	Q4	2012	3.6800	1.4352	4.0000	1
114	4239	17	1292	1	Q1	2012	1.8400	0.6624	2.0000	1
114	4397	16	0	3	Q1	2012	3.6800	1.4352	4.0000	1
114	4471	11	0	9	Q3	2012	4.6000	1.7940	5.0000	1
114	4810	23	0	5	Q2	2012	4.6000	2.2540	5.0000	1
114	5163	3	0	9	Q3	2012	2.7600	0.9936	3.0000	1
114	5374	16	0	12	Q4	2012	2.7600	1.3524	3.0000	1
114	5396	11	0	1	Q1	2012	3.6800	1.5824	4.0000	1
114	5545	15	0	5	Q2	2012	2.7600	1.2144	3.0000	1
114	5685	13	0	6	Q2	2012	2.7600	1.1592	3.0000	1
114	5796	6	522	10	Q4	2012	3.6800	1.3248	4.0000	1
114	5846	11	0	1	Q1	2012	1.8400	0.8096	2.0000	1
114	5884	24	0	5	Q2	2012	2.7600	0.9660	3.0000	1
114	5892	15	0	1	Q1	2012	1.8400	0.5704	2.0000	1
114	6468	2	0	3	Q1	2012	2.7600	1.1316	3.0000	1
114	6568	14	0	2	Q1	2012	0.9200	0.3864	1.0000	1
114	6670	6	0	4	Q2	2012	3.6800	1.4352	4.0000	1
114	7149	13	0	7	Q3	2012	3.6800	1.1408	4.0000	1
114	7354	3	205	10	Q4	2012	2.7600	0.9660	3.0000	1
114	7377	3	0	5	Q2	2012	2.7600	1.3248	3.0000	1
114	7413	3	210	12	Q4	2012	2.7600	1.2972	3.0000	1
114	7584	6	524	11	Q4	2012	4.6000	2.1620	5.0000	1
114	7719	24	1866	11	Q4	2012	2.7600	0.9936	3.0000	1
114	8060	22	0	12	Q4	2012	0.9200	0.3588	1.0000	1
114	8329	15	0	8	Q3	2012	3.6800	1.2880	4.0000	1
114	8478	7	0	12	Q4	2012	1.8400	0.9016	2.0000	1
114	8556	11	0	4	Q2	2012	2.7600	1.3524	3.0000	1
114	8577	23	0	6	Q2	2012	1.8400	0.6256	2.0000	1
114	8793	7	0	12	Q4	2012	2.7600	1.2144	3.0000	1
114	9866	3	201	8	Q3	2012	2.7600	0.9660	3.0000	1
114	9892	13	0	11	Q4	2012	2.7600	0.8556	3.0000	1
114	9929	13	0	10	Q4	2012	2.7600	0.8832	3.0000	1
115	217	13	976	1	Q1	2012	1.9500	0.8775	3.0000	1
115	378	16	1233	10	Q4	2012	1.3000	0.5460	2.0000	1
115	492	14	0	7	Q3	2012	0.6500	0.2275	1.0000	1
115	505	7	523	11	Q4	2012	2.6000	1.0400	4.0000	1
115	636	17	0	6	Q2	2012	2.6000	0.9880	4.0000	1
115	792	6	0	5	Q2	2012	1.3000	0.5200	2.0000	1
115	830	15	0	2	Q1	2012	2.6000	1.1180	4.0000	1
115	1024	17	1303	6	Q2	2012	1.3000	0.4160	2.0000	1
115	1202	11	0	4	Q2	2012	1.3000	0.5330	2.0000	1
115	1216	17	1304	7	Q3	2012	2.6000	0.8580	4.0000	1
115	1275	24	0	1	Q1	2012	1.3000	0.5460	2.0000	1
115	1838	24	1851	4	Q2	2012	1.3000	0.5070	2.0000	1
115	1890	24	0	10	Q4	2012	2.6000	0.9100	4.0000	1
115	2042	13	0	4	Q2	2012	1.3000	0.6110	2.0000	1
115	2084	17	0	7	Q3	2012	1.3000	0.4160	2.0000	1
115	2269	11	0	5	Q2	2012	1.3000	0.4810	2.0000	1
115	2523	6	0	2	Q1	2012	3.2500	1.5925	5.0000	1
115	2878	3	0	12	Q4	2012	1.9500	0.6435	3.0000	1
115	3075	23	0	3	Q1	2012	2.6000	1.0920	4.0000	1
115	3218	3	0	8	Q3	2012	2.6000	0.9620	4.0000	1
115	3258	7	0	10	Q4	2012	1.9500	0.6435	3.0000	1
115	3302	13	976	1	Q1	2012	2.6000	0.8060	4.0000	1
115	3499	13	0	1	Q1	2012	1.9500	0.7995	3.0000	1
115	4342	13	980	3	Q1	2012	2.6000	0.9620	4.0000	1
115	4345	14	0	10	Q4	2012	0.6500	0.2730	1.0000	1
115	4391	16	0	4	Q2	2012	2.6000	0.9360	4.0000	1
115	4514	11	0	10	Q4	2012	2.6000	0.9620	4.0000	1
115	4573	7	0	5	Q2	2012	1.3000	0.4680	2.0000	1
115	4619	13	0	11	Q4	2012	1.9500	0.6435	3.0000	1
115	4649	17	1312	10	Q4	2012	1.9500	0.8580	3.0000	1
115	4700	17	1303	6	Q2	2012	1.3000	0.4810	2.0000	1
115	4810	23	1776	6	Q2	2012	1.3000	0.5980	2.0000	1
115	4925	16	0	1	Q1	2012	1.9500	0.5850	3.0000	1
115	5026	17	0	12	Q4	2012	2.6000	0.9100	4.0000	1
115	5410	17	0	11	Q4	2012	2.6000	0.9360	4.0000	1
115	5452	13	980	3	Q1	2012	1.3000	0.4420	2.0000	1
115	5942	7	0	11	Q4	2012	1.9500	0.5850	3.0000	1
115	6012	13	0	4	Q2	2012	1.9500	0.6045	3.0000	1
115	6324	23	0	1	Q1	2012	2.6000	0.8320	4.0000	1
115	6420	14	0	8	Q3	2012	1.3000	0.6240	2.0000	1
115	6607	13	0	11	Q4	2012	1.3000	0.5460	2.0000	1
115	6651	11	0	9	Q3	2012	1.9500	0.8385	3.0000	1
115	6713	13	0	7	Q3	2012	1.9500	0.5850	3.0000	1
115	6830	22	0	11	Q4	2012	1.3000	0.6500	2.0000	1
115	6836	7	0	3	Q1	2012	1.9500	0.7800	3.0000	1
115	7420	14	0	9	Q3	2012	0.6500	0.2340	1.0000	1
115	7704	3	195	5	Q2	2012	1.9500	0.6240	3.0000	1
115	7822	3	0	4	Q2	2012	1.3000	0.4680	2.0000	1
115	8311	23	1773	4	Q2	2012	2.6000	0.8320	4.0000	1
115	8555	11	0	1	Q1	2012	1.9500	0.8580	3.0000	1
115	8593	6	0	1	Q1	2012	1.9500	0.7995	3.0000	1
115	9040	16	1216	2	Q1	2012	1.9500	0.8580	3.0000	1
115	9324	3	0	10	Q4	2012	1.3000	0.4160	2.0000	1
115	9327	17	0	6	Q2	2012	2.6000	0.8320	4.0000	1
115	9510	16	0	8	Q3	2012	3.2500	1.5925	5.0000	1
115	9564	17	0	2	Q1	2012	3.2500	1.6250	5.0000	1
115	9937	17	0	10	Q4	2012	1.3000	0.4940	2.0000	1
116	467	13	0	2	Q1	2012	15.8800	4.9228	4.0000	1
116	776	24	1866	11	Q4	2012	11.9100	5.1213	3.0000	1
116	1024	17	0	10	Q4	2012	11.9100	3.8112	3.0000	1
116	1316	7	512	6	Q2	2012	11.9100	4.8831	3.0000	1
116	1316	7	523	11	Q4	2012	11.9100	4.8831	3.0000	1
116	1445	15	1140	4	Q2	2012	19.8500	7.7415	5.0000	1
116	1605	7	521	10	Q4	2012	11.9100	3.6921	3.0000	1
116	1619	6	523	11	Q4	2012	7.9400	2.6202	2.0000	1
116	1684	15	1140	4	Q2	2012	11.9100	5.7168	3.0000	1
116	1922	15	0	5	Q2	2012	11.9100	4.7640	3.0000	1
116	1979	3	0	3	Q1	2012	11.9100	4.8831	3.0000	1
116	2019	16	0	5	Q2	2012	19.8500	5.9550	5.0000	1
116	3178	11	0	12	Q4	2012	11.9100	5.5977	3.0000	1
116	3310	17	1314	11	Q4	2012	11.9100	5.1213	3.0000	1
116	3532	6	0	3	Q1	2012	11.9100	3.9303	3.0000	1
116	3550	11	0	12	Q4	2012	15.8800	5.3992	4.0000	1
116	3878	3	0	8	Q3	2012	15.8800	6.3520	4.0000	1
116	3976	17	1314	11	Q4	2012	7.9400	3.0172	2.0000	1
116	4078	3	0	2	Q1	2012	15.8800	5.0816	4.0000	1
116	4096	3	0	4	Q2	2012	11.9100	4.1685	3.0000	1
116	4148	15	0	10	Q4	2012	11.9100	5.5977	3.0000	1
116	4207	15	1146	7	Q3	2012	15.8800	6.5108	4.0000	1
116	4310	15	0	8	Q3	2012	11.9100	4.8831	3.0000	1
116	4413	13	0	10	Q4	2012	15.8800	7.3048	4.0000	1
116	4541	3	0	8	Q3	2012	11.9100	4.8831	3.0000	1
116	4543	13	0	11	Q4	2012	7.9400	3.4142	2.0000	1
116	4615	17	0	7	Q3	2012	7.9400	2.5408	2.0000	1
116	4666	13	0	1	Q1	2012	7.9400	3.5730	2.0000	1
116	4666	13	0	3	Q1	2012	11.9100	4.4067	3.0000	1
116	5095	7	505	2	Q1	2012	11.9100	5.0022	3.0000	1
116	5592	16	0	8	Q3	2012	11.9100	4.5258	3.0000	1
116	5656	24	0	9	Q3	2012	11.9100	5.3595	3.0000	1
116	5720	2	0	7	Q3	2012	3.9700	1.3895	1.0000	1
116	5871	15	0	2	Q1	2012	7.9400	2.4614	2.0000	1
116	6307	16	0	11	Q4	2012	7.9400	2.7790	2.0000	1
116	6395	15	0	7	Q3	2012	15.8800	5.2404	4.0000	1
116	6690	17	0	3	Q1	2012	7.9400	2.3820	2.0000	1
116	6781	15	0	9	Q3	2012	7.9400	3.1760	2.0000	1
116	6844	11	0	1	Q1	2012	11.9100	5.7168	3.0000	1
116	7266	24	0	4	Q2	2012	15.8800	6.5108	4.0000	1
116	7831	17	0	12	Q4	2012	7.9400	3.1760	2.0000	1
116	7905	13	984	5	Q2	2012	15.8800	5.2404	4.0000	1
116	7980	24	0	9	Q3	2012	15.8800	5.7168	4.0000	1
116	8108	17	0	2	Q1	2012	11.9100	5.7168	3.0000	1
116	8187	11	0	7	Q3	2012	11.9100	4.8831	3.0000	1
116	8308	17	1292	1	Q1	2012	11.9100	4.0494	3.0000	1
116	8342	24	0	1	Q1	2012	15.8800	4.9228	4.0000	1
116	8511	16	0	7	Q3	2012	11.9100	5.1213	3.0000	1
116	8746	23	0	12	Q4	2012	15.8800	4.7640	4.0000	1
116	8891	11	0	7	Q3	2012	11.9100	5.7168	3.0000	1
116	8919	13	980	3	Q1	2012	15.8800	6.0344	4.0000	1
116	8945	23	0	10	Q4	2012	7.9400	3.4936	2.0000	1
116	8960	3	0	5	Q2	2012	15.8800	6.3520	4.0000	1
116	8994	17	0	5	Q2	2012	11.9100	4.8831	3.0000	1
116	9110	15	1138	3	Q1	2012	11.9100	5.1213	3.0000	1
116	9269	7	523	11	Q4	2012	11.9100	5.8359	3.0000	1
116	9448	13	1000	12	Q4	2012	11.9100	4.1685	3.0000	1
116	9534	17	1294	2	Q1	2012	11.9100	5.4786	3.0000	1
116	9564	17	0	9	Q3	2012	15.8800	7.1460	4.0000	1
116	10062	15	0	6	Q2	2012	19.8500	6.7490	5.0000	1
116	10110	24	0	7	Q3	2012	15.8800	7.3048	4.0000	1
116	10156	14	1072	9	Q3	2012	7.9400	2.4614	2.0000	1
117	178	13	0	5	Q2	2012	8.2500	2.4750	3.0000	1
117	1137	6	0	4	Q2	2012	11.0000	3.7400	4.0000	1
117	1286	24	0	8	Q3	2012	11.0000	4.2900	4.0000	1
117	1289	23	0	9	Q3	2012	8.2500	3.6300	3.0000	1
117	1296	15	1152	9	Q3	2012	5.5000	2.0350	2.0000	1
117	1341	3	0	8	Q3	2012	5.5000	2.4750	2.0000	1
117	2150	6	0	10	Q4	2012	8.2500	2.6400	3.0000	1
117	2295	17	0	9	Q3	2012	11.0000	3.6300	4.0000	1
117	2378	16	1220	4	Q2	2012	11.0000	4.6200	4.0000	1
117	2941	24	1847	2	Q1	2012	8.2500	3.8775	3.0000	1
117	3222	7	0	6	Q2	2012	8.2500	2.8050	3.0000	1
117	3463	13	0	6	Q2	2012	8.2500	2.8050	3.0000	1
117	3588	24	1856	6	Q2	2012	5.5000	2.2550	2.0000	1
117	4301	11	829	6	Q2	2012	8.2500	3.3825	3.0000	1
117	4351	23	1776	6	Q2	2012	11.0000	3.5200	4.0000	1
117	4445	17	0	5	Q2	2012	5.5000	1.9800	2.0000	1
117	4658	17	0	5	Q2	2012	5.5000	1.7600	2.0000	1
117	4727	16	1233	10	Q4	2012	8.2500	3.5475	3.0000	1
117	4767	16	1225	7	Q3	2012	8.2500	4.0425	3.0000	1
117	5067	17	0	7	Q3	2012	8.2500	3.6300	3.0000	1
117	5307	6	0	6	Q2	2012	8.2500	3.2175	3.0000	1
117	5436	7	504	2	Q1	2012	8.2500	2.8875	3.0000	1
117	5486	24	0	7	Q3	2012	8.2500	4.1250	3.0000	1
117	5528	24	0	5	Q2	2012	8.2500	2.8875	3.0000	1
117	5539	7	0	3	Q1	2012	11.0000	4.9500	4.0000	1
117	5568	23	0	10	Q4	2012	8.2500	3.3825	3.0000	1
117	5808	7	0	7	Q3	2012	8.2500	3.5475	3.0000	1
117	5895	17	0	12	Q4	2012	11.0000	4.4000	4.0000	1
117	5973	3	187	2	Q1	2012	5.5000	2.1450	2.0000	1
117	6348	16	0	4	Q2	2012	8.2500	3.3825	3.0000	1
117	6459	24	1845	1	Q1	2012	8.2500	3.9600	3.0000	1
117	6681	17	0	3	Q1	2012	8.2500	3.5475	3.0000	1
117	6702	6	0	3	Q1	2012	8.2500	2.6400	3.0000	1
117	6784	15	1143	5	Q2	2012	5.5000	1.9250	2.0000	1
117	7076	7	521	10	Q4	2012	11.0000	5.0600	4.0000	1
117	7209	11	837	10	Q4	2012	8.2500	2.9700	3.0000	1
117	7474	7	0	1	Q1	2012	8.2500	2.5575	3.0000	1
117	7607	17	1292	1	Q1	2012	8.2500	3.5475	3.0000	1
117	7702	16	0	4	Q2	2012	8.2500	3.2175	3.0000	1
117	8074	17	0	4	Q2	2012	8.2500	3.7950	3.0000	1
117	8074	17	0	6	Q2	2012	5.5000	2.6400	2.0000	1
117	8134	11	0	2	Q1	2012	5.5000	2.5850	2.0000	1
117	8841	13	0	9	Q3	2012	11.0000	4.9500	4.0000	1
117	8872	24	0	2	Q1	2012	8.2500	3.7950	3.0000	1
117	9256	13	0	11	Q4	2012	8.2500	3.5475	3.0000	1
117	9324	3	0	8	Q3	2012	5.5000	2.2000	2.0000	1
117	9697	23	1783	9	Q3	2012	11.0000	4.6200	4.0000	1
117	10026	13	0	6	Q2	2012	8.2500	3.3000	3.0000	1
118	376	11	821	2	Q1	2012	5.9200	2.0128	4.0000	1
118	1037	7	0	10	Q4	2012	2.9600	1.0952	2.0000	1
118	1115	22	0	10	Q4	2012	1.4800	0.6512	1.0000	1
118	1157	24	0	3	Q1	2012	2.9600	1.1544	2.0000	1
118	1451	3	0	7	Q3	2012	4.4400	1.6428	3.0000	1
118	1452	24	0	7	Q3	2012	2.9600	1.3320	2.0000	1
118	1580	15	0	11	Q4	2012	7.4000	2.8860	5.0000	1
118	1580	15	1141	4	Q2	2012	7.4000	2.8860	5.0000	1
118	1681	13	0	12	Q4	2012	5.9200	2.1312	4.0000	1
118	2201	16	0	10	Q4	2012	5.9200	2.5456	4.0000	1
118	2553	16	0	12	Q4	2012	4.4400	1.6428	3.0000	1
118	2588	23	1775	5	Q2	2012	5.9200	2.4864	4.0000	1
118	2872	2	0	5	Q2	2012	1.4800	0.4588	1.0000	1
118	3181	24	0	12	Q4	2012	7.4000	3.2560	5.0000	1
118	3242	3	0	10	Q4	2012	4.4400	1.3764	3.0000	1
118	3310	17	0	2	Q1	2012	2.9600	1.0360	2.0000	1
118	3524	13	0	10	Q4	2012	4.4400	1.8204	3.0000	1
118	3695	13	0	11	Q4	2012	2.9600	1.0360	2.0000	1
118	4021	16	0	1	Q1	2012	5.9200	1.8944	4.0000	1
118	4029	17	0	12	Q4	2012	4.4400	2.0868	3.0000	1
118	4133	24	0	4	Q2	2012	5.9200	1.8944	4.0000	1
118	4465	13	0	5	Q2	2012	2.9600	1.2432	2.0000	1
118	4486	6	0	7	Q3	2012	5.9200	1.9536	4.0000	1
118	4503	13	992	9	Q3	2012	5.9200	2.3088	4.0000	1
118	4609	23	0	11	Q4	2012	2.9600	1.3320	2.0000	1
118	4868	16	0	6	Q2	2012	2.9600	1.0952	2.0000	1
118	4868	16	0	11	Q4	2012	2.9600	1.0360	2.0000	1
118	5279	7	0	6	Q2	2012	5.9200	2.9600	4.0000	1
118	5398	17	0	1	Q1	2012	5.9200	2.9600	4.0000	1
118	5547	6	524	11	Q4	2012	2.9600	1.2432	2.0000	1
118	5607	7	0	4	Q2	2012	4.4400	1.3764	3.0000	1
118	5760	13	0	5	Q2	2012	2.9600	1.0656	2.0000	1
118	5792	15	0	3	Q1	2012	5.9200	2.0720	4.0000	1
118	5925	15	0	9	Q3	2012	5.9200	2.3680	4.0000	1
118	6113	16	1231	9	Q3	2012	2.9600	1.3616	2.0000	1
118	6161	17	0	2	Q1	2012	5.9200	2.9008	4.0000	1
118	6547	15	0	1	Q1	2012	4.4400	1.9092	3.0000	1
118	6551	11	0	5	Q2	2012	2.9600	1.3912	2.0000	1
118	6590	7	518	8	Q3	2012	5.9200	2.1904	4.0000	1
118	6778	24	0	2	Q1	2012	4.4400	2.1756	3.0000	1
118	6800	24	1860	8	Q3	2012	4.4400	1.3320	3.0000	1
118	7004	11	0	12	Q4	2012	4.4400	1.7316	3.0000	1
118	7017	24	0	7	Q3	2012	2.9600	0.8880	2.0000	1
118	7187	7	0	7	Q3	2012	4.4400	1.7760	3.0000	1
118	7306	6	0	3	Q1	2012	4.4400	1.9092	3.0000	1
118	7393	24	0	7	Q3	2012	2.9600	1.0656	2.0000	1
118	7514	17	0	11	Q4	2012	7.4000	3.1080	5.0000	1
118	7606	11	829	6	Q2	2012	5.9200	2.1904	4.0000	1
118	7702	16	0	10	Q4	2012	4.4400	1.5984	3.0000	1
118	7717	11	0	7	Q3	2012	4.4400	2.0868	3.0000	1
118	8304	13	0	1	Q1	2012	4.4400	1.9536	3.0000	1
118	8478	6	504	2	Q1	2012	5.9200	2.1312	4.0000	1
118	8747	6	515	7	Q3	2012	4.4400	1.8204	3.0000	1
118	8760	24	1859	8	Q3	2012	2.9600	1.3912	2.0000	1
118	9248	15	1157	12	Q4	2012	5.9200	2.1904	4.0000	1
118	9530	13	0	1	Q1	2012	2.9600	0.9176	2.0000	1
118	9814	6	0	7	Q3	2012	5.9200	1.8944	4.0000	1
118	9826	13	0	6	Q2	2012	2.9600	1.1544	2.0000	1
118	9826	13	976	1	Q1	2012	4.4400	1.7316	3.0000	1
118	9846	24	0	5	Q2	2012	4.4400	1.7316	3.0000	1
118	9997	17	0	7	Q3	2012	2.9600	1.0952	2.0000	1
119	666	24	0	1	Q1	2012	6.8400	2.2572	3.0000	1
119	997	3	0	11	Q4	2012	9.1200	3.6480	4.0000	1
119	1097	23	0	12	Q4	2012	6.8400	2.9412	3.0000	1
119	1282	3	0	8	Q3	2012	6.8400	2.6676	3.0000	1
119	1491	16	1233	10	Q4	2012	6.8400	2.4624	3.0000	1
119	1549	7	0	6	Q2	2012	9.1200	2.7360	4.0000	1
119	1567	16	1225	7	Q3	2012	4.5600	1.4592	2.0000	1
119	1762	24	0	7	Q3	2012	6.8400	2.8728	3.0000	1
119	1818	11	0	3	Q1	2012	9.1200	3.9216	4.0000	1
119	1832	23	0	11	Q4	2012	11.4000	4.1040	5.0000	1
119	1838	24	0	11	Q4	2012	6.8400	2.2572	3.0000	1
119	1898	7	0	4	Q2	2012	6.8400	2.6676	3.0000	1
119	2194	7	518	8	Q3	2012	6.8400	2.4624	3.0000	1
119	2424	6	508	4	Q2	2012	4.5600	1.6416	2.0000	1
119	2438	7	0	12	Q4	2012	6.8400	3.2832	3.0000	1
119	2438	7	523	11	Q4	2012	4.5600	1.9152	2.0000	1
119	2794	6	0	10	Q4	2012	6.8400	3.0096	3.0000	1
119	3075	23	1765	1	Q1	2012	4.5600	1.4136	2.0000	1
119	3211	2	0	3	Q1	2012	4.5600	2.1888	2.0000	1
119	3218	3	0	8	Q3	2012	4.5600	1.5048	2.0000	1
119	3334	17	0	5	Q2	2012	4.5600	2.0520	2.0000	1
119	3388	13	984	5	Q2	2012	9.1200	4.0128	4.0000	1
119	3423	13	980	3	Q1	2012	9.1200	2.8272	4.0000	1
119	3548	13	0	8	Q3	2012	6.8400	2.8728	3.0000	1
119	3596	11	0	7	Q3	2012	9.1200	2.9184	4.0000	1
119	3706	13	982	4	Q2	2012	6.8400	2.7360	3.0000	1
119	3726	7	504	2	Q1	2012	4.5600	2.0520	2.0000	1
119	3740	15	0	9	Q3	2012	11.4000	5.3580	5.0000	1
119	4070	23	0	6	Q2	2012	4.5600	1.6872	2.0000	1
119	4186	7	0	3	Q1	2012	4.5600	1.5504	2.0000	1
119	4643	22	1711	12	Q4	2012	2.2800	1.0488	1.0000	1
119	4928	13	0	3	Q1	2012	9.1200	3.3744	4.0000	1
119	4928	13	980	3	Q1	2012	4.5600	2.2344	2.0000	1
119	4982	24	0	4	Q2	2012	6.8400	2.7360	3.0000	1
119	5542	16	0	6	Q2	2012	6.8400	2.5308	3.0000	1
119	5592	16	1233	10	Q4	2012	6.8400	3.2832	3.0000	1
119	5674	7	0	5	Q2	2012	4.5600	1.3680	2.0000	1
119	5734	13	0	2	Q1	2012	6.8400	2.5308	3.0000	1
119	6062	6	0	1	Q1	2012	6.8400	2.2572	3.0000	1
119	6079	13	0	5	Q2	2012	9.1200	3.5568	4.0000	1
119	6082	13	0	3	Q1	2012	6.8400	2.8044	3.0000	1
119	6148	11	0	11	Q4	2012	4.5600	1.7784	2.0000	1
119	6168	17	0	5	Q2	2012	9.1200	3.3744	4.0000	1
119	6169	13	0	8	Q3	2012	9.1200	3.1008	4.0000	1
119	6324	23	1768	2	Q1	2012	9.1200	2.9184	4.0000	1
119	6347	17	1304	7	Q3	2012	6.8400	3.2832	3.0000	1
119	6954	24	0	8	Q3	2012	9.1200	3.9216	4.0000	1
119	7570	13	0	9	Q3	2012	6.8400	2.1888	3.0000	1
119	8159	7	0	4	Q2	2012	9.1200	4.2864	4.0000	1
119	8214	6	521	10	Q4	2012	6.8400	2.2572	3.0000	1
119	8318	24	0	12	Q4	2012	6.8400	2.5992	3.0000	1
119	8511	16	0	8	Q3	2012	4.5600	1.9608	2.0000	1
119	8593	6	0	4	Q2	2012	4.5600	1.3680	2.0000	1
119	8717	17	1293	1	Q1	2012	6.8400	2.8728	3.0000	1
119	8768	11	837	10	Q4	2012	6.8400	3.2148	3.0000	1
119	8916	11	842	12	Q4	2012	6.8400	3.2148	3.0000	1
119	9040	16	0	7	Q3	2012	6.8400	2.3256	3.0000	1
119	9044	6	0	10	Q4	2012	9.1200	3.9216	4.0000	1
119	9213	11	0	1	Q1	2012	6.8400	2.4624	3.0000	1
119	9256	13	0	2	Q1	2012	6.8400	2.9412	3.0000	1
119	9451	15	0	6	Q2	2012	9.1200	3.9216	4.0000	1
119	9881	3	0	7	Q3	2012	6.8400	2.3256	3.0000	1
120	255	7	0	6	Q2	2012	4.5200	1.6724	2.0000	1
120	420	22	1710	12	Q4	2012	6.7800	3.2544	3.0000	1
120	588	23	1776	6	Q2	2012	6.7800	2.7120	3.0000	1
120	769	16	0	9	Q3	2012	6.7800	2.6442	3.0000	1
120	905	3	0	7	Q3	2012	6.7800	2.1696	3.0000	1
120	1102	7	516	8	Q3	2012	4.5200	1.8080	2.0000	1
120	1310	16	0	10	Q4	2012	9.0400	4.3392	4.0000	1
120	1561	24	1846	2	Q1	2012	6.7800	2.6442	3.0000	1
120	1605	7	0	10	Q4	2012	4.5200	1.6272	2.0000	1
120	1915	11	0	6	Q2	2012	4.5200	1.5820	2.0000	1
120	1940	13	0	1	Q1	2012	4.5200	2.0340	2.0000	1
120	2011	23	1776	6	Q2	2012	4.5200	2.0340	2.0000	1
120	2921	16	0	5	Q2	2012	9.0400	3.0736	4.0000	1
120	2947	17	1311	10	Q4	2012	4.5200	1.9436	2.0000	1
120	3208	14	0	10	Q4	2012	6.7800	2.1018	3.0000	1
120	3533	3	201	8	Q3	2012	6.7800	2.7120	3.0000	1
120	3788	2	0	11	Q4	2012	4.5200	2.2148	2.0000	1
120	4021	16	1235	11	Q4	2012	9.0400	2.8928	4.0000	1
120	4220	11	0	12	Q4	2012	9.0400	3.2544	4.0000	1
120	4220	11	824	4	Q2	2012	9.0400	3.2544	4.0000	1
120	4221	17	0	10	Q4	2012	4.5200	1.6272	2.0000	1
120	4465	13	0	5	Q2	2012	6.7800	2.9154	3.0000	1
120	4527	3	210	12	Q4	2012	6.7800	2.1018	3.0000	1
120	4543	13	0	7	Q3	2012	9.0400	3.5256	4.0000	1
120	4670	17	0	9	Q3	2012	4.5200	2.0792	2.0000	1
120	4727	16	0	6	Q2	2012	6.7800	2.3730	3.0000	1
120	5026	17	1314	11	Q4	2012	9.0400	4.1584	4.0000	1
120	5061	7	0	10	Q4	2012	9.0400	3.2544	4.0000	1
120	5063	3	0	3	Q1	2012	9.0400	2.7120	4.0000	1
120	6114	16	0	1	Q1	2012	4.5200	1.6272	2.0000	1
120	6206	11	0	11	Q4	2012	9.0400	3.6160	4.0000	1
120	6647	17	1311	10	Q4	2012	6.7800	3.0510	3.0000	1
120	6929	24	0	6	Q2	2012	9.0400	3.7064	4.0000	1
120	6982	13	0	11	Q4	2012	4.5200	1.4464	2.0000	1
120	7075	15	0	1	Q1	2012	6.7800	2.5086	3.0000	1
120	7303	7	504	2	Q1	2012	9.0400	3.5256	4.0000	1
120	7832	7	0	7	Q3	2012	4.5200	2.0340	2.0000	1
120	7862	16	0	6	Q2	2012	11.3000	3.3900	5.0000	1
120	7930	11	0	8	Q3	2012	4.5200	2.2600	2.0000	1
120	8003	3	0	11	Q4	2012	9.0400	3.7968	4.0000	1
120	8149	24	0	4	Q2	2012	6.7800	2.7798	3.0000	1
120	8172	17	0	6	Q2	2012	9.0400	4.3392	4.0000	1
120	8202	3	0	7	Q3	2012	9.0400	3.5256	4.0000	1
120	8351	16	0	6	Q2	2012	9.0400	3.2544	4.0000	1
120	8577	23	0	1	Q1	2012	6.7800	2.3730	3.0000	1
120	8684	6	519	9	Q3	2012	9.0400	4.0680	4.0000	1
120	8695	15	1141	4	Q2	2012	9.0400	2.7120	4.0000	1
120	8737	11	820	2	Q1	2012	4.5200	2.1244	2.0000	1
120	8793	6	521	10	Q4	2012	6.7800	2.3052	3.0000	1
120	9055	6	0	9	Q3	2012	6.7800	3.1188	3.0000	1
120	9068	7	0	4	Q2	2012	4.5200	1.5368	2.0000	1
120	9234	24	0	11	Q4	2012	9.0400	2.9832	4.0000	1
120	9324	3	0	6	Q2	2012	4.5200	2.2600	2.0000	1
120	9384	24	0	4	Q2	2012	4.5200	1.4012	2.0000	1
120	9473	15	0	3	Q1	2012	4.5200	1.9436	2.0000	1
120	9570	15	0	11	Q4	2012	9.0400	4.0680	4.0000	1
120	10186	13	0	12	Q4	2012	6.7800	2.8476	3.0000	1
121	363	7	0	1	Q1	2012	5.9600	2.2648	2.0000	1
121	439	13	0	8	Q3	2012	11.9200	4.7680	4.0000	1
121	803	7	0	5	Q2	2012	8.9400	3.3078	3.0000	1
121	1389	6	0	12	Q4	2012	8.9400	4.1124	3.0000	1
121	1415	16	0	3	Q1	2012	8.9400	3.7548	3.0000	1
121	1706	13	0	9	Q3	2012	8.9400	4.3806	3.0000	1
121	1802	23	1788	11	Q4	2012	8.9400	3.6654	3.0000	1
121	1835	11	0	9	Q3	2012	11.9200	3.8144	4.0000	1
121	1862	17	0	11	Q4	2012	5.9600	1.9072	2.0000	1
121	1940	13	0	3	Q1	2012	5.9600	2.6820	2.0000	1
121	2234	13	0	7	Q3	2012	8.9400	2.8608	3.0000	1
121	2523	7	514	7	Q3	2012	5.9600	2.3840	2.0000	1
121	2942	17	1312	10	Q4	2012	11.9200	4.5296	4.0000	1
121	3020	13	0	5	Q2	2012	5.9600	1.8476	2.0000	1
121	3263	14	1062	4	Q2	2012	2.9800	0.9238	1.0000	1
121	3552	17	1294	2	Q1	2012	8.9400	3.1290	3.0000	1
121	3744	7	0	10	Q4	2012	5.9600	2.8012	2.0000	1
121	3748	13	0	1	Q1	2012	8.9400	2.9502	3.0000	1
121	3755	24	0	6	Q2	2012	8.9400	3.6654	3.0000	1
121	3976	17	0	3	Q1	2012	8.9400	4.1124	3.0000	1
121	4069	17	0	4	Q2	2012	8.9400	3.9336	3.0000	1
121	4253	13	0	7	Q3	2012	8.9400	3.4866	3.0000	1
121	4373	11	821	2	Q1	2012	11.9200	5.4832	4.0000	1
121	4445	17	1314	11	Q4	2012	8.9400	3.2184	3.0000	1
121	4606	3	0	12	Q4	2012	8.9400	3.4866	3.0000	1
121	4695	13	0	4	Q2	2012	11.9200	4.0528	4.0000	1
121	4695	13	0	8	Q3	2012	8.9400	4.2912	3.0000	1
121	4763	24	0	10	Q4	2012	11.9200	5.0064	4.0000	1
121	4767	16	0	5	Q2	2012	11.9200	4.5296	4.0000	1
121	4836	11	0	6	Q2	2012	8.9400	4.3806	3.0000	1
121	4985	23	0	11	Q4	2012	14.9000	5.5130	5.0000	1
121	5143	17	0	9	Q3	2012	5.9600	1.9072	2.0000	1
121	5256	17	1304	7	Q3	2012	11.9200	5.7216	4.0000	1
121	5308	6	0	4	Q2	2012	11.9200	5.2448	4.0000	1
121	5353	23	0	2	Q1	2012	8.9400	3.6654	3.0000	1
121	5592	16	0	11	Q4	2012	11.9200	5.3640	4.0000	1
121	5753	15	1150	8	Q3	2012	8.9400	2.6820	3.0000	1
121	5984	17	0	6	Q2	2012	8.9400	3.2184	3.0000	1
121	6049	15	0	12	Q4	2012	14.9000	5.9600	5.0000	1
121	6153	16	0	9	Q3	2012	5.9600	2.3244	2.0000	1
121	6371	24	0	4	Q2	2012	11.9200	5.0064	4.0000	1
121	6574	13	0	9	Q3	2012	11.9200	5.6024	4.0000	1
121	6690	17	0	2	Q1	2012	11.9200	5.8408	4.0000	1
121	7038	24	0	6	Q2	2012	11.9200	5.2448	4.0000	1
121	7085	11	0	5	Q2	2012	11.9200	5.8408	4.0000	1
121	7141	17	0	12	Q4	2012	8.9400	3.9336	3.0000	1
121	7556	17	0	8	Q3	2012	8.9400	4.3806	3.0000	1
121	7702	16	0	3	Q1	2012	8.9400	3.4866	3.0000	1
121	7715	13	980	3	Q1	2012	14.9000	6.7050	5.0000	1
121	8296	6	515	7	Q3	2012	11.9200	4.7680	4.0000	1
121	9536	24	0	4	Q2	2012	5.9600	2.1456	2.0000	1
122	120	11	0	5	Q2	2012	3.9800	1.1940	2.0000	1
122	355	3	0	11	Q4	2012	5.9700	2.3283	3.0000	1
122	453	24	0	11	Q4	2012	3.9800	1.4328	2.0000	1
122	485	15	1141	4	Q2	2012	5.9700	2.2089	3.0000	1
122	790	13	0	5	Q2	2012	3.9800	1.4726	2.0000	1
122	921	23	0	5	Q2	2012	7.9600	3.6616	4.0000	1
122	1110	15	0	11	Q4	2012	5.9700	2.2089	3.0000	1
122	1587	11	837	10	Q4	2012	5.9700	1.9701	3.0000	1
122	1988	11	837	10	Q4	2012	3.9800	1.4328	2.0000	1
122	2368	3	202	8	Q3	2012	5.9700	2.2686	3.0000	1
122	3065	3	0	11	Q4	2012	3.9800	1.3532	2.0000	1
122	3308	13	988	7	Q3	2012	7.9600	3.6616	4.0000	1
122	3373	15	0	2	Q1	2012	7.9600	3.4228	4.0000	1
122	3373	15	1150	8	Q3	2012	7.9600	3.5820	4.0000	1
122	3395	11	0	4	Q2	2012	5.9700	2.1492	3.0000	1
122	3476	3	0	7	Q3	2012	7.9600	2.4676	4.0000	1
122	4094	16	1225	7	Q3	2012	7.9600	2.7064	4.0000	1
122	4096	3	0	5	Q2	2012	3.9800	1.3930	2.0000	1
122	4338	7	0	1	Q1	2012	5.9700	2.2686	3.0000	1
122	4443	11	821	3	Q1	2012	5.9700	2.0895	3.0000	1
122	4606	3	0	2	Q1	2012	7.9600	2.3880	4.0000	1
122	4727	16	0	7	Q3	2012	9.9500	4.8755	5.0000	1
122	4784	11	0	5	Q2	2012	9.9500	3.8805	5.0000	1
122	4845	24	0	7	Q3	2012	7.9600	3.4228	4.0000	1
122	5257	13	0	8	Q3	2012	5.9700	2.8656	3.0000	1
122	5374	16	0	6	Q2	2012	7.9600	3.1840	4.0000	1
122	5458	15	1149	8	Q3	2012	3.9800	1.4726	2.0000	1
122	5505	15	1157	12	Q4	2012	7.9600	2.5472	4.0000	1
122	5580	7	0	8	Q3	2012	7.9600	2.8656	4.0000	1
122	6105	23	0	8	Q3	2012	7.9600	2.8656	4.0000	1
122	6161	17	0	2	Q1	2012	5.9700	1.8507	3.0000	1
122	6180	13	976	1	Q1	2012	7.9600	3.1044	4.0000	1
122	6802	6	0	2	Q1	2012	7.9600	3.7412	4.0000	1
122	7287	24	0	10	Q4	2012	3.9800	1.1940	2.0000	1
122	7390	15	0	6	Q2	2012	3.9800	1.8308	2.0000	1
122	7413	3	0	10	Q4	2012	3.9800	1.5124	2.0000	1
122	7502	16	1231	9	Q3	2012	7.9600	2.7860	4.0000	1
122	7686	14	0	3	Q1	2012	1.9900	0.7164	1.0000	1
122	9224	17	1293	1	Q1	2012	7.9600	3.6616	4.0000	1
122	9346	15	1146	7	Q3	2012	3.9800	1.4328	2.0000	1
122	9728	16	0	8	Q3	2012	7.9600	3.1044	4.0000	1
122	10062	15	0	6	Q2	2012	7.9600	2.7064	4.0000	1
123	261	24	0	3	Q1	2012	19.2000	5.9520	5.0000	1
123	1204	24	0	9	Q3	2012	11.5200	4.4928	3.0000	1
123	1917	23	1778	7	Q3	2012	15.3600	4.9152	4.0000	1
123	2298	3	0	8	Q3	2012	11.5200	5.6448	3.0000	1
123	2342	6	502	1	Q1	2012	11.5200	4.7232	3.0000	1
123	2981	23	0	9	Q3	2012	11.5200	4.4928	3.0000	1
123	3121	7	0	5	Q2	2012	11.5200	4.3776	3.0000	1
123	3121	7	0	9	Q3	2012	11.5200	4.3776	3.0000	1
123	3130	13	0	7	Q3	2012	7.6800	2.6112	2.0000	1
123	3133	24	0	5	Q2	2012	11.5200	4.6080	3.0000	1
123	3463	13	0	6	Q2	2012	11.5200	4.3776	3.0000	1
123	3469	24	1869	12	Q4	2012	15.3600	6.1440	4.0000	1
123	3471	11	0	9	Q3	2012	11.5200	3.8016	3.0000	1
123	3548	13	0	8	Q3	2012	7.6800	3.2256	2.0000	1
123	3826	16	0	5	Q2	2012	11.5200	5.4144	3.0000	1
123	4075	3	0	7	Q3	2012	15.3600	5.0688	4.0000	1
123	4157	6	523	11	Q4	2012	11.5200	3.5712	3.0000	1
123	4373	11	841	12	Q4	2012	15.3600	7.0656	4.0000	1
123	4522	17	0	11	Q4	2012	11.5200	4.0320	3.0000	1
123	4676	16	0	9	Q3	2012	15.3600	4.9152	4.0000	1
123	4938	13	0	11	Q4	2012	11.5200	3.9168	3.0000	1
123	4985	23	1769	3	Q1	2012	11.5200	3.9168	3.0000	1
123	5019	23	1781	8	Q3	2012	15.3600	7.3728	4.0000	1
123	5174	16	0	3	Q1	2012	11.5200	5.5296	3.0000	1
123	5410	17	1307	8	Q3	2012	11.5200	5.7600	3.0000	1
123	5686	3	0	3	Q1	2012	11.5200	4.1472	3.0000	1
123	5744	3	195	5	Q2	2012	7.6800	2.5344	2.0000	1
123	5826	15	1143	5	Q2	2012	11.5200	5.1840	3.0000	1
123	6162	17	0	9	Q3	2012	15.3600	7.2192	4.0000	1
123	6352	13	986	6	Q2	2012	11.5200	3.4560	3.0000	1
123	6367	3	0	1	Q1	2012	7.6800	2.9952	2.0000	1
123	6417	6	513	6	Q2	2012	7.6800	2.9184	2.0000	1
123	6429	6	0	6	Q2	2012	15.3600	6.1440	4.0000	1
123	7319	13	0	4	Q2	2012	7.6800	2.8416	2.0000	1
123	7576	13	0	8	Q3	2012	15.3600	4.6080	4.0000	1
123	7822	3	0	11	Q4	2012	7.6800	3.2256	2.0000	1
123	7880	6	522	10	Q4	2012	15.3600	6.9120	4.0000	1
123	7920	17	1292	1	Q1	2012	7.6800	2.6880	2.0000	1
123	8096	7	0	3	Q1	2012	7.6800	3.8400	2.0000	1
123	8179	11	0	12	Q4	2012	7.6800	3.6096	2.0000	1
123	8351	16	0	6	Q2	2012	15.3600	6.2976	4.0000	1
123	9045	24	0	1	Q1	2012	11.5200	3.6864	3.0000	1
123	9200	16	1216	2	Q1	2012	11.5200	5.7600	3.0000	1
123	9422	7	517	8	Q3	2012	19.2000	8.2560	5.0000	1
123	9552	6	0	8	Q3	2012	11.5200	5.0688	3.0000	1
123	9956	17	0	9	Q3	2012	11.5200	4.0320	3.0000	1
124	207	24	1845	1	Q1	2012	4.8400	2.0812	4.0000	1
124	293	22	0	7	Q3	2012	2.4200	1.0406	2.0000	1
124	992	7	519	9	Q3	2012	3.6300	1.4157	3.0000	1
124	1297	16	0	1	Q1	2012	2.4200	0.8712	2.0000	1
124	1352	17	0	12	Q4	2012	2.4200	1.1374	2.0000	1
124	1734	2	0	12	Q4	2012	2.4200	0.7744	2.0000	1
124	1785	3	0	2	Q1	2012	3.6300	1.6335	3.0000	1
124	1850	16	1236	12	Q4	2012	4.8400	2.3232	4.0000	1
124	1919	24	1859	8	Q3	2012	3.6300	1.5246	3.0000	1
124	2158	11	0	11	Q4	2012	2.4200	0.8712	2.0000	1
124	2553	16	0	12	Q4	2012	3.6300	1.5246	3.0000	1
124	2663	16	0	11	Q4	2012	4.8400	2.1780	4.0000	1
124	2681	6	0	8	Q3	2012	2.4200	0.9680	2.0000	1
124	2690	3	0	12	Q4	2012	3.6300	1.5609	3.0000	1
124	3316	6	0	11	Q4	2012	2.4200	1.1374	2.0000	1
124	3389	7	0	11	Q4	2012	3.6300	1.0890	3.0000	1
124	3486	15	0	12	Q4	2012	2.4200	0.8712	2.0000	1
124	3826	16	1225	7	Q3	2012	3.6300	1.2705	3.0000	1
124	4158	24	1847	2	Q1	2012	2.4200	1.0164	2.0000	1
124	4211	11	0	12	Q4	2012	6.0500	2.7225	5.0000	1
124	4291	15	0	12	Q4	2012	3.6300	1.3068	3.0000	1
124	4344	7	0	8	Q3	2012	3.6300	1.1979	3.0000	1
124	4627	7	0	7	Q3	2012	4.8400	1.7424	4.0000	1
124	4810	23	1776	6	Q2	2012	2.4200	1.1858	2.0000	1
124	4868	16	0	5	Q2	2012	4.8400	1.7908	4.0000	1
124	5338	24	0	4	Q2	2012	3.6300	1.5246	3.0000	1
124	5811	6	508	4	Q2	2012	3.6300	1.5246	3.0000	1
124	5924	13	0	2	Q1	2012	3.6300	1.3068	3.0000	1
124	6018	11	0	10	Q4	2012	2.4200	1.1616	2.0000	1
124	6313	17	0	4	Q2	2012	2.4200	1.0890	2.0000	1
124	6496	3	0	5	Q2	2012	2.4200	1.0406	2.0000	1
124	6749	6	0	3	Q1	2012	6.0500	2.6620	5.0000	1
124	7072	16	0	6	Q2	2012	4.8400	1.5488	4.0000	1
124	7109	11	0	1	Q1	2012	3.6300	1.1616	3.0000	1
124	7109	11	0	10	Q4	2012	3.6300	1.1616	3.0000	1
124	8242	17	0	10	Q4	2012	2.4200	0.8470	2.0000	1
124	8351	16	1235	11	Q4	2012	3.6300	1.4520	3.0000	1
124	8746	23	0	9	Q3	2012	3.6300	1.6335	3.0000	1
124	8760	24	1845	1	Q1	2012	2.4200	0.8228	2.0000	1
124	8787	7	0	10	Q4	2012	3.6300	1.6335	3.0000	1
124	8945	23	0	10	Q4	2012	3.6300	1.6698	3.0000	1
124	9040	16	0	1	Q1	2012	2.4200	1.0164	2.0000	1
124	9639	17	1307	8	Q3	2012	2.4200	0.8954	2.0000	1
124	10033	3	0	6	Q2	2012	2.4200	0.8228	2.0000	1
124	10111	3	0	9	Q3	2012	2.4200	0.7502	2.0000	1
124	10190	15	1138	3	Q1	2012	4.8400	1.6940	4.0000	1
125	137	7	0	9	Q3	2012	11.6000	5.5680	5.0000	1
125	354	23	0	10	Q4	2012	11.6000	3.8280	5.0000	1
125	532	13	0	11	Q4	2012	9.2800	3.6192	4.0000	1
125	769	16	0	9	Q3	2012	6.9600	2.7144	3.0000	1
125	864	24	0	11	Q4	2012	4.6400	1.4384	2.0000	1
125	907	6	0	6	Q2	2012	4.6400	1.9488	2.0000	1
125	997	3	201	8	Q3	2012	9.2800	2.7840	4.0000	1
125	1281	3	0	4	Q2	2012	6.9600	3.3408	3.0000	1
125	1339	13	0	4	Q2	2012	6.9600	2.8536	3.0000	1
125	1681	13	0	11	Q4	2012	9.2800	3.9904	4.0000	1
125	2102	6	524	11	Q4	2012	6.9600	2.2272	3.0000	1
125	2594	17	0	12	Q4	2012	11.6000	4.9880	5.0000	1
125	3250	15	0	9	Q3	2012	11.6000	4.9880	5.0000	1
125	3540	24	0	10	Q4	2012	4.6400	1.4848	2.0000	1
125	3549	22	1698	6	Q2	2012	2.3200	0.9048	1.0000	1
125	3759	13	0	7	Q3	2012	4.6400	1.4848	2.0000	1
125	3828	24	0	3	Q1	2012	6.9600	2.2272	3.0000	1
125	3861	14	0	1	Q1	2012	2.3200	0.7424	1.0000	1
125	3939	7	0	3	Q1	2012	4.6400	1.6240	2.0000	1
125	4094	16	0	7	Q3	2012	4.6400	1.6704	2.0000	1
125	4204	17	0	5	Q2	2012	9.2800	2.8768	4.0000	1
125	4557	22	0	7	Q3	2012	2.3200	1.0904	1.0000	1
125	4606	3	0	10	Q4	2012	6.9600	2.7840	3.0000	1
125	4763	24	0	10	Q4	2012	11.6000	3.5960	5.0000	1
125	4778	3	0	12	Q4	2012	9.2800	3.5264	4.0000	1
125	4973	17	0	9	Q3	2012	4.6400	1.7168	2.0000	1
125	5026	17	0	9	Q3	2012	6.9600	2.1576	3.0000	1
125	5164	2	114	4	Q2	2012	4.6400	1.9488	2.0000	1
125	5389	7	0	9	Q3	2012	9.2800	2.8768	4.0000	1
125	5549	2	0	5	Q2	2012	2.3200	0.9976	1.0000	1
125	5905	15	0	11	Q4	2012	4.6400	1.9488	2.0000	1
125	6131	14	0	10	Q4	2012	2.3200	0.8352	1.0000	1
125	6307	16	1220	4	Q2	2012	9.2800	4.6400	4.0000	1
125	6324	23	0	1	Q1	2012	9.2800	3.8048	4.0000	1
125	7230	7	0	7	Q3	2012	6.9600	2.5056	3.0000	1
125	7275	17	0	9	Q3	2012	6.9600	3.0624	3.0000	1
125	8189	17	0	12	Q4	2012	9.2800	4.5472	4.0000	1
125	8272	7	0	10	Q4	2012	4.6400	1.7168	2.0000	1
125	8351	16	0	5	Q2	2012	9.2800	2.7840	4.0000	1
125	8382	15	0	6	Q2	2012	6.9600	2.2968	3.0000	1
125	8511	16	0	3	Q1	2012	4.6400	1.9024	2.0000	1
125	8549	6	508	4	Q2	2012	4.6400	1.8560	2.0000	1
125	8577	23	0	6	Q2	2012	9.2800	3.8048	4.0000	1
125	9471	7	0	3	Q1	2012	6.9600	3.3408	3.0000	1
125	9554	13	0	3	Q1	2012	6.9600	3.4104	3.0000	1
125	9943	6	0	6	Q2	2012	9.2800	3.8976	4.0000	1
125	10238	16	0	10	Q4	2012	9.2800	3.8048	4.0000	1
126	217	13	976	1	Q1	2012	6.4400	2.8980	4.0000	1
126	464	15	0	11	Q4	2012	8.0500	2.6565	5.0000	1
126	1124	3	187	2	Q1	2012	6.4400	2.7048	4.0000	1
126	1415	16	1220	4	Q2	2012	4.8300	1.9803	3.0000	1
126	1511	11	0	11	Q4	2012	6.4400	3.0912	4.0000	1
126	1638	11	820	2	Q1	2012	3.2200	1.3524	2.0000	1
126	1925	22	0	5	Q2	2012	3.2200	1.4168	2.0000	1
126	1979	3	0	3	Q1	2012	4.8300	1.7388	3.0000	1
126	2019	16	0	12	Q4	2012	6.4400	1.9964	4.0000	1
126	2335	17	0	9	Q3	2012	6.4400	3.0912	4.0000	1
126	2917	15	1146	7	Q3	2012	6.4400	3.1556	4.0000	1
126	2951	24	0	7	Q3	2012	6.4400	1.9320	4.0000	1
126	3352	7	0	8	Q3	2012	3.2200	1.1270	2.0000	1
126	3388	13	0	4	Q2	2012	4.8300	2.3667	3.0000	1
126	3407	7	0	12	Q4	2012	3.2200	1.4168	2.0000	1
126	3776	13	976	1	Q1	2012	4.8300	1.7871	3.0000	1
126	3810	7	0	3	Q1	2012	3.2200	1.4812	2.0000	1
126	4069	17	0	12	Q4	2012	4.8300	2.3667	3.0000	1
126	4094	16	0	6	Q2	2012	6.4400	1.9964	4.0000	1
126	4310	15	0	8	Q3	2012	4.8300	1.7388	3.0000	1
126	4338	7	0	1	Q1	2012	3.2200	1.1270	2.0000	1
126	4363	15	1142	5	Q2	2012	3.2200	1.3524	2.0000	1
126	4395	11	0	2	Q1	2012	4.8300	1.9803	3.0000	1
126	4444	11	0	4	Q2	2012	6.4400	2.3828	4.0000	1
126	4497	17	1297	3	Q1	2012	8.0500	2.6565	5.0000	1
126	4651	22	0	5	Q2	2012	3.2200	1.5456	2.0000	1
126	4800	2	0	6	Q2	2012	3.2200	0.9982	2.0000	1
126	4810	23	1789	12	Q4	2012	3.2200	1.5456	2.0000	1
126	4832	15	0	8	Q3	2012	4.8300	1.7871	3.0000	1
126	4845	24	0	7	Q3	2012	8.0500	2.6565	5.0000	1
126	4846	17	0	8	Q3	2012	4.8300	1.7388	3.0000	1
126	4925	16	1216	2	Q1	2012	4.8300	1.5456	3.0000	1
126	5026	17	0	12	Q4	2012	4.8300	1.4490	3.0000	1
126	5085	24	1847	2	Q1	2012	4.8300	2.1252	3.0000	1
126	5147	13	0	7	Q3	2012	4.8300	2.1252	3.0000	1
126	5374	16	0	8	Q3	2012	6.4400	2.6404	4.0000	1
126	5592	16	1216	2	Q1	2012	6.4400	1.9320	4.0000	1
126	5612	15	1140	4	Q2	2012	4.8300	1.6905	3.0000	1
126	5671	7	0	12	Q4	2012	4.8300	2.1252	3.0000	1
126	6056	15	0	6	Q2	2012	6.4400	1.9964	4.0000	1
126	6171	15	0	8	Q3	2012	4.8300	1.4490	3.0000	1
126	6320	24	0	9	Q3	2012	4.8300	1.6905	3.0000	1
126	6496	3	0	11	Q4	2012	4.8300	2.1252	3.0000	1
126	6577	15	0	9	Q3	2012	4.8300	2.2218	3.0000	1
126	7051	16	0	6	Q2	2012	4.8300	2.2218	3.0000	1
126	7246	6	0	12	Q4	2012	3.2200	1.2558	2.0000	1
126	7667	6	0	2	Q1	2012	4.8300	1.6905	3.0000	1
126	8033	24	0	7	Q3	2012	3.2200	1.2558	2.0000	1
126	8296	7	523	11	Q4	2012	8.0500	3.1395	5.0000	1
126	8452	16	0	9	Q3	2012	6.4400	2.1896	4.0000	1
126	8511	16	1228	8	Q3	2012	3.2200	1.2558	2.0000	1
126	8668	13	0	9	Q3	2012	6.4400	2.0608	4.0000	1
126	8749	13	0	7	Q3	2012	4.8300	1.6422	3.0000	1
126	8754	7	504	2	Q1	2012	4.8300	1.5939	3.0000	1
126	8891	11	0	7	Q3	2012	3.2200	1.2880	2.0000	1
126	9224	17	0	12	Q4	2012	4.8300	1.7871	3.0000	1
126	9231	11	0	5	Q2	2012	3.2200	1.5778	2.0000	1
126	9263	16	0	5	Q2	2012	4.8300	1.9320	3.0000	1
126	9271	17	1307	8	Q3	2012	8.0500	3.4615	5.0000	1
126	9307	11	0	7	Q3	2012	6.4400	2.3184	4.0000	1
126	9494	7	504	2	Q1	2012	6.4400	2.0608	4.0000	1
126	9648	13	0	7	Q3	2012	3.2200	1.2236	2.0000	1
126	10174	7	0	12	Q4	2012	4.8300	1.7388	3.0000	1
127	293	22	0	12	Q4	2012	5.2200	2.4534	3.0000	1
127	329	7	0	5	Q2	2012	3.4800	1.4964	2.0000	1
127	874	6	0	4	Q2	2012	5.2200	1.7226	3.0000	1
127	1798	3	0	6	Q2	2012	6.9600	3.1320	4.0000	1
127	1979	3	0	4	Q2	2012	6.9600	2.5056	4.0000	1
127	2002	15	0	12	Q4	2012	5.2200	2.5056	3.0000	1
127	2224	16	1235	11	Q4	2012	6.9600	2.9928	4.0000	1
127	2246	13	0	12	Q4	2012	3.4800	1.3920	2.0000	1
127	2294	11	0	10	Q4	2012	3.4800	1.2528	2.0000	1
127	2361	24	0	8	Q3	2012	5.2200	2.0880	3.0000	1
127	2547	23	1789	12	Q4	2012	6.9600	3.2016	4.0000	1
127	2570	16	1220	4	Q2	2012	6.9600	2.0880	4.0000	1
127	2587	16	0	8	Q3	2012	3.4800	1.7052	2.0000	1
127	2626	11	0	11	Q4	2012	3.4800	1.3920	2.0000	1
127	2981	23	1775	5	Q2	2012	6.9600	3.4104	4.0000	1
127	3441	3	0	7	Q3	2012	6.9600	2.1576	4.0000	1
127	3499	13	0	1	Q1	2012	6.9600	2.5752	4.0000	1
127	3549	22	0	7	Q3	2012	1.7400	0.7308	1.0000	1
127	3906	15	0	5	Q2	2012	5.2200	1.5660	3.0000	1
127	3921	23	0	8	Q3	2012	5.2200	2.1402	3.0000	1
127	4219	11	0	1	Q1	2012	5.2200	1.6704	3.0000	1
127	4231	17	1307	8	Q3	2012	6.9600	2.1576	4.0000	1
127	4279	7	0	6	Q2	2012	3.4800	1.3920	2.0000	1
127	4522	17	1314	11	Q4	2012	5.2200	1.8792	3.0000	1
127	4618	3	0	6	Q2	2012	6.9600	3.4104	4.0000	1
127	5147	13	0	11	Q4	2012	5.2200	2.5578	3.0000	1
127	5216	3	0	5	Q2	2012	5.2200	2.5578	3.0000	1
127	5991	3	0	3	Q1	2012	5.2200	2.0358	3.0000	1
127	6021	13	0	1	Q1	2012	5.2200	1.9314	3.0000	1
127	6105	23	0	9	Q3	2012	5.2200	1.9836	3.0000	1
127	6162	17	0	9	Q3	2012	5.2200	1.6182	3.0000	1
127	6428	14	1077	11	Q4	2012	1.7400	0.6612	1.0000	1
127	6617	7	526	12	Q4	2012	6.9600	2.8536	4.0000	1
127	6866	17	0	11	Q4	2012	6.9600	2.1576	4.0000	1
127	7037	11	841	12	Q4	2012	5.2200	2.1402	3.0000	1
127	7079	11	0	12	Q4	2012	6.9600	2.7840	4.0000	1
127	7120	15	0	12	Q4	2012	5.2200	2.2446	3.0000	1
127	7243	13	0	11	Q4	2012	3.4800	1.4616	2.0000	1
127	7263	11	0	1	Q1	2012	6.9600	3.4104	4.0000	1
127	7362	11	833	8	Q3	2012	3.4800	1.1484	2.0000	1
127	7821	7	0	4	Q2	2012	5.2200	1.6704	3.0000	1
127	7870	15	0	12	Q4	2012	3.4800	1.6008	2.0000	1
127	8418	22	1694	4	Q2	2012	1.7400	0.7308	1.0000	1
127	8427	16	1214	2	Q1	2012	5.2200	1.9836	3.0000	1
127	8758	7	504	2	Q1	2012	6.9600	2.4360	4.0000	1
127	8840	17	0	5	Q2	2012	5.2200	2.4012	3.0000	1
127	8889	11	0	12	Q4	2012	5.2200	1.8792	3.0000	1
127	8929	7	0	1	Q1	2012	5.2200	2.4534	3.0000	1
127	8975	15	0	7	Q3	2012	5.2200	2.0880	3.0000	1
127	9101	7	521	10	Q4	2012	6.9600	2.7144	4.0000	1
127	9134	23	1768	2	Q1	2012	3.4800	1.7052	2.0000	1
127	9216	15	1146	7	Q3	2012	6.9600	3.2016	4.0000	1
127	9376	22	1698	6	Q2	2012	1.7400	0.8004	1.0000	1
127	9499	7	0	12	Q4	2012	6.9600	3.3408	4.0000	1
127	9639	17	0	5	Q2	2012	6.9600	2.5752	4.0000	1
127	9684	2	129	11	Q4	2012	5.2200	2.2446	3.0000	1
127	9855	6	0	12	Q4	2012	3.4800	1.1832	2.0000	1
127	9858	24	1845	1	Q1	2012	6.9600	2.3664	4.0000	1
127	10015	17	0	12	Q4	2012	5.2200	2.5578	3.0000	1
127	10015	17	1304	7	Q3	2012	3.4800	1.3224	2.0000	1
128	293	22	0	8	Q3	2012	1.0600	0.4452	2.0000	1
128	485	15	1141	4	Q2	2012	1.5900	0.6678	3.0000	1
128	663	16	0	3	Q1	2012	1.5900	0.5088	3.0000	1
128	940	7	0	5	Q2	2012	1.0600	0.3286	2.0000	1
128	983	11	0	11	Q4	2012	1.0600	0.4664	2.0000	1
128	1267	13	0	7	Q3	2012	2.1200	0.6784	4.0000	1
128	1281	3	0	3	Q1	2012	1.5900	0.5247	3.0000	1
128	1415	16	0	1	Q1	2012	1.5900	0.7791	3.0000	1
128	1556	17	1294	2	Q1	2012	1.5900	0.6837	3.0000	1
128	1723	7	0	11	Q4	2012	1.0600	0.4982	2.0000	1
128	2019	16	1233	10	Q4	2012	2.1200	0.9964	4.0000	1
128	2224	16	0	12	Q4	2012	2.6500	0.9275	5.0000	1
128	2383	2	0	11	Q4	2012	1.0600	0.4558	2.0000	1
128	2525	13	0	2	Q1	2012	1.0600	0.4982	2.0000	1
128	2777	13	0	11	Q4	2012	1.5900	0.6360	3.0000	1
128	3159	24	0	5	Q2	2012	1.0600	0.4770	2.0000	1
128	3160	17	0	9	Q3	2012	1.5900	0.5088	3.0000	1
128	3627	3	0	3	Q1	2012	1.5900	0.6519	3.0000	1
128	3954	24	0	10	Q4	2012	1.5900	0.7473	3.0000	1
128	4481	15	0	1	Q1	2012	1.5900	0.5088	3.0000	1
128	4543	13	988	7	Q3	2012	2.1200	0.9116	4.0000	1
128	4557	22	1711	12	Q4	2012	0.5300	0.2491	1.0000	1
128	4858	17	0	5	Q2	2012	1.5900	0.5724	3.0000	1
128	5125	17	0	6	Q2	2012	1.0600	0.5088	2.0000	1
128	5295	16	0	11	Q4	2012	1.0600	0.3180	2.0000	1
128	5452	13	0	3	Q1	2012	2.1200	0.7844	4.0000	1
128	6291	3	197	6	Q2	2012	2.1200	0.8056	4.0000	1
128	6352	13	0	11	Q4	2012	2.6500	1.0335	5.0000	1
128	7822	3	205	10	Q4	2012	2.1200	0.6784	4.0000	1
128	7866	15	0	10	Q4	2012	2.1200	1.0176	4.0000	1
128	8056	24	0	11	Q4	2012	2.1200	0.9328	4.0000	1
128	8110	13	0	10	Q4	2012	1.0600	0.4558	2.0000	1
128	8277	2	0	5	Q2	2012	1.0600	0.3604	2.0000	1
128	8351	16	1235	11	Q4	2012	1.5900	0.5088	3.0000	1
128	8452	16	0	4	Q2	2012	2.1200	0.7208	4.0000	1
128	8730	7	504	2	Q1	2012	2.1200	1.0388	4.0000	1
128	8963	17	1314	11	Q4	2012	1.0600	0.4452	2.0000	1
128	9110	15	0	4	Q2	2012	2.1200	0.8480	4.0000	1
128	9417	15	0	10	Q4	2012	1.5900	0.5724	3.0000	1
128	9673	13	980	3	Q1	2012	1.5900	0.4929	3.0000	1
128	9719	11	820	2	Q1	2012	2.6500	0.9805	5.0000	1
128	9728	16	0	4	Q2	2012	1.5900	0.4770	3.0000	1
128	9972	13	0	10	Q4	2012	1.5900	0.6042	3.0000	1
128	10059	15	0	9	Q3	2012	2.1200	0.7208	4.0000	1
129	136	15	1143	5	Q2	2012	6.2000	2.7280	4.0000	1
129	1221	15	1157	12	Q4	2012	4.6500	2.3250	3.0000	1
129	1690	16	0	11	Q4	2012	6.2000	2.6040	4.0000	1
129	1750	6	506	3	Q1	2012	3.1000	1.1470	2.0000	1
129	1917	23	1773	4	Q2	2012	4.6500	1.9995	3.0000	1
129	1965	17	1314	11	Q4	2012	4.6500	1.5345	3.0000	1
129	2298	3	0	5	Q2	2012	4.6500	1.4415	3.0000	1
129	2511	17	0	10	Q4	2012	4.6500	1.8135	3.0000	1
129	2756	3	0	4	Q2	2012	3.1000	1.3640	2.0000	1
129	2917	15	0	11	Q4	2012	4.6500	1.8135	3.0000	1
129	2921	16	0	12	Q4	2012	3.1000	1.1780	2.0000	1
129	3293	11	0	9	Q3	2012	4.6500	2.0460	3.0000	1
129	3541	15	1138	3	Q1	2012	6.2000	1.9220	4.0000	1
129	3680	6	0	12	Q4	2012	4.6500	1.6275	3.0000	1
129	4163	14	0	4	Q2	2012	1.5500	0.4960	1.0000	1
129	4340	17	0	3	Q1	2012	6.2000	2.4180	4.0000	1
129	4402	11	0	9	Q3	2012	3.1000	1.3020	2.0000	1
129	4468	11	837	10	Q4	2012	4.6500	1.5810	3.0000	1
129	4767	16	0	5	Q2	2012	6.2000	2.2940	4.0000	1
129	4858	17	0	12	Q4	2012	4.6500	1.6740	3.0000	1
129	4958	23	1778	7	Q3	2012	6.2000	2.7900	4.0000	1
129	5092	17	0	12	Q4	2012	3.1000	1.0540	2.0000	1
129	5542	16	0	11	Q4	2012	4.6500	1.4880	3.0000	1
129	5696	15	0	11	Q4	2012	3.1000	1.4570	2.0000	1
129	5895	17	1311	10	Q4	2012	4.6500	1.4415	3.0000	1
129	6278	7	0	1	Q1	2012	4.6500	1.7205	3.0000	1
129	6324	23	1768	2	Q1	2012	6.2000	2.5420	4.0000	1
129	6570	11	0	5	Q2	2012	3.1000	1.3640	2.0000	1
129	6733	13	0	3	Q1	2012	4.6500	1.9065	3.0000	1
129	6919	11	0	12	Q4	2012	3.1000	1.2400	2.0000	1
129	6997	13	0	11	Q4	2012	4.6500	1.5810	3.0000	1
129	7035	7	0	6	Q2	2012	4.6500	1.9065	3.0000	1
129	7133	22	0	3	Q1	2012	1.5500	0.4805	1.0000	1
129	7486	3	185	1	Q1	2012	3.1000	1.4260	2.0000	1
129	7526	17	1303	6	Q2	2012	6.2000	2.5420	4.0000	1
129	7621	13	0	12	Q4	2012	4.6500	1.9065	3.0000	1
129	8017	7	523	11	Q4	2012	6.2000	2.9140	4.0000	1
129	8084	22	0	1	Q1	2012	1.5500	0.6355	1.0000	1
129	8206	23	1788	11	Q4	2012	6.2000	2.6040	4.0000	1
129	8275	16	0	3	Q1	2012	6.2000	2.3560	4.0000	1
129	8844	13	992	9	Q3	2012	3.1000	1.4570	2.0000	1
129	8892	13	0	2	Q1	2012	4.6500	1.5345	3.0000	1
129	8892	13	0	6	Q2	2012	4.6500	1.5345	3.0000	1
129	9111	17	0	4	Q2	2012	4.6500	1.7205	3.0000	1
129	9124	24	0	8	Q3	2012	6.2000	2.8520	4.0000	1
129	9673	13	0	7	Q3	2012	4.6500	1.4415	3.0000	1
129	9787	13	980	3	Q1	2012	6.2000	3.1000	4.0000	1
129	9823	13	0	7	Q3	2012	4.6500	1.6740	3.0000	1
129	9837	17	0	6	Q2	2012	7.7500	3.4100	5.0000	1
129	10098	7	0	9	Q3	2012	4.6500	2.0460	3.0000	1
130	3	15	1141	4	Q2	2012	4.4600	1.3826	2.0000	1
130	517	7	521	10	Q4	2012	6.6900	2.4753	3.0000	1
130	751	6	0	6	Q2	2012	8.9200	4.1032	4.0000	1
130	997	3	0	7	Q3	2012	8.9200	2.6760	4.0000	1
130	1216	17	0	11	Q4	2012	6.6900	2.1408	3.0000	1
130	1281	3	0	9	Q3	2012	8.9200	2.9436	4.0000	1
130	1304	13	0	11	Q4	2012	8.9200	2.8544	4.0000	1
130	1341	3	0	9	Q3	2012	4.4600	1.7840	2.0000	1
130	1545	15	0	9	Q3	2012	8.9200	3.0328	4.0000	1
130	1659	15	1152	9	Q3	2012	4.4600	1.6056	2.0000	1
130	1864	15	0	12	Q4	2012	6.6900	2.3415	3.0000	1
130	1916	13	0	12	Q4	2012	6.6900	2.5422	3.0000	1
130	2201	16	0	10	Q4	2012	6.6900	2.8098	3.0000	1
130	2234	13	0	3	Q1	2012	4.4600	2.0070	2.0000	1
130	2547	23	0	6	Q2	2012	6.6900	2.7429	3.0000	1
130	2905	3	0	5	Q2	2012	4.4600	2.0962	2.0000	1
130	2918	17	0	8	Q3	2012	8.9200	2.8544	4.0000	1
130	3173	11	0	1	Q1	2012	6.6900	2.1408	3.0000	1
130	3643	22	0	11	Q4	2012	4.4600	1.9178	2.0000	1
130	4503	13	0	11	Q4	2012	6.6900	3.2781	3.0000	1
130	4597	17	0	6	Q2	2012	6.6900	2.8767	3.0000	1
130	4629	13	0	8	Q3	2012	6.6900	2.0739	3.0000	1
130	4690	13	0	12	Q4	2012	6.6900	2.4084	3.0000	1
130	4739	15	0	12	Q4	2012	8.9200	3.1220	4.0000	1
130	4804	13	0	6	Q2	2012	6.6900	3.2781	3.0000	1
130	4824	3	0	6	Q2	2012	8.9200	2.6760	4.0000	1
130	4925	16	0	9	Q3	2012	6.6900	2.9436	3.0000	1
130	5070	13	0	10	Q4	2012	6.6900	3.0105	3.0000	1
130	5174	16	0	10	Q4	2012	6.6900	2.2746	3.0000	1
130	5419	17	0	5	Q2	2012	6.6900	3.3450	3.0000	1
130	5732	24	0	6	Q2	2012	6.6900	3.0774	3.0000	1
130	5766	16	1233	10	Q4	2012	6.6900	2.9436	3.0000	1
130	5923	23	1769	3	Q1	2012	6.6900	2.0070	3.0000	1
130	6082	13	0	3	Q1	2012	6.6900	2.4084	3.0000	1
130	6208	17	0	10	Q4	2012	6.6900	2.0739	3.0000	1
130	6816	11	0	8	Q3	2012	6.6900	2.7429	3.0000	1
130	6897	6	0	6	Q2	2012	4.4600	1.5610	2.0000	1
130	7072	16	1216	2	Q1	2012	8.9200	3.0328	4.0000	1
130	7275	17	0	9	Q3	2012	6.6900	3.0774	3.0000	1
130	7275	17	0	12	Q4	2012	4.4600	1.8732	2.0000	1
130	7416	13	988	7	Q3	2012	4.4600	1.4272	2.0000	1
130	7468	14	1072	9	Q3	2012	2.2300	0.9812	1.0000	1
130	7702	16	0	5	Q2	2012	6.6900	2.0739	3.0000	1
130	7862	16	0	6	Q2	2012	11.1500	3.4565	5.0000	1
130	8172	17	0	5	Q2	2012	8.9200	3.9248	4.0000	1
130	8202	3	0	12	Q4	2012	8.9200	3.7464	4.0000	1
130	8598	7	526	12	Q4	2012	11.1500	4.3485	5.0000	1
130	8658	6	0	8	Q3	2012	8.9200	4.0140	4.0000	1
130	9163	15	0	6	Q2	2012	4.4600	1.9624	2.0000	1
130	9169	23	0	11	Q4	2012	6.6900	2.1408	3.0000	1
130	9169	23	1765	1	Q1	2012	8.9200	3.2112	4.0000	1
130	10065	6	0	10	Q4	2012	6.6900	3.1443	3.0000	1
130	10091	17	0	3	Q1	2012	6.6900	2.1408	3.0000	1
130	10105	14	0	7	Q3	2012	2.2300	1.0258	1.0000	1
131	39	13	0	12	Q4	2012	9.6000	3.6480	4.0000	1
131	76	3	207	11	Q4	2012	7.2000	2.3760	3.0000	1
131	644	13	0	5	Q2	2012	7.2000	3.0240	3.0000	1
131	1071	13	980	3	Q1	2012	7.2000	3.3840	3.0000	1
131	1130	15	0	6	Q2	2012	9.6000	2.9760	4.0000	1
131	1166	13	1000	12	Q4	2012	7.2000	2.9520	3.0000	1
131	1289	23	0	3	Q1	2012	9.6000	3.3600	4.0000	1
131	1599	6	0	6	Q2	2012	9.6000	3.3600	4.0000	1
131	1818	11	0	3	Q1	2012	7.2000	3.0240	3.0000	1
131	2132	15	1136	2	Q1	2012	9.6000	4.0320	4.0000	1
131	2335	17	0	6	Q2	2012	4.8000	1.8240	2.0000	1
131	2376	11	0	9	Q3	2012	7.2000	2.2320	3.0000	1
131	2428	24	1858	7	Q3	2012	7.2000	3.3120	3.0000	1
131	2443	13	0	5	Q2	2012	9.6000	4.2240	4.0000	1
131	2507	3	0	5	Q2	2012	4.8000	2.2080	2.0000	1
131	2511	17	0	12	Q4	2012	7.2000	3.0240	3.0000	1
131	2548	13	0	1	Q1	2012	7.2000	2.8080	3.0000	1
131	2775	24	0	5	Q2	2012	7.2000	2.3760	3.0000	1
131	2869	6	522	10	Q4	2012	7.2000	3.6000	3.0000	1
131	2894	22	0	11	Q4	2012	7.2000	2.8800	3.0000	1
131	2965	2	0	12	Q4	2012	2.4000	1.1040	1.0000	1
131	3180	24	0	11	Q4	2012	12.0000	4.6800	5.0000	1
131	3197	23	0	8	Q3	2012	7.2000	3.3120	3.0000	1
131	3199	24	0	9	Q3	2012	7.2000	3.0960	3.0000	1
131	3389	7	505	2	Q1	2012	7.2000	2.9520	3.0000	1
131	3448	3	0	11	Q4	2012	7.2000	2.8080	3.0000	1
131	3499	13	0	1	Q1	2012	4.8000	1.6320	2.0000	1
131	3826	16	1216	2	Q1	2012	4.8000	1.8240	2.0000	1
131	3888	7	0	7	Q3	2012	7.2000	2.3760	3.0000	1
131	4396	13	0	2	Q1	2012	4.8000	1.5840	2.0000	1
131	4543	13	0	3	Q1	2012	7.2000	3.5280	3.0000	1
131	4642	15	0	4	Q2	2012	4.8000	1.6320	2.0000	1
131	5329	13	0	3	Q1	2012	7.2000	3.0960	3.0000	1
131	5612	15	0	6	Q2	2012	7.2000	2.9520	3.0000	1
131	5671	6	0	4	Q2	2012	12.0000	3.9600	5.0000	1
131	5802	6	0	9	Q3	2012	7.2000	2.9520	3.0000	1
131	6484	22	0	10	Q4	2012	2.4000	0.8880	1.0000	1
131	6529	17	0	1	Q1	2012	7.2000	2.6640	3.0000	1
131	6757	6	0	9	Q3	2012	7.2000	3.1680	3.0000	1
131	7269	13	0	7	Q3	2012	4.8000	1.5360	2.0000	1
131	7370	23	0	1	Q1	2012	9.6000	2.9760	4.0000	1
131	8235	22	0	9	Q3	2012	2.4000	1.1760	1.0000	1
131	8259	15	0	1	Q1	2012	4.8000	2.1120	2.0000	1
131	8270	6	0	11	Q4	2012	7.2000	2.8800	3.0000	1
131	8555	11	0	1	Q1	2012	4.8000	2.3520	2.0000	1
131	8587	22	0	3	Q1	2012	4.8000	1.6320	2.0000	1
131	8953	24	1853	5	Q2	2012	9.6000	4.7040	4.0000	1
131	8975	15	0	7	Q3	2012	7.2000	2.3040	3.0000	1
131	9068	6	0	1	Q1	2012	9.6000	3.5520	4.0000	1
131	9115	11	829	6	Q2	2012	4.8000	1.5360	2.0000	1
131	9127	24	0	9	Q3	2012	9.6000	3.1680	4.0000	1
131	9405	7	504	2	Q1	2012	7.2000	3.3840	3.0000	1
131	9791	15	0	6	Q2	2012	4.8000	2.0160	2.0000	1
131	9823	13	0	7	Q3	2012	9.6000	3.2640	4.0000	1
131	10186	13	0	8	Q3	2012	9.6000	4.7040	4.0000	1
132	250	11	0	12	Q4	2012	3.8400	1.1904	2.0000	1
132	485	15	1143	5	Q2	2012	3.8400	1.1520	2.0000	1
132	587	17	0	2	Q1	2012	5.7600	2.4192	3.0000	1
132	647	3	0	10	Q4	2012	3.8400	1.6128	2.0000	1
132	792	6	0	5	Q2	2012	7.6800	2.7648	4.0000	1
132	993	13	0	2	Q1	2012	5.7600	2.7648	3.0000	1
132	1071	13	0	5	Q2	2012	3.8400	1.8432	2.0000	1
132	1093	13	0	11	Q4	2012	3.8400	1.1520	2.0000	1
132	1551	3	202	8	Q3	2012	5.7600	2.1312	3.0000	1
132	1610	3	0	11	Q4	2012	3.8400	1.3824	2.0000	1
132	1633	3	0	5	Q2	2012	5.7600	2.4768	3.0000	1
132	1771	2	0	12	Q4	2012	3.8400	1.2288	2.0000	1
132	1802	23	1788	11	Q4	2012	5.7600	2.0736	3.0000	1
132	1890	24	0	10	Q4	2012	5.7600	2.2464	3.0000	1
132	2019	16	1214	2	Q1	2012	7.6800	3.7632	4.0000	1
132	2019	16	1233	10	Q4	2012	5.7600	1.7856	3.0000	1
132	2261	15	0	9	Q3	2012	7.6800	2.8416	4.0000	1
132	2570	16	0	9	Q3	2012	5.7600	2.1312	3.0000	1
132	2674	11	833	8	Q3	2012	5.7600	2.0160	3.0000	1
132	2724	24	0	11	Q4	2012	3.8400	1.1520	2.0000	1
132	3158	15	1140	4	Q2	2012	5.7600	2.5344	3.0000	1
132	3401	11	0	12	Q4	2012	5.7600	2.3040	3.0000	1
132	3427	24	0	1	Q1	2012	9.6000	3.8400	5.0000	1
132	3443	15	0	4	Q2	2012	7.6800	2.9184	4.0000	1
132	3585	7	504	2	Q1	2012	7.6800	2.4576	4.0000	1
132	3776	13	976	1	Q1	2012	5.7600	2.4192	3.0000	1
132	3782	24	1869	12	Q4	2012	3.8400	1.3824	2.0000	1
132	3944	14	0	3	Q1	2012	1.9200	0.8448	1.0000	1
132	4081	24	1866	11	Q4	2012	7.6800	3.7632	4.0000	1
132	4234	3	0	3	Q1	2012	7.6800	2.6112	4.0000	1
132	4417	3	0	9	Q3	2012	5.7600	2.0736	3.0000	1
132	4534	7	0	10	Q4	2012	7.6800	2.8416	4.0000	1
132	4567	23	0	8	Q3	2012	7.6800	2.4576	4.0000	1
132	4606	3	0	9	Q3	2012	3.8400	1.2288	2.0000	1
132	4626	7	0	12	Q4	2012	7.6800	3.1488	4.0000	1
132	4709	22	1694	4	Q2	2012	3.8400	1.4592	2.0000	1
132	4813	7	0	1	Q1	2012	3.8400	1.4208	2.0000	1
132	4925	16	0	4	Q2	2012	5.7600	2.5344	3.0000	1
132	4973	17	0	12	Q4	2012	3.8400	1.4592	2.0000	1
132	5245	11	0	7	Q3	2012	3.8400	1.7664	2.0000	1
132	5278	11	0	12	Q4	2012	7.6800	2.4576	4.0000	1
132	5302	11	0	3	Q1	2012	5.7600	1.8432	3.0000	1
132	5408	6	0	8	Q3	2012	3.8400	1.8048	2.0000	1
132	5738	3	0	7	Q3	2012	5.7600	2.1888	3.0000	1
132	5901	24	1845	1	Q1	2012	5.7600	2.6496	3.0000	1
132	6018	11	0	5	Q2	2012	5.7600	2.7648	3.0000	1
132	6105	23	0	4	Q2	2012	5.7600	2.1888	3.0000	1
132	6145	15	0	5	Q2	2012	7.6800	3.1488	4.0000	1
132	6208	17	0	11	Q4	2012	5.7600	1.7856	3.0000	1
132	6265	23	0	1	Q1	2012	7.6800	3.8400	4.0000	1
132	6352	13	0	2	Q1	2012	7.6800	3.2256	4.0000	1
132	6537	7	0	3	Q1	2012	7.6800	3.3792	4.0000	1
132	6559	3	190	3	Q1	2012	3.8400	1.4976	2.0000	1
132	6609	7	516	8	Q3	2012	5.7600	2.6496	3.0000	1
132	6736	17	0	7	Q3	2012	5.7600	1.7280	3.0000	1
132	7012	6	518	8	Q3	2012	3.8400	1.4592	2.0000	1
132	7065	17	0	12	Q4	2012	7.6800	3.4560	4.0000	1
132	7502	16	1236	12	Q4	2012	5.7600	2.7072	3.0000	1
132	7529	17	0	8	Q3	2012	5.7600	2.3616	3.0000	1
132	7879	15	0	9	Q3	2012	9.6000	3.9360	5.0000	1
132	8026	22	1698	6	Q2	2012	1.9200	0.7872	1.0000	1
132	8122	11	0	6	Q2	2012	3.8400	1.6896	2.0000	1
132	8288	7	0	8	Q3	2012	5.7600	2.7648	3.0000	1
132	8635	7	0	9	Q3	2012	5.7600	1.8432	3.0000	1
132	8814	13	0	1	Q1	2012	7.6800	3.2256	4.0000	1
132	9162	13	0	7	Q3	2012	3.8400	1.2288	2.0000	1
132	9184	3	0	4	Q2	2012	5.7600	2.4192	3.0000	1
132	9194	17	0	6	Q2	2012	11.5200	4.7232	6.0000	1
132	9533	24	0	6	Q2	2012	7.6800	2.4576	4.0000	1
132	9719	11	820	2	Q1	2012	5.7600	1.9584	3.0000	1
132	10091	17	0	9	Q3	2012	3.8400	1.9200	2.0000	1
132	10249	7	0	10	Q4	2012	7.6800	3.3024	4.0000	1
133	521	11	0	6	Q2	2012	2.1000	0.7980	3.0000	1
133	619	13	0	8	Q3	2012	2.8000	0.8680	4.0000	1
133	874	6	0	4	Q2	2012	2.1000	0.7770	3.0000	1
133	1297	16	0	1	Q1	2012	2.8000	1.2880	4.0000	1
133	1415	16	0	1	Q1	2012	2.8000	1.1200	4.0000	1
133	1415	16	0	11	Q4	2012	2.1000	1.0290	3.0000	1
133	1798	3	0	8	Q3	2012	2.1000	0.7350	3.0000	1
133	1940	13	0	11	Q4	2012	2.1000	0.7140	3.0000	1
133	2039	11	821	3	Q1	2012	2.8000	1.3720	4.0000	1
133	2277	6	523	11	Q4	2012	2.1000	0.7560	3.0000	1
133	2468	13	0	3	Q1	2012	2.8000	0.8960	4.0000	1
133	2570	16	0	12	Q4	2012	2.1000	0.8400	3.0000	1
133	2612	24	0	5	Q2	2012	1.4000	0.5880	2.0000	1
133	2663	16	0	8	Q3	2012	2.8000	1.2880	4.0000	1
133	2787	17	1311	10	Q4	2012	2.8000	0.8400	4.0000	1
133	3328	17	0	5	Q2	2012	2.8000	0.8960	4.0000	1
133	3533	3	0	1	Q1	2012	2.1000	0.6510	3.0000	1
133	3794	24	0	3	Q1	2012	2.1000	0.9030	3.0000	1
133	4142	6	526	12	Q4	2012	2.8000	1.4000	4.0000	1
133	4268	11	820	2	Q1	2012	2.1000	0.9870	3.0000	1
133	4330	13	0	9	Q3	2012	2.1000	0.8190	3.0000	1
133	4342	13	0	7	Q3	2012	2.8000	1.0360	4.0000	1
133	4369	15	0	11	Q4	2012	2.1000	0.9870	3.0000	1
133	4606	3	0	2	Q1	2012	2.1000	0.6510	3.0000	1
133	4774	11	0	10	Q4	2012	1.4000	0.4760	2.0000	1
133	5067	17	0	7	Q3	2012	1.4000	0.6860	2.0000	1
133	5096	7	0	11	Q4	2012	2.1000	1.0080	3.0000	1
133	5174	16	1216	2	Q1	2012	2.1000	0.9030	3.0000	1
133	5295	16	0	5	Q2	2012	2.8000	0.8400	4.0000	1
133	5723	15	0	4	Q2	2012	2.8000	0.9240	4.0000	1
133	5790	17	0	12	Q4	2012	1.4000	0.5180	2.0000	1
133	5991	3	0	3	Q1	2012	2.8000	1.0640	4.0000	1
133	6208	17	0	12	Q4	2012	1.4000	0.6300	2.0000	1
133	6289	6	513	6	Q2	2012	1.4000	0.5040	2.0000	1
133	6367	3	0	1	Q1	2012	1.4000	0.5040	2.0000	1
133	6655	11	820	2	Q1	2012	2.1000	0.9240	3.0000	1
133	7051	16	0	6	Q2	2012	2.8000	1.1480	4.0000	1
133	7130	24	0	10	Q4	2012	2.1000	0.7350	3.0000	1
133	7139	7	0	10	Q4	2012	3.5000	1.7500	5.0000	1
133	7556	17	0	7	Q3	2012	2.8000	1.3440	4.0000	1
133	7558	13	984	5	Q2	2012	2.1000	0.9450	3.0000	1
133	7657	11	821	2	Q1	2012	2.8000	1.1760	4.0000	1
133	7797	15	0	6	Q2	2012	2.1000	0.7560	3.0000	1
133	7804	14	0	10	Q4	2012	1.4000	0.6160	2.0000	1
133	7835	13	0	1	Q1	2012	2.8000	0.9520	4.0000	1
133	8463	23	0	5	Q2	2012	2.8000	0.9520	4.0000	1
133	8608	24	0	6	Q2	2012	2.8000	1.0360	4.0000	1
133	8687	23	1778	7	Q3	2012	1.4000	0.5180	2.0000	1
133	8734	7	0	5	Q2	2012	2.8000	1.0920	4.0000	1
133	8970	22	0	11	Q4	2012	1.4000	0.5180	2.0000	1
133	9144	13	1000	12	Q4	2012	2.1000	1.0080	3.0000	1
133	9440	24	0	5	Q2	2012	2.1000	0.7560	3.0000	1
133	9552	7	517	8	Q3	2012	1.4000	0.5600	2.0000	1
133	9757	24	1869	12	Q4	2012	2.1000	0.6720	3.0000	1
133	10058	15	0	7	Q3	2012	2.1000	0.7980	3.0000	1
133	10140	17	1294	2	Q1	2012	2.1000	0.7560	3.0000	1
134	795	14	1078	12	Q4	2012	4.8600	1.7496	2.0000	1
134	891	7	0	8	Q3	2012	4.8600	1.8468	2.0000	1
134	1071	13	0	3	Q1	2012	4.8600	2.4300	2.0000	1
134	1094	15	0	4	Q2	2012	9.7200	4.2768	4.0000	1
134	1137	6	0	12	Q4	2012	7.2900	2.4057	3.0000	1
134	1874	17	0	5	Q2	2012	4.8600	2.0412	2.0000	1
134	1914	24	1860	8	Q3	2012	7.2900	3.2076	3.0000	1
134	1934	2	0	10	Q4	2012	4.8600	1.5066	2.0000	1
134	2558	7	0	5	Q2	2012	7.2900	3.2805	3.0000	1
134	3231	17	0	2	Q1	2012	4.8600	2.1384	2.0000	1
134	3373	15	0	2	Q1	2012	7.2900	2.9160	3.0000	1
134	3647	13	980	3	Q1	2012	7.2900	3.1347	3.0000	1
134	3825	22	1689	2	Q1	2012	7.2900	2.5515	3.0000	1
134	3831	7	0	11	Q4	2012	4.8600	1.8468	2.0000	1
134	3840	15	0	3	Q1	2012	9.7200	3.0132	4.0000	1
134	4094	16	0	6	Q2	2012	7.2900	3.4992	3.0000	1
134	4096	3	0	2	Q1	2012	7.2900	3.0618	3.0000	1
134	4118	17	0	8	Q3	2012	9.7200	4.7628	4.0000	1
134	4413	13	988	7	Q3	2012	9.7200	4.0824	4.0000	1
134	4461	11	833	8	Q3	2012	9.7200	4.2768	4.0000	1
134	4606	3	0	8	Q3	2012	4.8600	1.7982	2.0000	1
134	4938	13	0	2	Q1	2012	7.2900	3.5721	3.0000	1
134	5067	17	0	11	Q4	2012	9.7200	3.5964	4.0000	1
134	5162	22	0	10	Q4	2012	7.2900	3.3534	3.0000	1
134	5201	6	0	6	Q2	2012	9.7200	4.4712	4.0000	1
134	5387	7	0	4	Q2	2012	4.8600	2.2842	2.0000	1
134	5590	17	0	4	Q2	2012	9.7200	4.8600	4.0000	1
134	5742	16	0	8	Q3	2012	9.7200	3.5964	4.0000	1
134	5813	3	0	6	Q2	2012	9.7200	3.4992	4.0000	1
134	5831	3	0	11	Q4	2012	7.2900	3.4263	3.0000	1
134	6353	24	1856	6	Q2	2012	4.8600	1.9440	2.0000	1
134	7331	11	0	2	Q1	2012	9.7200	3.2076	4.0000	1
134	7529	17	0	3	Q1	2012	9.7200	3.5964	4.0000	1
134	8275	16	0	9	Q3	2012	7.2900	2.6973	3.0000	1
134	8787	7	0	10	Q4	2012	7.2900	3.2805	3.0000	1
134	9105	24	1856	6	Q2	2012	7.2900	3.3534	3.0000	1
134	9324	3	195	5	Q2	2012	9.7200	3.4992	4.0000	1
134	9578	13	0	12	Q4	2012	9.7200	4.3740	4.0000	1
134	9598	6	0	9	Q3	2012	7.2900	2.5515	3.0000	1
134	9631	16	0	8	Q3	2012	12.1500	5.2245	5.0000	1
134	9698	23	0	2	Q1	2012	12.1500	4.7385	5.0000	1
134	10033	3	0	4	Q2	2012	9.7200	3.5964	4.0000	1
135	181	3	202	8	Q3	2012	15.5600	5.1348	4.0000	1
135	208	13	0	11	Q4	2012	15.5600	6.2240	4.0000	1
135	216	17	1304	7	Q3	2012	15.5600	5.7572	4.0000	1
135	570	15	0	4	Q2	2012	7.7800	2.3340	2.0000	1
135	619	13	0	9	Q3	2012	15.5600	4.6680	4.0000	1
135	849	6	0	8	Q3	2012	11.6700	4.2012	3.0000	1
135	1771	2	0	12	Q4	2012	3.8900	1.7116	1.0000	1
135	2075	13	0	9	Q3	2012	11.6700	3.7344	3.0000	1
135	2171	23	1789	12	Q4	2012	11.6700	3.5010	3.0000	1
135	2468	13	976	1	Q1	2012	15.5600	6.8464	4.0000	1
135	2731	7	0	10	Q4	2012	15.5600	5.2904	4.0000	1
135	2787	17	0	3	Q1	2012	7.7800	2.8008	2.0000	1
135	2896	3	0	3	Q1	2012	11.6700	5.3682	3.0000	1
135	3768	7	0	6	Q2	2012	11.6700	3.8511	3.0000	1
135	3828	24	0	4	Q2	2012	15.5600	6.6908	4.0000	1
135	4082	24	0	6	Q2	2012	15.5600	5.7572	4.0000	1
135	4169	6	0	8	Q3	2012	7.7800	3.1898	2.0000	1
135	4544	7	501	1	Q1	2012	11.6700	4.6680	3.0000	1
135	4664	7	516	8	Q3	2012	7.7800	3.5010	2.0000	1
135	5018	7	0	4	Q2	2012	15.5600	6.2240	4.0000	1
135	5063	3	0	4	Q2	2012	15.5600	7.3132	4.0000	1
135	5376	3	0	3	Q1	2012	15.5600	6.6908	4.0000	1
135	5414	24	0	3	Q1	2012	15.5600	5.9128	4.0000	1
135	5432	16	1228	8	Q3	2012	15.5600	6.3796	4.0000	1
135	5547	7	0	6	Q2	2012	7.7800	3.0342	2.0000	1
135	5782	13	0	12	Q4	2012	7.7800	2.7230	2.0000	1
135	6367	3	0	1	Q1	2012	11.6700	5.1348	3.0000	1
135	6529	17	1307	8	Q3	2012	7.7800	3.5010	2.0000	1
135	7100	17	0	12	Q4	2012	11.6700	4.9014	3.0000	1
135	7569	13	0	3	Q1	2012	15.5600	6.3796	4.0000	1
135	7606	11	829	6	Q2	2012	15.5600	4.8236	4.0000	1
135	7849	3	0	1	Q1	2012	15.5600	4.8236	4.0000	1
135	7989	17	0	1	Q1	2012	11.6700	5.0181	3.0000	1
135	8270	6	0	11	Q4	2012	11.6700	3.8511	3.0000	1
135	8374	3	0	12	Q4	2012	7.7800	2.8008	2.0000	1
135	8463	23	1768	2	Q1	2012	11.6700	4.4346	3.0000	1
135	8509	24	0	8	Q3	2012	7.7800	2.4118	2.0000	1
135	9019	7	523	11	Q4	2012	19.4500	7.1965	5.0000	1
135	9487	17	0	12	Q4	2012	15.5600	7.1576	4.0000	1
135	9760	13	980	3	Q1	2012	7.7800	3.2676	2.0000	1
135	9797	16	0	9	Q3	2012	11.6700	5.3682	3.0000	1
135	9892	13	0	7	Q3	2012	15.5600	7.4688	4.0000	1
135	10131	17	0	11	Q4	2012	11.6700	4.5513	3.0000	1
135	10167	17	0	9	Q3	2012	11.6700	4.3179	3.0000	1
135	10173	16	0	3	Q1	2012	15.5600	6.8464	4.0000	1
136	378	16	1216	2	Q1	2012	7.7400	2.7090	2.0000	1
136	644	13	0	9	Q3	2012	11.6100	4.2957	3.0000	1
136	1058	7	504	2	Q1	2012	15.4800	7.1208	4.0000	1
136	1245	17	1312	10	Q4	2012	11.6100	5.3406	3.0000	1
136	1341	3	0	10	Q4	2012	15.4800	6.1920	4.0000	1
136	1373	7	0	1	Q1	2012	11.6100	3.7152	3.0000	1
136	1633	3	0	2	Q1	2012	15.4800	6.1920	4.0000	1
136	1785	3	0	2	Q1	2012	11.6100	4.9923	3.0000	1
136	2019	16	1214	2	Q1	2012	11.6100	3.5991	3.0000	1
136	2261	15	0	9	Q3	2012	11.6100	4.5279	3.0000	1
136	2265	24	0	1	Q1	2012	15.4800	5.7276	4.0000	1
136	2279	15	0	2	Q1	2012	7.7400	3.4830	2.0000	1
136	2493	17	0	3	Q1	2012	7.7400	2.9412	2.0000	1
136	2506	15	0	9	Q3	2012	11.6100	4.1796	3.0000	1
136	2625	13	0	2	Q1	2012	11.6100	4.9923	3.0000	1
136	2846	11	0	12	Q4	2012	7.7400	2.9412	2.0000	1
136	2981	23	0	9	Q3	2012	11.6100	3.9474	3.0000	1
136	3009	7	518	8	Q3	2012	7.7400	2.7864	2.0000	1
136	3201	11	829	6	Q2	2012	15.4800	6.3468	4.0000	1
136	3320	24	0	8	Q3	2012	11.6100	5.3406	3.0000	1
136	3796	11	0	1	Q1	2012	11.6100	5.2245	3.0000	1
136	4451	7	0	5	Q2	2012	11.6100	4.0635	3.0000	1
136	4548	6	0	11	Q4	2012	7.7400	3.2508	2.0000	1
136	4567	23	1776	6	Q2	2012	15.4800	4.9536	4.0000	1
136	4595	11	0	5	Q2	2012	15.4800	5.5728	4.0000	1
136	4615	17	1314	11	Q4	2012	11.6100	4.2957	3.0000	1
136	5067	17	1307	8	Q3	2012	11.6100	5.6889	3.0000	1
136	5256	17	0	3	Q1	2012	11.6100	4.2957	3.0000	1
136	5542	16	0	10	Q4	2012	11.6100	5.4567	3.0000	1
136	6347	17	1293	1	Q1	2012	11.6100	3.5991	3.0000	1
136	6574	13	0	7	Q3	2012	15.4800	5.7276	4.0000	1
136	7149	13	0	2	Q1	2012	11.6100	3.9474	3.0000	1
136	7366	3	0	2	Q1	2012	11.6100	4.7601	3.0000	1
136	7618	11	0	9	Q3	2012	7.7400	2.8638	2.0000	1
136	7721	13	0	7	Q3	2012	15.4800	6.1920	4.0000	1
136	8084	22	0	12	Q4	2012	7.7400	3.2508	2.0000	1
136	8141	22	0	10	Q4	2012	3.8700	1.1997	1.0000	1
136	8275	16	0	4	Q2	2012	11.6100	4.5279	3.0000	1
136	8409	24	0	7	Q3	2012	7.7400	2.9412	2.0000	1
136	8749	13	0	9	Q3	2012	15.4800	7.4304	4.0000	1
136	9014	13	0	1	Q1	2012	7.7400	3.8700	2.0000	1
136	9184	3	0	4	Q2	2012	15.4800	4.7988	4.0000	1
136	9470	7	0	3	Q1	2012	15.4800	5.5728	4.0000	1
136	9571	11	0	12	Q4	2012	11.6100	5.5728	3.0000	1
136	10068	23	0	11	Q4	2012	11.6100	5.4567	3.0000	1
136	10167	17	0	10	Q4	2012	11.6100	4.0635	3.0000	1
137	178	13	0	6	Q2	2012	11.1000	4.4400	3.0000	1
137	235	11	837	10	Q4	2012	14.8000	5.3280	4.0000	1
137	329	7	0	5	Q2	2012	14.8000	6.6600	4.0000	1
137	602	17	0	7	Q3	2012	7.4000	2.3680	2.0000	1
137	647	3	202	8	Q3	2012	11.1000	4.4400	3.0000	1
137	994	13	0	9	Q3	2012	7.4000	3.7000	2.0000	1
137	1724	7	0	11	Q4	2012	11.1000	4.2180	3.0000	1
137	2658	7	517	8	Q3	2012	14.8000	6.6600	4.0000	1
137	2850	3	0	12	Q4	2012	7.4000	3.5520	2.0000	1
137	2921	16	0	3	Q1	2012	22.2000	8.2880	6.0000	2
137	2981	23	1772	4	Q2	2012	7.4000	2.3680	2.0000	1
137	3012	24	0	2	Q1	2012	11.1000	5.2170	3.0000	1
137	3547	11	0	1	Q1	2012	11.1000	5.1060	3.0000	1
137	3702	7	0	12	Q4	2012	11.1000	3.8850	3.0000	1
137	4000	15	0	9	Q3	2012	11.1000	5.1060	3.0000	1
137	4188	7	0	9	Q3	2012	11.1000	4.4400	3.0000	1
137	4219	11	0	1	Q1	2012	14.8000	5.3280	4.0000	1
137	4239	17	1292	1	Q1	2012	11.1000	4.7730	3.0000	1
137	4249	11	0	6	Q2	2012	14.8000	7.2520	4.0000	1
137	4527	3	0	3	Q1	2012	11.1000	4.7730	3.0000	1
137	4663	7	0	11	Q4	2012	14.8000	5.0320	4.0000	1
137	4727	16	0	6	Q2	2012	11.1000	3.4410	3.0000	1
137	4864	24	1845	1	Q1	2012	11.1000	4.8840	3.0000	1
137	4867	24	0	3	Q1	2012	7.4000	2.3680	2.0000	1
137	4958	23	1783	9	Q3	2012	11.1000	4.5510	3.0000	1
137	4988	2	126	10	Q4	2012	3.7000	1.4430	1.0000	1
137	5068	22	0	9	Q3	2012	11.1000	3.4410	3.0000	1
137	5322	7	514	7	Q3	2012	14.8000	7.1040	4.0000	1
137	5644	17	0	4	Q2	2012	11.1000	4.7730	3.0000	1
137	5733	11	0	12	Q4	2012	11.1000	4.7730	3.0000	1
137	5924	13	0	5	Q2	2012	11.1000	3.5520	3.0000	1
137	5943	2	0	11	Q4	2012	7.4000	2.8860	2.0000	1
137	5944	3	0	12	Q4	2012	11.1000	5.2170	3.0000	1
137	6092	24	0	9	Q3	2012	11.1000	5.1060	3.0000	1
137	6113	16	1225	7	Q3	2012	11.1000	5.4390	3.0000	1
137	6347	17	0	9	Q3	2012	7.4000	3.3300	2.0000	1
137	6499	17	0	9	Q3	2012	7.4000	2.2940	2.0000	1
137	6542	7	0	3	Q1	2012	11.1000	4.5510	3.0000	1
137	6899	7	0	5	Q2	2012	11.1000	4.5510	3.0000	1
137	7100	17	0	10	Q4	2012	7.4000	3.5520	2.0000	1
137	7112	24	0	11	Q4	2012	7.4000	2.7380	2.0000	1
137	7117	15	0	6	Q2	2012	11.1000	4.3290	3.0000	1
137	7363	6	0	8	Q3	2012	7.4000	2.8120	2.0000	1
137	7434	11	0	4	Q2	2012	14.8000	5.6240	4.0000	1
137	7589	17	0	3	Q1	2012	11.1000	5.3280	3.0000	1
137	7733	13	0	1	Q1	2012	14.8000	5.4760	4.0000	1
137	8151	7	523	11	Q4	2012	7.4000	3.4780	2.0000	1
137	8199	17	1314	11	Q4	2012	11.1000	5.1060	3.0000	1
137	8202	3	187	2	Q1	2012	14.8000	6.2160	4.0000	1
137	8283	17	1304	7	Q3	2012	11.1000	4.5510	3.0000	1
137	8289	17	0	12	Q4	2012	14.8000	7.2520	4.0000	1
137	8466	17	1314	11	Q4	2012	7.4000	3.4040	2.0000	1
137	8483	15	0	7	Q3	2012	11.1000	4.3290	3.0000	1
137	8844	13	0	3	Q1	2012	11.1000	4.9950	3.0000	1
137	8968	11	0	8	Q3	2012	7.4000	2.5160	2.0000	1
137	9095	7	0	12	Q4	2012	11.1000	5.3280	3.0000	1
137	9309	17	0	1	Q1	2012	14.8000	7.2520	4.0000	1
137	9309	17	0	7	Q3	2012	11.1000	4.6620	3.0000	1
137	9795	11	841	12	Q4	2012	11.1000	4.7730	3.0000	1
137	9797	16	0	6	Q2	2012	7.4000	2.3680	2.0000	1
137	10167	17	0	1	Q1	2012	11.1000	3.8850	3.0000	1
137	10255	2	0	6	Q2	2012	3.7000	1.7760	1.0000	1
138	120	11	0	5	Q2	2012	10.8000	3.9960	4.0000	1
138	178	13	0	5	Q2	2012	8.1000	3.8880	3.0000	1
138	373	13	0	11	Q4	2012	8.1000	3.9690	3.0000	1
138	378	16	0	3	Q1	2012	5.4000	2.3760	2.0000	1
138	477	15	1138	3	Q1	2012	5.4000	1.7280	2.0000	1
138	638	11	0	2	Q1	2012	5.4000	2.2140	2.0000	1
138	1528	16	0	10	Q4	2012	8.1000	2.9970	3.0000	1
138	1676	3	0	3	Q1	2012	8.1000	3.9690	3.0000	1
138	1738	7	0	4	Q2	2012	5.4000	2.1600	2.0000	1
138	1977	23	0	6	Q2	2012	5.4000	2.5920	2.0000	1
138	2245	11	0	4	Q2	2012	10.8000	4.5360	4.0000	1
138	2246	13	0	1	Q1	2012	8.1000	2.5110	3.0000	1
138	2511	17	0	12	Q4	2012	8.1000	3.1590	3.0000	1
138	2553	16	0	1	Q1	2012	8.1000	3.2400	3.0000	1
138	2563	15	0	2	Q1	2012	10.8000	4.5360	4.0000	1
138	2751	7	516	8	Q3	2012	8.1000	2.5920	3.0000	1
138	2767	11	0	4	Q2	2012	5.4000	1.9980	2.0000	1
138	2848	7	0	6	Q2	2012	10.8000	3.4560	4.0000	1
138	2921	16	0	1	Q1	2012	8.1000	2.9970	3.0000	1
138	3065	3	207	11	Q4	2012	5.4000	1.7280	2.0000	1
138	3687	24	0	12	Q4	2012	10.8000	3.6720	4.0000	1
138	3792	7	0	4	Q2	2012	5.4000	1.8360	2.0000	1
138	4165	3	0	3	Q1	2012	8.1000	3.5640	3.0000	1
138	4204	17	1312	10	Q4	2012	10.8000	4.3200	4.0000	1
138	4606	3	0	2	Q1	2012	8.1000	2.5110	3.0000	1
138	5080	15	1150	8	Q3	2012	8.1000	2.5920	3.0000	1
138	5130	11	0	4	Q2	2012	5.4000	1.9980	2.0000	1
138	5257	13	982	4	Q2	2012	8.1000	2.5920	3.0000	1
138	5308	6	0	4	Q2	2012	5.4000	1.6200	2.0000	1
138	5345	7	0	8	Q3	2012	10.8000	4.3200	4.0000	1
138	5433	13	980	3	Q1	2012	8.1000	3.6450	3.0000	1
138	5592	16	0	8	Q3	2012	8.1000	2.8350	3.0000	1
138	5738	3	0	7	Q3	2012	10.8000	3.9960	4.0000	1
138	5766	16	0	1	Q1	2012	10.8000	4.4280	4.0000	1
138	5827	11	826	5	Q2	2012	8.1000	3.8070	3.0000	1
138	6184	6	0	9	Q3	2012	13.5000	4.5900	5.0000	1
138	6186	15	0	5	Q2	2012	5.4000	1.9980	2.0000	1
138	6206	11	0	1	Q1	2012	10.8000	3.6720	4.0000	1
138	6596	24	0	5	Q2	2012	5.4000	2.3760	2.0000	1
138	7036	7	0	11	Q4	2012	8.1000	3.4020	3.0000	1
138	7132	13	0	11	Q4	2012	8.1000	4.0500	3.0000	1
138	7132	13	988	7	Q3	2012	10.8000	4.6440	4.0000	1
138	7149	13	0	9	Q3	2012	8.1000	2.4300	3.0000	1
138	7354	3	201	8	Q3	2012	10.8000	4.2120	4.0000	1
138	7502	16	1231	9	Q3	2012	8.1000	3.1590	3.0000	1
138	7522	13	0	12	Q4	2012	10.8000	4.7520	4.0000	1
138	7611	7	0	6	Q2	2012	10.8000	5.2920	4.0000	1
138	7791	15	1140	4	Q2	2012	10.8000	5.1840	4.0000	1
138	7806	13	0	7	Q3	2012	8.1000	2.9160	3.0000	1
138	7809	2	0	5	Q2	2012	2.7000	0.9720	1.0000	1
138	7905	13	0	11	Q4	2012	10.8000	3.7800	4.0000	1
138	8054	15	1134	1	Q1	2012	8.1000	2.5110	3.0000	1
138	8289	17	0	7	Q3	2012	10.8000	5.0760	4.0000	1
138	8351	16	1216	2	Q1	2012	10.8000	4.9680	4.0000	1
138	8518	24	1850	3	Q1	2012	8.1000	2.7540	3.0000	1
138	9029	3	0	5	Q2	2012	5.4000	1.9980	2.0000	1
138	9441	14	0	2	Q1	2012	5.4000	2.3220	2.0000	1
138	9498	23	0	7	Q3	2012	5.4000	2.7000	2.0000	1
138	9527	7	0	9	Q3	2012	5.4000	2.5920	2.0000	1
138	9531	15	0	10	Q4	2012	5.4000	2.3760	2.0000	1
138	9897	16	0	1	Q1	2012	8.1000	3.3210	3.0000	1
138	9929	13	0	11	Q4	2012	10.8000	3.5640	4.0000	1
138	10140	17	1293	1	Q1	2012	5.4000	2.0520	2.0000	1
138	10249	7	0	3	Q1	2012	10.8000	5.2920	4.0000	1
139	573	11	829	6	Q2	2012	5.3700	1.7721	3.0000	1
139	878	3	0	6	Q2	2012	5.3700	1.6110	3.0000	1
139	924	3	0	9	Q3	2012	7.1600	3.3652	4.0000	1
139	1289	23	0	9	Q3	2012	5.3700	2.1480	3.0000	1
139	1567	16	0	3	Q1	2012	5.3700	1.8795	3.0000	1
139	1666	6	0	11	Q4	2012	3.5800	1.7542	2.0000	1
139	2242	7	0	10	Q4	2012	7.1600	2.6492	4.0000	1
139	2244	17	0	8	Q3	2012	7.1600	2.9356	4.0000	1
139	2246	13	0	9	Q3	2012	5.3700	2.6313	3.0000	1
139	2285	24	0	4	Q2	2012	7.1600	3.2936	4.0000	1
139	2398	13	984	5	Q2	2012	5.3700	2.3091	3.0000	1
139	2441	17	0	3	Q1	2012	5.3700	2.4702	3.0000	1
139	2488	24	1859	8	Q3	2012	8.9500	3.3115	5.0000	1
139	2712	6	521	10	Q4	2012	5.3700	2.3628	3.0000	1
139	3558	24	0	4	Q2	2012	7.1600	3.5084	4.0000	1
139	3576	15	0	9	Q3	2012	7.1600	2.7208	4.0000	1
139	4029	17	0	9	Q3	2012	5.3700	1.8795	3.0000	1
139	4340	17	0	3	Q1	2012	7.1600	2.1480	4.0000	1
139	4410	13	986	6	Q2	2012	5.3700	2.4702	3.0000	1
139	4468	11	0	1	Q1	2012	5.3700	2.5239	3.0000	1
139	4527	3	210	12	Q4	2012	7.1600	2.5060	4.0000	1
139	4846	17	0	4	Q2	2012	3.5800	1.3604	2.0000	1
139	5433	13	0	9	Q3	2012	3.5800	1.6110	2.0000	1
139	5685	13	0	7	Q3	2012	5.3700	2.4165	3.0000	1
139	5877	17	1307	8	Q3	2012	5.3700	2.6313	3.0000	1
139	6201	15	0	12	Q4	2012	3.5800	1.3246	2.0000	1
139	6218	11	837	10	Q4	2012	5.3700	2.5776	3.0000	1
139	6321	14	1058	2	Q1	2012	1.7900	0.7160	1.0000	1
139	6589	17	0	12	Q4	2012	5.3700	1.9869	3.0000	1
139	6733	13	0	3	Q1	2012	5.3700	1.9332	3.0000	1
139	6788	7	0	10	Q4	2012	5.3700	2.3628	3.0000	1
139	7051	16	0	6	Q2	2012	5.3700	1.6647	3.0000	1
139	7085	11	0	8	Q3	2012	3.5800	1.2530	2.0000	1
139	7149	13	0	2	Q1	2012	5.3700	1.6110	3.0000	1
139	7203	13	0	2	Q1	2012	5.3700	2.2017	3.0000	1
139	7355	13	0	1	Q1	2012	5.3700	1.8795	3.0000	1
139	7775	7	0	1	Q1	2012	5.3700	2.4702	3.0000	1
139	7865	22	0	11	Q4	2012	3.5800	1.1456	2.0000	1
139	7897	15	0	10	Q4	2012	7.1600	2.1480	4.0000	1
139	8108	17	1297	3	Q1	2012	3.5800	1.0740	2.0000	1
139	8290	15	0	11	Q4	2012	3.5800	1.7900	2.0000	1
139	8307	14	0	4	Q2	2012	1.7900	0.7160	1.0000	1
139	8373	13	0	8	Q3	2012	3.5800	1.1456	2.0000	1
139	8374	3	0	2	Q1	2012	3.5800	1.3246	2.0000	1
139	8921	13	1000	12	Q4	2012	7.1600	2.6492	4.0000	1
139	9134	23	0	8	Q3	2012	7.1600	2.2196	4.0000	1
139	9170	7	0	1	Q1	2012	5.3700	2.5776	3.0000	1
139	9581	24	1853	5	Q2	2012	7.1600	2.9356	4.0000	1
139	9617	2	118	6	Q2	2012	1.7900	0.7697	1.0000	1
139	9703	24	0	10	Q4	2012	7.1600	2.6492	4.0000	1
139	9892	13	0	7	Q3	2012	5.3700	1.6647	3.0000	1
139	9972	13	0	7	Q3	2012	3.5800	1.3604	2.0000	1
139	9976	17	0	9	Q3	2012	5.3700	2.5239	3.0000	1
139	10026	13	0	2	Q1	2012	7.1600	3.4368	4.0000	1
139	10106	13	0	7	Q3	2012	8.9500	3.3115	5.0000	1
139	10168	15	1134	1	Q1	2012	7.1600	3.2936	4.0000	1
139	10176	13	0	8	Q3	2012	5.3700	2.0406	3.0000	1
139	10222	6	524	11	Q4	2012	3.5800	1.5752	2.0000	1
139	10255	2	0	5	Q2	2012	1.7900	0.7697	1.0000	1
140	426	15	0	6	Q2	2012	7.2800	2.6936	4.0000	1
140	456	15	1149	8	Q3	2012	3.6400	1.7472	2.0000	1
140	487	7	0	7	Q3	2012	7.2800	2.4024	4.0000	1
140	529	24	0	5	Q2	2012	5.4600	2.2386	3.0000	1
140	673	11	0	11	Q4	2012	5.4600	2.1294	3.0000	1
140	709	6	0	1	Q1	2012	7.2800	2.6936	4.0000	1
140	823	24	0	4	Q2	2012	5.4600	2.3478	3.0000	1
140	878	3	0	1	Q1	2012	5.4600	2.1840	3.0000	1
140	1360	13	0	2	Q1	2012	3.6400	1.6744	2.0000	1
140	1565	24	1847	2	Q1	2012	3.6400	1.1648	2.0000	1
140	1829	11	836	9	Q3	2012	3.6400	1.6744	2.0000	1
140	1979	3	0	12	Q4	2012	7.2800	2.9848	4.0000	1
140	2224	16	1235	11	Q4	2012	5.4600	2.2386	3.0000	1
140	2639	15	0	9	Q3	2012	7.2800	3.0576	4.0000	1
140	2829	23	0	10	Q4	2012	7.2800	3.4216	4.0000	1
140	2918	17	0	7	Q3	2012	5.4600	2.0748	3.0000	1
140	3130	13	0	7	Q3	2012	3.6400	1.7108	2.0000	1
140	3182	2	0	9	Q3	2012	1.8200	0.8736	1.0000	1
140	3360	13	0	3	Q1	2012	3.6400	1.4196	2.0000	1
140	3448	3	0	3	Q1	2012	5.4600	1.9110	3.0000	1
140	3773	17	0	5	Q2	2012	7.2800	2.6936	4.0000	1
140	4021	16	1214	2	Q1	2012	3.6400	1.3832	2.0000	1
140	4257	3	0	6	Q2	2012	5.4600	2.2386	3.0000	1
140	4258	7	521	10	Q4	2012	5.4600	2.2386	3.0000	1
140	4445	17	0	5	Q2	2012	5.4600	2.3478	3.0000	1
140	5436	6	0	5	Q2	2012	5.4600	2.6754	3.0000	1
140	5834	11	0	12	Q4	2012	5.4600	2.5662	3.0000	1
140	6575	11	0	12	Q4	2012	5.4600	2.1840	3.0000	1
140	7141	17	0	4	Q2	2012	3.6400	1.7472	2.0000	1
140	7190	23	0	9	Q3	2012	5.4600	1.9110	3.0000	1
140	7209	11	837	10	Q4	2012	5.4600	2.3478	3.0000	1
140	7348	11	0	3	Q1	2012	7.2800	2.9848	4.0000	1
140	7442	24	1856	6	Q2	2012	5.4600	1.9110	3.0000	1
140	7708	6	508	4	Q2	2012	7.2800	2.6936	4.0000	1
140	8165	15	0	6	Q2	2012	5.4600	2.7300	3.0000	1
140	8862	11	818	1	Q1	2012	7.2800	3.2032	4.0000	1
140	9338	6	0	12	Q4	2012	5.4600	2.1840	3.0000	1
140	9747	13	0	9	Q3	2012	7.2800	3.2760	4.0000	1
140	9866	3	0	6	Q2	2012	7.2800	2.2568	4.0000	1
140	10116	17	0	4	Q2	2012	5.4600	1.6926	3.0000	1
141	476	7	0	4	Q2	2012	15.7200	4.7160	4.0000	1
141	994	13	0	7	Q3	2012	7.8600	2.7510	2.0000	1
141	1253	13	984	5	Q2	2012	11.7900	3.8907	3.0000	1
141	1289	23	1789	12	Q4	2012	19.6500	6.2880	5.0000	1
141	1532	6	0	2	Q1	2012	15.7200	5.5020	4.0000	1
141	1850	16	1225	7	Q3	2012	11.7900	5.6592	3.0000	1
141	2289	7	0	10	Q4	2012	11.7900	3.8907	3.0000	1
141	2921	16	0	9	Q3	2012	7.8600	2.9868	2.0000	1
141	2921	16	1220	4	Q2	2012	11.7900	4.3623	3.0000	1
141	3033	24	1859	8	Q3	2012	7.8600	3.6156	2.0000	1
141	3283	15	0	6	Q2	2012	15.7200	4.7160	4.0000	1
141	3448	3	199	7	Q3	2012	15.7200	4.8732	4.0000	1
141	3664	22	0	2	Q1	2012	7.8600	2.8296	2.0000	1
141	3702	6	0	2	Q1	2012	7.8600	2.5152	2.0000	1
141	3838	17	0	7	Q3	2012	15.7200	5.5020	4.0000	1
141	3966	15	0	12	Q4	2012	7.8600	3.2226	2.0000	1
141	4176	24	1856	6	Q2	2012	15.7200	5.0304	4.0000	1
141	4204	17	0	6	Q2	2012	11.7900	4.7160	3.0000	1
141	4204	17	0	10	Q4	2012	19.6500	9.4320	5.0000	1
141	4372	13	0	10	Q4	2012	7.8600	3.9300	2.0000	1
141	4397	16	0	10	Q4	2012	11.7900	5.5413	3.0000	1
141	4739	15	0	10	Q4	2012	11.7900	5.0697	3.0000	1
141	4900	13	0	12	Q4	2012	11.7900	4.0086	3.0000	1
141	4939	2	126	10	Q4	2012	7.8600	3.6942	2.0000	1
141	4950	7	504	2	Q1	2012	11.7900	3.8907	3.0000	1
141	5013	6	0	11	Q4	2012	7.8600	2.9868	2.0000	1
141	5322	7	514	7	Q3	2012	11.7900	3.6549	3.0000	1
141	5322	7	517	8	Q3	2012	7.8600	3.6156	2.0000	1
141	5537	3	195	5	Q2	2012	7.8600	2.6724	2.0000	1
141	5760	13	0	5	Q2	2012	11.7900	5.0697	3.0000	1
141	6590	7	0	9	Q3	2012	7.8600	2.9868	2.0000	1
141	6666	17	0	12	Q4	2012	11.7900	4.5981	3.0000	1
141	7362	11	820	2	Q1	2012	7.8600	2.9868	2.0000	1
141	7899	6	0	4	Q2	2012	11.7900	4.0086	3.0000	1
141	8060	22	0	2	Q1	2012	7.8600	2.9082	2.0000	1
141	8138	24	0	2	Q1	2012	11.7900	4.2444	3.0000	1
141	8254	17	0	11	Q4	2012	7.8600	3.6942	2.0000	1
141	8255	11	826	5	Q2	2012	11.7900	5.4234	3.0000	1
141	8382	15	0	10	Q4	2012	11.7900	3.8907	3.0000	1
141	8435	17	0	1	Q1	2012	11.7900	3.5370	3.0000	1
141	8526	11	0	5	Q2	2012	7.8600	2.5938	2.0000	1
141	8653	3	0	3	Q1	2012	11.7900	4.5981	3.0000	1
141	8794	17	0	11	Q4	2012	19.6500	7.6635	5.0000	1
141	8976	13	0	2	Q1	2012	11.7900	4.3623	3.0000	1
141	9190	6	0	10	Q4	2012	11.7900	5.1876	3.0000	1
141	9309	17	0	2	Q1	2012	11.7900	4.9518	3.0000	1
141	9390	7	519	9	Q3	2012	11.7900	3.7728	3.0000	1
142	20	24	0	1	Q1	2012	6.9600	2.2272	3.0000	1
142	545	13	0	11	Q4	2012	9.2800	3.8048	4.0000	1
142	595	24	0	7	Q3	2012	9.2800	3.5264	4.0000	1
142	842	15	0	11	Q4	2012	6.9600	2.2968	3.0000	1
142	1491	16	1233	10	Q4	2012	6.9600	2.9928	3.0000	1
142	1575	13	0	1	Q1	2012	4.6400	1.9488	2.0000	1
142	1680	6	511	5	Q2	2012	9.2800	3.8976	4.0000	1
142	1736	13	986	6	Q2	2012	4.6400	1.6240	2.0000	1
142	1917	23	0	4	Q2	2012	9.2800	3.4336	4.0000	1
142	2296	6	0	5	Q2	2012	6.9600	2.2968	3.0000	1
142	2422	13	984	5	Q2	2012	6.9600	2.5752	3.0000	1
142	2556	3	188	2	Q1	2012	6.9600	2.4360	3.0000	1
142	2681	7	0	12	Q4	2012	9.2800	4.6400	4.0000	1
142	2769	16	0	7	Q3	2012	6.9600	3.2712	3.0000	1
142	2963	7	0	5	Q2	2012	9.2800	3.2480	4.0000	1
142	2981	23	0	9	Q3	2012	9.2800	3.5264	4.0000	1
142	3124	3	0	6	Q2	2012	6.9600	3.0624	3.0000	1
142	3321	24	1850	3	Q1	2012	6.9600	3.2712	3.0000	1
142	3416	6	0	12	Q4	2012	6.9600	2.5752	3.0000	1
142	3809	6	519	9	Q3	2012	9.2800	4.3616	4.0000	1
142	4395	11	0	2	Q1	2012	4.6400	1.4384	2.0000	1
142	4460	3	0	12	Q4	2012	4.6400	1.9024	2.0000	1
142	5168	7	0	5	Q2	2012	9.2800	3.6192	4.0000	1
142	5335	15	0	8	Q3	2012	6.9600	2.2272	3.0000	1
142	5612	15	0	6	Q2	2012	6.9600	2.5056	3.0000	1
142	5820	17	0	8	Q3	2012	9.2800	3.3408	4.0000	1
142	5869	13	0	7	Q3	2012	6.9600	3.2712	3.0000	1
142	5958	13	0	9	Q3	2012	9.2800	3.5264	4.0000	1
142	6307	16	0	1	Q1	2012	11.6000	4.1760	5.0000	1
142	6559	3	190	3	Q1	2012	6.9600	2.5056	3.0000	1
142	7179	11	0	2	Q1	2012	4.6400	2.2272	2.0000	1
142	7234	16	0	7	Q3	2012	9.2800	3.1552	4.0000	1
142	7702	16	0	2	Q1	2012	9.2800	3.9904	4.0000	1
142	8374	3	0	4	Q2	2012	9.2800	3.0624	4.0000	1
142	8587	22	0	3	Q1	2012	2.3200	0.7424	1.0000	1
142	8633	24	1866	11	Q4	2012	6.9600	3.2016	3.0000	1
142	8657	15	0	11	Q4	2012	6.9600	2.5056	3.0000	1
142	9278	2	0	3	Q1	2012	2.3200	0.9744	1.0000	1
142	9309	17	1311	10	Q4	2012	9.2800	3.7120	4.0000	1
142	9325	11	0	9	Q3	2012	6.9600	2.4360	3.0000	1
142	9396	13	980	3	Q1	2012	6.9600	3.0624	3.0000	1
142	9397	11	0	11	Q4	2012	4.6400	1.4848	2.0000	1
142	9459	11	0	1	Q1	2012	11.6000	5.1040	5.0000	1
142	9646	2	0	11	Q4	2012	2.3200	1.1368	1.0000	1
142	9781	3	187	2	Q1	2012	6.9600	2.5056	3.0000	1
142	10166	11	0	5	Q2	2012	4.6400	2.1808	2.0000	1
142	10231	6	524	11	Q4	2012	6.9600	3.2712	3.0000	1
143	280	13	0	8	Q3	2012	7.3800	2.7306	3.0000	1
143	369	7	504	2	Q1	2012	4.9200	1.5744	2.0000	1
143	569	23	0	10	Q4	2012	9.8400	3.8376	4.0000	1
143	758	22	1694	4	Q2	2012	7.3800	2.6568	3.0000	1
143	813	11	0	1	Q1	2012	7.3800	3.1734	3.0000	1
143	878	3	210	12	Q4	2012	7.3800	3.5424	3.0000	1
143	1176	24	0	9	Q3	2012	7.3800	3.1734	3.0000	1
143	1676	3	207	11	Q4	2012	7.3800	3.0258	3.0000	1
143	1706	13	0	7	Q3	2012	7.3800	3.0258	3.0000	1
143	1744	17	1292	1	Q1	2012	7.3800	3.2472	3.0000	1
143	1785	3	0	7	Q3	2012	9.8400	3.1488	4.0000	1
143	2096	24	0	3	Q1	2012	7.3800	3.2472	3.0000	1
143	2244	17	0	2	Q1	2012	12.3000	5.1660	5.0000	1
143	2638	13	0	1	Q1	2012	9.8400	4.8216	4.0000	1
143	3155	6	0	10	Q4	2012	4.9200	1.6236	2.0000	1
143	3160	17	1314	11	Q4	2012	7.3800	3.5424	3.0000	1
143	3187	24	1869	12	Q4	2012	7.3800	2.2878	3.0000	1
143	3719	23	0	12	Q4	2012	4.9200	2.3124	2.0000	1
143	4021	16	1233	10	Q4	2012	12.3000	3.6900	5.0000	1
143	4056	11	821	3	Q1	2012	7.3800	3.3948	3.0000	1
143	4204	17	1312	10	Q4	2012	7.3800	3.0258	3.0000	1
143	4240	24	0	8	Q3	2012	4.9200	1.5744	2.0000	1
143	4490	13	0	10	Q4	2012	4.9200	1.8204	2.0000	1
143	4527	3	0	12	Q4	2012	9.8400	3.4440	4.0000	1
143	4541	3	0	6	Q2	2012	4.9200	1.6728	2.0000	1
143	4691	17	1304	7	Q3	2012	9.8400	4.2312	4.0000	1
143	4824	3	0	11	Q4	2012	12.3000	5.0430	5.0000	1
143	4846	17	0	8	Q3	2012	4.9200	1.5252	2.0000	1
143	4903	3	188	2	Q1	2012	9.8400	4.7232	4.0000	1
143	5127	15	0	11	Q4	2012	9.8400	3.6408	4.0000	1
143	5410	17	0	9	Q3	2012	4.9200	2.2632	2.0000	1
143	5597	3	0	6	Q2	2012	7.3800	2.9520	3.0000	1
143	5720	2	0	4	Q2	2012	4.9200	2.2632	2.0000	1
143	5824	7	0	4	Q2	2012	9.8400	3.4440	4.0000	1
143	5869	13	0	3	Q1	2012	7.3800	3.3948	3.0000	1
143	5913	7	0	5	Q2	2012	4.9200	1.5744	2.0000	1
143	6148	11	0	1	Q1	2012	7.3800	2.2140	3.0000	1
143	6452	11	0	10	Q4	2012	7.3800	3.5424	3.0000	1
143	6494	7	0	1	Q1	2012	7.3800	3.1734	3.0000	1
143	6924	24	0	7	Q3	2012	4.9200	1.9680	2.0000	1
143	7608	15	0	9	Q3	2012	9.8400	3.5424	4.0000	1
143	7635	24	0	10	Q4	2012	4.9200	1.8696	2.0000	1
143	7997	13	0	12	Q4	2012	9.8400	3.1488	4.0000	1
143	8126	24	1860	8	Q3	2012	4.9200	1.8696	2.0000	1
143	8206	23	0	5	Q2	2012	9.8400	4.1328	4.0000	1
143	8275	16	0	11	Q4	2012	7.3800	2.4354	3.0000	1
143	8336	17	0	3	Q1	2012	9.8400	2.9520	4.0000	1
143	8574	15	0	6	Q2	2012	4.9200	2.3124	2.0000	1
143	8749	13	0	11	Q4	2012	7.3800	2.3616	3.0000	1
143	9151	15	1140	4	Q2	2012	7.3800	3.3948	3.0000	1
143	9404	7	0	3	Q1	2012	7.3800	2.9520	3.0000	1
143	9470	7	0	3	Q1	2012	9.8400	3.3456	4.0000	1
143	9497	15	0	5	Q2	2012	7.3800	2.4354	3.0000	1
143	9797	16	0	6	Q2	2012	9.8400	4.1328	4.0000	1
143	10026	13	0	2	Q1	2012	7.3800	2.2878	3.0000	1
143	10026	13	980	3	Q1	2012	4.9200	1.5744	2.0000	1
143	10173	16	1228	8	Q3	2012	7.3800	3.3948	3.0000	1
144	323	24	1847	2	Q1	2012	2.0400	0.6528	4.0000	1
144	430	16	0	4	Q2	2012	1.5300	0.6120	3.0000	1
144	448	17	0	4	Q2	2012	1.5300	0.5355	3.0000	1
144	1660	13	0	1	Q1	2012	1.5300	0.7344	3.0000	1
144	2460	24	0	10	Q4	2012	1.0200	0.4182	2.0000	1
144	2523	6	518	8	Q3	2012	1.0200	0.3672	2.0000	1
144	2626	11	0	11	Q4	2012	2.0400	0.7344	4.0000	1
144	3001	13	0	7	Q3	2012	2.0400	0.9792	4.0000	1
144	3216	7	514	7	Q3	2012	1.5300	0.6732	3.0000	1
144	3300	24	0	7	Q3	2012	1.0200	0.4998	2.0000	1
144	3404	24	0	8	Q3	2012	1.5300	0.6579	3.0000	1
144	3533	3	0	9	Q3	2012	1.5300	0.6426	3.0000	1
144	4397	16	0	9	Q3	2012	2.0400	1.0200	4.0000	1
144	4420	11	0	1	Q1	2012	2.0400	0.6732	4.0000	1
144	4445	17	1314	11	Q4	2012	1.5300	0.6732	3.0000	1
144	4670	17	1297	3	Q1	2012	1.5300	0.5661	3.0000	1
144	4868	16	0	8	Q3	2012	2.0400	0.8160	4.0000	1
144	5742	16	0	12	Q4	2012	2.0400	0.7548	4.0000	1
144	5869	13	0	9	Q3	2012	1.5300	0.7038	3.0000	1
144	5898	3	0	5	Q2	2012	1.5300	0.6273	3.0000	1
144	6138	17	0	6	Q2	2012	1.5300	0.6885	3.0000	1
144	6454	15	0	7	Q3	2012	1.5300	0.6273	3.0000	1
144	6835	16	1228	8	Q3	2012	1.0200	0.3978	2.0000	1
144	6912	16	0	12	Q4	2012	1.5300	0.7191	3.0000	1
144	7008	2	0	2	Q1	2012	1.0200	0.4182	2.0000	1
144	7085	11	0	5	Q2	2012	1.5300	0.4590	3.0000	1
144	7913	17	0	12	Q4	2012	1.5300	0.5508	3.0000	1
144	7913	17	1303	6	Q2	2012	1.5300	0.5508	3.0000	1
144	7963	11	0	11	Q4	2012	2.0400	0.8976	4.0000	1
144	8024	6	0	12	Q4	2012	1.5300	0.5814	3.0000	1
144	8172	17	1303	6	Q2	2012	2.0400	0.6324	4.0000	1
144	8242	17	0	3	Q1	2012	1.0200	0.3060	2.0000	1
144	8351	16	0	12	Q4	2012	1.5300	0.6732	3.0000	1
144	8814	13	0	5	Q2	2012	1.5300	0.5355	3.0000	1
144	9167	11	821	3	Q1	2012	2.0400	0.7140	4.0000	1
144	9225	11	0	9	Q3	2012	1.0200	0.3366	2.0000	1
144	9318	16	0	6	Q2	2012	1.0200	0.4284	2.0000	1
144	9338	6	0	12	Q4	2012	1.5300	0.5049	3.0000	1
144	9471	6	521	10	Q4	2012	1.0200	0.3774	2.0000	1
144	9745	17	1297	3	Q1	2012	2.5500	1.0965	5.0000	1
144	9797	16	0	12	Q4	2012	2.0400	0.6324	4.0000	1
144	9851	3	0	2	Q1	2012	1.5300	0.6120	3.0000	1
144	10003	24	0	8	Q3	2012	1.0200	0.4794	2.0000	1
144	10097	6	523	11	Q4	2012	1.5300	0.7497	3.0000	1
145	44	6	515	7	Q3	2012	4.5400	1.4982	2.0000	1
145	448	17	0	9	Q3	2012	6.8100	2.7921	3.0000	1
145	472	17	0	9	Q3	2012	4.5400	1.6344	2.0000	1
145	760	3	0	3	Q1	2012	6.8100	2.5197	3.0000	1
145	769	16	0	12	Q4	2012	6.8100	2.1792	3.0000	1
145	863	17	0	3	Q1	2012	4.5400	1.9522	2.0000	1
145	891	7	0	8	Q3	2012	9.0800	4.0860	4.0000	1
145	1245	17	0	11	Q4	2012	4.5400	1.7706	2.0000	1
145	1773	13	982	4	Q2	2012	4.5400	2.1792	2.0000	1
145	1791	13	0	7	Q3	2012	6.8100	3.2688	3.0000	1
145	2019	16	0	5	Q2	2012	9.0800	4.2676	4.0000	1
145	2371	16	0	3	Q1	2012	6.8100	2.7921	3.0000	1
145	2472	6	521	10	Q4	2012	9.0800	3.5412	4.0000	1
145	2914	15	0	2	Q1	2012	4.5400	2.0884	2.0000	1
145	2918	17	0	11	Q4	2012	9.0800	2.9964	4.0000	1
145	3157	7	521	10	Q4	2012	9.0800	2.9964	4.0000	1
145	3197	23	0	5	Q2	2012	6.8100	2.5197	3.0000	1
145	3249	11	0	12	Q4	2012	9.0800	4.3584	4.0000	1
145	3334	17	0	12	Q4	2012	6.8100	2.1792	3.0000	1
145	3620	15	1138	3	Q1	2012	4.5400	1.7252	2.0000	1
145	3687	24	0	12	Q4	2012	9.0800	2.9964	4.0000	1
145	3936	7	0	10	Q4	2012	6.8100	2.8602	3.0000	1
145	4420	11	0	10	Q4	2012	9.0800	2.9964	4.0000	1
145	4700	17	0	4	Q2	2012	6.8100	2.9283	3.0000	1
145	4858	17	0	5	Q2	2012	4.5400	1.4074	2.0000	1
145	4909	6	523	11	Q4	2012	6.8100	2.7921	3.0000	1
145	4995	13	0	11	Q4	2012	4.5400	1.8160	2.0000	1
145	5022	15	0	11	Q4	2012	9.0800	4.0860	4.0000	1
145	5135	6	0	9	Q3	2012	9.0800	2.7240	4.0000	1
145	5542	16	0	11	Q4	2012	4.5400	2.0884	2.0000	1
145	5547	7	0	6	Q2	2012	6.8100	2.4516	3.0000	1
145	5879	6	0	12	Q4	2012	4.5400	1.9522	2.0000	1
145	5957	11	0	5	Q2	2012	4.5400	1.5436	2.0000	1
145	6067	7	0	6	Q2	2012	4.5400	1.4528	2.0000	1
145	6844	11	829	6	Q2	2012	6.8100	3.3369	3.0000	1
145	7391	7	505	2	Q1	2012	6.8100	2.1792	3.0000	1
145	7543	2	0	9	Q3	2012	2.2700	0.8172	1.0000	1
145	7811	11	818	1	Q1	2012	9.0800	4.0860	4.0000	1
145	8477	3	0	3	Q1	2012	4.5400	1.9522	2.0000	1
145	8771	22	0	8	Q3	2012	2.2700	0.9761	1.0000	1
145	9144	13	0	12	Q4	2012	4.5400	1.9976	2.0000	1
145	9437	15	1134	1	Q1	2012	4.5400	1.9976	2.0000	1
145	9591	7	0	4	Q2	2012	6.8100	2.4516	3.0000	1
145	9631	16	0	8	Q3	2012	9.0800	3.9044	4.0000	1
145	9667	23	0	12	Q4	2012	6.8100	2.5197	3.0000	1
145	10106	13	0	5	Q2	2012	11.3500	3.4050	5.0000	1
146	350	6	0	2	Q1	2012	15.3200	6.1280	4.0000	1
146	405	6	523	11	Q4	2012	11.4900	4.1364	3.0000	1
146	448	17	0	7	Q3	2012	11.4900	4.1364	3.0000	1
146	502	15	0	3	Q1	2012	7.6600	3.5236	2.0000	1
146	588	23	1765	1	Q1	2012	7.6600	2.4512	2.0000	1
146	1053	13	0	1	Q1	2012	11.4900	3.6768	3.0000	1
146	1079	7	0	5	Q2	2012	15.3200	4.5960	4.0000	1
146	1415	16	0	7	Q3	2012	11.4900	4.9407	3.0000	1
146	1706	13	0	6	Q2	2012	11.4900	5.4003	3.0000	1
146	1720	16	1225	7	Q3	2012	11.4900	4.2513	3.0000	1
146	1874	17	0	5	Q2	2012	11.4900	5.0556	3.0000	1
146	1963	11	824	4	Q2	2012	11.4900	4.9407	3.0000	1
146	2218	7	0	8	Q3	2012	19.1500	5.7450	5.0000	1
146	2232	6	0	3	Q1	2012	7.6600	2.4512	2.0000	1
146	2251	13	0	2	Q1	2012	11.4900	3.7917	3.0000	1
146	3845	24	0	7	Q3	2012	15.3200	6.7408	4.0000	1
146	4021	16	1233	10	Q4	2012	11.4900	4.1364	3.0000	1
146	4368	6	0	8	Q3	2012	11.4900	4.0215	3.0000	1
146	4625	15	1142	5	Q2	2012	11.4900	4.3662	3.0000	1
146	4692	15	0	5	Q2	2012	11.4900	3.6768	3.0000	1
146	4767	16	0	5	Q2	2012	11.4900	3.6768	3.0000	1
146	4824	3	0	6	Q2	2012	11.4900	4.2513	3.0000	1
146	4858	17	0	12	Q4	2012	7.6600	2.3746	2.0000	1
146	4942	11	833	8	Q3	2012	11.4900	4.7109	3.0000	1
146	5508	6	0	6	Q2	2012	11.4900	4.3662	3.0000	1
146	5560	13	0	2	Q1	2012	11.4900	5.0556	3.0000	1
146	5597	3	207	11	Q4	2012	11.4900	4.5960	3.0000	1
146	5885	14	0	6	Q2	2012	3.8300	1.2256	1.0000	1
146	5944	3	204	9	Q3	2012	15.3200	6.7408	4.0000	1
146	6014	7	517	8	Q3	2012	15.3200	5.5152	4.0000	1
146	6589	17	0	12	Q4	2012	15.3200	6.5876	4.0000	1
146	6854	17	0	3	Q1	2012	11.4900	5.5152	3.0000	1
146	6921	24	0	1	Q1	2012	7.6600	3.0640	2.0000	1
146	7138	11	0	6	Q2	2012	11.4900	4.7109	3.0000	1
146	7232	11	0	7	Q3	2012	15.3200	5.0556	4.0000	1
146	7281	17	1307	8	Q3	2012	11.4900	4.7109	3.0000	1
146	7287	24	0	12	Q4	2012	11.4900	3.6768	3.0000	1
146	7434	11	0	12	Q4	2012	11.4900	3.6768	3.0000	1
146	7457	13	0	3	Q1	2012	11.4900	4.1364	3.0000	1
146	7459	6	523	11	Q4	2012	7.6600	3.5236	2.0000	1
146	7502	16	1216	2	Q1	2012	11.4900	4.7109	3.0000	1
146	7576	13	0	8	Q3	2012	11.4900	3.6768	3.0000	1
146	7906	13	0	7	Q3	2012	11.4900	4.9407	3.0000	1
146	7938	24	0	9	Q3	2012	15.3200	6.7408	4.0000	1
146	8084	22	1698	6	Q2	2012	3.8300	1.8001	1.0000	1
146	8164	13	0	2	Q1	2012	11.4900	3.9066	3.0000	1
146	8436	15	0	1	Q1	2012	11.4900	4.1364	3.0000	1
146	8669	23	0	9	Q3	2012	7.6600	2.6044	2.0000	1
146	8840	17	0	6	Q2	2012	15.3200	6.4344	4.0000	1
146	9631	16	0	6	Q2	2012	15.3200	7.0472	4.0000	1
146	9728	16	1228	8	Q3	2012	15.3200	6.7408	4.0000	1
146	9744	6	0	3	Q1	2012	11.4900	4.0215	3.0000	1
146	9801	11	0	9	Q3	2012	11.4900	3.6768	3.0000	1
146	10026	13	0	3	Q1	2012	7.6600	2.4512	2.0000	1
147	216	17	1311	10	Q4	2012	1.2800	0.4864	2.0000	1
147	517	7	521	10	Q4	2012	1.2800	0.5120	2.0000	1
147	625	13	0	11	Q4	2012	1.9200	0.7296	3.0000	1
147	909	7	0	5	Q2	2012	1.9200	0.8256	3.0000	1
147	1129	24	1856	6	Q2	2012	2.5600	1.2544	4.0000	1
147	1289	23	0	5	Q2	2012	1.2800	0.5504	2.0000	1
147	1567	16	1228	8	Q3	2012	1.2800	0.4736	2.0000	1
147	1599	6	0	6	Q2	2012	1.9200	0.7488	3.0000	1
147	1773	13	0	11	Q4	2012	1.9200	0.7104	3.0000	1
147	1965	17	0	7	Q3	2012	1.9200	0.6336	3.0000	1
147	2054	15	0	3	Q1	2012	1.9200	0.8256	3.0000	1
147	2251	13	0	12	Q4	2012	1.9200	0.6336	3.0000	1
147	2587	16	1236	12	Q4	2012	1.9200	0.7872	3.0000	1
147	2591	7	0	12	Q4	2012	1.9200	0.7872	3.0000	1
147	2916	13	984	5	Q2	2012	1.9200	0.9216	3.0000	1
147	3020	13	0	3	Q1	2012	2.5600	1.2288	4.0000	1
147	3267	23	1775	5	Q2	2012	2.5600	0.7680	4.0000	1
147	3692	16	0	3	Q1	2012	1.2800	0.5376	2.0000	1
147	3826	16	0	3	Q1	2012	1.9200	0.7488	3.0000	1
147	4056	11	821	3	Q1	2012	3.2000	1.4720	5.0000	1
147	4234	3	0	4	Q2	2012	2.5600	1.2288	4.0000	1
147	4291	15	0	12	Q4	2012	1.9200	0.8448	3.0000	1
147	4651	22	1711	12	Q4	2012	1.2800	0.6400	2.0000	1
147	4690	13	0	12	Q4	2012	1.2800	0.3968	2.0000	1
147	4739	15	0	12	Q4	2012	1.9200	0.7488	3.0000	1
147	4925	16	0	9	Q3	2012	1.2800	0.6272	2.0000	1
147	5019	23	0	7	Q3	2012	1.2800	0.6016	2.0000	1
147	5060	13	0	1	Q1	2012	1.9200	0.7488	3.0000	1
147	5303	17	0	12	Q4	2012	1.9200	0.7872	3.0000	1
147	5353	23	0	10	Q4	2012	1.9200	0.9216	3.0000	1
147	5376	3	0	11	Q4	2012	1.2800	0.5120	2.0000	1
147	5592	16	1216	2	Q1	2012	2.5600	1.2288	4.0000	1
147	5597	3	0	6	Q2	2012	1.9200	0.6336	3.0000	1
147	5924	13	0	2	Q1	2012	1.9200	0.8448	3.0000	1
147	6617	7	516	8	Q3	2012	1.9200	0.7488	3.0000	1
147	6651	11	826	5	Q2	2012	2.5600	0.9984	4.0000	1
147	7377	3	210	12	Q4	2012	1.9200	0.7680	3.0000	1
147	7584	7	514	7	Q3	2012	3.2000	1.1200	5.0000	1
147	7584	6	524	11	Q4	2012	1.9200	0.5760	3.0000	1
147	8478	7	0	12	Q4	2012	1.9200	0.8256	3.0000	1
147	8742	3	0	8	Q3	2012	1.9200	0.7488	3.0000	1
147	8746	23	0	12	Q4	2012	2.5600	0.7680	4.0000	1
147	8772	11	0	5	Q2	2012	2.5600	0.9216	4.0000	1
147	8951	24	0	9	Q3	2012	1.2800	0.6016	2.0000	1
147	9404	7	0	3	Q1	2012	1.9200	0.6336	3.0000	1
147	9521	7	0	9	Q3	2012	1.2800	0.4992	2.0000	1
147	9973	6	0	10	Q4	2012	1.9200	0.8256	3.0000	1
148	187	13	0	9	Q3	2012	11.8500	4.2660	3.0000	1
148	336	6	508	4	Q2	2012	11.8500	3.5550	3.0000	1
148	378	16	0	1	Q1	2012	7.9000	2.3700	2.0000	1
148	769	16	1216	2	Q1	2012	11.8500	3.7920	3.0000	1
148	783	11	0	5	Q2	2012	11.8500	4.0290	3.0000	1
148	1328	17	0	9	Q3	2012	15.8000	7.7420	4.0000	1
148	1451	3	0	3	Q1	2012	11.8500	3.5550	3.0000	1
148	1965	17	0	10	Q4	2012	11.8500	4.9770	3.0000	1
148	2158	11	833	8	Q3	2012	11.8500	4.7400	3.0000	1
148	2201	16	0	5	Q2	2012	7.9000	2.5280	2.0000	1
148	2295	17	0	9	Q3	2012	15.8000	6.4780	4.0000	1
148	2588	23	0	5	Q2	2012	11.8500	5.5695	3.0000	1
148	2625	13	980	3	Q1	2012	11.8500	4.7400	3.0000	1
148	2703	6	504	2	Q1	2012	15.8000	6.1620	4.0000	1
148	2723	3	0	12	Q4	2012	7.9000	3.2390	2.0000	1
148	2769	16	0	3	Q1	2012	11.8500	5.5695	3.0000	1
148	3153	13	992	9	Q3	2012	15.8000	7.7420	4.0000	1
148	3321	24	0	3	Q1	2012	7.9000	3.2390	2.0000	1
148	3748	13	0	4	Q2	2012	11.8500	5.8065	3.0000	1
148	3906	15	0	5	Q2	2012	11.8500	5.6880	3.0000	1
148	3944	14	0	3	Q1	2012	3.9500	1.2245	1.0000	1
148	3976	17	0	9	Q3	2012	11.8500	5.0955	3.0000	1
148	4234	3	0	7	Q3	2012	19.7500	6.9125	5.0000	1
148	4340	17	0	5	Q2	2012	11.8500	4.6215	3.0000	1
148	4497	17	0	5	Q2	2012	11.8500	5.3325	3.0000	1
148	4527	3	0	11	Q4	2012	11.8500	4.8585	3.0000	1
148	4541	3	0	12	Q4	2012	15.8000	7.7420	4.0000	1
148	4664	6	0	12	Q4	2012	15.8000	6.6360	4.0000	1
148	4998	3	0	4	Q2	2012	15.8000	4.7400	4.0000	1
148	5329	13	982	4	Q2	2012	15.8000	5.2140	4.0000	1
148	5410	17	0	3	Q1	2012	11.8500	4.3845	3.0000	1
148	5410	17	0	11	Q4	2012	11.8500	4.2660	3.0000	1
148	5432	16	0	7	Q3	2012	7.9000	2.5280	2.0000	1
148	5790	17	0	4	Q2	2012	7.9000	3.2390	2.0000	1
148	5790	17	1303	6	Q2	2012	15.8000	7.2680	4.0000	1
148	6009	11	0	7	Q3	2012	11.8500	4.7400	3.0000	1
148	6560	17	1304	7	Q3	2012	11.8500	4.6215	3.0000	1
148	6564	13	0	6	Q2	2012	15.8000	6.9520	4.0000	1
148	7190	23	1775	5	Q2	2012	7.9000	2.7650	2.0000	1
148	7683	22	0	3	Q1	2012	3.9500	1.5010	1.0000	1
148	8074	17	0	12	Q4	2012	11.8500	5.2140	3.0000	1
148	8141	22	0	10	Q4	2012	7.9000	3.3180	2.0000	1
148	8919	13	0	10	Q4	2012	11.8500	4.5030	3.0000	1
148	9065	13	0	3	Q1	2012	11.8500	4.9770	3.0000	1
148	9154	24	0	6	Q2	2012	11.8500	5.4510	3.0000	1
148	9937	17	0	10	Q4	2012	11.8500	5.5695	3.0000	1
148	10225	23	0	9	Q3	2012	11.8500	5.2140	3.0000	1
149	612	22	0	9	Q3	2012	4.9800	1.5936	2.0000	1
149	621	11	0	11	Q4	2012	7.4700	2.6892	3.0000	1
149	638	11	0	2	Q1	2012	7.4700	2.6892	3.0000	1
149	769	16	0	12	Q4	2012	7.4700	2.6145	3.0000	1
149	1337	17	0	12	Q4	2012	4.9800	2.2410	2.0000	1
149	1415	16	0	12	Q4	2012	7.4700	3.5109	3.0000	1
149	1820	7	0	11	Q4	2012	4.9800	1.6932	2.0000	1
149	1917	23	0	3	Q1	2012	7.4700	2.8386	3.0000	1
149	2600	15	0	7	Q3	2012	9.9600	4.7808	4.0000	1
149	2818	6	0	4	Q2	2012	7.4700	2.3904	3.0000	1
149	3152	15	0	7	Q3	2012	7.4700	3.6603	3.0000	1
149	3249	11	0	12	Q4	2012	7.4700	2.3157	3.0000	1
149	3499	13	0	7	Q3	2012	7.4700	2.6145	3.0000	1
149	3693	3	0	1	Q1	2012	9.9600	4.8804	4.0000	1
149	3750	6	0	3	Q1	2012	12.4500	3.8595	5.0000	1
149	3849	15	0	10	Q4	2012	9.9600	2.9880	4.0000	1
149	4074	11	0	11	Q4	2012	9.9600	3.8844	4.0000	1
149	4219	11	0	3	Q1	2012	7.4700	3.0627	3.0000	1
149	4232	7	512	6	Q2	2012	9.9600	3.5856	4.0000	1
149	4261	13	0	11	Q4	2012	7.4700	2.2410	3.0000	1
149	4417	3	0	12	Q4	2012	7.4700	3.0627	3.0000	1
149	4445	17	0	3	Q1	2012	7.4700	3.6603	3.0000	1
149	4468	11	0	1	Q1	2012	9.9600	3.0876	4.0000	1
149	4623	13	0	6	Q2	2012	7.4700	3.1374	3.0000	1
149	4623	13	0	11	Q4	2012	7.4700	2.7639	3.0000	1
149	4843	24	0	6	Q2	2012	12.4500	5.3535	5.0000	1
149	4858	17	1303	6	Q2	2012	7.4700	3.1374	3.0000	1
149	4925	16	0	4	Q2	2012	4.9800	2.4402	2.0000	1
149	5280	7	0	12	Q4	2012	9.9600	4.8804	4.0000	1
149	5846	11	0	8	Q3	2012	9.9600	3.6852	4.0000	1
149	6675	22	0	2	Q1	2012	2.4900	1.0209	1.0000	1
149	6850	15	0	7	Q3	2012	4.9800	1.4940	2.0000	1
149	6889	15	0	4	Q2	2012	7.4700	3.1374	3.0000	1
149	6932	13	0	5	Q2	2012	7.4700	3.2121	3.0000	1
149	6936	17	0	10	Q4	2012	7.4700	2.9133	3.0000	1
149	7203	13	0	2	Q1	2012	7.4700	2.6892	3.0000	1
149	7678	23	0	11	Q4	2012	4.9800	1.9422	2.0000	1
149	8068	3	0	8	Q3	2012	9.9600	4.6812	4.0000	1
149	8359	17	0	5	Q2	2012	9.9600	4.5816	4.0000	1
149	8921	13	0	3	Q1	2012	9.9600	4.3824	4.0000	1
149	9167	11	0	3	Q1	2012	12.4500	4.4820	5.0000	1
149	9764	14	0	3	Q1	2012	2.4900	1.0209	1.0000	1
149	9851	3	0	10	Q4	2012	7.4700	3.1374	3.0000	1
149	10210	7	518	8	Q3	2012	9.9600	4.2828	4.0000	1
150	341	17	0	3	Q1	2012	10.3500	5.1750	3.0000	1
150	373	13	0	11	Q4	2012	10.3500	3.6225	3.0000	1
150	466	6	0	10	Q4	2012	13.8000	4.9680	4.0000	1
150	764	6	0	7	Q3	2012	13.8000	4.2780	4.0000	1
150	1389	7	0	11	Q4	2012	10.3500	4.4505	3.0000	1
150	1415	16	0	7	Q3	2012	10.3500	5.0715	3.0000	1
150	1589	15	0	9	Q3	2012	10.3500	4.2435	3.0000	1
150	1622	3	204	9	Q3	2012	10.3500	3.8295	3.0000	1
150	1634	3	0	4	Q2	2012	10.3500	5.0715	3.0000	1
150	1820	7	0	3	Q1	2012	10.3500	3.7260	3.0000	1
150	1979	3	0	4	Q2	2012	17.2500	7.5900	5.0000	1
150	2201	16	0	3	Q1	2012	13.8000	6.7620	4.0000	1
150	2232	6	0	3	Q1	2012	6.9000	2.3460	2.0000	1
150	2280	13	0	7	Q3	2012	6.9000	2.5530	2.0000	1
150	2386	14	0	12	Q4	2012	6.9000	3.3810	2.0000	1
150	2437	3	0	11	Q4	2012	10.3500	4.1400	3.0000	1
150	2570	16	1220	4	Q2	2012	6.9000	2.2080	2.0000	1
150	2587	16	0	10	Q4	2012	10.3500	3.8295	3.0000	1
150	2830	7	0	8	Q3	2012	10.3500	3.4155	3.0000	1
150	2981	23	1775	5	Q2	2012	6.9000	2.1390	2.0000	1
150	3301	11	0	9	Q3	2012	6.9000	2.6220	2.0000	1
150	3301	11	826	5	Q2	2012	6.9000	2.6220	2.0000	1
150	3308	13	986	6	Q2	2012	10.3500	4.1400	3.0000	1
150	3360	13	0	3	Q1	2012	10.3500	3.7260	3.0000	1
150	3973	15	0	3	Q1	2012	6.9000	2.6220	2.0000	1
150	4221	17	0	2	Q1	2012	10.3500	5.0715	3.0000	1
150	4342	13	0	9	Q3	2012	17.2500	5.6925	5.0000	1
150	4397	16	1235	11	Q4	2012	10.3500	4.8645	3.0000	1
150	4522	17	1314	11	Q4	2012	10.3500	4.5540	3.0000	1
150	4527	3	207	11	Q4	2012	6.9000	2.6220	2.0000	1
150	4942	11	841	12	Q4	2012	10.3500	3.3120	3.0000	1
150	5485	14	1071	8	Q3	2012	10.3500	3.3120	3.0000	1
150	5592	16	0	8	Q3	2012	10.3500	3.3120	3.0000	1
150	5597	3	207	11	Q4	2012	10.3500	3.4155	3.0000	1
150	5895	17	0	3	Q1	2012	10.3500	3.1050	3.0000	1
150	6114	16	0	9	Q3	2012	6.9000	2.8290	2.0000	1
150	6442	7	0	6	Q2	2012	10.3500	3.3120	3.0000	1
150	6554	17	0	3	Q1	2012	6.9000	2.6220	2.0000	1
150	6878	7	0	9	Q3	2012	6.9000	2.8290	2.0000	1
150	6956	13	0	7	Q3	2012	13.8000	5.1060	4.0000	1
150	7200	11	829	6	Q2	2012	6.9000	2.8980	2.0000	1
150	7263	11	0	1	Q1	2012	10.3500	3.2085	3.0000	1
150	7735	15	0	8	Q3	2012	10.3500	4.9680	3.0000	1
150	7920	17	0	1	Q1	2012	6.9000	2.2080	2.0000	1
150	8066	15	0	2	Q1	2012	10.3500	3.2085	3.0000	1
150	8089	17	0	8	Q3	2012	6.9000	2.8980	2.0000	1
150	8165	15	0	11	Q4	2012	6.9000	2.8290	2.0000	1
150	8269	13	0	8	Q3	2012	6.9000	2.4840	2.0000	1
150	9200	16	0	8	Q3	2012	13.8000	6.6240	4.0000	1
150	10131	17	0	5	Q2	2012	10.3500	3.3120	3.0000	1
151	93	13	0	1	Q1	2012	5.8200	2.1534	2.0000	1
151	93	13	0	11	Q4	2012	8.7300	2.7936	3.0000	1
151	499	24	1851	4	Q2	2012	8.7300	3.0555	3.0000	1
151	760	3	0	7	Q3	2012	8.7300	3.7539	3.0000	1
151	763	6	0	7	Q3	2012	5.8200	1.8624	2.0000	1
151	981	24	1866	11	Q4	2012	8.7300	4.1031	3.0000	1
151	1097	23	0	4	Q2	2012	5.8200	2.6772	2.0000	1
151	1271	13	0	3	Q1	2012	11.6400	5.0052	4.0000	1
151	1297	16	0	4	Q2	2012	11.6400	4.1904	4.0000	1
151	1423	13	0	11	Q4	2012	5.8200	2.0952	2.0000	1
151	1446	24	0	3	Q1	2012	8.7300	3.8412	3.0000	1
151	1681	13	0	6	Q2	2012	14.5500	4.6560	5.0000	1
151	1695	2	114	4	Q2	2012	5.8200	2.1534	2.0000	1
151	2274	14	1054	1	Q1	2012	2.9100	1.2804	1.0000	1
151	2869	6	0	5	Q2	2012	11.6400	5.3544	4.0000	1
151	3001	13	0	4	Q2	2012	8.7300	3.7539	3.0000	1
151	3242	3	0	4	Q2	2012	11.6400	5.5872	4.0000	1
151	3693	3	0	12	Q4	2012	5.8200	2.1534	2.0000	1
151	3930	15	1154	10	Q4	2012	5.8200	2.5026	2.0000	1
151	4258	7	521	10	Q4	2012	8.7300	3.1428	3.0000	1
151	4364	17	0	6	Q2	2012	5.8200	2.6772	2.0000	1
151	4422	6	0	12	Q4	2012	8.7300	2.7936	3.0000	1
151	5210	17	0	2	Q1	2012	8.7300	3.2301	3.0000	1
151	5596	6	513	6	Q2	2012	11.6400	3.8412	4.0000	1
151	5882	11	0	8	Q3	2012	5.8200	2.6772	2.0000	1
151	5898	3	187	2	Q1	2012	5.8200	1.9788	2.0000	1
151	6003	13	0	8	Q3	2012	8.7300	3.4047	3.0000	1
151	6313	17	0	10	Q4	2012	8.7300	3.9285	3.0000	1
151	6553	24	0	8	Q3	2012	11.6400	3.6084	4.0000	1
151	6692	24	0	6	Q2	2012	11.6400	4.7724	4.0000	1
151	7258	7	0	5	Q2	2012	8.7300	2.9682	3.0000	1
151	7281	17	0	2	Q1	2012	5.8200	2.3280	2.0000	1
151	7384	3	0	7	Q3	2012	8.7300	4.1031	3.0000	1
151	7569	13	0	3	Q1	2012	5.8200	2.7354	2.0000	1
151	7904	6	0	12	Q4	2012	8.7300	4.0158	3.0000	1
151	8177	2	0	2	Q1	2012	2.9100	1.3386	1.0000	1
151	8207	13	0	1	Q1	2012	11.6400	5.1216	4.0000	1
151	8919	13	0	1	Q1	2012	14.5500	4.8015	5.0000	1
151	9025	13	0	3	Q1	2012	11.6400	3.8412	4.0000	1
151	9263	16	1235	11	Q4	2012	8.7300	3.4047	3.0000	1
151	9332	11	826	5	Q2	2012	8.7300	4.1031	3.0000	1
151	9535	11	824	4	Q2	2012	14.5500	4.6560	5.0000	1
151	9977	11	836	9	Q3	2012	11.6400	5.7036	4.0000	1
151	10052	2	0	10	Q4	2012	5.8200	2.3862	2.0000	1
152	154	13	0	12	Q4	2012	8.6700	3.7281	3.0000	1
152	472	17	0	9	Q3	2012	5.7800	1.7340	2.0000	1
152	739	23	1789	12	Q4	2012	8.6700	2.9478	3.0000	1
152	769	16	1216	2	Q1	2012	8.6700	3.0345	3.0000	1
152	1144	6	0	12	Q4	2012	11.5600	4.0460	4.0000	1
152	1261	24	0	9	Q3	2012	8.6700	4.0749	3.0000	1
152	1310	16	0	6	Q2	2012	8.6700	3.7281	3.0000	1
152	1351	24	0	10	Q4	2012	5.7800	2.7166	2.0000	1
152	1446	24	0	6	Q2	2012	11.5600	5.6644	4.0000	1
152	1771	2	0	12	Q4	2012	2.8900	1.0693	1.0000	1
152	1811	11	0	4	Q2	2012	5.7800	2.5432	2.0000	1
152	1813	17	1303	6	Q2	2012	8.6700	3.5547	3.0000	1
152	1832	23	0	11	Q4	2012	8.6700	3.1212	3.0000	1
152	1839	11	829	6	Q2	2012	11.5600	4.6240	4.0000	1
152	1979	3	0	6	Q2	2012	11.5600	5.6644	4.0000	1
152	2201	16	0	10	Q4	2012	5.7800	1.9652	2.0000	1
152	2201	16	1236	12	Q4	2012	8.6700	3.1212	3.0000	1
152	2304	13	0	9	Q3	2012	8.6700	3.1212	3.0000	1
152	2769	16	1220	4	Q2	2012	8.6700	3.8148	3.0000	1
152	2927	7	0	5	Q2	2012	11.5600	4.5084	4.0000	1
152	3282	6	0	6	Q2	2012	8.6700	2.6877	3.0000	1
152	3647	13	986	6	Q2	2012	8.6700	4.1616	3.0000	1
152	3735	24	0	4	Q2	2012	11.5600	5.3176	4.0000	1
152	4231	17	1293	1	Q1	2012	5.7800	1.9652	2.0000	1
152	4239	17	0	9	Q3	2012	5.7800	2.5432	2.0000	1
152	4342	13	0	1	Q1	2012	8.6700	2.6877	3.0000	1
152	4563	2	112	3	Q1	2012	2.8900	1.3005	1.0000	1
152	4611	15	0	9	Q3	2012	8.6700	3.5547	3.0000	1
152	4892	17	0	5	Q2	2012	8.6700	2.9478	3.0000	1
152	5435	7	0	9	Q3	2012	8.6700	3.0345	3.0000	1
152	5644	17	0	6	Q2	2012	5.7800	2.8322	2.0000	1
152	5648	7	0	1	Q1	2012	8.6700	4.2483	3.0000	1
152	5748	7	518	8	Q3	2012	8.6700	3.5547	3.0000	1
152	5760	13	0	4	Q2	2012	5.7800	2.6010	2.0000	1
152	5899	13	0	2	Q1	2012	8.6700	4.2483	3.0000	1
152	6018	11	0	3	Q1	2012	8.6700	4.0749	3.0000	1
152	6557	11	0	11	Q4	2012	8.6700	4.2483	3.0000	1
152	6560	17	1304	7	Q3	2012	8.6700	2.6877	3.0000	1
152	6716	6	0	8	Q3	2012	5.7800	1.8496	2.0000	1
152	6745	7	523	11	Q4	2012	8.6700	3.8148	3.0000	1
152	6805	7	0	3	Q1	2012	5.7800	2.8322	2.0000	1
152	7456	2	0	4	Q2	2012	5.7800	2.0230	2.0000	1
152	7696	23	0	8	Q3	2012	8.6700	4.2483	3.0000	1
152	7727	11	820	2	Q1	2012	8.6700	3.6414	3.0000	1
152	9176	23	0	3	Q1	2012	8.6700	2.8611	3.0000	1
152	9602	11	0	4	Q2	2012	5.7800	2.8322	2.0000	1
153	76	3	0	10	Q4	2012	10.8800	4.1344	4.0000	1
153	378	16	1233	10	Q4	2012	5.4400	1.6320	2.0000	1
153	571	3	204	9	Q3	2012	10.8800	3.5904	4.0000	1
153	741	24	1859	8	Q3	2012	10.8800	5.3312	4.0000	1
153	1053	13	0	10	Q4	2012	8.1600	2.5296	3.0000	1
153	1141	11	0	4	Q2	2012	10.8800	3.3728	4.0000	1
153	1194	24	1869	12	Q4	2012	8.1600	3.5904	3.0000	1
153	1195	11	0	6	Q2	2012	5.4400	2.5568	2.0000	1
153	1341	3	0	9	Q3	2012	8.1600	3.4272	3.0000	1
153	1416	6	0	7	Q3	2012	8.1600	2.8560	3.0000	1
153	1491	16	0	7	Q3	2012	8.1600	3.9984	3.0000	1
153	1525	7	0	12	Q4	2012	8.1600	3.0192	3.0000	1
153	1611	13	984	5	Q2	2012	10.8800	3.2640	4.0000	1
153	1649	24	0	8	Q3	2012	8.1600	3.5088	3.0000	1
153	1734	2	0	6	Q2	2012	5.4400	2.5024	2.0000	1
153	1874	17	0	9	Q3	2012	10.8800	3.6992	4.0000	1
153	2180	2	0	9	Q3	2012	5.4400	2.0672	2.0000	1
153	2185	14	1064	5	Q2	2012	5.4400	2.7200	2.0000	1
153	2194	6	526	12	Q4	2012	8.1600	2.5296	3.0000	1
153	2246	13	0	4	Q2	2012	10.8800	5.0048	4.0000	1
153	2378	16	1233	10	Q4	2012	8.1600	2.8560	3.0000	1
153	2587	16	0	12	Q4	2012	5.4400	2.1760	2.0000	1
153	2600	15	0	7	Q3	2012	8.1600	2.5296	3.0000	1
153	2677	13	0	11	Q4	2012	8.1600	3.4272	3.0000	1
153	2709	7	516	8	Q3	2012	8.1600	3.1008	3.0000	1
153	2863	17	0	12	Q4	2012	8.1600	3.0192	3.0000	1
153	3693	3	0	1	Q1	2012	8.1600	2.5296	3.0000	1
153	3796	11	0	1	Q1	2012	8.1600	3.5904	3.0000	1
153	4125	11	829	6	Q2	2012	10.8800	5.4400	4.0000	1
153	4180	7	0	6	Q2	2012	10.8800	3.6992	4.0000	1
153	4239	17	0	4	Q2	2012	10.8800	5.1136	4.0000	1
153	4422	7	0	12	Q4	2012	8.1600	3.9168	3.0000	1
153	4498	17	0	10	Q4	2012	8.1600	2.7744	3.0000	1
153	4666	13	0	9	Q3	2012	8.1600	3.7536	3.0000	1
153	4670	17	1307	8	Q3	2012	8.1600	3.0192	3.0000	1
153	4868	16	0	5	Q2	2012	5.4400	2.0128	2.0000	1
153	4892	17	0	10	Q4	2012	8.1600	3.8352	3.0000	1
153	5163	3	0	5	Q2	2012	5.4400	1.9584	2.0000	1
153	5724	11	0	7	Q3	2012	10.8800	3.5904	4.0000	1
153	5768	3	0	2	Q1	2012	5.4400	1.6864	2.0000	1
153	5825	15	0	7	Q3	2012	10.8800	5.3312	4.0000	1
153	6114	16	0	1	Q1	2012	8.1600	2.4480	3.0000	1
153	6698	13	0	7	Q3	2012	8.1600	3.7536	3.0000	1
153	6799	17	1294	2	Q1	2012	5.4400	2.5024	2.0000	1
153	6845	6	523	11	Q4	2012	8.1600	3.2640	3.0000	1
153	6948	24	0	9	Q3	2012	8.1600	2.5296	3.0000	1
153	7003	15	1154	10	Q4	2012	13.6000	6.2560	5.0000	1
153	7038	24	0	9	Q3	2012	10.8800	4.4608	4.0000	1
153	7434	11	842	12	Q4	2012	8.1600	3.0192	3.0000	1
153	7457	13	0	2	Q1	2012	8.1600	3.3456	3.0000	1
153	7618	11	0	7	Q3	2012	5.4400	2.0672	2.0000	1
153	7689	15	0	10	Q4	2012	10.8800	3.9168	4.0000	1
153	7702	16	1233	10	Q4	2012	8.1600	3.1824	3.0000	1
153	7930	11	0	4	Q2	2012	8.1600	3.3456	3.0000	1
153	8076	14	1071	8	Q3	2012	2.7200	0.8432	1.0000	1
153	8181	17	1293	1	Q1	2012	5.4400	2.2304	2.0000	1
153	8252	13	0	9	Q3	2012	5.4400	2.6112	2.0000	1
153	8275	16	0	1	Q1	2012	8.1600	3.0192	3.0000	1
153	8439	13	0	6	Q2	2012	8.1600	3.9168	3.0000	1
153	8699	7	0	12	Q4	2012	8.1600	2.7744	3.0000	1
153	8960	3	0	9	Q3	2012	8.1600	3.8352	3.0000	1
153	9453	15	0	11	Q4	2012	8.1600	3.9984	3.0000	1
153	9706	7	504	2	Q1	2012	5.4400	2.1760	2.0000	1
153	9748	24	0	7	Q3	2012	10.8800	4.7872	4.0000	1
153	9851	3	0	4	Q2	2012	5.4400	2.0672	2.0000	1
153	9851	3	0	10	Q4	2012	10.8800	3.4816	4.0000	1
153	10243	17	0	1	Q1	2012	5.4400	2.4480	2.0000	1
154	910	15	0	7	Q3	2012	7.8400	3.6064	4.0000	1
154	910	15	0	9	Q3	2012	5.8800	2.5284	3.0000	1
154	1399	24	0	7	Q3	2012	9.8000	4.1160	5.0000	1
154	1418	2	0	1	Q1	2012	1.9600	0.7252	1.0000	1
154	1611	13	0	8	Q3	2012	7.8400	2.9792	4.0000	1
154	1931	15	0	5	Q2	2012	5.8800	2.0580	3.0000	1
154	2077	23	1768	2	Q1	2012	3.9200	1.8032	2.0000	1
154	2201	16	0	3	Q1	2012	5.8800	1.8228	3.0000	1
154	2371	16	1235	11	Q4	2012	7.8400	3.5280	4.0000	1
154	2638	13	0	10	Q4	2012	5.8800	2.9400	3.0000	1
154	2829	23	1765	1	Q1	2012	5.8800	1.8816	3.0000	1
154	2850	3	0	4	Q2	2012	5.8800	2.8812	3.0000	1
154	3359	11	0	12	Q4	2012	5.8800	1.8816	3.0000	1
154	3367	6	0	5	Q2	2012	5.8800	2.1756	3.0000	1
154	3474	15	1154	10	Q4	2012	5.8800	2.3520	3.0000	1
154	3983	24	1860	8	Q3	2012	7.8400	2.9792	4.0000	1
154	4000	15	0	7	Q3	2012	7.8400	3.0576	4.0000	1
154	4029	17	1312	10	Q4	2012	3.9200	1.8424	2.0000	1
154	4109	6	0	9	Q3	2012	3.9200	1.4112	2.0000	1
154	4113	6	0	12	Q4	2012	9.8000	4.8020	5.0000	1
154	4115	7	523	11	Q4	2012	5.8800	2.1756	3.0000	1
154	4239	17	1297	3	Q1	2012	5.8800	1.7640	3.0000	1
154	4337	6	502	1	Q1	2012	3.9200	1.7248	2.0000	1
154	4498	17	0	1	Q1	2012	5.8800	1.9992	3.0000	1
154	4609	23	0	2	Q1	2012	5.8800	2.1756	3.0000	1
154	4868	16	0	7	Q3	2012	5.8800	2.8812	3.0000	1
154	4985	23	1771	3	Q1	2012	9.8000	3.5280	5.0000	1
154	5070	13	0	8	Q3	2012	5.8800	1.8228	3.0000	1
154	5141	6	0	6	Q2	2012	5.8800	2.3520	3.0000	1
154	5707	23	0	2	Q1	2012	5.8800	2.8812	3.0000	1
154	6051	11	0	3	Q1	2012	3.9200	1.2152	2.0000	1
154	6313	17	0	4	Q2	2012	5.8800	2.6460	3.0000	1
154	6530	17	0	10	Q4	2012	5.8800	2.4696	3.0000	1
154	6675	22	0	3	Q1	2012	1.9600	0.7840	1.0000	1
154	6683	17	0	11	Q4	2012	7.8400	3.2928	4.0000	1
154	6912	16	0	4	Q2	2012	7.8400	3.0576	4.0000	1
154	7190	23	0	5	Q2	2012	7.8400	3.5280	4.0000	1
154	7257	15	0	7	Q3	2012	5.8800	2.4696	3.0000	1
154	7441	24	0	9	Q3	2012	7.8400	3.6848	4.0000	1
154	7464	11	0	1	Q1	2012	7.8400	2.5088	4.0000	1
154	7797	15	0	10	Q4	2012	7.8400	2.9792	4.0000	1
154	7878	15	0	1	Q1	2012	5.8800	1.7640	3.0000	1
154	8263	11	0	11	Q4	2012	5.8800	1.9992	3.0000	1
154	8483	15	0	7	Q3	2012	5.8800	2.6460	3.0000	1
154	8737	11	0	9	Q3	2012	3.9200	1.4504	2.0000	1
154	8902	3	0	4	Q2	2012	5.8800	1.9404	3.0000	1
154	9081	6	0	2	Q1	2012	5.8800	2.1756	3.0000	1
154	9557	3	0	4	Q2	2012	7.8400	3.6064	4.0000	1
154	9631	16	0	8	Q3	2012	3.9200	1.8424	2.0000	1
154	9631	16	1216	2	Q1	2012	3.9200	1.5680	2.0000	1
154	9871	13	0	2	Q1	2012	3.9200	1.8032	2.0000	1
154	9951	3	0	12	Q4	2012	7.8400	3.5280	4.0000	1
155	99	3	0	9	Q3	2012	11.4300	4.0005	3.0000	1
155	790	13	0	2	Q1	2012	7.6200	2.8194	2.0000	1
155	1532	6	0	7	Q3	2012	7.6200	2.9718	2.0000	1
155	1619	7	504	2	Q1	2012	11.4300	4.3434	3.0000	1
155	1730	11	0	9	Q3	2012	15.2400	7.1628	4.0000	1
155	1738	6	0	9	Q3	2012	15.2400	6.5532	4.0000	1
155	1747	24	1869	12	Q4	2012	11.4300	4.6863	3.0000	1
155	2682	23	0	12	Q4	2012	7.6200	2.6670	2.0000	1
155	2863	17	0	8	Q3	2012	11.4300	4.2291	3.0000	1
155	2921	16	0	3	Q1	2012	7.6200	2.5908	2.0000	1
155	3415	15	1136	2	Q1	2012	11.4300	3.8862	3.0000	1
155	3470	17	0	9	Q3	2012	11.4300	4.6863	3.0000	1
155	3711	3	0	12	Q4	2012	15.2400	7.4676	4.0000	1
155	3922	7	0	10	Q4	2012	7.6200	2.4384	2.0000	1
155	4063	15	0	6	Q2	2012	15.2400	6.8580	4.0000	1
155	4081	24	1866	11	Q4	2012	7.6200	2.3622	2.0000	1
155	4212	24	0	9	Q3	2012	7.6200	2.2860	2.0000	1
155	4239	17	0	11	Q4	2012	15.2400	7.1628	4.0000	1
155	4909	6	523	11	Q4	2012	11.4300	4.1148	3.0000	1
155	5238	17	0	5	Q2	2012	15.2400	5.7912	4.0000	1
155	5374	16	1233	10	Q4	2012	11.4300	4.6863	3.0000	1
155	5456	14	0	2	Q1	2012	7.6200	2.5908	2.0000	1
155	5493	6	523	11	Q4	2012	11.4300	5.1435	3.0000	1
155	5704	24	0	11	Q4	2012	11.4300	4.5720	3.0000	1
155	5739	11	829	6	Q2	2012	15.2400	6.5532	4.0000	1
155	5777	7	0	8	Q3	2012	11.4300	5.3721	3.0000	1
155	5942	6	0	6	Q2	2012	15.2400	4.5720	4.0000	1
155	6505	15	0	1	Q1	2012	11.4300	3.6576	3.0000	1
155	6788	7	0	10	Q4	2012	7.6200	3.7338	2.0000	1
155	6844	11	0	2	Q1	2012	19.0500	9.5250	5.0000	1
155	7209	11	842	12	Q4	2012	11.4300	5.6007	3.0000	1
155	7526	17	0	9	Q3	2012	11.4300	4.6863	3.0000	1
155	7736	6	0	10	Q4	2012	11.4300	5.0292	3.0000	1
155	7862	16	0	3	Q1	2012	11.4300	3.8862	3.0000	1
155	8292	14	1066	6	Q2	2012	3.8100	1.6002	1.0000	1
155	8336	17	1303	6	Q2	2012	11.4300	5.4864	3.0000	1
155	8442	17	0	12	Q4	2012	11.4300	5.3721	3.0000	1
155	8526	11	0	4	Q2	2012	11.4300	4.3434	3.0000	1
155	8810	6	504	2	Q1	2012	7.6200	3.1242	2.0000	1
155	8954	7	0	12	Q4	2012	7.6200	2.7432	2.0000	1
155	9025	13	0	11	Q4	2012	15.2400	6.5532	4.0000	1
155	9032	13	0	11	Q4	2012	15.2400	5.1816	4.0000	1
155	9557	3	0	2	Q1	2012	15.2400	6.2484	4.0000	1
155	9694	7	504	2	Q1	2012	7.6200	2.7432	2.0000	1
155	9788	13	0	7	Q3	2012	11.4300	5.2578	3.0000	1
155	9900	15	1143	5	Q2	2012	19.0500	6.8580	5.0000	1
155	9924	15	0	7	Q3	2012	11.4300	4.0005	3.0000	1
156	463	23	0	6	Q2	2012	1.1000	0.3410	2.0000	1
156	560	24	0	7	Q3	2012	2.2000	0.8140	4.0000	1
156	1147	13	0	12	Q4	2012	1.1000	0.3520	2.0000	1
156	1548	13	0	1	Q1	2012	2.2000	1.0120	4.0000	1
156	1607	17	1314	11	Q4	2012	1.1000	0.5500	2.0000	1
156	1838	24	0	6	Q2	2012	2.2000	1.0120	4.0000	1
156	2020	6	506	3	Q1	2012	1.6500	0.7260	3.0000	1
156	2039	11	821	3	Q1	2012	1.6500	0.5115	3.0000	1
156	2171	23	1789	12	Q4	2012	1.6500	0.8085	3.0000	1
156	2189	7	0	9	Q3	2012	1.6500	0.7095	3.0000	1
156	2277	6	523	11	Q4	2012	1.6500	0.7260	3.0000	1
156	2553	16	0	8	Q3	2012	1.1000	0.4510	2.0000	1
156	2712	6	521	10	Q4	2012	1.1000	0.5390	2.0000	1
156	3187	24	0	1	Q1	2012	1.6500	0.6105	3.0000	1
156	3197	23	0	5	Q2	2012	2.2000	0.8800	4.0000	1
156	3228	24	0	10	Q4	2012	1.6500	0.8250	3.0000	1
156	3642	24	0	5	Q2	2012	2.2000	0.8580	4.0000	1
156	3695	13	0	11	Q4	2012	1.1000	0.4290	2.0000	1
156	3873	11	829	6	Q2	2012	2.2000	0.9240	4.0000	1
156	4143	11	0	6	Q2	2012	1.6500	0.8085	3.0000	1
156	4145	24	0	8	Q3	2012	1.6500	0.7095	3.0000	1
156	4397	16	0	11	Q4	2012	1.1000	0.5170	2.0000	1
156	4541	3	0	8	Q3	2012	1.1000	0.5390	2.0000	1
156	4649	17	0	9	Q3	2012	1.1000	0.3630	2.0000	1
156	5086	6	0	12	Q4	2012	1.1000	0.3410	2.0000	1
156	5295	16	0	7	Q3	2012	1.6500	0.5280	3.0000	1
156	5484	6	0	7	Q3	2012	1.1000	0.5170	2.0000	1
156	5683	7	0	8	Q3	2012	1.6500	0.5445	3.0000	1
156	5760	13	0	12	Q4	2012	2.2000	0.7260	4.0000	1
156	5791	11	842	12	Q4	2012	2.2000	0.7260	4.0000	1
156	6039	13	0	12	Q4	2012	2.2000	1.0120	4.0000	1
156	6500	6	0	12	Q4	2012	2.2000	0.9020	4.0000	1
156	6754	7	0	10	Q4	2012	1.6500	0.6765	3.0000	1
156	6835	16	0	6	Q2	2012	1.6500	0.4950	3.0000	1
156	6844	11	826	5	Q2	2012	2.2000	0.9020	4.0000	1
156	6889	15	0	11	Q4	2012	1.1000	0.3740	2.0000	1
156	6921	24	1847	2	Q1	2012	2.2000	0.7040	4.0000	1
156	7271	7	0	8	Q3	2012	1.1000	0.5060	2.0000	1
156	7556	17	1292	1	Q1	2012	2.7500	1.0450	5.0000	1
156	7727	11	820	2	Q1	2012	2.2000	0.7260	4.0000	1
156	7859	7	0	12	Q4	2012	2.7500	1.1550	5.0000	1
156	7951	15	0	12	Q4	2012	1.6500	0.5280	3.0000	1
156	8012	11	0	11	Q4	2012	2.2000	0.8800	4.0000	1
156	8463	23	0	6	Q2	2012	1.1000	0.4070	2.0000	1
156	8899	7	516	8	Q3	2012	1.6500	0.8250	3.0000	1
156	9072	24	0	12	Q4	2012	2.2000	0.7920	4.0000	1
156	9434	6	0	6	Q2	2012	1.6500	0.6105	3.0000	1
156	9662	6	511	5	Q2	2012	2.2000	0.9900	4.0000	1
156	9814	7	0	5	Q2	2012	1.1000	0.4180	2.0000	1
156	10238	16	0	9	Q3	2012	1.6500	0.7425	3.0000	1
157	398	13	980	3	Q1	2012	8.8500	3.2745	3.0000	1
157	448	17	0	1	Q1	2012	5.9000	1.9470	2.0000	1
157	997	3	0	11	Q4	2012	5.9000	1.8880	2.0000	1
157	1004	17	1303	6	Q2	2012	5.9000	1.8880	2.0000	1
157	1131	15	1157	12	Q4	2012	8.8500	3.8055	3.0000	1
157	1268	11	836	9	Q3	2012	11.8000	5.9000	4.0000	1
157	1309	24	0	12	Q4	2012	8.8500	2.6550	3.0000	1
157	1727	24	0	4	Q2	2012	5.9000	2.7140	2.0000	1
157	1974	22	0	9	Q3	2012	5.9000	2.9500	2.0000	1
157	2067	17	0	6	Q2	2012	8.8500	4.3365	3.0000	1
157	2663	16	0	6	Q2	2012	8.8500	3.2745	3.0000	1
157	2690	3	0	12	Q4	2012	5.9000	2.5960	2.0000	1
157	2772	24	0	11	Q4	2012	11.8000	4.1300	4.0000	1
157	2870	7	0	11	Q4	2012	8.8500	4.1595	3.0000	1
157	3130	13	0	4	Q2	2012	11.8000	5.4280	4.0000	1
157	3213	13	0	5	Q2	2012	5.9000	2.5960	2.0000	1
157	3389	7	0	11	Q4	2012	8.8500	2.8320	3.0000	1
157	3476	3	197	6	Q2	2012	8.8500	3.5400	3.0000	1
157	3692	16	0	8	Q3	2012	5.9000	2.5370	2.0000	1
157	3801	11	0	3	Q1	2012	5.9000	2.1830	2.0000	1
157	3809	6	0	6	Q2	2012	8.8500	2.7435	3.0000	1
157	3996	6	513	6	Q2	2012	5.9000	1.7700	2.0000	1
157	4257	3	0	6	Q2	2012	8.8500	2.7435	3.0000	1
157	4289	24	1853	5	Q2	2012	11.8000	5.4280	4.0000	1
157	4803	23	0	9	Q3	2012	5.9000	2.9500	2.0000	1
157	5257	13	992	9	Q3	2012	11.8000	5.1920	4.0000	1
157	5353	23	1765	1	Q1	2012	8.8500	2.8320	3.0000	1
157	5486	24	0	3	Q1	2012	8.8500	3.3630	3.0000	1
157	5590	17	1307	8	Q3	2012	5.9000	2.6550	2.0000	1
157	5903	13	0	10	Q4	2012	8.8500	2.9205	3.0000	1
157	6163	13	0	12	Q4	2012	11.8000	4.4840	4.0000	1
157	6681	17	0	12	Q4	2012	8.8500	2.7435	3.0000	1
157	6919	11	833	8	Q3	2012	8.8500	3.4515	3.0000	1
157	7149	13	0	7	Q3	2012	8.8500	2.8320	3.0000	1
157	7209	11	826	5	Q2	2012	8.8500	3.5400	3.0000	1
157	7417	7	0	3	Q1	2012	8.8500	3.0975	3.0000	1
157	7507	6	0	5	Q2	2012	11.8000	4.2480	4.0000	1
157	7702	16	0	9	Q3	2012	8.8500	4.3365	3.0000	1
157	7938	24	0	1	Q1	2012	8.8500	3.0090	3.0000	1
157	8613	2	0	2	Q1	2012	2.9500	1.2980	1.0000	1
157	8622	7	0	1	Q1	2012	11.8000	3.8940	4.0000	1
157	8851	7	0	6	Q2	2012	8.8500	3.8940	3.0000	1
157	8953	24	1853	5	Q2	2012	5.9000	2.7140	2.0000	1
157	9200	16	0	9	Q3	2012	5.9000	2.7730	2.0000	1
157	9305	2	114	4	Q2	2012	5.9000	2.8320	2.0000	1
157	9401	13	0	5	Q2	2012	11.8000	4.1300	4.0000	1
157	9504	13	0	2	Q1	2012	8.8500	2.9205	3.0000	1
158	88	11	0	4	Q2	2012	4.7400	1.4694	3.0000	1
158	188	13	0	7	Q3	2012	6.3200	2.7808	4.0000	1
158	771	15	0	8	Q3	2012	6.3200	3.1600	4.0000	1
158	970	14	0	2	Q1	2012	1.5800	0.4898	1.0000	1
158	994	13	0	1	Q1	2012	3.1600	1.2008	2.0000	1
158	1397	24	0	4	Q2	2012	4.7400	2.2752	3.0000	1
158	1532	6	0	2	Q1	2012	4.7400	1.8486	3.0000	1
158	1532	7	0	3	Q1	2012	6.3200	2.4016	4.0000	1
158	1994	15	0	11	Q4	2012	4.7400	1.9434	3.0000	1
158	2052	13	0	10	Q4	2012	4.7400	1.5168	3.0000	1
158	2237	7	0	6	Q2	2012	6.3200	2.3384	4.0000	1
158	2448	16	0	10	Q4	2012	3.1600	1.1060	2.0000	1
158	2805	2	0	8	Q3	2012	3.1600	1.0428	2.0000	1
158	2966	17	0	8	Q3	2012	6.3200	2.7176	4.0000	1
158	3205	15	0	10	Q4	2012	3.1600	1.3272	2.0000	1
158	3233	6	0	4	Q2	2012	6.3200	2.0224	4.0000	1
158	3438	11	0	5	Q2	2012	6.3200	2.8440	4.0000	1
158	3491	16	0	12	Q4	2012	4.7400	1.8960	3.0000	1
158	3632	7	0	1	Q1	2012	6.3200	2.0224	4.0000	1
158	3731	15	0	2	Q1	2012	6.3200	2.1488	4.0000	1
158	3937	13	0	5	Q2	2012	4.7400	1.7064	3.0000	1
158	4078	3	205	10	Q4	2012	6.3200	2.5912	4.0000	1
158	4185	24	0	11	Q4	2012	4.7400	1.8486	3.0000	1
158	4445	17	0	4	Q2	2012	4.7400	2.2278	3.0000	1
158	4445	17	0	6	Q2	2012	4.7400	2.3226	3.0000	1
158	4445	17	1293	1	Q1	2012	4.7400	2.2278	3.0000	1
158	4900	13	0	12	Q4	2012	4.7400	1.8960	3.0000	1
158	5373	24	0	1	Q1	2012	6.3200	2.0856	4.0000	1
158	5760	13	0	7	Q3	2012	4.7400	2.2278	3.0000	1
158	6423	17	0	4	Q2	2012	6.3200	2.8440	4.0000	1
158	6452	11	0	9	Q3	2012	3.1600	1.5800	2.0000	1
158	6647	17	0	2	Q1	2012	3.1600	1.0112	2.0000	1
158	6666	17	0	12	Q4	2012	4.7400	2.1330	3.0000	1
158	7294	6	0	9	Q3	2012	4.7400	1.7064	3.0000	1
158	7719	24	1866	11	Q4	2012	6.3200	2.9072	4.0000	1
158	7818	11	837	10	Q4	2012	6.3200	2.9704	4.0000	1
158	7887	11	0	7	Q3	2012	3.1600	1.1692	2.0000	1
158	8138	24	0	2	Q1	2012	3.1600	0.9796	2.0000	1
158	8435	17	0	1	Q1	2012	3.1600	1.5800	2.0000	1
158	8472	17	1303	6	Q2	2012	6.3200	2.6544	4.0000	1
158	8490	24	0	12	Q4	2012	4.7400	1.7538	3.0000	1
158	8542	24	0	11	Q4	2012	4.7400	1.6590	3.0000	1
158	8578	23	1768	2	Q1	2012	3.1600	1.3272	2.0000	1
158	8814	13	0	1	Q1	2012	6.3200	2.7808	4.0000	1
158	9206	17	0	9	Q3	2012	3.1600	1.3904	2.0000	1
158	9256	13	0	5	Q2	2012	6.3200	2.1488	4.0000	1
158	9286	13	0	4	Q2	2012	4.7400	2.0382	3.0000	1
158	9602	11	0	1	Q1	2012	3.1600	1.3904	2.0000	1
158	9667	23	0	10	Q4	2012	4.7400	2.0382	3.0000	1
158	9782	15	0	12	Q4	2012	3.1600	1.2956	2.0000	1
158	9817	14	0	10	Q4	2012	3.1600	1.1692	2.0000	1
158	9851	3	0	2	Q1	2012	4.7400	2.0382	3.0000	1
158	10103	2	119	7	Q3	2012	3.1600	1.1376	2.0000	1
159	949	11	829	6	Q2	2012	5.1300	1.5390	3.0000	1
159	985	24	0	11	Q4	2012	5.1300	2.2059	3.0000	1
159	1053	13	0	9	Q3	2012	3.4200	1.2654	2.0000	1
159	1210	6	0	12	Q4	2012	5.1300	1.5903	3.0000	1
159	1245	17	0	2	Q1	2012	5.1300	2.0007	3.0000	1
159	1415	16	1216	2	Q1	2012	3.4200	1.2312	2.0000	1
159	1743	6	0	11	Q4	2012	6.8400	2.7360	4.0000	1
159	1923	11	0	11	Q4	2012	5.1300	2.5137	3.0000	1
159	2129	6	0	11	Q4	2012	5.1300	1.5903	3.0000	1
159	2245	11	0	4	Q2	2012	8.5500	2.8215	5.0000	1
159	2588	23	0	5	Q2	2012	6.8400	2.1204	4.0000	1
159	2921	16	1220	4	Q2	2012	3.4200	1.1628	2.0000	1
159	3153	13	0	6	Q2	2012	6.8400	3.1464	4.0000	1
159	3187	24	1869	12	Q4	2012	5.1300	1.5903	3.0000	1
159	3253	13	0	10	Q4	2012	5.1300	2.3598	3.0000	1
159	3401	11	0	4	Q2	2012	3.4200	1.2654	2.0000	1
159	3503	6	0	12	Q4	2012	6.8400	3.4200	4.0000	1
159	3711	3	0	12	Q4	2012	5.1300	1.5903	3.0000	1
159	3802	6	0	1	Q1	2012	5.1300	2.1033	3.0000	1
159	3897	13	1000	12	Q4	2012	3.4200	1.4022	2.0000	1
159	4137	15	0	7	Q3	2012	3.4200	1.4706	2.0000	1
159	4597	17	0	5	Q2	2012	6.8400	3.4200	4.0000	1
159	4615	17	1314	11	Q4	2012	5.1300	2.2572	3.0000	1
159	4695	13	0	8	Q3	2012	3.4200	1.5732	2.0000	1
159	4843	24	0	11	Q4	2012	8.5500	3.2490	5.0000	1
159	4881	13	0	9	Q3	2012	8.5500	4.1040	5.0000	1
159	5127	15	0	6	Q2	2012	5.1300	1.7442	3.0000	1
159	5201	6	0	5	Q2	2012	5.1300	2.1033	3.0000	1
159	6056	15	0	5	Q2	2012	5.1300	2.4111	3.0000	1
159	7133	22	0	3	Q1	2012	3.4200	1.7100	2.0000	1
159	7743	3	205	10	Q4	2012	5.1300	1.8981	3.0000	1
159	7852	11	836	9	Q3	2012	6.8400	2.3940	4.0000	1
159	7865	22	0	6	Q2	2012	3.4200	1.0602	2.0000	1
159	7971	24	0	8	Q3	2012	3.4200	1.5732	2.0000	1
159	8298	13	0	1	Q1	2012	5.1300	2.1033	3.0000	1
159	9176	23	0	3	Q1	2012	5.1300	2.5137	3.0000	1
159	9282	24	0	5	Q2	2012	6.8400	2.4624	4.0000	1
159	9346	15	1146	7	Q3	2012	5.1300	2.1033	3.0000	1
159	9459	11	0	1	Q1	2012	3.4200	1.6758	2.0000	1
159	9570	15	1152	9	Q3	2012	5.1300	2.1033	3.0000	1
159	9943	7	0	3	Q1	2012	5.1300	1.8981	3.0000	1
159	10031	24	0	6	Q2	2012	6.8400	2.3940	4.0000	1
160	453	24	0	11	Q4	2012	6.3900	2.6199	3.0000	1
160	484	13	0	5	Q2	2012	4.2600	1.4484	2.0000	1
160	711	17	0	3	Q1	2012	4.2600	1.3206	2.0000	1
160	760	3	0	1	Q1	2012	4.2600	2.0874	2.0000	1
160	819	13	0	11	Q4	2012	4.2600	1.6188	2.0000	1
160	937	6	0	3	Q1	2012	8.5200	3.7488	4.0000	1
160	1173	13	0	7	Q3	2012	4.2600	1.3206	2.0000	1
160	1310	16	0	5	Q2	2012	4.2600	2.0022	2.0000	1
160	1328	17	1292	1	Q1	2012	6.3900	2.4921	3.0000	1
160	1528	16	1233	10	Q4	2012	8.5200	3.6636	4.0000	1
160	1631	24	0	7	Q3	2012	8.5200	2.8968	4.0000	1
160	1666	6	0	11	Q4	2012	6.3900	2.6199	3.0000	1
160	2143	17	0	10	Q4	2012	4.2600	1.7892	2.0000	1
160	2266	7	516	8	Q3	2012	8.5200	3.4932	4.0000	1
160	2313	24	0	2	Q1	2012	10.6500	3.1950	5.0000	1
160	2648	24	0	12	Q4	2012	8.5200	2.8116	4.0000	1
160	2915	7	516	8	Q3	2012	4.2600	1.3206	2.0000	1
160	2921	16	0	3	Q1	2012	6.3900	2.7477	3.0000	1
160	3187	24	0	1	Q1	2012	6.3900	2.4921	3.0000	1
160	3327	7	0	12	Q4	2012	6.3900	2.6199	3.0000	1
160	3491	16	0	2	Q1	2012	6.3900	2.3643	3.0000	1
160	4324	15	1152	9	Q3	2012	6.3900	2.3643	3.0000	1
160	4649	17	0	12	Q4	2012	4.2600	1.5762	2.0000	1
160	4695	13	0	7	Q3	2012	4.2600	2.0448	2.0000	1
160	4958	23	0	10	Q4	2012	4.2600	1.9170	2.0000	1
160	5158	3	185	1	Q1	2012	6.3900	2.7477	3.0000	1
160	5256	17	1304	7	Q3	2012	6.3900	2.3004	3.0000	1
160	6321	14	1058	2	Q1	2012	4.2600	2.0448	2.0000	1
160	6647	17	0	7	Q3	2012	4.2600	1.9596	2.0000	1
160	6751	22	0	8	Q3	2012	6.3900	2.2365	3.0000	1
160	6951	15	0	2	Q1	2012	4.2600	1.3206	2.0000	1
160	7031	11	0	7	Q3	2012	8.5200	3.1524	4.0000	1
160	7192	2	0	10	Q4	2012	4.2600	2.0874	2.0000	1
160	7529	17	1307	8	Q3	2012	6.3900	2.1726	3.0000	1
160	7694	13	980	3	Q1	2012	6.3900	2.8755	3.0000	1
160	8000	7	505	2	Q1	2012	4.2600	1.7040	2.0000	1
160	8406	7	0	4	Q2	2012	6.3900	3.0033	3.0000	1
160	8504	13	0	7	Q3	2012	8.5200	3.4932	4.0000	1
160	8551	17	0	1	Q1	2012	10.6500	5.2185	5.0000	1
160	8906	11	821	2	Q1	2012	6.3900	2.3643	3.0000	1
160	8947	3	0	5	Q2	2012	4.2600	1.9596	2.0000	1
160	9194	17	0	6	Q2	2012	6.3900	3.0672	3.0000	1
160	9224	17	0	12	Q4	2012	6.3900	2.0448	3.0000	1
160	9231	11	0	5	Q2	2012	6.3900	3.0033	3.0000	1
160	9309	17	0	1	Q1	2012	6.3900	1.9809	3.0000	1
160	9557	3	0	3	Q1	2012	8.5200	3.5784	4.0000	1
160	9588	6	523	11	Q4	2012	4.2600	2.0874	2.0000	1
160	9602	11	824	4	Q2	2012	8.5200	3.6636	4.0000	1
160	9686	6	510	5	Q2	2012	8.5200	3.7488	4.0000	1
160	9794	2	0	5	Q2	2012	2.1300	0.9798	1.0000	1
160	10015	17	0	12	Q4	2012	8.5200	2.5560	4.0000	1
160	10222	7	504	2	Q1	2012	6.3900	2.3004	3.0000	1
161	208	13	0	8	Q3	2012	4.5600	1.4592	3.0000	1
161	594	15	1141	4	Q2	2012	3.0400	1.0032	2.0000	1
161	638	11	841	12	Q4	2012	6.0800	2.0672	4.0000	1
161	870	24	0	9	Q3	2012	4.5600	1.6872	3.0000	1
161	891	6	0	12	Q4	2012	4.5600	1.8696	3.0000	1
161	1297	16	0	1	Q1	2012	3.0400	1.1856	2.0000	1
161	1445	15	0	11	Q4	2012	4.5600	2.0520	3.0000	1
161	1528	16	0	10	Q4	2012	4.5600	2.0064	3.0000	1
161	1718	13	0	11	Q4	2012	6.0800	2.6144	4.0000	1
161	1794	13	0	7	Q3	2012	6.0800	2.6752	4.0000	1
161	1850	16	0	3	Q1	2012	4.5600	1.6872	3.0000	1
161	1940	13	0	10	Q4	2012	4.5600	1.4592	3.0000	1
161	2143	17	0	1	Q1	2012	3.0400	1.2768	2.0000	1
161	2523	6	513	6	Q2	2012	6.0800	1.9456	4.0000	1
161	2553	16	0	1	Q1	2012	4.5600	2.0520	3.0000	1
161	2553	16	1233	10	Q4	2012	4.5600	1.6416	3.0000	1
161	2723	3	0	7	Q3	2012	4.5600	2.0976	3.0000	1
161	3370	7	526	12	Q4	2012	4.5600	1.4592	3.0000	1
161	3509	24	1856	6	Q2	2012	4.5600	1.7784	3.0000	1
161	3627	3	0	4	Q2	2012	4.5600	1.8696	3.0000	1
161	3719	23	1778	7	Q3	2012	6.0800	1.9456	4.0000	1
161	3725	23	0	10	Q4	2012	4.5600	2.2800	3.0000	1
161	4016	7	0	3	Q1	2012	7.6000	2.7360	5.0000	1
161	4029	17	0	10	Q4	2012	3.0400	0.9424	2.0000	1
161	4065	3	0	6	Q2	2012	3.0400	1.1552	2.0000	1
161	4116	11	0	11	Q4	2012	4.5600	1.4592	3.0000	1
161	4160	24	0	5	Q2	2012	4.5600	2.0520	3.0000	1
161	4231	17	0	10	Q4	2012	6.0800	2.7360	4.0000	1
161	4351	23	1789	12	Q4	2012	6.0800	2.1280	4.0000	1
161	4541	3	207	11	Q4	2012	6.0800	2.3104	4.0000	1
161	4564	17	0	4	Q2	2012	3.0400	0.9424	2.0000	1
161	4942	11	841	12	Q4	2012	6.0800	2.1888	4.0000	1
161	4954	11	0	3	Q1	2012	7.6000	3.8000	5.0000	1
161	5092	17	0	11	Q4	2012	6.0800	2.3104	4.0000	1
161	5174	16	0	8	Q3	2012	4.5600	1.6416	3.0000	1
161	5486	24	0	7	Q3	2012	3.0400	1.3072	2.0000	1
161	5533	13	0	6	Q2	2012	3.0400	1.0944	2.0000	1
161	5821	15	0	10	Q4	2012	4.5600	1.7784	3.0000	1
161	5954	6	523	11	Q4	2012	6.0800	2.0672	4.0000	1
161	6180	13	0	1	Q1	2012	3.0400	1.3984	2.0000	1
161	6348	16	0	6	Q2	2012	3.0400	1.0032	2.0000	1
161	7075	15	0	11	Q4	2012	3.0400	0.9728	2.0000	1
161	7085	11	820	2	Q1	2012	4.5600	2.2344	3.0000	1
161	7269	13	988	7	Q3	2012	4.5600	1.6872	3.0000	1
161	7391	7	505	2	Q1	2012	4.5600	1.4136	3.0000	1
161	8193	6	0	6	Q2	2012	6.0800	1.8240	4.0000	1
161	8472	17	0	2	Q1	2012	4.5600	2.0976	3.0000	1
161	8840	17	0	8	Q3	2012	4.5600	1.7784	3.0000	1
161	8945	23	0	6	Q2	2012	3.0400	1.2464	2.0000	1
161	9016	23	0	8	Q3	2012	6.0800	2.1280	4.0000	1
161	9437	15	1138	3	Q1	2012	6.0800	2.6752	4.0000	1
161	9815	16	0	7	Q3	2012	6.0800	2.6144	4.0000	1
161	10015	17	1304	7	Q3	2012	4.5600	1.4592	3.0000	1
161	10210	7	0	4	Q2	2012	4.5600	1.8696	3.0000	1
161	10221	15	0	1	Q1	2012	4.5600	2.0520	3.0000	1
162	76	3	207	11	Q4	2012	11.4000	5.7000	4.0000	1
162	476	7	0	4	Q2	2012	11.4000	5.5860	4.0000	1
162	569	23	0	12	Q4	2012	11.4000	4.3320	4.0000	1
162	602	17	0	10	Q4	2012	5.7000	1.8810	2.0000	1
162	769	16	1223	6	Q2	2012	5.7000	2.1090	2.0000	1
162	1069	7	0	12	Q4	2012	8.5500	3.3345	3.0000	1
162	1070	3	207	11	Q4	2012	5.7000	1.8240	2.0000	1
162	1352	17	0	10	Q4	2012	11.4000	5.1300	4.0000	1
162	1917	23	1773	4	Q2	2012	5.7000	2.5650	2.0000	1
162	1979	3	0	7	Q3	2012	8.5500	3.4200	3.0000	1
162	2086	13	0	3	Q1	2012	8.5500	2.7360	3.0000	1
162	2158	11	0	7	Q3	2012	8.5500	2.8215	3.0000	1
162	2280	13	0	7	Q3	2012	11.4000	5.2440	4.0000	1
162	2921	16	0	12	Q4	2012	8.5500	4.0185	3.0000	1
162	3205	15	0	10	Q4	2012	11.4000	5.4720	4.0000	1
162	3286	22	0	3	Q1	2012	2.8500	0.8835	1.0000	1
162	3325	13	980	3	Q1	2012	8.5500	4.1895	3.0000	1
162	3425	11	0	11	Q4	2012	8.5500	2.7360	3.0000	1
162	3539	17	0	2	Q1	2012	8.5500	3.7620	3.0000	1
162	3938	13	976	1	Q1	2012	8.5500	3.0780	3.0000	1
162	4231	17	0	7	Q3	2012	8.5500	4.2750	3.0000	1
162	4518	13	0	1	Q1	2012	8.5500	4.2750	3.0000	1
162	4552	17	1304	7	Q3	2012	11.4000	4.5600	4.0000	1
162	4557	22	1701	7	Q3	2012	5.7000	2.4510	2.0000	1
162	4881	13	0	9	Q3	2012	5.7000	2.2800	2.0000	1
162	4998	3	0	11	Q4	2012	5.7000	2.1090	2.0000	1
162	5163	3	0	7	Q3	2012	8.5500	3.4200	3.0000	1
162	5501	17	0	4	Q2	2012	8.5500	2.9070	3.0000	1
162	5715	11	818	1	Q1	2012	5.7000	1.8240	2.0000	1
162	6017	11	829	6	Q2	2012	8.5500	3.6765	3.0000	1
162	6623	14	0	7	Q3	2012	2.8500	1.0830	1.0000	1
162	6705	24	0	1	Q1	2012	8.5500	3.3345	3.0000	1
162	6760	17	1307	8	Q3	2012	11.4000	5.0160	4.0000	1
162	6889	15	0	7	Q3	2012	5.7000	1.9950	2.0000	1
162	6893	7	0	10	Q4	2012	11.4000	3.6480	4.0000	1
162	7327	15	0	11	Q4	2012	11.4000	5.3580	4.0000	1
162	7502	16	1216	2	Q1	2012	5.7000	1.7670	2.0000	1
162	7678	23	0	6	Q2	2012	8.5500	3.1635	3.0000	1
162	7884	11	0	3	Q1	2012	8.5500	4.1895	3.0000	1
162	7897	15	0	2	Q1	2012	14.2500	6.2700	5.0000	1
162	8007	24	1845	1	Q1	2012	8.5500	3.9330	3.0000	1
162	8089	17	1303	6	Q2	2012	8.5500	2.6505	3.0000	1
162	8324	24	0	10	Q4	2012	5.7000	2.3370	2.0000	1
162	8407	15	1140	4	Q2	2012	8.5500	3.4200	3.0000	1
162	8647	3	0	12	Q4	2012	8.5500	3.1635	3.0000	1
162	8660	6	0	8	Q3	2012	8.5500	3.7620	3.0000	1
162	8935	15	0	9	Q3	2012	8.5500	3.3345	3.0000	1
162	9213	11	0	1	Q1	2012	11.4000	5.2440	4.0000	1
162	9297	13	0	12	Q4	2012	8.5500	3.6765	3.0000	1
162	9353	15	0	11	Q4	2012	5.7000	2.1090	2.0000	1
162	9524	3	199	7	Q3	2012	8.5500	4.1895	3.0000	1
162	9673	13	980	3	Q1	2012	8.5500	3.4200	3.0000	1
162	9745	17	0	9	Q3	2012	8.5500	3.1635	3.0000	1
162	9797	16	1220	4	Q2	2012	11.4000	4.9020	4.0000	1
162	9928	16	0	12	Q4	2012	8.5500	4.1895	3.0000	1
162	10210	7	518	8	Q3	2012	11.4000	3.6480	4.0000	1
163	128	13	986	6	Q2	2012	7.1400	3.2844	3.0000	1
163	265	11	0	11	Q4	2012	7.1400	3.4986	3.0000	1
163	350	6	0	12	Q4	2012	9.5200	3.5224	4.0000	1
163	991	24	0	4	Q2	2012	4.7600	2.2372	2.0000	1
163	1271	13	0	3	Q1	2012	7.1400	2.9274	3.0000	1
163	1683	6	518	8	Q3	2012	7.1400	2.6418	3.0000	1
163	1701	13	0	11	Q4	2012	7.1400	2.7132	3.0000	1
163	1844	3	0	4	Q2	2012	7.1400	2.2134	3.0000	1
163	2553	16	1231	9	Q3	2012	9.5200	4.1888	4.0000	1
163	3267	23	1775	5	Q2	2012	7.1400	2.7846	3.0000	1
163	3286	22	0	10	Q4	2012	2.3800	1.1900	1.0000	1
163	3387	11	0	7	Q3	2012	7.1400	2.2134	3.0000	1
163	3567	16	0	8	Q3	2012	9.5200	4.6648	4.0000	1
163	3639	24	0	12	Q4	2012	7.1400	2.8560	3.0000	1
163	3650	15	0	2	Q1	2012	7.1400	2.6418	3.0000	1
163	3809	6	0	10	Q4	2012	7.1400	2.9274	3.0000	1
163	3838	17	0	7	Q3	2012	7.1400	2.9274	3.0000	1
163	3911	7	0	6	Q2	2012	7.1400	2.6418	3.0000	1
163	4161	7	504	2	Q1	2012	9.5200	4.3792	4.0000	1
163	4234	3	0	4	Q2	2012	9.5200	2.8560	4.0000	1
163	4258	7	521	10	Q4	2012	9.5200	4.2840	4.0000	1
163	4457	22	0	3	Q1	2012	2.3800	1.0472	1.0000	1
163	4727	16	0	4	Q2	2012	11.9000	5.3550	5.0000	1
163	4727	16	1233	10	Q4	2012	7.1400	3.4272	3.0000	1
163	4881	13	0	9	Q3	2012	9.5200	3.8080	4.0000	1
163	5061	7	0	10	Q4	2012	11.9000	5.4740	5.0000	1
163	5063	3	195	5	Q2	2012	7.1400	3.2130	3.0000	1
163	5067	17	0	11	Q4	2012	4.7600	1.7612	2.0000	1
163	5144	6	0	10	Q4	2012	7.1400	2.5704	3.0000	1
163	5295	16	0	6	Q2	2012	7.1400	2.4990	3.0000	1
163	5633	13	0	9	Q3	2012	7.1400	2.6418	3.0000	1
163	5674	7	0	5	Q2	2012	7.1400	2.2848	3.0000	1
163	5877	17	1303	6	Q2	2012	7.1400	2.6418	3.0000	1
163	5924	13	0	3	Q1	2012	9.5200	3.1416	4.0000	1
163	6288	13	0	7	Q3	2012	7.1400	3.5700	3.0000	1
163	6301	15	0	8	Q3	2012	9.5200	3.1416	4.0000	1
163	6442	7	0	7	Q3	2012	7.1400	3.0702	3.0000	1
163	6622	11	0	4	Q2	2012	7.1400	3.1416	3.0000	1
163	6690	17	1307	8	Q3	2012	4.7600	1.5708	2.0000	1
163	6816	11	0	8	Q3	2012	9.5200	3.0464	4.0000	1
163	7078	14	0	8	Q3	2012	4.7600	2.1896	2.0000	1
163	7165	6	522	10	Q4	2012	7.1400	2.8560	3.0000	1
163	7365	13	1000	12	Q4	2012	7.1400	2.7846	3.0000	1
163	7413	3	188	2	Q1	2012	4.7600	1.9992	2.0000	1
163	7438	2	0	10	Q4	2012	4.7600	1.7136	2.0000	1
163	7457	13	0	2	Q1	2012	7.1400	2.5704	3.0000	1
163	7521	13	0	4	Q2	2012	7.1400	2.7846	3.0000	1
163	7618	11	826	5	Q2	2012	4.7600	2.1420	2.0000	1
163	7800	11	0	12	Q4	2012	9.5200	3.0464	4.0000	1
163	8695	15	1141	4	Q2	2012	9.5200	3.0464	4.0000	1
163	9065	13	984	5	Q2	2012	9.5200	3.1416	4.0000	1
163	9271	17	0	8	Q3	2012	7.1400	3.3558	3.0000	1
163	9343	11	0	11	Q4	2012	11.9000	5.4740	5.0000	1
163	9745	17	1312	10	Q4	2012	9.5200	4.0936	4.0000	1
163	9780	15	0	9	Q3	2012	4.7600	1.7136	2.0000	1
163	10031	24	0	9	Q3	2012	9.5200	4.4744	4.0000	1
163	10104	7	505	2	Q1	2012	9.5200	2.9512	4.0000	1
163	10225	23	0	11	Q4	2012	7.1400	3.4986	3.0000	1
164	161	24	1856	6	Q2	2012	11.8800	4.1580	4.0000	1
164	376	11	821	2	Q1	2012	5.9400	2.6730	2.0000	1
164	476	6	0	2	Q1	2012	8.9100	2.6730	3.0000	1
164	645	11	0	11	Q4	2012	8.9100	4.0095	3.0000	1
164	760	3	0	4	Q2	2012	11.8800	4.5144	4.0000	1
164	939	7	0	6	Q2	2012	11.8800	4.6332	4.0000	1
164	1064	24	0	9	Q3	2012	5.9400	2.0790	2.0000	1
164	1339	13	0	8	Q3	2012	5.9400	2.0196	2.0000	1
164	1375	15	0	7	Q3	2012	11.8800	4.5144	4.0000	1
164	1583	15	0	3	Q1	2012	11.8800	5.5836	4.0000	1
164	1862	17	0	12	Q4	2012	8.9100	4.3659	3.0000	1
164	2193	7	0	10	Q4	2012	8.9100	4.4550	3.0000	1
164	2245	11	0	9	Q3	2012	8.9100	3.9204	3.0000	1
164	2378	16	0	12	Q4	2012	11.8800	4.8708	4.0000	1
164	2424	6	508	4	Q2	2012	8.9100	3.1185	3.0000	1
164	2751	6	0	10	Q4	2012	8.9100	3.8313	3.0000	1
164	2955	7	0	12	Q4	2012	8.9100	3.9204	3.0000	1
164	3319	11	0	7	Q3	2012	8.9100	3.6531	3.0000	1
164	3418	3	0	12	Q4	2012	5.9400	2.7918	2.0000	1
164	3500	15	0	7	Q3	2012	5.9400	2.6136	2.0000	1
164	3552	17	0	4	Q2	2012	8.9100	2.8512	3.0000	1
164	3825	22	0	3	Q1	2012	8.9100	4.0095	3.0000	1
164	3906	15	1136	2	Q1	2012	5.9400	1.9602	2.0000	1
164	4194	24	1845	1	Q1	2012	5.9400	2.7324	2.0000	1
164	4228	15	0	6	Q2	2012	8.9100	4.0986	3.0000	1
164	4279	7	0	11	Q4	2012	8.9100	3.0294	3.0000	1
164	4324	15	1152	9	Q3	2012	11.8800	4.6332	4.0000	1
164	4606	3	0	5	Q2	2012	8.9100	3.6531	3.0000	1
164	4611	15	1136	2	Q1	2012	5.9400	1.9008	2.0000	1
164	4693	3	0	8	Q3	2012	8.9100	4.2768	3.0000	1
164	4824	3	0	6	Q2	2012	11.8800	3.8016	4.0000	1
164	4856	15	1140	4	Q2	2012	8.9100	2.9403	3.0000	1
164	5060	13	0	1	Q1	2012	8.9100	4.0095	3.0000	1
164	5353	23	1776	6	Q2	2012	8.9100	3.2967	3.0000	1
164	5432	16	0	4	Q2	2012	8.9100	4.4550	3.0000	1
164	5607	7	0	4	Q2	2012	11.8800	5.9400	4.0000	1
164	6009	11	820	2	Q1	2012	8.9100	3.2967	3.0000	1
164	6047	17	0	6	Q2	2012	8.9100	2.9403	3.0000	1
164	6544	13	0	11	Q4	2012	8.9100	3.2967	3.0000	1
164	6617	6	0	3	Q1	2012	8.9100	3.0294	3.0000	1
164	6957	16	0	3	Q1	2012	8.9100	4.1877	3.0000	1
164	7066	14	0	11	Q4	2012	5.9400	2.6136	2.0000	1
164	7312	24	1850	3	Q1	2012	11.8800	3.5640	4.0000	1
164	7522	13	0	11	Q4	2012	11.8800	5.4648	4.0000	1
164	7584	6	524	11	Q4	2012	8.9100	3.6531	3.0000	1
164	7769	11	837	10	Q4	2012	8.9100	4.0095	3.0000	1
164	8206	23	1773	4	Q2	2012	11.8800	3.5640	4.0000	1
164	8259	15	0	1	Q1	2012	5.9400	2.6730	2.0000	1
164	8717	17	1307	8	Q3	2012	11.8800	5.9400	4.0000	1
164	8924	24	0	5	Q2	2012	8.9100	3.2967	3.0000	1
164	9401	13	0	8	Q3	2012	11.8800	3.9204	4.0000	1
164	9498	23	0	1	Q1	2012	5.9400	2.7324	2.0000	1
164	9633	7	0	8	Q3	2012	5.9400	2.9700	2.0000	1
164	9745	17	0	9	Q3	2012	14.8500	6.9795	5.0000	1
164	9815	16	0	8	Q3	2012	11.8800	5.1084	4.0000	1
165	96	11	0	9	Q3	2012	3.5000	1.6450	2.0000	1
165	192	16	0	8	Q3	2012	3.5000	1.1200	2.0000	1
165	392	13	976	1	Q1	2012	3.5000	1.1550	2.0000	1
165	511	16	1233	10	Q4	2012	5.2500	2.1000	3.0000	1
165	552	11	841	12	Q4	2012	7.0000	3.0800	4.0000	1
165	702	24	0	12	Q4	2012	5.2500	1.8375	3.0000	1
165	870	24	0	6	Q2	2012	5.2500	2.6250	3.0000	1
165	1197	23	0	11	Q4	2012	3.5000	1.6800	2.0000	1
165	1615	17	1293	1	Q1	2012	5.2500	2.3625	3.0000	1
165	1720	16	0	5	Q2	2012	3.5000	1.2600	2.0000	1
165	1743	6	0	4	Q2	2012	7.0000	2.1700	4.0000	1
165	1810	2	0	4	Q2	2012	3.5000	1.6800	2.0000	1
165	1848	11	0	3	Q1	2012	5.2500	2.2575	3.0000	1
165	1896	22	0	5	Q2	2012	3.5000	1.5750	2.0000	1
165	2075	13	0	4	Q2	2012	3.5000	1.0850	2.0000	1
165	2378	16	0	1	Q1	2012	3.5000	1.0850	2.0000	1
165	2397	11	0	9	Q3	2012	3.5000	1.4700	2.0000	1
165	2829	23	1778	7	Q3	2012	3.5000	1.2600	2.0000	1
165	3352	6	0	5	Q2	2012	7.0000	2.1700	4.0000	1
165	3589	13	0	7	Q3	2012	5.2500	2.6250	3.0000	1
165	4340	17	1311	10	Q4	2012	3.5000	1.1900	2.0000	1
165	4417	3	199	7	Q3	2012	7.0000	3.1500	4.0000	1
165	4682	15	1136	2	Q1	2012	8.7500	3.4125	5.0000	1
165	4691	17	0	11	Q4	2012	7.0000	3.0800	4.0000	1
165	5174	16	0	9	Q3	2012	3.5000	1.1900	2.0000	1
165	5353	23	0	2	Q1	2012	5.2500	1.6800	3.0000	1
165	5542	16	0	6	Q2	2012	3.5000	1.2600	2.0000	1
165	6098	3	202	8	Q3	2012	7.0000	3.1500	4.0000	1
165	6105	23	0	4	Q2	2012	5.2500	1.6800	3.0000	1
165	6309	2	0	8	Q3	2012	3.5000	1.2950	2.0000	1
165	6564	13	0	6	Q2	2012	3.5000	1.7500	2.0000	1
165	6651	11	0	9	Q3	2012	3.5000	1.2600	2.0000	1
165	6830	22	0	11	Q4	2012	1.7500	0.7000	1.0000	1
165	6894	24	1869	12	Q4	2012	3.5000	1.2950	2.0000	1
165	7211	24	1845	1	Q1	2012	5.2500	1.9425	3.0000	1
165	7257	15	0	7	Q3	2012	5.2500	1.8900	3.0000	1
165	7852	11	836	9	Q3	2012	7.0000	2.3100	4.0000	1
165	8390	24	0	10	Q4	2012	7.0000	3.4300	4.0000	1
165	8551	17	0	1	Q1	2012	3.5000	1.4350	2.0000	1
165	8782	7	504	2	Q1	2012	5.2500	2.3100	3.0000	1
165	8966	3	0	6	Q2	2012	3.5000	1.6100	2.0000	1
165	9109	6	0	6	Q2	2012	5.2500	2.4150	3.0000	1
165	9548	15	0	1	Q1	2012	5.2500	1.6800	3.0000	1
165	9979	6	523	11	Q4	2012	8.7500	3.8500	5.0000	1
165	10106	13	0	5	Q2	2012	8.7500	4.2875	5.0000	1
166	143	7	0	6	Q2	2012	9.8800	4.9400	4.0000	1
166	296	6	0	9	Q3	2012	7.4100	3.3345	3.0000	1
166	605	7	504	2	Q1	2012	7.4100	2.5935	3.0000	1
166	806	17	1307	8	Q3	2012	4.9400	2.4206	2.0000	1
166	1638	11	0	9	Q3	2012	7.4100	2.3712	3.0000	1
166	1643	24	1866	11	Q4	2012	9.8800	4.3472	4.0000	1
166	1666	6	0	9	Q3	2012	4.9400	1.6302	2.0000	1
166	1957	13	0	5	Q2	2012	7.4100	3.4086	3.0000	1
166	2019	16	0	5	Q2	2012	9.8800	4.7424	4.0000	1
166	2204	3	0	1	Q1	2012	7.4100	3.2604	3.0000	1
166	2245	11	0	10	Q4	2012	12.3500	6.0515	5.0000	1
166	2533	7	0	5	Q2	2012	7.4100	2.3712	3.0000	1
166	2533	7	0	8	Q3	2012	7.4100	3.1122	3.0000	1
166	3037	24	0	4	Q2	2012	7.4100	2.8899	3.0000	1
166	3819	23	1765	1	Q1	2012	7.4100	2.7417	3.0000	1
166	4065	3	0	6	Q2	2012	7.4100	3.2604	3.0000	1
166	4251	7	0	10	Q4	2012	9.8800	4.5448	4.0000	1
166	4567	23	0	6	Q2	2012	7.4100	3.1863	3.0000	1
166	4998	3	207	11	Q4	2012	4.9400	1.8772	2.0000	1
166	5011	24	1851	4	Q2	2012	9.8800	4.5448	4.0000	1
166	5085	24	1847	2	Q1	2012	7.4100	3.6309	3.0000	1
166	5528	24	1853	5	Q2	2012	9.8800	3.1616	4.0000	1
166	5742	16	0	6	Q2	2012	4.9400	1.5314	2.0000	1
166	6001	17	0	4	Q2	2012	4.9400	1.9760	2.0000	1
166	6142	24	0	5	Q2	2012	7.4100	2.4453	3.0000	1
166	6474	15	0	6	Q2	2012	9.8800	3.7544	4.0000	1
166	6965	24	0	4	Q2	2012	7.4100	3.7050	3.0000	1
166	7028	15	0	10	Q4	2012	7.4100	2.5194	3.0000	1
166	7132	13	0	7	Q3	2012	4.9400	1.7784	2.0000	1
166	7354	3	199	7	Q3	2012	4.9400	1.9760	2.0000	1
166	7354	3	205	10	Q4	2012	4.9400	2.4700	2.0000	1
166	7365	13	0	11	Q4	2012	7.4100	3.0381	3.0000	1
166	7536	7	0	7	Q3	2012	12.3500	5.3105	5.0000	1
166	7632	15	0	7	Q3	2012	9.8800	3.7544	4.0000	1
166	7678	23	0	6	Q2	2012	7.4100	2.8899	3.0000	1
166	7835	13	0	1	Q1	2012	7.4100	3.3345	3.0000	1
166	7907	6	508	4	Q2	2012	4.9400	2.4700	2.0000	1
166	7972	6	0	6	Q2	2012	7.4100	2.4453	3.0000	1
166	8235	22	0	1	Q1	2012	2.4700	0.7657	1.0000	1
166	8370	11	821	2	Q1	2012	7.4100	2.7417	3.0000	1
166	8754	7	0	6	Q2	2012	4.9400	2.2724	2.0000	1
166	8841	13	0	6	Q2	2012	4.9400	2.0748	2.0000	1
166	8907	3	0	9	Q3	2012	9.8800	3.8532	4.0000	1
166	8945	23	1769	3	Q1	2012	7.4100	2.9640	3.0000	1
166	8960	3	0	5	Q2	2012	7.4100	2.2971	3.0000	1
166	9710	6	513	6	Q2	2012	4.9400	1.7784	2.0000	1
166	9745	17	0	12	Q4	2012	9.8800	3.6556	4.0000	1
166	9801	11	842	12	Q4	2012	9.8800	3.7544	4.0000	1
166	9867	13	0	11	Q4	2012	7.4100	3.3345	3.0000	1
166	9928	16	0	3	Q1	2012	9.8800	4.1496	4.0000	1
167	603	24	0	2	Q1	2012	1.8000	0.8460	3.0000	1
167	734	7	0	10	Q4	2012	2.4000	1.0320	4.0000	1
167	734	6	522	10	Q4	2012	2.4000	1.0320	4.0000	1
167	764	6	0	6	Q2	2012	1.2000	0.4200	2.0000	1
167	806	17	0	2	Q1	2012	1.2000	0.5760	2.0000	1
167	917	7	0	9	Q3	2012	1.8000	0.8100	3.0000	1
167	1079	7	0	5	Q2	2012	2.4000	1.1760	4.0000	1
167	1491	16	1223	6	Q2	2012	1.8000	0.5400	3.0000	1
167	1839	11	0	10	Q4	2012	1.8000	0.6840	3.0000	1
167	1953	7	0	11	Q4	2012	1.8000	0.7920	3.0000	1
167	2371	16	1235	11	Q4	2012	1.8000	0.7560	3.0000	1
167	2437	3	0	11	Q4	2012	1.8000	0.7740	3.0000	1
167	2756	3	187	2	Q1	2012	1.8000	0.8280	3.0000	1
167	3020	13	0	5	Q2	2012	1.8000	0.9000	3.0000	1
167	3020	13	980	3	Q1	2012	1.8000	0.8640	3.0000	1
167	3236	15	1157	12	Q4	2012	3.0000	0.9900	5.0000	1
167	3297	6	0	12	Q4	2012	1.8000	0.7920	3.0000	1
167	3470	17	1314	11	Q4	2012	1.8000	0.8280	3.0000	1
167	3706	13	0	6	Q2	2012	1.2000	0.4920	2.0000	1
167	4017	15	0	5	Q2	2012	3.0000	1.0500	5.0000	1
167	4090	7	514	7	Q3	2012	2.4000	0.8160	4.0000	1
167	4315	17	0	3	Q1	2012	1.8000	0.7920	3.0000	1
167	4436	3	0	3	Q1	2012	1.8000	0.6120	3.0000	1
167	4522	17	0	9	Q3	2012	1.2000	0.5280	2.0000	1
167	4670	17	1297	3	Q1	2012	1.8000	0.7920	3.0000	1
167	4693	3	207	11	Q4	2012	1.8000	0.7920	3.0000	1
167	4938	13	0	8	Q3	2012	2.4000	1.0560	4.0000	1
167	5631	24	0	12	Q4	2012	2.4000	1.1280	4.0000	1
167	6001	17	0	2	Q1	2012	1.8000	0.8640	3.0000	1
167	6114	16	0	9	Q3	2012	1.2000	0.4200	2.0000	1
167	6352	13	980	3	Q1	2012	2.4000	1.1040	4.0000	1
167	6766	24	1850	3	Q1	2012	1.2000	0.5280	2.0000	1
167	6857	7	0	1	Q1	2012	2.4000	0.7440	4.0000	1
167	7291	11	0	12	Q4	2012	2.4000	0.9120	4.0000	1
167	8492	14	1061	4	Q2	2012	0.6000	0.2280	1.0000	1
167	8665	15	0	9	Q3	2012	2.4000	1.0080	4.0000	1
167	8770	22	0	5	Q2	2012	0.6000	0.2580	1.0000	1
167	9047	15	1157	12	Q4	2012	1.2000	0.5520	2.0000	1
167	9279	7	0	10	Q4	2012	1.8000	0.9000	3.0000	1
167	9469	17	1307	8	Q3	2012	1.2000	0.5160	2.0000	1
167	9715	17	0	6	Q2	2012	2.4000	1.0320	4.0000	1
167	9760	13	0	11	Q4	2012	1.8000	0.7020	3.0000	1
167	10142	11	0	11	Q4	2012	1.2000	0.5280	2.0000	1
168	446	13	0	10	Q4	2012	2.5200	1.1592	2.0000	1
168	447	6	0	12	Q4	2012	3.7800	1.5498	3.0000	1
168	652	6	0	3	Q1	2012	5.0400	1.7136	4.0000	1
168	760	3	0	7	Q3	2012	3.7800	1.3986	3.0000	1
168	976	16	0	12	Q4	2012	2.5200	0.8316	2.0000	1
168	993	13	0	9	Q3	2012	2.5200	1.1844	2.0000	1
168	1035	13	0	5	Q2	2012	2.5200	0.9576	2.0000	1
168	1145	17	1307	8	Q3	2012	3.7800	1.5876	3.0000	1
168	1378	11	0	5	Q2	2012	3.7800	1.8900	3.0000	1
168	1442	3	0	12	Q4	2012	2.5200	0.8064	2.0000	1
168	1596	24	0	10	Q4	2012	5.0400	1.5624	4.0000	1
168	1897	13	0	7	Q3	2012	2.5200	0.9072	2.0000	1
168	2335	17	0	4	Q2	2012	2.5200	1.0584	2.0000	1
168	2556	3	195	5	Q2	2012	3.7800	1.3986	3.0000	1
168	2640	6	0	4	Q2	2012	3.7800	1.8522	3.0000	1
168	3720	7	0	10	Q4	2012	2.5200	0.9324	2.0000	1
168	4094	16	0	4	Q2	2012	2.5200	0.9576	2.0000	1
168	4131	15	0	12	Q4	2012	3.7800	1.2474	3.0000	1
168	4176	24	1856	6	Q2	2012	5.0400	2.1168	4.0000	1
168	4230	11	0	7	Q3	2012	3.7800	1.2096	3.0000	1
168	4243	11	0	1	Q1	2012	2.5200	0.8064	2.0000	1
168	4261	13	0	7	Q3	2012	3.7800	1.5120	3.0000	1
168	4340	17	0	4	Q2	2012	3.7800	1.3986	3.0000	1
168	4340	17	0	11	Q4	2012	3.7800	1.8144	3.0000	1
168	4460	3	0	9	Q3	2012	5.0400	1.6632	4.0000	1
168	4500	14	1070	8	Q3	2012	2.5200	0.8820	2.0000	1
168	4507	13	0	1	Q1	2012	2.5200	1.0836	2.0000	1
168	4552	17	0	12	Q4	2012	3.7800	1.1340	3.0000	1
168	4633	7	0	5	Q2	2012	2.5200	0.8064	2.0000	1
168	5116	15	1149	8	Q3	2012	2.5200	1.1844	2.0000	1
168	5123	11	0	9	Q3	2012	5.0400	2.1672	4.0000	1
168	5340	11	0	1	Q1	2012	3.7800	1.7388	3.0000	1
168	5341	17	0	1	Q1	2012	3.7800	1.3986	3.0000	1
168	5373	24	0	1	Q1	2012	5.0400	2.0664	4.0000	1
168	5423	11	0	9	Q3	2012	3.7800	1.5876	3.0000	1
168	5453	22	1694	4	Q2	2012	2.5200	1.1340	2.0000	1
168	5702	11	0	11	Q4	2012	3.7800	1.1718	3.0000	1
168	6003	13	0	3	Q1	2012	3.7800	1.4364	3.0000	1
168	6113	16	0	5	Q2	2012	5.0400	1.8648	4.0000	1
168	6164	24	0	5	Q2	2012	5.0400	2.3688	4.0000	1
168	6313	17	0	12	Q4	2012	5.0400	1.8648	4.0000	1
168	6635	24	1845	1	Q1	2012	3.7800	1.5120	3.0000	1
168	6759	22	0	8	Q3	2012	2.5200	0.9072	2.0000	1
168	6799	17	1314	11	Q4	2012	5.0400	2.1672	4.0000	1
168	7051	16	1220	4	Q2	2012	3.7800	1.6632	3.0000	1
168	7534	13	0	7	Q3	2012	2.5200	1.1340	2.0000	1
168	7599	6	526	12	Q4	2012	5.0400	1.5624	4.0000	1
168	7849	3	0	8	Q3	2012	3.7800	1.4742	3.0000	1
168	8015	13	0	12	Q4	2012	5.0400	1.8648	4.0000	1
168	8545	7	518	8	Q3	2012	3.7800	1.2474	3.0000	1
168	8772	11	0	5	Q2	2012	3.7800	1.6254	3.0000	1
168	9019	7	501	1	Q1	2012	3.7800	1.5876	3.0000	1
168	9065	13	0	12	Q4	2012	3.7800	1.4742	3.0000	1
168	9125	13	992	9	Q3	2012	3.7800	1.2852	3.0000	1
168	9469	17	0	8	Q3	2012	2.5200	1.0836	2.0000	1
168	9974	7	0	9	Q3	2012	2.5200	0.7812	2.0000	1
168	10131	17	0	11	Q4	2012	3.7800	1.2852	3.0000	1
168	10173	16	0	10	Q4	2012	3.7800	1.2852	3.0000	1
168	10231	6	0	5	Q2	2012	2.5200	1.0836	2.0000	1
169	666	24	0	8	Q3	2012	7.9200	3.1680	4.0000	1
169	955	6	0	9	Q3	2012	5.9400	2.9106	3.0000	1
169	976	16	1223	6	Q2	2012	7.9200	2.6928	4.0000	1
169	997	3	201	8	Q3	2012	5.9400	1.9008	3.0000	1
169	1142	13	0	11	Q4	2012	7.9200	2.9304	4.0000	1
169	1558	14	0	8	Q3	2012	1.9800	0.8514	1.0000	1
169	1610	3	0	11	Q4	2012	5.9400	2.4354	3.0000	1
169	1917	23	1778	7	Q3	2012	3.9600	1.7820	2.0000	1
169	2024	11	0	12	Q4	2012	3.9600	1.1880	2.0000	1
169	2359	24	0	1	Q1	2012	7.9200	3.8808	4.0000	1
169	2524	6	0	6	Q2	2012	9.9000	3.9600	5.0000	1
169	2882	24	0	10	Q4	2012	3.9600	1.6236	2.0000	1
169	3254	15	0	4	Q2	2012	3.9600	1.8612	2.0000	1
169	3302	13	988	7	Q3	2012	5.9400	1.9602	3.0000	1
169	3401	11	0	7	Q3	2012	5.9400	2.4948	3.0000	1
169	3491	16	0	8	Q3	2012	5.9400	2.9700	3.0000	1
169	3549	22	1698	6	Q2	2012	1.9800	0.9900	1.0000	1
169	3803	24	0	8	Q3	2012	5.9400	1.7820	3.0000	1
169	4664	6	0	12	Q4	2012	7.9200	2.6136	4.0000	1
169	4892	17	0	1	Q1	2012	7.9200	3.4056	4.0000	1
169	4892	17	1314	11	Q4	2012	7.9200	3.4056	4.0000	1
169	5013	7	517	8	Q3	2012	5.9400	2.0196	3.0000	1
169	5050	17	0	1	Q1	2012	7.9200	2.4552	4.0000	1
169	5070	13	0	7	Q3	2012	5.9400	2.1978	3.0000	1
169	5303	17	0	1	Q1	2012	5.9400	2.2572	3.0000	1
169	5366	15	0	8	Q3	2012	5.9400	2.6730	3.0000	1
169	5958	13	0	7	Q3	2012	5.9400	2.4354	3.0000	1
169	5991	3	0	3	Q1	2012	5.9400	2.6730	3.0000	1
169	6307	16	1220	4	Q2	2012	5.9400	2.9106	3.0000	1
169	6313	17	1303	6	Q2	2012	5.9400	2.9106	3.0000	1
169	6609	7	504	2	Q1	2012	5.9400	2.0196	3.0000	1
169	6681	17	0	6	Q2	2012	7.9200	3.7224	4.0000	1
169	6695	2	0	6	Q2	2012	3.9600	1.8216	2.0000	1
169	6932	13	980	3	Q1	2012	7.9200	3.0096	4.0000	1
169	7384	3	0	1	Q1	2012	7.9200	2.8512	4.0000	1
169	7666	7	0	1	Q1	2012	5.9400	2.4948	3.0000	1
169	7862	16	0	7	Q3	2012	7.9200	3.4848	4.0000	1
169	8270	7	504	2	Q1	2012	3.9600	1.3464	2.0000	1
169	8389	6	519	9	Q3	2012	5.9400	2.5542	3.0000	1
169	8901	13	980	3	Q1	2012	7.9200	2.4552	4.0000	1
169	9200	16	0	7	Q3	2012	7.9200	2.6928	4.0000	1
169	9218	7	504	2	Q1	2012	5.9400	1.8414	3.0000	1
169	9263	16	0	7	Q3	2012	5.9400	2.7324	3.0000	1
169	9297	13	0	11	Q4	2012	7.9200	2.4552	4.0000	1
169	9307	11	0	7	Q3	2012	9.9000	4.5540	5.0000	1
169	9473	15	0	9	Q3	2012	5.9400	2.7324	3.0000	1
170	192	16	0	5	Q2	2012	9.6000	4.4160	3.0000	1
170	226	11	833	8	Q3	2012	16.0000	6.0800	5.0000	1
170	481	24	0	10	Q4	2012	6.4000	3.0080	2.0000	1
170	665	6	0	9	Q3	2012	6.4000	2.4320	2.0000	1
170	751	7	0	3	Q1	2012	9.6000	3.5520	3.0000	1
170	1036	13	0	10	Q4	2012	9.6000	3.5520	3.0000	1
170	1091	7	0	9	Q3	2012	9.6000	2.9760	3.0000	1
170	1194	24	1869	12	Q4	2012	6.4000	3.2000	2.0000	1
170	1297	16	0	8	Q3	2012	9.6000	3.0720	3.0000	1
170	1850	16	0	10	Q4	2012	12.8000	3.9680	4.0000	1
170	1906	6	0	1	Q1	2012	12.8000	6.0160	4.0000	1
170	2032	23	0	9	Q3	2012	6.4000	3.0720	2.0000	1
170	2065	17	0	7	Q3	2012	6.4000	2.0480	2.0000	1
170	2065	17	1304	7	Q3	2012	6.4000	2.4320	2.0000	1
170	2716	13	984	5	Q2	2012	9.6000	4.7040	3.0000	1
170	2734	7	504	2	Q1	2012	9.6000	4.7040	3.0000	1
170	2921	16	0	3	Q1	2012	9.6000	4.5120	3.0000	1
170	2951	24	0	7	Q3	2012	9.6000	3.0720	3.0000	1
170	3046	13	0	3	Q1	2012	6.4000	2.4320	2.0000	1
170	3549	22	0	7	Q3	2012	3.2000	1.1200	1.0000	1
170	3655	6	0	3	Q1	2012	9.6000	3.6480	3.0000	1
170	3804	24	0	7	Q3	2012	9.6000	3.8400	3.0000	1
170	3908	6	0	12	Q4	2012	9.6000	3.5520	3.0000	1
170	4497	17	0	7	Q3	2012	9.6000	3.2640	3.0000	1
170	4597	17	0	12	Q4	2012	6.4000	2.9440	2.0000	1
170	5096	7	0	11	Q4	2012	12.8000	4.4800	4.0000	1
170	5303	17	0	12	Q4	2012	9.6000	4.3200	3.0000	1
170	5644	17	0	4	Q2	2012	6.4000	2.8800	2.0000	1
170	5721	15	1149	8	Q3	2012	9.6000	3.4560	3.0000	1
170	5839	7	0	3	Q1	2012	6.4000	2.7520	2.0000	1
170	6107	3	0	3	Q1	2012	9.6000	4.5120	3.0000	1
170	6114	16	0	1	Q1	2012	9.6000	2.8800	3.0000	1
170	6289	6	513	6	Q2	2012	6.4000	2.4960	2.0000	1
170	6291	3	0	12	Q4	2012	9.6000	3.5520	3.0000	1
170	6526	13	980	3	Q1	2012	12.8000	4.7360	4.0000	1
170	6877	24	0	10	Q4	2012	9.6000	2.9760	3.0000	1
170	6897	6	0	3	Q1	2012	9.6000	2.8800	3.0000	1
170	7190	23	0	7	Q3	2012	16.0000	5.6000	5.0000	1
170	8076	14	1071	8	Q3	2012	3.2000	1.3760	1.0000	1
170	8235	22	1694	4	Q2	2012	6.4000	2.0480	2.0000	1
170	8617	17	0	12	Q4	2012	12.8000	5.2480	4.0000	1
170	8946	23	1788	11	Q4	2012	9.6000	3.0720	3.0000	1
170	8960	3	0	6	Q2	2012	9.6000	3.7440	3.0000	1
170	9087	7	0	5	Q2	2012	12.8000	6.0160	4.0000	1
170	9124	24	0	2	Q1	2012	9.6000	3.5520	3.0000	1
170	9188	7	514	7	Q3	2012	9.6000	4.7040	3.0000	1
170	9208	15	0	2	Q1	2012	6.4000	2.3680	2.0000	1
170	9534	17	1311	10	Q4	2012	6.4000	2.5600	2.0000	1
170	9642	3	195	5	Q2	2012	12.8000	4.4800	4.0000	1
170	9728	16	1214	2	Q1	2012	9.6000	3.3600	3.0000	1
170	9823	13	0	1	Q1	2012	9.6000	3.7440	3.0000	1
171	39	13	0	10	Q4	2012	11.8000	4.8380	4.0000	1
171	260	11	0	10	Q4	2012	8.8500	4.2480	3.0000	1
171	275	6	0	6	Q2	2012	5.9000	2.5960	2.0000	1
171	682	6	0	7	Q3	2012	8.8500	3.2745	3.0000	1
171	770	17	0	10	Q4	2012	5.9000	1.9470	2.0000	1
171	778	15	0	3	Q1	2012	5.9000	2.7730	2.0000	1
171	1093	13	0	7	Q3	2012	8.8500	2.7435	3.0000	1
171	1528	16	1225	7	Q3	2012	8.8500	4.3365	3.0000	1
171	1802	23	0	8	Q3	2012	8.8500	3.8940	3.0000	1
171	1979	3	207	11	Q4	2012	8.8500	3.8940	3.0000	1
171	2327	13	0	1	Q1	2012	8.8500	2.8320	3.0000	1
171	2523	6	513	6	Q2	2012	11.8000	4.3660	4.0000	1
171	2647	6	0	3	Q1	2012	14.7500	5.9000	5.0000	1
171	3109	11	836	9	Q3	2012	11.8000	3.8940	4.0000	1
171	3664	22	0	6	Q2	2012	2.9500	1.3865	1.0000	1
171	4018	2	126	10	Q4	2012	2.9500	1.1800	1.0000	1
171	4461	11	842	12	Q4	2012	5.9000	2.7140	2.0000	1
171	5183	6	510	5	Q2	2012	11.8000	3.7760	4.0000	1
171	5303	17	0	5	Q2	2012	8.8500	3.3630	3.0000	1
171	5365	24	0	10	Q4	2012	8.8500	3.8940	3.0000	1
171	5419	17	0	3	Q1	2012	8.8500	3.2745	3.0000	1
171	5743	13	0	8	Q3	2012	8.8500	3.5400	3.0000	1
171	5820	17	0	5	Q2	2012	5.9000	2.0060	2.0000	1
171	5844	17	0	11	Q4	2012	5.9000	2.4190	2.0000	1
171	5847	22	1701	7	Q3	2012	5.9000	2.7730	2.0000	1
171	6001	17	0	12	Q4	2012	8.8500	3.2745	3.0000	1
171	6351	11	0	6	Q2	2012	8.8500	3.3630	3.0000	1
171	6486	13	0	6	Q2	2012	8.8500	4.1595	3.0000	1
171	6551	11	0	2	Q1	2012	11.8000	3.6580	4.0000	1
171	6599	22	0	9	Q3	2012	5.9000	2.8910	2.0000	1
171	6617	7	526	12	Q4	2012	8.8500	2.8320	3.0000	1
171	6912	16	0	12	Q4	2012	11.8000	4.3660	4.0000	1
171	7051	16	0	12	Q4	2012	8.8500	4.0710	3.0000	1
171	7715	13	980	3	Q1	2012	11.8000	3.6580	4.0000	1
171	7753	6	0	7	Q3	2012	14.7500	6.1950	5.0000	1
171	8193	6	0	6	Q2	2012	5.9000	2.7730	2.0000	1
171	8717	17	0	4	Q2	2012	11.8000	5.5460	4.0000	1
171	8717	17	1303	6	Q2	2012	8.8500	3.8055	3.0000	1
171	9340	11	0	11	Q4	2012	8.8500	3.2745	3.0000	1
171	9797	16	0	9	Q3	2012	8.8500	3.2745	3.0000	1
171	9897	16	0	2	Q1	2012	8.8500	4.1595	3.0000	1
172	601	6	0	10	Q4	2012	13.2800	5.3120	4.0000	1
172	650	11	0	10	Q4	2012	9.9600	3.5856	3.0000	1
172	1209	24	0	10	Q4	2012	9.9600	3.5856	3.0000	1
172	1415	16	0	8	Q3	2012	13.2800	6.2416	4.0000	1
172	1429	13	0	10	Q4	2012	9.9600	3.1872	3.0000	1
172	1439	7	0	10	Q4	2012	9.9600	3.5856	3.0000	1
172	1442	3	0	12	Q4	2012	6.6400	2.5232	2.0000	1
172	1607	17	1307	8	Q3	2012	9.9600	4.6812	3.0000	1
172	1607	17	1314	11	Q4	2012	13.2800	4.7808	4.0000	1
172	1696	22	0	3	Q1	2012	3.3200	1.1288	1.0000	1
172	1772	15	0	4	Q2	2012	9.9600	3.7848	3.0000	1
172	2019	16	0	12	Q4	2012	13.2800	4.9136	4.0000	1
172	2204	3	197	6	Q2	2012	9.9600	4.8804	3.0000	1
172	2208	7	501	1	Q1	2012	13.2800	6.2416	4.0000	1
172	2493	17	0	4	Q2	2012	6.6400	2.7888	2.0000	1
172	2961	7	0	8	Q3	2012	9.9600	4.7808	3.0000	1
172	3003	6	0	6	Q2	2012	9.9600	4.8804	3.0000	1
172	3242	3	205	10	Q4	2012	9.9600	3.6852	3.0000	1
172	3470	17	0	9	Q3	2012	6.6400	2.0584	2.0000	1
172	3965	24	0	8	Q3	2012	9.9600	4.9800	3.0000	1
172	4094	16	1214	2	Q1	2012	9.9600	3.6852	3.0000	1
172	4460	3	201	8	Q3	2012	13.2800	4.3824	4.0000	1
172	4633	7	0	5	Q2	2012	6.6400	2.2576	2.0000	1
172	4868	16	1216	2	Q1	2012	9.9600	3.9840	3.0000	1
172	5174	16	1235	11	Q4	2012	13.2800	5.0464	4.0000	1
172	5341	17	0	2	Q1	2012	13.2800	5.0464	4.0000	1
172	5895	17	1311	10	Q4	2012	9.9600	3.3864	3.0000	1
172	5903	13	0	4	Q2	2012	6.6400	2.4568	2.0000	1
172	6136	7	0	3	Q1	2012	13.2800	5.8432	4.0000	1
172	6321	14	1079	12	Q4	2012	3.3200	1.1288	1.0000	1
172	6381	24	0	5	Q2	2012	6.6400	3.1872	2.0000	1
172	7124	6	511	5	Q2	2012	9.9600	3.9840	3.0000	1
172	7234	16	0	11	Q4	2012	9.9600	3.1872	3.0000	1
172	7234	16	1214	2	Q1	2012	13.2800	5.4448	4.0000	1
172	7721	13	0	10	Q4	2012	6.6400	2.1248	2.0000	1
172	8033	24	0	7	Q3	2012	9.9600	2.9880	3.0000	1
172	8060	22	0	1	Q1	2012	3.3200	0.9960	1.0000	1
172	8587	22	0	12	Q4	2012	3.3200	0.9960	1.0000	1
172	8652	7	0	5	Q2	2012	9.9600	3.9840	3.0000	1
172	8945	23	0	10	Q4	2012	6.6400	2.1248	2.0000	1
172	8954	7	0	4	Q2	2012	6.6400	2.7888	2.0000	1
172	8958	22	1711	12	Q4	2012	6.6400	2.3904	2.0000	1
172	9263	16	0	6	Q2	2012	13.2800	6.6400	4.0000	1
172	9403	6	0	2	Q1	2012	9.9600	3.6852	3.0000	1
172	9494	7	504	2	Q1	2012	6.6400	2.9880	2.0000	1
172	9752	17	0	2	Q1	2012	9.9600	4.0836	3.0000	1
172	9960	7	0	10	Q4	2012	9.9600	3.8844	3.0000	1
172	10140	17	1293	1	Q1	2012	9.9600	4.6812	3.0000	1
172	10144	7	523	11	Q4	2012	6.6400	2.7224	2.0000	1
173	36	11	826	5	Q2	2012	5.7200	2.4596	4.0000	1
173	208	13	0	9	Q3	2012	4.2900	1.8018	3.0000	1
173	962	15	1138	3	Q1	2012	2.8600	1.1440	2.0000	1
173	997	3	0	7	Q3	2012	5.7200	1.8304	4.0000	1
173	1007	11	818	1	Q1	2012	5.7200	2.5168	4.0000	1
173	1133	7	514	7	Q3	2012	4.2900	1.5873	3.0000	1
173	1309	24	0	12	Q4	2012	4.2900	2.1021	3.0000	1
173	1337	17	0	1	Q1	2012	5.7200	1.7732	4.0000	1
173	1361	24	0	7	Q3	2012	4.2900	1.5444	3.0000	1
173	2171	23	0	11	Q4	2012	2.8600	1.0582	2.0000	1
173	2174	15	0	3	Q1	2012	5.7200	2.0020	4.0000	1
173	2319	14	0	10	Q4	2012	2.8600	1.4300	2.0000	1
173	2371	16	0	3	Q1	2012	4.2900	1.7589	3.0000	1
173	2493	17	1292	1	Q1	2012	4.2900	1.4157	3.0000	1
173	2787	17	0	3	Q1	2012	2.8600	1.1154	2.0000	1
173	3021	16	0	9	Q3	2012	4.2900	2.0163	3.0000	1
173	3102	24	0	11	Q4	2012	4.2900	1.4586	3.0000	1
173	3196	13	0	4	Q2	2012	2.8600	1.0582	2.0000	1
173	3647	13	984	5	Q2	2012	4.2900	1.5444	3.0000	1
173	3773	17	0	1	Q1	2012	4.2900	1.9734	3.0000	1
173	4029	17	1293	1	Q1	2012	4.2900	2.0592	3.0000	1
173	4279	6	0	8	Q3	2012	5.7200	2.6884	4.0000	1
173	4405	13	980	3	Q1	2012	4.2900	2.0163	3.0000	1
173	4417	3	0	12	Q4	2012	4.2900	1.8018	3.0000	1
173	4487	2	124	9	Q3	2012	2.8600	0.9438	2.0000	1
173	4692	15	0	10	Q4	2012	2.8600	1.2584	2.0000	1
173	4810	23	0	8	Q3	2012	5.7200	1.8876	4.0000	1
173	5070	13	0	7	Q3	2012	2.8600	0.9724	2.0000	1
173	5086	7	504	2	Q1	2012	4.2900	1.3728	3.0000	1
173	5134	3	0	8	Q3	2012	2.8600	1.2012	2.0000	1
173	5257	13	976	1	Q1	2012	4.2900	1.5015	3.0000	1
173	5295	16	0	7	Q3	2012	5.7200	2.5168	4.0000	1
173	5341	17	1314	11	Q4	2012	4.2900	1.6302	3.0000	1
173	5501	17	1312	10	Q4	2012	7.1500	2.7170	5.0000	1
173	5781	11	837	10	Q4	2012	4.2900	1.8018	3.0000	1
173	5823	15	0	1	Q1	2012	4.2900	1.9305	3.0000	1
173	5973	3	187	2	Q1	2012	4.2900	1.5015	3.0000	1
173	6499	17	0	6	Q2	2012	4.2900	1.7589	3.0000	1
173	6844	11	0	8	Q3	2012	7.1500	2.7170	5.0000	1
173	8134	11	0	6	Q2	2012	2.8600	1.2870	2.0000	1
173	8311	23	1773	4	Q2	2012	4.2900	1.2870	3.0000	1
173	8351	16	0	7	Q3	2012	5.7200	2.4596	4.0000	1
173	8356	15	0	6	Q2	2012	4.2900	1.6731	3.0000	1
173	8452	16	0	9	Q3	2012	5.7200	2.5740	4.0000	1
173	8452	16	1216	2	Q1	2012	5.7200	2.0592	4.0000	1
173	8777	17	0	8	Q3	2012	4.2900	2.0163	3.0000	1
173	8960	3	207	11	Q4	2012	4.2900	1.6731	3.0000	1
173	9248	15	0	2	Q1	2012	2.8600	1.2870	2.0000	1
173	9535	11	0	10	Q4	2012	4.2900	1.5873	3.0000	1
173	9602	11	0	4	Q2	2012	4.2900	1.7589	3.0000	1
173	9642	3	0	6	Q2	2012	4.2900	1.9305	3.0000	1
173	10176	13	0	8	Q3	2012	4.2900	1.3728	3.0000	1
174	167	24	0	4	Q2	2012	6.8400	2.7360	4.0000	1
174	378	16	1233	10	Q4	2012	5.1300	2.3085	3.0000	1
174	417	6	0	9	Q3	2012	3.4200	1.4364	2.0000	1
174	511	16	0	4	Q2	2012	6.8400	2.8044	4.0000	1
174	792	7	0	7	Q3	2012	8.5500	3.3345	5.0000	1
174	983	11	0	11	Q4	2012	3.4200	1.5390	2.0000	1
174	1064	24	1866	11	Q4	2012	5.1300	1.9494	3.0000	1
174	1161	15	1134	1	Q1	2012	6.8400	3.0780	4.0000	1
174	1245	17	0	6	Q2	2012	5.1300	1.8981	3.0000	1
174	1297	16	0	8	Q3	2012	3.4200	1.1628	2.0000	1
174	1309	24	0	9	Q3	2012	6.8400	2.4624	4.0000	1
174	1451	3	0	7	Q3	2012	6.8400	2.3940	4.0000	1
174	2086	13	980	3	Q1	2012	5.1300	2.4624	3.0000	1
174	2550	24	0	2	Q1	2012	6.8400	2.7360	4.0000	1
174	2869	6	522	10	Q4	2012	5.1300	2.5137	3.0000	1
174	2921	16	0	9	Q3	2012	5.1300	1.6416	3.0000	1
174	2924	3	199	7	Q3	2012	5.1300	2.3598	3.0000	1
174	3097	6	0	4	Q2	2012	6.8400	2.9412	4.0000	1
174	3132	15	0	2	Q1	2012	6.8400	2.9412	4.0000	1
174	3239	17	0	8	Q3	2012	3.4200	1.2996	2.0000	1
174	3389	7	0	11	Q4	2012	5.1300	1.5390	3.0000	1
174	3551	7	0	12	Q4	2012	5.1300	2.5650	3.0000	1
174	3580	6	0	11	Q4	2012	5.1300	1.7955	3.0000	1
174	4274	11	0	7	Q3	2012	5.1300	1.6416	3.0000	1
174	4627	7	0	7	Q3	2012	5.1300	1.6929	3.0000	1
174	4868	16	0	7	Q3	2012	3.4200	1.4022	2.0000	1
174	4961	13	0	8	Q3	2012	3.4200	1.6416	2.0000	1
174	5147	13	0	10	Q4	2012	6.8400	3.2148	4.0000	1
174	5210	17	0	2	Q1	2012	5.1300	2.2572	3.0000	1
174	5320	24	1856	6	Q2	2012	5.1300	2.1546	3.0000	1
174	5346	3	204	9	Q3	2012	3.4200	1.4022	2.0000	1
174	5501	17	0	10	Q4	2012	6.8400	3.2148	4.0000	1
174	5809	13	984	5	Q2	2012	5.1300	2.5137	3.0000	1
174	5962	17	0	6	Q2	2012	6.8400	2.0520	4.0000	1
174	6113	16	1231	9	Q3	2012	6.8400	2.1204	4.0000	1
174	6564	13	0	9	Q3	2012	5.1300	1.9494	3.0000	1
174	6590	7	0	9	Q3	2012	5.1300	1.6416	3.0000	1
174	6912	16	1216	2	Q1	2012	6.8400	2.5308	4.0000	1
174	6932	13	0	11	Q4	2012	5.1300	1.9494	3.0000	1
174	7109	11	0	1	Q1	2012	3.4200	1.2312	2.0000	1
174	7109	11	0	10	Q4	2012	3.4200	1.2312	2.0000	1
174	7149	13	0	2	Q1	2012	3.4200	1.3680	2.0000	1
174	7331	11	0	6	Q2	2012	5.1300	2.5650	3.0000	1
174	7780	13	0	5	Q2	2012	5.1300	2.0520	3.0000	1
174	7813	17	0	10	Q4	2012	5.1300	2.1033	3.0000	1
174	7818	11	0	3	Q1	2012	6.8400	3.4200	4.0000	1
174	8134	11	821	2	Q1	2012	3.4200	1.5048	2.0000	1
174	8684	6	508	4	Q2	2012	3.4200	1.4706	2.0000	1
174	8851	7	0	6	Q2	2012	3.4200	1.7100	2.0000	1
174	9123	3	0	6	Q2	2012	5.1300	2.4111	3.0000	1
174	9187	17	0	2	Q1	2012	8.5500	3.5910	5.0000	1
174	10173	16	1228	8	Q3	2012	5.1300	2.1546	3.0000	1
175	41	11	836	9	Q3	2012	7.7000	2.9260	2.0000	1
175	435	17	0	8	Q3	2012	11.5500	4.8510	3.0000	1
175	612	22	0	7	Q3	2012	7.7000	3.6190	2.0000	1
175	816	6	518	8	Q3	2012	15.4000	5.5440	4.0000	1
175	1388	13	0	2	Q1	2012	15.4000	6.1600	4.0000	1
175	1429	13	0	1	Q1	2012	11.5500	4.6200	3.0000	1
175	1646	15	1141	4	Q2	2012	11.5500	5.3130	3.0000	1
175	1729	11	0	9	Q3	2012	11.5500	5.7750	3.0000	1
175	1729	11	837	10	Q4	2012	11.5500	5.7750	3.0000	1
175	1744	17	0	4	Q2	2012	15.4000	6.9300	4.0000	1
175	1818	11	826	5	Q2	2012	15.4000	6.1600	4.0000	1
175	2159	14	0	5	Q2	2012	3.8500	1.6940	1.0000	1
175	2210	13	0	3	Q1	2012	7.7000	3.3880	2.0000	1
175	2224	16	0	1	Q1	2012	11.5500	3.8115	3.0000	1
175	2441	17	0	12	Q4	2012	15.4000	4.7740	4.0000	1
175	2444	13	0	6	Q2	2012	15.4000	6.6220	4.0000	1
175	2533	6	522	10	Q4	2012	15.4000	6.1600	4.0000	1
175	2570	16	0	3	Q1	2012	11.5500	5.0820	3.0000	1
175	2614	13	1000	12	Q4	2012	11.5500	4.3890	3.0000	1
175	3333	7	0	7	Q3	2012	15.4000	6.3140	4.0000	1
175	3828	24	0	3	Q1	2012	7.7000	2.7720	2.0000	1
175	4065	3	0	12	Q4	2012	11.5500	5.3130	3.0000	1
175	4388	15	0	6	Q2	2012	11.5500	5.1975	3.0000	1
175	4396	13	0	11	Q4	2012	11.5500	4.6200	3.0000	1
175	4615	17	1304	7	Q3	2012	11.5500	5.6595	3.0000	1
175	4649	17	0	2	Q1	2012	7.7000	2.6180	2.0000	1
175	4674	7	0	10	Q4	2012	15.4000	5.0820	4.0000	1
175	4704	6	0	6	Q2	2012	11.5500	3.5805	3.0000	1
175	4958	23	1778	7	Q3	2012	11.5500	5.6595	3.0000	1
175	5095	6	0	7	Q3	2012	15.4000	6.7760	4.0000	1
175	5295	16	1216	2	Q1	2012	15.4000	5.8520	4.0000	1
175	5724	11	0	4	Q2	2012	15.4000	5.0820	4.0000	1
175	5894	11	829	6	Q2	2012	7.7000	3.7730	2.0000	1
175	5982	13	0	3	Q1	2012	7.7000	2.8490	2.0000	1
175	6488	13	0	3	Q1	2012	11.5500	5.6595	3.0000	1
175	6530	17	0	10	Q4	2012	15.4000	5.0820	4.0000	1
175	6712	16	0	3	Q1	2012	19.2500	7.1225	5.0000	1
175	7486	3	0	9	Q3	2012	11.5500	4.3890	3.0000	1
175	7791	15	0	7	Q3	2012	15.4000	6.0060	4.0000	1
175	8435	17	0	5	Q2	2012	15.4000	5.6980	4.0000	1
175	8578	23	1768	2	Q1	2012	11.5500	3.5805	3.0000	1
175	9040	16	0	3	Q1	2012	15.4000	6.6220	4.0000	1
175	9194	17	1307	8	Q3	2012	19.2500	8.8550	5.0000	1
175	9353	15	1150	8	Q3	2012	15.4000	5.0820	4.0000	1
175	9504	13	0	2	Q1	2012	7.7000	3.2340	2.0000	1
175	9599	24	1869	12	Q4	2012	11.5500	3.6960	3.0000	1
175	9697	23	1771	3	Q1	2012	7.7000	2.8490	2.0000	1
175	9721	15	1146	7	Q3	2012	11.5500	3.5805	3.0000	1
175	9747	13	982	4	Q2	2012	11.5500	4.0425	3.0000	1
175	10225	23	0	5	Q2	2012	7.7000	3.2340	2.0000	1
175	10243	17	0	11	Q4	2012	11.5500	4.8510	3.0000	1
176	3	15	1141	4	Q2	2012	6.8100	3.4050	3.0000	1
176	20	24	1856	6	Q2	2012	9.0800	3.3596	4.0000	1
176	169	13	0	7	Q3	2012	6.8100	2.2473	3.0000	1
176	352	11	0	12	Q4	2012	4.5400	1.8160	2.0000	1
176	485	15	1143	5	Q2	2012	6.8100	2.1792	3.0000	1
176	492	14	0	3	Q1	2012	2.2700	0.7945	1.0000	1
176	644	13	0	7	Q3	2012	6.8100	2.5878	3.0000	1
176	644	13	0	9	Q3	2012	11.3500	4.3130	5.0000	1
176	813	11	0	1	Q1	2012	4.5400	2.0430	2.0000	1
176	878	3	199	7	Q3	2012	4.5400	1.6344	2.0000	1
176	922	7	0	7	Q3	2012	9.0800	4.5400	4.0000	1
176	1147	13	0	1	Q1	2012	6.8100	2.5197	3.0000	1
176	1538	6	521	10	Q4	2012	9.0800	3.9952	4.0000	1
176	1720	16	1228	8	Q3	2012	6.8100	3.2688	3.0000	1
176	1817	6	0	5	Q2	2012	9.0800	4.5400	4.0000	1
176	1916	13	0	12	Q4	2012	4.5400	1.6344	2.0000	1
176	2204	3	185	1	Q1	2012	6.8100	3.3369	3.0000	1
176	2638	13	976	1	Q1	2012	6.8100	2.8602	3.0000	1
176	2686	11	0	9	Q3	2012	6.8100	2.5197	3.0000	1
176	2724	24	0	11	Q4	2012	6.8100	2.1792	3.0000	1
176	2827	6	526	12	Q4	2012	9.0800	3.6320	4.0000	1
176	2896	3	0	3	Q1	2012	4.5400	1.9976	2.0000	1
176	3143	6	0	2	Q1	2012	6.8100	2.6559	3.0000	1
176	3275	24	1853	5	Q2	2012	4.5400	2.0884	2.0000	1
176	3586	11	0	6	Q2	2012	11.3500	4.8805	5.0000	1
176	4599	7	0	11	Q4	2012	6.8100	3.3369	3.0000	1
176	4767	16	0	8	Q3	2012	4.5400	1.9976	2.0000	1
176	5280	7	523	11	Q4	2012	4.5400	1.5436	2.0000	1
176	5608	7	0	11	Q4	2012	6.8100	2.1111	3.0000	1
176	5610	13	0	12	Q4	2012	9.0800	4.2676	4.0000	1
176	5678	7	504	2	Q1	2012	9.0800	2.9056	4.0000	1
176	5905	15	0	7	Q3	2012	6.8100	2.5197	3.0000	1
176	5942	7	0	11	Q4	2012	9.0800	4.3584	4.0000	1
176	6124	7	0	8	Q3	2012	6.8100	2.3154	3.0000	1
176	6189	7	0	11	Q4	2012	6.8100	2.5197	3.0000	1
176	6835	16	0	8	Q3	2012	6.8100	2.1111	3.0000	1
176	6932	13	0	2	Q1	2012	6.8100	2.5878	3.0000	1
176	7037	11	818	1	Q1	2012	9.0800	3.9952	4.0000	1
176	7276	23	0	2	Q1	2012	9.0800	3.7228	4.0000	1
176	7433	11	820	2	Q1	2012	9.0800	3.5412	4.0000	1
176	8102	24	0	9	Q3	2012	6.8100	2.1792	3.0000	1
176	8484	24	0	8	Q3	2012	6.8100	2.3154	3.0000	1
176	9111	17	0	4	Q2	2012	11.3500	5.5615	5.0000	1
176	9224	17	0	12	Q4	2012	6.8100	2.1111	3.0000	1
176	9263	16	1233	10	Q4	2012	6.8100	3.4050	3.0000	1
176	9403	6	0	2	Q1	2012	4.5400	1.5436	2.0000	1
176	9434	6	0	12	Q4	2012	6.8100	2.3154	3.0000	1
176	9449	6	0	9	Q3	2012	6.8100	2.2473	3.0000	1
176	9534	17	0	10	Q4	2012	9.0800	3.1780	4.0000	1
176	9570	15	0	11	Q4	2012	6.8100	2.1792	3.0000	1
176	9706	7	504	2	Q1	2012	4.5400	1.6798	2.0000	1
177	169	13	0	1	Q1	2012	4.9800	2.0916	3.0000	1
177	187	13	0	10	Q4	2012	4.9800	2.4402	3.0000	1
177	288	6	521	10	Q4	2012	4.9800	1.6932	3.0000	1
177	328	11	0	3	Q1	2012	6.6400	2.9216	4.0000	1
177	611	24	0	4	Q2	2012	6.6400	2.8552	4.0000	1
177	847	15	1154	10	Q4	2012	3.3200	1.0956	2.0000	1
177	941	13	0	5	Q2	2012	3.3200	1.5272	2.0000	1
177	1090	6	0	10	Q4	2012	4.9800	2.2410	3.0000	1
177	1434	24	0	2	Q1	2012	4.9800	1.7430	3.0000	1
177	1551	3	0	12	Q4	2012	6.6400	2.5896	4.0000	1
177	1802	23	1765	1	Q1	2012	3.3200	1.4608	2.0000	1
177	2042	13	984	5	Q2	2012	6.6400	2.7888	4.0000	1
177	2636	17	0	12	Q4	2012	4.9800	1.7928	3.0000	1
177	2769	16	1236	12	Q4	2012	6.6400	2.8552	4.0000	1
177	2878	3	0	11	Q4	2012	6.6400	2.5896	4.0000	1
177	3298	6	0	4	Q2	2012	4.9800	2.4402	3.0000	1
177	3308	13	0	1	Q1	2012	4.9800	1.5936	3.0000	1
177	3878	3	0	9	Q3	2012	6.6400	2.1248	4.0000	1
177	3925	11	0	1	Q1	2012	4.9800	1.5438	3.0000	1
177	3936	7	505	2	Q1	2012	4.9800	1.5936	3.0000	1
177	4110	15	0	9	Q3	2012	4.9800	2.0418	3.0000	1
177	4222	6	0	2	Q1	2012	4.9800	2.3406	3.0000	1
177	4279	6	0	8	Q3	2012	4.9800	1.8924	3.0000	1
177	4497	17	0	7	Q3	2012	4.9800	2.1912	3.0000	1
177	4868	16	0	6	Q2	2012	4.9800	2.1414	3.0000	1
177	5196	13	0	4	Q2	2012	6.6400	2.9216	4.0000	1
177	5295	16	0	5	Q2	2012	6.6400	2.1248	4.0000	1
177	5514	6	0	3	Q1	2012	6.6400	3.0544	4.0000	1
177	5808	7	0	1	Q1	2012	4.9800	2.4402	3.0000	1
177	6733	13	980	3	Q1	2012	6.6400	2.2576	4.0000	1
177	7366	3	0	9	Q3	2012	4.9800	1.6434	3.0000	1
177	7406	11	0	4	Q2	2012	6.6400	2.7888	4.0000	1
177	7449	24	0	5	Q2	2012	4.9800	2.0418	3.0000	1
177	7449	24	1869	12	Q4	2012	6.6400	3.0544	4.0000	1
177	7617	11	0	3	Q1	2012	6.6400	2.6560	4.0000	1
177	8243	13	0	2	Q1	2012	6.6400	3.1208	4.0000	1
177	8351	16	1235	11	Q4	2012	6.6400	2.5232	4.0000	1
177	9369	6	0	12	Q4	2012	4.9800	1.4940	3.0000	1
177	9611	15	0	9	Q3	2012	3.3200	1.1288	2.0000	1
177	9622	6	0	8	Q3	2012	4.9800	2.3406	3.0000	1
177	9734	17	0	2	Q1	2012	3.3200	1.4608	2.0000	1
177	9972	13	0	3	Q1	2012	3.3200	1.3944	2.0000	1
177	10015	17	0	12	Q4	2012	4.9800	1.9422	3.0000	1
177	10140	17	1294	2	Q1	2012	6.6400	3.1872	4.0000	1
178	137	7	523	11	Q4	2012	3.9900	1.8753	3.0000	1
178	630	24	1869	12	Q4	2012	2.6600	1.2502	2.0000	1
178	891	6	0	12	Q4	2012	3.9900	1.7157	3.0000	1
178	941	13	0	8	Q3	2012	2.6600	0.8778	2.0000	1
178	957	6	0	8	Q3	2012	5.3200	2.6600	4.0000	1
178	1004	17	0	1	Q1	2012	3.9900	1.4364	3.0000	1
178	1245	17	0	6	Q2	2012	3.9900	1.5561	3.0000	1
178	1795	24	0	11	Q4	2012	5.3200	1.5960	4.0000	1
178	1954	13	0	7	Q3	2012	5.3200	1.6492	4.0000	1
178	2077	23	1789	12	Q4	2012	3.9900	1.7955	3.0000	1
178	2441	17	1304	7	Q3	2012	5.3200	1.8088	4.0000	1
178	2482	13	0	11	Q4	2012	3.9900	1.9551	3.0000	1
178	2553	16	1233	10	Q4	2012	2.6600	0.9044	2.0000	1
178	2900	7	0	6	Q2	2012	2.6600	1.1172	2.0000	1
178	3349	7	517	8	Q3	2012	3.9900	1.5561	3.0000	1
178	4096	3	0	8	Q3	2012	3.9900	1.2369	3.0000	1
178	4417	3	0	6	Q2	2012	5.3200	2.1812	4.0000	1
178	4445	17	0	12	Q4	2012	3.9900	1.6359	3.0000	1
178	4445	17	1303	6	Q2	2012	3.9900	1.6359	3.0000	1
178	4515	15	0	6	Q2	2012	3.9900	1.4763	3.0000	1
178	4525	7	0	11	Q4	2012	3.9900	1.4763	3.0000	1
178	4534	7	0	12	Q4	2012	3.9900	1.5162	3.0000	1
178	4552	17	0	7	Q3	2012	3.9900	1.7157	3.0000	1
178	5043	15	0	7	Q3	2012	2.6600	0.8778	2.0000	1
178	5104	24	0	5	Q2	2012	3.9900	1.7157	3.0000	1
178	5163	3	188	2	Q1	2012	3.9900	1.6758	3.0000	1
178	5610	13	0	10	Q4	2012	3.9900	1.9950	3.0000	1
178	5829	22	0	12	Q4	2012	3.9900	1.9152	3.0000	1
178	6053	6	518	8	Q3	2012	3.9900	1.4364	3.0000	1
178	6295	24	0	5	Q2	2012	3.9900	1.7556	3.0000	1
178	6522	13	0	12	Q4	2012	2.6600	0.8512	2.0000	1
178	6559	3	0	10	Q4	2012	5.3200	2.3408	4.0000	1
178	6670	7	504	2	Q1	2012	5.3200	1.7024	4.0000	1
178	6690	17	0	2	Q1	2012	3.9900	1.6758	3.0000	1
178	6733	13	0	3	Q1	2012	2.6600	1.1704	2.0000	1
178	6912	16	1216	2	Q1	2012	3.9900	1.3566	3.0000	1
178	6982	13	0	7	Q3	2012	5.3200	1.8088	4.0000	1
178	7072	16	0	11	Q4	2012	2.6600	1.2236	2.0000	1
178	7622	3	190	3	Q1	2012	3.9900	1.3965	3.0000	1
178	7897	15	0	2	Q1	2012	2.6600	1.3300	2.0000	1
178	8266	7	0	4	Q2	2012	3.9900	1.5162	3.0000	1
178	8427	16	0	5	Q2	2012	2.6600	0.9044	2.0000	1
178	9013	11	0	12	Q4	2012	5.3200	1.9152	4.0000	1
178	9286	13	0	9	Q3	2012	3.9900	1.9152	3.0000	1
178	9437	15	1134	1	Q1	2012	2.6600	1.1970	2.0000	1
178	9517	2	0	11	Q4	2012	1.3300	0.5453	1.0000	1
178	9527	6	508	4	Q2	2012	3.9900	1.3167	3.0000	1
179	28	15	1134	1	Q1	2012	8.2500	2.5575	3.0000	1
179	148	15	0	8	Q3	2012	11.0000	3.4100	4.0000	1
179	558	11	0	9	Q3	2012	11.0000	3.9600	4.0000	1
179	893	13	0	1	Q1	2012	8.2500	3.6300	3.0000	1
179	1053	13	0	1	Q1	2012	8.2500	2.6400	3.0000	1
179	1274	6	0	8	Q3	2012	8.2500	2.9700	3.0000	1
179	1539	7	0	7	Q3	2012	11.0000	4.4000	4.0000	1
179	1584	7	516	8	Q3	2012	8.2500	3.0525	3.0000	1
179	1656	6	0	3	Q1	2012	11.0000	4.5100	4.0000	1
179	1918	6	0	2	Q1	2012	8.2500	2.8875	3.0000	1
179	2078	24	0	5	Q2	2012	8.2500	3.6300	3.0000	1
179	2272	17	0	7	Q3	2012	5.5000	1.8150	2.0000	1
179	2371	16	0	9	Q3	2012	8.2500	2.5575	3.0000	1
179	2422	13	0	6	Q2	2012	11.0000	4.8400	4.0000	1
179	2472	6	521	10	Q4	2012	8.2500	2.6400	3.0000	1
179	2636	17	0	3	Q1	2012	8.2500	3.7950	3.0000	1
179	2823	24	1850	3	Q1	2012	11.0000	4.4000	4.0000	1
179	2916	13	0	7	Q3	2012	8.2500	3.7125	3.0000	1
179	3069	15	1141	4	Q2	2012	11.0000	4.7300	4.0000	1
179	3328	17	0	11	Q4	2012	5.5000	2.0900	2.0000	1
179	3418	3	210	12	Q4	2012	11.0000	4.4000	4.0000	1
179	3458	24	0	1	Q1	2012	8.2500	3.9600	3.0000	1
179	3469	24	0	6	Q2	2012	8.2500	3.0525	3.0000	1
179	3692	16	1214	2	Q1	2012	5.5000	2.7500	2.0000	1
179	3878	3	0	5	Q2	2012	8.2500	3.4650	3.0000	1
179	4090	6	0	3	Q1	2012	5.5000	2.0900	2.0000	1
179	4186	7	523	11	Q4	2012	8.2500	3.5475	3.0000	1
179	4249	11	829	6	Q2	2012	5.5000	2.5300	2.0000	1
179	4364	17	0	9	Q3	2012	8.2500	3.5475	3.0000	1
179	4727	16	0	6	Q2	2012	11.0000	4.8400	4.0000	1
179	4803	23	0	2	Q1	2012	5.5000	2.5850	2.0000	1
179	5004	7	0	4	Q2	2012	8.2500	3.0525	3.0000	1
179	5067	17	1303	6	Q2	2012	8.2500	3.1350	3.0000	1
179	5214	7	0	12	Q4	2012	8.2500	3.6300	3.0000	1
179	5257	13	976	1	Q1	2012	11.0000	4.2900	4.0000	1
179	5301	6	0	6	Q2	2012	8.2500	3.4650	3.0000	1
179	5644	17	0	6	Q2	2012	8.2500	3.4650	3.0000	1
179	5862	2	0	8	Q3	2012	5.5000	1.8150	2.0000	1
179	5968	7	504	2	Q1	2012	11.0000	4.5100	4.0000	1
179	5971	17	0	6	Q2	2012	11.0000	4.8400	4.0000	1
179	6153	16	0	3	Q1	2012	13.7500	4.8125	5.0000	1
179	6367	3	0	1	Q1	2012	8.2500	2.8875	3.0000	1
179	7138	11	0	2	Q1	2012	8.2500	2.6400	3.0000	1
179	7149	13	988	7	Q3	2012	13.7500	5.2250	5.0000	1
179	7373	13	0	1	Q1	2012	8.2500	3.0525	3.0000	1
179	7664	24	0	5	Q2	2012	11.0000	5.0600	4.0000	1
179	7871	6	0	10	Q4	2012	8.2500	3.3000	3.0000	1
179	8079	2	0	11	Q4	2012	5.5000	2.4750	2.0000	1
179	8979	24	0	6	Q2	2012	11.0000	4.6200	4.0000	1
179	9016	23	1768	2	Q1	2012	8.2500	3.3000	3.0000	1
179	9080	11	0	11	Q4	2012	11.0000	4.0700	4.0000	1
179	9279	7	0	10	Q4	2012	5.5000	2.1450	2.0000	1
179	9564	17	0	12	Q4	2012	11.0000	5.1700	4.0000	1
179	9580	15	0	3	Q1	2012	11.0000	3.9600	4.0000	1
179	10058	15	0	7	Q3	2012	5.5000	1.9800	2.0000	1
180	127	15	1140	4	Q2	2012	1.3800	0.4278	2.0000	1
180	191	6	524	11	Q4	2012	1.3800	0.6624	2.0000	1
180	216	17	1311	10	Q4	2012	2.0700	0.9729	3.0000	1
180	293	22	1694	4	Q2	2012	0.6900	0.2139	1.0000	1
180	734	7	0	8	Q3	2012	2.0700	0.8073	3.0000	1
180	1281	3	0	5	Q2	2012	2.0700	0.8280	3.0000	1
180	1297	16	0	3	Q1	2012	2.7600	0.9384	4.0000	1
180	1378	11	0	5	Q2	2012	2.7600	1.2972	4.0000	1
180	1490	13	0	7	Q3	2012	2.0700	0.7866	3.0000	1
180	1666	6	0	9	Q3	2012	2.0700	0.7245	3.0000	1
180	1983	17	0	8	Q3	2012	4.1400	1.6560	6.0000	1
180	2019	16	1235	11	Q4	2012	2.7600	1.2696	4.0000	1
180	2180	2	0	2	Q1	2012	2.0700	1.0143	3.0000	1
180	2224	16	1233	10	Q4	2012	2.0700	0.6831	3.0000	1
180	2570	16	0	4	Q2	2012	1.3800	0.5658	2.0000	1
180	2963	7	517	8	Q3	2012	2.7600	1.1316	4.0000	1
180	2981	23	1772	4	Q2	2012	2.0700	0.7038	3.0000	1
180	3009	6	0	6	Q2	2012	2.0700	0.7866	3.0000	1
180	3182	2	108	1	Q1	2012	1.3800	0.6486	2.0000	1
180	3286	22	0	10	Q4	2012	0.6900	0.2898	1.0000	1
180	3422	23	0	9	Q3	2012	1.3800	0.4968	2.0000	1
180	3532	7	526	12	Q4	2012	2.7600	1.3524	4.0000	1
180	3655	7	0	6	Q2	2012	1.3800	0.6072	2.0000	1
180	3790	6	0	3	Q1	2012	2.0700	0.8073	3.0000	1
180	3838	17	0	7	Q3	2012	2.0700	0.6417	3.0000	1
180	4121	7	0	4	Q2	2012	2.7600	1.0488	4.0000	1
180	4422	6	518	8	Q3	2012	2.0700	0.9729	3.0000	1
180	4466	13	988	7	Q3	2012	2.0700	1.0350	3.0000	1
180	4467	11	0	4	Q2	2012	1.3800	0.5244	2.0000	1
180	4649	17	0	12	Q4	2012	2.0700	0.6417	3.0000	1
180	4824	3	0	6	Q2	2012	2.0700	0.6417	3.0000	1
180	5123	11	0	9	Q3	2012	2.0700	0.8487	3.0000	1
180	5610	13	0	12	Q4	2012	2.0700	0.7866	3.0000	1
180	5674	7	514	7	Q3	2012	1.3800	0.4830	2.0000	1
180	5690	7	0	6	Q2	2012	2.7600	1.3524	4.0000	1
180	5747	15	1150	8	Q3	2012	2.7600	0.8556	4.0000	1
180	5877	17	0	2	Q1	2012	1.3800	0.5520	2.0000	1
180	6283	6	0	4	Q2	2012	2.0700	0.8280	3.0000	1
180	6320	24	0	10	Q4	2012	2.7600	0.9384	4.0000	1
180	6686	13	0	10	Q4	2012	2.7600	1.1868	4.0000	1
180	6816	11	0	8	Q3	2012	2.0700	0.8694	3.0000	1
180	6854	17	0	4	Q2	2012	2.7600	1.2972	4.0000	1
180	6888	23	1765	1	Q1	2012	1.3800	0.4554	2.0000	1
180	6982	13	0	12	Q4	2012	1.3800	0.6072	2.0000	1
180	7085	11	818	1	Q1	2012	2.0700	0.8901	3.0000	1
180	7494	15	0	1	Q1	2012	1.3800	0.4692	2.0000	1
180	7514	17	0	11	Q4	2012	2.7600	0.8832	4.0000	1
180	7832	7	0	7	Q3	2012	2.7600	0.9936	4.0000	1
180	7896	23	0	6	Q2	2012	2.7600	0.8832	4.0000	1
180	8068	3	0	12	Q4	2012	2.0700	1.0143	3.0000	1
180	8094	6	0	11	Q4	2012	1.3800	0.4416	2.0000	1
180	8171	24	0	11	Q4	2012	1.3800	0.6072	2.0000	1
180	8179	11	0	11	Q4	2012	1.3800	0.6072	2.0000	1
180	8556	11	826	5	Q2	2012	2.7600	0.8832	4.0000	1
180	8851	7	504	2	Q1	2012	2.0700	0.7866	3.0000	1
180	9081	6	511	5	Q2	2012	1.3800	0.4692	2.0000	1
180	9192	15	0	6	Q2	2012	1.3800	0.5934	2.0000	1
180	9397	11	841	12	Q4	2012	2.7600	0.9936	4.0000	1
180	9446	7	0	11	Q4	2012	2.0700	0.6831	3.0000	1
180	9512	23	1778	7	Q3	2012	1.3800	0.6210	2.0000	1
180	9973	6	0	10	Q4	2012	1.3800	0.6210	2.0000	1
180	9991	6	521	10	Q4	2012	1.3800	0.6762	2.0000	1
180	10152	13	986	6	Q2	2012	2.7600	0.9384	4.0000	1
181	221	15	0	9	Q3	2012	1.8600	0.8184	2.0000	1
181	475	7	0	4	Q2	2012	2.7900	1.0044	3.0000	1
181	476	6	0	2	Q1	2012	1.8600	0.5766	2.0000	1
181	570	15	0	4	Q2	2012	2.7900	1.3671	3.0000	1
181	1202	11	0	4	Q2	2012	2.7900	1.0323	3.0000	1
181	1214	11	833	8	Q3	2012	2.7900	1.0323	3.0000	1
181	1245	17	0	3	Q1	2012	1.8600	0.5580	2.0000	1
181	1298	17	0	10	Q4	2012	2.7900	0.9207	3.0000	1
181	1312	3	0	5	Q2	2012	2.7900	1.3671	3.0000	1
181	1497	17	0	7	Q3	2012	2.7900	1.0323	3.0000	1
181	1897	13	0	6	Q2	2012	1.8600	0.5766	2.0000	1
181	1897	13	976	1	Q1	2012	1.8600	0.5766	2.0000	1
181	1938	24	0	3	Q1	2012	1.8600	0.6696	2.0000	1
181	2011	23	1776	6	Q2	2012	2.7900	1.0323	3.0000	1
181	2408	14	0	9	Q3	2012	0.9300	0.2976	1.0000	1
181	2871	15	0	2	Q1	2012	1.8600	0.8556	2.0000	1
181	2968	13	0	1	Q1	2012	5.5800	2.3436	6.0000	1
181	3149	11	837	10	Q4	2012	2.7900	1.0323	3.0000	1
181	3175	6	0	1	Q1	2012	3.7200	1.7856	4.0000	1
181	3305	13	0	7	Q3	2012	1.8600	0.5766	2.0000	1
181	3497	17	0	2	Q1	2012	3.7200	1.4880	4.0000	1
181	3668	7	0	6	Q2	2012	2.7900	0.9765	3.0000	1
181	3844	6	0	7	Q3	2012	2.7900	1.0881	3.0000	1
181	4018	2	0	1	Q1	2012	2.7900	1.0323	3.0000	1
181	4096	3	0	3	Q1	2012	3.7200	1.7856	4.0000	1
181	4253	13	0	4	Q2	2012	1.8600	0.6510	2.0000	1
181	4397	16	0	6	Q2	2012	1.8600	0.6882	2.0000	1
181	5163	3	0	6	Q2	2012	3.7200	1.5996	4.0000	1
181	5216	3	0	4	Q2	2012	3.7200	1.4508	4.0000	1
181	5593	13	0	4	Q2	2012	3.7200	1.1532	4.0000	1
181	5685	13	0	6	Q2	2012	1.8600	0.8370	2.0000	1
181	5877	17	0	8	Q3	2012	1.8600	0.7812	2.0000	1
181	6087	13	0	7	Q3	2012	1.8600	0.6696	2.0000	1
181	6424	6	0	6	Q2	2012	3.7200	1.1904	4.0000	1
181	6666	17	0	8	Q3	2012	3.7200	1.6368	4.0000	1
181	6666	17	0	12	Q4	2012	2.7900	1.3950	3.0000	1
181	7065	17	0	2	Q1	2012	2.7900	1.1718	3.0000	1
181	7197	11	0	3	Q1	2012	2.7900	1.0881	3.0000	1
181	7526	17	0	4	Q2	2012	1.8600	0.8556	2.0000	1
181	7601	24	0	4	Q2	2012	1.8600	0.7812	2.0000	1
181	7695	6	0	10	Q4	2012	2.7900	0.9207	3.0000	1
181	7905	13	0	10	Q4	2012	2.7900	1.3671	3.0000	1
181	8003	3	185	1	Q1	2012	2.7900	1.2276	3.0000	1
181	8195	6	0	6	Q2	2012	3.7200	1.7856	4.0000	1
181	8511	16	0	3	Q1	2012	3.7200	1.3392	4.0000	1
181	8606	15	0	2	Q1	2012	2.7900	1.2276	3.0000	1
181	8746	23	0	3	Q1	2012	2.7900	1.2276	3.0000	1
181	9140	7	0	10	Q4	2012	1.8600	0.6324	2.0000	1
181	9513	15	0	12	Q4	2012	1.8600	0.9114	2.0000	1
181	9648	13	980	3	Q1	2012	2.7900	1.3671	3.0000	1
181	9891	23	0	11	Q4	2012	2.7900	0.9486	3.0000	1
181	9979	6	523	11	Q4	2012	1.8600	0.9300	2.0000	1
181	10258	15	0	10	Q4	2012	2.7900	1.0602	3.0000	1
182	76	3	0	10	Q4	2012	3.6800	1.3616	2.0000	1
182	552	11	841	12	Q4	2012	3.6800	1.8400	2.0000	1
182	780	13	0	1	Q1	2012	7.3600	2.2080	4.0000	1
182	1160	14	0	5	Q2	2012	1.8400	0.6440	1.0000	1
182	1193	13	0	6	Q2	2012	7.3600	3.5328	4.0000	1
182	1270	7	0	4	Q2	2012	5.5200	2.6496	3.0000	1
182	1556	17	0	3	Q1	2012	5.5200	2.0424	3.0000	1
182	1580	15	0	4	Q2	2012	3.6800	1.5824	2.0000	1
182	1720	16	0	4	Q2	2012	7.3600	2.7968	4.0000	1
182	1771	2	0	1	Q1	2012	1.8400	0.7360	1.0000	1
182	1773	13	0	3	Q1	2012	7.3600	3.0912	4.0000	1
182	1925	22	0	5	Q2	2012	3.6800	1.4720	2.0000	1
182	1957	13	0	8	Q3	2012	5.5200	1.7112	3.0000	1
182	2921	16	0	1	Q1	2012	7.3600	3.3856	4.0000	1
182	3057	7	0	3	Q1	2012	5.5200	2.3184	3.0000	1
182	3101	11	0	3	Q1	2012	9.2000	3.7720	5.0000	1
182	3127	7	517	8	Q3	2012	5.5200	2.3184	3.0000	1
182	3731	15	0	11	Q4	2012	7.3600	3.3120	4.0000	1
182	4146	24	0	3	Q1	2012	5.5200	2.0976	3.0000	1
182	4148	15	0	10	Q4	2012	7.3600	3.1648	4.0000	1
182	4152	23	1773	4	Q2	2012	5.5200	1.8216	3.0000	1
182	4204	17	0	11	Q4	2012	7.3600	2.7968	4.0000	1
182	4240	24	0	8	Q3	2012	9.2000	4.3240	5.0000	1
182	4537	7	512	6	Q2	2012	7.3600	2.5024	4.0000	1
182	4597	17	0	3	Q1	2012	7.3600	3.3120	4.0000	1
182	4626	7	0	12	Q4	2012	5.5200	1.7112	3.0000	1
182	4642	15	0	2	Q1	2012	5.5200	2.0424	3.0000	1
182	4649	17	0	1	Q1	2012	5.5200	2.3736	3.0000	1
182	4676	16	0	12	Q4	2012	3.6800	1.6928	2.0000	1
182	5152	24	0	8	Q3	2012	5.5200	2.3184	3.0000	1
182	5379	17	0	6	Q2	2012	7.3600	3.1648	4.0000	1
182	5405	11	837	10	Q4	2012	7.3600	3.2384	4.0000	1
182	5743	13	0	1	Q1	2012	5.5200	1.9320	3.0000	1
182	5984	17	1304	7	Q3	2012	5.5200	1.7664	3.0000	1
182	6035	24	0	7	Q3	2012	3.6800	1.1040	2.0000	1
182	6089	15	0	7	Q3	2012	3.6800	1.1776	2.0000	1
182	6496	3	195	5	Q2	2012	5.5200	2.4288	3.0000	1
182	6574	13	0	7	Q3	2012	5.5200	2.3736	3.0000	1
182	6708	24	0	11	Q4	2012	5.5200	2.2080	3.0000	1
182	6761	11	0	2	Q1	2012	5.5200	2.0976	3.0000	1
182	7204	11	0	2	Q1	2012	5.5200	1.9872	3.0000	1
182	7205	24	0	3	Q1	2012	7.3600	2.7968	4.0000	1
182	7206	7	504	2	Q1	2012	7.3600	2.6496	4.0000	1
182	7292	13	0	11	Q4	2012	3.6800	1.2880	2.0000	1
182	7354	3	205	10	Q4	2012	7.3600	2.6496	4.0000	1
182	8091	13	0	8	Q3	2012	7.3600	3.0176	4.0000	1
182	8409	24	0	7	Q3	2012	5.5200	2.2080	3.0000	1
182	8410	13	984	5	Q2	2012	5.5200	2.5944	3.0000	1
182	8511	16	1228	8	Q3	2012	5.5200	1.9872	3.0000	1
182	8590	24	0	12	Q4	2012	5.5200	1.7664	3.0000	1
182	8717	17	0	2	Q1	2012	5.5200	2.7600	3.0000	1
182	8730	6	524	11	Q4	2012	5.5200	2.6496	3.0000	1
182	8749	13	0	7	Q3	2012	3.6800	1.2144	2.0000	1
182	8872	24	1866	11	Q4	2012	5.5200	1.7112	3.0000	1
182	8921	13	0	3	Q1	2012	3.6800	1.6928	2.0000	1
182	9134	23	0	7	Q3	2012	3.6800	1.1776	2.0000	1
182	9447	13	0	3	Q1	2012	5.5200	2.3184	3.0000	1
182	9658	6	0	10	Q4	2012	7.3600	3.4592	4.0000	1
182	9928	16	1225	7	Q3	2012	7.3600	3.4592	4.0000	1
182	9943	7	0	3	Q1	2012	3.6800	1.6192	2.0000	1
183	213	7	0	8	Q3	2012	9.6400	3.5668	4.0000	1
183	341	17	0	3	Q1	2012	9.6400	2.9884	4.0000	1
183	429	7	519	9	Q3	2012	7.2300	2.2413	3.0000	1
183	636	17	0	1	Q1	2012	4.8200	1.6388	2.0000	1
183	650	11	0	3	Q1	2012	4.8200	1.6388	2.0000	1
183	663	16	0	1	Q1	2012	7.2300	2.8920	3.0000	1
183	819	13	0	7	Q3	2012	4.8200	2.1208	2.0000	1
183	1036	13	0	6	Q2	2012	7.2300	2.5305	3.0000	1
183	1124	3	0	5	Q2	2012	12.0500	5.6635	5.0000	1
183	1481	15	0	7	Q3	2012	7.2300	2.5305	3.0000	1
183	1850	16	1216	2	Q1	2012	7.2300	3.1812	3.0000	1
183	1917	23	0	6	Q2	2012	9.6400	4.6272	4.0000	1
183	1984	24	0	12	Q4	2012	7.2300	2.8197	3.0000	1
183	2244	17	0	4	Q2	2012	9.6400	4.7236	4.0000	1
183	2673	11	0	4	Q2	2012	7.2300	3.5427	3.0000	1
183	2839	15	0	6	Q2	2012	4.8200	2.2172	2.0000	1
183	2921	16	1216	2	Q1	2012	9.6400	4.2416	4.0000	1
183	3239	17	1311	10	Q4	2012	7.2300	3.0366	3.0000	1
183	3361	24	1859	8	Q3	2012	7.2300	3.3981	3.0000	1
183	3521	14	0	2	Q1	2012	4.8200	2.1208	2.0000	1
183	3588	24	1856	6	Q2	2012	7.2300	2.6751	3.0000	1
183	3776	13	0	1	Q1	2012	7.2300	3.5427	3.0000	1
183	3903	6	523	11	Q4	2012	7.2300	3.5427	3.0000	1
183	4029	17	0	11	Q4	2012	7.2300	3.1812	3.0000	1
183	4397	16	0	11	Q4	2012	4.8200	1.7352	2.0000	1
183	4499	13	0	11	Q4	2012	7.2300	3.3981	3.0000	1
183	4626	6	502	1	Q1	2012	7.2300	2.9643	3.0000	1
183	4649	17	1307	8	Q3	2012	7.2300	3.0366	3.0000	1
183	5295	16	0	10	Q4	2012	7.2300	2.5305	3.0000	1
183	5912	11	0	8	Q3	2012	7.2300	3.3981	3.0000	1
183	6003	13	984	5	Q2	2012	7.2300	2.4582	3.0000	1
183	6132	3	204	9	Q3	2012	4.8200	1.6388	2.0000	1
183	6207	7	523	11	Q4	2012	7.2300	3.0366	3.0000	1
183	6562	24	0	7	Q3	2012	9.6400	3.8560	4.0000	1
183	6799	17	1314	11	Q4	2012	9.6400	4.4344	4.0000	1
183	6866	17	0	11	Q4	2012	7.2300	3.3981	3.0000	1
183	6912	16	1214	2	Q1	2012	9.6400	3.6632	4.0000	1
183	7081	6	508	4	Q2	2012	4.8200	1.6388	2.0000	1
183	7182	13	0	7	Q3	2012	4.8200	2.1208	2.0000	1
183	7573	3	0	2	Q1	2012	7.2300	3.1812	3.0000	1
183	7870	15	0	12	Q4	2012	9.6400	2.9884	4.0000	1
183	8000	7	0	9	Q3	2012	7.2300	2.8920	3.0000	1
183	8275	16	0	10	Q4	2012	7.2300	3.0366	3.0000	1
183	8373	13	0	3	Q1	2012	7.2300	2.2413	3.0000	1
183	8452	16	1214	2	Q1	2012	9.6400	3.4704	4.0000	1
183	8487	15	1138	3	Q1	2012	9.6400	3.1812	4.0000	1
183	8783	15	0	12	Q4	2012	9.6400	4.6272	4.0000	1
183	8906	11	0	7	Q3	2012	4.8200	1.8316	2.0000	1
183	8977	6	523	11	Q4	2012	7.2300	2.6028	3.0000	1
183	9016	23	1768	2	Q1	2012	7.2300	2.3859	3.0000	1
183	9703	24	1847	2	Q1	2012	4.8200	2.2172	2.0000	1
184	376	11	0	11	Q4	2012	6.8000	3.1960	2.0000	1
184	908	11	0	11	Q4	2012	10.2000	4.4880	3.0000	1
184	950	13	0	6	Q2	2012	13.6000	4.2160	4.0000	1
184	999	24	0	7	Q3	2012	10.2000	4.7940	3.0000	1
184	1112	24	1846	2	Q1	2012	6.8000	2.1080	2.0000	1
184	1556	17	0	10	Q4	2012	10.2000	3.7740	3.0000	1
184	1556	17	1294	2	Q1	2012	6.8000	3.3320	2.0000	1
184	1567	16	0	8	Q3	2012	10.2000	4.5900	3.0000	1
184	2053	11	0	7	Q3	2012	13.6000	4.6240	4.0000	1
184	2158	11	0	11	Q4	2012	6.8000	2.3800	2.0000	1
184	2525	13	980	3	Q1	2012	6.8000	2.9920	2.0000	1
184	2664	17	0	12	Q4	2012	13.6000	4.3520	4.0000	1
184	2682	23	0	3	Q1	2012	10.2000	3.2640	3.0000	1
184	2684	15	0	3	Q1	2012	13.6000	4.8960	4.0000	1
184	2695	13	0	8	Q3	2012	10.2000	3.8760	3.0000	1
184	2725	11	0	11	Q4	2012	13.6000	4.0800	4.0000	1
184	2869	7	0	12	Q4	2012	6.8000	3.1960	2.0000	1
184	3166	24	0	11	Q4	2012	10.2000	3.2640	3.0000	1
184	3448	3	0	4	Q2	2012	10.2000	3.6720	3.0000	1
184	3476	3	197	6	Q2	2012	13.6000	6.6640	4.0000	1
184	3706	13	0	11	Q4	2012	13.6000	4.2160	4.0000	1
184	3929	15	0	5	Q2	2012	6.8000	2.9920	2.0000	1
184	4210	2	0	9	Q3	2012	6.8000	2.5840	2.0000	1
184	4215	15	0	9	Q3	2012	17.0000	5.7800	5.0000	1
184	4618	3	0	6	Q2	2012	10.2000	4.1820	3.0000	1
184	4719	23	1783	9	Q3	2012	10.2000	3.8760	3.0000	1
184	5023	6	513	6	Q2	2012	10.2000	3.5700	3.0000	1
184	5050	17	0	3	Q1	2012	10.2000	3.7740	3.0000	1
184	5138	24	0	11	Q4	2012	10.2000	4.0800	3.0000	1
184	5143	17	0	12	Q4	2012	10.2000	4.9980	3.0000	1
184	5238	17	0	5	Q2	2012	6.8000	2.5160	2.0000	1
184	5379	17	0	10	Q4	2012	6.8000	2.5160	2.0000	1
184	5568	23	0	10	Q4	2012	10.2000	3.7740	3.0000	1
184	5790	17	0	1	Q1	2012	13.6000	5.1680	4.0000	1
184	5790	17	0	12	Q4	2012	10.2000	4.3860	3.0000	1
184	5962	17	0	6	Q2	2012	17.0000	5.7800	5.0000	1
184	6123	7	0	11	Q4	2012	6.8000	2.3800	2.0000	1
184	6332	6	0	11	Q4	2012	13.6000	4.2160	4.0000	1
184	6496	3	210	12	Q4	2012	13.6000	6.8000	4.0000	1
184	6571	24	1856	6	Q2	2012	10.2000	3.6720	3.0000	1
184	6592	13	0	9	Q3	2012	6.8000	2.1760	2.0000	1
184	6727	15	0	6	Q2	2012	10.2000	4.6920	3.0000	1
184	7109	11	0	6	Q2	2012	6.8000	2.5160	2.0000	1
184	7323	24	0	4	Q2	2012	10.2000	3.5700	3.0000	1
184	8467	13	0	9	Q3	2012	10.2000	3.1620	3.0000	1
184	8760	24	1859	8	Q3	2012	13.6000	5.8480	4.0000	1
184	9040	16	0	12	Q4	2012	6.8000	2.1080	2.0000	1
184	9213	11	0	3	Q1	2012	10.2000	4.1820	3.0000	1
184	9461	17	0	1	Q1	2012	13.6000	6.1200	4.0000	1
184	9528	6	0	6	Q2	2012	6.8000	3.1280	2.0000	1
184	9857	24	0	9	Q3	2012	6.8000	2.1760	2.0000	1
184	10026	13	976	1	Q1	2012	10.2000	3.7740	3.0000	1
185	76	3	207	11	Q4	2012	1.7100	0.5301	3.0000	1
185	170	7	0	7	Q3	2012	2.2800	0.7296	4.0000	1
185	465	13	0	10	Q4	2012	2.2800	0.7752	4.0000	1
185	481	24	1850	3	Q1	2012	2.2800	0.9576	4.0000	1
185	666	24	0	12	Q4	2012	1.7100	0.6327	3.0000	1
185	1293	2	0	9	Q3	2012	0.5700	0.1767	1.0000	1
185	1387	11	0	1	Q1	2012	1.7100	0.6156	3.0000	1
185	1773	13	0	1	Q1	2012	1.1400	0.4788	2.0000	1
185	2371	16	0	5	Q2	2012	1.1400	0.5244	2.0000	1
185	2684	15	0	3	Q1	2012	1.7100	0.5472	3.0000	1
185	2787	17	1307	8	Q3	2012	2.2800	0.7068	4.0000	1
185	3005	6	0	9	Q3	2012	2.8500	1.0260	5.0000	1
185	3124	3	0	8	Q3	2012	1.1400	0.5358	2.0000	1
185	3310	17	1297	3	Q1	2012	2.2800	0.9348	4.0000	1
185	3441	3	0	1	Q1	2012	2.8500	0.9975	5.0000	1
185	3567	16	0	12	Q4	2012	1.7100	0.6840	3.0000	1
185	3693	3	201	8	Q3	2012	1.7100	0.6327	3.0000	1
185	4096	3	0	3	Q1	2012	1.7100	0.5472	3.0000	1
185	4133	24	1866	11	Q4	2012	1.1400	0.3762	2.0000	1
185	4175	16	0	6	Q2	2012	2.2800	0.8892	4.0000	1
185	4528	15	0	3	Q1	2012	1.7100	0.8550	3.0000	1
185	4699	15	0	8	Q3	2012	2.2800	0.8664	4.0000	1
185	4901	15	0	7	Q3	2012	1.7100	0.7011	3.0000	1
185	5018	7	0	4	Q2	2012	1.7100	0.5301	3.0000	1
185	5180	24	0	8	Q3	2012	1.7100	0.7011	3.0000	1
185	5302	11	0	5	Q2	2012	1.7100	0.7011	3.0000	1
185	5647	15	1142	5	Q2	2012	1.1400	0.5358	2.0000	1
185	5768	3	0	2	Q1	2012	1.7100	0.5985	3.0000	1
185	5769	6	0	4	Q2	2012	1.7100	0.7524	3.0000	1
185	5790	17	1303	6	Q2	2012	1.7100	0.6669	3.0000	1
185	5867	11	820	2	Q1	2012	1.7100	0.8037	3.0000	1
185	6131	14	0	10	Q4	2012	1.1400	0.3420	2.0000	1
185	6136	6	0	7	Q3	2012	2.2800	1.0716	4.0000	1
185	6248	24	1860	8	Q3	2012	1.7100	0.5301	3.0000	1
185	6266	15	0	8	Q3	2012	1.7100	0.5301	3.0000	1
185	6278	7	0	3	Q1	2012	1.7100	0.5643	3.0000	1
185	6362	14	0	5	Q2	2012	1.1400	0.4788	2.0000	1
185	7341	24	0	2	Q1	2012	2.2800	1.0716	4.0000	1
185	7774	15	1140	4	Q2	2012	1.7100	0.7524	3.0000	1
185	8334	11	0	11	Q4	2012	1.1400	0.5016	2.0000	1
185	8730	7	504	2	Q1	2012	1.7100	0.7353	3.0000	1
185	8814	13	0	9	Q3	2012	1.7100	0.6156	3.0000	1
185	8837	11	0	3	Q1	2012	1.7100	0.7182	3.0000	1
185	9169	23	0	10	Q4	2012	2.8500	1.2825	5.0000	1
185	9399	7	0	6	Q2	2012	2.2800	0.8664	4.0000	1
185	9505	15	0	12	Q4	2012	1.1400	0.5700	2.0000	1
185	9528	7	0	3	Q1	2012	1.1400	0.3762	2.0000	1
185	9863	13	980	3	Q1	2012	1.1400	0.3876	2.0000	1
185	9879	24	0	10	Q4	2012	1.1400	0.4788	2.0000	1
185	9986	7	0	9	Q3	2012	1.7100	0.7182	3.0000	1
185	10190	15	1138	3	Q1	2012	1.1400	0.5244	2.0000	1
186	39	13	0	11	Q4	2012	11.1500	3.7910	5.0000	1
186	118	3	0	4	Q2	2012	6.6900	2.3415	3.0000	1
186	400	23	0	5	Q2	2012	8.9200	3.4788	4.0000	1
186	663	16	0	9	Q3	2012	6.6900	2.8098	3.0000	1
186	886	15	1146	7	Q3	2012	6.6900	3.3450	3.0000	1
186	893	13	0	8	Q3	2012	8.9200	4.4600	4.0000	1
186	1130	15	1141	4	Q2	2012	11.1500	5.1290	5.0000	1
186	1193	13	0	6	Q2	2012	6.6900	2.1408	3.0000	1
186	1193	13	0	11	Q4	2012	4.4600	2.0516	2.0000	1
186	1373	7	0	1	Q1	2012	4.4600	1.6056	2.0000	1
186	1430	3	0	7	Q3	2012	4.4600	1.4272	2.0000	1
186	1545	15	0	10	Q4	2012	6.6900	2.4084	3.0000	1
186	1690	16	0	8	Q3	2012	6.6900	2.8098	3.0000	1
186	2064	6	0	12	Q4	2012	4.4600	1.6056	2.0000	1
186	2218	7	0	1	Q1	2012	6.6900	2.6091	3.0000	1
186	2682	23	0	9	Q3	2012	6.6900	2.7429	3.0000	1
186	2737	15	0	11	Q4	2012	8.9200	3.4788	4.0000	1
186	3352	6	0	5	Q2	2012	8.9200	4.3708	4.0000	1
186	3473	15	0	9	Q3	2012	8.9200	3.9248	4.0000	1
186	3666	6	0	6	Q2	2012	4.4600	1.4718	2.0000	1
186	3725	23	0	12	Q4	2012	4.4600	1.5164	2.0000	1
186	3816	3	0	7	Q3	2012	6.6900	2.5422	3.0000	1
186	4151	6	0	4	Q2	2012	8.9200	3.0328	4.0000	1
186	4239	17	0	12	Q4	2012	8.9200	3.9248	4.0000	1
186	4357	7	0	3	Q1	2012	8.9200	2.8544	4.0000	1
186	4503	13	0	11	Q4	2012	4.4600	1.4272	2.0000	1
186	4649	17	0	12	Q4	2012	8.9200	3.3896	4.0000	1
186	4900	13	0	3	Q1	2012	6.6900	2.3415	3.0000	1
186	5009	7	0	3	Q1	2012	6.6900	2.2077	3.0000	1
186	5532	6	0	4	Q2	2012	8.9200	3.8356	4.0000	1
186	5923	23	1765	1	Q1	2012	6.6900	2.6091	3.0000	1
186	5958	13	0	7	Q3	2012	6.6900	3.0105	3.0000	1
186	6299	7	0	4	Q2	2012	11.1500	5.0175	5.0000	1
186	6307	16	0	5	Q2	2012	4.4600	1.9624	2.0000	1
186	6307	16	1214	2	Q1	2012	6.6900	2.9436	3.0000	1
186	6500	7	517	8	Q3	2012	8.9200	4.1924	4.0000	1
186	6592	13	0	3	Q1	2012	6.6900	2.8767	3.0000	1
186	7149	13	0	5	Q2	2012	6.6900	2.5422	3.0000	1
186	7495	14	1056	1	Q1	2012	2.2300	0.7805	1.0000	1
186	8737	11	820	2	Q1	2012	6.6900	2.8767	3.0000	1
186	8830	14	0	1	Q1	2012	4.4600	1.5164	2.0000	1
186	8840	17	0	9	Q3	2012	4.4600	2.0516	2.0000	1
186	8937	7	504	2	Q1	2012	6.6900	3.2781	3.0000	1
186	9064	17	0	5	Q2	2012	6.6900	2.5422	3.0000	1
186	9530	13	0	7	Q3	2012	6.6900	2.8098	3.0000	1
186	9781	3	0	3	Q1	2012	8.9200	4.3708	4.0000	1
186	10068	23	0	11	Q4	2012	4.4600	1.3826	2.0000	1
186	10093	2	0	6	Q2	2012	4.4600	1.9624	2.0000	1
187	488	14	0	10	Q4	2012	2.6400	1.0824	2.0000	1
187	741	24	1859	8	Q3	2012	2.6400	0.9768	2.0000	1
187	769	16	0	6	Q2	2012	5.2800	2.0064	4.0000	1
187	873	24	1853	5	Q2	2012	3.9600	1.4256	3.0000	1
187	1481	15	1142	5	Q2	2012	5.2800	2.3232	4.0000	1
187	1524	13	0	1	Q1	2012	5.2800	1.6368	4.0000	1
187	1567	16	0	7	Q3	2012	6.6000	2.1120	5.0000	1
187	1729	11	837	10	Q4	2012	5.2800	2.4816	4.0000	1
187	2864	24	0	2	Q1	2012	2.6400	1.2144	2.0000	1
187	3001	13	0	11	Q4	2012	3.9600	1.6632	3.0000	1
187	3242	3	197	6	Q2	2012	5.2800	1.5840	4.0000	1
187	3246	6	513	6	Q2	2012	3.9600	1.3860	3.0000	1
187	3327	7	0	12	Q4	2012	3.9600	1.9404	3.0000	1
187	3388	13	0	4	Q2	2012	5.2800	1.9008	4.0000	1
187	3946	7	0	9	Q3	2012	5.2800	2.4816	4.0000	1
187	4096	3	190	3	Q1	2012	2.6400	0.9768	2.0000	1
187	4146	24	0	3	Q1	2012	3.9600	1.5840	3.0000	1
187	4175	16	0	11	Q4	2012	3.9600	1.4652	3.0000	1
187	4397	16	0	6	Q2	2012	3.9600	1.2672	3.0000	1
187	4443	11	0	1	Q1	2012	2.6400	1.2144	2.0000	1
187	4541	3	0	9	Q3	2012	3.9600	1.8612	3.0000	1
187	4543	13	0	3	Q1	2012	2.6400	0.8448	2.0000	1
187	4676	16	1225	7	Q3	2012	3.9600	1.8216	3.0000	1
187	4814	11	0	9	Q3	2012	2.6400	1.0032	2.0000	1
187	4998	3	0	1	Q1	2012	3.9600	1.7424	3.0000	1
187	5199	11	0	3	Q1	2012	5.2800	1.6368	4.0000	1
187	5924	13	0	5	Q2	2012	2.6400	0.9504	2.0000	1
187	5970	13	980	3	Q1	2012	5.2800	2.4816	4.0000	1
187	6020	24	0	9	Q3	2012	3.9600	1.6632	3.0000	1
187	6163	13	0	12	Q4	2012	2.6400	0.9768	2.0000	1
187	6283	6	0	5	Q2	2012	3.9600	1.4652	3.0000	1
187	6309	2	0	8	Q3	2012	2.6400	1.0560	2.0000	1
187	6554	17	1292	1	Q1	2012	2.6400	1.1616	2.0000	1
187	6634	15	0	4	Q2	2012	3.9600	1.4652	3.0000	1
187	6832	3	0	1	Q1	2012	5.2800	2.3232	4.0000	1
187	6851	6	0	6	Q2	2012	2.6400	1.1616	2.0000	1
187	6912	16	1214	2	Q1	2012	3.9600	1.3464	3.0000	1
187	6947	11	0	12	Q4	2012	5.2800	2.5872	4.0000	1
187	7085	11	0	5	Q2	2012	3.9600	1.2672	3.0000	1
187	7100	17	0	10	Q4	2012	3.9600	1.2672	3.0000	1
187	7465	6	0	11	Q4	2012	2.6400	0.8448	2.0000	1
187	7489	24	0	3	Q1	2012	3.9600	1.6632	3.0000	1
187	7507	6	0	5	Q2	2012	2.6400	1.0824	2.0000	1
187	7580	17	1314	11	Q4	2012	2.6400	1.2144	2.0000	1
187	7683	22	0	4	Q2	2012	2.6400	0.8712	2.0000	1
187	8224	6	0	11	Q4	2012	5.2800	1.7952	4.0000	1
187	8508	14	0	3	Q1	2012	2.6400	0.8712	2.0000	1
187	8953	24	1853	5	Q2	2012	3.9600	1.7028	3.0000	1
187	9245	15	0	3	Q1	2012	5.2800	1.7424	4.0000	1
188	39	13	0	10	Q4	2012	7.7400	2.3994	3.0000	1
188	76	3	0	7	Q3	2012	7.7400	2.7090	3.0000	1
188	346	13	0	12	Q4	2012	10.3200	3.3024	4.0000	1
188	471	24	0	2	Q1	2012	7.7400	2.5542	3.0000	1
188	612	22	1701	7	Q3	2012	7.7400	3.7152	3.0000	1
188	891	6	511	5	Q2	2012	10.3200	4.5408	4.0000	1
188	1162	6	0	12	Q4	2012	7.7400	3.0186	3.0000	1
188	1451	3	0	9	Q3	2012	10.3200	4.6440	4.0000	1
188	1528	16	0	5	Q2	2012	7.7400	3.0960	3.0000	1
188	1655	15	1138	3	Q1	2012	5.1600	1.8576	2.0000	1
188	2086	13	0	10	Q4	2012	10.3200	4.2312	4.0000	1
188	2376	11	0	9	Q3	2012	10.3200	4.8504	4.0000	1
188	2878	3	0	12	Q4	2012	12.9000	5.4180	5.0000	1
188	3057	7	0	3	Q1	2012	10.3200	4.7472	4.0000	1
188	3159	24	0	5	Q2	2012	7.7400	2.8638	3.0000	1
188	3187	24	1869	12	Q4	2012	7.7400	2.3220	3.0000	1
188	3418	3	0	5	Q2	2012	5.1600	1.9092	2.0000	1
188	3755	24	0	6	Q2	2012	7.7400	2.8638	3.0000	1
188	3993	24	0	10	Q4	2012	5.1600	1.5480	2.0000	1
188	4127	15	1152	9	Q3	2012	10.3200	4.7472	4.0000	1
188	4219	11	836	9	Q3	2012	7.7400	3.6378	3.0000	1
188	4460	3	187	2	Q1	2012	5.1600	2.4252	2.0000	1
188	4958	23	1771	3	Q1	2012	5.1600	1.5480	2.0000	1
188	5000	11	826	5	Q2	2012	5.1600	2.3736	2.0000	1
188	5009	7	0	8	Q3	2012	5.1600	1.9608	2.0000	1
188	5153	11	829	6	Q2	2012	10.3200	4.0248	4.0000	1
188	5231	6	504	2	Q1	2012	7.7400	3.1734	3.0000	1
188	5342	15	1140	4	Q2	2012	10.3200	4.5408	4.0000	1
188	5345	7	0	8	Q3	2012	7.7400	2.3994	3.0000	1
188	5433	13	980	3	Q1	2012	7.7400	3.0186	3.0000	1
188	5743	13	0	1	Q1	2012	12.9000	5.0310	5.0000	1
188	5768	3	0	2	Q1	2012	10.3200	3.5088	4.0000	1
188	6087	13	0	2	Q1	2012	7.7400	3.1734	3.0000	1
188	6114	16	0	9	Q3	2012	7.7400	3.0186	3.0000	1
188	6153	16	0	3	Q1	2012	7.7400	3.4830	3.0000	1
188	6265	23	0	12	Q4	2012	10.3200	3.3024	4.0000	1
188	6307	16	1233	10	Q4	2012	10.3200	3.0960	4.0000	1
188	6559	3	190	3	Q1	2012	7.7400	2.7864	3.0000	1
188	7037	11	820	2	Q1	2012	10.3200	4.4376	4.0000	1
188	7060	7	0	1	Q1	2012	7.7400	2.7090	3.0000	1
188	7283	13	0	10	Q4	2012	7.7400	3.2508	3.0000	1
188	7486	3	0	12	Q4	2012	7.7400	3.7152	3.0000	1
188	8335	6	0	3	Q1	2012	7.7400	3.2508	3.0000	1
188	8435	17	0	7	Q3	2012	10.3200	4.5408	4.0000	1
188	8587	22	0	3	Q1	2012	5.1600	1.8060	2.0000	1
188	8648	14	1054	1	Q1	2012	2.5800	0.7740	1.0000	1
188	8814	13	0	1	Q1	2012	7.7400	2.6316	3.0000	1
188	9050	11	821	3	Q1	2012	7.7400	3.0186	3.0000	1
188	9263	16	1225	7	Q3	2012	10.3200	3.6120	4.0000	1
188	9791	15	0	6	Q2	2012	5.1600	2.4768	2.0000	1
188	9825	13	0	4	Q2	2012	5.1600	2.0640	2.0000	1
188	9928	16	0	11	Q4	2012	12.9000	5.9340	5.0000	1
188	10035	15	0	2	Q1	2012	7.7400	3.4056	3.0000	1
189	274	13	1000	12	Q4	2012	10.3500	3.2085	3.0000	1
189	372	2	126	10	Q4	2012	3.4500	1.4145	1.0000	1
189	432	15	0	6	Q2	2012	6.9000	2.8290	2.0000	1
189	448	17	0	9	Q3	2012	10.3500	4.1400	3.0000	1
189	493	15	1140	4	Q2	2012	13.8000	5.9340	4.0000	1
189	723	6	0	3	Q1	2012	10.3500	3.8295	3.0000	1
189	1081	14	0	6	Q2	2012	3.4500	1.2765	1.0000	1
189	1271	13	0	1	Q1	2012	6.9000	3.1740	2.0000	1
189	1481	15	0	6	Q2	2012	10.3500	5.0715	3.0000	1
189	1504	24	0	7	Q3	2012	10.3500	5.0715	3.0000	1
189	1596	24	0	10	Q4	2012	13.8000	6.7620	4.0000	1
189	1798	3	0	8	Q3	2012	10.3500	3.5190	3.0000	1
189	2065	17	1307	8	Q3	2012	10.3500	5.0715	3.0000	1
189	2636	17	0	5	Q2	2012	10.3500	3.2085	3.0000	1
189	2832	13	0	3	Q1	2012	10.3500	4.1400	3.0000	1
189	3086	15	0	9	Q3	2012	13.8000	6.0720	4.0000	1
189	3127	7	517	8	Q3	2012	13.8000	6.3480	4.0000	1
189	3268	13	0	1	Q1	2012	13.8000	6.2100	4.0000	1
189	3286	22	0	7	Q3	2012	3.4500	1.0695	1.0000	1
189	3559	14	0	11	Q4	2012	3.4500	1.3455	1.0000	1
189	4446	15	0	12	Q4	2012	10.3500	3.6225	3.0000	1
189	4543	13	0	1	Q1	2012	6.9000	2.2770	2.0000	1
189	4543	13	1000	12	Q4	2012	10.3500	3.2085	3.0000	1
189	5161	7	518	8	Q3	2012	10.3500	4.5540	3.0000	1
189	5163	3	0	11	Q4	2012	6.9000	2.6220	2.0000	1
189	5244	7	0	7	Q3	2012	10.3500	3.4155	3.0000	1
189	5380	7	0	1	Q1	2012	10.3500	4.6575	3.0000	1
189	5644	17	0	6	Q2	2012	10.3500	3.7260	3.0000	1
189	5746	15	1134	1	Q1	2012	6.9000	3.1740	2.0000	1
189	6067	7	0	12	Q4	2012	13.8000	6.3480	4.0000	1
189	6172	15	0	11	Q4	2012	10.3500	4.0365	3.0000	1
189	6598	11	0	11	Q4	2012	6.9000	2.8980	2.0000	1
189	6805	7	0	3	Q1	2012	13.8000	4.8300	4.0000	1
189	6854	17	0	12	Q4	2012	10.3500	3.3120	3.0000	1
189	6969	24	0	3	Q1	2012	13.8000	5.5200	4.0000	1
189	7370	23	1771	3	Q1	2012	13.8000	5.2440	4.0000	1
189	7388	24	0	3	Q1	2012	13.8000	4.8300	4.0000	1
189	7576	13	0	8	Q3	2012	10.3500	3.3120	3.0000	1
189	7910	15	0	8	Q3	2012	10.3500	3.9330	3.0000	1
189	7920	17	0	9	Q3	2012	13.8000	4.1400	4.0000	1
189	8899	7	516	8	Q3	2012	13.8000	4.2780	4.0000	1
189	9188	7	504	2	Q1	2012	17.2500	6.5550	5.0000	1
189	9208	15	1150	8	Q3	2012	10.3500	4.0365	3.0000	1
189	9263	16	1233	10	Q4	2012	13.8000	6.7620	4.0000	1
189	9673	13	980	3	Q1	2012	10.3500	5.0715	3.0000	1
189	10213	7	0	5	Q2	2012	10.3500	3.4155	3.0000	1
190	106	6	0	1	Q1	2012	14.9600	5.8344	4.0000	1
190	165	11	829	6	Q2	2012	7.4800	2.5432	2.0000	1
190	215	24	0	7	Q3	2012	14.9600	6.4328	4.0000	1
190	391	6	0	5	Q2	2012	18.7000	6.7320	5.0000	1
190	988	15	0	7	Q3	2012	7.4800	3.2912	2.0000	1
190	1430	3	0	2	Q1	2012	11.2200	3.4782	3.0000	1
190	1690	16	0	1	Q1	2012	11.2200	4.0392	3.0000	1
190	1718	13	0	1	Q1	2012	11.2200	3.4782	3.0000	1
190	1983	17	0	10	Q4	2012	18.7000	5.7970	5.0000	1
190	2295	17	1292	1	Q1	2012	11.2200	5.3856	3.0000	1
190	2610	7	0	6	Q2	2012	14.9600	4.7872	4.0000	1
190	2673	11	0	5	Q2	2012	11.2200	3.5904	3.0000	1
190	2769	16	0	5	Q2	2012	14.9600	5.2360	4.0000	1
190	2787	17	1311	10	Q4	2012	11.2200	3.7026	3.0000	1
190	3128	7	0	5	Q2	2012	11.2200	4.1514	3.0000	1
190	3216	7	514	7	Q3	2012	11.2200	5.3856	3.0000	1
190	3711	3	202	8	Q3	2012	7.4800	2.4684	2.0000	1
190	3799	13	976	1	Q1	2012	7.4800	3.4408	2.0000	1
190	3816	3	0	7	Q3	2012	11.2200	4.4880	3.0000	1
190	3897	13	982	4	Q2	2012	11.2200	3.7026	3.0000	1
190	4021	16	1225	7	Q3	2012	18.7000	5.9840	5.0000	1
190	4070	23	1789	12	Q4	2012	11.2200	3.7026	3.0000	1
190	4085	24	0	11	Q4	2012	14.9600	5.0864	4.0000	1
190	4468	11	0	1	Q1	2012	7.4800	3.5156	2.0000	1
190	4503	13	0	11	Q4	2012	11.2200	4.0392	3.0000	1
190	4556	13	0	10	Q4	2012	7.4800	2.9172	2.0000	1
190	4610	23	0	8	Q3	2012	14.9600	6.1336	4.0000	1
190	5047	11	820	2	Q1	2012	14.9600	5.5352	4.0000	1
190	5210	17	0	5	Q2	2012	14.9600	7.1808	4.0000	1
190	5295	16	0	7	Q3	2012	7.4800	3.7400	2.0000	1
190	5587	7	0	8	Q3	2012	14.9600	5.6848	4.0000	1
190	5592	16	1233	10	Q4	2012	11.2200	4.6002	3.0000	1
190	5685	13	0	3	Q1	2012	11.2200	4.7124	3.0000	1
190	5865	15	1146	7	Q3	2012	14.9600	5.0864	4.0000	1
190	5877	17	0	6	Q2	2012	11.2200	4.2636	3.0000	1
190	6372	17	0	8	Q3	2012	11.2200	3.4782	3.0000	1
190	6843	15	0	7	Q3	2012	11.2200	4.1514	3.0000	1
190	7141	17	0	4	Q2	2012	11.2200	3.4782	3.0000	1
190	7323	24	0	4	Q2	2012	7.4800	2.2440	2.0000	1
190	7394	24	1847	2	Q1	2012	14.9600	5.6848	4.0000	1
190	7708	6	0	7	Q3	2012	11.2200	4.1514	3.0000	1
190	8056	24	0	6	Q2	2012	11.2200	5.0490	3.0000	1
190	8410	13	982	4	Q2	2012	11.2200	4.6002	3.0000	1
190	8912	7	0	6	Q2	2012	11.2200	4.8246	3.0000	1
190	8982	7	518	8	Q3	2012	14.9600	6.1336	4.0000	1
190	9063	23	1773	4	Q2	2012	14.9600	7.0312	4.0000	1
190	9184	3	210	12	Q4	2012	7.4800	3.4408	2.0000	1
190	9270	11	0	12	Q4	2012	11.2200	4.6002	3.0000	1
190	9512	23	1776	6	Q2	2012	11.2200	5.4978	3.0000	1
190	10056	7	521	10	Q4	2012	7.4800	2.6928	2.0000	1
191	154	13	0	12	Q4	2012	8.6100	4.0467	3.0000	1
191	392	13	0	6	Q2	2012	11.4800	3.5588	4.0000	1
191	424	6	0	5	Q2	2012	8.6100	3.4440	3.0000	1
191	819	13	0	1	Q1	2012	5.7400	2.5256	2.0000	1
191	887	14	0	6	Q2	2012	5.7400	2.1238	2.0000	1
191	970	14	0	2	Q1	2012	2.8700	1.2915	1.0000	1
191	975	7	504	2	Q1	2012	8.6100	3.4440	3.0000	1
191	1036	13	0	5	Q2	2012	8.6100	3.3579	3.0000	1
191	1175	6	510	5	Q2	2012	5.7400	2.6978	2.0000	1
191	1491	16	0	11	Q4	2012	8.6100	3.7884	3.0000	1
191	1659	15	1152	9	Q3	2012	5.7400	2.0664	2.0000	1
191	1965	17	0	8	Q3	2012	8.6100	3.0135	3.0000	1
191	2193	7	0	3	Q1	2012	8.6100	2.6691	3.0000	1
191	2443	13	976	1	Q1	2012	5.7400	2.5830	2.0000	1
191	2496	11	0	6	Q2	2012	8.6100	3.4440	3.0000	1
191	2553	16	1236	12	Q4	2012	8.6100	4.0467	3.0000	1
191	2640	7	0	4	Q2	2012	11.4800	4.8216	4.0000	1
191	2951	24	0	3	Q1	2012	14.3500	7.0315	5.0000	1
191	3491	16	1220	4	Q2	2012	5.7400	1.9516	2.0000	1
191	3731	15	0	11	Q4	2012	5.7400	2.6978	2.0000	1
191	3751	15	1140	4	Q2	2012	8.6100	4.2189	3.0000	1
191	3869	7	0	8	Q3	2012	11.4800	5.2808	4.0000	1
191	4275	24	0	9	Q3	2012	8.6100	3.7884	3.0000	1
191	4465	13	0	3	Q1	2012	11.4800	4.0180	4.0000	1
191	4543	13	0	3	Q1	2012	8.6100	3.9606	3.0000	1
191	5120	7	504	2	Q1	2012	8.6100	2.6691	3.0000	1
191	5210	17	0	12	Q4	2012	8.6100	4.2189	3.0000	1
191	5278	11	824	4	Q2	2012	11.4800	5.3956	4.0000	1
191	5355	15	0	2	Q1	2012	8.6100	3.0996	3.0000	1
191	5547	7	0	6	Q2	2012	8.6100	3.0996	3.0000	1
191	5592	16	0	6	Q2	2012	8.6100	3.9606	3.0000	1
191	5970	13	980	3	Q1	2012	8.6100	3.3579	3.0000	1
191	5991	3	0	11	Q4	2012	5.7400	2.0664	2.0000	1
191	6301	15	0	1	Q1	2012	8.6100	3.9606	3.0000	1
191	6372	17	1292	1	Q1	2012	5.7400	2.1238	2.0000	1
191	7095	24	0	9	Q3	2012	5.7400	1.9516	2.0000	1
191	7294	6	0	9	Q3	2012	8.6100	2.9274	3.0000	1
191	7354	3	0	1	Q1	2012	8.6100	3.7023	3.0000	1
191	7359	13	0	7	Q3	2012	8.6100	3.0135	3.0000	1
191	7447	7	0	12	Q4	2012	8.6100	3.0135	3.0000	1
191	7464	11	0	1	Q1	2012	8.6100	3.3579	3.0000	1
191	7655	17	0	5	Q2	2012	5.7400	2.1238	2.0000	1
191	8171	24	1866	11	Q4	2012	8.6100	2.8413	3.0000	1
191	8248	6	518	8	Q3	2012	11.4800	3.9032	4.0000	1
191	8463	23	0	4	Q2	2012	8.6100	4.1328	3.0000	1
191	8837	11	0	3	Q1	2012	11.4800	5.2808	4.0000	1
191	8918	7	505	2	Q1	2012	11.4800	5.1660	4.0000	1
191	9123	3	0	7	Q3	2012	11.4800	4.9364	4.0000	1
191	9286	13	0	4	Q2	2012	5.7400	2.5830	2.0000	1
191	9513	15	0	11	Q4	2012	11.4800	4.3624	4.0000	1
191	9536	24	0	5	Q2	2012	8.6100	2.7552	3.0000	1
191	9712	6	0	2	Q1	2012	11.4800	5.6252	4.0000	1
191	9785	15	0	1	Q1	2012	8.6100	3.6162	3.0000	1
191	9814	6	0	7	Q3	2012	8.6100	3.4440	3.0000	1
191	9873	15	0	11	Q4	2012	5.7400	2.0664	2.0000	1
192	88	11	0	4	Q2	2012	6.0800	1.8848	4.0000	1
192	1124	3	187	2	Q1	2012	4.5600	1.7328	3.0000	1
192	1256	6	0	9	Q3	2012	4.5600	1.5960	3.0000	1
192	1913	15	0	3	Q1	2012	3.0400	1.0944	2.0000	1
192	2106	7	0	6	Q2	2012	3.0400	1.0640	2.0000	1
192	2588	23	0	3	Q1	2012	6.0800	2.9184	4.0000	1
192	3149	11	0	4	Q2	2012	4.5600	2.0064	3.0000	1
192	3528	17	0	8	Q3	2012	6.0800	2.3712	4.0000	1
192	3567	16	0	8	Q3	2012	4.5600	1.6872	3.0000	1
192	3782	24	1869	12	Q4	2012	3.0400	1.0944	2.0000	1
192	3892	11	841	12	Q4	2012	4.5600	1.6416	3.0000	1
192	4241	14	0	5	Q2	2012	3.0400	1.1552	2.0000	1
192	4357	6	506	3	Q1	2012	3.0400	1.3376	2.0000	1
192	4413	13	0	4	Q2	2012	6.0800	2.8576	4.0000	1
192	4543	13	0	7	Q3	2012	6.0800	2.0672	4.0000	1
192	4691	17	0	4	Q2	2012	4.5600	1.5504	3.0000	1
192	5167	24	0	2	Q1	2012	4.5600	1.7328	3.0000	1
192	5206	13	0	12	Q4	2012	6.0800	2.9184	4.0000	1
192	5374	16	0	8	Q3	2012	4.5600	1.6872	3.0000	1
192	5374	16	1225	7	Q3	2012	6.0800	2.7360	4.0000	1
192	5651	11	821	3	Q1	2012	4.5600	1.4592	3.0000	1
192	5655	7	526	12	Q4	2012	4.5600	2.2800	3.0000	1
192	5768	3	0	2	Q1	2012	6.0800	2.3712	4.0000	1
192	5850	2	0	5	Q2	2012	3.0400	1.3984	2.0000	1
192	5941	7	0	5	Q2	2012	6.0800	2.3712	4.0000	1
192	5944	3	0	12	Q4	2012	4.5600	1.6416	3.0000	1
192	6367	3	0	3	Q1	2012	4.5600	1.4592	3.0000	1
192	6592	13	0	3	Q1	2012	4.5600	2.2344	3.0000	1
192	6956	13	0	2	Q1	2012	4.5600	2.0520	3.0000	1
192	7123	24	0	5	Q2	2012	6.0800	2.0672	4.0000	1
192	7359	13	0	5	Q2	2012	4.5600	1.5960	3.0000	1
192	7359	13	980	3	Q1	2012	3.0400	1.2768	2.0000	1
192	7497	24	0	1	Q1	2012	6.0800	2.3104	4.0000	1
192	7655	17	0	1	Q1	2012	3.0400	1.3984	2.0000	1
192	8015	13	0	9	Q3	2012	4.5600	2.2344	3.0000	1
192	8378	24	1866	11	Q4	2012	3.0400	1.3984	2.0000	1
192	9067	6	506	3	Q1	2012	4.5600	2.2344	3.0000	1
192	9133	24	1860	8	Q3	2012	6.0800	1.8848	4.0000	1
192	9242	15	0	11	Q4	2012	4.5600	2.1888	3.0000	1
192	9263	16	0	7	Q3	2012	4.5600	1.6872	3.0000	1
192	9314	6	0	12	Q4	2012	4.5600	2.2344	3.0000	1
192	9397	11	837	10	Q4	2012	6.0800	3.0400	4.0000	1
192	9555	17	0	5	Q2	2012	3.0400	1.0032	2.0000	1
192	9556	15	0	4	Q2	2012	4.5600	1.5048	3.0000	1
192	9779	7	519	9	Q3	2012	4.5600	1.7784	3.0000	1
192	9837	17	0	6	Q2	2012	6.0800	2.8576	4.0000	1
192	9840	7	504	2	Q1	2012	3.0400	0.9728	2.0000	1
192	9851	3	0	2	Q1	2012	4.5600	2.1888	3.0000	1
192	10131	17	1304	7	Q3	2012	6.0800	2.6144	4.0000	1
193	36	11	0	11	Q4	2012	11.0400	4.4160	3.0000	1
193	169	13	0	7	Q3	2012	7.3600	2.2816	2.0000	1
193	219	7	0	7	Q3	2012	11.0400	4.1952	3.0000	1
193	335	17	0	9	Q3	2012	7.3600	3.0912	2.0000	1
193	406	7	0	5	Q2	2012	14.7200	4.7104	4.0000	1
193	467	13	0	9	Q3	2012	11.0400	3.6432	3.0000	1
193	644	13	0	1	Q1	2012	7.3600	3.0912	2.0000	1
193	760	3	0	4	Q2	2012	7.3600	2.7232	2.0000	1
193	1197	23	1789	12	Q4	2012	14.7200	6.0352	4.0000	1
193	1366	13	0	3	Q1	2012	7.3600	3.3856	2.0000	1
193	1633	3	0	2	Q1	2012	11.0400	3.5328	3.0000	1
193	1884	15	0	3	Q1	2012	7.3600	3.0176	2.0000	1
193	2570	16	1220	4	Q2	2012	11.0400	3.6432	3.0000	1
193	2586	6	513	6	Q2	2012	14.7200	4.4160	4.0000	1
193	2588	23	1789	12	Q4	2012	7.3600	3.3856	2.0000	1
193	2832	13	0	3	Q1	2012	11.0400	3.6432	3.0000	1
193	3143	7	0	6	Q2	2012	11.0400	4.3056	3.0000	1
193	3428	24	0	1	Q1	2012	18.4000	8.8320	5.0000	1
193	4078	3	0	4	Q2	2012	14.7200	4.7104	4.0000	1
193	4099	17	0	6	Q2	2012	11.0400	5.1888	3.0000	1
193	4249	11	0	6	Q2	2012	11.0400	4.7472	3.0000	1
193	4392	6	521	10	Q4	2012	14.7200	5.8880	4.0000	1
193	4451	7	0	11	Q4	2012	18.4000	9.0160	5.0000	1
193	4476	24	0	4	Q2	2012	14.7200	6.9184	4.0000	1
193	4705	15	0	12	Q4	2012	11.0400	3.7536	3.0000	1
193	4819	6	0	7	Q3	2012	7.3600	2.9440	2.0000	1
193	4958	23	0	9	Q3	2012	11.0400	4.1952	3.0000	1
193	5376	3	0	12	Q4	2012	11.0400	4.7472	3.0000	1
193	5824	7	0	4	Q2	2012	11.0400	4.4160	3.0000	1
193	5912	11	0	8	Q3	2012	14.7200	4.7104	4.0000	1
193	6172	15	0	11	Q4	2012	11.0400	4.7472	3.0000	1
193	6208	17	0	12	Q4	2012	11.0400	4.0848	3.0000	1
193	6229	24	0	8	Q3	2012	14.7200	4.4160	4.0000	1
193	6372	17	0	5	Q2	2012	7.3600	2.7232	2.0000	1
193	6712	16	0	9	Q3	2012	7.3600	2.7232	2.0000	1
193	6775	15	1141	4	Q2	2012	18.4000	6.2560	5.0000	1
193	6815	6	0	5	Q2	2012	11.0400	4.9680	3.0000	1
193	7130	24	0	7	Q3	2012	11.0400	3.8640	3.0000	1
193	7890	24	0	1	Q1	2012	11.0400	3.8640	3.0000	1
193	7906	13	0	5	Q2	2012	11.0400	4.0848	3.0000	1
193	8466	17	0	2	Q1	2012	14.7200	6.4768	4.0000	1
193	8466	17	1314	11	Q4	2012	14.7200	6.7712	4.0000	1
193	8487	15	1138	3	Q1	2012	14.7200	5.4464	4.0000	1
193	8561	15	1154	10	Q4	2012	14.7200	6.0352	4.0000	1
193	8954	7	0	12	Q4	2012	14.7200	5.8880	4.0000	1
193	8960	3	0	9	Q3	2012	11.0400	4.7472	3.0000	1
193	9881	3	0	7	Q3	2012	14.7200	5.1520	4.0000	1
194	169	13	0	1	Q1	2012	6.7200	2.0832	2.0000	1
194	439	13	0	8	Q3	2012	13.4400	6.5856	4.0000	1
194	705	6	502	1	Q1	2012	16.8000	8.2320	5.0000	1
194	823	24	0	5	Q2	2012	10.0800	3.3264	3.0000	1
194	1023	6	0	8	Q3	2012	10.0800	4.4352	3.0000	1
194	1309	24	1860	8	Q3	2012	10.0800	4.1328	3.0000	1
194	1341	3	0	7	Q3	2012	10.0800	3.7296	3.0000	1
194	1366	13	0	9	Q3	2012	6.7200	3.0912	2.0000	1
194	1983	17	0	10	Q4	2012	13.4400	5.6448	4.0000	1
194	2201	16	0	4	Q2	2012	10.0800	3.2256	3.0000	1
194	2204	3	0	4	Q2	2012	10.0800	5.0400	3.0000	1
194	2204	3	0	12	Q4	2012	16.8000	5.2080	5.0000	1
194	2383	2	0	11	Q4	2012	3.3600	1.5120	1.0000	1
194	2448	16	0	12	Q4	2012	10.0800	4.3344	3.0000	1
194	2507	3	0	11	Q4	2012	6.7200	2.9568	2.0000	1
194	2636	17	0	5	Q2	2012	10.0800	4.4352	3.0000	1
194	2787	17	1311	10	Q4	2012	10.0800	3.6288	3.0000	1
194	2793	24	0	11	Q4	2012	13.4400	5.9136	4.0000	1
194	2981	23	1775	5	Q2	2012	10.0800	3.3264	3.0000	1
194	2996	13	988	7	Q3	2012	10.0800	4.4352	3.0000	1
194	3182	2	0	5	Q2	2012	3.3600	1.6464	1.0000	1
194	3239	17	0	4	Q2	2012	13.4400	4.5696	4.0000	1
194	3549	22	0	1	Q1	2012	3.3600	1.4112	1.0000	1
194	3725	23	0	10	Q4	2012	13.4400	4.1664	4.0000	1
194	3941	3	0	1	Q1	2012	10.0800	4.2336	3.0000	1
194	4094	16	0	4	Q2	2012	16.8000	5.8800	5.0000	1
194	4181	24	0	8	Q3	2012	6.7200	3.0912	2.0000	1
194	4454	15	0	12	Q4	2012	6.7200	3.0912	2.0000	1
194	4583	13	0	7	Q3	2012	10.0800	4.8384	3.0000	1
194	4726	11	0	7	Q3	2012	10.0800	4.2336	3.0000	1
194	5374	16	0	1	Q1	2012	6.7200	2.6208	2.0000	1
194	5405	11	837	10	Q4	2012	10.0800	4.1328	3.0000	1
194	5419	17	0	3	Q1	2012	6.7200	2.9568	2.0000	1
194	5592	16	0	8	Q3	2012	10.0800	3.3264	3.0000	1
194	5649	2	0	1	Q1	2012	3.3600	1.5120	1.0000	1
194	5790	17	0	12	Q4	2012	6.7200	2.5536	2.0000	1
194	6026	15	1152	9	Q3	2012	16.8000	5.7120	5.0000	1
194	6265	23	0	1	Q1	2012	10.0800	3.7296	3.0000	1
194	6628	6	508	4	Q2	2012	13.4400	4.5696	4.0000	1
194	6658	24	0	3	Q1	2012	13.4400	5.3760	4.0000	1
194	6735	6	0	9	Q3	2012	10.0800	3.7296	3.0000	1
194	7157	15	0	11	Q4	2012	16.8000	6.7200	5.0000	1
194	7263	11	0	1	Q1	2012	10.0800	3.3264	3.0000	1
194	7470	13	0	5	Q2	2012	10.0800	4.5360	3.0000	1
194	7569	13	0	4	Q2	2012	10.0800	4.2336	3.0000	1
194	7656	2	0	3	Q1	2012	6.7200	2.6880	2.0000	1
194	7862	16	1231	9	Q3	2012	10.0800	4.2336	3.0000	1
194	8154	7	0	7	Q3	2012	10.0800	3.7296	3.0000	1
194	8252	13	0	12	Q4	2012	10.0800	3.7296	3.0000	1
194	8304	13	0	3	Q1	2012	10.0800	4.8384	3.0000	1
194	8393	11	0	7	Q3	2012	10.0800	5.0400	3.0000	1
194	8518	24	1850	3	Q1	2012	10.0800	3.3264	3.0000	1
194	9504	13	0	11	Q4	2012	6.7200	2.4864	2.0000	1
194	9623	15	0	8	Q3	2012	10.0800	3.9312	3.0000	1
194	9746	15	0	7	Q3	2012	10.0800	3.0240	3.0000	1
194	9797	16	0	12	Q4	2012	13.4400	6.4512	4.0000	1
194	10188	2	114	4	Q2	2012	3.3600	1.6128	1.0000	1
194	10264	15	0	5	Q2	2012	10.0800	4.9392	3.0000	1
195	118	3	190	3	Q1	2012	5.3100	2.2302	3.0000	1
195	495	15	0	11	Q4	2012	5.3100	2.3895	3.0000	1
195	638	11	0	2	Q1	2012	5.3100	1.9647	3.0000	1
195	924	3	210	12	Q4	2012	5.3100	2.1240	3.0000	1
195	1153	13	0	10	Q4	2012	3.5400	1.5576	2.0000	1
195	1215	7	0	12	Q4	2012	5.3100	2.3364	3.0000	1
195	1470	17	0	3	Q1	2012	5.3100	1.6992	3.0000	1
195	1941	15	0	7	Q3	2012	3.5400	1.4868	2.0000	1
195	1994	15	0	9	Q3	2012	5.3100	1.6461	3.0000	1
195	2105	24	0	3	Q1	2012	7.0800	2.6196	4.0000	1
195	2251	13	0	1	Q1	2012	7.0800	2.9028	4.0000	1
195	2371	16	0	6	Q2	2012	5.3100	2.3364	3.0000	1
195	2469	15	1140	4	Q2	2012	5.3100	1.6992	3.0000	1
195	2647	6	0	7	Q3	2012	7.0800	2.1948	4.0000	1
195	3098	15	1149	8	Q3	2012	5.3100	2.1771	3.0000	1
195	3422	23	0	12	Q4	2012	3.5400	1.2744	2.0000	1
195	4155	7	0	10	Q4	2012	7.0800	2.3364	4.0000	1
195	4257	3	0	12	Q4	2012	5.3100	1.9116	3.0000	1
195	4261	13	0	11	Q4	2012	5.3100	2.6019	3.0000	1
195	4342	13	0	3	Q1	2012	7.0800	2.1948	4.0000	1
195	4446	15	0	12	Q4	2012	7.0800	2.7612	4.0000	1
195	4556	13	0	12	Q4	2012	3.5400	1.0620	2.0000	1
195	4589	13	0	7	Q3	2012	7.0800	2.1240	4.0000	1
195	4609	23	0	5	Q2	2012	7.0800	2.8320	4.0000	1
195	4628	24	0	7	Q3	2012	5.3100	1.8585	3.0000	1
195	4664	7	516	8	Q3	2012	5.3100	1.9647	3.0000	1
195	4846	17	0	1	Q1	2012	3.5400	1.0620	2.0000	1
195	4909	7	504	2	Q1	2012	5.3100	1.8054	3.0000	1
195	4934	24	0	3	Q1	2012	5.3100	2.3895	3.0000	1
195	5125	17	0	6	Q2	2012	5.3100	2.3364	3.0000	1
195	5345	6	0	9	Q3	2012	7.0800	2.8320	4.0000	1
195	5686	3	197	6	Q2	2012	7.0800	3.0444	4.0000	1
195	5760	13	0	4	Q2	2012	7.0800	2.4780	4.0000	1
195	5895	17	0	3	Q1	2012	7.0800	2.6904	4.0000	1
195	5971	17	0	6	Q2	2012	3.5400	1.7700	2.0000	1
195	6017	11	829	6	Q2	2012	7.0800	2.1240	4.0000	1
195	6113	16	1231	9	Q3	2012	7.0800	3.4692	4.0000	1
195	6474	15	0	6	Q2	2012	3.5400	1.3098	2.0000	1
195	6667	24	1856	6	Q2	2012	5.3100	2.1240	3.0000	1
195	7266	24	0	3	Q1	2012	5.3100	2.3364	3.0000	1
195	7336	2	118	6	Q2	2012	1.7700	0.5664	1.0000	1
195	7352	7	0	1	Q1	2012	7.0800	2.4780	4.0000	1
195	7355	13	0	6	Q2	2012	5.3100	2.1240	3.0000	1
195	7359	13	0	8	Q3	2012	7.0800	2.5488	4.0000	1
195	7721	13	0	3	Q1	2012	5.3100	2.3895	3.0000	1
195	7841	6	0	9	Q3	2012	5.3100	1.8585	3.0000	1
195	8208	24	0	12	Q4	2012	7.0800	2.9736	4.0000	1
195	8306	24	0	4	Q2	2012	5.3100	2.0709	3.0000	1
195	8947	3	0	3	Q1	2012	5.3100	1.7523	3.0000	1
195	8958	22	1711	12	Q4	2012	5.3100	1.8054	3.0000	1
195	8963	17	0	12	Q4	2012	5.3100	1.8585	3.0000	1
195	9297	13	0	12	Q4	2012	3.5400	1.5930	2.0000	1
195	9357	7	504	2	Q1	2012	7.0800	2.3364	4.0000	1
195	9564	17	1292	1	Q1	2012	8.8500	2.7435	5.0000	1
195	9758	15	0	5	Q2	2012	7.0800	3.0444	4.0000	1
195	9801	11	842	12	Q4	2012	3.5400	1.3098	2.0000	1
195	9891	23	0	10	Q4	2012	7.0800	2.6904	4.0000	1
195	10191	24	1851	4	Q2	2012	5.3100	2.0709	3.0000	1
196	49	6	511	5	Q2	2012	7.4100	2.5935	3.0000	1
196	99	3	0	9	Q3	2012	9.8800	3.6556	4.0000	1
196	193	6	0	9	Q3	2012	7.4100	3.1122	3.0000	1
196	319	15	0	2	Q1	2012	4.9400	1.7290	2.0000	1
196	647	3	0	3	Q1	2012	4.9400	1.6302	2.0000	1
196	930	17	1304	7	Q3	2012	12.3500	4.5695	5.0000	1
196	962	15	1138	3	Q1	2012	4.9400	1.8278	2.0000	1
196	1053	13	0	1	Q1	2012	7.4100	2.2971	3.0000	1
196	1055	15	0	12	Q4	2012	4.9400	1.6302	2.0000	1
196	1207	14	0	6	Q2	2012	4.9400	1.4820	2.0000	1
196	1341	3	0	9	Q3	2012	7.4100	2.4453	3.0000	1
196	1360	13	0	2	Q1	2012	9.8800	4.5448	4.0000	1
196	1415	16	1216	2	Q1	2012	7.4100	2.9640	3.0000	1
196	1567	16	0	8	Q3	2012	7.4100	3.6309	3.0000	1
196	2065	17	1303	6	Q2	2012	7.4100	2.4453	3.0000	1
196	2086	13	0	12	Q4	2012	9.8800	3.8532	4.0000	1
196	2587	16	0	9	Q3	2012	7.4100	3.1863	3.0000	1
196	2588	23	0	3	Q1	2012	7.4100	2.3712	3.0000	1
196	2769	16	0	5	Q2	2012	9.8800	3.3592	4.0000	1
196	2942	17	1314	11	Q4	2012	7.4100	3.1863	3.0000	1
196	2963	7	0	7	Q3	2012	9.8800	3.1616	4.0000	1
196	2968	13	0	4	Q2	2012	9.8800	3.8532	4.0000	1
196	3360	13	0	3	Q1	2012	7.4100	2.6676	3.0000	1
196	3491	16	0	6	Q2	2012	4.9400	1.7784	2.0000	1
196	3552	17	0	2	Q1	2012	9.8800	3.9520	4.0000	1
196	3692	16	1214	2	Q1	2012	9.8800	3.5568	4.0000	1
196	3740	15	0	9	Q3	2012	9.8800	3.1616	4.0000	1
196	3942	15	0	5	Q2	2012	9.8800	3.9520	4.0000	1
196	4334	24	1869	12	Q4	2012	9.8800	3.3592	4.0000	1
196	4445	17	1314	11	Q4	2012	7.4100	2.8899	3.0000	1
196	4692	15	0	5	Q2	2012	4.9400	1.7784	2.0000	1
196	4925	16	1228	8	Q3	2012	4.9400	1.9266	2.0000	1
196	5167	24	0	2	Q1	2012	7.4100	2.9640	3.0000	1
196	5238	17	0	4	Q2	2012	4.9400	1.9266	2.0000	1
196	5293	6	504	2	Q1	2012	7.4100	3.6309	3.0000	1
196	5398	17	0	8	Q3	2012	7.4100	2.9640	3.0000	1
196	5432	16	0	8	Q3	2012	7.4100	2.7417	3.0000	1
196	5733	11	0	6	Q2	2012	9.8800	4.0508	4.0000	1
196	6091	24	0	3	Q1	2012	7.4100	2.2971	3.0000	1
196	6297	15	1154	10	Q4	2012	7.4100	2.6676	3.0000	1
196	6421	7	0	1	Q1	2012	7.4100	3.6309	3.0000	1
196	6844	11	0	3	Q1	2012	4.9400	2.1242	2.0000	1
196	7137	11	0	12	Q4	2012	7.4100	2.5935	3.0000	1
196	7250	13	0	11	Q4	2012	9.8800	4.2484	4.0000	1
196	7558	13	0	6	Q2	2012	4.9400	2.4206	2.0000	1
196	7818	11	829	6	Q2	2012	4.9400	2.3712	2.0000	1
196	8070	6	0	11	Q4	2012	7.4100	2.6676	3.0000	1
196	8153	24	0	12	Q4	2012	4.9400	2.1736	2.0000	1
196	8185	2	0	12	Q4	2012	2.4700	0.8892	1.0000	1
196	8814	13	0	12	Q4	2012	7.4100	2.2971	3.0000	1
196	9109	7	0	8	Q3	2012	7.4100	2.2971	3.0000	1
196	9581	24	1851	4	Q2	2012	9.8800	3.2604	4.0000	1
196	9622	7	523	11	Q4	2012	4.9400	1.8278	2.0000	1
196	10090	14	0	2	Q1	2012	4.9400	2.1736	2.0000	1
196	10273	17	0	11	Q4	2012	7.4100	3.7050	3.0000	1
197	217	13	0	3	Q1	2012	14.5500	5.9655	5.0000	1
197	293	22	0	7	Q3	2012	5.8200	2.0370	2.0000	1
197	1607	17	0	2	Q1	2012	8.7300	2.9682	3.0000	1
197	1633	3	0	2	Q1	2012	11.6400	5.3544	4.0000	1
197	1813	17	0	11	Q4	2012	8.7300	3.4047	3.0000	1
197	2077	23	1786	10	Q4	2012	11.6400	5.1216	4.0000	1
197	2204	3	0	6	Q2	2012	8.7300	3.2301	3.0000	1
197	2210	13	0	8	Q3	2012	11.6400	5.7036	4.0000	1
197	2737	15	0	11	Q4	2012	8.7300	3.2301	3.0000	1
197	2921	16	0	12	Q4	2012	5.8200	2.0952	2.0000	1
197	3004	7	0	7	Q3	2012	11.6400	5.3544	4.0000	1
197	3054	24	0	4	Q2	2012	8.7300	3.7539	3.0000	1
197	3442	3	0	7	Q3	2012	11.6400	4.0740	4.0000	1
197	3966	15	0	12	Q4	2012	11.6400	4.1904	4.0000	1
197	4069	17	0	12	Q4	2012	8.7300	3.0555	3.0000	1
197	4498	17	0	12	Q4	2012	8.7300	2.8809	3.0000	1
197	4522	17	1303	6	Q2	2012	8.7300	3.8412	3.0000	1
197	5056	15	0	2	Q1	2012	11.6400	4.7724	4.0000	1
197	5288	13	0	1	Q1	2012	5.8200	2.2116	2.0000	1
197	5337	2	0	7	Q3	2012	2.9100	1.3677	1.0000	1
197	5426	24	1866	11	Q4	2012	8.7300	3.6666	3.0000	1
197	5537	3	0	3	Q1	2012	5.8200	2.3862	2.0000	1
197	5686	3	0	8	Q3	2012	8.7300	3.0555	3.0000	1
197	5819	15	0	5	Q2	2012	11.6400	5.4708	4.0000	1
197	5923	23	1775	5	Q2	2012	8.7300	2.7063	3.0000	1
197	6347	17	0	9	Q3	2012	8.7300	3.2301	3.0000	1
197	6630	24	1860	8	Q3	2012	8.7300	3.9285	3.0000	1
197	6799	17	0	8	Q3	2012	11.6400	4.5396	4.0000	1
197	6933	15	0	6	Q2	2012	5.8200	2.1534	2.0000	1
197	7692	24	0	5	Q2	2012	11.6400	5.0052	4.0000	1
197	7862	16	0	6	Q2	2012	14.5500	4.9470	5.0000	1
197	7866	15	0	4	Q2	2012	8.7300	3.5793	3.0000	1
197	7914	24	0	5	Q2	2012	5.8200	2.2698	2.0000	1
197	8046	7	0	1	Q1	2012	11.6400	5.2380	4.0000	1
197	8248	6	518	8	Q3	2012	11.6400	4.4232	4.0000	1
197	8435	17	0	6	Q2	2012	8.7300	3.0555	3.0000	1
197	8452	16	0	1	Q1	2012	14.5500	4.6560	5.0000	1
197	8452	16	0	5	Q2	2012	11.6400	3.6084	4.0000	1
197	8477	3	187	2	Q1	2012	11.6400	3.6084	4.0000	1
197	8587	22	0	6	Q2	2012	5.8200	2.9100	2.0000	1
197	9014	13	980	3	Q1	2012	8.7300	4.1031	3.0000	1
197	9081	6	0	2	Q1	2012	11.6400	5.4708	4.0000	1
197	9286	13	0	11	Q4	2012	8.7300	3.6666	3.0000	1
197	9324	3	0	7	Q3	2012	8.7300	3.4920	3.0000	1
197	9495	13	0	9	Q3	2012	5.8200	2.9100	2.0000	1
197	9510	16	0	10	Q4	2012	11.6400	5.5872	4.0000	1
198	178	13	0	7	Q3	2012	2.7600	0.8832	3.0000	1
198	187	13	0	9	Q3	2012	2.7600	0.9108	3.0000	1
198	645	11	0	6	Q2	2012	2.7600	1.1592	3.0000	1
198	870	24	0	6	Q2	2012	4.6000	1.4260	5.0000	1
198	1197	23	1783	9	Q3	2012	2.7600	0.8556	3.0000	1
198	1263	13	1000	12	Q4	2012	2.7600	1.3248	3.0000	1
198	1491	16	0	1	Q1	2012	2.7600	1.0764	3.0000	1
198	1633	3	207	11	Q4	2012	3.6800	1.1408	4.0000	1
198	1848	11	0	3	Q1	2012	1.8400	0.8280	2.0000	1
198	1965	17	1311	10	Q4	2012	2.7600	1.1040	3.0000	1
198	2279	15	0	3	Q1	2012	2.7600	1.3524	3.0000	1
198	2412	7	0	10	Q4	2012	2.7600	1.2972	3.0000	1
198	2570	16	0	3	Q1	2012	1.8400	0.6440	2.0000	1
198	2614	13	0	3	Q1	2012	3.6800	1.2880	4.0000	1
198	2767	11	0	4	Q2	2012	2.7600	1.3248	3.0000	1
198	2825	11	0	7	Q3	2012	4.6000	1.4720	5.0000	1
198	3153	13	992	9	Q3	2012	1.8400	0.8096	2.0000	1
198	3242	3	197	6	Q2	2012	3.6800	1.2512	4.0000	1
198	3305	13	0	3	Q1	2012	2.7600	1.1316	3.0000	1
198	3422	23	0	5	Q2	2012	1.8400	0.7360	2.0000	1
198	3491	16	0	3	Q1	2012	2.7600	0.9108	3.0000	1
198	3711	3	0	1	Q1	2012	2.7600	0.8832	3.0000	1
198	4342	13	0	1	Q1	2012	2.7600	1.3524	3.0000	1
198	4611	15	1140	4	Q2	2012	1.8400	0.8464	2.0000	1
198	4678	13	976	1	Q1	2012	3.6800	1.3984	4.0000	1
198	4682	15	1134	1	Q1	2012	4.6000	1.7480	5.0000	1
198	5174	16	0	6	Q2	2012	2.7600	1.0488	3.0000	1
198	5245	11	0	7	Q3	2012	1.8400	0.7176	2.0000	1
198	5289	7	0	11	Q4	2012	4.6000	2.2540	5.0000	1
198	5568	23	0	5	Q2	2012	1.8400	0.9016	2.0000	1
198	6061	17	0	8	Q3	2012	3.6800	1.5088	4.0000	1
198	6420	14	1070	8	Q3	2012	0.9200	0.3772	1.0000	1
198	6690	17	0	2	Q1	2012	3.6800	1.2144	4.0000	1
198	6713	13	0	7	Q3	2012	2.7600	0.9108	3.0000	1
198	6835	16	0	3	Q1	2012	3.6800	1.2880	4.0000	1
198	6842	24	0	11	Q4	2012	2.7600	1.0212	3.0000	1
198	6932	13	980	3	Q1	2012	1.8400	0.6808	2.0000	1
198	6982	13	0	12	Q4	2012	2.7600	1.3800	3.0000	1
198	7051	16	0	12	Q4	2012	1.8400	0.6624	2.0000	1
198	7365	13	0	11	Q4	2012	3.6800	1.5824	4.0000	1
198	7811	11	0	8	Q3	2012	3.6800	1.7296	4.0000	1
198	8048	7	0	10	Q4	2012	2.7600	1.1316	3.0000	1
198	8130	6	0	4	Q2	2012	2.7600	0.9384	3.0000	1
198	8311	23	1773	4	Q2	2012	2.7600	1.3248	3.0000	1
198	8946	23	1773	4	Q2	2012	2.7600	1.1592	3.0000	1
198	9156	6	522	10	Q4	2012	2.7600	1.1040	3.0000	1
198	9199	2	0	9	Q3	2012	1.8400	0.9016	2.0000	1
198	9245	15	0	3	Q1	2012	3.6800	1.3616	4.0000	1
198	9318	16	0	7	Q3	2012	2.7600	0.8280	3.0000	1
198	9500	6	523	11	Q4	2012	3.6800	1.6560	4.0000	1
198	10167	17	0	9	Q3	2012	1.8400	0.5520	2.0000	1
199	192	16	1231	9	Q3	2012	5.0100	2.1042	3.0000	1
199	878	3	0	1	Q1	2012	5.0100	2.5050	3.0000	1
199	893	13	0	2	Q1	2012	3.3400	1.2358	2.0000	1
199	1197	23	0	11	Q4	2012	6.6800	2.6720	4.0000	1
199	1319	11	821	2	Q1	2012	3.3400	1.1690	2.0000	1
199	1415	16	0	1	Q1	2012	5.0100	1.7535	3.0000	1
199	1428	24	0	6	Q2	2012	3.3400	1.5698	2.0000	1
199	1720	16	0	12	Q4	2012	5.0100	1.8537	3.0000	1
199	2039	11	821	3	Q1	2012	5.0100	1.6533	3.0000	1
199	2135	22	0	10	Q4	2012	3.3400	1.6700	2.0000	1
199	2171	23	0	4	Q2	2012	5.0100	2.2545	3.0000	1
199	2263	11	0	10	Q4	2012	5.0100	2.0541	3.0000	1
199	2313	24	1856	6	Q2	2012	3.3400	1.1356	2.0000	1
199	2493	17	0	12	Q4	2012	5.0100	2.0040	3.0000	1
199	2690	3	190	3	Q1	2012	5.0100	1.5030	3.0000	1
199	2709	7	516	8	Q3	2012	3.3400	1.2024	2.0000	1
199	3027	24	0	4	Q2	2012	5.0100	1.9539	3.0000	1
199	3448	3	201	8	Q3	2012	8.3500	3.1730	5.0000	1
199	4078	3	0	2	Q1	2012	5.0100	2.4048	3.0000	1
199	4081	24	1866	11	Q4	2012	5.0100	1.6533	3.0000	1
199	4105	3	0	3	Q1	2012	5.0100	2.3046	3.0000	1
199	4310	15	1138	3	Q1	2012	5.0100	2.2044	3.0000	1
199	4556	13	0	11	Q4	2012	5.0100	1.8537	3.0000	1
199	4670	17	0	9	Q3	2012	5.0100	2.5050	3.0000	1
199	5432	16	0	11	Q4	2012	3.3400	1.3026	2.0000	1
199	5473	24	0	8	Q3	2012	3.3400	1.3026	2.0000	1
199	5766	16	0	12	Q4	2012	5.0100	1.5531	3.0000	1
199	5844	17	1312	10	Q4	2012	5.0100	2.1042	3.0000	1
199	5944	3	0	9	Q3	2012	6.6800	2.6052	4.0000	1
199	6148	11	0	1	Q1	2012	3.3400	1.0688	2.0000	1
199	6445	24	0	7	Q3	2012	6.6800	2.6052	4.0000	1
199	6690	17	0	8	Q3	2012	5.0100	1.7535	3.0000	1
199	6832	3	0	8	Q3	2012	6.6800	2.4716	4.0000	1
199	7292	13	0	3	Q1	2012	5.0100	1.9539	3.0000	1
199	7390	15	0	6	Q2	2012	6.6800	3.2732	4.0000	1
199	7457	13	0	11	Q4	2012	6.6800	2.3380	4.0000	1
199	7502	16	1225	7	Q3	2012	5.0100	2.0040	3.0000	1
199	7813	17	0	2	Q1	2012	3.3400	1.1022	2.0000	1
199	7813	17	0	5	Q2	2012	5.0100	2.2044	3.0000	1
199	8108	17	0	2	Q1	2012	6.6800	2.1376	4.0000	1
199	8137	15	0	12	Q4	2012	8.3500	3.1730	5.0000	1
199	8235	22	0	1	Q1	2012	1.6700	0.7515	1.0000	1
199	8499	24	0	12	Q4	2012	3.3400	1.4696	2.0000	1
199	8500	17	0	3	Q1	2012	3.3400	1.0354	2.0000	1
199	9213	11	0	12	Q4	2012	5.0100	1.8036	3.0000	1
199	9307	11	0	6	Q2	2012	6.6800	2.7388	4.0000	1
199	9810	24	0	3	Q1	2012	5.0100	1.7535	3.0000	1
199	9928	16	0	3	Q1	2012	5.0100	2.0040	3.0000	1
199	10197	14	0	1	Q1	2012	1.6700	0.5177	1.0000	1
200	293	22	0	12	Q4	2012	5.3000	2.1200	2.0000	1
200	341	17	0	3	Q1	2012	7.9500	3.1800	3.0000	1
200	394	14	1061	4	Q2	2012	2.6500	0.9805	1.0000	1
200	748	24	0	9	Q3	2012	7.9500	3.4185	3.0000	1
200	1094	15	0	4	Q2	2012	5.3000	2.0670	2.0000	1
200	1167	7	0	10	Q4	2012	7.9500	3.1005	3.0000	1
200	1352	17	0	6	Q2	2012	10.6000	3.8160	4.0000	1
200	2422	13	0	6	Q2	2012	5.3000	1.6430	2.0000	1
200	2587	16	1231	9	Q3	2012	7.9500	3.4185	3.0000	1
200	2695	13	0	7	Q3	2012	7.9500	2.8620	3.0000	1
200	2960	14	1064	5	Q2	2012	7.9500	3.2595	3.0000	1
200	2966	17	0	11	Q4	2012	10.6000	4.2400	4.0000	1
200	3092	15	0	9	Q3	2012	10.6000	3.1800	4.0000	1
200	3627	3	0	10	Q4	2012	7.9500	2.8620	3.0000	1
200	3738	6	519	9	Q3	2012	7.9500	2.9415	3.0000	1
200	4397	16	0	5	Q2	2012	10.6000	3.7100	4.0000	1
200	4439	15	0	1	Q1	2012	10.6000	4.3460	4.0000	1
200	4606	3	0	11	Q4	2012	10.6000	3.6040	4.0000	1
200	4925	16	0	4	Q2	2012	5.3000	2.3850	2.0000	1
200	5050	17	1294	2	Q1	2012	7.9500	3.3390	3.0000	1
200	5134	3	0	3	Q1	2012	10.6000	4.6640	4.0000	1
200	5141	7	504	2	Q1	2012	5.3000	2.2260	2.0000	1
200	5431	6	0	11	Q4	2012	7.9500	3.8955	3.0000	1
200	5436	7	504	2	Q1	2012	5.3000	1.8020	2.0000	1
200	5686	3	0	9	Q3	2012	5.3000	1.9610	2.0000	1
200	6061	17	0	12	Q4	2012	5.3000	1.9080	2.0000	1
200	6169	13	986	6	Q2	2012	7.9500	2.7825	3.0000	1
200	6228	11	0	12	Q4	2012	7.9500	3.7365	3.0000	1
200	6993	2	0	8	Q3	2012	5.3000	2.0140	2.0000	1
200	7072	16	0	7	Q3	2012	7.9500	3.5775	3.0000	1
200	7355	13	0	12	Q4	2012	10.6000	4.2400	4.0000	1
200	7416	13	0	7	Q3	2012	7.9500	2.7825	3.0000	1
200	7487	6	0	9	Q3	2012	10.6000	3.9220	4.0000	1
200	7622	3	0	5	Q2	2012	10.6000	3.1800	4.0000	1
200	7641	13	0	11	Q4	2012	7.9500	3.5775	3.0000	1
200	7862	16	1214	2	Q1	2012	10.6000	4.9820	4.0000	1
200	8125	7	0	3	Q1	2012	7.9500	2.8620	3.0000	1
200	8557	6	0	5	Q2	2012	10.6000	4.0280	4.0000	1
200	8629	24	1853	5	Q2	2012	5.3000	2.2790	2.0000	1
200	8682	6	0	6	Q2	2012	5.3000	2.0670	2.0000	1
200	8968	11	0	5	Q2	2012	7.9500	2.7825	3.0000	1
200	9040	16	1214	2	Q1	2012	7.9500	2.5440	3.0000	1
200	9419	11	0	5	Q2	2012	7.9500	3.4980	3.0000	1
200	9728	16	1220	4	Q2	2012	7.9500	3.4980	3.0000	1
201	192	16	0	5	Q2	2012	6.7500	2.8350	3.0000	1
201	293	22	0	8	Q3	2012	4.5000	1.5750	2.0000	1
201	544	2	119	7	Q3	2012	4.5000	1.7100	2.0000	1
201	582	15	1142	5	Q2	2012	9.0000	3.6000	4.0000	1
201	924	3	0	3	Q1	2012	9.0000	3.1500	4.0000	1
201	1115	22	1694	4	Q2	2012	4.5000	1.9800	2.0000	1
201	1137	7	0	8	Q3	2012	9.0000	2.7900	4.0000	1
201	1167	6	0	5	Q2	2012	6.7500	2.6325	3.0000	1
201	1168	17	1303	6	Q2	2012	4.5000	1.5750	2.0000	1
201	1263	13	0	11	Q4	2012	6.7500	2.6325	3.0000	1
201	1616	24	1860	8	Q3	2012	6.7500	2.4975	3.0000	1
201	1633	3	0	7	Q3	2012	9.0000	3.0600	4.0000	1
201	1633	3	0	12	Q4	2012	9.0000	4.1400	4.0000	1
201	1650	6	521	10	Q4	2012	9.0000	4.3200	4.0000	1
201	2373	13	0	1	Q1	2012	4.5000	2.0250	2.0000	1
201	2460	24	0	10	Q4	2012	11.2500	4.0500	5.0000	1
201	2533	6	0	8	Q3	2012	6.7500	2.3625	3.0000	1
201	2553	16	1236	12	Q4	2012	9.0000	2.8800	4.0000	1
201	2632	13	0	5	Q2	2012	6.7500	2.7675	3.0000	1
201	3196	13	0	1	Q1	2012	4.5000	2.0700	2.0000	1
201	3691	17	0	9	Q3	2012	9.0000	3.5100	4.0000	1
201	4158	24	1847	2	Q1	2012	4.5000	2.0250	2.0000	1
201	4169	6	0	8	Q3	2012	6.7500	2.4975	3.0000	1
201	5174	16	1235	11	Q4	2012	4.5000	1.6650	2.0000	1
201	5322	7	517	8	Q3	2012	6.7500	2.4975	3.0000	1
201	5387	7	0	7	Q3	2012	9.0000	4.3200	4.0000	1
201	5432	16	1228	8	Q3	2012	6.7500	2.4975	3.0000	1
201	5944	3	201	8	Q3	2012	6.7500	2.0925	3.0000	1
201	6403	2	0	9	Q3	2012	4.5000	1.3500	2.0000	1
201	6647	17	0	1	Q1	2012	6.7500	2.9025	3.0000	1
201	6800	24	1860	8	Q3	2012	6.7500	2.2275	3.0000	1
201	6904	13	0	5	Q2	2012	6.7500	2.4975	3.0000	1
201	6954	24	1845	1	Q1	2012	4.5000	2.1150	2.0000	1
201	7100	17	0	12	Q4	2012	4.5000	2.0250	2.0000	1
201	7204	11	0	6	Q2	2012	4.5000	1.4400	2.0000	1
201	7381	7	0	8	Q3	2012	9.0000	4.2300	4.0000	1
201	8242	17	0	6	Q2	2012	6.7500	2.4300	3.0000	1
201	8463	23	0	2	Q1	2012	6.7500	3.1050	3.0000	1
201	8526	11	0	4	Q2	2012	4.5000	1.6200	2.0000	1
201	9013	11	818	1	Q1	2012	11.2500	3.4875	5.0000	1
201	9040	16	0	9	Q3	2012	4.5000	2.1150	2.0000	1
201	9271	17	0	5	Q2	2012	9.0000	4.4100	4.0000	1
201	9324	3	0	8	Q3	2012	6.7500	3.2400	3.0000	1
201	9327	17	0	2	Q1	2012	11.2500	5.2875	5.0000	1
201	9604	24	0	8	Q3	2012	9.0000	2.7900	4.0000	1
201	9638	11	833	8	Q3	2012	6.7500	2.7675	3.0000	1
201	9788	13	0	1	Q1	2012	6.7500	2.9700	3.0000	1
201	10007	7	0	11	Q4	2012	6.7500	3.1050	3.0000	1
201	10019	11	820	2	Q1	2012	6.7500	2.0250	3.0000	1
201	10026	13	0	3	Q1	2012	9.0000	3.7800	4.0000	1
201	10261	2	0	6	Q2	2012	4.5000	1.3950	2.0000	1
202	79	17	0	4	Q2	2012	2.9800	1.4304	2.0000	1
202	118	3	199	7	Q3	2012	2.9800	0.9834	2.0000	1
202	136	15	1143	5	Q2	2012	7.4500	3.1290	5.0000	1
202	780	13	0	4	Q2	2012	7.4500	2.3840	5.0000	1
202	792	6	0	5	Q2	2012	4.4700	1.9221	3.0000	1
202	819	13	0	12	Q4	2012	2.9800	1.2814	2.0000	1
202	863	17	0	8	Q3	2012	5.9600	2.3244	4.0000	1
202	1221	15	0	7	Q3	2012	4.4700	1.3857	3.0000	1
202	1474	15	0	2	Q1	2012	5.9600	1.8476	4.0000	1
202	1594	11	0	7	Q3	2012	5.9600	2.5032	4.0000	1
202	1692	24	0	12	Q4	2012	5.9600	1.8476	4.0000	1
202	1720	16	1235	11	Q4	2012	4.4700	1.4304	3.0000	1
202	1773	13	0	11	Q4	2012	4.4700	1.6539	3.0000	1
202	2201	16	1236	12	Q4	2012	4.4700	1.4751	3.0000	1
202	2359	24	0	1	Q1	2012	2.9800	1.1026	2.0000	1
202	2378	16	0	3	Q1	2012	5.9600	2.9204	4.0000	1
202	2511	17	0	12	Q4	2012	4.4700	2.1009	3.0000	1
202	2908	11	0	11	Q4	2012	5.9600	2.9204	4.0000	1
202	2968	13	0	12	Q4	2012	7.4500	2.6075	5.0000	1
202	3271	13	0	7	Q3	2012	5.9600	1.7880	4.0000	1
202	3305	13	0	3	Q1	2012	4.4700	1.4751	3.0000	1
202	3491	16	0	8	Q3	2012	5.9600	1.8476	4.0000	1
202	3763	24	0	12	Q4	2012	5.9600	1.7880	4.0000	1
202	4782	24	0	8	Q3	2012	4.4700	1.7433	3.0000	1
202	4856	15	1140	4	Q2	2012	4.4700	1.7880	3.0000	1
202	4951	15	0	6	Q2	2012	2.9800	1.3410	2.0000	1
202	4973	17	0	2	Q1	2012	5.9600	2.5628	4.0000	1
202	5230	13	0	2	Q1	2012	5.9600	2.5032	4.0000	1
202	5295	16	0	5	Q2	2012	7.4500	3.7250	5.0000	1
202	5644	17	0	6	Q2	2012	4.4700	2.0562	3.0000	1
202	6082	13	0	12	Q4	2012	5.9600	2.6224	4.0000	1
202	6651	11	0	9	Q3	2012	4.4700	1.3857	3.0000	1
202	6741	24	0	3	Q1	2012	5.9600	2.0264	4.0000	1
202	6844	11	0	8	Q3	2012	2.9800	1.1026	2.0000	1
202	6877	24	0	10	Q4	2012	2.9800	1.0728	2.0000	1
202	7059	17	1312	10	Q4	2012	5.9600	2.8012	4.0000	1
202	7290	24	1866	11	Q4	2012	4.4700	1.3857	3.0000	1
202	7388	24	0	1	Q1	2012	2.9800	0.8940	2.0000	1
202	7547	24	0	2	Q1	2012	4.4700	1.8774	3.0000	1
202	7641	13	0	11	Q4	2012	4.4700	1.3410	3.0000	1
202	7831	17	0	8	Q3	2012	4.4700	1.9668	3.0000	1
202	8062	24	0	1	Q1	2012	5.9600	2.3244	4.0000	1
202	8452	16	0	11	Q4	2012	7.4500	2.3095	5.0000	1
202	8976	13	980	3	Q1	2012	4.4700	1.6539	3.0000	1
202	9019	7	501	1	Q1	2012	2.9800	0.9536	2.0000	1
202	9040	16	0	7	Q3	2012	4.4700	1.4304	3.0000	1
202	9124	24	0	8	Q3	2012	4.4700	1.7880	3.0000	1
202	9353	15	1150	8	Q3	2012	4.4700	1.8327	3.0000	1
202	9387	6	0	11	Q4	2012	5.9600	2.0264	4.0000	1
202	9556	15	0	4	Q2	2012	5.9600	2.2052	4.0000	1
202	9715	17	0	9	Q3	2012	5.9600	2.4436	4.0000	1
202	9788	13	986	6	Q2	2012	4.4700	2.0115	3.0000	1
202	9851	3	0	9	Q3	2012	2.9800	1.4304	2.0000	1
202	10101	7	516	8	Q3	2012	2.9800	1.2814	2.0000	1
203	130	14	0	12	Q4	2012	1.2600	0.4284	2.0000	1
203	133	6	523	11	Q4	2012	1.8900	0.8316	3.0000	1
203	439	13	0	3	Q1	2012	2.5200	1.0584	4.0000	1
203	488	14	0	10	Q4	2012	1.2600	0.5670	2.0000	1
203	751	6	0	6	Q2	2012	1.8900	0.7560	3.0000	1
203	837	11	0	1	Q1	2012	1.2600	0.5292	2.0000	1
203	1195	11	0	6	Q2	2012	2.5200	0.7812	4.0000	1
203	1310	16	1225	7	Q3	2012	1.8900	0.6426	3.0000	1
203	1332	11	0	12	Q4	2012	2.5200	0.7812	4.0000	1
203	1491	16	0	11	Q4	2012	1.8900	0.7371	3.0000	1
203	1821	13	0	4	Q2	2012	2.5200	1.2096	4.0000	1
203	1979	3	0	5	Q2	2012	2.5200	0.9828	4.0000	1
203	2443	13	0	8	Q3	2012	2.5200	1.1088	4.0000	1
203	2556	3	0	7	Q3	2012	2.5200	0.8568	4.0000	1
203	3103	24	0	9	Q3	2012	1.8900	0.7182	3.0000	1
203	3567	16	0	5	Q2	2012	1.8900	0.9072	3.0000	1
203	3877	14	1078	12	Q4	2012	1.2600	0.4158	2.0000	1
203	4610	23	0	2	Q1	2012	1.8900	0.7371	3.0000	1
203	4719	23	1789	12	Q4	2012	2.5200	0.7560	4.0000	1
203	5216	3	0	7	Q3	2012	1.8900	0.9261	3.0000	1
203	5408	6	523	11	Q4	2012	1.8900	0.8883	3.0000	1
203	5410	17	0	1	Q1	2012	1.8900	0.9450	3.0000	1
203	5533	13	980	3	Q1	2012	1.2600	0.6174	2.0000	1
203	5918	7	0	9	Q3	2012	2.5200	1.0836	4.0000	1
203	5944	3	204	9	Q3	2012	1.8900	0.6048	3.0000	1
203	6047	17	0	10	Q4	2012	2.5200	0.9576	4.0000	1
203	6148	11	0	1	Q1	2012	1.8900	0.6804	3.0000	1
203	6221	24	0	12	Q4	2012	2.5200	1.0836	4.0000	1
203	6542	7	0	3	Q1	2012	2.5200	1.0836	4.0000	1
203	6921	24	0	1	Q1	2012	1.8900	0.6804	3.0000	1
203	6966	24	0	6	Q2	2012	1.8900	0.7182	3.0000	1
203	7028	15	0	10	Q4	2012	1.2600	0.6174	2.0000	1
203	7396	11	842	12	Q4	2012	2.5200	1.1340	4.0000	1
203	7490	24	1853	5	Q2	2012	1.2600	0.5796	2.0000	1
203	7502	16	1236	12	Q4	2012	2.5200	0.8820	4.0000	1
203	7881	24	0	2	Q1	2012	2.5200	1.0080	4.0000	1
203	8254	17	0	12	Q4	2012	1.2600	0.6174	2.0000	1
203	8291	13	0	9	Q3	2012	2.5200	1.0584	4.0000	1
203	8594	7	504	2	Q1	2012	2.5200	1.0332	4.0000	1
203	9064	17	0	5	Q2	2012	2.5200	0.9576	4.0000	1
203	9234	24	0	11	Q4	2012	1.8900	0.9261	3.0000	1
203	9748	24	0	4	Q2	2012	1.8900	0.8505	3.0000	1
203	9960	7	0	1	Q1	2012	1.8900	0.6048	3.0000	1
204	3	15	0	11	Q4	2012	4.8000	2.3040	3.0000	1
204	317	15	0	11	Q4	2012	6.4000	2.1760	4.0000	1
204	638	11	0	12	Q4	2012	4.8000	1.8720	3.0000	1
204	1187	13	0	10	Q4	2012	4.8000	1.8240	3.0000	1
204	1214	11	0	1	Q1	2012	4.8000	1.8240	3.0000	1
204	1289	23	1789	12	Q4	2012	4.8000	2.0160	3.0000	1
204	1415	16	0	11	Q4	2012	4.8000	1.6800	3.0000	1
204	1541	15	0	7	Q3	2012	4.8000	2.1120	3.0000	1
204	1720	16	1236	12	Q4	2012	4.8000	1.7760	3.0000	1
204	1822	7	0	7	Q3	2012	3.2000	1.5360	2.0000	1
204	1928	7	523	11	Q4	2012	4.8000	1.4880	3.0000	1
204	1931	15	0	6	Q2	2012	4.8000	1.4880	3.0000	1
204	1965	17	0	10	Q4	2012	3.2000	1.5360	2.0000	1
204	2327	13	0	6	Q2	2012	3.2000	1.3440	2.0000	1
204	2715	15	0	8	Q3	2012	4.8000	2.0640	3.0000	1
204	2850	3	0	4	Q2	2012	4.8000	1.4400	3.0000	1
204	3328	17	0	5	Q2	2012	4.8000	1.6320	3.0000	1
204	3491	16	0	2	Q1	2012	6.4000	3.0080	4.0000	1
204	3692	16	0	3	Q1	2012	4.8000	2.3520	3.0000	1
204	3716	17	0	3	Q1	2012	6.4000	2.6240	4.0000	1
204	4006	6	0	7	Q3	2012	6.4000	2.8800	4.0000	1
204	4149	11	0	2	Q1	2012	3.2000	1.3760	2.0000	1
204	5339	11	0	6	Q2	2012	3.2000	1.1840	2.0000	1
204	6087	13	986	6	Q2	2012	6.4000	2.2400	4.0000	1
204	6254	7	0	6	Q2	2012	4.8000	1.8240	3.0000	1
204	7031	11	0	6	Q2	2012	4.8000	2.2560	3.0000	1
204	7036	6	0	8	Q3	2012	4.8000	2.3040	3.0000	1
204	7095	24	0	4	Q2	2012	4.8000	1.6800	3.0000	1
204	7244	15	0	10	Q4	2012	4.8000	1.4880	3.0000	1
204	7281	17	0	11	Q4	2012	4.8000	1.6800	3.0000	1
204	7791	15	0	7	Q3	2012	4.8000	1.8720	3.0000	1
204	7822	3	0	10	Q4	2012	3.2000	1.3760	2.0000	1
204	7823	7	0	12	Q4	2012	8.0000	2.8000	5.0000	1
204	7870	15	0	12	Q4	2012	6.4000	3.1360	4.0000	1
204	7907	6	508	4	Q2	2012	6.4000	2.3680	4.0000	1
204	8235	22	1694	4	Q2	2012	1.6000	0.7200	1.0000	1
204	8242	17	0	11	Q4	2012	4.8000	2.2080	3.0000	1
204	8427	16	0	8	Q3	2012	3.2000	1.0560	2.0000	1
204	8860	17	0	7	Q3	2012	3.2000	1.1200	2.0000	1
204	9065	13	0	3	Q1	2012	8.0000	3.2000	5.0000	1
204	9144	13	0	7	Q3	2012	4.8000	1.8720	3.0000	1
204	9184	3	0	7	Q3	2012	4.8000	1.8240	3.0000	1
204	9309	17	0	1	Q1	2012	4.8000	1.5840	3.0000	1
204	9505	15	0	3	Q1	2012	6.4000	2.0480	4.0000	1
204	9557	3	0	4	Q2	2012	3.2000	0.9920	2.0000	1
204	9837	17	0	3	Q1	2012	6.4000	2.5600	4.0000	1
204	9866	3	0	10	Q4	2012	3.2000	0.9600	2.0000	1
204	9977	11	0	5	Q2	2012	3.2000	1.1840	2.0000	1
205	230	2	0	12	Q4	2012	2.7100	0.8943	1.0000	1
205	354	23	0	12	Q4	2012	10.8400	5.4200	4.0000	1
205	780	13	0	3	Q1	2012	5.4200	2.2764	2.0000	1
205	870	24	0	9	Q3	2012	13.5500	6.3685	5.0000	1
205	986	15	1134	1	Q1	2012	8.1300	3.4146	3.0000	1
205	1006	14	0	9	Q3	2012	5.4200	2.4932	2.0000	1
205	1185	17	0	11	Q4	2012	10.8400	4.3360	4.0000	1
205	1533	3	0	11	Q4	2012	8.1300	3.7398	3.0000	1
205	1650	6	521	10	Q4	2012	8.1300	2.6016	3.0000	1
205	1785	3	0	7	Q3	2012	5.4200	2.2764	2.0000	1
205	1991	13	0	6	Q2	2012	10.8400	5.4200	4.0000	1
205	2245	11	0	4	Q2	2012	8.1300	3.6585	3.0000	1
205	2482	13	0	6	Q2	2012	8.1300	3.3333	3.0000	1
205	2496	11	0	1	Q1	2012	8.1300	3.5772	3.0000	1
205	3046	13	0	6	Q2	2012	5.4200	2.3306	2.0000	1
205	3178	11	0	12	Q4	2012	10.8400	3.2520	4.0000	1
205	3213	13	0	8	Q3	2012	5.4200	2.4390	2.0000	1
205	3302	13	0	5	Q2	2012	5.4200	2.4390	2.0000	1
205	3308	13	0	9	Q3	2012	8.1300	2.6829	3.0000	1
205	3855	15	0	7	Q3	2012	8.1300	3.2520	3.0000	1
205	3889	3	0	12	Q4	2012	8.1300	2.6829	3.0000	1
205	3985	11	829	6	Q2	2012	10.8400	5.0948	4.0000	1
205	3988	24	0	7	Q3	2012	8.1300	3.8211	3.0000	1
205	4066	3	0	4	Q2	2012	10.8400	3.4688	4.0000	1
205	4149	11	0	7	Q3	2012	10.8400	3.3604	4.0000	1
205	4527	3	0	6	Q2	2012	10.8400	3.3604	4.0000	1
205	4791	24	0	5	Q2	2012	8.1300	3.8211	3.0000	1
205	5054	6	0	8	Q3	2012	8.1300	3.6585	3.0000	1
205	5226	6	0	6	Q2	2012	8.1300	3.2520	3.0000	1
205	5614	15	0	7	Q3	2012	8.1300	3.6585	3.0000	1
205	5894	11	837	10	Q4	2012	10.8400	4.4444	4.0000	1
205	5944	3	0	8	Q3	2012	8.1300	2.5203	3.0000	1
205	6207	6	0	6	Q2	2012	8.1300	3.9024	3.0000	1
205	6267	24	0	3	Q1	2012	8.1300	2.6016	3.0000	1
205	7051	16	1233	10	Q4	2012	8.1300	2.4390	3.0000	1
205	7189	13	0	4	Q2	2012	8.1300	3.0081	3.0000	1
205	7281	17	0	12	Q4	2012	5.4200	1.8970	2.0000	1
205	7361	11	0	9	Q3	2012	8.1300	3.7398	3.0000	1
205	7381	7	0	8	Q3	2012	8.1300	3.1707	3.0000	1
205	7582	11	0	7	Q3	2012	13.5500	5.8265	5.0000	1
205	7702	16	0	8	Q3	2012	10.8400	3.9024	4.0000	1
205	8117	11	0	9	Q3	2012	8.1300	2.9268	3.0000	1
205	8122	11	0	6	Q2	2012	8.1300	3.7398	3.0000	1
205	8123	24	0	8	Q3	2012	8.1300	3.2520	3.0000	1
205	8407	15	0	9	Q3	2012	8.1300	2.4390	3.0000	1
205	8600	6	0	10	Q4	2012	8.1300	2.8455	3.0000	1
205	8730	7	504	2	Q1	2012	10.8400	3.5772	4.0000	1
205	8824	15	0	10	Q4	2012	10.8400	3.5772	4.0000	1
205	8899	7	516	8	Q3	2012	5.4200	2.1680	2.0000	1
205	9233	24	0	9	Q3	2012	8.1300	2.7642	3.0000	1
205	9557	3	0	2	Q1	2012	8.1300	2.5203	3.0000	1
205	9557	3	0	5	Q2	2012	8.1300	3.3333	3.0000	1
205	9694	7	0	11	Q4	2012	8.1300	2.6016	3.0000	1
205	10100	15	1138	3	Q1	2012	8.1300	3.2520	3.0000	1
206	764	6	0	7	Q3	2012	8.4400	3.1228	4.0000	1
206	785	15	0	11	Q4	2012	4.2200	1.6036	2.0000	1
206	805	6	0	9	Q3	2012	6.3300	2.8485	3.0000	1
206	856	11	0	3	Q1	2012	10.5500	4.6420	5.0000	1
206	1145	17	0	12	Q4	2012	8.4400	2.9540	4.0000	1
206	1468	13	0	8	Q3	2012	8.4400	4.0512	4.0000	1
206	1589	15	0	9	Q3	2012	4.2200	1.3504	2.0000	1
206	1634	3	0	4	Q2	2012	4.2200	1.3504	2.0000	1
206	1821	13	0	12	Q4	2012	6.3300	2.7852	3.0000	1
206	1856	24	0	9	Q3	2012	8.4400	2.8696	4.0000	1
206	1977	23	0	1	Q1	2012	6.3300	2.0256	3.0000	1
206	1987	13	0	6	Q2	2012	4.2200	1.3082	2.0000	1
206	2210	13	0	7	Q3	2012	4.2200	1.6458	2.0000	1
206	2443	13	0	12	Q4	2012	6.3300	2.4687	3.0000	1
206	2690	3	185	1	Q1	2012	8.4400	2.7852	4.0000	1
206	2952	23	1765	1	Q1	2012	4.2200	1.3082	2.0000	1
206	2981	23	0	10	Q4	2012	4.2200	1.5614	2.0000	1
206	3003	6	0	9	Q3	2012	6.3300	2.2155	3.0000	1
206	3160	17	1314	11	Q4	2012	4.2200	1.8146	2.0000	1
206	3513	7	0	5	Q2	2012	6.3300	2.6586	3.0000	1
206	3691	17	1314	11	Q4	2012	4.2200	1.8146	2.0000	1
206	4029	17	0	9	Q3	2012	6.3300	2.4687	3.0000	1
206	4094	16	1235	11	Q4	2012	6.3300	2.0889	3.0000	1
206	4585	6	0	12	Q4	2012	6.3300	2.7219	3.0000	1
206	4664	7	0	6	Q2	2012	6.3300	2.7219	3.0000	1
206	4676	16	0	7	Q3	2012	6.3300	2.0889	3.0000	1
206	4730	2	120	7	Q3	2012	4.2200	1.9412	2.0000	1
206	4776	7	0	3	Q1	2012	6.3300	2.2788	3.0000	1
206	4803	23	0	2	Q1	2012	4.2200	1.5192	2.0000	1
206	5026	17	0	12	Q4	2012	6.3300	1.8990	3.0000	1
206	5432	16	1233	10	Q4	2012	6.3300	2.6586	3.0000	1
206	5485	14	1071	8	Q3	2012	6.3300	3.0384	3.0000	1
206	5866	24	1845	1	Q1	2012	4.2200	1.3504	2.0000	1
206	5902	22	1709	11	Q4	2012	4.2200	2.1100	2.0000	1
206	5962	17	1304	7	Q3	2012	8.4400	3.6292	4.0000	1
206	6090	6	0	8	Q3	2012	6.3300	2.5320	3.0000	1
206	6562	24	1851	4	Q2	2012	6.3300	2.0256	3.0000	1
206	6598	11	0	11	Q4	2012	6.3300	2.0256	3.0000	1
206	6666	17	0	4	Q2	2012	8.4400	3.4604	4.0000	1
206	6667	24	1860	8	Q3	2012	4.2200	1.8990	2.0000	1
206	6760	17	0	1	Q1	2012	6.3300	1.9623	3.0000	1
206	7496	13	0	2	Q1	2012	6.3300	3.0384	3.0000	1
206	7556	17	1292	1	Q1	2012	8.4400	2.6164	4.0000	1
206	7662	24	0	4	Q2	2012	6.3300	2.5953	3.0000	1
206	8074	17	0	6	Q2	2012	6.3300	1.8990	3.0000	1
206	8336	17	1311	10	Q4	2012	6.3300	2.5953	3.0000	1
206	8577	23	1789	12	Q4	2012	4.2200	1.7302	2.0000	1
206	8747	7	0	10	Q4	2012	4.2200	1.3926	2.0000	1
206	8970	22	0	7	Q3	2012	4.2200	1.4770	2.0000	1
206	9040	16	0	6	Q2	2012	6.3300	2.5320	3.0000	1
206	9401	13	0	7	Q3	2012	4.2200	1.6880	2.0000	1
206	9535	11	0	10	Q4	2012	4.2200	1.3082	2.0000	1
206	9598	6	0	9	Q3	2012	6.3300	2.7219	3.0000	1
206	9712	7	0	4	Q2	2012	6.3300	2.0256	3.0000	1
206	9745	17	0	10	Q4	2012	6.3300	3.1017	3.0000	1
206	9831	15	0	4	Q2	2012	4.2200	1.8146	2.0000	1
206	9853	14	1064	5	Q2	2012	4.2200	1.3082	2.0000	1
206	9929	13	980	3	Q1	2012	8.4400	3.5448	4.0000	1
206	10131	17	0	5	Q2	2012	6.3300	2.3421	3.0000	1
207	276	15	0	3	Q1	2012	4.9600	2.3808	4.0000	1
207	529	24	0	5	Q2	2012	4.9600	2.1328	4.0000	1
207	582	15	0	5	Q2	2012	3.7200	1.8600	3.0000	1
207	598	7	0	12	Q4	2012	4.9600	1.8352	4.0000	1
207	903	24	0	2	Q1	2012	3.7200	1.1532	3.0000	1
207	940	7	0	9	Q3	2012	3.7200	1.5996	3.0000	1
207	1175	7	0	11	Q4	2012	6.2000	2.9760	5.0000	1
207	1261	24	0	3	Q1	2012	3.7200	1.3764	3.0000	1
207	1681	13	0	6	Q2	2012	2.4800	1.1656	2.0000	1
207	1801	6	508	4	Q2	2012	3.7200	1.2276	3.0000	1
207	1821	13	0	4	Q2	2012	3.7200	1.1904	3.0000	1
207	1862	17	0	7	Q3	2012	2.4800	1.2152	2.0000	1
207	2217	15	0	12	Q4	2012	3.7200	1.3764	3.0000	1
207	2905	3	0	4	Q2	2012	3.7200	1.4508	3.0000	1
207	3075	23	1775	5	Q2	2012	3.7200	1.8228	3.0000	1
207	3211	2	0	3	Q1	2012	1.2400	0.5332	1.0000	1
207	3415	15	0	1	Q1	2012	3.7200	1.1532	3.0000	1
207	3567	16	0	5	Q2	2012	3.7200	1.7856	3.0000	1
207	3859	24	0	7	Q3	2012	4.9600	1.7360	4.0000	1
207	4418	15	0	6	Q2	2012	4.9600	2.0336	4.0000	1
207	4422	6	521	10	Q4	2012	2.4800	0.9424	2.0000	1
207	4434	15	0	9	Q3	2012	3.7200	1.6740	3.0000	1
207	4693	3	0	6	Q2	2012	4.9600	2.3312	4.0000	1
207	4798	6	0	3	Q1	2012	4.9600	2.1328	4.0000	1
207	5106	11	0	5	Q2	2012	3.7200	1.3392	3.0000	1
207	5144	7	0	3	Q1	2012	4.9600	1.9840	4.0000	1
207	5196	13	0	4	Q2	2012	3.7200	1.3392	3.0000	1
207	5419	17	0	6	Q2	2012	4.9600	1.9344	4.0000	1
207	5790	17	0	12	Q4	2012	4.9600	2.3312	4.0000	1
207	5948	6	0	5	Q2	2012	2.4800	0.7440	2.0000	1
207	6001	17	0	5	Q2	2012	4.9600	1.9344	4.0000	1
207	6153	16	0	1	Q1	2012	2.4800	0.7688	2.0000	1
207	6169	13	986	6	Q2	2012	2.4800	0.7440	2.0000	1
207	6283	6	0	4	Q2	2012	3.7200	1.8228	3.0000	1
207	6666	17	0	2	Q1	2012	3.7200	1.4136	3.0000	1
207	6799	17	0	11	Q4	2012	4.9600	2.4304	4.0000	1
207	7072	16	0	6	Q2	2012	3.7200	1.7856	3.0000	1
207	7310	11	0	6	Q2	2012	4.9600	1.5376	4.0000	1
207	7441	24	0	11	Q4	2012	3.7200	1.3764	3.0000	1
207	7576	13	0	1	Q1	2012	3.7200	1.4136	3.0000	1
207	7655	17	0	4	Q2	2012	3.7200	1.5624	3.0000	1
207	8423	24	0	9	Q3	2012	3.7200	1.4508	3.0000	1
207	8617	17	1304	7	Q3	2012	3.7200	1.5996	3.0000	1
207	8746	23	1788	11	Q4	2012	3.7200	1.7112	3.0000	1
207	9125	13	0	11	Q4	2012	3.7200	1.4508	3.0000	1
207	9200	16	0	9	Q3	2012	3.7200	1.1532	3.0000	1
207	9200	16	1216	2	Q1	2012	4.9600	1.9344	4.0000	1
207	9327	17	0	12	Q4	2012	3.7200	1.1904	3.0000	1
207	9851	3	0	2	Q1	2012	2.4800	1.1904	2.0000	1
207	10243	17	0	4	Q2	2012	3.7200	1.7484	3.0000	1
208	88	11	0	4	Q2	2012	4.9400	2.0254	2.0000	1
208	400	23	0	1	Q1	2012	7.4100	3.4827	3.0000	1
208	771	15	0	6	Q2	2012	7.4100	2.8899	3.0000	1
208	970	14	0	2	Q1	2012	2.4700	0.8151	1.0000	1
208	1075	24	0	10	Q4	2012	7.4100	2.7417	3.0000	1
208	1145	17	1307	8	Q3	2012	9.8800	4.0508	4.0000	1
208	1900	6	508	4	Q2	2012	9.8800	3.0628	4.0000	1
208	1965	17	0	8	Q3	2012	9.8800	3.5568	4.0000	1
208	2690	3	0	3	Q1	2012	7.4100	3.7050	3.0000	1
208	2886	11	0	10	Q4	2012	7.4100	2.6676	3.0000	1
208	2896	3	0	3	Q1	2012	7.4100	3.1122	3.0000	1
208	3213	13	0	12	Q4	2012	4.9400	2.1736	2.0000	1
208	4094	16	0	10	Q4	2012	4.9400	2.1242	2.0000	1
208	4143	11	0	11	Q4	2012	4.9400	1.6796	2.0000	1
208	4293	14	0	1	Q1	2012	2.4700	0.7410	1.0000	1
208	4357	7	0	12	Q4	2012	7.4100	2.2230	3.0000	1
208	4434	15	1142	5	Q2	2012	7.4100	2.5935	3.0000	1
208	4618	3	0	3	Q1	2012	9.8800	4.9400	4.0000	1
208	4727	16	0	7	Q3	2012	4.9400	1.8278	2.0000	1
208	4727	16	0	12	Q4	2012	9.8800	3.7544	4.0000	1
208	5200	24	0	12	Q4	2012	4.9400	2.3712	2.0000	1
208	5374	16	1225	7	Q3	2012	4.9400	1.4820	2.0000	1
208	5637	15	0	12	Q4	2012	4.9400	2.2230	2.0000	1
208	6038	7	0	7	Q3	2012	7.4100	2.7417	3.0000	1
208	7149	13	988	7	Q3	2012	4.9400	1.8278	2.0000	1
208	7354	3	0	1	Q1	2012	7.4100	2.2230	3.0000	1
208	7416	13	0	3	Q1	2012	7.4100	2.8899	3.0000	1
208	7502	16	0	12	Q4	2012	7.4100	2.5935	3.0000	1
208	7576	13	984	5	Q2	2012	7.4100	2.8158	3.0000	1
208	7618	11	0	2	Q1	2012	7.4100	2.5194	3.0000	1
208	7715	13	980	3	Q1	2012	9.8800	4.0508	4.0000	1
208	7733	13	984	5	Q2	2012	12.3500	4.0755	5.0000	1
208	8015	13	0	9	Q3	2012	4.9400	1.9266	2.0000	1
208	8142	7	0	9	Q3	2012	4.9400	1.8772	2.0000	1
208	8321	11	837	10	Q4	2012	9.8800	3.0628	4.0000	1
208	8351	16	0	12	Q4	2012	7.4100	3.5568	3.0000	1
208	8369	11	0	3	Q1	2012	4.9400	1.7290	2.0000	1
208	8416	11	0	4	Q2	2012	9.8800	3.8532	4.0000	1
208	8953	24	1853	5	Q2	2012	9.8800	3.3592	4.0000	1
208	9286	13	0	11	Q4	2012	7.4100	2.7417	3.0000	1
208	9299	24	1860	8	Q3	2012	4.9400	1.8278	2.0000	1
208	9728	16	0	8	Q3	2012	7.4100	3.3345	3.0000	1
209	407	15	0	11	Q4	2012	3.7400	1.7952	2.0000	1
209	448	17	0	7	Q3	2012	3.7400	1.8326	2.0000	1
209	467	13	0	10	Q4	2012	5.6100	1.9635	3.0000	1
209	545	13	0	3	Q1	2012	3.7400	1.5708	2.0000	1
209	644	13	0	1	Q1	2012	7.4800	2.3936	4.0000	1
209	878	3	210	12	Q4	2012	5.6100	1.9074	3.0000	1
209	923	15	1138	3	Q1	2012	7.4800	3.6652	4.0000	1
209	1493	2	0	1	Q1	2012	1.8700	0.7667	1.0000	1
209	1991	13	0	6	Q2	2012	5.6100	1.7952	3.0000	1
209	2723	3	197	6	Q2	2012	7.4800	2.4684	4.0000	1
209	2977	7	0	4	Q2	2012	7.4800	2.3936	4.0000	1
209	3087	6	508	4	Q2	2012	5.6100	2.0757	3.0000	1
209	3109	11	829	6	Q2	2012	7.4800	3.6652	4.0000	1
209	3567	16	0	1	Q1	2012	5.6100	2.6928	3.0000	1
209	3838	17	0	8	Q3	2012	5.6100	1.8513	3.0000	1
209	4191	7	0	6	Q2	2012	3.7400	1.5708	2.0000	1
209	4433	6	513	6	Q2	2012	3.7400	1.3838	2.0000	1
209	4707	11	833	8	Q3	2012	5.6100	1.7391	3.0000	1
209	4810	23	1789	12	Q4	2012	7.4800	2.4684	4.0000	1
209	5005	14	0	1	Q1	2012	1.8700	0.8041	1.0000	1
209	5768	3	0	1	Q1	2012	3.7400	1.8700	2.0000	1
209	6392	7	0	5	Q2	2012	3.7400	1.3838	2.0000	1
209	6557	11	0	11	Q4	2012	3.7400	1.1968	2.0000	1
209	6806	6	510	5	Q2	2012	7.4800	3.2164	4.0000	1
209	7190	23	0	7	Q3	2012	5.6100	2.7489	3.0000	1
209	7207	13	0	12	Q4	2012	7.4800	3.5904	4.0000	1
209	8116	13	0	9	Q3	2012	7.4800	3.2164	4.0000	1
209	8139	11	0	7	Q3	2012	3.7400	1.5708	2.0000	1
209	8296	7	0	12	Q4	2012	7.4800	2.4684	4.0000	1
209	8668	13	0	9	Q3	2012	7.4800	3.5904	4.0000	1
209	9327	17	0	8	Q3	2012	5.6100	1.7952	3.0000	1
209	10249	7	0	3	Q1	2012	5.6100	1.9635	3.0000	1
210	463	23	0	9	Q3	2012	6.1600	1.9096	4.0000	1
210	1412	11	829	6	Q2	2012	6.1600	2.7104	4.0000	1
210	1545	15	0	9	Q3	2012	4.6200	1.6632	3.0000	1
210	1589	15	0	9	Q3	2012	4.6200	2.1252	3.0000	1
210	1634	3	0	4	Q2	2012	4.6200	1.6170	3.0000	1
210	1720	16	1216	2	Q1	2012	4.6200	1.4784	3.0000	1
210	2373	13	0	4	Q2	2012	3.0800	0.9548	2.0000	1
210	2663	16	1214	2	Q1	2012	6.1600	2.9568	4.0000	1
210	2832	13	0	5	Q2	2012	3.0800	1.1704	2.0000	1
210	3182	2	0	5	Q2	2012	1.5400	0.6776	1.0000	1
210	3819	23	1765	1	Q1	2012	6.1600	2.8952	4.0000	1
210	4279	6	0	5	Q2	2012	4.6200	1.7556	3.0000	1
210	4498	17	0	11	Q4	2012	6.1600	2.1560	4.0000	1
210	4676	16	1225	7	Q3	2012	4.6200	1.7094	3.0000	1
210	4700	17	0	5	Q2	2012	3.0800	0.9856	2.0000	1
210	5183	7	0	7	Q3	2012	4.6200	1.4784	3.0000	1
210	5476	13	0	1	Q1	2012	4.6200	1.5246	3.0000	1
210	5973	3	0	10	Q4	2012	4.6200	1.4322	3.0000	1
210	6254	7	0	3	Q1	2012	6.1600	2.5256	4.0000	1
210	6442	7	0	6	Q2	2012	3.0800	0.9548	2.0000	1
210	6531	13	0	9	Q3	2012	4.6200	1.7094	3.0000	1
210	6760	17	0	12	Q4	2012	4.6200	1.4322	3.0000	1
210	6995	11	0	11	Q4	2012	6.1600	2.0328	4.0000	1
210	7180	11	0	2	Q1	2012	7.7000	3.3110	5.0000	1
210	7862	16	1231	9	Q3	2012	4.6200	1.4784	3.0000	1
210	7913	17	0	2	Q1	2012	4.6200	2.0328	3.0000	1
210	8769	23	0	6	Q2	2012	4.6200	1.3860	3.0000	1
210	8937	7	0	5	Q2	2012	4.6200	2.1714	3.0000	1
210	9040	16	0	4	Q2	2012	3.0800	1.1396	2.0000	1
210	9125	13	0	6	Q2	2012	4.6200	1.3860	3.0000	1
210	9245	15	1142	5	Q2	2012	4.6200	1.8942	3.0000	1
210	9557	3	0	3	Q1	2012	4.6200	1.4322	3.0000	1
210	9580	15	0	7	Q3	2012	4.6200	2.0328	3.0000	1
210	9944	15	0	2	Q1	2012	4.6200	2.0790	3.0000	1
210	9980	6	526	12	Q4	2012	4.6200	1.3860	3.0000	1
211	93	13	0	1	Q1	2012	5.4400	1.9584	2.0000	1
211	182	15	0	9	Q3	2012	8.1600	3.2640	3.0000	1
211	187	13	0	11	Q4	2012	5.4400	1.7408	2.0000	1
211	260	11	0	7	Q3	2012	8.1600	2.7744	3.0000	1
211	277	2	0	11	Q4	2012	2.7200	0.8976	1.0000	1
211	878	3	0	1	Q1	2012	8.1600	3.0192	3.0000	1
211	934	15	0	11	Q4	2012	8.1600	3.1824	3.0000	1
211	997	3	0	4	Q2	2012	8.1600	3.0192	3.0000	1
211	1036	13	0	11	Q4	2012	10.8800	4.6784	4.0000	1
211	1071	13	0	12	Q4	2012	8.1600	2.6112	3.0000	1
211	1423	13	0	4	Q2	2012	5.4400	2.1216	2.0000	1
211	1533	3	210	12	Q4	2012	8.1600	3.0192	3.0000	1
211	1634	3	199	7	Q3	2012	10.8800	3.6992	4.0000	1
211	2019	16	0	5	Q2	2012	8.1600	3.0192	3.0000	1
211	2390	17	1303	6	Q2	2012	8.1600	3.2640	3.0000	1
211	2422	13	0	9	Q3	2012	10.8800	3.3728	4.0000	1
211	2511	17	0	12	Q4	2012	8.1600	3.2640	3.0000	1
211	2621	7	526	12	Q4	2012	8.1600	2.8560	3.0000	1
211	3305	13	0	12	Q4	2012	5.4400	2.0128	2.0000	1
211	3349	6	0	6	Q2	2012	10.8800	4.1344	4.0000	1
211	3397	17	0	4	Q2	2012	8.1600	3.8352	3.0000	1
211	3533	3	0	9	Q3	2012	10.8800	4.0256	4.0000	1
211	3693	3	0	12	Q4	2012	5.4400	1.9584	2.0000	1
211	3725	23	0	10	Q4	2012	5.4400	2.1760	2.0000	1
211	4155	7	0	10	Q4	2012	8.1600	2.6112	3.0000	1
211	4417	3	0	2	Q1	2012	8.1600	3.4272	3.0000	1
211	4498	17	0	8	Q3	2012	10.8800	3.4816	4.0000	1
211	4934	24	0	3	Q1	2012	8.1600	2.6112	3.0000	1
211	4959	13	0	7	Q3	2012	13.6000	4.7600	5.0000	1
211	5276	15	0	12	Q4	2012	13.6000	5.1680	5.0000	1
211	5280	7	0	12	Q4	2012	8.1600	2.9376	3.0000	1
211	5295	16	1223	6	Q2	2012	8.1600	3.1008	3.0000	1
211	5401	6	521	10	Q4	2012	8.1600	3.6720	3.0000	1
211	5867	11	0	5	Q2	2012	10.8800	4.5696	4.0000	1
211	6367	3	0	8	Q3	2012	5.4400	2.0128	2.0000	1
211	6522	13	0	12	Q4	2012	8.1600	3.0192	3.0000	1
211	6554	17	0	3	Q1	2012	5.4400	2.0128	2.0000	1
211	6799	17	0	8	Q3	2012	8.1600	2.5296	3.0000	1
211	6953	2	121	8	Q3	2012	2.7200	1.3600	1.0000	1
211	6956	13	0	5	Q2	2012	10.8800	4.7872	4.0000	1
211	7100	17	0	12	Q4	2012	10.8800	4.0256	4.0000	1
211	7109	11	0	1	Q1	2012	8.1600	3.2640	3.0000	1
211	7109	11	0	10	Q4	2012	8.1600	3.2640	3.0000	1
211	7502	16	1235	11	Q4	2012	8.1600	2.5296	3.0000	1
211	7567	24	0	10	Q4	2012	10.8800	3.6992	4.0000	1
211	7738	15	0	6	Q2	2012	10.8800	4.6784	4.0000	1
211	7871	6	519	9	Q3	2012	8.1600	2.8560	3.0000	1
211	8408	6	511	5	Q2	2012	5.4400	1.7952	2.0000	1
211	8414	17	0	7	Q3	2012	8.1600	3.3456	3.0000	1
211	8731	3	0	2	Q1	2012	8.1600	2.6112	3.0000	1
211	9052	24	1845	1	Q1	2012	8.1600	3.0192	3.0000	1
211	9125	13	0	1	Q1	2012	8.1600	3.5088	3.0000	1
211	9752	17	1293	1	Q1	2012	5.4400	2.7200	2.0000	1
211	10140	17	0	9	Q3	2012	8.1600	3.0192	3.0000	1
211	10264	15	0	2	Q1	2012	5.4400	1.7408	2.0000	1
212	118	3	199	7	Q3	2012	4.9800	1.8426	3.0000	1
212	276	15	0	11	Q4	2012	3.3200	1.4276	2.0000	1
212	957	6	0	8	Q3	2012	8.3000	2.5730	5.0000	1
212	1005	3	0	2	Q1	2012	4.9800	1.6932	3.0000	1
212	1197	23	1771	3	Q1	2012	4.9800	1.6434	3.0000	1
212	1280	6	0	6	Q2	2012	4.9800	2.4402	3.0000	1
212	1289	23	0	4	Q2	2012	4.9800	1.7928	3.0000	1
212	1634	3	190	3	Q1	2012	6.6400	2.6560	4.0000	1
212	1754	11	0	5	Q2	2012	4.9800	1.8426	3.0000	1
212	1820	6	510	5	Q2	2012	4.9800	2.1912	3.0000	1
212	2047	11	0	7	Q3	2012	6.6400	2.5896	4.0000	1
212	2102	6	0	5	Q2	2012	3.3200	1.4608	2.0000	1
212	2371	16	1228	8	Q3	2012	4.9800	1.6434	3.0000	1
212	2523	6	0	4	Q2	2012	4.9800	1.6434	3.0000	1
212	2533	6	0	1	Q1	2012	4.9800	1.7430	3.0000	1
212	2613	11	0	2	Q1	2012	4.9800	2.1912	3.0000	1
212	2656	13	0	6	Q2	2012	3.3200	1.2616	2.0000	1
212	2684	15	0	5	Q2	2012	4.9800	1.5438	3.0000	1
212	3506	7	0	4	Q2	2012	6.6400	2.0584	4.0000	1
212	3828	24	0	3	Q1	2012	6.6400	2.6560	4.0000	1
212	4166	15	0	12	Q4	2012	3.3200	1.4608	2.0000	1
212	4230	11	0	7	Q3	2012	3.3200	1.4940	2.0000	1
212	4457	22	0	6	Q2	2012	1.6600	0.6308	1.0000	1
212	4497	17	0	12	Q4	2012	6.6400	3.1208	4.0000	1
212	4618	3	0	3	Q1	2012	6.6400	2.1912	4.0000	1
212	4787	2	0	1	Q1	2012	3.3200	1.5272	2.0000	1
212	4868	16	0	6	Q2	2012	6.6400	2.7888	4.0000	1
212	5060	13	0	12	Q4	2012	4.9800	1.9422	3.0000	1
212	5163	3	0	6	Q2	2012	4.9800	2.1414	3.0000	1
212	5193	14	0	8	Q3	2012	3.3200	1.6600	2.0000	1
212	5389	7	0	9	Q3	2012	4.9800	1.5438	3.0000	1
212	5580	6	523	11	Q4	2012	4.9800	1.8426	3.0000	1
212	5590	17	0	7	Q3	2012	6.6400	2.2576	4.0000	1
212	6091	24	1853	5	Q2	2012	4.9800	2.3406	3.0000	1
212	6153	16	0	11	Q4	2012	3.3200	1.0624	2.0000	1
212	6288	13	0	9	Q3	2012	4.9800	1.9422	3.0000	1
212	6710	13	0	7	Q3	2012	4.9800	2.0418	3.0000	1
212	6832	3	0	10	Q4	2012	4.9800	1.4940	3.0000	1
212	7522	13	0	10	Q4	2012	4.9800	1.7430	3.0000	1
212	7643	24	0	7	Q3	2012	4.9800	1.7430	3.0000	1
212	7667	6	0	6	Q2	2012	6.6400	2.7224	4.0000	1
212	7721	13	0	3	Q1	2012	3.3200	0.9960	2.0000	1
212	8004	24	1851	4	Q2	2012	6.6400	3.2536	4.0000	1
212	8079	2	0	11	Q4	2012	1.6600	0.4980	1.0000	1
212	8089	17	0	1	Q1	2012	4.9800	1.9422	3.0000	1
212	8261	14	1079	12	Q4	2012	1.6600	0.8134	1.0000	1
212	8270	7	504	2	Q1	2012	3.3200	1.2948	2.0000	1
212	8289	17	1293	1	Q1	2012	6.6400	2.0584	4.0000	1
212	8562	15	0	1	Q1	2012	4.9800	1.8426	3.0000	1
212	9184	3	0	6	Q2	2012	3.3200	1.2284	2.0000	1
212	9209	6	0	8	Q3	2012	3.3200	1.5604	2.0000	1
212	9357	7	504	2	Q1	2012	6.6400	3.2536	4.0000	1
212	10091	17	0	8	Q3	2012	6.6400	2.1248	4.0000	1
213	665	6	0	5	Q2	2012	1.6800	0.5544	3.0000	1
213	973	24	0	8	Q3	2012	1.1200	0.3920	2.0000	1
213	993	13	0	5	Q2	2012	1.6800	0.7728	3.0000	1
213	1074	13	0	5	Q2	2012	1.6800	0.5880	3.0000	1
213	1249	15	0	2	Q1	2012	1.6800	0.5040	3.0000	1
213	1310	16	0	6	Q2	2012	1.6800	0.5544	3.0000	1
213	1388	13	0	6	Q2	2012	2.2400	0.7840	4.0000	1
213	1545	15	0	9	Q3	2012	1.6800	0.8232	3.0000	1
213	1690	16	0	1	Q1	2012	1.6800	0.6888	3.0000	1
213	1832	23	0	11	Q4	2012	1.6800	0.5208	3.0000	1
213	1984	24	0	12	Q4	2012	1.1200	0.4368	2.0000	1
213	2186	15	1138	3	Q1	2012	1.1200	0.3584	2.0000	1
213	2535	24	1859	8	Q3	2012	1.6800	0.6552	3.0000	1
213	2715	15	0	7	Q3	2012	1.6800	0.5040	3.0000	1
213	2781	24	0	1	Q1	2012	1.1200	0.4144	2.0000	1
213	2918	17	0	8	Q3	2012	1.6800	0.8064	3.0000	1
213	3076	7	501	1	Q1	2012	1.6800	0.5712	3.0000	1
213	3242	3	190	3	Q1	2012	1.1200	0.4928	2.0000	1
213	3401	11	826	5	Q2	2012	1.1200	0.4592	2.0000	1
213	3504	22	0	3	Q1	2012	0.5600	0.2072	1.0000	1
213	4204	17	0	5	Q2	2012	1.6800	0.8232	3.0000	1
213	4395	11	0	2	Q1	2012	2.2400	0.8064	4.0000	1
213	4651	22	0	5	Q2	2012	0.5600	0.2408	1.0000	1
213	5002	23	1786	10	Q4	2012	2.2400	0.8736	4.0000	1
213	5037	24	0	1	Q1	2012	1.6800	0.5544	3.0000	1
213	5037	24	0	2	Q1	2012	1.6800	0.5544	3.0000	1
213	5302	11	0	11	Q4	2012	1.6800	0.6552	3.0000	1
213	5303	17	0	12	Q4	2012	2.2400	0.9632	4.0000	1
213	5426	24	1866	11	Q4	2012	1.1200	0.3584	2.0000	1
213	5590	17	0	5	Q2	2012	1.6800	0.5712	3.0000	1
213	5685	13	0	3	Q1	2012	1.6800	0.6720	3.0000	1
213	5811	6	0	5	Q2	2012	1.1200	0.5264	2.0000	1
213	6161	17	0	5	Q2	2012	2.2400	0.8736	4.0000	1
213	6291	3	0	12	Q4	2012	2.2400	1.0528	4.0000	1
213	6557	11	0	11	Q4	2012	1.6800	0.6048	3.0000	1
213	6598	11	0	4	Q2	2012	1.6800	0.5712	3.0000	1
213	7275	17	0	9	Q3	2012	1.1200	0.3696	2.0000	1
213	7368	11	826	5	Q2	2012	1.6800	0.5880	3.0000	1
213	7502	16	0	4	Q2	2012	1.6800	0.6048	3.0000	1
213	7829	24	1859	8	Q3	2012	1.6800	0.7392	3.0000	1
213	7883	15	0	8	Q3	2012	1.6800	0.5712	3.0000	1
213	8003	3	0	6	Q2	2012	1.1200	0.3696	2.0000	1
213	8202	3	0	9	Q3	2012	2.2400	0.7168	4.0000	1
213	8960	3	0	12	Q4	2012	1.1200	0.5264	2.0000	1
213	8983	2	0	2	Q1	2012	0.5600	0.2352	1.0000	1
213	9200	16	0	10	Q4	2012	1.6800	0.6720	3.0000	1
213	9331	11	0	9	Q3	2012	1.6800	0.5040	3.0000	1
213	9487	17	0	12	Q4	2012	1.1200	0.4592	2.0000	1
213	9569	15	0	10	Q4	2012	1.6800	0.8064	3.0000	1
213	9697	23	0	6	Q2	2012	1.1200	0.5264	2.0000	1
213	10116	17	1307	8	Q3	2012	2.2400	0.7168	4.0000	1
214	430	16	1216	2	Q1	2012	11.2800	3.6096	4.0000	1
214	435	17	1311	10	Q4	2012	5.6400	2.0868	2.0000	1
214	440	15	0	6	Q2	2012	11.2800	4.2864	4.0000	1
214	663	16	0	3	Q1	2012	11.2800	4.0608	4.0000	1
214	682	6	0	7	Q3	2012	11.2800	5.3016	4.0000	1
214	766	15	0	12	Q4	2012	8.4600	3.2148	3.0000	1
214	992	7	0	12	Q4	2012	11.2800	3.8352	4.0000	1
214	1124	3	0	4	Q2	2012	8.4600	3.2994	3.0000	1
214	1310	16	0	8	Q3	2012	11.2800	3.8352	4.0000	1
214	1379	7	0	3	Q1	2012	5.6400	1.8048	2.0000	1
214	1822	7	0	8	Q3	2012	8.4600	4.2300	3.0000	1
214	1848	11	837	10	Q4	2012	8.4600	3.6378	3.0000	1
214	1897	13	976	1	Q1	2012	8.4600	2.7918	3.0000	1
214	2019	16	0	1	Q1	2012	5.6400	2.3688	2.0000	1
214	2373	13	980	3	Q1	2012	5.6400	2.4252	2.0000	1
214	2444	13	0	9	Q3	2012	8.4600	2.7918	3.0000	1
214	2493	17	0	4	Q2	2012	8.4600	3.7224	3.0000	1
214	2587	16	1223	6	Q2	2012	8.4600	3.4686	3.0000	1
214	2626	11	0	11	Q4	2012	8.4600	3.6378	3.0000	1
214	3010	7	0	5	Q2	2012	5.6400	2.5380	2.0000	1
214	3021	16	0	12	Q4	2012	8.4600	3.4686	3.0000	1
214	3359	11	0	12	Q4	2012	8.4600	2.6226	3.0000	1
214	3389	7	0	11	Q4	2012	8.4600	2.9610	3.0000	1
214	3458	24	0	5	Q2	2012	11.2800	3.8352	4.0000	1
214	3471	11	818	1	Q1	2012	8.4600	3.5532	3.0000	1
214	3815	2	0	12	Q4	2012	2.8200	0.9306	1.0000	1
214	4249	11	0	6	Q2	2012	14.1000	4.7940	5.0000	1
214	4330	13	0	5	Q2	2012	8.4600	2.7072	3.0000	1
214	4460	3	0	8	Q3	2012	8.4600	3.0456	3.0000	1
214	4948	13	0	6	Q2	2012	8.4600	3.7224	3.0000	1
214	5013	7	0	12	Q4	2012	5.6400	1.7484	2.0000	1
214	5131	24	0	5	Q2	2012	8.4600	3.2994	3.0000	1
214	5554	6	519	9	Q3	2012	8.4600	3.7224	3.0000	1
214	5610	13	0	7	Q3	2012	8.4600	2.7918	3.0000	1
214	5887	6	0	11	Q4	2012	8.4600	3.2994	3.0000	1
214	5943	2	0	11	Q4	2012	5.6400	2.0868	2.0000	1
214	5992	15	0	9	Q3	2012	5.6400	2.5380	2.0000	1
214	6107	3	0	6	Q2	2012	8.4600	3.4686	3.0000	1
214	6139	14	0	9	Q3	2012	5.6400	1.9176	2.0000	1
214	6471	15	1134	1	Q1	2012	11.2800	4.9632	4.0000	1
214	6484	22	0	10	Q4	2012	5.6400	2.6508	2.0000	1
214	6854	17	0	2	Q1	2012	5.6400	1.7484	2.0000	1
214	6897	6	0	3	Q1	2012	8.4600	4.1454	3.0000	1
214	7003	15	0	9	Q3	2012	5.6400	1.9740	2.0000	1
214	7036	6	0	8	Q3	2012	11.2800	3.6096	4.0000	1
214	7117	15	0	6	Q2	2012	8.4600	3.7224	3.0000	1
214	7715	13	0	7	Q3	2012	11.2800	3.7224	4.0000	1
214	7733	13	0	5	Q2	2012	8.4600	4.2300	3.0000	1
214	8199	17	0	6	Q2	2012	5.6400	1.8612	2.0000	1
214	8234	24	1860	8	Q3	2012	11.2800	4.8504	4.0000	1
214	8308	17	0	8	Q3	2012	8.4600	3.1302	3.0000	1
214	8340	6	0	3	Q1	2012	8.4600	3.2148	3.0000	1
214	8526	11	0	5	Q2	2012	11.2800	4.7376	4.0000	1
214	9192	15	0	6	Q2	2012	8.4600	2.6226	3.0000	1
214	9369	6	0	12	Q4	2012	14.1000	5.2170	5.0000	1
214	9602	11	0	1	Q1	2012	5.6400	1.8048	2.0000	1
215	454	17	0	2	Q1	2012	2.3700	1.1850	3.0000	1
215	757	15	0	10	Q4	2012	2.3700	0.8295	3.0000	1
215	870	24	0	6	Q2	2012	1.5800	0.6320	2.0000	1
215	993	13	0	2	Q1	2012	3.1600	1.0112	4.0000	1
215	1575	13	980	3	Q1	2012	2.3700	0.7347	3.0000	1
215	1690	16	0	11	Q4	2012	2.3700	0.8058	3.0000	1
215	1897	13	0	6	Q2	2012	2.3700	0.7821	3.0000	1
215	1957	13	0	8	Q3	2012	1.5800	0.5214	2.0000	1
215	2052	13	980	3	Q1	2012	2.3700	0.8769	3.0000	1
215	2077	23	1768	2	Q1	2012	2.3700	0.8769	3.0000	1
215	2293	7	0	12	Q4	2012	2.3700	1.0902	3.0000	1
215	3467	15	0	6	Q2	2012	2.3700	1.0428	3.0000	1
215	3692	16	1225	7	Q3	2012	2.3700	1.0191	3.0000	1
215	4115	7	0	12	Q4	2012	2.3700	1.0428	3.0000	1
215	4234	3	0	3	Q1	2012	2.3700	1.1613	3.0000	1
215	4287	15	0	12	Q4	2012	2.3700	0.8295	3.0000	1
215	4301	11	0	5	Q2	2012	2.3700	1.1139	3.0000	1
215	4351	23	0	7	Q3	2012	1.5800	0.5846	2.0000	1
215	4664	6	0	12	Q4	2012	1.5800	0.7110	2.0000	1
215	4985	23	1768	2	Q1	2012	2.3700	0.7821	3.0000	1
215	5267	15	0	11	Q4	2012	1.5800	0.7426	2.0000	1
215	5317	15	1154	10	Q4	2012	1.5800	0.7584	2.0000	1
215	5407	24	0	6	Q2	2012	3.1600	0.9796	4.0000	1
215	5419	17	0	4	Q2	2012	2.3700	1.0428	3.0000	1
215	5648	7	0	1	Q1	2012	2.3700	0.8532	3.0000	1
215	5821	15	0	7	Q3	2012	3.1600	1.1376	4.0000	1
215	6496	3	195	5	Q2	2012	3.1600	1.4220	4.0000	1
215	6758	11	0	9	Q3	2012	3.1600	1.3904	4.0000	1
215	6957	16	0	11	Q4	2012	1.5800	0.6004	2.0000	1
215	7099	15	0	6	Q2	2012	2.3700	1.1139	3.0000	1
215	7189	13	0	11	Q4	2012	2.3700	0.8058	3.0000	1
215	7940	13	0	2	Q1	2012	1.5800	0.6794	2.0000	1
215	8436	15	0	6	Q2	2012	2.3700	0.7110	3.0000	1
215	8511	16	0	11	Q4	2012	2.3700	0.7347	3.0000	1
215	8555	11	0	8	Q3	2012	1.5800	0.4740	2.0000	1
215	8669	23	0	10	Q4	2012	3.1600	1.1376	4.0000	1
215	9144	13	980	3	Q1	2012	2.3700	0.7584	3.0000	1
215	9156	6	522	10	Q4	2012	2.3700	1.0902	3.0000	1
215	9318	16	1220	4	Q2	2012	2.3700	1.0665	3.0000	1
215	9851	3	0	4	Q2	2012	1.5800	0.5056	2.0000	1
215	10182	24	0	12	Q4	2012	2.3700	0.7347	3.0000	1
216	30	11	0	5	Q2	2012	10.8000	4.5360	3.0000	1
216	216	17	0	9	Q3	2012	10.8000	3.9960	3.0000	1
216	697	13	0	12	Q4	2012	10.8000	5.4000	3.0000	1
216	937	6	521	10	Q4	2012	10.8000	4.4280	3.0000	1
216	1099	15	0	9	Q3	2012	10.8000	5.2920	3.0000	1
216	1110	15	1141	4	Q2	2012	10.8000	5.1840	3.0000	1
216	1267	13	0	12	Q4	2012	14.4000	5.3280	4.0000	1
216	1389	6	0	10	Q4	2012	14.4000	6.0480	4.0000	1
216	1528	16	0	11	Q4	2012	10.8000	4.2120	3.0000	1
216	1681	13	0	11	Q4	2012	10.8000	4.7520	3.0000	1
216	2143	17	0	10	Q4	2012	7.2000	3.5280	2.0000	1
216	2314	6	0	10	Q4	2012	10.8000	4.7520	3.0000	1
216	2493	17	0	5	Q2	2012	10.8000	4.7520	3.0000	1
216	2678	3	207	11	Q4	2012	10.8000	3.4560	3.0000	1
216	2798	11	0	9	Q3	2012	10.8000	4.7520	3.0000	1
216	2829	23	0	4	Q2	2012	7.2000	2.9520	2.0000	1
216	2907	15	0	8	Q3	2012	14.4000	6.3360	4.0000	1
216	3130	13	0	2	Q1	2012	10.8000	5.2920	3.0000	1
216	3155	6	0	10	Q4	2012	14.4000	6.0480	4.0000	1
216	3603	24	0	4	Q2	2012	14.4000	4.7520	4.0000	1
216	3748	13	1000	12	Q4	2012	14.4000	4.7520	4.0000	1
216	3898	6	0	6	Q2	2012	14.4000	5.4720	4.0000	1
216	4096	3	0	4	Q2	2012	10.8000	4.4280	3.0000	1
216	4188	6	0	4	Q2	2012	14.4000	4.4640	4.0000	1
216	4340	17	0	3	Q1	2012	18.0000	6.1200	5.0000	1
216	4369	15	1150	8	Q3	2012	14.4000	5.0400	4.0000	1
216	4711	3	195	5	Q2	2012	10.8000	4.2120	3.0000	1
216	4963	24	1853	5	Q2	2012	10.8000	4.6440	3.0000	1
216	5127	15	0	6	Q2	2012	10.8000	3.5640	3.0000	1
216	5501	17	1304	7	Q3	2012	10.8000	4.5360	3.0000	1
216	5595	7	0	8	Q3	2012	10.8000	4.5360	3.0000	1
216	5845	24	0	12	Q4	2012	14.4000	6.1920	4.0000	1
216	6008	17	0	4	Q2	2012	10.8000	4.6440	3.0000	1
216	6083	24	0	4	Q2	2012	10.8000	4.7520	3.0000	1
216	6348	16	1235	11	Q4	2012	7.2000	3.1680	2.0000	1
216	6889	15	0	4	Q2	2012	14.4000	6.3360	4.0000	1
216	7059	17	0	8	Q3	2012	7.2000	2.6640	2.0000	1
216	7250	13	976	1	Q1	2012	10.8000	3.9960	3.0000	1
216	7502	16	0	2	Q1	2012	7.2000	2.5200	2.0000	1
216	7672	7	0	12	Q4	2012	10.8000	4.3200	3.0000	1
216	7849	3	205	10	Q4	2012	10.8000	5.2920	3.0000	1
216	8235	22	0	1	Q1	2012	3.6000	1.1880	1.0000	1
216	8454	17	0	2	Q1	2012	10.8000	4.5360	3.0000	1
216	8551	17	0	7	Q3	2012	7.2000	2.2320	2.0000	1
216	8586	24	1853	5	Q2	2012	18.0000	5.7600	5.0000	1
216	8745	7	0	5	Q2	2012	7.2000	2.3040	2.0000	1
216	8745	7	0	8	Q3	2012	7.2000	2.3040	2.0000	1
216	8770	22	0	5	Q2	2012	3.6000	1.6560	1.0000	1
216	9064	17	0	1	Q1	2012	10.8000	4.1040	3.0000	1
216	9263	16	0	6	Q2	2012	14.4000	6.3360	4.0000	1
216	9362	6	526	12	Q4	2012	10.8000	4.6440	3.0000	1
216	9420	13	0	5	Q2	2012	10.8000	4.3200	3.0000	1
216	9601	11	0	7	Q3	2012	10.8000	5.2920	3.0000	1
216	9949	24	0	7	Q3	2012	7.2000	2.3760	2.0000	1
216	10116	17	1307	8	Q3	2012	14.4000	4.6080	4.0000	1
216	10167	17	0	12	Q4	2012	10.8000	5.4000	3.0000	1
217	99	3	0	3	Q1	2012	1.3600	0.6120	2.0000	1
217	908	11	0	11	Q4	2012	2.7200	1.2240	4.0000	1
217	1310	16	1236	12	Q4	2012	2.0400	0.6732	3.0000	1
217	1341	3	0	12	Q4	2012	2.0400	0.7752	3.0000	1
217	1415	16	0	9	Q3	2012	2.7200	0.9520	4.0000	1
217	1429	13	0	12	Q4	2012	2.0400	0.6120	3.0000	1
217	2143	17	0	1	Q1	2012	1.3600	0.6528	2.0000	1
217	2246	13	980	3	Q1	2012	2.0400	0.8976	3.0000	1
217	2588	23	0	11	Q4	2012	2.7200	1.1968	4.0000	1
217	2616	22	0	12	Q4	2012	1.3600	0.4080	2.0000	1
217	2981	23	0	2	Q1	2012	2.0400	0.9996	3.0000	1
217	3052	6	0	9	Q3	2012	2.0400	0.7956	3.0000	1
217	3058	7	0	8	Q3	2012	1.3600	0.4488	2.0000	1
217	3116	6	0	12	Q4	2012	2.0400	0.8160	3.0000	1
217	3216	6	524	11	Q4	2012	2.0400	0.8568	3.0000	1
217	3231	17	0	2	Q1	2012	2.0400	0.7956	3.0000	1
217	4007	15	0	6	Q2	2012	1.3600	0.4080	2.0000	1
217	4439	15	0	1	Q1	2012	2.0400	0.9588	3.0000	1
217	4457	22	1709	11	Q4	2012	0.6800	0.2652	1.0000	1
217	4584	11	833	8	Q3	2012	2.0400	0.9996	3.0000	1
217	4954	11	0	3	Q1	2012	2.0400	0.8772	3.0000	1
217	5141	7	504	2	Q1	2012	2.0400	0.6528	3.0000	1
217	5560	13	0	2	Q1	2012	2.0400	0.7140	3.0000	1
217	5616	17	0	2	Q1	2012	2.7200	0.9248	4.0000	1
217	5707	23	0	2	Q1	2012	2.0400	0.7344	3.0000	1
217	5777	7	0	8	Q3	2012	1.3600	0.5576	2.0000	1
217	6120	24	0	6	Q2	2012	1.3600	0.6392	2.0000	1
217	6496	3	210	12	Q4	2012	3.4000	1.0540	5.0000	1
217	6522	13	0	12	Q4	2012	2.0400	0.7140	3.0000	1
217	6574	13	0	9	Q3	2012	2.0400	0.7548	3.0000	1
217	6960	17	1292	1	Q1	2012	2.7200	1.3056	4.0000	1
217	7072	16	1216	2	Q1	2012	2.7200	0.8704	4.0000	1
217	7236	24	0	3	Q1	2012	2.0400	0.6120	3.0000	1
217	7250	13	0	6	Q2	2012	3.4000	1.6320	5.0000	1
217	7271	7	0	8	Q3	2012	2.7200	1.3056	4.0000	1
217	7281	17	0	7	Q3	2012	2.7200	1.2784	4.0000	1
217	7433	11	0	9	Q3	2012	1.3600	0.5984	2.0000	1
217	7433	11	837	10	Q4	2012	2.0400	0.9792	3.0000	1
217	7474	6	0	9	Q3	2012	2.0400	0.8976	3.0000	1
217	7529	17	1307	8	Q3	2012	2.0400	0.6732	3.0000	1
217	8463	23	0	5	Q2	2012	2.0400	0.9996	3.0000	1
217	8640	15	0	12	Q4	2012	2.7200	0.8432	4.0000	1
217	8665	15	0	9	Q3	2012	2.0400	0.6324	3.0000	1
217	8770	22	0	5	Q2	2012	0.6800	0.2720	1.0000	1
217	9194	17	0	4	Q2	2012	2.0400	0.9588	3.0000	1
217	9264	24	0	2	Q1	2012	2.7200	1.0608	4.0000	1
217	9594	7	0	7	Q3	2012	2.7200	1.3328	4.0000	1
217	9897	16	0	8	Q3	2012	2.7200	1.3056	4.0000	1
217	10140	17	0	9	Q3	2012	2.0400	0.7140	3.0000	1
217	10240	3	0	12	Q4	2012	2.7200	1.1696	4.0000	1
218	663	16	1220	4	Q2	2012	10.3200	3.6120	3.0000	1
218	1162	6	0	12	Q4	2012	17.2000	6.5360	5.0000	1
218	1528	16	0	6	Q2	2012	10.3200	4.0248	3.0000	1
218	1736	13	0	8	Q3	2012	10.3200	4.8504	3.0000	1
218	1785	3	0	7	Q3	2012	13.7600	4.2656	4.0000	1
218	1916	13	0	2	Q1	2012	13.7600	6.0544	4.0000	1
218	2134	11	0	12	Q4	2012	6.8800	2.6144	2.0000	1
218	2443	13	0	6	Q2	2012	10.3200	3.8184	3.0000	1
218	2443	13	976	1	Q1	2012	10.3200	3.8184	3.0000	1
218	2479	13	0	6	Q2	2012	10.3200	3.7152	3.0000	1
218	2479	13	0	7	Q3	2012	13.7600	6.7424	4.0000	1
218	2554	15	0	11	Q4	2012	13.7600	4.8160	4.0000	1
218	2695	13	0	1	Q1	2012	13.7600	5.5040	4.0000	1
218	2881	24	0	12	Q4	2012	13.7600	6.0544	4.0000	1
218	2955	7	0	10	Q4	2012	6.8800	3.2336	2.0000	1
218	3612	24	0	3	Q1	2012	10.3200	4.9536	3.0000	1
218	4525	6	508	4	Q2	2012	10.3200	4.4376	3.0000	1
218	4863	2	0	1	Q1	2012	3.4400	1.5824	1.0000	1
218	5322	6	518	8	Q3	2012	6.8800	2.5456	2.0000	1
218	5350	22	0	6	Q2	2012	3.4400	1.2040	1.0000	1
218	5374	16	1220	4	Q2	2012	10.3200	4.1280	3.0000	1
218	5388	11	0	11	Q4	2012	10.3200	4.0248	3.0000	1
218	5526	15	0	3	Q1	2012	6.8800	3.3024	2.0000	1
218	5533	13	988	7	Q3	2012	13.7600	6.6048	4.0000	1
218	5647	15	0	5	Q2	2012	6.8800	2.3392	2.0000	1
218	5724	11	0	3	Q1	2012	6.8800	2.5456	2.0000	1
218	5889	24	0	5	Q2	2012	10.3200	3.3024	3.0000	1
218	6120	24	0	12	Q4	2012	10.3200	4.9536	3.0000	1
218	6321	14	0	9	Q3	2012	3.4400	1.2728	1.0000	1
218	6432	24	1866	11	Q4	2012	10.3200	3.6120	3.0000	1
218	6568	14	0	2	Q1	2012	3.4400	1.4104	1.0000	1
218	6609	7	0	9	Q3	2012	10.3200	3.1992	3.0000	1
218	6703	11	0	10	Q4	2012	10.3200	4.7472	3.0000	1
218	6712	16	1236	12	Q4	2012	10.3200	4.5408	3.0000	1
218	6740	7	0	5	Q2	2012	10.3200	4.8504	3.0000	1
218	7234	16	1225	7	Q3	2012	10.3200	4.6440	3.0000	1
218	7262	13	0	10	Q4	2012	13.7600	6.7424	4.0000	1
218	8195	7	0	9	Q3	2012	13.7600	4.5408	4.0000	1
218	8207	13	0	1	Q1	2012	6.8800	2.8208	2.0000	1
218	8213	14	0	12	Q4	2012	6.8800	2.8896	2.0000	1
218	8489	2	0	7	Q3	2012	3.4400	1.3072	1.0000	1
218	8509	24	0	8	Q3	2012	6.8800	2.2704	2.0000	1
218	9019	7	501	1	Q1	2012	13.7600	5.9168	4.0000	1
218	9169	23	1773	4	Q2	2012	17.2000	6.0200	5.0000	1
218	9504	13	0	8	Q3	2012	10.3200	3.9216	3.0000	1
218	10043	22	0	2	Q1	2012	3.4400	1.0664	1.0000	1
219	647	3	0	1	Q1	2012	7.5600	2.8728	3.0000	1
219	1090	6	524	11	Q4	2012	7.5600	2.6460	3.0000	1
219	1245	17	0	3	Q1	2012	10.0800	3.6288	4.0000	1
219	1266	13	980	3	Q1	2012	5.0400	2.1168	2.0000	1
219	1282	3	0	2	Q1	2012	5.0400	1.5624	2.0000	1
219	1575	13	0	9	Q3	2012	10.0800	4.4352	4.0000	1
219	1801	7	0	9	Q3	2012	7.5600	3.1752	3.0000	1
219	1839	11	829	6	Q2	2012	10.0800	4.4352	4.0000	1
219	2378	16	0	5	Q2	2012	10.0800	4.8384	4.0000	1
219	2690	3	195	5	Q2	2012	7.5600	2.7972	3.0000	1
219	2763	15	1140	4	Q2	2012	10.0800	3.2256	4.0000	1
219	2850	3	0	7	Q3	2012	10.0800	3.5280	4.0000	1
219	3401	11	0	4	Q2	2012	5.0400	1.8648	2.0000	1
219	3491	16	0	8	Q3	2012	5.0400	2.0160	2.0000	1
219	3701	6	513	6	Q2	2012	7.5600	3.6288	3.0000	1
219	3719	23	0	6	Q2	2012	7.5600	2.7972	3.0000	1
219	3773	17	0	8	Q3	2012	7.5600	2.7216	3.0000	1
219	3809	6	519	9	Q3	2012	7.5600	2.8728	3.0000	1
219	4070	23	0	9	Q3	2012	7.5600	2.9484	3.0000	1
219	4316	22	0	12	Q4	2012	2.5200	1.1088	1.0000	1
219	4707	11	833	8	Q3	2012	5.0400	2.1672	2.0000	1
219	5310	2	0	11	Q4	2012	5.0400	2.2176	2.0000	1
219	5432	16	0	9	Q3	2012	7.5600	2.8728	3.0000	1
219	5535	24	0	10	Q4	2012	10.0800	4.4352	4.0000	1
219	5568	23	1781	8	Q3	2012	7.5600	3.0240	3.0000	1
219	5612	15	0	4	Q2	2012	7.5600	3.5532	3.0000	1
219	5677	22	0	12	Q4	2012	5.0400	2.3184	2.0000	1
219	5984	17	0	7	Q3	2012	7.5600	3.3264	3.0000	1
219	6001	17	1304	7	Q3	2012	7.5600	2.7972	3.0000	1
219	6425	14	0	4	Q2	2012	2.5200	1.0584	1.0000	1
219	6835	16	0	8	Q3	2012	7.5600	3.7044	3.0000	1
219	6945	15	1150	8	Q3	2012	12.6000	4.2840	5.0000	1
219	7413	3	188	2	Q1	2012	10.0800	3.9312	4.0000	1
219	7870	15	0	12	Q4	2012	7.5600	3.5532	3.0000	1
219	7999	24	0	1	Q1	2012	7.5600	2.3436	3.0000	1
219	8442	17	1314	11	Q4	2012	7.5600	3.7044	3.0000	1
219	8720	11	842	12	Q4	2012	7.5600	3.2508	3.0000	1
219	8902	3	201	8	Q3	2012	7.5600	2.7972	3.0000	1
219	9662	7	0	9	Q3	2012	10.0800	4.7376	4.0000	1
219	9759	15	0	8	Q3	2012	10.0800	4.6368	4.0000	1
219	9781	3	210	12	Q4	2012	7.5600	3.0240	3.0000	1
220	117	13	0	1	Q1	2012	7.6500	2.8305	3.0000	1
220	219	7	0	5	Q2	2012	7.6500	2.6010	3.0000	1
220	466	7	0	11	Q4	2012	7.6500	2.5245	3.0000	1
220	604	14	1058	2	Q1	2012	2.5500	1.2495	1.0000	1
220	676	7	0	1	Q1	2012	10.2000	3.7740	4.0000	1
220	769	16	0	4	Q2	2012	5.1000	1.5810	2.0000	1
220	878	3	0	1	Q1	2012	5.1000	2.1420	2.0000	1
220	1415	16	1235	11	Q4	2012	10.2000	4.7940	4.0000	1
220	2194	6	0	5	Q2	2012	7.6500	2.6010	3.0000	1
220	2272	17	0	2	Q1	2012	5.1000	2.1930	2.0000	1
220	2951	24	0	3	Q1	2012	12.7500	6.2475	5.0000	1
220	3937	13	0	5	Q2	2012	5.1000	2.4990	2.0000	1
220	3941	3	0	6	Q2	2012	7.6500	2.8305	3.0000	1
220	4078	3	0	4	Q2	2012	7.6500	3.1365	3.0000	1
220	4105	3	0	3	Q1	2012	5.1000	2.3970	2.0000	1
220	4196	13	976	1	Q1	2012	7.6500	3.6720	3.0000	1
220	4443	11	0	2	Q1	2012	7.6500	2.6775	3.0000	1
220	4445	17	0	3	Q1	2012	7.6500	2.6775	3.0000	1
220	4449	7	0	6	Q2	2012	10.2000	3.8760	4.0000	1
220	4958	23	0	10	Q4	2012	10.2000	3.6720	4.0000	1
220	5068	22	0	9	Q3	2012	5.1000	2.4990	2.0000	1
220	5295	16	0	6	Q2	2012	7.6500	2.5245	3.0000	1
220	5303	17	1314	11	Q4	2012	5.1000	2.2950	2.0000	1
220	5309	14	1064	5	Q2	2012	7.6500	2.6010	3.0000	1
220	5533	13	0	2	Q1	2012	5.1000	2.0910	2.0000	1
220	5597	3	0	9	Q3	2012	7.6500	3.3660	3.0000	1
220	5647	15	0	2	Q1	2012	5.1000	1.7340	2.0000	1
220	6113	16	1225	7	Q3	2012	10.2000	3.2640	4.0000	1
220	6350	13	0	6	Q2	2012	5.1000	2.2950	2.0000	1
220	6530	17	0	10	Q4	2012	5.1000	2.3460	2.0000	1
220	6647	17	0	7	Q3	2012	7.6500	2.8305	3.0000	1
220	6683	17	0	8	Q3	2012	7.6500	2.7540	3.0000	1
220	6878	6	0	12	Q4	2012	7.6500	2.4480	3.0000	1
220	7190	23	1775	5	Q2	2012	10.2000	4.2840	4.0000	1
220	7294	6	0	9	Q3	2012	5.1000	2.4990	2.0000	1
220	7438	2	0	10	Q4	2012	2.5500	1.0200	1.0000	1
220	7570	13	988	7	Q3	2012	7.6500	2.5245	3.0000	1
220	7721	13	0	6	Q2	2012	7.6500	3.0600	3.0000	1
220	7965	15	0	5	Q2	2012	10.2000	4.5900	4.0000	1
220	7985	24	1859	8	Q3	2012	12.7500	5.7375	5.0000	1
220	8091	13	0	9	Q3	2012	12.7500	4.8450	5.0000	1
220	8235	22	1694	4	Q2	2012	2.5500	0.8415	1.0000	1
220	8499	24	1847	2	Q1	2012	7.6500	3.8250	3.0000	1
220	8653	3	0	2	Q1	2012	7.6500	3.5955	3.0000	1
220	8843	13	980	3	Q1	2012	7.6500	3.7485	3.0000	1
220	9095	7	0	10	Q4	2012	7.6500	3.1365	3.0000	1
220	9928	16	1216	2	Q1	2012	10.2000	3.8760	4.0000	1
220	10104	7	505	2	Q1	2012	7.6500	2.5245	3.0000	1
221	454	17	0	8	Q3	2012	10.9800	4.9410	3.0000	1
221	778	15	1157	12	Q4	2012	14.6400	5.2704	4.0000	1
221	817	17	1293	1	Q1	2012	10.9800	5.2704	3.0000	1
221	1093	13	0	7	Q3	2012	14.6400	7.0272	4.0000	1
221	1107	22	0	10	Q4	2012	7.3200	3.3672	2.0000	1
221	1235	11	0	3	Q1	2012	10.9800	4.2822	3.0000	1
221	1242	24	0	10	Q4	2012	14.6400	4.5384	4.0000	1
221	1582	11	0	11	Q4	2012	10.9800	4.3920	3.0000	1
221	1676	3	0	7	Q3	2012	14.6400	5.1240	4.0000	1
221	1759	6	510	5	Q2	2012	10.9800	3.4038	3.0000	1
221	1773	13	0	12	Q4	2012	10.9800	5.2704	3.0000	1
221	2397	11	0	9	Q3	2012	7.3200	3.5136	2.0000	1
221	2448	16	1235	11	Q4	2012	10.9800	4.9410	3.0000	1
221	2668	7	0	11	Q4	2012	7.3200	3.4404	2.0000	1
221	2677	13	0	6	Q2	2012	14.6400	4.5384	4.0000	1
221	2908	11	821	2	Q1	2012	14.6400	5.1240	4.0000	1
221	2942	17	0	3	Q1	2012	10.9800	4.5018	3.0000	1
221	3219	11	0	12	Q4	2012	7.3200	2.7816	2.0000	1
221	3389	7	0	11	Q4	2012	7.3200	2.4156	2.0000	1
221	3860	15	0	11	Q4	2012	7.3200	2.7084	2.0000	1
221	4118	17	0	8	Q3	2012	10.9800	3.4038	3.0000	1
221	4443	11	821	3	Q1	2012	10.9800	4.5018	3.0000	1
221	4459	15	0	7	Q3	2012	14.6400	4.8312	4.0000	1
221	4525	7	0	6	Q2	2012	10.9800	5.4900	3.0000	1
221	5164	2	108	1	Q1	2012	7.3200	2.4888	2.0000	1
221	5303	17	0	9	Q3	2012	7.3200	3.2940	2.0000	1
221	5358	3	201	8	Q3	2012	10.9800	5.3802	3.0000	1
221	5611	24	0	3	Q1	2012	10.9800	4.9410	3.0000	1
221	5702	11	0	3	Q1	2012	10.9800	4.9410	3.0000	1
221	6138	17	0	5	Q2	2012	10.9800	4.8312	3.0000	1
221	6313	17	0	2	Q1	2012	7.3200	3.1476	2.0000	1
221	6672	2	126	10	Q4	2012	3.6600	1.2078	1.0000	1
221	6842	24	1851	4	Q2	2012	14.6400	5.1240	4.0000	1
221	6985	11	0	10	Q4	2012	7.3200	3.4404	2.0000	1
221	7282	17	0	4	Q2	2012	7.3200	2.3424	2.0000	1
221	7445	15	0	9	Q3	2012	7.3200	2.6352	2.0000	1
221	7571	6	0	12	Q4	2012	14.6400	7.0272	4.0000	1
221	7582	11	0	6	Q2	2012	18.3000	6.9540	5.0000	1
221	7909	3	0	10	Q4	2012	10.9800	3.4038	3.0000	1
221	8189	17	0	3	Q1	2012	7.3200	2.4156	2.0000	1
221	8253	24	0	9	Q3	2012	10.9800	4.5018	3.0000	1
221	8335	7	0	10	Q4	2012	14.6400	6.0024	4.0000	1
221	8669	23	0	11	Q4	2012	7.3200	2.4156	2.0000	1
221	8692	13	976	1	Q1	2012	10.9800	3.6234	3.0000	1
221	9026	13	0	9	Q3	2012	10.9800	4.5018	3.0000	1
221	9256	13	0	11	Q4	2012	10.9800	4.1724	3.0000	1
221	9513	15	0	11	Q4	2012	7.3200	2.7816	2.0000	1
221	9536	24	0	4	Q2	2012	10.9800	3.8430	3.0000	1
221	10240	3	0	1	Q1	2012	10.9800	4.6116	3.0000	1
222	43	7	0	3	Q1	2012	11.8500	3.9105	3.0000	1
222	216	17	0	9	Q3	2012	11.8500	4.1475	3.0000	1
222	553	7	0	3	Q1	2012	11.8500	5.3325	3.0000	1
222	617	17	0	12	Q4	2012	7.9000	3.4760	2.0000	1
222	730	7	0	1	Q1	2012	15.8000	6.6360	4.0000	1
222	1289	23	0	3	Q1	2012	15.8000	5.5300	4.0000	1
222	1415	16	0	12	Q4	2012	15.8000	4.8980	4.0000	1
222	1681	13	0	1	Q1	2012	11.8500	3.5550	3.0000	1
222	1682	13	0	10	Q4	2012	11.8500	4.5030	3.0000	1
222	2180	2	126	10	Q4	2012	7.9000	2.7650	2.0000	1
222	2327	13	0	1	Q1	2012	11.8500	4.5030	3.0000	1
222	2493	17	0	11	Q4	2012	11.8500	4.1475	3.0000	1
222	2521	7	512	6	Q2	2012	11.8500	5.2140	3.0000	1
222	2625	13	0	1	Q1	2012	11.8500	3.9105	3.0000	1
222	3763	24	0	7	Q3	2012	15.8000	7.7420	4.0000	1
222	3945	15	0	7	Q3	2012	7.9000	3.2390	2.0000	1
222	4067	11	0	4	Q2	2012	7.9000	3.2390	2.0000	1
222	4096	3	0	5	Q2	2012	7.9000	3.3180	2.0000	1
222	4105	3	0	4	Q2	2012	11.8500	4.0290	3.0000	1
222	4148	15	0	12	Q4	2012	11.8500	4.3845	3.0000	1
222	4614	11	0	9	Q3	2012	11.8500	4.3845	3.0000	1
222	4658	17	0	11	Q4	2012	15.8000	7.7420	4.0000	1
222	5135	6	0	9	Q3	2012	15.8000	5.3720	4.0000	1
222	5256	17	1304	7	Q3	2012	11.8500	5.8065	3.0000	1
222	5542	16	0	7	Q3	2012	11.8500	3.9105	3.0000	1
222	5809	13	0	11	Q4	2012	11.8500	3.6735	3.0000	1
222	6114	16	0	12	Q4	2012	15.8000	5.0560	4.0000	1
222	6307	16	0	5	Q2	2012	11.8500	4.6215	3.0000	1
222	6429	6	0	5	Q2	2012	7.9000	3.5550	2.0000	1
222	6596	24	0	10	Q4	2012	15.8000	5.5300	4.0000	1
222	6800	24	0	6	Q2	2012	15.8000	5.2140	4.0000	1
222	7051	16	0	6	Q2	2012	11.8500	3.9105	3.0000	1
222	7193	7	0	11	Q4	2012	11.8500	4.3845	3.0000	1
222	7329	2	118	6	Q2	2012	11.8500	5.3325	3.0000	1
222	7343	7	505	2	Q1	2012	11.8500	4.9770	3.0000	1
222	7354	3	201	8	Q3	2012	11.8500	3.9105	3.0000	1
222	7601	24	0	4	Q2	2012	11.8500	5.9250	3.0000	1
222	7651	14	0	9	Q3	2012	7.9000	3.0810	2.0000	1
222	7801	7	0	3	Q1	2012	11.8500	4.3845	3.0000	1
222	7801	7	517	8	Q3	2012	11.8500	4.3845	3.0000	1
222	7901	2	0	5	Q2	2012	3.9500	1.5010	1.0000	1
222	8068	3	0	11	Q4	2012	7.9000	3.7920	2.0000	1
222	8193	6	0	5	Q2	2012	11.8500	4.7400	3.0000	1
222	8213	14	0	12	Q4	2012	3.9500	1.6985	1.0000	1
222	8254	17	0	9	Q3	2012	7.9000	3.7920	2.0000	1
222	8298	13	0	11	Q4	2012	11.8500	4.5030	3.0000	1
222	8427	16	0	10	Q4	2012	11.8500	4.5030	3.0000	1
222	8794	17	0	8	Q3	2012	15.8000	4.8980	4.0000	1
222	8816	6	0	7	Q3	2012	15.8000	6.3200	4.0000	1
222	9063	23	0	1	Q1	2012	7.9000	2.7650	2.0000	1
222	9200	16	1235	11	Q4	2012	11.8500	4.7400	3.0000	1
222	9719	11	0	10	Q4	2012	15.8000	7.4260	4.0000	1
222	9745	17	0	5	Q2	2012	11.8500	5.2140	3.0000	1
222	9881	3	0	11	Q4	2012	11.8500	4.9770	3.0000	1
222	9972	13	988	7	Q3	2012	11.8500	4.1475	3.0000	1
222	10020	11	837	10	Q4	2012	11.8500	5.6880	3.0000	1
222	10030	15	0	1	Q1	2012	15.8000	7.2680	4.0000	1
223	99	3	0	6	Q2	2012	9.5700	4.2108	3.0000	1
223	405	7	516	8	Q3	2012	6.3800	2.1692	2.0000	1
223	709	6	0	6	Q2	2012	6.3800	3.1262	2.0000	1
223	827	24	0	4	Q2	2012	12.7600	3.9556	4.0000	1
223	950	13	0	1	Q1	2012	9.5700	3.5409	3.0000	1
223	1033	24	0	1	Q1	2012	12.7600	3.9556	4.0000	1
223	1141	11	833	8	Q3	2012	9.5700	3.6366	3.0000	1
223	1202	11	0	7	Q3	2012	9.5700	3.0624	3.0000	1
223	1373	7	0	1	Q1	2012	12.7600	5.1040	4.0000	1
223	1385	15	0	7	Q3	2012	9.5700	3.8280	3.0000	1
223	1649	24	1869	12	Q4	2012	9.5700	4.3065	3.0000	1
223	1771	2	0	12	Q4	2012	3.1900	1.4674	1.0000	1
223	1979	3	0	6	Q2	2012	9.5700	3.3495	3.0000	1
223	1983	17	0	2	Q1	2012	15.9500	7.0180	5.0000	1
223	2298	3	0	8	Q3	2012	6.3800	3.0624	2.0000	1
223	2756	3	0	3	Q1	2012	12.7600	4.3384	4.0000	1
223	2829	23	0	1	Q1	2012	9.5700	3.6366	3.0000	1
223	2896	3	0	3	Q1	2012	6.3800	2.7434	2.0000	1
223	3021	16	1233	10	Q4	2012	6.3800	3.0624	2.0000	1
223	3351	22	0	3	Q1	2012	6.3800	2.6158	2.0000	1
223	3580	6	0	12	Q4	2012	9.5700	3.7323	3.0000	1
223	3709	7	0	1	Q1	2012	6.3800	2.1054	2.0000	1
223	3709	7	0	11	Q4	2012	9.5700	3.7323	3.0000	1
223	3975	24	0	12	Q4	2012	9.5700	3.9237	3.0000	1
223	4416	6	0	5	Q2	2012	9.5700	3.1581	3.0000	1
223	4460	3	0	9	Q3	2012	9.5700	4.4022	3.0000	1
223	4739	15	0	6	Q2	2012	9.5700	3.6366	3.0000	1
223	5161	7	518	8	Q3	2012	6.3800	2.8710	2.0000	1
223	5174	16	0	8	Q3	2012	6.3800	3.1262	2.0000	1
223	5530	13	980	3	Q1	2012	12.7600	3.9556	4.0000	1
223	5610	13	0	11	Q4	2012	12.7600	4.7212	4.0000	1
223	5686	3	0	12	Q4	2012	6.3800	2.1054	2.0000	1
223	5824	7	0	4	Q2	2012	9.5700	3.1581	3.0000	1
223	5899	13	0	2	Q1	2012	9.5700	3.3495	3.0000	1
223	5984	17	0	6	Q2	2012	9.5700	4.2108	3.0000	1
223	6026	15	0	1	Q1	2012	12.7600	5.3592	4.0000	1
223	6153	16	0	7	Q3	2012	15.9500	7.0180	5.0000	1
223	6168	17	0	3	Q1	2012	9.5700	3.7323	3.0000	1
223	6256	6	0	8	Q3	2012	9.5700	4.2108	3.0000	1
223	6574	13	0	9	Q3	2012	9.5700	3.3495	3.0000	1
223	6683	17	0	9	Q3	2012	12.7600	6.2524	4.0000	1
223	6710	13	0	7	Q3	2012	9.5700	3.5409	3.0000	1
223	6754	7	0	10	Q4	2012	9.5700	3.5409	3.0000	1
223	7150	14	0	8	Q3	2012	6.3800	2.4882	2.0000	1
223	7234	16	0	8	Q3	2012	9.5700	4.4022	3.0000	1
223	7429	6	0	5	Q2	2012	12.7600	5.2316	4.0000	1
223	7589	17	0	6	Q2	2012	9.5700	3.7323	3.0000	1
223	8411	15	0	5	Q2	2012	9.5700	4.7850	3.0000	1
223	8578	23	0	8	Q3	2012	9.5700	2.9667	3.0000	1
223	8885	7	0	7	Q3	2012	6.3800	2.5520	2.0000	1
223	8968	11	826	5	Q2	2012	15.9500	6.5395	5.0000	1
223	9016	23	0	11	Q4	2012	9.5700	3.1581	3.0000	1
223	9535	11	0	10	Q4	2012	12.7600	3.9556	4.0000	1
223	9690	15	1154	10	Q4	2012	12.7600	6.2524	4.0000	1
223	9719	11	829	6	Q2	2012	15.9500	7.4965	5.0000	1
223	10010	2	0	7	Q3	2012	3.1900	1.1803	1.0000	1
223	10068	23	0	11	Q4	2012	9.5700	3.9237	3.0000	1
224	115	7	512	6	Q2	2012	3.4600	1.1764	2.0000	1
224	280	13	0	3	Q1	2012	6.9200	2.9064	4.0000	1
224	290	15	0	5	Q2	2012	5.1900	2.0241	3.0000	1
224	341	17	0	3	Q1	2012	5.1900	1.9203	3.0000	1
224	792	7	0	7	Q3	2012	5.1900	1.6608	3.0000	1
224	879	7	504	2	Q1	2012	3.4600	1.5570	2.0000	1
224	1289	23	1786	10	Q4	2012	6.9200	2.9756	4.0000	1
224	1388	13	0	2	Q1	2012	5.1900	2.5950	3.0000	1
224	1609	14	1070	8	Q3	2012	1.7300	0.6055	1.0000	1
224	1883	15	1134	1	Q1	2012	3.4600	1.6608	2.0000	1
224	2241	6	0	8	Q3	2012	5.1900	1.9203	3.0000	1
224	2314	7	0	3	Q1	2012	5.1900	1.6608	3.0000	1
224	2335	17	0	4	Q2	2012	3.4600	1.6608	2.0000	1
224	2371	16	0	1	Q1	2012	3.4600	1.1764	2.0000	1
224	2382	15	0	2	Q1	2012	6.9200	3.3908	4.0000	1
224	2769	16	0	11	Q4	2012	6.9200	3.3216	4.0000	1
224	3001	13	0	1	Q1	2012	6.9200	3.3908	4.0000	1
224	3463	13	0	6	Q2	2012	5.1900	2.1798	3.0000	1
224	3938	13	976	1	Q1	2012	3.4600	1.7300	2.0000	1
224	4490	13	0	7	Q3	2012	3.4600	1.5224	2.0000	1
224	4651	22	1711	12	Q4	2012	3.4600	1.6954	2.0000	1
224	4727	16	1225	7	Q3	2012	6.9200	2.2836	4.0000	1
224	4739	15	0	11	Q4	2012	5.1900	1.8684	3.0000	1
224	4948	13	980	3	Q1	2012	5.1900	1.6608	3.0000	1
224	5153	11	0	11	Q4	2012	3.4600	1.5224	2.0000	1
224	5387	7	0	4	Q2	2012	5.1900	1.6089	3.0000	1
224	5924	13	0	5	Q2	2012	5.1900	2.0760	3.0000	1
224	5924	13	0	10	Q4	2012	5.1900	2.4393	3.0000	1
224	5931	24	1856	6	Q2	2012	5.1900	1.7646	3.0000	1
224	6059	7	0	10	Q4	2012	6.9200	2.4220	4.0000	1
224	6180	13	0	2	Q1	2012	5.1900	2.4393	3.0000	1
224	6698	13	0	1	Q1	2012	3.4600	1.5570	2.0000	1
224	6712	16	1216	2	Q1	2012	3.4600	1.5224	2.0000	1
224	6866	17	0	3	Q1	2012	3.4600	1.2110	2.0000	1
224	6905	7	517	8	Q3	2012	5.1900	1.6608	3.0000	1
224	6946	7	0	10	Q4	2012	5.1900	1.9722	3.0000	1
224	7618	11	826	5	Q2	2012	6.9200	2.4912	4.0000	1
224	8215	11	836	9	Q3	2012	6.9200	2.9756	4.0000	1
224	8329	15	0	8	Q3	2012	6.9200	3.1832	4.0000	1
224	8808	14	0	3	Q1	2012	1.7300	0.6747	1.0000	1
224	8902	3	0	11	Q4	2012	3.4600	1.3148	2.0000	1
224	9095	7	0	10	Q4	2012	5.1900	1.7646	3.0000	1
224	9399	6	523	11	Q4	2012	6.9200	2.8372	4.0000	1
224	9461	17	0	5	Q2	2012	6.9200	2.4912	4.0000	1
224	9668	13	0	6	Q2	2012	5.1900	1.9722	3.0000	1
224	9998	6	0	5	Q2	2012	6.9200	2.9756	4.0000	1
224	10104	7	505	2	Q1	2012	5.1900	1.8684	3.0000	1
224	10142	11	0	11	Q4	2012	3.4600	1.1418	2.0000	1
224	10145	13	0	2	Q1	2012	5.1900	2.4393	3.0000	1
225	30	11	0	3	Q1	2012	11.6700	4.3179	3.0000	1
225	126	15	0	11	Q4	2012	15.5600	6.5352	4.0000	1
225	314	15	0	4	Q2	2012	15.5600	7.3132	4.0000	1
225	454	17	0	2	Q1	2012	11.6700	5.2515	3.0000	1
225	887	14	0	6	Q2	2012	3.8900	1.3615	1.0000	1
225	1271	13	0	4	Q2	2012	7.7800	2.6452	2.0000	1
225	1330	13	0	7	Q3	2012	7.7800	3.2676	2.0000	1
225	1330	13	0	12	Q4	2012	15.5600	6.5352	4.0000	1
225	1339	13	0	5	Q2	2012	11.6700	4.9014	3.0000	1
225	1497	17	0	7	Q3	2012	15.5600	7.3132	4.0000	1
225	1738	6	0	1	Q1	2012	15.5600	7.0020	4.0000	1
225	1848	11	0	10	Q4	2012	11.6700	3.9678	3.0000	1
225	2059	17	0	12	Q4	2012	15.5600	7.4688	4.0000	1
225	2143	17	0	2	Q1	2012	11.6700	3.5010	3.0000	1
225	2259	15	1140	4	Q2	2012	11.6700	4.6680	3.0000	1
225	2376	11	0	9	Q3	2012	11.6700	4.5513	3.0000	1
225	2688	7	0	3	Q1	2012	11.6700	3.9678	3.0000	1
225	2776	22	0	6	Q2	2012	3.8900	1.2059	1.0000	1
225	2818	6	526	12	Q4	2012	11.6700	5.8350	3.0000	1
225	3149	11	0	4	Q2	2012	7.7800	3.5010	2.0000	1
225	3321	24	0	1	Q1	2012	11.6700	5.6016	3.0000	1
225	3605	14	0	5	Q2	2012	7.7800	3.7344	2.0000	1
225	3993	24	0	10	Q4	2012	15.5600	5.7572	4.0000	1
225	4431	13	976	1	Q1	2012	7.7800	3.8122	2.0000	1
225	4973	17	0	9	Q3	2012	11.6700	3.9678	3.0000	1
225	5286	15	0	6	Q2	2012	11.6700	4.5513	3.0000	1
225	5530	13	0	7	Q3	2012	15.5600	4.8236	4.0000	1
225	5892	15	0	1	Q1	2012	7.7800	2.8786	2.0000	1
225	5984	17	0	11	Q4	2012	11.6700	4.4346	3.0000	1
225	6178	24	0	6	Q2	2012	11.6700	4.2012	3.0000	1
225	6206	11	829	6	Q2	2012	15.5600	6.5352	4.0000	1
225	6309	2	0	5	Q2	2012	3.8900	1.4004	1.0000	1
225	6309	2	0	8	Q3	2012	3.8900	1.6338	1.0000	1
225	6313	17	0	5	Q2	2012	11.6700	4.4346	3.0000	1
225	6792	13	0	4	Q2	2012	15.5600	5.7572	4.0000	1
225	7203	13	0	9	Q3	2012	11.6700	5.4849	3.0000	1
225	7234	16	0	7	Q3	2012	15.5600	7.7800	4.0000	1
225	7384	3	202	8	Q3	2012	15.5600	7.0020	4.0000	1
225	7444	13	0	1	Q1	2012	7.7800	2.8786	2.0000	1
225	8048	7	0	10	Q4	2012	15.5600	7.6244	4.0000	1
225	8272	7	0	10	Q4	2012	11.6700	3.9678	3.0000	1
225	8298	13	0	1	Q1	2012	11.6700	4.3179	3.0000	1
225	8436	15	0	6	Q2	2012	11.6700	5.8350	3.0000	1
225	8483	15	0	7	Q3	2012	15.5600	5.4460	4.0000	1
225	8976	13	980	3	Q1	2012	7.7800	3.5010	2.0000	1
225	9194	17	0	8	Q3	2012	19.4500	7.3910	5.0000	1
225	9213	11	0	11	Q4	2012	11.6700	4.6680	3.0000	1
225	9313	7	0	4	Q2	2012	19.4500	9.1415	5.0000	1
225	10142	11	0	4	Q2	2012	11.6700	4.6680	3.0000	1
225	10225	23	0	5	Q2	2012	11.6700	4.0845	3.0000	1
225	10248	15	1141	4	Q2	2012	11.6700	4.5513	3.0000	1
225	10274	6	515	7	Q3	2012	15.5600	6.5352	4.0000	1
226	406	7	504	2	Q1	2012	2.2800	1.0032	3.0000	1
226	461	11	0	8	Q3	2012	3.0400	1.2160	4.0000	1
226	1556	17	0	3	Q1	2012	3.8000	1.7860	5.0000	1
226	1874	17	0	8	Q3	2012	1.5200	0.4712	2.0000	1
226	1923	11	0	12	Q4	2012	3.0400	1.3984	4.0000	1
226	2587	16	0	8	Q3	2012	2.2800	1.0944	3.0000	1
226	3254	15	0	1	Q1	2012	1.5200	0.6688	2.0000	1
226	3491	16	0	3	Q1	2012	2.2800	0.9576	3.0000	1
226	3558	24	0	4	Q2	2012	2.2800	0.7068	3.0000	1
226	3719	23	0	6	Q2	2012	2.2800	0.7980	3.0000	1
226	3728	13	0	12	Q4	2012	1.5200	0.7144	2.0000	1
226	4118	17	1303	6	Q2	2012	1.5200	0.5776	2.0000	1
226	4155	7	0	5	Q2	2012	1.5200	0.7448	2.0000	1
226	4239	17	0	10	Q4	2012	3.0400	1.0032	4.0000	1
226	4351	23	0	7	Q3	2012	3.8000	1.8240	5.0000	1
226	4391	16	0	5	Q2	2012	3.0400	1.0336	4.0000	1
226	4507	13	0	11	Q4	2012	1.5200	0.6688	2.0000	1
226	4522	17	1303	6	Q2	2012	2.2800	0.8436	3.0000	1
226	4998	3	0	12	Q4	2012	2.2800	0.8892	3.0000	1
226	5026	17	0	12	Q4	2012	2.2800	1.0488	3.0000	1
226	5358	3	0	7	Q3	2012	2.2800	1.0944	3.0000	1
226	5373	24	0	9	Q3	2012	2.2800	0.8892	3.0000	1
226	5537	3	201	8	Q3	2012	1.5200	0.7448	2.0000	1
226	5597	3	0	5	Q2	2012	1.5200	0.5928	2.0000	1
226	5875	11	829	6	Q2	2012	2.2800	0.7752	3.0000	1
226	6003	13	0	11	Q4	2012	3.0400	1.2464	4.0000	1
226	6218	11	0	6	Q2	2012	3.0400	1.2464	4.0000	1
226	6307	16	0	11	Q4	2012	1.5200	0.4864	2.0000	1
226	6565	15	0	3	Q1	2012	1.5200	0.7144	2.0000	1
226	6712	16	0	9	Q3	2012	2.2800	0.7068	3.0000	1
226	6831	14	0	12	Q4	2012	0.7600	0.3344	1.0000	1
226	6970	7	0	7	Q3	2012	2.2800	0.8664	3.0000	1
226	7003	15	1154	10	Q4	2012	3.0400	1.2464	4.0000	1
226	7283	13	0	12	Q4	2012	1.5200	0.6384	2.0000	1
226	7359	13	0	1	Q1	2012	1.5200	0.5776	2.0000	1
226	7434	11	826	5	Q2	2012	3.0400	1.4288	4.0000	1
226	7601	24	0	4	Q2	2012	1.5200	0.6536	2.0000	1
226	7611	7	0	6	Q2	2012	2.2800	0.7068	3.0000	1
226	7636	7	523	11	Q4	2012	1.5200	0.6536	2.0000	1
226	7951	15	0	12	Q4	2012	1.5200	0.5016	2.0000	1
226	8068	3	207	11	Q4	2012	1.5200	0.7296	2.0000	1
226	8146	11	0	12	Q4	2012	1.5200	0.4864	2.0000	1
226	8275	16	0	3	Q1	2012	2.2800	0.8892	3.0000	1
226	8427	16	1236	12	Q4	2012	2.2800	1.0944	3.0000	1
226	8730	6	513	6	Q2	2012	1.5200	0.4864	2.0000	1
226	8797	11	833	8	Q3	2012	3.0400	0.9728	4.0000	1
226	8968	11	0	5	Q2	2012	3.8000	1.5580	5.0000	1
226	9153	24	1850	3	Q1	2012	2.2800	0.9120	3.0000	1
226	9306	24	0	2	Q1	2012	3.0400	1.3072	4.0000	1
226	9698	23	0	8	Q3	2012	2.2800	1.0488	3.0000	1
226	9710	7	0	7	Q3	2012	2.2800	1.0032	3.0000	1
226	9710	6	502	1	Q1	2012	1.5200	0.5928	2.0000	1
226	10152	13	0	1	Q1	2012	2.2800	0.7980	3.0000	1
226	10243	17	0	1	Q1	2012	3.0400	1.3984	4.0000	1
227	17	6	526	12	Q4	2012	5.9400	2.4354	3.0000	1
227	363	6	0	6	Q2	2012	7.9200	3.4056	4.0000	1
227	417	7	512	6	Q2	2012	5.9400	2.6136	3.0000	1
227	430	16	0	12	Q4	2012	7.9200	2.4552	4.0000	1
227	573	11	829	6	Q2	2012	3.9600	1.7820	2.0000	1
227	647	3	0	12	Q4	2012	5.9400	1.9008	3.0000	1
227	663	16	0	12	Q4	2012	3.9600	1.3464	2.0000	1
227	705	6	0	5	Q2	2012	9.9000	3.9600	5.0000	1
227	764	6	0	7	Q3	2012	5.9400	2.5542	3.0000	1
227	873	24	0	2	Q1	2012	7.9200	3.9600	4.0000	1
227	873	24	0	12	Q4	2012	7.9200	2.6928	4.0000	1
227	1044	24	0	4	Q2	2012	3.9600	1.6632	2.0000	1
227	1556	17	0	10	Q4	2012	9.9000	4.6530	5.0000	1
227	1832	23	1786	10	Q4	2012	3.9600	1.6236	2.0000	1
227	2032	23	0	6	Q2	2012	5.9400	2.3166	3.0000	1
227	2147	13	976	1	Q1	2012	5.9400	2.0790	3.0000	1
227	2211	17	1303	6	Q2	2012	5.9400	1.8414	3.0000	1
227	2507	3	195	5	Q2	2012	7.9200	2.7720	4.0000	1
227	2632	13	0	12	Q4	2012	5.9400	2.3166	3.0000	1
227	2808	13	0	4	Q2	2012	5.9400	2.4354	3.0000	1
227	3404	24	1859	8	Q3	2012	5.9400	2.7918	3.0000	1
227	3603	24	0	4	Q2	2012	7.9200	2.9304	4.0000	1
227	3754	11	0	3	Q1	2012	7.9200	2.5344	4.0000	1
227	4021	16	1214	2	Q1	2012	7.9200	3.5640	4.0000	1
227	4100	7	0	4	Q2	2012	7.9200	2.7720	4.0000	1
227	4257	3	0	6	Q2	2012	5.9400	2.1384	3.0000	1
227	4282	15	1138	3	Q1	2012	7.9200	2.7720	4.0000	1
227	4307	7	521	10	Q4	2012	3.9600	1.8612	2.0000	1
227	4452	24	1869	12	Q4	2012	5.9400	2.5542	3.0000	1
227	4700	17	0	9	Q3	2012	5.9400	2.2572	3.0000	1
227	4767	16	0	12	Q4	2012	3.9600	1.2672	2.0000	1
227	4767	16	1225	7	Q3	2012	3.9600	1.5048	2.0000	1
227	4846	17	0	3	Q1	2012	3.9600	1.4652	2.0000	1
227	5141	6	0	6	Q2	2012	3.9600	1.3860	2.0000	1
227	5174	16	0	4	Q2	2012	5.9400	2.1384	3.0000	1
227	5196	13	0	8	Q3	2012	9.9000	3.3660	5.0000	1
227	5304	15	0	8	Q3	2012	7.9200	3.7224	4.0000	1
227	5877	17	0	12	Q4	2012	5.9400	2.4354	3.0000	1
227	6003	13	0	8	Q3	2012	5.9400	1.9602	3.0000	1
227	6098	3	205	10	Q4	2012	5.9400	2.1384	3.0000	1
227	6706	6	0	4	Q2	2012	3.9600	1.7424	2.0000	1
227	6766	24	1850	3	Q1	2012	7.9200	2.7720	4.0000	1
227	6936	17	0	10	Q4	2012	7.9200	3.8016	4.0000	1
227	6988	6	524	11	Q4	2012	5.9400	1.9008	3.0000	1
227	7366	3	0	9	Q3	2012	5.9400	2.1978	3.0000	1
227	7455	13	0	12	Q4	2012	5.9400	2.1978	3.0000	1
227	7899	6	504	2	Q1	2012	5.9400	2.4948	3.0000	1
227	8065	15	1140	4	Q2	2012	3.9600	1.3068	2.0000	1
227	8068	3	197	6	Q2	2012	5.9400	1.9602	3.0000	1
227	8289	17	0	12	Q4	2012	5.9400	2.6730	3.0000	1
227	8310	13	984	5	Q2	2012	5.9400	2.6730	3.0000	1
227	8411	15	0	10	Q4	2012	7.9200	3.1680	4.0000	1
227	8431	14	0	6	Q2	2012	1.9800	0.8712	1.0000	1
227	8504	13	0	2	Q1	2012	5.9400	2.3166	3.0000	1
227	8889	11	0	1	Q1	2012	5.9400	1.9008	3.0000	1
227	9144	13	0	7	Q3	2012	5.9400	2.7324	3.0000	1
227	9170	7	0	10	Q4	2012	7.9200	3.8808	4.0000	1
227	9264	24	1845	1	Q1	2012	5.9400	2.3166	3.0000	1
227	9499	6	0	10	Q4	2012	3.9600	1.2672	2.0000	1
227	9584	13	0	11	Q4	2012	7.9200	3.9600	4.0000	1
227	10010	2	0	5	Q2	2012	1.9800	0.7326	1.0000	1
228	190	13	0	1	Q1	2012	2.4600	1.1070	3.0000	1
228	446	13	0	10	Q4	2012	2.4600	0.9102	3.0000	1
228	901	13	0	2	Q1	2012	3.2800	1.6072	4.0000	1
228	957	6	0	8	Q3	2012	1.6400	0.6560	2.0000	1
228	997	3	0	4	Q2	2012	1.6400	0.5248	2.0000	1
228	1005	3	0	12	Q4	2012	2.4600	0.8610	3.0000	1
228	1036	13	0	11	Q4	2012	1.6400	0.5248	2.0000	1
228	1037	7	0	10	Q4	2012	2.4600	1.0824	3.0000	1
228	1112	24	0	12	Q4	2012	2.4600	0.8118	3.0000	1
228	1333	2	0	9	Q3	2012	2.4600	1.0332	3.0000	1
228	1409	24	0	4	Q2	2012	1.6400	0.6068	2.0000	1
228	1548	13	0	1	Q1	2012	2.4600	1.0086	3.0000	1
228	1690	16	0	11	Q4	2012	3.2800	1.3120	4.0000	1
228	1773	13	0	2	Q1	2012	2.4600	0.9348	3.0000	1
228	1793	13	0	12	Q4	2012	3.2800	1.4760	4.0000	1
228	2443	13	976	1	Q1	2012	3.2800	1.3120	4.0000	1
228	2632	13	988	7	Q3	2012	2.4600	1.1070	3.0000	1
228	2756	3	0	4	Q2	2012	2.4600	1.0086	3.0000	1
228	2772	24	0	1	Q1	2012	3.2800	1.1808	4.0000	1
228	3253	13	984	5	Q2	2012	2.4600	0.8856	3.0000	1
228	3493	2	0	7	Q3	2012	0.8200	0.3362	1.0000	1
228	3497	17	0	9	Q3	2012	2.4600	0.8364	3.0000	1
228	3673	22	0	2	Q1	2012	1.6400	0.5904	2.0000	1
228	3819	23	1789	12	Q4	2012	1.6400	0.5740	2.0000	1
228	3878	3	0	2	Q1	2012	1.6400	0.7380	2.0000	1
228	3965	24	0	8	Q3	2012	1.6400	0.5412	2.0000	1
228	4094	16	1225	7	Q3	2012	1.6400	0.6068	2.0000	1
228	4096	3	0	8	Q3	2012	3.2800	1.6072	4.0000	1
228	4143	11	0	3	Q1	2012	1.6400	0.5248	2.0000	1
228	4258	7	0	4	Q2	2012	1.6400	0.7872	2.0000	1
228	4556	13	0	3	Q1	2012	2.4600	0.9594	3.0000	1
228	4719	23	0	3	Q1	2012	2.4600	0.8610	3.0000	1
228	4900	13	0	12	Q4	2012	2.4600	0.8610	3.0000	1
228	5183	6	0	6	Q2	2012	1.6400	0.7872	2.0000	1
228	5432	16	1235	11	Q4	2012	3.2800	1.5088	4.0000	1
228	5895	17	0	11	Q4	2012	2.4600	0.8364	3.0000	1
228	6087	13	0	2	Q1	2012	2.4600	0.7872	3.0000	1
228	6168	17	1314	11	Q4	2012	2.4600	0.9594	3.0000	1
228	6666	17	0	12	Q4	2012	3.2800	1.1480	4.0000	1
228	6760	17	1312	10	Q4	2012	2.4600	0.7872	3.0000	1
228	6956	13	0	3	Q1	2012	2.4600	0.9102	3.0000	1
228	7611	6	0	9	Q3	2012	2.4600	0.8364	3.0000	1
228	7641	13	0	3	Q1	2012	2.4600	0.7380	3.0000	1
228	7801	7	0	3	Q1	2012	2.4600	0.8610	3.0000	1
228	7822	3	0	2	Q1	2012	2.4600	1.2300	3.0000	1
228	7831	17	1292	1	Q1	2012	3.2800	1.0824	4.0000	1
228	8224	7	0	10	Q4	2012	3.2800	1.4432	4.0000	1
228	8291	13	0	10	Q4	2012	1.6400	0.5248	2.0000	1
228	8445	7	0	12	Q4	2012	3.2800	1.2792	4.0000	1
228	8947	3	207	11	Q4	2012	1.6400	0.6232	2.0000	1
228	9025	13	0	8	Q3	2012	2.4600	0.8118	3.0000	1
228	9139	22	0	1	Q1	2012	1.6400	0.6068	2.0000	1
228	9447	13	0	7	Q3	2012	2.4600	0.9840	3.0000	1
228	9507	7	0	8	Q3	2012	3.2800	1.4104	4.0000	1
228	9516	6	0	4	Q2	2012	2.4600	1.0086	3.0000	1
228	9591	7	0	4	Q2	2012	2.4600	0.8364	3.0000	1
228	9694	6	508	4	Q2	2012	3.2800	1.0824	4.0000	1
228	9951	3	0	1	Q1	2012	2.4600	0.9840	3.0000	1
229	268	6	526	12	Q4	2012	8.9200	4.4600	4.0000	1
229	312	7	0	5	Q2	2012	11.1500	4.0140	5.0000	1
229	404	7	0	10	Q4	2012	6.6900	2.8098	3.0000	1
229	521	11	0	6	Q2	2012	8.9200	3.8356	4.0000	1
229	709	7	0	1	Q1	2012	8.9200	3.3004	4.0000	1
229	739	23	0	12	Q4	2012	4.4600	1.3826	2.0000	1
229	813	11	821	3	Q1	2012	8.9200	3.0328	4.0000	1
229	986	15	0	3	Q1	2012	4.4600	1.6056	2.0000	1
229	1074	13	1000	12	Q4	2012	6.6900	3.3450	3.0000	1
229	1138	6	0	1	Q1	2012	6.6900	3.1443	3.0000	1
229	1378	11	833	8	Q3	2012	6.6900	2.6091	3.0000	1
229	1529	13	0	1	Q1	2012	11.1500	3.6795	5.0000	1
229	1970	3	0	1	Q1	2012	8.9200	2.9436	4.0000	1
229	1984	24	0	4	Q2	2012	6.6900	2.6091	3.0000	1
229	2371	16	0	6	Q2	2012	6.6900	3.2112	3.0000	1
229	2371	16	0	9	Q3	2012	8.9200	4.3708	4.0000	1
229	2493	17	0	4	Q2	2012	4.4600	2.1408	2.0000	1
229	2613	11	0	2	Q1	2012	6.6900	2.4084	3.0000	1
229	3127	6	502	1	Q1	2012	6.6900	2.9436	3.0000	1
229	3130	13	0	4	Q2	2012	6.6900	2.8098	3.0000	1
229	3541	15	1140	4	Q2	2012	4.4600	1.9624	2.0000	1
229	3878	3	0	3	Q1	2012	4.4600	1.5164	2.0000	1
229	3922	7	523	11	Q4	2012	6.6900	3.3450	3.0000	1
229	4120	15	0	11	Q4	2012	6.6900	3.3450	3.0000	1
229	4175	16	1214	2	Q1	2012	6.6900	3.3450	3.0000	1
229	4385	7	0	3	Q1	2012	8.9200	4.1032	4.0000	1
229	5245	11	0	11	Q4	2012	4.4600	1.9624	2.0000	1
229	5528	24	1853	5	Q2	2012	4.4600	1.8732	2.0000	1
229	5590	17	0	4	Q2	2012	8.9200	2.6760	4.0000	1
229	5781	11	0	6	Q2	2012	4.4600	1.4718	2.0000	1
229	5862	2	0	8	Q3	2012	4.4600	2.0516	2.0000	1
229	6291	3	0	2	Q1	2012	4.4600	1.6502	2.0000	1
229	6386	14	0	6	Q2	2012	4.4600	1.3826	2.0000	1
229	6442	7	0	7	Q3	2012	8.9200	3.3896	4.0000	1
229	6499	17	0	7	Q3	2012	8.9200	2.8544	4.0000	1
229	6616	11	820	2	Q1	2012	8.9200	3.6572	4.0000	1
229	6745	6	0	6	Q2	2012	6.6900	3.1443	3.0000	1
229	6760	17	1307	8	Q3	2012	4.4600	1.7840	2.0000	1
229	7287	24	0	2	Q1	2012	8.9200	3.9248	4.0000	1
229	7419	14	1066	6	Q2	2012	4.4600	2.1854	2.0000	1
229	8382	15	0	9	Q3	2012	4.4600	1.9624	2.0000	1
229	8947	3	197	6	Q2	2012	6.6900	2.4084	3.0000	1
229	9184	3	0	10	Q4	2012	4.4600	2.0516	2.0000	1
229	9563	15	1146	7	Q3	2012	11.1500	3.5680	5.0000	1
229	9744	6	0	3	Q1	2012	4.4600	1.4718	2.0000	1
229	9851	3	0	9	Q3	2012	4.4600	1.6056	2.0000	1
230	341	17	0	3	Q1	2012	3.5700	1.2495	3.0000	1
230	417	6	0	9	Q3	2012	2.3800	1.1424	2.0000	1
230	448	17	0	1	Q1	2012	4.7600	1.9992	4.0000	1
230	484	13	0	8	Q3	2012	5.9500	2.2610	5.0000	1
230	547	24	0	6	Q2	2012	4.7600	1.5708	4.0000	1
230	760	3	0	7	Q3	2012	2.3800	1.1900	2.0000	1
230	916	7	517	8	Q3	2012	4.7600	2.3800	4.0000	1
230	1423	13	0	9	Q3	2012	3.5700	1.4994	3.0000	1
230	1607	17	0	2	Q1	2012	4.7600	2.1420	4.0000	1
230	1676	3	0	3	Q1	2012	2.3800	0.9044	2.0000	1
230	1690	16	0	5	Q2	2012	3.5700	1.0710	3.0000	1
230	2215	11	0	3	Q1	2012	4.7600	2.1896	4.0000	1
230	2372	15	1154	10	Q4	2012	3.5700	1.4994	3.0000	1
230	2908	11	0	7	Q3	2012	4.7600	1.6660	4.0000	1
230	3011	15	0	5	Q2	2012	4.7600	2.0944	4.0000	1
230	3075	23	1769	3	Q1	2012	3.5700	1.7493	3.0000	1
230	3307	15	0	3	Q1	2012	4.7600	1.4756	4.0000	1
230	3426	11	0	2	Q1	2012	3.5700	1.4994	3.0000	1
230	3497	17	0	2	Q1	2012	3.5700	1.1067	3.0000	1
230	3599	13	0	1	Q1	2012	2.3800	0.9996	2.0000	1
230	3664	22	0	6	Q2	2012	2.3800	0.9044	2.0000	1
230	3894	15	0	7	Q3	2012	3.5700	1.1424	3.0000	1
230	4234	3	0	7	Q3	2012	4.7600	1.9040	4.0000	1
230	4498	17	1303	6	Q2	2012	4.7600	1.8564	4.0000	1
230	4543	13	0	1	Q1	2012	3.5700	1.0710	3.0000	1
230	4691	17	0	5	Q2	2012	4.7600	1.4280	4.0000	1
230	4810	23	0	12	Q4	2012	4.7600	2.3324	4.0000	1
230	5297	6	0	9	Q3	2012	3.5700	1.1781	3.0000	1
230	5341	17	0	1	Q1	2012	3.5700	1.1067	3.0000	1
230	5400	15	0	12	Q4	2012	4.7600	1.9040	4.0000	1
230	5747	15	1150	8	Q3	2012	5.9500	2.9155	5.0000	1
230	6398	11	0	2	Q1	2012	4.7600	1.9992	4.0000	1
230	6403	2	0	3	Q1	2012	1.1900	0.5831	1.0000	1
230	6694	6	0	4	Q2	2012	4.7600	2.2372	4.0000	1
230	6710	13	0	7	Q3	2012	3.5700	1.2495	3.0000	1
230	6957	16	1231	9	Q3	2012	2.3800	0.8092	2.0000	1
230	7818	11	0	3	Q1	2012	3.5700	1.1781	3.0000	1
230	7828	11	818	1	Q1	2012	3.5700	1.3923	3.0000	1
230	7997	13	0	4	Q2	2012	4.7600	1.4756	4.0000	1
230	8452	16	0	5	Q2	2012	2.3800	0.7854	2.0000	1
230	8659	13	0	1	Q1	2012	4.7600	2.1420	4.0000	1
230	8668	13	0	8	Q3	2012	3.5700	1.3923	3.0000	1
230	8731	3	0	9	Q3	2012	2.3800	0.8330	2.0000	1
230	9163	15	0	6	Q2	2012	3.5700	1.4637	3.0000	1
230	9293	24	1847	2	Q1	2012	3.5700	1.5351	3.0000	1
230	9427	24	0	7	Q3	2012	2.3800	0.7854	2.0000	1
230	10277	11	0	4	Q2	2012	4.7600	1.4280	4.0000	1
231	137	7	0	9	Q3	2012	10.6000	3.2860	4.0000	1
231	158	17	1314	11	Q4	2012	7.9500	3.8160	3.0000	1
231	771	15	0	10	Q4	2012	10.6000	3.8160	4.0000	1
231	1074	13	0	2	Q1	2012	7.9500	3.9750	3.0000	1
231	1075	24	0	10	Q4	2012	5.3000	2.3850	2.0000	1
231	1403	24	0	8	Q3	2012	5.3000	2.3850	2.0000	1
231	1706	13	0	9	Q3	2012	7.9500	2.7825	3.0000	1
231	1897	13	0	6	Q2	2012	7.9500	2.4645	3.0000	1
231	1897	13	976	1	Q1	2012	7.9500	2.4645	3.0000	1
231	2077	23	1786	10	Q4	2012	5.3000	2.3850	2.0000	1
231	2086	13	0	6	Q2	2012	10.6000	3.6040	4.0000	1
231	2134	11	0	10	Q4	2012	5.3000	1.8020	2.0000	1
231	2441	17	0	10	Q4	2012	10.6000	4.1340	4.0000	1
231	2493	17	0	4	Q2	2012	7.9500	2.4645	3.0000	1
231	2513	11	818	1	Q1	2012	7.9500	3.1005	3.0000	1
231	2673	11	0	1	Q1	2012	7.9500	3.1005	3.0000	1
231	2881	24	0	12	Q4	2012	7.9500	3.3390	3.0000	1
231	3288	3	0	4	Q2	2012	7.9500	3.4980	3.0000	1
231	3319	11	0	7	Q3	2012	10.6000	4.0280	4.0000	1
231	3436	11	0	10	Q4	2012	10.6000	3.7100	4.0000	1
231	3739	2	112	3	Q1	2012	5.3000	2.0670	2.0000	1
231	3780	24	1856	6	Q2	2012	5.3000	2.2790	2.0000	1
231	3928	23	0	3	Q1	2012	7.9500	2.6235	3.0000	1
231	4263	24	0	8	Q3	2012	13.2500	5.4325	5.0000	1
231	4397	16	0	9	Q3	2012	7.9500	2.4645	3.0000	1
231	4445	17	1293	1	Q1	2012	10.6000	3.2860	4.0000	1
231	4535	15	0	3	Q1	2012	10.6000	3.7100	4.0000	1
231	4541	3	0	3	Q1	2012	7.9500	3.7365	3.0000	1
231	4573	7	0	5	Q2	2012	5.3000	2.4910	2.0000	1
231	4642	15	0	12	Q4	2012	7.9500	2.9415	3.0000	1
231	4726	11	837	10	Q4	2012	7.9500	3.8955	3.0000	1
231	4836	11	0	6	Q2	2012	7.9500	2.7825	3.0000	1
231	4942	11	0	10	Q4	2012	7.9500	2.9415	3.0000	1
231	5063	3	0	5	Q2	2012	5.3000	2.2790	2.0000	1
231	5095	6	0	7	Q3	2012	7.9500	2.6235	3.0000	1
231	5238	17	0	4	Q2	2012	10.6000	4.2400	4.0000	1
231	5522	24	0	4	Q2	2012	10.6000	3.2860	4.0000	1
231	5541	7	521	10	Q4	2012	7.9500	2.9415	3.0000	1
231	6351	11	0	6	Q2	2012	10.6000	4.5580	4.0000	1
231	6655	11	0	1	Q1	2012	10.6000	3.8160	4.0000	1
231	6957	16	0	7	Q3	2012	7.9500	2.8620	3.0000	1
231	6978	24	1859	8	Q3	2012	7.9500	3.0210	3.0000	1
231	7132	13	992	9	Q3	2012	5.3000	2.3850	2.0000	1
231	7250	13	0	8	Q3	2012	7.9500	3.3390	3.0000	1
231	7349	14	1070	8	Q3	2012	2.6500	0.9275	1.0000	1
231	7444	13	0	5	Q2	2012	7.9500	3.3390	3.0000	1
231	7464	11	0	1	Q1	2012	13.2500	4.7700	5.0000	1
231	7486	3	0	6	Q2	2012	10.6000	4.3460	4.0000	1
231	7514	17	0	1	Q1	2012	10.6000	5.1940	4.0000	1
231	7683	22	0	12	Q4	2012	5.3000	2.3320	2.0000	1
231	7896	23	1772	4	Q2	2012	5.3000	1.8020	2.0000	1
231	8098	13	0	8	Q3	2012	7.9500	3.1005	3.0000	1
231	8418	22	1694	4	Q2	2012	2.6500	1.0865	1.0000	1
231	8452	16	0	12	Q4	2012	7.9500	3.8160	3.0000	1
231	8673	11	0	3	Q1	2012	7.9500	3.2595	3.0000	1
231	8753	6	0	12	Q4	2012	7.9500	3.5775	3.0000	1
231	9057	24	1846	2	Q1	2012	7.9500	3.9750	3.0000	1
231	9140	7	0	11	Q4	2012	7.9500	2.9415	3.0000	1
231	9273	11	0	1	Q1	2012	7.9500	3.1005	3.0000	1
231	9321	22	0	12	Q4	2012	5.3000	1.8550	2.0000	1
231	9686	7	0	7	Q3	2012	5.3000	2.4910	2.0000	1
231	9694	7	0	11	Q4	2012	10.6000	3.6040	4.0000	1
231	9858	24	1850	3	Q1	2012	13.2500	5.8300	5.0000	1
231	10273	17	1294	2	Q1	2012	10.6000	3.3920	4.0000	1
232	158	17	0	1	Q1	2012	7.8900	3.7872	3.0000	1
232	922	7	0	7	Q3	2012	7.8900	2.6037	3.0000	1
232	1193	13	0	11	Q4	2012	5.2600	1.6832	2.0000	1
232	1561	24	1846	2	Q1	2012	5.2600	2.3670	2.0000	1
232	1730	11	0	9	Q3	2012	7.8900	2.6037	3.0000	1
232	1772	15	0	4	Q2	2012	10.5200	4.5236	4.0000	1
232	1957	13	0	8	Q3	2012	7.8900	2.4459	3.0000	1
232	2493	17	1304	7	Q3	2012	7.8900	3.4716	3.0000	1
232	2612	24	0	7	Q3	2012	7.8900	2.4459	3.0000	1
232	2626	11	829	6	Q2	2012	7.8900	3.6294	3.0000	1
232	2656	13	0	7	Q3	2012	5.2600	1.7358	2.0000	1
232	2907	15	0	8	Q3	2012	10.5200	3.7872	4.0000	1
232	3113	13	980	3	Q1	2012	5.2600	1.8410	2.0000	1
232	3153	13	0	6	Q2	2012	7.8900	3.3138	3.0000	1
232	3285	6	0	7	Q3	2012	10.5200	4.8392	4.0000	1
232	3397	17	0	3	Q1	2012	7.8900	3.5505	3.0000	1
232	3545	15	0	11	Q4	2012	5.2600	1.8410	2.0000	1
232	3586	11	0	11	Q4	2012	10.5200	3.2612	4.0000	1
232	3956	14	0	9	Q3	2012	2.6300	1.1046	1.0000	1
232	3965	24	0	8	Q3	2012	7.8900	3.6294	3.0000	1
232	3976	17	0	1	Q1	2012	10.5200	4.9444	4.0000	1
232	4032	11	0	8	Q3	2012	7.8900	2.4459	3.0000	1
232	4417	3	0	9	Q3	2012	7.8900	3.2349	3.0000	1
232	4609	23	0	8	Q3	2012	7.8900	2.6826	3.0000	1
232	4725	7	0	9	Q3	2012	10.5200	3.6820	4.0000	1
232	4767	16	0	12	Q4	2012	5.2600	1.6832	2.0000	1
232	4925	16	0	6	Q2	2012	5.2600	1.6306	2.0000	1
232	5278	11	0	12	Q4	2012	7.8900	3.4716	3.0000	1
232	5379	17	1297	3	Q1	2012	5.2600	2.4722	2.0000	1
232	5650	2	114	4	Q2	2012	2.6300	1.1309	1.0000	1
232	5869	13	0	7	Q3	2012	10.5200	3.2612	4.0000	1
232	6047	17	0	10	Q4	2012	7.8900	2.9982	3.0000	1
232	6232	15	0	3	Q1	2012	5.2600	2.1040	2.0000	1
232	6313	17	0	11	Q4	2012	7.8900	3.0771	3.0000	1
232	6372	17	0	12	Q4	2012	5.2600	2.0514	2.0000	1
232	6559	3	0	1	Q1	2012	10.5200	4.2080	4.0000	1
232	6771	15	0	12	Q4	2012	5.2600	1.9462	2.0000	1
232	6792	13	0	4	Q2	2012	10.5200	3.6820	4.0000	1
232	6841	3	0	4	Q2	2012	7.8900	2.6037	3.0000	1
232	7352	7	0	1	Q1	2012	7.8900	2.3670	3.0000	1
232	7813	17	0	5	Q2	2012	7.8900	2.9982	3.0000	1
232	7829	24	0	9	Q3	2012	5.2600	2.2092	2.0000	1
232	7952	13	0	8	Q3	2012	7.8900	3.1560	3.0000	1
232	8140	13	0	8	Q3	2012	7.8900	3.9450	3.0000	1
232	8466	17	0	1	Q1	2012	7.8900	3.7083	3.0000	1
232	8511	16	1233	10	Q4	2012	5.2600	1.9988	2.0000	1
232	8578	23	1786	10	Q4	2012	7.8900	2.4459	3.0000	1
232	9263	16	0	2	Q1	2012	5.2600	2.1040	2.0000	1
232	9275	7	0	4	Q2	2012	7.8900	2.9193	3.0000	1
232	9447	13	0	12	Q4	2012	10.5200	4.5236	4.0000	1
232	9469	17	1304	7	Q3	2012	7.8900	3.0771	3.0000	1
232	9667	23	1765	1	Q1	2012	5.2600	2.5774	2.0000	1
232	9759	15	0	5	Q2	2012	7.8900	2.6826	3.0000	1
232	10131	17	0	1	Q1	2012	5.2600	2.5774	2.0000	1
233	328	11	0	3	Q1	2012	7.3800	2.4354	3.0000	1
233	328	11	0	4	Q2	2012	4.9200	1.7220	2.0000	1
233	429	7	519	9	Q3	2012	9.8400	4.8216	4.0000	1
233	619	13	0	3	Q1	2012	12.3000	4.5510	5.0000	1
233	852	15	0	10	Q4	2012	9.8400	4.2312	4.0000	1
233	937	6	521	10	Q4	2012	7.3800	3.3948	3.0000	1
233	1214	11	0	1	Q1	2012	4.9200	1.9188	2.0000	1
233	1317	24	0	4	Q2	2012	7.3800	3.0996	3.0000	1
233	1368	7	516	8	Q3	2012	9.8400	3.0504	4.0000	1
233	1607	17	1304	7	Q3	2012	7.3800	3.3948	3.0000	1
233	1720	16	0	8	Q3	2012	12.3000	4.0590	5.0000	1
233	1758	3	0	11	Q4	2012	7.3800	2.3616	3.0000	1
233	1957	13	980	3	Q1	2012	7.3800	2.2140	3.0000	1
233	2151	13	0	9	Q3	2012	9.8400	3.3456	4.0000	1
233	2422	13	0	6	Q2	2012	7.3800	2.4354	3.0000	1
233	2493	17	0	5	Q2	2012	7.3800	2.6568	3.0000	1
233	2705	24	0	9	Q3	2012	7.3800	3.3210	3.0000	1
233	3681	13	0	2	Q1	2012	4.9200	2.1156	2.0000	1
233	3816	3	0	11	Q4	2012	4.9200	1.8204	2.0000	1
233	3936	7	0	6	Q2	2012	9.8400	3.0504	4.0000	1
233	4099	17	0	5	Q2	2012	4.9200	2.0172	2.0000	1
233	4230	11	0	3	Q1	2012	9.8400	4.9200	4.0000	1
233	4257	3	0	3	Q1	2012	7.3800	3.4686	3.0000	1
233	4295	11	829	6	Q2	2012	4.9200	1.5252	2.0000	1
233	5162	22	0	1	Q1	2012	7.3800	3.3948	3.0000	1
233	5219	17	0	12	Q4	2012	4.9200	2.0664	2.0000	1
233	5442	7	504	2	Q1	2012	7.3800	3.5424	3.0000	1
233	5668	7	0	6	Q2	2012	9.8400	3.6408	4.0000	1
233	5790	17	0	12	Q4	2012	7.3800	2.5092	3.0000	1
233	6047	17	0	7	Q3	2012	12.3000	6.0270	5.0000	1
233	6288	13	0	7	Q3	2012	7.3800	2.6568	3.0000	1
233	6348	16	0	6	Q2	2012	9.8400	4.2312	4.0000	1
233	6559	3	0	1	Q1	2012	12.3000	4.3050	5.0000	1
233	6562	24	0	5	Q2	2012	9.8400	4.5264	4.0000	1
233	6566	6	521	10	Q4	2012	7.3800	2.4354	3.0000	1
233	6578	15	0	8	Q3	2012	9.8400	4.1328	4.0000	1
233	7065	17	0	3	Q1	2012	7.3800	3.6900	3.0000	1
233	7130	24	1858	7	Q3	2012	7.3800	3.6162	3.0000	1
233	7319	13	0	4	Q2	2012	7.3800	3.2472	3.0000	1
233	7363	6	0	1	Q1	2012	7.3800	2.8044	3.0000	1
233	7486	3	0	4	Q2	2012	7.3800	2.2878	3.0000	1
233	7502	16	1216	2	Q1	2012	9.8400	3.5424	4.0000	1
233	7580	17	0	5	Q2	2012	9.8400	4.6248	4.0000	1
233	7639	13	0	9	Q3	2012	7.3800	2.7306	3.0000	1
233	7781	15	1134	1	Q1	2012	9.8400	3.3456	4.0000	1
233	7884	11	826	5	Q2	2012	9.8400	3.0504	4.0000	1
233	8041	24	1859	8	Q3	2012	4.9200	1.5744	2.0000	1
233	8276	15	0	11	Q4	2012	7.3800	3.0996	3.0000	1
233	8482	11	842	12	Q4	2012	7.3800	3.0996	3.0000	1
233	8744	11	841	12	Q4	2012	4.9200	1.5744	2.0000	1
233	8841	13	0	6	Q2	2012	7.3800	2.8044	3.0000	1
233	8898	11	841	12	Q4	2012	7.3800	3.2472	3.0000	1
233	8947	3	0	9	Q3	2012	7.3800	2.5092	3.0000	1
233	9240	24	0	12	Q4	2012	9.8400	3.9360	4.0000	1
233	9296	2	129	11	Q4	2012	2.4600	1.1316	1.0000	1
233	9396	13	0	6	Q2	2012	7.3800	3.4686	3.0000	1
233	9510	16	0	5	Q2	2012	7.3800	3.2472	3.0000	1
233	9972	13	0	3	Q1	2012	7.3800	3.6900	3.0000	1
234	328	11	0	3	Q1	2012	8.1000	3.4020	3.0000	1
234	565	15	0	6	Q2	2012	10.8000	3.3480	4.0000	1
234	672	24	1860	8	Q3	2012	5.4000	1.6740	2.0000	1
234	1133	6	524	11	Q4	2012	10.8000	3.3480	4.0000	1
234	1137	6	0	4	Q2	2012	10.8000	3.4560	4.0000	1
234	1167	6	0	5	Q2	2012	8.1000	3.8880	3.0000	1
234	1167	7	0	10	Q4	2012	8.1000	3.8880	3.0000	1
234	1574	6	0	9	Q3	2012	5.4000	2.6460	2.0000	1
234	1800	11	0	7	Q3	2012	10.8000	3.9960	4.0000	1
234	1896	22	0	7	Q3	2012	2.7000	1.2690	1.0000	1
234	1934	2	0	10	Q4	2012	5.4000	1.6200	2.0000	1
234	1994	15	1136	2	Q1	2012	8.1000	3.1590	3.0000	1
234	2052	13	982	4	Q2	2012	8.1000	3.2400	3.0000	1
234	2171	23	0	11	Q4	2012	5.4000	1.9440	2.0000	1
234	2734	6	519	9	Q3	2012	10.8000	4.8600	4.0000	1
234	2890	6	0	10	Q4	2012	5.4000	1.7280	2.0000	1
234	3012	24	0	7	Q3	2012	10.8000	3.5640	4.0000	1
234	3046	13	986	6	Q2	2012	5.4000	1.6740	2.0000	1
234	3239	17	0	2	Q1	2012	10.8000	5.4000	4.0000	1
234	3490	13	0	7	Q3	2012	8.1000	3.2400	3.0000	1
234	3878	3	0	10	Q4	2012	5.4000	2.6460	2.0000	1
234	3889	3	0	3	Q1	2012	10.8000	4.5360	4.0000	1
234	4110	15	0	9	Q3	2012	5.4000	1.7820	2.0000	1
234	4165	3	0	2	Q1	2012	10.8000	3.4560	4.0000	1
234	4407	7	516	8	Q3	2012	5.4000	2.2140	2.0000	1
234	4445	17	0	12	Q4	2012	5.4000	1.7820	2.0000	1
234	4445	17	1303	6	Q2	2012	8.1000	3.5640	3.0000	1
234	4692	15	0	5	Q2	2012	8.1000	3.2400	3.0000	1
234	4728	7	501	1	Q1	2012	8.1000	3.2400	3.0000	1
234	4875	13	0	3	Q1	2012	8.1000	3.3210	3.0000	1
234	5060	13	0	1	Q1	2012	8.1000	2.8350	3.0000	1
234	5125	17	0	12	Q4	2012	5.4000	1.6740	2.0000	1
234	5144	7	0	11	Q4	2012	10.8000	3.6720	4.0000	1
234	5196	13	0	4	Q2	2012	8.1000	3.1590	3.0000	1
234	5461	22	0	7	Q3	2012	2.7000	0.8100	1.0000	1
234	5631	24	0	12	Q4	2012	8.1000	3.0780	3.0000	1
234	5944	3	201	8	Q3	2012	8.1000	2.6730	3.0000	1
234	6136	6	0	7	Q3	2012	8.1000	4.0500	3.0000	1
234	6266	15	0	8	Q3	2012	10.8000	5.2920	4.0000	1
234	6496	3	210	12	Q4	2012	5.4000	2.1600	2.0000	1
234	6617	6	521	10	Q4	2012	10.8000	5.4000	4.0000	1
234	6667	24	0	11	Q4	2012	8.1000	2.9160	3.0000	1
234	6708	24	0	3	Q1	2012	8.1000	2.8350	3.0000	1
234	7234	16	0	4	Q2	2012	5.4000	1.8360	2.0000	1
234	7653	6	519	9	Q3	2012	10.8000	4.3200	4.0000	1
234	7674	7	0	10	Q4	2012	10.8000	3.8880	4.0000	1
234	7702	16	0	9	Q3	2012	8.1000	2.8350	3.0000	1
234	7818	11	0	3	Q1	2012	8.1000	2.8350	3.0000	1
234	7858	15	0	8	Q3	2012	5.4000	1.8360	2.0000	1
234	8314	15	0	11	Q4	2012	8.1000	3.8070	3.0000	1
234	8414	17	0	9	Q3	2012	10.8000	5.2920	4.0000	1
234	8793	6	504	2	Q1	2012	8.1000	3.7260	3.0000	1
234	9338	7	0	11	Q4	2012	8.1000	3.4830	3.0000	1
234	9338	7	518	8	Q3	2012	5.4000	2.5380	2.0000	1
234	9826	13	0	2	Q1	2012	5.4000	2.6460	2.0000	1
234	10131	17	0	8	Q3	2012	5.4000	2.6460	2.0000	1
234	10243	17	0	9	Q3	2012	8.1000	3.8070	3.0000	1
235	170	7	0	7	Q3	2012	10.6500	4.6860	3.0000	1
235	372	2	126	10	Q4	2012	3.5500	1.3135	1.0000	1
235	465	13	0	12	Q4	2012	10.6500	4.6860	3.0000	1
235	647	3	0	11	Q4	2012	10.6500	3.8340	3.0000	1
235	650	11	0	10	Q4	2012	7.1000	3.5500	2.0000	1
235	892	7	505	2	Q1	2012	14.2000	4.9700	4.0000	1
235	1202	11	0	7	Q3	2012	10.6500	3.7275	3.0000	1
235	1209	24	0	10	Q4	2012	7.1000	3.5500	2.0000	1
235	1841	15	0	12	Q4	2012	14.2000	4.8280	4.0000	1
235	1999	11	820	2	Q1	2012	14.2000	5.1120	4.0000	1
235	2078	24	0	5	Q2	2012	7.1000	2.3430	2.0000	1
235	2397	11	0	3	Q1	2012	14.2000	6.2480	4.0000	1
235	2614	13	0	3	Q1	2012	7.1000	2.1300	2.0000	1
235	3117	2	0	11	Q4	2012	3.5500	1.7395	1.0000	1
235	3197	23	0	3	Q1	2012	7.1000	2.1300	2.0000	1
235	3199	24	0	8	Q3	2012	14.2000	5.1120	4.0000	1
235	3239	17	1312	10	Q4	2012	14.2000	7.1000	4.0000	1
235	3401	11	0	7	Q3	2012	14.2000	5.3960	4.0000	1
235	3401	11	826	5	Q2	2012	7.1000	2.6980	2.0000	1
235	3538	11	0	7	Q3	2012	10.6500	4.6860	3.0000	1
235	3599	13	0	5	Q2	2012	10.6500	4.2600	3.0000	1
235	3838	17	0	12	Q4	2012	10.6500	3.3015	3.0000	1
235	3847	11	0	10	Q4	2012	7.1000	2.5560	2.0000	1
235	4039	24	0	4	Q2	2012	10.6500	5.0055	3.0000	1
235	4664	6	0	5	Q2	2012	10.6500	4.1535	3.0000	1
235	4943	24	0	1	Q1	2012	7.1000	3.4080	2.0000	1
235	5597	3	0	4	Q2	2012	10.6500	4.5795	3.0000	1
235	5686	3	207	11	Q4	2012	10.6500	4.6860	3.0000	1
235	6559	3	0	10	Q4	2012	10.6500	3.5145	3.0000	1
235	6559	3	188	2	Q1	2012	10.6500	4.2600	3.0000	1
235	6799	17	1314	11	Q4	2012	10.6500	4.0470	3.0000	1
235	7393	24	0	7	Q3	2012	7.1000	3.3370	2.0000	1
235	7775	7	0	4	Q2	2012	14.2000	6.9580	4.0000	1
235	7806	13	0	5	Q2	2012	10.6500	3.4080	3.0000	1
235	7831	17	0	8	Q3	2012	14.2000	6.6740	4.0000	1
235	8899	7	0	12	Q4	2012	7.1000	2.5560	2.0000	1
235	9063	23	0	2	Q1	2012	10.6500	4.2600	3.0000	1
235	9405	6	518	8	Q3	2012	7.1000	2.2720	2.0000	1
235	9556	15	0	3	Q1	2012	10.6500	4.2600	3.0000	1
235	9760	13	980	3	Q1	2012	10.6500	3.6210	3.0000	1
235	9873	15	0	11	Q4	2012	14.2000	6.9580	4.0000	1
236	635	15	0	2	Q1	2012	5.4300	2.6064	3.0000	1
236	673	11	0	11	Q4	2012	7.2400	3.1856	4.0000	1
236	922	7	0	7	Q3	2012	5.4300	1.9548	3.0000	1
236	1090	6	524	11	Q4	2012	5.4300	2.2263	3.0000	1
236	1192	17	0	8	Q3	2012	7.2400	3.4752	4.0000	1
236	1361	24	0	7	Q3	2012	3.6200	1.8100	2.0000	1
236	1785	3	0	2	Q1	2012	7.2400	2.5340	4.0000	1
236	1954	13	0	7	Q3	2012	7.2400	3.2580	4.0000	1
236	2019	16	1235	11	Q4	2012	7.2400	2.3168	4.0000	1
236	2095	22	0	6	Q2	2012	1.8100	0.7421	1.0000	1
236	2204	3	0	1	Q1	2012	5.4300	1.9548	3.0000	1
236	2340	2	120	7	Q3	2012	3.6200	1.3756	2.0000	1
236	3207	15	0	3	Q1	2012	3.6200	1.3756	2.0000	1
236	3245	17	0	7	Q3	2012	7.2400	2.8960	4.0000	1
236	4161	7	504	2	Q1	2012	5.4300	2.2806	3.0000	1
236	4460	3	0	5	Q2	2012	3.6200	1.5204	2.0000	1
236	4962	11	0	3	Q1	2012	5.4300	2.2806	3.0000	1
236	5230	13	984	5	Q2	2012	3.6200	1.1584	2.0000	1
236	5358	3	0	3	Q1	2012	3.6200	1.1584	2.0000	1
236	5802	6	0	1	Q1	2012	5.4300	1.6833	3.0000	1
236	5903	13	0	12	Q4	2012	5.4300	2.3892	3.0000	1
236	6109	14	0	2	Q1	2012	1.8100	0.8145	1.0000	1
236	6799	17	0	3	Q1	2012	5.4300	2.2806	3.0000	1
236	7478	6	0	9	Q3	2012	5.4300	2.1720	3.0000	1
236	7514	17	0	1	Q1	2012	7.2400	2.8960	4.0000	1
236	7571	6	0	12	Q4	2012	5.4300	2.2806	3.0000	1
236	7571	7	0	9	Q3	2012	7.2400	3.2580	4.0000	1
236	7576	13	0	1	Q1	2012	3.6200	1.3756	2.0000	1
236	8452	16	0	10	Q4	2012	9.0500	3.5295	5.0000	1
236	8921	13	0	12	Q4	2012	5.4300	2.4978	3.0000	1
236	8966	3	0	4	Q2	2012	5.4300	1.7919	3.0000	1
236	9045	24	0	1	Q1	2012	5.4300	2.4435	3.0000	1
236	9223	24	1866	11	Q4	2012	5.4300	1.6290	3.0000	1
236	9564	17	0	11	Q4	2012	5.4300	2.5521	3.0000	1
236	9748	24	0	3	Q1	2012	5.4300	2.1720	3.0000	1
236	9883	7	501	1	Q1	2012	5.4300	2.1720	3.0000	1
237	160	15	0	3	Q1	2012	10.7200	4.3952	4.0000	1
237	430	16	1225	7	Q3	2012	8.0400	2.4120	3.0000	1
237	440	15	0	6	Q2	2012	8.0400	3.6180	3.0000	1
237	1044	24	1860	8	Q3	2012	5.3600	2.0368	2.0000	1
237	1055	15	0	12	Q4	2012	8.0400	2.4120	3.0000	1
237	1337	17	0	11	Q4	2012	10.7200	3.8592	4.0000	1
237	2241	6	0	10	Q4	2012	5.3600	1.8224	2.0000	1
237	2437	3	0	11	Q4	2012	8.0400	3.2964	3.0000	1
237	2846	11	0	7	Q3	2012	8.0400	2.4924	3.0000	1
237	2870	7	0	9	Q3	2012	5.3600	2.1976	2.0000	1
237	3305	13	0	7	Q3	2012	8.0400	3.2160	3.0000	1
237	3664	22	0	6	Q2	2012	2.6800	1.0720	1.0000	1
237	4006	6	0	7	Q3	2012	10.7200	4.8240	4.0000	1
237	4085	24	0	11	Q4	2012	8.0400	2.8140	3.0000	1
237	4431	13	0	6	Q2	2012	10.7200	3.5376	4.0000	1
237	4828	7	0	11	Q4	2012	13.4000	5.0920	5.0000	1
237	4846	17	0	1	Q1	2012	8.0400	3.0552	3.0000	1
237	4988	2	126	10	Q4	2012	2.6800	1.3132	1.0000	1
237	5015	2	121	8	Q3	2012	5.3600	1.7152	2.0000	1
237	5183	6	508	4	Q2	2012	8.0400	3.1356	3.0000	1
237	5658	11	0	8	Q3	2012	8.0400	2.6532	3.0000	1
237	6203	11	0	8	Q3	2012	8.0400	3.7788	3.0000	1
237	6351	11	824	4	Q2	2012	8.0400	3.6984	3.0000	1
237	6683	17	0	8	Q3	2012	10.7200	4.0736	4.0000	1
237	7141	17	0	12	Q4	2012	8.0400	2.5728	3.0000	1
237	7250	13	0	8	Q3	2012	10.7200	5.0384	4.0000	1
237	7525	2	0	9	Q3	2012	5.3600	2.4120	2.0000	1
237	7532	24	0	11	Q4	2012	8.0400	2.9748	3.0000	1
237	7576	13	984	5	Q2	2012	5.3600	2.0368	2.0000	1
237	8098	13	0	2	Q1	2012	8.0400	3.1356	3.0000	1
237	8189	17	0	1	Q1	2012	8.0400	3.3768	3.0000	1
237	8281	17	0	9	Q3	2012	8.0400	2.9748	3.0000	1
237	8551	17	0	7	Q3	2012	10.7200	5.3600	4.0000	1
237	8758	7	504	2	Q1	2012	8.0400	3.7788	3.0000	1
237	8769	23	0	3	Q1	2012	8.0400	3.2160	3.0000	1
237	8898	11	0	11	Q4	2012	10.7200	3.9664	4.0000	1
237	9308	11	0	4	Q2	2012	10.7200	4.6096	4.0000	1
237	9531	15	0	10	Q4	2012	8.0400	3.2964	3.0000	1
237	9536	24	0	7	Q3	2012	8.0400	2.4120	3.0000	1
237	9631	16	1216	2	Q1	2012	8.0400	3.9396	3.0000	1
238	169	13	0	4	Q2	2012	5.9100	2.7777	3.0000	1
238	346	13	0	12	Q4	2012	5.9100	2.3640	3.0000	1
238	378	16	1233	10	Q4	2012	5.9100	2.8368	3.0000	1
238	408	7	0	1	Q1	2012	7.8800	2.6004	4.0000	1
238	941	13	0	5	Q2	2012	5.9100	2.1867	3.0000	1
238	1275	24	0	1	Q1	2012	7.8800	3.7824	4.0000	1
238	1276	24	0	3	Q1	2012	5.9100	1.9503	3.0000	1
238	1648	11	0	2	Q1	2012	3.9400	1.8124	2.0000	1
238	1977	23	0	6	Q2	2012	7.8800	3.6248	4.0000	1
238	2032	23	1771	3	Q1	2012	5.9100	2.0685	3.0000	1
238	2908	11	821	2	Q1	2012	7.8800	3.7036	4.0000	1
238	2929	24	1856	6	Q2	2012	3.9400	1.4578	2.0000	1
238	3115	6	0	8	Q3	2012	5.9100	2.1276	3.0000	1
238	3589	13	0	1	Q1	2012	7.8800	3.0732	4.0000	1
238	3632	6	526	12	Q4	2012	5.9100	1.9503	3.0000	1
238	3676	3	0	10	Q4	2012	3.9400	1.7336	2.0000	1
238	4110	15	0	9	Q3	2012	5.9100	2.7777	3.0000	1
238	4117	2	0	11	Q4	2012	1.9700	0.6895	1.0000	1
238	4162	7	0	3	Q1	2012	5.9100	2.1867	3.0000	1
238	4341	11	0	12	Q4	2012	3.9400	1.2608	2.0000	1
238	4397	16	0	5	Q2	2012	3.9400	1.1820	2.0000	1
238	4445	17	1303	6	Q2	2012	5.9100	2.7777	3.0000	1
238	4597	17	1311	10	Q4	2012	5.9100	2.3049	3.0000	1
238	4873	17	0	8	Q3	2012	5.9100	2.6595	3.0000	1
238	4954	11	0	3	Q1	2012	9.8500	3.3490	5.0000	1
238	5183	7	0	3	Q1	2012	5.9100	2.6004	3.0000	1
238	5611	24	0	1	Q1	2012	7.8800	2.8368	4.0000	1
238	6348	16	0	8	Q3	2012	7.8800	2.6004	4.0000	1
238	6559	3	0	3	Q1	2012	9.8500	3.1520	5.0000	1
238	6564	13	0	4	Q2	2012	5.9100	1.8321	3.0000	1
238	6712	16	0	5	Q2	2012	7.8800	3.7036	4.0000	1
238	6832	3	210	12	Q4	2012	5.9100	2.3640	3.0000	1
238	7001	3	0	3	Q1	2012	3.9400	1.7336	2.0000	1
238	7343	7	505	2	Q1	2012	3.9400	1.2608	2.0000	1
238	7601	24	0	4	Q2	2012	5.9100	2.9550	3.0000	1
238	7896	23	0	12	Q4	2012	3.9400	1.7730	2.0000	1
238	8414	17	0	9	Q3	2012	5.9100	1.8912	3.0000	1
238	8673	11	0	12	Q4	2012	5.9100	2.4822	3.0000	1
238	8731	3	0	4	Q2	2012	5.9100	2.0685	3.0000	1
238	8921	13	1000	12	Q4	2012	9.8500	3.3490	5.0000	1
238	9236	13	0	5	Q2	2012	7.8800	3.9400	4.0000	1
238	9348	15	0	11	Q4	2012	7.8800	2.9156	4.0000	1
238	9357	6	0	1	Q1	2012	5.9100	1.8321	3.0000	1
238	9417	15	0	10	Q4	2012	7.8800	3.7824	4.0000	1
238	9487	17	0	4	Q2	2012	3.9400	1.9700	2.0000	1
238	9639	17	0	4	Q2	2012	5.9100	2.3640	3.0000	1
238	9972	13	988	7	Q3	2012	5.9100	2.7777	3.0000	1
238	10035	15	0	2	Q1	2012	5.9100	2.9550	3.0000	1
239	208	13	0	9	Q3	2012	8.8400	3.3592	4.0000	1
239	404	6	0	3	Q1	2012	4.4200	2.0774	2.0000	1
239	663	16	0	11	Q4	2012	4.4200	2.1216	2.0000	1
239	1821	13	0	12	Q4	2012	6.6300	3.1824	3.0000	1
239	2204	3	0	2	Q1	2012	6.6300	2.4531	3.0000	1
239	2471	15	0	12	Q4	2012	6.6300	2.5857	3.0000	1
239	2673	11	0	1	Q1	2012	6.6300	2.5857	3.0000	1
239	2769	16	0	4	Q2	2012	8.8400	4.3316	4.0000	1
239	2784	15	0	2	Q1	2012	6.6300	3.3150	3.0000	1
239	3112	22	0	3	Q1	2012	4.4200	1.4586	2.0000	1
239	3423	13	0	10	Q4	2012	4.4200	1.6796	2.0000	1
239	3819	23	0	12	Q4	2012	4.4200	1.6354	2.0000	1
239	4094	16	1225	7	Q3	2012	11.0500	5.3040	5.0000	1
239	4249	11	829	6	Q2	2012	6.6300	2.4531	3.0000	1
239	4445	17	0	12	Q4	2012	6.6300	3.1161	3.0000	1
239	4585	6	0	12	Q4	2012	8.8400	4.0664	4.0000	1
239	4767	16	0	8	Q3	2012	8.8400	3.3592	4.0000	1
239	5256	17	0	12	Q4	2012	6.6300	2.6520	3.0000	1
239	5580	7	0	8	Q3	2012	8.8400	4.1548	4.0000	1
239	5944	3	0	8	Q3	2012	6.6300	2.1879	3.0000	1
239	6180	13	0	7	Q3	2012	4.4200	2.1216	2.0000	1
239	6347	17	0	2	Q1	2012	6.6300	2.5194	3.0000	1
239	6736	17	0	4	Q2	2012	6.6300	3.2487	3.0000	1
239	6758	11	821	2	Q1	2012	11.0500	4.6410	5.0000	1
239	7056	3	0	8	Q3	2012	4.4200	1.6354	2.0000	1
239	7075	15	0	1	Q1	2012	8.8400	3.1824	4.0000	1
239	7109	11	0	7	Q3	2012	4.4200	1.6796	2.0000	1
239	7327	15	0	11	Q4	2012	8.8400	3.3592	4.0000	1
239	7573	3	0	9	Q3	2012	6.6300	2.5194	3.0000	1
239	7743	3	0	10	Q4	2012	6.6300	2.9835	3.0000	1
239	7826	24	0	3	Q1	2012	4.4200	1.8122	2.0000	1
239	7849	3	0	11	Q4	2012	4.4200	1.8122	2.0000	1
239	7896	23	0	12	Q4	2012	4.4200	1.5028	2.0000	1
239	8068	3	0	8	Q3	2012	8.8400	2.7404	4.0000	1
239	9671	13	0	1	Q1	2012	4.4200	1.3702	2.0000	1
239	9951	3	0	5	Q2	2012	8.8400	3.8896	4.0000	1
239	10018	24	0	3	Q1	2012	4.4200	1.5912	2.0000	1
239	10222	6	524	11	Q4	2012	6.6300	2.7183	3.0000	1
239	10240	3	187	2	Q1	2012	6.6300	2.7846	3.0000	1
240	551	7	0	4	Q2	2012	2.5800	1.2900	3.0000	1
240	795	14	1078	12	Q4	2012	1.7200	0.8256	2.0000	1
240	878	3	0	1	Q1	2012	2.5800	1.1868	3.0000	1
240	1138	6	0	4	Q2	2012	2.5800	0.7998	3.0000	1
240	1718	13	0	1	Q1	2012	3.4400	1.6856	4.0000	1
240	2019	16	1225	7	Q3	2012	2.5800	1.2642	3.0000	1
240	2032	23	0	1	Q1	2012	2.5800	0.8256	3.0000	1
240	2270	11	0	11	Q4	2012	2.5800	1.2642	3.0000	1
240	2376	11	0	11	Q4	2012	2.5800	0.8772	3.0000	1
240	2869	7	0	12	Q4	2012	3.4400	1.5824	4.0000	1
240	3030	14	0	11	Q4	2012	1.7200	0.7912	2.0000	1
240	3360	13	0	7	Q3	2012	2.5800	1.0320	3.0000	1
240	3413	15	0	9	Q3	2012	3.4400	1.2384	4.0000	1
240	3453	14	0	3	Q1	2012	0.8600	0.3526	1.0000	1
240	3655	7	0	6	Q2	2012	1.7200	0.8084	2.0000	1
240	3748	13	0	8	Q3	2012	4.3000	1.7630	5.0000	1
240	4094	16	0	6	Q2	2012	2.5800	0.7998	3.0000	1
240	4122	15	0	12	Q4	2012	3.4400	1.2728	4.0000	1
240	4341	11	0	5	Q2	2012	2.5800	1.0836	3.0000	1
240	4858	17	0	3	Q1	2012	2.5800	0.9804	3.0000	1
240	5023	6	513	6	Q2	2012	2.5800	0.8514	3.0000	1
240	5537	3	0	2	Q1	2012	1.7200	0.5504	2.0000	1
240	5616	17	0	11	Q4	2012	2.5800	0.7740	3.0000	1
240	5720	2	0	4	Q2	2012	0.8600	0.3096	1.0000	1
240	6162	17	0	7	Q3	2012	1.7200	0.7224	2.0000	1
240	6168	17	0	10	Q4	2012	3.4400	1.1696	4.0000	1
240	6423	17	1307	8	Q3	2012	2.5800	1.0062	3.0000	1
240	7215	11	842	12	Q4	2012	2.5800	1.0578	3.0000	1
240	7416	13	988	7	Q3	2012	1.7200	0.6192	2.0000	1
240	7683	22	1708	11	Q4	2012	1.7200	0.6536	2.0000	1
240	7714	7	504	2	Q1	2012	2.5800	1.1352	3.0000	1
240	7852	11	0	5	Q2	2012	1.7200	0.5504	2.0000	1
240	7865	22	1694	4	Q2	2012	0.8600	0.3440	1.0000	1
240	7962	14	0	1	Q1	2012	1.7200	0.8428	2.0000	1
240	8394	7	0	5	Q2	2012	2.5800	0.9804	3.0000	1
240	8666	24	1858	7	Q3	2012	2.5800	1.1352	3.0000	1
240	10195	7	523	11	Q4	2012	1.7200	0.7740	2.0000	1
240	10222	7	0	8	Q3	2012	3.4400	1.3760	4.0000	1
241	311	7	0	1	Q1	2012	5.8200	1.9206	2.0000	1
241	392	13	0	6	Q2	2012	8.7300	3.4047	3.0000	1
241	392	13	0	11	Q4	2012	8.7300	3.6666	3.0000	1
241	706	6	0	6	Q2	2012	8.7300	4.1904	3.0000	1
241	863	17	0	12	Q4	2012	11.6400	4.4232	4.0000	1
241	863	17	1303	6	Q2	2012	11.6400	4.1904	4.0000	1
241	887	14	0	6	Q2	2012	5.8200	1.9206	2.0000	1
241	958	24	0	12	Q4	2012	11.6400	4.4232	4.0000	1
241	1193	13	0	3	Q1	2012	5.8200	1.9206	2.0000	1
241	1244	11	0	7	Q3	2012	5.8200	2.1534	2.0000	1
241	1330	13	0	12	Q4	2012	5.8200	1.8624	2.0000	1
241	1499	13	0	12	Q4	2012	8.7300	4.1031	3.0000	1
241	1626	13	0	5	Q2	2012	11.6400	3.7248	4.0000	1
241	1791	13	0	3	Q1	2012	8.7300	2.7936	3.0000	1
241	1802	23	0	8	Q3	2012	8.7300	3.1428	3.0000	1
241	1813	17	0	11	Q4	2012	11.6400	5.5872	4.0000	1
241	1987	13	0	4	Q2	2012	8.7300	2.7063	3.0000	1
241	2769	16	0	11	Q4	2012	8.7300	2.7936	3.0000	1
241	3149	11	829	6	Q2	2012	8.7300	3.3174	3.0000	1
241	3271	13	980	3	Q1	2012	8.7300	3.2301	3.0000	1
241	4117	2	129	11	Q4	2012	2.9100	1.4259	1.0000	1
241	4194	24	0	3	Q1	2012	5.8200	2.5026	2.0000	1
241	4397	16	0	7	Q3	2012	8.7300	2.9682	3.0000	1
241	4431	13	976	1	Q1	2012	11.6400	4.1904	4.0000	1
241	4528	15	0	3	Q1	2012	5.8200	1.9206	2.0000	1
241	4528	15	0	11	Q4	2012	11.6400	3.7248	4.0000	1
241	4606	3	0	8	Q3	2012	8.7300	3.2301	3.0000	1
241	5162	22	0	3	Q1	2012	8.7300	4.1904	3.0000	1
241	5173	15	1138	3	Q1	2012	8.7300	3.0555	3.0000	1
241	5174	16	0	1	Q1	2012	8.7300	3.4047	3.0000	1
241	5476	13	0	12	Q4	2012	8.7300	4.1031	3.0000	1
241	5568	23	0	2	Q1	2012	5.8200	2.2116	2.0000	1
241	6256	7	0	12	Q4	2012	8.7300	4.1904	3.0000	1
241	6288	13	984	5	Q2	2012	11.6400	4.8888	4.0000	1
241	6350	13	0	11	Q4	2012	11.6400	5.2380	4.0000	1
241	6468	2	0	3	Q1	2012	8.7300	3.0555	3.0000	1
241	6759	22	0	8	Q3	2012	2.9100	1.4259	1.0000	1
241	7526	17	0	4	Q2	2012	8.7300	3.2301	3.0000	1
241	7589	17	0	5	Q2	2012	8.7300	3.2301	3.0000	1
241	7626	6	0	9	Q3	2012	8.7300	3.8412	3.0000	1
241	8477	3	187	2	Q1	2012	5.8200	2.5608	2.0000	1
241	8549	7	0	12	Q4	2012	8.7300	3.4920	3.0000	1
241	8976	13	0	2	Q1	2012	5.8200	1.9788	2.0000	1
241	9504	13	0	8	Q3	2012	8.7300	3.9285	3.0000	1
241	9557	3	0	4	Q2	2012	8.7300	3.5793	3.0000	1
242	17	7	516	8	Q3	2012	10.3600	4.5584	4.0000	1
242	137	7	0	9	Q3	2012	5.1800	2.2274	2.0000	1
242	591	11	0	10	Q4	2012	5.1800	1.8130	2.0000	1
242	614	17	0	12	Q4	2012	10.3600	3.8332	4.0000	1
242	1192	17	0	7	Q3	2012	7.7700	3.2634	3.0000	1
242	1330	13	0	7	Q3	2012	7.7700	2.4864	3.0000	1
242	1339	13	0	5	Q2	2012	5.1800	1.6576	2.0000	1
242	1379	7	0	10	Q4	2012	10.3600	3.2116	4.0000	1
242	1850	16	0	1	Q1	2012	7.7700	3.4965	3.0000	1
242	1965	17	0	12	Q4	2012	7.7700	3.5742	3.0000	1
242	1977	23	1771	3	Q1	2012	7.7700	2.7972	3.0000	1
242	2078	24	0	9	Q3	2012	5.1800	2.0202	2.0000	1
242	2210	13	0	7	Q3	2012	7.7700	3.1080	3.0000	1
242	2438	7	523	11	Q4	2012	7.7700	3.7296	3.0000	1
242	2681	7	0	12	Q4	2012	7.7700	3.8073	3.0000	1
242	3020	13	984	5	Q2	2012	7.7700	3.1857	3.0000	1
242	3124	3	0	6	Q2	2012	5.1800	2.1238	2.0000	1
242	3202	11	829	6	Q2	2012	7.7700	3.0303	3.0000	1
242	3302	13	0	5	Q2	2012	10.3600	4.1440	4.0000	1
242	3334	17	0	5	Q2	2012	7.7700	3.7296	3.0000	1
242	3352	7	504	2	Q1	2012	7.7700	2.9526	3.0000	1
242	3470	17	0	9	Q3	2012	10.3600	3.8332	4.0000	1
242	3586	11	0	11	Q4	2012	12.9500	4.5325	5.0000	1
242	3892	11	841	12	Q4	2012	10.3600	3.1080	4.0000	1
242	3976	17	0	10	Q4	2012	7.7700	2.4087	3.0000	1
242	4021	16	0	1	Q1	2012	10.3600	3.7296	4.0000	1
242	4204	17	0	11	Q4	2012	12.9500	5.6980	5.0000	1
242	4460	3	0	12	Q4	2012	7.7700	2.5641	3.0000	1
242	5278	11	0	7	Q3	2012	5.1800	2.4864	2.0000	1
242	5503	7	0	6	Q2	2012	7.7700	3.4965	3.0000	1
242	5508	6	0	6	Q2	2012	10.3600	4.1440	4.0000	1
242	6132	3	0	6	Q2	2012	7.7700	2.5641	3.0000	1
242	6299	7	0	3	Q1	2012	10.3600	3.3152	4.0000	1
242	6575	11	0	4	Q2	2012	7.7700	2.4087	3.0000	1
242	6844	11	0	2	Q1	2012	7.7700	2.4087	3.0000	1
242	6922	7	521	10	Q4	2012	7.7700	3.8073	3.0000	1
242	6932	13	0	12	Q4	2012	5.1800	1.6058	2.0000	1
242	7287	24	0	2	Q1	2012	7.7700	3.2634	3.0000	1
242	7305	24	1869	12	Q4	2012	7.7700	3.0303	3.0000	1
242	7570	13	0	11	Q4	2012	7.7700	3.2634	3.0000	1
242	7572	15	0	11	Q4	2012	7.7700	3.8850	3.0000	1
242	7720	17	0	12	Q4	2012	7.7700	3.0303	3.0000	1
242	7920	17	0	2	Q1	2012	7.7700	3.1857	3.0000	1
242	8175	15	0	6	Q2	2012	10.3600	4.9728	4.0000	1
242	8390	24	0	10	Q4	2012	7.7700	2.9526	3.0000	1
242	8578	23	0	9	Q3	2012	7.7700	3.4965	3.0000	1
242	9170	6	0	10	Q4	2012	7.7700	2.8749	3.0000	1
242	10250	17	0	12	Q4	2012	7.7700	3.6519	3.0000	1
243	79	17	0	1	Q1	2012	6.3300	2.5320	3.0000	1
243	302	15	0	3	Q1	2012	6.3300	2.6586	3.0000	1
243	335	17	0	9	Q3	2012	6.3300	2.4687	3.0000	1
243	346	13	0	5	Q2	2012	6.3300	2.5320	3.0000	1
243	477	15	0	2	Q1	2012	6.3300	2.2155	3.0000	1
243	645	11	837	10	Q4	2012	4.2200	1.7724	2.0000	1
243	766	15	0	12	Q4	2012	4.2200	1.6458	2.0000	1
243	1003	17	0	9	Q3	2012	8.4400	3.0384	4.0000	1
243	1266	13	0	7	Q3	2012	8.4400	3.7136	4.0000	1
243	1491	16	0	1	Q1	2012	8.4400	3.3760	4.0000	1
243	1916	13	0	1	Q1	2012	6.3300	2.0256	3.0000	1
243	1996	13	0	7	Q3	2012	8.4400	2.5320	4.0000	1
243	2441	17	0	9	Q3	2012	6.3300	2.6586	3.0000	1
243	2508	2	0	1	Q1	2012	2.1100	0.7385	1.0000	1
243	2648	24	0	12	Q4	2012	6.3300	3.0384	3.0000	1
243	3215	15	1143	5	Q2	2012	8.4400	3.1228	4.0000	1
243	3249	11	833	8	Q3	2012	8.4400	3.2916	4.0000	1
243	3305	13	0	10	Q4	2012	8.4400	4.2200	4.0000	1
243	3567	16	0	5	Q2	2012	8.4400	3.7136	4.0000	1
243	3652	7	526	12	Q4	2012	8.4400	3.7136	4.0000	1
243	3728	13	0	7	Q3	2012	8.4400	3.3760	4.0000	1
243	3755	24	0	5	Q2	2012	6.3300	2.2155	3.0000	1
243	4096	3	0	12	Q4	2012	4.2200	1.3926	2.0000	1
243	5005	14	0	1	Q1	2012	4.2200	1.3926	2.0000	1
243	5096	7	0	11	Q4	2012	6.3300	2.3421	3.0000	1
243	5134	3	0	7	Q3	2012	8.4400	3.8824	4.0000	1
243	5305	11	842	12	Q4	2012	6.3300	3.1650	3.0000	1
243	5537	3	201	8	Q3	2012	8.4400	2.8696	4.0000	1
243	5954	6	504	2	Q1	2012	4.2200	1.6036	2.0000	1
243	5973	3	0	10	Q4	2012	6.3300	2.0889	3.0000	1
243	6420	14	1070	8	Q3	2012	2.1100	0.7596	1.0000	1
243	6712	16	0	9	Q3	2012	6.3300	1.9623	3.0000	1
243	6754	7	0	11	Q4	2012	6.3300	2.4687	3.0000	1
243	6851	6	0	6	Q2	2012	4.2200	1.3926	2.0000	1
243	6857	7	0	1	Q1	2012	8.4400	2.8696	4.0000	1
243	7190	23	0	7	Q3	2012	8.4400	3.1228	4.0000	1
243	7275	17	0	3	Q1	2012	6.3300	2.0256	3.0000	1
243	7416	13	0	1	Q1	2012	10.5500	5.0640	5.0000	1
243	7896	23	0	9	Q3	2012	8.4400	3.4604	4.0000	1
243	8303	15	0	4	Q2	2012	8.4400	4.2200	4.0000	1
243	8407	15	0	11	Q4	2012	6.3300	2.8485	3.0000	1
243	8427	16	0	12	Q4	2012	8.4400	2.7852	4.0000	1
243	8452	16	0	9	Q3	2012	8.4400	2.7008	4.0000	1
243	8617	17	0	4	Q2	2012	8.4400	3.7136	4.0000	1
243	9125	13	0	6	Q2	2012	10.5500	3.2705	5.0000	1
243	9144	13	0	6	Q2	2012	6.3300	1.8990	3.0000	1
243	9734	17	0	4	Q2	2012	6.3300	2.4687	3.0000	1
243	9928	16	0	11	Q4	2012	8.4400	4.1356	4.0000	1
244	454	17	0	9	Q3	2012	5.4000	1.6740	2.0000	1
244	456	15	1154	10	Q4	2012	5.4000	2.0520	2.0000	1
244	705	6	0	5	Q2	2012	8.1000	3.7260	3.0000	1
244	1145	17	0	9	Q3	2012	5.4000	2.4840	2.0000	1
244	1282	3	0	6	Q2	2012	10.8000	4.6440	4.0000	1
244	1802	23	0	5	Q2	2012	10.8000	3.7800	4.0000	1
244	1862	17	0	7	Q3	2012	10.8000	3.8880	4.0000	1
244	2197	11	0	7	Q3	2012	10.8000	3.8880	4.0000	1
244	2470	6	0	12	Q4	2012	8.1000	4.0500	3.0000	1
244	2520	11	0	10	Q4	2012	8.1000	2.9160	3.0000	1
244	2523	6	518	8	Q3	2012	8.1000	3.3210	3.0000	1
244	2695	13	0	8	Q3	2012	13.5000	5.9400	5.0000	1
244	2769	16	0	1	Q1	2012	8.1000	3.5640	3.0000	1
244	3480	7	0	1	Q1	2012	5.4000	2.2680	2.0000	1
244	3551	7	0	12	Q4	2012	8.1000	2.9160	3.0000	1
244	3691	17	0	12	Q4	2012	8.1000	2.7540	3.0000	1
244	3929	15	0	5	Q2	2012	10.8000	3.7800	4.0000	1
244	4017	15	1140	4	Q2	2012	8.1000	2.5110	3.0000	1
244	4094	16	0	6	Q2	2012	8.1000	3.4830	3.0000	1
244	4094	16	1223	6	Q2	2012	10.8000	4.8600	4.0000	1
244	4127	15	1152	9	Q3	2012	8.1000	2.6730	3.0000	1
244	4925	16	0	5	Q2	2012	8.1000	2.5920	3.0000	1
244	5032	15	0	1	Q1	2012	5.4000	2.1060	2.0000	1
244	5436	6	0	5	Q2	2012	8.1000	3.7260	3.0000	1
244	5528	24	1847	2	Q1	2012	10.8000	5.0760	4.0000	1
244	5896	6	0	2	Q1	2012	10.8000	3.6720	4.0000	1
244	6300	15	1140	4	Q2	2012	10.8000	3.3480	4.0000	1
244	6307	16	1220	4	Q2	2012	5.4000	1.8900	2.0000	1
244	6352	13	980	3	Q1	2012	5.4000	2.5920	2.0000	1
244	6690	17	0	2	Q1	2012	5.4000	2.4840	2.0000	1
244	6792	13	0	12	Q4	2012	8.1000	3.0780	3.0000	1
244	6957	16	0	1	Q1	2012	5.4000	2.6460	2.0000	1
244	7657	11	0	4	Q2	2012	10.8000	4.9680	4.0000	1
244	7768	15	0	3	Q1	2012	10.8000	3.6720	4.0000	1
244	7899	6	504	2	Q1	2012	8.1000	2.5920	3.0000	1
244	7906	13	0	5	Q2	2012	5.4000	2.1060	2.0000	1
244	7913	17	0	2	Q1	2012	8.1000	3.8070	3.0000	1
244	7913	17	0	12	Q4	2012	8.1000	3.3210	3.0000	1
244	7913	17	1303	6	Q2	2012	8.1000	3.3210	3.0000	1
244	8154	7	0	1	Q1	2012	8.1000	3.4830	3.0000	1
244	8164	13	986	6	Q2	2012	8.1000	2.9970	3.0000	1
244	8172	17	1303	6	Q2	2012	8.1000	3.9690	3.0000	1
244	8242	17	0	12	Q4	2012	13.5000	5.6700	5.0000	1
244	8284	22	0	11	Q4	2012	2.7000	1.3230	1.0000	1
244	8384	15	0	11	Q4	2012	8.1000	2.8350	3.0000	1
244	8782	7	0	1	Q1	2012	8.1000	3.2400	3.0000	1
244	9125	13	0	1	Q1	2012	10.8000	4.9680	4.0000	1
244	9350	6	521	10	Q4	2012	10.8000	5.0760	4.0000	1
244	9469	17	1311	10	Q4	2012	8.1000	2.5920	3.0000	1
244	9564	17	1292	1	Q1	2012	13.5000	6.6150	5.0000	1
244	9631	16	0	8	Q3	2012	8.1000	2.5110	3.0000	1
244	9656	24	0	11	Q4	2012	8.1000	4.0500	3.0000	1
244	10075	15	1146	7	Q3	2012	10.8000	4.5360	4.0000	1
244	10168	15	0	12	Q4	2012	8.1000	3.5640	3.0000	1
244	10213	6	0	9	Q3	2012	10.8000	3.4560	4.0000	1
245	181	3	0	2	Q1	2012	5.9600	2.8012	4.0000	1
245	190	13	0	1	Q1	2012	4.4700	1.4304	3.0000	1
245	739	23	0	12	Q4	2012	4.4700	1.5645	3.0000	1
245	740	11	0	1	Q1	2012	4.4700	1.8774	3.0000	1
245	771	15	0	8	Q3	2012	4.4700	1.3857	3.0000	1
245	1251	7	0	11	Q4	2012	5.9600	2.8012	4.0000	1
245	1289	23	1765	1	Q1	2012	2.9800	0.9834	2.0000	1
245	1862	17	0	6	Q2	2012	5.9600	2.5032	4.0000	1
245	2020	6	0	2	Q1	2012	4.4700	1.3857	3.0000	1
245	2053	11	0	6	Q2	2012	5.9600	2.1456	4.0000	1
245	2246	13	984	5	Q2	2012	4.4700	2.0562	3.0000	1
245	2270	11	0	5	Q2	2012	5.9600	2.2052	4.0000	1
245	2371	16	0	5	Q2	2012	4.4700	2.1903	3.0000	1
245	2742	17	0	7	Q3	2012	5.9600	2.4436	4.0000	1
245	2758	7	0	10	Q4	2012	2.9800	1.2218	2.0000	1
245	2897	15	0	9	Q3	2012	2.9800	0.9536	2.0000	1
245	3166	24	0	5	Q2	2012	4.4700	1.5198	3.0000	1
245	3463	13	0	3	Q1	2012	5.9600	2.9204	4.0000	1
245	3549	22	0	4	Q2	2012	1.4900	0.4768	1.0000	1
245	3681	13	0	7	Q3	2012	2.9800	0.9536	2.0000	1
245	3826	16	1216	2	Q1	2012	4.4700	2.1903	3.0000	1
245	3859	24	0	7	Q3	2012	2.9800	0.8940	2.0000	1
245	4436	3	0	10	Q4	2012	2.9800	1.3112	2.0000	1
245	4479	6	0	9	Q3	2012	4.4700	2.1456	3.0000	1
245	4528	15	0	3	Q1	2012	4.4700	1.5645	3.0000	1
245	4676	16	0	7	Q3	2012	2.9800	1.1324	2.0000	1
245	4693	3	0	4	Q2	2012	4.4700	1.6986	3.0000	1
245	4736	13	0	8	Q3	2012	2.9800	1.3112	2.0000	1
245	4816	24	0	7	Q3	2012	4.4700	2.0562	3.0000	1
245	5050	17	0	1	Q1	2012	5.9600	2.0860	4.0000	1
245	5214	7	521	10	Q4	2012	4.4700	1.6539	3.0000	1
245	5302	11	0	3	Q1	2012	4.4700	1.5645	3.0000	1
245	6067	7	0	12	Q4	2012	5.9600	1.9072	4.0000	1
245	6278	7	0	1	Q1	2012	4.4700	2.1456	3.0000	1
245	7579	15	0	10	Q4	2012	4.4700	1.8774	3.0000	1
245	7674	7	0	10	Q4	2012	5.9600	2.0860	4.0000	1
245	7899	7	0	7	Q3	2012	2.9800	1.2516	2.0000	1
245	7978	11	0	7	Q3	2012	4.4700	1.4751	3.0000	1
245	8224	7	0	10	Q4	2012	5.9600	2.1456	4.0000	1
245	8295	6	0	5	Q2	2012	5.9600	2.9800	4.0000	1
245	8452	16	0	4	Q2	2012	5.9600	1.9072	4.0000	1
245	8452	16	1235	11	Q4	2012	7.4500	2.9055	5.0000	1
245	8578	23	1768	2	Q1	2012	4.4700	1.6986	3.0000	1
245	8609	6	0	8	Q3	2012	5.9600	2.3840	4.0000	1
245	9144	13	0	12	Q4	2012	2.9800	1.2218	2.0000	1
245	9420	13	0	7	Q3	2012	4.4700	1.4304	3.0000	1
245	9528	6	0	6	Q2	2012	4.4700	1.7433	3.0000	1
245	9757	24	1869	12	Q4	2012	2.9800	1.0132	2.0000	1
245	10021	24	0	12	Q4	2012	4.4700	1.3857	3.0000	1
246	121	6	506	3	Q1	2012	12.8400	5.1360	4.0000	1
246	448	17	0	4	Q2	2012	9.6300	4.2372	3.0000	1
246	1193	13	0	11	Q4	2012	9.6300	3.6594	3.0000	1
246	1341	3	0	12	Q4	2012	6.4200	2.4396	2.0000	1
246	1497	17	0	2	Q1	2012	9.6300	4.0446	3.0000	1
246	1531	6	511	5	Q2	2012	9.6300	3.7557	3.0000	1
246	1720	16	1225	7	Q3	2012	9.6300	3.3705	3.0000	1
246	3448	3	0	4	Q2	2012	9.6300	4.8150	3.0000	1
246	3463	13	0	7	Q3	2012	12.8400	6.2916	4.0000	1
246	3589	13	980	3	Q1	2012	6.4200	2.7606	2.0000	1
246	3767	6	524	11	Q4	2012	12.8400	4.8792	4.0000	1
246	4099	17	0	9	Q3	2012	12.8400	5.6496	4.0000	1
246	4597	17	0	5	Q2	2012	9.6300	2.9853	3.0000	1
246	4711	3	197	6	Q2	2012	9.6300	4.4298	3.0000	1
246	4967	7	516	8	Q3	2012	12.8400	4.7508	4.0000	1
246	5126	24	1856	6	Q2	2012	12.8400	5.9064	4.0000	1
246	5168	7	0	5	Q2	2012	16.0500	5.9385	5.0000	1
246	5174	16	0	11	Q4	2012	9.6300	3.7557	3.0000	1
246	5302	11	0	11	Q4	2012	9.6300	4.6224	3.0000	1
246	5999	23	1773	4	Q2	2012	9.6300	2.8890	3.0000	1
246	6014	7	517	8	Q3	2012	9.6300	4.6224	3.0000	1
246	6096	7	0	12	Q4	2012	12.8400	4.4940	4.0000	1
246	6307	16	0	9	Q3	2012	9.6300	3.7557	3.0000	1
246	6496	3	0	9	Q3	2012	9.6300	4.0446	3.0000	1
246	6924	24	0	8	Q3	2012	12.8400	5.9064	4.0000	1
246	7595	24	1866	11	Q4	2012	9.6300	2.8890	3.0000	1
246	7822	3	0	12	Q4	2012	9.6300	4.4298	3.0000	1
246	7920	17	0	2	Q1	2012	9.6300	3.2742	3.0000	1
246	8207	13	986	6	Q2	2012	9.6300	3.7557	3.0000	1
246	8452	16	0	5	Q2	2012	9.6300	2.9853	3.0000	1
246	8912	7	0	6	Q2	2012	6.4200	3.1458	2.0000	1
246	8966	3	0	4	Q2	2012	12.8400	3.9804	4.0000	1
246	9270	11	0	3	Q1	2012	9.6300	4.2372	3.0000	1
246	9825	13	986	6	Q2	2012	9.6300	4.0446	3.0000	1
247	158	17	1314	11	Q4	2012	5.3400	2.1360	3.0000	1
247	161	24	1846	2	Q1	2012	5.3400	2.4030	3.0000	1
247	377	7	0	3	Q1	2012	7.1200	3.2040	4.0000	1
247	511	16	0	4	Q2	2012	7.1200	2.1360	4.0000	1
247	621	11	0	7	Q3	2012	5.3400	1.6554	3.0000	1
247	1249	15	0	2	Q1	2012	7.1200	2.2784	4.0000	1
247	1423	13	0	9	Q3	2012	5.3400	1.7088	3.0000	1
247	1919	24	1859	8	Q3	2012	7.1200	3.4176	4.0000	1
247	2228	15	1150	8	Q3	2012	5.3400	2.5632	3.0000	1
247	2343	15	0	11	Q4	2012	3.5600	1.7088	2.0000	1
247	2673	11	833	8	Q3	2012	5.3400	1.9758	3.0000	1
247	2896	3	0	2	Q1	2012	5.3400	1.7088	3.0000	1
247	3688	24	0	7	Q3	2012	5.3400	1.9224	3.0000	1
247	4096	3	190	3	Q1	2012	3.5600	1.3528	2.0000	1
247	4315	17	0	12	Q4	2012	5.3400	2.5098	3.0000	1
247	4443	11	0	1	Q1	2012	5.3400	2.0292	3.0000	1
247	4498	17	0	11	Q4	2012	3.5600	1.1036	2.0000	1
247	4507	13	0	4	Q2	2012	7.1200	3.4888	4.0000	1
247	4568	6	508	4	Q2	2012	5.3400	1.9224	3.0000	1
247	5067	17	0	6	Q2	2012	3.5600	1.1748	2.0000	1
247	5999	23	0	10	Q4	2012	3.5600	1.7444	2.0000	1
247	6288	13	0	1	Q1	2012	7.1200	2.4920	4.0000	1
247	6340	14	0	6	Q2	2012	3.5600	1.7800	2.0000	1
247	6424	6	518	8	Q3	2012	7.1200	2.4920	4.0000	1
247	6933	15	0	6	Q2	2012	5.3400	1.8156	3.0000	1
247	7117	15	0	6	Q2	2012	5.3400	2.4030	3.0000	1
247	7241	17	1304	7	Q3	2012	8.9000	3.6490	5.0000	1
247	7416	13	0	1	Q1	2012	7.1200	2.7768	4.0000	1
247	7580	17	1314	11	Q4	2012	5.3400	2.0292	3.0000	1
247	8171	24	0	1	Q1	2012	5.3400	2.0292	3.0000	1
247	8749	13	980	3	Q1	2012	3.5600	1.5308	2.0000	1
247	9169	23	0	5	Q2	2012	3.5600	1.3528	2.0000	1
247	9491	13	0	8	Q3	2012	7.1200	2.3496	4.0000	1
247	9535	11	826	5	Q2	2012	7.1200	2.5632	4.0000	1
247	9668	13	0	6	Q2	2012	5.3400	2.4030	3.0000	1
247	9951	3	0	2	Q1	2012	8.9000	3.9160	5.0000	1
248	192	16	0	8	Q3	2012	2.5800	0.9030	3.0000	1
248	400	23	0	5	Q2	2012	3.4400	1.6168	4.0000	1
248	477	15	1138	3	Q1	2012	3.4400	1.2040	4.0000	1
248	856	11	829	6	Q2	2012	5.1600	1.9608	6.0000	1
248	863	17	1292	1	Q1	2012	2.5800	0.9288	3.0000	1
248	1358	15	0	7	Q3	2012	3.4400	1.3416	4.0000	1
248	1387	11	0	1	Q1	2012	1.7200	0.8600	2.0000	1
248	1771	2	0	6	Q2	2012	0.8600	0.4300	1.0000	1
248	1838	24	0	6	Q2	2012	2.5800	1.1094	3.0000	1
248	1913	15	0	12	Q4	2012	2.5800	1.1094	3.0000	1
248	2075	13	0	9	Q3	2012	1.7200	0.5848	2.0000	1
248	2588	23	0	12	Q4	2012	2.5800	1.1352	3.0000	1
248	2654	6	0	10	Q4	2012	1.7200	0.8600	2.0000	1
248	2976	7	0	7	Q3	2012	2.5800	1.0578	3.0000	1
248	3109	11	0	2	Q1	2012	2.5800	1.1352	3.0000	1
248	3263	14	1062	4	Q2	2012	1.7200	0.8600	2.0000	1
248	3288	3	0	4	Q2	2012	2.5800	0.9288	3.0000	1
248	3299	14	0	10	Q4	2012	0.8600	0.3182	1.0000	1
248	3321	24	0	3	Q1	2012	2.5800	0.8514	3.0000	1
248	3336	15	0	2	Q1	2012	2.5800	1.2900	3.0000	1
248	3463	13	0	1	Q1	2012	1.7200	0.6536	2.0000	1
248	3692	16	1225	7	Q3	2012	3.4400	1.5824	4.0000	1
248	3733	24	1856	6	Q2	2012	1.7200	0.7052	2.0000	1
248	3742	11	0	12	Q4	2012	2.5800	0.9030	3.0000	1
248	3944	14	0	3	Q1	2012	1.7200	0.6192	2.0000	1
248	3956	14	0	9	Q3	2012	1.7200	0.8084	2.0000	1
248	3994	15	0	6	Q2	2012	3.4400	1.5136	4.0000	1
248	4021	16	0	11	Q4	2012	2.5800	1.0836	3.0000	1
248	4175	16	1216	2	Q1	2012	3.4400	1.1696	4.0000	1
248	4322	15	1143	5	Q2	2012	3.4400	1.0664	4.0000	1
248	4357	7	0	3	Q1	2012	1.7200	0.7224	2.0000	1
248	4397	16	0	2	Q1	2012	2.5800	0.8772	3.0000	1
248	4405	13	0	6	Q2	2012	1.7200	0.7224	2.0000	1
248	4431	13	0	6	Q2	2012	3.4400	1.3072	4.0000	1
248	4695	13	0	7	Q3	2012	3.4400	1.3416	4.0000	1
248	4925	16	1228	8	Q3	2012	2.5800	1.1352	3.0000	1
248	5050	17	0	7	Q3	2012	2.5800	0.9030	3.0000	1
248	5096	7	521	10	Q4	2012	2.5800	1.1352	3.0000	1
248	5237	2	0	12	Q4	2012	0.8600	0.2752	1.0000	1
248	5432	16	0	9	Q3	2012	1.7200	0.6536	2.0000	1
248	6854	17	0	2	Q1	2012	2.5800	0.8514	3.0000	1
248	6995	11	820	2	Q1	2012	2.5800	0.7998	3.0000	1
248	7065	17	0	2	Q1	2012	2.5800	0.9804	3.0000	1
248	7117	15	0	6	Q2	2012	2.5800	1.2126	3.0000	1
248	7151	24	0	11	Q4	2012	3.4400	1.5480	4.0000	1
248	7275	17	0	11	Q4	2012	1.7200	0.6020	2.0000	1
248	7522	13	0	12	Q4	2012	2.5800	1.2642	3.0000	1
248	7829	24	0	9	Q3	2012	3.4400	1.1008	4.0000	1
248	7878	15	0	12	Q4	2012	2.5800	0.9030	3.0000	1
248	8214	7	516	8	Q3	2012	2.5800	1.1094	3.0000	1
248	8511	16	0	6	Q2	2012	2.5800	1.1610	3.0000	1
248	9029	3	0	5	Q2	2012	2.5800	1.1352	3.0000	1
248	9134	23	0	8	Q3	2012	1.7200	0.6708	2.0000	1
248	9134	23	0	11	Q4	2012	1.7200	0.6020	2.0000	1
248	9507	7	0	4	Q2	2012	2.5800	0.8772	3.0000	1
248	9864	6	508	4	Q2	2012	2.5800	0.9546	3.0000	1
249	217	13	980	3	Q1	2012	6.3600	2.4168	4.0000	1
249	769	16	1216	2	Q1	2012	6.3600	2.7348	4.0000	1
249	1271	13	0	1	Q1	2012	4.7700	1.8126	3.0000	1
249	1339	13	0	6	Q2	2012	6.3600	3.1164	4.0000	1
249	1468	13	0	7	Q3	2012	4.7700	1.4787	3.0000	1
249	1638	11	820	2	Q1	2012	4.7700	2.2896	3.0000	1
249	2088	6	0	4	Q2	2012	4.7700	1.4787	3.0000	1
249	2194	6	526	12	Q4	2012	4.7700	2.0034	3.0000	1
249	2246	13	0	9	Q3	2012	4.7700	1.6695	3.0000	1
249	2313	24	0	2	Q1	2012	6.3600	2.6712	4.0000	1
249	2997	15	1134	1	Q1	2012	4.7700	2.0511	3.0000	1
249	3124	3	0	1	Q1	2012	4.7700	1.6695	3.0000	1
249	3160	17	0	2	Q1	2012	4.7700	2.1465	3.0000	1
249	3160	17	1314	11	Q4	2012	4.7700	1.4787	3.0000	1
249	3463	13	0	3	Q1	2012	4.7700	1.5264	3.0000	1
249	3567	16	0	5	Q2	2012	3.1800	1.2084	2.0000	1
249	3776	13	0	10	Q4	2012	3.1800	1.1766	2.0000	1
249	3977	13	980	3	Q1	2012	4.7700	2.1465	3.0000	1
249	4096	3	0	5	Q2	2012	4.7700	2.3850	3.0000	1
249	4179	24	1869	12	Q4	2012	4.7700	1.6695	3.0000	1
249	4295	11	829	6	Q2	2012	6.3600	2.3532	4.0000	1
249	4391	16	1235	11	Q4	2012	6.3600	3.1800	4.0000	1
249	4643	22	0	1	Q1	2012	1.5900	0.7473	1.0000	1
249	4711	3	195	5	Q2	2012	6.3600	2.9892	4.0000	1
249	4783	13	0	8	Q3	2012	6.3600	2.0988	4.0000	1
249	5001	7	504	2	Q1	2012	4.7700	1.6218	3.0000	1
249	5031	6	0	4	Q2	2012	4.7700	1.6218	3.0000	1
249	5154	14	1077	11	Q4	2012	1.5900	0.7314	1.0000	1
249	5238	17	0	4	Q2	2012	4.7700	2.0988	3.0000	1
249	5280	7	523	11	Q4	2012	6.3600	2.7348	4.0000	1
249	5361	24	0	6	Q2	2012	6.3600	2.2260	4.0000	1
249	5419	17	0	4	Q2	2012	3.1800	1.4628	2.0000	1
249	5620	6	522	10	Q4	2012	4.7700	2.2896	3.0000	1
249	5686	3	0	12	Q4	2012	3.1800	1.3992	2.0000	1
249	5746	15	1134	1	Q1	2012	6.3600	3.1164	4.0000	1
249	6372	17	0	10	Q4	2012	3.1800	1.3356	2.0000	1
249	7051	16	1233	10	Q4	2012	3.1800	1.5582	2.0000	1
249	7250	13	0	2	Q1	2012	6.3600	2.5440	4.0000	1
249	7276	23	0	2	Q1	2012	4.7700	1.9557	3.0000	1
249	7455	13	0	6	Q2	2012	7.9500	2.8620	5.0000	1
249	7514	17	0	5	Q2	2012	7.9500	3.8160	5.0000	1
249	7579	15	0	10	Q4	2012	4.7700	1.6695	3.0000	1
249	7607	17	0	2	Q1	2012	6.3600	2.1624	4.0000	1
249	7607	17	1314	11	Q4	2012	4.7700	2.0034	3.0000	1
249	8427	16	0	3	Q1	2012	3.1800	1.3356	2.0000	1
249	8576	11	0	9	Q3	2012	4.7700	1.6695	3.0000	1
249	9167	11	0	3	Q1	2012	6.3600	3.0528	4.0000	1
249	9170	6	0	9	Q3	2012	6.3600	2.5440	4.0000	1
249	9315	7	0	9	Q3	2012	6.3600	2.4168	4.0000	1
249	9332	11	0	5	Q2	2012	6.3600	3.0528	4.0000	1
249	9487	17	0	5	Q2	2012	3.1800	1.1766	2.0000	1
249	9794	2	0	5	Q2	2012	3.1800	1.3038	2.0000	1
249	10034	15	0	12	Q4	2012	4.7700	1.7649	3.0000	1
250	106	6	0	1	Q1	2012	12.9500	5.6980	5.0000	1
250	158	17	0	9	Q3	2012	10.3600	4.5584	4.0000	1
250	226	11	829	6	Q2	2012	10.3600	3.4188	4.0000	1
250	439	13	0	2	Q1	2012	10.3600	4.1440	4.0000	1
250	553	6	0	3	Q1	2012	5.1800	1.7094	2.0000	1
250	593	7	0	10	Q4	2012	7.7700	3.8850	3.0000	1
250	676	7	0	1	Q1	2012	10.3600	4.8692	4.0000	1
250	795	14	1078	12	Q4	2012	5.1800	2.5900	2.0000	1
250	976	16	1220	4	Q2	2012	7.7700	2.7195	3.0000	1
250	979	15	0	12	Q4	2012	5.1800	2.1756	2.0000	1
250	1115	22	0	12	Q4	2012	7.7700	3.4965	3.0000	1
250	1415	16	0	4	Q2	2012	7.7700	3.8850	3.0000	1
250	1415	16	0	8	Q3	2012	7.7700	3.5742	3.0000	1
250	1567	16	0	7	Q3	2012	10.3600	3.5224	4.0000	1
250	1800	11	0	7	Q3	2012	7.7700	2.4864	3.0000	1
250	1821	13	0	8	Q3	2012	12.9500	6.0865	5.0000	1
250	1839	11	0	10	Q4	2012	10.3600	4.6620	4.0000	1
250	1850	16	0	4	Q2	2012	7.7700	2.7195	3.0000	1
250	1966	6	502	1	Q1	2012	7.7700	2.5641	3.0000	1
250	1983	17	0	8	Q3	2012	12.9500	5.5685	5.0000	1
250	2059	17	0	8	Q3	2012	10.3600	3.7296	4.0000	1
250	2204	3	0	12	Q4	2012	7.7700	2.5641	3.0000	1
250	2298	3	0	8	Q3	2012	10.3600	3.2116	4.0000	1
250	2422	13	0	6	Q2	2012	7.7700	2.4087	3.0000	1
250	2479	13	0	3	Q1	2012	7.7700	3.7296	3.0000	1
250	2496	11	0	8	Q3	2012	7.7700	3.0303	3.0000	1
250	2663	16	1225	7	Q3	2012	7.7700	3.2634	3.0000	1
250	2687	24	0	5	Q2	2012	15.5400	6.3714	6.0000	1
250	2907	15	1140	4	Q2	2012	7.7700	3.7296	3.0000	1
250	3216	6	0	9	Q3	2012	7.7700	3.0303	3.0000	1
250	3312	15	0	2	Q1	2012	7.7700	3.0303	3.0000	1
250	3463	13	0	7	Q3	2012	7.7700	2.5641	3.0000	1
250	3725	23	0	7	Q3	2012	7.7700	2.7972	3.0000	1
250	4231	17	0	4	Q2	2012	7.7700	2.4087	3.0000	1
250	4340	17	1303	6	Q2	2012	7.7700	3.6519	3.0000	1
250	4468	11	0	1	Q1	2012	7.7700	3.0303	3.0000	1
250	5085	24	1856	6	Q2	2012	7.7700	3.8850	3.0000	1
250	5134	3	0	8	Q3	2012	10.3600	4.7656	4.0000	1
250	5219	17	0	12	Q4	2012	10.3600	3.3152	4.0000	1
250	5340	11	829	6	Q2	2012	10.3600	4.2476	4.0000	1
250	5524	11	836	9	Q3	2012	7.7700	3.8850	3.0000	1
250	5766	16	0	1	Q1	2012	7.7700	2.3310	3.0000	1
250	5869	13	0	6	Q2	2012	7.7700	3.0303	3.0000	1
250	5944	3	0	1	Q1	2012	7.7700	3.0303	3.0000	1
250	6017	11	0	12	Q4	2012	10.3600	3.9368	4.0000	1
250	6733	13	0	11	Q4	2012	10.3600	3.3152	4.0000	1
250	7065	17	0	3	Q1	2012	10.3600	3.3152	4.0000	1
250	7072	16	0	7	Q3	2012	5.1800	2.0202	2.0000	1
250	7130	24	1858	7	Q3	2012	10.3600	3.6260	4.0000	1
250	7132	13	0	5	Q2	2012	10.3600	4.6620	4.0000	1
250	7141	17	1307	8	Q3	2012	10.3600	3.3152	4.0000	1
250	7384	3	0	6	Q2	2012	7.7700	3.0303	3.0000	1
250	8004	24	1858	7	Q3	2012	7.7700	3.4188	3.0000	1
250	8482	11	842	12	Q4	2012	7.7700	2.4864	3.0000	1
250	8492	14	1061	4	Q2	2012	2.5900	1.2432	1.0000	1
250	8608	24	0	6	Q2	2012	5.1800	2.5382	2.0000	1
250	8984	6	0	9	Q3	2012	7.7700	3.4965	3.0000	1
250	9252	6	515	7	Q3	2012	7.7700	2.9526	3.0000	1
250	9437	15	0	2	Q1	2012	7.7700	2.4087	3.0000	1
250	9715	17	0	12	Q4	2012	10.3600	3.9368	4.0000	1
250	9815	16	1216	2	Q1	2012	5.1800	2.4346	2.0000	1
250	10246	15	0	12	Q4	2012	7.7700	2.4864	3.0000	1
251	335	17	0	4	Q2	2012	7.3200	2.9280	3.0000	1
251	392	13	984	5	Q2	2012	9.7600	4.2944	4.0000	1
251	447	6	519	9	Q3	2012	4.8800	2.0008	2.0000	1
251	619	13	0	11	Q4	2012	7.3200	2.5620	3.0000	1
251	1235	11	0	4	Q2	2012	7.3200	2.3424	3.0000	1
251	1446	24	0	3	Q1	2012	4.8800	2.0008	2.0000	1
251	1446	24	0	6	Q2	2012	4.8800	2.0496	2.0000	1
251	1574	6	0	9	Q3	2012	9.7600	3.4160	4.0000	1
251	1810	2	0	5	Q2	2012	4.8800	1.8544	2.0000	1
251	1832	23	0	5	Q2	2012	9.7600	3.3184	4.0000	1
251	2201	16	0	4	Q2	2012	9.7600	3.7088	4.0000	1
251	2246	13	980	3	Q1	2012	9.7600	4.5872	4.0000	1
251	2311	7	526	12	Q4	2012	7.3200	2.3424	3.0000	1
251	2469	15	1140	4	Q2	2012	9.7600	3.7088	4.0000	1
251	2570	16	0	3	Q1	2012	4.8800	1.9032	2.0000	1
251	2647	6	0	7	Q3	2012	7.3200	2.4156	3.0000	1
251	2674	11	0	9	Q3	2012	9.7600	4.7824	4.0000	1
251	2731	7	0	10	Q4	2012	9.7600	3.1232	4.0000	1
251	2769	16	0	8	Q3	2012	9.7600	3.1232	4.0000	1
251	3197	23	0	3	Q1	2012	12.2000	4.3920	5.0000	1
251	3337	6	0	1	Q1	2012	4.8800	2.2448	2.0000	1
251	3388	13	980	3	Q1	2012	9.7600	3.9040	4.0000	1
251	3415	15	0	1	Q1	2012	7.3200	2.1960	3.0000	1
251	3838	17	0	7	Q3	2012	7.3200	2.7084	3.0000	1
251	4340	17	1314	11	Q4	2012	7.3200	3.0744	3.0000	1
251	4680	6	526	12	Q4	2012	7.3200	2.7816	3.0000	1
251	4886	24	1845	1	Q1	2012	7.3200	3.4404	3.0000	1
251	5388	11	0	11	Q4	2012	9.7600	4.5872	4.0000	1
251	5407	24	0	6	Q2	2012	9.7600	4.3920	4.0000	1
251	5598	24	0	11	Q4	2012	7.3200	2.6352	3.0000	1
251	5805	11	0	4	Q2	2012	7.3200	3.1476	3.0000	1
251	5810	13	980	3	Q1	2012	4.8800	1.6104	2.0000	1
251	5924	13	0	10	Q4	2012	4.8800	1.9032	2.0000	1
251	5944	3	201	8	Q3	2012	7.3200	2.2692	3.0000	1
251	5962	17	0	6	Q2	2012	9.7600	3.0256	4.0000	1
251	6043	24	1866	11	Q4	2012	4.8800	1.5616	2.0000	1
251	6683	17	0	11	Q4	2012	7.3200	3.1476	3.0000	1
251	6841	3	0	8	Q3	2012	7.3200	3.1476	3.0000	1
251	7329	2	118	6	Q2	2012	4.8800	2.2936	2.0000	1
251	7704	3	0	1	Q1	2012	7.3200	2.7816	3.0000	1
251	8472	17	0	12	Q4	2012	7.3200	2.2692	3.0000	1
251	8511	16	0	7	Q3	2012	7.3200	3.3672	3.0000	1
251	8511	16	1214	2	Q1	2012	4.8800	1.9032	2.0000	1
251	8549	6	508	4	Q2	2012	9.7600	3.1232	4.0000	1
251	8576	11	0	10	Q4	2012	4.8800	1.6592	2.0000	1
251	8578	23	0	2	Q1	2012	7.3200	3.0744	3.0000	1
251	8724	7	0	3	Q1	2012	4.8800	1.9520	2.0000	1
251	8730	7	504	2	Q1	2012	4.8800	2.2448	2.0000	1
251	8947	3	0	6	Q2	2012	4.8800	1.7568	2.0000	1
251	9125	13	0	11	Q4	2012	9.7600	4.7824	4.0000	1
251	9682	15	1136	2	Q1	2012	7.3200	2.4156	3.0000	1
251	9719	11	0	10	Q4	2012	7.3200	2.7084	3.0000	1
252	261	24	1856	6	Q2	2012	8.1300	3.1707	3.0000	1
252	280	13	0	10	Q4	2012	8.1300	2.6016	3.0000	1
252	465	13	0	12	Q4	2012	10.8400	3.3604	4.0000	1
252	619	13	1000	12	Q4	2012	8.1300	3.8211	3.0000	1
252	652	6	0	3	Q1	2012	8.1300	4.0650	3.0000	1
252	780	13	0	4	Q2	2012	8.1300	3.1707	3.0000	1
252	964	6	0	4	Q2	2012	10.8400	4.3360	4.0000	1
252	1042	11	0	3	Q1	2012	10.8400	3.4688	4.0000	1
252	1474	15	0	2	Q1	2012	8.1300	3.1707	3.0000	1
252	1524	13	0	7	Q3	2012	10.8400	5.4200	4.0000	1
252	1692	24	0	12	Q4	2012	8.1300	3.5772	3.0000	1
252	1758	3	0	1	Q1	2012	5.4200	2.3306	2.0000	1
252	1811	11	0	4	Q2	2012	5.4200	2.2764	2.0000	1
252	2200	7	0	9	Q3	2012	8.1300	3.1707	3.0000	1
252	2298	3	0	4	Q2	2012	5.4200	1.8970	2.0000	1
252	2304	13	0	9	Q3	2012	8.1300	3.3333	3.0000	1
252	2572	6	0	12	Q4	2012	8.1300	3.5772	3.0000	1
252	2640	6	0	2	Q1	2012	8.1300	3.9024	3.0000	1
252	2677	13	0	1	Q1	2012	8.1300	3.9024	3.0000	1
252	2682	23	1765	1	Q1	2012	8.1300	3.5772	3.0000	1
252	2762	13	0	6	Q2	2012	10.8400	3.9024	4.0000	1
252	3395	11	0	1	Q1	2012	10.8400	4.4444	4.0000	1
252	3418	3	210	12	Q4	2012	8.1300	3.3333	3.0000	1
252	3513	7	512	6	Q2	2012	5.4200	1.9512	2.0000	1
252	3847	11	0	10	Q4	2012	10.8400	4.5528	4.0000	1
252	3900	24	0	12	Q4	2012	10.8400	4.7696	4.0000	1
252	4471	11	0	12	Q4	2012	10.8400	3.7940	4.0000	1
252	4525	6	508	4	Q2	2012	10.8400	4.9864	4.0000	1
252	4810	23	0	9	Q3	2012	5.4200	2.3306	2.0000	1
252	4973	17	0	9	Q3	2012	5.4200	2.4390	2.0000	1
252	5070	13	0	5	Q2	2012	5.4200	2.4390	2.0000	1
252	5503	7	0	6	Q2	2012	8.1300	3.4959	3.0000	1
252	5731	7	0	12	Q4	2012	5.4200	2.0054	2.0000	1
252	6091	24	0	3	Q1	2012	5.4200	1.7886	2.0000	1
252	6565	15	0	3	Q1	2012	5.4200	1.7886	2.0000	1
252	6772	24	0	5	Q2	2012	10.8400	3.9024	4.0000	1
252	6805	7	518	8	Q3	2012	8.1300	3.6585	3.0000	1
252	6997	13	0	11	Q4	2012	10.8400	4.3360	4.0000	1
252	7032	2	0	9	Q3	2012	2.7100	0.8130	1.0000	1
252	7275	17	0	7	Q3	2012	8.1300	2.5203	3.0000	1
252	7384	3	0	1	Q1	2012	5.4200	1.7886	2.0000	1
252	7434	11	829	6	Q2	2012	13.5500	5.1490	5.0000	1
252	7655	17	0	1	Q1	2012	8.1300	3.0894	3.0000	1
252	7655	17	0	5	Q2	2012	5.4200	2.0596	2.0000	1
252	7669	11	0	4	Q2	2012	8.1300	3.2520	3.0000	1
252	7683	22	0	11	Q4	2012	2.7100	1.1653	1.0000	1
252	7689	15	0	10	Q4	2012	8.1300	3.3333	3.0000	1
252	8070	6	0	11	Q4	2012	5.4200	1.7886	2.0000	1
252	8170	11	821	3	Q1	2012	8.1300	3.9024	3.0000	1
252	8378	24	1866	11	Q4	2012	8.1300	3.0894	3.0000	1
252	8500	17	0	10	Q4	2012	8.1300	3.6585	3.0000	1
252	8768	11	826	5	Q2	2012	5.4200	1.8428	2.0000	1
252	10131	17	0	9	Q3	2012	8.1300	3.5772	3.0000	1
252	10173	16	0	5	Q2	2012	8.1300	2.9268	3.0000	1
253	143	7	0	6	Q2	2012	2.6700	0.8544	3.0000	1
253	398	13	0	3	Q1	2012	2.6700	0.8544	3.0000	1
253	690	24	1856	6	Q2	2012	2.6700	1.2282	3.0000	1
253	995	6	0	10	Q4	2012	2.6700	0.8811	3.0000	1
253	1142	13	0	7	Q3	2012	2.6700	0.9879	3.0000	1
253	1168	17	0	7	Q3	2012	1.7800	0.8188	2.0000	1
253	1329	15	0	1	Q1	2012	3.5600	1.4240	4.0000	1
253	1332	11	0	12	Q4	2012	2.6700	1.1748	3.0000	1
253	1339	13	0	6	Q2	2012	2.6700	1.3083	3.0000	1
253	1366	13	0	3	Q1	2012	2.6700	1.0146	3.0000	1
253	1525	7	0	12	Q4	2012	1.7800	0.6408	2.0000	1
253	1660	13	0	10	Q4	2012	3.5600	1.3172	4.0000	1
253	1818	11	0	3	Q1	2012	3.5600	1.7088	4.0000	1
253	2052	13	0	9	Q3	2012	2.6700	1.1214	3.0000	1
253	2255	24	1856	6	Q2	2012	2.6700	1.1481	3.0000	1
253	2942	17	1314	11	Q4	2012	1.7800	0.8900	2.0000	1
253	3160	17	1314	11	Q4	2012	2.6700	1.1481	3.0000	1
253	3207	15	0	10	Q4	2012	3.5600	1.3884	4.0000	1
253	3395	11	0	11	Q4	2012	3.5600	1.6020	4.0000	1
253	3435	11	0	12	Q4	2012	2.6700	1.0146	3.0000	1
253	4021	16	1214	2	Q1	2012	2.6700	1.0146	3.0000	1
253	4196	13	992	9	Q3	2012	3.5600	1.7800	4.0000	1
253	4240	24	0	8	Q3	2012	2.6700	0.9612	3.0000	1
253	4522	17	1303	6	Q2	2012	1.7800	0.6942	2.0000	1
253	4595	11	0	5	Q2	2012	2.6700	1.2549	3.0000	1
253	4693	3	0	5	Q2	2012	2.6700	0.9345	3.0000	1
253	4948	13	0	9	Q3	2012	2.6700	0.8544	3.0000	1
253	5174	16	0	10	Q4	2012	3.5600	1.4240	4.0000	1
253	5256	17	0	12	Q4	2012	3.5600	1.3884	4.0000	1
253	5271	15	0	9	Q3	2012	3.5600	1.3884	4.0000	1
253	5542	16	0	5	Q2	2012	2.6700	1.0413	3.0000	1
253	5612	15	0	1	Q1	2012	3.5600	1.6732	4.0000	1
253	5678	6	0	12	Q4	2012	3.5600	1.7800	4.0000	1
253	5744	3	0	4	Q2	2012	2.6700	1.0680	3.0000	1
253	5895	17	0	5	Q2	2012	2.6700	1.3350	3.0000	1
253	6074	2	0	4	Q2	2012	0.8900	0.2848	1.0000	1
253	6392	7	0	7	Q3	2012	1.7800	0.6052	2.0000	1
253	6530	17	0	4	Q2	2012	2.6700	0.9612	3.0000	1
253	6681	17	0	12	Q4	2012	2.6700	1.1214	3.0000	1
253	7137	11	0	12	Q4	2012	2.6700	0.9078	3.0000	1
253	7433	11	0	2	Q1	2012	2.6700	1.2015	3.0000	1
253	7571	7	0	9	Q3	2012	1.7800	0.5518	2.0000	1
253	7733	13	0	1	Q1	2012	2.6700	1.3083	3.0000	1
253	8275	16	0	11	Q4	2012	1.7800	0.6942	2.0000	1
253	8898	11	0	11	Q4	2012	1.7800	0.8900	2.0000	1
253	8912	6	0	9	Q3	2012	2.6700	1.2816	3.0000	1
253	9125	13	0	12	Q4	2012	2.6700	0.8811	3.0000	1
253	9200	16	0	9	Q3	2012	1.7800	0.7120	2.0000	1
253	9619	11	0	11	Q4	2012	2.6700	0.9879	3.0000	1
253	10167	17	0	8	Q3	2012	2.6700	0.9612	3.0000	1
254	17	7	516	8	Q3	2012	2.2400	0.9408	4.0000	1
254	36	11	0	11	Q4	2012	1.6800	0.7560	3.0000	1
254	178	13	0	7	Q3	2012	2.2400	0.8512	4.0000	1
254	240	7	0	4	Q2	2012	1.1200	0.4816	2.0000	1
254	511	16	0	11	Q4	2012	1.6800	0.7728	3.0000	1
254	689	24	0	11	Q4	2012	1.6800	0.6216	3.0000	1
254	936	24	0	6	Q2	2012	2.2400	0.9856	4.0000	1
254	1024	17	1314	11	Q4	2012	1.6800	0.5712	3.0000	1
254	1366	13	0	9	Q3	2012	1.6800	0.6384	3.0000	1
254	1379	6	0	7	Q3	2012	2.2400	1.0528	4.0000	1
254	1567	16	0	8	Q3	2012	1.6800	0.6048	3.0000	1
254	1902	24	0	12	Q4	2012	1.6800	0.8064	3.0000	1
254	2032	23	0	8	Q3	2012	1.6800	0.7560	3.0000	1
254	2204	3	0	12	Q4	2012	1.6800	0.6216	3.0000	1
254	2448	16	1235	11	Q4	2012	1.6800	0.7896	3.0000	1
254	2588	23	1789	12	Q4	2012	1.6800	0.6384	3.0000	1
254	2791	11	0	8	Q3	2012	2.8000	1.0360	5.0000	1
254	2941	24	1847	2	Q1	2012	1.6800	0.8400	3.0000	1
254	3140	6	513	6	Q2	2012	1.1200	0.5488	2.0000	1
254	3146	7	0	5	Q2	2012	2.2400	0.6944	4.0000	1
254	3271	13	0	2	Q1	2012	1.1200	0.4032	2.0000	1
254	3688	24	0	9	Q3	2012	1.6800	0.7728	3.0000	1
254	3711	3	0	1	Q1	2012	2.2400	0.8512	4.0000	1
254	4080	11	841	12	Q4	2012	1.6800	0.6720	3.0000	1
254	4219	11	836	9	Q3	2012	1.6800	0.6384	3.0000	1
254	4253	13	0	4	Q2	2012	2.2400	0.9856	4.0000	1
254	4349	15	0	12	Q4	2012	2.2400	0.9408	4.0000	1
254	4351	23	0	2	Q1	2012	2.8000	1.3160	5.0000	1
254	4351	23	0	7	Q3	2012	2.2400	0.8288	4.0000	1
254	4666	13	0	2	Q1	2012	1.6800	0.7392	3.0000	1
254	5339	11	0	6	Q2	2012	1.6800	0.5712	3.0000	1
254	5355	15	0	2	Q1	2012	1.1200	0.5600	2.0000	1
254	5396	11	0	1	Q1	2012	2.2400	0.7840	4.0000	1
254	5581	11	833	8	Q3	2012	1.6800	0.7224	3.0000	1
254	5686	3	0	6	Q2	2012	1.6800	0.7392	3.0000	1
254	5844	17	1294	2	Q1	2012	1.6800	0.5208	3.0000	1
254	5989	7	0	3	Q1	2012	1.6800	0.7392	3.0000	1
254	6047	17	1294	2	Q1	2012	2.2400	1.0976	4.0000	1
254	6313	17	0	5	Q2	2012	1.1200	0.4256	2.0000	1
254	6408	24	0	10	Q4	2012	1.1200	0.4256	2.0000	1
254	6792	13	0	8	Q3	2012	1.6800	0.5040	3.0000	1
254	7052	23	0	12	Q4	2012	1.6800	0.6048	3.0000	1
254	7189	13	976	1	Q1	2012	2.2400	1.0080	4.0000	1
254	7312	24	1850	3	Q1	2012	1.6800	0.7056	3.0000	1
254	7355	13	976	1	Q1	2012	1.6800	0.6216	3.0000	1
254	7366	3	210	12	Q4	2012	1.6800	0.7896	3.0000	1
254	7489	24	0	3	Q1	2012	2.8000	1.0640	5.0000	1
254	7501	24	1866	11	Q4	2012	1.6800	0.6552	3.0000	1
254	7694	13	0	7	Q3	2012	2.2400	0.7168	4.0000	1
254	7806	13	0	7	Q3	2012	1.6800	0.7896	3.0000	1
254	8142	6	504	2	Q1	2012	2.2400	1.0304	4.0000	1
254	8310	13	0	6	Q2	2012	1.6800	0.7056	3.0000	1
254	8348	24	1866	11	Q4	2012	2.2400	0.8064	4.0000	1
254	8435	17	0	6	Q2	2012	1.6800	0.5712	3.0000	1
254	8487	15	0	1	Q1	2012	2.2400	0.9856	4.0000	1
254	8558	11	0	1	Q1	2012	2.2400	0.7168	4.0000	1
254	8667	13	0	12	Q4	2012	1.6800	0.6216	3.0000	1
254	8731	3	0	2	Q1	2012	1.1200	0.5152	2.0000	1
254	8902	3	0	11	Q4	2012	1.1200	0.5040	2.0000	1
254	9594	7	0	1	Q1	2012	2.2400	0.9184	4.0000	1
254	10118	13	986	6	Q2	2012	2.2400	1.0752	4.0000	1
254	10161	6	0	1	Q1	2012	1.6800	0.5712	3.0000	1
255	179	6	0	7	Q3	2012	1.9200	0.7296	3.0000	1
255	591	11	0	4	Q2	2012	2.5600	1.1520	4.0000	1
255	593	7	504	2	Q1	2012	1.9200	0.5952	3.0000	1
255	617	17	0	9	Q3	2012	1.9200	0.5760	3.0000	1
255	644	13	0	10	Q4	2012	1.9200	0.9024	3.0000	1
255	647	3	0	10	Q4	2012	1.9200	0.9216	3.0000	1
255	769	16	0	12	Q4	2012	2.5600	0.9216	4.0000	2
255	779	15	0	10	Q4	2012	2.5600	0.9216	4.0000	1
255	780	13	0	3	Q1	2012	1.9200	0.8448	3.0000	1
255	1493	2	0	1	Q1	2012	0.6400	0.2304	1.0000	1
255	1813	17	0	9	Q3	2012	1.2800	0.4736	2.0000	1
255	1850	16	0	7	Q3	2012	1.9200	0.5760	3.0000	1
255	1950	24	0	4	Q2	2012	1.9200	0.9600	3.0000	1
255	2171	23	0	9	Q3	2012	1.2800	0.4864	2.0000	1
255	2201	16	0	3	Q1	2012	2.5600	0.9728	4.0000	1
255	2507	3	0	3	Q1	2012	1.9200	0.6912	3.0000	1
255	2647	6	0	7	Q3	2012	1.9200	0.7104	3.0000	1
255	2722	7	0	4	Q2	2012	1.9200	0.8640	3.0000	1
255	2917	15	0	11	Q4	2012	2.5600	0.8448	4.0000	1
255	3204	24	0	3	Q1	2012	1.2800	0.3968	2.0000	1
255	3242	3	0	6	Q2	2012	2.5600	0.8960	4.0000	1
255	3313	15	0	4	Q2	2012	1.9200	0.8832	3.0000	1
255	3458	24	0	5	Q2	2012	3.2000	0.9920	5.0000	1
255	3838	17	0	9	Q3	2012	2.5600	1.0752	4.0000	1
255	4029	17	0	12	Q4	2012	1.9200	0.9600	3.0000	1
255	4231	17	0	4	Q2	2012	1.9200	0.6144	3.0000	1
255	4363	15	1142	5	Q2	2012	1.2800	0.6400	2.0000	1
255	4454	15	0	12	Q4	2012	2.5600	0.9472	4.0000	1
255	4457	22	0	6	Q2	2012	0.6400	0.3200	1.0000	1
255	4618	3	0	4	Q2	2012	3.2000	1.5040	5.0000	1
255	4670	17	0	8	Q3	2012	2.5600	0.8192	4.0000	1
255	4670	17	0	9	Q3	2012	1.2800	0.4224	2.0000	1
255	4810	23	1778	7	Q3	2012	1.9200	0.6528	3.0000	1
255	4874	24	0	1	Q1	2012	1.2800	0.4736	2.0000	1
255	4903	3	0	10	Q4	2012	1.2800	0.4352	2.0000	1
255	5180	24	0	8	Q3	2012	1.2800	0.5504	2.0000	1
255	5245	11	0	7	Q3	2012	1.9200	0.9408	3.0000	1
255	5530	13	0	7	Q3	2012	1.9200	0.8832	3.0000	1
255	5592	16	0	8	Q3	2012	1.9200	0.9024	3.0000	1
255	5766	16	1233	10	Q4	2012	1.9200	0.5760	3.0000	1
255	5944	3	0	8	Q3	2012	1.9200	0.5952	3.0000	1
255	6013	22	0	5	Q2	2012	0.6400	0.2496	1.0000	1
255	6124	7	0	9	Q3	2012	1.9200	0.8832	3.0000	1
255	6206	11	0	1	Q1	2012	2.5600	0.8192	4.0000	1
255	6383	22	0	6	Q2	2012	1.2800	0.4864	2.0000	1
255	6982	13	0	12	Q4	2012	1.2800	0.4224	2.0000	1
255	7149	13	0	9	Q3	2012	1.9200	0.6336	3.0000	1
255	7153	3	201	8	Q3	2012	1.9200	0.7680	3.0000	1
255	7713	17	0	5	Q2	2012	1.2800	0.4864	2.0000	1
255	7797	15	0	6	Q2	2012	2.5600	1.0240	4.0000	1
255	7978	11	0	7	Q3	2012	2.5600	0.9728	4.0000	1
255	8060	22	0	1	Q1	2012	1.2800	0.5632	2.0000	1
255	8673	11	0	12	Q4	2012	1.9200	0.6144	3.0000	1
255	8772	11	0	4	Q2	2012	1.9200	0.7872	3.0000	1
255	8849	11	0	5	Q2	2012	2.5600	0.8704	4.0000	1
255	9019	6	521	10	Q4	2012	2.5600	1.1520	4.0000	1
255	9263	16	0	5	Q2	2012	1.9200	0.7104	3.0000	1
255	9290	14	0	10	Q4	2012	0.6400	0.2176	1.0000	1
255	10054	7	0	9	Q3	2012	2.5600	1.1264	4.0000	1
256	40	14	1061	4	Q2	2012	5.3000	2.3320	2.0000	1
256	502	15	0	3	Q1	2012	7.9500	2.6235	3.0000	1
256	552	11	0	7	Q3	2012	5.3000	2.4380	2.0000	1
256	647	3	0	4	Q2	2012	7.9500	3.4980	3.0000	1
256	650	11	0	3	Q1	2012	10.6000	4.5580	4.0000	1
256	750	13	0	8	Q3	2012	7.9500	3.7365	3.0000	1
256	776	24	1866	11	Q4	2012	10.6000	3.7100	4.0000	1
256	1925	22	0	9	Q3	2012	5.3000	1.9610	2.0000	1
256	2020	6	506	3	Q1	2012	5.3000	2.1730	2.0000	1
256	2211	17	0	3	Q1	2012	10.6000	5.1940	4.0000	1
256	2232	6	0	3	Q1	2012	5.3000	2.0140	2.0000	1
256	2371	16	0	6	Q2	2012	7.9500	3.9750	3.0000	1
256	2612	24	0	5	Q2	2012	7.9500	3.8160	3.0000	1
256	2712	6	521	10	Q4	2012	7.9500	3.8955	3.0000	1
256	2942	17	0	4	Q2	2012	7.9500	2.7825	3.0000	1
256	2968	13	0	4	Q2	2012	13.2500	5.8300	5.0000	1
256	3231	17	0	5	Q2	2012	7.9500	3.0210	3.0000	1
256	3428	24	0	1	Q1	2012	7.9500	3.9750	3.0000	1
256	3528	17	0	3	Q1	2012	10.6000	5.3000	4.0000	1
256	3709	7	0	11	Q4	2012	7.9500	3.7365	3.0000	1
256	3828	24	0	10	Q4	2012	5.3000	2.4910	2.0000	1
256	4163	14	0	4	Q2	2012	5.3000	2.3320	2.0000	1
256	4175	16	0	8	Q3	2012	10.6000	5.3000	4.0000	1
256	4445	17	1314	11	Q4	2012	10.6000	4.6640	4.0000	1
256	4570	2	126	10	Q4	2012	7.9500	3.8160	3.0000	1
256	4589	13	992	9	Q3	2012	7.9500	3.4185	3.0000	1
256	4634	24	0	12	Q4	2012	7.9500	2.7030	3.0000	1
256	4658	17	0	9	Q3	2012	7.9500	2.7030	3.0000	1
256	4877	15	0	3	Q1	2012	7.9500	3.0210	3.0000	1
256	5425	24	0	6	Q2	2012	7.9500	3.1005	3.0000	1
256	5631	24	1856	6	Q2	2012	13.2500	5.1675	5.0000	1
256	5808	7	0	7	Q3	2012	10.6000	3.7100	4.0000	1
256	5958	13	0	7	Q3	2012	7.9500	2.7825	3.0000	1
256	6091	24	0	3	Q1	2012	7.9500	2.9415	3.0000	1
256	6113	16	0	8	Q3	2012	7.9500	3.5775	3.0000	1
256	6256	6	0	8	Q3	2012	7.9500	2.4645	3.0000	1
256	6736	17	0	4	Q2	2012	10.6000	3.7100	4.0000	1
256	7051	16	0	12	Q4	2012	7.9500	3.4185	3.0000	1
256	7243	13	0	11	Q4	2012	5.3000	2.6500	2.0000	1
256	7384	3	0	6	Q2	2012	10.6000	4.1340	4.0000	1
256	7580	17	0	2	Q1	2012	7.9500	3.3390	3.0000	1
256	7683	22	0	11	Q4	2012	2.6500	1.3250	1.0000	1
256	7708	6	508	4	Q2	2012	7.9500	3.8955	3.0000	1
256	7743	3	0	10	Q4	2012	7.9500	2.5440	3.0000	1
256	7780	13	0	7	Q3	2012	5.3000	2.5970	2.0000	1
256	7906	13	0	7	Q3	2012	7.9500	3.6570	3.0000	1
256	8038	24	0	8	Q3	2012	7.9500	3.6570	3.0000	1
256	8457	7	0	9	Q3	2012	5.3000	1.8550	2.0000	1
256	8629	24	1853	5	Q2	2012	5.3000	2.5970	2.0000	1
256	8966	3	0	5	Q2	2012	7.9500	2.7825	3.0000	1
256	9184	3	0	12	Q4	2012	5.3000	2.0140	2.0000	1
256	9476	6	0	7	Q3	2012	7.9500	3.4185	3.0000	1
256	9534	17	0	1	Q1	2012	7.9500	2.5440	3.0000	1
256	10156	14	1072	9	Q3	2012	7.9500	3.5775	3.0000	1
257	217	13	984	5	Q2	2012	2.6500	1.0335	5.0000	1
257	1332	11	0	4	Q2	2012	2.6500	0.8480	5.0000	1
257	1575	13	0	4	Q2	2012	1.5900	0.7155	3.0000	1
257	1887	11	0	1	Q1	2012	2.1200	0.8692	4.0000	1
257	1983	17	0	8	Q3	2012	2.1200	0.8692	4.0000	1
257	2747	24	0	6	Q2	2012	2.1200	0.9116	4.0000	1
257	3130	13	0	3	Q1	2012	1.5900	0.5724	3.0000	1
257	4609	23	0	9	Q3	2012	2.1200	0.6572	4.0000	1
257	4670	17	0	9	Q3	2012	2.1200	0.7632	4.0000	1
257	4728	7	504	2	Q1	2012	1.0600	0.4028	2.0000	1
257	4834	24	0	7	Q3	2012	2.1200	0.6360	4.0000	1
257	5253	7	0	1	Q1	2012	1.0600	0.4346	2.0000	1
257	5358	3	0	3	Q1	2012	2.1200	1.0600	4.0000	1
257	5644	17	1314	11	Q4	2012	1.5900	0.7155	3.0000	1
257	5742	16	0	9	Q3	2012	2.1200	1.0388	4.0000	1
257	5827	11	0	3	Q1	2012	1.5900	0.7473	3.0000	1
257	5882	11	826	5	Q2	2012	1.0600	0.4770	2.0000	1
257	5935	7	0	11	Q4	2012	1.5900	0.7473	3.0000	1
257	5977	15	0	2	Q1	2012	2.1200	0.9964	4.0000	1
257	6529	17	0	7	Q3	2012	1.5900	0.6042	3.0000	1
257	7330	6	0	4	Q2	2012	1.5900	0.6519	3.0000	1
257	7434	11	0	12	Q4	2012	1.0600	0.4028	2.0000	1
257	7657	11	0	4	Q2	2012	1.0600	0.4558	2.0000	1
257	8108	17	1303	6	Q2	2012	1.0600	0.3710	2.0000	1
257	8514	14	0	12	Q4	2012	1.0600	0.5194	2.0000	1
257	8742	3	188	2	Q1	2012	1.5900	0.5247	3.0000	1
257	8798	6	0	6	Q2	2012	2.1200	0.6572	4.0000	1
257	8982	7	523	11	Q4	2012	1.5900	0.6360	3.0000	1
257	9276	7	0	7	Q3	2012	1.0600	0.3604	2.0000	1
257	9331	11	0	10	Q4	2012	1.5900	0.5724	3.0000	1
257	9381	24	0	6	Q2	2012	1.5900	0.6996	3.0000	1
257	10240	3	0	12	Q4	2012	1.0600	0.4134	2.0000	1
257	10264	15	0	5	Q2	2012	1.5900	0.5724	3.0000	1
258	400	23	0	1	Q1	2012	3.4400	1.5136	2.0000	1
258	454	17	0	1	Q1	2012	5.1600	2.0640	3.0000	1
258	481	24	1850	3	Q1	2012	5.1600	2.1672	3.0000	1
258	769	16	1216	2	Q1	2012	3.4400	1.3072	2.0000	1
258	778	15	1157	12	Q4	2012	3.4400	1.0664	2.0000	1
258	819	13	0	12	Q4	2012	3.4400	1.6856	2.0000	1
258	887	14	0	4	Q2	2012	1.7200	0.8600	1.0000	1
258	916	6	0	2	Q1	2012	5.1600	1.8576	3.0000	1
258	1144	7	0	4	Q2	2012	5.1600	2.2188	3.0000	1
258	1192	17	0	4	Q2	2012	5.1600	1.8060	3.0000	1
258	1387	11	0	7	Q3	2012	5.1600	2.4768	3.0000	1
258	1491	16	0	1	Q1	2012	5.1600	2.3220	3.0000	1
258	1650	7	0	8	Q3	2012	3.4400	1.1352	2.0000	1
258	1744	17	0	6	Q2	2012	6.8800	3.0960	4.0000	1
258	1839	11	0	4	Q2	2012	5.1600	1.8060	3.0000	1
258	2035	15	0	2	Q1	2012	5.1600	2.2704	3.0000	1
258	2102	6	0	12	Q4	2012	5.1600	1.9092	3.0000	1
258	2143	17	0	2	Q1	2012	8.6000	2.7520	5.0000	1
258	2201	16	0	7	Q3	2012	5.1600	2.3220	3.0000	1
258	2740	11	0	6	Q2	2012	5.1600	2.4768	3.0000	1
258	2769	16	0	12	Q4	2012	5.1600	1.7028	3.0000	1
258	2820	7	0	11	Q4	2012	5.1600	2.3736	3.0000	1
258	3166	24	1845	1	Q1	2012	6.8800	2.9584	4.0000	1
258	3388	13	984	5	Q2	2012	3.4400	1.2384	2.0000	1
258	3425	11	818	1	Q1	2012	5.1600	1.8576	3.0000	1
258	3965	24	0	10	Q4	2012	5.1600	1.6512	3.0000	1
258	4413	13	0	1	Q1	2012	3.4400	1.3416	2.0000	1
258	4474	6	502	1	Q1	2012	6.8800	3.2336	4.0000	1
258	4664	6	0	5	Q2	2012	5.1600	2.3220	3.0000	1
258	4727	16	0	1	Q1	2012	6.8800	2.6144	4.0000	1
258	4954	11	0	9	Q3	2012	5.1600	1.7028	3.0000	1
258	5063	3	0	10	Q4	2012	5.1600	1.9608	3.0000	1
258	5116	15	1149	8	Q3	2012	5.1600	1.5996	3.0000	1
258	5339	11	0	3	Q1	2012	3.4400	1.1352	2.0000	1
258	5419	17	0	10	Q4	2012	6.8800	2.2016	4.0000	1
258	5432	16	0	7	Q3	2012	3.4400	1.2384	2.0000	1
258	5560	13	0	7	Q3	2012	5.1600	2.2704	3.0000	1
258	5731	7	514	7	Q3	2012	3.4400	1.6856	2.0000	1
258	5809	13	984	5	Q2	2012	6.8800	2.3392	4.0000	1
258	5910	15	0	3	Q1	2012	5.1600	2.3736	3.0000	1
258	6019	6	0	9	Q3	2012	5.1600	2.4768	3.0000	1
258	6355	7	0	12	Q4	2012	5.1600	2.3736	3.0000	1
258	6609	6	0	4	Q2	2012	5.1600	1.7544	3.0000	1
258	7149	13	0	2	Q1	2012	6.8800	2.7520	4.0000	1
258	7384	3	0	12	Q4	2012	3.4400	1.6512	2.0000	1
258	7469	7	0	7	Q3	2012	3.4400	1.4792	2.0000	1
258	7772	15	0	9	Q3	2012	5.1600	2.3736	3.0000	1
258	7849	3	199	7	Q3	2012	5.1600	1.6512	3.0000	1
258	8195	6	0	6	Q2	2012	5.1600	1.9608	3.0000	1
258	8321	11	837	10	Q4	2012	6.8800	3.3712	4.0000	1
258	8367	13	0	2	Q1	2012	6.8800	2.6832	4.0000	1
258	8435	17	0	1	Q1	2012	3.4400	1.6512	2.0000	1
258	8505	6	502	1	Q1	2012	5.1600	2.5284	3.0000	1
258	8541	15	1150	8	Q3	2012	6.8800	3.0272	4.0000	1
258	8768	11	0	11	Q4	2012	3.4400	1.5136	2.0000	1
258	9171	15	1154	10	Q4	2012	6.8800	2.9584	4.0000	1
258	9487	17	0	12	Q4	2012	6.8800	3.0960	4.0000	1
258	9884	11	0	2	Q1	2012	3.4400	1.3416	2.0000	1
258	10243	17	0	9	Q3	2012	6.8800	2.3392	4.0000	1
259	39	13	0	10	Q4	2012	5.7000	2.1090	3.0000	1
259	133	6	523	11	Q4	2012	5.7000	2.8500	3.0000	1
259	193	6	0	5	Q2	2012	5.7000	2.2230	3.0000	1
259	663	16	0	9	Q3	2012	7.6000	2.3560	4.0000	1
259	924	3	0	1	Q1	2012	9.5000	4.2750	5.0000	1
259	1097	23	0	12	Q4	2012	7.6000	2.6600	4.0000	1
259	1122	15	0	10	Q4	2012	9.5000	3.9900	5.0000	1
259	1890	24	0	10	Q4	2012	7.6000	2.5080	4.0000	1
259	1917	23	0	4	Q2	2012	3.8000	1.8620	2.0000	1
259	2065	17	0	9	Q3	2012	5.7000	2.4510	3.0000	1
259	2201	16	0	5	Q2	2012	5.7000	1.9380	3.0000	1
259	2210	13	0	8	Q3	2012	5.7000	2.0520	3.0000	1
259	2246	13	982	4	Q2	2012	9.5000	4.4650	5.0000	1
259	2521	6	515	7	Q3	2012	5.7000	2.7360	3.0000	1
259	2673	11	0	10	Q4	2012	7.6000	3.7240	4.0000	1
259	2711	15	0	12	Q4	2012	5.7000	2.7930	3.0000	1
259	2908	11	0	1	Q1	2012	7.6000	3.6480	4.0000	1
259	2977	7	0	4	Q2	2012	5.7000	2.5080	3.0000	1
259	3124	3	0	10	Q4	2012	7.6000	2.3560	4.0000	1
259	3187	24	1869	12	Q4	2012	3.8000	1.8620	2.0000	1
259	3286	22	0	9	Q3	2012	3.8000	1.2540	2.0000	1
259	3850	7	0	9	Q3	2012	5.7000	2.0520	3.0000	1
259	3979	13	980	3	Q1	2012	7.6000	3.7240	4.0000	1
259	4490	13	0	11	Q4	2012	5.7000	2.6220	3.0000	1
259	4548	6	0	11	Q4	2012	3.8000	1.8240	2.0000	1
259	4670	17	0	9	Q3	2012	5.7000	2.0520	3.0000	1
259	4676	16	1225	7	Q3	2012	3.8000	1.3680	2.0000	1
259	4783	13	0	8	Q3	2012	7.6000	2.8880	4.0000	1
259	4985	23	1768	2	Q1	2012	5.7000	1.8240	3.0000	1
259	5126	24	1856	6	Q2	2012	3.8000	1.6340	2.0000	1
259	5278	11	0	12	Q4	2012	3.8000	1.5200	2.0000	1
259	5295	16	1214	2	Q1	2012	7.6000	2.2800	4.0000	1
259	5380	7	0	1	Q1	2012	5.7000	2.0520	3.0000	1
259	5850	2	0	5	Q2	2012	3.8000	1.6720	2.0000	1
259	6088	14	0	4	Q2	2012	1.9000	0.8740	1.0000	1
259	6441	24	1851	4	Q2	2012	5.7000	2.7360	3.0000	1
259	6590	7	518	8	Q3	2012	5.7000	2.5080	3.0000	1
259	6922	7	521	10	Q4	2012	7.6000	2.6600	4.0000	1
259	6982	13	0	12	Q4	2012	5.7000	2.0520	3.0000	1
259	7001	3	0	4	Q2	2012	7.6000	2.5080	4.0000	1
259	7490	24	0	7	Q3	2012	7.6000	2.5080	4.0000	1
259	7556	17	0	9	Q3	2012	9.5000	3.0400	5.0000	1
259	7731	7	0	12	Q4	2012	5.7000	2.1090	3.0000	1
259	7813	17	0	5	Q2	2012	5.7000	2.8500	3.0000	1
259	8292	14	1066	6	Q2	2012	5.7000	2.4510	3.0000	1
259	8717	17	0	8	Q3	2012	3.8000	1.2920	2.0000	1
259	8862	11	0	7	Q3	2012	5.7000	2.1090	3.0000	1
259	8960	3	0	9	Q3	2012	3.8000	1.7480	2.0000	1
259	9109	7	0	10	Q4	2012	3.8000	1.2920	2.0000	1
259	9208	15	0	2	Q1	2012	9.5000	3.5150	5.0000	1
259	9622	6	0	8	Q3	2012	3.8000	1.1780	2.0000	1
259	9668	13	0	7	Q3	2012	7.6000	3.1160	4.0000	1
259	9924	15	0	12	Q4	2012	5.7000	2.8500	3.0000	1
259	10043	22	1710	12	Q4	2012	3.8000	1.4440	2.0000	1
260	432	15	0	9	Q3	2012	7.3600	2.3552	4.0000	1
260	463	23	0	9	Q3	2012	5.5200	2.1528	3.0000	1
260	1003	17	1303	6	Q2	2012	5.5200	2.5392	3.0000	1
260	1281	3	0	2	Q1	2012	7.3600	2.2816	4.0000	1
260	1917	23	0	6	Q2	2012	5.5200	2.0976	3.0000	1
260	1966	6	502	1	Q1	2012	7.3600	2.7968	4.0000	1
260	1970	3	0	6	Q2	2012	7.3600	3.1648	4.0000	1
260	2272	17	1314	11	Q4	2012	5.5200	1.9320	3.0000	1
260	2673	11	0	1	Q1	2012	3.6800	1.3984	2.0000	1
260	2777	13	0	5	Q2	2012	5.5200	2.3736	3.0000	1
260	2925	11	0	10	Q4	2012	5.5200	2.6496	3.0000	1
260	3231	17	0	5	Q2	2012	5.5200	1.9320	3.0000	1
260	3328	17	0	9	Q3	2012	5.5200	1.9320	3.0000	1
260	3422	23	0	11	Q4	2012	5.5200	2.2080	3.0000	1
260	3476	3	0	5	Q2	2012	7.3600	2.5760	4.0000	1
260	3520	15	0	11	Q4	2012	5.5200	1.7664	3.0000	1
260	3838	17	0	12	Q4	2012	7.3600	3.4592	4.0000	1
260	3979	13	0	7	Q3	2012	7.3600	3.6064	4.0000	1
260	4162	7	0	3	Q1	2012	5.5200	2.7048	3.0000	1
260	4249	11	0	6	Q2	2012	3.6800	1.6928	2.0000	1
260	4499	13	992	9	Q3	2012	3.6800	1.5824	2.0000	1
260	4726	11	0	7	Q3	2012	7.3600	2.7968	4.0000	1
260	4810	23	0	4	Q2	2012	7.3600	2.9440	4.0000	1
260	4844	24	0	8	Q3	2012	3.6800	1.8032	2.0000	1
260	4987	15	0	6	Q2	2012	5.5200	2.6496	3.0000	1
260	5196	13	0	11	Q4	2012	5.5200	2.4840	3.0000	1
260	5288	13	0	1	Q1	2012	7.3600	2.2816	4.0000	1
260	5566	6	526	12	Q4	2012	5.5200	2.1528	3.0000	1
260	5973	3	0	10	Q4	2012	5.5200	1.7664	3.0000	1
260	6599	22	0	9	Q3	2012	3.6800	1.3248	2.0000	1
260	6654	24	1853	5	Q2	2012	7.3600	2.3552	4.0000	1
260	6793	7	526	12	Q4	2012	7.3600	2.5024	4.0000	1
260	6831	14	0	12	Q4	2012	3.6800	1.2144	2.0000	1
260	6891	7	0	7	Q3	2012	9.2000	3.4960	5.0000	1
260	7203	13	0	4	Q2	2012	7.3600	2.3552	4.0000	1
260	7267	6	526	12	Q4	2012	5.5200	1.8768	3.0000	1
260	7493	24	0	2	Q1	2012	7.3600	2.3552	4.0000	1
260	7556	17	0	11	Q4	2012	7.3600	3.6800	4.0000	1
260	7659	6	0	4	Q2	2012	3.6800	1.3984	2.0000	1
260	7822	3	0	10	Q4	2012	3.6800	1.8032	2.0000	1
260	8269	13	0	2	Q1	2012	5.5200	2.4840	3.0000	1
260	8289	17	0	12	Q4	2012	5.5200	2.0976	3.0000	1
260	8477	3	202	8	Q3	2012	5.5200	2.7600	3.0000	1
260	8667	13	0	11	Q4	2012	5.5200	2.3184	3.0000	1
260	8783	15	0	12	Q4	2012	5.5200	1.8216	3.0000	1
260	8902	3	199	7	Q3	2012	5.5200	2.7600	3.0000	1
260	9016	23	0	10	Q4	2012	5.5200	2.1528	3.0000	1
260	9125	13	0	6	Q2	2012	3.6800	1.4720	2.0000	1
260	9745	17	1294	2	Q1	2012	7.3600	3.5328	4.0000	1
261	511	16	1233	10	Q4	2012	10.1400	3.5490	3.0000	1
261	612	22	1701	7	Q3	2012	6.7600	2.7716	2.0000	1
261	976	16	0	1	Q1	2012	10.1400	3.5490	3.0000	1
261	1167	6	0	5	Q2	2012	10.1400	5.0700	3.0000	1
261	1167	7	0	10	Q4	2012	10.1400	5.0700	3.0000	1
261	1253	13	0	7	Q3	2012	10.1400	4.5630	3.0000	1
261	1311	11	0	4	Q2	2012	6.7600	2.9068	2.0000	1
261	1736	13	0	12	Q4	2012	13.5200	5.0024	4.0000	1
261	1850	16	0	3	Q1	2012	6.7600	2.3660	2.0000	1
261	1934	2	0	10	Q4	2012	3.3800	1.2506	1.0000	1
261	1938	24	0	12	Q4	2012	6.7600	2.2984	2.0000	1
261	2165	24	0	9	Q3	2012	10.1400	3.9546	3.0000	1
261	2187	15	0	9	Q3	2012	6.7600	3.3124	2.0000	1
261	2373	13	0	1	Q1	2012	13.5200	4.8672	4.0000	1
261	2468	13	0	10	Q4	2012	13.5200	4.5968	4.0000	1
261	2626	11	0	11	Q4	2012	6.7600	2.2308	2.0000	1
261	2632	13	0	12	Q4	2012	10.1400	4.7658	3.0000	1
261	2632	13	988	7	Q3	2012	10.1400	4.7658	3.0000	1
261	2640	7	0	4	Q2	2012	13.5200	4.4616	4.0000	1
261	2893	24	0	12	Q4	2012	10.1400	4.9686	3.0000	1
261	3012	24	1850	3	Q1	2012	10.1400	4.2588	3.0000	1
261	3101	11	826	5	Q2	2012	13.5200	5.5432	4.0000	1
261	3242	3	0	11	Q4	2012	13.5200	5.1376	4.0000	1
261	3311	11	826	5	Q2	2012	13.5200	4.3264	4.0000	1
261	3337	6	0	1	Q1	2012	13.5200	5.0024	4.0000	1
261	3422	23	0	10	Q4	2012	13.5200	4.3264	4.0000	1
261	3596	11	0	1	Q1	2012	13.5200	5.6784	4.0000	1
261	4094	16	1223	6	Q2	2012	13.5200	5.0024	4.0000	1
261	4211	11	0	7	Q3	2012	16.9000	6.7600	5.0000	1
261	4700	17	0	8	Q3	2012	13.5200	5.4080	4.0000	1
261	4809	6	0	12	Q4	2012	10.1400	4.6644	3.0000	1
261	4824	3	0	6	Q2	2012	10.1400	4.2588	3.0000	1
261	5080	15	0	5	Q2	2012	16.9000	5.5770	5.0000	1
261	5116	15	0	12	Q4	2012	13.5200	5.2728	4.0000	1
261	5185	24	0	1	Q1	2012	13.5200	6.4896	4.0000	1
261	5432	16	0	11	Q4	2012	16.9000	8.1120	5.0000	1
261	5461	22	1709	11	Q4	2012	3.3800	1.3858	1.0000	1
261	5614	15	0	7	Q3	2012	6.7600	2.2308	2.0000	1
261	5821	15	0	5	Q2	2012	10.1400	4.5630	3.0000	1
261	5847	22	0	5	Q2	2012	3.3800	1.2168	1.0000	1
261	5962	17	0	5	Q2	2012	13.5200	4.3264	4.0000	1
261	6486	13	0	6	Q2	2012	13.5200	4.1912	4.0000	1
261	6516	15	0	10	Q4	2012	6.7600	2.3660	2.0000	1
261	6832	3	0	5	Q2	2012	10.1400	4.3602	3.0000	1
261	6995	11	829	6	Q2	2012	13.5200	5.5432	4.0000	1
261	7243	13	0	3	Q1	2012	10.1400	3.3462	3.0000	1
261	7362	11	0	7	Q3	2012	10.1400	3.9546	3.0000	1
261	7382	22	0	7	Q3	2012	10.1400	3.6504	3.0000	1
261	7391	7	505	2	Q1	2012	6.7600	3.3124	2.0000	1
261	7601	24	0	3	Q1	2012	10.1400	4.8672	3.0000	1
261	7871	7	504	2	Q1	2012	13.5200	4.3264	4.0000	1
261	7927	15	0	1	Q1	2012	10.1400	5.0700	3.0000	1
261	8056	24	0	6	Q2	2012	10.1400	3.6504	3.0000	1
261	8142	6	0	4	Q2	2012	6.7600	3.0420	2.0000	1
261	8445	6	0	9	Q3	2012	6.7600	3.0420	2.0000	1
261	8746	23	0	6	Q2	2012	10.1400	4.1574	3.0000	1
261	8746	23	1783	9	Q3	2012	10.1400	4.7658	3.0000	1
261	8840	17	0	8	Q3	2012	6.7600	3.2448	2.0000	1
261	8960	3	0	5	Q2	2012	10.1400	3.1434	3.0000	1
261	9025	13	0	12	Q4	2012	6.7600	2.9068	2.0000	1
261	9318	16	0	9	Q3	2012	13.5200	5.1376	4.0000	1
261	9420	13	0	5	Q2	2012	10.1400	4.9686	3.0000	1
261	9563	15	1149	8	Q3	2012	6.7600	2.5688	2.0000	1
261	9642	3	0	4	Q2	2012	10.1400	3.9546	3.0000	1
261	9745	17	0	8	Q3	2012	10.1400	3.2448	3.0000	1
261	10091	17	0	8	Q3	2012	13.5200	6.6248	4.0000	1
262	260	11	0	7	Q3	2012	4.0200	1.2864	3.0000	1
262	454	17	0	6	Q2	2012	5.3600	2.3584	4.0000	1
262	614	17	0	12	Q4	2012	5.3600	1.9296	4.0000	1
262	660	7	0	6	Q2	2012	4.0200	1.5678	3.0000	1
262	705	6	0	7	Q3	2012	4.0200	1.6884	3.0000	1
262	747	24	0	10	Q4	2012	6.7000	2.6130	5.0000	1
262	1144	6	0	12	Q4	2012	4.0200	1.8894	3.0000	1
262	1549	7	0	5	Q2	2012	4.0200	1.8090	3.0000	1
262	1701	13	0	11	Q4	2012	5.3600	1.6080	4.0000	1
262	1773	13	0	1	Q1	2012	4.0200	1.8492	3.0000	1
262	1923	11	0	3	Q1	2012	2.6800	1.1524	2.0000	1
262	2625	13	0	7	Q3	2012	5.3600	2.0368	4.0000	1
262	2808	13	0	7	Q3	2012	4.0200	1.8090	3.0000	1
262	3070	7	0	3	Q1	2012	4.0200	1.2060	3.0000	1
262	3160	17	1314	11	Q4	2012	2.6800	1.3400	2.0000	1
262	3251	6	526	12	Q4	2012	5.3600	2.6264	4.0000	1
262	3506	7	0	4	Q2	2012	4.0200	1.5678	3.0000	1
262	3627	3	0	10	Q4	2012	2.6800	1.3400	2.0000	1
262	4021	16	0	12	Q4	2012	2.6800	1.0988	2.0000	1
262	4122	15	1138	3	Q1	2012	5.3600	2.4656	4.0000	1
262	4193	24	0	2	Q1	2012	2.6800	0.9648	2.0000	1
262	4196	13	0	8	Q3	2012	4.0200	1.5276	3.0000	1
262	4508	13	1000	12	Q4	2012	2.6800	0.9916	2.0000	1
262	4541	3	202	8	Q3	2012	4.0200	1.8090	3.0000	1
262	4547	13	0	2	Q1	2012	5.3600	2.2512	4.0000	1
262	4951	15	0	6	Q2	2012	5.3600	1.9296	4.0000	1
262	5019	23	1773	4	Q2	2012	4.0200	1.5678	3.0000	1
262	5180	24	0	8	Q3	2012	4.0200	1.6482	3.0000	1
262	5346	3	0	4	Q2	2012	2.6800	0.9112	2.0000	1
262	5353	23	0	2	Q1	2012	5.3600	2.4120	4.0000	1
262	5655	7	526	12	Q4	2012	4.0200	1.4472	3.0000	1
262	5820	17	0	3	Q1	2012	2.6800	1.0720	2.0000	1
262	5999	23	1773	4	Q2	2012	4.0200	1.4472	3.0000	1
262	6267	24	0	3	Q1	2012	5.3600	2.0368	4.0000	1
262	6347	17	0	2	Q1	2012	4.0200	1.8090	3.0000	1
262	6609	7	0	9	Q3	2012	2.6800	1.1792	2.0000	1
262	6741	24	1869	12	Q4	2012	4.0200	1.4874	3.0000	1
262	6805	7	0	3	Q1	2012	4.0200	1.4874	3.0000	1
262	6893	6	0	12	Q4	2012	4.0200	1.7688	3.0000	1
262	6960	17	0	6	Q2	2012	4.0200	1.2462	3.0000	1
262	7046	15	0	7	Q3	2012	2.6800	1.2060	2.0000	1
262	7269	13	0	3	Q1	2012	5.3600	2.5192	4.0000	1
262	7366	3	0	10	Q4	2012	2.6800	0.9916	2.0000	1
262	7457	13	0	7	Q3	2012	4.0200	1.4874	3.0000	1
262	7469	7	0	7	Q3	2012	2.6800	1.1256	2.0000	1
262	7595	24	1866	11	Q4	2012	4.0200	1.4472	3.0000	1
262	7618	11	821	2	Q1	2012	4.0200	1.8090	3.0000	1
262	7622	3	190	3	Q1	2012	2.6800	0.8844	2.0000	1
262	7702	16	1223	6	Q2	2012	5.3600	2.5192	4.0000	1
262	7743	3	0	12	Q4	2012	5.3600	2.5192	4.0000	1
262	7831	17	0	8	Q3	2012	4.0200	2.0100	3.0000	1
262	8242	17	0	10	Q4	2012	4.0200	2.0100	3.0000	1
262	8311	23	0	6	Q2	2012	2.6800	1.2328	2.0000	1
262	8436	15	0	1	Q1	2012	4.0200	1.8894	3.0000	1
262	8571	3	197	6	Q2	2012	4.0200	1.9296	3.0000	1
262	8777	17	0	8	Q3	2012	5.3600	1.6616	4.0000	1
262	8897	11	0	2	Q1	2012	4.0200	2.0100	3.0000	1
262	9080	11	837	10	Q4	2012	5.3600	1.8224	4.0000	1
262	9422	7	517	8	Q3	2012	5.3600	1.8760	4.0000	1
262	9668	13	0	12	Q4	2012	5.3600	1.8760	4.0000	1
262	9673	13	984	5	Q2	2012	6.7000	2.7470	5.0000	1
262	9760	13	980	3	Q1	2012	5.3600	1.6080	4.0000	1
262	9931	6	0	5	Q2	2012	4.0200	1.8492	3.0000	1
263	221	15	0	1	Q1	2012	11.4000	3.5340	3.0000	1
263	293	22	1694	4	Q2	2012	7.6000	2.5840	2.0000	1
263	417	6	0	12	Q4	2012	11.4000	4.5600	3.0000	1
263	739	23	0	2	Q1	2012	7.6000	3.7240	2.0000	1
263	739	23	1778	7	Q3	2012	7.6000	2.8120	2.0000	1
263	1193	13	0	5	Q2	2012	7.6000	2.8880	2.0000	1
263	1249	15	0	2	Q1	2012	7.6000	3.0400	2.0000	1
263	1491	16	0	11	Q4	2012	11.4000	5.1300	3.0000	1
263	1683	6	518	8	Q3	2012	11.4000	5.5860	3.0000	1
263	2201	16	0	1	Q1	2012	11.4000	5.0160	3.0000	1
263	2368	3	207	11	Q4	2012	7.6000	2.7360	2.0000	1
263	2378	16	0	7	Q3	2012	7.6000	3.8000	2.0000	1
263	2957	7	0	7	Q3	2012	11.4000	5.4720	3.0000	1
263	3208	14	0	2	Q1	2012	7.6000	2.9640	2.0000	1
263	3239	17	0	12	Q4	2012	15.2000	6.8400	4.0000	1
263	3267	23	1775	5	Q2	2012	11.4000	3.5340	3.0000	1
263	3334	17	1307	8	Q3	2012	11.4000	3.4200	3.0000	1
263	3352	7	0	8	Q3	2012	11.4000	5.7000	3.0000	1
263	3810	7	0	3	Q1	2012	15.2000	5.4720	4.0000	1
263	3928	23	0	6	Q2	2012	7.6000	2.8120	2.0000	1
263	3979	13	980	3	Q1	2012	11.4000	3.7620	3.0000	1
263	4151	7	0	11	Q4	2012	7.6000	3.2680	2.0000	1
263	4321	15	1154	10	Q4	2012	15.2000	5.1680	4.0000	1
263	4782	24	0	8	Q3	2012	15.2000	6.6880	4.0000	1
263	4967	7	516	8	Q3	2012	11.4000	3.6480	3.0000	1
263	5133	7	0	11	Q4	2012	7.6000	2.4320	2.0000	1
263	5542	16	0	3	Q1	2012	7.6000	2.6600	2.0000	1
263	5590	17	0	1	Q1	2012	11.4000	4.6740	3.0000	1
263	5597	3	0	3	Q1	2012	11.4000	5.2440	3.0000	1
263	5802	7	0	1	Q1	2012	11.4000	4.3320	3.0000	1
263	6392	7	0	7	Q3	2012	11.4000	4.2180	3.0000	1
263	6417	7	0	4	Q2	2012	11.4000	3.7620	3.0000	1
263	6617	7	0	3	Q1	2012	7.6000	3.6480	2.0000	1
263	6716	6	0	8	Q3	2012	7.6000	2.8880	2.0000	1
263	6717	6	524	11	Q4	2012	11.4000	3.8760	3.0000	1
263	7269	13	0	7	Q3	2012	11.4000	4.4460	3.0000	1
263	7276	23	1769	3	Q1	2012	7.6000	2.4320	2.0000	1
263	7291	11	0	12	Q4	2012	11.4000	5.0160	3.0000	1
263	7459	7	0	7	Q3	2012	11.4000	4.4460	3.0000	1
263	7493	24	0	1	Q1	2012	15.2000	5.4720	4.0000	1
263	7495	14	1056	1	Q1	2012	7.6000	2.8880	2.0000	1
263	7584	6	524	11	Q4	2012	15.2000	6.0800	4.0000	1
263	8038	24	0	7	Q3	2012	15.2000	4.7120	4.0000	1
263	8202	3	0	9	Q3	2012	15.2000	7.4480	4.0000	1
263	8274	13	0	2	Q1	2012	7.6000	2.6600	2.0000	1
263	8665	15	0	12	Q4	2012	15.2000	4.8640	4.0000	1
263	9115	11	0	11	Q4	2012	15.2000	4.8640	4.0000	1
263	9397	11	837	10	Q4	2012	11.4000	4.1040	3.0000	1
263	9501	13	988	7	Q3	2012	7.6000	3.2680	2.0000	1
263	9534	17	1304	7	Q3	2012	15.2000	6.8400	4.0000	1
263	9827	15	1142	5	Q2	2012	11.4000	4.5600	3.0000	1
263	10116	17	1307	8	Q3	2012	15.2000	7.4480	4.0000	1
263	10173	16	1233	10	Q4	2012	15.2000	5.1680	4.0000	1
264	143	6	0	4	Q2	2012	5.5600	1.8904	2.0000	1
264	169	13	0	7	Q3	2012	5.5600	2.6688	2.0000	1
264	352	11	0	1	Q1	2012	5.5600	1.7792	2.0000	1
264	400	23	0	9	Q3	2012	8.3400	3.6696	3.0000	1
264	430	16	1216	2	Q1	2012	5.5600	2.4464	2.0000	1
264	638	11	0	12	Q4	2012	13.9000	6.1160	5.0000	1
264	893	13	0	9	Q3	2012	8.3400	3.9198	3.0000	1
264	968	15	0	11	Q4	2012	5.5600	2.1128	2.0000	1
264	968	15	1141	4	Q2	2012	8.3400	3.3360	3.0000	1
264	1024	17	1314	11	Q4	2012	8.3400	2.6688	3.0000	1
264	1076	2	0	11	Q4	2012	5.5600	2.2796	2.0000	1
264	1609	14	0	12	Q4	2012	2.7800	1.0008	1.0000	1
264	1759	6	510	5	Q2	2012	8.3400	4.1700	3.0000	1
264	1979	3	0	5	Q2	2012	13.9000	6.1160	5.0000	1
264	2211	17	1303	6	Q2	2012	13.9000	5.0040	5.0000	1
264	2212	15	1157	12	Q4	2012	13.9000	5.4210	5.0000	1
264	2215	11	0	12	Q4	2012	11.1200	5.3376	4.0000	1
264	2245	11	0	9	Q3	2012	13.9000	4.5870	5.0000	1
264	2326	6	0	8	Q3	2012	11.1200	5.0040	4.0000	1
264	2335	17	0	8	Q3	2012	8.3400	4.0866	3.0000	1
264	2511	17	0	2	Q1	2012	11.1200	3.3360	4.0000	1
264	2548	13	0	6	Q2	2012	11.1200	5.2264	4.0000	1
264	2638	13	0	10	Q4	2012	8.3400	2.9190	3.0000	1
264	2645	22	0	4	Q2	2012	5.5600	2.2796	2.0000	1
264	2663	16	1214	2	Q1	2012	8.3400	3.9198	3.0000	1
264	2663	16	1228	8	Q3	2012	11.1200	5.1152	4.0000	1
264	2673	11	833	8	Q3	2012	5.5600	1.7792	2.0000	1
264	3149	11	829	6	Q2	2012	8.3400	3.7530	3.0000	1
264	3242	3	197	6	Q2	2012	8.3400	2.5854	3.0000	1
264	3668	7	0	6	Q2	2012	5.5600	1.8348	2.0000	1
264	3979	13	0	7	Q3	2012	8.3400	2.7522	3.0000	1
264	4094	16	0	10	Q4	2012	5.5600	1.6680	2.0000	1
264	4115	7	504	2	Q1	2012	8.3400	2.6688	3.0000	1
264	4118	17	0	4	Q2	2012	8.3400	2.8356	3.0000	1
264	4194	24	0	9	Q3	2012	8.3400	2.9190	3.0000	1
264	4322	15	0	1	Q1	2012	13.9000	4.1700	5.0000	1
264	4357	7	0	12	Q4	2012	5.5600	1.8348	2.0000	1
264	4422	6	0	12	Q4	2012	8.3400	2.9190	3.0000	1
264	4422	7	0	12	Q4	2012	5.5600	1.8904	2.0000	1
264	4643	22	0	6	Q2	2012	5.5600	2.6132	2.0000	1
264	4739	15	0	8	Q3	2012	11.1200	4.4480	4.0000	1
264	4992	6	508	4	Q2	2012	11.1200	4.1144	4.0000	1
264	5143	17	0	9	Q3	2012	11.1200	3.8920	4.0000	1
264	5305	11	837	10	Q4	2012	8.3400	2.5854	3.0000	1
264	5407	24	0	6	Q2	2012	8.3400	3.5028	3.0000	1
264	5625	24	0	12	Q4	2012	11.1200	5.3376	4.0000	1
264	5944	3	0	2	Q1	2012	5.5600	2.3908	2.0000	1
264	6452	11	842	12	Q4	2012	13.9000	4.8650	5.0000	1
264	6854	17	0	2	Q1	2012	8.3400	2.6688	3.0000	1
264	7040	11	818	1	Q1	2012	11.1200	5.1152	4.0000	1
264	7292	13	0	7	Q3	2012	11.1200	5.0040	4.0000	1
264	7319	13	976	1	Q1	2012	11.1200	3.3360	4.0000	1
264	7413	3	0	4	Q2	2012	5.5600	1.8348	2.0000	1
264	8074	17	0	7	Q3	2012	8.3400	3.2526	3.0000	1
264	8423	24	1869	12	Q4	2012	8.3400	3.2526	3.0000	1
264	8737	11	0	2	Q1	2012	8.3400	2.5854	3.0000	1
264	8794	17	0	6	Q2	2012	11.1200	3.4472	4.0000	1
264	8947	3	0	10	Q4	2012	8.3400	3.2526	3.0000	1
264	9017	15	1136	2	Q1	2012	11.1200	4.8928	4.0000	1
264	9065	13	0	12	Q4	2012	13.9000	6.1160	5.0000	1
264	9132	11	0	8	Q3	2012	5.5600	1.6680	2.0000	1
264	9286	13	0	12	Q4	2012	8.3400	3.5028	3.0000	1
264	9324	3	0	8	Q3	2012	5.5600	2.3908	2.0000	1
264	9390	7	505	2	Q1	2012	8.3400	3.1692	3.0000	1
264	9471	6	508	4	Q2	2012	8.3400	3.0024	3.0000	1
264	10145	13	0	8	Q3	2012	11.1200	4.4480	4.0000	1
265	169	13	0	1	Q1	2012	14.4400	5.3428	4.0000	1
265	505	7	516	8	Q3	2012	7.2200	2.2382	2.0000	1
265	532	13	0	8	Q3	2012	14.4400	5.0540	4.0000	1
265	621	11	0	11	Q4	2012	10.8300	5.0901	3.0000	1
265	863	17	0	6	Q2	2012	14.4400	5.0540	4.0000	1
265	870	24	0	5	Q2	2012	10.8300	3.2490	3.0000	1
265	878	3	0	6	Q2	2012	10.8300	4.0071	3.0000	1
265	924	3	0	6	Q2	2012	10.8300	4.2237	3.0000	1
265	976	16	1231	9	Q3	2012	10.8300	4.9818	3.0000	1
265	1173	13	0	6	Q2	2012	14.4400	6.0648	4.0000	1
265	1771	2	0	1	Q1	2012	3.6100	1.3718	1.0000	1
265	1832	23	0	12	Q4	2012	10.8300	3.8988	3.0000	1
265	1838	24	1851	4	Q2	2012	14.4400	4.6208	4.0000	1
265	1917	23	0	3	Q1	2012	7.2200	3.5378	2.0000	1
265	2102	6	0	12	Q4	2012	10.8300	3.8988	3.0000	1
265	2245	11	0	10	Q4	2012	7.2200	2.9602	2.0000	1
265	2493	17	1304	7	Q3	2012	14.4400	6.6424	4.0000	1
265	2910	15	0	2	Q1	2012	10.8300	3.6822	3.0000	1
265	3231	17	0	3	Q1	2012	10.8300	5.4150	3.0000	1
265	3253	13	982	4	Q2	2012	14.4400	5.6316	4.0000	1
265	3423	13	0	10	Q4	2012	10.8300	3.8988	3.0000	1
265	3462	6	508	4	Q2	2012	14.4400	5.0540	4.0000	1
265	3498	24	0	2	Q1	2012	10.8300	3.8988	3.0000	1
265	3540	24	0	10	Q4	2012	7.2200	2.8880	2.0000	1
265	3567	16	0	4	Q2	2012	10.8300	3.6822	3.0000	1
265	3742	11	0	12	Q4	2012	10.8300	3.3573	3.0000	1
265	3918	7	0	3	Q1	2012	14.4400	5.0540	4.0000	1
265	4322	15	0	10	Q4	2012	14.4400	6.9312	4.0000	1
265	5233	6	504	2	Q1	2012	7.2200	2.3104	2.0000	1
265	5346	3	0	12	Q4	2012	10.8300	4.8735	3.0000	1
265	5432	16	0	11	Q4	2012	10.8300	4.3320	3.0000	1
265	5790	17	0	5	Q2	2012	10.8300	4.8735	3.0000	1
265	5877	17	0	7	Q3	2012	10.8300	4.6569	3.0000	1
265	6291	3	0	12	Q4	2012	10.8300	4.3320	3.0000	1
265	6560	17	1307	8	Q3	2012	10.8300	3.6822	3.0000	1
265	6703	11	0	5	Q2	2012	7.2200	2.9602	2.0000	1
265	6958	6	0	5	Q2	2012	10.8300	5.4150	3.0000	1
265	7319	13	0	6	Q2	2012	10.8300	3.3573	3.0000	1
265	7470	13	0	5	Q2	2012	10.8300	3.8988	3.0000	1
265	7502	16	1231	9	Q3	2012	14.4400	4.7652	4.0000	1
265	7704	3	0	8	Q3	2012	10.8300	5.1984	3.0000	1
265	8291	13	0	10	Q4	2012	14.4400	5.4872	4.0000	1
265	8336	17	1303	6	Q2	2012	10.8300	3.6822	3.0000	1
265	8427	16	0	3	Q1	2012	14.4400	4.6208	4.0000	1
265	8887	17	0	7	Q3	2012	7.2200	3.4656	2.0000	1
265	9033	6	513	6	Q2	2012	10.8300	4.3320	3.0000	1
265	9788	13	0	3	Q1	2012	7.2200	2.7436	2.0000	1
265	9800	15	0	9	Q3	2012	14.4400	6.4980	4.0000	1
265	9857	24	0	7	Q3	2012	7.2200	2.5270	2.0000	1
265	10152	13	0	12	Q4	2012	7.2200	3.2490	2.0000	1
265	10182	24	0	9	Q3	2012	10.8300	3.8988	3.0000	1
265	10238	16	0	8	Q3	2012	7.2200	3.3212	2.0000	1
265	10248	15	0	11	Q4	2012	7.2200	3.2490	2.0000	1
266	326	2	0	12	Q4	2012	1.6200	0.5670	1.0000	1
266	612	22	0	9	Q3	2012	1.6200	0.6480	1.0000	1
266	878	3	0	6	Q2	2012	6.4800	2.3976	4.0000	1
266	1147	13	0	12	Q4	2012	3.2400	1.2312	2.0000	1
266	1297	16	0	11	Q4	2012	6.4800	2.2680	4.0000	1
266	1341	3	0	6	Q2	2012	6.4800	3.1104	4.0000	1
266	1821	13	0	12	Q4	2012	4.8600	2.4300	3.0000	1
266	2204	3	0	2	Q1	2012	4.8600	1.8954	3.0000	1
266	2829	23	1765	1	Q1	2012	3.2400	1.1016	2.0000	1
266	2981	23	0	9	Q3	2012	3.2400	1.2312	2.0000	1
266	3114	7	0	7	Q3	2012	8.1000	3.3210	5.0000	1
266	3160	17	0	2	Q1	2012	4.8600	1.8468	3.0000	1
266	3245	17	0	9	Q3	2012	3.2400	1.3932	2.0000	1
266	3508	6	0	11	Q4	2012	4.8600	1.8954	3.0000	1
266	3550	11	0	12	Q4	2012	3.2400	1.5876	2.0000	1
266	3669	24	0	7	Q3	2012	6.4800	3.1752	4.0000	1
266	3816	3	0	11	Q4	2012	4.8600	1.5552	3.0000	1
266	3817	6	508	4	Q2	2012	4.8600	1.9440	3.0000	1
266	3980	13	0	6	Q2	2012	4.8600	2.1870	3.0000	1
266	4021	16	0	9	Q3	2012	6.4800	3.1104	4.0000	1
266	4066	3	0	7	Q3	2012	6.4800	2.6568	4.0000	1
266	4188	6	0	4	Q2	2012	3.2400	1.4256	2.0000	1
266	5088	13	0	4	Q2	2012	3.2400	1.1340	2.0000	1
266	5105	11	829	6	Q2	2012	4.8600	1.8954	3.0000	1
266	5511	6	513	6	Q2	2012	4.8600	1.7496	3.0000	1
266	5587	7	0	12	Q4	2012	4.8600	2.2842	3.0000	1
266	5644	17	0	11	Q4	2012	4.8600	1.9440	3.0000	1
266	5686	3	0	12	Q4	2012	6.4800	2.2032	4.0000	1
266	5743	13	0	12	Q4	2012	4.8600	1.5552	3.0000	1
266	5809	13	0	11	Q4	2012	4.8600	1.5066	3.0000	1
266	5929	15	0	1	Q1	2012	4.8600	1.6038	3.0000	1
266	5962	17	0	1	Q1	2012	4.8600	1.5066	3.0000	1
266	6208	17	0	3	Q1	2012	6.4800	2.2680	4.0000	1
266	6372	17	0	10	Q4	2012	6.4800	2.0736	4.0000	1
266	6566	7	0	1	Q1	2012	3.2400	1.0692	2.0000	1
266	7384	3	0	11	Q4	2012	3.2400	1.1988	2.0000	1
266	7486	3	0	4	Q2	2012	6.4800	2.0736	4.0000	1
266	7607	17	0	5	Q2	2012	4.8600	1.7010	3.0000	1
266	7735	15	0	8	Q3	2012	3.2400	1.5228	2.0000	1
266	7851	7	0	12	Q4	2012	6.4800	2.4624	4.0000	1
266	7906	13	0	6	Q2	2012	6.4800	2.9160	4.0000	1
266	7920	17	0	9	Q3	2012	3.2400	1.2636	2.0000	1
266	8173	15	0	12	Q4	2012	3.2400	1.0044	2.0000	1
266	8269	13	0	8	Q3	2012	4.8600	1.7010	3.0000	1
266	8574	15	0	6	Q2	2012	6.4800	1.9440	4.0000	1
266	8586	24	1853	5	Q2	2012	6.4800	3.1752	4.0000	1
266	9040	16	0	6	Q2	2012	4.8600	2.1870	3.0000	1
266	9184	3	0	10	Q4	2012	3.2400	1.6200	2.0000	1
266	9558	6	524	11	Q4	2012	4.8600	1.7982	3.0000	1
266	9932	6	0	10	Q4	2012	6.4800	2.6568	4.0000	1
266	10116	17	1307	8	Q3	2012	6.4800	3.1752	4.0000	1
267	110	7	0	7	Q3	2012	2.4900	1.1205	3.0000	1
267	711	17	0	8	Q3	2012	3.3200	1.3944	4.0000	1
267	1230	14	1072	9	Q3	2012	1.6600	0.8300	2.0000	1
267	1491	16	1220	4	Q2	2012	2.4900	0.7968	3.0000	1
267	1847	11	829	6	Q2	2012	1.6600	0.7470	2.0000	1
267	1983	17	0	3	Q1	2012	3.3200	1.2284	4.0000	1
267	2067	17	0	7	Q3	2012	3.3200	1.4276	4.0000	1
267	2180	2	0	12	Q4	2012	2.4900	0.9462	3.0000	1
267	2293	7	0	5	Q2	2012	2.4900	1.0956	3.0000	1
267	2832	13	0	10	Q4	2012	2.4900	0.8964	3.0000	1
267	2856	13	988	7	Q3	2012	2.4900	0.9462	3.0000	1
267	3293	11	826	5	Q2	2012	2.4900	0.9960	3.0000	1
267	3334	17	1307	8	Q3	2012	1.6600	0.7138	2.0000	1
267	3401	11	0	6	Q2	2012	2.4900	0.8466	3.0000	1
267	3441	3	202	8	Q3	2012	1.6600	0.5312	2.0000	1
267	3533	3	0	7	Q3	2012	3.3200	1.3612	4.0000	1
267	3742	11	0	2	Q1	2012	2.4900	1.2201	3.0000	1
267	3886	15	1150	8	Q3	2012	2.4900	1.1952	3.0000	1
267	3950	13	0	5	Q2	2012	3.3200	1.4940	4.0000	1
267	4029	17	0	12	Q4	2012	2.4900	0.9462	3.0000	1
267	4253	13	0	7	Q3	2012	2.4900	0.7470	3.0000	1
267	4439	15	1134	1	Q1	2012	3.3200	1.0956	4.0000	1
267	4543	13	988	7	Q3	2012	2.4900	0.8964	3.0000	1
267	4634	24	0	12	Q4	2012	3.3200	1.2284	4.0000	1
267	4833	24	0	3	Q1	2012	2.4900	1.0707	3.0000	1
267	5650	2	0	9	Q3	2012	0.8300	0.3818	1.0000	1
267	6172	15	1136	2	Q1	2012	3.3200	1.4608	4.0000	1
267	6866	17	0	3	Q1	2012	2.4900	1.1205	3.0000	1
267	7056	3	210	12	Q4	2012	2.4900	0.7470	3.0000	1
267	7292	13	0	12	Q4	2012	3.3200	1.3612	4.0000	1
267	7997	13	0	4	Q2	2012	4.1500	1.5355	5.0000	1
267	8304	13	0	1	Q1	2012	3.3200	1.6268	4.0000	1
267	8408	6	511	5	Q2	2012	3.3200	1.2948	4.0000	1
267	8473	13	0	5	Q2	2012	1.6600	0.7636	2.0000	1
267	8993	24	0	3	Q1	2012	2.4900	0.7470	3.0000	1
267	9125	13	0	7	Q3	2012	2.4900	0.9213	3.0000	1
267	9169	23	1786	10	Q4	2012	3.3200	1.3612	4.0000	1
267	9256	13	0	9	Q3	2012	1.6600	0.7138	2.0000	1
267	9263	16	1220	4	Q2	2012	2.4900	1.1205	3.0000	1
267	9309	17	0	9	Q3	2012	3.3200	1.6600	4.0000	1
267	9673	13	0	11	Q4	2012	3.3200	1.3944	4.0000	1
267	9699	15	1152	9	Q3	2012	4.1500	1.4940	5.0000	1
267	9787	13	0	5	Q2	2012	2.4900	0.8217	3.0000	1
267	9825	13	0	12	Q4	2012	3.3200	1.1620	4.0000	1
267	9937	17	1304	7	Q3	2012	2.4900	1.0458	3.0000	1
267	9976	17	0	2	Q1	2012	1.6600	0.4980	2.0000	1
268	265	11	0	9	Q3	2012	3.4600	1.4532	2.0000	1
268	378	16	1231	9	Q3	2012	3.4600	1.3840	2.0000	1
268	504	13	0	12	Q4	2012	3.4600	1.2456	2.0000	1
268	863	17	0	3	Q1	2012	3.4600	1.6608	2.0000	1
268	1005	3	190	3	Q1	2012	3.4600	1.2456	2.0000	1
268	1066	14	0	3	Q1	2012	1.7300	0.7439	1.0000	1
268	1280	6	0	6	Q2	2012	5.1900	1.6089	3.0000	1
268	1313	15	0	1	Q1	2012	6.9200	2.8372	4.0000	1
268	1567	16	0	9	Q3	2012	5.1900	1.8684	3.0000	1
268	1634	3	187	2	Q1	2012	5.1900	2.1798	3.0000	1
268	1720	16	0	7	Q3	2012	5.1900	1.9203	3.0000	1
268	1773	13	982	4	Q2	2012	6.9200	2.3528	4.0000	1
268	2200	7	523	11	Q4	2012	3.4600	1.4878	2.0000	1
268	2206	6	510	5	Q2	2012	5.1900	2.3874	3.0000	1
268	2215	11	0	12	Q4	2012	5.1900	2.0760	3.0000	1
268	2371	16	1214	2	Q1	2012	5.1900	2.3355	3.0000	1
268	2507	3	0	5	Q2	2012	6.9200	2.4220	4.0000	1
268	2688	7	0	4	Q2	2012	5.1900	2.2836	3.0000	1
268	2690	3	185	1	Q1	2012	3.4600	1.4878	2.0000	1
268	3019	11	0	3	Q1	2012	5.1900	2.0241	3.0000	1
268	3253	13	0	7	Q3	2012	6.9200	2.6988	4.0000	1
268	3441	3	0	9	Q3	2012	5.1900	1.9203	3.0000	1
268	3458	24	0	8	Q3	2012	8.6500	3.3735	5.0000	1
268	3645	2	114	4	Q2	2012	1.7300	0.6574	1.0000	1
268	3954	24	0	10	Q4	2012	5.1900	1.9722	3.0000	1
268	4357	7	0	12	Q4	2012	5.1900	2.4393	3.0000	1
268	4405	13	0	9	Q3	2012	6.9200	2.8372	4.0000	1
268	4859	14	1079	12	Q4	2012	3.4600	1.1072	2.0000	1
268	5206	13	0	12	Q4	2012	5.1900	1.7127	3.0000	1
268	5526	15	0	2	Q1	2012	5.1900	1.7646	3.0000	1
268	5623	7	0	12	Q4	2012	6.9200	3.2524	4.0000	1
268	5834	11	0	4	Q2	2012	5.1900	2.5431	3.0000	1
268	5867	11	829	6	Q2	2012	6.9200	2.7680	4.0000	1
268	5879	6	0	12	Q4	2012	3.4600	1.6954	2.0000	1
268	5931	24	0	8	Q3	2012	6.9200	3.4600	4.0000	1
268	6720	15	0	12	Q4	2012	5.1900	1.5570	3.0000	1
268	6946	7	0	10	Q4	2012	6.9200	3.3216	4.0000	1
268	7234	16	1225	7	Q3	2012	5.1900	2.0241	3.0000	1
268	7589	17	0	9	Q3	2012	5.1900	2.3355	3.0000	1
268	7777	24	0	5	Q2	2012	5.1900	1.6608	3.0000	1
268	8304	13	0	4	Q2	2012	5.1900	1.8684	3.0000	1
268	8448	24	1866	11	Q4	2012	5.1900	2.3874	3.0000	1
268	8889	11	821	3	Q1	2012	5.1900	2.3355	3.0000	1
268	9176	23	1775	5	Q2	2012	6.9200	2.2836	4.0000	1
268	9299	24	1860	8	Q3	2012	5.1900	1.9722	3.0000	1
268	9368	15	0	5	Q2	2012	6.9200	3.0448	4.0000	1
268	9534	17	0	3	Q1	2012	5.1900	2.4393	3.0000	1
268	9712	6	0	2	Q1	2012	5.1900	1.9722	3.0000	1
268	9862	7	0	1	Q1	2012	3.4600	1.5916	2.0000	1
269	148	15	0	8	Q3	2012	8.5200	3.5784	3.0000	1
269	405	6	523	11	Q4	2012	11.3600	4.5440	4.0000	1
269	588	23	0	12	Q4	2012	14.2000	4.6860	5.0000	1
269	647	3	0	1	Q1	2012	5.6800	2.4992	2.0000	1
269	927	6	504	2	Q1	2012	14.2000	5.8220	5.0000	1
269	930	17	1304	7	Q3	2012	11.3600	4.2032	4.0000	1
269	976	16	0	12	Q4	2012	8.5200	3.0672	3.0000	1
269	1266	13	980	3	Q1	2012	11.3600	4.0896	4.0000	1
269	2019	16	1225	7	Q3	2012	14.2000	5.8220	5.0000	1
269	2189	6	0	10	Q4	2012	11.3600	4.5440	4.0000	1
269	2681	7	0	12	Q4	2012	14.2000	4.4020	5.0000	1
269	2759	2	0	7	Q3	2012	2.8400	0.9088	1.0000	1
269	2763	15	1140	4	Q2	2012	5.6800	2.4992	2.0000	1
269	3003	7	0	6	Q2	2012	8.5200	2.5560	3.0000	1
269	3173	11	0	3	Q1	2012	5.6800	1.9312	2.0000	1
269	3217	2	0	10	Q4	2012	5.6800	2.7264	2.0000	1
269	3285	6	0	4	Q2	2012	5.6800	2.6696	2.0000	1
269	3385	15	0	9	Q3	2012	8.5200	4.1748	3.0000	1
269	3908	6	0	12	Q4	2012	5.6800	1.9880	2.0000	1
269	4180	7	0	6	Q2	2012	11.3600	3.6352	4.0000	1
269	4274	11	0	6	Q2	2012	8.5200	2.8968	3.0000	1
269	4304	15	0	7	Q3	2012	8.5200	2.8116	3.0000	1
269	4450	7	0	1	Q1	2012	11.3600	4.8848	4.0000	1
269	4460	3	0	12	Q4	2012	11.3600	5.5664	4.0000	1
269	4597	17	0	6	Q2	2012	5.6800	2.0448	2.0000	1
269	4813	7	0	1	Q1	2012	8.5200	2.5560	3.0000	1
269	5271	15	0	9	Q3	2012	8.5200	2.6412	3.0000	1
269	5696	15	0	11	Q4	2012	5.6800	2.2720	2.0000	1
269	6018	11	0	5	Q2	2012	8.5200	2.5560	3.0000	1
269	6060	11	0	7	Q3	2012	8.5200	2.8116	3.0000	1
269	6113	16	0	8	Q3	2012	8.5200	3.5784	3.0000	1
269	6148	11	0	11	Q4	2012	8.5200	2.8116	3.0000	1
269	6551	11	842	12	Q4	2012	5.6800	1.9312	2.0000	1
269	6559	3	0	4	Q2	2012	8.5200	4.1748	3.0000	1
269	6595	2	0	11	Q4	2012	2.8400	1.0224	1.0000	1
269	6712	16	0	8	Q3	2012	14.2000	6.3900	5.0000	1
269	6805	7	518	8	Q3	2012	8.5200	3.2376	3.0000	1
269	6977	24	0	4	Q2	2012	8.5200	4.1748	3.0000	1
269	7117	15	0	6	Q2	2012	5.6800	2.3288	2.0000	1
269	7283	13	0	12	Q4	2012	11.3600	5.4528	4.0000	1
269	7669	11	0	4	Q2	2012	8.5200	3.9192	3.0000	1
269	8289	17	0	9	Q3	2012	5.6800	1.8744	2.0000	1
269	8439	13	0	6	Q2	2012	8.5200	3.3228	3.0000	1
269	8504	13	0	3	Q1	2012	8.5200	3.8340	3.0000	1
269	8559	6	0	9	Q3	2012	5.6800	2.0448	2.0000	1
269	8700	7	504	2	Q1	2012	8.5200	4.0044	3.0000	1
269	8859	15	0	11	Q4	2012	8.5200	3.4080	3.0000	1
269	9133	24	1860	8	Q3	2012	11.3600	3.9760	4.0000	1
269	9224	17	0	9	Q3	2012	8.5200	3.9192	3.0000	1
269	9276	7	523	11	Q4	2012	8.5200	3.4080	3.0000	1
269	9331	11	0	9	Q3	2012	5.6800	1.8744	2.0000	1
269	9453	15	0	12	Q4	2012	11.3600	4.9984	4.0000	1
269	9991	7	0	8	Q3	2012	11.3600	3.6352	4.0000	1
270	169	13	0	3	Q1	2012	4.4800	2.1056	2.0000	1
270	547	24	0	8	Q3	2012	6.7200	3.0240	3.0000	1
270	614	17	1297	3	Q1	2012	6.7200	2.7552	3.0000	1
270	663	16	0	6	Q2	2012	8.9600	3.2256	4.0000	1
270	1298	17	1312	10	Q4	2012	6.7200	3.2256	3.0000	1
270	1341	3	0	6	Q2	2012	6.7200	2.6880	3.0000	1
270	1738	6	0	1	Q1	2012	6.7200	3.2928	3.0000	1
270	1798	3	205	10	Q4	2012	6.7200	2.6208	3.0000	1
270	1957	13	0	6	Q2	2012	8.9600	4.0320	4.0000	1
270	2034	24	1856	6	Q2	2012	6.7200	3.2928	3.0000	1
270	2052	13	0	9	Q3	2012	6.7200	2.1504	3.0000	1
270	2185	14	1064	5	Q2	2012	4.4800	1.5232	2.0000	1
270	2376	11	0	1	Q1	2012	6.7200	2.8224	3.0000	1
270	2442	24	0	7	Q3	2012	8.9600	2.6880	4.0000	1
270	2568	11	0	4	Q2	2012	8.9600	3.2256	4.0000	1
270	2687	24	0	9	Q3	2012	8.9600	3.4048	4.0000	1
270	2690	3	190	3	Q1	2012	6.7200	2.4192	3.0000	1
270	2756	3	0	11	Q4	2012	6.7200	2.4864	3.0000	1
270	2968	13	0	11	Q4	2012	6.7200	2.8896	3.0000	1
270	3054	24	0	4	Q2	2012	8.9600	2.7776	4.0000	1
270	3242	3	0	4	Q2	2012	6.7200	2.0832	3.0000	1
270	3273	11	0	6	Q2	2012	4.4800	1.6128	2.0000	1
270	3669	24	0	7	Q3	2012	6.7200	2.2176	3.0000	1
270	4094	16	0	3	Q1	2012	8.9600	2.7776	4.0000	1
270	4267	7	0	1	Q1	2012	6.7200	2.6880	3.0000	1
270	4900	13	0	3	Q1	2012	4.4800	1.4784	2.0000	1
270	5256	17	0	4	Q2	2012	6.7200	2.6208	3.0000	1
270	5616	17	0	4	Q2	2012	6.7200	2.7552	3.0000	1
270	5811	6	0	5	Q2	2012	8.9600	4.2112	4.0000	1
270	6107	3	0	4	Q2	2012	11.2000	5.3760	5.0000	1
270	6114	16	0	1	Q1	2012	4.4800	2.1504	2.0000	1
270	6163	13	0	3	Q1	2012	4.4800	1.4784	2.0000	1
270	6564	13	0	9	Q3	2012	4.4800	1.8816	2.0000	1
270	6970	7	0	7	Q3	2012	8.9600	4.3008	4.0000	1
270	7090	14	0	9	Q3	2012	2.2400	0.9856	1.0000	1
270	7141	17	0	12	Q4	2012	4.4800	1.4784	2.0000	1
270	7368	11	826	5	Q2	2012	6.7200	2.2848	3.0000	1
270	7546	13	0	9	Q3	2012	4.4800	2.1952	2.0000	1
270	7612	7	0	8	Q3	2012	6.7200	2.4864	3.0000	1
270	7733	13	984	5	Q2	2012	4.4800	1.9264	2.0000	1
270	7985	24	0	7	Q3	2012	11.2000	3.6960	5.0000	1
270	9112	7	519	9	Q3	2012	6.7200	3.2256	3.0000	1
270	9487	17	0	12	Q4	2012	6.7200	2.8224	3.0000	1
270	9745	17	1294	2	Q1	2012	8.9600	2.9568	4.0000	1
270	10031	24	0	6	Q2	2012	6.7200	2.8224	3.0000	1
271	417	7	0	11	Q4	2012	7.1100	3.1995	3.0000	1
271	511	16	1233	10	Q4	2012	7.1100	2.3463	3.0000	1
271	817	17	1293	1	Q1	2012	4.7400	2.0856	2.0000	1
271	997	3	0	10	Q4	2012	9.4800	4.0764	4.0000	1
271	1196	13	0	1	Q1	2012	9.4800	3.6024	4.0000	1
271	1297	16	1235	11	Q4	2012	9.4800	3.3180	4.0000	1
271	1575	13	0	11	Q4	2012	9.4800	3.8868	4.0000	1
271	1706	13	0	7	Q3	2012	7.1100	3.1284	3.0000	1
271	1718	13	0	11	Q4	2012	9.4800	4.0764	4.0000	1
271	2019	16	0	12	Q4	2012	7.1100	2.5596	3.0000	1
271	2171	23	1773	4	Q2	2012	7.1100	2.3463	3.0000	1
271	2201	16	0	4	Q2	2012	7.1100	3.0573	3.0000	1
271	2296	6	510	5	Q2	2012	9.4800	3.7920	4.0000	1
271	2523	6	518	8	Q3	2012	7.1100	2.1330	3.0000	1
271	2568	11	0	8	Q3	2012	7.1100	2.1330	3.0000	1
271	2723	3	197	6	Q2	2012	4.7400	2.0382	2.0000	1
271	2846	11	0	7	Q3	2012	9.4800	3.0336	4.0000	1
271	2981	23	0	7	Q3	2012	7.1100	3.1995	3.0000	1
271	3160	17	1293	1	Q1	2012	4.7400	1.9434	2.0000	1
271	3452	24	1850	3	Q1	2012	9.4800	4.2660	4.0000	1
271	3742	11	837	10	Q4	2012	4.7400	1.9434	2.0000	1
271	4259	15	0	8	Q3	2012	7.1100	3.4128	3.0000	1
271	4534	6	0	3	Q1	2012	9.4800	2.8440	4.0000	1
271	4778	3	0	12	Q4	2012	7.1100	3.1284	3.0000	1
271	4803	23	0	1	Q1	2012	4.7400	1.6590	2.0000	1
271	5032	15	0	6	Q2	2012	4.7400	1.4220	2.0000	1
271	5038	17	0	10	Q4	2012	7.1100	2.1330	3.0000	1
271	5686	3	0	6	Q2	2012	7.1100	2.2752	3.0000	1
271	5903	13	0	9	Q3	2012	7.1100	2.2752	3.0000	1
271	5942	7	0	5	Q2	2012	7.1100	3.3417	3.0000	1
271	6208	17	0	8	Q3	2012	9.4800	3.8868	4.0000	1
271	6307	16	1233	10	Q4	2012	9.4800	3.6024	4.0000	1
271	6372	17	1314	11	Q4	2012	7.1100	3.1995	3.0000	1
271	6423	17	0	12	Q4	2012	7.1100	3.4128	3.0000	1
271	6567	15	0	8	Q3	2012	11.8500	5.9250	5.0000	1
271	6624	15	0	2	Q1	2012	9.4800	3.8868	4.0000	1
271	6835	16	0	3	Q1	2012	7.1100	2.6307	3.0000	1
271	7267	6	526	12	Q4	2012	9.4800	3.5076	4.0000	1
271	7384	3	207	11	Q4	2012	4.7400	1.7538	2.0000	1
271	7541	24	0	9	Q3	2012	7.1100	2.2752	3.0000	1
271	7641	13	0	11	Q4	2012	7.1100	2.5596	3.0000	1
271	7656	2	0	3	Q1	2012	4.7400	1.8012	2.0000	1
271	7809	2	118	6	Q2	2012	2.3700	1.1139	1.0000	1
271	7913	17	0	2	Q1	2012	7.1100	2.1330	3.0000	1
271	8172	17	1303	6	Q2	2012	9.4800	2.9388	4.0000	1
271	8255	11	842	12	Q4	2012	7.1100	2.7018	3.0000	1
271	8370	11	837	10	Q4	2012	4.7400	1.7064	2.0000	1
271	8374	3	0	11	Q4	2012	7.1100	3.2706	3.0000	1
271	8667	13	0	8	Q3	2012	7.1100	2.7018	3.0000	1
271	8858	6	0	9	Q3	2012	4.7400	2.2752	2.0000	1
271	8975	15	1154	10	Q4	2012	4.7400	2.2752	2.0000	1
271	9040	16	0	10	Q4	2012	7.1100	3.0573	3.0000	1
271	9101	7	0	12	Q4	2012	9.4800	3.5076	4.0000	1
271	9102	3	0	1	Q1	2012	7.1100	2.4885	3.0000	1
271	9111	17	0	11	Q4	2012	4.7400	1.8012	2.0000	1
271	9151	15	0	7	Q3	2012	9.4800	3.9816	4.0000	1
271	9318	16	1225	7	Q3	2012	7.1100	3.1284	3.0000	1
271	9366	17	0	3	Q1	2012	4.7400	1.8486	2.0000	1
271	9513	15	0	3	Q1	2012	4.7400	1.6116	2.0000	1
271	9694	7	504	2	Q1	2012	4.7400	1.7064	2.0000	1
271	9698	23	0	9	Q3	2012	7.1100	2.2752	3.0000	1
271	9932	6	0	12	Q4	2012	7.1100	3.4128	3.0000	1
271	10067	6	0	8	Q3	2012	7.1100	3.0573	3.0000	1
271	10182	24	0	12	Q4	2012	4.7400	1.5642	2.0000	1
272	591	11	0	4	Q2	2012	15.6400	5.6304	4.0000	1
272	742	15	0	6	Q2	2012	19.5500	6.0605	5.0000	1
272	769	16	0	1	Q1	2012	11.7300	4.3401	3.0000	1
272	923	15	1138	3	Q1	2012	11.7300	4.3401	3.0000	1
272	1035	13	0	8	Q3	2012	7.8200	3.5190	2.0000	1
272	1321	15	0	6	Q2	2012	11.7300	5.2785	3.0000	1
272	1345	17	0	3	Q1	2012	19.5500	7.2335	5.0000	1
272	1415	16	0	6	Q2	2012	15.6400	6.0996	4.0000	1
272	1428	24	0	6	Q2	2012	15.6400	7.5072	4.0000	1
272	1587	11	0	7	Q3	2012	11.7300	5.0439	3.0000	1
272	1633	3	0	5	Q2	2012	11.7300	4.2228	3.0000	1
272	1761	24	0	11	Q4	2012	11.7300	5.3958	3.0000	1
272	1887	11	842	12	Q4	2012	11.7300	4.9266	3.0000	1
272	2469	15	1140	4	Q2	2012	11.7300	5.0439	3.0000	1
272	2523	6	0	4	Q2	2012	11.7300	3.6363	3.0000	1
272	2674	11	0	9	Q3	2012	11.7300	3.8709	3.0000	1
272	2757	6	0	11	Q4	2012	15.6400	7.0380	4.0000	1
272	2857	6	0	12	Q4	2012	11.7300	5.3958	3.0000	1
272	3076	7	501	1	Q1	2012	11.7300	4.1055	3.0000	1
272	3198	7	0	11	Q4	2012	11.7300	5.7477	3.0000	1
272	3202	11	0	1	Q1	2012	7.8200	2.9716	2.0000	1
272	3202	11	829	6	Q2	2012	7.8200	3.1280	2.0000	1
272	3250	15	0	3	Q1	2012	7.8200	3.4408	2.0000	1
272	3352	7	504	2	Q1	2012	11.7300	5.6304	3.0000	1
272	3412	11	0	1	Q1	2012	11.7300	4.6920	3.0000	1
272	4082	24	0	10	Q4	2012	15.6400	5.4740	4.0000	1
272	4316	22	0	12	Q4	2012	3.9100	1.7595	1.0000	1
272	4609	23	0	9	Q3	2012	15.6400	7.1944	4.0000	1
272	4680	6	0	4	Q2	2012	11.7300	4.8093	3.0000	1
272	5392	14	1079	12	Q4	2012	3.9100	1.6813	1.0000	1
272	5432	16	1233	10	Q4	2012	15.6400	6.8816	4.0000	1
272	5485	14	1071	8	Q3	2012	7.8200	2.6588	2.0000	1
272	5720	2	0	7	Q3	2012	7.8200	3.8318	2.0000	1
272	6278	7	0	3	Q1	2012	7.8200	3.7536	2.0000	1
272	6288	13	0	9	Q3	2012	15.6400	6.8816	4.0000	1
272	6388	11	0	11	Q4	2012	7.8200	2.6588	2.0000	1
272	6592	13	0	6	Q2	2012	11.7300	3.8709	3.0000	1
272	6832	3	0	10	Q4	2012	11.7300	4.1055	3.0000	1
272	7250	13	0	2	Q1	2012	11.7300	4.4574	3.0000	1
272	7370	23	0	5	Q2	2012	11.7300	4.3401	3.0000	1
272	7621	13	0	12	Q4	2012	11.7300	5.2785	3.0000	1
272	7641	13	0	11	Q4	2012	11.7300	4.2228	3.0000	1
272	7713	17	0	5	Q2	2012	15.6400	6.4124	4.0000	1
272	7849	3	0	7	Q3	2012	11.7300	4.4574	3.0000	1
272	7849	3	205	10	Q4	2012	7.8200	2.5806	2.0000	1
272	8153	24	1869	12	Q4	2012	11.7300	3.7536	3.0000	1
272	8275	16	0	8	Q3	2012	11.7300	5.6304	3.0000	1
272	8577	23	1765	1	Q1	2012	11.7300	3.6363	3.0000	1
272	8730	6	524	11	Q4	2012	11.7300	5.0439	3.0000	1
272	8782	7	517	8	Q3	2012	7.8200	3.3626	2.0000	1
272	9315	7	516	8	Q3	2012	11.7300	4.2228	3.0000	1
272	9318	16	0	12	Q4	2012	7.8200	2.8934	2.0000	1
272	9860	11	0	8	Q3	2012	7.8200	3.3626	2.0000	1
272	10019	11	820	2	Q1	2012	11.7300	4.3401	3.0000	1
273	355	3	0	4	Q2	2012	6.5400	2.5506	3.0000	1
273	467	13	0	5	Q2	2012	8.7200	4.3600	4.0000	1
273	769	16	0	5	Q2	2012	10.9000	3.4880	5.0000	1
273	892	7	505	2	Q1	2012	4.3600	2.1800	2.0000	1
273	927	7	0	11	Q4	2012	10.9000	4.7960	5.0000	1
273	988	15	0	8	Q3	2012	6.5400	2.0274	3.0000	1
273	1491	16	0	3	Q1	2012	6.5400	2.8122	3.0000	1
273	1681	13	0	6	Q2	2012	10.9000	4.7960	5.0000	1
273	1762	24	0	7	Q3	2012	6.5400	3.0738	3.0000	1
273	1974	22	0	9	Q3	2012	4.3600	1.4824	2.0000	1
273	2052	13	0	9	Q3	2012	6.5400	2.9430	3.0000	1
273	2448	16	0	12	Q4	2012	8.7200	3.3136	4.0000	1
273	2535	24	1859	8	Q3	2012	8.7200	3.8368	4.0000	1
273	3397	17	0	3	Q1	2012	4.3600	1.8748	2.0000	1
273	3647	13	980	3	Q1	2012	4.3600	1.5260	2.0000	1
273	3692	16	1235	11	Q4	2012	8.7200	3.8368	4.0000	1
273	4396	13	0	1	Q1	2012	6.5400	3.0084	3.0000	1
273	4450	7	0	1	Q1	2012	6.5400	2.2236	3.0000	1
273	4676	16	1216	2	Q1	2012	6.5400	2.5506	3.0000	1
273	4842	7	0	1	Q1	2012	4.3600	1.7440	2.0000	1
273	4892	17	1307	8	Q3	2012	6.5400	3.0084	3.0000	1
273	5206	13	984	5	Q2	2012	4.3600	1.9184	2.0000	1
273	5302	11	0	11	Q4	2012	6.5400	2.0274	3.0000	1
273	5405	11	829	6	Q2	2012	4.3600	1.4388	2.0000	1
273	5429	11	0	3	Q1	2012	6.5400	2.2890	3.0000	1
273	5655	7	504	2	Q1	2012	6.5400	3.0738	3.0000	1
273	5690	7	0	11	Q4	2012	4.3600	1.6132	2.0000	1
273	6531	13	0	9	Q3	2012	4.3600	1.3080	2.0000	1
273	7234	16	0	8	Q3	2012	6.5400	2.6160	3.0000	1
273	7281	17	0	7	Q3	2012	8.7200	2.8776	4.0000	1
273	7607	17	0	5	Q2	2012	8.7200	2.6160	4.0000	1
273	8666	24	1858	7	Q3	2012	8.7200	2.7032	4.0000	1
273	9047	15	1157	12	Q4	2012	8.7200	4.2728	4.0000	1
273	9200	16	0	10	Q4	2012	6.5400	2.9430	3.0000	1
273	9248	15	0	12	Q4	2012	6.5400	2.6814	3.0000	1
273	9331	11	0	9	Q3	2012	6.5400	2.3544	3.0000	1
273	9671	13	0	7	Q3	2012	4.3600	1.8748	2.0000	1
274	161	24	1856	6	Q2	2012	11.2200	4.7124	3.0000	1
274	187	13	0	8	Q3	2012	14.9600	5.5352	4.0000	1
274	376	11	0	11	Q4	2012	11.2200	3.4782	3.0000	1
274	391	7	516	8	Q3	2012	11.2200	3.5904	3.0000	1
274	517	7	521	10	Q4	2012	14.9600	5.0864	4.0000	1
274	569	23	1789	12	Q4	2012	14.9600	4.7872	4.0000	1
274	806	17	0	2	Q1	2012	7.4800	3.6652	2.0000	1
274	916	7	0	9	Q3	2012	7.4800	2.9920	2.0000	1
274	1168	17	1303	6	Q2	2012	14.9600	6.5824	4.0000	1
274	1209	24	0	8	Q3	2012	11.2200	4.1514	3.0000	1
274	1281	3	188	2	Q1	2012	14.9600	5.5352	4.0000	1
274	1309	24	0	9	Q3	2012	11.2200	5.3856	3.0000	1
274	1599	6	0	6	Q2	2012	11.2200	3.7026	3.0000	1
274	1889	24	0	8	Q3	2012	7.4800	2.3936	2.0000	1
274	1893	13	0	7	Q3	2012	18.7000	5.7970	5.0000	1
274	1983	17	1307	8	Q3	2012	11.2200	4.7124	3.0000	1
274	2289	6	0	9	Q3	2012	7.4800	2.8424	2.0000	1
274	2511	17	1303	6	Q2	2012	11.2200	4.0392	3.0000	1
274	2625	13	0	2	Q1	2012	7.4800	3.3660	2.0000	1
274	2645	22	0	1	Q1	2012	7.4800	2.8424	2.0000	1
274	2924	3	207	11	Q4	2012	11.2200	5.4978	3.0000	1
274	3239	17	0	4	Q2	2012	14.9600	5.8344	4.0000	1
274	3279	6	504	2	Q1	2012	11.2200	5.4978	3.0000	1
274	3389	7	0	11	Q4	2012	7.4800	2.6928	2.0000	1
274	3702	7	505	2	Q1	2012	11.2200	3.5904	3.0000	1
274	3731	15	0	2	Q1	2012	11.2200	3.5904	3.0000	1
274	3906	15	0	2	Q1	2012	11.2200	3.9270	3.0000	1
274	3930	15	1154	10	Q4	2012	7.4800	3.5904	2.0000	1
274	4094	16	0	9	Q3	2012	7.4800	2.9920	2.0000	1
274	4261	13	0	11	Q4	2012	11.2200	4.4880	3.0000	1
274	4321	15	1154	10	Q4	2012	18.7000	6.9190	5.0000	1
274	4544	6	0	6	Q2	2012	14.9600	4.6376	4.0000	1
274	4608	11	833	8	Q3	2012	11.2200	4.3758	3.0000	1
274	4739	15	0	12	Q4	2012	11.2200	3.7026	3.0000	1
274	4862	15	0	9	Q3	2012	11.2200	5.6100	3.0000	1
274	4873	17	0	9	Q3	2012	14.9600	7.1808	4.0000	1
274	5095	6	0	4	Q2	2012	18.7000	8.7890	5.0000	1
274	5278	11	0	3	Q1	2012	7.4800	3.2164	2.0000	1
274	5299	14	0	12	Q4	2012	7.4800	2.3188	2.0000	1
274	5501	17	0	10	Q4	2012	14.9600	5.8344	4.0000	1
274	5607	7	0	4	Q2	2012	11.2200	4.0392	3.0000	1
274	5877	17	0	12	Q4	2012	11.2200	5.4978	3.0000	1
274	5983	6	515	7	Q3	2012	14.9600	5.6848	4.0000	1
274	5992	15	0	9	Q3	2012	14.9600	5.3856	4.0000	1
274	6141	7	523	11	Q4	2012	11.2200	3.8148	3.0000	1
274	7524	15	0	9	Q3	2012	14.9600	7.1808	4.0000	1
274	7626	6	0	9	Q3	2012	11.2200	3.4782	3.0000	1
274	7655	17	0	4	Q2	2012	14.9600	5.6848	4.0000	1
274	7919	2	121	8	Q3	2012	3.7400	1.3090	1.0000	1
274	8046	7	0	12	Q4	2012	11.2200	4.3758	3.0000	1
274	8089	17	1303	6	Q2	2012	7.4800	2.9172	2.0000	1
274	8452	16	0	1	Q1	2012	18.7000	6.5450	5.0000	1
274	8505	6	502	1	Q1	2012	14.9600	5.2360	4.0000	1
274	8699	7	0	6	Q2	2012	11.2200	3.3660	3.0000	1
274	9510	16	0	10	Q4	2012	14.9600	4.9368	4.0000	1
274	9511	24	1858	7	Q3	2012	7.4800	3.2164	2.0000	1
274	10147	7	0	10	Q4	2012	7.4800	2.6180	2.0000	1
275	178	13	0	7	Q3	2012	9.8100	4.2183	3.0000	1
275	267	7	0	5	Q2	2012	6.5400	2.4852	2.0000	1
275	328	11	0	9	Q3	2012	9.8100	3.9240	3.0000	1
275	354	23	0	10	Q4	2012	13.0800	4.4472	4.0000	1
275	360	24	0	11	Q4	2012	9.8100	4.1202	3.0000	1
275	1144	7	0	4	Q2	2012	9.8100	3.1392	3.0000	1
275	2061	3	0	11	Q4	2012	9.8100	2.9430	3.0000	1
275	2143	17	0	2	Q1	2012	6.5400	2.6814	2.0000	1
275	2224	16	0	11	Q4	2012	9.8100	3.4335	3.0000	1
275	2424	6	508	4	Q2	2012	13.0800	6.1476	4.0000	1
275	2438	6	0	1	Q1	2012	13.0800	5.7552	4.0000	1
275	2556	3	0	5	Q2	2012	13.0800	4.1856	4.0000	1
275	2688	6	0	7	Q3	2012	9.8100	3.5316	3.0000	1
275	2850	3	0	7	Q3	2012	9.8100	3.3354	3.0000	1
275	3020	13	984	5	Q2	2012	9.8100	4.7088	3.0000	1
275	3075	23	0	3	Q1	2012	9.8100	3.1392	3.0000	1
275	3321	24	0	3	Q1	2012	13.0800	6.4092	4.0000	1
275	3533	3	0	6	Q2	2012	9.8100	4.8069	3.0000	1
275	3604	15	0	2	Q1	2012	6.5400	2.8122	2.0000	1
275	3711	3	0	1	Q1	2012	9.8100	4.2183	3.0000	1
275	3888	7	0	4	Q2	2012	6.5400	2.8122	2.0000	1
275	3921	23	0	9	Q3	2012	13.0800	5.3628	4.0000	1
275	4417	3	199	7	Q3	2012	9.8100	4.3164	3.0000	1
275	4464	15	1140	4	Q2	2012	13.0800	4.5780	4.0000	1
275	4726	11	833	8	Q3	2012	6.5400	1.9620	2.0000	1
275	4787	2	0	1	Q1	2012	6.5400	2.0274	2.0000	1
275	4873	17	0	12	Q4	2012	9.8100	4.7088	3.0000	1
275	5001	6	0	12	Q4	2012	13.0800	4.5780	4.0000	1
275	5414	24	0	3	Q1	2012	13.0800	5.6244	4.0000	1
275	5644	17	0	4	Q2	2012	9.8100	4.0221	3.0000	1
275	5655	6	502	1	Q1	2012	13.0800	4.1856	4.0000	1
275	5674	7	0	5	Q2	2012	6.5400	2.2236	2.0000	1
275	5717	7	517	8	Q3	2012	13.0800	4.7088	4.0000	1
275	6019	6	504	2	Q1	2012	6.5400	2.4198	2.0000	1
275	6301	15	0	1	Q1	2012	13.0800	5.1012	4.0000	1
275	6314	24	0	11	Q4	2012	9.8100	3.1392	3.0000	1
275	6423	17	0	12	Q4	2012	9.8100	3.9240	3.0000	1
275	6501	24	0	9	Q3	2012	9.8100	3.4335	3.0000	1
275	6609	7	504	2	Q1	2012	9.8100	3.7278	3.0000	1
275	6690	17	0	12	Q4	2012	9.8100	3.4335	3.0000	1
275	6978	24	1859	8	Q3	2012	16.3500	7.8480	5.0000	1
275	7117	15	0	6	Q2	2012	9.8100	2.9430	3.0000	1
275	7446	13	0	3	Q1	2012	13.0800	4.5780	4.0000	1
275	8483	15	0	7	Q3	2012	13.0800	5.6244	4.0000	1
275	8663	13	0	7	Q3	2012	6.5400	2.8122	2.0000	1
275	8887	17	0	4	Q2	2012	13.0800	4.1856	4.0000	1
275	9046	14	0	3	Q1	2012	6.5400	2.4852	2.0000	1
275	9504	13	980	3	Q1	2012	9.8100	3.1392	3.0000	1
275	9505	15	0	12	Q4	2012	6.5400	3.0738	2.0000	1
275	9640	6	0	9	Q3	2012	6.5400	2.9430	2.0000	1
275	9671	13	0	4	Q2	2012	6.5400	2.8122	2.0000	1
275	9697	23	1771	3	Q1	2012	13.0800	6.5400	4.0000	1
275	9747	13	0	9	Q3	2012	9.8100	4.9050	3.0000	1
275	10274	6	0	5	Q2	2012	6.5400	2.2890	2.0000	1
276	89	6	0	8	Q3	2012	15.4400	4.9408	4.0000	1
276	461	11	0	8	Q3	2012	15.4400	7.4112	4.0000	1
276	464	15	0	11	Q4	2012	11.5800	5.6742	3.0000	1
276	697	13	0	3	Q1	2012	11.5800	5.3268	3.0000	1
276	711	17	0	2	Q1	2012	11.5800	4.7478	3.0000	1
276	878	3	199	7	Q3	2012	11.5800	3.8214	3.0000	1
276	1049	11	829	6	Q2	2012	11.5800	3.7056	3.0000	1
276	1281	3	0	7	Q3	2012	15.4400	4.7864	4.0000	1
276	1334	17	0	8	Q3	2012	11.5800	4.1688	3.0000	1
276	1416	6	0	7	Q3	2012	15.4400	6.1760	4.0000	1
276	1507	15	0	12	Q4	2012	7.7200	3.0880	2.0000	1
276	1528	16	0	11	Q4	2012	15.4400	6.9480	4.0000	1
276	1605	7	0	10	Q4	2012	15.4400	6.1760	4.0000	1
276	1716	24	0	4	Q2	2012	15.4400	6.0216	4.0000	1
276	1954	13	0	3	Q1	2012	7.7200	2.7792	2.0000	1
276	2204	3	210	12	Q4	2012	11.5800	3.7056	3.0000	1
276	2290	7	0	12	Q4	2012	11.5800	4.4004	3.0000	1
276	2686	11	0	9	Q3	2012	7.7200	2.7020	2.0000	1
276	2921	16	1214	2	Q1	2012	11.5800	3.5898	3.0000	1
276	3328	17	0	9	Q3	2012	11.5800	5.4426	3.0000	1
276	3426	11	0	2	Q1	2012	15.4400	5.2496	4.0000	1
276	4029	17	1312	10	Q4	2012	15.4400	4.6320	4.0000	1
276	4070	23	0	1	Q1	2012	7.7200	2.8564	2.0000	1
276	4273	11	0	8	Q3	2012	11.5800	5.3268	3.0000	1
276	4711	3	195	5	Q2	2012	11.5800	3.4740	3.0000	1
276	4730	2	120	7	Q3	2012	3.8600	1.4282	1.0000	1
276	4928	13	0	7	Q3	2012	11.5800	5.2110	3.0000	1
276	5671	7	0	12	Q4	2012	11.5800	5.6742	3.0000	1
276	6218	11	837	10	Q4	2012	11.5800	3.4740	3.0000	1
276	7028	15	0	10	Q4	2012	11.5800	4.9794	3.0000	1
276	7275	17	0	3	Q1	2012	7.7200	2.5476	2.0000	1
276	7363	6	0	1	Q1	2012	15.4400	7.4112	4.0000	1
276	7370	23	0	4	Q2	2012	7.7200	2.4704	2.0000	1
276	7556	17	1303	6	Q2	2012	15.4400	6.0216	4.0000	1
276	7823	7	0	12	Q4	2012	15.4400	5.7128	4.0000	1
276	7890	24	0	1	Q1	2012	7.7200	2.5476	2.0000	1
276	8055	14	0	8	Q3	2012	3.8600	1.2352	1.0000	1
276	8059	17	0	3	Q1	2012	7.7200	3.3196	2.0000	1
276	8731	3	0	12	Q4	2012	15.4400	4.6320	4.0000	1
276	8782	7	517	8	Q3	2012	7.7200	3.2424	2.0000	1
276	8946	23	0	3	Q1	2012	15.4400	5.2496	4.0000	1
276	9021	7	0	1	Q1	2012	11.5800	5.0952	3.0000	1
276	9224	17	0	12	Q4	2012	7.7200	3.8600	2.0000	1
276	9619	11	0	1	Q1	2012	7.7200	3.1652	2.0000	1
276	9867	13	0	4	Q2	2012	15.4400	6.3304	4.0000	1
276	9998	7	526	12	Q4	2012	7.7200	2.9336	2.0000	1
276	10222	7	504	2	Q1	2012	11.5800	5.5584	3.0000	1
277	430	16	0	12	Q4	2012	7.2300	3.2535	3.0000	1
277	563	15	0	7	Q3	2012	4.8200	1.6388	2.0000	1
277	625	13	0	1	Q1	2012	7.2300	3.4704	3.0000	1
277	941	13	976	1	Q1	2012	9.6400	3.6632	4.0000	1
277	1267	13	980	3	Q1	2012	12.0500	3.8560	5.0000	1
277	1345	17	0	9	Q3	2012	9.6400	4.7236	4.0000	1
277	1537	7	518	8	Q3	2012	4.8200	1.8798	2.0000	1
277	1626	13	984	5	Q2	2012	4.8200	2.1208	2.0000	1
277	1795	24	0	11	Q4	2012	7.2300	3.4704	3.0000	1
277	2224	16	1225	7	Q3	2012	9.6400	4.3380	4.0000	1
277	2289	6	504	2	Q1	2012	7.2300	2.5305	3.0000	1
277	2326	6	0	8	Q3	2012	7.2300	3.0366	3.0000	1
277	2390	17	0	11	Q4	2012	9.6400	3.1812	4.0000	1
277	2482	13	0	6	Q2	2012	7.2300	2.1690	3.0000	1
277	2656	13	0	10	Q4	2012	9.6400	4.6272	4.0000	1
277	2769	16	0	12	Q4	2012	7.2300	3.5427	3.0000	1
277	2878	3	0	4	Q2	2012	9.6400	4.2416	4.0000	1
277	3020	13	0	5	Q2	2012	7.2300	2.6028	3.0000	1
277	3020	13	980	3	Q1	2012	4.8200	1.6388	2.0000	1
277	3170	7	0	12	Q4	2012	7.2300	3.1812	3.0000	1
277	3700	15	0	2	Q1	2012	4.8200	1.7834	2.0000	1
277	3925	11	0	3	Q1	2012	9.6400	3.4704	4.0000	1
277	4004	13	0	12	Q4	2012	4.8200	1.9762	2.0000	1
277	4342	13	0	1	Q1	2012	7.2300	2.8920	3.0000	1
277	4403	7	517	8	Q3	2012	7.2300	3.4704	3.0000	1
277	4471	11	820	2	Q1	2012	9.6400	4.4344	4.0000	1
277	4600	2	0	2	Q1	2012	4.8200	1.6870	2.0000	1
277	4610	23	1788	11	Q4	2012	7.2300	2.1690	3.0000	1
277	4659	13	0	3	Q1	2012	4.8200	1.8798	2.0000	1
277	4677	11	824	4	Q2	2012	7.2300	2.8197	3.0000	1
277	4828	7	504	2	Q1	2012	9.6400	3.9524	4.0000	1
277	4846	17	0	12	Q4	2012	7.2300	2.5305	3.0000	1
277	5354	15	0	12	Q4	2012	9.6400	3.4704	4.0000	1
277	5587	7	0	4	Q2	2012	9.6400	4.2416	4.0000	1
277	5848	7	0	9	Q3	2012	7.2300	3.1089	3.0000	1
277	5954	6	523	11	Q4	2012	7.2300	2.3136	3.0000	1
277	6132	3	0	9	Q3	2012	9.6400	4.6272	4.0000	1
277	6598	11	0	11	Q4	2012	7.2300	2.6751	3.0000	1
277	6628	6	508	4	Q2	2012	7.2300	3.1089	3.0000	1
277	6957	16	0	11	Q4	2012	9.6400	2.9884	4.0000	1
277	7059	17	0	1	Q1	2012	9.6400	2.9884	4.0000	1
277	7072	16	0	11	Q4	2012	4.8200	2.2172	2.0000	1
277	7153	3	0	12	Q4	2012	7.2300	3.4704	3.0000	1
277	7282	17	0	4	Q2	2012	9.6400	3.6632	4.0000	1
277	7713	17	0	10	Q4	2012	7.2300	3.4704	3.0000	1
277	7842	15	0	11	Q4	2012	4.8200	1.5906	2.0000	1
277	7907	6	508	4	Q2	2012	7.2300	2.6751	3.0000	1
277	9101	6	0	11	Q4	2012	7.2300	2.5305	3.0000	1
277	9263	16	0	3	Q1	2012	7.2300	3.4704	3.0000	1
277	9420	13	0	5	Q2	2012	9.6400	3.3740	4.0000	1
277	10015	17	0	12	Q4	2012	7.2300	2.2413	3.0000	1
277	10153	6	508	4	Q2	2012	7.2300	2.8197	3.0000	1
278	285	6	0	12	Q4	2012	10.0800	4.9392	3.0000	1
278	638	11	841	12	Q4	2012	13.4400	4.3008	4.0000	1
278	905	3	197	6	Q2	2012	16.8000	5.8800	5.0000	1
278	941	13	0	8	Q3	2012	10.0800	3.3264	3.0000	1
278	976	16	0	12	Q4	2012	6.7200	2.6208	2.0000	1
278	994	13	0	7	Q3	2012	10.0800	3.0240	3.0000	1
278	1099	15	0	9	Q3	2012	10.0800	3.7296	3.0000	1
278	1114	24	0	12	Q4	2012	13.4400	5.2416	4.0000	1
278	1147	13	0	7	Q3	2012	10.0800	4.9392	3.0000	1
278	1253	13	0	7	Q3	2012	10.0800	3.1248	3.0000	1
278	1281	3	0	8	Q3	2012	6.7200	2.6208	2.0000	1
278	1587	11	0	7	Q3	2012	13.4400	6.3168	4.0000	1
278	1587	11	837	10	Q4	2012	10.0800	3.4272	3.0000	1
278	1850	16	1235	11	Q4	2012	10.0800	3.1248	3.0000	1
278	1977	23	0	12	Q4	2012	10.0800	4.0320	3.0000	1
278	2246	13	980	3	Q1	2012	10.0800	3.0240	3.0000	1
278	2270	11	833	8	Q3	2012	10.0800	4.6368	3.0000	1
278	2553	16	0	12	Q4	2012	13.4400	6.4512	4.0000	1
278	2890	7	0	12	Q4	2012	13.4400	4.9728	4.0000	1
278	2921	16	1235	11	Q4	2012	6.7200	2.0160	2.0000	1
278	3130	13	0	2	Q1	2012	10.0800	3.7296	3.0000	1
278	3445	15	0	11	Q4	2012	13.4400	4.3008	4.0000	1
278	3528	17	0	10	Q4	2012	13.4400	4.7040	4.0000	1
278	3750	6	524	11	Q4	2012	10.0800	4.9392	3.0000	1
278	4243	11	0	9	Q3	2012	10.0800	3.7296	3.0000	1
278	4417	3	0	2	Q1	2012	13.4400	5.1072	4.0000	1
278	4615	17	0	7	Q3	2012	10.0800	3.2256	3.0000	1
278	4626	7	0	12	Q4	2012	10.0800	3.2256	3.0000	1
278	4633	7	0	5	Q2	2012	6.7200	2.5536	2.0000	1
278	4695	13	0	12	Q4	2012	10.0800	4.5360	3.0000	1
278	4900	13	0	12	Q4	2012	10.0800	4.3344	3.0000	1
278	5256	17	0	12	Q4	2012	10.0800	3.5280	3.0000	1
278	5387	7	0	7	Q3	2012	10.0800	3.3264	3.0000	1
278	5388	11	0	11	Q4	2012	10.0800	3.0240	3.0000	1
278	5597	3	0	7	Q3	2012	13.4400	4.1664	4.0000	1
278	5611	24	0	3	Q1	2012	6.7200	2.2176	2.0000	1
278	5715	11	0	11	Q4	2012	10.0800	3.0240	3.0000	1
278	5793	24	1869	12	Q4	2012	13.4400	5.5104	4.0000	1
278	6218	11	0	12	Q4	2012	10.0800	3.9312	3.0000	1
278	6321	14	0	9	Q3	2012	3.3600	1.0080	1.0000	1
278	6488	13	0	5	Q2	2012	10.0800	4.3344	3.0000	1
278	6490	6	0	11	Q4	2012	10.0800	3.5280	3.0000	1
278	6666	17	0	12	Q4	2012	13.4400	5.7792	4.0000	1
278	6690	17	1314	11	Q4	2012	10.0800	3.5280	3.0000	1
278	7895	24	0	7	Q3	2012	13.4400	4.4352	4.0000	1
278	9248	15	1157	12	Q4	2012	10.0800	4.7376	3.0000	1
278	9604	24	0	8	Q3	2012	13.4400	4.7040	4.0000	1
278	9715	17	0	6	Q2	2012	13.4400	6.4512	4.0000	1
278	9747	13	0	7	Q3	2012	10.0800	4.0320	3.0000	1
278	9760	13	0	3	Q1	2012	6.7200	2.8896	2.0000	1
278	9924	15	0	7	Q3	2012	13.4400	5.3760	4.0000	1
278	10240	3	188	2	Q1	2012	10.0800	3.2256	3.0000	1
279	448	17	0	4	Q2	2012	8.4600	2.6226	3.0000	1
279	769	16	0	5	Q2	2012	5.6400	2.4252	2.0000	1
279	1145	17	0	12	Q4	2012	8.4600	3.1302	3.0000	1
279	1481	15	0	9	Q3	2012	8.4600	3.8070	3.0000	1
279	1528	16	0	6	Q2	2012	14.1000	6.2040	5.0000	1
279	1744	17	0	12	Q4	2012	8.4600	3.2148	3.0000	1
279	2143	17	0	12	Q4	2012	11.2800	4.9632	4.0000	1
279	2158	11	0	8	Q3	2012	8.4600	2.6226	3.0000	1
279	2466	24	0	9	Q3	2012	5.6400	2.3688	2.0000	1
279	2521	7	0	10	Q4	2012	5.6400	1.8048	2.0000	1
279	2632	13	0	5	Q2	2012	5.6400	1.8612	2.0000	1
279	2861	6	0	3	Q1	2012	5.6400	2.7072	2.0000	1
279	2988	15	0	7	Q3	2012	8.4600	3.4686	3.0000	1
279	3131	15	0	12	Q4	2012	11.2800	3.8352	4.0000	1
279	3173	11	0	3	Q1	2012	11.2800	4.2864	4.0000	1
279	3305	13	0	5	Q2	2012	8.4600	3.3840	3.0000	1
279	3334	17	0	12	Q4	2012	8.4600	3.2148	3.0000	1
279	3476	3	0	6	Q2	2012	14.1000	4.3710	5.0000	1
279	3681	13	0	7	Q3	2012	8.4600	2.7918	3.0000	1
279	3693	3	190	3	Q1	2012	5.6400	2.3124	2.0000	1
279	3889	3	201	8	Q3	2012	11.2800	4.2864	4.0000	1
279	4397	16	0	11	Q4	2012	11.2800	4.0608	4.0000	1
279	4418	15	0	6	Q2	2012	8.4600	3.4686	3.0000	1
279	4564	17	0	3	Q1	2012	8.4600	3.8070	3.0000	1
279	4664	7	0	6	Q2	2012	11.2800	3.3840	4.0000	1
279	4666	13	0	7	Q3	2012	5.6400	2.0868	2.0000	1
279	4772	2	0	2	Q1	2012	2.8200	1.3818	1.0000	1
279	5278	11	0	3	Q1	2012	5.6400	2.3688	2.0000	1
279	5914	24	0	4	Q2	2012	8.4600	3.6378	3.0000	1
279	6017	11	0	12	Q4	2012	11.2800	5.3016	4.0000	1
279	6096	7	0	5	Q2	2012	8.4600	2.5380	3.0000	1
279	6744	13	0	7	Q3	2012	8.4600	2.7072	3.0000	1
279	6960	17	0	6	Q2	2012	8.4600	3.0456	3.0000	1
279	6975	6	0	8	Q3	2012	8.4600	3.0456	3.0000	1
279	7293	22	1702	8	Q3	2012	2.8200	1.2690	1.0000	1
279	7327	15	0	10	Q4	2012	11.2800	3.6096	4.0000	1
279	7368	11	0	4	Q2	2012	11.2800	4.2864	4.0000	1
279	7496	13	0	2	Q1	2012	11.2800	3.6096	4.0000	1
279	7662	24	0	4	Q2	2012	5.6400	1.6920	2.0000	1
279	7662	24	1869	12	Q4	2012	8.4600	3.1302	3.0000	1
279	8081	14	0	3	Q1	2012	2.8200	1.1280	1.0000	1
279	8452	16	0	11	Q4	2012	14.1000	4.9350	5.0000	1
279	8473	13	0	6	Q2	2012	5.6400	2.0304	2.0000	1
279	8523	2	0	3	Q1	2012	5.6400	2.1996	2.0000	1
279	9213	11	0	3	Q1	2012	8.4600	4.1454	3.0000	1
279	9542	14	0	2	Q1	2012	5.6400	2.6508	2.0000	1
279	9563	15	1146	7	Q3	2012	11.2800	5.5272	4.0000	1
279	9631	16	0	7	Q3	2012	11.2800	5.3016	4.0000	1
279	9745	17	0	7	Q3	2012	5.6400	1.7484	2.0000	1
279	10167	17	0	12	Q4	2012	8.4600	3.1302	3.0000	1
280	360	24	0	11	Q4	2012	5.4300	1.8462	3.0000	1
280	644	13	0	1	Q1	2012	5.4300	2.0091	3.0000	1
280	817	17	0	10	Q4	2012	7.2400	2.3168	4.0000	1
280	1145	17	1307	8	Q3	2012	5.4300	2.2263	3.0000	1
280	1202	11	820	2	Q1	2012	7.2400	3.1856	4.0000	1
280	1263	13	0	5	Q2	2012	5.4300	2.6064	3.0000	1
280	1297	16	0	8	Q3	2012	5.4300	2.0634	3.0000	1
280	1297	16	0	11	Q4	2012	7.2400	2.5340	4.0000	1
280	1388	13	0	2	Q1	2012	5.4300	1.7919	3.0000	1
280	2086	13	980	3	Q1	2012	5.4300	1.7376	3.0000	1
280	2134	11	0	12	Q4	2012	3.6200	1.0860	2.0000	1
280	2204	3	0	12	Q4	2012	9.0500	3.8915	5.0000	1
280	2295	17	0	4	Q2	2012	3.6200	1.1946	2.0000	1
280	2371	16	0	5	Q2	2012	5.4300	2.0091	3.0000	1
280	3021	16	1228	8	Q3	2012	5.4300	2.3892	3.0000	1
280	3149	11	0	9	Q3	2012	3.6200	1.7738	2.0000	1
280	3149	11	837	10	Q4	2012	3.6200	1.2670	2.0000	1
280	3312	15	0	2	Q1	2012	3.6200	1.3756	2.0000	1
280	4666	13	0	12	Q4	2012	9.0500	4.4345	5.0000	1
280	4824	3	0	6	Q2	2012	5.4300	2.0091	3.0000	1
280	4919	15	0	2	Q1	2012	5.4300	2.2806	3.0000	1
280	5101	15	0	11	Q4	2012	5.4300	2.4435	3.0000	1
280	5303	17	1314	11	Q4	2012	7.2400	2.6064	4.0000	1
280	5310	2	0	11	Q4	2012	1.8100	0.8507	1.0000	1
280	5410	17	0	9	Q3	2012	7.2400	2.5340	4.0000	1
280	5553	6	0	2	Q1	2012	9.0500	3.2580	5.0000	1
280	5735	6	506	3	Q1	2012	3.6200	1.3032	2.0000	1
280	6001	17	1297	3	Q1	2012	5.4300	2.4435	3.0000	1
280	6069	13	0	4	Q2	2012	5.4300	2.2806	3.0000	1
280	6350	13	0	6	Q2	2012	7.2400	2.6064	4.0000	1
280	6398	11	0	4	Q2	2012	3.6200	1.7376	2.0000	1
280	6423	17	0	2	Q1	2012	9.0500	4.0725	5.0000	1
280	6452	11	0	10	Q4	2012	7.2400	2.1720	4.0000	1
280	6488	13	0	3	Q1	2012	5.4300	2.3349	3.0000	1
280	6816	11	0	8	Q3	2012	9.0500	4.2535	5.0000	1
280	7066	14	0	3	Q1	2012	1.8100	0.5430	1.0000	1
280	7072	16	1216	2	Q1	2012	3.6200	1.0860	2.0000	1
280	7470	13	0	7	Q3	2012	7.2400	2.5340	4.0000	1
280	7573	3	0	4	Q2	2012	5.4300	2.6607	3.0000	1
280	8195	7	0	9	Q3	2012	3.6200	1.5566	2.0000	1
280	8247	6	0	10	Q4	2012	3.6200	1.4480	2.0000	1
280	9109	7	0	8	Q3	2012	5.4300	1.8462	3.0000	1
280	9160	6	0	5	Q2	2012	7.2400	2.7512	4.0000	1
280	9780	15	0	9	Q3	2012	5.4300	1.9005	3.0000	1
280	10161	6	0	4	Q2	2012	7.2400	2.5340	4.0000	1
280	10168	15	0	1	Q1	2012	7.2400	2.6064	4.0000	1
281	636	17	0	11	Q4	2012	7.8900	3.4716	3.0000	1
281	864	24	0	11	Q4	2012	10.5200	3.6820	4.0000	1
281	997	3	0	12	Q4	2012	7.8900	3.0771	3.0000	1
281	1235	11	0	3	Q1	2012	7.8900	3.5505	3.0000	1
281	1347	13	0	4	Q2	2012	10.5200	3.4716	4.0000	1
281	1720	16	0	5	Q2	2012	7.8900	2.8404	3.0000	1
281	1938	24	0	3	Q1	2012	7.8900	2.6826	3.0000	1
281	1981	11	836	9	Q3	2012	7.8900	3.0771	3.0000	1
281	2129	7	0	4	Q2	2012	5.2600	1.7884	2.0000	1
281	2327	13	0	6	Q2	2012	7.8900	3.6294	3.0000	1
281	2448	16	1235	11	Q4	2012	7.8900	2.3670	3.0000	1
281	2587	16	0	9	Q3	2012	10.5200	3.7872	4.0000	1
281	2588	23	0	12	Q4	2012	5.2600	2.4196	2.0000	1
281	2776	22	0	6	Q2	2012	2.6300	1.0783	1.0000	1
281	2929	24	0	6	Q2	2012	10.5200	4.6288	4.0000	1
281	3182	2	0	5	Q2	2012	2.6300	0.8416	1.0000	1
281	3423	13	0	7	Q3	2012	7.8900	3.0771	3.0000	1
281	3538	11	0	1	Q1	2012	7.8900	3.2349	3.0000	1
281	3883	2	0	2	Q1	2012	2.6300	0.8153	1.0000	1
281	4263	24	0	3	Q1	2012	10.5200	5.0496	4.0000	1
281	4678	13	0	9	Q3	2012	7.8900	3.4716	3.0000	1
281	4778	3	207	11	Q4	2012	5.2600	2.3670	2.0000	1
281	5063	3	0	7	Q3	2012	7.8900	3.7872	3.0000	1
281	5142	11	0	12	Q4	2012	7.8900	3.4716	3.0000	1
281	5174	16	1216	2	Q1	2012	7.8900	2.3670	3.0000	1
281	5303	17	0	9	Q3	2012	10.5200	3.7872	4.0000	1
281	5410	17	0	12	Q4	2012	10.5200	4.3132	4.0000	1
281	5898	3	207	11	Q4	2012	7.8900	3.8661	3.0000	1
281	5999	23	0	5	Q2	2012	5.2600	1.9988	2.0000	1
281	6511	6	0	12	Q4	2012	10.5200	4.3132	4.0000	1
281	7292	13	0	1	Q1	2012	7.8900	2.9982	3.0000	1
281	7355	13	976	1	Q1	2012	5.2600	2.0514	2.0000	1
281	7501	24	0	3	Q1	2012	7.8900	3.0771	3.0000	1
281	7862	16	1231	9	Q3	2012	13.1500	4.8655	5.0000	1
281	8311	23	0	11	Q4	2012	7.8900	2.6037	3.0000	1
281	8390	24	0	12	Q4	2012	10.5200	3.3664	4.0000	1
281	8473	13	0	8	Q3	2012	5.2600	1.8410	2.0000	1
281	9026	13	0	6	Q2	2012	5.2600	1.8410	2.0000	1
281	9199	2	0	9	Q3	2012	5.2600	2.5248	2.0000	1
281	9236	13	0	1	Q1	2012	7.8900	3.3138	3.0000	1
281	9617	2	0	1	Q1	2012	2.6300	0.8942	1.0000	1
281	9855	7	0	11	Q4	2012	5.2600	2.2618	2.0000	1
281	10015	17	1312	10	Q4	2012	7.8900	3.8661	3.0000	1
281	10273	17	1294	2	Q1	2012	10.5200	5.1548	4.0000	1
282	485	15	1141	4	Q2	2012	1.8600	0.8742	2.0000	1
282	638	11	826	5	Q2	2012	2.7900	1.1160	3.0000	1
282	863	17	0	11	Q4	2012	3.7200	1.1904	4.0000	1
282	907	7	0	9	Q3	2012	2.7900	0.8928	3.0000	1
282	1193	13	0	7	Q3	2012	3.7200	1.4880	4.0000	1
282	1267	13	0	7	Q3	2012	3.7200	1.6368	4.0000	1
282	1310	16	0	6	Q2	2012	2.7900	0.9765	3.0000	1
282	1648	11	0	2	Q1	2012	3.7200	1.3392	4.0000	1
282	2430	24	0	5	Q2	2012	1.8600	0.5580	2.0000	1
282	2448	16	1236	12	Q4	2012	3.7200	1.1904	4.0000	1
282	2507	3	0	3	Q1	2012	1.8600	0.7254	2.0000	1
282	2553	16	0	12	Q4	2012	4.6500	2.2320	5.0000	1
282	2769	16	0	12	Q4	2012	2.7900	1.3671	3.0000	1
282	2818	6	526	12	Q4	2012	3.7200	1.1904	4.0000	1
282	3109	11	0	2	Q1	2012	3.7200	1.7112	4.0000	1
282	3253	13	0	10	Q4	2012	4.6500	1.3950	5.0000	1
282	3397	17	0	3	Q1	2012	2.7900	1.0881	3.0000	1
282	3427	24	0	1	Q1	2012	2.7900	0.8928	3.0000	1
282	4137	15	0	7	Q3	2012	1.8600	0.8928	2.0000	1
282	4155	7	0	10	Q4	2012	2.7900	1.3392	3.0000	1
282	4676	16	1214	2	Q1	2012	2.7900	1.0881	3.0000	1
282	5048	15	0	5	Q2	2012	3.7200	1.8228	4.0000	1
282	5096	7	521	10	Q4	2012	2.7900	0.8649	3.0000	1
282	5303	17	1312	10	Q4	2012	2.7900	0.8370	3.0000	1
282	5374	16	1228	8	Q3	2012	3.7200	1.8228	4.0000	1
282	5533	13	0	1	Q1	2012	2.7900	1.1718	3.0000	1
282	5542	16	0	5	Q2	2012	1.8600	0.7068	2.0000	1
282	5597	3	0	7	Q3	2012	3.7200	1.5996	4.0000	1
282	5768	3	0	12	Q4	2012	2.7900	1.3113	3.0000	1
282	5781	11	0	5	Q2	2012	1.8600	0.6138	2.0000	1
282	5942	7	0	11	Q4	2012	2.7900	0.8928	3.0000	1
282	6056	15	0	6	Q2	2012	2.7900	1.1439	3.0000	1
282	6077	24	1860	8	Q3	2012	2.7900	1.0044	3.0000	1
282	6267	24	0	3	Q1	2012	2.7900	1.2276	3.0000	1
282	7100	17	0	10	Q4	2012	3.7200	1.6368	4.0000	1
282	7384	3	202	8	Q3	2012	2.7900	0.9207	3.0000	1
282	8033	24	0	7	Q3	2012	2.7900	1.3950	3.0000	1
282	8178	2	108	1	Q1	2012	0.9300	0.3999	1.0000	1
282	8263	11	0	2	Q1	2012	3.7200	1.4880	4.0000	1
282	8578	23	0	1	Q1	2012	1.8600	0.7998	2.0000	1
282	8647	3	0	2	Q1	2012	3.7200	1.1904	4.0000	1
282	8746	23	0	12	Q4	2012	2.7900	0.8928	3.0000	1
282	8816	6	0	7	Q3	2012	3.7200	1.6740	4.0000	1
282	8864	7	0	12	Q4	2012	2.7900	0.8649	3.0000	1
282	8945	23	0	10	Q4	2012	1.8600	0.7068	2.0000	1
282	9200	16	1235	11	Q4	2012	2.7900	1.2555	3.0000	1
282	9357	6	0	1	Q1	2012	1.8600	0.8370	2.0000	1
282	9760	13	0	3	Q1	2012	1.8600	0.7998	2.0000	1
282	9960	7	0	4	Q2	2012	1.8600	0.7998	2.0000	1
282	10063	2	0	6	Q2	2012	0.9300	0.4092	1.0000	1
282	10092	22	0	5	Q2	2012	0.9300	0.3813	1.0000	1
283	240	7	0	1	Q1	2012	5.4600	2.4570	2.0000	1
283	658	7	0	5	Q2	2012	8.1900	2.8665	3.0000	1
283	663	16	1225	7	Q3	2012	5.4600	1.8564	2.0000	1
283	753	3	0	1	Q1	2012	10.9200	3.4944	4.0000	1
283	873	24	0	2	Q1	2012	8.1900	2.7027	3.0000	1
283	981	24	0	3	Q1	2012	5.4600	2.4024	2.0000	1
283	1415	16	0	1	Q1	2012	8.1900	2.6208	3.0000	1
283	1415	16	1220	4	Q2	2012	8.1900	3.2760	3.0000	1
283	1647	7	523	11	Q4	2012	8.1900	4.0950	3.0000	1
283	1748	7	521	10	Q4	2012	5.4600	2.4024	2.0000	1
283	1902	24	0	12	Q4	2012	8.1900	3.0303	3.0000	1
283	2019	16	1235	11	Q4	2012	8.1900	4.0950	3.0000	1
283	2271	6	523	11	Q4	2012	8.1900	2.4570	3.0000	1
283	2760	7	501	1	Q1	2012	10.9200	4.6956	4.0000	1
283	2830	6	0	10	Q4	2012	5.4600	2.0748	2.0000	1
283	3245	17	0	1	Q1	2012	8.1900	4.0950	3.0000	1
283	3304	22	1710	12	Q4	2012	5.4600	1.6926	2.0000	1
283	3547	11	829	6	Q2	2012	8.1900	3.2760	3.0000	1
283	3709	7	0	11	Q4	2012	8.1900	2.4570	3.0000	1
283	3816	3	0	11	Q4	2012	5.4600	1.6926	2.0000	1
283	3854	13	984	5	Q2	2012	5.4600	1.9110	2.0000	1
283	3941	3	0	6	Q2	2012	5.4600	1.6380	2.0000	1
283	4080	11	841	12	Q4	2012	5.4600	2.1840	2.0000	1
283	4157	6	523	11	Q4	2012	5.4600	2.2932	2.0000	1
283	4231	17	1307	8	Q3	2012	10.9200	4.4772	4.0000	1
283	4595	11	0	2	Q1	2012	13.6500	5.5965	5.0000	1
283	4691	17	1304	7	Q3	2012	5.4600	1.9110	2.0000	1
283	4736	13	0	8	Q3	2012	5.4600	1.8564	2.0000	1
283	4875	13	0	7	Q3	2012	5.4600	2.0748	2.0000	1
283	4958	23	0	7	Q3	2012	8.1900	2.8665	3.0000	1
283	5256	17	0	12	Q4	2012	8.1900	3.1122	3.0000	1
283	5374	16	0	1	Q1	2012	10.9200	4.8048	4.0000	1
283	5590	17	0	11	Q4	2012	8.1900	3.9312	3.0000	1
283	5754	6	518	8	Q3	2012	10.9200	3.9312	4.0000	1
283	5973	3	187	2	Q1	2012	8.1900	3.8493	3.0000	1
283	6012	13	0	11	Q4	2012	8.1900	2.5389	3.0000	1
283	6132	3	188	2	Q1	2012	8.1900	3.7674	3.0000	1
283	6696	6	0	6	Q2	2012	10.9200	3.6036	4.0000	1
283	6844	11	829	6	Q2	2012	10.9200	3.2760	4.0000	1
283	7281	17	1294	2	Q1	2012	8.1900	2.8665	3.0000	1
283	7486	3	0	4	Q2	2012	5.4600	2.2386	2.0000	1
283	7536	7	0	9	Q3	2012	8.1900	3.4398	3.0000	1
283	7573	3	0	9	Q3	2012	10.9200	5.2416	4.0000	1
283	7715	13	0	6	Q2	2012	10.9200	3.4944	4.0000	1
283	7842	15	0	11	Q4	2012	10.9200	3.4944	4.0000	1
283	7868	24	0	4	Q2	2012	8.1900	4.0131	3.0000	1
283	8004	24	1858	7	Q3	2012	13.6500	6.2790	5.0000	1
283	8199	17	0	7	Q3	2012	8.1900	3.2760	3.0000	1
283	8367	13	0	3	Q1	2012	8.1900	2.7027	3.0000	1
283	8423	24	0	4	Q2	2012	5.4600	1.9110	2.0000	1
283	8499	24	1847	2	Q1	2012	8.1900	3.0303	3.0000	1
283	8885	7	0	7	Q3	2012	8.1900	3.6855	3.0000	1
283	8947	3	0	5	Q2	2012	8.1900	4.0131	3.0000	1
283	9047	15	1157	12	Q4	2012	5.4600	2.1840	2.0000	1
283	9499	6	0	10	Q4	2012	10.9200	4.1496	4.0000	1
283	9552	7	517	8	Q3	2012	8.1900	2.6208	3.0000	1
283	9745	17	0	2	Q1	2012	5.4600	1.6926	2.0000	1
284	181	3	202	8	Q3	2012	2.9700	1.4553	3.0000	1
284	276	15	0	3	Q1	2012	2.9700	1.1583	3.0000	1
284	764	6	0	6	Q2	2012	2.9700	1.0395	3.0000	1
284	1089	15	0	5	Q2	2012	1.9800	0.7524	2.0000	1
284	1166	13	0	1	Q1	2012	2.9700	0.9801	3.0000	1
284	1175	7	0	11	Q4	2012	2.9700	1.1583	3.0000	1
284	1235	11	0	4	Q2	2012	1.9800	0.6534	2.0000	1
284	1312	3	0	5	Q2	2012	1.9800	0.8514	2.0000	1
284	1512	6	508	4	Q2	2012	2.9700	1.4256	3.0000	1
284	1602	7	0	4	Q2	2012	2.9700	1.4553	3.0000	1
284	1653	7	0	4	Q2	2012	2.9700	1.4850	3.0000	1
284	1736	13	0	8	Q3	2012	2.9700	1.1286	3.0000	1
284	1780	24	0	4	Q2	2012	1.9800	0.9108	2.0000	1
284	1991	13	0	3	Q1	2012	2.9700	1.3068	3.0000	1
284	2086	13	980	3	Q1	2012	2.9700	1.2771	3.0000	1
284	2224	16	1214	2	Q1	2012	4.9500	2.1285	5.0000	1
284	2293	7	0	5	Q2	2012	2.9700	0.9801	3.0000	1
284	2725	11	0	11	Q4	2012	2.9700	1.4553	3.0000	1
284	3667	15	1134	1	Q1	2012	3.9600	1.2672	4.0000	1
284	3706	13	0	11	Q4	2012	2.9700	1.4850	3.0000	1
284	4554	24	0	11	Q4	2012	2.9700	1.0098	3.0000	1
284	4700	17	0	4	Q2	2012	1.9800	0.7128	2.0000	1
284	4900	13	0	12	Q4	2012	1.9800	0.7524	2.0000	1
284	4954	11	0	3	Q1	2012	2.9700	1.3662	3.0000	1
284	4959	13	0	7	Q3	2012	3.9600	1.4652	4.0000	1
284	5060	13	0	1	Q1	2012	2.9700	1.3068	3.0000	1
284	5313	24	0	3	Q1	2012	3.9600	1.4256	4.0000	1
284	5345	7	0	8	Q3	2012	2.9700	0.9207	3.0000	1
284	5368	24	0	11	Q4	2012	3.9600	1.4256	4.0000	1
284	5426	24	1866	11	Q4	2012	3.9600	1.4652	4.0000	1
284	5990	6	0	7	Q3	2012	3.9600	1.1880	4.0000	1
284	6001	17	0	2	Q1	2012	3.9600	1.5444	4.0000	1
284	6114	16	0	9	Q3	2012	2.9700	0.9207	3.0000	1
284	6574	13	988	7	Q3	2012	1.9800	0.5940	2.0000	1
284	6617	7	526	12	Q4	2012	2.9700	1.3662	3.0000	1
284	7589	17	0	6	Q2	2012	4.9500	2.1780	5.0000	1
284	7641	13	0	3	Q1	2012	1.9800	0.6534	2.0000	1
284	7989	17	0	5	Q2	2012	2.9700	0.9504	3.0000	1
284	8074	17	0	12	Q4	2012	2.9700	1.3068	3.0000	1
284	8511	16	0	4	Q2	2012	2.9700	1.3068	3.0000	1
284	9029	3	201	8	Q3	2012	3.9600	1.1880	4.0000	1
284	9331	11	0	10	Q4	2012	1.9800	0.7722	2.0000	1
284	9361	7	0	4	Q2	2012	4.9500	1.9305	5.0000	1
284	9598	6	0	11	Q4	2012	2.9700	1.2771	3.0000	1
284	9746	15	0	7	Q3	2012	3.9600	1.9008	4.0000	1
284	10026	13	976	1	Q1	2012	1.9800	0.6930	2.0000	1
285	554	23	0	1	Q1	2012	7.4400	3.5712	4.0000	1
285	863	17	1293	1	Q1	2012	7.4400	2.3808	4.0000	1
285	870	24	0	6	Q2	2012	5.5800	2.4552	3.0000	1
285	1415	16	0	7	Q3	2012	5.5800	1.9530	3.0000	1
285	1532	6	0	2	Q1	2012	5.5800	1.8414	3.0000	1
285	1610	3	0	9	Q3	2012	3.7200	1.8228	2.0000	1
285	2135	22	0	9	Q3	2012	3.7200	1.1532	2.0000	1
285	2272	17	0	12	Q4	2012	5.5800	2.5668	3.0000	1
285	2371	16	0	5	Q2	2012	5.5800	2.6226	3.0000	1
285	2378	16	0	5	Q2	2012	5.5800	2.1204	3.0000	1
285	2390	17	0	4	Q2	2012	5.5800	1.8414	3.0000	1
285	2398	13	982	4	Q2	2012	5.5800	2.5110	3.0000	1
285	2553	16	0	7	Q3	2012	7.4400	2.8272	4.0000	1
285	2688	7	0	4	Q2	2012	5.5800	1.7298	3.0000	1
285	2921	16	1236	12	Q4	2012	5.5800	1.8972	3.0000	1
285	3301	11	0	2	Q1	2012	5.5800	2.7342	3.0000	1
285	3572	11	0	9	Q3	2012	3.7200	1.6368	2.0000	1
285	3599	13	0	7	Q3	2012	5.5800	2.5110	3.0000	1
285	3660	24	0	7	Q3	2012	5.5800	1.8972	3.0000	1
285	3693	3	201	8	Q3	2012	3.7200	1.3020	2.0000	1
285	4175	16	1214	2	Q1	2012	3.7200	1.2276	2.0000	1
285	4316	22	0	6	Q2	2012	1.8600	0.6696	1.0000	1
285	4618	3	0	2	Q1	2012	5.5800	2.4552	3.0000	1
285	4691	17	0	1	Q1	2012	3.7200	1.6740	2.0000	1
285	5286	15	0	6	Q2	2012	7.4400	3.2736	4.0000	1
285	5635	7	0	4	Q2	2012	5.5800	2.2320	3.0000	1
285	6511	6	0	12	Q4	2012	7.4400	2.2320	4.0000	1
285	7046	15	0	7	Q3	2012	5.5800	2.4552	3.0000	1
285	7234	16	0	10	Q4	2012	5.5800	2.0088	3.0000	1
285	7243	13	0	7	Q3	2012	5.5800	2.7342	3.0000	1
285	7810	3	0	1	Q1	2012	7.4400	2.6784	4.0000	1
285	7895	24	1845	1	Q1	2012	5.5800	2.1204	3.0000	1
285	7920	17	0	4	Q2	2012	5.5800	2.3436	3.0000	1
285	8351	16	0	12	Q4	2012	5.5800	2.6784	3.0000	1
285	8435	17	0	1	Q1	2012	5.5800	1.7856	3.0000	1
285	8436	15	0	6	Q2	2012	5.5800	2.0088	3.0000	1
285	8500	17	0	10	Q4	2012	5.5800	2.6226	3.0000	1
285	8669	23	0	7	Q3	2012	3.7200	1.2276	2.0000	1
285	8892	13	0	2	Q1	2012	5.5800	1.8972	3.0000	1
285	9156	6	522	10	Q4	2012	5.5800	2.0088	3.0000	1
285	9176	23	0	11	Q4	2012	7.4400	3.1248	4.0000	1
285	9184	3	0	7	Q3	2012	3.7200	1.6740	2.0000	1
285	9209	6	0	8	Q3	2012	5.5800	2.0646	3.0000	1
285	9673	13	988	7	Q3	2012	7.4400	2.3064	4.0000	1
285	9855	7	0	11	Q4	2012	3.7200	1.5996	2.0000	1
285	10136	7	0	8	Q3	2012	3.7200	1.4136	2.0000	1
286	3	15	1141	4	Q2	2012	4.2600	1.5336	3.0000	1
286	1249	15	0	1	Q1	2012	2.8400	1.0792	2.0000	1
286	1304	13	980	3	Q1	2012	5.6800	2.5560	4.0000	1
286	1388	13	0	11	Q4	2012	4.2600	2.0448	3.0000	1
286	1426	13	0	4	Q2	2012	4.2600	1.7466	3.0000	1
286	1690	16	0	5	Q2	2012	2.8400	0.9372	2.0000	1
286	1801	7	0	9	Q3	2012	7.1000	2.6980	5.0000	1
286	1862	17	1293	1	Q1	2012	4.2600	1.8744	3.0000	1
286	2238	24	0	7	Q3	2012	4.2600	1.6614	3.0000	1
286	2241	6	0	8	Q3	2012	4.2600	1.2780	3.0000	1
286	2921	16	1223	6	Q2	2012	4.2600	1.7892	3.0000	1
286	3011	15	1142	5	Q2	2012	2.8400	1.2212	2.0000	1
286	3121	7	0	7	Q3	2012	4.2600	1.3632	3.0000	1
286	3187	24	1869	12	Q4	2012	4.2600	1.3632	3.0000	1
286	3193	24	1866	11	Q4	2012	5.6800	1.7040	4.0000	1
286	3413	15	0	2	Q1	2012	4.2600	1.7466	3.0000	1
286	3453	14	0	3	Q1	2012	1.4200	0.5254	1.0000	1
286	3497	17	0	2	Q1	2012	4.2600	1.4058	3.0000	1
286	3603	24	0	12	Q4	2012	2.8400	0.9656	2.0000	1
286	3776	13	976	1	Q1	2012	2.8400	1.3348	2.0000	1
286	5063	3	0	3	Q1	2012	4.2600	1.3632	3.0000	1
286	5255	24	0	10	Q4	2012	5.6800	1.9880	4.0000	1
286	5408	6	523	11	Q4	2012	4.2600	1.9170	3.0000	1
286	5590	17	0	4	Q2	2012	4.2600	1.4058	3.0000	1
286	5636	15	0	7	Q3	2012	4.2600	1.4484	3.0000	1
286	5967	24	0	12	Q4	2012	4.2600	1.7892	3.0000	1
286	6196	24	0	1	Q1	2012	5.6800	2.3288	4.0000	1
286	6283	6	0	5	Q2	2012	2.8400	0.9940	2.0000	1
286	6304	6	0	4	Q2	2012	5.6800	2.3288	4.0000	1
286	6504	14	1071	8	Q3	2012	1.4200	0.7100	1.0000	1
286	6609	7	504	2	Q1	2012	5.6800	2.7264	4.0000	1
286	7141	17	0	4	Q2	2012	5.6800	2.4424	4.0000	1
286	7478	7	0	7	Q3	2012	4.2600	2.0874	3.0000	1
286	7724	15	0	5	Q2	2012	4.2600	1.4058	3.0000	1
286	7832	7	0	7	Q3	2012	2.8400	1.0792	2.0000	1
286	7862	16	0	6	Q2	2012	5.6800	2.3288	4.0000	1
286	8196	24	0	6	Q2	2012	2.8400	1.2496	2.0000	1
286	8504	13	0	5	Q2	2012	5.6800	1.8744	4.0000	1
286	8578	23	0	1	Q1	2012	2.8400	1.2212	2.0000	1
286	8647	3	202	8	Q3	2012	4.2600	1.8744	3.0000	1
286	8653	3	0	11	Q4	2012	5.6800	2.0448	4.0000	1
286	8834	7	0	5	Q2	2012	2.8400	0.9656	2.0000	1
286	9200	16	0	7	Q3	2012	4.2600	1.3632	3.0000	1
286	9570	15	0	11	Q4	2012	2.8400	1.0792	2.0000	1
286	9787	13	980	3	Q1	2012	2.8400	1.0508	2.0000	1
286	9840	6	0	12	Q4	2012	4.2600	1.6614	3.0000	1
286	9960	7	0	1	Q1	2012	4.2600	1.4484	3.0000	1
286	9960	7	0	4	Q2	2012	2.8400	1.2212	2.0000	1
287	44	7	0	8	Q3	2012	3.1200	1.2792	2.0000	1
287	187	13	0	10	Q4	2012	4.6800	1.6380	3.0000	1
287	909	7	0	5	Q2	2012	3.1200	1.0920	2.0000	1
287	980	6	0	8	Q3	2012	6.2400	1.9344	4.0000	1
287	1124	3	0	7	Q3	2012	3.1200	1.2168	2.0000	1
287	2054	15	0	3	Q1	2012	4.6800	1.6380	3.0000	1
287	2110	11	0	11	Q4	2012	3.1200	1.1544	2.0000	1
287	2147	13	0	10	Q4	2012	4.6800	2.2932	3.0000	1
287	2269	11	0	3	Q1	2012	6.2400	1.9344	4.0000	1
287	2632	13	0	12	Q4	2012	4.6800	1.4040	3.0000	1
287	2808	13	0	11	Q4	2012	3.1200	1.3416	2.0000	1
287	2828	7	0	12	Q4	2012	3.1200	1.2792	2.0000	1
287	2846	11	0	7	Q3	2012	3.1200	1.2792	2.0000	1
287	2863	17	1307	8	Q3	2012	4.6800	2.2932	3.0000	1
287	2947	17	0	3	Q1	2012	4.6800	1.6380	3.0000	1
287	3309	24	1858	7	Q3	2012	6.2400	1.8720	4.0000	1
287	3310	17	1314	11	Q4	2012	3.1200	1.5600	2.0000	1
287	3350	11	0	9	Q3	2012	3.1200	1.4976	2.0000	1
287	3360	13	0	12	Q4	2012	6.2400	1.9344	4.0000	1
287	3395	11	0	11	Q4	2012	4.6800	2.1996	3.0000	1
287	3499	13	0	9	Q3	2012	4.6800	2.0592	3.0000	1
287	3549	22	0	5	Q2	2012	3.1200	1.4352	2.0000	1
287	3649	11	0	8	Q3	2012	6.2400	3.0576	4.0000	1
287	3799	13	976	1	Q1	2012	6.2400	2.2464	4.0000	1
287	4165	3	0	8	Q3	2012	6.2400	1.9968	4.0000	1
287	4204	17	1312	10	Q4	2012	6.2400	1.9968	4.0000	1
287	4398	7	0	9	Q3	2012	4.6800	2.1528	3.0000	1
287	4676	16	0	6	Q2	2012	4.6800	1.5912	3.0000	1
287	4925	16	0	5	Q2	2012	4.6800	1.4508	3.0000	1
287	5182	15	1138	3	Q1	2012	4.6800	1.8720	3.0000	1
287	5200	24	1866	11	Q4	2012	6.2400	2.8704	4.0000	1
287	5556	7	0	4	Q2	2012	4.6800	2.2932	3.0000	1
287	5814	15	1140	4	Q2	2012	6.2400	2.3712	4.0000	1
287	5907	7	0	4	Q2	2012	7.8000	3.7440	5.0000	1
287	6132	3	0	9	Q3	2012	4.6800	1.5444	3.0000	1
287	6554	17	1292	1	Q1	2012	3.1200	1.3104	2.0000	1
287	7031	11	0	6	Q2	2012	4.6800	1.8720	3.0000	1
287	7141	17	0	12	Q4	2012	4.6800	1.4976	3.0000	1
287	7362	11	826	5	Q2	2012	4.6800	1.5444	3.0000	1
287	7612	7	0	8	Q3	2012	3.1200	1.0296	2.0000	1
287	8171	24	1853	5	Q2	2012	4.6800	1.8720	3.0000	1
287	8214	6	0	12	Q4	2012	4.6800	1.6380	3.0000	1
287	8289	17	0	12	Q4	2012	4.6800	1.4040	3.0000	1
287	8408	6	511	5	Q2	2012	4.6800	2.1060	3.0000	1
287	8617	17	1303	6	Q2	2012	4.6800	1.6848	3.0000	1
287	8678	24	0	4	Q2	2012	3.1200	1.0920	2.0000	1
287	9101	6	0	11	Q4	2012	4.6800	1.4976	3.0000	1
287	9318	16	0	4	Q2	2012	4.6800	1.6848	3.0000	1
287	9369	6	0	12	Q4	2012	6.2400	2.3712	4.0000	1
287	9639	17	0	5	Q2	2012	4.6800	2.1996	3.0000	1
287	9642	3	0	1	Q1	2012	3.1200	1.1232	2.0000	1
287	10209	6	0	9	Q3	2012	6.2400	2.3712	4.0000	1
288	294	24	0	9	Q3	2012	8.5800	4.2900	3.0000	1
288	378	16	0	3	Q1	2012	8.5800	4.2042	3.0000	1
288	485	15	1143	5	Q2	2012	8.5800	3.0888	3.0000	1
288	587	17	0	12	Q4	2012	11.4400	3.6608	4.0000	1
288	587	17	1303	6	Q2	2012	11.4400	3.6608	4.0000	1
288	760	3	210	12	Q4	2012	11.4400	4.2328	4.0000	1
288	900	24	0	9	Q3	2012	8.5800	3.7752	3.0000	1
288	1193	13	0	1	Q1	2012	11.4400	4.0040	4.0000	1
288	1193	13	0	11	Q4	2012	11.4400	4.3472	4.0000	1
288	1304	13	0	1	Q1	2012	11.4400	5.0336	4.0000	1
288	1572	11	0	5	Q2	2012	8.5800	4.2042	3.0000	1
288	2059	17	0	12	Q4	2012	5.7200	2.4024	2.0000	1
288	2147	13	0	7	Q3	2012	5.7200	1.9448	2.0000	1
288	2254	6	0	12	Q4	2012	8.5800	2.5740	3.0000	1
288	2382	15	1146	7	Q3	2012	11.4400	4.6904	4.0000	1
288	2422	13	0	9	Q3	2012	11.4400	4.0040	4.0000	1
288	2626	11	829	6	Q2	2012	5.7200	1.8876	2.0000	1
288	2632	13	0	11	Q4	2012	11.4400	3.6608	4.0000	1
288	2632	13	988	7	Q3	2012	8.5800	2.5740	3.0000	1
288	2724	24	0	11	Q4	2012	8.5800	3.9468	3.0000	1
288	3286	22	0	7	Q3	2012	2.8600	0.9724	1.0000	1
288	4615	17	0	2	Q1	2012	8.5800	2.5740	3.0000	1
288	4644	11	0	4	Q2	2012	11.4400	3.7752	4.0000	1
288	4963	24	1853	5	Q2	2012	14.3000	4.5760	5.0000	1
288	5060	13	980	3	Q1	2012	5.7200	2.4596	2.0000	1
288	5088	13	0	8	Q3	2012	8.5800	4.1184	3.0000	1
288	5141	7	504	2	Q1	2012	8.5800	3.1746	3.0000	1
288	5250	6	0	9	Q3	2012	5.7200	2.6884	2.0000	1
288	5542	16	0	7	Q3	2012	11.4400	5.0336	4.0000	1
288	5944	3	0	11	Q4	2012	11.4400	5.1480	4.0000	1
288	5970	13	0	5	Q2	2012	8.5800	3.4320	3.0000	1
288	6001	17	0	12	Q4	2012	8.5800	4.1184	3.0000	1
288	6291	3	0	12	Q4	2012	8.5800	3.2604	3.0000	1
288	6792	13	0	12	Q4	2012	11.4400	5.4912	4.0000	1
288	7101	15	0	9	Q3	2012	5.7200	2.0020	2.0000	1
288	7391	7	505	2	Q1	2012	5.7200	1.8876	2.0000	1
288	7444	13	0	3	Q1	2012	8.5800	3.7752	3.0000	1
288	7641	13	0	3	Q1	2012	8.5800	3.1746	3.0000	1
288	7641	13	980	3	Q1	2012	11.4400	4.0040	4.0000	1
288	7643	24	0	8	Q3	2012	8.5800	3.0030	3.0000	1
288	7769	11	836	9	Q3	2012	11.4400	5.0336	4.0000	1
288	8241	17	0	2	Q1	2012	8.5800	3.4320	3.0000	1
288	8374	3	0	11	Q4	2012	8.5800	2.6598	3.0000	1
288	8404	3	0	11	Q4	2012	8.5800	3.9468	3.0000	1
288	8687	23	1769	3	Q1	2012	8.5800	3.7752	3.0000	1
288	8843	13	0	8	Q3	2012	5.7200	2.2308	2.0000	1
288	8975	15	1138	3	Q1	2012	8.5800	3.0888	3.0000	1
288	9256	13	0	11	Q4	2012	5.7200	2.8600	2.0000	1
288	9271	17	0	5	Q2	2012	8.5800	3.5178	3.0000	1
288	9498	23	0	2	Q1	2012	11.4400	4.1184	4.0000	1
288	9728	16	1223	6	Q2	2012	8.5800	3.9468	3.0000	1
289	93	13	0	11	Q4	2012	4.1100	2.0139	3.0000	1
289	118	3	0	12	Q4	2012	4.1100	1.6029	3.0000	1
289	391	6	0	5	Q2	2012	4.1100	1.9728	3.0000	1
289	477	15	1152	9	Q3	2012	5.4800	2.4112	4.0000	1
289	619	13	0	8	Q3	2012	5.4800	2.2468	4.0000	1
289	941	13	992	9	Q3	2012	4.1100	1.4385	3.0000	1
289	1378	11	833	8	Q3	2012	5.4800	2.4112	4.0000	1
289	1468	13	0	8	Q3	2012	5.4800	2.1920	4.0000	1
289	2258	11	0	5	Q2	2012	4.1100	1.9728	3.0000	1
289	2371	16	0	3	Q1	2012	4.1100	1.5618	3.0000	1
289	2857	6	0	12	Q4	2012	4.1100	1.5207	3.0000	1
289	2863	17	0	5	Q2	2012	4.1100	2.0139	3.0000	1
289	2942	17	0	4	Q2	2012	5.4800	2.5208	4.0000	1
289	3242	3	205	10	Q4	2012	4.1100	1.9728	3.0000	1
289	3528	17	0	12	Q4	2012	2.7400	1.0138	2.0000	1
289	3647	13	986	6	Q2	2012	4.1100	1.2330	3.0000	1
289	3719	23	0	8	Q3	2012	2.7400	0.8220	2.0000	1
289	4021	16	0	5	Q2	2012	5.4800	1.9180	4.0000	1
289	4160	24	0	11	Q4	2012	4.1100	2.0139	3.0000	1
289	4259	15	0	8	Q3	2012	4.1100	2.0139	3.0000	1
289	4420	11	0	4	Q2	2012	2.7400	0.9590	2.0000	1
289	4471	11	0	12	Q4	2012	2.7400	1.3700	2.0000	1
289	4566	11	818	1	Q1	2012	4.1100	2.0139	3.0000	1
289	4609	23	0	9	Q3	2012	5.4800	2.0824	4.0000	1
289	4750	11	0	12	Q4	2012	5.4800	2.2468	4.0000	1
289	4776	6	0	5	Q2	2012	4.1100	1.8495	3.0000	1
289	4939	2	126	10	Q4	2012	2.7400	0.8494	2.0000	1
289	5738	3	0	8	Q3	2012	2.7400	1.2604	2.0000	1
289	5781	11	0	6	Q2	2012	2.7400	0.9042	2.0000	1
289	6367	3	0	1	Q1	2012	4.1100	1.9317	3.0000	1
289	6666	17	0	9	Q3	2012	5.4800	2.5208	4.0000	1
289	6832	3	0	3	Q1	2012	5.4800	2.5756	4.0000	1
289	7005	15	0	11	Q4	2012	2.7400	1.3152	2.0000	1
289	7182	13	0	3	Q1	2012	4.1100	1.8084	3.0000	1
289	7215	11	841	12	Q4	2012	5.4800	1.7536	4.0000	1
289	7457	13	0	7	Q3	2012	2.7400	1.0686	2.0000	1
289	7576	13	0	8	Q3	2012	4.1100	1.7673	3.0000	1
289	7580	17	0	5	Q2	2012	5.4800	1.8632	4.0000	1
289	7643	24	1846	2	Q1	2012	4.1100	1.4385	3.0000	1
289	7721	13	988	7	Q3	2012	5.4800	2.3564	4.0000	1
289	7735	15	0	8	Q3	2012	4.1100	1.6851	3.0000	1
289	8041	24	1859	8	Q3	2012	6.8500	2.6030	5.0000	1
289	8059	17	0	7	Q3	2012	2.7400	0.9042	2.0000	1
289	8253	24	1845	1	Q1	2012	2.7400	1.0686	2.0000	1
289	8687	23	1778	7	Q3	2012	5.4800	2.1920	4.0000	1
289	9123	3	0	8	Q3	2012	5.4800	1.6440	4.0000	1
289	9375	24	1858	7	Q3	2012	4.1100	1.7262	3.0000	1
289	9403	6	502	1	Q1	2012	4.1100	1.9728	3.0000	1
289	9691	15	0	11	Q4	2012	2.7400	0.9042	2.0000	1
290	93	13	980	3	Q1	2012	5.1000	2.4990	3.0000	1
290	588	23	0	4	Q2	2012	8.5000	3.0600	5.0000	1
290	916	6	0	10	Q4	2012	3.4000	1.2240	2.0000	1
290	934	15	0	8	Q3	2012	6.8000	2.3800	4.0000	1
290	1159	11	820	2	Q1	2012	6.8000	2.9240	4.0000	1
290	1328	17	1292	1	Q1	2012	6.8000	3.0600	4.0000	1
290	1690	16	0	5	Q2	2012	10.2000	4.1310	6.0000	2
290	1850	16	0	3	Q1	2012	3.4000	1.4960	2.0000	1
290	1897	13	0	10	Q4	2012	6.8000	2.5160	4.0000	1
290	2431	3	0	11	Q4	2012	6.8000	3.1280	4.0000	1
290	2639	15	0	9	Q3	2012	5.1000	1.5810	3.0000	1
290	2678	3	0	2	Q1	2012	3.4000	1.2240	2.0000	1
290	2734	6	519	9	Q3	2012	5.1000	1.6830	3.0000	1
290	2815	22	0	9	Q3	2012	3.4000	1.1560	2.0000	1
290	2863	17	0	8	Q3	2012	5.1000	2.4480	3.0000	1
290	3009	6	504	2	Q1	2012	5.1000	2.2440	3.0000	1
290	3161	13	0	5	Q2	2012	8.5000	4.0800	5.0000	1
290	3441	3	0	3	Q1	2012	5.1000	1.8360	3.0000	1
290	3497	17	0	12	Q4	2012	5.1000	2.2440	3.0000	1
290	3706	13	984	5	Q2	2012	5.1000	2.3970	3.0000	1
290	3719	23	0	7	Q3	2012	3.4000	1.7000	2.0000	1
290	4088	24	0	12	Q4	2012	5.1000	2.1420	3.0000	1
290	4122	15	0	12	Q4	2012	3.4000	1.5300	2.0000	1
290	4203	15	0	11	Q4	2012	3.4000	1.3600	2.0000	1
290	4211	11	0	7	Q3	2012	5.1000	2.0400	3.0000	1
290	4543	13	0	1	Q1	2012	5.1000	1.8360	3.0000	1
290	5060	13	0	7	Q3	2012	5.1000	1.8360	3.0000	1
290	5590	17	0	4	Q2	2012	5.1000	1.8870	3.0000	1
290	5714	7	0	4	Q2	2012	5.1000	1.6830	3.0000	1
290	6168	17	0	7	Q3	2012	5.1000	1.5810	3.0000	1
290	6554	17	0	3	Q1	2012	5.1000	2.4990	3.0000	1
290	7035	6	0	12	Q4	2012	5.1000	1.8870	3.0000	1
290	7455	13	0	12	Q4	2012	5.1000	1.5300	3.0000	1
290	7584	6	524	11	Q4	2012	6.8000	2.1760	4.0000	1
290	7810	3	0	1	Q1	2012	6.8000	2.4480	4.0000	1
290	7937	24	0	2	Q1	2012	5.1000	1.9890	3.0000	1
290	8171	24	0	1	Q1	2012	6.8000	3.2640	4.0000	1
290	8351	16	0	12	Q4	2012	5.1000	2.4990	3.0000	1
290	8466	17	1293	1	Q1	2012	5.1000	2.1420	3.0000	1
290	8601	7	0	3	Q1	2012	5.1000	2.1930	3.0000	1
290	8746	23	1788	11	Q4	2012	6.8000	2.6520	4.0000	1
290	9027	7	523	11	Q4	2012	6.8000	3.1280	4.0000	1
290	9176	23	0	9	Q3	2012	6.8000	3.2640	4.0000	1
290	9256	13	0	2	Q1	2012	3.4000	1.7000	2.0000	1
290	9427	24	0	3	Q1	2012	6.8000	2.4480	4.0000	1
290	9694	6	508	4	Q2	2012	3.4000	1.4620	2.0000	1
290	9891	23	0	11	Q4	2012	5.1000	2.4990	3.0000	1
290	10043	22	0	3	Q1	2012	3.4000	1.1220	2.0000	1
290	10222	7	0	8	Q3	2012	6.8000	3.2640	4.0000	1
291	360	24	1856	6	Q2	2012	4.4400	1.9536	2.0000	1
291	570	15	0	4	Q2	2012	6.6600	2.3310	3.0000	1
291	924	3	210	12	Q4	2012	4.4400	1.8648	2.0000	1
291	1089	15	0	5	Q2	2012	11.1000	3.9960	5.0000	1
291	1093	13	0	7	Q3	2012	6.6600	2.3310	3.0000	1
291	1124	3	0	11	Q4	2012	8.8800	3.9072	4.0000	1
291	1271	13	0	1	Q1	2012	6.6600	2.9304	3.0000	1
291	1352	17	0	8	Q3	2012	11.1000	4.1070	5.0000	1
291	1403	24	0	8	Q3	2012	8.8800	3.1968	4.0000	1
291	1429	13	0	1	Q1	2012	6.6600	2.5308	3.0000	1
291	1533	3	0	2	Q1	2012	4.4400	2.0868	2.0000	1
291	1626	13	0	5	Q2	2012	4.4400	1.9980	2.0000	1
291	1759	7	0	7	Q3	2012	4.4400	1.5540	2.0000	1
291	2068	6	0	10	Q4	2012	6.6600	2.4642	3.0000	1
291	2678	3	207	11	Q4	2012	8.8800	4.1736	4.0000	1
291	2769	16	0	5	Q2	2012	8.8800	3.9960	4.0000	1
291	3046	13	0	9	Q3	2012	8.8800	2.8416	4.0000	1
291	3693	3	0	5	Q2	2012	8.8800	3.6408	4.0000	1
291	4135	11	826	5	Q2	2012	6.6600	2.5974	3.0000	1
291	4316	22	0	6	Q2	2012	2.2200	1.0656	1.0000	1
291	5341	17	0	7	Q3	2012	8.8800	3.2856	4.0000	1
291	5454	6	0	6	Q2	2012	6.6600	2.9970	3.0000	1
291	5501	17	0	9	Q3	2012	6.6600	2.1312	3.0000	1
291	5922	15	0	3	Q1	2012	6.6600	2.7306	3.0000	1
291	6153	16	1216	2	Q1	2012	8.8800	3.3744	4.0000	1
291	6347	17	0	9	Q3	2012	6.6600	2.0646	3.0000	1
291	7149	13	0	4	Q2	2012	4.4400	1.7760	2.0000	1
291	7384	3	0	7	Q3	2012	11.1000	5.5500	5.0000	1
291	7617	11	818	1	Q1	2012	6.6600	2.3310	3.0000	1
291	7625	7	0	8	Q3	2012	6.6600	2.3310	3.0000	1
291	7806	13	0	5	Q2	2012	4.4400	1.4652	2.0000	1
291	7852	11	829	6	Q2	2012	6.6600	2.9970	3.0000	1
291	8416	11	821	2	Q1	2012	8.8800	3.5520	4.0000	1
291	8768	11	0	9	Q3	2012	6.6600	3.2634	3.0000	1
291	9022	24	0	9	Q3	2012	6.6600	2.4642	3.0000	1
291	9254	15	1140	4	Q2	2012	8.8800	3.9072	4.0000	1
291	9747	13	0	9	Q3	2012	8.8800	3.1080	4.0000	1
291	9773	15	0	7	Q3	2012	4.4400	1.3764	2.0000	1
291	9852	24	0	5	Q2	2012	8.8800	2.9304	4.0000	1
291	10032	6	0	12	Q4	2012	4.4400	2.1756	2.0000	1
291	10050	6	0	12	Q4	2012	6.6600	2.8638	3.0000	1
291	10126	7	0	12	Q4	2012	6.6600	2.5308	3.0000	1
291	10186	13	0	12	Q4	2012	8.8800	2.6640	4.0000	1
291	10190	15	1138	3	Q1	2012	4.4400	1.6872	2.0000	1
292	117	13	0	1	Q1	2012	5.4300	2.1177	3.0000	1
292	424	6	0	9	Q3	2012	3.6200	1.4118	2.0000	1
292	538	11	0	8	Q3	2012	9.0500	4.5250	5.0000	1
292	881	24	1850	3	Q1	2012	7.2400	2.3168	4.0000	1
292	1152	7	0	12	Q4	2012	5.4300	1.8462	3.0000	1
292	1173	13	0	1	Q1	2012	7.2400	3.3304	4.0000	1
292	1245	17	0	3	Q1	2012	5.4300	2.0091	3.0000	1
292	1341	3	0	10	Q4	2012	7.2400	3.2580	4.0000	1
292	1529	13	0	9	Q3	2012	3.6200	1.3032	2.0000	1
292	1545	15	0	12	Q4	2012	7.2400	2.3168	4.0000	1
292	1561	24	1846	2	Q1	2012	7.2400	2.6064	4.0000	1
292	1832	23	0	12	Q4	2012	5.4300	2.1177	3.0000	1
292	1865	6	0	4	Q2	2012	5.4300	2.6064	3.0000	1
292	1977	23	1771	3	Q1	2012	7.2400	3.5476	4.0000	1
292	2197	11	0	11	Q4	2012	3.6200	1.3394	2.0000	1
292	2507	3	0	9	Q3	2012	5.4300	2.4435	3.0000	1
292	2614	13	1000	12	Q4	2012	3.6200	1.7376	2.0000	1
292	2850	3	0	8	Q3	2012	7.2400	2.3892	4.0000	1
292	3691	17	1311	10	Q4	2012	5.4300	1.9548	3.0000	1
292	3826	16	1214	2	Q1	2012	5.4300	2.2806	3.0000	1
292	4410	13	986	6	Q2	2012	7.2400	3.3304	4.0000	1
292	4446	15	0	5	Q2	2012	3.6200	1.1946	2.0000	1
292	5026	17	0	12	Q4	2012	5.4300	1.7376	3.0000	1
292	5143	17	0	2	Q1	2012	5.4300	2.4435	3.0000	1
292	5209	14	0	8	Q3	2012	1.8100	0.8326	1.0000	1
292	5476	13	988	7	Q3	2012	7.2400	2.8960	4.0000	1
292	5501	17	1303	6	Q2	2012	5.4300	2.4978	3.0000	1
292	5813	3	199	7	Q3	2012	7.2400	2.2444	4.0000	1
292	5942	7	0	11	Q4	2012	3.6200	1.5928	2.0000	1
292	6189	7	516	8	Q3	2012	3.6200	1.3756	2.0000	1
292	6232	15	0	3	Q1	2012	5.4300	2.4435	3.0000	1
292	6265	23	1769	3	Q1	2012	5.4300	2.6607	3.0000	1
292	6273	24	0	2	Q1	2012	3.6200	1.6290	2.0000	1
292	6381	24	0	8	Q3	2012	5.4300	2.2806	3.0000	1
292	6392	7	0	5	Q2	2012	3.6200	1.7738	2.0000	1
292	6400	7	514	7	Q3	2012	7.2400	3.5476	4.0000	1
292	6715	7	0	3	Q1	2012	7.2400	2.8236	4.0000	1
292	6759	22	0	1	Q1	2012	1.8100	0.5792	1.0000	1
292	6936	17	0	3	Q1	2012	5.4300	2.1177	3.0000	1
292	6995	11	820	2	Q1	2012	3.6200	1.6290	2.0000	1
292	7132	13	992	9	Q3	2012	7.2400	2.6064	4.0000	1
292	7190	23	0	7	Q3	2012	7.2400	2.7512	4.0000	1
292	7234	16	0	5	Q2	2012	7.2400	3.0408	4.0000	1
292	7275	17	0	3	Q1	2012	5.4300	1.7376	3.0000	1
292	7546	13	0	7	Q3	2012	5.4300	2.4435	3.0000	1
292	7828	11	0	9	Q3	2012	5.4300	2.0634	3.0000	1
292	7910	15	0	9	Q3	2012	5.4300	2.0091	3.0000	1
292	7972	6	0	6	Q2	2012	7.2400	3.2580	4.0000	1
292	8033	24	0	10	Q4	2012	3.6200	1.7376	2.0000	1
292	8173	15	1157	12	Q4	2012	3.6200	1.1946	2.0000	1
292	8351	16	0	5	Q2	2012	5.4300	1.7376	3.0000	1
292	8389	6	519	9	Q3	2012	5.4300	2.1720	3.0000	1
292	8404	3	207	11	Q4	2012	5.4300	2.4978	3.0000	1
292	8511	16	0	3	Q1	2012	5.4300	2.2806	3.0000	1
292	8511	16	0	11	Q4	2012	3.6200	1.6290	2.0000	1
292	8511	16	1228	8	Q3	2012	5.4300	2.5521	3.0000	1
292	8578	23	0	9	Q3	2012	5.4300	2.1177	3.0000	1
292	8579	15	0	12	Q4	2012	5.4300	2.3892	3.0000	1
292	8749	13	0	7	Q3	2012	5.4300	1.9005	3.0000	1
292	8906	11	0	1	Q1	2012	5.4300	2.3892	3.0000	1
292	9176	23	0	3	Q1	2012	5.4300	2.1177	3.0000	1
292	9223	24	1866	11	Q4	2012	3.6200	1.1946	2.0000	1
292	9272	15	0	3	Q1	2012	5.4300	1.9548	3.0000	1
292	9318	16	1233	10	Q4	2012	5.4300	1.7376	3.0000	1
292	9503	24	1856	6	Q2	2012	9.0500	3.3485	5.0000	1
292	10145	13	980	3	Q1	2012	3.6200	1.5928	2.0000	1
293	547	24	0	6	Q2	2012	3.2000	1.3760	2.0000	1
293	663	16	1225	7	Q3	2012	6.4000	2.4320	4.0000	1
293	878	3	0	12	Q4	2012	6.4000	2.3680	4.0000	1
293	921	23	0	6	Q2	2012	8.0000	2.5600	5.0000	1
293	1142	13	0	2	Q1	2012	6.4000	2.6240	4.0000	1
293	1205	15	0	9	Q3	2012	4.8000	1.4400	3.0000	1
293	1249	15	0	1	Q1	2012	6.4000	2.3040	4.0000	1
293	1538	7	0	8	Q3	2012	4.8000	1.6800	3.0000	1
293	1626	13	980	3	Q1	2012	6.4000	2.1120	4.0000	1
293	1633	3	207	11	Q4	2012	4.8000	2.0640	3.0000	1
293	1696	22	0	5	Q2	2012	3.2000	1.3760	2.0000	1
293	1916	13	0	7	Q3	2012	6.4000	2.4320	4.0000	1
293	2346	15	1157	12	Q4	2012	6.4000	2.0480	4.0000	1
293	2479	13	0	12	Q4	2012	6.4000	2.8800	4.0000	1
293	2584	24	0	12	Q4	2012	4.8000	2.1600	3.0000	1
293	2981	23	1772	4	Q2	2012	4.8000	1.7280	3.0000	1
293	3169	6	0	2	Q1	2012	4.8000	2.1120	3.0000	1
293	3170	7	0	12	Q4	2012	4.8000	1.4880	3.0000	1
293	3388	13	0	4	Q2	2012	4.8000	1.8240	3.0000	1
293	3588	24	0	3	Q1	2012	6.4000	2.4320	4.0000	1
293	3611	24	1866	11	Q4	2012	3.2000	1.1840	2.0000	1
293	3776	13	0	1	Q1	2012	4.8000	1.6800	3.0000	1
293	3813	6	0	10	Q4	2012	6.4000	2.8800	4.0000	1
293	4078	3	0	5	Q2	2012	3.2000	1.5360	2.0000	1
293	4273	11	824	4	Q2	2012	4.8000	2.3040	3.0000	1
293	4364	17	0	4	Q2	2012	6.4000	1.9200	4.0000	1
293	4392	6	0	9	Q3	2012	4.8000	2.0640	3.0000	1
293	4927	14	1078	12	Q4	2012	3.2000	1.0560	2.0000	1
293	5362	24	0	7	Q3	2012	3.2000	1.5680	2.0000	1
293	5592	16	0	5	Q2	2012	3.2000	1.1840	2.0000	1
293	5639	11	0	11	Q4	2012	4.8000	2.0640	3.0000	1
293	5765	7	0	6	Q2	2012	3.2000	1.4720	2.0000	1
293	6153	16	0	10	Q4	2012	4.8000	2.0640	3.0000	1
293	6320	24	1869	12	Q4	2012	4.8000	1.4400	3.0000	1
293	6511	7	0	4	Q2	2012	3.2000	1.0560	2.0000	1
293	6647	17	0	6	Q2	2012	4.8000	1.5840	3.0000	1
293	6735	6	0	9	Q3	2012	3.2000	1.1200	2.0000	1
293	6744	13	0	1	Q1	2012	4.8000	2.2080	3.0000	1
293	7203	13	0	4	Q2	2012	4.8000	1.6800	3.0000	1
293	7525	2	108	1	Q1	2012	1.6000	0.5280	1.0000	1
293	7909	3	0	11	Q4	2012	3.2000	1.2160	2.0000	1
293	7915	13	0	7	Q3	2012	6.4000	2.7520	4.0000	1
293	7920	17	0	9	Q3	2012	6.4000	2.8160	4.0000	1
293	8055	14	0	8	Q3	2012	1.6000	0.5120	1.0000	1
293	8138	24	1856	6	Q2	2012	4.8000	1.6800	3.0000	1
293	8409	24	0	7	Q3	2012	4.8000	1.9200	3.0000	1
293	8555	11	841	12	Q4	2012	6.4000	2.5600	4.0000	1
293	8860	17	0	6	Q2	2012	6.4000	2.4320	4.0000	1
293	9123	3	0	10	Q4	2012	6.4000	1.9200	4.0000	1
293	9318	16	0	1	Q1	2012	4.8000	1.8720	3.0000	1
293	9421	22	1698	6	Q2	2012	3.2000	1.2800	2.0000	1
293	9536	24	0	7	Q3	2012	3.2000	1.0560	2.0000	1
293	9601	11	0	7	Q3	2012	4.8000	2.0640	3.0000	1
294	823	24	0	4	Q2	2012	5.2800	1.8480	4.0000	1
294	1366	13	0	12	Q4	2012	3.9600	1.3068	3.0000	1
294	1429	13	0	7	Q3	2012	3.9600	1.9404	3.0000	1
294	1738	6	0	9	Q3	2012	2.6400	0.9240	2.0000	1
294	2047	11	0	2	Q1	2012	2.6400	0.9504	2.0000	1
294	2729	15	0	1	Q1	2012	5.2800	2.3760	4.0000	1
294	3179	24	0	9	Q3	2012	3.9600	1.7424	3.0000	1
294	3460	11	821	2	Q1	2012	3.9600	1.9404	3.0000	1
294	3763	24	0	3	Q1	2012	3.9600	1.3464	3.0000	1
294	4420	11	0	1	Q1	2012	2.6400	1.2936	2.0000	1
294	4420	11	0	10	Q4	2012	2.6400	1.2936	2.0000	1
294	4687	24	0	7	Q3	2012	2.6400	1.2672	2.0000	1
294	4910	24	1869	12	Q4	2012	5.2800	2.3232	4.0000	1
294	6138	17	0	4	Q2	2012	2.6400	1.0296	2.0000	1
294	6266	15	0	1	Q1	2012	3.9600	1.6236	3.0000	1
294	6469	6	504	2	Q1	2012	5.2800	2.1648	4.0000	1
294	6480	24	0	5	Q2	2012	3.9600	1.1880	3.0000	1
294	6866	17	0	11	Q4	2012	3.9600	1.5444	3.0000	1
294	7051	16	1233	10	Q4	2012	2.6400	0.8184	2.0000	1
294	7067	13	0	6	Q2	2012	2.6400	0.9768	2.0000	1
294	7132	13	988	7	Q3	2012	3.9600	1.4256	3.0000	1
294	7282	17	0	12	Q4	2012	6.6000	2.5080	5.0000	1
294	7849	3	0	3	Q1	2012	3.9600	1.9404	3.0000	1
294	7887	11	0	10	Q4	2012	5.2800	1.6896	4.0000	1
294	8046	7	0	5	Q2	2012	3.9600	1.6236	3.0000	1
294	8108	17	0	10	Q4	2012	3.9600	1.1880	3.0000	1
294	8158	11	0	5	Q2	2012	3.9600	1.5048	3.0000	1
294	8351	16	1235	11	Q4	2012	3.9600	1.8612	3.0000	1
294	8412	11	0	7	Q3	2012	3.9600	1.7820	3.0000	1
294	8482	11	837	10	Q4	2012	3.9600	1.9008	3.0000	1
294	8518	24	0	1	Q1	2012	2.6400	1.0296	2.0000	1
294	9033	6	513	6	Q2	2012	2.6400	1.0560	2.0000	1
294	9052	24	1845	1	Q1	2012	3.9600	1.3860	3.0000	1
294	9111	17	1307	8	Q3	2012	6.6000	2.9700	5.0000	1
294	9200	16	0	1	Q1	2012	3.9600	1.7424	3.0000	1
294	9481	24	0	8	Q3	2012	3.9600	1.6632	3.0000	1
294	9767	15	0	8	Q3	2012	3.9600	1.1880	3.0000	1
294	10104	7	0	7	Q3	2012	2.6400	0.9768	2.0000	1
294	10134	24	0	2	Q1	2012	2.6400	0.8712	2.0000	1
295	350	6	0	2	Q1	2012	9.3600	2.9952	3.0000	1
295	400	23	0	1	Q1	2012	6.2400	2.2464	2.0000	1
295	625	13	988	7	Q3	2012	9.3600	4.5864	3.0000	1
295	685	15	0	1	Q1	2012	9.3600	3.2760	3.0000	1
295	750	13	0	3	Q1	2012	12.4800	4.6176	4.0000	1
295	769	16	1216	2	Q1	2012	12.4800	4.2432	4.0000	1
295	1070	3	210	12	Q4	2012	9.3600	4.0248	3.0000	1
295	1192	17	1294	2	Q1	2012	12.4800	6.2400	4.0000	1
295	1298	17	0	12	Q4	2012	12.4800	6.1152	4.0000	1
295	1491	16	1231	9	Q3	2012	9.3600	4.0248	3.0000	1
295	1548	13	0	2	Q1	2012	12.4800	5.1168	4.0000	1
295	1567	16	0	9	Q3	2012	9.3600	3.6504	3.0000	1
295	1720	16	0	8	Q3	2012	6.2400	2.1216	2.0000	1
295	2086	13	0	10	Q4	2012	9.3600	2.9016	3.0000	1
295	2193	7	0	3	Q1	2012	15.6000	6.8640	5.0000	1
295	2479	13	0	7	Q3	2012	12.4800	5.3664	4.0000	1
295	2915	7	0	5	Q2	2012	6.2400	2.3712	2.0000	1
295	3203	7	0	11	Q4	2012	12.4800	5.1168	4.0000	1
295	3291	6	0	3	Q1	2012	15.6000	5.1480	5.0000	1
295	3528	17	0	10	Q4	2012	12.4800	4.6176	4.0000	1
295	3673	22	0	2	Q1	2012	3.1200	1.5288	1.0000	1
295	3681	13	0	7	Q3	2012	9.3600	2.9952	3.0000	1
295	3711	3	0	8	Q3	2012	6.2400	3.0576	2.0000	1
295	3738	7	526	12	Q4	2012	9.3600	2.9016	3.0000	1
295	5174	16	0	9	Q3	2012	12.4800	4.6176	4.0000	1
295	5639	11	0	7	Q3	2012	9.3600	3.3696	3.0000	1
295	5668	6	506	3	Q1	2012	9.3600	4.5864	3.0000	1
295	5923	23	1788	11	Q4	2012	12.4800	5.7408	4.0000	1
295	5958	13	0	11	Q4	2012	9.3600	3.7440	3.0000	1
295	5991	3	185	1	Q1	2012	9.3600	4.0248	3.0000	1
295	6641	24	0	5	Q2	2012	9.3600	2.8080	3.0000	1
295	6731	7	0	6	Q2	2012	15.6000	5.1480	5.0000	1
295	6754	7	0	7	Q3	2012	9.3600	3.3696	3.0000	1
295	6816	11	0	6	Q2	2012	9.3600	4.3992	3.0000	1
295	6953	2	121	8	Q3	2012	3.1200	1.5288	1.0000	1
295	7106	24	0	10	Q4	2012	9.3600	4.1184	3.0000	1
295	7305	24	1858	7	Q3	2012	9.3600	2.9016	3.0000	1
295	7359	13	0	8	Q3	2012	9.3600	4.4928	3.0000	1
295	7806	13	0	5	Q2	2012	9.3600	3.4632	3.0000	1
295	7940	13	0	9	Q3	2012	12.4800	5.6160	4.0000	1
295	8351	16	0	8	Q3	2012	12.4800	5.4912	4.0000	1
295	8841	13	0	2	Q1	2012	9.3600	4.5864	3.0000	1
295	8853	15	0	12	Q4	2012	9.3600	3.9312	3.0000	1
295	9019	7	0	5	Q2	2012	12.4800	5.1168	4.0000	1
295	9032	13	0	8	Q3	2012	9.3600	4.4928	3.0000	1
295	9184	3	0	3	Q1	2012	9.3600	3.1824	3.0000	1
295	9491	13	0	5	Q2	2012	6.2400	2.7456	2.0000	1
295	9498	23	0	7	Q3	2012	9.3600	3.3696	3.0000	1
295	9512	23	0	9	Q3	2012	6.2400	2.6832	2.0000	1
295	9627	24	0	10	Q4	2012	9.3600	4.5864	3.0000	1
295	9638	11	0	9	Q3	2012	9.3600	4.5864	3.0000	1
296	754	3	0	1	Q1	2012	2.0000	0.9600	4.0000	1
296	769	16	1236	12	Q4	2012	2.0000	0.8000	4.0000	1
296	1053	13	0	1	Q1	2012	1.0000	0.3800	2.0000	1
296	1253	13	986	6	Q2	2012	1.5000	0.7350	3.0000	1
296	1341	3	207	11	Q4	2012	2.0000	0.8800	4.0000	1
296	1810	2	0	5	Q2	2012	0.5000	0.1600	1.0000	1
296	2043	24	0	4	Q2	2012	1.0000	0.4300	2.0000	1
296	2046	7	0	8	Q3	2012	1.5000	0.5550	3.0000	1
296	2189	7	0	9	Q3	2012	1.0000	0.3500	2.0000	1
296	2201	16	0	9	Q3	2012	1.0000	0.4900	2.0000	1
296	2393	6	0	12	Q4	2012	2.0000	0.8600	4.0000	1
296	2645	22	0	1	Q1	2012	1.0000	0.3400	2.0000	1
296	2769	16	0	4	Q2	2012	1.0000	0.4400	2.0000	1
296	2921	16	1236	12	Q4	2012	2.0000	0.7600	4.0000	1
296	3253	13	0	7	Q3	2012	2.0000	0.7000	4.0000	1
296	3291	7	0	3	Q1	2012	2.5000	0.8000	5.0000	1
296	3316	7	517	8	Q3	2012	2.0000	0.6400	4.0000	1
296	3435	11	0	12	Q4	2012	2.0000	0.9600	4.0000	1
296	3580	6	0	11	Q4	2012	2.0000	0.8000	4.0000	1
296	3711	3	0	1	Q1	2012	1.0000	0.4900	2.0000	1
296	3937	13	0	9	Q3	2012	1.5000	0.4950	3.0000	1
296	4012	24	0	8	Q3	2012	1.5000	0.4500	3.0000	1
296	4021	16	1214	2	Q1	2012	2.0000	0.9600	4.0000	1
296	4120	15	1138	3	Q1	2012	1.0000	0.3900	2.0000	1
296	4385	7	0	1	Q1	2012	1.0000	0.3100	2.0000	1
296	4451	7	0	10	Q4	2012	1.0000	0.3200	2.0000	1
296	4503	13	0	11	Q4	2012	1.0000	0.3800	2.0000	1
296	4609	23	0	7	Q3	2012	2.0000	0.9200	4.0000	1
296	5433	13	982	4	Q2	2012	2.0000	0.9800	4.0000	1
296	5616	17	0	11	Q4	2012	1.0000	0.3300	2.0000	1
296	5958	13	0	6	Q2	2012	1.0000	0.4000	2.0000	1
296	6065	15	1157	12	Q4	2012	1.5000	0.6450	3.0000	1
296	6145	15	0	4	Q2	2012	1.5000	0.5850	3.0000	1
296	6642	24	1850	3	Q1	2012	1.0000	0.4500	2.0000	1
296	7046	15	0	7	Q3	2012	1.0000	0.4600	2.0000	1
296	7639	13	0	9	Q3	2012	1.0000	0.3000	2.0000	1
296	7832	7	0	7	Q3	2012	2.0000	1.0000	4.0000	1
296	7906	13	0	6	Q2	2012	1.5000	0.6450	3.0000	1
296	8022	15	1140	4	Q2	2012	1.0000	0.3700	2.0000	1
296	8427	16	0	5	Q2	2012	1.5000	0.7200	3.0000	1
296	8477	3	0	5	Q2	2012	2.0000	0.8200	4.0000	1
296	8597	6	0	5	Q2	2012	1.5000	0.6300	3.0000	1
296	8605	7	521	10	Q4	2012	2.0000	0.6000	4.0000	1
296	8629	24	1851	4	Q2	2012	1.5000	0.6000	3.0000	1
296	9223	24	1866	11	Q4	2012	1.5000	0.5400	3.0000	1
296	9309	17	0	10	Q4	2012	1.5000	0.6450	3.0000	1
296	9631	16	0	10	Q4	2012	1.5000	0.6000	3.0000	1
296	10145	13	980	3	Q1	2012	1.0000	0.4300	2.0000	1
297	422	13	0	8	Q3	2012	1.8000	0.7920	2.0000	1
297	511	16	0	4	Q2	2012	3.6000	1.7640	4.0000	1
297	968	15	1141	4	Q2	2012	2.7000	1.2690	3.0000	1
297	1003	17	0	11	Q4	2012	3.6000	1.5840	4.0000	1
297	1024	17	0	3	Q1	2012	2.7000	1.1070	3.0000	1
297	1034	24	1845	1	Q1	2012	2.7000	1.0530	3.0000	1
297	1055	15	0	12	Q4	2012	2.7000	0.9720	3.0000	1
297	1415	16	1235	11	Q4	2012	3.6000	1.7280	4.0000	1
297	1884	15	0	3	Q1	2012	2.7000	0.8370	3.0000	1
297	2011	23	1776	6	Q2	2012	2.7000	1.2960	3.0000	1
297	2035	15	0	11	Q4	2012	4.5000	1.3950	5.0000	1
297	2201	16	0	4	Q2	2012	1.8000	0.5400	2.0000	1
297	2241	7	0	11	Q4	2012	1.8000	0.6480	2.0000	1
297	2722	7	0	3	Q1	2012	2.7000	1.0800	3.0000	1
297	3010	7	523	11	Q4	2012	1.8000	0.7200	2.0000	1
297	3577	11	0	11	Q4	2012	4.5000	2.0250	5.0000	1
297	3676	3	0	7	Q3	2012	4.5000	1.3950	5.0000	1
297	3695	13	0	7	Q3	2012	3.6000	1.4760	4.0000	1
297	4351	23	0	7	Q3	2012	4.5000	2.2500	5.0000	1
297	4395	11	829	6	Q2	2012	3.6000	1.5120	4.0000	1
297	4403	7	512	6	Q2	2012	1.8000	0.5940	2.0000	1
297	4543	13	0	3	Q1	2012	1.8000	0.6840	2.0000	1
297	4804	13	0	1	Q1	2012	2.7000	1.1610	3.0000	1
297	4810	23	0	5	Q2	2012	2.7000	0.9450	3.0000	1
297	5171	7	0	4	Q2	2012	1.8000	0.7740	2.0000	1
297	5174	16	1214	2	Q1	2012	1.8000	0.6300	2.0000	1
297	5432	16	0	8	Q3	2012	1.8000	0.6300	2.0000	1
297	5636	15	0	7	Q3	2012	2.7000	0.8640	3.0000	1
297	5819	15	0	5	Q2	2012	3.6000	1.3680	4.0000	1
297	5952	15	0	7	Q3	2012	2.7000	1.1340	3.0000	1
297	6098	3	0	6	Q2	2012	2.7000	1.3230	3.0000	1
297	6114	16	0	1	Q1	2012	3.6000	1.1520	4.0000	1
297	6153	16	1220	4	Q2	2012	3.6000	1.3680	4.0000	1
297	6271	6	0	10	Q4	2012	1.8000	0.8460	2.0000	1
297	6479	2	0	11	Q4	2012	1.8000	0.8460	2.0000	1
297	6499	17	0	4	Q2	2012	4.5000	1.6650	5.0000	1
297	6647	17	0	12	Q4	2012	3.6000	1.4760	4.0000	1
297	6731	6	0	12	Q4	2012	2.7000	1.1070	3.0000	1
297	6994	7	526	12	Q4	2012	1.8000	0.5940	2.0000	1
297	7066	14	0	3	Q1	2012	1.8000	0.8100	2.0000	1
297	7562	15	0	11	Q4	2012	2.7000	1.1880	3.0000	1
297	7576	13	0	10	Q4	2012	3.6000	1.3680	4.0000	1
297	7589	17	1303	6	Q2	2012	2.7000	1.3230	3.0000	1
297	7772	15	0	1	Q1	2012	2.7000	0.9990	3.0000	1
297	7843	2	126	10	Q4	2012	1.8000	0.7380	2.0000	1
297	7910	15	0	2	Q1	2012	2.7000	0.8640	3.0000	1
297	8076	14	1071	8	Q3	2012	1.8000	0.5400	2.0000	1
297	8108	17	0	10	Q4	2012	2.7000	1.3500	3.0000	1
297	8222	15	1146	7	Q3	2012	3.6000	1.4400	4.0000	1
297	8634	7	0	1	Q1	2012	3.6000	1.5480	4.0000	1
297	8684	6	508	4	Q2	2012	1.8000	0.8640	2.0000	1
297	8958	22	1708	11	Q4	2012	2.7000	1.0530	3.0000	1
297	8975	15	0	7	Q3	2012	2.7000	1.2690	3.0000	1
297	9160	6	508	4	Q2	2012	2.7000	1.1610	3.0000	1
297	9164	15	0	1	Q1	2012	2.7000	1.2150	3.0000	1
297	9200	16	0	8	Q3	2012	2.7000	1.2420	3.0000	1
297	9236	13	0	1	Q1	2012	2.7000	1.2690	3.0000	1
297	9302	14	1065	6	Q2	2012	0.9000	0.4320	1.0000	1
297	9536	24	0	7	Q3	2012	2.7000	0.9720	3.0000	1
297	9851	3	0	2	Q1	2012	1.8000	0.6300	2.0000	1
297	10209	7	523	11	Q4	2012	2.7000	0.9450	3.0000	1
298	187	13	976	1	Q1	2012	5.6600	2.7734	2.0000	1
298	757	15	0	10	Q4	2012	5.6600	1.9244	2.0000	1
298	830	15	0	2	Q1	2012	11.3200	3.3960	4.0000	1
298	1015	7	0	6	Q2	2012	8.4900	3.4809	3.0000	1
298	1024	17	1293	1	Q1	2012	11.3200	5.4336	4.0000	1
298	1036	13	0	11	Q4	2012	14.1500	5.5185	5.0000	1
298	1244	11	821	3	Q1	2012	8.4900	4.1601	3.0000	1
298	1310	16	1231	9	Q3	2012	8.4900	3.6507	3.0000	1
298	1439	6	0	9	Q3	2012	11.3200	4.4148	4.0000	1
298	1466	15	0	2	Q1	2012	11.3200	5.0940	4.0000	1
298	1491	16	0	5	Q2	2012	8.4900	3.6507	3.0000	1
298	1897	13	0	10	Q4	2012	8.4900	2.9715	3.0000	1
298	2067	17	0	3	Q1	2012	14.1500	4.5280	5.0000	1
298	2147	13	0	7	Q3	2012	8.4900	3.2262	3.0000	1
298	2296	6	508	4	Q2	2012	8.4900	2.9715	3.0000	1
298	2587	16	0	4	Q2	2012	5.6600	2.7734	2.0000	1
298	2723	3	0	7	Q3	2012	8.4900	3.0564	3.0000	1
298	2976	7	514	7	Q3	2012	8.4900	2.8017	3.0000	1
298	3352	7	0	9	Q3	2012	5.6600	1.6980	2.0000	1
298	3476	3	0	7	Q3	2012	11.3200	4.4148	4.0000	1
298	3993	24	0	10	Q4	2012	8.4900	3.1413	3.0000	1
298	4205	15	1152	9	Q3	2012	5.6600	2.2074	2.0000	1
298	4322	15	1143	5	Q2	2012	8.4900	3.3960	3.0000	1
298	4476	24	1866	11	Q4	2012	8.4900	3.7356	3.0000	1
298	4843	24	0	12	Q4	2012	8.4900	3.5658	3.0000	1
298	5257	13	0	11	Q4	2012	8.4900	3.8205	3.0000	1
298	5731	6	0	12	Q4	2012	11.3200	4.0752	4.0000	1
298	6191	15	1140	4	Q2	2012	8.4900	3.3111	3.0000	1
298	6559	3	190	3	Q1	2012	11.3200	5.3204	4.0000	1
298	6574	13	0	7	Q3	2012	8.4900	4.1601	3.0000	1
298	6683	17	0	3	Q1	2012	11.3200	5.0940	4.0000	1
298	7220	3	0	7	Q3	2012	5.6600	1.7546	2.0000	1
298	7282	17	0	4	Q2	2012	8.4900	3.7356	3.0000	1
298	7486	3	197	6	Q2	2012	8.4900	3.6507	3.0000	1
298	7526	17	0	3	Q1	2012	8.4900	3.6507	3.0000	1
298	7589	17	0	12	Q4	2012	8.4900	4.1601	3.0000	1
298	7813	17	1314	11	Q4	2012	8.4900	2.8017	3.0000	1
298	7889	14	1062	4	Q2	2012	5.6600	2.4904	2.0000	1
298	7932	24	1850	3	Q1	2012	8.4900	3.0564	3.0000	1
298	8208	24	0	10	Q4	2012	8.4900	2.9715	3.0000	1
298	8587	22	0	3	Q1	2012	2.8300	1.2735	1.0000	1
298	8937	7	504	2	Q1	2012	8.4900	2.7168	3.0000	1
298	9204	7	0	5	Q2	2012	8.4900	3.0564	3.0000	1
298	9461	17	1303	6	Q2	2012	5.6600	2.7734	2.0000	1
298	9512	23	0	7	Q3	2012	8.4900	4.2450	3.0000	1
298	9564	17	0	2	Q1	2012	14.1500	4.2450	5.0000	1
298	10063	2	0	6	Q2	2012	2.8300	1.3867	1.0000	1
298	10274	6	515	7	Q3	2012	8.4900	3.0564	3.0000	1
299	341	17	0	3	Q1	2012	5.0400	1.5624	3.0000	1
299	769	16	0	12	Q4	2012	3.3600	1.1424	2.0000	1
299	790	13	0	7	Q3	2012	6.7200	2.4192	4.0000	1
299	1195	11	0	6	Q2	2012	6.7200	2.8896	4.0000	1
299	1215	7	0	10	Q4	2012	5.0400	2.1672	3.0000	1
299	1476	6	0	10	Q4	2012	8.4000	3.0240	5.0000	1
299	1610	3	0	3	Q1	2012	5.0400	1.8144	3.0000	1
299	1736	13	0	12	Q4	2012	5.0400	2.2176	3.0000	1
299	1798	3	0	8	Q3	2012	5.0400	1.8648	3.0000	1
299	2242	7	0	10	Q4	2012	5.0400	2.3688	3.0000	1
299	2570	16	0	3	Q1	2012	3.3600	1.2432	2.0000	1
299	2756	3	0	1	Q1	2012	6.7200	2.1504	4.0000	1
299	3000	17	0	11	Q4	2012	5.0400	1.7640	3.0000	1
299	3075	23	1789	12	Q4	2012	5.0400	2.2680	3.0000	1
299	3124	3	0	1	Q1	2012	6.7200	3.2256	4.0000	1
299	3422	23	0	12	Q4	2012	6.7200	2.6880	4.0000	1
299	3664	22	0	2	Q1	2012	1.6800	0.7392	1.0000	1
299	3725	23	1786	10	Q4	2012	3.3600	1.0080	2.0000	1
299	3776	13	0	10	Q4	2012	5.0400	1.7640	3.0000	1
299	4373	11	0	3	Q1	2012	6.7200	2.1504	4.0000	1
299	4543	13	0	1	Q1	2012	3.3600	1.3104	2.0000	1
299	4815	15	0	10	Q4	2012	6.7200	2.0832	4.0000	1
299	4898	24	0	10	Q4	2012	5.0400	2.1168	3.0000	1
299	5305	11	842	12	Q4	2012	5.0400	1.6128	3.0000	1
299	5346	3	0	12	Q4	2012	5.0400	2.3688	3.0000	1
299	5376	3	197	6	Q2	2012	3.3600	1.5120	2.0000	1
299	5461	22	0	3	Q1	2012	1.6800	0.5040	1.0000	1
299	5555	22	0	10	Q4	2012	5.0400	1.8144	3.0000	1
299	5973	3	0	5	Q2	2012	6.7200	3.0240	4.0000	1
299	6001	17	1314	11	Q4	2012	3.3600	1.3776	2.0000	1
299	6182	13	0	11	Q4	2012	8.4000	3.7800	5.0000	1
299	6439	7	501	1	Q1	2012	5.0400	1.6632	3.0000	1
299	6574	13	0	5	Q2	2012	5.0400	2.4696	3.0000	1
299	6699	15	1150	8	Q3	2012	3.3600	1.6464	2.0000	1
299	6759	22	0	1	Q1	2012	1.6800	0.5376	1.0000	1
299	7032	2	0	9	Q3	2012	3.3600	1.6464	2.0000	1
299	7037	11	0	11	Q4	2012	6.7200	2.1504	4.0000	1
299	7149	13	0	7	Q3	2012	5.0400	1.5120	3.0000	1
299	7291	11	0	7	Q3	2012	3.3600	1.6464	2.0000	1
299	7305	24	1858	7	Q3	2012	5.0400	1.5624	3.0000	1
299	7813	17	1293	1	Q1	2012	5.0400	1.9656	3.0000	1
299	7841	6	0	9	Q3	2012	6.7200	2.0832	4.0000	1
299	7845	13	986	6	Q2	2012	5.0400	1.8144	3.0000	1
299	8222	15	1143	5	Q2	2012	5.0400	1.5624	3.0000	1
299	8275	16	0	1	Q1	2012	6.7200	2.1504	4.0000	1
299	8901	13	0	6	Q2	2012	6.7200	2.8896	4.0000	1
299	9200	16	1233	10	Q4	2012	5.0400	2.2176	3.0000	1
299	9318	16	0	3	Q1	2012	5.0400	2.4696	3.0000	1
299	9622	6	0	8	Q3	2012	6.7200	2.0160	4.0000	1
299	9897	16	0	6	Q2	2012	3.3600	1.6464	2.0000	1
299	9992	24	0	2	Q1	2012	6.7200	2.4864	4.0000	1
300	234	24	1856	6	Q2	2012	5.8800	2.9400	2.0000	1
300	408	7	0	1	Q1	2012	5.8800	2.5284	2.0000	1
300	426	15	0	6	Q2	2012	5.8800	2.8224	2.0000	1
300	538	11	0	9	Q3	2012	11.7600	5.1744	4.0000	1
300	1647	7	523	11	Q4	2012	11.7600	4.1160	4.0000	1
300	1802	23	0	8	Q3	2012	8.8200	3.9690	3.0000	1
300	1850	16	0	4	Q2	2012	8.8200	4.3218	3.0000	1
300	1874	17	1304	7	Q3	2012	8.8200	3.0870	3.0000	1
300	2158	11	0	11	Q4	2012	8.8200	3.0870	3.0000	1
300	2232	6	522	10	Q4	2012	5.8800	2.8812	2.0000	1
300	2599	7	0	6	Q2	2012	5.8800	2.2344	2.0000	1
300	2695	13	0	3	Q1	2012	11.7600	5.2920	4.0000	1
300	2787	17	1311	10	Q4	2012	8.8200	3.4398	3.0000	1
300	2893	24	1860	8	Q3	2012	11.7600	5.2920	4.0000	1
300	3231	17	0	8	Q3	2012	14.7000	6.3210	5.0000	1
300	3351	22	1709	11	Q4	2012	2.9400	1.2642	1.0000	1
300	3539	17	1304	7	Q3	2012	8.8200	3.7926	3.0000	1
300	3577	11	821	3	Q1	2012	8.8200	4.3218	3.0000	1
300	3591	24	0	5	Q2	2012	8.8200	4.3218	3.0000	1
300	3650	15	0	5	Q2	2012	5.8800	2.6460	2.0000	1
300	3911	7	523	11	Q4	2012	5.8800	2.1168	2.0000	1
300	3950	13	0	5	Q2	2012	8.8200	2.9106	3.0000	1
300	3981	6	526	12	Q4	2012	11.7600	4.8216	4.0000	1
300	4719	23	1783	9	Q3	2012	5.8800	2.8812	2.0000	1
300	4727	16	1233	10	Q4	2012	11.7600	3.6456	4.0000	1
300	4877	15	0	3	Q1	2012	11.7600	5.7624	4.0000	1
300	5616	17	0	11	Q4	2012	8.8200	3.2634	3.0000	1
300	5664	11	833	8	Q3	2012	14.7000	5.5860	5.0000	1
300	5733	11	837	10	Q4	2012	11.7600	5.0568	4.0000	1
300	5829	22	0	12	Q4	2012	5.8800	1.7640	2.0000	1
300	5944	3	210	12	Q4	2012	11.7600	3.6456	4.0000	1
300	6172	15	1136	2	Q1	2012	11.7600	3.8808	4.0000	1
300	6647	17	0	1	Q1	2012	8.8200	3.7044	3.0000	1
300	7085	11	0	5	Q2	2012	8.8200	3.0870	3.0000	1
300	7189	13	0	5	Q2	2012	8.8200	2.6460	3.0000	1
300	7189	13	0	9	Q3	2012	5.8800	2.6460	2.0000	1
300	7501	24	0	8	Q3	2012	8.8200	2.7342	3.0000	1
300	7781	15	1134	1	Q1	2012	11.7600	4.4688	4.0000	1
300	7813	17	1304	7	Q3	2012	5.8800	2.5872	2.0000	1
300	7822	3	187	2	Q1	2012	5.8800	2.9400	2.0000	1
300	7873	24	1853	5	Q2	2012	11.7600	3.6456	4.0000	1
300	8303	15	0	4	Q2	2012	8.8200	2.8224	3.0000	1
300	8483	15	0	3	Q1	2012	11.7600	4.3512	4.0000	1
300	8495	15	1140	4	Q2	2012	8.8200	4.2336	3.0000	1
300	8511	16	0	4	Q2	2012	11.7600	3.9984	4.0000	1
300	9115	11	0	3	Q1	2012	8.8200	2.6460	3.0000	1
300	10195	7	523	11	Q4	2012	11.7600	4.2336	4.0000	1
300	10240	3	197	6	Q2	2012	8.8200	3.5280	3.0000	1
301	44	6	515	7	Q3	2012	1.5900	0.5724	3.0000	1
301	163	7	0	10	Q4	2012	2.1200	0.8692	4.0000	1
301	335	17	0	2	Q1	2012	2.1200	0.6572	4.0000	1
301	446	13	0	6	Q2	2012	1.5900	0.6678	3.0000	1
301	570	15	1143	5	Q2	2012	1.0600	0.3498	2.0000	1
301	950	13	0	10	Q4	2012	2.1200	0.8904	4.0000	1
301	1235	11	0	4	Q2	2012	1.5900	0.5088	3.0000	1
301	1251	7	0	11	Q4	2012	2.1200	0.6996	4.0000	1
301	1289	23	1781	8	Q3	2012	2.1200	0.9328	4.0000	1
301	1312	3	0	10	Q4	2012	1.0600	0.3922	2.0000	1
301	1347	13	0	11	Q4	2012	1.5900	0.7791	3.0000	1
301	1653	7	0	4	Q2	2012	1.5900	0.5565	3.0000	1
301	1701	13	0	11	Q4	2012	2.1200	0.6996	4.0000	1
301	1727	24	1866	11	Q4	2012	1.5900	0.6837	3.0000	1
301	1874	17	0	5	Q2	2012	2.1200	0.6572	4.0000	1
301	2059	17	0	4	Q2	2012	1.5900	0.7632	3.0000	1
301	2065	17	0	8	Q3	2012	1.5900	0.5883	3.0000	1
301	2201	16	0	10	Q4	2012	2.1200	0.6784	4.0000	1
301	2371	16	1214	2	Q1	2012	1.5900	0.5406	3.0000	1
301	2443	13	976	1	Q1	2012	1.5900	0.6837	3.0000	1
301	2776	22	0	6	Q2	2012	1.0600	0.5194	2.0000	1
301	2881	24	0	11	Q4	2012	1.0600	0.3498	2.0000	1
301	3021	16	0	8	Q3	2012	1.5900	0.7155	3.0000	1
301	3066	24	0	11	Q4	2012	1.0600	0.3498	2.0000	1
301	3231	17	0	3	Q1	2012	2.6500	0.9805	5.0000	1
301	3389	7	0	11	Q4	2012	1.0600	0.4134	2.0000	1
301	4070	23	0	3	Q1	2012	1.5900	0.5724	3.0000	1
301	4291	15	1134	1	Q1	2012	1.5900	0.6837	3.0000	1
301	4396	13	0	1	Q1	2012	1.0600	0.3604	2.0000	1
301	4417	3	0	1	Q1	2012	1.0600	0.4664	2.0000	1
301	4507	13	0	8	Q3	2012	1.0600	0.4770	2.0000	1
301	4677	11	0	12	Q4	2012	1.5900	0.6042	3.0000	1
301	4868	16	0	6	Q2	2012	1.0600	0.4134	2.0000	1
301	5143	17	1294	2	Q1	2012	1.5900	0.7155	3.0000	1
301	5158	3	0	3	Q1	2012	1.0600	0.3498	2.0000	1
301	5210	17	0	6	Q2	2012	1.5900	0.4770	3.0000	1
301	5341	17	1294	2	Q1	2012	1.5900	0.4929	3.0000	1
301	5533	13	988	7	Q3	2012	1.0600	0.4876	2.0000	1
301	5547	7	0	6	Q2	2012	1.5900	0.7473	3.0000	1
301	5685	13	0	4	Q2	2012	1.5900	0.5565	3.0000	1
301	5820	17	0	3	Q1	2012	1.0600	0.3710	2.0000	1
301	6039	13	0	4	Q2	2012	1.5900	0.6519	3.0000	1
301	6336	15	0	7	Q3	2012	1.5900	0.4770	3.0000	1
301	6630	24	1860	8	Q3	2012	1.5900	0.6678	3.0000	1
301	6841	3	0	5	Q2	2012	2.1200	1.0600	4.0000	1
301	6904	13	0	5	Q2	2012	2.1200	1.0600	4.0000	1
301	7446	13	0	1	Q1	2012	1.5900	0.6996	3.0000	1
301	8270	6	0	11	Q4	2012	1.5900	0.7473	3.0000	1
301	8334	11	837	10	Q4	2012	1.0600	0.5194	2.0000	1
301	8456	15	0	10	Q4	2012	1.0600	0.4876	2.0000	1
301	8853	15	0	9	Q3	2012	1.5900	0.4770	3.0000	1
301	9348	15	0	11	Q4	2012	2.1200	0.6360	4.0000	1
301	10190	15	1138	3	Q1	2012	1.5900	0.6360	3.0000	1
302	39	13	0	5	Q2	2012	10.3500	3.1050	3.0000	1
302	170	6	0	5	Q2	2012	10.3500	4.2435	3.0000	1
302	191	7	0	12	Q4	2012	6.9000	3.1050	2.0000	1
302	346	13	0	1	Q1	2012	6.9000	2.3460	2.0000	1
302	504	13	0	5	Q2	2012	6.9000	3.0360	2.0000	1
302	511	16	0	10	Q4	2012	13.8000	4.5540	4.0000	1
302	636	17	0	12	Q4	2012	6.9000	2.1390	2.0000	1
302	709	7	0	1	Q1	2012	10.3500	4.0365	3.0000	1
302	1627	2	0	2	Q1	2012	6.9000	2.6910	2.0000	1
302	2053	11	0	3	Q1	2012	10.3500	4.0365	3.0000	1
302	2690	3	0	2	Q1	2012	13.8000	4.8300	4.0000	1
302	2695	13	0	10	Q4	2012	13.8000	5.7960	4.0000	1
302	3020	13	984	5	Q2	2012	10.3500	3.3120	3.0000	1
302	3101	11	0	6	Q2	2012	13.8000	4.2780	4.0000	1
302	3193	24	1853	5	Q2	2012	6.9000	3.1740	2.0000	1
302	3211	2	0	1	Q1	2012	3.4500	1.3455	1.0000	1
302	3231	17	0	3	Q1	2012	17.2500	6.3825	5.0000	1
302	3749	15	1138	3	Q1	2012	10.3500	3.7260	3.0000	1
302	3759	13	0	7	Q3	2012	10.3500	4.0365	3.0000	1
302	3763	24	0	12	Q4	2012	10.3500	5.0715	3.0000	1
302	3821	15	0	8	Q3	2012	10.3500	4.6575	3.0000	1
302	3826	16	0	5	Q2	2012	6.9000	2.6220	2.0000	1
302	3878	3	0	3	Q1	2012	13.8000	5.9340	4.0000	1
302	3976	17	0	11	Q4	2012	13.8000	5.6580	4.0000	1
302	4460	3	0	3	Q1	2012	10.3500	4.6575	3.0000	1
302	4803	23	0	2	Q1	2012	13.8000	4.9680	4.0000	1
302	4892	17	0	1	Q1	2012	13.8000	4.4160	4.0000	1
302	4998	3	187	2	Q1	2012	13.8000	4.6920	4.0000	1
302	5063	3	0	5	Q2	2012	10.3500	5.0715	3.0000	1
302	5374	16	0	5	Q2	2012	6.9000	2.2770	2.0000	1
302	5394	7	519	9	Q3	2012	13.8000	4.9680	4.0000	1
302	5504	14	0	7	Q3	2012	3.4500	1.4835	1.0000	1
302	5542	16	0	6	Q2	2012	10.3500	3.1050	3.0000	1
302	5610	13	984	5	Q2	2012	10.3500	3.6225	3.0000	1
302	5690	7	0	11	Q4	2012	6.9000	2.2770	2.0000	1
302	5844	17	1312	10	Q4	2012	10.3500	4.8645	3.0000	1
302	6131	14	0	10	Q4	2012	6.9000	2.4150	2.0000	1
302	6147	7	0	11	Q4	2012	6.9000	2.7600	2.0000	1
302	6641	24	0	5	Q2	2012	10.3500	4.6575	3.0000	1
302	6799	17	0	3	Q1	2012	13.8000	6.0720	4.0000	1
302	7100	17	1303	6	Q2	2012	6.9000	3.0360	2.0000	1
302	7324	6	504	2	Q1	2012	10.3500	4.7610	3.0000	1
302	7556	17	1292	1	Q1	2012	17.2500	7.4175	5.0000	1
302	7571	6	0	12	Q4	2012	13.8000	6.0720	4.0000	1
302	7589	17	1312	10	Q4	2012	13.8000	4.2780	4.0000	1
302	7720	17	0	12	Q4	2012	13.8000	6.0720	4.0000	1
302	7743	3	0	9	Q3	2012	10.3500	4.3470	3.0000	1
302	7805	6	0	6	Q2	2012	13.8000	4.4160	4.0000	1
302	8038	24	0	8	Q3	2012	6.9000	3.0360	2.0000	1
302	8139	11	0	1	Q1	2012	6.9000	2.7600	2.0000	1
302	8185	2	0	11	Q4	2012	3.4500	1.4835	1.0000	1
302	8367	13	0	2	Q1	2012	10.3500	4.9680	3.0000	1
302	8612	22	0	10	Q4	2012	6.9000	2.1390	2.0000	1
302	9006	17	0	12	Q4	2012	10.3500	3.1050	3.0000	1
302	9357	7	0	6	Q2	2012	10.3500	3.3120	3.0000	1
302	9487	17	0	12	Q4	2012	10.3500	4.7610	3.0000	1
302	9584	13	0	2	Q1	2012	10.3500	4.0365	3.0000	1
302	9605	15	0	12	Q4	2012	10.3500	5.0715	3.0000	1
303	216	17	0	3	Q1	2012	7.7400	2.3220	3.0000	1
303	511	16	0	5	Q2	2012	10.3200	4.5408	4.0000	1
303	571	3	204	9	Q3	2012	7.7400	3.7926	3.0000	1
303	621	11	0	7	Q3	2012	5.1600	1.7544	2.0000	1
303	878	3	199	7	Q3	2012	5.1600	2.2704	2.0000	1
303	937	6	521	10	Q4	2012	7.7400	2.7864	3.0000	1
303	1028	7	0	3	Q1	2012	7.7400	3.3282	3.0000	1
303	1121	15	0	8	Q3	2012	5.1600	2.2704	2.0000	1
303	1124	3	0	4	Q2	2012	10.3200	4.4376	4.0000	1
303	1152	7	0	12	Q4	2012	7.7400	2.5542	3.0000	1
303	1241	11	0	7	Q3	2012	10.3200	4.4376	4.0000	1
303	1298	17	0	10	Q4	2012	10.3200	4.6440	4.0000	1
303	1430	3	0	11	Q4	2012	10.3200	4.4376	4.0000	1
303	1633	3	0	2	Q1	2012	7.7400	2.9412	3.0000	1
303	1965	17	0	7	Q3	2012	10.3200	4.2312	4.0000	1
303	2135	22	0	10	Q4	2012	5.1600	1.6512	2.0000	1
303	2327	13	0	1	Q1	2012	10.3200	4.0248	4.0000	1
303	2588	23	0	4	Q2	2012	7.7400	3.0186	3.0000	1
303	2808	13	0	11	Q4	2012	10.3200	3.4056	4.0000	1
303	3011	15	1142	5	Q2	2012	10.3200	3.4056	4.0000	1
303	3142	14	0	9	Q3	2012	5.1600	2.4768	2.0000	1
303	3388	13	0	4	Q2	2012	12.9000	6.3210	5.0000	1
303	4322	15	0	7	Q3	2012	5.1600	2.1672	2.0000	1
303	4868	16	0	1	Q1	2012	7.7400	2.4768	3.0000	1
303	5310	2	0	11	Q4	2012	5.1600	1.7544	2.0000	1
303	5533	13	0	2	Q1	2012	5.1600	2.3736	2.0000	1
303	5566	6	526	12	Q4	2012	7.7400	3.7152	3.0000	1
303	5568	23	0	11	Q4	2012	7.7400	3.0186	3.0000	1
303	5895	17	0	5	Q2	2012	5.1600	1.7028	2.0000	1
303	6153	16	1235	11	Q4	2012	7.7400	3.3282	3.0000	1
303	6174	7	0	7	Q3	2012	7.7400	3.0186	3.0000	1
303	6248	24	0	6	Q2	2012	5.1600	1.7544	2.0000	1
303	7038	24	1845	1	Q1	2012	10.3200	3.5088	4.0000	1
303	7715	13	0	7	Q3	2012	7.7400	2.4768	3.0000	1
303	7772	15	0	9	Q3	2012	5.1600	2.2704	2.0000	1
303	8189	17	0	1	Q1	2012	10.3200	3.9216	4.0000	1
303	8444	14	1078	12	Q4	2012	5.1600	2.2704	2.0000	1
303	8647	3	202	8	Q3	2012	7.7400	2.3994	3.0000	1
303	8907	3	187	2	Q1	2012	7.7400	2.8638	3.0000	1
303	9200	16	0	9	Q3	2012	7.7400	3.3282	3.0000	1
303	9224	17	0	12	Q4	2012	5.1600	1.7028	2.0000	1
303	9498	23	0	1	Q1	2012	10.3200	3.7152	4.0000	1
304	760	3	190	3	Q1	2012	5.6700	1.8144	3.0000	1
304	1178	11	0	7	Q3	2012	5.6700	2.3814	3.0000	1
304	1339	13	0	4	Q2	2012	3.7800	1.5120	2.0000	1
304	1660	13	0	3	Q1	2012	7.5600	3.4020	4.0000	1
304	1706	13	0	7	Q3	2012	7.5600	2.4948	4.0000	1
304	1795	24	0	11	Q4	2012	7.5600	2.4192	4.0000	1
304	1850	16	1235	11	Q4	2012	3.7800	1.5120	2.0000	1
304	1886	15	0	8	Q3	2012	5.6700	2.0412	3.0000	1
304	2134	11	0	10	Q4	2012	7.5600	3.2508	4.0000	1
304	2553	16	1233	10	Q4	2012	3.7800	1.8900	2.0000	1
304	2571	7	0	12	Q4	2012	5.6700	2.7783	3.0000	1
304	2664	17	0	10	Q4	2012	5.6700	2.0412	3.0000	1
304	2751	6	0	10	Q4	2012	3.7800	1.3230	2.0000	1
304	2756	3	187	2	Q1	2012	7.5600	2.7216	4.0000	1
304	2769	16	0	5	Q2	2012	3.7800	1.6632	2.0000	1
304	2859	14	1065	6	Q2	2012	1.8900	0.8505	1.0000	1
304	3552	17	1294	2	Q1	2012	5.6700	2.7783	3.0000	1
304	3591	24	1866	11	Q4	2012	5.6700	2.5515	3.0000	1
304	4100	7	0	4	Q2	2012	5.6700	2.4381	3.0000	1
304	4124	14	0	11	Q4	2012	1.8900	0.8127	1.0000	1
304	4149	11	0	5	Q2	2012	5.6700	1.9278	3.0000	1
304	4149	11	820	2	Q1	2012	3.7800	1.3986	2.0000	1
304	4263	24	0	8	Q3	2012	5.6700	2.3814	3.0000	1
304	4300	6	0	12	Q4	2012	5.6700	2.5515	3.0000	1
304	4398	7	0	9	Q3	2012	5.6700	1.8711	3.0000	1
304	4410	13	0	5	Q2	2012	7.5600	2.7216	4.0000	1
304	4431	13	980	3	Q1	2012	7.5600	3.4020	4.0000	1
304	4608	11	833	8	Q3	2012	3.7800	1.4742	2.0000	1
304	4743	6	504	2	Q1	2012	5.6700	1.7010	3.0000	1
304	5592	16	0	8	Q3	2012	3.7800	1.3986	2.0000	1
304	5808	7	0	1	Q1	2012	7.5600	2.7216	4.0000	1
304	5956	22	0	12	Q4	2012	3.7800	1.1718	2.0000	1
304	6003	13	0	9	Q3	2012	5.6700	2.2680	3.0000	1
304	6019	6	504	2	Q1	2012	3.7800	1.2474	2.0000	1
304	6174	7	0	11	Q4	2012	5.6700	2.2113	3.0000	1
304	6254	7	0	6	Q2	2012	3.7800	1.3230	2.0000	1
304	6501	24	0	2	Q1	2012	7.5600	3.1752	4.0000	1
304	6553	24	0	7	Q3	2012	7.5600	2.7216	4.0000	1
304	6630	24	0	7	Q3	2012	3.7800	1.8522	2.0000	1
304	6700	15	0	8	Q3	2012	5.6700	2.3247	3.0000	1
304	6710	13	0	7	Q3	2012	5.6700	2.7783	3.0000	1
304	6760	17	0	1	Q1	2012	5.6700	2.7783	3.0000	1
304	7151	24	0	11	Q4	2012	5.6700	1.9278	3.0000	1
304	7355	13	0	2	Q1	2012	5.6700	1.7010	3.0000	1
304	7362	11	0	7	Q3	2012	5.6700	2.7216	3.0000	1
304	7501	24	0	8	Q3	2012	5.6700	1.7577	3.0000	1
304	7557	14	0	5	Q2	2012	3.7800	1.7388	2.0000	1
304	7622	3	0	5	Q2	2012	7.5600	3.2508	4.0000	1
304	7684	7	0	1	Q1	2012	3.7800	1.2474	2.0000	1
304	7715	13	0	11	Q4	2012	9.4500	3.0240	5.0000	1
304	7809	2	118	6	Q2	2012	1.8900	0.8883	1.0000	1
304	7896	23	1772	4	Q2	2012	7.5600	3.2508	4.0000	1
304	8007	24	0	11	Q4	2012	5.6700	2.6082	3.0000	1
304	8141	22	0	10	Q4	2012	1.8900	0.7749	1.0000	1
304	8223	14	0	3	Q1	2012	3.7800	1.5498	2.0000	1
304	8275	16	0	8	Q3	2012	3.7800	1.6254	2.0000	1
304	8518	24	1850	3	Q1	2012	5.6700	1.9845	3.0000	1
304	8550	11	0	12	Q4	2012	3.7800	1.4364	2.0000	1
304	8601	7	504	2	Q1	2012	5.6700	2.4381	3.0000	1
304	9105	24	0	3	Q1	2012	9.4500	3.3075	5.0000	1
304	9263	16	1225	7	Q3	2012	5.6700	1.8711	3.0000	1
304	9421	22	0	1	Q1	2012	1.8900	0.8127	1.0000	1
304	9499	6	0	10	Q4	2012	5.6700	2.4948	3.0000	1
304	9543	15	1140	4	Q2	2012	5.6700	2.4381	3.0000	1
304	9642	3	0	4	Q2	2012	5.6700	2.7216	3.0000	1
304	10186	13	0	1	Q1	2012	5.6700	2.0979	3.0000	1
304	10274	7	0	5	Q2	2012	7.5600	3.4020	4.0000	1
305	294	24	0	9	Q3	2012	10.1700	3.5595	3.0000	1
305	638	11	0	2	Q1	2012	6.7800	3.3222	2.0000	1
305	754	3	0	4	Q2	2012	10.1700	3.9663	3.0000	1
305	781	24	1858	7	Q3	2012	6.7800	2.3730	2.0000	1
305	873	24	0	11	Q4	2012	13.5600	6.6444	4.0000	1
305	1168	17	1307	8	Q3	2012	13.5600	4.3392	4.0000	1
305	1474	15	0	1	Q1	2012	10.1700	3.9663	3.0000	1
305	1773	13	0	3	Q1	2012	10.1700	4.8816	3.0000	1
305	2065	17	0	9	Q3	2012	13.5600	4.6104	4.0000	1
305	2195	7	0	6	Q2	2012	13.5600	5.0172	4.0000	1
305	2204	3	0	11	Q4	2012	6.7800	2.0340	2.0000	1
305	2270	11	0	5	Q2	2012	6.7800	2.0340	2.0000	1
305	2378	16	0	10	Q4	2012	10.1700	4.4748	3.0000	1
305	2513	11	837	10	Q4	2012	10.1700	4.1697	3.0000	1
305	2820	7	0	11	Q4	2012	13.5600	4.3392	4.0000	1
305	3038	2	0	5	Q2	2012	3.3900	1.3899	1.0000	1
305	3159	24	0	5	Q2	2012	6.7800	3.2544	2.0000	1
305	3245	17	0	1	Q1	2012	13.5600	4.3392	4.0000	1
305	3373	15	0	2	Q1	2012	16.9500	5.2545	5.0000	1
305	3564	14	1066	6	Q2	2012	6.7800	2.3730	2.0000	1
305	3567	16	1231	9	Q3	2012	10.1700	4.5765	3.0000	1
305	3816	3	207	11	Q4	2012	10.1700	3.8646	3.0000	1
305	3922	7	523	11	Q4	2012	10.1700	4.4748	3.0000	1
305	4065	3	0	2	Q1	2012	10.1700	4.8816	3.0000	1
305	4078	3	0	5	Q2	2012	13.5600	4.2036	4.0000	1
305	4261	13	0	11	Q4	2012	10.1700	3.5595	3.0000	1
305	4282	15	0	2	Q1	2012	13.5600	5.0172	4.0000	1
305	4391	16	1235	11	Q4	2012	10.1700	3.2544	3.0000	1
305	4405	13	0	9	Q3	2012	10.1700	4.9833	3.0000	1
305	4537	7	526	12	Q4	2012	6.7800	2.7120	2.0000	1
305	4541	3	0	2	Q1	2012	6.7800	2.1696	2.0000	1
305	4676	16	0	12	Q4	2012	10.1700	4.9833	3.0000	1
305	4727	16	0	7	Q3	2012	13.5600	4.7460	4.0000	1
305	4810	23	1776	6	Q2	2012	10.1700	4.8816	3.0000	1
305	5019	23	0	11	Q4	2012	13.5600	4.2036	4.0000	1
305	5597	3	0	12	Q4	2012	10.1700	4.9833	3.0000	1
305	6526	13	0	11	Q4	2012	13.5600	6.3732	4.0000	1
305	6544	13	0	7	Q3	2012	13.5600	5.0172	4.0000	1
305	6664	15	1146	7	Q3	2012	10.1700	4.9833	3.0000	1
305	6781	15	0	12	Q4	2012	10.1700	3.9663	3.0000	1
305	6894	24	0	9	Q3	2012	10.1700	4.3731	3.0000	1
305	7352	7	0	1	Q1	2012	13.5600	5.8308	4.0000	1
305	7486	3	187	2	Q1	2012	10.1700	4.3731	3.0000	1
305	7655	17	0	3	Q1	2012	10.1700	3.5595	3.0000	1
305	7735	15	0	8	Q3	2012	10.1700	4.7799	3.0000	1
305	7904	6	0	12	Q4	2012	10.1700	4.5765	3.0000	1
305	8158	11	0	3	Q1	2012	10.1700	4.3731	3.0000	1
305	8899	7	516	8	Q3	2012	10.1700	3.1527	3.0000	1
305	9064	17	0	8	Q3	2012	10.1700	3.7629	3.0000	1
305	9504	13	0	12	Q4	2012	6.7800	2.7798	2.0000	1
305	9673	13	0	2	Q1	2012	6.7800	2.7798	2.0000	1
305	9897	16	0	10	Q4	2012	13.5600	4.3392	4.0000	1
306	260	11	0	7	Q3	2012	15.8400	4.9104	4.0000	1
306	569	23	1788	11	Q4	2012	15.8400	6.9696	4.0000	1
306	647	3	0	1	Q1	2012	15.8400	7.2864	4.0000	1
306	1055	15	0	12	Q4	2012	7.9200	3.0888	2.0000	1
306	1090	6	524	11	Q4	2012	11.8800	4.2768	3.0000	1
306	1310	16	0	6	Q2	2012	15.8400	5.5440	4.0000	1
306	1328	17	1292	1	Q1	2012	15.8400	5.8608	4.0000	1
306	1481	15	0	7	Q3	2012	15.8400	6.4944	4.0000	1
306	1649	24	0	8	Q3	2012	15.8400	5.5440	4.0000	1
306	1821	13	0	8	Q3	2012	15.8400	5.2272	4.0000	1
306	1924	14	1056	1	Q1	2012	3.9600	1.5444	1.0000	1
306	2065	17	0	3	Q1	2012	11.8800	5.8212	3.0000	1
306	2218	7	504	2	Q1	2012	11.8800	3.5640	3.0000	1
306	2263	11	0	3	Q1	2012	7.9200	3.1680	2.0000	1
306	2570	16	1220	4	Q2	2012	11.8800	4.2768	3.0000	1
306	2695	13	0	10	Q4	2012	15.8400	4.9104	4.0000	1
306	2968	13	0	12	Q4	2012	19.8000	6.9300	5.0000	1
306	2981	23	1772	4	Q2	2012	7.9200	2.6136	2.0000	1
306	2981	23	1775	5	Q2	2012	11.8800	4.1580	3.0000	1
306	3286	22	0	10	Q4	2012	11.8800	4.2768	3.0000	1
306	3360	13	0	3	Q1	2012	11.8800	5.7024	3.0000	1
306	3466	15	1152	9	Q3	2012	11.8800	5.3460	3.0000	1
306	3719	23	0	7	Q3	2012	15.8400	5.5440	4.0000	1
306	3863	6	0	3	Q1	2012	7.9200	3.5640	2.0000	1
306	3921	23	0	7	Q3	2012	11.8800	5.4648	3.0000	1
306	4209	2	129	11	Q4	2012	7.9200	3.8808	2.0000	1
306	4369	15	0	1	Q1	2012	11.8800	5.3460	3.0000	1
306	4404	24	1856	6	Q2	2012	7.9200	3.1680	2.0000	1
306	4693	3	0	7	Q3	2012	11.8800	5.1084	3.0000	1
306	4776	6	0	5	Q2	2012	11.8800	4.3956	3.0000	1
306	4982	24	0	12	Q4	2012	11.8800	3.6828	3.0000	1
306	5524	11	836	9	Q3	2012	15.8400	5.0688	4.0000	1
306	5766	16	0	3	Q1	2012	11.8800	4.7520	3.0000	1
306	5958	13	0	7	Q3	2012	11.8800	5.2272	3.0000	1
306	6232	15	0	10	Q4	2012	11.8800	5.8212	3.0000	1
306	6244	14	1078	12	Q4	2012	7.9200	3.6432	2.0000	1
306	6733	13	0	9	Q3	2012	15.8400	5.0688	4.0000	1
306	6766	24	0	11	Q4	2012	11.8800	4.2768	3.0000	1
306	7059	17	1312	10	Q4	2012	11.8800	5.4648	3.0000	1
306	7193	7	0	11	Q4	2012	7.9200	2.6928	2.0000	1
306	7263	11	0	1	Q1	2012	11.8800	4.1580	3.0000	1
306	7502	16	0	10	Q4	2012	15.8400	5.0688	4.0000	1
306	7858	15	0	8	Q3	2012	19.8000	8.5140	5.0000	1
306	8622	7	0	1	Q1	2012	7.9200	3.9600	2.0000	1
306	9167	11	836	9	Q3	2012	15.8400	7.1280	4.0000	1
306	9437	15	0	2	Q1	2012	7.9200	2.6928	2.0000	1
306	9747	13	984	5	Q2	2012	7.9200	3.0888	2.0000	1
306	9826	13	980	3	Q1	2012	15.8400	7.1280	4.0000	1
306	9897	16	0	8	Q3	2012	15.8400	5.0688	4.0000	1
306	10043	22	0	3	Q1	2012	3.9600	1.9008	1.0000	1
307	115	6	0	12	Q4	2012	4.4400	1.9092	3.0000	1
307	543	13	0	10	Q4	2012	2.9600	0.9176	2.0000	1
307	621	11	0	7	Q3	2012	4.4400	1.5984	3.0000	1
307	880	11	0	1	Q1	2012	5.9200	2.1904	4.0000	1
307	970	14	0	2	Q1	2012	1.4800	0.5180	1.0000	1
307	1313	15	0	7	Q3	2012	2.9600	1.1840	2.0000	1
307	1332	11	0	4	Q2	2012	7.4000	3.7000	5.0000	1
307	1432	11	0	7	Q3	2012	4.4400	1.9092	3.0000	1
307	1442	3	188	2	Q1	2012	5.9200	2.9008	4.0000	1
307	1659	15	1152	9	Q3	2012	4.4400	1.5540	3.0000	1
307	1671	24	0	3	Q1	2012	4.4400	1.7316	3.0000	1
307	1887	11	0	1	Q1	2012	5.9200	2.9600	4.0000	1
307	1932	15	0	5	Q2	2012	4.4400	1.4652	3.0000	1
307	2234	13	0	7	Q3	2012	5.9200	2.4864	4.0000	1
307	2302	15	0	11	Q4	2012	7.4000	2.7380	5.0000	1
307	2431	3	0	11	Q4	2012	2.9600	0.9768	2.0000	1
307	2772	24	0	11	Q4	2012	4.4400	2.2200	3.0000	1
307	2808	13	0	12	Q4	2012	4.4400	1.9980	3.0000	1
307	2890	7	0	1	Q1	2012	5.9200	2.9008	4.0000	1
307	3143	7	0	4	Q2	2012	4.4400	2.0424	3.0000	1
307	3533	3	0	4	Q2	2012	2.9600	1.3024	2.0000	1
307	3567	16	0	5	Q2	2012	4.4400	1.9980	3.0000	1
307	3716	17	0	5	Q2	2012	4.4400	1.3764	3.0000	1
307	3966	15	0	12	Q4	2012	4.4400	1.8648	3.0000	1
307	4261	13	0	11	Q4	2012	5.9200	2.7824	4.0000	1
307	4436	3	199	7	Q3	2012	2.9600	1.1840	2.0000	1
307	4824	3	0	6	Q2	2012	5.9200	2.3680	4.0000	1
307	4858	17	0	8	Q3	2012	4.4400	1.6428	3.0000	1
307	4902	6	508	4	Q2	2012	7.4000	3.2560	5.0000	1
307	5063	3	199	7	Q3	2012	2.9600	1.2728	2.0000	1
307	5596	6	513	6	Q2	2012	4.4400	1.8648	3.0000	1
307	5847	22	0	3	Q1	2012	2.9600	1.3320	2.0000	1
307	6180	13	0	2	Q1	2012	4.4400	1.9980	3.0000	1
307	6306	13	0	1	Q1	2012	5.9200	2.6640	4.0000	1
307	6493	24	0	5	Q2	2012	4.4400	1.9092	3.0000	1
307	6553	24	0	8	Q3	2012	5.9200	2.4272	4.0000	1
307	6571	24	1856	6	Q2	2012	5.9200	2.4864	4.0000	1
307	6617	7	516	8	Q3	2012	4.4400	2.1756	3.0000	1
307	6792	13	0	7	Q3	2012	5.9200	2.9008	4.0000	1
307	6816	11	0	8	Q3	2012	2.9600	1.1840	2.0000	1
307	6856	15	0	1	Q1	2012	4.4400	1.3764	3.0000	1
307	7056	3	0	8	Q3	2012	2.9600	1.1840	2.0000	1
307	7085	11	820	2	Q1	2012	4.4400	1.9980	3.0000	1
307	7310	11	0	6	Q2	2012	7.4000	3.6260	5.0000	1
307	8108	17	0	10	Q4	2012	4.4400	1.7760	3.0000	1
307	8151	6	0	6	Q2	2012	2.9600	1.4208	2.0000	1
307	8248	6	519	9	Q3	2012	4.4400	1.8648	3.0000	1
307	8250	15	0	11	Q4	2012	5.9200	2.7232	4.0000	1
307	8329	15	0	8	Q3	2012	5.9200	2.3088	4.0000	1
307	8524	15	0	12	Q4	2012	2.9600	1.4208	2.0000	1
307	8546	6	0	2	Q1	2012	4.4400	1.9092	3.0000	1
307	8594	7	504	2	Q1	2012	4.4400	1.3764	3.0000	1
307	8798	6	0	6	Q2	2012	2.9600	1.3320	2.0000	1
307	9064	17	0	11	Q4	2012	4.4400	1.4208	3.0000	1
307	9136	2	0	8	Q3	2012	2.9600	0.9472	2.0000	1
307	9169	23	0	11	Q4	2012	5.9200	2.3088	4.0000	1
307	9318	16	0	9	Q3	2012	4.4400	1.9536	3.0000	1
307	9401	13	0	5	Q2	2012	2.9600	1.4800	2.0000	1
307	9591	6	526	12	Q4	2012	5.9200	1.8352	4.0000	1
307	9633	7	504	2	Q1	2012	4.4400	1.3764	3.0000	1
307	10039	24	1845	1	Q1	2012	4.4400	1.4652	3.0000	1
308	88	11	0	4	Q2	2012	4.3600	1.3952	2.0000	1
308	326	2	119	7	Q3	2012	2.1800	1.0028	1.0000	1
308	878	3	0	5	Q2	2012	6.5400	2.0274	3.0000	1
308	910	15	0	9	Q3	2012	8.7200	3.0520	4.0000	1
308	1140	22	1704	9	Q3	2012	2.1800	0.8066	1.0000	1
308	1328	17	0	12	Q4	2012	4.3600	1.8312	2.0000	1
308	1747	24	0	3	Q1	2012	6.5400	2.5506	3.0000	1
308	1765	22	0	12	Q4	2012	6.5400	2.6160	3.0000	1
308	1850	16	0	6	Q2	2012	4.3600	1.7876	2.0000	1
308	1897	13	0	11	Q4	2012	6.5400	3.1392	3.0000	1
308	1938	24	0	3	Q1	2012	4.3600	1.9184	2.0000	1
308	1999	11	820	2	Q1	2012	6.5400	2.4198	3.0000	1
308	2039	11	829	6	Q2	2012	8.7200	3.3136	4.0000	1
308	2311	6	0	12	Q4	2012	4.3600	1.3952	2.0000	1
308	2511	17	0	2	Q1	2012	8.7200	3.4880	4.0000	1
308	2614	13	0	3	Q1	2012	6.5400	2.8122	3.0000	1
308	2625	13	0	2	Q1	2012	4.3600	2.0056	2.0000	1
308	2662	11	824	4	Q2	2012	10.9000	4.7960	5.0000	1
308	2762	13	0	6	Q2	2012	6.5400	2.2236	3.0000	1
308	3041	24	1866	11	Q4	2012	8.7200	3.1392	4.0000	1
308	3130	13	982	4	Q2	2012	8.7200	3.5752	4.0000	1
308	3271	13	0	7	Q3	2012	6.5400	2.1582	3.0000	1
308	3299	14	0	10	Q4	2012	4.3600	1.3516	2.0000	1
308	3463	13	0	1	Q1	2012	4.3600	1.6132	2.0000	1
308	3691	17	1311	10	Q4	2012	8.7200	3.2264	4.0000	1
308	3706	13	0	7	Q3	2012	4.3600	1.9620	2.0000	1
308	3826	16	0	5	Q2	2012	8.7200	3.1392	4.0000	1
308	3844	7	0	10	Q4	2012	8.7200	2.6160	4.0000	1
308	4179	24	0	5	Q2	2012	8.7200	3.7496	4.0000	1
308	4342	13	0	1	Q1	2012	6.5400	2.2890	3.0000	1
308	4465	13	0	3	Q1	2012	6.5400	2.1582	3.0000	1
308	4618	3	0	3	Q1	2012	8.7200	3.6624	4.0000	1
308	4621	24	0	2	Q1	2012	8.7200	4.2728	4.0000	1
308	4680	6	0	8	Q3	2012	6.5400	3.1392	3.0000	1
308	4892	17	1314	11	Q4	2012	4.3600	1.5260	2.0000	1
308	5038	17	0	10	Q4	2012	4.3600	1.5260	2.0000	1
308	5892	15	0	1	Q1	2012	6.5400	2.8776	3.0000	1
308	5906	15	0	1	Q1	2012	4.3600	2.1800	2.0000	1
308	5999	23	0	6	Q2	2012	6.5400	2.9430	3.0000	1
308	6098	3	0	6	Q2	2012	8.7200	2.8776	4.0000	1
308	6894	24	1858	7	Q3	2012	8.7200	3.1392	4.0000	1
308	7281	17	0	11	Q4	2012	6.5400	2.0274	3.0000	1
308	8382	15	0	6	Q2	2012	6.5400	3.1392	3.0000	1
308	8600	6	0	10	Q4	2012	6.5400	2.0274	3.0000	1
308	9046	14	0	3	Q1	2012	2.1800	0.7848	1.0000	1
308	9068	7	0	8	Q3	2012	4.3600	1.7440	2.0000	1
308	9299	24	0	10	Q4	2012	6.5400	2.5506	3.0000	1
308	9543	15	1140	4	Q2	2012	8.7200	3.4880	4.0000	1
308	9745	17	0	5	Q2	2012	6.5400	2.6160	3.0000	1
308	9900	15	0	6	Q2	2012	8.7200	3.0520	4.0000	1
309	709	7	0	11	Q4	2012	7.2400	3.0408	2.0000	1
309	769	16	0	12	Q4	2012	14.4800	5.5024	4.0000	1
309	782	17	0	10	Q4	2012	7.2400	2.2444	2.0000	1
309	817	17	1293	1	Q1	2012	7.2400	2.6064	2.0000	1
309	941	13	0	4	Q2	2012	10.8600	4.5612	3.0000	1
309	1130	15	1141	4	Q2	2012	18.1000	8.8690	5.0000	1
309	1193	13	0	11	Q4	2012	10.8600	4.7784	3.0000	1
309	1366	13	0	12	Q4	2012	14.4800	5.5024	4.0000	1
309	1511	11	0	11	Q4	2012	10.8600	4.6698	3.0000	1
309	1652	2	124	9	Q3	2012	3.6200	1.3756	1.0000	1
309	1743	6	0	11	Q4	2012	10.8600	3.4752	3.0000	1
309	1977	23	0	10	Q4	2012	14.4800	4.6336	4.0000	1
309	2863	17	0	7	Q3	2012	14.4800	6.3712	4.0000	1
309	3021	16	0	12	Q4	2012	10.8600	5.3214	3.0000	1
309	3491	16	1228	8	Q3	2012	7.2400	3.6200	2.0000	1
309	3586	11	0	11	Q4	2012	14.4800	4.6336	4.0000	1
309	3782	24	1869	12	Q4	2012	10.8600	3.8010	3.0000	1
309	3813	7	504	2	Q1	2012	14.4800	5.6472	4.0000	1
309	3908	7	0	9	Q3	2012	10.8600	5.2128	3.0000	1
309	4066	3	195	5	Q2	2012	14.4800	4.4888	4.0000	1
309	4175	16	0	9	Q3	2012	7.2400	2.5340	2.0000	1
309	4204	17	0	12	Q4	2012	14.4800	6.2264	4.0000	1
309	4719	23	1789	12	Q4	2012	10.8600	3.4752	3.0000	1
309	4784	11	0	12	Q4	2012	10.8600	4.3440	3.0000	1
309	4892	17	0	1	Q1	2012	7.2400	2.5340	2.0000	1
309	4962	11	0	3	Q1	2012	7.2400	2.2444	2.0000	1
309	5026	17	0	12	Q4	2012	14.4800	5.6472	4.0000	1
309	5238	17	1304	7	Q3	2012	14.4800	6.0816	4.0000	1
309	5339	11	0	7	Q3	2012	14.4800	5.7920	4.0000	1
309	5678	6	0	12	Q4	2012	14.4800	4.6336	4.0000	1
309	5733	11	0	6	Q2	2012	7.2400	2.9684	2.0000	1
309	5739	11	829	6	Q2	2012	14.4800	5.0680	4.0000	1
309	5865	15	0	12	Q4	2012	7.2400	2.2444	2.0000	1
309	6148	11	0	1	Q1	2012	7.2400	2.8236	2.0000	1
309	6542	7	0	4	Q2	2012	14.4800	5.7920	4.0000	1
309	6560	17	0	10	Q4	2012	10.8600	4.0182	3.0000	1
309	6966	24	1860	8	Q3	2012	10.8600	5.1042	3.0000	1
309	7077	24	1869	12	Q4	2012	10.8600	3.9096	3.0000	1
309	7177	24	1845	1	Q1	2012	14.4800	6.5160	4.0000	1
309	7343	7	505	2	Q1	2012	14.4800	5.3576	4.0000	1
309	7525	2	108	1	Q1	2012	3.6200	1.2308	1.0000	1
309	7536	7	0	3	Q1	2012	14.4800	4.6336	4.0000	1
309	7558	13	0	6	Q2	2012	10.8600	4.8870	3.0000	1
309	8089	17	1311	10	Q4	2012	10.8600	5.3214	3.0000	1
309	8139	11	0	7	Q3	2012	10.8600	3.6924	3.0000	1
309	8175	15	0	6	Q2	2012	10.8600	4.2354	3.0000	1
309	8284	22	0	11	Q4	2012	7.2400	3.5476	2.0000	1
309	8310	13	0	4	Q2	2012	14.4800	6.6608	4.0000	1
309	8577	23	1765	1	Q1	2012	18.1000	6.6970	5.0000	1
309	8739	7	0	11	Q4	2012	10.8600	4.6698	3.0000	1
309	9254	15	0	6	Q2	2012	10.8600	5.1042	3.0000	1
309	9491	13	0	8	Q3	2012	7.2400	3.1132	2.0000	1
309	9631	16	0	4	Q2	2012	7.2400	3.1132	2.0000	1
309	9874	15	0	5	Q2	2012	14.4800	4.6336	4.0000	1
309	9875	24	0	8	Q3	2012	14.4800	5.3576	4.0000	1
309	9959	7	0	9	Q3	2012	14.4800	5.5024	4.0000	1
309	10167	17	0	8	Q3	2012	10.8600	3.6924	3.0000	1
309	10273	17	0	11	Q4	2012	10.8600	3.4752	3.0000	1
310	717	6	0	2	Q1	2012	1.5200	0.5624	2.0000	1
310	723	7	0	6	Q2	2012	1.5200	0.4712	2.0000	1
310	1083	11	829	6	Q2	2012	3.0400	1.1552	4.0000	1
310	1281	3	0	2	Q1	2012	2.2800	0.9120	3.0000	1
310	1293	2	0	1	Q1	2012	0.7600	0.3420	1.0000	1
310	1497	17	0	9	Q3	2012	2.2800	0.7524	3.0000	1
310	1718	13	984	5	Q2	2012	2.2800	0.7980	3.0000	1
310	1994	15	0	11	Q4	2012	2.2800	0.7524	3.0000	1
310	2224	16	1235	11	Q4	2012	3.0400	0.9424	4.0000	1
310	2422	13	0	1	Q1	2012	3.0400	1.1552	4.0000	1
310	2431	3	0	8	Q3	2012	2.2800	0.9348	3.0000	1
310	2496	11	0	8	Q3	2012	2.2800	1.0032	3.0000	1
310	2941	24	1847	2	Q1	2012	2.2800	0.7296	3.0000	1
310	3092	15	1143	5	Q2	2012	1.5200	0.6536	2.0000	1
310	3253	13	0	7	Q3	2012	2.2800	1.0260	3.0000	1
310	3328	17	0	11	Q4	2012	1.5200	0.7600	2.0000	1
310	3782	24	0	4	Q2	2012	1.5200	0.6840	2.0000	1
310	4342	13	0	1	Q1	2012	3.0400	1.4288	4.0000	1
310	5142	11	0	6	Q2	2012	1.5200	0.6688	2.0000	1
310	5182	15	0	7	Q3	2012	2.2800	0.8664	3.0000	1
310	5295	16	0	12	Q4	2012	2.2800	0.7068	3.0000	1
310	5574	24	0	12	Q4	2012	1.5200	0.6840	2.0000	1
310	5650	2	0	4	Q2	2012	0.7600	0.2964	1.0000	1
310	5844	17	1294	2	Q1	2012	1.5200	0.5168	2.0000	1
310	6061	17	0	8	Q3	2012	2.2800	1.0260	3.0000	1
310	6114	16	0	3	Q1	2012	3.8000	1.8620	5.0000	1
310	6168	17	0	8	Q3	2012	1.5200	0.6688	2.0000	1
310	6208	17	0	12	Q4	2012	2.2800	1.0944	3.0000	1
310	6352	13	0	2	Q1	2012	3.0400	1.3072	4.0000	1
310	6577	15	1149	8	Q3	2012	2.2800	1.0260	3.0000	1
310	6703	11	0	7	Q3	2012	2.2800	0.7524	3.0000	1
310	7031	11	0	4	Q2	2012	2.2800	1.0260	3.0000	1
310	7271	6	0	11	Q4	2012	2.2800	0.9576	3.0000	1
310	7948	17	1307	8	Q3	2012	2.2800	0.7980	3.0000	1
310	8003	3	185	1	Q1	2012	2.2800	0.7980	3.0000	1
310	8041	24	1859	8	Q3	2012	2.2800	1.0032	3.0000	1
310	8164	13	0	11	Q4	2012	3.0400	1.3376	4.0000	1
310	8653	3	0	9	Q3	2012	3.0400	1.4288	4.0000	1
310	8665	15	0	12	Q4	2012	1.5200	0.7296	2.0000	1
310	8747	7	0	10	Q4	2012	2.2800	0.7068	3.0000	1
310	9224	17	1292	1	Q1	2012	2.2800	0.8208	3.0000	1
310	9419	11	0	5	Q2	2012	2.2800	1.1172	3.0000	1
310	9437	15	0	2	Q1	2012	2.2800	0.8208	3.0000	1
310	9823	13	0	5	Q2	2012	2.2800	0.8208	3.0000	1
310	9864	7	505	2	Q1	2012	3.0400	0.9424	4.0000	1
310	10056	7	0	8	Q3	2012	1.5200	0.4712	2.0000	1
310	10176	13	0	8	Q3	2012	2.2800	0.7524	3.0000	1
311	717	6	0	8	Q3	2012	4.3000	1.6770	2.0000	1
311	722	24	1845	1	Q1	2012	8.6000	3.6120	4.0000	1
311	887	14	0	4	Q2	2012	2.1500	0.9460	1.0000	1
311	1131	15	1157	12	Q4	2012	8.6000	3.0100	4.0000	1
311	1442	3	0	4	Q2	2012	8.6000	3.0960	4.0000	1
311	1738	6	0	1	Q1	2012	8.6000	2.7520	4.0000	1
311	1874	17	1304	7	Q3	2012	6.4500	2.4510	3.0000	1
311	1932	15	0	5	Q2	2012	6.4500	2.2575	3.0000	1
311	2362	6	0	11	Q4	2012	4.3000	1.7200	2.0000	1
311	2460	24	0	10	Q4	2012	6.4500	2.7090	3.0000	1
311	2681	7	504	2	Q1	2012	4.3000	1.6770	2.0000	1
311	2725	11	0	11	Q4	2012	10.7500	3.4400	5.0000	1
311	2908	11	0	7	Q3	2012	8.6000	3.2680	4.0000	1
311	2924	3	199	7	Q3	2012	8.6000	3.0960	4.0000	1
311	3021	16	0	8	Q3	2012	8.6000	3.2680	4.0000	1
311	3539	17	0	12	Q4	2012	6.4500	2.7735	3.0000	1
311	3635	15	0	11	Q4	2012	8.6000	2.8380	4.0000	1
311	3664	22	0	6	Q2	2012	4.3000	1.6770	2.0000	1
311	3706	13	0	11	Q4	2012	6.4500	2.1285	3.0000	1
311	3725	23	0	10	Q4	2012	4.3000	1.3760	2.0000	1
311	3905	15	1136	2	Q1	2012	6.4500	2.5800	3.0000	1
311	4029	17	0	12	Q4	2012	8.6000	3.6980	4.0000	1
311	4081	24	1866	11	Q4	2012	6.4500	2.2575	3.0000	1
311	4344	7	0	6	Q2	2012	6.4500	2.8380	3.0000	1
311	4391	16	0	4	Q2	2012	8.6000	2.8380	4.0000	1
311	4397	16	0	5	Q2	2012	6.4500	2.9025	3.0000	1
311	4434	15	0	9	Q3	2012	6.4500	1.9995	3.0000	1
311	4618	3	0	6	Q2	2012	10.7500	3.8700	5.0000	1
311	4856	15	0	5	Q2	2012	8.6000	4.1280	4.0000	1
311	5080	15	0	5	Q2	2012	8.6000	3.5260	4.0000	1
311	5144	7	0	7	Q3	2012	8.6000	3.6120	4.0000	1
311	5649	2	0	1	Q1	2012	6.4500	2.3865	3.0000	1
311	5768	3	0	10	Q4	2012	4.3000	1.9780	2.0000	1
311	6057	11	826	5	Q2	2012	6.4500	2.7735	3.0000	1
311	6107	3	0	8	Q3	2012	6.4500	3.1605	3.0000	1
311	6351	11	0	12	Q4	2012	6.4500	2.9025	3.0000	1
311	6421	7	0	5	Q2	2012	8.6000	3.0960	4.0000	1
311	6423	17	0	2	Q1	2012	6.4500	2.7735	3.0000	1
311	6560	17	0	7	Q3	2012	6.4500	2.4510	3.0000	1
311	6570	11	0	1	Q1	2012	6.4500	1.9995	3.0000	1
311	7160	24	0	7	Q3	2012	4.3000	1.9780	2.0000	1
311	7377	3	202	8	Q3	2012	4.3000	2.1500	2.0000	1
311	7384	3	0	6	Q2	2012	8.6000	3.7840	4.0000	1
311	7486	3	187	2	Q1	2012	8.6000	4.1280	4.0000	1
311	7674	7	0	10	Q4	2012	8.6000	3.1820	4.0000	1
311	7780	13	0	8	Q3	2012	6.4500	3.0960	3.0000	1
311	8314	15	0	11	Q4	2012	4.3000	2.0640	2.0000	1
311	8452	16	0	4	Q2	2012	8.6000	3.6980	4.0000	1
311	8912	6	504	2	Q1	2012	6.4500	2.7735	3.0000	1
311	9271	17	0	5	Q2	2012	6.4500	2.2575	3.0000	1
311	9338	6	0	12	Q4	2012	6.4500	3.0960	3.0000	1
311	9788	13	0	1	Q1	2012	6.4500	3.1605	3.0000	1
311	9791	15	1134	1	Q1	2012	6.4500	2.9025	3.0000	1
311	9903	6	502	1	Q1	2012	8.6000	2.6660	4.0000	1
311	10259	7	504	2	Q1	2012	8.6000	3.8700	4.0000	1
311	10261	2	0	6	Q2	2012	2.1500	0.7955	1.0000	1
312	346	13	0	1	Q1	2012	6.3900	2.4282	3.0000	1
312	1330	13	0	7	Q3	2012	6.3900	2.3643	3.0000	1
312	1330	13	0	12	Q4	2012	10.6500	3.9405	5.0000	1
312	1421	24	0	10	Q4	2012	8.5200	4.0044	4.0000	1
312	1430	3	190	3	Q1	2012	4.2600	1.7040	2.0000	1
312	1549	7	0	5	Q2	2012	6.3900	2.4921	3.0000	1
312	1850	16	0	1	Q1	2012	6.3900	2.3643	3.0000	1
312	1861	15	0	11	Q4	2012	8.5200	3.0672	4.0000	1
312	1991	13	0	1	Q1	2012	6.3900	2.4921	3.0000	1
312	2200	7	0	9	Q3	2012	6.3900	2.8116	3.0000	1
312	2242	7	0	3	Q1	2012	6.3900	2.7477	3.0000	1
312	2244	17	1307	8	Q3	2012	8.5200	2.7264	4.0000	1
312	2366	6	508	4	Q2	2012	6.3900	3.1311	3.0000	1
312	2371	16	0	3	Q1	2012	6.3900	2.9394	3.0000	1
312	2378	16	1236	12	Q4	2012	6.3900	2.2365	3.0000	1
312	2715	15	0	7	Q3	2012	10.6500	4.8990	5.0000	1
312	2905	3	0	3	Q1	2012	6.3900	2.4282	3.0000	1
312	2966	17	0	8	Q3	2012	8.5200	2.9820	4.0000	1
312	3021	16	0	9	Q3	2012	6.3900	3.1311	3.0000	1
312	3182	2	114	4	Q2	2012	2.1300	1.0011	1.0000	1
312	3271	13	0	7	Q3	2012	6.3900	2.8755	3.0000	1
312	3414	7	516	8	Q3	2012	8.5200	2.5560	4.0000	1
312	3497	17	0	12	Q4	2012	4.2600	1.5336	2.0000	1
312	3611	24	0	7	Q3	2012	6.3900	2.7477	3.0000	1
312	3691	17	0	6	Q2	2012	4.2600	1.7040	2.0000	1
312	3799	13	976	1	Q1	2012	6.3900	3.1311	3.0000	1
312	3816	3	0	8	Q3	2012	4.2600	1.6188	2.0000	1
312	3889	3	207	11	Q4	2012	8.5200	3.4932	4.0000	1
312	3921	23	0	2	Q1	2012	8.5200	3.2376	4.0000	1
312	4243	11	0	2	Q1	2012	8.5200	3.0672	4.0000	1
312	4541	3	202	8	Q3	2012	6.3900	2.4921	3.0000	1
312	4552	17	1304	7	Q3	2012	6.3900	2.0448	3.0000	1
312	4618	3	0	4	Q2	2012	8.5200	2.8116	4.0000	1
312	4664	7	516	8	Q3	2012	6.3900	3.0672	3.0000	1
312	4958	23	1778	7	Q3	2012	8.5200	2.7264	4.0000	1
312	5206	13	0	2	Q1	2012	6.3900	2.3643	3.0000	1
312	5280	7	0	9	Q3	2012	6.3900	1.9170	3.0000	1
312	5295	16	0	7	Q3	2012	8.5200	3.0672	4.0000	1
312	5511	7	504	2	Q1	2012	6.3900	2.9394	3.0000	1
312	5616	17	0	7	Q3	2012	6.3900	2.8116	3.0000	1
312	5720	2	0	11	Q4	2012	2.1300	0.8094	1.0000	1
312	5923	23	0	4	Q2	2012	4.2600	1.4484	2.0000	1
312	5956	22	0	11	Q4	2012	2.1300	0.7668	1.0000	1
312	6096	7	0	5	Q2	2012	6.3900	2.0448	3.0000	1
312	6659	15	0	11	Q4	2012	6.3900	2.2365	3.0000	1
312	6741	24	1869	12	Q4	2012	4.2600	1.9170	2.0000	1
312	6751	22	0	7	Q3	2012	2.1300	0.8094	1.0000	1
312	6921	24	1847	2	Q1	2012	6.3900	2.6199	3.0000	1
312	6997	13	0	3	Q1	2012	8.5200	2.6412	4.0000	1
312	7181	7	0	5	Q2	2012	6.3900	2.8116	3.0000	1
312	7379	6	504	2	Q1	2012	6.3900	2.7477	3.0000	1
312	7556	17	1294	2	Q1	2012	8.5200	3.5784	4.0000	1
312	7655	17	0	3	Q1	2012	6.3900	2.7477	3.0000	1
312	7896	23	0	12	Q4	2012	8.5200	3.7488	4.0000	1
312	7906	13	0	9	Q3	2012	6.3900	2.7477	3.0000	1
312	8452	16	1228	8	Q3	2012	8.5200	3.2376	4.0000	1
312	8500	17	0	10	Q4	2012	6.3900	1.9809	3.0000	1
312	8577	23	0	2	Q1	2012	10.6500	3.9405	5.0000	1
312	8770	22	0	5	Q2	2012	2.1300	1.0011	1.0000	1
312	8843	13	0	3	Q1	2012	8.5200	3.8340	4.0000	1
312	9045	24	1847	2	Q1	2012	6.3900	2.2365	3.0000	1
312	9200	16	0	5	Q2	2012	6.3900	2.5560	3.0000	1
312	9263	16	0	2	Q1	2012	8.5200	2.6412	4.0000	1
312	9353	15	0	10	Q4	2012	4.2600	1.5336	2.0000	1
312	9383	11	0	5	Q2	2012	6.3900	2.8755	3.0000	1
312	9439	22	0	5	Q2	2012	4.2600	1.6614	2.0000	1
312	9757	24	0	4	Q2	2012	6.3900	2.6838	3.0000	1
312	9788	13	986	6	Q2	2012	6.3900	1.9170	3.0000	1
313	187	13	0	1	Q1	2012	8.5500	3.1635	3.0000	1
313	997	3	0	11	Q4	2012	11.4000	4.1040	4.0000	1
313	1005	3	202	8	Q3	2012	5.7000	2.3940	2.0000	1
313	1085	7	0	12	Q4	2012	5.7000	2.1090	2.0000	1
313	1339	13	0	5	Q2	2012	11.4000	4.2180	4.0000	1
313	1607	17	0	9	Q3	2012	11.4000	3.4200	4.0000	1
313	1794	13	0	3	Q1	2012	11.4000	5.2440	4.0000	1
313	1916	13	0	12	Q4	2012	8.5500	2.6505	3.0000	1
313	2043	24	0	4	Q2	2012	11.4000	3.7620	4.0000	1
313	2132	15	0	12	Q4	2012	5.7000	2.5650	2.0000	1
313	2204	3	0	6	Q2	2012	11.4000	5.4720	4.0000	1
313	2378	16	0	12	Q4	2012	8.5500	2.9925	3.0000	1
313	2444	13	0	7	Q3	2012	11.4000	4.3320	4.0000	1
313	2681	7	0	9	Q3	2012	5.7000	2.5080	2.0000	1
313	2968	13	980	3	Q1	2012	14.2500	6.4125	5.0000	1
313	3204	24	0	6	Q2	2012	8.5500	3.1635	3.0000	1
313	3294	24	0	5	Q2	2012	8.5500	3.5910	3.0000	1
313	3316	7	0	10	Q4	2012	11.4000	3.5340	4.0000	1
313	3467	15	0	7	Q3	2012	5.7000	2.3370	2.0000	1
313	3513	7	0	9	Q3	2012	8.5500	4.1040	3.0000	1
313	3539	17	0	6	Q2	2012	8.5500	3.9330	3.0000	1
313	3585	6	513	6	Q2	2012	8.5500	3.8475	3.0000	1
313	3647	13	0	12	Q4	2012	11.4000	3.5340	4.0000	1
313	4567	23	0	2	Q1	2012	11.4000	5.1300	4.0000	1
313	4704	7	0	3	Q1	2012	8.5500	2.9925	3.0000	1
313	4719	23	1789	12	Q4	2012	8.5500	3.7620	3.0000	1
313	5118	11	0	3	Q1	2012	8.5500	2.9925	3.0000	1
313	5398	17	0	5	Q2	2012	11.4000	5.1300	4.0000	1
313	5649	2	120	7	Q3	2012	8.5500	4.1040	3.0000	1
313	5742	16	0	9	Q3	2012	5.7000	2.2800	2.0000	1
313	5944	3	204	9	Q3	2012	5.7000	2.1660	2.0000	1
313	5958	13	0	5	Q2	2012	11.4000	5.0160	4.0000	1
313	5999	23	0	10	Q4	2012	11.4000	5.0160	4.0000	1
313	6171	15	0	5	Q2	2012	8.5500	3.7620	3.0000	1
313	6347	17	0	9	Q3	2012	5.7000	2.7360	2.0000	1
313	6529	17	0	10	Q4	2012	11.4000	4.7880	4.0000	1
313	6560	17	0	4	Q2	2012	8.5500	3.1635	3.0000	1
313	6921	24	0	1	Q1	2012	8.5500	4.1040	3.0000	1
313	7438	2	0	9	Q3	2012	5.7000	2.4510	2.0000	1
313	7470	13	0	3	Q1	2012	8.5500	2.6505	3.0000	1
313	7494	15	1150	8	Q3	2012	8.5500	4.1895	3.0000	1
313	8011	6	504	2	Q1	2012	5.7000	2.2800	2.0000	1
313	8075	24	0	1	Q1	2012	8.5500	3.6765	3.0000	1
313	8108	17	0	10	Q4	2012	8.5500	2.9925	3.0000	1
313	8140	13	0	11	Q4	2012	5.7000	1.9380	2.0000	1
313	8477	3	0	9	Q3	2012	8.5500	3.7620	3.0000	1
313	8605	7	0	4	Q2	2012	5.7000	2.1660	2.0000	1
313	8665	15	0	9	Q3	2012	8.5500	2.6505	3.0000	1
313	8665	15	0	12	Q4	2012	8.5500	3.4200	3.0000	1
313	8684	6	519	9	Q3	2012	5.7000	2.3940	2.0000	1
313	9081	6	0	9	Q3	2012	8.5500	2.5650	3.0000	1
313	9184	3	210	12	Q4	2012	11.4000	3.5340	4.0000	1
313	9404	7	0	3	Q1	2012	8.5500	4.1040	3.0000	1
313	9488	24	1850	3	Q1	2012	5.7000	2.2800	2.0000	1
313	9512	23	0	7	Q3	2012	8.5500	2.8215	3.0000	1
313	9892	13	0	11	Q4	2012	5.7000	2.1090	2.0000	1
313	9937	17	1314	11	Q4	2012	5.7000	2.6220	2.0000	1
313	10108	15	0	8	Q3	2012	11.4000	3.6480	4.0000	1
314	785	15	0	5	Q2	2012	5.5500	1.9980	3.0000	1
314	1085	6	518	8	Q3	2012	3.7000	1.3690	2.0000	1
314	1086	11	0	11	Q4	2012	5.5500	2.2755	3.0000	1
314	2295	17	0	4	Q2	2012	3.7000	1.5170	2.0000	1
314	2378	16	1235	11	Q4	2012	7.4000	2.4420	4.0000	1
314	2588	23	0	10	Q4	2012	5.5500	1.9425	3.0000	1
314	2680	11	820	2	Q1	2012	3.7000	1.4800	2.0000	1
314	2736	6	0	4	Q2	2012	3.7000	1.6280	2.0000	1
314	2767	11	0	4	Q2	2012	7.4000	2.8860	4.0000	1
314	2775	24	0	5	Q2	2012	5.5500	2.6640	3.0000	1
314	3436	11	0	2	Q1	2012	5.5500	1.6650	3.0000	1
314	3647	13	0	5	Q2	2012	7.4000	2.2940	4.0000	1
314	3935	24	1869	12	Q4	2012	5.5500	2.5530	3.0000	1
314	4041	24	0	3	Q1	2012	5.5500	2.3865	3.0000	1
314	4149	11	0	5	Q2	2012	5.5500	1.8315	3.0000	1
314	4496	7	504	2	Q1	2012	5.5500	2.7195	3.0000	1
314	4678	13	0	9	Q3	2012	5.5500	1.7760	3.0000	1
314	5002	23	0	8	Q3	2012	5.5500	2.0535	3.0000	1
314	5142	11	0	12	Q4	2012	9.2500	3.0525	5.0000	1
314	5329	13	0	7	Q3	2012	5.5500	2.3865	3.0000	1
314	5339	11	0	3	Q1	2012	7.4000	2.8860	4.0000	1
314	5374	16	1220	4	Q2	2012	3.7000	1.5910	2.0000	1
314	5597	3	0	6	Q2	2012	5.5500	2.6640	3.0000	1
314	6352	13	0	2	Q1	2012	5.5500	1.9425	3.0000	1
314	6462	13	0	8	Q3	2012	5.5500	2.3310	3.0000	1
314	6710	13	0	7	Q3	2012	7.4000	2.4420	4.0000	1
314	6778	24	0	2	Q1	2012	5.5500	2.5530	3.0000	1
314	6960	17	0	12	Q4	2012	9.2500	4.2550	5.0000	1
314	7229	15	0	1	Q1	2012	5.5500	2.3865	3.0000	1
314	7416	13	976	1	Q1	2012	5.5500	2.6640	3.0000	1
314	7830	15	0	1	Q1	2012	7.4000	3.5520	4.0000	1
314	7899	6	504	2	Q1	2012	7.4000	2.8120	4.0000	1
314	8284	22	0	5	Q2	2012	1.8500	0.6475	1.0000	1
314	8311	23	0	11	Q4	2012	3.7000	1.5170	2.0000	1
314	8606	15	0	11	Q4	2012	3.7000	1.4060	2.0000	1
314	8843	13	0	12	Q4	2012	5.5500	2.7750	3.0000	1
314	8945	23	0	11	Q4	2012	7.4000	3.2560	4.0000	1
314	9321	22	0	12	Q4	2012	3.7000	1.8130	2.0000	1
314	9390	7	505	2	Q1	2012	3.7000	1.6650	2.0000	1
314	9671	13	0	12	Q4	2012	7.4000	2.3680	4.0000	1
314	9748	24	0	4	Q2	2012	5.5500	1.6650	3.0000	1
315	182	15	0	9	Q3	2012	2.8800	0.9216	3.0000	1
315	523	6	0	4	Q2	2012	1.9200	0.5952	2.0000	1
315	722	24	1845	1	Q1	2012	2.8800	1.0080	3.0000	1
315	870	24	0	6	Q2	2012	2.8800	0.8928	3.0000	1
315	878	3	0	9	Q3	2012	2.8800	1.2096	3.0000	1
315	1154	13	992	9	Q3	2012	4.8000	2.3040	5.0000	1
315	1310	16	0	6	Q2	2012	2.8800	0.9216	3.0000	1
315	1470	17	0	8	Q3	2012	2.8800	0.8928	3.0000	1
315	1741	11	829	6	Q2	2012	2.8800	1.1232	3.0000	1
315	2052	13	0	5	Q2	2012	3.8400	1.8432	4.0000	1
315	2224	16	0	10	Q4	2012	2.8800	1.4112	3.0000	1
315	2246	13	982	4	Q2	2012	3.8400	1.2672	4.0000	1
315	2441	17	0	9	Q3	2012	1.9200	0.5952	2.0000	1
315	2509	7	0	9	Q3	2012	2.8800	1.0944	3.0000	1
315	2981	23	0	3	Q1	2012	1.9200	0.6336	2.0000	1
315	3124	3	0	10	Q4	2012	2.8800	0.9792	3.0000	1
315	3286	22	0	7	Q3	2012	0.9600	0.4224	1.0000	1
315	3302	13	0	5	Q2	2012	2.8800	1.0080	3.0000	1
315	3305	13	0	12	Q4	2012	2.8800	1.0656	3.0000	1
315	3458	24	0	5	Q2	2012	2.8800	1.0368	3.0000	1
315	3462	6	0	6	Q2	2012	1.9200	0.7872	2.0000	1
315	3538	11	0	9	Q3	2012	1.9200	0.7872	2.0000	1
315	4436	3	210	12	Q4	2012	3.8400	1.4208	4.0000	1
315	4465	13	0	3	Q1	2012	2.8800	1.1808	3.0000	1
315	4619	13	0	11	Q4	2012	2.8800	1.0368	3.0000	1
315	4664	7	0	10	Q4	2012	1.9200	0.8448	2.0000	1
315	4778	3	207	11	Q4	2012	1.9200	0.8832	2.0000	1
315	4990	7	0	6	Q2	2012	2.8800	1.0368	3.0000	1
315	5019	23	0	11	Q4	2012	3.8400	1.6128	4.0000	1
315	5026	17	0	7	Q3	2012	1.9200	0.9408	2.0000	1
315	5095	6	0	12	Q4	2012	1.9200	0.7104	2.0000	1
315	5135	6	0	12	Q4	2012	2.8800	1.2960	3.0000	1
315	5437	7	0	8	Q3	2012	2.8800	1.2960	3.0000	1
315	5537	3	0	7	Q3	2012	2.8800	1.0944	3.0000	1
315	5844	17	1294	2	Q1	2012	2.8800	1.0368	3.0000	1
315	5903	13	0	7	Q3	2012	1.9200	0.8640	2.0000	1
315	5906	15	0	2	Q1	2012	2.8800	1.4112	3.0000	1
315	5910	15	0	3	Q1	2012	4.8000	2.0160	5.0000	1
315	6057	11	826	5	Q2	2012	2.8800	1.1232	3.0000	1
315	6462	13	0	11	Q4	2012	1.9200	0.8640	2.0000	1
315	6551	11	0	2	Q1	2012	3.8400	1.3440	4.0000	1
315	7099	15	0	6	Q2	2012	3.8400	1.4976	4.0000	1
315	7266	24	0	4	Q2	2012	3.8400	1.3824	4.0000	1
315	7416	13	0	6	Q2	2012	2.8800	1.3824	3.0000	1
315	7416	13	0	8	Q3	2012	3.8400	1.8432	4.0000	1
315	7622	3	0	8	Q3	2012	2.8800	1.2672	3.0000	1
315	7721	13	0	8	Q3	2012	1.9200	0.6336	2.0000	1
315	7768	15	1138	3	Q1	2012	2.8800	1.2384	3.0000	1
315	8003	3	195	5	Q2	2012	2.8800	0.9504	3.0000	1
315	8133	7	0	9	Q3	2012	3.8400	1.4976	4.0000	1
315	8138	24	0	1	Q1	2012	1.9200	0.6720	2.0000	1
315	8140	13	0	11	Q4	2012	2.8800	1.1808	3.0000	1
315	8308	17	0	5	Q2	2012	2.8800	0.8928	3.0000	1
315	8477	3	0	11	Q4	2012	2.8800	1.4112	3.0000	1
315	8659	13	0	3	Q1	2012	2.8800	1.2960	3.0000	1
315	8887	17	0	10	Q4	2012	3.8400	1.4208	4.0000	1
315	9016	23	0	4	Q2	2012	4.8000	1.8240	5.0000	1
315	9064	17	0	1	Q1	2012	3.8400	1.1520	4.0000	1
315	9263	16	0	11	Q4	2012	3.8400	1.2672	4.0000	1
315	9401	13	988	7	Q3	2012	3.8400	1.6128	4.0000	1
315	9997	17	0	8	Q3	2012	2.8800	1.1232	3.0000	1
315	10240	3	188	2	Q1	2012	1.9200	0.6912	2.0000	1
316	80	24	1846	2	Q1	2012	3.9300	1.8864	3.0000	1
316	91	6	0	8	Q3	2012	3.9300	1.6899	3.0000	1
316	182	15	1149	8	Q3	2012	3.9300	1.8471	3.0000	1
316	361	11	0	5	Q2	2012	2.6200	0.8122	2.0000	1
316	679	7	504	2	Q1	2012	5.2400	2.4628	4.0000	1
316	697	13	0	2	Q1	2012	3.9300	1.6899	3.0000	1
316	923	15	0	8	Q3	2012	5.2400	2.0436	4.0000	1
316	997	3	0	12	Q4	2012	2.6200	0.9170	2.0000	1
316	1102	7	0	10	Q4	2012	3.9300	1.8078	3.0000	1
316	1146	24	1858	7	Q3	2012	6.5500	2.0960	5.0000	1
316	1418	2	0	4	Q2	2012	2.6200	1.0218	2.0000	1
316	1423	13	0	9	Q3	2012	3.9300	1.4934	3.0000	1
316	2020	6	0	2	Q1	2012	3.9300	1.4541	3.0000	1
316	2198	13	0	11	Q4	2012	5.2400	2.5152	4.0000	1
316	2542	7	0	10	Q4	2012	5.2400	2.0436	4.0000	1
316	2647	6	523	11	Q4	2012	3.9300	1.3755	3.0000	1
316	2897	15	0	7	Q3	2012	5.2400	2.3580	4.0000	1
316	2965	2	0	2	Q1	2012	1.3100	0.4847	1.0000	1
316	3361	24	1866	11	Q4	2012	3.9300	1.5720	3.0000	1
316	3539	17	0	2	Q1	2012	5.2400	1.8340	4.0000	1
316	4175	16	0	7	Q3	2012	2.6200	0.9432	2.0000	1
316	4373	11	0	7	Q3	2012	2.6200	0.9694	2.0000	1
316	4473	15	0	7	Q3	2012	5.2400	2.1484	4.0000	1
316	4536	13	0	11	Q4	2012	2.6200	0.8646	2.0000	1
316	4847	11	0	8	Q3	2012	2.6200	1.0218	2.0000	1
316	5182	15	1138	3	Q1	2012	2.6200	1.0480	2.0000	1
316	5339	11	0	3	Q1	2012	5.2400	1.7292	4.0000	1
316	5374	16	0	10	Q4	2012	5.2400	2.3580	4.0000	1
316	5501	17	1314	11	Q4	2012	3.9300	1.6506	3.0000	1
316	5597	3	207	11	Q4	2012	3.9300	1.8864	3.0000	1
316	6688	6	0	6	Q2	2012	3.9300	1.6899	3.0000	1
316	6888	23	0	1	Q1	2012	5.2400	2.5676	4.0000	1
316	7130	24	0	7	Q3	2012	5.2400	2.1484	4.0000	1
316	7384	3	0	6	Q2	2012	5.2400	2.3580	4.0000	1
316	7446	13	0	5	Q2	2012	5.2400	2.4104	4.0000	1
316	7813	17	0	6	Q2	2012	2.6200	1.2838	2.0000	1
316	7849	3	0	7	Q3	2012	5.2400	2.5152	4.0000	1
316	7859	7	0	12	Q4	2012	2.6200	0.8646	2.0000	1
316	7896	23	0	9	Q3	2012	3.9300	1.6506	3.0000	1
316	7905	13	984	5	Q2	2012	5.2400	2.4628	4.0000	1
316	7952	13	0	8	Q3	2012	3.9300	1.4934	3.0000	1
316	7968	15	1152	9	Q3	2012	3.9300	1.6899	3.0000	1
316	8158	11	0	5	Q2	2012	5.2400	1.9388	4.0000	1
316	8235	22	0	1	Q1	2012	1.3100	0.4585	1.0000	1
316	8404	3	0	5	Q2	2012	3.9300	1.5720	3.0000	1
316	8406	6	523	11	Q4	2012	3.9300	1.7685	3.0000	1
316	8902	3	199	7	Q3	2012	5.2400	1.6768	4.0000	1
316	9144	13	1000	12	Q4	2012	3.9300	1.8864	3.0000	1
316	9290	14	0	10	Q4	2012	1.3100	0.5895	1.0000	1
316	9300	7	519	9	Q3	2012	3.9300	1.9257	3.0000	1
316	9309	17	0	1	Q1	2012	3.9300	1.3755	3.0000	1
316	9420	13	980	3	Q1	2012	3.9300	1.9650	3.0000	1
316	9510	16	1225	7	Q3	2012	5.2400	1.9388	4.0000	1
316	9558	6	524	11	Q4	2012	2.6200	1.1790	2.0000	1
316	9949	24	1851	4	Q2	2012	5.2400	2.2532	4.0000	1
316	10058	15	0	7	Q3	2012	3.9300	1.2183	3.0000	1
317	40	14	1061	4	Q2	2012	2.1800	1.0246	1.0000	1
317	234	24	1856	6	Q2	2012	8.7200	3.2264	4.0000	1
317	354	23	0	12	Q4	2012	6.5400	2.0928	3.0000	1
317	806	17	0	4	Q2	2012	4.3600	1.3516	2.0000	1
317	1253	13	0	7	Q3	2012	8.7200	4.1856	4.0000	1
317	1589	15	0	9	Q3	2012	4.3600	1.6568	2.0000	1
317	1599	6	0	11	Q4	2012	4.3600	1.8312	2.0000	1
317	1634	3	0	4	Q2	2012	4.3600	1.6568	2.0000	1
317	1785	3	0	2	Q1	2012	6.5400	2.8122	3.0000	1
317	1798	3	0	9	Q3	2012	8.7200	2.6160	4.0000	1
317	1821	13	980	3	Q1	2012	6.5400	2.2890	3.0000	1
317	1862	17	0	6	Q2	2012	8.7200	3.3136	4.0000	1
317	1862	17	0	7	Q3	2012	6.5400	2.4852	3.0000	1
317	1981	11	836	9	Q3	2012	8.7200	4.0112	4.0000	1
317	1991	13	0	3	Q1	2012	8.7200	2.8776	4.0000	1
317	1991	13	0	4	Q2	2012	4.3600	1.7440	2.0000	1
317	2110	11	824	4	Q2	2012	6.5400	2.4198	3.0000	1
317	2453	24	0	9	Q3	2012	6.5400	2.4198	3.0000	1
317	2553	16	0	1	Q1	2012	4.3600	1.3516	2.0000	1
317	2556	3	0	4	Q2	2012	8.7200	4.0984	4.0000	1
317	2689	3	0	6	Q2	2012	4.3600	1.7876	2.0000	1
317	2878	3	185	1	Q1	2012	10.9000	4.5780	5.0000	1
317	3075	23	1775	5	Q2	2012	6.5400	2.2890	3.0000	1
317	3243	13	0	7	Q3	2012	8.7200	4.0984	4.0000	1
317	3404	24	1856	6	Q2	2012	6.5400	2.4198	3.0000	1
317	3404	24	1858	7	Q3	2012	8.7200	2.7032	4.0000	1
317	3859	24	0	7	Q3	2012	6.5400	2.8776	3.0000	1
317	4017	15	0	5	Q2	2012	6.5400	3.2700	3.0000	1
317	4021	16	1214	2	Q1	2012	8.7200	3.4880	4.0000	1
317	4231	17	0	1	Q1	2012	6.5400	2.0274	3.0000	1
317	4301	11	829	6	Q2	2012	8.7200	3.1392	4.0000	1
317	4868	16	0	6	Q2	2012	4.3600	1.5260	2.0000	1
317	5134	3	0	11	Q4	2012	6.5400	2.7468	3.0000	1
317	5162	22	0	10	Q4	2012	6.5400	2.2890	3.0000	1
317	5393	7	0	9	Q3	2012	6.5400	2.8122	3.0000	1
317	5431	7	0	3	Q1	2012	8.7200	4.0112	4.0000	1
317	5555	22	0	5	Q2	2012	2.1800	0.6976	1.0000	1
317	5580	7	514	7	Q3	2012	8.7200	3.6624	4.0000	1
317	6114	16	0	9	Q3	2012	10.9000	3.4880	5.0000	1
317	6307	16	1220	4	Q2	2012	10.9000	4.7960	5.0000	1
317	6317	7	523	11	Q4	2012	6.5400	2.6160	3.0000	1
317	6475	24	1853	5	Q2	2012	6.5400	3.2046	3.0000	1
317	6930	24	0	7	Q3	2012	6.5400	2.2236	3.0000	1
317	7076	7	521	10	Q4	2012	8.7200	3.1392	4.0000	1
317	7330	6	0	4	Q2	2012	6.5400	2.0928	3.0000	1
317	7502	16	0	1	Q1	2012	8.7200	3.6624	4.0000	1
317	7557	14	0	5	Q2	2012	4.3600	1.8748	2.0000	1
317	7565	15	0	10	Q4	2012	6.5400	2.7468	3.0000	1
317	7989	17	0	5	Q2	2012	4.3600	1.4824	2.0000	1
317	8291	13	0	1	Q1	2012	10.9000	4.5780	5.0000	1
317	8359	17	1311	10	Q4	2012	4.3600	1.6568	2.0000	1
317	8367	13	0	3	Q1	2012	4.3600	1.7876	2.0000	1
317	8551	17	0	11	Q4	2012	8.7200	2.7904	4.0000	1
317	8577	23	0	10	Q4	2012	8.7200	3.1392	4.0000	1
317	8617	17	0	6	Q2	2012	6.5400	2.5506	3.0000	1
317	9016	23	0	11	Q4	2012	8.7200	3.3136	4.0000	1
317	9172	24	0	2	Q1	2012	6.5400	2.2890	3.0000	1
317	9318	16	0	9	Q3	2012	6.5400	2.0274	3.0000	1
317	9903	6	524	11	Q4	2012	6.5400	2.7468	3.0000	1
317	10091	17	0	6	Q2	2012	6.5400	2.8122	3.0000	1
317	10168	15	1136	2	Q1	2012	6.5400	2.2236	3.0000	1
318	163	7	0	10	Q4	2012	7.4100	3.4827	3.0000	1
318	170	6	0	5	Q2	2012	7.4100	3.4827	3.0000	1
318	348	2	0	11	Q4	2012	4.9400	1.5808	2.0000	1
318	391	7	516	8	Q3	2012	7.4100	2.2971	3.0000	1
318	682	7	526	12	Q4	2012	4.9400	1.5314	2.0000	1
318	1070	3	207	11	Q4	2012	9.8800	3.5568	4.0000	1
318	1313	15	0	1	Q1	2012	9.8800	4.7424	4.0000	1
318	1332	11	0	11	Q4	2012	9.8800	3.2604	4.0000	1
318	1423	13	0	9	Q3	2012	9.8800	3.7544	4.0000	1
318	1533	3	0	11	Q4	2012	9.8800	4.4460	4.0000	1
318	1598	3	202	8	Q3	2012	9.8800	4.2484	4.0000	1
318	1613	7	0	9	Q3	2012	9.8800	4.4460	4.0000	1
318	1730	11	0	1	Q1	2012	7.4100	2.9640	3.0000	1
318	1923	11	0	5	Q2	2012	7.4100	3.4086	3.0000	1
318	2206	6	510	5	Q2	2012	7.4100	3.0381	3.0000	1
318	2270	11	0	5	Q2	2012	7.4100	2.8899	3.0000	1
318	2280	13	986	6	Q2	2012	9.8800	3.6556	4.0000	1
318	2390	17	0	4	Q2	2012	4.9400	2.0254	2.0000	1
318	3166	24	0	11	Q4	2012	7.4100	2.2971	3.0000	1
318	3288	3	0	4	Q2	2012	7.4100	2.3712	3.0000	1
318	3533	3	0	6	Q2	2012	7.4100	3.2604	3.0000	1
318	4041	24	0	3	Q1	2012	9.8800	4.0508	4.0000	1
318	4249	11	0	4	Q2	2012	7.4100	2.6676	3.0000	1
318	4460	3	0	9	Q3	2012	4.9400	2.4700	2.0000	1
318	4467	11	833	8	Q3	2012	4.9400	1.8278	2.0000	1
318	4552	17	0	7	Q3	2012	7.4100	2.5935	3.0000	1
318	4909	7	504	2	Q1	2012	9.8800	4.9400	4.0000	1
318	4961	13	980	3	Q1	2012	7.4100	2.5935	3.0000	1
318	5123	11	826	5	Q2	2012	7.4100	2.5935	3.0000	1
318	5135	6	0	2	Q1	2012	7.4100	2.2971	3.0000	1
318	5161	6	0	10	Q4	2012	4.9400	2.1736	2.0000	1
318	5322	7	517	8	Q3	2012	4.9400	2.3712	2.0000	1
318	5388	11	0	2	Q1	2012	9.8800	4.1496	4.0000	1
318	5530	13	980	3	Q1	2012	9.8800	4.2484	4.0000	1
318	5929	15	0	8	Q3	2012	7.4100	3.1863	3.0000	1
318	5956	22	1702	8	Q3	2012	4.9400	2.1736	2.0000	1
318	5962	17	0	5	Q2	2012	7.4100	2.5194	3.0000	1
318	6313	17	0	12	Q4	2012	7.4100	3.5568	3.0000	1
318	6462	13	0	8	Q3	2012	7.4100	2.5935	3.0000	1
318	6919	11	833	8	Q3	2012	7.4100	3.7050	3.0000	1
318	7131	11	0	5	Q2	2012	7.4100	2.9640	3.0000	1
318	7282	17	0	8	Q3	2012	7.4100	2.2230	3.0000	1
318	7486	3	0	3	Q1	2012	7.4100	3.0381	3.0000	1
318	7741	15	0	8	Q3	2012	7.4100	3.6309	3.0000	1
318	8015	13	0	12	Q4	2012	4.9400	2.1736	2.0000	1
318	8214	6	521	10	Q4	2012	7.4100	2.7417	3.0000	1
318	8472	17	1303	6	Q2	2012	4.9400	1.6302	2.0000	1
318	8617	17	0	2	Q1	2012	7.4100	2.9640	3.0000	1
318	8969	6	0	7	Q3	2012	9.8800	4.0508	4.0000	1
318	9012	24	0	10	Q4	2012	9.8800	4.2484	4.0000	1
318	9019	7	501	1	Q1	2012	9.8800	4.7424	4.0000	1
318	9313	6	0	2	Q1	2012	4.9400	2.3712	2.0000	1
318	9345	15	0	2	Q1	2012	9.8800	3.6556	4.0000	1
318	9357	7	504	2	Q1	2012	7.4100	2.3712	3.0000	1
318	9397	11	0	3	Q1	2012	12.3500	4.5695	5.0000	1
318	9495	13	0	7	Q3	2012	4.9400	1.6302	2.0000	1
318	9534	17	0	5	Q2	2012	7.4100	3.1863	3.0000	1
318	9671	13	0	4	Q2	2012	7.4100	3.5568	3.0000	1
318	9891	23	0	2	Q1	2012	9.8800	3.7544	4.0000	1
319	377	7	0	12	Q4	2012	8.0000	3.4400	5.0000	1
319	588	23	0	12	Q4	2012	6.4000	2.5600	4.0000	1
319	1675	15	0	6	Q2	2012	3.2000	1.5680	2.0000	1
319	1683	6	504	2	Q1	2012	3.2000	1.3440	2.0000	1
319	1838	24	0	11	Q4	2012	6.4000	2.3040	4.0000	1
319	2251	13	986	6	Q2	2012	4.8000	2.3520	3.0000	1
319	2570	16	1220	4	Q2	2012	3.2000	1.0560	2.0000	1
319	3124	3	0	10	Q4	2012	4.8000	1.8240	3.0000	1
319	3438	11	829	6	Q2	2012	4.8000	1.9680	3.0000	1
319	3491	16	0	8	Q3	2012	4.8000	1.4880	3.0000	1
319	3882	13	0	7	Q3	2012	3.2000	1.2480	2.0000	1
319	3941	3	0	8	Q3	2012	4.8000	1.4880	3.0000	1
319	3956	14	0	9	Q3	2012	3.2000	1.4720	2.0000	1
319	4179	24	1845	1	Q1	2012	4.8000	2.0160	3.0000	1
319	4186	7	523	11	Q4	2012	3.2000	1.1200	2.0000	1
319	4227	24	0	9	Q3	2012	6.4000	1.9200	4.0000	1
319	4328	7	0	3	Q1	2012	4.8000	1.5360	3.0000	1
319	4567	23	0	2	Q1	2012	8.0000	3.4400	5.0000	1
319	5405	11	0	7	Q3	2012	4.8000	1.5840	3.0000	1
319	5663	6	513	6	Q2	2012	4.8000	2.1120	3.0000	1
319	5677	22	0	9	Q3	2012	3.2000	1.4080	2.0000	1
319	5801	24	0	1	Q1	2012	3.2000	1.3440	2.0000	1
319	5875	11	820	2	Q1	2012	3.2000	1.2160	2.0000	1
319	6347	17	0	7	Q3	2012	3.2000	1.4720	2.0000	1
319	6528	6	0	10	Q4	2012	6.4000	2.3040	4.0000	1
319	6557	11	0	11	Q4	2012	3.2000	1.2160	2.0000	1
319	6763	7	0	9	Q3	2012	6.4000	2.7520	4.0000	1
319	6889	15	0	11	Q4	2012	4.8000	2.3520	3.0000	1
319	7046	15	0	7	Q3	2012	6.4000	2.1120	4.0000	1
319	7056	3	0	5	Q2	2012	4.8000	1.6800	3.0000	1
319	7149	13	0	2	Q1	2012	4.8000	2.0160	3.0000	1
319	7569	13	0	10	Q4	2012	3.2000	0.9920	2.0000	1
319	7589	17	1307	8	Q3	2012	3.2000	1.3760	2.0000	1
319	7800	11	0	12	Q4	2012	6.4000	2.6240	4.0000	1
319	7829	24	0	9	Q3	2012	4.8000	1.8240	3.0000	1
319	8108	17	0	9	Q3	2012	3.2000	1.1200	2.0000	1
319	8247	7	0	1	Q1	2012	4.8000	2.3520	3.0000	1
319	8717	17	0	8	Q3	2012	3.2000	1.0560	2.0000	1
319	8847	24	0	12	Q4	2012	4.8000	2.1600	3.0000	1
319	9512	23	1778	7	Q3	2012	3.2000	0.9920	2.0000	1
319	9897	16	0	10	Q4	2012	6.4000	2.0480	4.0000	1
320	252	24	0	9	Q3	2012	9.7800	3.6186	3.0000	1
320	453	24	1845	1	Q1	2012	13.0400	4.8248	4.0000	1
320	792	7	0	7	Q3	2012	13.0400	5.6072	4.0000	1
320	976	16	1216	2	Q1	2012	6.5200	2.4124	2.0000	1
320	1082	15	0	11	Q4	2012	13.0400	5.0856	4.0000	1
320	1187	13	0	10	Q4	2012	9.7800	3.1296	3.0000	1
320	1271	13	988	7	Q3	2012	6.5200	2.0864	2.0000	1
320	1389	7	0	11	Q4	2012	6.5200	1.9560	2.0000	1
320	1825	23	0	9	Q3	2012	16.3000	7.3350	5.0000	1
320	1977	23	0	3	Q1	2012	13.0400	4.3032	4.0000	1
320	2049	24	0	3	Q1	2012	13.0400	4.8248	4.0000	1
320	2290	7	0	12	Q4	2012	9.7800	3.8142	3.0000	1
320	2376	11	0	1	Q1	2012	13.0400	6.5200	4.0000	1
320	2894	22	0	11	Q4	2012	6.5200	2.9992	2.0000	1
320	3103	24	0	9	Q3	2012	9.7800	3.1296	3.0000	1
320	3305	13	0	10	Q4	2012	13.0400	5.7376	4.0000	1
320	3328	17	0	3	Q1	2012	6.5200	2.2820	2.0000	1
320	3449	6	0	1	Q1	2012	9.7800	3.6186	3.0000	1
320	4118	17	0	11	Q4	2012	9.7800	3.0318	3.0000	1
320	4498	17	0	11	Q4	2012	9.7800	4.3032	3.0000	1
320	4657	17	0	7	Q3	2012	6.5200	2.9340	2.0000	1
320	4678	13	980	3	Q1	2012	9.7800	3.2274	3.0000	1
320	4695	13	0	4	Q2	2012	13.0400	4.8248	4.0000	1
320	5026	17	1314	11	Q4	2012	6.5200	3.1296	2.0000	1
320	5322	6	0	12	Q4	2012	6.5200	2.6080	2.0000	1
320	5370	24	0	7	Q3	2012	9.7800	3.6186	3.0000	1
320	5528	24	1847	2	Q1	2012	13.0400	6.2592	4.0000	1
320	5802	7	0	5	Q2	2012	6.5200	2.6080	2.0000	1
320	5895	17	0	9	Q3	2012	9.7800	3.0318	3.0000	1
320	5953	6	0	4	Q2	2012	13.0400	5.9984	4.0000	1
320	6047	17	0	6	Q2	2012	9.7800	3.6186	3.0000	1
320	6129	7	0	7	Q3	2012	13.0400	4.8248	4.0000	1
320	6129	7	0	11	Q4	2012	13.0400	4.8248	4.0000	1
320	6153	16	1216	2	Q1	2012	13.0400	6.1288	4.0000	1
320	6493	24	0	4	Q2	2012	13.0400	4.8248	4.0000	1
320	6843	15	0	1	Q1	2012	6.5200	2.5428	2.0000	1
320	7065	17	0	6	Q2	2012	13.0400	5.8680	4.0000	1
320	7331	11	0	7	Q3	2012	9.7800	4.1076	3.0000	1
320	7354	3	205	10	Q4	2012	13.0400	5.6072	4.0000	1
320	7355	13	0	11	Q4	2012	9.7800	4.3032	3.0000	1
320	7569	13	0	3	Q1	2012	6.5200	2.0212	2.0000	1
320	7659	6	0	4	Q2	2012	6.5200	2.4124	2.0000	1
320	8111	15	0	12	Q4	2012	6.5200	2.4776	2.0000	1
320	8235	22	1694	4	Q2	2012	3.2600	1.1736	1.0000	1
320	8241	17	1304	7	Q3	2012	6.5200	2.7384	2.0000	1
320	8289	17	0	12	Q4	2012	13.0400	4.6944	4.0000	1
320	8758	7	504	2	Q1	2012	13.0400	5.0856	4.0000	1
320	8902	3	0	4	Q2	2012	13.0400	4.1728	4.0000	1
320	9184	3	0	4	Q2	2012	13.0400	4.0424	4.0000	1
320	9184	3	0	7	Q3	2012	6.5200	3.1948	2.0000	1
320	9286	13	0	12	Q4	2012	6.5200	2.2168	2.0000	1
320	9795	11	841	12	Q4	2012	9.7800	3.0318	3.0000	1
321	206	2	0	3	Q1	2012	4.8200	2.0244	2.0000	1
321	250	11	0	12	Q4	2012	7.2300	3.1812	3.0000	1
321	900	24	0	9	Q3	2012	7.2300	2.3136	3.0000	1
321	999	24	0	7	Q3	2012	9.6400	3.4704	4.0000	1
321	1142	13	986	6	Q2	2012	7.2300	2.2413	3.0000	1
321	1192	17	0	4	Q2	2012	4.8200	1.4942	2.0000	1
321	1622	3	0	2	Q1	2012	7.2300	2.2413	3.0000	1
321	1648	11	0	5	Q2	2012	7.2300	2.6028	3.0000	1
321	1798	3	0	9	Q3	2012	7.2300	3.6150	3.0000	1
321	2019	16	0	3	Q1	2012	4.8200	2.1208	2.0000	1
321	2298	3	204	9	Q3	2012	4.8200	1.9280	2.0000	1
321	2327	13	0	8	Q3	2012	9.6400	3.1812	4.0000	1
321	2431	3	0	6	Q2	2012	7.2300	2.9643	3.0000	1
321	2616	22	0	12	Q4	2012	4.8200	1.5424	2.0000	1
321	2647	6	0	3	Q1	2012	7.2300	3.1089	3.0000	1
321	2751	7	516	8	Q3	2012	7.2300	3.1812	3.0000	1
321	2769	16	1216	2	Q1	2012	4.8200	2.1690	2.0000	1
321	2942	17	1304	7	Q3	2012	7.2300	3.1089	3.0000	1
321	3308	13	988	7	Q3	2012	9.6400	3.4704	4.0000	1
321	3509	24	1856	6	Q2	2012	7.2300	3.5427	3.0000	1
321	3587	6	521	10	Q4	2012	7.2300	2.8197	3.0000	1
321	4292	7	519	9	Q3	2012	7.2300	2.6028	3.0000	1
321	4373	11	821	2	Q1	2012	9.6400	3.4704	4.0000	1
321	4397	16	0	11	Q4	2012	9.6400	3.9524	4.0000	1
321	4644	11	0	7	Q3	2012	4.8200	1.7834	2.0000	1
321	4808	11	837	10	Q4	2012	7.2300	3.0366	3.0000	1
321	4938	13	0	8	Q3	2012	9.6400	3.3740	4.0000	1
321	5219	17	0	12	Q4	2012	7.2300	2.7474	3.0000	1
321	5566	7	0	3	Q1	2012	9.6400	3.2776	4.0000	1
321	5658	11	0	8	Q3	2012	7.2300	3.5427	3.0000	1
321	5869	13	0	7	Q3	2012	7.2300	2.4582	3.0000	1
321	5922	15	0	3	Q1	2012	4.8200	1.9280	2.0000	1
321	6039	13	0	9	Q3	2012	9.6400	3.4704	4.0000	1
321	6107	3	0	8	Q3	2012	9.6400	3.1812	4.0000	1
321	6208	17	0	8	Q3	2012	4.8200	1.9280	2.0000	1
321	6359	7	0	1	Q1	2012	7.2300	3.3981	3.0000	1
321	6930	24	0	4	Q2	2012	4.8200	2.3618	2.0000	1
321	7124	7	0	10	Q4	2012	4.8200	1.5424	2.0000	1
321	7281	17	1314	11	Q4	2012	7.2300	3.0366	3.0000	1
321	7362	11	826	5	Q2	2012	4.8200	1.9762	2.0000	1
321	7529	17	0	1	Q1	2012	4.8200	1.9280	2.0000	1
321	7589	17	0	2	Q1	2012	7.2300	3.2535	3.0000	1
321	7591	15	0	10	Q4	2012	9.6400	3.5668	4.0000	1
321	7806	13	982	4	Q2	2012	7.2300	3.1812	3.0000	1
321	7828	11	0	9	Q3	2012	7.2300	3.3981	3.0000	1
321	7857	15	1138	3	Q1	2012	4.8200	2.0726	2.0000	1
321	8189	17	1297	3	Q1	2012	7.2300	2.3859	3.0000	1
321	8359	17	1303	6	Q2	2012	7.2300	2.5305	3.0000	1
321	8377	2	114	4	Q2	2012	4.8200	1.7834	2.0000	1
321	8482	11	842	12	Q4	2012	9.6400	3.6632	4.0000	1
321	8746	23	0	10	Q4	2012	4.8200	2.1690	2.0000	1
321	9199	2	0	7	Q3	2012	4.8200	2.2172	2.0000	1
321	9417	15	0	10	Q4	2012	7.2300	2.9643	3.0000	1
321	9757	24	1850	3	Q1	2012	7.2300	2.5305	3.0000	1
321	9928	16	0	5	Q2	2012	12.0500	3.8560	5.0000	1
321	10126	7	0	12	Q4	2012	7.2300	3.3981	3.0000	1
322	730	7	504	2	Q1	2012	11.9200	4.4104	4.0000	1
322	769	16	0	1	Q1	2012	5.9600	2.6820	2.0000	1
322	782	17	1311	10	Q4	2012	11.9200	5.8408	4.0000	1
322	921	23	0	5	Q2	2012	14.9000	5.3640	5.0000	1
322	955	6	524	11	Q4	2012	8.9400	4.4700	3.0000	1
322	1091	7	0	1	Q1	2012	11.9200	3.9336	4.0000	1
322	1189	6	524	11	Q4	2012	11.9200	4.4104	4.0000	1
322	1216	17	0	9	Q3	2012	11.9200	3.6952	4.0000	1
322	1676	3	0	5	Q2	2012	8.9400	3.1290	3.0000	1
322	1865	6	0	6	Q2	2012	5.9600	2.5032	2.0000	1
322	2105	24	1850	3	Q1	2012	11.9200	4.4104	4.0000	1
322	2266	7	0	6	Q2	2012	14.9000	5.5130	5.0000	1
322	2421	6	0	4	Q2	2012	8.9400	4.0230	3.0000	1
322	2556	3	0	4	Q2	2012	11.9200	4.4104	4.0000	1
322	2599	7	0	10	Q4	2012	5.9600	2.9204	2.0000	1
322	2612	24	0	7	Q3	2012	11.9200	5.7216	4.0000	1
322	3028	7	518	8	Q3	2012	5.9600	2.3840	2.0000	1
322	3124	3	0	8	Q3	2012	14.9000	5.3640	5.0000	1
322	3334	17	0	12	Q4	2012	11.9200	5.7216	4.0000	1
322	3437	6	522	10	Q4	2012	11.9200	4.6488	4.0000	1
322	3460	11	826	5	Q2	2012	8.9400	3.8442	3.0000	1
322	4029	17	0	9	Q3	2012	8.9400	4.3806	3.0000	1
322	4148	15	0	10	Q4	2012	8.9400	3.1290	3.0000	1
322	4315	17	0	1	Q1	2012	8.9400	2.7714	3.0000	1
322	4373	11	841	12	Q4	2012	11.9200	4.2912	4.0000	1
322	4460	3	201	8	Q3	2012	5.9600	2.9800	2.0000	1
322	4582	6	518	8	Q3	2012	5.9600	2.6820	2.0000	1
322	4630	15	0	6	Q2	2012	5.9600	2.3840	2.0000	1
322	5346	3	0	8	Q3	2012	8.9400	2.6820	3.0000	1
322	5450	24	1869	12	Q4	2012	11.9200	4.7680	4.0000	1
322	5470	2	0	12	Q4	2012	2.9800	0.9238	1.0000	1
322	5592	16	0	8	Q3	2012	11.9200	5.3640	4.0000	1
322	5647	15	0	5	Q2	2012	8.9400	2.7714	3.0000	1
322	5734	13	0	12	Q4	2012	8.9400	4.0230	3.0000	1
322	5855	13	0	1	Q1	2012	5.9600	2.4436	2.0000	1
322	5956	22	1702	8	Q3	2012	2.9800	1.0728	1.0000	1
322	5962	17	0	5	Q2	2012	8.9400	3.3972	3.0000	1
322	6321	14	1079	12	Q4	2012	2.9800	0.8940	1.0000	1
322	6486	13	0	12	Q4	2012	5.9600	2.6224	2.0000	1
322	6939	7	526	12	Q4	2012	8.9400	2.9502	3.0000	1
322	7067	13	1000	12	Q4	2012	11.9200	3.9336	4.0000	1
322	7283	13	1000	12	Q4	2012	5.9600	2.0860	2.0000	1
322	7301	24	0	6	Q2	2012	11.9200	5.1256	4.0000	1
322	7361	11	842	12	Q4	2012	11.9200	3.6952	4.0000	1
322	7455	13	0	6	Q2	2012	11.9200	4.5296	4.0000	1
322	7704	3	0	1	Q1	2012	5.9600	2.0860	2.0000	1
322	7813	17	1293	1	Q1	2012	8.9400	4.1124	3.0000	1
322	8059	17	0	7	Q3	2012	8.9400	3.0396	3.0000	1
322	8509	24	1869	12	Q4	2012	8.9400	3.8442	3.0000	1
322	9285	15	0	3	Q1	2012	11.9200	3.6952	4.0000	1
322	9318	16	0	6	Q2	2012	8.9400	4.1124	3.0000	1
322	9357	7	504	2	Q1	2012	8.9400	3.9336	3.0000	1
322	9810	24	0	3	Q1	2012	11.9200	4.8872	4.0000	1
323	604	14	1058	2	Q1	2012	7.0000	2.1700	2.0000	1
323	769	16	0	5	Q2	2012	7.0000	3.1500	2.0000	1
323	1053	13	0	1	Q1	2012	7.0000	2.8000	2.0000	1
323	1115	22	0	12	Q4	2012	7.0000	2.9400	2.0000	1
323	1129	24	0	5	Q2	2012	10.5000	4.2000	3.0000	1
323	1245	17	0	10	Q4	2012	10.5000	4.2000	3.0000	1
323	1418	2	0	4	Q2	2012	3.5000	1.4350	1.0000	1
323	1446	24	0	6	Q2	2012	14.0000	4.6200	4.0000	1
323	1637	15	0	5	Q2	2012	14.0000	6.3000	4.0000	1
323	1780	24	0	10	Q4	2012	7.0000	2.6600	2.0000	1
323	1862	17	0	6	Q2	2012	7.0000	2.9400	2.0000	1
323	2059	17	0	8	Q3	2012	10.5000	3.9900	3.0000	1
323	2610	6	0	10	Q4	2012	10.5000	3.2550	3.0000	1
323	2625	13	0	4	Q2	2012	7.0000	3.0800	2.0000	1
323	2639	15	0	9	Q3	2012	10.5000	4.0950	3.0000	1
323	3009	6	504	2	Q1	2012	10.5000	3.3600	3.0000	1
323	3021	16	0	9	Q3	2012	14.0000	4.6200	4.0000	1
323	3149	11	0	9	Q3	2012	10.5000	4.6200	3.0000	1
323	3497	17	0	12	Q4	2012	10.5000	3.3600	3.0000	1
323	3763	24	0	3	Q1	2012	10.5000	4.7250	3.0000	1
323	3773	17	1294	2	Q1	2012	14.0000	4.4800	4.0000	1
323	3787	3	0	12	Q4	2012	10.5000	3.8850	3.0000	1
323	3809	7	505	2	Q1	2012	10.5000	3.6750	3.0000	1
323	4116	11	0	11	Q4	2012	7.0000	3.1500	2.0000	1
323	4268	11	824	4	Q2	2012	10.5000	3.7800	3.0000	1
323	4353	14	0	8	Q3	2012	7.0000	2.3800	2.0000	1
323	4668	15	1143	5	Q2	2012	10.5000	3.6750	3.0000	1
323	4688	6	0	3	Q1	2012	7.0000	2.5900	2.0000	1
323	5174	16	0	3	Q1	2012	10.5000	4.7250	3.0000	1
323	5220	6	0	4	Q2	2012	7.0000	3.2200	2.0000	1
323	5293	6	0	7	Q3	2012	10.5000	4.7250	3.0000	1
323	5295	16	0	10	Q4	2012	14.0000	4.3400	4.0000	1
323	5423	11	0	7	Q3	2012	10.5000	3.4650	3.0000	1
323	5471	6	523	11	Q4	2012	10.5000	3.8850	3.0000	1
323	5647	15	0	2	Q1	2012	10.5000	3.2550	3.0000	1
323	5923	23	1789	12	Q4	2012	14.0000	5.3200	4.0000	1
323	5948	7	0	3	Q1	2012	7.0000	2.8000	2.0000	1
323	6113	16	0	8	Q3	2012	10.5000	4.4100	3.0000	1
323	6168	17	1314	11	Q4	2012	7.0000	2.9400	2.0000	1
323	6299	6	0	4	Q2	2012	14.0000	6.4400	4.0000	1
323	7352	6	0	7	Q3	2012	14.0000	5.8800	4.0000	1
323	7444	13	0	1	Q1	2012	10.5000	5.1450	3.0000	1
323	7494	15	1150	8	Q3	2012	14.0000	4.6200	4.0000	1
323	7607	17	0	5	Q2	2012	10.5000	4.5150	3.0000	1
323	7858	15	1152	9	Q3	2012	17.5000	5.7750	5.0000	1
323	8298	13	0	1	Q1	2012	14.0000	6.5800	4.0000	1
323	8351	16	0	6	Q2	2012	14.0000	5.0400	4.0000	1
323	8769	23	0	11	Q4	2012	10.5000	4.5150	3.0000	1
323	8912	6	0	9	Q3	2012	10.5000	4.5150	3.0000	1
323	8912	7	0	5	Q2	2012	7.0000	3.0100	2.0000	1
323	9027	7	523	11	Q4	2012	10.5000	3.3600	3.0000	1
323	9535	11	0	10	Q4	2012	10.5000	3.1500	3.0000	1
323	9633	7	0	5	Q2	2012	10.5000	4.5150	3.0000	1
323	9866	3	0	6	Q2	2012	10.5000	4.6200	3.0000	1
324	188	13	0	9	Q3	2012	3.9400	1.5366	2.0000	1
324	769	16	0	1	Q1	2012	9.8500	3.2505	5.0000	1
324	968	15	0	11	Q4	2012	3.9400	1.4578	2.0000	1
324	968	15	1141	4	Q2	2012	5.9100	1.8321	3.0000	1
324	1352	17	0	5	Q2	2012	5.9100	2.4231	3.0000	1
324	1811	11	0	9	Q3	2012	7.8800	2.6004	4.0000	1
324	1850	16	1225	7	Q3	2012	5.9100	2.8368	3.0000	1
324	2019	16	1235	11	Q4	2012	3.9400	1.6154	2.0000	1
324	2135	22	1708	11	Q4	2012	1.9700	0.6304	1.0000	1
324	2524	7	523	11	Q4	2012	7.8800	3.7824	4.0000	1
324	2736	7	0	6	Q2	2012	5.9100	2.0685	3.0000	1
324	2769	16	1235	11	Q4	2012	3.9400	1.6548	2.0000	1
324	2805	2	0	8	Q3	2012	1.9700	0.8865	1.0000	1
324	3068	11	841	12	Q4	2012	5.9100	2.1276	3.0000	1
324	4070	23	1772	4	Q2	2012	5.9100	1.8912	3.0000	1
324	4736	13	0	5	Q2	2012	3.9400	1.3002	2.0000	1
324	4827	6	0	10	Q4	2012	7.8800	2.6792	4.0000	1
324	5543	24	0	10	Q4	2012	9.8500	4.1370	5.0000	1
324	5633	13	986	6	Q2	2012	5.9100	2.6004	3.0000	1
324	5766	16	1236	12	Q4	2012	3.9400	1.5366	2.0000	1
324	6146	15	0	7	Q3	2012	7.8800	3.2308	4.0000	1
324	6715	7	0	12	Q4	2012	7.8800	2.7580	4.0000	1
324	6835	16	0	4	Q2	2012	3.9400	1.3002	2.0000	1
324	7003	15	0	12	Q4	2012	3.9400	1.7730	2.0000	1
324	7416	13	988	7	Q3	2012	7.8800	3.0732	4.0000	1
324	7852	11	829	6	Q2	2012	5.9100	2.8368	3.0000	1
324	7985	24	1859	8	Q3	2012	7.8800	2.4428	4.0000	1
324	8189	17	0	12	Q4	2012	5.9100	2.4822	3.0000	1
324	8250	15	0	11	Q4	2012	3.9400	1.2608	2.0000	1
324	8252	13	0	9	Q3	2012	7.8800	3.2308	4.0000	1
324	8289	17	0	4	Q2	2012	3.9400	1.7730	2.0000	1
324	8545	7	518	8	Q3	2012	5.9100	2.0094	3.0000	1
324	8571	3	207	11	Q4	2012	3.9400	1.6548	2.0000	1
324	8760	24	1859	8	Q3	2012	3.9400	1.3790	2.0000	1
324	9173	11	0	4	Q2	2012	7.8800	2.9156	4.0000	1
324	9217	7	0	3	Q1	2012	5.9100	2.9550	3.0000	1
324	9286	13	0	12	Q4	2012	5.9100	2.8368	3.0000	1
324	9602	11	0	1	Q1	2012	3.9400	1.4972	2.0000	1
324	9956	17	0	9	Q3	2012	5.9100	1.8912	3.0000	1
324	10238	16	0	10	Q4	2012	3.9400	1.8912	2.0000	1
325	154	13	0	2	Q1	2012	4.5300	2.0385	3.0000	1
325	255	7	0	5	Q2	2012	6.0400	1.8120	4.0000	1
325	846	24	0	6	Q2	2012	6.0400	2.4764	4.0000	1
325	1339	13	0	4	Q2	2012	6.0400	2.1744	4.0000	1
325	1399	24	0	5	Q2	2012	3.0200	1.2080	2.0000	1
325	1432	11	0	4	Q2	2012	3.0200	1.2080	2.0000	1
325	1529	13	0	9	Q3	2012	6.0400	2.8388	4.0000	1
325	1697	14	0	12	Q4	2012	3.0200	1.4496	2.0000	1
325	1758	3	0	7	Q3	2012	3.0200	1.3892	2.0000	1
325	1965	17	0	6	Q2	2012	7.5500	2.2650	5.0000	1
325	2032	23	0	8	Q3	2012	4.5300	1.6761	3.0000	1
325	2224	16	0	9	Q3	2012	6.0400	2.2348	4.0000	1
325	2238	24	0	4	Q2	2012	6.0400	2.5972	4.0000	1
325	2496	11	837	10	Q4	2012	4.5300	2.0838	3.0000	1
325	2547	23	0	10	Q4	2012	6.0400	2.4764	4.0000	1
325	2850	3	0	8	Q3	2012	7.5500	2.4915	5.0000	1
325	3369	24	0	9	Q3	2012	4.5300	1.4043	3.0000	1
325	4351	23	0	2	Q1	2012	6.0400	2.5972	4.0000	1
325	4727	16	0	12	Q4	2012	3.0200	1.4798	2.0000	1
325	5147	13	0	12	Q4	2012	4.5300	1.4496	3.0000	1
325	5361	24	0	6	Q2	2012	4.5300	1.9479	3.0000	1
325	5387	6	508	4	Q2	2012	3.0200	1.3590	2.0000	1
325	5742	16	0	10	Q4	2012	4.5300	2.2650	3.0000	1
325	5960	6	0	2	Q1	2012	4.5300	1.5402	3.0000	1
325	6018	11	0	5	Q2	2012	4.5300	1.4496	3.0000	1
325	6079	13	0	11	Q4	2012	4.5300	1.6308	3.0000	1
325	6145	15	0	4	Q2	2012	3.0200	1.1778	2.0000	1
325	6204	13	980	3	Q1	2012	4.5300	1.9932	3.0000	1
325	6772	24	0	4	Q2	2012	4.5300	1.4043	3.0000	1
325	8074	17	0	7	Q3	2012	4.5300	2.0838	3.0000	1
325	8289	17	0	9	Q3	2012	6.0400	2.3556	4.0000	1
325	8673	11	0	12	Q4	2012	6.0400	2.2952	4.0000	1
325	8717	17	0	2	Q1	2012	6.0400	2.0536	4.0000	1
325	8718	7	0	10	Q4	2012	7.5500	2.4160	5.0000	1
325	9046	14	0	3	Q1	2012	3.0200	1.0268	2.0000	1
325	9194	17	0	8	Q3	2012	6.0400	1.8120	4.0000	1
325	9231	11	0	12	Q4	2012	3.0200	1.3590	2.0000	1
325	9263	16	1225	7	Q3	2012	3.0200	1.4496	2.0000	1
325	9318	16	1233	10	Q4	2012	3.0200	1.0268	2.0000	1
325	9851	3	0	9	Q3	2012	6.0400	2.1744	4.0000	1
325	9976	17	1303	6	Q2	2012	4.5300	1.8120	3.0000	1
325	10053	7	0	12	Q4	2012	4.5300	1.6761	3.0000	1
325	10097	7	505	2	Q1	2012	4.5300	1.9932	3.0000	1
326	191	6	524	11	Q4	2012	7.4100	3.3345	3.0000	1
326	287	6	504	2	Q1	2012	9.8800	3.8532	4.0000	1
326	760	3	210	12	Q4	2012	7.4100	3.3345	3.0000	1
326	878	3	0	8	Q3	2012	7.4100	3.6309	3.0000	1
326	1159	11	0	8	Q3	2012	7.4100	2.2971	3.0000	1
326	1176	24	0	9	Q3	2012	7.4100	2.2971	3.0000	1
326	1605	7	521	10	Q4	2012	9.8800	3.0628	4.0000	1
326	1681	13	0	3	Q1	2012	7.4100	2.8158	3.0000	1
326	1856	24	0	1	Q1	2012	4.9400	2.1736	2.0000	1
326	1991	13	0	10	Q4	2012	9.8800	4.4460	4.0000	1
326	2019	16	1235	11	Q4	2012	7.4100	3.4086	3.0000	1
326	2406	24	0	10	Q4	2012	9.8800	4.6436	4.0000	1
326	2588	23	0	4	Q2	2012	7.4100	3.4086	3.0000	1
326	2638	13	0	1	Q1	2012	9.8800	3.5568	4.0000	1
326	2690	3	0	6	Q2	2012	9.8800	3.8532	4.0000	1
326	2981	23	0	9	Q3	2012	4.9400	1.8278	2.0000	1
326	3169	6	0	2	Q1	2012	9.8800	4.6436	4.0000	1
326	3200	14	1064	5	Q2	2012	4.9400	1.7784	2.0000	1
326	3242	3	0	4	Q2	2012	4.9400	1.6796	2.0000	1
326	3693	3	207	11	Q4	2012	4.9400	1.9760	2.0000	1
326	3817	6	508	4	Q2	2012	7.4100	3.4086	3.0000	1
326	3997	15	0	1	Q1	2012	7.4100	3.2604	3.0000	1
326	4232	6	515	7	Q3	2012	7.4100	3.5568	3.0000	1
326	4282	15	0	10	Q4	2012	4.9400	2.4700	2.0000	1
326	4541	3	0	8	Q3	2012	4.9400	1.9760	2.0000	1
326	4958	23	0	10	Q4	2012	7.4100	2.8158	3.0000	1
326	5097	14	1079	12	Q4	2012	2.4700	0.8892	1.0000	1
326	5127	15	0	6	Q2	2012	7.4100	2.6676	3.0000	1
326	5191	15	0	5	Q2	2012	7.4100	3.1863	3.0000	1
326	5307	6	0	8	Q3	2012	4.9400	2.2230	2.0000	1
326	5346	3	0	12	Q4	2012	7.4100	2.2971	3.0000	1
326	5542	16	0	4	Q2	2012	9.8800	4.2484	4.0000	1
326	5644	17	0	11	Q4	2012	7.4100	3.3345	3.0000	1
326	5681	11	833	8	Q3	2012	7.4100	2.8158	3.0000	1
326	5786	13	0	7	Q3	2012	7.4100	3.3345	3.0000	1
326	6710	13	0	11	Q4	2012	7.4100	3.1863	3.0000	1
326	7203	13	0	12	Q4	2012	7.4100	2.6676	3.0000	1
326	7241	17	0	3	Q1	2012	9.8800	4.6436	4.0000	1
326	8014	24	0	4	Q2	2012	7.4100	2.5935	3.0000	1
326	8336	17	0	3	Q1	2012	9.8800	3.6556	4.0000	1
326	8472	17	0	11	Q4	2012	7.4100	2.8899	3.0000	1
326	8737	11	820	2	Q1	2012	4.9400	1.7290	2.0000	1
326	8754	7	504	2	Q1	2012	7.4100	2.6676	3.0000	1
326	8864	6	0	9	Q3	2012	4.9400	1.8772	2.0000	1
326	9208	15	0	2	Q1	2012	7.4100	2.9640	3.0000	1
326	9216	15	1146	7	Q3	2012	9.8800	3.5568	4.0000	1
326	9318	16	1233	10	Q4	2012	7.4100	3.4086	3.0000	1
326	9583	15	1138	3	Q1	2012	9.8800	4.2484	4.0000	1
326	9867	13	0	4	Q2	2012	9.8800	4.8412	4.0000	1
326	10019	11	0	8	Q3	2012	9.8800	3.8532	4.0000	1
326	10033	3	0	4	Q2	2012	7.4100	2.6676	3.0000	1
326	10209	6	0	10	Q4	2012	7.4100	2.2971	3.0000	1
327	325	15	0	2	Q1	2012	1.8000	0.7020	3.0000	1
327	336	6	0	6	Q2	2012	1.8000	0.5580	3.0000	1
327	361	11	0	10	Q4	2012	1.8000	0.8820	3.0000	1
327	471	24	0	8	Q3	2012	1.8000	0.6300	3.0000	1
327	527	7	0	3	Q1	2012	1.8000	0.7740	3.0000	1
327	1083	11	829	6	Q2	2012	1.2000	0.4320	2.0000	1
327	1168	17	0	1	Q1	2012	1.2000	0.4560	2.0000	1
327	1267	13	980	3	Q1	2012	2.4000	1.2000	4.0000	1
327	1298	17	1303	6	Q2	2012	1.8000	0.6660	3.0000	1
327	1721	13	0	10	Q4	2012	1.8000	0.5940	3.0000	1
327	1983	17	0	10	Q4	2012	3.0000	1.4700	5.0000	1
327	2147	13	980	3	Q1	2012	1.2000	0.4920	2.0000	1
327	2246	13	0	7	Q3	2012	1.8000	0.6660	3.0000	1
327	2277	6	0	6	Q2	2012	1.2000	0.6000	2.0000	1
327	2320	2	0	12	Q4	2012	0.6000	0.2760	1.0000	1
327	2741	2	0	1	Q1	2012	1.2000	0.4560	2.0000	1
327	2831	14	0	11	Q4	2012	1.2000	0.3720	2.0000	1
327	3109	11	836	9	Q3	2012	1.8000	0.6120	3.0000	1
327	3216	7	514	7	Q3	2012	1.8000	0.5580	3.0000	1
327	3293	11	826	5	Q2	2012	1.8000	0.8280	3.0000	1
327	3491	16	0	4	Q2	2012	1.2000	0.4440	2.0000	1
327	3497	17	0	2	Q1	2012	1.8000	0.6300	3.0000	1
327	4032	11	0	9	Q3	2012	1.8000	0.6660	3.0000	1
327	4069	17	0	2	Q1	2012	1.8000	0.8460	3.0000	1
327	4127	15	1143	5	Q2	2012	2.4000	1.1040	4.0000	1
327	4149	11	0	2	Q1	2012	1.2000	0.5880	2.0000	1
327	4330	13	992	9	Q3	2012	2.4000	1.0560	4.0000	1
327	4772	2	0	9	Q3	2012	1.2000	0.3720	2.0000	1
327	4828	7	504	2	Q1	2012	2.4000	1.2000	4.0000	1
327	5432	16	0	1	Q1	2012	1.2000	0.3960	2.0000	1
327	6134	15	0	10	Q4	2012	1.8000	0.7020	3.0000	1
327	6162	17	0	7	Q3	2012	1.2000	0.4560	2.0000	1
327	6530	17	1294	2	Q1	2012	1.2000	0.4920	2.0000	1
327	6554	17	0	3	Q1	2012	1.2000	0.4440	2.0000	1
327	6570	11	0	1	Q1	2012	1.8000	0.6660	3.0000	1
327	6599	22	0	9	Q3	2012	0.6000	0.2460	1.0000	1
327	6666	17	0	12	Q4	2012	1.8000	0.8820	3.0000	1
327	6854	17	1307	8	Q3	2012	2.4000	1.1520	4.0000	1
327	6866	17	1314	11	Q4	2012	1.8000	0.6480	3.0000	1
327	7203	13	0	5	Q2	2012	1.8000	0.6300	3.0000	1
327	7529	17	1307	8	Q3	2012	1.8000	0.6480	3.0000	1
327	8289	17	0	6	Q2	2012	1.2000	0.5520	2.0000	1
327	8289	17	1303	6	Q2	2012	1.8000	0.7560	3.0000	1
327	8348	24	1866	11	Q4	2012	1.8000	0.6840	3.0000	1
327	9016	23	0	1	Q1	2012	2.4000	0.8880	4.0000	1
327	9027	7	0	6	Q2	2012	1.2000	0.4560	2.0000	1
327	9300	7	519	9	Q3	2012	2.4000	0.7920	4.0000	1
327	9491	13	0	5	Q2	2012	2.4000	0.7920	4.0000	1
327	9631	16	1216	2	Q1	2012	2.4000	0.8160	4.0000	1
327	9633	7	0	5	Q2	2012	1.8000	0.7020	3.0000	1
327	10007	7	0	10	Q4	2012	1.8000	0.8640	3.0000	1
328	93	13	0	1	Q1	2012	5.0400	1.8144	4.0000	1
328	115	7	512	6	Q2	2012	3.7800	1.1718	3.0000	1
328	454	17	0	2	Q1	2012	3.7800	1.2096	3.0000	1
328	527	7	514	7	Q3	2012	2.5200	1.0836	2.0000	1
328	697	13	0	12	Q4	2012	3.7800	1.2096	3.0000	1
328	712	6	0	2	Q1	2012	3.7800	1.6254	3.0000	1
328	742	15	0	6	Q2	2012	3.7800	1.2852	3.0000	1
328	887	14	0	4	Q2	2012	2.5200	0.8064	2.0000	1
328	916	7	0	12	Q4	2012	5.0400	2.0160	4.0000	1
328	941	13	0	12	Q4	2012	3.7800	1.7766	3.0000	1
328	957	6	0	8	Q3	2012	3.7800	1.1718	3.0000	1
328	993	13	0	7	Q3	2012	3.7800	1.5876	3.0000	1
328	1175	6	510	5	Q2	2012	5.0400	1.8144	4.0000	1
328	1271	13	0	4	Q2	2012	3.7800	1.1718	3.0000	1
328	1282	3	0	12	Q4	2012	2.5200	1.0332	2.0000	1
328	1452	24	0	10	Q4	2012	2.5200	1.1340	2.0000	1
328	1610	3	0	8	Q3	2012	3.7800	1.8522	3.0000	1
328	1983	17	1303	6	Q2	2012	5.0400	2.3184	4.0000	1
328	2188	13	0	8	Q3	2012	5.0400	1.6632	4.0000	1
328	2371	16	0	1	Q1	2012	3.7800	1.1718	3.0000	1
328	2682	23	0	11	Q4	2012	3.7800	1.3230	3.0000	1
328	3046	13	0	6	Q2	2012	2.5200	1.2348	2.0000	1
328	3179	24	0	9	Q3	2012	2.5200	0.8064	2.0000	1
328	3253	13	976	1	Q1	2012	5.0400	2.2680	4.0000	1
328	3649	11	0	5	Q2	2012	2.5200	1.0332	2.0000	1
328	3693	3	0	12	Q4	2012	3.7800	1.3608	3.0000	1
328	3873	11	0	9	Q3	2012	5.0400	2.0160	4.0000	1
328	3921	23	0	2	Q1	2012	2.5200	0.7812	2.0000	1
328	4061	7	0	10	Q4	2012	5.0400	1.9656	4.0000	1
328	4122	15	0	12	Q4	2012	3.7800	1.7010	3.0000	1
328	4261	13	0	7	Q3	2012	3.7800	1.8522	3.0000	1
328	4330	13	0	9	Q3	2012	5.0400	1.5624	4.0000	1
328	4331	24	0	5	Q2	2012	2.5200	1.1340	2.0000	1
328	4658	17	0	11	Q4	2012	3.7800	1.2096	3.0000	1
328	4824	3	0	12	Q4	2012	2.5200	0.8064	2.0000	1
328	4841	15	0	12	Q4	2012	3.7800	1.3230	3.0000	1
328	5002	23	1773	4	Q2	2012	3.7800	1.3608	3.0000	1
328	5280	7	0	9	Q3	2012	3.7800	1.3608	3.0000	1
328	5329	13	0	12	Q4	2012	3.7800	1.6632	3.0000	1
328	5341	17	0	7	Q3	2012	3.7800	1.7010	3.0000	1
328	5742	16	0	7	Q3	2012	5.0400	2.2680	4.0000	1
328	5925	15	0	9	Q3	2012	2.5200	1.0080	2.0000	1
328	5944	3	205	10	Q4	2012	3.7800	1.8144	3.0000	1
328	5945	7	0	7	Q3	2012	3.7800	1.3230	3.0000	1
328	6414	24	1858	7	Q3	2012	2.5200	0.9828	2.0000	1
328	6470	6	518	8	Q3	2012	3.7800	1.2474	3.0000	1
328	6500	6	0	7	Q3	2012	5.0400	1.6128	4.0000	1
328	6570	11	836	9	Q3	2012	3.7800	1.5876	3.0000	1
328	6781	15	0	12	Q4	2012	3.7800	1.7388	3.0000	1
328	6854	17	1292	1	Q1	2012	3.7800	1.4364	3.0000	1
328	7065	17	0	6	Q2	2012	5.0400	1.5624	4.0000	1
328	7153	3	0	4	Q2	2012	3.7800	1.6254	3.0000	1
328	7701	15	0	10	Q4	2012	3.7800	1.2096	3.0000	1
328	7704	3	0	1	Q1	2012	2.5200	0.9828	2.0000	1
328	7721	13	0	10	Q4	2012	3.7800	1.3608	3.0000	1
328	7741	15	0	8	Q3	2012	5.0400	1.6632	4.0000	1
328	7806	13	0	7	Q3	2012	3.7800	1.2096	3.0000	1
328	8944	14	0	3	Q1	2012	2.5200	0.9828	2.0000	1
328	9631	16	0	8	Q3	2012	5.0400	1.5624	4.0000	1
328	9671	13	0	1	Q1	2012	2.5200	1.2096	2.0000	1
328	9928	16	1235	11	Q4	2012	6.3000	2.0160	5.0000	1
328	9974	6	526	12	Q4	2012	2.5200	1.2096	2.0000	1
328	10059	15	0	9	Q3	2012	3.7800	1.3986	3.0000	1
328	10197	14	0	1	Q1	2012	2.5200	0.8568	2.0000	1
329	377	6	523	11	Q4	2012	5.2200	1.8792	3.0000	1
329	747	24	0	3	Q1	2012	6.9600	2.1576	4.0000	1
329	769	16	0	5	Q2	2012	5.2200	2.0880	3.0000	1
329	769	16	1233	10	Q4	2012	8.7000	2.8710	5.0000	1
329	886	15	1146	7	Q3	2012	6.9600	2.3664	4.0000	1
329	994	13	0	1	Q1	2012	3.4800	1.2528	2.0000	1
329	997	3	0	10	Q4	2012	5.2200	2.1924	3.0000	1
329	1066	14	0	3	Q1	2012	1.7400	0.7308	1.0000	1
329	1138	7	0	6	Q2	2012	3.4800	1.4268	2.0000	1
329	1178	11	0	12	Q4	2012	6.9600	2.3664	4.0000	1
329	1309	24	0	4	Q2	2012	5.2200	2.3490	3.0000	1
329	1449	23	0	6	Q2	2012	8.7000	3.8280	5.0000	1
329	1744	17	0	12	Q4	2012	3.4800	1.5660	2.0000	1
329	1887	11	842	12	Q4	2012	5.2200	1.7748	3.0000	1
329	2238	24	0	4	Q2	2012	6.9600	2.2272	4.0000	1
329	2280	13	0	7	Q3	2012	3.4800	1.4268	2.0000	1
329	2613	11	0	11	Q4	2012	5.2200	1.6704	3.0000	1
329	2638	13	1000	12	Q4	2012	5.2200	2.1924	3.0000	1
329	3131	15	0	12	Q4	2012	6.9600	3.4800	4.0000	1
329	3196	13	0	11	Q4	2012	6.9600	2.7144	4.0000	1
329	3285	6	0	4	Q2	2012	6.9600	2.6448	4.0000	1
329	3763	24	0	12	Q4	2012	8.7000	2.7840	5.0000	1
329	3767	7	516	8	Q3	2012	5.2200	2.0358	3.0000	1
329	3819	23	1788	11	Q4	2012	6.9600	3.3408	4.0000	1
329	4061	6	0	5	Q2	2012	6.9600	2.7144	4.0000	1
329	4342	13	0	5	Q2	2012	5.2200	1.5660	3.0000	1
329	4522	17	0	11	Q4	2012	5.2200	2.2968	3.0000	1
329	4609	23	0	7	Q3	2012	3.4800	1.1484	2.0000	1
329	4691	17	0	5	Q2	2012	6.9600	2.5056	4.0000	1
329	4885	24	1845	1	Q1	2012	5.2200	2.4012	3.0000	1
329	5329	13	0	5	Q2	2012	5.2200	2.2968	3.0000	1
329	5329	13	0	7	Q3	2012	5.2200	2.2968	3.0000	1
329	5353	23	0	5	Q2	2012	6.9600	2.2272	4.0000	1
329	5374	16	0	5	Q2	2012	5.2200	2.5578	3.0000	1
329	5835	24	0	10	Q4	2012	6.9600	2.9232	4.0000	1
329	6169	13	0	7	Q3	2012	3.4800	1.6356	2.0000	1
329	6453	24	1869	12	Q4	2012	5.2200	2.2446	3.0000	1
329	6617	7	0	3	Q1	2012	5.2200	2.0358	3.0000	1
329	7065	17	1312	10	Q4	2012	5.2200	2.6100	3.0000	1
329	7192	2	0	4	Q2	2012	1.7400	0.7482	1.0000	1
329	7662	24	1869	12	Q4	2012	3.4800	1.5660	2.0000	1
329	7849	3	0	3	Q1	2012	6.9600	3.1320	4.0000	1
329	7938	24	0	9	Q3	2012	5.2200	1.6182	3.0000	1
329	8189	17	1307	8	Q3	2012	5.2200	1.8270	3.0000	1
329	8859	15	0	11	Q4	2012	6.9600	3.1320	4.0000	1
329	8970	22	0	7	Q3	2012	3.4800	1.5312	2.0000	1
329	9064	17	0	11	Q4	2012	6.9600	2.6448	4.0000	1
329	9497	15	0	1	Q1	2012	5.2200	2.1924	3.0000	1
329	9550	6	526	12	Q4	2012	3.4800	1.4964	2.0000	1
329	9728	16	1220	4	Q2	2012	5.2200	1.8792	3.0000	1
329	9815	16	1236	12	Q4	2012	3.4800	1.4616	2.0000	1
329	9862	7	0	1	Q1	2012	5.2200	2.5578	3.0000	1
329	9976	17	1292	1	Q1	2012	5.2200	1.8270	3.0000	1
330	179	6	526	12	Q4	2012	15.9200	4.9352	4.0000	1
330	488	14	0	10	Q4	2012	7.9600	3.5820	2.0000	1
330	734	7	0	7	Q3	2012	11.9400	5.1342	3.0000	1
330	817	17	0	10	Q4	2012	15.9200	7.9600	4.0000	1
330	878	3	0	12	Q4	2012	11.9400	5.3730	3.0000	1
330	1086	11	0	11	Q4	2012	11.9400	5.6118	3.0000	1
330	1168	17	0	4	Q2	2012	11.9400	3.9402	3.0000	1
330	1168	17	0	8	Q3	2012	7.9600	2.6268	2.0000	1
330	1360	13	0	3	Q1	2012	7.9600	2.4676	2.0000	1
330	2076	13	0	10	Q4	2012	19.9000	5.9700	5.0000	1
330	2295	17	0	4	Q2	2012	11.9400	3.7014	3.0000	1
330	2389	7	504	2	Q1	2012	11.9400	5.0148	3.0000	1
330	2390	17	0	1	Q1	2012	11.9400	5.8506	3.0000	1
330	2570	16	1223	6	Q2	2012	7.9600	2.6268	2.0000	1
330	2921	16	1214	2	Q1	2012	7.9600	3.5820	2.0000	1
330	3242	3	0	4	Q2	2012	11.9400	4.2984	3.0000	1
330	3307	15	0	3	Q1	2012	11.9400	5.8506	3.0000	1
330	3663	7	0	10	Q4	2012	7.9600	3.9800	2.0000	1
330	3718	11	0	4	Q2	2012	7.9600	3.5820	2.0000	1
330	3773	17	0	1	Q1	2012	15.9200	5.8904	4.0000	1
330	3804	24	0	7	Q3	2012	15.9200	7.8008	4.0000	1
330	3888	7	0	7	Q3	2012	11.9400	4.4178	3.0000	1
330	3970	7	0	4	Q2	2012	11.9400	4.6566	3.0000	1
330	4021	16	1235	11	Q4	2012	7.9600	3.0248	2.0000	1
330	4099	17	0	9	Q3	2012	7.9600	3.1044	2.0000	1
330	4993	14	0	10	Q4	2012	7.9600	3.9800	2.0000	1
330	5295	16	0	6	Q2	2012	11.9400	4.2984	3.0000	1
330	5432	16	0	5	Q2	2012	15.9200	7.6416	4.0000	1
330	5612	15	0	1	Q1	2012	15.9200	7.6416	4.0000	1
330	5628	14	0	10	Q4	2012	3.9800	1.7910	1.0000	1
330	5857	11	0	3	Q1	2012	11.9400	4.7760	3.0000	1
330	6061	17	0	12	Q4	2012	15.9200	5.8904	4.0000	1
330	6206	11	0	11	Q4	2012	7.9600	3.1840	2.0000	1
330	6526	13	980	3	Q1	2012	7.9600	3.8208	2.0000	1
330	6686	13	0	1	Q1	2012	7.9600	2.9452	2.0000	1
330	6751	22	0	12	Q4	2012	7.9600	3.4228	2.0000	1
330	6970	7	0	5	Q2	2012	7.9600	2.6268	2.0000	1
330	6989	15	1138	3	Q1	2012	15.9200	6.5272	4.0000	1
330	6997	13	0	3	Q1	2012	11.9400	5.3730	3.0000	1
330	7438	2	0	10	Q4	2012	3.9800	1.5124	1.0000	1
330	7618	11	826	5	Q2	2012	11.9400	4.5372	3.0000	1
330	7909	3	204	9	Q3	2012	11.9400	4.2984	3.0000	1
330	8130	7	0	4	Q2	2012	11.9400	4.4178	3.0000	1
330	8340	6	0	3	Q1	2012	11.9400	3.8208	3.0000	1
330	8359	17	0	12	Q4	2012	11.9400	4.8954	3.0000	1
330	8495	15	1140	4	Q2	2012	11.9400	4.5372	3.0000	1
330	8617	17	0	6	Q2	2012	11.9400	5.1342	3.0000	1
330	8699	7	0	6	Q2	2012	15.9200	5.0944	4.0000	1
330	8912	6	0	9	Q3	2012	15.9200	7.8008	4.0000	1
330	8947	3	201	8	Q3	2012	15.9200	7.1640	4.0000	1
330	9324	3	0	8	Q3	2012	11.9400	5.6118	3.0000	1
330	9851	3	0	2	Q1	2012	15.9200	4.9352	4.0000	1
330	9892	13	980	3	Q1	2012	7.9600	3.2636	2.0000	1
330	10104	7	505	2	Q1	2012	11.9400	4.5372	3.0000	1
330	10152	13	986	6	Q2	2012	7.9600	3.9800	2.0000	1
331	106	6	504	2	Q1	2012	14.1500	6.2260	5.0000	1
331	151	14	0	2	Q1	2012	5.6600	2.7168	2.0000	1
331	161	24	0	8	Q3	2012	8.4900	4.0752	3.0000	1
331	454	17	0	8	Q3	2012	8.4900	2.5470	3.0000	1
331	477	15	1138	3	Q1	2012	8.4900	3.7356	3.0000	1
331	588	23	0	3	Q1	2012	8.4900	3.4809	3.0000	1
331	591	11	0	10	Q4	2012	11.3200	4.5280	4.0000	1
331	689	24	0	9	Q3	2012	5.6600	2.2640	2.0000	1
331	778	15	1157	12	Q4	2012	8.4900	3.8205	3.0000	1
331	1152	7	0	5	Q2	2012	5.6600	2.4338	2.0000	1
331	1897	13	0	6	Q2	2012	5.6600	2.0942	2.0000	1
331	1897	13	976	1	Q1	2012	5.6600	2.0942	2.0000	1
331	2059	17	1292	1	Q1	2012	11.3200	5.2072	4.0000	1
331	2077	23	1768	2	Q1	2012	8.4900	4.0752	3.0000	1
331	2158	11	833	8	Q3	2012	8.4900	3.3111	3.0000	1
331	2311	6	523	11	Q4	2012	8.4900	3.9054	3.0000	1
331	2368	3	197	6	Q2	2012	5.6600	2.4338	2.0000	1
331	2430	24	0	5	Q2	2012	5.6600	2.4338	2.0000	1
331	2723	3	0	6	Q2	2012	8.4900	2.6319	3.0000	1
331	2942	17	0	11	Q4	2012	5.6600	2.4338	2.0000	1
331	2942	17	1312	10	Q4	2012	5.6600	2.1508	2.0000	1
331	3445	15	0	10	Q4	2012	8.4900	3.1413	3.0000	1
331	3928	23	0	9	Q3	2012	11.3200	5.5468	4.0000	1
331	4065	3	207	11	Q4	2012	5.6600	2.4338	2.0000	1
331	4267	7	0	1	Q1	2012	8.4900	3.8205	3.0000	1
331	4351	23	0	2	Q1	2012	11.3200	5.4336	4.0000	1
331	4524	24	0	10	Q4	2012	11.3200	4.1884	4.0000	1
331	4566	11	0	12	Q4	2012	8.4900	3.7356	3.0000	1
331	4658	17	0	9	Q3	2012	8.4900	2.6319	3.0000	1
331	5196	13	0	4	Q2	2012	14.1500	4.9525	5.0000	1
331	5358	3	205	10	Q4	2012	11.3200	4.1884	4.0000	1
331	5542	16	0	5	Q2	2012	8.4900	3.2262	3.0000	1
331	5671	6	0	4	Q2	2012	14.1500	6.6505	5.0000	1
331	5707	23	1786	10	Q4	2012	5.6600	2.2640	2.0000	1
331	6049	15	0	12	Q4	2012	8.4900	3.3960	3.0000	1
331	6132	3	0	9	Q3	2012	11.3200	5.2072	4.0000	1
331	6247	24	0	8	Q3	2012	8.4900	2.7168	3.0000	1
331	6291	3	0	4	Q2	2012	8.4900	4.1601	3.0000	1
331	6333	14	0	12	Q4	2012	5.6600	1.9244	2.0000	1
331	6957	16	0	8	Q3	2012	8.4900	3.2262	3.0000	1
331	7003	15	0	6	Q2	2012	11.3200	3.8488	4.0000	1
331	7343	7	0	8	Q3	2012	5.6600	2.5470	2.0000	1
331	7355	13	0	9	Q3	2012	8.4900	3.9054	3.0000	1
331	7704	3	195	5	Q2	2012	8.4900	3.2262	3.0000	1
331	7809	2	118	6	Q2	2012	2.8300	1.1320	1.0000	1
331	8311	23	0	11	Q4	2012	8.4900	2.6319	3.0000	1
331	8731	3	0	5	Q2	2012	11.3200	4.1884	4.0000	1
331	9171	15	1154	10	Q4	2012	11.3200	4.3016	4.0000	1
331	9225	11	0	4	Q2	2012	8.4900	3.6507	3.0000	1
331	9299	24	0	10	Q4	2012	8.4900	3.9054	3.0000	1
331	9318	16	1220	4	Q2	2012	8.4900	2.8866	3.0000	1
331	9468	11	829	6	Q2	2012	8.4900	4.2450	3.0000	1
331	9488	24	0	5	Q2	2012	11.3200	3.5092	4.0000	1
331	9504	13	980	3	Q1	2012	8.4900	2.9715	3.0000	1
331	9697	23	1789	12	Q4	2012	11.3200	5.0940	4.0000	1
331	9898	15	0	1	Q1	2012	8.4900	2.9715	3.0000	1
331	10126	6	506	3	Q1	2012	5.6600	2.3206	2.0000	1
332	168	22	0	3	Q1	2012	4.4200	1.4586	2.0000	1
332	197	24	0	12	Q4	2012	6.6300	2.9172	3.0000	1
332	265	11	0	5	Q2	2012	8.8400	2.8288	4.0000	1
332	308	14	0	5	Q2	2012	4.4200	1.4586	2.0000	1
332	742	15	0	6	Q2	2012	6.6300	2.5194	3.0000	1
332	760	3	0	6	Q2	2012	6.6300	2.5857	3.0000	1
332	760	3	0	12	Q4	2012	6.6300	2.9172	3.0000	1
332	863	17	0	11	Q4	2012	8.8400	4.4200	4.0000	1
332	1152	7	0	10	Q4	2012	4.4200	1.8122	2.0000	1
332	1899	7	0	4	Q2	2012	11.0500	5.0830	5.0000	1
332	1957	13	0	8	Q3	2012	4.4200	1.6354	2.0000	1
332	1979	3	0	3	Q1	2012	8.8400	3.8896	4.0000	1
332	2636	17	1304	7	Q3	2012	8.8400	2.7404	4.0000	1
332	2742	17	0	6	Q2	2012	6.6300	2.3868	3.0000	1
332	2798	11	0	9	Q3	2012	8.8400	2.8288	4.0000	1
332	3215	15	1143	5	Q2	2012	8.8400	3.0940	4.0000	1
332	3388	13	0	6	Q2	2012	4.4200	1.6796	2.0000	1
332	3412	11	0	1	Q1	2012	6.6300	3.0498	3.0000	1
332	3460	11	0	5	Q2	2012	6.6300	2.9172	3.0000	1
332	3750	6	0	3	Q1	2012	6.6300	2.9172	3.0000	1
332	3847	11	0	9	Q3	2012	6.6300	3.3150	3.0000	1
332	4021	16	0	5	Q2	2012	6.6300	2.3205	3.0000	1
332	4310	15	0	8	Q3	2012	6.6300	2.9172	3.0000	1
332	4338	6	521	10	Q4	2012	8.8400	3.4476	4.0000	1
332	4527	3	0	4	Q2	2012	8.8400	3.7128	4.0000	1
332	4541	3	0	2	Q1	2012	4.4200	1.7680	2.0000	1
332	4658	17	0	11	Q4	2012	6.6300	2.9172	3.0000	1
332	5189	6	0	12	Q4	2012	4.4200	1.5912	2.0000	1
332	5501	17	1311	10	Q4	2012	8.8400	3.9780	4.0000	1
332	6017	11	0	4	Q2	2012	8.8400	3.4476	4.0000	1
332	6057	11	0	9	Q3	2012	8.8400	3.7128	4.0000	1
332	6113	16	1236	12	Q4	2012	4.4200	1.6354	2.0000	1
332	6218	11	837	10	Q4	2012	6.6300	2.1216	3.0000	1
332	6268	24	0	5	Q2	2012	8.8400	2.7404	4.0000	1
332	6268	24	0	9	Q3	2012	8.8400	2.7404	4.0000	1
332	6380	14	0	5	Q2	2012	4.4200	2.2100	2.0000	1
332	6439	7	501	1	Q1	2012	4.4200	1.8564	2.0000	1
332	6799	17	0	3	Q1	2012	6.6300	2.9835	3.0000	1
332	6919	11	0	12	Q4	2012	4.4200	1.9006	2.0000	1
332	7051	16	0	12	Q4	2012	4.4200	1.5470	2.0000	1
332	7287	24	0	3	Q1	2012	6.6300	2.1879	3.0000	1
332	7384	3	0	12	Q4	2012	8.8400	2.8288	4.0000	1
332	7456	2	0	3	Q1	2012	2.2100	0.8177	1.0000	1
332	7655	17	0	2	Q1	2012	4.4200	2.1658	2.0000	1
332	7743	3	0	12	Q4	2012	6.6300	2.9172	3.0000	1
332	8609	7	0	4	Q2	2012	8.8400	3.1824	4.0000	1
332	9111	17	0	11	Q4	2012	4.4200	1.6354	2.0000	1
332	9209	6	0	3	Q1	2012	6.6300	2.7183	3.0000	1
332	9434	6	0	12	Q4	2012	6.6300	2.2542	3.0000	1
332	9511	24	0	10	Q4	2012	6.6300	2.9835	3.0000	1
332	9734	17	1311	10	Q4	2012	8.8400	4.1548	4.0000	1
332	9927	24	0	10	Q4	2012	8.8400	3.6244	4.0000	1
332	10210	7	518	8	Q3	2012	8.8400	2.7404	4.0000	1
333	93	13	0	11	Q4	2012	5.2800	2.3760	4.0000	1
333	181	3	0	7	Q3	2012	5.2800	1.6368	4.0000	1
333	426	15	0	11	Q4	2012	2.6400	1.1880	2.0000	1
333	621	11	0	12	Q4	2012	3.9600	1.7424	3.0000	1
333	663	16	1223	6	Q2	2012	5.2800	2.3760	4.0000	1
333	697	13	0	2	Q1	2012	3.9600	1.9404	3.0000	1
333	705	6	0	5	Q2	2012	6.6000	3.1680	5.0000	1
333	753	3	0	1	Q1	2012	5.2800	2.6400	4.0000	1
333	1297	16	0	1	Q1	2012	6.6000	2.5080	5.0000	1
333	1887	11	842	12	Q4	2012	3.9600	1.9008	3.0000	1
333	2043	24	0	5	Q2	2012	2.6400	1.1088	2.0000	1
333	2442	24	0	7	Q3	2012	3.9600	1.4652	3.0000	1
333	2479	13	0	2	Q1	2012	5.2800	2.2176	4.0000	1
333	2648	24	0	2	Q1	2012	3.9600	1.3464	3.0000	1
333	2918	17	1304	7	Q3	2012	3.9600	1.8216	3.0000	1
333	2963	6	0	3	Q1	2012	2.6400	0.9240	2.0000	1
333	3101	11	826	5	Q2	2012	5.2800	2.2176	4.0000	1
333	3139	24	0	9	Q3	2012	6.6000	2.7720	5.0000	1
333	3528	17	0	12	Q4	2012	3.9600	1.1880	3.0000	1
333	3911	7	523	11	Q4	2012	3.9600	1.8612	3.0000	1
333	4320	6	521	10	Q4	2012	6.6000	2.5080	5.0000	1
333	4351	23	1776	6	Q2	2012	5.2800	1.9536	4.0000	1
333	4471	11	820	2	Q1	2012	5.2800	1.7952	4.0000	1
333	4490	13	0	10	Q4	2012	5.2800	1.6368	4.0000	1
333	4498	17	0	8	Q3	2012	2.6400	1.0032	2.0000	1
333	5085	24	1856	6	Q2	2012	5.2800	1.7952	4.0000	1
333	5174	16	0	9	Q3	2012	3.9600	1.7820	3.0000	1
333	5920	6	0	12	Q4	2012	3.9600	1.7820	3.0000	1
333	6021	13	0	11	Q4	2012	3.9600	1.9404	3.0000	1
333	6047	17	0	10	Q4	2012	5.2800	1.6368	4.0000	1
333	6086	7	0	3	Q1	2012	2.6400	1.0824	2.0000	1
333	6105	23	0	6	Q2	2012	5.2800	2.3760	4.0000	1
333	6141	6	0	8	Q3	2012	3.9600	1.9404	3.0000	1
333	6554	17	0	3	Q1	2012	3.9600	1.7820	3.0000	1
333	6766	24	1850	3	Q1	2012	3.9600	1.5444	3.0000	1
333	7014	24	0	12	Q4	2012	3.9600	1.7820	3.0000	1
333	7271	7	0	8	Q3	2012	3.9600	1.9008	3.0000	1
333	7382	22	0	7	Q3	2012	1.3200	0.6468	1.0000	1
333	7915	13	0	6	Q2	2012	3.9600	1.9008	3.0000	1
333	8367	13	0	3	Q1	2012	5.2800	1.6368	4.0000	1
333	8406	6	523	11	Q4	2012	3.9600	1.3068	3.0000	1
333	8464	15	1157	12	Q4	2012	2.6400	1.1880	2.0000	1
333	9051	24	0	11	Q4	2012	5.2800	2.0592	4.0000	1
333	9248	15	0	12	Q4	2012	3.9600	1.8216	3.0000	1
333	9396	13	0	6	Q2	2012	5.2800	2.0592	4.0000	1
333	9428	7	0	5	Q2	2012	3.9600	1.3068	3.0000	1
333	9501	13	0	9	Q3	2012	5.2800	2.5872	4.0000	1
333	9552	7	501	1	Q1	2012	5.2800	1.8480	4.0000	1
333	9643	13	0	11	Q4	2012	5.2800	1.7424	4.0000	1
333	10104	6	0	3	Q1	2012	3.9600	1.7028	3.0000	1
334	93	13	980	3	Q1	2012	3.1200	1.4040	4.0000	1
334	179	6	526	12	Q4	2012	2.3400	1.1700	3.0000	1
334	346	13	0	12	Q4	2012	1.5600	0.7644	2.0000	1
334	624	15	0	3	Q1	2012	1.5600	0.7488	2.0000	1
334	847	15	1154	10	Q4	2012	2.3400	0.8658	3.0000	1
334	970	14	0	2	Q1	2012	1.5600	0.7488	2.0000	1
334	1271	13	0	3	Q1	2012	3.1200	0.9672	4.0000	1
334	1281	3	0	2	Q1	2012	1.5600	0.6084	2.0000	1
334	1312	3	0	5	Q2	2012	2.3400	1.0530	3.0000	1
334	1341	3	201	8	Q3	2012	2.3400	1.1232	3.0000	1
334	1352	17	0	12	Q4	2012	3.1200	1.4040	4.0000	1
334	1548	13	980	3	Q1	2012	2.3400	0.8190	3.0000	1
334	1718	13	0	4	Q2	2012	2.3400	0.9828	3.0000	1
334	1730	11	0	3	Q1	2012	2.3400	1.0530	3.0000	1
334	1971	15	0	10	Q4	2012	3.1200	1.5288	4.0000	1
334	1991	13	0	1	Q1	2012	2.3400	1.0764	3.0000	1
334	2077	23	1781	8	Q3	2012	1.5600	0.6240	2.0000	1
334	2135	22	0	9	Q3	2012	0.7800	0.2652	1.0000	1
334	2270	11	833	8	Q3	2012	3.1200	1.3104	4.0000	1
334	2404	7	504	2	Q1	2012	3.1200	1.1544	4.0000	1
334	2550	24	0	2	Q1	2012	2.3400	1.0296	3.0000	1
334	2656	13	0	10	Q4	2012	3.1200	1.0296	4.0000	1
334	2664	17	0	8	Q3	2012	2.3400	0.8190	3.0000	1
334	2955	7	0	12	Q4	2012	1.5600	0.4836	2.0000	1
334	3213	13	0	4	Q2	2012	3.1200	1.2168	4.0000	1
334	3253	13	0	7	Q3	2012	2.3400	0.7020	3.0000	1
334	3337	6	0	1	Q1	2012	2.3400	0.8892	3.0000	1
334	3709	7	0	10	Q4	2012	2.3400	0.8190	3.0000	1
334	4017	15	1140	4	Q2	2012	2.3400	1.1232	3.0000	1
334	4021	16	0	1	Q1	2012	3.1200	1.1544	4.0000	1
334	4215	15	0	9	Q3	2012	3.9000	1.3650	5.0000	1
334	4261	13	0	11	Q4	2012	2.3400	0.7254	3.0000	1
334	4396	13	0	1	Q1	2012	2.3400	1.1466	3.0000	1
334	4471	11	0	9	Q3	2012	3.1200	1.4352	4.0000	1
334	4739	15	0	6	Q2	2012	3.1200	1.3104	4.0000	1
334	4798	7	0	10	Q4	2012	2.3400	0.8658	3.0000	1
334	4827	6	0	10	Q4	2012	2.3400	0.7722	3.0000	1
334	4868	16	0	6	Q2	2012	1.5600	0.7176	2.0000	1
334	4964	2	0	12	Q4	2012	1.5600	0.6084	2.0000	1
334	5125	17	0	6	Q2	2012	1.5600	0.5616	2.0000	1
334	5337	2	0	7	Q3	2012	1.5600	0.6240	2.0000	1
334	5530	13	0	9	Q3	2012	3.1200	1.3728	4.0000	1
334	5858	11	833	8	Q3	2012	3.1200	0.9984	4.0000	1
334	5973	3	187	2	Q1	2012	3.1200	1.1544	4.0000	1
334	6114	16	0	9	Q3	2012	1.5600	0.6396	2.0000	1
334	6340	14	0	6	Q2	2012	1.5600	0.5148	2.0000	1
334	6403	2	0	3	Q1	2012	1.5600	0.4836	2.0000	1
334	6496	3	210	12	Q4	2012	2.3400	0.7254	3.0000	1
334	6670	6	0	4	Q2	2012	1.5600	0.6396	2.0000	1
334	7310	11	0	6	Q2	2012	3.1200	0.9984	4.0000	1
334	7433	11	837	10	Q4	2012	1.5600	0.7488	2.0000	1
334	7444	13	0	1	Q1	2012	3.1200	1.0296	4.0000	1
334	7650	24	0	10	Q4	2012	1.5600	0.6396	2.0000	1
334	7702	16	0	2	Q1	2012	2.3400	1.0296	3.0000	1
334	7774	15	0	5	Q2	2012	1.5600	0.6864	2.0000	1
334	7849	3	0	3	Q1	2012	1.5600	0.6084	2.0000	1
334	7871	6	519	9	Q3	2012	3.1200	1.2792	4.0000	1
334	7989	17	0	5	Q2	2012	2.3400	0.7488	3.0000	1
334	8189	17	0	11	Q4	2012	2.3400	0.8190	3.0000	1
334	8275	16	0	4	Q2	2012	1.5600	0.6864	2.0000	1
334	8336	17	0	12	Q4	2012	3.1200	1.0296	4.0000	1
334	8919	13	0	11	Q4	2012	3.1200	1.0296	4.0000	1
334	9331	11	842	12	Q4	2012	2.3400	0.8190	3.0000	1
334	9588	6	0	5	Q2	2012	2.3400	0.7722	3.0000	1
334	10142	11	0	11	Q4	2012	1.5600	0.6084	2.0000	1
334	10157	7	0	3	Q1	2012	3.9000	1.2870	5.0000	1
334	10243	17	0	9	Q3	2012	3.1200	1.2168	4.0000	1
335	760	3	0	9	Q3	2012	11.2200	3.9270	3.0000	1
335	863	17	1293	1	Q1	2012	14.9600	7.4800	4.0000	1
335	1192	17	0	4	Q2	2012	11.2200	5.4978	3.0000	1
335	1245	17	0	11	Q4	2012	7.4800	2.8424	2.0000	1
335	1282	3	205	10	Q4	2012	14.9600	6.7320	4.0000	1
335	1332	11	0	11	Q4	2012	11.2200	5.2734	3.0000	1
335	1818	11	826	5	Q2	2012	14.9600	6.5824	4.0000	1
335	1850	16	1235	11	Q4	2012	11.2200	3.8148	3.0000	1
335	2031	15	0	1	Q1	2012	11.2200	4.9368	3.0000	1
335	2053	11	0	6	Q2	2012	18.7000	6.1710	5.0000	1
335	2112	17	0	4	Q2	2012	14.9600	4.4880	4.0000	1
335	2158	11	0	8	Q3	2012	11.2200	3.8148	3.0000	1
335	2390	17	0	4	Q2	2012	11.2200	3.4782	3.0000	1
335	2412	7	0	10	Q4	2012	14.9600	5.3856	4.0000	1
335	2548	13	0	11	Q4	2012	14.9600	7.3304	4.0000	1
335	3211	2	0	1	Q1	2012	3.7400	1.2716	1.0000	1
335	3218	3	0	5	Q2	2012	11.2200	3.5904	3.0000	1
335	3302	13	0	9	Q3	2012	14.9600	6.2832	4.0000	1
335	3337	6	0	4	Q2	2012	14.9600	7.3304	4.0000	1
335	3476	3	0	6	Q2	2012	14.9600	5.0864	4.0000	1
335	3597	7	518	8	Q3	2012	11.2200	4.0392	3.0000	1
335	3728	13	0	11	Q4	2012	14.9600	6.8816	4.0000	1
335	3965	24	0	9	Q3	2012	11.2200	4.9368	3.0000	1
335	4078	3	0	9	Q3	2012	11.2200	5.4978	3.0000	1
335	4193	24	0	5	Q2	2012	11.2200	3.4782	3.0000	1
335	4396	13	0	11	Q4	2012	11.2200	5.4978	3.0000	1
335	4507	13	988	7	Q3	2012	14.9600	4.7872	4.0000	1
335	4527	3	0	6	Q2	2012	14.9600	4.9368	4.0000	1
335	4606	3	0	10	Q4	2012	7.4800	2.9920	2.0000	1
335	4643	22	0	6	Q2	2012	7.4800	3.6652	2.0000	1
335	4676	16	0	5	Q2	2012	11.2200	3.4782	3.0000	1
335	4828	6	523	11	Q4	2012	7.4800	3.2912	2.0000	1
335	5005	14	1058	2	Q1	2012	3.7400	1.4960	1.0000	1
335	5339	11	0	3	Q1	2012	11.2200	5.0490	3.0000	1
335	5502	7	0	6	Q2	2012	14.9600	5.2360	4.0000	1
335	5584	15	1138	3	Q1	2012	7.4800	3.3660	2.0000	1
335	5742	16	0	2	Q1	2012	14.9600	4.6376	4.0000	1
335	6072	7	0	8	Q3	2012	11.2200	5.3856	3.0000	1
335	6712	16	0	3	Q1	2012	7.4800	3.5904	2.0000	1
335	6904	13	0	6	Q2	2012	7.4800	2.7676	2.0000	1
335	6932	13	0	12	Q4	2012	11.2200	4.3758	3.0000	1
335	7268	15	0	11	Q4	2012	11.2200	4.1514	3.0000	1
335	7336	2	118	6	Q2	2012	7.4800	2.6928	2.0000	1
335	7359	13	0	8	Q3	2012	11.2200	3.5904	3.0000	1
335	7822	3	0	12	Q4	2012	11.2200	4.4880	3.0000	1
335	8222	15	0	1	Q1	2012	7.4800	2.2440	2.0000	1
335	8242	17	1307	8	Q3	2012	7.4800	2.9920	2.0000	1
335	8308	17	0	7	Q3	2012	11.2200	4.6002	3.0000	1
335	8841	13	980	3	Q1	2012	11.2200	4.9368	3.0000	1
335	8944	14	0	3	Q1	2012	3.7400	1.5334	1.0000	1
335	9156	6	522	10	Q4	2012	11.2200	5.0490	3.0000	1
335	9487	17	0	12	Q4	2012	11.2200	5.3856	3.0000	1
335	9488	24	0	5	Q2	2012	11.2200	5.6100	3.0000	1
335	9504	13	980	3	Q1	2012	11.2200	4.2636	3.0000	1
335	9631	16	0	7	Q3	2012	14.9600	5.2360	4.0000	1
336	20	24	1856	6	Q2	2012	2.3000	1.1040	2.0000	1
336	39	13	0	11	Q4	2012	3.4500	1.7250	3.0000	1
336	181	3	0	4	Q2	2012	2.3000	1.1040	2.0000	1
336	236	11	821	2	Q1	2012	4.6000	1.9780	4.0000	1
336	308	14	0	5	Q2	2012	3.4500	1.3800	3.0000	1
336	407	15	0	6	Q2	2012	3.4500	1.6905	3.0000	1
336	454	17	0	2	Q1	2012	3.4500	1.0350	3.0000	1
336	733	24	1851	4	Q2	2012	3.4500	1.6560	3.0000	1
336	739	23	1778	7	Q3	2012	4.6000	2.1620	4.0000	1
336	1289	23	0	8	Q3	2012	2.3000	0.7590	2.0000	1
336	1298	17	0	10	Q4	2012	2.3000	0.7360	2.0000	1
336	1671	24	0	3	Q1	2012	2.3000	0.8970	2.0000	1
336	2258	11	0	8	Q3	2012	3.4500	1.4835	3.0000	1
336	2280	13	0	7	Q3	2012	2.3000	0.9200	2.0000	1
336	2304	13	0	5	Q2	2012	3.4500	1.5525	3.0000	1
336	2588	23	0	3	Q1	2012	3.4500	1.4835	3.0000	1
336	2709	7	516	8	Q3	2012	3.4500	1.0695	3.0000	1
336	2846	11	829	6	Q2	2012	3.4500	1.1040	3.0000	1
336	2850	3	0	4	Q2	2012	2.3000	0.7130	2.0000	1
336	3201	11	0	2	Q1	2012	3.4500	1.0695	3.0000	1
336	3401	11	0	4	Q2	2012	2.3000	0.8510	2.0000	1
336	4041	24	0	10	Q4	2012	4.6000	1.9320	4.0000	1
336	4149	11	0	10	Q4	2012	3.4500	1.4835	3.0000	1
336	4234	3	0	5	Q2	2012	4.6000	1.4720	4.0000	1
336	4240	24	0	8	Q3	2012	3.4500	1.5525	3.0000	1
336	4425	13	0	2	Q1	2012	3.4500	1.2075	3.0000	1
336	4460	3	0	5	Q2	2012	3.4500	1.1730	3.0000	1
336	4498	17	0	10	Q4	2012	3.4500	1.6560	3.0000	1
336	4691	17	0	5	Q2	2012	3.4500	1.1385	3.0000	1
336	4727	16	0	9	Q3	2012	2.3000	0.8740	2.0000	1
336	4810	23	0	5	Q2	2012	3.4500	1.4835	3.0000	1
336	4810	23	0	12	Q4	2012	3.4500	1.1385	3.0000	1
336	4974	7	512	6	Q2	2012	2.3000	1.0120	2.0000	1
336	4974	7	523	11	Q4	2012	2.3000	1.0120	2.0000	1
336	5492	15	0	10	Q4	2012	3.4500	1.1385	3.0000	1
336	5590	17	0	5	Q2	2012	4.6000	2.3000	4.0000	1
336	5686	3	0	12	Q4	2012	3.4500	1.3455	3.0000	1
336	5905	15	1149	8	Q3	2012	3.4500	1.4835	3.0000	1
336	6082	13	0	3	Q1	2012	4.6000	2.0240	4.0000	1
336	6124	7	0	8	Q3	2012	4.6000	2.2540	4.0000	1
336	6218	11	836	9	Q3	2012	4.6000	1.9320	4.0000	1
336	6372	17	0	10	Q4	2012	3.4500	1.3110	3.0000	1
336	6400	6	508	4	Q2	2012	3.4500	1.4145	3.0000	1
336	6696	6	0	5	Q2	2012	5.7500	2.5875	5.0000	1
336	7051	16	0	6	Q2	2012	3.4500	1.0695	3.0000	1
336	7056	3	0	5	Q2	2012	2.3000	1.0350	2.0000	1
336	7299	7	521	10	Q4	2012	3.4500	1.3110	3.0000	1
336	7386	7	0	3	Q1	2012	3.4500	1.6905	3.0000	1
336	7547	24	0	3	Q1	2012	2.3000	1.0350	2.0000	1
336	7573	3	0	2	Q1	2012	3.4500	1.7250	3.0000	1
336	7589	17	1307	8	Q3	2012	4.6000	1.5180	4.0000	1
336	7639	13	0	7	Q3	2012	3.4500	1.3110	3.0000	1
336	7792	15	0	1	Q1	2012	2.3000	1.0120	2.0000	1
336	7849	3	0	9	Q3	2012	4.6000	2.2080	4.0000	1
336	7883	15	0	8	Q3	2012	4.6000	2.3000	4.0000	1
336	7909	3	0	9	Q3	2012	2.3000	0.8280	2.0000	1
336	7951	15	0	8	Q3	2012	3.4500	1.6215	3.0000	1
336	8068	3	0	11	Q4	2012	4.6000	2.0700	4.0000	1
336	8139	11	0	7	Q3	2012	4.6000	2.3000	4.0000	1
336	8427	16	0	3	Q1	2012	3.4500	1.3110	3.0000	1
336	8556	11	826	5	Q2	2012	3.4500	1.4145	3.0000	1
336	8617	17	1304	7	Q3	2012	3.4500	1.1730	3.0000	1
336	8633	24	1860	8	Q3	2012	3.4500	1.1040	3.0000	1
336	8699	7	0	12	Q4	2012	3.4500	1.6560	3.0000	1
336	9327	17	0	1	Q1	2012	2.3000	1.0350	2.0000	1
336	9863	13	0	9	Q3	2012	2.3000	0.9890	2.0000	1
336	10118	13	0	9	Q3	2012	3.4500	1.1040	3.0000	1
336	10248	15	0	4	Q2	2012	4.6000	1.9320	4.0000	1
337	392	13	0	6	Q2	2012	1.5000	0.7200	2.0000	1
337	740	11	0	6	Q2	2012	3.0000	1.0500	4.0000	1
337	893	13	0	9	Q3	2012	2.2500	0.7200	3.0000	1
337	1445	15	1140	4	Q2	2012	2.2500	0.9225	3.0000	1
337	1706	13	980	3	Q1	2012	3.0000	1.2600	4.0000	1
337	1736	13	982	4	Q2	2012	2.2500	0.9450	3.0000	1
337	1744	17	1292	1	Q1	2012	1.5000	0.6150	2.0000	1
337	1785	3	0	7	Q3	2012	2.2500	0.9675	3.0000	1
337	1798	3	204	9	Q3	2012	3.0000	1.2600	4.0000	1
337	2061	3	0	6	Q2	2012	3.0000	0.9300	4.0000	1
337	2084	17	0	6	Q2	2012	3.0000	0.9900	4.0000	1
337	2211	17	1303	6	Q2	2012	3.0000	1.1400	4.0000	1
337	2371	16	1235	11	Q4	2012	3.0000	0.9600	4.0000	1
337	2437	3	0	12	Q4	2012	1.5000	0.5400	2.0000	1
337	2482	13	0	2	Q1	2012	3.0000	1.3500	4.0000	1
337	2776	22	1709	11	Q4	2012	1.5000	0.7200	2.0000	1
337	2829	23	1789	12	Q4	2012	2.2500	0.9900	3.0000	1
337	2896	3	0	9	Q3	2012	2.2500	0.6975	3.0000	1
337	2942	17	1312	10	Q4	2012	3.0000	1.1400	4.0000	1
337	3097	7	0	11	Q4	2012	3.0000	0.9600	4.0000	1
337	3101	11	0	4	Q2	2012	1.5000	0.6450	2.0000	1
337	3297	6	0	12	Q4	2012	1.5000	0.4500	2.0000	1
337	3386	24	1845	1	Q1	2012	2.2500	0.7200	3.0000	1
337	3609	24	1853	5	Q2	2012	2.2500	0.7875	3.0000	1
337	3742	11	0	2	Q1	2012	2.2500	0.9900	3.0000	1
337	4021	16	1235	11	Q4	2012	3.0000	1.1100	4.0000	1
337	4162	6	0	8	Q3	2012	1.5000	0.5850	2.0000	1
337	4194	24	1866	11	Q4	2012	2.2500	0.8550	3.0000	1
337	4204	17	1307	8	Q3	2012	3.0000	1.0500	4.0000	1
337	4268	11	0	1	Q1	2012	2.2500	0.8325	3.0000	1
337	4315	17	0	3	Q1	2012	1.5000	0.4500	2.0000	1
337	4342	13	0	1	Q1	2012	2.2500	0.6975	3.0000	1
337	4391	16	1235	11	Q4	2012	3.0000	1.0200	4.0000	1
337	4445	17	0	12	Q4	2012	2.2500	0.9900	3.0000	1
337	4498	17	0	1	Q1	2012	2.2500	1.0800	3.0000	1
337	4499	13	0	2	Q1	2012	2.2500	0.9900	3.0000	1
337	4958	23	0	10	Q4	2012	3.0000	0.9000	4.0000	1
337	4985	23	1771	3	Q1	2012	3.0000	1.3200	4.0000	1
337	5109	15	0	10	Q4	2012	3.0000	0.9300	4.0000	1
337	5194	15	0	10	Q4	2012	1.5000	0.5400	2.0000	1
337	5206	13	0	11	Q4	2012	3.0000	1.3500	4.0000	1
337	5362	24	0	7	Q3	2012	2.2500	1.0350	3.0000	1
337	5447	11	0	11	Q4	2012	2.2500	1.1025	3.0000	1
337	5447	11	841	12	Q4	2012	1.5000	0.7350	2.0000	1
337	5829	22	0	1	Q1	2012	2.2500	1.0350	3.0000	1
337	5846	11	829	6	Q2	2012	3.0000	1.1100	4.0000	1
337	5877	17	0	12	Q4	2012	1.5000	0.6900	2.0000	1
337	6113	16	0	3	Q1	2012	1.5000	0.5400	2.0000	1
337	6280	2	0	1	Q1	2012	1.5000	0.5100	2.0000	1
337	6307	16	1220	4	Q2	2012	3.7500	1.5750	5.0000	1
337	6452	11	0	10	Q4	2012	2.2500	0.7200	3.0000	1
337	6647	17	0	7	Q3	2012	2.2500	1.0800	3.0000	1
337	6880	15	0	11	Q4	2012	3.7500	1.8375	5.0000	1
337	7137	11	826	5	Q2	2012	2.2500	0.9225	3.0000	1
337	7209	11	842	12	Q4	2012	2.2500	0.9900	3.0000	1
337	7354	3	0	1	Q1	2012	2.2500	0.9000	3.0000	1
337	7362	11	826	5	Q2	2012	2.2500	0.6975	3.0000	1
337	7366	3	0	6	Q2	2012	2.2500	0.9675	3.0000	1
337	7457	13	0	2	Q1	2012	2.2500	0.7875	3.0000	1
337	7556	17	0	11	Q4	2012	3.0000	1.3200	4.0000	1
337	7683	22	0	2	Q1	2012	0.7500	0.2925	1.0000	1
337	7813	17	0	9	Q3	2012	1.5000	0.7350	2.0000	1
337	7831	17	0	1	Q1	2012	3.0000	0.9900	4.0000	1
337	8068	3	0	1	Q1	2012	1.5000	0.6000	2.0000	1
337	8275	16	0	11	Q4	2012	1.5000	0.4650	2.0000	1
337	8336	17	1303	6	Q2	2012	1.5000	0.6000	2.0000	1
337	9075	7	0	6	Q2	2012	3.0000	1.3500	4.0000	1
337	9323	15	0	10	Q4	2012	1.5000	0.5250	2.0000	1
337	9728	16	0	8	Q3	2012	2.2500	0.8100	3.0000	1
337	9998	7	526	12	Q4	2012	1.5000	0.5550	2.0000	1
337	10118	13	0	2	Q1	2012	2.2500	0.7200	3.0000	1
338	335	17	0	9	Q3	2012	1.1400	0.5472	2.0000	1
338	471	24	0	8	Q3	2012	2.2800	0.8664	4.0000	1
338	769	16	0	12	Q4	2012	1.7100	0.5301	3.0000	1
338	863	17	1292	1	Q1	2012	2.2800	0.7752	4.0000	1
338	1083	11	842	12	Q4	2012	2.2800	0.9804	4.0000	1
338	1195	11	0	12	Q4	2012	2.2800	0.9576	4.0000	1
338	1430	3	0	8	Q3	2012	1.7100	0.8208	3.0000	1
338	1468	13	0	7	Q3	2012	2.2800	1.0944	4.0000	1
338	1580	15	0	11	Q4	2012	1.7100	0.7011	3.0000	1
338	1580	15	1141	4	Q2	2012	2.2800	1.0488	4.0000	1
338	1682	13	0	10	Q4	2012	1.7100	0.5472	3.0000	1
338	1718	13	0	7	Q3	2012	2.2800	0.9576	4.0000	1
338	1772	15	0	4	Q2	2012	1.7100	0.5643	3.0000	1
338	1802	23	1788	11	Q4	2012	1.7100	0.7524	3.0000	1
338	2382	15	1146	7	Q3	2012	2.8500	1.3965	5.0000	1
338	2553	16	0	12	Q4	2012	2.2800	0.7752	4.0000	1
338	2553	16	1216	2	Q1	2012	1.7100	0.7182	3.0000	1
338	2689	3	0	8	Q3	2012	1.7100	0.6840	3.0000	1
338	2829	23	1783	9	Q3	2012	1.7100	0.7182	3.0000	1
338	2856	13	0	1	Q1	2012	1.1400	0.5016	2.0000	1
338	2887	14	0	7	Q3	2012	0.5700	0.2850	1.0000	1
338	2888	24	1866	11	Q4	2012	1.7100	0.7353	3.0000	1
338	3020	13	0	12	Q4	2012	1.7100	0.7353	3.0000	1
338	3160	17	0	9	Q3	2012	1.1400	0.4332	2.0000	1
338	3414	6	0	6	Q2	2012	1.1400	0.3534	2.0000	1
338	3645	2	0	7	Q3	2012	0.5700	0.2280	1.0000	1
338	3738	7	526	12	Q4	2012	2.8500	0.8550	5.0000	1
338	3873	11	0	7	Q3	2012	1.1400	0.4902	2.0000	1
338	3965	24	0	8	Q3	2012	1.1400	0.4446	2.0000	1
338	4227	24	0	3	Q1	2012	2.2800	0.7296	4.0000	1
338	4803	23	0	3	Q1	2012	2.2800	1.0260	4.0000	1
338	5074	15	1149	8	Q3	2012	2.2800	0.8436	4.0000	1
338	5423	11	0	5	Q2	2012	1.7100	0.7524	3.0000	1
338	5616	17	0	9	Q3	2012	2.2800	0.8436	4.0000	1
338	5821	15	1142	5	Q2	2012	1.1400	0.3762	2.0000	1
338	5973	3	0	3	Q1	2012	1.7100	0.7182	3.0000	1
338	6149	2	0	10	Q4	2012	1.1400	0.4332	2.0000	1
338	6184	6	0	9	Q3	2012	1.1400	0.4218	2.0000	1
338	6351	11	0	6	Q2	2012	1.7100	0.5643	3.0000	1
338	7133	22	0	5	Q2	2012	0.5700	0.2394	1.0000	1
338	7589	17	0	2	Q1	2012	1.7100	0.5643	3.0000	1
338	7743	3	0	12	Q4	2012	2.2800	1.0944	4.0000	1
338	7747	6	504	2	Q1	2012	2.2800	0.7524	4.0000	1
338	7899	7	0	1	Q1	2012	1.1400	0.5130	2.0000	1
338	8472	17	1304	7	Q3	2012	1.7100	0.5643	3.0000	1
338	8901	13	0	1	Q1	2012	1.7100	0.5814	3.0000	1
338	8947	3	207	11	Q4	2012	2.2800	1.0488	4.0000	1
338	9110	15	1138	3	Q1	2012	2.2800	0.8436	4.0000	1
338	9309	17	1304	7	Q3	2012	1.1400	0.3762	2.0000	1
338	9318	16	0	6	Q2	2012	1.7100	0.5472	3.0000	1
338	10079	24	0	2	Q1	2012	1.7100	0.7695	3.0000	1
338	10191	24	1869	12	Q4	2012	2.2800	1.0260	4.0000	1
338	10274	7	0	5	Q2	2012	1.1400	0.3648	2.0000	1
339	502	15	0	3	Q1	2012	4.2000	1.3020	3.0000	1
339	769	16	1214	2	Q1	2012	5.6000	2.5200	4.0000	1
339	1006	14	1072	9	Q3	2012	2.8000	1.3440	2.0000	1
339	1409	24	0	6	Q2	2012	5.6000	2.5760	4.0000	1
339	1481	15	0	9	Q3	2012	4.2000	2.0580	3.0000	1
339	1622	3	185	1	Q1	2012	5.6000	1.7360	4.0000	1
339	1633	3	190	3	Q1	2012	4.2000	1.6380	3.0000	1
339	1714	6	508	4	Q2	2012	7.0000	2.9400	5.0000	1
339	1850	16	1235	11	Q4	2012	4.2000	1.5540	3.0000	1
339	1874	17	0	5	Q2	2012	2.8000	1.1760	2.0000	1
339	1977	23	0	12	Q4	2012	5.6000	2.5200	4.0000	1
339	2086	13	0	10	Q4	2012	5.6000	1.6800	4.0000	1
339	2158	11	0	8	Q3	2012	4.2000	1.5540	3.0000	1
339	2823	24	1850	3	Q1	2012	4.2000	1.8480	3.0000	1
339	2988	15	0	10	Q4	2012	4.2000	1.7640	3.0000	1
339	3069	15	1141	4	Q2	2012	2.8000	0.9240	2.0000	1
339	3350	11	829	6	Q2	2012	4.2000	1.3020	3.0000	1
339	3460	11	0	5	Q2	2012	5.6000	2.6880	4.0000	1
339	3476	3	0	6	Q2	2012	4.2000	1.5540	3.0000	1
339	3652	7	504	2	Q1	2012	4.2000	1.8480	3.0000	1
339	3711	3	0	1	Q1	2012	4.2000	1.8900	3.0000	1
339	3711	3	0	8	Q3	2012	4.2000	1.8900	3.0000	1
339	4007	15	0	10	Q4	2012	5.6000	2.5200	4.0000	1
339	4066	3	0	7	Q3	2012	5.6000	2.0720	4.0000	1
339	4503	13	0	8	Q3	2012	2.8000	0.8680	2.0000	1
339	4666	13	0	12	Q4	2012	5.6000	1.7920	4.0000	1
339	4676	16	1236	12	Q4	2012	5.6000	2.3520	4.0000	1
339	5000	11	826	5	Q2	2012	4.2000	1.8900	3.0000	1
339	5298	6	0	7	Q3	2012	2.8000	1.1200	2.0000	1
339	5470	2	0	12	Q4	2012	2.8000	1.2600	2.0000	1
339	5610	13	980	3	Q1	2012	2.8000	1.3160	2.0000	1
339	5742	16	0	2	Q1	2012	4.2000	2.1000	3.0000	1
339	5929	15	0	3	Q1	2012	4.2000	1.8900	3.0000	1
339	6161	17	0	2	Q1	2012	4.2000	1.7220	3.0000	1
339	6683	17	0	8	Q3	2012	5.6000	2.6880	4.0000	1
339	6690	17	0	5	Q2	2012	4.2000	1.9320	3.0000	1
339	6805	7	518	8	Q3	2012	4.2000	1.4280	3.0000	1
339	6844	11	829	6	Q2	2012	2.8000	0.9520	2.0000	1
339	6997	13	0	1	Q1	2012	4.2000	1.6380	3.0000	1
339	7059	17	0	12	Q4	2012	5.6000	2.1280	4.0000	1
339	7132	13	980	3	Q1	2012	4.2000	1.8900	3.0000	1
339	7189	13	0	3	Q1	2012	4.2000	1.8900	3.0000	1
339	7215	11	841	12	Q4	2012	5.6000	2.8000	4.0000	1
339	7269	13	0	3	Q1	2012	5.6000	2.6880	4.0000	1
339	7669	11	0	4	Q2	2012	4.2000	1.5120	3.0000	1
339	7906	13	0	7	Q3	2012	4.2000	1.4700	3.0000	1
339	7943	14	0	11	Q4	2012	2.8000	0.9240	2.0000	1
339	8022	15	1140	4	Q2	2012	4.2000	1.2600	3.0000	1
339	8059	17	0	7	Q3	2012	4.2000	1.3860	3.0000	1
339	8414	17	1312	10	Q4	2012	4.2000	1.7640	3.0000	1
339	8526	11	0	4	Q2	2012	4.2000	1.3020	3.0000	1
339	9045	24	0	1	Q1	2012	4.2000	1.3020	3.0000	1
339	9184	3	0	10	Q4	2012	4.2000	1.8480	3.0000	1
339	9224	17	0	9	Q3	2012	4.2000	1.5540	3.0000	1
339	9397	11	0	12	Q4	2012	5.6000	2.0160	4.0000	1
339	9501	13	0	7	Q3	2012	7.0000	3.4300	5.0000	1
339	9795	11	0	2	Q1	2012	4.2000	2.0160	3.0000	1
339	9851	3	187	2	Q1	2012	4.2000	1.7640	3.0000	1
340	39	13	0	5	Q2	2012	3.1500	1.1655	5.0000	1
340	40	14	1061	4	Q2	2012	1.2600	0.4410	2.0000	1
340	152	15	1136	2	Q1	2012	1.8900	0.8316	3.0000	1
340	753	3	185	1	Q1	2012	1.8900	0.7938	3.0000	1
340	819	13	0	7	Q3	2012	1.2600	0.4788	2.0000	1
340	988	15	0	12	Q4	2012	1.8900	0.7560	3.0000	1
340	1187	13	0	11	Q4	2012	1.8900	0.7749	3.0000	1
340	1658	15	0	10	Q4	2012	1.2600	0.5922	2.0000	1
340	1977	23	0	9	Q3	2012	1.2600	0.4158	2.0000	1
340	2052	13	0	9	Q3	2012	2.5200	0.9576	4.0000	1
340	2201	16	0	4	Q2	2012	1.8900	0.8694	3.0000	1
340	2201	16	0	9	Q3	2012	1.8900	0.8505	3.0000	1
340	2232	6	0	3	Q1	2012	1.2600	0.6300	2.0000	1
340	2431	3	0	8	Q3	2012	1.2600	0.5040	2.0000	1
340	2635	15	0	5	Q2	2012	1.2600	0.4788	2.0000	1
340	3001	13	0	1	Q1	2012	1.8900	0.6426	3.0000	1
340	3473	15	0	9	Q3	2012	2.5200	0.8820	4.0000	1
340	3976	17	0	11	Q4	2012	1.8900	0.9072	3.0000	1
340	3981	7	0	3	Q1	2012	1.8900	0.8694	3.0000	1
340	4085	24	0	11	Q4	2012	1.2600	0.6300	2.0000	1
340	4239	17	0	12	Q4	2012	2.5200	0.8820	4.0000	1
340	4659	13	0	7	Q3	2012	2.5200	0.8064	4.0000	1
340	4691	17	0	5	Q2	2012	1.8900	0.8505	3.0000	1
340	4803	23	0	9	Q3	2012	2.5200	1.0332	4.0000	1
340	4810	23	0	5	Q2	2012	1.8900	0.7560	3.0000	1
340	4810	23	0	12	Q4	2012	1.8900	0.8316	3.0000	1
340	4841	15	0	8	Q3	2012	1.8900	0.8316	3.0000	1
340	4873	17	0	4	Q2	2012	1.2600	0.4284	2.0000	1
340	4903	3	0	12	Q4	2012	1.8900	0.6426	3.0000	1
340	4934	24	0	3	Q1	2012	1.8900	0.7560	3.0000	1
340	4949	15	1150	8	Q3	2012	2.5200	1.1844	4.0000	1
340	5052	14	0	5	Q2	2012	0.6300	0.2394	1.0000	1
340	5379	17	0	10	Q4	2012	2.5200	1.0332	4.0000	1
340	5484	6	521	10	Q4	2012	2.5200	0.9828	4.0000	1
340	5865	15	1146	7	Q3	2012	1.2600	0.6300	2.0000	1
340	6113	16	1225	7	Q3	2012	1.2600	0.4536	2.0000	1
340	6306	13	0	1	Q1	2012	1.2600	0.4032	2.0000	1
340	6665	6	502	1	Q1	2012	1.8900	0.5859	3.0000	1
340	6686	13	0	10	Q4	2012	1.2600	0.4158	2.0000	1
340	6754	7	512	6	Q2	2012	1.8900	0.7560	3.0000	1
340	6860	7	0	9	Q3	2012	1.8900	0.6993	3.0000	1
340	7138	11	0	5	Q2	2012	1.8900	0.7938	3.0000	1
340	7262	13	0	12	Q4	2012	1.8900	0.9450	3.0000	1
340	7269	13	0	7	Q3	2012	2.5200	1.2096	4.0000	1
340	7306	6	0	3	Q1	2012	2.5200	0.9324	4.0000	1
340	7434	11	0	12	Q4	2012	2.5200	1.2600	4.0000	1
340	7618	11	826	5	Q2	2012	2.5200	0.7560	4.0000	1
340	7813	17	0	10	Q4	2012	1.8900	0.6237	3.0000	1
340	7818	11	0	3	Q1	2012	1.8900	0.7371	3.0000	1
340	7968	15	0	3	Q1	2012	1.8900	0.9261	3.0000	1
340	8175	15	0	1	Q1	2012	1.8900	0.6615	3.0000	1
340	8202	3	0	12	Q4	2012	1.2600	0.5670	2.0000	1
340	8742	3	188	2	Q1	2012	1.8900	0.7182	3.0000	1
340	8878	2	108	1	Q1	2012	0.6300	0.2079	1.0000	1
340	9169	23	1765	1	Q1	2012	2.5200	1.0836	4.0000	1
340	9325	11	821	2	Q1	2012	1.8900	0.7371	3.0000	1
340	9638	11	0	9	Q3	2012	1.8900	0.8883	3.0000	1
340	9815	16	0	7	Q3	2012	3.1500	1.4805	5.0000	1
340	10240	3	0	12	Q4	2012	1.2600	0.5292	2.0000	1
341	192	16	1233	10	Q4	2012	5.5400	2.3268	2.0000	1
341	304	13	0	11	Q4	2012	8.3100	3.5733	3.0000	1
341	504	13	992	9	Q3	2012	5.5400	2.2160	2.0000	1
341	887	14	0	6	Q2	2012	5.5400	1.9944	2.0000	1
341	939	7	0	4	Q2	2012	11.0800	4.8752	4.0000	1
341	1255	6	0	6	Q2	2012	8.3100	3.9888	3.0000	1
341	1328	17	0	12	Q4	2012	5.5400	1.9390	2.0000	1
341	1587	11	0	1	Q1	2012	5.5400	1.7174	2.0000	1
341	1615	17	1304	7	Q3	2012	8.3100	3.7395	3.0000	1
341	1634	3	187	2	Q1	2012	5.5400	1.7174	2.0000	1
341	1669	11	837	10	Q4	2012	8.3100	2.6592	3.0000	1
341	1718	13	0	8	Q3	2012	5.5400	2.7146	2.0000	1
341	2061	3	0	6	Q2	2012	8.3100	4.1550	3.0000	1
341	2171	23	0	3	Q1	2012	8.3100	3.8226	3.0000	1
341	2228	15	0	9	Q3	2012	11.0800	4.3212	4.0000	1
341	2378	16	0	3	Q1	2012	5.5400	2.3268	2.0000	1
341	2396	7	505	2	Q1	2012	11.0800	5.4292	4.0000	1
341	2587	16	0	1	Q1	2012	11.0800	4.2104	4.0000	1
341	2587	16	0	9	Q3	2012	8.3100	4.0719	3.0000	1
341	2688	6	0	10	Q4	2012	5.5400	2.1052	2.0000	1
341	2924	3	185	1	Q1	2012	8.3100	3.6564	3.0000	1
341	3046	13	0	9	Q3	2012	8.3100	3.3240	3.0000	1
341	3196	13	988	7	Q3	2012	8.3100	3.2409	3.0000	1
341	3389	7	505	2	Q1	2012	5.5400	2.2160	2.0000	1
341	3476	3	0	12	Q4	2012	13.8500	5.2630	5.0000	1
341	3538	11	0	1	Q1	2012	8.3100	3.8226	3.0000	1
341	3693	3	0	5	Q2	2012	11.0800	5.4292	4.0000	1
341	3706	13	0	7	Q3	2012	5.5400	2.6038	2.0000	1
341	3935	24	0	11	Q4	2012	8.3100	2.5761	3.0000	1
341	3977	13	0	5	Q2	2012	8.3100	2.5761	3.0000	1
341	4543	13	984	5	Q2	2012	8.3100	2.7423	3.0000	1
341	4643	22	0	6	Q2	2012	5.5400	2.0498	2.0000	1
341	4645	2	121	8	Q3	2012	2.7700	1.3296	1.0000	1
341	4873	17	1314	11	Q4	2012	5.5400	1.7174	2.0000	1
341	5095	6	0	7	Q3	2012	5.5400	2.1606	2.0000	1
341	5109	15	0	10	Q4	2012	8.3100	4.1550	3.0000	1
341	5204	23	1786	10	Q4	2012	8.3100	3.7395	3.0000	1
341	5643	15	0	10	Q4	2012	8.3100	2.8254	3.0000	1
341	5686	3	0	6	Q2	2012	11.0800	4.3212	4.0000	1
341	6060	11	842	12	Q4	2012	11.0800	3.6564	4.0000	1
341	6452	11	0	9	Q3	2012	11.0800	4.5428	4.0000	1
341	6933	15	0	5	Q2	2012	8.3100	2.7423	3.0000	1
341	7100	17	0	12	Q4	2012	5.5400	1.7174	2.0000	1
341	7319	13	0	6	Q2	2012	8.3100	3.7395	3.0000	1
341	7319	13	976	1	Q1	2012	8.3100	3.6564	3.0000	1
341	7486	3	0	3	Q1	2012	8.3100	3.2409	3.0000	1
341	7780	13	0	1	Q1	2012	8.3100	3.1578	3.0000	1
341	7831	17	0	9	Q3	2012	8.3100	4.0719	3.0000	1
341	8946	23	1773	4	Q2	2012	8.3100	3.8226	3.0000	1
341	8975	15	0	1	Q1	2012	8.3100	3.6564	3.0000	1
341	9077	15	0	9	Q3	2012	5.5400	1.7174	2.0000	1
341	9279	6	523	11	Q4	2012	5.5400	2.4376	2.0000	1
341	9299	24	0	6	Q2	2012	8.3100	2.7423	3.0000	1
341	9318	16	1233	10	Q4	2012	8.3100	2.7423	3.0000	1
341	9667	23	0	10	Q4	2012	8.3100	2.5761	3.0000	1
341	9673	13	988	7	Q3	2012	8.3100	2.8254	3.0000	1
341	9898	15	0	1	Q1	2012	8.3100	2.7423	3.0000	1
341	10118	13	0	2	Q1	2012	8.3100	2.5761	3.0000	1
341	10118	13	0	9	Q3	2012	8.3100	4.1550	3.0000	1
341	10140	17	0	3	Q1	2012	5.5400	2.4930	2.0000	1
341	10169	11	0	11	Q4	2012	11.0800	4.3212	4.0000	1
342	77	7	0	9	Q3	2012	4.5000	1.4850	3.0000	1
342	187	13	976	1	Q1	2012	4.5000	2.0250	3.0000	1
342	532	13	0	8	Q3	2012	4.5000	1.9800	3.0000	1
342	591	11	0	4	Q2	2012	4.5000	1.5300	3.0000	1
342	709	7	0	11	Q4	2012	3.0000	1.0800	2.0000	1
342	769	16	1216	2	Q1	2012	3.0000	1.5000	2.0000	1
342	907	6	0	7	Q3	2012	4.5000	1.8000	3.0000	1
342	922	7	0	7	Q3	2012	4.5000	1.7550	3.0000	1
342	1074	13	1000	12	Q4	2012	4.5000	1.4400	3.0000	1
342	1195	11	0	12	Q4	2012	6.0000	1.8600	4.0000	1
342	1282	3	185	1	Q1	2012	6.0000	2.7000	4.0000	1
342	1430	3	0	7	Q3	2012	4.5000	1.6200	3.0000	1
342	1457	24	0	8	Q3	2012	4.5000	2.2050	3.0000	1
342	1622	3	197	6	Q2	2012	4.5000	1.4850	3.0000	1
342	1785	3	0	9	Q3	2012	6.0000	2.1000	4.0000	1
342	2459	15	1152	9	Q3	2012	6.0000	1.9200	4.0000	1
342	2656	13	0	5	Q2	2012	4.5000	1.5750	3.0000	1
342	2850	3	0	8	Q3	2012	3.0000	1.2900	2.0000	1
342	2905	3	0	3	Q1	2012	4.5000	2.1150	3.0000	1
342	2947	17	1312	10	Q4	2012	4.5000	1.7100	3.0000	1
342	2963	7	0	5	Q2	2012	4.5000	1.4400	3.0000	1
342	3127	7	517	8	Q3	2012	6.0000	1.8600	4.0000	1
342	3691	17	1314	11	Q4	2012	3.0000	0.9000	2.0000	1
342	4021	16	0	6	Q2	2012	6.0000	1.9200	4.0000	1
342	4564	17	0	3	Q1	2012	3.0000	0.9900	2.0000	1
342	4564	17	1307	8	Q3	2012	6.0000	2.7000	4.0000	1
342	4567	23	0	8	Q3	2012	3.0000	1.1400	2.0000	1
342	4691	17	0	5	Q2	2012	4.5000	2.0250	3.0000	1
342	4767	16	0	8	Q3	2012	6.0000	2.3400	4.0000	1
342	5432	16	0	7	Q3	2012	6.0000	2.4000	4.0000	1
342	5653	11	833	8	Q3	2012	6.0000	1.8600	4.0000	1
342	5742	16	0	11	Q4	2012	4.5000	2.2500	3.0000	1
342	6180	13	976	1	Q1	2012	6.0000	2.7600	4.0000	1
342	6291	3	0	4	Q2	2012	6.0000	1.9800	4.0000	1
342	6295	24	1859	8	Q3	2012	4.5000	1.3950	3.0000	1
342	6517	7	0	9	Q3	2012	6.0000	1.8600	4.0000	1
342	6616	11	820	2	Q1	2012	3.0000	1.2300	2.0000	1
342	6842	24	1851	4	Q2	2012	3.0000	0.9000	2.0000	1
342	6966	24	0	9	Q3	2012	6.0000	1.8600	4.0000	1
342	7056	3	0	2	Q1	2012	4.5000	2.0700	3.0000	1
342	7077	24	1856	6	Q2	2012	3.0000	1.1100	2.0000	1
342	7131	11	0	7	Q3	2012	6.0000	2.7600	4.0000	1
342	7179	11	0	1	Q1	2012	4.5000	1.8450	3.0000	1
342	7416	13	980	3	Q1	2012	6.0000	1.8600	4.0000	1
342	7715	13	0	3	Q1	2012	7.5000	2.7750	5.0000	1
342	7884	11	0	12	Q4	2012	4.5000	1.9800	3.0000	1
342	8110	13	0	1	Q1	2012	6.0000	2.1000	4.0000	1
342	8252	13	0	1	Q1	2012	6.0000	2.3400	4.0000	1
342	8954	7	0	4	Q2	2012	4.5000	1.8000	3.0000	1
342	9309	17	0	12	Q4	2012	4.5000	2.1600	3.0000	1
342	9325	11	841	12	Q4	2012	4.5000	1.7550	3.0000	1
342	9745	17	0	5	Q2	2012	4.5000	2.1600	3.0000	1
343	148	15	1134	1	Q1	2012	6.9000	2.1390	3.0000	1
343	198	24	0	9	Q3	2012	4.6000	1.7480	2.0000	1
343	213	7	0	8	Q3	2012	4.6000	2.2080	2.0000	1
343	328	11	0	3	Q1	2012	4.6000	1.7940	2.0000	1
343	921	23	0	6	Q2	2012	9.2000	3.6800	4.0000	1
343	1310	16	1231	9	Q3	2012	9.2000	3.2200	4.0000	1
343	1378	11	821	3	Q1	2012	4.6000	1.7480	2.0000	1
343	1389	6	524	11	Q4	2012	9.2000	4.0480	4.0000	1
343	1430	3	0	10	Q4	2012	6.9000	3.3120	3.0000	1
343	1626	13	980	3	Q1	2012	9.2000	4.6000	4.0000	1
343	1720	16	0	3	Q1	2012	9.2000	2.8520	4.0000	1
343	2218	7	504	2	Q1	2012	11.5000	4.2550	5.0000	1
343	2244	17	0	8	Q3	2012	11.5000	3.5650	5.0000	1
343	2272	17	0	2	Q1	2012	4.6000	2.2540	2.0000	1
343	2569	6	524	11	Q4	2012	9.2000	4.5080	4.0000	1
343	2878	3	0	9	Q3	2012	6.9000	2.2080	3.0000	1
343	4231	17	1304	7	Q3	2012	6.9000	2.5530	3.0000	1
343	4255	24	0	5	Q2	2012	9.2000	3.2200	4.0000	1
343	4273	11	824	4	Q2	2012	4.6000	2.0700	2.0000	1
343	4282	15	0	7	Q3	2012	4.6000	1.4720	2.0000	1
343	4417	3	0	1	Q1	2012	9.2000	3.8640	4.0000	1
343	4514	11	0	10	Q4	2012	6.9000	2.4150	3.0000	1
343	4541	3	0	2	Q1	2012	6.9000	2.6220	3.0000	1
343	4543	13	0	2	Q1	2012	6.9000	3.0360	3.0000	1
343	4832	15	0	8	Q3	2012	6.9000	3.1050	3.0000	1
343	4925	16	1216	2	Q1	2012	6.9000	2.5530	3.0000	1
343	5143	17	0	12	Q4	2012	4.6000	1.4260	2.0000	1
343	5373	24	0	9	Q3	2012	6.9000	2.2770	3.0000	1
343	5410	17	0	2	Q1	2012	6.9000	2.4150	3.0000	1
343	5647	15	1142	5	Q2	2012	6.9000	2.6910	3.0000	1
343	5723	15	0	4	Q2	2012	4.6000	1.7480	2.0000	1
343	5907	7	0	4	Q2	2012	9.2000	3.1280	4.0000	1
343	5907	7	0	12	Q4	2012	6.9000	2.8980	3.0000	1
343	6422	11	820	2	Q1	2012	4.6000	2.0240	2.0000	1
343	6494	6	0	4	Q2	2012	4.6000	1.7020	2.0000	1
343	6542	7	0	3	Q1	2012	4.6000	1.9320	2.0000	1
343	6712	16	0	9	Q3	2012	4.6000	2.2540	2.0000	1
343	7175	7	0	1	Q1	2012	4.6000	1.6560	2.0000	1
343	7319	13	0	12	Q4	2012	4.6000	1.7020	2.0000	1
343	7811	11	0	6	Q2	2012	6.9000	3.3810	3.0000	1
343	8222	15	1143	5	Q2	2012	9.2000	2.7600	4.0000	1
343	8235	22	0	1	Q1	2012	4.6000	2.2080	2.0000	1
343	8442	17	0	7	Q3	2012	9.2000	3.0360	4.0000	1
343	8485	15	0	12	Q4	2012	6.9000	2.8290	3.0000	1
343	8594	6	510	5	Q2	2012	6.9000	3.1740	3.0000	1
343	8994	17	0	9	Q3	2012	4.6000	1.7020	2.0000	1
343	9013	11	0	9	Q3	2012	6.9000	2.6220	3.0000	1
343	9146	22	0	10	Q4	2012	2.3000	0.7590	1.0000	1
343	9303	15	0	9	Q3	2012	6.9000	3.1740	3.0000	1
343	9473	15	0	3	Q1	2012	9.2000	3.4040	4.0000	1
343	9487	17	0	2	Q1	2012	4.6000	1.9780	2.0000	1
343	9642	3	0	7	Q3	2012	9.2000	2.8520	4.0000	1
343	10099	24	0	10	Q4	2012	6.9000	2.9670	3.0000	1
343	10173	16	0	3	Q1	2012	6.9000	3.3810	3.0000	1
344	190	13	0	4	Q2	2012	4.5600	1.5504	2.0000	1
344	630	24	0	3	Q1	2012	9.1200	3.1920	4.0000	1
344	924	3	0	4	Q2	2012	9.1200	4.1040	4.0000	1
344	1074	13	0	2	Q1	2012	6.8400	2.1888	3.0000	1
344	1415	16	1220	4	Q2	2012	6.8400	3.0780	3.0000	1
344	1445	15	0	11	Q4	2012	9.1200	2.9184	4.0000	1
344	1491	16	0	3	Q1	2012	6.8400	3.0096	3.0000	1
344	1491	16	0	12	Q4	2012	9.1200	3.3744	4.0000	1
344	1718	13	0	11	Q4	2012	9.1200	2.8272	4.0000	1
344	1736	13	0	5	Q2	2012	6.8400	2.9412	3.0000	1
344	1856	24	0	2	Q1	2012	6.8400	2.5992	3.0000	1
344	2151	13	988	7	Q3	2012	6.8400	2.3256	3.0000	1
344	2204	3	0	4	Q2	2012	9.1200	4.4688	4.0000	1
344	2448	16	0	9	Q3	2012	9.1200	3.4656	4.0000	1
344	2453	24	0	9	Q3	2012	4.5600	1.8240	2.0000	1
344	2587	16	1214	2	Q1	2012	6.8400	2.5992	3.0000	1
344	2729	15	0	6	Q2	2012	4.5600	2.1888	2.0000	1
344	2815	22	0	7	Q3	2012	4.5600	1.7784	2.0000	1
344	2921	16	0	8	Q3	2012	4.5600	1.7784	2.0000	1
344	3204	24	0	3	Q1	2012	4.5600	2.1888	2.0000	1
344	3486	15	0	12	Q4	2012	6.8400	2.1888	3.0000	1
344	3547	11	829	6	Q2	2012	6.8400	3.0780	3.0000	1
344	3548	13	984	5	Q2	2012	9.1200	3.8304	4.0000	1
344	3587	6	521	10	Q4	2012	6.8400	3.1464	3.0000	1
344	3742	11	0	2	Q1	2012	9.1200	4.4688	4.0000	1
344	3814	6	523	11	Q4	2012	6.8400	2.8728	3.0000	1
344	3816	3	0	2	Q1	2012	6.8400	2.2572	3.0000	1
344	3905	15	1136	2	Q1	2012	6.8400	3.2832	3.0000	1
344	4099	17	1307	8	Q3	2012	11.4000	4.2180	5.0000	1
344	4099	17	1312	10	Q4	2012	9.1200	3.8304	4.0000	1
344	4110	15	0	9	Q3	2012	4.5600	1.7784	2.0000	1
344	4445	17	1303	6	Q2	2012	9.1200	4.5600	4.0000	1
344	4541	3	207	11	Q4	2012	9.1200	3.8304	4.0000	1
344	4556	13	0	3	Q1	2012	6.8400	3.4200	3.0000	1
344	4564	17	0	4	Q2	2012	9.1200	3.8304	4.0000	1
344	4657	17	0	3	Q1	2012	4.5600	1.4136	2.0000	1
344	4727	16	1235	11	Q4	2012	6.8400	3.3516	3.0000	1
344	4903	3	0	8	Q3	2012	6.8400	2.3940	3.0000	1
344	5138	24	0	11	Q4	2012	6.8400	2.0520	3.0000	1
344	5346	3	0	8	Q3	2012	9.1200	4.1040	4.0000	1
344	5368	24	0	11	Q4	2012	6.8400	3.3516	3.0000	1
344	5530	13	988	7	Q3	2012	9.1200	3.1920	4.0000	1
344	5593	13	0	11	Q4	2012	6.8400	2.8044	3.0000	1
344	5777	7	0	7	Q3	2012	9.1200	3.5568	4.0000	1
344	6026	15	1152	9	Q3	2012	6.8400	3.4200	3.0000	1
344	6600	6	508	4	Q2	2012	4.5600	1.6416	2.0000	1
344	6766	24	1850	3	Q1	2012	9.1200	4.4688	4.0000	1
344	6902	15	0	6	Q2	2012	6.8400	3.0780	3.0000	1
344	7109	11	821	2	Q1	2012	6.8400	2.3940	3.0000	1
344	7157	15	0	11	Q4	2012	9.1200	4.0128	4.0000	1
344	7243	13	0	3	Q1	2012	6.8400	2.5992	3.0000	1
344	7433	11	0	5	Q2	2012	6.8400	2.1204	3.0000	1
344	7862	16	0	8	Q3	2012	9.1200	3.3744	4.0000	1
344	8199	17	0	7	Q3	2012	6.8400	3.0780	3.0000	1
344	8202	3	195	5	Q2	2012	6.8400	3.3516	3.0000	1
344	8393	11	0	7	Q3	2012	4.5600	2.2344	2.0000	1
344	8404	3	0	11	Q4	2012	6.8400	2.3256	3.0000	1
344	8487	15	1134	1	Q1	2012	6.8400	2.3940	3.0000	1
344	8577	23	0	6	Q2	2012	9.1200	2.9184	4.0000	1
344	8849	11	0	5	Q2	2012	6.8400	2.1888	3.0000	1
344	9536	24	0	4	Q2	2012	6.8400	2.1204	3.0000	1
344	9728	16	1223	6	Q2	2012	6.8400	2.3256	3.0000	1
345	64	11	821	3	Q1	2012	8.4400	3.3760	4.0000	1
345	304	13	0	11	Q4	2012	6.3300	2.0256	3.0000	1
345	372	2	126	10	Q4	2012	4.2200	1.5614	2.0000	1
345	398	13	0	9	Q3	2012	4.2200	1.6880	2.0000	1
345	422	13	0	10	Q4	2012	6.3300	1.8990	3.0000	1
345	446	13	0	10	Q4	2012	6.3300	3.0384	3.0000	1
345	532	13	0	6	Q2	2012	6.3300	2.9118	3.0000	1
345	644	13	0	5	Q2	2012	10.5500	3.2705	5.0000	1
345	880	11	0	1	Q1	2012	6.3300	2.8485	3.0000	1
345	1053	13	0	4	Q2	2012	4.2200	1.3082	2.0000	1
345	1144	6	0	12	Q4	2012	6.3300	1.9623	3.0000	1
345	1144	7	0	4	Q2	2012	8.4400	3.2072	4.0000	1
345	1442	3	0	4	Q2	2012	6.3300	2.7852	3.0000	1
345	1491	16	0	11	Q4	2012	8.4400	2.9540	4.0000	1
345	1498	24	0	7	Q3	2012	8.4400	3.6292	4.0000	1
345	1556	17	0	8	Q3	2012	6.3300	2.7852	3.0000	1
345	1861	15	0	11	Q4	2012	6.3300	2.3421	3.0000	1
345	1914	24	0	2	Q1	2012	4.2200	1.8146	2.0000	1
345	1964	11	829	6	Q2	2012	4.2200	1.3926	2.0000	1
345	2244	17	0	1	Q1	2012	10.5500	4.7475	5.0000	1
345	2378	16	0	3	Q1	2012	6.3300	2.1522	3.0000	1
345	2664	17	0	8	Q3	2012	6.3300	2.0889	3.0000	1
345	2757	6	508	4	Q2	2012	6.3300	1.9623	3.0000	1
345	3160	17	0	9	Q3	2012	6.3300	2.3421	3.0000	1
345	3239	17	0	4	Q2	2012	8.4400	3.7136	4.0000	1
345	3291	6	0	3	Q1	2012	4.2200	1.8990	2.0000	1
345	3401	11	842	12	Q4	2012	4.2200	1.7724	2.0000	1
345	3550	11	821	2	Q1	2012	6.3300	1.9623	3.0000	1
345	3567	16	1235	11	Q4	2012	6.3300	2.7852	3.0000	1
345	3647	13	986	6	Q2	2012	6.3300	2.0256	3.0000	1
345	4010	11	0	10	Q4	2012	4.2200	1.9412	2.0000	1
345	4275	24	0	9	Q3	2012	8.4400	2.9540	4.0000	1
345	4331	24	0	5	Q2	2012	8.4400	2.7852	4.0000	1
345	4334	24	1869	12	Q4	2012	6.3300	1.8990	3.0000	1
345	4445	17	0	12	Q4	2012	4.2200	1.6458	2.0000	1
345	4727	16	0	8	Q3	2012	6.3300	1.9623	3.0000	1
345	4875	13	0	3	Q1	2012	8.4400	2.7008	4.0000	1
345	5019	23	1773	4	Q2	2012	6.3300	2.7219	3.0000	1
345	5060	13	0	7	Q3	2012	6.3300	2.9118	3.0000	1
345	5086	6	0	12	Q4	2012	6.3300	3.1650	3.0000	1
345	6307	16	0	8	Q3	2012	10.5500	4.4310	5.0000	1
345	6362	14	0	5	Q2	2012	4.2200	1.9412	2.0000	1
345	6559	3	0	10	Q4	2012	4.2200	1.6458	2.0000	1
345	6647	17	0	7	Q3	2012	4.2200	1.8990	2.0000	1
345	6731	7	0	6	Q2	2012	8.4400	2.5320	4.0000	1
345	6733	13	0	3	Q1	2012	6.3300	2.7852	3.0000	1
345	7197	11	0	1	Q1	2012	8.4400	3.1228	4.0000	1
345	7822	3	187	2	Q1	2012	6.3300	2.4054	3.0000	1
345	7996	15	0	2	Q1	2012	4.2200	1.3082	2.0000	1
345	7997	13	0	12	Q4	2012	4.2200	1.5192	2.0000	1
345	8837	11	0	3	Q1	2012	8.4400	2.6164	4.0000	1
345	8907	3	0	9	Q3	2012	8.4400	2.8696	4.0000	1
345	9016	23	0	9	Q3	2012	8.4400	2.6164	4.0000	1
345	9019	7	501	1	Q1	2012	8.4400	3.3760	4.0000	1
345	9381	24	1853	5	Q2	2012	8.4400	2.9540	4.0000	1
345	9638	11	836	9	Q3	2012	4.2200	1.9412	2.0000	1
345	9673	13	988	7	Q3	2012	6.3300	2.3421	3.0000	1
345	9691	15	0	11	Q4	2012	10.5500	4.2200	5.0000	1
345	9781	3	207	11	Q4	2012	8.4400	2.7008	4.0000	1
345	9997	17	0	8	Q3	2012	6.3300	2.9751	3.0000	1
346	529	24	0	5	Q2	2012	4.2400	1.7808	2.0000	1
346	892	7	505	2	Q1	2012	6.3600	2.7984	3.0000	1
346	1198	7	512	6	Q2	2012	6.3600	2.7348	3.0000	1
346	1451	3	0	3	Q1	2012	8.4800	2.7136	4.0000	1
346	1556	17	1307	8	Q3	2012	6.3600	3.1164	3.0000	1
346	1727	24	1866	11	Q4	2012	8.4800	2.9680	4.0000	1
346	2035	15	0	2	Q1	2012	6.3600	2.4168	3.0000	1
346	2078	24	0	5	Q2	2012	4.2400	1.6536	2.0000	1
346	2302	15	0	11	Q4	2012	6.3600	3.1164	3.0000	1
346	3161	13	0	5	Q2	2012	8.4800	2.8832	4.0000	1
346	3207	15	0	4	Q2	2012	4.2400	1.7808	2.0000	1
346	3245	17	0	1	Q1	2012	6.3600	2.1624	3.0000	1
346	3291	7	0	3	Q1	2012	6.3600	2.5440	3.0000	1
346	3316	7	517	8	Q3	2012	6.3600	2.8620	3.0000	1
346	3567	16	0	5	Q2	2012	6.3600	3.1164	3.0000	1
346	4391	16	1231	9	Q3	2012	4.2400	1.5264	2.0000	1
346	4425	13	0	2	Q1	2012	6.3600	2.0988	3.0000	1
346	4584	11	0	11	Q4	2012	6.3600	3.1164	3.0000	1
346	4711	3	0	6	Q2	2012	4.2400	1.3568	2.0000	1
346	4906	11	0	11	Q4	2012	6.3600	2.9892	3.0000	1
346	5009	7	0	7	Q3	2012	4.2400	1.9080	2.0000	1
346	5865	15	0	12	Q4	2012	8.4800	3.1376	4.0000	1
346	6592	13	0	3	Q1	2012	8.4800	2.8832	4.0000	1
346	6633	24	1866	11	Q4	2012	6.3600	1.9716	3.0000	1
346	6716	6	0	8	Q3	2012	6.3600	3.1800	3.0000	1
346	6841	3	0	9	Q3	2012	6.3600	3.1164	3.0000	1
346	7820	24	0	8	Q3	2012	6.3600	1.9716	3.0000	1
346	8260	7	0	12	Q4	2012	6.3600	2.0988	3.0000	1
346	8274	13	988	7	Q3	2012	6.3600	1.9716	3.0000	1
346	8289	17	0	9	Q3	2012	6.3600	2.7984	3.0000	1
346	8311	23	0	5	Q2	2012	6.3600	1.9716	3.0000	1
346	8414	17	0	5	Q2	2012	6.3600	2.2260	3.0000	1
346	8452	16	0	5	Q2	2012	6.3600	2.3532	3.0000	1
346	8457	7	0	9	Q3	2012	8.4800	3.3920	4.0000	1
346	8886	11	821	3	Q1	2012	8.4800	3.3920	4.0000	1
346	9040	16	0	11	Q4	2012	8.4800	3.2224	4.0000	1
346	9172	24	0	12	Q4	2012	6.3600	3.1800	3.0000	1
346	9279	7	0	10	Q4	2012	8.4800	3.3920	4.0000	1
346	9512	23	0	7	Q3	2012	4.2400	1.4416	2.0000	1
346	9603	6	506	3	Q1	2012	6.3600	2.4804	3.0000	1
346	10087	24	0	5	Q2	2012	4.2400	1.8656	2.0000	1
347	76	3	207	11	Q4	2012	3.6000	1.3680	3.0000	1
347	115	7	0	7	Q3	2012	3.6000	1.3320	3.0000	1
347	1297	16	1235	11	Q4	2012	3.6000	1.2960	3.0000	1
347	1329	15	0	7	Q3	2012	2.4000	1.1760	2.0000	1
347	1378	11	0	5	Q2	2012	2.4000	1.1760	2.0000	1
347	1696	22	0	8	Q3	2012	3.6000	1.6920	3.0000	1
347	2224	16	0	12	Q4	2012	2.4000	1.1040	2.0000	1
347	2295	17	0	2	Q1	2012	3.6000	1.1160	3.0000	1
347	2791	11	833	8	Q3	2012	4.8000	1.8720	4.0000	1
347	3208	14	1078	12	Q4	2012	2.4000	1.1520	2.0000	1
347	3227	24	0	1	Q1	2012	4.8000	1.6800	4.0000	1
347	3655	7	0	6	Q2	2012	3.6000	1.4040	3.0000	1
347	3819	23	0	8	Q3	2012	4.8000	2.3040	4.0000	1
347	3937	13	0	6	Q2	2012	4.8000	1.8720	4.0000	1
347	3981	6	0	6	Q2	2012	3.6000	1.1160	3.0000	1
347	4407	7	516	8	Q3	2012	3.6000	1.5480	3.0000	1
347	4518	13	0	3	Q1	2012	3.6000	1.6200	3.0000	1
347	5037	24	0	1	Q1	2012	3.6000	1.1160	3.0000	1
347	5123	11	826	5	Q2	2012	4.8000	2.0160	4.0000	1
347	5419	17	0	10	Q4	2012	3.6000	1.1520	3.0000	1
347	5499	11	0	8	Q3	2012	3.6000	1.2240	3.0000	1
347	5628	14	0	10	Q4	2012	1.2000	0.6000	1.0000	1
347	5726	15	0	8	Q3	2012	3.6000	1.1520	3.0000	1
347	5820	17	0	3	Q1	2012	3.6000	1.4040	3.0000	1
347	5978	7	0	11	Q4	2012	6.0000	2.3400	5.0000	1
347	6113	16	0	5	Q2	2012	2.4000	0.9600	2.0000	1
347	6347	17	0	9	Q3	2012	3.6000	1.2240	3.0000	1
347	6630	24	0	7	Q3	2012	3.6000	1.6200	3.0000	1
347	6647	17	0	12	Q4	2012	4.8000	2.3520	4.0000	1
347	6778	24	0	2	Q1	2012	3.6000	1.7280	3.0000	1
347	6995	11	0	5	Q2	2012	4.8000	2.0160	4.0000	1
347	7828	11	818	1	Q1	2012	3.6000	1.1880	3.0000	1
347	7878	15	0	1	Q1	2012	3.6000	1.5840	3.0000	1
347	8059	17	0	12	Q4	2012	2.4000	1.0560	2.0000	1
347	8074	17	1304	7	Q3	2012	4.8000	1.5360	4.0000	1
347	8159	6	523	11	Q4	2012	4.8000	1.6800	4.0000	1
347	8172	17	0	6	Q2	2012	2.4000	0.7920	2.0000	1
347	8235	22	1694	4	Q2	2012	2.4000	1.1520	2.0000	1
347	8250	15	0	4	Q2	2012	4.8000	1.8720	4.0000	1
347	8253	24	1845	1	Q1	2012	3.6000	1.2240	3.0000	1
347	8304	13	0	11	Q4	2012	4.8000	2.3520	4.0000	1
347	8304	13	0	12	Q4	2012	4.8000	1.4880	4.0000	1
347	8401	14	0	1	Q1	2012	2.4000	0.9600	2.0000	1
347	8463	23	0	7	Q3	2012	3.6000	1.4400	3.0000	1
347	8862	11	0	3	Q1	2012	3.6000	1.8000	3.0000	1
347	8892	13	0	3	Q1	2012	3.6000	1.1160	3.0000	1
347	8892	13	0	9	Q3	2012	3.6000	1.1160	3.0000	1
347	8946	23	0	3	Q1	2012	3.6000	1.4040	3.0000	1
347	8994	17	0	10	Q4	2012	2.4000	1.0080	2.0000	1
347	9063	23	0	5	Q2	2012	3.6000	1.3320	3.0000	1
347	9633	7	0	8	Q3	2012	4.8000	1.9680	4.0000	1
347	9858	24	1856	6	Q2	2012	7.2000	3.3840	6.0000	1
347	9873	15	0	8	Q3	2012	4.8000	2.3520	4.0000	1
348	208	13	0	3	Q1	2012	2.4600	1.0332	2.0000	1
348	335	17	0	2	Q1	2012	4.9200	1.6236	4.0000	1
348	374	15	0	12	Q4	2012	3.6900	1.4022	3.0000	1
348	446	13	0	7	Q3	2012	2.4600	1.0086	2.0000	1
348	617	17	1314	11	Q4	2012	4.9200	1.9188	4.0000	1
348	619	13	0	6	Q2	2012	3.6900	1.5498	3.0000	1
348	740	11	0	6	Q2	2012	4.9200	1.9188	4.0000	1
348	780	13	0	4	Q2	2012	3.6900	1.7712	3.0000	1
348	878	3	0	10	Q4	2012	3.6900	1.3284	3.0000	1
348	1023	6	0	8	Q3	2012	4.9200	1.7220	4.0000	1
348	1331	7	517	8	Q3	2012	3.6900	1.6236	3.0000	1
348	1379	7	0	10	Q4	2012	3.6900	1.2546	3.0000	1
348	1474	15	0	2	Q1	2012	2.4600	1.1808	2.0000	1
348	1607	17	0	12	Q4	2012	4.9200	2.4108	4.0000	1
348	1743	7	516	8	Q3	2012	3.6900	1.2177	3.0000	1
348	1772	15	0	4	Q2	2012	3.6900	1.7712	3.0000	1
348	1838	24	0	6	Q2	2012	2.4600	0.9102	2.0000	1
348	2019	16	0	5	Q2	2012	4.9200	2.4108	4.0000	1
348	2067	17	0	3	Q1	2012	3.6900	1.4760	3.0000	1
348	2448	16	0	12	Q4	2012	3.6900	1.7712	3.0000	1
348	2682	23	0	2	Q1	2012	3.6900	1.3284	3.0000	1
348	2927	7	0	11	Q4	2012	4.9200	1.5252	4.0000	1
348	3436	11	0	10	Q4	2012	3.6900	1.2177	3.0000	1
348	3533	3	0	9	Q3	2012	3.6900	1.6236	3.0000	1
348	3589	13	0	7	Q3	2012	4.9200	2.0172	4.0000	1
348	4118	17	0	7	Q3	2012	3.6900	1.7712	3.0000	1
348	4191	7	0	3	Q1	2012	2.4600	1.0332	2.0000	1
348	4291	15	1141	4	Q2	2012	2.4600	1.1316	2.0000	1
348	4417	3	199	7	Q3	2012	4.9200	1.5744	4.0000	1
348	4557	22	1711	12	Q4	2012	1.2300	0.4059	1.0000	1
348	4567	23	0	8	Q3	2012	4.9200	1.8204	4.0000	1
348	4725	7	0	9	Q3	2012	3.6900	1.2177	3.0000	1
348	4767	16	1228	8	Q3	2012	3.6900	1.5498	3.0000	1
348	4973	17	0	9	Q3	2012	3.6900	1.2546	3.0000	1
348	5329	13	982	4	Q2	2012	3.6900	1.3653	3.0000	1
348	5612	15	0	6	Q2	2012	3.6900	1.6236	3.0000	1
348	6351	11	0	6	Q2	2012	3.6900	1.7712	3.0000	1
348	6352	13	0	11	Q4	2012	4.9200	2.2632	4.0000	1
348	6529	17	0	2	Q1	2012	3.6900	1.7712	3.0000	1
348	6826	6	0	3	Q1	2012	3.6900	1.2915	3.0000	1
348	6949	15	0	4	Q2	2012	3.6900	1.1070	3.0000	1
348	7457	13	0	1	Q1	2012	2.4600	0.9348	2.0000	1
348	8241	17	0	2	Q1	2012	3.6900	1.6605	3.0000	1
348	8272	7	0	10	Q4	2012	4.9200	1.4760	4.0000	1
348	8296	6	513	6	Q2	2012	6.1500	3.0135	5.0000	1
348	8404	3	207	11	Q4	2012	3.6900	1.2546	3.0000	1
348	8500	17	0	3	Q1	2012	3.6900	1.2546	3.0000	1
348	8921	13	0	5	Q2	2012	4.9200	1.5252	4.0000	1
348	9401	13	0	2	Q1	2012	3.6900	1.7343	3.0000	1
348	9524	3	0	9	Q3	2012	3.6900	1.4760	3.0000	1
348	9533	24	0	6	Q2	2012	4.9200	1.8204	4.0000	1
348	9567	15	1150	8	Q3	2012	3.6900	1.7712	3.0000	1
348	10126	7	0	11	Q4	2012	3.6900	1.1439	3.0000	1
349	169	13	0	12	Q4	2012	9.3600	3.9312	4.0000	1
349	430	16	1225	7	Q3	2012	7.0200	2.2464	3.0000	1
349	625	13	0	3	Q1	2012	7.0200	3.2994	3.0000	1
349	760	3	0	1	Q1	2012	9.3600	3.8376	4.0000	1
349	1147	13	0	12	Q4	2012	7.0200	3.5100	3.0000	1
349	1215	7	0	12	Q4	2012	9.3600	3.2760	4.0000	1
349	1310	16	1225	7	Q3	2012	7.0200	3.0888	3.0000	1
349	1330	13	0	8	Q3	2012	4.6800	2.3400	2.0000	1
349	1337	17	1314	11	Q4	2012	4.6800	1.8252	2.0000	1
349	2224	16	0	1	Q1	2012	9.3600	3.6504	4.0000	1
349	2344	7	0	3	Q1	2012	4.6800	2.0124	2.0000	1
349	2359	24	1850	3	Q1	2012	4.6800	2.0124	2.0000	1
349	2405	24	1866	11	Q4	2012	4.6800	1.6848	2.0000	1
349	2422	13	0	6	Q2	2012	4.6800	1.7316	2.0000	1
349	2872	2	0	12	Q4	2012	4.6800	1.9188	2.0000	1
349	3000	17	1304	7	Q3	2012	7.0200	2.5974	3.0000	1
349	3130	13	0	8	Q3	2012	7.0200	3.3696	3.0000	1
349	3158	15	0	7	Q3	2012	7.0200	2.3166	3.0000	1
349	3257	24	0	1	Q1	2012	7.0200	2.1762	3.0000	1
349	3310	17	1314	11	Q4	2012	7.0200	2.3868	3.0000	1
349	3422	23	0	7	Q3	2012	4.6800	2.2932	2.0000	1
349	3928	23	0	12	Q4	2012	7.0200	2.1762	3.0000	1
349	4204	17	0	11	Q4	2012	9.3600	3.0888	4.0000	1
349	4373	11	0	3	Q1	2012	7.0200	3.1590	3.0000	1
349	4405	13	0	6	Q2	2012	7.0200	3.2292	3.0000	1
349	4606	3	0	11	Q4	2012	4.6800	1.4040	2.0000	1
349	4695	13	0	10	Q4	2012	4.6800	1.7316	2.0000	1
349	4858	17	0	4	Q2	2012	7.0200	2.9484	3.0000	1
349	5154	14	1077	11	Q4	2012	2.3400	0.7722	1.0000	1
349	5158	3	0	10	Q4	2012	4.6800	2.1060	2.0000	1
349	5302	11	0	3	Q1	2012	7.0200	2.3166	3.0000	1
349	5738	3	0	8	Q3	2012	7.0200	3.4398	3.0000	1
349	5925	15	0	2	Q1	2012	11.7000	4.3290	5.0000	1
349	6439	7	501	1	Q1	2012	9.3600	2.9016	4.0000	1
349	6490	7	0	10	Q4	2012	7.0200	2.3868	3.0000	1
349	6511	7	0	4	Q2	2012	9.3600	3.6504	4.0000	1
349	6529	17	0	4	Q2	2012	4.6800	1.8720	2.0000	1
349	6531	13	0	4	Q2	2012	4.6800	1.5444	2.0000	1
349	6741	24	1869	12	Q4	2012	7.0200	3.1590	3.0000	1
349	6866	17	0	2	Q1	2012	7.0200	2.9484	3.0000	1
349	7035	6	0	8	Q3	2012	4.6800	1.9188	2.0000	1
349	7297	11	0	5	Q2	2012	7.0200	2.5272	3.0000	1
349	7607	17	0	7	Q3	2012	9.3600	4.3056	4.0000	1
349	7624	11	0	7	Q3	2012	7.0200	2.8080	3.0000	1
349	7704	3	205	10	Q4	2012	9.3600	4.5864	4.0000	1
349	7845	13	0	1	Q1	2012	4.6800	1.8252	2.0000	1
349	7862	16	1236	12	Q4	2012	9.3600	3.0888	4.0000	1
349	7942	24	0	10	Q4	2012	9.3600	3.0888	4.0000	1
349	7942	24	1866	11	Q4	2012	9.3600	4.2120	4.0000	1
349	8003	3	195	5	Q2	2012	4.6800	1.5912	2.0000	1
349	8053	24	0	4	Q2	2012	9.3600	4.5864	4.0000	1
349	8059	17	0	9	Q3	2012	4.6800	2.0124	2.0000	1
349	8172	17	0	5	Q2	2012	7.0200	2.3166	3.0000	1
349	8206	23	1773	4	Q2	2012	11.7000	5.2650	5.0000	1
349	8266	7	0	4	Q2	2012	9.3600	4.3992	4.0000	1
349	8275	16	0	1	Q1	2012	9.3600	4.6800	4.0000	1
349	8374	3	0	3	Q1	2012	9.3600	3.7440	4.0000	1
349	8782	6	513	6	Q2	2012	7.0200	2.2464	3.0000	1
349	9016	23	1768	2	Q1	2012	7.0200	3.3696	3.0000	1
349	9322	15	0	12	Q4	2012	7.0200	2.5272	3.0000	1
349	9469	17	1304	7	Q3	2012	7.0200	2.3166	3.0000	1
349	9501	13	0	7	Q3	2012	7.0200	2.8782	3.0000	1
349	9510	16	0	5	Q2	2012	9.3600	3.0888	4.0000	1
349	9757	24	1869	12	Q4	2012	7.0200	2.1762	3.0000	1
349	9867	13	0	11	Q4	2012	9.3600	3.3696	4.0000	1
349	9891	23	0	10	Q4	2012	7.0200	2.2464	3.0000	1
349	10144	7	504	2	Q1	2012	7.0200	2.1762	3.0000	1
350	50	7	0	9	Q3	2012	6.5200	2.8036	4.0000	1
350	280	13	992	9	Q3	2012	6.5200	2.4124	4.0000	1
350	748	24	0	4	Q2	2012	4.8900	1.5159	3.0000	1
350	1082	15	0	11	Q4	2012	6.5200	3.0644	4.0000	1
350	1198	7	512	6	Q2	2012	4.8900	1.9560	3.0000	1
350	1205	15	0	9	Q3	2012	6.5200	2.0864	4.0000	1
350	1205	15	1152	9	Q3	2012	4.8900	1.5159	3.0000	1
350	1599	6	0	11	Q4	2012	3.2600	1.1736	2.0000	1
350	1730	11	0	3	Q1	2012	6.5200	2.1516	4.0000	1
350	1856	24	1856	6	Q2	2012	6.5200	2.0212	4.0000	1
350	1991	13	0	7	Q3	2012	4.8900	1.7604	3.0000	1
350	2171	23	0	11	Q4	2012	4.8900	1.7604	3.0000	1
350	2201	16	0	1	Q1	2012	3.2600	1.2714	2.0000	1
350	2523	7	514	7	Q3	2012	4.8900	2.4450	3.0000	1
350	2599	7	0	6	Q2	2012	4.8900	1.7115	3.0000	1
350	2639	15	0	9	Q3	2012	3.2600	1.3692	2.0000	1
350	2695	13	0	8	Q3	2012	4.8900	1.6137	3.0000	1
350	2876	6	522	10	Q4	2012	4.8900	2.3961	3.0000	1
350	2921	16	0	6	Q2	2012	4.8900	1.7115	3.0000	1
350	2924	3	0	2	Q1	2012	8.1500	3.0970	5.0000	1
350	3099	7	0	6	Q2	2012	4.8900	2.3472	3.0000	1
350	3239	17	0	4	Q2	2012	4.8900	1.7115	3.0000	1
350	3716	17	0	5	Q2	2012	6.5200	2.0212	4.0000	1
350	3929	15	0	5	Q2	2012	4.8900	1.9071	3.0000	1
350	3935	24	1847	2	Q1	2012	4.8900	2.1027	3.0000	1
350	3938	13	0	9	Q3	2012	6.5200	2.5428	4.0000	1
350	4094	16	0	4	Q2	2012	4.8900	2.3961	3.0000	1
350	4151	7	0	11	Q4	2012	3.2600	1.2388	2.0000	1
350	4618	3	0	1	Q1	2012	4.8900	1.7604	3.0000	1
350	5295	16	0	10	Q4	2012	6.5200	2.8036	4.0000	1
350	5626	7	0	12	Q4	2012	6.5200	2.0864	4.0000	1
350	5655	7	504	2	Q1	2012	6.5200	3.1296	4.0000	1
350	5723	15	0	4	Q2	2012	4.8900	1.8582	3.0000	1
350	6134	15	1154	10	Q4	2012	3.2600	1.3692	2.0000	1
350	6541	23	0	9	Q3	2012	3.2600	1.1736	2.0000	1
350	6888	23	0	11	Q4	2012	4.8900	1.5648	3.0000	1
350	6936	17	0	2	Q1	2012	3.2600	1.4996	2.0000	1
350	7359	13	0	6	Q2	2012	4.8900	2.2005	3.0000	1
350	7607	17	0	5	Q2	2012	4.8900	2.1516	3.0000	1
350	7743	3	185	1	Q1	2012	4.8900	1.7604	3.0000	1
350	8133	6	0	11	Q4	2012	4.8900	1.7604	3.0000	1
350	8336	17	0	1	Q1	2012	4.8900	2.1516	3.0000	1
350	8472	17	0	9	Q3	2012	4.8900	2.3961	3.0000	1
350	8577	23	0	10	Q4	2012	4.8900	1.5648	3.0000	1
350	8598	7	0	10	Q4	2012	6.5200	2.9992	4.0000	1
350	8598	7	526	12	Q4	2012	4.8900	2.0049	3.0000	1
350	9040	16	0	7	Q3	2012	3.2600	1.3692	2.0000	1
350	9256	13	0	11	Q4	2012	4.8900	1.6626	3.0000	1
350	9263	16	0	7	Q3	2012	4.8900	2.1516	3.0000	1
350	9420	13	0	8	Q3	2012	4.8900	1.6626	3.0000	1
350	9535	11	0	10	Q4	2012	4.8900	1.5648	3.0000	1
350	9580	15	0	11	Q4	2012	4.8900	2.0538	3.0000	1
350	9598	6	0	11	Q4	2012	6.5200	2.5428	4.0000	1
350	9715	17	0	12	Q4	2012	6.5200	2.0212	4.0000	1
350	9826	13	0	6	Q2	2012	3.2600	0.9780	2.0000	1
350	10168	15	1136	2	Q1	2012	4.8900	1.6626	3.0000	1
351	44	6	0	4	Q2	2012	8.2800	3.2292	3.0000	1
351	582	15	1142	5	Q2	2012	8.2800	2.7324	3.0000	1
351	662	11	0	9	Q3	2012	8.2800	3.6432	3.0000	1
351	849	6	0	11	Q4	2012	11.0400	5.2992	4.0000	1
351	975	7	504	2	Q1	2012	8.2800	2.4840	3.0000	1
351	1153	13	0	10	Q4	2012	5.5200	2.0976	2.0000	1
351	1159	11	0	11	Q4	2012	8.2800	3.7260	3.0000	1
351	1490	13	0	7	Q3	2012	5.5200	1.9872	2.0000	1
351	1613	7	0	9	Q3	2012	5.5200	1.7664	2.0000	1
351	1701	13	0	11	Q4	2012	8.2800	2.4840	3.0000	1
351	1868	6	508	4	Q2	2012	5.5200	2.2080	2.0000	1
351	2224	16	1235	11	Q4	2012	5.5200	2.3184	2.0000	1
351	2226	15	1138	3	Q1	2012	5.5200	2.4840	2.0000	1
351	2441	17	0	9	Q3	2012	8.2800	3.8088	3.0000	1
351	2445	6	0	11	Q4	2012	5.5200	2.0976	2.0000	1
351	2727	24	0	3	Q1	2012	5.5200	2.0424	2.0000	1
351	2769	16	0	8	Q3	2012	8.2800	2.5668	3.0000	1
351	3038	2	0	5	Q2	2012	2.7600	1.1592	1.0000	1
351	3239	17	0	4	Q2	2012	8.2800	3.3120	3.0000	1
351	3900	24	1859	8	Q3	2012	8.2800	2.5668	3.0000	1
351	3907	24	0	10	Q4	2012	8.2800	3.4776	3.0000	1
351	4029	17	0	10	Q4	2012	8.2800	4.1400	3.0000	1
351	4075	3	0	7	Q3	2012	11.0400	3.7536	4.0000	1
351	4175	16	0	1	Q1	2012	5.5200	2.4288	2.0000	1
351	4292	7	0	11	Q4	2012	8.2800	3.3120	3.0000	1
351	4522	17	1303	6	Q2	2012	11.0400	3.8640	4.0000	1
351	4528	15	0	3	Q1	2012	5.5200	2.1528	2.0000	1
351	5023	6	513	6	Q2	2012	8.2800	2.9808	3.0000	1
351	5123	11	0	9	Q3	2012	11.0400	3.4224	4.0000	1
351	5230	13	0	10	Q4	2012	11.0400	3.4224	4.0000	1
351	5376	3	0	11	Q4	2012	11.0400	3.8640	4.0000	1
351	5453	22	1694	4	Q2	2012	5.5200	1.9320	2.0000	1
351	5715	11	818	1	Q1	2012	8.2800	4.1400	3.0000	1
351	5944	3	201	8	Q3	2012	5.5200	2.0424	2.0000	1
351	6319	2	112	3	Q1	2012	5.5200	1.7664	2.0000	1
351	6347	17	0	9	Q3	2012	8.2800	3.0636	3.0000	1
351	6355	6	0	9	Q3	2012	8.2800	3.4776	3.0000	1
351	7368	11	0	1	Q1	2012	8.2800	3.3948	3.0000	1
351	7419	14	1066	6	Q2	2012	5.5200	2.5392	2.0000	1
351	7439	7	0	3	Q1	2012	11.0400	4.1952	4.0000	1
351	7599	6	0	10	Q4	2012	5.5200	1.8216	2.0000	1
351	7852	11	829	6	Q2	2012	8.2800	2.5668	3.0000	1
351	7904	6	0	12	Q4	2012	8.2800	3.1464	3.0000	1
351	8117	11	0	4	Q2	2012	11.0400	3.7536	4.0000	1
351	8463	23	0	7	Q3	2012	8.2800	3.4776	3.0000	1
351	8624	7	0	9	Q3	2012	11.0400	3.5328	4.0000	1
351	8720	11	829	6	Q2	2012	5.5200	2.4840	2.0000	1
351	8919	13	0	1	Q1	2012	5.5200	1.9872	2.0000	1
351	9080	11	0	4	Q2	2012	8.2800	4.1400	3.0000	1
351	9080	11	837	10	Q4	2012	11.0400	3.5328	4.0000	1
351	9390	7	505	2	Q1	2012	8.2800	3.7260	3.0000	1
351	9512	23	0	4	Q2	2012	11.0400	3.5328	4.0000	1
351	9571	11	0	1	Q1	2012	5.5200	2.7048	2.0000	1
351	9671	13	0	7	Q3	2012	5.5200	1.8768	2.0000	1
351	9862	7	0	1	Q1	2012	8.2800	3.6432	3.0000	1
351	9951	3	0	12	Q4	2012	5.5200	2.7048	2.0000	1
351	9974	7	0	9	Q3	2012	11.0400	4.5264	4.0000	1
351	10227	15	1146	7	Q3	2012	8.2800	2.5668	3.0000	1
352	354	23	1771	3	Q1	2012	2.0100	0.8643	3.0000	1
352	511	16	0	10	Q4	2012	2.0100	0.6030	3.0000	1
352	846	24	0	5	Q2	2012	2.0100	0.7236	3.0000	1
352	1066	14	0	3	Q1	2012	1.3400	0.4556	2.0000	1
352	1379	7	0	10	Q4	2012	2.0100	0.9045	3.0000	1
352	1409	24	0	6	Q2	2012	1.3400	0.5762	2.0000	1
352	1594	11	0	11	Q4	2012	2.0100	0.8643	3.0000	1
352	1649	24	0	8	Q3	2012	2.0100	0.9648	3.0000	1
352	1683	6	504	2	Q1	2012	2.0100	0.6030	3.0000	1
352	1734	2	0	6	Q2	2012	0.6700	0.3149	1.0000	1
352	2075	13	0	9	Q3	2012	2.0100	0.6231	3.0000	1
352	2572	6	0	12	Q4	2012	2.0100	0.9648	3.0000	1
352	2682	23	1765	1	Q1	2012	2.0100	0.8643	3.0000	1
352	3749	15	1138	3	Q1	2012	2.0100	0.9849	3.0000	1
352	4239	17	0	9	Q3	2012	2.0100	0.9447	3.0000	1
352	4342	13	0	5	Q2	2012	2.6800	1.2060	4.0000	1
352	5024	15	0	11	Q4	2012	2.0100	0.7236	3.0000	1
352	5158	3	0	4	Q2	2012	2.0100	0.7437	3.0000	1
352	5206	13	0	7	Q3	2012	2.0100	0.6834	3.0000	1
352	5216	3	187	2	Q1	2012	2.0100	0.6834	3.0000	1
352	5663	6	513	6	Q2	2012	2.6800	1.2328	4.0000	1
352	5801	24	0	1	Q1	2012	2.0100	0.6030	3.0000	1
352	6082	13	976	1	Q1	2012	3.3500	1.2395	5.0000	1
352	6132	3	0	9	Q3	2012	2.0100	0.6231	3.0000	1
352	6348	16	0	1	Q1	2012	2.0100	0.7839	3.0000	1
352	6741	24	0	3	Q1	2012	2.6800	0.9380	4.0000	1
352	7366	3	0	2	Q1	2012	2.0100	0.7035	3.0000	1
352	7535	6	506	3	Q1	2012	2.0100	0.9849	3.0000	1
352	7738	15	0	8	Q3	2012	2.0100	0.9447	3.0000	1
352	8351	16	0	5	Q2	2012	1.3400	0.5896	2.0000	1
352	8472	17	0	7	Q3	2012	1.3400	0.6030	2.0000	1
352	8500	17	0	6	Q2	2012	1.3400	0.6030	2.0000	1
352	9256	13	0	2	Q1	2012	2.0100	0.6834	3.0000	1
352	9387	6	0	11	Q4	2012	2.0100	0.6030	3.0000	1
352	9524	3	199	7	Q3	2012	1.3400	0.6566	2.0000	1
352	9570	15	1157	12	Q4	2012	2.6800	1.2328	4.0000	1
352	9928	16	0	12	Q4	2012	1.3400	0.4020	2.0000	1
352	10173	16	1233	10	Q4	2012	2.0100	0.6432	3.0000	1
353	910	15	0	9	Q3	2012	4.7100	2.1666	3.0000	1
353	924	3	0	8	Q3	2012	6.2800	2.3864	4.0000	1
353	937	6	521	10	Q4	2012	4.7100	2.1195	3.0000	1
353	976	16	1235	11	Q4	2012	6.2800	1.8840	4.0000	1
353	1142	13	976	1	Q1	2012	3.1400	1.1618	2.0000	1
353	1266	13	0	7	Q3	2012	6.2800	3.0772	4.0000	1
353	1330	13	0	8	Q3	2012	7.8500	3.9250	5.0000	1
353	1415	16	1220	4	Q2	2012	3.1400	1.0990	2.0000	1
353	1528	16	0	3	Q1	2012	6.2800	2.7632	4.0000	1
353	1916	13	0	8	Q3	2012	4.7100	1.8840	3.0000	1
353	1917	23	0	8	Q3	2012	4.7100	2.0724	3.0000	1
353	1983	17	0	5	Q2	2012	4.7100	1.4601	3.0000	1
353	2075	13	0	5	Q2	2012	6.2800	2.6376	4.0000	1
353	2346	15	1157	12	Q4	2012	6.2800	2.3864	4.0000	1
353	2361	24	1845	1	Q1	2012	6.2800	3.1400	4.0000	1
353	2689	3	0	6	Q2	2012	4.7100	1.8369	3.0000	1
353	3114	7	0	4	Q2	2012	4.7100	2.3079	3.0000	1
353	3503	6	0	1	Q1	2012	4.7100	2.3079	3.0000	1
353	3676	3	0	7	Q3	2012	6.2800	2.1352	4.0000	1
353	4094	16	0	8	Q3	2012	7.8500	3.2185	5.0000	1
353	4310	15	1138	3	Q1	2012	6.2800	2.3236	4.0000	1
353	4434	15	0	10	Q4	2012	6.2800	2.2608	4.0000	1
353	4507	13	0	4	Q2	2012	4.7100	1.5543	3.0000	1
353	4552	17	0	10	Q4	2012	4.7100	2.0724	3.0000	1
353	4609	23	1769	3	Q1	2012	4.7100	1.4601	3.0000	1
353	4666	13	0	1	Q1	2012	3.1400	1.3502	2.0000	1
353	4824	3	0	11	Q4	2012	3.1400	1.2874	2.0000	1
353	5226	6	0	12	Q4	2012	3.1400	1.0990	2.0000	1
353	5256	17	0	3	Q1	2012	4.7100	2.1666	3.0000	1
353	5256	17	0	4	Q2	2012	3.1400	1.3188	2.0000	1
353	5303	17	0	12	Q4	2012	3.1400	1.3188	2.0000	1
353	5379	17	0	2	Q1	2012	4.7100	2.1666	3.0000	1
353	5501	17	1314	11	Q4	2012	7.8500	3.6110	5.0000	1
353	5553	6	0	2	Q1	2012	6.2800	2.3864	4.0000	1
353	5590	17	0	1	Q1	2012	6.2800	2.5120	4.0000	1
353	5686	3	0	8	Q3	2012	4.7100	1.9782	3.0000	1
353	5733	11	0	6	Q2	2012	4.7100	1.4130	3.0000	1
353	5991	3	0	3	Q1	2012	4.7100	1.5543	3.0000	1
353	6526	13	0	7	Q3	2012	4.7100	1.5543	3.0000	1
353	6559	3	0	6	Q2	2012	4.7100	2.3079	3.0000	1
353	6559	3	0	12	Q4	2012	4.7100	2.3079	3.0000	1
353	6936	17	0	10	Q4	2012	4.7100	1.8840	3.0000	1
353	6994	7	526	12	Q4	2012	6.2800	2.4492	4.0000	1
353	7215	11	842	12	Q4	2012	3.1400	1.2874	2.0000	1
353	7340	24	1847	2	Q1	2012	6.2800	2.0724	4.0000	1
353	7354	3	0	3	Q1	2012	4.7100	1.4601	3.0000	1
353	7408	6	524	11	Q4	2012	3.1400	1.5072	2.0000	1
353	7605	6	515	7	Q3	2012	7.8500	2.9830	5.0000	1
353	7721	13	984	5	Q2	2012	4.7100	1.5543	3.0000	1
353	8110	13	0	1	Q1	2012	6.2800	2.4492	4.0000	1
353	8189	17	0	4	Q2	2012	4.7100	1.5543	3.0000	1
353	8734	7	0	5	Q2	2012	6.2800	2.8888	4.0000	1
353	9040	16	0	7	Q3	2012	4.7100	1.9782	3.0000	1
353	9558	6	524	11	Q4	2012	6.2800	2.8260	4.0000	1
353	9648	13	0	3	Q1	2012	4.7100	1.5543	3.0000	1
353	9697	23	0	6	Q2	2012	4.7100	2.1666	3.0000	1
353	9794	2	0	5	Q2	2012	4.7100	2.3079	3.0000	1
353	9881	3	187	2	Q1	2012	6.2800	1.9468	4.0000	1
353	9997	17	0	6	Q2	2012	4.7100	1.4601	3.0000	1
353	10031	24	0	6	Q2	2012	6.2800	2.5120	4.0000	1
353	10111	3	0	3	Q1	2012	4.7100	1.6485	3.0000	1
353	10273	17	0	7	Q3	2012	3.1400	1.5386	2.0000	1
354	323	24	1847	2	Q1	2012	4.5000	1.7550	2.0000	1
354	530	24	0	4	Q2	2012	6.7500	2.9700	3.0000	1
354	910	15	0	7	Q3	2012	9.0000	3.3300	4.0000	1
354	941	13	0	5	Q2	2012	4.5000	2.2050	2.0000	1
354	1071	13	980	3	Q1	2012	4.5000	2.1600	2.0000	1
354	1254	15	0	1	Q1	2012	9.0000	4.4100	4.0000	1
354	1436	14	0	10	Q4	2012	2.2500	0.7425	1.0000	1
354	1573	24	0	12	Q4	2012	6.7500	3.3075	3.0000	1
354	1729	11	837	10	Q4	2012	4.5000	2.2050	2.0000	1
354	2035	15	0	11	Q4	2012	9.0000	3.0600	4.0000	1
354	2110	11	0	7	Q3	2012	4.5000	1.4850	2.0000	1
354	2126	2	0	2	Q1	2012	2.2500	0.9225	1.0000	1
354	2293	7	0	5	Q2	2012	9.0000	3.4200	4.0000	1
354	2373	13	0	7	Q3	2012	6.7500	3.2400	3.0000	1
354	2466	24	1851	4	Q2	2012	6.7500	2.4300	3.0000	1
354	2695	13	0	1	Q1	2012	11.2500	4.6125	5.0000	1
354	2966	17	1293	1	Q1	2012	4.5000	1.6650	2.0000	1
354	3166	24	1845	1	Q1	2012	4.5000	1.7550	2.0000	1
354	3271	13	980	3	Q1	2012	6.7500	3.1725	3.0000	1
354	3579	7	0	7	Q3	2012	6.7500	2.3625	3.0000	1
354	4127	15	1152	9	Q3	2012	4.5000	1.8000	2.0000	1
354	4231	17	0	1	Q1	2012	11.2500	4.1625	5.0000	1
354	4397	16	1228	8	Q3	2012	4.5000	2.0700	2.0000	1
354	4470	7	0	11	Q4	2012	9.0000	2.7000	4.0000	1
354	4499	13	0	2	Q1	2012	9.0000	2.9700	4.0000	1
354	4709	22	1694	4	Q2	2012	6.7500	3.3075	3.0000	1
354	4825	6	0	12	Q4	2012	9.0000	2.8800	4.0000	1
354	5216	3	0	11	Q4	2012	4.5000	2.0250	2.0000	1
354	5354	15	0	12	Q4	2012	6.7500	2.9700	3.0000	1
354	5452	13	0	1	Q1	2012	9.0000	2.7900	4.0000	1
354	5869	13	0	7	Q3	2012	4.5000	1.6200	2.0000	1
354	5898	3	187	2	Q1	2012	6.7500	3.1725	3.0000	1
354	6420	14	1070	8	Q3	2012	4.5000	1.6200	2.0000	1
354	6703	11	0	5	Q2	2012	11.2500	4.2750	5.0000	1
354	6851	6	0	6	Q2	2012	4.5000	1.7550	2.0000	1
354	6937	11	0	11	Q4	2012	9.0000	2.9700	4.0000	1
354	7622	3	0	2	Q1	2012	6.7500	2.2950	3.0000	1
354	7639	13	0	9	Q3	2012	6.7500	2.0250	3.0000	1
354	7806	13	0	9	Q3	2012	6.7500	3.1050	3.0000	1
354	7857	15	1138	3	Q1	2012	6.7500	2.0250	3.0000	1
354	7862	16	0	12	Q4	2012	9.0000	2.9700	4.0000	1
354	7988	11	0	7	Q3	2012	6.7500	2.8350	3.0000	1
354	8181	17	0	3	Q1	2012	9.0000	2.8800	4.0000	1
354	8269	13	0	8	Q3	2012	9.0000	4.1400	4.0000	1
354	8414	17	0	4	Q2	2012	6.7500	2.7675	3.0000	1
354	8550	11	0	12	Q4	2012	4.5000	1.5750	2.0000	1
354	8551	17	0	9	Q3	2012	9.0000	3.5100	4.0000	1
354	8863	6	515	7	Q3	2012	6.7500	2.5650	3.0000	1
354	9216	15	0	9	Q3	2012	6.7500	2.9025	3.0000	1
354	9639	17	0	4	Q2	2012	6.7500	2.2275	3.0000	1
354	9900	15	1143	5	Q2	2012	9.0000	2.8800	4.0000	1
354	10213	6	502	1	Q1	2012	6.7500	2.7000	3.0000	1
355	398	13	988	7	Q3	2012	3.2400	1.1988	4.0000	1
355	1334	17	0	2	Q1	2012	1.6200	0.6966	2.0000	1
355	1470	17	0	5	Q2	2012	1.6200	0.5346	2.0000	1
355	1838	24	0	6	Q2	2012	3.2400	1.2312	4.0000	1
355	1865	6	0	6	Q2	2012	2.4300	0.7290	3.0000	1
355	2381	6	0	12	Q4	2012	1.6200	0.7614	2.0000	1
355	2381	7	0	8	Q3	2012	2.4300	0.7533	3.0000	1
355	2625	13	0	10	Q4	2012	2.4300	1.1421	3.0000	1
355	2825	11	836	9	Q3	2012	2.4300	0.7290	3.0000	1
355	2829	23	0	1	Q1	2012	3.2400	1.3932	4.0000	1
355	2991	7	523	11	Q4	2012	1.6200	0.5346	2.0000	1
355	3182	2	0	10	Q4	2012	0.8100	0.3726	1.0000	1
355	3334	17	0	12	Q4	2012	1.6200	0.6318	2.0000	1
355	3559	14	0	11	Q4	2012	1.6200	0.7128	2.0000	1
355	3587	6	0	8	Q3	2012	2.4300	0.8019	3.0000	1
355	3706	13	0	7	Q3	2012	2.4300	1.0206	3.0000	1
355	4099	17	0	7	Q3	2012	1.6200	0.6966	2.0000	1
355	4168	13	0	12	Q4	2012	1.6200	0.4860	2.0000	1
355	4180	6	523	11	Q4	2012	1.6200	0.6804	2.0000	1
355	4249	11	829	6	Q2	2012	1.6200	0.7938	2.0000	1
355	4376	24	0	3	Q1	2012	3.2400	1.3932	4.0000	1
355	5088	13	0	4	Q2	2012	3.2400	1.2960	4.0000	1
355	5125	17	0	5	Q2	2012	2.4300	0.9720	3.0000	1
355	5419	17	0	7	Q3	2012	1.6200	0.6156	2.0000	1
355	5511	7	0	5	Q2	2012	1.6200	0.5670	2.0000	1
355	5944	3	0	8	Q3	2012	1.6200	0.5994	2.0000	1
355	6647	17	0	6	Q2	2012	3.2400	1.0692	4.0000	1
355	6754	7	0	7	Q3	2012	2.4300	1.2150	3.0000	1
355	6889	15	0	4	Q2	2012	1.6200	0.6966	2.0000	1
355	7060	7	0	6	Q2	2012	2.4300	0.8991	3.0000	1
355	7072	16	0	12	Q4	2012	1.6200	0.5670	2.0000	1
355	7203	13	0	2	Q1	2012	3.2400	1.4256	4.0000	1
355	7251	15	0	11	Q4	2012	3.2400	1.3608	4.0000	1
355	7536	7	0	4	Q2	2012	2.4300	0.7533	3.0000	1
355	8161	24	0	9	Q3	2012	3.2400	1.0044	4.0000	1
355	8172	17	1303	6	Q2	2012	1.6200	0.8100	2.0000	1
355	8414	17	0	1	Q1	2012	3.2400	1.5552	4.0000	1
355	8945	23	1773	4	Q2	2012	1.6200	0.7614	2.0000	1
355	9263	16	1233	10	Q4	2012	1.6200	0.8100	2.0000	1
355	9368	15	0	11	Q4	2012	2.4300	0.9477	3.0000	1
355	9368	15	1141	4	Q2	2012	2.4300	1.0935	3.0000	1
355	9557	3	0	11	Q4	2012	2.4300	0.8991	3.0000	1
355	9891	23	0	10	Q4	2012	1.6200	0.7776	2.0000	1
355	10116	17	0	9	Q3	2012	2.4300	0.8991	3.0000	1
356	463	23	0	9	Q3	2012	4.7200	2.2656	2.0000	1
356	553	6	510	5	Q2	2012	7.0800	2.3364	3.0000	1
356	921	23	0	1	Q1	2012	9.4400	2.8320	4.0000	1
356	997	3	0	2	Q1	2012	7.0800	2.7612	3.0000	1
356	1007	11	818	1	Q1	2012	9.4400	2.9264	4.0000	1
356	1090	6	524	11	Q4	2012	7.0800	3.1152	3.0000	1
356	1388	13	0	11	Q4	2012	7.0800	3.1152	3.0000	1
356	1451	3	0	5	Q2	2012	7.0800	3.3984	3.0000	1
356	1862	17	0	6	Q2	2012	7.0800	2.1240	3.0000	1
356	2272	17	0	12	Q4	2012	9.4400	4.6256	4.0000	1
356	2988	15	0	10	Q4	2012	7.0800	3.3984	3.0000	1
356	2991	6	0	12	Q4	2012	4.7200	1.8408	2.0000	1
356	3021	16	1220	4	Q2	2012	4.7200	2.1712	2.0000	1
356	3098	15	1149	8	Q3	2012	9.4400	2.8320	4.0000	1
356	3469	24	1869	12	Q4	2012	7.0800	3.1860	3.0000	1
356	3470	17	0	6	Q2	2012	7.0800	2.2656	3.0000	1
356	3477	11	0	6	Q2	2012	9.4400	3.0208	4.0000	1
356	3763	24	0	3	Q1	2012	4.7200	2.2184	2.0000	1
356	3942	15	0	5	Q2	2012	9.4400	4.1536	4.0000	1
356	3952	6	521	10	Q4	2012	7.0800	3.1860	3.0000	1
356	4375	6	508	4	Q2	2012	9.4400	3.1152	4.0000	1
356	4606	3	0	10	Q4	2012	9.4400	3.4928	4.0000	1
356	4727	16	1233	10	Q4	2012	7.0800	2.3364	3.0000	1
356	4804	13	0	7	Q3	2012	7.0800	2.6196	3.0000	1
356	5232	7	504	2	Q1	2012	11.8000	5.4280	5.0000	1
356	5345	6	0	9	Q3	2012	7.0800	3.1152	3.0000	1
356	5567	14	0	9	Q3	2012	4.7200	1.6048	2.0000	1
356	5664	11	833	8	Q3	2012	4.7200	1.9824	2.0000	1
356	5677	22	0	9	Q3	2012	4.7200	1.5104	2.0000	1
356	5754	6	518	8	Q3	2012	7.0800	2.6904	3.0000	1
356	5760	13	0	12	Q4	2012	7.0800	2.6904	3.0000	1
356	5790	17	0	12	Q4	2012	9.4400	2.8320	4.0000	1
356	5958	13	0	6	Q2	2012	7.0800	3.1860	3.0000	1
356	5958	13	0	11	Q4	2012	7.0800	3.1860	3.0000	1
356	6057	11	0	1	Q1	2012	4.7200	2.1712	2.0000	1
356	6082	13	0	12	Q4	2012	11.8000	4.1300	5.0000	1
356	6096	7	0	5	Q2	2012	7.0800	2.2656	3.0000	1
356	6589	17	0	9	Q3	2012	7.0800	3.3984	3.0000	1
356	6657	15	0	2	Q1	2012	7.0800	2.7612	3.0000	1
356	7067	13	1000	12	Q4	2012	9.4400	4.4368	4.0000	1
356	7362	11	833	8	Q3	2012	7.0800	2.1948	3.0000	1
356	7654	15	0	11	Q4	2012	9.4400	3.7760	4.0000	1
356	7858	15	1152	9	Q3	2012	7.0800	2.1240	3.0000	1
356	7862	16	0	5	Q2	2012	9.4400	3.6816	4.0000	1
356	8094	7	0	3	Q1	2012	7.0800	3.4692	3.0000	1
356	8094	7	0	7	Q3	2012	7.0800	3.4692	3.0000	1
356	9064	17	0	10	Q4	2012	4.7200	1.9352	2.0000	1
356	9188	7	0	12	Q4	2012	7.0800	3.3276	3.0000	1
356	9279	7	0	10	Q4	2012	4.7200	1.8880	2.0000	1
356	9510	16	0	7	Q3	2012	9.4400	3.0208	4.0000	1
356	9975	24	1869	12	Q4	2012	9.4400	4.6256	4.0000	1
357	106	6	0	1	Q1	2012	7.2000	2.3760	4.0000	1
357	161	24	1856	6	Q2	2012	7.2000	2.8800	4.0000	1
357	265	11	0	9	Q3	2012	7.2000	3.0240	4.0000	1
357	570	15	1143	5	Q2	2012	7.2000	2.8080	4.0000	1
357	623	24	0	3	Q1	2012	5.4000	2.5380	3.0000	1
357	753	3	185	1	Q1	2012	5.4000	2.5920	3.0000	1
357	813	11	0	1	Q1	2012	7.2000	3.3120	4.0000	1
357	997	3	0	1	Q1	2012	5.4000	2.4300	3.0000	1
357	997	3	0	7	Q3	2012	5.4000	2.0520	3.0000	1
357	1131	15	1157	12	Q4	2012	5.4000	2.4840	3.0000	1
357	1184	14	1077	11	Q4	2012	3.6000	1.1880	2.0000	1
357	1253	13	984	5	Q2	2012	5.4000	2.0520	3.0000	1
357	1282	3	0	9	Q3	2012	7.2000	2.6640	4.0000	1
357	1378	11	0	5	Q2	2012	7.2000	3.5280	4.0000	1
357	1676	3	0	7	Q3	2012	5.4000	2.0520	3.0000	1
357	1713	6	0	6	Q2	2012	5.4000	1.7820	3.0000	1
357	1850	16	0	12	Q4	2012	5.4000	2.3760	3.0000	1
357	1915	11	0	3	Q1	2012	3.6000	1.7280	2.0000	1
357	2272	17	0	12	Q4	2012	7.2000	3.4560	4.0000	1
357	2371	16	0	5	Q2	2012	5.4000	2.4300	3.0000	1
357	2587	16	0	12	Q4	2012	3.6000	1.5480	2.0000	1
357	2587	16	1223	6	Q2	2012	5.4000	2.5920	3.0000	1
357	2715	15	0	7	Q3	2012	7.2000	2.4480	4.0000	1
357	2747	24	1869	12	Q4	2012	7.2000	2.5200	4.0000	1
357	3307	15	0	3	Q1	2012	5.4000	1.7820	3.0000	1
357	3316	6	0	11	Q4	2012	7.2000	3.2400	4.0000	1
357	3491	16	0	4	Q2	2012	3.6000	1.2240	2.0000	1
357	3567	16	0	5	Q2	2012	7.2000	2.4480	4.0000	1
357	3655	7	0	6	Q2	2012	3.6000	1.4760	2.0000	1
357	3676	3	0	7	Q3	2012	5.4000	1.9980	3.0000	1
357	3706	13	0	5	Q2	2012	5.4000	2.2680	3.0000	1
357	4258	7	521	10	Q4	2012	7.2000	3.1680	4.0000	1
357	4396	13	0	1	Q1	2012	7.2000	3.2400	4.0000	1
357	4412	2	0	12	Q4	2012	3.6000	1.6560	2.0000	1
357	4507	13	0	4	Q2	2012	5.4000	2.3760	3.0000	1
357	4567	23	0	10	Q4	2012	5.4000	2.0520	3.0000	1
357	4915	24	0	10	Q4	2012	7.2000	3.3120	4.0000	1
357	4958	23	0	2	Q1	2012	5.4000	1.6740	3.0000	1
357	5163	3	0	5	Q2	2012	3.6000	1.5840	2.0000	1
357	5834	11	0	5	Q2	2012	5.4000	1.7820	3.0000	1
357	6047	17	1314	11	Q4	2012	7.2000	3.0960	4.0000	1
357	6488	13	0	9	Q3	2012	5.4000	2.3760	3.0000	1
357	6771	15	1149	8	Q3	2012	3.6000	1.3320	2.0000	1
357	7072	16	0	8	Q3	2012	3.6000	1.2600	2.0000	1
357	7077	24	1847	2	Q1	2012	3.6000	1.5120	2.0000	1
357	7149	13	0	2	Q1	2012	7.2000	3.3120	4.0000	1
357	7281	17	0	12	Q4	2012	3.6000	1.5480	2.0000	1
357	7331	11	0	6	Q2	2012	7.2000	2.9520	4.0000	1
357	7366	3	0	3	Q1	2012	5.4000	2.4840	3.0000	1
357	7502	16	1216	2	Q1	2012	5.4000	1.7280	3.0000	1
357	8159	6	523	11	Q4	2012	7.2000	2.3760	4.0000	1
357	8199	17	0	3	Q1	2012	5.4000	1.7280	3.0000	1
357	8414	17	1303	6	Q2	2012	7.2000	3.3840	4.0000	1
357	8439	13	0	10	Q4	2012	5.4000	2.5380	3.0000	1
357	8551	17	1307	8	Q3	2012	7.2000	3.2400	4.0000	1
357	8946	23	0	3	Q1	2012	3.6000	1.5840	2.0000	1
357	9136	2	0	8	Q3	2012	1.8000	0.5940	1.0000	1
357	9487	17	1297	3	Q1	2012	5.4000	2.0520	3.0000	1
357	9631	16	0	10	Q4	2012	7.2000	3.2400	4.0000	1
357	9951	3	0	6	Q2	2012	9.0000	2.9700	5.0000	1
357	9956	17	0	9	Q3	2012	9.0000	2.9700	5.0000	1
357	10050	6	0	12	Q4	2012	7.2000	2.8080	4.0000	1
357	10064	24	0	11	Q4	2012	5.4000	1.9980	3.0000	1
358	404	7	0	10	Q4	2012	11.2500	4.2750	3.0000	1
358	849	7	517	8	Q3	2012	15.0000	4.8000	4.0000	1
358	921	23	0	7	Q3	2012	11.2500	5.4000	3.0000	1
358	1328	17	0	12	Q4	2012	7.5000	2.8500	2.0000	1
358	1528	16	1233	10	Q4	2012	11.2500	5.2875	3.0000	1
358	1706	13	0	6	Q2	2012	11.2500	3.7125	3.0000	1
358	1758	3	0	11	Q4	2012	7.5000	3.6000	2.0000	1
358	1759	7	0	10	Q4	2012	7.5000	3.1500	2.0000	1
358	1800	11	842	12	Q4	2012	15.0000	4.6500	4.0000	1
358	1896	22	0	8	Q3	2012	3.7500	1.5375	1.0000	1
358	1897	13	0	6	Q2	2012	15.0000	6.0000	4.0000	1
358	1897	13	976	1	Q1	2012	15.0000	6.0000	4.0000	1
358	1987	13	0	4	Q2	2012	11.2500	4.2750	3.0000	1
358	2035	15	0	11	Q4	2012	11.2500	4.1625	3.0000	1
358	2224	16	0	10	Q4	2012	15.0000	6.7500	4.0000	1
358	2362	7	0	12	Q4	2012	11.2500	3.7125	3.0000	1
358	2424	6	508	4	Q2	2012	15.0000	6.0000	4.0000	1
358	2530	6	0	3	Q1	2012	15.0000	6.6000	4.0000	1
358	2813	15	0	5	Q2	2012	18.7500	8.0625	5.0000	1
358	2850	3	0	9	Q3	2012	11.2500	4.6125	3.0000	1
358	2881	24	0	11	Q4	2012	15.0000	5.8500	4.0000	1
358	2921	16	1220	4	Q2	2012	11.2500	5.0625	3.0000	1
358	3196	13	0	11	Q4	2012	11.2500	5.4000	3.0000	1
358	3227	24	0	1	Q1	2012	15.0000	5.8500	4.0000	1
358	3243	13	0	11	Q4	2012	11.2500	5.0625	3.0000	1
358	3506	7	0	4	Q2	2012	11.2500	5.4000	3.0000	1
358	3660	24	0	7	Q3	2012	7.5000	2.3250	2.0000	1
358	3673	22	0	2	Q1	2012	7.5000	2.8500	2.0000	1
358	3692	16	0	5	Q2	2012	11.2500	3.6000	3.0000	1
358	3776	13	0	1	Q1	2012	11.2500	5.0625	3.0000	1
358	4029	17	0	9	Q3	2012	11.2500	4.9500	3.0000	1
358	4609	23	1789	12	Q4	2012	7.5000	3.0000	2.0000	1
358	4678	13	976	1	Q1	2012	7.5000	3.6000	2.0000	1
358	4682	15	1134	1	Q1	2012	7.5000	3.6000	2.0000	1
358	4690	13	0	11	Q4	2012	7.5000	3.5250	2.0000	1
358	4824	3	0	4	Q2	2012	18.7500	6.0000	5.0000	1
358	5038	17	0	4	Q2	2012	15.0000	4.6500	4.0000	1
358	5195	15	0	4	Q2	2012	7.5000	3.0750	2.0000	1
358	5216	3	0	7	Q3	2012	11.2500	4.7250	3.0000	1
358	5257	13	0	11	Q4	2012	11.2500	5.6250	3.0000	1
358	5346	3	0	8	Q3	2012	7.5000	3.4500	2.0000	1
358	5407	24	0	6	Q2	2012	11.2500	3.9375	3.0000	1
358	5547	7	517	8	Q3	2012	11.2500	5.6250	3.0000	1
358	5685	13	0	8	Q3	2012	15.0000	4.9500	4.0000	1
358	5887	7	0	3	Q1	2012	11.2500	3.6000	3.0000	1
358	5960	6	0	2	Q1	2012	7.5000	2.5500	2.0000	1
358	6061	17	0	9	Q3	2012	7.5000	3.7500	2.0000	1
358	6324	23	0	1	Q1	2012	18.7500	8.6250	5.0000	1
358	6454	15	0	6	Q2	2012	11.2500	3.7125	3.0000	1
358	6472	6	0	6	Q2	2012	11.2500	4.0500	3.0000	1
358	7100	17	0	6	Q2	2012	7.5000	3.2250	2.0000	1
358	7365	13	0	11	Q4	2012	7.5000	2.4750	2.0000	1
358	7526	17	0	4	Q2	2012	11.2500	5.5125	3.0000	1
358	8070	6	0	7	Q3	2012	15.0000	5.7000	4.0000	1
358	8083	24	0	10	Q4	2012	11.2500	3.6000	3.0000	1
358	8841	13	0	12	Q4	2012	7.5000	3.6000	2.0000	1
358	8936	2	0	10	Q4	2012	7.5000	3.5250	2.0000	1
358	9040	16	1216	2	Q1	2012	11.2500	5.5125	3.0000	1
358	9200	16	1214	2	Q1	2012	15.0000	5.7000	4.0000	1
358	9286	13	0	11	Q4	2012	11.2500	3.4875	3.0000	1
358	9855	6	518	8	Q3	2012	11.2500	3.6000	3.0000	1
358	10068	23	0	5	Q2	2012	15.0000	5.8500	4.0000	1
358	10133	24	1850	3	Q1	2012	11.2500	4.1625	3.0000	1
359	406	6	510	5	Q2	2012	2.6400	1.2144	2.0000	1
359	663	16	0	6	Q2	2012	5.2800	1.7952	4.0000	1
359	709	7	0	11	Q4	2012	2.6400	1.0032	2.0000	1
359	995	7	514	7	Q3	2012	3.9600	1.2276	3.0000	1
359	1802	23	1768	2	Q1	2012	3.9600	1.7424	3.0000	1
359	1901	6	0	4	Q2	2012	3.9600	1.7424	3.0000	1
359	1915	11	824	4	Q2	2012	3.9600	1.4652	3.0000	1
359	1921	15	0	8	Q3	2012	3.9600	1.5444	3.0000	1
359	1957	13	0	8	Q3	2012	2.6400	1.0560	2.0000	1
359	2112	17	0	12	Q4	2012	3.9600	1.2276	3.0000	1
359	2210	13	0	7	Q3	2012	3.9600	1.3068	3.0000	1
359	2266	7	0	6	Q2	2012	3.9600	1.7820	3.0000	1
359	2368	3	0	12	Q4	2012	3.9600	1.1880	3.0000	1
359	2378	16	0	5	Q2	2012	5.2800	2.0592	4.0000	1
359	2547	23	1768	2	Q1	2012	2.6400	1.0824	2.0000	1
359	2689	3	0	7	Q3	2012	2.6400	1.0296	2.0000	1
359	2818	6	0	4	Q2	2012	2.6400	1.0296	2.0000	1
359	2832	13	0	3	Q1	2012	3.9600	1.9008	3.0000	1
359	2832	13	0	10	Q4	2012	3.9600	1.3464	3.0000	1
359	3178	11	836	9	Q3	2012	3.9600	1.7820	3.0000	1
359	3448	3	201	8	Q3	2012	2.6400	1.2672	2.0000	1
359	3528	17	0	9	Q3	2012	5.2800	2.5872	4.0000	1
359	3539	17	0	6	Q2	2012	3.9600	1.7424	3.0000	1
359	3776	13	0	7	Q3	2012	5.2800	1.7952	4.0000	1
359	3819	23	0	8	Q3	2012	3.9600	1.8216	3.0000	1
359	4204	17	0	11	Q4	2012	5.2800	2.5344	4.0000	1
359	4315	17	0	1	Q1	2012	6.6000	2.4420	5.0000	1
359	4498	17	0	4	Q2	2012	2.6400	1.2144	2.0000	1
359	4649	17	1312	10	Q4	2012	3.9600	1.9404	3.0000	1
359	4803	23	0	11	Q4	2012	2.6400	1.2144	2.0000	1
359	4847	11	833	8	Q3	2012	2.6400	0.8448	2.0000	1
359	5374	16	1235	11	Q4	2012	5.2800	2.2704	4.0000	1
359	5449	15	0	7	Q3	2012	3.9600	1.4652	3.0000	1
359	5856	14	0	7	Q3	2012	3.9600	1.1880	3.0000	1
359	5944	3	0	3	Q1	2012	3.9600	1.5048	3.0000	1
359	6114	16	0	9	Q3	2012	3.9600	1.4256	3.0000	1
359	6114	16	1220	4	Q2	2012	5.2800	1.7952	4.0000	1
359	6388	11	0	3	Q1	2012	5.2800	2.5872	4.0000	1
359	6395	15	0	7	Q3	2012	3.9600	1.9404	3.0000	1
359	6713	13	0	3	Q1	2012	3.9600	1.7028	3.0000	1
359	7051	16	1236	12	Q4	2012	3.9600	1.1880	3.0000	1
359	7077	24	1869	12	Q4	2012	3.9600	1.9404	3.0000	1
359	7692	24	0	11	Q4	2012	2.6400	1.1088	2.0000	1
359	7951	15	0	6	Q2	2012	3.9600	1.3068	3.0000	1
359	8311	23	1771	3	Q1	2012	2.6400	1.1088	2.0000	1
359	8777	17	0	2	Q1	2012	3.9600	1.9404	3.0000	1
359	8911	24	1845	1	Q1	2012	3.9600	1.8216	3.0000	1
359	9208	15	1150	8	Q3	2012	2.6400	0.9768	2.0000	1
359	9357	6	0	7	Q3	2012	2.6400	1.1088	2.0000	1
359	9510	16	0	8	Q3	2012	5.2800	2.4288	4.0000	1
359	9570	15	1157	12	Q4	2012	6.6000	2.5740	5.0000	1
359	9734	17	0	4	Q2	2012	3.9600	1.3068	3.0000	1
359	9781	3	207	11	Q4	2012	3.9600	1.5048	3.0000	1
359	10043	22	0	12	Q4	2012	1.3200	0.5544	1.0000	1
360	36	11	0	11	Q4	2012	3.9300	1.3755	3.0000	1
360	261	24	0	3	Q1	2012	6.5500	2.1615	5.0000	1
360	323	24	1847	2	Q1	2012	5.2400	1.9388	4.0000	1
360	436	7	521	10	Q4	2012	3.9300	1.2183	3.0000	1
360	511	16	1220	4	Q2	2012	3.9300	1.6899	3.0000	1
360	530	24	0	4	Q2	2012	5.2400	2.5152	4.0000	1
360	769	16	0	1	Q1	2012	5.2400	2.3580	4.0000	1
360	1170	24	0	12	Q4	2012	6.5500	3.2095	5.0000	1
360	1418	2	0	1	Q1	2012	2.6200	1.0480	2.0000	1
360	1549	7	0	9	Q3	2012	3.9300	1.8471	3.0000	1
360	1598	3	0	6	Q2	2012	5.2400	2.5152	4.0000	1
360	1666	6	0	11	Q4	2012	5.2400	1.9388	4.0000	1
360	2194	6	513	6	Q2	2012	3.9300	1.8864	3.0000	1
360	2204	3	0	12	Q4	2012	3.9300	1.5720	3.0000	1
360	2493	17	0	4	Q2	2012	3.9300	1.6113	3.0000	1
360	2594	17	0	10	Q4	2012	3.9300	1.7685	3.0000	1
360	2695	13	0	8	Q3	2012	5.2400	2.5152	4.0000	1
360	2925	11	0	8	Q3	2012	3.9300	1.7685	3.0000	1
360	3020	13	0	4	Q2	2012	5.2400	2.4628	4.0000	1
360	3109	11	0	9	Q3	2012	5.2400	2.5676	4.0000	1
360	3133	24	1846	2	Q1	2012	2.6200	1.1790	2.0000	1
360	3297	6	506	3	Q1	2012	5.2400	2.2532	4.0000	1
360	3328	17	0	5	Q2	2012	3.9300	1.3755	3.0000	1
360	3361	24	1866	11	Q4	2012	2.6200	1.2838	2.0000	1
360	3577	11	821	3	Q1	2012	5.2400	2.5152	4.0000	1
360	3929	15	0	5	Q2	2012	5.2400	2.5676	4.0000	1
360	4021	16	0	3	Q1	2012	5.2400	1.9388	4.0000	1
360	4473	15	1157	12	Q4	2012	2.6200	1.2052	2.0000	1
360	4687	24	0	7	Q3	2012	3.9300	1.5327	3.0000	1
360	4778	3	197	6	Q2	2012	2.6200	0.8646	2.0000	1
360	4950	7	504	2	Q1	2012	5.2400	2.6200	4.0000	1
360	4988	2	126	10	Q4	2012	2.6200	0.8908	2.0000	1
360	4995	13	0	8	Q3	2012	2.6200	1.0218	2.0000	1
360	5030	24	0	12	Q4	2012	5.2400	1.9912	4.0000	1
360	5190	7	0	9	Q3	2012	5.2400	1.6768	4.0000	1
360	5295	16	0	10	Q4	2012	2.6200	0.9170	2.0000	1
360	5587	7	0	4	Q2	2012	2.6200	1.0480	2.0000	1
360	5590	17	0	11	Q4	2012	5.2400	2.5152	4.0000	1
360	5616	17	0	4	Q2	2012	3.9300	1.6506	3.0000	1
360	5696	15	1134	1	Q1	2012	5.2400	2.4104	4.0000	1
360	5834	11	0	12	Q4	2012	3.9300	1.4541	3.0000	1
360	5973	3	0	10	Q4	2012	2.6200	0.9694	2.0000	1
360	5999	23	0	1	Q1	2012	2.6200	1.2576	2.0000	1
360	6012	13	992	9	Q3	2012	3.9300	1.8078	3.0000	1
360	6207	7	517	8	Q3	2012	2.6200	0.7860	2.0000	1
360	6846	15	0	8	Q3	2012	2.6200	1.1266	2.0000	1
360	6880	15	1138	3	Q1	2012	2.6200	1.0480	2.0000	1
360	7281	17	0	10	Q4	2012	2.6200	1.1004	2.0000	1
360	7621	13	0	1	Q1	2012	2.6200	1.0742	2.0000	1
360	7715	13	0	6	Q2	2012	5.2400	2.3056	4.0000	1
360	7822	3	0	11	Q4	2012	3.9300	1.4148	3.0000	1
360	7831	17	0	12	Q4	2012	3.9300	1.4541	3.0000	1
360	8301	24	0	2	Q1	2012	2.6200	0.7860	2.0000	1
360	8454	17	0	8	Q3	2012	5.2400	2.5152	4.0000	1
360	9062	11	0	7	Q3	2012	5.2400	1.6768	4.0000	1
360	9125	13	0	6	Q2	2012	2.6200	0.8384	2.0000	1
360	9448	13	0	12	Q4	2012	3.9300	1.2183	3.0000	1
360	9510	16	0	9	Q3	2012	5.2400	1.7292	4.0000	1
360	9631	16	1216	2	Q1	2012	2.6200	0.9432	2.0000	1
360	10034	15	0	11	Q4	2012	5.2400	2.4104	4.0000	1
360	10186	13	0	1	Q1	2012	3.9300	1.6506	3.0000	1
361	346	13	0	10	Q4	2012	2.2600	1.1300	2.0000	1
361	638	11	0	3	Q1	2012	3.3900	1.4238	3.0000	1
361	654	24	0	12	Q4	2012	4.5200	2.0792	4.0000	1
361	878	3	0	1	Q1	2012	2.2600	0.9944	2.0000	1
361	976	16	0	12	Q4	2012	2.2600	0.7006	2.0000	1
361	1160	14	0	5	Q2	2012	1.1300	0.3390	1.0000	1
361	1214	11	0	3	Q1	2012	4.5200	1.9436	4.0000	1
361	1286	24	0	8	Q3	2012	2.2600	1.0170	2.0000	1
361	1738	6	0	12	Q4	2012	2.2600	1.1074	2.0000	1
361	1957	13	0	6	Q2	2012	2.2600	1.0396	2.0000	1
361	2077	23	1789	12	Q4	2012	4.5200	1.6272	4.0000	1
361	2133	24	0	3	Q1	2012	3.3900	1.1187	3.0000	1
361	2371	16	0	5	Q2	2012	2.2600	0.9040	2.0000	1
361	2647	6	0	7	Q3	2012	3.3900	1.3221	3.0000	1
361	2689	3	204	9	Q3	2012	2.2600	0.8814	2.0000	1
361	3166	24	0	11	Q4	2012	4.5200	1.4012	4.0000	1
361	3253	13	976	1	Q1	2012	2.2600	0.7232	2.0000	1
361	3306	15	0	1	Q1	2012	2.2600	0.9266	2.0000	1
361	3334	17	0	12	Q4	2012	3.3900	1.2882	3.0000	1
361	3422	23	0	10	Q4	2012	3.3900	1.0509	3.0000	1
361	3725	23	1773	4	Q2	2012	3.3900	1.1865	3.0000	1
361	3733	24	1856	6	Q2	2012	3.3900	1.0848	3.0000	1
361	3979	13	1000	12	Q4	2012	3.3900	1.2204	3.0000	1
361	4454	15	0	12	Q4	2012	3.3900	1.3221	3.0000	1
361	4503	13	992	9	Q3	2012	3.3900	1.5594	3.0000	1
361	4909	6	523	11	Q4	2012	3.3900	1.4916	3.0000	1
361	5163	3	0	5	Q2	2012	2.2600	0.9944	2.0000	1
361	5244	7	0	12	Q4	2012	4.5200	1.3560	4.0000	1
361	5295	16	0	11	Q4	2012	4.5200	1.9436	4.0000	1
361	5533	13	988	7	Q3	2012	3.3900	1.6950	3.0000	1
361	6039	13	0	4	Q2	2012	2.2600	1.0396	2.0000	1
361	6163	13	1000	12	Q4	2012	3.3900	1.3560	3.0000	1
361	6470	6	518	8	Q3	2012	2.2600	0.7684	2.0000	1
361	6518	6	502	1	Q1	2012	4.5200	2.0340	4.0000	1
361	6544	13	0	7	Q3	2012	2.2600	0.9492	2.0000	1
361	6930	24	0	7	Q3	2012	2.2600	0.7458	2.0000	1
361	7312	24	0	12	Q4	2012	4.5200	1.7176	4.0000	1
361	7433	11	0	3	Q1	2012	3.3900	1.0848	3.0000	1
361	7660	6	0	11	Q4	2012	2.2600	0.6780	2.0000	1
361	7684	7	0	1	Q1	2012	4.5200	1.7628	4.0000	1
361	7720	17	0	9	Q3	2012	3.3900	1.4916	3.0000	1
361	8007	24	0	11	Q4	2012	4.5200	1.8984	4.0000	1
361	8065	15	1154	10	Q4	2012	3.3900	1.6272	3.0000	1
361	8463	23	0	4	Q2	2012	3.3900	1.6272	3.0000	1
361	8556	11	0	7	Q3	2012	3.3900	1.5594	3.0000	1
361	8557	6	0	5	Q2	2012	2.2600	1.0848	2.0000	1
361	8794	17	0	11	Q4	2012	5.6500	2.6555	5.0000	1
361	8921	13	1000	12	Q4	2012	3.3900	1.0509	3.0000	1
361	8984	6	0	2	Q1	2012	2.2600	0.7910	2.0000	1
361	8984	6	508	4	Q2	2012	4.5200	1.4464	4.0000	1
361	9029	3	0	12	Q4	2012	2.2600	0.8814	2.0000	1
361	9029	3	201	8	Q3	2012	3.3900	1.4916	3.0000	1
361	9528	6	0	6	Q2	2012	2.2600	1.1074	2.0000	1
361	9697	23	1783	9	Q3	2012	3.3900	1.0509	3.0000	1
361	9812	13	0	11	Q4	2012	3.3900	1.4238	3.0000	1
361	9866	3	201	8	Q3	2012	3.3900	1.0509	3.0000	1
361	10168	15	0	12	Q4	2012	4.5200	1.4916	4.0000	1
362	502	15	0	6	Q2	2012	7.9400	3.6524	2.0000	1
362	569	23	0	10	Q4	2012	11.9100	5.5977	3.0000	1
362	710	15	1146	7	Q3	2012	11.9100	5.1213	3.0000	1
362	1282	3	201	8	Q3	2012	15.8800	5.8756	4.0000	1
362	1429	13	0	4	Q2	2012	7.9400	2.6202	2.0000	1
362	1481	15	0	9	Q3	2012	11.9100	5.2404	3.0000	1
362	1531	6	511	5	Q2	2012	11.9100	3.9303	3.0000	1
362	1811	11	0	1	Q1	2012	11.9100	3.6921	3.0000	1
362	2298	3	0	5	Q2	2012	15.8800	6.9872	4.0000	1
362	2298	3	210	12	Q4	2012	11.9100	4.5258	3.0000	1
362	2570	16	0	12	Q4	2012	11.9100	5.0022	3.0000	1
362	2625	13	0	7	Q3	2012	7.9400	2.8584	2.0000	1
362	2981	23	1772	4	Q2	2012	15.8800	6.1932	4.0000	1
362	3175	7	0	4	Q2	2012	11.9100	5.2404	3.0000	1
362	3201	11	0	5	Q2	2012	11.9100	3.8112	3.0000	1
362	3219	11	0	12	Q4	2012	11.9100	5.8359	3.0000	1
362	3423	13	0	3	Q1	2012	7.9400	3.6524	2.0000	1
362	3878	3	0	5	Q2	2012	15.8800	6.5108	4.0000	1
362	3889	3	207	11	Q4	2012	15.8800	7.7812	4.0000	1
362	3946	6	515	7	Q3	2012	15.8800	5.8756	4.0000	1
362	4338	6	521	10	Q4	2012	11.9100	5.7168	3.0000	1
362	4420	11	0	4	Q2	2012	15.8800	6.9872	4.0000	1
362	4423	13	982	4	Q2	2012	15.8800	6.1932	4.0000	1
362	4445	17	1314	11	Q4	2012	11.9100	3.9303	3.0000	1
362	4471	11	0	12	Q4	2012	15.8800	6.9872	4.0000	1
362	4548	6	0	6	Q2	2012	11.9100	4.0494	3.0000	1
362	4633	7	0	5	Q2	2012	7.9400	2.3820	2.0000	1
362	4868	16	1228	8	Q3	2012	15.8800	4.9228	4.0000	1
362	5038	17	1293	1	Q1	2012	11.9100	3.6921	3.0000	1
362	5374	16	0	9	Q3	2012	11.9100	5.3595	3.0000	1
362	5504	14	0	7	Q3	2012	3.9700	1.9056	1.0000	1
362	5647	15	1142	5	Q2	2012	7.9400	3.9700	2.0000	1
362	5707	23	1781	8	Q3	2012	11.9100	5.1213	3.0000	1
362	5875	11	820	2	Q1	2012	11.9100	3.6921	3.0000	1
362	5905	15	0	11	Q4	2012	11.9100	4.5258	3.0000	1
362	6091	24	0	3	Q1	2012	7.9400	3.1760	2.0000	1
362	6147	7	0	11	Q4	2012	11.9100	5.3595	3.0000	1
362	6307	16	0	9	Q3	2012	15.8800	5.2404	4.0000	1
362	6324	23	1768	2	Q1	2012	19.8500	9.1310	5.0000	1
362	6453	24	1869	12	Q4	2012	11.9100	3.5730	3.0000	1
362	6745	7	0	6	Q2	2012	7.9400	3.4142	2.0000	1
362	6893	7	514	7	Q3	2012	11.9100	5.2404	3.0000	1
362	6967	24	1845	1	Q1	2012	15.8800	6.1932	4.0000	1
362	7052	23	0	5	Q2	2012	11.9100	4.8831	3.0000	1
362	7282	17	0	8	Q3	2012	11.9100	5.4786	3.0000	1
362	7324	6	504	2	Q1	2012	11.9100	5.9550	3.0000	1
362	7404	6	508	4	Q2	2012	11.9100	5.0022	3.0000	1
362	7529	17	1312	10	Q4	2012	7.9400	2.5408	2.0000	1
362	7556	17	0	3	Q1	2012	19.8500	7.5430	5.0000	1
362	7558	13	0	8	Q3	2012	11.9100	5.3595	3.0000	1
362	7667	6	0	6	Q2	2012	11.9100	3.9303	3.0000	1
362	7743	3	0	10	Q4	2012	7.9400	2.6202	2.0000	1
362	7975	6	0	12	Q4	2012	11.9100	3.6921	3.0000	1
362	8070	6	0	11	Q4	2012	7.9400	3.0966	2.0000	1
362	8092	15	1142	5	Q2	2012	11.9100	3.5730	3.0000	1
362	8500	17	0	1	Q1	2012	11.9100	4.2876	3.0000	1
362	8572	2	0	12	Q4	2012	7.9400	2.4614	2.0000	1
362	9051	24	0	11	Q4	2012	15.8800	7.6224	4.0000	1
362	9181	24	0	4	Q2	2012	15.8800	7.9400	4.0000	1
362	9487	17	0	12	Q4	2012	11.9100	3.6921	3.0000	1
362	9499	6	0	3	Q1	2012	11.9100	5.4786	3.0000	1
362	9542	14	0	2	Q1	2012	3.9700	1.2307	1.0000	1
362	9550	6	526	12	Q4	2012	11.9100	5.3595	3.0000	1
362	9745	17	1314	11	Q4	2012	11.9100	5.4786	3.0000	1
362	9801	11	0	9	Q3	2012	11.9100	4.5258	3.0000	1
362	9812	13	0	3	Q1	2012	11.9100	3.9303	3.0000	1
362	9866	3	199	7	Q3	2012	7.9400	3.7318	2.0000	1
362	10166	11	0	5	Q2	2012	7.9400	3.3348	2.0000	1
362	10205	6	0	8	Q3	2012	11.9100	4.0494	3.0000	1
363	1053	13	0	10	Q4	2012	3.6400	1.4560	2.0000	1
363	1142	13	0	11	Q4	2012	3.6400	1.5288	2.0000	1
363	1193	13	0	11	Q4	2012	3.6400	1.7836	2.0000	1
363	1210	6	0	2	Q1	2012	5.4600	2.0748	3.0000	1
363	1249	15	0	2	Q1	2012	3.6400	1.1648	2.0000	1
363	1297	16	0	8	Q3	2012	5.4600	1.6380	3.0000	1
363	1388	13	0	11	Q4	2012	7.2800	3.4944	4.0000	1
363	2189	7	0	3	Q1	2012	3.6400	1.7472	2.0000	1
363	2252	15	0	6	Q2	2012	5.4600	1.8018	3.0000	1
363	2429	7	518	8	Q3	2012	5.4600	2.0748	3.0000	1
363	2553	16	0	10	Q4	2012	5.4600	1.9656	3.0000	1
363	2968	13	0	4	Q2	2012	7.2800	2.4024	4.0000	1
363	3081	24	0	6	Q2	2012	7.2800	2.3296	4.0000	1
363	3204	24	0	6	Q2	2012	5.4600	2.0748	3.0000	1
363	3213	13	0	4	Q2	2012	5.4600	2.6208	3.0000	1
363	3242	3	0	9	Q3	2012	5.4600	1.6926	3.0000	1
363	3418	3	0	6	Q2	2012	3.6400	1.3468	2.0000	1
363	3639	24	0	5	Q2	2012	7.2800	3.1304	4.0000	1
363	3719	23	0	12	Q4	2012	3.6400	1.5288	2.0000	1
363	3889	3	188	2	Q1	2012	3.6400	1.5288	2.0000	1
363	4096	3	190	3	Q1	2012	5.4600	2.0202	3.0000	1
363	4340	17	0	5	Q2	2012	5.4600	2.6754	3.0000	1
363	4460	3	0	5	Q2	2012	7.2800	2.1840	4.0000	1
363	4518	13	0	3	Q1	2012	7.2800	2.4752	4.0000	1
363	4543	13	0	7	Q3	2012	3.6400	1.6380	2.0000	1
363	4564	17	0	4	Q2	2012	3.6400	1.6744	2.0000	1
363	5297	7	505	2	Q1	2012	5.4600	2.3478	3.0000	1
363	5438	24	0	8	Q3	2012	5.4600	2.2386	3.0000	1
363	5924	13	0	3	Q1	2012	5.4600	2.0748	3.0000	1
363	6114	16	0	9	Q3	2012	3.6400	1.6380	2.0000	1
363	6268	24	0	4	Q2	2012	5.4600	2.2386	3.0000	1
363	6666	17	0	2	Q1	2012	7.2800	2.9848	4.0000	1
363	6815	6	0	5	Q2	2012	3.6400	1.1648	2.0000	1
363	6948	24	0	9	Q3	2012	3.6400	1.4560	2.0000	1
363	7137	11	0	12	Q4	2012	5.4600	1.9656	3.0000	1
363	7167	14	0	5	Q2	2012	3.6400	1.5288	2.0000	1
363	7413	3	210	12	Q4	2012	5.4600	1.8564	3.0000	1
363	7416	13	0	7	Q3	2012	5.4600	2.5116	3.0000	1
363	7862	16	0	4	Q2	2012	7.2800	3.2032	4.0000	1
363	8003	3	0	11	Q4	2012	7.2800	2.2568	4.0000	1
363	8247	6	0	10	Q4	2012	3.6400	1.5288	2.0000	1
363	8947	3	201	8	Q3	2012	3.6400	1.1648	2.0000	1
363	8976	13	0	2	Q1	2012	7.2800	2.1840	4.0000	1
363	9064	17	0	5	Q2	2012	5.4600	2.6754	3.0000	1
363	9263	16	0	5	Q2	2012	5.4600	2.5116	3.0000	1
363	9293	24	0	4	Q2	2012	3.6400	1.6744	2.0000	1
363	9309	17	0	10	Q4	2012	7.2800	2.8392	4.0000	1
363	9512	23	0	7	Q3	2012	5.4600	1.8018	3.0000	1
363	9779	7	519	9	Q3	2012	3.6400	1.3104	2.0000	1
363	9851	3	0	6	Q2	2012	3.6400	1.7472	2.0000	1
363	10031	24	0	9	Q3	2012	7.2800	2.6936	4.0000	1
364	251	24	1851	4	Q2	2012	6.6000	2.3100	3.0000	1
364	325	15	0	2	Q1	2012	6.6000	3.0360	3.0000	1
364	511	16	0	11	Q4	2012	6.6000	2.0460	3.0000	1
364	647	3	0	2	Q1	2012	6.6000	3.2340	3.0000	1
364	817	17	0	8	Q3	2012	6.6000	2.2440	3.0000	1
364	992	7	0	12	Q4	2012	11.0000	3.9600	5.0000	1
364	1491	16	0	1	Q1	2012	4.4000	1.4960	2.0000	1
364	1583	15	0	3	Q1	2012	8.8000	3.2560	4.0000	1
364	1610	3	0	8	Q3	2012	6.6000	2.8380	3.0000	1
364	1729	11	837	10	Q4	2012	8.8000	2.6400	4.0000	1
364	1850	16	1235	11	Q4	2012	6.6000	2.9700	3.0000	1
364	1965	17	1294	2	Q1	2012	6.6000	3.3000	3.0000	1
364	2059	17	1292	1	Q1	2012	4.4000	1.4080	2.0000	1
364	2159	14	0	5	Q2	2012	4.4000	1.4520	2.0000	1
364	2430	24	0	5	Q2	2012	6.6000	2.9700	3.0000	1
364	2587	16	0	4	Q2	2012	6.6000	2.5740	3.0000	1
364	2587	16	0	9	Q3	2012	6.6000	2.9040	3.0000	1
364	2636	17	0	5	Q2	2012	4.4000	1.3640	2.0000	1
364	2723	3	0	12	Q4	2012	8.8000	3.1680	4.0000	1
364	3434	24	0	5	Q2	2012	6.6000	2.9700	3.0000	1
364	3441	3	0	7	Q3	2012	8.8000	2.8160	4.0000	1
364	3484	14	0	7	Q3	2012	2.2000	0.9240	1.0000	1
364	3688	24	0	9	Q3	2012	6.6000	2.0460	3.0000	1
364	3748	13	0	7	Q3	2012	11.0000	5.0600	5.0000	1
364	4029	17	0	9	Q3	2012	8.8000	3.8720	4.0000	1
364	4105	3	205	10	Q4	2012	6.6000	3.0360	3.0000	1
364	4118	17	0	11	Q4	2012	4.4000	1.4080	2.0000	1
364	4261	13	0	1	Q1	2012	8.8000	3.3440	4.0000	1
364	4401	11	0	1	Q1	2012	6.6000	2.3760	3.0000	1
364	4443	11	0	1	Q1	2012	4.4000	2.1560	2.0000	1
364	4468	11	841	12	Q4	2012	8.8000	4.0480	4.0000	1
364	4566	11	0	12	Q4	2012	8.8000	4.0480	4.0000	1
364	4609	23	0	2	Q1	2012	4.4000	1.7160	2.0000	1
364	4928	13	0	10	Q4	2012	6.6000	2.0460	3.0000	1
364	5002	23	0	8	Q3	2012	6.6000	2.5080	3.0000	1
364	5095	6	0	7	Q3	2012	8.8000	4.0480	4.0000	1
364	5419	17	1312	10	Q4	2012	4.4000	1.3200	2.0000	1
364	5644	17	0	4	Q2	2012	6.6000	2.7720	3.0000	1
364	5844	17	0	4	Q2	2012	6.6000	3.1020	3.0000	1
364	6138	17	0	8	Q3	2012	6.6000	2.8380	3.0000	1
364	6544	13	0	12	Q4	2012	4.4000	1.6720	2.0000	1
364	6854	17	0	2	Q1	2012	4.4000	1.6280	2.0000	1
364	7141	17	0	7	Q3	2012	6.6000	3.2340	3.0000	1
364	7141	17	0	12	Q4	2012	6.6000	3.2340	3.0000	1
364	7283	13	0	1	Q1	2012	4.4000	1.8480	2.0000	1
364	7439	7	0	10	Q4	2012	6.6000	2.4420	3.0000	1
364	7493	24	0	2	Q1	2012	6.6000	1.9800	3.0000	1
364	7580	17	1314	11	Q4	2012	4.4000	2.1560	2.0000	1
364	7810	3	0	6	Q2	2012	11.0000	3.8500	5.0000	1
364	7925	14	0	4	Q2	2012	2.2000	1.0560	1.0000	1
364	8003	3	0	4	Q2	2012	8.8000	2.8160	4.0000	1
364	8435	17	0	6	Q2	2012	4.4000	1.5840	2.0000	1
364	8902	3	0	4	Q2	2012	4.4000	1.4080	2.0000	1
364	9393	24	1866	11	Q4	2012	4.4000	2.0680	2.0000	1
364	9401	13	0	8	Q3	2012	4.4000	1.5840	2.0000	1
364	9401	13	0	9	Q3	2012	6.6000	3.2340	3.0000	1
364	9503	24	1856	6	Q2	2012	8.8000	3.3440	4.0000	1
364	9623	15	0	8	Q3	2012	6.6000	2.3760	3.0000	1
364	9823	13	0	7	Q3	2012	6.6000	3.0360	3.0000	1
364	9897	16	1225	7	Q3	2012	4.4000	1.7160	2.0000	1
364	10147	7	0	10	Q4	2012	11.0000	4.4000	5.0000	1
364	10186	13	0	1	Q1	2012	6.6000	2.3100	3.0000	1
365	336	6	0	6	Q2	2012	7.9200	2.7720	2.0000	1
365	778	15	1138	3	Q1	2012	7.9200	3.0888	2.0000	1
365	964	7	501	1	Q1	2012	15.8400	6.0192	4.0000	1
365	1185	17	0	11	Q4	2012	15.8400	6.9696	4.0000	1
365	1316	7	516	8	Q3	2012	15.8400	7.7616	4.0000	1
365	1334	17	0	8	Q3	2012	15.8400	5.3856	4.0000	1
365	1754	11	0	5	Q2	2012	11.8800	5.3460	3.0000	1
365	2355	3	0	2	Q1	2012	7.9200	3.7224	2.0000	1
365	2609	7	523	11	Q4	2012	7.9200	3.3264	2.0000	1
365	2818	6	0	4	Q2	2012	11.8800	4.5144	3.0000	1
365	3442	3	0	11	Q4	2012	15.8400	6.3360	4.0000	1
365	3579	7	0	7	Q3	2012	15.8400	6.1776	4.0000	1
365	3632	7	0	1	Q1	2012	19.8000	9.7020	5.0000	1
365	4065	3	207	11	Q4	2012	7.9200	2.8512	2.0000	1
365	4570	2	0	12	Q4	2012	7.9200	3.6432	2.0000	1
365	4670	17	0	9	Q3	2012	7.9200	3.0888	2.0000	1
365	4691	17	0	11	Q4	2012	7.9200	3.2472	2.0000	1
365	5107	7	0	9	Q3	2012	15.8400	4.9104	4.0000	1
365	5118	11	0	4	Q2	2012	7.9200	2.5344	2.0000	1
365	5405	11	837	10	Q4	2012	15.8400	4.9104	4.0000	1
365	5694	11	829	6	Q2	2012	15.8400	6.6528	4.0000	1
365	5901	24	1845	1	Q1	2012	11.8800	4.2768	3.0000	1
365	6035	24	0	7	Q3	2012	15.8400	6.4944	4.0000	1
365	6760	17	0	1	Q1	2012	11.8800	4.9896	3.0000	1
365	6982	13	0	12	Q4	2012	7.9200	3.0888	2.0000	1
365	7056	3	0	6	Q2	2012	15.8400	6.0192	4.0000	1
365	7141	17	0	3	Q1	2012	19.8000	7.9200	5.0000	1
365	7206	7	504	2	Q1	2012	7.9200	3.7224	2.0000	1
365	7234	16	0	5	Q2	2012	15.8400	5.8608	4.0000	1
365	7502	16	1236	12	Q4	2012	11.8800	5.3460	3.0000	1
365	7541	24	0	12	Q4	2012	7.9200	3.4056	2.0000	1
365	7569	13	992	9	Q3	2012	11.8800	4.2768	3.0000	1
365	7720	17	0	9	Q3	2012	11.8800	3.9204	3.0000	1
365	7731	6	0	9	Q3	2012	15.8400	6.6528	4.0000	1
365	7920	17	1303	6	Q2	2012	11.8800	5.4648	3.0000	1
365	8003	3	195	5	Q2	2012	11.8800	3.9204	3.0000	1
365	8026	22	1698	6	Q2	2012	7.9200	2.7720	2.0000	1
365	8089	17	0	7	Q3	2012	11.8800	4.0392	3.0000	1
365	8241	17	0	7	Q3	2012	11.8800	3.8016	3.0000	1
365	8298	13	980	3	Q1	2012	11.8800	4.5144	3.0000	1
365	8318	24	0	3	Q1	2012	7.9200	3.8016	2.0000	1
365	8556	11	0	7	Q3	2012	11.8800	5.3460	3.0000	1
365	8619	13	0	8	Q3	2012	15.8400	6.1776	4.0000	1
365	8653	3	0	8	Q3	2012	11.8800	3.9204	3.0000	1
365	8911	24	1845	1	Q1	2012	15.8400	6.0192	4.0000	1
365	8945	23	0	10	Q4	2012	11.8800	5.3460	3.0000	1
365	9123	3	0	8	Q3	2012	11.8800	5.2272	3.0000	1
365	9275	7	0	4	Q2	2012	7.9200	3.4056	2.0000	1
365	9673	13	0	2	Q1	2012	7.9200	3.6432	2.0000	1
365	9823	13	980	3	Q1	2012	11.8800	4.2768	3.0000	1
365	9959	7	0	9	Q3	2012	7.9200	3.3264	2.0000	1
365	9979	6	0	12	Q4	2012	19.8000	6.5340	5.0000	1
365	10274	6	0	5	Q2	2012	15.8400	6.3360	4.0000	1
366	99	3	0	11	Q4	2012	9.4400	3.7760	4.0000	1
366	424	7	0	7	Q3	2012	7.0800	3.2568	3.0000	1
366	817	17	1307	8	Q3	2012	7.0800	2.4072	3.0000	1
366	950	13	0	5	Q2	2012	11.8000	3.7760	5.0000	1
366	1271	13	0	1	Q1	2012	4.7200	2.3128	2.0000	1
366	1493	2	0	1	Q1	2012	4.7200	1.6992	2.0000	1
366	1539	6	518	8	Q3	2012	7.0800	2.6904	3.0000	1
366	1744	17	0	12	Q4	2012	9.4400	4.4368	4.0000	1
366	1808	24	1846	2	Q1	2012	7.0800	3.2568	3.0000	1
366	1813	17	0	4	Q2	2012	9.4400	4.5312	4.0000	1
366	2263	11	0	3	Q1	2012	7.0800	3.1860	3.0000	1
366	2511	17	0	6	Q2	2012	9.4400	4.2480	4.0000	1
366	2547	23	0	11	Q4	2012	4.7200	1.9352	2.0000	1
366	2675	6	0	9	Q3	2012	4.7200	1.5104	2.0000	1
366	2694	24	0	11	Q4	2012	7.0800	3.1860	3.0000	1
366	2742	17	0	6	Q2	2012	7.0800	2.6196	3.0000	1
366	3466	15	1152	9	Q3	2012	7.0800	3.5400	3.0000	1
366	3932	15	0	10	Q4	2012	9.4400	3.6816	4.0000	1
366	4004	13	0	12	Q4	2012	9.4400	3.5872	4.0000	1
366	4096	3	0	7	Q3	2012	7.0800	3.2568	3.0000	1
366	4180	7	0	7	Q3	2012	11.8000	4.3660	5.0000	1
366	4342	13	0	5	Q2	2012	7.0800	3.2568	3.0000	1
366	4369	15	0	11	Q4	2012	7.0800	3.1860	3.0000	1
366	4392	6	0	9	Q3	2012	4.7200	1.5104	2.0000	1
366	4402	11	0	9	Q3	2012	7.0800	2.6904	3.0000	1
366	4473	15	0	7	Q3	2012	9.4400	4.6256	4.0000	1
366	4691	17	0	5	Q2	2012	7.0800	2.1948	3.0000	1
366	4925	16	0	4	Q2	2012	7.0800	2.7612	3.0000	1
366	4938	13	0	8	Q3	2012	9.4400	4.3424	4.0000	1
366	5726	15	0	6	Q2	2012	7.0800	2.6904	3.0000	1
366	5746	15	1134	1	Q1	2012	7.0800	2.8320	3.0000	1
366	5869	13	0	6	Q2	2012	9.4400	3.1152	4.0000	1
366	5973	3	187	2	Q1	2012	7.0800	2.8320	3.0000	1
366	6113	16	0	8	Q3	2012	7.0800	3.3276	3.0000	1
366	6348	16	0	4	Q2	2012	4.7200	1.8880	2.0000	1
366	6560	17	0	10	Q4	2012	7.0800	2.9736	3.0000	1
366	6599	22	0	4	Q2	2012	4.7200	2.2656	2.0000	1
366	6844	11	826	5	Q2	2012	4.7200	2.1712	2.0000	1
366	6932	13	0	5	Q2	2012	7.0800	3.3984	3.0000	1
366	7141	17	0	9	Q3	2012	7.0800	2.6196	3.0000	1
366	7341	24	1845	1	Q1	2012	9.4400	3.5872	4.0000	1
366	7363	7	0	10	Q4	2012	7.0800	2.9736	3.0000	1
366	7702	16	1214	2	Q1	2012	7.0800	2.4072	3.0000	1
366	7831	17	0	4	Q2	2012	9.4400	3.0208	4.0000	1
366	7831	17	0	5	Q2	2012	7.0800	2.2656	3.0000	1
366	7851	7	0	12	Q4	2012	9.4400	2.9264	4.0000	1
366	8096	7	0	3	Q1	2012	7.0800	2.5488	3.0000	1
366	8165	15	0	11	Q4	2012	9.4400	3.3984	4.0000	1
366	8541	15	0	5	Q2	2012	4.7200	2.0296	2.0000	1
366	8945	23	0	6	Q2	2012	4.7200	2.1240	2.0000	1
366	8970	22	0	11	Q4	2012	4.7200	1.4632	2.0000	1
366	8994	17	1303	6	Q2	2012	4.7200	2.2656	2.0000	1
366	9263	16	1233	10	Q4	2012	9.4400	2.8320	4.0000	1
366	9355	6	0	7	Q3	2012	7.0800	3.4692	3.0000	1
366	9643	13	0	5	Q2	2012	7.0800	3.1860	3.0000	1
366	9691	15	0	11	Q4	2012	4.7200	2.1712	2.0000	1
366	9851	3	207	11	Q4	2012	4.7200	2.3128	2.0000	1
366	10144	7	504	2	Q1	2012	7.0800	2.5488	3.0000	1
367	106	6	0	1	Q1	2012	13.9600	6.7008	4.0000	1
367	430	16	0	10	Q4	2012	10.4700	3.5598	3.0000	1
367	593	7	0	10	Q4	2012	10.4700	3.7692	3.0000	1
367	760	3	0	7	Q3	2012	10.4700	5.0256	3.0000	1
367	1297	16	0	4	Q2	2012	13.9600	4.1880	4.0000	1
367	1313	15	0	7	Q3	2012	10.4700	4.7115	3.0000	1
367	1599	6	0	11	Q4	2012	6.9800	2.6524	2.0000	1
367	1872	7	0	4	Q2	2012	13.9600	6.0028	4.0000	1
367	1906	7	526	12	Q4	2012	10.4700	4.0833	3.0000	1
367	2320	2	0	6	Q2	2012	6.9800	2.1638	2.0000	1
367	2570	16	0	12	Q4	2012	10.4700	4.3974	3.0000	1
367	2610	6	0	11	Q4	2012	6.9800	2.7222	2.0000	1
367	2648	24	0	2	Q1	2012	10.4700	3.7692	3.0000	1
367	2689	3	0	8	Q3	2012	6.9800	2.7920	2.0000	1
367	2747	24	1869	12	Q4	2012	17.4500	6.8055	5.0000	1
367	2878	3	0	4	Q2	2012	13.9600	4.6068	4.0000	1
367	3068	11	0	3	Q1	2012	13.9600	6.2820	4.0000	1
367	3170	6	0	2	Q1	2012	6.9800	3.0712	2.0000	1
367	3236	15	1154	10	Q4	2012	13.9600	6.8404	4.0000	1
367	3236	15	1157	12	Q4	2012	17.4500	8.3760	5.0000	1
367	3404	24	1856	6	Q2	2012	10.4700	3.9786	3.0000	1
367	3627	3	197	6	Q2	2012	6.9800	2.7920	2.0000	1
367	3883	2	129	11	Q4	2012	3.4900	1.3262	1.0000	1
367	3921	23	0	11	Q4	2012	13.9600	6.7008	4.0000	1
367	4468	11	0	1	Q1	2012	6.9800	3.4900	2.0000	1
367	4767	16	0	6	Q2	2012	10.4700	4.6068	3.0000	1
367	4900	13	0	11	Q4	2012	6.9800	2.8618	2.0000	1
367	5060	13	984	5	Q2	2012	10.4700	3.5598	3.0000	1
367	5134	3	0	11	Q4	2012	10.4700	4.1880	3.0000	1
367	5368	24	0	11	Q4	2012	10.4700	4.6068	3.0000	1
367	5374	16	0	5	Q2	2012	10.4700	3.7692	3.0000	1
367	5944	3	0	5	Q2	2012	10.4700	5.0256	3.0000	1
367	6061	17	0	12	Q4	2012	10.4700	4.7115	3.0000	1
367	6442	7	0	7	Q3	2012	10.4700	4.7115	3.0000	1
367	7066	14	0	3	Q1	2012	3.4900	1.1517	1.0000	1
367	7141	17	0	10	Q4	2012	6.9800	3.4900	2.0000	1
367	7236	24	0	3	Q1	2012	6.9800	3.4202	2.0000	1
367	7570	13	0	7	Q3	2012	10.4700	4.8162	3.0000	1
367	7662	24	1869	12	Q4	2012	13.9600	6.4216	4.0000	1
367	7905	13	0	11	Q4	2012	10.4700	3.8739	3.0000	1
367	7956	14	0	4	Q2	2012	6.9800	2.3732	2.0000	1
367	8403	11	0	3	Q1	2012	10.4700	4.9209	3.0000	1
367	9786	24	1853	5	Q2	2012	17.4500	5.4095	5.0000	1
367	10168	15	1136	2	Q1	2012	10.4700	3.4551	3.0000	1
368	317	15	1140	4	Q2	2012	3.4200	1.0260	3.0000	1
368	354	23	0	1	Q1	2012	4.5600	1.6416	4.0000	1
368	663	16	0	8	Q3	2012	3.4200	1.4364	3.0000	1
368	750	13	0	12	Q4	2012	3.4200	1.3338	3.0000	1
368	887	14	0	6	Q2	2012	1.1400	0.3648	1.0000	1
368	1175	6	508	4	Q2	2012	4.5600	1.7328	4.0000	1
368	1297	16	0	2	Q1	2012	5.7000	1.8240	5.0000	1
368	1491	16	1231	9	Q3	2012	2.2800	0.7296	2.0000	1
368	1720	16	0	1	Q1	2012	5.7000	2.6220	5.0000	1
368	2373	13	0	1	Q1	2012	3.4200	1.3338	3.0000	1
368	2441	17	0	12	Q4	2012	3.4200	1.4706	3.0000	1
368	2483	24	0	1	Q1	2012	4.5600	1.8696	4.0000	1
368	3163	7	0	3	Q1	2012	4.5600	1.9608	4.0000	1
368	3218	3	0	5	Q2	2012	4.5600	1.5048	4.0000	1
368	3233	6	0	4	Q2	2012	2.2800	0.8892	2.0000	1
368	3288	3	0	4	Q2	2012	3.4200	1.3338	3.0000	1
368	3305	13	0	3	Q1	2012	3.4200	1.6416	3.0000	1
368	3319	11	0	7	Q3	2012	3.4200	1.5048	3.0000	1
368	3321	24	0	10	Q4	2012	4.5600	1.4592	4.0000	1
368	3405	14	0	5	Q2	2012	1.1400	0.4788	1.0000	1
368	3458	24	0	11	Q4	2012	5.7000	1.8240	5.0000	1
368	3463	13	0	2	Q1	2012	3.4200	1.4022	3.0000	1
368	3907	24	0	10	Q4	2012	3.4200	1.6416	3.0000	1
368	4249	11	0	4	Q2	2012	4.5600	2.2344	4.0000	1
368	4364	17	0	10	Q4	2012	4.5600	1.5960	4.0000	1
368	4422	6	0	12	Q4	2012	3.4200	1.1286	3.0000	1
368	4926	6	521	10	Q4	2012	4.5600	1.8240	4.0000	1
368	4951	15	0	6	Q2	2012	3.4200	1.3338	3.0000	1
368	4958	23	1778	7	Q3	2012	2.2800	0.7752	2.0000	1
368	4964	2	0	12	Q4	2012	1.1400	0.3876	1.0000	1
368	5188	2	112	3	Q1	2012	3.4200	1.5732	3.0000	1
368	5358	3	0	11	Q4	2012	4.5600	1.6872	4.0000	1
368	5358	3	205	10	Q4	2012	3.4200	1.5390	3.0000	1
368	5511	7	504	2	Q1	2012	4.5600	1.9152	4.0000	1
368	5945	7	0	7	Q3	2012	3.4200	1.6074	3.0000	1
368	5999	23	0	6	Q2	2012	3.4200	1.7100	3.0000	1
368	6009	11	0	7	Q3	2012	4.5600	2.1432	4.0000	1
368	6223	7	0	7	Q3	2012	4.5600	2.0520	4.0000	1
368	6355	6	0	9	Q3	2012	3.4200	1.6416	3.0000	1
368	6355	7	0	12	Q4	2012	3.4200	1.0602	3.0000	1
368	6560	17	0	7	Q3	2012	3.4200	1.4364	3.0000	1
368	6832	3	185	1	Q1	2012	2.2800	0.9576	2.0000	1
368	7275	17	0	9	Q3	2012	3.4200	1.6758	3.0000	1
368	7275	17	1303	6	Q2	2012	2.2800	0.8664	2.0000	1
368	7348	11	0	5	Q2	2012	2.2800	1.0488	2.0000	1
368	7655	17	0	5	Q2	2012	2.2800	0.8208	2.0000	1
368	7702	16	0	2	Q1	2012	3.4200	1.5390	3.0000	1
368	8418	22	0	7	Q3	2012	1.1400	0.3762	1.0000	1
368	8944	14	0	12	Q4	2012	2.2800	1.0716	2.0000	1
368	8969	6	0	7	Q3	2012	4.5600	2.2344	4.0000	1
368	9236	13	0	1	Q1	2012	2.2800	0.8664	2.0000	1
368	9533	24	0	5	Q2	2012	3.4200	1.2996	3.0000	1
368	9667	23	0	3	Q1	2012	3.4200	1.1286	3.0000	1
368	9721	15	1146	7	Q3	2012	3.4200	1.4706	3.0000	1
368	9863	13	0	3	Q1	2012	3.4200	1.2312	3.0000	1
368	10120	7	0	6	Q2	2012	3.4200	1.2312	3.0000	1
368	10227	15	1143	5	Q2	2012	4.5600	2.0976	4.0000	1
369	21	15	1138	3	Q1	2012	4.6000	2.0700	2.0000	1
369	973	24	0	8	Q3	2012	6.9000	2.4840	3.0000	1
369	1193	13	0	8	Q3	2012	4.6000	2.1160	2.0000	1
369	1271	13	0	3	Q1	2012	4.6000	1.8860	2.0000	1
369	1491	16	0	11	Q4	2012	4.6000	1.5640	2.0000	1
369	1683	6	504	2	Q1	2012	6.9000	2.2770	3.0000	1
369	1720	16	1225	7	Q3	2012	9.2000	2.7600	4.0000	1
369	2077	23	0	9	Q3	2012	4.6000	1.4260	2.0000	1
369	2129	6	0	11	Q4	2012	6.9000	2.7600	3.0000	1
369	2245	11	826	5	Q2	2012	6.9000	3.1050	3.0000	1
369	2263	11	0	10	Q4	2012	9.2000	2.8520	4.0000	1
369	2272	17	0	1	Q1	2012	6.9000	3.1740	3.0000	1
369	2570	16	1223	6	Q2	2012	6.9000	3.1050	3.0000	1
369	2638	13	0	4	Q2	2012	6.9000	2.8980	3.0000	1
369	3160	17	0	7	Q3	2012	6.9000	2.6910	3.0000	1
369	3669	24	0	12	Q4	2012	6.9000	3.1740	3.0000	1
369	3921	23	1765	1	Q1	2012	4.6000	1.6100	2.0000	1
369	3956	14	0	9	Q3	2012	4.6000	2.1160	2.0000	1
369	4221	17	0	10	Q4	2012	6.9000	2.6220	3.0000	1
369	4372	13	984	5	Q2	2012	9.2000	3.4960	4.0000	1
369	4466	13	988	7	Q3	2012	9.2000	4.5080	4.0000	1
369	4541	3	0	8	Q3	2012	4.6000	2.2540	2.0000	1
369	4782	24	0	8	Q3	2012	4.6000	1.5640	2.0000	1
369	4784	11	0	12	Q4	2012	9.2000	4.1400	4.0000	1
369	5608	7	0	11	Q4	2012	6.9000	2.9670	3.0000	1
369	5663	6	513	6	Q2	2012	6.9000	3.0360	3.0000	1
369	5663	6	522	10	Q4	2012	9.2000	2.9440	4.0000	1
369	5742	16	0	6	Q2	2012	9.2000	4.3240	4.0000	1
369	5801	24	0	1	Q1	2012	6.9000	2.2770	3.0000	1
369	5984	17	1303	6	Q2	2012	4.6000	2.1160	2.0000	1
369	6014	7	517	8	Q3	2012	6.9000	2.2770	3.0000	1
369	6018	11	820	2	Q1	2012	6.9000	3.3120	3.0000	1
369	6560	17	0	4	Q2	2012	6.9000	2.8980	3.0000	1
369	6621	7	504	2	Q1	2012	4.6000	1.7480	2.0000	1
369	6681	17	0	6	Q2	2012	9.2000	3.4040	4.0000	1
369	6712	16	1236	12	Q4	2012	9.2000	3.4040	4.0000	1
369	6816	11	0	10	Q4	2012	9.2000	3.9560	4.0000	1
369	6929	24	1847	2	Q1	2012	9.2000	2.9440	4.0000	1
369	7346	24	0	1	Q1	2012	6.9000	2.6220	3.0000	1
369	7457	13	0	2	Q1	2012	6.9000	3.0360	3.0000	1
369	7569	13	992	9	Q3	2012	9.2000	4.2320	4.0000	1
369	7655	17	0	1	Q1	2012	4.6000	2.2540	2.0000	1
369	7931	24	1850	3	Q1	2012	6.9000	2.0700	3.0000	1
369	8296	7	523	11	Q4	2012	11.5000	5.1750	5.0000	1
369	8311	23	0	1	Q1	2012	6.9000	2.4840	3.0000	1
369	8329	15	1138	3	Q1	2012	9.2000	3.4040	4.0000	1
369	8378	24	1866	11	Q4	2012	4.6000	2.2540	2.0000	1
369	8692	13	0	3	Q1	2012	9.2000	4.4160	4.0000	1
369	8852	24	1858	7	Q3	2012	9.2000	2.9440	4.0000	1
369	9224	17	1311	10	Q4	2012	9.2000	3.3120	4.0000	1
369	9321	22	1689	2	Q1	2012	4.6000	1.9780	2.0000	1
369	9327	17	0	1	Q1	2012	4.6000	2.1620	2.0000	1
369	9362	7	0	3	Q1	2012	4.6000	2.0700	2.0000	1
369	9570	15	0	11	Q4	2012	4.6000	1.4260	2.0000	1
369	9704	24	0	8	Q3	2012	4.6000	1.7940	2.0000	1
369	9728	16	1214	2	Q1	2012	4.6000	1.6560	2.0000	1
369	9745	17	0	5	Q2	2012	6.9000	2.1390	3.0000	1
369	9863	13	0	9	Q3	2012	6.9000	3.1050	3.0000	1
369	10063	2	0	6	Q2	2012	4.6000	2.2080	2.0000	1
370	36	11	0	11	Q4	2012	2.7600	1.3524	3.0000	1
370	187	13	0	1	Q1	2012	1.8400	0.7728	2.0000	1
370	187	13	984	5	Q2	2012	1.8400	0.7728	2.0000	1
370	252	24	0	9	Q3	2012	2.7600	1.0488	3.0000	1
370	638	11	0	12	Q4	2012	2.7600	0.9384	3.0000	1
370	676	7	0	1	Q1	2012	1.8400	0.8280	2.0000	1
370	719	15	1138	3	Q1	2012	2.7600	1.2696	3.0000	1
370	834	24	0	9	Q3	2012	2.7600	1.0488	3.0000	1
370	1003	17	1303	6	Q2	2012	2.7600	0.8556	3.0000	1
370	1193	13	0	1	Q1	2012	1.8400	0.8280	2.0000	1
370	1366	13	0	3	Q1	2012	1.8400	0.9016	2.0000	1
370	1366	13	0	9	Q3	2012	1.8400	0.9016	2.0000	1
370	1545	15	1136	2	Q1	2012	3.6800	1.8400	4.0000	1
370	1605	7	521	10	Q4	2012	2.7600	1.1316	3.0000	1
370	1622	3	0	1	Q1	2012	2.7600	0.8280	3.0000	1
370	1808	24	1846	2	Q1	2012	1.8400	0.6624	2.0000	1
370	1979	3	0	5	Q2	2012	2.7600	0.9384	3.0000	1
370	2084	17	0	6	Q2	2012	2.7600	0.8556	3.0000	1
370	2251	13	0	4	Q2	2012	3.6800	1.4720	4.0000	1
370	2266	7	516	8	Q3	2012	3.6800	1.4720	4.0000	1
370	2548	13	986	6	Q2	2012	2.7600	1.0488	3.0000	1
370	2588	23	1789	12	Q4	2012	1.8400	0.9016	2.0000	1
370	2829	23	1765	1	Q1	2012	2.7600	0.8832	3.0000	1
370	3010	7	0	5	Q2	2012	1.8400	0.7176	2.0000	1
370	3012	24	0	2	Q1	2012	2.7600	1.2420	3.0000	1
370	3436	11	0	5	Q2	2012	2.7600	0.9384	3.0000	1
370	3599	13	984	5	Q2	2012	1.8400	0.7728	2.0000	1
370	3921	23	0	8	Q3	2012	2.7600	1.1040	3.0000	1
370	4032	11	821	3	Q1	2012	3.6800	1.1776	4.0000	1
370	4032	11	833	8	Q3	2012	3.6800	1.6192	4.0000	1
370	4064	24	0	8	Q3	2012	1.8400	0.8280	2.0000	1
370	4340	17	0	8	Q3	2012	3.6800	1.2512	4.0000	1
370	4395	11	829	6	Q2	2012	2.7600	1.1592	3.0000	1
370	4497	17	1297	3	Q1	2012	2.7600	1.3524	3.0000	1
370	4527	3	0	3	Q1	2012	2.7600	1.3524	3.0000	1
370	4573	7	504	2	Q1	2012	1.8400	0.6992	2.0000	1
370	4609	23	0	2	Q1	2012	3.6800	1.3616	4.0000	1
370	4678	13	0	12	Q4	2012	3.6800	1.4352	4.0000	1
370	4697	15	0	10	Q4	2012	2.7600	1.3248	3.0000	1
370	4834	24	0	7	Q3	2012	2.7600	0.9108	3.0000	1
370	5295	16	1225	7	Q3	2012	1.8400	0.7912	2.0000	1
370	5396	11	824	4	Q2	2012	3.6800	1.8032	4.0000	1
370	5733	11	0	12	Q4	2012	3.6800	1.2880	4.0000	1
370	5782	13	980	3	Q1	2012	1.8400	0.8464	2.0000	1
370	5982	13	0	10	Q4	2012	3.6800	1.5824	4.0000	1
370	6021	13	0	1	Q1	2012	3.6800	1.1776	4.0000	1
370	6049	15	0	10	Q4	2012	3.6800	1.2880	4.0000	1
370	6132	3	195	5	Q2	2012	2.7600	0.9660	3.0000	1
370	6511	7	0	4	Q2	2012	2.7600	1.2696	3.0000	1
370	6560	17	0	10	Q4	2012	2.7600	0.9660	3.0000	1
370	6712	16	0	9	Q3	2012	2.7600	0.9108	3.0000	1
370	6835	16	1216	2	Q1	2012	3.6800	1.4352	4.0000	1
370	6872	24	0	9	Q3	2012	3.6800	1.6192	4.0000	1
370	6936	17	0	12	Q4	2012	3.6800	1.7664	4.0000	1
370	7003	15	0	9	Q3	2012	2.7600	0.9660	3.0000	1
370	7072	16	0	9	Q3	2012	3.6800	1.6928	4.0000	1
370	7180	11	0	2	Q1	2012	1.8400	0.6072	2.0000	1
370	7185	11	0	12	Q4	2012	2.7600	1.2420	3.0000	1
370	7207	13	980	3	Q1	2012	4.6000	1.5180	5.0000	1
370	7915	13	0	7	Q3	2012	1.8400	0.9200	2.0000	1
370	8283	17	1304	7	Q3	2012	2.7600	0.8556	3.0000	1
370	8769	23	0	1	Q1	2012	4.6000	1.7020	5.0000	1
370	8907	3	0	11	Q4	2012	2.7600	1.0212	3.0000	1
370	9087	7	0	5	Q2	2012	4.6000	1.7020	5.0000	1
370	9111	17	0	12	Q4	2012	1.8400	0.8280	2.0000	1
370	9123	3	0	10	Q4	2012	2.7600	1.2144	3.0000	1
370	9548	15	0	2	Q1	2012	2.7600	1.1040	3.0000	1
370	9686	7	0	7	Q3	2012	2.7600	1.2972	3.0000	1
370	10209	6	0	10	Q4	2012	1.8400	0.8464	2.0000	1
371	477	15	0	1	Q1	2012	1.9800	0.9108	3.0000	1
371	711	17	0	3	Q1	2012	1.3200	0.5544	2.0000	1
371	803	7	0	12	Q4	2012	2.6400	0.8712	4.0000	1
371	1070	3	0	2	Q1	2012	1.9800	0.8910	3.0000	1
371	1312	3	0	10	Q4	2012	1.9800	0.7524	3.0000	1
371	1415	16	0	8	Q3	2012	2.6400	0.9768	4.0000	1
371	1838	24	0	6	Q2	2012	1.9800	0.6336	3.0000	1
371	1872	7	0	4	Q2	2012	2.6400	0.8184	4.0000	1
371	1940	13	0	10	Q4	2012	1.3200	0.5148	2.0000	1
371	1950	24	0	4	Q2	2012	1.9800	0.7326	3.0000	1
371	1965	17	0	4	Q2	2012	3.3000	1.5840	5.0000	1
371	2042	13	0	4	Q2	2012	1.9800	0.8118	3.0000	1
371	2112	17	0	12	Q4	2012	1.9800	0.8514	3.0000	1
371	2385	6	0	7	Q3	2012	2.6400	1.1352	4.0000	1
371	2681	7	504	2	Q1	2012	1.9800	0.7524	3.0000	1
371	2688	6	0	10	Q4	2012	1.3200	0.4488	2.0000	1
371	2699	24	1859	8	Q3	2012	1.9800	0.8118	3.0000	1
371	2740	11	0	6	Q2	2012	1.9800	0.7326	3.0000	1
371	2981	23	0	3	Q1	2012	2.6400	1.0824	4.0000	1
371	3101	11	0	4	Q2	2012	1.9800	0.6138	3.0000	1
371	3349	6	0	6	Q2	2012	1.3200	0.6336	2.0000	1
371	3370	7	526	12	Q4	2012	1.3200	0.5148	2.0000	1
371	3776	13	0	12	Q4	2012	1.9800	0.7128	3.0000	1
371	3905	15	1136	2	Q1	2012	1.9800	0.6138	3.0000	1
371	4204	17	1303	6	Q2	2012	2.6400	1.3200	4.0000	1
371	4425	13	0	7	Q3	2012	1.9800	0.5940	3.0000	1
371	4454	15	0	12	Q4	2012	3.3000	1.0230	5.0000	1
371	4476	24	1866	11	Q4	2012	1.9800	0.6534	3.0000	1
371	4506	14	1077	11	Q4	2012	1.9800	0.7722	3.0000	1
371	4767	16	0	6	Q2	2012	1.9800	0.7920	3.0000	1
371	4778	3	0	12	Q4	2012	1.9800	0.9504	3.0000	1
371	4803	23	0	3	Q1	2012	1.3200	0.4356	2.0000	1
371	5276	15	0	12	Q4	2012	1.3200	0.6336	2.0000	1
371	5458	15	1138	3	Q1	2012	1.3200	0.4488	2.0000	1
371	5541	6	0	5	Q2	2012	2.6400	0.8184	4.0000	1
371	5602	7	0	6	Q2	2012	1.9800	0.6138	3.0000	1
371	5614	15	0	7	Q3	2012	1.3200	0.5148	2.0000	1
371	5626	6	0	11	Q4	2012	1.9800	0.8514	3.0000	1
371	5631	24	0	12	Q4	2012	2.6400	1.2936	4.0000	1
371	5814	15	0	3	Q1	2012	3.3000	1.2540	5.0000	1
371	5827	11	826	5	Q2	2012	1.9800	0.9108	3.0000	1
371	5869	13	0	7	Q3	2012	1.9800	0.6732	3.0000	1
371	5925	15	0	9	Q3	2012	1.9800	0.9702	3.0000	1
371	6147	7	0	11	Q4	2012	1.9800	0.6930	3.0000	1
371	6414	24	0	2	Q1	2012	1.9800	0.6138	3.0000	1
371	6712	16	0	11	Q4	2012	1.9800	0.7524	3.0000	1
371	6888	23	0	9	Q3	2012	1.3200	0.5280	2.0000	1
371	7001	3	197	6	Q2	2012	1.3200	0.5544	2.0000	1
371	7001	3	207	11	Q4	2012	2.6400	0.9768	4.0000	1
371	7232	11	837	10	Q4	2012	1.9800	0.8316	3.0000	1
371	7257	15	0	7	Q3	2012	1.9800	0.8712	3.0000	1
371	7570	13	0	7	Q3	2012	1.3200	0.4752	2.0000	1
371	7622	3	0	2	Q1	2012	1.9800	0.7722	3.0000	1
371	7702	16	0	5	Q2	2012	1.9800	0.7128	3.0000	1
371	7769	11	836	9	Q3	2012	1.3200	0.5280	2.0000	1
371	7856	7	504	2	Q1	2012	2.6400	1.1088	4.0000	1
371	7857	15	1138	3	Q1	2012	1.9800	0.6732	3.0000	1
371	7913	17	0	4	Q2	2012	2.6400	0.8712	4.0000	1
371	7988	11	0	7	Q3	2012	1.9800	0.9306	3.0000	1
371	8073	24	0	1	Q1	2012	2.6400	1.0296	4.0000	1
371	8214	7	516	8	Q3	2012	1.9800	0.6336	3.0000	1
371	8335	7	0	10	Q4	2012	1.9800	0.6534	3.0000	1
371	8511	16	0	4	Q2	2012	2.6400	1.0296	4.0000	1
371	8887	17	0	10	Q4	2012	1.3200	0.5544	2.0000	1
371	8984	6	0	2	Q1	2012	1.9800	0.7722	3.0000	1
371	9075	7	0	6	Q2	2012	1.9800	0.9306	3.0000	1
371	9134	23	1768	2	Q1	2012	1.3200	0.5940	2.0000	1
371	9200	16	1225	7	Q3	2012	1.9800	0.8316	3.0000	1
371	9513	15	0	12	Q4	2012	2.6400	1.0824	4.0000	1
371	9631	16	1220	4	Q2	2012	2.6400	0.8712	4.0000	1
371	9643	13	0	6	Q2	2012	2.6400	0.8712	4.0000	1
371	9673	13	0	11	Q4	2012	1.9800	0.7128	3.0000	1
371	9929	13	0	11	Q4	2012	1.9800	0.8910	3.0000	1
371	10097	7	0	1	Q1	2012	2.6400	1.1352	4.0000	1
371	10097	7	505	2	Q1	2012	2.6400	0.9240	4.0000	1
372	182	15	1149	8	Q3	2012	15.9200	6.6864	4.0000	1
372	346	13	0	7	Q3	2012	15.9200	5.2536	4.0000	1
372	424	7	0	7	Q3	2012	15.9200	6.2088	4.0000	1
372	565	15	1140	4	Q2	2012	15.9200	5.2536	4.0000	1
372	907	7	0	1	Q1	2012	11.9400	3.9402	3.0000	1
372	1081	14	0	6	Q2	2012	7.9600	3.6616	2.0000	1
372	1215	7	0	10	Q4	2012	7.9600	2.5472	2.0000	1
372	1286	24	1856	6	Q2	2012	15.9200	4.7760	4.0000	1
372	1718	13	0	7	Q3	2012	7.9600	3.1044	2.0000	1
372	1718	13	0	9	Q3	2012	11.9400	5.6118	3.0000	1
372	1813	17	1303	6	Q2	2012	7.9600	3.9800	2.0000	1
372	1865	6	0	6	Q2	2012	11.9400	3.9402	3.0000	1
372	1988	11	837	10	Q4	2012	11.9400	5.1342	3.0000	1
372	2086	13	0	3	Q1	2012	7.9600	3.1044	2.0000	1
372	2112	17	1307	8	Q3	2012	11.9400	5.1342	3.0000	1
372	2285	24	0	6	Q2	2012	11.9400	4.4178	3.0000	1
372	2362	6	0	11	Q4	2012	15.9200	7.1640	4.0000	1
372	2371	16	0	6	Q2	2012	11.9400	3.7014	3.0000	1
372	2441	17	0	3	Q1	2012	19.9000	8.9550	5.0000	1
372	2658	7	0	6	Q2	2012	11.9400	4.8954	3.0000	1
372	2825	11	820	2	Q1	2012	11.9400	5.0148	3.0000	1
372	3258	7	0	10	Q4	2012	7.9600	3.4228	2.0000	1
372	3436	11	0	1	Q1	2012	11.9400	4.0596	3.0000	1
372	3645	2	0	7	Q3	2012	3.9800	1.3930	1.0000	1
372	3711	3	0	5	Q2	2012	7.9600	3.9004	2.0000	1
372	4204	17	0	12	Q4	2012	15.9200	7.9600	4.0000	1
372	4498	17	0	4	Q2	2012	11.9400	4.1790	3.0000	1
372	5245	11	0	5	Q2	2012	11.9400	4.6566	3.0000	1
372	5656	24	0	9	Q3	2012	7.9600	3.1044	2.0000	1
372	5738	3	0	8	Q3	2012	11.9400	5.2536	3.0000	1
372	5768	3	0	10	Q4	2012	11.9400	5.9700	3.0000	1
372	5813	3	0	4	Q2	2012	15.9200	7.3232	4.0000	1
372	6061	17	0	5	Q2	2012	11.9400	5.3730	3.0000	1
372	6172	15	1142	5	Q2	2012	7.9600	3.2636	2.0000	1
372	6324	23	0	5	Q2	2012	15.9200	7.4824	4.0000	1
372	6367	3	0	1	Q1	2012	11.9400	4.7760	3.0000	1
372	6560	17	0	7	Q3	2012	11.9400	4.2984	3.0000	1
372	6581	22	1701	7	Q3	2012	3.9800	1.4726	1.0000	1
372	6822	11	842	12	Q4	2012	15.9200	5.7312	4.0000	1
372	6844	11	826	5	Q2	2012	15.9200	6.0496	4.0000	1
372	7067	13	1000	12	Q4	2012	15.9200	7.9600	4.0000	1
372	7196	6	0	1	Q1	2012	11.9400	4.8954	3.0000	1
372	7269	13	0	10	Q4	2012	15.9200	7.0048	4.0000	1
372	7329	2	118	6	Q2	2012	7.9600	2.7064	2.0000	1
372	7521	13	0	3	Q1	2012	15.9200	7.6416	4.0000	1
372	7849	3	0	8	Q3	2012	15.9200	6.2088	4.0000	1
372	8098	13	0	9	Q3	2012	15.9200	5.2536	4.0000	1
372	8108	17	1297	3	Q1	2012	15.9200	6.8456	4.0000	1
372	8117	11	0	9	Q3	2012	19.9000	7.3630	5.0000	1
372	8407	15	1140	4	Q2	2012	7.9600	3.1840	2.0000	1
372	8472	17	1304	7	Q3	2012	7.9600	2.7860	2.0000	1
372	8578	23	0	12	Q4	2012	15.9200	7.6416	4.0000	1
372	8647	3	0	12	Q4	2012	7.9600	3.1044	2.0000	1
372	8901	13	0	6	Q2	2012	11.9400	5.0148	3.0000	1
372	9040	16	0	6	Q2	2012	11.9400	4.0596	3.0000	1
372	9064	17	1304	7	Q3	2012	15.9200	7.6416	4.0000	1
372	9167	11	0	3	Q1	2012	15.9200	5.2536	4.0000	1
372	9200	16	0	5	Q2	2012	11.9400	5.3730	3.0000	1
372	9788	13	0	7	Q3	2012	11.9400	4.5372	3.0000	1
372	9795	11	0	12	Q4	2012	11.9400	5.8506	3.0000	1
373	44	6	0	12	Q4	2012	11.0400	4.1952	4.0000	1
373	50	7	0	7	Q3	2012	5.5200	1.9872	2.0000	1
373	490	11	0	4	Q2	2012	8.2800	3.0636	3.0000	1
373	823	24	0	9	Q3	2012	8.2800	3.9744	3.0000	1
373	1624	11	826	5	Q2	2012	11.0400	5.2992	4.0000	1
373	1862	17	0	6	Q2	2012	8.2800	2.7324	3.0000	1
373	2448	16	0	12	Q4	2012	5.5200	1.9872	2.0000	1
373	2588	23	1776	6	Q2	2012	11.0400	5.0784	4.0000	1
373	2656	13	0	12	Q4	2012	11.0400	5.4096	4.0000	1
373	2695	13	0	7	Q3	2012	8.2800	4.0572	3.0000	1
373	2968	13	0	4	Q2	2012	11.0400	5.2992	4.0000	1
373	3011	15	1142	5	Q2	2012	8.2800	3.1464	3.0000	1
373	3028	7	504	2	Q1	2012	8.2800	3.7260	3.0000	1
373	3231	17	0	8	Q3	2012	11.0400	4.7472	4.0000	1
373	3302	13	984	5	Q2	2012	8.2800	2.8980	3.0000	1
373	3401	11	0	7	Q3	2012	8.2800	3.6432	3.0000	1
373	3585	6	513	6	Q2	2012	8.2800	4.1400	3.0000	1
373	3586	11	820	2	Q1	2012	11.0400	3.6432	4.0000	1
373	3639	24	0	12	Q4	2012	8.2800	3.3120	3.0000	1
373	3911	7	0	6	Q2	2012	5.5200	2.1528	2.0000	1
373	4122	15	1138	3	Q1	2012	11.0400	3.4224	4.0000	1
373	4180	7	0	5	Q2	2012	8.2800	3.6432	3.0000	1
373	4268	11	824	4	Q2	2012	8.2800	4.0572	3.0000	1
373	4269	15	0	10	Q4	2012	5.5200	2.0976	2.0000	1
373	4307	6	0	5	Q2	2012	8.2800	2.8980	3.0000	1
373	4378	11	0	1	Q1	2012	5.5200	2.3184	2.0000	1
373	4445	17	1314	11	Q4	2012	8.2800	3.9744	3.0000	1
373	5086	7	514	7	Q3	2012	11.0400	5.4096	4.0000	1
373	5210	17	0	7	Q3	2012	8.2800	2.7324	3.0000	1
373	5340	11	0	3	Q1	2012	8.2800	4.0572	3.0000	1
373	5768	3	0	10	Q4	2012	8.2800	4.0572	3.0000	1
373	5805	11	0	4	Q2	2012	8.2800	2.6496	3.0000	1
373	5829	22	0	5	Q2	2012	8.2800	3.1464	3.0000	1
373	5869	13	0	1	Q1	2012	11.0400	4.8576	4.0000	1
373	6206	11	0	11	Q4	2012	8.2800	4.0572	3.0000	1
373	6560	17	0	4	Q2	2012	8.2800	2.8980	3.0000	1
373	6683	17	0	6	Q2	2012	8.2800	4.0572	3.0000	1
373	6686	13	0	1	Q1	2012	8.2800	4.1400	3.0000	1
373	6744	13	0	11	Q4	2012	11.0400	5.1888	4.0000	1
373	6766	24	0	3	Q1	2012	8.2800	2.6496	3.0000	1
373	6937	11	826	5	Q2	2012	8.2800	3.0636	3.0000	1
373	7410	13	976	1	Q1	2012	5.5200	2.3736	2.0000	1
373	7669	11	0	1	Q1	2012	8.2800	3.3120	3.0000	1
373	7750	15	1138	3	Q1	2012	5.5200	2.7048	2.0000	1
373	7858	15	1152	9	Q3	2012	8.2800	2.7324	3.0000	1
373	8011	6	504	2	Q1	2012	11.0400	4.0848	4.0000	1
373	8134	11	0	2	Q1	2012	8.2800	3.3948	3.0000	1
373	8452	16	0	5	Q2	2012	11.0400	4.4160	4.0000	1
373	8546	6	0	2	Q1	2012	11.0400	3.7536	4.0000	1
373	8599	15	0	3	Q1	2012	11.0400	4.0848	4.0000	1
373	8660	7	0	1	Q1	2012	8.2800	3.4776	3.0000	1
373	8779	13	0	10	Q4	2012	11.0400	5.1888	4.0000	1
373	8814	13	0	11	Q4	2012	5.5200	1.9872	2.0000	1
373	8960	3	185	1	Q1	2012	11.0400	5.2992	4.0000	1
373	9472	14	0	9	Q3	2012	2.7600	1.2144	1.0000	1
373	9524	3	0	1	Q1	2012	11.0400	3.6432	4.0000	1
373	9602	11	0	4	Q2	2012	11.0400	4.0848	4.0000	1
373	10080	7	0	8	Q3	2012	13.8000	5.2440	5.0000	1
374	44	6	508	4	Q2	2012	2.9800	1.2516	2.0000	1
374	187	13	0	1	Q1	2012	2.9800	1.0430	2.0000	1
374	190	13	0	1	Q1	2012	4.4700	1.8327	3.0000	1
374	285	7	0	7	Q3	2012	2.9800	1.1324	2.0000	1
374	373	13	0	5	Q2	2012	2.9800	1.1920	2.0000	1
374	625	13	0	11	Q4	2012	5.9600	2.9800	4.0000	1
374	769	16	0	1	Q1	2012	4.4700	1.3410	3.0000	1
374	893	13	0	9	Q3	2012	7.4500	2.8310	5.0000	1
374	898	7	526	12	Q4	2012	4.4700	2.1009	3.0000	1
374	1491	16	0	1	Q1	2012	4.4700	2.1456	3.0000	1
374	1602	7	523	11	Q4	2012	4.4700	1.6092	3.0000	1
374	1780	24	0	4	Q2	2012	5.9600	2.5032	4.0000	1
374	2371	16	0	3	Q1	2012	4.4700	2.0562	3.0000	1
374	2378	16	0	1	Q1	2012	5.9600	2.7416	4.0000	1
374	2479	13	0	6	Q2	2012	5.9600	2.5628	4.0000	1
374	2808	13	0	11	Q4	2012	4.4700	1.6986	3.0000	1
374	3233	6	0	4	Q2	2012	5.9600	2.2052	4.0000	1
374	3304	22	0	7	Q3	2012	2.9800	1.3410	2.0000	1
374	3552	17	0	4	Q2	2012	2.9800	1.1622	2.0000	1
374	3552	17	1294	2	Q1	2012	4.4700	1.9668	3.0000	1
374	3707	24	0	2	Q1	2012	4.4700	1.4751	3.0000	1
374	3728	13	0	3	Q1	2012	2.9800	1.3112	2.0000	1
374	3861	14	0	1	Q1	2012	2.9800	1.3112	2.0000	1
374	4133	24	1866	11	Q4	2012	4.4700	1.3857	3.0000	1
374	4291	15	1134	1	Q1	2012	5.9600	1.9072	4.0000	1
374	4357	7	0	12	Q4	2012	2.9800	1.1622	2.0000	1
374	4739	15	0	10	Q4	2012	4.4700	1.5645	3.0000	1
374	5147	13	0	10	Q4	2012	2.9800	1.4304	2.0000	1
374	5329	13	0	12	Q4	2012	5.9600	2.0860	4.0000	1
374	6778	24	0	2	Q1	2012	4.4700	1.3857	3.0000	1
374	6994	7	526	12	Q4	2012	4.4700	2.0562	3.0000	1
374	7149	13	0	4	Q2	2012	4.4700	1.8774	3.0000	1
374	7149	13	0	7	Q3	2012	4.4700	1.6539	3.0000	1
374	7386	6	0	6	Q2	2012	7.4500	2.8310	5.0000	1
374	7609	11	842	12	Q4	2012	2.9800	1.2516	2.0000	1
374	7655	17	0	6	Q2	2012	4.4700	1.6986	3.0000	1
374	7777	24	0	2	Q1	2012	4.4700	1.4751	3.0000	1
374	7893	11	0	2	Q1	2012	4.4700	1.6092	3.0000	1
374	8140	13	0	7	Q3	2012	4.4700	1.4304	3.0000	1
374	8202	3	0	12	Q4	2012	5.9600	1.9072	4.0000	1
374	8283	17	1304	7	Q3	2012	4.4700	1.3410	3.0000	1
374	8358	11	0	12	Q4	2012	5.9600	2.3244	4.0000	1
374	8815	7	505	2	Q1	2012	2.9800	1.0728	2.0000	1
374	8843	13	0	12	Q4	2012	4.4700	1.8774	3.0000	1
374	8901	13	0	3	Q1	2012	2.9800	1.0728	2.0000	1
374	8933	6	0	6	Q2	2012	7.4500	3.6505	5.0000	1
374	8960	3	0	6	Q2	2012	2.9800	1.4602	2.0000	1
374	9052	24	0	8	Q3	2012	5.9600	1.9072	4.0000	1
374	9098	11	0	3	Q1	2012	4.4700	2.1903	3.0000	1
374	9237	11	0	3	Q1	2012	4.4700	2.1009	3.0000	1
374	9324	3	188	2	Q1	2012	2.9800	1.1622	2.0000	1
374	9399	6	523	11	Q4	2012	4.4700	1.5198	3.0000	1
374	9534	17	1304	7	Q3	2012	4.4700	1.5645	3.0000	1
374	9534	17	1311	10	Q4	2012	5.9600	2.0860	4.0000	1
374	9687	15	0	12	Q4	2012	4.4700	1.5198	3.0000	1
374	9825	13	0	10	Q4	2012	2.9800	0.9834	2.0000	1
374	9891	23	0	2	Q1	2012	2.9800	1.2516	2.0000	1
374	9956	17	0	9	Q3	2012	2.9800	1.2516	2.0000	1
374	10145	13	0	11	Q4	2012	4.4700	1.6092	3.0000	1
374	10179	2	0	11	Q4	2012	1.4900	0.5811	1.0000	1
375	64	11	821	3	Q1	2012	6.8700	3.3663	3.0000	1
375	830	15	0	2	Q1	2012	6.8700	3.0228	3.0000	1
375	997	3	0	1	Q1	2012	9.1600	3.0228	4.0000	1
375	1005	3	0	7	Q3	2012	6.8700	2.8854	3.0000	1
375	1145	17	0	3	Q1	2012	9.1600	3.5724	4.0000	1
375	1334	17	0	1	Q1	2012	6.8700	2.8854	3.0000	1
375	1525	7	0	12	Q4	2012	6.8700	2.1984	3.0000	1
375	1701	13	0	11	Q4	2012	6.8700	2.2671	3.0000	1
375	1717	11	837	10	Q4	2012	9.1600	4.3968	4.0000	1
375	1813	17	0	11	Q4	2012	4.5800	1.4656	2.0000	1
375	2143	17	0	2	Q1	2012	4.5800	1.4656	2.0000	1
375	2201	16	0	1	Q1	2012	9.1600	3.0228	4.0000	1
375	2385	6	0	7	Q3	2012	9.1600	2.8396	4.0000	1
375	2507	3	0	10	Q4	2012	6.8700	3.2289	3.0000	1
375	2547	23	0	10	Q4	2012	9.1600	2.7480	4.0000	1
375	2570	16	1214	2	Q1	2012	6.8700	3.0915	3.0000	1
375	2570	16	1220	4	Q2	2012	9.1600	3.5724	4.0000	1
375	2916	13	0	11	Q4	2012	6.8700	2.6106	3.0000	1
375	2981	23	0	7	Q3	2012	6.8700	2.4732	3.0000	1
375	3231	17	0	3	Q1	2012	9.1600	3.4808	4.0000	1
375	3321	24	1850	3	Q1	2012	6.8700	3.0915	3.0000	1
375	3499	13	0	12	Q4	2012	6.8700	2.8854	3.0000	1
375	3579	6	0	10	Q4	2012	4.5800	1.4656	2.0000	1
375	3802	6	0	1	Q1	2012	6.8700	2.4045	3.0000	1
375	3855	15	1134	1	Q1	2012	4.5800	1.8778	2.0000	1
375	4021	16	0	12	Q4	2012	9.1600	4.3968	4.0000	1
375	4082	24	0	6	Q2	2012	4.5800	1.5572	2.0000	1
375	4564	17	1307	8	Q3	2012	6.8700	3.2289	3.0000	1
375	4772	2	0	1	Q1	2012	4.5800	2.1068	2.0000	1
375	5329	13	0	5	Q2	2012	9.1600	3.2060	4.0000	1
375	5825	15	0	3	Q1	2012	6.8700	2.3358	3.0000	1
375	5903	13	0	7	Q3	2012	6.8700	3.4350	3.0000	1
375	5957	11	826	5	Q2	2012	6.8700	2.2671	3.0000	1
375	5960	6	0	2	Q1	2012	6.8700	2.3358	3.0000	1
375	6049	15	0	12	Q4	2012	9.1600	4.4884	4.0000	1
375	6307	16	0	1	Q1	2012	11.4500	4.8090	5.0000	1
375	6318	15	0	8	Q3	2012	4.5800	1.8778	2.0000	1
375	6675	22	0	1	Q1	2012	2.2900	0.7328	1.0000	1
375	6966	24	1856	6	Q2	2012	6.8700	2.6106	3.0000	1
375	7001	3	185	1	Q1	2012	4.5800	2.0152	2.0000	1
375	7181	7	0	12	Q4	2012	6.8700	2.6106	3.0000	1
375	7234	16	0	11	Q4	2012	9.1600	2.9312	4.0000	1
375	7556	17	1304	7	Q3	2012	4.5800	2.0152	2.0000	1
375	7655	17	0	2	Q1	2012	4.5800	2.1068	2.0000	1
375	7702	16	0	4	Q2	2012	6.8700	2.8854	3.0000	1
375	8068	3	0	1	Q1	2012	9.1600	3.0228	4.0000	1
375	8129	7	504	2	Q1	2012	6.8700	2.6106	3.0000	1
375	8223	14	0	3	Q1	2012	2.2900	1.1221	1.0000	1
375	8243	13	980	3	Q1	2012	4.5800	1.5114	2.0000	1
375	8511	16	0	3	Q1	2012	6.8700	2.7480	3.0000	1
375	8511	16	1228	8	Q3	2012	6.8700	2.7480	3.0000	1
375	8578	23	0	6	Q2	2012	6.8700	2.4732	3.0000	1
375	8742	3	0	5	Q2	2012	9.1600	4.3052	4.0000	1
375	8749	13	0	7	Q3	2012	6.8700	3.0228	3.0000	1
375	8937	7	504	2	Q1	2012	6.8700	2.1984	3.0000	1
375	8968	11	0	2	Q1	2012	9.1600	3.9388	4.0000	1
375	9206	17	1307	8	Q3	2012	4.5800	1.8320	2.0000	1
375	9555	17	0	7	Q3	2012	6.8700	2.7480	3.0000	1
375	9564	17	0	2	Q1	2012	9.1600	4.0304	4.0000	1
375	10152	13	0	12	Q4	2012	6.8700	3.1602	3.0000	1
376	91	7	504	2	Q1	2012	9.0800	2.9056	4.0000	1
376	373	13	0	1	Q1	2012	6.8100	2.9283	3.0000	1
376	420	22	0	1	Q1	2012	2.2700	1.1123	1.0000	1
376	511	16	1220	4	Q2	2012	6.8100	3.2688	3.0000	1
376	930	17	1303	6	Q2	2012	6.8100	2.5878	3.0000	1
376	1147	13	0	2	Q1	2012	4.5400	1.8614	2.0000	1
376	1538	6	521	10	Q4	2012	6.8100	3.2007	3.0000	1
376	1567	16	0	3	Q1	2012	9.0800	3.9952	4.0000	1
376	1811	11	829	6	Q2	2012	9.0800	4.1768	4.0000	1
376	1944	24	1845	1	Q1	2012	9.0800	4.4492	4.0000	1
376	1957	13	0	9	Q3	2012	4.5400	1.4982	2.0000	1
376	2255	24	1856	6	Q2	2012	6.8100	2.1792	3.0000	1
376	2294	11	0	10	Q4	2012	6.8100	2.9283	3.0000	1
376	2422	13	0	6	Q2	2012	9.0800	3.6320	4.0000	1
376	2762	13	0	10	Q4	2012	9.0800	3.6320	4.0000	1
376	2861	7	0	3	Q1	2012	9.0800	3.1780	4.0000	1
376	2863	17	1303	6	Q2	2012	9.0800	4.0860	4.0000	1
376	3178	11	836	9	Q3	2012	6.8100	2.6559	3.0000	1
376	3388	13	0	6	Q2	2012	9.0800	4.5400	4.0000	1
376	3593	3	0	5	Q2	2012	9.0800	3.5412	4.0000	1
376	3642	24	0	5	Q2	2012	9.0800	4.2676	4.0000	1
376	3898	6	0	6	Q2	2012	4.5400	2.1792	2.0000	1
376	4279	7	0	6	Q2	2012	4.5400	2.1338	2.0000	1
376	4322	15	0	1	Q1	2012	6.8100	2.2473	3.0000	1
376	4959	13	0	3	Q1	2012	9.0800	3.5412	4.0000	1
376	5347	6	0	4	Q2	2012	9.0800	4.0860	4.0000	1
376	5398	17	1304	7	Q3	2012	9.0800	3.9952	4.0000	1
376	5471	7	0	9	Q3	2012	4.5400	2.2246	2.0000	1
376	5845	24	0	12	Q4	2012	4.5400	1.4982	2.0000	1
376	6381	24	0	8	Q3	2012	6.8100	2.6559	3.0000	1
376	6683	17	0	8	Q3	2012	9.0800	3.8136	4.0000	1
376	6733	13	980	3	Q1	2012	6.8100	2.5878	3.0000	1
376	6775	15	0	4	Q2	2012	9.0800	3.9952	4.0000	1
376	6960	17	0	3	Q1	2012	11.3500	5.5615	5.0000	1
376	7236	24	0	5	Q2	2012	6.8100	3.2007	3.0000	1
376	7340	24	0	8	Q3	2012	6.8100	2.9964	3.0000	1
376	7406	11	0	11	Q4	2012	4.5400	1.9522	2.0000	1
376	7556	17	0	7	Q3	2012	11.3500	4.9940	5.0000	1
376	7694	13	982	4	Q2	2012	6.8100	2.8602	3.0000	1
376	7735	15	0	8	Q3	2012	4.5400	1.6798	2.0000	1
376	7813	17	0	5	Q2	2012	6.8100	2.1111	3.0000	1
376	7813	17	1312	10	Q4	2012	6.8100	2.5878	3.0000	1
376	8055	14	0	6	Q2	2012	4.5400	1.7706	2.0000	1
376	8288	7	0	8	Q3	2012	9.0800	3.9952	4.0000	1
376	8404	3	0	5	Q2	2012	6.8100	3.0645	3.0000	1
376	8411	15	0	4	Q2	2012	4.5400	1.4074	2.0000	1
376	8730	6	524	11	Q4	2012	4.5400	2.2246	2.0000	1
376	8739	7	0	11	Q4	2012	6.8100	2.3154	3.0000	1
376	8901	13	0	1	Q1	2012	4.5400	1.6344	2.0000	1
376	8902	3	0	12	Q4	2012	4.5400	1.7252	2.0000	1
376	9111	17	0	1	Q1	2012	6.8100	3.0645	3.0000	1
376	9271	17	0	8	Q3	2012	11.3500	4.4265	5.0000	1
376	9420	13	0	1	Q1	2012	9.0800	4.4492	4.0000	1
376	9421	22	1698	6	Q2	2012	2.2700	1.1350	1.0000	1
376	9501	13	1000	12	Q4	2012	6.8100	2.9283	3.0000	1
376	9510	16	0	3	Q1	2012	9.0800	3.1780	4.0000	1
376	9673	13	0	11	Q4	2012	6.8100	2.1111	3.0000	1
376	10237	24	1851	4	Q2	2012	9.0800	2.8148	4.0000	1
377	106	6	504	2	Q1	2012	10.5000	3.6750	5.0000	1
377	167	24	0	4	Q2	2012	8.4000	3.2760	4.0000	1
377	208	13	0	9	Q3	2012	8.4000	3.6960	4.0000	1
377	240	7	501	1	Q1	2012	4.2000	1.9320	2.0000	1
377	465	13	0	8	Q3	2012	4.2000	1.6800	2.0000	1
377	527	7	518	8	Q3	2012	8.4000	3.1920	4.0000	1
377	719	15	1138	3	Q1	2012	8.4000	3.1920	4.0000	1
377	1167	7	0	10	Q4	2012	6.3000	1.9530	3.0000	1
377	1328	17	1292	1	Q1	2012	8.4000	2.7720	4.0000	1
377	1690	16	0	11	Q4	2012	4.2000	1.3020	2.0000	1
377	2110	11	0	11	Q4	2012	8.4000	3.3600	4.0000	1
377	2346	15	1140	4	Q2	2012	6.3000	2.0790	3.0000	1
377	2547	23	1789	12	Q4	2012	8.4000	2.7720	4.0000	1
377	2621	6	0	4	Q2	2012	6.3000	2.3310	3.0000	1
377	2664	17	0	12	Q4	2012	6.3000	2.7720	3.0000	1
377	2741	2	0	1	Q1	2012	6.3000	2.5830	3.0000	1
377	2831	14	0	11	Q4	2012	2.1000	0.7140	1.0000	1
377	2969	6	0	6	Q2	2012	6.3000	2.7720	3.0000	1
377	3111	24	0	6	Q2	2012	4.2000	1.6380	2.0000	1
377	3161	13	980	3	Q1	2012	8.4000	3.9480	4.0000	1
377	3231	17	1311	10	Q4	2012	4.2000	1.5120	2.0000	1
377	3370	7	526	12	Q4	2012	6.3000	2.3310	3.0000	1
377	3388	13	0	12	Q4	2012	4.2000	1.5540	2.0000	1
377	3404	24	0	8	Q3	2012	6.3000	2.2050	3.0000	1
377	3497	17	0	1	Q1	2012	6.3000	2.3940	3.0000	1
377	3728	13	0	3	Q1	2012	6.3000	2.3310	3.0000	1
377	3803	24	0	2	Q1	2012	8.4000	2.9400	4.0000	1
377	4021	16	0	11	Q4	2012	6.3000	2.0160	3.0000	1
377	4135	11	0	1	Q1	2012	6.3000	2.3940	3.0000	1
377	4498	17	0	8	Q3	2012	8.4000	4.2000	4.0000	1
377	4534	6	0	3	Q1	2012	6.3000	2.5200	3.0000	1
377	4858	17	1304	7	Q3	2012	6.3000	2.3940	3.0000	1
377	4867	24	0	6	Q2	2012	8.4000	3.1920	4.0000	1
377	5388	11	841	12	Q4	2012	8.4000	2.7720	4.0000	1
377	5978	7	0	11	Q4	2012	6.3000	3.0870	3.0000	1
377	6194	11	0	5	Q2	2012	6.3000	2.3310	3.0000	1
377	6332	6	0	11	Q4	2012	6.3000	2.7090	3.0000	1
377	6624	15	0	7	Q3	2012	8.4000	3.1920	4.0000	1
377	6866	17	0	11	Q4	2012	6.3000	1.9530	3.0000	1
377	7101	15	0	9	Q3	2012	8.4000	3.3600	4.0000	1
377	7319	13	0	1	Q1	2012	6.3000	2.0790	3.0000	1
377	7529	17	0	3	Q1	2012	6.3000	2.4570	3.0000	1
377	7546	13	0	11	Q4	2012	6.3000	2.9610	3.0000	1
377	8242	17	0	3	Q1	2012	8.4000	3.6120	4.0000	1
377	8551	17	0	9	Q3	2012	8.4000	3.9480	4.0000	1
377	8560	24	0	9	Q3	2012	8.4000	4.2000	4.0000	1
377	9115	11	0	11	Q4	2012	6.3000	2.7090	3.0000	1
377	9631	16	0	8	Q3	2012	6.3000	2.0790	3.0000	1
377	9631	16	1216	2	Q1	2012	6.3000	2.1420	3.0000	1
377	9797	16	1225	7	Q3	2012	6.3000	3.1500	3.0000	1
377	9866	3	0	7	Q3	2012	6.3000	2.0160	3.0000	1
378	400	23	0	12	Q4	2012	2.2200	1.1100	2.0000	1
378	404	6	0	3	Q1	2012	3.3300	1.4985	3.0000	1
378	570	15	1143	5	Q2	2012	3.3300	1.4985	3.0000	1
378	886	15	0	2	Q1	2012	4.4400	2.0868	4.0000	1
378	1007	11	0	1	Q1	2012	4.4400	1.4652	4.0000	1
378	1167	6	0	5	Q2	2012	3.3300	1.0323	3.0000	1
378	1504	24	0	3	Q1	2012	4.4400	1.3764	4.0000	1
378	1602	7	523	11	Q4	2012	4.4400	2.0424	4.0000	1
378	1718	13	0	3	Q1	2012	2.2200	0.9102	2.0000	1
378	1940	13	0	10	Q4	2012	3.3300	1.2321	3.0000	1
378	1956	15	0	7	Q3	2012	3.3300	1.0656	3.0000	1
378	1968	14	0	6	Q2	2012	1.1100	0.3996	1.0000	1
378	2188	13	0	8	Q3	2012	4.4400	1.3320	4.0000	1
378	2244	17	0	1	Q1	2012	3.3300	1.0989	3.0000	1
378	2368	3	0	1	Q1	2012	3.3300	1.5318	3.0000	1
378	2373	13	0	1	Q1	2012	4.4400	2.2200	4.0000	1
378	2640	6	510	5	Q2	2012	4.4400	1.9536	4.0000	1
378	2769	16	0	8	Q3	2012	3.3300	1.1322	3.0000	1
378	2787	17	1307	8	Q3	2012	3.3300	1.4319	3.0000	1
378	2881	24	0	11	Q4	2012	3.3300	1.4985	3.0000	1
378	2905	3	0	4	Q2	2012	2.2200	0.7992	2.0000	1
378	3388	13	0	5	Q2	2012	2.2200	0.7992	2.0000	1
378	3448	3	199	7	Q3	2012	4.4400	1.4208	4.0000	1
378	3873	11	0	10	Q4	2012	3.3300	1.6650	3.0000	1
378	3882	13	0	1	Q1	2012	3.3300	1.4652	3.0000	1
378	3895	14	1077	11	Q4	2012	2.2200	1.0656	2.0000	1
378	4039	24	1850	3	Q1	2012	3.3300	1.0989	3.0000	1
378	4065	3	0	4	Q2	2012	3.3300	1.3986	3.0000	1
378	4468	11	837	10	Q4	2012	2.2200	0.9324	2.0000	1
378	4516	22	1709	11	Q4	2012	2.2200	1.0878	2.0000	1
378	4556	13	0	12	Q4	2012	4.4400	1.8204	4.0000	1
378	4606	3	0	10	Q4	2012	2.2200	1.0878	2.0000	1
378	4846	17	0	1	Q1	2012	4.4400	1.8204	4.0000	1
378	5125	17	1292	1	Q1	2012	4.4400	1.3764	4.0000	1
378	5162	22	0	2	Q1	2012	4.4400	1.7316	4.0000	1
378	5376	3	185	1	Q1	2012	3.3300	1.4985	3.0000	1
378	5813	3	0	4	Q2	2012	5.5500	2.1090	5.0000	1
378	5922	15	0	10	Q4	2012	3.3300	1.0989	3.0000	1
378	5944	3	201	8	Q3	2012	5.5500	2.2200	5.0000	1
378	6288	13	0	9	Q3	2012	2.2200	0.7548	2.0000	1
378	6470	6	518	8	Q3	2012	3.3300	1.0989	3.0000	1
378	6541	23	0	4	Q2	2012	3.3300	0.9990	3.0000	1
378	6655	11	820	2	Q1	2012	3.3300	1.0989	3.0000	1
378	6754	7	0	7	Q3	2012	2.2200	0.7770	2.0000	1
378	6832	3	0	10	Q4	2012	3.3300	1.1322	3.0000	1
378	6916	6	526	12	Q4	2012	3.3300	1.3653	3.0000	1
378	6982	13	0	7	Q3	2012	3.3300	1.5984	3.0000	1
378	7414	15	1142	5	Q2	2012	3.3300	1.1655	3.0000	1
378	7624	11	0	7	Q3	2012	4.4400	1.3764	4.0000	1
378	7642	7	0	11	Q4	2012	5.5500	2.1090	5.0000	1
378	7831	17	0	8	Q3	2012	3.3300	1.0323	3.0000	1
378	7842	15	0	7	Q3	2012	3.3300	1.2654	3.0000	1
378	7901	2	0	5	Q2	2012	1.1100	0.5106	1.0000	1
378	8023	15	0	3	Q1	2012	4.4400	1.6872	4.0000	1
378	8089	17	1303	6	Q2	2012	3.3300	1.6650	3.0000	1
378	8351	16	0	8	Q3	2012	2.2200	0.8880	2.0000	1
378	8374	3	0	7	Q3	2012	2.2200	0.9546	2.0000	1
378	8382	15	0	6	Q2	2012	3.3300	1.4652	3.0000	1
378	8617	17	0	2	Q1	2012	3.3300	1.4985	3.0000	1
378	8647	3	0	12	Q4	2012	4.4400	1.6428	4.0000	1
378	8897	11	0	2	Q1	2012	3.3300	1.2321	3.0000	1
378	8912	6	504	2	Q1	2012	3.3300	1.1322	3.0000	1
378	9271	17	0	5	Q2	2012	5.5500	2.1090	5.0000	1
378	9357	7	526	12	Q4	2012	2.2200	1.0212	2.0000	1
378	9420	13	0	7	Q3	2012	3.3300	1.6317	3.0000	1
378	9501	13	0	9	Q3	2012	4.4400	1.5540	4.0000	1
378	9976	17	0	2	Q1	2012	2.2200	1.0212	2.0000	1
378	10131	17	0	1	Q1	2012	3.3300	1.5318	3.0000	1
379	181	3	0	1	Q1	2012	15.4000	5.5440	4.0000	1
379	465	13	0	11	Q4	2012	15.4000	6.4680	4.0000	1
379	504	13	0	3	Q1	2012	7.7000	2.5410	2.0000	1
379	504	13	0	7	Q3	2012	7.7000	3.3110	2.0000	1
379	769	16	1233	10	Q4	2012	11.5500	3.4650	3.0000	1
379	994	13	0	8	Q3	2012	15.4000	7.2380	4.0000	1
379	1207	14	0	6	Q2	2012	3.8500	1.3475	1.0000	1
379	1427	6	508	4	Q2	2012	7.7000	2.3100	2.0000	1
379	1491	16	0	11	Q4	2012	11.5500	5.5440	3.0000	1
379	1801	6	524	11	Q4	2012	11.5500	5.3130	3.0000	1
379	2086	13	0	3	Q1	2012	11.5500	4.2735	3.0000	1
379	2278	6	0	11	Q4	2012	7.7000	2.5410	2.0000	1
379	2302	15	0	11	Q4	2012	15.4000	5.8520	4.0000	1
379	2343	15	0	3	Q1	2012	15.4000	7.0840	4.0000	1
379	2535	24	1859	8	Q3	2012	11.5500	3.9270	3.0000	1
379	2830	7	0	8	Q3	2012	11.5500	3.6960	3.0000	1
379	3282	6	522	10	Q4	2012	15.4000	6.4680	4.0000	1
379	3387	11	0	7	Q3	2012	11.5500	4.1580	3.0000	1
379	3423	13	0	10	Q4	2012	7.7000	3.5420	2.0000	1
379	3787	3	0	12	Q4	2012	7.7000	3.2340	2.0000	1
379	3932	15	1138	3	Q1	2012	11.5500	4.3890	3.0000	1
379	3979	13	0	4	Q2	2012	15.4000	7.3920	4.0000	1
379	4063	15	0	12	Q4	2012	19.2500	6.3525	5.0000	1
379	4193	24	0	5	Q2	2012	15.4000	4.7740	4.0000	1
379	4217	2	0	1	Q1	2012	7.7000	3.6960	2.0000	1
379	4257	3	0	7	Q3	2012	11.5500	4.6200	3.0000	1
379	4676	16	0	5	Q2	2012	15.4000	4.7740	4.0000	1
379	4703	15	0	11	Q4	2012	7.7000	2.6180	2.0000	1
379	4767	16	0	3	Q1	2012	15.4000	6.1600	4.0000	1
379	4782	24	0	8	Q3	2012	11.5500	5.5440	3.0000	1
379	4951	15	0	6	Q2	2012	19.2500	9.6250	5.0000	1
379	5016	7	0	1	Q1	2012	11.5500	3.8115	3.0000	1
379	5285	6	0	11	Q4	2012	11.5500	5.4285	3.0000	1
379	5374	16	0	5	Q2	2012	11.5500	5.1975	3.0000	1
379	5398	17	0	5	Q2	2012	11.5500	5.3130	3.0000	1
379	5514	6	0	10	Q4	2012	7.7000	2.8490	2.0000	1
379	5542	16	0	6	Q2	2012	15.4000	4.9280	4.0000	1
379	5674	7	0	5	Q2	2012	11.5500	3.6960	3.0000	1
379	5771	7	517	8	Q3	2012	11.5500	4.3890	3.0000	1
379	5903	13	980	3	Q1	2012	11.5500	4.3890	3.0000	1
379	6453	24	1869	12	Q4	2012	15.4000	5.2360	4.0000	1
379	6528	7	0	9	Q3	2012	15.4000	6.7760	4.0000	1
379	6665	6	0	3	Q1	2012	11.5500	5.6595	3.0000	1
379	6814	2	0	4	Q2	2012	3.8500	1.5400	1.0000	1
379	6835	16	1214	2	Q1	2012	15.4000	6.0060	4.0000	1
379	6854	17	0	4	Q2	2012	15.4000	5.6980	4.0000	1
379	6936	17	0	7	Q3	2012	11.5500	4.3890	3.0000	1
379	7138	11	0	6	Q2	2012	11.5500	3.5805	3.0000	1
379	7404	6	508	4	Q2	2012	11.5500	5.5440	3.0000	1
379	7416	13	980	3	Q1	2012	7.7000	2.6950	2.0000	1
379	7529	17	0	10	Q4	2012	7.7000	3.4650	2.0000	1
379	7702	16	1225	7	Q3	2012	11.5500	5.3130	3.0000	1
379	7807	15	1146	7	Q3	2012	11.5500	4.5045	3.0000	1
379	8179	11	0	12	Q4	2012	11.5500	4.8510	3.0000	1
379	8185	2	0	7	Q3	2012	7.7000	3.3880	2.0000	1
379	8260	7	0	12	Q4	2012	7.7000	2.6950	2.0000	1
379	8452	16	1235	11	Q4	2012	7.7000	3.6190	2.0000	1
379	8668	13	980	3	Q1	2012	15.4000	5.5440	4.0000	1
379	9014	13	0	2	Q1	2012	15.4000	6.0060	4.0000	1
379	9200	16	0	10	Q4	2012	11.5500	3.9270	3.0000	1
379	9318	16	0	3	Q1	2012	15.4000	6.6220	4.0000	1
379	9331	11	0	9	Q3	2012	7.7000	3.0030	2.0000	1
379	9422	6	504	2	Q1	2012	7.7000	2.7720	2.0000	1
379	9476	6	0	7	Q3	2012	11.5500	5.3130	3.0000	1
379	9550	6	526	12	Q4	2012	7.7000	3.1570	2.0000	1
379	9554	13	0	3	Q1	2012	7.7000	3.1570	2.0000	1
379	9855	6	504	2	Q1	2012	7.7000	3.4650	2.0000	1
379	10058	15	1142	5	Q2	2012	15.4000	6.0060	4.0000	1
380	255	6	511	5	Q2	2012	3.6600	1.2444	3.0000	1
380	293	22	0	9	Q3	2012	2.4400	1.1468	2.0000	1
380	378	16	0	4	Q2	2012	4.8800	1.7568	4.0000	1
380	1297	16	0	5	Q2	2012	2.4400	0.9028	2.0000	1
380	1461	24	1866	11	Q4	2012	4.8800	2.0984	4.0000	1
380	1759	7	0	7	Q3	2012	4.8800	1.9520	4.0000	1
380	1791	13	992	9	Q3	2012	2.4400	1.0004	2.0000	1
380	1979	3	0	5	Q2	2012	4.8800	2.3424	4.0000	1
380	2178	15	1138	3	Q1	2012	3.6600	1.6470	3.0000	1
380	2430	24	0	5	Q2	2012	2.4400	1.0004	2.0000	1
380	2454	24	1845	1	Q1	2012	4.8800	2.2936	4.0000	1
380	2747	24	0	6	Q2	2012	3.6600	1.1712	3.0000	1
380	2968	13	0	12	Q4	2012	4.8800	1.8544	4.0000	1
380	3145	24	0	3	Q1	2012	3.6600	1.4274	3.0000	1
380	3188	6	0	9	Q3	2012	3.6600	1.6836	3.0000	1
380	3188	7	0	5	Q2	2012	3.6600	1.1346	3.0000	1
380	3434	24	1846	2	Q1	2012	4.8800	2.2936	4.0000	1
380	3473	15	1149	8	Q3	2012	6.1000	1.9520	5.0000	1
380	3512	24	1869	12	Q4	2012	2.4400	0.9760	2.0000	1
380	3552	17	0	4	Q2	2012	3.6600	1.3542	3.0000	1
380	3759	13	0	12	Q4	2012	3.6600	1.3542	3.0000	1
380	3911	7	0	6	Q2	2012	4.8800	1.8056	4.0000	1
380	4065	3	0	6	Q2	2012	4.8800	2.0496	4.0000	1
380	4088	24	0	12	Q4	2012	6.1000	2.3790	5.0000	1
380	4234	3	0	2	Q1	2012	2.4400	0.8784	2.0000	1
380	4273	11	824	4	Q2	2012	2.4400	0.9028	2.0000	1
380	4449	7	0	6	Q2	2012	2.4400	1.1712	2.0000	1
380	4503	13	0	11	Q4	2012	2.4400	0.7320	2.0000	1
380	4543	13	0	3	Q1	2012	2.4400	0.7320	2.0000	1
380	4632	15	0	10	Q4	2012	4.8800	2.2448	4.0000	1
380	5394	6	0	9	Q3	2012	2.4400	1.0492	2.0000	1
380	5470	2	119	7	Q3	2012	2.4400	0.7320	2.0000	1
380	5530	13	0	9	Q3	2012	4.8800	1.7080	4.0000	1
380	5537	3	210	12	Q4	2012	4.8800	1.8544	4.0000	1
380	5568	23	0	12	Q4	2012	3.6600	1.4640	3.0000	1
380	5898	3	0	11	Q4	2012	3.6600	1.3908	3.0000	1
380	5992	15	0	9	Q3	2012	3.6600	1.4274	3.0000	1
380	6320	24	0	10	Q4	2012	3.6600	1.3542	3.0000	1
380	7065	17	0	6	Q2	2012	4.8800	2.4400	4.0000	1
380	7103	15	0	1	Q1	2012	3.6600	1.6836	3.0000	1
380	7300	7	0	1	Q1	2012	6.1000	2.2570	5.0000	1
380	7368	11	826	5	Q2	2012	3.6600	1.3176	3.0000	1
380	7446	13	0	5	Q2	2012	3.6600	1.6104	3.0000	1
380	7589	17	0	3	Q1	2012	4.8800	2.1472	4.0000	1
380	7769	11	0	6	Q2	2012	3.6600	1.3908	3.0000	1
380	7813	17	0	9	Q3	2012	3.6600	1.6470	3.0000	1
380	8059	17	0	10	Q4	2012	4.8800	2.0984	4.0000	1
380	8091	13	0	3	Q1	2012	3.6600	1.7934	3.0000	1
380	8130	7	0	4	Q2	2012	3.6600	1.3908	3.0000	1
380	8202	3	187	2	Q1	2012	4.8800	1.5616	4.0000	1
380	8230	24	0	11	Q4	2012	3.6600	1.3908	3.0000	1
380	8617	17	0	3	Q1	2012	3.6600	1.3176	3.0000	1
380	8695	15	1141	4	Q2	2012	4.8800	1.8056	4.0000	1
380	8746	23	0	9	Q3	2012	3.6600	1.3908	3.0000	1
380	9095	7	0	12	Q4	2012	4.8800	1.9032	4.0000	1
380	9263	16	1236	12	Q4	2012	4.8800	2.1472	4.0000	1
380	9324	3	204	9	Q3	2012	2.4400	1.0004	2.0000	1
380	9639	17	0	7	Q3	2012	3.6600	1.4640	3.0000	1
381	348	2	0	11	Q4	2012	4.6600	2.1436	2.0000	1
381	465	13	0	12	Q4	2012	9.3200	3.8212	4.0000	1
381	638	11	0	12	Q4	2012	9.3200	4.4736	4.0000	1
381	976	16	0	1	Q1	2012	6.9900	2.6562	3.0000	1
381	997	3	202	8	Q3	2012	9.3200	3.0756	4.0000	1
381	1611	13	1000	12	Q4	2012	6.9900	2.3766	3.0000	1
381	2164	14	0	7	Q3	2012	4.6600	1.8640	2.0000	1
381	2197	11	0	11	Q4	2012	9.3200	3.8212	4.0000	1
381	2224	16	0	9	Q3	2012	6.9900	2.9358	3.0000	1
381	2769	16	1216	2	Q1	2012	6.9900	3.4950	3.0000	1
381	2848	6	0	9	Q3	2012	6.9900	2.2368	3.0000	1
381	3020	13	0	9	Q3	2012	4.6600	1.7242	2.0000	1
381	3552	17	1294	2	Q1	2012	9.3200	4.6600	4.0000	1
381	3572	11	0	1	Q1	2012	6.9900	2.3766	3.0000	1
381	3976	17	0	2	Q1	2012	6.9900	2.5164	3.0000	1
381	3976	17	0	9	Q3	2012	6.9900	2.5164	3.0000	1
381	4065	3	207	11	Q4	2012	4.6600	1.8640	2.0000	1
381	4131	15	1152	9	Q3	2012	9.3200	3.0756	4.0000	1
381	4194	24	1866	11	Q4	2012	9.3200	4.6600	4.0000	1
381	4534	6	0	3	Q1	2012	9.3200	3.9144	4.0000	1
381	4566	11	0	12	Q4	2012	6.9900	3.0756	3.0000	1
381	4657	17	0	3	Q1	2012	6.9900	2.6562	3.0000	1
381	4657	17	0	6	Q2	2012	6.9900	2.6562	3.0000	1
381	4828	7	0	5	Q2	2012	6.9900	3.1455	3.0000	1
381	4836	11	0	11	Q4	2012	4.6600	2.0970	2.0000	1
381	4967	7	523	11	Q4	2012	4.6600	1.3980	2.0000	1
381	5026	17	0	9	Q3	2012	4.6600	1.9106	2.0000	1
381	5038	17	0	10	Q4	2012	9.3200	3.9144	4.0000	1
381	5174	16	0	6	Q2	2012	9.3200	4.1940	4.0000	1
381	5257	13	0	11	Q4	2012	6.9900	3.0756	3.0000	1
381	5267	15	0	11	Q4	2012	9.3200	3.4484	4.0000	1
381	5322	6	0	12	Q4	2012	6.9900	3.1455	3.0000	1
381	5353	23	0	2	Q1	2012	6.9900	3.3552	3.0000	1
381	5694	11	833	8	Q3	2012	6.9900	2.7261	3.0000	1
381	5786	13	0	5	Q2	2012	9.3200	3.2620	4.0000	1
381	5809	13	0	7	Q3	2012	6.9900	3.0756	3.0000	1
381	5982	13	0	1	Q1	2012	6.9900	2.6562	3.0000	1
381	6017	11	836	9	Q3	2012	4.6600	2.0038	2.0000	1
381	6105	23	0	12	Q4	2012	4.6600	1.9106	2.0000	1
381	6324	23	0	2	Q1	2012	9.3200	4.2872	4.0000	1
381	6666	17	0	6	Q2	2012	9.3200	4.2872	4.0000	1
381	6850	15	0	7	Q3	2012	9.3200	4.0076	4.0000	1
381	7003	15	0	5	Q2	2012	6.9900	2.5863	3.0000	1
381	7008	2	0	2	Q1	2012	2.3300	0.7223	1.0000	1
381	7079	11	0	8	Q3	2012	9.3200	3.9144	4.0000	1
381	7582	11	0	6	Q2	2012	4.6600	2.2368	2.0000	1
381	7657	11	833	8	Q3	2012	6.9900	3.1455	3.0000	1
381	7684	7	0	1	Q1	2012	6.9900	3.1455	3.0000	1
381	7731	6	0	9	Q3	2012	9.3200	4.4736	4.0000	1
381	7810	3	0	6	Q2	2012	9.3200	3.6348	4.0000	1
381	8091	13	0	9	Q3	2012	4.6600	2.2368	2.0000	1
381	8199	17	0	5	Q2	2012	4.6600	2.0970	2.0000	1
381	8202	3	0	9	Q3	2012	9.3200	2.9824	4.0000	1
381	8587	22	0	3	Q1	2012	4.6600	2.2834	2.0000	1
381	9200	16	0	5	Q2	2012	6.9900	2.4465	3.0000	1
382	76	3	0	4	Q2	2012	4.8600	1.5066	3.0000	1
382	131	24	0	3	Q1	2012	4.8600	1.6038	3.0000	1
382	181	3	0	11	Q4	2012	4.8600	1.8954	3.0000	1
382	229	15	1143	5	Q2	2012	4.8600	2.0412	3.0000	1
382	530	24	0	2	Q1	2012	3.2400	1.0692	2.0000	1
382	625	13	0	3	Q1	2012	4.8600	1.5552	3.0000	1
382	630	24	1866	11	Q4	2012	3.2400	1.1664	2.0000	1
382	666	24	0	9	Q3	2012	3.2400	1.2636	2.0000	1
382	907	7	505	2	Q1	2012	3.2400	1.2960	2.0000	1
382	1058	7	0	7	Q3	2012	3.2400	1.4580	2.0000	1
382	1331	7	0	10	Q4	2012	4.8600	1.7496	3.0000	1
382	1331	7	517	8	Q3	2012	4.8600	2.1870	3.0000	1
382	1347	13	0	6	Q2	2012	6.4800	2.4624	4.0000	1
382	1429	13	0	10	Q4	2012	6.4800	2.0736	4.0000	1
382	1601	6	0	10	Q4	2012	4.8600	1.7010	3.0000	1
382	1798	3	0	8	Q3	2012	4.8600	2.1870	3.0000	1
382	1908	15	1157	12	Q4	2012	6.4800	2.0088	4.0000	1
382	1916	13	0	8	Q3	2012	3.2400	1.2960	2.0000	1
382	1941	15	1149	8	Q3	2012	4.8600	2.1870	3.0000	1
382	2198	13	0	1	Q1	2012	4.8600	2.1870	3.0000	1
382	2444	13	0	7	Q3	2012	6.4800	3.1104	4.0000	1
382	2587	16	1214	2	Q1	2012	4.8600	2.1870	3.0000	1
382	2742	17	0	6	Q2	2012	4.8600	1.6038	3.0000	1
382	3000	17	1304	7	Q3	2012	4.8600	1.5552	3.0000	1
382	3113	13	0	2	Q1	2012	4.8600	1.9440	3.0000	1
382	4063	15	0	10	Q4	2012	6.4800	2.8512	4.0000	1
382	4413	13	0	3	Q1	2012	4.8600	2.0412	3.0000	1
382	4543	13	0	1	Q1	2012	3.2400	1.0368	2.0000	1
382	4582	6	518	8	Q3	2012	4.8600	2.4300	3.0000	1
382	5231	7	523	11	Q4	2012	3.2400	1.4904	2.0000	1
382	5376	3	197	6	Q2	2012	4.8600	2.2356	3.0000	1
382	5493	7	0	9	Q3	2012	3.2400	1.3932	2.0000	1
382	5671	7	0	6	Q2	2012	4.8600	1.5066	3.0000	1
382	5765	7	0	6	Q2	2012	4.8600	1.9926	3.0000	1
382	5944	3	0	8	Q3	2012	8.1000	3.3210	5.0000	1
382	6483	14	0	12	Q4	2012	1.6200	0.6156	1.0000	1
382	6559	3	190	3	Q1	2012	4.8600	1.9440	3.0000	1
382	6584	6	508	4	Q2	2012	4.8600	2.3814	3.0000	1
382	6822	11	842	12	Q4	2012	6.4800	2.5920	4.0000	1
382	6927	7	523	11	Q4	2012	6.4800	2.0736	4.0000	1
382	7060	7	0	6	Q2	2012	3.2400	1.3284	2.0000	1
382	7217	15	0	11	Q4	2012	4.8600	2.1384	3.0000	1
382	7438	2	0	9	Q3	2012	3.2400	1.2636	2.0000	1
382	7464	11	0	3	Q1	2012	4.8600	1.8468	3.0000	1
382	7519	24	0	2	Q1	2012	4.8600	1.5552	3.0000	1
382	7844	24	1853	5	Q2	2012	4.8600	1.9926	3.0000	1
382	7942	24	0	10	Q4	2012	4.8600	1.5066	3.0000	1
382	7942	24	1866	11	Q4	2012	3.2400	1.0692	2.0000	1
382	7996	15	0	2	Q1	2012	4.8600	1.8468	3.0000	1
382	8071	15	0	12	Q4	2012	4.8600	1.6038	3.0000	1
382	8089	17	0	7	Q3	2012	4.8600	1.8954	3.0000	1
382	8146	11	0	11	Q4	2012	6.4800	2.7864	4.0000	1
382	8206	23	1773	4	Q2	2012	3.2400	1.0692	2.0000	1
382	8373	13	0	1	Q1	2012	4.8600	1.5066	3.0000	1
382	8477	3	0	3	Q1	2012	4.8600	1.7982	3.0000	1
382	8554	24	0	11	Q4	2012	6.4800	2.5920	4.0000	1
382	8577	23	1765	1	Q1	2012	6.4800	2.4624	4.0000	1
382	8652	7	0	5	Q2	2012	3.2400	1.3284	2.0000	1
382	9102	3	0	12	Q4	2012	4.8600	2.1384	3.0000	1
382	9144	13	0	10	Q4	2012	4.8600	1.8954	3.0000	1
382	9170	7	0	1	Q1	2012	6.4800	2.8512	4.0000	1
382	9441	14	0	2	Q1	2012	1.6200	0.5994	1.0000	1
382	9658	7	0	3	Q1	2012	4.8600	1.7982	3.0000	1
382	9840	7	504	2	Q1	2012	4.8600	1.4580	3.0000	1
382	9924	15	0	1	Q1	2012	6.4800	2.1384	4.0000	1
382	10073	23	0	9	Q3	2012	3.2400	1.1340	2.0000	1
382	10092	22	0	5	Q2	2012	3.2400	1.0368	2.0000	1
382	10094	14	0	3	Q1	2012	1.6200	0.7452	1.0000	1
383	49	7	0	10	Q4	2012	8.2500	2.8050	3.0000	1
383	99	3	0	3	Q1	2012	11.0000	4.2900	4.0000	1
383	154	13	0	8	Q3	2012	8.2500	3.0525	3.0000	1
383	280	13	0	7	Q3	2012	8.2500	2.7225	3.0000	1
383	709	6	0	6	Q2	2012	8.2500	3.3000	3.0000	1
383	980	6	524	11	Q4	2012	5.5000	1.8150	2.0000	1
383	1053	13	0	4	Q2	2012	8.2500	3.1350	3.0000	1
383	1389	7	0	11	Q4	2012	8.2500	2.8875	3.0000	1
383	1528	16	0	11	Q4	2012	5.5000	1.8700	2.0000	1
383	1791	13	0	1	Q1	2012	5.5000	2.4200	2.0000	1
383	1821	13	0	12	Q4	2012	8.2500	2.5575	3.0000	1
383	1956	15	0	12	Q4	2012	5.5000	1.9800	2.0000	1
383	2180	2	0	12	Q4	2012	8.2500	2.9700	3.0000	1
383	2319	14	0	10	Q4	2012	2.7500	0.9075	1.0000	1
383	2547	23	0	12	Q4	2012	8.2500	3.2175	3.0000	1
383	2648	24	0	2	Q1	2012	11.0000	3.5200	4.0000	1
383	2787	17	1311	10	Q4	2012	8.2500	2.6400	3.0000	1
383	2981	23	1772	4	Q2	2012	8.2500	3.7950	3.0000	1
383	3216	7	514	7	Q3	2012	5.5000	1.8150	2.0000	1
383	3463	13	0	12	Q4	2012	8.2500	2.9700	3.0000	1
383	3548	13	0	9	Q3	2012	5.5000	2.0350	2.0000	1
383	3650	15	0	5	Q2	2012	8.2500	3.6300	3.0000	1
383	3787	3	0	11	Q4	2012	11.0000	3.6300	4.0000	1
383	3787	3	0	12	Q4	2012	5.5000	1.9250	2.0000	1
383	3816	3	0	8	Q3	2012	8.2500	2.8050	3.0000	1
383	3816	3	0	11	Q4	2012	5.5000	2.7500	2.0000	1
383	3980	13	0	7	Q3	2012	8.2500	3.0525	3.0000	1
383	4029	17	0	12	Q4	2012	5.5000	2.6950	2.0000	1
383	4094	16	0	3	Q1	2012	11.0000	5.2800	4.0000	1
383	4543	13	1000	12	Q4	2012	8.2500	3.5475	3.0000	1
383	4547	13	0	1	Q1	2012	8.2500	3.6300	3.0000	1
383	4666	13	0	2	Q1	2012	8.2500	2.8875	3.0000	1
383	4774	11	0	10	Q4	2012	5.5000	2.3100	2.0000	1
383	4998	3	0	2	Q1	2012	5.5000	2.3650	2.0000	1
383	5026	17	0	2	Q1	2012	5.5000	2.3100	2.0000	1
383	5063	3	207	11	Q4	2012	8.2500	3.1350	3.0000	1
383	5086	7	504	2	Q1	2012	5.5000	2.1450	2.0000	1
383	5105	11	829	6	Q2	2012	11.0000	3.6300	4.0000	1
383	5197	14	1078	12	Q4	2012	5.5000	2.4200	2.0000	1
383	5826	15	0	11	Q4	2012	11.0000	3.9600	4.0000	1
383	5948	7	0	3	Q1	2012	8.2500	3.7125	3.0000	1
383	6114	16	0	9	Q3	2012	11.0000	3.4100	4.0000	1
383	6172	15	1136	2	Q1	2012	5.5000	2.0900	2.0000	1
383	6878	7	0	9	Q3	2012	8.2500	2.5575	3.0000	1
383	7067	13	0	6	Q2	2012	11.0000	4.5100	4.0000	1
383	7138	11	0	6	Q2	2012	8.2500	2.4750	3.0000	1
383	7190	23	0	1	Q1	2012	8.2500	2.6400	3.0000	1
383	7209	11	842	12	Q4	2012	11.0000	3.8500	4.0000	1
383	7486	3	0	4	Q2	2012	5.5000	1.7600	2.0000	1
383	7743	3	185	1	Q1	2012	8.2500	2.6400	3.0000	1
383	8291	13	0	7	Q3	2012	8.2500	3.5475	3.0000	1
383	8601	6	511	5	Q2	2012	8.2500	2.5575	3.0000	1
383	9025	13	0	11	Q4	2012	5.5000	2.3650	2.0000	1
383	9033	6	0	4	Q2	2012	8.2500	3.1350	3.0000	1
383	9040	16	0	6	Q2	2012	8.2500	4.0425	3.0000	1
383	9271	17	0	8	Q3	2012	11.0000	4.6200	4.0000	1
383	9318	16	0	3	Q1	2012	11.0000	3.5200	4.0000	1
383	9622	6	522	10	Q4	2012	8.2500	4.1250	3.0000	1
383	9639	17	0	1	Q1	2012	8.2500	2.8050	3.0000	1
383	10213	6	502	1	Q1	2012	5.5000	2.2000	2.0000	1
384	5	14	1054	1	Q1	2012	1.0800	0.5184	2.0000	1
384	598	6	0	12	Q4	2012	1.6200	0.7938	3.0000	1
384	663	16	0	8	Q3	2012	1.6200	0.7776	3.0000	1
384	697	13	0	7	Q3	2012	2.1600	0.7776	4.0000	1
384	956	6	524	11	Q4	2012	1.0800	0.4320	2.0000	1
384	991	24	0	4	Q2	2012	1.6200	0.6804	3.0000	1
384	1024	17	1294	2	Q1	2012	1.6200	0.5508	3.0000	1
384	1097	23	0	4	Q2	2012	2.1600	0.9720	4.0000	1
384	1129	24	0	5	Q2	2012	1.6200	0.7290	3.0000	1
384	1282	3	204	9	Q3	2012	2.1600	0.7128	4.0000	1
384	1616	24	1860	8	Q3	2012	2.1600	0.9720	4.0000	1
384	1718	13	0	8	Q3	2012	1.6200	0.7290	3.0000	1
384	1723	7	0	11	Q4	2012	1.6200	0.6804	3.0000	1
384	1850	16	0	3	Q1	2012	2.1600	0.6480	4.0000	1
384	1956	15	0	1	Q1	2012	1.0800	0.4644	2.0000	1
384	2043	24	0	4	Q2	2012	1.6200	0.6156	3.0000	1
384	2371	16	1214	2	Q1	2012	1.0800	0.4104	2.0000	1
384	2412	7	0	7	Q3	2012	2.7000	1.2420	5.0000	1
384	2525	13	0	2	Q1	2012	1.0800	0.3888	2.0000	1
384	2684	15	1138	3	Q1	2012	1.6200	0.5184	3.0000	1
384	2775	24	0	5	Q2	2012	2.7000	1.1880	5.0000	1
384	2850	3	0	6	Q2	2012	1.6200	0.5508	3.0000	1
384	3020	13	0	1	Q1	2012	1.6200	0.6804	3.0000	1
384	3160	17	1293	1	Q1	2012	2.1600	1.0800	4.0000	1
384	3172	15	0	6	Q2	2012	2.1600	0.9288	4.0000	1
384	3197	23	0	10	Q4	2012	2.7000	1.0260	5.0000	1
384	3311	11	821	3	Q1	2012	1.6200	0.6804	3.0000	1
384	3389	7	505	2	Q1	2012	1.6200	0.5022	3.0000	1
384	3742	11	837	10	Q4	2012	2.1600	1.0584	4.0000	1
384	3981	6	518	8	Q3	2012	1.6200	0.7452	3.0000	1
384	4075	3	0	7	Q3	2012	1.0800	0.5184	2.0000	1
384	4096	3	0	4	Q2	2012	1.6200	0.6318	3.0000	1
384	4118	17	1304	7	Q3	2012	2.1600	1.0584	4.0000	1
384	4324	15	0	3	Q1	2012	1.6200	0.6156	3.0000	1
384	4372	13	0	10	Q4	2012	2.1600	0.9504	4.0000	1
384	4372	13	0	12	Q4	2012	1.6200	0.5994	3.0000	1
384	4461	11	0	4	Q2	2012	2.1600	0.8424	4.0000	1
384	4516	22	1709	11	Q4	2012	1.0800	0.4104	2.0000	1
384	4668	15	1143	5	Q2	2012	1.0800	0.3564	2.0000	1
384	4767	16	0	5	Q2	2012	2.7000	1.2420	5.0000	1
384	4873	17	1312	10	Q4	2012	1.6200	0.6156	3.0000	1
384	4875	13	0	3	Q1	2012	1.6200	0.7128	3.0000	1
384	4964	2	0	12	Q4	2012	0.5400	0.2268	1.0000	1
384	4973	17	0	3	Q1	2012	1.6200	0.5184	3.0000	1
384	5052	14	0	5	Q2	2012	1.0800	0.5292	2.0000	1
384	5060	13	984	5	Q2	2012	1.6200	0.6318	3.0000	1
384	5088	13	0	12	Q4	2012	2.7000	1.1610	5.0000	1
384	5144	6	0	7	Q3	2012	1.0800	0.4752	2.0000	1
384	5320	24	1856	6	Q2	2012	1.6200	0.6642	3.0000	1
384	5533	13	988	7	Q3	2012	1.6200	0.7128	3.0000	1
384	5547	7	0	6	Q2	2012	1.6200	0.6480	3.0000	1
384	5898	3	207	11	Q4	2012	1.6200	0.6156	3.0000	1
384	5983	6	0	12	Q4	2012	1.6200	0.4860	3.0000	1
384	6321	14	0	9	Q3	2012	0.5400	0.1782	1.0000	1
384	6403	2	0	9	Q3	2012	0.5400	0.1890	1.0000	1
384	6524	15	1150	8	Q3	2012	1.6200	0.7614	3.0000	1
384	6675	22	0	9	Q3	2012	1.0800	0.4644	2.0000	1
384	6902	15	0	12	Q4	2012	1.6200	0.6642	3.0000	1
384	7459	7	0	11	Q4	2012	2.1600	0.8856	4.0000	1
384	7589	17	0	12	Q4	2012	1.6200	0.6804	3.0000	1
384	7702	16	0	2	Q1	2012	1.0800	0.4428	2.0000	1
384	7780	13	0	5	Q2	2012	1.6200	0.6156	3.0000	1
384	7915	13	0	1	Q1	2012	1.6200	0.6480	3.0000	1
384	7948	17	1293	1	Q1	2012	1.0800	0.4860	2.0000	1
384	8059	17	0	10	Q4	2012	2.1600	0.6912	4.0000	1
384	8446	15	1152	9	Q3	2012	1.0800	0.4104	2.0000	1
384	8571	3	207	11	Q4	2012	1.0800	0.5076	2.0000	1
384	9160	6	508	4	Q2	2012	1.0800	0.4104	2.0000	1
384	9184	3	0	12	Q4	2012	1.0800	0.3456	2.0000	1
384	9187	17	0	8	Q3	2012	2.7000	1.1610	5.0000	1
384	9213	11	0	5	Q2	2012	1.6200	0.6156	3.0000	1
384	9217	7	0	3	Q1	2012	1.6200	0.6804	3.0000	1
384	9397	11	837	10	Q4	2012	2.1600	0.9504	4.0000	1
384	9504	13	0	11	Q4	2012	1.6200	0.7776	3.0000	1
384	9860	11	0	8	Q3	2012	1.6200	0.4860	3.0000	1
384	10157	7	0	3	Q1	2012	1.6200	0.5022	3.0000	1
385	154	13	0	12	Q4	2012	4.6800	1.6380	3.0000	1
385	314	15	0	5	Q2	2012	4.6800	1.4508	3.0000	1
385	595	24	0	7	Q3	2012	6.2400	1.9968	4.0000	1
385	770	17	1307	8	Q3	2012	6.2400	3.1200	4.0000	1
385	995	7	0	10	Q4	2012	4.6800	1.8252	3.0000	1
385	997	3	201	8	Q3	2012	4.6800	1.7316	3.0000	1
385	1193	13	0	11	Q4	2012	4.6800	1.9656	3.0000	1
385	1196	13	0	8	Q3	2012	4.6800	1.4040	3.0000	1
385	1310	16	0	3	Q1	2012	6.2400	3.0576	4.0000	1
385	1351	24	0	10	Q4	2012	6.2400	2.8704	4.0000	1
385	1399	24	0	5	Q2	2012	6.2400	2.8080	4.0000	1
385	1429	13	0	1	Q1	2012	3.1200	1.2792	2.0000	1
385	1528	16	0	6	Q2	2012	3.1200	1.0608	2.0000	1
385	1978	15	0	2	Q1	2012	4.6800	1.6848	3.0000	1
385	2084	17	0	6	Q2	2012	6.2400	2.5584	4.0000	1
385	2224	16	0	9	Q3	2012	4.6800	1.6848	3.0000	1
385	2553	16	0	8	Q3	2012	4.6800	1.4040	3.0000	1
385	3218	3	0	5	Q2	2012	3.1200	1.3104	2.0000	1
385	3473	15	0	9	Q3	2012	6.2400	2.9328	4.0000	1
385	3480	7	0	4	Q2	2012	4.6800	1.7316	3.0000	1
385	4070	23	1783	9	Q3	2012	4.6800	2.0124	3.0000	1
385	4431	13	0	1	Q1	2012	6.2400	2.1216	4.0000	1
385	4682	15	1136	2	Q1	2012	6.2400	2.9328	4.0000	1
385	4868	16	0	7	Q3	2012	4.6800	2.0592	3.0000	1
385	5024	15	0	11	Q4	2012	6.2400	2.3088	4.0000	1
385	5410	17	1311	10	Q4	2012	4.6800	2.0592	3.0000	1
385	5504	14	0	7	Q3	2012	3.1200	1.0920	2.0000	1
385	5579	15	0	11	Q4	2012	6.2400	2.9952	4.0000	1
385	5736	7	501	1	Q1	2012	6.2400	2.9952	4.0000	1
385	5809	13	0	7	Q3	2012	6.2400	2.4960	4.0000	1
385	6153	16	1216	2	Q1	2012	3.1200	1.2480	2.0000	1
385	6168	17	0	5	Q2	2012	6.2400	2.8080	4.0000	1
385	6496	3	0	2	Q1	2012	4.6800	2.0124	3.0000	1
385	6530	17	0	7	Q3	2012	4.6800	2.1060	3.0000	1
385	6757	6	0	4	Q2	2012	3.1200	1.0608	2.0000	1
385	6861	11	0	6	Q2	2012	6.2400	2.6208	4.0000	1
385	7196	7	0	4	Q2	2012	4.6800	1.5912	3.0000	1
385	7243	13	984	5	Q2	2012	4.6800	2.0592	3.0000	1
385	7268	15	0	11	Q4	2012	4.6800	1.7784	3.0000	1
385	7324	6	504	2	Q1	2012	4.6800	2.0592	3.0000	1
385	7388	24	0	1	Q1	2012	6.2400	2.5584	4.0000	1
385	7486	3	207	11	Q4	2012	4.6800	2.0124	3.0000	1
385	7526	17	0	3	Q1	2012	3.1200	1.1856	2.0000	1
385	7558	13	0	6	Q2	2012	4.6800	2.1996	3.0000	1
385	7743	3	0	10	Q4	2012	4.6800	1.9188	3.0000	1
385	7831	17	0	9	Q3	2012	6.2400	2.8080	4.0000	1
385	7913	17	0	12	Q4	2012	4.6800	2.1528	3.0000	1
385	7938	24	0	9	Q3	2012	4.6800	1.5912	3.0000	1
385	8159	6	0	8	Q3	2012	4.6800	2.0124	3.0000	1
385	8223	14	0	3	Q1	2012	1.5600	0.7176	1.0000	1
385	8382	15	0	6	Q2	2012	6.2400	3.0576	4.0000	1
385	8382	15	0	9	Q3	2012	3.1200	1.1856	2.0000	1
385	8993	24	1869	12	Q4	2012	3.1200	1.1856	2.0000	1
385	9064	17	0	11	Q4	2012	3.1200	1.3728	2.0000	1
385	9067	6	0	3	Q1	2012	4.6800	2.0124	3.0000	1
385	9072	24	0	12	Q4	2012	4.6800	1.7784	3.0000	1
385	9140	7	0	10	Q4	2012	4.6800	2.1528	3.0000	1
385	9213	11	0	11	Q4	2012	4.6800	2.3400	3.0000	1
385	9231	11	0	12	Q4	2012	4.6800	2.3400	3.0000	1
385	9299	24	1860	8	Q3	2012	4.6800	1.7784	3.0000	1
385	9476	6	0	7	Q3	2012	6.2400	2.3712	4.0000	1
385	9534	17	0	5	Q2	2012	6.2400	2.4960	4.0000	1
385	9639	17	0	2	Q1	2012	4.6800	1.8252	3.0000	1
385	9897	16	0	7	Q3	2012	3.1200	1.4976	2.0000	1
385	9976	17	1303	6	Q2	2012	4.6800	1.8252	3.0000	1
385	10262	17	0	10	Q4	2012	6.2400	2.4336	4.0000	1
386	293	22	0	4	Q2	2012	4.4600	1.3380	2.0000	1
386	569	23	0	10	Q4	2012	4.4600	2.0070	2.0000	1
386	636	17	1303	6	Q2	2012	6.6900	3.0774	3.0000	1
386	976	16	1233	10	Q4	2012	6.6900	2.5422	3.0000	1
386	1058	7	504	2	Q1	2012	4.4600	1.8732	2.0000	1
386	1624	11	826	5	Q2	2012	6.6900	3.0105	3.0000	1
386	1633	3	0	2	Q1	2012	11.1500	4.6830	5.0000	1
386	1637	15	0	10	Q4	2012	8.9200	2.8544	4.0000	1
386	1893	13	0	7	Q3	2012	6.6900	2.2077	3.0000	1
386	2198	13	0	1	Q1	2012	6.6900	3.0105	3.0000	1
386	2202	6	522	10	Q4	2012	6.6900	3.1443	3.0000	1
386	2224	16	0	12	Q4	2012	8.9200	4.4600	4.0000	1
386	2781	24	1856	6	Q2	2012	8.9200	3.9248	4.0000	1
386	2850	3	0	7	Q3	2012	4.4600	1.6056	2.0000	1
386	2905	3	0	5	Q2	2012	6.6900	2.8098	3.0000	1
386	2951	24	0	7	Q3	2012	6.6900	2.4753	3.0000	1
386	3101	11	0	6	Q2	2012	8.9200	3.0328	4.0000	1
386	3370	6	0	8	Q3	2012	4.4600	1.9178	2.0000	1
386	3460	11	829	6	Q2	2012	4.4600	1.7840	2.0000	1
386	3693	3	207	11	Q4	2012	6.6900	3.0105	3.0000	1
386	3719	23	0	10	Q4	2012	11.1500	4.7945	5.0000	1
386	4031	14	0	4	Q2	2012	4.4600	2.1854	2.0000	1
386	4099	17	1307	8	Q3	2012	6.6900	2.4084	3.0000	1
386	4151	6	0	4	Q2	2012	6.6900	2.5422	3.0000	1
386	4239	17	0	12	Q4	2012	8.9200	4.1924	4.0000	1
386	4282	15	0	10	Q4	2012	6.6900	3.1443	3.0000	1
386	4342	13	0	4	Q2	2012	6.6900	2.4084	3.0000	1
386	4397	16	0	3	Q1	2012	8.9200	4.3708	4.0000	1
386	4707	11	0	1	Q1	2012	4.4600	1.6056	2.0000	1
386	4843	24	0	2	Q1	2012	8.9200	3.0328	4.0000	1
386	5092	17	0	3	Q1	2012	6.6900	2.9436	3.0000	1
386	5303	17	1314	11	Q4	2012	6.6900	2.6091	3.0000	1
386	5432	16	1235	11	Q4	2012	4.4600	1.3380	2.0000	1
386	5533	13	0	2	Q1	2012	6.6900	2.9436	3.0000	1
386	5836	24	0	12	Q4	2012	8.9200	3.4788	4.0000	1
386	6350	13	0	6	Q2	2012	6.6900	2.6091	3.0000	1
386	6526	13	0	7	Q3	2012	4.4600	1.5610	2.0000	1
386	6861	11	842	12	Q4	2012	4.4600	1.6056	2.0000	1
386	7241	17	0	3	Q1	2012	8.9200	4.4600	4.0000	1
386	7490	24	1853	5	Q2	2012	6.6900	2.4753	3.0000	1
386	7525	2	0	9	Q3	2012	4.4600	2.0516	2.0000	1
386	8094	7	0	7	Q3	2012	8.9200	3.3896	4.0000	1
386	8102	24	0	9	Q3	2012	4.4600	1.8286	2.0000	1
386	8214	7	0	12	Q4	2012	6.6900	3.2112	3.0000	1
386	8298	13	0	3	Q1	2012	6.6900	2.2077	3.0000	1
386	8415	11	0	4	Q2	2012	8.9200	3.5680	4.0000	1
386	8555	11	818	1	Q1	2012	4.4600	2.1854	2.0000	1
386	8557	7	504	2	Q1	2012	8.9200	3.8356	4.0000	1
386	8731	3	0	9	Q3	2012	6.6900	2.4084	3.0000	1
386	9194	17	0	5	Q2	2012	11.1500	4.7945	5.0000	1
386	9670	6	518	8	Q3	2012	6.6900	3.0774	3.0000	1
386	9710	7	0	12	Q4	2012	8.9200	3.4788	4.0000	1
386	9728	16	1214	2	Q1	2012	6.6900	2.2746	3.0000	1
386	9815	16	0	6	Q2	2012	4.4600	2.0516	2.0000	1
386	9863	13	0	9	Q3	2012	4.4600	1.8286	2.0000	1
386	10273	17	0	11	Q4	2012	4.4600	1.5164	2.0000	1
387	569	23	1789	12	Q4	2012	7.2300	2.3859	3.0000	1
387	729	24	0	12	Q4	2012	7.2300	3.5427	3.0000	1
387	1235	11	0	3	Q1	2012	7.2300	2.4582	3.0000	1
387	1332	11	0	1	Q1	2012	7.2300	2.3859	3.0000	1
387	1706	13	980	3	Q1	2012	9.6400	4.7236	4.0000	1
387	2084	17	0	6	Q2	2012	7.2300	3.1812	3.0000	1
387	2241	7	0	11	Q4	2012	9.6400	3.8560	4.0000	1
387	2368	3	210	12	Q4	2012	4.8200	2.1690	2.0000	1
387	2448	16	0	1	Q1	2012	7.2300	2.4582	3.0000	1
387	2547	23	0	8	Q3	2012	9.6400	3.1812	4.0000	1
387	2764	15	1134	1	Q1	2012	12.0500	4.8200	5.0000	1
387	2815	22	0	7	Q3	2012	4.8200	1.4942	2.0000	1
387	2846	11	0	7	Q3	2012	4.8200	1.5424	2.0000	1
387	2865	7	516	8	Q3	2012	9.6400	4.4344	4.0000	1
387	3101	11	0	4	Q2	2012	7.2300	2.3859	3.0000	1
387	3245	17	1314	11	Q4	2012	7.2300	2.8920	3.0000	1
387	3404	24	0	7	Q3	2012	7.2300	3.5427	3.0000	1
387	3436	11	0	5	Q2	2012	7.2300	2.8197	3.0000	1
387	3803	24	0	2	Q1	2012	7.2300	2.4582	3.0000	1
387	3946	7	0	9	Q3	2012	9.6400	3.5668	4.0000	1
387	4524	24	0	10	Q4	2012	4.8200	2.0726	2.0000	1
387	4618	3	0	6	Q2	2012	12.0500	5.3020	5.0000	1
387	4707	11	0	1	Q1	2012	4.8200	2.0726	2.0000	1
387	5307	6	0	8	Q3	2012	7.2300	3.6150	3.0000	1
387	5410	17	0	4	Q2	2012	7.2300	3.1812	3.0000	1
387	5592	16	0	8	Q3	2012	7.2300	2.8920	3.0000	1
387	5844	17	0	11	Q4	2012	9.6400	3.4704	4.0000	1
387	5973	3	0	10	Q4	2012	12.0500	4.9405	5.0000	1
387	6061	17	0	8	Q3	2012	7.2300	3.3981	3.0000	1
387	6114	16	0	9	Q3	2012	7.2300	2.1690	3.0000	1
387	6228	11	0	5	Q2	2012	7.2300	2.3859	3.0000	1
387	6617	7	526	12	Q4	2012	7.2300	2.3136	3.0000	1
387	6878	7	0	9	Q3	2012	7.2300	2.1690	3.0000	1
387	6933	15	1154	10	Q4	2012	7.2300	2.8197	3.0000	1
387	7038	24	1845	1	Q1	2012	7.2300	2.8197	3.0000	1
387	7141	17	0	12	Q4	2012	4.8200	1.8316	2.0000	1
387	7330	6	0	4	Q2	2012	7.2300	3.4704	3.0000	1
387	7366	3	0	7	Q3	2012	9.6400	3.7596	4.0000	1
387	7507	6	0	5	Q2	2012	7.2300	2.7474	3.0000	1
387	7913	17	0	2	Q1	2012	7.2300	2.2413	3.0000	1
387	8014	24	0	4	Q2	2012	4.8200	1.5906	2.0000	1
387	8281	17	0	11	Q4	2012	9.6400	2.9884	4.0000	1
387	8435	17	0	9	Q3	2012	9.6400	3.1812	4.0000	1
387	8443	24	0	3	Q1	2012	4.8200	2.2654	2.0000	1
387	8623	24	1856	6	Q2	2012	7.2300	3.1089	3.0000	1
387	9299	24	0	3	Q1	2012	9.6400	3.8560	4.0000	1
387	9524	3	0	12	Q4	2012	7.2300	2.9643	3.0000	1
387	9866	3	0	10	Q4	2012	9.6400	3.9524	4.0000	1
387	9903	6	524	11	Q4	2012	7.2300	3.2535	3.0000	1
388	163	7	0	10	Q4	2012	7.0500	2.6085	3.0000	1
388	409	24	0	1	Q1	2012	9.4000	3.1960	4.0000	1
388	638	11	0	2	Q1	2012	4.7000	1.9740	2.0000	1
388	644	13	0	5	Q2	2012	7.0500	2.8905	3.0000	1
388	806	17	0	2	Q1	2012	7.0500	2.9610	3.0000	1
388	1603	14	0	8	Q3	2012	2.3500	0.7285	1.0000	1
388	1706	13	0	7	Q3	2012	4.7000	1.7860	2.0000	1
388	1718	13	0	7	Q3	2012	9.4000	4.6060	4.0000	1
388	1896	22	0	7	Q3	2012	2.3500	1.1280	1.0000	1
388	2431	3	0	12	Q4	2012	7.0500	3.2430	3.0000	1
388	2496	11	0	1	Q1	2012	7.0500	2.2560	3.0000	1
388	2592	6	519	9	Q3	2012	7.0500	3.0315	3.0000	1
388	2647	6	523	11	Q4	2012	7.0500	2.9610	3.0000	1
388	2695	13	0	9	Q3	2012	4.7000	2.1620	2.0000	1
388	2724	24	0	8	Q3	2012	7.0500	2.3970	3.0000	1
388	2850	3	0	6	Q2	2012	9.4000	4.0420	4.0000	1
388	2917	15	0	3	Q1	2012	7.0500	2.2560	3.0000	1
388	2947	17	1303	6	Q2	2012	7.0500	3.4545	3.0000	1
388	3245	17	0	8	Q3	2012	4.7000	2.0210	2.0000	1
388	3422	23	0	10	Q4	2012	7.0500	2.3265	3.0000	1
388	3497	17	0	6	Q2	2012	4.7000	1.8800	2.0000	1
388	3552	17	0	5	Q2	2012	7.0500	2.6790	3.0000	1
388	3889	3	207	11	Q4	2012	9.4000	3.1020	4.0000	1
388	4099	17	0	7	Q3	2012	7.0500	3.1725	3.0000	1
388	4132	6	506	3	Q1	2012	7.0500	3.3840	3.0000	1
388	4405	13	980	3	Q1	2012	7.0500	2.9610	3.0000	1
388	5163	3	188	2	Q1	2012	4.7000	1.9270	2.0000	1
388	5303	17	0	9	Q3	2012	7.0500	2.7495	3.0000	1
388	5374	16	0	9	Q3	2012	4.7000	2.1150	2.0000	1
388	5419	17	0	3	Q1	2012	7.0500	3.3135	3.0000	1
388	5568	23	0	5	Q2	2012	7.0500	2.8905	3.0000	1
388	5611	24	0	3	Q1	2012	4.7000	1.8330	2.0000	1
388	5829	22	0	12	Q4	2012	4.7000	1.5510	2.0000	1
388	6136	7	518	8	Q3	2012	9.4000	3.6660	4.0000	1
388	6278	6	0	12	Q4	2012	7.0500	3.3135	3.0000	1
388	6362	14	0	5	Q2	2012	4.7000	2.3030	2.0000	1
388	6600	6	0	6	Q2	2012	7.0500	3.4545	3.0000	1
388	6666	17	0	6	Q2	2012	11.7500	4.4650	5.0000	1
388	6781	15	0	9	Q3	2012	4.7000	2.1150	2.0000	1
388	7189	13	0	4	Q2	2012	9.4000	4.2300	4.0000	1
388	7884	11	0	12	Q4	2012	9.4000	3.2900	4.0000	1
388	7963	11	0	11	Q4	2012	11.7500	5.1700	5.0000	1
388	8238	15	0	11	Q4	2012	7.0500	3.2430	3.0000	1
388	8312	7	0	4	Q2	2012	9.4000	4.3240	4.0000	1
388	8472	17	1304	7	Q3	2012	7.0500	2.3265	3.0000	1
388	8518	24	1850	3	Q1	2012	7.0500	3.1020	3.0000	1
388	8619	13	0	11	Q4	2012	7.0500	2.7495	3.0000	1
388	8730	7	0	12	Q4	2012	4.7000	2.3500	2.0000	1
388	8731	3	0	7	Q3	2012	4.7000	2.0680	2.0000	1
388	8958	22	1711	12	Q4	2012	4.7000	1.4570	2.0000	1
388	9310	15	0	4	Q2	2012	7.0500	2.4675	3.0000	1
388	9318	16	0	7	Q3	2012	9.40