/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.services.s3.internal.AbstractRepeatableInputStream;
import com.amazonaws.services.s3.internal.crypto.CipherFactory;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;

public class RepeatableCipherInputStream
extends AbstractRepeatableInputStream {
    private CipherFactory cipherFactory;
    private InputStream unencryptedDataStream;

    public RepeatableCipherInputStream(InputStream input, CipherFactory cipherFactory) {
        super(RepeatableCipherInputStream.createCipherInputStream(input, cipherFactory));
        this.unencryptedDataStream = input;
        this.cipherFactory = cipherFactory;
        this.unencryptedDataStream.mark(-1);
    }

    private static CipherInputStream createCipherInputStream(InputStream input, CipherFactory cipherFactory) {
        Cipher cipher = cipherFactory.createCipher();
        return new CipherInputStream(input, cipher);
    }

    protected void reopenWrappedStream() throws IOException {
        this.unencryptedDataStream.reset();
        this.in = RepeatableCipherInputStream.createCipherInputStream(this.unencryptedDataStream, this.cipherFactory);
    }
}

