/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.crypto;

import com.jaspersoft.jasperserver.crypto.EncryptionProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class KeystoreManager {
    private static final Logger a = LogManager.getLogger(KeystoreManager.class);
    private static SecureRandom a;
    public static final String KS_TYPE = "jceks";
    public static final String KS_PROP_NAME = ".jrsksp";
    public static final String KS_NAME = ".jrsks";
    public static final String BUILD_KEY_ALIAS = "buildSecret";
    public static final String PROP_KS_PWD = "ksPwd";
    public static final String PROP_BUILD_KEY_PWD = "build.key.pwd";
    public static final String PROP_KS_PATH = "ksPath";
    public static final String PROP_BUILD_KEY_ALGO = "build.key.algo";
    public static final String PROP_BUILD_KEY_SIZE = "build.key.size";
    public static final String PROP_DEFAULT_ENC_TRANFORMATION = "enc.transformation";
    public static final String PROP_DEFAULT_ENC_BLOCK_SIZE = "enc.block.size";
    private static KeystoreManager a;
    private String a;
    private Properties a;
    private String b;
    private EncryptionProperties a;
    private KeyStore a = new Properties();

    private KeystoreManager(String string) {
        FileInputStream fileInputStream = null;
        try {
            a.info((Object)"KeystoreManager constructor");
            this.a = string + File.separator + KS_PROP_NAME;
            this.a = KeystoreManager.a(this.a);
            if (this.a == null) {
                throw new Exception("Keystore set up failed.");
            }
            this.b = this.a.getProperty(PROP_KS_PATH);
            this.a = KeyStore.getInstance(KS_TYPE);
            fileInputStream = new FileInputStream(this.b);
            this.a.load(fileInputStream, this.a.getProperty(PROP_KS_PWD).toCharArray());
            Integer n = Integer.parseInt(this.a.getProperty(PROP_BUILD_KEY_SIZE, String.valueOf(128)));
            String string2 = this.a.getProperty(PROP_BUILD_KEY_ALGO, "AES");
            int n2 = Integer.parseInt(this.a.getProperty(PROP_DEFAULT_ENC_BLOCK_SIZE, String.valueOf(16)));
            String string3 = this.a.getProperty(PROP_DEFAULT_ENC_TRANFORMATION, "AES/CBC/PKCS5Padding");
            this.a = new EncryptionProperties(n2, string3, n, string2);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                a.error((Object)("Failed to close ks: " + iOException));
            }
        }
    }

    private KeystoreManager(String string, String string2, EncryptionProperties encryptionProperties) {
        FileInputStream fileInputStream = null;
        try {
            a.trace((Object)"KeystoreManager constructor");
            this.a = string + File.separator + KS_PROP_NAME;
            this.a = KeystoreManager.a(this.a);
            if (this.a != null) {
                this.a = KeyStore.getInstance(KS_TYPE);
                this.b = this.a.getProperty(PROP_KS_PATH);
                fileInputStream = new FileInputStream(this.b);
                this.a.load(fileInputStream, this.a.getProperty(PROP_KS_PWD).toCharArray());
                String string3 = this.a.getProperty(PROP_DEFAULT_ENC_BLOCK_SIZE);
                String string4 = this.a.getProperty(PROP_BUILD_KEY_SIZE);
                this.a = new EncryptionProperties(string3 != null && !string3.trim().isEmpty() ? Integer.valueOf(Integer.parseInt(string3)) : null, this.a.getProperty(PROP_DEFAULT_ENC_TRANFORMATION), string4 != null && !string4.trim().isEmpty() ? Integer.valueOf(Integer.parseInt(string4)) : null, this.a.getProperty(PROP_BUILD_KEY_ALGO));
            } else {
                this.b = string2 + File.separator + KS_NAME;
                this.a = encryptionProperties;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                a.error((Object)("Failed to close ks: " + iOException));
            }
        }
    }

    public static synchronized KeystoreManager getInstance() {
        if (a == null) {
            String string;
            try {
                string = System.getenv("ksp");
                if (string != null && !string.isEmpty()) {
                    a = new KeystoreManager(string);
                    return a;
                }
                a.trace((Object)"Unable to access keystore properties as a system variable.");
            }
            catch (Exception exception) {
                a.warn((Object)("Unable to access keystore properties 1: " + exception.getMessage()));
            }
            try {
                string = System.getProperty("user.home");
                a = new KeystoreManager(string);
                return a;
            }
            catch (Exception exception) {
                a.warn((Object)("Unable to access keystore properties 2: " + exception.getMessage()));
                throw new RuntimeException("KeystoreManager.init was never called or there are errors instantiating an instance.");
            }
        }
        return a;
    }

    public static synchronized void init(String string) {
        if (a != null) {
            a.warn((Object)"Keystore has already been initialized.");
            return;
        }
        if (string == null) {
            throw new RuntimeException("keystore attribute is null.  It's required for " + KeystoreManager.class + " init.");
        }
        a = new KeystoreManager(string);
        a.a();
    }

    public static synchronized void init(String string, String string2, EncryptionProperties encryptionProperties) {
        if (a != null) {
            a.warn((Object)"Keystore has already been initialized.");
            return;
        }
        if (string == null) {
            throw new RuntimeException("keystore attribute is null.  It's required for " + KeystoreManager.class + " init.");
        }
        a.trace((Object)"KeystoreManager init");
        a = new KeystoreManager(string2, string, encryptionProperties);
        a.a();
    }

    private void a() {
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        try {
            if (this.a != null) {
                a.trace((Object)("Kesytore might already exist at " + this.a.getProperty(PROP_KS_PATH)));
                return;
            }
            File file = new File(this.b);
            if (!file.exists()) {
                a.trace((Object)String.format("Creating %s keystore in %s\n", KS_TYPE, this.b));
                EncryptionProperties.KeyProperties keyProperties = this.a.getKeyProperties();
                SecretKey secretKey = KeystoreManager.generateSecret(keyProperties.getKeyAlgo(), keyProperties.getKeySize());
                String string = this.a();
                String string2 = this.a();
                this.a = new Properties();
                this.a.setProperty(PROP_KS_PWD, string);
                this.a.setProperty(PROP_BUILD_KEY_PWD, string2);
                this.a.setProperty(PROP_KS_PATH, this.b);
                this.a.setProperty(PROP_BUILD_KEY_SIZE, String.valueOf(keyProperties.getKeySize()));
                this.a.setProperty(PROP_BUILD_KEY_ALGO, keyProperties.getKeyAlgo());
                this.a.setProperty(PROP_DEFAULT_ENC_BLOCK_SIZE, String.valueOf(this.a.getBlockSize()));
                this.a.setProperty(PROP_DEFAULT_ENC_TRANFORMATION, this.a.getCipherTransformation());
                this.a.store((OutputStream)new Base64OutputStream((OutputStream)new FileOutputStream(this.a)), "");
                this.a = KeyStore.getInstance(KS_TYPE);
                this.a.load(null);
                this.a.setKeyEntry(BUILD_KEY_ALIAS, secretKey, string2.toCharArray(), null);
                fileOutputStream = new FileOutputStream(file);
                this.a.store(fileOutputStream, string.toCharArray());
            } else {
                a.debug((Object)String.format("Found %s keystore in %s\n", KS_TYPE, this.a));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create a keystore and a key", exception);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                a.error((Object)("Unable to close keystore " + this.b));
            }
            try {
                if (fileOutputStream2 != null) {
                    fileOutputStream2.close();
                }
            }
            catch (IOException iOException) {
                a.error((Object)"Unable to close keystore prop");
            }
        }
    }

    private static Properties a(String string) {
        FileInputStream fileInputStream = null;
        try {
            File file = new File(string);
            if (!file.exists()) {
                Properties properties = null;
                return properties;
            }
            fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load((InputStream)new Base64InputStream((InputStream)fileInputStream));
            if (properties.get(PROP_KS_PATH) == null || properties.get(PROP_KS_PWD) == null || properties.get(PROP_BUILD_KEY_PWD) == null) {
                throw new Exception("Keystore may have been tempered with.");
            }
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                a.error((Object)("Failed to close kspPath: " + iOException));
            }
        }
    }

    public static SecretKey generateSecret(String string, int n) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(string);
            keyGenerator.init(n);
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    private String a() {
        byte[] byArray = new byte[(int)(Math.random() * 10.0 + 20.0)];
        if (a == null) {
            a = new SecureRandom(SecureRandom.getSeed(32));
        }
        a.nextBytes(byArray);
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        for (byte by : byArray) {
            stringBuffer.append((char)(Math.abs(by % 94) + 33));
        }
        return stringBuffer.toString();
    }

    public Key getBuildKey() {
        try {
            return this.a.getKey(BUILD_KEY_ALIAS, this.a.getProperty(PROP_BUILD_KEY_PWD).toCharArray());
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to read key buildSecret", exception);
        }
    }

    public String getDefaultEncTranformation() {
        return this.a.getProperty(PROP_DEFAULT_ENC_TRANFORMATION);
    }

    public Integer getDefaultEncBlockSize() {
        String string = this.a.getProperty(PROP_DEFAULT_ENC_BLOCK_SIZE);
        return string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
    }
}

