/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.util.RepositoryLabelIDHelper;
import com.jaspersoft.jasperserver.search.service.FolderService;
import com.jaspersoft.jasperserver.search.service.impl.BaseService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class FolderServiceImpl
extends BaseService
implements FolderService {
    private static final Log log = LogFactory.getLog(FolderServiceImpl.class);

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public Folder create(String parentUri, String label, String description) {
        if (parentUri == null || label == null || description == null) {
            return null;
        }
        label = label.trim();
        description = description.trim();
        if (this.isObjectLabelExist(parentUri, label)) {
            throw new JSException("jsexception.folder.duplicate.name", new Object[]{label, parentUri});
        }
        FolderImpl folder = new FolderImpl();
        String generatedId = RepositoryLabelIDHelper.generateIdBasedOnLabel((RepositoryService)this.repositoryService, (String)parentUri, (String)label);
        folder.setParentFolder(parentUri);
        folder.setName(generatedId);
        folder.setLabel(label);
        folder.setDescription(description);
        this.repositoryService.saveFolder(null, (Folder)folder);
        return folder;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public Folder update(String folderUri, String label, String description) {
        Folder folder = this.repositoryService.getFolder(null, folderUri);
        if (folder == null) {
            throw new JSException("jsexception.folder.not.found", new Object[]{folderUri});
        }
        if (this.isObjectLabelExist(folder.getParentURI(), label, folderUri)) {
            throw new JSException("jsexception.folder.duplicate.name", new Object[]{label, folder.getParentURI()});
        }
        if (!label.equals(folder.getLabel()) || !description.equals(folder.getDescription())) {
            folder.setLabel(label);
            folder.setDescription(description);
            this.repositoryService.saveFolder(null, folder);
        }
        return folder;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void delete(String folderUri) {
        if (folderUri != null && folderUri.length() == 0) {
            return;
        }
        this.repositoryService.deleteFolder(null, folderUri);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void copy(String folderUri, String destinationFolderUri) {
        Folder folder;
        String parentFolderUri = destinationFolderUri;
        int lastIndex = folderUri.lastIndexOf("/");
        if (lastIndex != -1) {
            destinationFolderUri = destinationFolderUri + "/" + folderUri.substring(lastIndex + 1);
        }
        if ((folder = this.repositoryService.getFolder(null, folderUri)) == null) {
            throw new JSException("jsexception.folder.not.found", new Object[]{folderUri});
        }
        String folderLabel = folder.getLabel();
        if (this.isObjectLabelExist(parentFolderUri, folderLabel)) {
            throw new JSException("jsexception.folder.duplicate.label", new Object[]{folderLabel, parentFolderUri});
        }
        this.repositoryService.copyFolder(null, folderUri, destinationFolderUri);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void move(String folderUri, String destinationFolderUri) {
        Folder folder = this.repositoryService.getFolder(null, folderUri);
        if (folder == null) {
            throw new JSException("jsexception.folder.not.found", new Object[]{folderUri});
        }
        String folderLabel = folder.getLabel();
        if (this.isObjectLabelExist(destinationFolderUri, folderLabel)) {
            throw new JSException("jsexception.folder.duplicate.label", new Object[]{folderLabel, destinationFolderUri});
        }
        this.repositoryService.moveFolder(null, folderUri, destinationFolderUri);
    }

    private String getParentUri(String folderUri) {
        return folderUri.substring(0, folderUri.lastIndexOf(47));
    }

    @Override
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

