/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.search.action.BaseSearchAction;
import com.jaspersoft.jasperserver.search.common.ResourceDetails;
import com.jaspersoft.jasperserver.search.service.ResourceService;
import com.jaspersoft.jasperserver.search.util.JSONConverter;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ResourceAction
extends BaseSearchAction {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String AJAX_RESPONSE_MODEL = "ajaxResponseModel";
    private ResourceService resourceService;

    public Event init(RequestContext context) throws Exception {
        Assert.notNull((Object)this.resourceService);
        return this.success();
    }

    public Event update(RequestContext context) throws Exception {
        JSONObject response;
        JSONConverter jsonConverter = this.getConverter(context);
        try {
            Resource r = jsonConverter.jsonToResource(this.getParameter(context, "selectedResource"));
            ResourceDetails resource = this.resourceService.update(r.getURIString(), r.getLabel(), r.getDescription());
            response = jsonConverter.createJSONResponse(jsonConverter.resourceToJson(resource));
        }
        catch (Exception e) {
            response = jsonConverter.createErrorJSONResponse(this.getErrorMessage(e));
            this.log.debug((Object)"SEARCH_ERROR: Can't update resource properties.", (Throwable)e);
        }
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)response.toString());
        return this.success();
    }

    public Event delete(RequestContext context) throws Exception {
        JSONObject response;
        JSONConverter jsonConverter = this.getConverter(context);
        try {
            List<Resource> selectedResources = jsonConverter.jsonArrayToResources(this.getParameter(context, "selectedResources"));
            if (CollectionUtils.isEmpty(selectedResources)) {
                throw new JSException("No resources to delete.");
            }
            List<ResourceDetails> dependentResources = this.resourceService.check(this.exContext(context), selectedResources);
            if (dependentResources.isEmpty()) {
                this.resourceService.delete(selectedResources);
                response = jsonConverter.deleteResourcesJSONResponse(selectedResources);
            } else {
                response = jsonConverter.dependentResourcesJSONResponse(dependentResources);
            }
        }
        catch (JSExceptionWrapper e) {
            response = jsonConverter.createErrorJSONResponse(this.messages.getMessage("jsp.flowRemoveError.errorMsg2", null, LocaleContextHolder.getLocale()));
            this.log.debug((Object)"SEARCH_ERROR: Can't delete resource.", (Throwable)e);
        }
        catch (Exception e) {
            response = jsonConverter.createErrorJSONResponse(this.getErrorMessage(e));
            this.log.debug((Object)"SEARCH_ERROR: Can't delete resource.", (Throwable)e);
        }
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)response.toString());
        return this.success();
    }

    public Event copy(RequestContext context) throws Exception {
        JSONObject response;
        JSONConverter jsonConverter = this.getConverter(context);
        try {
            Set<String> selectedResources = jsonConverter.jsonStringArrayToSet(this.getParameter(context, "selectedResources"));
            String folder = this.getParameter(context, "destFolderUri");
            this.resourceService.copy(selectedResources, folder);
            response = jsonConverter.createOKJSONResponse("Resources copied successfully.");
        }
        catch (Exception e) {
            response = jsonConverter.createErrorJSONResponse(this.getErrorMessage(e));
            this.log.debug((Object)"SEARCH_ERROR: Can't copy resource.", (Throwable)e);
        }
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)response.toString());
        return this.success();
    }

    public Event move(RequestContext context) throws Exception {
        JSONObject response;
        JSONConverter jsonConverter = this.getConverter(context);
        try {
            Set<String> selectedResources = jsonConverter.jsonStringArrayToSet(this.getParameter(context, "selectedResources"));
            String folder = this.getParameter(context, "destFolderUri");
            this.resourceService.move(selectedResources, folder);
            response = jsonConverter.createOKJSONResponse("Resources moved successfully.");
        }
        catch (Exception e) {
            response = jsonConverter.createErrorJSONResponse(this.getErrorMessage(e));
            this.log.debug((Object)"SEARCH_ERROR: Can't move resource.", (Throwable)e);
        }
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)response.toString());
        return this.success();
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    protected ExecutionContext exContext(RequestContext context) {
        TimeZone tz = JasperServerUtil.getTimezone((RequestContext)context);
        Locale loc = LocaleContextHolder.getLocale();
        return JasperServerUtil.getExecutionContext((Locale)loc, (TimeZone)tz);
    }
}

