/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.buildomatic.sql.ant;

import com.jaspersoft.buildomatic.sql.ant.AdvancedSQLExec;
import com.jaspersoft.buildomatic.sql.ant.ReflectionUtils;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.tools.ant.taskdefs.SQLExec;

public class SelectSQLExec
extends AdvancedSQLExec {
    private String selectRowCountProperty;
    private boolean selected = false;
    private String onErrorCopy = "abort";

    public void setSelectRowCountProperty(String selectRowCountProperty) {
        this.selectRowCountProperty = selectRowCountProperty;
    }

    public void setOnerror(SQLExec.OnError action) {
        super.setOnerror(action);
        this.onErrorCopy = action.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execSQL(String sql, PrintStream out) throws SQLException {
        if ("".equals(sql.trim())) {
            return;
        }
        if (this.selected) {
            return;
        }
        ResultSet resultSet = null;
        try {
            this.setTotalSql(this.getTotalSql() + 1);
            this.log("SQL: " + sql, 3);
            resultSet = this.getStatement().executeQuery(sql);
            int rowCount = 0;
            while (resultSet.next()) {
                ++rowCount;
            }
            this.log(rowCount + " rows returned", 3);
            this.setProperty(this.selectRowCountProperty, String.valueOf(rowCount));
            this.setGoodSql(this.getGoodSql() + 1);
            this.selected = true;
        }
        catch (SQLException e) {
            this.log("Failed to execute: " + sql, 0);
            this.setErrorProperty();
            if (!this.onErrorCopy.equals("abort")) {
                this.log(e.toString(), 0);
            }
            if (!this.onErrorCopy.equals("continue")) {
                throw e;
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    protected int getTotalSql() {
        return (Integer)ReflectionUtils.getFieldValue(ReflectionUtils.findField(SQLExec.class, "totalSql"), (Object)this);
    }

    protected void setTotalSql(int totalSql) {
        ReflectionUtils.setFieldValue(ReflectionUtils.findField(SQLExec.class, "totalSql"), (Object)this, totalSql);
    }

    protected int getGoodSql() {
        return (Integer)ReflectionUtils.getFieldValue(ReflectionUtils.findField(SQLExec.class, "goodSql"), (Object)this);
    }

    protected void setGoodSql(int goodSql) {
        ReflectionUtils.setFieldValue(ReflectionUtils.findField(SQLExec.class, "goodSql"), (Object)this, goodSql);
    }
}

