/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.buildomatic.sql.ant;

import com.jaspersoft.jasperserver.crypto.EncryptionEngine;
import com.jaspersoft.jasperserver.crypto.KeystoreManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Key;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.JDBCTask;
import org.apache.tools.ant.taskdefs.SQLExec;

public class AdvancedSQLExec
extends SQLExec {
    public static final String DEFAULT_ENC_BLOCK_SIZE = "16";
    public static final String DEFAULT_ENC_MODE = "AES/CBC/PKCS5Padding";
    private boolean failOnConnectionError = true;
    private String connectionErrorOccurredProperty;
    private String errorSqlStateCodeProperty;
    private String errorNativeCodeProperty;
    private String errorMessageProperty;
    private Connection connection;

    public void execute() throws BuildException {
        if (this.getConnection() == null) {
            return;
        }
        super.execute();
    }

    public boolean isFailOnConnectionError() {
        return this.failOnConnectionError;
    }

    public void setFailOnConnectionError(boolean failOnConnectionError) {
        this.failOnConnectionError = failOnConnectionError;
    }

    public void setConnectionErrorOccurredProperty(String connectionErrorOccurredProperty) {
        this.connectionErrorOccurredProperty = connectionErrorOccurredProperty;
    }

    public void setErrorSqlStateCodeProperty(String errorSqlStateCodeProperty) {
        this.errorSqlStateCodeProperty = errorSqlStateCodeProperty;
    }

    public void setErrorNativeCodeProperty(String errorNativeCodeProperty) {
        this.errorNativeCodeProperty = errorNativeCodeProperty;
    }

    public void setErrorMessageProperty(String errorMessageProperty) {
        this.errorMessageProperty = errorMessageProperty;
    }

    protected Connection getConnection() {
        if (this.connection == null) {
            this.connection = this.establishConnection();
            if (!this.isValidRdbms(this.connection)) {
                this.connection = null;
            }
        }
        return this.connection;
    }

    private Connection establishConnection() throws BuildException {
        if (this.getUserId() == null) {
            throw new BuildException("UserId attribute must be set!", this.getLocation());
        }
        if (this.getPassword() == null) {
            throw new BuildException("Password attribute must be set!", this.getLocation());
        }
        if (this.getUrl() == null) {
            throw new BuildException("Url attribute must be set!", this.getLocation());
        }
        try {
            this.log("connecting to " + this.getUrl(), 3);
            Properties info = new Properties();
            info.put("user", this.getUserId());
            String passwd = this.getPassword();
            if (EncryptionEngine.isEncrypted((String)passwd)) {
                KeystoreManager ksManager = KeystoreManager.getInstance();
                passwd = EncryptionEngine.decrypt((Key)ksManager.getBuildKey(), (String)passwd);
            }
            info.put("password", passwd);
            Connection conn = this.callGetDriver().connect(this.getUrl(), info);
            if (conn == null) {
                throw new SQLException("No suitable Driver for " + this.getUrl());
            }
            conn.setAutoCommit(this.isAutocommit());
            return conn;
        }
        catch (SQLException e) {
            if (!this.isFailOnConnectionError()) {
                this.log("Failed to connect: " + e.getMessage(), 1);
                this.updatePropertiesFromSQLException(e);
                return null;
            }
            throw new BuildException((Throwable)e, this.getLocation());
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    private void updatePropertiesFromSQLException(SQLException exception) {
        this.setProperty(this.connectionErrorOccurredProperty, "true");
        this.setProperty(this.errorSqlStateCodeProperty, exception.getSQLState());
        this.setProperty(this.errorNativeCodeProperty, String.valueOf(exception.getErrorCode()));
        this.setProperty(this.errorMessageProperty, exception.getMessage());
    }

    protected void setProperty(String name, String value) {
        if (name != null) {
            this.getProject().setNewProperty(name, value);
        }
    }

    private Driver callGetDriver() {
        try {
            Method getDriverMethod = JDBCTask.class.getDeclaredMethod("getDriver", new Class[0]);
            getDriverMethod.setAccessible(true);
            return (Driver)getDriverMethod.invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new BuildException("Method getDriver() not found in Ant task class hierarchy", (Throwable)e, this.getLocation());
        }
        catch (IllegalAccessException e) {
            throw new BuildException("Illegal access of getDriver() method", (Throwable)e, this.getLocation());
        }
        catch (InvocationTargetException e) {
            throw new BuildException("Error invoking getDriver() method", (Throwable)e, this.getLocation());
        }
    }
}

