/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.hibernate;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.lob.SerializableBlob;
import org.hibernate.type.BlobType;

public class ByteWrappingBlobType
extends BlobType {
    public static Logger log = Logger.getLogger(ByteWrappingBlobType.class);
    public static final String MAP_BLOBS_TO_BINARY_TYPE = "mapBlobsToBinaryType";

    public void set(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        String mapProp = session.getFactory().getDialect().getDefaultProperties().getProperty(MAP_BLOBS_TO_BINARY_TYPE);
        boolean mapBlobToStreams = String.valueOf(true).equals(mapProp);
        if (value == null) {
            st.setNull(index, mapBlobToStreams ? -2 : 2004);
        } else {
            Blob blob = (Blob)value;
            if (mapBlobToStreams) {
                st.setBinaryStream(index, blob.getBinaryStream(), (int)blob.length());
            } else {
                super.set(st, value, index, session);
            }
        }
    }

    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        Object value = rs.getObject(name);
        if (rs.wasNull()) {
            return null;
        }
        if (value instanceof Blob) {
            log.debug((Object)("getting blob for " + name));
            return new SerializableBlob((Blob)value);
        }
        if (value instanceof byte[]) {
            log.debug((Object)("getting byte[" + ((byte[])value).length + "] for " + name));
            return Hibernate.createBlob((byte[])((byte[])value));
        }
        if (value instanceof InputStream) {
            try {
                log.debug((Object)("getting input stream for " + name));
                return Hibernate.createBlob((InputStream)((InputStream)value));
            }
            catch (Exception e) {
                throw new HibernateException("exception creating blob from input stream", (Throwable)e);
            }
        }
        throw new HibernateException("I don't know how to map the type " + value.getClass().getName() + " to a blob");
    }
}

