/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.types.date;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.types.date.AbstractDateRange;
import net.sf.jasperreports.types.date.CalendarUnit;
import net.sf.jasperreports.types.date.DateRangeExpression;
import net.sf.jasperreports.types.date.InvalidDateRangeExpressionException;

public class RelativeDateRange
extends AbstractDateRange
implements DateRangeExpression {
    private static final long serialVersionUID = 10200L;
    public static final String DATE_RANGE_REGEXP = "^(DAY|WEEK|MONTH|QUARTER|SEMI|YEAR)([\\+|-][\\d]{1,9})?$";
    public static final int DEFAULT_WEEK_START_DAY = 2;
    public static final String WEEK_START_DAY_KEY = "week.start.day";
    public static final String PROPERTIES_FILE_NAME = "relativedate.properties";
    private static final Pattern PATTERN = Pattern.compile("^(DAY|WEEK|MONTH|QUARTER|SEMI|YEAR)([\\+|-][\\d]{1,9})?$");
    private static Properties props;
    private CalendarUnit calendarUnit;
    private Integer number;
    private Integer weekStart;

    public RelativeDateRange(String expression) {
        this(expression, null, null);
    }

    public RelativeDateRange(String expression, TimeZone timeZone, Integer weekStart) {
        super(expression, timeZone);
        this.weekStart = weekStart;
        this.validateExpression(expression);
        this.parse();
    }

    protected Pattern getPattern() {
        return PATTERN;
    }

    @Override
    protected void validateExpression(String expression) throws InvalidDateRangeExpressionException {
        super.validateExpression(expression);
        Matcher matcher = this.getPattern().matcher(expression);
        if (!matcher.matches()) {
            throw new InvalidDateRangeExpressionException(expression);
        }
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    private void parse() {
        Matcher matcher = this.getPattern().matcher(this.getExpression());
        if (matcher.find()) {
            this.calendarUnit = CalendarUnit.fromValue(matcher.group(1));
            String numberAsString = matcher.group(2);
            this.number = numberAsString != null ? Integer.valueOf(Integer.parseInt(numberAsString.replaceAll("\\+", ""))) : Integer.valueOf(0);
        } else {
            throw new InvalidDateRangeExpressionException(this.getExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected int getWeekStart() {
        if (this.weekStart != null) return this.weekStart;
        if (this.getProperties() == null) {
            InputStream is;
            Class<RelativeDateRange> clazz = RelativeDateRange.class;
            // MONITORENTER : net.sf.jasperreports.types.date.RelativeDateRange.class
            if (this.getProperties() == null && (is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getPropertiesFileName())) != null) {
                this.setProperties(new Properties());
                try {
                    this.getProperties().load(is);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // MONITOREXIT : clazz
        }
        if (this.getProperties() != null) {
            try {
                this.weekStart = Integer.parseInt(this.getProperties().getProperty(WEEK_START_DAY_KEY));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.weekStart != null) return this.weekStart;
        this.weekStart = 2;
        return this.weekStart;
    }

    protected String getPropertiesFileName() {
        return PROPERTIES_FILE_NAME;
    }

    protected Date getCurrentDate() {
        return new Date();
    }

    protected void setProperties(Properties props) {
        RelativeDateRange.props = props;
    }

    protected Properties getProperties() {
        return props;
    }

    @Override
    public Date getStart() {
        Calendar calendar = this.getCalendar();
        switch (this.calendarUnit) {
            case DAY: {
                calendar.add(6, this.number);
                break;
            }
            case WEEK: {
                calendar.add(6, -1 * this.getDaysToWeekStart(calendar));
                calendar.add(3, this.number);
                break;
            }
            case MONTH: {
                calendar.set(5, 1);
                calendar.add(2, this.number);
                break;
            }
            case QUARTER: {
                calendar.set(5, 1);
                calendar.add(2, -1 * this.getMonthesToQuarterStart(calendar));
                calendar.add(2, this.number * 3);
                break;
            }
            case SEMI: {
                calendar.set(5, 1);
                calendar.add(2, -1 * this.getMonthesToSemiStart(calendar));
                calendar.add(2, this.number * 6);
                break;
            }
            case YEAR: {
                calendar.set(5, 1);
                calendar.set(2, 0);
                calendar.add(1, this.number);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return calendar.getTime();
    }

    @Override
    public Date getEnd() {
        Calendar calendar = this.getCalendar();
        switch (this.calendarUnit) {
            case DAY: {
                calendar.add(6, this.number);
                break;
            }
            case WEEK: {
                calendar.add(6, this.getDaysToWeekEnd(calendar));
                calendar.add(3, this.number);
                break;
            }
            case MONTH: {
                calendar.add(2, this.number);
                calendar.set(5, calendar.getActualMaximum(5));
                break;
            }
            case QUARTER: {
                calendar.set(5, 1);
                calendar.add(2, this.getMonthesToQuarterEnd(calendar));
                calendar.add(2, this.number * 3);
                calendar.set(5, calendar.getActualMaximum(5));
                break;
            }
            case SEMI: {
                calendar.set(5, 1);
                calendar.add(2, this.getMonthesToSemiEnd(calendar));
                calendar.add(2, this.number * 6);
                calendar.set(5, calendar.getActualMaximum(5));
                break;
            }
            case YEAR: {
                calendar.set(5, 1);
                calendar.set(2, 0);
                calendar.add(1, this.number);
                calendar.set(2, calendar.getActualMaximum(2));
                calendar.set(5, calendar.getActualMaximum(5));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    protected Calendar getCalendar() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this.getCurrentDate());
        if (this.timeZone != null) {
            ((Calendar)calendar).setTimeZone(this.timeZone);
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private int getDaysToWeekStart(Calendar cal) {
        int dayOfWeek = cal.get(7);
        if (dayOfWeek == 1 && this.getWeekStart() == 2) {
            return 6;
        }
        return dayOfWeek - this.getWeekStart();
    }

    private int getDaysToWeekEnd(Calendar cal) {
        return 7 - (this.getDaysToWeekStart(cal) + 1);
    }

    private int getMonthesToQuarterStart(Calendar cal) {
        return cal.get(2) % 3;
    }

    private int getMonthesToQuarterEnd(Calendar cal) {
        return 3 - (this.getMonthesToQuarterStart(cal) + 1);
    }

    private int getMonthesToSemiStart(Calendar cal) {
        return cal.get(2) % 6;
    }

    private int getMonthesToSemiEnd(Calendar cal) {
        return 6 - (this.getMonthesToSemiStart(cal) + 1);
    }
}

